"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _lodashObjectMerge = require("lodash/object/merge");

var _lodashObjectMerge2 = _interopRequireDefault(_lodashObjectMerge);

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _radium = require("radium");

var _radium2 = _interopRequireDefault(_radium);

var _victoryLabel = require("victory-label");

var _victoryUtil = require("victory-util");

var BarLabel = (function (_React$Component) {
  _inherits(BarLabel, _React$Component);

  function BarLabel() {
    _classCallCheck(this, _BarLabel);

    _get(Object.getPrototypeOf(_BarLabel.prototype), "constructor", this).apply(this, arguments);
  }

  _createClass(BarLabel, [{
    key: "getLabelAnchors",
    value: function getLabelAnchors(props) {
      var sign = props.datum.y >= 0 ? 1 : -1;
      if (!props.horizontal) {
        return {
          vertical: sign >= 0 ? "end" : "start",
          text: "middle"
        };
      } else {
        return {
          vertical: "middle",
          text: sign >= 0 ? "start" : "end"
        };
      }
    }
  }, {
    key: "getlabelPadding",
    value: function getlabelPadding(props, style) {
      return {
        x: props.horizontal ? style.padding : 0,
        y: props.horizontal ? 0 : style.padding
      };
    }
  }, {
    key: "renderLabelComponent",
    value: function renderLabelComponent(props, position, anchors) {
      var component = props.labelComponent;
      var baseStyle = (0, _lodashObjectMerge2["default"])({ padding: 0 }, props.style, component.props.style);
      var style = _victoryUtil.Chart.evaluateStyle(baseStyle, props.datum);
      var padding = this.getlabelPadding(props, style);
      var children = component.props.children || props.labelText;
      var newProps = {
        x: component.props.x || position.x + padding.x,
        y: component.props.y || position.y - padding.y,
        data: props.datum, // Pass data for custom label component to access - todo: rename to datum
        textAnchor: component.props.textAnchor || anchors.text,
        verticalAnchor: component.props.verticalAnchor || anchors.vertical,
        style: style
      };
      return _react2["default"].cloneElement(component, newProps, children);
    }
  }, {
    key: "renderVictoryLabel",
    value: function renderVictoryLabel(props, position, anchors) {
      var baseStyle = (0, _lodashObjectMerge2["default"])({ padding: 0 }, props.style);
      var style = _victoryUtil.Chart.evaluateStyle(baseStyle, props.datum);
      var padding = this.getlabelPadding(props, style);
      return _react2["default"].createElement(
        _victoryLabel.VictoryLabel,
        {
          x: position.x + padding.x,
          y: position.y - padding.y,
          data: props.datum, // todo: rename to datum
          textAnchor: anchors.text,
          verticalAnchor: anchors.vertical,
          style: style
        },
        props.labelText
      );
    }
  }, {
    key: "renderLabel",
    value: function renderLabel(props) {
      var anchors = this.getLabelAnchors(props);
      var position = {
        x: props.horizontal ? props.position.dependent1 : props.position.independent,
        y: props.horizontal ? props.position.independent : props.position.dependent1
      };
      return props.labelComponent ? this.renderLabelComponent(props, position, anchors) : this.renderVictoryLabel(props, position, anchors);
    }
  }, {
    key: "render",
    value: function render() {
      return _react2["default"].createElement(
        "g",
        null,
        this.renderLabel(this.props)
      );
    }
  }], [{
    key: "propTypes",
    value: {
      position: _react.PropTypes.object,
      horizontal: _react.PropTypes.bool,
      style: _react.PropTypes.object,
      datum: _react.PropTypes.object,
      labelText: _react.PropTypes.string,
      labelComponent: _react.PropTypes.any
    },
    enumerable: true
  }]);

  var _BarLabel = BarLabel;
  BarLabel = (0, _radium2["default"])(BarLabel) || BarLabel;
  return BarLabel;
})(_react2["default"].Component);

exports["default"] = BarLabel;
module.exports = exports["default"];