"use strict";

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i]; return arr2; } else { return Array.from(arr); } }

var _lodashArrayFlatten = require("lodash/array/flatten");

var _lodashArrayFlatten2 = _interopRequireDefault(_lodashArrayFlatten);

var _lodashCollectionIncludes = require("lodash/collection/includes");

var _lodashCollectionIncludes2 = _interopRequireDefault(_lodashCollectionIncludes);

var _lodashLangIsEmpty = require("lodash/lang/isEmpty");

var _lodashLangIsEmpty2 = _interopRequireDefault(_lodashLangIsEmpty);

var _lodashLangIsUndefined = require("lodash/lang/isUndefined");

var _lodashLangIsUndefined2 = _interopRequireDefault(_lodashLangIsUndefined);

var _lodashArrayZipObject = require("lodash/array/zipObject");

var _lodashArrayZipObject2 = _interopRequireDefault(_lodashArrayZipObject);

var _victoryUtil = require("victory-util");

module.exports = {
  // Domain Helpers
  getDomain: function getDomain(props, axis) {
    var domain = _victoryUtil.Domain.getDomainFromProps(props, axis) || this.getDomainFromGroupedData(props, axis);
    return _victoryUtil.Domain.padDomain(domain, axis);
  },

  getDomainFromCategories: function getDomainFromCategories(props, axis) {
    if (axis !== "x" || !props.categories) {
      return undefined;
    }
    var categories = (0, _lodashArrayFlatten2["default"])(props.categories);
    var stringArray = _victoryUtil.Collection.containsStrings(categories) ? _victoryUtil.Data.getStringsFromCategories(props, axis) : [];
    var stringMap = (0, _lodashLangIsEmpty2["default"])(stringArray) ? null : (0, _lodashArrayZipObject2["default"])(stringArray.map(function (string, index) {
      return [string, index + 1];
    }));
    var categoryValues = stringMap ? categories.map(function (value) {
      return stringMap[value];
    }) : categories;
    return [Math.min.apply(Math, _toConsumableArray(categoryValues)), Math.max.apply(Math, _toConsumableArray(categoryValues))];
  },

  getDomainFromData: function getDomainFromData(datasets, axis) {
    var ensureZero = function ensureZero(domain) {
      return [Math.min.apply(Math, _toConsumableArray(domain).concat([0])), Math.max.apply(Math, _toConsumableArray(domain).concat([0]))];
    };
    var axisData = (0, _lodashArrayFlatten2["default"])(datasets).map(function (data) {
      return data[axis];
    });
    var globalMin = Math.min.apply(Math, _toConsumableArray(axisData));
    var globalMax = Math.max.apply(Math, _toConsumableArray(axisData));
    var domain = [globalMin, globalMax];
    return axis === "y" ? ensureZero(domain) : domain;
  },

  getDomainFromGroupedData: function getDomainFromGroupedData(props, axis) {
    if (axis === "x" && props.categories) {
      return this.getDomainFromCategories(props, axis);
    }
    // find the global min and max
    var rawDatasets = props.stacked || this.shouldGroup(props) ? props.data : [props.data];
    var datasets = _victoryUtil.Data.formatDatasets(rawDatasets, props).map(function (dataset) {
      return dataset.data;
    });
    var globalDomain = this.getDomainFromData(datasets, axis);

    // find the cumulative max for stacked chart types
    var cumulativeData = this.isStacked(props, axis) ? this.getCumulativeData(datasets, axis) : [];

    var cumulativeMaxArray = cumulativeData.map(function (dataset) {
      return dataset.reduce(function (memo, val) {
        return val > 0 ? memo + val : memo;
      }, 0);
    });

    var cumulativeMinArray = cumulativeData.map(function (dataset) {
      return dataset.reduce(function (memo, val) {
        return val < 0 ? memo + val : memo;
      }, 0);
    });

    var cumulativeMin = Math.min.apply(Math, _toConsumableArray(cumulativeMinArray));
    // use greatest min / max
    var domainMin = cumulativeMin < 0 ? cumulativeMin : Math.min.apply(Math, _toConsumableArray(globalDomain));
    var domainMax = Math.max.apply(Math, _toConsumableArray(globalDomain).concat(_toConsumableArray(cumulativeMaxArray)));
    // TODO: is this the correct behavior, or should we just error. How do we
    // handle charts with just one data point?
    if (domainMin === domainMax) {
      var adjustedMax = domainMax === 0 ? 1 : domainMax;
      return [0, adjustedMax];
    }
    return [domainMin, domainMax];
  },

  shouldGroup: function shouldGroup(props) {
    // automatically create grouped bars if data is array of arrays
    // and x/y accessors are the default "x" and "y" keys,
    return !props.stacked && (props.grouped || (0, _lodashLangIsUndefined2["default"])(props.grouped) && _victoryUtil.Collection.isArrayOfArrays(props.data) && props.x === "x" && props.y === "y");
  },

  isStacked: function isStacked(props, axis) {
    // checks whether grouped data is stacked,
    // whether there are multiple datasets to stack
    // and whether the current axis is y (dependent)
    // TODO: check assumptions for inverted axis charts

    return props.stacked === true && _victoryUtil.Collection.isArrayOfArrays(props.data) && axis === "y";
  },

  getCumulativeData: function getCumulativeData(datasets, axis) {
    var categories = [];
    var axisValues = [];
    datasets.forEach(function (dataset) {
      dataset.forEach(function (data) {
        if (data.category !== undefined && !(0, _lodashCollectionIncludes2["default"])(categories, data.category)) {
          categories.push(data.category);
        } else if (!(0, _lodashCollectionIncludes2["default"])(axisValues, data[axis])) {
          axisValues.push(data[axis]);
        }
      });
    });

    var _dataByCategory = function _dataByCategory() {
      return categories.map(function (value) {
        var categoryData = datasets.filter(function (data) {
          return data.category === value;
        });
        return (0, _lodashArrayFlatten2["default"])(categoryData.map(function (data) {
          return data[axis];
        }));
      });
    };

    var _dataByIndex = function _dataByIndex() {
      return axisValues.map(function (value, index) {
        return datasets.map(function (data) {
          return data[index] && data[index][axis];
        });
      });
    };

    return (0, _lodashLangIsEmpty2["default"])(categories) ? _dataByIndex() : _dataByCategory();
  }
};