"use strict";

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i]; return arr2; } else { return Array.from(arr); } }

var _lodashArrayFlatten = require("lodash/array/flatten");

var _lodashArrayFlatten2 = _interopRequireDefault(_lodashArrayFlatten);

var _lodashArrayTake = require("lodash/array/take");

var _lodashArrayTake2 = _interopRequireDefault(_lodashArrayTake);

var _lodashArrayUniq = require("lodash/array/uniq");

var _lodashArrayUniq2 = _interopRequireDefault(_lodashArrayUniq);

var _lodashLangIsDate = require("lodash/lang/isDate");

var _lodashLangIsDate2 = _interopRequireDefault(_lodashLangIsDate);

var _lodashObjectMerge = require("lodash/object/merge");

var _lodashObjectMerge2 = _interopRequireDefault(_lodashObjectMerge);

var _lodashObjectOmit = require("lodash/object/omit");

var _lodashObjectOmit2 = _interopRequireDefault(_lodashObjectOmit);

module.exports = {
  // Layout Helpers
  getBarPosition: function getBarPosition(datum, index, calculatedProps) {
    var scale = calculatedProps.scale;
    var stacked = calculatedProps.stacked;
    var categories = calculatedProps.categories;

    var yOffset = stacked ? this.getYOffset(datum, index, calculatedProps) : 0;
    var y0 = yOffset;
    var y1 = yOffset + datum.y;
    var x = stacked && !categories ? datum.x : this.adjustX(datum, index.seriesIndex, calculatedProps);
    var formatValue = function formatValue(value, axis) {
      return (0, _lodashLangIsDate2["default"])(datum[axis]) ? new Date(value) : value;
    };
    return {
      independent: scale.x(formatValue(x, "x")),
      dependent0: scale.y(formatValue(y0, "y")),
      dependent1: scale.y(formatValue(y1, "y"))
    };
  },

  getYOffset: function getYOffset(datum, index, calculatedProps) {
    var datasets = calculatedProps.datasets;

    if (index.seriesIndex === 0) {
      return 0;
    }
    var y = datum.y;
    var previousDataSets = (0, _lodashArrayTake2["default"])(datasets, index.seriesIndex);
    var previousBars = (0, _lodashArrayFlatten2["default"])(previousDataSets.map(function (dataset) {
      return dataset.data.filter(function (previousDatum) {
        return previousDatum.x === datum.x;
      }).map(function (previousDatum) {
        return previousDatum.y || 0;
      });
    }));
    return previousBars.reduce(function (memo, barValue) {
      var sameSign = y < 0 && barValue < 0 || y >= 0 && barValue >= 0;
      return sameSign ? memo + barValue : memo;
    }, 0);
  },

  adjustX: function adjustX(datum, index, calculatedProps) {
    var stacked = calculatedProps.stacked;
    var categories = calculatedProps.categories;

    var style = calculatedProps.style.data;
    var x = datum.x;
    var datasets = calculatedProps.datasets;
    var center = datasets.length % 2 === 0 ? datasets.length / 2 : (datasets.length - 1) / 2;
    var centerOffset = index - center;
    var totalWidth = this.pixelsToValue(style.padding, "x", calculatedProps) + this.pixelsToValue(style.width, "x", calculatedProps);
    if (datum.category !== undefined) {
      // if this is category data, shift x to the center of its category
      var rangeBand = categories[datum.category];
      var bandCenter = (Math.max.apply(Math, _toConsumableArray(rangeBand)) + Math.min.apply(Math, _toConsumableArray(rangeBand))) / 2;
      return stacked ? bandCenter : bandCenter + centerOffset * totalWidth;
    }
    return stacked ? x : x + centerOffset * totalWidth;
  },

  pixelsToValue: function pixelsToValue(pixels, axis, calculatedProps) {
    if (pixels === 0) {
      return 0;
    }
    var domain = calculatedProps.domain[axis];
    var range = calculatedProps.range[axis];
    var domainExtent = Math.max.apply(Math, _toConsumableArray(domain)) - Math.min.apply(Math, _toConsumableArray(domain));
    var rangeExtent = Math.max.apply(Math, _toConsumableArray(range)) - Math.min.apply(Math, _toConsumableArray(range));
    return domainExtent / rangeExtent * pixels;
  },

  // Label Helpers
  shouldPlotLabel: function shouldPlotLabel(index, props, datasets) {
    var isCenter = Math.floor(datasets.length / 2) === index;
    var isLast = datasets.length === index + 1;
    var stacked = props.stacked;
    var plotGroupLabel = stacked && isLast || !stacked && isCenter;
    var labelExists = props.labels || props.labelComponents ? true : false;
    return plotGroupLabel && labelExists;
  },

  getLabelIndex: function getLabelIndex(datum, calculatedProps) {
    var datasets = calculatedProps.datasets;
    var stringMap = calculatedProps.stringMap;

    if (datum.category !== undefined) {
      return datum.category;
    } else if (stringMap.x) {
      return datum.x - 1;
    } else {
      var allX = datasets.map(function (dataset) {
        return dataset.data.map(function (d) {
          return d.x;
        });
      });
      var uniqueX = (0, _lodashArrayUniq2["default"])((0, _lodashArrayFlatten2["default"])(allX));
      return uniqueX.sort().findIndex(function (x) {
        return x === datum.x;
      });
    }
  },

  getBarStyle: function getBarStyle(datum, dataset, baseStyle) {
    var styleData = (0, _lodashObjectOmit2["default"])(datum, ["xName", "yName", "x", "y", "label", "category"]);
    return (0, _lodashObjectMerge2["default"])({}, baseStyle.data, (0, _lodashObjectOmit2["default"])(dataset.attrs, "name"), styleData);
  }
};