"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _radium = require("radium");

var _radium2 = _interopRequireDefault(_radium);

var _victoryUtil = require("victory-util");

var Bar = (function (_React$Component) {
  _inherits(Bar, _React$Component);

  function Bar() {
    _classCallCheck(this, _Bar);

    _get(Object.getPrototypeOf(_Bar.prototype), "constructor", this).apply(this, arguments);
  }

  _createClass(Bar, [{
    key: "getVerticalBarPath",
    value: function getVerticalBarPath(position, width) {
      var independent = position.independent;
      var dependent0 = position.dependent0;
      var dependent1 = position.dependent1;

      var size = width / 2;
      return "M " + (independent - size) + ", " + dependent0 + "\n      L " + (independent - size) + ", " + dependent1 + "\n      L " + (independent + size) + ", " + dependent1 + "\n      L " + (independent + size) + ", " + dependent0 + "\n      L " + (independent - size) + ", " + dependent0;
    }
  }, {
    key: "getHorizontalBarPath",
    value: function getHorizontalBarPath(position, width) {
      var independent = position.independent;
      var dependent0 = position.dependent0;
      var dependent1 = position.dependent1;

      var size = width / 2;
      return "M " + dependent0 + ", " + (independent - size) + "\n      L " + dependent0 + ", " + (independent + size) + "\n      L " + dependent1 + ", " + (independent + size) + "\n      L " + dependent1 + ", " + (independent - size) + "\n      L " + dependent0 + ", " + (independent - size);
    }
  }, {
    key: "getBarPath",
    value: function getBarPath(position, width) {
      return this.props.horizontal ? this.getHorizontalBarPath(position, width) : this.getVerticalBarPath(position, width);
    }
  }, {
    key: "renderBar",
    value: function renderBar(props) {
      var style = _victoryUtil.Chart.evaluateStyle(props.style, props.datum);
      // TODO better bar width calculation
      var barWidth = style.width;
      var path = props.position.independent ? this.getBarPath(props.position, barWidth) : undefined;
      return _react2["default"].createElement("path", {
        d: path,
        style: style,
        shapeRendering: "optimizeSpeed"
      });
    }
  }, {
    key: "render",
    value: function render() {
      return _react2["default"].createElement(
        "g",
        null,
        this.renderBar(this.props)
      );
    }
  }], [{
    key: "propTypes",
    value: {
      position: _react.PropTypes.object,
      horizontal: _react.PropTypes.bool,
      style: _react.PropTypes.object,
      datum: _react.PropTypes.object
    },
    enumerable: true
  }]);

  var _Bar = Bar;
  Bar = (0, _radium2["default"])(Bar) || Bar;
  return Bar;
})(_react2["default"].Component);

exports["default"] = Bar;
module.exports = exports["default"];