"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _lodashObjectPick = require("lodash/object/pick");

var _lodashObjectPick2 = _interopRequireDefault(_lodashObjectPick);

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _radium = require("radium");

var _radium2 = _interopRequireDefault(_radium);

var _victoryUtil = require("victory-util");

var _victoryAnimation = require("victory-animation");

var _bar = require("./bar");

var _bar2 = _interopRequireDefault(_bar);

var _barLabel = require("./bar-label");

var _barLabel2 = _interopRequireDefault(_barLabel);

var _domainHelpers = require("../domain-helpers");

var _domainHelpers2 = _interopRequireDefault(_domainHelpers);

var _layoutHelpers = require("../layout-helpers");

var _layoutHelpers2 = _interopRequireDefault(_layoutHelpers);

var defaultStyles = {
  data: {
    width: 8,
    padding: 6,
    stroke: "transparent",
    strokeWidth: 0,
    fill: "#756f6a",
    opacity: 1
  },
  labels: {
    fontSize: 12,
    padding: 4,
    fill: "black"
  }
};

var defaultData = [{ x: 1, y: 1 }, { x: 2, y: 2 }, { x: 3, y: 3 }, { x: 4, y: 4 }];

var VictoryBar = (function (_React$Component) {
  _inherits(VictoryBar, _React$Component);

  function VictoryBar() {
    _classCallCheck(this, _VictoryBar);

    _get(Object.getPrototypeOf(_VictoryBar.prototype), "constructor", this).apply(this, arguments);
  }

  _createClass(VictoryBar, [{
    key: "renderBars",
    value: function renderBars(dataset, seriesIndex, calculatedProps) {
      var _this = this;

      return dataset.data.map(function (datum, barIndex) {
        var index = { seriesIndex: seriesIndex, barIndex: barIndex };
        var position = _layoutHelpers2["default"].getBarPosition(datum, index, calculatedProps);
        var baseStyle = calculatedProps.style;
        var style = _layoutHelpers2["default"].getBarStyle(datum, dataset, baseStyle);
        var barComponent = _react2["default"].createElement(_bar2["default"], { key: "series-" + index + "-bar-" + barIndex,
          horizontal: _this.props.horizontal,
          style: style,
          position: position,
          datum: datum
        });
        var shouldPlotLabel = _layoutHelpers2["default"].shouldPlotLabel(seriesIndex, _this.props, calculatedProps.datasets);
        if (datum.label || shouldPlotLabel) {
          var labelIndex = _layoutHelpers2["default"].getLabelIndex(datum, calculatedProps);
          var labelText = _this.props.labels ? _this.props.labels[labelIndex] || _this.props.labels[0] : "";
          var labelComponent = _this.props.labelComponents ? _this.props.labelComponents[labelIndex] || _this.props.labelComponents[0] : undefined;
          return _react2["default"].createElement(
            "g",
            { key: "series-" + index + "-bar-" + barIndex },
            barComponent,
            _react2["default"].createElement(_barLabel2["default"], { key: "label-series-" + index + "-bar-" + barIndex,
              horizontal: _this.props.horizontal,
              style: baseStyle.labels,
              position: position,
              datum: datum,
              labelText: datum.label || labelText,
              labelComponent: labelComponent
            })
          );
        }
        return barComponent;
      });
    }
  }, {
    key: "renderData",
    value: function renderData(props, style) {
      var _this2 = this;

      var stacked = props.stacked;
      var categories = props.categories;

      var grouped = _domainHelpers2["default"].shouldGroup(props);
      var hasMultipleDatasets = grouped || stacked;
      var rawDatasets = hasMultipleDatasets ? props.data : [props.data];
      var datasets = _victoryUtil.Data.formatDatasets(rawDatasets, props);
      var stringMap = {
        x: _victoryUtil.Data.createStringMap(props, "x", hasMultipleDatasets),
        y: _victoryUtil.Data.createStringMap(props, "y", hasMultipleDatasets)
      };
      var padding = _victoryUtil.Chart.getPadding(props);
      var range = {
        x: _victoryUtil.Chart.getRange(props, "x"),
        y: _victoryUtil.Chart.getRange(props, "y")
      };
      var domain = {
        x: _domainHelpers2["default"].getDomain(props, "x"),
        y: _domainHelpers2["default"].getDomain(props, "y")
      };
      var scale = {
        x: _victoryUtil.Scale.getBaseScale(props, "x").domain(domain.x).range(range.x),
        y: _victoryUtil.Scale.getBaseScale(props, "y").domain(domain.y).range(range.y)
      };
      var calculatedProps = {
        categories: categories, datasets: datasets, domain: domain, padding: padding, range: range, scale: scale, grouped: grouped, stacked: stacked, stringMap: stringMap, style: style
      };
      return datasets.map(function (dataset, index) {
        return _this2.renderBars(dataset, index, calculatedProps);
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      // If animating, return a `VictoryAnimation` element that will create
      // a new `VictoryBar` with nearly identical props, except (1) tweened
      // and (2) `animate` set to null so we don't recurse forever.
      if (this.props.animate) {
        // Do less work by having `VictoryAnimation` tween only values that
        // make sense to tween. In the future, allow customization of animated
        // prop whitelist/blacklist?
        var animateData = (0, _lodashObjectPick2["default"])(this.props, ["data", "dataAttributes", "categories", "colorScale", "domain", "height", "padding", "style", "width"]);
        return _react2["default"].createElement(
          _victoryAnimation.VictoryAnimation,
          _extends({}, this.props.animate, { data: animateData }),
          function (props) {
            return _react2["default"].createElement(VictoryBar, _extends({}, _this3.props, props, { animate: null }));
          }
        );
      }
      var style = _victoryUtil.Chart.getStyles(this.props, defaultStyles);
      var group = _react2["default"].createElement(
        "g",
        { style: style.parent },
        this.renderData(this.props, style)
      );
      return this.props.standalone ? _react2["default"].createElement(
        "svg",
        { style: style.parent },
        group
      ) : group;
    }
  }], [{
    key: "role",
    value: "bar",
    enumerable: true
  }, {
    key: "propTypes",
    value: {
      /**
       * The animate prop specifies props for victory-animation to use. It this prop is
       * not given, the bar chart will not tween between changing data / style props.
       * Large datasets might animate slowly due to the inherent limits of svg rendering.
       * @examples {velocity: 0.02, onEnd: () => alert("done!")}
       */
      animate: _react.PropTypes.object,
      /**
       * The data prop specifies the data to be plotted. Data should be in the form of an array
       * of data points, or an array of arrays of data points for multiple datasets.
       * Each data point may be any format you wish (depending on the `x` and `y` accessor props),
       * but by default, an object with x and y properties is expected.
       * @examples [{x: 1, y: 2}, {x: 2, y: 3}], [[1, 2], [2, 3]],
       * [[{x: "a", y: 1}, {x: "b", y: 2}], [{x: "a", y: 2}, {x: "b", y: 3}]]
       */
      data: _react.PropTypes.array,
      /**
       * The dataAttributes prop describes how a data set should be styled.
       * This prop can be given as an object, or an array of objects. If this prop is
       * given as an array of objects, the properties of each object in the array will
       * be applied to the data points in the corresponding array of the data prop.
       * @examples {fill: "blue", opacity: 0.6}, [{fill: "red"}, {fill: "orange"}]
       */
      dataAttributes: _react.PropTypes.oneOfType([_react.PropTypes.object, _react.PropTypes.arrayOf(_react.PropTypes.object)]),
      /**
       * The categories prop specifies the categories for a bar chart. This prop should
       * be given as an array of string values, numeric values, or arrays. When this prop is
       * given as an array of arrays, the minimum and maximum values of the arrays define range bands,
       * allowing numeric data to be grouped into segments.
       * @examples ["dogs", "cats", "mice"], [[0, 5], [5, 10], [10, 15]]
       */
      categories: _victoryUtil.PropTypes.homogeneousArray,
      /**
       * The colorScale prop is an optional prop that defines the color scale the chart's bars
       * will be created on. This prop should be given as an array of CSS colors, or as a string
       * corresponding to one of the built in color scales. VictoryBar will automatically assign
       * values from this color scale to the bars unless colors are explicitly provided in the
       * `dataAttributes` prop.
       */
      colorScale: _react.PropTypes.oneOfType([_react.PropTypes.arrayOf(_react.PropTypes.string), _react.PropTypes.oneOf(["greyscale", "qualitative", "heatmap", "warm", "cool", "red", "green", "blue"])]),
      /**
       * The domain prop describes the range of values your bar chart will cover. This prop can be
       * given as a array of the minimum and maximum expected values for your bar chart,
       * or as an object that specifies separate arrays for x and y.
       * If this prop is not provided, a domain will be calculated from data, or other
       * available information.
       * @examples [-1, 1], {x: [0, 100], y: [0, 1]}
       */
      domain: _react.PropTypes.oneOfType([_victoryUtil.PropTypes.domain, _react.PropTypes.shape({
        x: _victoryUtil.PropTypes.domain,
        y: _victoryUtil.PropTypes.domain
      })]),
      /**
       * The domainPadding prop specifies a number of pixels of padding to add to the
       * beginning and end of a domain. This prop is useful for preventing 0 pixel bars,
       * and taking bar width into account.
       */
      domainPadding: _react.PropTypes.oneOfType([_react.PropTypes.shape({
        x: _victoryUtil.PropTypes.nonNegative,
        y: _victoryUtil.PropTypes.nonNegative
      }), _victoryUtil.PropTypes.nonNegative]),
      /**
       * The grouped prop determines whether the chart should consist of sets of grouped bars.
       * When this prop is set to true, the data prop *must* be an array of multiple data series
       * ie. not an array of data points, but an array of arrays of data points.  If data is
       * given as an array or arrays, and data accessor props have default values
       * (ie. x={"x"} y={"y"}), the grouped prop will default to true.
       */
      grouped: _react.PropTypes.bool,
      /**
       * The height props specifies the height of the chart container element in pixels
       */
      height: _victoryUtil.PropTypes.nonNegative,
      /**
       * The horizontal prop determines whether the bars will be laid vertically or
       * horizontally. The bars will be vertical if this prop is false or unspecified,
       * or horizontal if the prop is set to true.
       */
      horizontal: _react.PropTypes.bool,
      /**
       * The labels prop defines labels that will appear above each bar or
       * group of bars in your bar chart. This prop should be given as an array of values.
       * The number of elements in the label array should be equal to number of elements in
       * the categories array, or if categories is not defined, to the number of unique
       * x values in your data. Use this prop to add labels to individual bars, stacked bars,
       * and groups of bars.
       * @examples: ["spring", "summer", "fall", "winter"]
       */
      labels: _react.PropTypes.array,
      /**
       * The labelComponents prop takes in an array of entire, HTML-complete label components
       * which will be used to create labels for individual bars, stacked bars, or groups of
       * bars as appropriate.
       */
      labelComponents: _react.PropTypes.array,
      /**
       * The padding props specifies the amount of padding in number of pixels between
       * the edge of the chart and any rendered child components. This prop can be given
       * as a number or as an object with padding specified for top, bottom, left
       * and right.
       */
      padding: _react.PropTypes.oneOfType([_react.PropTypes.number, _react.PropTypes.shape({
        top: _react.PropTypes.number,
        bottom: _react.PropTypes.number,
        left: _react.PropTypes.number,
        right: _react.PropTypes.number
      })]),
      /**
       * The scale prop determines which scales your chart should use. This prop can be
       * given as a string specifying a supported scale ("linear", "time", "log", "sqrt"),
       * as a d3 scale function, or as an object with scales specified for x and y
       * @exampes d3Scale.time(), {x: "linear", y: "log"}
       */
      scale: _react.PropTypes.oneOfType([_victoryUtil.PropTypes.scale, _react.PropTypes.shape({
        x: _victoryUtil.PropTypes.scale,
        y: _victoryUtil.PropTypes.scale
      })]),
      /**
       * The stacked prop determines whether the chart should consist of stacked bars.
       * When this prop is set to true, the data prop *must* be an array of multiple data series
       * ie. not an array of data points, but an array of arrays of data points
       */
      stacked: _react.PropTypes.bool,
      /**
       * The standalone prop determines whether the component will render a standalone svg
       * or a <g> tag that will be included in an external svg. Set standalone to false to
       * compose VictoryBar with other components within an enclosing <svg> tag.
       */
      standalone: _react.PropTypes.bool,
      /**
       * The style prop specifies styles for your chart. VictoryBar relies on Radium,
       * so valid Radium style objects should work for this prop, however height, width, and margin
       * are used to calculate range, and need to be expressed as a number of pixels
       * @examples {data: {fill: "red", width: 8}, labels: {fontSize: 12}}
       */
      style: _react.PropTypes.shape({
        parent: _react.PropTypes.object,
        data: _react.PropTypes.object,
        labels: _react.PropTypes.object
      }),
      /**
       * The width prop specifies the width of the chart container element in pixels
       */
      width: _victoryUtil.PropTypes.nonNegative,
      /**
       * The x prop specifies how to access the X value of each data point.
       * If given as a function, it will be run on each data point, and returned value will be used.
       * If given as an integer, it will be used as an array index for array-type data points.
       * If given as a string, it will be used as a property key for object-type data points.
       * If given as an array of strings, or a string containing dots or brackets,
       * it will be used as a nested object property path (for details see Lodash docs for _.get).
       * If `null` or `undefined`, the data value will be used as is (identity function/pass-through).
       * @examples 0, 'x', 'x.value.nested.1.thing', 'x[2].also.nested', null, d => Math.sin(d)
       */
      x: _react.PropTypes.oneOfType([_react.PropTypes.func, _victoryUtil.PropTypes.allOfType([_victoryUtil.PropTypes.integer, _victoryUtil.PropTypes.nonNegative]), _react.PropTypes.string, _react.PropTypes.arrayOf(_react.PropTypes.string)]),
      /**
       * The y prop specifies how to access the Y value of each data point.
       * If given as a function, it will be run on each data point, and returned value will be used.
       * If given as an integer, it will be used as an array index for array-type data points.
       * If given as a string, it will be used as a property key for object-type data points.
       * If given as an array of strings, or a string containing dots or brackets,
       * it will be used as a nested object property path (for details see Lodash docs for _.get).
       * If `null` or `undefined`, the data value will be used as is (identity function/pass-through).
       * @examples 0, 'y', 'y.value.nested.1.thing', 'y[2].also.nested', null, d => Math.sin(d)
       */
      y: _react.PropTypes.oneOfType([_react.PropTypes.func, _victoryUtil.PropTypes.allOfType([_victoryUtil.PropTypes.integer, _victoryUtil.PropTypes.nonNegative]), _react.PropTypes.string, _react.PropTypes.arrayOf(_react.PropTypes.string)])
    },
    enumerable: true
  }, {
    key: "defaultProps",
    value: {
      data: defaultData,
      colorScale: "greyscale",
      height: 300,
      padding: 50,
      scale: "linear",
      stacked: false,
      standalone: true,
      width: 450,
      x: "x",
      y: "y"
    },
    enumerable: true
  }, {
    key: "getDomain",
    value: _domainHelpers2["default"].getDomain.bind(_domainHelpers2["default"]),
    enumerable: true
  }]);

  var _VictoryBar = VictoryBar;
  VictoryBar = (0, _radium2["default"])(VictoryBar) || VictoryBar;
  return VictoryBar;
})(_react2["default"].Component);

exports["default"] = VictoryBar;
module.exports = exports["default"];