"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _radium = require("radium");

var _radium2 = _interopRequireDefault(_radium);

var _victoryUtil = require("victory-util");

var _lodashObjectMerge = require("lodash/object/merge");

var _lodashObjectMerge2 = _interopRequireDefault(_lodashObjectMerge);

var defaultStyles = {
  stroke: "transparent",
  fill: "#756f6a",
  fontSize: 16,
  fontFamily: "Helvetica",
  backgroundColor: "#ccc"
};

var VictoryLabel = (function (_React$Component) {
  _inherits(VictoryLabel, _React$Component);

  function VictoryLabel() {
    _classCallCheck(this, _VictoryLabel);

    _get(Object.getPrototypeOf(_VictoryLabel.prototype), "constructor", this).apply(this, arguments);
  }

  _createClass(VictoryLabel, [{
    key: "getStyles",
    value: function getStyles(props) {
      var style = props.style ? (0, _lodashObjectMerge2["default"])({}, defaultStyles, props.style) : defaultStyles;
      return _victoryUtil.Chart.evaluateStyle(style);
    }
  }, {
    key: "getHeight",
    value: function getHeight(props, type) {
      var height = _victoryUtil.Chart.evaluateProp(props[type]);
      return typeof height === "number" ? height + "em" : height;
    }
  }, {
    key: "getContent",
    value: function getContent(props) {
      if (props.children) {
        var child = _victoryUtil.Chart.evaluateProp(props.children);
        return ("" + child).split("\n");
      }
      return [""];
    }
  }, {
    key: "getDy",
    value: function getDy(props, content, lineHeight) {
      var dy = props.dy ? _victoryUtil.Chart.evaluateProp(props.dy) : 0;
      var length = content.length;
      var capHeight = this.getHeight(props, "capHeight");
      var verticalAnchor = props.verticalAnchor ? _victoryUtil.Chart.evaluateProp(props.verticalAnchor) : "middle";
      switch (verticalAnchor) {
        case "end":
          return _victoryUtil.Style.calc(dy + " +  " + capHeight + " / 2 + (0.5 - " + length + ") * " + lineHeight);
        case "middle":
          return _victoryUtil.Style.calc(dy + " + " + capHeight + " / 2 + (0.5 - " + length + " / 2) * " + lineHeight);
        default:
          return _victoryUtil.Style.calc(dy + " + " + capHeight + " / 2 + " + lineHeight + " / 2");
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var lineHeight = this.getHeight(this.props, "lineHeight");
      var transform = this.props.transform && _victoryUtil.Style.toTransformString(_victoryUtil.Chart.evaluateProp(this.props.transform));
      var textAnchor = this.props.textAnchor ? _victoryUtil.Chart.evaluateProp(this.props.textAnchor) : "start";
      var content = this.getContent(this.props);
      var style = this.getStyles(this.props);
      var dx = this.props.dx ? _victoryUtil.Chart.evaluateProp(this.props.dx) : 0;
      var dy = this.getDy(this.props, content, lineHeight);
      return _react2["default"].createElement(
        "text",
        {
          x: this.props.x,
          y: this.props.y,
          dy: dy,
          dx: dx,
          textAnchor: textAnchor,
          transform: transform,
          style: style
        },
        content.map(function (line, i) {
          return _react2["default"].createElement(
            "tspan",
            { key: i, x: _this.props.x, dy: i ? lineHeight : undefined },
            line
          );
        })
      );
    }
  }], [{
    key: "propTypes",
    value: {
      /**
       * The capHeight prop defines a text metric for the font being used: the
       * expected height of capital letters. This is necessary because of SVG,
       * which (a) positions the *bottom* of the text at `y`, and (b) has no
       * notion of line height. The value should ideally use the same units as
       * `lineHeight` and `dy`, preferably ems. If given a unitless number, it
       * is assumed to be ems.
       */
      capHeight: _react.PropTypes.oneOfType([_react.PropTypes.string, _victoryUtil.PropTypes.nonNegative, _react.PropTypes.func]),
      /**
       * all Victory components will pass a data prop to their label component. This can
       * be used to calculate functional styles, and determine child text
       */
      data: _react.PropTypes.object,
      /**
       * The children of this component define the content of the label. This
       * makes using the component similar to normal HTML spans or labels.
       * Currently, only strings are supported.
       */
      children: _react.PropTypes.oneOfType([// TODO: Expand child support in future release
      _react.PropTypes.string, _react.PropTypes.number, _react.PropTypes.func]),
      /**
       * The lineHeight prop defines how much space a single line of text should
       * take up. Note that SVG has no notion of line-height, so the positioning
       * may differ slightly from what you would expect with CSS, but the result
       * is similar: a roughly equal amount of extra space is distributed above
       * and below the line of text. The value should ideally use the same units
       * as `capHeight` and `dy`, preferably ems. If given a unitless number, it
       * is assumed to be ems.
       */
      lineHeight: _react.PropTypes.oneOfType([_react.PropTypes.string, _victoryUtil.PropTypes.nonNegative, _react.PropTypes.func]),
      /**
       * The style prop applies CSS properties to the rendered `<text>` element.
       */
      style: _react.PropTypes.object,
      /**
       * The textAnchor prop defines how the text is horizontally positioned
       * relative to the given `x` and `y` coordinates.
       */
      textAnchor: _react.PropTypes.oneOfType([_react.PropTypes.oneOf(["start", "middle", "end", "inherit"]), _react.PropTypes.func]),
      /**
       * The verticalAnchor prop defines how the text is vertically positioned
       * relative to the given `x` and `y` coordinates.
       */
      verticalAnchor: _react.PropTypes.oneOfType([_react.PropTypes.oneOf(["start", "middle", "end"]), _react.PropTypes.func]),
      /**
       * The transform prop applies a transform to the rendered `<text>` element.
       * In addition to being a string, it can be an object containing transform
       * definitions for easier authoring.
       */
      transform: _react.PropTypes.oneOfType([_react.PropTypes.string, _react.PropTypes.object, _react.PropTypes.func]),
      /**
       * The x prop defines the x coordinate to use as a basis for horizontal
       * positioning.
       */
      x: _react.PropTypes.number,
      /**
       * The y prop defines the y coordinate to use as a basis for vertical
       * positioning.
       */
      y: _react.PropTypes.number,
      /**
       * The dx prop defines a horizontal shift from the `x` coordinate.
       */
      dx: _react.PropTypes.oneOfType([_react.PropTypes.number, _react.PropTypes.string, _react.PropTypes.func]),
      /**
       * The dy prop defines a vertical shift from the `y` coordinate. Since this
       * component already accounts for `capHeight`, `lineHeight`, and
       * `verticalAnchor`, this will usually not be necessary.
       */
      dy: _react.PropTypes.oneOfType([_react.PropTypes.number, _react.PropTypes.string, _react.PropTypes.func])
    },
    enumerable: true
  }, {
    key: "defaultProps",
    value: {
      capHeight: "0.71em", // Magic number from d3.
      lineHeight: 1
    },
    enumerable: true
  }]);

  var _VictoryLabel = VictoryLabel;
  VictoryLabel = (0, _radium2["default"])(VictoryLabel) || VictoryLabel;
  return VictoryLabel;
})(_react2["default"].Component);

exports["default"] = VictoryLabel;
module.exports = exports["default"];