"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _radium = require("radium");

var _radium2 = _interopRequireDefault(_radium);

var _d3Shape = require("d3-shape");

var _d3Shape2 = _interopRequireDefault(_d3Shape);

var _lodashLangIsArray = require("lodash/lang/isArray");

var _lodashLangIsArray2 = _interopRequireDefault(_lodashLangIsArray);

var _lodashObjectMerge = require("lodash/object/merge");

var _lodashObjectMerge2 = _interopRequireDefault(_lodashObjectMerge);

var _lodashObjectAssign = require("lodash/object/assign");

var _lodashObjectAssign2 = _interopRequireDefault(_lodashObjectAssign);

var _lodashObjectPick = require("lodash/object/pick");

var _lodashObjectPick2 = _interopRequireDefault(_lodashObjectPick);

var _victoryUtil = require("victory-util");

var _slice = require("./slice");

var _slice2 = _interopRequireDefault(_slice);

var _sliceLabel = require("./slice-label");

var _sliceLabel2 = _interopRequireDefault(_sliceLabel);

var _victoryAnimation = require("victory-animation");

var defaultStyles = {
  data: {
    padding: 5,
    stroke: "white",
    strokeWidth: 1
  },
  labels: {
    padding: 10,
    fill: "black",
    strokeWidth: 0,
    stroke: "transparent",
    fontFamily: "'Helvetica Neue', Helvetica, Arial, sans-serif",
    fontSize: 10,
    textAnchor: "middle"
  }
};

var degreesToRadians = function degreesToRadians(degrees) {
  return degrees * (Math.PI / 180);
};

var getRadius = function getRadius(props, padding) {
  return Math.min(props.width - padding.left - padding.right, props.height - padding.top - padding.bottom) / 2;
};

var getLabelPosition = function getLabelPosition(props, style, radius) {
  // TODO: better label positioning
  var innerRadius = props.innerRadius ? props.innerRadius + style.labels.padding : style.labels.padding;
  return _d3Shape2["default"].arc().outerRadius(radius).innerRadius(innerRadius);
};

var VictoryPie = (function (_React$Component) {
  _inherits(VictoryPie, _React$Component);

  function VictoryPie() {
    _classCallCheck(this, _VictoryPie);

    _get(Object.getPrototypeOf(_VictoryPie.prototype), "constructor", this).apply(this, arguments);
  }

  _createClass(VictoryPie, [{
    key: "renderSlice",
    value: function renderSlice(slice, index, calculatedProps) {
      var style = calculatedProps.style;
      var colorScale = calculatedProps.colorScale;
      var makeSlicePath = calculatedProps.makeSlicePath;
      var labelPosition = calculatedProps.labelPosition;

      var fill = colorScale[index % colorScale.length];
      var sliceStyle = (0, _lodashObjectMerge2["default"])({}, style.data, { fill: fill });
      return _react2["default"].createElement(
        "g",
        { key: index },
        _react2["default"].createElement(_slice2["default"], {
          slice: slice,
          pathFunction: makeSlicePath,
          style: sliceStyle
        }),
        _react2["default"].createElement(_sliceLabel2["default"], {
          labelComponent: this.props.labelComponent,
          style: style.labels,
          positionFunction: labelPosition.centroid,
          slice: slice
        })
      );
    }
  }, {
    key: "renderData",
    value: function renderData(props, calculatedProps) {
      var _this = this;

      var _calculatedProps = calculatedProps;
      var style = _calculatedProps.style;
      var radius = _calculatedProps.radius;

      var data = _victoryUtil.Helpers.getData(props);
      var labelPosition = getLabelPosition(props, style, radius);
      var colorScale = (0, _lodashLangIsArray2["default"])(props.colorScale) ? props.colorScale : _victoryUtil.Style.getColorScale(props.colorScale);
      var makeSlicePath = _d3Shape2["default"].arc().outerRadius(radius).innerRadius(this.props.innerRadius);

      calculatedProps = (0, _lodashObjectAssign2["default"])(calculatedProps, { data: data, colorScale: colorScale, makeSlicePath: makeSlicePath, labelPosition: labelPosition });

      var pie = _d3Shape2["default"].pie().sort(null).startAngle(degreesToRadians(props.startAngle)).endAngle(degreesToRadians(props.endAngle)).padAngle(degreesToRadians(props.padAngle)).value(function (datum) {
        return datum.y;
      });
      var slices = pie(data);

      return _react2["default"].createElement(
        "g",
        null,
        slices.map(function (slice, index) {
          return _this.renderSlice(slice, index, calculatedProps);
        })
      );
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      if (this.props.animate) {
        // Do less work by having `VictoryAnimation` tween only values that
        // make sense to tween. In the future, allow customization of animated
        // prop whitelist/blacklist?
        var animateData = (0, _lodashObjectPick2["default"])(this.props, ["data", "endAngle", "height", "innerRadius", "padAngle", "padding", "colorScale", "startAngle", "style", "width"]);
        return _react2["default"].createElement(
          _victoryAnimation.VictoryAnimation,
          _extends({}, this.props.animate, { data: animateData }),
          function (props) {
            return _react2["default"].createElement(VictoryPie, _extends({}, _this2.props, props, { animate: null }));
          }
        );
      }

      var style = _victoryUtil.Helpers.getStyles(this.props, defaultStyles);
      var padding = _victoryUtil.Helpers.getPadding(this.props);
      var radius = getRadius(this.props, padding);
      var parentStyle = style.parent;
      var xOffset = radius + padding.left;
      var yOffset = radius + padding.top;

      var group = _react2["default"].createElement(
        "g",
        { style: parentStyle, transform: "translate(" + xOffset + ", " + yOffset + ")" },
        this.renderData(this.props, { style: style, padding: padding, radius: radius })
      );

      return this.props.standalone ? _react2["default"].createElement(
        "svg",
        { style: parentStyle },
        group
      ) : group;
    }
  }], [{
    key: "propTypes",
    value: {
      /**
       * The animate prop specifies props for victory-animation to use. If this prop is
       * not given, the pie chart will not tween between changing data / style props.
       * Large datasets might animate slowly due to the inherent limits of svg rendering.
       * @examples {velocity: 0.02, onEnd: () => alert("done!")}
       */
      animate: _react.PropTypes.object,
      /**
       * The colorScale prop is an optional prop that defines the color scale the pie
       * will be created on. This prop should be given as an array of CSS colors, or as a string
       * corresponding to one of the built in color scales. VictoryPie will automatically assign
       * values from this color scale to the pie slices unless colors are explicitly provided in the
       * data object
       */
      colorScale: _react.PropTypes.oneOfType([_react.PropTypes.arrayOf(_react.PropTypes.string), _react.PropTypes.oneOf(["greyscale", "qualitative", "heatmap", "warm", "cool", "red", "green", "blue"])]),
      /**
       * Objects in the data array must be of the form { x: <x-val>, y: <y-val> }, where <x-val>
       * is the slice label (string or number), and <y-val> is the corresponding number
       * used to calculate arc length as a proportion of the pie's circumference.
       * If the data prop is omitted, the pie will render sample data.
       */

      /**
       * The data prop specifies the data to be plotted,
       * where data X-value is the slice label (string or number),
       * and Y-value is the corresponding number value represented by the slice
       * Data should be in the form of an array of data points.
       * Each data point may be any format you wish (depending on the `x` and `y` accessor props),
       * but by default, an object with x and y properties is expected.
       * @examples [{x: 1, y: 2}, {x: 2, y: 3}], [[1, 2], [2, 3]],
       * [[{x: "a", y: 1}, {x: "b", y: 2}], [{x: "a", y: 2}, {x: "b", y: 3}]]
       */
      data: _react.PropTypes.array,
      /**
       * The overall end angle of the pie in degrees. This prop is used in conjunction with
       * startAngle to create a pie that spans only a segment of a circle.
       */
      endAngle: _react.PropTypes.number,
      /**
       * The height props specifies the height of the chart container element in pixels
       */
      height: _victoryUtil.PropTypes.nonNegative,
      /**
       * When creating a donut chart, this prop determines the number of pixels between
       * the center of the chart and the inner edge of a donut. When this prop is set to zero
       * a regular pie chart is rendered.
       */
      innerRadius: _victoryUtil.PropTypes.nonNegative,
      /**
       * This prop specifies the labels that will be applied to your data. This prop can be
       * passed in as an array of values, in the same order as your data, or as a function
       * to be applied to each data point. If this prop is not specified, the x value
       * of each data point will be used as a label.
       */
      labelComponent: _react.PropTypes.element,
      /**
       * The padAngle prop determines the amount of separation between adjacent data slices
       * in number of degrees
       */
      padAngle: _victoryUtil.PropTypes.nonNegative,
      /**
       * The padding props specifies the amount of padding in number of pixels between
       * the edge of the chart and any rendered child components. This prop can be given
       * as a number or as an object with padding specified for top, bottom, left
       * and right.
       */
      padding: _react.PropTypes.oneOfType([_react.PropTypes.number, _react.PropTypes.shape({
        top: _react.PropTypes.number,
        bottom: _react.PropTypes.number,
        left: _react.PropTypes.number,
        right: _react.PropTypes.number
      })]),
      /**
       * The standalone prop determines whether VictoryPie should render as a standalone
       * svg, or in a g tag to be included in an svg
       */
      standalone: _react.PropTypes.bool,
      /**
       * The overall start angle of the pie in degrees. This prop is used in conjunction with
       * endAngle to create a pie that spans only a segment of a circle.
       */
      startAngle: _react.PropTypes.number,
      /**
       * The style prop specifies styles for your pie. VictoryPie relies on Radium,
       * so valid Radium style objects should work for this prop. Height, width, and
       * padding should be specified via the height, width, and padding props.
       * @examples {data: {stroke: "black"}, label: {fontSize: 10}}
       */
      style: _react.PropTypes.shape({
        parent: _react.PropTypes.object,
        data: _react.PropTypes.object,
        labels: _react.PropTypes.object
      }),
      /**
       * The width props specifies the width of the chart container element in pixels
       */
      width: _victoryUtil.PropTypes.nonNegative,
      /**
       * The x prop specifies how to access the X value of each data point.
       * If given as a function, it will be run on each data point, and returned value will be used.
       * If given as an integer, it will be used as an array index for array-type data points.
       * If given as a string, it will be used as a property key for object-type data points.
       * If given as an array of strings, or a string containing dots or brackets,
       * it will be used as a nested object property path (for details see Lodash docs for _.get).
       * If `null` or `undefined`, the data value will be used as is (identity function/pass-through).
       * @examples 0, 'x', 'x.value.nested.1.thing', 'x[2].also.nested', null, d => Math.sin(d)
       */
      x: _react.PropTypes.oneOfType([_react.PropTypes.func, _victoryUtil.PropTypes.allOfType([_victoryUtil.PropTypes.integer, _victoryUtil.PropTypes.nonNegative]), _react.PropTypes.string, _react.PropTypes.arrayOf(_react.PropTypes.string)]),
      /**
       * The y prop specifies how to access the Y value of each data point.
       * If given as a function, it will be run on each data point, and returned value will be used.
       * If given as an integer, it will be used as an array index for array-type data points.
       * If given as a string, it will be used as a property key for object-type data points.
       * If given as an array of strings, or a string containing dots or brackets,
       * it will be used as a nested object property path (for details see Lodash docs for _.get).
       * If `null` or `undefined`, the data value will be used as is (identity function/pass-through).
       * @examples 0, 'y', 'y.value.nested.1.thing', 'y[2].also.nested', null, d => Math.sin(d)
       */
      y: _react.PropTypes.oneOfType([_react.PropTypes.func, _victoryUtil.PropTypes.allOfType([_victoryUtil.PropTypes.integer, _victoryUtil.PropTypes.nonNegative]), _react.PropTypes.string, _react.PropTypes.arrayOf(_react.PropTypes.string)])
    },
    enumerable: true
  }, {
    key: "defaultProps",
    value: {
      data: [{ x: "A", y: 1 }, { x: "B", y: 2 }, { x: "C", y: 3 }, { x: "D", y: 1 }, { x: "E", y: 2 }],
      endAngle: 360,
      height: 400,
      innerRadius: 0,
      padAngle: 0,
      padding: 30,
      colorScale: ["#75C776", "#39B6C5", "#78CCC4", "#62C3A4", "#64A8D1", "#8C95C8", "#3BAF74"],
      startAngle: 0,
      standalone: true,
      width: 400,
      x: "x",
      y: "y"
    },
    enumerable: true
  }]);

  var _VictoryPie = VictoryPie;
  VictoryPie = (0, _radium2["default"])(VictoryPie) || VictoryPie;
  return VictoryPie;
})(_react2["default"].Component);

exports["default"] = VictoryPie;
module.exports = exports["default"];