"use strict";

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _lodashObjectTransform = require("lodash/object/transform");

var _lodashObjectTransform2 = _interopRequireDefault(_lodashObjectTransform);

var _lodashObjectMerge = require("lodash/object/merge");

var _lodashObjectMerge2 = _interopRequireDefault(_lodashObjectMerge);

var _lodashCollectionSome = require("lodash/collection/some");

var _lodashCollectionSome2 = _interopRequireDefault(_lodashCollectionSome);

module.exports = {
  getPadding: function getPadding(props) {
    var padding = typeof props.padding === "number" ? props.padding : 0;
    var paddingObj = typeof props.padding === "object" ? props.padding : {};
    return {
      top: paddingObj.top || padding,
      bottom: paddingObj.bottom || padding,
      left: paddingObj.left || padding,
      right: paddingObj.right || padding
    };
  },

  getStyles: function getStyles(props, defaultStyles) {
    var style = props.style || defaultStyles;
    var data = style.data;
    var labels = style.labels;
    var parent = style.parent;

    return {
      parent: (0, _lodashObjectMerge2["default"])({}, defaultStyles.parent, parent, { height: props.height, width: props.width }),
      labels: (0, _lodashObjectMerge2["default"])({}, defaultStyles.labels, labels),
      data: (0, _lodashObjectMerge2["default"])({}, defaultStyles.data, data)
    };
  },

  evaluateProp: function evaluateProp(prop, data) {
    return typeof prop === "function" ? prop(data) : prop;
  },

  evaluateStyle: function evaluateStyle(style, data) {
    var _this = this;

    if (!(0, _lodashCollectionSome2["default"])(style, function (value) {
      return typeof value === "function";
    })) {
      return style;
    }
    return (0, _lodashObjectTransform2["default"])(style, function (result, value, key) {
      result[key] = _this.evaluateProp(value, data);
    });
  },

  getRange: function getRange(props, axis) {
    // determine how to lay the axis and what direction positive and negative are
    var horizontal = props.horizontal;

    var isVertical = horizontal && axis === "x" || !horizontal && axis !== "x";
    var isDependent = horizontal && !isVertical || !horizontal && isVertical;
    var padding = this.getPadding(props);
    if (isVertical) {
      var bottomToTop = [props.height - padding.bottom, padding.top];
      return isDependent ? bottomToTop : bottomToTop.reverse();
    }
    return [padding.left, props.width - padding.right];
  }
};