"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _lodashCollectionSome = require("lodash/collection/some");

var _lodashCollectionSome2 = _interopRequireDefault(_lodashCollectionSome);

var _lodashCollectionEvery = require("lodash/collection/every");

var _lodashCollectionEvery2 = _interopRequireDefault(_lodashCollectionEvery);

var _lodashLangIsDate = require("lodash/lang/isDate");

var _lodashLangIsDate2 = _interopRequireDefault(_lodashLangIsDate);

var isNonEmptyArray = function isNonEmptyArray(collection) {
  return Array.isArray(collection) && collection.length > 0;
};

exports.isNonEmptyArray = isNonEmptyArray;
var containsStrings = function containsStrings(collection) {
  return (0, _lodashCollectionSome2["default"])(collection, function (value) {
    return typeof value === "string";
  });
};

exports.containsStrings = containsStrings;
var containsDates = function containsDates(collection) {
  return (0, _lodashCollectionSome2["default"])(collection, _lodashLangIsDate2["default"]);
};

exports.containsDates = containsDates;
var containsOnlyStrings = function containsOnlyStrings(collection) {
  return isNonEmptyArray(collection) && (0, _lodashCollectionEvery2["default"])(collection, function (value) {
    return typeof value === "string";
  });
};

exports.containsOnlyStrings = containsOnlyStrings;
var isArrayOfArrays = function isArrayOfArrays(collection) {
  return isNonEmptyArray(collection) && (0, _lodashCollectionEvery2["default"])(collection, Array.isArray);
};

exports.isArrayOfArrays = isArrayOfArrays;
var removeUndefined = function removeUndefined(arr) {
  return arr.filter(function (el) {
    return el !== undefined;
  });
};
exports.removeUndefined = removeUndefined;