"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i]; return arr2; } else { return Array.from(arr); } }

var _lodashArrayCompact = require("lodash/array/compact");

var _lodashArrayCompact2 = _interopRequireDefault(_lodashArrayCompact);

var _lodashArrayFindIndex = require("lodash/array/findIndex");

var _lodashArrayFindIndex2 = _interopRequireDefault(_lodashArrayFindIndex);

var _lodashArrayFlatten = require("lodash/array/flatten");

var _lodashArrayFlatten2 = _interopRequireDefault(_lodashArrayFlatten);

var _lodashArrayUnion = require("lodash/array/union");

var _lodashArrayUnion2 = _interopRequireDefault(_lodashArrayUnion);

var _lodashLangIsEmpty = require("lodash/lang/isEmpty");

var _lodashLangIsEmpty2 = _interopRequireDefault(_lodashLangIsEmpty);

var _lodashLangIsFunction = require("lodash/lang/isFunction");

var _lodashLangIsFunction2 = _interopRequireDefault(_lodashLangIsFunction);

var _lodashLangIsUndefined = require("lodash/lang/isUndefined");

var _lodashLangIsUndefined2 = _interopRequireDefault(_lodashLangIsUndefined);

var _lodashLangIsNull = require("lodash/lang/isNull");

var _lodashLangIsNull2 = _interopRequireDefault(_lodashLangIsNull);

var _lodashObjectHas = require("lodash/object/has");

var _lodashObjectHas2 = _interopRequireDefault(_lodashObjectHas);

var _lodashObjectAssign = require("lodash/object/assign");

var _lodashObjectAssign2 = _interopRequireDefault(_lodashObjectAssign);

var _lodashObjectMerge = require("lodash/object/merge");

var _lodashObjectMerge2 = _interopRequireDefault(_lodashObjectMerge);

var _lodashUtilityIdentity = require("lodash/utility/identity");

var _lodashUtilityIdentity2 = _interopRequireDefault(_lodashUtilityIdentity);

var _lodashUtilityProperty = require("lodash/utility/property");

var _lodashUtilityProperty2 = _interopRequireDefault(_lodashUtilityProperty);

var _lodashUtilityRange = require("lodash/utility/range");

var _lodashUtilityRange2 = _interopRequireDefault(_lodashUtilityRange);

var _lodashArrayUniq = require("lodash/array/uniq");

var _lodashArrayUniq2 = _interopRequireDefault(_lodashArrayUniq);

var _lodashArrayZipObject = require("lodash/array/zipObject");

var _lodashArrayZipObject2 = _interopRequireDefault(_lodashArrayZipObject);

var _style = require("./style");

var Style = _interopRequireWildcard(_style);

var _scale = require("./scale");

var _scale2 = _interopRequireDefault(_scale);

exports["default"] = {
  // String Data
  createStringMap: function createStringMap(props, axis) {
    var _this = this;

    var hasMultipleDatasets = arguments.length <= 2 || arguments[2] === undefined ? false : arguments[2];

    var stringsFromAxes = this.getStringsFromAxes(props, axis);
    var stringsFromCategories = this.getStringsFromCategories(props, axis);
    var stringsFromData = hasMultipleDatasets ? (0, _lodashArrayUniq2["default"])((0, _lodashArrayFlatten2["default"])(props.data.map(function (dataset) {
      return _this.getStringsFromData((0, _lodashObjectMerge2["default"])({}, props, { data: dataset }), axis);
    }))) : this.getStringsFromData(props, axis);

    var allStrings = (0, _lodashArrayUniq2["default"])((0, _lodashArrayCompact2["default"])([].concat(_toConsumableArray(stringsFromAxes), _toConsumableArray(stringsFromCategories), _toConsumableArray(stringsFromData))));
    return (0, _lodashLangIsEmpty2["default"])(allStrings) ? null : (0, _lodashArrayZipObject2["default"])(allStrings.map(function (string, index) {
      return [string, index + 1];
    }));
  },

  getStringsFromAxes: function getStringsFromAxes(props, axis) {
    if (!props.tickValues || !Array.isArray(props.tickValues) && !props.tickValues[axis]) {
      return [];
    }
    var tickValueArray = props.tickValues[axis] || props.tickValues;
    return tickValueArray.filter(function (val) {
      return typeof val === "string";
    });
  },

  getStringsFromCategories: function getStringsFromCategories(props, axis) {
    // TODO generalize for independent vertical axes
    if (!props.categories || axis !== "x") {
      return [];
    } else {
      var categoryArray = (0, _lodashArrayCompact2["default"])((0, _lodashArrayFlatten2["default"])(props.categories));
      return categoryArray.filter(function (val) {
        return typeof val === "string";
      });
    }
  },

  getStringsFromData: function getStringsFromData(props, axis) {
    if (!props.data) {
      return [];
    }
    var accessor = this.createAccessor((0, _lodashObjectHas2["default"])(props, axis) ? props[axis] : axis);
    var dataStrings = props.data.map(function (datum) {
      return accessor(datum);
    }).filter(function (datum) {
      return typeof datum === "string";
    });
    // return a unique set of strings
    return (0, _lodashArrayCompact2["default"])((0, _lodashArrayUniq2["default"])(dataStrings));
  },

  // for components that take single datasets
  getData: function getData(props) {
    if (props.data) {
      return this.formatData(props.data, props);
    }
    var data = this.generateData(props);
    return this.formatData(data, props);
  },

  generateData: function generateData(props) {
    // create an array of values evenly spaced across the x domain that include domain min/max
    var domain = props.domain ? props.domain.x || props.domain : _scale2["default"].getBaseScale(props, "x").domain();
    var step = Math.max.apply(Math, _toConsumableArray(domain)) / props.samples;
    var values = (0, _lodashArrayUnion2["default"])((0, _lodashUtilityRange2["default"])(Math.min.apply(Math, _toConsumableArray(domain)), Math.max.apply(Math, _toConsumableArray(domain)), step), [Math.max.apply(Math, _toConsumableArray(domain))]);
    // return data objects for values in {x, y} format
    return values.map(function (v) {
      return { x: v, y: v };
    });
  },

  formatData: function formatData(dataset, props, stringMap) {
    var _this2 = this;

    if (!dataset) {
      return [];
    }
    stringMap = stringMap || {
      x: this.createStringMap(props, "x"),
      y: this.createStringMap(props, "y")
    };
    var accessor = {
      x: this.createAccessor(props.x),
      y: this.createAccessor(props.y)
    };

    return this.cleanData(dataset, props).map(function (datum) {
      var x = accessor.x(datum);
      var y = accessor.y(datum);
      return (0, _lodashObjectMerge2["default"])({}, datum, {
        category: _this2.determineCategoryIndex(x, props.categories),
        // map string data to numeric values, and add names
        x: typeof x === "string" ? stringMap.x[x] : x,
        xName: typeof x === "string" ? x : undefined,
        y: typeof y === "string" ? stringMap.y[y] : y,
        yName: typeof y === "string" ? y : undefined
      });
    });
  },

  // For components that take multiple datasets
  formatDatasets: function formatDatasets(datasets, props) {
    var _this3 = this;

    // string map must be calculated using all datasets and shared
    var propsWithDatasets = (0, _lodashObjectAssign2["default"])({}, props, { data: datasets });
    var stringMap = {
      x: this.createStringMap(propsWithDatasets, "x", true),
      y: this.createStringMap(propsWithDatasets, "y", true)
    };
    return datasets.map(function (dataset, index) {
      return {
        attrs: _this3.getAttributes(props, index),
        data: _this3.formatData(dataset, props, stringMap)
      };
    });
  },

  cleanData: function cleanData(dataset, props) {
    // Some scale types break when certain data is supplies. This method will
    // remove data points that break scales. So far this method only removes
    // zeroes for log scales
    // TODO other cases?
    var scaleType = {
      x: _scale2["default"].getScaleType(props, "x"),
      y: _scale2["default"].getScaleType(props, "y")
    };
    var accessor = {
      x: this.createAccessor(props.x),
      y: this.createAccessor(props.y)
    };
    if (scaleType.x !== "log" && scaleType.y !== "log") {
      return dataset;
    }
    var rules = function rules(datum, axis) {
      return scaleType[axis] === "log" ? accessor[axis](datum) !== 0 : true;
    };
    return dataset.filter(function (datum) {
      return rules(datum, "x") && rules(datum, "y");
    });
  },

  determineCategoryIndex: function determineCategoryIndex(x, categories) {
    // if categories don't exist or are not given as an array of arrays, return undefined;
    if (!categories || !Array.isArray(categories[0])) {
      return undefined;
    }
    // determine which range band this x value belongs to, and return the index of that range band.
    return (0, _lodashArrayFindIndex2["default"])(categories, function (category) {
      return x >= Math.min.apply(Math, _toConsumableArray(category)) && x <= Math.max.apply(Math, _toConsumableArray(category));
    });
  },

  getAttributes: function getAttributes(props, index) {
    var attributes = props.dataAttributes && props.dataAttributes[index] ? props.dataAttributes[index] : props.dataAttributes;
    if (attributes) {
      attributes.fill = attributes.fill || this.getColor(props, index);
    } else {
      attributes = { fill: this.getColor(props, index) };
    }
    var requiredAttributes = {
      name: attributes && attributes.name ? attributes.name : "data-" + index
    };
    return (0, _lodashObjectMerge2["default"])(requiredAttributes, attributes);
  },

  getColor: function getColor(props, index) {
    // check for styles first
    if (props.style && props.style.data && props.style.data.fill) {
      return props.style.data.fill;
    }
    var colorScale = Array.isArray(props.colorScale) ? props.colorScale : Style.getColorScale(props.colorScale);
    return colorScale[index % colorScale.length];
  },

  createAccessor: function createAccessor(key) {
    // creates a data accessor function
    // given a property key, path, array index, or null for identity.
    if ((0, _lodashLangIsFunction2["default"])(key)) {
      return key;
    } else if ((0, _lodashLangIsNull2["default"])(key) || (0, _lodashLangIsUndefined2["default"])(key)) {
      // null/undefined means "return the data item itself"
      return _lodashUtilityIdentity2["default"];
    }
    // otherwise, assume it is an array index, property key or path (_.property handles all three)
    return (0, _lodashUtilityProperty2["default"])(key);
  }
};
module.exports = exports["default"];