"use strict";

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i]; return arr2; } else { return Array.from(arr); } }

var _lodashArrayFlatten = require("lodash/array/flatten");

var _lodashArrayFlatten2 = _interopRequireDefault(_lodashArrayFlatten);

var _lodashLangIsDate = require("lodash/lang/isDate");

var _lodashLangIsDate2 = _interopRequireDefault(_lodashLangIsDate);

var _data = require("./data");

var _data2 = _interopRequireDefault(_data);

var _chart = require("./chart");

var _chart2 = _interopRequireDefault(_chart);

module.exports = {
  getDomain: function getDomain(props, axis) {
    var propsDomain = this.getDomainFromProps(props, axis);
    if (propsDomain) {
      return propsDomain;
    }
    var dataset = _data2["default"].getData(props);
    return this.getDomainFromData(dataset, axis);
  },

  getDomainFromProps: function getDomainFromProps(props, axis) {
    if (props.domain && props.domain[axis]) {
      return props.domain[axis];
    } else if (props.domain && Array.isArray(props.domain)) {
      return props.domain;
    }
  },

  getDomainFromData: function getDomainFromData(dataset, axis) {
    var allData = (0, _lodashArrayFlatten2["default"])(dataset).map(function (datum) {
      return datum[axis];
    });
    var min = Math.min.apply(Math, _toConsumableArray(allData));
    var max = Math.max.apply(Math, _toConsumableArray(allData));
    // TODO: is this the correct behavior, or should we just error. How do we
    // handle charts with just one data point?
    if (min === max) {
      var adjustedMax = max === 0 ? 1 : max;
      return [0, adjustedMax];
    }
    return [min, max];
  },

  padDomain: function padDomain(domain, props, axis) {
    if (!props.domainPadding) {
      return domain;
    }
    var domainPadding = typeof props.domainPadding === "number" ? props.domainPadding : props.domainPadding[axis];

    if (!domainPadding) {
      return domain;
    }
    var domainMin = Math.min.apply(Math, _toConsumableArray(domain));
    var domainMax = Math.max.apply(Math, _toConsumableArray(domain));
    var range = _chart2["default"].getRange(props, axis);
    var rangeExtent = Math.abs(Math.max.apply(Math, _toConsumableArray(range)) - Math.min.apply(Math, _toConsumableArray(range)));
    var padding = Math.abs(domainMax - domainMin) * domainPadding / rangeExtent;
    // don't make the axes cross if they aren't already
    var adjustedMin = domainMin >= 0 && domainMin - padding <= 0 ? 0 : domainMin.valueOf() - padding;
    var adjustedMax = domainMax <= 0 && domainMax + padding >= 0 ? 0 : domainMax.valueOf() + padding;
    return (0, _lodashLangIsDate2["default"])(domainMin) || (0, _lodashLangIsDate2["default"])(domainMax) ? [new Date(adjustedMin), new Date(adjustedMax)] : [adjustedMin, adjustedMax];
  }
};