"use strict";

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _lodashArrayFlatten = require("lodash/array/flatten");

var _lodashArrayFlatten2 = _interopRequireDefault(_lodashArrayFlatten);

var _lodashCollectionIncludes = require("lodash/collection/includes");

var _lodashCollectionIncludes2 = _interopRequireDefault(_lodashCollectionIncludes);

var _collection = require("./collection");

var Collection = _interopRequireWildcard(_collection);

var _data = require("./data");

var _data2 = _interopRequireDefault(_data);

var _d3Scale = require("d3-scale");

var _d3Scale2 = _interopRequireDefault(_d3Scale);

var supportedScaleStrings = ["linear", "time", "log", "sqrt"];

module.exports = {
  validScale: function validScale(scale) {
    if (typeof scale === "function") {
      var isFunction = function isFunction(val) {
        return typeof val === "function";
      };
      return isFunction(scale.copy) && isFunction(scale.domain) && isFunction(scale.range);
    } else if (typeof scale === "string") {
      return (0, _lodashCollectionIncludes2["default"])(supportedScaleStrings, scale);
    }
    return false;
  },

  isScaleDefined: function isScaleDefined(props, axis) {
    if (!props.scale) {
      return false;
    } else if (props.scale.x || props.scale.y) {
      return props.scale[axis] ? true : false;
    }
    return true;
  },

  getScaleFromProps: function getScaleFromProps(props, axis) {
    if (!this.isScaleDefined(props, axis)) {
      return undefined;
    }
    var scale = props.scale[axis] || props.scale;
    if (this.validScale(scale)) {
      return typeof scale === "function" ? scale : _d3Scale2["default"][scale]();
    }
  },

  getScaleTypeFromData: function getScaleTypeFromData(props, axis) {
    if (!props.data) {
      return "linear";
    }
    var accessor = _data2["default"].createAccessor(props[axis]);
    var allData = (0, _lodashArrayFlatten2["default"])(props.data);
    var axisData = allData.map(accessor);
    return Collection.containsDates(axisData) ? "time" : "linear";
  },

  getBaseScale: function getBaseScale(props, axis) {
    var scale = this.getScaleFromProps(props, axis);
    if (scale) {
      return scale;
    }
    return _d3Scale2["default"][this.getScaleTypeFromData(props, axis)]();
  },

  getScaleType: function getScaleType(props, axis) {
    var scale = this.getScaleFromProps(props, axis);
    // if the scale was not given in props, it will be set to linear or time depending on data
    if (!scale) {
      return this.getScaleTypeFromData(props, axis);
    } else if (typeof scale === "string") {
      return (0, _lodashCollectionIncludes2["default"])(supportedScaleStrings, scale) ? scale : "invalid";
    } else if (!this.validScale(scale)) {
      return "invalid";
    }
    var duckTypes = [{ name: "log", method: "base" }, { name: "ordinal", method: "unknown" }, { name: "pow-sqrt", method: "exponent" }, { name: "quantile", method: "quantiles" }, { name: "quantize-threshold", method: "invertExtent" }];
    var scaleType = duckTypes.filter(function (type) {
      return scale[type.method] !== undefined;
    })[0];
    if (scaleType) {
      return scaleType.name;
    }
    return this.getScaleTypeFromData(props, axis);
  }
};