"use strict";

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _lodashObjectTransform = require("lodash/object/transform");

var _lodashObjectTransform2 = _interopRequireDefault(_lodashObjectTransform);

var _lodashObjectMerge = require("lodash/object/merge");

var _lodashObjectMerge2 = _interopRequireDefault(_lodashObjectMerge);

var _lodashCollectionSome = require("lodash/collection/some");

var _lodashCollectionSome2 = _interopRequireDefault(_lodashCollectionSome);

var _lodashLangIsFunction = require("lodash/lang/isFunction");

var _lodashLangIsFunction2 = _interopRequireDefault(_lodashLangIsFunction);

var _lodashLangIsUndefined = require("lodash/lang/isUndefined");

var _lodashLangIsUndefined2 = _interopRequireDefault(_lodashLangIsUndefined);

var _lodashLangIsNull = require("lodash/lang/isNull");

var _lodashLangIsNull2 = _interopRequireDefault(_lodashLangIsNull);

var _lodashUtilityProperty = require("lodash/utility/property");

var _lodashUtilityProperty2 = _interopRequireDefault(_lodashUtilityProperty);

var _lodashUtilityIdentity = require("lodash/utility/identity");

var _lodashUtilityIdentity2 = _interopRequireDefault(_lodashUtilityIdentity);

var _lodashArrayCompact = require("lodash/array/compact");

var _lodashArrayCompact2 = _interopRequireDefault(_lodashArrayCompact);

var _lodashLangIsEmpty = require("lodash/lang/isEmpty");

var _lodashLangIsEmpty2 = _interopRequireDefault(_lodashLangIsEmpty);

var _lodashObjectHas = require("lodash/object/has");

var _lodashObjectHas2 = _interopRequireDefault(_lodashObjectHas);

var _lodashArrayUniq = require("lodash/array/uniq");

var _lodashArrayUniq2 = _interopRequireDefault(_lodashArrayUniq);

var _lodashArrayZipObject = require("lodash/array/zipObject");

var _lodashArrayZipObject2 = _interopRequireDefault(_lodashArrayZipObject);

module.exports = {
  getPadding: function getPadding(props) {
    var padding = typeof props.padding === "number" ? props.padding : 0;
    var paddingObj = typeof props.padding === "object" ? props.padding : {};
    return {
      top: paddingObj.top || padding,
      bottom: paddingObj.bottom || padding,
      left: paddingObj.left || padding,
      right: paddingObj.right || padding
    };
  },

  getStyles: function getStyles(props, defaultStyles) {
    var style = props.style || defaultStyles;
    var data = style.data;
    var labels = style.labels;
    var parent = style.parent;

    return {
      parent: (0, _lodashObjectMerge2["default"])({}, defaultStyles.parent, parent, { height: props.height, width: props.width }),
      labels: (0, _lodashObjectMerge2["default"])({}, defaultStyles.labels, labels),
      data: (0, _lodashObjectMerge2["default"])({}, defaultStyles.data, data)
    };
  },

  evaluateProp: function evaluateProp(prop, data) {
    return typeof prop === "function" ? prop(data) : prop;
  },

  evaluateStyle: function evaluateStyle(style, data) {
    var _this = this;

    if (!(0, _lodashCollectionSome2["default"])(style, function (value) {
      return typeof value === "function";
    })) {
      return style;
    }
    return (0, _lodashObjectTransform2["default"])(style, function (result, value, key) {
      result[key] = _this.evaluateProp(value, data);
    });
  },

  getRange: function getRange(props, axis) {
    // determine how to lay the axis and what direction positive and negative are
    var horizontal = props.horizontal;

    var isVertical = horizontal && axis === "x" || !horizontal && axis !== "x";
    var isDependent = horizontal && !isVertical || !horizontal && isVertical;
    var padding = this.getPadding(props);
    if (isVertical) {
      var bottomToTop = [props.height - padding.bottom, padding.top];
      return isDependent ? bottomToTop : bottomToTop.reverse();
    }
    return [padding.left, props.width - padding.right];
  },

  // for components that take single datasets
  getData: function getData(props) {
    if (props.data) {
      return this.formatData(props.data, props);
    }
  },

  formatData: function formatData(dataset, props, stringMap) {
    if (!dataset) {
      return [];
    }
    stringMap = stringMap || {
      x: this.createStringMap(props, "x"),
      y: this.createStringMap(props, "y")
    };
    var accessor = {
      x: this.createAccessor(props.x),
      y: this.createAccessor(props.y)
    };

    return dataset.map(function (datum) {
      var x = accessor.x(datum);
      var y = accessor.y(datum);
      return (0, _lodashObjectMerge2["default"])({}, datum, {
        // map string data to numeric values, and add names
        x: typeof x === "string" ? stringMap.x[x] : x,
        xName: typeof x === "string" ? x : undefined,
        y: typeof y === "string" ? stringMap.y[y] : y,
        yName: typeof y === "string" ? y : undefined
      });
    });
  },

  createStringMap: function createStringMap(props, axis) {
    var stringsFromData = this.getStringsFromData(props, axis);
    return (0, _lodashLangIsEmpty2["default"])(stringsFromData) ? null : (0, _lodashArrayZipObject2["default"])(stringsFromData.map(function (string, index) {
      return [string, index + 1];
    }));
  },

  getStringsFromData: function getStringsFromData(props, axis) {
    if (!props.data) {
      return [];
    }
    var accessor = this.createAccessor((0, _lodashObjectHas2["default"])(props, axis) ? props[axis] : axis);
    var dataStrings = props.data.map(function (datum) {
      return accessor(datum);
    }).filter(function (datum) {
      return typeof datum === "string";
    });
    // return a unique set of strings
    return (0, _lodashArrayCompact2["default"])((0, _lodashArrayUniq2["default"])(dataStrings));
  },

  createAccessor: function createAccessor(key) {
    // creates a data accessor function
    // given a property key, path, array index, or null for identity.
    if ((0, _lodashLangIsFunction2["default"])(key)) {
      return key;
    } else if ((0, _lodashLangIsNull2["default"])(key) || (0, _lodashLangIsUndefined2["default"])(key)) {
      // null/undefined means "return the data item itself"
      return _lodashUtilityIdentity2["default"];
    }
    // otherwise, assume it is an array index, property key or path (_.property handles all three)
    return (0, _lodashUtilityProperty2["default"])(key);
  }
};