"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var nullConstructor = function nullConstructor() {
  return null;
};
exports.nullConstructor = nullConstructor;
var undefinedConstructor = function undefinedConstructor() {
  return;
};
exports.undefinedConstructor = undefinedConstructor;
/**
 * Get the constructor of `value`. If `value` is null or undefined, return the
 * special singletons `nullConstructor` or `undefinedConstructor`, respectively.
 * @param {*} value Instance to return the constructor of.
 * @returns {Function} Constructor of `value`.
 */
var getConstructor = function getConstructor(value) {
  if (typeof value === "undefined") {
    return undefinedConstructor;
  } else if (value === null) {
    return nullConstructor;
  } else {
    return value.constructor;
  }
};

exports.getConstructor = getConstructor;
/**
 * Get the name of the constructor used to create `value`, using
 * `Object.protoype.toString`. If the value is null or undefined, return
 * "null" or "undefined", respectively.
 * @param {*} value Instance to return the constructor name of.
 * @returns {String} Name of the constructor.
 */
var getConstructorName = function getConstructorName(value) {
  if (typeof value === "undefined") {
    return "undefined";
  } else if (value === null) {
    return "null";
  }
  return Object.prototype.toString.call(value).slice(8, -1);
};
exports.getConstructorName = getConstructorName;