'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var propTypes = {
  manager: _propTypes2.default.object,
  className: _propTypes2.default.string
};

var Bezel = function (_Component) {
  _inherits(Bezel, _Component);

  function Bezel(props, context) {
    _classCallCheck(this, Bezel);

    var _this = _possibleConstructorReturn(this, (Bezel.__proto__ || Object.getPrototypeOf(Bezel)).call(this, props, context));

    _this.timer = null;
    props.manager.subscribeToOperationStateChange(_this.handleStateChange.bind(_this));

    _this.state = {
      hidden: true,
      operation: {}
    };
    return _this;
  }

  _createClass(Bezel, [{
    key: 'handleStateChange',
    value: function handleStateChange(state, prevState) {
      var _this2 = this;

      if (state.count !== prevState.count && state.operation.source === 'shortcut') {
        if (this.timer) {
          // previous animation is not finished
          clearTimeout(this.timer); // cancel it
          this.timer = null;
        }

        // show it
        // update operation
        this.setState({
          hidden: false,
          count: state.count,
          operation: state.operation
        });

        // hide it after 0.5s
        this.timer = setTimeout(function () {
          _this2.setState({
            hidden: true
          });
          _this2.timer = null;
        }, 500);
      }
    }
  }, {
    key: 'render',
    value: function render() {
      // only displays for shortcut so far
      if (this.state.operation.source !== 'shortcut') {
        return null;
      }
      var style = this.state.hidden ? {
        display: 'none'
      } : null;

      return _react2.default.createElement(
        'div',
        {
          className: (0, _classnames2.default)({
            'video-react-bezel': true,
            'video-react-bezel-animation': this.state.count % 2 === 0,
            'video-react-bezel-animation-alt': this.state.count % 2 === 1
          }, this.props.className),
          style: style,
          role: 'status',
          'aria-label': this.state.operation.action
        },
        _react2.default.createElement('div', {
          className: (0, _classnames2.default)('video-react-bezel-icon', 'video-react-bezel-icon-' + this.state.operation.action)
        })
      );
    }
  }]);

  return Bezel;
}(_react.Component);

exports.default = Bezel;


Bezel.propTypes = propTypes;
Bezel.displayName = 'Bezel';