"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var isSafari = typeof navigator !== 'undefined' && /^((?!chrome|android).)*safari/i.test(navigator.userAgent);
var VideoSnapshot = /** @class */ (function () {
    // TODO: Add support for base64?
    function VideoSnapshot(blob) {
        var _this = this;
        // TODO: implement video cache
        this.loadVideo = function (time) {
            if (time === void 0) { time = 0; }
            return new Promise(function (resolve, reject) {
                var video = document.createElement('video');
                video.preload = 'metadata';
                video.src = _this.videoUrl;
                video.muted = true;
                if (time === 0) {
                    video.play();
                }
                else {
                    if (typeof time === 'number') {
                        video.currentTime = time;
                    }
                    else if (typeof time === 'string') {
                        var duration = video.duration;
                        video.currentTime = _this.getSmartTime(time, duration);
                    }
                    if (isSafari) {
                        // Safari needs to always play the video
                        video.play();
                    }
                }
                // loadedmetadata, loadeddata, play, playing
                video.addEventListener('timeupdate', function timeupdateHandler() {
                    video.removeEventListener('timeupdate', timeupdateHandler);
                    video.pause();
                    resolve(video);
                });
                video.addEventListener('error', function () {
                    reject(new Error('failed to load video'));
                });
            });
        };
        this.getDimensions = function () { return tslib_1.__awaiter(_this, void 0, void 0, function () {
            var video;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.loadVideo()];
                    case 1:
                        video = _a.sent();
                        return [2 /*return*/, {
                                width: video.videoWidth,
                                height: video.videoHeight
                            }];
                }
            });
        }); };
        var url = URL.createObjectURL(blob);
        this.videoUrl = url;
    }
    // TODO: Support time="1:20", time="01:05"
    VideoSnapshot.prototype.takeSnapshot = function (time) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var video, canvas, context, dataURL;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.loadVideo(time)];
                    case 1:
                        video = _a.sent();
                        canvas = document.createElement('canvas');
                        if (!video.videoWidth && !video.videoHeight) {
                            throw new Error("error retrieving video dimensions");
                        }
                        canvas.width = video.videoWidth;
                        canvas.height = video.videoHeight;
                        context = canvas.getContext('2d');
                        if (!context) {
                            throw new Error('error creating canvas context');
                        }
                        context.drawImage(video, 0, 0, canvas.width, canvas.height);
                        dataURL = canvas.toDataURL();
                        return [2 /*return*/, dataURL];
                }
            });
        });
    };
    VideoSnapshot.prototype.end = function () {
        this.revoke();
    };
    VideoSnapshot.prototype.revoke = function () {
        URL.revokeObjectURL(this.videoUrl);
    };
    VideoSnapshot.prototype.getSmartTime = function (time, duration) {
        if (duration === void 0) { duration = 0; }
        var smartTimes = {
            start: 0,
            middle: duration / 2,
            end: duration,
        };
        return smartTimes[time];
    };
    return VideoSnapshot;
}());
exports.default = VideoSnapshot;
