export declare type CustomVideoTime = 'start' | 'middle' | 'end';
export declare type VideoTime = number | CustomVideoTime;
export interface Dimensions {
    width: number;
    height: number;
}
declare class VideoSnapshot {
    videoUrl: string;
    constructor(blob: Blob);
    takeSnapshot(time?: VideoTime): Promise<string>;
    end(): void;
    private loadVideo;
    getDimensions: () => Promise<Dimensions>;
    private revoke();
    private getSmartTime(time, duration?);
}
export default VideoSnapshot;
