/*!
 * videojs-record
 * @version 2.4.1
 * @see https://github.com/collab-project/videojs-record
 * @copyright 2014-2018 Collab
 * @license MIT
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t(require("videojs")):"function"==typeof define&&define.amd?define("VideojsRecord",["videojs"],t):"object"==typeof exports?exports.VideojsRecord=t(require("videojs")):e.VideojsRecord=t(e.videojs)}(window,function(e){return function(e){var t={};function i(r){if(t[r])return t[r].exports;var o=t[r]={i:r,l:!1,exports:{}};return e[r].call(o.exports,o,o.exports,i),o.l=!0,o.exports}return i.m=e,i.c=t,i.d=function(e,t,r){i.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:r})},i.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},i.t=function(e,t){if(1&t&&(e=i(e)),8&t)return e;if(4&t&&"object"==typeof e&&e&&e.__esModule)return e;var r=Object.create(null);if(i.r(r),Object.defineProperty(r,"default",{enumerable:!0,value:e}),2&t&&"string"!=typeof e)for(var o in e)i.d(r,o,function(t){return e[t]}.bind(null,o));return r},i.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return i.d(t,"a",t),t},i.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},i.p="",i(i.s=3)}([function(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.isSafari=t.isChrome=t.isOpera=t.isEdge=t.detectBrowser=void 0;var r=function(e){return e&&e.__esModule?e:{default:e}}(i(14));var o=function(){var e={browser:null,version:null,minVersion:null};if(void 0===r.default||!r.default.navigator)return e.browser="Not a supported browser.",e;if(navigator.mozGetUserMedia)e.browser="firefox",e.version=n(navigator.userAgent,/Firefox\/(\d+)\./,1),e.minVersion=31;else if(navigator.webkitGetUserMedia)e.browser="chrome",e.version=n(navigator.userAgent,/Chrom(e|ium)\/(\d+)\./,2),e.minVersion=38;else if(navigator.mediaDevices&&navigator.userAgent.match(/Edge\/(\d+).(\d+)$/))e.browser="edge",e.version=n(navigator.userAgent,/Edge\/(\d+).(\d+)$/,2),e.minVersion=10547;else{if(!r.default.RTCPeerConnection||!navigator.userAgent.match(/AppleWebKit\/(\d+)\./))return e.browser="Not a supported browser.",e;e.browser="safari",e.version=n(navigator.userAgent,/AppleWebKit\/(\d+)\./,1)}return e},n=function(e,t,i){var r=e.match(t);return r&&r.length>=i&&parseInt(r[i],10)};t.detectBrowser=o,t.isEdge=function(){return"edge"===o().browser},t.isOpera=function(){return!!r.default.opera||-1!==navigator.userAgent.indexOf("OPR/")},t.isChrome=function(){return"chrome"===o().browser},t.isSafari=function(){return"safari"===o().browser}},function(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var r=function(){function e(e,t){for(var i=0;i<t.length;i++){var r=t[i];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}return function(t,i,r){return i&&e(t.prototype,i),r&&e(t,r),t}}();var o=videojs.getComponent("Component"),n=function(e){function t(e,i){return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,t),i.evented=!0,function(e,t){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!t||"object"!=typeof t&&"function"!=typeof t?e:t}(this,(t.__proto__||Object.getPrototypeOf(t)).call(this,e,i))}return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t);e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)}(t,o),r(t,[{key:"dispose",value:function(){void 0!==this.recordedData&&URL.revokeObjectURL(this.recordedData)}},{key:"addFileInfo",value:function(e){if(e instanceof Blob||e instanceof File){var t=new Date;try{e.lastModified=t.getTime(),e.lastModifiedDate=t}catch(e){if(!(e instanceof TypeError))throw e}var i="."+e.type.split("/")[1];i.indexOf(";")>-1&&(i=i.split(";")[0]);try{e.name=t.getTime()+i}catch(e){if(!(e instanceof TypeError))throw e}}}},{key:"onStopRecording",value:function(e){this.recordedData=e,this.addFileInfo(this.recordedData),this.dispose(),this.trigger("recordComplete")}},{key:"saveAs",value:function(e){var t=e[Object.keys(e)[0]];if(void 0!==navigator.msSaveOrOpenBlob)return navigator.msSaveOrOpenBlob(this.recordedData,t);if(void 0!==navigator.msSaveBlob)return navigator.msSaveBlob(this.recordedData,t);var i=document.createElement("a");i.href=URL.createObjectURL(this.recordedData),i.download=t,i.style="display:none;opacity:0;color:transparent;",(document.body||document.documentElement).appendChild(i),"function"==typeof i.click?i.click():(i.target="_blank",i.dispatchEvent(new MouseEvent("click",{view:window,bubbles:!0,cancelable:!0}))),URL.revokeObjectURL(i.href)}}]),t}();videojs.RecordEngine=n,o.registerComponent("RecordEngine",n),t.RecordEngine=n,t.RECORDRTC="recordrtc",t.LIBVORBISJS="libvorbis.js",t.RECORDERJS="recorder.js",t.LAMEJS="lamejs",t.OPUSRECORDER="opus-recorder"},function(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var r=function(e){return e===Object(e)||!0===e};t.getRecorderMode=function(e,t,i,o){return r(e)?"image_only":r(o)?"animation":r(t)&&!r(i)?"audio_only":r(t)&&r(i)?"audio_video":!r(t)&&r(i)?"video_only":void 0},t.IMAGE_ONLY="image_only",t.AUDIO_ONLY="audio_only",t.VIDEO_ONLY="video_only",t.AUDIO_VIDEO="audio_video",t.ANIMATION="animation"},function(e,t,i){i(4),e.exports=i(18)},function(e,t,i){"use strict";var r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},o=function(){function e(e,t){for(var i=0;i<t.length;i++){var r=t[i];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}return function(t,i,r){return i&&e(t.prototype,i),r&&e(t,r),t}}(),n=b(i(5)),a=b(i(6)),s=b(i(7)),c=b(i(8)),u=b(i(9)),l=b(i(10)),d=b(i(11)),p=b(i(12)),h=b(i(13)),f=i(0),y=b(i(16)),v=i(1),m=i(2),g=b(i(17));function b(e){return e&&e.__esModule?e:{default:e}}var O=g.default.getPlugin("plugin");g.default.getComponent("Player").prototype.play=function(){var e=this.techGet_("play");return void 0!==e&&"function"==typeof e.then&&e.then(null,function(e){}),e};var _=function(e){function t(e,i){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,t);var r=function(e,t){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!t||"object"!=typeof t&&"function"!=typeof t?e:t}(this,(t.__proto__||Object.getPrototypeOf(t)).call(this,e,i));e.addClass("vjs-record"),r.loadOptions(),r.resetState();var o="av-perm";switch(r.getRecordType()){case m.IMAGE_ONLY:case m.VIDEO_ONLY:case m.ANIMATION:o="video-perm";break;case m.AUDIO_ONLY:o="audio-perm"}return s.default.prototype.buildCSSClass=function(){return"vjs-record vjs-device-button vjs-control vjs-icon-"+o},e.deviceButton=new s.default(e,i),e.addChild(e.deviceButton),e.recordIndicator=new l.default(e,i),e.recordIndicator.hide(),e.addChild(e.recordIndicator),e.recordCanvas=new a.default(e,i),e.recordCanvas.hide(),e.addChild(e.recordCanvas),e.animationDisplay=new n.default(e,i),e.animationDisplay.hide(),e.addChild(e.animationDisplay),e.cameraButton=new c.default(e,i),e.cameraButton.hide(),e.recordToggle=new u.default(e,i),e.recordToggle.hide(),r.player.one("ready",r.setupUI.bind(r)),r}return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t);e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)}(t,O),o(t,[{key:"loadOptions",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},t=g.default.mergeOptions(d.default,this.player.options_.plugins.record,e);this.recordImage=t.image,this.recordAudio=t.audio,this.recordVideo=t.video,this.recordAnimation=t.animation,this.maxLength=t.maxLength,this.debug=t.debug,this.recordTimeSlice=t.timeSlice,this.autoMuteDevice=t.autoMuteDevice,this.videoFrameWidth=t.frameWidth,this.videoFrameHeight=t.frameHeight,this.videoRecorderType=t.videoRecorderType,this.videoMimeType=t.videoMimeType,this.audioEngine=t.audioEngine,this.audioRecorderType=t.audioRecorderType,this.audioWorkerURL=t.audioWorkerURL,this.audioBufferSize=t.audioBufferSize,this.audioSampleRate=t.audioSampleRate,this.audioBitRate=t.audioBitRate,this.audioChannels=t.audioChannels,this.audioMimeType=t.audioMimeType,this.animationFrameRate=t.animationFrameRate,this.animationQuality=t.animationQuality}},{key:"setupUI",value:function(){var e=this;switch(this.player.controlBar.addChild(this.player.cameraButton),this.player.controlBar.el().insertBefore(this.player.cameraButton.el(),this.player.controlBar.el().firstChild),this.player.controlBar.el().insertBefore(this.player.recordToggle.el(),this.player.controlBar.el().firstChild),void 0!==this.player.controlBar.remainingTimeDisplay&&(this.player.controlBar.remainingTimeDisplay.el().style.display="none"),void 0!==this.player.controlBar.liveDisplay&&(this.player.controlBar.liveDisplay.el().style.display="none"),this.player.loop(!1),this.getRecordType()){case m.AUDIO_ONLY:this.surfer=this.player.wavesurfer();break;case m.IMAGE_ONLY:case m.VIDEO_ONLY:case m.AUDIO_VIDEO:case m.ANIMATION:this.player.bigPlayButton.hide(),this.player.one("loadedmetadata",function(){e.setDuration(e.maxLength)}),!0===this.player.usingNativeControls_&&void 0!==this.player.tech_.el_&&(this.player.tech_.el_.controls=!1),this.player.removeTechControlsListeners_(),this.player.options_.controls&&(this.player.controlBar.progressControl.hide(),this.player.on("userinactive",function(t){e.player.userActive(!0)}),this.player.controlBar.show(),this.player.controlBar.el().style.display="flex")}this.player.off("timeupdate"),this.player.off("durationchange"),this.player.off("loadedmetadata"),this.setDuration(this.maxLength),this.player.controlBar.playToggle.hide()}},{key:"isRecording",value:function(){return this._recording}},{key:"isProcessing",value:function(){return this._processing}},{key:"isDestroyed",value:function(){return this.player&&null===this.player.children()}},{key:"getDevice",value:function(){switch(void 0===this.deviceReadyCallback&&(this.deviceReadyCallback=this.onDeviceReady.bind(this)),void 0===this.deviceErrorCallback&&(this.deviceErrorCallback=this.onDeviceError.bind(this)),void 0===this.engineStopCallback&&(this.engineStopCallback=this.onRecordComplete.bind(this)),this.getRecordType()){case m.AUDIO_ONLY:this.mediaType={audio:"auto"===this.audioRecorderType||this.audioRecorderType,video:!1},this.surfer.surfer.microphone.un("deviceReady",this.deviceReadyCallback),this.surfer.surfer.microphone.un("deviceError",this.deviceErrorCallback),this.surfer.surfer.microphone.on("deviceReady",this.deviceReadyCallback),this.surfer.surfer.microphone.on("deviceError",this.deviceErrorCallback),this.surfer.setupPlaybackEvents(!1),this.surfer.liveMode=!0,this.surfer.surfer.microphone.paused=!1,this.surfer.surfer.microphone.start();break;case m.IMAGE_ONLY:case m.VIDEO_ONLY:this.mediaType={audio:!1,video:"auto"===this.videoRecorderType||this.videoRecorderType},navigator.mediaDevices.getUserMedia({audio:!1,video:this.getRecordType()===m.IMAGE_ONLY?this.recordImage:this.recordVideo}).then(this.onDeviceReady.bind(this)).catch(this.onDeviceError.bind(this));break;case m.AUDIO_VIDEO:this.mediaType={audio:"auto"===this.audioRecorderType||this.audioRecorderType,video:"auto"===this.videoRecorderType||this.videoRecorderType},navigator.mediaDevices.getUserMedia({audio:this.recordAudio,video:this.recordVideo}).then(this.onDeviceReady.bind(this)).catch(this.onDeviceError.bind(this));break;case m.ANIMATION:this.mediaType={audio:!1,video:!1,gif:!0},navigator.mediaDevices.getUserMedia({audio:!1,video:this.recordAnimation}).then(this.onDeviceReady.bind(this)).catch(this.onDeviceError.bind(this))}}},{key:"onDeviceReady",value:function(e){var t=this;if(this._deviceActive=!0,this.stream=e,this.player.deviceButton.hide(),this.setDuration(this.maxLength),this.setCurrentTime(0),this.player.controlBar.playToggle.hide(),this.off(this.player,"timeupdate",this.playbackTimeUpdate),this.off(this.player,"ended",this.playbackTimeUpdate),this.getRecordType()!==m.IMAGE_ONLY){if(this.getRecordType()!==m.AUDIO_ONLY&&(this.audioEngine===v.LIBVORBISJS||this.audioEngine===v.RECORDERJS||this.audioEngine===v.LAMEJS||this.audioEngine===v.OPUSRECORDER))throw new Error("Currently "+this.audioEngine+" is only supported in audio-only mode.");var i;switch(this.audioEngine){case v.RECORDRTC:i=y.default;break;case v.LIBVORBISJS:i=g.default.LibVorbisEngine;break;case v.RECORDERJS:i=g.default.RecorderjsEngine;break;case v.LAMEJS:i=g.default.LamejsEngine;break;case v.OPUSRECORDER:i=g.default.OpusRecorderEngine;break;default:throw new Error("Unknown audioEngine: "+this.audioEngine)}try{this.engine=new i(this.player,this.player.options_)}catch(e){throw console.error(e),new Error("Could not load "+this.audioEngine+" plugin")}this.engine.on("recordComplete",this.engineStopCallback),this.engine.bufferSize=this.audioBufferSize,this.engine.sampleRate=this.audioSampleRate,this.engine.bitRate=this.audioBitRate,this.engine.audioChannels=this.audioChannels,this.engine.audioWorkerURL=this.audioWorkerURL,this.engine.mimeType={video:this.videoMimeType,gif:"image/gif"},null!==this.audioMimeType&&"auto"!==this.audioMimeType&&(this.engine.mimeType.audio=this.audioMimeType),this.engine.video={width:this.videoFrameWidth,height:this.videoFrameHeight},this.engine.canvas={width:this.videoFrameWidth,height:this.videoFrameHeight},this.engine.quality=this.animationQuality,this.engine.frameRate=this.animationFrameRate,this.recordTimeSlice&&this.recordTimeSlice>0&&(this.engine.timeSlice=this.recordTimeSlice,this.engine.onTimeStamp=this.onTimeStamp.bind(this)),this.engine.setup(this.stream,this.mediaType,this.debug),[this.player.controlBar.currentTimeDisplay,this.player.controlBar.timeDivider,this.player.controlBar.durationDisplay].forEach(function(e){void 0!==e&&(e.el().style.display="block",e.show())}),this.player.recordToggle.show()}else this.player.recordIndicator.disable(),this.retrySnapshot(),this.player.cameraButton.onStop(),this.player.cameraButton.show();this.getRecordType()!==m.AUDIO_ONLY?(this.mediaElement=this.player.el().firstChild,this.mediaElement.controls=!1,this.mediaElement.muted=!0,this.displayVolumeControl(!1),this.load(this.stream),this.player.one("loadedmetadata",function(){t.mediaElement.play(),t.player.trigger("deviceReady")})):this.player.trigger("deviceReady")}},{key:"onDeviceError",value:function(e){this._deviceActive=!1,this.player.deviceErrorCode=e,this.player.trigger("deviceError")}},{key:"start",value:function(){var e=this;if(!this.isProcessing()){switch(this._recording=!0,this.player.controlBar.playToggle.hide(),this.off(this.player,"timeupdate",this.playbackTimeUpdate),this.off(this.player,"ended",this.playbackTimeUpdate),this.getRecordType()){case m.AUDIO_ONLY:this.surfer.setupPlaybackEvents(!1),this.surfer.surfer.microphone.paused=!1,this.surfer.liveMode=!0,this.surfer.surfer.microphone.play();break;case m.VIDEO_ONLY:case m.AUDIO_VIDEO:this.startVideoPreview();break;case m.ANIMATION:this.player.recordCanvas.hide(),this.player.animationDisplay.hide(),this.mediaElement.style.display="block",this.captureFrame().then(function(t){e.startVideoPreview()})}switch(this.autoMuteDevice&&this.muteTracks(!1),this.getRecordType()){case m.IMAGE_ONLY:this.createSnapshot(),this.player.trigger("startRecord");break;case m.VIDEO_ONLY:case m.AUDIO_VIDEO:case m.ANIMATION:this.player.one("loadedmetadata",function(){e.startRecording()});break;default:this.startRecording()}}}},{key:"startRecording",value:function(){this.paused=!1,this.pauseTime=this.pausedTime=0,this.startTime=(new Date).getTime(),this.countDown=this.player.setInterval(this.onCountDown.bind(this),100),void 0!==this.engine&&this.engine.dispose(),this.engine.start(),this.player.trigger("startRecord")}},{key:"stop",value:function(){this.isProcessing()||(this._recording=!1,this._processing=!0,this.getRecordType()!==m.IMAGE_ONLY?(this.player.trigger("stopRecord"),this.player.clearInterval(this.countDown),this.engine&&this.engine.stop(),this.autoMuteDevice&&this.muteTracks(!0)):this.player.recordedData&&this.player.trigger("finishRecord"))}},{key:"stopDevice",value:function(){this.isRecording()?(this.player.one("finishRecord",this.stopStream.bind(this)),this.stop()):this.stopStream()}},{key:"stopStream",value:function(){if(this.stream){if(this._deviceActive=!1,this.getRecordType()===m.AUDIO_ONLY)return void this.surfer.surfer.microphone.stopDevice();this.stream.getTracks().forEach(function(e){e.stop()})}}},{key:"pause",value:function(){this.paused||(this.pauseTime=(new Date).getTime(),this.paused=!0,this.engine.pause())}},{key:"resume",value:function(){this.paused&&(this.pausedTime+=(new Date).getTime()-this.pauseTime,this.engine.resume(),this.paused=!1)}},{key:"onRecordComplete",value:function(){var e=this;switch(this.player.recordedData=this.engine.recordedData,this.player.controlBar.playToggle.removeClass("vjs-ended"),this.player.controlBar.playToggle.show(),this.player.trigger("finishRecord"),this.getRecordType()){case m.AUDIO_ONLY:this.surfer.pause(),this.surfer.setupPlaybackEvents(!0),this.player.loadingSpinner.show(),this.surfer.surfer.once("ready",function(){e._processing=!1}),this.load(this.player.recordedData);break;case m.VIDEO_ONLY:case m.AUDIO_VIDEO:this.player.one("pause",function(){e._processing=!1,e.player.loadingSpinner.hide(),e.setDuration(e.streamDuration),e.on(e.player,"timeupdate",e.playbackTimeUpdate),e.on(e.player,"ended",e.playbackTimeUpdate),e.getRecordType()===m.AUDIO_VIDEO&&(e.mediaElement.muted=!1,e.displayVolumeControl(!0)),(0,f.isChrome)()&&e.getRecordType()===m.AUDIO_VIDEO?e.load(e.player.recordedData.video):e.load(e.player.recordedData)}),this.player.pause();break;case m.ANIMATION:this._processing=!1,this.player.loadingSpinner.hide(),this.setDuration(this.streamDuration),this.mediaElement.style.display="none",this.player.recordCanvas.show(),this.player.pause(),this.on(this.player,"play",this.showAnimation),this.on(this.player,"pause",this.hideAnimation)}}},{key:"onCountDown",value:function(){if(!this.paused){var e=(new Date).getTime(),t=this.maxLength,i=(e-(this.startTime+this.pausedTime))/1e3;this.streamDuration=i,i>=t&&(i=t,this.stop()),this.setDuration(t),this.setCurrentTime(i,t),this.player.trigger("progressRecord")}}},{key:"getCurrentTime",value:function(){var e=isNaN(this.streamCurrentTime)?0:this.streamCurrentTime;return this.getRecordType()===m.AUDIO_ONLY&&(e=this.surfer.getCurrentTime()),e}},{key:"setCurrentTime",value:function(e,t){switch(e=isNaN(e)?0:e,t=isNaN(t)?0:t,this.getRecordType()){case m.AUDIO_ONLY:this.surfer.setCurrentTime(e,t);break;case m.VIDEO_ONLY:case m.AUDIO_VIDEO:case m.ANIMATION:this.streamCurrentTime=Math.min(e,t),this.player.controlBar.currentTimeDisplay.formattedTime_=this.player.controlBar.currentTimeDisplay.contentEl().lastChild.textContent=(0,p.default)(this.streamCurrentTime,t,this.msDisplayMax)}}},{key:"getDuration",value:function(){return isNaN(this.streamDuration)?0:this.streamDuration}},{key:"setDuration",value:function(e){switch(e=isNaN(e)?0:e,this.getRecordType()){case m.AUDIO_ONLY:this.surfer.setDuration(e);break;case m.VIDEO_ONLY:case m.AUDIO_VIDEO:case m.ANIMATION:this.player.controlBar.durationDisplay.formattedTime_=this.player.controlBar.durationDisplay.contentEl().lastChild.textContent=(0,p.default)(e,e,this.msDisplayMax)}}},{key:"load",value:function(e){switch(this.getRecordType()){case m.AUDIO_ONLY:this.surfer.load(e);break;case m.IMAGE_ONLY:case m.VIDEO_ONLY:case m.AUDIO_VIDEO:case m.ANIMATION:e instanceof Blob||e instanceof File?(0,h.default)(e,this.mediaElement,!1):(0,h.default)(e,this.mediaElement,!0)}}},{key:"saveAs",value:function(e){this.engine&&void 0!==e&&this.engine.saveAs(e)}},{key:"dispose",value:function(){this.player.off("ready"),this.player.off("userinactive"),this.player.off("loadedmetadata"),this.engine&&(this.engine.dispose(),this.engine.off("recordComplete",this.engineStopCallback)),this.stop(),this.stopDevice(),this.player.clearInterval(this.countDown),this.getRecordType()==m.AUDIO_ONLY&&this.surfer&&this.surfer.destroy(),this.resetState(),function e(t,i,r){null===t&&(t=Function.prototype);var o=Object.getOwnPropertyDescriptor(t,i);if(void 0===o){var n=Object.getPrototypeOf(t);return null===n?void 0:e(n,i,r)}if("value"in o)return o.value;var a=o.get;return void 0!==a?a.call(r):void 0}(t.prototype.__proto__||Object.getPrototypeOf(t.prototype),"dispose",this).call(this)}},{key:"destroy",value:function(){this.player.dispose()}},{key:"reset",value:function(){var e=this;switch(this.engine&&(this.engine.dispose(),this.engine.off("recordComplete",this.engineStopCallback)),this.stop(),this.stopDevice(),this.player.clearInterval(this.countDown),this.loadOptions(),this.resetState(),this.setDuration(this.maxLength),this.setCurrentTime(0),this.player.reset(),this.getRecordType()){case m.AUDIO_ONLY:this.surfer&&this.surfer.surfer&&this.surfer.surfer.empty();break;case m.IMAGE_ONLY:case m.ANIMATION:this.player.recordCanvas.hide(),this.player.cameraButton.hide()}this.player.controlBar.playToggle.hide(),this.player.deviceButton.show(),this.player.recordToggle.hide(),this.player.one("loadedmetadata",function(){e.setDuration(e.maxLength)})}},{key:"resetState",value:function(){this._recording=!1,this._processing=!1,this._deviceActive=!1,this.devices=[]}},{key:"muteTracks",value:function(e){(this.getRecordType()===m.AUDIO_ONLY||this.getRecordType()===m.AUDIO_VIDEO)&&this.stream.getAudioTracks().length>0&&(this.stream.getAudioTracks()[0].enabled=!e),this.getRecordType()!==m.AUDIO_ONLY&&this.stream.getVideoTracks().length>0&&(this.stream.getVideoTracks()[0].enabled=!e)}},{key:"getRecordType",value:function(){return(0,m.getRecorderMode)(this.recordImage,this.recordAudio,this.recordVideo,this.recordAnimation)}},{key:"createSnapshot",value:function(){var e=this;this.captureFrame().then(function(t){e.player.recordedData=t.toDataURL("image/png"),e.mediaElement.style.display="none",e.player.recordCanvas.show(),e.stop()})}},{key:"retrySnapshot",value:function(){this._processing=!1,this.player.recordCanvas.hide(),this.player.el().firstChild.style.display="block"}},{key:"captureFrame",value:function(){var e=this,t=(0,f.detectBrowser)(),i=this.player.recordCanvas.el().firstChild;return i.width=this.player.width(),i.height=this.player.height(),new Promise(function(o,n){if("chrome"===t.browser&&t.version>=60&&("undefined"==typeof ImageCapture?"undefined":r(ImageCapture))===("undefined"==typeof Function?"undefined":r(Function)))try{var a=e.stream.getVideoTracks()[0];new ImageCapture(a).grabFrame().then(function(t){e.drawCanvas(i,t),o(i)}).catch(function(e){})}catch(e){}e.drawCanvas(i,e.mediaElement),o(i)})}},{key:"drawCanvas",value:function(e,t){e.getContext("2d").drawImage(t,0,0,e.width,e.height)}},{key:"startVideoPreview",value:function(){this.off("timeupdate"),this.off("durationchange"),this.off("loadedmetadata"),this.off("play"),this.mediaElement.muted=!0,this.displayVolumeControl(!1),this.load(this.stream),this.mediaElement.play()}},{key:"showAnimation",value:function(){var e=this.player.animationDisplay.el().firstChild;e.width=this.player.width(),e.height=this.player.height(),this.player.recordCanvas.hide(),(0,h.default)(this.player.recordedData,e,!1),this.player.animationDisplay.show()}},{key:"hideAnimation",value:function(){this.player.recordCanvas.show(),this.player.animationDisplay.hide()}},{key:"playbackTimeUpdate",value:function(){this.setCurrentTime(this.player.currentTime(),this.streamDuration)}},{key:"onTimeStamp",value:function(e,t){var i;switch(this.player.currentTimestamp=e,this.player.allTimestamps=t,this.getRecordType()){case m.AUDIO_ONLY:i=this.engine.engine.audioRecorder;break;case m.ANIMATION:i=this.engine.engine.gifRecorder;break;default:i=this.engine.engine.videoRecorder}(i=i.getInternalRecorder())instanceof MediaStreamRecorder==!0&&(this.player.recordedData=i.getArrayOfBlobs(),this.engine.addFileInfo(this.player.recordedData[this.player.recordedData.length-1])),this.player.trigger("timestamp")}},{key:"enumerateDevices",value:function(){var e=this;if(!navigator.mediaDevices||!navigator.mediaDevices.enumerateDevices)return this.player.enumerateErrorCode="enumerateDevices() not supported.",void this.player.trigger("enumerateError");navigator.mediaDevices.enumerateDevices(this).then(function(t){e.devices=[],t.forEach(function(t){e.devices.push(t)}),e.player.trigger("enumerateReady")}).catch(function(t){e.player.enumerateErrorCode=t,e.player.trigger("enumerateError")})}},{key:"setAudioOutput",value:function(e){var t=this,i=void 0;switch(this.getRecordType()){case m.AUDIO_ONLY:this.surfer.surfer.setSinkId(e).then(function(e){t.player.trigger("audioOutputReady")}).catch(function(e){i=e});break;default:var r=player.tech_.el_;e?void 0!==r.sinkId?r.setSinkId(e).then(function(e){t.player.trigger("audioOutputReady")}).catch(function(e){i=e}):i="Browser does not support audio output device selection.":i="Invalid deviceId: "+e}this.player.trigger("error",i)}},{key:"displayVolumeControl",value:function(e){void 0!==this.player.controlBar.volumePanel&&(e=!0===e?"flex":"none",this.player.controlBar.volumePanel.el().style.display=e)}}]),t}();_.VERSION="2.4.1",g.default.Record=_,void 0===g.default.getPlugin("record")&&g.default.registerPlugin("record",_),e.exports={Record:_}},function(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var r=function(){function e(e,t){for(var i=0;i<t.length;i++){var r=t[i];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}return function(t,i,r){return i&&e(t.prototype,i),r&&e(t,r),t}}();var o=videojs.getComponent("Component"),n=function(e){function t(){return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,t),function(e,t){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!t||"object"!=typeof t&&"function"!=typeof t?e:t}(this,(t.__proto__||Object.getPrototypeOf(t)).apply(this,arguments))}return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t);e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)}(t,o),r(t,[{key:"createEl",value:function(){return function e(t,i,r){null===t&&(t=Function.prototype);var o=Object.getOwnPropertyDescriptor(t,i);if(void 0===o){var n=Object.getPrototypeOf(t);return null===n?void 0:e(n,i,r)}if("value"in o)return o.value;var a=o.get;return void 0!==a?a.call(r):void 0}(t.prototype.__proto__||Object.getPrototypeOf(t.prototype),"createEl",this).call(this,"div",{className:"vjs-animation-display",innerHTML:"<img />"})}}]),t}();o.registerComponent("AnimationDisplay",n),t.default=n,e.exports=t.default},function(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var r=function(){function e(e,t){for(var i=0;i<t.length;i++){var r=t[i];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}return function(t,i,r){return i&&e(t.prototype,i),r&&e(t,r),t}}();var o=videojs.getComponent("Component"),n=function(e){function t(){return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,t),function(e,t){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!t||"object"!=typeof t&&"function"!=typeof t?e:t}(this,(t.__proto__||Object.getPrototypeOf(t)).apply(this,arguments))}return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t);e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)}(t,o),r(t,[{key:"createEl",value:function(){return function e(t,i,r){null===t&&(t=Function.prototype);var o=Object.getOwnPropertyDescriptor(t,i);if(void 0===o){var n=Object.getPrototypeOf(t);return null===n?void 0:e(n,i,r)}if("value"in o)return o.value;var a=o.get;return void 0!==a?a.call(r):void 0}(t.prototype.__proto__||Object.getPrototypeOf(t.prototype),"createEl",this).call(this,"div",{className:"vjs-record-canvas",innerHTML:"<canvas></canvas>"})}}]),t}();o.registerComponent("RecordCanvas",n),t.default=n,e.exports=t.default},function(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var r=function(){function e(e,t){for(var i=0;i<t.length;i++){var r=t[i];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}return function(t,i,r){return i&&e(t.prototype,i),r&&e(t,r),t}}();var o=videojs.getComponent("Button"),n=videojs.getComponent("Component"),a=function(e){function t(){return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,t),function(e,t){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!t||"object"!=typeof t&&"function"!=typeof t?e:t}(this,(t.__proto__||Object.getPrototypeOf(t)).apply(this,arguments))}return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t);e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)}(t,o),r(t,[{key:"handleClick",value:function(e){this.player_.record().getDevice()}}]),t}();a.prototype.controlText_="Device",n.registerComponent("DeviceButton",a),t.default=a,e.exports=t.default},function(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var r=function(){function e(e,t){for(var i=0;i<t.length;i++){var r=t[i];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}return function(t,i,r){return i&&e(t.prototype,i),r&&e(t,r),t}}(),o=function e(t,i,r){null===t&&(t=Function.prototype);var o=Object.getOwnPropertyDescriptor(t,i);if(void 0===o){var n=Object.getPrototypeOf(t);return null===n?void 0:e(n,i,r)}if("value"in o)return o.value;var a=o.get;return void 0!==a?a.call(r):void 0};var n=videojs.getComponent("Button"),a=videojs.getComponent("Component"),s=function(e){function t(){return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,t),function(e,t){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!t||"object"!=typeof t&&"function"!=typeof t?e:t}(this,(t.__proto__||Object.getPrototypeOf(t)).apply(this,arguments))}return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t);e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)}(t,n),r(t,[{key:"buildCSSClass",value:function(){return"vjs-camera-button vjs-control vjs-button vjs-icon-photo-camera"}},{key:"enable",value:function(){o(t.prototype.__proto__||Object.getPrototypeOf(t.prototype),"enable",this).call(this),this.on(this.player_,"startRecord",this.onStart),this.on(this.player_,"stopRecord",this.onStop)}},{key:"disable",value:function(){o(t.prototype.__proto__||Object.getPrototypeOf(t.prototype),"disable",this).call(this),this.off(this.player_,"startRecord",this.onStart),this.off(this.player_,"stopRecord",this.onStop)}},{key:"handleClick",value:function(e){var t=this.player_.record();t.isProcessing()?(t.retrySnapshot(),this.onStop()):t.start()}},{key:"onStart",value:function(e){this.removeClass("vjs-icon-photo-camera"),this.addClass("vjs-icon-replay"),this.controlText("Retry")}},{key:"onStop",value:function(e){this.removeClass("vjs-icon-replay"),this.addClass("vjs-icon-photo-camera"),this.controlText("Image")}}]),t}();s.prototype.controlText_="Image",a.registerComponent("CameraButton",s),t.default=s,e.exports=t.default},function(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var r=function(){function e(e,t){for(var i=0;i<t.length;i++){var r=t[i];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}return function(t,i,r){return i&&e(t.prototype,i),r&&e(t,r),t}}(),o=function e(t,i,r){null===t&&(t=Function.prototype);var o=Object.getOwnPropertyDescriptor(t,i);if(void 0===o){var n=Object.getPrototypeOf(t);return null===n?void 0:e(n,i,r)}if("value"in o)return o.value;var a=o.get;return void 0!==a?a.call(r):void 0};var n=videojs.getComponent("Button"),a=videojs.getComponent("Component"),s=function(e){function t(){return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,t),function(e,t){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!t||"object"!=typeof t&&"function"!=typeof t?e:t}(this,(t.__proto__||Object.getPrototypeOf(t)).apply(this,arguments))}return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t);e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)}(t,n),r(t,[{key:"buildCSSClass",value:function(){return"vjs-record-button vjs-control vjs-button vjs-icon-record-start"}},{key:"enable",value:function(){o(t.prototype.__proto__||Object.getPrototypeOf(t.prototype),"enable",this).call(this),this.on(this.player_,"startRecord",this.onStart),this.on(this.player_,"stopRecord",this.onStop)}},{key:"disable",value:function(){o(t.prototype.__proto__||Object.getPrototypeOf(t.prototype),"disable",this).call(this),this.off(this.player_,"startRecord",this.onStart),this.off(this.player_,"stopRecord",this.onStop)}},{key:"handleClick",value:function(e){var t=this.player_.record();t.isRecording()?t.stop():t.start()}},{key:"onStart",value:function(e){this.removeClass("vjs-icon-record-start"),this.addClass("vjs-icon-record-stop"),this.controlText("Stop")}},{key:"onStop",value:function(e){this.removeClass("vjs-icon-record-stop"),this.addClass("vjs-icon-record-start"),this.controlText("Record")}}]),t}();s.prototype.controlText_="Record",a.registerComponent("RecordToggle",s),t.default=s,e.exports=t.default},function(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var r=function(){function e(e,t){for(var i=0;i<t.length;i++){var r=t[i];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}return function(t,i,r){return i&&e(t.prototype,i),r&&e(t,r),t}}();var o=videojs.getComponent("Component"),n=function(e){function t(e,i){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,t);var r=function(e,t){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!t||"object"!=typeof t&&"function"!=typeof t?e:t}(this,(t.__proto__||Object.getPrototypeOf(t)).call(this,e,i));return r.enable(),r}return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t);e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)}(t,o),r(t,[{key:"createEl",value:function(){return function e(t,i,r){null===t&&(t=Function.prototype);var o=Object.getOwnPropertyDescriptor(t,i);if(void 0===o){var n=Object.getPrototypeOf(t);return null===n?void 0:e(n,i,r)}if("value"in o)return o.value;var a=o.get;return void 0!==a?a.call(r):void 0}(t.prototype.__proto__||Object.getPrototypeOf(t.prototype),"createEl",this).call(this,"div",{className:"vjs-record-indicator vjs-control",dir:"ltr"})}},{key:"enable",value:function(){this.on(this.player_,"startRecord",this.show),this.on(this.player_,"stopRecord",this.hide)}},{key:"disable",value:function(){this.off(this.player_,"startRecord",this.show),this.off(this.player_,"stopRecord",this.hide)}}]),t}();o.registerComponent("RecordIndicator",n),t.default=n,e.exports=t.default},function(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.default={image:!1,audio:!1,video:!1,animation:!1,maxLength:10,frameWidth:320,frameHeight:240,debug:!1,autoMuteDevice:!1,videoMimeType:"video/webm",videoRecorderType:"auto",audioEngine:"recordrtc",audioRecorderType:"auto",audioMimeType:"auto",audioBufferSize:4096,audioSampleRate:44100,audioBitRate:128,audioChannels:2,audioWorkerURL:"",animationFrameRate:200,animationQuality:10,timeSlice:0},e.exports=t.default},function(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.default=function(e,t,i){e=e<0?0:e,t=t||e;var r=Math.floor(e%60),o=Math.floor(e/60%60),n=Math.floor(e/3600),a=Math.floor(t/60%60),s=Math.floor(t/3600),c=Math.floor(1e3*(e-r));return(isNaN(e)||e===1/0)&&(n=o=r=c="-"),t>0&&t<i?(c<100&&(c=c<10?"00"+c:"0"+c),c=":"+c):c="",(n=n>0||s>0?n+":":"")+(o=((n||a>=10)&&o<10?"0"+o:o)+":")+(r=r<10?"0"+r:r)+c},e.exports=t.default},function(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.default=function e(t,i,r){if("createObjectURL"in URL&&!r)try{i.src=URL.createObjectURL(t)}catch(r){return void e(t,i,!0)}else"srcObject"in i?i.srcObject=t:"mozSrcObject"in i?i.mozSrcObject=t:console.log("createObjectURL/srcObject both are not supported.")},e.exports=t.default},function(e,t,i){(function(t){var i;i="undefined"!=typeof window?window:void 0!==t?t:"undefined"!=typeof self?self:{},e.exports=i}).call(this,i(15))},function(e,t){var i;i=function(){return this}();try{i=i||Function("return this")()||(0,eval)("this")}catch(e){"object"==typeof window&&(i=window)}e.exports=i},function(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var r=function(){function e(e,t){for(var i=0;i<t.length;i++){var r=t[i];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}return function(t,i,r){return i&&e(t.prototype,i),r&&e(t,r),t}}(),o=i(1),n=i(0),a=i(2);var s=videojs.getComponent("Component"),c=function(e){function t(){return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,t),function(e,t){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!t||"object"!=typeof t&&"function"!=typeof t?e:t}(this,(t.__proto__||Object.getPrototypeOf(t)).apply(this,arguments))}return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t);e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)}(t,o.RecordEngine),r(t,[{key:"setup",value:function(e,t,i){this.inputStream=e,this.mediaType=t,this.debug=i,this.engine=new RecordRTC.MRecordRTC,this.engine.mediaType=this.mediaType,this.engine.disableLogs=!this.debug,this.engine.mimeType=this.mimeType,this.engine.bufferSize=this.bufferSize,this.engine.sampleRate=this.sampleRate,this.engine.numberOfAudioChannels=this.audioChannels,this.engine.video=this.video,this.engine.canvas=this.canvas,this.engine.quality=this.quality,this.engine.frameRate=this.frameRate,void 0!==this.onTimeStamp&&(this.engine.timeSlice=this.timeSlice,this.engine.onTimeStamp=this.onTimeStamp),this.engine.addStream(this.inputStream)}},{key:"dispose",value:function(){(function e(t,i,r){null===t&&(t=Function.prototype);var o=Object.getOwnPropertyDescriptor(t,i);if(void 0===o){var n=Object.getPrototypeOf(t);return null===n?void 0:e(n,i,r)}if("value"in o)return o.value;var a=o.get;return void 0!==a?a.call(r):void 0})(t.prototype.__proto__||Object.getPrototypeOf(t.prototype),"dispose",this).call(this),"function"==typeof this.engine.destroy&&this.engine.destroy()}},{key:"start",value:function(){this.engine.startRecording()}},{key:"stop",value:function(){this.engine.stopRecording(this.onStopRecording.bind(this))}},{key:"pause",value:function(){this.engine.pauseRecording()}},{key:"resume",value:function(){this.engine.resumeRecording()}},{key:"saveAs",value:function(e){this.engine&&void 0!==e&&this.engine.save(e)}},{key:"onStopRecording",value:function(e,t){var i=this;this.mediaURL=e;var r=this.player().record().getRecordType();this.engine.getBlob(function(e){switch(r){case a.AUDIO_ONLY:i.recordedData=e.audio,i.addFileInfo(i.recordedData),i.trigger("recordComplete");break;case a.VIDEO_ONLY:case a.AUDIO_VIDEO:if(void 0!==e.video){if(i.recordedData=e.video,r===a.AUDIO_VIDEO&&(0,n.isChrome)())for(var t in i.recordedData=e,i.recordedData)i.addFileInfo(i.recordedData[t]);else i.addFileInfo(i.recordedData);i.trigger("recordComplete")}break;case a.ANIMATION:i.recordedData=e.gif,i.addFileInfo(i.recordedData),i.trigger("recordComplete")}})}}]),t}();videojs.RecordRTCEngine=c,s.registerComponent("RecordRTCEngine",c),t.default=c,e.exports=t.default},function(t,i){t.exports=e},function(e,t,i){}])});
//# sourceMappingURL=videojs.record.min.js.map