/**
 * @file event.js
 * @since 3.5.0
 */

class Event {}

// video.js
Event.READY = 'ready';
Event.ERROR = 'error';
Event.PLAYING = 'playing';
Event.LOADEDMETADATA = 'loadedmetadata';
Event.LOADSTART = 'loadstart';
Event.USERINACTIVE = 'userinactive';
Event.TIMEUPDATE = 'timeupdate';
Event.DURATIONCHANGE = 'durationchange';
Event.ENDED = 'ended';
Event.PAUSE = 'pause';
Event.PLAY = 'play';

// videojs-record
Event.DEVICE_READY = 'deviceReady';
Event.DEVICE_ERROR = 'deviceError';
Event.START_RECORD = 'startRecord';
Event.STOP_RECORD = 'stopRecord';
Event.FINISH_RECORD = 'finishRecord';
Event.RECORD_COMPLETE = 'recordComplete';
Event.PROGRESS_RECORD = 'progressRecord';
Event.TIMESTAMP = 'timestamp';
Event.ENUMERATE_READY = 'enumerateReady';
Event.ENUMERATE_ERROR = 'enumerateError';
Event.AUDIO_BUFFER_UPDATE = 'audioBufferUpdate';
Event.AUDIO_OUTPUT_READY = 'audioOutputReady';
Event.START_CONVERT = 'startConvert';
Event.FINISH_CONVERT = 'finishConvert';
Event.ENTER_PIP = 'enterPIP';
Event.LEAVE_PIP = 'leavePIP';
Event.RETRY = 'retry';

// dom
Event.ENTERPICTUREINPICTURE = 'enterpictureinpicture';
Event.LEAVEPICTUREINPICTURE = 'leavepictureinpicture';

// after the freeze, any attempts of altering the class will have no result
Object.freeze(Event);

export default Event;
