/*!
 * vmsg plugin for videojs-record
 * @version 4.8.0
 * @see https://github.com/collab-project/videojs-record
 * @copyright 2014-2024 Collab
 * @license MIT
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t(require("video.js")):"function"==typeof define&&define.amd?define("VideojsRecord",["video.js"],t):"object"==typeof exports?exports.VideojsRecord=t(require("video.js")):(e.VideojsRecord=e.VideojsRecord||{},e.VideojsRecord.vmsg=t(e.videojs))}(self,(e=>(()=>{var t={462:(e,t,r)=>{"use strict";var o=r(994);Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var s=o(r(383)),i=o(r(579)),n=o(r(452)),a=o(r(72)),c=o(r(511)),l=o(r(928)),d=r(855);function u(e,t,r){return t=(0,a.default)(t),(0,n.default)(e,p()?Reflect.construct(t,r||[],(0,a.default)(e).constructor):t.apply(e,r))}function p(){try{var e=!Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){})))}catch(e){}return(p=function(){return!!e})()}var h=function(e){function t(e,r){var o;return(0,s.default)(this,t),(o=u(this,t,[e,r])).debug=!1,o.audioWebAssemblyURL="vmsg.wasm",o.pluginLibraryOptions={},o}return(0,c.default)(t,e),(0,i.default)(t,[{key:"setup",value:function(e,t,r){var o=this;this.inputStream=e,this.mediaType=t,this.debug=r,this.config={wasmURL:this.audioWebAssemblyURL},this.config=Object.assign(this.config,this.pluginLibraryOptions),this.engine=new d.Recorder(this.config,this.onRecordingAvailable.bind(this)),this.engine.stream=this.inputStream;var s=window.AudioContext||window.webkitAudioContext;this.audioContext=new s,this.audioSourceNode=this.audioContext.createMediaStreamSource(this.inputStream),this.processor=this.audioContext.createScriptProcessor(0,1,1),this.audioSourceNode.connect(this.processor),this.engine.initWorker().catch((function(e){o.player().trigger("error",e)}))}},{key:"start",value:function(){this.engine.blob=null,this.engine.blobURL&&URL.revokeObjectURL(this.engine.blobURL),this.engine.blobURL=null,this.engine.worker.postMessage({type:"start",data:this.audioContext.sampleRate}),this.processor.onaudioprocess=this.onAudioProcess.bind(this),this.processor.connect(this.audioContext.destination)}},{key:"stop",value:function(){this.processor&&(this.processor.disconnect(),this.processor.onaudioprocess=null),this.engine&&void 0!==this.engine.worker&&this.engine.worker.postMessage({type:"stop",data:null})}},{key:"destroy",value:function(){this.engine&&"function"==typeof this.engine.close&&this.engine.close()}},{key:"onAudioProcess",value:function(e){var t=e.inputBuffer.getChannelData(0);this.engine.worker.postMessage({type:"data",data:t})}},{key:"onRecordingAvailable",value:function(){this.onStopRecording(this.engine.blob)}}])}(l.default.getComponent("RecordEngine"));l.default.VmsgEngine=h;t.default=h;e.exports=t.default},855:(e,t,r)=>{"use strict";function o(e){return(e|=0)<10?`0${e}`:`${Math.min(e,99)}`}function s(){function e(e,t){return new Promise(((r,o)=>{const s=new XMLHttpRequest;s.open("GET",e),s.responseType="arraybuffer",s.onload=()=>{r(WebAssembly.instantiate(s.response,t))},s.onerror=o,s.send()}))}let t=null,r=5242880;function o(e){const t=r;return r+=e,t}function s(e){postMessage({type:"internal-error",data:e})}let i=null,n=null,a=null;onmessage=r=>{const c=r.data;switch(c.type){case"init":const{wasmURL:r,shimURL:d}=c.data;Promise.resolve().then((()=>(self.WebAssembly&&!function(){const e=new Uint8Array([0,97,115,109,1,0,0,0,1,6,1,96,1,127,1,127,3,2,1,0,5,3,1,0,1,7,8,1,4,116,101,115,116,0,0,10,16,1,14,0,32,0,65,1,54,2,0,32,0,40,2,0,11]),t=new WebAssembly.Module(e);return 0!==new WebAssembly.Instance(t,{}).exports.test(4)}()&&delete self.WebAssembly,self.WebAssembly||importScripts(d),t=new WebAssembly.Memory({initial:256,maximum:256}),{memory:t,pow:Math.pow,exit:s,powf:Math.pow,exp:Math.exp,sqrtf:Math.sqrt,cos:Math.cos,log:Math.log,sin:Math.sin,sbrk:o}))).then((t=>function(t,r){if(!WebAssembly.instantiateStreaming)return e(t,r);const o=fetch(t,{credentials:"same-origin"});return WebAssembly.instantiateStreaming(o,r).catch((o=>{if(o.message&&o.message.indexOf("Argument 0 must be provided and must be a Response")>0)return e(t,r);throw o}))}(r,{env:t}))).then((e=>{i=e.instance.exports,postMessage({type:"init",data:null})})).catch((e=>{postMessage({type:"init-error",data:e.toString()})}));break;case"start":if(!function(e){if(n=i.vmsg_init(e),!n)return!1;const r=new Uint32Array(t.buffer,n,1)[0];return a=new Float32Array(t.buffer,r),!0}(c.data))return postMessage({type:"error",data:"vmsg_init"});break;case"data":if(l=c.data,a.set(l),!(i.vmsg_encode(n,l.length)>=0))return postMessage({type:"error",data:"vmsg_encode"});break;case"stop":const u=function(){if(i.vmsg_flush(n)<0)return null;const e=new Uint32Array(t.buffer,n+4,1)[0],r=new Uint32Array(t.buffer,n+8,1)[0],o=new Uint8Array(t.buffer,e,r),s=new Blob([o],{type:"audio/mpeg"});return i.vmsg_free(n),n=null,a=null,s}();if(!u)return postMessage({type:"error",data:"vmsg_flush"});postMessage({type:"stop",data:u})}var l}}r.r(t),r.d(t,{Form:()=>n,Recorder:()=>i,default:()=>l,record:()=>c});class i{constructor(e={},t=null){this.wasmURL=new URL(e.wasmURL||"/static/js/vmsg.wasm",location).href,this.shimURL=new URL(e.shimURL||"/static/js/wasm-polyfill.js",location).href,this.onStop=t,this.pitch=e.pitch||0,this.stream=null,this.audioCtx=null,this.gainNode=null,this.pitchFX=null,this.encNode=null,this.worker=null,this.workerURL=null,this.blob=null,this.blobURL=null,this.resolve=null,this.reject=null,Object.seal(this)}close(){this.encNode&&this.encNode.disconnect(),this.encNode&&(this.encNode.onaudioprocess=null),this.stream&&this.stopTracks(),this.audioCtx&&this.audioCtx.close(),this.worker&&(this.worker.terminate(),this.worker=null),this.workerURL&&URL.revokeObjectURL(this.workerURL),this.blobURL&&URL.revokeObjectURL(this.blobURL)}initAudio(){return(navigator.mediaDevices&&navigator.mediaDevices.getUserMedia?function(e){return navigator.mediaDevices.getUserMedia(e)}:function(e){const t=navigator.webkitGetUserMedia||navigator.mozGetUserMedia;return t?new Promise((function(r,o){t.call(navigator,e,r,o)})):Promise.reject(new Error("getUserMedia is not implemented in this browser"))})({audio:!0}).then((e=>{this.stream=e;const t=this.audioCtx=new(window.AudioContext||window.webkitAudioContext),r=t.createMediaStreamSource(e),o=this.gainNode=(t.createGain||t.createGainNode).call(t);o.gain.value=1,r.connect(o);const s=this.pitchFX=new f(t);s.setPitchOffset(this.pitch);const i=this.encNode=(t.createScriptProcessor||t.createJavaScriptNode).call(t,0,1,1);s.output.connect(i),o.connect(0===this.pitch?i:s.input)}))}initWorker(){if(this.worker)return Promise.resolve();const e=new Blob(["(",s.toString(),")()"],{type:"application/javascript"}),t=this.workerURL=URL.createObjectURL(e),r=this.worker=new Worker(t),{wasmURL:o,shimURL:i}=this;return r.postMessage({type:"init",data:{wasmURL:o,shimURL:i}}),new Promise(((e,t)=>{r.onmessage=r=>{const o=r.data;switch(o.type){case"init":e();break;case"init-error":this.close(),t(new Error(o.data));break;case"error":case"internal-error":this.close(),console.error("Worker error:",o.data),this.reject&&this.reject(o.data);break;case"stop":this.blob=o.data,this.blobURL=URL.createObjectURL(o.data),this.onStop&&this.onStop(),this.resolve&&this.resolve(this.blob)}}}))}init(){return this.initAudio().then(this.initWorker.bind(this))}startRecording(){if(!this.stream)throw new Error("missing audio initialization");if(!this.worker)throw new Error("missing worker initialization");this.blob=null,this.blobURL&&URL.revokeObjectURL(this.blobURL),this.blobURL=null,this.resolve=null,this.reject=null,this.worker.postMessage({type:"start",data:this.audioCtx.sampleRate}),this.encNode.onaudioprocess=e=>{const t=e.inputBuffer.getChannelData(0);this.worker.postMessage({type:"data",data:t})},this.encNode.connect(this.audioCtx.destination)}stopRecording(){if(!this.stream)throw new Error("missing audio initialization");if(!this.worker)throw new Error("missing worker initialization");return this.encNode.disconnect(),this.encNode.onaudioprocess=null,this.stopTracks(),this.audioCtx.close(),this.worker.postMessage({type:"stop",data:null}),new Promise(((e,t)=>{this.resolve=e,this.reject=t}))}stopTracks(){this.stream.getTracks&&this.stream.getTracks().forEach((e=>e.stop()))}}class n{constructor(e={},t,r){this.recorder=new i(e,this.onStop.bind(this)),this.resolve=t,this.reject=r,this.backdrop=null,this.popup=null,this.recordBtn=null,this.stopBtn=null,this.timer=null,this.audio=null,this.saveBtn=null,this.tid=0,this.start=0,Object.seal(this),this.recorder.initAudio().then((()=>this.drawInit())).then((()=>this.recorder.initWorker())).then((()=>this.drawAll())).catch((e=>this.drawError(e)))}drawInit(){if(this.backdrop)return;const e=this.backdrop=document.createElement("div");e.className="vmsg-backdrop",e.addEventListener("click",(()=>this.close(null)));const t=this.popup=document.createElement("div");t.className="vmsg-popup",t.addEventListener("click",(e=>e.stopPropagation()));const r=document.createElement("div");r.className="vmsg-progress";for(let e=0;e<3;e++){const e=document.createElement("div");e.className="vmsg-progress-dot",r.appendChild(e)}t.appendChild(r),e.appendChild(t),document.body.appendChild(e)}drawTime(e){const t=Math.round(e/1e3);this.timer.textContent=o(t/60)+":"+o(t%60)}drawAll(){this.drawInit(),this.clearAll();const e=document.createElement("div");e.className="vmsg-record-row",this.popup.appendChild(e);const t=this.recordBtn=document.createElement("button");t.className="vmsg-button vmsg-record-button",t.textContent="●",t.title="Start Recording",t.addEventListener("click",(()=>this.startRecording())),e.appendChild(t);const r=this.stopBtn=document.createElement("button");r.className="vmsg-button vmsg-stop-button",r.style.display="none",r.textContent="■",r.title="Stop Recording",r.addEventListener("click",(()=>this.stopRecording())),e.appendChild(r);const o=this.audio=new Audio;o.autoplay=!0;const s=this.timer=document.createElement("span");s.className="vmsg-timer",s.title="Preview Recording",s.addEventListener("click",(()=>{o.paused?this.recorder.blobURL&&(o.src=this.recorder.blobURL):o.pause()})),this.drawTime(0),e.appendChild(s);const i=this.saveBtn=document.createElement("button");i.className="vmsg-button vmsg-save-button",i.textContent="✓",i.title="Save Recording",i.disabled=!0,i.addEventListener("click",(()=>this.close(this.recorder.blob))),e.appendChild(i);const n=document.createElement("div");n.className="vmsg-slider-wrapper vmsg-gain-slider-wrapper";const a=document.createElement("input");a.className="vmsg-slider vmsg-gain-slider",a.setAttribute("type","range"),a.min=0,a.max=2,a.step=.2,a.value=1,a.onchange=()=>{const e=+a.value;this.recorder.gainNode.gain.value=e},n.appendChild(a),this.popup.appendChild(n);const c=document.createElement("div");c.className="vmsg-slider-wrapper vmsg-pitch-slider-wrapper";const l=document.createElement("input");l.className="vmsg-slider vmsg-pitch-slider",l.setAttribute("type","range"),l.min=-1,l.max=1,l.step=.2,l.value=this.recorder.pitch,l.onchange=()=>{const e=+l.value;this.recorder.pitchFX.setPitchOffset(e),this.recorder.gainNode.disconnect(),this.recorder.gainNode.connect(0===e?this.recorder.encNode:this.recorder.pitchFX.input)},c.appendChild(l),this.popup.appendChild(c),t.focus()}drawError(e){console.error(e),this.drawInit(),this.clearAll();const t=document.createElement("div");t.className="vmsg-error",t.textContent=e.toString(),this.popup.appendChild(t)}clearAll(){this.popup&&(this.popup.innerHTML="")}close(e){this.audio&&this.audio.pause(),this.tid&&clearTimeout(this.tid),this.recorder.close(),this.backdrop.remove(),e?this.resolve(e):this.reject(new Error("No record made"))}onStop(){this.recordBtn.style.display="",this.stopBtn.style.display="none",this.stopBtn.disabled=!1,this.saveBtn.disabled=!1}startRecording(){this.audio.pause(),this.start=Date.now(),this.updateTime(),this.recordBtn.style.display="none",this.stopBtn.style.display="",this.saveBtn.disabled=!0,this.stopBtn.focus(),this.recorder.startRecording()}stopRecording(){clearTimeout(this.tid),this.tid=0,this.stopBtn.disabled=!0,this.recordBtn.focus(),this.recorder.stopRecording()}updateTime(){this.drawTime(Date.now()-this.start),this.tid=setTimeout((()=>this.updateTime()),300)}}let a=!1;function c(e){return new Promise(((t,r)=>{if(a)throw new Error("Record form is already opened");a=!0,new n(e,t,r)})).then((e=>(a=!1,e)),(e=>{throw a=!1,e}))}const l={Recorder:i,Form:n,record:c},d=.1,u=.05,p=.1;function h(e,t,r,o){for(var s=t*e.sampleRate,i=s+(t-2*r)*e.sampleRate,n=e.createBuffer(1,i,e.sampleRate),a=n.getChannelData(0),c=0;c<s;++c)a[c]=o?(s-c)/i:c/s;for(c=s;c<i;++c)a[c]=0;return n}function f(e){this.context=e;var t=(e.createGain||e.createGainNode).call(e),r=(e.createGain||e.createGainNode).call(e);this.input=t,this.output=r;var o=e.createBufferSource(),s=e.createBufferSource(),i=e.createBufferSource(),n=e.createBufferSource();this.shiftDownBuffer=h(e,p,u,!1),this.shiftUpBuffer=h(e,p,u,!0),o.buffer=this.shiftDownBuffer,s.buffer=this.shiftDownBuffer,i.buffer=this.shiftUpBuffer,n.buffer=this.shiftUpBuffer,o.loop=!0,s.loop=!0,i.loop=!0,n.loop=!0;var a=(e.createGain||e.createGainNode).call(e),c=(e.createGain||e.createGainNode).call(e),l=(e.createGain||e.createGainNode).call(e);l.gain.value=0;var f=(e.createGain||e.createGainNode).call(e);f.gain.value=0,o.connect(a),s.connect(c),i.connect(l),n.connect(f);var m=(e.createGain||e.createGainNode).call(e),b=(e.createGain||e.createGainNode).call(e),g=(e.createDelay||e.createDelayNode).call(e),v=(e.createDelay||e.createDelayNode).call(e);a.connect(m),c.connect(b),l.connect(m),f.connect(b),m.connect(g.delayTime),b.connect(v.delayTime);var y=e.createBufferSource(),w=e.createBufferSource(),x=function(e,t,r){for(var o=t*e.sampleRate,s=o+(t-2*r)*e.sampleRate,i=e.createBuffer(1,s,e.sampleRate),n=i.getChannelData(0),a=r*e.sampleRate,c=a,l=o-a,d=0;d<o;++d){var u;u=d<c?Math.sqrt(d/a):d>=l?Math.sqrt(1-(d-l)/a):1,n[d]=u}for(d=o;d<s;++d)n[d]=0;return i}(e,p,u);y.buffer=x,w.buffer=x,y.loop=!0,w.loop=!0;var R=(e.createGain||e.createGainNode).call(e),k=(e.createGain||e.createGainNode).call(e);R.gain.value=0,k.gain.value=0,y.connect(R.gain),w.connect(k.gain),t.connect(g),t.connect(v),g.connect(R),v.connect(k),R.connect(r),k.connect(r);var U=e.currentTime+.05,M=U+p-u;o.start(U),s.start(M),i.start(U),n.start(M),y.start(U),w.start(M),this.mod1=o,this.mod2=s,this.mod1Gain=a,this.mod2Gain=c,this.mod3Gain=l,this.mod4Gain=f,this.modGain1=m,this.modGain2=b,this.fade1=y,this.fade2=w,this.mix1=R,this.mix2=k,this.delay1=g,this.delay2=v,this.setDelay(d)}f.prototype.setDelay=function(e){this.modGain1.gain.setTargetAtTime(.5*e,0,.01),this.modGain2.gain.setTargetAtTime(.5*e,0,.01)},f.prototype.setPitchOffset=function(e){e>0?(this.mod1Gain.gain.value=0,this.mod2Gain.gain.value=0,this.mod3Gain.gain.value=1,this.mod4Gain.gain.value=1):(this.mod1Gain.gain.value=1,this.mod2Gain.gain.value=1,this.mod3Gain.gain.value=0,this.mod4Gain.gain.value=0),this.setDelay(d*Math.abs(e))}},928:t=>{"use strict";t.exports=e},475:e=>{e.exports=function(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e},e.exports.__esModule=!0,e.exports.default=e.exports},383:e=>{e.exports=function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")},e.exports.__esModule=!0,e.exports.default=e.exports},579:(e,t,r)=>{var o=r(736);function s(e,t){for(var r=0;r<t.length;r++){var s=t[r];s.enumerable=s.enumerable||!1,s.configurable=!0,"value"in s&&(s.writable=!0),Object.defineProperty(e,o(s.key),s)}}e.exports=function(e,t,r){return t&&s(e.prototype,t),r&&s(e,r),Object.defineProperty(e,"prototype",{writable:!1}),e},e.exports.__esModule=!0,e.exports.default=e.exports},72:e=>{function t(r){return e.exports=t=Object.setPrototypeOf?Object.getPrototypeOf.bind():function(e){return e.__proto__||Object.getPrototypeOf(e)},e.exports.__esModule=!0,e.exports.default=e.exports,t(r)}e.exports=t,e.exports.__esModule=!0,e.exports.default=e.exports},511:(e,t,r)=>{var o=r(636);e.exports=function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),Object.defineProperty(e,"prototype",{writable:!1}),t&&o(e,t)},e.exports.__esModule=!0,e.exports.default=e.exports},994:e=>{e.exports=function(e){return e&&e.__esModule?e:{default:e}},e.exports.__esModule=!0,e.exports.default=e.exports},452:(e,t,r)=>{var o=r(738).default,s=r(475);e.exports=function(e,t){if(t&&("object"===o(t)||"function"==typeof t))return t;if(void 0!==t)throw new TypeError("Derived constructors may only return object or undefined");return s(e)},e.exports.__esModule=!0,e.exports.default=e.exports},636:e=>{function t(r,o){return e.exports=t=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(e,t){return e.__proto__=t,e},e.exports.__esModule=!0,e.exports.default=e.exports,t(r,o)}e.exports=t,e.exports.__esModule=!0,e.exports.default=e.exports},45:(e,t,r)=>{var o=r(738).default;e.exports=function(e,t){if("object"!=o(e)||!e)return e;var r=e[Symbol.toPrimitive];if(void 0!==r){var s=r.call(e,t||"default");if("object"!=o(s))return s;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)},e.exports.__esModule=!0,e.exports.default=e.exports},736:(e,t,r)=>{var o=r(738).default,s=r(45);e.exports=function(e){var t=s(e,"string");return"symbol"==o(t)?t:String(t)},e.exports.__esModule=!0,e.exports.default=e.exports},738:e=>{function t(r){return e.exports=t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},e.exports.__esModule=!0,e.exports.default=e.exports,t(r)}e.exports=t,e.exports.__esModule=!0,e.exports.default=e.exports}},r={};function o(e){var s=r[e];if(void 0!==s)return s.exports;var i=r[e]={exports:{}};return t[e](i,i.exports,o),i.exports}return o.d=(e,t)=>{for(var r in t)o.o(t,r)&&!o.o(e,r)&&Object.defineProperty(e,r,{enumerable:!0,get:t[r]})},o.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),o.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},o(462)})()));