/*!
 * videojs-wavesurfer
 * @version 3.10.0
 * @see https://github.com/collab-project/videojs-wavesurfer
 * @copyright 2014-2024 Collab
 * @license MIT
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t(require("video.js"),require("wavesurfer.js")):"function"==typeof define&&define.amd?define("VideojsWavesurfer",["video.js","wavesurfer.js"],t):"object"==typeof exports?exports.VideojsWavesurfer=t(require("video.js"),require("wavesurfer.js")):e.VideojsWavesurfer=t(e.videojs,e.WaveSurfer)}(self,((e,t)=>(()=>{var r={96:function(e,t,r){var i;!function(t){"use strict";function o(e,t){t=t||2;var r,i=Number(e)<0,o=e.toString();return i&&(o=o.slice(1)),r=t-o.length+1,(i?"-":"")+(o=new Array(r).join("0").concat(o))}void 0===(i=function(){return o}.call(t,r,t,e))||(e.exports=i)}(this)},920:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;t.default={debug:!1,displayMilliseconds:!0};e.exports=t.default},456:(e,t)=>{"use strict";function r(e){return r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},r(e)}function i(e,t){for(var r=0;r<t.length;r++){var i=t[r];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,o(i.key),i)}}function o(e){var t=function(e,t){if("object"!=r(e)||!e)return e;var i=e[Symbol.toPrimitive];if(void 0!==i){var o=i.call(e,t||"default");if("object"!=r(o))return o;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==r(t)?t:String(t)}Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var a,n,s,l=(a=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e)},n&&i(a.prototype,n),s&&i(a,s),Object.defineProperty(a,"prototype",{writable:!1}),a);l.READY="ready",l.ERROR="error",l.VOLUMECHANGE="volumechange",l.FULLSCREENCHANGE="fullscreenchange",l.TIMEUPDATE="timeupdate",l.ENDED="ended",l.PAUSE="pause",l.FINISH="finish",l.SEEK="seek",l.REDRAW="redraw",l.AUDIOPROCESS="audioprocess",l.DEVICE_READY="deviceReady",l.DEVICE_ERROR="deviceError",l.AUDIO_OUTPUT_READY="audioOutputReady",l.WAVE_READY="waveReady",l.PLAYBACK_FINISH="playbackFinish",l.ABORT="abort",l.RESIZE="resize",Object.freeze(l);t.default=l;e.exports=t.default},444:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var r={setSource:function(e,t){if(this.player.usingPlugin("wavesurfer")){var r=this.player.wavesurfer().surfer.params.backend,i=e.src,o=e.peaks;if("WebAudio"===r)this.player.wavesurfer().load(i);else{t(null,e);var a=this.player.tech_.el();void 0===o?this.player.wavesurfer().load(a):this.player.wavesurfer().load(a,o)}}else t(null,e)}};t.default=r;e.exports=t.default},280:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var i=a(r(96)),o=a(r(44));function a(e){return e&&e.__esModule?e:{default:e}}t.default=function(e,t){var r=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];e=e<0?0:e,(isNaN(e)||e===1/0)&&(e=0);var a=(0,o.default)(1e3*e),n=a;void 0!==t&&(n=(0,o.default)(1e3*t));var s=(0,i.default)(a.hours),l=(0,i.default)(a.minutes),u=(0,i.default)(a.seconds),c=(0,i.default)(a.milliseconds,3);if(a.days>0||n.days>0){var f=(0,i.default)(a.days);return"".concat(f,":").concat(s,":").concat(l,":").concat(u)}return a.hours>0||n.hours>0?"".concat(s,":").concat(l,":").concat(u):r?"".concat(l,":").concat(u,":").concat(c):"".concat(l,":").concat(u)};e.exports=t.default},480:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var i,o=(i=r(520))&&i.__esModule?i:{default:i};t.default=function(e,t,r){!0===r&&("error"===t?o.default.log.error(e):"warn"===t?o.default.log.warn(e):o.default.log(e))};e.exports=t.default},796:(e,t,r)=>{var i;i="undefined"!=typeof window?window:void 0!==r.g?r.g:"undefined"!=typeof self?self:{},e.exports=i},520:t=>{"use strict";t.exports=e},609:e=>{"use strict";e.exports=t},44:(e,t,r)=>{"use strict";function i(e){if("number"!=typeof e)throw new TypeError("Expected a number");const t=e>0?Math.floor:Math.ceil;return{days:t(e/864e5),hours:t(e/36e5)%24,minutes:t(e/6e4)%60,seconds:t(e/1e3)%60,milliseconds:t(e)%1e3,microseconds:t(1e3*e)%1e3,nanoseconds:t(1e6*e)%1e3}}r.r(t),r.d(t,{default:()=>i})}},i={};function o(e){var t=i[e];if(void 0!==t)return t.exports;var a=i[e]={exports:{}};return r[e].call(a.exports,a,a.exports,o),a.exports}o.d=(e,t)=>{for(var r in t)o.o(t,r)&&!o.o(e,r)&&Object.defineProperty(e,r,{enumerable:!0,get:t[r]})},o.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),o.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),o.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var a={};return(()=>{"use strict";var e=a;function t(e){return t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},t(e)}Object.defineProperty(e,"__esModule",{value:!0}),e.Wavesurfer=void 0;var r=f(o(456)),i=f(o(480)),n=f(o(280)),s=f(o(920)),l=f(o(444)),u=(f(o(796)),f(o(520))),c=f(o(609));function f(e){return e&&e.__esModule?e:{default:e}}function h(e,t){for(var r=0;r<t.length;r++){var i=t[r];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,d(i.key),i)}}function d(e){var r=function(e,r){if("object"!=t(e)||!e)return e;var i=e[Symbol.toPrimitive];if(void 0!==i){var o=i.call(e,r||"default");if("object"!=t(o))return o;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(e)}(e,"string");return"symbol"==t(r)?r:String(r)}function p(e,r,i){return r=v(r),function(e,r){if(r&&("object"===t(r)||"function"==typeof r))return r;if(void 0!==r)throw new TypeError("Derived constructors may only return object or undefined");return g(e)}(e,y()?Reflect.construct(r,i||[],v(e).constructor):r.apply(e,i))}function y(){try{var e=!Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){})))}catch(e){}return(y=function(){return!!e})()}function v(e){return v=Object.setPrototypeOf?Object.getPrototypeOf.bind():function(e){return e.__proto__||Object.getPrototypeOf(e)},v(e)}function g(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}function m(e,t){return m=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(e,t){return e.__proto__=t,e},m(e,t)}var b=u.default.getPlugin("plugin"),E="wavesurfer",w="vjs-wavedisplay",T="WebAudio",k=e.Wavesurfer=function(e){function t(e,i){var o;return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,t),o=p(this,t,[e,i]),e.addClass("vjs-wavesurfer"),i=void 0!==u.default.obj?u.default.obj.merge(s.default,i):u.default.mergeOptions(s.default,i),o.waveReady=!1,o.waveFinished=!1,o.liveMode=!1,o.backend=null,o.debug="true"===i.debug.toString(),o.textTracksEnabled=o.player.options_.tracks.length>0,o.displayMilliseconds=i.displayMilliseconds,i.formatTime&&"function"==typeof i.formatTime?o.setFormatTime(i.formatTime):o.setFormatTime((function(e,t){return(0,n.default)(e,t,o.displayMilliseconds)})),o.player.one(r.default.READY,o.initialize.bind(g(o))),o}var o,a,l;return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),Object.defineProperty(e,"prototype",{writable:!1}),t&&m(e,t)}(t,e),o=t,a=[{key:"initialize",value:function(){var e=this;void 0!==this.player.bigPlayButton&&this.player.bigPlayButton.hide();var t=this.parseOptions(this.player.options_.plugins.wavesurfer);!0===this.player.options_.controls&&(this.player.controlBar.show(),this.player.controlBar.el_.style.display="flex",this.backend===T&&void 0!==this.player.controlBar.progressControl&&this.player.controlBar.progressControl.hide(),void 0!==this.player.controlBar.pictureInPictureToggle&&this.player.controlBar.pictureInPictureToggle.hide(),["currentTimeDisplay","timeDivider","durationDisplay"].forEach((function(t){void 0!==(t=e.player.controlBar[t])&&(t.el_.style.display="block",t.show())})),void 0!==this.player.controlBar.remainingTimeDisplay&&this.player.controlBar.remainingTimeDisplay.hide(),this.backend===T&&void 0!==this.player.controlBar.playToggle&&(this.player.controlBar.playToggle.on(["tap","click"],this.onPlayToggle.bind(this)),this.player.controlBar.playToggle.hide())),this.surfer=c.default.create(t),this.surfer.on(r.default.ERROR,this.onWaveError.bind(this)),this.surfer.on(r.default.FINISH,this.onWaveFinish.bind(this)),this.backend=this.surfer.params.backend,this.log("Using wavesurfer.js "+this.backend+" backend."),"microphone"in this.player.wavesurfer().surfer.getActivePlugins()&&(this.liveMode=!0,this.waveReady=!0,this.log("wavesurfer.js microphone plugin enabled."),this.player.controlBar.playToggle.show(),this.surfer.microphone.on(r.default.DEVICE_ERROR,this.onWaveError.bind(this))),this.surferReady=this.onWaveReady.bind(this),this.backend===T&&(this.surferProgress=this.onWaveProgress.bind(this),this.surferSeek=this.onWaveSeek.bind(this),this.player.muted()&&this.setVolume(0)),this.liveMode||this.setupPlaybackEvents(!0),this.player.on(r.default.VOLUMECHANGE,this.onVolumeChange.bind(this)),this.player.on(r.default.FULLSCREENCHANGE,this.onScreenChange.bind(this)),!0===this.player.options_.fluid&&(this.surfer.drawer.wrapper.className=w)}},{key:"parseOptions",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},t=this.player.el_.getBoundingClientRect();this.originalWidth=this.player.options_.width||t.width,this.originalHeight=this.player.options_.height||t.height;var r=this.player.controlBar.height();if(!0===this.player.options_.controls&&0===r&&(r=30),void 0===e.container&&(e.container=this.player.el_),void 0===e.waveformHeight){var i=t.height;e.height=i-r}else e.height=e.waveformHeight;return e.splitChannels&&!0===e.splitChannels&&(e.height/=2),"backend"in e?this.backend=e.backend:e.backend=this.backend="MediaElement",e}},{key:"setupPlaybackEvents",value:function(e){!1===e?(this.surfer.un(r.default.READY,this.surferReady),this.backend===T&&(this.surfer.un(r.default.AUDIOPROCESS,this.surferProgress),this.surfer.un(r.default.SEEK,this.surferSeek))):!0===e&&(this.surfer.on(r.default.READY,this.surferReady),this.backend===T&&(this.surfer.on(r.default.AUDIOPROCESS,this.surferProgress),this.surfer.on(r.default.SEEK,this.surferSeek)))}},{key:"load",value:function(e,t){e instanceof Blob||e instanceof File?(this.log("Loading object: "+JSON.stringify(e)),this.surfer.loadBlob(e)):void 0!==t?this.loadPeaks(e,t):("string"==typeof e?this.log("Loading URL: "+e):this.log("Loading element: "+e),this.surfer.load(e))}},{key:"loadPeaks",value:function(e,t){var i=this;if(Array.isArray(t))this.log("Loading URL with array of peaks: "+e),this.surfer.load(e,t);else{var o={url:t,responseType:"json"};void 0!==this.player.options_.plugins.wavesurfer.xhr&&(o.xhr=this.player.options_.plugins.wavesurfer.xhr);var a=c.default.util.fetchFile(o);a.once("success",(function(o){i.log("Loaded Peak Data URL: "+t),o&&o.data?i.surfer.load(e,o.data):(i.player.trigger(r.default.ERROR,"Could not load peaks data from "+t),i.log(err,"error"))})),a.once("error",(function(e){i.player.trigger(r.default.ERROR,"Unable to retrieve peak data from "+t+". Status code: "+a.response.status)}))}}},{key:"play",value:function(){void 0!==this.player.controlBar.playToggle&&this.player.controlBar.playToggle.contentEl()&&this.player.controlBar.playToggle.handlePlay(),this.liveMode?this.surfer.microphone.active?this.surfer.microphone.paused?(this.log("Resume microphone"),this.surfer.microphone.play()):this.pause():(this.log("Start microphone"),this.surfer.microphone.start()):(this.log("Start playback"),this.player.play(),this.surfer.play())}},{key:"pause",value:function(){void 0!==this.player.controlBar.playToggle&&this.player.controlBar.playToggle.contentEl()&&this.player.controlBar.playToggle.handlePause(),this.liveMode?(this.log("Pause microphone"),this.surfer.microphone.pause()):(this.log("Pause playback"),this.waveFinished?this.waveFinished=!1:this.surfer.pause(),this.setCurrentTime())}},{key:"dispose",value:function(){this.surfer&&(this.liveMode&&this.surfer.microphone&&(this.surfer.microphone.destroy(),this.log("Destroyed microphone plugin")),this.surfer.destroy()),this.log("Destroyed plugin")}},{key:"isDestroyed",value:function(){return this.player&&null===this.player.children()}},{key:"destroy",value:function(){this.player.dispose()}},{key:"setVolume",value:function(e){void 0!==e&&(this.log("Changing volume to: "+e),this.player.volume(e))}},{key:"exportImage",value:function(e,t){var r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"blob";return this.surfer.exportImage(e,t,r)}},{key:"setAudioOutput",value:function(e){var t=this;e&&this.surfer.setSinkId(e).then((function(e){t.player.trigger(r.default.AUDIO_OUTPUT_READY)})).catch((function(e){t.player.trigger(r.default.ERROR,e),t.log(e,"error")}))}},{key:"getCurrentTime",value:function(){var e=this.surfer.getCurrentTime();return e=isNaN(e)?0:e}},{key:"setCurrentTime",value:function(e,t){if(void 0===e&&(e=this.surfer.getCurrentTime()),void 0===t&&(t=this.surfer.getDuration()),e=isNaN(e)?0:e,t=isNaN(t)?0:t,this.player.controlBar.currentTimeDisplay&&this.player.controlBar.currentTimeDisplay.contentEl()&&this.player.controlBar.currentTimeDisplay.contentEl().lastChild){var r=Math.min(e,t);this.player.controlBar.currentTimeDisplay.formattedTime_=this.player.controlBar.currentTimeDisplay.contentEl().lastChild.textContent=this._formatTime(r,t,this.displayMilliseconds)}this.textTracksEnabled&&this.player.tech_&&this.player.tech_.el_&&this.player.tech_.setCurrentTime(e)}},{key:"getDuration",value:function(){var e=this.surfer.getDuration();return e=isNaN(e)?0:e}},{key:"setDuration",value:function(e){void 0===e&&(e=this.surfer.getDuration()),e=isNaN(e)?0:e,this.player.controlBar.durationDisplay&&this.player.controlBar.durationDisplay.contentEl()&&this.player.controlBar.durationDisplay.contentEl().lastChild&&(this.player.controlBar.durationDisplay.formattedTime_=this.player.controlBar.durationDisplay.contentEl().lastChild.textContent=this._formatTime(e,e,this.displayMilliseconds))}},{key:"onWaveReady",value:function(){var e=this;this.waveReady=!0,this.waveFinished=!1,this.liveMode=!1,this.log("Waveform is ready"),this.player.trigger(r.default.WAVE_READY),this.backend===T&&(this.setCurrentTime(),this.setDuration(),void 0!==this.player.controlBar.playToggle&&this.player.controlBar.playToggle.contentEl()&&this.player.controlBar.playToggle.show()),this.player.loadingSpinner.contentEl()&&this.player.loadingSpinner.hide(),!0===this.player.options_.autoplay&&(this.setVolume(0),this.backend===T?this.play():this.player.play().catch((function(t){e.onWaveError(t)})))}},{key:"onWaveFinish",value:function(){var e=this;this.log("Finished playback"),this.player.trigger(r.default.PLAYBACK_FINISH),!0===this.player.options_.loop?this.backend===T&&(this.surfer.stop(),this.play()):(this.waveFinished=!0,this.backend===T&&(this.pause(),this.player.trigger(r.default.ENDED),this.surfer.once(r.default.SEEK,(function(){void 0!==e.player.controlBar.playToggle&&e.player.controlBar.playToggle.removeClass("vjs-ended"),e.player.trigger(r.default.PAUSE)}))))}},{key:"onWaveProgress",value:function(e){this.setCurrentTime()}},{key:"onWaveSeek",value:function(){this.setCurrentTime()}},{key:"onWaveError",value:function(e){e.name&&"AbortError"===e.name||"DOMException"===e.name&&e.message.startsWith("The operation was aborted")?this.player.trigger(r.default.ABORT,e):(this.player.trigger(r.default.ERROR,e),this.log(e,"error"))}},{key:"onPlayToggle",value:function(){void 0!==this.player.controlBar.playToggle&&this.player.controlBar.playToggle.hasClass("vjs-ended")&&this.player.controlBar.playToggle.removeClass("vjs-ended"),this.surfer.isPlaying()?this.pause():this.play()}},{key:"onVolumeChange",value:function(){var e=this.player.volume();this.player.muted()&&(e=0),this.surfer.setVolume(e)}},{key:"onScreenChange",value:function(){var e=this,t=this.player.setInterval((function(){var r,i;if(e.player.isFullscreen()||(r=e.originalWidth,i=e.originalHeight),e.waveReady){if(e.liveMode&&!e.surfer.microphone.active)return;e.redrawWaveform(r,i)}e.player.clearInterval(t)}),100)}},{key:"redrawWaveform",value:function(e,t){if(!this.isDestroyed()){if(this.player.el_){var r=this.player.el_.getBoundingClientRect();void 0===e&&(e=r.width),void 0===t&&(t=r.height)}this.surfer.drawer.destroy(),this.surfer.params.width=e,this.surfer.params.height=t-this.player.controlBar.height(),this.surfer.createDrawer(),this.surfer.drawer.wrapper.className=w,this.surfer.drawBuffer(),this.surfer.drawer.progress(this.surfer.backend.getPlayedPercents())}}},{key:"log",value:function(e,t){(0,i.default)(e,t,this.debug)}},{key:"setFormatTime",value:function(e){this._formatTime=e,u.default.time?u.default.time.setFormatTime(this._formatTime):u.default.setFormatTime(this._formatTime)}}],a&&h(o.prototype,a),l&&h(o,l),Object.defineProperty(o,"prototype",{writable:!1}),t}(b);k.VERSION="3.10.0",u.default.Wavesurfer=k,void 0===u.default.getPlugin(E)&&u.default.registerPlugin(E,k),u.default.use("*",(function(e){return l.default.player=e,l.default}))})(),a})()));