/**
 * @file event.js
 * @since 2.8.0
 */

class Event {}

// video.js
Event.READY = 'ready';
Event.ERROR = 'error';
Event.VOLUMECHANGE = 'volumechange';
Event.FULLSCREENCHANGE = 'fullscreenchange';
Event.TIMEUPDATE = 'timeupdate';
Event.ENDED = 'ended';
Event.PAUSE = 'pause';

// wavesurfer.js
Event.FINISH = 'finish';
Event.SEEK = 'seek';
Event.REDRAW = 'redraw';
Event.AUDIOPROCESS = 'audioprocess';
Event.DEVICE_READY = 'deviceReady';
Event.DEVICE_ERROR = 'deviceError';

// videojs-wavesurfer
Event.AUDIO_OUTPUT_READY = 'audioOutputReady';
Event.WAVE_READY = 'waveReady';
Event.PLAYBACK_FINISH = 'playbackFinish';
Event.ABORT = 'abort';

// dom
Event.RESIZE = 'resize';

// after the freeze, any attempts of altering the class will have no result
Object.freeze(Event);

export default Event;
