/**
 * @videojs/http-streaming
 * @version 1.1.0
 * @copyright 2018 Brightcove, Inc
 * @license Apache-2.0
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("video.js")):"function"==typeof define&&define.amd?define(["exports","video.js"],t):t(e.videojsHttpStreaming={},e.videojs)}(this,function(e,t){"use strict";t=t&&t.hasOwnProperty("default")?t.default:t;var i="undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};var r,n={},a=Object.freeze({default:n}),s=a&&n||a,o="undefined"!=typeof i?i:"undefined"!=typeof window?window:{};"undefined"!=typeof document?r=document:(r=o["__GLOBAL_DOCUMENT_CACHE@4"])||(r=o["__GLOBAL_DOCUMENT_CACHE@4"]=s);var u,d=r,l=(function(e,t){var i,r,n,a,s;i=/^((?:[a-zA-Z0-9+\-.]+:)?)(\/\/[^\/\;?#]*)?(.*?)??(;.*?)?(\?.*?)?(#.*?)?$/,r=/^([^\/;?#]*)(.*)$/,n=/(?:\/|^)\.(?=\/)/g,a=/(?:\/|^)\.\.\/(?!\.\.\/).*?(?=\/)/g,s={buildAbsoluteURL:function(e,t,i){if(i=i||{},e=e.trim(),!(t=t.trim())){if(!i.alwaysNormalize)return e;var n=this.parseURL(e);if(!n)throw new Error("Error trying to parse base URL.");return n.path=s.normalizePath(n.path),s.buildURLFromParts(n)}var a=this.parseURL(t);if(!a)throw new Error("Error trying to parse relative URL.");if(a.scheme)return i.alwaysNormalize?(a.path=s.normalizePath(a.path),s.buildURLFromParts(a)):t;var o=this.parseURL(e);if(!o)throw new Error("Error trying to parse base URL.");if(!o.netLoc&&o.path&&"/"!==o.path[0]){var u=r.exec(o.path);o.netLoc=u[1],o.path=u[2]}o.netLoc&&!o.path&&(o.path="/");var d={scheme:o.scheme,netLoc:a.netLoc,path:null,params:a.params,query:a.query,fragment:a.fragment};if(!a.netLoc&&(d.netLoc=o.netLoc,"/"!==a.path[0]))if(a.path){var l=o.path,c=l.substring(0,l.lastIndexOf("/")+1)+a.path;d.path=s.normalizePath(c)}else d.path=o.path,a.params||(d.params=o.params,a.query||(d.query=o.query));return null===d.path&&(d.path=i.alwaysNormalize?s.normalizePath(a.path):a.path),s.buildURLFromParts(d)},parseURL:function(e){var t=i.exec(e);return t?{scheme:t[1]||"",netLoc:t[2]||"",path:t[3]||"",params:t[4]||"",query:t[5]||"",fragment:t[6]||""}:null},normalizePath:function(e){for(e=e.split("").reverse().join("").replace(n,"");e.length!==(e=e.replace(a,"")).length;);return e.split("").reverse().join("")},buildURLFromParts:function(e){return e.scheme+e.netLoc+e.path+e.params+e.query+e.fragment}},e.exports=s}(u={exports:{}},u.exports),u.exports),c="undefined"!=typeof window?window:"undefined"!=typeof i?i:"undefined"!=typeof self?self:{},h=function(e,t){return/^[a-z]+:/i.test(t)?t:(/\/\//i.test(e)||(e=l.buildAbsoluteURL(c.location.href,e)),l.buildAbsoluteURL(e,t))},f=function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")},p=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var i=arguments[t];for(var r in i)Object.prototype.hasOwnProperty.call(i,r)&&(e[r]=i[r])}return e},m=function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t);e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)},g=function(e,t){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!t||"object"!=typeof t&&"function"!=typeof t?e:t},y=function(){function e(){f(this,e),this.listeners={}}return e.prototype.on=function(e,t){this.listeners[e]||(this.listeners[e]=[]),this.listeners[e].push(t)},e.prototype.off=function(e,t){if(!this.listeners[e])return!1;var i=this.listeners[e].indexOf(t);return this.listeners[e].splice(i,1),i>-1},e.prototype.trigger=function(e){var t=this.listeners[e],i=void 0,r=void 0,n=void 0;if(t)if(2===arguments.length)for(r=t.length,i=0;i<r;++i)t[i].call(this,arguments[1]);else for(n=Array.prototype.slice.call(arguments,1),r=t.length,i=0;i<r;++i)t[i].apply(this,n)},e.prototype.dispose=function(){this.listeners={}},e.prototype.pipe=function(e){this.on("data",function(t){e.push(t)})},e}(),_=function(e){function t(){f(this,t);var i=g(this,e.call(this));return i.buffer="",i}return m(t,e),t.prototype.push=function(e){var t=void 0;for(this.buffer+=e,t=this.buffer.indexOf("\n");t>-1;t=this.buffer.indexOf("\n"))this.trigger("data",this.buffer.substring(0,t)),this.buffer=this.buffer.substring(t+1)},t}(y),v=function(e){for(var t=e.split(new RegExp('(?:^|,)((?:[^=]*)=(?:"[^"]*"|[^,]*))')),i={},r=t.length,n=void 0;r--;)""!==t[r]&&((n=/([^=]*)=(.*)/.exec(t[r]).slice(1))[0]=n[0].replace(/^\s+|\s+$/g,""),n[1]=n[1].replace(/^\s+|\s+$/g,""),n[1]=n[1].replace(/^['"](.*)['"]$/g,"$1"),i[n[0]]=n[1]);return i},b=function(e){function t(){f(this,t);var i=g(this,e.call(this));return i.customParsers=[],i}return m(t,e),t.prototype.push=function(e){var t=void 0,i=void 0;if(0!==(e=e.replace(/^[\u0000\s]+|[\u0000\s]+$/g,"")).length)if("#"===e[0]){for(var r=0;r<this.customParsers.length;r++)if(this.customParsers[r].call(this,e))return;if(0===e.indexOf("#EXT"))if(e=e.replace("\r",""),t=/^#EXTM3U/.exec(e))this.trigger("data",{type:"tag",tagType:"m3u"});else{if(t=/^#EXTINF:?([0-9\.]*)?,?(.*)?$/.exec(e))return i={type:"tag",tagType:"inf"},t[1]&&(i.duration=parseFloat(t[1])),t[2]&&(i.title=t[2]),void this.trigger("data",i);if(t=/^#EXT-X-TARGETDURATION:?([0-9.]*)?/.exec(e))return i={type:"tag",tagType:"targetduration"},t[1]&&(i.duration=parseInt(t[1],10)),void this.trigger("data",i);if(t=/^#ZEN-TOTAL-DURATION:?([0-9.]*)?/.exec(e))return i={type:"tag",tagType:"totalduration"},t[1]&&(i.duration=parseInt(t[1],10)),void this.trigger("data",i);if(t=/^#EXT-X-VERSION:?([0-9.]*)?/.exec(e))return i={type:"tag",tagType:"version"},t[1]&&(i.version=parseInt(t[1],10)),void this.trigger("data",i);if(t=/^#EXT-X-MEDIA-SEQUENCE:?(\-?[0-9.]*)?/.exec(e))return i={type:"tag",tagType:"media-sequence"},t[1]&&(i.number=parseInt(t[1],10)),void this.trigger("data",i);if(t=/^#EXT-X-DISCONTINUITY-SEQUENCE:?(\-?[0-9.]*)?/.exec(e))return i={type:"tag",tagType:"discontinuity-sequence"},t[1]&&(i.number=parseInt(t[1],10)),void this.trigger("data",i);if(t=/^#EXT-X-PLAYLIST-TYPE:?(.*)?$/.exec(e))return i={type:"tag",tagType:"playlist-type"},t[1]&&(i.playlistType=t[1]),void this.trigger("data",i);if(t=/^#EXT-X-BYTERANGE:?([0-9.]*)?@?([0-9.]*)?/.exec(e))return i={type:"tag",tagType:"byterange"},t[1]&&(i.length=parseInt(t[1],10)),t[2]&&(i.offset=parseInt(t[2],10)),void this.trigger("data",i);if(t=/^#EXT-X-ALLOW-CACHE:?(YES|NO)?/.exec(e))return i={type:"tag",tagType:"allow-cache"},t[1]&&(i.allowed=!/NO/.test(t[1])),void this.trigger("data",i);if(t=/^#EXT-X-MAP:?(.*)$/.exec(e)){if(i={type:"tag",tagType:"map"},t[1]){var n=v(t[1]);if(n.URI&&(i.uri=n.URI),n.BYTERANGE){var a=n.BYTERANGE.split("@"),s=a[0],o=a[1];i.byterange={},s&&(i.byterange.length=parseInt(s,10)),o&&(i.byterange.offset=parseInt(o,10))}}this.trigger("data",i)}else if(t=/^#EXT-X-STREAM-INF:?(.*)$/.exec(e)){if(i={type:"tag",tagType:"stream-inf"},t[1]){if(i.attributes=v(t[1]),i.attributes.RESOLUTION){var u=i.attributes.RESOLUTION.split("x"),d={};u[0]&&(d.width=parseInt(u[0],10)),u[1]&&(d.height=parseInt(u[1],10)),i.attributes.RESOLUTION=d}i.attributes.BANDWIDTH&&(i.attributes.BANDWIDTH=parseInt(i.attributes.BANDWIDTH,10)),i.attributes["PROGRAM-ID"]&&(i.attributes["PROGRAM-ID"]=parseInt(i.attributes["PROGRAM-ID"],10))}this.trigger("data",i)}else{if(t=/^#EXT-X-MEDIA:?(.*)$/.exec(e))return i={type:"tag",tagType:"media"},t[1]&&(i.attributes=v(t[1])),void this.trigger("data",i);if(t=/^#EXT-X-ENDLIST/.exec(e))this.trigger("data",{type:"tag",tagType:"endlist"});else if(t=/^#EXT-X-DISCONTINUITY/.exec(e))this.trigger("data",{type:"tag",tagType:"discontinuity"});else{if(t=/^#EXT-X-PROGRAM-DATE-TIME:?(.*)$/.exec(e))return i={type:"tag",tagType:"program-date-time"},t[1]&&(i.dateTimeString=t[1],i.dateTimeObject=new Date(t[1])),void this.trigger("data",i);if(t=/^#EXT-X-KEY:?(.*)$/.exec(e))return i={type:"tag",tagType:"key"},t[1]&&(i.attributes=v(t[1]),i.attributes.IV&&("0x"===i.attributes.IV.substring(0,2).toLowerCase()&&(i.attributes.IV=i.attributes.IV.substring(2)),i.attributes.IV=i.attributes.IV.match(/.{8}/g),i.attributes.IV[0]=parseInt(i.attributes.IV[0],16),i.attributes.IV[1]=parseInt(i.attributes.IV[1],16),i.attributes.IV[2]=parseInt(i.attributes.IV[2],16),i.attributes.IV[3]=parseInt(i.attributes.IV[3],16),i.attributes.IV=new Uint32Array(i.attributes.IV))),void this.trigger("data",i);if(t=/^#EXT-X-START:?(.*)$/.exec(e))return i={type:"tag",tagType:"start"},t[1]&&(i.attributes=v(t[1]),i.attributes["TIME-OFFSET"]=parseFloat(i.attributes["TIME-OFFSET"]),i.attributes.PRECISE=/YES/.test(i.attributes.PRECISE)),void this.trigger("data",i);if(t=/^#EXT-X-CUE-OUT-CONT:?(.*)?$/.exec(e))return i={type:"tag",tagType:"cue-out-cont"},t[1]?i.data=t[1]:i.data="",void this.trigger("data",i);if(t=/^#EXT-X-CUE-OUT:?(.*)?$/.exec(e))return i={type:"tag",tagType:"cue-out"},t[1]?i.data=t[1]:i.data="",void this.trigger("data",i);if(t=/^#EXT-X-CUE-IN:?(.*)?$/.exec(e))return i={type:"tag",tagType:"cue-in"},t[1]?i.data=t[1]:i.data="",void this.trigger("data",i);this.trigger("data",{type:"tag",data:e.slice(4)})}}}else this.trigger("data",{type:"comment",text:e.slice(1)})}else this.trigger("data",{type:"uri",uri:e})},t.prototype.addParser=function(e){var t=this,i=e.expression,r=e.customType,n=e.dataParser,a=e.segment;"function"!=typeof n&&(n=function(e){return e}),this.customParsers.push(function(e){if(i.exec(e))return t.trigger("data",{type:"custom",data:n(e),customType:r,segment:a}),!0})},t}(y),T=function(e){function t(){f(this,t);var i=g(this,e.call(this));i.lineStream=new _,i.parseStream=new b,i.lineStream.pipe(i.parseStream);var r=i,n=[],a={},s=void 0,o=void 0,u={AUDIO:{},VIDEO:{},"CLOSED-CAPTIONS":{},SUBTITLES:{}},d=0;return i.manifest={allowCache:!0,discontinuityStarts:[],segments:[]},i.parseStream.on("data",function(e){var t=void 0,i=void 0;({tag:function(){(({"allow-cache":function(){this.manifest.allowCache=e.allowed,"allowed"in e||(this.trigger("info",{message:"defaulting allowCache to YES"}),this.manifest.allowCache=!0)},byterange:function(){var t={};"length"in e&&(a.byterange=t,t.length=e.length,"offset"in e||(this.trigger("info",{message:"defaulting offset to zero"}),e.offset=0)),"offset"in e&&(a.byterange=t,t.offset=e.offset)},endlist:function(){this.manifest.endList=!0},inf:function(){"mediaSequence"in this.manifest||(this.manifest.mediaSequence=0,this.trigger("info",{message:"defaulting media sequence to zero"})),"discontinuitySequence"in this.manifest||(this.manifest.discontinuitySequence=0,this.trigger("info",{message:"defaulting discontinuity sequence to zero"})),e.duration>0&&(a.duration=e.duration),0===e.duration&&(a.duration=.01,this.trigger("info",{message:"updating zero segment duration to a small value"})),this.manifest.segments=n},key:function(){e.attributes?"NONE"!==e.attributes.METHOD?e.attributes.URI?(e.attributes.METHOD||this.trigger("warn",{message:"defaulting key method to AES-128"}),o={method:e.attributes.METHOD||"AES-128",uri:e.attributes.URI},"undefined"!=typeof e.attributes.IV&&(o.iv=e.attributes.IV)):this.trigger("warn",{message:"ignoring key declaration without URI"}):o=null:this.trigger("warn",{message:"ignoring key declaration without attribute list"})},"media-sequence":function(){isFinite(e.number)?this.manifest.mediaSequence=e.number:this.trigger("warn",{message:"ignoring invalid media sequence: "+e.number})},"discontinuity-sequence":function(){isFinite(e.number)?(this.manifest.discontinuitySequence=e.number,d=e.number):this.trigger("warn",{message:"ignoring invalid discontinuity sequence: "+e.number})},"playlist-type":function(){/VOD|EVENT/.test(e.playlistType)?this.manifest.playlistType=e.playlistType:this.trigger("warn",{message:"ignoring unknown playlist type: "+e.playlist})},map:function(){s={},e.uri&&(s.uri=e.uri),e.byterange&&(s.byterange=e.byterange)},"stream-inf":function(){this.manifest.playlists=n,this.manifest.mediaGroups=this.manifest.mediaGroups||u,e.attributes?(a.attributes||(a.attributes={}),p(a.attributes,e.attributes)):this.trigger("warn",{message:"ignoring empty stream-inf attributes"})},media:function(){if(this.manifest.mediaGroups=this.manifest.mediaGroups||u,e.attributes&&e.attributes.TYPE&&e.attributes["GROUP-ID"]&&e.attributes.NAME){var r=this.manifest.mediaGroups[e.attributes.TYPE];r[e.attributes["GROUP-ID"]]=r[e.attributes["GROUP-ID"]]||{},t=r[e.attributes["GROUP-ID"]],(i={default:/yes/i.test(e.attributes.DEFAULT)}).default?i.autoselect=!0:i.autoselect=/yes/i.test(e.attributes.AUTOSELECT),e.attributes.LANGUAGE&&(i.language=e.attributes.LANGUAGE),e.attributes.URI&&(i.uri=e.attributes.URI),e.attributes["INSTREAM-ID"]&&(i.instreamId=e.attributes["INSTREAM-ID"]),e.attributes.CHARACTERISTICS&&(i.characteristics=e.attributes.CHARACTERISTICS),e.attributes.FORCED&&(i.forced=/yes/i.test(e.attributes.FORCED)),t[e.attributes.NAME]=i}else this.trigger("warn",{message:"ignoring incomplete or missing media group"})},discontinuity:function(){d+=1,a.discontinuity=!0,this.manifest.discontinuityStarts.push(n.length)},"program-date-time":function(){"undefined"==typeof this.manifest.dateTimeString&&(this.manifest.dateTimeString=e.dateTimeString,this.manifest.dateTimeObject=e.dateTimeObject),a.dateTimeString=e.dateTimeString,a.dateTimeObject=e.dateTimeObject},targetduration:function(){!isFinite(e.duration)||e.duration<0?this.trigger("warn",{message:"ignoring invalid target duration: "+e.duration}):this.manifest.targetDuration=e.duration},totalduration:function(){!isFinite(e.duration)||e.duration<0?this.trigger("warn",{message:"ignoring invalid total duration: "+e.duration}):this.manifest.totalDuration=e.duration},start:function(){e.attributes&&!isNaN(e.attributes["TIME-OFFSET"])?this.manifest.start={timeOffset:e.attributes["TIME-OFFSET"],precise:e.attributes.PRECISE}:this.trigger("warn",{message:"ignoring start declaration without appropriate attribute list"})},"cue-out":function(){a.cueOut=e.data},"cue-out-cont":function(){a.cueOutCont=e.data},"cue-in":function(){a.cueIn=e.data}})[e.tagType]||function(){}).call(r)},uri:function(){a.uri=e.uri,n.push(a),!this.manifest.targetDuration||"duration"in a||(this.trigger("warn",{message:"defaulting segment duration to the target duration"}),a.duration=this.manifest.targetDuration),o&&(a.key=o),a.timeline=d,s&&(a.map=s),a={}},comment:function(){},custom:function(){e.segment?(a.custom=a.custom||{},a.custom[e.customType]=e.data):(this.manifest.custom=this.manifest.custom||{},this.manifest.custom[e.customType]=e.data)}})[e.type].call(r)}),i}return m(t,e),t.prototype.push=function(e){this.lineStream.push(e)},t.prototype.end=function(){this.lineStream.push("\n")},t.prototype.addParser=function(e){this.parseStream.addParser(e)},t}(y),S=function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")},k=function(){function e(e,t){for(var i=0;i<t.length;i++){var r=t[i];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}return function(t,i,r){return i&&e(t.prototype,i),r&&e(t,r),t}}(),E=function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t);e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)},L=function(e,t){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!t||"object"!=typeof t&&"function"!=typeof t?e:t},A=function(){return function(e,t){if(Array.isArray(e))return e;if(Symbol.iterator in Object(e))return function(e,t){var i=[],r=!0,n=!1,a=void 0;try{for(var s,o=e[Symbol.iterator]();!(r=(s=o.next()).done)&&(i.push(s.value),!t||i.length!==t);r=!0);}catch(e){n=!0,a=e}finally{try{!r&&o.return&&o.return()}finally{if(n)throw a}}return i}(e,t);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}(),w=t.mergeOptions,I=t.EventTarget,O=t.log,C=function(e,t){["AUDIO","SUBTITLES"].forEach(function(i){for(var r in e.mediaGroups[i])for(var n in e.mediaGroups[i][r]){var a=e.mediaGroups[i][r][n];t(a,i,r,n)}})},P=function(e,t){var i=w(e,{}),r=i.playlists[t.uri];if(!r)return null;if(r.segments&&t.segments&&r.segments.length===t.segments.length&&r.mediaSequence===t.mediaSequence)return null;var n=w(r,t);r.segments&&(n.segments=function(e,t,i){var r=t.slice();i=i||0;for(var n=Math.min(e.length,t.length+i),a=i;a<n;a++)r[a-i]=w(e[a],r[a-i]);return r}(r.segments,t.segments,t.mediaSequence-r.mediaSequence)),n.segments.forEach(function(e){!function(e,t){e.resolvedUri||(e.resolvedUri=h(t,e.uri)),e.key&&!e.key.resolvedUri&&(e.key.resolvedUri=h(t,e.key.uri)),e.map&&!e.map.resolvedUri&&(e.map.resolvedUri=h(t,e.map.uri))}(e,n.resolvedUri)});for(var a=0;a<i.playlists.length;a++)i.playlists[a].uri===t.uri&&(i.playlists[a]=n);return i.playlists[t.uri]=n,i},U=function(e){for(var t=e.playlists.length;t--;){var i=e.playlists[t];e.playlists[i.uri]=i,i.resolvedUri=h(e.uri,i.uri),i.id=t,i.attributes||(i.attributes={},O.warn("Invalid playlist STREAM-INF detected. Missing BANDWIDTH attribute."))}},D=function(e){C(e,function(t){t.uri&&(t.resolvedUri=h(e.uri,t.uri))})},R=function(e,t){var i=e.segments[e.segments.length-1];return t&&i&&i.duration?1e3*i.duration:500*(e.targetDuration||10)},B=function(e){function t(e,i,r){S(this,t);var n=L(this,(t.__proto__||Object.getPrototypeOf(t)).call(this));if(n.srcUrl=e,n.hls_=i,n.withCredentials=r,!n.srcUrl)throw new Error("A non-empty playlist URL is required");return n.state="HAVE_NOTHING",n.on("mediaupdatetimeout",function(){"HAVE_METADATA"===n.state&&(n.state="HAVE_CURRENT_METADATA",n.request=n.hls_.xhr({uri:h(n.master.uri,n.media().uri),withCredentials:n.withCredentials},function(e,t){if(n.request)return e?n.playlistRequestError(n.request,n.media().uri,"HAVE_METADATA"):void n.haveMetadata(n.request,n.media().uri)}))}),n}return E(t,I),k(t,[{key:"playlistRequestError",value:function(e,t,i){this.request=null,i&&(this.state=i),this.error={playlist:this.master.playlists[t],status:e.status,message:"HLS playlist request error at URL: "+t,responseText:e.responseText,code:e.status>=500?4:2},this.trigger("error")}},{key:"haveMetadata",value:function(e,t){var i=this;this.request=null,this.state="HAVE_METADATA";var r=new T;r.push(e.responseText),r.end(),r.manifest.uri=t,r.manifest.attributes=r.manifest.attributes||{};var n=P(this.master,r.manifest);this.targetDuration=r.manifest.targetDuration,n?(this.master=n,this.media_=this.master.playlists[r.manifest.uri]):this.trigger("playlistunchanged"),this.media().endList||(c.clearTimeout(this.mediaUpdateTimeout),this.mediaUpdateTimeout=c.setTimeout(function(){i.trigger("mediaupdatetimeout")},R(this.media(),!!n))),this.trigger("loadedplaylist")}},{key:"dispose",value:function(){this.stopRequest(),c.clearTimeout(this.mediaUpdateTimeout)}},{key:"stopRequest",value:function(){if(this.request){var e=this.request;this.request=null,e.onreadystatechange=null,e.abort()}}},{key:"media",value:function(e){var t=this;if(!e)return this.media_;if("HAVE_NOTHING"===this.state)throw new Error("Cannot switch media playlist from "+this.state);var i=this.state;if("string"==typeof e){if(!this.master.playlists[e])throw new Error("Unknown playlist URI: "+e);e=this.master.playlists[e]}var r=!this.media_||e.uri!==this.media_.uri;if(this.master.playlists[e.uri].endList)return this.request&&(this.request.onreadystatechange=null,this.request.abort(),this.request=null),this.state="HAVE_METADATA",this.media_=e,void(r&&(this.trigger("mediachanging"),this.trigger("mediachange")));if(r){if(this.state="SWITCHING_MEDIA",this.request){if(h(this.master.uri,e.uri)===this.request.url)return;this.request.onreadystatechange=null,this.request.abort(),this.request=null}this.media_&&this.trigger("mediachanging"),this.request=this.hls_.xhr({uri:h(this.master.uri,e.uri),withCredentials:this.withCredentials},function(r,n){if(t.request){if(r)return t.playlistRequestError(t.request,e.uri,i);t.haveMetadata(n,e.uri),"HAVE_MASTER"===i?t.trigger("loadedmetadata"):t.trigger("mediachange")}})}}},{key:"pause",value:function(){this.stopRequest(),c.clearTimeout(this.mediaUpdateTimeout),"HAVE_NOTHING"===this.state&&(this.started=!1),"SWITCHING_MEDIA"===this.state?this.media_?this.state="HAVE_METADATA":this.state="HAVE_MASTER":"HAVE_CURRENT_METADATA"===this.state&&(this.state="HAVE_METADATA")}},{key:"load",value:function(e){var t=this;c.clearTimeout(this.mediaUpdateTimeout);var i=this.media();if(e){var r=i?i.targetDuration/2*1e3:5e3;this.mediaUpdateTimeout=c.setTimeout(function(){return t.load()},r)}else this.started?i&&!i.endList?this.trigger("mediaupdatetimeout"):this.trigger("loadedplaylist"):this.start()}},{key:"start",value:function(){var e=this;this.started=!0,this.request=this.hls_.xhr({uri:this.srcUrl,withCredentials:this.withCredentials},function(t,i){if(e.request){if(e.request=null,t)return e.error={status:i.status,message:"HLS playlist request error at URL: "+e.srcUrl,responseText:i.responseText,code:2},"HAVE_NOTHING"===e.state&&(e.started=!1),e.trigger("error");var r=new T;return r.push(i.responseText),r.end(),e.state="HAVE_MASTER",r.manifest.uri=e.srcUrl,r.manifest.playlists?(e.master=r.manifest,U(e.master),D(e.master),e.trigger("loadedplaylist"),void(e.request||e.media(r.manifest.playlists[0]))):(e.master={mediaGroups:{AUDIO:{},VIDEO:{},"CLOSED-CAPTIONS":{},SUBTITLES:{}},uri:c.location.href,playlists:[{uri:e.srcUrl,id:0}]},e.master.playlists[e.srcUrl]=e.master.playlists[0],e.master.playlists[0].resolvedUri=e.srcUrl,e.master.playlists[0].attributes=e.master.playlists[0].attributes||{},e.haveMetadata(i,e.srcUrl),e.trigger("loadedmetadata"))}})}}]),t}(),M=t.createTimeRange,x=function(e,t,i){var r,n;return"undefined"==typeof t&&(t=e.mediaSequence+e.segments.length),t<e.mediaSequence?0:(r=function(e,t){var i=0,r=t-e.mediaSequence,n=e.segments[r];if(n){if("undefined"!=typeof n.start)return{result:n.start,precise:!0};if("undefined"!=typeof n.end)return{result:n.end-n.duration,precise:!0}}for(;r--;){if("undefined"!=typeof(n=e.segments[r]).end)return{result:i+n.end,precise:!0};if(i+=n.duration,"undefined"!=typeof n.start)return{result:i+n.start,precise:!0}}return{result:i,precise:!1}}(e,t)).precise?r.result:(n=function(e,t){for(var i=0,r=void 0,n=t-e.mediaSequence;n<e.segments.length;n++){if("undefined"!=typeof(r=e.segments[n]).start)return{result:r.start-i,precise:!0};if(i+=r.duration,"undefined"!=typeof r.end)return{result:r.end-i,precise:!0}}return{result:-1,precise:!1}}(e,t)).precise?n.result:r.result+i},N=function(e,t,i){if(!e)return 0;if("number"!=typeof i&&(i=0),"undefined"==typeof t){if(e.totalDuration)return e.totalDuration;if(!e.endList)return c.Infinity}return x(e,t,i)},q=function(e,t,i){var r=0;if(t>i){var n=[i,t];t=n[0],i=n[1]}if(t<0){for(var a=t;a<Math.min(0,i);a++)r+=e.targetDuration;t=0}for(var s=t;s<i;s++)r+=e.segments[s].duration;return r},F=function(e){if(!e.segments.length)return 0;for(var t=e.segments.length-1,i=e.segments[t].duration||e.targetDuration,r=i+2*e.targetDuration;t--&&!((i+=e.segments[t].duration)>=r););return Math.max(0,t)},H=function(e,t,i){if(!e||!e.segments)return null;if(e.endList)return N(e);if(null===t)return null;t=t||0;var r=i?F(e):e.segments.length;return x(e,e.mediaSequence+r,t)},G=function(e){return e-Math.floor(e)==0},j=function(e,t){if(G(t))return t+.1*e;for(var i=t.toString().split(".")[1].length,r=1;r<=i;r++){var n=Math.pow(10,r),a=t*n;if(G(a)||r===i)return(a+e)/n}},W=j.bind(null,1),V=j.bind(null,-1),z=function(e){return e.excludeUntil&&e.excludeUntil>Date.now()},X=function(e){return e.excludeUntil&&e.excludeUntil===1/0},Y=function(e){var t=z(e);return!e.disabled&&!t},$=function(e,t){return t.attributes&&t.attributes[e]},K=function(e,t){if(1===e.playlists.length)return!0;var i=t.attributes.BANDWIDTH||Number.MAX_VALUE;return 0===e.playlists.filter(function(e){return!!Y(e)&&(e.attributes.BANDWIDTH||0)<i}).length},Q={duration:N,seekable:function(e,t){var i=t||0,r=H(e,t,!0);return null===r?M():M(i,r)},safeLiveIndex:F,getMediaInfoForTime:function(e,t,i,r){var n=void 0,a=void 0,s=e.segments.length,o=t-r;if(o<0){if(i>0)for(n=i-1;n>=0;n--)if(a=e.segments[n],(o+=V(a.duration))>0)return{mediaIndex:n,startTime:r-q(e,i,n)};return{mediaIndex:0,startTime:t}}if(i<0){for(n=i;n<0;n++)if((o-=e.targetDuration)<0)return{mediaIndex:0,startTime:t};i=0}for(n=i;n<s;n++)if(a=e.segments[n],(o-=W(a.duration))<0)return{mediaIndex:n,startTime:r+q(e,i,n)};return{mediaIndex:s-1,startTime:t}},isEnabled:Y,isDisabled:function(e){return e.disabled},isBlacklisted:z,isIncompatible:X,playlistEnd:H,isAes:function(e){for(var t=0;t<e.segments.length;t++)if(e.segments[t].key)return!0;return!1},isFmp4:function(e){for(var t=0;t<e.segments.length;t++)if(e.segments[t].map)return!0;return!1},hasAttribute:$,estimateSegmentRequestTime:function(e,t,i){var r=arguments.length>3&&void 0!==arguments[3]?arguments[3]:0;return $("BANDWIDTH",i)?(e*i.attributes.BANDWIDTH-8*r)/t:NaN},isLowestEnabledRendition:K},J=t.xhr,Z=t.mergeOptions,ee=function(){return function e(i,r){i=Z({timeout:45e3},i);var n=e.beforeRequest||t.Hls.xhr.beforeRequest;if(n&&"function"==typeof n){var a=n(i);a&&(i=a)}var s=J(i,function(e,t){var i=s.response;!e&&i&&(s.responseTime=Date.now(),s.roundTripTime=s.responseTime-s.requestTime,s.bytesReceived=i.byteLength||i.length,s.bandwidth||(s.bandwidth=Math.floor(s.bytesReceived/s.roundTripTime*8*1e3))),t.headers&&(s.responseHeaders=t.headers),e&&"ETIMEDOUT"===e.code&&(s.timedout=!0),e||s.aborted||200===t.statusCode||206===t.statusCode||0===t.statusCode||(e=new Error("XHR Failed with a response of: "+(s&&(i||s.responseText)))),r(e,s)}),o=s.abort;return s.abort=function(){return s.aborted=!0,o.apply(s,arguments)},s.uri=i.uri,s.requestTime=Date.now(),s}};var te=function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")},ie=function(){function e(e,t){for(var i=0;i<t.length;i++){var r=t[i];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}return function(t,i,r){return i&&e(t.prototype,i),r&&e(t,r),t}}(),re=function(e,t){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!t||"object"!=typeof t&&"function"!=typeof t?e:t},ne=function(){var e=[[[],[],[],[],[]],[[],[],[],[],[]]],t=e[0],i=e[1],r=t[4],n=i[4],a=void 0,s=void 0,o=void 0,u=[],d=[],l=void 0,c=void 0,h=void 0,f=void 0,p=void 0;for(a=0;a<256;a++)d[(u[a]=a<<1^283*(a>>7))^a]=a;for(s=o=0;!r[s];s^=l||1,o=d[o]||1)for(h=(h=o^o<<1^o<<2^o<<3^o<<4)>>8^255&h^99,r[s]=h,n[h]=s,p=16843009*u[c=u[l=u[s]]]^65537*c^257*l^16843008*s,f=257*u[h]^16843008*h,a=0;a<4;a++)t[a][s]=f=f<<24^f>>>8,i[a][h]=p=p<<24^p>>>8;for(a=0;a<5;a++)t[a]=t[a].slice(0),i[a]=i[a].slice(0);return e},ae=null,se=function(){function e(t){te(this,e),ae||(ae=ne()),this._tables=[[ae[0][0].slice(),ae[0][1].slice(),ae[0][2].slice(),ae[0][3].slice(),ae[0][4].slice()],[ae[1][0].slice(),ae[1][1].slice(),ae[1][2].slice(),ae[1][3].slice(),ae[1][4].slice()]];var i=void 0,r=void 0,n=void 0,a=void 0,s=void 0,o=this._tables[0][4],u=this._tables[1],d=t.length,l=1;if(4!==d&&6!==d&&8!==d)throw new Error("Invalid aes key size");for(a=t.slice(0),s=[],this._key=[a,s],i=d;i<4*d+28;i++)n=a[i-1],(i%d==0||8===d&&i%d==4)&&(n=o[n>>>24]<<24^o[n>>16&255]<<16^o[n>>8&255]<<8^o[255&n],i%d==0&&(n=n<<8^n>>>24^l<<24,l=l<<1^283*(l>>7))),a[i]=a[i-d]^n;for(r=0;i;r++,i--)n=a[3&r?i:i-4],s[r]=i<=4||r<4?n:u[0][o[n>>>24]]^u[1][o[n>>16&255]]^u[2][o[n>>8&255]]^u[3][o[255&n]]}return e.prototype.decrypt=function(e,t,i,r,n,a){var s=this._key[1],o=e^s[0],u=r^s[1],d=i^s[2],l=t^s[3],c=void 0,h=void 0,f=void 0,p=s.length/4-2,m=void 0,g=4,y=this._tables[1],_=y[0],v=y[1],b=y[2],T=y[3],S=y[4];for(m=0;m<p;m++)c=_[o>>>24]^v[u>>16&255]^b[d>>8&255]^T[255&l]^s[g],h=_[u>>>24]^v[d>>16&255]^b[l>>8&255]^T[255&o]^s[g+1],f=_[d>>>24]^v[l>>16&255]^b[o>>8&255]^T[255&u]^s[g+2],l=_[l>>>24]^v[o>>16&255]^b[u>>8&255]^T[255&d]^s[g+3],g+=4,o=c,u=h,d=f;for(m=0;m<4;m++)n[(3&-m)+a]=S[o>>>24]<<24^S[u>>16&255]<<16^S[d>>8&255]<<8^S[255&l]^s[g++],c=o,o=u,u=d,d=l,l=c},e}(),oe=function(){function e(){te(this,e),this.listeners={}}return e.prototype.on=function(e,t){this.listeners[e]||(this.listeners[e]=[]),this.listeners[e].push(t)},e.prototype.off=function(e,t){if(!this.listeners[e])return!1;var i=this.listeners[e].indexOf(t);return this.listeners[e].splice(i,1),i>-1},e.prototype.trigger=function(e){var t=this.listeners[e];if(t)if(2===arguments.length)for(var i=t.length,r=0;r<i;++r)t[r].call(this,arguments[1]);else for(var n=Array.prototype.slice.call(arguments,1),a=t.length,s=0;s<a;++s)t[s].apply(this,n)},e.prototype.dispose=function(){this.listeners={}},e.prototype.pipe=function(e){this.on("data",function(t){e.push(t)})},e}(),ue=function(e){function t(){te(this,t);var i=re(this,e.call(this,oe));return i.jobs=[],i.delay=1,i.timeout_=null,i}return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t);e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)}(t,e),t.prototype.processJob_=function(){this.jobs.shift()(),this.jobs.length?this.timeout_=setTimeout(this.processJob_.bind(this),this.delay):this.timeout_=null},t.prototype.push=function(e){this.jobs.push(e),this.timeout_||(this.timeout_=setTimeout(this.processJob_.bind(this),this.delay))},t}(oe),de=function(e){return e<<24|(65280&e)<<8|(16711680&e)>>8|e>>>24},le=function(e,t,i){var r=new Int32Array(e.buffer,e.byteOffset,e.byteLength>>2),n=new se(Array.prototype.slice.call(t)),a=new Uint8Array(e.byteLength),s=new Int32Array(a.buffer),o=void 0,u=void 0,d=void 0,l=void 0,c=void 0,h=void 0,f=void 0,p=void 0,m=void 0;for(o=i[0],u=i[1],d=i[2],l=i[3],m=0;m<r.length;m+=4)c=de(r[m]),h=de(r[m+1]),f=de(r[m+2]),p=de(r[m+3]),n.decrypt(c,h,f,p,s,m),s[m]=de(s[m]^o),s[m+1]=de(s[m+1]^u),s[m+2]=de(s[m+2]^d),s[m+3]=de(s[m+3]^l),o=c,u=h,d=f,l=p;return a},ce=function(){function e(t,i,r,n){te(this,e);var a=e.STEP,s=new Int32Array(t.buffer),o=new Uint8Array(t.byteLength),u=0;for(this.asyncStream_=new ue,this.asyncStream_.push(this.decryptChunk_(s.subarray(u,u+a),i,r,o)),u=a;u<s.length;u+=a)r=new Uint32Array([de(s[u-4]),de(s[u-3]),de(s[u-2]),de(s[u-1])]),this.asyncStream_.push(this.decryptChunk_(s.subarray(u,u+a),i,r,o));this.asyncStream_.push(function(){var e;n(null,(e=o).subarray(0,e.byteLength-e[e.byteLength-1]))})}return e.prototype.decryptChunk_=function(e,t,i,r){return function(){var n=le(e,t,i);r.set(n,e.byteOffset)}},ie(e,null,[{key:"STEP",get:function(){return 32e3}}]),e}(),he=function(e,t){return e.start(t)+"-"+e.end(t)},fe=function(e,t){var i=e.toString(16);return"00".substring(0,2-i.length)+i+(t%2?" ":"")},pe=function(e){return e>=32&&e<126?String.fromCharCode(e):"."},me=function(e){var t={};return Object.keys(e).forEach(function(i){var r=e[i];ArrayBuffer.isView(r)?t[i]={bytes:r.buffer,byteOffset:r.byteOffset,byteLength:r.byteLength}:t[i]=r}),t},ge=function(e){var t=e.byterange||{length:1/0,offset:0};return[t.length,t.offset,e.resolvedUri].join(",")},ye=function(e){for(var t=Array.prototype.slice.call(e),i="",r=0;r<t.length/16;r++)i+=t.slice(16*r,16*r+16).map(fe).join("")+" "+t.slice(16*r,16*r+16).map(pe).join("")+"\n";return i},_e=Object.freeze({createTransferableMessage:me,initSegmentId:ge,hexDump:ye,tagDump:function(e){var t=e.bytes;return ye(t)},textRanges:function(e){var t="",i=void 0;for(i=0;i<e.length;i++)t+=he(e,i)+" ";return t}}),ve=function(e,i){var r=[],n=void 0;if(e&&e.length)for(n=0;n<e.length;n++)i(e.start(n),e.end(n))&&r.push([e.start(n),e.end(n)]);return t.createTimeRanges(r)},be=function(e,t){return ve(e,function(e,i){return e-1/30<=t&&i+1/30>=t})},Te=function(e,t){return ve(e,function(e){return e-1/30>=t})},Se=function(e){var t=[];if(!e||!e.length)return"";for(var i=0;i<e.length;i++)t.push(e.start(i)+" => "+e.end(i));return t.join(", ")},ke=function(e){for(var t=[],i=0;i<e.length;i++)t.push({start:e.start(i),end:e.end(i)});return t},Ee=function(e,t,i){var r=void 0,n=void 0;if(i&&i.cues)for(r=i.cues.length;r--;)(n=i.cues[r]).startTime<=t&&n.endTime>=e&&i.removeCue(n)},Le=function(e){return isNaN(e)||Math.abs(e)===1/0?Number.MAX_VALUE:e},Ae=function(e,i,r){var n=c.WebKitDataCue||c.VTTCue;if(i&&i.forEach(function(e){var t=e.stream;this.inbandTextTracks_[t].addCue(new n(e.startTime+this.timestampOffset,e.endTime+this.timestampOffset,e.text))},e),r){var a=Le(e.mediaSource_.duration);if(r.forEach(function(e){var i=e.cueTime+this.timestampOffset;e.frames.forEach(function(e){var r=new n(i,i,e.value||e.url||e.data||"");r.frame=e,r.value=e,function(e){Object.defineProperties(e.frame,{id:{get:function(){return t.log.warn("cue.frame.id is deprecated. Use cue.value.key instead."),e.value.key}},value:{get:function(){return t.log.warn("cue.frame.value is deprecated. Use cue.value.data instead."),e.value.data}},privateData:{get:function(){return t.log.warn("cue.frame.privateData is deprecated. Use cue.value.data instead."),e.value.data}}})}(r),this.metadataTrack_.addCue(r)},this)},e),e.metadataTrack_&&e.metadataTrack_.cues&&e.metadataTrack_.cues.length){for(var s=e.metadataTrack_.cues,o=[],u=0;u<s.length;u++)s[u]&&o.push(s[u]);var d=o.reduce(function(e,t){var i=e[t.startTime]||[];return i.push(t),e[t.startTime]=i,e},{}),l=Object.keys(d).sort(function(e,t){return Number(e)-Number(t)});l.forEach(function(e,t){var i=d[e],r=Number(l[t+1])||a;i.forEach(function(e){e.endTime=r})})}}},we="undefined"!=typeof window?window:{},Ie="undefined"==typeof Symbol?"__target":Symbol(),Oe="application/javascript",Ce=we.BlobBuilder||we.WebKitBlobBuilder||we.MozBlobBuilder||we.MSBlobBuilder,Pe=we.URL||we.webkitURL||Pe&&Pe.msURL,Ue=we.Worker;function De(e,t){return function(i){var r=this;if(!t)return new Ue(e);if(Ue&&!i){var n=xe(t.toString().replace(/^function.+?{/,"").slice(0,-1));return this[Ie]=new Ue(n),function(e,t){if(!e||!t)return;var i=e.terminate;e.objURL=t,e.terminate=function(){e.objURL&&Pe.revokeObjectURL(e.objURL),i.call(e)}}(this[Ie],n),this[Ie]}var a={postMessage:function(e){r.onmessage&&setTimeout(function(){r.onmessage({data:e,target:a})})}};t.call(a),this.postMessage=function(e){setTimeout(function(){a.onmessage({data:e,target:r})})},this.isThisThread=!0}}if(Ue){var Re,Be=xe("self.onmessage = function () {}"),Me=new Uint8Array(1);try{(Re=new Ue(Be)).postMessage(Me,[Me.buffer])}catch(e){Ue=null}finally{Pe.revokeObjectURL(Be),Re&&Re.terminate()}}function xe(e){try{return Pe.createObjectURL(new Blob([e],{type:Oe}))}catch(i){var t=new Ce;return t.append(e),Pe.createObjectURL(t.getBlob(type))}}var Ne=new De("./transmuxer-worker.worker.js",function(e,t){var i=this;!function(){var t,r,n,a,s,o,u,d,l,c,h,f,p,m,g,y,_,v,b,T,S,k,E,L,A,w,I,O,C,P,U,D,R,B,M,x,N,q,F,H,G="undefined"!=typeof e?e:"undefined"!=typeof global?global:"undefined"!=typeof i?i:{},j="undefined"!=typeof e?e:"undefined"!=typeof G?G:"undefined"!=typeof i?i:{},W=Math.pow(2,32)-1;!function(){var e;if(k={avc1:[],avcC:[],btrt:[],dinf:[],dref:[],esds:[],ftyp:[],hdlr:[],mdat:[],mdhd:[],mdia:[],mfhd:[],minf:[],moof:[],moov:[],mp4a:[],mvex:[],mvhd:[],sdtp:[],smhd:[],stbl:[],stco:[],stsc:[],stsd:[],stsz:[],stts:[],styp:[],tfdt:[],tfhd:[],traf:[],trak:[],trun:[],trex:[],tkhd:[],vmhd:[]},"undefined"!=typeof Uint8Array){for(e in k)k.hasOwnProperty(e)&&(k[e]=[e.charCodeAt(0),e.charCodeAt(1),e.charCodeAt(2),e.charCodeAt(3)]);E=new Uint8Array(["i".charCodeAt(0),"s".charCodeAt(0),"o".charCodeAt(0),"m".charCodeAt(0)]),A=new Uint8Array(["a".charCodeAt(0),"v".charCodeAt(0),"c".charCodeAt(0),"1".charCodeAt(0)]),L=new Uint8Array([0,0,0,1]),w=new Uint8Array([0,0,0,0,0,0,0,0,118,105,100,101,0,0,0,0,0,0,0,0,0,0,0,0,86,105,100,101,111,72,97,110,100,108,101,114,0]),I=new Uint8Array([0,0,0,0,0,0,0,0,115,111,117,110,0,0,0,0,0,0,0,0,0,0,0,0,83,111,117,110,100,72,97,110,100,108,101,114,0]),O={video:w,audio:I},U=new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,12,117,114,108,32,0,0,0,1]),P=new Uint8Array([0,0,0,0,0,0,0,0]),D=new Uint8Array([0,0,0,0,0,0,0,0]),R=D,B=new Uint8Array([0,0,0,0,0,0,0,0,0,0,0,0]),M=D,C=new Uint8Array([0,0,0,1,0,0,0,0,0,0,0,0])}}(),t=function(e){var t,i,r=[],n=0;for(t=1;t<arguments.length;t++)r.push(arguments[t]);for(t=r.length;t--;)n+=r[t].byteLength;for(i=new Uint8Array(n+8),new DataView(i.buffer,i.byteOffset,i.byteLength).setUint32(0,i.byteLength),i.set(e,4),t=0,n=8;t<r.length;t++)i.set(r[t],n),n+=r[t].byteLength;return i},r=function(){return t(k.dinf,t(k.dref,U))},n=function(e){return t(k.esds,new Uint8Array([0,0,0,0,3,25,0,0,0,4,17,64,21,0,6,0,0,0,218,192,0,0,218,192,5,2,e.audioobjecttype<<3|e.samplingfrequencyindex>>>1,e.samplingfrequencyindex<<7|e.channelcount<<3,6,1,2]))},g=function(e){return t(k.hdlr,O[e])},m=function(e){var i=new Uint8Array([0,0,0,0,0,0,0,2,0,0,0,3,0,1,95,144,e.duration>>>24&255,e.duration>>>16&255,e.duration>>>8&255,255&e.duration,85,196,0,0]);return e.samplerate&&(i[12]=e.samplerate>>>24&255,i[13]=e.samplerate>>>16&255,i[14]=e.samplerate>>>8&255,i[15]=255&e.samplerate),t(k.mdhd,i)},p=function(e){return t(k.mdia,m(e),g(e.type),o(e))},s=function(e){return t(k.mfhd,new Uint8Array([0,0,0,0,(4278190080&e)>>24,(16711680&e)>>16,(65280&e)>>8,255&e]))},o=function(e){return t(k.minf,"video"===e.type?t(k.vmhd,C):t(k.smhd,P),r(),_(e))},u=function(e,i){for(var r=[],n=i.length;n--;)r[n]=b(i[n]);return t.apply(null,[k.moof,s(e)].concat(r))},d=function(e){for(var i=e.length,r=[];i--;)r[i]=h(e[i]);return t.apply(null,[k.moov,c(4294967295)].concat(r).concat(l(e)))},l=function(e){for(var i=e.length,r=[];i--;)r[i]=T(e[i]);return t.apply(null,[k.mvex].concat(r))},c=function(e){var i=new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,2,0,1,95,144,(4278190080&e)>>24,(16711680&e)>>16,(65280&e)>>8,255&e,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255]);return t(k.mvhd,i)},y=function(e){var i,r,n=e.samples||[],a=new Uint8Array(4+n.length);for(r=0;r<n.length;r++)i=n[r].flags,a[r+4]=i.dependsOn<<4|i.isDependedOn<<2|i.hasRedundancy;return t(k.sdtp,a)},_=function(e){return t(k.stbl,v(e),t(k.stts,M),t(k.stsc,R),t(k.stsz,B),t(k.stco,D))},v=function(e){return t(k.stsd,new Uint8Array([0,0,0,0,0,0,0,1]),"video"===e.type?x(e):N(e))},x=function(e){var i,r=e.sps||[],n=e.pps||[],a=[],s=[];for(i=0;i<r.length;i++)a.push((65280&r[i].byteLength)>>>8),a.push(255&r[i].byteLength),a=a.concat(Array.prototype.slice.call(r[i]));for(i=0;i<n.length;i++)s.push((65280&n[i].byteLength)>>>8),s.push(255&n[i].byteLength),s=s.concat(Array.prototype.slice.call(n[i]));return t(k.avc1,new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,(65280&e.width)>>8,255&e.width,(65280&e.height)>>8,255&e.height,0,72,0,0,0,72,0,0,0,0,0,0,0,1,19,118,105,100,101,111,106,115,45,99,111,110,116,114,105,98,45,104,108,115,0,0,0,0,0,0,0,0,0,0,0,0,0,24,17,17]),t(k.avcC,new Uint8Array([1,e.profileIdc,e.profileCompatibility,e.levelIdc,255].concat([r.length]).concat(a).concat([n.length]).concat(s))),t(k.btrt,new Uint8Array([0,28,156,128,0,45,198,192,0,45,198,192])))},N=function(e){return t(k.mp4a,new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,(65280&e.channelcount)>>8,255&e.channelcount,(65280&e.samplesize)>>8,255&e.samplesize,0,0,0,0,(65280&e.samplerate)>>8,255&e.samplerate,0,0]),n(e))},f=function(e){var i=new Uint8Array([0,0,0,7,0,0,0,0,0,0,0,0,(4278190080&e.id)>>24,(16711680&e.id)>>16,(65280&e.id)>>8,255&e.id,0,0,0,0,(4278190080&e.duration)>>24,(16711680&e.duration)>>16,(65280&e.duration)>>8,255&e.duration,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,(65280&e.width)>>8,255&e.width,0,0,(65280&e.height)>>8,255&e.height,0,0]);return t(k.tkhd,i)},b=function(e){var i,r,n,a,s,o;return i=t(k.tfhd,new Uint8Array([0,0,0,58,(4278190080&e.id)>>24,(16711680&e.id)>>16,(65280&e.id)>>8,255&e.id,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0])),s=Math.floor(e.baseMediaDecodeTime/(W+1)),o=Math.floor(e.baseMediaDecodeTime%(W+1)),r=t(k.tfdt,new Uint8Array([1,0,0,0,s>>>24&255,s>>>16&255,s>>>8&255,255&s,o>>>24&255,o>>>16&255,o>>>8&255,255&o])),92,"audio"===e.type?(n=S(e,92),t(k.traf,i,r,n)):(a=y(e),n=S(e,a.length+92),t(k.traf,i,r,n,a))},h=function(e){return e.duration=e.duration||4294967295,t(k.trak,f(e),p(e))},T=function(e){var i=new Uint8Array([0,0,0,0,(4278190080&e.id)>>24,(16711680&e.id)>>16,(65280&e.id)>>8,255&e.id,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,1]);return"video"!==e.type&&(i[i.length-1]=0),t(k.trex,i)},H=function(e,t){var i=0,r=0,n=0,a=0;return e.length&&(void 0!==e[0].duration&&(i=1),void 0!==e[0].size&&(r=2),void 0!==e[0].flags&&(n=4),void 0!==e[0].compositionTimeOffset&&(a=8)),[0,0,i|r|n|a,1,(4278190080&e.length)>>>24,(16711680&e.length)>>>16,(65280&e.length)>>>8,255&e.length,(4278190080&t)>>>24,(16711680&t)>>>16,(65280&t)>>>8,255&t]},F=function(e,i){var r,n,a,s;for(i+=20+16*(n=e.samples||[]).length,r=H(n,i),s=0;s<n.length;s++)a=n[s],r=r.concat([(4278190080&a.duration)>>>24,(16711680&a.duration)>>>16,(65280&a.duration)>>>8,255&a.duration,(4278190080&a.size)>>>24,(16711680&a.size)>>>16,(65280&a.size)>>>8,255&a.size,a.flags.isLeading<<2|a.flags.dependsOn,a.flags.isDependedOn<<6|a.flags.hasRedundancy<<4|a.flags.paddingValue<<1|a.flags.isNonSyncSample,61440&a.flags.degradationPriority,15&a.flags.degradationPriority,(4278190080&a.compositionTimeOffset)>>>24,(16711680&a.compositionTimeOffset)>>>16,(65280&a.compositionTimeOffset)>>>8,255&a.compositionTimeOffset]);return t(k.trun,new Uint8Array(r))},q=function(e,i){var r,n,a,s;for(i+=20+8*(n=e.samples||[]).length,r=H(n,i),s=0;s<n.length;s++)a=n[s],r=r.concat([(4278190080&a.duration)>>>24,(16711680&a.duration)>>>16,(65280&a.duration)>>>8,255&a.duration,(4278190080&a.size)>>>24,(16711680&a.size)>>>16,(65280&a.size)>>>8,255&a.size]);return t(k.trun,new Uint8Array(r))},S=function(e,t){return"audio"===e.type?q(e,t):F(e,t)};var V={ftyp:a=function(){return t(k.ftyp,E,L,E,A)},mdat:function(e){return t(k.mdat,e)},moof:u,moov:d,initSegment:function(e){var t,i=a(),r=d(e);return(t=new Uint8Array(i.byteLength+r.byteLength)).set(i),t.set(r,i.byteLength),t}},z=function(){this.init=function(){var e={};this.on=function(t,i){e[t]||(e[t]=[]),e[t]=e[t].concat(i)},this.off=function(t,i){var r;return!!e[t]&&(r=e[t].indexOf(i),e[t]=e[t].slice(),e[t].splice(r,1),r>-1)},this.trigger=function(t){var i,r,n,a;if(i=e[t])if(2===arguments.length)for(n=i.length,r=0;r<n;++r)i[r].call(this,arguments[1]);else{for(a=[],r=arguments.length,r=1;r<arguments.length;++r)a.push(arguments[r]);for(n=i.length,r=0;r<n;++r)i[r].apply(this,a)}},this.dispose=function(){e={}}}};z.prototype.pipe=function(e){return this.on("data",function(t){e.push(t)}),this.on("done",function(t){e.flush(t)}),e},z.prototype.push=function(e){this.trigger("data",e)},z.prototype.flush=function(e){this.trigger("done",e)};var X=z,Y=function e(){e.prototype.init.call(this),this.captionPackets_=[],this.ccStreams_=[new Z(0,0),new Z(0,1),new Z(1,0),new Z(1,1)],this.reset(),this.ccStreams_.forEach(function(e){e.on("data",this.trigger.bind(this,"data")),e.on("done",this.trigger.bind(this,"done"))},this)};(Y.prototype=new X).push=function(e){var t,i;if("sei_rbsp"===e.nalUnitType&&4===(t=function(e){for(var t=0,i={payloadType:-1,payloadSize:0},r=0,n=0;t<e.byteLength&&128!==e[t];){for(;255===e[t];)r+=255,t++;for(r+=e[t++];255===e[t];)n+=255,t++;if(n+=e[t++],!i.payload&&4===r){i.payloadType=r,i.payloadSize=n,i.payload=e.subarray(t,t+n);break}t+=n,r=0,n=0}return i}(e.escapedRBSP)).payloadType&&(i=function(e){return 181!==e.payload[0]?null:49!=(e.payload[1]<<8|e.payload[2])?null:"GA94"!==String.fromCharCode(e.payload[3],e.payload[4],e.payload[5],e.payload[6])?null:3!==e.payload[7]?null:e.payload.subarray(8,e.payload.length-1)}(t)))if(e.dts<this.latestDts_)this.ignoreNextEqualDts_=!0;else{if(e.dts===this.latestDts_&&this.ignoreNextEqualDts_)return this.numSameDts_--,void(this.numSameDts_||(this.ignoreNextEqualDts_=!1));this.captionPackets_=this.captionPackets_.concat(function(e,t){var i,r,n,a,s=[];if(!(64&t[0]))return s;for(r=31&t[0],i=0;i<r;i++)a={type:3&t[2+(n=3*i)],pts:e},4&t[n+2]&&(a.ccData=t[n+3]<<8|t[n+4],s.push(a));return s}(e.pts,i)),this.latestDts_!==e.dts&&(this.numSameDts_=0),this.numSameDts_++,this.latestDts_=e.dts}},Y.prototype.flush=function(){this.captionPackets_.length?(this.captionPackets_.forEach(function(e,t){e.presortIndex=t}),this.captionPackets_.sort(function(e,t){return e.pts===t.pts?e.presortIndex-t.presortIndex:e.pts-t.pts}),this.captionPackets_.forEach(function(e){e.type<2&&this.dispatchCea608Packet(e)},this),this.captionPackets_.length=0,this.ccStreams_.forEach(function(e){e.flush()},this)):this.ccStreams_.forEach(function(e){e.flush()},this)},Y.prototype.reset=function(){this.latestDts_=null,this.ignoreNextEqualDts_=!1,this.numSameDts_=0,this.activeCea608Channel_=[null,null],this.ccStreams_.forEach(function(e){e.reset()})},Y.prototype.dispatchCea608Packet=function(e){this.setsChannel1Active(e)?this.activeCea608Channel_[e.type]=0:this.setsChannel2Active(e)&&(this.activeCea608Channel_[e.type]=1),null!==this.activeCea608Channel_[e.type]&&this.ccStreams_[(e.type<<1)+this.activeCea608Channel_[e.type]].push(e)},Y.prototype.setsChannel1Active=function(e){return 4096==(30720&e.ccData)},Y.prototype.setsChannel2Active=function(e){return 6144==(30720&e.ccData)};var $={42:225,92:233,94:237,95:243,96:250,123:231,124:247,125:209,126:241,127:9608,304:174,305:176,306:189,307:191,308:8482,309:162,310:163,311:9834,312:224,313:160,314:232,315:226,316:234,317:238,318:244,319:251,544:193,545:201,546:211,547:218,548:220,549:252,550:8216,551:161,552:42,553:39,554:8212,555:169,556:8480,557:8226,558:8220,559:8221,560:192,561:194,562:199,563:200,564:202,565:203,566:235,567:206,568:207,569:239,570:212,571:217,572:249,573:219,574:171,575:187,800:195,801:227,802:205,803:204,804:236,805:210,806:242,807:213,808:245,809:123,810:125,811:92,812:94,813:95,814:124,815:126,816:196,817:228,818:214,819:246,820:223,821:165,822:164,823:9474,824:197,825:229,826:216,827:248,828:9484,829:9488,830:9492,831:9496},K=function(e){return null===e?"":(e=$[e]||e,String.fromCharCode(e))},Q=[4352,4384,4608,4640,5376,5408,5632,5664,5888,5920,4096,4864,4896,5120,5152],J=function(){for(var e=[],t=15;t--;)e.push("");return e},Z=function e(t,i){e.prototype.init.call(this),this.field_=t||0,this.dataChannel_=i||0,this.name_="CC"+(1+(this.field_<<1|this.dataChannel_)),this.setConstants(),this.reset(),this.push=function(e){var t,i,r,n,a;if((t=32639&e.ccData)!==this.lastControlCode_){if(4096==(61440&t)?this.lastControlCode_=t:t!==this.PADDING_&&(this.lastControlCode_=null),r=t>>>8,n=255&t,t!==this.PADDING_)if(t===this.RESUME_CAPTION_LOADING_)this.mode_="popOn";else if(t===this.END_OF_CAPTION_)this.clearFormatting(e.pts),this.flushDisplayed(e.pts),i=this.displayed_,this.displayed_=this.nonDisplayed_,this.nonDisplayed_=i,this.startPts_=e.pts;else if(t===this.ROLL_UP_2_ROWS_)this.topRow_=13,this.mode_="rollUp";else if(t===this.ROLL_UP_3_ROWS_)this.topRow_=12,this.mode_="rollUp";else if(t===this.ROLL_UP_4_ROWS_)this.topRow_=11,this.mode_="rollUp";else if(t===this.CARRIAGE_RETURN_)this.clearFormatting(e.pts),this.flushDisplayed(e.pts),this.shiftRowsUp_(),this.startPts_=e.pts;else if(t===this.BACKSPACE_)"popOn"===this.mode_?this.nonDisplayed_[14]=this.nonDisplayed_[14].slice(0,-1):this.displayed_[14]=this.displayed_[14].slice(0,-1);else if(t===this.ERASE_DISPLAYED_MEMORY_)this.flushDisplayed(e.pts),this.displayed_=J();else if(t===this.ERASE_NON_DISPLAYED_MEMORY_)this.nonDisplayed_=J();else if(t===this.RESUME_DIRECT_CAPTIONING_)this.mode_="paintOn";else if(this.isSpecialCharacter(r,n))a=K((r=(3&r)<<8)|n),this[this.mode_](e.pts,a),this.column_++;else if(this.isExtCharacter(r,n))"popOn"===this.mode_?this.nonDisplayed_[this.row_]=this.nonDisplayed_[this.row_].slice(0,-1):this.displayed_[14]=this.displayed_[14].slice(0,-1),a=K((r=(3&r)<<8)|n),this[this.mode_](e.pts,a),this.column_++;else if(this.isMidRowCode(r,n))this.clearFormatting(e.pts),this[this.mode_](e.pts," "),this.column_++,14==(14&n)&&this.addFormatting(e.pts,["i"]),1==(1&n)&&this.addFormatting(e.pts,["u"]);else if(this.isOffsetControlCode(r,n))this.column_+=3&n;else if(this.isPAC(r,n)){var s=Q.indexOf(7968&t);s!==this.row_&&(this.clearFormatting(e.pts),this.row_=s),1&n&&-1===this.formatting_.indexOf("u")&&this.addFormatting(e.pts,["u"]),16==(16&t)&&(this.column_=4*((14&t)>>1)),this.isColorPAC(n)&&14==(14&n)&&this.addFormatting(e.pts,["i"])}else this.isNormalChar(r)&&(0===n&&(n=null),a=K(r),a+=K(n),this[this.mode_](e.pts,a),this.column_+=a.length)}else this.lastControlCode_=null}};Z.prototype=new X,Z.prototype.flushDisplayed=function(e){var t=this.displayed_.map(function(e){return e.trim()}).join("\n").replace(/^\n+|\n+$/g,"");t.length&&this.trigger("data",{startPts:this.startPts_,endPts:e,text:t,stream:this.name_})},Z.prototype.reset=function(){this.mode_="popOn",this.topRow_=0,this.startPts_=0,this.displayed_=J(),this.nonDisplayed_=J(),this.lastControlCode_=null,this.column_=0,this.row_=14,this.formatting_=[]},Z.prototype.setConstants=function(){0===this.dataChannel_?(this.BASE_=16,this.EXT_=17,this.CONTROL_=(20|this.field_)<<8,this.OFFSET_=23):1===this.dataChannel_&&(this.BASE_=24,this.EXT_=25,this.CONTROL_=(28|this.field_)<<8,this.OFFSET_=31),this.PADDING_=0,this.RESUME_CAPTION_LOADING_=32|this.CONTROL_,this.END_OF_CAPTION_=47|this.CONTROL_,this.ROLL_UP_2_ROWS_=37|this.CONTROL_,this.ROLL_UP_3_ROWS_=38|this.CONTROL_,this.ROLL_UP_4_ROWS_=39|this.CONTROL_,this.CARRIAGE_RETURN_=45|this.CONTROL_,this.RESUME_DIRECT_CAPTIONING_=41|this.CONTROL_,this.BACKSPACE_=33|this.CONTROL_,this.ERASE_DISPLAYED_MEMORY_=44|this.CONTROL_,this.ERASE_NON_DISPLAYED_MEMORY_=46|this.CONTROL_},Z.prototype.isSpecialCharacter=function(e,t){return e===this.EXT_&&t>=48&&t<=63},Z.prototype.isExtCharacter=function(e,t){return(e===this.EXT_+1||e===this.EXT_+2)&&t>=32&&t<=63},Z.prototype.isMidRowCode=function(e,t){return e===this.EXT_&&t>=32&&t<=47},Z.prototype.isOffsetControlCode=function(e,t){return e===this.OFFSET_&&t>=33&&t<=35},Z.prototype.isPAC=function(e,t){return e>=this.BASE_&&e<this.BASE_+8&&t>=64&&t<=127},Z.prototype.isColorPAC=function(e){return e>=64&&e<=79||e>=96&&e<=127},Z.prototype.isNormalChar=function(e){return e>=32&&e<=127},Z.prototype.addFormatting=function(e,t){this.formatting_=this.formatting_.concat(t);var i=t.reduce(function(e,t){return e+"<"+t+">"},"");this[this.mode_](e,i)},Z.prototype.clearFormatting=function(e){if(this.formatting_.length){var t=this.formatting_.reverse().reduce(function(e,t){return e+"</"+t+">"},"");this.formatting_=[],this[this.mode_](e,t)}},Z.prototype.popOn=function(e,t){var i=this.nonDisplayed_[this.row_];i+=t,this.nonDisplayed_[this.row_]=i},Z.prototype.rollUp=function(e,t){var i=this.displayed_[14];i+=t,this.displayed_[14]=i},Z.prototype.shiftRowsUp_=function(){var e;for(e=0;e<this.topRow_;e++)this.displayed_[e]="";for(e=this.topRow_;e<14;e++)this.displayed_[e]=this.displayed_[e+1];this.displayed_[14]=""},Z.prototype.paintOn=function(){};var ee={CaptionStream:Y,Cea608Stream:Z},te={H264_STREAM_TYPE:27,ADTS_STREAM_TYPE:15,METADATA_STREAM_TYPE:21},ie=function(e,t){var i=1;for(e>t&&(i=-1);Math.abs(t-e)>4294967296;)e+=8589934592*i;return e},re=function e(t){var i,r;e.prototype.init.call(this),this.type_=t,this.push=function(e){e.type===this.type_&&(void 0===r&&(r=e.dts),e.dts=ie(e.dts,r),e.pts=ie(e.pts,r),i=e.dts,this.trigger("data",e))},this.flush=function(){r=i,this.trigger("done")},this.discontinuity=function(){r=void 0,i=void 0}};re.prototype=new X;var ne,ae=re,se=function(e,t,i){var r,n="";for(r=t;r<i;r++)n+="%"+("00"+e[r].toString(16)).slice(-2);return n},oe=function(e,t,i){return decodeURIComponent(se(e,t,i))},ue=function(e){return e[0]<<21|e[1]<<14|e[2]<<7|e[3]},de={TXXX:function(e){var t;if(3===e.data[0]){for(t=1;t<e.data.length;t++)if(0===e.data[t]){e.description=oe(e.data,1,t),e.value=oe(e.data,t+1,e.data.length).replace(/\0*$/,"");break}e.data=e.value}},WXXX:function(e){var t;if(3===e.data[0])for(t=1;t<e.data.length;t++)if(0===e.data[t]){e.description=oe(e.data,1,t),e.url=oe(e.data,t+1,e.data.length);break}},PRIV:function(e){var t,i;for(t=0;t<e.data.length;t++)if(0===e.data[t]){e.owner=(i=e.data,unescape(se(i,0,t)));break}e.privateData=e.data.subarray(t+1),e.data=e.privateData}};(ne=function(e){var t,i={debug:!(!e||!e.debug),descriptor:e&&e.descriptor},r=0,n=[],a=0;if(ne.prototype.init.call(this),this.dispatchType=te.METADATA_STREAM_TYPE.toString(16),i.descriptor)for(t=0;t<i.descriptor.length;t++)this.dispatchType+=("00"+i.descriptor[t].toString(16)).slice(-2);this.push=function(e){var t,s,o,u,d;if("timed-metadata"===e.type)if(e.dataAlignmentIndicator&&(a=0,n.length=0),0===n.length&&(e.data.length<10||e.data[0]!=="I".charCodeAt(0)||e.data[1]!=="D".charCodeAt(0)||e.data[2]!=="3".charCodeAt(0)))i.debug&&console.log("Skipping unrecognized metadata packet");else if(n.push(e),a+=e.data.byteLength,1===n.length&&(r=ue(e.data.subarray(6,10)),r+=10),!(a<r)){for(t={data:new Uint8Array(r),frames:[],pts:n[0].pts,dts:n[0].dts},d=0;d<r;)t.data.set(n[0].data.subarray(0,r-d),d),d+=n[0].data.byteLength,a-=n[0].data.byteLength,n.shift();s=10,64&t.data[5]&&(s+=4,s+=ue(t.data.subarray(10,14)),r-=ue(t.data.subarray(16,20)));do{if((o=ue(t.data.subarray(s+4,s+8)))<1)return console.log("Malformed ID3 frame encountered. Skipping metadata parsing.");if((u={id:String.fromCharCode(t.data[s],t.data[s+1],t.data[s+2],t.data[s+3]),data:t.data.subarray(s+10,s+o+10)}).key=u.id,de[u.id]&&(de[u.id](u),"com.apple.streaming.transportStreamTimestamp"===u.owner)){var l=u.data,c=(1&l[3])<<30|l[4]<<22|l[5]<<14|l[6]<<6|l[7]>>>2;c*=4,c+=3&l[7],u.timeStamp=c,void 0===t.pts&&void 0===t.dts&&(t.pts=u.timeStamp,t.dts=u.timeStamp),this.trigger("timestamp",u)}t.frames.push(u),s+=10,s+=o}while(s<r);this.trigger("data",t)}}}).prototype=new X;var le,ce,he,fe=ne,pe=ae;(le=function(){var e=new Uint8Array(188),t=0;le.prototype.init.call(this),this.push=function(i){var r,n=0,a=188;for(t?((r=new Uint8Array(i.byteLength+t)).set(e.subarray(0,t)),r.set(i,t),t=0):r=i;a<r.byteLength;)71!==r[n]||71!==r[a]?(n++,a++):(this.trigger("data",r.subarray(n,a)),n+=188,a+=188);n<r.byteLength&&(e.set(r.subarray(n),0),t=r.byteLength-n)},this.flush=function(){188===t&&71===e[0]&&(this.trigger("data",e),t=0),this.trigger("done")}}).prototype=new X,(ce=function(){var e,t,i,r;ce.prototype.init.call(this),r=this,this.packetsWaitingForPmt=[],this.programMapTable=void 0,e=function(e,r){var n=0;r.payloadUnitStartIndicator&&(n+=e[n]+1),"pat"===r.type?t(e.subarray(n),r):i(e.subarray(n),r)},t=function(e,t){t.section_number=e[7],t.last_section_number=e[8],r.pmtPid=(31&e[10])<<8|e[11],t.pmtPid=r.pmtPid},i=function(e,t){var i,n;if(1&e[5]){for(r.programMapTable={video:null,audio:null,"timed-metadata":{}},i=3+((15&e[1])<<8|e[2])-4,n=12+((15&e[10])<<8|e[11]);n<i;){var a=e[n],s=(31&e[n+1])<<8|e[n+2];a===te.H264_STREAM_TYPE&&null===r.programMapTable.video?r.programMapTable.video=s:a===te.ADTS_STREAM_TYPE&&null===r.programMapTable.audio?r.programMapTable.audio=s:a===te.METADATA_STREAM_TYPE&&(r.programMapTable["timed-metadata"][s]=a),n+=5+((15&e[n+3])<<8|e[n+4])}t.programMapTable=r.programMapTable}},this.push=function(t){var i={},r=4;if(i.payloadUnitStartIndicator=!!(64&t[1]),i.pid=31&t[1],i.pid<<=8,i.pid|=t[2],(48&t[3])>>>4>1&&(r+=t[r]+1),0===i.pid)i.type="pat",e(t.subarray(r),i),this.trigger("data",i);else if(i.pid===this.pmtPid)for(i.type="pmt",e(t.subarray(r),i),this.trigger("data",i);this.packetsWaitingForPmt.length;)this.processPes_.apply(this,this.packetsWaitingForPmt.shift());else void 0===this.programMapTable?this.packetsWaitingForPmt.push([t,r,i]):this.processPes_(t,r,i)},this.processPes_=function(e,t,i){i.pid===this.programMapTable.video?i.streamType=te.H264_STREAM_TYPE:i.pid===this.programMapTable.audio?i.streamType=te.ADTS_STREAM_TYPE:i.streamType=this.programMapTable["timed-metadata"][i.pid],i.type="pes",i.data=e.subarray(t),this.trigger("data",i)}}).prototype=new X,ce.STREAM_TYPES={h264:27,adts:15},(he=function(){var e=this,t={data:[],size:0},i={data:[],size:0},r={data:[],size:0},n=function(t,i,r){var n,a,s=new Uint8Array(t.size),o={type:i},u=0,d=0;if(t.data.length&&!(t.size<9)){for(o.trackId=t.data[0].pid,u=0;u<t.data.length;u++)a=t.data[u],s.set(a.data,d),d+=a.data.byteLength;var l,c,h;l=s,(c=o).packetLength=6+(l[4]<<8|l[5]),c.dataAlignmentIndicator=0!=(4&l[6]),192&(h=l[7])&&(c.pts=(14&l[9])<<27|(255&l[10])<<20|(254&l[11])<<12|(255&l[12])<<5|(254&l[13])>>>3,c.pts*=4,c.pts+=(6&l[13])>>>1,c.dts=c.pts,64&h&&(c.dts=(14&l[14])<<27|(255&l[15])<<20|(254&l[16])<<12|(255&l[17])<<5|(254&l[18])>>>3,c.dts*=4,c.dts+=(6&l[18])>>>1)),c.data=l.subarray(9+l[8]),n="video"===i||o.packetLength<=t.size,(r||n)&&(t.size=0,t.data.length=0),n&&e.trigger("data",o)}};he.prototype.init.call(this),this.push=function(a){({pat:function(){},pes:function(){var e,s;switch(a.streamType){case te.H264_STREAM_TYPE:case te.H264_STREAM_TYPE:e=t,s="video";break;case te.ADTS_STREAM_TYPE:e=i,s="audio";break;case te.METADATA_STREAM_TYPE:e=r,s="timed-metadata";break;default:return}a.payloadUnitStartIndicator&&n(e,s,!0),e.data.push(a),e.size+=a.data.byteLength},pmt:function(){var t={type:"metadata",tracks:[]},i=a.programMapTable;null!==i.video&&t.tracks.push({timelineStartInfo:{baseMediaDecodeTime:0},id:+i.video,codec:"avc",type:"video"}),null!==i.audio&&t.tracks.push({timelineStartInfo:{baseMediaDecodeTime:0},id:+i.audio,codec:"adts",type:"audio"}),e.trigger("data",t)}})[a.type]()},this.flush=function(){n(t,"video"),n(i,"audio"),n(r,"timed-metadata"),this.trigger("done")}}).prototype=new X;var me={PAT_PID:0,MP2T_PACKET_LENGTH:188,TransportPacketStream:le,TransportParseStream:ce,ElementaryStream:he,TimestampRolloverStream:pe,CaptionStream:ee.CaptionStream,Cea608Stream:ee.Cea608Stream,MetadataStream:fe};for(var ge in te)te.hasOwnProperty(ge)&&(me[ge]=te[ge]);var ye,_e=me,ve=[96e3,88200,64e3,48e3,44100,32e3,24e3,22050,16e3,12e3,11025,8e3,7350];(ye=function(){var e;ye.prototype.init.call(this),this.push=function(t){var i,r,n,a,s,o,u=0,d=0;if("audio"===t.type)for(e?(a=e,(e=new Uint8Array(a.byteLength+t.data.byteLength)).set(a),e.set(t.data,a.byteLength)):e=t.data;u+5<e.length;)if(255===e[u]&&240==(246&e[u+1])){if(r=2*(1&~e[u+1]),i=(3&e[u+3])<<11|e[u+4]<<3|(224&e[u+5])>>5,o=9e4*(s=1024*(1+(3&e[u+6])))/ve[(60&e[u+2])>>>2],n=u+i,e.byteLength<n)return;if(this.trigger("data",{pts:t.pts+d*o,dts:t.dts+d*o,sampleCount:s,audioobjecttype:1+(e[u+2]>>>6&3),channelcount:(1&e[u+2])<<2|(192&e[u+3])>>>6,samplerate:ve[(60&e[u+2])>>>2],samplingfrequencyindex:(60&e[u+2])>>>2,samplesize:16,data:e.subarray(u+7+r,n)}),e.byteLength===n)return void(e=void 0);d++,e=e.subarray(n)}else u++},this.flush=function(){this.trigger("done")}}).prototype=new X;var be,Te,Se,ke=ye,Ee=function(e){var t=e.byteLength,i=0,r=0;this.length=function(){return 8*t},this.bitsAvailable=function(){return 8*t+r},this.loadWord=function(){var n=e.byteLength-t,a=new Uint8Array(4),s=Math.min(4,t);if(0===s)throw new Error("no bytes available");a.set(e.subarray(n,n+s)),i=new DataView(a.buffer).getUint32(0),r=8*s,t-=s},this.skipBits=function(e){var n;r>e?(i<<=e,r-=e):(e-=r,e-=8*(n=Math.floor(e/8)),t-=n,this.loadWord(),i<<=e,r-=e)},this.readBits=function(e){var n=Math.min(r,e),a=i>>>32-n;return(r-=n)>0?i<<=n:t>0&&this.loadWord(),(n=e-n)>0?a<<n|this.readBits(n):a},this.skipLeadingZeros=function(){var e;for(e=0;e<r;++e)if(0!=(i&2147483648>>>e))return i<<=e,r-=e,e;return this.loadWord(),e+this.skipLeadingZeros()},this.skipUnsignedExpGolomb=function(){this.skipBits(1+this.skipLeadingZeros())},this.skipExpGolomb=function(){this.skipBits(1+this.skipLeadingZeros())},this.readUnsignedExpGolomb=function(){var e=this.skipLeadingZeros();return this.readBits(e+1)-1},this.readExpGolomb=function(){var e=this.readUnsignedExpGolomb();return 1&e?1+e>>>1:-1*(e>>>1)},this.readBoolean=function(){return 1===this.readBits(1)},this.readUnsignedByte=function(){return this.readBits(8)},this.loadWord()};(Te=function(){var e,t,i=0;Te.prototype.init.call(this),this.push=function(r){var n;for(t?((n=new Uint8Array(t.byteLength+r.data.byteLength)).set(t),n.set(r.data,t.byteLength),t=n):t=r.data;i<t.byteLength-3;i++)if(1===t[i+2]){e=i+5;break}for(;e<t.byteLength;)switch(t[e]){case 0:if(0!==t[e-1]){e+=2;break}if(0!==t[e-2]){e++;break}i+3!==e-2&&this.trigger("data",t.subarray(i+3,e-2));do{e++}while(1!==t[e]&&e<t.length);i=e-2,e+=3;break;case 1:if(0!==t[e-1]||0!==t[e-2]){e+=3;break}this.trigger("data",t.subarray(i+3,e-2)),i=e-2,e+=3;break;default:e+=3}t=t.subarray(i),e-=i,i=0},this.flush=function(){t&&t.byteLength>3&&this.trigger("data",t.subarray(i+3)),t=null,i=0,this.trigger("done")}}).prototype=new X,Se={100:!0,110:!0,122:!0,244:!0,44:!0,83:!0,86:!0,118:!0,128:!0,138:!0,139:!0,134:!0},(be=function(){var e,t,i,r,n,a,s,o=new Te;be.prototype.init.call(this),e=this,this.push=function(e){"video"===e.type&&(t=e.trackId,i=e.pts,r=e.dts,o.push(e))},o.on("data",function(s){var o={trackId:t,pts:i,dts:r,data:s};switch(31&s[0]){case 5:o.nalUnitType="slice_layer_without_partitioning_rbsp_idr";break;case 6:o.nalUnitType="sei_rbsp",o.escapedRBSP=n(s.subarray(1));break;case 7:o.nalUnitType="seq_parameter_set_rbsp",o.escapedRBSP=n(s.subarray(1)),o.config=a(o.escapedRBSP);break;case 8:o.nalUnitType="pic_parameter_set_rbsp";break;case 9:o.nalUnitType="access_unit_delimiter_rbsp"}e.trigger("data",o)}),o.on("done",function(){e.trigger("done")}),this.flush=function(){o.flush()},s=function(e,t){var i,r=8,n=8;for(i=0;i<e;i++)0!==n&&(n=(r+t.readExpGolomb()+256)%256),r=0===n?r:n},n=function(e){for(var t,i,r=e.byteLength,n=[],a=1;a<r-2;)0===e[a]&&0===e[a+1]&&3===e[a+2]?(n.push(a+2),a+=2):a++;if(0===n.length)return e;t=r-n.length,i=new Uint8Array(t);var s=0;for(a=0;a<t;s++,a++)s===n[0]&&(s++,n.shift()),i[a]=e[s];return i},a=function(e){var t,i,r,n,a,o,u,d,l,c,h,f,p,m=0,g=0,y=0,_=0,v=1;if(i=(t=new Ee(e)).readUnsignedByte(),n=t.readUnsignedByte(),r=t.readUnsignedByte(),t.skipUnsignedExpGolomb(),Se[i]&&(3===(a=t.readUnsignedExpGolomb())&&t.skipBits(1),t.skipUnsignedExpGolomb(),t.skipUnsignedExpGolomb(),t.skipBits(1),t.readBoolean()))for(h=3!==a?8:12,p=0;p<h;p++)t.readBoolean()&&s(p<6?16:64,t);if(t.skipUnsignedExpGolomb(),0===(o=t.readUnsignedExpGolomb()))t.readUnsignedExpGolomb();else if(1===o)for(t.skipBits(1),t.skipExpGolomb(),t.skipExpGolomb(),u=t.readUnsignedExpGolomb(),p=0;p<u;p++)t.skipExpGolomb();if(t.skipUnsignedExpGolomb(),t.skipBits(1),d=t.readUnsignedExpGolomb(),l=t.readUnsignedExpGolomb(),0===(c=t.readBits(1))&&t.skipBits(1),t.skipBits(1),t.readBoolean()&&(m=t.readUnsignedExpGolomb(),g=t.readUnsignedExpGolomb(),y=t.readUnsignedExpGolomb(),_=t.readUnsignedExpGolomb()),t.readBoolean()&&t.readBoolean()){switch(t.readUnsignedByte()){case 1:f=[1,1];break;case 2:f=[12,11];break;case 3:f=[10,11];break;case 4:f=[16,11];break;case 5:f=[40,33];break;case 6:f=[24,11];break;case 7:f=[20,11];break;case 8:f=[32,11];break;case 9:f=[80,33];break;case 10:f=[18,11];break;case 11:f=[15,11];break;case 12:f=[64,33];break;case 13:f=[160,99];break;case 14:f=[4,3];break;case 15:f=[3,2];break;case 16:f=[2,1];break;case 255:f=[t.readUnsignedByte()<<8|t.readUnsignedByte(),t.readUnsignedByte()<<8|t.readUnsignedByte()]}f&&(v=f[0]/f[1])}return{profileIdc:i,levelIdc:r,profileCompatibility:n,width:Math.ceil((16*(d+1)-2*m-2*g)*v),height:(2-c)*(l+1)*16-2*y-2*_}}}).prototype=new X;var Le,Ae={H264Stream:be,NalByteStream:Te};(Le=function(){var e=new Uint8Array,t=0;Le.prototype.init.call(this),this.setTimestamp=function(e){t=e},this.parseId3TagSize=function(e,t){var i=e[t+6]<<21|e[t+7]<<14|e[t+8]<<7|e[t+9];return(16&e[t+5])>>4?i+20:i+10},this.parseAdtsSize=function(e,t){var i=(224&e[t+5])>>5,r=e[t+4]<<3;return 6144&e[t+3]|r|i},this.push=function(i){var r,n,a,s,o=0,u=0;for(e.length?(s=e.length,(e=new Uint8Array(i.byteLength+s)).set(e.subarray(0,s)),e.set(i,s)):e=i;e.length-u>=3;)if(e[u]!=="I".charCodeAt(0)||e[u+1]!=="D".charCodeAt(0)||e[u+2]!=="3".charCodeAt(0))if(!0&e[u]&&240==(240&e[u+1])){if(e.length-u<7)break;if((o=this.parseAdtsSize(e,u))>e.length)break;a={type:"audio",data:e.subarray(u,u+o),pts:t,dts:t},this.trigger("data",a),u+=o}else u++;else{if(e.length-u<10)break;if((o=this.parseId3TagSize(e,u))>e.length)break;n={type:"timed-metadata",data:e.subarray(u,u+o)},this.trigger("data",n),u+=o}r=e.length-u,e=r>0?e.subarray(u):new Uint8Array}}).prototype=new X;var we,Ie,Oe,Ce,Pe,Ue,De,Re,Be,Me,xe,Ne,qe,Fe,He,Ge=Le,je=[33,16,5,32,164,27],We=[33,65,108,84,1,2,4,8,168,2,4,8,17,191,252],Ve=function(e){for(var t=[];e--;)t.push(0);return t},ze={96000:[je,[227,64],Ve(154),[56]],88200:[je,[231],Ve(170),[56]],64000:[je,[248,192],Ve(240),[56]],48000:[je,[255,192],Ve(268),[55,148,128],Ve(54),[112]],44100:[je,[255,192],Ve(268),[55,163,128],Ve(84),[112]],32000:[je,[255,192],Ve(268),[55,234],Ve(226),[112]],24000:[je,[255,192],Ve(268),[55,255,128],Ve(268),[111,112],Ve(126),[224]],16000:[je,[255,192],Ve(268),[55,255,128],Ve(268),[111,255],Ve(269),[223,108],Ve(195),[1,192]],12000:[We,Ve(268),[3,127,248],Ve(268),[6,255,240],Ve(268),[13,255,224],Ve(268),[27,253,128],Ve(259),[56]],11025:[We,Ve(268),[3,127,248],Ve(268),[6,255,240],Ve(268),[13,255,224],Ve(268),[27,255,192],Ve(268),[55,175,128],Ve(108),[112]],8000:[We,Ve(268),[3,121,16],Ve(47),[7]]},Xe=(we=ze,Object.keys(we).reduce(function(e,t){return e[t]=new Uint8Array(we[t].reduce(function(e,t){return e.concat(t)},[])),e},{})),Ye=(Ie=function(e){return 9e4*e},Oe=function(e,t){return e*t},Ce=function(e){return e/9e4},Pe=function(e,t){return e/t},function(e,t){return Ie(Pe(e,t))}),$e=function(e,t){return Oe(Ce(e),t)},Ke=Ae.H264Stream,Qe=["audioobjecttype","channelcount","samplerate","samplingfrequencyindex","samplesize"],Je=["width","height","profileIdc","levelIdc","profileCompatibility"];Me=function(e){return e[0]==="I".charCodeAt(0)&&e[1]==="D".charCodeAt(0)&&e[2]==="3".charCodeAt(0)},Fe=function(e,t){var i;if(e.length!==t.length)return!1;for(i=0;i<e.length;i++)if(e[i]!==t[i])return!1;return!0},He=function(e){var t,i=0;for(t=0;t<e.length;t++)i+=e[t].data.byteLength;return i},(De=function(e,t){var i=[],r=0,n=0,a=0,s=1/0;t=t||{},De.prototype.init.call(this),this.push=function(t){xe(e,t),e&&Qe.forEach(function(i){e[i]=t[i]}),i.push(t)},this.setEarliestDts=function(t){n=t-e.timelineStartInfo.baseMediaDecodeTime},this.setVideoBaseMediaDecodeTime=function(e){s=e},this.setAudioAppendStart=function(e){a=e},this.flush=function(){var n,a,s,o;0!==i.length?(n=this.trimAdtsFramesByEarliestDts_(i),e.baseMediaDecodeTime=qe(e,t.keepOriginalTimestamps),this.prefixWithSilence_(e,n),e.samples=this.generateSampleTable_(n),s=V.mdat(this.concatenateFrameData_(n)),i=[],a=V.moof(r,[e]),o=new Uint8Array(a.byteLength+s.byteLength),r++,o.set(a),o.set(s,a.byteLength),Ne(e),this.trigger("data",{track:e,boxes:o}),this.trigger("done","AudioSegmentStream")):this.trigger("done","AudioSegmentStream")},this.prefixWithSilence_=function(e,t){var i,r,n,o,u=0,d=0,l=0;if(t.length&&(i=Ye(e.baseMediaDecodeTime,e.samplerate),r=Math.ceil(9e4/(e.samplerate/1024)),a&&s&&(u=i-Math.max(a,s),l=(d=Math.floor(u/r))*r),!(d<1||l>45e3))){for((n=Xe[e.samplerate])||(n=t[0].data),o=0;o<d;o++)t.splice(o,0,{data:n});e.baseMediaDecodeTime-=Math.floor($e(l,e.samplerate))}},this.trimAdtsFramesByEarliestDts_=function(t){return e.minSegmentDts>=n?t:(e.minSegmentDts=1/0,t.filter(function(t){return t.dts>=n&&(e.minSegmentDts=Math.min(e.minSegmentDts,t.dts),e.minSegmentPts=e.minSegmentDts,!0)}))},this.generateSampleTable_=function(e){var t,i,r=[];for(t=0;t<e.length;t++)i=e[t],r.push({size:i.data.byteLength,duration:1024});return r},this.concatenateFrameData_=function(e){var t,i,r=0,n=new Uint8Array(He(e));for(t=0;t<e.length;t++)i=e[t],n.set(i.data,r),r+=i.data.byteLength;return n}}).prototype=new X,(Ue=function(e,t){var i,r,n=0,a=[],s=[];t=t||{},Ue.prototype.init.call(this),delete e.minPTS,this.gopCache_=[],this.push=function(t){xe(e,t),"seq_parameter_set_rbsp"!==t.nalUnitType||i||(i=t.config,e.sps=[t.data],Je.forEach(function(t){e[t]=i[t]},this)),"pic_parameter_set_rbsp"!==t.nalUnitType||r||(r=t.data,e.pps=[t.data]),a.push(t)},this.flush=function(){for(var i,r,o,u,d,l;a.length&&"access_unit_delimiter_rbsp"!==a[0].nalUnitType;)a.shift();if(0===a.length)return this.resetStream_(),void this.trigger("done","VideoSegmentStream");if(i=this.groupNalsIntoFrames_(a),(o=this.groupFramesIntoGops_(i))[0][0].keyFrame||((r=this.getGopForFusion_(a[0],e))?(o.unshift(r),o.byteLength+=r.byteLength,o.nalCount+=r.nalCount,o.pts=r.pts,o.dts=r.dts,o.duration+=r.duration):o=this.extendFirstKeyFrame_(o)),s.length){var c;if(!(c=t.alignGopsAtEnd?this.alignGopsAtEnd_(o):this.alignGopsAtStart_(o)))return this.gopCache_.unshift({gop:o.pop(),pps:e.pps,sps:e.sps}),this.gopCache_.length=Math.min(6,this.gopCache_.length),a=[],this.resetStream_(),void this.trigger("done","VideoSegmentStream");Ne(e),o=c}xe(e,o),e.samples=this.generateSampleTable_(o),d=V.mdat(this.concatenateNalData_(o)),e.baseMediaDecodeTime=qe(e,t.keepOriginalTimestamps),this.trigger("processedGopsInfo",o.map(function(e){return{pts:e.pts,dts:e.dts,byteLength:e.byteLength}})),this.gopCache_.unshift({gop:o.pop(),pps:e.pps,sps:e.sps}),this.gopCache_.length=Math.min(6,this.gopCache_.length),a=[],this.trigger("baseMediaDecodeTime",e.baseMediaDecodeTime),this.trigger("timelineStartInfo",e.timelineStartInfo),u=V.moof(n,[e]),l=new Uint8Array(u.byteLength+d.byteLength),n++,l.set(u),l.set(d,u.byteLength),this.trigger("data",{track:e,boxes:l}),this.resetStream_(),this.trigger("done","VideoSegmentStream")},this.resetStream_=function(){Ne(e),i=void 0,r=void 0},this.getGopForFusion_=function(t){var i,r,n,a,s,o=1/0;for(s=0;s<this.gopCache_.length;s++)n=(a=this.gopCache_[s]).gop,e.pps&&Fe(e.pps[0],a.pps[0])&&e.sps&&Fe(e.sps[0],a.sps[0])&&(n.dts<e.timelineStartInfo.dts||(i=t.dts-n.dts-n.duration)>=-1e4&&i<=45e3&&(!r||o>i)&&(r=a,o=i));return r?r.gop:null},this.extendFirstKeyFrame_=function(e){var t;return!e[0][0].keyFrame&&e.length>1&&(t=e.shift(),e.byteLength-=t.byteLength,e.nalCount-=t.nalCount,e[0][0].dts=t.dts,e[0][0].pts=t.pts,e[0][0].duration+=t.duration),e},this.groupNalsIntoFrames_=function(e){var t,i,r=[],n=[];for(r.byteLength=0,t=0;t<e.length;t++)"access_unit_delimiter_rbsp"===(i=e[t]).nalUnitType?(r.length&&(r.duration=i.dts-r.dts,n.push(r)),(r=[i]).byteLength=i.data.byteLength,r.pts=i.pts,r.dts=i.dts):("slice_layer_without_partitioning_rbsp_idr"===i.nalUnitType&&(r.keyFrame=!0),r.duration=i.dts-r.dts,r.byteLength+=i.data.byteLength,r.push(i));return n.length&&(!r.duration||r.duration<=0)&&(r.duration=n[n.length-1].duration),n.push(r),n},this.groupFramesIntoGops_=function(e){var t,i,r=[],n=[];for(r.byteLength=0,r.nalCount=0,r.duration=0,r.pts=e[0].pts,r.dts=e[0].dts,n.byteLength=0,n.nalCount=0,n.duration=0,n.pts=e[0].pts,n.dts=e[0].dts,t=0;t<e.length;t++)(i=e[t]).keyFrame?(r.length&&(n.push(r),n.byteLength+=r.byteLength,n.nalCount+=r.nalCount,n.duration+=r.duration),(r=[i]).nalCount=i.length,r.byteLength=i.byteLength,r.pts=i.pts,r.dts=i.dts,r.duration=i.duration):(r.duration+=i.duration,r.nalCount+=i.length,r.byteLength+=i.byteLength,r.push(i));return n.length&&r.duration<=0&&(r.duration=n[n.length-1].duration),n.byteLength+=r.byteLength,n.nalCount+=r.nalCount,n.duration+=r.duration,n.push(r),n},this.generateSampleTable_=function(e,t){var i,r,n,a,s,o=t||0,u=[];for(i=0;i<e.length;i++)for(a=e[i],r=0;r<a.length;r++)s=a[r],(n={size:0,flags:{isLeading:0,dependsOn:1,isDependedOn:0,hasRedundancy:0,degradationPriority:0}}).dataOffset=o,n.compositionTimeOffset=s.pts-s.dts,n.duration=s.duration,n.size=4*s.length,n.size+=s.byteLength,s.keyFrame&&(n.flags.dependsOn=2),o+=n.size,u.push(n);return u},this.concatenateNalData_=function(e){var t,i,r,n,a,s,o=0,u=e.byteLength,d=e.nalCount,l=new Uint8Array(u+4*d),c=new DataView(l.buffer);for(t=0;t<e.length;t++)for(n=e[t],i=0;i<n.length;i++)for(a=n[i],r=0;r<a.length;r++)s=a[r],c.setUint32(o,s.data.byteLength),o+=4,l.set(s.data,o),o+=s.data.byteLength;return l},this.alignGopsAtStart_=function(e){var t,i,r,n,a,o,u,d;for(a=e.byteLength,o=e.nalCount,u=e.duration,t=i=0;t<s.length&&i<e.length&&(r=s[t],n=e[i],r.pts!==n.pts);)n.pts>r.pts?t++:(i++,a-=n.byteLength,o-=n.nalCount,u-=n.duration);return 0===i?e:i===e.length?null:((d=e.slice(i)).byteLength=a,d.duration=u,d.nalCount=o,d.pts=d[0].pts,d.dts=d[0].dts,d)},this.alignGopsAtEnd_=function(e){var t,i,r,n,a,o,u;for(t=s.length-1,i=e.length-1,a=null,o=!1;t>=0&&i>=0;){if(r=s[t],n=e[i],r.pts===n.pts){o=!0;break}r.pts>n.pts?t--:(t===s.length-1&&(a=i),i--)}if(!o&&null===a)return null;if(0===(u=o?i:a))return e;var d=e.slice(u),l=d.reduce(function(e,t){return e.byteLength+=t.byteLength,e.duration+=t.duration,e.nalCount+=t.nalCount,e},{byteLength:0,duration:0,nalCount:0});return d.byteLength=l.byteLength,d.duration=l.duration,d.nalCount=l.nalCount,d.pts=d[0].pts,d.dts=d[0].dts,d},this.alignGopsWith=function(e){s=e}}).prototype=new X,xe=function(e,t){"number"==typeof t.pts&&(void 0===e.timelineStartInfo.pts&&(e.timelineStartInfo.pts=t.pts),void 0===e.minSegmentPts?e.minSegmentPts=t.pts:e.minSegmentPts=Math.min(e.minSegmentPts,t.pts),void 0===e.maxSegmentPts?e.maxSegmentPts=t.pts:e.maxSegmentPts=Math.max(e.maxSegmentPts,t.pts)),"number"==typeof t.dts&&(void 0===e.timelineStartInfo.dts&&(e.timelineStartInfo.dts=t.dts),void 0===e.minSegmentDts?e.minSegmentDts=t.dts:e.minSegmentDts=Math.min(e.minSegmentDts,t.dts),void 0===e.maxSegmentDts?e.maxSegmentDts=t.dts:e.maxSegmentDts=Math.max(e.maxSegmentDts,t.dts))},Ne=function(e){delete e.minSegmentDts,delete e.maxSegmentDts,delete e.minSegmentPts,delete e.maxSegmentPts},qe=function(e,t){var i,r=e.minSegmentDts;return t||(r-=e.timelineStartInfo.dts),i=e.timelineStartInfo.baseMediaDecodeTime,i+=r,i=Math.max(0,i),"audio"===e.type&&(i*=e.samplerate/9e4,i=Math.floor(i)),i},(Be=function(e,t){this.numberOfTracks=0,this.metadataStream=t,"undefined"!=typeof e.remux?this.remuxTracks=!!e.remux:this.remuxTracks=!0,this.pendingTracks=[],this.videoTrack=null,this.pendingBoxes=[],this.pendingCaptions=[],this.pendingMetadata=[],this.pendingBytes=0,this.emittedTracks=0,Be.prototype.init.call(this),this.push=function(e){return e.text?this.pendingCaptions.push(e):e.frames?this.pendingMetadata.push(e):(this.pendingTracks.push(e.track),this.pendingBoxes.push(e.boxes),this.pendingBytes+=e.boxes.byteLength,"video"===e.track.type&&(this.videoTrack=e.track),void("audio"===e.track.type&&(this.audioTrack=e.track)))}}).prototype=new X,Be.prototype.flush=function(e){var t,i,r,n,a=0,s={captions:[],captionStreams:{},metadata:[],info:{}},o=0;if(this.pendingTracks.length<this.numberOfTracks){if("VideoSegmentStream"!==e&&"AudioSegmentStream"!==e)return;if(this.remuxTracks)return;if(0===this.pendingTracks.length)return this.emittedTracks++,void(this.emittedTracks>=this.numberOfTracks&&(this.trigger("done"),this.emittedTracks=0))}for(this.videoTrack?(o=this.videoTrack.timelineStartInfo.pts,Je.forEach(function(e){s.info[e]=this.videoTrack[e]},this)):this.audioTrack&&(o=this.audioTrack.timelineStartInfo.pts,Qe.forEach(function(e){s.info[e]=this.audioTrack[e]},this)),1===this.pendingTracks.length?s.type=this.pendingTracks[0].type:s.type="combined",this.emittedTracks+=this.pendingTracks.length,r=V.initSegment(this.pendingTracks),s.initSegment=new Uint8Array(r.byteLength),s.initSegment.set(r),s.data=new Uint8Array(this.pendingBytes),n=0;n<this.pendingBoxes.length;n++)s.data.set(this.pendingBoxes[n],a),a+=this.pendingBoxes[n].byteLength;for(n=0;n<this.pendingCaptions.length;n++)(t=this.pendingCaptions[n]).startTime=t.startPts-o,t.startTime/=9e4,t.endTime=t.endPts-o,t.endTime/=9e4,s.captionStreams[t.stream]=!0,s.captions.push(t);for(n=0;n<this.pendingMetadata.length;n++)(i=this.pendingMetadata[n]).cueTime=i.pts-o,i.cueTime/=9e4,s.metadata.push(i);s.metadata.dispatchType=this.metadataStream.dispatchType,this.pendingTracks.length=0,this.videoTrack=null,this.pendingBoxes.length=0,this.pendingCaptions.length=0,this.pendingBytes=0,this.pendingMetadata.length=0,this.trigger("data",s),this.emittedTracks>=this.numberOfTracks&&(this.trigger("done"),this.emittedTracks=0)},(Re=function(e){var t,i,r=this,n=!0;Re.prototype.init.call(this),e=e||{},this.baseMediaDecodeTime=e.baseMediaDecodeTime||0,this.transmuxPipeline_={},this.setupAacPipeline=function(){var t={};this.transmuxPipeline_=t,t.type="aac",t.metadataStream=new _e.MetadataStream,t.aacStream=new Ge,t.audioTimestampRolloverStream=new _e.TimestampRolloverStream("audio"),t.timedMetadataTimestampRolloverStream=new _e.TimestampRolloverStream("timed-metadata"),t.adtsStream=new ke,t.coalesceStream=new Be(e,t.metadataStream),t.headOfPipeline=t.aacStream,t.aacStream.pipe(t.audioTimestampRolloverStream).pipe(t.adtsStream),t.aacStream.pipe(t.timedMetadataTimestampRolloverStream).pipe(t.metadataStream).pipe(t.coalesceStream),t.metadataStream.on("timestamp",function(e){t.aacStream.setTimestamp(e.timeStamp)}),t.aacStream.on("data",function(n){"timed-metadata"!==n.type||t.audioSegmentStream||(i=i||{timelineStartInfo:{baseMediaDecodeTime:r.baseMediaDecodeTime},codec:"adts",type:"audio"},t.coalesceStream.numberOfTracks++,t.audioSegmentStream=new De(i,e),t.adtsStream.pipe(t.audioSegmentStream).pipe(t.coalesceStream))}),t.coalesceStream.on("data",this.trigger.bind(this,"data")),t.coalesceStream.on("done",this.trigger.bind(this,"done"))},this.setupTsPipeline=function(){var n={};this.transmuxPipeline_=n,n.type="ts",n.metadataStream=new _e.MetadataStream,n.packetStream=new _e.TransportPacketStream,n.parseStream=new _e.TransportParseStream,n.elementaryStream=new _e.ElementaryStream,n.videoTimestampRolloverStream=new _e.TimestampRolloverStream("video"),n.audioTimestampRolloverStream=new _e.TimestampRolloverStream("audio"),n.timedMetadataTimestampRolloverStream=new _e.TimestampRolloverStream("timed-metadata"),n.adtsStream=new ke,n.h264Stream=new Ke,n.captionStream=new _e.CaptionStream,n.coalesceStream=new Be(e,n.metadataStream),n.headOfPipeline=n.packetStream,n.packetStream.pipe(n.parseStream).pipe(n.elementaryStream),n.elementaryStream.pipe(n.videoTimestampRolloverStream).pipe(n.h264Stream),n.elementaryStream.pipe(n.audioTimestampRolloverStream).pipe(n.adtsStream),n.elementaryStream.pipe(n.timedMetadataTimestampRolloverStream).pipe(n.metadataStream).pipe(n.coalesceStream),n.h264Stream.pipe(n.captionStream).pipe(n.coalesceStream),n.elementaryStream.on("data",function(a){var s;if("metadata"===a.type){for(s=a.tracks.length;s--;)t||"video"!==a.tracks[s].type?i||"audio"!==a.tracks[s].type||((i=a.tracks[s]).timelineStartInfo.baseMediaDecodeTime=r.baseMediaDecodeTime):(t=a.tracks[s]).timelineStartInfo.baseMediaDecodeTime=r.baseMediaDecodeTime;t&&!n.videoSegmentStream&&(n.coalesceStream.numberOfTracks++,n.videoSegmentStream=new Ue(t,e),n.videoSegmentStream.on("timelineStartInfo",function(e){i&&(i.timelineStartInfo=e,n.audioSegmentStream.setEarliestDts(e.dts))}),n.videoSegmentStream.on("processedGopsInfo",r.trigger.bind(r,"gopInfo")),n.videoSegmentStream.on("baseMediaDecodeTime",function(e){i&&n.audioSegmentStream.setVideoBaseMediaDecodeTime(e)}),n.h264Stream.pipe(n.videoSegmentStream).pipe(n.coalesceStream)),i&&!n.audioSegmentStream&&(n.coalesceStream.numberOfTracks++,n.audioSegmentStream=new De(i,e),n.adtsStream.pipe(n.audioSegmentStream).pipe(n.coalesceStream))}}),n.coalesceStream.on("data",this.trigger.bind(this,"data")),n.coalesceStream.on("done",this.trigger.bind(this,"done"))},this.setBaseMediaDecodeTime=function(e){var r=this.transmuxPipeline_;this.baseMediaDecodeTime=e,i&&(i.timelineStartInfo.dts=void 0,i.timelineStartInfo.pts=void 0,Ne(i),i.timelineStartInfo.baseMediaDecodeTime=e,r.audioTimestampRolloverStream&&r.audioTimestampRolloverStream.discontinuity()),t&&(r.videoSegmentStream&&(r.videoSegmentStream.gopCache_=[],r.videoTimestampRolloverStream.discontinuity()),t.timelineStartInfo.dts=void 0,t.timelineStartInfo.pts=void 0,Ne(t),r.captionStream.reset(),t.timelineStartInfo.baseMediaDecodeTime=e),r.timedMetadataTimestampRolloverStream&&r.timedMetadataTimestampRolloverStream.discontinuity()},this.setAudioAppendStart=function(e){i&&this.transmuxPipeline_.audioSegmentStream.setAudioAppendStart(e)},this.alignGopsWith=function(e){t&&this.transmuxPipeline_.videoSegmentStream&&this.transmuxPipeline_.videoSegmentStream.alignGopsWith(e)},this.push=function(e){if(n){var t=Me(e);t&&"aac"!==this.transmuxPipeline_.type?this.setupAacPipeline():t||"ts"===this.transmuxPipeline_.type||this.setupTsPipeline(),n=!1}this.transmuxPipeline_.headOfPipeline.push(e)},this.flush=function(){n=!0,this.transmuxPipeline_.headOfPipeline.flush()},this.resetCaptions=function(){this.transmuxPipeline_.captionStream&&this.transmuxPipeline_.captionStream.reset()}}).prototype=new X;var Ze={Transmuxer:Re,VideoSegmentStream:Ue,AudioSegmentStream:De,AUDIO_PROPERTIES:Qe,VIDEO_PROPERTIES:Je},et={generator:V,Transmuxer:Ze.Transmuxer,AudioSegmentStream:Ze.AudioSegmentStream,VideoSegmentStream:Ze.VideoSegmentStream},tt=function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")},it=function(){function e(e,t){for(var i=0;i<t.length;i++){var r=t[i];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}return function(t,i,r){return i&&e(t.prototype,i),r&&e(t,r),t}}(),rt=function(){function e(t){tt(this,e),this.options=t||{},this.init()}return it(e,[{key:"init",value:function(){var e;this.transmuxer&&this.transmuxer.dispose(),this.transmuxer=new et.Transmuxer(this.options),(e=this.transmuxer).on("data",function(e){var t=e.initSegment;e.initSegment={data:t.buffer,byteOffset:t.byteOffset,byteLength:t.byteLength};var i=e.data;e.data=i.buffer,j.postMessage({action:"data",segment:e,byteOffset:i.byteOffset,byteLength:i.byteLength},[e.data])}),e.captionStream&&e.captionStream.on("data",function(e){j.postMessage({action:"caption",data:e})}),e.on("done",function(e){j.postMessage({action:"done"})}),e.on("gopInfo",function(e){j.postMessage({action:"gopInfo",gopInfo:e})})}},{key:"push",value:function(e){var t=new Uint8Array(e.data,e.byteOffset,e.byteLength);this.transmuxer.push(t)}},{key:"reset",value:function(){this.init()}},{key:"setTimestampOffset",value:function(e){var t=e.timestampOffset||0;this.transmuxer.setBaseMediaDecodeTime(Math.round(9e4*t))}},{key:"setAudioAppendStart",value:function(e){this.transmuxer.setAudioAppendStart(Math.ceil(9e4*e.appendStart))}},{key:"flush",value:function(e){this.transmuxer.flush()}},{key:"resetCaptions",value:function(){this.transmuxer.resetCaptions()}},{key:"alignGopsWith",value:function(e){this.transmuxer.alignGopsWith(e.gopsToAlignWith.slice())}}]),e}();new function(e){e.onmessage=function(e){"init"===e.data.action&&e.data.options?this.messageHandlers=new rt(e.data.options):(this.messageHandlers||(this.messageHandlers=new rt),e.data&&e.data.action&&"init"!==e.data.action&&this.messageHandlers[e.data.action]&&this.messageHandlers[e.data.action](e.data))}}(i)}()}),qe=function(e){return/mp4a\.\d+.\d+/i.test(e)},Fe=function(e){return/avc1\.[\da-f]+/i.test(e)},He=function(e){return e.map(function(e){return e.replace(/avc1\.(\d+)\.(\d+)/i,function(e,t,i){return"avc1."+("00"+Number(t).toString(16)).slice(-2)+"00"+("00"+Number(i).toString(16)).slice(-2)})})},Ge=function(e){function i(e,r){S(this,i);var n=L(this,(i.__proto__||Object.getPrototypeOf(i)).call(this,t.EventTarget));n.timestampOffset_=0,n.pendingBuffers_=[],n.bufferUpdating_=!1,n.mediaSource_=e,n.codecs_=r,n.audioCodec_=null,n.videoCodec_=null,n.audioDisabled_=!1,n.appendAudioInitSegment_=!0,n.gopBuffer_=[],n.timeMapping_=0,n.safeAppend_=t.browser.IE_VERSION>=11;var a={remux:!1,alignGopsAtEnd:n.safeAppend_};return n.codecs_.forEach(function(e){qe(e)?n.audioCodec_=e:Fe(e)&&(n.videoCodec_=e)}),n.transmuxer_=new Ne,n.transmuxer_.postMessage({action:"init",options:a}),n.transmuxer_.onmessage=function(e){return"data"===e.data.action?n.data_(e):"done"===e.data.action?n.done_(e):"gopInfo"===e.data.action?n.appendGopInfo_(e):void 0},Object.defineProperty(n,"timestampOffset",{get:function(){return this.timestampOffset_},set:function(e){"number"==typeof e&&e>=0&&(this.timestampOffset_=e,this.appendAudioInitSegment_=!0,this.gopBuffer_.length=0,this.timeMapping_=0,this.transmuxer_.postMessage({action:"setTimestampOffset",timestampOffset:e}))}}),Object.defineProperty(n,"appendWindowStart",{get:function(){return(this.videoBuffer_||this.audioBuffer_).appendWindowStart},set:function(e){this.videoBuffer_&&(this.videoBuffer_.appendWindowStart=e),this.audioBuffer_&&(this.audioBuffer_.appendWindowStart=e)}}),Object.defineProperty(n,"updating",{get:function(){return!!(this.bufferUpdating_||!this.audioDisabled_&&this.audioBuffer_&&this.audioBuffer_.updating||this.videoBuffer_&&this.videoBuffer_.updating)}}),Object.defineProperty(n,"buffered",{get:function(){var e=null,i=null,r=0,n=[],a=[];if(!this.videoBuffer_&&!this.audioBuffer_)return t.createTimeRange();if(!this.videoBuffer_)return this.audioBuffer_.buffered;if(!this.audioBuffer_)return this.videoBuffer_.buffered;if(this.audioDisabled_)return this.videoBuffer_.buffered;if(0===this.videoBuffer_.buffered.length&&0===this.audioBuffer_.buffered.length)return t.createTimeRange();for(var s=this.videoBuffer_.buffered,o=this.audioBuffer_.buffered,u=s.length;u--;)n.push({time:s.start(u),type:"start"}),n.push({time:s.end(u),type:"end"});for(u=o.length;u--;)n.push({time:o.start(u),type:"start"}),n.push({time:o.end(u),type:"end"});for(n.sort(function(e,t){return e.time-t.time}),u=0;u<n.length;u++)"start"===n[u].type?2===++r&&(e=n[u].time):"end"===n[u].type&&1===--r&&(i=n[u].time),null!==e&&null!==i&&(a.push([e,i]),e=null,i=null);return t.createTimeRanges(a)}}),n}return E(i,e),k(i,[{key:"data_",value:function(e){var t=e.data.segment;t.data=new Uint8Array(t.data,e.data.byteOffset,e.data.byteLength),t.initSegment=new Uint8Array(t.initSegment.data,t.initSegment.byteOffset,t.initSegment.byteLength),function(e,t,i){var r=t.player_;if(i.captions&&i.captions.length)for(var n in e.inbandTextTracks_||(e.inbandTextTracks_={}),i.captionStreams)if(!e.inbandTextTracks_[n]){r.tech_.trigger({type:"usage",name:"hls-608"});var a=r.textTracks().getTrackById(n);e.inbandTextTracks_[n]=a||r.addRemoteTextTrack({kind:"captions",id:n,label:n},!1).track}i.metadata&&i.metadata.length&&!e.metadataTrack_&&(e.metadataTrack_=r.addRemoteTextTrack({kind:"metadata",label:"Timed Metadata"},!1).track,e.metadataTrack_.inBandMetadataTrackDispatchType=i.metadata.dispatchType)}(this,this.mediaSource_,t),this.pendingBuffers_.push(t)}},{key:"done_",value:function(e){"closed"!==this.mediaSource_.readyState?this.processPendingSegments_():this.pendingBuffers_.length=0}},{key:"createRealSourceBuffers_",value:function(){var e=this,t=["audio","video"];t.forEach(function(i){if(e[i+"Codec_"]&&!e[i+"Buffer_"]){var r=null;if(e.mediaSource_[i+"Buffer_"])(r=e.mediaSource_[i+"Buffer_"]).updating=!1;else{var n=i+'/mp4;codecs="'+e[i+"Codec_"]+'"';r=function(e,t){var i=e.addSourceBuffer(t),r=Object.create(null);r.updating=!1,r.realBuffer_=i;var n=function(e){"function"==typeof i[e]?r[e]=function(){return i[e].apply(i,arguments)}:"undefined"==typeof r[e]&&Object.defineProperty(r,e,{get:function(){return i[e]},set:function(t){return i[e]=t}})};for(var a in i)n(a);return r}(e.mediaSource_.nativeMediaSource_,n),e.mediaSource_[i+"Buffer_"]=r}e[i+"Buffer_"]=r,["update","updatestart","updateend"].forEach(function(n){r.addEventListener(n,function(){if("audio"!==i||!e.audioDisabled_)return"updateend"===n&&(e[i+"Buffer_"].updating=!1),t.every(function(t){return!("audio"!==t||!e.audioDisabled_)||(i===t||!e[t+"Buffer_"]||!e[t+"Buffer_"].updating)})?e.trigger(n):void 0})})}})}},{key:"appendBuffer",value:function(e){if(this.bufferUpdating_=!0,this.audioBuffer_&&this.audioBuffer_.buffered.length){var t=this.audioBuffer_.buffered;this.transmuxer_.postMessage({action:"setAudioAppendStart",appendStart:t.end(t.length-1)})}this.videoBuffer_&&this.transmuxer_.postMessage({action:"alignGopsWith",gopsToAlignWith:function(e,t,i){if(!t||!e.length)return[];var r=Math.ceil(9e4*(t.currentTime()-i+3)),n=void 0;for(n=0;n<e.length&&!(e[n].pts>r);n++);return e.slice(n)}(this.gopBuffer_,this.mediaSource_.player_,this.timeMapping_)}),this.transmuxer_.postMessage({action:"push",data:e.buffer,byteOffset:e.byteOffset,byteLength:e.byteLength},[e.buffer]),this.transmuxer_.postMessage({action:"flush"})}},{key:"appendGopInfo_",value:function(e){this.gopBuffer_=function(e,t,i){if(!t.length)return e;if(i)return t.slice();for(var r=t[0].pts,n=0;n<e.length&&!(e[n].pts>=r);n++);return e.slice(0,n).concat(t)}(this.gopBuffer_,e.data.gopInfo,this.safeAppend_)}},{key:"remove",value:function(e,t){if(this.videoBuffer_&&(this.videoBuffer_.updating=!0,this.videoBuffer_.remove(e,t),this.gopBuffer_=function(e,t,i,r){for(var n=Math.ceil(9e4*(t-r)),a=Math.ceil(9e4*(i-r)),s=e.slice(),o=e.length;o--&&!(e[o].pts<=a););if(-1===o)return s;for(var u=o+1;u--&&!(e[u].pts<=n););return u=Math.max(u,0),s.splice(u,o-u+1),s}(this.gopBuffer_,e,t,this.timeMapping_)),!this.audioDisabled_&&this.audioBuffer_&&(this.audioBuffer_.updating=!0,this.audioBuffer_.remove(e,t)),Ee(e,t,this.metadataTrack_),this.inbandTextTracks_)for(var i in this.inbandTextTracks_)Ee(e,t,this.inbandTextTracks_[i])}},{key:"processPendingSegments_",value:function(){var e={video:{segments:[],bytes:0},audio:{segments:[],bytes:0},captions:[],metadata:[]};e=this.pendingBuffers_.reduce(function(e,t){var i=t.type,r=t.data,n=t.initSegment;return e[i].segments.push(r),e[i].bytes+=r.byteLength,e[i].initSegment=n,t.captions&&(e.captions=e.captions.concat(t.captions)),t.info&&(e[i].info=t.info),t.metadata&&(e.metadata=e.metadata.concat(t.metadata)),e},e),this.videoBuffer_||this.audioBuffer_||(0===e.video.bytes&&(this.videoCodec_=null),0===e.audio.bytes&&(this.audioCodec_=null),this.createRealSourceBuffers_()),e.audio.info&&this.mediaSource_.trigger({type:"audioinfo",info:e.audio.info}),e.video.info&&this.mediaSource_.trigger({type:"videoinfo",info:e.video.info}),this.appendAudioInitSegment_&&(!this.audioDisabled_&&this.audioBuffer_&&(e.audio.segments.unshift(e.audio.initSegment),e.audio.bytes+=e.audio.initSegment.byteLength),this.appendAudioInitSegment_=!1);var t=!1;this.videoBuffer_&&e.video.bytes?(e.video.segments.unshift(e.video.initSegment),e.video.bytes+=e.video.initSegment.byteLength,this.concatAndAppendSegments_(e.video,this.videoBuffer_),Ae(this,e.captions,e.metadata)):!this.videoBuffer_||!this.audioDisabled_&&this.audioBuffer_||(t=!0),!this.audioDisabled_&&this.audioBuffer_&&this.concatAndAppendSegments_(e.audio,this.audioBuffer_),this.pendingBuffers_.length=0,t&&this.trigger("updateend"),this.bufferUpdating_=!1}},{key:"concatAndAppendSegments_",value:function(e,t){var i=0,r=void 0;if(e.bytes){r=new Uint8Array(e.bytes),e.segments.forEach(function(e){r.set(e,i),i+=e.byteLength});try{t.updating=!0,t.appendBuffer(r)}catch(e){this.mediaSource_.player_&&this.mediaSource_.player_.error({code:-3,type:"APPEND_BUFFER_ERR",message:e.message,originalError:e})}}}},{key:"abort",value:function(){this.videoBuffer_&&this.videoBuffer_.abort(),!this.audioDisabled_&&this.audioBuffer_&&this.audioBuffer_.abort(),this.transmuxer_&&this.transmuxer_.postMessage({action:"reset"}),this.pendingBuffers_.length=0,this.bufferUpdating_=!1}}]),i}(t.EventTarget),je=function(e){function i(){S(this,i);var e=L(this,(i.__proto__||Object.getPrototypeOf(i)).call(this)),r=void 0;for(r in e.nativeMediaSource_=new c.MediaSource,e.nativeMediaSource_)r in i.prototype||"function"!=typeof e.nativeMediaSource_[r]||(e[r]=e.nativeMediaSource_[r].bind(e.nativeMediaSource_));return e.duration_=NaN,Object.defineProperty(e,"duration",{get:function(){return this.duration_===1/0?this.duration_:this.nativeMediaSource_.duration},set:function(e){this.duration_=e,e===1/0||(this.nativeMediaSource_.duration=e)}}),Object.defineProperty(e,"seekable",{get:function(){return this.duration_===1/0?t.createTimeRanges([[0,this.nativeMediaSource_.duration]]):this.nativeMediaSource_.seekable}}),Object.defineProperty(e,"readyState",{get:function(){return this.nativeMediaSource_.readyState}}),Object.defineProperty(e,"activeSourceBuffers",{get:function(){return this.activeSourceBuffers_}}),e.sourceBuffers=[],e.activeSourceBuffers_=[],e.updateActiveSourceBuffers_=function(){if(e.activeSourceBuffers_.length=0,1===e.sourceBuffers.length){var t=e.sourceBuffers[0];return t.appendAudioInitSegment_=!0,t.audioDisabled_=!t.audioCodec_,void e.activeSourceBuffers_.push(t)}for(var i=!1,r=!0,n=0;n<e.player_.audioTracks().length;n++){var a=e.player_.audioTracks()[n];if(a.enabled&&"main"!==a.kind){i=!0,r=!1;break}}e.sourceBuffers.forEach(function(t,n){if(t.appendAudioInitSegment_=!0,t.videoCodec_&&t.audioCodec_)t.audioDisabled_=i;else if(t.videoCodec_&&!t.audioCodec_)t.audioDisabled_=!0,r=!1;else if(!t.videoCodec_&&t.audioCodec_&&(t.audioDisabled_=n?r:!r,t.audioDisabled_))return;e.activeSourceBuffers_.push(t)})},e.onPlayerMediachange_=function(){e.sourceBuffers.forEach(function(e){e.appendAudioInitSegment_=!0})},e.onHlsReset_=function(){e.sourceBuffers.forEach(function(e){e.transmuxer_&&e.transmuxer_.postMessage({action:"resetCaptions"})})},e.onHlsSegmentTimeMapping_=function(t){e.sourceBuffers.forEach(function(e){return e.timeMapping_=t.mapping})},["sourceopen","sourceclose","sourceended"].forEach(function(e){this.nativeMediaSource_.addEventListener(e,this.trigger.bind(this))},e),e.on("sourceopen",function(i){var r=d.querySelector('[src="'+e.url_+'"]');r&&(e.player_=t(r.parentNode),e.player_.tech_.on("hls-reset",e.onHlsReset_),e.player_.tech_.on("hls-segment-time-mapping",e.onHlsSegmentTimeMapping_),e.player_.audioTracks&&e.player_.audioTracks()&&(e.player_.audioTracks().on("change",e.updateActiveSourceBuffers_),e.player_.audioTracks().on("addtrack",e.updateActiveSourceBuffers_),e.player_.audioTracks().on("removetrack",e.updateActiveSourceBuffers_)),e.player_.on("mediachange",e.onPlayerMediachange_))}),e.on("sourceended",function(t){for(var i=Le(e.duration),r=0;r<e.sourceBuffers.length;r++){var n=e.sourceBuffers[r],a=n.metadataTrack_&&n.metadataTrack_.cues;a&&a.length&&(a[a.length-1].endTime=i)}}),e.on("sourceclose",function(e){this.sourceBuffers.forEach(function(e){e.transmuxer_&&e.transmuxer_.terminate()}),this.sourceBuffers.length=0,this.player_&&(this.player_.audioTracks&&this.player_.audioTracks()&&(this.player_.audioTracks().off("change",this.updateActiveSourceBuffers_),this.player_.audioTracks().off("addtrack",this.updateActiveSourceBuffers_),this.player_.audioTracks().off("removetrack",this.updateActiveSourceBuffers_)),this.player_.el_&&(this.player_.off("mediachange",this.onPlayerMediachange_),this.player_.tech_.off("hls-reset",this.onHlsReset_),this.player_.tech_.off("hls-segment-time-mapping",this.onHlsSegmentTimeMapping_)))}),e}return E(i,e),k(i,[{key:"addSeekableRange_",value:function(e,t){var i=void 0;if(this.duration!==1/0)throw(i=new Error("MediaSource.addSeekableRange() can only be invoked when the duration is Infinity")).name="InvalidStateError",i.code=11,i;(t>this.nativeMediaSource_.duration||isNaN(this.nativeMediaSource_.duration))&&(this.nativeMediaSource_.duration=t)}},{key:"addSourceBuffer",value:function(e){var t=void 0,i=function(e){var t={type:"",parameters:{}},i=e.trim().split(";");return t.type=i.shift().trim(),i.forEach(function(e){var i=e.trim().split("=");if(i.length>1){var r=i[0].replace(/"/g,"").trim(),n=i[1].replace(/"/g,"").trim();t.parameters[r]=n}}),t}(e);if(/^(video|audio)\/mp2t$/i.test(i.type)){var r=[];i.parameters&&i.parameters.codecs&&(r=i.parameters.codecs.split(","),r=(r=He(r)).filter(function(e){return qe(e)||Fe(e)})),0===r.length&&(r=["avc1.4d400d","mp4a.40.2"]),t=new Ge(this,r),0!==this.sourceBuffers.length&&(this.sourceBuffers[0].createRealSourceBuffers_(),t.createRealSourceBuffers_(),this.sourceBuffers[0].audioDisabled_=!0)}else t=this.nativeMediaSource_.addSourceBuffer(e);return this.sourceBuffers.push(t),t}}]),i}(t.EventTarget),We=0;t.mediaSources={};var Ve=function(e,i){var r=t.mediaSources[e];if(!r)throw new Error("Media Source not found (Video.js)");r.trigger({type:"sourceopen",swfId:i})},ze=function(){return!!c.MediaSource&&!!c.MediaSource.isTypeSupported&&c.MediaSource.isTypeSupported('video/mp4;codecs="avc1.4d400d,mp4a.40.2"')},Xe=function(){if(this.MediaSource={open:Ve,supportsNativeMediaSources:ze},ze())return new je;throw new Error("Cannot use create a virtual MediaSource for this video")};Xe.open=Ve,Xe.supportsNativeMediaSources=ze;var Ye={createObjectURL:function(e){var i=void 0;return e instanceof je?(i=c.URL.createObjectURL(e.nativeMediaSource_),e.url_=i,i):e instanceof je?(i="blob:vjs-media-source/"+We,We++,t.mediaSources[i]=e,i):(i=c.URL.createObjectURL(e),e.url_=i,i)}};t.MediaSource=Xe,t.URL=Ye;
/**
	 * mpd-parser
	 * @version 0.6.1
	 * @copyright 2018 Brightcove, Inc
	 * @license Apache-2.0
	 */
var $e=function(e){var t,i=e.attributes,r=e.segments,n={attributes:(t={NAME:i.id,AUDIO:"audio",SUBTITLES:"subs",RESOLUTION:{width:i.width,height:i.height},CODECS:i.codecs,BANDWIDTH:i.bandwidth},t["PROGRAM-ID"]=1,t),uri:"",endList:"static"===(i.type||"static"),timeline:i.periodIndex,resolvedUri:"",targetDuration:i.duration,segments:r,mediaSequence:r.length?r[0].number:1};return i.contentProtection&&(n.contentProtection=i.contentProtection),n},Ke="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},Qe=function(e){return!!e&&"object"===("undefined"==typeof e?"undefined":Ke(e))},Je=function e(){for(var t=arguments.length,i=Array(t),r=0;r<t;r++)i[r]=arguments[r];return i.reduce(function(t,i){return Object.keys(i).forEach(function(r){Array.isArray(t[r])&&Array.isArray(i[r])?t[r]=t[r].concat(i[r]):Qe(t[r])&&Qe(i[r])?t[r]=e(t[r],i[r]):t[r]=i[r]}),t},{})},Ze=function(e,t){return/^[a-z]+:/i.test(t)?t:(/\/\//i.test(e)||(e=l.buildAbsoluteURL(c.location.href,e)),l.buildAbsoluteURL(e,t))},et=function(e){var t=e.baseUrl,i=void 0===t?"":t,r=e.source,n=void 0===r?"":r,a=e.range,s=void 0===a?"":a,o={uri:n,resolvedUri:Ze(i||"",n)};if(s){var u=s.split("-"),d=parseInt(u[0],10),l=parseInt(u[1],10);o.byterange={length:l-d,offset:d}}return o},tt=function(e,t,i){var r=e.NOW,n=e.clientOffset,a=e.availabilityStartTime,s=e.timescale,o=void 0===s?1:s,u=e.start,d=void 0===u?0:u,l=e.minimumUpdatePeriod,c=(r+n)/1e3+(void 0===l?0:l)-(a+d);return Math.ceil((c*o-t)/i)},it=function(e,t){for(var i=e.type,r=void 0===i?"static":i,n=e.minimumUpdatePeriod,a=void 0===n?0:n,s=e.media,o=void 0===s?"":s,u=e.sourceDuration,d=e.timescale,l=void 0===d?1:d,c=e.startNumber,h=void 0===c?1:c,f=e.periodIndex,p=[],m=-1,g=0;g<t.length;g++){var y=t[g],_=y.d,v=y.r||0,b=y.t||0;m<0&&(m=b),b&&b>m&&(m=b);var T=void 0;if(v<0){var S=g+1;T=S===t.length?"dynamic"===r&&a>0&&o.indexOf("$Number$")>0?tt(e,m,_):(u*l-m)/_:(t[S].t-m)/_}else T=v+1;for(var k=h+p.length+T,E=h+p.length;E<k;)p.push({number:E,duration:_/l,time:m,timeline:f}),m+=_,E++}return p},rt=function(e){return e.reduce(function(e,t){return e.concat(t)},[])},nt=function(e){if(!e.length)return[];for(var t=[],i=0;i<e.length;i++)t.push(e[i]);return t},at={static:function(e){var t=e.duration,i=e.timescale,r=void 0===i?1:i,n=e.sourceDuration;return{start:0,end:Math.ceil(n/(t/r))}},dynamic:function(e){var t=e.NOW,i=e.clientOffset,r=e.availabilityStartTime,n=e.timescale,a=void 0===n?1:n,s=e.duration,o=e.start,u=void 0===o?0:o,d=e.minimumUpdatePeriod,l=void 0===d?0:d,c=e.timeShiftBufferDepth,h=void 0===c?1/0:c,f=(t+i)/1e3,p=r+u,m=f+l-p,g=Math.ceil(m*a/s),y=Math.floor((f-p-h)*a/s),_=Math.floor((f-p)*a/s);return{start:Math.max(0,y),end:Math.min(g,_)}}},st=function(e){var t=e.type,i=void 0===t?"static":t,r=e.duration,n=e.timescale,a=void 0===n?1:n,s=e.sourceDuration,o=at[i](e),u=function(e,t){for(var i=[],r=e;r<t;r++)i.push(r);return i}(o.start,o.end).map(function(e){return function(t,i){var r=e.duration,n=e.timescale,a=void 0===n?1:n,s=e.periodIndex,o=e.startNumber;return{number:(void 0===o?1:o)+t,duration:r/a,timeline:s,time:i*r}}}(e));if("static"===i){var d=u.length-1;u[d].duration=s-r/a*d}return u},ot=/\$([A-z]*)(?:(%0)([0-9]+)d)?\$/g,ut=function(e,t){return e.replace(ot,function(e){return function(t,i,r,n){if("$$"===t)return"$";if("undefined"==typeof e[i])return t;var a=""+e[i];return"RepresentationID"===i?a:(n=r?parseInt(n,10):1,a.length>=n?a:""+new Array(n-a.length+1).join("0")+a)}}(t))},dt=function(e,t){var i={RepresentationID:e.id,Bandwidth:e.bandwidth||0},r=e.initialization,n=void 0===r?{sourceURL:"",range:""}:r,a=et({baseUrl:e.baseUrl,source:ut(n.sourceURL,i),range:n.range});return function(e,t){return e.duration||t?e.duration?st(e):it(e,t):[{number:e.startNumber||1,duration:e.sourceDuration,time:0,timeline:e.periodIndex}]}(e,t).map(function(t){i.Number=t.number,i.Time=t.time;var r=ut(e.media||"",i);return{uri:r,timeline:t.timeline,duration:t.duration,resolvedUri:Ze(e.baseUrl||"",r),map:a,number:t.number}})},lt="INVALID_NUMBER_OF_PERIOD",ct="DASH_EMPTY_MANIFEST",ht="DASH_INVALID_XML",ft="NO_BASE_URL",pt="SEGMENT_TIME_UNSPECIFIED",mt="UNSUPPORTED_UTC_TIMING_SCHEME",gt=function(e,t){var i=e.duration,r=e.segmentUrls,n=void 0===r?[]:r;if(!i&&!t||i&&t)throw new Error(pt);var a=n.map(function(t){return function(e,t){var i=e.baseUrl,r=e.initialization,n=void 0===r?{}:r,a=et({baseUrl:i,source:n.sourceURL,range:n.range}),s=et({baseUrl:i,source:t.media,range:t.mediaRange});return s.map=a,s}(e,t)}),s=void 0;return i&&(s=st(e)),t&&(s=it(e,t)),s.map(function(e,t){if(a[t]){var i=a[t];return i.timeline=e.timeline,i.duration=e.duration,i.number=e.number,i}}).filter(function(e){return e})},yt=function(e){var t=e.baseUrl,i=e.initialization,r=void 0===i?{}:i,n=e.sourceDuration,a=e.timescale,s=void 0===a?1:a,o=e.indexRange,u=void 0===o?"":o,d=e.duration;if(!t)throw new Error(ft);var l=et({baseUrl:t,source:r.sourceURL,range:r.range}),c=et({baseUrl:t,source:t,range:u});if(c.map=l,d){var h=st(e);h.length&&(c.duration=h[0].duration,c.timeline=h[0].timeline)}else n&&(c.duration=n/s,c.timeline=0);return c.number=0,[c]},_t=function(e){var t=e.attributes,i=e.segmentInfo,r=void 0,n=void 0;if(i.template?(n=dt,r=Je(t,i.template)):i.base?(n=yt,r=Je(t,i.base)):i.list&&(n=gt,r=Je(t,i.list)),!n)return{attributes:t};var a=n(r,i.timeline);if(r.duration){var s=r,o=s.duration,u=s.timescale,d=void 0===u?1:u;r.duration=o/d}else a.length?r.duration=a.reduce(function(e,t){return Math.max(e,Math.ceil(t.duration))},0):r.duration=0;return{attributes:r,segments:a}},vt=function(e,t){return nt(e.childNodes).filter(function(e){return e.tagName===t})},bt=function(e){return e.textContent.trim()},Tt=function(e){var t=/P(?:(\d*)Y)?(?:(\d*)M)?(?:(\d*)D)?(?:T(?:(\d*)H)?(?:(\d*)M)?(?:([\d.]*)S)?)?/.exec(e);if(!t)return 0;var i=t.slice(1),r=i[0],n=i[1],a=i[2],s=i[3],o=i[4],u=i[5];return 31536e3*parseFloat(r||0)+2592e3*parseFloat(n||0)+86400*parseFloat(a||0)+3600*parseFloat(s||0)+60*parseFloat(o||0)+parseFloat(u||0)},St={mediaPresentationDuration:function(e){return Tt(e)},availabilityStartTime:function(e){return/^\d+-\d+-\d+T\d+:\d+:\d+(\.\d+)?$/.test(t=e)&&(t+="Z"),Date.parse(t)/1e3;var t},minimumUpdatePeriod:function(e){return Tt(e)},timeShiftBufferDepth:function(e){return Tt(e)},start:function(e){return Tt(e)},width:function(e){return parseInt(e,10)},height:function(e){return parseInt(e,10)},bandwidth:function(e){return parseInt(e,10)},startNumber:function(e){return parseInt(e,10)},timescale:function(e){return parseInt(e,10)},duration:function(e){var t=parseInt(e,10);return isNaN(t)?Tt(e):t},d:function(e){return parseInt(e,10)},t:function(e){return parseInt(e,10)},r:function(e){return parseInt(e,10)},DEFAULT:function(e){return e}},kt=function(e){return e&&e.attributes?nt(e.attributes).reduce(function(e,t){var i=St[t.name]||St.DEFAULT;return e[t.name]=i(t.value),e},{}):{}};var Et={"urn:uuid:1077efec-c0b2-4d02-ace3-3c1e52e2fb4b":"org.w3.clearkey","urn:uuid:edef8ba9-79d6-4ace-a3c8-27dcd51d21ed":"com.widevine.alpha","urn:uuid:9a04f079-9840-4286-ab92-e65be0885f95":"com.microsoft.playready","urn:uuid:f239e769-efa3-4850-9c16-a903c6932efb":"com.adobe.primetime"},Lt=function(e,t){return t.length?rt(e.map(function(e){return t.map(function(t){return Ze(e,bt(t))})})):e},At=function(e){var t=vt(e,"SegmentTemplate")[0],i=vt(e,"SegmentList")[0],r=i&&vt(i,"SegmentURL").map(function(e){return Je({tag:"SegmentURL"},kt(e))}),n=vt(e,"SegmentBase")[0],a=i||t,s=a&&vt(a,"SegmentTimeline")[0],o=i||n||t,u=o&&vt(o,"Initialization")[0],d=t&&kt(t);d&&u?d.initialization=u&&kt(u):d&&d.initialization&&(d.initialization={sourceURL:d.initialization});var l={template:d,timeline:s&&vt(s,"S").map(function(e){return kt(e)}),list:i&&Je(kt(i),{segmentUrls:r,initialization:kt(u)}),base:n&&Je(kt(n),{initialization:kt(u)})};return Object.keys(l).forEach(function(e){l[e]||delete l[e]}),l},wt=function(e){return e.reduce(function(e,t){var i=kt(t),r=Et[i.schemeIdUri];if(r){e[r]={attributes:i};var n=vt(t,"cenc:pssh")[0];if(n){var a=bt(n),s=a&&function(e){for(var t=c.atob(e),i=new Uint8Array(t.length),r=0;r<t.length;r++)i[r]=t.charCodeAt(r);return i}(a);e[r].pssh=s}}return e},{})},It=function(e,t,i){return function(r){var n=kt(r),a=Lt(t,vt(r,"BaseURL")),s=vt(r,"Role")[0],o={role:kt(s)},u=Je(e,n,o),d=wt(vt(r,"ContentProtection"));Object.keys(d).length&&(u=Je(u,{contentProtection:d}));var l=At(r),c=vt(r,"Representation"),h=Je(i,l);return rt(c.map(function(e,t,i){return function(r){var n=vt(r,"BaseURL"),a=Lt(t,n),s=Je(e,kt(r)),o=At(r);return a.map(function(e){return{segmentInfo:Je(i,o),attributes:Je(s,{baseUrl:e})}})}}(u,a,h)))}},Ot=function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},i=t.manifestUri,r=void 0===i?"":i,n=t.NOW,a=void 0===n?Date.now():n,s=t.clientOffset,o=void 0===s?0:s,u=vt(e,"Period");if(1!==u.length)throw new Error(lt);var d=kt(e),l=Lt([r],vt(e,"BaseURL"));return d.sourceDuration=d.mediaPresentationDuration||0,d.NOW=a,d.clientOffset=o,rt(u.map(function(e,t){return function(i,r){var n=Lt(t,vt(i,"BaseURL")),a=kt(i),s=Je(e,a,{periodIndex:r}),o=vt(i,"AdaptationSet"),u=At(i);return rt(o.map(It(s,n,u)))}}(d,l)))},Ct=function(e){if(""===e)throw new Error(ct);var t=(new c.DOMParser).parseFromString(e,"application/xml"),i=t&&"MPD"===t.documentElement.tagName?t.documentElement:null;if(!i||i&&i.getElementsByTagName("parsererror").length>0)throw new Error(ht);return i},Pt=function(e,t){return function(e){var t;if(!e.length)return{};var i=e[0].attributes,r=i.sourceDuration,n=i.minimumUpdatePeriod,a=void 0===n?0:n,s=e.filter(function(e){var t=e.attributes;return"video/mp4"===t.mimeType||"video"===t.contentType}).map($e),o=e.filter(function(e){var t=e.attributes;return"audio/mp4"===t.mimeType||"audio"===t.contentType}),u=e.filter(function(e){var t=e.attributes;return"text/vtt"===t.mimeType||"text"===t.contentType}),d={allowCache:!0,discontinuityStarts:[],segments:[],endList:!0,mediaGroups:(t={AUDIO:{},VIDEO:{}},t["CLOSED-CAPTIONS"]={},t.SUBTITLES={},t),uri:"",duration:r,playlists:s,minimumUpdatePeriod:1e3*a};return o.length&&(d.mediaGroups.AUDIO.audio=o.reduce(function(e,t){var i=t.attributes.role&&t.attributes.role.value||"main",r=t.attributes.lang||"",n="main";return r&&(n=t.attributes.lang+" ("+i+")"),e[n]&&e[n].playlists[0].attributes.BANDWIDTH>t.attributes.bandwidth?e:(e[n]={language:r,autoselect:!0,default:"main"===i,playlists:[function(e){var t,i=e.attributes,r=e.segments,n={attributes:(t={NAME:i.id,BANDWIDTH:i.bandwidth,CODECS:i.codecs},t["PROGRAM-ID"]=1,t),uri:"",endList:"static"===(i.type||"static"),timeline:i.periodIndex,resolvedUri:"",targetDuration:i.duration,segments:r,mediaSequence:r.length?r[0].number:1};return i.contentProtection&&(n.contentProtection=i.contentProtection),n}(t)],uri:""},e)},{})),u.length&&(d.mediaGroups.SUBTITLES.subs=function(e){return e.reduce(function(e,t){var i,r,n,a,s=t.attributes.lang||"text";return e[s]?e:(e[s]={language:s,default:!1,autoselect:!1,playlists:[(i=t,n=i.attributes,a=i.segments,"undefined"==typeof a&&(a=[{uri:n.baseUrl,timeline:n.periodIndex,resolvedUri:n.baseUrl||"",duration:n.sourceDuration,number:0}],n.duration=n.sourceDuration),{attributes:(r={NAME:n.id,BANDWIDTH:n.bandwidth},r["PROGRAM-ID"]=1,r),uri:"",endList:"static"===(n.type||"static"),timeline:n.periodIndex,resolvedUri:n.baseUrl||"",targetDuration:n.duration,segments:a,mediaSequence:a.length?a[0].number:1})],uri:""},e)},{})}(u)),d}(Ot(Ct(e),t).map(_t))},Ut=function(e){return function(e){var t=vt(e,"UTCTiming")[0];if(!t)return null;var i=kt(t);switch(i.schemeIdUri){case"urn:mpeg:dash:utc:http-head:2014":case"urn:mpeg:dash:utc:http-head:2012":i.method="HEAD";break;case"urn:mpeg:dash:utc:http-xsdate:2014":case"urn:mpeg:dash:utc:http-iso:2014":case"urn:mpeg:dash:utc:http-xsdate:2012":case"urn:mpeg:dash:utc:http-iso:2012":i.method="GET";break;case"urn:mpeg:dash:utc:direct:2014":case"urn:mpeg:dash:utc:direct:2012":i.method="DIRECT",i.value=Date.parse(i.value);break;case"urn:mpeg:dash:utc:http-ntp:2014":case"urn:mpeg:dash:utc:ntp:2014":case"urn:mpeg:dash:utc:sntp:2014":default:throw new Error(mt)}return i}(Ct(e))},Dt=t.EventTarget,Rt=t.mergeOptions,Bt=function(e,t){for(var i=Rt(e,{duration:t.duration,minimumUpdatePeriod:t.minimumUpdatePeriod}),r=0;r<t.playlists.length;r++){var n=P(i,t.playlists[r]);n&&(i=n)}return C(t,function(e,t,r,n){if(e.playlists&&e.playlists.length){var a=e.playlists[0].uri,s=P(i,e.playlists[0]);s&&((i=s).mediaGroups[t][r][n].playlists[0]=i.playlists[a])}}),i},Mt=function(e){function t(e,i,r,n){S(this,t);var a=L(this,(t.__proto__||Object.getPrototypeOf(t)).call(this));if(a.hls_=i,a.withCredentials=r,!e)throw new Error("A non-empty playlist URL or playlist is required");return a.on("minimumUpdatePeriod",function(){a.refreshXml_()}),a.on("mediaupdatetimeout",function(){a.refreshMedia_()}),"string"==typeof e?(a.srcUrl=e,a.state="HAVE_NOTHING",L(a)):(a.masterPlaylistLoader_=n,a.state="HAVE_METADATA",a.started=!0,a.media(e),c.setTimeout(function(){a.trigger("loadedmetadata")},0),a)}return E(t,Dt),k(t,[{key:"dispose",value:function(){this.stopRequest(),c.clearTimeout(this.mediaUpdateTimeout)}},{key:"stopRequest",value:function(){if(this.request){var e=this.request;this.request=null,e.onreadystatechange=null,e.abort()}}},{key:"media",value:function(e){if(!e)return this.media_;if("HAVE_NOTHING"===this.state)throw new Error("Cannot switch media playlist from "+this.state);var t=this.state;if("string"==typeof e){if(!this.master.playlists[e])throw new Error("Unknown playlist URI: "+e);e=this.master.playlists[e]}var i=!this.media_||e.uri!==this.media_.uri;this.state="HAVE_METADATA",i&&(this.media_&&this.trigger("mediachanging"),this.media_=e,this.refreshMedia_(),"HAVE_MASTER"!==t&&this.trigger("mediachange"))}},{key:"pause",value:function(){this.stopRequest(),"HAVE_NOTHING"===this.state&&(this.started=!1)}},{key:"load",value:function(){this.started?this.trigger("loadedplaylist"):this.start()}},{key:"parseMasterXml",value:function(){var e=Pt(this.masterXml_,{manifestUri:this.srcUrl,clientOffset:this.clientOffset_});e.uri=this.srcUrl;for(var t=0;t<e.playlists.length;t++){var i="placeholder-uri-"+t;e.playlists[t].uri=i,e.playlists[i]=e.playlists[t]}return C(e,function(t,i,r,n){if(t.playlists&&t.playlists.length){var a="placeholder-uri-"+i+"-"+r+"-"+n;t.playlists[0].uri=a,e.playlists[a]=t.playlists[0]}}),U(e),D(e),e}},{key:"start",value:function(){var e=this;this.started=!0,this.request=this.hls_.xhr({uri:this.srcUrl,withCredentials:this.withCredentials},function(t,i){if(e.request){if(e.request=null,t)return e.error={status:i.status,message:"DASH playlist request error at URL: "+e.srcUrl,responseText:i.responseText,code:2},"HAVE_NOTHING"===e.state&&(e.started=!1),e.trigger("error");e.masterXml_=i.responseText,i.responseHeaders&&i.responseHeaders.date?e.masterLoaded_=Date.parse(i.responseHeaders.date):e.masterLoaded_=Date.now(),e.syncClientServerClock_(e.onClientServerClockSync_.bind(e))}})}},{key:"syncClientServerClock_",value:function(e){var t=this,i=Ut(this.masterXml_);return null===i?(this.clientOffset_=this.masterLoaded_-Date.now(),e()):"DIRECT"===i.method?(this.clientOffset_=i.value-Date.now(),e()):void(this.request=this.hls_.xhr({uri:h(this.srcUrl,i.value),method:i.method,withCredentials:this.withCredentials},function(r,n){if(t.request){if(r)return t.clientOffset_=t.masterLoaded_-Date.now(),e();var a=void 0;a="HEAD"===i.method?n.responseHeaders&&n.responseHeaders.date?Date.parse(n.responseHeaders.date):t.masterLoaded_:Date.parse(n.responseText),t.clientOffset_=a-Date.now(),e()}}))}},{key:"onClientServerClockSync_",value:function(){var e=this;this.master=this.parseMasterXml(),this.state="HAVE_MASTER",this.trigger("loadedplaylist"),this.media_||this.media(this.master.playlists[0]),c.setTimeout(function(){e.trigger("loadedmetadata")},0),this.master.minimumUpdatePeriod&&c.setTimeout(function(){e.trigger("minimumUpdatePeriod")},this.master.minimumUpdatePeriod)}},{key:"refreshXml_",value:function(){var e=this;this.request=this.hls_.xhr({uri:this.srcUrl,withCredentials:this.withCredentials},function(t,i){if(e.request){if(e.request=null,t)return e.error={status:i.status,message:"DASH playlist request error at URL: "+e.srcUrl,responseText:i.responseText,code:2},"HAVE_NOTHING"===e.state&&(e.started=!1),e.trigger("error");e.masterXml_=i.responseText;var r=e.parseMasterXml();e.master=Bt(e.master,r),c.setTimeout(function(){e.trigger("minimumUpdatePeriod")},e.master.minimumUpdatePeriod)}})}},{key:"refreshMedia_",value:function(){var e=this,t=void 0,i=void 0;this.masterPlaylistLoader_?(t=this.masterPlaylistLoader_.master,i=this.masterPlaylistLoader_.parseMasterXml()):(t=this.master,i=this.parseMasterXml());var r=Bt(t,i);r?(this.masterPlaylistLoader_?this.masterPlaylistLoader_.master=r:this.master=r,this.media_=r.playlists[this.media_.uri]):this.trigger("playlistunchanged"),this.media().endList||(this.mediaUpdateTimeout=c.setTimeout(function(){e.trigger("mediaupdatetimeout")},R(this.media(),!!r))),this.trigger("loadedplaylist")}}]),t}(),xt=function(e){return t.log.debug?t.log.debug.bind(t,"VHS:",e+" >"):function(){}};function Nt(){}var qt,Ft,Ht=function(){function e(t,i,r,n){S(this,e),this.callbacks_=[],this.pendingCallback_=null,this.timestampOffset_=0,this.mediaSource=t,this.processedAppend_=!1,this.type_=r,this.mimeType_=i,this.logger_=xt("SourceUpdater["+r+"]["+i+"]"),"closed"===t.readyState?t.addEventListener("sourceopen",this.createSourceBuffer_.bind(this,i,n)):this.createSourceBuffer_(i,n)}return k(e,[{key:"createSourceBuffer_",value:function(e,t){var i=this;this.sourceBuffer_=this.mediaSource.addSourceBuffer(e),this.logger_("created SourceBuffer"),t&&(t.trigger("sourcebufferadded"),this.mediaSource.sourceBuffers.length<2)?t.on("sourcebufferadded",function(){i.start_()}):this.start_()}},{key:"start_",value:function(){var e=this;this.started_=!0,this.onUpdateendCallback_=function(){var t=e.pendingCallback_;e.pendingCallback_=null,e.logger_("buffered ["+Se(e.buffered())+"]"),t&&t(),e.runCallback_()},this.sourceBuffer_.addEventListener("updateend",this.onUpdateendCallback_),this.runCallback_()}},{key:"abort",value:function(e){var t=this;this.processedAppend_&&this.queueCallback_(function(){t.sourceBuffer_.abort()},e)}},{key:"appendBuffer",value:function(e,t){var i=this;this.processedAppend_=!0,this.queueCallback_(function(){i.sourceBuffer_.appendBuffer(e)},t)}},{key:"buffered",value:function(){return this.sourceBuffer_?this.sourceBuffer_.buffered:t.createTimeRanges()}},{key:"remove",value:function(e,t){var i=this;this.processedAppend_&&this.queueCallback_(function(){i.logger_("remove ["+e+" => "+t+"]"),i.sourceBuffer_.remove(e,t)},Nt)}},{key:"updating",value:function(){return!this.sourceBuffer_||this.sourceBuffer_.updating||this.pendingCallback_}},{key:"timestampOffset",value:function(e){var t=this;return"undefined"!=typeof e&&(this.queueCallback_(function(){t.sourceBuffer_.timestampOffset=e}),this.timestampOffset_=e),this.timestampOffset_}},{key:"queueCallback_",value:function(e,t){this.callbacks_.push([e.bind(this),t]),this.runCallback_()}},{key:"runCallback_",value:function(){var e=void 0;!this.updating()&&this.callbacks_.length&&this.started_&&(e=this.callbacks_.shift(),this.pendingCallback_=e[1],e[0]())}},{key:"dispose",value:function(){this.sourceBuffer_.removeEventListener("updateend",this.onUpdateendCallback_),this.sourceBuffer_&&"open"===this.mediaSource.readyState&&this.sourceBuffer_.abort()}}]),e}(),Gt={GOAL_BUFFER_LENGTH:30,MAX_GOAL_BUFFER_LENGTH:60,GOAL_BUFFER_LENGTH_RATE:1,BANDWIDTH_VARIANCE:1.2,BUFFER_LOW_WATER_LINE:0,MAX_BUFFER_LOW_WATER_LINE:30,BUFFER_LOW_WATER_LINE_RATE:1},jt=2,Wt=-101,Vt=-102,zt=function(e){var t,i,r={};return e.byterange&&(r.Range=(t=e.byterange,i=t.offset+t.length-1,"bytes="+t.offset+"-"+i)),r},Xt=function(e){e.forEach(function(e){e.abort()})},Yt=function(e,t){return t.timedout?{status:t.status,message:"HLS request timed-out at URL: "+t.uri,code:Wt,xhr:t}:t.aborted?{status:t.status,message:"HLS request aborted at URL: "+t.uri,code:Vt,xhr:t}:e?{status:t.status,message:"HLS request errored at URL: "+t.uri,code:jt,xhr:t}:null},$t=function(e,t,i){var r=[],n=0;return function(a,s){if(a&&(Xt(e),r.push(a)),(n+=1)===e.length){if(s.endOfAllRequests=Date.now(),r.length>0){var o=function(e){return e.reduce(function(e,t){return t.code>e.code?t:e})}(r);return i(o,s)}return s.encryptedBytes?function(e,t,i){e.addEventListener("message",function r(n){if(n.data.source===t.requestId){e.removeEventListener("message",r);var a=n.data.decrypted;return t.bytes=new Uint8Array(a.bytes,a.byteOffset,a.byteLength),i(null,t)}}),e.postMessage(me({source:t.requestId,encrypted:t.encryptedBytes,key:t.key.bytes,iv:t.key.iv}),[t.encryptedBytes.buffer,t.key.bytes.buffer])}(t,s,i):i(null,s)}}},Kt=function(e,i){return function(r){var n,a,s;return e.stats=t.mergeOptions(e.stats,(a=(n=r).target,(s={bandwidth:1/0,bytesReceived:0,roundTripTime:Date.now()-a.requestTime||0}).bytesReceived=n.loaded,s.bandwidth=Math.floor(s.bytesReceived/s.roundTripTime*8*1e3),s)),!e.stats.firstBytesReceivedAt&&e.stats.bytesReceived&&(e.stats.firstBytesReceivedAt=Date.now()),i(r,e)}},Qt=function(e,i,r,n,a,s){var o=[],u=$t(o,r,s);if(n.key){var d=e(t.mergeOptions(i,{uri:n.key.resolvedUri,responseType:"arraybuffer"}),function(e,t){return function(i,r){var n=r.response,a=Yt(i,r);if(a)return t(a,e);if(16!==n.byteLength)return t({status:r.status,message:"Invalid HLS key at URL: "+r.uri,code:jt,xhr:r},e);var s=new DataView(n);return e.key.bytes=new Uint32Array([s.getUint32(0),s.getUint32(4),s.getUint32(8),s.getUint32(12)]),t(null,e)}}(n,u));o.push(d)}if(n.map&&!n.map.bytes){var l=e(t.mergeOptions(i,{uri:n.map.resolvedUri,responseType:"arraybuffer",headers:zt(n.map)}),function(e,t){return function(i,r){var n=r.response,a=Yt(i,r);return a?t(a,e):0===n.byteLength?t({status:r.status,message:"Empty HLS segment content at URL: "+r.uri,code:jt,xhr:r},e):(e.map.bytes=new Uint8Array(r.response),t(null,e))}}(n,u));o.push(l)}var c=e(t.mergeOptions(i,{uri:n.resolvedUri,responseType:"arraybuffer",headers:zt(n)}),function(e,t){return function(i,r){var n=r.response,a=Yt(i,r);return a?t(a,e):0===n.byteLength?t({status:r.status,message:"Empty HLS segment content at URL: "+r.uri,code:jt,xhr:r},e):(e.stats=function(e){return{bandwidth:e.bandwidth,bytesReceived:e.bytesReceived||0,roundTripTime:e.roundTripTime||0}}(r),e.key?e.encryptedBytes=new Uint8Array(r.response):e.bytes=new Uint8Array(r.response),t(null,e))}}(n,u));return c.addEventListener("progress",Kt(n,a)),o.push(c),function(){return Xt(o)}},Jt={videoCodec:"avc1",videoObjectTypeIndicator:".4d400d",audioProfile:"2"},Zt=function(){var e,t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"",i={codecCount:0};return i.codecCount=t.split(",").length,i.codecCount=i.codecCount||2,(e=/(^|\s|,)+(avc[13])([^ ,]*)/i.exec(t))&&(i.videoCodec=e[2],i.videoObjectTypeIndicator=e[3]),i.audioProfile=/(^|\s|,)+mp4a.[0-9A-Fa-f]+\.([0-9A-Fa-f]+)/i.exec(t),i.audioProfile=i.audioProfile&&i.audioProfile[2],i},ei=function(e,t,i){return e+"/"+t+'; codecs="'+i.filter(function(e){return!!e}).join(", ")+'"'},ti=function(e,i){var r=function(e){return e.segments&&e.segments.length&&e.segments[0].map?"mp4":"mp2t"}(i),n=function(e){var t=e.attributes||{};return t.CODECS?Zt(t.CODECS):Jt}(i),a=i.attributes||{},s=!0,o=!1;if(!i)return[];if(e.mediaGroups.AUDIO&&a.AUDIO){var u=e.mediaGroups.AUDIO[a.AUDIO];if(u)for(var d in o=!0,s=!1,u)if(!u[d].uri&&!u[d].playlists){s=!0;break}}o&&!n.audioProfile&&(s||(n.audioProfile=function(e,t){if(!e.mediaGroups.AUDIO||!t)return null;var i=e.mediaGroups.AUDIO[t];if(!i)return null;for(var r in i){var n=i[r];if(n.default&&n.playlists)return Zt(n.playlists[0].attributes.CODECS).audioProfile}return null}(e,a.AUDIO)),n.audioProfile||(t.log.warn("Multiple audio tracks present but no audio codec string is specified. Attempting to use the default audio codec (mp4a.40.2)"),n.audioProfile=Jt.audioProfile));var l={};n.videoCodec&&(l.video=""+n.videoCodec+n.videoObjectTypeIndicator),n.audioProfile&&(l.audio="mp4a.40."+n.audioProfile);var c=ei("audio",r,[l.audio]),h=ei("video",r,[l.video]),f=ei("video",r,[l.video,l.audio]);return o?!s&&l.video?[h,c]:s||l.video?[f,c]:[c,c]:l.video?[f]:[c]},ii=function(e,t){var i;return e&&(i=c.getComputedStyle(e))?i[t]:""},ri=function(e,t){var i=e.slice();e.sort(function(e,r){var n=t(e,r);return 0===n?i.indexOf(e)-i.indexOf(r):n})},ni=function(e,t){var i=void 0,r=void 0;return e.attributes.BANDWIDTH&&(i=e.attributes.BANDWIDTH),i=i||c.Number.MAX_VALUE,t.attributes.BANDWIDTH&&(r=t.attributes.BANDWIDTH),i-(r=r||c.Number.MAX_VALUE)},ai=function(e,t,i){if(!e||!t)return!1;var r=i===e.segments.length;return e.endList&&"open"===t.readyState&&r},si=function(e){return"number"==typeof e&&isFinite(e)},oi=function(e){function i(e){S(this,i);var t=L(this,(i.__proto__||Object.getPrototypeOf(i)).call(this));if(!e)throw new TypeError("Initialization settings are required");if("function"!=typeof e.currentTime)throw new TypeError("No currentTime getter specified");if(!e.mediaSource)throw new TypeError("No MediaSource specified");return t.bandwidth=e.bandwidth,t.throughput={rate:0,count:0},t.roundTrip=NaN,t.resetStats_(),t.mediaIndex=null,t.hasPlayed_=e.hasPlayed,t.currentTime_=e.currentTime,t.seekable_=e.seekable,t.seeking_=e.seeking,t.duration_=e.duration,t.mediaSource_=e.mediaSource,t.hls_=e.hls,t.loaderType_=e.loaderType,t.startingMedia_=void 0,t.segmentMetadataTrack_=e.segmentMetadataTrack,t.goalBufferLength_=e.goalBufferLength,t.sourceType_=e.sourceType,t.state_="INIT",t.checkBufferTimeout_=null,t.error_=void 0,t.currentTimeline_=-1,t.pendingSegment_=null,t.mimeType_=null,t.sourceUpdater_=null,t.xhrOptions_=null,t.activeInitSegmentId_=null,t.initSegments_={},t.decrypter_=e.decrypter,t.syncController_=e.syncController,t.syncPoint_={segmentIndex:0,time:0},t.syncController_.on("syncinfoupdate",function(){return t.trigger("syncinfoupdate")}),t.mediaSource_.addEventListener("sourceopen",function(){return t.ended_=!1}),t.fetchAtBuffer_=!1,t.logger_=xt("SegmentLoader["+t.loaderType_+"]"),Object.defineProperty(t,"state",{get:function(){return this.state_},set:function(e){e!==this.state_&&(this.logger_(this.state_+" -> "+e),this.state_=e)}}),t}return E(i,e),k(i,[{key:"resetStats_",value:function(){this.mediaBytesTransferred=0,this.mediaRequests=0,this.mediaRequestsAborted=0,this.mediaRequestsTimedout=0,this.mediaRequestsErrored=0,this.mediaTransferDuration=0,this.mediaSecondsLoaded=0}},{key:"dispose",value:function(){this.state="DISPOSED",this.pause(),this.abort_(),this.sourceUpdater_&&this.sourceUpdater_.dispose(),this.resetStats_()}},{key:"abort",value:function(){"WAITING"===this.state?(this.abort_(),this.state="READY",this.paused()||this.monitorBuffer_()):this.pendingSegment_&&(this.pendingSegment_=null)}},{key:"abort_",value:function(){this.pendingSegment_&&this.pendingSegment_.abortRequests(),this.pendingSegment_=null}},{key:"error",value:function(e){return"undefined"!=typeof e&&(this.error_=e),this.pendingSegment_=null,this.error_}},{key:"endOfStream",value:function(){this.ended_=!0,this.pause(),this.trigger("ended")}},{key:"buffered_",value:function(){return this.sourceUpdater_?this.sourceUpdater_.buffered():t.createTimeRanges()}},{key:"initSegment",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]&&arguments[1];if(!e)return null;var i=ge(e),r=this.initSegments_[i];return t&&!r&&e.bytes&&(this.initSegments_[i]=r={resolvedUri:e.resolvedUri,byterange:e.byterange,bytes:e.bytes}),r||e}},{key:"couldBeginLoading_",value:function(){return this.playlist_&&(this.sourceUpdater_||this.mimeType_&&"INIT"===this.state)&&!this.paused()}},{key:"load",value:function(){if(this.monitorBuffer_(),this.playlist_){if(this.syncController_.setDateTimeMapping(this.playlist_),"INIT"===this.state&&this.couldBeginLoading_())return this.init_();!this.couldBeginLoading_()||"READY"!==this.state&&"INIT"!==this.state||(this.state="READY")}}},{key:"init_",value:function(){return this.state="READY",this.sourceUpdater_=new Ht(this.mediaSource_,this.mimeType_,this.loaderType_,this.sourceBufferEmitter_),this.resetEverything(),this.monitorBuffer_()}},{key:"playlist",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(e){var i=this.playlist_,r=this.pendingSegment_;this.playlist_=e,this.xhrOptions_=t,this.hasPlayed_()||(e.syncInfo={mediaSequence:e.mediaSequence,time:0});var n=i?i.id:null;if(this.logger_("playlist update ["+n+" => "+e.id+"]"),this.trigger("syncinfoupdate"),"INIT"===this.state&&this.couldBeginLoading_())return this.init_();if(i&&i.uri===e.uri){var a=e.mediaSequence-i.mediaSequence;this.logger_("live window shift ["+a+"]"),null!==this.mediaIndex&&(this.mediaIndex-=a),r&&(r.mediaIndex-=a,r.mediaIndex>=0&&(r.segment=e.segments[r.mediaIndex])),this.syncController_.saveExpiredSegmentInfo(i,e)}else null!==this.mediaIndex&&this.resyncLoader()}}},{key:"pause",value:function(){this.checkBufferTimeout_&&(c.clearTimeout(this.checkBufferTimeout_),this.checkBufferTimeout_=null)}},{key:"paused",value:function(){return null===this.checkBufferTimeout_}},{key:"mimeType",value:function(e,t){this.mimeType_||(this.mimeType_=e,this.sourceBufferEmitter_=t,"INIT"===this.state&&this.couldBeginLoading_()&&this.init_())}},{key:"resetEverything",value:function(){this.ended_=!1,this.resetLoader(),this.remove(0,this.duration_()),this.trigger("reseteverything")}},{key:"resetLoader",value:function(){this.fetchAtBuffer_=!1,this.resyncLoader()}},{key:"resyncLoader",value:function(){this.mediaIndex=null,this.syncPoint_=null,this.abort()}},{key:"remove",value:function(e,t){this.sourceUpdater_&&this.sourceUpdater_.remove(e,t),Ee(e,t,this.segmentMetadataTrack_)}},{key:"monitorBuffer_",value:function(){this.checkBufferTimeout_&&c.clearTimeout(this.checkBufferTimeout_),this.checkBufferTimeout_=c.setTimeout(this.monitorBufferTick_.bind(this),1)}},{key:"monitorBufferTick_",value:function(){"READY"===this.state&&this.fillBuffer_(),this.checkBufferTimeout_&&c.clearTimeout(this.checkBufferTimeout_),this.checkBufferTimeout_=c.setTimeout(this.monitorBufferTick_.bind(this),500)}},{key:"fillBuffer_",value:function(){if(!this.sourceUpdater_.updating()){this.syncPoint_||(this.syncPoint_=this.syncController_.getSyncPoint(this.playlist_,this.duration_(),this.currentTimeline_,this.currentTime_()));var e=this.checkBuffer_(this.buffered_(),this.playlist_,this.mediaIndex,this.hasPlayed_(),this.currentTime_(),this.syncPoint_);if(e)ai(this.playlist_,this.mediaSource_,e.mediaIndex)?this.endOfStream():(e.mediaIndex!==this.playlist_.segments.length-1||"ended"!==this.mediaSource_.readyState||this.seeking_())&&((e.timeline!==this.currentTimeline_||null!==e.startOfSegment&&e.startOfSegment<this.sourceUpdater_.timestampOffset())&&(this.syncController_.reset(),e.timestampOffset=e.startOfSegment),this.loadSegment_(e))}}},{key:"checkBuffer_",value:function(e,t,i,r,n,a){var s=0,o=void 0;e.length&&(s=e.end(e.length-1));var u=Math.max(0,s-n);if(!t.segments.length)return null;if(u>=this.goalBufferLength_())return null;if(!r&&u>=1)return null;if(null===a)return i=this.getSyncSegmentCandidate_(t),this.generateSegmentInfo_(t,i,null,!0);if(null!==i){var d=t.segments[i];return o=d&&d.end?d.end:s,this.generateSegmentInfo_(t,i+1,o,!1)}if(this.fetchAtBuffer_){var l=Q.getMediaInfoForTime(t,s,a.segmentIndex,a.time);i=l.mediaIndex,o=l.startTime}else{var c=Q.getMediaInfoForTime(t,n,a.segmentIndex,a.time);i=c.mediaIndex,o=c.startTime}return this.generateSegmentInfo_(t,i,o,!1)}},{key:"getSyncSegmentCandidate_",value:function(e){var t=this;if(-1===this.currentTimeline_)return 0;var i=e.segments.map(function(e,t){return{timeline:e.timeline,segmentIndex:t}}).filter(function(e){return e.timeline===t.currentTimeline_});return i.length?i[Math.min(i.length-1,1)].segmentIndex:Math.max(e.segments.length-1,0)}},{key:"generateSegmentInfo_",value:function(e,t,i,r){if(t<0||t>=e.segments.length)return null;var n=e.segments[t];return{requestId:"segment-loader-"+Math.random(),uri:n.resolvedUri,mediaIndex:t,isSyncRequest:r,startOfSegment:i,playlist:e,bytes:null,encryptedBytes:null,timestampOffset:null,timeline:n.timeline,duration:n.duration,segment:n}}},{key:"abortRequestEarly_",value:function(e){if(this.hls_.tech_.paused()||!this.xhrOptions_.timeout||!this.playlist_.attributes.BANDWIDTH)return!1;if(Date.now()-(e.firstBytesReceivedAt||Date.now())<1e3)return!1;var t=this.currentTime_(),i=e.bandwidth,r=this.pendingSegment_.duration,n=Q.estimateSegmentRequestTime(r,i,this.playlist_,e.bytesReceived),a=function(e,t){var i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:1;return((e.length?e.end(e.length-1):0)-t)/i}(this.buffered_(),t,this.hls_.tech_.playbackRate())-1;if(n<=a)return!1;var s=function(e){var t=e.master,i=e.currentTime,r=e.bandwidth,n=e.duration,a=e.segmentDuration,s=e.timeUntilRebuffer,o=e.currentTimeline,u=e.syncController,d=t.playlists.filter(function(e){return!Q.isIncompatible(e)}),l=d.filter(Q.isEnabled);l.length||(l=d.filter(function(e){return!Q.isDisabled(e)}));var c=l.filter(Q.hasAttribute.bind(null,"BANDWIDTH")).map(function(e){var t=u.getSyncPoint(e,n,o,i)?1:2;return{playlist:e,rebufferingImpact:Q.estimateSegmentRequestTime(a,r,e)*t-s}}),h=c.filter(function(e){return e.rebufferingImpact<=0});return ri(h,function(e,t){return ni(t.playlist,e.playlist)}),h.length?h[0]:(ri(c,function(e,t){return e.rebufferingImpact-t.rebufferingImpact}),c[0]||null)}({master:this.hls_.playlists.master,currentTime:t,bandwidth:i,duration:this.duration_(),segmentDuration:r,timeUntilRebuffer:a,currentTimeline:this.currentTimeline_,syncController:this.syncController_});if(s){var o=n-a-s.rebufferingImpact,u=.5;return a<=1/30&&(u=1),!s.playlist||s.playlist.uri===this.playlist_.uri||o<u?!1:(this.bandwidth=s.playlist.attributes.BANDWIDTH*Gt.BANDWIDTH_VARIANCE+1,this.abort(),this.trigger("earlyabort"),!0)}}},{key:"handleProgress_",value:function(e,t){this.pendingSegment_&&t.requestId===this.pendingSegment_.requestId&&!this.abortRequestEarly_(t.stats)&&this.trigger("progress")}},{key:"loadSegment_",value:function(e){this.state="WAITING",this.pendingSegment_=e,this.trimBackBuffer_(e),e.abortRequests=Qt(this.hls_.xhr,this.xhrOptions_,this.decrypter_,this.createSimplifiedSegmentObj_(e),this.handleProgress_.bind(this),this.segmentRequestFinished_.bind(this))}},{key:"trimBackBuffer_",value:function(e){var t=function(e,t,i){var r=void 0;return r=e.length&&e.start(0)>0&&e.start(0)<t?e.start(0):t-30,Math.min(r,t-i)}(this.seekable_(),this.currentTime_(),this.playlist_.targetDuration||10);t>0&&this.remove(0,t)}},{key:"createSimplifiedSegmentObj_",value:function(e){var t=e.segment,i={resolvedUri:t.resolvedUri,byterange:t.byterange,requestId:e.requestId};if(t.key){var r=t.key.iv||new Uint32Array([0,0,0,e.mediaIndex+e.playlist.mediaSequence]);i.key={resolvedUri:t.key.resolvedUri,iv:r}}return t.map&&(i.map=this.initSegment(t.map)),i}},{key:"segmentRequestFinished_",value:function(e,t){if(this.mediaRequests+=1,t.stats&&(this.mediaBytesTransferred+=t.stats.bytesReceived,this.mediaTransferDuration+=t.stats.roundTripTime),this.pendingSegment_){if(t.requestId===this.pendingSegment_.requestId){if(e)return this.pendingSegment_=null,this.state="READY",e.code===Vt?void(this.mediaRequestsAborted+=1):(this.pause(),e.code===Wt?(this.mediaRequestsTimedout+=1,this.bandwidth=1,this.roundTrip=NaN,void this.trigger("bandwidthupdate")):(this.mediaRequestsErrored+=1,this.error(e),void this.trigger("error")));this.bandwidth=t.stats.bandwidth,this.roundTrip=t.stats.roundTripTime,t.map&&(t.map=this.initSegment(t.map,!0)),this.processSegmentResponse_(t)}}else this.mediaRequestsAborted+=1}},{key:"processSegmentResponse_",value:function(e){var t=this.pendingSegment_;t.bytes=e.bytes,e.map&&(t.segment.map.bytes=e.map.bytes),t.endOfAllRequests=e.endOfAllRequests,this.handleSegment_()}},{key:"handleSegment_",value:function(){var e=this;if(this.pendingSegment_){var t=this.pendingSegment_,i=t.segment,r=this.syncController_.probeSegmentInfo(t);"undefined"==typeof this.startingMedia_&&r&&(r.containsAudio||r.containsVideo)&&(this.startingMedia_={containsAudio:r.containsAudio,containsVideo:r.containsVideo});var n,a,s,o=(n=this.loaderType_,a=this.startingMedia_,s=r,"main"===n&&a&&s?s.containsAudio||s.containsVideo?a.containsVideo&&!s.containsVideo?"Only audio found in segment when we expected video. We can't switch to audio only from a stream that had video. To get rid of this message, please add codec information to the manifest.":!a.containsVideo&&s.containsVideo?"Video found in segment when we expected only audio. We can't switch to a stream with video from an audio only stream. To get rid of this message, please add codec information to the manifest.":null:"Neither audio nor video found in segment.":null);if(o)return this.error({message:o,blacklistDuration:1/0}),void this.trigger("error");if(t.isSyncRequest)return this.trigger("syncinfoupdate"),this.pendingSegment_=null,void(this.state="READY");null!==t.timestampOffset&&t.timestampOffset!==this.sourceUpdater_.timestampOffset()&&(this.sourceUpdater_.timestampOffset(t.timestampOffset),this.trigger("timestampoffset"));var u=this.syncController_.mappingForTimeline(t.timeline);if(null!==u&&this.trigger({type:"segmenttimemapping",mapping:u}),this.state="APPENDING",i.map){var d=ge(i.map);if(!this.activeInitSegmentId_||this.activeInitSegmentId_!==d){var l=this.initSegment(i.map);this.sourceUpdater_.appendBuffer(l.bytes,function(){e.activeInitSegmentId_=d})}}t.byteLength=t.bytes.byteLength,"number"==typeof i.start&&"number"==typeof i.end?this.mediaSecondsLoaded+=i.end-i.start:this.mediaSecondsLoaded+=i.duration,this.logger_(function(e){var t=e.segment,i=t.start,r=t.end,n=e.playlist,a=n.mediaSequence,s=n.id,o=n.segments,u=void 0===o?[]:o,d=e.mediaIndex,l=e.timeline;return["appending ["+d+"] of ["+a+", "+(a+u.length)+"] from playlist ["+s+"]","["+i+" => "+r+"] in timeline ["+l+"]"].join(" ")}(t)),this.sourceUpdater_.appendBuffer(t.bytes,this.handleUpdateEnd_.bind(this))}else this.state="READY"}},{key:"handleUpdateEnd_",value:function(){if(!this.pendingSegment_)return this.state="READY",void(this.paused()||this.monitorBuffer_());var e=this.pendingSegment_,t=e.segment,i=null!==this.mediaIndex;(this.pendingSegment_=null,this.recordThroughput_(e),this.addSegmentMetadataCue_(e),this.state="READY",this.mediaIndex=e.mediaIndex,this.fetchAtBuffer_=!0,this.currentTimeline_=e.timeline,this.trigger("syncinfoupdate"),t.end&&this.currentTime_()-t.end>3*e.playlist.targetDuration)?this.resetEverything():(i&&this.trigger("bandwidthupdate"),this.trigger("progress"),ai(e.playlist,this.mediaSource_,e.mediaIndex+1)&&this.endOfStream(),this.paused()||this.monitorBuffer_())}},{key:"recordThroughput_",value:function(e){var t=this.throughput.rate,i=Date.now()-e.endOfAllRequests+1,r=Math.floor(e.byteLength/i*8*1e3);this.throughput.rate+=(r-t)/++this.throughput.count}},{key:"addSegmentMetadataCue_",value:function(e){if(this.segmentMetadataTrack_){var t=e.segment,i=t.start,r=t.end;if(si(i)&&si(r)){Ee(i,r,this.segmentMetadataTrack_);var n=c.WebKitDataCue||c.VTTCue,a={bandwidth:e.playlist.attributes.BANDWIDTH,resolution:e.playlist.attributes.RESOLUTION,codecs:e.playlist.attributes.CODECS,byteLength:e.byteLength,uri:e.uri,timeline:e.timeline,playlist:e.playlist.uri,start:i,end:r},s=new n(i,r,JSON.stringify(a));s.value=a,this.segmentMetadataTrack_.addCue(s)}}}}]),i}(t.EventTarget),ui=new Uint8Array("\n\n".split("").map(function(e){return e.charCodeAt(0)})),di=function(e){return String.fromCharCode.apply(null,e)},li=function(e){function i(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};S(this,i);var r=L(this,(i.__proto__||Object.getPrototypeOf(i)).call(this,e,t));return r.mediaSource_=null,r.subtitlesTrack_=null,r}return E(i,oi),k(i,[{key:"buffered_",value:function(){if(!this.subtitlesTrack_||!this.subtitlesTrack_.cues.length)return t.createTimeRanges();var e=this.subtitlesTrack_.cues,i=e[0].startTime,r=e[e.length-1].startTime;return t.createTimeRanges([[i,r]])}},{key:"initSegment",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]&&arguments[1];if(!e)return null;var i=ge(e),r=this.initSegments_[i];if(t&&!r&&e.bytes){var n=ui.byteLength+e.bytes.byteLength,a=new Uint8Array(n);a.set(e.bytes),a.set(ui,e.bytes.byteLength),this.initSegments_[i]=r={resolvedUri:e.resolvedUri,byterange:e.byterange,bytes:a}}return r||e}},{key:"couldBeginLoading_",value:function(){return this.playlist_&&this.subtitlesTrack_&&!this.paused()}},{key:"init_",value:function(){return this.state="READY",this.resetEverything(),this.monitorBuffer_()}},{key:"track",value:function(e){return"undefined"==typeof e?this.subtitlesTrack_:(this.subtitlesTrack_=e,"INIT"===this.state&&this.couldBeginLoading_()&&this.init_(),this.subtitlesTrack_)}},{key:"remove",value:function(e,t){Ee(e,t,this.subtitlesTrack_)}},{key:"fillBuffer_",value:function(){var e=this;this.syncPoint_||(this.syncPoint_=this.syncController_.getSyncPoint(this.playlist_,this.duration_(),this.currentTimeline_,this.currentTime_()));var t=this.checkBuffer_(this.buffered_(),this.playlist_,this.mediaIndex,this.hasPlayed_(),this.currentTime_(),this.syncPoint_);if(t=this.skipEmptySegments_(t)){if(null===this.syncController_.timestampOffsetForTimeline(t.timeline)){return this.syncController_.one("timestampoffset",function(){e.state="READY",e.paused()||e.monitorBuffer_()}),void(this.state="WAITING_ON_TIMELINE")}this.loadSegment_(t)}}},{key:"skipEmptySegments_",value:function(e){for(;e&&e.segment.empty;)e=this.generateSegmentInfo_(e.playlist,e.mediaIndex+1,e.startOfSegment+e.duration,e.isSyncRequest);return e}},{key:"handleSegment_",value:function(){var e=this;if(this.pendingSegment_&&this.subtitlesTrack_){this.state="APPENDING";var t=this.pendingSegment_,i=t.segment;if("function"!=typeof c.WebVTT&&this.subtitlesTrack_&&this.subtitlesTrack_.tech_){var r=function(){e.handleSegment_()};return this.state="WAITING_ON_VTTJS",this.subtitlesTrack_.tech_.one("vttjsloaded",r),void this.subtitlesTrack_.tech_.one("vttjserror",function(){e.subtitlesTrack_.tech_.off("vttjsloaded",r),e.error({message:"Error loading vtt.js"}),e.state="READY",e.pause(),e.trigger("error")})}i.requested=!0;try{this.parseVTTCues_(t)}catch(e){return this.error({message:e.message}),this.state="READY",this.pause(),this.trigger("error")}if(this.updateTimeMapping_(t,this.syncController_.timelines[t.timeline],this.playlist_),t.isSyncRequest)return this.trigger("syncinfoupdate"),this.pendingSegment_=null,void(this.state="READY");t.byteLength=t.bytes.byteLength,this.mediaSecondsLoaded+=i.duration,t.cues.length&&this.remove(t.cues[0].endTime,t.cues[t.cues.length-1].endTime),t.cues.forEach(function(t){e.subtitlesTrack_.addCue(t)}),this.handleUpdateEnd_()}else this.state="READY"}},{key:"parseVTTCues_",value:function(e){var i=void 0,r=!1;"function"==typeof c.TextDecoder?i=new c.TextDecoder("utf8"):(i=c.WebVTT.StringDecoder(),r=!0);var n=new c.WebVTT.Parser(c,c.vttjs,i);if(e.cues=[],e.timestampmap={MPEGTS:0,LOCAL:0},n.oncue=e.cues.push.bind(e.cues),n.ontimestampmap=function(t){return e.timestampmap=t},n.onparsingerror=function(e){t.log.warn("Error encountered when parsing cues: "+e.message)},e.segment.map){var a=e.segment.map.bytes;r&&(a=di(a)),n.parse(a)}var s=e.bytes;r&&(s=di(s)),n.parse(s),n.flush()}},{key:"updateTimeMapping_",value:function(e,t,i){var r=e.segment;if(t)if(e.cues.length){var n=e.timestampmap,a=n.MPEGTS/9e4-n.LOCAL+t.mapping;if(e.cues.forEach(function(e){e.startTime+=a,e.endTime+=a}),!i.syncInfo){var s=e.cues[0].startTime,o=e.cues[e.cues.length-1].startTime;i.syncInfo={mediaSequence:i.mediaSequence+e.mediaIndex,time:Math.min(s,o-r.duration)}}}else r.empty=!0}}]),i}(),ci=function(e,t){for(var i=e.cues,r=0;r<i.length;r++){var n=i[r];if(t>=n.adStartTime&&t<=n.adEndTime)return n}return null},hi=function(e){return e>>>0};qt=function(e,t){var i,r,n,a,s,o=[];if(!t.length)return null;for(i=0;i<e.byteLength;)r=hi(e[i]<<24|e[i+1]<<16|e[i+2]<<8|e[i+3]),n=Ft(e.subarray(i+4,i+8)),a=r>1?i+r:e.byteLength,n===t[0]&&(1===t.length?o.push(e.subarray(i+8,a)):(s=qt(e.subarray(i+8,a),t.slice(1))).length&&(o=o.concat(s))),i=a;return o};Ft=function(e){var t="";return t+=String.fromCharCode(e[0]),t+=String.fromCharCode(e[1]),t+=String.fromCharCode(e[2]),t+=String.fromCharCode(e[3])};var fi=function(e){return qt(e,["moov","trak"]).reduce(function(e,t){var i,r,n,a,s;return(i=qt(t,["tkhd"])[0])?(r=i[0],a=hi(i[n=0===r?12:20]<<24|i[n+1]<<16|i[n+2]<<8|i[n+3]),(s=qt(t,["mdia","mdhd"])[0])?(n=0===(r=s[0])?12:20,e[a]=hi(s[n]<<24|s[n+1]<<16|s[n+2]<<8|s[n+3]),e):null):null},{})},pi=function(e,t){var i,r,n;return i=qt(t,["moof","traf"]),r=[].concat.apply([],i.map(function(t){return qt(t,["tfhd"]).map(function(i){var r,n;return r=hi(i[4]<<24|i[5]<<16|i[6]<<8|i[7]),n=e[r]||9e4,(qt(t,["tfdt"]).map(function(e){var t,i;return t=e[0],i=hi(e[4]<<24|e[5]<<16|e[6]<<8|e[7]),1===t&&(i*=Math.pow(2,32),i+=hi(e[8]<<24|e[9]<<16|e[10]<<8|e[11])),i})[0]||1/0)/n})})),n=Math.min.apply(null,r),isFinite(n)?n:0},mi=27,gi=15,yi=21,_i=function(){this.init=function(){var e={};this.on=function(t,i){e[t]||(e[t]=[]),e[t]=e[t].concat(i)},this.off=function(t,i){var r;return!!e[t]&&(r=e[t].indexOf(i),e[t]=e[t].slice(),e[t].splice(r,1),r>-1)},this.trigger=function(t){var i,r,n,a;if(i=e[t])if(2===arguments.length)for(n=i.length,r=0;r<n;++r)i[r].call(this,arguments[1]);else{for(a=[],r=arguments.length,r=1;r<arguments.length;++r)a.push(arguments[r]);for(n=i.length,r=0;r<n;++r)i[r].apply(this,a)}},this.dispose=function(){e={}}}};_i.prototype.pipe=function(e){return this.on("data",function(t){e.push(t)}),this.on("done",function(t){e.flush(t)}),e},_i.prototype.push=function(e){this.trigger("data",e)},_i.prototype.flush=function(e){this.trigger("done",e)};var vi=function(e,t){var i=1;for(e>t&&(i=-1);Math.abs(t-e)>4294967296;)e+=8589934592*i;return e},bi=function e(t){var i,r;e.prototype.init.call(this),this.type_=t,this.push=function(e){e.type===this.type_&&(void 0===r&&(r=e.dts),e.dts=vi(e.dts,r),e.pts=vi(e.pts,r),i=e.dts,this.trigger("data",e))},this.flush=function(){r=i,this.trigger("done")},this.discontinuity=function(){r=void 0,i=void 0}};bi.prototype=new _i;var Ti=function(e){var t=31&e[1];return t<<=8,t|=e[2]},Si=function(e){return!!(64&e[1])},ki=function(e){var t=0;return(48&e[3])>>>4>1&&(t+=e[4]+1),t},Ei=function(e){switch(e){case 5:return"slice_layer_without_partitioning_rbsp_idr";case 6:return"sei_rbsp";case 7:return"seq_parameter_set_rbsp";case 8:return"pic_parameter_set_rbsp";case 9:return"access_unit_delimiter_rbsp";default:return null}},Li={parseType:function(e,t){var i=Ti(e);return 0===i?"pat":i===t?"pmt":t?"pes":null},parsePat:function(e){var t=Si(e),i=4+ki(e);return t&&(i+=e[i]+1),(31&e[i+10])<<8|e[i+11]},parsePmt:function(e){var t={},i=Si(e),r=4+ki(e);if(i&&(r+=e[r]+1),1&e[r+5]){var n;n=3+((15&e[r+1])<<8|e[r+2])-4;for(var a=12+((15&e[r+10])<<8|e[r+11]);a<n;){var s=r+a;t[(31&e[s+1])<<8|e[s+2]]=e[s],a+=5+((15&e[s+3])<<8|e[s+4])}return t}},parsePayloadUnitStartIndicator:Si,parsePesType:function(e,t){switch(t[Ti(e)]){case mi:return"video";case gi:return"audio";case yi:return"timed-metadata";default:return null}},parsePesTime:function(e){if(!Si(e))return null;var t=4+ki(e);if(t>=e.byteLength)return null;var i,r=null;return 192&(i=e[t+7])&&((r={}).pts=(14&e[t+9])<<27|(255&e[t+10])<<20|(254&e[t+11])<<12|(255&e[t+12])<<5|(254&e[t+13])>>>3,r.pts*=4,r.pts+=(6&e[t+13])>>>1,r.dts=r.pts,64&i&&(r.dts=(14&e[t+14])<<27|(255&e[t+15])<<20|(254&e[t+16])<<12|(255&e[t+17])<<5|(254&e[t+18])>>>3,r.dts*=4,r.dts+=(6&e[t+18])>>>1)),r},videoPacketContainsKeyFrame:function(e){for(var t=4+ki(e),i=e.subarray(t),r=0,n=0,a=!1;n<i.byteLength-3;n++)if(1===i[n+2]){r=n+5;break}for(;r<i.byteLength;)switch(i[r]){case 0:if(0!==i[r-1]){r+=2;break}if(0!==i[r-2]){r++;break}n+3!==r-2&&"slice_layer_without_partitioning_rbsp_idr"===Ei(31&i[n+3])&&(a=!0);do{r++}while(1!==i[r]&&r<i.length);n=r-2,r+=3;break;case 1:if(0!==i[r-1]||0!==i[r-2]){r+=3;break}"slice_layer_without_partitioning_rbsp_idr"===Ei(31&i[n+3])&&(a=!0),n=r-2,r+=3;break;default:r+=3}return i=i.subarray(n),r-=n,n=0,i&&i.byteLength>3&&"slice_layer_without_partitioning_rbsp_idr"===Ei(31&i[n+3])&&(a=!0),a}},Ai=[96e3,88200,64e3,48e3,44100,32e3,24e3,22050,16e3,12e3,11025,8e3,7350],wi=function(e){return e[0]<<21|e[1]<<14|e[2]<<7|e[3]},Ii={parseId3TagSize:function(e,t){var i=e[t+6]<<21|e[t+7]<<14|e[t+8]<<7|e[t+9];return(16&e[t+5])>>4?i+20:i+10},parseAdtsSize:function(e,t){var i=(224&e[t+5])>>5,r=e[t+4]<<3;return 6144&e[t+3]|r|i},parseType:function(e,t){return e[t]==="I".charCodeAt(0)&&e[t+1]==="D".charCodeAt(0)&&e[t+2]==="3".charCodeAt(0)?"timed-metadata":!0&e[t]&&240==(240&e[t+1])?"audio":null},parseSampleRate:function(e){for(var t=0;t+5<e.length;){if(255===e[t]&&240==(246&e[t+1]))return Ai[(60&e[t+2])>>>2];t++}return null},parseAacTimestamp:function(e){var t,i,r;t=10,64&e[5]&&(t+=4,t+=wi(e.subarray(10,14)));do{if((i=wi(e.subarray(t+4,t+8)))<1)return null;if("PRIV"===String.fromCharCode(e[t],e[t+1],e[t+2],e[t+3])){r=e.subarray(t+10,t+i+10);for(var n=0;n<r.byteLength;n++)if(0===r[n]){if("com.apple.streaming.transportStreamTimestamp"===unescape(function(e,t,i){var r,n="";for(r=t;r<i;r++)n+="%"+("00"+e[r].toString(16)).slice(-2);return n}(r,0,n))){var a=r.subarray(n+1),s=(1&a[3])<<30|a[4]<<22|a[5]<<14|a[6]<<6|a[7]>>>2;return s*=4,s+=3&a[7]}break}}t+=10,t+=i}while(t<e.byteLength);return null}},Oi=vi,Ci={};Ci.ts=Li,Ci.aac=Ii;var Pi=function(e,t,i){for(var r,n,a,s,o=0,u=188,d=!1;u<e.byteLength;)if(71!==e[o]||71!==e[u])o++,u++;else{switch(r=e.subarray(o,u),Ci.ts.parseType(r,t.pid)){case"pes":n=Ci.ts.parsePesType(r,t.table),a=Ci.ts.parsePayloadUnitStartIndicator(r),"audio"===n&&a&&(s=Ci.ts.parsePesTime(r))&&(s.type="audio",i.audio.push(s),d=!0)}if(d)break;o+=188,u+=188}for(o=(u=e.byteLength)-188,d=!1;o>=0;)if(71!==e[o]||71!==e[u])o--,u--;else{switch(r=e.subarray(o,u),Ci.ts.parseType(r,t.pid)){case"pes":n=Ci.ts.parsePesType(r,t.table),a=Ci.ts.parsePayloadUnitStartIndicator(r),"audio"===n&&a&&(s=Ci.ts.parsePesTime(r))&&(s.type="audio",i.audio.push(s),d=!0)}if(d)break;o-=188,u-=188}},Ui=function(e,t,i){for(var r,n,a,s,o,u,d,l=0,c=188,h=!1,f={data:[],size:0};c<e.byteLength;)if(71!==e[l]||71!==e[c])l++,c++;else{switch(r=e.subarray(l,c),Ci.ts.parseType(r,t.pid)){case"pes":if(n=Ci.ts.parsePesType(r,t.table),a=Ci.ts.parsePayloadUnitStartIndicator(r),"video"===n&&(a&&!h&&(s=Ci.ts.parsePesTime(r))&&(s.type="video",i.video.push(s),h=!0),!i.firstKeyFrame)){if(a&&0!==f.size){for(o=new Uint8Array(f.size),u=0;f.data.length;)d=f.data.shift(),o.set(d,u),u+=d.byteLength;Ci.ts.videoPacketContainsKeyFrame(o)&&(i.firstKeyFrame=Ci.ts.parsePesTime(o),i.firstKeyFrame.type="video"),f.size=0}f.data.push(r),f.size+=r.byteLength}}if(h&&i.firstKeyFrame)break;l+=188,c+=188}for(l=(c=e.byteLength)-188,h=!1;l>=0;)if(71!==e[l]||71!==e[c])l--,c--;else{switch(r=e.subarray(l,c),Ci.ts.parseType(r,t.pid)){case"pes":n=Ci.ts.parsePesType(r,t.table),a=Ci.ts.parsePayloadUnitStartIndicator(r),"video"===n&&a&&(s=Ci.ts.parsePesTime(r))&&(s.type="video",i.video.push(s),h=!0)}if(h)break;l-=188,c-=188}},Di=function(e){var t={pid:null,table:null},i={};for(var r in function(e,t){for(var i,r=0,n=188;n<e.byteLength;)if(71!==e[r]||71!==e[n])r++,n++;else{switch(i=e.subarray(r,n),Ci.ts.parseType(i,t.pid)){case"pat":t.pid||(t.pid=Ci.ts.parsePat(i));break;case"pmt":t.table||(t.table=Ci.ts.parsePmt(i))}if(t.pid&&t.table)return;r+=188,n+=188}}(e,t),t.table){if(t.table.hasOwnProperty(r))switch(t.table[r]){case mi:i.video=[],Ui(e,t,i),0===i.video.length&&delete i.video;break;case gi:i.audio=[],Pi(e,t,i),0===i.audio.length&&delete i.audio}}return i},Ri=function(e,t){var i,r;return(r=(i=e)[0]==="I".charCodeAt(0)&&i[1]==="D".charCodeAt(0)&&i[2]==="3".charCodeAt(0)?function(e){for(var t,i=!1,r=0,n=null,a=null,s=0,o=0;e.length-o>=3;){switch(Ci.aac.parseType(e,o)){case"timed-metadata":if(e.length-o<10){i=!0;break}if((s=Ci.aac.parseId3TagSize(e,o))>e.length){i=!0;break}null===a&&(t=e.subarray(o,o+s),a=Ci.aac.parseAacTimestamp(t)),o+=s;break;case"audio":if(e.length-o<7){i=!0;break}if((s=Ci.aac.parseAdtsSize(e,o))>e.length){i=!0;break}null===n&&(t=e.subarray(o,o+s),n=Ci.aac.parseSampleRate(t)),r++,o+=s;break;default:o++}if(i)return null}if(null===n||null===a)return null;var u=9e4/n;return{audio:[{type:"audio",dts:a,pts:a},{type:"audio",dts:a+1024*r*u,pts:a+1024*r*u}]}}(e):Di(e))&&(r.audio||r.video)?(function(e,t){if(e.audio&&e.audio.length){var i=t;"undefined"==typeof i&&(i=e.audio[0].dts),e.audio.forEach(function(e){e.dts=Oi(e.dts,i),e.pts=Oi(e.pts,i),e.dtsTime=e.dts/9e4,e.ptsTime=e.pts/9e4})}if(e.video&&e.video.length){var r=t;if("undefined"==typeof r&&(r=e.video[0].dts),e.video.forEach(function(e){e.dts=Oi(e.dts,r),e.pts=Oi(e.pts,r),e.dtsTime=e.dts/9e4,e.ptsTime=e.pts/9e4}),e.firstKeyFrame){var n=e.firstKeyFrame;n.dts=Oi(n.dts,r),n.pts=Oi(n.pts,r),n.dtsTime=n.dts/9e4,n.ptsTime=n.dts/9e4}}}(r,t),r):null},Bi=[{name:"VOD",run:function(e,t,i,r,n){if(i!==1/0){return{time:0,segmentIndex:0}}return null}},{name:"ProgramDateTime",run:function(e,t,i,r,n){if(!e.datetimeToDisplayTime)return null;var a=t.segments||[],s=null,o=null;n=n||0;for(var u=0;u<a.length;u++){var d=a[u];if(d.dateTimeObject){var l=d.dateTimeObject.getTime()/1e3+e.datetimeToDisplayTime,c=Math.abs(n-l);if(null!==o&&o<c)break;o=c,s={time:l,segmentIndex:u}}}return s}},{name:"Segment",run:function(e,t,i,r,n){var a=t.segments||[],s=null,o=null;n=n||0;for(var u=0;u<a.length;u++){var d=a[u];if(d.timeline===r&&"undefined"!=typeof d.start){var l=Math.abs(n-d.start);if(null!==o&&o<l)break;(!s||null===o||o>=l)&&(o=l,s={time:d.start,segmentIndex:u})}}return s}},{name:"Discontinuity",run:function(e,t,i,r,n){var a=null;if(n=n||0,t.discontinuityStarts&&t.discontinuityStarts.length)for(var s=null,o=0;o<t.discontinuityStarts.length;o++){var u=t.discontinuityStarts[o],d=t.discontinuitySequence+o+1,l=e.discontinuities[d];if(l){var c=Math.abs(n-l.time);if(null!==s&&s<c)break;(!a||null===s||s>=c)&&(s=c,a={time:l.time,segmentIndex:u})}}return a}},{name:"Playlist",run:function(e,t,i,r,n){return t.syncInfo?{time:t.syncInfo.time,segmentIndex:t.syncInfo.mediaSequence-t.mediaSequence}:null}}],Mi=function(e){function t(){S(this,t);var e=L(this,(t.__proto__||Object.getPrototypeOf(t)).call(this));return e.inspectCache_=void 0,e.timelines=[],e.discontinuities=[],e.datetimeToDisplayTime=null,e.logger_=xt("SyncController"),e}return E(t,e),k(t,[{key:"getSyncPoint",value:function(e,t,i,r){var n=this.runStrategies_(e,t,i,r);return n.length?this.selectSyncPoint_(n,{key:"time",value:r}):null}},{key:"getExpiredTime",value:function(e,t){if(!e||!e.segments)return null;var i=this.runStrategies_(e,t,e.discontinuitySequence,0);if(!i.length)return null;var r=this.selectSyncPoint_(i,{key:"segmentIndex",value:0});return r.segmentIndex>0&&(r.time*=-1),Math.abs(r.time+q(e,r.segmentIndex,0))}},{key:"runStrategies_",value:function(e,t,i,r){for(var n=[],a=0;a<Bi.length;a++){var s=Bi[a],o=s.run(this,e,t,i,r);o&&(o.strategy=s.name,n.push({strategy:s.name,syncPoint:o}))}return n}},{key:"selectSyncPoint_",value:function(e,t){for(var i=e[0].syncPoint,r=Math.abs(e[0].syncPoint[t.key]-t.value),n=e[0].strategy,a=1;a<e.length;a++){var s=Math.abs(e[a].syncPoint[t.key]-t.value);s<r&&(r=s,i=e[a].syncPoint,n=e[a].strategy)}return this.logger_("syncPoint for ["+t.key+": "+t.value+"] chosen with strategy ["+n+"]: [time:"+i.time+", segmentIndex:"+i.segmentIndex+"]"),i}},{key:"saveExpiredSegmentInfo",value:function(e,t){for(var i=t.mediaSequence-e.mediaSequence-1;i>=0;i--){var r=e.segments[i];if(r&&"undefined"!=typeof r.start){t.syncInfo={mediaSequence:e.mediaSequence+i,time:r.start},this.logger_("playlist refresh sync: [time:"+t.syncInfo.time+", mediaSequence: "+t.syncInfo.mediaSequence+"]"),this.trigger("syncinfoupdate");break}}}},{key:"setDateTimeMapping",value:function(e){if(!this.datetimeToDisplayTime&&e.segments&&e.segments.length&&e.segments[0].dateTimeObject){var t=e.segments[0].dateTimeObject.getTime()/1e3;this.datetimeToDisplayTime=-t}}},{key:"reset",value:function(){this.inspectCache_=void 0}},{key:"probeSegmentInfo",value:function(e){var t=e.segment,i=e.playlist,r=void 0;return(r=t.map?this.probeMp4Segment_(e):this.probeTsSegment_(e))&&this.calculateSegmentTimeMapping_(e,r)&&(this.saveDiscontinuitySyncInfo_(e),i.syncInfo||(i.syncInfo={mediaSequence:i.mediaSequence+e.mediaIndex,time:t.start})),r}},{key:"probeMp4Segment_",value:function(e){var t=e.segment,i=fi(t.map.bytes),r=pi(i,e.bytes);return null!==e.timestampOffset&&(e.timestampOffset-=r),{start:r,end:r+t.duration}}},{key:"probeTsSegment_",value:function(e){var t=Ri(e.bytes,this.inspectCache_),i=void 0,r=void 0;return t?(t.video&&2===t.video.length?(this.inspectCache_=t.video[1].dts,i=t.video[0].dtsTime,r=t.video[1].dtsTime):t.audio&&2===t.audio.length&&(this.inspectCache_=t.audio[1].dts,i=t.audio[0].dtsTime,r=t.audio[1].dtsTime),{start:i,end:r,containsVideo:t.video&&2===t.video.length,containsAudio:t.audio&&2===t.audio.length}):null}},{key:"timestampOffsetForTimeline",value:function(e){return"undefined"==typeof this.timelines[e]?null:this.timelines[e].time}},{key:"mappingForTimeline",value:function(e){return"undefined"==typeof this.timelines[e]?null:this.timelines[e].mapping}},{key:"calculateSegmentTimeMapping_",value:function(e,t){var i=e.segment,r=this.timelines[e.timeline];if(null!==e.timestampOffset)r={time:e.startOfSegment,mapping:e.startOfSegment-t.start},this.timelines[e.timeline]=r,this.trigger("timestampoffset"),this.logger_("time mapping for timeline "+e.timeline+": [time: "+r.time+"] [mapping: "+r.mapping+"]"),i.start=e.startOfSegment,i.end=t.end+r.mapping;else{if(!r)return!1;i.start=t.start+r.mapping,i.end=t.end+r.mapping}return!0}},{key:"saveDiscontinuitySyncInfo_",value:function(e){var t=e.playlist,i=e.segment;if(i.discontinuity)this.discontinuities[i.timeline]={time:i.start,accuracy:0};else if(t.discontinuityStarts&&t.discontinuityStarts.length)for(var r=0;r<t.discontinuityStarts.length;r++){var n=t.discontinuityStarts[r],a=t.discontinuitySequence+r+1,s=n-e.mediaIndex,o=Math.abs(s);if(!this.discontinuities[a]||this.discontinuities[a].accuracy>o){var u=void 0;u=s<0?i.start-q(t,e.mediaIndex,n):i.end+q(t,e.mediaIndex+1,n),this.discontinuities[a]={time:u,accuracy:o}}}}}]),t}(t.EventTarget),xi=new De("./decrypter-worker.worker.js",function(e,t){var i=this;!function(){var t="undefined"!=typeof e?e:"undefined"!=typeof global?global:"undefined"!=typeof i?i:{},r="undefined"!=typeof e?e:"undefined"!=typeof t?t:"undefined"!=typeof i?i:{};var n=function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")},a=function(){function e(e,t){for(var i=0;i<t.length;i++){var r=t[i];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}return function(t,i,r){return i&&e(t.prototype,i),r&&e(t,r),t}}(),s=function(e,t){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!t||"object"!=typeof t&&"function"!=typeof t?e:t},o=function(){var e=[[[],[],[],[],[]],[[],[],[],[],[]]],t=e[0],i=e[1],r=t[4],n=i[4],a=void 0,s=void 0,o=void 0,u=[],d=[],l=void 0,c=void 0,h=void 0,f=void 0,p=void 0;for(a=0;a<256;a++)d[(u[a]=a<<1^283*(a>>7))^a]=a;for(s=o=0;!r[s];s^=l||1,o=d[o]||1)for(h=(h=o^o<<1^o<<2^o<<3^o<<4)>>8^255&h^99,r[s]=h,n[h]=s,p=16843009*u[c=u[l=u[s]]]^65537*c^257*l^16843008*s,f=257*u[h]^16843008*h,a=0;a<4;a++)t[a][s]=f=f<<24^f>>>8,i[a][h]=p=p<<24^p>>>8;for(a=0;a<5;a++)t[a]=t[a].slice(0),i[a]=i[a].slice(0);return e},u=null,d=function(){function e(t){n(this,e),u||(u=o()),this._tables=[[u[0][0].slice(),u[0][1].slice(),u[0][2].slice(),u[0][3].slice(),u[0][4].slice()],[u[1][0].slice(),u[1][1].slice(),u[1][2].slice(),u[1][3].slice(),u[1][4].slice()]];var i=void 0,r=void 0,a=void 0,s=void 0,d=void 0,l=this._tables[0][4],c=this._tables[1],h=t.length,f=1;if(4!==h&&6!==h&&8!==h)throw new Error("Invalid aes key size");for(s=t.slice(0),d=[],this._key=[s,d],i=h;i<4*h+28;i++)a=s[i-1],(i%h==0||8===h&&i%h==4)&&(a=l[a>>>24]<<24^l[a>>16&255]<<16^l[a>>8&255]<<8^l[255&a],i%h==0&&(a=a<<8^a>>>24^f<<24,f=f<<1^283*(f>>7))),s[i]=s[i-h]^a;for(r=0;i;r++,i--)a=s[3&r?i:i-4],d[r]=i<=4||r<4?a:c[0][l[a>>>24]]^c[1][l[a>>16&255]]^c[2][l[a>>8&255]]^c[3][l[255&a]]}return e.prototype.decrypt=function(e,t,i,r,n,a){var s=this._key[1],o=e^s[0],u=r^s[1],d=i^s[2],l=t^s[3],c=void 0,h=void 0,f=void 0,p=s.length/4-2,m=void 0,g=4,y=this._tables[1],_=y[0],v=y[1],b=y[2],T=y[3],S=y[4];for(m=0;m<p;m++)c=_[o>>>24]^v[u>>16&255]^b[d>>8&255]^T[255&l]^s[g],h=_[u>>>24]^v[d>>16&255]^b[l>>8&255]^T[255&o]^s[g+1],f=_[d>>>24]^v[l>>16&255]^b[o>>8&255]^T[255&u]^s[g+2],l=_[l>>>24]^v[o>>16&255]^b[u>>8&255]^T[255&d]^s[g+3],g+=4,o=c,u=h,d=f;for(m=0;m<4;m++)n[(3&-m)+a]=S[o>>>24]<<24^S[u>>16&255]<<16^S[d>>8&255]<<8^S[255&l]^s[g++],c=o,o=u,u=d,d=l,l=c},e}(),l=function(){function e(){n(this,e),this.listeners={}}return e.prototype.on=function(e,t){this.listeners[e]||(this.listeners[e]=[]),this.listeners[e].push(t)},e.prototype.off=function(e,t){if(!this.listeners[e])return!1;var i=this.listeners[e].indexOf(t);return this.listeners[e].splice(i,1),i>-1},e.prototype.trigger=function(e){var t=this.listeners[e];if(t)if(2===arguments.length)for(var i=t.length,r=0;r<i;++r)t[r].call(this,arguments[1]);else for(var n=Array.prototype.slice.call(arguments,1),a=t.length,s=0;s<a;++s)t[s].apply(this,n)},e.prototype.dispose=function(){this.listeners={}},e.prototype.pipe=function(e){this.on("data",function(t){e.push(t)})},e}(),c=function(e){function t(){n(this,t);var i=s(this,e.call(this,l));return i.jobs=[],i.delay=1,i.timeout_=null,i}return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t);e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)}(t,e),t.prototype.processJob_=function(){this.jobs.shift()(),this.jobs.length?this.timeout_=setTimeout(this.processJob_.bind(this),this.delay):this.timeout_=null},t.prototype.push=function(e){this.jobs.push(e),this.timeout_||(this.timeout_=setTimeout(this.processJob_.bind(this),this.delay))},t}(l),h=function(e){return e<<24|(65280&e)<<8|(16711680&e)>>8|e>>>24},f=function(){function e(t,i,r,a){n(this,e);var s=e.STEP,o=new Int32Array(t.buffer),u=new Uint8Array(t.byteLength),d=0;for(this.asyncStream_=new c,this.asyncStream_.push(this.decryptChunk_(o.subarray(d,d+s),i,r,u)),d=s;d<o.length;d+=s)r=new Uint32Array([h(o[d-4]),h(o[d-3]),h(o[d-2]),h(o[d-1])]),this.asyncStream_.push(this.decryptChunk_(o.subarray(d,d+s),i,r,u));this.asyncStream_.push(function(){var e;a(null,(e=u).subarray(0,e.byteLength-e[e.byteLength-1]))})}return e.prototype.decryptChunk_=function(e,t,i,r){return function(){var n=function(e,t,i){var r=new Int32Array(e.buffer,e.byteOffset,e.byteLength>>2),n=new d(Array.prototype.slice.call(t)),a=new Uint8Array(e.byteLength),s=new Int32Array(a.buffer),o=void 0,u=void 0,l=void 0,c=void 0,f=void 0,p=void 0,m=void 0,g=void 0,y=void 0;for(o=i[0],u=i[1],l=i[2],c=i[3],y=0;y<r.length;y+=4)f=h(r[y]),p=h(r[y+1]),m=h(r[y+2]),g=h(r[y+3]),n.decrypt(f,p,m,g,s,y),s[y]=h(s[y]^o),s[y+1]=h(s[y+1]^u),s[y+2]=h(s[y+2]^l),s[y+3]=h(s[y+3]^c),o=f,u=p,l=m,c=g;return a}(e,t,i);r.set(n,e.byteOffset)}},a(e,null,[{key:"STEP",get:function(){return 32e3}}]),e}();new function(e){e.onmessage=function(e){var t=e.data,i=new Uint8Array(t.encrypted.bytes,t.encrypted.byteOffset,t.encrypted.byteLength),n=new Uint32Array(t.key.bytes,t.key.byteOffset,t.key.byteLength/4),a=new Uint32Array(t.iv.bytes,t.iv.byteOffset,t.iv.byteLength/4);new f(i,n,a,function(e,i){var n,a;r.postMessage((n={source:t.source,decrypted:i},a={},Object.keys(n).forEach(function(e){var t=n[e];ArrayBuffer.isView(t)?a[e]={bytes:t.buffer,byteOffset:t.byteOffset,byteLength:t.byteLength}:a[e]=t}),a),[i.buffer])})}}(i)}()}),Ni=function(e){var t=e.default?"main":"alternative";return e.characteristics&&e.characteristics.indexOf("public.accessibility.describes-video")>=0&&(t="main-desc"),t},qi=function(e,t){e.abort(),e.pause(),t&&t.activePlaylistLoader&&(t.activePlaylistLoader.pause(),t.activePlaylistLoader=null)},Fi=function(e,t){t.activePlaylistLoader=e,e.load()},Hi={AUDIO:function(e,i){return function(){var r=i.segmentLoaders[e],n=i.mediaTypes[e],a=i.blacklistCurrentPlaylist;qi(r,n);var s=n.activeTrack(),o=n.activeGroup(),u=(o.filter(function(e){return e.default})[0]||o[0]).id,d=n.tracks[u];if(s!==d){for(var l in t.log.warn("Problem encountered loading the alternate audio track.Switching back to default."),n.tracks)n.tracks[l].enabled=n.tracks[l]===d;n.onTrackChanged()}else a({message:"Problem encountered loading the default audio track."})}},SUBTITLES:function(e,i){return function(){var r=i.segmentLoaders[e],n=i.mediaTypes[e];t.log.warn("Problem encountered loading the subtitle track.Disabling subtitle track."),qi(r,n);var a=n.activeTrack();a&&(a.mode="disabled"),n.onTrackChanged()}}},Gi={AUDIO:function(e,t,i){if(t){var r=i.tech,n=i.requestOptions,a=i.segmentLoaders[e];t.on("loadedmetadata",function(){var e=t.media();a.playlist(e,n),(!r.paused()||e.endList&&"none"!==r.preload())&&a.load()}),t.on("loadedplaylist",function(){a.playlist(t.media(),n),r.paused()||a.load()}),t.on("error",Hi[e](e,i))}},SUBTITLES:function(e,t,i){var r=i.tech,n=i.requestOptions,a=i.segmentLoaders[e],s=i.mediaTypes[e];t.on("loadedmetadata",function(){var e=t.media();a.playlist(e,n),a.track(s.activeTrack()),(!r.paused()||e.endList&&"none"!==r.preload())&&a.load()}),t.on("loadedplaylist",function(){a.playlist(t.media(),n),r.paused()||a.load()}),t.on("error",Hi[e](e,i))}},ji=function(e,t){return function(i){return i.attributes[e]===t}},Wi=function(e){return function(t){return t.resolvedUri===e}},Vi={AUDIO:function(e,i){var r=i.hls,n=i.sourceType,a=i.segmentLoaders[e],s=i.requestOptions.withCredentials,o=i.master,u=o.mediaGroups,d=o.playlists,l=i.mediaTypes[e],c=l.groups,h=l.tracks,f=i.masterPlaylistLoader;for(var p in u[e]&&0!==Object.keys(u[e]).length||(u[e]={main:{default:{default:!0}}}),u[e]){c[p]||(c[p]=[]);var m=d.filter(ji(e,p));for(var g in u[e][p]){var y=u[e][p][g];m.filter(Wi(y.resolvedUri)).length&&delete y.resolvedUri;var _=void 0;if(_=y.resolvedUri?new B(y.resolvedUri,r,s):y.playlists&&"dash"===n?new Mt(y.playlists[0],r,s,f):null,y=t.mergeOptions({id:g,playlistLoader:_},y),Gi[e](e,y.playlistLoader,i),c[p].push(y),"undefined"==typeof h[g]){var v=new t.AudioTrack({id:g,kind:Ni(y),enabled:!1,language:y.language,default:y.default,label:g});h[g]=v}}}a.on("error",Hi[e](e,i))},SUBTITLES:function(e,i){var r=i.tech,n=i.hls,a=i.sourceType,s=i.segmentLoaders[e],o=i.requestOptions.withCredentials,u=i.master.mediaGroups,d=i.mediaTypes[e],l=d.groups,c=d.tracks,h=i.masterPlaylistLoader;for(var f in u[e])for(var p in l[f]||(l[f]=[]),u[e][f])if(!u[e][f][p].forced){var m=u[e][f][p],g=void 0;if("hls"===a?g=new B(m.resolvedUri,n,o):"dash"===a&&(g=new Mt(m.playlists[0],n,o,h)),m=t.mergeOptions({id:p,playlistLoader:g},m),Gi[e](e,m.playlistLoader,i),l[f].push(m),"undefined"==typeof c[p]){var y=r.addRemoteTextTrack({id:p,kind:"subtitles",enabled:!1,language:m.language,label:p},!1).track;c[p]=y}}s.on("error",Hi[e](e,i))},"CLOSED-CAPTIONS":function(e,i){var r=i.tech,n=i.master.mediaGroups,a=i.mediaTypes[e],s=a.groups,o=a.tracks;for(var u in n[e])for(var d in s[u]||(s[u]=[]),n[e][u]){var l=n[e][u][d];if(l.instreamId.match(/CC\d/)&&(s[u].push(t.mergeOptions({id:d},l)),"undefined"==typeof o[d])){var c=r.addRemoteTextTrack({id:l.instreamId,kind:"captions",enabled:!1,language:l.language,label:d},!1).track;o[d]=c}}}},zi={AUDIO:function(e,t){return function(){var i=t.mediaTypes[e].tracks;for(var r in i)if(i[r].enabled)return i[r];return null}},SUBTITLES:function(e,t){return function(){var i=t.mediaTypes[e].tracks;for(var r in i)if("showing"===i[r].mode)return i[r];return null}}},Xi=function(e){["AUDIO","SUBTITLES","CLOSED-CAPTIONS"].forEach(function(t){Vi[t](t,e)});var t=e.mediaTypes,i=e.masterPlaylistLoader,r=e.tech,n=e.hls;["AUDIO","SUBTITLES"].forEach(function(i){t[i].activeGroup=function(e,t){return function(i){var r=t.masterPlaylistLoader,n=t.mediaTypes[e].groups,a=r.media();if(!a)return null;var s=null;return a.attributes[e]&&(s=n[a.attributes[e]]),s=s||n.main,"undefined"==typeof i?s:null===i?null:s.filter(function(e){return e.id===i.id})[0]||null}}(i,e),t[i].activeTrack=zi[i](i,e),t[i].onGroupChanged=function(e,t){return function(){var i=t.segmentLoaders,r=i[e],n=i.main,a=t.mediaTypes[e],s=a.activeTrack(),o=a.activeGroup(s),u=a.activePlaylistLoader;qi(r,a),o&&(o.playlistLoader?(r.resyncLoader(),Fi(o.playlistLoader,a)):u&&n.resetEverything())}}(i,e),t[i].onTrackChanged=function(e,t){return function(){var i=t.segmentLoaders,r=i[e],n=i.main,a=t.mediaTypes[e],s=a.activeTrack(),o=a.activeGroup(s),u=a.activePlaylistLoader;qi(r,a),o&&(o.playlistLoader?u!==o.playlistLoader?(r.track&&r.track(s),r.resetEverything(),Fi(o.playlistLoader,a)):Fi(o.playlistLoader,a):n.resetEverything())}}(i,e)});var a=t.AUDIO.activeGroup(),s=(a.filter(function(e){return e.default})[0]||a[0]).id;t.AUDIO.tracks[s].enabled=!0,t.AUDIO.onTrackChanged(),i.on("mediachange",function(){["AUDIO","SUBTITLES"].forEach(function(e){return t[e].onGroupChanged()})});var o=function(){t.AUDIO.onTrackChanged(),r.trigger({type:"usage",name:"hls-audio-change"})};for(var u in r.audioTracks().addEventListener("change",o),r.remoteTextTracks().addEventListener("change",t.SUBTITLES.onTrackChanged),n.on("dispose",function(){r.audioTracks().removeEventListener("change",o),r.remoteTextTracks().removeEventListener("change",t.SUBTITLES.onTrackChanged)}),r.clearTracks("audio"),t.AUDIO.tracks)r.audioTracks().addTrack(t.AUDIO.tracks[u])},Yi=function(){var e={};return["AUDIO","SUBTITLES","CLOSED-CAPTIONS"].forEach(function(t){e[t]={groups:{},tracks:{},activePlaylistLoader:null,activeGroup:Nt,activeTrack:Nt,onGroupChanged:Nt,onTrackChanged:Nt}}),e},$i=void 0,Ki=["mediaRequests","mediaRequestsAborted","mediaRequestsTimedout","mediaRequestsErrored","mediaTransferDuration","mediaBytesTransferred"],Qi=function(e){return this.audioSegmentLoader_[e]+this.mainSegmentLoader_[e]},Ji=function(e){function i(e){S(this,i);var r=L(this,(i.__proto__||Object.getPrototypeOf(i)).call(this)),n=e.url,a=e.withCredentials,s=e.tech,o=e.bandwidth,u=e.externHls,d=e.useCueTags,l=e.blacklistDuration,c=e.enableLowInitialPlaylist,h=e.sourceType;if(!n)throw new Error("A non-empty playlist URL is required");$i=u,r.withCredentials=a,r.tech_=s,r.hls_=s.hls,r.sourceType_=h,r.useCueTags_=d,r.blacklistDuration=l,r.enableLowInitialPlaylist=c,r.useCueTags_&&(r.cueTagsTrack_=r.tech_.addTextTrack("metadata","ad-cues"),r.cueTagsTrack_.inBandMetadataTrackDispatchType=""),r.requestOptions_={withCredentials:r.withCredentials,timeout:null},r.mediaTypes_=Yi(),r.mediaSource=new t.MediaSource,r.mediaSource.addEventListener("sourceopen",r.handleSourceOpen_.bind(r)),r.seekable_=t.createTimeRanges(),r.hasPlayed_=function(){return!1},r.syncController_=new Mi(e),r.segmentMetadataTrack_=s.addRemoteTextTrack({kind:"metadata",label:"segment-metadata"},!1).track,r.decrypter_=new xi;var f={hls:r.hls_,mediaSource:r.mediaSource,currentTime:r.tech_.currentTime.bind(r.tech_),seekable:function(){return r.seekable()},seeking:function(){return r.tech_.seeking()},duration:function(){return r.mediaSource.duration},hasPlayed:function(){return r.hasPlayed_()},goalBufferLength:function(){return r.goalBufferLength()},bandwidth:o,syncController:r.syncController_,decrypter:r.decrypter_,sourceType:r.sourceType_};return r.masterPlaylistLoader_="dash"===r.sourceType_?new Mt(n,r.hls_,r.withCredentials):new B(n,r.hls_,r.withCredentials),r.setupMasterPlaylistLoaderListeners_(),r.mainSegmentLoader_=new oi(t.mergeOptions(f,{segmentMetadataTrack:r.segmentMetadataTrack_,loaderType:"main"}),e),r.audioSegmentLoader_=new oi(t.mergeOptions(f,{loaderType:"audio"}),e),r.subtitleSegmentLoader_=new li(t.mergeOptions(f,{loaderType:"vtt"}),e),r.setupSegmentLoaderListeners_(),Ki.forEach(function(e){r[e+"_"]=Qi.bind(r,e)}),r.logger_=xt("MPC"),r.masterPlaylistLoader_.load(),r}return E(i,e),k(i,[{key:"setupMasterPlaylistLoaderListeners_",value:function(){var e=this;this.masterPlaylistLoader_.on("loadedmetadata",function(){var i=e.masterPlaylistLoader_.media(),r=1.5*e.masterPlaylistLoader_.targetDuration*1e3;K(e.masterPlaylistLoader_.master,e.masterPlaylistLoader_.media())?e.requestOptions_.timeout=0:e.requestOptions_.timeout=r,i.endList&&"none"!==e.tech_.preload()&&(e.mainSegmentLoader_.playlist(i,e.requestOptions_),e.mainSegmentLoader_.load()),Xi({sourceType:e.sourceType_,segmentLoaders:{AUDIO:e.audioSegmentLoader_,SUBTITLES:e.subtitleSegmentLoader_,main:e.mainSegmentLoader_},tech:e.tech_,requestOptions:e.requestOptions_,masterPlaylistLoader:e.masterPlaylistLoader_,hls:e.hls_,master:e.master(),mediaTypes:e.mediaTypes_,blacklistCurrentPlaylist:e.blacklistCurrentPlaylist.bind(e)}),e.triggerPresenceUsage_(e.master(),i);try{e.setupSourceBuffers_()}catch(i){return t.log.warn("Failed to create SourceBuffers",i),e.mediaSource.endOfStream("decode")}e.setupFirstPlay(),e.trigger("selectedinitialmedia")}),this.masterPlaylistLoader_.on("loadedplaylist",function(){var t=e.masterPlaylistLoader_.media();if(!t){e.excludeUnsupportedVariants_();var i=void 0;return e.enableLowInitialPlaylist&&(i=e.selectInitialPlaylist()),i||(i=e.selectPlaylist()),e.initialMedia_=i,void e.masterPlaylistLoader_.media(e.initialMedia_)}if(e.useCueTags_&&e.updateAdCues_(t),e.mainSegmentLoader_.playlist(t,e.requestOptions_),e.updateDuration(),e.tech_.paused()||e.mainSegmentLoader_.load(),!t.endList){var r=function(){var t=e.seekable();0!==t.length&&e.mediaSource.addSeekableRange_(t.start(0),t.end(0))};if(e.duration()!==1/0){e.tech_.one("durationchange",function t(){e.duration()===1/0?r():e.tech_.one("durationchange",t)})}else r()}}),this.masterPlaylistLoader_.on("error",function(){e.blacklistCurrentPlaylist(e.masterPlaylistLoader_.error)}),this.masterPlaylistLoader_.on("mediachanging",function(){e.mainSegmentLoader_.abort(),e.mainSegmentLoader_.pause()}),this.masterPlaylistLoader_.on("mediachange",function(){var t=e.masterPlaylistLoader_.media(),i=1.5*e.masterPlaylistLoader_.targetDuration*1e3;K(e.masterPlaylistLoader_.master,e.masterPlaylistLoader_.media())?e.requestOptions_.timeout=0:e.requestOptions_.timeout=i,e.mainSegmentLoader_.playlist(t,e.requestOptions_),e.mainSegmentLoader_.load(),e.tech_.trigger({type:"mediachange",bubbles:!0})}),this.masterPlaylistLoader_.on("playlistunchanged",function(){var t=e.masterPlaylistLoader_.media();e.stuckAtPlaylistEnd_(t)&&(e.blacklistCurrentPlaylist({message:"Playlist no longer updating."}),e.tech_.trigger("playliststuck"))}),this.masterPlaylistLoader_.on("renditiondisabled",function(){e.tech_.trigger({type:"usage",name:"hls-rendition-disabled"})}),this.masterPlaylistLoader_.on("renditionenabled",function(){e.tech_.trigger({type:"usage",name:"hls-rendition-enabled"})})}},{key:"triggerPresenceUsage_",value:function(e,t){var i=e.mediaGroups||{},r=!0,n=Object.keys(i.AUDIO);for(var a in i.AUDIO)for(var s in i.AUDIO[a]){i.AUDIO[a][s].uri||(r=!1)}r&&this.tech_.trigger({type:"usage",name:"hls-demuxed"}),Object.keys(i.SUBTITLES).length&&this.tech_.trigger({type:"usage",name:"hls-webvtt"}),$i.Playlist.isAes(t)&&this.tech_.trigger({type:"usage",name:"hls-aes"}),$i.Playlist.isFmp4(t)&&this.tech_.trigger({type:"usage",name:"hls-fmp4"}),n.length&&Object.keys(i.AUDIO[n[0]]).length>1&&this.tech_.trigger({type:"usage",name:"hls-alternate-audio"}),this.useCueTags_&&this.tech_.trigger({type:"usage",name:"hls-playlist-cue-tags"})}},{key:"setupSegmentLoaderListeners_",value:function(){var e=this;this.mainSegmentLoader_.on("bandwidthupdate",function(){var t=e.selectPlaylist(),i=e.masterPlaylistLoader_.media(),r=e.tech_.buffered(),n=r.length?r.end(r.length-1)-e.tech_.currentTime():0,a=e.bufferLowWaterLine();(!i.endList||e.duration()<Gt.MAX_BUFFER_LOW_WATER_LINE||t.attributes.BANDWIDTH<i.attributes.BANDWIDTH||n>=a)&&e.masterPlaylistLoader_.media(t),e.tech_.trigger("bandwidthupdate")}),this.mainSegmentLoader_.on("progress",function(){e.trigger("progress")}),this.mainSegmentLoader_.on("error",function(){e.blacklistCurrentPlaylist(e.mainSegmentLoader_.error())}),this.mainSegmentLoader_.on("syncinfoupdate",function(){e.onSyncInfoUpdate_()}),this.mainSegmentLoader_.on("timestampoffset",function(){e.tech_.trigger({type:"usage",name:"hls-timestamp-offset"})}),this.audioSegmentLoader_.on("syncinfoupdate",function(){e.onSyncInfoUpdate_()}),this.mainSegmentLoader_.on("ended",function(){e.onEndOfStream()}),this.mainSegmentLoader_.on("earlyabort",function(){e.blacklistCurrentPlaylist({message:"Aborted early because there isn't enough bandwidth to complete the request without rebuffering."},120)}),this.mainSegmentLoader_.on("reseteverything",function(){e.tech_.trigger("hls-reset")}),this.mainSegmentLoader_.on("segmenttimemapping",function(t){e.tech_.trigger({type:"hls-segment-time-mapping",mapping:t.mapping})}),this.audioSegmentLoader_.on("ended",function(){e.onEndOfStream()})}},{key:"mediaSecondsLoaded_",value:function(){return Math.max(this.audioSegmentLoader_.mediaSecondsLoaded+this.mainSegmentLoader_.mediaSecondsLoaded)}},{key:"load",value:function(){this.mainSegmentLoader_.load(),this.mediaTypes_.AUDIO.activePlaylistLoader&&this.audioSegmentLoader_.load(),this.mediaTypes_.SUBTITLES.activePlaylistLoader&&this.subtitleSegmentLoader_.load()}},{key:"fastQualityChange_",value:function(){var e=this.selectPlaylist();e!==this.masterPlaylistLoader_.media()&&(this.masterPlaylistLoader_.media(e),this.mainSegmentLoader_.resetLoader())}},{key:"play",value:function(){if(!this.setupFirstPlay()){this.tech_.ended()&&this.tech_.setCurrentTime(0),this.hasPlayed_()&&this.load();var e=this.tech_.seekable();return this.tech_.duration()===1/0&&this.tech_.currentTime()<e.start(0)?this.tech_.setCurrentTime(e.end(e.length-1)):void 0}}},{key:"setupFirstPlay",value:function(){var e=this,i=this.masterPlaylistLoader_.media();if(!i||this.tech_.paused()||this.hasPlayed_())return!1;if(!i.endList){var r=this.seekable();if(!r.length)return!1;if(t.browser.IE_VERSION&&0===this.tech_.readyState())return this.tech_.one("loadedmetadata",function(){e.trigger("firstplay"),e.tech_.setCurrentTime(r.end(0)),e.hasPlayed_=function(){return!0}}),!1;this.trigger("firstplay"),this.tech_.setCurrentTime(r.end(0))}return this.hasPlayed_=function(){return!0},this.load(),!0}},{key:"handleSourceOpen_",value:function(){try{this.setupSourceBuffers_()}catch(e){return t.log.warn("Failed to create Source Buffers",e),this.mediaSource.endOfStream("decode")}if(this.tech_.autoplay()){var e=this.tech_.play();"undefined"!=typeof e&&"function"==typeof e.then&&e.then(null,function(e){})}this.trigger("sourceopen")}},{key:"onEndOfStream",value:function(){var e=this.mainSegmentLoader_.ended_;this.mediaTypes_.AUDIO.activePlaylistLoader&&(e=!this.mainSegmentLoader_.startingMedia_||this.mainSegmentLoader_.startingMedia_.containsVideo?e&&this.audioSegmentLoader_.ended_:this.audioSegmentLoader_.ended_),e&&this.mediaSource.endOfStream()}},{key:"stuckAtPlaylistEnd_",value:function(e){if(!this.seekable().length)return!1;var t=this.syncController_.getExpiredTime(e,this.mediaSource.duration);if(null===t)return!1;var i=$i.Playlist.playlistEnd(e,t),r=this.tech_.currentTime(),n=this.tech_.buffered();if(!n.length)return i-r<=.1;var a=n.end(n.length-1);return a-r<=.1&&i-a<=.1}},{key:"blacklistCurrentPlaylist",value:function(){var e,i=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},r=arguments[1],n=void 0;if(n=i.playlist||this.masterPlaylistLoader_.media(),r=r||i.blacklistDuration||this.blacklistDuration,!n){this.error=i;try{return this.mediaSource.endOfStream("network")}catch(e){return this.trigger("error")}}var a=1===this.masterPlaylistLoader_.master.playlists.filter(Y).length;return a?(t.log.warn("Problem encountered with the current HLS playlist. Trying again since it is the final playlist."),this.tech_.trigger("retryplaylist"),this.masterPlaylistLoader_.load(a)):(n.excludeUntil=Date.now()+1e3*r,this.tech_.trigger("blacklistplaylist"),this.tech_.trigger({type:"usage",name:"hls-rendition-blacklisted"}),e=this.selectPlaylist(),t.log.warn("Problem encountered with the current HLS playlist."+(i.message?" "+i.message:"")+" Switching to another playlist."),this.masterPlaylistLoader_.media(e))}},{key:"pauseLoading",value:function(){this.mainSegmentLoader_.pause(),this.mediaTypes_.AUDIO.activePlaylistLoader&&this.audioSegmentLoader_.pause(),this.mediaTypes_.SUBTITLES.activePlaylistLoader&&this.subtitleSegmentLoader_.pause()}},{key:"setCurrentTime",value:function(e){var t=be(this.tech_.buffered(),e);return this.masterPlaylistLoader_&&this.masterPlaylistLoader_.media()&&this.masterPlaylistLoader_.media().segments?t&&t.length?e:(this.mainSegmentLoader_.resetEverything(),this.mainSegmentLoader_.abort(),this.mediaTypes_.AUDIO.activePlaylistLoader&&(this.audioSegmentLoader_.resetEverything(),this.audioSegmentLoader_.abort()),this.mediaTypes_.SUBTITLES.activePlaylistLoader&&(this.subtitleSegmentLoader_.resetEverything(),this.subtitleSegmentLoader_.abort()),void this.load()):0}},{key:"duration",value:function(){return this.masterPlaylistLoader_?this.mediaSource?this.mediaSource.duration:$i.Playlist.duration(this.masterPlaylistLoader_.media()):0}},{key:"seekable",value:function(){return this.seekable_}},{key:"onSyncInfoUpdate_",value:function(){var e=void 0,i=void 0;if(this.masterPlaylistLoader_){var r=this.masterPlaylistLoader_.media();if(r){var n=this.syncController_.getExpiredTime(r,this.mediaSource.duration);if(null!==n&&0!==(e=$i.Playlist.seekable(r,n)).length){if(this.mediaTypes_.AUDIO.activePlaylistLoader){if(r=this.mediaTypes_.AUDIO.activePlaylistLoader.media(),null===(n=this.syncController_.getExpiredTime(r,this.mediaSource.duration)))return;if(0===(i=$i.Playlist.seekable(r,n)).length)return}i?i.start(0)>e.end(0)||e.start(0)>i.end(0)?this.seekable_=e:this.seekable_=t.createTimeRanges([[i.start(0)>e.start(0)?i.start(0):e.start(0),i.end(0)<e.end(0)?i.end(0):e.end(0)]]):this.seekable_=e,this.logger_("seekable updated ["+Se(this.seekable_)+"]"),this.tech_.trigger("seekablechanged")}}}}},{key:"updateDuration",value:function(){var e=this,t=this.mediaSource.duration,i=$i.Playlist.duration(this.masterPlaylistLoader_.media()),r=this.tech_.buffered(),n=function t(){e.mediaSource.duration=i,e.tech_.trigger("durationchange"),e.mediaSource.removeEventListener("sourceopen",t)};r.length>0&&(i=Math.max(i,r.end(r.length-1))),t!==i&&("open"!==this.mediaSource.readyState?this.mediaSource.addEventListener("sourceopen",n):n())}},{key:"dispose",value:function(){var e=this;this.decrypter_.terminate(),this.masterPlaylistLoader_.dispose(),this.mainSegmentLoader_.dispose(),["AUDIO","SUBTITLES"].forEach(function(t){var i=e.mediaTypes_[t].groups;for(var r in i)i[r].forEach(function(e){e.playlistLoader&&e.playlistLoader.dispose()})}),this.audioSegmentLoader_.dispose(),this.subtitleSegmentLoader_.dispose()}},{key:"master",value:function(){return this.masterPlaylistLoader_.master}},{key:"media",value:function(){return this.masterPlaylistLoader_.media()||this.initialMedia_}},{key:"setupSourceBuffers_",value:function(){var e,t=this.masterPlaylistLoader_.media();if(t&&"open"===this.mediaSource.readyState){if((e=ti(this.masterPlaylistLoader_.master,t)).length<1)return this.error="No compatible SourceBuffer configuration for the variant stream:"+t.resolvedUri,this.mediaSource.endOfStream("decode");this.configureLoaderMimeTypes_(e),this.excludeIncompatibleVariants_(t)}}},{key:"configureLoaderMimeTypes_",value:function(e){var i=e.length>1&&-1===e[0].indexOf(",")&&e[0]!==e[1]?new t.EventTarget:null;this.mainSegmentLoader_.mimeType(e[0],i),e[1]&&this.audioSegmentLoader_.mimeType(e[1],i)}},{key:"excludeUnsupportedVariants_",value:function(){this.master().playlists.forEach(function(e){var t;e.attributes.CODECS&&c.MediaSource&&c.MediaSource.isTypeSupported&&!c.MediaSource.isTypeSupported('video/mp4; codecs="'+(t=e.attributes.CODECS,t.replace(/avc1\.(\d+)\.(\d+)/i,function(e){return He([e])[0]}))+'"')&&(e.excludeUntil=1/0)})}},{key:"excludeIncompatibleVariants_",value:function(e){var t=2,i=null,r=void 0;e.attributes.CODECS&&(r=Zt(e.attributes.CODECS),i=r.videoCodec,t=r.codecCount),this.master().playlists.forEach(function(e){var r={codecCount:2,videoCodec:null};e.attributes.CODECS&&(r=Zt(e.attributes.CODECS)),r.codecCount!==t&&(e.excludeUntil=1/0),r.videoCodec!==i&&(e.excludeUntil=1/0)})}},{key:"updateAdCues_",value:function(e){var t=0,i=this.seekable();i.length&&(t=i.start(0)),function(e,t){var i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0;if(e.segments)for(var r=i,n=void 0,a=0;a<e.segments.length;a++){var s=e.segments[a];if(n||(n=ci(t,r+s.duration/2)),n){if("cueIn"in s){n.endTime=r,n.adEndTime=r,r+=s.duration,n=null;continue}if(r<n.endTime){r+=s.duration;continue}n.endTime+=s.duration}else if("cueOut"in s&&((n=new c.VTTCue(r,r+s.duration,s.cueOut)).adStartTime=r,n.adEndTime=r+parseFloat(s.cueOut),t.addCue(n)),"cueOutCont"in s){var o,u,d=s.cueOutCont.split("/").map(parseFloat),l=A(d,2);o=l[0],u=l[1],(n=new c.VTTCue(r,r+s.duration,"")).adStartTime=r-o,n.adEndTime=n.adStartTime+u,t.addCue(n)}r+=s.duration}}(e,this.cueTagsTrack_,t)}},{key:"goalBufferLength",value:function(){var e=this.tech_.currentTime(),t=Gt.GOAL_BUFFER_LENGTH,i=Gt.GOAL_BUFFER_LENGTH_RATE,r=Math.max(t,Gt.MAX_GOAL_BUFFER_LENGTH);return Math.min(t+e*i,r)}},{key:"bufferLowWaterLine",value:function(){var e=this.tech_.currentTime(),t=Gt.BUFFER_LOW_WATER_LINE,i=Gt.BUFFER_LOW_WATER_LINE_RATE,r=Math.max(t,Gt.MAX_BUFFER_LOW_WATER_LINE);return Math.min(t+e*i,r)}}]),i}(t.EventTarget),Zi=function e(t,i,r){S(this,e);var n,a,s,o=t.masterPlaylistController_.fastQualityChange_.bind(t.masterPlaylistController_);if(i.attributes.RESOLUTION){var u=i.attributes.RESOLUTION;this.width=u.width,this.height=u.height}this.bandwidth=i.attributes.BANDWIDTH,this.id=r,this.enabled=(n=t.playlists,a=i.uri,s=o,function(e){var t=n.master.playlists[a],i=X(t),r=Y(t);return"undefined"==typeof e?r:(e?delete t.disabled:t.disabled=!0,e===r||i||(s(),e?n.trigger("renditionenabled"):n.trigger("renditiondisabled")),e)})},er=["seeking","seeked","pause","playing","error"],tr=function(){function e(t){var i=this;S(this,e),this.tech_=t.tech,this.seekable=t.seekable,this.consecutiveUpdates=0,this.lastRecordedTime=null,this.timer_=null,this.checkCurrentTimeTimeout_=null,this.logger_=xt("PlaybackWatcher"),this.logger_("initialize");var r=function(){return i.monitorCurrentTime_()},n=function(){return i.techWaiting_()},a=function(){return i.cancelTimer_()},s=function(){return i.fixesBadSeeks_()};this.tech_.on("seekablechanged",s),this.tech_.on("waiting",n),this.tech_.on(er,a),this.tech_.on("canplay",r),this.dispose=function(){i.logger_("dispose"),i.tech_.off("seekablechanged",s),i.tech_.off("waiting",n),i.tech_.off(er,a),i.tech_.off("canplay",r),i.checkCurrentTimeTimeout_&&c.clearTimeout(i.checkCurrentTimeTimeout_),i.cancelTimer_()}}return k(e,[{key:"monitorCurrentTime_",value:function(){this.checkCurrentTime_(),this.checkCurrentTimeTimeout_&&c.clearTimeout(this.checkCurrentTimeTimeout_),this.checkCurrentTimeTimeout_=c.setTimeout(this.monitorCurrentTime_.bind(this),250)}},{key:"checkCurrentTime_",value:function(){if(this.tech_.seeking()&&this.fixesBadSeeks_())return this.consecutiveUpdates=0,void(this.lastRecordedTime=this.tech_.currentTime());if(!this.tech_.paused()&&!this.tech_.seeking()){var e=this.tech_.currentTime(),t=this.tech_.buffered();if(this.lastRecordedTime===e&&(!t.length||e+.1>=t.end(t.length-1)))return this.techWaiting_();this.consecutiveUpdates>=5&&e===this.lastRecordedTime?(this.consecutiveUpdates++,this.waiting_()):e===this.lastRecordedTime?this.consecutiveUpdates++:(this.consecutiveUpdates=0,this.lastRecordedTime=e)}}},{key:"cancelTimer_",value:function(){this.consecutiveUpdates=0,this.timer_&&(this.logger_("cancelTimer_"),clearTimeout(this.timer_)),this.timer_=null}},{key:"fixesBadSeeks_",value:function(){var e=this.tech_.seeking(),t=this.seekable(),i=this.tech_.currentTime(),r=void 0;e&&this.afterSeekableWindow_(t,i)&&(r=t.end(t.length-1));e&&this.beforeSeekableWindow_(t,i)&&(r=t.start(0)+.1);return"undefined"!=typeof r&&(this.logger_("Trying to seek outside of seekable at time "+i+" with seekable range "+Se(t)+". Seeking to "+r+"."),this.tech_.setCurrentTime(r),!0)}},{key:"waiting_",value:function(){if(!this.techWaiting_()){var e=this.tech_.currentTime(),t=this.tech_.buffered(),i=be(t,e);return i.length&&e+3<=i.end(0)?(this.cancelTimer_(),this.tech_.setCurrentTime(e),this.logger_("Stopped at "+e+" while inside a buffered region ["+i.start(0)+" -> "+i.end(0)+"]. Attempting to resume playback by seeking to the current time."),void this.tech_.trigger({type:"usage",name:"hls-unknown-waiting"})):void 0}}},{key:"techWaiting_",value:function(){var e=this.seekable(),t=this.tech_.currentTime();if(this.tech_.seeking()&&this.fixesBadSeeks_())return!0;if(this.tech_.seeking()||null!==this.timer_)return!0;if(this.beforeSeekableWindow_(e,t)){var i=e.end(e.length-1);return this.logger_("Fell out of live window at time "+t+". Seeking to live point (seekable end) "+i),this.cancelTimer_(),this.tech_.setCurrentTime(i),this.tech_.trigger({type:"usage",name:"hls-live-resync"}),!0}var r=this.tech_.buffered(),n=Te(r,t);if(this.videoUnderflow_(n,r,t))return this.cancelTimer_(),this.tech_.setCurrentTime(t),this.tech_.trigger({type:"usage",name:"hls-video-underflow"}),!0;if(n.length>0){var a=n.start(0)-t;return this.logger_("Stopped at "+t+", setting timer for "+a+", seeking to "+n.start(0)),this.timer_=setTimeout(this.skipTheGap_.bind(this),1e3*a,t),!0}return!1}},{key:"afterSeekableWindow_",value:function(e,t){return!!e.length&&t>e.end(e.length-1)+.1}},{key:"beforeSeekableWindow_",value:function(e,t){return!!(e.length&&e.start(0)>0&&t<e.start(0)-.1)}},{key:"videoUnderflow_",value:function(e,t,i){if(0===e.length){var r=this.gapFromVideoUnderflow_(t,i);if(r)return this.logger_("Encountered a gap in video from "+r.start+" to "+r.end+". Seeking to current time "+i),!0}return!1}},{key:"skipTheGap_",value:function(e){var t=this.tech_.buffered(),i=this.tech_.currentTime(),r=Te(t,i);this.cancelTimer_(),0!==r.length&&i===e&&(this.logger_("skipTheGap_:","currentTime:",i,"scheduled currentTime:",e,"nextRange start:",r.start(0)),this.tech_.setCurrentTime(r.start(0)+1/30),this.tech_.trigger({type:"usage",name:"hls-gap-skip"}))}},{key:"gapFromVideoUnderflow_",value:function(e,i){for(var r=function(e){if(e.length<2)return t.createTimeRanges();for(var i=[],r=1;r<e.length;r++){var n=e.end(r-1),a=e.start(r);i.push([n,a])}return t.createTimeRanges(i)}(e),n=0;n<r.length;n++){var a=r.start(n),s=r.end(n);if(i-a<4&&i-a>2)return{start:a,end:s}}return null}}]),e}(),ir={errorInterval:30,getSource:function(e){return e(this.tech({IWillNotUseThisInPlugins:!0}).currentSource_)}},rr=function(e){!function e(i,r){var n=0,a=0,s=t.mergeOptions(ir,r);i.ready(function(){i.trigger({type:"usage",name:"hls-error-reload-initialized"})});var o=function(){a&&i.currentTime(a)},u=function(e){null!==e&&void 0!==e&&(a=i.duration()!==1/0&&i.currentTime()||0,i.one("loadedmetadata",o),i.src(e),i.trigger({type:"usage",name:"hls-error-reload"}),i.play())},d=function(){if(Date.now()-n<1e3*s.errorInterval)i.trigger({type:"usage",name:"hls-error-reload-canceled"});else{if(s.getSource&&"function"==typeof s.getSource)return n=Date.now(),s.getSource.call(i,u);t.log.error("ERROR: reloadSourceOnError - The option getSource must be a function!")}},l=function e(){i.off("loadedmetadata",o),i.off("error",d),i.off("dispose",e)};i.on("error",d),i.on("dispose",l),i.reloadSourceOnError=function(t){l(),e(i,t)}}(this,e)},nr={PlaylistLoader:B,Playlist:Q,Decrypter:ce,AsyncStream:ue,decrypt:le,utils:_e,STANDARD_PLAYLIST_SELECTOR:function(){return function(e,t,i,r){var n=e.playlists.map(function(e){var t,i;return t=e.attributes.RESOLUTION&&e.attributes.RESOLUTION.width,i=e.attributes.RESOLUTION&&e.attributes.RESOLUTION.height,{bandwidth:e.attributes.BANDWIDTH||c.Number.MAX_VALUE,width:t,height:i,playlist:e}});ri(n,function(e,t){return e.bandwidth-t.bandwidth});var a=(n=n.filter(function(e){return!Q.isIncompatible(e.playlist)})).filter(function(e){return Q.isEnabled(e.playlist)});a.length||(a=n.filter(function(e){return!Q.isDisabled(e.playlist)}));var s=a.filter(function(e){return e.bandwidth*Gt.BANDWIDTH_VARIANCE<t}),o=s[s.length-1],u=s.filter(function(e){return e.bandwidth===o.bandwidth})[0],d=s.filter(function(e){return e.width&&e.height});ri(d,function(e,t){return e.width-t.width});var l=d.filter(function(e){return e.width===i&&e.height===r});o=l[l.length-1];var h=l.filter(function(e){return e.bandwidth===o.bandwidth})[0],f=void 0,p=void 0,m=void 0;h||(p=(f=d.filter(function(e){return e.width>i||e.height>r})).filter(function(e){return e.width===f[0].width&&e.height===f[0].height}),o=p[p.length-1],m=p.filter(function(e){return e.bandwidth===o.bandwidth})[0]);var g=m||h||u||a[0]||n[0];return g?g.playlist:null}(this.playlists.master,this.systemBandwidth,parseInt(ii(this.tech_.el(),"width"),10),parseInt(ii(this.tech_.el(),"height"),10))},INITIAL_PLAYLIST_SELECTOR:function(){var e=this.playlists.master.playlists.filter(Q.isEnabled);return ri(e,function(e,t){return ni(e,t)}),e.filter(function(e){return Zt(e.attributes.CODECS).videoCodec})[0]||null},comparePlaylistBandwidth:ni,comparePlaylistResolution:function(e,t){var i=void 0,r=void 0;return e.attributes.RESOLUTION&&e.attributes.RESOLUTION.width&&(i=e.attributes.RESOLUTION.width),i=i||c.Number.MAX_VALUE,t.attributes.RESOLUTION&&t.attributes.RESOLUTION.width&&(r=t.attributes.RESOLUTION.width),i===(r=r||c.Number.MAX_VALUE)&&e.attributes.BANDWIDTH&&t.attributes.BANDWIDTH?e.attributes.BANDWIDTH-t.attributes.BANDWIDTH:i-r},xhr:ee()};["GOAL_BUFFER_LENGTH","MAX_GOAL_BUFFER_LENGTH","GOAL_BUFFER_LENGTH_RATE","BUFFER_LOW_WATER_LINE","MAX_BUFFER_LOW_WATER_LINE","BUFFER_LOW_WATER_LINE_RATE","BANDWIDTH_VARIANCE"].forEach(function(e){Object.defineProperty(nr,e,{get:function(){return t.log.warn("using Hls."+e+" is UNSAFE be sure you know what you are doing"),Gt[e]},set:function(i){t.log.warn("using Hls."+e+" is UNSAFE be sure you know what you are doing"),"number"!=typeof i||i<0?t.log.warn("value of Hls."+e+" must be greater than or equal to 0"):Gt[e]=i}})});var ar=function(e){if(/^(audio|video|application)\/(x-|vnd\.apple\.)?mpegurl/i.test(e))return"hls";return/^application\/dash\+xml/i.test(e)?"dash":null},sr=function(e,t){for(var i=t.media(),r=-1,n=0;n<e.length;n++)if(e[n].id===i.uri){r=n;break}e.selectedIndex_=r,e.trigger({selectedIndex:r,type:"change"})};nr.canPlaySource=function(){return t.log.warn("HLS is no longer a tech. Please remove it from your player's techOrder.")};var or=function(e,i,r){if(!e)return e;var n={};for(var a in e)n[a]={audioContentType:'audio/mp4; codecs="'+r.attributes.CODECS+'"',videoContentType:'video/mp4; codecs="'+i.attributes.CODECS+'"'},i.contentProtection&&i.contentProtection[a]&&i.contentProtection[a].pssh&&(n[a].pssh=i.contentProtection[a].pssh),"string"==typeof e[a]&&(n[a].url=e[a]);return t.mergeOptions(e,n)};nr.supportsNativeHls=function(){var e=d.createElement("video");if(!t.getTech("Html5").isSupported())return!1;return["application/vnd.apple.mpegurl","audio/mpegurl","audio/x-mpegurl","application/x-mpegurl","video/x-mpegurl","video/mpegurl","application/mpegurl"].some(function(t){return/maybe|probably/i.test(e.canPlayType(t))})}(),nr.supportsNativeDash=!!t.getTech("Html5").isSupported()&&/maybe|probably/i.test(d.createElement("video").canPlayType("application/dash+xml")),nr.supportsTypeNatively=function(e){return"hls"===e?nr.supportsNativeHls:"dash"===e&&nr.supportsNativeDash},nr.isSupported=function(){return t.log.warn("HLS is no longer a tech. Please remove it from your player's techOrder.")};var ur=t.getComponent("Component"),dr=function(e){function i(e,r,n){S(this,i);var a=L(this,(i.__proto__||Object.getPrototypeOf(i)).call(this,r,n.hls));if(r.options_&&r.options_.playerId){var s=t(r.options_.playerId);s.hasOwnProperty("hls")||Object.defineProperty(s,"hls",{get:function(){return t.log.warn("player.hls is deprecated. Use player.tech_.hls instead."),r.trigger({type:"usage",name:"hls-player-access"}),a}}),s.vhs=a,s.dash=a}if(a.tech_=r,a.source_=e,a.stats={},a.ignoreNextSeekingEvent_=!1,a.setOptions_(),a.options_.overrideNative&&r.overrideNativeAudioTracks&&r.overrideNativeVideoTracks)r.overrideNativeAudioTracks(!0),r.overrideNativeVideoTracks(!0);else if(a.options_.overrideNative&&(r.featuresNativeVideoTracks||r.featuresNativeAudioTracks))throw new Error("Overriding native HLS requires emulated tracks. See https://git.io/vMpjB");return a.on(d,["fullscreenchange","webkitfullscreenchange","mozfullscreenchange","MSFullscreenChange"],function(e){var t=d.fullscreenElement||d.webkitFullscreenElement||d.mozFullScreenElement||d.msFullscreenElement;t&&t.contains(a.tech_.el())&&a.masterPlaylistController_.fastQualityChange_()}),a.on(a.tech_,"seeking",function(){this.ignoreNextSeekingEvent_?this.ignoreNextSeekingEvent_=!1:this.setCurrentTime(this.tech_.currentTime())}),a.on(a.tech_,"error",function(){this.masterPlaylistController_&&this.masterPlaylistController_.pauseLoading()}),a.on(a.tech_,"play",a.play),a}return E(i,ur),k(i,[{key:"setOptions_",value:function(){var e=this;this.options_.withCredentials=this.options_.withCredentials||!1,"number"!=typeof this.options_.blacklistDuration&&(this.options_.blacklistDuration=300),"number"!=typeof this.options_.bandwidth&&(this.options_.bandwidth=4194304),this.options_.enableLowInitialPlaylist=this.options_.enableLowInitialPlaylist&&4194304===this.options_.bandwidth,["withCredentials","bandwidth"].forEach(function(t){"undefined"!=typeof e.source_[t]&&(e.options_[t]=e.source_[t])}),this.bandwidth=this.options_.bandwidth}},{key:"src",value:function(e,i){var r=this;e&&(this.setOptions_(),this.options_.url=this.source_.src,this.options_.tech=this.tech_,this.options_.externHls=nr,this.options_.sourceType=ar(i),this.masterPlaylistController_=new Ji(this.options_),this.playbackWatcher_=new tr(t.mergeOptions(this.options_,{seekable:function(){return r.seekable()}})),this.masterPlaylistController_.on("error",function(){t.players[r.tech_.options_.playerId].error(r.masterPlaylistController_.error)}),this.masterPlaylistController_.selectPlaylist=this.selectPlaylist?this.selectPlaylist.bind(this):nr.STANDARD_PLAYLIST_SELECTOR.bind(this),this.masterPlaylistController_.selectInitialPlaylist=nr.INITIAL_PLAYLIST_SELECTOR.bind(this),this.playlists=this.masterPlaylistController_.masterPlaylistLoader_,this.mediaSource=this.masterPlaylistController_.mediaSource,Object.defineProperties(this,{selectPlaylist:{get:function(){return this.masterPlaylistController_.selectPlaylist},set:function(e){this.masterPlaylistController_.selectPlaylist=e.bind(this)}},throughput:{get:function(){return this.masterPlaylistController_.mainSegmentLoader_.throughput.rate},set:function(e){this.masterPlaylistController_.mainSegmentLoader_.throughput.rate=e,this.masterPlaylistController_.mainSegmentLoader_.throughput.count=1}},bandwidth:{get:function(){return this.masterPlaylistController_.mainSegmentLoader_.bandwidth},set:function(e){this.masterPlaylistController_.mainSegmentLoader_.bandwidth=e,this.masterPlaylistController_.mainSegmentLoader_.throughput={rate:0,count:0}}},systemBandwidth:{get:function(){var e=1/(this.bandwidth||1),t=void 0;return t=this.throughput>0?1/this.throughput:0,Math.floor(1/(e+t))},set:function(){t.log.error('The "systemBandwidth" property is read-only')}}}),Object.defineProperties(this.stats,{bandwidth:{get:function(){return r.bandwidth||0},enumerable:!0},mediaRequests:{get:function(){return r.masterPlaylistController_.mediaRequests_()||0},enumerable:!0},mediaRequestsAborted:{get:function(){return r.masterPlaylistController_.mediaRequestsAborted_()||0},enumerable:!0},mediaRequestsTimedout:{get:function(){return r.masterPlaylistController_.mediaRequestsTimedout_()||0},enumerable:!0},mediaRequestsErrored:{get:function(){return r.masterPlaylistController_.mediaRequestsErrored_()||0},enumerable:!0},mediaTransferDuration:{get:function(){return r.masterPlaylistController_.mediaTransferDuration_()||0},enumerable:!0},mediaBytesTransferred:{get:function(){return r.masterPlaylistController_.mediaBytesTransferred_()||0},enumerable:!0},mediaSecondsLoaded:{get:function(){return r.masterPlaylistController_.mediaSecondsLoaded_()||0},enumerable:!0},buffered:{get:function(){return ke(r.tech_.buffered())},enumerable:!0},currentTime:{get:function(){return r.tech_.currentTime()},enumerable:!0},currentSource:{get:function(){return r.tech_.currentSource_},enumerable:!0},currentTech:{get:function(){return r.tech_.name_},enumerable:!0},duration:{get:function(){return r.tech_.duration()},enumerable:!0},master:{get:function(){return r.playlists.master},enumerable:!0},playerDimensions:{get:function(){return r.tech_.currentDimensions()},enumerable:!0},seekable:{get:function(){return ke(r.tech_.seekable())},enumerable:!0},timestamp:{get:function(){return Date.now()},enumerable:!0},videoPlaybackQuality:{get:function(){return r.tech_.getVideoPlaybackQuality()},enumerable:!0}}),this.tech_.one("canplay",this.masterPlaylistController_.setupFirstPlay.bind(this.masterPlaylistController_)),this.masterPlaylistController_.on("selectedinitialmedia",function(){var e,i;i=(e=r).playlists,e.representations=function(){return i.master.playlists.filter(function(e){return!X(e)}).map(function(t,i){return new Zi(e,t,t.uri)})},function(e){if("dash"===e.options_.sourceType){var i=t.players[e.tech_.options_.playerId];if(i.eme){var r=or(e.source_.keySystems,e.playlists.media(),e.masterPlaylistController_.mediaTypes_.AUDIO.activePlaylistLoader.media());r&&(i.currentSource().keySystems=r)}}}(r)}),this.on(this.masterPlaylistController_,"progress",function(){this.tech_.trigger("progress")}),this.on(this.masterPlaylistController_,"firstplay",function(){this.ignoreNextSeekingEvent_=!0}),this.tech_.ready(function(){return r.setupQualityLevels_()}),this.tech_.el()&&this.tech_.src(t.URL.createObjectURL(this.masterPlaylistController_.mediaSource)))}},{key:"setupQualityLevels_",value:function(){var e=this,i=t.players[this.tech_.options_.playerId];i&&i.qualityLevels&&(this.qualityLevels_=i.qualityLevels(),this.masterPlaylistController_.on("selectedinitialmedia",function(){var t,i;t=e.qualityLevels_,(i=e).representations().forEach(function(e){t.addQualityLevel(e)}),sr(t,i.playlists)}),this.playlists.on("mediachange",function(){sr(e.qualityLevels_,e.playlists)}))}},{key:"play",value:function(){this.masterPlaylistController_.play()}},{key:"setCurrentTime",value:function(e){this.masterPlaylistController_.setCurrentTime(e)}},{key:"duration",value:function(){return this.masterPlaylistController_.duration()}},{key:"seekable",value:function(){return this.masterPlaylistController_.seekable()}},{key:"dispose",value:function(){this.playbackWatcher_&&this.playbackWatcher_.dispose(),this.masterPlaylistController_&&this.masterPlaylistController_.dispose(),this.qualityLevels_&&this.qualityLevels_.dispose(),function e(t,i,r){null===t&&(t=Function.prototype);var n=Object.getOwnPropertyDescriptor(t,i);if(void 0===n){var a=Object.getPrototypeOf(t);return null===a?void 0:e(a,i,r)}if("value"in n)return n.value;var s=n.get;return void 0!==s?s.call(r):void 0}(i.prototype.__proto__||Object.getPrototypeOf(i.prototype),"dispose",this).call(this)}}]),i}(),lr={name:"videojs-http-streaming",VERSION:"1.1.0",canHandleSource:function(e){var i=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=t.mergeOptions(t.options,i);return lr.canPlayType(e.type,r)},handleSource:function(e,i){var r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},n=t.mergeOptions(t.options,r);return i.hls=new dr(e,i,n),i.hls.xhr=ee(),i.hls.src(e.src,e.type),i.hls},canPlayType:function(e){var i=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=t.mergeOptions(t.options,i).hls.overrideNative,n=ar(e);return n&&(!nr.supportsTypeNatively(n)||r)?"maybe":""}};"undefined"!=typeof t.MediaSource&&"undefined"!=typeof t.URL||(t.MediaSource=Xe,t.URL=Ye),Xe.supportsNativeMediaSources()&&t.getTech("Html5").registerSourceHandler(lr,0),t.HlsHandler=dr,t.HlsSourceHandler=lr,t.Hls=nr,t.use||t.registerComponent("Hls",nr),t.options.hls=t.options.hls||{},t.registerPlugin?t.registerPlugin("reloadSourceOnError",rr):t.plugin("reloadSourceOnError",rr),e.Hls=nr,e.HlsHandler=dr,e.HlsSourceHandler=lr,e.emeKeySystems=or,e.simpleTypeFromSourceType=ar,Object.defineProperty(e,"__esModule",{value:!0})});
