/**
 * @videojs/http-streaming
 * @version 1.8.0
 * @copyright 2019 Brightcove, Inc
 * @license Apache-2.0
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("video.js")):"function"==typeof define&&define.amd?define(["exports","video.js"],e):e(t.videojsHttpStreaming={},t.videojs)}(this,function(t,e){"use strict";e=e&&e.hasOwnProperty("default")?e.default:e;var i="undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};var n,r={},a=Object.freeze({default:r}),s=a&&r||a,o=void 0!==i?i:"undefined"!=typeof window?window:{};"undefined"!=typeof document?n=document:(n=o["__GLOBAL_DOCUMENT_CACHE@4"])||(n=o["__GLOBAL_DOCUMENT_CACHE@4"]=s);var u,d=n,l=(function(t,e){var i,n,r,a,s;i=/^((?:[a-zA-Z0-9+\-.]+:)?)(\/\/[^\/\;?#]*)?(.*?)??(;.*?)?(\?.*?)?(#.*?)?$/,n=/^([^\/;?#]*)(.*)$/,r=/(?:\/|^)\.(?=\/)/g,a=/(?:\/|^)\.\.\/(?!\.\.\/).*?(?=\/)/g,s={buildAbsoluteURL:function(t,e,i){if(i=i||{},t=t.trim(),!(e=e.trim())){if(!i.alwaysNormalize)return t;var r=this.parseURL(t);if(!r)throw new Error("Error trying to parse base URL.");return r.path=s.normalizePath(r.path),s.buildURLFromParts(r)}var a=this.parseURL(e);if(!a)throw new Error("Error trying to parse relative URL.");if(a.scheme)return i.alwaysNormalize?(a.path=s.normalizePath(a.path),s.buildURLFromParts(a)):e;var o=this.parseURL(t);if(!o)throw new Error("Error trying to parse base URL.");if(!o.netLoc&&o.path&&"/"!==o.path[0]){var u=n.exec(o.path);o.netLoc=u[1],o.path=u[2]}o.netLoc&&!o.path&&(o.path="/");var d={scheme:o.scheme,netLoc:a.netLoc,path:null,params:a.params,query:a.query,fragment:a.fragment};if(!a.netLoc&&(d.netLoc=o.netLoc,"/"!==a.path[0]))if(a.path){var l=o.path,c=l.substring(0,l.lastIndexOf("/")+1)+a.path;d.path=s.normalizePath(c)}else d.path=o.path,a.params||(d.params=o.params,a.query||(d.query=o.query));return null===d.path&&(d.path=i.alwaysNormalize?s.normalizePath(a.path):a.path),s.buildURLFromParts(d)},parseURL:function(t){var e=i.exec(t);return e?{scheme:e[1]||"",netLoc:e[2]||"",path:e[3]||"",params:e[4]||"",query:e[5]||"",fragment:e[6]||""}:null},normalizePath:function(t){for(t=t.split("").reverse().join("").replace(r,"");t.length!==(t=t.replace(a,"")).length;);return t.split("").reverse().join("")},buildURLFromParts:function(t){return t.scheme+t.netLoc+t.path+t.params+t.query+t.fragment}},t.exports=s}(u={exports:{}},u.exports),u.exports),c="undefined"!=typeof window?window:void 0!==i?i:"undefined"!=typeof self?self:{},h=function(t,e){return/^[a-z]+:/i.test(e)?e:(/\/\//i.test(t)||(t=l.buildAbsoluteURL(c.location.href,t)),l.buildAbsoluteURL(t,e))};
/*! @name m3u8-parser @version 4.3.0 @license Apache-2.0 */
function f(){return(f=Object.assign||function(t){for(var e=1;e<arguments.length;e++){var i=arguments[e];for(var n in i)Object.prototype.hasOwnProperty.call(i,n)&&(t[n]=i[n])}return t}).apply(this,arguments)}function p(t,e){t.prototype=Object.create(e.prototype),t.prototype.constructor=t,t.__proto__=e}function m(t){if(void 0===t)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return t}var g=function(){function t(){this.listeners={}}var e=t.prototype;return e.on=function(t,e){this.listeners[t]||(this.listeners[t]=[]),this.listeners[t].push(e)},e.off=function(t,e){if(!this.listeners[t])return!1;var i=this.listeners[t].indexOf(e);return this.listeners[t].splice(i,1),i>-1},e.trigger=function(t){var e,i,n,r=this.listeners[t];if(r)if(2===arguments.length)for(i=r.length,e=0;e<i;++e)r[e].call(this,arguments[1]);else for(n=Array.prototype.slice.call(arguments,1),i=r.length,e=0;e<i;++e)r[e].apply(this,n)},e.dispose=function(){this.listeners={}},e.pipe=function(t){this.on("data",function(e){t.push(e)})},t}(),y=function(t){function e(){var e;return(e=t.call(this)||this).buffer="",e}return p(e,t),e.prototype.push=function(t){var e;for(this.buffer+=t,e=this.buffer.indexOf("\n");e>-1;e=this.buffer.indexOf("\n"))this.trigger("data",this.buffer.substring(0,e)),this.buffer=this.buffer.substring(e+1)},e}(g),_=function(t){for(var e,i=t.split(new RegExp('(?:^|,)((?:[^=]*)=(?:"[^"]*"|[^,]*))')),n={},r=i.length;r--;)""!==i[r]&&((e=/([^=]*)=(.*)/.exec(i[r]).slice(1))[0]=e[0].replace(/^\s+|\s+$/g,""),e[1]=e[1].replace(/^\s+|\s+$/g,""),e[1]=e[1].replace(/^['"](.*)['"]$/g,"$1"),n[e[0]]=e[1]);return n},v=function(t){function e(){var e;return(e=t.call(this)||this).customParsers=[],e.tagMappers=[],e}p(e,t);var i=e.prototype;return i.push=function(t){var e,i,n=this;0!==(t=t.trim()).length&&("#"===t[0]?this.tagMappers.reduce(function(e,i){var n=i(t);return n===t?e:e.concat([n])},[t]).forEach(function(t){for(var r=0;r<n.customParsers.length;r++)if(n.customParsers[r].call(n,t))return;if(0===t.indexOf("#EXT"))if(t=t.replace("\r",""),e=/^#EXTM3U/.exec(t))n.trigger("data",{type:"tag",tagType:"m3u"});else{if(e=/^#EXTINF:?([0-9\.]*)?,?(.*)?$/.exec(t))return i={type:"tag",tagType:"inf"},e[1]&&(i.duration=parseFloat(e[1])),e[2]&&(i.title=e[2]),void n.trigger("data",i);if(e=/^#EXT-X-TARGETDURATION:?([0-9.]*)?/.exec(t))return i={type:"tag",tagType:"targetduration"},e[1]&&(i.duration=parseInt(e[1],10)),void n.trigger("data",i);if(e=/^#ZEN-TOTAL-DURATION:?([0-9.]*)?/.exec(t))return i={type:"tag",tagType:"totalduration"},e[1]&&(i.duration=parseInt(e[1],10)),void n.trigger("data",i);if(e=/^#EXT-X-VERSION:?([0-9.]*)?/.exec(t))return i={type:"tag",tagType:"version"},e[1]&&(i.version=parseInt(e[1],10)),void n.trigger("data",i);if(e=/^#EXT-X-MEDIA-SEQUENCE:?(\-?[0-9.]*)?/.exec(t))return i={type:"tag",tagType:"media-sequence"},e[1]&&(i.number=parseInt(e[1],10)),void n.trigger("data",i);if(e=/^#EXT-X-DISCONTINUITY-SEQUENCE:?(\-?[0-9.]*)?/.exec(t))return i={type:"tag",tagType:"discontinuity-sequence"},e[1]&&(i.number=parseInt(e[1],10)),void n.trigger("data",i);if(e=/^#EXT-X-PLAYLIST-TYPE:?(.*)?$/.exec(t))return i={type:"tag",tagType:"playlist-type"},e[1]&&(i.playlistType=e[1]),void n.trigger("data",i);if(e=/^#EXT-X-BYTERANGE:?([0-9.]*)?@?([0-9.]*)?/.exec(t))return i={type:"tag",tagType:"byterange"},e[1]&&(i.length=parseInt(e[1],10)),e[2]&&(i.offset=parseInt(e[2],10)),void n.trigger("data",i);if(e=/^#EXT-X-ALLOW-CACHE:?(YES|NO)?/.exec(t))return i={type:"tag",tagType:"allow-cache"},e[1]&&(i.allowed=!/NO/.test(e[1])),void n.trigger("data",i);if(e=/^#EXT-X-MAP:?(.*)$/.exec(t)){if(i={type:"tag",tagType:"map"},e[1]){var a=_(e[1]);if(a.URI&&(i.uri=a.URI),a.BYTERANGE){var s=a.BYTERANGE.split("@"),o=s[0],u=s[1];i.byterange={},o&&(i.byterange.length=parseInt(o,10)),u&&(i.byterange.offset=parseInt(u,10))}}n.trigger("data",i)}else if(e=/^#EXT-X-STREAM-INF:?(.*)$/.exec(t)){if(i={type:"tag",tagType:"stream-inf"},e[1]){if(i.attributes=_(e[1]),i.attributes.RESOLUTION){var d=i.attributes.RESOLUTION.split("x"),l={};d[0]&&(l.width=parseInt(d[0],10)),d[1]&&(l.height=parseInt(d[1],10)),i.attributes.RESOLUTION=l}i.attributes.BANDWIDTH&&(i.attributes.BANDWIDTH=parseInt(i.attributes.BANDWIDTH,10)),i.attributes["PROGRAM-ID"]&&(i.attributes["PROGRAM-ID"]=parseInt(i.attributes["PROGRAM-ID"],10))}n.trigger("data",i)}else{if(e=/^#EXT-X-MEDIA:?(.*)$/.exec(t))return i={type:"tag",tagType:"media"},e[1]&&(i.attributes=_(e[1])),void n.trigger("data",i);if(e=/^#EXT-X-ENDLIST/.exec(t))n.trigger("data",{type:"tag",tagType:"endlist"});else if(e=/^#EXT-X-DISCONTINUITY/.exec(t))n.trigger("data",{type:"tag",tagType:"discontinuity"});else{if(e=/^#EXT-X-PROGRAM-DATE-TIME:?(.*)$/.exec(t))return i={type:"tag",tagType:"program-date-time"},e[1]&&(i.dateTimeString=e[1],i.dateTimeObject=new Date(e[1])),void n.trigger("data",i);if(e=/^#EXT-X-KEY:?(.*)$/.exec(t))return i={type:"tag",tagType:"key"},e[1]&&(i.attributes=_(e[1]),i.attributes.IV&&("0x"===i.attributes.IV.substring(0,2).toLowerCase()&&(i.attributes.IV=i.attributes.IV.substring(2)),i.attributes.IV=i.attributes.IV.match(/.{8}/g),i.attributes.IV[0]=parseInt(i.attributes.IV[0],16),i.attributes.IV[1]=parseInt(i.attributes.IV[1],16),i.attributes.IV[2]=parseInt(i.attributes.IV[2],16),i.attributes.IV[3]=parseInt(i.attributes.IV[3],16),i.attributes.IV=new Uint32Array(i.attributes.IV))),void n.trigger("data",i);if(e=/^#EXT-X-START:?(.*)$/.exec(t))return i={type:"tag",tagType:"start"},e[1]&&(i.attributes=_(e[1]),i.attributes["TIME-OFFSET"]=parseFloat(i.attributes["TIME-OFFSET"]),i.attributes.PRECISE=/YES/.test(i.attributes.PRECISE)),void n.trigger("data",i);if(e=/^#EXT-X-CUE-OUT-CONT:?(.*)?$/.exec(t))return i={type:"tag",tagType:"cue-out-cont"},e[1]?i.data=e[1]:i.data="",void n.trigger("data",i);if(e=/^#EXT-X-CUE-OUT:?(.*)?$/.exec(t))return i={type:"tag",tagType:"cue-out"},e[1]?i.data=e[1]:i.data="",void n.trigger("data",i);if(e=/^#EXT-X-CUE-IN:?(.*)?$/.exec(t))return i={type:"tag",tagType:"cue-in"},e[1]?i.data=e[1]:i.data="",void n.trigger("data",i);n.trigger("data",{type:"tag",data:t.slice(4)})}}}else n.trigger("data",{type:"comment",text:t.slice(1)})}):this.trigger("data",{type:"uri",uri:t}))},i.addParser=function(t){var e=this,i=t.expression,n=t.customType,r=t.dataParser,a=t.segment;"function"!=typeof r&&(r=function(t){return t}),this.customParsers.push(function(t){if(i.exec(t))return e.trigger("data",{type:"custom",data:r(t),customType:n,segment:a}),!0})},i.addTagMapper=function(t){var e=t.expression,i=t.map;this.tagMappers.push(function(t){return e.test(t)?i(t):t})},e}(g),b=function(t){function e(){var e;(e=t.call(this)||this).lineStream=new y,e.parseStream=new v,e.lineStream.pipe(e.parseStream);var i,n,r=m(m(e)),a=[],s={},o={AUDIO:{},VIDEO:{},"CLOSED-CAPTIONS":{},SUBTITLES:{}},u=0;return e.manifest={allowCache:!0,discontinuityStarts:[],segments:[]},e.parseStream.on("data",function(t){var e,d;({tag:function(){(({"allow-cache":function(){this.manifest.allowCache=t.allowed,"allowed"in t||(this.trigger("info",{message:"defaulting allowCache to YES"}),this.manifest.allowCache=!0)},byterange:function(){var e={};"length"in t&&(s.byterange=e,e.length=t.length,"offset"in t||(this.trigger("info",{message:"defaulting offset to zero"}),t.offset=0)),"offset"in t&&(s.byterange=e,e.offset=t.offset)},endlist:function(){this.manifest.endList=!0},inf:function(){"mediaSequence"in this.manifest||(this.manifest.mediaSequence=0,this.trigger("info",{message:"defaulting media sequence to zero"})),"discontinuitySequence"in this.manifest||(this.manifest.discontinuitySequence=0,this.trigger("info",{message:"defaulting discontinuity sequence to zero"})),t.duration>0&&(s.duration=t.duration),0===t.duration&&(s.duration=.01,this.trigger("info",{message:"updating zero segment duration to a small value"})),this.manifest.segments=a},key:function(){t.attributes?"NONE"!==t.attributes.METHOD?t.attributes.URI?(t.attributes.METHOD||this.trigger("warn",{message:"defaulting key method to AES-128"}),n={method:t.attributes.METHOD||"AES-128",uri:t.attributes.URI},void 0!==t.attributes.IV&&(n.iv=t.attributes.IV)):this.trigger("warn",{message:"ignoring key declaration without URI"}):n=null:this.trigger("warn",{message:"ignoring key declaration without attribute list"})},"media-sequence":function(){isFinite(t.number)?this.manifest.mediaSequence=t.number:this.trigger("warn",{message:"ignoring invalid media sequence: "+t.number})},"discontinuity-sequence":function(){isFinite(t.number)?(this.manifest.discontinuitySequence=t.number,u=t.number):this.trigger("warn",{message:"ignoring invalid discontinuity sequence: "+t.number})},"playlist-type":function(){/VOD|EVENT/.test(t.playlistType)?this.manifest.playlistType=t.playlistType:this.trigger("warn",{message:"ignoring unknown playlist type: "+t.playlist})},map:function(){i={},t.uri&&(i.uri=t.uri),t.byterange&&(i.byterange=t.byterange)},"stream-inf":function(){this.manifest.playlists=a,this.manifest.mediaGroups=this.manifest.mediaGroups||o,t.attributes?(s.attributes||(s.attributes={}),f(s.attributes,t.attributes)):this.trigger("warn",{message:"ignoring empty stream-inf attributes"})},media:function(){if(this.manifest.mediaGroups=this.manifest.mediaGroups||o,t.attributes&&t.attributes.TYPE&&t.attributes["GROUP-ID"]&&t.attributes.NAME){var i=this.manifest.mediaGroups[t.attributes.TYPE];i[t.attributes["GROUP-ID"]]=i[t.attributes["GROUP-ID"]]||{},e=i[t.attributes["GROUP-ID"]],(d={default:/yes/i.test(t.attributes.DEFAULT)}).default?d.autoselect=!0:d.autoselect=/yes/i.test(t.attributes.AUTOSELECT),t.attributes.LANGUAGE&&(d.language=t.attributes.LANGUAGE),t.attributes.URI&&(d.uri=t.attributes.URI),t.attributes["INSTREAM-ID"]&&(d.instreamId=t.attributes["INSTREAM-ID"]),t.attributes.CHARACTERISTICS&&(d.characteristics=t.attributes.CHARACTERISTICS),t.attributes.FORCED&&(d.forced=/yes/i.test(t.attributes.FORCED)),e[t.attributes.NAME]=d}else this.trigger("warn",{message:"ignoring incomplete or missing media group"})},discontinuity:function(){u+=1,s.discontinuity=!0,this.manifest.discontinuityStarts.push(a.length)},"program-date-time":function(){void 0===this.manifest.dateTimeString&&(this.manifest.dateTimeString=t.dateTimeString,this.manifest.dateTimeObject=t.dateTimeObject),s.dateTimeString=t.dateTimeString,s.dateTimeObject=t.dateTimeObject},targetduration:function(){!isFinite(t.duration)||t.duration<0?this.trigger("warn",{message:"ignoring invalid target duration: "+t.duration}):this.manifest.targetDuration=t.duration},totalduration:function(){!isFinite(t.duration)||t.duration<0?this.trigger("warn",{message:"ignoring invalid total duration: "+t.duration}):this.manifest.totalDuration=t.duration},start:function(){t.attributes&&!isNaN(t.attributes["TIME-OFFSET"])?this.manifest.start={timeOffset:t.attributes["TIME-OFFSET"],precise:t.attributes.PRECISE}:this.trigger("warn",{message:"ignoring start declaration without appropriate attribute list"})},"cue-out":function(){s.cueOut=t.data},"cue-out-cont":function(){s.cueOutCont=t.data},"cue-in":function(){s.cueIn=t.data}})[t.tagType]||function(){}).call(r)},uri:function(){s.uri=t.uri,a.push(s),!this.manifest.targetDuration||"duration"in s||(this.trigger("warn",{message:"defaulting segment duration to the target duration"}),s.duration=this.manifest.targetDuration),n&&(s.key=n),s.timeline=u,i&&(s.map=i),s={}},comment:function(){},custom:function(){t.segment?(s.custom=s.custom||{},s.custom[t.customType]=t.data):(this.manifest.custom=this.manifest.custom||{},this.manifest.custom[t.customType]=t.data)}})[t.type].call(r)}),e}p(e,t);var i=e.prototype;return i.push=function(t){this.lineStream.push(t)},i.end=function(){this.lineStream.push("\n")},i.addParser=function(t){this.parseStream.addParser(t)},i.addTagMapper=function(t){this.parseStream.addTagMapper(t)},e}(g),T=function(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")},S=function(){function t(t,e){for(var i=0;i<e.length;i++){var n=e[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(t,n.key,n)}}return function(e,i,n){return i&&t(e.prototype,i),n&&t(e,n),e}}(),k=function(t,e){if("function"!=typeof e&&null!==e)throw new TypeError("Super expression must either be null or a function, not "+typeof e);t.prototype=Object.create(e&&e.prototype,{constructor:{value:t,enumerable:!1,writable:!0,configurable:!0}}),e&&(Object.setPrototypeOf?Object.setPrototypeOf(t,e):t.__proto__=e)},w=function(t,e){if(!t)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!e||"object"!=typeof e&&"function"!=typeof e?t:e},U=function(){return function(t,e){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return function(t,e){var i=[],n=!0,r=!1,a=void 0;try{for(var s,o=t[Symbol.iterator]();!(n=(s=o.next()).done)&&(i.push(s.value),!e||i.length!==e);n=!0);}catch(t){r=!0,a=t}finally{try{!n&&o.return&&o.return()}finally{if(r)throw a}}return i}(t,e);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}(),L=e.mergeOptions,A=e.EventTarget,E=e.log,O=function(t,e){["AUDIO","SUBTITLES"].forEach(function(i){for(var n in t.mediaGroups[i])for(var r in t.mediaGroups[i][n]){var a=t.mediaGroups[i][n][r];e(a,i,n,r)}})},C=function(t,e){var i=L(t,{}),n=i.playlists[e.uri];if(!n)return null;if(n.segments&&e.segments&&n.segments.length===e.segments.length&&n.mediaSequence===e.mediaSequence)return null;var r=L(n,e);n.segments&&(r.segments=function(t,e,i){var n=e.slice();i=i||0;for(var r=Math.min(t.length,e.length+i),a=i;a<r;a++)n[a-i]=L(t[a],n[a-i]);return n}(n.segments,e.segments,e.mediaSequence-n.mediaSequence)),r.segments.forEach(function(t){!function(t,e){t.resolvedUri||(t.resolvedUri=h(e,t.uri)),t.key&&!t.key.resolvedUri&&(t.key.resolvedUri=h(e,t.key.uri)),t.map&&!t.map.resolvedUri&&(t.map.resolvedUri=h(e,t.map.uri))}(t,r.resolvedUri)});for(var a=0;a<i.playlists.length;a++)i.playlists[a].uri===e.uri&&(i.playlists[a]=r);return i.playlists[e.uri]=r,i},I=function(t){for(var e=t.playlists.length;e--;){var i=t.playlists[e];t.playlists[i.uri]=i,i.resolvedUri=h(t.uri,i.uri),i.id=e,i.attributes||(i.attributes={},E.warn("Invalid playlist STREAM-INF detected. Missing BANDWIDTH attribute."))}},D=function(t){O(t,function(e){e.uri&&(e.resolvedUri=h(t.uri,e.uri))})},P=function(t,e){var i=t.segments[t.segments.length-1];return e&&i&&i.duration?1e3*i.duration:500*(t.targetDuration||10)},R=function(t){function e(t,i,n){T(this,e);var r=w(this,(e.__proto__||Object.getPrototypeOf(e)).call(this));r.srcUrl=t,r.hls_=i,r.withCredentials=n;var a=i.options_;if(r.customTagParsers=a&&a.customTagParsers||[],r.customTagMappers=a&&a.customTagMappers||[],!r.srcUrl)throw new Error("A non-empty playlist URL is required");return r.state="HAVE_NOTHING",r.on("mediaupdatetimeout",function(){"HAVE_METADATA"===r.state&&(r.state="HAVE_CURRENT_METADATA",r.request=r.hls_.xhr({uri:h(r.master.uri,r.media().uri),withCredentials:r.withCredentials},function(t,e){if(r.request)return t?r.playlistRequestError(r.request,r.media().uri,"HAVE_METADATA"):void r.haveMetadata(r.request,r.media().uri)}))}),r}return k(e,A),S(e,[{key:"playlistRequestError",value:function(t,e,i){this.request=null,i&&(this.state=i),this.error={playlist:this.master.playlists[e],status:t.status,message:"HLS playlist request error at URL: "+e,responseText:t.responseText,code:t.status>=500?4:2},this.trigger("error")}},{key:"haveMetadata",value:function(t,e){var i=this;this.request=null,this.state="HAVE_METADATA";var n=new b;this.customTagParsers.forEach(function(t){return n.addParser(t)}),this.customTagMappers.forEach(function(t){return n.addTagMapper(t)}),n.push(t.responseText),n.end(),n.manifest.uri=e,n.manifest.attributes=n.manifest.attributes||{};var r=C(this.master,n.manifest);this.targetDuration=n.manifest.targetDuration,r?(this.master=r,this.media_=this.master.playlists[n.manifest.uri]):this.trigger("playlistunchanged"),this.media().endList||(c.clearTimeout(this.mediaUpdateTimeout),this.mediaUpdateTimeout=c.setTimeout(function(){i.trigger("mediaupdatetimeout")},P(this.media(),!!r))),this.trigger("loadedplaylist")}},{key:"dispose",value:function(){this.stopRequest(),c.clearTimeout(this.mediaUpdateTimeout)}},{key:"stopRequest",value:function(){if(this.request){var t=this.request;this.request=null,t.onreadystatechange=null,t.abort()}}},{key:"media",value:function(t){var e=this;if(!t)return this.media_;if("HAVE_NOTHING"===this.state)throw new Error("Cannot switch media playlist from "+this.state);var i=this.state;if("string"==typeof t){if(!this.master.playlists[t])throw new Error("Unknown playlist URI: "+t);t=this.master.playlists[t]}var n=!this.media_||t.uri!==this.media_.uri;if(this.master.playlists[t.uri].endList)return this.request&&(this.request.onreadystatechange=null,this.request.abort(),this.request=null),this.state="HAVE_METADATA",this.media_=t,void(n&&(this.trigger("mediachanging"),this.trigger("mediachange")));if(n){if(this.state="SWITCHING_MEDIA",this.request){if(h(this.master.uri,t.uri)===this.request.url)return;this.request.onreadystatechange=null,this.request.abort(),this.request=null}this.media_&&this.trigger("mediachanging"),this.request=this.hls_.xhr({uri:h(this.master.uri,t.uri),withCredentials:this.withCredentials},function(n,r){if(e.request){if(n)return e.playlistRequestError(e.request,t.uri,i);e.haveMetadata(r,t.uri),"HAVE_MASTER"===i?e.trigger("loadedmetadata"):e.trigger("mediachange")}})}}},{key:"pause",value:function(){this.stopRequest(),c.clearTimeout(this.mediaUpdateTimeout),"HAVE_NOTHING"===this.state&&(this.started=!1),"SWITCHING_MEDIA"===this.state?this.media_?this.state="HAVE_METADATA":this.state="HAVE_MASTER":"HAVE_CURRENT_METADATA"===this.state&&(this.state="HAVE_METADATA")}},{key:"load",value:function(t){var e=this;c.clearTimeout(this.mediaUpdateTimeout);var i=this.media();if(t){var n=i?i.targetDuration/2*1e3:5e3;this.mediaUpdateTimeout=c.setTimeout(function(){return e.load()},n)}else this.started?i&&!i.endList?this.trigger("mediaupdatetimeout"):this.trigger("loadedplaylist"):this.start()}},{key:"start",value:function(){var t=this;this.started=!0,this.request=this.hls_.xhr({uri:this.srcUrl,withCredentials:this.withCredentials},function(e,i){if(t.request){if(t.request=null,e)return t.error={status:i.status,message:"HLS playlist request error at URL: "+t.srcUrl,responseText:i.responseText,code:2},"HAVE_NOTHING"===t.state&&(t.started=!1),t.trigger("error");var n=new b;return t.customTagParsers.forEach(function(t){return n.addParser(t)}),t.customTagMappers.forEach(function(t){return n.addTagMapper(t)}),n.push(i.responseText),n.end(),t.state="HAVE_MASTER",n.manifest.uri=t.srcUrl,n.manifest.playlists?(t.master=n.manifest,I(t.master),D(t.master),t.trigger("loadedplaylist"),void(t.request||t.media(n.manifest.playlists[0]))):(t.master={mediaGroups:{AUDIO:{},VIDEO:{},"CLOSED-CAPTIONS":{},SUBTITLES:{}},uri:c.location.href,playlists:[{uri:t.srcUrl,id:0}]},t.master.playlists[t.srcUrl]=t.master.playlists[0],t.master.playlists[0].resolvedUri=t.srcUrl,t.master.playlists[0].attributes=t.master.playlists[0].attributes||{},t.haveMetadata(i,t.srcUrl),t.trigger("loadedmetadata"))}})}}]),e}(),x=e.createTimeRange,M=function(t,e,i){var n,r;return void 0===e&&(e=t.mediaSequence+t.segments.length),e<t.mediaSequence?0:(n=function(t,e){var i=0,n=e-t.mediaSequence,r=t.segments[n];if(r){if(void 0!==r.start)return{result:r.start,precise:!0};if(void 0!==r.end)return{result:r.end-r.duration,precise:!0}}for(;n--;){if(void 0!==(r=t.segments[n]).end)return{result:i+r.end,precise:!0};if(i+=r.duration,void 0!==r.start)return{result:i+r.start,precise:!0}}return{result:i,precise:!1}}(t,e)).precise?n.result:(r=function(t,e){for(var i=0,n=void 0,r=e-t.mediaSequence;r<t.segments.length;r++){if(void 0!==(n=t.segments[r]).start)return{result:n.start-i,precise:!0};if(i+=n.duration,void 0!==n.end)return{result:n.end-i,precise:!0}}return{result:-1,precise:!1}}(t,e)).precise?r.result:n.result+i},B=function(t,e,i){if(!t)return 0;if("number"!=typeof i&&(i=0),void 0===e){if(t.totalDuration)return t.totalDuration;if(!t.endList)return c.Infinity}return M(t,e,i)},N=function(t,e,i){var n=0;if(e>i){var r=[i,e];e=r[0],i=r[1]}if(e<0){for(var a=e;a<Math.min(0,i);a++)n+=t.targetDuration;e=0}for(var s=e;s<i;s++)n+=t.segments[s].duration;return n},q=function(t){if(!t.segments.length)return 0;for(var e=t.segments.length-1,i=t.segments[e].duration||t.targetDuration,n=i+2*t.targetDuration;e--&&!((i+=t.segments[e].duration)>=n););return Math.max(0,e)},F=function(t,e,i){if(!t||!t.segments)return null;if(t.endList)return B(t);if(null===e)return null;e=e||0;var n=i?q(t):t.segments.length;return M(t,t.mediaSequence+n,e)},G=function(t){return t-Math.floor(t)==0},V=function(t,e){if(G(e))return e+.1*t;for(var i=e.toString().split(".")[1].length,n=1;n<=i;n++){var r=Math.pow(10,n),a=e*r;if(G(a)||n===i)return(a+t)/r}},H=V.bind(null,1),j=V.bind(null,-1),z=function(t){return t.excludeUntil&&t.excludeUntil>Date.now()},W=function(t){return t.excludeUntil&&t.excludeUntil===1/0},X=function(t){var e=z(t);return!t.disabled&&!e},Y=function(t,e){return e.attributes&&e.attributes[t]},$=function(t,e){if(1===t.playlists.length)return!0;var i=e.attributes.BANDWIDTH||Number.MAX_VALUE;return 0===t.playlists.filter(function(t){return!!X(t)&&(t.attributes.BANDWIDTH||0)<i}).length},K={duration:B,seekable:function(t,e){var i=e||0,n=F(t,e,!0);return null===n?x():x(i,n)},safeLiveIndex:q,getMediaInfoForTime:function(t,e,i,n){var r=void 0,a=void 0,s=t.segments.length,o=e-n;if(o<0){if(i>0)for(r=i-1;r>=0;r--)if(a=t.segments[r],(o+=j(a.duration))>0)return{mediaIndex:r,startTime:n-N(t,i,r)};return{mediaIndex:0,startTime:e}}if(i<0){for(r=i;r<0;r++)if((o-=t.targetDuration)<0)return{mediaIndex:0,startTime:e};i=0}for(r=i;r<s;r++)if(a=t.segments[r],(o-=H(a.duration))<0)return{mediaIndex:r,startTime:n+N(t,i,r)};return{mediaIndex:s-1,startTime:e}},isEnabled:X,isDisabled:function(t){return t.disabled},isBlacklisted:z,isIncompatible:W,playlistEnd:F,isAes:function(t){for(var e=0;e<t.segments.length;e++)if(t.segments[e].key)return!0;return!1},isFmp4:function(t){for(var e=0;e<t.segments.length;e++)if(t.segments[e].map)return!0;return!1},hasAttribute:Y,estimateSegmentRequestTime:function(t,e,i){var n=arguments.length>3&&void 0!==arguments[3]?arguments[3]:0;return Y("BANDWIDTH",i)?(t*i.attributes.BANDWIDTH-8*n)/e:NaN},isLowestEnabledRendition:$},Q=e.xhr,Z=e.mergeOptions,J=function(){return function t(i,n){i=Z({timeout:45e3},i);var r=t.beforeRequest||e.Hls.xhr.beforeRequest;if(r&&"function"==typeof r){var a=r(i);a&&(i=a)}var s=Q(i,function(t,e){var i=s.response;!t&&i&&(s.responseTime=Date.now(),s.roundTripTime=s.responseTime-s.requestTime,s.bytesReceived=i.byteLength||i.length,s.bandwidth||(s.bandwidth=Math.floor(s.bytesReceived/s.roundTripTime*8*1e3))),e.headers&&(s.responseHeaders=e.headers),t&&"ETIMEDOUT"===t.code&&(s.timedout=!0),t||s.aborted||200===e.statusCode||206===e.statusCode||0===e.statusCode||(t=new Error("XHR Failed with a response of: "+(s&&(i||s.responseText)))),n(t,s)}),o=s.abort;return s.abort=function(){return s.aborted=!0,o.apply(s,arguments)},s.uri=i.uri,s.requestTime=Date.now(),s}};var tt=function(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")},et=function(){function t(t,e){for(var i=0;i<e.length;i++){var n=e[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(t,n.key,n)}}return function(e,i,n){return i&&t(e.prototype,i),n&&t(e,n),e}}(),it=function(t,e){if(!t)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!e||"object"!=typeof e&&"function"!=typeof e?t:e},nt=function(){var t=[[[],[],[],[],[]],[[],[],[],[],[]]],e=t[0],i=t[1],n=e[4],r=i[4],a=void 0,s=void 0,o=void 0,u=[],d=[],l=void 0,c=void 0,h=void 0,f=void 0,p=void 0;for(a=0;a<256;a++)d[(u[a]=a<<1^283*(a>>7))^a]=a;for(s=o=0;!n[s];s^=l||1,o=d[o]||1)for(h=(h=o^o<<1^o<<2^o<<3^o<<4)>>8^255&h^99,n[s]=h,r[h]=s,p=16843009*u[c=u[l=u[s]]]^65537*c^257*l^16843008*s,f=257*u[h]^16843008*h,a=0;a<4;a++)e[a][s]=f=f<<24^f>>>8,i[a][h]=p=p<<24^p>>>8;for(a=0;a<5;a++)e[a]=e[a].slice(0),i[a]=i[a].slice(0);return t},rt=null,at=function(){function t(e){tt(this,t),rt||(rt=nt()),this._tables=[[rt[0][0].slice(),rt[0][1].slice(),rt[0][2].slice(),rt[0][3].slice(),rt[0][4].slice()],[rt[1][0].slice(),rt[1][1].slice(),rt[1][2].slice(),rt[1][3].slice(),rt[1][4].slice()]];var i=void 0,n=void 0,r=void 0,a=void 0,s=void 0,o=this._tables[0][4],u=this._tables[1],d=e.length,l=1;if(4!==d&&6!==d&&8!==d)throw new Error("Invalid aes key size");for(a=e.slice(0),s=[],this._key=[a,s],i=d;i<4*d+28;i++)r=a[i-1],(i%d==0||8===d&&i%d==4)&&(r=o[r>>>24]<<24^o[r>>16&255]<<16^o[r>>8&255]<<8^o[255&r],i%d==0&&(r=r<<8^r>>>24^l<<24,l=l<<1^283*(l>>7))),a[i]=a[i-d]^r;for(n=0;i;n++,i--)r=a[3&n?i:i-4],s[n]=i<=4||n<4?r:u[0][o[r>>>24]]^u[1][o[r>>16&255]]^u[2][o[r>>8&255]]^u[3][o[255&r]]}return t.prototype.decrypt=function(t,e,i,n,r,a){var s=this._key[1],o=t^s[0],u=n^s[1],d=i^s[2],l=e^s[3],c=void 0,h=void 0,f=void 0,p=s.length/4-2,m=void 0,g=4,y=this._tables[1],_=y[0],v=y[1],b=y[2],T=y[3],S=y[4];for(m=0;m<p;m++)c=_[o>>>24]^v[u>>16&255]^b[d>>8&255]^T[255&l]^s[g],h=_[u>>>24]^v[d>>16&255]^b[l>>8&255]^T[255&o]^s[g+1],f=_[d>>>24]^v[l>>16&255]^b[o>>8&255]^T[255&u]^s[g+2],l=_[l>>>24]^v[o>>16&255]^b[u>>8&255]^T[255&d]^s[g+3],g+=4,o=c,u=h,d=f;for(m=0;m<4;m++)r[(3&-m)+a]=S[o>>>24]<<24^S[u>>16&255]<<16^S[d>>8&255]<<8^S[255&l]^s[g++],c=o,o=u,u=d,d=l,l=c},t}(),st=function(){function t(){tt(this,t),this.listeners={}}return t.prototype.on=function(t,e){this.listeners[t]||(this.listeners[t]=[]),this.listeners[t].push(e)},t.prototype.off=function(t,e){if(!this.listeners[t])return!1;var i=this.listeners[t].indexOf(e);return this.listeners[t].splice(i,1),i>-1},t.prototype.trigger=function(t){var e=this.listeners[t];if(e)if(2===arguments.length)for(var i=e.length,n=0;n<i;++n)e[n].call(this,arguments[1]);else for(var r=Array.prototype.slice.call(arguments,1),a=e.length,s=0;s<a;++s)e[s].apply(this,r)},t.prototype.dispose=function(){this.listeners={}},t.prototype.pipe=function(t){this.on("data",function(e){t.push(e)})},t}(),ot=function(t){function e(){tt(this,e);var i=it(this,t.call(this,st));return i.jobs=[],i.delay=1,i.timeout_=null,i}return function(t,e){if("function"!=typeof e&&null!==e)throw new TypeError("Super expression must either be null or a function, not "+typeof e);t.prototype=Object.create(e&&e.prototype,{constructor:{value:t,enumerable:!1,writable:!0,configurable:!0}}),e&&(Object.setPrototypeOf?Object.setPrototypeOf(t,e):t.__proto__=e)}(e,t),e.prototype.processJob_=function(){this.jobs.shift()(),this.jobs.length?this.timeout_=setTimeout(this.processJob_.bind(this),this.delay):this.timeout_=null},e.prototype.push=function(t){this.jobs.push(t),this.timeout_||(this.timeout_=setTimeout(this.processJob_.bind(this),this.delay))},e}(st),ut=function(t){return t<<24|(65280&t)<<8|(16711680&t)>>8|t>>>24},dt=function(t,e,i){var n=new Int32Array(t.buffer,t.byteOffset,t.byteLength>>2),r=new at(Array.prototype.slice.call(e)),a=new Uint8Array(t.byteLength),s=new Int32Array(a.buffer),o=void 0,u=void 0,d=void 0,l=void 0,c=void 0,h=void 0,f=void 0,p=void 0,m=void 0;for(o=i[0],u=i[1],d=i[2],l=i[3],m=0;m<n.length;m+=4)c=ut(n[m]),h=ut(n[m+1]),f=ut(n[m+2]),p=ut(n[m+3]),r.decrypt(c,h,f,p,s,m),s[m]=ut(s[m]^o),s[m+1]=ut(s[m+1]^u),s[m+2]=ut(s[m+2]^d),s[m+3]=ut(s[m+3]^l),o=c,u=h,d=f,l=p;return a},lt=function(){function t(e,i,n,r){tt(this,t);var a=t.STEP,s=new Int32Array(e.buffer),o=new Uint8Array(e.byteLength),u=0;for(this.asyncStream_=new ot,this.asyncStream_.push(this.decryptChunk_(s.subarray(u,u+a),i,n,o)),u=a;u<s.length;u+=a)n=new Uint32Array([ut(s[u-4]),ut(s[u-3]),ut(s[u-2]),ut(s[u-1])]),this.asyncStream_.push(this.decryptChunk_(s.subarray(u,u+a),i,n,o));this.asyncStream_.push(function(){var t;r(null,(t=o).subarray(0,t.byteLength-t[t.byteLength-1]))})}return t.prototype.decryptChunk_=function(t,e,i,n){return function(){var r=dt(t,e,i);n.set(r,t.byteOffset)}},et(t,null,[{key:"STEP",get:function(){return 32e3}}]),t}(),ct=function(t,e){return t.start(e)+"-"+t.end(e)},ht=function(t,e){var i=t.toString(16);return"00".substring(0,2-i.length)+i+(e%2?" ":"")},ft=function(t){return t>=32&&t<126?String.fromCharCode(t):"."},pt=function(t){var e={};return Object.keys(t).forEach(function(i){var n=t[i];ArrayBuffer.isView(n)?e[i]={bytes:n.buffer,byteOffset:n.byteOffset,byteLength:n.byteLength}:e[i]=n}),e},mt=function(t){var e=t.byterange||{length:1/0,offset:0};return[e.length,e.offset,t.resolvedUri].join(",")},gt=function(t){for(var e=Array.prototype.slice.call(t),i="",n=0;n<e.length/16;n++)i+=e.slice(16*n,16*n+16).map(ht).join("")+" "+e.slice(16*n,16*n+16).map(ft).join("")+"\n";return i},yt=Object.freeze({createTransferableMessage:pt,initSegmentId:mt,hexDump:gt,tagDump:function(t){var e=t.bytes;return gt(e)},textRanges:function(t){var e="",i=void 0;for(i=0;i<t.length;i++)e+=ct(t,i)+" ";return e}}),_t=function(t,e,i,n){var r=void 0;if("stream"===e){r=new Date(1e3*n+i.getTime());var a=t.toISOString(),s=i.toISOString(),o=r.toISOString();return s<=a&&a<=o}if("player"===e)return r=n+i,i<=t&&t<=r},vt=function(t,e,i){if(!i.segments||0===i.segments.length)return null;if("player"!==e&&"stream"!==e)return null;for(var n=0,r=0;r<i.segments.length;r++){var a=i.segments[r],s=n+a.duration,o=void 0,u=void 0;"player"===e?(o=a.start,u=n):(o=a.dateTimeObject,u=a.dateTimeObject);var d=void 0!==a.start&&void 0!==a.end&&_t(t,e,o,a.end-a.start),l=_t(t,e,u,a.duration);if(d)return{segment:a,estimatedStart:u,type:"accurate"};if(l)return{segment:a,estimatedStart:u,type:"estimate"};n=s}return null},bt=function(t){var e=t.playlist,i=t.time,n=void 0===i?void 0:i,r=t.callback;if(!r)throw new Error("getStreamTime: callback must be provided");if(!e||void 0===n)return r({message:"getStreamTime: playlist and time must be provided"});var a=function(t,e){return vt(t,"player",e)}(n,e);if(!a)return r({message:"valid streamTime was not found"});if("estimate"===a.type)return r({message:"Accurate streamTime could not be determined. Please seek to e.seekTime and try again",seekTime:a.estimatedStart});var s={mediaSeconds:n};return a.segment.dateTimeObject&&(s.programDateTime=a.segment.dateTimeObject.toISOString()),r(null,s)},Tt=function t(e){var i=e.streamTime,n=e.playlist,r=e.retryCount,a=void 0===r?2:r,s=e.seekTo,o=e.pauseAfterSeek,u=void 0===o||o,d=e.tech,l=e.callback;if(!l)throw new Error("seekToStreamTime: callback must be provided");if(void 0===i||!n||!s)return l({message:"seekToStreamTime: streamTime, seekTo and playlist must be provided"});if(!n.endList&&!d.hasStarted_)return l({message:"player must be playing a live stream to start buffering"});if(!function(t){if(!t.segments||0===t.segments.length)return!1;for(var e=0;e<t.segments.length;e++)if(!t.segments[e].dateTimeObject)return!1;return!0}(n))return l({message:"programDateTime tags must be provided in the manifest "+n.resolvedUri});var c=function(t,e){var i=void 0;try{i=new Date(t)}catch(t){return null}return vt(i,"stream",e)}(i,n);if(!c)return l({message:i+" was not found in the stream"});if("estimate"===c.type)return 0===a?l({message:i+" is not buffered yet. Try again"}):t({streamTime:i,playlist:n,retryCount:a-1,seekTo:s,pauseAfterSeek:u,tech:d,callback:l});var h=c.segment,f=function(t,e){var i=void 0,n=void 0;try{i=new Date(t),n=new Date(e)}catch(t){}var r=i.getTime();return(n.getTime()-r)/1e3}(h.dateTimeObject,i),p=h.start+f;d.one("seeked",function(){return l(null,d.currentTime())}),u&&d.pause(),s(p)},St=function(t,i){var n=[],r=void 0;if(t&&t.length)for(r=0;r<t.length;r++)i(t.start(r),t.end(r))&&n.push([t.start(r),t.end(r)]);return e.createTimeRanges(n)},kt=function(t,e){return St(t,function(t,i){return t-1/30<=e&&i+1/30>=e})},wt=function(t,e){return St(t,function(t){return t-1/30>=e})},Ut=function(t){var e=[];if(!t||!t.length)return"";for(var i=0;i<t.length;i++)e.push(t.start(i)+" => "+t.end(i));return e.join(", ")},Lt=function(t){for(var e=[],i=0;i<t.length;i++)e.push({start:t.start(i),end:t.end(i)});return e},At=function(t,e,i){var n=void 0,r=void 0;if(i&&i.cues)for(n=i.cues.length;n--;)(r=i.cues[n]).startTime<=e&&r.endTime>=t&&i.removeCue(r)},Et=function(t){return isNaN(t)||Math.abs(t)===1/0?Number.MAX_VALUE:t},Ot=function(t,i,n){var r=c.WebKitDataCue||c.VTTCue;if(i&&i.forEach(function(t){var e=t.stream;this.inbandTextTracks_[e].addCue(new r(t.startTime+this.timestampOffset,t.endTime+this.timestampOffset,t.text))},t),n){var a=Et(t.mediaSource_.duration);if(n.forEach(function(t){var i=t.cueTime+this.timestampOffset;t.frames.forEach(function(t){var n=new r(i,i,t.value||t.url||t.data||"");n.frame=t,n.value=t,function(t){Object.defineProperties(t.frame,{id:{get:function(){return e.log.warn("cue.frame.id is deprecated. Use cue.value.key instead."),t.value.key}},value:{get:function(){return e.log.warn("cue.frame.value is deprecated. Use cue.value.data instead."),t.value.data}},privateData:{get:function(){return e.log.warn("cue.frame.privateData is deprecated. Use cue.value.data instead."),t.value.data}}})}(n),this.metadataTrack_.addCue(n)},this)},t),t.metadataTrack_&&t.metadataTrack_.cues&&t.metadataTrack_.cues.length){for(var s=t.metadataTrack_.cues,o=[],u=0;u<s.length;u++)s[u]&&o.push(s[u]);var d=o.reduce(function(t,e){var i=t[e.startTime]||[];return i.push(e),t[e.startTime]=i,t},{}),l=Object.keys(d).sort(function(t,e){return Number(t)-Number(e)});l.forEach(function(t,e){var i=d[t],n=Number(l[e+1])||a;i.forEach(function(t){t.endTime=n})})}}},Ct="undefined"!=typeof window?window:{},It="undefined"==typeof Symbol?"__target":Symbol(),Dt="application/javascript",Pt=Ct.BlobBuilder||Ct.WebKitBlobBuilder||Ct.MozBlobBuilder||Ct.MSBlobBuilder,Rt=Ct.URL||Ct.webkitURL||Rt&&Rt.msURL,xt=Ct.Worker;function Mt(t,e){return function(i){var n=this;if(!e)return new xt(t);if(xt&&!i){var r=Ft(e.toString().replace(/^function.+?{/,"").slice(0,-1));return this[It]=new xt(r),function(t,e){if(!t||!e)return;var i=t.terminate;t.objURL=e,t.terminate=function(){t.objURL&&Rt.revokeObjectURL(t.objURL),i.call(t)}}(this[It],r),this[It]}var a={postMessage:function(t){n.onmessage&&setTimeout(function(){n.onmessage({data:t,target:a})})}};e.call(a),this.postMessage=function(t){setTimeout(function(){a.onmessage({data:t,target:n})})},this.isThisThread=!0}}if(xt){var Bt,Nt=Ft("self.onmessage = function () {}"),qt=new Uint8Array(1);try{(Bt=new xt(Nt)).postMessage(qt,[qt.buffer])}catch(t){xt=null}finally{Rt.revokeObjectURL(Nt),Bt&&Bt.terminate()}}function Ft(t){try{return Rt.createObjectURL(new Blob([t],{type:Dt}))}catch(i){var e=new Pt;return e.append(t),Rt.createObjectURL(e.getBlob(type))}}var Gt=new Mt("./transmuxer-worker.worker.js",function(t,e){var i=this;!function(){var t,e,n,r,a,s,o,u,d,l,c,h,f,p,m,g,y,_,v,b,T,S,k,w,U,L,A,E,O,C,I,D,P,R,x,M,B,N,q,F,G=Math.pow(2,32)-1;!function(){var t;if(S={avc1:[],avcC:[],btrt:[],dinf:[],dref:[],esds:[],ftyp:[],hdlr:[],mdat:[],mdhd:[],mdia:[],mfhd:[],minf:[],moof:[],moov:[],mp4a:[],mvex:[],mvhd:[],sdtp:[],smhd:[],stbl:[],stco:[],stsc:[],stsd:[],stsz:[],stts:[],styp:[],tfdt:[],tfhd:[],traf:[],trak:[],trun:[],trex:[],tkhd:[],vmhd:[]},"undefined"!=typeof Uint8Array){for(t in S)S.hasOwnProperty(t)&&(S[t]=[t.charCodeAt(0),t.charCodeAt(1),t.charCodeAt(2),t.charCodeAt(3)]);k=new Uint8Array(["i".charCodeAt(0),"s".charCodeAt(0),"o".charCodeAt(0),"m".charCodeAt(0)]),U=new Uint8Array(["a".charCodeAt(0),"v".charCodeAt(0),"c".charCodeAt(0),"1".charCodeAt(0)]),w=new Uint8Array([0,0,0,1]),L=new Uint8Array([0,0,0,0,0,0,0,0,118,105,100,101,0,0,0,0,0,0,0,0,0,0,0,0,86,105,100,101,111,72,97,110,100,108,101,114,0]),A=new Uint8Array([0,0,0,0,0,0,0,0,115,111,117,110,0,0,0,0,0,0,0,0,0,0,0,0,83,111,117,110,100,72,97,110,100,108,101,114,0]),E={video:L,audio:A},I=new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,12,117,114,108,32,0,0,0,1]),C=new Uint8Array([0,0,0,0,0,0,0,0]),D=new Uint8Array([0,0,0,0,0,0,0,0]),P=D,R=new Uint8Array([0,0,0,0,0,0,0,0,0,0,0,0]),x=D,O=new Uint8Array([0,0,0,1,0,0,0,0,0,0,0,0])}}(),t=function(t){var e,i,n=[],r=0;for(e=1;e<arguments.length;e++)n.push(arguments[e]);for(e=n.length;e--;)r+=n[e].byteLength;for(i=new Uint8Array(r+8),new DataView(i.buffer,i.byteOffset,i.byteLength).setUint32(0,i.byteLength),i.set(t,4),e=0,r=8;e<n.length;e++)i.set(n[e],r),r+=n[e].byteLength;return i},e=function(){return t(S.dinf,t(S.dref,I))},n=function(e){return t(S.esds,new Uint8Array([0,0,0,0,3,25,0,0,0,4,17,64,21,0,6,0,0,0,218,192,0,0,218,192,5,2,e.audioobjecttype<<3|e.samplingfrequencyindex>>>1,e.samplingfrequencyindex<<7|e.channelcount<<3,6,1,2]))},m=function(e){return t(S.hdlr,E[e])},p=function(e){var i=new Uint8Array([0,0,0,0,0,0,0,2,0,0,0,3,0,1,95,144,e.duration>>>24&255,e.duration>>>16&255,e.duration>>>8&255,255&e.duration,85,196,0,0]);return e.samplerate&&(i[12]=e.samplerate>>>24&255,i[13]=e.samplerate>>>16&255,i[14]=e.samplerate>>>8&255,i[15]=255&e.samplerate),t(S.mdhd,i)},f=function(e){return t(S.mdia,p(e),m(e.type),s(e))},a=function(e){return t(S.mfhd,new Uint8Array([0,0,0,0,(4278190080&e)>>24,(16711680&e)>>16,(65280&e)>>8,255&e]))},s=function(i){return t(S.minf,"video"===i.type?t(S.vmhd,O):t(S.smhd,C),e(),y(i))},o=function(e,i){for(var n=[],r=i.length;r--;)n[r]=v(i[r]);return t.apply(null,[S.moof,a(e)].concat(n))},u=function(e){for(var i=e.length,n=[];i--;)n[i]=c(e[i]);return t.apply(null,[S.moov,l(4294967295)].concat(n).concat(d(e)))},d=function(e){for(var i=e.length,n=[];i--;)n[i]=b(e[i]);return t.apply(null,[S.mvex].concat(n))},l=function(e){var i=new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,2,0,1,95,144,(4278190080&e)>>24,(16711680&e)>>16,(65280&e)>>8,255&e,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255]);return t(S.mvhd,i)},g=function(e){var i,n,r=e.samples||[],a=new Uint8Array(4+r.length);for(n=0;n<r.length;n++)i=r[n].flags,a[n+4]=i.dependsOn<<4|i.isDependedOn<<2|i.hasRedundancy;return t(S.sdtp,a)},y=function(e){return t(S.stbl,_(e),t(S.stts,x),t(S.stsc,P),t(S.stsz,R),t(S.stco,D))},_=function(e){return t(S.stsd,new Uint8Array([0,0,0,0,0,0,0,1]),"video"===e.type?M(e):B(e))},M=function(e){var i,n=e.sps||[],r=e.pps||[],a=[],s=[];for(i=0;i<n.length;i++)a.push((65280&n[i].byteLength)>>>8),a.push(255&n[i].byteLength),a=a.concat(Array.prototype.slice.call(n[i]));for(i=0;i<r.length;i++)s.push((65280&r[i].byteLength)>>>8),s.push(255&r[i].byteLength),s=s.concat(Array.prototype.slice.call(r[i]));return t(S.avc1,new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,(65280&e.width)>>8,255&e.width,(65280&e.height)>>8,255&e.height,0,72,0,0,0,72,0,0,0,0,0,0,0,1,19,118,105,100,101,111,106,115,45,99,111,110,116,114,105,98,45,104,108,115,0,0,0,0,0,0,0,0,0,0,0,0,0,24,17,17]),t(S.avcC,new Uint8Array([1,e.profileIdc,e.profileCompatibility,e.levelIdc,255].concat([n.length]).concat(a).concat([r.length]).concat(s))),t(S.btrt,new Uint8Array([0,28,156,128,0,45,198,192,0,45,198,192])))},B=function(e){return t(S.mp4a,new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,(65280&e.channelcount)>>8,255&e.channelcount,(65280&e.samplesize)>>8,255&e.samplesize,0,0,0,0,(65280&e.samplerate)>>8,255&e.samplerate,0,0]),n(e))},h=function(e){var i=new Uint8Array([0,0,0,7,0,0,0,0,0,0,0,0,(4278190080&e.id)>>24,(16711680&e.id)>>16,(65280&e.id)>>8,255&e.id,0,0,0,0,(4278190080&e.duration)>>24,(16711680&e.duration)>>16,(65280&e.duration)>>8,255&e.duration,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,(65280&e.width)>>8,255&e.width,0,0,(65280&e.height)>>8,255&e.height,0,0]);return t(S.tkhd,i)},v=function(e){var i,n,r,a,s,o;return i=t(S.tfhd,new Uint8Array([0,0,0,58,(4278190080&e.id)>>24,(16711680&e.id)>>16,(65280&e.id)>>8,255&e.id,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0])),s=Math.floor(e.baseMediaDecodeTime/(G+1)),o=Math.floor(e.baseMediaDecodeTime%(G+1)),n=t(S.tfdt,new Uint8Array([1,0,0,0,s>>>24&255,s>>>16&255,s>>>8&255,255&s,o>>>24&255,o>>>16&255,o>>>8&255,255&o])),92,"audio"===e.type?(r=T(e,92),t(S.traf,i,n,r)):(a=g(e),r=T(e,a.length+92),t(S.traf,i,n,r,a))},c=function(e){return e.duration=e.duration||4294967295,t(S.trak,h(e),f(e))},b=function(e){var i=new Uint8Array([0,0,0,0,(4278190080&e.id)>>24,(16711680&e.id)>>16,(65280&e.id)>>8,255&e.id,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,1]);return"video"!==e.type&&(i[i.length-1]=0),t(S.trex,i)},F=function(t,e){var i=0,n=0,r=0,a=0;return t.length&&(void 0!==t[0].duration&&(i=1),void 0!==t[0].size&&(n=2),void 0!==t[0].flags&&(r=4),void 0!==t[0].compositionTimeOffset&&(a=8)),[0,0,i|n|r|a,1,(4278190080&t.length)>>>24,(16711680&t.length)>>>16,(65280&t.length)>>>8,255&t.length,(4278190080&e)>>>24,(16711680&e)>>>16,(65280&e)>>>8,255&e]},q=function(e,i){var n,r,a,s;for(i+=20+16*(r=e.samples||[]).length,n=F(r,i),s=0;s<r.length;s++)a=r[s],n=n.concat([(4278190080&a.duration)>>>24,(16711680&a.duration)>>>16,(65280&a.duration)>>>8,255&a.duration,(4278190080&a.size)>>>24,(16711680&a.size)>>>16,(65280&a.size)>>>8,255&a.size,a.flags.isLeading<<2|a.flags.dependsOn,a.flags.isDependedOn<<6|a.flags.hasRedundancy<<4|a.flags.paddingValue<<1|a.flags.isNonSyncSample,61440&a.flags.degradationPriority,15&a.flags.degradationPriority,(4278190080&a.compositionTimeOffset)>>>24,(16711680&a.compositionTimeOffset)>>>16,(65280&a.compositionTimeOffset)>>>8,255&a.compositionTimeOffset]);return t(S.trun,new Uint8Array(n))},N=function(e,i){var n,r,a,s;for(i+=20+8*(r=e.samples||[]).length,n=F(r,i),s=0;s<r.length;s++)a=r[s],n=n.concat([(4278190080&a.duration)>>>24,(16711680&a.duration)>>>16,(65280&a.duration)>>>8,255&a.duration,(4278190080&a.size)>>>24,(16711680&a.size)>>>16,(65280&a.size)>>>8,255&a.size]);return t(S.trun,new Uint8Array(n))},T=function(t,e){return"audio"===t.type?N(t,e):q(t,e)};var V,H,j={ftyp:r=function(){return t(S.ftyp,k,w,k,U)},mdat:function(e){return t(S.mdat,e)},moof:o,moov:u,initSegment:function(t){var e,i=r(),n=u(t);return(e=new Uint8Array(i.byteLength+n.byteLength)).set(i),e.set(n,i.byteLength),e}},z=function(t){return t>>>0},W={findBox:V=function(t,e){var i,n,r,a,s,o=[];if(!e.length)return null;for(i=0;i<t.byteLength;)n=z(t[i]<<24|t[i+1]<<16|t[i+2]<<8|t[i+3]),r=H(t.subarray(i+4,i+8)),a=n>1?i+n:t.byteLength,r===e[0]&&(1===e.length?o.push(t.subarray(i+8,a)):(s=V(t.subarray(i+8,a),e.slice(1))).length&&(o=o.concat(s))),i=a;return o},parseType:H=function(t){var e="";return e+=String.fromCharCode(t[0]),e+=String.fromCharCode(t[1]),e+=String.fromCharCode(t[2]),e+=String.fromCharCode(t[3])},timescale:function(t){return V(t,["moov","trak"]).reduce(function(t,e){var i,n,r,a,s;return(i=V(e,["tkhd"])[0])?(n=i[0],a=z(i[r=0===n?12:20]<<24|i[r+1]<<16|i[r+2]<<8|i[r+3]),(s=V(e,["mdia","mdhd"])[0])?(r=0===(n=s[0])?12:20,t[a]=z(s[r]<<24|s[r+1]<<16|s[r+2]<<8|s[r+3]),t):null):null},{})},startTime:function(t,e){var i,n,r;return i=V(e,["moof","traf"]),n=[].concat.apply([],i.map(function(e){return V(e,["tfhd"]).map(function(i){var n,r;return n=z(i[4]<<24|i[5]<<16|i[6]<<8|i[7]),r=t[n]||9e4,(V(e,["tfdt"]).map(function(t){var e,i;return e=t[0],i=z(t[4]<<24|t[5]<<16|t[6]<<8|t[7]),1===e&&(i*=Math.pow(2,32),i+=z(t[8]<<24|t[9]<<16|t[10]<<8|t[11])),i})[0]||1/0)/r})})),r=Math.min.apply(null,n),isFinite(r)?r:0},videoTrackIds:function(t){var e=[];return V(t,["moov","trak"]).forEach(function(t){var i=V(t,["mdia","hdlr"]),n=V(t,["tkhd"]);i.forEach(function(t,i){var r,a,s=H(t.subarray(8,12)),o=n[i];"vide"===s&&(a=0===(r=new DataView(o.buffer,o.byteOffset,o.byteLength)).getUint8(0)?r.getUint32(12):r.getUint32(20),e.push(a))})}),e}},X=function(){this.init=function(){var t={};this.on=function(e,i){t[e]||(t[e]=[]),t[e]=t[e].concat(i)},this.off=function(e,i){var n;return!!t[e]&&(n=t[e].indexOf(i),t[e]=t[e].slice(),t[e].splice(n,1),n>-1)},this.trigger=function(e){var i,n,r,a;if(i=t[e])if(2===arguments.length)for(r=i.length,n=0;n<r;++n)i[n].call(this,arguments[1]);else{for(a=[],n=arguments.length,n=1;n<arguments.length;++n)a.push(arguments[n]);for(r=i.length,n=0;n<r;++n)i[n].apply(this,a)}},this.dispose=function(){t={}}}};X.prototype.pipe=function(t){return this.on("data",function(e){t.push(e)}),this.on("done",function(e){t.flush(e)}),t},X.prototype.push=function(t){this.trigger("data",t)},X.prototype.flush=function(t){this.trigger("done",t)};var Y,$,K,Q,Z,J=X,tt=function(t,e){var i={size:0,flags:{isLeading:0,dependsOn:1,isDependedOn:0,hasRedundancy:0,degradationPriority:0,isNonSyncSample:1}};return i.dataOffset=e,i.compositionTimeOffset=t.pts-t.dts,i.duration=t.duration,i.size=4*t.length,i.size+=t.byteLength,t.keyFrame&&(i.flags.dependsOn=2,i.flags.isNonSyncSample=0),i},et=function(t){var e,i,n=[],r=[];for(n.byteLength=0,e=0;e<t.length;e++)"access_unit_delimiter_rbsp"===(i=t[e]).nalUnitType?(n.length&&(n.duration=i.dts-n.dts,r.push(n)),(n=[i]).byteLength=i.data.byteLength,n.pts=i.pts,n.dts=i.dts):("slice_layer_without_partitioning_rbsp_idr"===i.nalUnitType&&(n.keyFrame=!0),n.duration=i.dts-n.dts,n.byteLength+=i.data.byteLength,n.push(i));return r.length&&(!n.duration||n.duration<=0)&&(n.duration=r[r.length-1].duration),r.push(n),r},it=function(t){var e,i,n=[],r=[];for(n.byteLength=0,n.nalCount=0,n.duration=0,n.pts=t[0].pts,n.dts=t[0].dts,r.byteLength=0,r.nalCount=0,r.duration=0,r.pts=t[0].pts,r.dts=t[0].dts,e=0;e<t.length;e++)(i=t[e]).keyFrame?(n.length&&(r.push(n),r.byteLength+=n.byteLength,r.nalCount+=n.nalCount,r.duration+=n.duration),(n=[i]).nalCount=i.length,n.byteLength=i.byteLength,n.pts=i.pts,n.dts=i.dts,n.duration=i.duration):(n.duration+=i.duration,n.nalCount+=i.length,n.byteLength+=i.byteLength,n.push(i));return r.length&&n.duration<=0&&(n.duration=r[r.length-1].duration),r.byteLength+=n.byteLength,r.nalCount+=n.nalCount,r.duration+=n.duration,r.push(n),r},nt=function(t){var e;return!t[0][0].keyFrame&&t.length>1&&(e=t.shift(),t.byteLength-=e.byteLength,t.nalCount-=e.nalCount,t[0][0].dts=e.dts,t[0][0].pts=e.pts,t[0][0].duration+=e.duration),t},rt=function(t,e){var i,n,r,a,s,o=e||0,u=[];for(i=0;i<t.length;i++)for(a=t[i],n=0;n<a.length;n++)s=a[n],o+=(r=tt(s,o)).size,u.push(r);return u},at=function(t){var e,i,n,r,a,s,o=0,u=t.byteLength,d=t.nalCount,l=new Uint8Array(u+4*d),c=new DataView(l.buffer);for(e=0;e<t.length;e++)for(r=t[e],i=0;i<r.length;i++)for(a=r[i],n=0;n<a.length;n++)s=a[n],c.setUint32(o,s.data.byteLength),o+=4,l.set(s.data,o),o+=s.data.byteLength;return l},st=[33,16,5,32,164,27],ot=[33,65,108,84,1,2,4,8,168,2,4,8,17,191,252],ut=function(t){for(var e=[];t--;)e.push(0);return e},dt={96000:[st,[227,64],ut(154),[56]],88200:[st,[231],ut(170),[56]],64000:[st,[248,192],ut(240),[56]],48000:[st,[255,192],ut(268),[55,148,128],ut(54),[112]],44100:[st,[255,192],ut(268),[55,163,128],ut(84),[112]],32000:[st,[255,192],ut(268),[55,234],ut(226),[112]],24000:[st,[255,192],ut(268),[55,255,128],ut(268),[111,112],ut(126),[224]],16000:[st,[255,192],ut(268),[55,255,128],ut(268),[111,255],ut(269),[223,108],ut(195),[1,192]],12000:[ot,ut(268),[3,127,248],ut(268),[6,255,240],ut(268),[13,255,224],ut(268),[27,253,128],ut(259),[56]],11025:[ot,ut(268),[3,127,248],ut(268),[6,255,240],ut(268),[13,255,224],ut(268),[27,255,192],ut(268),[55,175,128],ut(108),[112]],8000:[ot,ut(268),[3,121,16],ut(47),[7]]},lt=(Y=dt,Object.keys(Y).reduce(function(t,e){return t[e]=new Uint8Array(Y[e].reduce(function(t,e){return t.concat(e)},[])),t},{})),ct=($=function(t){return 9e4*t},K=function(t,e){return t*e},Q=function(t){return t/9e4},Z=function(t,e){return t/e},function(t,e){return $(Z(t,e))}),ht=function(t,e){return K(Q(t),e)},ft=function(t,e,i,n){var r,a,s,o,u=0,d=0,l=0;if(e.length&&(r=ct(t.baseMediaDecodeTime,t.samplerate),a=Math.ceil(9e4/(t.samplerate/1024)),i&&n&&(u=r-Math.max(i,n),l=(d=Math.floor(u/a))*a),!(d<1||l>45e3))){for((s=lt[t.samplerate])||(s=e[0].data),o=0;o<d;o++)e.splice(o,0,{data:s});t.baseMediaDecodeTime-=Math.floor(ht(l,t.samplerate))}},pt=function(t,e,i){return e.minSegmentDts>=i?t:(e.minSegmentDts=1/0,t.filter(function(t){return t.dts>=i&&(e.minSegmentDts=Math.min(e.minSegmentDts,t.dts),e.minSegmentPts=e.minSegmentDts,!0)}))},mt=function(t){var e,i,n=[];for(e=0;e<t.length;e++)i=t[e],n.push({size:i.data.byteLength,duration:1024});return n},gt=function(t){var e,i,n=0,r=new Uint8Array(function(t){var e,i=0;for(e=0;e<t.length;e++)i+=t[e].data.byteLength;return i}(t));for(e=0;e<t.length;e++)i=t[e],r.set(i.data,n),n+=i.data.byteLength;return r},yt=function(t){delete t.minSegmentDts,delete t.maxSegmentDts,delete t.minSegmentPts,delete t.maxSegmentPts},_t=function(t,e){var i,n=t.minSegmentDts;return e||(n-=t.timelineStartInfo.dts),i=t.timelineStartInfo.baseMediaDecodeTime,i+=n,i=Math.max(0,i),"audio"===t.type&&(i*=t.samplerate/9e4,i=Math.floor(i)),i},vt=function(t,e){"number"==typeof e.pts&&(void 0===t.timelineStartInfo.pts&&(t.timelineStartInfo.pts=e.pts),void 0===t.minSegmentPts?t.minSegmentPts=e.pts:t.minSegmentPts=Math.min(t.minSegmentPts,e.pts),void 0===t.maxSegmentPts?t.maxSegmentPts=e.pts:t.maxSegmentPts=Math.max(t.maxSegmentPts,e.pts)),"number"==typeof e.dts&&(void 0===t.timelineStartInfo.dts&&(t.timelineStartInfo.dts=e.dts),void 0===t.minSegmentDts?t.minSegmentDts=e.dts:t.minSegmentDts=Math.min(t.minSegmentDts,e.dts),void 0===t.maxSegmentDts?t.maxSegmentDts=e.dts:t.maxSegmentDts=Math.max(t.maxSegmentDts,e.dts))},bt=function(t){for(var e=0,i={payloadType:-1,payloadSize:0},n=0,r=0;e<t.byteLength&&128!==t[e];){for(;255===t[e];)n+=255,e++;for(n+=t[e++];255===t[e];)r+=255,e++;if(r+=t[e++],!i.payload&&4===n){i.payloadType=n,i.payloadSize=r,i.payload=t.subarray(e,e+r);break}e+=r,n=0,r=0}return i},Tt=function(t){return 181!==t.payload[0]?null:49!=(t.payload[1]<<8|t.payload[2])?null:"GA94"!==String.fromCharCode(t.payload[3],t.payload[4],t.payload[5],t.payload[6])?null:3!==t.payload[7]?null:t.payload.subarray(8,t.payload.length-1)},St=function(t,e){var i,n,r,a,s=[];if(!(64&e[0]))return s;for(n=31&e[0],i=0;i<n;i++)a={type:3&e[2+(r=3*i)],pts:t},4&e[r+2]&&(a.ccData=e[r+3]<<8|e[r+4],s.push(a));return s},kt=function(t){for(var e,i,n=t.byteLength,r=[],a=1;a<n-2;)0===t[a]&&0===t[a+1]&&3===t[a+2]?(r.push(a+2),a+=2):a++;if(0===r.length)return t;e=n-r.length,i=new Uint8Array(e);var s=0;for(a=0;a<e;s++,a++)s===r[0]&&(s++,r.shift()),i[a]=t[s];return i},wt=4,Ut=function t(){t.prototype.init.call(this),this.captionPackets_=[],this.ccStreams_=[new Ct(0,0),new Ct(0,1),new Ct(1,0),new Ct(1,1)],this.reset(),this.ccStreams_.forEach(function(t){t.on("data",this.trigger.bind(this,"data")),t.on("done",this.trigger.bind(this,"done"))},this)};(Ut.prototype=new J).push=function(t){var e,i,n;if("sei_rbsp"===t.nalUnitType&&(e=bt(t.escapedRBSP)).payloadType===wt&&(i=Tt(e)))if(t.dts<this.latestDts_)this.ignoreNextEqualDts_=!0;else{if(t.dts===this.latestDts_&&this.ignoreNextEqualDts_)return this.numSameDts_--,void(this.numSameDts_||(this.ignoreNextEqualDts_=!1));n=St(t.pts,i),this.captionPackets_=this.captionPackets_.concat(n),this.latestDts_!==t.dts&&(this.numSameDts_=0),this.numSameDts_++,this.latestDts_=t.dts}},Ut.prototype.flush=function(){this.captionPackets_.length?(this.captionPackets_.forEach(function(t,e){t.presortIndex=e}),this.captionPackets_.sort(function(t,e){return t.pts===e.pts?t.presortIndex-e.presortIndex:t.pts-e.pts}),this.captionPackets_.forEach(function(t){t.type<2&&this.dispatchCea608Packet(t)},this),this.captionPackets_.length=0,this.ccStreams_.forEach(function(t){t.flush()},this)):this.ccStreams_.forEach(function(t){t.flush()},this)},Ut.prototype.reset=function(){this.latestDts_=null,this.ignoreNextEqualDts_=!1,this.numSameDts_=0,this.activeCea608Channel_=[null,null],this.ccStreams_.forEach(function(t){t.reset()})},Ut.prototype.dispatchCea608Packet=function(t){this.setsChannel1Active(t)?this.activeCea608Channel_[t.type]=0:this.setsChannel2Active(t)&&(this.activeCea608Channel_[t.type]=1),null!==this.activeCea608Channel_[t.type]&&this.ccStreams_[(t.type<<1)+this.activeCea608Channel_[t.type]].push(t)},Ut.prototype.setsChannel1Active=function(t){return 4096==(30720&t.ccData)},Ut.prototype.setsChannel2Active=function(t){return 6144==(30720&t.ccData)};var Lt={42:225,92:233,94:237,95:243,96:250,123:231,124:247,125:209,126:241,127:9608,304:174,305:176,306:189,307:191,308:8482,309:162,310:163,311:9834,312:224,313:160,314:232,315:226,316:234,317:238,318:244,319:251,544:193,545:201,546:211,547:218,548:220,549:252,550:8216,551:161,552:42,553:39,554:8212,555:169,556:8480,557:8226,558:8220,559:8221,560:192,561:194,562:199,563:200,564:202,565:203,566:235,567:206,568:207,569:239,570:212,571:217,572:249,573:219,574:171,575:187,800:195,801:227,802:205,803:204,804:236,805:210,806:242,807:213,808:245,809:123,810:125,811:92,812:94,813:95,814:124,815:126,816:196,817:228,818:214,819:246,820:223,821:165,822:164,823:9474,824:197,825:229,826:216,827:248,828:9484,829:9488,830:9492,831:9496},At=function(t){return null===t?"":(t=Lt[t]||t,String.fromCharCode(t))},Et=[4352,4384,4608,4640,5376,5408,5632,5664,5888,5920,4096,4864,4896,5120,5152],Ot=function(){for(var t=[],e=15;e--;)t.push("");return t},Ct=function t(e,i){t.prototype.init.call(this),this.field_=e||0,this.dataChannel_=i||0,this.name_="CC"+(1+(this.field_<<1|this.dataChannel_)),this.setConstants(),this.reset(),this.push=function(t){var e,i,n,r,a;if((e=32639&t.ccData)!==this.lastControlCode_){if(4096==(61440&e)?this.lastControlCode_=e:e!==this.PADDING_&&(this.lastControlCode_=null),n=e>>>8,r=255&e,e!==this.PADDING_)if(e===this.RESUME_CAPTION_LOADING_)this.mode_="popOn";else if(e===this.END_OF_CAPTION_)this.mode_="popOn",this.clearFormatting(t.pts),this.flushDisplayed(t.pts),i=this.displayed_,this.displayed_=this.nonDisplayed_,this.nonDisplayed_=i,this.startPts_=t.pts;else if(e===this.ROLL_UP_2_ROWS_)this.rollUpRows_=2,this.setRollUp(t.pts);else if(e===this.ROLL_UP_3_ROWS_)this.rollUpRows_=3,this.setRollUp(t.pts);else if(e===this.ROLL_UP_4_ROWS_)this.rollUpRows_=4,this.setRollUp(t.pts);else if(e===this.CARRIAGE_RETURN_)this.clearFormatting(t.pts),this.flushDisplayed(t.pts),this.shiftRowsUp_(),this.startPts_=t.pts;else if(e===this.BACKSPACE_)"popOn"===this.mode_?this.nonDisplayed_[this.row_]=this.nonDisplayed_[this.row_].slice(0,-1):this.displayed_[this.row_]=this.displayed_[this.row_].slice(0,-1);else if(e===this.ERASE_DISPLAYED_MEMORY_)this.flushDisplayed(t.pts),this.displayed_=Ot();else if(e===this.ERASE_NON_DISPLAYED_MEMORY_)this.nonDisplayed_=Ot();else if(e===this.RESUME_DIRECT_CAPTIONING_)"paintOn"!==this.mode_&&(this.flushDisplayed(t.pts),this.displayed_=Ot()),this.mode_="paintOn",this.startPts_=t.pts;else if(this.isSpecialCharacter(n,r))a=At((n=(3&n)<<8)|r),this[this.mode_](t.pts,a),this.column_++;else if(this.isExtCharacter(n,r))"popOn"===this.mode_?this.nonDisplayed_[this.row_]=this.nonDisplayed_[this.row_].slice(0,-1):this.displayed_[this.row_]=this.displayed_[this.row_].slice(0,-1),a=At((n=(3&n)<<8)|r),this[this.mode_](t.pts,a),this.column_++;else if(this.isMidRowCode(n,r))this.clearFormatting(t.pts),this[this.mode_](t.pts," "),this.column_++,14==(14&r)&&this.addFormatting(t.pts,["i"]),1==(1&r)&&this.addFormatting(t.pts,["u"]);else if(this.isOffsetControlCode(n,r))this.column_+=3&r;else if(this.isPAC(n,r)){var s=Et.indexOf(7968&e);"rollUp"===this.mode_&&(s-this.rollUpRows_+1<0&&(s=this.rollUpRows_-1),this.setRollUp(t.pts,s)),s!==this.row_&&(this.clearFormatting(t.pts),this.row_=s),1&r&&-1===this.formatting_.indexOf("u")&&this.addFormatting(t.pts,["u"]),16==(16&e)&&(this.column_=4*((14&e)>>1)),this.isColorPAC(r)&&14==(14&r)&&this.addFormatting(t.pts,["i"])}else this.isNormalChar(n)&&(0===r&&(r=null),a=At(n),a+=At(r),this[this.mode_](t.pts,a),this.column_+=a.length)}else this.lastControlCode_=null}};Ct.prototype=new J,Ct.prototype.flushDisplayed=function(t){var e=this.displayed_.map(function(t){try{return t.trim()}catch(t){return console.error("Skipping malformed caption."),""}}).join("\n").replace(/^\n+|\n+$/g,"");e.length&&this.trigger("data",{startPts:this.startPts_,endPts:t,text:e,stream:this.name_})},Ct.prototype.reset=function(){this.mode_="popOn",this.topRow_=0,this.startPts_=0,this.displayed_=Ot(),this.nonDisplayed_=Ot(),this.lastControlCode_=null,this.column_=0,this.row_=14,this.rollUpRows_=2,this.formatting_=[]},Ct.prototype.setConstants=function(){0===this.dataChannel_?(this.BASE_=16,this.EXT_=17,this.CONTROL_=(20|this.field_)<<8,this.OFFSET_=23):1===this.dataChannel_&&(this.BASE_=24,this.EXT_=25,this.CONTROL_=(28|this.field_)<<8,this.OFFSET_=31),this.PADDING_=0,this.RESUME_CAPTION_LOADING_=32|this.CONTROL_,this.END_OF_CAPTION_=47|this.CONTROL_,this.ROLL_UP_2_ROWS_=37|this.CONTROL_,this.ROLL_UP_3_ROWS_=38|this.CONTROL_,this.ROLL_UP_4_ROWS_=39|this.CONTROL_,this.CARRIAGE_RETURN_=45|this.CONTROL_,this.RESUME_DIRECT_CAPTIONING_=41|this.CONTROL_,this.BACKSPACE_=33|this.CONTROL_,this.ERASE_DISPLAYED_MEMORY_=44|this.CONTROL_,this.ERASE_NON_DISPLAYED_MEMORY_=46|this.CONTROL_},Ct.prototype.isSpecialCharacter=function(t,e){return t===this.EXT_&&e>=48&&e<=63},Ct.prototype.isExtCharacter=function(t,e){return(t===this.EXT_+1||t===this.EXT_+2)&&e>=32&&e<=63},Ct.prototype.isMidRowCode=function(t,e){return t===this.EXT_&&e>=32&&e<=47},Ct.prototype.isOffsetControlCode=function(t,e){return t===this.OFFSET_&&e>=33&&e<=35},Ct.prototype.isPAC=function(t,e){return t>=this.BASE_&&t<this.BASE_+8&&e>=64&&e<=127},Ct.prototype.isColorPAC=function(t){return t>=64&&t<=79||t>=96&&t<=127},Ct.prototype.isNormalChar=function(t){return t>=32&&t<=127},Ct.prototype.setRollUp=function(t,e){if("rollUp"!==this.mode_&&(this.row_=14,this.mode_="rollUp",this.flushDisplayed(t),this.nonDisplayed_=Ot(),this.displayed_=Ot()),void 0!==e&&e!==this.row_)for(var i=0;i<this.rollUpRows_;i++)this.displayed_[e-i]=this.displayed_[this.row_-i],this.displayed_[this.row_-i]="";void 0===e&&(e=this.row_),this.topRow_=e-this.rollUpRows_+1},Ct.prototype.addFormatting=function(t,e){this.formatting_=this.formatting_.concat(e);var i=e.reduce(function(t,e){return t+"<"+e+">"},"");this[this.mode_](t,i)},Ct.prototype.clearFormatting=function(t){if(this.formatting_.length){var e=this.formatting_.reverse().reduce(function(t,e){return t+"</"+e+">"},"");this.formatting_=[],this[this.mode_](t,e)}},Ct.prototype.popOn=function(t,e){var i=this.nonDisplayed_[this.row_];i+=e,this.nonDisplayed_[this.row_]=i},Ct.prototype.rollUp=function(t,e){var i=this.displayed_[this.row_];i+=e,this.displayed_[this.row_]=i},Ct.prototype.shiftRowsUp_=function(){var t;for(t=0;t<this.topRow_;t++)this.displayed_[t]="";for(t=this.row_+1;t<15;t++)this.displayed_[t]="";for(t=this.topRow_;t<this.row_;t++)this.displayed_[t]=this.displayed_[t+1];this.displayed_[this.row_]=""},Ct.prototype.paintOn=function(t,e){var i=this.displayed_[this.row_];i+=e,this.displayed_[this.row_]=i};var It={CaptionStream:Ut,Cea608Stream:Ct},Dt={H264_STREAM_TYPE:27,ADTS_STREAM_TYPE:15,METADATA_STREAM_TYPE:21},Pt=function(t,e){var i=1;for(t>e&&(i=-1);Math.abs(e-t)>4294967296;)t+=8589934592*i;return t},Rt=function t(e){var i,n;t.prototype.init.call(this),this.type_=e,this.push=function(t){t.type===this.type_&&(void 0===n&&(n=t.dts),t.dts=Pt(t.dts,n),t.pts=Pt(t.pts,n),i=t.dts,this.trigger("data",t))},this.flush=function(){n=i,this.trigger("done")},this.discontinuity=function(){n=void 0,i=void 0}};Rt.prototype=new J;var xt,Mt=Rt,Bt=function(t,e,i){var n,r="";for(n=e;n<i;n++)r+="%"+("00"+t[n].toString(16)).slice(-2);return r},Nt=function(t,e,i){return decodeURIComponent(Bt(t,e,i))},qt=function(t){return t[0]<<21|t[1]<<14|t[2]<<7|t[3]},Ft={TXXX:function(t){var e;if(3===t.data[0]){for(e=1;e<t.data.length;e++)if(0===t.data[e]){t.description=Nt(t.data,1,e),t.value=Nt(t.data,e+1,t.data.length).replace(/\0*$/,"");break}t.data=t.value}},WXXX:function(t){var e;if(3===t.data[0])for(e=1;e<t.data.length;e++)if(0===t.data[e]){t.description=Nt(t.data,1,e),t.url=Nt(t.data,e+1,t.data.length);break}},PRIV:function(t){var e,i;for(e=0;e<t.data.length;e++)if(0===t.data[e]){t.owner=(i=t.data,unescape(Bt(i,0,e)));break}t.privateData=t.data.subarray(e+1),t.data=t.privateData}};(xt=function(t){var e,i={debug:!(!t||!t.debug),descriptor:t&&t.descriptor},n=0,r=[],a=0;if(xt.prototype.init.call(this),this.dispatchType=Dt.METADATA_STREAM_TYPE.toString(16),i.descriptor)for(e=0;e<i.descriptor.length;e++)this.dispatchType+=("00"+i.descriptor[e].toString(16)).slice(-2);this.push=function(t){var e,s,o,u,d;if("timed-metadata"===t.type)if(t.dataAlignmentIndicator&&(a=0,r.length=0),0===r.length&&(t.data.length<10||t.data[0]!=="I".charCodeAt(0)||t.data[1]!=="D".charCodeAt(0)||t.data[2]!=="3".charCodeAt(0)))i.debug&&console.log("Skipping unrecognized metadata packet");else if(r.push(t),a+=t.data.byteLength,1===r.length&&(n=qt(t.data.subarray(6,10)),n+=10),!(a<n)){for(e={data:new Uint8Array(n),frames:[],pts:r[0].pts,dts:r[0].dts},d=0;d<n;)e.data.set(r[0].data.subarray(0,n-d),d),d+=r[0].data.byteLength,a-=r[0].data.byteLength,r.shift();s=10,64&e.data[5]&&(s+=4,s+=qt(e.data.subarray(10,14)),n-=qt(e.data.subarray(16,20)));do{if((o=qt(e.data.subarray(s+4,s+8)))<1)return console.log("Malformed ID3 frame encountered. Skipping metadata parsing.");if((u={id:String.fromCharCode(e.data[s],e.data[s+1],e.data[s+2],e.data[s+3]),data:e.data.subarray(s+10,s+o+10)}).key=u.id,Ft[u.id]&&(Ft[u.id](u),"com.apple.streaming.transportStreamTimestamp"===u.owner)){var l=u.data,c=(1&l[3])<<30|l[4]<<22|l[5]<<14|l[6]<<6|l[7]>>>2;c*=4,c+=3&l[7],u.timeStamp=c,void 0===e.pts&&void 0===e.dts&&(e.pts=u.timeStamp,e.dts=u.timeStamp),this.trigger("timestamp",u)}e.frames.push(u),s+=10,s+=o}while(s<n);this.trigger("data",e)}}}).prototype=new J;var Gt,Vt,Ht,jt=xt,zt=Mt;(Gt=function(){var t=new Uint8Array(188),e=0;Gt.prototype.init.call(this),this.push=function(i){var n,r=0,a=188;for(e?((n=new Uint8Array(i.byteLength+e)).set(t.subarray(0,e)),n.set(i,e),e=0):n=i;a<n.byteLength;)71!==n[r]||71!==n[a]?(r++,a++):(this.trigger("data",n.subarray(r,a)),r+=188,a+=188);r<n.byteLength&&(t.set(n.subarray(r),0),e=n.byteLength-r)},this.flush=function(){188===e&&71===t[0]&&(this.trigger("data",t),e=0),this.trigger("done")}}).prototype=new J,(Vt=function(){var t,e,i,n;Vt.prototype.init.call(this),n=this,this.packetsWaitingForPmt=[],this.programMapTable=void 0,t=function(t,n){var r=0;n.payloadUnitStartIndicator&&(r+=t[r]+1),"pat"===n.type?e(t.subarray(r),n):i(t.subarray(r),n)},e=function(t,e){e.section_number=t[7],e.last_section_number=t[8],n.pmtPid=(31&t[10])<<8|t[11],e.pmtPid=n.pmtPid},i=function(t,e){var i,r;if(1&t[5]){for(n.programMapTable={video:null,audio:null,"timed-metadata":{}},i=3+((15&t[1])<<8|t[2])-4,r=12+((15&t[10])<<8|t[11]);r<i;){var a=t[r],s=(31&t[r+1])<<8|t[r+2];a===Dt.H264_STREAM_TYPE&&null===n.programMapTable.video?n.programMapTable.video=s:a===Dt.ADTS_STREAM_TYPE&&null===n.programMapTable.audio?n.programMapTable.audio=s:a===Dt.METADATA_STREAM_TYPE&&(n.programMapTable["timed-metadata"][s]=a),r+=5+((15&t[r+3])<<8|t[r+4])}e.programMapTable=n.programMapTable}},this.push=function(e){var i={},n=4;if(i.payloadUnitStartIndicator=!!(64&e[1]),i.pid=31&e[1],i.pid<<=8,i.pid|=e[2],(48&e[3])>>>4>1&&(n+=e[n]+1),0===i.pid)i.type="pat",t(e.subarray(n),i),this.trigger("data",i);else if(i.pid===this.pmtPid)for(i.type="pmt",t(e.subarray(n),i),this.trigger("data",i);this.packetsWaitingForPmt.length;)this.processPes_.apply(this,this.packetsWaitingForPmt.shift());else void 0===this.programMapTable?this.packetsWaitingForPmt.push([e,n,i]):this.processPes_(e,n,i)},this.processPes_=function(t,e,i){i.pid===this.programMapTable.video?i.streamType=Dt.H264_STREAM_TYPE:i.pid===this.programMapTable.audio?i.streamType=Dt.ADTS_STREAM_TYPE:i.streamType=this.programMapTable["timed-metadata"][i.pid],i.type="pes",i.data=t.subarray(e),this.trigger("data",i)}}).prototype=new J,Vt.STREAM_TYPES={h264:27,adts:15},(Ht=function(){var t=this,e={data:[],size:0},i={data:[],size:0},n={data:[],size:0},r=function(e,i,n){var r,a,s=new Uint8Array(e.size),o={type:i},u=0,d=0;if(e.data.length&&!(e.size<9)){for(o.trackId=e.data[0].pid,u=0;u<e.data.length;u++)a=e.data[u],s.set(a.data,d),d+=a.data.byteLength;var l,c,h;l=s,(c=o).packetLength=6+(l[4]<<8|l[5]),c.dataAlignmentIndicator=0!=(4&l[6]),192&(h=l[7])&&(c.pts=(14&l[9])<<27|(255&l[10])<<20|(254&l[11])<<12|(255&l[12])<<5|(254&l[13])>>>3,c.pts*=4,c.pts+=(6&l[13])>>>1,c.dts=c.pts,64&h&&(c.dts=(14&l[14])<<27|(255&l[15])<<20|(254&l[16])<<12|(255&l[17])<<5|(254&l[18])>>>3,c.dts*=4,c.dts+=(6&l[18])>>>1)),c.data=l.subarray(9+l[8]),r="video"===i||o.packetLength<=e.size,(n||r)&&(e.size=0,e.data.length=0),r&&t.trigger("data",o)}};Ht.prototype.init.call(this),this.push=function(a){({pat:function(){},pes:function(){var t,s;switch(a.streamType){case Dt.H264_STREAM_TYPE:case Dt.H264_STREAM_TYPE:t=e,s="video";break;case Dt.ADTS_STREAM_TYPE:t=i,s="audio";break;case Dt.METADATA_STREAM_TYPE:t=n,s="timed-metadata";break;default:return}a.payloadUnitStartIndicator&&r(t,s,!0),t.data.push(a),t.size+=a.data.byteLength},pmt:function(){var e={type:"metadata",tracks:[]},i=a.programMapTable;null!==i.video&&e.tracks.push({timelineStartInfo:{baseMediaDecodeTime:0},id:+i.video,codec:"avc",type:"video"}),null!==i.audio&&e.tracks.push({timelineStartInfo:{baseMediaDecodeTime:0},id:+i.audio,codec:"adts",type:"audio"}),t.trigger("data",e)}})[a.type]()},this.flush=function(){r(e,"video"),r(i,"audio"),r(n,"timed-metadata"),this.trigger("done")}}).prototype=new J;var Wt={PAT_PID:0,MP2T_PACKET_LENGTH:188,TransportPacketStream:Gt,TransportParseStream:Vt,ElementaryStream:Ht,TimestampRolloverStream:zt,CaptionStream:It.CaptionStream,Cea608Stream:It.Cea608Stream,MetadataStream:jt};for(var Xt in Dt)Dt.hasOwnProperty(Xt)&&(Wt[Xt]=Dt[Xt]);var Yt,$t=Wt,Kt=[96e3,88200,64e3,48e3,44100,32e3,24e3,22050,16e3,12e3,11025,8e3,7350];(Yt=function(){var t;Yt.prototype.init.call(this),this.push=function(e){var i,n,r,a,s,o,u=0,d=0;if("audio"===e.type)for(t?(a=t,(t=new Uint8Array(a.byteLength+e.data.byteLength)).set(a),t.set(e.data,a.byteLength)):t=e.data;u+5<t.length;)if(255===t[u]&&240==(246&t[u+1])){if(n=2*(1&~t[u+1]),i=(3&t[u+3])<<11|t[u+4]<<3|(224&t[u+5])>>5,o=9e4*(s=1024*(1+(3&t[u+6])))/Kt[(60&t[u+2])>>>2],r=u+i,t.byteLength<r)return;if(this.trigger("data",{pts:e.pts+d*o,dts:e.dts+d*o,sampleCount:s,audioobjecttype:1+(t[u+2]>>>6&3),channelcount:(1&t[u+2])<<2|(192&t[u+3])>>>6,samplerate:Kt[(60&t[u+2])>>>2],samplingfrequencyindex:(60&t[u+2])>>>2,samplesize:16,data:t.subarray(u+7+n,r)}),t.byteLength===r)return void(t=void 0);d++,t=t.subarray(r)}else u++},this.flush=function(){this.trigger("done")}}).prototype=new J;var Qt,Zt,Jt,te=Yt,ee=function(t){var e=t.byteLength,i=0,n=0;this.length=function(){return 8*e},this.bitsAvailable=function(){return 8*e+n},this.loadWord=function(){var r=t.byteLength-e,a=new Uint8Array(4),s=Math.min(4,e);if(0===s)throw new Error("no bytes available");a.set(t.subarray(r,r+s)),i=new DataView(a.buffer).getUint32(0),n=8*s,e-=s},this.skipBits=function(t){var r;n>t?(i<<=t,n-=t):(t-=n,t-=8*(r=Math.floor(t/8)),e-=r,this.loadWord(),i<<=t,n-=t)},this.readBits=function(t){var r=Math.min(n,t),a=i>>>32-r;return(n-=r)>0?i<<=r:e>0&&this.loadWord(),(r=t-r)>0?a<<r|this.readBits(r):a},this.skipLeadingZeros=function(){var t;for(t=0;t<n;++t)if(0!=(i&2147483648>>>t))return i<<=t,n-=t,t;return this.loadWord(),t+this.skipLeadingZeros()},this.skipUnsignedExpGolomb=function(){this.skipBits(1+this.skipLeadingZeros())},this.skipExpGolomb=function(){this.skipBits(1+this.skipLeadingZeros())},this.readUnsignedExpGolomb=function(){var t=this.skipLeadingZeros();return this.readBits(t+1)-1},this.readExpGolomb=function(){var t=this.readUnsignedExpGolomb();return 1&t?1+t>>>1:-1*(t>>>1)},this.readBoolean=function(){return 1===this.readBits(1)},this.readUnsignedByte=function(){return this.readBits(8)},this.loadWord()};(Zt=function(){var t,e,i=0;Zt.prototype.init.call(this),this.push=function(n){var r;for(e?((r=new Uint8Array(e.byteLength+n.data.byteLength)).set(e),r.set(n.data,e.byteLength),e=r):e=n.data;i<e.byteLength-3;i++)if(1===e[i+2]){t=i+5;break}for(;t<e.byteLength;)switch(e[t]){case 0:if(0!==e[t-1]){t+=2;break}if(0!==e[t-2]){t++;break}i+3!==t-2&&this.trigger("data",e.subarray(i+3,t-2));do{t++}while(1!==e[t]&&t<e.length);i=t-2,t+=3;break;case 1:if(0!==e[t-1]||0!==e[t-2]){t+=3;break}this.trigger("data",e.subarray(i+3,t-2)),i=t-2,t+=3;break;default:t+=3}e=e.subarray(i),t-=i,i=0},this.flush=function(){e&&e.byteLength>3&&this.trigger("data",e.subarray(i+3)),e=null,i=0,this.trigger("done")}}).prototype=new J,Jt={100:!0,110:!0,122:!0,244:!0,44:!0,83:!0,86:!0,118:!0,128:!0,138:!0,139:!0,134:!0},(Qt=function(){var t,e,i,n,r,a,s,o=new Zt;Qt.prototype.init.call(this),t=this,this.push=function(t){"video"===t.type&&(e=t.trackId,i=t.pts,n=t.dts,o.push(t))},o.on("data",function(s){var o={trackId:e,pts:i,dts:n,data:s};switch(31&s[0]){case 5:o.nalUnitType="slice_layer_without_partitioning_rbsp_idr";break;case 6:o.nalUnitType="sei_rbsp",o.escapedRBSP=r(s.subarray(1));break;case 7:o.nalUnitType="seq_parameter_set_rbsp",o.escapedRBSP=r(s.subarray(1)),o.config=a(o.escapedRBSP);break;case 8:o.nalUnitType="pic_parameter_set_rbsp";break;case 9:o.nalUnitType="access_unit_delimiter_rbsp"}t.trigger("data",o)}),o.on("done",function(){t.trigger("done")}),this.flush=function(){o.flush()},s=function(t,e){var i,n=8,r=8;for(i=0;i<t;i++)0!==r&&(r=(n+e.readExpGolomb()+256)%256),n=0===r?n:r},r=function(t){for(var e,i,n=t.byteLength,r=[],a=1;a<n-2;)0===t[a]&&0===t[a+1]&&3===t[a+2]?(r.push(a+2),a+=2):a++;if(0===r.length)return t;e=n-r.length,i=new Uint8Array(e);var s=0;for(a=0;a<e;s++,a++)s===r[0]&&(s++,r.shift()),i[a]=t[s];return i},a=function(t){var e,i,n,r,a,o,u,d,l,c,h,f,p,m=0,g=0,y=0,_=0,v=1;if(i=(e=new ee(t)).readUnsignedByte(),r=e.readUnsignedByte(),n=e.readUnsignedByte(),e.skipUnsignedExpGolomb(),Jt[i]&&(3===(a=e.readUnsignedExpGolomb())&&e.skipBits(1),e.skipUnsignedExpGolomb(),e.skipUnsignedExpGolomb(),e.skipBits(1),e.readBoolean()))for(h=3!==a?8:12,p=0;p<h;p++)e.readBoolean()&&s(p<6?16:64,e);if(e.skipUnsignedExpGolomb(),0===(o=e.readUnsignedExpGolomb()))e.readUnsignedExpGolomb();else if(1===o)for(e.skipBits(1),e.skipExpGolomb(),e.skipExpGolomb(),u=e.readUnsignedExpGolomb(),p=0;p<u;p++)e.skipExpGolomb();if(e.skipUnsignedExpGolomb(),e.skipBits(1),d=e.readUnsignedExpGolomb(),l=e.readUnsignedExpGolomb(),0===(c=e.readBits(1))&&e.skipBits(1),e.skipBits(1),e.readBoolean()&&(m=e.readUnsignedExpGolomb(),g=e.readUnsignedExpGolomb(),y=e.readUnsignedExpGolomb(),_=e.readUnsignedExpGolomb()),e.readBoolean()&&e.readBoolean()){switch(e.readUnsignedByte()){case 1:f=[1,1];break;case 2:f=[12,11];break;case 3:f=[10,11];break;case 4:f=[16,11];break;case 5:f=[40,33];break;case 6:f=[24,11];break;case 7:f=[20,11];break;case 8:f=[32,11];break;case 9:f=[80,33];break;case 10:f=[18,11];break;case 11:f=[15,11];break;case 12:f=[64,33];break;case 13:f=[160,99];break;case 14:f=[4,3];break;case 15:f=[3,2];break;case 16:f=[2,1];break;case 255:f=[e.readUnsignedByte()<<8|e.readUnsignedByte(),e.readUnsignedByte()<<8|e.readUnsignedByte()]}f&&(v=f[0]/f[1])}return{profileIdc:i,levelIdc:n,profileCompatibility:r,width:Math.ceil((16*(d+1)-2*m-2*g)*v),height:(2-c)*(l+1)*16-2*y-2*_}}}).prototype=new J;var ie,ne={H264Stream:Qt,NalByteStream:Zt},re=function(t){return t[0]==="I".charCodeAt(0)&&t[1]==="D".charCodeAt(0)&&t[2]==="3".charCodeAt(0)},ae=function(t,e){var i=t[e+6]<<21|t[e+7]<<14|t[e+8]<<7|t[e+9];return(16&t[e+5])>>4?i+20:i+10},se=function(t,e){var i=(224&t[e+5])>>5,n=t[e+4]<<3;return 6144&t[e+3]|n|i};(ie=function(){var t=new Uint8Array,e=0;ie.prototype.init.call(this),this.setTimestamp=function(t){e=t},this.push=function(i){var n,r,a,s,o=0,u=0;for(t.length?(s=t.length,(t=new Uint8Array(i.byteLength+s)).set(t.subarray(0,s)),t.set(i,s)):t=i;t.length-u>=3;)if(t[u]!=="I".charCodeAt(0)||t[u+1]!=="D".charCodeAt(0)||t[u+2]!=="3".charCodeAt(0))if(255!=(255&t[u])||240!=(240&t[u+1]))u++;else{if(t.length-u<7)break;if(u+(o=se(t,u))>t.length)break;a={type:"audio",data:t.subarray(u,u+o),pts:e,dts:e},this.trigger("data",a),u+=o}else{if(t.length-u<10)break;if(u+(o=ae(t,u))>t.length)break;r={type:"timed-metadata",data:t.subarray(u,u+o)},this.trigger("data",r),u+=o}n=t.length-u,t=n>0?t.subarray(u):new Uint8Array}}).prototype=new J;var oe,ue,de,le,ce=ie,he=ne.H264Stream,fe=re,pe=["audioobjecttype","channelcount","samplerate","samplingfrequencyindex","samplesize"],me=["width","height","profileIdc","levelIdc","profileCompatibility"],ge=function(t,e){var i;if(t.length!==e.length)return!1;for(i=0;i<t.length;i++)if(t[i]!==e[i])return!1;return!0};(ue=function(t,e){var i=[],n=0,r=0,a=0,s=1/0;e=e||{},ue.prototype.init.call(this),this.push=function(e){vt(t,e),t&&pe.forEach(function(i){t[i]=e[i]}),i.push(e)},this.setEarliestDts=function(e){r=e-t.timelineStartInfo.baseMediaDecodeTime},this.setVideoBaseMediaDecodeTime=function(t){s=t},this.setAudioAppendStart=function(t){a=t},this.flush=function(){var o,u,d,l;0!==i.length?(o=pt(i,t,r),t.baseMediaDecodeTime=_t(t,e.keepOriginalTimestamps),ft(t,o,a,s),t.samples=mt(o),d=j.mdat(gt(o)),i=[],u=j.moof(n,[t]),l=new Uint8Array(u.byteLength+d.byteLength),n++,l.set(u),l.set(d,u.byteLength),yt(t),this.trigger("data",{track:t,boxes:l}),this.trigger("done","AudioSegmentStream")):this.trigger("done","AudioSegmentStream")}}).prototype=new J,(oe=function(t,e){var i,n,r=0,a=[],s=[];e=e||{},oe.prototype.init.call(this),delete t.minPTS,this.gopCache_=[],this.push=function(e){vt(t,e),"seq_parameter_set_rbsp"!==e.nalUnitType||i||(i=e.config,t.sps=[e.data],me.forEach(function(e){t[e]=i[e]},this)),"pic_parameter_set_rbsp"!==e.nalUnitType||n||(n=e.data,t.pps=[e.data]),a.push(e)},this.flush=function(){for(var i,n,o,u,d,l;a.length&&"access_unit_delimiter_rbsp"!==a[0].nalUnitType;)a.shift();if(0===a.length)return this.resetStream_(),void this.trigger("done","VideoSegmentStream");if(i=et(a),(o=it(i))[0][0].keyFrame||((n=this.getGopForFusion_(a[0],t))?(o.unshift(n),o.byteLength+=n.byteLength,o.nalCount+=n.nalCount,o.pts=n.pts,o.dts=n.dts,o.duration+=n.duration):o=nt(o)),s.length){var c;if(!(c=e.alignGopsAtEnd?this.alignGopsAtEnd_(o):this.alignGopsAtStart_(o)))return this.gopCache_.unshift({gop:o.pop(),pps:t.pps,sps:t.sps}),this.gopCache_.length=Math.min(6,this.gopCache_.length),a=[],this.resetStream_(),void this.trigger("done","VideoSegmentStream");yt(t),o=c}vt(t,o),t.samples=rt(o),d=j.mdat(at(o)),t.baseMediaDecodeTime=_t(t,e.keepOriginalTimestamps),this.trigger("processedGopsInfo",o.map(function(t){return{pts:t.pts,dts:t.dts,byteLength:t.byteLength}})),this.gopCache_.unshift({gop:o.pop(),pps:t.pps,sps:t.sps}),this.gopCache_.length=Math.min(6,this.gopCache_.length),a=[],this.trigger("baseMediaDecodeTime",t.baseMediaDecodeTime),this.trigger("timelineStartInfo",t.timelineStartInfo),u=j.moof(r,[t]),l=new Uint8Array(u.byteLength+d.byteLength),r++,l.set(u),l.set(d,u.byteLength),this.trigger("data",{track:t,boxes:l}),this.resetStream_(),this.trigger("done","VideoSegmentStream")},this.resetStream_=function(){yt(t),i=void 0,n=void 0},this.getGopForFusion_=function(e){var i,n,r,a,s,o=1/0;for(s=0;s<this.gopCache_.length;s++)r=(a=this.gopCache_[s]).gop,t.pps&&ge(t.pps[0],a.pps[0])&&t.sps&&ge(t.sps[0],a.sps[0])&&(r.dts<t.timelineStartInfo.dts||(i=e.dts-r.dts-r.duration)>=-1e4&&i<=45e3&&(!n||o>i)&&(n=a,o=i));return n?n.gop:null},this.alignGopsAtStart_=function(t){var e,i,n,r,a,o,u,d;for(a=t.byteLength,o=t.nalCount,u=t.duration,e=i=0;e<s.length&&i<t.length&&(n=s[e],r=t[i],n.pts!==r.pts);)r.pts>n.pts?e++:(i++,a-=r.byteLength,o-=r.nalCount,u-=r.duration);return 0===i?t:i===t.length?null:((d=t.slice(i)).byteLength=a,d.duration=u,d.nalCount=o,d.pts=d[0].pts,d.dts=d[0].dts,d)},this.alignGopsAtEnd_=function(t){var e,i,n,r,a,o,u;for(e=s.length-1,i=t.length-1,a=null,o=!1;e>=0&&i>=0;){if(n=s[e],r=t[i],n.pts===r.pts){o=!0;break}n.pts>r.pts?e--:(e===s.length-1&&(a=i),i--)}if(!o&&null===a)return null;if(0===(u=o?i:a))return t;var d=t.slice(u),l=d.reduce(function(t,e){return t.byteLength+=e.byteLength,t.duration+=e.duration,t.nalCount+=e.nalCount,t},{byteLength:0,duration:0,nalCount:0});return d.byteLength=l.byteLength,d.duration=l.duration,d.nalCount=l.nalCount,d.pts=d[0].pts,d.dts=d[0].dts,d},this.alignGopsWith=function(t){s=t}}).prototype=new J,(le=function(t,e){this.numberOfTracks=0,this.metadataStream=e,void 0!==(t=t||{}).remux?this.remuxTracks=!!t.remux:this.remuxTracks=!0,"boolean"==typeof t.keepOriginalTimestamps&&(this.keepOriginalTimestamps=t.keepOriginalTimestamps),this.pendingTracks=[],this.videoTrack=null,this.pendingBoxes=[],this.pendingCaptions=[],this.pendingMetadata=[],this.pendingBytes=0,this.emittedTracks=0,le.prototype.init.call(this),this.push=function(t){return t.text?this.pendingCaptions.push(t):t.frames?this.pendingMetadata.push(t):(this.pendingTracks.push(t.track),this.pendingBoxes.push(t.boxes),this.pendingBytes+=t.boxes.byteLength,"video"===t.track.type&&(this.videoTrack=t.track),void("audio"===t.track.type&&(this.audioTrack=t.track)))}}).prototype=new J,le.prototype.flush=function(t){var e,i,n,r,a=0,s={captions:[],captionStreams:{},metadata:[],info:{}},o=0;if(this.pendingTracks.length<this.numberOfTracks){if("VideoSegmentStream"!==t&&"AudioSegmentStream"!==t)return;if(this.remuxTracks)return;if(0===this.pendingTracks.length)return this.emittedTracks++,void(this.emittedTracks>=this.numberOfTracks&&(this.trigger("done"),this.emittedTracks=0))}for(this.videoTrack?(o=this.videoTrack.timelineStartInfo.pts,me.forEach(function(t){s.info[t]=this.videoTrack[t]},this)):this.audioTrack&&(o=this.audioTrack.timelineStartInfo.pts,pe.forEach(function(t){s.info[t]=this.audioTrack[t]},this)),1===this.pendingTracks.length?s.type=this.pendingTracks[0].type:s.type="combined",this.emittedTracks+=this.pendingTracks.length,n=j.initSegment(this.pendingTracks),s.initSegment=new Uint8Array(n.byteLength),s.initSegment.set(n),s.data=new Uint8Array(this.pendingBytes),r=0;r<this.pendingBoxes.length;r++)s.data.set(this.pendingBoxes[r],a),a+=this.pendingBoxes[r].byteLength;for(r=0;r<this.pendingCaptions.length;r++)(e=this.pendingCaptions[r]).startTime=e.startPts,this.keepOriginalTimestamps||(e.startTime-=o),e.startTime/=9e4,e.endTime=e.endPts,this.keepOriginalTimestamps||(e.endTime-=o),e.endTime/=9e4,s.captionStreams[e.stream]=!0,s.captions.push(e);for(r=0;r<this.pendingMetadata.length;r++)(i=this.pendingMetadata[r]).cueTime=i.pts,this.keepOriginalTimestamps||(i.cueTime-=o),i.cueTime/=9e4,s.metadata.push(i);s.metadata.dispatchType=this.metadataStream.dispatchType,this.pendingTracks.length=0,this.videoTrack=null,this.pendingBoxes.length=0,this.pendingCaptions.length=0,this.pendingBytes=0,this.pendingMetadata.length=0,this.trigger("data",s),this.emittedTracks>=this.numberOfTracks&&(this.trigger("done"),this.emittedTracks=0)},(de=function(t){var e,i,n=this,r=!0;de.prototype.init.call(this),t=t||{},this.baseMediaDecodeTime=t.baseMediaDecodeTime||0,this.transmuxPipeline_={},this.setupAacPipeline=function(){var e={};this.transmuxPipeline_=e,e.type="aac",e.metadataStream=new $t.MetadataStream,e.aacStream=new ce,e.audioTimestampRolloverStream=new $t.TimestampRolloverStream("audio"),e.timedMetadataTimestampRolloverStream=new $t.TimestampRolloverStream("timed-metadata"),e.adtsStream=new te,e.coalesceStream=new le(t,e.metadataStream),e.headOfPipeline=e.aacStream,e.aacStream.pipe(e.audioTimestampRolloverStream).pipe(e.adtsStream),e.aacStream.pipe(e.timedMetadataTimestampRolloverStream).pipe(e.metadataStream).pipe(e.coalesceStream),e.metadataStream.on("timestamp",function(t){e.aacStream.setTimestamp(t.timeStamp)}),e.aacStream.on("data",function(r){"timed-metadata"!==r.type||e.audioSegmentStream||(i=i||{timelineStartInfo:{baseMediaDecodeTime:n.baseMediaDecodeTime},codec:"adts",type:"audio"},e.coalesceStream.numberOfTracks++,e.audioSegmentStream=new ue(i,t),e.adtsStream.pipe(e.audioSegmentStream).pipe(e.coalesceStream))}),e.coalesceStream.on("data",this.trigger.bind(this,"data")),e.coalesceStream.on("done",this.trigger.bind(this,"done"))},this.setupTsPipeline=function(){var r={};this.transmuxPipeline_=r,r.type="ts",r.metadataStream=new $t.MetadataStream,r.packetStream=new $t.TransportPacketStream,r.parseStream=new $t.TransportParseStream,r.elementaryStream=new $t.ElementaryStream,r.videoTimestampRolloverStream=new $t.TimestampRolloverStream("video"),r.audioTimestampRolloverStream=new $t.TimestampRolloverStream("audio"),r.timedMetadataTimestampRolloverStream=new $t.TimestampRolloverStream("timed-metadata"),r.adtsStream=new te,r.h264Stream=new he,r.captionStream=new $t.CaptionStream,r.coalesceStream=new le(t,r.metadataStream),r.headOfPipeline=r.packetStream,r.packetStream.pipe(r.parseStream).pipe(r.elementaryStream),r.elementaryStream.pipe(r.videoTimestampRolloverStream).pipe(r.h264Stream),r.elementaryStream.pipe(r.audioTimestampRolloverStream).pipe(r.adtsStream),r.elementaryStream.pipe(r.timedMetadataTimestampRolloverStream).pipe(r.metadataStream).pipe(r.coalesceStream),r.h264Stream.pipe(r.captionStream).pipe(r.coalesceStream),r.elementaryStream.on("data",function(a){var s;if("metadata"===a.type){for(s=a.tracks.length;s--;)e||"video"!==a.tracks[s].type?i||"audio"!==a.tracks[s].type||((i=a.tracks[s]).timelineStartInfo.baseMediaDecodeTime=n.baseMediaDecodeTime):(e=a.tracks[s]).timelineStartInfo.baseMediaDecodeTime=n.baseMediaDecodeTime;e&&!r.videoSegmentStream&&(r.coalesceStream.numberOfTracks++,r.videoSegmentStream=new oe(e,t),r.videoSegmentStream.on("timelineStartInfo",function(t){i&&(i.timelineStartInfo=t,r.audioSegmentStream.setEarliestDts(t.dts))}),r.videoSegmentStream.on("processedGopsInfo",n.trigger.bind(n,"gopInfo")),r.videoSegmentStream.on("baseMediaDecodeTime",function(t){i&&r.audioSegmentStream.setVideoBaseMediaDecodeTime(t)}),r.h264Stream.pipe(r.videoSegmentStream).pipe(r.coalesceStream)),i&&!r.audioSegmentStream&&(r.coalesceStream.numberOfTracks++,r.audioSegmentStream=new ue(i,t),r.adtsStream.pipe(r.audioSegmentStream).pipe(r.coalesceStream))}}),r.coalesceStream.on("data",this.trigger.bind(this,"data")),r.coalesceStream.on("done",this.trigger.bind(this,"done"))},this.setBaseMediaDecodeTime=function(n){var r=this.transmuxPipeline_;t.keepOriginalTimestamps||(this.baseMediaDecodeTime=n),i&&(i.timelineStartInfo.dts=void 0,i.timelineStartInfo.pts=void 0,yt(i),t.keepOriginalTimestamps||(i.timelineStartInfo.baseMediaDecodeTime=n),r.audioTimestampRolloverStream&&r.audioTimestampRolloverStream.discontinuity()),e&&(r.videoSegmentStream&&(r.videoSegmentStream.gopCache_=[],r.videoTimestampRolloverStream.discontinuity()),e.timelineStartInfo.dts=void 0,e.timelineStartInfo.pts=void 0,yt(e),r.captionStream.reset(),t.keepOriginalTimestamps||(e.timelineStartInfo.baseMediaDecodeTime=n)),r.timedMetadataTimestampRolloverStream&&r.timedMetadataTimestampRolloverStream.discontinuity()},this.setAudioAppendStart=function(t){i&&this.transmuxPipeline_.audioSegmentStream.setAudioAppendStart(t)},this.alignGopsWith=function(t){e&&this.transmuxPipeline_.videoSegmentStream&&this.transmuxPipeline_.videoSegmentStream.alignGopsWith(t)},this.push=function(t){if(r){var e=fe(t);e&&"aac"!==this.transmuxPipeline_.type?this.setupAacPipeline():e||"ts"===this.transmuxPipeline_.type||this.setupTsPipeline(),r=!1}this.transmuxPipeline_.headOfPipeline.push(t)},this.flush=function(){r=!0,this.transmuxPipeline_.headOfPipeline.flush()},this.resetCaptions=function(){this.transmuxPipeline_.captionStream&&this.transmuxPipeline_.captionStream.reset()}}).prototype=new J;var ye,_e,ve={Transmuxer:de,VideoSegmentStream:oe,AudioSegmentStream:ue,AUDIO_PROPERTIES:pe,VIDEO_PROPERTIES:me},be=W.parseType,Te=function(t){return new Date(1e3*t-20828448e5)},Se=function(t){return{isLeading:(12&t[0])>>>2,dependsOn:3&t[0],isDependedOn:(192&t[1])>>>6,hasRedundancy:(48&t[1])>>>4,paddingValue:(14&t[1])>>>1,isNonSyncSample:1&t[1],degradationPriority:t[2]<<8|t[3]}},ke={avc1:function(t){var e=new DataView(t.buffer,t.byteOffset,t.byteLength);return{dataReferenceIndex:e.getUint16(6),width:e.getUint16(24),height:e.getUint16(26),horizresolution:e.getUint16(28)+e.getUint16(30)/16,vertresolution:e.getUint16(32)+e.getUint16(34)/16,frameCount:e.getUint16(40),depth:e.getUint16(74),config:ye(t.subarray(78,t.byteLength))}},avcC:function(t){var e,i,n,r,a=new DataView(t.buffer,t.byteOffset,t.byteLength),s={configurationVersion:t[0],avcProfileIndication:t[1],profileCompatibility:t[2],avcLevelIndication:t[3],lengthSizeMinusOne:3&t[4],sps:[],pps:[]},o=31&t[5];for(n=6,r=0;r<o;r++)i=a.getUint16(n),n+=2,s.sps.push(new Uint8Array(t.subarray(n,n+i))),n+=i;for(e=t[n],n++,r=0;r<e;r++)i=a.getUint16(n),n+=2,s.pps.push(new Uint8Array(t.subarray(n,n+i))),n+=i;return s},btrt:function(t){var e=new DataView(t.buffer,t.byteOffset,t.byteLength);return{bufferSizeDB:e.getUint32(0),maxBitrate:e.getUint32(4),avgBitrate:e.getUint32(8)}},esds:function(t){return{version:t[0],flags:new Uint8Array(t.subarray(1,4)),esId:t[6]<<8|t[7],streamPriority:31&t[8],decoderConfig:{objectProfileIndication:t[11],streamType:t[12]>>>2&63,bufferSize:t[13]<<16|t[14]<<8|t[15],maxBitrate:t[16]<<24|t[17]<<16|t[18]<<8|t[19],avgBitrate:t[20]<<24|t[21]<<16|t[22]<<8|t[23],decoderConfigDescriptor:{tag:t[24],length:t[25],audioObjectType:t[26]>>>3&31,samplingFrequencyIndex:(7&t[26])<<1|t[27]>>>7&1,channelConfiguration:t[27]>>>3&15}}}},ftyp:function(t){for(var e=new DataView(t.buffer,t.byteOffset,t.byteLength),i={majorBrand:be(t.subarray(0,4)),minorVersion:e.getUint32(4),compatibleBrands:[]},n=8;n<t.byteLength;)i.compatibleBrands.push(be(t.subarray(n,n+4))),n+=4;return i},dinf:function(t){return{boxes:ye(t)}},dref:function(t){return{version:t[0],flags:new Uint8Array(t.subarray(1,4)),dataReferences:ye(t.subarray(8))}},hdlr:function(t){var e={version:new DataView(t.buffer,t.byteOffset,t.byteLength).getUint8(0),flags:new Uint8Array(t.subarray(1,4)),handlerType:be(t.subarray(8,12)),name:""},i=8;for(i=24;i<t.byteLength;i++){if(0===t[i]){i++;break}e.name+=String.fromCharCode(t[i])}return e.name=decodeURIComponent(escape(e.name)),e},mdat:function(t){return{byteLength:t.byteLength,nals:function(t){var e,i,n=new DataView(t.buffer,t.byteOffset,t.byteLength),r=[];for(e=0;e+4<t.length;e+=i)if(i=n.getUint32(e),e+=4,i<=0)r.push("<span style='color:red;'>MALFORMED DATA</span>");else switch(31&t[e]){case 1:r.push("slice_layer_without_partitioning_rbsp");break;case 5:r.push("slice_layer_without_partitioning_rbsp_idr");break;case 6:r.push("sei_rbsp");break;case 7:r.push("seq_parameter_set_rbsp");break;case 8:r.push("pic_parameter_set_rbsp");break;case 9:r.push("access_unit_delimiter_rbsp");break;default:r.push("UNKNOWN NAL - "+t[e]&31)}return r}(t)}},mdhd:function(t){var e,i=new DataView(t.buffer,t.byteOffset,t.byteLength),n=4,r={version:i.getUint8(0),flags:new Uint8Array(t.subarray(1,4)),language:""};return 1===r.version?(n+=4,r.creationTime=Te(i.getUint32(n)),n+=8,r.modificationTime=Te(i.getUint32(n)),n+=4,r.timescale=i.getUint32(n),n+=8,r.duration=i.getUint32(n)):(r.creationTime=Te(i.getUint32(n)),n+=4,r.modificationTime=Te(i.getUint32(n)),n+=4,r.timescale=i.getUint32(n),n+=4,r.duration=i.getUint32(n)),n+=4,e=i.getUint16(n),r.language+=String.fromCharCode(96+(e>>10)),r.language+=String.fromCharCode(96+((992&e)>>5)),r.language+=String.fromCharCode(96+(31&e)),r},mdia:function(t){return{boxes:ye(t)}},mfhd:function(t){return{version:t[0],flags:new Uint8Array(t.subarray(1,4)),sequenceNumber:t[4]<<24|t[5]<<16|t[6]<<8|t[7]}},minf:function(t){return{boxes:ye(t)}},mp4a:function(t){var e=new DataView(t.buffer,t.byteOffset,t.byteLength),i={dataReferenceIndex:e.getUint16(6),channelcount:e.getUint16(16),samplesize:e.getUint16(18),samplerate:e.getUint16(24)+e.getUint16(26)/65536};return t.byteLength>28&&(i.streamDescriptor=ye(t.subarray(28))[0]),i},moof:function(t){return{boxes:ye(t)}},moov:function(t){return{boxes:ye(t)}},mvex:function(t){return{boxes:ye(t)}},mvhd:function(t){var e=new DataView(t.buffer,t.byteOffset,t.byteLength),i=4,n={version:e.getUint8(0),flags:new Uint8Array(t.subarray(1,4))};return 1===n.version?(i+=4,n.creationTime=Te(e.getUint32(i)),i+=8,n.modificationTime=Te(e.getUint32(i)),i+=4,n.timescale=e.getUint32(i),i+=8,n.duration=e.getUint32(i)):(n.creationTime=Te(e.getUint32(i)),i+=4,n.modificationTime=Te(e.getUint32(i)),i+=4,n.timescale=e.getUint32(i),i+=4,n.duration=e.getUint32(i)),i+=4,n.rate=e.getUint16(i)+e.getUint16(i+2)/16,i+=4,n.volume=e.getUint8(i)+e.getUint8(i+1)/8,i+=2,i+=2,i+=8,n.matrix=new Uint32Array(t.subarray(i,i+36)),i+=36,i+=24,n.nextTrackId=e.getUint32(i),n},pdin:function(t){var e=new DataView(t.buffer,t.byteOffset,t.byteLength);return{version:e.getUint8(0),flags:new Uint8Array(t.subarray(1,4)),rate:e.getUint32(4),initialDelay:e.getUint32(8)}},sdtp:function(t){var e,i={version:t[0],flags:new Uint8Array(t.subarray(1,4)),samples:[]};for(e=4;e<t.byteLength;e++)i.samples.push({dependsOn:(48&t[e])>>4,isDependedOn:(12&t[e])>>2,hasRedundancy:3&t[e]});return i},sidx:function(t){var e,i=new DataView(t.buffer,t.byteOffset,t.byteLength),n={version:t[0],flags:new Uint8Array(t.subarray(1,4)),references:[],referenceId:i.getUint32(4),timescale:i.getUint32(8),earliestPresentationTime:i.getUint32(12),firstOffset:i.getUint32(16)},r=i.getUint16(22);for(e=24;r;e+=12,r--)n.references.push({referenceType:(128&t[e])>>>7,referencedSize:2147483647&i.getUint32(e),subsegmentDuration:i.getUint32(e+4),startsWithSap:!!(128&t[e+8]),sapType:(112&t[e+8])>>>4,sapDeltaTime:268435455&i.getUint32(e+8)});return n},smhd:function(t){return{version:t[0],flags:new Uint8Array(t.subarray(1,4)),balance:t[4]+t[5]/256}},stbl:function(t){return{boxes:ye(t)}},stco:function(t){var e,i=new DataView(t.buffer,t.byteOffset,t.byteLength),n={version:t[0],flags:new Uint8Array(t.subarray(1,4)),chunkOffsets:[]},r=i.getUint32(4);for(e=8;r;e+=4,r--)n.chunkOffsets.push(i.getUint32(e));return n},stsc:function(t){var e,i=new DataView(t.buffer,t.byteOffset,t.byteLength),n=i.getUint32(4),r={version:t[0],flags:new Uint8Array(t.subarray(1,4)),sampleToChunks:[]};for(e=8;n;e+=12,n--)r.sampleToChunks.push({firstChunk:i.getUint32(e),samplesPerChunk:i.getUint32(e+4),sampleDescriptionIndex:i.getUint32(e+8)});return r},stsd:function(t){return{version:t[0],flags:new Uint8Array(t.subarray(1,4)),sampleDescriptions:ye(t.subarray(8))}},stsz:function(t){var e,i=new DataView(t.buffer,t.byteOffset,t.byteLength),n={version:t[0],flags:new Uint8Array(t.subarray(1,4)),sampleSize:i.getUint32(4),entries:[]};for(e=12;e<t.byteLength;e+=4)n.entries.push(i.getUint32(e));return n},stts:function(t){var e,i=new DataView(t.buffer,t.byteOffset,t.byteLength),n={version:t[0],flags:new Uint8Array(t.subarray(1,4)),timeToSamples:[]},r=i.getUint32(4);for(e=8;r;e+=8,r--)n.timeToSamples.push({sampleCount:i.getUint32(e),sampleDelta:i.getUint32(e+4)});return n},styp:function(t){return ke.ftyp(t)},tfdt:function(t){var e={version:t[0],flags:new Uint8Array(t.subarray(1,4)),baseMediaDecodeTime:t[4]<<24|t[5]<<16|t[6]<<8|t[7]};return 1===e.version&&(e.baseMediaDecodeTime*=Math.pow(2,32),e.baseMediaDecodeTime+=t[8]<<24|t[9]<<16|t[10]<<8|t[11]),e},tfhd:function(t){var e,i=new DataView(t.buffer,t.byteOffset,t.byteLength),n={version:t[0],flags:new Uint8Array(t.subarray(1,4)),trackId:i.getUint32(4)},r=1&n.flags[2],a=2&n.flags[2],s=8&n.flags[2],o=16&n.flags[2],u=32&n.flags[2],d=65536&n.flags[0],l=131072&n.flags[0];return e=8,r&&(e+=4,n.baseDataOffset=i.getUint32(12),e+=4),a&&(n.sampleDescriptionIndex=i.getUint32(e),e+=4),s&&(n.defaultSampleDuration=i.getUint32(e),e+=4),o&&(n.defaultSampleSize=i.getUint32(e),e+=4),u&&(n.defaultSampleFlags=i.getUint32(e)),d&&(n.durationIsEmpty=!0),!r&&l&&(n.baseDataOffsetIsMoof=!0),n},tkhd:function(t){var e=new DataView(t.buffer,t.byteOffset,t.byteLength),i=4,n={version:e.getUint8(0),flags:new Uint8Array(t.subarray(1,4))};return 1===n.version?(i+=4,n.creationTime=Te(e.getUint32(i)),i+=8,n.modificationTime=Te(e.getUint32(i)),i+=4,n.trackId=e.getUint32(i),i+=4,i+=8,n.duration=e.getUint32(i)):(n.creationTime=Te(e.getUint32(i)),i+=4,n.modificationTime=Te(e.getUint32(i)),i+=4,n.trackId=e.getUint32(i),i+=4,i+=4,n.duration=e.getUint32(i)),i+=4,i+=8,n.layer=e.getUint16(i),i+=2,n.alternateGroup=e.getUint16(i),i+=2,n.volume=e.getUint8(i)+e.getUint8(i+1)/8,i+=2,i+=2,n.matrix=new Uint32Array(t.subarray(i,i+36)),i+=36,n.width=e.getUint16(i)+e.getUint16(i+2)/16,i+=4,n.height=e.getUint16(i)+e.getUint16(i+2)/16,n},traf:function(t){return{boxes:ye(t)}},trak:function(t){return{boxes:ye(t)}},trex:function(t){var e=new DataView(t.buffer,t.byteOffset,t.byteLength);return{version:t[0],flags:new Uint8Array(t.subarray(1,4)),trackId:e.getUint32(4),defaultSampleDescriptionIndex:e.getUint32(8),defaultSampleDuration:e.getUint32(12),defaultSampleSize:e.getUint32(16),sampleDependsOn:3&t[20],sampleIsDependedOn:(192&t[21])>>6,sampleHasRedundancy:(48&t[21])>>4,samplePaddingValue:(14&t[21])>>1,sampleIsDifferenceSample:!!(1&t[21]),sampleDegradationPriority:e.getUint16(22)}},trun:function(t){var e,i={version:t[0],flags:new Uint8Array(t.subarray(1,4)),samples:[]},n=new DataView(t.buffer,t.byteOffset,t.byteLength),r=1&i.flags[2],a=4&i.flags[2],s=1&i.flags[1],o=2&i.flags[1],u=4&i.flags[1],d=8&i.flags[1],l=n.getUint32(4),c=8;for(r&&(i.dataOffset=n.getInt32(c),c+=4),a&&l&&(e={flags:Se(t.subarray(c,c+4))},c+=4,s&&(e.duration=n.getUint32(c),c+=4),o&&(e.size=n.getUint32(c),c+=4),d&&(e.compositionTimeOffset=n.getUint32(c),c+=4),i.samples.push(e),l--);l--;)e={},s&&(e.duration=n.getUint32(c),c+=4),o&&(e.size=n.getUint32(c),c+=4),u&&(e.flags=Se(t.subarray(c,c+4)),c+=4),d&&(e.compositionTimeOffset=n.getUint32(c),c+=4),i.samples.push(e);return i},"url ":function(t){return{version:t[0],flags:new Uint8Array(t.subarray(1,4))}},vmhd:function(t){var e=new DataView(t.buffer,t.byteOffset,t.byteLength);return{version:t[0],flags:new Uint8Array(t.subarray(1,4)),graphicsmode:e.getUint16(4),opcolor:new Uint16Array([e.getUint16(6),e.getUint16(8),e.getUint16(10)])}}},we={inspect:ye=function(t){for(var e,i,n,r,a,s=0,o=[],u=new ArrayBuffer(t.length),d=new Uint8Array(u),l=0;l<t.length;++l)d[l]=t[l];for(e=new DataView(u);s<t.byteLength;)i=e.getUint32(s),n=be(t.subarray(s+4,s+8)),r=i>1?s+i:t.byteLength,(a=(ke[n]||function(t){return{data:t}})(t.subarray(s+8,r))).size=i,a.type=n,o.push(a),s=r;return o},textify:_e=function(t,e){var i;return e=e||0,i=new Array(2*e+1).join(" "),t.map(function(t,n){return i+t.type+"\n"+Object.keys(t).filter(function(t){return"type"!==t&&"boxes"!==t}).map(function(e){var n=i+"  "+e+": ",r=t[e];if(r instanceof Uint8Array||r instanceof Uint32Array){var a=Array.prototype.slice.call(new Uint8Array(r.buffer,r.byteOffset,r.byteLength)).map(function(t){return" "+("00"+t.toString(16)).slice(-2)}).join("").match(/.{1,24}/g);return a?1===a.length?n+"<"+a.join("").slice(1)+">":n+"<\n"+a.map(function(t){return i+"  "+t}).join("\n")+"\n"+i+"  >":n+"<>"}return n+JSON.stringify(r,null,2).split("\n").map(function(t,e){return 0===e?t:i+"  "+t}).join("\n")}).join("\n")+(t.boxes?"\n"+_e(t.boxes,e+1):"")}).join("\n")},parseTfdt:ke.tfdt,parseHdlr:ke.hdlr,parseTfhd:ke.tfhd,parseTrun:ke.trun},Ue=kt,Le=It.CaptionStream,Ae=function(t,e){for(var i=t,n=0;n<e.length;n++){var r=e[n];if(i<r.size)return r;i-=r.size}return null},Ee=function(t,e){var i=W.findBox(t,["moof","traf"]),n={},r=[];return W.findBox(t,["mdat"]).forEach(function(t,e){var n=i[e];r.push({mdat:t,traf:n})}),r.forEach(function(t){var i,r=t.mdat,a=t.traf,s=W.findBox(a,["tfhd"]),o=we.parseTfhd(s[0]),u=o.trackId,d=W.findBox(a,["tfdt"]),l=d.length>0?we.parseTfdt(d[0]).baseMediaDecodeTime:0,c=W.findBox(a,["trun"]);e===u&&c.length>0&&(i=function(t,e,i){var n,r,a,s,o=new DataView(t.buffer,t.byteOffset,t.byteLength),u=[];for(r=0;r+4<t.length;r+=a)if(a=o.getUint32(r),r+=4,!(a<=0))switch(31&t[r]){case 6:var d=t.subarray(r+1,r+1+a),l=Ae(r,e);n={nalUnitType:"sei_rbsp",size:a,data:d,escapedRBSP:Ue(d),trackId:i},l?(n.pts=l.pts,n.dts=l.dts,s=l):(n.pts=s.pts,n.dts=s.dts),u.push(n)}return u}(r,function(t,e,i){var n=e,r=i.defaultSampleDuration||0,a=i.defaultSampleSize||0,s=i.trackId,o=[];return t.forEach(function(t){var e=we.parseTrun(t).samples;e.forEach(function(t){void 0===t.duration&&(t.duration=r),void 0===t.size&&(t.size=a),t.trackId=s,t.dts=n,void 0===t.compositionTimeOffset&&(t.compositionTimeOffset=0),t.pts=n+t.compositionTimeOffset,n+=t.duration}),o=o.concat(e)}),o}(c,l,o),u),n[u]||(n[u]=[]),n[u]=n[u].concat(i))}),n},Oe={generator:j,probe:W,Transmuxer:ve.Transmuxer,AudioSegmentStream:ve.AudioSegmentStream,VideoSegmentStream:ve.VideoSegmentStream,CaptionParser:function(){var t,e,i,n,r,a=!1;this.isInitialized=function(){return a},this.init=function(){t=new Le,a=!0,t.on("data",function(t){t.startTime=t.startPts/n,t.endTime=t.endPts/n,r.captions.push(t),r.captionStreams[t.stream]=!0})},this.isNewInit=function(t,e){return!(t&&0===t.length||e&&"object"==typeof e&&0===Object.keys(e).length||i===t[0]&&n===e[i])},this.parse=function(t,a,s){var o;if(!this.isInitialized())return null;if(!a||!s)return null;if(this.isNewInit(a,s))i=a[0],n=s[i];else if(!i||!n)return e.push(t),null;for(;e.length>0;){var u=e.shift();this.parse(u,a,s)}return null!==(o=function(t,e,i){return e?{seiNals:Ee(t,e)[e],timescale:i}:null}(t,i,n))&&o.seiNals?(this.pushNals(o.seiNals),this.flushStream(),r):null},this.pushNals=function(e){if(!this.isInitialized()||!e||0===e.length)return null;e.forEach(function(e){t.push(e)})},this.flushStream=function(){if(!this.isInitialized())return null;t.flush()},this.clearParsedCaptions=function(){r.captions=[],r.captionStreams={}},this.resetCaptionStream=function(){if(!this.isInitialized())return null;t.reset()},this.clearAllCaptions=function(){this.clearParsedCaptions(),this.resetCaptionStream()},this.reset=function(){e=[],i=null,n=null,r?this.clearParsedCaptions():r={captions:[],captionStreams:{}},this.resetCaptionStream()},this.reset()}},Ce=function(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")},Ie=function(){function t(t,e){for(var i=0;i<e.length;i++){var n=e[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(t,n.key,n)}}return function(e,i,n){return i&&t(e.prototype,i),n&&t(e,n),e}}(),De=function(){function t(e,i){Ce(this,t),this.options=i||{},this.self=e,this.init()}return Ie(t,[{key:"init",value:function(){var t,e;this.transmuxer&&this.transmuxer.dispose(),this.transmuxer=new Oe.Transmuxer(this.options),t=this.self,(e=this.transmuxer).on("data",function(e){var i=e.initSegment;e.initSegment={data:i.buffer,byteOffset:i.byteOffset,byteLength:i.byteLength};var n=e.data;e.data=n.buffer,t.postMessage({action:"data",segment:e,byteOffset:n.byteOffset,byteLength:n.byteLength},[e.data])}),e.captionStream&&e.captionStream.on("data",function(e){t.postMessage({action:"caption",data:e})}),e.on("done",function(e){t.postMessage({action:"done"})}),e.on("gopInfo",function(e){t.postMessage({action:"gopInfo",gopInfo:e})})}},{key:"push",value:function(t){var e=new Uint8Array(t.data,t.byteOffset,t.byteLength);this.transmuxer.push(e)}},{key:"reset",value:function(){this.init()}},{key:"setTimestampOffset",value:function(t){var e=t.timestampOffset||0;this.transmuxer.setBaseMediaDecodeTime(Math.round(9e4*e))}},{key:"setAudioAppendStart",value:function(t){this.transmuxer.setAudioAppendStart(Math.ceil(9e4*t.appendStart))}},{key:"flush",value:function(t){this.transmuxer.flush()}},{key:"resetCaptions",value:function(){this.transmuxer.resetCaptions()}},{key:"alignGopsWith",value:function(t){this.transmuxer.alignGopsWith(t.gopsToAlignWith.slice())}}]),t}();new function(t){t.onmessage=function(e){"init"===e.data.action&&e.data.options?this.messageHandlers=new De(t,e.data.options):(this.messageHandlers||(this.messageHandlers=new De(t)),e.data&&e.data.action&&"init"!==e.data.action&&this.messageHandlers[e.data.action]&&this.messageHandlers[e.data.action](e.data))}}(i)}()}),Vt={videoCodec:"avc1",videoObjectTypeIndicator:".4d400d",audioProfile:"2"},Ht=function(t){return t.map(function(t){return t.replace(/avc1\.(\d+)\.(\d+)/i,function(t,e,i){return"avc1."+("00"+Number(e).toString(16)).slice(-2)+"00"+("00"+Number(i).toString(16)).slice(-2)})})},jt=function(){var t,e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"",i={codecCount:0};return i.codecCount=e.split(",").length,i.codecCount=i.codecCount||2,(t=/(^|\s|,)+(avc[13])([^ ,]*)/i.exec(e))&&(i.videoCodec=t[2],i.videoObjectTypeIndicator=t[3]),i.audioProfile=/(^|\s|,)+mp4a.[0-9A-Fa-f]+\.([0-9A-Fa-f]+)/i.exec(e),i.audioProfile=i.audioProfile&&i.audioProfile[2],i},zt=function(t,e,i){return t+"/"+e+'; codecs="'+i.filter(function(t){return!!t}).join(", ")+'"'},Wt=function(t,i){var n=function(t){return t.segments&&t.segments.length&&t.segments[0].map?"mp4":"mp2t"}(i),r=function(t){var e=t.attributes||{};return e.CODECS?jt(e.CODECS):Vt}(i),a=i.attributes||{},s=!0,o=!1;if(!i)return[];if(t.mediaGroups.AUDIO&&a.AUDIO){var u=t.mediaGroups.AUDIO[a.AUDIO];if(u)for(var d in o=!0,s=!1,u)if(!u[d].uri&&!u[d].playlists){s=!0;break}}o&&!r.audioProfile&&(s||(r.audioProfile=function(t,e){if(!t.mediaGroups.AUDIO||!e)return null;var i=t.mediaGroups.AUDIO[e];if(!i)return null;for(var n in i){var r=i[n];if(r.default&&r.playlists)return jt(r.playlists[0].attributes.CODECS).audioProfile}return null}(t,a.AUDIO)),r.audioProfile||(e.log.warn("Multiple audio tracks present but no audio codec string is specified. Attempting to use the default audio codec (mp4a.40.2)"),r.audioProfile=Vt.audioProfile));var l={};r.videoCodec&&(l.video=""+r.videoCodec+r.videoObjectTypeIndicator),r.audioProfile&&(l.audio="mp4a.40."+r.audioProfile);var c=zt("audio",n,[l.audio]),h=zt("video",n,[l.video]),f=zt("video",n,[l.video,l.audio]);return o?!s&&l.video?[h,c]:s||l.video?[f,c]:[c,c]:l.video?[f]:[c]},Xt=function(t){return/mp4a\.\d+.\d+/i.test(t)},Yt=function(t){return/avc1\.[\da-f]+/i.test(t)},$t=function(t,i,n){var r=null,a=null,s=0,o=[],u=[];if(!t&&!i)return e.createTimeRange();if(!t)return i.buffered;if(!i)return t.buffered;if(n)return t.buffered;if(0===t.buffered.length&&0===i.buffered.length)return e.createTimeRange();for(var d=t.buffered,l=i.buffered,c=d.length;c--;)o.push({time:d.start(c),type:"start"}),o.push({time:d.end(c),type:"end"});for(c=l.length;c--;)o.push({time:l.start(c),type:"start"}),o.push({time:l.end(c),type:"end"});for(o.sort(function(t,e){return t.time-e.time}),c=0;c<o.length;c++)"start"===o[c].type?2===++s&&(r=o[c].time):"end"===o[c].type&&1===--s&&(a=o[c].time),null!==r&&null!==a&&(u.push([r,a]),r=null,a=null);return e.createTimeRanges(u)},Kt=function(t){function i(t,n){T(this,i);var r=w(this,(i.__proto__||Object.getPrototypeOf(i)).call(this,e.EventTarget));r.timestampOffset_=0,r.pendingBuffers_=[],r.bufferUpdating_=!1,r.mediaSource_=t,r.codecs_=n,r.audioCodec_=null,r.videoCodec_=null,r.audioDisabled_=!1,r.appendAudioInitSegment_=!0,r.gopBuffer_=[],r.timeMapping_=0,r.safeAppend_=e.browser.IE_VERSION>=11;var a={remux:!1,alignGopsAtEnd:r.safeAppend_};return r.codecs_.forEach(function(t){Xt(t)?r.audioCodec_=t:Yt(t)&&(r.videoCodec_=t)}),r.transmuxer_=new Gt,r.transmuxer_.postMessage({action:"init",options:a}),r.transmuxer_.onmessage=function(t){return"data"===t.data.action?r.data_(t):"done"===t.data.action?r.done_(t):"gopInfo"===t.data.action?r.appendGopInfo_(t):void 0},Object.defineProperty(r,"timestampOffset",{get:function(){return this.timestampOffset_},set:function(t){"number"==typeof t&&t>=0&&(this.timestampOffset_=t,this.appendAudioInitSegment_=!0,this.gopBuffer_.length=0,this.timeMapping_=0,this.transmuxer_.postMessage({action:"setTimestampOffset",timestampOffset:t}))}}),Object.defineProperty(r,"appendWindowStart",{get:function(){return(this.videoBuffer_||this.audioBuffer_).appendWindowStart},set:function(t){this.videoBuffer_&&(this.videoBuffer_.appendWindowStart=t),this.audioBuffer_&&(this.audioBuffer_.appendWindowStart=t)}}),Object.defineProperty(r,"updating",{get:function(){return!!(this.bufferUpdating_||!this.audioDisabled_&&this.audioBuffer_&&this.audioBuffer_.updating||this.videoBuffer_&&this.videoBuffer_.updating)}}),Object.defineProperty(r,"buffered",{get:function(){return $t(this.videoBuffer_,this.audioBuffer_,this.audioDisabled_)}}),r}return k(i,t),S(i,[{key:"data_",value:function(t){var e=t.data.segment;e.data=new Uint8Array(e.data,t.data.byteOffset,t.data.byteLength),e.initSegment=new Uint8Array(e.initSegment.data,e.initSegment.byteOffset,e.initSegment.byteLength),function(t,e,i){var n=e.player_;if(i.captions&&i.captions.length)for(var r in t.inbandTextTracks_||(t.inbandTextTracks_={}),i.captionStreams)if(!t.inbandTextTracks_[r]){n.tech_.trigger({type:"usage",name:"hls-608"});var a=n.textTracks().getTrackById(r);t.inbandTextTracks_[r]=a||n.addRemoteTextTrack({kind:"captions",id:r,label:r},!1).track}i.metadata&&i.metadata.length&&!t.metadataTrack_&&(t.metadataTrack_=n.addRemoteTextTrack({kind:"metadata",label:"Timed Metadata"},!1).track,t.metadataTrack_.inBandMetadataTrackDispatchType=i.metadata.dispatchType)}(this,this.mediaSource_,e),this.pendingBuffers_.push(e)}},{key:"done_",value:function(t){"closed"!==this.mediaSource_.readyState?this.processPendingSegments_():this.pendingBuffers_.length=0}},{key:"createRealSourceBuffers_",value:function(){var t=this,e=["audio","video"];e.forEach(function(i){if(t[i+"Codec_"]&&!t[i+"Buffer_"]){var n=null;if(t.mediaSource_[i+"Buffer_"])(n=t.mediaSource_[i+"Buffer_"]).updating=!1;else{var r=i+'/mp4;codecs="'+t[i+"Codec_"]+'"';n=function(t,e){var i=t.addSourceBuffer(e),n=Object.create(null);n.updating=!1,n.realBuffer_=i;var r=function(t){"function"==typeof i[t]?n[t]=function(){return i[t].apply(i,arguments)}:void 0===n[t]&&Object.defineProperty(n,t,{get:function(){return i[t]},set:function(e){return i[t]=e}})};for(var a in i)r(a);return n}(t.mediaSource_.nativeMediaSource_,r),t.mediaSource_[i+"Buffer_"]=n}t[i+"Buffer_"]=n,["update","updatestart","updateend"].forEach(function(r){n.addEventListener(r,function(){if("audio"!==i||!t.audioDisabled_)return"updateend"===r&&(t[i+"Buffer_"].updating=!1),e.every(function(e){return!("audio"!==e||!t.audioDisabled_)||(i===e||!t[e+"Buffer_"]||!t[e+"Buffer_"].updating)})?t.trigger(r):void 0})})}})}},{key:"appendBuffer",value:function(t){if(this.bufferUpdating_=!0,this.audioBuffer_&&this.audioBuffer_.buffered.length){var e=this.audioBuffer_.buffered;this.transmuxer_.postMessage({action:"setAudioAppendStart",appendStart:e.end(e.length-1)})}this.videoBuffer_&&this.transmuxer_.postMessage({action:"alignGopsWith",gopsToAlignWith:function(t,e,i){if(void 0===e||null===e||!t.length)return[];var n=Math.ceil(9e4*(e-i+3)),r=void 0;for(r=0;r<t.length&&!(t[r].pts>n);r++);return t.slice(r)}(this.gopBuffer_,this.mediaSource_.player_?this.mediaSource_.player_.currentTime():null,this.timeMapping_)}),this.transmuxer_.postMessage({action:"push",data:t.buffer,byteOffset:t.byteOffset,byteLength:t.byteLength},[t.buffer]),this.transmuxer_.postMessage({action:"flush"})}},{key:"appendGopInfo_",value:function(t){this.gopBuffer_=function(t,e,i){if(!e.length)return t;if(i)return e.slice();for(var n=e[0].pts,r=0;r<t.length&&!(t[r].pts>=n);r++);return t.slice(0,r).concat(e)}(this.gopBuffer_,t.data.gopInfo,this.safeAppend_)}},{key:"remove",value:function(t,e){if(this.videoBuffer_&&(this.videoBuffer_.updating=!0,this.videoBuffer_.remove(t,e),this.gopBuffer_=function(t,e,i,n){for(var r=Math.ceil(9e4*(e-n)),a=Math.ceil(9e4*(i-n)),s=t.slice(),o=t.length;o--&&!(t[o].pts<=a););if(-1===o)return s;for(var u=o+1;u--&&!(t[u].pts<=r););return u=Math.max(u,0),s.splice(u,o-u+1),s}(this.gopBuffer_,t,e,this.timeMapping_)),!this.audioDisabled_&&this.audioBuffer_&&(this.audioBuffer_.updating=!0,this.audioBuffer_.remove(t,e)),At(t,e,this.metadataTrack_),this.inbandTextTracks_)for(var i in this.inbandTextTracks_)At(t,e,this.inbandTextTracks_[i])}},{key:"processPendingSegments_",value:function(){var t={video:{segments:[],bytes:0},audio:{segments:[],bytes:0},captions:[],metadata:[]};t=this.pendingBuffers_.reduce(function(t,e){var i=e.type,n=e.data,r=e.initSegment;return t[i].segments.push(n),t[i].bytes+=n.byteLength,t[i].initSegment=r,e.captions&&(t.captions=t.captions.concat(e.captions)),e.info&&(t[i].info=e.info),e.metadata&&(t.metadata=t.metadata.concat(e.metadata)),t},t),this.videoBuffer_||this.audioBuffer_||(0===t.video.bytes&&(this.videoCodec_=null),0===t.audio.bytes&&(this.audioCodec_=null),this.createRealSourceBuffers_()),t.audio.info&&this.mediaSource_.trigger({type:"audioinfo",info:t.audio.info}),t.video.info&&this.mediaSource_.trigger({type:"videoinfo",info:t.video.info}),this.appendAudioInitSegment_&&(!this.audioDisabled_&&this.audioBuffer_&&(t.audio.segments.unshift(t.audio.initSegment),t.audio.bytes+=t.audio.initSegment.byteLength),this.appendAudioInitSegment_=!1);var e=!1;this.videoBuffer_&&t.video.bytes?(t.video.segments.unshift(t.video.initSegment),t.video.bytes+=t.video.initSegment.byteLength,this.concatAndAppendSegments_(t.video,this.videoBuffer_)):!this.videoBuffer_||!this.audioDisabled_&&this.audioBuffer_||(e=!0),Ot(this,t.captions,t.metadata),!this.audioDisabled_&&this.audioBuffer_&&this.concatAndAppendSegments_(t.audio,this.audioBuffer_),this.pendingBuffers_.length=0,e&&this.trigger("updateend"),this.bufferUpdating_=!1}},{key:"concatAndAppendSegments_",value:function(t,e){var i=0,n=void 0;if(t.bytes){n=new Uint8Array(t.bytes),t.segments.forEach(function(t){n.set(t,i),i+=t.byteLength});try{e.updating=!0,e.appendBuffer(n)}catch(t){this.mediaSource_.player_&&this.mediaSource_.player_.error({code:-3,type:"APPEND_BUFFER_ERR",message:t.message,originalError:t})}}}},{key:"abort",value:function(){this.videoBuffer_&&this.videoBuffer_.abort(),!this.audioDisabled_&&this.audioBuffer_&&this.audioBuffer_.abort(),this.transmuxer_&&this.transmuxer_.postMessage({action:"reset"}),this.pendingBuffers_.length=0,this.bufferUpdating_=!1}}]),i}(e.EventTarget),Qt=function(t){function i(){T(this,i);var t=w(this,(i.__proto__||Object.getPrototypeOf(i)).call(this)),n=void 0;for(n in t.nativeMediaSource_=new c.MediaSource,t.nativeMediaSource_)n in i.prototype||"function"!=typeof t.nativeMediaSource_[n]||(t[n]=t.nativeMediaSource_[n].bind(t.nativeMediaSource_));return t.duration_=NaN,Object.defineProperty(t,"duration",{get:function(){return this.duration_===1/0?this.duration_:this.nativeMediaSource_.duration},set:function(t){this.duration_=t,t===1/0||(this.nativeMediaSource_.duration=t)}}),Object.defineProperty(t,"seekable",{get:function(){return this.duration_===1/0?e.createTimeRanges([[0,this.nativeMediaSource_.duration]]):this.nativeMediaSource_.seekable}}),Object.defineProperty(t,"readyState",{get:function(){return this.nativeMediaSource_.readyState}}),Object.defineProperty(t,"activeSourceBuffers",{get:function(){return this.activeSourceBuffers_}}),t.sourceBuffers=[],t.activeSourceBuffers_=[],t.updateActiveSourceBuffers_=function(){if(t.activeSourceBuffers_.length=0,1===t.sourceBuffers.length){var e=t.sourceBuffers[0];return e.appendAudioInitSegment_=!0,e.audioDisabled_=!e.audioCodec_,void t.activeSourceBuffers_.push(e)}for(var i=!1,n=!0,r=0;r<t.player_.audioTracks().length;r++){var a=t.player_.audioTracks()[r];if(a.enabled&&"main"!==a.kind){i=!0,n=!1;break}}t.sourceBuffers.forEach(function(e,r){if(e.appendAudioInitSegment_=!0,e.videoCodec_&&e.audioCodec_)e.audioDisabled_=i;else if(e.videoCodec_&&!e.audioCodec_)e.audioDisabled_=!0,n=!1;else if(!e.videoCodec_&&e.audioCodec_&&(e.audioDisabled_=r?n:!n,e.audioDisabled_))return;t.activeSourceBuffers_.push(e)})},t.onPlayerMediachange_=function(){t.sourceBuffers.forEach(function(t){t.appendAudioInitSegment_=!0})},t.onHlsReset_=function(){t.sourceBuffers.forEach(function(t){t.transmuxer_&&t.transmuxer_.postMessage({action:"resetCaptions"})})},t.onHlsSegmentTimeMapping_=function(e){t.sourceBuffers.forEach(function(t){return t.timeMapping_=e.mapping})},["sourceopen","sourceclose","sourceended"].forEach(function(t){this.nativeMediaSource_.addEventListener(t,this.trigger.bind(this))},t),t.on("sourceopen",function(i){var n=d.querySelector('[src="'+t.url_+'"]');n&&(t.player_=e(n.parentNode),t.player_&&(t.player_.tech_.on("hls-reset",t.onHlsReset_),t.player_.tech_.on("hls-segment-time-mapping",t.onHlsSegmentTimeMapping_),t.player_.audioTracks&&t.player_.audioTracks()&&(t.player_.audioTracks().on("change",t.updateActiveSourceBuffers_),t.player_.audioTracks().on("addtrack",t.updateActiveSourceBuffers_),t.player_.audioTracks().on("removetrack",t.updateActiveSourceBuffers_)),t.player_.on("mediachange",t.onPlayerMediachange_)))}),t.on("sourceended",function(e){for(var i=Et(t.duration),n=0;n<t.sourceBuffers.length;n++){var r=t.sourceBuffers[n],a=r.metadataTrack_&&r.metadataTrack_.cues;a&&a.length&&(a[a.length-1].endTime=i)}}),t.on("sourceclose",function(t){this.sourceBuffers.forEach(function(t){t.transmuxer_&&t.transmuxer_.terminate()}),this.sourceBuffers.length=0,this.player_&&(this.player_.audioTracks&&this.player_.audioTracks()&&(this.player_.audioTracks().off("change",this.updateActiveSourceBuffers_),this.player_.audioTracks().off("addtrack",this.updateActiveSourceBuffers_),this.player_.audioTracks().off("removetrack",this.updateActiveSourceBuffers_)),this.player_.el_&&this.player_.off("mediachange",this.onPlayerMediachange_),this.player_.tech_&&this.player_.tech_.el_&&(this.player_.tech_.off("hls-reset",this.onHlsReset_),this.player_.tech_.off("hls-segment-time-mapping",this.onHlsSegmentTimeMapping_)))}),t}return k(i,t),S(i,[{key:"addSeekableRange_",value:function(t,e){var i=void 0;if(this.duration!==1/0)throw(i=new Error("MediaSource.addSeekableRange() can only be invoked when the duration is Infinity")).name="InvalidStateError",i.code=11,i;(e>this.nativeMediaSource_.duration||isNaN(this.nativeMediaSource_.duration))&&(this.nativeMediaSource_.duration=e)}},{key:"addSourceBuffer",value:function(t){var e=void 0,i=function(t){var e={type:"",parameters:{}},i=t.trim().split(";");return e.type=i.shift().trim(),i.forEach(function(t){var i=t.trim().split("=");if(i.length>1){var n=i[0].replace(/"/g,"").trim(),r=i[1].replace(/"/g,"").trim();e.parameters[n]=r}}),e}(t);if(/^(video|audio)\/mp2t$/i.test(i.type)){var n=[];i.parameters&&i.parameters.codecs&&(n=i.parameters.codecs.split(","),n=(n=Ht(n)).filter(function(t){return Xt(t)||Yt(t)})),0===n.length&&(n=["avc1.4d400d","mp4a.40.2"]),e=new Kt(this,n),0!==this.sourceBuffers.length&&(this.sourceBuffers[0].createRealSourceBuffers_(),e.createRealSourceBuffers_(),this.sourceBuffers[0].audioDisabled_=!0)}else e=this.nativeMediaSource_.addSourceBuffer(t);return this.sourceBuffers.push(e),e}}]),i}(e.EventTarget),Zt=0;e.mediaSources={};var Jt=function(t,i){var n=e.mediaSources[t];if(!n)throw new Error("Media Source not found (Video.js)");n.trigger({type:"sourceopen",swfId:i})},te=function(){return!!c.MediaSource&&!!c.MediaSource.isTypeSupported&&c.MediaSource.isTypeSupported('video/mp4;codecs="avc1.4d400d,mp4a.40.2"')},ee=function(){if(this.MediaSource={open:Jt,supportsNativeMediaSources:te},te())return new Qt;throw new Error("Cannot use create a virtual MediaSource for this video")};ee.open=Jt,ee.supportsNativeMediaSources=te;var ie={createObjectURL:function(t){var i=void 0;return t instanceof Qt?(i=c.URL.createObjectURL(t.nativeMediaSource_),t.url_=i,i):t instanceof Qt?(i="blob:vjs-media-source/"+Zt,Zt++,e.mediaSources[i]=t,i):(i=c.URL.createObjectURL(t),t.url_=i,i)}};e.MediaSource=ee,e.URL=ie;
/*! @name mpd-parser @version 0.7.0 @license Apache-2.0 */
var ne=function(t){return!!t&&"object"==typeof t},re=function t(){for(var e=arguments.length,i=new Array(e),n=0;n<e;n++)i[n]=arguments[n];return i.reduce(function(e,i){return Object.keys(i).forEach(function(n){Array.isArray(e[n])&&Array.isArray(i[n])?e[n]=e[n].concat(i[n]):ne(e[n])&&ne(i[n])?e[n]=t(e[n],i[n]):e[n]=i[n]}),e},{})},ae=function(t){return t.reduce(function(t,e){return t.concat(e)},[])},se=function(t){if(!t.length)return[];for(var e=[],i=0;i<t.length;i++)e.push(t[i]);return e},oe=function(t){var e;return(e=t.reduce(function(t,e){var i,n=e.attributes.id+(e.attributes.lang||"");t[n]?(e.segments[0].discontinuity=!0,(i=t[n].segments).push.apply(i,e.segments),e.attributes.contentProtection&&(t[n].attributes.contentProtection=e.attributes.contentProtection)):t[n]=e;return t},{}),Object.keys(e).map(function(t){return e[t]})).map(function(t){var e,i;return t.discontinuityStarts=(e=t.segments,i="discontinuity",e.reduce(function(t,e,n){return e[i]&&t.push(n),t},[])),t})},ue=function(t){var e,i=t.attributes,n=t.segments,r={attributes:(e={NAME:i.id,AUDIO:"audio",SUBTITLES:"subs",RESOLUTION:{width:i.width,height:i.height},CODECS:i.codecs,BANDWIDTH:i.bandwidth},e["PROGRAM-ID"]=1,e),uri:"",endList:"static"===(i.type||"static"),timeline:i.periodIndex,resolvedUri:"",targetDuration:i.duration,segments:n,mediaSequence:n.length?n[0].number:1};return i.contentProtection&&(r.contentProtection=i.contentProtection),r};"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self&&self;var de=function(t,e){return t(e={exports:{}},e.exports),e.exports}(function(t,e){var i,n,r,a,s;i=/^((?:[a-zA-Z0-9+\-.]+:)?)(\/\/[^\/?#]*)?((?:[^\/\?#]*\/)*.*?)??(;.*?)?(\?.*?)?(#.*?)?$/,n=/^([^\/?#]*)(.*)$/,r=/(?:\/|^)\.(?=\/)/g,a=/(?:\/|^)\.\.\/(?!\.\.\/).*?(?=\/)/g,s={buildAbsoluteURL:function(t,e,i){if(i=i||{},t=t.trim(),!(e=e.trim())){if(!i.alwaysNormalize)return t;var r=s.parseURL(t);if(!r)throw new Error("Error trying to parse base URL.");return r.path=s.normalizePath(r.path),s.buildURLFromParts(r)}var a=s.parseURL(e);if(!a)throw new Error("Error trying to parse relative URL.");if(a.scheme)return i.alwaysNormalize?(a.path=s.normalizePath(a.path),s.buildURLFromParts(a)):e;var o=s.parseURL(t);if(!o)throw new Error("Error trying to parse base URL.");if(!o.netLoc&&o.path&&"/"!==o.path[0]){var u=n.exec(o.path);o.netLoc=u[1],o.path=u[2]}o.netLoc&&!o.path&&(o.path="/");var d={scheme:o.scheme,netLoc:a.netLoc,path:null,params:a.params,query:a.query,fragment:a.fragment};if(!a.netLoc&&(d.netLoc=o.netLoc,"/"!==a.path[0]))if(a.path){var l=o.path,c=l.substring(0,l.lastIndexOf("/")+1)+a.path;d.path=s.normalizePath(c)}else d.path=o.path,a.params||(d.params=o.params,a.query||(d.query=o.query));return null===d.path&&(d.path=i.alwaysNormalize?s.normalizePath(a.path):a.path),s.buildURLFromParts(d)},parseURL:function(t){var e=i.exec(t);return e?{scheme:e[1]||"",netLoc:e[2]||"",path:e[3]||"",params:e[4]||"",query:e[5]||"",fragment:e[6]||""}:null},normalizePath:function(t){for(t=t.split("").reverse().join("").replace(r,"");t.length!==(t=t.replace(a,"")).length;);return t.split("").reverse().join("")},buildURLFromParts:function(t){return t.scheme+t.netLoc+t.path+t.params+t.query+t.fragment}},t.exports=s}),le=function(t,e){return/^[a-z]+:/i.test(e)?e:(/\/\//i.test(t)||(t=de.buildAbsoluteURL(c.location.href,t)),de.buildAbsoluteURL(t,e))},ce=function(t){var e=t.baseUrl,i=void 0===e?"":e,n=t.source,r=void 0===n?"":n,a=t.range,s=void 0===a?"":a,o={uri:r,resolvedUri:le(i||"",r)};if(s){var u=s.split("-"),d=parseInt(u[0],10),l=parseInt(u[1],10);o.byterange={length:l-d,offset:d}}return o},he=function(t,e,i){var n=t.NOW,r=t.clientOffset,a=t.availabilityStartTime,s=t.timescale,o=void 0===s?1:s,u=t.start,d=void 0===u?0:u,l=t.minimumUpdatePeriod,c=(n+r)/1e3+(void 0===l?0:l)-(a+d);return Math.ceil((c*o-e)/i)},fe=function(t,e){for(var i=t.type,n=void 0===i?"static":i,r=t.minimumUpdatePeriod,a=void 0===r?0:r,s=t.media,o=void 0===s?"":s,u=t.sourceDuration,d=t.timescale,l=void 0===d?1:d,c=t.startNumber,h=void 0===c?1:c,f=t.periodIndex,p=[],m=-1,g=0;g<e.length;g++){var y=e[g],_=y.d,v=y.r||0,b=y.t||0;m<0&&(m=b),b&&b>m&&(m=b);var T=void 0;if(v<0){var S=g+1;T=S===e.length?"dynamic"===n&&a>0&&o.indexOf("$Number$")>0?he(t,m,_):(u*l-m)/_:(e[S].t-m)/_}else T=v+1;for(var k=h+p.length+T,w=h+p.length;w<k;)p.push({number:w,duration:_/l,time:m,timeline:f}),m+=_,w++}return p},pe={static:function(t){var e=t.duration,i=t.timescale,n=void 0===i?1:i,r=t.sourceDuration;return{start:0,end:Math.ceil(r/(e/n))}},dynamic:function(t){var e=t.NOW,i=t.clientOffset,n=t.availabilityStartTime,r=t.timescale,a=void 0===r?1:r,s=t.duration,o=t.start,u=void 0===o?0:o,d=t.minimumUpdatePeriod,l=void 0===d?0:d,c=t.timeShiftBufferDepth,h=void 0===c?1/0:c,f=(e+i)/1e3,p=n+u,m=f+l-p,g=Math.ceil(m*a/s),y=Math.floor((f-p-h)*a/s),_=Math.floor((f-p)*a/s);return{start:Math.max(0,y),end:Math.min(g,_)}}},me=function(t){var e=t.type,i=void 0===e?"static":e,n=t.duration,r=t.timescale,a=void 0===r?1:r,s=t.sourceDuration,o=pe[i](t),u=function(t,e){for(var i=[],n=t;n<e;n++)i.push(n);return i}(o.start,o.end).map(function(t){return function(e,i){var n=t.duration,r=t.timescale,a=void 0===r?1:r,s=t.periodIndex,o=t.startNumber;return{number:(void 0===o?1:o)+e,duration:n/a,timeline:s,time:i*n}}}(t));if("static"===i){var d=u.length-1;u[d].duration=s-n/a*d}return u},ge=/\$([A-z]*)(?:(%0)([0-9]+)d)?\$/g,ye=function(t,e){return t.replace(ge,function(t){return function(e,i,n,r){if("$$"===e)return"$";if(void 0===t[i])return e;var a=""+t[i];return"RepresentationID"===i?a:(r=n?parseInt(r,10):1,a.length>=r?a:""+new Array(r-a.length+1).join("0")+a)}}(e))},_e=function(t,e){var i={RepresentationID:t.id,Bandwidth:t.bandwidth||0},n=t.initialization,r=void 0===n?{sourceURL:"",range:""}:n,a=ce({baseUrl:t.baseUrl,source:ye(r.sourceURL,i),range:r.range});return function(t,e){return t.duration||e?t.duration?me(t):fe(t,e):[{number:t.startNumber||1,duration:t.sourceDuration,time:0,timeline:t.periodIndex}]}(t,e).map(function(e){i.Number=e.number,i.Time=e.time;var n=ye(t.media||"",i);return{uri:n,timeline:e.timeline,duration:e.duration,resolvedUri:le(t.baseUrl||"",n),map:a,number:e.number}})},ve="INVALID_NUMBER_OF_PERIOD",be="DASH_EMPTY_MANIFEST",Te="DASH_INVALID_XML",Se="NO_BASE_URL",ke="SEGMENT_TIME_UNSPECIFIED",we="UNSUPPORTED_UTC_TIMING_SCHEME",Ue=function(t,e){var i=t.duration,n=t.segmentUrls,r=void 0===n?[]:n;if(!i&&!e||i&&e)throw new Error(ke);var a,s=r.map(function(e){return function(t,e){var i=t.baseUrl,n=t.initialization,r=void 0===n?{}:n,a=ce({baseUrl:i,source:r.sourceURL,range:r.range}),s=ce({baseUrl:i,source:e.media,range:e.mediaRange});return s.map=a,s}(t,e)});return i&&(a=me(t)),e&&(a=fe(t,e)),a.map(function(t,e){if(s[e]){var i=s[e];return i.timeline=t.timeline,i.duration=t.duration,i.number=t.number,i}}).filter(function(t){return t})},Le=function(t){var e=t.baseUrl,i=t.initialization,n=void 0===i?{}:i,r=t.sourceDuration,a=t.timescale,s=void 0===a?1:a,o=t.indexRange,u=void 0===o?"":o,d=t.duration;if(!e)throw new Error(Se);var l=ce({baseUrl:e,source:n.sourceURL,range:n.range}),c=ce({baseUrl:e,source:e,range:u});if(c.map=l,d){var h=me(t);h.length&&(c.duration=h[0].duration,c.timeline=h[0].timeline)}else r&&(c.duration=r/s,c.timeline=0);return c.number=0,[c]},Ae=function(t){var e,i,n=t.attributes,r=t.segmentInfo;if(r.template?(i=_e,e=re(n,r.template)):r.base?(i=Le,e=re(n,r.base)):r.list&&(i=Ue,e=re(n,r.list)),!i)return{attributes:n};var a=i(e,r.timeline);if(e.duration){var s=e,o=s.duration,u=s.timescale,d=void 0===u?1:u;e.duration=o/d}else a.length?e.duration=a.reduce(function(t,e){return Math.max(t,Math.ceil(e.duration))},0):e.duration=0;return{attributes:e,segments:a}},Ee=function(t,e){return se(t.childNodes).filter(function(t){return t.tagName===e})},Oe=function(t){return t.textContent.trim()},Ce=function(t){var e=/P(?:(\d*)Y)?(?:(\d*)M)?(?:(\d*)D)?(?:T(?:(\d*)H)?(?:(\d*)M)?(?:([\d.]*)S)?)?/.exec(t);if(!e)return 0;var i=e.slice(1),n=i[0],r=i[1],a=i[2],s=i[3],o=i[4],u=i[5];return 31536e3*parseFloat(n||0)+2592e3*parseFloat(r||0)+86400*parseFloat(a||0)+3600*parseFloat(s||0)+60*parseFloat(o||0)+parseFloat(u||0)},Ie={mediaPresentationDuration:function(t){return Ce(t)},availabilityStartTime:function(t){return/^\d+-\d+-\d+T\d+:\d+:\d+(\.\d+)?$/.test(e=t)&&(e+="Z"),Date.parse(e)/1e3;var e},minimumUpdatePeriod:function(t){return Ce(t)},timeShiftBufferDepth:function(t){return Ce(t)},start:function(t){return Ce(t)},width:function(t){return parseInt(t,10)},height:function(t){return parseInt(t,10)},bandwidth:function(t){return parseInt(t,10)},startNumber:function(t){return parseInt(t,10)},timescale:function(t){return parseInt(t,10)},duration:function(t){var e=parseInt(t,10);return isNaN(e)?Ce(t):e},d:function(t){return parseInt(t,10)},t:function(t){return parseInt(t,10)},r:function(t){return parseInt(t,10)},DEFAULT:function(t){return t}},De=function(t){return t&&t.attributes?se(t.attributes).reduce(function(t,e){var i=Ie[e.name]||Ie.DEFAULT;return t[e.name]=i(e.value),t},{}):{}};var Pe={"urn:uuid:1077efec-c0b2-4d02-ace3-3c1e52e2fb4b":"org.w3.clearkey","urn:uuid:edef8ba9-79d6-4ace-a3c8-27dcd51d21ed":"com.widevine.alpha","urn:uuid:9a04f079-9840-4286-ab92-e65be0885f95":"com.microsoft.playready","urn:uuid:f239e769-efa3-4850-9c16-a903c6932efb":"com.adobe.primetime"},Re=function(t,e){return e.length?ae(t.map(function(t){return e.map(function(e){return le(t,Oe(e))})})):t},xe=function(t){var e=Ee(t,"SegmentTemplate")[0],i=Ee(t,"SegmentList")[0],n=i&&Ee(i,"SegmentURL").map(function(t){return re({tag:"SegmentURL"},De(t))}),r=Ee(t,"SegmentBase")[0],a=i||e,s=a&&Ee(a,"SegmentTimeline")[0],o=i||r||e,u=o&&Ee(o,"Initialization")[0],d=e&&De(e);d&&u?d.initialization=u&&De(u):d&&d.initialization&&(d.initialization={sourceURL:d.initialization});var l={template:d,timeline:s&&Ee(s,"S").map(function(t){return De(t)}),list:i&&re(De(i),{segmentUrls:n,initialization:De(u)}),base:r&&re(De(r),{initialization:De(u)})};return Object.keys(l).forEach(function(t){l[t]||delete l[t]}),l},Me=function(t){return t.reduce(function(t,e){var i=De(e),n=Pe[i.schemeIdUri];if(n){t[n]={attributes:i};var r=Ee(e,"cenc:pssh")[0];if(r){var a=Oe(r),s=a&&function(t){for(var e=c.atob(t),i=new Uint8Array(e.length),n=0;n<e.length;n++)i[n]=e.charCodeAt(n);return i}(a);t[n].pssh=s}}return t},{})},Be=function(t,e,i){return function(n){var r=De(n),a=Re(e,Ee(n,"BaseURL")),s=Ee(n,"Role")[0],o={role:De(s)},u=re(t,r,o),d=Me(Ee(n,"ContentProtection"));Object.keys(d).length&&(u=re(u,{contentProtection:d}));var l=xe(n),c=Ee(n,"Representation"),h=re(i,l);return ae(c.map(function(t,e,i){return function(n){var r=Ee(n,"BaseURL"),a=Re(e,r),s=re(t,De(n)),o=xe(n);return a.map(function(t){return{segmentInfo:re(i,o),attributes:re(s,{baseUrl:t})}})}}(u,a,h)))}},Ne=function(t,e){void 0===e&&(e={});var i=e,n=i.manifestUri,r=void 0===n?"":n,a=i.NOW,s=void 0===a?Date.now():a,o=i.clientOffset,u=void 0===o?0:o,d=Ee(t,"Period");if(!d.length)throw new Error(ve);var l=De(t),h=Re([r],Ee(t,"BaseURL"));return l.sourceDuration=l.mediaPresentationDuration||0,l.NOW=s,l.clientOffset=u,ae(d.map(function(t,e){return function(i,n){var r=Re(e,Ee(i,"BaseURL")),a=De(i),s=parseInt(a.id,10),o=c.isNaN(s)?n:s,u=re(t,{periodIndex:o}),d=Ee(i,"AdaptationSet"),l=xe(i);return ae(d.map(Be(u,r,l)))}}(l,h)))},qe=function(t){if(""===t)throw new Error(be);var e=(new c.DOMParser).parseFromString(t,"application/xml"),i=e&&"MPD"===e.documentElement.tagName?e.documentElement:null;if(!i||i&&i.getElementsByTagName("parsererror").length>0)throw new Error(Te);return i},Fe=function(t,e){return function(t){var e;if(!t.length)return{};var i=t[0].attributes,n=i.sourceDuration,r=i.minimumUpdatePeriod,a=void 0===r?0:r,s=oe(t.filter(function(t){var e=t.attributes;return"video/mp4"===e.mimeType||"video"===e.contentType})).map(ue),o=oe(t.filter(function(t){var e=t.attributes;return"audio/mp4"===e.mimeType||"audio"===e.contentType})),u=t.filter(function(t){var e=t.attributes;return"text/vtt"===e.mimeType||"text"===e.contentType}),d={allowCache:!0,discontinuityStarts:[],segments:[],endList:!0,mediaGroups:(e={AUDIO:{},VIDEO:{}},e["CLOSED-CAPTIONS"]={},e.SUBTITLES={},e),uri:"",duration:n,playlists:s,minimumUpdatePeriod:1e3*a};return o.length&&(d.mediaGroups.AUDIO.audio=o.reduce(function(t,e){var i=e.attributes.role&&e.attributes.role.value||"main",n=e.attributes.lang||"",r="main";return n&&(r=e.attributes.lang+" ("+i+")"),t[r]&&t[r].playlists[0].attributes.BANDWIDTH>e.attributes.bandwidth?t:(t[r]={language:n,autoselect:!0,default:"main"===i,playlists:[function(t){var e,i=t.attributes,n=t.segments,r={attributes:(e={NAME:i.id,BANDWIDTH:i.bandwidth,CODECS:i.codecs},e["PROGRAM-ID"]=1,e),uri:"",endList:"static"===(i.type||"static"),timeline:i.periodIndex,resolvedUri:"",targetDuration:i.duration,segments:n,mediaSequence:n.length?n[0].number:1};return i.contentProtection&&(r.contentProtection=i.contentProtection),r}(e)],uri:""},t)},{})),u.length&&(d.mediaGroups.SUBTITLES.subs=function(t){return t.reduce(function(t,e){var i,n,r,a,s=e.attributes.lang||"text";return t[s]?t:(t[s]={language:s,default:!1,autoselect:!1,playlists:[(i=e,r=i.attributes,a=i.segments,void 0===a&&(a=[{uri:r.baseUrl,timeline:r.periodIndex,resolvedUri:r.baseUrl||"",duration:r.sourceDuration,number:0}],r.duration=r.sourceDuration),{attributes:(n={NAME:r.id,BANDWIDTH:r.bandwidth},n["PROGRAM-ID"]=1,n),uri:"",endList:"static"===(r.type||"static"),timeline:r.periodIndex,resolvedUri:r.baseUrl||"",targetDuration:r.duration,segments:a,mediaSequence:a.length?a[0].number:1})],uri:""},t)},{})}(u)),d}(Ne(qe(t),e).map(Ae))},Ge=function(t){return function(t){var e=Ee(t,"UTCTiming")[0];if(!e)return null;var i=De(e);switch(i.schemeIdUri){case"urn:mpeg:dash:utc:http-head:2014":case"urn:mpeg:dash:utc:http-head:2012":i.method="HEAD";break;case"urn:mpeg:dash:utc:http-xsdate:2014":case"urn:mpeg:dash:utc:http-iso:2014":case"urn:mpeg:dash:utc:http-xsdate:2012":case"urn:mpeg:dash:utc:http-iso:2012":i.method="GET";break;case"urn:mpeg:dash:utc:direct:2014":case"urn:mpeg:dash:utc:direct:2012":i.method="DIRECT",i.value=Date.parse(i.value);break;case"urn:mpeg:dash:utc:http-ntp:2014":case"urn:mpeg:dash:utc:ntp:2014":case"urn:mpeg:dash:utc:sntp:2014":default:throw new Error(we)}return i}(qe(t))},Ve=e.EventTarget,He=e.mergeOptions,je=function(t,e){for(var i=He(t,{duration:e.duration,minimumUpdatePeriod:e.minimumUpdatePeriod}),n=0;n<e.playlists.length;n++){var r=C(i,e.playlists[n]);r&&(i=r)}return O(e,function(t,e,n,r){if(t.playlists&&t.playlists.length){var a=t.playlists[0].uri,s=C(i,t.playlists[0]);s&&((i=s).mediaGroups[e][n][r].playlists[0]=i.playlists[a])}}),i},ze=function(t){function e(t,i,n,r){T(this,e);var a=w(this,(e.__proto__||Object.getPrototypeOf(e)).call(this));if(a.hls_=i,a.withCredentials=n,!t)throw new Error("A non-empty playlist URL or playlist is required");return a.on("minimumUpdatePeriod",function(){a.refreshXml_()}),a.on("mediaupdatetimeout",function(){a.refreshMedia_()}),"string"==typeof t?(a.srcUrl=t,a.state="HAVE_NOTHING",w(a)):(a.masterPlaylistLoader_=r,a.state="HAVE_METADATA",a.started=!0,a.media(t),c.setTimeout(function(){a.trigger("loadedmetadata")},0),a)}return k(e,Ve),S(e,[{key:"dispose",value:function(){this.stopRequest(),c.clearTimeout(this.mediaUpdateTimeout)}},{key:"stopRequest",value:function(){if(this.request){var t=this.request;this.request=null,t.onreadystatechange=null,t.abort()}}},{key:"media",value:function(t){if(!t)return this.media_;if("HAVE_NOTHING"===this.state)throw new Error("Cannot switch media playlist from "+this.state);var e=this.state;if("string"==typeof t){if(!this.master.playlists[t])throw new Error("Unknown playlist URI: "+t);t=this.master.playlists[t]}var i=!this.media_||t.uri!==this.media_.uri;this.state="HAVE_METADATA",i&&(this.media_&&this.trigger("mediachanging"),this.media_=t,this.refreshMedia_(),"HAVE_MASTER"!==e&&this.trigger("mediachange"))}},{key:"pause",value:function(){this.stopRequest(),c.clearTimeout(this.mediaUpdateTimeout),"HAVE_NOTHING"===this.state&&(this.started=!1)}},{key:"load",value:function(t){var e=this;c.clearTimeout(this.mediaUpdateTimeout);var i=this.media();if(t){var n=i?i.targetDuration/2*1e3:5e3;this.mediaUpdateTimeout=c.setTimeout(function(){return e.load()},n)}else this.started?this.trigger("loadedplaylist"):this.start()}},{key:"parseMasterXml",value:function(){var t=Fe(this.masterXml_,{manifestUri:this.srcUrl,clientOffset:this.clientOffset_});t.uri=this.srcUrl;for(var e=0;e<t.playlists.length;e++){var i="placeholder-uri-"+e;t.playlists[e].uri=i,t.playlists[i]=t.playlists[e]}return O(t,function(e,i,n,r){if(e.playlists&&e.playlists.length){var a="placeholder-uri-"+i+"-"+n+"-"+r;e.playlists[0].uri=a,t.playlists[a]=e.playlists[0]}}),I(t),D(t),t}},{key:"start",value:function(){var t=this;this.started=!0,this.request=this.hls_.xhr({uri:this.srcUrl,withCredentials:this.withCredentials},function(e,i){if(t.request){if(t.request=null,e)return t.error={status:i.status,message:"DASH playlist request error at URL: "+t.srcUrl,responseText:i.responseText,code:2},"HAVE_NOTHING"===t.state&&(t.started=!1),t.trigger("error");t.masterXml_=i.responseText,i.responseHeaders&&i.responseHeaders.date?t.masterLoaded_=Date.parse(i.responseHeaders.date):t.masterLoaded_=Date.now(),t.syncClientServerClock_(t.onClientServerClockSync_.bind(t))}})}},{key:"syncClientServerClock_",value:function(t){var e=this,i=Ge(this.masterXml_);return null===i?(this.clientOffset_=this.masterLoaded_-Date.now(),t()):"DIRECT"===i.method?(this.clientOffset_=i.value-Date.now(),t()):void(this.request=this.hls_.xhr({uri:h(this.srcUrl,i.value),method:i.method,withCredentials:this.withCredentials},function(n,r){if(e.request){if(n)return e.clientOffset_=e.masterLoaded_-Date.now(),t();var a=void 0;a="HEAD"===i.method?r.responseHeaders&&r.responseHeaders.date?Date.parse(r.responseHeaders.date):e.masterLoaded_:Date.parse(r.responseText),e.clientOffset_=a-Date.now(),t()}}))}},{key:"onClientServerClockSync_",value:function(){var t=this;this.master=this.parseMasterXml(),this.state="HAVE_MASTER",this.trigger("loadedplaylist"),this.media_||this.media(this.master.playlists[0]),c.setTimeout(function(){t.trigger("loadedmetadata")},0),this.master.minimumUpdatePeriod&&c.setTimeout(function(){t.trigger("minimumUpdatePeriod")},this.master.minimumUpdatePeriod)}},{key:"refreshXml_",value:function(){var t=this;this.request=this.hls_.xhr({uri:this.srcUrl,withCredentials:this.withCredentials},function(e,i){if(t.request){if(t.request=null,e)return t.error={status:i.status,message:"DASH playlist request error at URL: "+t.srcUrl,responseText:i.responseText,code:2},"HAVE_NOTHING"===t.state&&(t.started=!1),t.trigger("error");t.masterXml_=i.responseText;var n=t.parseMasterXml();t.master=je(t.master,n),c.setTimeout(function(){t.trigger("minimumUpdatePeriod")},t.master.minimumUpdatePeriod)}})}},{key:"refreshMedia_",value:function(){var t=this,e=void 0,i=void 0;this.masterPlaylistLoader_?(e=this.masterPlaylistLoader_.master,i=this.masterPlaylistLoader_.parseMasterXml()):(e=this.master,i=this.parseMasterXml());var n=je(e,i);n?(this.masterPlaylistLoader_?this.masterPlaylistLoader_.master=n:this.master=n,this.media_=n.playlists[this.media_.uri]):this.trigger("playlistunchanged"),this.media().endList||(this.mediaUpdateTimeout=c.setTimeout(function(){t.trigger("mediaupdatetimeout")},P(this.media(),!!n))),this.trigger("loadedplaylist")}}]),e}(),We=function(t){return e.log.debug?e.log.debug.bind(e,"VHS:",t+" >"):function(){}};function Xe(){}var Ye,$e,Ke,Qe,Ze,Je,ti,ei,ii,ni,ri,ai,si,oi,ui,di,li,ci,hi,fi,pi,mi,gi,yi,_i,vi,bi,Ti,Si,ki,wi,Ui,Li,Ai,Ei,Oi,Ci,Ii,Di,Pi,Ri,xi,Mi=function(){function t(e,i,n,r){T(this,t),this.callbacks_=[],this.pendingCallback_=null,this.timestampOffset_=0,this.mediaSource=e,this.processedAppend_=!1,this.type_=n,this.mimeType_=i,this.logger_=We("SourceUpdater["+n+"]["+i+"]"),"closed"===e.readyState?e.addEventListener("sourceopen",this.createSourceBuffer_.bind(this,i,r)):this.createSourceBuffer_(i,r)}return S(t,[{key:"createSourceBuffer_",value:function(t,e){var i=this;this.sourceBuffer_=this.mediaSource.addSourceBuffer(t),this.logger_("created SourceBuffer"),e&&(e.trigger("sourcebufferadded"),this.mediaSource.sourceBuffers.length<2)?e.on("sourcebufferadded",function(){i.start_()}):this.start_()}},{key:"start_",value:function(){var t=this;this.started_=!0,this.onUpdateendCallback_=function(){var e=t.pendingCallback_;t.pendingCallback_=null,t.logger_("buffered ["+Ut(t.buffered())+"]"),e&&e(),t.runCallback_()},this.sourceBuffer_.addEventListener("updateend",this.onUpdateendCallback_),this.runCallback_()}},{key:"abort",value:function(t){var e=this;this.processedAppend_&&this.queueCallback_(function(){e.sourceBuffer_.abort()},t)}},{key:"appendBuffer",value:function(t,e){var i=this;this.processedAppend_=!0,this.queueCallback_(function(){i.sourceBuffer_.appendBuffer(t)},e)}},{key:"buffered",value:function(){return this.sourceBuffer_?this.sourceBuffer_.buffered:e.createTimeRanges()}},{key:"remove",value:function(t,e){var i=this,n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:Xe;this.processedAppend_&&this.queueCallback_(function(){i.logger_("remove ["+t+" => "+e+"]"),i.sourceBuffer_.remove(t,e)},n)}},{key:"updating",value:function(){return!this.sourceBuffer_||this.sourceBuffer_.updating||this.pendingCallback_}},{key:"timestampOffset",value:function(t){var e=this;return void 0!==t&&(this.queueCallback_(function(){e.sourceBuffer_.timestampOffset=t}),this.timestampOffset_=t),this.timestampOffset_}},{key:"queueCallback_",value:function(t,e){this.callbacks_.push([t.bind(this),e]),this.runCallback_()}},{key:"runCallback_",value:function(){var t=void 0;!this.updating()&&this.callbacks_.length&&this.started_&&(t=this.callbacks_.shift(),this.pendingCallback_=t[1],t[0]())}},{key:"dispose",value:function(){this.sourceBuffer_.removeEventListener("updateend",this.onUpdateendCallback_),this.sourceBuffer_&&"open"===this.mediaSource.readyState&&this.sourceBuffer_.abort()}}]),t}(),Bi={GOAL_BUFFER_LENGTH:30,MAX_GOAL_BUFFER_LENGTH:60,GOAL_BUFFER_LENGTH_RATE:1,INITIAL_BANDWIDTH:4194304,BANDWIDTH_VARIANCE:1.2,BUFFER_LOW_WATER_LINE:0,MAX_BUFFER_LOW_WATER_LINE:30,BUFFER_LOW_WATER_LINE_RATE:1},Ni=function(t){return t>>>0},qi={findBox:Ye=function(t,e){var i,n,r,a,s,o=[];if(!e.length)return null;for(i=0;i<t.byteLength;)n=Ni(t[i]<<24|t[i+1]<<16|t[i+2]<<8|t[i+3]),r=$e(t.subarray(i+4,i+8)),a=n>1?i+n:t.byteLength,r===e[0]&&(1===e.length?o.push(t.subarray(i+8,a)):(s=Ye(t.subarray(i+8,a),e.slice(1))).length&&(o=o.concat(s))),i=a;return o},parseType:$e=function(t){var e="";return e+=String.fromCharCode(t[0]),e+=String.fromCharCode(t[1]),e+=String.fromCharCode(t[2]),e+=String.fromCharCode(t[3])},timescale:function(t){return Ye(t,["moov","trak"]).reduce(function(t,e){var i,n,r,a,s;return(i=Ye(e,["tkhd"])[0])?(n=i[0],a=Ni(i[r=0===n?12:20]<<24|i[r+1]<<16|i[r+2]<<8|i[r+3]),(s=Ye(e,["mdia","mdhd"])[0])?(r=0===(n=s[0])?12:20,t[a]=Ni(s[r]<<24|s[r+1]<<16|s[r+2]<<8|s[r+3]),t):null):null},{})},startTime:function(t,e){var i,n,r;return i=Ye(e,["moof","traf"]),n=[].concat.apply([],i.map(function(e){return Ye(e,["tfhd"]).map(function(i){var n,r;return n=Ni(i[4]<<24|i[5]<<16|i[6]<<8|i[7]),r=t[n]||9e4,(Ye(e,["tfdt"]).map(function(t){var e,i;return e=t[0],i=Ni(t[4]<<24|t[5]<<16|t[6]<<8|t[7]),1===e&&(i*=Math.pow(2,32),i+=Ni(t[8]<<24|t[9]<<16|t[10]<<8|t[11])),i})[0]||1/0)/r})})),r=Math.min.apply(null,n),isFinite(r)?r:0},videoTrackIds:function(t){var e=[];return Ye(t,["moov","trak"]).forEach(function(t){var i=Ye(t,["mdia","hdlr"]),n=Ye(t,["tkhd"]);i.forEach(function(t,i){var r,a,s=$e(t.subarray(8,12)),o=n[i];"vide"===s&&(a=0===(r=new DataView(o.buffer,o.byteOffset,o.byteLength)).getUint8(0)?r.getUint32(12):r.getUint32(20),e.push(a))})}),e}},Fi=2,Gi=-101,Vi=-102,Hi=function(t){var e,i,n={};return t.byterange&&(n.Range=(e=t.byterange,i=e.offset+e.length-1,"bytes="+e.offset+"-"+i)),n},ji=function(t){t.forEach(function(t){t.abort()})},zi=function(t,e){return e.timedout?{status:e.status,message:"HLS request timed-out at URL: "+e.uri,code:Gi,xhr:e}:e.aborted?{status:e.status,message:"HLS request aborted at URL: "+e.uri,code:Vi,xhr:e}:t?{status:e.status,message:"HLS request errored at URL: "+e.uri,code:Fi,xhr:e}:null},Wi=function(t,e,i){var n=0,r=!1;return function(a,s){if(!r)return a?(r=!0,ji(t),i(a,s)):(n+=1)===t.length?(s.endOfAllRequests=Date.now(),s.encryptedBytes?function(t,e,i){t.addEventListener("message",function n(r){if(r.data.source===e.requestId){t.removeEventListener("message",n);var a=r.data.decrypted;return e.bytes=new Uint8Array(a.bytes,a.byteOffset,a.byteLength),i(null,e)}}),t.postMessage(pt({source:e.requestId,encrypted:e.encryptedBytes,key:e.key.bytes,iv:e.key.iv}),[e.encryptedBytes.buffer,e.key.bytes.buffer])}(e,s,i):i(null,s)):void 0}},Xi=function(t,i){return function(n){var r,a,s;return t.stats=e.mergeOptions(t.stats,(a=(r=n).target,(s={bandwidth:1/0,bytesReceived:0,roundTripTime:Date.now()-a.requestTime||0}).bytesReceived=r.loaded,s.bandwidth=Math.floor(s.bytesReceived/s.roundTripTime*8*1e3),s)),!t.stats.firstBytesReceivedAt&&t.stats.bytesReceived&&(t.stats.firstBytesReceivedAt=Date.now()),i(n,t)}},Yi=function(t,i,n,r,a,s,o){var u=[],d=Wi(u,n,o);if(a.key){var l=t(e.mergeOptions(i,{uri:a.key.resolvedUri,responseType:"arraybuffer"}),function(t,e){return function(i,n){var r=n.response,a=zi(i,n);if(a)return e(a,t);if(16!==r.byteLength)return e({status:n.status,message:"Invalid HLS key at URL: "+n.uri,code:Fi,xhr:n},t);var s=new DataView(r);return t.key.bytes=new Uint32Array([s.getUint32(0),s.getUint32(4),s.getUint32(8),s.getUint32(12)]),e(null,t)}}(a,d));u.push(l)}if(a.map&&!a.map.bytes){var c=t(e.mergeOptions(i,{uri:a.map.resolvedUri,responseType:"arraybuffer",headers:Hi(a.map)}),function(t,e,i){return function(n,r){var a=r.response,s=zi(n,r);return s?i(s,t):0===a.byteLength?i({status:r.status,message:"Empty HLS segment content at URL: "+r.uri,code:Fi,xhr:r},t):(t.map.bytes=new Uint8Array(r.response),e.isInitialized()||e.init(),t.map.timescales=qi.timescale(t.map.bytes),t.map.videoTrackIds=qi.videoTrackIds(t.map.bytes),i(null,t))}}(a,r,d));u.push(c)}var h=t(e.mergeOptions(i,{uri:a.resolvedUri,responseType:"arraybuffer",headers:Hi(a)}),function(t,e,i){return function(n,r){var a=r.response,s=zi(n,r),o=void 0;return s?i(s,t):0===a.byteLength?i({status:r.status,message:"Empty HLS segment content at URL: "+r.uri,code:Fi,xhr:r},t):(t.stats=function(t){return{bandwidth:t.bandwidth,bytesReceived:t.bytesReceived||0,roundTripTime:t.roundTripTime||0}}(r),t.key?t.encryptedBytes=new Uint8Array(r.response):t.bytes=new Uint8Array(r.response),t.map&&t.map.bytes&&(e.isInitialized()||e.init(),(o=e.parse(t.bytes,t.map.videoTrackIds,t.map.timescales))&&o.captions&&(t.captionStreams=o.captionStreams,t.fmp4Captions=o.captions)),i(null,t))}}(a,r,d));return h.addEventListener("progress",Xi(a,s)),u.push(h),function(){return ji(u)}},$i=function(t,e){var i;return t&&(i=c.getComputedStyle(t))?i[e]:""},Ki=function(t,e){var i=t.slice();t.sort(function(t,n){var r=e(t,n);return 0===r?i.indexOf(t)-i.indexOf(n):r})},Qi=function(t,e){var i=void 0,n=void 0;return t.attributes.BANDWIDTH&&(i=t.attributes.BANDWIDTH),i=i||c.Number.MAX_VALUE,e.attributes.BANDWIDTH&&(n=e.attributes.BANDWIDTH),i-(n=n||c.Number.MAX_VALUE)},Zi=Math.pow(2,32)-1;!function(){var t;if(yi={avc1:[],avcC:[],btrt:[],dinf:[],dref:[],esds:[],ftyp:[],hdlr:[],mdat:[],mdhd:[],mdia:[],mfhd:[],minf:[],moof:[],moov:[],mp4a:[],mvex:[],mvhd:[],sdtp:[],smhd:[],stbl:[],stco:[],stsc:[],stsd:[],stsz:[],stts:[],styp:[],tfdt:[],tfhd:[],traf:[],trak:[],trun:[],trex:[],tkhd:[],vmhd:[]},"undefined"!=typeof Uint8Array){for(t in yi)yi.hasOwnProperty(t)&&(yi[t]=[t.charCodeAt(0),t.charCodeAt(1),t.charCodeAt(2),t.charCodeAt(3)]);_i=new Uint8Array(["i".charCodeAt(0),"s".charCodeAt(0),"o".charCodeAt(0),"m".charCodeAt(0)]),bi=new Uint8Array(["a".charCodeAt(0),"v".charCodeAt(0),"c".charCodeAt(0),"1".charCodeAt(0)]),vi=new Uint8Array([0,0,0,1]),Ti=new Uint8Array([0,0,0,0,0,0,0,0,118,105,100,101,0,0,0,0,0,0,0,0,0,0,0,0,86,105,100,101,111,72,97,110,100,108,101,114,0]),Si=new Uint8Array([0,0,0,0,0,0,0,0,115,111,117,110,0,0,0,0,0,0,0,0,0,0,0,0,83,111,117,110,100,72,97,110,100,108,101,114,0]),ki={video:Ti,audio:Si},Li=new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,12,117,114,108,32,0,0,0,1]),Ui=new Uint8Array([0,0,0,0,0,0,0,0]),Ai=new Uint8Array([0,0,0,0,0,0,0,0]),Ei=Ai,Oi=new Uint8Array([0,0,0,0,0,0,0,0,0,0,0,0]),Ci=Ai,wi=new Uint8Array([0,0,0,1,0,0,0,0,0,0,0,0])}}(),Ke=function(t){var e,i,n=[],r=0;for(e=1;e<arguments.length;e++)n.push(arguments[e]);for(e=n.length;e--;)r+=n[e].byteLength;for(i=new Uint8Array(r+8),new DataView(i.buffer,i.byteOffset,i.byteLength).setUint32(0,i.byteLength),i.set(t,4),e=0,r=8;e<n.length;e++)i.set(n[e],r),r+=n[e].byteLength;return i},Qe=function(){return Ke(yi.dinf,Ke(yi.dref,Li))},Ze=function(t){return Ke(yi.esds,new Uint8Array([0,0,0,0,3,25,0,0,0,4,17,64,21,0,6,0,0,0,218,192,0,0,218,192,5,2,t.audioobjecttype<<3|t.samplingfrequencyindex>>>1,t.samplingfrequencyindex<<7|t.channelcount<<3,6,1,2]))},li=function(t){return Ke(yi.hdlr,ki[t])},di=function(t){var e=new Uint8Array([0,0,0,0,0,0,0,2,0,0,0,3,0,1,95,144,t.duration>>>24&255,t.duration>>>16&255,t.duration>>>8&255,255&t.duration,85,196,0,0]);return t.samplerate&&(e[12]=t.samplerate>>>24&255,e[13]=t.samplerate>>>16&255,e[14]=t.samplerate>>>8&255,e[15]=255&t.samplerate),Ke(yi.mdhd,e)},ui=function(t){return Ke(yi.mdia,di(t),li(t.type),ei(t))},ti=function(t){return Ke(yi.mfhd,new Uint8Array([0,0,0,0,(4278190080&t)>>24,(16711680&t)>>16,(65280&t)>>8,255&t]))},ei=function(t){return Ke(yi.minf,"video"===t.type?Ke(yi.vmhd,wi):Ke(yi.smhd,Ui),Qe(),hi(t))},ii=function(t,e){for(var i=[],n=e.length;n--;)i[n]=pi(e[n]);return Ke.apply(null,[yi.moof,ti(t)].concat(i))},ni=function(t){for(var e=t.length,i=[];e--;)i[e]=si(t[e]);return Ke.apply(null,[yi.moov,ai(4294967295)].concat(i).concat(ri(t)))},ri=function(t){for(var e=t.length,i=[];e--;)i[e]=mi(t[e]);return Ke.apply(null,[yi.mvex].concat(i))},ai=function(t){var e=new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,2,0,1,95,144,(4278190080&t)>>24,(16711680&t)>>16,(65280&t)>>8,255&t,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255]);return Ke(yi.mvhd,e)},ci=function(t){var e,i,n=t.samples||[],r=new Uint8Array(4+n.length);for(i=0;i<n.length;i++)e=n[i].flags,r[i+4]=e.dependsOn<<4|e.isDependedOn<<2|e.hasRedundancy;return Ke(yi.sdtp,r)},hi=function(t){return Ke(yi.stbl,fi(t),Ke(yi.stts,Ci),Ke(yi.stsc,Ei),Ke(yi.stsz,Oi),Ke(yi.stco,Ai))},fi=function(t){return Ke(yi.stsd,new Uint8Array([0,0,0,0,0,0,0,1]),"video"===t.type?Ii(t):Di(t))},Ii=function(t){var e,i=t.sps||[],n=t.pps||[],r=[],a=[];for(e=0;e<i.length;e++)r.push((65280&i[e].byteLength)>>>8),r.push(255&i[e].byteLength),r=r.concat(Array.prototype.slice.call(i[e]));for(e=0;e<n.length;e++)a.push((65280&n[e].byteLength)>>>8),a.push(255&n[e].byteLength),a=a.concat(Array.prototype.slice.call(n[e]));return Ke(yi.avc1,new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,(65280&t.width)>>8,255&t.width,(65280&t.height)>>8,255&t.height,0,72,0,0,0,72,0,0,0,0,0,0,0,1,19,118,105,100,101,111,106,115,45,99,111,110,116,114,105,98,45,104,108,115,0,0,0,0,0,0,0,0,0,0,0,0,0,24,17,17]),Ke(yi.avcC,new Uint8Array([1,t.profileIdc,t.profileCompatibility,t.levelIdc,255].concat([i.length]).concat(r).concat([n.length]).concat(a))),Ke(yi.btrt,new Uint8Array([0,28,156,128,0,45,198,192,0,45,198,192])))},Di=function(t){return Ke(yi.mp4a,new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,(65280&t.channelcount)>>8,255&t.channelcount,(65280&t.samplesize)>>8,255&t.samplesize,0,0,0,0,(65280&t.samplerate)>>8,255&t.samplerate,0,0]),Ze(t))},oi=function(t){var e=new Uint8Array([0,0,0,7,0,0,0,0,0,0,0,0,(4278190080&t.id)>>24,(16711680&t.id)>>16,(65280&t.id)>>8,255&t.id,0,0,0,0,(4278190080&t.duration)>>24,(16711680&t.duration)>>16,(65280&t.duration)>>8,255&t.duration,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,(65280&t.width)>>8,255&t.width,0,0,(65280&t.height)>>8,255&t.height,0,0]);return Ke(yi.tkhd,e)},pi=function(t){var e,i,n,r,a,s;return e=Ke(yi.tfhd,new Uint8Array([0,0,0,58,(4278190080&t.id)>>24,(16711680&t.id)>>16,(65280&t.id)>>8,255&t.id,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0])),a=Math.floor(t.baseMediaDecodeTime/(Zi+1)),s=Math.floor(t.baseMediaDecodeTime%(Zi+1)),i=Ke(yi.tfdt,new Uint8Array([1,0,0,0,a>>>24&255,a>>>16&255,a>>>8&255,255&a,s>>>24&255,s>>>16&255,s>>>8&255,255&s])),92,"audio"===t.type?(n=gi(t,92),Ke(yi.traf,e,i,n)):(r=ci(t),n=gi(t,r.length+92),Ke(yi.traf,e,i,n,r))},si=function(t){return t.duration=t.duration||4294967295,Ke(yi.trak,oi(t),ui(t))},mi=function(t){var e=new Uint8Array([0,0,0,0,(4278190080&t.id)>>24,(16711680&t.id)>>16,(65280&t.id)>>8,255&t.id,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,1]);return"video"!==t.type&&(e[e.length-1]=0),Ke(yi.trex,e)},xi=function(t,e){var i=0,n=0,r=0,a=0;return t.length&&(void 0!==t[0].duration&&(i=1),void 0!==t[0].size&&(n=2),void 0!==t[0].flags&&(r=4),void 0!==t[0].compositionTimeOffset&&(a=8)),[0,0,i|n|r|a,1,(4278190080&t.length)>>>24,(16711680&t.length)>>>16,(65280&t.length)>>>8,255&t.length,(4278190080&e)>>>24,(16711680&e)>>>16,(65280&e)>>>8,255&e]},Ri=function(t,e){var i,n,r,a;for(e+=20+16*(n=t.samples||[]).length,i=xi(n,e),a=0;a<n.length;a++)r=n[a],i=i.concat([(4278190080&r.duration)>>>24,(16711680&r.duration)>>>16,(65280&r.duration)>>>8,255&r.duration,(4278190080&r.size)>>>24,(16711680&r.size)>>>16,(65280&r.size)>>>8,255&r.size,r.flags.isLeading<<2|r.flags.dependsOn,r.flags.isDependedOn<<6|r.flags.hasRedundancy<<4|r.flags.paddingValue<<1|r.flags.isNonSyncSample,61440&r.flags.degradationPriority,15&r.flags.degradationPriority,(4278190080&r.compositionTimeOffset)>>>24,(16711680&r.compositionTimeOffset)>>>16,(65280&r.compositionTimeOffset)>>>8,255&r.compositionTimeOffset]);return Ke(yi.trun,new Uint8Array(i))},Pi=function(t,e){var i,n,r,a;for(e+=20+8*(n=t.samples||[]).length,i=xi(n,e),a=0;a<n.length;a++)r=n[a],i=i.concat([(4278190080&r.duration)>>>24,(16711680&r.duration)>>>16,(65280&r.duration)>>>8,255&r.duration,(4278190080&r.size)>>>24,(16711680&r.size)>>>16,(65280&r.size)>>>8,255&r.size]);return Ke(yi.trun,new Uint8Array(i))},gi=function(t,e){return"audio"===t.type?Pi(t,e):Ri(t,e)};var Ji={ftyp:Je=function(){return Ke(yi.ftyp,_i,vi,_i,bi)},mdat:function(t){return Ke(yi.mdat,t)},moof:ii,moov:ni,initSegment:function(t){var e,i=Je(),n=ni(t);return(e=new Uint8Array(i.byteLength+n.byteLength)).set(i),e.set(n,i.byteLength),e}},tn=function(){this.init=function(){var t={};this.on=function(e,i){t[e]||(t[e]=[]),t[e]=t[e].concat(i)},this.off=function(e,i){var n;return!!t[e]&&(n=t[e].indexOf(i),t[e]=t[e].slice(),t[e].splice(n,1),n>-1)},this.trigger=function(e){var i,n,r,a;if(i=t[e])if(2===arguments.length)for(r=i.length,n=0;n<r;++n)i[n].call(this,arguments[1]);else{for(a=[],n=arguments.length,n=1;n<arguments.length;++n)a.push(arguments[n]);for(r=i.length,n=0;n<r;++n)i[n].apply(this,a)}},this.dispose=function(){t={}}}};tn.prototype.pipe=function(t){return this.on("data",function(e){t.push(e)}),this.on("done",function(e){t.flush(e)}),t},tn.prototype.push=function(t){this.trigger("data",t)},tn.prototype.flush=function(t){this.trigger("done",t)};var en,nn,rn,an,sn,on=tn,un=function(t,e){var i={size:0,flags:{isLeading:0,dependsOn:1,isDependedOn:0,hasRedundancy:0,degradationPriority:0,isNonSyncSample:1}};return i.dataOffset=e,i.compositionTimeOffset=t.pts-t.dts,i.duration=t.duration,i.size=4*t.length,i.size+=t.byteLength,t.keyFrame&&(i.flags.dependsOn=2,i.flags.isNonSyncSample=0),i},dn=function(t){var e,i,n=[],r=[];for(n.byteLength=0,e=0;e<t.length;e++)"access_unit_delimiter_rbsp"===(i=t[e]).nalUnitType?(n.length&&(n.duration=i.dts-n.dts,r.push(n)),(n=[i]).byteLength=i.data.byteLength,n.pts=i.pts,n.dts=i.dts):("slice_layer_without_partitioning_rbsp_idr"===i.nalUnitType&&(n.keyFrame=!0),n.duration=i.dts-n.dts,n.byteLength+=i.data.byteLength,n.push(i));return r.length&&(!n.duration||n.duration<=0)&&(n.duration=r[r.length-1].duration),r.push(n),r},ln=function(t){var e,i,n=[],r=[];for(n.byteLength=0,n.nalCount=0,n.duration=0,n.pts=t[0].pts,n.dts=t[0].dts,r.byteLength=0,r.nalCount=0,r.duration=0,r.pts=t[0].pts,r.dts=t[0].dts,e=0;e<t.length;e++)(i=t[e]).keyFrame?(n.length&&(r.push(n),r.byteLength+=n.byteLength,r.nalCount+=n.nalCount,r.duration+=n.duration),(n=[i]).nalCount=i.length,n.byteLength=i.byteLength,n.pts=i.pts,n.dts=i.dts,n.duration=i.duration):(n.duration+=i.duration,n.nalCount+=i.length,n.byteLength+=i.byteLength,n.push(i));return r.length&&n.duration<=0&&(n.duration=r[r.length-1].duration),r.byteLength+=n.byteLength,r.nalCount+=n.nalCount,r.duration+=n.duration,r.push(n),r},cn=function(t){var e;return!t[0][0].keyFrame&&t.length>1&&(e=t.shift(),t.byteLength-=e.byteLength,t.nalCount-=e.nalCount,t[0][0].dts=e.dts,t[0][0].pts=e.pts,t[0][0].duration+=e.duration),t},hn=function(t,e){var i,n,r,a,s,o=e||0,u=[];for(i=0;i<t.length;i++)for(a=t[i],n=0;n<a.length;n++)s=a[n],o+=(r=un(s,o)).size,u.push(r);return u},fn=function(t){var e,i,n,r,a,s,o=0,u=t.byteLength,d=t.nalCount,l=new Uint8Array(u+4*d),c=new DataView(l.buffer);for(e=0;e<t.length;e++)for(r=t[e],i=0;i<r.length;i++)for(a=r[i],n=0;n<a.length;n++)s=a[n],c.setUint32(o,s.data.byteLength),o+=4,l.set(s.data,o),o+=s.data.byteLength;return l},pn=[33,16,5,32,164,27],mn=[33,65,108,84,1,2,4,8,168,2,4,8,17,191,252],gn=function(t){for(var e=[];t--;)e.push(0);return e},yn={96000:[pn,[227,64],gn(154),[56]],88200:[pn,[231],gn(170),[56]],64000:[pn,[248,192],gn(240),[56]],48000:[pn,[255,192],gn(268),[55,148,128],gn(54),[112]],44100:[pn,[255,192],gn(268),[55,163,128],gn(84),[112]],32000:[pn,[255,192],gn(268),[55,234],gn(226),[112]],24000:[pn,[255,192],gn(268),[55,255,128],gn(268),[111,112],gn(126),[224]],16000:[pn,[255,192],gn(268),[55,255,128],gn(268),[111,255],gn(269),[223,108],gn(195),[1,192]],12000:[mn,gn(268),[3,127,248],gn(268),[6,255,240],gn(268),[13,255,224],gn(268),[27,253,128],gn(259),[56]],11025:[mn,gn(268),[3,127,248],gn(268),[6,255,240],gn(268),[13,255,224],gn(268),[27,255,192],gn(268),[55,175,128],gn(108),[112]],8000:[mn,gn(268),[3,121,16],gn(47),[7]]},_n=(en=yn,Object.keys(en).reduce(function(t,e){return t[e]=new Uint8Array(en[e].reduce(function(t,e){return t.concat(e)},[])),t},{})),vn=(nn=function(t){return 9e4*t},rn=function(t,e){return t*e},an=function(t){return t/9e4},sn=function(t,e){return t/e},function(t,e){return nn(sn(t,e))}),bn=function(t,e){return rn(an(t),e)},Tn=function(t,e,i,n){var r,a,s,o,u=0,d=0,l=0;if(e.length&&(r=vn(t.baseMediaDecodeTime,t.samplerate),a=Math.ceil(9e4/(t.samplerate/1024)),i&&n&&(u=r-Math.max(i,n),l=(d=Math.floor(u/a))*a),!(d<1||l>45e3))){for((s=_n[t.samplerate])||(s=e[0].data),o=0;o<d;o++)e.splice(o,0,{data:s});t.baseMediaDecodeTime-=Math.floor(bn(l,t.samplerate))}},Sn=function(t,e,i){return e.minSegmentDts>=i?t:(e.minSegmentDts=1/0,t.filter(function(t){return t.dts>=i&&(e.minSegmentDts=Math.min(e.minSegmentDts,t.dts),e.minSegmentPts=e.minSegmentDts,!0)}))},kn=function(t){var e,i,n=[];for(e=0;e<t.length;e++)i=t[e],n.push({size:i.data.byteLength,duration:1024});return n},wn=function(t){var e,i,n=0,r=new Uint8Array(function(t){var e,i=0;for(e=0;e<t.length;e++)i+=t[e].data.byteLength;return i}(t));for(e=0;e<t.length;e++)i=t[e],r.set(i.data,n),n+=i.data.byteLength;return r},Un=function(t){delete t.minSegmentDts,delete t.maxSegmentDts,delete t.minSegmentPts,delete t.maxSegmentPts},Ln=function(t,e){var i,n=t.minSegmentDts;return e||(n-=t.timelineStartInfo.dts),i=t.timelineStartInfo.baseMediaDecodeTime,i+=n,i=Math.max(0,i),"audio"===t.type&&(i*=t.samplerate/9e4,i=Math.floor(i)),i},An=function(t,e){"number"==typeof e.pts&&(void 0===t.timelineStartInfo.pts&&(t.timelineStartInfo.pts=e.pts),void 0===t.minSegmentPts?t.minSegmentPts=e.pts:t.minSegmentPts=Math.min(t.minSegmentPts,e.pts),void 0===t.maxSegmentPts?t.maxSegmentPts=e.pts:t.maxSegmentPts=Math.max(t.maxSegmentPts,e.pts)),"number"==typeof e.dts&&(void 0===t.timelineStartInfo.dts&&(t.timelineStartInfo.dts=e.dts),void 0===t.minSegmentDts?t.minSegmentDts=e.dts:t.minSegmentDts=Math.min(t.minSegmentDts,e.dts),void 0===t.maxSegmentDts?t.maxSegmentDts=e.dts:t.maxSegmentDts=Math.max(t.maxSegmentDts,e.dts))},En=function(t){for(var e=0,i={payloadType:-1,payloadSize:0},n=0,r=0;e<t.byteLength&&128!==t[e];){for(;255===t[e];)n+=255,e++;for(n+=t[e++];255===t[e];)r+=255,e++;if(r+=t[e++],!i.payload&&4===n){i.payloadType=n,i.payloadSize=r,i.payload=t.subarray(e,e+r);break}e+=r,n=0,r=0}return i},On=function(t){return 181!==t.payload[0]?null:49!=(t.payload[1]<<8|t.payload[2])?null:"GA94"!==String.fromCharCode(t.payload[3],t.payload[4],t.payload[5],t.payload[6])?null:3!==t.payload[7]?null:t.payload.subarray(8,t.payload.length-1)},Cn=function(t,e){var i,n,r,a,s=[];if(!(64&e[0]))return s;for(n=31&e[0],i=0;i<n;i++)a={type:3&e[2+(r=3*i)],pts:t},4&e[r+2]&&(a.ccData=e[r+3]<<8|e[r+4],s.push(a));return s},In=function(t){for(var e,i,n=t.byteLength,r=[],a=1;a<n-2;)0===t[a]&&0===t[a+1]&&3===t[a+2]?(r.push(a+2),a+=2):a++;if(0===r.length)return t;e=n-r.length,i=new Uint8Array(e);var s=0;for(a=0;a<e;s++,a++)s===r[0]&&(s++,r.shift()),i[a]=t[s];return i},Dn=4,Pn=function t(){t.prototype.init.call(this),this.captionPackets_=[],this.ccStreams_=[new Nn(0,0),new Nn(0,1),new Nn(1,0),new Nn(1,1)],this.reset(),this.ccStreams_.forEach(function(t){t.on("data",this.trigger.bind(this,"data")),t.on("done",this.trigger.bind(this,"done"))},this)};(Pn.prototype=new on).push=function(t){var e,i,n;if("sei_rbsp"===t.nalUnitType&&(e=En(t.escapedRBSP)).payloadType===Dn&&(i=On(e)))if(t.dts<this.latestDts_)this.ignoreNextEqualDts_=!0;else{if(t.dts===this.latestDts_&&this.ignoreNextEqualDts_)return this.numSameDts_--,void(this.numSameDts_||(this.ignoreNextEqualDts_=!1));n=Cn(t.pts,i),this.captionPackets_=this.captionPackets_.concat(n),this.latestDts_!==t.dts&&(this.numSameDts_=0),this.numSameDts_++,this.latestDts_=t.dts}},Pn.prototype.flush=function(){this.captionPackets_.length?(this.captionPackets_.forEach(function(t,e){t.presortIndex=e}),this.captionPackets_.sort(function(t,e){return t.pts===e.pts?t.presortIndex-e.presortIndex:t.pts-e.pts}),this.captionPackets_.forEach(function(t){t.type<2&&this.dispatchCea608Packet(t)},this),this.captionPackets_.length=0,this.ccStreams_.forEach(function(t){t.flush()},this)):this.ccStreams_.forEach(function(t){t.flush()},this)},Pn.prototype.reset=function(){this.latestDts_=null,this.ignoreNextEqualDts_=!1,this.numSameDts_=0,this.activeCea608Channel_=[null,null],this.ccStreams_.forEach(function(t){t.reset()})},Pn.prototype.dispatchCea608Packet=function(t){this.setsChannel1Active(t)?this.activeCea608Channel_[t.type]=0:this.setsChannel2Active(t)&&(this.activeCea608Channel_[t.type]=1),null!==this.activeCea608Channel_[t.type]&&this.ccStreams_[(t.type<<1)+this.activeCea608Channel_[t.type]].push(t)},Pn.prototype.setsChannel1Active=function(t){return 4096==(30720&t.ccData)},Pn.prototype.setsChannel2Active=function(t){return 6144==(30720&t.ccData)};var Rn={42:225,92:233,94:237,95:243,96:250,123:231,124:247,125:209,126:241,127:9608,304:174,305:176,306:189,307:191,308:8482,309:162,310:163,311:9834,312:224,313:160,314:232,315:226,316:234,317:238,318:244,319:251,544:193,545:201,546:211,547:218,548:220,549:252,550:8216,551:161,552:42,553:39,554:8212,555:169,556:8480,557:8226,558:8220,559:8221,560:192,561:194,562:199,563:200,564:202,565:203,566:235,567:206,568:207,569:239,570:212,571:217,572:249,573:219,574:171,575:187,800:195,801:227,802:205,803:204,804:236,805:210,806:242,807:213,808:245,809:123,810:125,811:92,812:94,813:95,814:124,815:126,816:196,817:228,818:214,819:246,820:223,821:165,822:164,823:9474,824:197,825:229,826:216,827:248,828:9484,829:9488,830:9492,831:9496},xn=function(t){return null===t?"":(t=Rn[t]||t,String.fromCharCode(t))},Mn=[4352,4384,4608,4640,5376,5408,5632,5664,5888,5920,4096,4864,4896,5120,5152],Bn=function(){for(var t=[],e=15;e--;)t.push("");return t},Nn=function t(e,i){t.prototype.init.call(this),this.field_=e||0,this.dataChannel_=i||0,this.name_="CC"+(1+(this.field_<<1|this.dataChannel_)),this.setConstants(),this.reset(),this.push=function(t){var e,i,n,r,a;if((e=32639&t.ccData)!==this.lastControlCode_){if(4096==(61440&e)?this.lastControlCode_=e:e!==this.PADDING_&&(this.lastControlCode_=null),n=e>>>8,r=255&e,e!==this.PADDING_)if(e===this.RESUME_CAPTION_LOADING_)this.mode_="popOn";else if(e===this.END_OF_CAPTION_)this.mode_="popOn",this.clearFormatting(t.pts),this.flushDisplayed(t.pts),i=this.displayed_,this.displayed_=this.nonDisplayed_,this.nonDisplayed_=i,this.startPts_=t.pts;else if(e===this.ROLL_UP_2_ROWS_)this.rollUpRows_=2,this.setRollUp(t.pts);else if(e===this.ROLL_UP_3_ROWS_)this.rollUpRows_=3,this.setRollUp(t.pts);else if(e===this.ROLL_UP_4_ROWS_)this.rollUpRows_=4,this.setRollUp(t.pts);else if(e===this.CARRIAGE_RETURN_)this.clearFormatting(t.pts),this.flushDisplayed(t.pts),this.shiftRowsUp_(),this.startPts_=t.pts;else if(e===this.BACKSPACE_)"popOn"===this.mode_?this.nonDisplayed_[this.row_]=this.nonDisplayed_[this.row_].slice(0,-1):this.displayed_[this.row_]=this.displayed_[this.row_].slice(0,-1);else if(e===this.ERASE_DISPLAYED_MEMORY_)this.flushDisplayed(t.pts),this.displayed_=Bn();else if(e===this.ERASE_NON_DISPLAYED_MEMORY_)this.nonDisplayed_=Bn();else if(e===this.RESUME_DIRECT_CAPTIONING_)"paintOn"!==this.mode_&&(this.flushDisplayed(t.pts),this.displayed_=Bn()),this.mode_="paintOn",this.startPts_=t.pts;else if(this.isSpecialCharacter(n,r))a=xn((n=(3&n)<<8)|r),this[this.mode_](t.pts,a),this.column_++;else if(this.isExtCharacter(n,r))"popOn"===this.mode_?this.nonDisplayed_[this.row_]=this.nonDisplayed_[this.row_].slice(0,-1):this.displayed_[this.row_]=this.displayed_[this.row_].slice(0,-1),a=xn((n=(3&n)<<8)|r),this[this.mode_](t.pts,a),this.column_++;else if(this.isMidRowCode(n,r))this.clearFormatting(t.pts),this[this.mode_](t.pts," "),this.column_++,14==(14&r)&&this.addFormatting(t.pts,["i"]),1==(1&r)&&this.addFormatting(t.pts,["u"]);else if(this.isOffsetControlCode(n,r))this.column_+=3&r;else if(this.isPAC(n,r)){var s=Mn.indexOf(7968&e);"rollUp"===this.mode_&&(s-this.rollUpRows_+1<0&&(s=this.rollUpRows_-1),this.setRollUp(t.pts,s)),s!==this.row_&&(this.clearFormatting(t.pts),this.row_=s),1&r&&-1===this.formatting_.indexOf("u")&&this.addFormatting(t.pts,["u"]),16==(16&e)&&(this.column_=4*((14&e)>>1)),this.isColorPAC(r)&&14==(14&r)&&this.addFormatting(t.pts,["i"])}else this.isNormalChar(n)&&(0===r&&(r=null),a=xn(n),a+=xn(r),this[this.mode_](t.pts,a),this.column_+=a.length)}else this.lastControlCode_=null}};Nn.prototype=new on,Nn.prototype.flushDisplayed=function(t){var e=this.displayed_.map(function(t){try{return t.trim()}catch(t){return console.error("Skipping malformed caption."),""}}).join("\n").replace(/^\n+|\n+$/g,"");e.length&&this.trigger("data",{startPts:this.startPts_,endPts:t,text:e,stream:this.name_})},Nn.prototype.reset=function(){this.mode_="popOn",this.topRow_=0,this.startPts_=0,this.displayed_=Bn(),this.nonDisplayed_=Bn(),this.lastControlCode_=null,this.column_=0,this.row_=14,this.rollUpRows_=2,this.formatting_=[]},Nn.prototype.setConstants=function(){0===this.dataChannel_?(this.BASE_=16,this.EXT_=17,this.CONTROL_=(20|this.field_)<<8,this.OFFSET_=23):1===this.dataChannel_&&(this.BASE_=24,this.EXT_=25,this.CONTROL_=(28|this.field_)<<8,this.OFFSET_=31),this.PADDING_=0,this.RESUME_CAPTION_LOADING_=32|this.CONTROL_,this.END_OF_CAPTION_=47|this.CONTROL_,this.ROLL_UP_2_ROWS_=37|this.CONTROL_,this.ROLL_UP_3_ROWS_=38|this.CONTROL_,this.ROLL_UP_4_ROWS_=39|this.CONTROL_,this.CARRIAGE_RETURN_=45|this.CONTROL_,this.RESUME_DIRECT_CAPTIONING_=41|this.CONTROL_,this.BACKSPACE_=33|this.CONTROL_,this.ERASE_DISPLAYED_MEMORY_=44|this.CONTROL_,this.ERASE_NON_DISPLAYED_MEMORY_=46|this.CONTROL_},Nn.prototype.isSpecialCharacter=function(t,e){return t===this.EXT_&&e>=48&&e<=63},Nn.prototype.isExtCharacter=function(t,e){return(t===this.EXT_+1||t===this.EXT_+2)&&e>=32&&e<=63},Nn.prototype.isMidRowCode=function(t,e){return t===this.EXT_&&e>=32&&e<=47},Nn.prototype.isOffsetControlCode=function(t,e){return t===this.OFFSET_&&e>=33&&e<=35},Nn.prototype.isPAC=function(t,e){return t>=this.BASE_&&t<this.BASE_+8&&e>=64&&e<=127},Nn.prototype.isColorPAC=function(t){return t>=64&&t<=79||t>=96&&t<=127},Nn.prototype.isNormalChar=function(t){return t>=32&&t<=127},Nn.prototype.setRollUp=function(t,e){if("rollUp"!==this.mode_&&(this.row_=14,this.mode_="rollUp",this.flushDisplayed(t),this.nonDisplayed_=Bn(),this.displayed_=Bn()),void 0!==e&&e!==this.row_)for(var i=0;i<this.rollUpRows_;i++)this.displayed_[e-i]=this.displayed_[this.row_-i],this.displayed_[this.row_-i]="";void 0===e&&(e=this.row_),this.topRow_=e-this.rollUpRows_+1},Nn.prototype.addFormatting=function(t,e){this.formatting_=this.formatting_.concat(e);var i=e.reduce(function(t,e){return t+"<"+e+">"},"");this[this.mode_](t,i)},Nn.prototype.clearFormatting=function(t){if(this.formatting_.length){var e=this.formatting_.reverse().reduce(function(t,e){return t+"</"+e+">"},"");this.formatting_=[],this[this.mode_](t,e)}},Nn.prototype.popOn=function(t,e){var i=this.nonDisplayed_[this.row_];i+=e,this.nonDisplayed_[this.row_]=i},Nn.prototype.rollUp=function(t,e){var i=this.displayed_[this.row_];i+=e,this.displayed_[this.row_]=i},Nn.prototype.shiftRowsUp_=function(){var t;for(t=0;t<this.topRow_;t++)this.displayed_[t]="";for(t=this.row_+1;t<15;t++)this.displayed_[t]="";for(t=this.topRow_;t<this.row_;t++)this.displayed_[t]=this.displayed_[t+1];this.displayed_[this.row_]=""},Nn.prototype.paintOn=function(t,e){var i=this.displayed_[this.row_];i+=e,this.displayed_[this.row_]=i};var qn={CaptionStream:Pn,Cea608Stream:Nn},Fn={H264_STREAM_TYPE:27,ADTS_STREAM_TYPE:15,METADATA_STREAM_TYPE:21},Gn=function(t,e){var i=1;for(t>e&&(i=-1);Math.abs(e-t)>4294967296;)t+=8589934592*i;return t},Vn=function t(e){var i,n;t.prototype.init.call(this),this.type_=e,this.push=function(t){t.type===this.type_&&(void 0===n&&(n=t.dts),t.dts=Gn(t.dts,n),t.pts=Gn(t.pts,n),i=t.dts,this.trigger("data",t))},this.flush=function(){n=i,this.trigger("done")},this.discontinuity=function(){n=void 0,i=void 0}};Vn.prototype=new on;var Hn,jn=Vn,zn=Gn,Wn=function(t,e,i){var n,r="";for(n=e;n<i;n++)r+="%"+("00"+t[n].toString(16)).slice(-2);return r},Xn=function(t,e,i){return decodeURIComponent(Wn(t,e,i))},Yn=function(t){return t[0]<<21|t[1]<<14|t[2]<<7|t[3]},$n={TXXX:function(t){var e;if(3===t.data[0]){for(e=1;e<t.data.length;e++)if(0===t.data[e]){t.description=Xn(t.data,1,e),t.value=Xn(t.data,e+1,t.data.length).replace(/\0*$/,"");break}t.data=t.value}},WXXX:function(t){var e;if(3===t.data[0])for(e=1;e<t.data.length;e++)if(0===t.data[e]){t.description=Xn(t.data,1,e),t.url=Xn(t.data,e+1,t.data.length);break}},PRIV:function(t){var e,i;for(e=0;e<t.data.length;e++)if(0===t.data[e]){t.owner=(i=t.data,unescape(Wn(i,0,e)));break}t.privateData=t.data.subarray(e+1),t.data=t.privateData}};(Hn=function(t){var e,i={debug:!(!t||!t.debug),descriptor:t&&t.descriptor},n=0,r=[],a=0;if(Hn.prototype.init.call(this),this.dispatchType=Fn.METADATA_STREAM_TYPE.toString(16),i.descriptor)for(e=0;e<i.descriptor.length;e++)this.dispatchType+=("00"+i.descriptor[e].toString(16)).slice(-2);this.push=function(t){var e,s,o,u,d;if("timed-metadata"===t.type)if(t.dataAlignmentIndicator&&(a=0,r.length=0),0===r.length&&(t.data.length<10||t.data[0]!=="I".charCodeAt(0)||t.data[1]!=="D".charCodeAt(0)||t.data[2]!=="3".charCodeAt(0)))i.debug&&console.log("Skipping unrecognized metadata packet");else if(r.push(t),a+=t.data.byteLength,1===r.length&&(n=Yn(t.data.subarray(6,10)),n+=10),!(a<n)){for(e={data:new Uint8Array(n),frames:[],pts:r[0].pts,dts:r[0].dts},d=0;d<n;)e.data.set(r[0].data.subarray(0,n-d),d),d+=r[0].data.byteLength,a-=r[0].data.byteLength,r.shift();s=10,64&e.data[5]&&(s+=4,s+=Yn(e.data.subarray(10,14)),n-=Yn(e.data.subarray(16,20)));do{if((o=Yn(e.data.subarray(s+4,s+8)))<1)return console.log("Malformed ID3 frame encountered. Skipping metadata parsing.");if((u={id:String.fromCharCode(e.data[s],e.data[s+1],e.data[s+2],e.data[s+3]),data:e.data.subarray(s+10,s+o+10)}).key=u.id,$n[u.id]&&($n[u.id](u),"com.apple.streaming.transportStreamTimestamp"===u.owner)){var l=u.data,c=(1&l[3])<<30|l[4]<<22|l[5]<<14|l[6]<<6|l[7]>>>2;c*=4,c+=3&l[7],u.timeStamp=c,void 0===e.pts&&void 0===e.dts&&(e.pts=u.timeStamp,e.dts=u.timeStamp),this.trigger("timestamp",u)}e.frames.push(u),s+=10,s+=o}while(s<n);this.trigger("data",e)}}}).prototype=new on;var Kn,Qn,Zn,Jn=Hn,tr=jn;(Kn=function(){var t=new Uint8Array(188),e=0;Kn.prototype.init.call(this),this.push=function(i){var n,r=0,a=188;for(e?((n=new Uint8Array(i.byteLength+e)).set(t.subarray(0,e)),n.set(i,e),e=0):n=i;a<n.byteLength;)71!==n[r]||71!==n[a]?(r++,a++):(this.trigger("data",n.subarray(r,a)),r+=188,a+=188);r<n.byteLength&&(t.set(n.subarray(r),0),e=n.byteLength-r)},this.flush=function(){188===e&&71===t[0]&&(this.trigger("data",t),e=0),this.trigger("done")}}).prototype=new on,(Qn=function(){var t,e,i,n;Qn.prototype.init.call(this),n=this,this.packetsWaitingForPmt=[],this.programMapTable=void 0,t=function(t,n){var r=0;n.payloadUnitStartIndicator&&(r+=t[r]+1),"pat"===n.type?e(t.subarray(r),n):i(t.subarray(r),n)},e=function(t,e){e.section_number=t[7],e.last_section_number=t[8],n.pmtPid=(31&t[10])<<8|t[11],e.pmtPid=n.pmtPid},i=function(t,e){var i,r;if(1&t[5]){for(n.programMapTable={video:null,audio:null,"timed-metadata":{}},i=3+((15&t[1])<<8|t[2])-4,r=12+((15&t[10])<<8|t[11]);r<i;){var a=t[r],s=(31&t[r+1])<<8|t[r+2];a===Fn.H264_STREAM_TYPE&&null===n.programMapTable.video?n.programMapTable.video=s:a===Fn.ADTS_STREAM_TYPE&&null===n.programMapTable.audio?n.programMapTable.audio=s:a===Fn.METADATA_STREAM_TYPE&&(n.programMapTable["timed-metadata"][s]=a),r+=5+((15&t[r+3])<<8|t[r+4])}e.programMapTable=n.programMapTable}},this.push=function(e){var i={},n=4;if(i.payloadUnitStartIndicator=!!(64&e[1]),i.pid=31&e[1],i.pid<<=8,i.pid|=e[2],(48&e[3])>>>4>1&&(n+=e[n]+1),0===i.pid)i.type="pat",t(e.subarray(n),i),this.trigger("data",i);else if(i.pid===this.pmtPid)for(i.type="pmt",t(e.subarray(n),i),this.trigger("data",i);this.packetsWaitingForPmt.length;)this.processPes_.apply(this,this.packetsWaitingForPmt.shift());else void 0===this.programMapTable?this.packetsWaitingForPmt.push([e,n,i]):this.processPes_(e,n,i)},this.processPes_=function(t,e,i){i.pid===this.programMapTable.video?i.streamType=Fn.H264_STREAM_TYPE:i.pid===this.programMapTable.audio?i.streamType=Fn.ADTS_STREAM_TYPE:i.streamType=this.programMapTable["timed-metadata"][i.pid],i.type="pes",i.data=t.subarray(e),this.trigger("data",i)}}).prototype=new on,Qn.STREAM_TYPES={h264:27,adts:15},(Zn=function(){var t=this,e={data:[],size:0},i={data:[],size:0},n={data:[],size:0},r=function(e,i,n){var r,a,s=new Uint8Array(e.size),o={type:i},u=0,d=0;if(e.data.length&&!(e.size<9)){for(o.trackId=e.data[0].pid,u=0;u<e.data.length;u++)a=e.data[u],s.set(a.data,d),d+=a.data.byteLength;var l,c,h;l=s,(c=o).packetLength=6+(l[4]<<8|l[5]),c.dataAlignmentIndicator=0!=(4&l[6]),192&(h=l[7])&&(c.pts=(14&l[9])<<27|(255&l[10])<<20|(254&l[11])<<12|(255&l[12])<<5|(254&l[13])>>>3,c.pts*=4,c.pts+=(6&l[13])>>>1,c.dts=c.pts,64&h&&(c.dts=(14&l[14])<<27|(255&l[15])<<20|(254&l[16])<<12|(255&l[17])<<5|(254&l[18])>>>3,c.dts*=4,c.dts+=(6&l[18])>>>1)),c.data=l.subarray(9+l[8]),r="video"===i||o.packetLength<=e.size,(n||r)&&(e.size=0,e.data.length=0),r&&t.trigger("data",o)}};Zn.prototype.init.call(this),this.push=function(a){({pat:function(){},pes:function(){var t,s;switch(a.streamType){case Fn.H264_STREAM_TYPE:case Fn.H264_STREAM_TYPE:t=e,s="video";break;case Fn.ADTS_STREAM_TYPE:t=i,s="audio";break;case Fn.METADATA_STREAM_TYPE:t=n,s="timed-metadata";break;default:return}a.payloadUnitStartIndicator&&r(t,s,!0),t.data.push(a),t.size+=a.data.byteLength},pmt:function(){var e={type:"metadata",tracks:[]},i=a.programMapTable;null!==i.video&&e.tracks.push({timelineStartInfo:{baseMediaDecodeTime:0},id:+i.video,codec:"avc",type:"video"}),null!==i.audio&&e.tracks.push({timelineStartInfo:{baseMediaDecodeTime:0},id:+i.audio,codec:"adts",type:"audio"}),t.trigger("data",e)}})[a.type]()},this.flush=function(){r(e,"video"),r(i,"audio"),r(n,"timed-metadata"),this.trigger("done")}}).prototype=new on;var er={PAT_PID:0,MP2T_PACKET_LENGTH:188,TransportPacketStream:Kn,TransportParseStream:Qn,ElementaryStream:Zn,TimestampRolloverStream:tr,CaptionStream:qn.CaptionStream,Cea608Stream:qn.Cea608Stream,MetadataStream:Jn};for(var ir in Fn)Fn.hasOwnProperty(ir)&&(er[ir]=Fn[ir]);var nr,rr=er,ar=[96e3,88200,64e3,48e3,44100,32e3,24e3,22050,16e3,12e3,11025,8e3,7350];(nr=function(){var t;nr.prototype.init.call(this),this.push=function(e){var i,n,r,a,s,o,u=0,d=0;if("audio"===e.type)for(t?(a=t,(t=new Uint8Array(a.byteLength+e.data.byteLength)).set(a),t.set(e.data,a.byteLength)):t=e.data;u+5<t.length;)if(255===t[u]&&240==(246&t[u+1])){if(n=2*(1&~t[u+1]),i=(3&t[u+3])<<11|t[u+4]<<3|(224&t[u+5])>>5,o=9e4*(s=1024*(1+(3&t[u+6])))/ar[(60&t[u+2])>>>2],r=u+i,t.byteLength<r)return;if(this.trigger("data",{pts:e.pts+d*o,dts:e.dts+d*o,sampleCount:s,audioobjecttype:1+(t[u+2]>>>6&3),channelcount:(1&t[u+2])<<2|(192&t[u+3])>>>6,samplerate:ar[(60&t[u+2])>>>2],samplingfrequencyindex:(60&t[u+2])>>>2,samplesize:16,data:t.subarray(u+7+n,r)}),t.byteLength===r)return void(t=void 0);d++,t=t.subarray(r)}else u++},this.flush=function(){this.trigger("done")}}).prototype=new on;var sr,or,ur,dr=nr,lr=function(t){var e=t.byteLength,i=0,n=0;this.length=function(){return 8*e},this.bitsAvailable=function(){return 8*e+n},this.loadWord=function(){var r=t.byteLength-e,a=new Uint8Array(4),s=Math.min(4,e);if(0===s)throw new Error("no bytes available");a.set(t.subarray(r,r+s)),i=new DataView(a.buffer).getUint32(0),n=8*s,e-=s},this.skipBits=function(t){var r;n>t?(i<<=t,n-=t):(t-=n,t-=8*(r=Math.floor(t/8)),e-=r,this.loadWord(),i<<=t,n-=t)},this.readBits=function(t){var r=Math.min(n,t),a=i>>>32-r;return(n-=r)>0?i<<=r:e>0&&this.loadWord(),(r=t-r)>0?a<<r|this.readBits(r):a},this.skipLeadingZeros=function(){var t;for(t=0;t<n;++t)if(0!=(i&2147483648>>>t))return i<<=t,n-=t,t;return this.loadWord(),t+this.skipLeadingZeros()},this.skipUnsignedExpGolomb=function(){this.skipBits(1+this.skipLeadingZeros())},this.skipExpGolomb=function(){this.skipBits(1+this.skipLeadingZeros())},this.readUnsignedExpGolomb=function(){var t=this.skipLeadingZeros();return this.readBits(t+1)-1},this.readExpGolomb=function(){var t=this.readUnsignedExpGolomb();return 1&t?1+t>>>1:-1*(t>>>1)},this.readBoolean=function(){return 1===this.readBits(1)},this.readUnsignedByte=function(){return this.readBits(8)},this.loadWord()};(or=function(){var t,e,i=0;or.prototype.init.call(this),this.push=function(n){var r;for(e?((r=new Uint8Array(e.byteLength+n.data.byteLength)).set(e),r.set(n.data,e.byteLength),e=r):e=n.data;i<e.byteLength-3;i++)if(1===e[i+2]){t=i+5;break}for(;t<e.byteLength;)switch(e[t]){case 0:if(0!==e[t-1]){t+=2;break}if(0!==e[t-2]){t++;break}i+3!==t-2&&this.trigger("data",e.subarray(i+3,t-2));do{t++}while(1!==e[t]&&t<e.length);i=t-2,t+=3;break;case 1:if(0!==e[t-1]||0!==e[t-2]){t+=3;break}this.trigger("data",e.subarray(i+3,t-2)),i=t-2,t+=3;break;default:t+=3}e=e.subarray(i),t-=i,i=0},this.flush=function(){e&&e.byteLength>3&&this.trigger("data",e.subarray(i+3)),e=null,i=0,this.trigger("done")}}).prototype=new on,ur={100:!0,110:!0,122:!0,244:!0,44:!0,83:!0,86:!0,118:!0,128:!0,138:!0,139:!0,134:!0},(sr=function(){var t,e,i,n,r,a,s,o=new or;sr.prototype.init.call(this),t=this,this.push=function(t){"video"===t.type&&(e=t.trackId,i=t.pts,n=t.dts,o.push(t))},o.on("data",function(s){var o={trackId:e,pts:i,dts:n,data:s};switch(31&s[0]){case 5:o.nalUnitType="slice_layer_without_partitioning_rbsp_idr";break;case 6:o.nalUnitType="sei_rbsp",o.escapedRBSP=r(s.subarray(1));break;case 7:o.nalUnitType="seq_parameter_set_rbsp",o.escapedRBSP=r(s.subarray(1)),o.config=a(o.escapedRBSP);break;case 8:o.nalUnitType="pic_parameter_set_rbsp";break;case 9:o.nalUnitType="access_unit_delimiter_rbsp"}t.trigger("data",o)}),o.on("done",function(){t.trigger("done")}),this.flush=function(){o.flush()},s=function(t,e){var i,n=8,r=8;for(i=0;i<t;i++)0!==r&&(r=(n+e.readExpGolomb()+256)%256),n=0===r?n:r},r=function(t){for(var e,i,n=t.byteLength,r=[],a=1;a<n-2;)0===t[a]&&0===t[a+1]&&3===t[a+2]?(r.push(a+2),a+=2):a++;if(0===r.length)return t;e=n-r.length,i=new Uint8Array(e);var s=0;for(a=0;a<e;s++,a++)s===r[0]&&(s++,r.shift()),i[a]=t[s];return i},a=function(t){var e,i,n,r,a,o,u,d,l,c,h,f,p,m=0,g=0,y=0,_=0,v=1;if(i=(e=new lr(t)).readUnsignedByte(),r=e.readUnsignedByte(),n=e.readUnsignedByte(),e.skipUnsignedExpGolomb(),ur[i]&&(3===(a=e.readUnsignedExpGolomb())&&e.skipBits(1),e.skipUnsignedExpGolomb(),e.skipUnsignedExpGolomb(),e.skipBits(1),e.readBoolean()))for(h=3!==a?8:12,p=0;p<h;p++)e.readBoolean()&&s(p<6?16:64,e);if(e.skipUnsignedExpGolomb(),0===(o=e.readUnsignedExpGolomb()))e.readUnsignedExpGolomb();else if(1===o)for(e.skipBits(1),e.skipExpGolomb(),e.skipExpGolomb(),u=e.readUnsignedExpGolomb(),p=0;p<u;p++)e.skipExpGolomb();if(e.skipUnsignedExpGolomb(),e.skipBits(1),d=e.readUnsignedExpGolomb(),l=e.readUnsignedExpGolomb(),0===(c=e.readBits(1))&&e.skipBits(1),e.skipBits(1),e.readBoolean()&&(m=e.readUnsignedExpGolomb(),g=e.readUnsignedExpGolomb(),y=e.readUnsignedExpGolomb(),_=e.readUnsignedExpGolomb()),e.readBoolean()&&e.readBoolean()){switch(e.readUnsignedByte()){case 1:f=[1,1];break;case 2:f=[12,11];break;case 3:f=[10,11];break;case 4:f=[16,11];break;case 5:f=[40,33];break;case 6:f=[24,11];break;case 7:f=[20,11];break;case 8:f=[32,11];break;case 9:f=[80,33];break;case 10:f=[18,11];break;case 11:f=[15,11];break;case 12:f=[64,33];break;case 13:f=[160,99];break;case 14:f=[4,3];break;case 15:f=[3,2];break;case 16:f=[2,1];break;case 255:f=[e.readUnsignedByte()<<8|e.readUnsignedByte(),e.readUnsignedByte()<<8|e.readUnsignedByte()]}f&&(v=f[0]/f[1])}return{profileIdc:i,levelIdc:n,profileCompatibility:r,width:Math.ceil((16*(d+1)-2*m-2*g)*v),height:(2-c)*(l+1)*16-2*y-2*_}}}).prototype=new on;var cr,hr={H264Stream:sr,NalByteStream:or},fr=[96e3,88200,64e3,48e3,44100,32e3,24e3,22050,16e3,12e3,11025,8e3,7350],pr=function(t){return t[0]<<21|t[1]<<14|t[2]<<7|t[3]},mr={isLikelyAacData:function(t){return t[0]==="I".charCodeAt(0)&&t[1]==="D".charCodeAt(0)&&t[2]==="3".charCodeAt(0)},parseId3TagSize:function(t,e){var i=t[e+6]<<21|t[e+7]<<14|t[e+8]<<7|t[e+9];return(16&t[e+5])>>4?i+20:i+10},parseAdtsSize:function(t,e){var i=(224&t[e+5])>>5,n=t[e+4]<<3;return 6144&t[e+3]|n|i},parseType:function(t,e){return t[e]==="I".charCodeAt(0)&&t[e+1]==="D".charCodeAt(0)&&t[e+2]==="3".charCodeAt(0)?"timed-metadata":!0&t[e]&&240==(240&t[e+1])?"audio":null},parseSampleRate:function(t){for(var e=0;e+5<t.length;){if(255===t[e]&&240==(246&t[e+1]))return fr[(60&t[e+2])>>>2];e++}return null},parseAacTimestamp:function(t){var e,i,n;e=10,64&t[5]&&(e+=4,e+=pr(t.subarray(10,14)));do{if((i=pr(t.subarray(e+4,e+8)))<1)return null;if("PRIV"===String.fromCharCode(t[e],t[e+1],t[e+2],t[e+3])){n=t.subarray(e+10,e+i+10);for(var r=0;r<n.byteLength;r++)if(0===n[r]){if("com.apple.streaming.transportStreamTimestamp"===unescape(function(t,e,i){var n,r="";for(n=e;n<i;n++)r+="%"+("00"+t[n].toString(16)).slice(-2);return r}(n,0,r))){var a=n.subarray(r+1),s=(1&a[3])<<30|a[4]<<22|a[5]<<14|a[6]<<6|a[7]>>>2;return s*=4,s+=3&a[7]}break}}e+=10,e+=i}while(e<t.byteLength);return null}};(cr=function(){var t=new Uint8Array,e=0;cr.prototype.init.call(this),this.setTimestamp=function(t){e=t},this.push=function(i){var n,r,a,s,o=0,u=0;for(t.length?(s=t.length,(t=new Uint8Array(i.byteLength+s)).set(t.subarray(0,s)),t.set(i,s)):t=i;t.length-u>=3;)if(t[u]!=="I".charCodeAt(0)||t[u+1]!=="D".charCodeAt(0)||t[u+2]!=="3".charCodeAt(0))if(255!=(255&t[u])||240!=(240&t[u+1]))u++;else{if(t.length-u<7)break;if(u+(o=mr.parseAdtsSize(t,u))>t.length)break;a={type:"audio",data:t.subarray(u,u+o),pts:e,dts:e},this.trigger("data",a),u+=o}else{if(t.length-u<10)break;if(u+(o=mr.parseId3TagSize(t,u))>t.length)break;r={type:"timed-metadata",data:t.subarray(u,u+o)},this.trigger("data",r),u+=o}n=t.length-u,t=n>0?t.subarray(u):new Uint8Array}}).prototype=new on;var gr,yr,_r,vr,br=cr,Tr=hr.H264Stream,Sr=mr.isLikelyAacData,kr=["audioobjecttype","channelcount","samplerate","samplingfrequencyindex","samplesize"],wr=["width","height","profileIdc","levelIdc","profileCompatibility"],Ur=function(t,e){var i;if(t.length!==e.length)return!1;for(i=0;i<t.length;i++)if(t[i]!==e[i])return!1;return!0};(yr=function(t,e){var i=[],n=0,r=0,a=0,s=1/0;e=e||{},yr.prototype.init.call(this),this.push=function(e){An(t,e),t&&kr.forEach(function(i){t[i]=e[i]}),i.push(e)},this.setEarliestDts=function(e){r=e-t.timelineStartInfo.baseMediaDecodeTime},this.setVideoBaseMediaDecodeTime=function(t){s=t},this.setAudioAppendStart=function(t){a=t},this.flush=function(){var o,u,d,l;0!==i.length?(o=Sn(i,t,r),t.baseMediaDecodeTime=Ln(t,e.keepOriginalTimestamps),Tn(t,o,a,s),t.samples=kn(o),d=Ji.mdat(wn(o)),i=[],u=Ji.moof(n,[t]),l=new Uint8Array(u.byteLength+d.byteLength),n++,l.set(u),l.set(d,u.byteLength),Un(t),this.trigger("data",{track:t,boxes:l}),this.trigger("done","AudioSegmentStream")):this.trigger("done","AudioSegmentStream")}}).prototype=new on,(gr=function(t,e){var i,n,r=0,a=[],s=[];e=e||{},gr.prototype.init.call(this),delete t.minPTS,this.gopCache_=[],this.push=function(e){An(t,e),"seq_parameter_set_rbsp"!==e.nalUnitType||i||(i=e.config,t.sps=[e.data],wr.forEach(function(e){t[e]=i[e]},this)),"pic_parameter_set_rbsp"!==e.nalUnitType||n||(n=e.data,t.pps=[e.data]),a.push(e)},this.flush=function(){for(var i,n,o,u,d,l;a.length&&"access_unit_delimiter_rbsp"!==a[0].nalUnitType;)a.shift();if(0===a.length)return this.resetStream_(),void this.trigger("done","VideoSegmentStream");if(i=dn(a),(o=ln(i))[0][0].keyFrame||((n=this.getGopForFusion_(a[0],t))?(o.unshift(n),o.byteLength+=n.byteLength,o.nalCount+=n.nalCount,o.pts=n.pts,o.dts=n.dts,o.duration+=n.duration):o=cn(o)),s.length){var c;if(!(c=e.alignGopsAtEnd?this.alignGopsAtEnd_(o):this.alignGopsAtStart_(o)))return this.gopCache_.unshift({gop:o.pop(),pps:t.pps,sps:t.sps}),this.gopCache_.length=Math.min(6,this.gopCache_.length),a=[],this.resetStream_(),void this.trigger("done","VideoSegmentStream");Un(t),o=c}An(t,o),t.samples=hn(o),d=Ji.mdat(fn(o)),t.baseMediaDecodeTime=Ln(t,e.keepOriginalTimestamps),this.trigger("processedGopsInfo",o.map(function(t){return{pts:t.pts,dts:t.dts,byteLength:t.byteLength}})),this.gopCache_.unshift({gop:o.pop(),pps:t.pps,sps:t.sps}),this.gopCache_.length=Math.min(6,this.gopCache_.length),a=[],this.trigger("baseMediaDecodeTime",t.baseMediaDecodeTime),this.trigger("timelineStartInfo",t.timelineStartInfo),u=Ji.moof(r,[t]),l=new Uint8Array(u.byteLength+d.byteLength),r++,l.set(u),l.set(d,u.byteLength),this.trigger("data",{track:t,boxes:l}),this.resetStream_(),this.trigger("done","VideoSegmentStream")},this.resetStream_=function(){Un(t),i=void 0,n=void 0},this.getGopForFusion_=function(e){var i,n,r,a,s,o=1/0;for(s=0;s<this.gopCache_.length;s++)r=(a=this.gopCache_[s]).gop,t.pps&&Ur(t.pps[0],a.pps[0])&&t.sps&&Ur(t.sps[0],a.sps[0])&&(r.dts<t.timelineStartInfo.dts||(i=e.dts-r.dts-r.duration)>=-1e4&&i<=45e3&&(!n||o>i)&&(n=a,o=i));return n?n.gop:null},this.alignGopsAtStart_=function(t){var e,i,n,r,a,o,u,d;for(a=t.byteLength,o=t.nalCount,u=t.duration,e=i=0;e<s.length&&i<t.length&&(n=s[e],r=t[i],n.pts!==r.pts);)r.pts>n.pts?e++:(i++,a-=r.byteLength,o-=r.nalCount,u-=r.duration);return 0===i?t:i===t.length?null:((d=t.slice(i)).byteLength=a,d.duration=u,d.nalCount=o,d.pts=d[0].pts,d.dts=d[0].dts,d)},this.alignGopsAtEnd_=function(t){var e,i,n,r,a,o,u;for(e=s.length-1,i=t.length-1,a=null,o=!1;e>=0&&i>=0;){if(n=s[e],r=t[i],n.pts===r.pts){o=!0;break}n.pts>r.pts?e--:(e===s.length-1&&(a=i),i--)}if(!o&&null===a)return null;if(0===(u=o?i:a))return t;var d=t.slice(u),l=d.reduce(function(t,e){return t.byteLength+=e.byteLength,t.duration+=e.duration,t.nalCount+=e.nalCount,t},{byteLength:0,duration:0,nalCount:0});return d.byteLength=l.byteLength,d.duration=l.duration,d.nalCount=l.nalCount,d.pts=d[0].pts,d.dts=d[0].dts,d},this.alignGopsWith=function(t){s=t}}).prototype=new on,(vr=function(t,e){this.numberOfTracks=0,this.metadataStream=e,void 0!==(t=t||{}).remux?this.remuxTracks=!!t.remux:this.remuxTracks=!0,"boolean"==typeof t.keepOriginalTimestamps&&(this.keepOriginalTimestamps=t.keepOriginalTimestamps),this.pendingTracks=[],this.videoTrack=null,this.pendingBoxes=[],this.pendingCaptions=[],this.pendingMetadata=[],this.pendingBytes=0,this.emittedTracks=0,vr.prototype.init.call(this),this.push=function(t){return t.text?this.pendingCaptions.push(t):t.frames?this.pendingMetadata.push(t):(this.pendingTracks.push(t.track),this.pendingBoxes.push(t.boxes),this.pendingBytes+=t.boxes.byteLength,"video"===t.track.type&&(this.videoTrack=t.track),void("audio"===t.track.type&&(this.audioTrack=t.track)))}}).prototype=new on,vr.prototype.flush=function(t){var e,i,n,r,a=0,s={captions:[],captionStreams:{},metadata:[],info:{}},o=0;if(this.pendingTracks.length<this.numberOfTracks){if("VideoSegmentStream"!==t&&"AudioSegmentStream"!==t)return;if(this.remuxTracks)return;if(0===this.pendingTracks.length)return this.emittedTracks++,void(this.emittedTracks>=this.numberOfTracks&&(this.trigger("done"),this.emittedTracks=0))}for(this.videoTrack?(o=this.videoTrack.timelineStartInfo.pts,wr.forEach(function(t){s.info[t]=this.videoTrack[t]},this)):this.audioTrack&&(o=this.audioTrack.timelineStartInfo.pts,kr.forEach(function(t){s.info[t]=this.audioTrack[t]},this)),1===this.pendingTracks.length?s.type=this.pendingTracks[0].type:s.type="combined",this.emittedTracks+=this.pendingTracks.length,n=Ji.initSegment(this.pendingTracks),s.initSegment=new Uint8Array(n.byteLength),s.initSegment.set(n),s.data=new Uint8Array(this.pendingBytes),r=0;r<this.pendingBoxes.length;r++)s.data.set(this.pendingBoxes[r],a),a+=this.pendingBoxes[r].byteLength;for(r=0;r<this.pendingCaptions.length;r++)(e=this.pendingCaptions[r]).startTime=e.startPts,this.keepOriginalTimestamps||(e.startTime-=o),e.startTime/=9e4,e.endTime=e.endPts,this.keepOriginalTimestamps||(e.endTime-=o),e.endTime/=9e4,s.captionStreams[e.stream]=!0,s.captions.push(e);for(r=0;r<this.pendingMetadata.length;r++)(i=this.pendingMetadata[r]).cueTime=i.pts,this.keepOriginalTimestamps||(i.cueTime-=o),i.cueTime/=9e4,s.metadata.push(i);s.metadata.dispatchType=this.metadataStream.dispatchType,this.pendingTracks.length=0,this.videoTrack=null,this.pendingBoxes.length=0,this.pendingCaptions.length=0,this.pendingBytes=0,this.pendingMetadata.length=0,this.trigger("data",s),this.emittedTracks>=this.numberOfTracks&&(this.trigger("done"),this.emittedTracks=0)},(_r=function(t){var e,i,n=this,r=!0;_r.prototype.init.call(this),t=t||{},this.baseMediaDecodeTime=t.baseMediaDecodeTime||0,this.transmuxPipeline_={},this.setupAacPipeline=function(){var e={};this.transmuxPipeline_=e,e.type="aac",e.metadataStream=new rr.MetadataStream,e.aacStream=new br,e.audioTimestampRolloverStream=new rr.TimestampRolloverStream("audio"),e.timedMetadataTimestampRolloverStream=new rr.TimestampRolloverStream("timed-metadata"),e.adtsStream=new dr,e.coalesceStream=new vr(t,e.metadataStream),e.headOfPipeline=e.aacStream,e.aacStream.pipe(e.audioTimestampRolloverStream).pipe(e.adtsStream),e.aacStream.pipe(e.timedMetadataTimestampRolloverStream).pipe(e.metadataStream).pipe(e.coalesceStream),e.metadataStream.on("timestamp",function(t){e.aacStream.setTimestamp(t.timeStamp)}),e.aacStream.on("data",function(r){"timed-metadata"!==r.type||e.audioSegmentStream||(i=i||{timelineStartInfo:{baseMediaDecodeTime:n.baseMediaDecodeTime},codec:"adts",type:"audio"},e.coalesceStream.numberOfTracks++,e.audioSegmentStream=new yr(i,t),e.adtsStream.pipe(e.audioSegmentStream).pipe(e.coalesceStream))}),e.coalesceStream.on("data",this.trigger.bind(this,"data")),e.coalesceStream.on("done",this.trigger.bind(this,"done"))},this.setupTsPipeline=function(){var r={};this.transmuxPipeline_=r,r.type="ts",r.metadataStream=new rr.MetadataStream,r.packetStream=new rr.TransportPacketStream,r.parseStream=new rr.TransportParseStream,r.elementaryStream=new rr.ElementaryStream,r.videoTimestampRolloverStream=new rr.TimestampRolloverStream("video"),r.audioTimestampRolloverStream=new rr.TimestampRolloverStream("audio"),r.timedMetadataTimestampRolloverStream=new rr.TimestampRolloverStream("timed-metadata"),r.adtsStream=new dr,r.h264Stream=new Tr,r.captionStream=new rr.CaptionStream,r.coalesceStream=new vr(t,r.metadataStream),r.headOfPipeline=r.packetStream,r.packetStream.pipe(r.parseStream).pipe(r.elementaryStream),r.elementaryStream.pipe(r.videoTimestampRolloverStream).pipe(r.h264Stream),r.elementaryStream.pipe(r.audioTimestampRolloverStream).pipe(r.adtsStream),r.elementaryStream.pipe(r.timedMetadataTimestampRolloverStream).pipe(r.metadataStream).pipe(r.coalesceStream),r.h264Stream.pipe(r.captionStream).pipe(r.coalesceStream),r.elementaryStream.on("data",function(a){var s;if("metadata"===a.type){for(s=a.tracks.length;s--;)e||"video"!==a.tracks[s].type?i||"audio"!==a.tracks[s].type||((i=a.tracks[s]).timelineStartInfo.baseMediaDecodeTime=n.baseMediaDecodeTime):(e=a.tracks[s]).timelineStartInfo.baseMediaDecodeTime=n.baseMediaDecodeTime;e&&!r.videoSegmentStream&&(r.coalesceStream.numberOfTracks++,r.videoSegmentStream=new gr(e,t),r.videoSegmentStream.on("timelineStartInfo",function(t){i&&(i.timelineStartInfo=t,r.audioSegmentStream.setEarliestDts(t.dts))}),r.videoSegmentStream.on("processedGopsInfo",n.trigger.bind(n,"gopInfo")),r.videoSegmentStream.on("baseMediaDecodeTime",function(t){i&&r.audioSegmentStream.setVideoBaseMediaDecodeTime(t)}),r.h264Stream.pipe(r.videoSegmentStream).pipe(r.coalesceStream)),i&&!r.audioSegmentStream&&(r.coalesceStream.numberOfTracks++,r.audioSegmentStream=new yr(i,t),r.adtsStream.pipe(r.audioSegmentStream).pipe(r.coalesceStream))}}),r.coalesceStream.on("data",this.trigger.bind(this,"data")),r.coalesceStream.on("done",this.trigger.bind(this,"done"))},this.setBaseMediaDecodeTime=function(n){var r=this.transmuxPipeline_;t.keepOriginalTimestamps||(this.baseMediaDecodeTime=n),i&&(i.timelineStartInfo.dts=void 0,i.timelineStartInfo.pts=void 0,Un(i),t.keepOriginalTimestamps||(i.timelineStartInfo.baseMediaDecodeTime=n),r.audioTimestampRolloverStream&&r.audioTimestampRolloverStream.discontinuity()),e&&(r.videoSegmentStream&&(r.videoSegmentStream.gopCache_=[],r.videoTimestampRolloverStream.discontinuity()),e.timelineStartInfo.dts=void 0,e.timelineStartInfo.pts=void 0,Un(e),r.captionStream.reset(),t.keepOriginalTimestamps||(e.timelineStartInfo.baseMediaDecodeTime=n)),r.timedMetadataTimestampRolloverStream&&r.timedMetadataTimestampRolloverStream.discontinuity()},this.setAudioAppendStart=function(t){i&&this.transmuxPipeline_.audioSegmentStream.setAudioAppendStart(t)},this.alignGopsWith=function(t){e&&this.transmuxPipeline_.videoSegmentStream&&this.transmuxPipeline_.videoSegmentStream.alignGopsWith(t)},this.push=function(t){if(r){var e=Sr(t);e&&"aac"!==this.transmuxPipeline_.type?this.setupAacPipeline():e||"ts"===this.transmuxPipeline_.type||this.setupTsPipeline(),r=!1}this.transmuxPipeline_.headOfPipeline.push(t)},this.flush=function(){r=!0,this.transmuxPipeline_.headOfPipeline.flush()},this.resetCaptions=function(){this.transmuxPipeline_.captionStream&&this.transmuxPipeline_.captionStream.reset()}}).prototype=new on;var Lr,Ar,Er={Transmuxer:_r,VideoSegmentStream:gr,AudioSegmentStream:yr,AUDIO_PROPERTIES:kr,VIDEO_PROPERTIES:wr},Or=qi.parseType,Cr=function(t){return new Date(1e3*t-20828448e5)},Ir=function(t){return{isLeading:(12&t[0])>>>2,dependsOn:3&t[0],isDependedOn:(192&t[1])>>>6,hasRedundancy:(48&t[1])>>>4,paddingValue:(14&t[1])>>>1,isNonSyncSample:1&t[1],degradationPriority:t[2]<<8|t[3]}},Dr={avc1:function(t){var e=new DataView(t.buffer,t.byteOffset,t.byteLength);return{dataReferenceIndex:e.getUint16(6),width:e.getUint16(24),height:e.getUint16(26),horizresolution:e.getUint16(28)+e.getUint16(30)/16,vertresolution:e.getUint16(32)+e.getUint16(34)/16,frameCount:e.getUint16(40),depth:e.getUint16(74),config:Lr(t.subarray(78,t.byteLength))}},avcC:function(t){var e,i,n,r,a=new DataView(t.buffer,t.byteOffset,t.byteLength),s={configurationVersion:t[0],avcProfileIndication:t[1],profileCompatibility:t[2],avcLevelIndication:t[3],lengthSizeMinusOne:3&t[4],sps:[],pps:[]},o=31&t[5];for(n=6,r=0;r<o;r++)i=a.getUint16(n),n+=2,s.sps.push(new Uint8Array(t.subarray(n,n+i))),n+=i;for(e=t[n],n++,r=0;r<e;r++)i=a.getUint16(n),n+=2,s.pps.push(new Uint8Array(t.subarray(n,n+i))),n+=i;return s},btrt:function(t){var e=new DataView(t.buffer,t.byteOffset,t.byteLength);return{bufferSizeDB:e.getUint32(0),maxBitrate:e.getUint32(4),avgBitrate:e.getUint32(8)}},esds:function(t){return{version:t[0],flags:new Uint8Array(t.subarray(1,4)),esId:t[6]<<8|t[7],streamPriority:31&t[8],decoderConfig:{objectProfileIndication:t[11],streamType:t[12]>>>2&63,bufferSize:t[13]<<16|t[14]<<8|t[15],maxBitrate:t[16]<<24|t[17]<<16|t[18]<<8|t[19],avgBitrate:t[20]<<24|t[21]<<16|t[22]<<8|t[23],decoderConfigDescriptor:{tag:t[24],length:t[25],audioObjectType:t[26]>>>3&31,samplingFrequencyIndex:(7&t[26])<<1|t[27]>>>7&1,channelConfiguration:t[27]>>>3&15}}}},ftyp:function(t){for(var e=new DataView(t.buffer,t.byteOffset,t.byteLength),i={majorBrand:Or(t.subarray(0,4)),minorVersion:e.getUint32(4),compatibleBrands:[]},n=8;n<t.byteLength;)i.compatibleBrands.push(Or(t.subarray(n,n+4))),n+=4;return i},dinf:function(t){return{boxes:Lr(t)}},dref:function(t){return{version:t[0],flags:new Uint8Array(t.subarray(1,4)),dataReferences:Lr(t.subarray(8))}},hdlr:function(t){var e={version:new DataView(t.buffer,t.byteOffset,t.byteLength).getUint8(0),flags:new Uint8Array(t.subarray(1,4)),handlerType:Or(t.subarray(8,12)),name:""},i=8;for(i=24;i<t.byteLength;i++){if(0===t[i]){i++;break}e.name+=String.fromCharCode(t[i])}return e.name=decodeURIComponent(escape(e.name)),e},mdat:function(t){return{byteLength:t.byteLength,nals:function(t){var e,i,n=new DataView(t.buffer,t.byteOffset,t.byteLength),r=[];for(e=0;e+4<t.length;e+=i)if(i=n.getUint32(e),e+=4,i<=0)r.push("<span style='color:red;'>MALFORMED DATA</span>");else switch(31&t[e]){case 1:r.push("slice_layer_without_partitioning_rbsp");break;case 5:r.push("slice_layer_without_partitioning_rbsp_idr");break;case 6:r.push("sei_rbsp");break;case 7:r.push("seq_parameter_set_rbsp");break;case 8:r.push("pic_parameter_set_rbsp");break;case 9:r.push("access_unit_delimiter_rbsp");break;default:r.push("UNKNOWN NAL - "+t[e]&31)}return r}(t)}},mdhd:function(t){var e,i=new DataView(t.buffer,t.byteOffset,t.byteLength),n=4,r={version:i.getUint8(0),flags:new Uint8Array(t.subarray(1,4)),language:""};return 1===r.version?(n+=4,r.creationTime=Cr(i.getUint32(n)),n+=8,r.modificationTime=Cr(i.getUint32(n)),n+=4,r.timescale=i.getUint32(n),n+=8,r.duration=i.getUint32(n)):(r.creationTime=Cr(i.getUint32(n)),n+=4,r.modificationTime=Cr(i.getUint32(n)),n+=4,r.timescale=i.getUint32(n),n+=4,r.duration=i.getUint32(n)),n+=4,e=i.getUint16(n),r.language+=String.fromCharCode(96+(e>>10)),r.language+=String.fromCharCode(96+((992&e)>>5)),r.language+=String.fromCharCode(96+(31&e)),r},mdia:function(t){return{boxes:Lr(t)}},mfhd:function(t){return{version:t[0],flags:new Uint8Array(t.subarray(1,4)),sequenceNumber:t[4]<<24|t[5]<<16|t[6]<<8|t[7]}},minf:function(t){return{boxes:Lr(t)}},mp4a:function(t){var e=new DataView(t.buffer,t.byteOffset,t.byteLength),i={dataReferenceIndex:e.getUint16(6),channelcount:e.getUint16(16),samplesize:e.getUint16(18),samplerate:e.getUint16(24)+e.getUint16(26)/65536};return t.byteLength>28&&(i.streamDescriptor=Lr(t.subarray(28))[0]),i},moof:function(t){return{boxes:Lr(t)}},moov:function(t){return{boxes:Lr(t)}},mvex:function(t){return{boxes:Lr(t)}},mvhd:function(t){var e=new DataView(t.buffer,t.byteOffset,t.byteLength),i=4,n={version:e.getUint8(0),flags:new Uint8Array(t.subarray(1,4))};return 1===n.version?(i+=4,n.creationTime=Cr(e.getUint32(i)),i+=8,n.modificationTime=Cr(e.getUint32(i)),i+=4,n.timescale=e.getUint32(i),i+=8,n.duration=e.getUint32(i)):(n.creationTime=Cr(e.getUint32(i)),i+=4,n.modificationTime=Cr(e.getUint32(i)),i+=4,n.timescale=e.getUint32(i),i+=4,n.duration=e.getUint32(i)),i+=4,n.rate=e.getUint16(i)+e.getUint16(i+2)/16,i+=4,n.volume=e.getUint8(i)+e.getUint8(i+1)/8,i+=2,i+=2,i+=8,n.matrix=new Uint32Array(t.subarray(i,i+36)),i+=36,i+=24,n.nextTrackId=e.getUint32(i),n},pdin:function(t){var e=new DataView(t.buffer,t.byteOffset,t.byteLength);return{version:e.getUint8(0),flags:new Uint8Array(t.subarray(1,4)),rate:e.getUint32(4),initialDelay:e.getUint32(8)}},sdtp:function(t){var e,i={version:t[0],flags:new Uint8Array(t.subarray(1,4)),samples:[]};for(e=4;e<t.byteLength;e++)i.samples.push({dependsOn:(48&t[e])>>4,isDependedOn:(12&t[e])>>2,hasRedundancy:3&t[e]});return i},sidx:function(t){var e,i=new DataView(t.buffer,t.byteOffset,t.byteLength),n={version:t[0],flags:new Uint8Array(t.subarray(1,4)),references:[],referenceId:i.getUint32(4),timescale:i.getUint32(8),earliestPresentationTime:i.getUint32(12),firstOffset:i.getUint32(16)},r=i.getUint16(22);for(e=24;r;e+=12,r--)n.references.push({referenceType:(128&t[e])>>>7,referencedSize:2147483647&i.getUint32(e),subsegmentDuration:i.getUint32(e+4),startsWithSap:!!(128&t[e+8]),sapType:(112&t[e+8])>>>4,sapDeltaTime:268435455&i.getUint32(e+8)});return n},smhd:function(t){return{version:t[0],flags:new Uint8Array(t.subarray(1,4)),balance:t[4]+t[5]/256}},stbl:function(t){return{boxes:Lr(t)}},stco:function(t){var e,i=new DataView(t.buffer,t.byteOffset,t.byteLength),n={version:t[0],flags:new Uint8Array(t.subarray(1,4)),chunkOffsets:[]},r=i.getUint32(4);for(e=8;r;e+=4,r--)n.chunkOffsets.push(i.getUint32(e));return n},stsc:function(t){var e,i=new DataView(t.buffer,t.byteOffset,t.byteLength),n=i.getUint32(4),r={version:t[0],flags:new Uint8Array(t.subarray(1,4)),sampleToChunks:[]};for(e=8;n;e+=12,n--)r.sampleToChunks.push({firstChunk:i.getUint32(e),samplesPerChunk:i.getUint32(e+4),sampleDescriptionIndex:i.getUint32(e+8)});return r},stsd:function(t){return{version:t[0],flags:new Uint8Array(t.subarray(1,4)),sampleDescriptions:Lr(t.subarray(8))}},stsz:function(t){var e,i=new DataView(t.buffer,t.byteOffset,t.byteLength),n={version:t[0],flags:new Uint8Array(t.subarray(1,4)),sampleSize:i.getUint32(4),entries:[]};for(e=12;e<t.byteLength;e+=4)n.entries.push(i.getUint32(e));return n},stts:function(t){var e,i=new DataView(t.buffer,t.byteOffset,t.byteLength),n={version:t[0],flags:new Uint8Array(t.subarray(1,4)),timeToSamples:[]},r=i.getUint32(4);for(e=8;r;e+=8,r--)n.timeToSamples.push({sampleCount:i.getUint32(e),sampleDelta:i.getUint32(e+4)});return n},styp:function(t){return Dr.ftyp(t)},tfdt:function(t){var e={version:t[0],flags:new Uint8Array(t.subarray(1,4)),baseMediaDecodeTime:t[4]<<24|t[5]<<16|t[6]<<8|t[7]};return 1===e.version&&(e.baseMediaDecodeTime*=Math.pow(2,32),e.baseMediaDecodeTime+=t[8]<<24|t[9]<<16|t[10]<<8|t[11]),e},tfhd:function(t){var e,i=new DataView(t.buffer,t.byteOffset,t.byteLength),n={version:t[0],flags:new Uint8Array(t.subarray(1,4)),trackId:i.getUint32(4)},r=1&n.flags[2],a=2&n.flags[2],s=8&n.flags[2],o=16&n.flags[2],u=32&n.flags[2],d=65536&n.flags[0],l=131072&n.flags[0];return e=8,r&&(e+=4,n.baseDataOffset=i.getUint32(12),e+=4),a&&(n.sampleDescriptionIndex=i.getUint32(e),e+=4),s&&(n.defaultSampleDuration=i.getUint32(e),e+=4),o&&(n.defaultSampleSize=i.getUint32(e),e+=4),u&&(n.defaultSampleFlags=i.getUint32(e)),d&&(n.durationIsEmpty=!0),!r&&l&&(n.baseDataOffsetIsMoof=!0),n},tkhd:function(t){var e=new DataView(t.buffer,t.byteOffset,t.byteLength),i=4,n={version:e.getUint8(0),flags:new Uint8Array(t.subarray(1,4))};return 1===n.version?(i+=4,n.creationTime=Cr(e.getUint32(i)),i+=8,n.modificationTime=Cr(e.getUint32(i)),i+=4,n.trackId=e.getUint32(i),i+=4,i+=8,n.duration=e.getUint32(i)):(n.creationTime=Cr(e.getUint32(i)),i+=4,n.modificationTime=Cr(e.getUint32(i)),i+=4,n.trackId=e.getUint32(i),i+=4,i+=4,n.duration=e.getUint32(i)),i+=4,i+=8,n.layer=e.getUint16(i),i+=2,n.alternateGroup=e.getUint16(i),i+=2,n.volume=e.getUint8(i)+e.getUint8(i+1)/8,i+=2,i+=2,n.matrix=new Uint32Array(t.subarray(i,i+36)),i+=36,n.width=e.getUint16(i)+e.getUint16(i+2)/16,i+=4,n.height=e.getUint16(i)+e.getUint16(i+2)/16,n},traf:function(t){return{boxes:Lr(t)}},trak:function(t){return{boxes:Lr(t)}},trex:function(t){var e=new DataView(t.buffer,t.byteOffset,t.byteLength);return{version:t[0],flags:new Uint8Array(t.subarray(1,4)),trackId:e.getUint32(4),defaultSampleDescriptionIndex:e.getUint32(8),defaultSampleDuration:e.getUint32(12),defaultSampleSize:e.getUint32(16),sampleDependsOn:3&t[20],sampleIsDependedOn:(192&t[21])>>6,sampleHasRedundancy:(48&t[21])>>4,samplePaddingValue:(14&t[21])>>1,sampleIsDifferenceSample:!!(1&t[21]),sampleDegradationPriority:e.getUint16(22)}},trun:function(t){var e,i={version:t[0],flags:new Uint8Array(t.subarray(1,4)),samples:[]},n=new DataView(t.buffer,t.byteOffset,t.byteLength),r=1&i.flags[2],a=4&i.flags[2],s=1&i.flags[1],o=2&i.flags[1],u=4&i.flags[1],d=8&i.flags[1],l=n.getUint32(4),c=8;for(r&&(i.dataOffset=n.getInt32(c),c+=4),a&&l&&(e={flags:Ir(t.subarray(c,c+4))},c+=4,s&&(e.duration=n.getUint32(c),c+=4),o&&(e.size=n.getUint32(c),c+=4),d&&(e.compositionTimeOffset=n.getUint32(c),c+=4),i.samples.push(e),l--);l--;)e={},s&&(e.duration=n.getUint32(c),c+=4),o&&(e.size=n.getUint32(c),c+=4),u&&(e.flags=Ir(t.subarray(c,c+4)),c+=4),d&&(e.compositionTimeOffset=n.getUint32(c),c+=4),i.samples.push(e);return i},"url ":function(t){return{version:t[0],flags:new Uint8Array(t.subarray(1,4))}},vmhd:function(t){var e=new DataView(t.buffer,t.byteOffset,t.byteLength);return{version:t[0],flags:new Uint8Array(t.subarray(1,4)),graphicsmode:e.getUint16(4),opcolor:new Uint16Array([e.getUint16(6),e.getUint16(8),e.getUint16(10)])}}},Pr={inspect:Lr=function(t){for(var e,i,n,r,a,s=0,o=[],u=new ArrayBuffer(t.length),d=new Uint8Array(u),l=0;l<t.length;++l)d[l]=t[l];for(e=new DataView(u);s<t.byteLength;)i=e.getUint32(s),n=Or(t.subarray(s+4,s+8)),r=i>1?s+i:t.byteLength,(a=(Dr[n]||function(t){return{data:t}})(t.subarray(s+8,r))).size=i,a.type=n,o.push(a),s=r;return o},textify:Ar=function(t,e){var i;return e=e||0,i=new Array(2*e+1).join(" "),t.map(function(t,n){return i+t.type+"\n"+Object.keys(t).filter(function(t){return"type"!==t&&"boxes"!==t}).map(function(e){var n=i+"  "+e+": ",r=t[e];if(r instanceof Uint8Array||r instanceof Uint32Array){var a=Array.prototype.slice.call(new Uint8Array(r.buffer,r.byteOffset,r.byteLength)).map(function(t){return" "+("00"+t.toString(16)).slice(-2)}).join("").match(/.{1,24}/g);return a?1===a.length?n+"<"+a.join("").slice(1)+">":n+"<\n"+a.map(function(t){return i+"  "+t}).join("\n")+"\n"+i+"  >":n+"<>"}return n+JSON.stringify(r,null,2).split("\n").map(function(t,e){return 0===e?t:i+"  "+t}).join("\n")}).join("\n")+(t.boxes?"\n"+Ar(t.boxes,e+1):"")}).join("\n")},parseTfdt:Dr.tfdt,parseHdlr:Dr.hdlr,parseTfhd:Dr.tfhd,parseTrun:Dr.trun},Rr=In,xr=qn.CaptionStream,Mr=function(t,e){for(var i=t,n=0;n<e.length;n++){var r=e[n];if(i<r.size)return r;i-=r.size}return null},Br=function(t,e){var i=qi.findBox(t,["moof","traf"]),n={},r=[];return qi.findBox(t,["mdat"]).forEach(function(t,e){var n=i[e];r.push({mdat:t,traf:n})}),r.forEach(function(t){var i,r=t.mdat,a=t.traf,s=qi.findBox(a,["tfhd"]),o=Pr.parseTfhd(s[0]),u=o.trackId,d=qi.findBox(a,["tfdt"]),l=d.length>0?Pr.parseTfdt(d[0]).baseMediaDecodeTime:0,c=qi.findBox(a,["trun"]);e===u&&c.length>0&&(i=function(t,e,i){var n,r,a,s,o=new DataView(t.buffer,t.byteOffset,t.byteLength),u=[];for(r=0;r+4<t.length;r+=a)if(a=o.getUint32(r),r+=4,!(a<=0))switch(31&t[r]){case 6:var d=t.subarray(r+1,r+1+a),l=Mr(r,e);n={nalUnitType:"sei_rbsp",size:a,data:d,escapedRBSP:Rr(d),trackId:i},l?(n.pts=l.pts,n.dts=l.dts,s=l):(n.pts=s.pts,n.dts=s.dts),u.push(n)}return u}(r,function(t,e,i){var n=e,r=i.defaultSampleDuration||0,a=i.defaultSampleSize||0,s=i.trackId,o=[];return t.forEach(function(t){var e=Pr.parseTrun(t).samples;e.forEach(function(t){void 0===t.duration&&(t.duration=r),void 0===t.size&&(t.size=a),t.trackId=s,t.dts=n,void 0===t.compositionTimeOffset&&(t.compositionTimeOffset=0),t.pts=n+t.compositionTimeOffset,n+=t.duration}),o=o.concat(e)}),o}(c,l,o),u),n[u]||(n[u]=[]),n[u]=n[u].concat(i))}),n},Nr={generator:Ji,probe:qi,Transmuxer:Er.Transmuxer,AudioSegmentStream:Er.AudioSegmentStream,VideoSegmentStream:Er.VideoSegmentStream,CaptionParser:function(){var t,e,i,n,r,a=!1;this.isInitialized=function(){return a},this.init=function(){t=new xr,a=!0,t.on("data",function(t){t.startTime=t.startPts/n,t.endTime=t.endPts/n,r.captions.push(t),r.captionStreams[t.stream]=!0})},this.isNewInit=function(t,e){return!(t&&0===t.length||e&&"object"==typeof e&&0===Object.keys(e).length||i===t[0]&&n===e[i])},this.parse=function(t,a,s){var o;if(!this.isInitialized())return null;if(!a||!s)return null;if(this.isNewInit(a,s))i=a[0],n=s[i];else if(!i||!n)return e.push(t),null;for(;e.length>0;){var u=e.shift();this.parse(u,a,s)}return null!==(o=function(t,e,i){return e?{seiNals:Br(t,e)[e],timescale:i}:null}(t,i,n))&&o.seiNals?(this.pushNals(o.seiNals),this.flushStream(),r):null},this.pushNals=function(e){if(!this.isInitialized()||!e||0===e.length)return null;e.forEach(function(e){t.push(e)})},this.flushStream=function(){if(!this.isInitialized())return null;t.flush()},this.clearParsedCaptions=function(){r.captions=[],r.captionStreams={}},this.resetCaptionStream=function(){if(!this.isInitialized())return null;t.reset()},this.clearAllCaptions=function(){this.clearParsedCaptions(),this.resetCaptionStream()},this.reset=function(){e=[],i=null,n=null,r?this.clearParsedCaptions():r={captions:[],captionStreams:{}},this.resetCaptionStream()},this.reset()}}.CaptionParser,qr=function(t,e,i){if(!t||!e)return!1;var n=i===t.segments.length;return t.endList&&"open"===e.readyState&&n},Fr=function(t){return"number"==typeof t&&isFinite(t)},Gr=function(t){function i(t){T(this,i);var e=w(this,(i.__proto__||Object.getPrototypeOf(i)).call(this));if(!t)throw new TypeError("Initialization settings are required");if("function"!=typeof t.currentTime)throw new TypeError("No currentTime getter specified");if(!t.mediaSource)throw new TypeError("No MediaSource specified");return e.bandwidth=t.bandwidth,e.throughput={rate:0,count:0},e.roundTrip=NaN,e.resetStats_(),e.mediaIndex=null,e.hasPlayed_=t.hasPlayed,e.currentTime_=t.currentTime,e.seekable_=t.seekable,e.seeking_=t.seeking,e.duration_=t.duration,e.mediaSource_=t.mediaSource,e.hls_=t.hls,e.loaderType_=t.loaderType,e.startingMedia_=void 0,e.segmentMetadataTrack_=t.segmentMetadataTrack,e.goalBufferLength_=t.goalBufferLength,e.sourceType_=t.sourceType,e.inbandTextTracks_=t.inbandTextTracks,e.state_="INIT",e.checkBufferTimeout_=null,e.error_=void 0,e.currentTimeline_=-1,e.pendingSegment_=null,e.mimeType_=null,e.sourceUpdater_=null,e.xhrOptions_=null,e.activeInitSegmentId_=null,e.initSegments_={},e.captionParser_=new Nr,e.decrypter_=t.decrypter,e.syncController_=t.syncController,e.syncPoint_={segmentIndex:0,time:0},e.syncController_.on("syncinfoupdate",function(){return e.trigger("syncinfoupdate")}),e.mediaSource_.addEventListener("sourceopen",function(){return e.ended_=!1}),e.fetchAtBuffer_=!1,e.logger_=We("SegmentLoader["+e.loaderType_+"]"),Object.defineProperty(e,"state",{get:function(){return this.state_},set:function(t){t!==this.state_&&(this.logger_(this.state_+" -> "+t),this.state_=t)}}),e}return k(i,t),S(i,[{key:"resetStats_",value:function(){this.mediaBytesTransferred=0,this.mediaRequests=0,this.mediaRequestsAborted=0,this.mediaRequestsTimedout=0,this.mediaRequestsErrored=0,this.mediaTransferDuration=0,this.mediaSecondsLoaded=0}},{key:"dispose",value:function(){this.state="DISPOSED",this.pause(),this.abort_(),this.sourceUpdater_&&this.sourceUpdater_.dispose(),this.resetStats_(),this.captionParser_.reset()}},{key:"abort",value:function(){"WAITING"===this.state?(this.abort_(),this.state="READY",this.paused()||this.monitorBuffer_()):this.pendingSegment_&&(this.pendingSegment_=null)}},{key:"abort_",value:function(){this.pendingSegment_&&this.pendingSegment_.abortRequests(),this.pendingSegment_=null}},{key:"error",value:function(t){return void 0!==t&&(this.error_=t),this.pendingSegment_=null,this.error_}},{key:"endOfStream",value:function(){this.ended_=!0,this.pause(),this.trigger("ended")}},{key:"buffered_",value:function(){return this.sourceUpdater_?this.sourceUpdater_.buffered():e.createTimeRanges()}},{key:"initSegment",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]&&arguments[1];if(!t)return null;var i=mt(t),n=this.initSegments_[i];return e&&!n&&t.bytes&&(this.initSegments_[i]=n={resolvedUri:t.resolvedUri,byterange:t.byterange,bytes:t.bytes,timescales:t.timescales,videoTrackIds:t.videoTrackIds}),n||t}},{key:"couldBeginLoading_",value:function(){return this.playlist_&&(this.sourceUpdater_||this.mimeType_&&"INIT"===this.state)&&!this.paused()}},{key:"load",value:function(){if(this.monitorBuffer_(),this.playlist_){if(this.syncController_.setDateTimeMapping(this.playlist_),"INIT"===this.state&&this.couldBeginLoading_())return this.init_();!this.couldBeginLoading_()||"READY"!==this.state&&"INIT"!==this.state||(this.state="READY")}}},{key:"init_",value:function(){return this.state="READY",this.sourceUpdater_=new Mi(this.mediaSource_,this.mimeType_,this.loaderType_,this.sourceBufferEmitter_),this.resetEverything(),this.monitorBuffer_()}},{key:"playlist",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(t){var i=this.playlist_,n=this.pendingSegment_;this.playlist_=t,this.xhrOptions_=e,this.hasPlayed_()||(t.syncInfo={mediaSequence:t.mediaSequence,time:0});var r=i?i.id:null;if(this.logger_("playlist update ["+r+" => "+t.id+"]"),this.trigger("syncinfoupdate"),"INIT"===this.state&&this.couldBeginLoading_())return this.init_();if(i&&i.uri===t.uri){var a=t.mediaSequence-i.mediaSequence;this.logger_("live window shift ["+a+"]"),null!==this.mediaIndex&&(this.mediaIndex-=a),n&&(n.mediaIndex-=a,n.mediaIndex>=0&&(n.segment=t.segments[n.mediaIndex])),this.syncController_.saveExpiredSegmentInfo(i,t)}else null!==this.mediaIndex&&this.resyncLoader()}}},{key:"pause",value:function(){this.checkBufferTimeout_&&(c.clearTimeout(this.checkBufferTimeout_),this.checkBufferTimeout_=null)}},{key:"paused",value:function(){return null===this.checkBufferTimeout_}},{key:"mimeType",value:function(t,e){this.mimeType_||(this.mimeType_=t,this.sourceBufferEmitter_=e,"INIT"===this.state&&this.couldBeginLoading_()&&this.init_())}},{key:"resetEverything",value:function(t){this.ended_=!1,this.resetLoader(),this.remove(0,this.duration_(),t),this.captionParser_.clearAllCaptions(),this.trigger("reseteverything")}},{key:"resetLoader",value:function(){this.fetchAtBuffer_=!1,this.resyncLoader()}},{key:"resyncLoader",value:function(){this.mediaIndex=null,this.syncPoint_=null,this.abort()}},{key:"remove",value:function(t,e,i){if(this.sourceUpdater_&&this.sourceUpdater_.remove(t,e,i),At(t,e,this.segmentMetadataTrack_),this.inbandTextTracks_)for(var n in this.inbandTextTracks_)At(t,e,this.inbandTextTracks_[n])}},{key:"monitorBuffer_",value:function(){this.checkBufferTimeout_&&c.clearTimeout(this.checkBufferTimeout_),this.checkBufferTimeout_=c.setTimeout(this.monitorBufferTick_.bind(this),1)}},{key:"monitorBufferTick_",value:function(){"READY"===this.state&&this.fillBuffer_(),this.checkBufferTimeout_&&c.clearTimeout(this.checkBufferTimeout_),this.checkBufferTimeout_=c.setTimeout(this.monitorBufferTick_.bind(this),500)}},{key:"fillBuffer_",value:function(){if(!this.sourceUpdater_.updating()){this.syncPoint_||(this.syncPoint_=this.syncController_.getSyncPoint(this.playlist_,this.duration_(),this.currentTimeline_,this.currentTime_()));var t=this.checkBuffer_(this.buffered_(),this.playlist_,this.mediaIndex,this.hasPlayed_(),this.currentTime_(),this.syncPoint_);if(t)qr(this.playlist_,this.mediaSource_,t.mediaIndex)?this.endOfStream():(t.mediaIndex!==this.playlist_.segments.length-1||"ended"!==this.mediaSource_.readyState||this.seeking_())&&((t.timeline!==this.currentTimeline_||null!==t.startOfSegment&&t.startOfSegment<this.sourceUpdater_.timestampOffset())&&(this.syncController_.reset(),t.timestampOffset=t.startOfSegment,this.captionParser_.clearAllCaptions()),this.loadSegment_(t))}}},{key:"checkBuffer_",value:function(t,e,i,n,r,a){var s=0,o=void 0;t.length&&(s=t.end(t.length-1));var u=Math.max(0,s-r);if(!e.segments.length)return null;if(u>=this.goalBufferLength_())return null;if(!n&&u>=1)return null;if(null===a)return i=this.getSyncSegmentCandidate_(e),this.generateSegmentInfo_(e,i,null,!0);if(null!==i){var d=e.segments[i];return o=d&&d.end?d.end:s,this.generateSegmentInfo_(e,i+1,o,!1)}if(this.fetchAtBuffer_){var l=K.getMediaInfoForTime(e,s,a.segmentIndex,a.time);i=l.mediaIndex,o=l.startTime}else{var c=K.getMediaInfoForTime(e,r,a.segmentIndex,a.time);i=c.mediaIndex,o=c.startTime}return this.generateSegmentInfo_(e,i,o,!1)}},{key:"getSyncSegmentCandidate_",value:function(t){var e=this;if(-1===this.currentTimeline_)return 0;var i=t.segments.map(function(t,e){return{timeline:t.timeline,segmentIndex:e}}).filter(function(t){return t.timeline===e.currentTimeline_});return i.length?i[Math.min(i.length-1,1)].segmentIndex:Math.max(t.segments.length-1,0)}},{key:"generateSegmentInfo_",value:function(t,e,i,n){if(e<0||e>=t.segments.length)return null;var r=t.segments[e];return{requestId:"segment-loader-"+Math.random(),uri:r.resolvedUri,mediaIndex:e,isSyncRequest:n,startOfSegment:i,playlist:t,bytes:null,encryptedBytes:null,timestampOffset:null,timeline:r.timeline,duration:r.duration,segment:r}}},{key:"abortRequestEarly_",value:function(t){if(this.hls_.tech_.paused()||!this.xhrOptions_.timeout||!this.playlist_.attributes.BANDWIDTH)return!1;if(Date.now()-(t.firstBytesReceivedAt||Date.now())<1e3)return!1;var e=this.currentTime_(),i=t.bandwidth,n=this.pendingSegment_.duration,r=K.estimateSegmentRequestTime(n,i,this.playlist_,t.bytesReceived),a=function(t,e){var i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:1;return((t.length?t.end(t.length-1):0)-e)/i}(this.buffered_(),e,this.hls_.tech_.playbackRate())-1;if(r<=a)return!1;var s=function(t){var e=t.master,i=t.currentTime,n=t.bandwidth,r=t.duration,a=t.segmentDuration,s=t.timeUntilRebuffer,o=t.currentTimeline,u=t.syncController,d=e.playlists.filter(function(t){return!K.isIncompatible(t)}),l=d.filter(K.isEnabled);l.length||(l=d.filter(function(t){return!K.isDisabled(t)}));var c=l.filter(K.hasAttribute.bind(null,"BANDWIDTH")).map(function(t){var e=u.getSyncPoint(t,r,o,i)?1:2;return{playlist:t,rebufferingImpact:K.estimateSegmentRequestTime(a,n,t)*e-s}}),h=c.filter(function(t){return t.rebufferingImpact<=0});return Ki(h,function(t,e){return Qi(e.playlist,t.playlist)}),h.length?h[0]:(Ki(c,function(t,e){return t.rebufferingImpact-e.rebufferingImpact}),c[0]||null)}({master:this.hls_.playlists.master,currentTime:e,bandwidth:i,duration:this.duration_(),segmentDuration:n,timeUntilRebuffer:a,currentTimeline:this.currentTimeline_,syncController:this.syncController_});if(s){var o=r-a-s.rebufferingImpact,u=.5;return a<=1/30&&(u=1),!s.playlist||s.playlist.uri===this.playlist_.uri||o<u?!1:(this.bandwidth=s.playlist.attributes.BANDWIDTH*Bi.BANDWIDTH_VARIANCE+1,this.abort(),this.trigger("earlyabort"),!0)}}},{key:"handleProgress_",value:function(t,e){this.pendingSegment_&&e.requestId===this.pendingSegment_.requestId&&!this.abortRequestEarly_(e.stats)&&this.trigger("progress")}},{key:"loadSegment_",value:function(t){this.state="WAITING",this.pendingSegment_=t,this.trimBackBuffer_(t),t.abortRequests=Yi(this.hls_.xhr,this.xhrOptions_,this.decrypter_,this.captionParser_,this.createSimplifiedSegmentObj_(t),this.handleProgress_.bind(this),this.segmentRequestFinished_.bind(this))}},{key:"trimBackBuffer_",value:function(t){var e=function(t,e,i){var n=void 0;return n=t.length&&t.start(0)>0&&t.start(0)<e?t.start(0):e-30,Math.min(n,e-i)}(this.seekable_(),this.currentTime_(),this.playlist_.targetDuration||10);e>0&&this.remove(0,e)}},{key:"createSimplifiedSegmentObj_",value:function(t){var e=t.segment,i={resolvedUri:e.resolvedUri,byterange:e.byterange,requestId:t.requestId};if(e.key){var n=e.key.iv||new Uint32Array([0,0,0,t.mediaIndex+t.playlist.mediaSequence]);i.key={resolvedUri:e.key.resolvedUri,iv:n}}return e.map&&(i.map=this.initSegment(e.map)),i}},{key:"segmentRequestFinished_",value:function(t,e){if(this.mediaRequests+=1,e.stats&&(this.mediaBytesTransferred+=e.stats.bytesReceived,this.mediaTransferDuration+=e.stats.roundTripTime),this.pendingSegment_){if(e.requestId===this.pendingSegment_.requestId){if(t)return this.pendingSegment_=null,this.state="READY",t.code===Vi?void(this.mediaRequestsAborted+=1):(this.pause(),t.code===Gi?(this.mediaRequestsTimedout+=1,this.bandwidth=1,this.roundTrip=NaN,void this.trigger("bandwidthupdate")):(this.mediaRequestsErrored+=1,this.error(t),void this.trigger("error")));this.bandwidth=e.stats.bandwidth,this.roundTrip=e.stats.roundTripTime,e.map&&(e.map=this.initSegment(e.map,!0)),this.processSegmentResponse_(e)}}else this.mediaRequestsAborted+=1}},{key:"processSegmentResponse_",value:function(t){var e=this.pendingSegment_;e.bytes=t.bytes,t.map&&(e.segment.map.bytes=t.map.bytes),e.endOfAllRequests=t.endOfAllRequests,t.fmp4Captions&&(!function(t,e,i){for(var n in i)if(!t[n]){e.trigger({type:"usage",name:"hls-608"});var r=e.textTracks().getTrackById(n);t[n]=r||e.addRemoteTextTrack({kind:"captions",id:n,label:n},!1).track}}(this.inbandTextTracks_,this.hls_.tech_,t.captionStreams),function(t){var e=t.inbandTextTracks,i=t.captionArray,n=t.timestampOffset;if(i){var r=window.WebKitDataCue||window.VTTCue;i.forEach(function(t){var i=t.stream,a=t.startTime,s=t.endTime;e[i]&&(a+=n,s+=n,e[i].addCue(new r(a,s,t.text)))})}}({inbandTextTracks:this.inbandTextTracks_,captionArray:t.fmp4Captions,timestampOffset:0}),this.captionParser_.clearParsedCaptions()),this.handleSegment_()}},{key:"handleSegment_",value:function(){var t=this;if(this.pendingSegment_){var e=this.pendingSegment_,i=e.segment,n=this.syncController_.probeSegmentInfo(e);void 0===this.startingMedia_&&n&&(n.containsAudio||n.containsVideo)&&(this.startingMedia_={containsAudio:n.containsAudio,containsVideo:n.containsVideo});var r,a,s,o=(r=this.loaderType_,a=this.startingMedia_,s=n,"main"===r&&a&&s?s.containsAudio||s.containsVideo?a.containsVideo&&!s.containsVideo?"Only audio found in segment when we expected video. We can't switch to audio only from a stream that had video. To get rid of this message, please add codec information to the manifest.":!a.containsVideo&&s.containsVideo?"Video found in segment when we expected only audio. We can't switch to a stream with video from an audio only stream. To get rid of this message, please add codec information to the manifest.":null:"Neither audio nor video found in segment.":null);if(o)return this.error({message:o,blacklistDuration:1/0}),void this.trigger("error");if(e.isSyncRequest)return this.trigger("syncinfoupdate"),this.pendingSegment_=null,void(this.state="READY");null!==e.timestampOffset&&e.timestampOffset!==this.sourceUpdater_.timestampOffset()&&(this.sourceUpdater_.timestampOffset(e.timestampOffset),this.trigger("timestampoffset"));var u=this.syncController_.mappingForTimeline(e.timeline);if(null!==u&&this.trigger({type:"segmenttimemapping",mapping:u}),this.state="APPENDING",i.map){var d=mt(i.map);if(!this.activeInitSegmentId_||this.activeInitSegmentId_!==d){var l=this.initSegment(i.map);this.sourceUpdater_.appendBuffer(l.bytes,function(){t.activeInitSegmentId_=d})}}e.byteLength=e.bytes.byteLength,"number"==typeof i.start&&"number"==typeof i.end?this.mediaSecondsLoaded+=i.end-i.start:this.mediaSecondsLoaded+=i.duration,this.logger_(function(t){var e=t.segment,i=e.start,n=e.end,r=t.playlist,a=r.mediaSequence,s=r.id,o=r.segments,u=void 0===o?[]:o,d=t.mediaIndex,l=t.timeline;return["appending ["+d+"] of ["+a+", "+(a+u.length)+"] from playlist ["+s+"]","["+i+" => "+n+"] in timeline ["+l+"]"].join(" ")}(e)),this.sourceUpdater_.appendBuffer(e.bytes,this.handleUpdateEnd_.bind(this))}else this.state="READY"}},{key:"handleUpdateEnd_",value:function(){if(!this.pendingSegment_)return this.state="READY",void(this.paused()||this.monitorBuffer_());var t=this.pendingSegment_,e=t.segment,i=null!==this.mediaIndex;(this.pendingSegment_=null,this.recordThroughput_(t),this.addSegmentMetadataCue_(t),this.state="READY",this.mediaIndex=t.mediaIndex,this.fetchAtBuffer_=!0,this.currentTimeline_=t.timeline,this.trigger("syncinfoupdate"),e.end&&this.currentTime_()-e.end>3*t.playlist.targetDuration)?this.resetEverything():(i&&this.trigger("bandwidthupdate"),this.trigger("progress"),qr(t.playlist,this.mediaSource_,t.mediaIndex+1)&&this.endOfStream(),this.paused()||this.monitorBuffer_())}},{key:"recordThroughput_",value:function(t){var e=this.throughput.rate,i=Date.now()-t.endOfAllRequests+1,n=Math.floor(t.byteLength/i*8*1e3);this.throughput.rate+=(n-e)/++this.throughput.count}},{key:"addSegmentMetadataCue_",value:function(t){if(this.segmentMetadataTrack_){var e=t.segment,i=e.start,n=e.end;if(Fr(i)&&Fr(n)){At(i,n,this.segmentMetadataTrack_);var r=c.WebKitDataCue||c.VTTCue,a={dateTimeObject:e.dateTimeObject,dateTimeString:e.dateTimeString,bandwidth:t.playlist.attributes.BANDWIDTH,resolution:t.playlist.attributes.RESOLUTION,codecs:t.playlist.attributes.CODECS,byteLength:t.byteLength,uri:t.uri,timeline:t.timeline,playlist:t.playlist.uri,start:i,end:n},s=new r(i,n,JSON.stringify(a));s.value=a,this.segmentMetadataTrack_.addCue(s)}}}}]),i}(e.EventTarget),Vr=function(t){return decodeURIComponent(escape(String.fromCharCode.apply(null,t)))},Hr=new Uint8Array("\n\n".split("").map(function(t){return t.charCodeAt(0)})),jr=function(t){function i(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};T(this,i);var n=w(this,(i.__proto__||Object.getPrototypeOf(i)).call(this,t,e));return n.mediaSource_=null,n.subtitlesTrack_=null,n}return k(i,Gr),S(i,[{key:"buffered_",value:function(){if(!this.subtitlesTrack_||!this.subtitlesTrack_.cues.length)return e.createTimeRanges();var t=this.subtitlesTrack_.cues,i=t[0].startTime,n=t[t.length-1].startTime;return e.createTimeRanges([[i,n]])}},{key:"initSegment",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]&&arguments[1];if(!t)return null;var i=mt(t),n=this.initSegments_[i];if(e&&!n&&t.bytes){var r=Hr.byteLength+t.bytes.byteLength,a=new Uint8Array(r);a.set(t.bytes),a.set(Hr,t.bytes.byteLength),this.initSegments_[i]=n={resolvedUri:t.resolvedUri,byterange:t.byterange,bytes:a}}return n||t}},{key:"couldBeginLoading_",value:function(){return this.playlist_&&this.subtitlesTrack_&&!this.paused()}},{key:"init_",value:function(){return this.state="READY",this.resetEverything(),this.monitorBuffer_()}},{key:"track",value:function(t){return void 0===t?this.subtitlesTrack_:(this.subtitlesTrack_=t,"INIT"===this.state&&this.couldBeginLoading_()&&this.init_(),this.subtitlesTrack_)}},{key:"remove",value:function(t,e){At(t,e,this.subtitlesTrack_)}},{key:"fillBuffer_",value:function(){var t=this;this.syncPoint_||(this.syncPoint_=this.syncController_.getSyncPoint(this.playlist_,this.duration_(),this.currentTimeline_,this.currentTime_()));var e=this.checkBuffer_(this.buffered_(),this.playlist_,this.mediaIndex,this.hasPlayed_(),this.currentTime_(),this.syncPoint_);if(e=this.skipEmptySegments_(e)){if(null===this.syncController_.timestampOffsetForTimeline(e.timeline)){return this.syncController_.one("timestampoffset",function(){t.state="READY",t.paused()||t.monitorBuffer_()}),void(this.state="WAITING_ON_TIMELINE")}this.loadSegment_(e)}}},{key:"skipEmptySegments_",value:function(t){for(;t&&t.segment.empty;)t=this.generateSegmentInfo_(t.playlist,t.mediaIndex+1,t.startOfSegment+t.duration,t.isSyncRequest);return t}},{key:"handleSegment_",value:function(){var t=this;if(this.pendingSegment_&&this.subtitlesTrack_){this.state="APPENDING";var e=this.pendingSegment_,i=e.segment;if("function"!=typeof c.WebVTT&&this.subtitlesTrack_&&this.subtitlesTrack_.tech_){var n=function(){t.handleSegment_()};return this.state="WAITING_ON_VTTJS",this.subtitlesTrack_.tech_.one("vttjsloaded",n),void this.subtitlesTrack_.tech_.one("vttjserror",function(){t.subtitlesTrack_.tech_.off("vttjsloaded",n),t.error({message:"Error loading vtt.js"}),t.state="READY",t.pause(),t.trigger("error")})}i.requested=!0;try{this.parseVTTCues_(e)}catch(t){return this.error({message:t.message}),this.state="READY",this.pause(),this.trigger("error")}if(this.updateTimeMapping_(e,this.syncController_.timelines[e.timeline],this.playlist_),e.isSyncRequest)return this.trigger("syncinfoupdate"),this.pendingSegment_=null,void(this.state="READY");e.byteLength=e.bytes.byteLength,this.mediaSecondsLoaded+=i.duration,e.cues.length&&this.remove(e.cues[0].endTime,e.cues[e.cues.length-1].endTime),e.cues.forEach(function(e){t.subtitlesTrack_.addCue(e)}),this.handleUpdateEnd_()}else this.state="READY"}},{key:"parseVTTCues_",value:function(t){var i=void 0,n=!1;"function"==typeof c.TextDecoder?i=new c.TextDecoder("utf8"):(i=c.WebVTT.StringDecoder(),n=!0);var r=new c.WebVTT.Parser(c,c.vttjs,i);if(t.cues=[],t.timestampmap={MPEGTS:0,LOCAL:0},r.oncue=t.cues.push.bind(t.cues),r.ontimestampmap=function(e){return t.timestampmap=e},r.onparsingerror=function(t){e.log.warn("Error encountered when parsing cues: "+t.message)},t.segment.map){var a=t.segment.map.bytes;n&&(a=Vr(a)),r.parse(a)}var s=t.bytes;n&&(s=Vr(s)),r.parse(s),r.flush()}},{key:"updateTimeMapping_",value:function(t,e,i){var n=t.segment;if(e)if(t.cues.length){var r=t.timestampmap,a=r.MPEGTS/9e4-r.LOCAL+e.mapping;if(t.cues.forEach(function(t){t.startTime+=a,t.endTime+=a}),!i.syncInfo){var s=t.cues[0].startTime,o=t.cues[t.cues.length-1].startTime;i.syncInfo={mediaSequence:i.mediaSequence+t.mediaIndex,time:Math.min(s,o-n.duration)}}}else n.empty=!0}}]),i}(),zr=function(t,e){for(var i=t.cues,n=0;n<i.length;n++){var r=i[n];if(e>=r.adStartTime&&e<=r.adEndTime)return r}return null},Wr=function(t){var e=31&t[1];return e<<=8,e|=t[2]},Xr=function(t){return!!(64&t[1])},Yr=function(t){var e=0;return(48&t[3])>>>4>1&&(e+=t[4]+1),e},$r=function(t){switch(t){case 5:return"slice_layer_without_partitioning_rbsp_idr";case 6:return"sei_rbsp";case 7:return"seq_parameter_set_rbsp";case 8:return"pic_parameter_set_rbsp";case 9:return"access_unit_delimiter_rbsp";default:return null}},Kr={parseType:function(t,e){var i=Wr(t);return 0===i?"pat":i===e?"pmt":e?"pes":null},parsePat:function(t){var e=Xr(t),i=4+Yr(t);return e&&(i+=t[i]+1),(31&t[i+10])<<8|t[i+11]},parsePmt:function(t){var e={},i=Xr(t),n=4+Yr(t);if(i&&(n+=t[n]+1),1&t[n+5]){var r;r=3+((15&t[n+1])<<8|t[n+2])-4;for(var a=12+((15&t[n+10])<<8|t[n+11]);a<r;){var s=n+a;e[(31&t[s+1])<<8|t[s+2]]=t[s],a+=5+((15&t[s+3])<<8|t[s+4])}return e}},parsePayloadUnitStartIndicator:Xr,parsePesType:function(t,e){switch(e[Wr(t)]){case Fn.H264_STREAM_TYPE:return"video";case Fn.ADTS_STREAM_TYPE:return"audio";case Fn.METADATA_STREAM_TYPE:return"timed-metadata";default:return null}},parsePesTime:function(t){if(!Xr(t))return null;var e=4+Yr(t);if(e>=t.byteLength)return null;var i,n=null;return 192&(i=t[e+7])&&((n={}).pts=(14&t[e+9])<<27|(255&t[e+10])<<20|(254&t[e+11])<<12|(255&t[e+12])<<5|(254&t[e+13])>>>3,n.pts*=4,n.pts+=(6&t[e+13])>>>1,n.dts=n.pts,64&i&&(n.dts=(14&t[e+14])<<27|(255&t[e+15])<<20|(254&t[e+16])<<12|(255&t[e+17])<<5|(254&t[e+18])>>>3,n.dts*=4,n.dts+=(6&t[e+18])>>>1)),n},videoPacketContainsKeyFrame:function(t){for(var e=4+Yr(t),i=t.subarray(e),n=0,r=0,a=!1;r<i.byteLength-3;r++)if(1===i[r+2]){n=r+5;break}for(;n<i.byteLength;)switch(i[n]){case 0:if(0!==i[n-1]){n+=2;break}if(0!==i[n-2]){n++;break}r+3!==n-2&&"slice_layer_without_partitioning_rbsp_idr"===$r(31&i[r+3])&&(a=!0);do{n++}while(1!==i[n]&&n<i.length);r=n-2,n+=3;break;case 1:if(0!==i[n-1]||0!==i[n-2]){n+=3;break}"slice_layer_without_partitioning_rbsp_idr"===$r(31&i[r+3])&&(a=!0),r=n-2,n+=3;break;default:n+=3}return i=i.subarray(r),n-=r,r=0,i&&i.byteLength>3&&"slice_layer_without_partitioning_rbsp_idr"===$r(31&i[r+3])&&(a=!0),a}},Qr=zn,Zr={};Zr.ts=Kr,Zr.aac=mr;var Jr=function(t,e,i){for(var n,r,a,s,o=0,u=188,d=!1;u<=t.byteLength;)if(71!==t[o]||71!==t[u]&&u!==t.byteLength)o++,u++;else{switch(n=t.subarray(o,u),Zr.ts.parseType(n,e.pid)){case"pes":r=Zr.ts.parsePesType(n,e.table),a=Zr.ts.parsePayloadUnitStartIndicator(n),"audio"===r&&a&&(s=Zr.ts.parsePesTime(n))&&(s.type="audio",i.audio.push(s),d=!0)}if(d)break;o+=188,u+=188}for(o=(u=t.byteLength)-188,d=!1;o>=0;)if(71!==t[o]||71!==t[u]&&u!==t.byteLength)o--,u--;else{switch(n=t.subarray(o,u),Zr.ts.parseType(n,e.pid)){case"pes":r=Zr.ts.parsePesType(n,e.table),a=Zr.ts.parsePayloadUnitStartIndicator(n),"audio"===r&&a&&(s=Zr.ts.parsePesTime(n))&&(s.type="audio",i.audio.push(s),d=!0)}if(d)break;o-=188,u-=188}},ta=function(t,e,i){for(var n,r,a,s,o,u,d,l=0,c=188,h=!1,f={data:[],size:0};c<t.byteLength;)if(71!==t[l]||71!==t[c])l++,c++;else{switch(n=t.subarray(l,c),Zr.ts.parseType(n,e.pid)){case"pes":if(r=Zr.ts.parsePesType(n,e.table),a=Zr.ts.parsePayloadUnitStartIndicator(n),"video"===r&&(a&&!h&&(s=Zr.ts.parsePesTime(n))&&(s.type="video",i.video.push(s),h=!0),!i.firstKeyFrame)){if(a&&0!==f.size){for(o=new Uint8Array(f.size),u=0;f.data.length;)d=f.data.shift(),o.set(d,u),u+=d.byteLength;Zr.ts.videoPacketContainsKeyFrame(o)&&(i.firstKeyFrame=Zr.ts.parsePesTime(o),i.firstKeyFrame.type="video"),f.size=0}f.data.push(n),f.size+=n.byteLength}}if(h&&i.firstKeyFrame)break;l+=188,c+=188}for(l=(c=t.byteLength)-188,h=!1;l>=0;)if(71!==t[l]||71!==t[c])l--,c--;else{switch(n=t.subarray(l,c),Zr.ts.parseType(n,e.pid)){case"pes":r=Zr.ts.parsePesType(n,e.table),a=Zr.ts.parsePayloadUnitStartIndicator(n),"video"===r&&a&&(s=Zr.ts.parsePesTime(n))&&(s.type="video",i.video.push(s),h=!0)}if(h)break;l-=188,c-=188}},ea=function(t){var e={pid:null,table:null},i={};for(var n in function(t,e){for(var i,n=0,r=188;r<t.byteLength;)if(71!==t[n]||71!==t[r])n++,r++;else{switch(i=t.subarray(n,r),Zr.ts.parseType(i,e.pid)){case"pat":e.pid||(e.pid=Zr.ts.parsePat(i));break;case"pmt":e.table||(e.table=Zr.ts.parsePmt(i))}if(e.pid&&e.table)return;n+=188,r+=188}}(t,e),e.table){if(e.table.hasOwnProperty(n))switch(e.table[n]){case Fn.H264_STREAM_TYPE:i.video=[],ta(t,e,i),0===i.video.length&&delete i.video;break;case Fn.ADTS_STREAM_TYPE:i.audio=[],Jr(t,e,i),0===i.audio.length&&delete i.audio}}return i},ia=function(t,e){var i;return(i=Zr.aac.isLikelyAacData(t)?function(t){for(var e,i=!1,n=0,r=null,a=null,s=0,o=0;t.length-o>=3;){switch(Zr.aac.parseType(t,o)){case"timed-metadata":if(t.length-o<10){i=!0;break}if((s=Zr.aac.parseId3TagSize(t,o))>t.length){i=!0;break}null===a&&(e=t.subarray(o,o+s),a=Zr.aac.parseAacTimestamp(e)),o+=s;break;case"audio":if(t.length-o<7){i=!0;break}if((s=Zr.aac.parseAdtsSize(t,o))>t.length){i=!0;break}null===r&&(e=t.subarray(o,o+s),r=Zr.aac.parseSampleRate(e)),n++,o+=s;break;default:o++}if(i)return null}if(null===r||null===a)return null;var u=9e4/r;return{audio:[{type:"audio",dts:a,pts:a},{type:"audio",dts:a+1024*n*u,pts:a+1024*n*u}]}}(t):ea(t))&&(i.audio||i.video)?(function(t,e){if(t.audio&&t.audio.length){var i=e;void 0===i&&(i=t.audio[0].dts),t.audio.forEach(function(t){t.dts=Qr(t.dts,i),t.pts=Qr(t.pts,i),t.dtsTime=t.dts/9e4,t.ptsTime=t.pts/9e4})}if(t.video&&t.video.length){var n=e;if(void 0===n&&(n=t.video[0].dts),t.video.forEach(function(t){t.dts=Qr(t.dts,n),t.pts=Qr(t.pts,n),t.dtsTime=t.dts/9e4,t.ptsTime=t.pts/9e4}),t.firstKeyFrame){var r=t.firstKeyFrame;r.dts=Qr(r.dts,n),r.pts=Qr(r.pts,n),r.dtsTime=r.dts/9e4,r.ptsTime=r.dts/9e4}}}(i,e),i):null},na=[{name:"VOD",run:function(t,e,i,n,r){if(i!==1/0){return{time:0,segmentIndex:0}}return null}},{name:"ProgramDateTime",run:function(t,e,i,n,r){if(!t.datetimeToDisplayTime)return null;var a=e.segments||[],s=null,o=null;r=r||0;for(var u=0;u<a.length;u++){var d=a[u];if(d.dateTimeObject){var l=d.dateTimeObject.getTime()/1e3+t.datetimeToDisplayTime,c=Math.abs(r-l);if(null!==o&&o<c)break;o=c,s={time:l,segmentIndex:u}}}return s}},{name:"Segment",run:function(t,e,i,n,r){var a=e.segments||[],s=null,o=null;r=r||0;for(var u=0;u<a.length;u++){var d=a[u];if(d.timeline===n&&void 0!==d.start){var l=Math.abs(r-d.start);if(null!==o&&o<l)break;(!s||null===o||o>=l)&&(o=l,s={time:d.start,segmentIndex:u})}}return s}},{name:"Discontinuity",run:function(t,e,i,n,r){var a=null;if(r=r||0,e.discontinuityStarts&&e.discontinuityStarts.length)for(var s=null,o=0;o<e.discontinuityStarts.length;o++){var u=e.discontinuityStarts[o],d=e.discontinuitySequence+o+1,l=t.discontinuities[d];if(l){var c=Math.abs(r-l.time);if(null!==s&&s<c)break;(!a||null===s||s>=c)&&(s=c,a={time:l.time,segmentIndex:u})}}return a}},{name:"Playlist",run:function(t,e,i,n,r){return e.syncInfo?{time:e.syncInfo.time,segmentIndex:e.syncInfo.mediaSequence-e.mediaSequence}:null}}],ra=function(t){function e(){T(this,e);var t=w(this,(e.__proto__||Object.getPrototypeOf(e)).call(this));return t.inspectCache_=void 0,t.timelines=[],t.discontinuities=[],t.datetimeToDisplayTime=null,t.logger_=We("SyncController"),t}return k(e,t),S(e,[{key:"getSyncPoint",value:function(t,e,i,n){var r=this.runStrategies_(t,e,i,n);return r.length?this.selectSyncPoint_(r,{key:"time",value:n}):null}},{key:"getExpiredTime",value:function(t,e){if(!t||!t.segments)return null;var i=this.runStrategies_(t,e,t.discontinuitySequence,0);if(!i.length)return null;var n=this.selectSyncPoint_(i,{key:"segmentIndex",value:0});return n.segmentIndex>0&&(n.time*=-1),Math.abs(n.time+N(t,n.segmentIndex,0))}},{key:"runStrategies_",value:function(t,e,i,n){for(var r=[],a=0;a<na.length;a++){var s=na[a],o=s.run(this,t,e,i,n);o&&(o.strategy=s.name,r.push({strategy:s.name,syncPoint:o}))}return r}},{key:"selectSyncPoint_",value:function(t,e){for(var i=t[0].syncPoint,n=Math.abs(t[0].syncPoint[e.key]-e.value),r=t[0].strategy,a=1;a<t.length;a++){var s=Math.abs(t[a].syncPoint[e.key]-e.value);s<n&&(n=s,i=t[a].syncPoint,r=t[a].strategy)}return this.logger_("syncPoint for ["+e.key+": "+e.value+"] chosen with strategy ["+r+"]: [time:"+i.time+", segmentIndex:"+i.segmentIndex+"]"),i}},{key:"saveExpiredSegmentInfo",value:function(t,e){for(var i=e.mediaSequence-t.mediaSequence-1;i>=0;i--){var n=t.segments[i];if(n&&void 0!==n.start){e.syncInfo={mediaSequence:t.mediaSequence+i,time:n.start},this.logger_("playlist refresh sync: [time:"+e.syncInfo.time+", mediaSequence: "+e.syncInfo.mediaSequence+"]"),this.trigger("syncinfoupdate");break}}}},{key:"setDateTimeMapping",value:function(t){if(!this.datetimeToDisplayTime&&t.segments&&t.segments.length&&t.segments[0].dateTimeObject){var e=t.segments[0].dateTimeObject.getTime()/1e3;this.datetimeToDisplayTime=-e}}},{key:"reset",value:function(){this.inspectCache_=void 0}},{key:"probeSegmentInfo",value:function(t){var e=t.segment,i=t.playlist,n=void 0;return(n=e.map?this.probeMp4Segment_(t):this.probeTsSegment_(t))&&this.calculateSegmentTimeMapping_(t,n)&&(this.saveDiscontinuitySyncInfo_(t),i.syncInfo||(i.syncInfo={mediaSequence:i.mediaSequence+t.mediaIndex,time:e.start})),n}},{key:"probeMp4Segment_",value:function(t){var e=t.segment,i=qi.timescale(e.map.bytes),n=qi.startTime(i,t.bytes);return null!==t.timestampOffset&&(t.timestampOffset-=n),{start:n,end:n+e.duration}}},{key:"probeTsSegment_",value:function(t){var e=ia(t.bytes,this.inspectCache_),i=void 0,n=void 0;return e?(e.video&&2===e.video.length?(this.inspectCache_=e.video[1].dts,i=e.video[0].dtsTime,n=e.video[1].dtsTime):e.audio&&2===e.audio.length&&(this.inspectCache_=e.audio[1].dts,i=e.audio[0].dtsTime,n=e.audio[1].dtsTime),{start:i,end:n,containsVideo:e.video&&2===e.video.length,containsAudio:e.audio&&2===e.audio.length}):null}},{key:"timestampOffsetForTimeline",value:function(t){return void 0===this.timelines[t]?null:this.timelines[t].time}},{key:"mappingForTimeline",value:function(t){return void 0===this.timelines[t]?null:this.timelines[t].mapping}},{key:"calculateSegmentTimeMapping_",value:function(t,e){var i=t.segment,n=this.timelines[t.timeline];if(null!==t.timestampOffset)n={time:t.startOfSegment,mapping:t.startOfSegment-e.start},this.timelines[t.timeline]=n,this.trigger("timestampoffset"),this.logger_("time mapping for timeline "+t.timeline+": [time: "+n.time+"] [mapping: "+n.mapping+"]"),i.start=t.startOfSegment,i.end=e.end+n.mapping;else{if(!n)return!1;i.start=e.start+n.mapping,i.end=e.end+n.mapping}return!0}},{key:"saveDiscontinuitySyncInfo_",value:function(t){var e=t.playlist,i=t.segment;if(i.discontinuity)this.discontinuities[i.timeline]={time:i.start,accuracy:0};else if(e.discontinuityStarts&&e.discontinuityStarts.length)for(var n=0;n<e.discontinuityStarts.length;n++){var r=e.discontinuityStarts[n],a=e.discontinuitySequence+n+1,s=r-t.mediaIndex,o=Math.abs(s);if(!this.discontinuities[a]||this.discontinuities[a].accuracy>o){var u=void 0;u=s<0?i.start-N(e,t.mediaIndex,r):i.end+N(e,t.mediaIndex+1,r),this.discontinuities[a]={time:u,accuracy:o}}}}}]),e}(e.EventTarget),aa=new Mt("./decrypter-worker.worker.js",function(t,e){var i=this;!function(){var t=function(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")},e=function(){function t(t,e){for(var i=0;i<e.length;i++){var n=e[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(t,n.key,n)}}return function(e,i,n){return i&&t(e.prototype,i),n&&t(e,n),e}}(),n=function(t,e){if(!t)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!e||"object"!=typeof e&&"function"!=typeof e?t:e},r=function(){var t=[[[],[],[],[],[]],[[],[],[],[],[]]],e=t[0],i=t[1],n=e[4],r=i[4],a=void 0,s=void 0,o=void 0,u=[],d=[],l=void 0,c=void 0,h=void 0,f=void 0,p=void 0;for(a=0;a<256;a++)d[(u[a]=a<<1^283*(a>>7))^a]=a;for(s=o=0;!n[s];s^=l||1,o=d[o]||1)for(h=(h=o^o<<1^o<<2^o<<3^o<<4)>>8^255&h^99,n[s]=h,r[h]=s,p=16843009*u[c=u[l=u[s]]]^65537*c^257*l^16843008*s,f=257*u[h]^16843008*h,a=0;a<4;a++)e[a][s]=f=f<<24^f>>>8,i[a][h]=p=p<<24^p>>>8;for(a=0;a<5;a++)e[a]=e[a].slice(0),i[a]=i[a].slice(0);return t},a=null,s=function(){function e(i){t(this,e),a||(a=r()),this._tables=[[a[0][0].slice(),a[0][1].slice(),a[0][2].slice(),a[0][3].slice(),a[0][4].slice()],[a[1][0].slice(),a[1][1].slice(),a[1][2].slice(),a[1][3].slice(),a[1][4].slice()]];var n=void 0,s=void 0,o=void 0,u=void 0,d=void 0,l=this._tables[0][4],c=this._tables[1],h=i.length,f=1;if(4!==h&&6!==h&&8!==h)throw new Error("Invalid aes key size");for(u=i.slice(0),d=[],this._key=[u,d],n=h;n<4*h+28;n++)o=u[n-1],(n%h==0||8===h&&n%h==4)&&(o=l[o>>>24]<<24^l[o>>16&255]<<16^l[o>>8&255]<<8^l[255&o],n%h==0&&(o=o<<8^o>>>24^f<<24,f=f<<1^283*(f>>7))),u[n]=u[n-h]^o;for(s=0;n;s++,n--)o=u[3&s?n:n-4],d[s]=n<=4||s<4?o:c[0][l[o>>>24]]^c[1][l[o>>16&255]]^c[2][l[o>>8&255]]^c[3][l[255&o]]}return e.prototype.decrypt=function(t,e,i,n,r,a){var s=this._key[1],o=t^s[0],u=n^s[1],d=i^s[2],l=e^s[3],c=void 0,h=void 0,f=void 0,p=s.length/4-2,m=void 0,g=4,y=this._tables[1],_=y[0],v=y[1],b=y[2],T=y[3],S=y[4];for(m=0;m<p;m++)c=_[o>>>24]^v[u>>16&255]^b[d>>8&255]^T[255&l]^s[g],h=_[u>>>24]^v[d>>16&255]^b[l>>8&255]^T[255&o]^s[g+1],f=_[d>>>24]^v[l>>16&255]^b[o>>8&255]^T[255&u]^s[g+2],l=_[l>>>24]^v[o>>16&255]^b[u>>8&255]^T[255&d]^s[g+3],g+=4,o=c,u=h,d=f;for(m=0;m<4;m++)r[(3&-m)+a]=S[o>>>24]<<24^S[u>>16&255]<<16^S[d>>8&255]<<8^S[255&l]^s[g++],c=o,o=u,u=d,d=l,l=c},e}(),o=function(){function e(){t(this,e),this.listeners={}}return e.prototype.on=function(t,e){this.listeners[t]||(this.listeners[t]=[]),this.listeners[t].push(e)},e.prototype.off=function(t,e){if(!this.listeners[t])return!1;var i=this.listeners[t].indexOf(e);return this.listeners[t].splice(i,1),i>-1},e.prototype.trigger=function(t){var e=this.listeners[t];if(e)if(2===arguments.length)for(var i=e.length,n=0;n<i;++n)e[n].call(this,arguments[1]);else for(var r=Array.prototype.slice.call(arguments,1),a=e.length,s=0;s<a;++s)e[s].apply(this,r)},e.prototype.dispose=function(){this.listeners={}},e.prototype.pipe=function(t){this.on("data",function(e){t.push(e)})},e}(),u=function(e){function i(){t(this,i);var r=n(this,e.call(this,o));return r.jobs=[],r.delay=1,r.timeout_=null,r}return function(t,e){if("function"!=typeof e&&null!==e)throw new TypeError("Super expression must either be null or a function, not "+typeof e);t.prototype=Object.create(e&&e.prototype,{constructor:{value:t,enumerable:!1,writable:!0,configurable:!0}}),e&&(Object.setPrototypeOf?Object.setPrototypeOf(t,e):t.__proto__=e)}(i,e),i.prototype.processJob_=function(){this.jobs.shift()(),this.jobs.length?this.timeout_=setTimeout(this.processJob_.bind(this),this.delay):this.timeout_=null},i.prototype.push=function(t){this.jobs.push(t),this.timeout_||(this.timeout_=setTimeout(this.processJob_.bind(this),this.delay))},i}(o),d=function(t){return t<<24|(65280&t)<<8|(16711680&t)>>8|t>>>24},l=function(){function i(e,n,r,a){t(this,i);var s=i.STEP,o=new Int32Array(e.buffer),l=new Uint8Array(e.byteLength),c=0;for(this.asyncStream_=new u,this.asyncStream_.push(this.decryptChunk_(o.subarray(c,c+s),n,r,l)),c=s;c<o.length;c+=s)r=new Uint32Array([d(o[c-4]),d(o[c-3]),d(o[c-2]),d(o[c-1])]),this.asyncStream_.push(this.decryptChunk_(o.subarray(c,c+s),n,r,l));this.asyncStream_.push(function(){var t;a(null,(t=l).subarray(0,t.byteLength-t[t.byteLength-1]))})}return i.prototype.decryptChunk_=function(t,e,i,n){return function(){var r=function(t,e,i){var n=new Int32Array(t.buffer,t.byteOffset,t.byteLength>>2),r=new s(Array.prototype.slice.call(e)),a=new Uint8Array(t.byteLength),o=new Int32Array(a.buffer),u=void 0,l=void 0,c=void 0,h=void 0,f=void 0,p=void 0,m=void 0,g=void 0,y=void 0;for(u=i[0],l=i[1],c=i[2],h=i[3],y=0;y<n.length;y+=4)f=d(n[y]),p=d(n[y+1]),m=d(n[y+2]),g=d(n[y+3]),r.decrypt(f,p,m,g,o,y),o[y]=d(o[y]^u),o[y+1]=d(o[y+1]^l),o[y+2]=d(o[y+2]^c),o[y+3]=d(o[y+3]^h),u=f,l=p,c=m,h=g;return a}(t,e,i);n.set(r,t.byteOffset)}},e(i,null,[{key:"STEP",get:function(){return 32e3}}]),i}();new function(t){t.onmessage=function(e){var i=e.data,n=new Uint8Array(i.encrypted.bytes,i.encrypted.byteOffset,i.encrypted.byteLength),r=new Uint32Array(i.key.bytes,i.key.byteOffset,i.key.byteLength/4),a=new Uint32Array(i.iv.bytes,i.iv.byteOffset,i.iv.byteLength/4);new l(n,r,a,function(e,n){var r,a;t.postMessage((r={source:i.source,decrypted:n},a={},Object.keys(r).forEach(function(t){var e=r[t];ArrayBuffer.isView(e)?a[t]={bytes:e.buffer,byteOffset:e.byteOffset,byteLength:e.byteLength}:a[t]=e}),a),[n.buffer])})}}(i)}()}),sa=function(t){var e=t.default?"main":"alternative";return t.characteristics&&t.characteristics.indexOf("public.accessibility.describes-video")>=0&&(e="main-desc"),e},oa=function(t,e){t.abort(),t.pause(),e&&e.activePlaylistLoader&&(e.activePlaylistLoader.pause(),e.activePlaylistLoader=null)},ua=function(t,e){e.activePlaylistLoader=t,t.load()},da={AUDIO:function(t,i){return function(){var n=i.segmentLoaders[t],r=i.mediaTypes[t],a=i.blacklistCurrentPlaylist;oa(n,r);var s=r.activeTrack(),o=r.activeGroup(),u=(o.filter(function(t){return t.default})[0]||o[0]).id,d=r.tracks[u];if(s!==d){for(var l in e.log.warn("Problem encountered loading the alternate audio track.Switching back to default."),r.tracks)r.tracks[l].enabled=r.tracks[l]===d;r.onTrackChanged()}else a({message:"Problem encountered loading the default audio track."})}},SUBTITLES:function(t,i){return function(){var n=i.segmentLoaders[t],r=i.mediaTypes[t];e.log.warn("Problem encountered loading the subtitle track.Disabling subtitle track."),oa(n,r);var a=r.activeTrack();a&&(a.mode="disabled"),r.onTrackChanged()}}},la={AUDIO:function(t,e,i){if(e){var n=i.tech,r=i.requestOptions,a=i.segmentLoaders[t];e.on("loadedmetadata",function(){var t=e.media();a.playlist(t,r),(!n.paused()||t.endList&&"none"!==n.preload())&&a.load()}),e.on("loadedplaylist",function(){a.playlist(e.media(),r),n.paused()||a.load()}),e.on("error",da[t](t,i))}},SUBTITLES:function(t,e,i){var n=i.tech,r=i.requestOptions,a=i.segmentLoaders[t],s=i.mediaTypes[t];e.on("loadedmetadata",function(){var t=e.media();a.playlist(t,r),a.track(s.activeTrack()),(!n.paused()||t.endList&&"none"!==n.preload())&&a.load()}),e.on("loadedplaylist",function(){a.playlist(e.media(),r),n.paused()||a.load()}),e.on("error",da[t](t,i))}},ca=function(t,e){return function(i){return i.attributes[t]===e}},ha=function(t){return function(e){return e.resolvedUri===t}},fa={AUDIO:function(t,i){var n=i.hls,r=i.sourceType,a=i.segmentLoaders[t],s=i.requestOptions.withCredentials,o=i.master,u=o.mediaGroups,d=o.playlists,l=i.mediaTypes[t],c=l.groups,h=l.tracks,f=i.masterPlaylistLoader;for(var p in u[t]&&0!==Object.keys(u[t]).length||(u[t]={main:{default:{default:!0}}}),u[t]){c[p]||(c[p]=[]);var m=d.filter(ca(t,p));for(var g in u[t][p]){var y=u[t][p][g];m.filter(ha(y.resolvedUri)).length&&delete y.resolvedUri;var _=void 0;if(_=y.resolvedUri?new R(y.resolvedUri,n,s):y.playlists&&"dash"===r?new ze(y.playlists[0],n,s,f):null,y=e.mergeOptions({id:g,playlistLoader:_},y),la[t](t,y.playlistLoader,i),c[p].push(y),void 0===h[g]){var v=new e.AudioTrack({id:g,kind:sa(y),enabled:!1,language:y.language,default:y.default,label:g});h[g]=v}}}a.on("error",da[t](t,i))},SUBTITLES:function(t,i){var n=i.tech,r=i.hls,a=i.sourceType,s=i.segmentLoaders[t],o=i.requestOptions.withCredentials,u=i.master.mediaGroups,d=i.mediaTypes[t],l=d.groups,c=d.tracks,h=i.masterPlaylistLoader;for(var f in u[t])for(var p in l[f]||(l[f]=[]),u[t][f])if(!u[t][f][p].forced){var m=u[t][f][p],g=void 0;if("hls"===a?g=new R(m.resolvedUri,r,o):"dash"===a&&(g=new ze(m.playlists[0],r,o,h)),m=e.mergeOptions({id:p,playlistLoader:g},m),la[t](t,m.playlistLoader,i),l[f].push(m),void 0===c[p]){var y=n.addRemoteTextTrack({id:p,kind:"subtitles",default:m.default&&m.autoselect,language:m.language,label:p},!1).track;c[p]=y}}s.on("error",da[t](t,i))},"CLOSED-CAPTIONS":function(t,i){var n=i.tech,r=i.master.mediaGroups,a=i.mediaTypes[t],s=a.groups,o=a.tracks;for(var u in r[t])for(var d in s[u]||(s[u]=[]),r[t][u]){var l=r[t][u][d];if(l.instreamId.match(/CC\d/)&&(s[u].push(e.mergeOptions({id:d},l)),void 0===o[d])){var c=n.addRemoteTextTrack({id:l.instreamId,kind:"captions",default:l.default&&l.autoselect,language:l.language,label:d},!1).track;o[d]=c}}}},pa={AUDIO:function(t,e){return function(){var i=e.mediaTypes[t].tracks;for(var n in i)if(i[n].enabled)return i[n];return null}},SUBTITLES:function(t,e){return function(){var i=e.mediaTypes[t].tracks;for(var n in i)if("showing"===i[n].mode)return i[n];return null}}},ma=function(t){["AUDIO","SUBTITLES","CLOSED-CAPTIONS"].forEach(function(e){fa[e](e,t)});var e=t.mediaTypes,i=t.masterPlaylistLoader,n=t.tech,r=t.hls;["AUDIO","SUBTITLES"].forEach(function(i){e[i].activeGroup=function(t,e){return function(i){var n=e.masterPlaylistLoader,r=e.mediaTypes[t].groups,a=n.media();if(!a)return null;var s=null;return a.attributes[t]&&(s=r[a.attributes[t]]),s=s||r.main,void 0===i?s:null===i?null:s.filter(function(t){return t.id===i.id})[0]||null}}(i,t),e[i].activeTrack=pa[i](i,t),e[i].onGroupChanged=function(t,e){return function(){var i=e.segmentLoaders,n=i[t],r=i.main,a=e.mediaTypes[t],s=a.activeTrack(),o=a.activeGroup(s),u=a.activePlaylistLoader;oa(n,a),o&&(o.playlistLoader?(n.resyncLoader(),ua(o.playlistLoader,a)):u&&r.resetEverything())}}(i,t),e[i].onTrackChanged=function(t,e){return function(){var i=e.segmentLoaders,n=i[t],r=i.main,a=e.mediaTypes[t],s=a.activeTrack(),o=a.activeGroup(s),u=a.activePlaylistLoader;oa(n,a),o&&(o.playlistLoader?u!==o.playlistLoader?(n.track&&n.track(s),n.resetEverything(),ua(o.playlistLoader,a)):ua(o.playlistLoader,a):r.resetEverything())}}(i,t)});var a=e.AUDIO.activeGroup(),s=(a.filter(function(t){return t.default})[0]||a[0]).id;e.AUDIO.tracks[s].enabled=!0,e.AUDIO.onTrackChanged(),i.on("mediachange",function(){["AUDIO","SUBTITLES"].forEach(function(t){return e[t].onGroupChanged()})});var o=function(){e.AUDIO.onTrackChanged(),n.trigger({type:"usage",name:"hls-audio-change"})};for(var u in n.audioTracks().addEventListener("change",o),n.remoteTextTracks().addEventListener("change",e.SUBTITLES.onTrackChanged),r.on("dispose",function(){n.audioTracks().removeEventListener("change",o),n.remoteTextTracks().removeEventListener("change",e.SUBTITLES.onTrackChanged)}),n.clearTracks("audio"),e.AUDIO.tracks)n.audioTracks().addTrack(e.AUDIO.tracks[u])},ga=function(){var t={};return["AUDIO","SUBTITLES","CLOSED-CAPTIONS"].forEach(function(e){t[e]={groups:{},tracks:{},activePlaylistLoader:null,activeGroup:Xe,activeTrack:Xe,onGroupChanged:Xe,onTrackChanged:Xe}}),t},ya=void 0,_a=["mediaRequests","mediaRequestsAborted","mediaRequestsTimedout","mediaRequestsErrored","mediaTransferDuration","mediaBytesTransferred"],va=function(t){return this.audioSegmentLoader_[t]+this.mainSegmentLoader_[t]},ba=function(t){function i(t){T(this,i);var n=w(this,(i.__proto__||Object.getPrototypeOf(i)).call(this)),r=t.url,a=t.withCredentials,s=t.tech,o=t.bandwidth,u=t.externHls,d=t.useCueTags,l=t.blacklistDuration,c=t.enableLowInitialPlaylist,h=t.sourceType,f=t.seekTo;if(!r)throw new Error("A non-empty playlist URL is required");ya=u,n.withCredentials=a,n.tech_=s,n.hls_=s.hls,n.seekTo_=f,n.sourceType_=h,n.useCueTags_=d,n.blacklistDuration=l,n.enableLowInitialPlaylist=c,n.useCueTags_&&(n.cueTagsTrack_=n.tech_.addTextTrack("metadata","ad-cues"),n.cueTagsTrack_.inBandMetadataTrackDispatchType=""),n.requestOptions_={withCredentials:n.withCredentials,timeout:null},n.mediaTypes_=ga(),n.mediaSource=new e.MediaSource,n.mediaSource.addEventListener("sourceopen",n.handleSourceOpen_.bind(n)),n.seekable_=e.createTimeRanges(),n.hasPlayed_=function(){return!1},n.syncController_=new ra(t),n.segmentMetadataTrack_=s.addRemoteTextTrack({kind:"metadata",label:"segment-metadata"},!1).track,n.decrypter_=new aa,n.inbandTextTracks_={};var p={hls:n.hls_,mediaSource:n.mediaSource,currentTime:n.tech_.currentTime.bind(n.tech_),seekable:function(){return n.seekable()},seeking:function(){return n.tech_.seeking()},duration:function(){return n.mediaSource.duration},hasPlayed:function(){return n.hasPlayed_()},goalBufferLength:function(){return n.goalBufferLength()},bandwidth:o,syncController:n.syncController_,decrypter:n.decrypter_,sourceType:n.sourceType_,inbandTextTracks:n.inbandTextTracks_};return n.masterPlaylistLoader_="dash"===n.sourceType_?new ze(r,n.hls_,n.withCredentials):new R(r,n.hls_,n.withCredentials),n.setupMasterPlaylistLoaderListeners_(),n.mainSegmentLoader_=new Gr(e.mergeOptions(p,{segmentMetadataTrack:n.segmentMetadataTrack_,loaderType:"main"}),t),n.audioSegmentLoader_=new Gr(e.mergeOptions(p,{loaderType:"audio"}),t),n.subtitleSegmentLoader_=new jr(e.mergeOptions(p,{loaderType:"vtt"}),t),n.setupSegmentLoaderListeners_(),_a.forEach(function(t){n[t+"_"]=va.bind(n,t)}),n.logger_=We("MPC"),n.masterPlaylistLoader_.load(),n}return k(i,t),S(i,[{key:"setupMasterPlaylistLoaderListeners_",value:function(){var t=this;this.masterPlaylistLoader_.on("loadedmetadata",function(){var i=t.masterPlaylistLoader_.media(),n=1.5*t.masterPlaylistLoader_.targetDuration*1e3;$(t.masterPlaylistLoader_.master,t.masterPlaylistLoader_.media())?t.requestOptions_.timeout=0:t.requestOptions_.timeout=n,i.endList&&"none"!==t.tech_.preload()&&(t.mainSegmentLoader_.playlist(i,t.requestOptions_),t.mainSegmentLoader_.load()),ma({sourceType:t.sourceType_,segmentLoaders:{AUDIO:t.audioSegmentLoader_,SUBTITLES:t.subtitleSegmentLoader_,main:t.mainSegmentLoader_},tech:t.tech_,requestOptions:t.requestOptions_,masterPlaylistLoader:t.masterPlaylistLoader_,hls:t.hls_,master:t.master(),mediaTypes:t.mediaTypes_,blacklistCurrentPlaylist:t.blacklistCurrentPlaylist.bind(t)}),t.triggerPresenceUsage_(t.master(),i);try{t.setupSourceBuffers_()}catch(i){return e.log.warn("Failed to create SourceBuffers",i),t.mediaSource.endOfStream("decode")}t.setupFirstPlay(),t.trigger("selectedinitialmedia")}),this.masterPlaylistLoader_.on("loadedplaylist",function(){var e=t.masterPlaylistLoader_.media();if(!e){t.excludeUnsupportedVariants_();var i=void 0;return t.enableLowInitialPlaylist&&(i=t.selectInitialPlaylist()),i||(i=t.selectPlaylist()),t.initialMedia_=i,void t.masterPlaylistLoader_.media(t.initialMedia_)}if(t.useCueTags_&&t.updateAdCues_(e),t.mainSegmentLoader_.playlist(e,t.requestOptions_),t.updateDuration(),t.tech_.paused()||(t.mainSegmentLoader_.load(),t.audioSegmentLoader_&&t.audioSegmentLoader_.load()),!e.endList){var n=function(){var e=t.seekable();0!==e.length&&t.mediaSource.addSeekableRange_(e.start(0),e.end(0))};if(t.duration()!==1/0){t.tech_.one("durationchange",function e(){t.duration()===1/0?n():t.tech_.one("durationchange",e)})}else n()}}),this.masterPlaylistLoader_.on("error",function(){t.blacklistCurrentPlaylist(t.masterPlaylistLoader_.error)}),this.masterPlaylistLoader_.on("mediachanging",function(){t.mainSegmentLoader_.abort(),t.mainSegmentLoader_.pause()}),this.masterPlaylistLoader_.on("mediachange",function(){var e=t.masterPlaylistLoader_.media(),i=1.5*t.masterPlaylistLoader_.targetDuration*1e3;$(t.masterPlaylistLoader_.master,t.masterPlaylistLoader_.media())?t.requestOptions_.timeout=0:t.requestOptions_.timeout=i,t.mainSegmentLoader_.playlist(e,t.requestOptions_),t.mainSegmentLoader_.load(),t.tech_.trigger({type:"mediachange",bubbles:!0})}),this.masterPlaylistLoader_.on("playlistunchanged",function(){var e=t.masterPlaylistLoader_.media();t.stuckAtPlaylistEnd_(e)&&(t.blacklistCurrentPlaylist({message:"Playlist no longer updating."}),t.tech_.trigger("playliststuck"))}),this.masterPlaylistLoader_.on("renditiondisabled",function(){t.tech_.trigger({type:"usage",name:"hls-rendition-disabled"})}),this.masterPlaylistLoader_.on("renditionenabled",function(){t.tech_.trigger({type:"usage",name:"hls-rendition-enabled"})})}},{key:"triggerPresenceUsage_",value:function(t,e){var i=t.mediaGroups||{},n=!0,r=Object.keys(i.AUDIO);for(var a in i.AUDIO)for(var s in i.AUDIO[a]){i.AUDIO[a][s].uri||(n=!1)}n&&this.tech_.trigger({type:"usage",name:"hls-demuxed"}),Object.keys(i.SUBTITLES).length&&this.tech_.trigger({type:"usage",name:"hls-webvtt"}),ya.Playlist.isAes(e)&&this.tech_.trigger({type:"usage",name:"hls-aes"}),ya.Playlist.isFmp4(e)&&this.tech_.trigger({type:"usage",name:"hls-fmp4"}),r.length&&Object.keys(i.AUDIO[r[0]]).length>1&&this.tech_.trigger({type:"usage",name:"hls-alternate-audio"}),this.useCueTags_&&this.tech_.trigger({type:"usage",name:"hls-playlist-cue-tags"})}},{key:"setupSegmentLoaderListeners_",value:function(){var t=this;this.mainSegmentLoader_.on("bandwidthupdate",function(){var e=t.selectPlaylist(),i=t.masterPlaylistLoader_.media(),n=t.tech_.buffered(),r=n.length?n.end(n.length-1)-t.tech_.currentTime():0,a=t.bufferLowWaterLine();(!i.endList||t.duration()<Bi.MAX_BUFFER_LOW_WATER_LINE||e.attributes.BANDWIDTH<i.attributes.BANDWIDTH||r>=a)&&t.masterPlaylistLoader_.media(e),t.tech_.trigger("bandwidthupdate")}),this.mainSegmentLoader_.on("progress",function(){t.trigger("progress")}),this.mainSegmentLoader_.on("error",function(){t.blacklistCurrentPlaylist(t.mainSegmentLoader_.error())}),this.mainSegmentLoader_.on("syncinfoupdate",function(){t.onSyncInfoUpdate_()}),this.mainSegmentLoader_.on("timestampoffset",function(){t.tech_.trigger({type:"usage",name:"hls-timestamp-offset"})}),this.audioSegmentLoader_.on("syncinfoupdate",function(){t.onSyncInfoUpdate_()}),this.mainSegmentLoader_.on("ended",function(){t.onEndOfStream()}),this.mainSegmentLoader_.on("earlyabort",function(){t.blacklistCurrentPlaylist({message:"Aborted early because there isn't enough bandwidth to complete the request without rebuffering."},120)}),this.mainSegmentLoader_.on("reseteverything",function(){t.tech_.trigger("hls-reset")}),this.mainSegmentLoader_.on("segmenttimemapping",function(e){t.tech_.trigger({type:"hls-segment-time-mapping",mapping:e.mapping})}),this.audioSegmentLoader_.on("ended",function(){t.onEndOfStream()})}},{key:"mediaSecondsLoaded_",value:function(){return Math.max(this.audioSegmentLoader_.mediaSecondsLoaded+this.mainSegmentLoader_.mediaSecondsLoaded)}},{key:"load",value:function(){this.mainSegmentLoader_.load(),this.mediaTypes_.AUDIO.activePlaylistLoader&&this.audioSegmentLoader_.load(),this.mediaTypes_.SUBTITLES.activePlaylistLoader&&this.subtitleSegmentLoader_.load()}},{key:"smoothQualityChange_",value:function(){var t=this.selectPlaylist();t!==this.masterPlaylistLoader_.media()&&(this.masterPlaylistLoader_.media(t),this.mainSegmentLoader_.resetLoader())}},{key:"fastQualityChange_",value:function(){var t=this,i=this.selectPlaylist();i!==this.masterPlaylistLoader_.media()&&(this.masterPlaylistLoader_.media(i),this.mainSegmentLoader_.resetEverything(function(){e.browser.IE_VERSION||e.browser.IS_EDGE?t.tech_.setCurrentTime(t.tech_.currentTime()+.04):t.tech_.setCurrentTime(t.tech_.currentTime())}))}},{key:"play",value:function(){if(!this.setupFirstPlay()){this.tech_.ended()&&this.seekTo_(0),this.hasPlayed_()&&this.load();var t=this.tech_.seekable();return this.tech_.duration()===1/0&&this.tech_.currentTime()<t.start(0)?this.seekTo_(t.end(t.length-1)):void 0}}},{key:"setupFirstPlay",value:function(){var t=this,i=this.masterPlaylistLoader_.media();if(!i||this.tech_.paused()||this.hasPlayed_())return!1;if(!i.endList){var n=this.seekable();if(!n.length)return!1;if(e.browser.IE_VERSION&&0===this.tech_.readyState())return this.tech_.one("loadedmetadata",function(){t.trigger("firstplay"),t.seekTo_(n.end(0)),t.hasPlayed_=function(){return!0}}),!1;this.trigger("firstplay"),this.seekTo_(n.end(0))}return this.hasPlayed_=function(){return!0},this.load(),!0}},{key:"handleSourceOpen_",value:function(){try{this.setupSourceBuffers_()}catch(t){return e.log.warn("Failed to create Source Buffers",t),this.mediaSource.endOfStream("decode")}if(this.tech_.autoplay()){var t=this.tech_.play();void 0!==t&&"function"==typeof t.then&&t.then(null,function(t){})}this.trigger("sourceopen")}},{key:"onEndOfStream",value:function(){var t=this.mainSegmentLoader_.ended_;this.mediaTypes_.AUDIO.activePlaylistLoader&&(t=!this.mainSegmentLoader_.startingMedia_||this.mainSegmentLoader_.startingMedia_.containsVideo?t&&this.audioSegmentLoader_.ended_:this.audioSegmentLoader_.ended_),t&&this.mediaSource.endOfStream()}},{key:"stuckAtPlaylistEnd_",value:function(t){if(!this.seekable().length)return!1;var e=this.syncController_.getExpiredTime(t,this.mediaSource.duration);if(null===e)return!1;var i=ya.Playlist.playlistEnd(t,e),n=this.tech_.currentTime(),r=this.tech_.buffered();if(!r.length)return i-n<=.1;var a=r.end(r.length-1);return a-n<=.1&&i-a<=.1}},{key:"blacklistCurrentPlaylist",value:function(){var t,i=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},n=arguments[1],r=void 0;if(r=i.playlist||this.masterPlaylistLoader_.media(),n=n||i.blacklistDuration||this.blacklistDuration,!r){this.error=i;try{return this.mediaSource.endOfStream("network")}catch(t){return this.trigger("error")}}var a=1===this.masterPlaylistLoader_.master.playlists.filter(X).length;return a?(e.log.warn("Problem encountered with the current HLS playlist. Trying again since it is the final playlist."),this.tech_.trigger("retryplaylist"),this.masterPlaylistLoader_.load(a)):(r.excludeUntil=Date.now()+1e3*n,this.tech_.trigger("blacklistplaylist"),this.tech_.trigger({type:"usage",name:"hls-rendition-blacklisted"}),t=this.selectPlaylist(),e.log.warn("Problem encountered with the current HLS playlist."+(i.message?" "+i.message:"")+" Switching to another playlist."),this.masterPlaylistLoader_.media(t))}},{key:"pauseLoading",value:function(){this.mainSegmentLoader_.pause(),this.mediaTypes_.AUDIO.activePlaylistLoader&&this.audioSegmentLoader_.pause(),this.mediaTypes_.SUBTITLES.activePlaylistLoader&&this.subtitleSegmentLoader_.pause()}},{key:"setCurrentTime",value:function(t){var e=kt(this.tech_.buffered(),t);return this.masterPlaylistLoader_&&this.masterPlaylistLoader_.media()&&this.masterPlaylistLoader_.media().segments?e&&e.length?t:(this.mainSegmentLoader_.resetEverything(),this.mainSegmentLoader_.abort(),this.mediaTypes_.AUDIO.activePlaylistLoader&&(this.audioSegmentLoader_.resetEverything(),this.audioSegmentLoader_.abort()),this.mediaTypes_.SUBTITLES.activePlaylistLoader&&(this.subtitleSegmentLoader_.resetEverything(),this.subtitleSegmentLoader_.abort()),void this.load()):0}},{key:"duration",value:function(){return this.masterPlaylistLoader_?this.mediaSource?this.mediaSource.duration:ya.Playlist.duration(this.masterPlaylistLoader_.media()):0}},{key:"seekable",value:function(){return this.seekable_}},{key:"onSyncInfoUpdate_",value:function(){var t=void 0,i=void 0;if(this.masterPlaylistLoader_){var n=this.masterPlaylistLoader_.media();if(n){var r=this.syncController_.getExpiredTime(n,this.mediaSource.duration);if(null!==r&&0!==(t=ya.Playlist.seekable(n,r)).length){if(this.mediaTypes_.AUDIO.activePlaylistLoader){if(n=this.mediaTypes_.AUDIO.activePlaylistLoader.media(),null===(r=this.syncController_.getExpiredTime(n,this.mediaSource.duration)))return;if(0===(i=ya.Playlist.seekable(n,r)).length)return}i?i.start(0)>t.end(0)||t.start(0)>i.end(0)?this.seekable_=t:this.seekable_=e.createTimeRanges([[i.start(0)>t.start(0)?i.start(0):t.start(0),i.end(0)<t.end(0)?i.end(0):t.end(0)]]):this.seekable_=t,this.logger_("seekable updated ["+Ut(this.seekable_)+"]"),this.tech_.trigger("seekablechanged")}}}}},{key:"updateDuration",value:function(){var t=this,e=this.mediaSource.duration,i=ya.Playlist.duration(this.masterPlaylistLoader_.media()),n=this.tech_.buffered(),r=function e(){t.mediaSource.duration=i,t.tech_.trigger("durationchange"),t.mediaSource.removeEventListener("sourceopen",e)};n.length>0&&(i=Math.max(i,n.end(n.length-1))),e!==i&&("open"!==this.mediaSource.readyState?this.mediaSource.addEventListener("sourceopen",r):r())}},{key:"dispose",value:function(){var t=this;this.decrypter_.terminate(),this.masterPlaylistLoader_.dispose(),this.mainSegmentLoader_.dispose(),["AUDIO","SUBTITLES"].forEach(function(e){var i=t.mediaTypes_[e].groups;for(var n in i)i[n].forEach(function(t){t.playlistLoader&&t.playlistLoader.dispose()})}),this.audioSegmentLoader_.dispose(),this.subtitleSegmentLoader_.dispose()}},{key:"master",value:function(){return this.masterPlaylistLoader_.master}},{key:"media",value:function(){return this.masterPlaylistLoader_.media()||this.initialMedia_}},{key:"setupSourceBuffers_",value:function(){var t,e=this.masterPlaylistLoader_.media();if(e&&"open"===this.mediaSource.readyState){if((t=Wt(this.masterPlaylistLoader_.master,e)).length<1)return this.error="No compatible SourceBuffer configuration for the variant stream:"+e.resolvedUri,this.mediaSource.endOfStream("decode");this.configureLoaderMimeTypes_(t),this.excludeIncompatibleVariants_(e)}}},{key:"configureLoaderMimeTypes_",value:function(t){var i=t.length>1&&-1===t[0].indexOf(",")&&t[0]!==t[1]?new e.EventTarget:null;this.mainSegmentLoader_.mimeType(t[0],i),t[1]&&this.audioSegmentLoader_.mimeType(t[1],i)}},{key:"excludeUnsupportedVariants_",value:function(){this.master().playlists.forEach(function(t){var e;t.attributes.CODECS&&c.MediaSource&&c.MediaSource.isTypeSupported&&!c.MediaSource.isTypeSupported('video/mp4; codecs="'+(e=t.attributes.CODECS,e.replace(/avc1\.(\d+)\.(\d+)/i,function(t){return Ht([t])[0]}))+'"')&&(t.excludeUntil=1/0)})}},{key:"excludeIncompatibleVariants_",value:function(t){var e=2,i=null,n=void 0;t.attributes.CODECS&&(n=jt(t.attributes.CODECS),i=n.videoCodec,e=n.codecCount),this.master().playlists.forEach(function(t){var n={codecCount:2,videoCodec:null};t.attributes.CODECS&&(n=jt(t.attributes.CODECS)),n.codecCount!==e&&(t.excludeUntil=1/0),n.videoCodec!==i&&(t.excludeUntil=1/0)})}},{key:"updateAdCues_",value:function(t){var e=0,i=this.seekable();i.length&&(e=i.start(0)),function(t,e){var i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0;if(t.segments)for(var n=i,r=void 0,a=0;a<t.segments.length;a++){var s=t.segments[a];if(r||(r=zr(e,n+s.duration/2)),r){if("cueIn"in s){r.endTime=n,r.adEndTime=n,n+=s.duration,r=null;continue}if(n<r.endTime){n+=s.duration;continue}r.endTime+=s.duration}else if("cueOut"in s&&((r=new c.VTTCue(n,n+s.duration,s.cueOut)).adStartTime=n,r.adEndTime=n+parseFloat(s.cueOut),e.addCue(r)),"cueOutCont"in s){var o,u,d=s.cueOutCont.split("/").map(parseFloat),l=U(d,2);o=l[0],u=l[1],(r=new c.VTTCue(n,n+s.duration,"")).adStartTime=n-o,r.adEndTime=r.adStartTime+u,e.addCue(r)}n+=s.duration}}(t,this.cueTagsTrack_,e)}},{key:"goalBufferLength",value:function(){var t=this.tech_.currentTime(),e=Bi.GOAL_BUFFER_LENGTH,i=Bi.GOAL_BUFFER_LENGTH_RATE,n=Math.max(e,Bi.MAX_GOAL_BUFFER_LENGTH);return Math.min(e+t*i,n)}},{key:"bufferLowWaterLine",value:function(){var t=this.tech_.currentTime(),e=Bi.BUFFER_LOW_WATER_LINE,i=Bi.BUFFER_LOW_WATER_LINE_RATE,n=Math.max(e,Bi.MAX_BUFFER_LOW_WATER_LINE);return Math.min(e+t*i,n)}}]),i}(e.EventTarget),Ta=function t(e,i,n){T(this,t);var r,a,s,o=e.masterPlaylistController_,u=o[(e.options_.smoothQualityChange?"smooth":"fast")+"QualityChange_"].bind(o);if(i.attributes.RESOLUTION){var d=i.attributes.RESOLUTION;this.width=d.width,this.height=d.height}this.bandwidth=i.attributes.BANDWIDTH,this.id=n,this.enabled=(r=e.playlists,a=i.uri,s=u,function(t){var e=r.master.playlists[a],i=W(e),n=X(e);return void 0===t?n:(t?delete e.disabled:e.disabled=!0,t===n||i||(s(),t?r.trigger("renditionenabled"):r.trigger("renditiondisabled")),t)})},Sa=["seeking","seeked","pause","playing","error"],ka=function(){function t(e){var i=this;T(this,t),this.tech_=e.tech,this.seekable=e.seekable,this.seekTo=e.seekTo,this.allowSeeksWithinUnsafeLiveWindow=e.allowSeeksWithinUnsafeLiveWindow,this.media=e.media,this.consecutiveUpdates=0,this.lastRecordedTime=null,this.timer_=null,this.checkCurrentTimeTimeout_=null,this.logger_=We("PlaybackWatcher"),this.logger_("initialize");var n=function(){return i.monitorCurrentTime_()},r=function(){return i.techWaiting_()},a=function(){return i.cancelTimer_()},s=function(){return i.fixesBadSeeks_()};this.tech_.on("seekablechanged",s),this.tech_.on("waiting",r),this.tech_.on(Sa,a),this.tech_.on("canplay",n),this.dispose=function(){i.logger_("dispose"),i.tech_.off("seekablechanged",s),i.tech_.off("waiting",r),i.tech_.off(Sa,a),i.tech_.off("canplay",n),i.checkCurrentTimeTimeout_&&c.clearTimeout(i.checkCurrentTimeTimeout_),i.cancelTimer_()}}return S(t,[{key:"monitorCurrentTime_",value:function(){this.checkCurrentTime_(),this.checkCurrentTimeTimeout_&&c.clearTimeout(this.checkCurrentTimeTimeout_),this.checkCurrentTimeTimeout_=c.setTimeout(this.monitorCurrentTime_.bind(this),250)}},{key:"checkCurrentTime_",value:function(){if(this.tech_.seeking()&&this.fixesBadSeeks_())return this.consecutiveUpdates=0,void(this.lastRecordedTime=this.tech_.currentTime());if(!this.tech_.paused()&&!this.tech_.seeking()){var t=this.tech_.currentTime(),e=this.tech_.buffered();if(this.lastRecordedTime===t&&(!e.length||t+.1>=e.end(e.length-1)))return this.techWaiting_();this.consecutiveUpdates>=5&&t===this.lastRecordedTime?(this.consecutiveUpdates++,this.waiting_()):t===this.lastRecordedTime?this.consecutiveUpdates++:(this.consecutiveUpdates=0,this.lastRecordedTime=t)}}},{key:"cancelTimer_",value:function(){this.consecutiveUpdates=0,this.timer_&&(this.logger_("cancelTimer_"),clearTimeout(this.timer_)),this.timer_=null}},{key:"fixesBadSeeks_",value:function(){if(!this.tech_.seeking())return!1;var t=this.seekable(),e=this.tech_.currentTime(),i=void 0;this.afterSeekableWindow_(t,e,this.media(),this.allowSeeksWithinUnsafeLiveWindow)&&(i=t.end(t.length-1));this.beforeSeekableWindow_(t,e)&&(i=t.start(0)+.1);return void 0!==i&&(this.logger_("Trying to seek outside of seekable at time "+e+" with seekable range "+Ut(t)+". Seeking to "+i+"."),this.seekTo(i),!0)}},{key:"waiting_",value:function(){if(!this.techWaiting_()){var t=this.tech_.currentTime(),e=this.tech_.buffered(),i=kt(e,t);return i.length&&t+3<=i.end(0)?(this.cancelTimer_(),this.seekTo(t),this.logger_("Stopped at "+t+" while inside a buffered region ["+i.start(0)+" -> "+i.end(0)+"]. Attempting to resume playback by seeking to the current time."),void this.tech_.trigger({type:"usage",name:"hls-unknown-waiting"})):void 0}}},{key:"techWaiting_",value:function(){var t=this.seekable(),e=this.tech_.currentTime();if(this.tech_.seeking()&&this.fixesBadSeeks_())return!0;if(this.tech_.seeking()||null!==this.timer_)return!0;if(this.beforeSeekableWindow_(t,e)){var i=t.end(t.length-1);return this.logger_("Fell out of live window at time "+e+". Seeking to live point (seekable end) "+i),this.cancelTimer_(),this.seekTo(i),this.tech_.trigger({type:"usage",name:"hls-live-resync"}),!0}var n=this.tech_.buffered(),r=wt(n,e);if(this.videoUnderflow_(r,n,e))return this.cancelTimer_(),this.seekTo(e),this.tech_.trigger({type:"usage",name:"hls-video-underflow"}),!0;if(r.length>0){var a=r.start(0)-e;return this.logger_("Stopped at "+e+", setting timer for "+a+", seeking to "+r.start(0)),this.timer_=setTimeout(this.skipTheGap_.bind(this),1e3*a,e),!0}return!1}},{key:"afterSeekableWindow_",value:function(t,e,i){var n=arguments.length>3&&void 0!==arguments[3]&&arguments[3];if(!t.length)return!1;var r=t.end(t.length-1)+.1;return!i.endList&&n&&(r=t.end(t.length-1)+3*i.targetDuration),e>r}},{key:"beforeSeekableWindow_",value:function(t,e){return!!(t.length&&t.start(0)>0&&e<t.start(0)-.1)}},{key:"videoUnderflow_",value:function(t,e,i){if(0===t.length){var n=this.gapFromVideoUnderflow_(e,i);if(n)return this.logger_("Encountered a gap in video from "+n.start+" to "+n.end+". Seeking to current time "+i),!0}return!1}},{key:"skipTheGap_",value:function(t){var e=this.tech_.buffered(),i=this.tech_.currentTime(),n=wt(e,i);this.cancelTimer_(),0!==n.length&&i===t&&(this.logger_("skipTheGap_:","currentTime:",i,"scheduled currentTime:",t,"nextRange start:",n.start(0)),this.seekTo(n.start(0)+1/30),this.tech_.trigger({type:"usage",name:"hls-gap-skip"}))}},{key:"gapFromVideoUnderflow_",value:function(t,i){for(var n=function(t){if(t.length<2)return e.createTimeRanges();for(var i=[],n=1;n<t.length;n++){var r=t.end(n-1),a=t.start(n);i.push([r,a])}return e.createTimeRanges(i)}(t),r=0;r<n.length;r++){var a=n.start(r),s=n.end(r);if(i-a<4&&i-a>2)return{start:a,end:s}}return null}}]),t}(),wa={errorInterval:30,getSource:function(t){return t(this.tech({IWillNotUseThisInPlugins:!0}).currentSource_)}},Ua=function(t){!function t(i,n){var r=0,a=0,s=e.mergeOptions(wa,n);i.ready(function(){i.trigger({type:"usage",name:"hls-error-reload-initialized"})});var o=function(){a&&i.currentTime(a)},u=function(t){null!==t&&void 0!==t&&(a=i.duration()!==1/0&&i.currentTime()||0,i.one("loadedmetadata",o),i.src(t),i.trigger({type:"usage",name:"hls-error-reload"}),i.play())},d=function(){if(Date.now()-r<1e3*s.errorInterval)i.trigger({type:"usage",name:"hls-error-reload-canceled"});else{if(s.getSource&&"function"==typeof s.getSource)return r=Date.now(),s.getSource.call(i,u);e.log.error("ERROR: reloadSourceOnError - The option getSource must be a function!")}},l=function t(){i.off("loadedmetadata",o),i.off("error",d),i.off("dispose",t)};i.on("error",d),i.on("dispose",l),i.reloadSourceOnError=function(e){l(),t(i,e)}}(this,t)};e.use("*",function(t){return{setSource:function(t,e){e(null,t)},setCurrentTime:function(e){return t.vhs&&t.currentSource().src===t.vhs.source_.src&&t.vhs.setCurrentTime(e),e},play:function(){t.vhs&&t.currentSource().src===t.vhs.source_.src&&t.vhs.setCurrentTime(t.currentTime())}}});var La={PlaylistLoader:R,Playlist:K,Decrypter:lt,AsyncStream:ot,decrypt:dt,utils:yt,STANDARD_PLAYLIST_SELECTOR:function(){return function(t,e,i,n,r){var a=t.playlists.map(function(t){var e,i;return e=t.attributes.RESOLUTION&&t.attributes.RESOLUTION.width,i=t.attributes.RESOLUTION&&t.attributes.RESOLUTION.height,{bandwidth:t.attributes.BANDWIDTH||c.Number.MAX_VALUE,width:e,height:i,playlist:t}});Ki(a,function(t,e){return t.bandwidth-e.bandwidth});var s=(a=a.filter(function(t){return!K.isIncompatible(t.playlist)})).filter(function(t){return K.isEnabled(t.playlist)});s.length||(s=a.filter(function(t){return!K.isDisabled(t.playlist)}));var o=s.filter(function(t){return t.bandwidth*Bi.BANDWIDTH_VARIANCE<e}),u=o[o.length-1],d=o.filter(function(t){return t.bandwidth===u.bandwidth})[0];if(!1===r){var l=d||s[0]||a[0];return l?l.playlist:null}var h=o.filter(function(t){return t.width&&t.height});Ki(h,function(t,e){return t.width-e.width});var f=h.filter(function(t){return t.width===i&&t.height===n});u=f[f.length-1];var p=f.filter(function(t){return t.bandwidth===u.bandwidth})[0],m=void 0,g=void 0,y=void 0;p||(g=(m=h.filter(function(t){return t.width>i||t.height>n})).filter(function(t){return t.width===m[0].width&&t.height===m[0].height}),u=g[g.length-1],y=g.filter(function(t){return t.bandwidth===u.bandwidth})[0]);var _=y||p||d||s[0]||a[0];return _?_.playlist:null}(this.playlists.master,this.systemBandwidth,parseInt($i(this.tech_.el(),"width"),10),parseInt($i(this.tech_.el(),"height"),10),this.limitRenditionByPlayerDimensions)},INITIAL_PLAYLIST_SELECTOR:function(){var t=this.playlists.master.playlists.filter(K.isEnabled);return Ki(t,function(t,e){return Qi(t,e)}),t.filter(function(t){return jt(t.attributes.CODECS).videoCodec})[0]||null},comparePlaylistBandwidth:Qi,comparePlaylistResolution:function(t,e){var i=void 0,n=void 0;return t.attributes.RESOLUTION&&t.attributes.RESOLUTION.width&&(i=t.attributes.RESOLUTION.width),i=i||c.Number.MAX_VALUE,e.attributes.RESOLUTION&&e.attributes.RESOLUTION.width&&(n=e.attributes.RESOLUTION.width),i===(n=n||c.Number.MAX_VALUE)&&t.attributes.BANDWIDTH&&e.attributes.BANDWIDTH?t.attributes.BANDWIDTH-e.attributes.BANDWIDTH:i-n},xhr:J()};["GOAL_BUFFER_LENGTH","MAX_GOAL_BUFFER_LENGTH","GOAL_BUFFER_LENGTH_RATE","BUFFER_LOW_WATER_LINE","MAX_BUFFER_LOW_WATER_LINE","BUFFER_LOW_WATER_LINE_RATE","BANDWIDTH_VARIANCE"].forEach(function(t){Object.defineProperty(La,t,{get:function(){return e.log.warn("using Hls."+t+" is UNSAFE be sure you know what you are doing"),Bi[t]},set:function(i){e.log.warn("using Hls."+t+" is UNSAFE be sure you know what you are doing"),"number"!=typeof i||i<0?e.log.warn("value of Hls."+t+" must be greater than or equal to 0"):Bi[t]=i}})});var Aa=function(t){if(/^(audio|video|application)\/(x-|vnd\.apple\.)?mpegurl/i.test(t))return"hls";return/^application\/dash\+xml/i.test(t)?"dash":null},Ea=function(t,e){for(var i=e.media(),n=-1,r=0;r<t.length;r++)if(t[r].id===i.uri){n=r;break}t.selectedIndex_=n,t.trigger({selectedIndex:n,type:"change"})};La.canPlaySource=function(){return e.log.warn("HLS is no longer a tech. Please remove it from your player's techOrder.")};var Oa=function(t,i,n){if(!t)return t;var r={};for(var a in t)r[a]={audioContentType:'audio/mp4; codecs="'+n.attributes.CODECS+'"',videoContentType:'video/mp4; codecs="'+i.attributes.CODECS+'"'},i.contentProtection&&i.contentProtection[a]&&i.contentProtection[a].pssh&&(r[a].pssh=i.contentProtection[a].pssh),"string"==typeof t[a]&&(r[a].url=t[a]);return e.mergeOptions(t,r)},Ca=function(){if(!window.localStorage)return null;var t=window.localStorage.getItem("videojs-vhs");if(!t)return null;try{return JSON.parse(t)}catch(t){return null}};La.supportsNativeHls=function(){var t=d.createElement("video");if(!e.getTech("Html5").isSupported())return!1;return["application/vnd.apple.mpegurl","audio/mpegurl","audio/x-mpegurl","application/x-mpegurl","video/x-mpegurl","video/mpegurl","application/mpegurl"].some(function(e){return/maybe|probably/i.test(t.canPlayType(e))})}(),La.supportsNativeDash=!!e.getTech("Html5").isSupported()&&/maybe|probably/i.test(d.createElement("video").canPlayType("application/dash+xml")),La.supportsTypeNatively=function(t){return"hls"===t?La.supportsNativeHls:"dash"===t&&La.supportsNativeDash},La.isSupported=function(){return e.log.warn("HLS is no longer a tech. Please remove it from your player's techOrder.")};var Ia=e.getComponent("Component"),Da=function(t){function i(t,n,r){T(this,i);var a=w(this,(i.__proto__||Object.getPrototypeOf(i)).call(this,n,r.hls));if(n.options_&&n.options_.playerId){var s=e(n.options_.playerId);s.hasOwnProperty("hls")||Object.defineProperty(s,"hls",{get:function(){return e.log.warn("player.hls is deprecated. Use player.tech().hls instead."),n.trigger({type:"usage",name:"hls-player-access"}),a},configurable:!0}),s.vhs=a,s.dash=a,a.player_=s}if(a.tech_=n,a.source_=t,a.stats={},a.setOptions_(),a.options_.overrideNative&&n.overrideNativeAudioTracks&&n.overrideNativeVideoTracks)n.overrideNativeAudioTracks(!0),n.overrideNativeVideoTracks(!0);else if(a.options_.overrideNative&&(n.featuresNativeVideoTracks||n.featuresNativeAudioTracks))throw new Error("Overriding native HLS requires emulated tracks. See https://git.io/vMpjB");return a.on(d,["fullscreenchange","webkitfullscreenchange","mozfullscreenchange","MSFullscreenChange"],function(t){var e=d.fullscreenElement||d.webkitFullscreenElement||d.mozFullScreenElement||d.msFullscreenElement;e&&e.contains(a.tech_.el())&&a.masterPlaylistController_.smoothQualityChange_()}),a.on(a.tech_,"seeking",function(){this.tech_.seeking()&&0===this.tech_.currentTime()&&this.tech_.player_.loop()&&this.setCurrentTime(0)}),a.on(a.tech_,"error",function(){this.masterPlaylistController_&&this.masterPlaylistController_.pauseLoading()}),a.on(a.tech_,"play",a.play),a}return k(i,Ia),S(i,[{key:"setOptions_",value:function(){var t=this;if(this.options_.withCredentials=this.options_.withCredentials||!1,this.options_.limitRenditionByPlayerDimensions=!1!==this.options_.limitRenditionByPlayerDimensions,this.options_.smoothQualityChange=this.options_.smoothQualityChange||!1,this.options_.useBandwidthFromLocalStorage=void 0!==this.source_.useBandwidthFromLocalStorage?this.source_.useBandwidthFromLocalStorage:this.options_.useBandwidthFromLocalStorage||!1,this.options_.customTagParsers=this.options_.customTagParsers||[],this.options_.customTagMappers=this.options_.customTagMappers||[],"number"!=typeof this.options_.blacklistDuration&&(this.options_.blacklistDuration=300),"number"!=typeof this.options_.bandwidth&&this.options_.useBandwidthFromLocalStorage){var e=Ca();e&&e.bandwidth&&(this.options_.bandwidth=e.bandwidth,this.tech_.trigger({type:"usage",name:"hls-bandwidth-from-local-storage"})),e&&e.throughput&&(this.options_.throughput=e.throughput,this.tech_.trigger({type:"usage",name:"hls-throughput-from-local-storage"}))}"number"!=typeof this.options_.bandwidth&&(this.options_.bandwidth=Bi.INITIAL_BANDWIDTH),this.options_.enableLowInitialPlaylist=this.options_.enableLowInitialPlaylist&&this.options_.bandwidth===Bi.INITIAL_BANDWIDTH,["withCredentials","limitRenditionByPlayerDimensions","bandwidth","smoothQualityChange","customTagParsers","customTagMappers"].forEach(function(e){void 0!==t.source_[e]&&(t.options_[e]=t.source_[e])}),this.limitRenditionByPlayerDimensions=this.options_.limitRenditionByPlayerDimensions}},{key:"src",value:function(t,i){var n=this;t&&(this.setOptions_(),this.options_.url=this.source_.src,this.options_.tech=this.tech_,this.options_.externHls=La,this.options_.sourceType=Aa(i),this.options_.seekTo=function(t){n.tech_.setCurrentTime(t),n.setCurrentTime(t)},this.masterPlaylistController_=new ba(this.options_),this.playbackWatcher_=new ka(e.mergeOptions(this.options_,{seekable:function(){return n.seekable()},media:function(){return n.masterPlaylistController_.media()}})),this.masterPlaylistController_.on("error",function(){e.players[n.tech_.options_.playerId].error(n.masterPlaylistController_.error)}),this.masterPlaylistController_.selectPlaylist=this.selectPlaylist?this.selectPlaylist.bind(this):La.STANDARD_PLAYLIST_SELECTOR.bind(this),this.masterPlaylistController_.selectInitialPlaylist=La.INITIAL_PLAYLIST_SELECTOR.bind(this),this.playlists=this.masterPlaylistController_.masterPlaylistLoader_,this.mediaSource=this.masterPlaylistController_.mediaSource,Object.defineProperties(this,{selectPlaylist:{get:function(){return this.masterPlaylistController_.selectPlaylist},set:function(t){this.masterPlaylistController_.selectPlaylist=t.bind(this)}},throughput:{get:function(){return this.masterPlaylistController_.mainSegmentLoader_.throughput.rate},set:function(t){this.masterPlaylistController_.mainSegmentLoader_.throughput.rate=t,this.masterPlaylistController_.mainSegmentLoader_.throughput.count=1}},bandwidth:{get:function(){return this.masterPlaylistController_.mainSegmentLoader_.bandwidth},set:function(t){this.masterPlaylistController_.mainSegmentLoader_.bandwidth=t,this.masterPlaylistController_.mainSegmentLoader_.throughput={rate:0,count:0}}},systemBandwidth:{get:function(){var t=1/(this.bandwidth||1),e=void 0;return e=this.throughput>0?1/this.throughput:0,Math.floor(1/(t+e))},set:function(){e.log.error('The "systemBandwidth" property is read-only')}}}),this.options_.bandwidth&&(this.bandwidth=this.options_.bandwidth),this.options_.throughput&&(this.throughput=this.options_.throughput),Object.defineProperties(this.stats,{bandwidth:{get:function(){return n.bandwidth||0},enumerable:!0},mediaRequests:{get:function(){return n.masterPlaylistController_.mediaRequests_()||0},enumerable:!0},mediaRequestsAborted:{get:function(){return n.masterPlaylistController_.mediaRequestsAborted_()||0},enumerable:!0},mediaRequestsTimedout:{get:function(){return n.masterPlaylistController_.mediaRequestsTimedout_()||0},enumerable:!0},mediaRequestsErrored:{get:function(){return n.masterPlaylistController_.mediaRequestsErrored_()||0},enumerable:!0},mediaTransferDuration:{get:function(){return n.masterPlaylistController_.mediaTransferDuration_()||0},enumerable:!0},mediaBytesTransferred:{get:function(){return n.masterPlaylistController_.mediaBytesTransferred_()||0},enumerable:!0},mediaSecondsLoaded:{get:function(){return n.masterPlaylistController_.mediaSecondsLoaded_()||0},enumerable:!0},buffered:{get:function(){return Lt(n.tech_.buffered())},enumerable:!0},currentTime:{get:function(){return n.tech_.currentTime()},enumerable:!0},currentSource:{get:function(){return n.tech_.currentSource_},enumerable:!0},currentTech:{get:function(){return n.tech_.name_},enumerable:!0},duration:{get:function(){return n.tech_.duration()},enumerable:!0},master:{get:function(){return n.playlists.master},enumerable:!0},playerDimensions:{get:function(){return n.tech_.currentDimensions()},enumerable:!0},seekable:{get:function(){return Lt(n.tech_.seekable())},enumerable:!0},timestamp:{get:function(){return Date.now()},enumerable:!0},videoPlaybackQuality:{get:function(){return n.tech_.getVideoPlaybackQuality()},enumerable:!0}}),this.tech_.one("canplay",this.masterPlaylistController_.setupFirstPlay.bind(this.masterPlaylistController_)),this.tech_.on("bandwidthupdate",function(){n.options_.useBandwidthFromLocalStorage&&function(t){if(!window.localStorage)return!1;var i=Ca();i=i?e.mergeOptions(i,t):t;try{window.localStorage.setItem("videojs-vhs",JSON.stringify(i))}catch(t){return!1}}({bandwidth:n.bandwidth,throughput:Math.round(n.throughput)})}),this.masterPlaylistController_.on("selectedinitialmedia",function(){var t,i;i=(t=n).playlists,t.representations=function(){return i.master.playlists.filter(function(t){return!W(t)}).map(function(e,i){return new Ta(t,e,e.uri)})},function(t){if("dash"===t.options_.sourceType){var i=e.players[t.tech_.options_.playerId];if(i.eme){var n=Oa(t.source_.keySystems,t.playlists.media(),t.masterPlaylistController_.mediaTypes_.AUDIO.activePlaylistLoader.media());n&&(i.currentSource().keySystems=n,i.eme.initializeMediaKeys&&i.eme.initializeMediaKeys())}}}(n)}),this.on(this.masterPlaylistController_,"progress",function(){this.tech_.trigger("progress")}),this.tech_.ready(function(){return n.setupQualityLevels_()}),this.tech_.el()&&this.tech_.src(e.URL.createObjectURL(this.masterPlaylistController_.mediaSource)))}},{key:"setupQualityLevels_",value:function(){var t=this,i=e.players[this.tech_.options_.playerId];i&&i.qualityLevels&&(this.qualityLevels_=i.qualityLevels(),this.masterPlaylistController_.on("selectedinitialmedia",function(){var e,i;e=t.qualityLevels_,(i=t).representations().forEach(function(t){e.addQualityLevel(t)}),Ea(e,i.playlists)}),this.playlists.on("mediachange",function(){Ea(t.qualityLevels_,t.playlists)}))}},{key:"play",value:function(){this.masterPlaylistController_.play()}},{key:"setCurrentTime",value:function(t){this.masterPlaylistController_.setCurrentTime(t)}},{key:"duration",value:function(){return this.masterPlaylistController_.duration()}},{key:"seekable",value:function(){return this.masterPlaylistController_.seekable()}},{key:"dispose",value:function(){this.playbackWatcher_&&this.playbackWatcher_.dispose(),this.masterPlaylistController_&&this.masterPlaylistController_.dispose(),this.qualityLevels_&&this.qualityLevels_.dispose(),this.player_&&(delete this.player_.vhs,delete this.player_.dash,delete this.player_.hls),this.tech_&&this.tech_.hls&&delete this.tech_.hls,function t(e,i,n){null===e&&(e=Function.prototype);var r=Object.getOwnPropertyDescriptor(e,i);if(void 0===r){var a=Object.getPrototypeOf(e);return null===a?void 0:t(a,i,n)}if("value"in r)return r.value;var s=r.get;return void 0!==s?s.call(n):void 0}(i.prototype.__proto__||Object.getPrototypeOf(i.prototype),"dispose",this).call(this)}},{key:"convertToStreamTime",value:function(t,e){return bt({playlist:this.masterPlaylistController_.media(),time:t,callback:e})}},{key:"seekToStreamTime",value:function(t,e){var i=!(arguments.length>2&&void 0!==arguments[2])||arguments[2],n=arguments.length>3&&void 0!==arguments[3]?arguments[3]:2;return Tt({streamTime:t,playlist:this.masterPlaylistController_.media(),retryCount:n,pauseAfterSeek:i,seekTo:this.options_.seekTo,tech:this.options_.tech,callback:e})}}]),i}(),Pa={name:"videojs-http-streaming",VERSION:"1.8.0",canHandleSource:function(t){var i=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=e.mergeOptions(e.options,i);return Pa.canPlayType(t.type,n)},handleSource:function(t,i){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r=e.mergeOptions(e.options,n);return i.hls=new Da(t,i,r),i.hls.xhr=J(),i.hls.src(t.src,t.type),i.hls},canPlayType:function(t){var i=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=e.mergeOptions(e.options,i).hls.overrideNative,r=Aa(t);return r&&(!La.supportsTypeNatively(r)||n)?"maybe":""}};void 0!==e.MediaSource&&void 0!==e.URL||(e.MediaSource=ee,e.URL=ie),ee.supportsNativeMediaSources()&&e.getTech("Html5").registerSourceHandler(Pa,0),e.HlsHandler=Da,e.HlsSourceHandler=Pa,e.Hls=La,e.use||e.registerComponent("Hls",La),e.options.hls=e.options.hls||{},e.registerPlugin?e.registerPlugin("reloadSourceOnError",Ua):e.plugin("reloadSourceOnError",Ua),t.LOCAL_STORAGE_KEY="videojs-vhs",t.Hls=La,t.HlsHandler=Da,t.HlsSourceHandler=Pa,t.emeKeySystems=Oa,t.simpleTypeFromSourceType=Aa,Object.defineProperty(t,"__esModule",{value:!0})});
