/**
 * @videojs/http-streaming
 * @version 1.9.3
 * @copyright 2019 Brightcove, Inc
 * @license Apache-2.0
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("video.js")):"function"==typeof define&&define.amd?define(["exports","video.js"],t):t(e.videojsHttpStreaming={},e.videojs)}(this,function(e,t){"use strict";t=t&&t.hasOwnProperty("default")?t.default:t;var i="undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};var n,r={},a=Object.freeze({default:r}),s=a&&r||a,o=void 0!==i?i:"undefined"!=typeof window?window:{};"undefined"!=typeof document?n=document:(n=o["__GLOBAL_DOCUMENT_CACHE@4"])||(n=o["__GLOBAL_DOCUMENT_CACHE@4"]=s);var u,d=n,l=(function(e,t){var i,n,r,a,s;i=/^((?:[a-zA-Z0-9+\-.]+:)?)(\/\/[^\/\;?#]*)?(.*?)??(;.*?)?(\?.*?)?(#.*?)?$/,n=/^([^\/;?#]*)(.*)$/,r=/(?:\/|^)\.(?=\/)/g,a=/(?:\/|^)\.\.\/(?!\.\.\/).*?(?=\/)/g,s={buildAbsoluteURL:function(e,t,i){if(i=i||{},e=e.trim(),!(t=t.trim())){if(!i.alwaysNormalize)return e;var r=this.parseURL(e);if(!r)throw new Error("Error trying to parse base URL.");return r.path=s.normalizePath(r.path),s.buildURLFromParts(r)}var a=this.parseURL(t);if(!a)throw new Error("Error trying to parse relative URL.");if(a.scheme)return i.alwaysNormalize?(a.path=s.normalizePath(a.path),s.buildURLFromParts(a)):t;var o=this.parseURL(e);if(!o)throw new Error("Error trying to parse base URL.");if(!o.netLoc&&o.path&&"/"!==o.path[0]){var u=n.exec(o.path);o.netLoc=u[1],o.path=u[2]}o.netLoc&&!o.path&&(o.path="/");var d={scheme:o.scheme,netLoc:a.netLoc,path:null,params:a.params,query:a.query,fragment:a.fragment};if(!a.netLoc&&(d.netLoc=o.netLoc,"/"!==a.path[0]))if(a.path){var l=o.path,h=l.substring(0,l.lastIndexOf("/")+1)+a.path;d.path=s.normalizePath(h)}else d.path=o.path,a.params||(d.params=o.params,a.query||(d.query=o.query));return null===d.path&&(d.path=i.alwaysNormalize?s.normalizePath(a.path):a.path),s.buildURLFromParts(d)},parseURL:function(e){var t=i.exec(e);return t?{scheme:t[1]||"",netLoc:t[2]||"",path:t[3]||"",params:t[4]||"",query:t[5]||"",fragment:t[6]||""}:null},normalizePath:function(e){for(e=e.split("").reverse().join("").replace(r,"");e.length!==(e=e.replace(a,"")).length;);return e.split("").reverse().join("")},buildURLFromParts:function(e){return e.scheme+e.netLoc+e.path+e.params+e.query+e.fragment}},e.exports=s}(u={exports:{}},u.exports),u.exports),h="undefined"!=typeof window?window:void 0!==i?i:"undefined"!=typeof self?self:{},c=function(e,t){return/^[a-z]+:/i.test(t)?t:(/\/\//i.test(e)||(e=l.buildAbsoluteURL(h.location.href,e)),l.buildAbsoluteURL(e,t))},f=function(e,t,i){return e&&i.responseURL&&t!==i.responseURL?i.responseURL:t};
/*! @name m3u8-parser @version 4.3.0 @license Apache-2.0 */
function p(){return(p=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var i=arguments[t];for(var n in i)Object.prototype.hasOwnProperty.call(i,n)&&(e[n]=i[n])}return e}).apply(this,arguments)}function m(e,t){e.prototype=Object.create(t.prototype),e.prototype.constructor=e,e.__proto__=t}function g(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}var y=function(){function e(){this.listeners={}}var t=e.prototype;return t.on=function(e,t){this.listeners[e]||(this.listeners[e]=[]),this.listeners[e].push(t)},t.off=function(e,t){if(!this.listeners[e])return!1;var i=this.listeners[e].indexOf(t);return this.listeners[e].splice(i,1),i>-1},t.trigger=function(e){var t,i,n,r=this.listeners[e];if(r)if(2===arguments.length)for(i=r.length,t=0;t<i;++t)r[t].call(this,arguments[1]);else for(n=Array.prototype.slice.call(arguments,1),i=r.length,t=0;t<i;++t)r[t].apply(this,n)},t.dispose=function(){this.listeners={}},t.pipe=function(e){this.on("data",function(t){e.push(t)})},e}(),_=function(e){function t(){var t;return(t=e.call(this)||this).buffer="",t}return m(t,e),t.prototype.push=function(e){var t;for(this.buffer+=e,t=this.buffer.indexOf("\n");t>-1;t=this.buffer.indexOf("\n"))this.trigger("data",this.buffer.substring(0,t)),this.buffer=this.buffer.substring(t+1)},t}(y),v=function(e){for(var t,i=e.split(new RegExp('(?:^|,)((?:[^=]*)=(?:"[^"]*"|[^,]*))')),n={},r=i.length;r--;)""!==i[r]&&((t=/([^=]*)=(.*)/.exec(i[r]).slice(1))[0]=t[0].replace(/^\s+|\s+$/g,""),t[1]=t[1].replace(/^\s+|\s+$/g,""),t[1]=t[1].replace(/^['"](.*)['"]$/g,"$1"),n[t[0]]=t[1]);return n},b=function(e){function t(){var t;return(t=e.call(this)||this).customParsers=[],t.tagMappers=[],t}m(t,e);var i=t.prototype;return i.push=function(e){var t,i,n=this;0!==(e=e.trim()).length&&("#"===e[0]?this.tagMappers.reduce(function(t,i){var n=i(e);return n===e?t:t.concat([n])},[e]).forEach(function(e){for(var r=0;r<n.customParsers.length;r++)if(n.customParsers[r].call(n,e))return;if(0===e.indexOf("#EXT"))if(e=e.replace("\r",""),t=/^#EXTM3U/.exec(e))n.trigger("data",{type:"tag",tagType:"m3u"});else{if(t=/^#EXTINF:?([0-9\.]*)?,?(.*)?$/.exec(e))return i={type:"tag",tagType:"inf"},t[1]&&(i.duration=parseFloat(t[1])),t[2]&&(i.title=t[2]),void n.trigger("data",i);if(t=/^#EXT-X-TARGETDURATION:?([0-9.]*)?/.exec(e))return i={type:"tag",tagType:"targetduration"},t[1]&&(i.duration=parseInt(t[1],10)),void n.trigger("data",i);if(t=/^#ZEN-TOTAL-DURATION:?([0-9.]*)?/.exec(e))return i={type:"tag",tagType:"totalduration"},t[1]&&(i.duration=parseInt(t[1],10)),void n.trigger("data",i);if(t=/^#EXT-X-VERSION:?([0-9.]*)?/.exec(e))return i={type:"tag",tagType:"version"},t[1]&&(i.version=parseInt(t[1],10)),void n.trigger("data",i);if(t=/^#EXT-X-MEDIA-SEQUENCE:?(\-?[0-9.]*)?/.exec(e))return i={type:"tag",tagType:"media-sequence"},t[1]&&(i.number=parseInt(t[1],10)),void n.trigger("data",i);if(t=/^#EXT-X-DISCONTINUITY-SEQUENCE:?(\-?[0-9.]*)?/.exec(e))return i={type:"tag",tagType:"discontinuity-sequence"},t[1]&&(i.number=parseInt(t[1],10)),void n.trigger("data",i);if(t=/^#EXT-X-PLAYLIST-TYPE:?(.*)?$/.exec(e))return i={type:"tag",tagType:"playlist-type"},t[1]&&(i.playlistType=t[1]),void n.trigger("data",i);if(t=/^#EXT-X-BYTERANGE:?([0-9.]*)?@?([0-9.]*)?/.exec(e))return i={type:"tag",tagType:"byterange"},t[1]&&(i.length=parseInt(t[1],10)),t[2]&&(i.offset=parseInt(t[2],10)),void n.trigger("data",i);if(t=/^#EXT-X-ALLOW-CACHE:?(YES|NO)?/.exec(e))return i={type:"tag",tagType:"allow-cache"},t[1]&&(i.allowed=!/NO/.test(t[1])),void n.trigger("data",i);if(t=/^#EXT-X-MAP:?(.*)$/.exec(e)){if(i={type:"tag",tagType:"map"},t[1]){var a=v(t[1]);if(a.URI&&(i.uri=a.URI),a.BYTERANGE){var s=a.BYTERANGE.split("@"),o=s[0],u=s[1];i.byterange={},o&&(i.byterange.length=parseInt(o,10)),u&&(i.byterange.offset=parseInt(u,10))}}n.trigger("data",i)}else if(t=/^#EXT-X-STREAM-INF:?(.*)$/.exec(e)){if(i={type:"tag",tagType:"stream-inf"},t[1]){if(i.attributes=v(t[1]),i.attributes.RESOLUTION){var d=i.attributes.RESOLUTION.split("x"),l={};d[0]&&(l.width=parseInt(d[0],10)),d[1]&&(l.height=parseInt(d[1],10)),i.attributes.RESOLUTION=l}i.attributes.BANDWIDTH&&(i.attributes.BANDWIDTH=parseInt(i.attributes.BANDWIDTH,10)),i.attributes["PROGRAM-ID"]&&(i.attributes["PROGRAM-ID"]=parseInt(i.attributes["PROGRAM-ID"],10))}n.trigger("data",i)}else{if(t=/^#EXT-X-MEDIA:?(.*)$/.exec(e))return i={type:"tag",tagType:"media"},t[1]&&(i.attributes=v(t[1])),void n.trigger("data",i);if(t=/^#EXT-X-ENDLIST/.exec(e))n.trigger("data",{type:"tag",tagType:"endlist"});else if(t=/^#EXT-X-DISCONTINUITY/.exec(e))n.trigger("data",{type:"tag",tagType:"discontinuity"});else{if(t=/^#EXT-X-PROGRAM-DATE-TIME:?(.*)$/.exec(e))return i={type:"tag",tagType:"program-date-time"},t[1]&&(i.dateTimeString=t[1],i.dateTimeObject=new Date(t[1])),void n.trigger("data",i);if(t=/^#EXT-X-KEY:?(.*)$/.exec(e))return i={type:"tag",tagType:"key"},t[1]&&(i.attributes=v(t[1]),i.attributes.IV&&("0x"===i.attributes.IV.substring(0,2).toLowerCase()&&(i.attributes.IV=i.attributes.IV.substring(2)),i.attributes.IV=i.attributes.IV.match(/.{8}/g),i.attributes.IV[0]=parseInt(i.attributes.IV[0],16),i.attributes.IV[1]=parseInt(i.attributes.IV[1],16),i.attributes.IV[2]=parseInt(i.attributes.IV[2],16),i.attributes.IV[3]=parseInt(i.attributes.IV[3],16),i.attributes.IV=new Uint32Array(i.attributes.IV))),void n.trigger("data",i);if(t=/^#EXT-X-START:?(.*)$/.exec(e))return i={type:"tag",tagType:"start"},t[1]&&(i.attributes=v(t[1]),i.attributes["TIME-OFFSET"]=parseFloat(i.attributes["TIME-OFFSET"]),i.attributes.PRECISE=/YES/.test(i.attributes.PRECISE)),void n.trigger("data",i);if(t=/^#EXT-X-CUE-OUT-CONT:?(.*)?$/.exec(e))return i={type:"tag",tagType:"cue-out-cont"},t[1]?i.data=t[1]:i.data="",void n.trigger("data",i);if(t=/^#EXT-X-CUE-OUT:?(.*)?$/.exec(e))return i={type:"tag",tagType:"cue-out"},t[1]?i.data=t[1]:i.data="",void n.trigger("data",i);if(t=/^#EXT-X-CUE-IN:?(.*)?$/.exec(e))return i={type:"tag",tagType:"cue-in"},t[1]?i.data=t[1]:i.data="",void n.trigger("data",i);n.trigger("data",{type:"tag",data:e.slice(4)})}}}else n.trigger("data",{type:"comment",text:e.slice(1)})}):this.trigger("data",{type:"uri",uri:e}))},i.addParser=function(e){var t=this,i=e.expression,n=e.customType,r=e.dataParser,a=e.segment;"function"!=typeof r&&(r=function(e){return e}),this.customParsers.push(function(e){if(i.exec(e))return t.trigger("data",{type:"custom",data:r(e),customType:n,segment:a}),!0})},i.addTagMapper=function(e){var t=e.expression,i=e.map;this.tagMappers.push(function(e){return t.test(e)?i(e):e})},t}(y),T=function(e){function t(){var t;(t=e.call(this)||this).lineStream=new _,t.parseStream=new b,t.lineStream.pipe(t.parseStream);var i,n,r=g(g(t)),a=[],s={},o={AUDIO:{},VIDEO:{},"CLOSED-CAPTIONS":{},SUBTITLES:{}},u=0;return t.manifest={allowCache:!0,discontinuityStarts:[],segments:[]},t.parseStream.on("data",function(e){var t,d;({tag:function(){(({"allow-cache":function(){this.manifest.allowCache=e.allowed,"allowed"in e||(this.trigger("info",{message:"defaulting allowCache to YES"}),this.manifest.allowCache=!0)},byterange:function(){var t={};"length"in e&&(s.byterange=t,t.length=e.length,"offset"in e||(this.trigger("info",{message:"defaulting offset to zero"}),e.offset=0)),"offset"in e&&(s.byterange=t,t.offset=e.offset)},endlist:function(){this.manifest.endList=!0},inf:function(){"mediaSequence"in this.manifest||(this.manifest.mediaSequence=0,this.trigger("info",{message:"defaulting media sequence to zero"})),"discontinuitySequence"in this.manifest||(this.manifest.discontinuitySequence=0,this.trigger("info",{message:"defaulting discontinuity sequence to zero"})),e.duration>0&&(s.duration=e.duration),0===e.duration&&(s.duration=.01,this.trigger("info",{message:"updating zero segment duration to a small value"})),this.manifest.segments=a},key:function(){e.attributes?"NONE"!==e.attributes.METHOD?e.attributes.URI?(e.attributes.METHOD||this.trigger("warn",{message:"defaulting key method to AES-128"}),n={method:e.attributes.METHOD||"AES-128",uri:e.attributes.URI},void 0!==e.attributes.IV&&(n.iv=e.attributes.IV)):this.trigger("warn",{message:"ignoring key declaration without URI"}):n=null:this.trigger("warn",{message:"ignoring key declaration without attribute list"})},"media-sequence":function(){isFinite(e.number)?this.manifest.mediaSequence=e.number:this.trigger("warn",{message:"ignoring invalid media sequence: "+e.number})},"discontinuity-sequence":function(){isFinite(e.number)?(this.manifest.discontinuitySequence=e.number,u=e.number):this.trigger("warn",{message:"ignoring invalid discontinuity sequence: "+e.number})},"playlist-type":function(){/VOD|EVENT/.test(e.playlistType)?this.manifest.playlistType=e.playlistType:this.trigger("warn",{message:"ignoring unknown playlist type: "+e.playlist})},map:function(){i={},e.uri&&(i.uri=e.uri),e.byterange&&(i.byterange=e.byterange)},"stream-inf":function(){this.manifest.playlists=a,this.manifest.mediaGroups=this.manifest.mediaGroups||o,e.attributes?(s.attributes||(s.attributes={}),p(s.attributes,e.attributes)):this.trigger("warn",{message:"ignoring empty stream-inf attributes"})},media:function(){if(this.manifest.mediaGroups=this.manifest.mediaGroups||o,e.attributes&&e.attributes.TYPE&&e.attributes["GROUP-ID"]&&e.attributes.NAME){var i=this.manifest.mediaGroups[e.attributes.TYPE];i[e.attributes["GROUP-ID"]]=i[e.attributes["GROUP-ID"]]||{},t=i[e.attributes["GROUP-ID"]],(d={default:/yes/i.test(e.attributes.DEFAULT)}).default?d.autoselect=!0:d.autoselect=/yes/i.test(e.attributes.AUTOSELECT),e.attributes.LANGUAGE&&(d.language=e.attributes.LANGUAGE),e.attributes.URI&&(d.uri=e.attributes.URI),e.attributes["INSTREAM-ID"]&&(d.instreamId=e.attributes["INSTREAM-ID"]),e.attributes.CHARACTERISTICS&&(d.characteristics=e.attributes.CHARACTERISTICS),e.attributes.FORCED&&(d.forced=/yes/i.test(e.attributes.FORCED)),t[e.attributes.NAME]=d}else this.trigger("warn",{message:"ignoring incomplete or missing media group"})},discontinuity:function(){u+=1,s.discontinuity=!0,this.manifest.discontinuityStarts.push(a.length)},"program-date-time":function(){void 0===this.manifest.dateTimeString&&(this.manifest.dateTimeString=e.dateTimeString,this.manifest.dateTimeObject=e.dateTimeObject),s.dateTimeString=e.dateTimeString,s.dateTimeObject=e.dateTimeObject},targetduration:function(){!isFinite(e.duration)||e.duration<0?this.trigger("warn",{message:"ignoring invalid target duration: "+e.duration}):this.manifest.targetDuration=e.duration},totalduration:function(){!isFinite(e.duration)||e.duration<0?this.trigger("warn",{message:"ignoring invalid total duration: "+e.duration}):this.manifest.totalDuration=e.duration},start:function(){e.attributes&&!isNaN(e.attributes["TIME-OFFSET"])?this.manifest.start={timeOffset:e.attributes["TIME-OFFSET"],precise:e.attributes.PRECISE}:this.trigger("warn",{message:"ignoring start declaration without appropriate attribute list"})},"cue-out":function(){s.cueOut=e.data},"cue-out-cont":function(){s.cueOutCont=e.data},"cue-in":function(){s.cueIn=e.data}})[e.tagType]||function(){}).call(r)},uri:function(){s.uri=e.uri,a.push(s),!this.manifest.targetDuration||"duration"in s||(this.trigger("warn",{message:"defaulting segment duration to the target duration"}),s.duration=this.manifest.targetDuration),n&&(s.key=n),s.timeline=u,i&&(s.map=i),s={}},comment:function(){},custom:function(){e.segment?(s.custom=s.custom||{},s.custom[e.customType]=e.data):(this.manifest.custom=this.manifest.custom||{},this.manifest.custom[e.customType]=e.data)}})[e.type].call(r)}),t}m(t,e);var i=t.prototype;return i.push=function(e){this.lineStream.push(e)},i.end=function(){this.lineStream.push("\n")},i.addParser=function(e){this.parseStream.addParser(e)},i.addTagMapper=function(e){this.parseStream.addTagMapper(e)},t}(y),S=function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")},k=function(){function e(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}return function(t,i,n){return i&&e(t.prototype,i),n&&e(t,n),t}}(),w=function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t);e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)},U=function(e,t){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!t||"object"!=typeof t&&"function"!=typeof t?e:t},L=function(){return function(e,t){if(Array.isArray(e))return e;if(Symbol.iterator in Object(e))return function(e,t){var i=[],n=!0,r=!1,a=void 0;try{for(var s,o=e[Symbol.iterator]();!(n=(s=o.next()).done)&&(i.push(s.value),!t||i.length!==t);n=!0);}catch(e){r=!0,a=e}finally{try{!n&&o.return&&o.return()}finally{if(r)throw a}}return i}(e,t);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}(),A=t.mergeOptions,E=t.EventTarget,O=t.log,I=function(e,t){["AUDIO","SUBTITLES"].forEach(function(i){for(var n in e.mediaGroups[i])for(var r in e.mediaGroups[i][n]){var a=e.mediaGroups[i][n][r];t(a,i,n,r)}})},C=function(e,t){var i=A(e,{}),n=i.playlists[t.uri];if(!n)return null;if(n.segments&&t.segments&&n.segments.length===t.segments.length&&n.endList===t.endList&&n.mediaSequence===t.mediaSequence)return null;var r=A(n,t);n.segments&&(r.segments=function(e,t,i){var n=t.slice();i=i||0;for(var r=Math.min(e.length,t.length+i),a=i;a<r;a++)n[a-i]=A(e[a],n[a-i]);return n}(n.segments,t.segments,t.mediaSequence-n.mediaSequence)),r.segments.forEach(function(e){!function(e,t){e.resolvedUri||(e.resolvedUri=c(t,e.uri)),e.key&&!e.key.resolvedUri&&(e.key.resolvedUri=c(t,e.key.uri)),e.map&&!e.map.resolvedUri&&(e.map.resolvedUri=c(t,e.map.uri))}(e,r.resolvedUri)});for(var a=0;a<i.playlists.length;a++)i.playlists[a].uri===t.uri&&(i.playlists[a]=r);return i.playlists[t.uri]=r,i},P=function(e){for(var t=e.playlists.length;t--;){var i=e.playlists[t];e.playlists[i.uri]=i,i.resolvedUri=c(e.uri,i.uri),i.id=t,i.attributes||(i.attributes={},O.warn("Invalid playlist STREAM-INF detected. Missing BANDWIDTH attribute."))}},D=function(e){I(e,function(t){t.uri&&(t.resolvedUri=c(e.uri,t.uri))})},R=function(e,t){var i=e.segments[e.segments.length-1];return t&&i&&i.duration?1e3*i.duration:500*(e.targetDuration||10)},x=function(e){function t(e,i){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};S(this,t);var r=U(this,(t.__proto__||Object.getPrototypeOf(t)).call(this)),a=n.withCredentials,s=void 0!==a&&a,o=n.handleManifestRedirects,u=void 0!==o&&o;r.srcUrl=e,r.hls_=i,r.withCredentials=s,r.handleManifestRedirects=u;var d=i.options_;if(r.customTagParsers=d&&d.customTagParsers||[],r.customTagMappers=d&&d.customTagMappers||[],!r.srcUrl)throw new Error("A non-empty playlist URL is required");return r.state="HAVE_NOTHING",r.on("mediaupdatetimeout",function(){"HAVE_METADATA"===r.state&&(r.state="HAVE_CURRENT_METADATA",r.request=r.hls_.xhr({uri:c(r.master.uri,r.media().uri),withCredentials:r.withCredentials},function(e,t){if(r.request)return e?r.playlistRequestError(r.request,r.media().uri,"HAVE_METADATA"):void r.haveMetadata(r.request,r.media().uri)}))}),r}return w(t,E),k(t,[{key:"playlistRequestError",value:function(e,t,i){this.request=null,i&&(this.state=i),this.error={playlist:this.master.playlists[t],status:e.status,message:"HLS playlist request error at URL: "+t,responseText:e.responseText,code:e.status>=500?4:2},this.trigger("error")}},{key:"haveMetadata",value:function(e,t){var i=this;this.request=null,this.state="HAVE_METADATA";var n=new T;this.customTagParsers.forEach(function(e){return n.addParser(e)}),this.customTagMappers.forEach(function(e){return n.addTagMapper(e)}),n.push(e.responseText),n.end(),n.manifest.uri=t,n.manifest.attributes=n.manifest.attributes||{};var r=C(this.master,n.manifest);this.targetDuration=n.manifest.targetDuration,r?(this.master=r,this.media_=this.master.playlists[n.manifest.uri]):this.trigger("playlistunchanged"),this.media().endList||(h.clearTimeout(this.mediaUpdateTimeout),this.mediaUpdateTimeout=h.setTimeout(function(){i.trigger("mediaupdatetimeout")},R(this.media(),!!r))),this.trigger("loadedplaylist")}},{key:"dispose",value:function(){this.stopRequest(),h.clearTimeout(this.mediaUpdateTimeout)}},{key:"stopRequest",value:function(){if(this.request){var e=this.request;this.request=null,e.onreadystatechange=null,e.abort()}}},{key:"media",value:function(e){var t=this;if(!e)return this.media_;if("HAVE_NOTHING"===this.state)throw new Error("Cannot switch media playlist from "+this.state);var i=this.state;if("string"==typeof e){if(!this.master.playlists[e])throw new Error("Unknown playlist URI: "+e);e=this.master.playlists[e]}var n=!this.media_||e.uri!==this.media_.uri;if(this.master.playlists[e.uri].endList)return this.request&&(this.request.onreadystatechange=null,this.request.abort(),this.request=null),this.state="HAVE_METADATA",this.media_=e,void(n&&(this.trigger("mediachanging"),this.trigger("mediachange")));if(n){if(this.state="SWITCHING_MEDIA",this.request){if(e.resolvedUri===this.request.url)return;this.request.onreadystatechange=null,this.request.abort(),this.request=null}this.media_&&this.trigger("mediachanging"),this.request=this.hls_.xhr({uri:e.resolvedUri,withCredentials:this.withCredentials},function(n,r){if(t.request){if(e.resolvedUri=f(t.handleManifestRedirects,e.resolvedUri,r),n)return t.playlistRequestError(t.request,e.uri,i);t.haveMetadata(r,e.uri),"HAVE_MASTER"===i?t.trigger("loadedmetadata"):t.trigger("mediachange")}})}}},{key:"pause",value:function(){this.stopRequest(),h.clearTimeout(this.mediaUpdateTimeout),"HAVE_NOTHING"===this.state&&(this.started=!1),"SWITCHING_MEDIA"===this.state?this.media_?this.state="HAVE_METADATA":this.state="HAVE_MASTER":"HAVE_CURRENT_METADATA"===this.state&&(this.state="HAVE_METADATA")}},{key:"load",value:function(e){var t=this;h.clearTimeout(this.mediaUpdateTimeout);var i=this.media();if(e){var n=i?i.targetDuration/2*1e3:5e3;this.mediaUpdateTimeout=h.setTimeout(function(){return t.load()},n)}else this.started?i&&!i.endList?this.trigger("mediaupdatetimeout"):this.trigger("loadedplaylist"):this.start()}},{key:"start",value:function(){var e=this;this.started=!0,this.request=this.hls_.xhr({uri:this.srcUrl,withCredentials:this.withCredentials},function(t,i){if(e.request){if(e.request=null,t)return e.error={status:i.status,message:"HLS playlist request error at URL: "+e.srcUrl,responseText:i.responseText,code:2},"HAVE_NOTHING"===e.state&&(e.started=!1),e.trigger("error");var n=new T;return e.customTagParsers.forEach(function(e){return n.addParser(e)}),e.customTagMappers.forEach(function(e){return n.addTagMapper(e)}),n.push(i.responseText),n.end(),e.state="HAVE_MASTER",e.srcUrl=f(e.handleManifestRedirects,e.srcUrl,i),n.manifest.uri=e.srcUrl,n.manifest.playlists?(e.master=n.manifest,P(e.master),D(e.master),e.trigger("loadedplaylist"),void(e.request||e.media(n.manifest.playlists[0]))):(e.master={mediaGroups:{AUDIO:{},VIDEO:{},"CLOSED-CAPTIONS":{},SUBTITLES:{}},uri:h.location.href,playlists:[{uri:e.srcUrl,id:0,resolvedUri:e.srcUrl,attributes:{}}]},e.master.playlists[e.srcUrl]=e.master.playlists[0],e.haveMetadata(i,e.srcUrl),e.trigger("loadedmetadata"))}})}}]),t}(),M=t.createTimeRange,B=function(e,t,i){var n,r;return void 0===t&&(t=e.mediaSequence+e.segments.length),t<e.mediaSequence?0:(n=function(e,t){var i=0,n=t-e.mediaSequence,r=e.segments[n];if(r){if(void 0!==r.start)return{result:r.start,precise:!0};if(void 0!==r.end)return{result:r.end-r.duration,precise:!0}}for(;n--;){if(void 0!==(r=e.segments[n]).end)return{result:i+r.end,precise:!0};if(i+=r.duration,void 0!==r.start)return{result:i+r.start,precise:!0}}return{result:i,precise:!1}}(e,t)).precise?n.result:(r=function(e,t){for(var i=0,n=void 0,r=t-e.mediaSequence;r<e.segments.length;r++){if(void 0!==(n=e.segments[r]).start)return{result:n.start-i,precise:!0};if(i+=n.duration,void 0!==n.end)return{result:n.end-i,precise:!0}}return{result:-1,precise:!1}}(e,t)).precise?r.result:n.result+i},N=function(e,t,i){if(!e)return 0;if("number"!=typeof i&&(i=0),void 0===t){if(e.totalDuration)return e.totalDuration;if(!e.endList)return h.Infinity}return B(e,t,i)},q=function(e,t,i){var n=0;if(t>i){var r=[i,t];t=r[0],i=r[1]}if(t<0){for(var a=t;a<Math.min(0,i);a++)n+=e.targetDuration;t=0}for(var s=t;s<i;s++)n+=e.segments[s].duration;return n},F=function(e){if(!e.segments.length)return 0;for(var t=e.segments.length-1,i=e.segments[t].duration||e.targetDuration,n=i+2*e.targetDuration;t--&&!((i+=e.segments[t].duration)>=n););return Math.max(0,t)},G=function(e,t,i){if(!e||!e.segments)return null;if(e.endList)return N(e);if(null===t)return null;t=t||0;var n=i?F(e):e.segments.length;return B(e,e.mediaSequence+n,t)},V=function(e){return e-Math.floor(e)==0},H=function(e,t){if(V(t))return t+.1*e;for(var i=t.toString().split(".")[1].length,n=1;n<=i;n++){var r=Math.pow(10,n),a=t*r;if(V(a)||n===i)return(a+e)/r}},j=H.bind(null,1),z=H.bind(null,-1),W=function(e){return e.excludeUntil&&e.excludeUntil>Date.now()},X=function(e){return e.excludeUntil&&e.excludeUntil===1/0},Y=function(e){var t=W(e);return!e.disabled&&!t},$=function(e,t){return t.attributes&&t.attributes[e]},K=function(e,t){if(1===e.playlists.length)return!0;var i=t.attributes.BANDWIDTH||Number.MAX_VALUE;return 0===e.playlists.filter(function(e){return!!Y(e)&&(e.attributes.BANDWIDTH||0)<i}).length},Q={duration:N,seekable:function(e,t){var i=t||0,n=G(e,t,!0);return null===n?M():M(i,n)},safeLiveIndex:F,getMediaInfoForTime:function(e,t,i,n){var r=void 0,a=void 0,s=e.segments.length,o=t-n;if(o<0){if(i>0)for(r=i-1;r>=0;r--)if(a=e.segments[r],(o+=z(a.duration))>0)return{mediaIndex:r,startTime:n-q(e,i,r)};return{mediaIndex:0,startTime:t}}if(i<0){for(r=i;r<0;r++)if((o-=e.targetDuration)<0)return{mediaIndex:0,startTime:t};i=0}for(r=i;r<s;r++)if(a=e.segments[r],(o-=j(a.duration))<0)return{mediaIndex:r,startTime:n+q(e,i,r)};return{mediaIndex:s-1,startTime:t}},isEnabled:Y,isDisabled:function(e){return e.disabled},isBlacklisted:W,isIncompatible:X,playlistEnd:G,isAes:function(e){for(var t=0;t<e.segments.length;t++)if(e.segments[t].key)return!0;return!1},isFmp4:function(e){for(var t=0;t<e.segments.length;t++)if(e.segments[t].map)return!0;return!1},hasAttribute:$,estimateSegmentRequestTime:function(e,t,i){var n=arguments.length>3&&void 0!==arguments[3]?arguments[3]:0;return $("BANDWIDTH",i)?(e*i.attributes.BANDWIDTH-8*n)/t:NaN},isLowestEnabledRendition:K},Z=t.xhr,J=t.mergeOptions,ee=function(){return function e(i,n){i=J({timeout:45e3},i);var r=e.beforeRequest||t.Hls.xhr.beforeRequest;if(r&&"function"==typeof r){var a=r(i);a&&(i=a)}var s=Z(i,function(e,t){var i=s.response;!e&&i&&(s.responseTime=Date.now(),s.roundTripTime=s.responseTime-s.requestTime,s.bytesReceived=i.byteLength||i.length,s.bandwidth||(s.bandwidth=Math.floor(s.bytesReceived/s.roundTripTime*8*1e3))),t.headers&&(s.responseHeaders=t.headers),e&&"ETIMEDOUT"===e.code&&(s.timedout=!0),e||s.aborted||200===t.statusCode||206===t.statusCode||0===t.statusCode||(e=new Error("XHR Failed with a response of: "+(s&&(i||s.responseText)))),n(e,s)}),o=s.abort;return s.abort=function(){return s.aborted=!0,o.apply(s,arguments)},s.uri=i.uri,s.requestTime=Date.now(),s}};var te=function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")},ie=function(){function e(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}return function(t,i,n){return i&&e(t.prototype,i),n&&e(t,n),t}}(),ne=function(e,t){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!t||"object"!=typeof t&&"function"!=typeof t?e:t},re=function(){var e=[[[],[],[],[],[]],[[],[],[],[],[]]],t=e[0],i=e[1],n=t[4],r=i[4],a=void 0,s=void 0,o=void 0,u=[],d=[],l=void 0,h=void 0,c=void 0,f=void 0,p=void 0;for(a=0;a<256;a++)d[(u[a]=a<<1^283*(a>>7))^a]=a;for(s=o=0;!n[s];s^=l||1,o=d[o]||1)for(c=(c=o^o<<1^o<<2^o<<3^o<<4)>>8^255&c^99,n[s]=c,r[c]=s,p=16843009*u[h=u[l=u[s]]]^65537*h^257*l^16843008*s,f=257*u[c]^16843008*c,a=0;a<4;a++)t[a][s]=f=f<<24^f>>>8,i[a][c]=p=p<<24^p>>>8;for(a=0;a<5;a++)t[a]=t[a].slice(0),i[a]=i[a].slice(0);return e},ae=null,se=function(){function e(t){te(this,e),ae||(ae=re()),this._tables=[[ae[0][0].slice(),ae[0][1].slice(),ae[0][2].slice(),ae[0][3].slice(),ae[0][4].slice()],[ae[1][0].slice(),ae[1][1].slice(),ae[1][2].slice(),ae[1][3].slice(),ae[1][4].slice()]];var i=void 0,n=void 0,r=void 0,a=void 0,s=void 0,o=this._tables[0][4],u=this._tables[1],d=t.length,l=1;if(4!==d&&6!==d&&8!==d)throw new Error("Invalid aes key size");for(a=t.slice(0),s=[],this._key=[a,s],i=d;i<4*d+28;i++)r=a[i-1],(i%d==0||8===d&&i%d==4)&&(r=o[r>>>24]<<24^o[r>>16&255]<<16^o[r>>8&255]<<8^o[255&r],i%d==0&&(r=r<<8^r>>>24^l<<24,l=l<<1^283*(l>>7))),a[i]=a[i-d]^r;for(n=0;i;n++,i--)r=a[3&n?i:i-4],s[n]=i<=4||n<4?r:u[0][o[r>>>24]]^u[1][o[r>>16&255]]^u[2][o[r>>8&255]]^u[3][o[255&r]]}return e.prototype.decrypt=function(e,t,i,n,r,a){var s=this._key[1],o=e^s[0],u=n^s[1],d=i^s[2],l=t^s[3],h=void 0,c=void 0,f=void 0,p=s.length/4-2,m=void 0,g=4,y=this._tables[1],_=y[0],v=y[1],b=y[2],T=y[3],S=y[4];for(m=0;m<p;m++)h=_[o>>>24]^v[u>>16&255]^b[d>>8&255]^T[255&l]^s[g],c=_[u>>>24]^v[d>>16&255]^b[l>>8&255]^T[255&o]^s[g+1],f=_[d>>>24]^v[l>>16&255]^b[o>>8&255]^T[255&u]^s[g+2],l=_[l>>>24]^v[o>>16&255]^b[u>>8&255]^T[255&d]^s[g+3],g+=4,o=h,u=c,d=f;for(m=0;m<4;m++)r[(3&-m)+a]=S[o>>>24]<<24^S[u>>16&255]<<16^S[d>>8&255]<<8^S[255&l]^s[g++],h=o,o=u,u=d,d=l,l=h},e}(),oe=function(){function e(){te(this,e),this.listeners={}}return e.prototype.on=function(e,t){this.listeners[e]||(this.listeners[e]=[]),this.listeners[e].push(t)},e.prototype.off=function(e,t){if(!this.listeners[e])return!1;var i=this.listeners[e].indexOf(t);return this.listeners[e].splice(i,1),i>-1},e.prototype.trigger=function(e){var t=this.listeners[e];if(t)if(2===arguments.length)for(var i=t.length,n=0;n<i;++n)t[n].call(this,arguments[1]);else for(var r=Array.prototype.slice.call(arguments,1),a=t.length,s=0;s<a;++s)t[s].apply(this,r)},e.prototype.dispose=function(){this.listeners={}},e.prototype.pipe=function(e){this.on("data",function(t){e.push(t)})},e}(),ue=function(e){function t(){te(this,t);var i=ne(this,e.call(this,oe));return i.jobs=[],i.delay=1,i.timeout_=null,i}return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t);e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)}(t,e),t.prototype.processJob_=function(){this.jobs.shift()(),this.jobs.length?this.timeout_=setTimeout(this.processJob_.bind(this),this.delay):this.timeout_=null},t.prototype.push=function(e){this.jobs.push(e),this.timeout_||(this.timeout_=setTimeout(this.processJob_.bind(this),this.delay))},t}(oe),de=function(e){return e<<24|(65280&e)<<8|(16711680&e)>>8|e>>>24},le=function(e,t,i){var n=new Int32Array(e.buffer,e.byteOffset,e.byteLength>>2),r=new se(Array.prototype.slice.call(t)),a=new Uint8Array(e.byteLength),s=new Int32Array(a.buffer),o=void 0,u=void 0,d=void 0,l=void 0,h=void 0,c=void 0,f=void 0,p=void 0,m=void 0;for(o=i[0],u=i[1],d=i[2],l=i[3],m=0;m<n.length;m+=4)h=de(n[m]),c=de(n[m+1]),f=de(n[m+2]),p=de(n[m+3]),r.decrypt(h,c,f,p,s,m),s[m]=de(s[m]^o),s[m+1]=de(s[m+1]^u),s[m+2]=de(s[m+2]^d),s[m+3]=de(s[m+3]^l),o=h,u=c,d=f,l=p;return a},he=function(){function e(t,i,n,r){te(this,e);var a=e.STEP,s=new Int32Array(t.buffer),o=new Uint8Array(t.byteLength),u=0;for(this.asyncStream_=new ue,this.asyncStream_.push(this.decryptChunk_(s.subarray(u,u+a),i,n,o)),u=a;u<s.length;u+=a)n=new Uint32Array([de(s[u-4]),de(s[u-3]),de(s[u-2]),de(s[u-1])]),this.asyncStream_.push(this.decryptChunk_(s.subarray(u,u+a),i,n,o));this.asyncStream_.push(function(){var e;r(null,(e=o).subarray(0,e.byteLength-e[e.byteLength-1]))})}return e.prototype.decryptChunk_=function(e,t,i,n){return function(){var r=le(e,t,i);n.set(r,e.byteOffset)}},ie(e,null,[{key:"STEP",get:function(){return 32e3}}]),e}(),ce=function(e,t){return e.start(t)+"-"+e.end(t)},fe=function(e,t){var i=e.toString(16);return"00".substring(0,2-i.length)+i+(t%2?" ":"")},pe=function(e){return e>=32&&e<126?String.fromCharCode(e):"."},me=function(e){var t={};return Object.keys(e).forEach(function(i){var n=e[i];ArrayBuffer.isView(n)?t[i]={bytes:n.buffer,byteOffset:n.byteOffset,byteLength:n.byteLength}:t[i]=n}),t},ge=function(e){var t=e.byterange||{length:1/0,offset:0};return[t.length,t.offset,e.resolvedUri].join(",")},ye=function(e){for(var t=Array.prototype.slice.call(e),i="",n=0;n<t.length/16;n++)i+=t.slice(16*n,16*n+16).map(fe).join("")+" "+t.slice(16*n,16*n+16).map(pe).join("")+"\n";return i},_e=Object.freeze({createTransferableMessage:me,initSegmentId:ge,hexDump:ye,tagDump:function(e){var t=e.bytes;return ye(t)},textRanges:function(e){var t="",i=void 0;for(i=0;i<e.length;i++)t+=ce(e,i)+" ";return t}}),ve=function(e){var t=e.playlist,i=e.time,n=void 0===i?void 0:i,r=e.callback;if(!r)throw new Error("getProgramTime: callback must be provided");if(!t||void 0===n)return r({message:"getProgramTime: playlist and time must be provided"});var a=function(e,t){if(!t||!t.segments||0===t.segments.length)return null;for(var i=0,n=void 0,r=0;r<t.segments.length&&!(e<=(i=(n=t.segments[r]).videoTimingInfo?n.videoTimingInfo.transmuxedPresentationEnd:i+n.duration));r++);var a=t.segments[t.segments.length-1];if(a.videoTimingInfo&&a.videoTimingInfo.transmuxedPresentationEnd<e)return null;if(e>i){if(e>i+.25*a.duration)return null;n=a}return{segment:n,estimatedStart:n.videoTimingInfo?n.videoTimingInfo.transmuxedPresentationStart:i-n.duration,type:n.videoTimingInfo?"accurate":"estimate"}}(n,t);if(!a)return r({message:"valid programTime was not found"});if("estimate"===a.type)return r({message:"Accurate programTime could not be determined. Please seek to e.seekTime and try again",seekTime:a.estimatedStart});var s={mediaSeconds:n},o=function(e,t){if(!t.dateTimeObject)return null;var i=t.videoTimingInfo.transmuxerPrependedSeconds,n=e-(t.videoTimingInfo.transmuxedPresentationStart+i);return new Date(t.dateTimeObject.getTime()+1e3*n)}(n,a.segment);return o&&(s.programDateTime=o.toISOString()),r(null,s)},be=function e(t){var i=t.programTime,n=t.playlist,r=t.retryCount,a=void 0===r?2:r,s=t.seekTo,o=t.pauseAfterSeek,u=void 0===o||o,d=t.tech,l=t.callback;if(!l)throw new Error("seekToProgramTime: callback must be provided");if(void 0===i||!n||!s)return l({message:"seekToProgramTime: programTime, seekTo and playlist must be provided"});if(!n.endList&&!d.hasStarted_)return l({message:"player must be playing a live stream to start buffering"});if(!function(e){if(!e.segments||0===e.segments.length)return!1;for(var t=0;t<e.segments.length;t++)if(!e.segments[t].dateTimeObject)return!1;return!0}(n))return l({message:"programDateTime tags must be provided in the manifest "+n.resolvedUri});var h=function(e,t){var i=void 0;try{i=new Date(e)}catch(e){return null}if(!t||!t.segments||0===t.segments.length)return null;var n=t.segments[0];if(i<n.dateTimeObject)return null;for(var r=0;r<t.segments.length-1&&(n=t.segments[r],!(i<t.segments[r+1].dateTimeObject));r++);var a,s=t.segments[t.segments.length-1],o=s.dateTimeObject,u=s.videoTimingInfo?(a=s.videoTimingInfo).transmuxedPresentationEnd-a.transmuxedPresentationStart-a.transmuxerPrependedSeconds:s.duration+.25*s.duration;return i>new Date(o.getTime()+1e3*u)?null:(i>o&&(n=s),{segment:n,estimatedStart:n.videoTimingInfo?n.videoTimingInfo.transmuxedPresentationStart:Q.duration(t,t.mediaSequence+t.segments.indexOf(n)),type:n.videoTimingInfo?"accurate":"estimate"})}(i,n);if(!h)return l({message:i+" was not found in the stream"});var c=h.segment,f=function(e,t){var i=void 0,n=void 0;try{i=new Date(e),n=new Date(t)}catch(e){}var r=i.getTime();return(n.getTime()-r)/1e3}(c.dateTimeObject,i);if("estimate"===h.type)return 0===a?l({message:i+" is not buffered yet. Try again"}):(s(h.estimatedStart+f),void d.one("seeked",function(){e({programTime:i,playlist:n,retryCount:a-1,seekTo:s,pauseAfterSeek:u,tech:d,callback:l})}));var p=c.start+f;d.one("seeked",function(){return l(null,d.currentTime())}),u&&d.pause(),s(p)},Te=function(e,i){var n=[],r=void 0;if(e&&e.length)for(r=0;r<e.length;r++)i(e.start(r),e.end(r))&&n.push([e.start(r),e.end(r)]);return t.createTimeRanges(n)},Se=function(e,t){return Te(e,function(e,i){return e-1/30<=t&&i+1/30>=t})},ke=function(e,t){return Te(e,function(e){return e-1/30>=t})},we=function(e){var t=[];if(!e||!e.length)return"";for(var i=0;i<e.length;i++)t.push(e.start(i)+" => "+e.end(i));return t.join(", ")},Ue=function(e){for(var t=[],i=0;i<e.length;i++)t.push({start:e.start(i),end:e.end(i)});return t},Le=function(e,t,i){var n=void 0,r=void 0;if(i&&i.cues)for(n=i.cues.length;n--;)(r=i.cues[n]).startTime<=t&&r.endTime>=e&&i.removeCue(r)},Ae=function(e){return isNaN(e)||Math.abs(e)===1/0?Number.MAX_VALUE:e},Ee=function(e,i,n){var r=h.WebKitDataCue||h.VTTCue;if(i&&i.forEach(function(e){var t=e.stream;this.inbandTextTracks_[t].addCue(new r(e.startTime+this.timestampOffset,e.endTime+this.timestampOffset,e.text))},e),n){var a=Ae(e.mediaSource_.duration);if(n.forEach(function(e){var i=e.cueTime+this.timestampOffset;!("number"!=typeof i||h.isNaN(i)||i<0)&&i<1/0&&e.frames.forEach(function(e){var n=new r(i,i,e.value||e.url||e.data||"");n.frame=e,n.value=e,function(e){Object.defineProperties(e.frame,{id:{get:function(){return t.log.warn("cue.frame.id is deprecated. Use cue.value.key instead."),e.value.key}},value:{get:function(){return t.log.warn("cue.frame.value is deprecated. Use cue.value.data instead."),e.value.data}},privateData:{get:function(){return t.log.warn("cue.frame.privateData is deprecated. Use cue.value.data instead."),e.value.data}}})}(n),this.metadataTrack_.addCue(n)},this)},e),e.metadataTrack_&&e.metadataTrack_.cues&&e.metadataTrack_.cues.length){for(var s=e.metadataTrack_.cues,o=[],u=0;u<s.length;u++)s[u]&&o.push(s[u]);var d=o.reduce(function(e,t){var i=e[t.startTime]||[];return i.push(t),e[t.startTime]=i,e},{}),l=Object.keys(d).sort(function(e,t){return Number(e)-Number(t)});l.forEach(function(e,t){var i=d[e],n=Number(l[t+1])||a;i.forEach(function(e){e.endTime=n})})}}},Oe="undefined"!=typeof window?window:{},Ie="undefined"==typeof Symbol?"__target":Symbol(),Ce="application/javascript",Pe=Oe.BlobBuilder||Oe.WebKitBlobBuilder||Oe.MozBlobBuilder||Oe.MSBlobBuilder,De=Oe.URL||Oe.webkitURL||De&&De.msURL,Re=Oe.Worker;function xe(e,t){return function(i){var n=this;if(!t)return new Re(e);if(Re&&!i){var r=qe(t.toString().replace(/^function.+?{/,"").slice(0,-1));return this[Ie]=new Re(r),function(e,t){if(!e||!t)return;var i=e.terminate;e.objURL=t,e.terminate=function(){e.objURL&&De.revokeObjectURL(e.objURL),i.call(e)}}(this[Ie],r),this[Ie]}var a={postMessage:function(e){n.onmessage&&setTimeout(function(){n.onmessage({data:e,target:a})})}};t.call(a),this.postMessage=function(e){setTimeout(function(){a.onmessage({data:e,target:n})})},this.isThisThread=!0}}if(Re){var Me,Be=qe("self.onmessage = function () {}"),Ne=new Uint8Array(1);try{(Me=new Re(Be)).postMessage(Ne,[Ne.buffer])}catch(e){Re=null}finally{De.revokeObjectURL(Be),Me&&Me.terminate()}}function qe(e){try{return De.createObjectURL(new Blob([e],{type:Ce}))}catch(i){var t=new Pe;return t.append(e),De.createObjectURL(t.getBlob(type))}}var Fe=new xe("./transmuxer-worker.worker.js",function(e,t){var i=this;!function(){var e,t,n,r,a,s,o,u,d,l,h,c,f,p,m,g,y,_,v,b,T,S,k,w,U,L,A,E,O,I,C,P,D,R,x,M,B,N,q,F,G=Math.pow(2,32)-1;!function(){var e;if(S={avc1:[],avcC:[],btrt:[],dinf:[],dref:[],esds:[],ftyp:[],hdlr:[],mdat:[],mdhd:[],mdia:[],mfhd:[],minf:[],moof:[],moov:[],mp4a:[],mvex:[],mvhd:[],sdtp:[],smhd:[],stbl:[],stco:[],stsc:[],stsd:[],stsz:[],stts:[],styp:[],tfdt:[],tfhd:[],traf:[],trak:[],trun:[],trex:[],tkhd:[],vmhd:[]},"undefined"!=typeof Uint8Array){for(e in S)S.hasOwnProperty(e)&&(S[e]=[e.charCodeAt(0),e.charCodeAt(1),e.charCodeAt(2),e.charCodeAt(3)]);k=new Uint8Array(["i".charCodeAt(0),"s".charCodeAt(0),"o".charCodeAt(0),"m".charCodeAt(0)]),U=new Uint8Array(["a".charCodeAt(0),"v".charCodeAt(0),"c".charCodeAt(0),"1".charCodeAt(0)]),w=new Uint8Array([0,0,0,1]),L=new Uint8Array([0,0,0,0,0,0,0,0,118,105,100,101,0,0,0,0,0,0,0,0,0,0,0,0,86,105,100,101,111,72,97,110,100,108,101,114,0]),A=new Uint8Array([0,0,0,0,0,0,0,0,115,111,117,110,0,0,0,0,0,0,0,0,0,0,0,0,83,111,117,110,100,72,97,110,100,108,101,114,0]),E={video:L,audio:A},C=new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,12,117,114,108,32,0,0,0,1]),I=new Uint8Array([0,0,0,0,0,0,0,0]),P=new Uint8Array([0,0,0,0,0,0,0,0]),D=P,R=new Uint8Array([0,0,0,0,0,0,0,0,0,0,0,0]),x=P,O=new Uint8Array([0,0,0,1,0,0,0,0,0,0,0,0])}}(),e=function(e){var t,i,n=[],r=0;for(t=1;t<arguments.length;t++)n.push(arguments[t]);for(t=n.length;t--;)r+=n[t].byteLength;for(i=new Uint8Array(r+8),new DataView(i.buffer,i.byteOffset,i.byteLength).setUint32(0,i.byteLength),i.set(e,4),t=0,r=8;t<n.length;t++)i.set(n[t],r),r+=n[t].byteLength;return i},t=function(){return e(S.dinf,e(S.dref,C))},n=function(t){return e(S.esds,new Uint8Array([0,0,0,0,3,25,0,0,0,4,17,64,21,0,6,0,0,0,218,192,0,0,218,192,5,2,t.audioobjecttype<<3|t.samplingfrequencyindex>>>1,t.samplingfrequencyindex<<7|t.channelcount<<3,6,1,2]))},m=function(t){return e(S.hdlr,E[t])},p=function(t){var i=new Uint8Array([0,0,0,0,0,0,0,2,0,0,0,3,0,1,95,144,t.duration>>>24&255,t.duration>>>16&255,t.duration>>>8&255,255&t.duration,85,196,0,0]);return t.samplerate&&(i[12]=t.samplerate>>>24&255,i[13]=t.samplerate>>>16&255,i[14]=t.samplerate>>>8&255,i[15]=255&t.samplerate),e(S.mdhd,i)},f=function(t){return e(S.mdia,p(t),m(t.type),s(t))},a=function(t){return e(S.mfhd,new Uint8Array([0,0,0,0,(4278190080&t)>>24,(16711680&t)>>16,(65280&t)>>8,255&t]))},s=function(i){return e(S.minf,"video"===i.type?e(S.vmhd,O):e(S.smhd,I),t(),y(i))},o=function(t,i){for(var n=[],r=i.length;r--;)n[r]=v(i[r]);return e.apply(null,[S.moof,a(t)].concat(n))},u=function(t){for(var i=t.length,n=[];i--;)n[i]=h(t[i]);return e.apply(null,[S.moov,l(4294967295)].concat(n).concat(d(t)))},d=function(t){for(var i=t.length,n=[];i--;)n[i]=b(t[i]);return e.apply(null,[S.mvex].concat(n))},l=function(t){var i=new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,2,0,1,95,144,(4278190080&t)>>24,(16711680&t)>>16,(65280&t)>>8,255&t,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255]);return e(S.mvhd,i)},g=function(t){var i,n,r=t.samples||[],a=new Uint8Array(4+r.length);for(n=0;n<r.length;n++)i=r[n].flags,a[n+4]=i.dependsOn<<4|i.isDependedOn<<2|i.hasRedundancy;return e(S.sdtp,a)},y=function(t){return e(S.stbl,_(t),e(S.stts,x),e(S.stsc,D),e(S.stsz,R),e(S.stco,P))},_=function(t){return e(S.stsd,new Uint8Array([0,0,0,0,0,0,0,1]),"video"===t.type?M(t):B(t))},M=function(t){var i,n=t.sps||[],r=t.pps||[],a=[],s=[];for(i=0;i<n.length;i++)a.push((65280&n[i].byteLength)>>>8),a.push(255&n[i].byteLength),a=a.concat(Array.prototype.slice.call(n[i]));for(i=0;i<r.length;i++)s.push((65280&r[i].byteLength)>>>8),s.push(255&r[i].byteLength),s=s.concat(Array.prototype.slice.call(r[i]));return e(S.avc1,new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,(65280&t.width)>>8,255&t.width,(65280&t.height)>>8,255&t.height,0,72,0,0,0,72,0,0,0,0,0,0,0,1,19,118,105,100,101,111,106,115,45,99,111,110,116,114,105,98,45,104,108,115,0,0,0,0,0,0,0,0,0,0,0,0,0,24,17,17]),e(S.avcC,new Uint8Array([1,t.profileIdc,t.profileCompatibility,t.levelIdc,255].concat([n.length]).concat(a).concat([r.length]).concat(s))),e(S.btrt,new Uint8Array([0,28,156,128,0,45,198,192,0,45,198,192])))},B=function(t){return e(S.mp4a,new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,(65280&t.channelcount)>>8,255&t.channelcount,(65280&t.samplesize)>>8,255&t.samplesize,0,0,0,0,(65280&t.samplerate)>>8,255&t.samplerate,0,0]),n(t))},c=function(t){var i=new Uint8Array([0,0,0,7,0,0,0,0,0,0,0,0,(4278190080&t.id)>>24,(16711680&t.id)>>16,(65280&t.id)>>8,255&t.id,0,0,0,0,(4278190080&t.duration)>>24,(16711680&t.duration)>>16,(65280&t.duration)>>8,255&t.duration,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,(65280&t.width)>>8,255&t.width,0,0,(65280&t.height)>>8,255&t.height,0,0]);return e(S.tkhd,i)},v=function(t){var i,n,r,a,s,o;return i=e(S.tfhd,new Uint8Array([0,0,0,58,(4278190080&t.id)>>24,(16711680&t.id)>>16,(65280&t.id)>>8,255&t.id,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0])),s=Math.floor(t.baseMediaDecodeTime/(G+1)),o=Math.floor(t.baseMediaDecodeTime%(G+1)),n=e(S.tfdt,new Uint8Array([1,0,0,0,s>>>24&255,s>>>16&255,s>>>8&255,255&s,o>>>24&255,o>>>16&255,o>>>8&255,255&o])),92,"audio"===t.type?(r=T(t,92),e(S.traf,i,n,r)):(a=g(t),r=T(t,a.length+92),e(S.traf,i,n,r,a))},h=function(t){return t.duration=t.duration||4294967295,e(S.trak,c(t),f(t))},b=function(t){var i=new Uint8Array([0,0,0,0,(4278190080&t.id)>>24,(16711680&t.id)>>16,(65280&t.id)>>8,255&t.id,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,1]);return"video"!==t.type&&(i[i.length-1]=0),e(S.trex,i)},F=function(e,t){var i=0,n=0,r=0,a=0;return e.length&&(void 0!==e[0].duration&&(i=1),void 0!==e[0].size&&(n=2),void 0!==e[0].flags&&(r=4),void 0!==e[0].compositionTimeOffset&&(a=8)),[0,0,i|n|r|a,1,(4278190080&e.length)>>>24,(16711680&e.length)>>>16,(65280&e.length)>>>8,255&e.length,(4278190080&t)>>>24,(16711680&t)>>>16,(65280&t)>>>8,255&t]},q=function(t,i){var n,r,a,s;for(i+=20+16*(r=t.samples||[]).length,n=F(r,i),s=0;s<r.length;s++)a=r[s],n=n.concat([(4278190080&a.duration)>>>24,(16711680&a.duration)>>>16,(65280&a.duration)>>>8,255&a.duration,(4278190080&a.size)>>>24,(16711680&a.size)>>>16,(65280&a.size)>>>8,255&a.size,a.flags.isLeading<<2|a.flags.dependsOn,a.flags.isDependedOn<<6|a.flags.hasRedundancy<<4|a.flags.paddingValue<<1|a.flags.isNonSyncSample,61440&a.flags.degradationPriority,15&a.flags.degradationPriority,(4278190080&a.compositionTimeOffset)>>>24,(16711680&a.compositionTimeOffset)>>>16,(65280&a.compositionTimeOffset)>>>8,255&a.compositionTimeOffset]);return e(S.trun,new Uint8Array(n))},N=function(t,i){var n,r,a,s;for(i+=20+8*(r=t.samples||[]).length,n=F(r,i),s=0;s<r.length;s++)a=r[s],n=n.concat([(4278190080&a.duration)>>>24,(16711680&a.duration)>>>16,(65280&a.duration)>>>8,255&a.duration,(4278190080&a.size)>>>24,(16711680&a.size)>>>16,(65280&a.size)>>>8,255&a.size]);return e(S.trun,new Uint8Array(n))},T=function(e,t){return"audio"===e.type?N(e,t):q(e,t)};var V,H,j={ftyp:r=function(){return e(S.ftyp,k,w,k,U)},mdat:function(t){return e(S.mdat,t)},moof:o,moov:u,initSegment:function(e){var t,i=r(),n=u(e);return(t=new Uint8Array(i.byteLength+n.byteLength)).set(i),t.set(n,i.byteLength),t}},z=function(e){return e>>>0},W={findBox:V=function(e,t){var i,n,r,a,s,o=[];if(!t.length)return null;for(i=0;i<e.byteLength;)n=z(e[i]<<24|e[i+1]<<16|e[i+2]<<8|e[i+3]),r=H(e.subarray(i+4,i+8)),a=n>1?i+n:e.byteLength,r===t[0]&&(1===t.length?o.push(e.subarray(i+8,a)):(s=V(e.subarray(i+8,a),t.slice(1))).length&&(o=o.concat(s))),i=a;return o},parseType:H=function(e){var t="";return t+=String.fromCharCode(e[0]),t+=String.fromCharCode(e[1]),t+=String.fromCharCode(e[2]),t+=String.fromCharCode(e[3])},timescale:function(e){return V(e,["moov","trak"]).reduce(function(e,t){var i,n,r,a,s;return(i=V(t,["tkhd"])[0])?(n=i[0],a=z(i[r=0===n?12:20]<<24|i[r+1]<<16|i[r+2]<<8|i[r+3]),(s=V(t,["mdia","mdhd"])[0])?(r=0===(n=s[0])?12:20,e[a]=z(s[r]<<24|s[r+1]<<16|s[r+2]<<8|s[r+3]),e):null):null},{})},startTime:function(e,t){var i,n,r;return i=V(t,["moof","traf"]),n=[].concat.apply([],i.map(function(t){return V(t,["tfhd"]).map(function(i){var n,r;return n=z(i[4]<<24|i[5]<<16|i[6]<<8|i[7]),r=e[n]||9e4,(V(t,["tfdt"]).map(function(e){var t,i;return t=e[0],i=z(e[4]<<24|e[5]<<16|e[6]<<8|e[7]),1===t&&(i*=Math.pow(2,32),i+=z(e[8]<<24|e[9]<<16|e[10]<<8|e[11])),i})[0]||1/0)/r})})),r=Math.min.apply(null,n),isFinite(r)?r:0},videoTrackIds:function(e){var t=[];return V(e,["moov","trak"]).forEach(function(e){var i=V(e,["mdia","hdlr"]),n=V(e,["tkhd"]);i.forEach(function(e,i){var r,a,s=H(e.subarray(8,12)),o=n[i];"vide"===s&&(a=0===(r=new DataView(o.buffer,o.byteOffset,o.byteLength)).getUint8(0)?r.getUint32(12):r.getUint32(20),t.push(a))})}),t}},X=function(){this.init=function(){var e={};this.on=function(t,i){e[t]||(e[t]=[]),e[t]=e[t].concat(i)},this.off=function(t,i){var n;return!!e[t]&&(n=e[t].indexOf(i),e[t]=e[t].slice(),e[t].splice(n,1),n>-1)},this.trigger=function(t){var i,n,r,a;if(i=e[t])if(2===arguments.length)for(r=i.length,n=0;n<r;++n)i[n].call(this,arguments[1]);else{for(a=[],n=arguments.length,n=1;n<arguments.length;++n)a.push(arguments[n]);for(r=i.length,n=0;n<r;++n)i[n].apply(this,a)}},this.dispose=function(){e={}}}};X.prototype.pipe=function(e){return this.on("data",function(t){e.push(t)}),this.on("done",function(t){e.flush(t)}),e},X.prototype.push=function(e){this.trigger("data",e)},X.prototype.flush=function(e){this.trigger("done",e)};var Y,$,K,Q,Z,J=X,ee=function(e,t){var i={size:0,flags:{isLeading:0,dependsOn:1,isDependedOn:0,hasRedundancy:0,degradationPriority:0,isNonSyncSample:1}};return i.dataOffset=t,i.compositionTimeOffset=e.pts-e.dts,i.duration=e.duration,i.size=4*e.length,i.size+=e.byteLength,e.keyFrame&&(i.flags.dependsOn=2,i.flags.isNonSyncSample=0),i},te=function(e){var t,i,n=[],r=[];for(n.byteLength=0,t=0;t<e.length;t++)"access_unit_delimiter_rbsp"===(i=e[t]).nalUnitType?(n.length&&(n.duration=i.dts-n.dts,r.push(n)),(n=[i]).byteLength=i.data.byteLength,n.pts=i.pts,n.dts=i.dts):("slice_layer_without_partitioning_rbsp_idr"===i.nalUnitType&&(n.keyFrame=!0),n.duration=i.dts-n.dts,n.byteLength+=i.data.byteLength,n.push(i));return r.length&&(!n.duration||n.duration<=0)&&(n.duration=r[r.length-1].duration),r.push(n),r},ie=function(e){var t,i,n=[],r=[];for(n.byteLength=0,n.nalCount=0,n.duration=0,n.pts=e[0].pts,n.dts=e[0].dts,r.byteLength=0,r.nalCount=0,r.duration=0,r.pts=e[0].pts,r.dts=e[0].dts,t=0;t<e.length;t++)(i=e[t]).keyFrame?(n.length&&(r.push(n),r.byteLength+=n.byteLength,r.nalCount+=n.nalCount,r.duration+=n.duration),(n=[i]).nalCount=i.length,n.byteLength=i.byteLength,n.pts=i.pts,n.dts=i.dts,n.duration=i.duration):(n.duration+=i.duration,n.nalCount+=i.length,n.byteLength+=i.byteLength,n.push(i));return r.length&&n.duration<=0&&(n.duration=r[r.length-1].duration),r.byteLength+=n.byteLength,r.nalCount+=n.nalCount,r.duration+=n.duration,r.push(n),r},ne=function(e){var t;return!e[0][0].keyFrame&&e.length>1&&(t=e.shift(),e.byteLength-=t.byteLength,e.nalCount-=t.nalCount,e[0][0].dts=t.dts,e[0][0].pts=t.pts,e[0][0].duration+=t.duration),e},re=function(e,t){var i,n,r,a,s,o=t||0,u=[];for(i=0;i<e.length;i++)for(a=e[i],n=0;n<a.length;n++)s=a[n],o+=(r=ee(s,o)).size,u.push(r);return u},ae=function(e){var t,i,n,r,a,s,o=0,u=e.byteLength,d=e.nalCount,l=new Uint8Array(u+4*d),h=new DataView(l.buffer);for(t=0;t<e.length;t++)for(r=e[t],i=0;i<r.length;i++)for(a=r[i],n=0;n<a.length;n++)s=a[n],h.setUint32(o,s.data.byteLength),o+=4,l.set(s.data,o),o+=s.data.byteLength;return l},se=[33,16,5,32,164,27],oe=[33,65,108,84,1,2,4,8,168,2,4,8,17,191,252],ue=function(e){for(var t=[];e--;)t.push(0);return t},de={96000:[se,[227,64],ue(154),[56]],88200:[se,[231],ue(170),[56]],64000:[se,[248,192],ue(240),[56]],48000:[se,[255,192],ue(268),[55,148,128],ue(54),[112]],44100:[se,[255,192],ue(268),[55,163,128],ue(84),[112]],32000:[se,[255,192],ue(268),[55,234],ue(226),[112]],24000:[se,[255,192],ue(268),[55,255,128],ue(268),[111,112],ue(126),[224]],16000:[se,[255,192],ue(268),[55,255,128],ue(268),[111,255],ue(269),[223,108],ue(195),[1,192]],12000:[oe,ue(268),[3,127,248],ue(268),[6,255,240],ue(268),[13,255,224],ue(268),[27,253,128],ue(259),[56]],11025:[oe,ue(268),[3,127,248],ue(268),[6,255,240],ue(268),[13,255,224],ue(268),[27,255,192],ue(268),[55,175,128],ue(108),[112]],8000:[oe,ue(268),[3,121,16],ue(47),[7]]},le=(Y=de,Object.keys(Y).reduce(function(e,t){return e[t]=new Uint8Array(Y[t].reduce(function(e,t){return e.concat(t)},[])),e},{})),he=($=function(e){return 9e4*e},K=function(e,t){return e*t},Q=function(e){return e/9e4},Z=function(e,t){return e/t},function(e,t){return $(Z(e,t))}),ce=function(e,t){return K(Q(e),t)},fe=function(e,t,i,n){var r,a,s,o,u=0,d=0,l=0;if(t.length&&(r=he(e.baseMediaDecodeTime,e.samplerate),a=Math.ceil(9e4/(e.samplerate/1024)),i&&n&&(u=r-Math.max(i,n),l=(d=Math.floor(u/a))*a),!(d<1||l>45e3))){for((s=le[e.samplerate])||(s=t[0].data),o=0;o<d;o++)t.splice(o,0,{data:s});e.baseMediaDecodeTime-=Math.floor(ce(l,e.samplerate))}},pe=function(e,t,i){return t.minSegmentDts>=i?e:(t.minSegmentDts=1/0,e.filter(function(e){return e.dts>=i&&(t.minSegmentDts=Math.min(t.minSegmentDts,e.dts),t.minSegmentPts=t.minSegmentDts,!0)}))},me=function(e){var t,i,n=[];for(t=0;t<e.length;t++)i=e[t],n.push({size:i.data.byteLength,duration:1024});return n},ge=function(e){var t,i,n=0,r=new Uint8Array(function(e){var t,i=0;for(t=0;t<e.length;t++)i+=e[t].data.byteLength;return i}(e));for(t=0;t<e.length;t++)i=e[t],r.set(i.data,n),n+=i.data.byteLength;return r},ye=function(e){delete e.minSegmentDts,delete e.maxSegmentDts,delete e.minSegmentPts,delete e.maxSegmentPts},_e=function(e,t){var i,n=e.minSegmentDts;return t||(n-=e.timelineStartInfo.dts),i=e.timelineStartInfo.baseMediaDecodeTime,i+=n,i=Math.max(0,i),"audio"===e.type&&(i*=e.samplerate/9e4,i=Math.floor(i)),i},ve=function(e,t){"number"==typeof t.pts&&(void 0===e.timelineStartInfo.pts&&(e.timelineStartInfo.pts=t.pts),void 0===e.minSegmentPts?e.minSegmentPts=t.pts:e.minSegmentPts=Math.min(e.minSegmentPts,t.pts),void 0===e.maxSegmentPts?e.maxSegmentPts=t.pts:e.maxSegmentPts=Math.max(e.maxSegmentPts,t.pts)),"number"==typeof t.dts&&(void 0===e.timelineStartInfo.dts&&(e.timelineStartInfo.dts=t.dts),void 0===e.minSegmentDts?e.minSegmentDts=t.dts:e.minSegmentDts=Math.min(e.minSegmentDts,t.dts),void 0===e.maxSegmentDts?e.maxSegmentDts=t.dts:e.maxSegmentDts=Math.max(e.maxSegmentDts,t.dts))},be=function(e){for(var t=0,i={payloadType:-1,payloadSize:0},n=0,r=0;t<e.byteLength&&128!==e[t];){for(;255===e[t];)n+=255,t++;for(n+=e[t++];255===e[t];)r+=255,t++;if(r+=e[t++],!i.payload&&4===n){i.payloadType=n,i.payloadSize=r,i.payload=e.subarray(t,t+r);break}t+=r,n=0,r=0}return i},Te=function(e){return 181!==e.payload[0]?null:49!=(e.payload[1]<<8|e.payload[2])?null:"GA94"!==String.fromCharCode(e.payload[3],e.payload[4],e.payload[5],e.payload[6])?null:3!==e.payload[7]?null:e.payload.subarray(8,e.payload.length-1)},Se=function(e,t){var i,n,r,a,s=[];if(!(64&t[0]))return s;for(n=31&t[0],i=0;i<n;i++)a={type:3&t[2+(r=3*i)],pts:e},4&t[r+2]&&(a.ccData=t[r+3]<<8|t[r+4],s.push(a));return s},ke=function(e){for(var t,i,n=e.byteLength,r=[],a=1;a<n-2;)0===e[a]&&0===e[a+1]&&3===e[a+2]?(r.push(a+2),a+=2):a++;if(0===r.length)return e;t=n-r.length,i=new Uint8Array(t);var s=0;for(a=0;a<t;s++,a++)s===r[0]&&(s++,r.shift()),i[a]=e[s];return i},we=4,Ue=function e(){e.prototype.init.call(this),this.captionPackets_=[],this.ccStreams_=[new Ie(0,0),new Ie(0,1),new Ie(1,0),new Ie(1,1)],this.reset(),this.ccStreams_.forEach(function(e){e.on("data",this.trigger.bind(this,"data")),e.on("done",this.trigger.bind(this,"done"))},this)};(Ue.prototype=new J).push=function(e){var t,i,n;if("sei_rbsp"===e.nalUnitType&&(t=be(e.escapedRBSP)).payloadType===we&&(i=Te(t)))if(e.dts<this.latestDts_)this.ignoreNextEqualDts_=!0;else{if(e.dts===this.latestDts_&&this.ignoreNextEqualDts_)return this.numSameDts_--,void(this.numSameDts_||(this.ignoreNextEqualDts_=!1));n=Se(e.pts,i),this.captionPackets_=this.captionPackets_.concat(n),this.latestDts_!==e.dts&&(this.numSameDts_=0),this.numSameDts_++,this.latestDts_=e.dts}},Ue.prototype.flush=function(){this.captionPackets_.length?(this.captionPackets_.forEach(function(e,t){e.presortIndex=t}),this.captionPackets_.sort(function(e,t){return e.pts===t.pts?e.presortIndex-t.presortIndex:e.pts-t.pts}),this.captionPackets_.forEach(function(e){e.type<2&&this.dispatchCea608Packet(e)},this),this.captionPackets_.length=0,this.ccStreams_.forEach(function(e){e.flush()},this)):this.ccStreams_.forEach(function(e){e.flush()},this)},Ue.prototype.reset=function(){this.latestDts_=null,this.ignoreNextEqualDts_=!1,this.numSameDts_=0,this.activeCea608Channel_=[null,null],this.ccStreams_.forEach(function(e){e.reset()})},Ue.prototype.dispatchCea608Packet=function(e){this.setsChannel1Active(e)?this.activeCea608Channel_[e.type]=0:this.setsChannel2Active(e)&&(this.activeCea608Channel_[e.type]=1),null!==this.activeCea608Channel_[e.type]&&this.ccStreams_[(e.type<<1)+this.activeCea608Channel_[e.type]].push(e)},Ue.prototype.setsChannel1Active=function(e){return 4096==(30720&e.ccData)},Ue.prototype.setsChannel2Active=function(e){return 6144==(30720&e.ccData)};var Le={42:225,92:233,94:237,95:243,96:250,123:231,124:247,125:209,126:241,127:9608,304:174,305:176,306:189,307:191,308:8482,309:162,310:163,311:9834,312:224,313:160,314:232,315:226,316:234,317:238,318:244,319:251,544:193,545:201,546:211,547:218,548:220,549:252,550:8216,551:161,552:42,553:39,554:8212,555:169,556:8480,557:8226,558:8220,559:8221,560:192,561:194,562:199,563:200,564:202,565:203,566:235,567:206,568:207,569:239,570:212,571:217,572:249,573:219,574:171,575:187,800:195,801:227,802:205,803:204,804:236,805:210,806:242,807:213,808:245,809:123,810:125,811:92,812:94,813:95,814:124,815:126,816:196,817:228,818:214,819:246,820:223,821:165,822:164,823:9474,824:197,825:229,826:216,827:248,828:9484,829:9488,830:9492,831:9496},Ae=function(e){return null===e?"":(e=Le[e]||e,String.fromCharCode(e))},Ee=[4352,4384,4608,4640,5376,5408,5632,5664,5888,5920,4096,4864,4896,5120,5152],Oe=function(){for(var e=[],t=15;t--;)e.push("");return e},Ie=function e(t,i){e.prototype.init.call(this),this.field_=t||0,this.dataChannel_=i||0,this.name_="CC"+(1+(this.field_<<1|this.dataChannel_)),this.setConstants(),this.reset(),this.push=function(e){var t,i,n,r,a;if((t=32639&e.ccData)!==this.lastControlCode_){if(4096==(61440&t)?this.lastControlCode_=t:t!==this.PADDING_&&(this.lastControlCode_=null),n=t>>>8,r=255&t,t!==this.PADDING_)if(t===this.RESUME_CAPTION_LOADING_)this.mode_="popOn";else if(t===this.END_OF_CAPTION_)this.mode_="popOn",this.clearFormatting(e.pts),this.flushDisplayed(e.pts),i=this.displayed_,this.displayed_=this.nonDisplayed_,this.nonDisplayed_=i,this.startPts_=e.pts;else if(t===this.ROLL_UP_2_ROWS_)this.rollUpRows_=2,this.setRollUp(e.pts);else if(t===this.ROLL_UP_3_ROWS_)this.rollUpRows_=3,this.setRollUp(e.pts);else if(t===this.ROLL_UP_4_ROWS_)this.rollUpRows_=4,this.setRollUp(e.pts);else if(t===this.CARRIAGE_RETURN_)this.clearFormatting(e.pts),this.flushDisplayed(e.pts),this.shiftRowsUp_(),this.startPts_=e.pts;else if(t===this.BACKSPACE_)"popOn"===this.mode_?this.nonDisplayed_[this.row_]=this.nonDisplayed_[this.row_].slice(0,-1):this.displayed_[this.row_]=this.displayed_[this.row_].slice(0,-1);else if(t===this.ERASE_DISPLAYED_MEMORY_)this.flushDisplayed(e.pts),this.displayed_=Oe();else if(t===this.ERASE_NON_DISPLAYED_MEMORY_)this.nonDisplayed_=Oe();else if(t===this.RESUME_DIRECT_CAPTIONING_)"paintOn"!==this.mode_&&(this.flushDisplayed(e.pts),this.displayed_=Oe()),this.mode_="paintOn",this.startPts_=e.pts;else if(this.isSpecialCharacter(n,r))a=Ae((n=(3&n)<<8)|r),this[this.mode_](e.pts,a),this.column_++;else if(this.isExtCharacter(n,r))"popOn"===this.mode_?this.nonDisplayed_[this.row_]=this.nonDisplayed_[this.row_].slice(0,-1):this.displayed_[this.row_]=this.displayed_[this.row_].slice(0,-1),a=Ae((n=(3&n)<<8)|r),this[this.mode_](e.pts,a),this.column_++;else if(this.isMidRowCode(n,r))this.clearFormatting(e.pts),this[this.mode_](e.pts," "),this.column_++,14==(14&r)&&this.addFormatting(e.pts,["i"]),1==(1&r)&&this.addFormatting(e.pts,["u"]);else if(this.isOffsetControlCode(n,r))this.column_+=3&r;else if(this.isPAC(n,r)){var s=Ee.indexOf(7968&t);"rollUp"===this.mode_&&(s-this.rollUpRows_+1<0&&(s=this.rollUpRows_-1),this.setRollUp(e.pts,s)),s!==this.row_&&(this.clearFormatting(e.pts),this.row_=s),1&r&&-1===this.formatting_.indexOf("u")&&this.addFormatting(e.pts,["u"]),16==(16&t)&&(this.column_=4*((14&t)>>1)),this.isColorPAC(r)&&14==(14&r)&&this.addFormatting(e.pts,["i"])}else this.isNormalChar(n)&&(0===r&&(r=null),a=Ae(n),a+=Ae(r),this[this.mode_](e.pts,a),this.column_+=a.length)}else this.lastControlCode_=null}};Ie.prototype=new J,Ie.prototype.flushDisplayed=function(e){var t=this.displayed_.map(function(e){try{return e.trim()}catch(e){return console.error("Skipping malformed caption."),""}}).join("\n").replace(/^\n+|\n+$/g,"");t.length&&this.trigger("data",{startPts:this.startPts_,endPts:e,text:t,stream:this.name_})},Ie.prototype.reset=function(){this.mode_="popOn",this.topRow_=0,this.startPts_=0,this.displayed_=Oe(),this.nonDisplayed_=Oe(),this.lastControlCode_=null,this.column_=0,this.row_=14,this.rollUpRows_=2,this.formatting_=[]},Ie.prototype.setConstants=function(){0===this.dataChannel_?(this.BASE_=16,this.EXT_=17,this.CONTROL_=(20|this.field_)<<8,this.OFFSET_=23):1===this.dataChannel_&&(this.BASE_=24,this.EXT_=25,this.CONTROL_=(28|this.field_)<<8,this.OFFSET_=31),this.PADDING_=0,this.RESUME_CAPTION_LOADING_=32|this.CONTROL_,this.END_OF_CAPTION_=47|this.CONTROL_,this.ROLL_UP_2_ROWS_=37|this.CONTROL_,this.ROLL_UP_3_ROWS_=38|this.CONTROL_,this.ROLL_UP_4_ROWS_=39|this.CONTROL_,this.CARRIAGE_RETURN_=45|this.CONTROL_,this.RESUME_DIRECT_CAPTIONING_=41|this.CONTROL_,this.BACKSPACE_=33|this.CONTROL_,this.ERASE_DISPLAYED_MEMORY_=44|this.CONTROL_,this.ERASE_NON_DISPLAYED_MEMORY_=46|this.CONTROL_},Ie.prototype.isSpecialCharacter=function(e,t){return e===this.EXT_&&t>=48&&t<=63},Ie.prototype.isExtCharacter=function(e,t){return(e===this.EXT_+1||e===this.EXT_+2)&&t>=32&&t<=63},Ie.prototype.isMidRowCode=function(e,t){return e===this.EXT_&&t>=32&&t<=47},Ie.prototype.isOffsetControlCode=function(e,t){return e===this.OFFSET_&&t>=33&&t<=35},Ie.prototype.isPAC=function(e,t){return e>=this.BASE_&&e<this.BASE_+8&&t>=64&&t<=127},Ie.prototype.isColorPAC=function(e){return e>=64&&e<=79||e>=96&&e<=127},Ie.prototype.isNormalChar=function(e){return e>=32&&e<=127},Ie.prototype.setRollUp=function(e,t){if("rollUp"!==this.mode_&&(this.row_=14,this.mode_="rollUp",this.flushDisplayed(e),this.nonDisplayed_=Oe(),this.displayed_=Oe()),void 0!==t&&t!==this.row_)for(var i=0;i<this.rollUpRows_;i++)this.displayed_[t-i]=this.displayed_[this.row_-i],this.displayed_[this.row_-i]="";void 0===t&&(t=this.row_),this.topRow_=t-this.rollUpRows_+1},Ie.prototype.addFormatting=function(e,t){this.formatting_=this.formatting_.concat(t);var i=t.reduce(function(e,t){return e+"<"+t+">"},"");this[this.mode_](e,i)},Ie.prototype.clearFormatting=function(e){if(this.formatting_.length){var t=this.formatting_.reverse().reduce(function(e,t){return e+"</"+t+">"},"");this.formatting_=[],this[this.mode_](e,t)}},Ie.prototype.popOn=function(e,t){var i=this.nonDisplayed_[this.row_];i+=t,this.nonDisplayed_[this.row_]=i},Ie.prototype.rollUp=function(e,t){var i=this.displayed_[this.row_];i+=t,this.displayed_[this.row_]=i},Ie.prototype.shiftRowsUp_=function(){var e;for(e=0;e<this.topRow_;e++)this.displayed_[e]="";for(e=this.row_+1;e<15;e++)this.displayed_[e]="";for(e=this.topRow_;e<this.row_;e++)this.displayed_[e]=this.displayed_[e+1];this.displayed_[this.row_]=""},Ie.prototype.paintOn=function(e,t){var i=this.displayed_[this.row_];i+=t,this.displayed_[this.row_]=i};var Ce={CaptionStream:Ue,Cea608Stream:Ie},Pe={H264_STREAM_TYPE:27,ADTS_STREAM_TYPE:15,METADATA_STREAM_TYPE:21},De=function(e,t){var i=1;for(e>t&&(i=-1);Math.abs(t-e)>4294967296;)e+=8589934592*i;return e},Re=function e(t){var i,n;e.prototype.init.call(this),this.type_=t,this.push=function(e){e.type===this.type_&&(void 0===n&&(n=e.dts),e.dts=De(e.dts,n),e.pts=De(e.pts,n),i=e.dts,this.trigger("data",e))},this.flush=function(){n=i,this.trigger("done")},this.discontinuity=function(){n=void 0,i=void 0}};Re.prototype=new J;var xe,Me=Re,Be=function(e,t,i){var n,r="";for(n=t;n<i;n++)r+="%"+("00"+e[n].toString(16)).slice(-2);return r},Ne=function(e,t,i){return decodeURIComponent(Be(e,t,i))},qe=function(e){return e[0]<<21|e[1]<<14|e[2]<<7|e[3]},Fe={TXXX:function(e){var t;if(3===e.data[0]){for(t=1;t<e.data.length;t++)if(0===e.data[t]){e.description=Ne(e.data,1,t),e.value=Ne(e.data,t+1,e.data.length).replace(/\0*$/,"");break}e.data=e.value}},WXXX:function(e){var t;if(3===e.data[0])for(t=1;t<e.data.length;t++)if(0===e.data[t]){e.description=Ne(e.data,1,t),e.url=Ne(e.data,t+1,e.data.length);break}},PRIV:function(e){var t,i;for(t=0;t<e.data.length;t++)if(0===e.data[t]){e.owner=(i=e.data,unescape(Be(i,0,t)));break}e.privateData=e.data.subarray(t+1),e.data=e.privateData}};(xe=function(e){var t,i={debug:!(!e||!e.debug),descriptor:e&&e.descriptor},n=0,r=[],a=0;if(xe.prototype.init.call(this),this.dispatchType=Pe.METADATA_STREAM_TYPE.toString(16),i.descriptor)for(t=0;t<i.descriptor.length;t++)this.dispatchType+=("00"+i.descriptor[t].toString(16)).slice(-2);this.push=function(e){var t,s,o,u,d;if("timed-metadata"===e.type)if(e.dataAlignmentIndicator&&(a=0,r.length=0),0===r.length&&(e.data.length<10||e.data[0]!=="I".charCodeAt(0)||e.data[1]!=="D".charCodeAt(0)||e.data[2]!=="3".charCodeAt(0)))i.debug&&console.log("Skipping unrecognized metadata packet");else if(r.push(e),a+=e.data.byteLength,1===r.length&&(n=qe(e.data.subarray(6,10)),n+=10),!(a<n)){for(t={data:new Uint8Array(n),frames:[],pts:r[0].pts,dts:r[0].dts},d=0;d<n;)t.data.set(r[0].data.subarray(0,n-d),d),d+=r[0].data.byteLength,a-=r[0].data.byteLength,r.shift();s=10,64&t.data[5]&&(s+=4,s+=qe(t.data.subarray(10,14)),n-=qe(t.data.subarray(16,20)));do{if((o=qe(t.data.subarray(s+4,s+8)))<1)return console.log("Malformed ID3 frame encountered. Skipping metadata parsing.");if((u={id:String.fromCharCode(t.data[s],t.data[s+1],t.data[s+2],t.data[s+3]),data:t.data.subarray(s+10,s+o+10)}).key=u.id,Fe[u.id]&&(Fe[u.id](u),"com.apple.streaming.transportStreamTimestamp"===u.owner)){var l=u.data,h=(1&l[3])<<30|l[4]<<22|l[5]<<14|l[6]<<6|l[7]>>>2;h*=4,h+=3&l[7],u.timeStamp=h,void 0===t.pts&&void 0===t.dts&&(t.pts=u.timeStamp,t.dts=u.timeStamp),this.trigger("timestamp",u)}t.frames.push(u),s+=10,s+=o}while(s<n);this.trigger("data",t)}}}).prototype=new J;var Ge,Ve,He,je=xe,ze=Me;(Ge=function(){var e=new Uint8Array(188),t=0;Ge.prototype.init.call(this),this.push=function(i){var n,r=0,a=188;for(t?((n=new Uint8Array(i.byteLength+t)).set(e.subarray(0,t)),n.set(i,t),t=0):n=i;a<n.byteLength;)71!==n[r]||71!==n[a]?(r++,a++):(this.trigger("data",n.subarray(r,a)),r+=188,a+=188);r<n.byteLength&&(e.set(n.subarray(r),0),t=n.byteLength-r)},this.flush=function(){188===t&&71===e[0]&&(this.trigger("data",e),t=0),this.trigger("done")}}).prototype=new J,(Ve=function(){var e,t,i,n;Ve.prototype.init.call(this),n=this,this.packetsWaitingForPmt=[],this.programMapTable=void 0,e=function(e,n){var r=0;n.payloadUnitStartIndicator&&(r+=e[r]+1),"pat"===n.type?t(e.subarray(r),n):i(e.subarray(r),n)},t=function(e,t){t.section_number=e[7],t.last_section_number=e[8],n.pmtPid=(31&e[10])<<8|e[11],t.pmtPid=n.pmtPid},i=function(e,t){var i,r;if(1&e[5]){for(n.programMapTable={video:null,audio:null,"timed-metadata":{}},i=3+((15&e[1])<<8|e[2])-4,r=12+((15&e[10])<<8|e[11]);r<i;){var a=e[r],s=(31&e[r+1])<<8|e[r+2];a===Pe.H264_STREAM_TYPE&&null===n.programMapTable.video?n.programMapTable.video=s:a===Pe.ADTS_STREAM_TYPE&&null===n.programMapTable.audio?n.programMapTable.audio=s:a===Pe.METADATA_STREAM_TYPE&&(n.programMapTable["timed-metadata"][s]=a),r+=5+((15&e[r+3])<<8|e[r+4])}t.programMapTable=n.programMapTable}},this.push=function(t){var i={},n=4;if(i.payloadUnitStartIndicator=!!(64&t[1]),i.pid=31&t[1],i.pid<<=8,i.pid|=t[2],(48&t[3])>>>4>1&&(n+=t[n]+1),0===i.pid)i.type="pat",e(t.subarray(n),i),this.trigger("data",i);else if(i.pid===this.pmtPid)for(i.type="pmt",e(t.subarray(n),i),this.trigger("data",i);this.packetsWaitingForPmt.length;)this.processPes_.apply(this,this.packetsWaitingForPmt.shift());else void 0===this.programMapTable?this.packetsWaitingForPmt.push([t,n,i]):this.processPes_(t,n,i)},this.processPes_=function(e,t,i){i.pid===this.programMapTable.video?i.streamType=Pe.H264_STREAM_TYPE:i.pid===this.programMapTable.audio?i.streamType=Pe.ADTS_STREAM_TYPE:i.streamType=this.programMapTable["timed-metadata"][i.pid],i.type="pes",i.data=e.subarray(t),this.trigger("data",i)}}).prototype=new J,Ve.STREAM_TYPES={h264:27,adts:15},(He=function(){var e=this,t={data:[],size:0},i={data:[],size:0},n={data:[],size:0},r=function(t,i,n){var r,a,s=new Uint8Array(t.size),o={type:i},u=0,d=0;if(t.data.length&&!(t.size<9)){for(o.trackId=t.data[0].pid,u=0;u<t.data.length;u++)a=t.data[u],s.set(a.data,d),d+=a.data.byteLength;var l,h,c;l=s,(h=o).packetLength=6+(l[4]<<8|l[5]),h.dataAlignmentIndicator=0!=(4&l[6]),192&(c=l[7])&&(h.pts=(14&l[9])<<27|(255&l[10])<<20|(254&l[11])<<12|(255&l[12])<<5|(254&l[13])>>>3,h.pts*=4,h.pts+=(6&l[13])>>>1,h.dts=h.pts,64&c&&(h.dts=(14&l[14])<<27|(255&l[15])<<20|(254&l[16])<<12|(255&l[17])<<5|(254&l[18])>>>3,h.dts*=4,h.dts+=(6&l[18])>>>1)),h.data=l.subarray(9+l[8]),r="video"===i||o.packetLength<=t.size,(n||r)&&(t.size=0,t.data.length=0),r&&e.trigger("data",o)}};He.prototype.init.call(this),this.push=function(a){({pat:function(){},pes:function(){var e,s;switch(a.streamType){case Pe.H264_STREAM_TYPE:case Pe.H264_STREAM_TYPE:e=t,s="video";break;case Pe.ADTS_STREAM_TYPE:e=i,s="audio";break;case Pe.METADATA_STREAM_TYPE:e=n,s="timed-metadata";break;default:return}a.payloadUnitStartIndicator&&r(e,s,!0),e.data.push(a),e.size+=a.data.byteLength},pmt:function(){var t={type:"metadata",tracks:[]},i=a.programMapTable;null!==i.video&&t.tracks.push({timelineStartInfo:{baseMediaDecodeTime:0},id:+i.video,codec:"avc",type:"video"}),null!==i.audio&&t.tracks.push({timelineStartInfo:{baseMediaDecodeTime:0},id:+i.audio,codec:"adts",type:"audio"}),e.trigger("data",t)}})[a.type]()},this.flush=function(){r(t,"video"),r(i,"audio"),r(n,"timed-metadata"),this.trigger("done")}}).prototype=new J;var We={PAT_PID:0,MP2T_PACKET_LENGTH:188,TransportPacketStream:Ge,TransportParseStream:Ve,ElementaryStream:He,TimestampRolloverStream:ze,CaptionStream:Ce.CaptionStream,Cea608Stream:Ce.Cea608Stream,MetadataStream:je};for(var Xe in Pe)Pe.hasOwnProperty(Xe)&&(We[Xe]=Pe[Xe]);var Ye,$e=We,Ke=[96e3,88200,64e3,48e3,44100,32e3,24e3,22050,16e3,12e3,11025,8e3,7350];(Ye=function(){var e;Ye.prototype.init.call(this),this.push=function(t){var i,n,r,a,s,o,u=0,d=0;if("audio"===t.type)for(e?(a=e,(e=new Uint8Array(a.byteLength+t.data.byteLength)).set(a),e.set(t.data,a.byteLength)):e=t.data;u+5<e.length;)if(255===e[u]&&240==(246&e[u+1])){if(n=2*(1&~e[u+1]),i=(3&e[u+3])<<11|e[u+4]<<3|(224&e[u+5])>>5,o=9e4*(s=1024*(1+(3&e[u+6])))/Ke[(60&e[u+2])>>>2],r=u+i,e.byteLength<r)return;if(this.trigger("data",{pts:t.pts+d*o,dts:t.dts+d*o,sampleCount:s,audioobjecttype:1+(e[u+2]>>>6&3),channelcount:(1&e[u+2])<<2|(192&e[u+3])>>>6,samplerate:Ke[(60&e[u+2])>>>2],samplingfrequencyindex:(60&e[u+2])>>>2,samplesize:16,data:e.subarray(u+7+n,r)}),e.byteLength===r)return void(e=void 0);d++,e=e.subarray(r)}else u++},this.flush=function(){this.trigger("done")}}).prototype=new J;var Qe,Ze,Je,et=Ye,tt=function(e){var t=e.byteLength,i=0,n=0;this.length=function(){return 8*t},this.bitsAvailable=function(){return 8*t+n},this.loadWord=function(){var r=e.byteLength-t,a=new Uint8Array(4),s=Math.min(4,t);if(0===s)throw new Error("no bytes available");a.set(e.subarray(r,r+s)),i=new DataView(a.buffer).getUint32(0),n=8*s,t-=s},this.skipBits=function(e){var r;n>e?(i<<=e,n-=e):(e-=n,e-=8*(r=Math.floor(e/8)),t-=r,this.loadWord(),i<<=e,n-=e)},this.readBits=function(e){var r=Math.min(n,e),a=i>>>32-r;return(n-=r)>0?i<<=r:t>0&&this.loadWord(),(r=e-r)>0?a<<r|this.readBits(r):a},this.skipLeadingZeros=function(){var e;for(e=0;e<n;++e)if(0!=(i&2147483648>>>e))return i<<=e,n-=e,e;return this.loadWord(),e+this.skipLeadingZeros()},this.skipUnsignedExpGolomb=function(){this.skipBits(1+this.skipLeadingZeros())},this.skipExpGolomb=function(){this.skipBits(1+this.skipLeadingZeros())},this.readUnsignedExpGolomb=function(){var e=this.skipLeadingZeros();return this.readBits(e+1)-1},this.readExpGolomb=function(){var e=this.readUnsignedExpGolomb();return 1&e?1+e>>>1:-1*(e>>>1)},this.readBoolean=function(){return 1===this.readBits(1)},this.readUnsignedByte=function(){return this.readBits(8)},this.loadWord()};(Ze=function(){var e,t,i=0;Ze.prototype.init.call(this),this.push=function(n){var r;for(t?((r=new Uint8Array(t.byteLength+n.data.byteLength)).set(t),r.set(n.data,t.byteLength),t=r):t=n.data;i<t.byteLength-3;i++)if(1===t[i+2]){e=i+5;break}for(;e<t.byteLength;)switch(t[e]){case 0:if(0!==t[e-1]){e+=2;break}if(0!==t[e-2]){e++;break}i+3!==e-2&&this.trigger("data",t.subarray(i+3,e-2));do{e++}while(1!==t[e]&&e<t.length);i=e-2,e+=3;break;case 1:if(0!==t[e-1]||0!==t[e-2]){e+=3;break}this.trigger("data",t.subarray(i+3,e-2)),i=e-2,e+=3;break;default:e+=3}t=t.subarray(i),e-=i,i=0},this.flush=function(){t&&t.byteLength>3&&this.trigger("data",t.subarray(i+3)),t=null,i=0,this.trigger("done")}}).prototype=new J,Je={100:!0,110:!0,122:!0,244:!0,44:!0,83:!0,86:!0,118:!0,128:!0,138:!0,139:!0,134:!0},(Qe=function(){var e,t,i,n,r,a,s,o=new Ze;Qe.prototype.init.call(this),e=this,this.push=function(e){"video"===e.type&&(t=e.trackId,i=e.pts,n=e.dts,o.push(e))},o.on("data",function(s){var o={trackId:t,pts:i,dts:n,data:s};switch(31&s[0]){case 5:o.nalUnitType="slice_layer_without_partitioning_rbsp_idr";break;case 6:o.nalUnitType="sei_rbsp",o.escapedRBSP=r(s.subarray(1));break;case 7:o.nalUnitType="seq_parameter_set_rbsp",o.escapedRBSP=r(s.subarray(1)),o.config=a(o.escapedRBSP);break;case 8:o.nalUnitType="pic_parameter_set_rbsp";break;case 9:o.nalUnitType="access_unit_delimiter_rbsp"}e.trigger("data",o)}),o.on("done",function(){e.trigger("done")}),this.flush=function(){o.flush()},s=function(e,t){var i,n=8,r=8;for(i=0;i<e;i++)0!==r&&(r=(n+t.readExpGolomb()+256)%256),n=0===r?n:r},r=function(e){for(var t,i,n=e.byteLength,r=[],a=1;a<n-2;)0===e[a]&&0===e[a+1]&&3===e[a+2]?(r.push(a+2),a+=2):a++;if(0===r.length)return e;t=n-r.length,i=new Uint8Array(t);var s=0;for(a=0;a<t;s++,a++)s===r[0]&&(s++,r.shift()),i[a]=e[s];return i},a=function(e){var t,i,n,r,a,o,u,d,l,h,c,f,p,m=0,g=0,y=0,_=0,v=1;if(i=(t=new tt(e)).readUnsignedByte(),r=t.readUnsignedByte(),n=t.readUnsignedByte(),t.skipUnsignedExpGolomb(),Je[i]&&(3===(a=t.readUnsignedExpGolomb())&&t.skipBits(1),t.skipUnsignedExpGolomb(),t.skipUnsignedExpGolomb(),t.skipBits(1),t.readBoolean()))for(c=3!==a?8:12,p=0;p<c;p++)t.readBoolean()&&s(p<6?16:64,t);if(t.skipUnsignedExpGolomb(),0===(o=t.readUnsignedExpGolomb()))t.readUnsignedExpGolomb();else if(1===o)for(t.skipBits(1),t.skipExpGolomb(),t.skipExpGolomb(),u=t.readUnsignedExpGolomb(),p=0;p<u;p++)t.skipExpGolomb();if(t.skipUnsignedExpGolomb(),t.skipBits(1),d=t.readUnsignedExpGolomb(),l=t.readUnsignedExpGolomb(),0===(h=t.readBits(1))&&t.skipBits(1),t.skipBits(1),t.readBoolean()&&(m=t.readUnsignedExpGolomb(),g=t.readUnsignedExpGolomb(),y=t.readUnsignedExpGolomb(),_=t.readUnsignedExpGolomb()),t.readBoolean()&&t.readBoolean()){switch(t.readUnsignedByte()){case 1:f=[1,1];break;case 2:f=[12,11];break;case 3:f=[10,11];break;case 4:f=[16,11];break;case 5:f=[40,33];break;case 6:f=[24,11];break;case 7:f=[20,11];break;case 8:f=[32,11];break;case 9:f=[80,33];break;case 10:f=[18,11];break;case 11:f=[15,11];break;case 12:f=[64,33];break;case 13:f=[160,99];break;case 14:f=[4,3];break;case 15:f=[3,2];break;case 16:f=[2,1];break;case 255:f=[t.readUnsignedByte()<<8|t.readUnsignedByte(),t.readUnsignedByte()<<8|t.readUnsignedByte()]}f&&(v=f[0]/f[1])}return{profileIdc:i,levelIdc:n,profileCompatibility:r,width:Math.ceil((16*(d+1)-2*m-2*g)*v),height:(2-h)*(l+1)*16-2*y-2*_}}}).prototype=new J;var it,nt={H264Stream:Qe,NalByteStream:Ze},rt=function(e){return e[0]==="I".charCodeAt(0)&&e[1]==="D".charCodeAt(0)&&e[2]==="3".charCodeAt(0)},at=function(e,t){var i=e[t+6]<<21|e[t+7]<<14|e[t+8]<<7|e[t+9];return(16&e[t+5])>>4?i+20:i+10},st=function(e,t){var i=(224&e[t+5])>>5,n=e[t+4]<<3;return 6144&e[t+3]|n|i};(it=function(){var e=new Uint8Array,t=0;it.prototype.init.call(this),this.setTimestamp=function(e){t=e},this.push=function(i){var n,r,a,s,o=0,u=0;for(e.length?(s=e.length,(e=new Uint8Array(i.byteLength+s)).set(e.subarray(0,s)),e.set(i,s)):e=i;e.length-u>=3;)if(e[u]!=="I".charCodeAt(0)||e[u+1]!=="D".charCodeAt(0)||e[u+2]!=="3".charCodeAt(0))if(255!=(255&e[u])||240!=(240&e[u+1]))u++;else{if(e.length-u<7)break;if(u+(o=st(e,u))>e.length)break;a={type:"audio",data:e.subarray(u,u+o),pts:t,dts:t},this.trigger("data",a),u+=o}else{if(e.length-u<10)break;if(u+(o=at(e,u))>e.length)break;r={type:"timed-metadata",data:e.subarray(u,u+o)},this.trigger("data",r),u+=o}n=e.length-u,e=n>0?e.subarray(u):new Uint8Array}}).prototype=new J;var ot,ut,dt,lt,ht=it,ct=nt.H264Stream,ft=rt,pt=["audioobjecttype","channelcount","samplerate","samplingfrequencyindex","samplesize"],mt=["width","height","profileIdc","levelIdc","profileCompatibility"],gt=function(e,t){var i;if(e.length!==t.length)return!1;for(i=0;i<e.length;i++)if(e[i]!==t[i])return!1;return!0},yt=function(e,t,i,n,r,a){return{start:{dts:e,pts:e+(i-t)},end:{dts:e+(n-t),pts:e+(r-i)},prependedContentDuration:a,baseMediaDecodeTime:e}};(ut=function(e,t){var i=[],n=0,r=0,a=0,s=1/0;t=t||{},ut.prototype.init.call(this),this.push=function(t){ve(e,t),e&&pt.forEach(function(i){e[i]=t[i]}),i.push(t)},this.setEarliestDts=function(t){r=t-e.timelineStartInfo.baseMediaDecodeTime},this.setVideoBaseMediaDecodeTime=function(e){s=e},this.setAudioAppendStart=function(e){a=e},this.flush=function(){var o,u,d,l;0!==i.length?(o=pe(i,e,r),e.baseMediaDecodeTime=_e(e,t.keepOriginalTimestamps),fe(e,o,a,s),e.samples=me(o),d=j.mdat(ge(o)),i=[],u=j.moof(n,[e]),l=new Uint8Array(u.byteLength+d.byteLength),n++,l.set(u),l.set(d,u.byteLength),ye(e),this.trigger("data",{track:e,boxes:l}),this.trigger("done","AudioSegmentStream")):this.trigger("done","AudioSegmentStream")}}).prototype=new J,(ot=function(e,t){var i,n,r=0,a=[],s=[];t=t||{},ot.prototype.init.call(this),delete e.minPTS,this.gopCache_=[],this.push=function(t){ve(e,t),"seq_parameter_set_rbsp"!==t.nalUnitType||i||(i=t.config,e.sps=[t.data],mt.forEach(function(t){e[t]=i[t]},this)),"pic_parameter_set_rbsp"!==t.nalUnitType||n||(n=t.data,e.pps=[t.data]),a.push(t)},this.flush=function(){for(var i,n,o,u,d,l,h,c,f=0;a.length&&"access_unit_delimiter_rbsp"!==a[0].nalUnitType;)a.shift();if(0===a.length)return this.resetStream_(),void this.trigger("done","VideoSegmentStream");if(i=te(a),(o=ie(i))[0][0].keyFrame||((n=this.getGopForFusion_(a[0],e))?(f=n.duration,o.unshift(n),o.byteLength+=n.byteLength,o.nalCount+=n.nalCount,o.pts=n.pts,o.dts=n.dts,o.duration+=n.duration):o=ne(o)),s.length){var p;if(!(p=t.alignGopsAtEnd?this.alignGopsAtEnd_(o):this.alignGopsAtStart_(o)))return this.gopCache_.unshift({gop:o.pop(),pps:e.pps,sps:e.sps}),this.gopCache_.length=Math.min(6,this.gopCache_.length),a=[],this.resetStream_(),void this.trigger("done","VideoSegmentStream");ye(e),o=p}ve(e,o),e.samples=re(o),d=j.mdat(ae(o)),e.baseMediaDecodeTime=_e(e,t.keepOriginalTimestamps),this.trigger("processedGopsInfo",o.map(function(e){return{pts:e.pts,dts:e.dts,byteLength:e.byteLength}})),h=o[0],c=o[o.length-1],this.trigger("segmentTimingInfo",yt(e.baseMediaDecodeTime,h.dts,h.pts,c.dts+c.duration,c.pts+c.duration,f)),this.gopCache_.unshift({gop:o.pop(),pps:e.pps,sps:e.sps}),this.gopCache_.length=Math.min(6,this.gopCache_.length),a=[],this.trigger("baseMediaDecodeTime",e.baseMediaDecodeTime),this.trigger("timelineStartInfo",e.timelineStartInfo),u=j.moof(r,[e]),l=new Uint8Array(u.byteLength+d.byteLength),r++,l.set(u),l.set(d,u.byteLength),this.trigger("data",{track:e,boxes:l}),this.resetStream_(),this.trigger("done","VideoSegmentStream")},this.resetStream_=function(){ye(e),i=void 0,n=void 0},this.getGopForFusion_=function(t){var i,n,r,a,s,o=1/0;for(s=0;s<this.gopCache_.length;s++)r=(a=this.gopCache_[s]).gop,e.pps&&gt(e.pps[0],a.pps[0])&&e.sps&&gt(e.sps[0],a.sps[0])&&(r.dts<e.timelineStartInfo.dts||(i=t.dts-r.dts-r.duration)>=-1e4&&i<=45e3&&(!n||o>i)&&(n=a,o=i));return n?n.gop:null},this.alignGopsAtStart_=function(e){var t,i,n,r,a,o,u,d;for(a=e.byteLength,o=e.nalCount,u=e.duration,t=i=0;t<s.length&&i<e.length&&(n=s[t],r=e[i],n.pts!==r.pts);)r.pts>n.pts?t++:(i++,a-=r.byteLength,o-=r.nalCount,u-=r.duration);return 0===i?e:i===e.length?null:((d=e.slice(i)).byteLength=a,d.duration=u,d.nalCount=o,d.pts=d[0].pts,d.dts=d[0].dts,d)},this.alignGopsAtEnd_=function(e){var t,i,n,r,a,o,u;for(t=s.length-1,i=e.length-1,a=null,o=!1;t>=0&&i>=0;){if(n=s[t],r=e[i],n.pts===r.pts){o=!0;break}n.pts>r.pts?t--:(t===s.length-1&&(a=i),i--)}if(!o&&null===a)return null;if(0===(u=o?i:a))return e;var d=e.slice(u),l=d.reduce(function(e,t){return e.byteLength+=t.byteLength,e.duration+=t.duration,e.nalCount+=t.nalCount,e},{byteLength:0,duration:0,nalCount:0});return d.byteLength=l.byteLength,d.duration=l.duration,d.nalCount=l.nalCount,d.pts=d[0].pts,d.dts=d[0].dts,d},this.alignGopsWith=function(e){s=e}}).prototype=new J,(lt=function(e,t){this.numberOfTracks=0,this.metadataStream=t,void 0!==(e=e||{}).remux?this.remuxTracks=!!e.remux:this.remuxTracks=!0,"boolean"==typeof e.keepOriginalTimestamps&&(this.keepOriginalTimestamps=e.keepOriginalTimestamps),this.pendingTracks=[],this.videoTrack=null,this.pendingBoxes=[],this.pendingCaptions=[],this.pendingMetadata=[],this.pendingBytes=0,this.emittedTracks=0,lt.prototype.init.call(this),this.push=function(e){return e.text?this.pendingCaptions.push(e):e.frames?this.pendingMetadata.push(e):(this.pendingTracks.push(e.track),this.pendingBoxes.push(e.boxes),this.pendingBytes+=e.boxes.byteLength,"video"===e.track.type&&(this.videoTrack=e.track),void("audio"===e.track.type&&(this.audioTrack=e.track)))}}).prototype=new J,lt.prototype.flush=function(e){var t,i,n,r,a=0,s={captions:[],captionStreams:{},metadata:[],info:{}},o=0;if(this.pendingTracks.length<this.numberOfTracks){if("VideoSegmentStream"!==e&&"AudioSegmentStream"!==e)return;if(this.remuxTracks)return;if(0===this.pendingTracks.length)return this.emittedTracks++,void(this.emittedTracks>=this.numberOfTracks&&(this.trigger("done"),this.emittedTracks=0))}for(this.videoTrack?(o=this.videoTrack.timelineStartInfo.pts,mt.forEach(function(e){s.info[e]=this.videoTrack[e]},this)):this.audioTrack&&(o=this.audioTrack.timelineStartInfo.pts,pt.forEach(function(e){s.info[e]=this.audioTrack[e]},this)),1===this.pendingTracks.length?s.type=this.pendingTracks[0].type:s.type="combined",this.emittedTracks+=this.pendingTracks.length,n=j.initSegment(this.pendingTracks),s.initSegment=new Uint8Array(n.byteLength),s.initSegment.set(n),s.data=new Uint8Array(this.pendingBytes),r=0;r<this.pendingBoxes.length;r++)s.data.set(this.pendingBoxes[r],a),a+=this.pendingBoxes[r].byteLength;for(r=0;r<this.pendingCaptions.length;r++)(t=this.pendingCaptions[r]).startTime=t.startPts,this.keepOriginalTimestamps||(t.startTime-=o),t.startTime/=9e4,t.endTime=t.endPts,this.keepOriginalTimestamps||(t.endTime-=o),t.endTime/=9e4,s.captionStreams[t.stream]=!0,s.captions.push(t);for(r=0;r<this.pendingMetadata.length;r++)(i=this.pendingMetadata[r]).cueTime=i.pts,this.keepOriginalTimestamps||(i.cueTime-=o),i.cueTime/=9e4,s.metadata.push(i);s.metadata.dispatchType=this.metadataStream.dispatchType,this.pendingTracks.length=0,this.videoTrack=null,this.pendingBoxes.length=0,this.pendingCaptions.length=0,this.pendingBytes=0,this.pendingMetadata.length=0,this.trigger("data",s),this.emittedTracks>=this.numberOfTracks&&(this.trigger("done"),this.emittedTracks=0)},(dt=function(e){var t,i,n=this,r=!0;dt.prototype.init.call(this),e=e||{},this.baseMediaDecodeTime=e.baseMediaDecodeTime||0,this.transmuxPipeline_={},this.setupAacPipeline=function(){var t={};this.transmuxPipeline_=t,t.type="aac",t.metadataStream=new $e.MetadataStream,t.aacStream=new ht,t.audioTimestampRolloverStream=new $e.TimestampRolloverStream("audio"),t.timedMetadataTimestampRolloverStream=new $e.TimestampRolloverStream("timed-metadata"),t.adtsStream=new et,t.coalesceStream=new lt(e,t.metadataStream),t.headOfPipeline=t.aacStream,t.aacStream.pipe(t.audioTimestampRolloverStream).pipe(t.adtsStream),t.aacStream.pipe(t.timedMetadataTimestampRolloverStream).pipe(t.metadataStream).pipe(t.coalesceStream),t.metadataStream.on("timestamp",function(e){t.aacStream.setTimestamp(e.timeStamp)}),t.aacStream.on("data",function(r){"timed-metadata"!==r.type||t.audioSegmentStream||(i=i||{timelineStartInfo:{baseMediaDecodeTime:n.baseMediaDecodeTime},codec:"adts",type:"audio"},t.coalesceStream.numberOfTracks++,t.audioSegmentStream=new ut(i,e),t.adtsStream.pipe(t.audioSegmentStream).pipe(t.coalesceStream))}),t.coalesceStream.on("data",this.trigger.bind(this,"data")),t.coalesceStream.on("done",this.trigger.bind(this,"done"))},this.setupTsPipeline=function(){var r={};this.transmuxPipeline_=r,r.type="ts",r.metadataStream=new $e.MetadataStream,r.packetStream=new $e.TransportPacketStream,r.parseStream=new $e.TransportParseStream,r.elementaryStream=new $e.ElementaryStream,r.videoTimestampRolloverStream=new $e.TimestampRolloverStream("video"),r.audioTimestampRolloverStream=new $e.TimestampRolloverStream("audio"),r.timedMetadataTimestampRolloverStream=new $e.TimestampRolloverStream("timed-metadata"),r.adtsStream=new et,r.h264Stream=new ct,r.captionStream=new $e.CaptionStream,r.coalesceStream=new lt(e,r.metadataStream),r.headOfPipeline=r.packetStream,r.packetStream.pipe(r.parseStream).pipe(r.elementaryStream),r.elementaryStream.pipe(r.videoTimestampRolloverStream).pipe(r.h264Stream),r.elementaryStream.pipe(r.audioTimestampRolloverStream).pipe(r.adtsStream),r.elementaryStream.pipe(r.timedMetadataTimestampRolloverStream).pipe(r.metadataStream).pipe(r.coalesceStream),r.h264Stream.pipe(r.captionStream).pipe(r.coalesceStream),r.elementaryStream.on("data",function(a){var s;if("metadata"===a.type){for(s=a.tracks.length;s--;)t||"video"!==a.tracks[s].type?i||"audio"!==a.tracks[s].type||((i=a.tracks[s]).timelineStartInfo.baseMediaDecodeTime=n.baseMediaDecodeTime):(t=a.tracks[s]).timelineStartInfo.baseMediaDecodeTime=n.baseMediaDecodeTime;t&&!r.videoSegmentStream&&(r.coalesceStream.numberOfTracks++,r.videoSegmentStream=new ot(t,e),r.videoSegmentStream.on("timelineStartInfo",function(e){i&&(i.timelineStartInfo=e,r.audioSegmentStream.setEarliestDts(e.dts))}),r.videoSegmentStream.on("processedGopsInfo",n.trigger.bind(n,"gopInfo")),r.videoSegmentStream.on("segmentTimingInfo",n.trigger.bind(n,"videoSegmentTimingInfo")),r.videoSegmentStream.on("baseMediaDecodeTime",function(e){i&&r.audioSegmentStream.setVideoBaseMediaDecodeTime(e)}),r.h264Stream.pipe(r.videoSegmentStream).pipe(r.coalesceStream)),i&&!r.audioSegmentStream&&(r.coalesceStream.numberOfTracks++,r.audioSegmentStream=new ut(i,e),r.adtsStream.pipe(r.audioSegmentStream).pipe(r.coalesceStream))}}),r.coalesceStream.on("data",this.trigger.bind(this,"data")),r.coalesceStream.on("done",this.trigger.bind(this,"done"))},this.setBaseMediaDecodeTime=function(n){var r=this.transmuxPipeline_;e.keepOriginalTimestamps||(this.baseMediaDecodeTime=n),i&&(i.timelineStartInfo.dts=void 0,i.timelineStartInfo.pts=void 0,ye(i),e.keepOriginalTimestamps||(i.timelineStartInfo.baseMediaDecodeTime=n),r.audioTimestampRolloverStream&&r.audioTimestampRolloverStream.discontinuity()),t&&(r.videoSegmentStream&&(r.videoSegmentStream.gopCache_=[],r.videoTimestampRolloverStream.discontinuity()),t.timelineStartInfo.dts=void 0,t.timelineStartInfo.pts=void 0,ye(t),r.captionStream.reset(),e.keepOriginalTimestamps||(t.timelineStartInfo.baseMediaDecodeTime=n)),r.timedMetadataTimestampRolloverStream&&r.timedMetadataTimestampRolloverStream.discontinuity()},this.setAudioAppendStart=function(e){i&&this.transmuxPipeline_.audioSegmentStream.setAudioAppendStart(e)},this.alignGopsWith=function(e){t&&this.transmuxPipeline_.videoSegmentStream&&this.transmuxPipeline_.videoSegmentStream.alignGopsWith(e)},this.push=function(e){if(r){var t=ft(e);t&&"aac"!==this.transmuxPipeline_.type?this.setupAacPipeline():t||"ts"===this.transmuxPipeline_.type||this.setupTsPipeline(),r=!1}this.transmuxPipeline_.headOfPipeline.push(e)},this.flush=function(){r=!0,this.transmuxPipeline_.headOfPipeline.flush()},this.resetCaptions=function(){this.transmuxPipeline_.captionStream&&this.transmuxPipeline_.captionStream.reset()}}).prototype=new J;var _t,vt,bt={Transmuxer:dt,VideoSegmentStream:ot,AudioSegmentStream:ut,AUDIO_PROPERTIES:pt,VIDEO_PROPERTIES:mt,generateVideoSegmentTimingInfo:yt},Tt=W.parseType,St=function(e){return new Date(1e3*e-20828448e5)},kt=function(e){return{isLeading:(12&e[0])>>>2,dependsOn:3&e[0],isDependedOn:(192&e[1])>>>6,hasRedundancy:(48&e[1])>>>4,paddingValue:(14&e[1])>>>1,isNonSyncSample:1&e[1],degradationPriority:e[2]<<8|e[3]}},wt={avc1:function(e){var t=new DataView(e.buffer,e.byteOffset,e.byteLength);return{dataReferenceIndex:t.getUint16(6),width:t.getUint16(24),height:t.getUint16(26),horizresolution:t.getUint16(28)+t.getUint16(30)/16,vertresolution:t.getUint16(32)+t.getUint16(34)/16,frameCount:t.getUint16(40),depth:t.getUint16(74),config:_t(e.subarray(78,e.byteLength))}},avcC:function(e){var t,i,n,r,a=new DataView(e.buffer,e.byteOffset,e.byteLength),s={configurationVersion:e[0],avcProfileIndication:e[1],profileCompatibility:e[2],avcLevelIndication:e[3],lengthSizeMinusOne:3&e[4],sps:[],pps:[]},o=31&e[5];for(n=6,r=0;r<o;r++)i=a.getUint16(n),n+=2,s.sps.push(new Uint8Array(e.subarray(n,n+i))),n+=i;for(t=e[n],n++,r=0;r<t;r++)i=a.getUint16(n),n+=2,s.pps.push(new Uint8Array(e.subarray(n,n+i))),n+=i;return s},btrt:function(e){var t=new DataView(e.buffer,e.byteOffset,e.byteLength);return{bufferSizeDB:t.getUint32(0),maxBitrate:t.getUint32(4),avgBitrate:t.getUint32(8)}},esds:function(e){return{version:e[0],flags:new Uint8Array(e.subarray(1,4)),esId:e[6]<<8|e[7],streamPriority:31&e[8],decoderConfig:{objectProfileIndication:e[11],streamType:e[12]>>>2&63,bufferSize:e[13]<<16|e[14]<<8|e[15],maxBitrate:e[16]<<24|e[17]<<16|e[18]<<8|e[19],avgBitrate:e[20]<<24|e[21]<<16|e[22]<<8|e[23],decoderConfigDescriptor:{tag:e[24],length:e[25],audioObjectType:e[26]>>>3&31,samplingFrequencyIndex:(7&e[26])<<1|e[27]>>>7&1,channelConfiguration:e[27]>>>3&15}}}},ftyp:function(e){for(var t=new DataView(e.buffer,e.byteOffset,e.byteLength),i={majorBrand:Tt(e.subarray(0,4)),minorVersion:t.getUint32(4),compatibleBrands:[]},n=8;n<e.byteLength;)i.compatibleBrands.push(Tt(e.subarray(n,n+4))),n+=4;return i},dinf:function(e){return{boxes:_t(e)}},dref:function(e){return{version:e[0],flags:new Uint8Array(e.subarray(1,4)),dataReferences:_t(e.subarray(8))}},hdlr:function(e){var t={version:new DataView(e.buffer,e.byteOffset,e.byteLength).getUint8(0),flags:new Uint8Array(e.subarray(1,4)),handlerType:Tt(e.subarray(8,12)),name:""},i=8;for(i=24;i<e.byteLength;i++){if(0===e[i]){i++;break}t.name+=String.fromCharCode(e[i])}return t.name=decodeURIComponent(escape(t.name)),t},mdat:function(e){return{byteLength:e.byteLength,nals:function(e){var t,i,n=new DataView(e.buffer,e.byteOffset,e.byteLength),r=[];for(t=0;t+4<e.length;t+=i)if(i=n.getUint32(t),t+=4,i<=0)r.push("<span style='color:red;'>MALFORMED DATA</span>");else switch(31&e[t]){case 1:r.push("slice_layer_without_partitioning_rbsp");break;case 5:r.push("slice_layer_without_partitioning_rbsp_idr");break;case 6:r.push("sei_rbsp");break;case 7:r.push("seq_parameter_set_rbsp");break;case 8:r.push("pic_parameter_set_rbsp");break;case 9:r.push("access_unit_delimiter_rbsp");break;default:r.push("UNKNOWN NAL - "+e[t]&31)}return r}(e)}},mdhd:function(e){var t,i=new DataView(e.buffer,e.byteOffset,e.byteLength),n=4,r={version:i.getUint8(0),flags:new Uint8Array(e.subarray(1,4)),language:""};return 1===r.version?(n+=4,r.creationTime=St(i.getUint32(n)),n+=8,r.modificationTime=St(i.getUint32(n)),n+=4,r.timescale=i.getUint32(n),n+=8,r.duration=i.getUint32(n)):(r.creationTime=St(i.getUint32(n)),n+=4,r.modificationTime=St(i.getUint32(n)),n+=4,r.timescale=i.getUint32(n),n+=4,r.duration=i.getUint32(n)),n+=4,t=i.getUint16(n),r.language+=String.fromCharCode(96+(t>>10)),r.language+=String.fromCharCode(96+((992&t)>>5)),r.language+=String.fromCharCode(96+(31&t)),r},mdia:function(e){return{boxes:_t(e)}},mfhd:function(e){return{version:e[0],flags:new Uint8Array(e.subarray(1,4)),sequenceNumber:e[4]<<24|e[5]<<16|e[6]<<8|e[7]}},minf:function(e){return{boxes:_t(e)}},mp4a:function(e){var t=new DataView(e.buffer,e.byteOffset,e.byteLength),i={dataReferenceIndex:t.getUint16(6),channelcount:t.getUint16(16),samplesize:t.getUint16(18),samplerate:t.getUint16(24)+t.getUint16(26)/65536};return e.byteLength>28&&(i.streamDescriptor=_t(e.subarray(28))[0]),i},moof:function(e){return{boxes:_t(e)}},moov:function(e){return{boxes:_t(e)}},mvex:function(e){return{boxes:_t(e)}},mvhd:function(e){var t=new DataView(e.buffer,e.byteOffset,e.byteLength),i=4,n={version:t.getUint8(0),flags:new Uint8Array(e.subarray(1,4))};return 1===n.version?(i+=4,n.creationTime=St(t.getUint32(i)),i+=8,n.modificationTime=St(t.getUint32(i)),i+=4,n.timescale=t.getUint32(i),i+=8,n.duration=t.getUint32(i)):(n.creationTime=St(t.getUint32(i)),i+=4,n.modificationTime=St(t.getUint32(i)),i+=4,n.timescale=t.getUint32(i),i+=4,n.duration=t.getUint32(i)),i+=4,n.rate=t.getUint16(i)+t.getUint16(i+2)/16,i+=4,n.volume=t.getUint8(i)+t.getUint8(i+1)/8,i+=2,i+=2,i+=8,n.matrix=new Uint32Array(e.subarray(i,i+36)),i+=36,i+=24,n.nextTrackId=t.getUint32(i),n},pdin:function(e){var t=new DataView(e.buffer,e.byteOffset,e.byteLength);return{version:t.getUint8(0),flags:new Uint8Array(e.subarray(1,4)),rate:t.getUint32(4),initialDelay:t.getUint32(8)}},sdtp:function(e){var t,i={version:e[0],flags:new Uint8Array(e.subarray(1,4)),samples:[]};for(t=4;t<e.byteLength;t++)i.samples.push({dependsOn:(48&e[t])>>4,isDependedOn:(12&e[t])>>2,hasRedundancy:3&e[t]});return i},sidx:function(e){var t,i=new DataView(e.buffer,e.byteOffset,e.byteLength),n={version:e[0],flags:new Uint8Array(e.subarray(1,4)),references:[],referenceId:i.getUint32(4),timescale:i.getUint32(8),earliestPresentationTime:i.getUint32(12),firstOffset:i.getUint32(16)},r=i.getUint16(22);for(t=24;r;t+=12,r--)n.references.push({referenceType:(128&e[t])>>>7,referencedSize:2147483647&i.getUint32(t),subsegmentDuration:i.getUint32(t+4),startsWithSap:!!(128&e[t+8]),sapType:(112&e[t+8])>>>4,sapDeltaTime:268435455&i.getUint32(t+8)});return n},smhd:function(e){return{version:e[0],flags:new Uint8Array(e.subarray(1,4)),balance:e[4]+e[5]/256}},stbl:function(e){return{boxes:_t(e)}},stco:function(e){var t,i=new DataView(e.buffer,e.byteOffset,e.byteLength),n={version:e[0],flags:new Uint8Array(e.subarray(1,4)),chunkOffsets:[]},r=i.getUint32(4);for(t=8;r;t+=4,r--)n.chunkOffsets.push(i.getUint32(t));return n},stsc:function(e){var t,i=new DataView(e.buffer,e.byteOffset,e.byteLength),n=i.getUint32(4),r={version:e[0],flags:new Uint8Array(e.subarray(1,4)),sampleToChunks:[]};for(t=8;n;t+=12,n--)r.sampleToChunks.push({firstChunk:i.getUint32(t),samplesPerChunk:i.getUint32(t+4),sampleDescriptionIndex:i.getUint32(t+8)});return r},stsd:function(e){return{version:e[0],flags:new Uint8Array(e.subarray(1,4)),sampleDescriptions:_t(e.subarray(8))}},stsz:function(e){var t,i=new DataView(e.buffer,e.byteOffset,e.byteLength),n={version:e[0],flags:new Uint8Array(e.subarray(1,4)),sampleSize:i.getUint32(4),entries:[]};for(t=12;t<e.byteLength;t+=4)n.entries.push(i.getUint32(t));return n},stts:function(e){var t,i=new DataView(e.buffer,e.byteOffset,e.byteLength),n={version:e[0],flags:new Uint8Array(e.subarray(1,4)),timeToSamples:[]},r=i.getUint32(4);for(t=8;r;t+=8,r--)n.timeToSamples.push({sampleCount:i.getUint32(t),sampleDelta:i.getUint32(t+4)});return n},styp:function(e){return wt.ftyp(e)},tfdt:function(e){var t={version:e[0],flags:new Uint8Array(e.subarray(1,4)),baseMediaDecodeTime:e[4]<<24|e[5]<<16|e[6]<<8|e[7]};return 1===t.version&&(t.baseMediaDecodeTime*=Math.pow(2,32),t.baseMediaDecodeTime+=e[8]<<24|e[9]<<16|e[10]<<8|e[11]),t},tfhd:function(e){var t,i=new DataView(e.buffer,e.byteOffset,e.byteLength),n={version:e[0],flags:new Uint8Array(e.subarray(1,4)),trackId:i.getUint32(4)},r=1&n.flags[2],a=2&n.flags[2],s=8&n.flags[2],o=16&n.flags[2],u=32&n.flags[2],d=65536&n.flags[0],l=131072&n.flags[0];return t=8,r&&(t+=4,n.baseDataOffset=i.getUint32(12),t+=4),a&&(n.sampleDescriptionIndex=i.getUint32(t),t+=4),s&&(n.defaultSampleDuration=i.getUint32(t),t+=4),o&&(n.defaultSampleSize=i.getUint32(t),t+=4),u&&(n.defaultSampleFlags=i.getUint32(t)),d&&(n.durationIsEmpty=!0),!r&&l&&(n.baseDataOffsetIsMoof=!0),n},tkhd:function(e){var t=new DataView(e.buffer,e.byteOffset,e.byteLength),i=4,n={version:t.getUint8(0),flags:new Uint8Array(e.subarray(1,4))};return 1===n.version?(i+=4,n.creationTime=St(t.getUint32(i)),i+=8,n.modificationTime=St(t.getUint32(i)),i+=4,n.trackId=t.getUint32(i),i+=4,i+=8,n.duration=t.getUint32(i)):(n.creationTime=St(t.getUint32(i)),i+=4,n.modificationTime=St(t.getUint32(i)),i+=4,n.trackId=t.getUint32(i),i+=4,i+=4,n.duration=t.getUint32(i)),i+=4,i+=8,n.layer=t.getUint16(i),i+=2,n.alternateGroup=t.getUint16(i),i+=2,n.volume=t.getUint8(i)+t.getUint8(i+1)/8,i+=2,i+=2,n.matrix=new Uint32Array(e.subarray(i,i+36)),i+=36,n.width=t.getUint16(i)+t.getUint16(i+2)/16,i+=4,n.height=t.getUint16(i)+t.getUint16(i+2)/16,n},traf:function(e){return{boxes:_t(e)}},trak:function(e){return{boxes:_t(e)}},trex:function(e){var t=new DataView(e.buffer,e.byteOffset,e.byteLength);return{version:e[0],flags:new Uint8Array(e.subarray(1,4)),trackId:t.getUint32(4),defaultSampleDescriptionIndex:t.getUint32(8),defaultSampleDuration:t.getUint32(12),defaultSampleSize:t.getUint32(16),sampleDependsOn:3&e[20],sampleIsDependedOn:(192&e[21])>>6,sampleHasRedundancy:(48&e[21])>>4,samplePaddingValue:(14&e[21])>>1,sampleIsDifferenceSample:!!(1&e[21]),sampleDegradationPriority:t.getUint16(22)}},trun:function(e){var t,i={version:e[0],flags:new Uint8Array(e.subarray(1,4)),samples:[]},n=new DataView(e.buffer,e.byteOffset,e.byteLength),r=1&i.flags[2],a=4&i.flags[2],s=1&i.flags[1],o=2&i.flags[1],u=4&i.flags[1],d=8&i.flags[1],l=n.getUint32(4),h=8;for(r&&(i.dataOffset=n.getInt32(h),h+=4),a&&l&&(t={flags:kt(e.subarray(h,h+4))},h+=4,s&&(t.duration=n.getUint32(h),h+=4),o&&(t.size=n.getUint32(h),h+=4),d&&(t.compositionTimeOffset=n.getUint32(h),h+=4),i.samples.push(t),l--);l--;)t={},s&&(t.duration=n.getUint32(h),h+=4),o&&(t.size=n.getUint32(h),h+=4),u&&(t.flags=kt(e.subarray(h,h+4)),h+=4),d&&(t.compositionTimeOffset=n.getUint32(h),h+=4),i.samples.push(t);return i},"url ":function(e){return{version:e[0],flags:new Uint8Array(e.subarray(1,4))}},vmhd:function(e){var t=new DataView(e.buffer,e.byteOffset,e.byteLength);return{version:e[0],flags:new Uint8Array(e.subarray(1,4)),graphicsmode:t.getUint16(4),opcolor:new Uint16Array([t.getUint16(6),t.getUint16(8),t.getUint16(10)])}}},Ut={inspect:_t=function(e){for(var t,i,n,r,a,s=0,o=[],u=new ArrayBuffer(e.length),d=new Uint8Array(u),l=0;l<e.length;++l)d[l]=e[l];for(t=new DataView(u);s<e.byteLength;)i=t.getUint32(s),n=Tt(e.subarray(s+4,s+8)),r=i>1?s+i:e.byteLength,(a=(wt[n]||function(e){return{data:e}})(e.subarray(s+8,r))).size=i,a.type=n,o.push(a),s=r;return o},textify:vt=function(e,t){var i;return t=t||0,i=new Array(2*t+1).join(" "),e.map(function(e,n){return i+e.type+"\n"+Object.keys(e).filter(function(e){return"type"!==e&&"boxes"!==e}).map(function(t){var n=i+"  "+t+": ",r=e[t];if(r instanceof Uint8Array||r instanceof Uint32Array){var a=Array.prototype.slice.call(new Uint8Array(r.buffer,r.byteOffset,r.byteLength)).map(function(e){return" "+("00"+e.toString(16)).slice(-2)}).join("").match(/.{1,24}/g);return a?1===a.length?n+"<"+a.join("").slice(1)+">":n+"<\n"+a.map(function(e){return i+"  "+e}).join("\n")+"\n"+i+"  >":n+"<>"}return n+JSON.stringify(r,null,2).split("\n").map(function(e,t){return 0===t?e:i+"  "+e}).join("\n")}).join("\n")+(e.boxes?"\n"+vt(e.boxes,t+1):"")}).join("\n")},parseTfdt:wt.tfdt,parseHdlr:wt.hdlr,parseTfhd:wt.tfhd,parseTrun:wt.trun,parseSidx:wt.sidx},Lt=ke,At=Ce.CaptionStream,Et=function(e,t){for(var i=e,n=0;n<t.length;n++){var r=t[n];if(i<r.size)return r;i-=r.size}return null},Ot=function(e,t){var i=W.findBox(e,["moof","traf"]),n={},r=[];return W.findBox(e,["mdat"]).forEach(function(e,t){var n=i[t];r.push({mdat:e,traf:n})}),r.forEach(function(e){var i,r=e.mdat,a=e.traf,s=W.findBox(a,["tfhd"]),o=Ut.parseTfhd(s[0]),u=o.trackId,d=W.findBox(a,["tfdt"]),l=d.length>0?Ut.parseTfdt(d[0]).baseMediaDecodeTime:0,h=W.findBox(a,["trun"]);t===u&&h.length>0&&(i=function(e,t,i){var n,r,a,s,o=new DataView(e.buffer,e.byteOffset,e.byteLength),u=[];for(r=0;r+4<e.length;r+=a)if(a=o.getUint32(r),r+=4,!(a<=0))switch(31&e[r]){case 6:var d=e.subarray(r+1,r+1+a),l=Et(r,t);n={nalUnitType:"sei_rbsp",size:a,data:d,escapedRBSP:Lt(d),trackId:i},l?(n.pts=l.pts,n.dts=l.dts,s=l):(n.pts=s.pts,n.dts=s.dts),u.push(n)}return u}(r,function(e,t,i){var n=t,r=i.defaultSampleDuration||0,a=i.defaultSampleSize||0,s=i.trackId,o=[];return e.forEach(function(e){var t=Ut.parseTrun(e).samples;t.forEach(function(e){void 0===e.duration&&(e.duration=r),void 0===e.size&&(e.size=a),e.trackId=s,e.dts=n,void 0===e.compositionTimeOffset&&(e.compositionTimeOffset=0),e.pts=n+e.compositionTimeOffset,n+=e.duration}),o=o.concat(t)}),o}(h,l,o),u),n[u]||(n[u]=[]),n[u]=n[u].concat(i))}),n},It={generator:j,probe:W,Transmuxer:bt.Transmuxer,AudioSegmentStream:bt.AudioSegmentStream,VideoSegmentStream:bt.VideoSegmentStream,CaptionParser:function(){var e,t,i,n,r,a=!1;this.isInitialized=function(){return a},this.init=function(){e=new At,a=!0,e.on("data",function(e){e.startTime=e.startPts/n,e.endTime=e.endPts/n,r.captions.push(e),r.captionStreams[e.stream]=!0})},this.isNewInit=function(e,t){return!(e&&0===e.length||t&&"object"==typeof t&&0===Object.keys(t).length||i===e[0]&&n===t[i])},this.parse=function(e,a,s){var o;if(!this.isInitialized())return null;if(!a||!s)return null;if(this.isNewInit(a,s))i=a[0],n=s[i];else if(!i||!n)return t.push(e),null;for(;t.length>0;){var u=t.shift();this.parse(u,a,s)}return null!==(o=function(e,t,i){return t?{seiNals:Ot(e,t)[t],timescale:i}:null}(e,i,n))&&o.seiNals?(this.pushNals(o.seiNals),this.flushStream(),r):null},this.pushNals=function(t){if(!this.isInitialized()||!t||0===t.length)return null;t.forEach(function(t){e.push(t)})},this.flushStream=function(){if(!this.isInitialized())return null;e.flush()},this.clearParsedCaptions=function(){r.captions=[],r.captionStreams={}},this.resetCaptionStream=function(){if(!this.isInitialized())return null;e.reset()},this.clearAllCaptions=function(){this.clearParsedCaptions(),this.resetCaptionStream()},this.reset=function(){t=[],i=null,n=null,r?this.clearParsedCaptions():r={captions:[],captionStreams:{}},this.resetCaptionStream()},this.reset()}},Ct=function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")},Pt=function(){function e(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}return function(t,i,n){return i&&e(t.prototype,i),n&&e(t,n),t}}(),Dt=function(){function e(t,i){Ct(this,e),this.options=i||{},this.self=t,this.init()}return Pt(e,[{key:"init",value:function(){var e,t;this.transmuxer&&this.transmuxer.dispose(),this.transmuxer=new It.Transmuxer(this.options),e=this.self,(t=this.transmuxer).on("data",function(t){var i=t.initSegment;t.initSegment={data:i.buffer,byteOffset:i.byteOffset,byteLength:i.byteLength};var n=t.data;t.data=n.buffer,e.postMessage({action:"data",segment:t,byteOffset:n.byteOffset,byteLength:n.byteLength},[t.data])}),t.captionStream&&t.captionStream.on("data",function(t){e.postMessage({action:"caption",data:t})}),t.on("done",function(t){e.postMessage({action:"done"})}),t.on("gopInfo",function(t){e.postMessage({action:"gopInfo",gopInfo:t})}),t.on("videoSegmentTimingInfo",function(t){e.postMessage({action:"videoSegmentTimingInfo",videoSegmentTimingInfo:t})})}},{key:"push",value:function(e){var t=new Uint8Array(e.data,e.byteOffset,e.byteLength);this.transmuxer.push(t)}},{key:"reset",value:function(){this.init()}},{key:"setTimestampOffset",value:function(e){var t=e.timestampOffset||0;this.transmuxer.setBaseMediaDecodeTime(Math.round(9e4*t))}},{key:"setAudioAppendStart",value:function(e){this.transmuxer.setAudioAppendStart(Math.ceil(9e4*e.appendStart))}},{key:"flush",value:function(e){this.transmuxer.flush()}},{key:"resetCaptions",value:function(){this.transmuxer.resetCaptions()}},{key:"alignGopsWith",value:function(e){this.transmuxer.alignGopsWith(e.gopsToAlignWith.slice())}}]),e}();new function(e){e.onmessage=function(t){"init"===t.data.action&&t.data.options?this.messageHandlers=new Dt(e,t.data.options):(this.messageHandlers||(this.messageHandlers=new Dt(e)),t.data&&t.data.action&&"init"!==t.data.action&&this.messageHandlers[t.data.action]&&this.messageHandlers[t.data.action](t.data))}}(i)}()}),Ge={videoCodec:"avc1",videoObjectTypeIndicator:".4d400d",audioProfile:"2"},Ve=function(e){return e.map(function(e){return e.replace(/avc1\.(\d+)\.(\d+)/i,function(e,t,i){return"avc1."+("00"+Number(t).toString(16)).slice(-2)+"00"+("00"+Number(i).toString(16)).slice(-2)})})},He=function(){var e,t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"",i={codecCount:0};return i.codecCount=t.split(",").length,i.codecCount=i.codecCount||2,(e=/(^|\s|,)+(avc[13])([^ ,]*)/i.exec(t))&&(i.videoCodec=e[2],i.videoObjectTypeIndicator=e[3]),i.audioProfile=/(^|\s|,)+mp4a.[0-9A-Fa-f]+\.([0-9A-Fa-f]+)/i.exec(t),i.audioProfile=i.audioProfile&&i.audioProfile[2],i},je=function(e,t,i){return e+"/"+t+'; codecs="'+i.filter(function(e){return!!e}).join(", ")+'"'},ze=function(e,i){var n=function(e){return e.segments&&e.segments.length&&e.segments[0].map?"mp4":"mp2t"}(i),r=function(e){var t=e.attributes||{};return t.CODECS?He(t.CODECS):Ge}(i),a=i.attributes||{},s=!0,o=!1;if(!i)return[];if(e.mediaGroups.AUDIO&&a.AUDIO){var u=e.mediaGroups.AUDIO[a.AUDIO];if(u)for(var d in o=!0,s=!1,u)if(!u[d].uri&&!u[d].playlists){s=!0;break}}o&&!r.audioProfile&&(s||(r.audioProfile=function(e,t){if(!e.mediaGroups.AUDIO||!t)return null;var i=e.mediaGroups.AUDIO[t];if(!i)return null;for(var n in i){var r=i[n];if(r.default&&r.playlists)return He(r.playlists[0].attributes.CODECS).audioProfile}return null}(e,a.AUDIO)),r.audioProfile||(t.log.warn("Multiple audio tracks present but no audio codec string is specified. Attempting to use the default audio codec (mp4a.40.2)"),r.audioProfile=Ge.audioProfile));var l={};r.videoCodec&&(l.video=""+r.videoCodec+r.videoObjectTypeIndicator),r.audioProfile&&(l.audio="mp4a.40."+r.audioProfile);var h=je("audio",n,[l.audio]),c=je("video",n,[l.video]),f=je("video",n,[l.video,l.audio]);return o?!s&&l.video?[c,h]:s||l.video?[f,h]:[h,h]:l.video?[f]:[h]},We=function(e){return/mp4a\.\d+.\d+/i.test(e)},Xe=function(e){return/avc1\.[\da-f]+/i.test(e)},Ye=function(e,i,n){var r=null,a=null,s=0,o=[],u=[];if(!e&&!i)return t.createTimeRange();if(!e)return i.buffered;if(!i)return e.buffered;if(n)return e.buffered;if(0===e.buffered.length&&0===i.buffered.length)return t.createTimeRange();for(var d=e.buffered,l=i.buffered,h=d.length;h--;)o.push({time:d.start(h),type:"start"}),o.push({time:d.end(h),type:"end"});for(h=l.length;h--;)o.push({time:l.start(h),type:"start"}),o.push({time:l.end(h),type:"end"});for(o.sort(function(e,t){return e.time-t.time}),h=0;h<o.length;h++)"start"===o[h].type?2===++s&&(r=o[h].time):"end"===o[h].type&&1===--s&&(a=o[h].time),null!==r&&null!==a&&(u.push([r,a]),r=null,a=null);return t.createTimeRanges(u)},$e=function(e){function i(e,n){S(this,i);var r=U(this,(i.__proto__||Object.getPrototypeOf(i)).call(this,t.EventTarget));r.timestampOffset_=0,r.pendingBuffers_=[],r.bufferUpdating_=!1,r.mediaSource_=e,r.codecs_=n,r.audioCodec_=null,r.videoCodec_=null,r.audioDisabled_=!1,r.appendAudioInitSegment_=!0,r.gopBuffer_=[],r.timeMapping_=0,r.safeAppend_=t.browser.IE_VERSION>=11;var a={remux:!1,alignGopsAtEnd:r.safeAppend_};return r.codecs_.forEach(function(e){We(e)?r.audioCodec_=e:Xe(e)&&(r.videoCodec_=e)}),r.transmuxer_=new Fe,r.transmuxer_.postMessage({action:"init",options:a}),r.transmuxer_.onmessage=function(e){return"data"===e.data.action?r.data_(e):"done"===e.data.action?r.done_(e):"gopInfo"===e.data.action?r.appendGopInfo_(e):"videoSegmentTimingInfo"===e.data.action?r.videoSegmentTimingInfo_(e.data.videoSegmentTimingInfo):void 0},Object.defineProperty(r,"timestampOffset",{get:function(){return this.timestampOffset_},set:function(e){"number"==typeof e&&e>=0&&(this.timestampOffset_=e,this.appendAudioInitSegment_=!0,this.gopBuffer_.length=0,this.timeMapping_=0,this.transmuxer_.postMessage({action:"setTimestampOffset",timestampOffset:e}))}}),Object.defineProperty(r,"appendWindowStart",{get:function(){return(this.videoBuffer_||this.audioBuffer_).appendWindowStart},set:function(e){this.videoBuffer_&&(this.videoBuffer_.appendWindowStart=e),this.audioBuffer_&&(this.audioBuffer_.appendWindowStart=e)}}),Object.defineProperty(r,"updating",{get:function(){return!!(this.bufferUpdating_||!this.audioDisabled_&&this.audioBuffer_&&this.audioBuffer_.updating||this.videoBuffer_&&this.videoBuffer_.updating)}}),Object.defineProperty(r,"buffered",{get:function(){return Ye(this.videoBuffer_,this.audioBuffer_,this.audioDisabled_)}}),r}return w(i,e),k(i,[{key:"data_",value:function(e){var t=e.data.segment;t.data=new Uint8Array(t.data,e.data.byteOffset,e.data.byteLength),t.initSegment=new Uint8Array(t.initSegment.data,t.initSegment.byteOffset,t.initSegment.byteLength),function(e,t,i){var n=t.player_;if(i.captions&&i.captions.length)for(var r in e.inbandTextTracks_||(e.inbandTextTracks_={}),i.captionStreams)if(!e.inbandTextTracks_[r]){n.tech_.trigger({type:"usage",name:"hls-608"});var a=n.textTracks().getTrackById(r);e.inbandTextTracks_[r]=a||n.addRemoteTextTrack({kind:"captions",id:r,label:r},!1).track}i.metadata&&i.metadata.length&&!e.metadataTrack_&&(e.metadataTrack_=n.addRemoteTextTrack({kind:"metadata",label:"Timed Metadata"},!1).track,e.metadataTrack_.inBandMetadataTrackDispatchType=i.metadata.dispatchType)}(this,this.mediaSource_,t),this.pendingBuffers_.push(t)}},{key:"done_",value:function(e){"closed"!==this.mediaSource_.readyState?this.processPendingSegments_():this.pendingBuffers_.length=0}},{key:"videoSegmentTimingInfo_",value:function(e){var t={start:{decode:e.start.dts/9e4,presentation:e.start.pts/9e4},end:{decode:e.end.dts/9e4,presentation:e.end.pts/9e4},baseMediaDecodeTime:e.baseMediaDecodeTime/9e4};e.prependedContentDuration&&(t.prependedContentDuration=e.prependedContentDuration/9e4),this.trigger({type:"videoSegmentTimingInfo",videoSegmentTimingInfo:t})}},{key:"createRealSourceBuffers_",value:function(){var e=this,t=["audio","video"];t.forEach(function(i){if(e[i+"Codec_"]&&!e[i+"Buffer_"]){var n=null;if(e.mediaSource_[i+"Buffer_"])(n=e.mediaSource_[i+"Buffer_"]).updating=!1;else{var r=i+'/mp4;codecs="'+e[i+"Codec_"]+'"';n=function(e,t){var i=e.addSourceBuffer(t),n=Object.create(null);n.updating=!1,n.realBuffer_=i;var r=function(e){"function"==typeof i[e]?n[e]=function(){return i[e].apply(i,arguments)}:void 0===n[e]&&Object.defineProperty(n,e,{get:function(){return i[e]},set:function(t){return i[e]=t}})};for(var a in i)r(a);return n}(e.mediaSource_.nativeMediaSource_,r),e.mediaSource_[i+"Buffer_"]=n}e[i+"Buffer_"]=n,["update","updatestart","updateend"].forEach(function(r){n.addEventListener(r,function(){if("audio"!==i||!e.audioDisabled_)return"updateend"===r&&(e[i+"Buffer_"].updating=!1),t.every(function(t){return!("audio"!==t||!e.audioDisabled_)||(i===t||!e[t+"Buffer_"]||!e[t+"Buffer_"].updating)})?e.trigger(r):void 0})})}})}},{key:"appendBuffer",value:function(e){if(this.bufferUpdating_=!0,this.audioBuffer_&&this.audioBuffer_.buffered.length){var t=this.audioBuffer_.buffered;this.transmuxer_.postMessage({action:"setAudioAppendStart",appendStart:t.end(t.length-1)})}this.videoBuffer_&&this.transmuxer_.postMessage({action:"alignGopsWith",gopsToAlignWith:function(e,t,i){if(void 0===t||null===t||!e.length)return[];var n=Math.ceil(9e4*(t-i+3)),r=void 0;for(r=0;r<e.length&&!(e[r].pts>n);r++);return e.slice(r)}(this.gopBuffer_,this.mediaSource_.player_?this.mediaSource_.player_.currentTime():null,this.timeMapping_)}),this.transmuxer_.postMessage({action:"push",data:e.buffer,byteOffset:e.byteOffset,byteLength:e.byteLength},[e.buffer]),this.transmuxer_.postMessage({action:"flush"})}},{key:"appendGopInfo_",value:function(e){this.gopBuffer_=function(e,t,i){if(!t.length)return e;if(i)return t.slice();for(var n=t[0].pts,r=0;r<e.length&&!(e[r].pts>=n);r++);return e.slice(0,r).concat(t)}(this.gopBuffer_,e.data.gopInfo,this.safeAppend_)}},{key:"remove",value:function(e,t){if(this.videoBuffer_&&(this.videoBuffer_.updating=!0,this.videoBuffer_.remove(e,t),this.gopBuffer_=function(e,t,i,n){for(var r=Math.ceil(9e4*(t-n)),a=Math.ceil(9e4*(i-n)),s=e.slice(),o=e.length;o--&&!(e[o].pts<=a););if(-1===o)return s;for(var u=o+1;u--&&!(e[u].pts<=r););return u=Math.max(u,0),s.splice(u,o-u+1),s}(this.gopBuffer_,e,t,this.timeMapping_)),!this.audioDisabled_&&this.audioBuffer_&&(this.audioBuffer_.updating=!0,this.audioBuffer_.remove(e,t)),Le(e,t,this.metadataTrack_),this.inbandTextTracks_)for(var i in this.inbandTextTracks_)Le(e,t,this.inbandTextTracks_[i])}},{key:"processPendingSegments_",value:function(){var e={video:{segments:[],bytes:0},audio:{segments:[],bytes:0},captions:[],metadata:[]};e=this.pendingBuffers_.reduce(function(e,t){var i=t.type,n=t.data,r=t.initSegment;return e[i].segments.push(n),e[i].bytes+=n.byteLength,e[i].initSegment=r,t.captions&&(e.captions=e.captions.concat(t.captions)),t.info&&(e[i].info=t.info),t.metadata&&(e.metadata=e.metadata.concat(t.metadata)),e},e),this.videoBuffer_||this.audioBuffer_||(0===e.video.bytes&&(this.videoCodec_=null),0===e.audio.bytes&&(this.audioCodec_=null),this.createRealSourceBuffers_()),e.audio.info&&this.mediaSource_.trigger({type:"audioinfo",info:e.audio.info}),e.video.info&&this.mediaSource_.trigger({type:"videoinfo",info:e.video.info}),this.appendAudioInitSegment_&&(!this.audioDisabled_&&this.audioBuffer_&&(e.audio.segments.unshift(e.audio.initSegment),e.audio.bytes+=e.audio.initSegment.byteLength),this.appendAudioInitSegment_=!1);var t=!1;this.videoBuffer_&&e.video.bytes?(e.video.segments.unshift(e.video.initSegment),e.video.bytes+=e.video.initSegment.byteLength,this.concatAndAppendSegments_(e.video,this.videoBuffer_)):!this.videoBuffer_||!this.audioDisabled_&&this.audioBuffer_||(t=!0),Ee(this,e.captions,e.metadata),!this.audioDisabled_&&this.audioBuffer_&&this.concatAndAppendSegments_(e.audio,this.audioBuffer_),this.pendingBuffers_.length=0,t&&this.trigger("updateend"),this.bufferUpdating_=!1}},{key:"concatAndAppendSegments_",value:function(e,t){var i=0,n=void 0;if(e.bytes){n=new Uint8Array(e.bytes),e.segments.forEach(function(e){n.set(e,i),i+=e.byteLength});try{t.updating=!0,t.appendBuffer(n)}catch(e){this.mediaSource_.player_&&this.mediaSource_.player_.error({code:-3,type:"APPEND_BUFFER_ERR",message:e.message,originalError:e})}}}},{key:"abort",value:function(){this.videoBuffer_&&this.videoBuffer_.abort(),!this.audioDisabled_&&this.audioBuffer_&&this.audioBuffer_.abort(),this.transmuxer_&&this.transmuxer_.postMessage({action:"reset"}),this.pendingBuffers_.length=0,this.bufferUpdating_=!1}}]),i}(t.EventTarget),Ke=function(e){function i(){S(this,i);var e=U(this,(i.__proto__||Object.getPrototypeOf(i)).call(this)),n=void 0;for(n in e.nativeMediaSource_=new h.MediaSource,e.nativeMediaSource_)n in i.prototype||"function"!=typeof e.nativeMediaSource_[n]||(e[n]=e.nativeMediaSource_[n].bind(e.nativeMediaSource_));return e.duration_=NaN,Object.defineProperty(e,"duration",{get:function(){return this.duration_===1/0?this.duration_:this.nativeMediaSource_.duration},set:function(e){this.duration_=e,e===1/0||(this.nativeMediaSource_.duration=e)}}),Object.defineProperty(e,"seekable",{get:function(){return this.duration_===1/0?t.createTimeRanges([[0,this.nativeMediaSource_.duration]]):this.nativeMediaSource_.seekable}}),Object.defineProperty(e,"readyState",{get:function(){return this.nativeMediaSource_.readyState}}),Object.defineProperty(e,"activeSourceBuffers",{get:function(){return this.activeSourceBuffers_}}),e.sourceBuffers=[],e.activeSourceBuffers_=[],e.updateActiveSourceBuffers_=function(){if(e.activeSourceBuffers_.length=0,1===e.sourceBuffers.length){var t=e.sourceBuffers[0];return t.appendAudioInitSegment_=!0,t.audioDisabled_=!t.audioCodec_,void e.activeSourceBuffers_.push(t)}for(var i=!1,n=!0,r=0;r<e.player_.audioTracks().length;r++){var a=e.player_.audioTracks()[r];if(a.enabled&&"main"!==a.kind){i=!0,n=!1;break}}e.sourceBuffers.forEach(function(t,r){if(t.appendAudioInitSegment_=!0,t.videoCodec_&&t.audioCodec_)t.audioDisabled_=i;else if(t.videoCodec_&&!t.audioCodec_)t.audioDisabled_=!0,n=!1;else if(!t.videoCodec_&&t.audioCodec_&&(t.audioDisabled_=r?n:!n,t.audioDisabled_))return;e.activeSourceBuffers_.push(t)})},e.onPlayerMediachange_=function(){e.sourceBuffers.forEach(function(e){e.appendAudioInitSegment_=!0})},e.onHlsReset_=function(){e.sourceBuffers.forEach(function(e){e.transmuxer_&&e.transmuxer_.postMessage({action:"resetCaptions"})})},e.onHlsSegmentTimeMapping_=function(t){e.sourceBuffers.forEach(function(e){return e.timeMapping_=t.mapping})},["sourceopen","sourceclose","sourceended"].forEach(function(e){this.nativeMediaSource_.addEventListener(e,this.trigger.bind(this))},e),e.on("sourceopen",function(i){var n=d.querySelector('[src="'+e.url_+'"]');n&&(e.player_=t(n.parentNode),e.player_&&(e.player_.tech_.on("hls-reset",e.onHlsReset_),e.player_.tech_.on("hls-segment-time-mapping",e.onHlsSegmentTimeMapping_),e.player_.audioTracks&&e.player_.audioTracks()&&(e.player_.audioTracks().on("change",e.updateActiveSourceBuffers_),e.player_.audioTracks().on("addtrack",e.updateActiveSourceBuffers_),e.player_.audioTracks().on("removetrack",e.updateActiveSourceBuffers_)),e.player_.on("mediachange",e.onPlayerMediachange_)))}),e.on("sourceended",function(t){for(var i=Ae(e.duration),n=0;n<e.sourceBuffers.length;n++){var r=e.sourceBuffers[n],a=r.metadataTrack_&&r.metadataTrack_.cues;a&&a.length&&(a[a.length-1].endTime=i)}}),e.on("sourceclose",function(e){this.sourceBuffers.forEach(function(e){e.transmuxer_&&e.transmuxer_.terminate()}),this.sourceBuffers.length=0,this.player_&&(this.player_.audioTracks&&this.player_.audioTracks()&&(this.player_.audioTracks().off("change",this.updateActiveSourceBuffers_),this.player_.audioTracks().off("addtrack",this.updateActiveSourceBuffers_),this.player_.audioTracks().off("removetrack",this.updateActiveSourceBuffers_)),this.player_.el_&&this.player_.off("mediachange",this.onPlayerMediachange_),this.player_.tech_&&this.player_.tech_.el_&&(this.player_.tech_.off("hls-reset",this.onHlsReset_),this.player_.tech_.off("hls-segment-time-mapping",this.onHlsSegmentTimeMapping_)))}),e}return w(i,e),k(i,[{key:"addSeekableRange_",value:function(e,t){var i=void 0;if(this.duration!==1/0)throw(i=new Error("MediaSource.addSeekableRange() can only be invoked when the duration is Infinity")).name="InvalidStateError",i.code=11,i;(t>this.nativeMediaSource_.duration||isNaN(this.nativeMediaSource_.duration))&&(this.nativeMediaSource_.duration=t)}},{key:"addSourceBuffer",value:function(e){var t=void 0,i=function(e){var t={type:"",parameters:{}},i=e.trim().split(";");return t.type=i.shift().trim(),i.forEach(function(e){var i=e.trim().split("=");if(i.length>1){var n=i[0].replace(/"/g,"").trim(),r=i[1].replace(/"/g,"").trim();t.parameters[n]=r}}),t}(e);if(/^(video|audio)\/mp2t$/i.test(i.type)){var n=[];i.parameters&&i.parameters.codecs&&(n=i.parameters.codecs.split(","),n=(n=Ve(n)).filter(function(e){return We(e)||Xe(e)})),0===n.length&&(n=["avc1.4d400d","mp4a.40.2"]),t=new $e(this,n),0!==this.sourceBuffers.length&&(this.sourceBuffers[0].createRealSourceBuffers_(),t.createRealSourceBuffers_(),this.sourceBuffers[0].audioDisabled_=!0)}else t=this.nativeMediaSource_.addSourceBuffer(e);return this.sourceBuffers.push(t),t}}]),i}(t.EventTarget),Qe=0;t.mediaSources={};var Ze=function(e,i){var n=t.mediaSources[e];if(!n)throw new Error("Media Source not found (Video.js)");n.trigger({type:"sourceopen",swfId:i})},Je=function(){return!!h.MediaSource&&!!h.MediaSource.isTypeSupported&&h.MediaSource.isTypeSupported('video/mp4;codecs="avc1.4d400d,mp4a.40.2"')},et=function(){if(this.MediaSource={open:Ze,supportsNativeMediaSources:Je},Je())return new Ke;throw new Error("Cannot use create a virtual MediaSource for this video")};et.open=Ze,et.supportsNativeMediaSources=Je;var tt={createObjectURL:function(e){var i=void 0;return e instanceof Ke?(i=h.URL.createObjectURL(e.nativeMediaSource_),e.url_=i,i):e instanceof Ke?(i="blob:vjs-media-source/"+Qe,Qe++,t.mediaSources[i]=e,i):(i=h.URL.createObjectURL(e),e.url_=i,i)}};t.MediaSource=et,t.URL=tt;
/*! @name mpd-parser @version 0.7.0 @license Apache-2.0 */
var it=function(e){return!!e&&"object"==typeof e},nt=function e(){for(var t=arguments.length,i=new Array(t),n=0;n<t;n++)i[n]=arguments[n];return i.reduce(function(t,i){return Object.keys(i).forEach(function(n){Array.isArray(t[n])&&Array.isArray(i[n])?t[n]=t[n].concat(i[n]):it(t[n])&&it(i[n])?t[n]=e(t[n],i[n]):t[n]=i[n]}),t},{})},rt=function(e){return e.reduce(function(e,t){return e.concat(t)},[])},at=function(e){if(!e.length)return[];for(var t=[],i=0;i<e.length;i++)t.push(e[i]);return t},st=function(e){var t;return(t=e.reduce(function(e,t){var i,n=t.attributes.id+(t.attributes.lang||"");e[n]?(t.segments[0].discontinuity=!0,(i=e[n].segments).push.apply(i,t.segments),t.attributes.contentProtection&&(e[n].attributes.contentProtection=t.attributes.contentProtection)):e[n]=t;return e},{}),Object.keys(t).map(function(e){return t[e]})).map(function(e){var t,i;return e.discontinuityStarts=(t=e.segments,i="discontinuity",t.reduce(function(e,t,n){return t[i]&&e.push(n),e},[])),e})},ot=function(e){var t,i=e.attributes,n=e.segments,r={attributes:(t={NAME:i.id,AUDIO:"audio",SUBTITLES:"subs",RESOLUTION:{width:i.width,height:i.height},CODECS:i.codecs,BANDWIDTH:i.bandwidth},t["PROGRAM-ID"]=1,t),uri:"",endList:"static"===(i.type||"static"),timeline:i.periodIndex,resolvedUri:"",targetDuration:i.duration,segments:n,mediaSequence:n.length?n[0].number:1};return i.contentProtection&&(r.contentProtection=i.contentProtection),r};"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self&&self;var ut=function(e,t){return e(t={exports:{}},t.exports),t.exports}(function(e,t){var i,n,r,a,s;i=/^((?:[a-zA-Z0-9+\-.]+:)?)(\/\/[^\/?#]*)?((?:[^\/\?#]*\/)*.*?)??(;.*?)?(\?.*?)?(#.*?)?$/,n=/^([^\/?#]*)(.*)$/,r=/(?:\/|^)\.(?=\/)/g,a=/(?:\/|^)\.\.\/(?!\.\.\/).*?(?=\/)/g,s={buildAbsoluteURL:function(e,t,i){if(i=i||{},e=e.trim(),!(t=t.trim())){if(!i.alwaysNormalize)return e;var r=s.parseURL(e);if(!r)throw new Error("Error trying to parse base URL.");return r.path=s.normalizePath(r.path),s.buildURLFromParts(r)}var a=s.parseURL(t);if(!a)throw new Error("Error trying to parse relative URL.");if(a.scheme)return i.alwaysNormalize?(a.path=s.normalizePath(a.path),s.buildURLFromParts(a)):t;var o=s.parseURL(e);if(!o)throw new Error("Error trying to parse base URL.");if(!o.netLoc&&o.path&&"/"!==o.path[0]){var u=n.exec(o.path);o.netLoc=u[1],o.path=u[2]}o.netLoc&&!o.path&&(o.path="/");var d={scheme:o.scheme,netLoc:a.netLoc,path:null,params:a.params,query:a.query,fragment:a.fragment};if(!a.netLoc&&(d.netLoc=o.netLoc,"/"!==a.path[0]))if(a.path){var l=o.path,h=l.substring(0,l.lastIndexOf("/")+1)+a.path;d.path=s.normalizePath(h)}else d.path=o.path,a.params||(d.params=o.params,a.query||(d.query=o.query));return null===d.path&&(d.path=i.alwaysNormalize?s.normalizePath(a.path):a.path),s.buildURLFromParts(d)},parseURL:function(e){var t=i.exec(e);return t?{scheme:t[1]||"",netLoc:t[2]||"",path:t[3]||"",params:t[4]||"",query:t[5]||"",fragment:t[6]||""}:null},normalizePath:function(e){for(e=e.split("").reverse().join("").replace(r,"");e.length!==(e=e.replace(a,"")).length;);return e.split("").reverse().join("")},buildURLFromParts:function(e){return e.scheme+e.netLoc+e.path+e.params+e.query+e.fragment}},e.exports=s}),dt=function(e,t){return/^[a-z]+:/i.test(t)?t:(/\/\//i.test(e)||(e=ut.buildAbsoluteURL(h.location.href,e)),ut.buildAbsoluteURL(e,t))},lt=function(e){var t=e.baseUrl,i=void 0===t?"":t,n=e.source,r=void 0===n?"":n,a=e.range,s=void 0===a?"":a,o={uri:r,resolvedUri:dt(i||"",r)};if(s){var u=s.split("-"),d=parseInt(u[0],10),l=parseInt(u[1],10);o.byterange={length:l-d,offset:d}}return o},ht=function(e,t,i){var n=e.NOW,r=e.clientOffset,a=e.availabilityStartTime,s=e.timescale,o=void 0===s?1:s,u=e.start,d=void 0===u?0:u,l=e.minimumUpdatePeriod,h=(n+r)/1e3+(void 0===l?0:l)-(a+d);return Math.ceil((h*o-t)/i)},ct=function(e,t){for(var i=e.type,n=void 0===i?"static":i,r=e.minimumUpdatePeriod,a=void 0===r?0:r,s=e.media,o=void 0===s?"":s,u=e.sourceDuration,d=e.timescale,l=void 0===d?1:d,h=e.startNumber,c=void 0===h?1:h,f=e.periodIndex,p=[],m=-1,g=0;g<t.length;g++){var y=t[g],_=y.d,v=y.r||0,b=y.t||0;m<0&&(m=b),b&&b>m&&(m=b);var T=void 0;if(v<0){var S=g+1;T=S===t.length?"dynamic"===n&&a>0&&o.indexOf("$Number$")>0?ht(e,m,_):(u*l-m)/_:(t[S].t-m)/_}else T=v+1;for(var k=c+p.length+T,w=c+p.length;w<k;)p.push({number:w,duration:_/l,time:m,timeline:f}),m+=_,w++}return p},ft={static:function(e){var t=e.duration,i=e.timescale,n=void 0===i?1:i,r=e.sourceDuration;return{start:0,end:Math.ceil(r/(t/n))}},dynamic:function(e){var t=e.NOW,i=e.clientOffset,n=e.availabilityStartTime,r=e.timescale,a=void 0===r?1:r,s=e.duration,o=e.start,u=void 0===o?0:o,d=e.minimumUpdatePeriod,l=void 0===d?0:d,h=e.timeShiftBufferDepth,c=void 0===h?1/0:h,f=(t+i)/1e3,p=n+u,m=f+l-p,g=Math.ceil(m*a/s),y=Math.floor((f-p-c)*a/s),_=Math.floor((f-p)*a/s);return{start:Math.max(0,y),end:Math.min(g,_)}}},pt=function(e){var t=e.type,i=void 0===t?"static":t,n=e.duration,r=e.timescale,a=void 0===r?1:r,s=e.sourceDuration,o=ft[i](e),u=function(e,t){for(var i=[],n=e;n<t;n++)i.push(n);return i}(o.start,o.end).map(function(e){return function(t,i){var n=e.duration,r=e.timescale,a=void 0===r?1:r,s=e.periodIndex,o=e.startNumber;return{number:(void 0===o?1:o)+t,duration:n/a,timeline:s,time:i*n}}}(e));if("static"===i){var d=u.length-1;u[d].duration=s-n/a*d}return u},mt=/\$([A-z]*)(?:(%0)([0-9]+)d)?\$/g,gt=function(e,t){return e.replace(mt,function(e){return function(t,i,n,r){if("$$"===t)return"$";if(void 0===e[i])return t;var a=""+e[i];return"RepresentationID"===i?a:(r=n?parseInt(r,10):1,a.length>=r?a:""+new Array(r-a.length+1).join("0")+a)}}(t))},yt=function(e,t){var i={RepresentationID:e.id,Bandwidth:e.bandwidth||0},n=e.initialization,r=void 0===n?{sourceURL:"",range:""}:n,a=lt({baseUrl:e.baseUrl,source:gt(r.sourceURL,i),range:r.range});return function(e,t){return e.duration||t?e.duration?pt(e):ct(e,t):[{number:e.startNumber||1,duration:e.sourceDuration,time:0,timeline:e.periodIndex}]}(e,t).map(function(t){i.Number=t.number,i.Time=t.time;var n=gt(e.media||"",i);return{uri:n,timeline:t.timeline,duration:t.duration,resolvedUri:dt(e.baseUrl||"",n),map:a,number:t.number}})},_t="INVALID_NUMBER_OF_PERIOD",vt="DASH_EMPTY_MANIFEST",bt="DASH_INVALID_XML",Tt="NO_BASE_URL",St="SEGMENT_TIME_UNSPECIFIED",kt="UNSUPPORTED_UTC_TIMING_SCHEME",wt=function(e,t){var i=e.duration,n=e.segmentUrls,r=void 0===n?[]:n;if(!i&&!t||i&&t)throw new Error(St);var a,s=r.map(function(t){return function(e,t){var i=e.baseUrl,n=e.initialization,r=void 0===n?{}:n,a=lt({baseUrl:i,source:r.sourceURL,range:r.range}),s=lt({baseUrl:i,source:t.media,range:t.mediaRange});return s.map=a,s}(e,t)});return i&&(a=pt(e)),t&&(a=ct(e,t)),a.map(function(e,t){if(s[t]){var i=s[t];return i.timeline=e.timeline,i.duration=e.duration,i.number=e.number,i}}).filter(function(e){return e})},Ut=function(e){var t=e.baseUrl,i=e.initialization,n=void 0===i?{}:i,r=e.sourceDuration,a=e.timescale,s=void 0===a?1:a,o=e.indexRange,u=void 0===o?"":o,d=e.duration;if(!t)throw new Error(Tt);var l=lt({baseUrl:t,source:n.sourceURL,range:n.range}),h=lt({baseUrl:t,source:t,range:u});if(h.map=l,d){var c=pt(e);c.length&&(h.duration=c[0].duration,h.timeline=c[0].timeline)}else r&&(h.duration=r/s,h.timeline=0);return h.number=0,[h]},Lt=function(e){var t,i,n=e.attributes,r=e.segmentInfo;if(r.template?(i=yt,t=nt(n,r.template)):r.base?(i=Ut,t=nt(n,r.base)):r.list&&(i=wt,t=nt(n,r.list)),!i)return{attributes:n};var a=i(t,r.timeline);if(t.duration){var s=t,o=s.duration,u=s.timescale,d=void 0===u?1:u;t.duration=o/d}else a.length?t.duration=a.reduce(function(e,t){return Math.max(e,Math.ceil(t.duration))},0):t.duration=0;return{attributes:t,segments:a}},At=function(e,t){return at(e.childNodes).filter(function(e){return e.tagName===t})},Et=function(e){return e.textContent.trim()},Ot=function(e){var t=/P(?:(\d*)Y)?(?:(\d*)M)?(?:(\d*)D)?(?:T(?:(\d*)H)?(?:(\d*)M)?(?:([\d.]*)S)?)?/.exec(e);if(!t)return 0;var i=t.slice(1),n=i[0],r=i[1],a=i[2],s=i[3],o=i[4],u=i[5];return 31536e3*parseFloat(n||0)+2592e3*parseFloat(r||0)+86400*parseFloat(a||0)+3600*parseFloat(s||0)+60*parseFloat(o||0)+parseFloat(u||0)},It={mediaPresentationDuration:function(e){return Ot(e)},availabilityStartTime:function(e){return/^\d+-\d+-\d+T\d+:\d+:\d+(\.\d+)?$/.test(t=e)&&(t+="Z"),Date.parse(t)/1e3;var t},minimumUpdatePeriod:function(e){return Ot(e)},timeShiftBufferDepth:function(e){return Ot(e)},start:function(e){return Ot(e)},width:function(e){return parseInt(e,10)},height:function(e){return parseInt(e,10)},bandwidth:function(e){return parseInt(e,10)},startNumber:function(e){return parseInt(e,10)},timescale:function(e){return parseInt(e,10)},duration:function(e){var t=parseInt(e,10);return isNaN(t)?Ot(e):t},d:function(e){return parseInt(e,10)},t:function(e){return parseInt(e,10)},r:function(e){return parseInt(e,10)},DEFAULT:function(e){return e}},Ct=function(e){return e&&e.attributes?at(e.attributes).reduce(function(e,t){var i=It[t.name]||It.DEFAULT;return e[t.name]=i(t.value),e},{}):{}};var Pt={"urn:uuid:1077efec-c0b2-4d02-ace3-3c1e52e2fb4b":"org.w3.clearkey","urn:uuid:edef8ba9-79d6-4ace-a3c8-27dcd51d21ed":"com.widevine.alpha","urn:uuid:9a04f079-9840-4286-ab92-e65be0885f95":"com.microsoft.playready","urn:uuid:f239e769-efa3-4850-9c16-a903c6932efb":"com.adobe.primetime"},Dt=function(e,t){return t.length?rt(e.map(function(e){return t.map(function(t){return dt(e,Et(t))})})):e},Rt=function(e){var t=At(e,"SegmentTemplate")[0],i=At(e,"SegmentList")[0],n=i&&At(i,"SegmentURL").map(function(e){return nt({tag:"SegmentURL"},Ct(e))}),r=At(e,"SegmentBase")[0],a=i||t,s=a&&At(a,"SegmentTimeline")[0],o=i||r||t,u=o&&At(o,"Initialization")[0],d=t&&Ct(t);d&&u?d.initialization=u&&Ct(u):d&&d.initialization&&(d.initialization={sourceURL:d.initialization});var l={template:d,timeline:s&&At(s,"S").map(function(e){return Ct(e)}),list:i&&nt(Ct(i),{segmentUrls:n,initialization:Ct(u)}),base:r&&nt(Ct(r),{initialization:Ct(u)})};return Object.keys(l).forEach(function(e){l[e]||delete l[e]}),l},xt=function(e){return e.reduce(function(e,t){var i=Ct(t),n=Pt[i.schemeIdUri];if(n){e[n]={attributes:i};var r=At(t,"cenc:pssh")[0];if(r){var a=Et(r),s=a&&function(e){for(var t=h.atob(e),i=new Uint8Array(t.length),n=0;n<t.length;n++)i[n]=t.charCodeAt(n);return i}(a);e[n].pssh=s}}return e},{})},Mt=function(e,t,i){return function(n){var r=Ct(n),a=Dt(t,At(n,"BaseURL")),s=At(n,"Role")[0],o={role:Ct(s)},u=nt(e,r,o),d=xt(At(n,"ContentProtection"));Object.keys(d).length&&(u=nt(u,{contentProtection:d}));var l=Rt(n),h=At(n,"Representation"),c=nt(i,l);return rt(h.map(function(e,t,i){return function(n){var r=At(n,"BaseURL"),a=Dt(t,r),s=nt(e,Ct(n)),o=Rt(n);return a.map(function(e){return{segmentInfo:nt(i,o),attributes:nt(s,{baseUrl:e})}})}}(u,a,c)))}},Bt=function(e,t){void 0===t&&(t={});var i=t,n=i.manifestUri,r=void 0===n?"":n,a=i.NOW,s=void 0===a?Date.now():a,o=i.clientOffset,u=void 0===o?0:o,d=At(e,"Period");if(!d.length)throw new Error(_t);var l=Ct(e),c=Dt([r],At(e,"BaseURL"));return l.sourceDuration=l.mediaPresentationDuration||0,l.NOW=s,l.clientOffset=u,rt(d.map(function(e,t){return function(i,n){var r=Dt(t,At(i,"BaseURL")),a=Ct(i),s=parseInt(a.id,10),o=h.isNaN(s)?n:s,u=nt(e,{periodIndex:o}),d=At(i,"AdaptationSet"),l=Rt(i);return rt(d.map(Mt(u,r,l)))}}(l,c)))},Nt=function(e){if(""===e)throw new Error(vt);var t=(new h.DOMParser).parseFromString(e,"application/xml"),i=t&&"MPD"===t.documentElement.tagName?t.documentElement:null;if(!i||i&&i.getElementsByTagName("parsererror").length>0)throw new Error(bt);return i},qt=function(e,t){return function(e){var t;if(!e.length)return{};var i=e[0].attributes,n=i.sourceDuration,r=i.minimumUpdatePeriod,a=void 0===r?0:r,s=st(e.filter(function(e){var t=e.attributes;return"video/mp4"===t.mimeType||"video"===t.contentType})).map(ot),o=st(e.filter(function(e){var t=e.attributes;return"audio/mp4"===t.mimeType||"audio"===t.contentType})),u=e.filter(function(e){var t=e.attributes;return"text/vtt"===t.mimeType||"text"===t.contentType}),d={allowCache:!0,discontinuityStarts:[],segments:[],endList:!0,mediaGroups:(t={AUDIO:{},VIDEO:{}},t["CLOSED-CAPTIONS"]={},t.SUBTITLES={},t),uri:"",duration:n,playlists:s,minimumUpdatePeriod:1e3*a};return o.length&&(d.mediaGroups.AUDIO.audio=o.reduce(function(e,t){var i=t.attributes.role&&t.attributes.role.value||"main",n=t.attributes.lang||"",r="main";return n&&(r=t.attributes.lang+" ("+i+")"),e[r]&&e[r].playlists[0].attributes.BANDWIDTH>t.attributes.bandwidth?e:(e[r]={language:n,autoselect:!0,default:"main"===i,playlists:[function(e){var t,i=e.attributes,n=e.segments,r={attributes:(t={NAME:i.id,BANDWIDTH:i.bandwidth,CODECS:i.codecs},t["PROGRAM-ID"]=1,t),uri:"",endList:"static"===(i.type||"static"),timeline:i.periodIndex,resolvedUri:"",targetDuration:i.duration,segments:n,mediaSequence:n.length?n[0].number:1};return i.contentProtection&&(r.contentProtection=i.contentProtection),r}(t)],uri:""},e)},{})),u.length&&(d.mediaGroups.SUBTITLES.subs=function(e){return e.reduce(function(e,t){var i,n,r,a,s=t.attributes.lang||"text";return e[s]?e:(e[s]={language:s,default:!1,autoselect:!1,playlists:[(i=t,r=i.attributes,a=i.segments,void 0===a&&(a=[{uri:r.baseUrl,timeline:r.periodIndex,resolvedUri:r.baseUrl||"",duration:r.sourceDuration,number:0}],r.duration=r.sourceDuration),{attributes:(n={NAME:r.id,BANDWIDTH:r.bandwidth},n["PROGRAM-ID"]=1,n),uri:"",endList:"static"===(r.type||"static"),timeline:r.periodIndex,resolvedUri:r.baseUrl||"",targetDuration:r.duration,segments:a,mediaSequence:a.length?a[0].number:1})],uri:""},e)},{})}(u)),d}(Bt(Nt(e),t).map(Lt))},Ft=function(e){return function(e){var t=At(e,"UTCTiming")[0];if(!t)return null;var i=Ct(t);switch(i.schemeIdUri){case"urn:mpeg:dash:utc:http-head:2014":case"urn:mpeg:dash:utc:http-head:2012":i.method="HEAD";break;case"urn:mpeg:dash:utc:http-xsdate:2014":case"urn:mpeg:dash:utc:http-iso:2014":case"urn:mpeg:dash:utc:http-xsdate:2012":case"urn:mpeg:dash:utc:http-iso:2012":i.method="GET";break;case"urn:mpeg:dash:utc:direct:2014":case"urn:mpeg:dash:utc:direct:2012":i.method="DIRECT",i.value=Date.parse(i.value);break;case"urn:mpeg:dash:utc:http-ntp:2014":case"urn:mpeg:dash:utc:ntp:2014":case"urn:mpeg:dash:utc:sntp:2014":default:throw new Error(kt)}return i}(Nt(e))},Gt=t.EventTarget,Vt=t.mergeOptions,Ht=function(e,t){for(var i=void 0,n=Vt(e,{duration:t.duration,minimumUpdatePeriod:t.minimumUpdatePeriod}),r=0;r<t.playlists.length;r++){var a=C(n,t.playlists[r]);a?n=a:i=!0}return I(t,function(e,t,r,a){if(e.playlists&&e.playlists.length){var s=e.playlists[0].uri,o=C(n,e.playlists[0]);o&&((n=o).mediaGroups[t][r][a].playlists[0]=n.playlists[s],i=!1)}}),i?null:n},jt=function(e){function t(e,i){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r=arguments[3];S(this,t);var a=U(this,(t.__proto__||Object.getPrototypeOf(t)).call(this)),s=n.withCredentials,o=void 0!==s&&s,u=n.handleManifestRedirects,d=void 0!==u&&u;if(a.hls_=i,a.withCredentials=o,a.handleManifestRedirects=d,!e)throw new Error("A non-empty playlist URL or playlist is required");return a.on("minimumUpdatePeriod",function(){a.refreshXml_()}),a.on("mediaupdatetimeout",function(){a.refreshMedia_()}),a.state="HAVE_NOTHING",a.loadedPlaylists_={},"string"==typeof e?(a.srcUrl=e,U(a)):(a.setupChildLoader(r,e),a)}return w(t,Gt),k(t,[{key:"setupChildLoader",value:function(e,t){this.masterPlaylistLoader_=e,this.childPlaylist_=t}},{key:"dispose",value:function(){this.stopRequest(),this.loadedPlaylists_={},h.clearTimeout(this.mediaUpdateTimeout)}},{key:"hasPendingRequest",value:function(){return this.request||this.mediaRequest_}},{key:"stopRequest",value:function(){if(this.request){var e=this.request;this.request=null,e.onreadystatechange=null,e.abort()}}},{key:"media",value:function(e){if(!e)return this.media_;if("HAVE_NOTHING"===this.state)throw new Error("Cannot switch media playlist from "+this.state);var t=this.state;if("string"==typeof e){if(!this.master.playlists[e])throw new Error("Unknown playlist URI: "+e);e=this.master.playlists[e]}var i=!this.media_||e.uri!==this.media_.uri;if(i&&this.loadedPlaylists_[e.uri]&&this.loadedPlaylists_[e.uri].endList)return this.state="HAVE_METADATA",this.media_=e,void(i&&(this.trigger("mediachanging"),this.trigger("mediachange")));i&&(this.media_&&this.trigger("mediachanging"),this.mediaRequest_=h.setTimeout(this.haveMetadata.bind(this,{startingState:t,playlist:e}),0))}},{key:"haveMetadata",value:function(e){var t=e.startingState,i=e.playlist;this.state="HAVE_METADATA",this.media_=i,this.loadedPlaylists_[i.uri]=i,this.mediaRequest_=null,this.refreshMedia_(),"HAVE_MASTER"===t?this.trigger("loadedmetadata"):this.trigger("mediachange")}},{key:"pause",value:function(){this.stopRequest(),h.clearTimeout(this.mediaUpdateTimeout),"HAVE_NOTHING"===this.state&&(this.started=!1)}},{key:"load",value:function(e){var t=this;h.clearTimeout(this.mediaUpdateTimeout);var i=this.media();if(e){var n=i?i.targetDuration/2*1e3:5e3;this.mediaUpdateTimeout=h.setTimeout(function(){return t.load()},n)}else this.started?this.trigger("loadedplaylist"):this.start()}},{key:"parseMasterXml",value:function(){var e=qt(this.masterXml_,{manifestUri:this.srcUrl,clientOffset:this.clientOffset_});e.uri=this.srcUrl;for(var t=0;t<e.playlists.length;t++){var i="placeholder-uri-"+t;e.playlists[t].uri=i,e.playlists[i]=e.playlists[t]}return I(e,function(t,i,n,r){if(t.playlists&&t.playlists.length){var a="placeholder-uri-"+i+"-"+n+"-"+r;t.playlists[0].uri=a,e.playlists[a]=t.playlists[0]}}),P(e),D(e),e}},{key:"start",value:function(){var e=this;this.started=!0,this.masterPlaylistLoader_?this.mediaRequest_=h.setTimeout(this.haveMaster_.bind(this),0):this.request=this.hls_.xhr({uri:this.srcUrl,withCredentials:this.withCredentials},function(t,i){if(e.request){if(e.request=null,t)return e.error={status:i.status,message:"DASH playlist request error at URL: "+e.srcUrl,responseText:i.responseText,code:2},"HAVE_NOTHING"===e.state&&(e.started=!1),e.trigger("error");e.masterXml_=i.responseText,i.responseHeaders&&i.responseHeaders.date?e.masterLoaded_=Date.parse(i.responseHeaders.date):e.masterLoaded_=Date.now(),e.srcUrl=f(e.handleManifestRedirects,e.srcUrl,i),e.syncClientServerClock_(e.onClientServerClockSync_.bind(e))}})}},{key:"syncClientServerClock_",value:function(e){var t=this,i=Ft(this.masterXml_);return null===i?(this.clientOffset_=this.masterLoaded_-Date.now(),e()):"DIRECT"===i.method?(this.clientOffset_=i.value-Date.now(),e()):void(this.request=this.hls_.xhr({uri:c(this.srcUrl,i.value),method:i.method,withCredentials:this.withCredentials},function(n,r){if(t.request){if(n)return t.clientOffset_=t.masterLoaded_-Date.now(),e();var a=void 0;a="HEAD"===i.method?r.responseHeaders&&r.responseHeaders.date?Date.parse(r.responseHeaders.date):t.masterLoaded_:Date.parse(r.responseText),t.clientOffset_=a-Date.now(),e()}}))}},{key:"haveMaster_",value:function(){this.state="HAVE_MASTER",this.mediaRequest_=null,this.masterPlaylistLoader_?this.media_||this.media(this.childPlaylist_):(this.master=this.parseMasterXml(),this.trigger("loadedplaylist"))}},{key:"onClientServerClockSync_",value:function(){var e=this;this.haveMaster_(),this.hasPendingRequest()||this.media_||this.media(this.master.playlists[0]),this.master&&this.master.minimumUpdatePeriod&&h.setTimeout(function(){e.trigger("minimumUpdatePeriod")},this.master.minimumUpdatePeriod)}},{key:"refreshXml_",value:function(){var e=this;this.request=this.hls_.xhr({uri:this.srcUrl,withCredentials:this.withCredentials},function(t,i){if(e.request){if(e.request=null,t)return e.error={status:i.status,message:"DASH playlist request error at URL: "+e.srcUrl,responseText:i.responseText,code:2},"HAVE_NOTHING"===e.state&&(e.started=!1),e.trigger("error");e.masterXml_=i.responseText;var n=e.parseMasterXml(),r=Ht(e.master,n);r&&(e.master=r),h.setTimeout(function(){e.trigger("minimumUpdatePeriod")},e.master.minimumUpdatePeriod)}})}},{key:"refreshMedia_",value:function(){var e=this,t=void 0,i=void 0;this.masterPlaylistLoader_?(t=this.masterPlaylistLoader_.master,i=this.masterPlaylistLoader_.parseMasterXml()):(t=this.master,i=this.parseMasterXml());var n=Ht(t,i);n?(this.masterPlaylistLoader_?this.masterPlaylistLoader_.master=n:this.master=n,this.media_=n.playlists[this.media_.uri]):this.trigger("playlistunchanged"),this.media().endList||(this.mediaUpdateTimeout=h.setTimeout(function(){e.trigger("mediaupdatetimeout")},R(this.media(),!!n))),this.trigger("loadedplaylist")}}]),t}(),zt=function(e){return t.log.debug?t.log.debug.bind(t,"VHS:",e+" >"):function(){}};function Wt(){}var Xt,Yt,$t,Kt,Qt,Zt,Jt,ei,ti,ii,ni,ri,ai,si,oi,ui,di,li,hi,ci,fi,pi,mi,gi,yi,_i,vi,bi,Ti,Si,ki,wi,Ui,Li,Ai,Ei,Oi,Ii,Ci,Pi,Di,Ri,xi=function(){function e(t,i,n,r){S(this,e),this.callbacks_=[],this.pendingCallback_=null,this.timestampOffset_=0,this.mediaSource=t,this.processedAppend_=!1,this.type_=n,this.mimeType_=i,this.logger_=zt("SourceUpdater["+n+"]["+i+"]"),"closed"===t.readyState?t.addEventListener("sourceopen",this.createSourceBuffer_.bind(this,i,r)):this.createSourceBuffer_(i,r)}return k(e,[{key:"createSourceBuffer_",value:function(e,t){var i=this;this.sourceBuffer_=this.mediaSource.addSourceBuffer(e),this.logger_("created SourceBuffer"),t&&(t.trigger("sourcebufferadded"),this.mediaSource.sourceBuffers.length<2)?t.on("sourcebufferadded",function(){i.start_()}):this.start_()}},{key:"start_",value:function(){var e=this;this.started_=!0,this.onUpdateendCallback_=function(){var t=e.pendingCallback_;e.pendingCallback_=null,e.logger_("buffered ["+we(e.buffered())+"]"),t&&t(),e.runCallback_()},this.sourceBuffer_.addEventListener("updateend",this.onUpdateendCallback_),this.runCallback_()}},{key:"abort",value:function(e){var t=this;this.processedAppend_&&this.queueCallback_(function(){t.sourceBuffer_.abort()},e)}},{key:"appendBuffer",value:function(e,t){var i=this;this.processedAppend_=!0,this.queueCallback_(function(){e.videoSegmentTimingInfoCallback&&i.sourceBuffer_.addEventListener("videoSegmentTimingInfo",e.videoSegmentTimingInfoCallback),i.sourceBuffer_.appendBuffer(e.bytes)},function(){e.videoSegmentTimingInfoCallback&&i.sourceBuffer_.removeEventListener("videoSegmentTimingInfo",e.videoSegmentTimingInfoCallback),t()})}},{key:"buffered",value:function(){return this.sourceBuffer_?this.sourceBuffer_.buffered:t.createTimeRanges()}},{key:"remove",value:function(e,t){var i=this,n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:Wt;this.processedAppend_&&this.queueCallback_(function(){i.logger_("remove ["+e+" => "+t+"]"),i.sourceBuffer_.remove(e,t)},n)}},{key:"updating",value:function(){return!this.sourceBuffer_||this.sourceBuffer_.updating||!!this.pendingCallback_&&this.pendingCallback_!==Wt}},{key:"timestampOffset",value:function(e){var t=this;return void 0!==e&&(this.queueCallback_(function(){t.sourceBuffer_.timestampOffset=e}),this.timestampOffset_=e),this.timestampOffset_}},{key:"queueCallback_",value:function(e,t){this.callbacks_.push([e.bind(this),t]),this.runCallback_()}},{key:"runCallback_",value:function(){var e=void 0;!this.updating()&&this.callbacks_.length&&this.started_&&(e=this.callbacks_.shift(),this.pendingCallback_=e[1],e[0]())}},{key:"dispose",value:function(){this.sourceBuffer_.removeEventListener("updateend",this.onUpdateendCallback_),this.sourceBuffer_&&"open"===this.mediaSource.readyState&&this.sourceBuffer_.abort()}}]),e}(),Mi={GOAL_BUFFER_LENGTH:30,MAX_GOAL_BUFFER_LENGTH:60,GOAL_BUFFER_LENGTH_RATE:1,INITIAL_BANDWIDTH:4194304,BANDWIDTH_VARIANCE:1.2,BUFFER_LOW_WATER_LINE:0,MAX_BUFFER_LOW_WATER_LINE:30,BUFFER_LOW_WATER_LINE_RATE:1},Bi=function(e){return e>>>0},Ni={findBox:Xt=function(e,t){var i,n,r,a,s,o=[];if(!t.length)return null;for(i=0;i<e.byteLength;)n=Bi(e[i]<<24|e[i+1]<<16|e[i+2]<<8|e[i+3]),r=Yt(e.subarray(i+4,i+8)),a=n>1?i+n:e.byteLength,r===t[0]&&(1===t.length?o.push(e.subarray(i+8,a)):(s=Xt(e.subarray(i+8,a),t.slice(1))).length&&(o=o.concat(s))),i=a;return o},parseType:Yt=function(e){var t="";return t+=String.fromCharCode(e[0]),t+=String.fromCharCode(e[1]),t+=String.fromCharCode(e[2]),t+=String.fromCharCode(e[3])},timescale:function(e){return Xt(e,["moov","trak"]).reduce(function(e,t){var i,n,r,a,s;return(i=Xt(t,["tkhd"])[0])?(n=i[0],a=Bi(i[r=0===n?12:20]<<24|i[r+1]<<16|i[r+2]<<8|i[r+3]),(s=Xt(t,["mdia","mdhd"])[0])?(r=0===(n=s[0])?12:20,e[a]=Bi(s[r]<<24|s[r+1]<<16|s[r+2]<<8|s[r+3]),e):null):null},{})},startTime:function(e,t){var i,n,r;return i=Xt(t,["moof","traf"]),n=[].concat.apply([],i.map(function(t){return Xt(t,["tfhd"]).map(function(i){var n,r;return n=Bi(i[4]<<24|i[5]<<16|i[6]<<8|i[7]),r=e[n]||9e4,(Xt(t,["tfdt"]).map(function(e){var t,i;return t=e[0],i=Bi(e[4]<<24|e[5]<<16|e[6]<<8|e[7]),1===t&&(i*=Math.pow(2,32),i+=Bi(e[8]<<24|e[9]<<16|e[10]<<8|e[11])),i})[0]||1/0)/r})})),r=Math.min.apply(null,n),isFinite(r)?r:0},videoTrackIds:function(e){var t=[];return Xt(e,["moov","trak"]).forEach(function(e){var i=Xt(e,["mdia","hdlr"]),n=Xt(e,["tkhd"]);i.forEach(function(e,i){var r,a,s=Yt(e.subarray(8,12)),o=n[i];"vide"===s&&(a=0===(r=new DataView(o.buffer,o.byteOffset,o.byteLength)).getUint8(0)?r.getUint32(12):r.getUint32(20),t.push(a))})}),t}},qi=2,Fi=-101,Gi=-102,Vi=function(e){var t,i,n={};return e.byterange&&(n.Range=(t=e.byterange,i=t.offset+t.length-1,"bytes="+t.offset+"-"+i)),n},Hi=function(e){e.forEach(function(e){e.abort()})},ji=function(e,t){return t.timedout?{status:t.status,message:"HLS request timed-out at URL: "+t.uri,code:Fi,xhr:t}:t.aborted?{status:t.status,message:"HLS request aborted at URL: "+t.uri,code:Gi,xhr:t}:e?{status:t.status,message:"HLS request errored at URL: "+t.uri,code:qi,xhr:t}:null},zi=function(e,t,i){var n=0,r=!1;return function(a,s){if(!r)return a?(r=!0,Hi(e),i(a,s)):(n+=1)===e.length?(s.endOfAllRequests=Date.now(),s.encryptedBytes?function(e,t,i){e.addEventListener("message",function n(r){if(r.data.source===t.requestId){e.removeEventListener("message",n);var a=r.data.decrypted;return t.bytes=new Uint8Array(a.bytes,a.byteOffset,a.byteLength),i(null,t)}}),e.postMessage(me({source:t.requestId,encrypted:t.encryptedBytes,key:t.key.bytes,iv:t.key.iv}),[t.encryptedBytes.buffer,t.key.bytes.buffer])}(t,s,i):i(null,s)):void 0}},Wi=function(e,i){return function(n){var r,a,s;return e.stats=t.mergeOptions(e.stats,(a=(r=n).target,(s={bandwidth:1/0,bytesReceived:0,roundTripTime:Date.now()-a.requestTime||0}).bytesReceived=r.loaded,s.bandwidth=Math.floor(s.bytesReceived/s.roundTripTime*8*1e3),s)),!e.stats.firstBytesReceivedAt&&e.stats.bytesReceived&&(e.stats.firstBytesReceivedAt=Date.now()),i(n,e)}},Xi=function(e,i,n,r,a,s,o){var u=[],d=zi(u,n,o);if(a.key){var l=e(t.mergeOptions(i,{uri:a.key.resolvedUri,responseType:"arraybuffer"}),function(e,t){return function(i,n){var r=n.response,a=ji(i,n);if(a)return t(a,e);if(16!==r.byteLength)return t({status:n.status,message:"Invalid HLS key at URL: "+n.uri,code:qi,xhr:n},e);var s=new DataView(r);return e.key.bytes=new Uint32Array([s.getUint32(0),s.getUint32(4),s.getUint32(8),s.getUint32(12)]),t(null,e)}}(a,d));u.push(l)}if(a.map&&!a.map.bytes){var h=e(t.mergeOptions(i,{uri:a.map.resolvedUri,responseType:"arraybuffer",headers:Vi(a.map)}),function(e,t,i){return function(n,r){var a=r.response,s=ji(n,r);return s?i(s,e):0===a.byteLength?i({status:r.status,message:"Empty HLS segment content at URL: "+r.uri,code:qi,xhr:r},e):(e.map.bytes=new Uint8Array(r.response),t.isInitialized()||t.init(),e.map.timescales=Ni.timescale(e.map.bytes),e.map.videoTrackIds=Ni.videoTrackIds(e.map.bytes),i(null,e))}}(a,r,d));u.push(h)}var c=e(t.mergeOptions(i,{uri:a.resolvedUri,responseType:"arraybuffer",headers:Vi(a)}),function(e,t,i){return function(n,r){var a=r.response,s=ji(n,r),o=void 0;return s?i(s,e):0===a.byteLength?i({status:r.status,message:"Empty HLS segment content at URL: "+r.uri,code:qi,xhr:r},e):(e.stats=function(e){return{bandwidth:e.bandwidth,bytesReceived:e.bytesReceived||0,roundTripTime:e.roundTripTime||0}}(r),e.key?e.encryptedBytes=new Uint8Array(r.response):e.bytes=new Uint8Array(r.response),e.map&&e.map.bytes&&(t.isInitialized()||t.init(),(o=t.parse(e.bytes,e.map.videoTrackIds,e.map.timescales))&&o.captions&&(e.captionStreams=o.captionStreams,e.fmp4Captions=o.captions)),i(null,e))}}(a,r,d));return c.addEventListener("progress",Wi(a,s)),u.push(c),function(){return Hi(u)}},Yi=function(e,t){var i;return e&&(i=h.getComputedStyle(e))?i[t]:""},$i=function(e,t){var i=e.slice();e.sort(function(e,n){var r=t(e,n);return 0===r?i.indexOf(e)-i.indexOf(n):r})},Ki=function(e,t){var i=void 0,n=void 0;return e.attributes.BANDWIDTH&&(i=e.attributes.BANDWIDTH),i=i||h.Number.MAX_VALUE,t.attributes.BANDWIDTH&&(n=t.attributes.BANDWIDTH),i-(n=n||h.Number.MAX_VALUE)},Qi=Math.pow(2,32)-1;!function(){var e;if(gi={avc1:[],avcC:[],btrt:[],dinf:[],dref:[],esds:[],ftyp:[],hdlr:[],mdat:[],mdhd:[],mdia:[],mfhd:[],minf:[],moof:[],moov:[],mp4a:[],mvex:[],mvhd:[],sdtp:[],smhd:[],stbl:[],stco:[],stsc:[],stsd:[],stsz:[],stts:[],styp:[],tfdt:[],tfhd:[],traf:[],trak:[],trun:[],trex:[],tkhd:[],vmhd:[]},"undefined"!=typeof Uint8Array){for(e in gi)gi.hasOwnProperty(e)&&(gi[e]=[e.charCodeAt(0),e.charCodeAt(1),e.charCodeAt(2),e.charCodeAt(3)]);yi=new Uint8Array(["i".charCodeAt(0),"s".charCodeAt(0),"o".charCodeAt(0),"m".charCodeAt(0)]),vi=new Uint8Array(["a".charCodeAt(0),"v".charCodeAt(0),"c".charCodeAt(0),"1".charCodeAt(0)]),_i=new Uint8Array([0,0,0,1]),bi=new Uint8Array([0,0,0,0,0,0,0,0,118,105,100,101,0,0,0,0,0,0,0,0,0,0,0,0,86,105,100,101,111,72,97,110,100,108,101,114,0]),Ti=new Uint8Array([0,0,0,0,0,0,0,0,115,111,117,110,0,0,0,0,0,0,0,0,0,0,0,0,83,111,117,110,100,72,97,110,100,108,101,114,0]),Si={video:bi,audio:Ti},Ui=new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,12,117,114,108,32,0,0,0,1]),wi=new Uint8Array([0,0,0,0,0,0,0,0]),Li=new Uint8Array([0,0,0,0,0,0,0,0]),Ai=Li,Ei=new Uint8Array([0,0,0,0,0,0,0,0,0,0,0,0]),Oi=Li,ki=new Uint8Array([0,0,0,1,0,0,0,0,0,0,0,0])}}(),$t=function(e){var t,i,n=[],r=0;for(t=1;t<arguments.length;t++)n.push(arguments[t]);for(t=n.length;t--;)r+=n[t].byteLength;for(i=new Uint8Array(r+8),new DataView(i.buffer,i.byteOffset,i.byteLength).setUint32(0,i.byteLength),i.set(e,4),t=0,r=8;t<n.length;t++)i.set(n[t],r),r+=n[t].byteLength;return i},Kt=function(){return $t(gi.dinf,$t(gi.dref,Ui))},Qt=function(e){return $t(gi.esds,new Uint8Array([0,0,0,0,3,25,0,0,0,4,17,64,21,0,6,0,0,0,218,192,0,0,218,192,5,2,e.audioobjecttype<<3|e.samplingfrequencyindex>>>1,e.samplingfrequencyindex<<7|e.channelcount<<3,6,1,2]))},di=function(e){return $t(gi.hdlr,Si[e])},ui=function(e){var t=new Uint8Array([0,0,0,0,0,0,0,2,0,0,0,3,0,1,95,144,e.duration>>>24&255,e.duration>>>16&255,e.duration>>>8&255,255&e.duration,85,196,0,0]);return e.samplerate&&(t[12]=e.samplerate>>>24&255,t[13]=e.samplerate>>>16&255,t[14]=e.samplerate>>>8&255,t[15]=255&e.samplerate),$t(gi.mdhd,t)},oi=function(e){return $t(gi.mdia,ui(e),di(e.type),ei(e))},Jt=function(e){return $t(gi.mfhd,new Uint8Array([0,0,0,0,(4278190080&e)>>24,(16711680&e)>>16,(65280&e)>>8,255&e]))},ei=function(e){return $t(gi.minf,"video"===e.type?$t(gi.vmhd,ki):$t(gi.smhd,wi),Kt(),hi(e))},ti=function(e,t){for(var i=[],n=t.length;n--;)i[n]=fi(t[n]);return $t.apply(null,[gi.moof,Jt(e)].concat(i))},ii=function(e){for(var t=e.length,i=[];t--;)i[t]=ai(e[t]);return $t.apply(null,[gi.moov,ri(4294967295)].concat(i).concat(ni(e)))},ni=function(e){for(var t=e.length,i=[];t--;)i[t]=pi(e[t]);return $t.apply(null,[gi.mvex].concat(i))},ri=function(e){var t=new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,2,0,1,95,144,(4278190080&e)>>24,(16711680&e)>>16,(65280&e)>>8,255&e,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255]);return $t(gi.mvhd,t)},li=function(e){var t,i,n=e.samples||[],r=new Uint8Array(4+n.length);for(i=0;i<n.length;i++)t=n[i].flags,r[i+4]=t.dependsOn<<4|t.isDependedOn<<2|t.hasRedundancy;return $t(gi.sdtp,r)},hi=function(e){return $t(gi.stbl,ci(e),$t(gi.stts,Oi),$t(gi.stsc,Ai),$t(gi.stsz,Ei),$t(gi.stco,Li))},ci=function(e){return $t(gi.stsd,new Uint8Array([0,0,0,0,0,0,0,1]),"video"===e.type?Ii(e):Ci(e))},Ii=function(e){var t,i=e.sps||[],n=e.pps||[],r=[],a=[];for(t=0;t<i.length;t++)r.push((65280&i[t].byteLength)>>>8),r.push(255&i[t].byteLength),r=r.concat(Array.prototype.slice.call(i[t]));for(t=0;t<n.length;t++)a.push((65280&n[t].byteLength)>>>8),a.push(255&n[t].byteLength),a=a.concat(Array.prototype.slice.call(n[t]));return $t(gi.avc1,new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,(65280&e.width)>>8,255&e.width,(65280&e.height)>>8,255&e.height,0,72,0,0,0,72,0,0,0,0,0,0,0,1,19,118,105,100,101,111,106,115,45,99,111,110,116,114,105,98,45,104,108,115,0,0,0,0,0,0,0,0,0,0,0,0,0,24,17,17]),$t(gi.avcC,new Uint8Array([1,e.profileIdc,e.profileCompatibility,e.levelIdc,255].concat([i.length]).concat(r).concat([n.length]).concat(a))),$t(gi.btrt,new Uint8Array([0,28,156,128,0,45,198,192,0,45,198,192])))},Ci=function(e){return $t(gi.mp4a,new Uint8Array([0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,(65280&e.channelcount)>>8,255&e.channelcount,(65280&e.samplesize)>>8,255&e.samplesize,0,0,0,0,(65280&e.samplerate)>>8,255&e.samplerate,0,0]),Qt(e))},si=function(e){var t=new Uint8Array([0,0,0,7,0,0,0,0,0,0,0,0,(4278190080&e.id)>>24,(16711680&e.id)>>16,(65280&e.id)>>8,255&e.id,0,0,0,0,(4278190080&e.duration)>>24,(16711680&e.duration)>>16,(65280&e.duration)>>8,255&e.duration,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,(65280&e.width)>>8,255&e.width,0,0,(65280&e.height)>>8,255&e.height,0,0]);return $t(gi.tkhd,t)},fi=function(e){var t,i,n,r,a,s;return t=$t(gi.tfhd,new Uint8Array([0,0,0,58,(4278190080&e.id)>>24,(16711680&e.id)>>16,(65280&e.id)>>8,255&e.id,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0])),a=Math.floor(e.baseMediaDecodeTime/(Qi+1)),s=Math.floor(e.baseMediaDecodeTime%(Qi+1)),i=$t(gi.tfdt,new Uint8Array([1,0,0,0,a>>>24&255,a>>>16&255,a>>>8&255,255&a,s>>>24&255,s>>>16&255,s>>>8&255,255&s])),92,"audio"===e.type?(n=mi(e,92),$t(gi.traf,t,i,n)):(r=li(e),n=mi(e,r.length+92),$t(gi.traf,t,i,n,r))},ai=function(e){return e.duration=e.duration||4294967295,$t(gi.trak,si(e),oi(e))},pi=function(e){var t=new Uint8Array([0,0,0,0,(4278190080&e.id)>>24,(16711680&e.id)>>16,(65280&e.id)>>8,255&e.id,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,1]);return"video"!==e.type&&(t[t.length-1]=0),$t(gi.trex,t)},Ri=function(e,t){var i=0,n=0,r=0,a=0;return e.length&&(void 0!==e[0].duration&&(i=1),void 0!==e[0].size&&(n=2),void 0!==e[0].flags&&(r=4),void 0!==e[0].compositionTimeOffset&&(a=8)),[0,0,i|n|r|a,1,(4278190080&e.length)>>>24,(16711680&e.length)>>>16,(65280&e.length)>>>8,255&e.length,(4278190080&t)>>>24,(16711680&t)>>>16,(65280&t)>>>8,255&t]},Di=function(e,t){var i,n,r,a;for(t+=20+16*(n=e.samples||[]).length,i=Ri(n,t),a=0;a<n.length;a++)r=n[a],i=i.concat([(4278190080&r.duration)>>>24,(16711680&r.duration)>>>16,(65280&r.duration)>>>8,255&r.duration,(4278190080&r.size)>>>24,(16711680&r.size)>>>16,(65280&r.size)>>>8,255&r.size,r.flags.isLeading<<2|r.flags.dependsOn,r.flags.isDependedOn<<6|r.flags.hasRedundancy<<4|r.flags.paddingValue<<1|r.flags.isNonSyncSample,61440&r.flags.degradationPriority,15&r.flags.degradationPriority,(4278190080&r.compositionTimeOffset)>>>24,(16711680&r.compositionTimeOffset)>>>16,(65280&r.compositionTimeOffset)>>>8,255&r.compositionTimeOffset]);return $t(gi.trun,new Uint8Array(i))},Pi=function(e,t){var i,n,r,a;for(t+=20+8*(n=e.samples||[]).length,i=Ri(n,t),a=0;a<n.length;a++)r=n[a],i=i.concat([(4278190080&r.duration)>>>24,(16711680&r.duration)>>>16,(65280&r.duration)>>>8,255&r.duration,(4278190080&r.size)>>>24,(16711680&r.size)>>>16,(65280&r.size)>>>8,255&r.size]);return $t(gi.trun,new Uint8Array(i))},mi=function(e,t){return"audio"===e.type?Pi(e,t):Di(e,t)};var Zi={ftyp:Zt=function(){return $t(gi.ftyp,yi,_i,yi,vi)},mdat:function(e){return $t(gi.mdat,e)},moof:ti,moov:ii,initSegment:function(e){var t,i=Zt(),n=ii(e);return(t=new Uint8Array(i.byteLength+n.byteLength)).set(i),t.set(n,i.byteLength),t}},Ji=function(){this.init=function(){var e={};this.on=function(t,i){e[t]||(e[t]=[]),e[t]=e[t].concat(i)},this.off=function(t,i){var n;return!!e[t]&&(n=e[t].indexOf(i),e[t]=e[t].slice(),e[t].splice(n,1),n>-1)},this.trigger=function(t){var i,n,r,a;if(i=e[t])if(2===arguments.length)for(r=i.length,n=0;n<r;++n)i[n].call(this,arguments[1]);else{for(a=[],n=arguments.length,n=1;n<arguments.length;++n)a.push(arguments[n]);for(r=i.length,n=0;n<r;++n)i[n].apply(this,a)}},this.dispose=function(){e={}}}};Ji.prototype.pipe=function(e){return this.on("data",function(t){e.push(t)}),this.on("done",function(t){e.flush(t)}),e},Ji.prototype.push=function(e){this.trigger("data",e)},Ji.prototype.flush=function(e){this.trigger("done",e)};var en,tn,nn,rn,an,sn=Ji,on=function(e,t){var i={size:0,flags:{isLeading:0,dependsOn:1,isDependedOn:0,hasRedundancy:0,degradationPriority:0,isNonSyncSample:1}};return i.dataOffset=t,i.compositionTimeOffset=e.pts-e.dts,i.duration=e.duration,i.size=4*e.length,i.size+=e.byteLength,e.keyFrame&&(i.flags.dependsOn=2,i.flags.isNonSyncSample=0),i},un=function(e){var t,i,n=[],r=[];for(n.byteLength=0,t=0;t<e.length;t++)"access_unit_delimiter_rbsp"===(i=e[t]).nalUnitType?(n.length&&(n.duration=i.dts-n.dts,r.push(n)),(n=[i]).byteLength=i.data.byteLength,n.pts=i.pts,n.dts=i.dts):("slice_layer_without_partitioning_rbsp_idr"===i.nalUnitType&&(n.keyFrame=!0),n.duration=i.dts-n.dts,n.byteLength+=i.data.byteLength,n.push(i));return r.length&&(!n.duration||n.duration<=0)&&(n.duration=r[r.length-1].duration),r.push(n),r},dn=function(e){var t,i,n=[],r=[];for(n.byteLength=0,n.nalCount=0,n.duration=0,n.pts=e[0].pts,n.dts=e[0].dts,r.byteLength=0,r.nalCount=0,r.duration=0,r.pts=e[0].pts,r.dts=e[0].dts,t=0;t<e.length;t++)(i=e[t]).keyFrame?(n.length&&(r.push(n),r.byteLength+=n.byteLength,r.nalCount+=n.nalCount,r.duration+=n.duration),(n=[i]).nalCount=i.length,n.byteLength=i.byteLength,n.pts=i.pts,n.dts=i.dts,n.duration=i.duration):(n.duration+=i.duration,n.nalCount+=i.length,n.byteLength+=i.byteLength,n.push(i));return r.length&&n.duration<=0&&(n.duration=r[r.length-1].duration),r.byteLength+=n.byteLength,r.nalCount+=n.nalCount,r.duration+=n.duration,r.push(n),r},ln=function(e){var t;return!e[0][0].keyFrame&&e.length>1&&(t=e.shift(),e.byteLength-=t.byteLength,e.nalCount-=t.nalCount,e[0][0].dts=t.dts,e[0][0].pts=t.pts,e[0][0].duration+=t.duration),e},hn=function(e,t){var i,n,r,a,s,o=t||0,u=[];for(i=0;i<e.length;i++)for(a=e[i],n=0;n<a.length;n++)s=a[n],o+=(r=on(s,o)).size,u.push(r);return u},cn=function(e){var t,i,n,r,a,s,o=0,u=e.byteLength,d=e.nalCount,l=new Uint8Array(u+4*d),h=new DataView(l.buffer);for(t=0;t<e.length;t++)for(r=e[t],i=0;i<r.length;i++)for(a=r[i],n=0;n<a.length;n++)s=a[n],h.setUint32(o,s.data.byteLength),o+=4,l.set(s.data,o),o+=s.data.byteLength;return l},fn=[33,16,5,32,164,27],pn=[33,65,108,84,1,2,4,8,168,2,4,8,17,191,252],mn=function(e){for(var t=[];e--;)t.push(0);return t},gn={96000:[fn,[227,64],mn(154),[56]],88200:[fn,[231],mn(170),[56]],64000:[fn,[248,192],mn(240),[56]],48000:[fn,[255,192],mn(268),[55,148,128],mn(54),[112]],44100:[fn,[255,192],mn(268),[55,163,128],mn(84),[112]],32000:[fn,[255,192],mn(268),[55,234],mn(226),[112]],24000:[fn,[255,192],mn(268),[55,255,128],mn(268),[111,112],mn(126),[224]],16000:[fn,[255,192],mn(268),[55,255,128],mn(268),[111,255],mn(269),[223,108],mn(195),[1,192]],12000:[pn,mn(268),[3,127,248],mn(268),[6,255,240],mn(268),[13,255,224],mn(268),[27,253,128],mn(259),[56]],11025:[pn,mn(268),[3,127,248],mn(268),[6,255,240],mn(268),[13,255,224],mn(268),[27,255,192],mn(268),[55,175,128],mn(108),[112]],8000:[pn,mn(268),[3,121,16],mn(47),[7]]},yn=(en=gn,Object.keys(en).reduce(function(e,t){return e[t]=new Uint8Array(en[t].reduce(function(e,t){return e.concat(t)},[])),e},{})),_n=(tn=function(e){return 9e4*e},nn=function(e,t){return e*t},rn=function(e){return e/9e4},an=function(e,t){return e/t},function(e,t){return tn(an(e,t))}),vn=function(e,t){return nn(rn(e),t)},bn=function(e,t,i,n){var r,a,s,o,u=0,d=0,l=0;if(t.length&&(r=_n(e.baseMediaDecodeTime,e.samplerate),a=Math.ceil(9e4/(e.samplerate/1024)),i&&n&&(u=r-Math.max(i,n),l=(d=Math.floor(u/a))*a),!(d<1||l>45e3))){for((s=yn[e.samplerate])||(s=t[0].data),o=0;o<d;o++)t.splice(o,0,{data:s});e.baseMediaDecodeTime-=Math.floor(vn(l,e.samplerate))}},Tn=function(e,t,i){return t.minSegmentDts>=i?e:(t.minSegmentDts=1/0,e.filter(function(e){return e.dts>=i&&(t.minSegmentDts=Math.min(t.minSegmentDts,e.dts),t.minSegmentPts=t.minSegmentDts,!0)}))},Sn=function(e){var t,i,n=[];for(t=0;t<e.length;t++)i=e[t],n.push({size:i.data.byteLength,duration:1024});return n},kn=function(e){var t,i,n=0,r=new Uint8Array(function(e){var t,i=0;for(t=0;t<e.length;t++)i+=e[t].data.byteLength;return i}(e));for(t=0;t<e.length;t++)i=e[t],r.set(i.data,n),n+=i.data.byteLength;return r},wn=function(e){delete e.minSegmentDts,delete e.maxSegmentDts,delete e.minSegmentPts,delete e.maxSegmentPts},Un=function(e,t){var i,n=e.minSegmentDts;return t||(n-=e.timelineStartInfo.dts),i=e.timelineStartInfo.baseMediaDecodeTime,i+=n,i=Math.max(0,i),"audio"===e.type&&(i*=e.samplerate/9e4,i=Math.floor(i)),i},Ln=function(e,t){"number"==typeof t.pts&&(void 0===e.timelineStartInfo.pts&&(e.timelineStartInfo.pts=t.pts),void 0===e.minSegmentPts?e.minSegmentPts=t.pts:e.minSegmentPts=Math.min(e.minSegmentPts,t.pts),void 0===e.maxSegmentPts?e.maxSegmentPts=t.pts:e.maxSegmentPts=Math.max(e.maxSegmentPts,t.pts)),"number"==typeof t.dts&&(void 0===e.timelineStartInfo.dts&&(e.timelineStartInfo.dts=t.dts),void 0===e.minSegmentDts?e.minSegmentDts=t.dts:e.minSegmentDts=Math.min(e.minSegmentDts,t.dts),void 0===e.maxSegmentDts?e.maxSegmentDts=t.dts:e.maxSegmentDts=Math.max(e.maxSegmentDts,t.dts))},An=function(e){for(var t=0,i={payloadType:-1,payloadSize:0},n=0,r=0;t<e.byteLength&&128!==e[t];){for(;255===e[t];)n+=255,t++;for(n+=e[t++];255===e[t];)r+=255,t++;if(r+=e[t++],!i.payload&&4===n){i.payloadType=n,i.payloadSize=r,i.payload=e.subarray(t,t+r);break}t+=r,n=0,r=0}return i},En=function(e){return 181!==e.payload[0]?null:49!=(e.payload[1]<<8|e.payload[2])?null:"GA94"!==String.fromCharCode(e.payload[3],e.payload[4],e.payload[5],e.payload[6])?null:3!==e.payload[7]?null:e.payload.subarray(8,e.payload.length-1)},On=function(e,t){var i,n,r,a,s=[];if(!(64&t[0]))return s;for(n=31&t[0],i=0;i<n;i++)a={type:3&t[2+(r=3*i)],pts:e},4&t[r+2]&&(a.ccData=t[r+3]<<8|t[r+4],s.push(a));return s},In=function(e){for(var t,i,n=e.byteLength,r=[],a=1;a<n-2;)0===e[a]&&0===e[a+1]&&3===e[a+2]?(r.push(a+2),a+=2):a++;if(0===r.length)return e;t=n-r.length,i=new Uint8Array(t);var s=0;for(a=0;a<t;s++,a++)s===r[0]&&(s++,r.shift()),i[a]=e[s];return i},Cn=4,Pn=function e(){e.prototype.init.call(this),this.captionPackets_=[],this.ccStreams_=[new Bn(0,0),new Bn(0,1),new Bn(1,0),new Bn(1,1)],this.reset(),this.ccStreams_.forEach(function(e){e.on("data",this.trigger.bind(this,"data")),e.on("done",this.trigger.bind(this,"done"))},this)};(Pn.prototype=new sn).push=function(e){var t,i,n;if("sei_rbsp"===e.nalUnitType&&(t=An(e.escapedRBSP)).payloadType===Cn&&(i=En(t)))if(e.dts<this.latestDts_)this.ignoreNextEqualDts_=!0;else{if(e.dts===this.latestDts_&&this.ignoreNextEqualDts_)return this.numSameDts_--,void(this.numSameDts_||(this.ignoreNextEqualDts_=!1));n=On(e.pts,i),this.captionPackets_=this.captionPackets_.concat(n),this.latestDts_!==e.dts&&(this.numSameDts_=0),this.numSameDts_++,this.latestDts_=e.dts}},Pn.prototype.flush=function(){this.captionPackets_.length?(this.captionPackets_.forEach(function(e,t){e.presortIndex=t}),this.captionPackets_.sort(function(e,t){return e.pts===t.pts?e.presortIndex-t.presortIndex:e.pts-t.pts}),this.captionPackets_.forEach(function(e){e.type<2&&this.dispatchCea608Packet(e)},this),this.captionPackets_.length=0,this.ccStreams_.forEach(function(e){e.flush()},this)):this.ccStreams_.forEach(function(e){e.flush()},this)},Pn.prototype.reset=function(){this.latestDts_=null,this.ignoreNextEqualDts_=!1,this.numSameDts_=0,this.activeCea608Channel_=[null,null],this.ccStreams_.forEach(function(e){e.reset()})},Pn.prototype.dispatchCea608Packet=function(e){this.setsChannel1Active(e)?this.activeCea608Channel_[e.type]=0:this.setsChannel2Active(e)&&(this.activeCea608Channel_[e.type]=1),null!==this.activeCea608Channel_[e.type]&&this.ccStreams_[(e.type<<1)+this.activeCea608Channel_[e.type]].push(e)},Pn.prototype.setsChannel1Active=function(e){return 4096==(30720&e.ccData)},Pn.prototype.setsChannel2Active=function(e){return 6144==(30720&e.ccData)};var Dn={42:225,92:233,94:237,95:243,96:250,123:231,124:247,125:209,126:241,127:9608,304:174,305:176,306:189,307:191,308:8482,309:162,310:163,311:9834,312:224,313:160,314:232,315:226,316:234,317:238,318:244,319:251,544:193,545:201,546:211,547:218,548:220,549:252,550:8216,551:161,552:42,553:39,554:8212,555:169,556:8480,557:8226,558:8220,559:8221,560:192,561:194,562:199,563:200,564:202,565:203,566:235,567:206,568:207,569:239,570:212,571:217,572:249,573:219,574:171,575:187,800:195,801:227,802:205,803:204,804:236,805:210,806:242,807:213,808:245,809:123,810:125,811:92,812:94,813:95,814:124,815:126,816:196,817:228,818:214,819:246,820:223,821:165,822:164,823:9474,824:197,825:229,826:216,827:248,828:9484,829:9488,830:9492,831:9496},Rn=function(e){return null===e?"":(e=Dn[e]||e,String.fromCharCode(e))},xn=[4352,4384,4608,4640,5376,5408,5632,5664,5888,5920,4096,4864,4896,5120,5152],Mn=function(){for(var e=[],t=15;t--;)e.push("");return e},Bn=function e(t,i){e.prototype.init.call(this),this.field_=t||0,this.dataChannel_=i||0,this.name_="CC"+(1+(this.field_<<1|this.dataChannel_)),this.setConstants(),this.reset(),this.push=function(e){var t,i,n,r,a;if((t=32639&e.ccData)!==this.lastControlCode_){if(4096==(61440&t)?this.lastControlCode_=t:t!==this.PADDING_&&(this.lastControlCode_=null),n=t>>>8,r=255&t,t!==this.PADDING_)if(t===this.RESUME_CAPTION_LOADING_)this.mode_="popOn";else if(t===this.END_OF_CAPTION_)this.mode_="popOn",this.clearFormatting(e.pts),this.flushDisplayed(e.pts),i=this.displayed_,this.displayed_=this.nonDisplayed_,this.nonDisplayed_=i,this.startPts_=e.pts;else if(t===this.ROLL_UP_2_ROWS_)this.rollUpRows_=2,this.setRollUp(e.pts);else if(t===this.ROLL_UP_3_ROWS_)this.rollUpRows_=3,this.setRollUp(e.pts);else if(t===this.ROLL_UP_4_ROWS_)this.rollUpRows_=4,this.setRollUp(e.pts);else if(t===this.CARRIAGE_RETURN_)this.clearFormatting(e.pts),this.flushDisplayed(e.pts),this.shiftRowsUp_(),this.startPts_=e.pts;else if(t===this.BACKSPACE_)"popOn"===this.mode_?this.nonDisplayed_[this.row_]=this.nonDisplayed_[this.row_].slice(0,-1):this.displayed_[this.row_]=this.displayed_[this.row_].slice(0,-1);else if(t===this.ERASE_DISPLAYED_MEMORY_)this.flushDisplayed(e.pts),this.displayed_=Mn();else if(t===this.ERASE_NON_DISPLAYED_MEMORY_)this.nonDisplayed_=Mn();else if(t===this.RESUME_DIRECT_CAPTIONING_)"paintOn"!==this.mode_&&(this.flushDisplayed(e.pts),this.displayed_=Mn()),this.mode_="paintOn",this.startPts_=e.pts;else if(this.isSpecialCharacter(n,r))a=Rn((n=(3&n)<<8)|r),this[this.mode_](e.pts,a),this.column_++;else if(this.isExtCharacter(n,r))"popOn"===this.mode_?this.nonDisplayed_[this.row_]=this.nonDisplayed_[this.row_].slice(0,-1):this.displayed_[this.row_]=this.displayed_[this.row_].slice(0,-1),a=Rn((n=(3&n)<<8)|r),this[this.mode_](e.pts,a),this.column_++;else if(this.isMidRowCode(n,r))this.clearFormatting(e.pts),this[this.mode_](e.pts," "),this.column_++,14==(14&r)&&this.addFormatting(e.pts,["i"]),1==(1&r)&&this.addFormatting(e.pts,["u"]);else if(this.isOffsetControlCode(n,r))this.column_+=3&r;else if(this.isPAC(n,r)){var s=xn.indexOf(7968&t);"rollUp"===this.mode_&&(s-this.rollUpRows_+1<0&&(s=this.rollUpRows_-1),this.setRollUp(e.pts,s)),s!==this.row_&&(this.clearFormatting(e.pts),this.row_=s),1&r&&-1===this.formatting_.indexOf("u")&&this.addFormatting(e.pts,["u"]),16==(16&t)&&(this.column_=4*((14&t)>>1)),this.isColorPAC(r)&&14==(14&r)&&this.addFormatting(e.pts,["i"])}else this.isNormalChar(n)&&(0===r&&(r=null),a=Rn(n),a+=Rn(r),this[this.mode_](e.pts,a),this.column_+=a.length)}else this.lastControlCode_=null}};Bn.prototype=new sn,Bn.prototype.flushDisplayed=function(e){var t=this.displayed_.map(function(e){try{return e.trim()}catch(e){return console.error("Skipping malformed caption."),""}}).join("\n").replace(/^\n+|\n+$/g,"");t.length&&this.trigger("data",{startPts:this.startPts_,endPts:e,text:t,stream:this.name_})},Bn.prototype.reset=function(){this.mode_="popOn",this.topRow_=0,this.startPts_=0,this.displayed_=Mn(),this.nonDisplayed_=Mn(),this.lastControlCode_=null,this.column_=0,this.row_=14,this.rollUpRows_=2,this.formatting_=[]},Bn.prototype.setConstants=function(){0===this.dataChannel_?(this.BASE_=16,this.EXT_=17,this.CONTROL_=(20|this.field_)<<8,this.OFFSET_=23):1===this.dataChannel_&&(this.BASE_=24,this.EXT_=25,this.CONTROL_=(28|this.field_)<<8,this.OFFSET_=31),this.PADDING_=0,this.RESUME_CAPTION_LOADING_=32|this.CONTROL_,this.END_OF_CAPTION_=47|this.CONTROL_,this.ROLL_UP_2_ROWS_=37|this.CONTROL_,this.ROLL_UP_3_ROWS_=38|this.CONTROL_,this.ROLL_UP_4_ROWS_=39|this.CONTROL_,this.CARRIAGE_RETURN_=45|this.CONTROL_,this.RESUME_DIRECT_CAPTIONING_=41|this.CONTROL_,this.BACKSPACE_=33|this.CONTROL_,this.ERASE_DISPLAYED_MEMORY_=44|this.CONTROL_,this.ERASE_NON_DISPLAYED_MEMORY_=46|this.CONTROL_},Bn.prototype.isSpecialCharacter=function(e,t){return e===this.EXT_&&t>=48&&t<=63},Bn.prototype.isExtCharacter=function(e,t){return(e===this.EXT_+1||e===this.EXT_+2)&&t>=32&&t<=63},Bn.prototype.isMidRowCode=function(e,t){return e===this.EXT_&&t>=32&&t<=47},Bn.prototype.isOffsetControlCode=function(e,t){return e===this.OFFSET_&&t>=33&&t<=35},Bn.prototype.isPAC=function(e,t){return e>=this.BASE_&&e<this.BASE_+8&&t>=64&&t<=127},Bn.prototype.isColorPAC=function(e){return e>=64&&e<=79||e>=96&&e<=127},Bn.prototype.isNormalChar=function(e){return e>=32&&e<=127},Bn.prototype.setRollUp=function(e,t){if("rollUp"!==this.mode_&&(this.row_=14,this.mode_="rollUp",this.flushDisplayed(e),this.nonDisplayed_=Mn(),this.displayed_=Mn()),void 0!==t&&t!==this.row_)for(var i=0;i<this.rollUpRows_;i++)this.displayed_[t-i]=this.displayed_[this.row_-i],this.displayed_[this.row_-i]="";void 0===t&&(t=this.row_),this.topRow_=t-this.rollUpRows_+1},Bn.prototype.addFormatting=function(e,t){this.formatting_=this.formatting_.concat(t);var i=t.reduce(function(e,t){return e+"<"+t+">"},"");this[this.mode_](e,i)},Bn.prototype.clearFormatting=function(e){if(this.formatting_.length){var t=this.formatting_.reverse().reduce(function(e,t){return e+"</"+t+">"},"");this.formatting_=[],this[this.mode_](e,t)}},Bn.prototype.popOn=function(e,t){var i=this.nonDisplayed_[this.row_];i+=t,this.nonDisplayed_[this.row_]=i},Bn.prototype.rollUp=function(e,t){var i=this.displayed_[this.row_];i+=t,this.displayed_[this.row_]=i},Bn.prototype.shiftRowsUp_=function(){var e;for(e=0;e<this.topRow_;e++)this.displayed_[e]="";for(e=this.row_+1;e<15;e++)this.displayed_[e]="";for(e=this.topRow_;e<this.row_;e++)this.displayed_[e]=this.displayed_[e+1];this.displayed_[this.row_]=""},Bn.prototype.paintOn=function(e,t){var i=this.displayed_[this.row_];i+=t,this.displayed_[this.row_]=i};var Nn={CaptionStream:Pn,Cea608Stream:Bn},qn={H264_STREAM_TYPE:27,ADTS_STREAM_TYPE:15,METADATA_STREAM_TYPE:21},Fn=function(e,t){var i=1;for(e>t&&(i=-1);Math.abs(t-e)>4294967296;)e+=8589934592*i;return e},Gn=function e(t){var i,n;e.prototype.init.call(this),this.type_=t,this.push=function(e){e.type===this.type_&&(void 0===n&&(n=e.dts),e.dts=Fn(e.dts,n),e.pts=Fn(e.pts,n),i=e.dts,this.trigger("data",e))},this.flush=function(){n=i,this.trigger("done")},this.discontinuity=function(){n=void 0,i=void 0}};Gn.prototype=new sn;var Vn,Hn=Gn,jn=Fn,zn=function(e,t,i){var n,r="";for(n=t;n<i;n++)r+="%"+("00"+e[n].toString(16)).slice(-2);return r},Wn=function(e,t,i){return decodeURIComponent(zn(e,t,i))},Xn=function(e){return e[0]<<21|e[1]<<14|e[2]<<7|e[3]},Yn={TXXX:function(e){var t;if(3===e.data[0]){for(t=1;t<e.data.length;t++)if(0===e.data[t]){e.description=Wn(e.data,1,t),e.value=Wn(e.data,t+1,e.data.length).replace(/\0*$/,"");break}e.data=e.value}},WXXX:function(e){var t;if(3===e.data[0])for(t=1;t<e.data.length;t++)if(0===e.data[t]){e.description=Wn(e.data,1,t),e.url=Wn(e.data,t+1,e.data.length);break}},PRIV:function(e){var t,i;for(t=0;t<e.data.length;t++)if(0===e.data[t]){e.owner=(i=e.data,unescape(zn(i,0,t)));break}e.privateData=e.data.subarray(t+1),e.data=e.privateData}};(Vn=function(e){var t,i={debug:!(!e||!e.debug),descriptor:e&&e.descriptor},n=0,r=[],a=0;if(Vn.prototype.init.call(this),this.dispatchType=qn.METADATA_STREAM_TYPE.toString(16),i.descriptor)for(t=0;t<i.descriptor.length;t++)this.dispatchType+=("00"+i.descriptor[t].toString(16)).slice(-2);this.push=function(e){var t,s,o,u,d;if("timed-metadata"===e.type)if(e.dataAlignmentIndicator&&(a=0,r.length=0),0===r.length&&(e.data.length<10||e.data[0]!=="I".charCodeAt(0)||e.data[1]!=="D".charCodeAt(0)||e.data[2]!=="3".charCodeAt(0)))i.debug&&console.log("Skipping unrecognized metadata packet");else if(r.push(e),a+=e.data.byteLength,1===r.length&&(n=Xn(e.data.subarray(6,10)),n+=10),!(a<n)){for(t={data:new Uint8Array(n),frames:[],pts:r[0].pts,dts:r[0].dts},d=0;d<n;)t.data.set(r[0].data.subarray(0,n-d),d),d+=r[0].data.byteLength,a-=r[0].data.byteLength,r.shift();s=10,64&t.data[5]&&(s+=4,s+=Xn(t.data.subarray(10,14)),n-=Xn(t.data.subarray(16,20)));do{if((o=Xn(t.data.subarray(s+4,s+8)))<1)return console.log("Malformed ID3 frame encountered. Skipping metadata parsing.");if((u={id:String.fromCharCode(t.data[s],t.data[s+1],t.data[s+2],t.data[s+3]),data:t.data.subarray(s+10,s+o+10)}).key=u.id,Yn[u.id]&&(Yn[u.id](u),"com.apple.streaming.transportStreamTimestamp"===u.owner)){var l=u.data,h=(1&l[3])<<30|l[4]<<22|l[5]<<14|l[6]<<6|l[7]>>>2;h*=4,h+=3&l[7],u.timeStamp=h,void 0===t.pts&&void 0===t.dts&&(t.pts=u.timeStamp,t.dts=u.timeStamp),this.trigger("timestamp",u)}t.frames.push(u),s+=10,s+=o}while(s<n);this.trigger("data",t)}}}).prototype=new sn;var $n,Kn,Qn,Zn=Vn,Jn=Hn;($n=function(){var e=new Uint8Array(188),t=0;$n.prototype.init.call(this),this.push=function(i){var n,r=0,a=188;for(t?((n=new Uint8Array(i.byteLength+t)).set(e.subarray(0,t)),n.set(i,t),t=0):n=i;a<n.byteLength;)71!==n[r]||71!==n[a]?(r++,a++):(this.trigger("data",n.subarray(r,a)),r+=188,a+=188);r<n.byteLength&&(e.set(n.subarray(r),0),t=n.byteLength-r)},this.flush=function(){188===t&&71===e[0]&&(this.trigger("data",e),t=0),this.trigger("done")}}).prototype=new sn,(Kn=function(){var e,t,i,n;Kn.prototype.init.call(this),n=this,this.packetsWaitingForPmt=[],this.programMapTable=void 0,e=function(e,n){var r=0;n.payloadUnitStartIndicator&&(r+=e[r]+1),"pat"===n.type?t(e.subarray(r),n):i(e.subarray(r),n)},t=function(e,t){t.section_number=e[7],t.last_section_number=e[8],n.pmtPid=(31&e[10])<<8|e[11],t.pmtPid=n.pmtPid},i=function(e,t){var i,r;if(1&e[5]){for(n.programMapTable={video:null,audio:null,"timed-metadata":{}},i=3+((15&e[1])<<8|e[2])-4,r=12+((15&e[10])<<8|e[11]);r<i;){var a=e[r],s=(31&e[r+1])<<8|e[r+2];a===qn.H264_STREAM_TYPE&&null===n.programMapTable.video?n.programMapTable.video=s:a===qn.ADTS_STREAM_TYPE&&null===n.programMapTable.audio?n.programMapTable.audio=s:a===qn.METADATA_STREAM_TYPE&&(n.programMapTable["timed-metadata"][s]=a),r+=5+((15&e[r+3])<<8|e[r+4])}t.programMapTable=n.programMapTable}},this.push=function(t){var i={},n=4;if(i.payloadUnitStartIndicator=!!(64&t[1]),i.pid=31&t[1],i.pid<<=8,i.pid|=t[2],(48&t[3])>>>4>1&&(n+=t[n]+1),0===i.pid)i.type="pat",e(t.subarray(n),i),this.trigger("data",i);else if(i.pid===this.pmtPid)for(i.type="pmt",e(t.subarray(n),i),this.trigger("data",i);this.packetsWaitingForPmt.length;)this.processPes_.apply(this,this.packetsWaitingForPmt.shift());else void 0===this.programMapTable?this.packetsWaitingForPmt.push([t,n,i]):this.processPes_(t,n,i)},this.processPes_=function(e,t,i){i.pid===this.programMapTable.video?i.streamType=qn.H264_STREAM_TYPE:i.pid===this.programMapTable.audio?i.streamType=qn.ADTS_STREAM_TYPE:i.streamType=this.programMapTable["timed-metadata"][i.pid],i.type="pes",i.data=e.subarray(t),this.trigger("data",i)}}).prototype=new sn,Kn.STREAM_TYPES={h264:27,adts:15},(Qn=function(){var e=this,t={data:[],size:0},i={data:[],size:0},n={data:[],size:0},r=function(t,i,n){var r,a,s=new Uint8Array(t.size),o={type:i},u=0,d=0;if(t.data.length&&!(t.size<9)){for(o.trackId=t.data[0].pid,u=0;u<t.data.length;u++)a=t.data[u],s.set(a.data,d),d+=a.data.byteLength;var l,h,c;l=s,(h=o).packetLength=6+(l[4]<<8|l[5]),h.dataAlignmentIndicator=0!=(4&l[6]),192&(c=l[7])&&(h.pts=(14&l[9])<<27|(255&l[10])<<20|(254&l[11])<<12|(255&l[12])<<5|(254&l[13])>>>3,h.pts*=4,h.pts+=(6&l[13])>>>1,h.dts=h.pts,64&c&&(h.dts=(14&l[14])<<27|(255&l[15])<<20|(254&l[16])<<12|(255&l[17])<<5|(254&l[18])>>>3,h.dts*=4,h.dts+=(6&l[18])>>>1)),h.data=l.subarray(9+l[8]),r="video"===i||o.packetLength<=t.size,(n||r)&&(t.size=0,t.data.length=0),r&&e.trigger("data",o)}};Qn.prototype.init.call(this),this.push=function(a){({pat:function(){},pes:function(){var e,s;switch(a.streamType){case qn.H264_STREAM_TYPE:case qn.H264_STREAM_TYPE:e=t,s="video";break;case qn.ADTS_STREAM_TYPE:e=i,s="audio";break;case qn.METADATA_STREAM_TYPE:e=n,s="timed-metadata";break;default:return}a.payloadUnitStartIndicator&&r(e,s,!0),e.data.push(a),e.size+=a.data.byteLength},pmt:function(){var t={type:"metadata",tracks:[]},i=a.programMapTable;null!==i.video&&t.tracks.push({timelineStartInfo:{baseMediaDecodeTime:0},id:+i.video,codec:"avc",type:"video"}),null!==i.audio&&t.tracks.push({timelineStartInfo:{baseMediaDecodeTime:0},id:+i.audio,codec:"adts",type:"audio"}),e.trigger("data",t)}})[a.type]()},this.flush=function(){r(t,"video"),r(i,"audio"),r(n,"timed-metadata"),this.trigger("done")}}).prototype=new sn;var er={PAT_PID:0,MP2T_PACKET_LENGTH:188,TransportPacketStream:$n,TransportParseStream:Kn,ElementaryStream:Qn,TimestampRolloverStream:Jn,CaptionStream:Nn.CaptionStream,Cea608Stream:Nn.Cea608Stream,MetadataStream:Zn};for(var tr in qn)qn.hasOwnProperty(tr)&&(er[tr]=qn[tr]);var ir,nr=er,rr=[96e3,88200,64e3,48e3,44100,32e3,24e3,22050,16e3,12e3,11025,8e3,7350];(ir=function(){var e;ir.prototype.init.call(this),this.push=function(t){var i,n,r,a,s,o,u=0,d=0;if("audio"===t.type)for(e?(a=e,(e=new Uint8Array(a.byteLength+t.data.byteLength)).set(a),e.set(t.data,a.byteLength)):e=t.data;u+5<e.length;)if(255===e[u]&&240==(246&e[u+1])){if(n=2*(1&~e[u+1]),i=(3&e[u+3])<<11|e[u+4]<<3|(224&e[u+5])>>5,o=9e4*(s=1024*(1+(3&e[u+6])))/rr[(60&e[u+2])>>>2],r=u+i,e.byteLength<r)return;if(this.trigger("data",{pts:t.pts+d*o,dts:t.dts+d*o,sampleCount:s,audioobjecttype:1+(e[u+2]>>>6&3),channelcount:(1&e[u+2])<<2|(192&e[u+3])>>>6,samplerate:rr[(60&e[u+2])>>>2],samplingfrequencyindex:(60&e[u+2])>>>2,samplesize:16,data:e.subarray(u+7+n,r)}),e.byteLength===r)return void(e=void 0);d++,e=e.subarray(r)}else u++},this.flush=function(){this.trigger("done")}}).prototype=new sn;var ar,sr,or,ur=ir,dr=function(e){var t=e.byteLength,i=0,n=0;this.length=function(){return 8*t},this.bitsAvailable=function(){return 8*t+n},this.loadWord=function(){var r=e.byteLength-t,a=new Uint8Array(4),s=Math.min(4,t);if(0===s)throw new Error("no bytes available");a.set(e.subarray(r,r+s)),i=new DataView(a.buffer).getUint32(0),n=8*s,t-=s},this.skipBits=function(e){var r;n>e?(i<<=e,n-=e):(e-=n,e-=8*(r=Math.floor(e/8)),t-=r,this.loadWord(),i<<=e,n-=e)},this.readBits=function(e){var r=Math.min(n,e),a=i>>>32-r;return(n-=r)>0?i<<=r:t>0&&this.loadWord(),(r=e-r)>0?a<<r|this.readBits(r):a},this.skipLeadingZeros=function(){var e;for(e=0;e<n;++e)if(0!=(i&2147483648>>>e))return i<<=e,n-=e,e;return this.loadWord(),e+this.skipLeadingZeros()},this.skipUnsignedExpGolomb=function(){this.skipBits(1+this.skipLeadingZeros())},this.skipExpGolomb=function(){this.skipBits(1+this.skipLeadingZeros())},this.readUnsignedExpGolomb=function(){var e=this.skipLeadingZeros();return this.readBits(e+1)-1},this.readExpGolomb=function(){var e=this.readUnsignedExpGolomb();return 1&e?1+e>>>1:-1*(e>>>1)},this.readBoolean=function(){return 1===this.readBits(1)},this.readUnsignedByte=function(){return this.readBits(8)},this.loadWord()};(sr=function(){var e,t,i=0;sr.prototype.init.call(this),this.push=function(n){var r;for(t?((r=new Uint8Array(t.byteLength+n.data.byteLength)).set(t),r.set(n.data,t.byteLength),t=r):t=n.data;i<t.byteLength-3;i++)if(1===t[i+2]){e=i+5;break}for(;e<t.byteLength;)switch(t[e]){case 0:if(0!==t[e-1]){e+=2;break}if(0!==t[e-2]){e++;break}i+3!==e-2&&this.trigger("data",t.subarray(i+3,e-2));do{e++}while(1!==t[e]&&e<t.length);i=e-2,e+=3;break;case 1:if(0!==t[e-1]||0!==t[e-2]){e+=3;break}this.trigger("data",t.subarray(i+3,e-2)),i=e-2,e+=3;break;default:e+=3}t=t.subarray(i),e-=i,i=0},this.flush=function(){t&&t.byteLength>3&&this.trigger("data",t.subarray(i+3)),t=null,i=0,this.trigger("done")}}).prototype=new sn,or={100:!0,110:!0,122:!0,244:!0,44:!0,83:!0,86:!0,118:!0,128:!0,138:!0,139:!0,134:!0},(ar=function(){var e,t,i,n,r,a,s,o=new sr;ar.prototype.init.call(this),e=this,this.push=function(e){"video"===e.type&&(t=e.trackId,i=e.pts,n=e.dts,o.push(e))},o.on("data",function(s){var o={trackId:t,pts:i,dts:n,data:s};switch(31&s[0]){case 5:o.nalUnitType="slice_layer_without_partitioning_rbsp_idr";break;case 6:o.nalUnitType="sei_rbsp",o.escapedRBSP=r(s.subarray(1));break;case 7:o.nalUnitType="seq_parameter_set_rbsp",o.escapedRBSP=r(s.subarray(1)),o.config=a(o.escapedRBSP);break;case 8:o.nalUnitType="pic_parameter_set_rbsp";break;case 9:o.nalUnitType="access_unit_delimiter_rbsp"}e.trigger("data",o)}),o.on("done",function(){e.trigger("done")}),this.flush=function(){o.flush()},s=function(e,t){var i,n=8,r=8;for(i=0;i<e;i++)0!==r&&(r=(n+t.readExpGolomb()+256)%256),n=0===r?n:r},r=function(e){for(var t,i,n=e.byteLength,r=[],a=1;a<n-2;)0===e[a]&&0===e[a+1]&&3===e[a+2]?(r.push(a+2),a+=2):a++;if(0===r.length)return e;t=n-r.length,i=new Uint8Array(t);var s=0;for(a=0;a<t;s++,a++)s===r[0]&&(s++,r.shift()),i[a]=e[s];return i},a=function(e){var t,i,n,r,a,o,u,d,l,h,c,f,p,m=0,g=0,y=0,_=0,v=1;if(i=(t=new dr(e)).readUnsignedByte(),r=t.readUnsignedByte(),n=t.readUnsignedByte(),t.skipUnsignedExpGolomb(),or[i]&&(3===(a=t.readUnsignedExpGolomb())&&t.skipBits(1),t.skipUnsignedExpGolomb(),t.skipUnsignedExpGolomb(),t.skipBits(1),t.readBoolean()))for(c=3!==a?8:12,p=0;p<c;p++)t.readBoolean()&&s(p<6?16:64,t);if(t.skipUnsignedExpGolomb(),0===(o=t.readUnsignedExpGolomb()))t.readUnsignedExpGolomb();else if(1===o)for(t.skipBits(1),t.skipExpGolomb(),t.skipExpGolomb(),u=t.readUnsignedExpGolomb(),p=0;p<u;p++)t.skipExpGolomb();if(t.skipUnsignedExpGolomb(),t.skipBits(1),d=t.readUnsignedExpGolomb(),l=t.readUnsignedExpGolomb(),0===(h=t.readBits(1))&&t.skipBits(1),t.skipBits(1),t.readBoolean()&&(m=t.readUnsignedExpGolomb(),g=t.readUnsignedExpGolomb(),y=t.readUnsignedExpGolomb(),_=t.readUnsignedExpGolomb()),t.readBoolean()&&t.readBoolean()){switch(t.readUnsignedByte()){case 1:f=[1,1];break;case 2:f=[12,11];break;case 3:f=[10,11];break;case 4:f=[16,11];break;case 5:f=[40,33];break;case 6:f=[24,11];break;case 7:f=[20,11];break;case 8:f=[32,11];break;case 9:f=[80,33];break;case 10:f=[18,11];break;case 11:f=[15,11];break;case 12:f=[64,33];break;case 13:f=[160,99];break;case 14:f=[4,3];break;case 15:f=[3,2];break;case 16:f=[2,1];break;case 255:f=[t.readUnsignedByte()<<8|t.readUnsignedByte(),t.readUnsignedByte()<<8|t.readUnsignedByte()]}f&&(v=f[0]/f[1])}return{profileIdc:i,levelIdc:n,profileCompatibility:r,width:Math.ceil((16*(d+1)-2*m-2*g)*v),height:(2-h)*(l+1)*16-2*y-2*_}}}).prototype=new sn;var lr,hr={H264Stream:ar,NalByteStream:sr},cr=[96e3,88200,64e3,48e3,44100,32e3,24e3,22050,16e3,12e3,11025,8e3,7350],fr=function(e){return e[0]<<21|e[1]<<14|e[2]<<7|e[3]},pr={isLikelyAacData:function(e){return e[0]==="I".charCodeAt(0)&&e[1]==="D".charCodeAt(0)&&e[2]==="3".charCodeAt(0)},parseId3TagSize:function(e,t){var i=e[t+6]<<21|e[t+7]<<14|e[t+8]<<7|e[t+9];return(16&e[t+5])>>4?i+20:i+10},parseAdtsSize:function(e,t){var i=(224&e[t+5])>>5,n=e[t+4]<<3;return 6144&e[t+3]|n|i},parseType:function(e,t){return e[t]==="I".charCodeAt(0)&&e[t+1]==="D".charCodeAt(0)&&e[t+2]==="3".charCodeAt(0)?"timed-metadata":!0&e[t]&&240==(240&e[t+1])?"audio":null},parseSampleRate:function(e){for(var t=0;t+5<e.length;){if(255===e[t]&&240==(246&e[t+1]))return cr[(60&e[t+2])>>>2];t++}return null},parseAacTimestamp:function(e){var t,i,n;t=10,64&e[5]&&(t+=4,t+=fr(e.subarray(10,14)));do{if((i=fr(e.subarray(t+4,t+8)))<1)return null;if("PRIV"===String.fromCharCode(e[t],e[t+1],e[t+2],e[t+3])){n=e.subarray(t+10,t+i+10);for(var r=0;r<n.byteLength;r++)if(0===n[r]){if("com.apple.streaming.transportStreamTimestamp"===unescape(function(e,t,i){var n,r="";for(n=t;n<i;n++)r+="%"+("00"+e[n].toString(16)).slice(-2);return r}(n,0,r))){var a=n.subarray(r+1),s=(1&a[3])<<30|a[4]<<22|a[5]<<14|a[6]<<6|a[7]>>>2;return s*=4,s+=3&a[7]}break}}t+=10,t+=i}while(t<e.byteLength);return null}};(lr=function(){var e=new Uint8Array,t=0;lr.prototype.init.call(this),this.setTimestamp=function(e){t=e},this.push=function(i){var n,r,a,s,o=0,u=0;for(e.length?(s=e.length,(e=new Uint8Array(i.byteLength+s)).set(e.subarray(0,s)),e.set(i,s)):e=i;e.length-u>=3;)if(e[u]!=="I".charCodeAt(0)||e[u+1]!=="D".charCodeAt(0)||e[u+2]!=="3".charCodeAt(0))if(255!=(255&e[u])||240!=(240&e[u+1]))u++;else{if(e.length-u<7)break;if(u+(o=pr.parseAdtsSize(e,u))>e.length)break;a={type:"audio",data:e.subarray(u,u+o),pts:t,dts:t},this.trigger("data",a),u+=o}else{if(e.length-u<10)break;if(u+(o=pr.parseId3TagSize(e,u))>e.length)break;r={type:"timed-metadata",data:e.subarray(u,u+o)},this.trigger("data",r),u+=o}n=e.length-u,e=n>0?e.subarray(u):new Uint8Array}}).prototype=new sn;var mr,gr,yr,_r,vr=lr,br=hr.H264Stream,Tr=pr.isLikelyAacData,Sr=["audioobjecttype","channelcount","samplerate","samplingfrequencyindex","samplesize"],kr=["width","height","profileIdc","levelIdc","profileCompatibility"],wr=function(e,t){var i;if(e.length!==t.length)return!1;for(i=0;i<e.length;i++)if(e[i]!==t[i])return!1;return!0},Ur=function(e,t,i,n,r,a){return{start:{dts:e,pts:e+(i-t)},end:{dts:e+(n-t),pts:e+(r-i)},prependedContentDuration:a,baseMediaDecodeTime:e}};(gr=function(e,t){var i=[],n=0,r=0,a=0,s=1/0;t=t||{},gr.prototype.init.call(this),this.push=function(t){Ln(e,t),e&&Sr.forEach(function(i){e[i]=t[i]}),i.push(t)},this.setEarliestDts=function(t){r=t-e.timelineStartInfo.baseMediaDecodeTime},this.setVideoBaseMediaDecodeTime=function(e){s=e},this.setAudioAppendStart=function(e){a=e},this.flush=function(){var o,u,d,l;0!==i.length?(o=Tn(i,e,r),e.baseMediaDecodeTime=Un(e,t.keepOriginalTimestamps),bn(e,o,a,s),e.samples=Sn(o),d=Zi.mdat(kn(o)),i=[],u=Zi.moof(n,[e]),l=new Uint8Array(u.byteLength+d.byteLength),n++,l.set(u),l.set(d,u.byteLength),wn(e),this.trigger("data",{track:e,boxes:l}),this.trigger("done","AudioSegmentStream")):this.trigger("done","AudioSegmentStream")}}).prototype=new sn,(mr=function(e,t){var i,n,r=0,a=[],s=[];t=t||{},mr.prototype.init.call(this),delete e.minPTS,this.gopCache_=[],this.push=function(t){Ln(e,t),"seq_parameter_set_rbsp"!==t.nalUnitType||i||(i=t.config,e.sps=[t.data],kr.forEach(function(t){e[t]=i[t]},this)),"pic_parameter_set_rbsp"!==t.nalUnitType||n||(n=t.data,e.pps=[t.data]),a.push(t)},this.flush=function(){for(var i,n,o,u,d,l,h,c,f=0;a.length&&"access_unit_delimiter_rbsp"!==a[0].nalUnitType;)a.shift();if(0===a.length)return this.resetStream_(),void this.trigger("done","VideoSegmentStream");if(i=un(a),(o=dn(i))[0][0].keyFrame||((n=this.getGopForFusion_(a[0],e))?(f=n.duration,o.unshift(n),o.byteLength+=n.byteLength,o.nalCount+=n.nalCount,o.pts=n.pts,o.dts=n.dts,o.duration+=n.duration):o=ln(o)),s.length){var p;if(!(p=t.alignGopsAtEnd?this.alignGopsAtEnd_(o):this.alignGopsAtStart_(o)))return this.gopCache_.unshift({gop:o.pop(),pps:e.pps,sps:e.sps}),this.gopCache_.length=Math.min(6,this.gopCache_.length),a=[],this.resetStream_(),void this.trigger("done","VideoSegmentStream");wn(e),o=p}Ln(e,o),e.samples=hn(o),d=Zi.mdat(cn(o)),e.baseMediaDecodeTime=Un(e,t.keepOriginalTimestamps),this.trigger("processedGopsInfo",o.map(function(e){return{pts:e.pts,dts:e.dts,byteLength:e.byteLength}})),h=o[0],c=o[o.length-1],this.trigger("segmentTimingInfo",Ur(e.baseMediaDecodeTime,h.dts,h.pts,c.dts+c.duration,c.pts+c.duration,f)),this.gopCache_.unshift({gop:o.pop(),pps:e.pps,sps:e.sps}),this.gopCache_.length=Math.min(6,this.gopCache_.length),a=[],this.trigger("baseMediaDecodeTime",e.baseMediaDecodeTime),this.trigger("timelineStartInfo",e.timelineStartInfo),u=Zi.moof(r,[e]),l=new Uint8Array(u.byteLength+d.byteLength),r++,l.set(u),l.set(d,u.byteLength),this.trigger("data",{track:e,boxes:l}),this.resetStream_(),this.trigger("done","VideoSegmentStream")},this.resetStream_=function(){wn(e),i=void 0,n=void 0},this.getGopForFusion_=function(t){var i,n,r,a,s,o=1/0;for(s=0;s<this.gopCache_.length;s++)r=(a=this.gopCache_[s]).gop,e.pps&&wr(e.pps[0],a.pps[0])&&e.sps&&wr(e.sps[0],a.sps[0])&&(r.dts<e.timelineStartInfo.dts||(i=t.dts-r.dts-r.duration)>=-1e4&&i<=45e3&&(!n||o>i)&&(n=a,o=i));return n?n.gop:null},this.alignGopsAtStart_=function(e){var t,i,n,r,a,o,u,d;for(a=e.byteLength,o=e.nalCount,u=e.duration,t=i=0;t<s.length&&i<e.length&&(n=s[t],r=e[i],n.pts!==r.pts);)r.pts>n.pts?t++:(i++,a-=r.byteLength,o-=r.nalCount,u-=r.duration);return 0===i?e:i===e.length?null:((d=e.slice(i)).byteLength=a,d.duration=u,d.nalCount=o,d.pts=d[0].pts,d.dts=d[0].dts,d)},this.alignGopsAtEnd_=function(e){var t,i,n,r,a,o,u;for(t=s.length-1,i=e.length-1,a=null,o=!1;t>=0&&i>=0;){if(n=s[t],r=e[i],n.pts===r.pts){o=!0;break}n.pts>r.pts?t--:(t===s.length-1&&(a=i),i--)}if(!o&&null===a)return null;if(0===(u=o?i:a))return e;var d=e.slice(u),l=d.reduce(function(e,t){return e.byteLength+=t.byteLength,e.duration+=t.duration,e.nalCount+=t.nalCount,e},{byteLength:0,duration:0,nalCount:0});return d.byteLength=l.byteLength,d.duration=l.duration,d.nalCount=l.nalCount,d.pts=d[0].pts,d.dts=d[0].dts,d},this.alignGopsWith=function(e){s=e}}).prototype=new sn,(_r=function(e,t){this.numberOfTracks=0,this.metadataStream=t,void 0!==(e=e||{}).remux?this.remuxTracks=!!e.remux:this.remuxTracks=!0,"boolean"==typeof e.keepOriginalTimestamps&&(this.keepOriginalTimestamps=e.keepOriginalTimestamps),this.pendingTracks=[],this.videoTrack=null,this.pendingBoxes=[],this.pendingCaptions=[],this.pendingMetadata=[],this.pendingBytes=0,this.emittedTracks=0,_r.prototype.init.call(this),this.push=function(e){return e.text?this.pendingCaptions.push(e):e.frames?this.pendingMetadata.push(e):(this.pendingTracks.push(e.track),this.pendingBoxes.push(e.boxes),this.pendingBytes+=e.boxes.byteLength,"video"===e.track.type&&(this.videoTrack=e.track),void("audio"===e.track.type&&(this.audioTrack=e.track)))}}).prototype=new sn,_r.prototype.flush=function(e){var t,i,n,r,a=0,s={captions:[],captionStreams:{},metadata:[],info:{}},o=0;if(this.pendingTracks.length<this.numberOfTracks){if("VideoSegmentStream"!==e&&"AudioSegmentStream"!==e)return;if(this.remuxTracks)return;if(0===this.pendingTracks.length)return this.emittedTracks++,void(this.emittedTracks>=this.numberOfTracks&&(this.trigger("done"),this.emittedTracks=0))}for(this.videoTrack?(o=this.videoTrack.timelineStartInfo.pts,kr.forEach(function(e){s.info[e]=this.videoTrack[e]},this)):this.audioTrack&&(o=this.audioTrack.timelineStartInfo.pts,Sr.forEach(function(e){s.info[e]=this.audioTrack[e]},this)),1===this.pendingTracks.length?s.type=this.pendingTracks[0].type:s.type="combined",this.emittedTracks+=this.pendingTracks.length,n=Zi.initSegment(this.pendingTracks),s.initSegment=new Uint8Array(n.byteLength),s.initSegment.set(n),s.data=new Uint8Array(this.pendingBytes),r=0;r<this.pendingBoxes.length;r++)s.data.set(this.pendingBoxes[r],a),a+=this.pendingBoxes[r].byteLength;for(r=0;r<this.pendingCaptions.length;r++)(t=this.pendingCaptions[r]).startTime=t.startPts,this.keepOriginalTimestamps||(t.startTime-=o),t.startTime/=9e4,t.endTime=t.endPts,this.keepOriginalTimestamps||(t.endTime-=o),t.endTime/=9e4,s.captionStreams[t.stream]=!0,s.captions.push(t);for(r=0;r<this.pendingMetadata.length;r++)(i=this.pendingMetadata[r]).cueTime=i.pts,this.keepOriginalTimestamps||(i.cueTime-=o),i.cueTime/=9e4,s.metadata.push(i);s.metadata.dispatchType=this.metadataStream.dispatchType,this.pendingTracks.length=0,this.videoTrack=null,this.pendingBoxes.length=0,this.pendingCaptions.length=0,this.pendingBytes=0,this.pendingMetadata.length=0,this.trigger("data",s),this.emittedTracks>=this.numberOfTracks&&(this.trigger("done"),this.emittedTracks=0)},(yr=function(e){var t,i,n=this,r=!0;yr.prototype.init.call(this),e=e||{},this.baseMediaDecodeTime=e.baseMediaDecodeTime||0,this.transmuxPipeline_={},this.setupAacPipeline=function(){var t={};this.transmuxPipeline_=t,t.type="aac",t.metadataStream=new nr.MetadataStream,t.aacStream=new vr,t.audioTimestampRolloverStream=new nr.TimestampRolloverStream("audio"),t.timedMetadataTimestampRolloverStream=new nr.TimestampRolloverStream("timed-metadata"),t.adtsStream=new ur,t.coalesceStream=new _r(e,t.metadataStream),t.headOfPipeline=t.aacStream,t.aacStream.pipe(t.audioTimestampRolloverStream).pipe(t.adtsStream),t.aacStream.pipe(t.timedMetadataTimestampRolloverStream).pipe(t.metadataStream).pipe(t.coalesceStream),t.metadataStream.on("timestamp",function(e){t.aacStream.setTimestamp(e.timeStamp)}),t.aacStream.on("data",function(r){"timed-metadata"!==r.type||t.audioSegmentStream||(i=i||{timelineStartInfo:{baseMediaDecodeTime:n.baseMediaDecodeTime},codec:"adts",type:"audio"},t.coalesceStream.numberOfTracks++,t.audioSegmentStream=new gr(i,e),t.adtsStream.pipe(t.audioSegmentStream).pipe(t.coalesceStream))}),t.coalesceStream.on("data",this.trigger.bind(this,"data")),t.coalesceStream.on("done",this.trigger.bind(this,"done"))},this.setupTsPipeline=function(){var r={};this.transmuxPipeline_=r,r.type="ts",r.metadataStream=new nr.MetadataStream,r.packetStream=new nr.TransportPacketStream,r.parseStream=new nr.TransportParseStream,r.elementaryStream=new nr.ElementaryStream,r.videoTimestampRolloverStream=new nr.TimestampRolloverStream("video"),r.audioTimestampRolloverStream=new nr.TimestampRolloverStream("audio"),r.timedMetadataTimestampRolloverStream=new nr.TimestampRolloverStream("timed-metadata"),r.adtsStream=new ur,r.h264Stream=new br,r.captionStream=new nr.CaptionStream,r.coalesceStream=new _r(e,r.metadataStream),r.headOfPipeline=r.packetStream,r.packetStream.pipe(r.parseStream).pipe(r.elementaryStream),r.elementaryStream.pipe(r.videoTimestampRolloverStream).pipe(r.h264Stream),r.elementaryStream.pipe(r.audioTimestampRolloverStream).pipe(r.adtsStream),r.elementaryStream.pipe(r.timedMetadataTimestampRolloverStream).pipe(r.metadataStream).pipe(r.coalesceStream),r.h264Stream.pipe(r.captionStream).pipe(r.coalesceStream),r.elementaryStream.on("data",function(a){var s;if("metadata"===a.type){for(s=a.tracks.length;s--;)t||"video"!==a.tracks[s].type?i||"audio"!==a.tracks[s].type||((i=a.tracks[s]).timelineStartInfo.baseMediaDecodeTime=n.baseMediaDecodeTime):(t=a.tracks[s]).timelineStartInfo.baseMediaDecodeTime=n.baseMediaDecodeTime;t&&!r.videoSegmentStream&&(r.coalesceStream.numberOfTracks++,r.videoSegmentStream=new mr(t,e),r.videoSegmentStream.on("timelineStartInfo",function(e){i&&(i.timelineStartInfo=e,r.audioSegmentStream.setEarliestDts(e.dts))}),r.videoSegmentStream.on("processedGopsInfo",n.trigger.bind(n,"gopInfo")),r.videoSegmentStream.on("segmentTimingInfo",n.trigger.bind(n,"videoSegmentTimingInfo")),r.videoSegmentStream.on("baseMediaDecodeTime",function(e){i&&r.audioSegmentStream.setVideoBaseMediaDecodeTime(e)}),r.h264Stream.pipe(r.videoSegmentStream).pipe(r.coalesceStream)),i&&!r.audioSegmentStream&&(r.coalesceStream.numberOfTracks++,r.audioSegmentStream=new gr(i,e),r.adtsStream.pipe(r.audioSegmentStream).pipe(r.coalesceStream))}}),r.coalesceStream.on("data",this.trigger.bind(this,"data")),r.coalesceStream.on("done",this.trigger.bind(this,"done"))},this.setBaseMediaDecodeTime=function(n){var r=this.transmuxPipeline_;e.keepOriginalTimestamps||(this.baseMediaDecodeTime=n),i&&(i.timelineStartInfo.dts=void 0,i.timelineStartInfo.pts=void 0,wn(i),e.keepOriginalTimestamps||(i.timelineStartInfo.baseMediaDecodeTime=n),r.audioTimestampRolloverStream&&r.audioTimestampRolloverStream.discontinuity()),t&&(r.videoSegmentStream&&(r.videoSegmentStream.gopCache_=[],r.videoTimestampRolloverStream.discontinuity()),t.timelineStartInfo.dts=void 0,t.timelineStartInfo.pts=void 0,wn(t),r.captionStream.reset(),e.keepOriginalTimestamps||(t.timelineStartInfo.baseMediaDecodeTime=n)),r.timedMetadataTimestampRolloverStream&&r.timedMetadataTimestampRolloverStream.discontinuity()},this.setAudioAppendStart=function(e){i&&this.transmuxPipeline_.audioSegmentStream.setAudioAppendStart(e)},this.alignGopsWith=function(e){t&&this.transmuxPipeline_.videoSegmentStream&&this.transmuxPipeline_.videoSegmentStream.alignGopsWith(e)},this.push=function(e){if(r){var t=Tr(e);t&&"aac"!==this.transmuxPipeline_.type?this.setupAacPipeline():t||"ts"===this.transmuxPipeline_.type||this.setupTsPipeline(),r=!1}this.transmuxPipeline_.headOfPipeline.push(e)},this.flush=function(){r=!0,this.transmuxPipeline_.headOfPipeline.flush()},this.resetCaptions=function(){this.transmuxPipeline_.captionStream&&this.transmuxPipeline_.captionStream.reset()}}).prototype=new sn;var Lr,Ar,Er={Transmuxer:yr,VideoSegmentStream:mr,AudioSegmentStream:gr,AUDIO_PROPERTIES:Sr,VIDEO_PROPERTIES:kr,generateVideoSegmentTimingInfo:Ur},Or=Ni.parseType,Ir=function(e){return new Date(1e3*e-20828448e5)},Cr=function(e){return{isLeading:(12&e[0])>>>2,dependsOn:3&e[0],isDependedOn:(192&e[1])>>>6,hasRedundancy:(48&e[1])>>>4,paddingValue:(14&e[1])>>>1,isNonSyncSample:1&e[1],degradationPriority:e[2]<<8|e[3]}},Pr={avc1:function(e){var t=new DataView(e.buffer,e.byteOffset,e.byteLength);return{dataReferenceIndex:t.getUint16(6),width:t.getUint16(24),height:t.getUint16(26),horizresolution:t.getUint16(28)+t.getUint16(30)/16,vertresolution:t.getUint16(32)+t.getUint16(34)/16,frameCount:t.getUint16(40),depth:t.getUint16(74),config:Lr(e.subarray(78,e.byteLength))}},avcC:function(e){var t,i,n,r,a=new DataView(e.buffer,e.byteOffset,e.byteLength),s={configurationVersion:e[0],avcProfileIndication:e[1],profileCompatibility:e[2],avcLevelIndication:e[3],lengthSizeMinusOne:3&e[4],sps:[],pps:[]},o=31&e[5];for(n=6,r=0;r<o;r++)i=a.getUint16(n),n+=2,s.sps.push(new Uint8Array(e.subarray(n,n+i))),n+=i;for(t=e[n],n++,r=0;r<t;r++)i=a.getUint16(n),n+=2,s.pps.push(new Uint8Array(e.subarray(n,n+i))),n+=i;return s},btrt:function(e){var t=new DataView(e.buffer,e.byteOffset,e.byteLength);return{bufferSizeDB:t.getUint32(0),maxBitrate:t.getUint32(4),avgBitrate:t.getUint32(8)}},esds:function(e){return{version:e[0],flags:new Uint8Array(e.subarray(1,4)),esId:e[6]<<8|e[7],streamPriority:31&e[8],decoderConfig:{objectProfileIndication:e[11],streamType:e[12]>>>2&63,bufferSize:e[13]<<16|e[14]<<8|e[15],maxBitrate:e[16]<<24|e[17]<<16|e[18]<<8|e[19],avgBitrate:e[20]<<24|e[21]<<16|e[22]<<8|e[23],decoderConfigDescriptor:{tag:e[24],length:e[25],audioObjectType:e[26]>>>3&31,samplingFrequencyIndex:(7&e[26])<<1|e[27]>>>7&1,channelConfiguration:e[27]>>>3&15}}}},ftyp:function(e){for(var t=new DataView(e.buffer,e.byteOffset,e.byteLength),i={majorBrand:Or(e.subarray(0,4)),minorVersion:t.getUint32(4),compatibleBrands:[]},n=8;n<e.byteLength;)i.compatibleBrands.push(Or(e.subarray(n,n+4))),n+=4;return i},dinf:function(e){return{boxes:Lr(e)}},dref:function(e){return{version:e[0],flags:new Uint8Array(e.subarray(1,4)),dataReferences:Lr(e.subarray(8))}},hdlr:function(e){var t={version:new DataView(e.buffer,e.byteOffset,e.byteLength).getUint8(0),flags:new Uint8Array(e.subarray(1,4)),handlerType:Or(e.subarray(8,12)),name:""},i=8;for(i=24;i<e.byteLength;i++){if(0===e[i]){i++;break}t.name+=String.fromCharCode(e[i])}return t.name=decodeURIComponent(escape(t.name)),t},mdat:function(e){return{byteLength:e.byteLength,nals:function(e){var t,i,n=new DataView(e.buffer,e.byteOffset,e.byteLength),r=[];for(t=0;t+4<e.length;t+=i)if(i=n.getUint32(t),t+=4,i<=0)r.push("<span style='color:red;'>MALFORMED DATA</span>");else switch(31&e[t]){case 1:r.push("slice_layer_without_partitioning_rbsp");break;case 5:r.push("slice_layer_without_partitioning_rbsp_idr");break;case 6:r.push("sei_rbsp");break;case 7:r.push("seq_parameter_set_rbsp");break;case 8:r.push("pic_parameter_set_rbsp");break;case 9:r.push("access_unit_delimiter_rbsp");break;default:r.push("UNKNOWN NAL - "+e[t]&31)}return r}(e)}},mdhd:function(e){var t,i=new DataView(e.buffer,e.byteOffset,e.byteLength),n=4,r={version:i.getUint8(0),flags:new Uint8Array(e.subarray(1,4)),language:""};return 1===r.version?(n+=4,r.creationTime=Ir(i.getUint32(n)),n+=8,r.modificationTime=Ir(i.getUint32(n)),n+=4,r.timescale=i.getUint32(n),n+=8,r.duration=i.getUint32(n)):(r.creationTime=Ir(i.getUint32(n)),n+=4,r.modificationTime=Ir(i.getUint32(n)),n+=4,r.timescale=i.getUint32(n),n+=4,r.duration=i.getUint32(n)),n+=4,t=i.getUint16(n),r.language+=String.fromCharCode(96+(t>>10)),r.language+=String.fromCharCode(96+((992&t)>>5)),r.language+=String.fromCharCode(96+(31&t)),r},mdia:function(e){return{boxes:Lr(e)}},mfhd:function(e){return{version:e[0],flags:new Uint8Array(e.subarray(1,4)),sequenceNumber:e[4]<<24|e[5]<<16|e[6]<<8|e[7]}},minf:function(e){return{boxes:Lr(e)}},mp4a:function(e){var t=new DataView(e.buffer,e.byteOffset,e.byteLength),i={dataReferenceIndex:t.getUint16(6),channelcount:t.getUint16(16),samplesize:t.getUint16(18),samplerate:t.getUint16(24)+t.getUint16(26)/65536};return e.byteLength>28&&(i.streamDescriptor=Lr(e.subarray(28))[0]),i},moof:function(e){return{boxes:Lr(e)}},moov:function(e){return{boxes:Lr(e)}},mvex:function(e){return{boxes:Lr(e)}},mvhd:function(e){var t=new DataView(e.buffer,e.byteOffset,e.byteLength),i=4,n={version:t.getUint8(0),flags:new Uint8Array(e.subarray(1,4))};return 1===n.version?(i+=4,n.creationTime=Ir(t.getUint32(i)),i+=8,n.modificationTime=Ir(t.getUint32(i)),i+=4,n.timescale=t.getUint32(i),i+=8,n.duration=t.getUint32(i)):(n.creationTime=Ir(t.getUint32(i)),i+=4,n.modificationTime=Ir(t.getUint32(i)),i+=4,n.timescale=t.getUint32(i),i+=4,n.duration=t.getUint32(i)),i+=4,n.rate=t.getUint16(i)+t.getUint16(i+2)/16,i+=4,n.volume=t.getUint8(i)+t.getUint8(i+1)/8,i+=2,i+=2,i+=8,n.matrix=new Uint32Array(e.subarray(i,i+36)),i+=36,i+=24,n.nextTrackId=t.getUint32(i),n},pdin:function(e){var t=new DataView(e.buffer,e.byteOffset,e.byteLength);return{version:t.getUint8(0),flags:new Uint8Array(e.subarray(1,4)),rate:t.getUint32(4),initialDelay:t.getUint32(8)}},sdtp:function(e){var t,i={version:e[0],flags:new Uint8Array(e.subarray(1,4)),samples:[]};for(t=4;t<e.byteLength;t++)i.samples.push({dependsOn:(48&e[t])>>4,isDependedOn:(12&e[t])>>2,hasRedundancy:3&e[t]});return i},sidx:function(e){var t,i=new DataView(e.buffer,e.byteOffset,e.byteLength),n={version:e[0],flags:new Uint8Array(e.subarray(1,4)),references:[],referenceId:i.getUint32(4),timescale:i.getUint32(8),earliestPresentationTime:i.getUint32(12),firstOffset:i.getUint32(16)},r=i.getUint16(22);for(t=24;r;t+=12,r--)n.references.push({referenceType:(128&e[t])>>>7,referencedSize:2147483647&i.getUint32(t),subsegmentDuration:i.getUint32(t+4),startsWithSap:!!(128&e[t+8]),sapType:(112&e[t+8])>>>4,sapDeltaTime:268435455&i.getUint32(t+8)});return n},smhd:function(e){return{version:e[0],flags:new Uint8Array(e.subarray(1,4)),balance:e[4]+e[5]/256}},stbl:function(e){return{boxes:Lr(e)}},stco:function(e){var t,i=new DataView(e.buffer,e.byteOffset,e.byteLength),n={version:e[0],flags:new Uint8Array(e.subarray(1,4)),chunkOffsets:[]},r=i.getUint32(4);for(t=8;r;t+=4,r--)n.chunkOffsets.push(i.getUint32(t));return n},stsc:function(e){var t,i=new DataView(e.buffer,e.byteOffset,e.byteLength),n=i.getUint32(4),r={version:e[0],flags:new Uint8Array(e.subarray(1,4)),sampleToChunks:[]};for(t=8;n;t+=12,n--)r.sampleToChunks.push({firstChunk:i.getUint32(t),samplesPerChunk:i.getUint32(t+4),sampleDescriptionIndex:i.getUint32(t+8)});return r},stsd:function(e){return{version:e[0],flags:new Uint8Array(e.subarray(1,4)),sampleDescriptions:Lr(e.subarray(8))}},stsz:function(e){var t,i=new DataView(e.buffer,e.byteOffset,e.byteLength),n={version:e[0],flags:new Uint8Array(e.subarray(1,4)),sampleSize:i.getUint32(4),entries:[]};for(t=12;t<e.byteLength;t+=4)n.entries.push(i.getUint32(t));return n},stts:function(e){var t,i=new DataView(e.buffer,e.byteOffset,e.byteLength),n={version:e[0],flags:new Uint8Array(e.subarray(1,4)),timeToSamples:[]},r=i.getUint32(4);for(t=8;r;t+=8,r--)n.timeToSamples.push({sampleCount:i.getUint32(t),sampleDelta:i.getUint32(t+4)});return n},styp:function(e){return Pr.ftyp(e)},tfdt:function(e){var t={version:e[0],flags:new Uint8Array(e.subarray(1,4)),baseMediaDecodeTime:e[4]<<24|e[5]<<16|e[6]<<8|e[7]};return 1===t.version&&(t.baseMediaDecodeTime*=Math.pow(2,32),t.baseMediaDecodeTime+=e[8]<<24|e[9]<<16|e[10]<<8|e[11]),t},tfhd:function(e){var t,i=new DataView(e.buffer,e.byteOffset,e.byteLength),n={version:e[0],flags:new Uint8Array(e.subarray(1,4)),trackId:i.getUint32(4)},r=1&n.flags[2],a=2&n.flags[2],s=8&n.flags[2],o=16&n.flags[2],u=32&n.flags[2],d=65536&n.flags[0],l=131072&n.flags[0];return t=8,r&&(t+=4,n.baseDataOffset=i.getUint32(12),t+=4),a&&(n.sampleDescriptionIndex=i.getUint32(t),t+=4),s&&(n.defaultSampleDuration=i.getUint32(t),t+=4),o&&(n.defaultSampleSize=i.getUint32(t),t+=4),u&&(n.defaultSampleFlags=i.getUint32(t)),d&&(n.durationIsEmpty=!0),!r&&l&&(n.baseDataOffsetIsMoof=!0),n},tkhd:function(e){var t=new DataView(e.buffer,e.byteOffset,e.byteLength),i=4,n={version:t.getUint8(0),flags:new Uint8Array(e.subarray(1,4))};return 1===n.version?(i+=4,n.creationTime=Ir(t.getUint32(i)),i+=8,n.modificationTime=Ir(t.getUint32(i)),i+=4,n.trackId=t.getUint32(i),i+=4,i+=8,n.duration=t.getUint32(i)):(n.creationTime=Ir(t.getUint32(i)),i+=4,n.modificationTime=Ir(t.getUint32(i)),i+=4,n.trackId=t.getUint32(i),i+=4,i+=4,n.duration=t.getUint32(i)),i+=4,i+=8,n.layer=t.getUint16(i),i+=2,n.alternateGroup=t.getUint16(i),i+=2,n.volume=t.getUint8(i)+t.getUint8(i+1)/8,i+=2,i+=2,n.matrix=new Uint32Array(e.subarray(i,i+36)),i+=36,n.width=t.getUint16(i)+t.getUint16(i+2)/16,i+=4,n.height=t.getUint16(i)+t.getUint16(i+2)/16,n},traf:function(e){return{boxes:Lr(e)}},trak:function(e){return{boxes:Lr(e)}},trex:function(e){var t=new DataView(e.buffer,e.byteOffset,e.byteLength);return{version:e[0],flags:new Uint8Array(e.subarray(1,4)),trackId:t.getUint32(4),defaultSampleDescriptionIndex:t.getUint32(8),defaultSampleDuration:t.getUint32(12),defaultSampleSize:t.getUint32(16),sampleDependsOn:3&e[20],sampleIsDependedOn:(192&e[21])>>6,sampleHasRedundancy:(48&e[21])>>4,samplePaddingValue:(14&e[21])>>1,sampleIsDifferenceSample:!!(1&e[21]),sampleDegradationPriority:t.getUint16(22)}},trun:function(e){var t,i={version:e[0],flags:new Uint8Array(e.subarray(1,4)),samples:[]},n=new DataView(e.buffer,e.byteOffset,e.byteLength),r=1&i.flags[2],a=4&i.flags[2],s=1&i.flags[1],o=2&i.flags[1],u=4&i.flags[1],d=8&i.flags[1],l=n.getUint32(4),h=8;for(r&&(i.dataOffset=n.getInt32(h),h+=4),a&&l&&(t={flags:Cr(e.subarray(h,h+4))},h+=4,s&&(t.duration=n.getUint32(h),h+=4),o&&(t.size=n.getUint32(h),h+=4),d&&(t.compositionTimeOffset=n.getUint32(h),h+=4),i.samples.push(t),l--);l--;)t={},s&&(t.duration=n.getUint32(h),h+=4),o&&(t.size=n.getUint32(h),h+=4),u&&(t.flags=Cr(e.subarray(h,h+4)),h+=4),d&&(t.compositionTimeOffset=n.getUint32(h),h+=4),i.samples.push(t);return i},"url ":function(e){return{version:e[0],flags:new Uint8Array(e.subarray(1,4))}},vmhd:function(e){var t=new DataView(e.buffer,e.byteOffset,e.byteLength);return{version:e[0],flags:new Uint8Array(e.subarray(1,4)),graphicsmode:t.getUint16(4),opcolor:new Uint16Array([t.getUint16(6),t.getUint16(8),t.getUint16(10)])}}},Dr={inspect:Lr=function(e){for(var t,i,n,r,a,s=0,o=[],u=new ArrayBuffer(e.length),d=new Uint8Array(u),l=0;l<e.length;++l)d[l]=e[l];for(t=new DataView(u);s<e.byteLength;)i=t.getUint32(s),n=Or(e.subarray(s+4,s+8)),r=i>1?s+i:e.byteLength,(a=(Pr[n]||function(e){return{data:e}})(e.subarray(s+8,r))).size=i,a.type=n,o.push(a),s=r;return o},textify:Ar=function(e,t){var i;return t=t||0,i=new Array(2*t+1).join(" "),e.map(function(e,n){return i+e.type+"\n"+Object.keys(e).filter(function(e){return"type"!==e&&"boxes"!==e}).map(function(t){var n=i+"  "+t+": ",r=e[t];if(r instanceof Uint8Array||r instanceof Uint32Array){var a=Array.prototype.slice.call(new Uint8Array(r.buffer,r.byteOffset,r.byteLength)).map(function(e){return" "+("00"+e.toString(16)).slice(-2)}).join("").match(/.{1,24}/g);return a?1===a.length?n+"<"+a.join("").slice(1)+">":n+"<\n"+a.map(function(e){return i+"  "+e}).join("\n")+"\n"+i+"  >":n+"<>"}return n+JSON.stringify(r,null,2).split("\n").map(function(e,t){return 0===t?e:i+"  "+e}).join("\n")}).join("\n")+(e.boxes?"\n"+Ar(e.boxes,t+1):"")}).join("\n")},parseTfdt:Pr.tfdt,parseHdlr:Pr.hdlr,parseTfhd:Pr.tfhd,parseTrun:Pr.trun,parseSidx:Pr.sidx},Rr=In,xr=Nn.CaptionStream,Mr=function(e,t){for(var i=e,n=0;n<t.length;n++){var r=t[n];if(i<r.size)return r;i-=r.size}return null},Br=function(e,t){var i=Ni.findBox(e,["moof","traf"]),n={},r=[];return Ni.findBox(e,["mdat"]).forEach(function(e,t){var n=i[t];r.push({mdat:e,traf:n})}),r.forEach(function(e){var i,r=e.mdat,a=e.traf,s=Ni.findBox(a,["tfhd"]),o=Dr.parseTfhd(s[0]),u=o.trackId,d=Ni.findBox(a,["tfdt"]),l=d.length>0?Dr.parseTfdt(d[0]).baseMediaDecodeTime:0,h=Ni.findBox(a,["trun"]);t===u&&h.length>0&&(i=function(e,t,i){var n,r,a,s,o=new DataView(e.buffer,e.byteOffset,e.byteLength),u=[];for(r=0;r+4<e.length;r+=a)if(a=o.getUint32(r),r+=4,!(a<=0))switch(31&e[r]){case 6:var d=e.subarray(r+1,r+1+a),l=Mr(r,t);n={nalUnitType:"sei_rbsp",size:a,data:d,escapedRBSP:Rr(d),trackId:i},l?(n.pts=l.pts,n.dts=l.dts,s=l):(n.pts=s.pts,n.dts=s.dts),u.push(n)}return u}(r,function(e,t,i){var n=t,r=i.defaultSampleDuration||0,a=i.defaultSampleSize||0,s=i.trackId,o=[];return e.forEach(function(e){var t=Dr.parseTrun(e).samples;t.forEach(function(e){void 0===e.duration&&(e.duration=r),void 0===e.size&&(e.size=a),e.trackId=s,e.dts=n,void 0===e.compositionTimeOffset&&(e.compositionTimeOffset=0),e.pts=n+e.compositionTimeOffset,n+=e.duration}),o=o.concat(t)}),o}(h,l,o),u),n[u]||(n[u]=[]),n[u]=n[u].concat(i))}),n},Nr={generator:Zi,probe:Ni,Transmuxer:Er.Transmuxer,AudioSegmentStream:Er.AudioSegmentStream,VideoSegmentStream:Er.VideoSegmentStream,CaptionParser:function(){var e,t,i,n,r,a=!1;this.isInitialized=function(){return a},this.init=function(){e=new xr,a=!0,e.on("data",function(e){e.startTime=e.startPts/n,e.endTime=e.endPts/n,r.captions.push(e),r.captionStreams[e.stream]=!0})},this.isNewInit=function(e,t){return!(e&&0===e.length||t&&"object"==typeof t&&0===Object.keys(t).length||i===e[0]&&n===t[i])},this.parse=function(e,a,s){var o;if(!this.isInitialized())return null;if(!a||!s)return null;if(this.isNewInit(a,s))i=a[0],n=s[i];else if(!i||!n)return t.push(e),null;for(;t.length>0;){var u=t.shift();this.parse(u,a,s)}return null!==(o=function(e,t,i){return t?{seiNals:Br(e,t)[t],timescale:i}:null}(e,i,n))&&o.seiNals?(this.pushNals(o.seiNals),this.flushStream(),r):null},this.pushNals=function(t){if(!this.isInitialized()||!t||0===t.length)return null;t.forEach(function(t){e.push(t)})},this.flushStream=function(){if(!this.isInitialized())return null;e.flush()},this.clearParsedCaptions=function(){r.captions=[],r.captionStreams={}},this.resetCaptionStream=function(){if(!this.isInitialized())return null;e.reset()},this.clearAllCaptions=function(){this.clearParsedCaptions(),this.resetCaptionStream()},this.reset=function(){t=[],i=null,n=null,r?this.clearParsedCaptions():r={captions:[],captionStreams:{}},this.resetCaptionStream()},this.reset()}}.CaptionParser,qr=function(e){return"number"==typeof e&&isFinite(e)},Fr=function(e){function i(e){S(this,i);var t=U(this,(i.__proto__||Object.getPrototypeOf(i)).call(this));if(!e)throw new TypeError("Initialization settings are required");if("function"!=typeof e.currentTime)throw new TypeError("No currentTime getter specified");if(!e.mediaSource)throw new TypeError("No MediaSource specified");return t.bandwidth=e.bandwidth,t.throughput={rate:0,count:0},t.roundTrip=NaN,t.resetStats_(),t.mediaIndex=null,t.hasPlayed_=e.hasPlayed,t.currentTime_=e.currentTime,t.seekable_=e.seekable,t.seeking_=e.seeking,t.duration_=e.duration,t.mediaSource_=e.mediaSource,t.hls_=e.hls,t.loaderType_=e.loaderType,t.startingMedia_=void 0,t.segmentMetadataTrack_=e.segmentMetadataTrack,t.goalBufferLength_=e.goalBufferLength,t.sourceType_=e.sourceType,t.inbandTextTracks_=e.inbandTextTracks,t.state_="INIT",t.checkBufferTimeout_=null,t.error_=void 0,t.currentTimeline_=-1,t.pendingSegment_=null,t.mimeType_=null,t.sourceUpdater_=null,t.xhrOptions_=null,t.activeInitSegmentId_=null,t.initSegments_={},t.captionParser_=new Nr,t.decrypter_=e.decrypter,t.syncController_=e.syncController,t.syncPoint_={segmentIndex:0,time:0},t.syncController_.on("syncinfoupdate",function(){return t.trigger("syncinfoupdate")}),t.mediaSource_.addEventListener("sourceopen",function(){return t.ended_=!1}),t.fetchAtBuffer_=!1,t.logger_=zt("SegmentLoader["+t.loaderType_+"]"),Object.defineProperty(t,"state",{get:function(){return this.state_},set:function(e){e!==this.state_&&(this.logger_(this.state_+" -> "+e),this.state_=e)}}),t}return w(i,e),k(i,[{key:"resetStats_",value:function(){this.mediaBytesTransferred=0,this.mediaRequests=0,this.mediaRequestsAborted=0,this.mediaRequestsTimedout=0,this.mediaRequestsErrored=0,this.mediaTransferDuration=0,this.mediaSecondsLoaded=0}},{key:"dispose",value:function(){this.state="DISPOSED",this.pause(),this.abort_(),this.sourceUpdater_&&this.sourceUpdater_.dispose(),this.resetStats_(),this.captionParser_.reset()}},{key:"abort",value:function(){"WAITING"===this.state?(this.abort_(),this.state="READY",this.paused()||this.monitorBuffer_()):this.pendingSegment_&&(this.pendingSegment_=null)}},{key:"abort_",value:function(){this.pendingSegment_&&this.pendingSegment_.abortRequests(),this.pendingSegment_=null}},{key:"error",value:function(e){return void 0!==e&&(this.error_=e),this.pendingSegment_=null,this.error_}},{key:"endOfStream",value:function(){this.ended_=!0,this.pause(),this.trigger("ended")}},{key:"buffered_",value:function(){return this.sourceUpdater_?this.sourceUpdater_.buffered():t.createTimeRanges()}},{key:"initSegment",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]&&arguments[1];if(!e)return null;var i=ge(e),n=this.initSegments_[i];return t&&!n&&e.bytes&&(this.initSegments_[i]=n={resolvedUri:e.resolvedUri,byterange:e.byterange,bytes:e.bytes,timescales:e.timescales,videoTrackIds:e.videoTrackIds}),n||e}},{key:"couldBeginLoading_",value:function(){return this.playlist_&&(this.sourceUpdater_||this.mimeType_&&"INIT"===this.state)&&!this.paused()}},{key:"load",value:function(){if(this.monitorBuffer_(),this.playlist_){if(this.syncController_.setDateTimeMapping(this.playlist_),"INIT"===this.state&&this.couldBeginLoading_())return this.init_();!this.couldBeginLoading_()||"READY"!==this.state&&"INIT"!==this.state||(this.state="READY")}}},{key:"init_",value:function(){return this.state="READY",this.sourceUpdater_=new xi(this.mediaSource_,this.mimeType_,this.loaderType_,this.sourceBufferEmitter_),this.resetEverything(),this.monitorBuffer_()}},{key:"playlist",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(e){var i=this.playlist_,n=this.pendingSegment_;this.playlist_=e,this.xhrOptions_=t,this.hasPlayed_()||(e.syncInfo={mediaSequence:e.mediaSequence,time:0});var r=null;if(i&&(i.id?r=i.id:i.uri&&(r=i.uri)),this.logger_("playlist update ["+r+" => "+(e.id||e.uri)+"]"),this.trigger("syncinfoupdate"),"INIT"===this.state&&this.couldBeginLoading_())return this.init_();if(i&&i.uri===e.uri){var a=e.mediaSequence-i.mediaSequence;this.logger_("live window shift ["+a+"]"),null!==this.mediaIndex&&(this.mediaIndex-=a),n&&(n.mediaIndex-=a,n.mediaIndex>=0&&(n.segment=e.segments[n.mediaIndex])),this.syncController_.saveExpiredSegmentInfo(i,e)}else null!==this.mediaIndex&&this.resyncLoader()}}},{key:"pause",value:function(){this.checkBufferTimeout_&&(h.clearTimeout(this.checkBufferTimeout_),this.checkBufferTimeout_=null)}},{key:"paused",value:function(){return null===this.checkBufferTimeout_}},{key:"mimeType",value:function(e,t){this.mimeType_||(this.mimeType_=e,this.sourceBufferEmitter_=t,"INIT"===this.state&&this.couldBeginLoading_()&&this.init_())}},{key:"resetEverything",value:function(e){this.ended_=!1,this.resetLoader(),this.remove(0,this.duration_(),e),this.captionParser_.clearAllCaptions(),this.trigger("reseteverything")}},{key:"resetLoader",value:function(){this.fetchAtBuffer_=!1,this.resyncLoader()}},{key:"resyncLoader",value:function(){this.mediaIndex=null,this.syncPoint_=null,this.abort()}},{key:"remove",value:function(e,t,i){if(this.sourceUpdater_&&this.sourceUpdater_.remove(e,t,i),Le(e,t,this.segmentMetadataTrack_),this.inbandTextTracks_)for(var n in this.inbandTextTracks_)Le(e,t,this.inbandTextTracks_[n])}},{key:"monitorBuffer_",value:function(){this.checkBufferTimeout_&&h.clearTimeout(this.checkBufferTimeout_),this.checkBufferTimeout_=h.setTimeout(this.monitorBufferTick_.bind(this),1)}},{key:"monitorBufferTick_",value:function(){"READY"===this.state&&this.fillBuffer_(),this.checkBufferTimeout_&&h.clearTimeout(this.checkBufferTimeout_),this.checkBufferTimeout_=h.setTimeout(this.monitorBufferTick_.bind(this),500)}},{key:"fillBuffer_",value:function(){if(!this.sourceUpdater_.updating()){this.syncPoint_||(this.syncPoint_=this.syncController_.getSyncPoint(this.playlist_,this.duration_(),this.currentTimeline_,this.currentTime_()));var e=this.checkBuffer_(this.buffered_(),this.playlist_,this.mediaIndex,this.hasPlayed_(),this.currentTime_(),this.syncPoint_);e&&(this.isEndOfStream_(e.mediaIndex)?this.endOfStream():(e.mediaIndex!==this.playlist_.segments.length-1||"ended"!==this.mediaSource_.readyState||this.seeking_())&&((e.timeline!==this.currentTimeline_||null!==e.startOfSegment&&e.startOfSegment<this.sourceUpdater_.timestampOffset())&&(this.syncController_.reset(),e.timestampOffset=e.startOfSegment,this.captionParser_.clearAllCaptions()),this.loadSegment_(e)))}}},{key:"isEndOfStream_",value:function(e){return function(e,t,i){if(!e||!t)return!1;var n=i===e.segments.length;return e.endList&&"open"===t.readyState&&n}(arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.playlist_,this.mediaSource_,e)&&!this.sourceUpdater_.updating()}},{key:"checkBuffer_",value:function(e,t,i,n,r,a){var s=0,o=void 0;e.length&&(s=e.end(e.length-1));var u=Math.max(0,s-r);if(!t.segments.length)return null;if(u>=this.goalBufferLength_())return null;if(!n&&u>=1)return null;if(null===a)return i=this.getSyncSegmentCandidate_(t),this.generateSegmentInfo_(t,i,null,!0);if(null!==i){var d=t.segments[i];return o=d&&d.end?d.end:s,this.generateSegmentInfo_(t,i+1,o,!1)}if(this.fetchAtBuffer_){var l=Q.getMediaInfoForTime(t,s,a.segmentIndex,a.time);i=l.mediaIndex,o=l.startTime}else{var h=Q.getMediaInfoForTime(t,r,a.segmentIndex,a.time);i=h.mediaIndex,o=h.startTime}return this.generateSegmentInfo_(t,i,o,!1)}},{key:"getSyncSegmentCandidate_",value:function(e){var t=this;if(-1===this.currentTimeline_)return 0;var i=e.segments.map(function(e,t){return{timeline:e.timeline,segmentIndex:t}}).filter(function(e){return e.timeline===t.currentTimeline_});return i.length?i[Math.min(i.length-1,1)].segmentIndex:Math.max(e.segments.length-1,0)}},{key:"generateSegmentInfo_",value:function(e,t,i,n){if(t<0||t>=e.segments.length)return null;var r=e.segments[t];return{requestId:"segment-loader-"+Math.random(),uri:r.resolvedUri,mediaIndex:t,isSyncRequest:n,startOfSegment:i,playlist:e,bytes:null,encryptedBytes:null,timestampOffset:null,timeline:r.timeline,duration:r.duration,segment:r}}},{key:"abortRequestEarly_",value:function(e){if(this.hls_.tech_.paused()||!this.xhrOptions_.timeout||!this.playlist_.attributes.BANDWIDTH)return!1;if(Date.now()-(e.firstBytesReceivedAt||Date.now())<1e3)return!1;var t=this.currentTime_(),i=e.bandwidth,n=this.pendingSegment_.duration,r=Q.estimateSegmentRequestTime(n,i,this.playlist_,e.bytesReceived),a=function(e,t){var i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:1;return((e.length?e.end(e.length-1):0)-t)/i}(this.buffered_(),t,this.hls_.tech_.playbackRate())-1;if(r<=a)return!1;var s=function(e){var t=e.master,i=e.currentTime,n=e.bandwidth,r=e.duration,a=e.segmentDuration,s=e.timeUntilRebuffer,o=e.currentTimeline,u=e.syncController,d=t.playlists.filter(function(e){return!Q.isIncompatible(e)}),l=d.filter(Q.isEnabled);l.length||(l=d.filter(function(e){return!Q.isDisabled(e)}));var h=l.filter(Q.hasAttribute.bind(null,"BANDWIDTH")).map(function(e){var t=u.getSyncPoint(e,r,o,i)?1:2;return{playlist:e,rebufferingImpact:Q.estimateSegmentRequestTime(a,n,e)*t-s}}),c=h.filter(function(e){return e.rebufferingImpact<=0});return $i(c,function(e,t){return Ki(t.playlist,e.playlist)}),c.length?c[0]:($i(h,function(e,t){return e.rebufferingImpact-t.rebufferingImpact}),h[0]||null)}({master:this.hls_.playlists.master,currentTime:t,bandwidth:i,duration:this.duration_(),segmentDuration:n,timeUntilRebuffer:a,currentTimeline:this.currentTimeline_,syncController:this.syncController_});if(s){var o=r-a-s.rebufferingImpact,u=.5;return a<=1/30&&(u=1),!s.playlist||s.playlist.uri===this.playlist_.uri||o<u?!1:(this.bandwidth=s.playlist.attributes.BANDWIDTH*Mi.BANDWIDTH_VARIANCE+1,this.abort(),this.trigger("earlyabort"),!0)}}},{key:"handleProgress_",value:function(e,t){this.pendingSegment_&&t.requestId===this.pendingSegment_.requestId&&!this.abortRequestEarly_(t.stats)&&this.trigger("progress")}},{key:"loadSegment_",value:function(e){this.state="WAITING",this.pendingSegment_=e,this.trimBackBuffer_(e),e.abortRequests=Xi(this.hls_.xhr,this.xhrOptions_,this.decrypter_,this.captionParser_,this.createSimplifiedSegmentObj_(e),this.handleProgress_.bind(this),this.segmentRequestFinished_.bind(this))}},{key:"trimBackBuffer_",value:function(e){var t=function(e,t,i){var n=void 0;return n=e.length&&e.start(0)>0&&e.start(0)<t?e.start(0):t-30,Math.min(n,t-i)}(this.seekable_(),this.currentTime_(),this.playlist_.targetDuration||10);t>0&&this.remove(0,t)}},{key:"createSimplifiedSegmentObj_",value:function(e){var t=e.segment,i={resolvedUri:t.resolvedUri,byterange:t.byterange,requestId:e.requestId};if(t.key){var n=t.key.iv||new Uint32Array([0,0,0,e.mediaIndex+e.playlist.mediaSequence]);i.key={resolvedUri:t.key.resolvedUri,iv:n}}return t.map&&(i.map=this.initSegment(t.map)),i}},{key:"segmentRequestFinished_",value:function(e,t){if(this.mediaRequests+=1,t.stats&&(this.mediaBytesTransferred+=t.stats.bytesReceived,this.mediaTransferDuration+=t.stats.roundTripTime),this.pendingSegment_){if(t.requestId===this.pendingSegment_.requestId){if(e)return this.pendingSegment_=null,this.state="READY",e.code===Gi?void(this.mediaRequestsAborted+=1):(this.pause(),e.code===Fi?(this.mediaRequestsTimedout+=1,this.bandwidth=1,this.roundTrip=NaN,void this.trigger("bandwidthupdate")):(this.mediaRequestsErrored+=1,this.error(e),void this.trigger("error")));this.bandwidth=t.stats.bandwidth,this.roundTrip=t.stats.roundTripTime,t.map&&(t.map=this.initSegment(t.map,!0)),this.processSegmentResponse_(t)}}else this.mediaRequestsAborted+=1}},{key:"processSegmentResponse_",value:function(e){var t=this.pendingSegment_;t.bytes=e.bytes,e.map&&(t.segment.map.bytes=e.map.bytes),t.endOfAllRequests=e.endOfAllRequests,e.fmp4Captions&&(!function(e,t,i){for(var n in i)if(!e[n]){t.trigger({type:"usage",name:"hls-608"});var r=t.textTracks().getTrackById(n);e[n]=r||t.addRemoteTextTrack({kind:"captions",id:n,label:n},!1).track}}(this.inbandTextTracks_,this.hls_.tech_,e.captionStreams),function(e){var t=e.inbandTextTracks,i=e.captionArray,n=e.timestampOffset;if(i){var r=window.WebKitDataCue||window.VTTCue;i.forEach(function(e){var i=e.stream,a=e.startTime,s=e.endTime;t[i]&&(a+=n,s+=n,t[i].addCue(new r(a,s,e.text)))})}}({inbandTextTracks:this.inbandTextTracks_,captionArray:e.fmp4Captions,timestampOffset:0}),this.captionParser_.clearParsedCaptions()),this.handleSegment_()}},{key:"handleSegment_",value:function(){var e=this;if(this.pendingSegment_){var t=this.pendingSegment_,i=t.segment,n=this.syncController_.probeSegmentInfo(t);void 0===this.startingMedia_&&n&&(n.containsAudio||n.containsVideo)&&(this.startingMedia_={containsAudio:n.containsAudio,containsVideo:n.containsVideo});var r,a,s,o=(r=this.loaderType_,a=this.startingMedia_,s=n,"main"===r&&a&&s?s.containsAudio||s.containsVideo?a.containsVideo&&!s.containsVideo?"Only audio found in segment when we expected video. We can't switch to audio only from a stream that had video. To get rid of this message, please add codec information to the manifest.":!a.containsVideo&&s.containsVideo?"Video found in segment when we expected only audio. We can't switch to a stream with video from an audio only stream. To get rid of this message, please add codec information to the manifest.":null:"Neither audio nor video found in segment.":null);if(o)return this.error({message:o,blacklistDuration:1/0}),void this.trigger("error");if(t.isSyncRequest)return this.trigger("syncinfoupdate"),this.pendingSegment_=null,void(this.state="READY");null!==t.timestampOffset&&t.timestampOffset!==this.sourceUpdater_.timestampOffset()&&(this.sourceUpdater_.timestampOffset(t.timestampOffset),this.trigger("timestampoffset"));var u=this.syncController_.mappingForTimeline(t.timeline);if(null!==u&&this.trigger({type:"segmenttimemapping",mapping:u}),this.state="APPENDING",i.map){var d=ge(i.map);if(!this.activeInitSegmentId_||this.activeInitSegmentId_!==d){var l=this.initSegment(i.map);this.sourceUpdater_.appendBuffer({bytes:l.bytes},function(){e.activeInitSegmentId_=d})}}t.byteLength=t.bytes.byteLength,"number"==typeof i.start&&"number"==typeof i.end?this.mediaSecondsLoaded+=i.end-i.start:this.mediaSecondsLoaded+=i.duration,this.logger_(function(e){var t=e.segment,i=t.start,n=t.end,r=e.playlist,a=r.mediaSequence,s=r.id,o=r.segments,u=void 0===o?[]:o,d=e.mediaIndex,l=e.timeline;return["appending ["+d+"] of ["+a+", "+(a+u.length)+"] from playlist ["+s+"]","["+i+" => "+n+"] in timeline ["+l+"]"].join(" ")}(t)),this.sourceUpdater_.appendBuffer({bytes:t.bytes,videoSegmentTimingInfoCallback:this.handleVideoSegmentTimingInfo_.bind(this,t.requestId)},this.handleUpdateEnd_.bind(this))}else this.state="READY"}},{key:"handleVideoSegmentTimingInfo_",value:function(e,t){if(this.pendingSegment_&&e===this.pendingSegment_.requestId){var i=this.pendingSegment_.segment;i.videoTimingInfo||(i.videoTimingInfo={}),i.videoTimingInfo.transmuxerPrependedSeconds=t.videoSegmentTimingInfo.prependedContentDuration||0,i.videoTimingInfo.transmuxedPresentationStart=t.videoSegmentTimingInfo.start.presentation,i.videoTimingInfo.transmuxedPresentationEnd=t.videoSegmentTimingInfo.end.presentation,i.videoTimingInfo.baseMediaDecodeTime=t.videoSegmentTimingInfo.baseMediaDecodeTime}}},{key:"handleUpdateEnd_",value:function(){if(!this.pendingSegment_)return this.state="READY",void(this.paused()||this.monitorBuffer_());var e=this.pendingSegment_,t=e.segment,i=null!==this.mediaIndex;this.pendingSegment_=null,this.recordThroughput_(e),this.addSegmentMetadataCue_(e),this.state="READY",this.mediaIndex=e.mediaIndex,this.fetchAtBuffer_=!0,this.currentTimeline_=e.timeline,this.trigger("syncinfoupdate"),t.end&&this.currentTime_()-t.end>3*e.playlist.targetDuration?this.resetEverything():(i&&this.trigger("bandwidthupdate"),this.trigger("progress"),this.isEndOfStream_(e.mediaIndex+1,e.playlist)&&this.endOfStream(),this.paused()||this.monitorBuffer_())}},{key:"recordThroughput_",value:function(e){var t=this.throughput.rate,i=Date.now()-e.endOfAllRequests+1,n=Math.floor(e.byteLength/i*8*1e3);this.throughput.rate+=(n-t)/++this.throughput.count}},{key:"addSegmentMetadataCue_",value:function(e){if(this.segmentMetadataTrack_){var t=e.segment,i=t.start,n=t.end;if(qr(i)&&qr(n)){Le(i,n,this.segmentMetadataTrack_);var r=h.WebKitDataCue||h.VTTCue,a={custom:t.custom,dateTimeObject:t.dateTimeObject,dateTimeString:t.dateTimeString,bandwidth:e.playlist.attributes.BANDWIDTH,resolution:e.playlist.attributes.RESOLUTION,codecs:e.playlist.attributes.CODECS,byteLength:e.byteLength,uri:e.uri,timeline:e.timeline,playlist:e.playlist.uri,start:i,end:n},s=new r(i,n,JSON.stringify(a));s.value=a,this.segmentMetadataTrack_.addCue(s)}}}}]),i}(t.EventTarget),Gr=function(e){return decodeURIComponent(escape(String.fromCharCode.apply(null,e)))},Vr=new Uint8Array("\n\n".split("").map(function(e){return e.charCodeAt(0)})),Hr=function(e){function i(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};S(this,i);var n=U(this,(i.__proto__||Object.getPrototypeOf(i)).call(this,e,t));return n.mediaSource_=null,n.subtitlesTrack_=null,n}return w(i,Fr),k(i,[{key:"buffered_",value:function(){if(!this.subtitlesTrack_||!this.subtitlesTrack_.cues.length)return t.createTimeRanges();var e=this.subtitlesTrack_.cues,i=e[0].startTime,n=e[e.length-1].startTime;return t.createTimeRanges([[i,n]])}},{key:"initSegment",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]&&arguments[1];if(!e)return null;var i=ge(e),n=this.initSegments_[i];if(t&&!n&&e.bytes){var r=Vr.byteLength+e.bytes.byteLength,a=new Uint8Array(r);a.set(e.bytes),a.set(Vr,e.bytes.byteLength),this.initSegments_[i]=n={resolvedUri:e.resolvedUri,byterange:e.byterange,bytes:a}}return n||e}},{key:"couldBeginLoading_",value:function(){return this.playlist_&&this.subtitlesTrack_&&!this.paused()}},{key:"init_",value:function(){return this.state="READY",this.resetEverything(),this.monitorBuffer_()}},{key:"track",value:function(e){return void 0===e?this.subtitlesTrack_:(this.subtitlesTrack_=e,"INIT"===this.state&&this.couldBeginLoading_()&&this.init_(),this.subtitlesTrack_)}},{key:"remove",value:function(e,t){Le(e,t,this.subtitlesTrack_)}},{key:"fillBuffer_",value:function(){var e=this;this.syncPoint_||(this.syncPoint_=this.syncController_.getSyncPoint(this.playlist_,this.duration_(),this.currentTimeline_,this.currentTime_()));var t=this.checkBuffer_(this.buffered_(),this.playlist_,this.mediaIndex,this.hasPlayed_(),this.currentTime_(),this.syncPoint_);if(t=this.skipEmptySegments_(t)){if(null===this.syncController_.timestampOffsetForTimeline(t.timeline)){return this.syncController_.one("timestampoffset",function(){e.state="READY",e.paused()||e.monitorBuffer_()}),void(this.state="WAITING_ON_TIMELINE")}this.loadSegment_(t)}}},{key:"skipEmptySegments_",value:function(e){for(;e&&e.segment.empty;)e=this.generateSegmentInfo_(e.playlist,e.mediaIndex+1,e.startOfSegment+e.duration,e.isSyncRequest);return e}},{key:"handleSegment_",value:function(){var e=this;if(this.pendingSegment_&&this.subtitlesTrack_){this.state="APPENDING";var t=this.pendingSegment_,i=t.segment;if("function"!=typeof h.WebVTT&&this.subtitlesTrack_&&this.subtitlesTrack_.tech_){var n=function(){e.handleSegment_()};return this.state="WAITING_ON_VTTJS",this.subtitlesTrack_.tech_.one("vttjsloaded",n),void this.subtitlesTrack_.tech_.one("vttjserror",function(){e.subtitlesTrack_.tech_.off("vttjsloaded",n),e.error({message:"Error loading vtt.js"}),e.state="READY",e.pause(),e.trigger("error")})}i.requested=!0;try{this.parseVTTCues_(t)}catch(e){return this.error({message:e.message}),this.state="READY",this.pause(),this.trigger("error")}if(this.updateTimeMapping_(t,this.syncController_.timelines[t.timeline],this.playlist_),t.isSyncRequest)return this.trigger("syncinfoupdate"),this.pendingSegment_=null,void(this.state="READY");t.byteLength=t.bytes.byteLength,this.mediaSecondsLoaded+=i.duration,t.cues.length&&this.remove(t.cues[0].endTime,t.cues[t.cues.length-1].endTime),t.cues.forEach(function(t){e.subtitlesTrack_.addCue(t)}),this.handleUpdateEnd_()}else this.state="READY"}},{key:"parseVTTCues_",value:function(e){var i=void 0,n=!1;"function"==typeof h.TextDecoder?i=new h.TextDecoder("utf8"):(i=h.WebVTT.StringDecoder(),n=!0);var r=new h.WebVTT.Parser(h,h.vttjs,i);if(e.cues=[],e.timestampmap={MPEGTS:0,LOCAL:0},r.oncue=e.cues.push.bind(e.cues),r.ontimestampmap=function(t){return e.timestampmap=t},r.onparsingerror=function(e){t.log.warn("Error encountered when parsing cues: "+e.message)},e.segment.map){var a=e.segment.map.bytes;n&&(a=Gr(a)),r.parse(a)}var s=e.bytes;n&&(s=Gr(s)),r.parse(s),r.flush()}},{key:"updateTimeMapping_",value:function(e,t,i){var n=e.segment;if(t)if(e.cues.length){var r=e.timestampmap,a=r.MPEGTS/9e4-r.LOCAL+t.mapping;if(e.cues.forEach(function(e){e.startTime+=a,e.endTime+=a}),!i.syncInfo){var s=e.cues[0].startTime,o=e.cues[e.cues.length-1].startTime;i.syncInfo={mediaSequence:i.mediaSequence+e.mediaIndex,time:Math.min(s,o-n.duration)}}}else n.empty=!0}}]),i}(),jr=function(e,t){for(var i=e.cues,n=0;n<i.length;n++){var r=i[n];if(t>=r.adStartTime&&t<=r.adEndTime)return r}return null},zr=function(e){var t=31&e[1];return t<<=8,t|=e[2]},Wr=function(e){return!!(64&e[1])},Xr=function(e){var t=0;return(48&e[3])>>>4>1&&(t+=e[4]+1),t},Yr=function(e){switch(e){case 5:return"slice_layer_without_partitioning_rbsp_idr";case 6:return"sei_rbsp";case 7:return"seq_parameter_set_rbsp";case 8:return"pic_parameter_set_rbsp";case 9:return"access_unit_delimiter_rbsp";default:return null}},$r={parseType:function(e,t){var i=zr(e);return 0===i?"pat":i===t?"pmt":t?"pes":null},parsePat:function(e){var t=Wr(e),i=4+Xr(e);return t&&(i+=e[i]+1),(31&e[i+10])<<8|e[i+11]},parsePmt:function(e){var t={},i=Wr(e),n=4+Xr(e);if(i&&(n+=e[n]+1),1&e[n+5]){var r;r=3+((15&e[n+1])<<8|e[n+2])-4;for(var a=12+((15&e[n+10])<<8|e[n+11]);a<r;){var s=n+a;t[(31&e[s+1])<<8|e[s+2]]=e[s],a+=5+((15&e[s+3])<<8|e[s+4])}return t}},parsePayloadUnitStartIndicator:Wr,parsePesType:function(e,t){switch(t[zr(e)]){case qn.H264_STREAM_TYPE:return"video";case qn.ADTS_STREAM_TYPE:return"audio";case qn.METADATA_STREAM_TYPE:return"timed-metadata";default:return null}},parsePesTime:function(e){if(!Wr(e))return null;var t=4+Xr(e);if(t>=e.byteLength)return null;var i,n=null;return 192&(i=e[t+7])&&((n={}).pts=(14&e[t+9])<<27|(255&e[t+10])<<20|(254&e[t+11])<<12|(255&e[t+12])<<5|(254&e[t+13])>>>3,n.pts*=4,n.pts+=(6&e[t+13])>>>1,n.dts=n.pts,64&i&&(n.dts=(14&e[t+14])<<27|(255&e[t+15])<<20|(254&e[t+16])<<12|(255&e[t+17])<<5|(254&e[t+18])>>>3,n.dts*=4,n.dts+=(6&e[t+18])>>>1)),n},videoPacketContainsKeyFrame:function(e){for(var t=4+Xr(e),i=e.subarray(t),n=0,r=0,a=!1;r<i.byteLength-3;r++)if(1===i[r+2]){n=r+5;break}for(;n<i.byteLength;)switch(i[n]){case 0:if(0!==i[n-1]){n+=2;break}if(0!==i[n-2]){n++;break}r+3!==n-2&&"slice_layer_without_partitioning_rbsp_idr"===Yr(31&i[r+3])&&(a=!0);do{n++}while(1!==i[n]&&n<i.length);r=n-2,n+=3;break;case 1:if(0!==i[n-1]||0!==i[n-2]){n+=3;break}"slice_layer_without_partitioning_rbsp_idr"===Yr(31&i[r+3])&&(a=!0),r=n-2,n+=3;break;default:n+=3}return i=i.subarray(r),n-=r,r=0,i&&i.byteLength>3&&"slice_layer_without_partitioning_rbsp_idr"===Yr(31&i[r+3])&&(a=!0),a}},Kr=jn,Qr={};Qr.ts=$r,Qr.aac=pr;var Zr=function(e,t,i){for(var n,r,a,s,o=0,u=188,d=!1;u<=e.byteLength;)if(71!==e[o]||71!==e[u]&&u!==e.byteLength)o++,u++;else{switch(n=e.subarray(o,u),Qr.ts.parseType(n,t.pid)){case"pes":r=Qr.ts.parsePesType(n,t.table),a=Qr.ts.parsePayloadUnitStartIndicator(n),"audio"===r&&a&&(s=Qr.ts.parsePesTime(n))&&(s.type="audio",i.audio.push(s),d=!0)}if(d)break;o+=188,u+=188}for(o=(u=e.byteLength)-188,d=!1;o>=0;)if(71!==e[o]||71!==e[u]&&u!==e.byteLength)o--,u--;else{switch(n=e.subarray(o,u),Qr.ts.parseType(n,t.pid)){case"pes":r=Qr.ts.parsePesType(n,t.table),a=Qr.ts.parsePayloadUnitStartIndicator(n),"audio"===r&&a&&(s=Qr.ts.parsePesTime(n))&&(s.type="audio",i.audio.push(s),d=!0)}if(d)break;o-=188,u-=188}},Jr=function(e,t,i){for(var n,r,a,s,o,u,d,l=0,h=188,c=!1,f={data:[],size:0};h<e.byteLength;)if(71!==e[l]||71!==e[h])l++,h++;else{switch(n=e.subarray(l,h),Qr.ts.parseType(n,t.pid)){case"pes":if(r=Qr.ts.parsePesType(n,t.table),a=Qr.ts.parsePayloadUnitStartIndicator(n),"video"===r&&(a&&!c&&(s=Qr.ts.parsePesTime(n))&&(s.type="video",i.video.push(s),c=!0),!i.firstKeyFrame)){if(a&&0!==f.size){for(o=new Uint8Array(f.size),u=0;f.data.length;)d=f.data.shift(),o.set(d,u),u+=d.byteLength;Qr.ts.videoPacketContainsKeyFrame(o)&&(i.firstKeyFrame=Qr.ts.parsePesTime(o),i.firstKeyFrame.type="video"),f.size=0}f.data.push(n),f.size+=n.byteLength}}if(c&&i.firstKeyFrame)break;l+=188,h+=188}for(l=(h=e.byteLength)-188,c=!1;l>=0;)if(71!==e[l]||71!==e[h])l--,h--;else{switch(n=e.subarray(l,h),Qr.ts.parseType(n,t.pid)){case"pes":r=Qr.ts.parsePesType(n,t.table),a=Qr.ts.parsePayloadUnitStartIndicator(n),"video"===r&&a&&(s=Qr.ts.parsePesTime(n))&&(s.type="video",i.video.push(s),c=!0)}if(c)break;l-=188,h-=188}},ea=function(e){var t={pid:null,table:null},i={};for(var n in function(e,t){for(var i,n=0,r=188;r<e.byteLength;)if(71!==e[n]||71!==e[r])n++,r++;else{switch(i=e.subarray(n,r),Qr.ts.parseType(i,t.pid)){case"pat":t.pid||(t.pid=Qr.ts.parsePat(i));break;case"pmt":t.table||(t.table=Qr.ts.parsePmt(i))}if(t.pid&&t.table)return;n+=188,r+=188}}(e,t),t.table){if(t.table.hasOwnProperty(n))switch(t.table[n]){case qn.H264_STREAM_TYPE:i.video=[],Jr(e,t,i),0===i.video.length&&delete i.video;break;case qn.ADTS_STREAM_TYPE:i.audio=[],Zr(e,t,i),0===i.audio.length&&delete i.audio}}return i},ta=function(e,t){var i;return(i=Qr.aac.isLikelyAacData(e)?function(e){for(var t,i=!1,n=0,r=null,a=null,s=0,o=0;e.length-o>=3;){switch(Qr.aac.parseType(e,o)){case"timed-metadata":if(e.length-o<10){i=!0;break}if((s=Qr.aac.parseId3TagSize(e,o))>e.length){i=!0;break}null===a&&(t=e.subarray(o,o+s),a=Qr.aac.parseAacTimestamp(t)),o+=s;break;case"audio":if(e.length-o<7){i=!0;break}if((s=Qr.aac.parseAdtsSize(e,o))>e.length){i=!0;break}null===r&&(t=e.subarray(o,o+s),r=Qr.aac.parseSampleRate(t)),n++,o+=s;break;default:o++}if(i)return null}if(null===r||null===a)return null;var u=9e4/r;return{audio:[{type:"audio",dts:a,pts:a},{type:"audio",dts:a+1024*n*u,pts:a+1024*n*u}]}}(e):ea(e))&&(i.audio||i.video)?(function(e,t){if(e.audio&&e.audio.length){var i=t;void 0===i&&(i=e.audio[0].dts),e.audio.forEach(function(e){e.dts=Kr(e.dts,i),e.pts=Kr(e.pts,i),e.dtsTime=e.dts/9e4,e.ptsTime=e.pts/9e4})}if(e.video&&e.video.length){var n=t;if(void 0===n&&(n=e.video[0].dts),e.video.forEach(function(e){e.dts=Kr(e.dts,n),e.pts=Kr(e.pts,n),e.dtsTime=e.dts/9e4,e.ptsTime=e.pts/9e4}),e.firstKeyFrame){var r=e.firstKeyFrame;r.dts=Kr(r.dts,n),r.pts=Kr(r.pts,n),r.dtsTime=r.dts/9e4,r.ptsTime=r.dts/9e4}}}(i,t),i):null},ia=[{name:"VOD",run:function(e,t,i,n,r){if(i!==1/0){return{time:0,segmentIndex:0}}return null}},{name:"ProgramDateTime",run:function(e,t,i,n,r){if(!e.datetimeToDisplayTime)return null;var a=t.segments||[],s=null,o=null;r=r||0;for(var u=0;u<a.length;u++){var d=a[u];if(d.dateTimeObject){var l=d.dateTimeObject.getTime()/1e3+e.datetimeToDisplayTime,h=Math.abs(r-l);if(null!==o&&o<h)break;o=h,s={time:l,segmentIndex:u}}}return s}},{name:"Segment",run:function(e,t,i,n,r){var a=t.segments||[],s=null,o=null;r=r||0;for(var u=0;u<a.length;u++){var d=a[u];if(d.timeline===n&&void 0!==d.start){var l=Math.abs(r-d.start);if(null!==o&&o<l)break;(!s||null===o||o>=l)&&(o=l,s={time:d.start,segmentIndex:u})}}return s}},{name:"Discontinuity",run:function(e,t,i,n,r){var a=null;if(r=r||0,t.discontinuityStarts&&t.discontinuityStarts.length)for(var s=null,o=0;o<t.discontinuityStarts.length;o++){var u=t.discontinuityStarts[o],d=t.discontinuitySequence+o+1,l=e.discontinuities[d];if(l){var h=Math.abs(r-l.time);if(null!==s&&s<h)break;(!a||null===s||s>=h)&&(s=h,a={time:l.time,segmentIndex:u})}}return a}},{name:"Playlist",run:function(e,t,i,n,r){return t.syncInfo?{time:t.syncInfo.time,segmentIndex:t.syncInfo.mediaSequence-t.mediaSequence}:null}}],na=function(e){function t(){S(this,t);var e=U(this,(t.__proto__||Object.getPrototypeOf(t)).call(this));return e.inspectCache_=void 0,e.timelines=[],e.discontinuities=[],e.datetimeToDisplayTime=null,e.logger_=zt("SyncController"),e}return w(t,e),k(t,[{key:"getSyncPoint",value:function(e,t,i,n){var r=this.runStrategies_(e,t,i,n);return r.length?this.selectSyncPoint_(r,{key:"time",value:n}):null}},{key:"getExpiredTime",value:function(e,t){if(!e||!e.segments)return null;var i=this.runStrategies_(e,t,e.discontinuitySequence,0);if(!i.length)return null;var n=this.selectSyncPoint_(i,{key:"segmentIndex",value:0});return n.segmentIndex>0&&(n.time*=-1),Math.abs(n.time+q(e,n.segmentIndex,0))}},{key:"runStrategies_",value:function(e,t,i,n){for(var r=[],a=0;a<ia.length;a++){var s=ia[a],o=s.run(this,e,t,i,n);o&&(o.strategy=s.name,r.push({strategy:s.name,syncPoint:o}))}return r}},{key:"selectSyncPoint_",value:function(e,t){for(var i=e[0].syncPoint,n=Math.abs(e[0].syncPoint[t.key]-t.value),r=e[0].strategy,a=1;a<e.length;a++){var s=Math.abs(e[a].syncPoint[t.key]-t.value);s<n&&(n=s,i=e[a].syncPoint,r=e[a].strategy)}return this.logger_("syncPoint for ["+t.key+": "+t.value+"] chosen with strategy ["+r+"]: [time:"+i.time+", segmentIndex:"+i.segmentIndex+"]"),i}},{key:"saveExpiredSegmentInfo",value:function(e,t){for(var i=t.mediaSequence-e.mediaSequence-1;i>=0;i--){var n=e.segments[i];if(n&&void 0!==n.start){t.syncInfo={mediaSequence:e.mediaSequence+i,time:n.start},this.logger_("playlist refresh sync: [time:"+t.syncInfo.time+", mediaSequence: "+t.syncInfo.mediaSequence+"]"),this.trigger("syncinfoupdate");break}}}},{key:"setDateTimeMapping",value:function(e){if(!this.datetimeToDisplayTime&&e.segments&&e.segments.length&&e.segments[0].dateTimeObject){var t=e.segments[0].dateTimeObject.getTime()/1e3;this.datetimeToDisplayTime=-t}}},{key:"reset",value:function(){this.inspectCache_=void 0}},{key:"probeSegmentInfo",value:function(e){var t=e.segment,i=e.playlist,n=void 0;return(n=t.map?this.probeMp4Segment_(e):this.probeTsSegment_(e))&&this.calculateSegmentTimeMapping_(e,n)&&(this.saveDiscontinuitySyncInfo_(e),i.syncInfo||(i.syncInfo={mediaSequence:i.mediaSequence+e.mediaIndex,time:t.start})),n}},{key:"probeMp4Segment_",value:function(e){var t=e.segment,i=Ni.timescale(t.map.bytes),n=Ni.startTime(i,e.bytes);return null!==e.timestampOffset&&(e.timestampOffset-=n),{start:n,end:n+t.duration}}},{key:"probeTsSegment_",value:function(e){var t=ta(e.bytes,this.inspectCache_),i=void 0,n=void 0;return t?(t.video&&2===t.video.length?(this.inspectCache_=t.video[1].dts,i=t.video[0].dtsTime,n=t.video[1].dtsTime):t.audio&&2===t.audio.length&&(this.inspectCache_=t.audio[1].dts,i=t.audio[0].dtsTime,n=t.audio[1].dtsTime),{start:i,end:n,containsVideo:t.video&&2===t.video.length,containsAudio:t.audio&&2===t.audio.length}):null}},{key:"timestampOffsetForTimeline",value:function(e){return void 0===this.timelines[e]?null:this.timelines[e].time}},{key:"mappingForTimeline",value:function(e){return void 0===this.timelines[e]?null:this.timelines[e].mapping}},{key:"calculateSegmentTimeMapping_",value:function(e,t){var i=e.segment,n=this.timelines[e.timeline];if(null!==e.timestampOffset)n={time:e.startOfSegment,mapping:e.startOfSegment-t.start},this.timelines[e.timeline]=n,this.trigger("timestampoffset"),this.logger_("time mapping for timeline "+e.timeline+": [time: "+n.time+"] [mapping: "+n.mapping+"]"),i.start=e.startOfSegment,i.end=t.end+n.mapping;else{if(!n)return!1;i.start=t.start+n.mapping,i.end=t.end+n.mapping}return!0}},{key:"saveDiscontinuitySyncInfo_",value:function(e){var t=e.playlist,i=e.segment;if(i.discontinuity)this.discontinuities[i.timeline]={time:i.start,accuracy:0};else if(t.discontinuityStarts&&t.discontinuityStarts.length)for(var n=0;n<t.discontinuityStarts.length;n++){var r=t.discontinuityStarts[n],a=t.discontinuitySequence+n+1,s=r-e.mediaIndex,o=Math.abs(s);if(!this.discontinuities[a]||this.discontinuities[a].accuracy>o){var u=void 0;u=s<0?i.start-q(t,e.mediaIndex,r):i.end+q(t,e.mediaIndex+1,r),this.discontinuities[a]={time:u,accuracy:o}}}}}]),t}(t.EventTarget),ra=new xe("./decrypter-worker.worker.js",function(e,t){var i=this;!function(){var e=function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")},t=function(){function e(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}return function(t,i,n){return i&&e(t.prototype,i),n&&e(t,n),t}}(),n=function(e,t){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!t||"object"!=typeof t&&"function"!=typeof t?e:t},r=function(){var e=[[[],[],[],[],[]],[[],[],[],[],[]]],t=e[0],i=e[1],n=t[4],r=i[4],a=void 0,s=void 0,o=void 0,u=[],d=[],l=void 0,h=void 0,c=void 0,f=void 0,p=void 0;for(a=0;a<256;a++)d[(u[a]=a<<1^283*(a>>7))^a]=a;for(s=o=0;!n[s];s^=l||1,o=d[o]||1)for(c=(c=o^o<<1^o<<2^o<<3^o<<4)>>8^255&c^99,n[s]=c,r[c]=s,p=16843009*u[h=u[l=u[s]]]^65537*h^257*l^16843008*s,f=257*u[c]^16843008*c,a=0;a<4;a++)t[a][s]=f=f<<24^f>>>8,i[a][c]=p=p<<24^p>>>8;for(a=0;a<5;a++)t[a]=t[a].slice(0),i[a]=i[a].slice(0);return e},a=null,s=function(){function t(i){e(this,t),a||(a=r()),this._tables=[[a[0][0].slice(),a[0][1].slice(),a[0][2].slice(),a[0][3].slice(),a[0][4].slice()],[a[1][0].slice(),a[1][1].slice(),a[1][2].slice(),a[1][3].slice(),a[1][4].slice()]];var n=void 0,s=void 0,o=void 0,u=void 0,d=void 0,l=this._tables[0][4],h=this._tables[1],c=i.length,f=1;if(4!==c&&6!==c&&8!==c)throw new Error("Invalid aes key size");for(u=i.slice(0),d=[],this._key=[u,d],n=c;n<4*c+28;n++)o=u[n-1],(n%c==0||8===c&&n%c==4)&&(o=l[o>>>24]<<24^l[o>>16&255]<<16^l[o>>8&255]<<8^l[255&o],n%c==0&&(o=o<<8^o>>>24^f<<24,f=f<<1^283*(f>>7))),u[n]=u[n-c]^o;for(s=0;n;s++,n--)o=u[3&s?n:n-4],d[s]=n<=4||s<4?o:h[0][l[o>>>24]]^h[1][l[o>>16&255]]^h[2][l[o>>8&255]]^h[3][l[255&o]]}return t.prototype.decrypt=function(e,t,i,n,r,a){var s=this._key[1],o=e^s[0],u=n^s[1],d=i^s[2],l=t^s[3],h=void 0,c=void 0,f=void 0,p=s.length/4-2,m=void 0,g=4,y=this._tables[1],_=y[0],v=y[1],b=y[2],T=y[3],S=y[4];for(m=0;m<p;m++)h=_[o>>>24]^v[u>>16&255]^b[d>>8&255]^T[255&l]^s[g],c=_[u>>>24]^v[d>>16&255]^b[l>>8&255]^T[255&o]^s[g+1],f=_[d>>>24]^v[l>>16&255]^b[o>>8&255]^T[255&u]^s[g+2],l=_[l>>>24]^v[o>>16&255]^b[u>>8&255]^T[255&d]^s[g+3],g+=4,o=h,u=c,d=f;for(m=0;m<4;m++)r[(3&-m)+a]=S[o>>>24]<<24^S[u>>16&255]<<16^S[d>>8&255]<<8^S[255&l]^s[g++],h=o,o=u,u=d,d=l,l=h},t}(),o=function(){function t(){e(this,t),this.listeners={}}return t.prototype.on=function(e,t){this.listeners[e]||(this.listeners[e]=[]),this.listeners[e].push(t)},t.prototype.off=function(e,t){if(!this.listeners[e])return!1;var i=this.listeners[e].indexOf(t);return this.listeners[e].splice(i,1),i>-1},t.prototype.trigger=function(e){var t=this.listeners[e];if(t)if(2===arguments.length)for(var i=t.length,n=0;n<i;++n)t[n].call(this,arguments[1]);else for(var r=Array.prototype.slice.call(arguments,1),a=t.length,s=0;s<a;++s)t[s].apply(this,r)},t.prototype.dispose=function(){this.listeners={}},t.prototype.pipe=function(e){this.on("data",function(t){e.push(t)})},t}(),u=function(t){function i(){e(this,i);var r=n(this,t.call(this,o));return r.jobs=[],r.delay=1,r.timeout_=null,r}return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t);e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)}(i,t),i.prototype.processJob_=function(){this.jobs.shift()(),this.jobs.length?this.timeout_=setTimeout(this.processJob_.bind(this),this.delay):this.timeout_=null},i.prototype.push=function(e){this.jobs.push(e),this.timeout_||(this.timeout_=setTimeout(this.processJob_.bind(this),this.delay))},i}(o),d=function(e){return e<<24|(65280&e)<<8|(16711680&e)>>8|e>>>24},l=function(){function i(t,n,r,a){e(this,i);var s=i.STEP,o=new Int32Array(t.buffer),l=new Uint8Array(t.byteLength),h=0;for(this.asyncStream_=new u,this.asyncStream_.push(this.decryptChunk_(o.subarray(h,h+s),n,r,l)),h=s;h<o.length;h+=s)r=new Uint32Array([d(o[h-4]),d(o[h-3]),d(o[h-2]),d(o[h-1])]),this.asyncStream_.push(this.decryptChunk_(o.subarray(h,h+s),n,r,l));this.asyncStream_.push(function(){var e;a(null,(e=l).subarray(0,e.byteLength-e[e.byteLength-1]))})}return i.prototype.decryptChunk_=function(e,t,i,n){return function(){var r=function(e,t,i){var n=new Int32Array(e.buffer,e.byteOffset,e.byteLength>>2),r=new s(Array.prototype.slice.call(t)),a=new Uint8Array(e.byteLength),o=new Int32Array(a.buffer),u=void 0,l=void 0,h=void 0,c=void 0,f=void 0,p=void 0,m=void 0,g=void 0,y=void 0;for(u=i[0],l=i[1],h=i[2],c=i[3],y=0;y<n.length;y+=4)f=d(n[y]),p=d(n[y+1]),m=d(n[y+2]),g=d(n[y+3]),r.decrypt(f,p,m,g,o,y),o[y]=d(o[y]^u),o[y+1]=d(o[y+1]^l),o[y+2]=d(o[y+2]^h),o[y+3]=d(o[y+3]^c),u=f,l=p,h=m,c=g;return a}(e,t,i);n.set(r,e.byteOffset)}},t(i,null,[{key:"STEP",get:function(){return 32e3}}]),i}();new function(e){e.onmessage=function(t){var i=t.data,n=new Uint8Array(i.encrypted.bytes,i.encrypted.byteOffset,i.encrypted.byteLength),r=new Uint32Array(i.key.bytes,i.key.byteOffset,i.key.byteLength/4),a=new Uint32Array(i.iv.bytes,i.iv.byteOffset,i.iv.byteLength/4);new l(n,r,a,function(t,n){var r,a;e.postMessage((r={source:i.source,decrypted:n},a={},Object.keys(r).forEach(function(e){var t=r[e];ArrayBuffer.isView(t)?a[e]={bytes:t.buffer,byteOffset:t.byteOffset,byteLength:t.byteLength}:a[e]=t}),a),[n.buffer])})}}(i)}()}),aa=function(e){var t=e.default?"main":"alternative";return e.characteristics&&e.characteristics.indexOf("public.accessibility.describes-video")>=0&&(t="main-desc"),t},sa=function(e,t){e.abort(),e.pause(),t&&t.activePlaylistLoader&&(t.activePlaylistLoader.pause(),t.activePlaylistLoader=null)},oa=function(e,t){t.activePlaylistLoader=e,e.load()},ua={AUDIO:function(e,i){return function(){var n=i.segmentLoaders[e],r=i.mediaTypes[e],a=i.blacklistCurrentPlaylist;sa(n,r);var s=r.activeTrack(),o=r.activeGroup(),u=(o.filter(function(e){return e.default})[0]||o[0]).id,d=r.tracks[u];if(s!==d){for(var l in t.log.warn("Problem encountered loading the alternate audio track.Switching back to default."),r.tracks)r.tracks[l].enabled=r.tracks[l]===d;r.onTrackChanged()}else a({message:"Problem encountered loading the default audio track."})}},SUBTITLES:function(e,i){return function(){var n=i.segmentLoaders[e],r=i.mediaTypes[e];t.log.warn("Problem encountered loading the subtitle track.Disabling subtitle track."),sa(n,r);var a=r.activeTrack();a&&(a.mode="disabled"),r.onTrackChanged()}}},da={AUDIO:function(e,t,i){if(t){var n=i.tech,r=i.requestOptions,a=i.segmentLoaders[e];t.on("loadedmetadata",function(){var e=t.media();a.playlist(e,r),(!n.paused()||e.endList&&"none"!==n.preload())&&a.load()}),t.on("loadedplaylist",function(){a.playlist(t.media(),r),n.paused()||a.load()}),t.on("error",ua[e](e,i))}},SUBTITLES:function(e,t,i){var n=i.tech,r=i.requestOptions,a=i.segmentLoaders[e],s=i.mediaTypes[e];t.on("loadedmetadata",function(){var e=t.media();a.playlist(e,r),a.track(s.activeTrack()),(!n.paused()||e.endList&&"none"!==n.preload())&&a.load()}),t.on("loadedplaylist",function(){a.playlist(t.media(),r),n.paused()||a.load()}),t.on("error",ua[e](e,i))}},la=function(e,t){return function(i){return i.attributes[e]===t}},ha=function(e){return function(t){return t.resolvedUri===e}},ca={AUDIO:function(e,i){var n=i.hls,r=i.sourceType,a=i.segmentLoaders[e],s=i.requestOptions,o=i.master,u=o.mediaGroups,d=o.playlists,l=i.mediaTypes[e],h=l.groups,c=l.tracks,f=i.masterPlaylistLoader;for(var p in u[e]&&0!==Object.keys(u[e]).length||(u[e]={main:{default:{default:!0}}}),u[e]){h[p]||(h[p]=[]);var m=d.filter(la(e,p));for(var g in u[e][p]){var y=u[e][p][g];m.filter(ha(y.resolvedUri)).length&&delete y.resolvedUri;var _=void 0;if(_=y.resolvedUri?new x(y.resolvedUri,n,s):y.playlists&&"dash"===r?new jt(y.playlists[0],n,s,f):null,y=t.mergeOptions({id:g,playlistLoader:_},y),da[e](e,y.playlistLoader,i),h[p].push(y),void 0===c[g]){var v=new t.AudioTrack({id:g,kind:aa(y),enabled:!1,language:y.language,default:y.default,label:g});c[g]=v}}}a.on("error",ua[e](e,i))},SUBTITLES:function(e,i){var n=i.tech,r=i.hls,a=i.sourceType,s=i.segmentLoaders[e],o=i.requestOptions,u=i.master.mediaGroups,d=i.mediaTypes[e],l=d.groups,h=d.tracks,c=i.masterPlaylistLoader;for(var f in u[e])for(var p in l[f]||(l[f]=[]),u[e][f])if(!u[e][f][p].forced){var m=u[e][f][p],g=void 0;if("hls"===a?g=new x(m.resolvedUri,r,o):"dash"===a&&(g=new jt(m.playlists[0],r,o,c)),m=t.mergeOptions({id:p,playlistLoader:g},m),da[e](e,m.playlistLoader,i),l[f].push(m),void 0===h[p]){var y=n.addRemoteTextTrack({id:p,kind:"subtitles",default:m.default&&m.autoselect,language:m.language,label:p},!1).track;h[p]=y}}s.on("error",ua[e](e,i))},"CLOSED-CAPTIONS":function(e,i){var n=i.tech,r=i.master.mediaGroups,a=i.mediaTypes[e],s=a.groups,o=a.tracks;for(var u in r[e])for(var d in s[u]||(s[u]=[]),r[e][u]){var l=r[e][u][d];if(l.instreamId.match(/CC\d/)&&(s[u].push(t.mergeOptions({id:d},l)),void 0===o[d])){var h=n.addRemoteTextTrack({id:l.instreamId,kind:"captions",default:l.default&&l.autoselect,language:l.language,label:d},!1).track;o[d]=h}}}},fa={AUDIO:function(e,t){return function(){var i=t.mediaTypes[e].tracks;for(var n in i)if(i[n].enabled)return i[n];return null}},SUBTITLES:function(e,t){return function(){var i=t.mediaTypes[e].tracks;for(var n in i)if("showing"===i[n].mode)return i[n];return null}}},pa=function(e){["AUDIO","SUBTITLES","CLOSED-CAPTIONS"].forEach(function(t){ca[t](t,e)});var t=e.mediaTypes,i=e.masterPlaylistLoader,n=e.tech,r=e.hls;["AUDIO","SUBTITLES"].forEach(function(i){t[i].activeGroup=function(e,t){return function(i){var n=t.masterPlaylistLoader,r=t.mediaTypes[e].groups,a=n.media();if(!a)return null;var s=null;return a.attributes[e]&&(s=r[a.attributes[e]]),s=s||r.main,void 0===i?s:null===i?null:s.filter(function(e){return e.id===i.id})[0]||null}}(i,e),t[i].activeTrack=fa[i](i,e),t[i].onGroupChanged=function(e,t){return function(){var i=t.segmentLoaders,n=i[e],r=i.main,a=t.mediaTypes[e],s=a.activeTrack(),o=a.activeGroup(s),u=a.activePlaylistLoader;sa(n,a),o&&(o.playlistLoader?(n.resyncLoader(),oa(o.playlistLoader,a)):u&&r.resetEverything())}}(i,e),t[i].onTrackChanged=function(e,t){return function(){var i=t.segmentLoaders,n=i[e],r=i.main,a=t.mediaTypes[e],s=a.activeTrack(),o=a.activeGroup(s),u=a.activePlaylistLoader;sa(n,a),o&&(o.playlistLoader?u!==o.playlistLoader?(n.track&&n.track(s),n.resetEverything(),oa(o.playlistLoader,a)):oa(o.playlistLoader,a):r.resetEverything())}}(i,e)});var a=t.AUDIO.activeGroup(),s=(a.filter(function(e){return e.default})[0]||a[0]).id;t.AUDIO.tracks[s].enabled=!0,t.AUDIO.onTrackChanged(),i.on("mediachange",function(){["AUDIO","SUBTITLES"].forEach(function(e){return t[e].onGroupChanged()})});var o=function(){t.AUDIO.onTrackChanged(),n.trigger({type:"usage",name:"hls-audio-change"})};for(var u in n.audioTracks().addEventListener("change",o),n.remoteTextTracks().addEventListener("change",t.SUBTITLES.onTrackChanged),r.on("dispose",function(){n.audioTracks().removeEventListener("change",o),n.remoteTextTracks().removeEventListener("change",t.SUBTITLES.onTrackChanged)}),n.clearTracks("audio"),t.AUDIO.tracks)n.audioTracks().addTrack(t.AUDIO.tracks[u])},ma=function(){var e={};return["AUDIO","SUBTITLES","CLOSED-CAPTIONS"].forEach(function(t){e[t]={groups:{},tracks:{},activePlaylistLoader:null,activeGroup:Wt,activeTrack:Wt,onGroupChanged:Wt,onTrackChanged:Wt}}),e},ga=void 0,ya=["mediaRequests","mediaRequestsAborted","mediaRequestsTimedout","mediaRequestsErrored","mediaTransferDuration","mediaBytesTransferred"],_a=function(e){return this.audioSegmentLoader_[e]+this.mainSegmentLoader_[e]},va=function(e){function i(e){S(this,i);var n=U(this,(i.__proto__||Object.getPrototypeOf(i)).call(this)),r=e.url,a=e.handleManifestRedirects,s=e.withCredentials,o=e.tech,u=e.bandwidth,d=e.externHls,l=e.useCueTags,h=e.blacklistDuration,c=e.enableLowInitialPlaylist,f=e.sourceType,p=e.seekTo;if(!r)throw new Error("A non-empty playlist URL is required");ga=d,n.withCredentials=s,n.tech_=o,n.hls_=o.hls,n.seekTo_=p,n.sourceType_=f,n.useCueTags_=l,n.blacklistDuration=h,n.enableLowInitialPlaylist=c,n.useCueTags_&&(n.cueTagsTrack_=n.tech_.addTextTrack("metadata","ad-cues"),n.cueTagsTrack_.inBandMetadataTrackDispatchType=""),n.requestOptions_={withCredentials:s,handleManifestRedirects:a,timeout:null},n.mediaTypes_=ma(),n.mediaSource=new t.MediaSource,n.mediaSource.addEventListener("sourceopen",n.handleSourceOpen_.bind(n)),n.seekable_=t.createTimeRanges(),n.hasPlayed_=function(){return!1},n.syncController_=new na(e),n.segmentMetadataTrack_=o.addRemoteTextTrack({kind:"metadata",label:"segment-metadata"},!1).track,n.decrypter_=new ra,n.inbandTextTracks_={};var m={hls:n.hls_,mediaSource:n.mediaSource,currentTime:n.tech_.currentTime.bind(n.tech_),seekable:function(){return n.seekable()},seeking:function(){return n.tech_.seeking()},duration:function(){return n.mediaSource.duration},hasPlayed:function(){return n.hasPlayed_()},goalBufferLength:function(){return n.goalBufferLength()},bandwidth:u,syncController:n.syncController_,decrypter:n.decrypter_,sourceType:n.sourceType_,inbandTextTracks:n.inbandTextTracks_};return n.masterPlaylistLoader_="dash"===n.sourceType_?new jt(r,n.hls_,n.requestOptions_):new x(r,n.hls_,n.requestOptions_),n.setupMasterPlaylistLoaderListeners_(),n.mainSegmentLoader_=new Fr(t.mergeOptions(m,{segmentMetadataTrack:n.segmentMetadataTrack_,loaderType:"main"}),e),n.audioSegmentLoader_=new Fr(t.mergeOptions(m,{loaderType:"audio"}),e),n.subtitleSegmentLoader_=new Hr(t.mergeOptions(m,{loaderType:"vtt"}),e),n.setupSegmentLoaderListeners_(),ya.forEach(function(e){n[e+"_"]=_a.bind(n,e)}),n.logger_=zt("MPC"),n.masterPlaylistLoader_.load(),n}return w(i,e),k(i,[{key:"setupMasterPlaylistLoaderListeners_",value:function(){var e=this;this.masterPlaylistLoader_.on("loadedmetadata",function(){var i=e.masterPlaylistLoader_.media(),n=1.5*i.targetDuration*1e3;K(e.masterPlaylistLoader_.master,e.masterPlaylistLoader_.media())?e.requestOptions_.timeout=0:e.requestOptions_.timeout=n,i.endList&&"none"!==e.tech_.preload()&&(e.mainSegmentLoader_.playlist(i,e.requestOptions_),e.mainSegmentLoader_.load()),pa({sourceType:e.sourceType_,segmentLoaders:{AUDIO:e.audioSegmentLoader_,SUBTITLES:e.subtitleSegmentLoader_,main:e.mainSegmentLoader_},tech:e.tech_,requestOptions:e.requestOptions_,masterPlaylistLoader:e.masterPlaylistLoader_,hls:e.hls_,master:e.master(),mediaTypes:e.mediaTypes_,blacklistCurrentPlaylist:e.blacklistCurrentPlaylist.bind(e)}),e.triggerPresenceUsage_(e.master(),i);try{e.setupSourceBuffers_()}catch(i){return t.log.warn("Failed to create SourceBuffers",i),e.mediaSource.endOfStream("decode")}e.setupFirstPlay(),!e.mediaTypes_.AUDIO.activePlaylistLoader||e.mediaTypes_.AUDIO.activePlaylistLoader.media()?e.trigger("selectedinitialmedia"):e.mediaTypes_.AUDIO.activePlaylistLoader.one("loadedmetadata",function(){e.trigger("selectedinitialmedia")})}),this.masterPlaylistLoader_.on("loadedplaylist",function(){var t=e.masterPlaylistLoader_.media();if(!t){e.excludeUnsupportedVariants_();var i=void 0;return e.enableLowInitialPlaylist&&(i=e.selectInitialPlaylist()),i||(i=e.selectPlaylist()),e.initialMedia_=i,void e.masterPlaylistLoader_.media(e.initialMedia_)}if(e.useCueTags_&&e.updateAdCues_(t),e.mainSegmentLoader_.playlist(t,e.requestOptions_),e.updateDuration(),e.tech_.paused()||(e.mainSegmentLoader_.load(),e.audioSegmentLoader_&&e.audioSegmentLoader_.load()),!t.endList){var n=function(){var t=e.seekable();0!==t.length&&e.mediaSource.addSeekableRange_(t.start(0),t.end(0))};if(e.duration()!==1/0){e.tech_.one("durationchange",function t(){e.duration()===1/0?n():e.tech_.one("durationchange",t)})}else n()}}),this.masterPlaylistLoader_.on("error",function(){e.blacklistCurrentPlaylist(e.masterPlaylistLoader_.error)}),this.masterPlaylistLoader_.on("mediachanging",function(){e.mainSegmentLoader_.abort(),e.mainSegmentLoader_.pause()}),this.masterPlaylistLoader_.on("mediachange",function(){var t=e.masterPlaylistLoader_.media(),i=1.5*t.targetDuration*1e3;K(e.masterPlaylistLoader_.master,e.masterPlaylistLoader_.media())?e.requestOptions_.timeout=0:e.requestOptions_.timeout=i,e.mainSegmentLoader_.playlist(t,e.requestOptions_),e.mainSegmentLoader_.load(),e.tech_.trigger({type:"mediachange",bubbles:!0})}),this.masterPlaylistLoader_.on("playlistunchanged",function(){var t=e.masterPlaylistLoader_.media();e.stuckAtPlaylistEnd_(t)&&(e.blacklistCurrentPlaylist({message:"Playlist no longer updating."}),e.tech_.trigger("playliststuck"))}),this.masterPlaylistLoader_.on("renditiondisabled",function(){e.tech_.trigger({type:"usage",name:"hls-rendition-disabled"})}),this.masterPlaylistLoader_.on("renditionenabled",function(){e.tech_.trigger({type:"usage",name:"hls-rendition-enabled"})})}},{key:"triggerPresenceUsage_",value:function(e,t){var i=e.mediaGroups||{},n=!0,r=Object.keys(i.AUDIO);for(var a in i.AUDIO)for(var s in i.AUDIO[a]){i.AUDIO[a][s].uri||(n=!1)}n&&this.tech_.trigger({type:"usage",name:"hls-demuxed"}),Object.keys(i.SUBTITLES).length&&this.tech_.trigger({type:"usage",name:"hls-webvtt"}),ga.Playlist.isAes(t)&&this.tech_.trigger({type:"usage",name:"hls-aes"}),ga.Playlist.isFmp4(t)&&this.tech_.trigger({type:"usage",name:"hls-fmp4"}),r.length&&Object.keys(i.AUDIO[r[0]]).length>1&&this.tech_.trigger({type:"usage",name:"hls-alternate-audio"}),this.useCueTags_&&this.tech_.trigger({type:"usage",name:"hls-playlist-cue-tags"})}},{key:"setupSegmentLoaderListeners_",value:function(){var e=this;this.mainSegmentLoader_.on("bandwidthupdate",function(){var t=e.selectPlaylist(),i=e.masterPlaylistLoader_.media(),n=e.tech_.buffered(),r=n.length?n.end(n.length-1)-e.tech_.currentTime():0,a=e.bufferLowWaterLine();(!i.endList||e.duration()<Mi.MAX_BUFFER_LOW_WATER_LINE||t.attributes.BANDWIDTH<i.attributes.BANDWIDTH||r>=a)&&e.masterPlaylistLoader_.media(t),e.tech_.trigger("bandwidthupdate")}),this.mainSegmentLoader_.on("progress",function(){e.trigger("progress")}),this.mainSegmentLoader_.on("error",function(){e.blacklistCurrentPlaylist(e.mainSegmentLoader_.error())}),this.mainSegmentLoader_.on("syncinfoupdate",function(){e.onSyncInfoUpdate_()}),this.mainSegmentLoader_.on("timestampoffset",function(){e.tech_.trigger({type:"usage",name:"hls-timestamp-offset"})}),this.audioSegmentLoader_.on("syncinfoupdate",function(){e.onSyncInfoUpdate_()}),this.mainSegmentLoader_.on("ended",function(){e.onEndOfStream()}),this.mainSegmentLoader_.on("earlyabort",function(){e.blacklistCurrentPlaylist({message:"Aborted early because there isn't enough bandwidth to complete the request without rebuffering."},120)}),this.mainSegmentLoader_.on("reseteverything",function(){e.tech_.trigger("hls-reset")}),this.mainSegmentLoader_.on("segmenttimemapping",function(t){e.tech_.trigger({type:"hls-segment-time-mapping",mapping:t.mapping})}),this.audioSegmentLoader_.on("ended",function(){e.onEndOfStream()})}},{key:"mediaSecondsLoaded_",value:function(){return Math.max(this.audioSegmentLoader_.mediaSecondsLoaded+this.mainSegmentLoader_.mediaSecondsLoaded)}},{key:"load",value:function(){this.mainSegmentLoader_.load(),this.mediaTypes_.AUDIO.activePlaylistLoader&&this.audioSegmentLoader_.load(),this.mediaTypes_.SUBTITLES.activePlaylistLoader&&this.subtitleSegmentLoader_.load()}},{key:"smoothQualityChange_",value:function(){var e=this.selectPlaylist();e!==this.masterPlaylistLoader_.media()&&(this.masterPlaylistLoader_.media(e),this.mainSegmentLoader_.resetLoader())}},{key:"fastQualityChange_",value:function(){var e=this,i=this.selectPlaylist();i!==this.masterPlaylistLoader_.media()&&(this.masterPlaylistLoader_.media(i),this.mainSegmentLoader_.resetEverything(function(){t.browser.IE_VERSION||t.browser.IS_EDGE?e.tech_.setCurrentTime(e.tech_.currentTime()+.04):e.tech_.setCurrentTime(e.tech_.currentTime())}))}},{key:"play",value:function(){if(!this.setupFirstPlay()){this.tech_.ended()&&this.seekTo_(0),this.hasPlayed_()&&this.load();var e=this.tech_.seekable();return this.tech_.duration()===1/0&&this.tech_.currentTime()<e.start(0)?this.seekTo_(e.end(e.length-1)):void 0}}},{key:"setupFirstPlay",value:function(){var e=this,i=this.masterPlaylistLoader_.media();if(!i||this.tech_.paused()||this.hasPlayed_())return!1;if(!i.endList){var n=this.seekable();if(!n.length)return!1;if(t.browser.IE_VERSION&&0===this.tech_.readyState())return this.tech_.one("loadedmetadata",function(){e.trigger("firstplay"),e.seekTo_(n.end(0)),e.hasPlayed_=function(){return!0}}),!1;this.trigger("firstplay"),this.seekTo_(n.end(0))}return this.hasPlayed_=function(){return!0},this.load(),!0}},{key:"handleSourceOpen_",value:function(){try{this.setupSourceBuffers_()}catch(e){return t.log.warn("Failed to create Source Buffers",e),this.mediaSource.endOfStream("decode")}if(this.tech_.autoplay()){var e=this.tech_.play();void 0!==e&&"function"==typeof e.then&&e.then(null,function(e){})}this.trigger("sourceopen")}},{key:"onEndOfStream",value:function(){var e=this.mainSegmentLoader_.ended_;if(this.mediaTypes_.AUDIO.activePlaylistLoader&&(e=!this.mainSegmentLoader_.startingMedia_||this.mainSegmentLoader_.startingMedia_.containsVideo?e&&this.audioSegmentLoader_.ended_:this.audioSegmentLoader_.ended_),e){this.logger_("calling mediaSource.endOfStream()");try{this.mediaSource.endOfStream()}catch(e){t.log.warn("Failed to call media source endOfStream",e)}}}},{key:"stuckAtPlaylistEnd_",value:function(e){if(!this.seekable().length)return!1;var t=this.syncController_.getExpiredTime(e,this.mediaSource.duration);if(null===t)return!1;var i=ga.Playlist.playlistEnd(e,t),n=this.tech_.currentTime(),r=this.tech_.buffered();if(!r.length)return i-n<=.1;var a=r.end(r.length-1);return a-n<=.1&&i-a<=.1}},{key:"blacklistCurrentPlaylist",value:function(){var e,i=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},n=arguments[1],r=void 0;if(r=i.playlist||this.masterPlaylistLoader_.media(),n=n||i.blacklistDuration||this.blacklistDuration,!r){this.error=i;try{return this.mediaSource.endOfStream("network")}catch(e){return this.trigger("error")}}var a=1===this.masterPlaylistLoader_.master.playlists.filter(Y).length;return a?(t.log.warn("Problem encountered with the current HLS playlist. Trying again since it is the final playlist."),this.tech_.trigger("retryplaylist"),this.masterPlaylistLoader_.load(a)):(r.excludeUntil=Date.now()+1e3*n,this.tech_.trigger("blacklistplaylist"),this.tech_.trigger({type:"usage",name:"hls-rendition-blacklisted"}),e=this.selectPlaylist(),t.log.warn("Problem encountered with the current HLS playlist."+(i.message?" "+i.message:"")+" Switching to another playlist."),this.masterPlaylistLoader_.media(e))}},{key:"pauseLoading",value:function(){this.mainSegmentLoader_.pause(),this.mediaTypes_.AUDIO.activePlaylistLoader&&this.audioSegmentLoader_.pause(),this.mediaTypes_.SUBTITLES.activePlaylistLoader&&this.subtitleSegmentLoader_.pause()}},{key:"setCurrentTime",value:function(e){var t=Se(this.tech_.buffered(),e);return this.masterPlaylistLoader_&&this.masterPlaylistLoader_.media()&&this.masterPlaylistLoader_.media().segments?t&&t.length?e:(this.mainSegmentLoader_.resetEverything(),this.mainSegmentLoader_.abort(),this.mediaTypes_.AUDIO.activePlaylistLoader&&(this.audioSegmentLoader_.resetEverything(),this.audioSegmentLoader_.abort()),this.mediaTypes_.SUBTITLES.activePlaylistLoader&&(this.subtitleSegmentLoader_.resetEverything(),this.subtitleSegmentLoader_.abort()),void this.load()):0}},{key:"duration",value:function(){return this.masterPlaylistLoader_?this.mediaSource?this.mediaSource.duration:ga.Playlist.duration(this.masterPlaylistLoader_.media()):0}},{key:"seekable",value:function(){return this.seekable_}},{key:"onSyncInfoUpdate_",value:function(){var e=void 0,i=void 0;if(this.masterPlaylistLoader_){var n=this.masterPlaylistLoader_.media();if(n){var r=this.syncController_.getExpiredTime(n,this.mediaSource.duration);if(null!==r&&0!==(e=ga.Playlist.seekable(n,r)).length){if(this.mediaTypes_.AUDIO.activePlaylistLoader){if(n=this.mediaTypes_.AUDIO.activePlaylistLoader.media(),null===(r=this.syncController_.getExpiredTime(n,this.mediaSource.duration)))return;if(0===(i=ga.Playlist.seekable(n,r)).length)return}var a=void 0,s=void 0;this.seekable_&&this.seekable_.length&&(a=this.seekable_.end(0),s=this.seekable_.start(0)),i?i.start(0)>e.end(0)||e.start(0)>i.end(0)?this.seekable_=e:this.seekable_=t.createTimeRanges([[i.start(0)>e.start(0)?i.start(0):e.start(0),i.end(0)<e.end(0)?i.end(0):e.end(0)]]):this.seekable_=e,this.seekable_&&this.seekable_.length&&this.seekable_.end(0)===a&&this.seekable_.start(0)===s||(this.logger_("seekable updated ["+we(this.seekable_)+"]"),this.tech_.trigger("seekablechanged"))}}}}},{key:"updateDuration",value:function(){var e=this,i=this.mediaSource.duration,n=ga.Playlist.duration(this.masterPlaylistLoader_.media()),r=this.tech_.buffered(),a=function i(){e.logger_("Setting duration from "+e.mediaSource.duration+" => "+n);try{e.mediaSource.duration=n}catch(e){t.log.warn("Failed to set media source duration",e)}e.tech_.trigger("durationchange"),e.mediaSource.removeEventListener("sourceopen",i)};r.length>0&&(n=Math.max(n,r.end(r.length-1))),i!==n&&("open"!==this.mediaSource.readyState?this.mediaSource.addEventListener("sourceopen",a):a())}},{key:"dispose",value:function(){var e=this;this.decrypter_.terminate(),this.masterPlaylistLoader_.dispose(),this.mainSegmentLoader_.dispose(),["AUDIO","SUBTITLES"].forEach(function(t){var i=e.mediaTypes_[t].groups;for(var n in i)i[n].forEach(function(e){e.playlistLoader&&e.playlistLoader.dispose()})}),this.audioSegmentLoader_.dispose(),this.subtitleSegmentLoader_.dispose()}},{key:"master",value:function(){return this.masterPlaylistLoader_.master}},{key:"media",value:function(){return this.masterPlaylistLoader_.media()||this.initialMedia_}},{key:"setupSourceBuffers_",value:function(){var e,t=this.masterPlaylistLoader_.media();if(t&&"open"===this.mediaSource.readyState){if((e=ze(this.masterPlaylistLoader_.master,t)).length<1)return this.error="No compatible SourceBuffer configuration for the variant stream:"+t.resolvedUri,this.mediaSource.endOfStream("decode");this.configureLoaderMimeTypes_(e),this.excludeIncompatibleVariants_(t)}}},{key:"configureLoaderMimeTypes_",value:function(e){var i=e.length>1&&-1===e[0].indexOf(",")&&e[0]!==e[1]?new t.EventTarget:null;this.mainSegmentLoader_.mimeType(e[0],i),e[1]&&this.audioSegmentLoader_.mimeType(e[1],i)}},{key:"excludeUnsupportedVariants_",value:function(){this.master().playlists.forEach(function(e){var t;e.attributes.CODECS&&h.MediaSource&&h.MediaSource.isTypeSupported&&!h.MediaSource.isTypeSupported('video/mp4; codecs="'+(t=e.attributes.CODECS,t.replace(/avc1\.(\d+)\.(\d+)/i,function(e){return Ve([e])[0]}))+'"')&&(e.excludeUntil=1/0)})}},{key:"excludeIncompatibleVariants_",value:function(e){var t=2,i=null,n=void 0;e.attributes.CODECS&&(n=He(e.attributes.CODECS),i=n.videoCodec,t=n.codecCount),this.master().playlists.forEach(function(e){var n={codecCount:2,videoCodec:null};e.attributes.CODECS&&(n=He(e.attributes.CODECS)),n.codecCount!==t&&(e.excludeUntil=1/0),n.videoCodec!==i&&(e.excludeUntil=1/0)})}},{key:"updateAdCues_",value:function(e){var t=0,i=this.seekable();i.length&&(t=i.start(0)),function(e,t){var i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0;if(e.segments)for(var n=i,r=void 0,a=0;a<e.segments.length;a++){var s=e.segments[a];if(r||(r=jr(t,n+s.duration/2)),r){if("cueIn"in s){r.endTime=n,r.adEndTime=n,n+=s.duration,r=null;continue}if(n<r.endTime){n+=s.duration;continue}r.endTime+=s.duration}else if("cueOut"in s&&((r=new h.VTTCue(n,n+s.duration,s.cueOut)).adStartTime=n,r.adEndTime=n+parseFloat(s.cueOut),t.addCue(r)),"cueOutCont"in s){var o,u,d=s.cueOutCont.split("/").map(parseFloat),l=L(d,2);o=l[0],u=l[1],(r=new h.VTTCue(n,n+s.duration,"")).adStartTime=n-o,r.adEndTime=r.adStartTime+u,t.addCue(r)}n+=s.duration}}(e,this.cueTagsTrack_,t)}},{key:"goalBufferLength",value:function(){var e=this.tech_.currentTime(),t=Mi.GOAL_BUFFER_LENGTH,i=Mi.GOAL_BUFFER_LENGTH_RATE,n=Math.max(t,Mi.MAX_GOAL_BUFFER_LENGTH);return Math.min(t+e*i,n)}},{key:"bufferLowWaterLine",value:function(){var e=this.tech_.currentTime(),t=Mi.BUFFER_LOW_WATER_LINE,i=Mi.BUFFER_LOW_WATER_LINE_RATE,n=Math.max(t,Mi.MAX_BUFFER_LOW_WATER_LINE);return Math.min(t+e*i,n)}}]),i}(t.EventTarget),ba=function e(t,i,n){S(this,e);var r,a,s,o=t.masterPlaylistController_,u=o[(t.options_.smoothQualityChange?"smooth":"fast")+"QualityChange_"].bind(o);if(i.attributes.RESOLUTION){var d=i.attributes.RESOLUTION;this.width=d.width,this.height=d.height}this.bandwidth=i.attributes.BANDWIDTH,this.id=n,this.enabled=(r=t.playlists,a=i.uri,s=u,function(e){var t=r.master.playlists[a],i=X(t),n=Y(t);return void 0===e?n:(e?delete t.disabled:t.disabled=!0,e===n||i||(s(),e?r.trigger("renditionenabled"):r.trigger("renditiondisabled")),e)})},Ta=["seeking","seeked","pause","playing","error"],Sa=function(){function e(t){var i=this;S(this,e),this.tech_=t.tech,this.seekable=t.seekable,this.seekTo=t.seekTo,this.allowSeeksWithinUnsafeLiveWindow=t.allowSeeksWithinUnsafeLiveWindow,this.media=t.media,this.consecutiveUpdates=0,this.lastRecordedTime=null,this.timer_=null,this.checkCurrentTimeTimeout_=null,this.logger_=zt("PlaybackWatcher"),this.logger_("initialize");var n=function(){return i.monitorCurrentTime_()},r=function(){return i.techWaiting_()},a=function(){return i.cancelTimer_()},s=function(){return i.fixesBadSeeks_()};this.tech_.on("seekablechanged",s),this.tech_.on("waiting",r),this.tech_.on(Ta,a),this.tech_.on("canplay",n),this.dispose=function(){i.logger_("dispose"),i.tech_.off("seekablechanged",s),i.tech_.off("waiting",r),i.tech_.off(Ta,a),i.tech_.off("canplay",n),i.checkCurrentTimeTimeout_&&h.clearTimeout(i.checkCurrentTimeTimeout_),i.cancelTimer_()}}return k(e,[{key:"monitorCurrentTime_",value:function(){this.checkCurrentTime_(),this.checkCurrentTimeTimeout_&&h.clearTimeout(this.checkCurrentTimeTimeout_),this.checkCurrentTimeTimeout_=h.setTimeout(this.monitorCurrentTime_.bind(this),250)}},{key:"checkCurrentTime_",value:function(){if(this.tech_.seeking()&&this.fixesBadSeeks_())return this.consecutiveUpdates=0,void(this.lastRecordedTime=this.tech_.currentTime());if(!this.tech_.paused()&&!this.tech_.seeking()){var e=this.tech_.currentTime(),t=this.tech_.buffered();if(this.lastRecordedTime===e&&(!t.length||e+.1>=t.end(t.length-1)))return this.techWaiting_();this.consecutiveUpdates>=5&&e===this.lastRecordedTime?(this.consecutiveUpdates++,this.waiting_()):e===this.lastRecordedTime?this.consecutiveUpdates++:(this.consecutiveUpdates=0,this.lastRecordedTime=e)}}},{key:"cancelTimer_",value:function(){this.consecutiveUpdates=0,this.timer_&&(this.logger_("cancelTimer_"),clearTimeout(this.timer_)),this.timer_=null}},{key:"fixesBadSeeks_",value:function(){if(!this.tech_.seeking())return!1;var e=this.seekable(),t=this.tech_.currentTime(),i=void 0;this.afterSeekableWindow_(e,t,this.media(),this.allowSeeksWithinUnsafeLiveWindow)&&(i=e.end(e.length-1));this.beforeSeekableWindow_(e,t)&&(i=e.start(0)+.1);return void 0!==i&&(this.logger_("Trying to seek outside of seekable at time "+t+" with seekable range "+we(e)+". Seeking to "+i+"."),this.seekTo(i),!0)}},{key:"waiting_",value:function(){if(!this.techWaiting_()){var e=this.tech_.currentTime(),t=this.tech_.buffered(),i=Se(t,e);return i.length&&e+3<=i.end(0)?(this.cancelTimer_(),this.seekTo(e),this.logger_("Stopped at "+e+" while inside a buffered region ["+i.start(0)+" -> "+i.end(0)+"]. Attempting to resume playback by seeking to the current time."),void this.tech_.trigger({type:"usage",name:"hls-unknown-waiting"})):void 0}}},{key:"techWaiting_",value:function(){var e=this.seekable(),t=this.tech_.currentTime();if(this.tech_.seeking()&&this.fixesBadSeeks_())return!0;if(this.tech_.seeking()||null!==this.timer_)return!0;if(this.beforeSeekableWindow_(e,t)){var i=e.end(e.length-1);return this.logger_("Fell out of live window at time "+t+". Seeking to live point (seekable end) "+i),this.cancelTimer_(),this.seekTo(i),this.tech_.trigger({type:"usage",name:"hls-live-resync"}),!0}var n=this.tech_.buffered(),r=ke(n,t);if(this.videoUnderflow_(r,n,t))return this.cancelTimer_(),this.seekTo(t),this.tech_.trigger({type:"usage",name:"hls-video-underflow"}),!0;if(r.length>0){var a=r.start(0)-t;return this.logger_("Stopped at "+t+", setting timer for "+a+", seeking to "+r.start(0)),this.timer_=setTimeout(this.skipTheGap_.bind(this),1e3*a,t),!0}return!1}},{key:"afterSeekableWindow_",value:function(e,t,i){var n=arguments.length>3&&void 0!==arguments[3]&&arguments[3];if(!e.length)return!1;var r=e.end(e.length-1)+.1;return!i.endList&&n&&(r=e.end(e.length-1)+3*i.targetDuration),t>r}},{key:"beforeSeekableWindow_",value:function(e,t){return!!(e.length&&e.start(0)>0&&t<e.start(0)-.1)}},{key:"videoUnderflow_",value:function(e,t,i){if(0===e.length){var n=this.gapFromVideoUnderflow_(t,i);if(n)return this.logger_("Encountered a gap in video from "+n.start+" to "+n.end+". Seeking to current time "+i),!0}return!1}},{key:"skipTheGap_",value:function(e){var t=this.tech_.buffered(),i=this.tech_.currentTime(),n=ke(t,i);this.cancelTimer_(),0!==n.length&&i===e&&(this.logger_("skipTheGap_:","currentTime:",i,"scheduled currentTime:",e,"nextRange start:",n.start(0)),this.seekTo(n.start(0)+1/30),this.tech_.trigger({type:"usage",name:"hls-gap-skip"}))}},{key:"gapFromVideoUnderflow_",value:function(e,i){for(var n=function(e){if(e.length<2)return t.createTimeRanges();for(var i=[],n=1;n<e.length;n++){var r=e.end(n-1),a=e.start(n);i.push([r,a])}return t.createTimeRanges(i)}(e),r=0;r<n.length;r++){var a=n.start(r),s=n.end(r);if(i-a<4&&i-a>2)return{start:a,end:s}}return null}}]),e}(),ka={errorInterval:30,getSource:function(e){return e(this.tech({IWillNotUseThisInPlugins:!0}).currentSource_)}},wa=function(e){!function e(i,n){var r=0,a=0,s=t.mergeOptions(ka,n);i.ready(function(){i.trigger({type:"usage",name:"hls-error-reload-initialized"})});var o=function(){a&&i.currentTime(a)},u=function(e){null!==e&&void 0!==e&&(a=i.duration()!==1/0&&i.currentTime()||0,i.one("loadedmetadata",o),i.src(e),i.trigger({type:"usage",name:"hls-error-reload"}),i.play())},d=function(){if(Date.now()-r<1e3*s.errorInterval)i.trigger({type:"usage",name:"hls-error-reload-canceled"});else{if(s.getSource&&"function"==typeof s.getSource)return r=Date.now(),s.getSource.call(i,u);t.log.error("ERROR: reloadSourceOnError - The option getSource must be a function!")}},l=function e(){i.off("loadedmetadata",o),i.off("error",d),i.off("dispose",e)};i.on("error",d),i.on("dispose",l),i.reloadSourceOnError=function(t){l(),e(i,t)}}(this,e)};t.use("*",function(e){return{setSource:function(e,t){t(null,e)},setCurrentTime:function(t){return e.vhs&&e.currentSource().src===e.vhs.source_.src&&e.vhs.setCurrentTime(t),t},play:function(){e.vhs&&e.currentSource().src===e.vhs.source_.src&&e.vhs.setCurrentTime(e.tech_.currentTime())}}});var Ua={PlaylistLoader:x,Playlist:Q,Decrypter:he,AsyncStream:ue,decrypt:le,utils:_e,STANDARD_PLAYLIST_SELECTOR:function(){return function(e,t,i,n,r){var a=e.playlists.map(function(e){var t,i;return t=e.attributes.RESOLUTION&&e.attributes.RESOLUTION.width,i=e.attributes.RESOLUTION&&e.attributes.RESOLUTION.height,{bandwidth:e.attributes.BANDWIDTH||h.Number.MAX_VALUE,width:t,height:i,playlist:e}});$i(a,function(e,t){return e.bandwidth-t.bandwidth});var s=(a=a.filter(function(e){return!Q.isIncompatible(e.playlist)})).filter(function(e){return Q.isEnabled(e.playlist)});s.length||(s=a.filter(function(e){return!Q.isDisabled(e.playlist)}));var o=s.filter(function(e){return e.bandwidth*Mi.BANDWIDTH_VARIANCE<t}),u=o[o.length-1],d=o.filter(function(e){return e.bandwidth===u.bandwidth})[0];if(!1===r){var l=d||s[0]||a[0];return l?l.playlist:null}var c=o.filter(function(e){return e.width&&e.height});$i(c,function(e,t){return e.width-t.width});var f=c.filter(function(e){return e.width===i&&e.height===n});u=f[f.length-1];var p=f.filter(function(e){return e.bandwidth===u.bandwidth})[0],m=void 0,g=void 0,y=void 0;p||(g=(m=c.filter(function(e){return e.width>i||e.height>n})).filter(function(e){return e.width===m[0].width&&e.height===m[0].height}),u=g[g.length-1],y=g.filter(function(e){return e.bandwidth===u.bandwidth})[0]);var _=y||p||d||s[0]||a[0];return _?_.playlist:null}(this.playlists.master,this.systemBandwidth,parseInt(Yi(this.tech_.el(),"width"),10),parseInt(Yi(this.tech_.el(),"height"),10),this.limitRenditionByPlayerDimensions)},INITIAL_PLAYLIST_SELECTOR:function(){var e=this.playlists.master.playlists.filter(Q.isEnabled);return $i(e,function(e,t){return Ki(e,t)}),e.filter(function(e){return He(e.attributes.CODECS).videoCodec})[0]||null},comparePlaylistBandwidth:Ki,comparePlaylistResolution:function(e,t){var i=void 0,n=void 0;return e.attributes.RESOLUTION&&e.attributes.RESOLUTION.width&&(i=e.attributes.RESOLUTION.width),i=i||h.Number.MAX_VALUE,t.attributes.RESOLUTION&&t.attributes.RESOLUTION.width&&(n=t.attributes.RESOLUTION.width),i===(n=n||h.Number.MAX_VALUE)&&e.attributes.BANDWIDTH&&t.attributes.BANDWIDTH?e.attributes.BANDWIDTH-t.attributes.BANDWIDTH:i-n},xhr:ee()};["GOAL_BUFFER_LENGTH","MAX_GOAL_BUFFER_LENGTH","GOAL_BUFFER_LENGTH_RATE","BUFFER_LOW_WATER_LINE","MAX_BUFFER_LOW_WATER_LINE","BUFFER_LOW_WATER_LINE_RATE","BANDWIDTH_VARIANCE"].forEach(function(e){Object.defineProperty(Ua,e,{get:function(){return t.log.warn("using Hls."+e+" is UNSAFE be sure you know what you are doing"),Mi[e]},set:function(i){t.log.warn("using Hls."+e+" is UNSAFE be sure you know what you are doing"),"number"!=typeof i||i<0?t.log.warn("value of Hls."+e+" must be greater than or equal to 0"):Mi[e]=i}})});var La=function(e){if(/^(audio|video|application)\/(x-|vnd\.apple\.)?mpegurl/i.test(e))return"hls";return/^application\/dash\+xml/i.test(e)?"dash":null},Aa=function(e,t){for(var i=t.media(),n=-1,r=0;r<e.length;r++)if(e[r].id===i.uri){n=r;break}e.selectedIndex_=n,e.trigger({selectedIndex:n,type:"change"})};Ua.canPlaySource=function(){return t.log.warn("HLS is no longer a tech. Please remove it from your player's techOrder.")};var Ea=function(e,i,n){if(!e)return e;var r={};for(var a in e)r[a]={audioContentType:'audio/mp4; codecs="'+n.attributes.CODECS+'"',videoContentType:'video/mp4; codecs="'+i.attributes.CODECS+'"'},i.contentProtection&&i.contentProtection[a]&&i.contentProtection[a].pssh&&(r[a].pssh=i.contentProtection[a].pssh),"string"==typeof e[a]&&(r[a].url=e[a]);return t.mergeOptions(e,r)},Oa=function(){if(!window.localStorage)return null;var e=window.localStorage.getItem("videojs-vhs");if(!e)return null;try{return JSON.parse(e)}catch(e){return null}};Ua.supportsNativeHls=function(){var e=d.createElement("video");if(!t.getTech("Html5").isSupported())return!1;return["application/vnd.apple.mpegurl","audio/mpegurl","audio/x-mpegurl","application/x-mpegurl","video/x-mpegurl","video/mpegurl","application/mpegurl"].some(function(t){return/maybe|probably/i.test(e.canPlayType(t))})}(),Ua.supportsNativeDash=!!t.getTech("Html5").isSupported()&&/maybe|probably/i.test(d.createElement("video").canPlayType("application/dash+xml")),Ua.supportsTypeNatively=function(e){return"hls"===e?Ua.supportsNativeHls:"dash"===e&&Ua.supportsNativeDash},Ua.isSupported=function(){return t.log.warn("HLS is no longer a tech. Please remove it from your player's techOrder.")};var Ia=t.getComponent("Component"),Ca=function(e){function i(e,n,r){S(this,i);var a=U(this,(i.__proto__||Object.getPrototypeOf(i)).call(this,n,r.hls));if(n.options_&&n.options_.playerId){var s=t(n.options_.playerId);s.hasOwnProperty("hls")||Object.defineProperty(s,"hls",{get:function(){return t.log.warn("player.hls is deprecated. Use player.tech().hls instead."),n.trigger({type:"usage",name:"hls-player-access"}),a},configurable:!0}),s.vhs=a,s.dash=a,a.player_=s}if(a.tech_=n,a.source_=e,a.stats={},a.setOptions_(),a.options_.overrideNative&&n.overrideNativeAudioTracks&&n.overrideNativeVideoTracks)n.overrideNativeAudioTracks(!0),n.overrideNativeVideoTracks(!0);else if(a.options_.overrideNative&&(n.featuresNativeVideoTracks||n.featuresNativeAudioTracks))throw new Error("Overriding native HLS requires emulated tracks. See https://git.io/vMpjB");return a.on(d,["fullscreenchange","webkitfullscreenchange","mozfullscreenchange","MSFullscreenChange"],function(e){var t=d.fullscreenElement||d.webkitFullscreenElement||d.mozFullScreenElement||d.msFullscreenElement;t&&t.contains(a.tech_.el())&&a.masterPlaylistController_.smoothQualityChange_()}),a.on(a.tech_,"seeking",function(){0===this.tech_.currentTime()&&this.tech_.player_.loop()&&this.setCurrentTime(0)}),a.on(a.tech_,"error",function(){this.masterPlaylistController_&&this.masterPlaylistController_.pauseLoading()}),a.on(a.tech_,"play",a.play),a}return w(i,Ia),k(i,[{key:"setOptions_",value:function(){var e=this;if(this.options_.withCredentials=this.options_.withCredentials||!1,this.options_.handleManifestRedirects=this.options_.handleManifestRedirects||!1,this.options_.limitRenditionByPlayerDimensions=!1!==this.options_.limitRenditionByPlayerDimensions,this.options_.smoothQualityChange=this.options_.smoothQualityChange||!1,this.options_.useBandwidthFromLocalStorage=void 0!==this.source_.useBandwidthFromLocalStorage?this.source_.useBandwidthFromLocalStorage:this.options_.useBandwidthFromLocalStorage||!1,this.options_.customTagParsers=this.options_.customTagParsers||[],this.options_.customTagMappers=this.options_.customTagMappers||[],"number"!=typeof this.options_.blacklistDuration&&(this.options_.blacklistDuration=300),"number"!=typeof this.options_.bandwidth&&this.options_.useBandwidthFromLocalStorage){var t=Oa();t&&t.bandwidth&&(this.options_.bandwidth=t.bandwidth,this.tech_.trigger({type:"usage",name:"hls-bandwidth-from-local-storage"})),t&&t.throughput&&(this.options_.throughput=t.throughput,this.tech_.trigger({type:"usage",name:"hls-throughput-from-local-storage"}))}"number"!=typeof this.options_.bandwidth&&(this.options_.bandwidth=Mi.INITIAL_BANDWIDTH),this.options_.enableLowInitialPlaylist=this.options_.enableLowInitialPlaylist&&this.options_.bandwidth===Mi.INITIAL_BANDWIDTH,["withCredentials","limitRenditionByPlayerDimensions","bandwidth","smoothQualityChange","customTagParsers","customTagMappers","handleManifestRedirects"].forEach(function(t){void 0!==e.source_[t]&&(e.options_[t]=e.source_[t])}),this.limitRenditionByPlayerDimensions=this.options_.limitRenditionByPlayerDimensions}},{key:"src",value:function(e,i){var n=this;e&&(this.setOptions_(),this.options_.url=this.source_.src,this.options_.tech=this.tech_,this.options_.externHls=Ua,this.options_.sourceType=La(i),this.options_.seekTo=function(e){n.tech_.setCurrentTime(e),n.setCurrentTime(e)},this.masterPlaylistController_=new va(this.options_),this.playbackWatcher_=new Sa(t.mergeOptions(this.options_,{seekable:function(){return n.seekable()},media:function(){return n.masterPlaylistController_.media()}})),this.masterPlaylistController_.on("error",function(){t.players[n.tech_.options_.playerId].error(n.masterPlaylistController_.error)}),this.masterPlaylistController_.selectPlaylist=this.selectPlaylist?this.selectPlaylist.bind(this):Ua.STANDARD_PLAYLIST_SELECTOR.bind(this),this.masterPlaylistController_.selectInitialPlaylist=Ua.INITIAL_PLAYLIST_SELECTOR.bind(this),this.playlists=this.masterPlaylistController_.masterPlaylistLoader_,this.mediaSource=this.masterPlaylistController_.mediaSource,Object.defineProperties(this,{selectPlaylist:{get:function(){return this.masterPlaylistController_.selectPlaylist},set:function(e){this.masterPlaylistController_.selectPlaylist=e.bind(this)}},throughput:{get:function(){return this.masterPlaylistController_.mainSegmentLoader_.throughput.rate},set:function(e){this.masterPlaylistController_.mainSegmentLoader_.throughput.rate=e,this.masterPlaylistController_.mainSegmentLoader_.throughput.count=1}},bandwidth:{get:function(){return this.masterPlaylistController_.mainSegmentLoader_.bandwidth},set:function(e){this.masterPlaylistController_.mainSegmentLoader_.bandwidth=e,this.masterPlaylistController_.mainSegmentLoader_.throughput={rate:0,count:0}}},systemBandwidth:{get:function(){var e=1/(this.bandwidth||1),t=void 0;return t=this.throughput>0?1/this.throughput:0,Math.floor(1/(e+t))},set:function(){t.log.error('The "systemBandwidth" property is read-only')}}}),this.options_.bandwidth&&(this.bandwidth=this.options_.bandwidth),this.options_.throughput&&(this.throughput=this.options_.throughput),Object.defineProperties(this.stats,{bandwidth:{get:function(){return n.bandwidth||0},enumerable:!0},mediaRequests:{get:function(){return n.masterPlaylistController_.mediaRequests_()||0},enumerable:!0},mediaRequestsAborted:{get:function(){return n.masterPlaylistController_.mediaRequestsAborted_()||0},enumerable:!0},mediaRequestsTimedout:{get:function(){return n.masterPlaylistController_.mediaRequestsTimedout_()||0},enumerable:!0},mediaRequestsErrored:{get:function(){return n.masterPlaylistController_.mediaRequestsErrored_()||0},enumerable:!0},mediaTransferDuration:{get:function(){return n.masterPlaylistController_.mediaTransferDuration_()||0},enumerable:!0},mediaBytesTransferred:{get:function(){return n.masterPlaylistController_.mediaBytesTransferred_()||0},enumerable:!0},mediaSecondsLoaded:{get:function(){return n.masterPlaylistController_.mediaSecondsLoaded_()||0},enumerable:!0},buffered:{get:function(){return Ue(n.tech_.buffered())},enumerable:!0},currentTime:{get:function(){return n.tech_.currentTime()},enumerable:!0},currentSource:{get:function(){return n.tech_.currentSource_},enumerable:!0},currentTech:{get:function(){return n.tech_.name_},enumerable:!0},duration:{get:function(){return n.tech_.duration()},enumerable:!0},master:{get:function(){return n.playlists.master},enumerable:!0},playerDimensions:{get:function(){return n.tech_.currentDimensions()},enumerable:!0},seekable:{get:function(){return Ue(n.tech_.seekable())},enumerable:!0},timestamp:{get:function(){return Date.now()},enumerable:!0},videoPlaybackQuality:{get:function(){return n.tech_.getVideoPlaybackQuality()},enumerable:!0}}),this.tech_.one("canplay",this.masterPlaylistController_.setupFirstPlay.bind(this.masterPlaylistController_)),this.tech_.on("bandwidthupdate",function(){n.options_.useBandwidthFromLocalStorage&&function(e){if(!window.localStorage)return!1;var i=Oa();i=i?t.mergeOptions(i,e):e;try{window.localStorage.setItem("videojs-vhs",JSON.stringify(i))}catch(e){return!1}}({bandwidth:n.bandwidth,throughput:Math.round(n.throughput)})}),this.masterPlaylistController_.on("selectedinitialmedia",function(){var e,i;i=(e=n).playlists,e.representations=function(){return i.master.playlists.filter(function(e){return!X(e)}).map(function(t,i){return new ba(e,t,t.uri)})},function(e){if("dash"===e.options_.sourceType){var i=t.players[e.tech_.options_.playerId];if(i.eme){var n=Ea(e.source_.keySystems,e.playlists.media(),e.masterPlaylistController_.mediaTypes_.AUDIO.activePlaylistLoader.media());n&&(i.currentSource().keySystems=n,i.eme.initializeMediaKeys&&i.eme.initializeMediaKeys())}}}(n)}),this.on(this.masterPlaylistController_,"progress",function(){this.tech_.trigger("progress")}),this.tech_.ready(function(){return n.setupQualityLevels_()}),this.tech_.el()&&this.tech_.src(t.URL.createObjectURL(this.masterPlaylistController_.mediaSource)))}},{key:"setupQualityLevels_",value:function(){var e=this,i=t.players[this.tech_.options_.playerId];i&&i.qualityLevels&&(this.qualityLevels_=i.qualityLevels(),this.masterPlaylistController_.on("selectedinitialmedia",function(){var t,i;t=e.qualityLevels_,(i=e).representations().forEach(function(e){t.addQualityLevel(e)}),Aa(t,i.playlists)}),this.playlists.on("mediachange",function(){Aa(e.qualityLevels_,e.playlists)}))}},{key:"play",value:function(){this.masterPlaylistController_.play()}},{key:"setCurrentTime",value:function(e){this.masterPlaylistController_.setCurrentTime(e)}},{key:"duration",value:function(){return this.masterPlaylistController_.duration()}},{key:"seekable",value:function(){return this.masterPlaylistController_.seekable()}},{key:"dispose",value:function(){this.playbackWatcher_&&this.playbackWatcher_.dispose(),this.masterPlaylistController_&&this.masterPlaylistController_.dispose(),this.qualityLevels_&&this.qualityLevels_.dispose(),this.player_&&(delete this.player_.vhs,delete this.player_.dash,delete this.player_.hls),this.tech_&&this.tech_.hls&&delete this.tech_.hls,function e(t,i,n){null===t&&(t=Function.prototype);var r=Object.getOwnPropertyDescriptor(t,i);if(void 0===r){var a=Object.getPrototypeOf(t);return null===a?void 0:e(a,i,n)}if("value"in r)return r.value;var s=r.get;return void 0!==s?s.call(n):void 0}(i.prototype.__proto__||Object.getPrototypeOf(i.prototype),"dispose",this).call(this)}},{key:"convertToProgramTime",value:function(e,t){return ve({playlist:this.masterPlaylistController_.media(),time:e,callback:t})}},{key:"seekToProgramTime",value:function(e,t){var i=!(arguments.length>2&&void 0!==arguments[2])||arguments[2],n=arguments.length>3&&void 0!==arguments[3]?arguments[3]:2;return be({programTime:e,playlist:this.masterPlaylistController_.media(),retryCount:n,pauseAfterSeek:i,seekTo:this.options_.seekTo,tech:this.options_.tech,callback:t})}}]),i}(),Pa={name:"videojs-http-streaming",VERSION:"1.9.3",canHandleSource:function(e){var i=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=t.mergeOptions(t.options,i);return Pa.canPlayType(e.type,n)},handleSource:function(e,i){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r=t.mergeOptions(t.options,n);return i.hls=new Ca(e,i,r),i.hls.xhr=ee(),i.hls.src(e.src,e.type),i.hls},canPlayType:function(e){var i=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=t.mergeOptions(t.options,i).hls.overrideNative,r=La(e);return r&&(!Ua.supportsTypeNatively(r)||n)?"maybe":""}};void 0!==t.MediaSource&&void 0!==t.URL||(t.MediaSource=et,t.URL=tt),et.supportsNativeMediaSources()&&t.getTech("Html5").registerSourceHandler(Pa,0),t.HlsHandler=Ca,t.HlsSourceHandler=Pa,t.Hls=Ua,t.use||t.registerComponent("Hls",Ua),t.options.hls=t.options.hls||{},t.registerPlugin?t.registerPlugin("reloadSourceOnError",wa):t.plugin("reloadSourceOnError",wa),e.LOCAL_STORAGE_KEY="videojs-vhs",e.Hls=Ua,e.HlsHandler=Ca,e.HlsSourceHandler=Pa,e.emeKeySystems=Ea,e.simpleTypeFromSourceType=La,Object.defineProperty(e,"__esModule",{value:!0})});
