"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _urlToolkit = _interopRequireDefault(require("url-toolkit"));

var _window = _interopRequireDefault(require("global/window"));

var resolveUrl = function resolveUrl(baseUrl, relativeUrl) {
  // return early if we don't need to resolve
  if (/^[a-z]+:/i.test(relativeUrl)) {
    return relativeUrl;
  } // if the base URL is relative then combine with the current location


  if (!/\/\//i.test(baseUrl)) {
    baseUrl = _urlToolkit.default.buildAbsoluteURL(_window.default.location && _window.default.location.href || '', baseUrl);
  }

  return _urlToolkit.default.buildAbsoluteURL(baseUrl, relativeUrl);
};

var _default = resolveUrl;
exports.default = _default;
module.exports = exports.default;