import { nextTick, openBlock, createElementBlock, createElementVNode, normalizeClass, normalizeStyle, renderSlot, withDirectives, vShow, resolveComponent, createBlock, Transition, withCtx, createVNode, createCommentVNode, resolveDynamicComponent, inject, withModifiers, toDisplayString, h, Teleport, mergeProps, getCurrentInstance, Fragment, renderList, createTextVNode, withKeys, vModelText, resolveDirective, vModelCheckbox, TransitionGroup, createApp, normalizeProps, guardReactiveProps, defineComponent, toHandlers, Comment, Text, setBlockTracking, createSlots } from "vue";
const isClient = typeof window !== "undefined";
const on = function() {
  if (isClient && document.addEventListener) {
    return function(element, event, handler, useCapture = false) {
      if (element && event && handler) {
        element.addEventListener(event, handler, useCapture);
      }
    };
  } else {
    return function(element, event, handler) {
      if (element && event && handler) {
        element.attachEvent("on" + event, handler);
      }
    };
  }
}();
const off = function() {
  if (isClient && document.removeEventListener) {
    return function(element, event, handler, useCapture = false) {
      if (element && event) {
        element.removeEventListener(event, handler, useCapture);
      }
    };
  } else {
    return function(element, event, handler) {
      if (element && event) {
        element.detachEvent("on" + event, handler);
      }
    };
  }
}();
var _export_sfc = (sfc, props) => {
  const target = sfc.__vccOpts || sfc;
  for (const [key2, val] of props) {
    target[key2] = val;
  }
  return target;
};
const prefixCls$1m = "ivu-affix";
function getScroll(target, top2) {
  const prop2 = top2 ? "pageYOffset" : "pageXOffset";
  const method3 = top2 ? "scrollTop" : "scrollLeft";
  let ret = target[prop2];
  if (isClient && typeof ret !== "number") {
    ret = window.document.documentElement[method3];
  }
  return ret;
}
function getOffset(element) {
  if (!isClient)
    return;
  const rect = element.getBoundingClientRect();
  const scrollTop2 = getScroll(window, true);
  const scrollLeft = getScroll(window);
  const docEl = window.document.body;
  const clientTop = docEl.clientTop || 0;
  const clientLeft = docEl.clientLeft || 0;
  return {
    top: rect.top + scrollTop2 - clientTop,
    left: rect.left + scrollLeft - clientLeft
  };
}
const _sfc_main$2v = {
  name: "Affix",
  emits: ["on-change"],
  props: {
    offsetTop: {
      type: Number,
      default: 0
    },
    offsetBottom: {
      type: Number
    },
    useCapture: {
      type: Boolean,
      default: false
    }
  },
  data() {
    return {
      affix: false,
      styles: {},
      slot: false,
      slotStyle: {}
    };
  },
  computed: {
    offsetType() {
      let type2 = "top";
      if (this.offsetBottom >= 0) {
        type2 = "bottom";
      }
      return type2;
    },
    classes() {
      return [
        {
          [`${prefixCls$1m}`]: this.affix
        }
      ];
    }
  },
  mounted() {
    on(window, "scroll", this.handleScroll, this.useCapture);
    on(window, "resize", this.handleScroll, this.useCapture);
    nextTick(() => {
      this.handleScroll();
    });
  },
  beforeUnmount() {
    off(window, "scroll", this.handleScroll, this.useCapture);
    off(window, "resize", this.handleScroll, this.useCapture);
  },
  methods: {
    handleScroll() {
      if (!isClient)
        return;
      const affix = this.affix;
      const scrollTop2 = getScroll(window, true);
      const elOffset = getOffset(this.$el);
      const windowHeight = window.innerHeight;
      const elHeight = this.$el.getElementsByTagName("div")[0].offsetHeight;
      if (elOffset.top - this.offsetTop < scrollTop2 && this.offsetType == "top" && !affix) {
        this.affix = true;
        this.slotStyle = {
          width: this.$refs.point.clientWidth + "px",
          height: this.$refs.point.clientHeight + "px"
        };
        this.slot = true;
        this.styles = {
          top: `${this.offsetTop}px`,
          left: `${elOffset.left}px`,
          width: `${this.$el.offsetWidth}px`
        };
        this.$emit("on-change", true);
      } else if (elOffset.top - this.offsetTop > scrollTop2 && this.offsetType == "top" && affix) {
        this.slot = false;
        this.slotStyle = {};
        this.affix = false;
        this.styles = null;
        this.$emit("on-change", false);
      }
      if (elOffset.top + this.offsetBottom + elHeight > scrollTop2 + windowHeight && this.offsetType == "bottom" && !affix) {
        this.affix = true;
        this.styles = {
          bottom: `${this.offsetBottom}px`,
          left: `${elOffset.left}px`,
          width: `${this.$el.offsetWidth}px`
        };
        this.$emit("on-change", true);
      } else if (elOffset.top + this.offsetBottom + elHeight < scrollTop2 + windowHeight && this.offsetType == "bottom" && affix) {
        this.affix = false;
        this.styles = null;
        this.$emit("on-change", false);
      }
    }
  }
};
function _sfc_render$2e(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", null, [
    createElementVNode("div", {
      ref: "point",
      class: normalizeClass($options.classes),
      style: normalizeStyle($data.styles)
    }, [
      renderSlot(_ctx.$slots, "default")
    ], 6),
    withDirectives(createElementVNode("div", {
      style: normalizeStyle($data.slotStyle)
    }, null, 4), [
      [vShow, $data.slot]
    ])
  ]);
}
var Affix = /* @__PURE__ */ _export_sfc(_sfc_main$2v, [["render", _sfc_render$2e]]);
const prefixCls$1l = "ivu-icon";
const _sfc_main$2u = {
  name: "Icon",
  props: {
    type: {
      type: String,
      default: ""
    },
    size: [Number, String],
    color: String,
    custom: {
      type: String,
      default: ""
    }
  },
  computed: {
    classes() {
      return [
        `${prefixCls$1l}`,
        {
          [`${prefixCls$1l}-${this.type}`]: this.type !== "",
          [`${this.custom}`]: this.custom !== ""
        }
      ];
    },
    styles() {
      let style2 = {};
      if (this.size)
        style2["font-size"] = `${this.size}px`;
      if (this.color)
        style2.color = this.color;
      return style2;
    }
  }
};
function _sfc_render$2d(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("i", {
    class: normalizeClass($options.classes),
    style: normalizeStyle($options.styles)
  }, null, 6);
}
var Icon = /* @__PURE__ */ _export_sfc(_sfc_main$2u, [["render", _sfc_render$2d]]);
function oneOf(value, validList) {
  for (let i = 0; i < validList.length; i++) {
    if (value === validList[i]) {
      return true;
    }
  }
  return false;
}
let cached;
function getScrollBarSize(fresh) {
  if (isClient && (fresh || cached === void 0)) {
    const inner = document.createElement("div");
    inner.style.width = "100%";
    inner.style.height = "200px";
    const outer = document.createElement("div");
    const outerStyle = outer.style;
    outerStyle.position = "absolute";
    outerStyle.top = 0;
    outerStyle.left = 0;
    outerStyle.pointerEvents = "none";
    outerStyle.visibility = "hidden";
    outerStyle.width = "200px";
    outerStyle.height = "150px";
    outerStyle.overflow = "hidden";
    outer.appendChild(inner);
    document.body.appendChild(outer);
    const widthContained = inner.offsetWidth;
    outer.style.overflow = "scroll";
    let widthScroll = inner.offsetWidth;
    if (widthContained === widthScroll) {
      widthScroll = outer.clientWidth;
    }
    document.body.removeChild(outer);
    cached = widthContained - widthScroll;
  }
  return cached;
}
const MutationObserver = isClient ? window.MutationObserver || window.WebKitMutationObserver || window.MozMutationObserver || false : false;
const SPECIAL_CHARS_REGEXP = /([\:\-\_]+(.))/g;
const MOZ_HACK_REGEXP = /^moz([A-Z])/;
function camelCase(name2) {
  return name2.replace(SPECIAL_CHARS_REGEXP, function(_, separator, letter, offset) {
    return offset ? letter.toUpperCase() : letter;
  }).replace(MOZ_HACK_REGEXP, "Moz$1");
}
function getStyle(element, styleName) {
  if (!isClient)
    return;
  if (!element || !styleName)
    return null;
  styleName = camelCase(styleName);
  if (styleName === "float") {
    styleName = "cssFloat";
  }
  try {
    const computed = document.defaultView.getComputedStyle(element, "");
    return element.style[styleName] || computed ? computed[styleName] : null;
  } catch (e) {
    return element.style[styleName];
  }
}
function firstUpperCase(str) {
  return str.toString()[0].toUpperCase() + str.toString().slice(1);
}
function typeOf(obj) {
  const toString2 = Object.prototype.toString;
  const map = {
    "[object Boolean]": "boolean",
    "[object Number]": "number",
    "[object String]": "string",
    "[object Function]": "function",
    "[object Array]": "array",
    "[object Date]": "date",
    "[object RegExp]": "regExp",
    "[object Undefined]": "undefined",
    "[object Null]": "null",
    "[object Object]": "object"
  };
  return map[toString2.call(obj)];
}
function deepCopy(data) {
  const t2 = typeOf(data);
  let o;
  if (t2 === "array") {
    o = [];
  } else if (t2 === "object") {
    o = {};
  } else {
    return data;
  }
  if (t2 === "array") {
    for (let i = 0; i < data.length; i++) {
      o.push(deepCopy(data[i]));
    }
  } else if (t2 === "object") {
    for (let i in data) {
      o[i] = deepCopy(data[i]);
    }
  }
  return o;
}
function scrollTop(el, from = 0, to, duration2 = 500, endCallback) {
  if (!isClient)
    return;
  if (!window.requestAnimationFrame) {
    window.requestAnimationFrame = window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.msRequestAnimationFrame || function(callback) {
      return window.setTimeout(callback, 1e3 / 60);
    };
  }
  const difference = Math.abs(from - to);
  const step = Math.ceil(difference / duration2 * 50);
  function scroll2(start, end, step2) {
    if (start === end) {
      endCallback && endCallback();
      return;
    }
    let d = start + step2 > end ? end : start + step2;
    if (start > end) {
      d = start - step2 < end ? end : start - step2;
    }
    if (el === window) {
      window.scrollTo(d, d);
    } else {
      el.scrollTop = d;
    }
    window.requestAnimationFrame(() => scroll2(d, end, step2));
  }
  scroll2(from, to, step);
}
function findComponentUpward(context, componentName, componentNames) {
  if (typeof componentName === "string") {
    componentNames = [componentName];
  } else {
    componentNames = componentName;
  }
  let parent = context.$parent;
  let name2 = parent.$options.name;
  while (parent && (!name2 || componentNames.indexOf(name2) < 0)) {
    parent = parent.$parent;
    if (parent)
      name2 = parent.$options.name;
  }
  return parent;
}
function findComponentsUpward(context, componentName) {
  let parents = [];
  const parent = context.$parent;
  if (parent) {
    if (parent.$options.name === componentName)
      parents.push(parent);
    return parents.concat(findComponentsUpward(parent, componentName));
  } else {
    return [];
  }
}
const trim = function(string2) {
  return (string2 || "").replace(/^[\s\uFEFF]+|[\s\uFEFF]+$/g, "");
};
function hasClass(el, cls) {
  if (!el || !cls)
    return false;
  if (cls.indexOf(" ") !== -1)
    throw new Error("className should not contain space.");
  if (el.classList) {
    return el.classList.contains(cls);
  } else {
    return (" " + el.className + " ").indexOf(" " + cls + " ") > -1;
  }
}
function addClass(el, cls) {
  if (!el)
    return;
  let curClass = el.className;
  const classes = (cls || "").split(" ");
  for (let i = 0, j = classes.length; i < j; i++) {
    const clsName = classes[i];
    if (!clsName)
      continue;
    if (el.classList) {
      el.classList.add(clsName);
    } else {
      if (!hasClass(el, clsName)) {
        curClass += " " + clsName;
      }
    }
  }
  if (!el.classList) {
    el.className = curClass;
  }
}
function removeClass(el, cls) {
  if (!el || !cls)
    return;
  const classes = cls.split(" ");
  let curClass = " " + el.className + " ";
  for (let i = 0, j = classes.length; i < j; i++) {
    const clsName = classes[i];
    if (!clsName)
      continue;
    if (el.classList) {
      el.classList.remove(clsName);
    } else {
      if (hasClass(el, clsName)) {
        curClass = curClass.replace(" " + clsName + " ", " ");
      }
    }
  }
  if (!el.classList) {
    el.className = trim(curClass);
  }
}
const dimensionMap = {
  xs: "480px",
  sm: "576px",
  md: "768px",
  lg: "992px",
  xl: "1200px",
  xxl: "1600px"
};
function setMatchMedia() {
  if (!isClient)
    return;
  const matchMediaPolyfill = (mediaQuery) => {
    return {
      media: mediaQuery,
      matches: false,
      on() {
      },
      off() {
      }
    };
  };
  window.matchMedia = window.matchMedia || matchMediaPolyfill;
}
const sharpMatcherRegx = /#([^#]+)$/;
async function downloadFile(url2, name2 = "unnamed") {
  if (!isClient)
    return Promise.reject();
  try {
    const res = await fetch(url2);
    const blob = await res.blob();
    if (!blob)
      return Promise.reject();
    const localUrl = URL.createObjectURL(blob);
    const a = document.createElement("a");
    a.setAttribute("href", localUrl);
    a.setAttribute("download", name2);
    a.click();
    URL.revokeObjectURL(localUrl);
    return Promise.resolve();
  } catch (e) {
    return Promise.reject(e);
  }
}
const prefixCls$1k = "ivu-alert";
const _sfc_main$2t = {
  name: "Alert",
  components: { Icon },
  props: {
    type: {
      validator(value) {
        return oneOf(value, ["success", "info", "warning", "error"]);
      },
      default: "info"
    },
    closable: {
      type: Boolean,
      default: false
    },
    showIcon: {
      type: Boolean,
      default: false
    },
    banner: {
      type: Boolean,
      default: false
    },
    fade: {
      type: Boolean,
      default: true
    }
  },
  data() {
    return {
      closed: false,
      desc: false
    };
  },
  computed: {
    wrapClasses() {
      return [
        `${prefixCls$1k}`,
        `${prefixCls$1k}-${this.type}`,
        {
          [`${prefixCls$1k}-with-icon`]: this.showIcon,
          [`${prefixCls$1k}-with-desc`]: this.desc,
          [`${prefixCls$1k}-with-banner`]: this.banner
        }
      ];
    },
    messageClasses() {
      return `${prefixCls$1k}-message`;
    },
    descClasses() {
      return `${prefixCls$1k}-desc`;
    },
    closeClasses() {
      return `${prefixCls$1k}-close`;
    },
    iconClasses() {
      return `${prefixCls$1k}-icon`;
    },
    iconType() {
      let type2 = "";
      switch (this.type) {
        case "success":
          type2 = "ios-checkmark-circle";
          break;
        case "info":
          type2 = "ios-information-circle";
          break;
        case "warning":
          type2 = "ios-alert";
          break;
        case "error":
          type2 = "ios-close-circle";
          break;
      }
      if (this.desc)
        type2 += "-outline";
      return type2;
    }
  },
  methods: {
    close(e) {
      this.closed = true;
      this.$emit("on-close", e);
    }
  },
  mounted() {
    this.desc = this.$slots.desc !== void 0;
  }
};
function _sfc_render$2c(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = resolveComponent("Icon");
  return openBlock(), createBlock(Transition, {
    name: $props.fade ? "fade" : ""
  }, {
    default: withCtx(() => [
      !$data.closed ? (openBlock(), createElementBlock("div", {
        key: 0,
        class: normalizeClass($options.wrapClasses)
      }, [
        $props.showIcon ? (openBlock(), createElementBlock("span", {
          key: 0,
          class: normalizeClass($options.iconClasses)
        }, [
          renderSlot(_ctx.$slots, "icon", {}, () => [
            createVNode(_component_Icon, { type: $options.iconType }, null, 8, ["type"])
          ])
        ], 2)) : createCommentVNode("", true),
        createElementVNode("span", {
          class: normalizeClass($options.messageClasses)
        }, [
          renderSlot(_ctx.$slots, "default")
        ], 2),
        createElementVNode("span", {
          class: normalizeClass($options.descClasses)
        }, [
          renderSlot(_ctx.$slots, "desc")
        ], 2),
        $props.closable ? (openBlock(), createElementBlock("a", {
          key: 1,
          class: normalizeClass($options.closeClasses),
          onClick: _cache[0] || (_cache[0] = (...args) => $options.close && $options.close(...args))
        }, [
          renderSlot(_ctx.$slots, "close", {}, () => [
            createVNode(_component_Icon, { type: "ios-close" })
          ])
        ], 2)) : createCommentVNode("", true)
      ], 2)) : createCommentVNode("", true)
    ]),
    _: 3
  }, 8, ["name"]);
}
var Alert = /* @__PURE__ */ _export_sfc(_sfc_main$2t, [["render", _sfc_render$2c]]);
const _sfc_main$2s = {
  name: "Anchor",
  provide() {
    return {
      AnchorInstance: this
    };
  },
  emits: ["on-change", "on-select"],
  props: {
    affix: {
      type: Boolean,
      default: true
    },
    offsetTop: {
      type: Number,
      default: 0
    },
    offsetBottom: Number,
    bounds: {
      type: Number,
      default: 5
    },
    container: null,
    showInk: {
      type: Boolean,
      default: false
    },
    scrollOffset: {
      type: Number,
      default: 0
    }
  },
  data() {
    return {
      prefix: "ivu-anchor",
      isAffixed: false,
      inkTop: 0,
      animating: false,
      currentLink: "",
      currentId: "",
      scrollContainer: null,
      scrollElement: null,
      wrapperTop: 0,
      upperFirstTitle: true,
      links: []
    };
  },
  computed: {
    wrapperComponent() {
      return this.affix ? "Affix" : "div";
    },
    wrapperStyle() {
      return {
        maxHeight: this.offsetTop ? `calc(100vh - ${this.offsetTop}px)` : "100vh"
      };
    },
    containerIsWindow() {
      return this.scrollContainer === window;
    },
    titlesOffsetArr() {
      const links = this.links.map((item) => {
        return item.link.href;
      });
      const idArr = links.map((link) => {
        return link.split("#")[1];
      });
      let offsetArr = [];
      isClient && idArr.forEach((id) => {
        const titleEle = document.getElementById(id);
        if (titleEle)
          offsetArr.push({
            link: `#${id}`,
            offset: titleEle.offsetTop - this.scrollElement.offsetTop
          });
      });
      return offsetArr;
    }
  },
  methods: {
    handleAffixStateChange(state) {
      this.isAffixed = this.affix && state;
    },
    handleScroll(e) {
      this.upperFirstTitle = !!this.titlesOffsetArr[0] && e.target.scrollTop < this.titlesOffsetArr[0].offset;
      if (this.animating)
        return;
      const scrollTop2 = isClient ? document.documentElement.scrollTop || document.body.scrollTop || e.target.scrollTop : 0;
      this.getCurrentScrollAtTitleId(scrollTop2);
    },
    handleHashChange() {
      if (!isClient)
        return;
      const url2 = window.location.href;
      const sharpLinkMatch = sharpMatcherRegx.exec(url2);
      if (!sharpLinkMatch)
        return;
      this.currentLink = sharpLinkMatch[0];
      this.currentId = sharpLinkMatch[1];
    },
    handleScrollTo() {
      if (!isClient)
        return;
      const anchor = document.getElementById(this.currentId);
      const currentLinkElementA = document.querySelector(`a[data-href="${this.currentLink}"]`);
      let offset = this.scrollOffset;
      if (currentLinkElementA) {
        offset = parseFloat(currentLinkElementA.getAttribute("data-scroll-offset"));
      }
      if (!anchor)
        return;
      const offsetTop = anchor.offsetTop - this.wrapperTop - offset;
      this.animating = true;
      scrollTop(this.scrollContainer, this.scrollElement.scrollTop, offsetTop, 600, () => {
        this.animating = false;
      });
      this.handleSetInkTop();
    },
    handleSetInkTop() {
      if (!isClient)
        return;
      const currentLinkElementA = document.querySelector(`a[data-href="${this.currentLink}"]`);
      if (!currentLinkElementA)
        return;
      const elementATop = currentLinkElementA.offsetTop;
      const top2 = elementATop < 0 ? this.offsetTop : elementATop;
      this.inkTop = top2;
    },
    getCurrentScrollAtTitleId(scrollTop2) {
      let i = -1;
      let len = this.titlesOffsetArr.length;
      let titleItem = {
        link: "#",
        offset: 0
      };
      scrollTop2 += this.bounds;
      while (++i < len) {
        let currentEle = this.titlesOffsetArr[i];
        let nextEle = this.titlesOffsetArr[i + 1];
        if (scrollTop2 >= currentEle.offset && scrollTop2 < (nextEle && nextEle.offset || Infinity)) {
          titleItem = this.titlesOffsetArr[i];
          break;
        }
      }
      this.currentLink = titleItem.link;
      this.handleSetInkTop();
    },
    getContainer() {
      if (!isClient)
        return;
      this.scrollContainer = this.container ? typeof this.container === "string" ? document.querySelector(this.container) : this.container : window;
      this.scrollElement = this.container ? this.scrollContainer : document.documentElement || document.body;
    },
    removeListener() {
      off(this.scrollContainer, "scroll", this.handleScroll);
      off(window, "hashchange", this.handleHashChange);
    },
    init() {
      this.handleHashChange();
      nextTick(() => {
        this.removeListener();
        this.getContainer();
        this.wrapperTop = this.containerIsWindow ? 0 : this.scrollElement.offsetTop;
        this.handleScrollTo();
        this.handleSetInkTop();
        if (this.titlesOffsetArr[0]) {
          this.upperFirstTitle = this.scrollElement.scrollTop < this.titlesOffsetArr[0].offset;
        }
        on(this.scrollContainer, "scroll", this.handleScroll);
        on(window, "hashchange", this.handleHashChange);
      });
    },
    addLink(id, link) {
      this.links.push({ id, link });
    },
    removeLink(id) {
      const linkIndex = this.links.findIndex((item) => item.id === id);
      this.links.splice(linkIndex, 1);
    }
  },
  watch: {
    "$route"() {
      this.currentLink = "";
      this.currentId = "";
      this.handleHashChange();
      nextTick(() => {
        this.handleScrollTo();
      });
    },
    container() {
      this.init();
    },
    currentLink(newHref, oldHref) {
      this.$emit("on-change", newHref, oldHref);
    }
  },
  mounted() {
    this.init();
  },
  beforeUnmount() {
    this.removeListener();
  }
};
function _sfc_render$2b(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createBlock(resolveDynamicComponent($options.wrapperComponent), {
    "offset-top": $props.offsetTop,
    "offset-bottom": $props.offsetBottom,
    onOnChange: $options.handleAffixStateChange
  }, {
    default: withCtx(() => [
      createElementVNode("div", {
        class: normalizeClass(`${$data.prefix}-wrapper`),
        style: normalizeStyle($options.wrapperStyle)
      }, [
        createElementVNode("div", {
          class: normalizeClass(`${$data.prefix}`)
        }, [
          createElementVNode("div", {
            class: normalizeClass(`${$data.prefix}-ink`)
          }, [
            withDirectives(createElementVNode("span", {
              class: normalizeClass(`${$data.prefix}-ink-ball`),
              style: normalizeStyle({ top: `${$data.inkTop}px` })
            }, null, 6), [
              [vShow, $props.showInk]
            ])
          ], 2),
          renderSlot(_ctx.$slots, "default")
        ], 2)
      ], 6)
    ]),
    _: 3
  }, 40, ["offset-top", "offset-bottom", "onOnChange"]);
}
var Anchor = /* @__PURE__ */ _export_sfc(_sfc_main$2s, [["render", _sfc_render$2b]]);
function random(len = 32) {
  const $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
  const maxPos = $chars.length;
  let str = "";
  for (let i = 0; i < len; i++) {
    str += $chars.charAt(Math.floor(Math.random() * maxPos));
  }
  return str;
}
const _sfc_main$2r = {
  name: "AnchorLink",
  inject: ["AnchorInstance"],
  props: {
    href: String,
    title: String,
    scrollOffset: {
      type: Number,
      default() {
        return inject("AnchorInstance").scrollOffset;
      }
    }
  },
  data() {
    return {
      prefix: "ivu-anchor-link",
      id: random(6)
    };
  },
  computed: {
    anchorLinkClasses() {
      return [
        this.prefix,
        this.AnchorInstance.currentLink === this.href ? `${this.prefix}-active` : ""
      ];
    },
    linkTitleClasses() {
      return [
        `${this.prefix}-title`
      ];
    }
  },
  methods: {
    goAnchor() {
      this.currentLink = this.href;
      this.AnchorInstance.handleHashChange();
      this.AnchorInstance.handleScrollTo();
      this.AnchorInstance.$emit("on-select", this.href);
      const isRoute = this.$router;
      if (isRoute) {
        this.$router.push(this.href, () => {
        });
      } else {
        isClient && (window.location.href = this.href);
      }
    }
  },
  mounted() {
    this.AnchorInstance.addLink(this.id, this);
    nextTick(() => {
      this.AnchorInstance.init();
    });
  },
  beforeUnmount() {
    this.AnchorInstance.removeLink(this.id);
  }
};
const _hoisted_1$1h = ["href", "data-scroll-offset", "data-href", "title"];
function _sfc_render$2a(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.anchorLinkClasses)
  }, [
    createElementVNode("a", {
      class: normalizeClass($options.linkTitleClasses),
      href: $props.href,
      "data-scroll-offset": $props.scrollOffset,
      "data-href": $props.href,
      onClick: _cache[0] || (_cache[0] = withModifiers((...args) => $options.goAnchor && $options.goAnchor(...args), ["prevent"])),
      title: $props.title
    }, toDisplayString($props.title), 11, _hoisted_1$1h),
    renderSlot(_ctx.$slots, "default")
  ], 2);
}
var AnchorLink = /* @__PURE__ */ _export_sfc(_sfc_main$2r, [["render", _sfc_render$2a]]);
var mixinsLink = {
  props: {
    to: {
      type: [Object, String]
    },
    replace: {
      type: Boolean,
      default: false
    },
    target: {
      type: String,
      validator(value) {
        return oneOf(value, ["_blank", "_self", "_parent", "_top"]);
      },
      default: "_self"
    },
    append: {
      type: Boolean,
      required: false,
      default: false
    }
  },
  computed: {
    linkUrl() {
      const type2 = typeof this.to;
      if (type2 !== "string") {
        return null;
      }
      if (this.to.includes("//")) {
        return this.to;
      }
      const router = this.$router;
      if (router) {
        const current = this.$route;
        const route = router.resolve(this.to, current, this.append);
        return route ? route.href : this.to;
      }
      return this.to;
    }
  },
  methods: {
    handleOpenTo() {
      if (!isClient)
        return;
      const router = this.$router;
      let to = this.to;
      if (router) {
        const current = this.$route;
        const route = router.resolve(this.to, current, this.append);
        to = route ? route.href : this.to;
      }
      if (typeof this.to === "string")
        return;
      window.open(to);
    },
    handleClick(new_window = false) {
      const router = this.$router;
      if (!isClient)
        return;
      if (new_window) {
        this.handleOpenTo();
      } else {
        if (router) {
          if (typeof this.to === "string" && this.to.includes("//")) {
            window.location.href = this.to;
          } else {
            this.replace ? this.$router.replace(this.to, () => {
            }) : this.$router.push(this.to, () => {
            });
          }
        } else {
          window.location.href = this.to;
        }
      }
    },
    handleCheckClick(event, new_window = false) {
      if (this.to) {
        if (this.target === "_blank") {
          this.handleOpenTo();
          return false;
        } else {
          event.preventDefault();
          this.handleClick(new_window);
        }
      }
    }
  }
};
function includeArray(list1, list2) {
  let status = false;
  list2.forEach((item) => {
    if (list1.includes(item))
      status = true;
  });
  return status;
}
const _sfc_main$2q = {
  name: "Auth",
  mixins: [mixinsLink],
  emits: ["click"],
  props: {
    authority: {
      type: [String, Array, Function, Boolean],
      default: true
    },
    access: {
      type: [String, Array]
    },
    prevent: {
      type: Boolean,
      default: false
    },
    message: {
      type: String,
      default: "\u60A8\u6CA1\u6709\u6743\u9650\u8FDB\u884C\u6B64\u64CD\u4F5C"
    },
    customTip: {
      type: Boolean,
      default: false
    },
    display: {
      type: String
    }
  },
  computed: {
    isPermission() {
      let state;
      if (typeof this.authority === "boolean") {
        state = this.authority;
      } else if (this.authority instanceof Function) {
        state = this.authority();
      } else {
        const authority = typeof this.authority === "string" ? [this.authority] : this.authority;
        const access = typeof this.access === "string" ? [this.access] : this.access;
        state = includeArray(authority, access);
      }
      return state;
    },
    options() {
      let style2 = {};
      if (this.display)
        style2.display = this.display;
      return {
        class: {
          "ivu-auth": true,
          "ivu-auth-permission": this.isPermission,
          "ivu-auth-no-math": !this.isPermission,
          "ivu-auth-redirect": !this.isPermission && this.to,
          "ivu-auth-prevent": this.prevent
        },
        style: style2
      };
    }
  },
  render() {
    if (this.isPermission) {
      return h("div", this.options, this.$slots.default());
    } else {
      if (this.to) {
        return h("div", this.options);
      } else {
        if (this.prevent) {
          return h("div", Object.assign({}, this.options, {
            onClick: this.handlePreventClick
          }), [
            h("div", {
              class: "ivu-auth-prevent-no-match"
            }, this.$slots.default())
          ]);
        } else {
          return h("div", this.options, this.$slots.noMatch());
        }
      }
    }
  },
  methods: {
    handlePreventClick(event) {
      if (!this.isPermission) {
        if (!this.customTip) {
          this.$Message.info({
            content: this.message,
            duration: 3
          });
        }
        this.$emit("click", event);
      }
    }
  },
  created() {
    if (!this.isPermission && this.to) {
      this.handleClick(false);
    }
  }
};
var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
function commonjsRequire(path) {
  throw new Error('Could not dynamically require "' + path + '". Please configure the dynamicRequireTargets or/and ignoreDynamicRequires option of @rollup/plugin-commonjs appropriately for this require call to work.');
}
var popper = { exports: {} };
/**!
 * @fileOverview Kickass library to create and place poppers near their reference elements.
 * @version 1.16.1
 * @license
 * Copyright (c) 2016 Federico Zivolo and contributors
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
(function(module, exports) {
  (function(global2, factory) {
    module.exports = factory();
  })(commonjsGlobal, function() {
    var isBrowser = typeof window !== "undefined" && typeof document !== "undefined" && typeof navigator !== "undefined";
    var timeoutDuration = function() {
      var longerTimeoutBrowsers = ["Edge", "Trident", "Firefox"];
      for (var i = 0; i < longerTimeoutBrowsers.length; i += 1) {
        if (isBrowser && navigator.userAgent.indexOf(longerTimeoutBrowsers[i]) >= 0) {
          return 1;
        }
      }
      return 0;
    }();
    function microtaskDebounce(fn) {
      var called = false;
      return function() {
        if (called) {
          return;
        }
        called = true;
        window.Promise.resolve().then(function() {
          called = false;
          fn();
        });
      };
    }
    function taskDebounce(fn) {
      var scheduled = false;
      return function() {
        if (!scheduled) {
          scheduled = true;
          setTimeout(function() {
            scheduled = false;
            fn();
          }, timeoutDuration);
        }
      };
    }
    var supportsMicroTasks = isBrowser && window.Promise;
    var debounce2 = supportsMicroTasks ? microtaskDebounce : taskDebounce;
    function isFunction2(functionToCheck) {
      var getType2 = {};
      return functionToCheck && getType2.toString.call(functionToCheck) === "[object Function]";
    }
    function getStyleComputedProperty(element, property) {
      if (element.nodeType !== 1) {
        return [];
      }
      var window2 = element.ownerDocument.defaultView;
      var css = window2.getComputedStyle(element, null);
      return property ? css[property] : css;
    }
    function getParentNode(element) {
      if (element.nodeName === "HTML") {
        return element;
      }
      return element.parentNode || element.host;
    }
    function getScrollParent(element) {
      if (!element) {
        return document.body;
      }
      switch (element.nodeName) {
        case "HTML":
        case "BODY":
          return element.ownerDocument.body;
        case "#document":
          return element.body;
      }
      var _getStyleComputedProp = getStyleComputedProperty(element), overflow = _getStyleComputedProp.overflow, overflowX = _getStyleComputedProp.overflowX, overflowY = _getStyleComputedProp.overflowY;
      if (/(auto|scroll|overlay)/.test(overflow + overflowY + overflowX)) {
        return element;
      }
      return getScrollParent(getParentNode(element));
    }
    function getReferenceNode(reference) {
      return reference && reference.referenceNode ? reference.referenceNode : reference;
    }
    var isIE11 = isBrowser && !!(window.MSInputMethodContext && document.documentMode);
    var isIE10 = isBrowser && /MSIE 10/.test(navigator.userAgent);
    function isIE(version2) {
      if (version2 === 11) {
        return isIE11;
      }
      if (version2 === 10) {
        return isIE10;
      }
      return isIE11 || isIE10;
    }
    function getOffsetParent(element) {
      if (!element) {
        return document.documentElement;
      }
      var noOffsetParent = isIE(10) ? document.body : null;
      var offsetParent = element.offsetParent || null;
      while (offsetParent === noOffsetParent && element.nextElementSibling) {
        offsetParent = (element = element.nextElementSibling).offsetParent;
      }
      var nodeName = offsetParent && offsetParent.nodeName;
      if (!nodeName || nodeName === "BODY" || nodeName === "HTML") {
        return element ? element.ownerDocument.documentElement : document.documentElement;
      }
      if (["TH", "TD", "TABLE"].indexOf(offsetParent.nodeName) !== -1 && getStyleComputedProperty(offsetParent, "position") === "static") {
        return getOffsetParent(offsetParent);
      }
      return offsetParent;
    }
    function isOffsetContainer(element) {
      var nodeName = element.nodeName;
      if (nodeName === "BODY") {
        return false;
      }
      return nodeName === "HTML" || getOffsetParent(element.firstElementChild) === element;
    }
    function getRoot(node) {
      if (node.parentNode !== null) {
        return getRoot(node.parentNode);
      }
      return node;
    }
    function findCommonOffsetParent(element1, element2) {
      if (!element1 || !element1.nodeType || !element2 || !element2.nodeType) {
        return document.documentElement;
      }
      var order = element1.compareDocumentPosition(element2) & Node.DOCUMENT_POSITION_FOLLOWING;
      var start = order ? element1 : element2;
      var end = order ? element2 : element1;
      var range2 = document.createRange();
      range2.setStart(start, 0);
      range2.setEnd(end, 0);
      var commonAncestorContainer = range2.commonAncestorContainer;
      if (element1 !== commonAncestorContainer && element2 !== commonAncestorContainer || start.contains(end)) {
        if (isOffsetContainer(commonAncestorContainer)) {
          return commonAncestorContainer;
        }
        return getOffsetParent(commonAncestorContainer);
      }
      var element1root = getRoot(element1);
      if (element1root.host) {
        return findCommonOffsetParent(element1root.host, element2);
      } else {
        return findCommonOffsetParent(element1, getRoot(element2).host);
      }
    }
    function getScroll2(element) {
      var side = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : "top";
      var upperSide = side === "top" ? "scrollTop" : "scrollLeft";
      var nodeName = element.nodeName;
      if (nodeName === "BODY" || nodeName === "HTML") {
        var html = element.ownerDocument.documentElement;
        var scrollingElement = element.ownerDocument.scrollingElement || html;
        return scrollingElement[upperSide];
      }
      return element[upperSide];
    }
    function includeScroll(rect, element) {
      var subtract = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : false;
      var scrollTop2 = getScroll2(element, "top");
      var scrollLeft = getScroll2(element, "left");
      var modifier = subtract ? -1 : 1;
      rect.top += scrollTop2 * modifier;
      rect.bottom += scrollTop2 * modifier;
      rect.left += scrollLeft * modifier;
      rect.right += scrollLeft * modifier;
      return rect;
    }
    function getBordersSize(styles, axis) {
      var sideA = axis === "x" ? "Left" : "Top";
      var sideB = sideA === "Left" ? "Right" : "Bottom";
      return parseFloat(styles["border" + sideA + "Width"]) + parseFloat(styles["border" + sideB + "Width"]);
    }
    function getSize(axis, body, html, computedStyle) {
      return Math.max(body["offset" + axis], body["scroll" + axis], html["client" + axis], html["offset" + axis], html["scroll" + axis], isIE(10) ? parseInt(html["offset" + axis]) + parseInt(computedStyle["margin" + (axis === "Height" ? "Top" : "Left")]) + parseInt(computedStyle["margin" + (axis === "Height" ? "Bottom" : "Right")]) : 0);
    }
    function getWindowSizes(document2) {
      var body = document2.body;
      var html = document2.documentElement;
      var computedStyle = isIE(10) && getComputedStyle(html);
      return {
        height: getSize("Height", body, html, computedStyle),
        width: getSize("Width", body, html, computedStyle)
      };
    }
    var classCallCheck = function(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    };
    var createClass = function() {
      function defineProperties(target, props) {
        for (var i = 0; i < props.length; i++) {
          var descriptor = props[i];
          descriptor.enumerable = descriptor.enumerable || false;
          descriptor.configurable = true;
          if ("value" in descriptor)
            descriptor.writable = true;
          Object.defineProperty(target, descriptor.key, descriptor);
        }
      }
      return function(Constructor, protoProps, staticProps) {
        if (protoProps)
          defineProperties(Constructor.prototype, protoProps);
        if (staticProps)
          defineProperties(Constructor, staticProps);
        return Constructor;
      };
    }();
    var defineProperty = function(obj, key2, value) {
      if (key2 in obj) {
        Object.defineProperty(obj, key2, {
          value,
          enumerable: true,
          configurable: true,
          writable: true
        });
      } else {
        obj[key2] = value;
      }
      return obj;
    };
    var _extends2 = Object.assign || function(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];
        for (var key2 in source) {
          if (Object.prototype.hasOwnProperty.call(source, key2)) {
            target[key2] = source[key2];
          }
        }
      }
      return target;
    };
    function getClientRect(offsets) {
      return _extends2({}, offsets, {
        right: offsets.left + offsets.width,
        bottom: offsets.top + offsets.height
      });
    }
    function getBoundingClientRect(element) {
      var rect = {};
      try {
        if (isIE(10)) {
          rect = element.getBoundingClientRect();
          var scrollTop2 = getScroll2(element, "top");
          var scrollLeft = getScroll2(element, "left");
          rect.top += scrollTop2;
          rect.left += scrollLeft;
          rect.bottom += scrollTop2;
          rect.right += scrollLeft;
        } else {
          rect = element.getBoundingClientRect();
        }
      } catch (e) {
      }
      var result = {
        left: rect.left,
        top: rect.top,
        width: rect.right - rect.left,
        height: rect.bottom - rect.top
      };
      var sizes = element.nodeName === "HTML" ? getWindowSizes(element.ownerDocument) : {};
      var width = sizes.width || element.clientWidth || result.width;
      var height2 = sizes.height || element.clientHeight || result.height;
      var horizScrollbar = element.offsetWidth - width;
      var vertScrollbar = element.offsetHeight - height2;
      if (horizScrollbar || vertScrollbar) {
        var styles = getStyleComputedProperty(element);
        horizScrollbar -= getBordersSize(styles, "x");
        vertScrollbar -= getBordersSize(styles, "y");
        result.width -= horizScrollbar;
        result.height -= vertScrollbar;
      }
      return getClientRect(result);
    }
    function getOffsetRectRelativeToArbitraryNode(children, parent) {
      var fixedPosition = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : false;
      var isIE102 = isIE(10);
      var isHTML = parent.nodeName === "HTML";
      var childrenRect = getBoundingClientRect(children);
      var parentRect = getBoundingClientRect(parent);
      var scrollParent = getScrollParent(children);
      var styles = getStyleComputedProperty(parent);
      var borderTopWidth = parseFloat(styles.borderTopWidth);
      var borderLeftWidth = parseFloat(styles.borderLeftWidth);
      if (fixedPosition && isHTML) {
        parentRect.top = Math.max(parentRect.top, 0);
        parentRect.left = Math.max(parentRect.left, 0);
      }
      var offsets = getClientRect({
        top: childrenRect.top - parentRect.top - borderTopWidth,
        left: childrenRect.left - parentRect.left - borderLeftWidth,
        width: childrenRect.width,
        height: childrenRect.height
      });
      offsets.marginTop = 0;
      offsets.marginLeft = 0;
      if (!isIE102 && isHTML) {
        var marginTop = parseFloat(styles.marginTop);
        var marginLeft = parseFloat(styles.marginLeft);
        offsets.top -= borderTopWidth - marginTop;
        offsets.bottom -= borderTopWidth - marginTop;
        offsets.left -= borderLeftWidth - marginLeft;
        offsets.right -= borderLeftWidth - marginLeft;
        offsets.marginTop = marginTop;
        offsets.marginLeft = marginLeft;
      }
      if (isIE102 && !fixedPosition ? parent.contains(scrollParent) : parent === scrollParent && scrollParent.nodeName !== "BODY") {
        offsets = includeScroll(offsets, parent);
      }
      return offsets;
    }
    function getViewportOffsetRectRelativeToArtbitraryNode(element) {
      var excludeScroll = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : false;
      var html = element.ownerDocument.documentElement;
      var relativeOffset = getOffsetRectRelativeToArbitraryNode(element, html);
      var width = Math.max(html.clientWidth, window.innerWidth || 0);
      var height2 = Math.max(html.clientHeight, window.innerHeight || 0);
      var scrollTop2 = !excludeScroll ? getScroll2(html) : 0;
      var scrollLeft = !excludeScroll ? getScroll2(html, "left") : 0;
      var offset2 = {
        top: scrollTop2 - relativeOffset.top + relativeOffset.marginTop,
        left: scrollLeft - relativeOffset.left + relativeOffset.marginLeft,
        width,
        height: height2
      };
      return getClientRect(offset2);
    }
    function isFixed(element) {
      var nodeName = element.nodeName;
      if (nodeName === "BODY" || nodeName === "HTML") {
        return false;
      }
      if (getStyleComputedProperty(element, "position") === "fixed") {
        return true;
      }
      var parentNode = getParentNode(element);
      if (!parentNode) {
        return false;
      }
      return isFixed(parentNode);
    }
    function getFixedPositionOffsetParent(element) {
      if (!element || !element.parentElement || isIE()) {
        return document.documentElement;
      }
      var el = element.parentElement;
      while (el && getStyleComputedProperty(el, "transform") === "none") {
        el = el.parentElement;
      }
      return el || document.documentElement;
    }
    function getBoundaries(popper2, reference, padding, boundariesElement) {
      var fixedPosition = arguments.length > 4 && arguments[4] !== void 0 ? arguments[4] : false;
      var boundaries = { top: 0, left: 0 };
      var offsetParent = fixedPosition ? getFixedPositionOffsetParent(popper2) : findCommonOffsetParent(popper2, getReferenceNode(reference));
      if (boundariesElement === "viewport") {
        boundaries = getViewportOffsetRectRelativeToArtbitraryNode(offsetParent, fixedPosition);
      } else {
        var boundariesNode = void 0;
        if (boundariesElement === "scrollParent") {
          boundariesNode = getScrollParent(getParentNode(reference));
          if (boundariesNode.nodeName === "BODY") {
            boundariesNode = popper2.ownerDocument.documentElement;
          }
        } else if (boundariesElement === "window") {
          boundariesNode = popper2.ownerDocument.documentElement;
        } else {
          boundariesNode = boundariesElement;
        }
        var offsets = getOffsetRectRelativeToArbitraryNode(boundariesNode, offsetParent, fixedPosition);
        if (boundariesNode.nodeName === "HTML" && !isFixed(offsetParent)) {
          var _getWindowSizes = getWindowSizes(popper2.ownerDocument), height2 = _getWindowSizes.height, width = _getWindowSizes.width;
          boundaries.top += offsets.top - offsets.marginTop;
          boundaries.bottom = height2 + offsets.top;
          boundaries.left += offsets.left - offsets.marginLeft;
          boundaries.right = width + offsets.left;
        } else {
          boundaries = offsets;
        }
      }
      padding = padding || 0;
      var isPaddingNumber = typeof padding === "number";
      boundaries.left += isPaddingNumber ? padding : padding.left || 0;
      boundaries.top += isPaddingNumber ? padding : padding.top || 0;
      boundaries.right -= isPaddingNumber ? padding : padding.right || 0;
      boundaries.bottom -= isPaddingNumber ? padding : padding.bottom || 0;
      return boundaries;
    }
    function getArea(_ref) {
      var width = _ref.width, height2 = _ref.height;
      return width * height2;
    }
    function computeAutoPlacement(placement, refRect, popper2, reference, boundariesElement) {
      var padding = arguments.length > 5 && arguments[5] !== void 0 ? arguments[5] : 0;
      if (placement.indexOf("auto") === -1) {
        return placement;
      }
      var boundaries = getBoundaries(popper2, reference, padding, boundariesElement);
      var rects = {
        top: {
          width: boundaries.width,
          height: refRect.top - boundaries.top
        },
        right: {
          width: boundaries.right - refRect.right,
          height: boundaries.height
        },
        bottom: {
          width: boundaries.width,
          height: boundaries.bottom - refRect.bottom
        },
        left: {
          width: refRect.left - boundaries.left,
          height: boundaries.height
        }
      };
      var sortedAreas = Object.keys(rects).map(function(key2) {
        return _extends2({
          key: key2
        }, rects[key2], {
          area: getArea(rects[key2])
        });
      }).sort(function(a, b) {
        return b.area - a.area;
      });
      var filteredAreas = sortedAreas.filter(function(_ref2) {
        var width = _ref2.width, height2 = _ref2.height;
        return width >= popper2.clientWidth && height2 >= popper2.clientHeight;
      });
      var computedPlacement = filteredAreas.length > 0 ? filteredAreas[0].key : sortedAreas[0].key;
      var variation = placement.split("-")[1];
      return computedPlacement + (variation ? "-" + variation : "");
    }
    function getReferenceOffsets(state, popper2, reference) {
      var fixedPosition = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : null;
      var commonOffsetParent = fixedPosition ? getFixedPositionOffsetParent(popper2) : findCommonOffsetParent(popper2, getReferenceNode(reference));
      return getOffsetRectRelativeToArbitraryNode(reference, commonOffsetParent, fixedPosition);
    }
    function getOuterSizes(element) {
      var window2 = element.ownerDocument.defaultView;
      var styles = window2.getComputedStyle(element);
      var x = parseFloat(styles.marginTop || 0) + parseFloat(styles.marginBottom || 0);
      var y = parseFloat(styles.marginLeft || 0) + parseFloat(styles.marginRight || 0);
      var result = {
        width: element.offsetWidth + y,
        height: element.offsetHeight + x
      };
      return result;
    }
    function getOppositePlacement(placement) {
      var hash = { left: "right", right: "left", bottom: "top", top: "bottom" };
      return placement.replace(/left|right|bottom|top/g, function(matched) {
        return hash[matched];
      });
    }
    function getPopperOffsets(popper2, referenceOffsets, placement) {
      placement = placement.split("-")[0];
      var popperRect = getOuterSizes(popper2);
      var popperOffsets = {
        width: popperRect.width,
        height: popperRect.height
      };
      var isHoriz = ["right", "left"].indexOf(placement) !== -1;
      var mainSide = isHoriz ? "top" : "left";
      var secondarySide = isHoriz ? "left" : "top";
      var measurement = isHoriz ? "height" : "width";
      var secondaryMeasurement = !isHoriz ? "height" : "width";
      popperOffsets[mainSide] = referenceOffsets[mainSide] + referenceOffsets[measurement] / 2 - popperRect[measurement] / 2;
      if (placement === secondarySide) {
        popperOffsets[secondarySide] = referenceOffsets[secondarySide] - popperRect[secondaryMeasurement];
      } else {
        popperOffsets[secondarySide] = referenceOffsets[getOppositePlacement(secondarySide)];
      }
      return popperOffsets;
    }
    function find(arr, check) {
      if (Array.prototype.find) {
        return arr.find(check);
      }
      return arr.filter(check)[0];
    }
    function findIndex(arr, prop2, value) {
      if (Array.prototype.findIndex) {
        return arr.findIndex(function(cur) {
          return cur[prop2] === value;
        });
      }
      var match = find(arr, function(obj) {
        return obj[prop2] === value;
      });
      return arr.indexOf(match);
    }
    function runModifiers(modifiers2, data, ends) {
      var modifiersToRun = ends === void 0 ? modifiers2 : modifiers2.slice(0, findIndex(modifiers2, "name", ends));
      modifiersToRun.forEach(function(modifier) {
        if (modifier["function"]) {
          console.warn("`modifier.function` is deprecated, use `modifier.fn`!");
        }
        var fn = modifier["function"] || modifier.fn;
        if (modifier.enabled && isFunction2(fn)) {
          data.offsets.popper = getClientRect(data.offsets.popper);
          data.offsets.reference = getClientRect(data.offsets.reference);
          data = fn(data, modifier);
        }
      });
      return data;
    }
    function update2() {
      if (this.state.isDestroyed) {
        return;
      }
      var data = {
        instance: this,
        styles: {},
        arrowStyles: {},
        attributes: {},
        flipped: false,
        offsets: {}
      };
      data.offsets.reference = getReferenceOffsets(this.state, this.popper, this.reference, this.options.positionFixed);
      data.placement = computeAutoPlacement(this.options.placement, data.offsets.reference, this.popper, this.reference, this.options.modifiers.flip.boundariesElement, this.options.modifiers.flip.padding);
      data.originalPlacement = data.placement;
      data.positionFixed = this.options.positionFixed;
      data.offsets.popper = getPopperOffsets(this.popper, data.offsets.reference, data.placement);
      data.offsets.popper.position = this.options.positionFixed ? "fixed" : "absolute";
      data = runModifiers(this.modifiers, data);
      if (!this.state.isCreated) {
        this.state.isCreated = true;
        this.options.onCreate(data);
      } else {
        this.options.onUpdate(data);
      }
    }
    function isModifierEnabled(modifiers2, modifierName) {
      return modifiers2.some(function(_ref) {
        var name2 = _ref.name, enabled = _ref.enabled;
        return enabled && name2 === modifierName;
      });
    }
    function getSupportedPropertyName(property) {
      var prefixes = [false, "ms", "Webkit", "Moz", "O"];
      var upperProp = property.charAt(0).toUpperCase() + property.slice(1);
      for (var i = 0; i < prefixes.length; i++) {
        var prefix = prefixes[i];
        var toCheck = prefix ? "" + prefix + upperProp : property;
        if (typeof document.body.style[toCheck] !== "undefined") {
          return toCheck;
        }
      }
      return null;
    }
    function destroy() {
      this.state.isDestroyed = true;
      if (isModifierEnabled(this.modifiers, "applyStyle")) {
        this.popper.removeAttribute("x-placement");
        this.popper.style.position = "";
        this.popper.style.top = "";
        this.popper.style.left = "";
        this.popper.style.right = "";
        this.popper.style.bottom = "";
        this.popper.style.willChange = "";
        this.popper.style[getSupportedPropertyName("transform")] = "";
      }
      this.disableEventListeners();
      if (this.options.removeOnDestroy) {
        this.popper.parentNode.removeChild(this.popper);
      }
      return this;
    }
    function getWindow(element) {
      var ownerDocument = element.ownerDocument;
      return ownerDocument ? ownerDocument.defaultView : window;
    }
    function attachToScrollParents(scrollParent, event, callback, scrollParents) {
      var isBody = scrollParent.nodeName === "BODY";
      var target = isBody ? scrollParent.ownerDocument.defaultView : scrollParent;
      target.addEventListener(event, callback, { passive: true });
      if (!isBody) {
        attachToScrollParents(getScrollParent(target.parentNode), event, callback, scrollParents);
      }
      scrollParents.push(target);
    }
    function setupEventListeners(reference, options, state, updateBound) {
      state.updateBound = updateBound;
      getWindow(reference).addEventListener("resize", state.updateBound, { passive: true });
      var scrollElement = getScrollParent(reference);
      attachToScrollParents(scrollElement, "scroll", state.updateBound, state.scrollParents);
      state.scrollElement = scrollElement;
      state.eventsEnabled = true;
      return state;
    }
    function enableEventListeners() {
      if (!this.state.eventsEnabled) {
        this.state = setupEventListeners(this.reference, this.options, this.state, this.scheduleUpdate);
      }
    }
    function removeEventListeners(reference, state) {
      getWindow(reference).removeEventListener("resize", state.updateBound);
      state.scrollParents.forEach(function(target) {
        target.removeEventListener("scroll", state.updateBound);
      });
      state.updateBound = null;
      state.scrollParents = [];
      state.scrollElement = null;
      state.eventsEnabled = false;
      return state;
    }
    function disableEventListeners() {
      if (this.state.eventsEnabled) {
        cancelAnimationFrame(this.scheduleUpdate);
        this.state = removeEventListeners(this.reference, this.state);
      }
    }
    function isNumeric(n) {
      return n !== "" && !isNaN(parseFloat(n)) && isFinite(n);
    }
    function setStyles(element, styles) {
      Object.keys(styles).forEach(function(prop2) {
        var unit2 = "";
        if (["width", "height", "top", "right", "bottom", "left"].indexOf(prop2) !== -1 && isNumeric(styles[prop2])) {
          unit2 = "px";
        }
        element.style[prop2] = styles[prop2] + unit2;
      });
    }
    function setAttributes(element, attributes) {
      Object.keys(attributes).forEach(function(prop2) {
        var value = attributes[prop2];
        if (value !== false) {
          element.setAttribute(prop2, attributes[prop2]);
        } else {
          element.removeAttribute(prop2);
        }
      });
    }
    function applyStyle(data) {
      setStyles(data.instance.popper, data.styles);
      setAttributes(data.instance.popper, data.attributes);
      if (data.arrowElement && Object.keys(data.arrowStyles).length) {
        setStyles(data.arrowElement, data.arrowStyles);
      }
      return data;
    }
    function applyStyleOnLoad(reference, popper2, options, modifierOptions, state) {
      var referenceOffsets = getReferenceOffsets(state, popper2, reference, options.positionFixed);
      var placement = computeAutoPlacement(options.placement, referenceOffsets, popper2, reference, options.modifiers.flip.boundariesElement, options.modifiers.flip.padding);
      popper2.setAttribute("x-placement", placement);
      setStyles(popper2, { position: options.positionFixed ? "fixed" : "absolute" });
      return options;
    }
    function getRoundedOffsets(data, shouldRound) {
      var _data$offsets = data.offsets, popper2 = _data$offsets.popper, reference = _data$offsets.reference;
      var round = Math.round, floor = Math.floor;
      var noRound = function noRound2(v) {
        return v;
      };
      var referenceWidth = round(reference.width);
      var popperWidth = round(popper2.width);
      var isVertical = ["left", "right"].indexOf(data.placement) !== -1;
      var isVariation = data.placement.indexOf("-") !== -1;
      var sameWidthParity = referenceWidth % 2 === popperWidth % 2;
      var bothOddWidth = referenceWidth % 2 === 1 && popperWidth % 2 === 1;
      var horizontalToInteger = !shouldRound ? noRound : isVertical || isVariation || sameWidthParity ? round : floor;
      var verticalToInteger = !shouldRound ? noRound : round;
      return {
        left: horizontalToInteger(bothOddWidth && !isVariation && shouldRound ? popper2.left - 1 : popper2.left),
        top: verticalToInteger(popper2.top),
        bottom: verticalToInteger(popper2.bottom),
        right: horizontalToInteger(popper2.right)
      };
    }
    var isFirefox = isBrowser && /Firefox/i.test(navigator.userAgent);
    function computeStyle(data, options) {
      var x = options.x, y = options.y;
      var popper2 = data.offsets.popper;
      var legacyGpuAccelerationOption = find(data.instance.modifiers, function(modifier) {
        return modifier.name === "applyStyle";
      }).gpuAcceleration;
      if (legacyGpuAccelerationOption !== void 0) {
        console.warn("WARNING: `gpuAcceleration` option moved to `computeStyle` modifier and will not be supported in future versions of Popper.js!");
      }
      var gpuAcceleration = legacyGpuAccelerationOption !== void 0 ? legacyGpuAccelerationOption : options.gpuAcceleration;
      var offsetParent = getOffsetParent(data.instance.popper);
      var offsetParentRect = getBoundingClientRect(offsetParent);
      var styles = {
        position: popper2.position
      };
      var offsets = getRoundedOffsets(data, window.devicePixelRatio < 2 || !isFirefox);
      var sideA = x === "bottom" ? "top" : "bottom";
      var sideB = y === "right" ? "left" : "right";
      var prefixedProperty = getSupportedPropertyName("transform");
      var left = void 0, top2 = void 0;
      if (sideA === "bottom") {
        if (offsetParent.nodeName === "HTML") {
          top2 = -offsetParent.clientHeight + offsets.bottom;
        } else {
          top2 = -offsetParentRect.height + offsets.bottom;
        }
      } else {
        top2 = offsets.top;
      }
      if (sideB === "right") {
        if (offsetParent.nodeName === "HTML") {
          left = -offsetParent.clientWidth + offsets.right;
        } else {
          left = -offsetParentRect.width + offsets.right;
        }
      } else {
        left = offsets.left;
      }
      if (gpuAcceleration && prefixedProperty) {
        styles[prefixedProperty] = "translate3d(" + left + "px, " + top2 + "px, 0)";
        styles[sideA] = 0;
        styles[sideB] = 0;
        styles.willChange = "transform";
      } else {
        var invertTop = sideA === "bottom" ? -1 : 1;
        var invertLeft = sideB === "right" ? -1 : 1;
        styles[sideA] = top2 * invertTop;
        styles[sideB] = left * invertLeft;
        styles.willChange = sideA + ", " + sideB;
      }
      var attributes = {
        "x-placement": data.placement
      };
      data.attributes = _extends2({}, attributes, data.attributes);
      data.styles = _extends2({}, styles, data.styles);
      data.arrowStyles = _extends2({}, data.offsets.arrow, data.arrowStyles);
      return data;
    }
    function isModifierRequired(modifiers2, requestingName, requestedName) {
      var requesting = find(modifiers2, function(_ref) {
        var name2 = _ref.name;
        return name2 === requestingName;
      });
      var isRequired = !!requesting && modifiers2.some(function(modifier) {
        return modifier.name === requestedName && modifier.enabled && modifier.order < requesting.order;
      });
      if (!isRequired) {
        var _requesting = "`" + requestingName + "`";
        var requested = "`" + requestedName + "`";
        console.warn(requested + " modifier is required by " + _requesting + " modifier in order to work, be sure to include it before " + _requesting + "!");
      }
      return isRequired;
    }
    function arrow(data, options) {
      var _data$offsets$arrow;
      if (!isModifierRequired(data.instance.modifiers, "arrow", "keepTogether")) {
        return data;
      }
      var arrowElement = options.element;
      if (typeof arrowElement === "string") {
        arrowElement = data.instance.popper.querySelector(arrowElement);
        if (!arrowElement) {
          return data;
        }
      } else {
        if (!data.instance.popper.contains(arrowElement)) {
          console.warn("WARNING: `arrow.element` must be child of its popper element!");
          return data;
        }
      }
      var placement = data.placement.split("-")[0];
      var _data$offsets = data.offsets, popper2 = _data$offsets.popper, reference = _data$offsets.reference;
      var isVertical = ["left", "right"].indexOf(placement) !== -1;
      var len = isVertical ? "height" : "width";
      var sideCapitalized = isVertical ? "Top" : "Left";
      var side = sideCapitalized.toLowerCase();
      var altSide = isVertical ? "left" : "top";
      var opSide = isVertical ? "bottom" : "right";
      var arrowElementSize = getOuterSizes(arrowElement)[len];
      if (reference[opSide] - arrowElementSize < popper2[side]) {
        data.offsets.popper[side] -= popper2[side] - (reference[opSide] - arrowElementSize);
      }
      if (reference[side] + arrowElementSize > popper2[opSide]) {
        data.offsets.popper[side] += reference[side] + arrowElementSize - popper2[opSide];
      }
      data.offsets.popper = getClientRect(data.offsets.popper);
      var center = reference[side] + reference[len] / 2 - arrowElementSize / 2;
      var css = getStyleComputedProperty(data.instance.popper);
      var popperMarginSide = parseFloat(css["margin" + sideCapitalized]);
      var popperBorderSide = parseFloat(css["border" + sideCapitalized + "Width"]);
      var sideValue = center - data.offsets.popper[side] - popperMarginSide - popperBorderSide;
      sideValue = Math.max(Math.min(popper2[len] - arrowElementSize, sideValue), 0);
      data.arrowElement = arrowElement;
      data.offsets.arrow = (_data$offsets$arrow = {}, defineProperty(_data$offsets$arrow, side, Math.round(sideValue)), defineProperty(_data$offsets$arrow, altSide, ""), _data$offsets$arrow);
      return data;
    }
    function getOppositeVariation(variation) {
      if (variation === "end") {
        return "start";
      } else if (variation === "start") {
        return "end";
      }
      return variation;
    }
    var placements = ["auto-start", "auto", "auto-end", "top-start", "top", "top-end", "right-start", "right", "right-end", "bottom-end", "bottom", "bottom-start", "left-end", "left", "left-start"];
    var validPlacements = placements.slice(3);
    function clockwise(placement) {
      var counter = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : false;
      var index2 = validPlacements.indexOf(placement);
      var arr = validPlacements.slice(index2 + 1).concat(validPlacements.slice(0, index2));
      return counter ? arr.reverse() : arr;
    }
    var BEHAVIORS = {
      FLIP: "flip",
      CLOCKWISE: "clockwise",
      COUNTERCLOCKWISE: "counterclockwise"
    };
    function flip2(data, options) {
      if (isModifierEnabled(data.instance.modifiers, "inner")) {
        return data;
      }
      if (data.flipped && data.placement === data.originalPlacement) {
        return data;
      }
      var boundaries = getBoundaries(data.instance.popper, data.instance.reference, options.padding, options.boundariesElement, data.positionFixed);
      var placement = data.placement.split("-")[0];
      var placementOpposite = getOppositePlacement(placement);
      var variation = data.placement.split("-")[1] || "";
      var flipOrder = [];
      switch (options.behavior) {
        case BEHAVIORS.FLIP:
          flipOrder = [placement, placementOpposite];
          break;
        case BEHAVIORS.CLOCKWISE:
          flipOrder = clockwise(placement);
          break;
        case BEHAVIORS.COUNTERCLOCKWISE:
          flipOrder = clockwise(placement, true);
          break;
        default:
          flipOrder = options.behavior;
      }
      flipOrder.forEach(function(step, index2) {
        if (placement !== step || flipOrder.length === index2 + 1) {
          return data;
        }
        placement = data.placement.split("-")[0];
        placementOpposite = getOppositePlacement(placement);
        var popperOffsets = data.offsets.popper;
        var refOffsets = data.offsets.reference;
        var floor = Math.floor;
        var overlapsRef = placement === "left" && floor(popperOffsets.right) > floor(refOffsets.left) || placement === "right" && floor(popperOffsets.left) < floor(refOffsets.right) || placement === "top" && floor(popperOffsets.bottom) > floor(refOffsets.top) || placement === "bottom" && floor(popperOffsets.top) < floor(refOffsets.bottom);
        var overflowsLeft = floor(popperOffsets.left) < floor(boundaries.left);
        var overflowsRight = floor(popperOffsets.right) > floor(boundaries.right);
        var overflowsTop = floor(popperOffsets.top) < floor(boundaries.top);
        var overflowsBottom = floor(popperOffsets.bottom) > floor(boundaries.bottom);
        var overflowsBoundaries = placement === "left" && overflowsLeft || placement === "right" && overflowsRight || placement === "top" && overflowsTop || placement === "bottom" && overflowsBottom;
        var isVertical = ["top", "bottom"].indexOf(placement) !== -1;
        var flippedVariationByRef = !!options.flipVariations && (isVertical && variation === "start" && overflowsLeft || isVertical && variation === "end" && overflowsRight || !isVertical && variation === "start" && overflowsTop || !isVertical && variation === "end" && overflowsBottom);
        var flippedVariationByContent = !!options.flipVariationsByContent && (isVertical && variation === "start" && overflowsRight || isVertical && variation === "end" && overflowsLeft || !isVertical && variation === "start" && overflowsBottom || !isVertical && variation === "end" && overflowsTop);
        var flippedVariation = flippedVariationByRef || flippedVariationByContent;
        if (overlapsRef || overflowsBoundaries || flippedVariation) {
          data.flipped = true;
          if (overlapsRef || overflowsBoundaries) {
            placement = flipOrder[index2 + 1];
          }
          if (flippedVariation) {
            variation = getOppositeVariation(variation);
          }
          data.placement = placement + (variation ? "-" + variation : "");
          data.offsets.popper = _extends2({}, data.offsets.popper, getPopperOffsets(data.instance.popper, data.offsets.reference, data.placement));
          data = runModifiers(data.instance.modifiers, data, "flip");
        }
      });
      return data;
    }
    function keepTogether(data) {
      var _data$offsets = data.offsets, popper2 = _data$offsets.popper, reference = _data$offsets.reference;
      var placement = data.placement.split("-")[0];
      var floor = Math.floor;
      var isVertical = ["top", "bottom"].indexOf(placement) !== -1;
      var side = isVertical ? "right" : "bottom";
      var opSide = isVertical ? "left" : "top";
      var measurement = isVertical ? "width" : "height";
      if (popper2[side] < floor(reference[opSide])) {
        data.offsets.popper[opSide] = floor(reference[opSide]) - popper2[measurement];
      }
      if (popper2[opSide] > floor(reference[side])) {
        data.offsets.popper[opSide] = floor(reference[side]);
      }
      return data;
    }
    function toValue(str, measurement, popperOffsets, referenceOffsets) {
      var split = str.match(/((?:\-|\+)?\d*\.?\d*)(.*)/);
      var value = +split[1];
      var unit2 = split[2];
      if (!value) {
        return str;
      }
      if (unit2.indexOf("%") === 0) {
        var element = void 0;
        switch (unit2) {
          case "%p":
            element = popperOffsets;
            break;
          case "%":
          case "%r":
          default:
            element = referenceOffsets;
        }
        var rect = getClientRect(element);
        return rect[measurement] / 100 * value;
      } else if (unit2 === "vh" || unit2 === "vw") {
        var size = void 0;
        if (unit2 === "vh") {
          size = Math.max(document.documentElement.clientHeight, window.innerHeight || 0);
        } else {
          size = Math.max(document.documentElement.clientWidth, window.innerWidth || 0);
        }
        return size / 100 * value;
      } else {
        return value;
      }
    }
    function parseOffset(offset2, popperOffsets, referenceOffsets, basePlacement) {
      var offsets = [0, 0];
      var useHeight = ["right", "left"].indexOf(basePlacement) !== -1;
      var fragments = offset2.split(/(\+|\-)/).map(function(frag) {
        return frag.trim();
      });
      var divider = fragments.indexOf(find(fragments, function(frag) {
        return frag.search(/,|\s/) !== -1;
      }));
      if (fragments[divider] && fragments[divider].indexOf(",") === -1) {
        console.warn("Offsets separated by white space(s) are deprecated, use a comma (,) instead.");
      }
      var splitRegex = /\s*,\s*|\s+/;
      var ops = divider !== -1 ? [fragments.slice(0, divider).concat([fragments[divider].split(splitRegex)[0]]), [fragments[divider].split(splitRegex)[1]].concat(fragments.slice(divider + 1))] : [fragments];
      ops = ops.map(function(op, index2) {
        var measurement = (index2 === 1 ? !useHeight : useHeight) ? "height" : "width";
        var mergeWithPrevious = false;
        return op.reduce(function(a, b) {
          if (a[a.length - 1] === "" && ["+", "-"].indexOf(b) !== -1) {
            a[a.length - 1] = b;
            mergeWithPrevious = true;
            return a;
          } else if (mergeWithPrevious) {
            a[a.length - 1] += b;
            mergeWithPrevious = false;
            return a;
          } else {
            return a.concat(b);
          }
        }, []).map(function(str) {
          return toValue(str, measurement, popperOffsets, referenceOffsets);
        });
      });
      ops.forEach(function(op, index2) {
        op.forEach(function(frag, index22) {
          if (isNumeric(frag)) {
            offsets[index2] += frag * (op[index22 - 1] === "-" ? -1 : 1);
          }
        });
      });
      return offsets;
    }
    function offset(data, _ref) {
      var offset2 = _ref.offset;
      var placement = data.placement, _data$offsets = data.offsets, popper2 = _data$offsets.popper, reference = _data$offsets.reference;
      var basePlacement = placement.split("-")[0];
      var offsets = void 0;
      if (isNumeric(+offset2)) {
        offsets = [+offset2, 0];
      } else {
        offsets = parseOffset(offset2, popper2, reference, basePlacement);
      }
      if (basePlacement === "left") {
        popper2.top += offsets[0];
        popper2.left -= offsets[1];
      } else if (basePlacement === "right") {
        popper2.top += offsets[0];
        popper2.left += offsets[1];
      } else if (basePlacement === "top") {
        popper2.left += offsets[0];
        popper2.top -= offsets[1];
      } else if (basePlacement === "bottom") {
        popper2.left += offsets[0];
        popper2.top += offsets[1];
      }
      data.popper = popper2;
      return data;
    }
    function preventOverflow(data, options) {
      var boundariesElement = options.boundariesElement || getOffsetParent(data.instance.popper);
      if (data.instance.reference === boundariesElement) {
        boundariesElement = getOffsetParent(boundariesElement);
      }
      var transformProp = getSupportedPropertyName("transform");
      var popperStyles = data.instance.popper.style;
      var top2 = popperStyles.top, left = popperStyles.left, transform = popperStyles[transformProp];
      popperStyles.top = "";
      popperStyles.left = "";
      popperStyles[transformProp] = "";
      var boundaries = getBoundaries(data.instance.popper, data.instance.reference, options.padding, boundariesElement, data.positionFixed);
      popperStyles.top = top2;
      popperStyles.left = left;
      popperStyles[transformProp] = transform;
      options.boundaries = boundaries;
      var order = options.priority;
      var popper2 = data.offsets.popper;
      var check = {
        primary: function primary(placement) {
          var value = popper2[placement];
          if (popper2[placement] < boundaries[placement] && !options.escapeWithReference) {
            value = Math.max(popper2[placement], boundaries[placement]);
          }
          return defineProperty({}, placement, value);
        },
        secondary: function secondary(placement) {
          var mainSide = placement === "right" ? "left" : "top";
          var value = popper2[mainSide];
          if (popper2[placement] > boundaries[placement] && !options.escapeWithReference) {
            value = Math.min(popper2[mainSide], boundaries[placement] - (placement === "right" ? popper2.width : popper2.height));
          }
          return defineProperty({}, mainSide, value);
        }
      };
      order.forEach(function(placement) {
        var side = ["left", "top"].indexOf(placement) !== -1 ? "primary" : "secondary";
        popper2 = _extends2({}, popper2, check[side](placement));
      });
      data.offsets.popper = popper2;
      return data;
    }
    function shift(data) {
      var placement = data.placement;
      var basePlacement = placement.split("-")[0];
      var shiftvariation = placement.split("-")[1];
      if (shiftvariation) {
        var _data$offsets = data.offsets, reference = _data$offsets.reference, popper2 = _data$offsets.popper;
        var isVertical = ["bottom", "top"].indexOf(basePlacement) !== -1;
        var side = isVertical ? "left" : "top";
        var measurement = isVertical ? "width" : "height";
        var shiftOffsets = {
          start: defineProperty({}, side, reference[side]),
          end: defineProperty({}, side, reference[side] + reference[measurement] - popper2[measurement])
        };
        data.offsets.popper = _extends2({}, popper2, shiftOffsets[shiftvariation]);
      }
      return data;
    }
    function hide2(data) {
      if (!isModifierRequired(data.instance.modifiers, "hide", "preventOverflow")) {
        return data;
      }
      var refRect = data.offsets.reference;
      var bound = find(data.instance.modifiers, function(modifier) {
        return modifier.name === "preventOverflow";
      }).boundaries;
      if (refRect.bottom < bound.top || refRect.left > bound.right || refRect.top > bound.bottom || refRect.right < bound.left) {
        if (data.hide === true) {
          return data;
        }
        data.hide = true;
        data.attributes["x-out-of-boundaries"] = "";
      } else {
        if (data.hide === false) {
          return data;
        }
        data.hide = false;
        data.attributes["x-out-of-boundaries"] = false;
      }
      return data;
    }
    function inner(data) {
      var placement = data.placement;
      var basePlacement = placement.split("-")[0];
      var _data$offsets = data.offsets, popper2 = _data$offsets.popper, reference = _data$offsets.reference;
      var isHoriz = ["left", "right"].indexOf(basePlacement) !== -1;
      var subtractLength = ["top", "left"].indexOf(basePlacement) === -1;
      popper2[isHoriz ? "left" : "top"] = reference[basePlacement] - (subtractLength ? popper2[isHoriz ? "width" : "height"] : 0);
      data.placement = getOppositePlacement(placement);
      data.offsets.popper = getClientRect(popper2);
      return data;
    }
    var modifiers = {
      shift: {
        order: 100,
        enabled: true,
        fn: shift
      },
      offset: {
        order: 200,
        enabled: true,
        fn: offset,
        offset: 0
      },
      preventOverflow: {
        order: 300,
        enabled: true,
        fn: preventOverflow,
        priority: ["left", "right", "top", "bottom"],
        padding: 5,
        boundariesElement: "scrollParent"
      },
      keepTogether: {
        order: 400,
        enabled: true,
        fn: keepTogether
      },
      arrow: {
        order: 500,
        enabled: true,
        fn: arrow,
        element: "[x-arrow]"
      },
      flip: {
        order: 600,
        enabled: true,
        fn: flip2,
        behavior: "flip",
        padding: 5,
        boundariesElement: "viewport",
        flipVariations: false,
        flipVariationsByContent: false
      },
      inner: {
        order: 700,
        enabled: false,
        fn: inner
      },
      hide: {
        order: 800,
        enabled: true,
        fn: hide2
      },
      computeStyle: {
        order: 850,
        enabled: true,
        fn: computeStyle,
        gpuAcceleration: true,
        x: "bottom",
        y: "right"
      },
      applyStyle: {
        order: 900,
        enabled: true,
        fn: applyStyle,
        onLoad: applyStyleOnLoad,
        gpuAcceleration: void 0
      }
    };
    var Defaults = {
      placement: "bottom",
      positionFixed: false,
      eventsEnabled: true,
      removeOnDestroy: false,
      onCreate: function onCreate() {
      },
      onUpdate: function onUpdate() {
      },
      modifiers
    };
    var Popper2 = function() {
      function Popper3(reference, popper2) {
        var _this = this;
        var options = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
        classCallCheck(this, Popper3);
        this.scheduleUpdate = function() {
          return requestAnimationFrame(_this.update);
        };
        this.update = debounce2(this.update.bind(this));
        this.options = _extends2({}, Popper3.Defaults, options);
        this.state = {
          isDestroyed: false,
          isCreated: false,
          scrollParents: []
        };
        this.reference = reference && reference.jquery ? reference[0] : reference;
        this.popper = popper2 && popper2.jquery ? popper2[0] : popper2;
        this.options.modifiers = {};
        Object.keys(_extends2({}, Popper3.Defaults.modifiers, options.modifiers)).forEach(function(name2) {
          _this.options.modifiers[name2] = _extends2({}, Popper3.Defaults.modifiers[name2] || {}, options.modifiers ? options.modifiers[name2] : {});
        });
        this.modifiers = Object.keys(this.options.modifiers).map(function(name2) {
          return _extends2({
            name: name2
          }, _this.options.modifiers[name2]);
        }).sort(function(a, b) {
          return a.order - b.order;
        });
        this.modifiers.forEach(function(modifierOptions) {
          if (modifierOptions.enabled && isFunction2(modifierOptions.onLoad)) {
            modifierOptions.onLoad(_this.reference, _this.popper, _this.options, modifierOptions, _this.state);
          }
        });
        this.update();
        var eventsEnabled = this.options.eventsEnabled;
        if (eventsEnabled) {
          this.enableEventListeners();
        }
        this.state.eventsEnabled = eventsEnabled;
      }
      createClass(Popper3, [{
        key: "update",
        value: function update$$1() {
          return update2.call(this);
        }
      }, {
        key: "destroy",
        value: function destroy$$1() {
          return destroy.call(this);
        }
      }, {
        key: "enableEventListeners",
        value: function enableEventListeners$$1() {
          return enableEventListeners.call(this);
        }
      }, {
        key: "disableEventListeners",
        value: function disableEventListeners$$1() {
          return disableEventListeners.call(this);
        }
      }]);
      return Popper3;
    }();
    Popper2.Utils = (typeof window !== "undefined" ? window : commonjsGlobal).PopperUtils;
    Popper2.placements = placements;
    Popper2.Defaults = Defaults;
    return Popper2;
  });
})(popper);
var Popper$1 = popper.exports;
let transferIndex = 0;
let lastVisibleIndex = 0;
function transferIncrease() {
  transferIndex++;
}
function lastVisibleIncrease() {
  lastVisibleIndex++;
}
const _sfc_main$2p = {
  name: "Drop",
  emits: ["mouseenter", "mouseleave", "click"],
  props: {
    placement: {
      type: String,
      default: "bottom-start"
    },
    className: {
      type: String
    },
    transfer: {
      type: Boolean
    },
    eventsEnabled: {
      type: Boolean,
      default: false
    },
    visible: {
      type: Boolean
    },
    classes: {
      type: Object,
      default: () => {
      }
    },
    styles: {
      type: Object,
      default: () => {
      }
    },
    transitionName: {
      type: String,
      default: "transition-drop"
    },
    boundariesElement: {
      default: "window"
    }
  },
  data() {
    return {
      popper: null,
      width: "",
      popperStatus: false,
      tIndex: this.handleGetIndex()
    };
  },
  computed: {
    mergedStyle() {
      let style2 = {};
      if (this.width)
        style2.minWidth = `${this.width}px`;
      if (this.transfer)
        style2["z-index"] = 1060 + this.tIndex;
      return Object.assign({}, this.styles, style2);
    },
    mergedClass() {
      return Object.assign({}, this.classes, {
        [this.className]: this.className
      });
    }
  },
  methods: {
    update() {
      nextTick(() => {
        if (this.popper) {
          this.popper.update();
          this.popperStatus = true;
        } else {
          this.popper = new Popper$1(this.$parent.$refs.reference, this.$refs.drop, {
            eventsEnabled: this.eventsEnabled,
            placement: this.placement,
            modifiers: {
              computeStyle: {
                gpuAcceleration: false
              },
              preventOverflow: {
                boundariesElement: this.boundariesElement
              }
            },
            onCreate: () => {
              this.resetTransformOrigin();
              nextTick(this.popper.update());
            },
            onUpdate: () => {
              this.resetTransformOrigin();
            }
          });
        }
        if (this.$parent.$options.name === "iSelect") {
          this.width = parseInt(getStyle(this.$parent.$el, "width"));
        }
        this.tIndex = this.handleGetIndex();
      });
    },
    destroy() {
      if (this.popper) {
        setTimeout(() => {
          if (this.popper && !this.popperStatus) {
            this.popper.popper.style.display = "none";
            this.popper.destroy();
            this.popper = null;
          }
          this.popperStatus = false;
        }, 300);
      }
    },
    resetTransformOrigin() {
      if (!this.popper)
        return;
      let x_placement = this.popper.popper.getAttribute("x-placement");
      let placementStart = x_placement.split("-")[0];
      let placementEnd = x_placement.split("-")[1];
      const leftOrRight = x_placement === "left" || x_placement === "right";
      if (!leftOrRight) {
        this.popper.popper.style.transformOrigin = placementStart === "bottom" || placementStart !== "top" && placementEnd === "start" ? "center top" : "center bottom";
      }
    },
    handleGetIndex() {
      transferIncrease();
      return transferIndex;
    },
    handleMouseenter(e) {
      this.$emit("mouseenter", e);
    },
    handleMouseleave(e) {
      this.$emit("mouseleave", e);
    },
    handleOnUpdatePopper() {
      this.update();
    },
    handleOnDestroyPopper() {
      this.destroy();
    },
    handleClick(event) {
      this.$emit("click", event);
    }
  },
  beforeUnmount() {
    if (this.popper) {
      this.popper.destroy();
      this.popper = null;
    }
  }
};
function _sfc_render$29(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createBlock(Teleport, {
    to: "body",
    disabled: !$props.transfer
  }, [
    createVNode(Transition, { name: $props.transitionName }, {
      default: withCtx(() => [
        withDirectives(createElementVNode("div", mergeProps({
          class: ["ivu-select-dropdown", $options.mergedClass],
          ref: "drop",
          style: $options.mergedStyle
        }, _ctx.$attrs, {
          onMouseenter: _cache[0] || (_cache[0] = (...args) => $options.handleMouseenter && $options.handleMouseenter(...args)),
          onMouseleave: _cache[1] || (_cache[1] = (...args) => $options.handleMouseleave && $options.handleMouseleave(...args)),
          onClick: _cache[2] || (_cache[2] = withModifiers((...args) => $options.handleClick && $options.handleClick(...args), ["stop"]))
        }), [
          renderSlot(_ctx.$slots, "default")
        ], 16), [
          [vShow, $props.visible]
        ])
      ]),
      _: 3
    }, 8, ["name"])
  ], 8, ["disabled"]);
}
var Drop = /* @__PURE__ */ _export_sfc(_sfc_main$2p, [["render", _sfc_render$29]]);
function setLang(lang2) {
  if (isClient && typeof window.viewuiplus !== "undefined") {
    if (!("langs" in viewuiplus)) {
      viewuiplus.langs = {};
    }
    viewuiplus.langs[lang2.i.locale] = lang2;
  }
}
const lang$2 = {
  i: {
    locale: "zh-CN",
    select: {
      placeholder: "\u8BF7\u9009\u62E9",
      noMatch: "\u65E0\u5339\u914D\u6570\u636E",
      loading: "\u52A0\u8F7D\u4E2D"
    },
    table: {
      noDataText: "\u6682\u65E0\u6570\u636E",
      noFilteredDataText: "\u6682\u65E0\u7B5B\u9009\u7ED3\u679C",
      confirmFilter: "\u7B5B\u9009",
      resetFilter: "\u91CD\u7F6E",
      clearFilter: "\u5168\u90E8",
      sumText: "\u5408\u8BA1"
    },
    datepicker: {
      selectDate: "\u9009\u62E9\u65E5\u671F",
      selectTime: "\u9009\u62E9\u65F6\u95F4",
      startTime: "\u5F00\u59CB\u65F6\u95F4",
      endTime: "\u7ED3\u675F\u65F6\u95F4",
      clear: "\u6E05\u7A7A",
      ok: "\u786E\u5B9A",
      datePanelLabel: "[yyyy\u5E74] [m\u6708]",
      month: "\u6708",
      month1: "1 \u6708",
      month2: "2 \u6708",
      month3: "3 \u6708",
      month4: "4 \u6708",
      month5: "5 \u6708",
      month6: "6 \u6708",
      month7: "7 \u6708",
      month8: "8 \u6708",
      month9: "9 \u6708",
      month10: "10 \u6708",
      month11: "11 \u6708",
      month12: "12 \u6708",
      year: "\u5E74",
      weekStartDay: "0",
      weeks: {
        sun: "\u65E5",
        mon: "\u4E00",
        tue: "\u4E8C",
        wed: "\u4E09",
        thu: "\u56DB",
        fri: "\u4E94",
        sat: "\u516D"
      },
      months: {
        m1: "1\u6708",
        m2: "2\u6708",
        m3: "3\u6708",
        m4: "4\u6708",
        m5: "5\u6708",
        m6: "6\u6708",
        m7: "7\u6708",
        m8: "8\u6708",
        m9: "9\u6708",
        m10: "10\u6708",
        m11: "11\u6708",
        m12: "12\u6708"
      }
    },
    transfer: {
      titles: {
        source: "\u6E90\u5217\u8868",
        target: "\u76EE\u7684\u5217\u8868"
      },
      filterPlaceholder: "\u8BF7\u8F93\u5165\u641C\u7D22\u5185\u5BB9",
      notFoundText: "\u5217\u8868\u4E3A\u7A7A"
    },
    modal: {
      okText: "\u786E\u5B9A",
      cancelText: "\u53D6\u6D88"
    },
    poptip: {
      okText: "\u786E\u5B9A",
      cancelText: "\u53D6\u6D88"
    },
    page: {
      prev: "\u4E0A\u4E00\u9875",
      next: "\u4E0B\u4E00\u9875",
      total: "\u5171",
      item: "\u6761",
      items: "\u6761",
      prev5: "\u5411\u524D 5 \u9875",
      next5: "\u5411\u540E 5 \u9875",
      page: "\u6761/\u9875",
      goto: "\u8DF3\u81F3",
      p: "\u9875"
    },
    rate: {
      star: "\u661F",
      stars: "\u661F"
    },
    time: {
      before: "\u524D",
      after: "\u540E",
      just: "\u521A\u521A",
      seconds: "\u79D2",
      minutes: "\u5206\u949F",
      hours: "\u5C0F\u65F6",
      days: "\u5929"
    },
    tree: {
      emptyText: "\u6682\u65E0\u6570\u636E"
    },
    image: {
      zoomIn: "\u653E\u5927",
      zoomOut: "\u7F29\u5C0F",
      rotateLeft: "\u5DE6\u65CB\u8F6C",
      rotateRight: "\u53F3\u65CB\u8F6C",
      fail: "\u5931\u8D25",
      preview: "\u9884\u89C8"
    }
  }
};
setLang(lang$2);
var isMergeableObject = function isMergeableObject2(value) {
  return isNonNullObject(value) && !isSpecial(value);
};
function isNonNullObject(value) {
  return !!value && typeof value === "object";
}
function isSpecial(value) {
  var stringValue = Object.prototype.toString.call(value);
  return stringValue === "[object RegExp]" || stringValue === "[object Date]" || isReactElement(value);
}
var canUseSymbol = typeof Symbol === "function" && Symbol.for;
var REACT_ELEMENT_TYPE = canUseSymbol ? Symbol.for("react.element") : 60103;
function isReactElement(value) {
  return value.$$typeof === REACT_ELEMENT_TYPE;
}
function emptyTarget(val) {
  return Array.isArray(val) ? [] : {};
}
function cloneUnlessOtherwiseSpecified(value, options) {
  return options.clone !== false && options.isMergeableObject(value) ? deepmerge(emptyTarget(value), value, options) : value;
}
function defaultArrayMerge(target, source, options) {
  return target.concat(source).map(function(element) {
    return cloneUnlessOtherwiseSpecified(element, options);
  });
}
function mergeObject(target, source, options) {
  var destination = {};
  if (options.isMergeableObject(target)) {
    Object.keys(target).forEach(function(key2) {
      destination[key2] = cloneUnlessOtherwiseSpecified(target[key2], options);
    });
  }
  Object.keys(source).forEach(function(key2) {
    if (!options.isMergeableObject(source[key2]) || !target[key2]) {
      destination[key2] = cloneUnlessOtherwiseSpecified(source[key2], options);
    } else {
      destination[key2] = deepmerge(target[key2], source[key2], options);
    }
  });
  return destination;
}
function deepmerge(target, source, options) {
  options = options || {};
  options.arrayMerge = options.arrayMerge || defaultArrayMerge;
  options.isMergeableObject = options.isMergeableObject || isMergeableObject;
  var sourceIsArray = Array.isArray(source);
  var targetIsArray = Array.isArray(target);
  var sourceAndTargetTypesMatch = sourceIsArray === targetIsArray;
  if (!sourceAndTargetTypesMatch) {
    return cloneUnlessOtherwiseSpecified(source, options);
  } else if (sourceIsArray) {
    return options.arrayMerge(target, source, options);
  } else {
    return mergeObject(target, source, options);
  }
}
deepmerge.all = function deepmergeAll(array3, options) {
  if (!Array.isArray(array3)) {
    throw new Error("first argument should be an array");
  }
  return array3.reduce(function(prev, next) {
    return deepmerge(prev, next, options);
  }, {});
};
var deepmerge_1 = deepmerge;
const RE_NARGS = /(%|)\{([0-9a-zA-Z_]+)\}/g;
function Format() {
  function hasOwn(obj, key2) {
    return Object.prototype.hasOwnProperty.call(obj, key2);
  }
  function template(string2, ...args) {
    if (args.length === 1 && typeof args[0] === "object") {
      args = args[0];
    }
    if (!args || !args.hasOwnProperty) {
      args = {};
    }
    if (string2 === void 0) {
      return "";
    }
    return string2.replace(RE_NARGS, (match, prefix, i, index2) => {
      let result;
      if (string2[index2 - 1] === "{" && string2[index2 + match.length] === "}") {
        return i;
      } else {
        result = hasOwn(args, i) ? args[i] : null;
        if (result === null || result === void 0) {
          return "";
        }
        return result;
      }
    });
  }
  return template;
}
const format$1 = Format();
let lang$1 = lang$2;
const langs = {
  zh: lang$2
};
let nowLang = null;
let merged = {};
let vuei18n = null;
let i18nHandler = function() {
  if (Reflect.has(this, "$t")) {
    return this.$t(...arguments);
  }
  if (vuei18n && vuei18n.global) {
    return vuei18n.global.t(...arguments);
  }
  if (vuei18n && vuei18n.locale) {
    if (!merged[vuei18n.locale] || nowLang != vuei18n.locale) {
      merged[vuei18n.locale] = true;
      let localMessage = vuei18n.getLocaleMessage(vuei18n.locale) || {};
      let newLocalMessage = {};
      deepmerge_1(newLocalMessage, langs[vuei18n.locale], localMessage);
      lang$1 = newLocalMessage;
      vuei18n.setLocaleMessage(vuei18n.locale, newLocalMessage);
      nowLang = vuei18n.locale;
    }
    return vuei18n.hlang(...arguments);
  }
};
const t = function(path, options) {
  let value = i18nHandler.apply(this, arguments);
  if (value !== null && value !== void 0)
    return value;
  const array3 = path.split(".");
  let current = lang$1;
  for (let i = 0, j = array3.length; i < j; i++) {
    const property = array3[i];
    value = current[property];
    if (i === j - 1)
      return format$1(value, options);
    if (!value)
      return "";
    current = value;
  }
  return "";
};
const use = function(l) {
  lang$1 = l || lang$1;
};
const i18n$1 = function(initI18n) {
  vuei18n = initI18n;
};
var localeFile = {
  use,
  t,
  i18n: i18n$1
};
var Locale = {
  methods: {
    t(...args) {
      return t.apply(this, args);
    }
  }
};
var globalConfig = {
  data() {
    return {
      globalConfig: {}
    };
  },
  created() {
    const instance = getCurrentInstance();
    this.globalConfig = instance.appContext.config.globalProperties.$VIEWUI;
  }
};
const prefixCls$1j = "ivu-select";
const _sfc_main$2o = {
  name: "iSelectHead",
  mixins: [Locale, globalConfig],
  components: { Icon },
  emits: ["on-input-focus", "on-input-blur", "on-keydown", "on-enter", "on-clear", "on-query-change"],
  inject: ["SelectInstance"],
  props: {
    disabled: {
      type: Boolean,
      default: false
    },
    filterable: {
      type: Boolean,
      default: false
    },
    multiple: {
      type: Boolean,
      default: false
    },
    remote: {
      type: Boolean,
      default: false
    },
    initialLabel: {
      type: [String, Number, Array]
    },
    values: {
      type: Array,
      default: () => []
    },
    clearable: {
      type: [Function, Boolean],
      default: false
    },
    inputElementId: {
      type: String
    },
    placeholder: {
      type: String
    },
    queryProp: {
      type: String,
      default: ""
    },
    prefix: {
      type: String
    },
    maxTagCount: {
      type: Number
    },
    maxTagPlaceholder: {
      type: Function
    },
    allowCreate: {
      type: Boolean
    },
    showCreateItem: {
      type: Boolean
    }
  },
  data() {
    return {
      prefixCls: prefixCls$1j,
      query: "",
      inputLength: 20,
      remoteInitialLabel: this.initialLabel,
      preventRemoteCall: false
    };
  },
  computed: {
    singleDisplayClasses() {
      const { filterable, multiple, showPlaceholder } = this;
      return [{
        [prefixCls$1j + "-head-with-prefix"]: this.showPrefix,
        [prefixCls$1j + "-placeholder"]: showPlaceholder && !filterable,
        [prefixCls$1j + "-selected-value"]: !showPlaceholder && !multiple && !filterable
      }];
    },
    singleDisplayValue() {
      if (this.multiple && this.values.length > 0 || this.filterable)
        return "";
      return `${this.selectedSingle}` || this.localePlaceholder;
    },
    showPlaceholder() {
      let status = false;
      if (!this.multiple) {
        const value = this.values[0];
        if (typeof value === "undefined" || String(value).trim() === "") {
          status = !this.remoteInitialLabel;
        }
      } else {
        if (!this.values.length > 0) {
          status = true;
        }
      }
      return status;
    },
    resetSelect() {
      return !this.showPlaceholder && this.clearable;
    },
    inputStyle() {
      let style2 = {};
      if (this.multiple) {
        if (this.showPlaceholder) {
          style2.width = "100%";
        } else {
          style2.width = `${this.inputLength}px`;
        }
      }
      return style2;
    },
    localePlaceholder() {
      if (this.placeholder === void 0) {
        return this.t("i.select.placeholder");
      } else {
        return this.placeholder;
      }
    },
    selectedSingle() {
      const selected = this.values[0];
      return selected ? selected.label : this.remoteInitialLabel || "";
    },
    selectedMultiple() {
      const values = this.multiple ? this.values : [];
      return values.filter((item, index2) => this.maxTagCount === void 0 || index2 < this.maxTagCount);
    },
    headCls() {
      return {
        [`${prefixCls$1j}-head-flex`]: this.filterable && this.showPrefix
      };
    },
    arrowType() {
      const config = this.globalConfig;
      let type2 = "ios-arrow-down";
      if (config) {
        if (config.select.customArrow) {
          type2 = "";
        } else if (config.select.arrow) {
          type2 = config.select.arrow;
        }
      }
      return type2;
    },
    customArrowType() {
      const config = this.globalConfig;
      let type2 = "";
      if (config) {
        if (config.select.customArrow) {
          type2 = config.select.customArrow;
        }
      }
      return type2;
    },
    showPrefix() {
      const prefix = this.$slots.prefix && this.$slots.prefix();
      let visible = false;
      if (prefix) {
        visible = prefix[0].children.length > 0;
      }
      return visible || this.prefix;
    },
    arrowSize() {
      const config = this.globalConfig;
      let size = "";
      if (config) {
        if (config.select.arrowSize) {
          size = config.select.arrowSize;
        }
      }
      return size;
    }
  },
  methods: {
    onInputFocus() {
      this.$emit("on-input-focus");
    },
    onInputBlur() {
      if (this.showCreateItem)
        return;
      if (!this.values.length)
        this.query = "";
      this.$emit("on-input-blur");
    },
    removeTag(value) {
      if (this.disabled)
        return false;
      this.SelectInstance.handleOnSelectSelected(value);
    },
    resetInputState() {
      this.inputLength = this.$refs.input.value.length * 12 + 20;
      this.$emit("on-keydown");
    },
    handleInputDelete(e) {
      const targetValue = e.target.value;
      if (this.multiple && this.selectedMultiple.length && this.query === "" && targetValue === "") {
        this.removeTag(this.selectedMultiple[this.selectedMultiple.length - 1]);
      }
    },
    handleInputEnter(e) {
      this.$emit("on-enter");
      if (this.showCreateItem) {
        e.stopPropagation();
      }
    },
    onHeaderClick(e) {
      if (this.filterable && e.target === this.$el) {
        this.$refs.input.focus();
      }
    },
    onClear() {
      this.$emit("on-clear");
    }
  },
  watch: {
    values([value]) {
      if (!this.filterable)
        return;
      this.preventRemoteCall = true;
      if (this.multiple) {
        this.query = "";
        this.preventRemoteCall = false;
        return;
      }
      if (typeof value === "undefined" || value === "" || value === null)
        this.query = "";
      else
        this.query = value.label;
      nextTick(() => this.preventRemoteCall = false);
    },
    query(val) {
      if (this.preventRemoteCall) {
        this.preventRemoteCall = false;
        return;
      }
      this.$emit("on-query-change", val);
    },
    queryProp(query) {
      if (query !== this.query)
        this.query = query;
    }
  }
};
const _hoisted_1$1g = {
  key: 1,
  class: "ivu-tag ivu-tag-checked"
};
const _hoisted_2$L = { class: "ivu-tag-text ivu-select-max-tag" };
const _hoisted_3$y = ["id", "disabled", "placeholder"];
function _sfc_render$28(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = resolveComponent("Icon");
  return openBlock(), createElementBlock("div", {
    onClick: _cache[6] || (_cache[6] = (...args) => $options.onHeaderClick && $options.onHeaderClick(...args)),
    class: normalizeClass($options.headCls)
  }, [
    $options.showPrefix ? (openBlock(), createElementBlock("span", {
      key: 0,
      class: normalizeClass([$data.prefixCls + "-prefix"])
    }, [
      renderSlot(_ctx.$slots, "prefix", {}, () => [
        $props.prefix ? (openBlock(), createBlock(_component_Icon, {
          key: 0,
          type: $props.prefix
        }, null, 8, ["type"])) : createCommentVNode("", true)
      ])
    ], 2)) : createCommentVNode("", true),
    (openBlock(true), createElementBlock(Fragment, null, renderList($options.selectedMultiple, (item, index2) => {
      return openBlock(), createElementBlock("div", {
        class: "ivu-tag ivu-tag-checked",
        key: index2
      }, [
        createElementVNode("span", {
          class: normalizeClass(["ivu-tag-text", { "ivu-select-multiple-tag-hidden": item.disabled }])
        }, toDisplayString(item.tag !== void 0 ? item.tag : item.label), 3),
        !item.disabled ? (openBlock(), createBlock(_component_Icon, {
          key: 0,
          type: "ios-close",
          onClick: withModifiers(($event) => $options.removeTag(item), ["stop"])
        }, null, 8, ["onClick"])) : createCommentVNode("", true)
      ]);
    }), 128)),
    $props.maxTagCount !== void 0 && $props.values.length > $props.maxTagCount ? (openBlock(), createElementBlock("div", _hoisted_1$1g, [
      createElementVNode("span", _hoisted_2$L, [
        $props.maxTagPlaceholder ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
          createTextVNode(toDisplayString($props.maxTagPlaceholder($props.values.length - $props.maxTagCount)), 1)
        ], 64)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
          createTextVNode("+ " + toDisplayString($props.values.length - $props.maxTagCount) + "...", 1)
        ], 64))
      ])
    ])) : createCommentVNode("", true),
    withDirectives(createElementVNode("span", {
      class: normalizeClass($options.singleDisplayClasses)
    }, toDisplayString($options.singleDisplayValue), 3), [
      [vShow, $options.singleDisplayValue]
    ]),
    $props.filterable ? withDirectives((openBlock(), createElementBlock("input", {
      key: 2,
      id: $props.inputElementId,
      type: "text",
      "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => $data.query = $event),
      disabled: $props.disabled,
      class: normalizeClass([$data.prefixCls + "-input"]),
      placeholder: $options.showPlaceholder ? $options.localePlaceholder : "",
      style: normalizeStyle($options.inputStyle),
      autocomplete: "off",
      spellcheck: "false",
      onKeydown: [
        _cache[1] || (_cache[1] = (...args) => $options.resetInputState && $options.resetInputState(...args)),
        _cache[2] || (_cache[2] = withKeys((...args) => $options.handleInputDelete && $options.handleInputDelete(...args), ["delete"])),
        _cache[3] || (_cache[3] = withKeys((...args) => $options.handleInputEnter && $options.handleInputEnter(...args), ["enter"]))
      ],
      onFocus: _cache[4] || (_cache[4] = (...args) => $options.onInputFocus && $options.onInputFocus(...args)),
      onBlur: _cache[5] || (_cache[5] = (...args) => $options.onInputBlur && $options.onInputBlur(...args)),
      ref: "input"
    }, null, 46, _hoisted_3$y)), [
      [vModelText, $data.query]
    ]) : createCommentVNode("", true),
    $options.resetSelect ? (openBlock(), createBlock(_component_Icon, {
      key: 3,
      type: "ios-close-circle",
      class: normalizeClass([$data.prefixCls + "-arrow"]),
      onClick: withModifiers($options.onClear, ["stop"])
    }, null, 8, ["class", "onClick"])) : createCommentVNode("", true),
    !$options.resetSelect && !$props.remote ? (openBlock(), createBlock(_component_Icon, {
      key: 4,
      type: $options.arrowType,
      custom: $options.customArrowType,
      size: $options.arrowSize,
      class: normalizeClass([$data.prefixCls + "-arrow"])
    }, null, 8, ["type", "custom", "size", "class"])) : createCommentVNode("", true)
  ], 2);
}
var SelectHead = /* @__PURE__ */ _export_sfc(_sfc_main$2o, [["render", _sfc_render$28]]);
const CLICK = "click";
const captureInstances = /* @__PURE__ */ Object.create(null);
const nonCaptureInstances = /* @__PURE__ */ Object.create(null);
const instancesList = [captureInstances, nonCaptureInstances];
const commonHandler = function _onCommonEvent(context, instances, event) {
  const { target } = event;
  const itemIteratee = function _itemIteratee(item) {
    const { el } = item;
    if (el !== target && !el.contains(target)) {
      const { binding } = item;
      if (binding.modifiers.stop) {
        event.stopPropagation();
      }
      if (binding.modifiers.prevent) {
        event.preventDefault();
      }
      binding.value.call(context, event);
    }
  };
  const keysIteratee = function _keysIteratee(eventName) {
    return instances[eventName].forEach(itemIteratee);
  };
  Object.keys(instances).forEach(keysIteratee);
};
const captureEventHandler = function onCaptureEvent(event) {
  commonHandler(this, captureInstances, event);
};
const nonCaptureEventHandler = function onNonCaptureEvent(event) {
  commonHandler(this, nonCaptureInstances, event);
};
const getEventHandler = function _getEventHandler(useCapture) {
  return useCapture ? captureEventHandler : nonCaptureEventHandler;
};
const directive = Object.defineProperties(
  {},
  {
    $_captureInstances: {
      value: captureInstances
    },
    $_nonCaptureInstances: {
      value: nonCaptureInstances
    },
    $_onCaptureEvent: {
      value: captureEventHandler
    },
    $_onNonCaptureEvent: {
      value: nonCaptureEventHandler
    },
    beforeMount: {
      value: function bind(el, binding) {
        if (typeof binding.value !== "function") {
          throw new TypeError("Binding value must be a function.");
        }
        let eventType;
        const modifiers = binding.modifiers;
        if (modifiers.click)
          eventType = "click";
        else if (modifiers.mousedown)
          eventType = "mousedown";
        else if (modifiers.touchstart)
          eventType = "touchstart";
        else
          eventType = CLICK;
        const useCapture = binding.arg;
        const normalisedBinding = {
          ...binding,
          ...{
            modifiers: {
              ...{
                capture: false,
                prevent: false,
                stop: false
              },
              ...binding.modifiers
            }
          }
        };
        const instances = useCapture ? captureInstances : nonCaptureInstances;
        if (!Array.isArray(instances[eventType])) {
          instances[eventType] = [];
        }
        if (instances[eventType].push({ el, binding: normalisedBinding }) === 1) {
          if (typeof document === "object" && document) {
            document.addEventListener(
              eventType,
              getEventHandler(useCapture),
              useCapture
            );
          }
        }
      }
    },
    unmounted: {
      value: function unbind(el) {
        const compareElements = function _compareElements(item) {
          return item.el !== el;
        };
        const instancesIteratee = function _instancesIteratee(instances) {
          const instanceKeys = Object.keys(instances);
          if (instanceKeys.length) {
            const useCapture = instances === captureInstances;
            const keysIteratee = function _keysIteratee(eventName) {
              const newInstance = instances[eventName].filter(compareElements);
              if (newInstance.length) {
                instances[eventName] = newInstance;
              } else {
                if (typeof document === "object" && document) {
                  document.removeEventListener(
                    eventName,
                    getEventHandler(useCapture),
                    useCapture
                  );
                }
                delete instances[eventName];
              }
            };
            instanceKeys.forEach(keysIteratee);
          }
        };
        instancesList.forEach(instancesIteratee);
      }
    },
    version: {
      enumerable: true,
      value: "3.7.1"
    }
  }
);
var mixinsForm = {
  inject: {
    FormInstance: {
      default: ""
    },
    FormItemInstance: {
      default: null
    }
  },
  computed: {
    itemDisabled() {
      let state = this.disabled;
      if (!state && this.FormInstance)
        state = this.FormInstance.disabled;
      return state ? true : null;
    }
  },
  methods: {
    handleFormItemChange(type2, data) {
      if (this.FormItemInstance) {
        if (type2 === "blur")
          this.FormItemInstance.formBlur(data);
        else if (type2 === "change")
          this.FormItemInstance.formChange(data);
      }
    }
  }
};
const prefixCls$1i = "ivu-select";
const checkValuesNotEqual = (value, publicValue, values) => {
  const strValue = JSON.stringify(value);
  const strPublic = JSON.stringify(publicValue);
  const strValues = JSON.stringify(values.map((item) => {
    return item.value;
  }));
  return strValue !== strPublic || strValue !== strValues || strValues !== strPublic;
};
const ANIMATION_TIMEOUT = 300;
const _sfc_main$2n = {
  name: "iSelect",
  mixins: [Locale, mixinsForm],
  components: { Drop, SelectHead, Icon },
  directives: { clickOutside: directive },
  emits: ["on-set-default-options", "on-clear", "on-clickoutside", "on-select", "on-create", "on-change", "on-query-change", "on-open-change", "update:modelValue"],
  provide() {
    return {
      SelectInstance: this
    };
  },
  props: {
    modelValue: {
      type: [String, Number, Array],
      default: ""
    },
    label: {
      type: [String, Number, Array],
      default: ""
    },
    defaultLabel: {
      type: [String, Number, Array],
      default: ""
    },
    multiple: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    },
    clearable: {
      type: Boolean,
      default: false
    },
    placeholder: {
      type: String
    },
    filterable: {
      type: Boolean,
      default: false
    },
    filterMethod: {
      type: Function
    },
    remoteMethod: {
      type: Function
    },
    loading: {
      type: Boolean,
      default: false
    },
    loadingText: {
      type: String
    },
    size: {
      validator(value) {
        return oneOf(value, ["small", "large", "default"]);
      },
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.size === "" ? "default" : global2.$VIEWUI.size;
      }
    },
    labelInValue: {
      type: Boolean,
      default: false
    },
    notFoundText: {
      type: String
    },
    placement: {
      validator(value) {
        return oneOf(value, ["top", "bottom", "top-start", "bottom-start", "top-end", "bottom-end"]);
      },
      default: "bottom-start"
    },
    transfer: {
      type: Boolean,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.transfer === "" ? false : global2.$VIEWUI.transfer;
      }
    },
    autoComplete: {
      type: Boolean,
      default: false
    },
    name: {
      type: String
    },
    elementId: {
      type: String
    },
    transferClassName: {
      type: String
    },
    prefix: {
      type: String
    },
    maxTagCount: {
      type: Number
    },
    maxTagPlaceholder: {
      type: Function
    },
    allowCreate: {
      type: Boolean,
      default: false
    },
    capture: {
      type: Boolean,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI ? true : global2.$VIEWUI.capture;
      }
    },
    filterByLabel: {
      type: Boolean,
      default: false
    },
    eventsEnabled: {
      type: Boolean,
      default: false
    },
    hideNotFound: {
      type: Boolean,
      default: false
    }
  },
  mounted() {
    if (!this.remote && this.slotOptions.length > 0) {
      this.values = this.getInitialValue().map((value) => {
        if (typeof value !== "number" && !value)
          return null;
        return this.getOptionData(value);
      }).filter(Boolean);
    }
    this.checkUpdateStatus();
    if (this.remote && this.modelValue && this.defaultLabel) {
      if (!this.multiple) {
        this.query = this.defaultLabel;
        if (this.modelValue && this.defaultLabel) {
          this.values.push({
            label: this.defaultLabel,
            value: this.modelValue
          });
        }
      } else if (this.multiple && this.defaultLabel instanceof Array && this.modelValue.length === this.defaultLabel.length) {
        const values = this.modelValue.map((item, index2) => {
          return {
            value: item,
            label: this.defaultLabel[index2]
          };
        });
        setTimeout(() => {
          this.values = values;
        });
      }
    }
  },
  data() {
    return {
      prefixCls: prefixCls$1i,
      values: [],
      dropDownWidth: 0,
      visible: false,
      focusIndex: -1,
      isFocused: false,
      query: "",
      initialLabel: this.label,
      hasMouseHoverHead: false,
      slotOptions: [],
      caretPosition: -1,
      lastRemoteQuery: "",
      unchangedQuery: true,
      hasExpectedValue: false,
      isTyping: false,
      preventRemoteCall: false,
      filterQueryChange: false,
      slotOptionsMap: /* @__PURE__ */ new Map(),
      isLocking: false
    };
  },
  computed: {
    classes() {
      return [
        `${prefixCls$1i}`,
        {
          [`${prefixCls$1i}-visible`]: this.visible,
          [`${prefixCls$1i}-disabled`]: this.itemDisabled,
          [`${prefixCls$1i}-multiple`]: this.multiple,
          [`${prefixCls$1i}-single`]: !this.multiple,
          [`${prefixCls$1i}-${this.size}`]: !!this.size
        }
      ];
    },
    dropdownCls() {
      return {
        [prefixCls$1i + "-dropdown-transfer"]: this.transfer,
        [prefixCls$1i + "-multiple"]: this.multiple && this.transfer,
        ["ivu-auto-complete"]: this.autoComplete,
        [this.transferClassName]: this.transferClassName
      };
    },
    selectionCls() {
      return {
        [`${prefixCls$1i}-selection`]: !this.autoComplete,
        [`${prefixCls$1i}-selection-focused`]: this.isFocused
      };
    },
    localeNotFoundText() {
      if (typeof this.notFoundText === "undefined") {
        return this.t("i.select.noMatch");
      } else {
        return this.notFoundText;
      }
    },
    localeLoadingText() {
      if (typeof this.loadingText === "undefined") {
        return this.t("i.select.loading");
      } else {
        return this.loadingText;
      }
    },
    showCreateItem() {
      let state = false;
      const { allowCreate, query, slotOptions } = this;
      if (allowCreate && query !== "") {
        state = true;
        const findSlotItem = (slotOptions || []).find((item) => item.proxy && item.proxy.showLabel === query);
        if (findSlotItem)
          state = false;
      }
      return state;
    },
    transitionName() {
      return this.placement === "bottom" ? "slide-up" : "slide-down";
    },
    dropVisible() {
      let status = true;
      const noOptions = this.slotOptions.length === 0;
      if (!this.loading && this.remote && this.query === "" && noOptions)
        status = false;
      if (this.autoComplete && noOptions)
        status = false;
      return this.visible && status;
    },
    showNotFoundLabel() {
      const { loading: loading2, remote, slotOptions, hideNotFound } = this;
      const options = slotOptions || [];
      const filterOptions = options.find((item) => item.proxy.isShow);
      return (options.length === 0 || !filterOptions) && (!remote || remote && !loading2) && !hideNotFound;
    },
    publicValue() {
      return this.multiple ? this.values.map((option) => option.value) : (this.values[0] || {}).value;
    },
    canBeCleared() {
      const uiStateMatch = this.hasMouseHoverHead;
      const qualifiesForClear = !this.multiple && !this.itemDisabled && this.clearable;
      return uiStateMatch && qualifiesForClear && this.reset;
    },
    selectTabindex() {
      return this.itemDisabled || this.filterable ? -1 : 0;
    },
    remote() {
      return typeof this.remoteMethod === "function";
    }
  },
  methods: {
    setQuery(query) {
      if (query) {
        this.onQueryChange(query);
        return;
      }
      if (query === null) {
        this.onQueryChange("");
        this.values = [];
        this.lastRemoteQuery = "";
      }
    },
    clearSingleSelect() {
      if (!this.multiple)
        this.$emit("update:modelValue", "");
      this.$emit("on-clear");
      this.hideMenu();
      if (this.clearable)
        this.reset();
    },
    getOptionData(value) {
      const optionItem = this.slotOptions.find(({ props }) => props.value === value);
      if (!optionItem)
        return null;
      const { optionLabel, disabled } = optionItem.proxy || {};
      return {
        value,
        label: optionLabel,
        disabled
      };
    },
    getInitialValue() {
      const { multiple, remote, modelValue } = this;
      let initialValue = Array.isArray(modelValue) ? modelValue : [modelValue];
      if (!multiple && (typeof initialValue[0] === "undefined" || String(initialValue[0]).trim() === "" && !Number.isFinite(initialValue[0])))
        initialValue = [];
      if (remote && !multiple && modelValue) {
        const data = this.getOptionData(modelValue);
        this.query = data ? data.label : String(modelValue);
      }
      return initialValue.filter((item) => {
        return Boolean(item) || item === 0;
      });
    },
    validateOption({ children, elm, propsData }) {
      const value = propsData.value;
      const label = propsData.label || "";
      const textContent = elm && elm.textContent || (children || []).reduce((str, node) => {
        const nodeText = node.elm ? node.elm.textContent : node.text;
        return `${str} ${nodeText}`;
      }, "") || "";
      const stringValues = this.filterByLabel ? [label].toString() : [value, label, textContent].toString();
      const query = this.query.toLowerCase().trim();
      return stringValues.toLowerCase().includes(query);
    },
    toggleMenu(e, force) {
      if (this.itemDisabled) {
        return false;
      }
      this.visible = typeof force !== "undefined" ? force : !this.visible;
      if (this.visible) {
        this.dropDownWidth = this.$el.getBoundingClientRect().width;
        this.$refs.dropdown.handleOnUpdatePopper();
      }
    },
    hideMenu() {
      this.toggleMenu(null, false);
      this.isTyping = false;
      setTimeout(() => this.unchangedQuery = true, ANIMATION_TIMEOUT);
    },
    onClickOutside(event) {
      if (this.visible) {
        if (event.type === "mousedown") {
          event.preventDefault();
          return;
        }
        if (this.transfer) {
          const $el = this.$refs.dropdown.$refs.drop;
          if ($el === event.target || $el.contains(event.target)) {
            return;
          }
        }
        if (this.filterable) {
          const input = this.$el.querySelector('input[type="text"]');
          this.caretPosition = input.selectionStart;
          nextTick(() => {
            const caretPosition = this.caretPosition === -1 ? input.value.length : this.caretPosition;
            input.setSelectionRange(caretPosition, caretPosition);
          });
        }
        if (!this.autoComplete)
          event.stopPropagation();
        event.preventDefault();
        this.hideMenu();
        this.isFocused = true;
        this.$emit("on-clickoutside", event);
      } else {
        this.caretPosition = -1;
        this.isFocused = false;
      }
    },
    reset() {
      this.query = "";
      this.focusIndex = -1;
      this.unchangedQuery = true;
      this.values = [];
      this.filterQueryChange = false;
    },
    handleKeydown(e) {
      const key2 = e.key || e.code;
      const keyCode = e.keyCode || e.which;
      if (key2 === "Backspace" || keyCode === 8) {
        return;
      }
      if (this.visible) {
        e.preventDefault();
        if (key2 === "Tab") {
          e.stopPropagation();
        }
        if (key2 === "Escape") {
          e.stopPropagation();
          this.hideMenu();
        }
        if (key2 === "ArrowUp") {
          this.navigateOptions(-1);
        }
        if (key2 === "ArrowDown") {
          this.navigateOptions(1);
        }
        if (key2 === "Enter") {
          if (this.focusIndex === -1)
            return this.hideMenu();
          const optionComponent = this.slotOptions[this.focusIndex];
          if (optionComponent) {
            const option = this.getOptionData(optionComponent.props.value);
            this.onOptionClick(option);
          } else {
            this.hideMenu();
          }
        }
      } else {
        const keysThatCanOpenSelect = ["ArrowUp", "ArrowDown"];
        if (keysThatCanOpenSelect.includes(e.key))
          this.toggleMenu(null, true);
      }
    },
    navigateOptions(direction) {
      const slotOptions = this.slotOptions;
      const optionsLength = slotOptions.length - 1;
      if (optionsLength < 0)
        return;
      let index2 = this.focusIndex + direction;
      if (index2 < 0)
        index2 = optionsLength;
      if (index2 > optionsLength)
        index2 = 0;
      let nearestActiveOption;
      let firseIndex = null;
      if (direction > 0) {
        nearestActiveOption = -1;
        for (let i = 0; i < slotOptions.length; i++) {
          const { proxy } = slotOptions[i];
          const optionIsActive = !proxy.disabled;
          if (optionIsActive)
            nearestActiveOption = i;
          if (proxy.isShow && firseIndex === null) {
            firseIndex = i;
          } else if (!proxy.isShow) {
            nearestActiveOption = i;
            continue;
          }
          if (nearestActiveOption >= index2)
            break;
        }
      } else {
        nearestActiveOption = slotOptions.length;
        for (let i = optionsLength; i >= 0; i--) {
          const { proxy } = slotOptions[i];
          const optionIsActive = !proxy.disabled;
          if (optionIsActive)
            nearestActiveOption = i;
          if (proxy.isShow && firseIndex === null) {
            firseIndex = i;
          } else if (!proxy.isShow) {
            nearestActiveOption = i;
            continue;
          }
          if (nearestActiveOption <= index2)
            break;
        }
      }
      const activeSlotsOption = slotOptions[nearestActiveOption];
      index2 = !activeSlotsOption.proxy.isShow ? firseIndex : nearestActiveOption;
      this.focusIndex = index2;
    },
    onOptionClick(option) {
      if (this.multiple) {
        if (this.remote)
          this.lastRemoteQuery = this.lastRemoteQuery || this.query;
        else
          this.lastRemoteQuery = "";
        const valueIsSelected = this.values.find(({ value }) => value === option.value);
        if (valueIsSelected) {
          this.values = this.values.filter(({ value }) => value !== option.value);
        } else {
          this.values = this.values.concat(option);
        }
        this.isFocused = true;
      } else {
        this.query = String(option.label).trim();
        this.values = [option];
        this.lastRemoteQuery = "";
        this.hideMenu();
      }
      this.focusIndex = this.slotOptions.findIndex((opt) => {
        if (!opt)
          return false;
        return opt.props.value === option.value;
      });
      if (this.filterable) {
        const inputField = this.$el.querySelector('input[type="text"]');
        if (!this.autoComplete)
          nextTick(() => inputField.focus());
      }
      this.$emit("on-select", option);
      this.$refs.dropdown.handleOnUpdatePopper();
      setTimeout(() => {
        this.filterQueryChange = false;
      }, ANIMATION_TIMEOUT);
    },
    onQueryChange(query) {
      this.isTyping = true;
      if (query.length > 0 && query !== this.query) {
        if (isClient && this.autoComplete) {
          let isInputFocused = document.hasFocus && document.hasFocus() && document.activeElement === this.$el.querySelector("input");
          this.visible = isInputFocused;
        } else {
          this.visible = true;
        }
      }
      this.query = query;
      this.unchangedQuery = this.visible;
      this.filterQueryChange = true;
    },
    toggleHeaderFocus({ type: type2 }) {
      if (this.itemDisabled) {
        return;
      }
      this.isFocused = type2 === "focus";
    },
    checkUpdateStatus() {
      if (this.getInitialValue().length > 0 && this.slotOptions.length === 0) {
        this.hasExpectedValue = true;
      }
    },
    handleCreateItem() {
      if (this.allowCreate && this.query !== "" && this.showCreateItem) {
        const query = this.query;
        this.$emit("on-create", query);
        this.query = "";
        const option = {
          value: query,
          label: query,
          tag: void 0
        };
        this.$refs.dropdown.handleOnUpdatePopper();
        setTimeout(() => {
          this.onOptionClick(option);
        });
      }
    },
    handleOnSelectSelected(options) {
      this.onOptionClick(options);
    },
    focus() {
      if (this.filterable) {
        this.$refs.selectHead.$refs.input.focus();
        this.toggleMenu();
      }
    },
    lazyUpdateValue(checked) {
      const { getInitialValue, isLocking, defaultLabel, remote, modelValue, values } = this;
      const hasDefaultLabel = !!(defaultLabel && defaultLabel.length);
      const hasModelValue = !!(modelValue && modelValue.length);
      if ((hasModelValue || values.length || hasDefaultLabel) && remote && checked)
        return;
      if (isLocking)
        return;
      this.isLocking = true;
      nextTick(() => {
        this.values = getInitialValue().map(this.getOptionData).filter(Boolean);
        this.isLocking = false;
      });
    }
  },
  watch: {
    modelValue(value) {
      const { publicValue, values } = this;
      this.checkUpdateStatus();
      if (value === "") {
        this.values = [];
        this.query = "";
      } else if (checkValuesNotEqual(value, publicValue, values)) {
        this.lazyUpdateValue();
        if (!this.multiple)
          this.handleFormItemChange("change", this.publicValue);
      }
    },
    values(now2, before) {
      const newValue = JSON.stringify(now2);
      const oldValue = JSON.stringify(before);
      let vModelValue = this.publicValue;
      const shouldEmitInput = newValue !== oldValue && vModelValue !== this.modelValue;
      if (shouldEmitInput) {
        let emitValue = this.publicValue;
        if (this.labelInValue) {
          if (this.multiple) {
            emitValue = this.values;
          } else {
            emitValue = this.values[0];
          }
        }
        if (Array.isArray(vModelValue) && !vModelValue.length && this.modelValue === null)
          vModelValue = null;
        else if (vModelValue === void 0 && this.modelValue === null)
          vModelValue = null;
        this.$emit("update:modelValue", vModelValue);
        this.$emit("on-change", emitValue);
        this.handleFormItemChange("change", emitValue);
      }
    },
    query(query) {
      this.focusIndex = -1;
      this.$emit("on-query-change", query);
      const { remoteMethod, lastRemoteQuery } = this;
      const hasValidQuery = query !== "" && (query !== lastRemoteQuery || !lastRemoteQuery);
      const shouldCallRemoteMethod = remoteMethod && hasValidQuery && !this.preventRemoteCall;
      this.preventRemoteCall = false;
      if (shouldCallRemoteMethod) {
        const promise = this.remoteMethod(query);
        this.initialLabel = "";
        if (promise && promise.then) {
          promise.then((options) => {
            if (options)
              this.options = options;
          });
        }
      }
      if (this.visible) {
        this.$refs.dropdown.handleOnUpdatePopper();
      }
      if (query !== "" && this.remote)
        this.lastRemoteQuery = query;
    },
    isFocused(focused) {
      const el = this.filterable ? this.$el.querySelector('input[type="text"]') : this.$el;
      el[this.isFocused ? "focus" : "blur"]();
      const [selectedOption] = this.values;
      if (selectedOption && this.filterable && !this.multiple && !focused) {
        const selectedLabel = String(selectedOption.label || selectedOption.value).trim();
        if (selectedLabel && this.query !== selectedLabel) {
          this.preventRemoteCall = true;
          this.query = selectedLabel;
        }
      }
    },
    focusIndex(index2) {
      if (index2 < 0 || this.autoComplete)
        return;
      if (this.slotOptions[index2]) {
        const optionInstance = this.slotOptions[index2].proxy;
        const $itemEle = optionInstance.$el;
        const $drop = this.$refs.dropdown.$refs.drop;
        let bottomOverflowDistance = $itemEle.getBoundingClientRect().bottom - $drop.getBoundingClientRect().bottom;
        let topOverflowDistance = $itemEle.getBoundingClientRect().top - $drop.getBoundingClientRect().top;
        if (bottomOverflowDistance > 0) {
          $drop.scrollTop += bottomOverflowDistance;
        }
        if (topOverflowDistance < 0) {
          $drop.scrollTop += topOverflowDistance;
        }
      }
    },
    dropVisible(open) {
      if (open) {
        this.$refs.dropdown.handleOnUpdatePopper();
      } else {
        this.$refs.dropdown.handleOnDestroyPopper();
      }
    },
    visible(state) {
      this.$emit("on-open-change", state);
    }
  }
};
const _hoisted_1$1f = ["tabindex"];
const _hoisted_2$K = ["name", "value"];
function _sfc_render$27(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_select_head = resolveComponent("select-head");
  const _component_Icon = resolveComponent("Icon");
  const _component_Drop = resolveComponent("Drop");
  const _directive_click_outside = resolveDirective("click-outside");
  return withDirectives((openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes)
  }, [
    createElementVNode("div", {
      ref: "reference",
      class: normalizeClass($options.selectionCls),
      tabindex: $options.selectTabindex,
      onBlur: _cache[2] || (_cache[2] = (...args) => $options.toggleHeaderFocus && $options.toggleHeaderFocus(...args)),
      onFocus: _cache[3] || (_cache[3] = (...args) => $options.toggleHeaderFocus && $options.toggleHeaderFocus(...args)),
      onClick: _cache[4] || (_cache[4] = (...args) => $options.toggleMenu && $options.toggleMenu(...args)),
      onKeydown: [
        _cache[5] || (_cache[5] = withKeys((...args) => $options.handleKeydown && $options.handleKeydown(...args), ["esc"])),
        _cache[6] || (_cache[6] = withKeys((...args) => $options.handleKeydown && $options.handleKeydown(...args), ["enter"])),
        _cache[7] || (_cache[7] = withKeys(withModifiers((...args) => $options.handleKeydown && $options.handleKeydown(...args), ["prevent"]), ["up"])),
        _cache[8] || (_cache[8] = withKeys(withModifiers((...args) => $options.handleKeydown && $options.handleKeydown(...args), ["prevent"]), ["down"])),
        _cache[9] || (_cache[9] = withKeys((...args) => $options.handleKeydown && $options.handleKeydown(...args), ["tab"])),
        _cache[10] || (_cache[10] = withKeys((...args) => $options.handleKeydown && $options.handleKeydown(...args), ["delete"]))
      ],
      onMouseenter: _cache[11] || (_cache[11] = ($event) => $data.hasMouseHoverHead = true),
      onMouseleave: _cache[12] || (_cache[12] = ($event) => $data.hasMouseHoverHead = false)
    }, [
      renderSlot(_ctx.$slots, "input", {}, () => [
        createElementVNode("input", {
          type: "hidden",
          name: $props.name,
          value: $options.publicValue
        }, null, 8, _hoisted_2$K),
        createVNode(_component_select_head, {
          ref: "selectHead",
          filterable: $props.filterable,
          multiple: $props.multiple,
          values: $data.values,
          clearable: $options.canBeCleared,
          prefix: $props.prefix,
          disabled: _ctx.itemDisabled,
          remote: $options.remote,
          "input-element-id": $props.elementId,
          "initial-label": $data.initialLabel,
          placeholder: $props.placeholder,
          "query-prop": $data.query,
          "max-tag-count": $props.maxTagCount,
          "max-tag-placeholder": $props.maxTagPlaceholder,
          "allow-create": $props.allowCreate,
          "show-create-item": $options.showCreateItem,
          onOnQueryChange: $options.onQueryChange,
          onOnInputFocus: _cache[0] || (_cache[0] = ($event) => $data.isFocused = true),
          onOnInputBlur: _cache[1] || (_cache[1] = ($event) => $data.isFocused = false),
          onOnClear: $options.clearSingleSelect,
          onOnEnter: $options.handleCreateItem
        }, {
          prefix: withCtx(() => [
            renderSlot(_ctx.$slots, "prefix")
          ]),
          _: 3
        }, 8, ["filterable", "multiple", "values", "clearable", "prefix", "disabled", "remote", "input-element-id", "initial-label", "placeholder", "query-prop", "max-tag-count", "max-tag-placeholder", "allow-create", "show-create-item", "onOnQueryChange", "onOnClear", "onOnEnter"])
      ])
    ], 42, _hoisted_1$1f),
    createVNode(_component_Drop, {
      ref: "dropdown",
      classes: $options.dropdownCls,
      visible: $options.dropVisible,
      placement: $props.placement,
      eventsEnabled: $props.eventsEnabled,
      transfer: $props.transfer,
      "transition-name": "transition-drop"
    }, {
      default: withCtx(() => [
        withDirectives(createElementVNode("ul", {
          class: normalizeClass([$data.prefixCls + "-not-found"])
        }, [
          createElementVNode("li", null, toDisplayString($options.localeNotFoundText), 1)
        ], 2), [
          [vShow, $options.showNotFoundLabel && !$props.allowCreate]
        ]),
        !$options.remote || $options.remote && !$props.loading ? (openBlock(), createElementBlock("ul", {
          key: 0,
          class: normalizeClass($data.prefixCls + "-dropdown-list")
        }, [
          $options.showCreateItem ? (openBlock(), createElementBlock("li", {
            key: 0,
            class: normalizeClass($data.prefixCls + "-item"),
            onClick: _cache[13] || (_cache[13] = (...args) => $options.handleCreateItem && $options.handleCreateItem(...args))
          }, [
            createTextVNode(toDisplayString($data.query) + " ", 1),
            createVNode(_component_Icon, {
              type: "md-return-left",
              class: normalizeClass($data.prefixCls + "-item-enter")
            }, null, 8, ["class"])
          ], 2)) : createCommentVNode("", true),
          renderSlot(_ctx.$slots, "default")
        ], 2)) : (openBlock(), createElementBlock("ul", {
          key: 1,
          class: normalizeClass($data.prefixCls + "-dropdown-list")
        }, [
          $options.showCreateItem ? (openBlock(), createElementBlock("li", {
            key: 0,
            class: normalizeClass($data.prefixCls + "-item"),
            onClick: _cache[14] || (_cache[14] = (...args) => $options.handleCreateItem && $options.handleCreateItem(...args))
          }, [
            createTextVNode(toDisplayString($data.query) + " ", 1),
            createVNode(_component_Icon, {
              type: "md-return-left",
              class: normalizeClass($data.prefixCls + "-item-enter")
            }, null, 8, ["class"])
          ], 2)) : createCommentVNode("", true)
        ], 2)),
        withDirectives(createElementVNode("ul", {
          class: normalizeClass([$data.prefixCls + "-loading"])
        }, toDisplayString($options.localeLoadingText), 3), [
          [vShow, $props.loading]
        ])
      ]),
      _: 3
    }, 8, ["classes", "visible", "placement", "eventsEnabled", "transfer"])
  ], 2)), [
    [_directive_click_outside, $options.onClickOutside, $props.capture],
    [
      _directive_click_outside,
      $options.onClickOutside,
      $props.capture,
      { mousedown: true }
    ],
    [
      _directive_click_outside,
      $options.onClickOutside,
      $props.capture,
      { touchstart: true }
    ]
  ]);
}
var Select = /* @__PURE__ */ _export_sfc(_sfc_main$2n, [["render", _sfc_render$27]]);
const prefixCls$1h = "ivu-select-item";
const _sfc_main$2m = {
  name: "iOption",
  componentName: "select-item",
  mixins: [mixinsForm],
  emits: ["on-select-selected"],
  inject: {
    SelectInstance: {
      default: null
    },
    OptionGroupInstance: {
      default: null
    }
  },
  props: {
    value: {
      type: [String, Number],
      required: true
    },
    label: {
      type: [String, Number]
    },
    disabled: {
      type: Boolean,
      default: false
    },
    tag: {
      type: [String, Number]
    }
  },
  data() {
    return {
      searchLabel: "",
      autoComplete: false,
      id: random(6),
      instance: null
    };
  },
  computed: {
    classes() {
      return [
        `${prefixCls$1h}`,
        {
          [`${prefixCls$1h}-disabled`]: this.itemDisabled,
          [`${prefixCls$1h}-selected`]: this.selected && !this.autoComplete,
          [`${prefixCls$1h}-focus`]: this.isFocused
        }
      ];
    },
    showLabel() {
      return this.label ? this.label : this.value;
    },
    optionLabel() {
      return this.label || this.$el && this.$el.textContent;
    },
    isFocused() {
      const SelectInstance = this.SelectInstance;
      let slotOptions = SelectInstance.slotOptions || [];
      const focusIndex = SelectInstance.focusIndex;
      const defaultSlot = SelectInstance.$slots.default;
      if (this.autoComplete && defaultSlot) {
        slotOptions = [];
        let vNodes = defaultSlot();
        while (vNodes.length > 0) {
          const vNode = vNodes.shift();
          if (vNode.type && typeof vNode.type === "object" && vNode.type.name === "iOption") {
            slotOptions.push(vNode);
          } else {
            if (Array.isArray(vNode.children)) {
              vNodes = vNodes.concat(vNode.children);
            }
          }
        }
      }
      const focusOption = slotOptions[focusIndex];
      return focusOption && focusOption.props && focusOption.props.value === this.value;
    },
    isShow() {
      const SelectInstance = this.SelectInstance;
      const filterable = SelectInstance.filterable;
      const query = SelectInstance.query.toLowerCase().trim();
      const filterByLabel = SelectInstance.filterByLabel;
      const slotOptionsMap = SelectInstance.slotOptionsMap;
      const { props } = slotOptionsMap.get(this.value) || { props: {} };
      const label = this.label || this.$el && this.$el.textContent;
      let filterOption = (label || props.value || "").toLowerCase();
      if (filterByLabel) {
        filterOption = (label || "").toLowerCase();
      }
      const showFilterOption = filterOption.includes(query);
      return !filterable || filterable && (showFilterOption || !SelectInstance.filterQueryChange) || typeOf(SelectInstance.remoteMethod) === "function";
    },
    selected() {
      const SelectInstance = this.SelectInstance;
      const values = SelectInstance.values || [];
      return values.find((item) => item.value === this.value);
    }
  },
  methods: {
    select() {
      if (this.itemDisabled)
        return false;
      this.SelectInstance.handleOnSelectSelected({
        value: this.value,
        label: this.optionLabel,
        tag: this.tag
      });
    },
    addOption() {
      const select2 = this.SelectInstance;
      const group = this.OptionGroupInstance;
      const { id, value, instance } = this;
      if (group) {
        group.optionList.push({
          ...instance,
          id,
          tag: "option"
        });
      }
      if (select2) {
        select2.slotOptions.push({
          ...instance,
          id,
          tag: "option"
        });
        select2.slotOptionsMap.set(value, instance);
        const { modelValue } = select2;
        (modelValue && modelValue.length || typeOf(modelValue) === "number") && select2.lazyUpdateValue(true);
      }
    },
    removeOption() {
      const group = this.OptionGroupInstance;
      const select2 = this.SelectInstance;
      const { id, value } = this;
      if (group) {
        const index2 = group.optionList.findIndex((item) => item.id === id);
        index2 !== -1 && group.optionList.splice(index2, 1);
      }
      if (select2) {
        const select3 = this.SelectInstance;
        const index2 = select3.slotOptions.findIndex((item) => item.id === id);
        index2 !== -1 && select3.slotOptions.splice(index2, 1);
        select3.slotOptionsMap.has(value) && select3.slotOptionsMap.delete(value);
      }
    }
  },
  created() {
    this.instance = getCurrentInstance();
  },
  mounted() {
    this.addOption();
    const Select2 = findComponentUpward(this, "iSelect");
    if (Select2) {
      this.autoComplete = Select2.autoComplete;
    }
  },
  beforeUnmount() {
    nextTick(() => {
      this.removeOption();
      this.instance = null;
    });
  }
};
function _sfc_render$26(_ctx, _cache, $props, $setup, $data, $options) {
  return withDirectives((openBlock(), createElementBlock("li", {
    class: normalizeClass($options.classes),
    onClick: _cache[0] || (_cache[0] = withModifiers((...args) => $options.select && $options.select(...args), ["stop"])),
    onMousedown: _cache[1] || (_cache[1] = withModifiers(() => {
    }, ["prevent"]))
  }, [
    renderSlot(_ctx.$slots, "default", {}, () => [
      createTextVNode(toDisplayString($options.showLabel), 1)
    ])
  ], 34)), [
    [vShow, $options.isShow]
  ]);
}
var iOption = /* @__PURE__ */ _export_sfc(_sfc_main$2m, [["render", _sfc_render$26]]);
const HIDDEN_TEXTAREA_STYLE = `
  min-height:0 !important;
  max-height:none !important;
  height:0 !important;
  visibility:hidden !important;
  overflow:hidden !important;
  position:absolute !important;
  z-index:-1000 !important;
  top:0 !important;
  right:0 !important
`;
const SIZING_STYLE = [
  "letter-spacing",
  "line-height",
  "padding-top",
  "padding-bottom",
  "font-family",
  "font-weight",
  "font-size",
  "text-rendering",
  "text-transform",
  "width",
  "text-indent",
  "padding-left",
  "padding-right",
  "border-width",
  "box-sizing"
];
let computedStyleCache = {};
let hiddenTextarea;
function calculateNodeStyling(node, useCache = false) {
  if (!isClient)
    return;
  const nodeRef = node.getAttribute("id") || node.getAttribute("data-reactid") || node.getAttribute("name");
  if (useCache && computedStyleCache[nodeRef]) {
    return computedStyleCache[nodeRef];
  }
  const style2 = window.getComputedStyle(node);
  const boxSizing = style2.getPropertyValue("box-sizing") || style2.getPropertyValue("-moz-box-sizing") || style2.getPropertyValue("-webkit-box-sizing");
  const paddingSize = parseFloat(style2.getPropertyValue("padding-bottom")) + parseFloat(style2.getPropertyValue("padding-top"));
  const borderSize = parseFloat(style2.getPropertyValue("border-bottom-width")) + parseFloat(style2.getPropertyValue("border-top-width"));
  const sizingStyle = SIZING_STYLE.map((name2) => `${name2}:${style2.getPropertyValue(name2)}`).join(";");
  const nodeInfo = {
    sizingStyle,
    paddingSize,
    borderSize,
    boxSizing
  };
  if (useCache && nodeRef) {
    computedStyleCache[nodeRef] = nodeInfo;
  }
  return nodeInfo;
}
function calcTextareaHeight(uiTextNode, minRows = null, maxRows = null, useCache = false) {
  if (isClient && !hiddenTextarea) {
    hiddenTextarea = document.createElement("textarea");
    document.body.appendChild(hiddenTextarea);
  }
  if (uiTextNode.getAttribute("wrap")) {
    hiddenTextarea.setAttribute("wrap", uiTextNode.getAttribute("wrap"));
  } else {
    hiddenTextarea.removeAttribute("wrap");
  }
  let {
    paddingSize,
    borderSize,
    boxSizing,
    sizingStyle
  } = calculateNodeStyling(uiTextNode, useCache);
  hiddenTextarea.setAttribute("style", `${sizingStyle};${HIDDEN_TEXTAREA_STYLE}`);
  hiddenTextarea.value = uiTextNode.value || uiTextNode.placeholder || "";
  let minHeight = Number.MIN_SAFE_INTEGER;
  let maxHeight = Number.MAX_SAFE_INTEGER;
  let height2 = hiddenTextarea.scrollHeight;
  let overflowY;
  if (boxSizing === "border-box") {
    height2 = height2 + borderSize;
  } else if (boxSizing === "content-box") {
    height2 = height2 - paddingSize;
  }
  if (minRows !== null || maxRows !== null) {
    hiddenTextarea.value = " ";
    let singleRowHeight = hiddenTextarea.scrollHeight - paddingSize;
    if (minRows !== null) {
      minHeight = singleRowHeight * minRows;
      if (boxSizing === "border-box") {
        minHeight = minHeight + paddingSize + borderSize;
      }
      height2 = Math.max(minHeight, height2);
    }
    if (maxRows !== null) {
      maxHeight = singleRowHeight * maxRows;
      if (boxSizing === "border-box") {
        maxHeight = maxHeight + paddingSize + borderSize;
      }
      overflowY = height2 > maxHeight ? "" : "hidden";
      height2 = Math.min(maxHeight, height2);
    }
  }
  if (!maxRows) {
    overflowY = "hidden";
  }
  return {
    height: `${height2}px`,
    minHeight: `${minHeight}px`,
    maxHeight: `${maxHeight}px`,
    overflowY
  };
}
const prefixCls$1g = "ivu-input";
const _sfc_main$2l = {
  name: "Input",
  mixins: [mixinsForm],
  emits: ["on-enter", "on-search", "on-keydown", "on-keypress", "on-keyup", "on-click", "on-focus", "on-blur", "on-change", "on-input-change", "on-clear", "update:modelValue"],
  props: {
    type: {
      validator(value) {
        return oneOf(value, ["text", "textarea", "password", "url", "email", "date", "number", "tel"]);
      },
      default: "text"
    },
    modelValue: {
      type: [String, Number],
      default: ""
    },
    size: {
      validator(value) {
        return oneOf(value, ["small", "large", "default"]);
      },
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.size === "" ? "default" : global2.$VIEWUI.size;
      }
    },
    placeholder: {
      type: String,
      default: ""
    },
    maxlength: {
      type: [String, Number]
    },
    disabled: {
      type: Boolean,
      default: false
    },
    icon: String,
    autosize: {
      type: [Boolean, Object],
      default: false
    },
    rows: {
      type: Number,
      default: 2
    },
    readonly: {
      type: Boolean,
      default: false
    },
    name: {
      type: String
    },
    number: {
      type: Boolean,
      default: false
    },
    autofocus: {
      type: Boolean,
      default: false
    },
    spellcheck: {
      type: Boolean,
      default: false
    },
    autocomplete: {
      type: String,
      default: "off"
    },
    clearable: {
      type: Boolean,
      default: false
    },
    elementId: {
      type: String
    },
    wrap: {
      validator(value) {
        return oneOf(value, ["hard", "soft"]);
      },
      default: "soft"
    },
    prefix: {
      type: String,
      default: ""
    },
    suffix: {
      type: String,
      default: ""
    },
    search: {
      type: Boolean,
      default: false
    },
    enterButton: {
      type: [Boolean, String],
      default: false
    },
    showWordLimit: {
      type: Boolean,
      default: false
    },
    password: {
      type: Boolean,
      default: false
    },
    border: {
      type: Boolean,
      default: true
    }
  },
  data() {
    return {
      currentValue: this.modelValue,
      prefixCls: prefixCls$1g,
      slotReady: false,
      textareaStyles: {},
      isOnComposition: false,
      showPassword: false,
      clearableIconOffset: 0
    };
  },
  computed: {
    currentType() {
      let type2 = this.type;
      if (type2 === "password" && this.password && this.showPassword)
        type2 = "text";
      return type2;
    },
    prepend() {
      let state = false;
      if (this.type !== "textarea")
        state = this.$slots.prepend !== void 0;
      return state;
    },
    append() {
      let state = false;
      if (this.type !== "textarea")
        state = this.$slots.append !== void 0;
      return state;
    },
    showPrefix() {
      let state = false;
      if (this.type !== "textarea")
        state = this.prefix !== "" || this.$slots.prefix !== void 0;
      return state;
    },
    showSuffix() {
      let state = false;
      if (this.type !== "textarea")
        state = this.suffix !== "" || this.$slots.suffix !== void 0;
      return state;
    },
    wrapClasses() {
      return [
        `${prefixCls$1g}-wrapper`,
        {
          [`${prefixCls$1g}-wrapper-${this.size}`]: !!this.size,
          [`${prefixCls$1g}-type-${this.type}`]: this.type,
          [`${prefixCls$1g}-group`]: this.prepend || this.append || this.search && this.enterButton,
          [`${prefixCls$1g}-group-${this.size}`]: (this.prepend || this.append || this.search && this.enterButton) && !!this.size,
          [`${prefixCls$1g}-group-with-prepend`]: this.prepend,
          [`${prefixCls$1g}-group-with-append`]: this.append || this.search && this.enterButton,
          [`${prefixCls$1g}-hide-icon`]: this.append,
          [`${prefixCls$1g}-with-search`]: this.search && this.enterButton,
          [`${prefixCls$1g}-wrapper-disabled`]: this.itemDisabled
        }
      ];
    },
    inputClasses() {
      return [
        `${prefixCls$1g}`,
        {
          [`${prefixCls$1g}-${this.size}`]: !!this.size,
          [`${prefixCls$1g}-disabled`]: this.itemDisabled,
          [`${prefixCls$1g}-no-border`]: !this.border,
          [`${prefixCls$1g}-with-prefix`]: this.showPrefix,
          [`${prefixCls$1g}-with-suffix`]: this.showSuffix || this.search && this.enterButton === false
        }
      ];
    },
    textareaClasses() {
      return [
        `${prefixCls$1g}`,
        {
          [`${prefixCls$1g}-disabled`]: this.itemDisabled,
          [`${prefixCls$1g}-no-border`]: !this.border
        }
      ];
    },
    upperLimit() {
      return this.maxlength;
    },
    textLength() {
      if (typeof this.modelValue === "number") {
        return String(this.modelValue).length;
      }
      return (this.modelValue || "").length;
    },
    clearableStyles() {
      const style2 = {};
      let offset = this.clearableIconOffset;
      if (offset)
        style2.transform = `translateX(-${offset}px)`;
      return style2;
    }
  },
  methods: {
    handleEnter(event) {
      this.$emit("on-enter", event);
      if (this.search)
        this.$emit("on-search", this.currentValue);
    },
    handleKeydown(event) {
      this.$emit("on-keydown", event);
    },
    handleKeypress(event) {
      this.$emit("on-keypress", event);
    },
    handleKeyup(event) {
      this.$emit("on-keyup", event);
    },
    handleIconClick(event) {
      this.$emit("on-click", event);
    },
    handleFocus(event) {
      this.$emit("on-focus", event);
    },
    handleBlur(event) {
      this.$emit("on-blur", event);
      if (!findComponentUpward(this, ["DatePicker", "TimePicker", "Cascader", "Search"])) {
        this.handleFormItemChange("blur", this.currentValue);
      }
    },
    handleComposition(event) {
      if (event.type === "compositionstart") {
        this.isOnComposition = true;
      }
      if (event.type === "compositionend") {
        this.isOnComposition = false;
        this.handleInput(event);
      }
    },
    handleInput(event) {
      if (this.isOnComposition)
        return;
      let value = event.target.value;
      if (this.number && value !== "")
        value = Number.isNaN(Number(value)) ? value : Number(value);
      this.$emit("update:modelValue", value);
      this.setCurrentValue(value);
      this.$emit("on-change", event);
    },
    handleChange(event) {
      this.$emit("on-input-change", event);
    },
    setCurrentValue(value) {
      if (value === this.currentValue)
        return;
      nextTick(() => {
        this.resizeTextarea();
      });
      this.currentValue = value;
      if (!findComponentUpward(this, ["DatePicker", "TimePicker", "Cascader", "Search"])) {
        this.handleFormItemChange("change", value);
      }
    },
    resizeTextarea() {
      const autosize = this.autosize;
      if (!autosize || this.type !== "textarea") {
        return false;
      }
      const minRows = autosize.minRows;
      const maxRows = autosize.maxRows;
      this.textareaStyles = calcTextareaHeight(this.$refs.textarea, minRows, maxRows);
    },
    focus(option) {
      const $el = this.type === "textarea" ? this.$refs.textarea : this.$refs.input;
      $el.focus(option);
      const { cursor } = option || {};
      if (cursor) {
        const len = $el.value.length;
        switch (cursor) {
          case "start":
            $el.setSelectionRange(0, 0);
            break;
          case "end":
            $el.setSelectionRange(len, len);
            break;
          default:
            $el.setSelectionRange(0, len);
        }
      }
    },
    blur() {
      if (this.type === "textarea") {
        this.$refs.textarea.blur();
      } else {
        this.$refs.input.blur();
      }
    },
    handleClear() {
      const e = { target: { value: "" } };
      this.$emit("update:modelValue", "");
      this.setCurrentValue("");
      this.$emit("on-change", e);
      this.$emit("on-clear");
    },
    handleSearch() {
      if (this.itemDisabled)
        return false;
      this.$refs.input.focus();
      this.$emit("on-search", this.currentValue);
    },
    handleToggleShowPassword() {
      if (this.itemDisabled)
        return false;
      this.showPassword = !this.showPassword;
      this.focus();
      const len = this.currentValue.length;
      setTimeout(() => {
        this.$refs.input.setSelectionRange(len, len);
      }, 0);
    },
    handleCalcIconOffset() {
      const $el = this.$el.querySelectorAll(".ivu-input-group-append")[0];
      if ($el) {
        this.clearableIconOffset = $el.offsetWidth;
      } else {
        this.clearableIconOffset = 0;
      }
    }
  },
  watch: {
    modelValue(val) {
      this.setCurrentValue(val);
    },
    type() {
      nextTick(this.handleCalcIconOffset);
    }
  },
  mounted() {
    this.slotReady = true;
    this.resizeTextarea();
    this.handleCalcIconOffset();
  },
  updated() {
    nextTick(this.handleCalcIconOffset);
  }
};
const _hoisted_1$1e = {
  key: 4,
  class: "ivu-input-suffix"
};
const _hoisted_2$J = {
  key: 5,
  class: "ivu-input-word-count"
};
const _hoisted_3$x = {
  key: 0,
  class: "ivu-icon ivu-icon-ios-eye-outline"
};
const _hoisted_4$p = {
  key: 1,
  class: "ivu-icon ivu-icon-ios-eye-off-outline"
};
const _hoisted_5$i = ["id", "autocomplete", "spellcheck", "type", "placeholder", "disabled", "maxlength", "readonly", "name", "value", "number", "autofocus"];
const _hoisted_6$8 = {
  key: 0,
  class: "ivu-icon ivu-icon-ios-search"
};
const _hoisted_7$7 = {
  key: 9,
  class: "ivu-input-prefix"
};
const _hoisted_8$4 = ["id", "wrap", "autocomplete", "spellcheck", "placeholder", "disabled", "rows", "maxlength", "readonly", "name", "value", "autofocus"];
const _hoisted_9$4 = {
  key: 0,
  class: "ivu-input-word-count"
};
function _sfc_render$25(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.wrapClasses)
  }, [
    $props.type !== "textarea" ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
      $options.prepend ? withDirectives((openBlock(), createElementBlock("div", {
        key: 0,
        class: normalizeClass([$data.prefixCls + "-group-prepend"])
      }, [
        renderSlot(_ctx.$slots, "prepend")
      ], 2)), [
        [vShow, $data.slotReady]
      ]) : createCommentVNode("", true),
      $props.clearable && $data.currentValue && !_ctx.itemDisabled ? (openBlock(), createElementBlock("i", {
        key: 1,
        class: normalizeClass(["ivu-icon", ["ivu-icon-ios-close-circle", $data.prefixCls + "-icon", $data.prefixCls + "-icon-clear", $data.prefixCls + "-icon-normal"]]),
        onClick: _cache[0] || (_cache[0] = (...args) => $options.handleClear && $options.handleClear(...args)),
        style: normalizeStyle($options.clearableStyles)
      }, null, 6)) : $props.icon ? (openBlock(), createElementBlock("i", {
        key: 2,
        class: normalizeClass(["ivu-icon", ["ivu-icon-" + $props.icon, $data.prefixCls + "-icon", $data.prefixCls + "-icon-normal"]]),
        onClick: _cache[1] || (_cache[1] = (...args) => $options.handleIconClick && $options.handleIconClick(...args))
      }, null, 2)) : $props.search && $props.enterButton === false ? (openBlock(), createElementBlock("i", {
        key: 3,
        class: normalizeClass(["ivu-icon ivu-icon-ios-search", [$data.prefixCls + "-icon", $data.prefixCls + "-icon-normal", $data.prefixCls + "-search-icon"]]),
        onClick: _cache[2] || (_cache[2] = (...args) => $options.handleSearch && $options.handleSearch(...args))
      }, null, 2)) : $options.showSuffix ? (openBlock(), createElementBlock("span", _hoisted_1$1e, [
        renderSlot(_ctx.$slots, "suffix", {}, () => [
          $props.suffix ? (openBlock(), createElementBlock("i", {
            key: 0,
            class: normalizeClass(["ivu-icon", ["ivu-icon-" + $props.suffix]])
          }, null, 2)) : createCommentVNode("", true)
        ])
      ])) : $props.showWordLimit ? (openBlock(), createElementBlock("span", _hoisted_2$J, toDisplayString($options.textLength) + "/" + toDisplayString($options.upperLimit), 1)) : $props.password ? (openBlock(), createElementBlock("span", {
        key: 6,
        class: "ivu-input-suffix",
        onClick: _cache[3] || (_cache[3] = (...args) => $options.handleToggleShowPassword && $options.handleToggleShowPassword(...args))
      }, [
        $data.showPassword ? (openBlock(), createElementBlock("i", _hoisted_3$x)) : (openBlock(), createElementBlock("i", _hoisted_4$p))
      ])) : createCommentVNode("", true),
      createVNode(Transition, { name: "fade" }, {
        default: withCtx(() => [
          !$props.icon ? (openBlock(), createElementBlock("i", {
            key: 0,
            class: normalizeClass(["ivu-icon ivu-icon-ios-loading ivu-load-loop", [$data.prefixCls + "-icon", $data.prefixCls + "-icon-validate"]])
          }, null, 2)) : createCommentVNode("", true)
        ]),
        _: 1
      }),
      createElementVNode("input", {
        id: $props.elementId,
        autocomplete: $props.autocomplete,
        spellcheck: $props.spellcheck,
        ref: "input",
        type: $options.currentType,
        class: normalizeClass($options.inputClasses),
        placeholder: $props.placeholder,
        disabled: _ctx.itemDisabled,
        maxlength: $props.maxlength,
        readonly: $props.readonly,
        name: $props.name,
        value: $data.currentValue,
        number: $props.number,
        autofocus: $props.autofocus,
        onKeyup: [
          _cache[4] || (_cache[4] = withKeys((...args) => $options.handleEnter && $options.handleEnter(...args), ["enter"])),
          _cache[5] || (_cache[5] = (...args) => $options.handleKeyup && $options.handleKeyup(...args))
        ],
        onKeypress: _cache[6] || (_cache[6] = (...args) => $options.handleKeypress && $options.handleKeypress(...args)),
        onKeydown: _cache[7] || (_cache[7] = (...args) => $options.handleKeydown && $options.handleKeydown(...args)),
        onFocus: _cache[8] || (_cache[8] = (...args) => $options.handleFocus && $options.handleFocus(...args)),
        onBlur: _cache[9] || (_cache[9] = (...args) => $options.handleBlur && $options.handleBlur(...args)),
        onCompositionstart: _cache[10] || (_cache[10] = (...args) => $options.handleComposition && $options.handleComposition(...args)),
        onCompositionupdate: _cache[11] || (_cache[11] = (...args) => $options.handleComposition && $options.handleComposition(...args)),
        onCompositionend: _cache[12] || (_cache[12] = (...args) => $options.handleComposition && $options.handleComposition(...args)),
        onInput: _cache[13] || (_cache[13] = (...args) => $options.handleInput && $options.handleInput(...args)),
        onChange: _cache[14] || (_cache[14] = (...args) => $options.handleChange && $options.handleChange(...args))
      }, null, 42, _hoisted_5$i),
      $options.append ? withDirectives((openBlock(), createElementBlock("div", {
        key: 7,
        class: normalizeClass([$data.prefixCls + "-group-append"])
      }, [
        renderSlot(_ctx.$slots, "append")
      ], 2)), [
        [vShow, $data.slotReady]
      ]) : $props.search && $props.enterButton ? (openBlock(), createElementBlock("div", {
        key: 8,
        class: normalizeClass([$data.prefixCls + "-group-append", $data.prefixCls + "-search"]),
        onClick: _cache[15] || (_cache[15] = (...args) => $options.handleSearch && $options.handleSearch(...args))
      }, [
        $props.enterButton === true ? (openBlock(), createElementBlock("i", _hoisted_6$8)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
          createTextVNode(toDisplayString($props.enterButton), 1)
        ], 64))
      ], 2)) : $options.showPrefix ? (openBlock(), createElementBlock("span", _hoisted_7$7, [
        renderSlot(_ctx.$slots, "prefix", {}, () => [
          $props.prefix ? (openBlock(), createElementBlock("i", {
            key: 0,
            class: normalizeClass(["ivu-icon", ["ivu-icon-" + $props.prefix]])
          }, null, 2)) : createCommentVNode("", true)
        ])
      ])) : createCommentVNode("", true)
    ], 64)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
      createElementVNode("textarea", {
        id: $props.elementId,
        wrap: $props.wrap,
        autocomplete: $props.autocomplete,
        spellcheck: $props.spellcheck,
        ref: "textarea",
        class: normalizeClass($options.textareaClasses),
        style: normalizeStyle($data.textareaStyles),
        placeholder: $props.placeholder,
        disabled: _ctx.itemDisabled,
        rows: $props.rows,
        maxlength: $props.maxlength,
        readonly: $props.readonly,
        name: $props.name,
        value: $data.currentValue,
        autofocus: $props.autofocus,
        onKeyup: [
          _cache[16] || (_cache[16] = withKeys((...args) => $options.handleEnter && $options.handleEnter(...args), ["enter"])),
          _cache[17] || (_cache[17] = (...args) => $options.handleKeyup && $options.handleKeyup(...args))
        ],
        onKeypress: _cache[18] || (_cache[18] = (...args) => $options.handleKeypress && $options.handleKeypress(...args)),
        onKeydown: _cache[19] || (_cache[19] = (...args) => $options.handleKeydown && $options.handleKeydown(...args)),
        onFocus: _cache[20] || (_cache[20] = (...args) => $options.handleFocus && $options.handleFocus(...args)),
        onBlur: _cache[21] || (_cache[21] = (...args) => $options.handleBlur && $options.handleBlur(...args)),
        onCompositionstart: _cache[22] || (_cache[22] = (...args) => $options.handleComposition && $options.handleComposition(...args)),
        onCompositionupdate: _cache[23] || (_cache[23] = (...args) => $options.handleComposition && $options.handleComposition(...args)),
        onCompositionend: _cache[24] || (_cache[24] = (...args) => $options.handleComposition && $options.handleComposition(...args)),
        onInput: _cache[25] || (_cache[25] = (...args) => $options.handleInput && $options.handleInput(...args))
      }, "            ", 46, _hoisted_8$4),
      $props.showWordLimit ? (openBlock(), createElementBlock("span", _hoisted_9$4, toDisplayString($options.textLength) + "/" + toDisplayString($options.upperLimit), 1)) : createCommentVNode("", true)
    ], 64))
  ], 2);
}
var Input = /* @__PURE__ */ _export_sfc(_sfc_main$2l, [["render", _sfc_render$25]]);
const _sfc_main$2k = {
  name: "AutoComplete",
  mixins: [mixinsForm],
  components: { iSelect: Select, iOption, iInput: Input },
  emits: ["update:modelValue", "on-change", "on-search", "on-select", "on-focus", "on-blur", "on-clear"],
  props: {
    modelValue: {
      type: [String, Number],
      default: ""
    },
    label: {
      type: [String, Number],
      default: ""
    },
    data: {
      type: Array,
      default: () => []
    },
    disabled: {
      type: Boolean,
      default: false
    },
    clearable: {
      type: Boolean,
      default: false
    },
    placeholder: {
      type: String
    },
    size: {
      validator(value) {
        return oneOf(value, ["small", "large", "default"]);
      },
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.size === "" ? "default" : global2.$VIEWUI.size;
      }
    },
    icon: {
      type: String
    },
    filterMethod: {
      type: [Function, Boolean],
      default: false
    },
    placement: {
      validator(value) {
        return oneOf(value, ["top", "bottom", "top-start", "bottom-start", "top-end", "bottom-end"]);
      },
      default: "bottom-start"
    },
    transfer: {
      type: Boolean,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.transfer === "" ? false : global2.$VIEWUI.transfer;
      }
    },
    name: {
      type: String
    },
    elementId: {
      type: String
    },
    transferClassName: {
      type: String
    },
    capture: {
      type: Boolean,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI ? true : global2.$VIEWUI.capture;
      }
    },
    eventsEnabled: {
      type: Boolean,
      default: false
    }
  },
  data() {
    return {
      currentValue: this.modelValue,
      disableEmitChange: false
    };
  },
  computed: {
    inputIcon() {
      let icon = "";
      if (this.clearable && this.currentValue && !this.disabled) {
        icon = "ios-close-circle";
      } else if (this.icon) {
        icon = this.icon;
      }
      return icon;
    },
    filteredData() {
      if (this.filterMethod) {
        return this.data.filter((item) => this.filterMethod(this.currentValue, item));
      } else {
        return this.data;
      }
    }
  },
  watch: {
    modelValue(val) {
      if (this.currentValue !== val) {
        this.disableEmitChange = true;
      }
      this.currentValue = val;
    },
    currentValue(val) {
      this.$refs.select.setQuery(val);
      this.$emit("update:modelValue", val);
      if (this.disableEmitChange) {
        this.disableEmitChange = false;
        return;
      }
      this.$emit("on-change", val);
      this.handleFormItemChange("change", val);
    }
  },
  methods: {
    remoteMethod(query) {
      this.$emit("on-search", query);
    },
    handleSelect(option) {
      const val = option.value;
      if (val === void 0 || val === null)
        return;
      this.currentValue = val;
      this.$refs.input.blur();
      this.$emit("on-select", val);
    },
    handleFocus(event) {
      this.$emit("on-focus", event);
    },
    handleBlur(event) {
      this.$emit("on-blur", event);
    },
    handleClear() {
      if (!this.clearable)
        return;
      this.currentValue = "";
      this.$refs.select.reset();
      this.$emit("on-clear");
    },
    handleClickOutside() {
      nextTick(() => {
        this.$refs.input.blur();
      });
    }
  }
};
function _sfc_render$24(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_i_input = resolveComponent("i-input");
  const _component_i_option = resolveComponent("i-option");
  const _component_i_select = resolveComponent("i-select");
  return openBlock(), createBlock(_component_i_select, {
    ref: "select",
    class: "ivu-auto-complete",
    label: $props.label,
    disabled: _ctx.itemDisabled,
    clearable: $props.clearable,
    placeholder: $props.placeholder,
    size: $props.size,
    placement: $props.placement,
    "model-value": $data.currentValue,
    "transfer-class-name": $props.transferClassName,
    filterable: "",
    remote: "",
    "auto-complete": "",
    "remote-method": $options.remoteMethod,
    onOnSelect: $options.handleSelect,
    onOnClickoutside: $options.handleClickOutside,
    transfer: $props.transfer,
    capture: $props.capture,
    eventsEnabled: $props.eventsEnabled
  }, {
    input: withCtx(() => [
      renderSlot(_ctx.$slots, "input", {}, () => [
        createVNode(_component_i_input, {
          "element-id": $props.elementId,
          ref: "input",
          modelValue: $data.currentValue,
          "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => $data.currentValue = $event),
          name: $props.name,
          placeholder: $props.placeholder,
          disabled: _ctx.itemDisabled,
          size: $props.size,
          icon: $options.inputIcon,
          onOnClick: $options.handleClear,
          onOnFocus: $options.handleFocus,
          onOnBlur: $options.handleBlur
        }, null, 8, ["element-id", "modelValue", "name", "placeholder", "disabled", "size", "icon", "onOnClick", "onOnFocus", "onOnBlur"])
      ])
    ]),
    default: withCtx(() => [
      renderSlot(_ctx.$slots, "default", {}, () => [
        (openBlock(true), createElementBlock(Fragment, null, renderList($options.filteredData, (item) => {
          return openBlock(), createBlock(_component_i_option, {
            value: item,
            key: item
          }, {
            default: withCtx(() => [
              createTextVNode(toDisplayString(item), 1)
            ]),
            _: 2
          }, 1032, ["value"]);
        }), 128))
      ])
    ]),
    _: 3
  }, 8, ["label", "disabled", "clearable", "placeholder", "size", "placement", "model-value", "transfer-class-name", "remote-method", "onOnSelect", "onOnClickoutside", "transfer", "capture", "eventsEnabled"]);
}
var AutoComplete = /* @__PURE__ */ _export_sfc(_sfc_main$2k, [["render", _sfc_render$24]]);
const prefixCls$1f = "ivu-avatar";
const sizeList = ["small", "large", "default"];
const _sfc_main$2j = {
  name: "Avatar",
  components: { Icon },
  emits: ["on-error"],
  props: {
    shape: {
      validator(value) {
        return oneOf(value, ["circle", "square"]);
      },
      default: "circle"
    },
    size: {
      type: [String, Number],
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.size === "" ? "default" : global2.$VIEWUI.size;
      }
    },
    src: {
      type: String
    },
    icon: {
      type: String
    },
    customIcon: {
      type: String,
      default: ""
    }
  },
  data() {
    return {
      prefixCls: prefixCls$1f,
      scale: 1,
      childrenWidth: 0,
      isSlotShow: false,
      slotTemp: null
    };
  },
  computed: {
    classes() {
      return [
        `${prefixCls$1f}`,
        `${prefixCls$1f}-${this.shape}`,
        {
          [`${prefixCls$1f}-image`]: !!this.src,
          [`${prefixCls$1f}-icon`]: !!this.icon || !!this.customIcon,
          [`${prefixCls$1f}-${this.size}`]: oneOf(this.size, sizeList)
        }
      ];
    },
    styles() {
      let style2 = {};
      if (this.size && !oneOf(this.size, sizeList)) {
        style2.width = `${this.size}px`;
        style2.height = `${this.size}px`;
        style2.lineHeight = `${this.size}px`;
        style2.fontSize = `${this.size / 2}px`;
      }
      return style2;
    },
    childrenStyle() {
      let style2 = {};
      if (this.isSlotShow) {
        style2 = {
          msTransform: `scale(${this.scale})`,
          WebkitTransform: `scale(${this.scale})`,
          transform: `scale(${this.scale})`,
          position: "absolute",
          display: "inline-block",
          left: `calc(50% - ${Math.round(this.childrenWidth / 2)}px)`
        };
      }
      return style2;
    }
  },
  watch: {
    size(val, oldVal) {
      if (val !== oldVal)
        this.setScale();
    }
  },
  methods: {
    setScale() {
      this.isSlotShow = !this.src && !this.icon;
      if (this.$refs.children) {
        this.childrenWidth = this.$refs.children.offsetWidth;
        const avatarWidth = this.$el.getBoundingClientRect().width;
        if (avatarWidth - 8 < this.childrenWidth) {
          this.scale = (avatarWidth - 8) / this.childrenWidth;
        } else {
          this.scale = 1;
        }
      }
    },
    handleError(e) {
      this.$emit("on-error", e);
    }
  },
  beforeCreate() {
    this.slotTemp = this.$slots.default ? this.$slots.default() : null;
  },
  mounted() {
    this.setScale();
  },
  updated() {
    const slot = this.$slots.default ? this.$slots.default() : null;
    if (slot && slot !== this.slotTemp)
      this.setScale();
  }
};
const _hoisted_1$1d = ["src"];
function _sfc_render$23(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = resolveComponent("Icon");
  return openBlock(), createElementBlock("span", {
    class: normalizeClass($options.classes),
    style: normalizeStyle($options.styles)
  }, [
    $props.src ? (openBlock(), createElementBlock("img", {
      key: 0,
      src: $props.src,
      onError: _cache[0] || (_cache[0] = (...args) => $options.handleError && $options.handleError(...args))
    }, null, 40, _hoisted_1$1d)) : $props.icon || $props.customIcon ? (openBlock(), createBlock(_component_Icon, {
      key: 1,
      type: $props.icon,
      custom: $props.customIcon
    }, null, 8, ["type", "custom"])) : (openBlock(), createElementBlock("span", {
      key: 2,
      ref: "children",
      class: normalizeClass([$data.prefixCls + "-string"]),
      style: normalizeStyle($options.childrenStyle)
    }, [
      renderSlot(_ctx.$slots, "default")
    ], 6))
  ], 6);
}
var Avatar = /* @__PURE__ */ _export_sfc(_sfc_main$2j, [["render", _sfc_render$23]]);
var Popper = {
  emits: ["on-popper-show", "on-popper-hide", "created", "update:modelValue"],
  props: {
    eventsEnabled: {
      type: Boolean,
      default: false
    },
    placement: {
      type: String,
      default: "bottom"
    },
    boundariesPadding: {
      type: Number,
      default: 5
    },
    reference: Object,
    popper: Object,
    offset: {
      default: 0
    },
    modelValue: {
      type: Boolean,
      default: false
    },
    transition: String,
    options: {
      type: Object,
      default() {
        return {
          modifiers: {
            computeStyle: {
              gpuAcceleration: false
            },
            preventOverflow: {
              boundariesElement: "window"
            }
          }
        };
      }
    }
  },
  data() {
    return {
      visible: this.modelValue
    };
  },
  watch: {
    modelValue: {
      immediate: true,
      handler(val) {
        this.visible = val;
        this.$emit("update:modelValue", val);
      }
    },
    visible(val) {
      if (val) {
        if (this.handleIndexIncrease)
          this.handleIndexIncrease();
        this.updatePopper();
        this.$emit("on-popper-show");
      } else {
        this.$emit("on-popper-hide");
      }
      this.$emit("update:modelValue", val);
    }
  },
  methods: {
    createPopper() {
      if (!/^(top|bottom|left|right)(-start|-end)?$/g.test(this.placement)) {
        return;
      }
      const options = this.options;
      const popper2 = this.popper || this.$refs.popper;
      const reference = this.reference || this.$refs.reference;
      if (!popper2 || !reference)
        return;
      if (this.popperJS && this.popperJS.hasOwnProperty("destroy")) {
        this.popperJS.destroy();
      }
      options.eventsEnabled = this.eventsEnabled;
      options.placement = this.placement;
      if (!options.modifiers.offset) {
        options.modifiers.offset = {};
      }
      options.modifiers.offset.offset = this.offset;
      options.onCreate = () => {
        nextTick(this.updatePopper);
        this.$emit("created", this);
      };
      this.popperJS = new Popper$1(reference, popper2, options);
    },
    updatePopper() {
      this.popperJS ? this.popperJS.update() : this.createPopper();
    },
    doDestroy() {
      if (this.visible)
        return;
      this.popperJS.destroy();
      this.popperJS = null;
    }
  },
  updated() {
    nextTick(() => this.updatePopper());
  },
  beforeUnmount() {
    if (this.popperJS) {
      this.popperJS.destroy();
    }
  }
};
const prefixCls$1e = "ivu-tooltip";
const _sfc_main$2i = {
  name: "Tooltip",
  mixins: [Popper],
  props: {
    placement: {
      validator(value) {
        return oneOf(value, ["top", "top-start", "top-end", "bottom", "bottom-start", "bottom-end", "left", "left-start", "left-end", "right", "right-start", "right-end"]);
      },
      default: "bottom"
    },
    content: {
      type: [String, Number],
      default: ""
    },
    delay: {
      type: Number,
      default: 100
    },
    disabled: {
      type: Boolean,
      default: false
    },
    controlled: {
      type: Boolean,
      default: false
    },
    always: {
      type: Boolean,
      default: false
    },
    transfer: {
      type: Boolean,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.transfer === "" ? false : global2.$VIEWUI.transfer;
      }
    },
    theme: {
      validator(value) {
        return oneOf(value, ["dark", "light"]);
      },
      default: "dark"
    },
    maxWidth: {
      type: [String, Number]
    },
    transferClassName: {
      type: String
    }
  },
  data() {
    return {
      prefixCls: prefixCls$1e,
      tIndex: this.handleGetIndex()
    };
  },
  computed: {
    innerStyles() {
      const styles = {};
      if (this.maxWidth)
        styles["max-width"] = `${this.maxWidth}px`;
      return styles;
    },
    innerClasses() {
      return [
        `${prefixCls$1e}-inner`,
        {
          [`${prefixCls$1e}-inner-with-width`]: !!this.maxWidth
        }
      ];
    },
    dropStyles() {
      let styles = {};
      if (this.transfer)
        styles["z-index"] = 1060 + this.tIndex;
      return styles;
    },
    dropdownCls() {
      return [
        `${prefixCls$1e}-popper`,
        `${prefixCls$1e}-${this.theme}`,
        {
          [prefixCls$1e + "-transfer"]: this.transfer,
          [this.transferClassName]: this.transferClassName
        }
      ];
    }
  },
  watch: {
    content() {
      this.updatePopper();
    }
  },
  methods: {
    handleShowPopper() {
      if (this.timeout)
        clearTimeout(this.timeout);
      this.timeout = setTimeout(() => {
        this.visible = true;
      }, this.delay);
      this.tIndex = this.handleGetIndex();
    },
    handleClosePopper() {
      if (this.timeout) {
        clearTimeout(this.timeout);
        if (!this.controlled) {
          this.timeout = setTimeout(() => {
            this.visible = false;
          }, 100);
        }
      }
    },
    handleGetIndex() {
      transferIncrease();
      return transferIndex;
    }
  },
  mounted() {
    if (this.always) {
      this.updatePopper();
    }
  }
};
function _sfc_render$22(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass([$data.prefixCls]),
    onMouseenter: _cache[2] || (_cache[2] = (...args) => $options.handleShowPopper && $options.handleShowPopper(...args)),
    onMouseleave: _cache[3] || (_cache[3] = (...args) => $options.handleClosePopper && $options.handleClosePopper(...args))
  }, [
    createElementVNode("div", {
      class: normalizeClass([$data.prefixCls + "-rel"]),
      ref: "reference"
    }, [
      renderSlot(_ctx.$slots, "default")
    ], 2),
    (openBlock(), createBlock(Teleport, {
      to: "body",
      disabled: !$props.transfer
    }, [
      createVNode(Transition, { name: "fade" }, {
        default: withCtx(() => [
          withDirectives(createElementVNode("div", {
            ref: "popper",
            class: normalizeClass($options.dropdownCls),
            style: normalizeStyle($options.dropStyles),
            onMouseenter: _cache[0] || (_cache[0] = (...args) => $options.handleShowPopper && $options.handleShowPopper(...args)),
            onMouseleave: _cache[1] || (_cache[1] = (...args) => $options.handleClosePopper && $options.handleClosePopper(...args))
          }, [
            createElementVNode("div", {
              class: normalizeClass([$data.prefixCls + "-content"])
            }, [
              createElementVNode("div", {
                class: normalizeClass([$data.prefixCls + "-arrow"])
              }, null, 2),
              createElementVNode("div", {
                class: normalizeClass($options.innerClasses),
                style: normalizeStyle($options.innerStyles)
              }, [
                renderSlot(_ctx.$slots, "content", {}, () => [
                  createTextVNode(toDisplayString($props.content), 1)
                ])
              ], 6)
            ], 2)
          ], 38), [
            [vShow, !$props.disabled && (_ctx.visible || $props.always)]
          ])
        ]),
        _: 3
      })
    ], 8, ["disabled"]))
  ], 34);
}
var Tooltip = /* @__PURE__ */ _export_sfc(_sfc_main$2i, [["render", _sfc_render$22]]);
const _sfc_main$2h = {
  name: "AvatarList",
  components: { Avatar, Tooltip },
  props: {
    list: {
      type: Array,
      default() {
        return [];
      }
    },
    shape: {
      validator(value) {
        return oneOf(value, ["circle", "square"]);
      },
      default: "circle"
    },
    size: {
      validator(value) {
        return oneOf(value, ["small", "large", "default"]);
      },
      default: "default"
    },
    excessStyle: {
      type: Object,
      default() {
        return {};
      }
    },
    max: {
      type: Number
    },
    tooltip: {
      type: Boolean,
      default: true
    },
    placement: {
      validator(value) {
        return oneOf(value, ["top", "top-start", "top-end", "bottom", "bottom-start", "bottom-end", "left", "left-start", "left-end", "right", "right-start", "right-end"]);
      },
      default: "top"
    },
    transfer: {
      type: Boolean,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.transfer === "" ? false : global2.$VIEWUI.transfer;
      }
    }
  },
  computed: {
    currentList() {
      const len = this.list.length;
      const max = this.max;
      if (len <= max) {
        return [...this.list];
      } else {
        return [...this.list].slice(0, max);
      }
    }
  }
};
const _hoisted_1$1c = {
  key: 0,
  class: "ivu-avatar-list-item ivu-avatar-list-item-excess"
};
const _hoisted_2$I = {
  key: 1,
  class: "ivu-avatar-list-item ivu-avatar-list-item-excess"
};
function _sfc_render$21(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Avatar = resolveComponent("Avatar");
  const _component_Tooltip = resolveComponent("Tooltip");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(["ivu-avatar-list", "ivu-avatar-list-" + $props.size])
  }, [
    (openBlock(true), createElementBlock(Fragment, null, renderList($options.currentList, (item, index2) => {
      return openBlock(), createElementBlock("div", {
        class: "ivu-avatar-list-item",
        key: index2
      }, [
        $props.tooltip && item.tip ? (openBlock(), createBlock(_component_Tooltip, {
          key: 0,
          content: item.tip,
          placement: $props.placement,
          transfer: $props.transfer
        }, {
          default: withCtx(() => [
            createVNode(_component_Avatar, {
              src: item.src,
              size: $props.size,
              shape: $props.shape
            }, null, 8, ["src", "size", "shape"])
          ]),
          _: 2
        }, 1032, ["content", "placement", "transfer"])) : (openBlock(), createBlock(_component_Avatar, {
          key: 1,
          src: item.src,
          size: $props.size,
          shape: $props.shape
        }, null, 8, ["src", "size", "shape"]))
      ]);
    }), 128)),
    _ctx.$slots.extra ? (openBlock(), createElementBlock("div", _hoisted_1$1c, [
      createVNode(_component_Avatar, {
        size: $props.size,
        shape: $props.shape,
        style: normalizeStyle($props.excessStyle)
      }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "extra")
        ]),
        _: 3
      }, 8, ["size", "shape", "style"])
    ])) : $props.list.length > $props.max ? (openBlock(), createElementBlock("div", _hoisted_2$I, [
      createVNode(_component_Avatar, {
        size: $props.size,
        shape: $props.shape,
        style: normalizeStyle($props.excessStyle)
      }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "excess", {}, () => [
            createTextVNode("+" + toDisplayString($props.list.length - $props.max), 1)
          ])
        ]),
        _: 3
      }, 8, ["size", "shape", "style"])
    ])) : createCommentVNode("", true)
  ], 2);
}
var AvatarList = /* @__PURE__ */ _export_sfc(_sfc_main$2h, [["render", _sfc_render$21]]);
const prefixCls$1d = "ivu-back-top";
const _sfc_main$2g = {
  name: "BackTop",
  emits: ["on-click"],
  props: {
    height: {
      type: Number,
      default: 400
    },
    bottom: {
      type: Number,
      default: 30
    },
    right: {
      type: Number,
      default: 30
    },
    duration: {
      type: Number,
      default: 1e3
    }
  },
  data() {
    return {
      backTop: false
    };
  },
  mounted() {
    on(window, "scroll", this.handleScroll);
    on(window, "resize", this.handleScroll);
  },
  beforeUnmount() {
    off(window, "scroll", this.handleScroll);
    off(window, "resize", this.handleScroll);
  },
  computed: {
    classes() {
      return [
        `${prefixCls$1d}`,
        {
          [`${prefixCls$1d}-show`]: this.backTop
        }
      ];
    },
    styles() {
      return {
        bottom: `${this.bottom}px`,
        right: `${this.right}px`
      };
    },
    innerClasses() {
      return `${prefixCls$1d}-inner`;
    }
  },
  methods: {
    handleScroll() {
      if (!isClient)
        return;
      this.backTop = window.pageYOffset >= this.height;
    },
    back() {
      if (!isClient)
        return;
      const sTop = document.documentElement.scrollTop || document.body.scrollTop;
      scrollTop(window, sTop, 0, this.duration);
      this.$emit("on-click");
    }
  }
};
function _sfc_render$20(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes),
    style: normalizeStyle($options.styles),
    onClick: _cache[0] || (_cache[0] = (...args) => $options.back && $options.back(...args))
  }, [
    renderSlot(_ctx.$slots, "default", {}, () => [
      createElementVNode("div", {
        class: normalizeClass($options.innerClasses)
      }, _cache[1] || (_cache[1] = [
        createElementVNode("i", { class: "ivu-icon ivu-icon-ios-arrow-up" }, null, -1)
      ]), 2)
    ])
  ], 6);
}
var BackTop = /* @__PURE__ */ _export_sfc(_sfc_main$2g, [["render", _sfc_render$20]]);
const initColorList$1 = ["blue", "green", "red", "yellow", "pink", "magenta", "volcano", "orange", "gold", "lime", "cyan", "geekblue", "purple"];
const prefixCls$1c = "ivu-badge";
const _sfc_main$2f = {
  name: "Badge",
  props: {
    count: Number,
    dot: {
      type: Boolean,
      default: false
    },
    overflowCount: {
      type: [Number, String],
      default: 99
    },
    className: String,
    showZero: {
      type: Boolean,
      default: false
    },
    text: {
      type: String,
      default: ""
    },
    status: {
      validator(value) {
        return oneOf(value, ["success", "processing", "default", "error", "warning"]);
      }
    },
    type: {
      validator(value) {
        return oneOf(value, ["success", "primary", "normal", "error", "warning", "info"]);
      }
    },
    offset: {
      type: Array
    },
    color: {
      type: String
    }
  },
  computed: {
    classes() {
      return `${prefixCls$1c}`;
    },
    dotClasses() {
      return `${prefixCls$1c}-dot`;
    },
    countClasses() {
      return [
        `${prefixCls$1c}-count`,
        {
          [`${this.className}`]: !!this.className,
          [`${prefixCls$1c}-count-alone`]: this.alone,
          [`${prefixCls$1c}-count-${this.type}`]: !!this.type
        }
      ];
    },
    customCountClasses() {
      return [
        `${prefixCls$1c}-count`,
        `${prefixCls$1c}-count-custom`,
        {
          [`${this.className}`]: !!this.className
        }
      ];
    },
    statusClasses() {
      return [
        `${prefixCls$1c}-status-dot`,
        {
          [`${prefixCls$1c}-status-${this.status}`]: !!this.status,
          [`${prefixCls$1c}-status-${this.color}`]: !!this.color && oneOf(this.color, initColorList$1)
        }
      ];
    },
    statusStyles() {
      return oneOf(this.color, initColorList$1) ? {} : { backgroundColor: this.color };
    },
    styles() {
      const style2 = {};
      if (this.offset && this.offset.length === 2) {
        style2["margin-top"] = `${this.offset[0]}px`;
        style2["margin-right"] = `${this.offset[1]}px`;
      }
      return style2;
    },
    finalCount() {
      if (this.text !== "")
        return this.text;
      return parseInt(this.count) >= parseInt(this.overflowCount) ? `${this.overflowCount}+` : this.count;
    },
    badge() {
      let status = false;
      if (this.count) {
        status = !(parseInt(this.count) === 0);
      }
      if (this.dot) {
        status = true;
        if (this.count !== null) {
          if (parseInt(this.count) === 0) {
            status = false;
          }
        }
      }
      if (this.text !== "")
        status = true;
      return status || this.showZero;
    },
    hasCount() {
      if (this.count || this.text !== "")
        return true;
      if (this.showZero && parseInt(this.count) === 0)
        return true;
      else
        return false;
    },
    alone() {
      return this.$slots.default === void 0;
    }
  }
};
const _hoisted_1$1b = { class: "ivu-badge-status-text" };
function _sfc_render$1$(_ctx, _cache, $props, $setup, $data, $options) {
  return $props.dot ? (openBlock(), createElementBlock("span", {
    key: 0,
    class: normalizeClass($options.classes),
    ref: "badge"
  }, [
    renderSlot(_ctx.$slots, "default"),
    withDirectives(createElementVNode("sup", {
      class: normalizeClass($options.dotClasses),
      style: normalizeStyle($options.styles)
    }, null, 6), [
      [vShow, $options.badge]
    ])
  ], 2)) : $props.status || $props.color ? (openBlock(), createElementBlock("span", {
    key: 1,
    class: normalizeClass([$options.classes, "ivu-badge-status"]),
    ref: "badge"
  }, [
    createElementVNode("span", {
      class: normalizeClass($options.statusClasses),
      style: normalizeStyle($options.statusStyles)
    }, null, 6),
    createElementVNode("span", _hoisted_1$1b, [
      renderSlot(_ctx.$slots, "text", {}, () => [
        createTextVNode(toDisplayString($props.text), 1)
      ])
    ])
  ], 2)) : (openBlock(), createElementBlock("span", {
    key: 2,
    class: normalizeClass($options.classes),
    ref: "badge"
  }, [
    renderSlot(_ctx.$slots, "default"),
    _ctx.$slots.count ? (openBlock(), createElementBlock("sup", {
      key: 0,
      style: normalizeStyle($options.styles),
      class: normalizeClass($options.customCountClasses)
    }, [
      renderSlot(_ctx.$slots, "count")
    ], 6)) : $options.hasCount ? withDirectives((openBlock(), createElementBlock("sup", {
      key: 1,
      style: normalizeStyle($options.styles),
      class: normalizeClass($options.countClasses)
    }, [
      renderSlot(_ctx.$slots, "text", {}, () => [
        createTextVNode(toDisplayString($options.finalCount), 1)
      ])
    ], 6)), [
      [vShow, $options.badge]
    ]) : createCommentVNode("", true)
  ], 2));
}
var Badge = /* @__PURE__ */ _export_sfc(_sfc_main$2f, [["render", _sfc_render$1$]]);
const _sfc_main$2e = {
  name: "Breadcrumb",
  provide() {
    return {
      BreadcrumbInstance: this
    };
  },
  props: {
    separator: {
      type: String,
      default: "/"
    }
  }
};
const _hoisted_1$1a = { class: "ivu-breadcrumb" };
function _sfc_render$1_(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", _hoisted_1$1a, [
    renderSlot(_ctx.$slots, "default")
  ]);
}
var Breadcrumb = /* @__PURE__ */ _export_sfc(_sfc_main$2e, [["render", _sfc_render$1_]]);
const prefixCls$1b = "ivu-breadcrumb-item";
const _sfc_main$2d = {
  name: "BreadcrumbItem",
  mixins: [mixinsLink],
  inject: ["BreadcrumbInstance"],
  props: {},
  data() {
    return {
      showSeparator: false
    };
  },
  computed: {
    linkClasses() {
      return `${prefixCls$1b}-link`;
    },
    separatorClasses() {
      return `${prefixCls$1b}-separator`;
    },
    separator() {
      return this.BreadcrumbInstance.separator;
    }
  },
  mounted() {
    this.showSeparator = this.$slots.separator !== void 0;
  }
};
const _hoisted_1$19 = ["href", "target"];
const _hoisted_2$H = ["innerHTML"];
function _sfc_render$1Z(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("span", null, [
    _ctx.to ? (openBlock(), createElementBlock("a", {
      key: 0,
      href: _ctx.linkUrl,
      target: _ctx.target,
      class: normalizeClass($options.linkClasses),
      onClick: [
        _cache[0] || (_cache[0] = withModifiers(($event) => _ctx.handleCheckClick($event, false), ["exact"])),
        _cache[1] || (_cache[1] = withModifiers(($event) => _ctx.handleCheckClick($event, true), ["ctrl"])),
        _cache[2] || (_cache[2] = withModifiers(($event) => _ctx.handleCheckClick($event, true), ["meta"]))
      ]
    }, [
      renderSlot(_ctx.$slots, "default")
    ], 10, _hoisted_1$19)) : (openBlock(), createElementBlock("span", {
      key: 1,
      class: normalizeClass($options.linkClasses)
    }, [
      renderSlot(_ctx.$slots, "default")
    ], 2)),
    !$data.showSeparator ? (openBlock(), createElementBlock("span", {
      key: 2,
      class: normalizeClass($options.separatorClasses),
      innerHTML: $options.separator
    }, null, 10, _hoisted_2$H)) : (openBlock(), createElementBlock("span", {
      key: 3,
      class: normalizeClass($options.separatorClasses)
    }, [
      renderSlot(_ctx.$slots, "separator")
    ], 2))
  ]);
}
var BreadcrumbItem = /* @__PURE__ */ _export_sfc(_sfc_main$2d, [["render", _sfc_render$1Z]]);
const prefixCls$1a = "ivu-btn";
const _sfc_main$2c = {
  name: "Button",
  mixins: [mixinsLink, mixinsForm],
  components: { Icon },
  emits: ["click"],
  props: {
    type: {
      validator(value) {
        return oneOf(value, ["default", "primary", "dashed", "text", "info", "success", "warning", "error"]);
      },
      default: "default"
    },
    shape: {
      validator(value) {
        return oneOf(value, ["circle", "circle-outline"]);
      }
    },
    size: {
      validator(value) {
        return oneOf(value, ["small", "large", "default"]);
      },
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.size === "" ? "default" : global2.$VIEWUI.size;
      }
    },
    loading: Boolean,
    disabled: Boolean,
    htmlType: {
      default: "button",
      validator(value) {
        return oneOf(value, ["button", "submit", "reset"]);
      }
    },
    icon: {
      type: String,
      default: ""
    },
    customIcon: {
      type: String,
      default: ""
    },
    long: {
      type: Boolean,
      default: false
    },
    ghost: {
      type: Boolean,
      default: false
    }
  },
  computed: {
    showSlot() {
      return !!this.$slots.default;
    },
    classes() {
      return [
        `${prefixCls$1a}`,
        `${prefixCls$1a}-${this.type}`,
        {
          [`${prefixCls$1a}-long`]: this.long,
          [`${prefixCls$1a}-${this.shape}`]: !!this.shape,
          [`${prefixCls$1a}-${this.size}`]: this.size !== "default",
          [`${prefixCls$1a}-loading`]: this.loading != null && this.loading,
          [`${prefixCls$1a}-icon-only`]: !this.showSlot && (!!this.icon || !!this.customIcon || this.loading),
          [`${prefixCls$1a}-ghost`]: this.ghost
        }
      ];
    },
    isHrefPattern() {
      const { to } = this;
      return !!to;
    },
    tagName() {
      const { isHrefPattern } = this;
      return isHrefPattern ? "a" : "button";
    },
    tagProps() {
      const { isHrefPattern } = this;
      if (isHrefPattern) {
        const { linkUrl, target } = this;
        return { href: linkUrl, target };
      } else {
        const { htmlType } = this;
        return { type: htmlType };
      }
    }
  },
  methods: {
    handleClickLink(event) {
      this.$emit("click", event);
      const openInNewWindow = event.ctrlKey || event.metaKey;
      this.handleCheckClick(event, openInNewWindow);
    }
  },
  render() {
    let tag;
    if (this.tagName === "button")
      tag = "button";
    else if (this.tagName === "a")
      tag = "a";
    let slots = [];
    if (this.loading) {
      slots.push(h(Icon, {
        class: "ivu-load-loop",
        type: "ios-loading"
      }));
    }
    if ((this.icon || this.customIcon) && !this.loading) {
      slots.push(h(Icon, {
        type: this.icon,
        custom: this.customIcon
      }));
    }
    if (this.$slots.default) {
      slots.push(h("span", {
        ref: "slot"
      }, this.$slots.default()));
    }
    return h(tag, {
      class: this.classes,
      disabled: this.itemDisabled,
      onClick: this.handleClickLink,
      ...this.tagProps
    }, slots);
  }
};
const prefixCls$19 = "ivu-btn-group";
const _sfc_main$2b = {
  name: "ButtonGroup",
  props: {
    size: {
      validator(value) {
        return oneOf(value, ["small", "large", "default"]);
      },
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.size === "" ? "default" : global2.$VIEWUI.size;
      }
    },
    shape: {
      validator(value) {
        return oneOf(value, ["circle", "circle-outline"]);
      }
    },
    vertical: {
      type: Boolean,
      default: false
    }
  },
  computed: {
    classes() {
      return [
        `${prefixCls$19}`,
        {
          [`${prefixCls$19}-${this.size}`]: !!this.size,
          [`${prefixCls$19}-${this.shape}`]: !!this.shape,
          [`${prefixCls$19}-vertical`]: this.vertical
        }
      ];
    }
  }
};
function _sfc_render$1Y(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes)
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 2);
}
var ButtonGroup = /* @__PURE__ */ _export_sfc(_sfc_main$2b, [["render", _sfc_render$1Y]]);
const prefixCls$18 = "ivu-radio-group";
let seed$1 = 0;
const now$2 = Date.now();
const getUuid$1 = () => `ivuRadioGroup_${now$2}_${seed$1++}`;
const _sfc_main$2a = {
  name: "RadioGroup",
  mixins: [mixinsForm],
  emits: ["update:modelValue", "on-change"],
  provide() {
    return {
      RadioGroupInstance: this
    };
  },
  props: {
    modelValue: {
      type: [String, Number],
      default: ""
    },
    size: {
      validator(value) {
        return oneOf(value, ["small", "large", "default"]);
      },
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.size === "" ? "default" : global2.$VIEWUI.size;
      }
    },
    type: {
      validator(value) {
        return oneOf(value, ["button"]);
      }
    },
    vertical: {
      type: Boolean,
      default: false
    },
    name: {
      type: String,
      default: getUuid$1
    },
    buttonStyle: {
      validator(value) {
        return oneOf(value, ["default", "solid"]);
      },
      default: "default"
    }
  },
  data() {
    return {
      currentValue: this.modelValue,
      children: []
    };
  },
  computed: {
    classes() {
      return [
        `${prefixCls$18}`,
        {
          [`${prefixCls$18}-${this.size}`]: !!this.size,
          [`ivu-radio-${this.size}`]: !!this.size,
          [`${prefixCls$18}-${this.type}`]: !!this.type,
          [`${prefixCls$18}-button-${this.buttonStyle}`]: this.type === "button" && this.buttonStyle !== "default",
          [`${prefixCls$18}-vertical`]: this.vertical
        }
      ];
    }
  },
  methods: {
    change(data) {
      this.currentValue = data.value;
      this.$emit("update:modelValue", data.value);
      this.$emit("on-change", data.value);
      this.handleFormItemChange("change", data.value);
    }
  },
  watch: {
    modelValue() {
      if (this.currentValue !== this.modelValue) {
        this.currentValue = this.modelValue;
      }
    }
  }
};
const _hoisted_1$18 = ["name"];
function _sfc_render$1X(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes),
    name: $props.name
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 10, _hoisted_1$18);
}
var RadioGroup = /* @__PURE__ */ _export_sfc(_sfc_main$2a, [["render", _sfc_render$1X]]);
const prefixCls$17 = "ivu-radio";
const _sfc_main$29 = {
  name: "Radio",
  mixins: [mixinsForm],
  emits: ["update:modelValue", "on-change"],
  inject: {
    RadioGroupInstance: {
      default: null
    }
  },
  props: {
    modelValue: {
      type: [String, Number, Boolean],
      default: false
    },
    trueValue: {
      type: [String, Number, Boolean],
      default: true
    },
    falseValue: {
      type: [String, Number, Boolean],
      default: false
    },
    label: {
      type: [String, Number]
    },
    disabled: {
      type: Boolean,
      default: false
    },
    size: {
      validator(value) {
        return oneOf(value, ["small", "large", "default"]);
      },
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.size === "" ? "default" : global2.$VIEWUI.size;
      }
    },
    name: {
      type: String
    },
    border: {
      type: Boolean,
      default: false
    }
  },
  data() {
    return {
      groupName: this.name,
      parent: this.RadioGroupInstance,
      focusWrapper: false,
      focusInner: false
    };
  },
  computed: {
    wrapClasses() {
      return [
        `${prefixCls$17}-wrapper`,
        {
          [`${prefixCls$17}-group-item`]: this.group,
          [`${prefixCls$17}-wrapper-checked`]: this.currentValue,
          [`${prefixCls$17}-wrapper-disabled`]: this.itemDisabled,
          [`${prefixCls$17}-${this.size}`]: !!this.size,
          [`${prefixCls$17}-focus`]: this.focusWrapper,
          [`${prefixCls$17}-border`]: this.border
        }
      ];
    },
    radioClasses() {
      return [
        `${prefixCls$17}`,
        {
          [`${prefixCls$17}-checked`]: this.currentValue,
          [`${prefixCls$17}-disabled`]: this.itemDisabled
        }
      ];
    },
    innerClasses() {
      return [
        `${prefixCls$17}-inner`,
        {
          [`${prefixCls$17}-focus`]: this.focusInner
        }
      ];
    },
    inputClasses() {
      return `${prefixCls$17}-input`;
    },
    currentValue() {
      if (this.RadioGroupInstance) {
        return this.RadioGroupInstance.currentValue === this.label;
      } else {
        return this.modelValue === this.trueValue;
      }
    },
    group() {
      return !!this.RadioGroupInstance;
    }
  },
  mounted() {
    if (this.parent) {
      if (this.name && this.name !== this.parent.name) {
        if (console.warn) {
          console.warn("[View UI] Name does not match Radio Group name.");
        }
      } else {
        this.groupName = this.parent.name;
      }
    }
  },
  methods: {
    change(event) {
      if (this.itemDisabled) {
        return false;
      }
      const checked = event.target.checked;
      const value = checked ? this.trueValue : this.falseValue;
      this.$emit("update:modelValue", value);
      if (this.group) {
        if (this.label !== void 0) {
          this.parent.change({
            value: this.label,
            checked: this.modelValue
          });
        }
      } else {
        this.$emit("on-change", value);
        this.handleFormItemChange("change", value);
      }
    },
    onBlur() {
      this.focusWrapper = false;
      this.focusInner = false;
    },
    onFocus() {
      if (this.group && this.parent.type === "button") {
        this.focusWrapper = true;
      } else {
        this.focusInner = true;
      }
    }
  },
  watch: {
    modelValue(val) {
      if (val === this.trueValue || val === this.falseValue)
        ;
      else {
        throw "Value should be trueValue or falseValue.";
      }
    }
  }
};
const _hoisted_1$17 = ["disabled", "checked", "name"];
function _sfc_render$1W(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("label", {
    class: normalizeClass($options.wrapClasses)
  }, [
    createElementVNode("span", {
      class: normalizeClass($options.radioClasses)
    }, [
      createElementVNode("span", {
        class: normalizeClass($options.innerClasses)
      }, null, 2),
      createElementVNode("input", {
        type: "radio",
        class: normalizeClass($options.inputClasses),
        disabled: _ctx.itemDisabled,
        checked: $options.currentValue,
        name: $data.groupName,
        onChange: _cache[0] || (_cache[0] = (...args) => $options.change && $options.change(...args)),
        onFocus: _cache[1] || (_cache[1] = (...args) => $options.onFocus && $options.onFocus(...args)),
        onBlur: _cache[2] || (_cache[2] = (...args) => $options.onBlur && $options.onBlur(...args))
      }, null, 42, _hoisted_1$17)
    ], 2),
    renderSlot(_ctx.$slots, "default", {}, () => [
      createTextVNode(toDisplayString($props.label), 1)
    ])
  ], 2);
}
var Radio = /* @__PURE__ */ _export_sfc(_sfc_main$29, [["render", _sfc_render$1W]]);
var dayjs_min = { exports: {} };
(function(module, exports) {
  !function(t2, e) {
    module.exports = e();
  }(commonjsGlobal, function() {
    var t2 = 1e3, e = 6e4, n = 36e5, r = "millisecond", i = "second", s = "minute", u = "hour", a = "day", o = "week", c = "month", f = "quarter", h2 = "year", d = "date", l = "Invalid Date", $ = /^(\d{4})[-/]?(\d{1,2})?[-/]?(\d{0,2})[Tt\s]*(\d{1,2})?:?(\d{1,2})?:?(\d{1,2})?[.:]?(\d+)?$/, y = /\[([^\]]+)]|Y{1,4}|M{1,4}|D{1,2}|d{1,4}|H{1,2}|h{1,2}|a|A|m{1,2}|s{1,2}|Z{1,2}|SSS/g, M = { name: "en", weekdays: "Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"), months: "January_February_March_April_May_June_July_August_September_October_November_December".split("_"), ordinal: function(t3) {
      var e2 = ["th", "st", "nd", "rd"], n2 = t3 % 100;
      return "[" + t3 + (e2[(n2 - 20) % 10] || e2[n2] || e2[0]) + "]";
    } }, m = function(t3, e2, n2) {
      var r2 = String(t3);
      return !r2 || r2.length >= e2 ? t3 : "" + Array(e2 + 1 - r2.length).join(n2) + t3;
    }, v = { s: m, z: function(t3) {
      var e2 = -t3.utcOffset(), n2 = Math.abs(e2), r2 = Math.floor(n2 / 60), i2 = n2 % 60;
      return (e2 <= 0 ? "+" : "-") + m(r2, 2, "0") + ":" + m(i2, 2, "0");
    }, m: function t3(e2, n2) {
      if (e2.date() < n2.date())
        return -t3(n2, e2);
      var r2 = 12 * (n2.year() - e2.year()) + (n2.month() - e2.month()), i2 = e2.clone().add(r2, c), s2 = n2 - i2 < 0, u2 = e2.clone().add(r2 + (s2 ? -1 : 1), c);
      return +(-(r2 + (n2 - i2) / (s2 ? i2 - u2 : u2 - i2)) || 0);
    }, a: function(t3) {
      return t3 < 0 ? Math.ceil(t3) || 0 : Math.floor(t3);
    }, p: function(t3) {
      return { M: c, y: h2, w: o, d: a, D: d, h: u, m: s, s: i, ms: r, Q: f }[t3] || String(t3 || "").toLowerCase().replace(/s$/, "");
    }, u: function(t3) {
      return void 0 === t3;
    } }, g = "en", D = {};
    D[g] = M;
    var p = "$isDayjsObject", S = function(t3) {
      return t3 instanceof _ || !(!t3 || !t3[p]);
    }, w = function t3(e2, n2, r2) {
      var i2;
      if (!e2)
        return g;
      if ("string" == typeof e2) {
        var s2 = e2.toLowerCase();
        D[s2] && (i2 = s2), n2 && (D[s2] = n2, i2 = s2);
        var u2 = e2.split("-");
        if (!i2 && u2.length > 1)
          return t3(u2[0]);
      } else {
        var a2 = e2.name;
        D[a2] = e2, i2 = a2;
      }
      return !r2 && i2 && (g = i2), i2 || !r2 && g;
    }, O = function(t3, e2) {
      if (S(t3))
        return t3.clone();
      var n2 = "object" == typeof e2 ? e2 : {};
      return n2.date = t3, n2.args = arguments, new _(n2);
    }, b = v;
    b.l = w, b.i = S, b.w = function(t3, e2) {
      return O(t3, { locale: e2.$L, utc: e2.$u, x: e2.$x, $offset: e2.$offset });
    };
    var _ = function() {
      function M2(t3) {
        this.$L = w(t3.locale, null, true), this.parse(t3), this.$x = this.$x || t3.x || {}, this[p] = true;
      }
      var m2 = M2.prototype;
      return m2.parse = function(t3) {
        this.$d = function(t4) {
          var e2 = t4.date, n2 = t4.utc;
          if (null === e2)
            return new Date(NaN);
          if (b.u(e2))
            return new Date();
          if (e2 instanceof Date)
            return new Date(e2);
          if ("string" == typeof e2 && !/Z$/i.test(e2)) {
            var r2 = e2.match($);
            if (r2) {
              var i2 = r2[2] - 1 || 0, s2 = (r2[7] || "0").substring(0, 3);
              return n2 ? new Date(Date.UTC(r2[1], i2, r2[3] || 1, r2[4] || 0, r2[5] || 0, r2[6] || 0, s2)) : new Date(r2[1], i2, r2[3] || 1, r2[4] || 0, r2[5] || 0, r2[6] || 0, s2);
            }
          }
          return new Date(e2);
        }(t3), this.init();
      }, m2.init = function() {
        var t3 = this.$d;
        this.$y = t3.getFullYear(), this.$M = t3.getMonth(), this.$D = t3.getDate(), this.$W = t3.getDay(), this.$H = t3.getHours(), this.$m = t3.getMinutes(), this.$s = t3.getSeconds(), this.$ms = t3.getMilliseconds();
      }, m2.$utils = function() {
        return b;
      }, m2.isValid = function() {
        return !(this.$d.toString() === l);
      }, m2.isSame = function(t3, e2) {
        var n2 = O(t3);
        return this.startOf(e2) <= n2 && n2 <= this.endOf(e2);
      }, m2.isAfter = function(t3, e2) {
        return O(t3) < this.startOf(e2);
      }, m2.isBefore = function(t3, e2) {
        return this.endOf(e2) < O(t3);
      }, m2.$g = function(t3, e2, n2) {
        return b.u(t3) ? this[e2] : this.set(n2, t3);
      }, m2.unix = function() {
        return Math.floor(this.valueOf() / 1e3);
      }, m2.valueOf = function() {
        return this.$d.getTime();
      }, m2.startOf = function(t3, e2) {
        var n2 = this, r2 = !!b.u(e2) || e2, f2 = b.p(t3), l2 = function(t4, e3) {
          var i2 = b.w(n2.$u ? Date.UTC(n2.$y, e3, t4) : new Date(n2.$y, e3, t4), n2);
          return r2 ? i2 : i2.endOf(a);
        }, $2 = function(t4, e3) {
          return b.w(n2.toDate()[t4].apply(n2.toDate("s"), (r2 ? [0, 0, 0, 0] : [23, 59, 59, 999]).slice(e3)), n2);
        }, y2 = this.$W, M3 = this.$M, m3 = this.$D, v2 = "set" + (this.$u ? "UTC" : "");
        switch (f2) {
          case h2:
            return r2 ? l2(1, 0) : l2(31, 11);
          case c:
            return r2 ? l2(1, M3) : l2(0, M3 + 1);
          case o:
            var g2 = this.$locale().weekStart || 0, D2 = (y2 < g2 ? y2 + 7 : y2) - g2;
            return l2(r2 ? m3 - D2 : m3 + (6 - D2), M3);
          case a:
          case d:
            return $2(v2 + "Hours", 0);
          case u:
            return $2(v2 + "Minutes", 1);
          case s:
            return $2(v2 + "Seconds", 2);
          case i:
            return $2(v2 + "Milliseconds", 3);
          default:
            return this.clone();
        }
      }, m2.endOf = function(t3) {
        return this.startOf(t3, false);
      }, m2.$set = function(t3, e2) {
        var n2, o2 = b.p(t3), f2 = "set" + (this.$u ? "UTC" : ""), l2 = (n2 = {}, n2[a] = f2 + "Date", n2[d] = f2 + "Date", n2[c] = f2 + "Month", n2[h2] = f2 + "FullYear", n2[u] = f2 + "Hours", n2[s] = f2 + "Minutes", n2[i] = f2 + "Seconds", n2[r] = f2 + "Milliseconds", n2)[o2], $2 = o2 === a ? this.$D + (e2 - this.$W) : e2;
        if (o2 === c || o2 === h2) {
          var y2 = this.clone().set(d, 1);
          y2.$d[l2]($2), y2.init(), this.$d = y2.set(d, Math.min(this.$D, y2.daysInMonth())).$d;
        } else
          l2 && this.$d[l2]($2);
        return this.init(), this;
      }, m2.set = function(t3, e2) {
        return this.clone().$set(t3, e2);
      }, m2.get = function(t3) {
        return this[b.p(t3)]();
      }, m2.add = function(r2, f2) {
        var d2, l2 = this;
        r2 = Number(r2);
        var $2 = b.p(f2), y2 = function(t3) {
          var e2 = O(l2);
          return b.w(e2.date(e2.date() + Math.round(t3 * r2)), l2);
        };
        if ($2 === c)
          return this.set(c, this.$M + r2);
        if ($2 === h2)
          return this.set(h2, this.$y + r2);
        if ($2 === a)
          return y2(1);
        if ($2 === o)
          return y2(7);
        var M3 = (d2 = {}, d2[s] = e, d2[u] = n, d2[i] = t2, d2)[$2] || 1, m3 = this.$d.getTime() + r2 * M3;
        return b.w(m3, this);
      }, m2.subtract = function(t3, e2) {
        return this.add(-1 * t3, e2);
      }, m2.format = function(t3) {
        var e2 = this, n2 = this.$locale();
        if (!this.isValid())
          return n2.invalidDate || l;
        var r2 = t3 || "YYYY-MM-DDTHH:mm:ssZ", i2 = b.z(this), s2 = this.$H, u2 = this.$m, a2 = this.$M, o2 = n2.weekdays, c2 = n2.months, f2 = n2.meridiem, h3 = function(t4, n3, i3, s3) {
          return t4 && (t4[n3] || t4(e2, r2)) || i3[n3].slice(0, s3);
        }, d2 = function(t4) {
          return b.s(s2 % 12 || 12, t4, "0");
        }, $2 = f2 || function(t4, e3, n3) {
          var r3 = t4 < 12 ? "AM" : "PM";
          return n3 ? r3.toLowerCase() : r3;
        };
        return r2.replace(y, function(t4, r3) {
          return r3 || function(t5) {
            switch (t5) {
              case "YY":
                return String(e2.$y).slice(-2);
              case "YYYY":
                return b.s(e2.$y, 4, "0");
              case "M":
                return a2 + 1;
              case "MM":
                return b.s(a2 + 1, 2, "0");
              case "MMM":
                return h3(n2.monthsShort, a2, c2, 3);
              case "MMMM":
                return h3(c2, a2);
              case "D":
                return e2.$D;
              case "DD":
                return b.s(e2.$D, 2, "0");
              case "d":
                return String(e2.$W);
              case "dd":
                return h3(n2.weekdaysMin, e2.$W, o2, 2);
              case "ddd":
                return h3(n2.weekdaysShort, e2.$W, o2, 3);
              case "dddd":
                return o2[e2.$W];
              case "H":
                return String(s2);
              case "HH":
                return b.s(s2, 2, "0");
              case "h":
                return d2(1);
              case "hh":
                return d2(2);
              case "a":
                return $2(s2, u2, true);
              case "A":
                return $2(s2, u2, false);
              case "m":
                return String(u2);
              case "mm":
                return b.s(u2, 2, "0");
              case "s":
                return String(e2.$s);
              case "ss":
                return b.s(e2.$s, 2, "0");
              case "SSS":
                return b.s(e2.$ms, 3, "0");
              case "Z":
                return i2;
            }
            return null;
          }(t4) || i2.replace(":", "");
        });
      }, m2.utcOffset = function() {
        return 15 * -Math.round(this.$d.getTimezoneOffset() / 15);
      }, m2.diff = function(r2, d2, l2) {
        var $2, y2 = this, M3 = b.p(d2), m3 = O(r2), v2 = (m3.utcOffset() - this.utcOffset()) * e, g2 = this - m3, D2 = function() {
          return b.m(y2, m3);
        };
        switch (M3) {
          case h2:
            $2 = D2() / 12;
            break;
          case c:
            $2 = D2();
            break;
          case f:
            $2 = D2() / 3;
            break;
          case o:
            $2 = (g2 - v2) / 6048e5;
            break;
          case a:
            $2 = (g2 - v2) / 864e5;
            break;
          case u:
            $2 = g2 / n;
            break;
          case s:
            $2 = g2 / e;
            break;
          case i:
            $2 = g2 / t2;
            break;
          default:
            $2 = g2;
        }
        return l2 ? $2 : b.a($2);
      }, m2.daysInMonth = function() {
        return this.endOf(c).$D;
      }, m2.$locale = function() {
        return D[this.$L];
      }, m2.locale = function(t3, e2) {
        if (!t3)
          return this.$L;
        var n2 = this.clone(), r2 = w(t3, e2, true);
        return r2 && (n2.$L = r2), n2;
      }, m2.clone = function() {
        return b.w(this.$d, this);
      }, m2.toDate = function() {
        return new Date(this.valueOf());
      }, m2.toJSON = function() {
        return this.isValid() ? this.toISOString() : null;
      }, m2.toISOString = function() {
        return this.$d.toISOString();
      }, m2.toString = function() {
        return this.$d.toUTCString();
      }, M2;
    }(), k = _.prototype;
    return O.prototype = k, [["$ms", r], ["$s", i], ["$m", s], ["$H", u], ["$W", a], ["$M", c], ["$y", h2], ["$D", d]].forEach(function(t3) {
      k[t3[1]] = function(e2) {
        return this.$g(e2, t3[0], t3[1]);
      };
    }), O.extend = function(t3, e2) {
      return t3.$i || (t3(e2, _, O), t3.$i = true), O;
    }, O.locale = w, O.isDayjs = S, O.unix = function(t3) {
      return O(1e3 * t3);
    }, O.en = D[g], O.Ls = D, O.p = {}, O;
  });
})(dayjs_min);
var dayjs = dayjs_min.exports;
var INFINITY = 1 / 0, MAX_SAFE_INTEGER = 9007199254740991, MAX_INTEGER = 17976931348623157e292, NAN$1 = 0 / 0;
var funcTag = "[object Function]", genTag = "[object GeneratorFunction]", symbolTag$1 = "[object Symbol]";
var reTrim$1 = /^\s+|\s+$/g;
var reIsBadHex$1 = /^[-+]0x[0-9a-f]+$/i;
var reIsBinary$1 = /^0b[01]+$/i;
var reIsOctal$1 = /^0o[0-7]+$/i;
var reIsUint = /^(?:0|[1-9]\d*)$/;
var freeParseInt$1 = parseInt;
var objectProto$1 = Object.prototype;
var objectToString$1 = objectProto$1.toString;
var nativeCeil = Math.ceil, nativeMax$1 = Math.max;
function baseSlice(array3, start, end) {
  var index2 = -1, length = array3.length;
  if (start < 0) {
    start = -start > length ? 0 : length + start;
  }
  end = end > length ? length : end;
  if (end < 0) {
    end += length;
  }
  length = start > end ? 0 : end - start >>> 0;
  start >>>= 0;
  var result = Array(length);
  while (++index2 < length) {
    result[index2] = array3[index2 + start];
  }
  return result;
}
function isIndex(value, length) {
  length = length == null ? MAX_SAFE_INTEGER : length;
  return !!length && (typeof value == "number" || reIsUint.test(value)) && (value > -1 && value % 1 == 0 && value < length);
}
function isIterateeCall(value, index2, object3) {
  if (!isObject$1(object3)) {
    return false;
  }
  var type2 = typeof index2;
  if (type2 == "number" ? isArrayLike(object3) && isIndex(index2, object3.length) : type2 == "string" && index2 in object3) {
    return eq(object3[index2], value);
  }
  return false;
}
function chunk(array3, size, guard) {
  if (guard ? isIterateeCall(array3, size, guard) : size === void 0) {
    size = 1;
  } else {
    size = nativeMax$1(toInteger(size), 0);
  }
  var length = array3 ? array3.length : 0;
  if (!length || size < 1) {
    return [];
  }
  var index2 = 0, resIndex = 0, result = Array(nativeCeil(length / size));
  while (index2 < length) {
    result[resIndex++] = baseSlice(array3, index2, index2 += size);
  }
  return result;
}
function eq(value, other) {
  return value === other || value !== value && other !== other;
}
function isArrayLike(value) {
  return value != null && isLength(value.length) && !isFunction(value);
}
function isFunction(value) {
  var tag = isObject$1(value) ? objectToString$1.call(value) : "";
  return tag == funcTag || tag == genTag;
}
function isLength(value) {
  return typeof value == "number" && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
}
function isObject$1(value) {
  var type2 = typeof value;
  return !!value && (type2 == "object" || type2 == "function");
}
function isObjectLike$1(value) {
  return !!value && typeof value == "object";
}
function isSymbol$1(value) {
  return typeof value == "symbol" || isObjectLike$1(value) && objectToString$1.call(value) == symbolTag$1;
}
function toFinite(value) {
  if (!value) {
    return value === 0 ? value : 0;
  }
  value = toNumber$1(value);
  if (value === INFINITY || value === -INFINITY) {
    var sign = value < 0 ? -1 : 1;
    return sign * MAX_INTEGER;
  }
  return value === value ? value : 0;
}
function toInteger(value) {
  var result = toFinite(value), remainder = result % 1;
  return result === result ? remainder ? result - remainder : result : 0;
}
function toNumber$1(value) {
  if (typeof value == "number") {
    return value;
  }
  if (isSymbol$1(value)) {
    return NAN$1;
  }
  if (isObject$1(value)) {
    var other = typeof value.valueOf == "function" ? value.valueOf() : value;
    value = isObject$1(other) ? other + "" : other;
  }
  if (typeof value != "string") {
    return value === 0 ? value : +value;
  }
  value = value.replace(reTrim$1, "");
  var isBinary = reIsBinary$1.test(value);
  return isBinary || reIsOctal$1.test(value) ? freeParseInt$1(value.slice(2), isBinary ? 2 : 8) : reIsBadHex$1.test(value) ? NAN$1 : +value;
}
var lodash_chunk = chunk;
var events = {
  emits: ["on-cell-click", "on-cell-contextmenu"],
  methods: {
    handleCellClick(data) {
      this.CalendarInstance.$emit("on-cell-click", data);
    },
    handleCellContextmenu(data) {
      this.CalendarInstance.$emit("on-cell-contextmenu", data);
    }
  }
};
const _sfc_main$28 = {
  name: "CalendarMonth",
  mixins: [events],
  inject: ["CalendarInstance"],
  props: {
    date: Object
  },
  data() {
    return {
      firstDayOfWeek: this.CalendarInstance.firstDayOfWeek,
      weekDays: this.CalendarInstance.locale.weekDays
    };
  },
  computed: {
    finalWeekDays() {
      return this.weekDays.slice(this.firstDayOfWeek).concat(this.weekDays.slice(0, this.firstDayOfWeek));
    },
    days() {
      let days = [];
      const firstDate = dayjs(this.date.format("YYYY-MM-01"));
      const firstDay = firstDate.day();
      const firstDayOfWeek = this.firstDayOfWeek;
      const prevMonthDaysCount = firstDayOfWeek <= firstDay ? firstDay - firstDayOfWeek : 7 - (firstDayOfWeek - firstDay);
      for (let i = 0; i < prevMonthDaysCount; i++) {
        const day = firstDate.subtract(prevMonthDaysCount - i, "day");
        const date3 = {
          text: day.format("YYYY-MM-DD"),
          date: day.format("D"),
          type: "prev"
        };
        days.push(date3);
      }
      const daysInMonth2 = firstDate.daysInMonth();
      for (let i = 0; i < daysInMonth2; i++) {
        const day = firstDate.add(i, "day");
        const date3 = {
          text: day.format("YYYY-MM-DD"),
          date: day.format("D"),
          type: "current"
        };
        days.push(date3);
      }
      const nextMonthDaysCount = 42 - days.length;
      const nextMonthFirstDay = firstDate.add(1, "month");
      for (let i = 0; i < nextMonthDaysCount; i++) {
        const day = nextMonthFirstDay.add(i, "day");
        const date3 = {
          text: day.format("YYYY-MM-DD"),
          date: day.format("D"),
          type: "next"
        };
        days.push(date3);
      }
      return days;
    },
    chunkDays() {
      return lodash_chunk(this.days, 7);
    },
    dayStyles() {
      let style2 = {};
      if (this.CalendarInstance.cellHeight !== 100) {
        style2.height = `${this.CalendarInstance.cellHeight}px`;
      }
      return style2;
    },
    currentDate() {
      return this.date.format("YYYY-MM-DD");
    }
  },
  methods: {
    handleClickDate(date3) {
      this.CalendarInstance.handleChangeDate(dayjs(date3));
    }
  }
};
const _hoisted_1$16 = {
  class: "ivu-calendar-table",
  cellspacing: "0",
  cellpadding: "0"
};
const _hoisted_2$G = ["onClick", "onContextmenu"];
const _hoisted_3$w = ["onClick"];
const _hoisted_4$o = { class: "ivu-calendar-table-day-title" };
const _hoisted_5$h = { class: "ivu-calendar-table-day-slot" };
function _sfc_render$1V(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("table", _hoisted_1$16, [
    createElementVNode("thead", null, [
      (openBlock(true), createElementBlock(Fragment, null, renderList($options.finalWeekDays, (item) => {
        return openBlock(), createElementBlock("th", { key: item }, toDisplayString(item), 1);
      }), 128))
    ]),
    createElementVNode("tbody", null, [
      (openBlock(true), createElementBlock(Fragment, null, renderList($options.chunkDays, (item, index2) => {
        return openBlock(), createElementBlock("tr", { key: index2 }, [
          (openBlock(true), createElementBlock(Fragment, null, renderList(item, (date3) => {
            return openBlock(), createElementBlock("td", {
              key: date3.text,
              onClick: ($event) => _ctx.handleCellClick(date3),
              onContextmenu: withModifiers(($event) => _ctx.handleCellContextmenu(date3), ["prevent"])
            }, [
              createElementVNode("div", {
                class: normalizeClass(["ivu-calendar-table-day", { "ivu-calendar-table-day-other": date3.type !== "current", "ivu-calendar-table-day-current": date3.text === $options.currentDate }]),
                style: normalizeStyle($options.dayStyles),
                onClick: ($event) => $options.handleClickDate(date3.text)
              }, [
                createElementVNode("div", _hoisted_4$o, toDisplayString(date3.date), 1),
                createElementVNode("div", _hoisted_5$h, [
                  renderSlot(_ctx.$slots, "month", {
                    date: new Date(date3.date),
                    data: { type: date3.type + "-month", day: date3.text, selected: date3.text === $options.currentDate }
                  })
                ])
              ], 14, _hoisted_3$w)
            ], 40, _hoisted_2$G);
          }), 128))
        ]);
      }), 128))
    ])
  ]);
}
var CalendarMonth = /* @__PURE__ */ _export_sfc(_sfc_main$28, [["render", _sfc_render$1V]]);
const _sfc_main$27 = {
  name: "CalendarYear",
  mixins: [events],
  inject: ["CalendarInstance"],
  props: {
    date: Object
  },
  data() {
    return {};
  },
  computed: {
    months() {
      let months = [];
      const firstMonth = dayjs(this.date.format("YYYY-01-01"));
      for (let i = 0; i < 12; i++) {
        const day = firstMonth.add(i, "month");
        months.push({
          text: day.format("YYYY-MM"),
          month: this.CalendarInstance.locale.months[i],
          type: "current"
        });
      }
      return months;
    },
    chunkMonths() {
      return lodash_chunk(this.months, 3);
    },
    dayStyles() {
      let style2 = {};
      if (this.CalendarInstance.cellHeight !== 100) {
        style2.height = `${this.CalendarInstance.cellHeight}px`;
      }
      return style2;
    },
    currentMonth() {
      return this.date.format("YYYY-MM");
    }
  },
  methods: {
    handleClickDate(date3) {
      this.CalendarInstance.handleChangeDate(dayjs(date3));
    }
  }
};
const _hoisted_1$15 = {
  class: "ivu-calendar-table ivu-calendar-table-year",
  cellspacing: "0",
  cellpadding: "0"
};
const _hoisted_2$F = ["onClick", "onContextmenu"];
const _hoisted_3$v = ["onClick"];
const _hoisted_4$n = { class: "ivu-calendar-table-day-title" };
const _hoisted_5$g = { class: "ivu-calendar-table-day-slot" };
function _sfc_render$1U(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("table", _hoisted_1$15, [
    createElementVNode("tbody", null, [
      (openBlock(true), createElementBlock(Fragment, null, renderList($options.chunkMonths, (item, index2) => {
        return openBlock(), createElementBlock("tr", { key: index2 }, [
          (openBlock(true), createElementBlock(Fragment, null, renderList(item, (month) => {
            return openBlock(), createElementBlock("td", {
              key: month.text,
              onClick: ($event) => _ctx.handleCellClick(month),
              onContextmenu: withModifiers(($event) => _ctx.handleCellContextmenu(month), ["prevent"])
            }, [
              createElementVNode("div", {
                class: normalizeClass(["ivu-calendar-table-day", { "ivu-calendar-table-day-current": month.text === $options.currentMonth }]),
                style: normalizeStyle($options.dayStyles),
                onClick: ($event) => $options.handleClickDate(month.text)
              }, [
                createElementVNode("div", _hoisted_4$n, toDisplayString(month.month), 1),
                createElementVNode("div", _hoisted_5$g, [
                  renderSlot(_ctx.$slots, "year", {
                    month: new Date(month.month),
                    data: { type: month.type + "-year", month: month.text, selected: month.text === $options.currentMonth }
                  })
                ])
              ], 14, _hoisted_3$v)
            ], 40, _hoisted_2$F);
          }), 128))
        ]);
      }), 128))
    ])
  ]);
}
var CalendarYear = /* @__PURE__ */ _export_sfc(_sfc_main$27, [["render", _sfc_render$1U]]);
const _sfc_main$26 = {
  name: "Calendar",
  components: { CalendarMonth, CalendarYear, ButtonGroup, Button: _sfc_main$2c, RadioGroup, Radio, Icon },
  emits: ["on-type-change", "on-prev", "on-next", "on-today", "on-change", "update:modelValue", "on-cell-click", "on-cell-contextmenu"],
  provide() {
    return {
      CalendarInstance: this
    };
  },
  props: {
    modelValue: {
      type: [Date, String, Number]
    },
    type: {
      validator(value) {
        return oneOf(value, ["month", "year"]);
      },
      default: "month"
    },
    cellHeight: {
      type: Number,
      default: 100
    },
    showHeader: {
      type: Boolean,
      default: true
    },
    headerType: {
      validator(value) {
        return oneOf(value, ["simple", "full"]);
      },
      default: "simple"
    },
    firstDayOfWeek: {
      validator(value) {
        return oneOf(value, [1, 2, 3, 4, 5, 6, 7]);
      },
      default: 1
    },
    hideType: {
      type: Boolean,
      default: false
    },
    locale: {
      type: Object,
      default() {
        return {
          today: "\u4ECA\u5929",
          type: {
            month: "\u6708",
            year: "\u5E74"
          },
          weekDays: ["\u65E5", "\u4E00", "\u4E8C", "\u4E09", "\u56DB", "\u4E94", "\u516D"],
          months: ["1\u6708", "2\u6708", "3\u6708", "4\u6708", "5\u6708", "6\u6708", "7\u6708", "8\u6708", "9\u6708", "10\u6708", "11\u6708", "12\u6708"]
        };
      }
    }
  },
  data() {
    const value = this.modelValue ? this.modelValue : new Date();
    return {
      currentValue: dayjs(value),
      mode: this.type
    };
  },
  watch: {
    modelValue(val) {
      const value = val ? val : new Date();
      this.currentValue = dayjs(value);
    },
    type(val) {
      this.mode = val;
    }
  },
  computed: {
    headerTitle() {
      if (this.mode === "month") {
        return this.currentValue.format("YYYY \u5E74 M \u6708");
      } else if (this.mode === "year") {
        return this.currentValue.format("YYYY \u5E74");
      }
    }
  },
  methods: {
    handleChangeType(type2) {
      this.$emit("on-type-change", type2);
    },
    handlePrev() {
      const firstDate = this.currentValue.format("YYYY-MM-01");
      let prevDate;
      if (this.mode === "month") {
        prevDate = dayjs(firstDate).subtract(1, "month");
      } else if (this.mode === "year") {
        prevDate = dayjs(firstDate).subtract(1, "year");
      }
      this.handleChangeDate(prevDate);
      this.$emit("on-prev");
    },
    handleNext() {
      const firstDate = this.currentValue.format("YYYY-MM-01");
      let nextDate;
      if (this.mode === "month") {
        nextDate = dayjs(firstDate).add(1, "month");
      } else if (this.mode === "year") {
        nextDate = dayjs(firstDate).add(1, "year");
      }
      this.handleChangeDate(nextDate);
      this.$emit("on-next");
    },
    handleToday() {
      const nowDate = dayjs(new Date());
      const today = nowDate.format("YYYY-MM-DD");
      const currentValue = this.currentValue.format("YYYY-MM-DD");
      if (today !== currentValue) {
        this.handleChangeDate(nowDate);
      }
      this.$emit("on-today");
    },
    handleChangeDate(val) {
      this.currentValue = val;
      const date3 = new Date(val.format("YYYY-MM-DD"));
      this.$emit("update:modelValue", date3);
      this.$emit("on-change", date3);
    }
  }
};
const _hoisted_1$14 = { class: "ivu-calendar" };
const _hoisted_2$E = {
  key: 0,
  class: "ivu-calendar-header"
};
const _hoisted_3$u = { class: "ivu-calendar-header-title" };
const _hoisted_4$m = { class: "ivu-calendar-header-action" };
const _hoisted_5$f = { class: "ivu-calendar-body" };
function _sfc_render$1T(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = resolveComponent("Icon");
  const _component_Button = resolveComponent("Button");
  const _component_ButtonGroup = resolveComponent("ButtonGroup");
  const _component_Radio = resolveComponent("Radio");
  const _component_RadioGroup = resolveComponent("RadioGroup");
  const _component_CalendarMonth = resolveComponent("CalendarMonth");
  const _component_CalendarYear = resolveComponent("CalendarYear");
  return openBlock(), createElementBlock("div", _hoisted_1$14, [
    $props.showHeader ? (openBlock(), createElementBlock("div", _hoisted_2$E, [
      renderSlot(_ctx.$slots, "header", {}, () => [
        createElementVNode("div", _hoisted_3$u, [
          renderSlot(_ctx.$slots, "headerTitle", {}, () => [
            createTextVNode(toDisplayString($options.headerTitle), 1)
          ])
        ]),
        createElementVNode("div", _hoisted_4$m, [
          $props.headerType === "simple" ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
            createVNode(_component_ButtonGroup, null, {
              default: withCtx(() => [
                createVNode(_component_Button, { onClick: $options.handlePrev }, {
                  default: withCtx(() => [
                    createVNode(_component_Icon, { type: "ios-arrow-back" })
                  ]),
                  _: 1
                }, 8, ["onClick"]),
                createVNode(_component_Button, { onClick: $options.handleToday }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString($props.locale.today), 1)
                  ]),
                  _: 1
                }, 8, ["onClick"]),
                createVNode(_component_Button, { onClick: $options.handleNext }, {
                  default: withCtx(() => [
                    createVNode(_component_Icon, { type: "ios-arrow-forward" })
                  ]),
                  _: 1
                }, 8, ["onClick"])
              ]),
              _: 1
            }),
            !$props.hideType ? (openBlock(), createBlock(_component_RadioGroup, {
              key: 0,
              modelValue: $data.mode,
              "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => $data.mode = $event),
              type: "button",
              class: "ivu-ml",
              onOnChange: $options.handleChangeType
            }, {
              default: withCtx(() => [
                createVNode(_component_Radio, { label: "month" }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString($props.locale.type.month), 1)
                  ]),
                  _: 1
                }),
                createVNode(_component_Radio, { label: "year" }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString($props.locale.type.year), 1)
                  ]),
                  _: 1
                })
              ]),
              _: 1
            }, 8, ["modelValue", "onOnChange"])) : createCommentVNode("", true)
          ], 64)) : $props.headerType === "full" ? (openBlock(), createElementBlock(Fragment, { key: 1 }, [], 64)) : createCommentVNode("", true)
        ])
      ])
    ])) : createCommentVNode("", true),
    createElementVNode("div", _hoisted_5$f, [
      $data.mode === "month" ? (openBlock(), createBlock(_component_CalendarMonth, {
        key: 0,
        date: $data.currentValue
      }, {
        month: withCtx(({ date: date3, data }) => [
          renderSlot(_ctx.$slots, "month", {
            date: date3,
            data
          })
        ]),
        _: 3
      }, 8, ["date"])) : $data.mode === "year" ? (openBlock(), createBlock(_component_CalendarYear, {
        key: 1,
        date: $data.currentValue
      }, {
        year: withCtx(({ month, data }) => [
          renderSlot(_ctx.$slots, "year", {
            month,
            data
          })
        ]),
        _: 3
      }, 8, ["date"])) : createCommentVNode("", true)
    ])
  ]);
}
var Calendar = /* @__PURE__ */ _export_sfc(_sfc_main$26, [["render", _sfc_render$1T]]);
const prefixCls$16 = "ivu-col";
function parseFlex(flex) {
  if (typeof flex === "number") {
    return `${flex} ${flex} auto`;
  }
  if (/^\d+(\.\d+)?(px|em|rem|%)$/.test(flex)) {
    return `0 0 ${flex}`;
  }
  return flex;
}
const _sfc_main$25 = {
  name: "iCol",
  inject: ["RowInstance"],
  props: {
    span: [Number, String],
    order: [Number, String],
    offset: [Number, String],
    push: [Number, String],
    pull: [Number, String],
    className: String,
    xs: [Number, Object],
    sm: [Number, Object],
    md: [Number, Object],
    lg: [Number, Object],
    xl: [Number, Object],
    xxl: [Number, Object],
    flex: {
      type: [Number, String],
      default: ""
    }
  },
  computed: {
    gutter() {
      return this.RowInstance.gutter;
    },
    classes() {
      let classList = [
        `${prefixCls$16}`,
        {
          [`${prefixCls$16}-span-${this.span}`]: this.span,
          [`${prefixCls$16}-order-${this.order}`]: this.order,
          [`${prefixCls$16}-offset-${this.offset}`]: this.offset,
          [`${prefixCls$16}-push-${this.push}`]: this.push,
          [`${prefixCls$16}-pull-${this.pull}`]: this.pull,
          [`${this.className}`]: !!this.className
        }
      ];
      ["xs", "sm", "md", "lg", "xl", "xxl"].forEach((size) => {
        if (typeof this[size] === "number") {
          classList.push(`${prefixCls$16}-span-${size}-${this[size]}`);
        } else if (typeof this[size] === "object") {
          let props = this[size];
          Object.keys(props).forEach((prop2) => {
            classList.push(
              prop2 !== "span" ? `${prefixCls$16}-${size}-${prop2}-${props[prop2]}` : `${prefixCls$16}-span-${size}-${props[prop2]}`
            );
          });
        }
      });
      return classList;
    },
    styles() {
      let style2 = {};
      if (this.gutter !== 0) {
        style2 = {
          paddingLeft: this.gutter / 2 + "px",
          paddingRight: this.gutter / 2 + "px"
        };
      }
      if (this.flex) {
        style2.flex = parseFlex(this.flex);
      }
      return style2;
    }
  }
};
function _sfc_render$1S(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes),
    style: normalizeStyle($options.styles)
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 6);
}
var Col = /* @__PURE__ */ _export_sfc(_sfc_main$25, [["render", _sfc_render$1S]]);
const prefixCls$15 = "ivu-row";
const _sfc_main$24 = {
  name: "Row",
  provide() {
    return {
      RowInstance: this
    };
  },
  props: {
    type: {
      validator(value) {
        return oneOf(value, ["flex"]);
      }
    },
    align: {
      validator(value) {
        return oneOf(value, ["top", "middle", "bottom"]);
      }
    },
    justify: {
      validator(value) {
        return oneOf(value, ["start", "end", "center", "space-around", "space-between"]);
      }
    },
    gutter: {
      type: Number,
      default: 0
    },
    className: String,
    wrap: {
      type: Boolean,
      default: true
    }
  },
  computed: {
    classes() {
      return [
        `${prefixCls$15}`,
        {
          [`${prefixCls$15}-${this.type}`]: !!this.type,
          [`${prefixCls$15}-${this.type}-${this.align}`]: !!this.align && this.type,
          [`${prefixCls$15}-${this.type}-${this.justify}`]: !!this.justify && this.type,
          [`${prefixCls$15}-${this.align}`]: !!this.align,
          [`${prefixCls$15}-${this.justify}`]: !!this.justify,
          [`${this.className}`]: !!this.className,
          [`${prefixCls$15}-no-wrap`]: !this.wrap
        }
      ];
    },
    styles() {
      let style2 = {};
      if (this.gutter !== 0) {
        style2 = {
          marginLeft: this.gutter / -2 + "px",
          marginRight: this.gutter / -2 + "px"
        };
      }
      return style2;
    }
  }
};
function _sfc_render$1R(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes),
    style: normalizeStyle($options.styles)
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 6);
}
var Row = /* @__PURE__ */ _export_sfc(_sfc_main$24, [["render", _sfc_render$1R]]);
function _extends() {
  _extends = Object.assign || function(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key2 in source) {
        if (Object.prototype.hasOwnProperty.call(source, key2)) {
          target[key2] = source[key2];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}
function _inheritsLoose(subClass, superClass) {
  subClass.prototype = Object.create(superClass.prototype);
  subClass.prototype.constructor = subClass;
  _setPrototypeOf(subClass, superClass);
}
function _getPrototypeOf(o) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf2(o2) {
    return o2.__proto__ || Object.getPrototypeOf(o2);
  };
  return _getPrototypeOf(o);
}
function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf2(o2, p2) {
    o2.__proto__ = p2;
    return o2;
  };
  return _setPrototypeOf(o, p);
}
function _isNativeReflectConstruct() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e) {
    return false;
  }
}
function _construct(Parent, args, Class) {
  if (_isNativeReflectConstruct()) {
    _construct = Reflect.construct;
  } else {
    _construct = function _construct2(Parent2, args2, Class2) {
      var a = [null];
      a.push.apply(a, args2);
      var Constructor = Function.bind.apply(Parent2, a);
      var instance = new Constructor();
      if (Class2)
        _setPrototypeOf(instance, Class2.prototype);
      return instance;
    };
  }
  return _construct.apply(null, arguments);
}
function _isNativeFunction(fn) {
  return Function.toString.call(fn).indexOf("[native code]") !== -1;
}
function _wrapNativeSuper(Class) {
  var _cache = typeof Map === "function" ? /* @__PURE__ */ new Map() : void 0;
  _wrapNativeSuper = function _wrapNativeSuper2(Class2) {
    if (Class2 === null || !_isNativeFunction(Class2))
      return Class2;
    if (typeof Class2 !== "function") {
      throw new TypeError("Super expression must either be null or a function");
    }
    if (typeof _cache !== "undefined") {
      if (_cache.has(Class2))
        return _cache.get(Class2);
      _cache.set(Class2, Wrapper);
    }
    function Wrapper() {
      return _construct(Class2, arguments, _getPrototypeOf(this).constructor);
    }
    Wrapper.prototype = Object.create(Class2.prototype, {
      constructor: {
        value: Wrapper,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
    return _setPrototypeOf(Wrapper, Class2);
  };
  return _wrapNativeSuper(Class);
}
var formatRegExp = /%[sdj%]/g;
var warning = function warning2() {
};
if (typeof process !== "undefined" && process.env && false) {
  warning = function warning3(type2, errors) {
    if (typeof console !== "undefined" && console.warn) {
      if (errors.every(function(e) {
        return typeof e === "string";
      })) {
        console.warn(type2, errors);
      }
    }
  };
}
function convertFieldsError(errors) {
  if (!errors || !errors.length)
    return null;
  var fields = {};
  errors.forEach(function(error) {
    var field = error.field;
    fields[field] = fields[field] || [];
    fields[field].push(error);
  });
  return fields;
}
function format() {
  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }
  var i = 1;
  var f = args[0];
  var len = args.length;
  if (typeof f === "function") {
    return f.apply(null, args.slice(1));
  }
  if (typeof f === "string") {
    var str = String(f).replace(formatRegExp, function(x) {
      if (x === "%%") {
        return "%";
      }
      if (i >= len) {
        return x;
      }
      switch (x) {
        case "%s":
          return String(args[i++]);
        case "%d":
          return Number(args[i++]);
        case "%j":
          try {
            return JSON.stringify(args[i++]);
          } catch (_) {
            return "[Circular]";
          }
          break;
        default:
          return x;
      }
    });
    return str;
  }
  return f;
}
function isNativeStringType(type2) {
  return type2 === "string" || type2 === "url" || type2 === "hex" || type2 === "email" || type2 === "date" || type2 === "pattern";
}
function isEmptyValue(value, type2) {
  if (value === void 0 || value === null) {
    return true;
  }
  if (type2 === "array" && Array.isArray(value) && !value.length) {
    return true;
  }
  if (isNativeStringType(type2) && typeof value === "string" && !value) {
    return true;
  }
  return false;
}
function asyncParallelArray(arr, func, callback) {
  var results = [];
  var total = 0;
  var arrLength = arr.length;
  function count(errors) {
    results.push.apply(results, errors);
    total++;
    if (total === arrLength) {
      callback(results);
    }
  }
  arr.forEach(function(a) {
    func(a, count);
  });
}
function asyncSerialArray(arr, func, callback) {
  var index2 = 0;
  var arrLength = arr.length;
  function next(errors) {
    if (errors && errors.length) {
      callback(errors);
      return;
    }
    var original = index2;
    index2 = index2 + 1;
    if (original < arrLength) {
      func(arr[original], next);
    } else {
      callback([]);
    }
  }
  next([]);
}
function flattenObjArr(objArr) {
  var ret = [];
  Object.keys(objArr).forEach(function(k) {
    ret.push.apply(ret, objArr[k]);
  });
  return ret;
}
var AsyncValidationError = /* @__PURE__ */ function(_Error) {
  _inheritsLoose(AsyncValidationError2, _Error);
  function AsyncValidationError2(errors, fields) {
    var _this;
    _this = _Error.call(this, "Async Validation Error") || this;
    _this.errors = errors;
    _this.fields = fields;
    return _this;
  }
  return AsyncValidationError2;
}(/* @__PURE__ */ _wrapNativeSuper(Error));
function asyncMap(objArr, option, func, callback) {
  if (option.first) {
    var _pending = new Promise(function(resolve, reject) {
      var next = function next2(errors) {
        callback(errors);
        return errors.length ? reject(new AsyncValidationError(errors, convertFieldsError(errors))) : resolve();
      };
      var flattenArr = flattenObjArr(objArr);
      asyncSerialArray(flattenArr, func, next);
    });
    _pending["catch"](function(e) {
      return e;
    });
    return _pending;
  }
  var firstFields = option.firstFields || [];
  if (firstFields === true) {
    firstFields = Object.keys(objArr);
  }
  var objArrKeys = Object.keys(objArr);
  var objArrLength = objArrKeys.length;
  var total = 0;
  var results = [];
  var pending = new Promise(function(resolve, reject) {
    var next = function next2(errors) {
      results.push.apply(results, errors);
      total++;
      if (total === objArrLength) {
        callback(results);
        return results.length ? reject(new AsyncValidationError(results, convertFieldsError(results))) : resolve();
      }
    };
    if (!objArrKeys.length) {
      callback(results);
      resolve();
    }
    objArrKeys.forEach(function(key2) {
      var arr = objArr[key2];
      if (firstFields.indexOf(key2) !== -1) {
        asyncSerialArray(arr, func, next);
      } else {
        asyncParallelArray(arr, func, next);
      }
    });
  });
  pending["catch"](function(e) {
    return e;
  });
  return pending;
}
function complementError(rule) {
  return function(oe) {
    if (oe && oe.message) {
      oe.field = oe.field || rule.fullField;
      return oe;
    }
    return {
      message: typeof oe === "function" ? oe() : oe,
      field: oe.field || rule.fullField
    };
  };
}
function deepMerge(target, source) {
  if (source) {
    for (var s in source) {
      if (source.hasOwnProperty(s)) {
        var value = source[s];
        if (typeof value === "object" && typeof target[s] === "object") {
          target[s] = _extends({}, target[s], value);
        } else {
          target[s] = value;
        }
      }
    }
  }
  return target;
}
function required(rule, value, source, errors, options, type2) {
  if (rule.required && (!source.hasOwnProperty(rule.field) || isEmptyValue(value, type2 || rule.type))) {
    errors.push(format(options.messages.required, rule.fullField));
  }
}
function whitespace(rule, value, source, errors, options) {
  if (/^\s+$/.test(value) || value === "") {
    errors.push(format(options.messages.whitespace, rule.fullField));
  }
}
var pattern = {
  email: /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/,
  url: new RegExp("^(?!mailto:)(?:(?:http|https|ftp)://|//)(?:\\S+(?::\\S*)?@)?(?:(?:(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}(?:\\.(?:[0-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4]))|(?:(?:[a-z\\u00a1-\\uffff0-9]+-*)*[a-z\\u00a1-\\uffff0-9]+)(?:\\.(?:[a-z\\u00a1-\\uffff0-9]+-*)*[a-z\\u00a1-\\uffff0-9]+)*(?:\\.(?:[a-z\\u00a1-\\uffff]{2,})))|localhost)(?::\\d{2,5})?(?:(/|\\?|#)[^\\s]*)?$", "i"),
  hex: /^#?([a-f0-9]{6}|[a-f0-9]{3})$/i
};
var types = {
  integer: function integer(value) {
    return types.number(value) && parseInt(value, 10) === value;
  },
  "float": function float(value) {
    return types.number(value) && !types.integer(value);
  },
  array: function array(value) {
    return Array.isArray(value);
  },
  regexp: function regexp(value) {
    if (value instanceof RegExp) {
      return true;
    }
    try {
      return !!new RegExp(value);
    } catch (e) {
      return false;
    }
  },
  date: function date(value) {
    return typeof value.getTime === "function" && typeof value.getMonth === "function" && typeof value.getYear === "function" && !isNaN(value.getTime());
  },
  number: function number(value) {
    if (isNaN(value)) {
      return false;
    }
    return typeof value === "number";
  },
  object: function object(value) {
    return typeof value === "object" && !types.array(value);
  },
  method: function method(value) {
    return typeof value === "function";
  },
  email: function email(value) {
    return typeof value === "string" && !!value.match(pattern.email) && value.length < 255;
  },
  url: function url(value) {
    return typeof value === "string" && !!value.match(pattern.url);
  },
  hex: function hex(value) {
    return typeof value === "string" && !!value.match(pattern.hex);
  }
};
function type(rule, value, source, errors, options) {
  if (rule.required && value === void 0) {
    required(rule, value, source, errors, options);
    return;
  }
  var custom = ["integer", "float", "array", "regexp", "object", "method", "email", "number", "date", "url", "hex"];
  var ruleType = rule.type;
  if (custom.indexOf(ruleType) > -1) {
    if (!types[ruleType](value)) {
      errors.push(format(options.messages.types[ruleType], rule.fullField, rule.type));
    }
  } else if (ruleType && typeof value !== rule.type) {
    errors.push(format(options.messages.types[ruleType], rule.fullField, rule.type));
  }
}
function range(rule, value, source, errors, options) {
  var len = typeof rule.len === "number";
  var min = typeof rule.min === "number";
  var max = typeof rule.max === "number";
  var spRegexp = /[\uD800-\uDBFF][\uDC00-\uDFFF]/g;
  var val = value;
  var key2 = null;
  var num = typeof value === "number";
  var str = typeof value === "string";
  var arr = Array.isArray(value);
  if (num) {
    key2 = "number";
  } else if (str) {
    key2 = "string";
  } else if (arr) {
    key2 = "array";
  }
  if (!key2) {
    return false;
  }
  if (arr) {
    val = value.length;
  }
  if (str) {
    val = value.replace(spRegexp, "_").length;
  }
  if (len) {
    if (val !== rule.len) {
      errors.push(format(options.messages[key2].len, rule.fullField, rule.len));
    }
  } else if (min && !max && val < rule.min) {
    errors.push(format(options.messages[key2].min, rule.fullField, rule.min));
  } else if (max && !min && val > rule.max) {
    errors.push(format(options.messages[key2].max, rule.fullField, rule.max));
  } else if (min && max && (val < rule.min || val > rule.max)) {
    errors.push(format(options.messages[key2].range, rule.fullField, rule.min, rule.max));
  }
}
var ENUM = "enum";
function enumerable(rule, value, source, errors, options) {
  rule[ENUM] = Array.isArray(rule[ENUM]) ? rule[ENUM] : [];
  if (rule[ENUM].indexOf(value) === -1) {
    errors.push(format(options.messages[ENUM], rule.fullField, rule[ENUM].join(", ")));
  }
}
function pattern$1(rule, value, source, errors, options) {
  if (rule.pattern) {
    if (rule.pattern instanceof RegExp) {
      rule.pattern.lastIndex = 0;
      if (!rule.pattern.test(value)) {
        errors.push(format(options.messages.pattern.mismatch, rule.fullField, value, rule.pattern));
      }
    } else if (typeof rule.pattern === "string") {
      var _pattern = new RegExp(rule.pattern);
      if (!_pattern.test(value)) {
        errors.push(format(options.messages.pattern.mismatch, rule.fullField, value, rule.pattern));
      }
    }
  }
}
var rules = {
  required,
  whitespace,
  type,
  range,
  "enum": enumerable,
  pattern: pattern$1
};
function string(rule, value, callback, source, options) {
  var errors = [];
  var validate2 = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate2) {
    if (isEmptyValue(value, "string") && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options, "string");
    if (!isEmptyValue(value, "string")) {
      rules.type(rule, value, source, errors, options);
      rules.range(rule, value, source, errors, options);
      rules.pattern(rule, value, source, errors, options);
      if (rule.whitespace === true) {
        rules.whitespace(rule, value, source, errors, options);
      }
    }
  }
  callback(errors);
}
function method2(rule, value, callback, source, options) {
  var errors = [];
  var validate2 = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate2) {
    if (isEmptyValue(value) && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options);
    if (value !== void 0) {
      rules.type(rule, value, source, errors, options);
    }
  }
  callback(errors);
}
function number2(rule, value, callback, source, options) {
  var errors = [];
  var validate2 = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate2) {
    if (value === "") {
      value = void 0;
    }
    if (isEmptyValue(value) && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options);
    if (value !== void 0) {
      rules.type(rule, value, source, errors, options);
      rules.range(rule, value, source, errors, options);
    }
  }
  callback(errors);
}
function _boolean(rule, value, callback, source, options) {
  var errors = [];
  var validate2 = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate2) {
    if (isEmptyValue(value) && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options);
    if (value !== void 0) {
      rules.type(rule, value, source, errors, options);
    }
  }
  callback(errors);
}
function regexp2(rule, value, callback, source, options) {
  var errors = [];
  var validate2 = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate2) {
    if (isEmptyValue(value) && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options);
    if (!isEmptyValue(value)) {
      rules.type(rule, value, source, errors, options);
    }
  }
  callback(errors);
}
function integer2(rule, value, callback, source, options) {
  var errors = [];
  var validate2 = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate2) {
    if (isEmptyValue(value) && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options);
    if (value !== void 0) {
      rules.type(rule, value, source, errors, options);
      rules.range(rule, value, source, errors, options);
    }
  }
  callback(errors);
}
function floatFn(rule, value, callback, source, options) {
  var errors = [];
  var validate2 = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate2) {
    if (isEmptyValue(value) && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options);
    if (value !== void 0) {
      rules.type(rule, value, source, errors, options);
      rules.range(rule, value, source, errors, options);
    }
  }
  callback(errors);
}
function array2(rule, value, callback, source, options) {
  var errors = [];
  var validate2 = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate2) {
    if ((value === void 0 || value === null) && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options, "array");
    if (value !== void 0 && value !== null) {
      rules.type(rule, value, source, errors, options);
      rules.range(rule, value, source, errors, options);
    }
  }
  callback(errors);
}
function object$1(rule, value, callback, source, options) {
  var errors = [];
  var validate2 = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate2) {
    if (isEmptyValue(value) && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options);
    if (value !== void 0) {
      rules.type(rule, value, source, errors, options);
    }
  }
  callback(errors);
}
var ENUM$1 = "enum";
function enumerable$1(rule, value, callback, source, options) {
  var errors = [];
  var validate2 = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate2) {
    if (isEmptyValue(value) && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options);
    if (value !== void 0) {
      rules[ENUM$1](rule, value, source, errors, options);
    }
  }
  callback(errors);
}
function pattern$2(rule, value, callback, source, options) {
  var errors = [];
  var validate2 = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate2) {
    if (isEmptyValue(value, "string") && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options);
    if (!isEmptyValue(value, "string")) {
      rules.pattern(rule, value, source, errors, options);
    }
  }
  callback(errors);
}
function date2(rule, value, callback, source, options) {
  var errors = [];
  var validate2 = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate2) {
    if (isEmptyValue(value, "date") && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options);
    if (!isEmptyValue(value, "date")) {
      var dateObject;
      if (value instanceof Date) {
        dateObject = value;
      } else {
        dateObject = new Date(value);
      }
      rules.type(rule, dateObject, source, errors, options);
      if (dateObject) {
        rules.range(rule, dateObject.getTime(), source, errors, options);
      }
    }
  }
  callback(errors);
}
function required$1(rule, value, callback, source, options) {
  var errors = [];
  var type2 = Array.isArray(value) ? "array" : typeof value;
  rules.required(rule, value, source, errors, options, type2);
  callback(errors);
}
function type$1(rule, value, callback, source, options) {
  var ruleType = rule.type;
  var errors = [];
  var validate2 = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate2) {
    if (isEmptyValue(value, ruleType) && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options, ruleType);
    if (!isEmptyValue(value, ruleType)) {
      rules.type(rule, value, source, errors, options);
    }
  }
  callback(errors);
}
function any(rule, value, callback, source, options) {
  var errors = [];
  var validate2 = rule.required || !rule.required && source.hasOwnProperty(rule.field);
  if (validate2) {
    if (isEmptyValue(value) && !rule.required) {
      return callback();
    }
    rules.required(rule, value, source, errors, options);
  }
  callback(errors);
}
var validators = {
  string,
  method: method2,
  number: number2,
  "boolean": _boolean,
  regexp: regexp2,
  integer: integer2,
  "float": floatFn,
  array: array2,
  object: object$1,
  "enum": enumerable$1,
  pattern: pattern$2,
  date: date2,
  url: type$1,
  hex: type$1,
  email: type$1,
  required: required$1,
  any
};
function newMessages() {
  return {
    "default": "Validation error on field %s",
    required: "%s is required",
    "enum": "%s must be one of %s",
    whitespace: "%s cannot be empty",
    date: {
      format: "%s date %s is invalid for format %s",
      parse: "%s date could not be parsed, %s is invalid ",
      invalid: "%s date %s is invalid"
    },
    types: {
      string: "%s is not a %s",
      method: "%s is not a %s (function)",
      array: "%s is not an %s",
      object: "%s is not an %s",
      number: "%s is not a %s",
      date: "%s is not a %s",
      "boolean": "%s is not a %s",
      integer: "%s is not an %s",
      "float": "%s is not a %s",
      regexp: "%s is not a valid %s",
      email: "%s is not a valid %s",
      url: "%s is not a valid %s",
      hex: "%s is not a valid %s"
    },
    string: {
      len: "%s must be exactly %s characters",
      min: "%s must be at least %s characters",
      max: "%s cannot be longer than %s characters",
      range: "%s must be between %s and %s characters"
    },
    number: {
      len: "%s must equal %s",
      min: "%s cannot be less than %s",
      max: "%s cannot be greater than %s",
      range: "%s must be between %s and %s"
    },
    array: {
      len: "%s must be exactly %s in length",
      min: "%s cannot be less than %s in length",
      max: "%s cannot be greater than %s in length",
      range: "%s must be between %s and %s in length"
    },
    pattern: {
      mismatch: "%s value %s does not match pattern %s"
    },
    clone: function clone2() {
      var cloned = JSON.parse(JSON.stringify(this));
      cloned.clone = this.clone;
      return cloned;
    }
  };
}
var messages = newMessages();
function Schema(descriptor) {
  this.rules = null;
  this._messages = messages;
  this.define(descriptor);
}
Schema.prototype = {
  messages: function messages2(_messages) {
    if (_messages) {
      this._messages = deepMerge(newMessages(), _messages);
    }
    return this._messages;
  },
  define: function define(rules2) {
    if (!rules2) {
      throw new Error("Cannot configure a schema with no rules");
    }
    if (typeof rules2 !== "object" || Array.isArray(rules2)) {
      throw new Error("Rules must be an object");
    }
    this.rules = {};
    var z;
    var item;
    for (z in rules2) {
      if (rules2.hasOwnProperty(z)) {
        item = rules2[z];
        this.rules[z] = Array.isArray(item) ? item : [item];
      }
    }
  },
  validate: function validate(source_, o, oc) {
    var _this = this;
    if (o === void 0) {
      o = {};
    }
    if (oc === void 0) {
      oc = function oc2() {
      };
    }
    var source = source_;
    var options = o;
    var callback = oc;
    if (typeof options === "function") {
      callback = options;
      options = {};
    }
    if (!this.rules || Object.keys(this.rules).length === 0) {
      if (callback) {
        callback();
      }
      return Promise.resolve();
    }
    function complete(results) {
      var i;
      var errors = [];
      var fields = {};
      function add(e) {
        if (Array.isArray(e)) {
          var _errors;
          errors = (_errors = errors).concat.apply(_errors, e);
        } else {
          errors.push(e);
        }
      }
      for (i = 0; i < results.length; i++) {
        add(results[i]);
      }
      if (!errors.length) {
        errors = null;
        fields = null;
      } else {
        fields = convertFieldsError(errors);
      }
      callback(errors, fields);
    }
    if (options.messages) {
      var messages$1 = this.messages();
      if (messages$1 === messages) {
        messages$1 = newMessages();
      }
      deepMerge(messages$1, options.messages);
      options.messages = messages$1;
    } else {
      options.messages = this.messages();
    }
    var arr;
    var value;
    var series = {};
    var keys = options.keys || Object.keys(this.rules);
    keys.forEach(function(z) {
      arr = _this.rules[z];
      value = source[z];
      arr.forEach(function(r) {
        var rule = r;
        if (typeof rule.transform === "function") {
          if (source === source_) {
            source = _extends({}, source);
          }
          value = source[z] = rule.transform(value);
        }
        if (typeof rule === "function") {
          rule = {
            validator: rule
          };
        } else {
          rule = _extends({}, rule);
        }
        rule.validator = _this.getValidationMethod(rule);
        rule.field = z;
        rule.fullField = rule.fullField || z;
        rule.type = _this.getType(rule);
        if (!rule.validator) {
          return;
        }
        series[z] = series[z] || [];
        series[z].push({
          rule,
          value,
          source,
          field: z
        });
      });
    });
    var errorFields = {};
    return asyncMap(series, options, function(data, doIt) {
      var rule = data.rule;
      var deep = (rule.type === "object" || rule.type === "array") && (typeof rule.fields === "object" || typeof rule.defaultField === "object");
      deep = deep && (rule.required || !rule.required && data.value);
      rule.field = data.field;
      function addFullfield(key2, schema) {
        return _extends({}, schema, {
          fullField: rule.fullField + "." + key2
        });
      }
      function cb(e) {
        if (e === void 0) {
          e = [];
        }
        var errors = e;
        if (!Array.isArray(errors)) {
          errors = [errors];
        }
        if (!options.suppressWarning && errors.length) {
          Schema.warning("async-validator:", errors);
        }
        if (errors.length && rule.message !== void 0) {
          errors = [].concat(rule.message);
        }
        errors = errors.map(complementError(rule));
        if (options.first && errors.length) {
          errorFields[rule.field] = 1;
          return doIt(errors);
        }
        if (!deep) {
          doIt(errors);
        } else {
          if (rule.required && !data.value) {
            if (rule.message !== void 0) {
              errors = [].concat(rule.message).map(complementError(rule));
            } else if (options.error) {
              errors = [options.error(rule, format(options.messages.required, rule.field))];
            }
            return doIt(errors);
          }
          var fieldsSchema = {};
          if (rule.defaultField) {
            for (var k in data.value) {
              if (data.value.hasOwnProperty(k)) {
                fieldsSchema[k] = rule.defaultField;
              }
            }
          }
          fieldsSchema = _extends({}, fieldsSchema, data.rule.fields);
          for (var f in fieldsSchema) {
            if (fieldsSchema.hasOwnProperty(f)) {
              var fieldSchema = Array.isArray(fieldsSchema[f]) ? fieldsSchema[f] : [fieldsSchema[f]];
              fieldsSchema[f] = fieldSchema.map(addFullfield.bind(null, f));
            }
          }
          var schema = new Schema(fieldsSchema);
          schema.messages(options.messages);
          if (data.rule.options) {
            data.rule.options.messages = options.messages;
            data.rule.options.error = options.error;
          }
          schema.validate(data.value, data.rule.options || options, function(errs) {
            var finalErrors = [];
            if (errors && errors.length) {
              finalErrors.push.apply(finalErrors, errors);
            }
            if (errs && errs.length) {
              finalErrors.push.apply(finalErrors, errs);
            }
            doIt(finalErrors.length ? finalErrors : null);
          });
        }
      }
      var res;
      if (rule.asyncValidator) {
        res = rule.asyncValidator(rule, data.value, cb, data.source, options);
      } else if (rule.validator) {
        res = rule.validator(rule, data.value, cb, data.source, options);
        if (res === true) {
          cb();
        } else if (res === false) {
          cb(rule.message || rule.field + " fails");
        } else if (res instanceof Array) {
          cb(res);
        } else if (res instanceof Error) {
          cb(res.message);
        }
      }
      if (res && res.then) {
        res.then(function() {
          return cb();
        }, function(e) {
          return cb(e);
        });
      }
    }, function(results) {
      complete(results);
    });
  },
  getType: function getType(rule) {
    if (rule.type === void 0 && rule.pattern instanceof RegExp) {
      rule.type = "pattern";
    }
    if (typeof rule.validator !== "function" && rule.type && !validators.hasOwnProperty(rule.type)) {
      throw new Error(format("Unknown rule type %s", rule.type));
    }
    return rule.type || "string";
  },
  getValidationMethod: function getValidationMethod(rule) {
    if (typeof rule.validator === "function") {
      return rule.validator;
    }
    var keys = Object.keys(rule);
    var messageIndex = keys.indexOf("message");
    if (messageIndex !== -1) {
      keys.splice(messageIndex, 1);
    }
    if (keys.length === 1 && keys[0] === "required") {
      return validators.required;
    }
    return validators[this.getType(rule)] || false;
  }
};
Schema.register = function register(type2, validator) {
  if (typeof validator !== "function") {
    throw new Error("Cannot register a validator by type, validator is not a function");
  }
  validators[type2] = validator;
};
Schema.warning = warning;
Schema.messages = messages;
Schema.validators = validators;
const prefixCls$14 = "ivu-form-item";
function getPropByPath(obj, path) {
  let tempObj = obj;
  path = path.replace(/\[(\w+)\]/g, ".$1");
  path = path.replace(/^\./, "");
  let keyArr = path.split(".");
  let i = 0;
  for (let len = keyArr.length; i < len - 1; ++i) {
    let key2 = keyArr[i];
    if (key2 in tempObj) {
      tempObj = tempObj[key2];
    } else {
      throw new Error("[View UI warn]: please transfer a valid prop path to form item!");
    }
  }
  return {
    o: tempObj,
    k: keyArr[i],
    v: tempObj[keyArr[i]]
  };
}
const _sfc_main$23 = {
  name: "FormItem",
  inject: ["FormInstance"],
  provide() {
    return {
      FormItemInstance: this
    };
  },
  props: {
    label: {
      type: String,
      default: ""
    },
    labelWidth: {
      type: Number
    },
    prop: {
      type: String
    },
    required: {
      type: Boolean,
      default: false
    },
    rules: {
      type: [Object, Array]
    },
    error: {
      type: String
    },
    validateStatus: {
      type: Boolean
    },
    showMessage: {
      type: Boolean,
      default: true
    },
    labelFor: {
      type: String
    }
  },
  data() {
    return {
      prefixCls: prefixCls$14,
      isRequired: false,
      validateState: "",
      validateMessage: "",
      validateDisabled: false,
      validator: {}
    };
  },
  watch: {
    error: {
      handler(val) {
        this.validateMessage = val;
        this.validateState = val ? "error" : "";
      },
      immediate: true
    },
    validateStatus(val) {
      this.validateState = val;
    },
    rules() {
      this.setRules();
    },
    required(n, o) {
      this.isRequired = n;
      if (o && !n) {
        this.resetField();
      }
    }
  },
  computed: {
    classes() {
      return [
        `${prefixCls$14}`,
        {
          [`${prefixCls$14}-required`]: this.required || this.isRequired,
          [`${prefixCls$14}-error`]: this.validateState === "error",
          [`${prefixCls$14}-validating`]: this.validateState === "validating"
        }
      ];
    },
    fieldValue() {
      const model = this.FormInstance.model;
      if (!model || !this.prop) {
        return;
      }
      let path = this.prop;
      if (path.indexOf(":") !== -1) {
        path = path.replace(/:/, ".");
      }
      return getPropByPath(model, path).v;
    },
    labelStyles() {
      let style2 = {};
      const labelWidth = this.labelWidth === 0 || this.labelWidth ? this.labelWidth : this.FormInstance.labelWidth;
      if (labelWidth || labelWidth === 0) {
        style2.width = `${labelWidth}px`;
      }
      return style2;
    },
    contentStyles() {
      let style2 = {};
      const labelWidth = this.labelWidth === 0 || this.labelWidth ? this.labelWidth : this.FormInstance.labelWidth;
      if (labelWidth || labelWidth === 0) {
        style2.marginLeft = `${labelWidth}px`;
      }
      return style2;
    }
  },
  methods: {
    setRules() {
      let rules2 = this.getRules();
      if (rules2.length && this.required) {
        return;
      } else if (rules2.length) {
        rules2.every((rule) => {
          this.isRequired = rule.required;
        });
      } else if (this.required) {
        this.isRequired = this.required;
      }
    },
    getRules() {
      let formRules = this.FormInstance.rules;
      const selfRules = this.rules;
      formRules = formRules ? formRules[this.prop] : [];
      return [].concat(selfRules || formRules || []);
    },
    getFilteredRule(trigger) {
      const rules2 = this.getRules();
      return rules2.filter((rule) => !rule.trigger || rule.trigger.indexOf(trigger) !== -1);
    },
    validate(trigger, callback = function() {
    }) {
      let rules2 = this.getFilteredRule(trigger);
      if (!rules2 || rules2.length === 0) {
        if (!this.required) {
          callback();
          return true;
        } else {
          rules2 = [{ required: true }];
        }
      }
      this.validateState = "validating";
      let descriptor = {};
      descriptor[this.prop] = rules2;
      const validator = new Schema(descriptor);
      let model = {};
      model[this.prop] = this.fieldValue;
      validator.validate(model, { firstFields: true }, (errors) => {
        this.validateState = !errors ? "success" : "error";
        this.validateMessage = errors ? errors[0].message : "";
        callback(this.validateMessage);
        this.FormInstance && this.FormInstance.$emit("on-validate", this.prop, !errors, this.validateMessage || null);
      });
      this.validateDisabled = false;
    },
    resetField() {
      this.validateState = "";
      this.validateMessage = "";
      let model = this.FormInstance.model;
      let value = this.fieldValue;
      let path = this.prop;
      if (path.indexOf(":") !== -1) {
        path = path.replace(/:/, ".");
      }
      let prop2 = getPropByPath(model, path);
      if (Array.isArray(value) && this.initialValue !== null) {
        this.validateDisabled = true;
        prop2.o[prop2.k] = [].concat(this.initialValue);
      } else {
        this.validateDisabled = true;
        prop2.o[prop2.k] = this.initialValue;
      }
    },
    onFieldBlur() {
      this.validate("blur");
    },
    onFieldChange() {
      if (this.validateDisabled) {
        this.validateDisabled = false;
        return;
      }
      this.validate("change");
    },
    formBlur() {
      this.onFieldBlur();
    },
    formChange() {
      this.onFieldChange();
    }
  },
  mounted() {
    if (this.prop) {
      this.FormInstance.addField(this);
      Object.defineProperty(this, "initialValue", {
        value: this.fieldValue
      });
      this.setRules();
    }
  },
  beforeUnmount() {
    this.FormInstance.removeField(this);
  }
};
const _hoisted_1$13 = ["for"];
function _sfc_render$1Q(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes)
  }, [
    $props.label || _ctx.$slots.label ? (openBlock(), createElementBlock("label", {
      key: 0,
      class: normalizeClass([$data.prefixCls + "-label"]),
      for: $props.labelFor,
      style: normalizeStyle($options.labelStyles)
    }, [
      renderSlot(_ctx.$slots, "label", {}, () => [
        createTextVNode(toDisplayString($props.label) + toDisplayString($options.FormInstance.colon), 1)
      ])
    ], 14, _hoisted_1$13)) : createCommentVNode("", true),
    createElementVNode("div", {
      class: normalizeClass([$data.prefixCls + "-content"]),
      style: normalizeStyle($options.contentStyles)
    }, [
      renderSlot(_ctx.$slots, "default"),
      createVNode(Transition, { name: "fade" }, {
        default: withCtx(() => [
          $data.validateState === "error" && $props.showMessage && $options.FormInstance.showMessage ? (openBlock(), createElementBlock("div", {
            key: 0,
            class: normalizeClass([$data.prefixCls + "-error-tip"])
          }, toDisplayString($data.validateMessage), 3)) : createCommentVNode("", true)
        ]),
        _: 1
      })
    ], 6)
  ], 2);
}
var FormItem = /* @__PURE__ */ _export_sfc(_sfc_main$23, [["render", _sfc_render$1Q]]);
var defaultValidateMessage = {
  UserName: "\u8BF7\u8F93\u5165\u7528\u6237\u540D\uFF01",
  Password: "\u8BF7\u8F93\u5165\u5BC6\u7801\uFF01",
  Email: "\u8BF7\u8F93\u5165\u90AE\u7BB1\uFF01",
  Mobile: "\u8BF7\u8F93\u5165\u624B\u673A\u53F7\u7801\uFF01",
  Captcha: "\u8BF7\u8F93\u5165\u9A8C\u8BC1\u7801\uFF01"
};
var LoginItem = {
  inject: ["LoginInstance"],
  emits: ["on-change"],
  props: {
    rules: {
      type: [Object, Array],
      default() {
        const componentName = getCurrentInstance().type.name;
        return [
          {
            required: true,
            message: defaultValidateMessage[componentName],
            trigger: "change"
          }
        ];
      }
    },
    value: {
      type: String
    },
    name: {
      type: String,
      required: true
    },
    enterToSubmit: {
      type: Boolean,
      default: false
    }
  },
  data() {
    return {
      prop: ""
    };
  },
  methods: {
    handleChange(val) {
      this.LoginInstance.formValidate[this.prop] = val;
      this.$emit("on-change", val);
    },
    handleEnter() {
      if (this.enterToSubmit)
        this.LoginInstance.handleSubmit();
    },
    handleSetValue() {
      const $props = this.$props;
      if ($props.value) {
        this.LoginInstance.formValidate[this.prop] = $props.value;
      }
    },
    handleGetProps() {
      const $props = this.$props;
      let name2 = $props.name;
      const defaultProps = {
        prefix: this.prefix,
        placeholder: this.placeholder,
        type: this.type,
        size: "large",
        modelValue: this.LoginInstance.formValidate[this.prop]
      };
      if (name2)
        defaultProps.name = name2;
      return Object.assign(defaultProps, this.$attrs);
    }
  },
  render() {
    const finalProps = this.handleGetProps();
    const $input = h(Input, {
      ...finalProps,
      "onUpdate:modelValue": this.handleChange,
      "onOn-enter": this.handleEnter
    });
    const $formitem = h(FormItem, {
      prop: this.prop,
      rules: this.rules
    }, () => [$input]);
    return h("div", {
      class: this.className
    }, [$formitem]);
  },
  created() {
    const name2 = this.name;
    const formValidate = Object.assign({}, this.LoginInstance.formValidate);
    formValidate[name2] = "";
    this.LoginInstance.formValidate = formValidate;
    this.prop = name2;
    this.handleSetValue();
  }
};
const _sfc_main$22 = {
  name: "Captcha",
  mixins: [LoginItem],
  emits: ["on-get-captcha"],
  props: {
    field: {
      type: [String, Array]
    },
    countDown: {
      type: Number,
      default: 60
    },
    text: {
      type: String
    },
    unitText: {
      type: String,
      default: "\u79D2"
    },
    beforeClick: Function
  },
  data() {
    return {
      className: "ivu-login-captcha",
      prefix: "ios-keypad-outline",
      placeholder: "\u8BF7\u8F93\u5165\u9A8C\u8BC1\u7801",
      type: "text",
      buttonDisabled: false,
      limitCountDown: 0
    };
  },
  methods: {
    handleClickCaptcha() {
      if (this.field) {
        const fields = typeof this.field === "string" ? [this.field] : this.field;
        this.LoginInstance.handleValidate(fields, (status) => {
          if (status)
            this.handleBeforeGetCaptcha();
        });
      } else {
        this.handleBeforeGetCaptcha();
      }
    },
    handleBeforeGetCaptcha() {
      if (!this.beforeClick) {
        return this.handleGetCaptcha();
      }
      const before = this.beforeClick();
      if (before && before.then) {
        before.then(() => {
          this.handleGetCaptcha();
        });
      } else {
        this.handleGetCaptcha();
      }
    },
    handleGetCaptcha() {
      if (this.countDown > 0) {
        this.buttonDisabled = true;
        this.limitCountDown = this.countDown;
        this.handleCountDown();
      }
      this.$emit("on-get-captcha", this.LoginInstance.formValidate[this.prop], JSON.parse(JSON.stringify(this.LoginInstance.formValidate)));
    },
    handleCountDown() {
      this.timer = setTimeout(() => {
        this.limitCountDown--;
        if (this.limitCountDown === 0) {
          this.buttonDisabled = false;
          clearTimeout(this.timer);
        } else {
          this.handleCountDown();
        }
      }, 1e3);
    }
  },
  render() {
    const $attrs = this.$attrs;
    const finalProps = this.handleGetProps();
    const defaultButtonProps = {
      size: "large",
      type: "default",
      long: true,
      disabled: this.buttonDisabled
    };
    if ("size" in $attrs)
      defaultButtonProps.size = $attrs.size;
    if ("button-type" in $attrs)
      defaultButtonProps.type = $attrs["button-type"];
    let buttonSlot;
    if (this.$slots.text) {
      buttonSlot = this.$slots.text;
    } else if (this.limitCountDown !== 0) {
      buttonSlot = () => `${this.limitCountDown} ${this.unitText}`;
    } else if (this.text) {
      buttonSlot = () => this.text;
    } else {
      buttonSlot = () => "\u83B7\u53D6\u9A8C\u8BC1\u7801";
    }
    const $button = h(_sfc_main$2c, {
      ...defaultButtonProps,
      onClick: this.handleClickCaptcha
    }, buttonSlot);
    const $input = h(Input, {
      ...finalProps,
      "onUpdate:modelValue": this.handleChange,
      "onOn-enter": this.handleEnter
    });
    const $colinput = h(Col, {
      span: 16
    }, () => [$input]);
    const $colbutton = h(Col, {
      span: 8
    }, () => [$button]);
    const $row = h(Row, {
      gutter: 8
    }, () => [$colinput, $colbutton]);
    const $formitem = h(FormItem, {
      prop: this.prop,
      rules: this.rules
    }, () => [$row]);
    return h("div", {
      class: this.className
    }, [$formitem]);
  },
  beforeUnmount() {
    if (this.timer)
      clearTimeout(this.timer);
  }
};
const prefixCls$13 = "ivu-card";
const defaultPadding = 16;
const _sfc_main$21 = {
  name: "Card",
  mixins: [mixinsLink],
  components: { Icon },
  props: {
    bordered: {
      type: Boolean,
      default: true
    },
    disHover: {
      type: Boolean,
      default: false
    },
    shadow: {
      type: Boolean,
      default: false
    },
    padding: {
      type: Number,
      default: defaultPadding
    },
    title: {
      type: String
    },
    icon: {
      type: String
    }
  },
  data() {
    return {
      showHead: true,
      showExtra: true
    };
  },
  computed: {
    classes() {
      return [
        `${prefixCls$13}`,
        {
          [`${prefixCls$13}-bordered`]: this.bordered && !this.shadow,
          [`${prefixCls$13}-dis-hover`]: this.disHover || this.shadow,
          [`${prefixCls$13}-shadow`]: this.shadow
        }
      ];
    },
    headClasses() {
      return `${prefixCls$13}-head`;
    },
    extraClasses() {
      return `${prefixCls$13}-extra`;
    },
    bodyClasses() {
      return `${prefixCls$13}-body`;
    },
    bodyStyles() {
      if (this.padding !== defaultPadding) {
        return {
          padding: `${this.padding}px`
        };
      } else {
        return "";
      }
    },
    isHrefPattern() {
      const { to } = this;
      return !!to;
    },
    tagName() {
      const { isHrefPattern } = this;
      return isHrefPattern ? "a" : "div";
    },
    tagProps() {
      const { isHrefPattern } = this;
      if (isHrefPattern) {
        const { linkUrl, target } = this;
        return { href: linkUrl, target };
      } else {
        return {};
      }
    }
  },
  methods: {
    handleClickLink(event) {
      if (!this.isHrefPattern)
        return;
      const openInNewWindow = event.ctrlKey || event.metaKey;
      this.handleCheckClick(event, openInNewWindow);
    }
  },
  mounted() {
    this.showHead = this.title || this.$slots.title !== void 0;
    this.showExtra = this.$slots.extra !== void 0;
  }
};
const _hoisted_1$12 = { key: 0 };
function _sfc_render$1P(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = resolveComponent("Icon");
  return openBlock(), createBlock(resolveDynamicComponent($options.tagName), mergeProps({ class: $options.classes }, $options.tagProps, { onClick: $options.handleClickLink }), {
    default: withCtx(() => [
      $data.showHead ? (openBlock(), createElementBlock("div", {
        key: 0,
        class: normalizeClass($options.headClasses)
      }, [
        renderSlot(_ctx.$slots, "title", {}, () => [
          $props.title ? (openBlock(), createElementBlock("p", _hoisted_1$12, [
            $props.icon ? (openBlock(), createBlock(_component_Icon, {
              key: 0,
              type: $props.icon
            }, null, 8, ["type"])) : createCommentVNode("", true),
            createElementVNode("span", null, toDisplayString($props.title), 1)
          ])) : createCommentVNode("", true)
        ])
      ], 2)) : createCommentVNode("", true),
      $data.showExtra ? (openBlock(), createElementBlock("div", {
        key: 1,
        class: normalizeClass($options.extraClasses)
      }, [
        renderSlot(_ctx.$slots, "extra")
      ], 2)) : createCommentVNode("", true),
      createElementVNode("div", {
        class: normalizeClass($options.bodyClasses),
        style: normalizeStyle($options.bodyStyles)
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 6)
    ]),
    _: 3
  }, 16, ["class", "onClick"]);
}
var Card = /* @__PURE__ */ _export_sfc(_sfc_main$21, [["render", _sfc_render$1P]]);
const prefixCls$12 = "ivu-carousel";
const _sfc_main$20 = {
  name: "Carousel",
  provide() {
    return {
      CarouselInstance: this
    };
  },
  components: { Icon },
  emits: ["on-change", "on-click", "update:modelValue"],
  props: {
    arrow: {
      type: String,
      default: "hover",
      validator(value) {
        return oneOf(value, ["hover", "always", "never"]);
      }
    },
    autoplay: {
      type: Boolean,
      default: false
    },
    autoplaySpeed: {
      type: Number,
      default: 2e3
    },
    loop: {
      type: Boolean,
      default: false
    },
    easing: {
      type: String,
      default: "ease"
    },
    dots: {
      type: String,
      default: "inside",
      validator(value) {
        return oneOf(value, ["inside", "outside", "none"]);
      }
    },
    radiusDot: {
      type: Boolean,
      default: false
    },
    trigger: {
      type: String,
      default: "click",
      validator(value) {
        return oneOf(value, ["click", "hover"]);
      }
    },
    modelValue: {
      type: Number,
      default: 0
    },
    height: {
      type: [String, Number],
      default: "auto",
      validator(value) {
        return value === "auto" || Object.prototype.toString.call(value) === "[object Number]";
      }
    }
  },
  data() {
    return {
      prefixCls: prefixCls$12,
      listWidth: 0,
      trackWidth: 0,
      trackOffset: 0,
      trackCopyOffset: 0,
      showCopyTrack: false,
      slides: [],
      slideInstances: [],
      timer: null,
      ready: false,
      currentIndex: this.modelValue,
      trackIndex: this.modelValue,
      copyTrackIndex: this.modelValue,
      hideTrackPos: -1,
      carouselItemList: []
    };
  },
  computed: {
    classes() {
      return [
        `${prefixCls$12}`
      ];
    },
    trackStyles() {
      const visibleStyle = this.trackIndex === -1 ? "hidden" : "visible";
      return {
        width: `${this.trackWidth}px`,
        transform: `translate3d(${-this.trackOffset}px, 0px, 0px)`,
        transition: `transform 500ms ${this.easing}`,
        visibility: visibleStyle
      };
    },
    copyTrackStyles() {
      return {
        width: `${this.trackWidth}px`,
        transform: `translate3d(${-this.trackCopyOffset}px, 0px, 0px)`,
        transition: `transform 500ms ${this.easing}`,
        position: "absolute"
      };
    },
    arrowClasses() {
      return [
        `${prefixCls$12}-arrow`,
        `${prefixCls$12}-arrow-${this.arrow}`
      ];
    },
    dotsClasses() {
      return [
        `${prefixCls$12}-dots`,
        `${prefixCls$12}-dots-${this.dots}`
      ];
    }
  },
  methods: {
    findChild(cb) {
      if (this.carouselItemList.length) {
        this.carouselItemList.forEach((item) => {
          cb(item.carouselItem);
        });
      }
    },
    initCopyTrackDom() {
      nextTick(() => {
        this.$refs.copyTrack.innerHTML = this.$refs.originTrack.innerHTML;
      });
    },
    updateSlides(init) {
      let slides = [];
      let index2 = 1;
      this.findChild((child) => {
        slides.push({
          $el: child.$el
        });
        child.index = index2++;
        if (init) {
          this.slideInstances.push(child);
        }
      });
      this.slides = slides;
      this.updatePos();
    },
    updatePos() {
      this.findChild((child) => {
        child.width = this.listWidth;
        child.height = typeof this.height === "number" ? `${this.height}px` : this.height;
      });
      this.trackWidth = (this.slides.length || 0) * this.listWidth;
    },
    slotChange() {
      nextTick(() => {
        this.slides = [];
        this.slideInstances = [];
        this.updateSlides(true, true);
        this.updatePos();
        this.updateOffset();
      });
    },
    handleResize() {
      this.listWidth = parseInt(getStyle(this.$el, "width"));
      this.updatePos();
      this.updateOffset();
    },
    updateTrackPos(index2) {
      if (this.showCopyTrack) {
        this.trackIndex = index2;
      } else {
        this.copyTrackIndex = index2;
      }
    },
    updateTrackIndex(index2) {
      if (this.showCopyTrack) {
        this.copyTrackIndex = index2;
      } else {
        this.trackIndex = index2;
      }
      this.currentIndex = index2;
    },
    add(offset) {
      let slidesLen = this.slides.length;
      if (this.loop) {
        if (offset > 0) {
          this.hideTrackPos = -1;
        } else {
          this.hideTrackPos = slidesLen;
        }
        this.updateTrackPos(this.hideTrackPos);
      }
      const oldIndex = this.showCopyTrack ? this.copyTrackIndex : this.trackIndex;
      let index2 = oldIndex + offset;
      while (index2 < 0)
        index2 += slidesLen;
      if ((offset > 0 && index2 === slidesLen || offset < 0 && index2 === slidesLen - 1) && this.loop) {
        this.showCopyTrack = !this.showCopyTrack;
        this.trackIndex += offset;
        this.copyTrackIndex += offset;
      } else {
        if (!this.loop)
          index2 = index2 % this.slides.length;
        this.updateTrackIndex(index2);
      }
      this.currentIndex = index2 === this.slides.length ? 0 : index2;
      this.$emit("on-change", oldIndex, this.currentIndex);
      this.$emit("update:modelValue", this.currentIndex);
    },
    arrowEvent(offset) {
      this.setAutoplay();
      this.add(offset);
    },
    dotsEvent(event, n) {
      let curIndex = this.showCopyTrack ? this.copyTrackIndex : this.trackIndex;
      const oldCurrentIndex = this.currentIndex;
      if (event === this.trigger && curIndex !== n) {
        this.updateTrackIndex(n);
        this.$emit("on-change", oldCurrentIndex, this.currentIndex);
        this.$emit("update:modelValue", n);
        this.setAutoplay();
      }
    },
    setAutoplay() {
      if (!isClient)
        return;
      window.clearInterval(this.timer);
      if (this.autoplay) {
        this.timer = window.setInterval(() => {
          this.add(1);
        }, this.autoplaySpeed);
      }
    },
    updateOffset() {
      nextTick(() => {
        let ofs = this.copyTrackIndex > 0 ? -1 : 1;
        this.trackOffset = this.trackIndex * this.listWidth;
        this.trackCopyOffset = this.copyTrackIndex * this.listWidth + ofs;
      });
    },
    handleClick(type2) {
      this.$emit("on-click", this[type2]);
    }
  },
  watch: {
    autoplay() {
      this.setAutoplay();
    },
    autoplaySpeed() {
      this.setAutoplay();
    },
    trackIndex() {
      this.updateOffset();
    },
    copyTrackIndex() {
      this.updateOffset();
    },
    height() {
      this.updatePos();
    },
    modelValue(val) {
      this.updateTrackIndex(val);
      this.setAutoplay();
    }
  },
  mounted() {
    this.updateSlides(true);
    this.handleResize();
    this.setAutoplay();
    on(window, "resize", this.handleResize);
  },
  beforeUnmount() {
    off(window, "resize", this.handleResize);
  }
};
const _hoisted_1$11 = ["onClick", "onMouseover"];
function _sfc_render$1O(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = resolveComponent("Icon");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes)
  }, [
    createElementVNode("button", {
      type: "button",
      class: normalizeClass([$options.arrowClasses, "left"]),
      onClick: _cache[0] || (_cache[0] = ($event) => $options.arrowEvent(-1))
    }, [
      createVNode(_component_Icon, { type: "ios-arrow-back" })
    ], 2),
    createElementVNode("div", {
      class: normalizeClass([$data.prefixCls + "-list"])
    }, [
      createElementVNode("div", {
        class: normalizeClass([$data.prefixCls + "-track", $data.showCopyTrack ? "" : "higher"]),
        style: normalizeStyle($options.trackStyles),
        ref: "originTrack",
        onClick: _cache[1] || (_cache[1] = ($event) => $options.handleClick("currentIndex"))
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 6),
      $props.loop ? (openBlock(), createElementBlock("div", {
        key: 0,
        class: normalizeClass([$data.prefixCls + "-track", $data.showCopyTrack ? "higher" : ""]),
        style: normalizeStyle($options.copyTrackStyles),
        ref: "copyTrack",
        onClick: _cache[2] || (_cache[2] = ($event) => $options.handleClick("copyTrackIndex"))
      }, null, 6)) : createCommentVNode("", true)
    ], 2),
    createElementVNode("button", {
      type: "button",
      class: normalizeClass([$options.arrowClasses, "right"]),
      onClick: _cache[3] || (_cache[3] = ($event) => $options.arrowEvent(1))
    }, [
      createVNode(_component_Icon, { type: "ios-arrow-forward" })
    ], 2),
    createElementVNode("ul", {
      class: normalizeClass($options.dotsClasses)
    }, [
      (openBlock(true), createElementBlock(Fragment, null, renderList($data.slides.length, (n) => {
        return openBlock(), createElementBlock("li", {
          key: n,
          class: normalizeClass([n - 1 === $data.currentIndex ? $data.prefixCls + "-active" : ""]),
          onClick: ($event) => $options.dotsEvent("click", n - 1),
          onMouseover: ($event) => $options.dotsEvent("hover", n - 1)
        }, [
          createElementVNode("button", {
            type: "button",
            class: normalizeClass([$props.radiusDot ? "radius" : ""])
          }, null, 2)
        ], 42, _hoisted_1$11);
      }), 128))
    ], 2)
  ], 2);
}
var Carousel = /* @__PURE__ */ _export_sfc(_sfc_main$20, [["render", _sfc_render$1O]]);
const prefixCls$11 = "ivu-carousel-item";
const _sfc_main$1$ = {
  componentName: "carousel-item",
  name: "CarouselItem",
  inject: ["CarouselInstance"],
  data() {
    return {
      prefixCls: prefixCls$11,
      width: 0,
      height: "auto",
      left: 0,
      id: random(6)
    };
  },
  computed: {
    styles() {
      return {
        width: `${this.width}px`,
        height: `${this.height}`,
        left: `${this.left}px`
      };
    }
  },
  watch: {
    width(val) {
      if (val && this.CarouselInstance.loop) {
        nextTick(() => {
          this.CarouselInstance.initCopyTrackDom();
        });
      }
    },
    height(val) {
      if (val && this.CarouselInstance.loop) {
        nextTick(() => {
          this.CarouselInstance.initCopyTrackDom();
        });
      }
    }
  },
  methods: {
    addInstance() {
      const root2 = this.CarouselInstance;
      if (!root2.carouselItemList)
        root2.carouselItemList = [];
      root2.carouselItemList.push({
        id: this.id,
        carouselItem: this
      });
    },
    removeInstance() {
      const root2 = this.CarouselInstance;
      if (!root2.carouselItemList)
        return;
      const index2 = root2.carouselItemList.findIndex((item) => item.id === this.id);
      root2.carouselItemList.splice(index2, 1);
    }
  },
  mounted() {
    this.addInstance();
    this.CarouselInstance.slotChange();
  },
  beforeUnmount() {
    this.removeInstance();
    this.CarouselInstance.slotChange();
  }
};
function _sfc_render$1N(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($data.prefixCls),
    style: normalizeStyle($options.styles)
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 6);
}
var CarouselItem = /* @__PURE__ */ _export_sfc(_sfc_main$1$, [["render", _sfc_render$1N]]);
const _sfc_main$1_ = {
  name: "Casitem",
  components: { Icon },
  mixins: [globalConfig],
  props: {
    data: Object,
    prefixCls: String,
    tmpItem: Object
  },
  computed: {
    classes() {
      return [
        `${this.prefixCls}-menu-item`,
        {
          [`${this.prefixCls}-menu-item-active`]: this.tmpItem.value === this.data.value,
          [`${this.prefixCls}-menu-item-disabled`]: this.data.disabled
        }
      ];
    },
    showArrow() {
      return this.data.children && this.data.children.length || "loading" in this.data && !this.data.loading;
    },
    showLoading() {
      return "loading" in this.data && this.data.loading;
    },
    arrowType() {
      const config = this.globalConfig;
      let type2 = "ios-arrow-forward";
      if (config) {
        if (config.cascader.customItemArrow) {
          type2 = "";
        } else if (config.cascader.itemArrow) {
          type2 = config.cascader.itemArrow;
        }
      }
      return type2;
    },
    customArrowType() {
      const config = this.globalConfig;
      let type2 = "";
      if (config) {
        if (config.cascader.customItemArrow) {
          type2 = config.cascader.customItemArrow;
        }
      }
      return type2;
    },
    arrowSize() {
      const config = this.globalConfig;
      let size = "";
      if (config) {
        if (config.cascader.itemArrowSize) {
          size = config.cascader.itemArrowSize;
        }
      }
      return size;
    }
  }
};
const _hoisted_1$10 = {
  key: 1,
  class: "ivu-icon ivu-icon-ios-loading ivu-load-loop ivu-cascader-menu-item-loading"
};
function _sfc_render$1M(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = resolveComponent("Icon");
  return openBlock(), createElementBlock("li", {
    class: normalizeClass($options.classes)
  }, [
    createTextVNode(toDisplayString($props.data.label) + " ", 1),
    $options.showArrow ? (openBlock(), createBlock(_component_Icon, {
      key: 0,
      type: $options.arrowType,
      custom: $options.customArrowType,
      size: $options.arrowSize
    }, null, 8, ["type", "custom", "size"])) : createCommentVNode("", true),
    $options.showLoading ? (openBlock(), createElementBlock("i", _hoisted_1$10)) : createCommentVNode("", true)
  ], 2);
}
var Casitem = /* @__PURE__ */ _export_sfc(_sfc_main$1_, [["render", _sfc_render$1M]]);
let key = 1;
const _sfc_main$1Z = {
  name: "Caspanel",
  components: { Casitem },
  inject: ["CascaderInstance"],
  provide() {
    return {
      CaspanelInstance: this
    };
  },
  props: {
    data: {
      type: Array,
      default() {
        return [];
      }
    },
    disabled: Boolean,
    changeOnSelect: Boolean,
    trigger: String,
    prefixCls: String
  },
  data() {
    return {
      tmpItem: {},
      result: [],
      sublist: [],
      id: random(6),
      childCaspanelList: []
    };
  },
  watch: {
    data() {
      this.sublist = [];
    }
  },
  methods: {
    handleClickItem(item) {
      if (this.trigger !== "click" && item.children && item.children.length)
        return;
      this.handleTriggerItem(item, false, true);
    },
    handleHoverItem(item) {
      if (this.trigger !== "hover" || !item.children || !item.children.length)
        return;
      this.handleTriggerItem(item, false, true);
    },
    handleTriggerItem(item, fromInit = false, fromUser = false) {
      if (item.disabled)
        return;
      const cascader = findComponentUpward(this, "Cascader");
      if (item.loading !== void 0 && !item.children.length) {
        if (cascader && cascader.loadData) {
          cascader.loadData(item, () => {
            if (fromUser) {
              cascader.isLoadedChildren = true;
            }
            if (item.children.length) {
              this.handleTriggerItem(item);
            }
          });
          return;
        }
      }
      const backItem = this.getBaseItem(item);
      if (this.changeOnSelect || (backItem.label !== this.tmpItem.label || backItem.value !== this.tmpItem.value) || backItem.label === this.tmpItem.label && backItem.value === this.tmpItem.value) {
        this.tmpItem = backItem;
        this.emitUpdate([backItem]);
      }
      if (item.children && item.children.length) {
        this.sublist = item.children;
        this.CascaderInstance.handleOnResultChange({
          lastValue: false,
          changeOnSelect: this.changeOnSelect,
          fromInit
        });
        if (this.changeOnSelect) {
          if (this.childCaspanelList.length) {
            const Caspanel2 = this.childCaspanelList[0].caspanel;
            Caspanel2.handleOnClear(true);
          }
        }
      } else {
        this.sublist = [];
        this.CascaderInstance.handleOnResultChange({
          lastValue: true,
          changeOnSelect: this.changeOnSelect,
          fromInit
        });
      }
      if (cascader) {
        cascader.$refs.drop.update();
      }
    },
    updateResult(item) {
      this.result = [this.tmpItem].concat(item);
      this.emitUpdate(this.result);
    },
    getBaseItem(item) {
      let backItem = Object.assign({}, item);
      if (backItem.children) {
        delete backItem.children;
      }
      return backItem;
    },
    emitUpdate(result) {
      if (this.$parent.$options.name === "Caspanel") {
        this.$parent.updateResult(result);
      } else {
        this.CascaderInstance.updateResult(result);
      }
    },
    getKey() {
      return key++;
    },
    handleOnFindSelected(params) {
      const val = params.value;
      let value = [...val];
      for (let i = 0; i < value.length; i++) {
        for (let j = 0; j < this.data.length; j++) {
          if (value[i] === this.data[j].value) {
            this.handleTriggerItem(this.data[j], true);
            value.splice(0, 1);
            nextTick(() => {
              if (this.childCaspanelList.length) {
                const Caspanel2 = this.childCaspanelList[0].caspanel;
                Caspanel2.handleOnFindSelected({
                  value
                });
              }
            });
            return false;
          }
        }
      }
    },
    handleOnClear(deep = false) {
      this.sublist = [];
      this.tmpItem = {};
      if (deep) {
        if (this.childCaspanelList.length) {
          const Caspanel2 = this.childCaspanelList[0].caspanel;
          Caspanel2.handleOnClear(true);
        }
      }
    },
    addCaspanel() {
      const root2 = this.CascaderInstance;
      if (!root2.caspanelList)
        root2.caspanelList = [];
      root2.caspanelList.push({
        id: this.id,
        caspanel: this
      });
      const parentCaspanel = findComponentUpward(this, "Caspanel");
      if (parentCaspanel) {
        if (!parentCaspanel.childCaspanelList)
          parentCaspanel.childCaspanelList = [];
        parentCaspanel.childCaspanelList.push({
          id: this.id,
          caspanel: this
        });
      }
    },
    removeCaspanel() {
      const root2 = this.CascaderInstance;
      if (root2.caspanelList && root2.caspanelList.length) {
        const index2 = root2.caspanelList.findIndex((item) => item.id === this.id);
        root2.caspanelList.splice(index2, 1);
      }
      const parentCaspanel = findComponentUpward(this, "Caspanel");
      if (parentCaspanel) {
        if (parentCaspanel.childCaspanelList && parentCaspanel.childCaspanelList.length) {
          const index2 = parentCaspanel.childCaspanelList.findIndex((item) => item.id === this.id);
          parentCaspanel.childCaspanelList.splice(index2, 1);
        }
      }
    }
  },
  mounted() {
    this.addCaspanel();
  },
  beforeUnmount() {
    this.removeCaspanel();
  }
};
function _sfc_render$1L(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Casitem = resolveComponent("Casitem");
  const _component_Caspanel = resolveComponent("Caspanel", true);
  return openBlock(), createElementBlock("span", null, [
    $props.data && $props.data.length ? (openBlock(), createElementBlock("ul", {
      key: 0,
      class: normalizeClass([$props.prefixCls + "-menu"])
    }, [
      (openBlock(true), createElementBlock(Fragment, null, renderList($props.data, (item, index2) => {
        return openBlock(), createBlock(_component_Casitem, {
          key: index2,
          "prefix-cls": $props.prefixCls,
          data: item,
          "tmp-item": $data.tmpItem,
          onClick: withModifiers(($event) => $options.handleClickItem(item), ["stop"]),
          onMouseenter: withModifiers(($event) => $options.handleHoverItem(item), ["stop"])
        }, null, 8, ["prefix-cls", "data", "tmp-item", "onClick", "onMouseenter"]);
      }), 128))
    ], 2)) : createCommentVNode("", true),
    $data.sublist && $data.sublist.length ? (openBlock(), createBlock(_component_Caspanel, {
      key: 1,
      "prefix-cls": $props.prefixCls,
      data: $data.sublist,
      disabled: $props.disabled,
      trigger: $props.trigger,
      "change-on-select": $props.changeOnSelect
    }, null, 8, ["prefix-cls", "data", "disabled", "trigger", "change-on-select"])) : createCommentVNode("", true)
  ]);
}
var Caspanel = /* @__PURE__ */ _export_sfc(_sfc_main$1Z, [["render", _sfc_render$1L]]);
var clickOutside = {
  beforeMount(el, binding, vnode) {
    function documentHandler(e) {
      if (el.contains(e.target)) {
        return false;
      }
      binding.value(e);
    }
    el.__vueClickOutside__ = documentHandler;
    isClient && document.addEventListener("click", documentHandler);
  },
  unmounted(el, binding) {
    isClient && document.removeEventListener("click", el.__vueClickOutside__);
    delete el.__vueClickOutside__;
  }
};
const prefixCls$10 = "ivu-cascader";
const selectPrefixCls = "ivu-select";
const _sfc_main$1Y = {
  name: "Cascader",
  mixins: [Locale, mixinsForm, globalConfig],
  components: { iInput: Input, Drop, Icon, Caspanel },
  directives: { clickOutside },
  emits: ["on-change", "on-visible-change", "update:modelValue"],
  provide() {
    return {
      CascaderInstance: this
    };
  },
  props: {
    data: {
      type: Array,
      default() {
        return [];
      }
    },
    modelValue: {
      type: Array,
      default() {
        return [];
      }
    },
    disabled: {
      type: Boolean,
      default: false
    },
    clearable: {
      type: Boolean,
      default: true
    },
    placeholder: {
      type: String
    },
    size: {
      validator(value) {
        return oneOf(value, ["small", "large", "default"]);
      },
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.size === "" ? "default" : global2.$VIEWUI.size;
      }
    },
    trigger: {
      validator(value) {
        return oneOf(value, ["click", "hover"]);
      },
      default: "click"
    },
    changeOnSelect: {
      type: Boolean,
      default: false
    },
    renderFormat: {
      type: Function,
      default(label) {
        return label.join(" / ");
      }
    },
    loadData: {
      type: Function
    },
    filterable: {
      type: Boolean,
      default: false
    },
    notFoundText: {
      type: String
    },
    transfer: {
      type: Boolean,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.transfer === "" ? false : global2.$VIEWUI.transfer;
      }
    },
    name: {
      type: String
    },
    elementId: {
      type: String
    },
    capture: {
      type: Boolean,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI ? true : global2.$VIEWUI.capture;
      }
    },
    transferClassName: {
      type: String
    },
    eventsEnabled: {
      type: Boolean,
      default: false
    }
  },
  data() {
    return {
      prefixCls: prefixCls$10,
      selectPrefixCls,
      visible: false,
      selected: [],
      tmpSelected: [],
      updatingValue: false,
      currentValue: this.modelValue || [],
      query: "",
      validDataStr: "",
      isLoadedChildren: false,
      isValueNull: false,
      caspanelList: []
    };
  },
  computed: {
    classes() {
      return [
        `${prefixCls$10}`,
        {
          [`${prefixCls$10}-show-clear`]: this.showCloseIcon,
          [`${prefixCls$10}-size-${this.size}`]: !!this.size,
          [`${prefixCls$10}-visible`]: this.visible,
          [`${prefixCls$10}-disabled`]: this.itemDisabled,
          [`${prefixCls$10}-not-found`]: this.filterable && this.query !== "" && !this.querySelections.length
        }
      ];
    },
    showCloseIcon() {
      return this.currentValue && this.currentValue.length && this.clearable && !this.itemDisabled;
    },
    displayRender() {
      let label = [];
      for (let i = 0; i < this.selected.length; i++) {
        label.push(this.selected[i].label);
      }
      return this.renderFormat(label, this.selected);
    },
    displayInputRender() {
      return this.filterable ? "" : this.displayRender;
    },
    localePlaceholder() {
      if (this.placeholder === void 0) {
        return this.t("i.select.placeholder");
      } else {
        return this.placeholder;
      }
    },
    inputPlaceholder() {
      return this.filterable && this.currentValue.length ? null : this.localePlaceholder;
    },
    localeNotFoundText() {
      if (this.notFoundText === void 0) {
        return this.t("i.select.noMatch");
      } else {
        return this.notFoundText;
      }
    },
    querySelections() {
      let selections = [];
      function getSelections(arr, label, value) {
        const cloneArr = deepCopy(arr);
        for (let i = 0; i < cloneArr.length; i++) {
          let item = cloneArr[i];
          item.__label = label ? label + " / " + item.label : item.label;
          item.__value = value ? value + "," + item.value : item.value;
          if (item.children && item.children.length) {
            getSelections(item.children, item.__label, item.__value);
            delete item.__label;
            delete item.__value;
          } else {
            selections.push({
              label: item.__label,
              value: item.__value,
              display: item.__label,
              item,
              disabled: !!item.disabled
            });
          }
        }
      }
      getSelections(this.data);
      selections = selections.filter((item) => {
        return item.label ? item.label.indexOf(this.query) > -1 : false;
      }).map((item) => {
        item.display = item.display.replace(new RegExp(this.query, "g"), `<span>${this.query}</span>`);
        return item;
      });
      return selections;
    },
    arrowType() {
      const config = this.globalConfig;
      let type2 = "ios-arrow-down";
      if (config) {
        if (config.cascader.customArrow) {
          type2 = "";
        } else if (config.cascader.arrow) {
          type2 = config.cascader.arrow;
        }
      }
      return type2;
    },
    customArrowType() {
      const config = this.globalConfig;
      let type2 = "";
      if (config) {
        if (config.cascader.customArrow) {
          type2 = config.cascader.customArrow;
        }
      }
      return type2;
    },
    arrowSize() {
      const config = this.globalConfig;
      let size = "";
      if (config) {
        if (config.cascader.arrowSize) {
          size = config.cascader.arrowSize;
        }
      }
      return size;
    },
    dropdownCls() {
      return {
        [prefixCls$10 + "-transfer"]: this.transfer,
        [this.transferClassName]: this.transferClassName
      };
    }
  },
  methods: {
    clearSelect() {
      if (this.itemDisabled)
        return false;
      const oldVal = JSON.stringify(this.currentValue);
      this.currentValue = this.selected = this.tmpSelected = [];
      this.handleClose();
      this.emitValue(this.currentValue, oldVal);
      this.caspanelList.forEach((item) => {
        item.caspanel.handleOnClear();
      });
    },
    handleClose() {
      this.visible = false;
    },
    toggleOpen() {
      if (this.itemDisabled)
        return false;
      if (this.visible) {
        if (!this.filterable)
          this.handleClose();
      } else {
        this.onFocus();
      }
    },
    onFocus() {
      this.visible = true;
      if (!this.currentValue.length) {
        this.caspanelList.forEach((item) => {
          item.caspanel.handleOnClear();
        });
      }
    },
    updateResult(result) {
      this.tmpSelected = result;
    },
    updateSelected(init = false, changeOnSelectDataChange = false) {
      if (!this.changeOnSelect || init || changeOnSelectDataChange) {
        this.caspanelList.forEach((item) => {
          item.caspanel.handleOnFindSelected({
            value: this.currentValue
          });
        });
      }
    },
    emitValue(val, oldVal) {
      if (JSON.stringify(val) !== oldVal) {
        this.$emit("on-change", this.currentValue, JSON.parse(JSON.stringify(this.selected)));
        nextTick(() => {
          this.handleFormItemChange("change", {
            value: this.currentValue,
            selected: JSON.parse(JSON.stringify(this.selected))
          });
        });
      }
    },
    handleInput(event) {
      this.query = event.target.value;
    },
    handleSelectItem(index2) {
      const item = this.querySelections[index2];
      if (item.item.disabled)
        return false;
      this.query = "";
      this.$refs.input.currentValue = "";
      const oldVal = JSON.stringify(this.currentValue);
      this.currentValue = item.value.split(",");
      setTimeout(() => {
        this.emitValue(this.currentValue, oldVal);
        this.handleClose();
      }, 0);
    },
    handleFocus() {
      this.$refs.input.focus();
    },
    getValidData(data) {
      const cloneData = deepCopy(data);
      function deleteData(item) {
        const new_item = Object.assign({}, item);
        if ("loading" in new_item) {
          delete new_item.loading;
        }
        if ("__value" in new_item) {
          delete new_item.__value;
        }
        if ("__label" in new_item) {
          delete new_item.__label;
        }
        if ("children" in new_item && new_item.children.length) {
          new_item.children = new_item.children.map((i) => deleteData(i));
        }
        return new_item;
      }
      return cloneData.map((item) => deleteData(item));
    },
    handleOnResultChange(params) {
      const lastValue = params.lastValue;
      const changeOnSelect = params.changeOnSelect;
      const fromInit = params.fromInit;
      if (lastValue || changeOnSelect) {
        const oldVal = JSON.stringify(this.currentValue);
        this.selected = this.tmpSelected;
        let newVal = [];
        this.selected.forEach((item) => {
          newVal.push(item.value);
        });
        if (!fromInit) {
          this.updatingValue = true;
          this.currentValue = newVal;
          this.emitValue(this.currentValue, oldVal);
        }
      }
      if (lastValue && !fromInit) {
        this.handleClose();
      }
    }
  },
  created() {
    this.validDataStr = JSON.stringify(this.getValidData(this.data));
  },
  mounted() {
    this.updateSelected(true);
  },
  watch: {
    visible(val) {
      if (val) {
        if (this.currentValue.length) {
          this.updateSelected();
        }
        if (this.transfer) {
          this.$refs.drop.update();
        }
        this.$refs.drop.handleOnUpdatePopper();
      } else {
        if (this.filterable) {
          this.query = "";
          this.$refs.input.currentValue = "";
        }
        if (this.transfer) {
          this.$refs.drop.destroy();
        }
        this.$refs.drop.handleOnDestroyPopper();
      }
      this.$emit("on-visible-change", val);
    },
    modelValue(val) {
      if (val === null)
        this.isValueNull = true;
      this.currentValue = val || [];
      if (val === null || !val.length)
        this.selected = [];
    },
    currentValue() {
      if (this.isValueNull) {
        this.isValueNull = false;
        this.$emit("update:modelValue", null);
      } else {
        this.$emit("update:modelValue", this.currentValue);
      }
      if (this.updatingValue) {
        this.updatingValue = false;
        return;
      }
      this.updateSelected(true);
    },
    data: {
      deep: true,
      handler() {
        const validDataStr = JSON.stringify(this.getValidData(this.data));
        if (validDataStr !== this.validDataStr) {
          this.validDataStr = validDataStr;
          if (!this.isLoadedChildren) {
            nextTick(() => this.updateSelected(false, this.changeOnSelect));
          }
          this.isLoadedChildren = false;
        }
      }
    }
  }
};
const _hoisted_1$$ = ["name", "value"];
const _hoisted_2$D = ["onClick", "innerHTML"];
function _sfc_render$1K(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_i_input = resolveComponent("i-input");
  const _component_Icon = resolveComponent("Icon");
  const _component_Caspanel = resolveComponent("Caspanel");
  const _component_Drop = resolveComponent("Drop");
  const _directive_click_outside = resolveDirective("click-outside");
  return withDirectives((openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes)
  }, [
    createElementVNode("div", {
      class: normalizeClass([$data.prefixCls + "-rel"]),
      onClick: _cache[1] || (_cache[1] = (...args) => $options.toggleOpen && $options.toggleOpen(...args)),
      ref: "reference"
    }, [
      createElementVNode("input", {
        type: "hidden",
        name: $props.name,
        value: $data.currentValue
      }, null, 8, _hoisted_1$$),
      renderSlot(_ctx.$slots, "default", {}, () => [
        createVNode(_component_i_input, {
          "element-id": $props.elementId,
          ref: "input",
          readonly: !$props.filterable,
          disabled: _ctx.itemDisabled,
          modelValue: $options.displayInputRender,
          onOnChange: $options.handleInput,
          size: $props.size,
          placeholder: $options.inputPlaceholder
        }, null, 8, ["element-id", "readonly", "disabled", "modelValue", "onOnChange", "size", "placeholder"]),
        withDirectives(createElementVNode("div", {
          class: normalizeClass([$data.prefixCls + "-label"]),
          onClick: _cache[0] || (_cache[0] = (...args) => $options.handleFocus && $options.handleFocus(...args))
        }, toDisplayString($options.displayRender), 3), [
          [vShow, $props.filterable && $data.query === ""]
        ]),
        withDirectives(createVNode(_component_Icon, {
          type: "ios-close-circle",
          class: normalizeClass([$data.prefixCls + "-arrow"]),
          onClick: withModifiers($options.clearSelect, ["stop"])
        }, null, 8, ["class", "onClick"]), [
          [vShow, $options.showCloseIcon]
        ]),
        createVNode(_component_Icon, {
          type: $options.arrowType,
          custom: $options.customArrowType,
          size: $options.arrowSize,
          class: normalizeClass([$data.prefixCls + "-arrow"])
        }, null, 8, ["type", "custom", "size", "class"])
      ])
    ], 2),
    createVNode(_component_Drop, {
      ref: "drop",
      visible: $data.visible,
      classes: $options.dropdownCls,
      eventsEnabled: $props.eventsEnabled,
      "transition-name": "transition-drop",
      transfer: $props.transfer
    }, {
      default: withCtx(() => [
        createElementVNode("div", null, [
          withDirectives(createVNode(_component_Caspanel, {
            ref: "caspanel",
            "prefix-cls": $data.prefixCls,
            data: $props.data,
            disabled: _ctx.itemDisabled,
            "change-on-select": $props.changeOnSelect,
            trigger: $props.trigger
          }, null, 8, ["prefix-cls", "data", "disabled", "change-on-select", "trigger"]), [
            [vShow, !$props.filterable || $props.filterable && $data.query === ""]
          ]),
          withDirectives(createElementVNode("div", {
            class: normalizeClass([$data.prefixCls + "-dropdown"])
          }, [
            createElementVNode("ul", {
              class: normalizeClass([$data.selectPrefixCls + "-dropdown-list"])
            }, [
              (openBlock(true), createElementBlock(Fragment, null, renderList($options.querySelections, (item, index2) => {
                return openBlock(), createElementBlock("li", {
                  class: normalizeClass([$data.selectPrefixCls + "-item", {
                    [$data.selectPrefixCls + "-item-disabled"]: item.disabled
                  }]),
                  key: index2,
                  onClick: ($event) => $options.handleSelectItem(index2),
                  innerHTML: item.display
                }, null, 10, _hoisted_2$D);
              }), 128))
            ], 2)
          ], 2), [
            [vShow, $props.filterable && $data.query !== "" && $options.querySelections.length]
          ]),
          withDirectives(createElementVNode("ul", {
            class: normalizeClass([$data.prefixCls + "-not-found-tip"])
          }, [
            createElementVNode("li", null, toDisplayString($options.localeNotFoundText), 1)
          ], 2), [
            [vShow, $props.filterable && $data.query !== "" && !$options.querySelections.length || !$props.data.length]
          ])
        ])
      ]),
      _: 1
    }, 8, ["visible", "classes", "eventsEnabled", "transfer"])
  ], 2)), [
    [_directive_click_outside, $options.handleClose]
  ]);
}
var Cascader = /* @__PURE__ */ _export_sfc(_sfc_main$1Y, [["render", _sfc_render$1K]]);
const _sfc_main$1X = {
  name: "CellItem",
  props: {
    title: {
      type: String,
      default: ""
    },
    label: {
      type: String,
      default: ""
    },
    extra: {
      type: String,
      default: ""
    }
  }
};
const _hoisted_1$_ = { class: "ivu-cell-item" };
const _hoisted_2$C = { class: "ivu-cell-icon" };
const _hoisted_3$t = { class: "ivu-cell-main" };
const _hoisted_4$l = { class: "ivu-cell-title" };
const _hoisted_5$e = { class: "ivu-cell-label" };
const _hoisted_6$7 = { class: "ivu-cell-footer" };
const _hoisted_7$6 = { class: "ivu-cell-extra" };
function _sfc_render$1J(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", _hoisted_1$_, [
    createElementVNode("div", _hoisted_2$C, [
      renderSlot(_ctx.$slots, "icon")
    ]),
    createElementVNode("div", _hoisted_3$t, [
      createElementVNode("div", _hoisted_4$l, [
        renderSlot(_ctx.$slots, "default", {}, () => [
          createTextVNode(toDisplayString($props.title), 1)
        ])
      ]),
      createElementVNode("div", _hoisted_5$e, [
        renderSlot(_ctx.$slots, "label", {}, () => [
          createTextVNode(toDisplayString($props.label), 1)
        ])
      ])
    ]),
    createElementVNode("div", _hoisted_6$7, [
      createElementVNode("span", _hoisted_7$6, [
        renderSlot(_ctx.$slots, "extra", {}, () => [
          createTextVNode(toDisplayString($props.extra), 1)
        ])
      ])
    ])
  ]);
}
var CellItem = /* @__PURE__ */ _export_sfc(_sfc_main$1X, [["render", _sfc_render$1J]]);
const prefixCls$$ = "ivu-cell";
const _sfc_main$1W = {
  name: "Cell",
  inject: ["CellGroupInstance"],
  mixins: [mixinsLink, globalConfig],
  components: { CellItem, Icon },
  props: {
    name: {
      type: [String, Number]
    },
    title: {
      type: String,
      default: ""
    },
    label: {
      type: String,
      default: ""
    },
    extra: {
      type: String,
      default: ""
    },
    disabled: {
      type: Boolean,
      default: false
    },
    selected: {
      type: Boolean,
      default: false
    }
  },
  data() {
    return {
      prefixCls: prefixCls$$
    };
  },
  computed: {
    classes() {
      return [
        `${prefixCls$$}`,
        {
          [`${prefixCls$$}-disabled`]: this.disabled,
          [`${prefixCls$$}-selected`]: this.selected,
          [`${prefixCls$$}-with-link`]: this.to
        }
      ];
    },
    arrowType() {
      const config = this.globalConfig;
      let type2 = "ios-arrow-forward";
      if (config) {
        if (config.cell.customArrow) {
          type2 = "";
        } else if (config.cell.arrow) {
          type2 = config.cell.arrow;
        }
      }
      return type2;
    },
    customArrowType() {
      const config = this.globalConfig;
      let type2 = "";
      if (config) {
        if (config.cell.customArrow) {
          type2 = config.cell.customArrow;
        }
      }
      return type2;
    },
    arrowSize() {
      const config = this.globalConfig;
      let size = "";
      if (config) {
        if (config.cell.arrowSize) {
          size = config.cell.arrowSize;
        }
      }
      return size;
    }
  },
  methods: {
    handleClickItem(event, new_window) {
      this.CellGroupInstance.handleClick(this.name);
      this.handleCheckClick(event, new_window);
    }
  }
};
const _hoisted_1$Z = ["href", "target"];
const _hoisted_2$B = {
  key: 2,
  class: "ivu-cell-arrow"
};
function _sfc_render$1I(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_CellItem = resolveComponent("CellItem");
  const _component_Icon = resolveComponent("Icon");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes)
  }, [
    _ctx.to ? (openBlock(), createElementBlock("a", {
      key: 0,
      href: _ctx.linkUrl,
      target: _ctx.target,
      class: "ivu-cell-link",
      onClick: [
        _cache[0] || (_cache[0] = withModifiers(($event) => $options.handleClickItem($event, false), ["exact"])),
        _cache[1] || (_cache[1] = withModifiers(($event) => $options.handleClickItem($event, true), ["ctrl"])),
        _cache[2] || (_cache[2] = withModifiers(($event) => $options.handleClickItem($event, true), ["meta"]))
      ]
    }, [
      createVNode(_component_CellItem, {
        title: $props.title,
        label: $props.label,
        extra: $props.extra
      }, {
        icon: withCtx(() => [
          renderSlot(_ctx.$slots, "icon")
        ]),
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default")
        ]),
        extra: withCtx(() => [
          renderSlot(_ctx.$slots, "extra")
        ]),
        label: withCtx(() => [
          renderSlot(_ctx.$slots, "label")
        ]),
        _: 3
      }, 8, ["title", "label", "extra"])
    ], 8, _hoisted_1$Z)) : (openBlock(), createElementBlock("div", {
      key: 1,
      class: "ivu-cell-link",
      onClick: _cache[3] || (_cache[3] = (...args) => $options.handleClickItem && $options.handleClickItem(...args))
    }, [
      createVNode(_component_CellItem, {
        title: $props.title,
        label: $props.label,
        extra: $props.extra
      }, {
        icon: withCtx(() => [
          renderSlot(_ctx.$slots, "icon")
        ]),
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default")
        ]),
        extra: withCtx(() => [
          renderSlot(_ctx.$slots, "extra")
        ]),
        label: withCtx(() => [
          renderSlot(_ctx.$slots, "label")
        ]),
        _: 3
      }, 8, ["title", "label", "extra"])
    ])),
    _ctx.to ? (openBlock(), createElementBlock("div", _hoisted_2$B, [
      renderSlot(_ctx.$slots, "arrow", {}, () => [
        createVNode(_component_Icon, {
          type: $options.arrowType,
          custom: $options.customArrowType,
          size: $options.arrowSize
        }, null, 8, ["type", "custom", "size"])
      ])
    ])) : createCommentVNode("", true)
  ], 2);
}
var Cell = /* @__PURE__ */ _export_sfc(_sfc_main$1W, [["render", _sfc_render$1I]]);
const _sfc_main$1V = {
  name: "CellGroup",
  emits: ["on-click"],
  provide() {
    return {
      CellGroupInstance: this
    };
  },
  methods: {
    handleClick(name2) {
      this.$emit("on-click", name2);
    }
  }
};
const _hoisted_1$Y = { class: "ivu-cell-group" };
function _sfc_render$1H(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", _hoisted_1$Y, [
    renderSlot(_ctx.$slots, "default")
  ]);
}
var CellGroup = /* @__PURE__ */ _export_sfc(_sfc_main$1V, [["render", _sfc_render$1H]]);
const prefixCls$_ = "ivu-checkbox";
const _sfc_main$1U = {
  name: "Checkbox",
  mixins: [mixinsForm],
  emits: ["update:modelValue", "on-change"],
  inject: {
    CheckboxGroupInstance: {
      default: null
    }
  },
  props: {
    disabled: {
      type: Boolean,
      default: false
    },
    modelValue: {
      type: [String, Number, Boolean],
      default: false
    },
    trueValue: {
      type: [String, Number, Boolean],
      default: true
    },
    falseValue: {
      type: [String, Number, Boolean],
      default: false
    },
    label: {
      type: [String, Number, Boolean]
    },
    indeterminate: {
      type: Boolean,
      default: false
    },
    size: {
      validator(value) {
        return oneOf(value, ["small", "large", "default"]);
      },
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.size === "" ? "default" : global2.$VIEWUI.size;
      }
    },
    name: {
      type: String
    },
    border: {
      type: Boolean,
      default: false
    }
  },
  data() {
    return {
      showSlot: true,
      focusInner: false,
      model: []
    };
  },
  computed: {
    wrapClasses() {
      return [
        `${prefixCls$_}-wrapper`,
        {
          [`${prefixCls$_}-group-item`]: this.group,
          [`${prefixCls$_}-wrapper-checked`]: this.currentValue,
          [`${prefixCls$_}-wrapper-disabled`]: this.itemDisabled,
          [`${prefixCls$_}-${this.size}`]: !!this.size,
          [`${prefixCls$_}-border`]: this.border
        }
      ];
    },
    checkboxClasses() {
      return [
        `${prefixCls$_}`,
        {
          [`${prefixCls$_}-checked`]: this.currentValue,
          [`${prefixCls$_}-disabled`]: this.itemDisabled,
          [`${prefixCls$_}-indeterminate`]: this.indeterminate
        }
      ];
    },
    innerClasses() {
      return [
        `${prefixCls$_}-inner`,
        {
          [`${prefixCls$_}-focus`]: this.focusInner
        }
      ];
    },
    inputClasses() {
      return `${prefixCls$_}-input`;
    },
    currentValue() {
      if (this.CheckboxGroupInstance) {
        let modelValue = this.CheckboxGroupInstance.modelValue;
        modelValue = Array.isArray(modelValue) ? modelValue : [];
        return modelValue.indexOf(this.label) >= 0;
      } else {
        return this.modelValue === this.trueValue;
      }
    },
    group() {
      return !!this.CheckboxGroupInstance;
    }
  },
  mounted() {
    if (!this.CheckboxGroupInstance)
      this.showSlot = this.$slots.default !== void 0;
  },
  methods: {
    change(event) {
      if (this.itemDisabled) {
        return false;
      }
      const checked = event.target.checked;
      const value = checked ? this.trueValue : this.falseValue;
      this.$emit("update:modelValue", value);
      if (this.group) {
        this.CheckboxGroupInstance.change(this.model);
      } else {
        this.$emit("on-change", value);
        this.handleFormItemChange("change", value);
      }
    },
    onBlur() {
      this.focusInner = false;
    },
    onFocus() {
      this.focusInner = true;
    }
  },
  watch: {
    modelValue(val) {
      if (val === this.trueValue || val === this.falseValue)
        ;
      else {
        throw "Value should be trueValue or falseValue.";
      }
    },
    "CheckboxGroupInstance.modelValue": {
      handler(val) {
        this.model = val || [];
      },
      immediate: true
    }
  }
};
const _hoisted_1$X = ["disabled", "value", "name"];
const _hoisted_2$A = ["disabled", "checked", "name"];
const _hoisted_3$s = {
  key: 0,
  class: "ivu-checkbox-label-text"
};
function _sfc_render$1G(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("label", {
    class: normalizeClass($options.wrapClasses)
  }, [
    createElementVNode("span", {
      class: normalizeClass($options.checkboxClasses)
    }, [
      createElementVNode("span", {
        class: normalizeClass($options.innerClasses)
      }, null, 2),
      $options.group ? withDirectives((openBlock(), createElementBlock("input", {
        key: 0,
        type: "checkbox",
        class: normalizeClass($options.inputClasses),
        disabled: _ctx.itemDisabled,
        value: $props.label,
        "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => $data.model = $event),
        name: $props.name,
        onChange: _cache[1] || (_cache[1] = (...args) => $options.change && $options.change(...args)),
        onFocus: _cache[2] || (_cache[2] = (...args) => $options.onFocus && $options.onFocus(...args)),
        onBlur: _cache[3] || (_cache[3] = (...args) => $options.onBlur && $options.onBlur(...args))
      }, null, 42, _hoisted_1$X)), [
        [vModelCheckbox, $data.model]
      ]) : (openBlock(), createElementBlock("input", {
        key: 1,
        type: "checkbox",
        class: normalizeClass($options.inputClasses),
        disabled: _ctx.itemDisabled,
        checked: $options.currentValue,
        name: $props.name,
        onChange: _cache[4] || (_cache[4] = (...args) => $options.change && $options.change(...args)),
        onFocus: _cache[5] || (_cache[5] = (...args) => $options.onFocus && $options.onFocus(...args)),
        onBlur: _cache[6] || (_cache[6] = (...args) => $options.onBlur && $options.onBlur(...args))
      }, null, 42, _hoisted_2$A))
    ], 2),
    $data.showSlot ? (openBlock(), createElementBlock("span", _hoisted_3$s, [
      renderSlot(_ctx.$slots, "default", {}, () => [
        createTextVNode(toDisplayString($props.label), 1)
      ])
    ])) : createCommentVNode("", true)
  ], 2);
}
var Checkbox = /* @__PURE__ */ _export_sfc(_sfc_main$1U, [["render", _sfc_render$1G]]);
const prefixCls$Z = "ivu-checkbox-group";
const _sfc_main$1T = {
  name: "CheckboxGroup",
  mixins: [mixinsForm],
  emits: ["update:modelValue", "on-change"],
  provide() {
    return {
      CheckboxGroupInstance: this
    };
  },
  props: {
    modelValue: {
      type: Array,
      default() {
        return [];
      }
    },
    size: {
      validator(value) {
        return oneOf(value, ["small", "large", "default"]);
      },
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.size === "" ? "default" : global2.$VIEWUI.size;
      }
    }
  },
  data() {
    return {
      currentValue: this.modelValue || [],
      children: []
    };
  },
  computed: {
    classes() {
      return [
        `${prefixCls$Z}`,
        {
          [`ivu-checkbox-${this.size}`]: !!this.size
        }
      ];
    }
  },
  methods: {
    change(data) {
      this.currentValue = data;
      this.$emit("update:modelValue", data);
      this.$emit("on-change", data);
      this.handleFormItemChange("change", data);
    }
  }
};
function _sfc_render$1F(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes)
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 2);
}
var CheckboxGroup = /* @__PURE__ */ _export_sfc(_sfc_main$1T, [["render", _sfc_render$1F]]);
const prefixCls$Y = "ivu-chart-circle";
const _sfc_main$1S = {
  name: "iCircle",
  props: {
    percent: {
      type: Number,
      default: 0
    },
    size: {
      type: Number,
      default: 120
    },
    strokeWidth: {
      type: Number,
      default: 6
    },
    strokeColor: {
      type: [String, Array],
      default: "#2d8cf0"
    },
    strokeLinecap: {
      validator(value) {
        return oneOf(value, ["square", "round"]);
      },
      default: "round"
    },
    trailWidth: {
      type: Number,
      default: 5
    },
    trailColor: {
      type: String,
      default: "#eaeef2"
    },
    dashboard: {
      type: Boolean,
      default: false
    }
  },
  data() {
    return {
      id: `ivu-chart-circle-${random(3)}`
    };
  },
  computed: {
    circleSize() {
      return {
        width: `${this.size}px`,
        height: `${this.size}px`
      };
    },
    computedStrokeWidth() {
      return this.percent === 0 && this.dashboard ? 0 : this.strokeWidth;
    },
    radius() {
      return 50 - this.strokeWidth / 2;
    },
    pathString() {
      if (this.dashboard) {
        return `M 50,50 m 0,${this.radius}
                    a ${this.radius},${this.radius} 0 1 1 0,-${2 * this.radius}
                    a ${this.radius},${this.radius} 0 1 1 0,${2 * this.radius}`;
      } else {
        return `M 50,50 m 0,-${this.radius}
                    a ${this.radius},${this.radius} 0 1 1 0,${2 * this.radius}
                    a ${this.radius},${this.radius} 0 1 1 0,-${2 * this.radius}`;
      }
    },
    len() {
      return Math.PI * 2 * this.radius;
    },
    trailStyle() {
      let style2 = {};
      if (this.dashboard) {
        style2 = {
          "stroke-dasharray": `${this.len - 75}px ${this.len}px`,
          "stroke-dashoffset": `-${75 / 2}px`,
          "transition": "stroke-dashoffset .3s ease 0s, stroke-dasharray .3s ease 0s, stroke .3s"
        };
      }
      return style2;
    },
    pathStyle() {
      let style2 = {};
      if (this.dashboard) {
        style2 = {
          "stroke-dasharray": `${this.percent / 100 * (this.len - 75)}px ${this.len}px`,
          "stroke-dashoffset": `-${75 / 2}px`,
          "transition": "stroke-dashoffset .3s ease 0s, stroke-dasharray .6s ease 0s, stroke .6s, stroke-width .06s ease .6s"
        };
      } else {
        style2 = {
          "stroke-dasharray": `${this.len}px ${this.len}px`,
          "stroke-dashoffset": `${(100 - this.percent) / 100 * this.len}px`,
          "transition": "stroke-dashoffset 0.6s ease 0s, stroke 0.6s ease"
        };
      }
      return style2;
    },
    wrapClasses() {
      return `${prefixCls$Y}`;
    },
    innerClasses() {
      return `${prefixCls$Y}-inner`;
    },
    strokeValue() {
      let color2 = this.strokeColor;
      if (typeof this.strokeColor !== "string") {
        color2 = `url(#${this.id})`;
      }
      return color2;
    },
    showDefs() {
      return typeof this.strokeColor !== "string";
    }
  }
};
const _hoisted_1$W = { viewBox: "0 0 100 100" };
const _hoisted_2$z = { key: 0 };
const _hoisted_3$r = ["id"];
const _hoisted_4$k = ["stop-color"];
const _hoisted_5$d = ["stop-color"];
const _hoisted_6$6 = ["d", "stroke", "stroke-width", "stroke-linecap"];
const _hoisted_7$5 = ["d", "stroke-linecap", "stroke", "stroke-width"];
function _sfc_render$1E(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    style: normalizeStyle($options.circleSize),
    class: normalizeClass($options.wrapClasses)
  }, [
    (openBlock(), createElementBlock("svg", _hoisted_1$W, [
      $options.showDefs ? (openBlock(), createElementBlock("defs", _hoisted_2$z, [
        createElementVNode("linearGradient", {
          id: $data.id,
          x1: "100%",
          y1: "0%",
          x2: "0%",
          y2: "0%"
        }, [
          createElementVNode("stop", {
            offset: "0%",
            "stop-color": $props.strokeColor[0]
          }, null, 8, _hoisted_4$k),
          createElementVNode("stop", {
            offset: "100%",
            "stop-color": $props.strokeColor[1]
          }, null, 8, _hoisted_5$d)
        ], 8, _hoisted_3$r)
      ])) : createCommentVNode("", true),
      createElementVNode("path", {
        d: $options.pathString,
        stroke: $props.trailColor,
        "stroke-width": $props.trailWidth,
        "fill-opacity": 0,
        style: normalizeStyle($options.trailStyle),
        "stroke-linecap": $props.strokeLinecap
      }, null, 12, _hoisted_6$6),
      createElementVNode("path", {
        d: $options.pathString,
        "stroke-linecap": $props.strokeLinecap,
        stroke: $options.strokeValue,
        "stroke-width": $options.computedStrokeWidth,
        "fill-opacity": "0",
        style: normalizeStyle($options.pathStyle)
      }, null, 12, _hoisted_7$5)
    ])),
    createElementVNode("div", {
      class: normalizeClass($options.innerClasses)
    }, [
      renderSlot(_ctx.$slots, "default")
    ], 2)
  ], 6);
}
var Circle = /* @__PURE__ */ _export_sfc(_sfc_main$1S, [["render", _sfc_render$1E]]);
const prefixCls$X = "ivu-dropdown";
const _sfc_main$1R = {
  name: "Dropdown",
  directives: { clickOutside },
  components: { Drop },
  emits: ["on-visible-change", "on-clickoutside", "on-click", "on-hover-click", "on-haschild-click"],
  props: {
    trigger: {
      validator(value) {
        return oneOf(value, ["click", "hover", "custom", "contextMenu"]);
      },
      default: "hover"
    },
    placement: {
      validator(value) {
        return oneOf(value, ["top", "top-start", "top-end", "bottom", "bottom-start", "bottom-end", "left", "left-start", "left-end", "right", "right-start", "right-end"]);
      },
      default: "bottom"
    },
    visible: {
      type: Boolean,
      default: false
    },
    transfer: {
      type: Boolean,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.transfer === "" ? false : global2.$VIEWUI.transfer;
      }
    },
    transferClassName: {
      type: String
    },
    stopPropagation: {
      type: Boolean,
      default: false
    },
    capture: {
      type: Boolean,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI ? true : global2.$VIEWUI.capture;
      }
    },
    eventsEnabled: {
      type: Boolean,
      default: false
    },
    boundariesElement: {
      default: "window"
    }
  },
  computed: {
    transition() {
      return ["bottom-start", "bottom", "bottom-end"].indexOf(this.placement) > -1 ? "slide-up" : "fade";
    },
    dropdownCls() {
      return {
        [prefixCls$X + "-transfer"]: this.transfer,
        [this.transferClassName]: this.transferClassName
      };
    },
    relClasses() {
      return [
        `${prefixCls$X}-rel`,
        {
          [`${prefixCls$X}-rel-user-select-none`]: this.trigger === "contextMenu"
        }
      ];
    }
  },
  data() {
    return {
      prefixCls: prefixCls$X,
      currentVisible: this.visible,
      timeout: null
    };
  },
  watch: {
    visible(val) {
      this.currentVisible = val;
    },
    currentVisible(val) {
      if (val) {
        this.$refs.drop.update();
      } else {
        this.$refs.drop.destroy();
      }
      this.$emit("on-visible-change", val);
    }
  },
  methods: {
    handleClick() {
      if (this.trigger === "custom")
        return false;
      if (this.trigger !== "click") {
        return false;
      }
      const $parent = this.hasParent();
      if (!$parent)
        this.currentVisible = !this.currentVisible;
    },
    handleRightClick() {
      if (this.trigger === "custom")
        return false;
      if (this.trigger !== "contextMenu") {
        return false;
      }
      this.currentVisible = !this.currentVisible;
    },
    handleMouseenter() {
      if (this.trigger === "custom")
        return false;
      if (this.trigger !== "hover") {
        return false;
      }
      if (this.timeout)
        clearTimeout(this.timeout);
      this.timeout = setTimeout(() => {
        this.currentVisible = true;
      }, 250);
    },
    handleMouseleave() {
      if (this.trigger === "custom")
        return false;
      if (this.trigger !== "hover") {
        return false;
      }
      if (this.timeout) {
        clearTimeout(this.timeout);
        this.timeout = setTimeout(() => {
          this.currentVisible = false;
        }, 150);
      }
    },
    onClickoutside(e) {
      this.handleClose();
      this.handleRightClose();
      if (this.currentVisible)
        this.$emit("on-clickoutside", e);
    },
    handleClose() {
      if (this.trigger === "custom")
        return false;
      if (this.trigger !== "click") {
        return false;
      }
      this.currentVisible = false;
    },
    handleRightClose() {
      if (this.trigger === "custom")
        return false;
      if (this.trigger !== "contextMenu") {
        return false;
      }
      this.currentVisible = false;
    },
    hasParent() {
      const $parent = findComponentUpward(this, "Dropdown");
      if ($parent) {
        return $parent;
      } else {
        return false;
      }
    },
    handleHaschildClick() {
      nextTick(() => {
        if (this.trigger === "custom")
          return false;
        this.currentVisible = true;
      });
      const $parent = this.hasParent();
      if ($parent)
        $parent.handleHaschildClick();
    },
    handleItemClick(key2) {
      if (this.stopPropagation)
        return;
      const $parent = this.hasParent();
      if ($parent)
        $parent.handleItemClick(key2);
      else
        this.$emit("on-click", key2);
    },
    handleHoverClick() {
      const $parent = this.hasParent();
      if ($parent) {
        nextTick(() => {
          if (this.trigger === "custom")
            return false;
          this.currentVisible = false;
        });
        $parent.handleHoverClick();
      } else {
        nextTick(() => {
          if (this.trigger === "custom")
            return false;
          this.currentVisible = false;
        });
      }
    }
  }
};
function _sfc_render$1D(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Drop = resolveComponent("Drop");
  const _directive_click_outside = resolveDirective("click-outside");
  return withDirectives((openBlock(), createElementBlock("div", {
    class: normalizeClass([$data.prefixCls]),
    onMouseenter: _cache[2] || (_cache[2] = (...args) => $options.handleMouseenter && $options.handleMouseenter(...args)),
    onMouseleave: _cache[3] || (_cache[3] = (...args) => $options.handleMouseleave && $options.handleMouseleave(...args))
  }, [
    createElementVNode("div", {
      class: normalizeClass($options.relClasses),
      ref: "reference",
      onClick: _cache[0] || (_cache[0] = (...args) => $options.handleClick && $options.handleClick(...args)),
      onContextmenu: _cache[1] || (_cache[1] = withModifiers((...args) => $options.handleRightClick && $options.handleRightClick(...args), ["prevent"]))
    }, [
      renderSlot(_ctx.$slots, "default")
    ], 34),
    createVNode(_component_Drop, {
      ref: "drop",
      visible: $data.currentVisible,
      classes: $options.dropdownCls,
      placement: $props.placement,
      eventsEnabled: $props.eventsEnabled,
      boundariesElement: $props.boundariesElement,
      transfer: $props.transfer,
      "transition-name": "transition-drop",
      onMouseenter: $options.handleMouseenter,
      onMouseleave: $options.handleMouseleave
    }, {
      default: withCtx(() => [
        renderSlot(_ctx.$slots, "list")
      ]),
      _: 3
    }, 8, ["visible", "classes", "placement", "eventsEnabled", "boundariesElement", "transfer", "onMouseenter", "onMouseleave"])
  ], 34)), [
    [_directive_click_outside, $options.onClickoutside]
  ]);
}
var Dropdown = /* @__PURE__ */ _export_sfc(_sfc_main$1R, [["render", _sfc_render$1D]]);
const _sfc_main$1Q = {
  name: "DropdownMenu"
};
const _hoisted_1$V = { class: "ivu-dropdown-menu" };
function _sfc_render$1C(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("ul", _hoisted_1$V, [
    renderSlot(_ctx.$slots, "default")
  ]);
}
var DropdownMenu = /* @__PURE__ */ _export_sfc(_sfc_main$1Q, [["render", _sfc_render$1C]]);
const prefixCls$W = "ivu-tag";
const initColorList = ["default", "primary", "success", "warning", "error", "blue", "green", "red", "yellow", "pink", "magenta", "volcano", "orange", "gold", "lime", "cyan", "geekblue", "purple"];
const colorList = ["pink", "magenta", "volcano", "orange", "gold", "lime", "cyan", "geekblue", "purple"];
const _sfc_main$1P = {
  name: "Tag",
  components: { Icon },
  emits: ["on-change", "on-close"],
  props: {
    closable: {
      type: Boolean,
      default: false
    },
    checkable: {
      type: Boolean,
      default: false
    },
    checked: {
      type: Boolean,
      default: true
    },
    color: {
      type: String,
      default: "default"
    },
    type: {
      validator(value) {
        return oneOf(value, ["border", "dot"]);
      }
    },
    name: {
      type: [String, Number]
    },
    size: {
      validator(value) {
        return oneOf(value, ["default", "medium", "large"]);
      },
      default: "default"
    }
  },
  data() {
    return {
      isChecked: this.checked
    };
  },
  computed: {
    classes() {
      return [
        `${prefixCls$W}`,
        `${prefixCls$W}-size-${this.size}`,
        {
          [`${prefixCls$W}-${this.color}`]: !!this.color && oneOf(this.color, initColorList),
          [`${prefixCls$W}-${this.type}`]: !!this.type,
          [`${prefixCls$W}-closable`]: this.closable,
          [`${prefixCls$W}-checked`]: this.isChecked,
          [`${prefixCls$W}-checkable`]: this.checkable
        }
      ];
    },
    wraperStyles() {
      return oneOf(this.color, initColorList) ? {} : { background: this.isChecked ? this.defaultTypeColor : "transparent", borderWidth: "1px", borderStyle: "solid", borderColor: this.type !== "dot" && this.type !== "border" && this.isChecked ? this.borderColor : this.lineColor, color: this.lineColor };
    },
    textClasses() {
      return [
        `${prefixCls$W}-text`,
        this.type === "border" ? oneOf(this.color, initColorList) ? `${prefixCls$W}-color-${this.color}` : "" : "",
        this.type !== "dot" && this.type !== "border" && this.color !== "default" ? this.isChecked && colorList.indexOf(this.color) < 0 ? `${prefixCls$W}-color-white` : "" : ""
      ];
    },
    dotClasses() {
      return `${prefixCls$W}-dot-inner`;
    },
    iconClass() {
      if (this.type === "dot") {
        return "";
      } else if (this.type === "border") {
        return oneOf(this.color, initColorList) ? `${prefixCls$W}-color-${this.color}` : "";
      } else {
        return this.color !== void 0 ? this.color === "default" ? "" : "rgb(255, 255, 255)" : "";
      }
    },
    showDot() {
      return !!this.type && this.type === "dot";
    },
    lineColor() {
      if (this.type === "dot") {
        return "";
      } else if (this.type === "border") {
        return this.color !== void 0 ? oneOf(this.color, initColorList) ? "" : this.color : "";
      } else {
        return this.color !== void 0 ? this.color === "default" ? "" : "rgb(255, 255, 255)" : "";
      }
    },
    borderColor() {
      return this.color !== void 0 ? this.color === "default" ? "" : this.color : "";
    },
    dotColor() {
      return this.color !== void 0 ? oneOf(this.color, initColorList) ? "" : this.color : "";
    },
    textColorStyle() {
      return oneOf(this.color, initColorList) ? {} : this.type !== "dot" && this.type !== "border" ? this.isChecked ? { color: this.lineColor } : {} : { color: this.lineColor };
    },
    bgColorStyle() {
      return oneOf(this.color, initColorList) ? {} : { background: this.dotColor };
    },
    defaultTypeColor() {
      return this.type !== "dot" && this.type !== "border" ? this.color !== void 0 ? oneOf(this.color, initColorList) ? "" : this.color : "" : "";
    }
  },
  methods: {
    close(event) {
      if (this.name === void 0) {
        this.$emit("on-close", event);
      } else {
        this.$emit("on-close", event, this.name);
      }
    },
    check() {
      if (!this.checkable)
        return;
      const checked = !this.isChecked;
      this.isChecked = checked;
      if (this.name === void 0) {
        this.$emit("on-change", checked);
      } else {
        this.$emit("on-change", checked, this.name);
      }
    }
  },
  watch: {
    checked(val) {
      this.isChecked = val;
    }
  }
};
function _sfc_render$1B(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = resolveComponent("Icon");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes),
    onClick: _cache[0] || (_cache[0] = withModifiers((...args) => $options.check && $options.check(...args), ["stop"])),
    style: normalizeStyle($options.wraperStyles)
  }, [
    $options.showDot ? (openBlock(), createElementBlock("span", {
      key: 0,
      class: normalizeClass($options.dotClasses),
      style: normalizeStyle($options.bgColorStyle)
    }, null, 6)) : createCommentVNode("", true),
    createElementVNode("span", {
      class: normalizeClass($options.textClasses),
      style: normalizeStyle($options.textColorStyle)
    }, [
      renderSlot(_ctx.$slots, "default")
    ], 6),
    $props.closable ? (openBlock(), createBlock(_component_Icon, {
      key: 1,
      class: normalizeClass($options.iconClass),
      color: $options.lineColor,
      type: "ios-close",
      onClick: withModifiers($options.close, ["stop"])
    }, null, 8, ["class", "color", "onClick"])) : createCommentVNode("", true)
  ], 6);
}
var Tag = /* @__PURE__ */ _export_sfc(_sfc_main$1P, [["render", _sfc_render$1B]]);
var provinceData = {
  "110000": { l: "Z1", n: "\u5317\u4EAC", c: "110000", p: "86" },
  "120000": { l: "Z1", n: "\u5929\u6D25", c: "120000", p: "86" },
  "130000": { l: "H", n: "\u6CB3\u5317", c: "130000", p: "86" },
  "140000": { l: "S", n: "\u5C71\u897F", c: "140000", p: "86" },
  "150000": { l: "N", n: "\u5185\u8499\u53E4", c: "150000", p: "86" },
  "210000": { l: "L", n: "\u8FBD\u5B81", c: "210000", p: "86" },
  "220000": { l: "J", n: "\u5409\u6797", c: "220000", p: "86" },
  "230000": { l: "H", n: "\u9ED1\u9F99\u6C5F", c: "230000", p: "86" },
  "310000": { l: "Z1", n: "\u4E0A\u6D77", c: "310000", p: "86" },
  "320000": { l: "J", n: "\u6C5F\u82CF", c: "320000", p: "86" },
  "330000": { l: "Z", n: "\u6D59\u6C5F", c: "330000", p: "86" },
  "340000": { l: "A", n: "\u5B89\u5FBD", c: "340000", p: "86" },
  "350000": { l: "F", n: "\u798F\u5EFA", c: "350000", p: "86" },
  "360000": { l: "J", n: "\u6C5F\u897F", c: "360000", p: "86" },
  "370000": { l: "S", n: "\u5C71\u4E1C", c: "370000", p: "86" },
  "410000": { l: "H", n: "\u6CB3\u5357", c: "410000", p: "86" },
  "420000": { l: "H", n: "\u6E56\u5317", c: "420000", p: "86" },
  "430000": { l: "H", n: "\u6E56\u5357", c: "430000", p: "86" },
  "440000": { l: "G", n: "\u5E7F\u4E1C", c: "440000", p: "86" },
  "450000": { l: "G", n: "\u5E7F\u897F", c: "450000", p: "86" },
  "460000": { l: "H", n: "\u6D77\u5357", c: "460000", p: "86" },
  "500000": { l: "Z1", n: "\u91CD\u5E86", c: "500000", p: "86" },
  "510000": { l: "S", n: "\u56DB\u5DDD", c: "510000", p: "86" },
  "520000": { l: "G", n: "\u8D35\u5DDE", c: "520000", p: "86" },
  "530000": { l: "Y", n: "\u4E91\u5357", c: "530000", p: "86" },
  "540000": { l: "X", n: "\u897F\u85CF", c: "540000", p: "86" },
  "610000": { l: "S", n: "\u9655\u897F", c: "610000", p: "86" },
  "620000": { l: "G", n: "\u7518\u8083", c: "620000", p: "86" },
  "630000": { l: "Q", n: "\u9752\u6D77", c: "630000", p: "86" },
  "640000": { l: "N", n: "\u5B81\u590F", c: "640000", p: "86" },
  "650000": { l: "X", n: "\u65B0\u7586", c: "650000", p: "86" },
  "710000": { l: "T", n: "\u53F0\u6E7E", c: "710000", p: "86" },
  "810000": { l: "Z2", n: "\u9999\u6E2F", c: "810000", p: "86" },
  "820000": { l: "Z2", n: "\u6FB3\u95E8", c: "820000", p: "86" }
};
var cityData = {
  "110000": { "l": "B", "n": "\u5317\u4EAC\u5E02", "c": "110000", "p": "86" },
  "120000": { "l": "T", "n": "\u5929\u6D25\u5E02", "c": "120000", "p": "86" },
  "130100": { "l": "S", "n": "\u77F3\u5BB6\u5E84\u5E02", "c": "130100", "p": "130000" },
  "130200": { "l": "T", "n": "\u5510\u5C71\u5E02", "c": "130200", "p": "130000" },
  "130300": { "l": "Q", "n": "\u79E6\u7687\u5C9B\u5E02", "c": "130300", "p": "130000" },
  "130400": { "l": "H", "n": "\u90AF\u90F8\u5E02", "c": "130400", "p": "130000" },
  "130500": { "l": "X", "n": "\u90A2\u53F0\u5E02", "c": "130500", "p": "130000" },
  "130600": { "l": "B", "n": "\u4FDD\u5B9A\u5E02", "c": "130600", "p": "130000" },
  "130700": { "l": "Z", "n": "\u5F20\u5BB6\u53E3\u5E02", "c": "130700", "p": "130000" },
  "130800": { "l": "C", "n": "\u627F\u5FB7\u5E02", "c": "130800", "p": "130000" },
  "130900": { "l": "C", "n": "\u6CA7\u5DDE\u5E02", "c": "130900", "p": "130000" },
  "131000": { "l": "L", "n": "\u5ECA\u574A\u5E02", "c": "131000", "p": "130000" },
  "131100": { "l": "H", "n": "\u8861\u6C34\u5E02", "c": "131100", "p": "130000" },
  "139001": { "l": "D", "n": "\u5B9A\u5DDE\u5E02", "c": "139001", "p": "130000" },
  "139002": { "l": "X", "n": "\u8F9B\u96C6\u5E02", "c": "139002", "p": "130000" },
  "140100": { "l": "T", "n": "\u592A\u539F\u5E02", "c": "140100", "p": "140000" },
  "140200": { "l": "D", "n": "\u5927\u540C\u5E02", "c": "140200", "p": "140000" },
  "140300": { "l": "Y", "n": "\u9633\u6CC9\u5E02", "c": "140300", "p": "140000" },
  "140400": { "l": "C", "n": "\u957F\u6CBB\u5E02", "c": "140400", "p": "140000" },
  "140500": { "l": "J", "n": "\u664B\u57CE\u5E02", "c": "140500", "p": "140000" },
  "140600": { "l": "S", "n": "\u6714\u5DDE\u5E02", "c": "140600", "p": "140000" },
  "140700": { "l": "J", "n": "\u664B\u4E2D\u5E02", "c": "140700", "p": "140000" },
  "140800": { "l": "Y", "n": "\u8FD0\u57CE\u5E02", "c": "140800", "p": "140000" },
  "140900": { "l": "X", "n": "\u5FFB\u5DDE\u5E02", "c": "140900", "p": "140000" },
  "141000": { "l": "L", "n": "\u4E34\u6C7E\u5E02", "c": "141000", "p": "140000" },
  "141100": { "l": "L", "n": "\u5415\u6881\u5E02", "c": "141100", "p": "140000" },
  "150100": { "l": "H", "n": "\u547C\u548C\u6D69\u7279\u5E02", "c": "150100", "p": "150000" },
  "150200": { "l": "B", "n": "\u5305\u5934\u5E02", "c": "150200", "p": "150000" },
  "150300": { "l": "W", "n": "\u4E4C\u6D77\u5E02", "c": "150300", "p": "150000" },
  "150400": { "l": "C", "n": "\u8D64\u5CF0\u5E02", "c": "150400", "p": "150000" },
  "150500": { "l": "T", "n": "\u901A\u8FBD\u5E02", "c": "150500", "p": "150000" },
  "150600": { "l": "E", "n": "\u9102\u5C14\u591A\u65AF\u5E02", "c": "150600", "p": "150000" },
  "150700": { "l": "H", "n": "\u547C\u4F26\u8D1D\u5C14\u5E02", "c": "150700", "p": "150000" },
  "150800": { "l": "B", "n": "\u5DF4\u5F66\u6DD6\u5C14\u5E02", "c": "150800", "p": "150000" },
  "150900": { "l": "W", "n": "\u4E4C\u5170\u5BDF\u5E03\u5E02", "c": "150900", "p": "150000" },
  "152200": { "l": "X", "n": "\u5174\u5B89\u76DF", "c": "152200", "p": "150000" },
  "152500": { "l": "X", "n": "\u9521\u6797\u90ED\u52D2\u76DF", "c": "152500", "p": "150000" },
  "152900": { "l": "A", "n": "\u963F\u62C9\u5584\u76DF", "c": "152900", "p": "150000" },
  "210100": { "l": "S", "n": "\u6C88\u9633\u5E02", "c": "210100", "p": "210000" },
  "210200": { "l": "D", "n": "\u5927\u8FDE\u5E02", "c": "210200", "p": "210000" },
  "210300": { "l": "A", "n": "\u978D\u5C71\u5E02", "c": "210300", "p": "210000" },
  "210400": { "l": "F", "n": "\u629A\u987A\u5E02", "c": "210400", "p": "210000" },
  "210500": { "l": "B", "n": "\u672C\u6EAA\u5E02", "c": "210500", "p": "210000" },
  "210600": { "l": "D", "n": "\u4E39\u4E1C\u5E02", "c": "210600", "p": "210000" },
  "210700": { "l": "J", "n": "\u9526\u5DDE\u5E02", "c": "210700", "p": "210000" },
  "210800": { "l": "Y", "n": "\u8425\u53E3\u5E02", "c": "210800", "p": "210000" },
  "210900": { "l": "F", "n": "\u961C\u65B0\u5E02", "c": "210900", "p": "210000" },
  "211000": { "l": "L", "n": "\u8FBD\u9633\u5E02", "c": "211000", "p": "210000" },
  "211100": { "l": "P", "n": "\u76D8\u9526\u5E02", "c": "211100", "p": "210000" },
  "211200": { "l": "T", "n": "\u94C1\u5CAD\u5E02", "c": "211200", "p": "210000" },
  "211300": { "l": "C", "n": "\u671D\u9633\u5E02", "c": "211300", "p": "210000" },
  "211400": { "l": "H", "n": "\u846B\u82A6\u5C9B\u5E02", "c": "211400", "p": "210000" },
  "220100": { "l": "C", "n": "\u957F\u6625\u5E02", "c": "220100", "p": "220000" },
  "220200": { "l": "J", "n": "\u5409\u6797\u5E02", "c": "220200", "p": "220000" },
  "220300": { "l": "S", "n": "\u56DB\u5E73\u5E02", "c": "220300", "p": "220000" },
  "220400": { "l": "L", "n": "\u8FBD\u6E90\u5E02", "c": "220400", "p": "220000" },
  "220500": { "l": "T", "n": "\u901A\u5316\u5E02", "c": "220500", "p": "220000" },
  "220600": { "l": "B", "n": "\u767D\u5C71\u5E02", "c": "220600", "p": "220000" },
  "220700": { "l": "S", "n": "\u677E\u539F\u5E02", "c": "220700", "p": "220000" },
  "220800": { "l": "B", "n": "\u767D\u57CE\u5E02", "c": "220800", "p": "220000" },
  "222400": { "l": "Y", "n": "\u5EF6\u8FB9\u671D\u9C9C\u65CF\u81EA\u6CBB\u5DDE", "c": "222400", "p": "220000" },
  "230100": { "l": "H", "n": "\u54C8\u5C14\u6EE8\u5E02", "c": "230100", "p": "230000" },
  "230200": { "l": "Q", "n": "\u9F50\u9F50\u54C8\u5C14\u5E02", "c": "230200", "p": "230000" },
  "230300": { "l": "J", "n": "\u9E21\u897F\u5E02", "c": "230300", "p": "230000" },
  "230400": { "l": "H", "n": "\u9E64\u5C97\u5E02", "c": "230400", "p": "230000" },
  "230500": { "l": "S", "n": "\u53CC\u9E2D\u5C71\u5E02", "c": "230500", "p": "230000" },
  "230600": { "l": "D", "n": "\u5927\u5E86\u5E02", "c": "230600", "p": "230000" },
  "230700": { "l": "Y", "n": "\u4F0A\u6625\u5E02", "c": "230700", "p": "230000" },
  "230800": { "l": "J", "n": "\u4F73\u6728\u65AF\u5E02", "c": "230800", "p": "230000" },
  "230900": { "l": "Q", "n": "\u4E03\u53F0\u6CB3\u5E02", "c": "230900", "p": "230000" },
  "231000": { "l": "M", "n": "\u7261\u4E39\u6C5F\u5E02", "c": "231000", "p": "230000" },
  "231100": { "l": "H", "n": "\u9ED1\u6CB3\u5E02", "c": "231100", "p": "230000" },
  "231200": { "l": "S", "n": "\u7EE5\u5316\u5E02", "c": "231200", "p": "230000" },
  "232700": { "l": "D", "n": "\u5927\u5174\u5B89\u5CAD\u5730\u533A", "c": "232700", "p": "230000" },
  "310000": { "l": "S", "n": "\u4E0A\u6D77\u5E02", "c": "310000", "p": "86" },
  "320100": { "l": "N", "n": "\u5357\u4EAC\u5E02", "c": "320100", "p": "320000" },
  "320200": { "l": "W", "n": "\u65E0\u9521\u5E02", "c": "320200", "p": "320000" },
  "320300": { "l": "X", "n": "\u5F90\u5DDE\u5E02", "c": "320300", "p": "320000" },
  "320400": { "l": "C", "n": "\u5E38\u5DDE\u5E02", "c": "320400", "p": "320000" },
  "320500": { "l": "S", "n": "\u82CF\u5DDE\u5E02", "c": "320500", "p": "320000" },
  "320600": { "l": "N", "n": "\u5357\u901A\u5E02", "c": "320600", "p": "320000" },
  "320700": { "l": "L", "n": "\u8FDE\u4E91\u6E2F\u5E02", "c": "320700", "p": "320000" },
  "320800": { "l": "H", "n": "\u6DEE\u5B89\u5E02", "c": "320800", "p": "320000" },
  "320900": { "l": "Y", "n": "\u76D0\u57CE\u5E02", "c": "320900", "p": "320000" },
  "321000": { "l": "Y", "n": "\u626C\u5DDE\u5E02", "c": "321000", "p": "320000" },
  "321100": { "l": "Z", "n": "\u9547\u6C5F\u5E02", "c": "321100", "p": "320000" },
  "321200": { "l": "T", "n": "\u6CF0\u5DDE\u5E02", "c": "321200", "p": "320000" },
  "321300": { "l": "X", "n": "\u5BBF\u8FC1\u5E02", "c": "321300", "p": "320000" },
  "330100": { "l": "H", "n": "\u676D\u5DDE\u5E02", "c": "330100", "p": "330000" },
  "330200": { "l": "N", "n": "\u5B81\u6CE2\u5E02", "c": "330200", "p": "330000" },
  "330300": { "l": "W", "n": "\u6E29\u5DDE\u5E02", "c": "330300", "p": "330000" },
  "330400": { "l": "J", "n": "\u5609\u5174\u5E02", "c": "330400", "p": "330000" },
  "330500": { "l": "H", "n": "\u6E56\u5DDE\u5E02", "c": "330500", "p": "330000" },
  "330600": { "l": "S", "n": "\u7ECD\u5174\u5E02", "c": "330600", "p": "330000" },
  "330700": { "l": "J", "n": "\u91D1\u534E\u5E02", "c": "330700", "p": "330000" },
  "330800": { "l": "Q", "n": "\u8862\u5DDE\u5E02", "c": "330800", "p": "330000" },
  "330900": { "l": "Z", "n": "\u821F\u5C71\u5E02", "c": "330900", "p": "330000" },
  "331000": { "l": "T", "n": "\u53F0\u5DDE\u5E02", "c": "331000", "p": "330000" },
  "331100": { "l": "L", "n": "\u4E3D\u6C34\u5E02", "c": "331100", "p": "330000" },
  "340100": { "l": "H", "n": "\u5408\u80A5\u5E02", "c": "340100", "p": "340000" },
  "340200": { "l": "W", "n": "\u829C\u6E56\u5E02", "c": "340200", "p": "340000" },
  "340300": { "l": "B", "n": "\u868C\u57E0\u5E02", "c": "340300", "p": "340000" },
  "340400": { "l": "H", "n": "\u6DEE\u5357\u5E02", "c": "340400", "p": "340000" },
  "340500": { "l": "M", "n": "\u9A6C\u978D\u5C71\u5E02", "c": "340500", "p": "340000" },
  "340600": { "l": "H", "n": "\u6DEE\u5317\u5E02", "c": "340600", "p": "340000" },
  "340700": { "l": "T", "n": "\u94DC\u9675\u5E02", "c": "340700", "p": "340000" },
  "340800": { "l": "A", "n": "\u5B89\u5E86\u5E02", "c": "340800", "p": "340000" },
  "341000": { "l": "H", "n": "\u9EC4\u5C71\u5E02", "c": "341000", "p": "340000" },
  "341100": { "l": "C", "n": "\u6EC1\u5DDE\u5E02", "c": "341100", "p": "340000" },
  "341200": { "l": "F", "n": "\u961C\u9633\u5E02", "c": "341200", "p": "340000" },
  "341300": { "l": "X", "n": "\u5BBF\u5DDE\u5E02", "c": "341300", "p": "340000" },
  "341500": { "l": "L", "n": "\u516D\u5B89\u5E02", "c": "341500", "p": "340000" },
  "341600": { "l": "B", "n": "\u4EB3\u5DDE\u5E02", "c": "341600", "p": "340000" },
  "341700": { "l": "C", "n": "\u6C60\u5DDE\u5E02", "c": "341700", "p": "340000" },
  "341800": { "l": "X", "n": "\u5BA3\u57CE\u5E02", "c": "341800", "p": "340000" },
  "350100": { "l": "F", "n": "\u798F\u5DDE\u5E02", "c": "350100", "p": "350000" },
  "350200": { "l": "S", "n": "\u53A6\u95E8\u5E02", "c": "350200", "p": "350000" },
  "350300": { "l": "P", "n": "\u8386\u7530\u5E02", "c": "350300", "p": "350000" },
  "350400": { "l": "S", "n": "\u4E09\u660E\u5E02", "c": "350400", "p": "350000" },
  "350500": { "l": "Q", "n": "\u6CC9\u5DDE\u5E02", "c": "350500", "p": "350000" },
  "350600": { "l": "Z", "n": "\u6F33\u5DDE\u5E02", "c": "350600", "p": "350000" },
  "350700": { "l": "N", "n": "\u5357\u5E73\u5E02", "c": "350700", "p": "350000" },
  "350800": { "l": "L", "n": "\u9F99\u5CA9\u5E02", "c": "350800", "p": "350000" },
  "350900": { "l": "N", "n": "\u5B81\u5FB7\u5E02", "c": "350900", "p": "350000" },
  "360100": { "l": "N", "n": "\u5357\u660C\u5E02", "c": "360100", "p": "360000" },
  "360200": { "l": "J", "n": "\u666F\u5FB7\u9547\u5E02", "c": "360200", "p": "360000" },
  "360300": { "l": "P", "n": "\u840D\u4E61\u5E02", "c": "360300", "p": "360000" },
  "360400": { "l": "J", "n": "\u4E5D\u6C5F\u5E02", "c": "360400", "p": "360000" },
  "360500": { "l": "X", "n": "\u65B0\u4F59\u5E02", "c": "360500", "p": "360000" },
  "360600": { "l": "Y", "n": "\u9E70\u6F6D\u5E02", "c": "360600", "p": "360000" },
  "360700": { "l": "G", "n": "\u8D63\u5DDE\u5E02", "c": "360700", "p": "360000" },
  "360800": { "l": "J", "n": "\u5409\u5B89\u5E02", "c": "360800", "p": "360000" },
  "360900": { "l": "Y", "n": "\u5B9C\u6625\u5E02", "c": "360900", "p": "360000" },
  "361000": { "l": "F", "n": "\u629A\u5DDE\u5E02", "c": "361000", "p": "360000" },
  "361100": { "l": "S", "n": "\u4E0A\u9976\u5E02", "c": "361100", "p": "360000" },
  "370100": { "l": "J", "n": "\u6D4E\u5357\u5E02", "c": "370100", "p": "370000" },
  "370200": { "l": "Q", "n": "\u9752\u5C9B\u5E02", "c": "370200", "p": "370000" },
  "370300": { "l": "Z", "n": "\u6DC4\u535A\u5E02", "c": "370300", "p": "370000" },
  "370400": { "l": "Z", "n": "\u67A3\u5E84\u5E02", "c": "370400", "p": "370000" },
  "370500": { "l": "D", "n": "\u4E1C\u8425\u5E02", "c": "370500", "p": "370000" },
  "370600": { "l": "Y", "n": "\u70DF\u53F0\u5E02", "c": "370600", "p": "370000" },
  "370700": { "l": "W", "n": "\u6F4D\u574A\u5E02", "c": "370700", "p": "370000" },
  "370800": { "l": "J", "n": "\u6D4E\u5B81\u5E02", "c": "370800", "p": "370000" },
  "370900": { "l": "T", "n": "\u6CF0\u5B89\u5E02", "c": "370900", "p": "370000" },
  "371000": { "l": "W", "n": "\u5A01\u6D77\u5E02", "c": "371000", "p": "370000" },
  "371100": { "l": "R", "n": "\u65E5\u7167\u5E02", "c": "371100", "p": "370000" },
  "371200": { "l": "L", "n": "\u83B1\u829C\u5E02", "c": "371200", "p": "370000" },
  "371300": { "l": "L", "n": "\u4E34\u6C82\u5E02", "c": "371300", "p": "370000" },
  "371400": { "l": "D", "n": "\u5FB7\u5DDE\u5E02", "c": "371400", "p": "370000" },
  "371500": { "l": "L", "n": "\u804A\u57CE\u5E02", "c": "371500", "p": "370000" },
  "371600": { "l": "B", "n": "\u6EE8\u5DDE\u5E02", "c": "371600", "p": "370000" },
  "371700": { "l": "H", "n": "\u83CF\u6CFD\u5E02", "c": "371700", "p": "370000" },
  "410100": { "l": "Z", "n": "\u90D1\u5DDE\u5E02", "c": "410100", "p": "410000" },
  "410200": { "l": "K", "n": "\u5F00\u5C01\u5E02", "c": "410200", "p": "410000" },
  "410300": { "l": "L", "n": "\u6D1B\u9633\u5E02", "c": "410300", "p": "410000" },
  "410400": { "l": "P", "n": "\u5E73\u9876\u5C71\u5E02", "c": "410400", "p": "410000" },
  "410500": { "l": "A", "n": "\u5B89\u9633\u5E02", "c": "410500", "p": "410000" },
  "410600": { "l": "H", "n": "\u9E64\u58C1\u5E02", "c": "410600", "p": "410000" },
  "410700": { "l": "X", "n": "\u65B0\u4E61\u5E02", "c": "410700", "p": "410000" },
  "410800": { "l": "J", "n": "\u7126\u4F5C\u5E02", "c": "410800", "p": "410000" },
  "410900": { "l": "P", "n": "\u6FEE\u9633\u5E02", "c": "410900", "p": "410000" },
  "411000": { "l": "X", "n": "\u8BB8\u660C\u5E02", "c": "411000", "p": "410000" },
  "411100": { "l": "L", "n": "\u6F2F\u6CB3\u5E02", "c": "411100", "p": "410000" },
  "411200": { "l": "S", "n": "\u4E09\u95E8\u5CE1\u5E02", "c": "411200", "p": "410000" },
  "411300": { "l": "N", "n": "\u5357\u9633\u5E02", "c": "411300", "p": "410000" },
  "411400": { "l": "S", "n": "\u5546\u4E18\u5E02", "c": "411400", "p": "410000" },
  "411500": { "l": "X", "n": "\u4FE1\u9633\u5E02", "c": "411500", "p": "410000" },
  "411600": { "l": "Z", "n": "\u5468\u53E3\u5E02", "c": "411600", "p": "410000" },
  "411700": { "l": "Z", "n": "\u9A7B\u9A6C\u5E97\u5E02", "c": "411700", "p": "410000" },
  "419001": { "l": "J", "n": "\u6D4E\u6E90\u5E02", "c": "419001", "p": "410000" },
  "420100": { "l": "W", "n": "\u6B66\u6C49\u5E02", "c": "420100", "p": "420000" },
  "420200": { "l": "H", "n": "\u9EC4\u77F3\u5E02", "c": "420200", "p": "420000" },
  "420300": { "l": "S", "n": "\u5341\u5830\u5E02", "c": "420300", "p": "420000" },
  "420500": { "l": "Y", "n": "\u5B9C\u660C\u5E02", "c": "420500", "p": "420000" },
  "420600": { "l": "X", "n": "\u8944\u9633\u5E02", "c": "420600", "p": "420000" },
  "420700": { "l": "E", "n": "\u9102\u5DDE\u5E02", "c": "420700", "p": "420000" },
  "420800": { "l": "J", "n": "\u8346\u95E8\u5E02", "c": "420800", "p": "420000" },
  "420900": { "l": "X", "n": "\u5B5D\u611F\u5E02", "c": "420900", "p": "420000" },
  "421000": { "l": "J", "n": "\u8346\u5DDE\u5E02", "c": "421000", "p": "420000" },
  "421100": { "l": "H", "n": "\u9EC4\u5188\u5E02", "c": "421100", "p": "420000" },
  "421200": { "l": "X", "n": "\u54B8\u5B81\u5E02", "c": "421200", "p": "420000" },
  "421300": { "l": "S", "n": "\u968F\u5DDE\u5E02", "c": "421300", "p": "420000" },
  "422800": { "l": "E", "n": "\u6069\u65BD\u571F\u5BB6\u65CF\u82D7\u65CF\u81EA\u6CBB\u5DDE", "c": "422800", "p": "420000" },
  "429004": { "l": "X", "n": "\u4ED9\u6843\u5E02", "c": "429004", "p": "420000" },
  "429005": { "l": "Q", "n": "\u6F5C\u6C5F\u5E02", "c": "429005", "p": "420000" },
  "429006": { "l": "T", "n": "\u5929\u95E8\u5E02", "c": "429006", "p": "420000" },
  "429021": { "l": "S", "n": "\u795E\u519C\u67B6\u6797\u533A", "c": "429021", "p": "420000" },
  "430100": { "l": "C", "n": "\u957F\u6C99\u5E02", "c": "430100", "p": "430000" },
  "430200": { "l": "Z", "n": "\u682A\u6D32\u5E02", "c": "430200", "p": "430000" },
  "430300": { "l": "X", "n": "\u6E58\u6F6D\u5E02", "c": "430300", "p": "430000" },
  "430400": { "l": "H", "n": "\u8861\u9633\u5E02", "c": "430400", "p": "430000" },
  "430500": { "l": "S", "n": "\u90B5\u9633\u5E02", "c": "430500", "p": "430000" },
  "430600": { "l": "Y", "n": "\u5CB3\u9633\u5E02", "c": "430600", "p": "430000" },
  "430700": { "l": "C", "n": "\u5E38\u5FB7\u5E02", "c": "430700", "p": "430000" },
  "430800": { "l": "Z", "n": "\u5F20\u5BB6\u754C\u5E02", "c": "430800", "p": "430000" },
  "430900": { "l": "Y", "n": "\u76CA\u9633\u5E02", "c": "430900", "p": "430000" },
  "431000": { "l": "C", "n": "\u90F4\u5DDE\u5E02", "c": "431000", "p": "430000" },
  "431100": { "l": "Y", "n": "\u6C38\u5DDE\u5E02", "c": "431100", "p": "430000" },
  "431200": { "l": "H", "n": "\u6000\u5316\u5E02", "c": "431200", "p": "430000" },
  "431300": { "l": "L", "n": "\u5A04\u5E95\u5E02", "c": "431300", "p": "430000" },
  "433100": { "l": "X", "n": "\u6E58\u897F\u571F\u5BB6\u65CF\u82D7\u65CF\u81EA\u6CBB\u5DDE", "c": "433100", "p": "430000" },
  "440100": { "l": "G", "n": "\u5E7F\u5DDE\u5E02", "c": "440100", "p": "440000" },
  "440200": { "l": "S", "n": "\u97F6\u5173\u5E02", "c": "440200", "p": "440000" },
  "440300": { "l": "S", "n": "\u6DF1\u5733\u5E02", "c": "440300", "p": "440000" },
  "440400": { "l": "Z", "n": "\u73E0\u6D77\u5E02", "c": "440400", "p": "440000" },
  "440500": { "l": "S", "n": "\u6C55\u5934\u5E02", "c": "440500", "p": "440000" },
  "440600": { "l": "F", "n": "\u4F5B\u5C71\u5E02", "c": "440600", "p": "440000" },
  "440700": { "l": "J", "n": "\u6C5F\u95E8\u5E02", "c": "440700", "p": "440000" },
  "440800": { "l": "Z", "n": "\u6E5B\u6C5F\u5E02", "c": "440800", "p": "440000" },
  "440900": { "l": "M", "n": "\u8302\u540D\u5E02", "c": "440900", "p": "440000" },
  "441200": { "l": "Z", "n": "\u8087\u5E86\u5E02", "c": "441200", "p": "440000" },
  "441300": { "l": "H", "n": "\u60E0\u5DDE\u5E02", "c": "441300", "p": "440000" },
  "441400": { "l": "M", "n": "\u6885\u5DDE\u5E02", "c": "441400", "p": "440000" },
  "441500": { "l": "S", "n": "\u6C55\u5C3E\u5E02", "c": "441500", "p": "440000" },
  "441600": { "l": "H", "n": "\u6CB3\u6E90\u5E02", "c": "441600", "p": "440000" },
  "441700": { "l": "Y", "n": "\u9633\u6C5F\u5E02", "c": "441700", "p": "440000" },
  "441800": { "l": "Q", "n": "\u6E05\u8FDC\u5E02", "c": "441800", "p": "440000" },
  "441900": { "l": "D", "n": "\u4E1C\u839E\u5E02", "c": "441900", "p": "440000" },
  "442000": { "l": "Z", "n": "\u4E2D\u5C71\u5E02", "c": "442000", "p": "440000" },
  "445100": { "l": "C", "n": "\u6F6E\u5DDE\u5E02", "c": "445100", "p": "440000" },
  "445200": { "l": "J", "n": "\u63ED\u9633\u5E02", "c": "445200", "p": "440000" },
  "445300": { "l": "Y", "n": "\u4E91\u6D6E\u5E02", "c": "445300", "p": "440000" },
  "450100": { "l": "N", "n": "\u5357\u5B81\u5E02", "c": "450100", "p": "450000" },
  "450200": { "l": "L", "n": "\u67F3\u5DDE\u5E02", "c": "450200", "p": "450000" },
  "450300": { "l": "G", "n": "\u6842\u6797\u5E02", "c": "450300", "p": "450000" },
  "450400": { "l": "W", "n": "\u68A7\u5DDE\u5E02", "c": "450400", "p": "450000" },
  "450500": { "l": "B", "n": "\u5317\u6D77\u5E02", "c": "450500", "p": "450000" },
  "450600": { "l": "F", "n": "\u9632\u57CE\u6E2F\u5E02", "c": "450600", "p": "450000" },
  "450700": { "l": "Q", "n": "\u94A6\u5DDE\u5E02", "c": "450700", "p": "450000" },
  "450800": { "l": "G", "n": "\u8D35\u6E2F\u5E02", "c": "450800", "p": "450000" },
  "450900": { "l": "Y", "n": "\u7389\u6797\u5E02", "c": "450900", "p": "450000" },
  "451000": { "l": "B", "n": "\u767E\u8272\u5E02", "c": "451000", "p": "450000" },
  "451100": { "l": "H", "n": "\u8D3A\u5DDE\u5E02", "c": "451100", "p": "450000" },
  "451200": { "l": "H", "n": "\u6CB3\u6C60\u5E02", "c": "451200", "p": "450000" },
  "451300": { "l": "L", "n": "\u6765\u5BBE\u5E02", "c": "451300", "p": "450000" },
  "451400": { "l": "C", "n": "\u5D07\u5DE6\u5E02", "c": "451400", "p": "450000" },
  "460100": { "l": "H", "n": "\u6D77\u53E3\u5E02", "c": "460100", "p": "460000" },
  "460200": { "l": "S", "n": "\u4E09\u4E9A\u5E02", "c": "460200", "p": "460000" },
  "460300": { "l": "S", "n": "\u4E09\u6C99\u5E02", "c": "460300", "p": "460000" },
  "460400": { "l": "D", "n": "\u510B\u5DDE\u5E02", "c": "460400", "p": "460000" },
  "469001": { "l": "W", "n": "\u4E94\u6307\u5C71\u5E02", "c": "469001", "p": "460000" },
  "469002": { "l": "Q", "n": "\u743C\u6D77\u5E02", "c": "469002", "p": "460000" },
  "469005": { "l": "W", "n": "\u6587\u660C\u5E02", "c": "469005", "p": "460000" },
  "469006": { "l": "W", "n": "\u4E07\u5B81\u5E02", "c": "469006", "p": "460000" },
  "469007": { "l": "D", "n": "\u4E1C\u65B9\u5E02", "c": "469007", "p": "460000" },
  "469021": { "l": "D", "n": "\u5B9A\u5B89\u53BF", "c": "469021", "p": "460000" },
  "469022": { "l": "T", "n": "\u5C6F\u660C\u53BF", "c": "469022", "p": "460000" },
  "469023": { "l": "C", "n": "\u6F84\u8FC8\u53BF", "c": "469023", "p": "460000" },
  "469024": { "l": "L", "n": "\u4E34\u9AD8\u53BF", "c": "469024", "p": "460000" },
  "469025": { "l": "B", "n": "\u767D\u6C99\u9ECE\u65CF\u81EA\u6CBB\u53BF", "c": "469025", "p": "460000" },
  "469026": { "l": "C", "n": "\u660C\u6C5F\u9ECE\u65CF\u81EA\u6CBB\u53BF", "c": "469026", "p": "460000" },
  "469027": { "l": "L", "n": "\u4E50\u4E1C\u9ECE\u65CF\u81EA\u6CBB\u53BF", "c": "469027", "p": "460000" },
  "469028": { "l": "L", "n": "\u9675\u6C34\u9ECE\u65CF\u81EA\u6CBB\u53BF", "c": "469028", "p": "460000" },
  "469029": { "l": "B", "n": "\u4FDD\u4EAD\u9ECE\u65CF\u82D7\u65CF\u81EA\u6CBB\u53BF", "c": "469029", "p": "460000" },
  "469030": { "l": "Q", "n": "\u743C\u4E2D\u9ECE\u65CF\u82D7\u65CF\u81EA\u6CBB\u53BF", "c": "469030", "p": "460000" },
  "500000": { "l": "C", "n": "\u91CD\u5E86\u5E02", "c": "500000", "p": "86" },
  "510100": { "l": "C", "n": "\u6210\u90FD\u5E02", "c": "510100", "p": "510000" },
  "510300": { "l": "Z", "n": "\u81EA\u8D21\u5E02", "c": "510300", "p": "510000" },
  "510400": { "l": "P", "n": "\u6500\u679D\u82B1\u5E02", "c": "510400", "p": "510000" },
  "510500": { "l": "L", "n": "\u6CF8\u5DDE\u5E02", "c": "510500", "p": "510000" },
  "510600": { "l": "D", "n": "\u5FB7\u9633\u5E02", "c": "510600", "p": "510000" },
  "510700": { "l": "M", "n": "\u7EF5\u9633\u5E02", "c": "510700", "p": "510000" },
  "510800": { "l": "G", "n": "\u5E7F\u5143\u5E02", "c": "510800", "p": "510000" },
  "510900": { "l": "S", "n": "\u9042\u5B81\u5E02", "c": "510900", "p": "510000" },
  "511000": { "l": "N", "n": "\u5185\u6C5F\u5E02", "c": "511000", "p": "510000" },
  "511100": { "l": "L", "n": "\u4E50\u5C71\u5E02", "c": "511100", "p": "510000" },
  "511300": { "l": "N", "n": "\u5357\u5145\u5E02", "c": "511300", "p": "510000" },
  "511400": { "l": "M", "n": "\u7709\u5C71\u5E02", "c": "511400", "p": "510000" },
  "511500": { "l": "Y", "n": "\u5B9C\u5BBE\u5E02", "c": "511500", "p": "510000" },
  "511600": { "l": "G", "n": "\u5E7F\u5B89\u5E02", "c": "511600", "p": "510000" },
  "511700": { "l": "D", "n": "\u8FBE\u5DDE\u5E02", "c": "511700", "p": "510000" },
  "511800": { "l": "Y", "n": "\u96C5\u5B89\u5E02", "c": "511800", "p": "510000" },
  "511900": { "l": "B", "n": "\u5DF4\u4E2D\u5E02", "c": "511900", "p": "510000" },
  "512000": { "l": "Z", "n": "\u8D44\u9633\u5E02", "c": "512000", "p": "510000" },
  "513200": { "l": "A", "n": "\u963F\u575D\u85CF\u65CF\u7F8C\u65CF\u81EA\u6CBB\u5DDE", "c": "513200", "p": "510000" },
  "513300": { "l": "G", "n": "\u7518\u5B5C\u85CF\u65CF\u81EA\u6CBB\u5DDE", "c": "513300", "p": "510000" },
  "513400": { "l": "L", "n": "\u51C9\u5C71\u5F5D\u65CF\u81EA\u6CBB\u5DDE", "c": "513400", "p": "510000" },
  "520100": { "l": "G", "n": "\u8D35\u9633\u5E02", "c": "520100", "p": "520000" },
  "520200": { "l": "L", "n": "\u516D\u76D8\u6C34\u5E02", "c": "520200", "p": "520000" },
  "520300": { "l": "Z", "n": "\u9075\u4E49\u5E02", "c": "520300", "p": "520000" },
  "520400": { "l": "A", "n": "\u5B89\u987A\u5E02", "c": "520400", "p": "520000" },
  "520500": { "l": "B", "n": "\u6BD5\u8282\u5E02", "c": "520500", "p": "520000" },
  "520600": { "l": "T", "n": "\u94DC\u4EC1\u5E02", "c": "520600", "p": "520000" },
  "522300": { "l": "Q", "n": "\u9ED4\u897F\u5357\u5E03\u4F9D\u65CF\u82D7\u65CF\u81EA\u6CBB\u5DDE", "c": "522300", "p": "520000" },
  "522600": { "l": "Q", "n": "\u9ED4\u4E1C\u5357\u82D7\u65CF\u4F97\u65CF\u81EA\u6CBB\u5DDE", "c": "522600", "p": "520000" },
  "522700": { "l": "Q", "n": "\u9ED4\u5357\u5E03\u4F9D\u65CF\u82D7\u65CF\u81EA\u6CBB\u5DDE", "c": "522700", "p": "520000" },
  "530100": { "l": "K", "n": "\u6606\u660E\u5E02", "c": "530100", "p": "530000" },
  "530300": { "l": "Q", "n": "\u66F2\u9756\u5E02", "c": "530300", "p": "530000" },
  "530400": { "l": "Y", "n": "\u7389\u6EAA\u5E02", "c": "530400", "p": "530000" },
  "530500": { "l": "B", "n": "\u4FDD\u5C71\u5E02", "c": "530500", "p": "530000" },
  "530600": { "l": "Z", "n": "\u662D\u901A\u5E02", "c": "530600", "p": "530000" },
  "530700": { "l": "L", "n": "\u4E3D\u6C5F\u5E02", "c": "530700", "p": "530000" },
  "530800": { "l": "P", "n": "\u666E\u6D31\u5E02", "c": "530800", "p": "530000" },
  "530900": { "l": "L", "n": "\u4E34\u6CA7\u5E02", "c": "530900", "p": "530000" },
  "532300": { "l": "C", "n": "\u695A\u96C4\u5F5D\u65CF\u81EA\u6CBB\u5DDE", "c": "532300", "p": "530000" },
  "532500": { "l": "H", "n": "\u7EA2\u6CB3\u54C8\u5C3C\u65CF\u5F5D\u65CF\u81EA\u6CBB\u5DDE", "c": "532500", "p": "530000" },
  "532600": { "l": "W", "n": "\u6587\u5C71\u58EE\u65CF\u82D7\u65CF\u81EA\u6CBB\u5DDE", "c": "532600", "p": "530000" },
  "532800": { "l": "X", "n": "\u897F\u53CC\u7248\u7EB3\u50A3\u65CF\u81EA\u6CBB\u5DDE", "c": "532800", "p": "530000" },
  "532900": { "l": "D", "n": "\u5927\u7406\u767D\u65CF\u81EA\u6CBB\u5DDE", "c": "532900", "p": "530000" },
  "533100": { "l": "D", "n": "\u5FB7\u5B8F\u50A3\u65CF\u666F\u9887\u65CF\u81EA\u6CBB\u5DDE", "c": "533100", "p": "530000" },
  "533300": { "l": "N", "n": "\u6012\u6C5F\u5088\u50F3\u65CF\u81EA\u6CBB\u5DDE", "c": "533300", "p": "530000" },
  "533400": { "l": "D", "n": "\u8FEA\u5E86\u85CF\u65CF\u81EA\u6CBB\u5DDE", "c": "533400", "p": "530000" },
  "540100": { "l": "L", "n": "\u62C9\u8428\u5E02", "c": "540100", "p": "540000" },
  "540200": { "l": "R", "n": "\u65E5\u5580\u5219\u5E02", "c": "540200", "p": "540000" },
  "540300": { "l": "C", "n": "\u660C\u90FD\u5E02", "c": "540300", "p": "540000" },
  "540400": { "l": "L", "n": "\u6797\u829D\u5E02", "c": "540400", "p": "540000" },
  "540500": { "l": "S", "n": "\u5C71\u5357\u5E02", "c": "540500", "p": "540000" },
  "542400": { "l": "N", "n": "\u90A3\u66F2\u5730\u533A", "c": "542400", "p": "540000" },
  "542500": { "l": "A", "n": "\u963F\u91CC\u5730\u533A", "c": "542500", "p": "540000" },
  "610100": { "l": "X", "n": "\u897F\u5B89\u5E02", "c": "610100", "p": "610000" },
  "610200": { "l": "T", "n": "\u94DC\u5DDD\u5E02", "c": "610200", "p": "610000" },
  "610300": { "l": "B", "n": "\u5B9D\u9E21\u5E02", "c": "610300", "p": "610000" },
  "610400": { "l": "X", "n": "\u54B8\u9633\u5E02", "c": "610400", "p": "610000" },
  "610500": { "l": "W", "n": "\u6E2D\u5357\u5E02", "c": "610500", "p": "610000" },
  "610600": { "l": "Y", "n": "\u5EF6\u5B89\u5E02", "c": "610600", "p": "610000" },
  "610700": { "l": "H", "n": "\u6C49\u4E2D\u5E02", "c": "610700", "p": "610000" },
  "610800": { "l": "Y", "n": "\u6986\u6797\u5E02", "c": "610800", "p": "610000" },
  "610900": { "l": "A", "n": "\u5B89\u5EB7\u5E02", "c": "610900", "p": "610000" },
  "611000": { "l": "S", "n": "\u5546\u6D1B\u5E02", "c": "611000", "p": "610000" },
  "620100": { "l": "L", "n": "\u5170\u5DDE\u5E02", "c": "620100", "p": "620000" },
  "620200": { "l": "J", "n": "\u5609\u5CEA\u5173\u5E02", "c": "620200", "p": "620000" },
  "620300": { "l": "J", "n": "\u91D1\u660C\u5E02", "c": "620300", "p": "620000" },
  "620400": { "l": "B", "n": "\u767D\u94F6\u5E02", "c": "620400", "p": "620000" },
  "620500": { "l": "T", "n": "\u5929\u6C34\u5E02", "c": "620500", "p": "620000" },
  "620600": { "l": "W", "n": "\u6B66\u5A01\u5E02", "c": "620600", "p": "620000" },
  "620700": { "l": "Z", "n": "\u5F20\u6396\u5E02", "c": "620700", "p": "620000" },
  "620800": { "l": "P", "n": "\u5E73\u51C9\u5E02", "c": "620800", "p": "620000" },
  "620900": { "l": "J", "n": "\u9152\u6CC9\u5E02", "c": "620900", "p": "620000" },
  "621000": { "l": "Q", "n": "\u5E86\u9633\u5E02", "c": "621000", "p": "620000" },
  "621100": { "l": "D", "n": "\u5B9A\u897F\u5E02", "c": "621100", "p": "620000" },
  "621200": { "l": "L", "n": "\u9647\u5357\u5E02", "c": "621200", "p": "620000" },
  "622900": { "l": "L", "n": "\u4E34\u590F\u56DE\u65CF\u81EA\u6CBB\u5DDE", "c": "622900", "p": "620000" },
  "623000": { "l": "G", "n": "\u7518\u5357\u85CF\u65CF\u81EA\u6CBB\u5DDE", "c": "623000", "p": "620000" },
  "630100": { "l": "X", "n": "\u897F\u5B81\u5E02", "c": "630100", "p": "630000" },
  "630200": { "l": "H", "n": "\u6D77\u4E1C\u5E02", "c": "630200", "p": "630000" },
  "632200": { "l": "H", "n": "\u6D77\u5317\u85CF\u65CF\u81EA\u6CBB\u5DDE", "c": "632200", "p": "630000" },
  "632300": { "l": "H", "n": "\u9EC4\u5357\u85CF\u65CF\u81EA\u6CBB\u5DDE", "c": "632300", "p": "630000" },
  "632500": { "l": "H", "n": "\u6D77\u5357\u85CF\u65CF\u81EA\u6CBB\u5DDE", "c": "632500", "p": "630000" },
  "632600": { "l": "G", "n": "\u679C\u6D1B\u85CF\u65CF\u81EA\u6CBB\u5DDE", "c": "632600", "p": "630000" },
  "632700": { "l": "Y", "n": "\u7389\u6811\u85CF\u65CF\u81EA\u6CBB\u5DDE", "c": "632700", "p": "630000" },
  "632800": { "l": "H", "n": "\u6D77\u897F\u8499\u53E4\u65CF\u85CF\u65CF\u81EA\u6CBB\u5DDE", "c": "632800", "p": "630000" },
  "640100": { "l": "Y", "n": "\u94F6\u5DDD\u5E02", "c": "640100", "p": "640000" },
  "640200": { "l": "S", "n": "\u77F3\u5634\u5C71\u5E02", "c": "640200", "p": "640000" },
  "640300": { "l": "W", "n": "\u5434\u5FE0\u5E02", "c": "640300", "p": "640000" },
  "640400": { "l": "G", "n": "\u56FA\u539F\u5E02", "c": "640400", "p": "640000" },
  "640500": { "l": "Z", "n": "\u4E2D\u536B\u5E02", "c": "640500", "p": "640000" },
  "650100": { "l": "W", "n": "\u4E4C\u9C81\u6728\u9F50\u5E02", "c": "650100", "p": "650000" },
  "650200": { "l": "K", "n": "\u514B\u62C9\u739B\u4F9D\u5E02", "c": "650200", "p": "650000" },
  "650400": { "l": "T", "n": "\u5410\u9C81\u756A\u5E02", "c": "650400", "p": "650000" },
  "650500": { "l": "H", "n": "\u54C8\u5BC6\u5E02", "c": "650500", "p": "650000" },
  "652300": { "l": "C", "n": "\u660C\u5409\u56DE\u65CF\u81EA\u6CBB\u5DDE", "c": "652300", "p": "650000" },
  "652700": { "l": "B", "n": "\u535A\u5C14\u5854\u62C9\u8499\u53E4\u81EA\u6CBB\u5DDE", "c": "652700", "p": "650000" },
  "652800": { "l": "B", "n": "\u5DF4\u97F3\u90ED\u695E\u8499\u53E4\u81EA\u6CBB\u5DDE", "c": "652800", "p": "650000" },
  "652900": { "l": "A", "n": "\u963F\u514B\u82CF\u5730\u533A", "c": "652900", "p": "650000" },
  "653000": { "l": "K", "n": "\u514B\u5B5C\u52D2\u82CF\u67EF\u5C14\u514B\u5B5C\u81EA\u6CBB\u5DDE", "c": "653000", "p": "650000" },
  "653100": { "l": "K", "n": "\u5580\u4EC0\u5730\u533A", "c": "653100", "p": "650000" },
  "653200": { "l": "H", "n": "\u548C\u7530\u5730\u533A", "c": "653200", "p": "650000" },
  "654000": { "l": "Y", "n": "\u4F0A\u7281\u54C8\u8428\u514B\u81EA\u6CBB\u5DDE", "c": "654000", "p": "650000" },
  "654200": { "l": "T", "n": "\u5854\u57CE\u5730\u533A", "c": "654200", "p": "650000" },
  "654300": { "l": "A", "n": "\u963F\u52D2\u6CF0\u5730\u533A", "c": "654300", "p": "650000" },
  "659001": { "l": "S", "n": "\u77F3\u6CB3\u5B50\u5E02", "c": "659001", "p": "650000" },
  "659002": { "l": "A", "n": "\u963F\u62C9\u5C14\u5E02", "c": "659002", "p": "650000" },
  "659003": { "l": "T", "n": "\u56FE\u6728\u8212\u514B\u5E02", "c": "659003", "p": "650000" },
  "659004": { "l": "W", "n": "\u4E94\u5BB6\u6E20\u5E02", "c": "659004", "p": "650000" },
  "659006": { "l": "T", "n": "\u94C1\u95E8\u5173\u5E02", "c": "659006", "p": "650000" },
  "710101": { "l": "J", "n": "\u91D1\u95E8", "c": "710101", "p": "710000" },
  "710102": { "l": "L", "n": "\u8FDE\u6C5F", "c": "710102", "p": "710000" },
  "710103": { "l": "M", "n": "\u82D7\u6817", "c": "710103", "p": "710000" },
  "710104": { "l": "N", "n": "\u5357\u6295", "c": "710104", "p": "710000" },
  "710105": { "l": "P", "n": "\u6F8E\u6E56", "c": "710105", "p": "710000" },
  "710106": { "l": "P", "n": "\u5C4F\u4E1C", "c": "710106", "p": "710000" },
  "710107": { "l": "T", "n": "\u53F0\u4E1C", "c": "710107", "p": "710000" },
  "710108": { "l": "T", "n": "\u53F0\u4E2D", "c": "710108", "p": "710000" },
  "710109": { "l": "T", "n": "\u53F0\u5357", "c": "710109", "p": "710000" },
  "710110": { "l": "T", "n": "\u53F0\u5317", "c": "710110", "p": "710000" },
  "710111": { "l": "T", "n": "\u6843\u56ED", "c": "710111", "p": "710000" },
  "710112": { "l": "Y", "n": "\u4E91\u6797", "c": "710112", "p": "710000" },
  "710113": { "l": "X", "n": "\u65B0\u5317", "c": "710113", "p": "710000" },
  "710114": { "l": "Z", "n": "\u5F70\u5316", "c": "710114", "p": "710000" },
  "710115": { "l": "J", "n": "\u5609\u4E49", "c": "710115", "p": "710000" },
  "710116": { "l": "X", "n": "\u65B0\u7AF9", "c": "710116", "p": "710000" },
  "710117": { "l": "H", "n": "\u82B1\u83B2", "c": "710117", "p": "710000" },
  "710118": { "l": "Y", "n": "\u5B9C\u5170", "c": "710118", "p": "710000" },
  "710119": { "l": "G", "n": "\u9AD8\u96C4", "c": "710119", "p": "710000" },
  "710120": { "l": "J", "n": "\u57FA\u9686", "c": "710120", "p": "710000" },
  "810000": { "l": "X", "n": "\u9999\u6E2F\u7279\u522B\u884C\u653F\u533A", "c": "810000", "p": "86" },
  "820000": { "l": "A", "n": "\u6FB3\u95E8\u7279\u522B\u884C\u653F\u533A", "c": "820000", "p": "86" }
};
function getCityName(name2) {
  return name2.replace("\u5E02", "").replace("\u5730\u533A", "").replace("\u7279\u522B\u884C\u653F\u533A", "");
}
function handleGetCities() {
  const cData = deepCopy(cityData);
  const cities = [];
  for (let cid in cData) {
    const city = cData[cid];
    city.n = getCityName(city.n);
    cities.push(city);
  }
  return cities;
}
function handleGetCodeByName(cities, name2) {
  if (!name2)
    return "";
  const info = cities.find((item) => item.n === name2);
  if (info) {
    return info.c;
  } else {
    console.error(`[View UI warn]: City name error.`);
    return "";
  }
}
function handleGetNameByCode(cities, code) {
  const info = cities.find((item) => item.c === code);
  return info.n;
}
const _sfc_main$1O = {
  name: "City",
  mixins: [mixinsForm],
  components: { Dropdown, DropdownMenu, Select, Option: iOption, Tag, Icon, RadioGroup, Radio },
  emits: ["on-change", "update:modelValue"],
  props: {
    modelValue: {
      type: String
    },
    useName: {
      type: Boolean,
      default: false
    },
    cities: {
      type: Array,
      default() {
        return [];
      }
    },
    disabled: {
      type: Boolean,
      default: false
    },
    clearable: {
      type: Boolean,
      default: false
    },
    showSuffix: {
      type: Boolean,
      default: false
    },
    size: {
      validator(value) {
        return oneOf(value, ["small", "large", "default"]);
      },
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.size === "" ? "default" : global2.$VIEWUI.size;
      }
    },
    transfer: {
      type: Boolean,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.transfer === "" ? false : global2.$VIEWUI.transfer;
      }
    },
    name: {
      type: String
    },
    elementId: {
      type: String
    },
    placeholder: {
      type: String,
      default: "\u8BF7\u9009\u62E9"
    },
    searchPlaceholder: {
      type: String,
      default: "\u8F93\u5165\u57CE\u5E02\u540D\u79F0\u641C\u7D22"
    },
    transferClassName: {
      type: String
    }
  },
  data() {
    const allCities = handleGetCities();
    const value = this.useName ? handleGetCodeByName(allCities, this.modelValue) : this.modelValue;
    return {
      currentValue: value,
      visible: false,
      provinceList: [],
      cityListByProvince: [],
      cityListByLetter: {},
      allCities,
      listType: "province",
      queryCity: ""
    };
  },
  watch: {
    modelValue(val) {
      const value = this.useName ? handleGetCodeByName(this.allCities, val) : val;
      this.currentValue = value;
    }
  },
  computed: {
    showCloseIcon() {
      return this.currentValue && this.clearable && !this.itemDisabled;
    },
    classes() {
      return [
        {
          ["ivu-city-show-clear"]: this.showCloseIcon,
          [`ivu-city-size-${this.size}`]: !!this.size,
          ["ivu-city-visible"]: this.visible,
          ["ivu-city-disabled"]: this.itemDisabled
        }
      ];
    },
    transferClasses() {
      let classes = "ivu-city-transfer";
      if (this.transferClassName)
        classes += ` ${this.transferClassName}`;
      return classes;
    },
    relCities() {
      const cities = [];
      if (this.cities.length) {
        this.cities.forEach((item) => {
          const newItem = cityData[item];
          newItem.n = getCityName(newItem.n);
          cities.push(newItem);
        });
      }
      return cities;
    },
    codeToName() {
      if (!this.currentValue)
        return this.placeholder;
      const n = cityData[this.currentValue].n;
      return this.showSuffix ? n : getCityName(n);
    }
  },
  methods: {
    handleSelect(val) {
      if (val) {
        this.handleChangeValue(val);
        nextTick(() => {
          this.queryCity = "";
        });
      }
    },
    handleChangeValue(val) {
      this.currentValue = val;
      this.visible = false;
      const value = this.useName ? handleGetNameByCode(this.allCities, val) : val;
      this.$emit("update:modelValue", value);
      this.$emit("on-change", cityData[val]);
      this.handleFormItemChange("change", val);
    },
    handleClickLetter(l) {
      let letter = l;
      if (letter === "\u76F4\u8F96\u5E02")
        letter = "Z1";
      else if (letter === "\u6E2F\u6FB3")
        letter = "Z2";
      const className = `.ivu-city-${letter}`;
      const $list = this.$refs.list;
      const $letter = $list.querySelectorAll(className)[0];
      const offsetTop = $letter.offsetTop;
      const listTop = $list.offsetTop;
      $list.scrollTop = offsetTop - listTop;
    },
    clearSelect() {
      if (this.itemDisabled)
        return false;
    },
    handleToggleOpen() {
      if (this.itemDisabled)
        return false;
      this.visible = !this.visible;
    },
    handleVisibleChange(visible) {
      this.visible = visible;
    },
    handleClickOutside(e) {
      if (this.$refs.city.contains(e.target))
        return;
      this.visible = false;
    },
    handleGetProvinceByLetter() {
      const provinces = {
        A: {
          n: "A",
          p: [],
          c: []
        },
        F: {
          n: "F",
          p: [],
          c: []
        },
        G: {
          n: "G",
          p: [],
          c: []
        },
        H: {
          n: "H",
          p: [],
          c: []
        },
        J: {
          n: "J",
          p: [],
          c: []
        },
        L: {
          n: "L",
          p: [],
          c: []
        },
        N: {
          n: "N",
          p: [],
          c: []
        },
        Q: {
          n: "Q",
          p: [],
          c: []
        },
        S: {
          n: "S",
          p: [],
          c: []
        },
        T: {
          n: "T",
          p: [],
          c: []
        },
        X: {
          n: "X",
          p: [],
          c: []
        },
        Y: {
          n: "Y",
          p: [],
          c: []
        },
        Z: {
          n: "Z",
          p: [],
          c: []
        },
        Z1: {
          n: "\u76F4\u8F96\u5E02",
          p: [],
          c: []
        },
        Z2: {
          n: "\u6E2F\u6FB3",
          p: [],
          c: []
        }
      };
      for (let c in provinceData) {
        const item = provinceData[c];
        provinces[item.l].p.push(item);
      }
      this.provinceList = provinces;
    },
    handleGetCityByProvince() {
      const provinceList = deepCopy(this.provinceList);
      const cityListByProvince = [];
      const cData = deepCopy(cityData);
      const otherCities = [
        {
          p: {
            n: "\u76F4\u8F96\u5E02",
            p: "86",
            l: "Z1"
          },
          c: []
        },
        {
          p: {
            n: "\u6E2F\u6FB3",
            p: "86",
            l: "Z2"
          },
          c: []
        }
      ];
      for (let letter in provinceList) {
        const letterProvince = provinceList[letter];
        for (let i = 0; i < letterProvince.p.length; i++) {
          const province = letterProvince.p[i];
          const pid = province.c;
          const provinceCities = {
            p: province,
            c: []
          };
          for (let cid in cData) {
            const city = cData[cid];
            city.n = getCityName(city.n);
            if (pid === city.p) {
              provinceCities.c.push(city);
            }
          }
          if (letter === "Z1") {
            otherCities[0].c.push(cData[pid]);
          } else if (letter === "Z2") {
            otherCities[1].c.push(cData[pid]);
          } else {
            cityListByProvince.push(provinceCities);
          }
        }
      }
      this.cityListByProvince = cityListByProvince.concat(otherCities);
    },
    handleGetCityByLetter() {
      const cData = deepCopy(cityData);
      const cityListByLetter = {
        A: [],
        B: [],
        C: [],
        D: [],
        E: [],
        F: [],
        G: [],
        H: [],
        J: [],
        K: [],
        L: [],
        M: [],
        N: [],
        P: [],
        Q: [],
        R: [],
        S: [],
        T: [],
        W: [],
        X: [],
        Y: [],
        Z: []
      };
      for (let cid in cData) {
        const city = cData[cid];
        city.n = getCityName(city.n);
        cityListByLetter[city.l].push(city);
      }
      this.cityListByLetter = cityListByLetter;
    }
  },
  created() {
    this.handleGetProvinceByLetter();
    this.handleGetCityByProvince();
    this.handleGetCityByLetter();
  }
};
const _hoisted_1$U = ["name", "value"];
const _hoisted_2$y = { class: "ivu-city-drop" };
const _hoisted_3$q = {
  key: 0,
  class: "ivu-city-drop-cities"
};
const _hoisted_4$j = ["onClick"];
const _hoisted_5$c = { class: "ivu-city-drop-menu" };
const _hoisted_6$5 = { class: "ivu-city-drop-type" };
const _hoisted_7$4 = { class: "ivu-city-drop-search" };
const _hoisted_8$3 = {
  key: 1,
  class: "ivu-city-drop-list"
};
const _hoisted_9$3 = { class: "ivu-city-drop-list-letter" };
const _hoisted_10$3 = {
  class: "ivu-city-drop-list-main",
  ref: "list"
};
const _hoisted_11$3 = ["onClick"];
const _hoisted_12$2 = {
  key: 2,
  class: "ivu-city-drop-list"
};
const _hoisted_13$1 = { class: "ivu-city-drop-list-letter" };
const _hoisted_14$1 = {
  class: "ivu-city-drop-list-main ivu-city-drop-list-main-city",
  ref: "list"
};
const _hoisted_15$1 = ["onClick"];
function _sfc_render$1A(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = resolveComponent("Icon");
  const _component_Radio = resolveComponent("Radio");
  const _component_RadioGroup = resolveComponent("RadioGroup");
  const _component_Option = resolveComponent("Option");
  const _component_Select = resolveComponent("Select");
  const _component_Tag = resolveComponent("Tag");
  const _component_DropdownMenu = resolveComponent("DropdownMenu");
  const _component_Dropdown = resolveComponent("Dropdown");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(["ivu-city", $options.classes]),
    ref: "city"
  }, [
    createVNode(_component_Dropdown, {
      trigger: "custom",
      visible: $data.visible,
      transfer: $props.transfer,
      placement: "bottom-start",
      "transfer-class-name": $options.transferClasses,
      onOnVisibleChange: $options.handleVisibleChange,
      onOnClickoutside: $options.handleClickOutside
    }, {
      list: withCtx(() => [
        createVNode(_component_DropdownMenu, {
          onClick: _cache[3] || (_cache[3] = withModifiers(() => {
          }, ["stop"]))
        }, {
          default: withCtx(() => [
            createElementVNode("div", _hoisted_2$y, [
              $props.cities.length ? (openBlock(), createElementBlock("div", _hoisted_3$q, [
                (openBlock(true), createElementBlock(Fragment, null, renderList($options.relCities, (item) => {
                  return openBlock(), createElementBlock("span", {
                    key: item.n,
                    onClick: ($event) => $options.handleChangeValue(item.c)
                  }, toDisplayString(item.n), 9, _hoisted_4$j);
                }), 128))
              ])) : createCommentVNode("", true),
              createElementVNode("div", _hoisted_5$c, [
                createElementVNode("div", _hoisted_6$5, [
                  createVNode(_component_RadioGroup, {
                    modelValue: $data.listType,
                    "onUpdate:modelValue": _cache[1] || (_cache[1] = ($event) => $data.listType = $event),
                    type: "button",
                    size: "small"
                  }, {
                    default: withCtx(() => [
                      createVNode(_component_Radio, { label: "province" }, {
                        default: withCtx(() => _cache[4] || (_cache[4] = [
                          createTextVNode("\u6309\u7701\u4EFD")
                        ])),
                        _: 1
                      }),
                      createVNode(_component_Radio, { label: "city" }, {
                        default: withCtx(() => _cache[5] || (_cache[5] = [
                          createTextVNode("\u6309\u57CE\u5E02")
                        ])),
                        _: 1
                      })
                    ]),
                    _: 1
                  }, 8, ["modelValue"])
                ]),
                createElementVNode("div", _hoisted_7$4, [
                  createVNode(_component_Select, {
                    modelValue: $data.queryCity,
                    "onUpdate:modelValue": _cache[2] || (_cache[2] = ($event) => $data.queryCity = $event),
                    filterable: "",
                    size: "small",
                    transfer: "",
                    placeholder: $props.searchPlaceholder,
                    onOnChange: $options.handleSelect
                  }, {
                    default: withCtx(() => [
                      (openBlock(true), createElementBlock(Fragment, null, renderList($data.allCities, (item) => {
                        return openBlock(), createBlock(_component_Option, {
                          value: item.c,
                          key: item.c
                        }, {
                          default: withCtx(() => [
                            createTextVNode(toDisplayString(item.n), 1)
                          ]),
                          _: 2
                        }, 1032, ["value"]);
                      }), 128))
                    ]),
                    _: 1
                  }, 8, ["modelValue", "placeholder", "onOnChange"])
                ])
              ]),
              $data.listType === "province" ? (openBlock(), createElementBlock("div", _hoisted_8$3, [
                createElementVNode("div", _hoisted_9$3, [
                  (openBlock(true), createElementBlock(Fragment, null, renderList($data.provinceList, (item) => {
                    return openBlock(), createBlock(_component_Tag, {
                      onClick: ($event) => $options.handleClickLetter(item.n),
                      type: "border",
                      fade: false,
                      key: item.n
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(item.n), 1)
                      ]),
                      _: 2
                    }, 1032, ["onClick"]);
                  }), 128))
                ]),
                createElementVNode("div", _hoisted_10$3, [
                  createElementVNode("dl", null, [
                    (openBlock(true), createElementBlock(Fragment, null, renderList($data.cityListByProvince, (item) => {
                      return openBlock(), createElementBlock(Fragment, {
                        key: item.p.n
                      }, [
                        createElementVNode("dt", {
                          class: normalizeClass("ivu-city-" + item.p.l)
                        }, toDisplayString(item.p.n) + "\uFF1A", 3),
                        createElementVNode("dd", null, [
                          (openBlock(true), createElementBlock(Fragment, null, renderList(item.c, (city) => {
                            return openBlock(), createElementBlock("li", {
                              key: city.n,
                              onClick: ($event) => $options.handleChangeValue(city.c)
                            }, toDisplayString(city.n), 9, _hoisted_11$3);
                          }), 128))
                        ])
                      ], 64);
                    }), 128))
                  ])
                ], 512)
              ])) : createCommentVNode("", true),
              $data.listType === "city" ? (openBlock(), createElementBlock("div", _hoisted_12$2, [
                createElementVNode("div", _hoisted_13$1, [
                  (openBlock(true), createElementBlock(Fragment, null, renderList($data.cityListByLetter, (item, key2) => {
                    return openBlock(), createBlock(_component_Tag, {
                      onClick: ($event) => $options.handleClickLetter(key2),
                      type: "border",
                      fade: false,
                      key: key2
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(key2), 1)
                      ]),
                      _: 2
                    }, 1032, ["onClick"]);
                  }), 128))
                ]),
                createElementVNode("div", _hoisted_14$1, [
                  createElementVNode("dl", null, [
                    (openBlock(true), createElementBlock(Fragment, null, renderList($data.cityListByLetter, (item, key2) => {
                      return openBlock(), createElementBlock(Fragment, { key: key2 }, [
                        createElementVNode("dt", {
                          class: normalizeClass("ivu-city-" + key2)
                        }, toDisplayString(key2) + "\uFF1A", 3),
                        createElementVNode("dd", null, [
                          (openBlock(true), createElementBlock(Fragment, null, renderList(item, (city) => {
                            return openBlock(), createElementBlock("li", {
                              key: city.n,
                              onClick: ($event) => $options.handleChangeValue(city.c)
                            }, toDisplayString(city.n), 9, _hoisted_15$1);
                          }), 128))
                        ])
                      ], 64);
                    }), 128))
                  ])
                ], 512)
              ])) : createCommentVNode("", true)
            ])
          ]),
          _: 1
        })
      ]),
      default: withCtx(() => [
        createElementVNode("div", {
          class: "ivu-city-rel",
          onClick: _cache[0] || (_cache[0] = withModifiers((...args) => $options.handleToggleOpen && $options.handleToggleOpen(...args), ["prevent", "stop"]))
        }, [
          createElementVNode("input", {
            type: "hidden",
            name: $props.name,
            value: $data.currentValue
          }, null, 8, _hoisted_1$U),
          renderSlot(_ctx.$slots, "default", {}, () => [
            createElementVNode("span", null, toDisplayString($options.codeToName), 1),
            withDirectives(createVNode(_component_Icon, {
              type: "ios-close-circle",
              class: "ivu-city-arrow",
              onClick: withModifiers($options.clearSelect, ["stop"])
            }, null, 8, ["onClick"]), [
              [vShow, $options.showCloseIcon]
            ]),
            createVNode(_component_Icon, {
              type: "ios-arrow-down",
              class: "ivu-city-arrow"
            })
          ])
        ])
      ]),
      _: 3
    }, 8, ["visible", "transfer", "transfer-class-name", "onOnVisibleChange", "onOnClickoutside"])
  ], 2);
}
var City = /* @__PURE__ */ _export_sfc(_sfc_main$1O, [["render", _sfc_render$1A]]);
const prefixCls$V = "ivu-collapse";
const _sfc_main$1N = {
  name: "Collapse",
  emits: ["on-change", "update:modelValue"],
  provide() {
    return {
      CollapseInstance: this
    };
  },
  props: {
    accordion: {
      type: Boolean,
      default: false
    },
    modelValue: {
      type: [Array, String]
    },
    simple: {
      type: Boolean,
      default: false
    }
  },
  data() {
    return {
      currentValue: this.modelValue,
      panelCount: 0
    };
  },
  computed: {
    classes() {
      return [
        `${prefixCls$V}`,
        {
          [`${prefixCls$V}-simple`]: this.simple
        }
      ];
    }
  },
  methods: {
    getActiveKey() {
      let activeKey = this.currentValue || [];
      const accordion = this.accordion;
      if (!Array.isArray(activeKey)) {
        activeKey = [activeKey];
      }
      if (accordion && activeKey.length > 1) {
        activeKey = [activeKey[0]];
      }
      for (let i = 0; i < activeKey.length; i++) {
        activeKey[i] = activeKey[i].toString();
      }
      return activeKey;
    },
    toggle(data) {
      const name2 = data.name.toString();
      let newActiveKey = [];
      if (this.accordion) {
        if (!data.isActive) {
          newActiveKey.push(name2);
        }
      } else {
        let activeKey = this.getActiveKey();
        const nameIndex = activeKey.indexOf(name2);
        if (data.isActive) {
          if (nameIndex > -1) {
            activeKey.splice(nameIndex, 1);
          }
        } else {
          if (nameIndex < 0) {
            activeKey.push(name2);
          }
        }
        newActiveKey = activeKey;
      }
      this.currentValue = newActiveKey;
      this.$emit("update:modelValue", newActiveKey);
      this.$emit("on-change", newActiveKey);
    }
  },
  watch: {
    modelValue(val) {
      this.currentValue = val;
    }
  }
};
function _sfc_render$1z(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes)
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 2);
}
var Collapse = /* @__PURE__ */ _export_sfc(_sfc_main$1N, [["render", _sfc_render$1z]]);
function _typeof(obj) {
  "@babel/helpers - typeof";
  return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof(obj);
}
var trimLeft = /^\s+/;
var trimRight = /\s+$/;
function tinycolor(color2, opts) {
  color2 = color2 ? color2 : "";
  opts = opts || {};
  if (color2 instanceof tinycolor) {
    return color2;
  }
  if (!(this instanceof tinycolor)) {
    return new tinycolor(color2, opts);
  }
  var rgb = inputToRGB(color2);
  this._originalInput = color2, this._r = rgb.r, this._g = rgb.g, this._b = rgb.b, this._a = rgb.a, this._roundA = Math.round(100 * this._a) / 100, this._format = opts.format || rgb.format;
  this._gradientType = opts.gradientType;
  if (this._r < 1)
    this._r = Math.round(this._r);
  if (this._g < 1)
    this._g = Math.round(this._g);
  if (this._b < 1)
    this._b = Math.round(this._b);
  this._ok = rgb.ok;
}
tinycolor.prototype = {
  isDark: function isDark() {
    return this.getBrightness() < 128;
  },
  isLight: function isLight() {
    return !this.isDark();
  },
  isValid: function isValid() {
    return this._ok;
  },
  getOriginalInput: function getOriginalInput() {
    return this._originalInput;
  },
  getFormat: function getFormat() {
    return this._format;
  },
  getAlpha: function getAlpha() {
    return this._a;
  },
  getBrightness: function getBrightness() {
    var rgb = this.toRgb();
    return (rgb.r * 299 + rgb.g * 587 + rgb.b * 114) / 1e3;
  },
  getLuminance: function getLuminance() {
    var rgb = this.toRgb();
    var RsRGB, GsRGB, BsRGB, R, G, B;
    RsRGB = rgb.r / 255;
    GsRGB = rgb.g / 255;
    BsRGB = rgb.b / 255;
    if (RsRGB <= 0.03928)
      R = RsRGB / 12.92;
    else
      R = Math.pow((RsRGB + 0.055) / 1.055, 2.4);
    if (GsRGB <= 0.03928)
      G = GsRGB / 12.92;
    else
      G = Math.pow((GsRGB + 0.055) / 1.055, 2.4);
    if (BsRGB <= 0.03928)
      B = BsRGB / 12.92;
    else
      B = Math.pow((BsRGB + 0.055) / 1.055, 2.4);
    return 0.2126 * R + 0.7152 * G + 0.0722 * B;
  },
  setAlpha: function setAlpha(value) {
    this._a = boundAlpha(value);
    this._roundA = Math.round(100 * this._a) / 100;
    return this;
  },
  toHsv: function toHsv() {
    var hsv = rgbToHsv(this._r, this._g, this._b);
    return {
      h: hsv.h * 360,
      s: hsv.s,
      v: hsv.v,
      a: this._a
    };
  },
  toHsvString: function toHsvString() {
    var hsv = rgbToHsv(this._r, this._g, this._b);
    var h2 = Math.round(hsv.h * 360), s = Math.round(hsv.s * 100), v = Math.round(hsv.v * 100);
    return this._a == 1 ? "hsv(" + h2 + ", " + s + "%, " + v + "%)" : "hsva(" + h2 + ", " + s + "%, " + v + "%, " + this._roundA + ")";
  },
  toHsl: function toHsl() {
    var hsl = rgbToHsl(this._r, this._g, this._b);
    return {
      h: hsl.h * 360,
      s: hsl.s,
      l: hsl.l,
      a: this._a
    };
  },
  toHslString: function toHslString() {
    var hsl = rgbToHsl(this._r, this._g, this._b);
    var h2 = Math.round(hsl.h * 360), s = Math.round(hsl.s * 100), l = Math.round(hsl.l * 100);
    return this._a == 1 ? "hsl(" + h2 + ", " + s + "%, " + l + "%)" : "hsla(" + h2 + ", " + s + "%, " + l + "%, " + this._roundA + ")";
  },
  toHex: function toHex(allow3Char) {
    return rgbToHex(this._r, this._g, this._b, allow3Char);
  },
  toHexString: function toHexString(allow3Char) {
    return "#" + this.toHex(allow3Char);
  },
  toHex8: function toHex8(allow4Char) {
    return rgbaToHex(this._r, this._g, this._b, this._a, allow4Char);
  },
  toHex8String: function toHex8String(allow4Char) {
    return "#" + this.toHex8(allow4Char);
  },
  toRgb: function toRgb() {
    return {
      r: Math.round(this._r),
      g: Math.round(this._g),
      b: Math.round(this._b),
      a: this._a
    };
  },
  toRgbString: function toRgbString() {
    return this._a == 1 ? "rgb(" + Math.round(this._r) + ", " + Math.round(this._g) + ", " + Math.round(this._b) + ")" : "rgba(" + Math.round(this._r) + ", " + Math.round(this._g) + ", " + Math.round(this._b) + ", " + this._roundA + ")";
  },
  toPercentageRgb: function toPercentageRgb() {
    return {
      r: Math.round(bound01(this._r, 255) * 100) + "%",
      g: Math.round(bound01(this._g, 255) * 100) + "%",
      b: Math.round(bound01(this._b, 255) * 100) + "%",
      a: this._a
    };
  },
  toPercentageRgbString: function toPercentageRgbString() {
    return this._a == 1 ? "rgb(" + Math.round(bound01(this._r, 255) * 100) + "%, " + Math.round(bound01(this._g, 255) * 100) + "%, " + Math.round(bound01(this._b, 255) * 100) + "%)" : "rgba(" + Math.round(bound01(this._r, 255) * 100) + "%, " + Math.round(bound01(this._g, 255) * 100) + "%, " + Math.round(bound01(this._b, 255) * 100) + "%, " + this._roundA + ")";
  },
  toName: function toName() {
    if (this._a === 0) {
      return "transparent";
    }
    if (this._a < 1) {
      return false;
    }
    return hexNames[rgbToHex(this._r, this._g, this._b, true)] || false;
  },
  toFilter: function toFilter(secondColor) {
    var hex8String = "#" + rgbaToArgbHex(this._r, this._g, this._b, this._a);
    var secondHex8String = hex8String;
    var gradientType = this._gradientType ? "GradientType = 1, " : "";
    if (secondColor) {
      var s = tinycolor(secondColor);
      secondHex8String = "#" + rgbaToArgbHex(s._r, s._g, s._b, s._a);
    }
    return "progid:DXImageTransform.Microsoft.gradient(" + gradientType + "startColorstr=" + hex8String + ",endColorstr=" + secondHex8String + ")";
  },
  toString: function toString(format2) {
    var formatSet = !!format2;
    format2 = format2 || this._format;
    var formattedString = false;
    var hasAlpha = this._a < 1 && this._a >= 0;
    var needsAlphaFormat = !formatSet && hasAlpha && (format2 === "hex" || format2 === "hex6" || format2 === "hex3" || format2 === "hex4" || format2 === "hex8" || format2 === "name");
    if (needsAlphaFormat) {
      if (format2 === "name" && this._a === 0) {
        return this.toName();
      }
      return this.toRgbString();
    }
    if (format2 === "rgb") {
      formattedString = this.toRgbString();
    }
    if (format2 === "prgb") {
      formattedString = this.toPercentageRgbString();
    }
    if (format2 === "hex" || format2 === "hex6") {
      formattedString = this.toHexString();
    }
    if (format2 === "hex3") {
      formattedString = this.toHexString(true);
    }
    if (format2 === "hex4") {
      formattedString = this.toHex8String(true);
    }
    if (format2 === "hex8") {
      formattedString = this.toHex8String();
    }
    if (format2 === "name") {
      formattedString = this.toName();
    }
    if (format2 === "hsl") {
      formattedString = this.toHslString();
    }
    if (format2 === "hsv") {
      formattedString = this.toHsvString();
    }
    return formattedString || this.toHexString();
  },
  clone: function clone() {
    return tinycolor(this.toString());
  },
  _applyModification: function _applyModification(fn, args) {
    var color2 = fn.apply(null, [this].concat([].slice.call(args)));
    this._r = color2._r;
    this._g = color2._g;
    this._b = color2._b;
    this.setAlpha(color2._a);
    return this;
  },
  lighten: function lighten() {
    return this._applyModification(_lighten, arguments);
  },
  brighten: function brighten() {
    return this._applyModification(_brighten, arguments);
  },
  darken: function darken() {
    return this._applyModification(_darken, arguments);
  },
  desaturate: function desaturate() {
    return this._applyModification(_desaturate, arguments);
  },
  saturate: function saturate() {
    return this._applyModification(_saturate, arguments);
  },
  greyscale: function greyscale() {
    return this._applyModification(_greyscale, arguments);
  },
  spin: function spin() {
    return this._applyModification(_spin, arguments);
  },
  _applyCombination: function _applyCombination(fn, args) {
    return fn.apply(null, [this].concat([].slice.call(args)));
  },
  analogous: function analogous() {
    return this._applyCombination(_analogous, arguments);
  },
  complement: function complement() {
    return this._applyCombination(_complement, arguments);
  },
  monochromatic: function monochromatic() {
    return this._applyCombination(_monochromatic, arguments);
  },
  splitcomplement: function splitcomplement() {
    return this._applyCombination(_splitcomplement, arguments);
  },
  triad: function triad() {
    return this._applyCombination(polyad, [3]);
  },
  tetrad: function tetrad() {
    return this._applyCombination(polyad, [4]);
  }
};
tinycolor.fromRatio = function(color2, opts) {
  if (_typeof(color2) == "object") {
    var newColor = {};
    for (var i in color2) {
      if (color2.hasOwnProperty(i)) {
        if (i === "a") {
          newColor[i] = color2[i];
        } else {
          newColor[i] = convertToPercentage(color2[i]);
        }
      }
    }
    color2 = newColor;
  }
  return tinycolor(color2, opts);
};
function inputToRGB(color2) {
  var rgb = {
    r: 0,
    g: 0,
    b: 0
  };
  var a = 1;
  var s = null;
  var v = null;
  var l = null;
  var ok = false;
  var format2 = false;
  if (typeof color2 == "string") {
    color2 = stringInputToObject(color2);
  }
  if (_typeof(color2) == "object") {
    if (isValidCSSUnit(color2.r) && isValidCSSUnit(color2.g) && isValidCSSUnit(color2.b)) {
      rgb = rgbToRgb(color2.r, color2.g, color2.b);
      ok = true;
      format2 = String(color2.r).substr(-1) === "%" ? "prgb" : "rgb";
    } else if (isValidCSSUnit(color2.h) && isValidCSSUnit(color2.s) && isValidCSSUnit(color2.v)) {
      s = convertToPercentage(color2.s);
      v = convertToPercentage(color2.v);
      rgb = hsvToRgb(color2.h, s, v);
      ok = true;
      format2 = "hsv";
    } else if (isValidCSSUnit(color2.h) && isValidCSSUnit(color2.s) && isValidCSSUnit(color2.l)) {
      s = convertToPercentage(color2.s);
      l = convertToPercentage(color2.l);
      rgb = hslToRgb(color2.h, s, l);
      ok = true;
      format2 = "hsl";
    }
    if (color2.hasOwnProperty("a")) {
      a = color2.a;
    }
  }
  a = boundAlpha(a);
  return {
    ok,
    format: color2.format || format2,
    r: Math.min(255, Math.max(rgb.r, 0)),
    g: Math.min(255, Math.max(rgb.g, 0)),
    b: Math.min(255, Math.max(rgb.b, 0)),
    a
  };
}
function rgbToRgb(r, g, b) {
  return {
    r: bound01(r, 255) * 255,
    g: bound01(g, 255) * 255,
    b: bound01(b, 255) * 255
  };
}
function rgbToHsl(r, g, b) {
  r = bound01(r, 255);
  g = bound01(g, 255);
  b = bound01(b, 255);
  var max = Math.max(r, g, b), min = Math.min(r, g, b);
  var h2, s, l = (max + min) / 2;
  if (max == min) {
    h2 = s = 0;
  } else {
    var d = max - min;
    s = l > 0.5 ? d / (2 - max - min) : d / (max + min);
    switch (max) {
      case r:
        h2 = (g - b) / d + (g < b ? 6 : 0);
        break;
      case g:
        h2 = (b - r) / d + 2;
        break;
      case b:
        h2 = (r - g) / d + 4;
        break;
    }
    h2 /= 6;
  }
  return {
    h: h2,
    s,
    l
  };
}
function hslToRgb(h2, s, l) {
  var r, g, b;
  h2 = bound01(h2, 360);
  s = bound01(s, 100);
  l = bound01(l, 100);
  function hue2rgb(p2, q2, t2) {
    if (t2 < 0)
      t2 += 1;
    if (t2 > 1)
      t2 -= 1;
    if (t2 < 1 / 6)
      return p2 + (q2 - p2) * 6 * t2;
    if (t2 < 1 / 2)
      return q2;
    if (t2 < 2 / 3)
      return p2 + (q2 - p2) * (2 / 3 - t2) * 6;
    return p2;
  }
  if (s === 0) {
    r = g = b = l;
  } else {
    var q = l < 0.5 ? l * (1 + s) : l + s - l * s;
    var p = 2 * l - q;
    r = hue2rgb(p, q, h2 + 1 / 3);
    g = hue2rgb(p, q, h2);
    b = hue2rgb(p, q, h2 - 1 / 3);
  }
  return {
    r: r * 255,
    g: g * 255,
    b: b * 255
  };
}
function rgbToHsv(r, g, b) {
  r = bound01(r, 255);
  g = bound01(g, 255);
  b = bound01(b, 255);
  var max = Math.max(r, g, b), min = Math.min(r, g, b);
  var h2, s, v = max;
  var d = max - min;
  s = max === 0 ? 0 : d / max;
  if (max == min) {
    h2 = 0;
  } else {
    switch (max) {
      case r:
        h2 = (g - b) / d + (g < b ? 6 : 0);
        break;
      case g:
        h2 = (b - r) / d + 2;
        break;
      case b:
        h2 = (r - g) / d + 4;
        break;
    }
    h2 /= 6;
  }
  return {
    h: h2,
    s,
    v
  };
}
function hsvToRgb(h2, s, v) {
  h2 = bound01(h2, 360) * 6;
  s = bound01(s, 100);
  v = bound01(v, 100);
  var i = Math.floor(h2), f = h2 - i, p = v * (1 - s), q = v * (1 - f * s), t2 = v * (1 - (1 - f) * s), mod = i % 6, r = [v, q, p, p, t2, v][mod], g = [t2, v, v, q, p, p][mod], b = [p, p, t2, v, v, q][mod];
  return {
    r: r * 255,
    g: g * 255,
    b: b * 255
  };
}
function rgbToHex(r, g, b, allow3Char) {
  var hex2 = [pad2(Math.round(r).toString(16)), pad2(Math.round(g).toString(16)), pad2(Math.round(b).toString(16))];
  if (allow3Char && hex2[0].charAt(0) == hex2[0].charAt(1) && hex2[1].charAt(0) == hex2[1].charAt(1) && hex2[2].charAt(0) == hex2[2].charAt(1)) {
    return hex2[0].charAt(0) + hex2[1].charAt(0) + hex2[2].charAt(0);
  }
  return hex2.join("");
}
function rgbaToHex(r, g, b, a, allow4Char) {
  var hex2 = [pad2(Math.round(r).toString(16)), pad2(Math.round(g).toString(16)), pad2(Math.round(b).toString(16)), pad2(convertDecimalToHex(a))];
  if (allow4Char && hex2[0].charAt(0) == hex2[0].charAt(1) && hex2[1].charAt(0) == hex2[1].charAt(1) && hex2[2].charAt(0) == hex2[2].charAt(1) && hex2[3].charAt(0) == hex2[3].charAt(1)) {
    return hex2[0].charAt(0) + hex2[1].charAt(0) + hex2[2].charAt(0) + hex2[3].charAt(0);
  }
  return hex2.join("");
}
function rgbaToArgbHex(r, g, b, a) {
  var hex2 = [pad2(convertDecimalToHex(a)), pad2(Math.round(r).toString(16)), pad2(Math.round(g).toString(16)), pad2(Math.round(b).toString(16))];
  return hex2.join("");
}
tinycolor.equals = function(color1, color2) {
  if (!color1 || !color2)
    return false;
  return tinycolor(color1).toRgbString() == tinycolor(color2).toRgbString();
};
tinycolor.random = function() {
  return tinycolor.fromRatio({
    r: Math.random(),
    g: Math.random(),
    b: Math.random()
  });
};
function _desaturate(color2, amount) {
  amount = amount === 0 ? 0 : amount || 10;
  var hsl = tinycolor(color2).toHsl();
  hsl.s -= amount / 100;
  hsl.s = clamp01(hsl.s);
  return tinycolor(hsl);
}
function _saturate(color2, amount) {
  amount = amount === 0 ? 0 : amount || 10;
  var hsl = tinycolor(color2).toHsl();
  hsl.s += amount / 100;
  hsl.s = clamp01(hsl.s);
  return tinycolor(hsl);
}
function _greyscale(color2) {
  return tinycolor(color2).desaturate(100);
}
function _lighten(color2, amount) {
  amount = amount === 0 ? 0 : amount || 10;
  var hsl = tinycolor(color2).toHsl();
  hsl.l += amount / 100;
  hsl.l = clamp01(hsl.l);
  return tinycolor(hsl);
}
function _brighten(color2, amount) {
  amount = amount === 0 ? 0 : amount || 10;
  var rgb = tinycolor(color2).toRgb();
  rgb.r = Math.max(0, Math.min(255, rgb.r - Math.round(255 * -(amount / 100))));
  rgb.g = Math.max(0, Math.min(255, rgb.g - Math.round(255 * -(amount / 100))));
  rgb.b = Math.max(0, Math.min(255, rgb.b - Math.round(255 * -(amount / 100))));
  return tinycolor(rgb);
}
function _darken(color2, amount) {
  amount = amount === 0 ? 0 : amount || 10;
  var hsl = tinycolor(color2).toHsl();
  hsl.l -= amount / 100;
  hsl.l = clamp01(hsl.l);
  return tinycolor(hsl);
}
function _spin(color2, amount) {
  var hsl = tinycolor(color2).toHsl();
  var hue = (hsl.h + amount) % 360;
  hsl.h = hue < 0 ? 360 + hue : hue;
  return tinycolor(hsl);
}
function _complement(color2) {
  var hsl = tinycolor(color2).toHsl();
  hsl.h = (hsl.h + 180) % 360;
  return tinycolor(hsl);
}
function polyad(color2, number3) {
  if (isNaN(number3) || number3 <= 0) {
    throw new Error("Argument to polyad must be a positive number");
  }
  var hsl = tinycolor(color2).toHsl();
  var result = [tinycolor(color2)];
  var step = 360 / number3;
  for (var i = 1; i < number3; i++) {
    result.push(tinycolor({
      h: (hsl.h + i * step) % 360,
      s: hsl.s,
      l: hsl.l
    }));
  }
  return result;
}
function _splitcomplement(color2) {
  var hsl = tinycolor(color2).toHsl();
  var h2 = hsl.h;
  return [tinycolor(color2), tinycolor({
    h: (h2 + 72) % 360,
    s: hsl.s,
    l: hsl.l
  }), tinycolor({
    h: (h2 + 216) % 360,
    s: hsl.s,
    l: hsl.l
  })];
}
function _analogous(color2, results, slices) {
  results = results || 6;
  slices = slices || 30;
  var hsl = tinycolor(color2).toHsl();
  var part = 360 / slices;
  var ret = [tinycolor(color2)];
  for (hsl.h = (hsl.h - (part * results >> 1) + 720) % 360; --results; ) {
    hsl.h = (hsl.h + part) % 360;
    ret.push(tinycolor(hsl));
  }
  return ret;
}
function _monochromatic(color2, results) {
  results = results || 6;
  var hsv = tinycolor(color2).toHsv();
  var h2 = hsv.h, s = hsv.s, v = hsv.v;
  var ret = [];
  var modification = 1 / results;
  while (results--) {
    ret.push(tinycolor({
      h: h2,
      s,
      v
    }));
    v = (v + modification) % 1;
  }
  return ret;
}
tinycolor.mix = function(color1, color2, amount) {
  amount = amount === 0 ? 0 : amount || 50;
  var rgb1 = tinycolor(color1).toRgb();
  var rgb2 = tinycolor(color2).toRgb();
  var p = amount / 100;
  var rgba = {
    r: (rgb2.r - rgb1.r) * p + rgb1.r,
    g: (rgb2.g - rgb1.g) * p + rgb1.g,
    b: (rgb2.b - rgb1.b) * p + rgb1.b,
    a: (rgb2.a - rgb1.a) * p + rgb1.a
  };
  return tinycolor(rgba);
};
tinycolor.readability = function(color1, color2) {
  var c1 = tinycolor(color1);
  var c2 = tinycolor(color2);
  return (Math.max(c1.getLuminance(), c2.getLuminance()) + 0.05) / (Math.min(c1.getLuminance(), c2.getLuminance()) + 0.05);
};
tinycolor.isReadable = function(color1, color2, wcag2) {
  var readability = tinycolor.readability(color1, color2);
  var wcag2Parms, out;
  out = false;
  wcag2Parms = validateWCAG2Parms(wcag2);
  switch (wcag2Parms.level + wcag2Parms.size) {
    case "AAsmall":
    case "AAAlarge":
      out = readability >= 4.5;
      break;
    case "AAlarge":
      out = readability >= 3;
      break;
    case "AAAsmall":
      out = readability >= 7;
      break;
  }
  return out;
};
tinycolor.mostReadable = function(baseColor, colorList2, args) {
  var bestColor = null;
  var bestScore = 0;
  var readability;
  var includeFallbackColors, level, size;
  args = args || {};
  includeFallbackColors = args.includeFallbackColors;
  level = args.level;
  size = args.size;
  for (var i = 0; i < colorList2.length; i++) {
    readability = tinycolor.readability(baseColor, colorList2[i]);
    if (readability > bestScore) {
      bestScore = readability;
      bestColor = tinycolor(colorList2[i]);
    }
  }
  if (tinycolor.isReadable(baseColor, bestColor, {
    level,
    size
  }) || !includeFallbackColors) {
    return bestColor;
  } else {
    args.includeFallbackColors = false;
    return tinycolor.mostReadable(baseColor, ["#fff", "#000"], args);
  }
};
var names = tinycolor.names = {
  aliceblue: "f0f8ff",
  antiquewhite: "faebd7",
  aqua: "0ff",
  aquamarine: "7fffd4",
  azure: "f0ffff",
  beige: "f5f5dc",
  bisque: "ffe4c4",
  black: "000",
  blanchedalmond: "ffebcd",
  blue: "00f",
  blueviolet: "8a2be2",
  brown: "a52a2a",
  burlywood: "deb887",
  burntsienna: "ea7e5d",
  cadetblue: "5f9ea0",
  chartreuse: "7fff00",
  chocolate: "d2691e",
  coral: "ff7f50",
  cornflowerblue: "6495ed",
  cornsilk: "fff8dc",
  crimson: "dc143c",
  cyan: "0ff",
  darkblue: "00008b",
  darkcyan: "008b8b",
  darkgoldenrod: "b8860b",
  darkgray: "a9a9a9",
  darkgreen: "006400",
  darkgrey: "a9a9a9",
  darkkhaki: "bdb76b",
  darkmagenta: "8b008b",
  darkolivegreen: "556b2f",
  darkorange: "ff8c00",
  darkorchid: "9932cc",
  darkred: "8b0000",
  darksalmon: "e9967a",
  darkseagreen: "8fbc8f",
  darkslateblue: "483d8b",
  darkslategray: "2f4f4f",
  darkslategrey: "2f4f4f",
  darkturquoise: "00ced1",
  darkviolet: "9400d3",
  deeppink: "ff1493",
  deepskyblue: "00bfff",
  dimgray: "696969",
  dimgrey: "696969",
  dodgerblue: "1e90ff",
  firebrick: "b22222",
  floralwhite: "fffaf0",
  forestgreen: "228b22",
  fuchsia: "f0f",
  gainsboro: "dcdcdc",
  ghostwhite: "f8f8ff",
  gold: "ffd700",
  goldenrod: "daa520",
  gray: "808080",
  green: "008000",
  greenyellow: "adff2f",
  grey: "808080",
  honeydew: "f0fff0",
  hotpink: "ff69b4",
  indianred: "cd5c5c",
  indigo: "4b0082",
  ivory: "fffff0",
  khaki: "f0e68c",
  lavender: "e6e6fa",
  lavenderblush: "fff0f5",
  lawngreen: "7cfc00",
  lemonchiffon: "fffacd",
  lightblue: "add8e6",
  lightcoral: "f08080",
  lightcyan: "e0ffff",
  lightgoldenrodyellow: "fafad2",
  lightgray: "d3d3d3",
  lightgreen: "90ee90",
  lightgrey: "d3d3d3",
  lightpink: "ffb6c1",
  lightsalmon: "ffa07a",
  lightseagreen: "20b2aa",
  lightskyblue: "87cefa",
  lightslategray: "789",
  lightslategrey: "789",
  lightsteelblue: "b0c4de",
  lightyellow: "ffffe0",
  lime: "0f0",
  limegreen: "32cd32",
  linen: "faf0e6",
  magenta: "f0f",
  maroon: "800000",
  mediumaquamarine: "66cdaa",
  mediumblue: "0000cd",
  mediumorchid: "ba55d3",
  mediumpurple: "9370db",
  mediumseagreen: "3cb371",
  mediumslateblue: "7b68ee",
  mediumspringgreen: "00fa9a",
  mediumturquoise: "48d1cc",
  mediumvioletred: "c71585",
  midnightblue: "191970",
  mintcream: "f5fffa",
  mistyrose: "ffe4e1",
  moccasin: "ffe4b5",
  navajowhite: "ffdead",
  navy: "000080",
  oldlace: "fdf5e6",
  olive: "808000",
  olivedrab: "6b8e23",
  orange: "ffa500",
  orangered: "ff4500",
  orchid: "da70d6",
  palegoldenrod: "eee8aa",
  palegreen: "98fb98",
  paleturquoise: "afeeee",
  palevioletred: "db7093",
  papayawhip: "ffefd5",
  peachpuff: "ffdab9",
  peru: "cd853f",
  pink: "ffc0cb",
  plum: "dda0dd",
  powderblue: "b0e0e6",
  purple: "800080",
  rebeccapurple: "663399",
  red: "f00",
  rosybrown: "bc8f8f",
  royalblue: "4169e1",
  saddlebrown: "8b4513",
  salmon: "fa8072",
  sandybrown: "f4a460",
  seagreen: "2e8b57",
  seashell: "fff5ee",
  sienna: "a0522d",
  silver: "c0c0c0",
  skyblue: "87ceeb",
  slateblue: "6a5acd",
  slategray: "708090",
  slategrey: "708090",
  snow: "fffafa",
  springgreen: "00ff7f",
  steelblue: "4682b4",
  tan: "d2b48c",
  teal: "008080",
  thistle: "d8bfd8",
  tomato: "ff6347",
  turquoise: "40e0d0",
  violet: "ee82ee",
  wheat: "f5deb3",
  white: "fff",
  whitesmoke: "f5f5f5",
  yellow: "ff0",
  yellowgreen: "9acd32"
};
var hexNames = tinycolor.hexNames = flip(names);
function flip(o) {
  var flipped = {};
  for (var i in o) {
    if (o.hasOwnProperty(i)) {
      flipped[o[i]] = i;
    }
  }
  return flipped;
}
function boundAlpha(a) {
  a = parseFloat(a);
  if (isNaN(a) || a < 0 || a > 1) {
    a = 1;
  }
  return a;
}
function bound01(n, max) {
  if (isOnePointZero(n))
    n = "100%";
  var processPercent = isPercentage(n);
  n = Math.min(max, Math.max(0, parseFloat(n)));
  if (processPercent) {
    n = parseInt(n * max, 10) / 100;
  }
  if (Math.abs(n - max) < 1e-6) {
    return 1;
  }
  return n % max / parseFloat(max);
}
function clamp01(val) {
  return Math.min(1, Math.max(0, val));
}
function parseIntFromHex(val) {
  return parseInt(val, 16);
}
function isOnePointZero(n) {
  return typeof n == "string" && n.indexOf(".") != -1 && parseFloat(n) === 1;
}
function isPercentage(n) {
  return typeof n === "string" && n.indexOf("%") != -1;
}
function pad2(c) {
  return c.length == 1 ? "0" + c : "" + c;
}
function convertToPercentage(n) {
  if (n <= 1) {
    n = n * 100 + "%";
  }
  return n;
}
function convertDecimalToHex(d) {
  return Math.round(parseFloat(d) * 255).toString(16);
}
function convertHexToDecimal(h2) {
  return parseIntFromHex(h2) / 255;
}
var matchers = function() {
  var CSS_INTEGER = "[-\\+]?\\d+%?";
  var CSS_NUMBER = "[-\\+]?\\d*\\.\\d+%?";
  var CSS_UNIT = "(?:" + CSS_NUMBER + ")|(?:" + CSS_INTEGER + ")";
  var PERMISSIVE_MATCH3 = "[\\s|\\(]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")\\s*\\)?";
  var PERMISSIVE_MATCH4 = "[\\s|\\(]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")\\s*\\)?";
  return {
    CSS_UNIT: new RegExp(CSS_UNIT),
    rgb: new RegExp("rgb" + PERMISSIVE_MATCH3),
    rgba: new RegExp("rgba" + PERMISSIVE_MATCH4),
    hsl: new RegExp("hsl" + PERMISSIVE_MATCH3),
    hsla: new RegExp("hsla" + PERMISSIVE_MATCH4),
    hsv: new RegExp("hsv" + PERMISSIVE_MATCH3),
    hsva: new RegExp("hsva" + PERMISSIVE_MATCH4),
    hex3: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,
    hex6: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,
    hex4: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,
    hex8: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/
  };
}();
function isValidCSSUnit(color2) {
  return !!matchers.CSS_UNIT.exec(color2);
}
function stringInputToObject(color2) {
  color2 = color2.replace(trimLeft, "").replace(trimRight, "").toLowerCase();
  var named = false;
  if (names[color2]) {
    color2 = names[color2];
    named = true;
  } else if (color2 == "transparent") {
    return {
      r: 0,
      g: 0,
      b: 0,
      a: 0,
      format: "name"
    };
  }
  var match;
  if (match = matchers.rgb.exec(color2)) {
    return {
      r: match[1],
      g: match[2],
      b: match[3]
    };
  }
  if (match = matchers.rgba.exec(color2)) {
    return {
      r: match[1],
      g: match[2],
      b: match[3],
      a: match[4]
    };
  }
  if (match = matchers.hsl.exec(color2)) {
    return {
      h: match[1],
      s: match[2],
      l: match[3]
    };
  }
  if (match = matchers.hsla.exec(color2)) {
    return {
      h: match[1],
      s: match[2],
      l: match[3],
      a: match[4]
    };
  }
  if (match = matchers.hsv.exec(color2)) {
    return {
      h: match[1],
      s: match[2],
      v: match[3]
    };
  }
  if (match = matchers.hsva.exec(color2)) {
    return {
      h: match[1],
      s: match[2],
      v: match[3],
      a: match[4]
    };
  }
  if (match = matchers.hex8.exec(color2)) {
    return {
      r: parseIntFromHex(match[1]),
      g: parseIntFromHex(match[2]),
      b: parseIntFromHex(match[3]),
      a: convertHexToDecimal(match[4]),
      format: named ? "name" : "hex8"
    };
  }
  if (match = matchers.hex6.exec(color2)) {
    return {
      r: parseIntFromHex(match[1]),
      g: parseIntFromHex(match[2]),
      b: parseIntFromHex(match[3]),
      format: named ? "name" : "hex"
    };
  }
  if (match = matchers.hex4.exec(color2)) {
    return {
      r: parseIntFromHex(match[1] + "" + match[1]),
      g: parseIntFromHex(match[2] + "" + match[2]),
      b: parseIntFromHex(match[3] + "" + match[3]),
      a: convertHexToDecimal(match[4] + "" + match[4]),
      format: named ? "name" : "hex8"
    };
  }
  if (match = matchers.hex3.exec(color2)) {
    return {
      r: parseIntFromHex(match[1] + "" + match[1]),
      g: parseIntFromHex(match[2] + "" + match[2]),
      b: parseIntFromHex(match[3] + "" + match[3]),
      format: named ? "name" : "hex"
    };
  }
  return false;
}
function validateWCAG2Parms(parms) {
  var level, size;
  parms = parms || {
    level: "AA",
    size: "small"
  };
  level = (parms.level || "AA").toUpperCase();
  size = (parms.size || "small").toLowerCase();
  if (level !== "AA" && level !== "AAA") {
    level = "AA";
  }
  if (size !== "small" && size !== "large") {
    size = "small";
  }
  return {
    level,
    size
  };
}
var handleEscapeMixin = {
  inject: ["ColorPickerInstance"],
  methods: {
    handleEscape(e) {
      this.ColorPickerInstance.handleOnEscapeKeydown(e);
    }
  }
};
var Prefixes = {
  data() {
    return {
      prefixCls: "ivu-color-picker",
      inputPrefixCls: "ivu-input",
      iconPrefixCls: "ivu-icon",
      transferPrefixCls: "ivu-transfer"
    };
  }
};
function setAlpha2(data, alpha) {
  const color2 = tinycolor(data);
  const { _a } = color2;
  if (_a === void 0 || _a === null) {
    color2.setAlpha(alpha || 1);
  }
  return color2;
}
function getColor(data, colorData) {
  const alpha = colorData && colorData.a;
  if (colorData) {
    if (colorData.hsl) {
      return setAlpha2(colorData.hsl, alpha);
    }
    if (colorData.hex && colorData.hex.length > 0) {
      return setAlpha2(colorData.hex, alpha);
    }
  }
  return setAlpha2(colorData, alpha);
}
function changeColor(data, oldHue) {
  const colorData = data === "" ? "#2d8cf0" : data;
  const color2 = getColor(data, colorData);
  const hsl = color2.toHsl();
  const hsv = color2.toHsv();
  if (hsl.s === 0) {
    hsl.h = colorData.h || colorData.hsl && colorData.hsl.h || oldHue || 0;
    hsv.h = hsl.h;
  }
  if (hsv.v < 0.0164) {
    hsv.h = colorData.h || colorData.hsv && colorData.hsv.h || 0;
    hsv.s = colorData.s || colorData.hsv && colorData.hsv.s || 0;
  }
  if (hsl.l < 0.01) {
    hsl.h = colorData.h || colorData.hsl && colorData.hsl.h || 0;
    hsl.s = colorData.s || colorData.hsl && colorData.hsl.s || 0;
  }
  return {
    hsl,
    hex: color2.toHexString().toUpperCase(),
    rgba: color2.toRgb(),
    hsv,
    oldHue: colorData.h || oldHue || hsl.h,
    source: colorData.source,
    a: colorData.a || color2.getAlpha()
  };
}
function clamp(value, min, max) {
  if (value < min) {
    return min;
  }
  if (value > max) {
    return max;
  }
  return value;
}
function getIncrement(key2, keys, increment) {
  return oneOf(key2, keys) ? increment : 0;
}
function getTouches(e, prop2) {
  return e.touches ? e.touches[0][prop2] : 0;
}
function toRGBAString(rgba) {
  const { r, g, b, a } = rgba;
  return `rgba(${[r, g, b, a].join(",")})`;
}
const _sfc_main$1M = {
  name: "RecommendedColors",
  mixins: [handleEscapeMixin, Prefixes],
  emits: ["picker-color", "change"],
  props: {
    list: {
      type: Array,
      default: void 0
    }
  },
  data() {
    const columns = 12;
    const rows = Math.ceil(this.list.length / columns);
    const normalStep = 1;
    return {
      left: -normalStep,
      right: normalStep,
      up: -normalStep,
      down: normalStep,
      powerKey: "shiftKey",
      grid: { x: 1, y: 1 },
      rows,
      columns
    };
  },
  computed: {
    hideClass() {
      return `${this.prefixCls}-hide`;
    },
    linearIndex() {
      return this.getLinearIndex(this.grid);
    },
    currentCircle() {
      return this.$refs[`color-circle-${this.linearIndex}`][0];
    }
  },
  methods: {
    getLinearIndex(grid) {
      return this.columns * (grid.y - 1) + grid.x - 1;
    },
    getMaxLimit(axis) {
      return axis === "x" ? this.columns : this.rows;
    },
    handleArrow(e, axis, direction) {
      e.preventDefault();
      e.stopPropagation();
      this.blurColor();
      const grid = { ...this.grid };
      if (e[this.powerKey]) {
        if (direction < 0) {
          grid[axis] = 1;
        } else {
          grid[axis] = this.getMaxLimit(axis);
        }
      } else {
        grid[axis] += direction;
      }
      const index2 = this.getLinearIndex(grid);
      if (index2 >= 0 && index2 < this.list.length) {
        this.grid[axis] = clamp(grid[axis], 1, this.getMaxLimit(axis));
      }
      this.focusColor();
    },
    blurColor() {
      this.currentCircle.classList.add(this.hideClass);
    },
    focusColor() {
      this.currentCircle.classList.remove(this.hideClass);
    },
    handleEnter(e) {
      this.handleClick(e, this.currentCircle);
    },
    handleClick(e, circle) {
      e.preventDefault();
      e.stopPropagation();
      this.$refs.reference.focus();
      const target = circle || e.target;
      const colorId = target.dataset.colorId || target.parentElement.dataset.colorId;
      if (colorId) {
        this.blurColor();
        const id = Number(colorId) + 1;
        this.grid.x = id % this.columns || this.columns;
        this.grid.y = Math.ceil(id / this.columns);
        this.focusColor();
        this.$emit("picker-color", this.list[colorId]);
        this.$emit("change", { hex: this.list[colorId], source: "hex" });
      }
    },
    lineBreak(list, index2) {
      if (!index2) {
        return false;
      }
      const nextIndex = index2 + 1;
      return nextIndex < list.length && nextIndex % this.columns === 0;
    }
  }
};
const _hoisted_1$T = ["data-color-id"];
const _hoisted_2$x = { key: 0 };
function _sfc_render$1y(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    ref: "reference",
    tabindex: "0",
    onClick: _cache[0] || (_cache[0] = (...args) => $options.handleClick && $options.handleClick(...args)),
    onKeydown: [
      _cache[1] || (_cache[1] = withKeys((...args) => _ctx.handleEscape && _ctx.handleEscape(...args), ["esc"])),
      _cache[2] || (_cache[2] = withKeys((...args) => $options.handleEnter && $options.handleEnter(...args), ["enter"])),
      _cache[3] || (_cache[3] = withKeys(($event) => $options.handleArrow($event, "x", $data.left), ["left"])),
      _cache[4] || (_cache[4] = withKeys(($event) => $options.handleArrow($event, "x", $data.right), ["right"])),
      _cache[5] || (_cache[5] = withKeys(($event) => $options.handleArrow($event, "y", $data.up), ["up"])),
      _cache[6] || (_cache[6] = withKeys(($event) => $options.handleArrow($event, "y", $data.down), ["down"]))
    ],
    onBlur: _cache[7] || (_cache[7] = (...args) => $options.blurColor && $options.blurColor(...args)),
    onFocus: _cache[8] || (_cache[8] = (...args) => $options.focusColor && $options.focusColor(...args))
  }, [
    (openBlock(true), createElementBlock(Fragment, null, renderList($props.list, (item, index2) => {
      return openBlock(), createElementBlock(Fragment, {
        key: item + ":" + index2
      }, [
        createElementVNode("div", {
          class: normalizeClass([_ctx.prefixCls + "-picker-colors-wrapper"])
        }, [
          createElementVNode("div", { "data-color-id": index2 }, [
            createElementVNode("div", {
              style: normalizeStyle({ background: item }),
              class: normalizeClass([_ctx.prefixCls + "-picker-colors-wrapper-color"])
            }, null, 6),
            createElementVNode("div", {
              ref_for: true,
              ref: "color-circle-" + index2,
              class: normalizeClass([_ctx.prefixCls + "-picker-colors-wrapper-circle", $options.hideClass])
            }, null, 2)
          ], 8, _hoisted_1$T)
        ], 2),
        $options.lineBreak($props.list, index2) ? (openBlock(), createElementBlock("br", _hoisted_2$x)) : createCommentVNode("", true)
      ], 64);
    }), 128))
  ], 544);
}
var RecommendColors = /* @__PURE__ */ _export_sfc(_sfc_main$1M, [["render", _sfc_render$1y]]);
var HSAMixin = {
  mixins: [handleEscapeMixin],
  props: {
    focused: {
      type: Boolean,
      default: false
    },
    value: {
      type: Object,
      default: void 0
    }
  },
  created() {
    if (this.focused) {
      setTimeout(() => this.$el.focus(), 1);
    }
  },
  beforeUnmount() {
    this.unbindEventListeners();
  },
  methods: {
    handleLeft(e) {
      this.handleSlide(e, this.left, "left");
    },
    handleRight(e) {
      this.handleSlide(e, this.right, "right");
    },
    handleUp(e) {
      this.handleSlide(e, this.up, "up");
    },
    handleDown(e) {
      this.handleSlide(e, this.down, "down");
    },
    handleMouseDown(e) {
      this.ColorPickerInstance.handleOnDragging(true);
      this.handleChange(e, true);
      on(window, "mousemove", this.handleChange);
      on(window, "mouseup", this.handleMouseUp);
    },
    handleMouseUp() {
      this.unbindEventListeners();
    },
    unbindEventListeners() {
      off(window, "mousemove", this.handleChange);
      off(window, "mouseup", this.handleMouseUp);
      setTimeout(() => this.ColorPickerInstance.handleOnDragging(false), 1);
    },
    getLeft(e) {
      if (!isClient)
        return;
      const { container } = this.$refs;
      const xOffset = container.getBoundingClientRect().left + window.pageXOffset;
      const pageX = e.pageX || getTouches(e, "PageX");
      return pageX - xOffset;
    },
    getTop(e) {
      if (!isClient)
        return;
      const { container } = this.$refs;
      const yOffset = container.getBoundingClientRect().top + window.pageYOffset;
      const pageY = e.pageY || getTouches(e, "PageY");
      return pageY - yOffset;
    }
  }
};
const _sfc_main$1L = {
  name: "Saturation",
  mixins: [HSAMixin, Prefixes],
  emits: ["change"],
  data() {
    const normalStep = 0.01;
    return {
      left: -normalStep,
      right: normalStep,
      up: normalStep,
      down: -normalStep,
      multiplier: 10,
      powerKey: "shiftKey"
    };
  },
  computed: {
    bgColorStyle() {
      return { background: `hsl(${this.value.hsv.h}, 100%, 50%)` };
    },
    pointerStyle() {
      return { top: `${-(this.value.hsv.v * 100) + 1 + 100}%`, left: `${this.value.hsv.s * 100}%` };
    }
  },
  methods: {
    change(h2, s, v, a) {
      this.$emit("change", { h: h2, s, v, a, source: "hsva" });
    },
    handleSlide(e, direction, key2) {
      e.preventDefault();
      e.stopPropagation();
      const isPowerKey = e[this.powerKey];
      const increment = isPowerKey ? direction * this.multiplier : direction;
      const { h: h2, s, v, a } = this.value.hsv;
      const saturation = clamp(s + getIncrement(key2, ["left", "right"], increment), 0, 1);
      const bright = clamp(v + getIncrement(key2, ["up", "down"], increment), 0, 1);
      this.change(h2, saturation, bright, a);
    },
    handleChange(e) {
      e.preventDefault();
      e.stopPropagation();
      const { clientWidth, clientHeight } = this.$refs.container;
      const left = clamp(this.getLeft(e), 0, clientWidth);
      const top2 = clamp(this.getTop(e), 0, clientHeight);
      const saturation = left / clientWidth;
      const bright = clamp(1 - top2 / clientHeight, 0, 1);
      this.change(this.value.hsv.h, saturation, bright, this.value.hsv.a);
    },
    handleMouseDown(e) {
      HSAMixin.methods.handleMouseDown.call(this, e);
      on(window, "mouseup", this.handleChange);
    },
    unbindEventListeners(e) {
      HSAMixin.methods.unbindEventListeners.call(this, e);
      off(window, "mouseup", this.handleChange);
    }
  }
};
function _sfc_render$1x(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass([_ctx.prefixCls + "-saturation-wrapper"]),
    tabindex: "0",
    onKeydown: [
      _cache[1] || (_cache[1] = withKeys((...args) => _ctx.handleEscape && _ctx.handleEscape(...args), ["esc"])),
      _cache[3] || (_cache[3] = withKeys((...args) => _ctx.handleLeft && _ctx.handleLeft(...args), ["left"])),
      _cache[4] || (_cache[4] = withKeys((...args) => _ctx.handleRight && _ctx.handleRight(...args), ["right"])),
      _cache[5] || (_cache[5] = withKeys((...args) => _ctx.handleUp && _ctx.handleUp(...args), ["up"])),
      _cache[6] || (_cache[6] = withKeys((...args) => _ctx.handleDown && _ctx.handleDown(...args), ["down"]))
    ],
    onClick: _cache[2] || (_cache[2] = ($event) => _ctx.$el.focus())
  }, [
    createElementVNode("div", {
      ref: "container",
      style: normalizeStyle($options.bgColorStyle),
      class: normalizeClass([_ctx.prefixCls + "-saturation"]),
      onMousedown: _cache[0] || (_cache[0] = (...args) => $options.handleMouseDown && $options.handleMouseDown(...args))
    }, [
      createElementVNode("div", {
        class: normalizeClass([_ctx.prefixCls + "-saturation--white"])
      }, null, 2),
      createElementVNode("div", {
        class: normalizeClass([_ctx.prefixCls + "-saturation--black"])
      }, null, 2),
      createElementVNode("div", {
        style: normalizeStyle($options.pointerStyle),
        class: normalizeClass([_ctx.prefixCls + "-saturation-pointer"])
      }, [
        createElementVNode("div", {
          class: normalizeClass([_ctx.prefixCls + "-saturation-circle"])
        }, null, 2)
      ], 6)
    ], 38)
  ], 34);
}
var Saturation = /* @__PURE__ */ _export_sfc(_sfc_main$1L, [["render", _sfc_render$1x]]);
const _sfc_main$1K = {
  name: "Hue",
  mixins: [HSAMixin, Prefixes],
  emits: ["change"],
  data() {
    const normalStep = 1 / 360 * 25;
    const jumpStep = 20 * normalStep;
    return {
      left: -normalStep,
      right: normalStep,
      up: jumpStep,
      down: -jumpStep,
      powerKey: "shiftKey",
      percent: clamp(this.value.hsl.h * 100 / 360, 0, 100)
    };
  },
  watch: {
    value() {
      this.percent = clamp(this.value.hsl.h * 100 / 360, 0, 100);
    }
  },
  methods: {
    change(percent) {
      this.percent = clamp(percent, 0, 100);
      const { h: h2, s, l, a } = this.value.hsl;
      const newHue = clamp(percent / 100 * 360, 0, 360);
      if (h2 !== newHue) {
        this.$emit("change", { h: newHue, s, l, a, source: "hsl" });
      }
    },
    handleSlide(e, direction) {
      e.preventDefault();
      e.stopPropagation();
      if (e[this.powerKey]) {
        this.change(direction < 0 ? 0 : 100);
        return;
      }
      this.change(this.percent + direction);
    },
    handleChange(e) {
      e.preventDefault();
      e.stopPropagation();
      const left = this.getLeft(e);
      if (left < 0) {
        this.change(0);
        return;
      }
      const { clientWidth } = this.$refs.container;
      if (left > clientWidth) {
        this.change(100);
        return;
      }
      this.change(left * 100 / clientWidth);
    }
  }
};
function _sfc_render$1w(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass([_ctx.prefixCls + "-hue"]),
    tabindex: "0",
    onClick: _cache[3] || (_cache[3] = ($event) => _ctx.$el.focus()),
    onKeydown: [
      _cache[4] || (_cache[4] = withKeys((...args) => _ctx.handleEscape && _ctx.handleEscape(...args), ["esc"])),
      _cache[5] || (_cache[5] = withKeys((...args) => _ctx.handleLeft && _ctx.handleLeft(...args), ["left"])),
      _cache[6] || (_cache[6] = withKeys((...args) => _ctx.handleRight && _ctx.handleRight(...args), ["right"])),
      _cache[7] || (_cache[7] = withKeys((...args) => _ctx.handleUp && _ctx.handleUp(...args), ["up"])),
      _cache[8] || (_cache[8] = withKeys((...args) => _ctx.handleDown && _ctx.handleDown(...args), ["down"]))
    ]
  }, [
    createElementVNode("div", {
      ref: "container",
      class: normalizeClass([_ctx.prefixCls + "-hue-container"]),
      onMousedown: _cache[0] || (_cache[0] = (...args) => _ctx.handleMouseDown && _ctx.handleMouseDown(...args)),
      onTouchmove: _cache[1] || (_cache[1] = (...args) => $options.handleChange && $options.handleChange(...args)),
      onTouchstart: _cache[2] || (_cache[2] = (...args) => $options.handleChange && $options.handleChange(...args))
    }, [
      createElementVNode("div", {
        style: normalizeStyle({ top: 0, left: `${$data.percent}%` }),
        class: normalizeClass([_ctx.prefixCls + "-hue-pointer"])
      }, [
        createElementVNode("div", {
          class: normalizeClass([_ctx.prefixCls + "-hue-picker"])
        }, null, 2)
      ], 6)
    ], 34)
  ], 34);
}
var Hue = /* @__PURE__ */ _export_sfc(_sfc_main$1K, [["render", _sfc_render$1w]]);
const _sfc_main$1J = {
  name: "Alpha",
  mixins: [HSAMixin, Prefixes],
  emits: ["change"],
  data() {
    const normalStep = 1;
    const jumpStep = 10;
    return {
      left: -normalStep,
      right: normalStep,
      up: jumpStep,
      down: -jumpStep,
      powerKey: "shiftKey"
    };
  },
  computed: {
    gradientStyle() {
      const { r, g, b } = this.value.rgba;
      const start = toRGBAString({ r, g, b, a: 0 });
      const finish = toRGBAString({ r, g, b, a: 1 });
      return { background: `linear-gradient(to right, ${start} 0%, ${finish} 100%)` };
    }
  },
  methods: {
    change(newAlpha) {
      const { h: h2, s, l } = this.value.hsl;
      const { a } = this.value;
      if (a !== newAlpha) {
        this.$emit("change", { h: h2, s, l, a: newAlpha, source: "rgba" });
      }
    },
    handleSlide(e, direction) {
      e.preventDefault();
      e.stopPropagation();
      this.change(clamp(e[this.powerKey] ? direction : Math.round(this.value.hsl.a * 100 + direction) / 100, 0, 1));
    },
    handleChange(e) {
      e.preventDefault();
      e.stopPropagation();
      const left = this.getLeft(e);
      if (left < 0) {
        this.change(0);
        return;
      }
      const { clientWidth } = this.$refs.container;
      if (left > clientWidth) {
        this.change(1);
        return;
      }
      this.change(Math.round(left * 100 / clientWidth) / 100);
    }
  }
};
function _sfc_render$1v(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass([_ctx.prefixCls + "-alpha"]),
    tabindex: "0",
    onClick: _cache[3] || (_cache[3] = ($event) => _ctx.$el.focus()),
    onKeydown: [
      _cache[4] || (_cache[4] = withKeys((...args) => _ctx.handleEscape && _ctx.handleEscape(...args), ["esc"])),
      _cache[5] || (_cache[5] = withKeys((...args) => _ctx.handleLeft && _ctx.handleLeft(...args), ["left"])),
      _cache[6] || (_cache[6] = withKeys((...args) => _ctx.handleRight && _ctx.handleRight(...args), ["right"])),
      _cache[7] || (_cache[7] = withKeys((...args) => _ctx.handleUp && _ctx.handleUp(...args), ["up"])),
      _cache[8] || (_cache[8] = withKeys((...args) => _ctx.handleDown && _ctx.handleDown(...args), ["down"]))
    ]
  }, [
    createElementVNode("div", {
      class: normalizeClass([_ctx.prefixCls + "-alpha-checkboard-wrap"])
    }, [
      createElementVNode("div", {
        class: normalizeClass([_ctx.prefixCls + "-alpha-checkerboard"])
      }, null, 2)
    ], 2),
    createElementVNode("div", {
      style: normalizeStyle($options.gradientStyle),
      class: normalizeClass([_ctx.prefixCls + "-alpha-gradient"])
    }, null, 6),
    createElementVNode("div", {
      ref: "container",
      class: normalizeClass([_ctx.prefixCls + "-alpha-container"]),
      onMousedown: _cache[0] || (_cache[0] = (...args) => _ctx.handleMouseDown && _ctx.handleMouseDown(...args)),
      onTouchmove: _cache[1] || (_cache[1] = (...args) => $options.handleChange && $options.handleChange(...args)),
      onTouchstart: _cache[2] || (_cache[2] = (...args) => $options.handleChange && $options.handleChange(...args))
    }, [
      createElementVNode("div", {
        style: normalizeStyle({ top: 0, left: `${_ctx.value.a * 100}%` }),
        class: normalizeClass([_ctx.prefixCls + "-alpha-pointer"])
      }, [
        createElementVNode("div", {
          class: normalizeClass([_ctx.prefixCls + "-alpha-picker"])
        }, null, 2)
      ], 6)
    ], 34)
  ], 34);
}
var Alpha = /* @__PURE__ */ _export_sfc(_sfc_main$1J, [["render", _sfc_render$1v]]);
const _sfc_main$1I = {
  name: "ColorPicker",
  components: { Drop, RecommendColors, Saturation, Hue, Alpha, iInput: Input, iButton: _sfc_main$2c, Icon },
  directives: { clickOutside: directive },
  mixins: [Locale, Prefixes, mixinsForm, globalConfig],
  emits: ["on-active-change", "on-open-change", "on-change", "on-pick-success", "on-pick-clear", "update:modelValue"],
  provide() {
    return {
      ColorPickerInstance: this
    };
  },
  props: {
    modelValue: {
      type: String,
      default: void 0
    },
    hue: {
      type: Boolean,
      default: true
    },
    alpha: {
      type: Boolean,
      default: false
    },
    recommend: {
      type: Boolean,
      default: false
    },
    format: {
      type: String,
      validator(value) {
        return oneOf(value, ["hsl", "hsv", "hex", "rgb"]);
      },
      default: void 0
    },
    colors: {
      type: Array,
      default() {
        return [];
      }
    },
    disabled: {
      type: Boolean,
      default: false
    },
    size: {
      validator(value) {
        return oneOf(value, ["small", "large", "default"]);
      },
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.size === "" ? "default" : global2.$VIEWUI.size;
      }
    },
    hideDropDown: {
      type: Boolean,
      default: false
    },
    placement: {
      type: String,
      validator(value) {
        return oneOf(value, [
          "top",
          "top-start",
          "top-end",
          "bottom",
          "bottom-start",
          "bottom-end",
          "left",
          "left-start",
          "left-end",
          "right",
          "right-start",
          "right-end"
        ]);
      },
      default: "bottom"
    },
    transfer: {
      type: Boolean,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.transfer === "" ? false : global2.$VIEWUI.transfer;
      }
    },
    name: {
      type: String,
      default: void 0
    },
    editable: {
      type: Boolean,
      default: true
    },
    capture: {
      type: Boolean,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI ? true : global2.$VIEWUI.capture;
      }
    },
    transferClassName: {
      type: String
    },
    eventsEnabled: {
      type: Boolean,
      default: false
    }
  },
  data() {
    return {
      val: changeColor(this.modelValue || ""),
      currentValue: this.modelValue || "",
      dragging: false,
      visible: false,
      recommendedColor: [
        "#2d8cf0",
        "#19be6b",
        "#ff9900",
        "#ed4014",
        "#00b5ff",
        "#19c919",
        "#f9e31c",
        "#ea1a1a",
        "#9b1dea",
        "#00c2b1",
        "#ac7a33",
        "#1d35ea",
        "#8bc34a",
        "#f16b62",
        "#ea4ca3",
        "#0d94aa",
        "#febd79",
        "#5d4037",
        "#00bcd4",
        "#f06292",
        "#cddc39",
        "#607d8b",
        "#000000",
        "#ffffff"
      ]
    };
  },
  computed: {
    arrowClasses() {
      return [
        `${this.inputPrefixCls}-icon`,
        `${this.inputPrefixCls}-icon-normal`
      ];
    },
    transition() {
      return oneOf(this.placement, ["bottom-start", "bottom", "bottom-end"]) ? "slide-up" : "fade";
    },
    saturationColors: {
      get() {
        return this.val;
      },
      set(newVal) {
        this.val = newVal;
        this.$emit("on-active-change", this.formatColor);
      }
    },
    classes() {
      return [
        `${this.prefixCls}`,
        {
          [`${this.prefixCls}-transfer`]: this.transfer
        }
      ];
    },
    wrapClasses() {
      return [
        `${this.prefixCls}-rel`,
        `${this.prefixCls}-${this.size}`,
        `${this.inputPrefixCls}-wrapper`,
        `${this.inputPrefixCls}-wrapper-${this.size}`,
        {
          [`${this.prefixCls}-disabled`]: this.itemDisabled
        }
      ];
    },
    inputClasses() {
      return [
        `${this.prefixCls}-input`,
        `${this.inputPrefixCls}`,
        `${this.inputPrefixCls}-${this.size}`,
        {
          [`${this.prefixCls}-focused`]: this.visible,
          [`${this.prefixCls}-disabled`]: this.itemDisabled
        }
      ];
    },
    dropClasses() {
      return {
        [`${this.transferPrefixCls}-no-max-height`]: true,
        [`${this.prefixCls}-transfer`]: this.transfer,
        [`${this.prefixCls}-hide-drop`]: this.hideDropDown,
        [this.transferClassName]: this.transferClassName
      };
    },
    displayedColorStyle() {
      return { backgroundColor: toRGBAString(this.visible ? this.saturationColors.rgba : tinycolor(this.modelValue).toRgb()) };
    },
    formatColor() {
      const { format: format2, saturationColors } = this;
      if (format2) {
        if (format2 === "hsl") {
          return tinycolor(saturationColors.hsl).toHslString();
        }
        if (format2 === "hsv") {
          return tinycolor(saturationColors.hsv).toHsvString();
        }
        if (format2 === "hex") {
          return saturationColors.hex;
        }
        if (format2 === "rgb") {
          return toRGBAString(saturationColors.rgba);
        }
      } else if (this.alpha) {
        return toRGBAString(saturationColors.rgba);
      }
      return saturationColors.hex;
    },
    confirmColorClasses() {
      return [
        `${this.prefixCls}-confirm-color`,
        {
          [`${this.prefixCls}-confirm-color-editable`]: this.editable
        }
      ];
    },
    arrowType() {
      const config = this.globalConfig;
      let type2 = "ios-arrow-down";
      if (config) {
        if (config.colorPicker.customArrow) {
          type2 = "";
        } else if (config.colorPicker.arrow) {
          type2 = config.colorPicker.arrow;
        }
      }
      return type2;
    },
    customArrowType() {
      const config = this.globalConfig;
      let type2 = "";
      if (config) {
        if (config.colorPicker.customArrow) {
          type2 = config.colorPicker.customArrow;
        }
      }
      return type2;
    },
    arrowSize() {
      const config = this.globalConfig;
      let size = "";
      if (config) {
        if (config.colorPicker.arrowSize) {
          size = config.colorPicker.arrowSize;
        }
      }
      return size;
    }
  },
  watch: {
    modelValue(newVal) {
      this.val = changeColor(newVal || "");
    },
    visible(val) {
      this.val = changeColor(this.modelValue || "");
      this.$refs.drop[val ? "update" : "destroy"]();
      this.$emit("on-open-change", Boolean(val));
    }
  },
  methods: {
    setDragging(value) {
      this.dragging = value;
    },
    handleClose(event) {
      if (this.visible) {
        if (this.dragging || event.type === "mousedown") {
          if (this.$refs.editColorInput && event.target !== this.$refs.editColorInput.$el.querySelector("input")) {
            event.preventDefault();
          }
          return;
        }
        if (this.transfer) {
          const $el = this.$refs.drop.$refs.drop;
          if ($el === event.target || $el.contains(event.target)) {
            return;
          }
        }
        this.closer(event);
        return;
      }
      this.visible = false;
    },
    toggleVisible() {
      if (this.itemDisabled) {
        return;
      }
      this.visible = !this.visible;
      this.$refs.input.focus();
    },
    childChange(data) {
      this.colorChange(data);
    },
    colorChange(data, oldHue) {
      this.oldHue = this.saturationColors.hsl.h;
      this.saturationColors = changeColor(data, oldHue || this.oldHue);
    },
    closer(event) {
      if (event) {
        event.preventDefault();
        event.stopPropagation();
      }
      this.visible = false;
      this.$refs.input.focus();
    },
    handleButtons(event, value) {
      this.currentValue = value;
      this.$emit("update:modelValue", value);
      this.$emit("on-change", value);
      this.handleFormItemChange("change", value);
      this.closer(event);
    },
    handleSuccess(event) {
      this.handleButtons(event, this.formatColor);
      this.$emit("on-pick-success");
    },
    handleClear(event) {
      this.handleButtons(event, "");
      this.$emit("on-pick-clear");
    },
    handleSelectColor(color2) {
      this.val = changeColor(color2);
      this.$emit("on-active-change", this.formatColor);
    },
    handleEditColor(event) {
      const value = event.target.value;
      this.handleSelectColor(value);
    },
    handleFirstTab(event) {
      if (event.shiftKey) {
        event.preventDefault();
        event.stopPropagation();
        this.$refs.ok.$el.focus();
      }
    },
    handleLastTab(event) {
      if (!event.shiftKey) {
        event.preventDefault();
        event.stopPropagation();
        this.$refs.saturation.$el.focus();
      }
    },
    onTab(event) {
      if (this.visible) {
        event.preventDefault();
      }
    },
    onEscape(event) {
      if (this.visible) {
        this.closer(event);
      }
    },
    onArrow(event) {
      if (!this.visible) {
        event.preventDefault();
        event.stopPropagation();
        this.visible = true;
      }
    },
    handleOnEscapeKeydown(e) {
      this.closer(e);
    },
    handleOnDragging(value) {
      this.setDragging(value);
    }
  }
};
const _hoisted_1$S = ["name", "value"];
const _hoisted_2$w = ["tabindex"];
function _sfc_render$1u(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = resolveComponent("Icon");
  const _component_Saturation = resolveComponent("Saturation");
  const _component_Hue = resolveComponent("Hue");
  const _component_Alpha = resolveComponent("Alpha");
  const _component_recommend_colors = resolveComponent("recommend-colors");
  const _component_i_input = resolveComponent("i-input");
  const _component_i_button = resolveComponent("i-button");
  const _component_Drop = resolveComponent("Drop");
  const _directive_click_outside = resolveDirective("click-outside");
  return withDirectives((openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes)
  }, [
    createElementVNode("div", {
      ref: "reference",
      class: normalizeClass($options.wrapClasses),
      onClick: _cache[4] || (_cache[4] = (...args) => $options.toggleVisible && $options.toggleVisible(...args))
    }, [
      createElementVNode("input", {
        name: $props.name,
        value: $data.currentValue,
        type: "hidden"
      }, null, 8, _hoisted_1$S),
      createVNode(_component_Icon, {
        type: $options.arrowType,
        custom: $options.customArrowType,
        size: $options.arrowSize,
        class: normalizeClass($options.arrowClasses)
      }, null, 8, ["type", "custom", "size", "class"]),
      createElementVNode("div", {
        ref: "input",
        tabindex: _ctx.itemDisabled ? void 0 : 0,
        class: normalizeClass($options.inputClasses),
        onKeydown: [
          _cache[0] || (_cache[0] = withKeys((...args) => $options.onTab && $options.onTab(...args), ["tab"])),
          _cache[1] || (_cache[1] = withKeys((...args) => $options.onEscape && $options.onEscape(...args), ["esc"])),
          _cache[2] || (_cache[2] = withKeys((...args) => $options.onArrow && $options.onArrow(...args), ["up"])),
          _cache[3] || (_cache[3] = withKeys((...args) => $options.onArrow && $options.onArrow(...args), ["down"]))
        ]
      }, [
        createElementVNode("div", {
          class: normalizeClass([_ctx.prefixCls + "-color"])
        }, [
          withDirectives(createElementVNode("div", {
            class: normalizeClass([_ctx.prefixCls + "-color-empty"])
          }, [
            createElementVNode("i", {
              class: normalizeClass([_ctx.iconPrefixCls, _ctx.iconPrefixCls + "-ios-close"])
            }, null, 2)
          ], 2), [
            [vShow, $props.modelValue === "" && !$data.visible]
          ]),
          withDirectives(createElementVNode("div", {
            style: normalizeStyle($options.displayedColorStyle)
          }, null, 4), [
            [vShow, $props.modelValue || $data.visible]
          ])
        ], 2)
      ], 42, _hoisted_2$w)
    ], 2),
    createVNode(_component_Drop, {
      ref: "drop",
      visible: $data.visible,
      placement: $props.placement,
      transfer: $props.transfer,
      classes: $options.dropClasses,
      eventsEnabled: $props.eventsEnabled,
      "transition-name": "transition-drop"
    }, {
      default: withCtx(() => [
        createVNode(Transition, { name: "fade" }, {
          default: withCtx(() => [
            $data.visible ? (openBlock(), createElementBlock("div", {
              key: 0,
              class: normalizeClass([_ctx.prefixCls + "-picker"])
            }, [
              createElementVNode("div", {
                class: normalizeClass([_ctx.prefixCls + "-picker-wrapper"])
              }, [
                createElementVNode("div", {
                  class: normalizeClass([_ctx.prefixCls + "-picker-panel"])
                }, [
                  createVNode(_component_Saturation, {
                    ref: "saturation",
                    value: $options.saturationColors,
                    focused: $data.visible,
                    onChange: $options.childChange,
                    onKeydown: withKeys($options.handleFirstTab, ["tab"])
                  }, null, 8, ["value", "focused", "onChange", "onKeydown"])
                ], 2),
                $props.hue ? (openBlock(), createElementBlock("div", {
                  key: 0,
                  class: normalizeClass([_ctx.prefixCls + "-picker-hue-slider"])
                }, [
                  createVNode(_component_Hue, {
                    value: $options.saturationColors,
                    onChange: $options.childChange
                  }, null, 8, ["value", "onChange"])
                ], 2)) : createCommentVNode("", true),
                $props.alpha ? (openBlock(), createElementBlock("div", {
                  key: 1,
                  class: normalizeClass([_ctx.prefixCls + "-picker-alpha-slider"])
                }, [
                  createVNode(_component_Alpha, {
                    value: $options.saturationColors,
                    onChange: $options.childChange
                  }, null, 8, ["value", "onChange"])
                ], 2)) : createCommentVNode("", true),
                $props.colors.length ? (openBlock(), createBlock(_component_recommend_colors, {
                  key: 2,
                  list: $props.colors,
                  class: normalizeClass([_ctx.prefixCls + "-picker-colors"]),
                  onPickerColor: $options.handleSelectColor
                }, null, 8, ["list", "class", "onPickerColor"])) : createCommentVNode("", true),
                !$props.colors.length && $props.recommend ? (openBlock(), createBlock(_component_recommend_colors, {
                  key: 3,
                  list: $data.recommendedColor,
                  class: normalizeClass([_ctx.prefixCls + "-picker-colors"]),
                  onPickerColor: $options.handleSelectColor
                }, null, 8, ["list", "class", "onPickerColor"])) : createCommentVNode("", true)
              ], 2),
              createElementVNode("div", {
                class: normalizeClass([_ctx.prefixCls + "-confirm"])
              }, [
                createElementVNode("span", {
                  class: normalizeClass($options.confirmColorClasses)
                }, [
                  $props.editable ? (openBlock(), createBlock(_component_i_input, {
                    key: 0,
                    ref: "editColorInput",
                    modelValue: $options.formatColor,
                    size: "small",
                    onOnEnter: $options.handleEditColor,
                    onOnBlur: $options.handleEditColor
                  }, null, 8, ["modelValue", "onOnEnter", "onOnBlur"])) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                    createTextVNode(toDisplayString($options.formatColor), 1)
                  ], 64))
                ], 2),
                createVNode(_component_i_button, {
                  class: normalizeClass([_ctx.prefixCls + "-confirm-btn-cancel"]),
                  ref: "clear",
                  tabindex: 0,
                  size: "small",
                  onClick: $options.handleClear,
                  onKeydown: [
                    withKeys($options.handleClear, ["enter"]),
                    withKeys($options.closer, ["esc"])
                  ]
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.t("i.datepicker.clear")), 1)
                  ]),
                  _: 1
                }, 8, ["class", "onClick", "onKeydown"]),
                createVNode(_component_i_button, {
                  ref: "ok",
                  tabindex: 0,
                  size: "small",
                  type: "primary",
                  onClick: $options.handleSuccess,
                  onKeydown: [
                    withKeys($options.handleLastTab, ["tab"]),
                    withKeys($options.handleSuccess, ["enter"]),
                    withKeys($options.closer, ["esc"])
                  ]
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.t("i.datepicker.ok")), 1)
                  ]),
                  _: 1
                }, 8, ["onClick", "onKeydown"])
              ], 2)
            ], 2)) : createCommentVNode("", true)
          ]),
          _: 1
        })
      ]),
      _: 1
    }, 8, ["visible", "placement", "transfer", "classes", "eventsEnabled"])
  ], 2)), [
    [_directive_click_outside, $options.handleClose, $props.capture]
  ]);
}
var ColorPicker = /* @__PURE__ */ _export_sfc(_sfc_main$1I, [["render", _sfc_render$1u]]);
const prefixCls$U = "ivu-layout";
const _sfc_main$1H = {
  name: "Content",
  computed: {
    wrapClasses() {
      return `${prefixCls$U}-content`;
    }
  }
};
function _sfc_render$1t(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.wrapClasses)
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 2);
}
var Content = /* @__PURE__ */ _export_sfc(_sfc_main$1H, [["render", _sfc_render$1t]]);
function select(element) {
  var selectedText;
  if (element.nodeName === "SELECT") {
    element.focus();
    selectedText = element.value;
  } else if (element.nodeName === "INPUT" || element.nodeName === "TEXTAREA") {
    var isReadOnly = element.hasAttribute("readonly");
    if (!isReadOnly) {
      element.setAttribute("readonly", "");
    }
    element.select();
    element.setSelectionRange(0, element.value.length);
    if (!isReadOnly) {
      element.removeAttribute("readonly");
    }
    selectedText = element.value;
  } else {
    if (element.hasAttribute("contenteditable")) {
      element.focus();
    }
    var selection = window.getSelection();
    var range2 = document.createRange();
    range2.selectNodeContents(element);
    selection.removeAllRanges();
    selection.addRange(range2);
    selectedText = selection.toString();
  }
  return selectedText;
}
var select_1 = select;
var Render$1 = {
  name: "RenderCell",
  props: {
    render: Function
  },
  render() {
    return this.render(h);
  }
};
const _sfc_main$1G = {
  components: {
    RenderCell: Render$1
  },
  props: {
    prefixCls: {
      type: String,
      default: ""
    },
    duration: {
      type: Number,
      default: 1.5
    },
    type: {
      type: String
    },
    content: {
      type: String,
      default: ""
    },
    withIcon: Boolean,
    render: {
      type: Function
    },
    hasTitle: Boolean,
    styles: {
      type: Object,
      default: function() {
        return {
          right: "50%"
        };
      }
    },
    closable: {
      type: Boolean,
      default: false
    },
    className: {
      type: String
    },
    name: {
      type: String,
      required: true
    },
    onClose: {
      type: Function
    },
    transitionName: {
      type: String
    },
    background: {
      type: Boolean,
      default: false
    },
    msgType: {
      type: String
    }
  },
  data() {
    return {
      withDesc: false
    };
  },
  computed: {
    baseClass() {
      return `${this.prefixCls}-notice`;
    },
    renderFunc() {
      return this.render || function() {
      };
    },
    classes() {
      return [
        this.baseClass,
        {
          [`${this.className}`]: !!this.className,
          [`${this.baseClass}-closable`]: this.closable,
          [`${this.baseClass}-with-desc`]: this.withDesc,
          [`${this.baseClass}-with-background`]: this.background
        }
      ];
    },
    contentClasses() {
      return [
        `${this.baseClass}-content`,
        this.render !== void 0 ? `${this.baseClass}-content-with-render` : ""
      ];
    },
    messageContentClasses() {
      return [
        `${this.baseClass}-content`,
        {
          [`${this.baseClass}-content-${this.msgType}`]: this.msgType,
          [`${this.baseClass}-content-background`]: this.background
        }
      ];
    },
    contentWithIcon() {
      return [
        this.withIcon ? `${this.prefixCls}-content-with-icon` : "",
        !this.hasTitle && this.withIcon ? `${this.prefixCls}-content-with-render-notitle` : ""
      ];
    },
    messageClasses() {
      return [
        `${this.baseClass}-content`,
        this.render !== void 0 ? `${this.baseClass}-content-with-render` : ""
      ];
    }
  },
  methods: {
    clearCloseTimer() {
      if (this.closeTimer) {
        clearTimeout(this.closeTimer);
        this.closeTimer = null;
      }
    },
    close() {
      this.clearCloseTimer();
      this.onClose();
      this.$parent.$parent.close(this.name);
    },
    handleEnter(el) {
      if (this.type === "message") {
        el.style.height = el.scrollHeight + "px";
      }
    },
    handleLeave(el) {
      if (this.type === "message") {
        if (isClient && document.getElementsByClassName("ivu-message-notice").length !== 1) {
          el.style.height = 0;
          el.style.paddingTop = 0;
          el.style.paddingBottom = 0;
        }
      }
    }
  },
  mounted() {
    this.handleEnter(this.$el);
    this.clearCloseTimer();
    if (this.duration !== 0) {
      this.closeTimer = setTimeout(() => {
        this.close();
      }, this.duration * 1e3);
    }
    if (this.prefixCls === "ivu-notice") {
      let desc = this.$refs.content.querySelectorAll(`.${this.prefixCls}-desc`)[0];
      this.withDesc = this.render ? true : desc ? desc.innerHTML !== "" : false;
    }
  },
  beforeUnmount() {
    this.handleLeave(this.$el);
    this.clearCloseTimer();
  }
};
const _hoisted_1$R = ["innerHTML"];
const _hoisted_2$v = ["innerHTML"];
function _sfc_render$1s(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_render_cell = resolveComponent("render-cell");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes),
    style: normalizeStyle($props.styles)
  }, [
    $props.type === "notice" ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
      createElementVNode("div", {
        class: normalizeClass($options.contentClasses),
        ref: "content",
        innerHTML: $props.content
      }, null, 10, _hoisted_1$R),
      createElementVNode("div", {
        class: normalizeClass($options.contentWithIcon)
      }, [
        createVNode(_component_render_cell, { render: $options.renderFunc }, null, 8, ["render"])
      ], 2),
      $props.closable ? (openBlock(), createElementBlock("a", {
        key: 0,
        class: normalizeClass([$options.baseClass + "-close"]),
        onClick: _cache[0] || (_cache[0] = (...args) => $options.close && $options.close(...args))
      }, _cache[2] || (_cache[2] = [
        createElementVNode("i", { class: "ivu-icon ivu-icon-ios-close" }, null, -1)
      ]), 2)) : createCommentVNode("", true)
    ], 64)) : createCommentVNode("", true),
    $props.type === "message" ? (openBlock(), createElementBlock("div", {
      key: 1,
      class: normalizeClass($options.messageContentClasses),
      ref: "content"
    }, [
      createElementVNode("div", {
        class: normalizeClass([$options.baseClass + "-content-text"]),
        innerHTML: $props.content
      }, null, 10, _hoisted_2$v),
      createElementVNode("div", {
        class: normalizeClass([$options.baseClass + "-content-text"])
      }, [
        createVNode(_component_render_cell, { render: $options.renderFunc }, null, 8, ["render"])
      ], 2),
      $props.closable ? (openBlock(), createElementBlock("a", {
        key: 0,
        class: normalizeClass([$options.baseClass + "-close"]),
        onClick: _cache[1] || (_cache[1] = (...args) => $options.close && $options.close(...args))
      }, _cache[3] || (_cache[3] = [
        createElementVNode("i", { class: "ivu-icon ivu-icon-ios-close" }, null, -1)
      ]), 2)) : createCommentVNode("", true)
    ], 2)) : createCommentVNode("", true)
  ], 6);
}
var Notice = /* @__PURE__ */ _export_sfc(_sfc_main$1G, [["render", _sfc_render$1s]]);
const prefixCls$T = "ivu-notification";
let seed = 0;
const now$1 = Date.now();
function getUuid() {
  return "ivuNotification_" + now$1 + "_" + seed++;
}
const _sfc_main$1F = {
  components: { Notice },
  props: {
    prefixCls: {
      type: String,
      default: prefixCls$T
    },
    styles: {
      type: Object,
      default: function() {
        return {
          top: "65px",
          left: "50%"
        };
      }
    },
    content: {
      type: String
    },
    className: {
      type: String
    },
    transitionName: {
      type: String
    }
  },
  data() {
    return {
      notices: [],
      tIndex: this.handleGetIndex()
    };
  },
  computed: {
    classes() {
      return [
        `${this.prefixCls}`,
        {
          [`${this.className}`]: !!this.className
        }
      ];
    },
    wrapStyles() {
      let styles = Object.assign({}, this.styles);
      styles["z-index"] = 1010 + this.tIndex;
      return styles;
    }
  },
  methods: {
    add(notice2) {
      const name2 = notice2.name || getUuid();
      let _notice = Object.assign({
        styles: {
          right: "50%"
        },
        content: "",
        duration: 1.5,
        closable: false,
        name: name2
      }, notice2);
      this.notices.push(_notice);
      this.tIndex = this.handleGetIndex();
    },
    close(name2) {
      const notices = this.notices;
      for (let i = 0; i < notices.length; i++) {
        if (notices[i].name === name2) {
          this.notices.splice(i, 1);
          break;
        }
      }
    },
    closeAll() {
      this.notices = [];
    },
    handleGetIndex() {
      transferIncrease();
      return transferIndex;
    }
  }
};
function _sfc_render$1r(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Notice = resolveComponent("Notice");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes),
    style: normalizeStyle($options.wrapStyles)
  }, [
    createVNode(TransitionGroup, {
      name: $props.transitionName,
      appear: ""
    }, {
      default: withCtx(() => [
        (openBlock(true), createElementBlock(Fragment, null, renderList($data.notices, (notice2) => {
          return openBlock(), createBlock(_component_Notice, {
            key: notice2.name,
            "prefix-cls": $props.prefixCls,
            styles: notice2.styles,
            type: notice2.type,
            content: notice2.content,
            duration: notice2.duration,
            render: notice2.render,
            "has-title": notice2.hasTitle,
            withIcon: notice2.withIcon,
            closable: notice2.closable,
            name: notice2.name,
            "transition-name": notice2.transitionName,
            background: notice2.background,
            "msg-type": notice2.msgType,
            "on-close": notice2.onClose
          }, null, 8, ["prefix-cls", "styles", "type", "content", "duration", "render", "has-title", "withIcon", "closable", "name", "transition-name", "background", "msg-type", "on-close"]);
        }), 128))
      ]),
      _: 1
    }, 8, ["name"])
  ], 6);
}
var Notification$1 = /* @__PURE__ */ _export_sfc(_sfc_main$1F, [["render", _sfc_render$1r]]);
Notification$1.newInstance = (properties) => {
  if (!isClient)
    return;
  const _props = properties || {};
  let _instance = null;
  const Instance = createApp({
    render() {
      return h(Notification$1, Object.assign({
        ref: "notification"
      }, _props));
    },
    created() {
      _instance = getCurrentInstance();
    }
  });
  const container = document.createElement("div");
  document.body.appendChild(container);
  Instance.mount(container);
  const notification = _instance.refs.notification;
  return {
    notice(noticeProps) {
      nextTick(() => {
        _instance.refs.notification.add(noticeProps);
      });
    },
    remove(name2) {
      nextTick(() => {
        _instance.refs.notification.close(name2);
      });
    },
    component: notification,
    destroy(element) {
      isClient && setTimeout(function() {
        _instance.refs.notification.closeAll();
        const removeElement = document.querySelectorAll(`.${element}`)[0];
        if (container && removeElement) {
          container.removeChild(removeElement);
        }
      }, 500);
    }
  };
};
const prefixCls$S = "ivu-message";
const iconPrefixCls$3 = "ivu-icon";
const prefixKey$1 = "ivu_message_key_";
const defaults$1 = {
  top: 24,
  duration: 1.5,
  background: false
};
let messageInstance;
let name$2 = 1;
const iconTypes$1 = {
  "info": "ios-information-circle",
  "success": "ios-checkmark-circle",
  "warning": "ios-alert",
  "error": "ios-close-circle",
  "loading": "ios-loading"
};
const transitionName$1 = "move-up";
function getMessageInstance() {
  messageInstance = messageInstance || Notification$1.newInstance({
    prefixCls: prefixCls$S,
    styles: {
      top: `${defaults$1.top}px`
    },
    transitionName: transitionName$1
  });
  return messageInstance;
}
function notice$1(content = "", duration2 = defaults$1.duration, type2, onClose = function() {
}, closable = false, render = function() {
}, background = defaults$1.background) {
  const iconType = iconTypes$1[type2];
  const loadCls = type2 === "loading" ? " ivu-load-loop" : "";
  let instance = getMessageInstance();
  instance.notice({
    name: `${prefixKey$1}${name$2}`,
    duration: duration2,
    styles: {},
    transitionName: transitionName$1,
    content: `
            <div class="${prefixCls$S}-custom-content ${prefixCls$S}-${type2}">
                <i class="${iconPrefixCls$3} ${iconPrefixCls$3}-${iconType} ${loadCls}"></i>
                <span>${content}</span>
            </div>
        `,
    render,
    onClose,
    closable,
    type: "message",
    msgType: type2,
    background
  });
  return function() {
    let target = name$2++;
    return function() {
      instance.remove(`${prefixKey$1}${target}`);
    };
  }();
}
var $Message = {
  name: "Message",
  info(options) {
    return this.message("info", options);
  },
  success(options) {
    return this.message("success", options);
  },
  warning(options) {
    return this.message("warning", options);
  },
  error(options) {
    return this.message("error", options);
  },
  loading(options) {
    return this.message("loading", options);
  },
  message(type2, options) {
    if (typeof options === "string") {
      options = {
        content: options
      };
    }
    return notice$1(options.content, options.duration, type2, options.onClose, options.closable, options.render, options.background);
  },
  config(options) {
    if (options.top || options.top === 0) {
      defaults$1.top = options.top;
    }
    if (options.duration || options.duration === 0) {
      defaults$1.duration = options.duration;
    }
    if (options.background)
      defaults$1.background = options.background;
  },
  destroy() {
    let instance = getMessageInstance();
    messageInstance = null;
    instance.destroy("ivu-message");
  }
};
const defaultSuccessTip = "\u590D\u5236\u6210\u529F";
const defaultErrorTip = "\u590D\u5236\u5931\u8D25";
function Copy({ text = "", successTip = defaultSuccessTip, errorTip = defaultErrorTip, success, error, showTip = true }) {
  if (!isClient)
    return;
  const isRTL = document.documentElement.getAttribute("dir") === "rtl";
  const $textarea = document.createElement("textarea");
  $textarea.style.fontSize = "12pt";
  $textarea.style.border = "0";
  $textarea.style.padding = "0";
  $textarea.style.margin = "0";
  $textarea.style.position = "absolute";
  $textarea.style[isRTL ? "right" : "left"] = "-9999px";
  let yPosition = window.pageYOffset || document.documentElement.scrollTop;
  $textarea.style.top = `${yPosition}px`;
  $textarea.setAttribute("readonly", "");
  $textarea.value = text;
  document.body.appendChild($textarea);
  select_1($textarea);
  let succeeded;
  try {
    succeeded = document.execCommand("copy");
    if (showTip) {
      $Message.success({
        content: successTip
      });
    }
    document.body.removeChild($textarea);
    if (success)
      success.call();
  } catch (err) {
    succeeded = false;
    if (showTip) {
      $Message.error({
        content: errorTip
      });
    }
    document.body.removeChild($textarea);
    if (error)
      error.call();
  }
}
function fixedZero(val) {
  return val * 1 < 10 ? `0${val}` : val;
}
const _sfc_main$1E = {
  name: "CountDown",
  emits: ["on-end"],
  props: {
    format: {
      type: Function
    },
    target: {
      type: [Date, Number]
    },
    interval: {
      type: Number,
      default: 1e3
    }
  },
  data() {
    return {
      lastTime: ""
    };
  },
  methods: {
    initTime() {
      let lastTime = 0;
      let targetTime = 0;
      try {
        if (Object.prototype.toString.call(this.target) === "[object Date]") {
          targetTime = this.target.getTime();
        } else {
          targetTime = new Date(this.target).getTime();
        }
      } catch (e) {
        throw new Error("invalid target prop", e);
      }
      lastTime = targetTime - new Date().getTime();
      return lastTime < 0 ? 0 : lastTime;
    },
    tick() {
      let { lastTime } = this;
      this.timer = setTimeout(() => {
        if (lastTime < this.interval) {
          clearTimeout(this.timer);
          this.lastTime = 0;
          this.$emit("on-end");
        } else {
          lastTime -= this.interval;
          this.lastTime = lastTime;
          this.tick();
        }
      }, this.interval);
    },
    defaultFormat(time) {
      const hours = 60 * 60 * 1e3;
      const minutes = 60 * 1e3;
      const h2 = Math.floor(time / hours);
      const m = Math.floor((time - h2 * hours) / minutes);
      const s = Math.floor((time - h2 * hours - m * minutes) / 1e3);
      return `${fixedZero(h2)}:${fixedZero(m)}:${fixedZero(s)}`;
    }
  },
  computed: {
    result() {
      const { format: format2 = this.defaultFormat } = this;
      return format2(this.lastTime);
    }
  },
  watch: {
    target() {
      if (this.timer)
        clearTimeout(this.timer);
      this.lastTime = this.initTime();
      this.tick();
    }
  },
  created() {
    this.lastTime = this.initTime();
  },
  mounted() {
    this.tick();
  },
  beforeUnmount() {
    if (this.timer)
      clearTimeout(this.timer);
  }
};
function _sfc_render$1q(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("span", null, toDisplayString($options.result), 1);
}
var CountDown = /* @__PURE__ */ _export_sfc(_sfc_main$1E, [["render", _sfc_render$1q]]);
var countUp_min = { exports: {} };
(function(module, exports) {
  !function(a, n) {
    module.exports = n(commonjsRequire, exports, module);
  }(commonjsGlobal, function(a, n, t2) {
    var e = function(a2, n2, t3, e2, i, r) {
      function o(a3) {
        var n3, t4, e3, i2, r2, o2, s2 = a3 < 0;
        if (a3 = Math.abs(a3).toFixed(l.decimals), a3 += "", n3 = a3.split("."), t4 = n3[0], e3 = n3.length > 1 ? l.options.decimal + n3[1] : "", l.options.useGrouping) {
          for (i2 = "", r2 = 0, o2 = t4.length; r2 < o2; ++r2)
            0 !== r2 && r2 % 3 === 0 && (i2 = l.options.separator + i2), i2 = t4[o2 - r2 - 1] + i2;
          t4 = i2;
        }
        return l.options.numerals.length && (t4 = t4.replace(/[0-9]/g, function(a4) {
          return l.options.numerals[+a4];
        }), e3 = e3.replace(/[0-9]/g, function(a4) {
          return l.options.numerals[+a4];
        })), (s2 ? "-" : "") + l.options.prefix + t4 + e3 + l.options.suffix;
      }
      function s(a3, n3, t4, e3) {
        return t4 * (-Math.pow(2, -10 * a3 / e3) + 1) * 1024 / 1023 + n3;
      }
      function u(a3) {
        return "number" == typeof a3 && !isNaN(a3);
      }
      var l = this;
      if (l.version = function() {
        return "1.9.3";
      }, l.options = { useEasing: true, useGrouping: true, separator: ",", decimal: ".", easingFn: s, formattingFn: o, prefix: "", suffix: "", numerals: [] }, r && "object" == typeof r)
        for (var m in l.options)
          r.hasOwnProperty(m) && null !== r[m] && (l.options[m] = r[m]);
      "" === l.options.separator ? l.options.useGrouping = false : l.options.separator = "" + l.options.separator;
      for (var d = 0, c = ["webkit", "moz", "ms", "o"], f = 0; f < c.length && !window.requestAnimationFrame; ++f)
        window.requestAnimationFrame = window[c[f] + "RequestAnimationFrame"], window.cancelAnimationFrame = window[c[f] + "CancelAnimationFrame"] || window[c[f] + "CancelRequestAnimationFrame"];
      window.requestAnimationFrame || (window.requestAnimationFrame = function(a3, n3) {
        var t4 = new Date().getTime(), e3 = Math.max(0, 16 - (t4 - d)), i2 = window.setTimeout(function() {
          a3(t4 + e3);
        }, e3);
        return d = t4 + e3, i2;
      }), window.cancelAnimationFrame || (window.cancelAnimationFrame = function(a3) {
        clearTimeout(a3);
      }), l.initialize = function() {
        return !!l.initialized || (l.error = "", l.d = "string" == typeof a2 ? document.getElementById(a2) : a2, l.d ? (l.startVal = Number(n2), l.endVal = Number(t3), u(l.startVal) && u(l.endVal) ? (l.decimals = Math.max(0, e2 || 0), l.dec = Math.pow(10, l.decimals), l.duration = 1e3 * Number(i) || 2e3, l.countDown = l.startVal > l.endVal, l.frameVal = l.startVal, l.initialized = true, true) : (l.error = "[CountUp] startVal (" + n2 + ") or endVal (" + t3 + ") is not a number", false)) : (l.error = "[CountUp] target is null or undefined", false));
      }, l.printValue = function(a3) {
        var n3 = l.options.formattingFn(a3);
        "INPUT" === l.d.tagName ? this.d.value = n3 : "text" === l.d.tagName || "tspan" === l.d.tagName ? this.d.textContent = n3 : this.d.innerHTML = n3;
      }, l.count = function(a3) {
        l.startTime || (l.startTime = a3), l.timestamp = a3;
        var n3 = a3 - l.startTime;
        l.remaining = l.duration - n3, l.options.useEasing ? l.countDown ? l.frameVal = l.startVal - l.options.easingFn(n3, 0, l.startVal - l.endVal, l.duration) : l.frameVal = l.options.easingFn(n3, l.startVal, l.endVal - l.startVal, l.duration) : l.countDown ? l.frameVal = l.startVal - (l.startVal - l.endVal) * (n3 / l.duration) : l.frameVal = l.startVal + (l.endVal - l.startVal) * (n3 / l.duration), l.countDown ? l.frameVal = l.frameVal < l.endVal ? l.endVal : l.frameVal : l.frameVal = l.frameVal > l.endVal ? l.endVal : l.frameVal, l.frameVal = Math.round(l.frameVal * l.dec) / l.dec, l.printValue(l.frameVal), n3 < l.duration ? l.rAF = requestAnimationFrame(l.count) : l.callback && l.callback();
      }, l.start = function(a3) {
        l.initialize() && (l.callback = a3, l.rAF = requestAnimationFrame(l.count));
      }, l.pauseResume = function() {
        l.paused ? (l.paused = false, delete l.startTime, l.duration = l.remaining, l.startVal = l.frameVal, requestAnimationFrame(l.count)) : (l.paused = true, cancelAnimationFrame(l.rAF));
      }, l.reset = function() {
        l.paused = false, delete l.startTime, l.initialized = false, l.initialize() && (cancelAnimationFrame(l.rAF), l.printValue(l.startVal));
      }, l.update = function(a3) {
        if (l.initialize()) {
          if (a3 = Number(a3), !u(a3))
            return void (l.error = "[CountUp] update() - new endVal is not a number: " + a3);
          l.error = "", a3 !== l.frameVal && (cancelAnimationFrame(l.rAF), l.paused = false, delete l.startTime, l.startVal = l.frameVal, l.endVal = a3, l.countDown = l.startVal > l.endVal, l.rAF = requestAnimationFrame(l.count));
        }
      }, l.initialize() && l.printValue(l.startVal);
    };
    return e;
  });
})(countUp_min, countUp_min.exports);
var CountUp$1 = countUp_min.exports;
const _sfc_main$1D = {
  name: "CountUp",
  props: {
    start: {
      type: Number,
      required: false,
      default: 0
    },
    end: {
      type: Number,
      required: true
    },
    decimals: {
      type: Number,
      required: false,
      default: 0
    },
    duration: {
      type: Number,
      required: false,
      default: 2
    },
    options: {
      type: Object,
      required: false,
      default() {
        return {};
      }
    },
    callback: {
      type: Function,
      required: false,
      default: () => {
      }
    }
  },
  data() {
    return {
      CountUp: null
    };
  },
  watch: {
    end(value) {
      if (this.CountUp && this.CountUp.update) {
        this.CountUp.update(value);
      }
    }
  },
  mounted() {
    this.init();
  },
  methods: {
    init() {
      if (!this.CountUp) {
        this.CountUp = new CountUp$1(
          this.$el,
          this.start,
          this.end,
          this.decimals,
          this.duration,
          this.options
        );
        this.CountUp.start(() => {
          this.callback(this.CountUp);
        });
      }
    },
    destroy() {
      this.CountUp = null;
    }
  },
  beforeUnmounted() {
    this.destroy();
  },
  start(callback) {
    if (this.CountUp && this.CountUp.start) {
      this.CountUp.start(() => {
        callback && callback(this.CountUp);
      });
    }
  },
  pauseResume() {
    if (this.CountUp && this.CountUp.pauseResume) {
      this.CountUp.pauseResume();
    }
  },
  reset() {
    if (this.CountUp && this.CountUp.reset) {
      this.CountUp.reset();
    }
  },
  update(newEndVal) {
    if (this.CountUp && this.CountUp.update) {
      this.CountUp.update(newEndVal);
    }
  }
};
const _hoisted_1$Q = { class: "ivu-count-up" };
function _sfc_render$1p(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("span", _hoisted_1$Q);
}
var CountUp = /* @__PURE__ */ _export_sfc(_sfc_main$1D, [["render", _sfc_render$1p]]);
var fecha = {};
var token = /d{1,4}|M{1,4}|yy(?:yy)?|S{1,3}|Do|ZZ|([HhMsDm])\1?|[aA]|"[^"]*"|'[^']*'/g;
var twoDigits = /\d\d?/;
var threeDigits = /\d{3}/;
var fourDigits = /\d{4}/;
var word = /[0-9]*['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+|[\u0600-\u06FF\/]+(\s*?[\u0600-\u06FF]+){1,2}/i;
var noop$1 = function() {
};
function shorten(arr, sLen) {
  var newArr = [];
  for (var i = 0, len = arr.length; i < len; i++) {
    newArr.push(arr[i].substr(0, sLen));
  }
  return newArr;
}
function monthUpdate(arrName) {
  return function(d, v, i18n2) {
    var index2 = i18n2[arrName].indexOf(v.charAt(0).toUpperCase() + v.substr(1).toLowerCase());
    if (~index2) {
      d.month = index2;
    }
  };
}
function pad(val, len) {
  val = String(val);
  len = len || 2;
  while (val.length < len) {
    val = "0" + val;
  }
  return val;
}
var dayNames = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
var monthNames = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
var monthNamesShort = shorten(monthNames, 3);
var dayNamesShort = shorten(dayNames, 3);
fecha.i18n = {
  dayNamesShort,
  dayNames,
  monthNamesShort,
  monthNames,
  amPm: ["am", "pm"],
  DoFn: function DoFn(D) {
    return D + ["th", "st", "nd", "rd"][D % 10 > 3 ? 0 : (D - D % 10 !== 10) * D % 10];
  }
};
var formatFlags = {
  D: function(dateObj) {
    return dateObj.getDay();
  },
  DD: function(dateObj) {
    return pad(dateObj.getDay());
  },
  Do: function(dateObj, i18n2) {
    return i18n2.DoFn(dateObj.getDate());
  },
  d: function(dateObj) {
    return dateObj.getDate();
  },
  dd: function(dateObj) {
    return pad(dateObj.getDate());
  },
  ddd: function(dateObj, i18n2) {
    return i18n2.dayNamesShort[dateObj.getDay()];
  },
  dddd: function(dateObj, i18n2) {
    return i18n2.dayNames[dateObj.getDay()];
  },
  M: function(dateObj) {
    return dateObj.getMonth() + 1;
  },
  MM: function(dateObj) {
    return pad(dateObj.getMonth() + 1);
  },
  MMM: function(dateObj, i18n2) {
    return i18n2.monthNamesShort[dateObj.getMonth()];
  },
  MMMM: function(dateObj, i18n2) {
    return i18n2.monthNames[dateObj.getMonth()];
  },
  yy: function(dateObj) {
    return String(dateObj.getFullYear()).substr(2);
  },
  yyyy: function(dateObj) {
    return dateObj.getFullYear();
  },
  h: function(dateObj) {
    return dateObj.getHours() % 12 || 12;
  },
  hh: function(dateObj) {
    return pad(dateObj.getHours() % 12 || 12);
  },
  H: function(dateObj) {
    return dateObj.getHours();
  },
  HH: function(dateObj) {
    return pad(dateObj.getHours());
  },
  m: function(dateObj) {
    return dateObj.getMinutes();
  },
  mm: function(dateObj) {
    return pad(dateObj.getMinutes());
  },
  s: function(dateObj) {
    return dateObj.getSeconds();
  },
  ss: function(dateObj) {
    return pad(dateObj.getSeconds());
  },
  S: function(dateObj) {
    return Math.round(dateObj.getMilliseconds() / 100);
  },
  SS: function(dateObj) {
    return pad(Math.round(dateObj.getMilliseconds() / 10), 2);
  },
  SSS: function(dateObj) {
    return pad(dateObj.getMilliseconds(), 3);
  },
  a: function(dateObj, i18n2) {
    return dateObj.getHours() < 12 ? i18n2.amPm[0] : i18n2.amPm[1];
  },
  A: function(dateObj, i18n2) {
    return dateObj.getHours() < 12 ? i18n2.amPm[0].toUpperCase() : i18n2.amPm[1].toUpperCase();
  },
  ZZ: function(dateObj) {
    var o = dateObj.getTimezoneOffset();
    return (o > 0 ? "-" : "+") + pad(Math.floor(Math.abs(o) / 60) * 100 + Math.abs(o) % 60, 4);
  }
};
var parseFlags = {
  d: [twoDigits, function(d, v) {
    d.day = v;
  }],
  M: [twoDigits, function(d, v) {
    d.month = v - 1;
  }],
  yy: [twoDigits, function(d, v) {
    var da = new Date(), cent = +("" + da.getFullYear()).substr(0, 2);
    d.year = "" + (v > 68 ? cent - 1 : cent) + v;
  }],
  h: [twoDigits, function(d, v) {
    d.hour = v;
  }],
  m: [twoDigits, function(d, v) {
    d.minute = v;
  }],
  s: [twoDigits, function(d, v) {
    d.second = v;
  }],
  yyyy: [fourDigits, function(d, v) {
    d.year = v;
  }],
  S: [/\d/, function(d, v) {
    d.millisecond = v * 100;
  }],
  SS: [/\d{2}/, function(d, v) {
    d.millisecond = v * 10;
  }],
  SSS: [threeDigits, function(d, v) {
    d.millisecond = v;
  }],
  D: [twoDigits, noop$1],
  ddd: [word, noop$1],
  MMM: [word, monthUpdate("monthNamesShort")],
  MMMM: [word, monthUpdate("monthNames")],
  a: [word, function(d, v, i18n2) {
    var val = v.toLowerCase();
    if (val === i18n2.amPm[0]) {
      d.isPm = false;
    } else if (val === i18n2.amPm[1]) {
      d.isPm = true;
    }
  }],
  ZZ: [/[\+\-]\d\d:?\d\d/, function(d, v) {
    var parts = (v + "").match(/([\+\-]|\d\d)/gi), minutes;
    if (parts) {
      minutes = +(parts[1] * 60) + parseInt(parts[2], 10);
      d.timezoneOffset = parts[0] === "+" ? minutes : -minutes;
    }
  }]
};
parseFlags.DD = parseFlags.DD;
parseFlags.dddd = parseFlags.ddd;
parseFlags.Do = parseFlags.dd = parseFlags.d;
parseFlags.mm = parseFlags.m;
parseFlags.hh = parseFlags.H = parseFlags.HH = parseFlags.h;
parseFlags.MM = parseFlags.M;
parseFlags.ss = parseFlags.s;
parseFlags.A = parseFlags.a;
fecha.masks = {
  "default": "ddd MMM dd yyyy HH:mm:ss",
  shortDate: "M/D/yy",
  mediumDate: "MMM d, yyyy",
  longDate: "MMMM d, yyyy",
  fullDate: "dddd, MMMM d, yyyy",
  shortTime: "HH:mm",
  mediumTime: "HH:mm:ss",
  longTime: "HH:mm:ss.SSS"
};
fecha.format = function(dateObj, mask, i18nSettings) {
  var i18n2 = i18nSettings || fecha.i18n;
  if (typeof dateObj === "number") {
    dateObj = new Date(dateObj);
  }
  if (Object.prototype.toString.call(dateObj) !== "[object Date]" || isNaN(dateObj.getTime())) {
    throw new Error("Invalid Date in fecha.format");
  }
  mask = fecha.masks[mask] || mask || fecha.masks["default"];
  return mask.replace(token, function($0) {
    return $0 in formatFlags ? formatFlags[$0](dateObj, i18n2) : $0.slice(1, $0.length - 1);
  });
};
fecha.parse = function(dateStr, format2, i18nSettings) {
  var i18n2 = i18nSettings || fecha.i18n;
  if (typeof format2 !== "string") {
    throw new Error("Invalid format in fecha.parse");
  }
  format2 = fecha.masks[format2] || format2;
  if (dateStr.length > 1e3) {
    return false;
  }
  var isValid2 = true;
  var dateInfo = {};
  format2.replace(token, function($0) {
    if (parseFlags[$0]) {
      var info = parseFlags[$0];
      var index2 = dateStr.search(info[0]);
      if (!~index2) {
        isValid2 = false;
      } else {
        dateStr.replace(info[0], function(result) {
          info[1](dateInfo, result, i18n2);
          dateStr = dateStr.substr(index2 + result.length);
          return result;
        });
      }
    }
    return parseFlags[$0] ? "" : $0.slice(1, $0.length - 1);
  });
  if (!isValid2) {
    return false;
  }
  var today = new Date();
  if (dateInfo.isPm === true && dateInfo.hour != null && +dateInfo.hour !== 12) {
    dateInfo.hour = +dateInfo.hour + 12;
  } else if (dateInfo.isPm === false && +dateInfo.hour === 12) {
    dateInfo.hour = 0;
  }
  var date3;
  if (dateInfo.timezoneOffset != null) {
    dateInfo.minute = +(dateInfo.minute || 0) - +dateInfo.timezoneOffset;
    date3 = new Date(Date.UTC(
      dateInfo.year || today.getFullYear(),
      dateInfo.month || 0,
      dateInfo.day || 1,
      dateInfo.hour || 0,
      dateInfo.minute || 0,
      dateInfo.second || 0,
      dateInfo.millisecond || 0
    ));
  } else {
    date3 = new Date(
      dateInfo.year || today.getFullYear(),
      dateInfo.month || 0,
      dateInfo.day || 1,
      dateInfo.hour || 0,
      dateInfo.minute || 0,
      dateInfo.second || 0,
      dateInfo.millisecond || 0
    );
  }
  return date3;
};
const toDate = function(date3) {
  let _date = new Date(date3);
  if (isNaN(_date.getTime()) && typeof date3 === "string") {
    _date = date3.split("-").map(Number);
    _date[1] += 1;
    _date = new Date(..._date);
  }
  if (isNaN(_date.getTime()))
    return null;
  return _date;
};
const clearHours = function(time) {
  const cloneDate = new Date(time);
  cloneDate.setHours(0, 0, 0, 0);
  return cloneDate.getTime();
};
const isInRange = (time, a, b) => {
  if (!a || !b)
    return false;
  const [start, end] = [a, b].sort();
  return time >= start && time <= end;
};
const formatDate = function(date3, format2) {
  date3 = toDate(date3);
  if (!date3)
    return "";
  return fecha.format(date3, format2 || "yyyy-MM-dd");
};
const parseDate = function(string2, format2) {
  return fecha.parse(string2, format2 || "yyyy-MM-dd");
};
const getDayCountOfMonth = function(year, month) {
  return new Date(year, month + 1, 0).getDate();
};
const siblingMonth = function(src, diff) {
  const temp = new Date(src);
  const newMonth = temp.getMonth() + diff;
  const newMonthDayCount = getDayCountOfMonth(temp.getFullYear(), newMonth);
  if (newMonthDayCount < temp.getDate()) {
    temp.setDate(newMonthDayCount);
  }
  temp.setMonth(newMonth);
  return temp;
};
const initTimeDate = function() {
  const date3 = new Date();
  date3.setHours(0);
  date3.setMinutes(0);
  date3.setSeconds(0);
  return date3;
};
const formatDateLabels = function() {
  const formats = {
    yyyy: (date3) => date3.getFullYear(),
    m: (date3) => date3.getMonth() + 1,
    mm: (date3) => ("0" + (date3.getMonth() + 1)).slice(-2),
    mmm: (date3, locale2) => {
      const monthName = date3.toLocaleDateString(locale2, {
        month: "long"
      });
      return monthName.slice(0, 3);
    },
    Mmm: (date3, locale2) => {
      const monthName = date3.toLocaleDateString(locale2, {
        month: "long"
      });
      return (monthName[0].toUpperCase() + monthName.slice(1).toLowerCase()).slice(0, 3);
    },
    mmmm: (date3, locale2) => date3.toLocaleDateString(locale2, {
      month: "long"
    }),
    Mmmm: (date3, locale2) => {
      const monthName = date3.toLocaleDateString(locale2, {
        month: "long"
      });
      return monthName[0].toUpperCase() + monthName.slice(1).toLowerCase();
    }
  };
  const formatRegex = new RegExp(["yyyy", "Mmmm", "mmmm", "Mmm", "mmm", "mm", "m"].join("|"), "g");
  return function(locale2, format2, date3) {
    const componetsRegex = /(\[[^\]]+\])([^\[\]]+)(\[[^\]]+\])/;
    const components2 = format2.match(componetsRegex).slice(1);
    const separator = components2[1];
    const labels2 = [components2[0], components2[2]].map((component) => {
      const label = component.replace(/\[[^\]]+\]/, (str) => {
        return str.slice(1, -1).replace(formatRegex, (match) => formats[match](date3, locale2));
      });
      return {
        label,
        type: component.indexOf("yy") != -1 ? "year" : "month"
      };
    });
    return {
      separator,
      labels: labels2
    };
  };
}();
const DEFAULT_FORMATS = {
  date: "yyyy-MM-dd",
  month: "yyyy-MM",
  year: "yyyy",
  datetime: "yyyy-MM-dd HH:mm:ss",
  time: "HH:mm:ss",
  timerange: "HH:mm:ss",
  daterange: "yyyy-MM-dd",
  datetimerange: "yyyy-MM-dd HH:mm:ss"
};
const DATE_FORMATTER = function(value, format2) {
  return formatDate(value, format2);
};
const DATE_PARSER = function(text, format2) {
  return parseDate(text, format2);
};
const RANGE_FORMATTER = function(value, format2, RANGE_SEPARATOR) {
  if (Array.isArray(value) && value.length === 2) {
    const start = value[0];
    const end = value[1];
    if (start && end) {
      return formatDate(start, format2) + RANGE_SEPARATOR + formatDate(end, format2);
    }
  } else if (!Array.isArray(value) && value instanceof Date) {
    return formatDate(value, format2);
  }
  return "";
};
const RANGE_PARSER = function(text, format2, RANGE_SEPARATOR) {
  const array3 = Array.isArray(text) ? text : text.split(RANGE_SEPARATOR);
  if (array3.length === 2) {
    const range1 = array3[0];
    const range2 = array3[1];
    return [
      range1 instanceof Date ? range1 : parseDate(range1, format2),
      range2 instanceof Date ? range2 : parseDate(range2, format2)
    ];
  }
  return [];
};
const TYPE_VALUE_RESOLVER_MAP = {
  default: {
    formatter(value) {
      if (!value)
        return "";
      return "" + value;
    },
    parser(text) {
      if (text === void 0 || text === "")
        return null;
      return text;
    }
  },
  date: {
    formatter: DATE_FORMATTER,
    parser: DATE_PARSER
  },
  datetime: {
    formatter: DATE_FORMATTER,
    parser: DATE_PARSER
  },
  daterange: {
    formatter: RANGE_FORMATTER,
    parser: RANGE_PARSER
  },
  datetimerange: {
    formatter: RANGE_FORMATTER,
    parser: RANGE_PARSER
  },
  timerange: {
    formatter: RANGE_FORMATTER,
    parser: RANGE_PARSER
  },
  time: {
    formatter: DATE_FORMATTER,
    parser: DATE_PARSER
  },
  month: {
    formatter: DATE_FORMATTER,
    parser: DATE_PARSER
  },
  year: {
    formatter: DATE_FORMATTER,
    parser: DATE_PARSER
  },
  multiple: {
    formatter: (value, format2) => {
      return value.filter(Boolean).map((date3) => formatDate(date3, format2)).join(",");
    },
    parser: (value, format2) => {
      const values = typeof value === "string" ? value.split(",") : value;
      return values.map((value2) => {
        if (value2 instanceof Date)
          return value2;
        if (typeof value2 === "string")
          value2 = value2.trim();
        else if (typeof value2 !== "number" && !value2)
          value2 = "";
        return parseDate(value2, format2);
      });
    }
  },
  number: {
    formatter(value) {
      if (!value)
        return "";
      return "" + value;
    },
    parser(text) {
      let result = Number(text);
      if (!isNaN(text)) {
        return result;
      } else {
        return null;
      }
    }
  }
};
const prefixCls$R = "ivu-date-picker";
const pickerPrefixCls = "ivu-picker";
const isEmptyArray = (val) => val.reduce((isEmpty, str) => isEmpty && !str || typeof str === "string" && str.trim() === "", true);
const keyValueMapper = {
  40: "up",
  39: "right",
  38: "down",
  37: "left"
};
const mapPossibleValues = (key2, horizontal, vertical) => {
  if (key2 === "left")
    return horizontal * -1;
  if (key2 === "right")
    return horizontal * 1;
  if (key2 === "up")
    return vertical * 1;
  if (key2 === "down")
    return vertical * -1;
};
const pulseElement = (el) => {
  const pulseClass = "ivu-date-picker-btn-pulse";
  el.classList.add(pulseClass);
  setTimeout(() => el.classList.remove(pulseClass), 200);
};
const extractTime = (date3) => {
  if (!date3)
    return [0, 0, 0];
  return [
    date3.getHours(),
    date3.getMinutes(),
    date3.getSeconds()
  ];
};
const _sfc_main$1C = {
  mixins: [mixinsForm, globalConfig],
  components: { iInput: Input, Drop, Icon },
  directives: { clickOutside: directive },
  emits: ["on-clickoutside", "on-clear", "on-change", "on-ok", "on-open-change", "update:modelValue"],
  provide() {
    return {
      PickerInstance: this
    };
  },
  props: {
    format: {
      type: String
    },
    readonly: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    },
    editable: {
      type: Boolean,
      default: true
    },
    clearable: {
      type: Boolean,
      default: true
    },
    confirm: {
      type: Boolean,
      default: false
    },
    open: {
      type: Boolean,
      default: null
    },
    multiple: {
      type: Boolean,
      default: false
    },
    timePickerOptions: {
      type: Object,
      default: () => ({})
    },
    splitPanels: {
      type: Boolean,
      default: false
    },
    showWeekNumbers: {
      type: Boolean,
      default: false
    },
    startDate: {
      type: Date
    },
    size: {
      validator(value) {
        return oneOf(value, ["small", "large", "default"]);
      },
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.size === "" ? "default" : global2.$VIEWUI.size;
      }
    },
    placeholder: {
      type: String,
      default: ""
    },
    placement: {
      validator(value) {
        return oneOf(value, ["top", "top-start", "top-end", "bottom", "bottom-start", "bottom-end", "left", "left-start", "left-end", "right", "right-start", "right-end"]);
      },
      default: "bottom-start"
    },
    transfer: {
      type: Boolean,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.transfer === "" ? false : global2.$VIEWUI.transfer;
      }
    },
    name: {
      type: String
    },
    elementId: {
      type: String
    },
    steps: {
      type: Array,
      default: () => []
    },
    modelValue: {
      type: [Date, String, Array]
    },
    options: {
      type: Object,
      default: () => ({})
    },
    separator: {
      type: String,
      default: " - "
    },
    capture: {
      type: Boolean,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI ? true : global2.$VIEWUI.capture;
      }
    },
    transferClassName: {
      type: String
    },
    eventsEnabled: {
      type: Boolean,
      default: false
    }
  },
  data() {
    const isRange = this.type.includes("range");
    const emptyArray = isRange ? [null, null] : [null];
    const initialValue = isEmptyArray((isRange ? this.modelValue : [this.modelValue]) || []) ? emptyArray : this.parseDate(this.modelValue);
    const focusedTime = initialValue.map(extractTime);
    return {
      prefixCls: prefixCls$R,
      showClose: false,
      visible: false,
      internalValue: initialValue,
      disableClickOutSide: false,
      disableCloseUnderTransfer: false,
      selectionMode: this.onSelectionModeChange(this.type),
      forceInputRerender: 1,
      isFocused: false,
      focusedDate: initialValue[0] || this.startDate || new Date(),
      focusedTime: {
        column: 0,
        picker: 0,
        time: focusedTime,
        active: false
      },
      internalFocus: false,
      isValueNull: false,
      timeSpinnerList: [],
      panelTableList: []
    };
  },
  computed: {
    wrapperClasses() {
      return [prefixCls$R, {
        [prefixCls$R + "-focused"]: this.isFocused
      }];
    },
    publicVModelValue() {
      if (this.multiple) {
        return this.internalValue.slice();
      } else {
        const isRange = this.type.includes("range");
        let val = this.internalValue.map((date3) => date3 instanceof Date ? new Date(date3) : date3 || "");
        if (this.type.match(/^time/))
          val = val.map(this.formatDate);
        return isRange || this.multiple ? val : val[0];
      }
    },
    publicStringValue() {
      const { formatDate: formatDate2, publicVModelValue, type: type2 } = this;
      if (type2.match(/^time/))
        return publicVModelValue;
      if (this.multiple)
        return formatDate2(publicVModelValue);
      return Array.isArray(publicVModelValue) ? publicVModelValue.map(formatDate2) : formatDate2(publicVModelValue);
    },
    opened() {
      return this.open === null ? this.visible : this.open;
    },
    transition() {
      const bottomPlaced = this.placement.match(/^bottom/);
      return bottomPlaced ? "slide-up" : "slide-down";
    },
    visualValue() {
      return this.formatDate(this.internalValue);
    },
    isConfirm() {
      return this.confirm || this.type === "datetime" || this.type === "datetimerange" || this.multiple;
    },
    arrowType() {
      const config = this.globalConfig;
      let type2 = "";
      if (this.type === "time" || this.type === "timerange") {
        type2 = "ios-time-outline";
        if (config) {
          if (config.timePicker.customIcon) {
            type2 = "";
          } else if (config.timePicker.icon) {
            type2 = config.timePicker.icon;
          }
        }
      } else {
        const config2 = this.globalConfig;
        type2 = "ios-calendar-outline";
        if (config2) {
          if (config2.datePicker.customIcon) {
            type2 = "";
          } else if (config2.datePicker.icon) {
            type2 = config2.datePicker.icon;
          }
        }
      }
      if (this.showClose)
        type2 = "ios-close-circle";
      return type2;
    },
    customArrowType() {
      const config = this.globalConfig;
      let type2 = "";
      if (!this.showClose) {
        if (this.type === "time" || this.type === "timerange") {
          if (config) {
            if (config.timePicker.customIcon) {
              type2 = config.timePicker.customIcon;
            }
          }
        } else {
          if (config) {
            if (config.datePicker.customIcon) {
              type2 = config.datePicker.customIcon;
            }
          }
        }
      }
      return type2;
    },
    arrowSize() {
      const config = this.globalConfig;
      let size = "";
      if (!this.showClose) {
        if (this.type === "time" || this.type === "timerange") {
          if (config) {
            if (config.timePicker.iconSize) {
              size = config.timePicker.iconSize;
            }
          }
        } else {
          if (config) {
            if (config.datePicker.iconSize) {
              size = config.datePicker.iconSize;
            }
          }
        }
      }
      return size;
    },
    dropdownCls() {
      return {
        [prefixCls$R + "-transfer"]: this.transfer,
        [this.transferClassName]: this.transferClassName
      };
    }
  },
  methods: {
    onSelectionModeChange(type2) {
      if (type2.match(/^date/))
        type2 = "date";
      this.selectionMode = oneOf(type2, ["year", "month", "date", "time"]) && type2;
      return this.selectionMode;
    },
    handleTransferClick() {
      if (this.transfer)
        this.disableCloseUnderTransfer = true;
    },
    handleClose(e) {
      if (this.disableCloseUnderTransfer) {
        this.disableCloseUnderTransfer = false;
        return false;
      }
      if (e && e.type === "mousedown" && this.visible) {
        e.preventDefault();
        e.stopPropagation();
        return;
      }
      if (this.visible) {
        const pickerPanel = this.$refs.pickerPanel && this.$refs.pickerPanel.$el;
        if (e && pickerPanel && pickerPanel.contains(e.target))
          return;
        this.visible = false;
        e && e.preventDefault();
        e && e.stopPropagation();
        this.$emit("on-clickoutside", e);
        return;
      }
      this.isFocused = false;
      this.disableClickOutSide = false;
    },
    handleFocus(e) {
      if (this.readonly)
        return;
      this.isFocused = true;
      if (e && e.type === "focus")
        return;
      if (!this.itemDisabled) {
        this.visible = true;
      }
    },
    handleBlur(e) {
      if (this.internalFocus) {
        this.internalFocus = false;
        return;
      }
      if (this.visible) {
        e.preventDefault();
        return;
      }
      this.isFocused = false;
      this.onSelectionModeChange(this.type);
      this.internalValue = this.internalValue.slice();
      this.reset();
      this.$refs.pickerPanel.onToggleVisibility(false);
    },
    handleKeydown(e) {
      const keyCode = e.keyCode;
      if (keyCode === 9) {
        if (this.visible) {
          e.stopPropagation();
          e.preventDefault();
          if (this.isConfirm) {
            const selector = `.${pickerPrefixCls}-confirm > *`;
            const tabbable = this.$refs.drop.$el.querySelectorAll(selector);
            this.internalFocus = true;
            const element = [...tabbable][e.shiftKey ? "pop" : "shift"]();
            element.focus();
          } else {
            this.handleClose();
          }
        } else {
          this.focused = false;
        }
      }
      const arrows = [37, 38, 39, 40];
      if (!this.visible && arrows.includes(keyCode)) {
        this.visible = true;
        return;
      }
      if (keyCode === 27) {
        if (this.visible) {
          e.stopPropagation();
          this.handleClose();
        }
      }
      if (keyCode === 13) {
        const timePickers = this.timeSpinnerList.map((item) => item.timeSpinner);
        if (timePickers.length > 0) {
          const columnsPerPicker = timePickers[0].showSeconds ? 3 : 2;
          const pickerIndex = Math.floor(this.focusedTime.column / columnsPerPicker);
          const value = this.focusedTime.time[pickerIndex];
          timePickers[pickerIndex].chooseValue(value);
          return;
        }
        if (this.type.match(/range/)) {
          this.$refs.pickerPanel.handleRangePick(this.focusedDate, "date");
        } else {
          const panels = this.panelTableList.map((item) => item.panelTable);
          const compareDate = (d) => {
            const sliceIndex = ["year", "month", "date"].indexOf(this.type) + 1;
            return [d.getFullYear(), d.getMonth(), d.getDate()].slice(0, sliceIndex).join("-");
          };
          const dateIsValid = panels.find(({ cells }) => {
            return cells.find(({ date: date3, disabled }) => compareDate(date3) === compareDate(this.focusedDate) && !disabled);
          });
          if (dateIsValid)
            this.onPick(this.focusedDate, false, "date");
        }
      }
      if (!arrows.includes(keyCode))
        return;
      if (this.focusedTime.active)
        e.preventDefault();
      this.navigateDatePanel(keyValueMapper[keyCode], e.shiftKey);
    },
    reset() {
      this.$refs.pickerPanel.reset && this.$refs.pickerPanel.reset();
    },
    navigateTimePanel(direction) {
      this.focusedTime.active = true;
      const horizontal = direction.match(/left|right/);
      const vertical = direction.match(/up|down/);
      const timePickers = this.timeSpinnerList.map((item) => item.timeSpinner);
      const maxNrOfColumns = (timePickers[0].showSeconds ? 3 : 2) * timePickers.length;
      const column = ((currentColumn) => {
        const incremented = currentColumn + (horizontal ? direction === "left" ? -1 : 1 : 0);
        return (incremented + maxNrOfColumns) % maxNrOfColumns;
      })(this.focusedTime.column);
      const columnsPerPicker = maxNrOfColumns / timePickers.length;
      const pickerIndex = Math.floor(column / columnsPerPicker);
      const col = column % columnsPerPicker;
      if (horizontal) {
        const time = this.internalValue.map(extractTime);
        this.focusedTime = {
          ...this.focusedTime,
          column,
          time
        };
        timePickers.forEach((instance, i) => {
          if (i === pickerIndex)
            instance.updateFocusedTime(col, time[pickerIndex]);
          else
            instance.updateFocusedTime(-1, instance.focusedTime);
        });
      }
      if (vertical) {
        const increment = direction === "up" ? 1 : -1;
        const timeParts2 = ["hours", "minutes", "seconds"];
        const pickerPossibleValues = timePickers[pickerIndex][`${timeParts2[col]}List`];
        const currentIndex = pickerPossibleValues.findIndex(({ text }) => this.focusedTime.time[pickerIndex][col] === text);
        const nextIndex = (currentIndex + increment + pickerPossibleValues.length) % pickerPossibleValues.length;
        const nextValue = pickerPossibleValues[nextIndex].text;
        const times = this.focusedTime.time.map((time, i) => {
          if (i !== pickerIndex)
            return time;
          time[col] = nextValue;
          return time;
        });
        this.focusedTime = {
          ...this.focusedTime,
          time: times
        };
        timePickers.forEach((instance, i) => {
          if (i === pickerIndex)
            instance.updateFocusedTime(col, times[i]);
          else
            instance.updateFocusedTime(-1, instance.focusedTime);
        });
      }
    },
    navigateDatePanel(direction, shift) {
      const timePickers = this.timeSpinnerList.map((item) => item.timeSpinner);
      if (timePickers.length > 0) {
        this.navigateTimePanel(direction, shift, timePickers);
        return;
      }
      if (shift) {
        if (this.type === "year") {
          this.focusedDate = new Date(
            this.focusedDate.getFullYear() + mapPossibleValues(direction, 0, 10),
            this.focusedDate.getMonth(),
            this.focusedDate.getDate()
          );
        } else {
          this.focusedDate = new Date(
            this.focusedDate.getFullYear() + mapPossibleValues(direction, 0, 1),
            this.focusedDate.getMonth() + mapPossibleValues(direction, 1, 0),
            this.focusedDate.getDate()
          );
        }
        const position = direction.match(/left|down/) ? "prev" : "next";
        const double = direction.match(/up|down/) ? "-double" : "";
        const button = this.$refs.drop.$el.querySelector(`.ivu-date-picker-${position}-btn-arrow${double}`);
        if (button)
          pulseElement(button);
        return;
      }
      const initialDate = this.focusedDate || this.internalValue && this.internalValue[0] || new Date();
      const focusedDate = new Date(initialDate);
      if (this.type.match(/^date/)) {
        const lastOfMonth = getDayCountOfMonth(initialDate.getFullYear(), initialDate.getMonth());
        const startDay = initialDate.getDate();
        const nextDay = focusedDate.getDate() + mapPossibleValues(direction, 1, 7);
        if (nextDay < 1) {
          if (direction.match(/left|right/)) {
            focusedDate.setMonth(focusedDate.getMonth() + 1);
            focusedDate.setDate(nextDay);
          } else {
            focusedDate.setDate(startDay + Math.floor((lastOfMonth - startDay) / 7) * 7);
          }
        } else if (nextDay > lastOfMonth) {
          if (direction.match(/left|right/)) {
            focusedDate.setMonth(focusedDate.getMonth() - 1);
            focusedDate.setDate(nextDay);
          } else {
            focusedDate.setDate(startDay % 7);
          }
        } else {
          focusedDate.setDate(nextDay);
        }
      }
      if (this.type.match(/^month/)) {
        focusedDate.setMonth(focusedDate.getMonth() + mapPossibleValues(direction, 1, 3));
      }
      if (this.type.match(/^year/)) {
        focusedDate.setFullYear(focusedDate.getFullYear() + mapPossibleValues(direction, 1, 3));
      }
      this.focusedDate = focusedDate;
    },
    handleInputChange(event) {
      const isArrayValue = this.type.includes("range") || this.multiple;
      const oldValue = this.visualValue;
      const newValue = event.target.value;
      const newDate = this.parseDate(newValue);
      const disabledDateFn = this.options && typeof this.options.disabledDate === "function" && this.options.disabledDate;
      const valueToTest = isArrayValue ? newDate : newDate[0];
      const isDisabled = disabledDateFn && disabledDateFn(valueToTest);
      const isValidDate = newDate.reduce((valid, date3) => valid && date3 instanceof Date, true);
      if (newValue !== oldValue && !isDisabled && isValidDate) {
        this.emitChange(this.type);
        this.internalValue = newDate;
      } else {
        this.forceInputRerender++;
      }
    },
    handleInputMouseenter() {
      if (this.readonly || this.itemDisabled)
        return;
      if (this.visualValue && this.clearable) {
        this.showClose = true;
      }
    },
    handleInputMouseleave() {
      this.showClose = false;
    },
    handleIconClick(e) {
      if (this.showClose) {
        if (e)
          e.stopPropagation();
        this.handleClear();
      } else if (!this.itemDisabled) {
        this.handleFocus();
      }
    },
    handleClear() {
      this.visible = false;
      this.internalValue = this.internalValue.map(() => null);
      this.$emit("on-clear");
      this.handleFormItemChange("change", "");
      this.emitChange(this.type);
      this.reset();
      setTimeout(
        () => this.onSelectionModeChange(this.type),
        500
      );
    },
    emitChange(type2) {
      nextTick(() => {
        this.$emit("on-change", this.publicStringValue, type2);
        this.handleFormItemChange("change", this.publicStringValue);
      });
    },
    parseDate(val) {
      const isRange = this.type.includes("range");
      const type2 = this.type;
      const parser = (TYPE_VALUE_RESOLVER_MAP[type2] || TYPE_VALUE_RESOLVER_MAP["default"]).parser;
      const format2 = this.format || DEFAULT_FORMATS[type2];
      const multipleParser = TYPE_VALUE_RESOLVER_MAP["multiple"].parser;
      if (val && type2 === "time" && !(val instanceof Date)) {
        val = parser(val, format2, this.separator);
      } else if (this.multiple && val) {
        val = multipleParser(val, format2, this.separator);
      } else if (isRange) {
        if (!val) {
          val = [null, null];
        } else {
          if (typeof val === "string") {
            val = parser(val, format2, this.separator);
          } else if (type2 === "timerange") {
            val = parser(val, format2, this.separator).map((v) => v || "");
          } else {
            const [start, end] = val;
            if (start instanceof Date && end instanceof Date) {
              val = val.map((date3) => new Date(date3));
            } else if (typeof start === "string" && typeof end === "string") {
              val = parser(val.join(this.separator), format2, this.separator);
            } else if (!start || !end) {
              val = [null, null];
            }
          }
        }
      } else if (typeof val === "string" && type2.indexOf("time") !== 0) {
        val = parser(val, format2) || null;
      }
      return isRange || this.multiple ? val || [] : [val];
    },
    formatDate(value) {
      const format2 = DEFAULT_FORMATS[this.type];
      if (this.multiple) {
        const formatter = TYPE_VALUE_RESOLVER_MAP.multiple.formatter;
        return formatter(value, this.format || format2, this.separator);
      } else {
        const { formatter } = TYPE_VALUE_RESOLVER_MAP[this.type] || TYPE_VALUE_RESOLVER_MAP["default"];
        return formatter(value, this.format || format2, this.separator);
      }
    },
    onPick(dates, visible = false, type2) {
      if (this.multiple) {
        const pickedTimeStamp = dates.getTime();
        const indexOfPickedDate = this.internalValue.findIndex((date3) => date3 && date3.getTime() === pickedTimeStamp);
        const allDates = [...this.internalValue, dates].filter(Boolean);
        const timeStamps = allDates.map((date3) => date3.getTime()).filter((ts, i, arr) => arr.indexOf(ts) === i && i !== indexOfPickedDate);
        this.internalValue = timeStamps.map((ts) => new Date(ts));
      } else {
        dates = this.parseDate(dates);
        this.internalValue = Array.isArray(dates) ? dates : [dates];
      }
      if (this.internalValue[0])
        this.focusedDate = this.internalValue[0];
      this.focusedTime = {
        ...this.focusedTime,
        time: this.internalValue.map(extractTime)
      };
      if (!this.isConfirm)
        this.onSelectionModeChange(this.type);
      if (!this.isConfirm)
        this.visible = !!visible;
      this.emitChange(type2);
    },
    onPickSuccess() {
      this.visible = false;
      this.$emit("on-ok");
      this.focus();
      this.reset();
    },
    focus() {
      this.$refs.input && this.$refs.input.focus();
    },
    updatePopper() {
      this.$refs.drop.update();
    },
    handleOnFocusInput() {
      this.focus();
    },
    handleOnUpdatePopper() {
      this.updatePopper();
    }
  },
  watch: {
    visible(state) {
      if (state === false) {
        this.$refs.drop.destroy();
      }
      if (state)
        this.$refs.drop.update();
      this.$emit("on-open-change", state);
    },
    modelValue(val) {
      if (val === null)
        this.isValueNull = true;
      this.internalValue = this.parseDate(val);
    },
    open(val) {
      this.visible = val === true;
    },
    type(type2) {
      this.onSelectionModeChange(type2);
    },
    publicVModelValue(now2, before) {
      const newValue = JSON.stringify(now2);
      const oldValue = JSON.stringify(before);
      const shouldEmitInput = newValue !== oldValue || typeof now2 !== typeof before;
      if (shouldEmitInput) {
        if (this.isValueNull) {
          this.isValueNull = false;
          this.$emit("update:modelValue", null);
        } else {
          this.$emit("update:modelValue", now2);
        }
      }
    }
  },
  mounted() {
    if (this.open !== null)
      this.visible = this.open;
  }
};
function _sfc_render$1o(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = resolveComponent("Icon");
  const _component_i_input = resolveComponent("i-input");
  const _component_Drop = resolveComponent("Drop");
  const _directive_click_outside = resolveDirective("click-outside");
  return withDirectives((openBlock(), createElementBlock("div", {
    class: normalizeClass($options.wrapperClasses)
  }, [
    createElementVNode("div", {
      ref: "reference",
      class: normalizeClass([$data.prefixCls + "-rel"])
    }, [
      renderSlot(_ctx.$slots, "default", {}, () => [
        (openBlock(), createBlock(_component_i_input, {
          key: $data.forceInputRerender,
          "element-id": $props.elementId,
          class: normalizeClass([$data.prefixCls + "-editor"]),
          readonly: !$props.editable || $props.readonly,
          disabled: _ctx.itemDisabled,
          size: $props.size,
          placeholder: $props.placeholder,
          "model-value": $options.visualValue,
          name: $props.name,
          ref: "input",
          onOnInputChange: $options.handleInputChange,
          onOnFocus: $options.handleFocus,
          onOnBlur: $options.handleBlur,
          onClick: $options.handleFocus,
          onKeydown: $options.handleKeydown,
          onMouseenter: $options.handleInputMouseenter,
          onMouseleave: $options.handleInputMouseleave
        }, {
          suffix: withCtx(() => [
            createVNode(_component_Icon, {
              onClick: $options.handleIconClick,
              type: $options.arrowType,
              custom: $options.customArrowType,
              size: $options.arrowSize
            }, null, 8, ["onClick", "type", "custom", "size"])
          ]),
          _: 1
        }, 8, ["element-id", "class", "readonly", "disabled", "size", "placeholder", "model-value", "name", "onOnInputChange", "onOnFocus", "onOnBlur", "onClick", "onKeydown", "onMouseenter", "onMouseleave"]))
      ])
    ], 2),
    createVNode(_component_Drop, {
      ref: "drop",
      visible: $options.opened,
      classes: $options.dropdownCls,
      placement: $props.placement,
      eventsEnabled: $props.eventsEnabled,
      transfer: $props.transfer,
      "transition-name": "transition-drop",
      onClick: $options.handleTransferClick
    }, {
      default: withCtx(() => [
        createElementVNode("div", null, [
          (openBlock(), createBlock(resolveDynamicComponent(_ctx.panel), mergeProps({
            ref: "pickerPanel",
            visible: $data.visible,
            showTime: _ctx.type === "datetime" || _ctx.type === "datetimerange",
            confirm: $options.isConfirm,
            selectionMode: $data.selectionMode,
            steps: $props.steps,
            format: $props.format,
            "model-value": $data.internalValue,
            "start-date": $props.startDate,
            "split-panels": $props.splitPanels,
            "show-week-numbers": $props.showWeekNumbers,
            "picker-type": _ctx.type,
            multiple: $props.multiple,
            "focused-date": $data.focusedDate,
            "time-picker-options": $props.timePickerOptions
          }, _ctx.ownPickerProps, {
            onOnPick: $options.onPick,
            onOnPickClear: $options.handleClear,
            onOnPickSuccess: $options.onPickSuccess,
            onOnPickClick: _cache[0] || (_cache[0] = ($event) => $data.disableClickOutSide = true),
            onOnSelectionModeChange: $options.onSelectionModeChange
          }), null, 16, ["visible", "showTime", "confirm", "selectionMode", "steps", "format", "model-value", "start-date", "split-panels", "show-week-numbers", "picker-type", "multiple", "focused-date", "time-picker-options", "onOnPick", "onOnPickClear", "onOnPickSuccess", "onOnSelectionModeChange"]))
        ])
      ]),
      _: 1
    }, 8, ["visible", "classes", "placement", "eventsEnabled", "transfer", "onClick"])
  ], 2)), [
    [
      _directive_click_outside,
      $options.handleClose,
      $props.capture,
      { mousedown: true }
    ],
    [
      _directive_click_outside,
      $options.handleClose,
      $props.capture,
      { touchstart: true }
    ],
    [_directive_click_outside, $options.handleClose, $props.capture]
  ]);
}
var Picker = /* @__PURE__ */ _export_sfc(_sfc_main$1C, [["render", _sfc_render$1o]]);
var oneDay = 1e3 * 60 * 60 * 24;
function daysInMonth(year, month) {
  return new Date(year, month + 1, 0).getDate();
}
function getYear(year, month, weekNr) {
  if (month === 0 && weekNr > 50)
    return year - 1;
  else if (month === 11 && weekNr < 10)
    return year + 1;
  else
    return year;
}
function getDateInfo(y, m, d, iso) {
  if (m > 11) {
    m = 0;
    y++;
  }
  var currentDay = new Date(y, m, d);
  if (iso)
    currentDay.setDate(currentDay.getDate() + 4 - (currentDay.getDay() || 7));
  var year = iso ? currentDay.getFullYear() : y;
  var firstOfJanuary = new Date(year, 0, 1);
  var numberOfDays = 1 + Math.round((currentDay - firstOfJanuary) / oneDay);
  if (!iso)
    numberOfDays += firstOfJanuary.getDay();
  var w = Math.ceil(numberOfDays / 7);
  if (!iso) {
    var initialDay = new Date(y, m, d);
    var beginOfNextYear = new Date(y + 1, 0, 1);
    var startDayOfNextYear = beginOfNextYear.getDay();
    if (initialDay.getTime() >= beginOfNextYear.getTime() - oneDay * startDayOfNextYear)
      w = 1;
  }
  return w;
}
function getMonthCalender(year, month, iteratorFns) {
  var lang2 = this.lang || "en";
  var onlyDays = this.onlyDays;
  var weekStart = typeof this.weekStart === "undefined" ? 1 : this.weekStart;
  var iso = weekStart === 1;
  var cells = [];
  var monthStartDate = new Date(year, month, 1);
  var dayOfWeek = monthStartDate.getDay() || (iso ? 7 : 0);
  var currentDay = weekStart - dayOfWeek;
  var weekNr = getDateInfo(year, month, 1, iso);
  var maxDays = daysInMonth(year, month);
  var lastMonthMaxDays = daysInMonth(year, month - 1);
  var currentMonth, day, dayBefore;
  var currentYear = getYear(year, month, weekNr);
  var returnObject = {
    month,
    year,
    daysInMonth: maxDays
  };
  for (var i = 0; i < 7; i++) {
    dayBefore = currentDay;
    for (var j = 0; j < 8; j++) {
      if (i > 0 && j > 0)
        currentDay++;
      if (currentDay > maxDays || currentDay < 1) {
        day = currentDay > maxDays ? currentDay - maxDays : lastMonthMaxDays + currentDay;
        currentMonth = currentDay > maxDays ? month + 1 : month - 1;
      } else {
        day = currentDay;
        currentMonth = month;
      }
      var type2 = function() {
        if (j === 0)
          return "weekLabel";
        else if (i === 0)
          return "dayLabel";
        else if (currentDay < 1)
          return "prevMonth";
        else if (currentDay > maxDays)
          return "nextMonth";
        else
          return "monthDay";
      }();
      var isDay = dayBefore !== currentDay && i > 0;
      var dayData = {
        desc: isDay ? day : weekNr,
        week: weekNr,
        type: type2,
        format: iso ? "ISO 8601" : "US",
        date: isDay ? new Date(Date.UTC(year, currentMonth, day)) : false,
        year: currentYear,
        index: cells.length
      };
      if (iteratorFns) {
        if (typeof iteratorFns === "function")
          dayData = iteratorFns.call(returnObject, dayData, lang2);
        else
          iteratorFns.forEach(function(fn) {
            dayData = fn.call(returnObject, dayData, lang2);
          });
      }
      if (onlyDays && isDay)
        cells.push(dayData);
      else if (!onlyDays)
        cells.push(dayData);
    }
    if (i > 0)
      weekNr = getDateInfo(year, currentMonth, day + 1, iso);
    currentYear = getYear(year, month, weekNr);
  }
  returnObject.cells = cells;
  return returnObject;
}
var jsCalendar$1 = function(config) {
  return getMonthCalender.bind(config);
};
var labels$1 = {
  weekPlaceholder: "",
  columnNames: {
    en: {
      0: "w",
      1: "monday",
      2: "tuesday",
      3: "wednesday",
      4: "thursday",
      5: "friday",
      6: "saturday",
      7: "sunday"
    },
    sv: {
      0: "v",
      1: "m\xE5ndag",
      2: "tisdag",
      3: "onsdag",
      4: "torsdag",
      5: "fredag",
      6: "l\xF6rdag",
      7: "s\xF6ndag"
    },
    pt: {
      0: "s",
      1: "segunda",
      2: "ter\xE7a",
      3: "quarta",
      4: "quinta",
      5: "sexta",
      6: "s\xE1bado",
      7: "domingo"
    }
  },
  monthNames: {
    en: [
      "January",
      "February",
      "March",
      "April",
      "May",
      "June",
      "July",
      "August",
      "September",
      "October",
      "November",
      "December"
    ],
    sv: [
      "januari",
      "februari",
      "mars",
      "april",
      "maj",
      "juni",
      "juli",
      "augusti",
      "september",
      "oktober",
      "november",
      "december"
    ],
    pt: [
      "Janeiro",
      "Fevereiro",
      "Mar\xE7o",
      "Abril",
      "Maio",
      "Junho",
      "Julho",
      "Agosto",
      "Setembro",
      "Outubro",
      "Novembro",
      "Dezembro"
    ]
  },
  classes: {
    dayLabel: "day-of-week",
    weekLabel: "week-number",
    prevMonth: "inactive",
    nextMonth: "inactive",
    monthDay: "day-in-month"
  }
};
var labels = labels$1;
function isIterable(variable) {
  if (variable == null)
    return false;
  if (variable.constructor === Array)
    return true;
  if (variable.constructor === Object)
    return true;
  return false;
}
function merge(_new, _old) {
  for (var prop2 in _new) {
    if (!_old[prop2])
      _old[prop2] = _new[prop2];
    else if (isIterable(_new[prop2]))
      merge(_new[prop2], _old[prop2]);
  }
}
function addLabels(dayObject, lang2) {
  var cssClass = [labels.classes[dayObject.type]];
  if (dayObject.class)
    dayObject.class = (typeof dayObject.class == "string" ? [dayObject.class] : dayObject.class).concat(cssClass);
  else
    dayObject.class = cssClass;
  if (dayObject.type.indexOf("Label") > 0) {
    if (dayObject.index == 0 && labels.weekPlaceholder)
      dayObject.desc = labels.weekPlaceholder;
    else if (dayObject.index < 8)
      dayObject.desc = labels.columnNames[lang2][dayObject.index];
    else if (dayObject.index % 8 == 0)
      dayObject.desc = dayObject.week;
  }
  if (dayObject.date)
    dayObject.monthName = labels.monthNames[lang2][dayObject.date.getMonth()];
  if (!this.monthName)
    this.monthName = labels.monthNames[lang2][this.month];
  if (!this.labels)
    this.labels = {
      monthNames: labels.monthNames[lang2],
      columnNames: labels.columnNames[lang2],
      classes: labels.classes
    };
  return dayObject;
}
addLabels.setLabels = function(newOptions) {
  merge(newOptions, labels);
};
var addLabels_1 = addLabels;
var jsCalendar = {
  Generator: jsCalendar$1,
  addLabels: addLabels_1
};
var mixin$1 = {
  name: "PanelTable",
  emits: ["on-pick", "on-pick-click", "on-change-range"],
  inject: ["PickerInstance"],
  props: {
    tableDate: {
      type: Date,
      required: true
    },
    disabledDate: {
      type: Function
    },
    selectionMode: {
      type: String,
      required: true
    },
    modelValue: {
      type: Array,
      required: true
    },
    rangeState: {
      type: Object,
      default: () => ({
        from: null,
        to: null,
        selecting: false
      })
    },
    focusedDate: {
      type: Date,
      required: true
    }
  },
  data() {
    return {
      id: random(6)
    };
  },
  computed: {
    dates() {
      const { selectionMode, modelValue, rangeState } = this;
      const rangeSelecting = selectionMode === "range" && rangeState.selecting;
      return rangeSelecting ? [rangeState.from] : modelValue;
    }
  },
  methods: {
    handleClick(cell, e) {
      e.stopPropagation();
      if (cell.disabled || cell.type === "weekLabel")
        return;
      const newDate = new Date(clearHours(cell.date));
      this.$emit("on-pick", newDate);
      this.$emit("on-pick-click");
    },
    handleMouseMove(cell) {
      if (!this.rangeState.selecting)
        return;
      if (cell.disabled)
        return;
      const newDate = cell.date;
      this.$emit("on-change-range", newDate);
    },
    addPanelTable() {
      const root2 = this.PickerInstance;
      if (!root2.panelTableList)
        root2.panelTableList = [];
      root2.panelTableList.push({
        id: this.id,
        panelTable: this
      });
    },
    removePanelTable() {
      const root2 = this.PickerInstance;
      if (root2.panelTableList && root2.panelTableList.length) {
        const index2 = root2.panelTableList.findIndex((item) => item.id === this.id);
        root2.panelTableList.splice(index2, 1);
      }
    }
  },
  mounted() {
    this.addPanelTable();
  },
  beforeUnmount() {
    this.removePanelTable();
  }
};
var prefixCls$Q = "ivu-date-picker-cells";
const _sfc_main$1B = {
  mixins: [Locale, mixin$1],
  props: {
    showWeekNumbers: {
      type: Boolean,
      default: false
    }
  },
  computed: {
    classes() {
      return [
        `${prefixCls$Q}`,
        {
          [`${prefixCls$Q}-show-week-numbers`]: this.showWeekNumbers
        }
      ];
    },
    calendar() {
      const weekStartDay = Number(this.t("i.datepicker.weekStartDay"));
      return new jsCalendar.Generator({ onlyDays: !this.showWeekNumbers, weekStart: weekStartDay });
    },
    headerDays() {
      const weekStartDay = Number(this.t("i.datepicker.weekStartDay"));
      const translatedDays = ["sun", "mon", "tue", "wed", "thu", "fri", "sat"].map((item) => {
        return this.t("i.datepicker.weeks." + item);
      });
      const weekDays = translatedDays.splice(weekStartDay, 7 - weekStartDay).concat(translatedDays.splice(0, weekStartDay));
      return this.showWeekNumbers ? [""].concat(weekDays) : weekDays;
    },
    cells() {
      const tableYear = this.tableDate.getFullYear();
      const tableMonth = this.tableDate.getMonth();
      const today = clearHours(new Date());
      const selectedDays = this.dates.filter(Boolean).map(clearHours);
      const [minDay, maxDay] = this.dates.map(clearHours);
      const rangeStart = this.rangeState.from && clearHours(this.rangeState.from);
      const rangeEnd = this.rangeState.to && clearHours(this.rangeState.to);
      const isRange = this.selectionMode === "range";
      const disabledTestFn = typeof this.disabledDate === "function" && this.disabledDate;
      return this.calendar(tableYear, tableMonth, (cell) => {
        if (cell.date instanceof Date)
          cell.date.setTime(cell.date.getTime() + cell.date.getTimezoneOffset() * 6e4 + 480 * 60 * 1e3);
        const time = cell.date && clearHours(cell.date);
        const dateIsInCurrentMonth = cell.date && tableMonth === cell.date.getMonth();
        return {
          ...cell,
          type: time === today ? "today" : cell.type,
          selected: dateIsInCurrentMonth && selectedDays.includes(time),
          disabled: cell.date && disabledTestFn && disabledTestFn(new Date(time)),
          range: dateIsInCurrentMonth && isRange && isInRange(time, rangeStart, rangeEnd),
          start: dateIsInCurrentMonth && isRange && time === minDay,
          end: dateIsInCurrentMonth && isRange && time === maxDay
        };
      }).cells.slice(this.showWeekNumbers ? 8 : 0);
    }
  },
  methods: {
    getCellCls(cell) {
      return [
        `${prefixCls$Q}-cell`,
        {
          [`${prefixCls$Q}-cell-selected`]: cell.selected || cell.start || cell.end,
          [`${prefixCls$Q}-cell-disabled`]: cell.disabled,
          [`${prefixCls$Q}-cell-today`]: cell.type === "today",
          [`${prefixCls$Q}-cell-prev-month`]: cell.type === "prevMonth",
          [`${prefixCls$Q}-cell-next-month`]: cell.type === "nextMonth",
          [`${prefixCls$Q}-cell-week-label`]: cell.type === "weekLabel",
          [`${prefixCls$Q}-cell-range`]: cell.range && !cell.start && !cell.end,
          [`${prefixCls$Q}-focused`]: clearHours(cell.date) === clearHours(this.focusedDate)
        }
      ];
    }
  }
};
const _hoisted_1$P = { class: "ivu-date-picker-cells-header" };
const _hoisted_2$u = ["onClick", "onMouseenter"];
function _sfc_render$1n(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes)
  }, [
    createElementVNode("div", _hoisted_1$P, [
      (openBlock(true), createElementBlock(Fragment, null, renderList($options.headerDays, (day) => {
        return openBlock(), createElementBlock("span", { key: day }, toDisplayString(day), 1);
      }), 128))
    ]),
    (openBlock(true), createElementBlock(Fragment, null, renderList($options.cells, (cell, i) => {
      return openBlock(), createElementBlock("span", {
        key: String(cell.date) + i,
        class: normalizeClass($options.getCellCls(cell)),
        onClick: ($event) => _ctx.handleClick(cell, $event),
        onMouseenter: ($event) => _ctx.handleMouseMove(cell)
      }, [
        createElementVNode("em", null, toDisplayString(cell.desc), 1)
      ], 42, _hoisted_2$u);
    }), 128))
  ], 2);
}
var DateTable = /* @__PURE__ */ _export_sfc(_sfc_main$1B, [["render", _sfc_render$1n]]);
const _sfc_main$1A = {
  mixins: [mixin$1],
  props: {},
  computed: {
    classes() {
      return [
        `${prefixCls$Q}`,
        `${prefixCls$Q}-year`
      ];
    },
    startYear() {
      return Math.floor(this.tableDate.getFullYear() / 10) * 10;
    },
    cells() {
      let cells = [];
      const cell_tmpl = {
        text: "",
        selected: false,
        disabled: false
      };
      const selectedDays = this.dates.filter(Boolean).map((date3) => clearHours(new Date(date3.getFullYear(), 0, 1)));
      const focusedDate = clearHours(new Date(this.focusedDate.getFullYear(), 0, 1));
      for (let i = 0; i < 10; i++) {
        const cell = deepCopy(cell_tmpl);
        cell.date = new Date(this.startYear + i, 0, 1);
        cell.disabled = typeof this.disabledDate === "function" && this.disabledDate(cell.date) && this.selectionMode === "year";
        const day = clearHours(cell.date);
        cell.selected = selectedDays.includes(day);
        cell.focused = day === focusedDate;
        cells.push(cell);
      }
      return cells;
    }
  },
  methods: {
    getCellCls(cell) {
      return [
        `${prefixCls$Q}-cell`,
        {
          [`${prefixCls$Q}-cell-selected`]: cell.selected,
          [`${prefixCls$Q}-cell-disabled`]: cell.disabled,
          [`${prefixCls$Q}-cell-focused`]: cell.focused,
          [`${prefixCls$Q}-cell-range`]: cell.range && !cell.start && !cell.end
        }
      ];
    }
  }
};
const _hoisted_1$O = ["onClick", "onMouseenter"];
function _sfc_render$1m(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes)
  }, [
    (openBlock(true), createElementBlock(Fragment, null, renderList($options.cells, (cell) => {
      return openBlock(), createElementBlock("span", {
        class: normalizeClass($options.getCellCls(cell)),
        key: cell.date,
        onClick: ($event) => _ctx.handleClick(cell, $event),
        onMouseenter: ($event) => _ctx.handleMouseMove(cell)
      }, [
        createElementVNode("em", null, toDisplayString(cell.date.getFullYear()), 1)
      ], 42, _hoisted_1$O);
    }), 128))
  ], 2);
}
var YearTable = /* @__PURE__ */ _export_sfc(_sfc_main$1A, [["render", _sfc_render$1m]]);
const _sfc_main$1z = {
  mixins: [Locale, mixin$1],
  props: {},
  computed: {
    classes() {
      return [
        `${prefixCls$Q}`,
        `${prefixCls$Q}-month`
      ];
    },
    cells() {
      let cells = [];
      const cell_tmpl = {
        text: "",
        selected: false,
        disabled: false
      };
      const tableYear = this.tableDate.getFullYear();
      const selectedDays = this.dates.filter(Boolean).map((date3) => clearHours(new Date(date3.getFullYear(), date3.getMonth(), 1)));
      const focusedDate = clearHours(new Date(this.focusedDate.getFullYear(), this.focusedDate.getMonth(), 1));
      for (let i = 0; i < 12; i++) {
        const cell = deepCopy(cell_tmpl);
        cell.date = new Date(tableYear, i, 1);
        cell.text = this.tCell(i + 1);
        const day = clearHours(cell.date);
        cell.disabled = typeof this.disabledDate === "function" && this.disabledDate(cell.date) && this.selectionMode === "month";
        cell.selected = selectedDays.includes(day);
        cell.focused = day === focusedDate;
        cells.push(cell);
      }
      return cells;
    }
  },
  methods: {
    getCellCls(cell) {
      return [
        `${prefixCls$Q}-cell`,
        {
          [`${prefixCls$Q}-cell-selected`]: cell.selected,
          [`${prefixCls$Q}-cell-disabled`]: cell.disabled,
          [`${prefixCls$Q}-cell-focused`]: cell.focused,
          [`${prefixCls$Q}-cell-range`]: cell.range && !cell.start && !cell.end
        }
      ];
    },
    tCell(nr) {
      return this.t(`i.datepicker.months.m${nr}`);
    }
  }
};
const _hoisted_1$N = ["onClick", "onMouseenter"];
function _sfc_render$1l(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes)
  }, [
    (openBlock(true), createElementBlock(Fragment, null, renderList($options.cells, (cell) => {
      return openBlock(), createElementBlock("span", {
        class: normalizeClass($options.getCellCls(cell)),
        key: cell.text,
        onClick: ($event) => _ctx.handleClick(cell, $event),
        onMouseenter: ($event) => _ctx.handleMouseMove(cell)
      }, [
        createElementVNode("em", null, toDisplayString(cell.text), 1)
      ], 42, _hoisted_1$N);
    }), 128))
  ], 2);
}
var MonthTable = /* @__PURE__ */ _export_sfc(_sfc_main$1z, [["render", _sfc_render$1l]]);
var Options$1 = {
  props: {
    disabledHours: {
      type: Array,
      default() {
        return [];
      }
    },
    disabledMinutes: {
      type: Array,
      default() {
        return [];
      }
    },
    disabledSeconds: {
      type: Array,
      default() {
        return [];
      }
    },
    hideDisabledOptions: {
      type: Boolean,
      default: false
    }
  }
};
const prefixCls$P = "ivu-time-picker-cells";
const timeParts = ["hours", "minutes", "seconds"];
const _sfc_main$1y = {
  name: "TimeSpinner",
  mixins: [Options$1],
  emits: ["on-change", "on-pick-click"],
  inject: ["PickerInstance"],
  props: {
    hours: {
      type: [Number, String],
      default: NaN
    },
    minutes: {
      type: [Number, String],
      default: NaN
    },
    seconds: {
      type: [Number, String],
      default: NaN
    },
    showSeconds: {
      type: Boolean,
      default: true
    },
    steps: {
      type: Array,
      default: () => []
    }
  },
  data() {
    return {
      spinerSteps: [1, 1, 1].map((one, i) => Math.abs(this.steps[i]) || one),
      prefixCls: prefixCls$P,
      compiled: false,
      focusedColumn: -1,
      focusedTime: [0, 0, 0],
      id: random(6)
    };
  },
  computed: {
    classes() {
      return [
        `${prefixCls$P}`,
        {
          [`${prefixCls$P}-with-seconds`]: this.showSeconds
        }
      ];
    },
    hoursList() {
      let hours = [];
      const step = this.spinerSteps[0];
      const focusedHour = this.focusedColumn === 0 && this.focusedTime[0];
      const hour_tmpl = {
        text: 0,
        selected: false,
        disabled: false,
        hide: false
      };
      for (let i = 0; i < 24; i += step) {
        const hour = deepCopy(hour_tmpl);
        hour.text = i;
        hour.focused = i === focusedHour;
        if (this.disabledHours.length && this.disabledHours.indexOf(i) > -1) {
          hour.disabled = true;
          if (this.hideDisabledOptions)
            hour.hide = true;
        }
        if (this.hours === i)
          hour.selected = true;
        hours.push(hour);
      }
      return hours;
    },
    minutesList() {
      let minutes = [];
      const step = this.spinerSteps[1];
      const focusedMinute = this.focusedColumn === 1 && this.focusedTime[1];
      const minute_tmpl = {
        text: 0,
        selected: false,
        disabled: false,
        hide: false
      };
      for (let i = 0; i < 60; i += step) {
        const minute = deepCopy(minute_tmpl);
        minute.text = i;
        minute.focused = i === focusedMinute;
        if (this.disabledMinutes.length && this.disabledMinutes.indexOf(i) > -1) {
          minute.disabled = true;
          if (this.hideDisabledOptions)
            minute.hide = true;
        }
        if (this.minutes === i)
          minute.selected = true;
        minutes.push(minute);
      }
      return minutes;
    },
    secondsList() {
      let seconds = [];
      const step = this.spinerSteps[2];
      const focusedMinute = this.focusedColumn === 2 && this.focusedTime[2];
      const second_tmpl = {
        text: 0,
        selected: false,
        disabled: false,
        hide: false
      };
      for (let i = 0; i < 60; i += step) {
        const second = deepCopy(second_tmpl);
        second.text = i;
        second.focused = i === focusedMinute;
        if (this.disabledSeconds.length && this.disabledSeconds.indexOf(i) > -1) {
          second.disabled = true;
          if (this.hideDisabledOptions)
            second.hide = true;
        }
        if (this.seconds === i)
          second.selected = true;
        seconds.push(second);
      }
      return seconds;
    }
  },
  methods: {
    getCellCls(cell) {
      return [
        `${prefixCls$P}-cell`,
        {
          [`${prefixCls$P}-cell-selected`]: cell.selected,
          [`${prefixCls$P}-cell-focused`]: cell.focused,
          [`${prefixCls$P}-cell-disabled`]: cell.disabled
        }
      ];
    },
    chooseValue(values) {
      const changes = timeParts.reduce((obj, part, i) => {
        const value = values[i];
        if (this[part] === value)
          return obj;
        return {
          ...obj,
          [part]: value
        };
      }, {});
      if (Object.keys(changes).length > 0) {
        this.emitChange(changes);
      }
    },
    handleClick(type2, cell) {
      if (cell.disabled)
        return;
      const data = { [type2]: cell.text };
      this.emitChange(data);
    },
    emitChange(changes) {
      this.$emit("on-change", changes);
      this.$emit("on-pick-click");
    },
    scroll(type2, index2) {
      const from = this.$refs[type2].scrollTop;
      const to = 24 * this.getScrollIndex(type2, index2);
      scrollTop(this.$refs[type2], from, to, 500);
    },
    getScrollIndex(type2, index2) {
      const Type = firstUpperCase(type2);
      const disabled = this[`disabled${Type}`];
      if (disabled.length && this.hideDisabledOptions) {
        let _count = 0;
        disabled.forEach((item) => item <= index2 ? _count++ : "");
        index2 -= _count;
      }
      return index2;
    },
    updateScroll() {
      nextTick(() => {
        timeParts.forEach((type2) => {
          this.$refs[type2].scrollTop = 24 * this[`${type2}List`].findIndex((obj) => obj.text == this[type2]);
        });
      });
    },
    formatTime(text) {
      return text < 10 ? "0" + text : text;
    },
    updateFocusedTime(col, time) {
      this.focusedColumn = col;
      this.focusedTime = time.slice();
    },
    addTimeSpinner() {
      const root2 = this.PickerInstance;
      if (!root2.timeSpinnerList)
        root2.timeSpinnerList = [];
      root2.timeSpinnerList.push({
        id: this.id,
        timeSpinner: this
      });
    },
    removeTimeSpinner() {
      const root2 = this.PickerInstance;
      if (root2.timeSpinnerList && root2.timeSpinnerList.length) {
        const index2 = root2.timeSpinnerList.findIndex((item) => item.id === this.id);
        root2.timeSpinnerList.splice(index2, 1);
      }
    }
  },
  watch: {
    hours(val) {
      if (!this.compiled)
        return;
      this.scroll("hours", this.hoursList.findIndex((obj) => obj.text == val));
    },
    minutes(val) {
      if (!this.compiled)
        return;
      this.scroll("minutes", this.minutesList.findIndex((obj) => obj.text == val));
    },
    seconds(val) {
      if (!this.compiled)
        return;
      this.scroll("seconds", this.secondsList.findIndex((obj) => obj.text == val));
    },
    focusedTime(updated, old) {
      timeParts.forEach((part, i) => {
        if (updated[i] === old[i] || typeof updated[i] === "undefined")
          return;
        const valueIndex = this[`${part}List`].findIndex((obj) => obj.text === updated[i]);
        this.scroll(part, valueIndex);
      });
    }
  },
  mounted() {
    this.addTimeSpinner();
    nextTick(() => this.compiled = true);
  },
  beforeUnmount() {
    this.removeTimeSpinner();
  }
};
const _hoisted_1$M = ["onClick"];
const _hoisted_2$t = ["onClick"];
const _hoisted_3$p = ["onClick"];
function _sfc_render$1k(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes)
  }, [
    createElementVNode("div", {
      class: normalizeClass([$data.prefixCls + "-list"]),
      ref: "hours"
    }, [
      createElementVNode("ul", {
        class: normalizeClass([$data.prefixCls + "-ul"])
      }, [
        (openBlock(true), createElementBlock(Fragment, null, renderList($options.hoursList, (item) => {
          return withDirectives((openBlock(), createElementBlock("li", {
            class: normalizeClass($options.getCellCls(item)),
            key: item.text,
            onClick: ($event) => $options.handleClick("hours", item)
          }, toDisplayString($options.formatTime(item.text)), 11, _hoisted_1$M)), [
            [vShow, !item.hide]
          ]);
        }), 128))
      ], 2)
    ], 2),
    createElementVNode("div", {
      class: normalizeClass([$data.prefixCls + "-list"]),
      ref: "minutes"
    }, [
      createElementVNode("ul", {
        class: normalizeClass([$data.prefixCls + "-ul"])
      }, [
        (openBlock(true), createElementBlock(Fragment, null, renderList($options.minutesList, (item) => {
          return withDirectives((openBlock(), createElementBlock("li", {
            class: normalizeClass($options.getCellCls(item)),
            key: item.text,
            onClick: ($event) => $options.handleClick("minutes", item)
          }, toDisplayString($options.formatTime(item.text)), 11, _hoisted_2$t)), [
            [vShow, !item.hide]
          ]);
        }), 128))
      ], 2)
    ], 2),
    withDirectives(createElementVNode("div", {
      class: normalizeClass([$data.prefixCls + "-list"]),
      ref: "seconds"
    }, [
      createElementVNode("ul", {
        class: normalizeClass([$data.prefixCls + "-ul"])
      }, [
        (openBlock(true), createElementBlock(Fragment, null, renderList($options.secondsList, (item) => {
          return withDirectives((openBlock(), createElementBlock("li", {
            class: normalizeClass($options.getCellCls(item)),
            key: item.text,
            onClick: ($event) => $options.handleClick("seconds", item)
          }, toDisplayString($options.formatTime(item.text)), 11, _hoisted_3$p)), [
            [vShow, !item.hide]
          ]);
        }), 128))
      ], 2)
    ], 2), [
      [vShow, $props.showSeconds]
    ])
  ], 2);
}
var TimeSpinner = /* @__PURE__ */ _export_sfc(_sfc_main$1y, [["render", _sfc_render$1k]]);
const prefixCls$O = "ivu-picker";
const _sfc_main$1x = {
  mixins: [Locale],
  components: { iButton: _sfc_main$2c },
  emits: ["on-pick-clear", "on-pick-success", "on-pick-toggle-time"],
  inject: ["PickerInstance"],
  props: {
    showTime: {
      type: Boolean,
      default: false
    },
    isTime: {
      type: Boolean,
      default: false
    },
    timeDisabled: {
      type: Boolean,
      default: false
    }
  },
  data() {
    return {
      prefixCls: prefixCls$O
    };
  },
  computed: {
    timeClasses() {
      return `${prefixCls$O}-confirm-time`;
    },
    labels() {
      const labels2 = ["time", "clear", "ok"];
      const values = [this.isTime ? "selectDate" : "selectTime", "clear", "ok"];
      return labels2.reduce((obj, key2, i) => {
        obj[key2] = this.t("i.datepicker." + values[i]);
        return obj;
      }, {});
    }
  },
  methods: {
    handleClear() {
      this.$emit("on-pick-clear");
    },
    handleSuccess() {
      this.$emit("on-pick-success");
    },
    handleToggleTime() {
      if (this.timeDisabled)
        return;
      this.$emit("on-pick-toggle-time");
      this.PickerInstance.handleOnFocusInput();
      this.PickerInstance.handleOnUpdatePopper();
    },
    handleTab(e) {
      const tabbables = [...this.$el.children];
      const expectedFocus = tabbables[e.shiftKey ? "shift" : "pop"]();
      if (isClient && document.activeElement === expectedFocus) {
        e.preventDefault();
        e.stopPropagation();
        this.PickerInstance.handleOnFocusInput();
      }
    }
  }
};
function _sfc_render$1j(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_i_button = resolveComponent("i-button");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass([$data.prefixCls + "-confirm"]),
    onKeydownCapture: _cache[0] || (_cache[0] = withKeys((...args) => $options.handleTab && $options.handleTab(...args), ["tab"]))
  }, [
    $props.showTime ? (openBlock(), createBlock(_component_i_button, {
      key: 0,
      class: normalizeClass($options.timeClasses),
      size: "small",
      type: "text",
      disabled: $props.timeDisabled,
      onClick: $options.handleToggleTime
    }, {
      default: withCtx(() => [
        createTextVNode(toDisplayString($options.labels.time), 1)
      ]),
      _: 1
    }, 8, ["class", "disabled", "onClick"])) : createCommentVNode("", true),
    createVNode(_component_i_button, {
      size: "small",
      class: "ivu-picker-confirm-btn-cancel",
      onClick: $options.handleClear,
      onKeydown: withKeys($options.handleClear, ["enter"])
    }, {
      default: withCtx(() => [
        createTextVNode(toDisplayString($options.labels.clear), 1)
      ]),
      _: 1
    }, 8, ["onClick", "onKeydown"]),
    createVNode(_component_i_button, {
      size: "small",
      type: "primary",
      onClick: $options.handleSuccess,
      onKeydown: withKeys($options.handleSuccess, ["enter"])
    }, {
      default: withCtx(() => [
        createTextVNode(toDisplayString($options.labels.ok), 1)
      ]),
      _: 1
    }, 8, ["onClick", "onKeydown"])
  ], 34);
}
var Confirm = /* @__PURE__ */ _export_sfc(_sfc_main$1x, [["render", _sfc_render$1j]]);
const prefixCls$N = "ivu-picker-panel";
const datePrefixCls$2 = "ivu-date-picker";
var Mixin$1 = {
  emits: ["on-pick-clear", "on-pick-success", "on-pick-click", "on-pick"],
  props: {
    confirm: {
      type: Boolean,
      default: false
    }
  },
  methods: {
    iconBtnCls(direction, type2 = "") {
      return [
        `${prefixCls$N}-icon-btn`,
        `${datePrefixCls$2}-${direction}-btn`,
        `${datePrefixCls$2}-${direction}-btn-arrow${type2}`
      ];
    },
    handleShortcutClick(shortcut) {
      if (shortcut.value)
        this.$emit("on-pick", shortcut.value());
      if (shortcut.onClick)
        shortcut.onClick(this);
    },
    handlePickClear() {
      this.resetView();
      this.$emit("on-pick-clear");
    },
    handlePickSuccess() {
      this.resetView();
      this.$emit("on-pick-success");
    },
    handlePickClick() {
      this.$emit("on-pick-click");
    },
    resetView() {
      setTimeout(
        () => this.currentView = this.selectionMode,
        500
      );
    },
    handleClear() {
      this.dates = this.dates.map(() => null);
      this.rangeState = {};
      this.$emit("on-pick", this.dates);
      this.handleConfirm();
    },
    handleConfirm(visible, type2) {
      this.$emit("on-pick", this.dates, visible, type2 || this.type);
    },
    onToggleVisibility(open) {
      const { timeSpinner, timeSpinnerEnd } = this.$refs;
      if (open && timeSpinner)
        timeSpinner.updateScroll();
      if (open && timeSpinnerEnd)
        timeSpinnerEnd.updateScroll();
    }
  }
};
const prefixCls$M = "ivu-picker-panel";
const timePrefixCls$1 = "ivu-time-picker";
const capitalize$1 = (str) => str[0].toUpperCase() + str.slice(1);
const mergeDateHMS = (date3, hours, minutes, seconds) => {
  const newDate = new Date(date3.getTime());
  newDate.setHours(hours);
  newDate.setMinutes(minutes);
  newDate.setSeconds(seconds);
  return newDate;
};
const unique = (el, i, arr) => arr.indexOf(el) === i;
const returnFalse = () => false;
const _sfc_main$1w = {
  name: "TimePickerPanel",
  mixins: [Mixin$1, Locale, Options$1],
  components: { TimeSpinner, Confirm },
  emits: ["on-pick"],
  props: {
    disabledDate: {
      type: Function,
      default: returnFalse
    },
    steps: {
      type: Array,
      default: () => []
    },
    format: {
      type: String,
      default: "HH:mm:ss"
    },
    modelValue: {
      type: Array,
      required: true
    }
  },
  data() {
    return {
      prefixCls: prefixCls$M,
      timePrefixCls: timePrefixCls$1,
      date: this.modelValue[0] || initTimeDate(),
      showDate: false
    };
  },
  computed: {
    showSeconds() {
      return !!(this.format || "").match(/ss/);
    },
    visibleDate() {
      const date3 = this.date;
      const month = date3.getMonth() + 1;
      const tYear = this.t("i.datepicker.year");
      const tMonth = this.t(`i.datepicker.month${month}`);
      return `${date3.getFullYear()}${tYear} ${tMonth}`;
    },
    timeSlots() {
      if (!this.modelValue[0])
        return [];
      return ["getHours", "getMinutes", "getSeconds"].map((slot) => this.date[slot]());
    },
    disabledHMS() {
      const disabledTypes = ["disabledHours", "disabledMinutes", "disabledSeconds"];
      if (this.disabledDate === returnFalse || !this.modelValue[0]) {
        const disabled = disabledTypes.reduce(
          (obj, type2) => (obj[type2] = this[type2], obj),
          {}
        );
        return disabled;
      } else {
        const slots = [24, 60, 60];
        const disabled = ["Hours", "Minutes", "Seconds"].map((type2) => this[`disabled${type2}`]);
        const disabledHMS = disabled.map((preDisabled, j) => {
          const slot = slots[j];
          const toDisable = preDisabled;
          for (let i = 0; i < slot; i += this.steps[j] || 1) {
            const hms = this.timeSlots.map((slot2, x) => x === j ? i : slot2);
            const testDateTime = mergeDateHMS(this.date, ...hms);
            if (this.disabledDate(testDateTime, true))
              toDisable.push(i);
          }
          return toDisable.filter(unique);
        });
        return disabledTypes.reduce(
          (obj, type2, i) => (obj[type2] = disabledHMS[i], obj),
          {}
        );
      }
    }
  },
  watch: {
    modelValue(dates) {
      let newVal = dates[0] || initTimeDate();
      newVal = new Date(newVal);
      this.date = newVal;
    }
  },
  methods: {
    handleChange(date3, emit = true) {
      const newDate = new Date(this.date);
      Object.keys(date3).forEach(
        (type2) => newDate[`set${capitalize$1(type2)}`](date3[type2])
      );
      if (emit)
        this.$emit("on-pick", newDate, "time");
    }
  },
  mounted() {
    if (this.$parent && this.$parent.$options.name === "DatePicker")
      this.showDate = true;
  }
};
function _sfc_render$1i(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_time_spinner = resolveComponent("time-spinner");
  const _component_Confirm = resolveComponent("Confirm");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass([$data.prefixCls + "-body-wrapper"]),
    onMousedown: _cache[0] || (_cache[0] = withModifiers(() => {
    }, ["prevent"]))
  }, [
    createElementVNode("div", {
      class: normalizeClass([$data.prefixCls + "-body"])
    }, [
      $data.showDate ? (openBlock(), createElementBlock("div", {
        key: 0,
        class: normalizeClass([$data.timePrefixCls + "-header"])
      }, toDisplayString($options.visibleDate), 3)) : createCommentVNode("", true),
      createElementVNode("div", {
        class: normalizeClass([$data.prefixCls + "-content"])
      }, [
        createVNode(_component_time_spinner, {
          ref: "timeSpinner",
          "show-seconds": $options.showSeconds,
          steps: $props.steps,
          hours: $options.timeSlots[0],
          minutes: $options.timeSlots[1],
          seconds: $options.timeSlots[2],
          "disabled-hours": $options.disabledHMS.disabledHours,
          "disabled-minutes": $options.disabledHMS.disabledMinutes,
          "disabled-seconds": $options.disabledHMS.disabledSeconds,
          "hide-disabled-options": _ctx.hideDisabledOptions,
          onOnChange: $options.handleChange,
          onOnPickClick: _ctx.handlePickClick
        }, null, 8, ["show-seconds", "steps", "hours", "minutes", "seconds", "disabled-hours", "disabled-minutes", "disabled-seconds", "hide-disabled-options", "onOnChange", "onOnPickClick"])
      ], 2),
      _ctx.confirm ? (openBlock(), createBlock(_component_Confirm, {
        key: 1,
        onOnPickClear: _ctx.handlePickClear,
        onOnPickSuccess: _ctx.handlePickSuccess
      }, null, 8, ["onOnPickClear", "onOnPickSuccess"])) : createCommentVNode("", true)
    ], 2)
  ], 34);
}
var TimePickerPanel = /* @__PURE__ */ _export_sfc(_sfc_main$1w, [["render", _sfc_render$1i]]);
const _sfc_main$1v = {
  props: {
    datePanelLabel: Object,
    currentView: String,
    datePrefixCls: String
  }
};
function _sfc_render$1h(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("span", null, [
    $props.datePanelLabel ? withDirectives((openBlock(), createElementBlock("span", {
      key: 0,
      class: normalizeClass([$props.datePrefixCls + "-header-label"]),
      onClick: _cache[0] || (_cache[0] = (...args) => $props.datePanelLabel.labels[0].handler && $props.datePanelLabel.labels[0].handler(...args))
    }, toDisplayString($props.datePanelLabel.labels[0].label), 3)), [
      [vShow, $props.datePanelLabel.labels[0].type === "year" || $props.currentView === "date"]
    ]) : createCommentVNode("", true),
    $props.datePanelLabel && $props.currentView === "date" ? (openBlock(), createElementBlock(Fragment, { key: 1 }, [
      createTextVNode(toDisplayString($props.datePanelLabel.separator), 1)
    ], 64)) : createCommentVNode("", true),
    $props.datePanelLabel ? withDirectives((openBlock(), createElementBlock("span", {
      key: 2,
      class: normalizeClass([$props.datePrefixCls + "-header-label"]),
      onClick: _cache[1] || (_cache[1] = (...args) => $props.datePanelLabel.labels[1].handler && $props.datePanelLabel.labels[1].handler(...args))
    }, toDisplayString($props.datePanelLabel.labels[1].label), 3)), [
      [vShow, $props.datePanelLabel.labels[1].type === "year" || $props.currentView === "date"]
    ]) : createCommentVNode("", true)
  ]);
}
var datePanelLabel = /* @__PURE__ */ _export_sfc(_sfc_main$1v, [["render", _sfc_render$1h]]);
var DateMixin = {
  props: {
    showTime: {
      type: Boolean,
      default: false
    },
    format: {
      type: String,
      default: "yyyy-MM-dd"
    },
    selectionMode: {
      type: String,
      validator(value) {
        return oneOf(value, ["year", "month", "date", "time"]);
      },
      default: "date"
    },
    shortcuts: {
      type: Array,
      default: () => []
    },
    disabledDate: {
      type: Function,
      default: () => false
    },
    modelValue: {
      type: Array,
      default: () => [initTimeDate(), initTimeDate()]
    },
    timePickerOptions: {
      default: () => ({}),
      type: Object
    },
    showWeekNumbers: {
      type: Boolean,
      default: false
    },
    startDate: {
      type: Date
    },
    pickerType: {
      type: String,
      require: true
    },
    focusedDate: {
      type: Date,
      required: true
    }
  },
  computed: {
    isTime() {
      return this.currentView === "time";
    }
  },
  methods: {
    handleToggleTime() {
      this.currentView = this.currentView === "time" ? "date" : "time";
    }
  }
};
const prefixCls$L = "ivu-picker-panel";
const datePrefixCls$1 = "ivu-date-picker";
const _sfc_main$1u = {
  name: "DatePickerPanel",
  mixins: [Mixin$1, Locale, DateMixin],
  components: { Icon, DateTable, YearTable, MonthTable, TimePicker: TimePickerPanel, Confirm, datePanelLabel },
  emits: ["on-selection-mode-change", "on-pick"],
  props: {
    multiple: {
      type: Boolean,
      default: false
    }
  },
  data() {
    const { selectionMode, modelValue } = this;
    const dates = modelValue.slice().sort();
    return {
      prefixCls: prefixCls$L,
      datePrefixCls: datePrefixCls$1,
      currentView: selectionMode || "date",
      pickerTable: this.getTableType(selectionMode),
      dates,
      panelDate: this.startDate || dates[0] || new Date()
    };
  },
  computed: {
    classes() {
      return [
        `${prefixCls$L}-body-wrapper`,
        {
          [`${prefixCls$L}-with-sidebar`]: this.shortcuts.length
        }
      ];
    },
    panelPickerHandlers() {
      return this.pickerTable === `${this.currentView}-table` ? this.handlePick : this.handlePreSelection;
    },
    datePanelLabel() {
      const locale2 = this.t("i.locale");
      const datePanelLabel2 = this.t("i.datepicker.datePanelLabel");
      const date3 = this.panelDate;
      const { labels: labels2, separator } = formatDateLabels(locale2, datePanelLabel2, date3);
      const handler = (type2) => {
        return () => this.pickerTable = this.getTableType(type2);
      };
      return {
        separator,
        labels: labels2.map((obj) => (obj.handler = handler(obj.type), obj))
      };
    },
    timeDisabled() {
      return !this.dates[0];
    }
  },
  watch: {
    modelValue(newVal) {
      this.dates = newVal;
      const panelDate = this.multiple ? this.dates[this.dates.length - 1] : this.startDate || this.dates[0];
      this.panelDate = panelDate || new Date();
    },
    currentView(currentView) {
      this.$emit("on-selection-mode-change", currentView);
      if (this.currentView === "time") {
        nextTick(() => {
          const spinner = this.$refs.timePicker.$refs.timeSpinner;
          spinner.updateScroll();
        });
      }
    },
    selectionMode(type2) {
      this.currentView = type2;
      this.pickerTable = this.getTableType(type2);
    },
    focusedDate(date3) {
      const isDifferentYear = date3.getFullYear() !== this.panelDate.getFullYear();
      const isDifferentMonth = isDifferentYear || date3.getMonth() !== this.panelDate.getMonth();
      if (isDifferentYear || isDifferentMonth) {
        if (!this.multiple)
          this.panelDate = date3;
      }
    }
  },
  methods: {
    reset() {
      this.currentView = this.selectionMode;
      this.pickerTable = this.getTableType(this.currentView);
    },
    changeYear(dir) {
      if (this.selectionMode === "year" || this.pickerTable === "year-table") {
        this.panelDate = new Date(this.panelDate.getFullYear() + dir * 10, 0, 1);
      } else {
        this.panelDate = siblingMonth(this.panelDate, dir * 12);
      }
    },
    getTableType(currentView) {
      return currentView.match(/^time/) ? "time-picker" : `${currentView}-table`;
    },
    changeMonth(dir) {
      this.panelDate = siblingMonth(this.panelDate, dir);
    },
    handlePreSelection(value) {
      this.panelDate = value;
      if (this.pickerTable === "year-table")
        this.pickerTable = "month-table";
      else
        this.pickerTable = this.getTableType(this.currentView);
    },
    handlePick(value, type2) {
      const { selectionMode, panelDate } = this;
      if (selectionMode === "year")
        value = new Date(value.getFullYear(), 0, 1);
      else if (selectionMode === "month")
        value = new Date(panelDate.getFullYear(), value.getMonth(), 1);
      else
        value = new Date(value);
      this.dates = [value];
      this.$emit("on-pick", value, false, type2 || selectionMode);
    }
  }
};
const _hoisted_1$L = ["onClick"];
function _sfc_render$1g(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = resolveComponent("Icon");
  const _component_date_panel_label = resolveComponent("date-panel-label");
  const _component_time_picker = resolveComponent("time-picker");
  const _component_Confirm = resolveComponent("Confirm");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes),
    onMousedown: _cache[4] || (_cache[4] = withModifiers(() => {
    }, ["prevent"]))
  }, [
    _ctx.shortcuts.length ? (openBlock(), createElementBlock("div", {
      key: 0,
      class: normalizeClass([$data.prefixCls + "-sidebar"])
    }, [
      (openBlock(true), createElementBlock(Fragment, null, renderList(_ctx.shortcuts, (shortcut) => {
        return openBlock(), createElementBlock("div", {
          class: normalizeClass([$data.prefixCls + "-shortcut"]),
          key: shortcut.text,
          onClick: ($event) => _ctx.handleShortcutClick(shortcut)
        }, toDisplayString(shortcut.text), 11, _hoisted_1$L);
      }), 128))
    ], 2)) : createCommentVNode("", true),
    createElementVNode("div", {
      class: normalizeClass([$data.prefixCls + "-body"])
    }, [
      withDirectives(createElementVNode("div", {
        class: normalizeClass([$data.datePrefixCls + "-header"])
      }, [
        createElementVNode("span", {
          class: normalizeClass(_ctx.iconBtnCls("prev", "-double")),
          onClick: _cache[0] || (_cache[0] = ($event) => $options.changeYear(-1))
        }, [
          createVNode(_component_Icon, { type: "ios-arrow-back" })
        ], 2),
        $data.pickerTable === "date-table" ? withDirectives((openBlock(), createElementBlock("span", {
          key: 0,
          class: normalizeClass(_ctx.iconBtnCls("prev")),
          onClick: _cache[1] || (_cache[1] = ($event) => $options.changeMonth(-1))
        }, [
          createVNode(_component_Icon, { type: "ios-arrow-back" })
        ], 2)), [
          [vShow, $data.currentView === "date"]
        ]) : createCommentVNode("", true),
        createVNode(_component_date_panel_label, {
          "date-panel-label": $options.datePanelLabel,
          "current-view": $data.pickerTable.split("-").shift(),
          "date-prefix-cls": $data.datePrefixCls
        }, null, 8, ["date-panel-label", "current-view", "date-prefix-cls"]),
        createElementVNode("span", {
          class: normalizeClass(_ctx.iconBtnCls("next", "-double")),
          onClick: _cache[2] || (_cache[2] = ($event) => $options.changeYear(1))
        }, [
          createVNode(_component_Icon, { type: "ios-arrow-forward" })
        ], 2),
        $data.pickerTable === "date-table" ? withDirectives((openBlock(), createElementBlock("span", {
          key: 1,
          class: normalizeClass(_ctx.iconBtnCls("next")),
          onClick: _cache[3] || (_cache[3] = ($event) => $options.changeMonth(1))
        }, [
          createVNode(_component_Icon, { type: "ios-arrow-forward" })
        ], 2)), [
          [vShow, $data.currentView === "date"]
        ]) : createCommentVNode("", true)
      ], 2), [
        [vShow, $data.currentView !== "time"]
      ]),
      createElementVNode("div", {
        class: normalizeClass([$data.prefixCls + "-content"])
      }, [
        $data.currentView !== "time" ? (openBlock(), createBlock(resolveDynamicComponent($data.pickerTable), {
          key: 0,
          ref: "pickerTable",
          "table-date": $data.panelDate,
          "show-week-numbers": _ctx.showWeekNumbers,
          "model-value": $data.dates,
          "selection-mode": _ctx.selectionMode,
          "disabled-date": _ctx.disabledDate,
          "focused-date": _ctx.focusedDate,
          onOnPick: $options.panelPickerHandlers,
          onOnPickClick: _ctx.handlePickClick
        }, null, 40, ["table-date", "show-week-numbers", "model-value", "selection-mode", "disabled-date", "focused-date", "onOnPick", "onOnPickClick"])) : createCommentVNode("", true)
      ], 2),
      withDirectives(createElementVNode("div", {
        class: normalizeClass([$data.prefixCls + "-content"])
      }, [
        $data.currentView === "time" ? (openBlock(), createBlock(_component_time_picker, mergeProps({
          key: 0,
          ref: "timePicker",
          "model-value": $data.dates,
          format: _ctx.format,
          "time-disabled": $options.timeDisabled,
          "disabled-date": _ctx.disabledDate,
          "focused-date": _ctx.focusedDate
        }, _ctx.timePickerOptions, {
          onOnPick: $options.handlePick,
          onOnPickClick: _ctx.handlePickClick,
          onOnPickClear: _ctx.handlePickClear,
          onOnPickSuccess: _ctx.handlePickSuccess,
          onOnPickToggleTime: _ctx.handleToggleTime
        }), null, 16, ["model-value", "format", "time-disabled", "disabled-date", "focused-date", "onOnPick", "onOnPickClick", "onOnPickClear", "onOnPickSuccess", "onOnPickToggleTime"])) : createCommentVNode("", true)
      ], 2), [
        [vShow, _ctx.isTime]
      ]),
      _ctx.confirm ? (openBlock(), createBlock(_component_Confirm, {
        key: 0,
        "show-time": _ctx.showTime,
        "is-time": _ctx.isTime,
        onOnPickToggleTime: _ctx.handleToggleTime,
        onOnPickClear: _ctx.handlePickClear,
        onOnPickSuccess: _ctx.handlePickSuccess
      }, null, 8, ["show-time", "is-time", "onOnPickToggleTime", "onOnPickClear", "onOnPickSuccess"])) : createCommentVNode("", true)
    ], 2)
  ], 34);
}
var DatePickerPanel = /* @__PURE__ */ _export_sfc(_sfc_main$1u, [["render", _sfc_render$1g]]);
const prefixCls$K = "ivu-picker-panel";
const timePrefixCls = "ivu-time-picker";
const capitalize = (str) => str[0].toUpperCase() + str.slice(1);
const _sfc_main$1t = {
  name: "RangeTimePickerPanel",
  mixins: [Mixin$1, Locale, Options$1],
  components: { TimeSpinner, Confirm },
  emits: ["on-pick"],
  props: {
    steps: {
      type: Array,
      default: () => []
    },
    format: {
      type: String,
      default: "HH:mm:ss"
    },
    modelValue: {
      type: Array,
      required: true
    }
  },
  data() {
    const [dateStart, dateEnd] = this.modelValue.slice();
    return {
      prefixCls: prefixCls$K,
      timePrefixCls,
      showDate: false,
      dateStart: dateStart || initTimeDate(),
      dateEnd: dateEnd || initTimeDate()
    };
  },
  computed: {
    classes() {
      return [
        `${prefixCls$K}-body-wrapper`,
        `${timePrefixCls}-with-range`,
        {
          [`${timePrefixCls}-with-seconds`]: this.showSeconds
        }
      ];
    },
    showSeconds() {
      return !!(this.format || "").match(/ss/);
    },
    leftDatePanelLabel() {
      return this.panelLabelConfig(this.date);
    },
    rightDatePanelLabel() {
      return this.panelLabelConfig(this.dateEnd);
    }
  },
  watch: {
    modelValue(dates) {
      const [dateStart, dateEnd] = dates.slice();
      this.dateStart = dateStart || initTimeDate();
      this.dateEnd = dateEnd || initTimeDate();
    }
  },
  methods: {
    panelLabelConfig(date3) {
      const locale2 = this.t("i.locale");
      const datePanelLabel2 = this.t("i.datepicker.datePanelLabel");
      const { labels: labels2, separator } = formatDateLabels(locale2, datePanelLabel2, date3 || initTimeDate());
      return [labels2[0].label, separator, labels2[1].label].join("");
    },
    handleChange(start, end, emit = true) {
      const dateStart = new Date(this.dateStart);
      let dateEnd = new Date(this.dateEnd);
      Object.keys(start).forEach((type2) => {
        dateStart[`set${capitalize(type2)}`](start[type2]);
      });
      Object.keys(end).forEach((type2) => {
        dateEnd[`set${capitalize(type2)}`](end[type2]);
      });
      if (dateEnd < dateStart)
        dateEnd = dateStart;
      if (emit)
        this.$emit("on-pick", [dateStart, dateEnd], "time");
    },
    handleStartChange(date3) {
      this.handleChange(date3, {});
    },
    handleEndChange(date3) {
      this.handleChange({}, date3);
    },
    updateScroll() {
      this.$refs.timeSpinner.updateScroll();
      this.$refs.timeSpinnerEnd.updateScroll();
    }
  },
  mounted() {
    if (this.$parent && this.$parent.$options.name === "DatePicker")
      this.showDate = true;
  }
};
function _sfc_render$1f(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_time_spinner = resolveComponent("time-spinner");
  const _component_Confirm = resolveComponent("Confirm");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes),
    onMousedown: _cache[0] || (_cache[0] = withModifiers(() => {
    }, ["prevent"]))
  }, [
    createElementVNode("div", {
      class: normalizeClass([$data.prefixCls + "-body"])
    }, [
      createElementVNode("div", {
        class: normalizeClass([$data.prefixCls + "-content", $data.prefixCls + "-content-left"])
      }, [
        createElementVNode("div", {
          class: normalizeClass([$data.timePrefixCls + "-header"])
        }, [
          $data.showDate ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
            createTextVNode(toDisplayString($options.leftDatePanelLabel), 1)
          ], 64)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
            createTextVNode(toDisplayString(_ctx.t("i.datepicker.startTime")), 1)
          ], 64))
        ], 2),
        createVNode(_component_time_spinner, {
          ref: "timeSpinner",
          steps: $props.steps,
          "show-seconds": $options.showSeconds,
          hours: $props.modelValue[0] && $data.dateStart.getHours(),
          minutes: $props.modelValue[0] && $data.dateStart.getMinutes(),
          seconds: $props.modelValue[0] && $data.dateStart.getSeconds(),
          "disabled-hours": _ctx.disabledHours,
          "disabled-minutes": _ctx.disabledMinutes,
          "disabled-seconds": _ctx.disabledSeconds,
          "hide-disabled-options": _ctx.hideDisabledOptions,
          onOnChange: $options.handleStartChange,
          onOnPickClick: _ctx.handlePickClick
        }, null, 8, ["steps", "show-seconds", "hours", "minutes", "seconds", "disabled-hours", "disabled-minutes", "disabled-seconds", "hide-disabled-options", "onOnChange", "onOnPickClick"])
      ], 2),
      createElementVNode("div", {
        class: normalizeClass([$data.prefixCls + "-content", $data.prefixCls + "-content-right"])
      }, [
        createElementVNode("div", {
          class: normalizeClass([$data.timePrefixCls + "-header"])
        }, [
          $data.showDate ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
            createTextVNode(toDisplayString($options.rightDatePanelLabel), 1)
          ], 64)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
            createTextVNode(toDisplayString(_ctx.t("i.datepicker.endTime")), 1)
          ], 64))
        ], 2),
        createVNode(_component_time_spinner, {
          ref: "timeSpinnerEnd",
          steps: $props.steps,
          "show-seconds": $options.showSeconds,
          hours: $props.modelValue[1] && $data.dateEnd.getHours(),
          minutes: $props.modelValue[1] && $data.dateEnd.getMinutes(),
          seconds: $props.modelValue[1] && $data.dateEnd.getSeconds(),
          "disabled-hours": _ctx.disabledHours,
          "disabled-minutes": _ctx.disabledMinutes,
          "disabled-seconds": _ctx.disabledSeconds,
          "hide-disabled-options": _ctx.hideDisabledOptions,
          onOnChange: $options.handleEndChange,
          onOnPickClick: _ctx.handlePickClick
        }, null, 8, ["steps", "show-seconds", "hours", "minutes", "seconds", "disabled-hours", "disabled-minutes", "disabled-seconds", "hide-disabled-options", "onOnChange", "onOnPickClick"])
      ], 2),
      _ctx.confirm ? (openBlock(), createBlock(_component_Confirm, {
        key: 0,
        onOnPickClear: _ctx.handlePickClear,
        onOnPickSuccess: _ctx.handlePickSuccess
      }, null, 8, ["onOnPickClear", "onOnPickSuccess"])) : createCommentVNode("", true)
    ], 2)
  ], 34);
}
var RangeTimePickerPanel = /* @__PURE__ */ _export_sfc(_sfc_main$1t, [["render", _sfc_render$1f]]);
const prefixCls$J = "ivu-picker-panel";
const datePrefixCls = "ivu-date-picker";
const dateSorter = (a, b) => {
  if (!a || !b)
    return 0;
  return a.getTime() - b.getTime();
};
const _sfc_main$1s = {
  name: "RangeDatePickerPanel",
  mixins: [Mixin$1, Locale, DateMixin],
  components: { Icon, DateTable, YearTable, MonthTable, TimePicker: RangeTimePickerPanel, Confirm, datePanelLabel },
  props: {
    splitPanels: {
      type: Boolean,
      default: false
    }
  },
  data() {
    const [minDate, maxDate] = this.modelValue.map((date3) => date3 || initTimeDate());
    const leftPanelDate = this.startDate ? this.startDate : minDate;
    return {
      prefixCls: prefixCls$J,
      datePrefixCls,
      dates: this.modelValue,
      rangeState: { from: this.modelValue[0], to: this.modelValue[1], selecting: minDate && !maxDate },
      currentView: this.selectionMode || "range",
      leftPickerTable: `${this.selectionMode}-table`,
      rightPickerTable: `${this.selectionMode}-table`,
      leftPanelDate,
      rightPanelDate: new Date(leftPanelDate.getFullYear(), leftPanelDate.getMonth() + 1, 1)
    };
  },
  computed: {
    classes() {
      return [
        `${prefixCls$J}-body-wrapper`,
        `${datePrefixCls}-with-range`,
        {
          [`${prefixCls$J}-with-sidebar`]: this.shortcuts.length,
          [`${datePrefixCls}-with-week-numbers`]: this.showWeekNumbers
        }
      ];
    },
    panelBodyClasses() {
      return [
        prefixCls$J + "-body",
        {
          [prefixCls$J + "-body-time"]: this.showTime,
          [prefixCls$J + "-body-date"]: !this.showTime
        }
      ];
    },
    leftDatePanelLabel() {
      return this.panelLabelConfig("left");
    },
    rightDatePanelLabel() {
      return this.panelLabelConfig("right");
    },
    leftDatePanelView() {
      return this.leftPickerTable.split("-").shift();
    },
    rightDatePanelView() {
      return this.rightPickerTable.split("-").shift();
    },
    timeDisabled() {
      return !(this.dates[0] && this.dates[1]);
    },
    preSelecting() {
      const tableType = `${this.currentView}-table`;
      return {
        left: this.leftPickerTable !== tableType,
        right: this.rightPickerTable !== tableType
      };
    },
    panelPickerHandlers() {
      return {
        left: this.preSelecting.left ? this.handlePreSelection.bind(this, "left") : this.handleRangePick,
        right: this.preSelecting.right ? this.handlePreSelection.bind(this, "right") : this.handleRangePick
      };
    }
  },
  watch: {
    modelValue(newVal) {
      const minDate = newVal[0] ? toDate(newVal[0]) : null;
      const maxDate = newVal[1] ? toDate(newVal[1]) : null;
      this.dates = [minDate, maxDate].sort(dateSorter);
      this.rangeState = {
        from: this.dates[0],
        to: this.dates[1],
        selecting: false
      };
      this.setPanelDates(this.startDate || this.dates[0] || new Date());
    },
    currentView(currentView) {
      const leftMonth = this.leftPanelDate.getMonth();
      const rightMonth = this.rightPanelDate.getMonth();
      const isSameYear = this.leftPanelDate.getFullYear() === this.rightPanelDate.getFullYear();
      if (currentView === "date" && isSameYear && leftMonth === rightMonth) {
        this.changePanelDate("right", "Month", 1);
      }
      if (currentView === "month" && isSameYear) {
        this.changePanelDate("right", "FullYear", 1);
      }
      if (currentView === "year" && isSameYear) {
        this.changePanelDate("right", "FullYear", 10);
      }
    },
    selectionMode(type2) {
      this.currentView = type2 || "range";
    },
    focusedDate(date3) {
      this.setPanelDates(date3 || new Date());
    }
  },
  methods: {
    reset() {
      this.currentView = this.selectionMode;
      this.leftPickerTable = `${this.currentView}-table`;
      this.rightPickerTable = `${this.currentView}-table`;
    },
    setPanelDates(leftPanelDate) {
      this.leftPanelDate = leftPanelDate;
      const rightPanelDate = new Date(leftPanelDate.getFullYear(), leftPanelDate.getMonth() + 1, 1);
      const splitRightPanelDate = this.dates[1] ? this.dates[1].getTime() : this.dates[1];
      this.rightPanelDate = this.splitPanels ? new Date(Math.max(splitRightPanelDate, rightPanelDate.getTime())) : rightPanelDate;
    },
    panelLabelConfig(direction) {
      const locale2 = this.t("i.locale");
      const datePanelLabel2 = this.t("i.datepicker.datePanelLabel");
      const handler = (type2) => {
        const fn = type2 == "month" ? this.showMonthPicker : this.showYearPicker;
        return () => fn(direction);
      };
      const date3 = this[`${direction}PanelDate`];
      const { labels: labels2, separator } = formatDateLabels(locale2, datePanelLabel2, date3);
      return {
        separator,
        labels: labels2.map((obj) => (obj.handler = handler(obj.type), obj))
      };
    },
    prevYear(panel) {
      const increment = this.currentView === "year" ? -10 : -1;
      this.changePanelDate(panel, "FullYear", increment);
    },
    nextYear(panel) {
      const increment = this.currentView === "year" ? 10 : 1;
      this.changePanelDate(panel, "FullYear", increment);
    },
    prevMonth(panel) {
      this.changePanelDate(panel, "Month", -1);
    },
    nextMonth(panel) {
      this.changePanelDate(panel, "Month", 1);
    },
    changePanelDate(panel, type2, increment, updateOtherPanel = true) {
      const current = new Date(this[`${panel}PanelDate`]);
      if (type2 === "FullYear")
        current[`set${type2}`](current[`get${type2}`]() + increment);
      else
        current[`set${type2}`](current[`get${type2}`]() + increment, 1);
      this[`${panel}PanelDate`] = current;
      if (!updateOtherPanel)
        return;
      if (this.splitPanels) {
        const otherPanel = panel === "left" ? "right" : "left";
        if (panel === "left" && this.leftPanelDate >= this.rightPanelDate) {
          this.changePanelDate(otherPanel, type2, 1);
        }
        if (panel === "right" && this.rightPanelDate <= this.leftPanelDate) {
          this.changePanelDate(otherPanel, type2, -1);
        }
      } else {
        const otherPanel = panel === "left" ? "right" : "left";
        const currentDate = this[`${otherPanel}PanelDate`];
        const temp = new Date(currentDate);
        if (type2 === "Month") {
          const nextMonthLastDate = new Date(
            temp.getFullYear(),
            temp.getMonth() + increment + 1,
            0
          ).getDate();
          temp.setDate(Math.min(nextMonthLastDate, temp.getDate()));
        }
        temp[`set${type2}`](temp[`get${type2}`]() + increment);
        this[`${otherPanel}PanelDate`] = temp;
      }
    },
    showYearPicker(panel) {
      this[`${panel}PickerTable`] = "year-table";
    },
    showMonthPicker(panel) {
      this[`${panel}PickerTable`] = "month-table";
    },
    handlePreSelection(panel, value) {
      this[`${panel}PanelDate`] = value;
      const currentViewType = this[`${panel}PickerTable`];
      if (currentViewType === "year-table")
        this[`${panel}PickerTable`] = "month-table";
      else
        this[`${panel}PickerTable`] = `${this.currentView}-table`;
      if (!this.splitPanels) {
        const otherPanel = panel === "left" ? "right" : "left";
        this[`${otherPanel}PanelDate`] = value;
        const increment = otherPanel === "left" ? -1 : 1;
        this.changePanelDate(otherPanel, "Month", increment, false);
      }
    },
    handleRangePick(val, type2) {
      if (this.rangeState.selecting || this.currentView === "time") {
        if (this.currentView === "time") {
          this.dates = val;
        } else {
          const [minDate, maxDate] = [this.rangeState.from, val].sort(dateSorter);
          this.dates = [minDate, maxDate];
          this.rangeState = {
            from: minDate,
            to: maxDate,
            selecting: false
          };
        }
        this.handleConfirm(false, type2 || "date");
      } else {
        this.rangeState = {
          from: val,
          to: null,
          selecting: true
        };
      }
    },
    handleChangeRange(val) {
      this.rangeState.to = val;
    }
  }
};
const _hoisted_1$K = ["onClick"];
function _sfc_render$1e(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = resolveComponent("Icon");
  const _component_date_panel_label = resolveComponent("date-panel-label");
  const _component_time_picker = resolveComponent("time-picker");
  const _component_Confirm = resolveComponent("Confirm");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes),
    onMousedown: _cache[8] || (_cache[8] = withModifiers(() => {
    }, ["prevent"]))
  }, [
    _ctx.shortcuts.length ? (openBlock(), createElementBlock("div", {
      key: 0,
      class: normalizeClass([$data.prefixCls + "-sidebar"])
    }, [
      (openBlock(true), createElementBlock(Fragment, null, renderList(_ctx.shortcuts, (shortcut) => {
        return openBlock(), createElementBlock("div", {
          class: normalizeClass([$data.prefixCls + "-shortcut"]),
          key: shortcut.text,
          onClick: ($event) => _ctx.handleShortcutClick(shortcut)
        }, toDisplayString(shortcut.text), 11, _hoisted_1$K);
      }), 128))
    ], 2)) : createCommentVNode("", true),
    createElementVNode("div", {
      class: normalizeClass($options.panelBodyClasses)
    }, [
      withDirectives(createElementVNode("div", {
        class: normalizeClass([$data.prefixCls + "-content", $data.prefixCls + "-content-left"])
      }, [
        withDirectives(createElementVNode("div", {
          class: normalizeClass([$data.datePrefixCls + "-header"])
        }, [
          createElementVNode("span", {
            class: normalizeClass(_ctx.iconBtnCls("prev", "-double")),
            onClick: _cache[0] || (_cache[0] = ($event) => $options.prevYear("left"))
          }, [
            createVNode(_component_Icon, { type: "ios-arrow-back" })
          ], 2),
          $data.leftPickerTable === "date-table" ? withDirectives((openBlock(), createElementBlock("span", {
            key: 0,
            class: normalizeClass(_ctx.iconBtnCls("prev")),
            onClick: _cache[1] || (_cache[1] = ($event) => $options.prevMonth("left"))
          }, [
            createVNode(_component_Icon, { type: "ios-arrow-back" })
          ], 2)), [
            [vShow, $data.currentView === "date"]
          ]) : createCommentVNode("", true),
          createVNode(_component_date_panel_label, {
            "date-panel-label": $options.leftDatePanelLabel,
            "current-view": $options.leftDatePanelView,
            "date-prefix-cls": $data.datePrefixCls
          }, null, 8, ["date-panel-label", "current-view", "date-prefix-cls"]),
          $props.splitPanels || $data.leftPickerTable !== "date-table" ? (openBlock(), createElementBlock("span", {
            key: 1,
            class: normalizeClass(_ctx.iconBtnCls("next", "-double")),
            onClick: _cache[2] || (_cache[2] = ($event) => $options.nextYear("left"))
          }, [
            createVNode(_component_Icon, { type: "ios-arrow-forward" })
          ], 2)) : createCommentVNode("", true),
          $props.splitPanels && $data.leftPickerTable === "date-table" ? withDirectives((openBlock(), createElementBlock("span", {
            key: 2,
            class: normalizeClass(_ctx.iconBtnCls("next")),
            onClick: _cache[3] || (_cache[3] = ($event) => $options.nextMonth("left"))
          }, [
            createVNode(_component_Icon, { type: "ios-arrow-forward" })
          ], 2)), [
            [vShow, $data.currentView === "date"]
          ]) : createCommentVNode("", true)
        ], 2), [
          [vShow, $data.currentView !== "time"]
        ]),
        $data.currentView !== "time" ? (openBlock(), createBlock(resolveDynamicComponent($data.leftPickerTable), {
          key: 0,
          ref: "leftYearTable",
          "table-date": $data.leftPanelDate,
          "selection-mode": "range",
          "disabled-date": _ctx.disabledDate,
          "range-state": $data.rangeState,
          "show-week-numbers": _ctx.showWeekNumbers,
          "model-value": $options.preSelecting.left ? [$data.dates[0]] : $data.dates,
          "focused-date": _ctx.focusedDate,
          onOnChangeRange: $options.handleChangeRange,
          onOnPick: $options.panelPickerHandlers.left,
          onOnPickClick: _ctx.handlePickClick
        }, null, 40, ["table-date", "disabled-date", "range-state", "show-week-numbers", "model-value", "focused-date", "onOnChangeRange", "onOnPick", "onOnPickClick"])) : createCommentVNode("", true)
      ], 2), [
        [vShow, !_ctx.isTime]
      ]),
      withDirectives(createElementVNode("div", {
        class: normalizeClass([$data.prefixCls + "-content", $data.prefixCls + "-content-right"])
      }, [
        withDirectives(createElementVNode("div", {
          class: normalizeClass([$data.datePrefixCls + "-header"])
        }, [
          $props.splitPanels || $data.rightPickerTable !== "date-table" ? (openBlock(), createElementBlock("span", {
            key: 0,
            class: normalizeClass(_ctx.iconBtnCls("prev", "-double")),
            onClick: _cache[4] || (_cache[4] = ($event) => $options.prevYear("right"))
          }, [
            createVNode(_component_Icon, { type: "ios-arrow-back" })
          ], 2)) : createCommentVNode("", true),
          $props.splitPanels && $data.rightPickerTable === "date-table" ? withDirectives((openBlock(), createElementBlock("span", {
            key: 1,
            class: normalizeClass(_ctx.iconBtnCls("prev")),
            onClick: _cache[5] || (_cache[5] = ($event) => $options.prevMonth("right"))
          }, [
            createVNode(_component_Icon, { type: "ios-arrow-back" })
          ], 2)), [
            [vShow, $data.currentView === "date"]
          ]) : createCommentVNode("", true),
          createVNode(_component_date_panel_label, {
            "date-panel-label": $options.rightDatePanelLabel,
            "current-view": $options.rightDatePanelView,
            "date-prefix-cls": $data.datePrefixCls
          }, null, 8, ["date-panel-label", "current-view", "date-prefix-cls"]),
          createElementVNode("span", {
            class: normalizeClass(_ctx.iconBtnCls("next", "-double")),
            onClick: _cache[6] || (_cache[6] = ($event) => $options.nextYear("right"))
          }, [
            createVNode(_component_Icon, { type: "ios-arrow-forward" })
          ], 2),
          $data.rightPickerTable === "date-table" ? withDirectives((openBlock(), createElementBlock("span", {
            key: 2,
            class: normalizeClass(_ctx.iconBtnCls("next")),
            onClick: _cache[7] || (_cache[7] = ($event) => $options.nextMonth("right"))
          }, [
            createVNode(_component_Icon, { type: "ios-arrow-forward" })
          ], 2)), [
            [vShow, $data.currentView === "date"]
          ]) : createCommentVNode("", true)
        ], 2), [
          [vShow, $data.currentView !== "time"]
        ]),
        $data.currentView !== "time" ? (openBlock(), createBlock(resolveDynamicComponent($data.rightPickerTable), {
          key: 0,
          ref: "rightYearTable",
          "table-date": $data.rightPanelDate,
          "selection-mode": "range",
          "range-state": $data.rangeState,
          "disabled-date": _ctx.disabledDate,
          "show-week-numbers": _ctx.showWeekNumbers,
          "model-value": $options.preSelecting.right ? [$data.dates[$data.dates.length - 1]] : $data.dates,
          "focused-date": _ctx.focusedDate,
          onOnChangeRange: $options.handleChangeRange,
          onOnPick: $options.panelPickerHandlers.right,
          onOnPickClick: _ctx.handlePickClick
        }, null, 40, ["table-date", "range-state", "disabled-date", "show-week-numbers", "model-value", "focused-date", "onOnChangeRange", "onOnPick", "onOnPickClick"])) : createCommentVNode("", true)
      ], 2), [
        [vShow, !_ctx.isTime]
      ]),
      withDirectives(createElementVNode("div", {
        class: normalizeClass([$data.prefixCls + "-content"])
      }, [
        $data.currentView === "time" ? (openBlock(), createBlock(_component_time_picker, mergeProps({
          key: 0,
          ref: "timePicker",
          "model-value": $data.dates,
          format: _ctx.format,
          "time-disabled": $options.timeDisabled
        }, _ctx.timePickerOptions, {
          onOnPick: $options.handleRangePick,
          onOnPickClick: _ctx.handlePickClick,
          onOnPickClear: _ctx.handlePickClear,
          onOnPickSuccess: _ctx.handlePickSuccess,
          onOnPickToggleTime: _ctx.handleToggleTime
        }), null, 16, ["model-value", "format", "time-disabled", "onOnPick", "onOnPickClick", "onOnPickClear", "onOnPickSuccess", "onOnPickToggleTime"])) : createCommentVNode("", true)
      ], 2), [
        [vShow, _ctx.isTime]
      ]),
      _ctx.confirm ? (openBlock(), createBlock(_component_Confirm, {
        key: 0,
        "show-time": _ctx.showTime,
        "is-time": _ctx.isTime,
        "time-disabled": $options.timeDisabled,
        onOnPickToggleTime: _ctx.handleToggleTime,
        onOnPickClear: _ctx.handlePickClear,
        onOnPickSuccess: _ctx.handlePickSuccess
      }, null, 8, ["show-time", "is-time", "time-disabled", "onOnPickToggleTime", "onOnPickClear", "onOnPickSuccess"])) : createCommentVNode("", true)
    ], 2)
  ], 34);
}
var RangeDatePickerPanel = /* @__PURE__ */ _export_sfc(_sfc_main$1s, [["render", _sfc_render$1e]]);
var DatePicker = {
  name: "CalendarPicker",
  mixins: [Picker],
  props: {
    type: {
      validator(value) {
        return oneOf(value, ["year", "month", "date", "daterange", "datetime", "datetimerange"]);
      },
      default: "date"
    }
  },
  components: { DatePickerPanel, RangeDatePickerPanel },
  computed: {
    panel() {
      const isRange = this.type === "daterange" || this.type === "datetimerange";
      return isRange ? "RangeDatePickerPanel" : "DatePickerPanel";
    },
    ownPickerProps() {
      return this.options;
    }
  }
};
var responsive = {
  1: { xs: 24 },
  2: { xs: 24, sm: 12 },
  3: { xs: 24, sm: 12, md: 8 },
  4: { xs: 24, sm: 12, md: 6 }
};
const _sfc_main$1r = {
  name: "Description",
  inject: ["DescriptionListInstance"],
  props: {
    term: {
      type: String
    }
  },
  computed: {
    styles() {
      let style2 = {};
      if (this.DescriptionListInstance.gutter !== 0) {
        style2 = {
          paddingLeft: this.DescriptionListInstance.gutter / 2 + "px",
          paddingRight: this.DescriptionListInstance.gutter / 2 + "px"
        };
      }
      return style2;
    }
  },
  render() {
    let termNode;
    if (this.term || this.$slots.term) {
      if (this.$slots.term) {
        termNode = h("div", {
          class: "ivu-description-term"
        }, this.$slots.term());
      } else {
        termNode = h("div", {
          class: "ivu-description-term"
        }, this.term);
      }
    }
    const detailNode = h("div", {
      class: "ivu-description-detail"
    }, this.$slots.default());
    const children = termNode ? [termNode, detailNode] : [detailNode];
    return h(Col, {
      ...responsive[this.DescriptionListInstance.col],
      style: this.styles
    }, () => children);
  }
};
const _sfc_main$1q = {
  name: "DescriptionList",
  components: { Row },
  provide() {
    return {
      DescriptionListInstance: this
    };
  },
  props: {
    layout: {
      validator(value) {
        return oneOf(value, ["horizontal", "vertical"]);
      },
      default: "horizontal"
    },
    title: {
      type: String
    },
    gutter: {
      type: Number,
      default: 32
    },
    col: {
      validator(value) {
        return oneOf(value, [1, 2, 3, 4]);
      },
      default: 3
    }
  }
};
const _hoisted_1$J = {
  key: 0,
  class: "ivu-description-list-title"
};
function _sfc_render$1d(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Row = resolveComponent("Row");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(["ivu-description-list", { "ivu-description-list-vertical": $props.layout === "vertical" }])
  }, [
    $props.title || _ctx.$slots.title ? (openBlock(), createElementBlock("div", _hoisted_1$J, [
      renderSlot(_ctx.$slots, "title", {}, () => [
        createTextVNode(toDisplayString($props.title), 1)
      ])
    ])) : createCommentVNode("", true),
    createVNode(_component_Row, { gutter: $props.gutter }, {
      default: withCtx(() => [
        renderSlot(_ctx.$slots, "default")
      ]),
      _: 3
    }, 8, ["gutter"])
  ], 2);
}
var DescriptionList = /* @__PURE__ */ _export_sfc(_sfc_main$1q, [["render", _sfc_render$1d]]);
const prefixCls$I = "ivu-divider";
const _sfc_main$1p = {
  name: "Divider",
  props: {
    type: {
      type: String,
      default: "horizontal",
      validator(value) {
        return oneOf(value, ["horizontal", "vertical"]);
      }
    },
    orientation: {
      type: String,
      default: "center",
      validator(value) {
        return oneOf(value, ["left", "right", "center"]);
      }
    },
    dashed: {
      type: Boolean,
      default: false
    },
    size: {
      validator(value) {
        return oneOf(value, ["small", "default"]);
      },
      default: "default"
    },
    plain: {
      type: Boolean,
      default: false
    }
  },
  computed: {
    hasSlot() {
      return !!this.$slots.default;
    },
    classes() {
      return [
        `${prefixCls$I}`,
        `${prefixCls$I}-${this.type}`,
        `${prefixCls$I}-${this.size}`,
        {
          [`${prefixCls$I}-with-text`]: this.hasSlot && this.orientation === "center",
          [`${prefixCls$I}-with-text-${this.orientation}`]: this.hasSlot,
          [`${prefixCls$I}-dashed`]: !!this.dashed,
          [`${prefixCls$I}-plain`]: this.plain
        }
      ];
    },
    slotClasses() {
      return [
        `${prefixCls$I}-inner-text`
      ];
    }
  }
};
function _sfc_render$1c(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes)
  }, [
    $options.hasSlot ? (openBlock(), createElementBlock("span", {
      key: 0,
      class: normalizeClass($options.slotClasses)
    }, [
      renderSlot(_ctx.$slots, "default")
    ], 2)) : createCommentVNode("", true)
  ], 2);
}
var Divider = /* @__PURE__ */ _export_sfc(_sfc_main$1p, [["render", _sfc_render$1c]]);
var ScrollbarMixins = {
  props: {
    lockScroll: {
      type: Boolean,
      default: true
    }
  },
  methods: {
    checkScrollBar() {
      if (!isClient)
        return;
      let fullWindowWidth = window.innerWidth;
      if (!fullWindowWidth) {
        const documentElementRect = document.documentElement.getBoundingClientRect();
        fullWindowWidth = documentElementRect.right - Math.abs(documentElementRect.left);
      }
      this.bodyIsOverflowing = document.body.clientWidth < fullWindowWidth;
      if (this.bodyIsOverflowing) {
        this.scrollBarWidth = getScrollBarSize();
      }
    },
    checkMaskInVisible() {
      let masks = isClient ? document.getElementsByClassName("ivu-modal-mask") || [] : [];
      return Array.from(masks).every((m) => m.style.display === "none" || m.classList.contains("fade-leave-to"));
    },
    setScrollBar() {
      if (isClient && this.bodyIsOverflowing && this.scrollBarWidth !== void 0) {
        document.body.style.paddingRight = `${this.scrollBarWidth}px`;
      }
    },
    resetScrollBar() {
      isClient && (document.body.style.paddingRight = "");
    },
    addScrollEffect() {
      if (!this.lockScroll)
        return;
      this.checkScrollBar();
      this.setScrollBar();
      isClient && (document.body.style.overflow = "hidden");
    },
    removeScrollEffect() {
      if (!this.lockScroll)
        return;
      if (isClient && this.checkMaskInVisible()) {
        document.body.style.overflow = "";
        this.resetScrollBar();
      }
    }
  }
};
const prefixCls$H = "ivu-drawer";
const _sfc_main$1o = {
  name: "Drawer",
  mixins: [ScrollbarMixins],
  components: { Icon },
  emits: ["on-close", "on-resize-width", "on-visible-change", "update:modelValue", "on-drag"],
  provide() {
    return {
      DrawerInstance: this
    };
  },
  props: {
    modelValue: {
      type: Boolean,
      default: false
    },
    title: {
      type: String
    },
    width: {
      type: [Number, String],
      default: 256
    },
    height: {
      type: [Number, String],
      default: 256
    },
    closable: {
      type: Boolean,
      default: true
    },
    maskClosable: {
      type: Boolean,
      default: true
    },
    mask: {
      type: Boolean,
      default: true
    },
    maskStyle: {
      type: Object
    },
    styles: {
      type: Object
    },
    scrollable: {
      type: Boolean,
      default: false
    },
    placement: {
      validator(value) {
        return oneOf(value, ["left", "right", "top", "bottom"]);
      },
      default: "right"
    },
    zIndex: {
      type: Number,
      default: 1e3
    },
    transfer: {
      type: Boolean,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.transfer === "" ? true : global2.$VIEWUI.transfer;
      }
    },
    className: {
      type: String
    },
    inner: {
      type: Boolean,
      default: false
    },
    draggable: {
      type: Boolean,
      default: false
    },
    beforeClose: Function
  },
  data() {
    return {
      prefixCls: prefixCls$H,
      visible: this.modelValue,
      wrapShow: false,
      showHead: true,
      canMove: false,
      dragWidth: this.width,
      dragHeight: this.height,
      wrapperWidth: this.width,
      wrapperHeight: this.height,
      wrapperLeft: 0,
      minWidth: 256,
      minHeight: 256,
      id: random(6),
      tableList: [],
      sliderList: []
    };
  },
  computed: {
    wrapClasses() {
      return [
        `${prefixCls$H}-wrap`,
        {
          [`${prefixCls$H}-hidden`]: !this.wrapShow,
          [`${this.className}`]: !!this.className,
          [`${prefixCls$H}-no-mask`]: !this.mask,
          [`${prefixCls$H}-wrap-inner`]: this.inner,
          [`${prefixCls$H}-wrap-dragging`]: this.canMove
        }
      ];
    },
    wrapStyles() {
      return {
        zIndex: this.zIndex
      };
    },
    mainStyles() {
      let style2 = {};
      if (this.placement === "left" || this.placement === "right") {
        const width = parseInt(this.dragWidth);
        const styleWidth = {
          width: width <= 100 ? `${width}%` : `${width}px`
        };
        Object.assign(style2, styleWidth);
      } else {
        const height2 = parseInt(this.dragHeight);
        const styleHeight = {
          height: height2 <= 100 ? `${height2}%` : `${height2}px`
        };
        Object.assign(style2, styleHeight);
      }
      return style2;
    },
    contentClasses() {
      return [
        `${prefixCls$H}-content`,
        {
          [`${prefixCls$H}-content-no-mask`]: !this.mask
        }
      ];
    },
    classes() {
      return [
        `${prefixCls$H}`,
        `${prefixCls$H}-${this.placement}`,
        {
          [`${prefixCls$H}-no-header`]: !this.showHead,
          [`${prefixCls$H}-inner`]: this.inner
        }
      ];
    },
    maskClasses() {
      return [
        `${prefixCls$H}-mask`,
        {
          [`${prefixCls$H}-mask-inner`]: this.inner
        }
      ];
    },
    transitionName() {
      if (this.placement === "left" || this.placement === "right")
        return `move-${this.placement}`;
      else if (this.placement === "top")
        return "move-up";
      else
        return "move-down";
    }
  },
  methods: {
    close() {
      if (!this.beforeClose) {
        return this.handleClose();
      }
      const before = this.beforeClose();
      if (before && before.then) {
        before.then(() => {
          this.handleClose();
        });
      } else {
        this.handleClose();
      }
    },
    handleClose() {
      this.visible = false;
      this.$emit("update:modelValue", false);
      this.$emit("on-close");
    },
    handleMask() {
      if (this.maskClosable && this.mask) {
        this.close();
      }
    },
    handleWrapClick(event) {
      const className = event.target.getAttribute("class");
      if (className && className.indexOf(`${prefixCls$H}-wrap`) > -1)
        this.handleMask();
    },
    handleMousemove(event) {
      if (!this.canMove || !this.draggable)
        return;
      this.handleSetWrapperWidth();
      const left = event.pageX - this.wrapperLeft;
      let width = this.placement === "right" ? this.wrapperWidth - left : left;
      width = Math.max(width, parseFloat(this.minWidth));
      event.atMin = width === parseFloat(this.minWidth);
      if (width <= 100)
        width = width / this.wrapperWidth * 100;
      this.dragWidth = width;
      this.$emit("on-resize-width", parseInt(this.dragWidth));
      this.$emit("on-drag", "dragging", parseInt(this.dragWidth));
    },
    handleSetWrapperWidth() {
      const {
        width,
        left
      } = this.$refs.drawer.getBoundingClientRect();
      this.wrapperWidth = width;
      this.wrapperLeft = left;
    },
    handleMouseup() {
      if (!this.draggable)
        return;
      this.canMove = false;
      this.$emit("on-drag", "end");
    },
    handleTriggerMousedown() {
      this.canMove = true;
      window.getSelection().removeAllRanges();
      this.$emit("on-drag", "start");
    },
    addDrawer() {
      const root2 = this.$root;
      if (!root2.drawerList)
        root2.drawerList = [];
      root2.drawerList.push({
        id: this.id,
        drawer: this
      });
    },
    removeDrawer() {
      const root2 = this.$root;
      if (!root2.drawerList)
        return;
      const index2 = root2.drawerList.findIndex((item) => item.id === this.id);
      root2.drawerList.splice(index2, 1);
    }
  },
  mounted() {
    if (this.visible) {
      this.wrapShow = true;
    }
    let showHead = true;
    if (this.$slots.header === void 0 && !this.title) {
      showHead = false;
    }
    this.showHead = showHead;
    this.addDrawer();
    on(document, "mousemove", this.handleMousemove);
    on(document, "mouseup", this.handleMouseup);
    this.handleSetWrapperWidth();
  },
  beforeUnmount() {
    this.removeDrawer();
    off(document, "mousemove", this.handleMousemove);
    off(document, "mouseup", this.handleMouseup);
    this.removeScrollEffect();
  },
  watch: {
    modelValue(val) {
      this.visible = val;
    },
    visible(val) {
      if (val === false) {
        this.timer = setTimeout(() => {
          this.wrapShow = false;
          const drawers = this.$root.drawerList.map((item) => item.drawer);
          const otherDrawers = drawers.filter((item) => item.id !== this.id);
          const isScrollDrawer = otherDrawers.some((item) => item.visible && !item.scrollable);
          if (!isScrollDrawer) {
            this.removeScrollEffect();
          }
        }, 300);
      } else {
        if (this.timer)
          clearTimeout(this.timer);
        this.wrapShow = true;
        if (!this.scrollable) {
          this.addScrollEffect();
        }
      }
      this.tableList.forEach((item) => {
        item.table.handleOnVisibleChange(val);
      });
      this.sliderList.forEach((item) => {
        item.slider.handleOnVisibleChange(val);
      });
      this.$emit("on-visible-change", val);
    },
    scrollable(val) {
      if (!val) {
        this.addScrollEffect();
      } else {
        this.removeScrollEffect();
      }
    },
    title(val) {
      if (this.$slots.header === void 0) {
        this.showHead = !!val;
      }
    },
    width(val) {
      this.dragWidth = val;
    },
    height(val) {
      this.dragHeight = val;
    }
  }
};
const _hoisted_1$I = { ref: "drawer" };
function _sfc_render$1b(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = resolveComponent("Icon");
  return openBlock(), createBlock(Teleport, {
    to: "body",
    disabled: !$props.transfer
  }, [
    createElementVNode("div", _hoisted_1$I, [
      createVNode(Transition, { name: "fade" }, {
        default: withCtx(() => [
          $props.mask ? withDirectives((openBlock(), createElementBlock("div", {
            key: 0,
            class: normalizeClass($options.maskClasses),
            style: normalizeStyle($props.maskStyle),
            onClick: _cache[0] || (_cache[0] = (...args) => $options.handleMask && $options.handleMask(...args))
          }, null, 6)), [
            [vShow, $data.visible]
          ]) : createCommentVNode("", true)
        ]),
        _: 1
      }),
      createElementVNode("div", {
        class: normalizeClass($options.wrapClasses),
        style: normalizeStyle($options.wrapStyles),
        onClick: _cache[3] || (_cache[3] = (...args) => $options.handleWrapClick && $options.handleWrapClick(...args))
      }, [
        createVNode(Transition, { name: $options.transitionName }, {
          default: withCtx(() => [
            withDirectives(createElementVNode("div", {
              class: normalizeClass($options.classes),
              style: normalizeStyle($options.mainStyles)
            }, [
              createElementVNode("div", {
                class: normalizeClass($options.contentClasses),
                ref: "content"
              }, [
                $props.closable ? (openBlock(), createElementBlock("a", {
                  key: 0,
                  class: "ivu-drawer-close",
                  onClick: _cache[1] || (_cache[1] = (...args) => $options.close && $options.close(...args))
                }, [
                  renderSlot(_ctx.$slots, "close", {}, () => [
                    createVNode(_component_Icon, { type: "ios-close" })
                  ])
                ])) : createCommentVNode("", true),
                $data.showHead ? (openBlock(), createElementBlock("div", {
                  key: 1,
                  class: normalizeClass([$data.prefixCls + "-header"])
                }, [
                  renderSlot(_ctx.$slots, "header", {}, () => [
                    createElementVNode("div", {
                      class: normalizeClass([$data.prefixCls + "-header-inner"])
                    }, toDisplayString($props.title), 3)
                  ])
                ], 2)) : createCommentVNode("", true),
                createElementVNode("div", {
                  class: normalizeClass([$data.prefixCls + "-body"]),
                  style: normalizeStyle($props.styles)
                }, [
                  renderSlot(_ctx.$slots, "default")
                ], 6)
              ], 2),
              $props.draggable && ($props.placement === "left" || $props.placement === "right") ? (openBlock(), createElementBlock("div", {
                key: 0,
                class: normalizeClass(["ivu-drawer-drag", "ivu-drawer-drag-" + $props.placement]),
                onMousedown: _cache[2] || (_cache[2] = (...args) => $options.handleTriggerMousedown && $options.handleTriggerMousedown(...args))
              }, [
                renderSlot(_ctx.$slots, "trigger", {}, () => [
                  _cache[4] || (_cache[4] = createElementVNode("div", { class: "ivu-drawer-drag-move-trigger" }, [
                    createElementVNode("div", { class: "ivu-drawer-drag-move-trigger-point" }, [
                      createElementVNode("i"),
                      createElementVNode("i"),
                      createElementVNode("i"),
                      createElementVNode("i"),
                      createElementVNode("i")
                    ])
                  ], -1))
                ])
              ], 34)) : createCommentVNode("", true)
            ], 6), [
              [vShow, $data.visible]
            ])
          ]),
          _: 3
        }, 8, ["name"])
      ], 6)
    ], 512)
  ], 8, ["disabled"]);
}
var Drawer = /* @__PURE__ */ _export_sfc(_sfc_main$1o, [["render", _sfc_render$1b]]);
const prefixCls$G = "ivu-dropdown-item";
const _sfc_main$1n = {
  name: "DropdownItem",
  props: {
    name: {
      type: [String, Number]
    },
    disabled: {
      type: Boolean,
      default: false
    },
    selected: {
      type: Boolean,
      default: false
    },
    divided: {
      type: Boolean,
      default: false
    }
  },
  computed: {
    classes() {
      return [
        `${prefixCls$G}`,
        {
          [`${prefixCls$G}-disabled`]: this.disabled,
          [`${prefixCls$G}-selected`]: this.selected,
          [`${prefixCls$G}-divided`]: this.divided
        }
      ];
    }
  },
  methods: {
    handleClick() {
      if (this.disabled)
        return;
      const $parent = findComponentUpward(this, "Dropdown");
      const hasChildren = this.$parent && this.$parent.$options.name === "Dropdown";
      if (hasChildren) {
        this.$parent.handleHaschildClick();
      } else {
        if ($parent && $parent.$options.name === "Dropdown") {
          $parent.handleHoverClick();
        }
      }
      $parent.handleItemClick(this.name);
    }
  }
};
function _sfc_render$1a(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("li", {
    class: normalizeClass($options.classes),
    onClick: _cache[0] || (_cache[0] = (...args) => $options.handleClick && $options.handleClick(...args))
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 2);
}
var DropdownItem = /* @__PURE__ */ _export_sfc(_sfc_main$1n, [["render", _sfc_render$1a]]);
const getStrFullLength = (str = "") => str.split("").reduce((pre, cur) => {
  const charCode = cur.charCodeAt(0);
  if (charCode >= 0 && charCode <= 128) {
    return pre + 1;
  }
  return pre + 2;
}, 0);
const cutStrByFullLength = (str = "", maxLength) => {
  let showLength = 0;
  return str.split("").reduce((pre, cur) => {
    const charCode = cur.charCodeAt(0);
    if (charCode >= 0 && charCode <= 128) {
      showLength += 1;
    } else {
      showLength += 2;
    }
    if (showLength <= maxLength) {
      return pre + cur;
    }
    return pre;
  }, "");
};
const _sfc_main$1m = {
  name: "Ellipsis",
  components: { Tooltip },
  emits: ["on-show", "on-hide"],
  props: {
    text: {
      type: String
    },
    height: {
      type: Number
    },
    lines: {
      type: Number
    },
    length: {
      type: Number
    },
    fullWidthRecognition: {
      type: Boolean,
      default: false
    },
    autoResize: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    },
    tooltip: {
      type: Boolean,
      default: false
    },
    transfer: {
      type: Boolean,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.transfer === "" ? false : global2.$VIEWUI.transfer;
      }
    },
    theme: {
      validator(value) {
        return oneOf(value, ["dark", "light"]);
      },
      default: "dark"
    },
    maxWidth: {
      type: [String, Number],
      default: 250
    },
    placement: {
      validator(value) {
        return oneOf(value, ["top", "top-start", "top-end", "bottom", "bottom-start", "bottom-end", "left", "left-start", "left-end", "right", "right-start", "right-end"]);
      },
      default: "bottom"
    }
  },
  data() {
    return {
      oversize: false,
      computedReady: false,
      computedText: ""
    };
  },
  watch: {
    disabled() {
      this.init();
    },
    text() {
      this.init();
    },
    height() {
      this.init();
    }
  },
  mounted() {
    this.init();
  },
  methods: {
    init() {
      if (!this.disabled) {
        this.computeText();
        this.limitShow();
      }
    },
    computeText() {
      this.oversize = false;
      this.computedReady = false;
      nextTick(() => {
        let $text = this.$refs.text;
        let $el = this.$el;
        let $more = this.$refs.more;
        let n = 1e3;
        let text = this.text;
        let height2 = this.height;
        if (!height2 && this.lines) {
          const lineHeight = parseInt(getStyle($el, "lineHeight"), 10);
          height2 = lineHeight * this.lines;
        }
        if ($text) {
          if (this.length) {
            const textLength = this.fullWidthRecognition ? getStrFullLength(text) : text.length;
            if (textLength > this.length) {
              this.oversize = true;
              $more.style.display = "inline-block";
              text = this.fullWidthRecognition ? cutStrByFullLength(text, this.length) : text.slice(0, this.length);
            }
          } else {
            if ($el.offsetHeight > height2) {
              this.oversize = true;
              $more.style.display = "inline-block";
              while ($el.offsetHeight > height2 && n > 0) {
                if ($el.offsetHeight > height2 * 3) {
                  $text.innerText = text = text.substring(0, Math.floor(text.length / 2));
                } else {
                  $text.innerText = text = text.substring(0, text.length - 1);
                }
                n--;
              }
            }
          }
        }
        this.computedText = text;
      });
    },
    limitShow() {
      this.computedReady = true;
      nextTick(() => {
        let $text = this.$refs.text;
        let $el = this.$el;
        if ($text) {
          $text.innerText = this.computedText;
          if ($el.offsetHeight > this.height) {
            this.$emit("on-hide");
          } else {
            this.$emit("on-show");
          }
        }
      });
    }
  }
};
const _hoisted_1$H = { class: "ivu-ellipsis" };
const _hoisted_2$s = {
  class: "ivu-ellipsis-more",
  ref: "more"
};
const _hoisted_3$o = {
  class: "ivu-ellipsis-more",
  ref: "more"
};
const _hoisted_4$i = {
  key: 1,
  class: "ivu-ellipsis-hidden"
};
const _hoisted_5$b = {
  class: "ivu-ellipsis-more",
  ref: "more"
};
function _sfc_render$19(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Tooltip = resolveComponent("Tooltip");
  return openBlock(), createElementBlock("div", _hoisted_1$H, [
    renderSlot(_ctx.$slots, "prefix", { class: "ivu-ellipsis-prefix" }),
    $data.computedReady ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
      $props.tooltip ? (openBlock(), createBlock(_component_Tooltip, {
        key: 0,
        content: $props.text,
        theme: $props.theme,
        "max-width": $props.maxWidth,
        placement: $props.placement,
        transfer: $props.transfer
      }, {
        default: withCtx(() => [
          createElementVNode("span", {
            class: "ivu-ellipsis-text",
            ref: "text"
          }, toDisplayString($props.text), 513),
          withDirectives(createElementVNode("span", _hoisted_2$s, [
            renderSlot(_ctx.$slots, "more", {}, () => [
              _cache[0] || (_cache[0] = createTextVNode("..."))
            ])
          ], 512), [
            [vShow, $data.oversize]
          ]),
          renderSlot(_ctx.$slots, "suffix", { class: "ivu-ellipsis-suffix" })
        ]),
        _: 3
      }, 8, ["content", "theme", "max-width", "placement", "transfer"])) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
        createElementVNode("span", {
          class: "ivu-ellipsis-text",
          ref: "text"
        }, toDisplayString($props.text), 513),
        withDirectives(createElementVNode("span", _hoisted_3$o, [
          renderSlot(_ctx.$slots, "more", {}, () => [
            _cache[1] || (_cache[1] = createTextVNode("..."))
          ])
        ], 512), [
          [vShow, $data.oversize]
        ]),
        renderSlot(_ctx.$slots, "suffix", { class: "ivu-ellipsis-suffix" })
      ], 64))
    ], 64)) : (openBlock(), createElementBlock("div", _hoisted_4$i, [
      createElementVNode("span", {
        class: "ivu-ellipsis-text",
        ref: "text"
      }, toDisplayString($props.text), 513),
      withDirectives(createElementVNode("span", _hoisted_5$b, [
        renderSlot(_ctx.$slots, "more", {}, () => [
          _cache[2] || (_cache[2] = createTextVNode("..."))
        ])
      ], 512), [
        [vShow, $data.oversize]
      ]),
      renderSlot(_ctx.$slots, "suffix", { class: "ivu-ellipsis-suffix" })
    ]))
  ]);
}
var Ellipsis = /* @__PURE__ */ _export_sfc(_sfc_main$1m, [["render", _sfc_render$19]]);
const _sfc_main$1l = {
  name: "Email",
  mixins: [LoginItem],
  data() {
    return {
      className: "ivu-login-mail",
      prefix: "ios-mail-outline",
      placeholder: "\u8BF7\u8F93\u5165\u90AE\u7BB1",
      type: "email"
    };
  },
  props: {
    rules: {
      type: [Object, Array],
      default() {
        return [
          {
            required: true,
            message: defaultValidateMessage["Email"],
            trigger: "change"
          },
          {
            type: "email",
            message: "\u8F93\u5165\u7684\u90AE\u7BB1\u683C\u5F0F\u4E0D\u6B63\u786E\uFF01",
            trigger: "change"
          }
        ];
      }
    }
  }
};
var typeConfig = {
  403: {
    img: "https://file.iviewui.com/iview-pro/icon-403.svg",
    imgColor: "https://file.iviewui.com/iview-pro/icon-403-color.svg",
    title: "403",
    desc: "\u62B1\u6B49\uFF0C\u4F60\u65E0\u6743\u8BBF\u95EE\u8BE5\u9875\u9762"
  },
  404: {
    img: "https://file.iviewui.com/iview-pro/icon-404.svg",
    imgColor: "https://file.iviewui.com/iview-pro/icon-404-color.svg",
    title: "404",
    desc: "\u62B1\u6B49\uFF0C\u4F60\u8BBF\u95EE\u7684\u9875\u9762\u4E0D\u5B58\u5728"
  },
  500: {
    img: "https://file.iviewui.com/iview-pro/icon-500.svg",
    imgColor: "https://file.iviewui.com/iview-pro/icon-500-color.svg",
    title: "500",
    desc: "\u62B1\u6B49\uFF0C\u670D\u52A1\u5668\u51FA\u9519\u4E86"
  }
};
const _sfc_main$1k = {
  name: "Exception",
  components: { Button: _sfc_main$2c },
  props: {
    type: {
      validator(value) {
        return oneOf(value, ["403", "404", "500", 403, 404, 500]);
      },
      default: "404"
    },
    title: {
      type: String
    },
    desc: {
      type: String
    },
    img: {
      type: String
    },
    imgColor: {
      type: Boolean,
      default: false
    },
    backText: {
      type: String,
      default: "\u8FD4\u56DE\u9996\u9875"
    },
    redirect: {
      type: String,
      default: "/"
    }
  },
  computed: {
    imgPath() {
      return this.img ? this.img : this.imgColor ? typeConfig[this.type].imgColor : typeConfig[this.type].img;
    },
    titleText() {
      return this.title ? this.title : typeConfig[this.type].title;
    },
    descText() {
      return this.desc ? this.desc : typeConfig[this.type].desc;
    }
  }
};
const _hoisted_1$G = { class: "ivu-exception" };
const _hoisted_2$r = { class: "ivu-exception-img" };
const _hoisted_3$n = { class: "ivu-exception-content" };
const _hoisted_4$h = { class: "ivu-exception-content-desc" };
const _hoisted_5$a = { class: "ivu-exception-content-actions" };
function _sfc_render$18(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Button = resolveComponent("Button");
  return openBlock(), createElementBlock("div", _hoisted_1$G, [
    createElementVNode("div", _hoisted_2$r, [
      createElementVNode("div", {
        class: "ivu-exception-img-element",
        style: normalizeStyle({ "background-image": "url(" + $options.imgPath + ")" })
      }, null, 4)
    ]),
    createElementVNode("div", _hoisted_3$n, [
      createElementVNode("h1", null, [
        renderSlot(_ctx.$slots, "title", {}, () => [
          createTextVNode(toDisplayString($options.titleText), 1)
        ])
      ]),
      createElementVNode("div", _hoisted_4$h, [
        renderSlot(_ctx.$slots, "desc", {}, () => [
          createTextVNode(toDisplayString($options.descText), 1)
        ])
      ]),
      createElementVNode("div", _hoisted_5$a, [
        renderSlot(_ctx.$slots, "actions", {}, () => [
          createVNode(_component_Button, {
            to: $props.redirect,
            type: "primary",
            size: "large"
          }, {
            default: withCtx(() => [
              createTextVNode(toDisplayString($props.backText), 1)
            ]),
            _: 1
          }, 8, ["to"])
        ])
      ])
    ])
  ]);
}
var Exception = /* @__PURE__ */ _export_sfc(_sfc_main$1k, [["render", _sfc_render$18]]);
const prefixCls$F = "ivu-layout";
const _sfc_main$1j = {
  name: "Footer",
  computed: {
    wrapClasses() {
      return `${prefixCls$F}-footer`;
    }
  }
};
function _sfc_render$17(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.wrapClasses)
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 2);
}
var Footer = /* @__PURE__ */ _export_sfc(_sfc_main$1j, [["render", _sfc_render$17]]);
const _sfc_main$1i = {
  name: "FooterToolbar",
  props: {
    extra: {
      type: String
    }
  }
};
const _hoisted_1$F = { class: "ivu-footer-toolbar" };
const _hoisted_2$q = {
  key: 0,
  class: "ivu-footer-toolbar-left"
};
const _hoisted_3$m = { class: "ivu-footer-toolbar-right" };
function _sfc_render$16(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", _hoisted_1$F, [
    $props.extra || _ctx.$slots.extra ? (openBlock(), createElementBlock("div", _hoisted_2$q, [
      renderSlot(_ctx.$slots, "extra", {}, () => [
        createTextVNode(toDisplayString($props.extra), 1)
      ])
    ])) : createCommentVNode("", true),
    createElementVNode("div", _hoisted_3$m, [
      renderSlot(_ctx.$slots, "default")
    ])
  ]);
}
var FooterToolbar = /* @__PURE__ */ _export_sfc(_sfc_main$1i, [["render", _sfc_render$16]]);
const prefixCls$E = "ivu-form";
const _sfc_main$1h = {
  name: "iForm",
  emits: ["on-validate"],
  provide() {
    return {
      FormInstance: this
    };
  },
  props: {
    model: {
      type: Object
    },
    rules: {
      type: Object
    },
    labelWidth: {
      type: Number
    },
    labelPosition: {
      validator(value) {
        return oneOf(value, ["left", "right", "top"]);
      },
      default: "right"
    },
    inline: {
      type: Boolean,
      default: false
    },
    showMessage: {
      type: Boolean,
      default: true
    },
    autocomplete: {
      validator(value) {
        return oneOf(value, ["on", "off"]);
      },
      default: "off"
    },
    hideRequiredMark: {
      type: Boolean,
      default: false
    },
    labelColon: {
      type: [Boolean, String],
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    }
  },
  data() {
    return {
      fields: []
    };
  },
  computed: {
    classes() {
      return [
        `${prefixCls$E}`,
        `${prefixCls$E}-label-${this.labelPosition}`,
        {
          [`${prefixCls$E}-inline`]: this.inline,
          [`${prefixCls$E}-hide-required-mark`]: this.hideRequiredMark
        }
      ];
    },
    colon() {
      let colon = "";
      if (this.labelColon) {
        colon = typeof this.labelColon === "boolean" ? ":" : this.labelColon;
      }
      return colon;
    }
  },
  methods: {
    resetFields() {
      this.fields.forEach((field) => {
        field.resetField();
      });
    },
    validate(callback) {
      return new Promise((resolve) => {
        let valid = true;
        let count = 0;
        if (this.fields.length === 0) {
          resolve(valid);
          if (typeof callback === "function") {
            callback(valid);
          }
        }
        this.fields.forEach((field) => {
          field.validate("", (errors) => {
            if (errors) {
              valid = false;
            }
            if (++count === this.fields.length) {
              resolve(valid);
              if (typeof callback === "function") {
                callback(valid);
              }
            }
          });
        });
      });
    },
    validateField(prop2, cb) {
      const field = this.fields.filter((field2) => field2.prop === prop2)[0];
      if (!field) {
        throw new Error("[View UI warn]: must call validateField with valid prop string!");
      }
      field.validate("", cb);
    },
    addField(field) {
      if (field)
        this.fields.push(field);
    },
    removeField(field) {
      if (field.prop)
        this.fields.splice(this.fields.indexOf(field), 1);
    }
  },
  watch: {
    rules() {
      this.validate();
    }
  }
};
const _hoisted_1$E = ["autocomplete"];
function _sfc_render$15(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("form", {
    class: normalizeClass($options.classes),
    autocomplete: $props.autocomplete
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 10, _hoisted_1$E);
}
var Form = /* @__PURE__ */ _export_sfc(_sfc_main$1h, [["render", _sfc_render$15]]);
const _sfc_main$1g = {
  name: "GlobalFooter",
  components: { Icon },
  props: {
    links: {
      type: Array,
      default() {
        return [];
      }
    },
    copyright: {
      type: String
    }
  }
};
const _hoisted_1$D = { class: "ivu-global-footer" };
const _hoisted_2$p = {
  key: 0,
  class: "ivu-global-footer-links"
};
const _hoisted_3$l = ["href", "target", "title"];
const _hoisted_4$g = {
  key: 1,
  class: "ivu-global-footer-copyright"
};
function _sfc_render$14(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = resolveComponent("Icon");
  return openBlock(), createElementBlock("footer", _hoisted_1$D, [
    $props.links.length || _ctx.$slots.links ? (openBlock(), createElementBlock("div", _hoisted_2$p, [
      renderSlot(_ctx.$slots, "links", {}, () => [
        (openBlock(true), createElementBlock(Fragment, null, renderList($props.links, (item) => {
          return openBlock(), createElementBlock("a", {
            href: item.href,
            target: item.blankTarget ? "_blank" : "_self",
            key: item.key,
            title: item.title
          }, [
            item.icon ? (openBlock(), createBlock(_component_Icon, {
              key: 0,
              type: item.icon
            }, null, 8, ["type"])) : item.customIcon ? (openBlock(), createBlock(_component_Icon, {
              key: 1,
              custom: item.customIcon
            }, null, 8, ["custom"])) : createCommentVNode("", true),
            createTextVNode(" " + toDisplayString(item.title), 1)
          ], 8, _hoisted_3$l);
        }), 128))
      ])
    ])) : createCommentVNode("", true),
    $props.copyright || _ctx.$slots.copyright ? (openBlock(), createElementBlock("div", _hoisted_4$g, [
      renderSlot(_ctx.$slots, "copyright", {}, () => [
        createTextVNode(toDisplayString($props.copyright), 1)
      ])
    ])) : createCommentVNode("", true)
  ]);
}
var GlobalFooter = /* @__PURE__ */ _export_sfc(_sfc_main$1g, [["render", _sfc_render$14]]);
var collectionUtils = { exports: {} };
var utils$3 = collectionUtils.exports = {};
utils$3.forEach = function(collection, callback) {
  for (var i = 0; i < collection.length; i++) {
    var result = callback(collection[i]);
    if (result) {
      return result;
    }
  }
};
var elementUtils = function(options) {
  var getState2 = options.stateHandler.getState;
  function isDetectable(element) {
    var state = getState2(element);
    return state && !!state.isDetectable;
  }
  function markAsDetectable(element) {
    getState2(element).isDetectable = true;
  }
  function isBusy(element) {
    return !!getState2(element).busy;
  }
  function markBusy(element, busy) {
    getState2(element).busy = !!busy;
  }
  return {
    isDetectable,
    markAsDetectable,
    isBusy,
    markBusy
  };
};
var listenerHandler = function(idHandler2) {
  var eventListeners = {};
  function getListeners(element) {
    var id = idHandler2.get(element);
    if (id === void 0) {
      return [];
    }
    return eventListeners[id] || [];
  }
  function addListener(element, listener) {
    var id = idHandler2.get(element);
    if (!eventListeners[id]) {
      eventListeners[id] = [];
    }
    eventListeners[id].push(listener);
  }
  function removeListener(element, listener) {
    var listeners = getListeners(element);
    for (var i = 0, len = listeners.length; i < len; ++i) {
      if (listeners[i] === listener) {
        listeners.splice(i, 1);
        break;
      }
    }
  }
  function removeAllListeners(element) {
    var listeners = getListeners(element);
    if (!listeners) {
      return;
    }
    listeners.length = 0;
  }
  return {
    get: getListeners,
    add: addListener,
    removeListener,
    removeAllListeners
  };
};
var idGenerator = function() {
  var idCount = 1;
  function generate() {
    return idCount++;
  }
  return {
    generate
  };
};
var idHandler = function(options) {
  var idGenerator2 = options.idGenerator;
  var getState2 = options.stateHandler.getState;
  function getId(element) {
    var state = getState2(element);
    if (state && state.id !== void 0) {
      return state.id;
    }
    return null;
  }
  function setId(element) {
    var state = getState2(element);
    if (!state) {
      throw new Error("setId required the element to have a resize detection state.");
    }
    var id = idGenerator2.generate();
    state.id = id;
    return id;
  }
  return {
    get: getId,
    set: setId
  };
};
var reporter = function(quiet) {
  function noop2() {
  }
  var reporter2 = {
    log: noop2,
    warn: noop2,
    error: noop2
  };
  if (!quiet && window.console) {
    var attachFunction = function(reporter3, name2) {
      reporter3[name2] = function reporterProxy() {
        var f = console[name2];
        if (f.apply) {
          f.apply(console, arguments);
        } else {
          for (var i = 0; i < arguments.length; i++) {
            f(arguments[i]);
          }
        }
      };
    };
    attachFunction(reporter2, "log");
    attachFunction(reporter2, "warn");
    attachFunction(reporter2, "error");
  }
  return reporter2;
};
var browserDetector$2 = { exports: {} };
var detector = browserDetector$2.exports = {};
detector.isIE = function(version2) {
  function isAnyIeVersion() {
    var agent = navigator.userAgent.toLowerCase();
    return agent.indexOf("msie") !== -1 || agent.indexOf("trident") !== -1 || agent.indexOf(" edge/") !== -1;
  }
  if (!isAnyIeVersion()) {
    return false;
  }
  if (!version2) {
    return true;
  }
  var ieVersion = function() {
    var undef, v = 3, div = document.createElement("div"), all = div.getElementsByTagName("i");
    do {
      div.innerHTML = "<!--[if gt IE " + ++v + "]><i></i><![endif]-->";
    } while (all[0]);
    return v > 4 ? v : undef;
  }();
  return version2 === ieVersion;
};
detector.isLegacyOpera = function() {
  return !!window.opera;
};
var utils$2 = { exports: {} };
var utils$1 = utils$2.exports = {};
utils$1.getOption = getOption$1;
function getOption$1(options, name2, defaultValue) {
  var value = options[name2];
  if ((value === void 0 || value === null) && defaultValue !== void 0) {
    return defaultValue;
  }
  return value;
}
var utils = utils$2.exports;
var batchProcessor = function batchProcessorMaker(options) {
  options = options || {};
  var reporter2 = options.reporter;
  var asyncProcess = utils.getOption(options, "async", true);
  var autoProcess = utils.getOption(options, "auto", true);
  if (autoProcess && !asyncProcess) {
    reporter2 && reporter2.warn("Invalid options combination. auto=true and async=false is invalid. Setting async=true.");
    asyncProcess = true;
  }
  var batch = Batch();
  var asyncFrameHandler;
  var isProcessing = false;
  function addFunction(level, fn) {
    if (!isProcessing && autoProcess && asyncProcess && batch.size() === 0) {
      processBatchAsync();
    }
    batch.add(level, fn);
  }
  function processBatch() {
    isProcessing = true;
    while (batch.size()) {
      var processingBatch = batch;
      batch = Batch();
      processingBatch.process();
    }
    isProcessing = false;
  }
  function forceProcessBatch(localAsyncProcess) {
    if (isProcessing) {
      return;
    }
    if (localAsyncProcess === void 0) {
      localAsyncProcess = asyncProcess;
    }
    if (asyncFrameHandler) {
      cancelFrame(asyncFrameHandler);
      asyncFrameHandler = null;
    }
    if (localAsyncProcess) {
      processBatchAsync();
    } else {
      processBatch();
    }
  }
  function processBatchAsync() {
    asyncFrameHandler = requestFrame(processBatch);
  }
  function cancelFrame(listener) {
    var cancel = clearTimeout;
    return cancel(listener);
  }
  function requestFrame(callback) {
    var raf = function(fn) {
      return setTimeout(fn, 0);
    };
    return raf(callback);
  }
  return {
    add: addFunction,
    force: forceProcessBatch
  };
};
function Batch() {
  var batch = {};
  var size = 0;
  var topLevel = 0;
  var bottomLevel = 0;
  function add(level, fn) {
    if (!fn) {
      fn = level;
      level = 0;
    }
    if (level > topLevel) {
      topLevel = level;
    } else if (level < bottomLevel) {
      bottomLevel = level;
    }
    if (!batch[level]) {
      batch[level] = [];
    }
    batch[level].push(fn);
    size++;
  }
  function process2() {
    for (var level = bottomLevel; level <= topLevel; level++) {
      var fns = batch[level];
      for (var i = 0; i < fns.length; i++) {
        var fn = fns[i];
        fn();
      }
    }
  }
  function getSize() {
    return size;
  }
  return {
    add,
    process: process2,
    size: getSize
  };
}
var prop = "_erd";
function initState(element) {
  element[prop] = {};
  return getState(element);
}
function getState(element) {
  return element[prop];
}
function cleanState(element) {
  delete element[prop];
}
var stateHandler$1 = {
  initState,
  getState,
  cleanState
};
var browserDetector$1 = browserDetector$2.exports;
var object2 = function(options) {
  options = options || {};
  var reporter2 = options.reporter;
  var batchProcessor2 = options.batchProcessor;
  var getState2 = options.stateHandler.getState;
  if (!reporter2) {
    throw new Error("Missing required dependency: reporter.");
  }
  function addListener(element, listener) {
    function listenerProxy() {
      listener(element);
    }
    if (browserDetector$1.isIE(8)) {
      getState2(element).object = {
        proxy: listenerProxy
      };
      element.attachEvent("onresize", listenerProxy);
    } else {
      var object3 = getObject(element);
      if (!object3) {
        throw new Error("Element is not detectable by this strategy.");
      }
      object3.contentDocument.defaultView.addEventListener("resize", listenerProxy);
    }
  }
  function buildCssTextString(rules2) {
    var seperator = options.important ? " !important; " : "; ";
    return (rules2.join(seperator) + seperator).trim();
  }
  function makeDetectable(options2, element, callback) {
    if (!callback) {
      callback = element;
      element = options2;
      options2 = null;
    }
    options2 = options2 || {};
    options2.debug;
    function injectObject(element2, callback2) {
      var OBJECT_STYLE = buildCssTextString(["display: block", "position: absolute", "top: 0", "left: 0", "width: 100%", "height: 100%", "border: none", "padding: 0", "margin: 0", "opacity: 0", "z-index: -1000", "pointer-events: none"]);
      var positionCheckPerformed = false;
      var style2 = window.getComputedStyle(element2);
      var width = element2.offsetWidth;
      var height2 = element2.offsetHeight;
      getState2(element2).startSize = {
        width,
        height: height2
      };
      function mutateDom() {
        function alterPositionStyles() {
          if (style2.position === "static") {
            element2.style.setProperty("position", "relative", options2.important ? "important" : "");
            var removeRelativeStyles = function(reporter3, element3, style3, property) {
              function getNumericalValue(value2) {
                return value2.replace(/[^-\d\.]/g, "");
              }
              var value = style3[property];
              if (value !== "auto" && getNumericalValue(value) !== "0") {
                reporter3.warn("An element that is positioned static has style." + property + "=" + value + " which is ignored due to the static positioning. The element will need to be positioned relative, so the style." + property + " will be set to 0. Element: ", element3);
                element3.style.setProperty(property, "0", options2.important ? "important" : "");
              }
            };
            removeRelativeStyles(reporter2, element2, style2, "top");
            removeRelativeStyles(reporter2, element2, style2, "right");
            removeRelativeStyles(reporter2, element2, style2, "bottom");
            removeRelativeStyles(reporter2, element2, style2, "left");
          }
        }
        function onObjectLoad() {
          if (!positionCheckPerformed) {
            alterPositionStyles();
          }
          function getDocument(element3, callback3) {
            if (!element3.contentDocument) {
              var state = getState2(element3);
              if (state.checkForObjectDocumentTimeoutId) {
                window.clearTimeout(state.checkForObjectDocumentTimeoutId);
              }
              state.checkForObjectDocumentTimeoutId = setTimeout(function checkForObjectDocument() {
                state.checkForObjectDocumentTimeoutId = 0;
                getDocument(element3, callback3);
              }, 100);
              return;
            }
            callback3(element3.contentDocument);
          }
          var objectElement = this;
          getDocument(objectElement, function onObjectDocumentReady(objectDocument) {
            callback2(element2);
          });
        }
        if (style2.position !== "") {
          alterPositionStyles();
          positionCheckPerformed = true;
        }
        var object3 = document.createElement("object");
        object3.style.cssText = OBJECT_STYLE;
        object3.tabIndex = -1;
        object3.type = "text/html";
        object3.setAttribute("aria-hidden", "true");
        object3.onload = onObjectLoad;
        if (!browserDetector$1.isIE()) {
          object3.data = "about:blank";
        }
        if (!getState2(element2)) {
          return;
        }
        element2.appendChild(object3);
        getState2(element2).object = object3;
        if (browserDetector$1.isIE()) {
          object3.data = "about:blank";
        }
      }
      if (batchProcessor2) {
        batchProcessor2.add(mutateDom);
      } else {
        mutateDom();
      }
    }
    if (browserDetector$1.isIE(8)) {
      callback(element);
    } else {
      injectObject(element, callback);
    }
  }
  function getObject(element) {
    return getState2(element).object;
  }
  function uninstall(element) {
    if (!getState2(element)) {
      return;
    }
    var object3 = getObject(element);
    if (!object3) {
      return;
    }
    if (browserDetector$1.isIE(8)) {
      element.detachEvent("onresize", object3.proxy);
    } else {
      element.removeChild(object3);
    }
    if (getState2(element).checkForObjectDocumentTimeoutId) {
      window.clearTimeout(getState2(element).checkForObjectDocumentTimeoutId);
    }
    delete getState2(element).object;
  }
  return {
    makeDetectable,
    addListener,
    uninstall
  };
};
var forEach$1 = collectionUtils.exports.forEach;
var scroll = function(options) {
  options = options || {};
  var reporter2 = options.reporter;
  var batchProcessor2 = options.batchProcessor;
  var getState2 = options.stateHandler.getState;
  options.stateHandler.hasState;
  var idHandler2 = options.idHandler;
  if (!batchProcessor2) {
    throw new Error("Missing required dependency: batchProcessor");
  }
  if (!reporter2) {
    throw new Error("Missing required dependency: reporter.");
  }
  var scrollbarSizes = getScrollbarSizes();
  var styleId = "erd_scroll_detection_scrollbar_style";
  var detectionContainerClass = "erd_scroll_detection_container";
  function initDocument(targetDocument) {
    injectScrollStyle(targetDocument, styleId, detectionContainerClass);
  }
  initDocument(window.document);
  function buildCssTextString(rules2) {
    var seperator = options.important ? " !important; " : "; ";
    return (rules2.join(seperator) + seperator).trim();
  }
  function getScrollbarSizes() {
    var width = 500;
    var height2 = 500;
    var child = document.createElement("div");
    child.style.cssText = buildCssTextString(["position: absolute", "width: " + width * 2 + "px", "height: " + height2 * 2 + "px", "visibility: hidden", "margin: 0", "padding: 0"]);
    var container = document.createElement("div");
    container.style.cssText = buildCssTextString(["position: absolute", "width: " + width + "px", "height: " + height2 + "px", "overflow: scroll", "visibility: none", "top: " + -width * 3 + "px", "left: " + -height2 * 3 + "px", "visibility: hidden", "margin: 0", "padding: 0"]);
    container.appendChild(child);
    document.body.insertBefore(container, document.body.firstChild);
    var widthSize = width - container.clientWidth;
    var heightSize = height2 - container.clientHeight;
    document.body.removeChild(container);
    return {
      width: widthSize,
      height: heightSize
    };
  }
  function injectScrollStyle(targetDocument, styleId2, containerClass) {
    function injectStyle(style3, method3) {
      method3 = method3 || function(element) {
        targetDocument.head.appendChild(element);
      };
      var styleElement = targetDocument.createElement("style");
      styleElement.innerHTML = style3;
      styleElement.id = styleId2;
      method3(styleElement);
      return styleElement;
    }
    if (!targetDocument.getElementById(styleId2)) {
      var containerAnimationClass = containerClass + "_animation";
      var containerAnimationActiveClass = containerClass + "_animation_active";
      var style2 = "/* Created by the element-resize-detector library. */\n";
      style2 += "." + containerClass + " > div::-webkit-scrollbar { " + buildCssTextString(["display: none"]) + " }\n\n";
      style2 += "." + containerAnimationActiveClass + " { " + buildCssTextString(["-webkit-animation-duration: 0.1s", "animation-duration: 0.1s", "-webkit-animation-name: " + containerAnimationClass, "animation-name: " + containerAnimationClass]) + " }\n";
      style2 += "@-webkit-keyframes " + containerAnimationClass + " { 0% { opacity: 1; } 50% { opacity: 0; } 100% { opacity: 1; } }\n";
      style2 += "@keyframes " + containerAnimationClass + " { 0% { opacity: 1; } 50% { opacity: 0; } 100% { opacity: 1; } }";
      injectStyle(style2);
    }
  }
  function addAnimationClass(element) {
    element.className += " " + detectionContainerClass + "_animation_active";
  }
  function addEvent(el, name2, cb) {
    if (el.addEventListener) {
      el.addEventListener(name2, cb);
    } else if (el.attachEvent) {
      el.attachEvent("on" + name2, cb);
    } else {
      return reporter2.error("[scroll] Don't know how to add event listeners.");
    }
  }
  function removeEvent(el, name2, cb) {
    if (el.removeEventListener) {
      el.removeEventListener(name2, cb);
    } else if (el.detachEvent) {
      el.detachEvent("on" + name2, cb);
    } else {
      return reporter2.error("[scroll] Don't know how to remove event listeners.");
    }
  }
  function getExpandElement(element) {
    return getState2(element).container.childNodes[0].childNodes[0].childNodes[0];
  }
  function getShrinkElement(element) {
    return getState2(element).container.childNodes[0].childNodes[0].childNodes[1];
  }
  function addListener(element, listener) {
    var listeners = getState2(element).listeners;
    if (!listeners.push) {
      throw new Error("Cannot add listener to an element that is not detectable.");
    }
    getState2(element).listeners.push(listener);
  }
  function makeDetectable(options2, element, callback) {
    if (!callback) {
      callback = element;
      element = options2;
      options2 = null;
    }
    options2 = options2 || {};
    function debug() {
      if (options2.debug) {
        var args = Array.prototype.slice.call(arguments);
        args.unshift(idHandler2.get(element), "Scroll: ");
        if (reporter2.log.apply) {
          reporter2.log.apply(null, args);
        } else {
          for (var i = 0; i < args.length; i++) {
            reporter2.log(args[i]);
          }
        }
      }
    }
    function isDetached(element2) {
      function isInDocument(element3) {
        var isInShadowRoot = element3.getRootNode && element3.getRootNode().contains(element3);
        return element3 === element3.ownerDocument.body || element3.ownerDocument.body.contains(element3) || isInShadowRoot;
      }
      if (!isInDocument(element2)) {
        return true;
      }
      if (window.getComputedStyle(element2) === null) {
        return true;
      }
      return false;
    }
    function isUnrendered(element2) {
      var container = getState2(element2).container.childNodes[0];
      var style2 = window.getComputedStyle(container);
      return !style2.width || style2.width.indexOf("px") === -1;
    }
    function getStyle2() {
      var elementStyle = window.getComputedStyle(element);
      var style2 = {};
      style2.position = elementStyle.position;
      style2.width = element.offsetWidth;
      style2.height = element.offsetHeight;
      style2.top = elementStyle.top;
      style2.right = elementStyle.right;
      style2.bottom = elementStyle.bottom;
      style2.left = elementStyle.left;
      style2.widthCSS = elementStyle.width;
      style2.heightCSS = elementStyle.height;
      return style2;
    }
    function storeStartSize() {
      var style2 = getStyle2();
      getState2(element).startSize = {
        width: style2.width,
        height: style2.height
      };
      debug("Element start size", getState2(element).startSize);
    }
    function initListeners() {
      getState2(element).listeners = [];
    }
    function storeStyle() {
      debug("storeStyle invoked.");
      if (!getState2(element)) {
        debug("Aborting because element has been uninstalled");
        return;
      }
      var style2 = getStyle2();
      getState2(element).style = style2;
    }
    function storeCurrentSize(element2, width, height2) {
      getState2(element2).lastWidth = width;
      getState2(element2).lastHeight = height2;
    }
    function getExpandChildElement(element2) {
      return getExpandElement(element2).childNodes[0];
    }
    function getWidthOffset() {
      return 2 * scrollbarSizes.width + 1;
    }
    function getHeightOffset() {
      return 2 * scrollbarSizes.height + 1;
    }
    function getExpandWidth(width) {
      return width + 10 + getWidthOffset();
    }
    function getExpandHeight(height2) {
      return height2 + 10 + getHeightOffset();
    }
    function getShrinkWidth(width) {
      return width * 2 + getWidthOffset();
    }
    function getShrinkHeight(height2) {
      return height2 * 2 + getHeightOffset();
    }
    function positionScrollbars(element2, width, height2) {
      var expand = getExpandElement(element2);
      var shrink = getShrinkElement(element2);
      var expandWidth = getExpandWidth(width);
      var expandHeight = getExpandHeight(height2);
      var shrinkWidth = getShrinkWidth(width);
      var shrinkHeight = getShrinkHeight(height2);
      expand.scrollLeft = expandWidth;
      expand.scrollTop = expandHeight;
      shrink.scrollLeft = shrinkWidth;
      shrink.scrollTop = shrinkHeight;
    }
    function injectContainerElement() {
      var container = getState2(element).container;
      if (!container) {
        container = document.createElement("div");
        container.className = detectionContainerClass;
        container.style.cssText = buildCssTextString(["visibility: hidden", "display: inline", "width: 0px", "height: 0px", "z-index: -1", "overflow: hidden", "margin: 0", "padding: 0"]);
        getState2(element).container = container;
        addAnimationClass(container);
        element.appendChild(container);
        var onAnimationStart = function() {
          getState2(element).onRendered && getState2(element).onRendered();
        };
        addEvent(container, "animationstart", onAnimationStart);
        getState2(element).onAnimationStart = onAnimationStart;
      }
      return container;
    }
    function injectScrollElements() {
      function alterPositionStyles() {
        var style2 = getState2(element).style;
        if (style2.position === "static") {
          element.style.setProperty("position", "relative", options2.important ? "important" : "");
          var removeRelativeStyles = function(reporter3, element2, style3, property) {
            function getNumericalValue(value2) {
              return value2.replace(/[^-\d\.]/g, "");
            }
            var value = style3[property];
            if (value !== "auto" && getNumericalValue(value) !== "0") {
              reporter3.warn("An element that is positioned static has style." + property + "=" + value + " which is ignored due to the static positioning. The element will need to be positioned relative, so the style." + property + " will be set to 0. Element: ", element2);
              element2.style[property] = 0;
            }
          };
          removeRelativeStyles(reporter2, element, style2, "top");
          removeRelativeStyles(reporter2, element, style2, "right");
          removeRelativeStyles(reporter2, element, style2, "bottom");
          removeRelativeStyles(reporter2, element, style2, "left");
        }
      }
      function getLeftTopBottomRightCssText(left, top2, bottom, right) {
        left = !left ? "0" : left + "px";
        top2 = !top2 ? "0" : top2 + "px";
        bottom = !bottom ? "0" : bottom + "px";
        right = !right ? "0" : right + "px";
        return ["left: " + left, "top: " + top2, "right: " + right, "bottom: " + bottom];
      }
      debug("Injecting elements");
      if (!getState2(element)) {
        debug("Aborting because element has been uninstalled");
        return;
      }
      alterPositionStyles();
      var rootContainer = getState2(element).container;
      if (!rootContainer) {
        rootContainer = injectContainerElement();
      }
      var scrollbarWidth = scrollbarSizes.width;
      var scrollbarHeight = scrollbarSizes.height;
      var containerContainerStyle = buildCssTextString(["position: absolute", "flex: none", "overflow: hidden", "z-index: -1", "visibility: hidden", "width: 100%", "height: 100%", "left: 0px", "top: 0px"]);
      var containerStyle = buildCssTextString(["position: absolute", "flex: none", "overflow: hidden", "z-index: -1", "visibility: hidden"].concat(getLeftTopBottomRightCssText(-(1 + scrollbarWidth), -(1 + scrollbarHeight), -scrollbarHeight, -scrollbarWidth)));
      var expandStyle = buildCssTextString(["position: absolute", "flex: none", "overflow: scroll", "z-index: -1", "visibility: hidden", "width: 100%", "height: 100%"]);
      var shrinkStyle = buildCssTextString(["position: absolute", "flex: none", "overflow: scroll", "z-index: -1", "visibility: hidden", "width: 100%", "height: 100%"]);
      var expandChildStyle = buildCssTextString(["position: absolute", "left: 0", "top: 0"]);
      var shrinkChildStyle = buildCssTextString(["position: absolute", "width: 200%", "height: 200%"]);
      var containerContainer = document.createElement("div");
      var container = document.createElement("div");
      var expand = document.createElement("div");
      var expandChild = document.createElement("div");
      var shrink = document.createElement("div");
      var shrinkChild = document.createElement("div");
      containerContainer.dir = "ltr";
      containerContainer.style.cssText = containerContainerStyle;
      containerContainer.className = detectionContainerClass;
      container.className = detectionContainerClass;
      container.style.cssText = containerStyle;
      expand.style.cssText = expandStyle;
      expandChild.style.cssText = expandChildStyle;
      shrink.style.cssText = shrinkStyle;
      shrinkChild.style.cssText = shrinkChildStyle;
      expand.appendChild(expandChild);
      shrink.appendChild(shrinkChild);
      container.appendChild(expand);
      container.appendChild(shrink);
      containerContainer.appendChild(container);
      rootContainer.appendChild(containerContainer);
      function onExpandScroll() {
        var state = getState2(element);
        if (state && state.onExpand) {
          state.onExpand();
        } else {
          debug("Aborting expand scroll handler: element has been uninstalled");
        }
      }
      function onShrinkScroll() {
        var state = getState2(element);
        if (state && state.onShrink) {
          state.onShrink();
        } else {
          debug("Aborting shrink scroll handler: element has been uninstalled");
        }
      }
      addEvent(expand, "scroll", onExpandScroll);
      addEvent(shrink, "scroll", onShrinkScroll);
      getState2(element).onExpandScroll = onExpandScroll;
      getState2(element).onShrinkScroll = onShrinkScroll;
    }
    function registerListenersAndPositionElements() {
      function updateChildSizes(element2, width, height2) {
        var expandChild = getExpandChildElement(element2);
        var expandWidth = getExpandWidth(width);
        var expandHeight = getExpandHeight(height2);
        expandChild.style.setProperty("width", expandWidth + "px", options2.important ? "important" : "");
        expandChild.style.setProperty("height", expandHeight + "px", options2.important ? "important" : "");
      }
      function updateDetectorElements(done) {
        var width = element.offsetWidth;
        var height2 = element.offsetHeight;
        var sizeChanged = width !== getState2(element).lastWidth || height2 !== getState2(element).lastHeight;
        debug("Storing current size", width, height2);
        storeCurrentSize(element, width, height2);
        batchProcessor2.add(0, function performUpdateChildSizes() {
          if (!sizeChanged) {
            return;
          }
          if (!getState2(element)) {
            debug("Aborting because element has been uninstalled");
            return;
          }
          if (!areElementsInjected()) {
            debug("Aborting because element container has not been initialized");
            return;
          }
          if (options2.debug) {
            var w = element.offsetWidth;
            var h2 = element.offsetHeight;
            if (w !== width || h2 !== height2) {
              reporter2.warn(idHandler2.get(element), "Scroll: Size changed before updating detector elements.");
            }
          }
          updateChildSizes(element, width, height2);
        });
        batchProcessor2.add(1, function updateScrollbars() {
          if (!getState2(element)) {
            debug("Aborting because element has been uninstalled");
            return;
          }
          if (!areElementsInjected()) {
            debug("Aborting because element container has not been initialized");
            return;
          }
          positionScrollbars(element, width, height2);
        });
        if (sizeChanged && done) {
          batchProcessor2.add(2, function() {
            if (!getState2(element)) {
              debug("Aborting because element has been uninstalled");
              return;
            }
            if (!areElementsInjected()) {
              debug("Aborting because element container has not been initialized");
              return;
            }
            done();
          });
        }
      }
      function areElementsInjected() {
        return !!getState2(element).container;
      }
      function notifyListenersIfNeeded() {
        function isFirstNotify() {
          return getState2(element).lastNotifiedWidth === void 0;
        }
        debug("notifyListenersIfNeeded invoked");
        var state = getState2(element);
        if (isFirstNotify() && state.lastWidth === state.startSize.width && state.lastHeight === state.startSize.height) {
          return debug("Not notifying: Size is the same as the start size, and there has been no notification yet.");
        }
        if (state.lastWidth === state.lastNotifiedWidth && state.lastHeight === state.lastNotifiedHeight) {
          return debug("Not notifying: Size already notified");
        }
        debug("Current size not notified, notifying...");
        state.lastNotifiedWidth = state.lastWidth;
        state.lastNotifiedHeight = state.lastHeight;
        forEach$1(getState2(element).listeners, function(listener) {
          listener(element);
        });
      }
      function handleRender() {
        debug("startanimation triggered.");
        if (isUnrendered(element)) {
          debug("Ignoring since element is still unrendered...");
          return;
        }
        debug("Element rendered.");
        var expand = getExpandElement(element);
        var shrink = getShrinkElement(element);
        if (expand.scrollLeft === 0 || expand.scrollTop === 0 || shrink.scrollLeft === 0 || shrink.scrollTop === 0) {
          debug("Scrollbars out of sync. Updating detector elements...");
          updateDetectorElements(notifyListenersIfNeeded);
        }
      }
      function handleScroll() {
        debug("Scroll detected.");
        if (isUnrendered(element)) {
          debug("Scroll event fired while unrendered. Ignoring...");
          return;
        }
        updateDetectorElements(notifyListenersIfNeeded);
      }
      debug("registerListenersAndPositionElements invoked.");
      if (!getState2(element)) {
        debug("Aborting because element has been uninstalled");
        return;
      }
      getState2(element).onRendered = handleRender;
      getState2(element).onExpand = handleScroll;
      getState2(element).onShrink = handleScroll;
      var style2 = getState2(element).style;
      updateChildSizes(element, style2.width, style2.height);
    }
    function finalizeDomMutation() {
      debug("finalizeDomMutation invoked.");
      if (!getState2(element)) {
        debug("Aborting because element has been uninstalled");
        return;
      }
      var style2 = getState2(element).style;
      storeCurrentSize(element, style2.width, style2.height);
      positionScrollbars(element, style2.width, style2.height);
    }
    function ready() {
      callback(element);
    }
    function install2() {
      debug("Installing...");
      initListeners();
      storeStartSize();
      batchProcessor2.add(0, storeStyle);
      batchProcessor2.add(1, injectScrollElements);
      batchProcessor2.add(2, registerListenersAndPositionElements);
      batchProcessor2.add(3, finalizeDomMutation);
      batchProcessor2.add(4, ready);
    }
    debug("Making detectable...");
    if (isDetached(element)) {
      debug("Element is detached");
      injectContainerElement();
      debug("Waiting until element is attached...");
      getState2(element).onRendered = function() {
        debug("Element is now attached");
        install2();
      };
    } else {
      install2();
    }
  }
  function uninstall(element) {
    var state = getState2(element);
    if (!state) {
      return;
    }
    state.onExpandScroll && removeEvent(getExpandElement(element), "scroll", state.onExpandScroll);
    state.onShrinkScroll && removeEvent(getShrinkElement(element), "scroll", state.onShrinkScroll);
    state.onAnimationStart && removeEvent(state.container, "animationstart", state.onAnimationStart);
    state.container && element.removeChild(state.container);
  }
  return {
    makeDetectable,
    addListener,
    uninstall,
    initDocument
  };
};
var forEach = collectionUtils.exports.forEach;
var elementUtilsMaker = elementUtils;
var listenerHandlerMaker = listenerHandler;
var idGeneratorMaker = idGenerator;
var idHandlerMaker = idHandler;
var reporterMaker = reporter;
var browserDetector = browserDetector$2.exports;
var batchProcessorMaker2 = batchProcessor;
var stateHandler = stateHandler$1;
var objectStrategyMaker = object2;
var scrollStrategyMaker = scroll;
function isCollection(obj) {
  return Array.isArray(obj) || obj.length !== void 0;
}
function toArray(collection) {
  if (!Array.isArray(collection)) {
    var array3 = [];
    forEach(collection, function(obj) {
      array3.push(obj);
    });
    return array3;
  } else {
    return collection;
  }
}
function isElement$1(obj) {
  return obj && obj.nodeType === 1;
}
var elementResizeDetector = function(options) {
  options = options || {};
  var idHandler2;
  if (options.idHandler) {
    idHandler2 = {
      get: function(element) {
        return options.idHandler.get(element, true);
      },
      set: options.idHandler.set
    };
  } else {
    var idGenerator2 = idGeneratorMaker();
    var defaultIdHandler = idHandlerMaker({
      idGenerator: idGenerator2,
      stateHandler
    });
    idHandler2 = defaultIdHandler;
  }
  var reporter2 = options.reporter;
  if (!reporter2) {
    var quiet = reporter2 === false;
    reporter2 = reporterMaker(quiet);
  }
  var batchProcessor2 = getOption(options, "batchProcessor", batchProcessorMaker2({ reporter: reporter2 }));
  var globalOptions = {};
  globalOptions.callOnAdd = !!getOption(options, "callOnAdd", true);
  globalOptions.debug = !!getOption(options, "debug", false);
  var eventListenerHandler = listenerHandlerMaker(idHandler2);
  var elementUtils2 = elementUtilsMaker({
    stateHandler
  });
  var detectionStrategy;
  var desiredStrategy = getOption(options, "strategy", "object");
  var importantCssRules = getOption(options, "important", false);
  var strategyOptions = {
    reporter: reporter2,
    batchProcessor: batchProcessor2,
    stateHandler,
    idHandler: idHandler2,
    important: importantCssRules
  };
  if (desiredStrategy === "scroll") {
    if (browserDetector.isLegacyOpera()) {
      reporter2.warn("Scroll strategy is not supported on legacy Opera. Changing to object strategy.");
      desiredStrategy = "object";
    } else if (browserDetector.isIE(9)) {
      reporter2.warn("Scroll strategy is not supported on IE9. Changing to object strategy.");
      desiredStrategy = "object";
    }
  }
  if (desiredStrategy === "scroll") {
    detectionStrategy = scrollStrategyMaker(strategyOptions);
  } else if (desiredStrategy === "object") {
    detectionStrategy = objectStrategyMaker(strategyOptions);
  } else {
    throw new Error("Invalid strategy name: " + desiredStrategy);
  }
  var onReadyCallbacks = {};
  function listenTo(options2, elements, listener) {
    function onResizeCallback(element) {
      var listeners = eventListenerHandler.get(element);
      forEach(listeners, function callListenerProxy(listener2) {
        listener2(element);
      });
    }
    function addListener(callOnAdd2, element, listener2) {
      eventListenerHandler.add(element, listener2);
      if (callOnAdd2) {
        listener2(element);
      }
    }
    if (!listener) {
      listener = elements;
      elements = options2;
      options2 = {};
    }
    if (!elements) {
      throw new Error("At least one element required.");
    }
    if (!listener) {
      throw new Error("Listener required.");
    }
    if (isElement$1(elements)) {
      elements = [elements];
    } else if (isCollection(elements)) {
      elements = toArray(elements);
    } else {
      return reporter2.error("Invalid arguments. Must be a DOM element or a collection of DOM elements.");
    }
    var elementsReady = 0;
    var callOnAdd = getOption(options2, "callOnAdd", globalOptions.callOnAdd);
    var onReadyCallback = getOption(options2, "onReady", function noop2() {
    });
    var debug = getOption(options2, "debug", globalOptions.debug);
    forEach(elements, function attachListenerToElement(element) {
      if (!stateHandler.getState(element)) {
        stateHandler.initState(element);
        idHandler2.set(element);
      }
      var id = idHandler2.get(element);
      debug && reporter2.log("Attaching listener to element", id, element);
      if (!elementUtils2.isDetectable(element)) {
        debug && reporter2.log(id, "Not detectable.");
        if (elementUtils2.isBusy(element)) {
          debug && reporter2.log(id, "System busy making it detectable");
          addListener(callOnAdd, element, listener);
          onReadyCallbacks[id] = onReadyCallbacks[id] || [];
          onReadyCallbacks[id].push(function onReady() {
            elementsReady++;
            if (elementsReady === elements.length) {
              onReadyCallback();
            }
          });
          return;
        }
        debug && reporter2.log(id, "Making detectable...");
        elementUtils2.markBusy(element, true);
        return detectionStrategy.makeDetectable({ debug, important: importantCssRules }, element, function onElementDetectable(element2) {
          debug && reporter2.log(id, "onElementDetectable");
          if (stateHandler.getState(element2)) {
            elementUtils2.markAsDetectable(element2);
            elementUtils2.markBusy(element2, false);
            detectionStrategy.addListener(element2, onResizeCallback);
            addListener(callOnAdd, element2, listener);
            var state = stateHandler.getState(element2);
            if (state && state.startSize) {
              var width = element2.offsetWidth;
              var height2 = element2.offsetHeight;
              if (state.startSize.width !== width || state.startSize.height !== height2) {
                onResizeCallback(element2);
              }
            }
            if (onReadyCallbacks[id]) {
              forEach(onReadyCallbacks[id], function(callback) {
                callback();
              });
            }
          } else {
            debug && reporter2.log(id, "Element uninstalled before being detectable.");
          }
          delete onReadyCallbacks[id];
          elementsReady++;
          if (elementsReady === elements.length) {
            onReadyCallback();
          }
        });
      }
      debug && reporter2.log(id, "Already detecable, adding listener.");
      addListener(callOnAdd, element, listener);
      elementsReady++;
    });
    if (elementsReady === elements.length) {
      onReadyCallback();
    }
  }
  function uninstall(elements) {
    if (!elements) {
      return reporter2.error("At least one element is required.");
    }
    if (isElement$1(elements)) {
      elements = [elements];
    } else if (isCollection(elements)) {
      elements = toArray(elements);
    } else {
      return reporter2.error("Invalid arguments. Must be a DOM element or a collection of DOM elements.");
    }
    forEach(elements, function(element) {
      eventListenerHandler.removeAllListeners(element);
      detectionStrategy.uninstall(element);
      stateHandler.cleanState(element);
    });
  }
  function initDocument(targetDocument) {
    detectionStrategy.initDocument && detectionStrategy.initDocument(targetDocument);
  }
  return {
    listenTo,
    removeListener: eventListenerHandler.removeListener,
    removeAllListeners: eventListenerHandler.removeAllListeners,
    uninstall,
    initDocument
  };
};
function getOption(options, name2, defaultValue) {
  var value = options[name2];
  if ((value === void 0 || value === null) && defaultValue !== void 0) {
    return defaultValue;
  }
  return value;
}
var FUNC_ERROR_TEXT = "Expected a function";
var NAN = 0 / 0;
var symbolTag = "[object Symbol]";
var reTrim = /^\s+|\s+$/g;
var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
var reIsBinary = /^0b[01]+$/i;
var reIsOctal = /^0o[0-7]+$/i;
var freeParseInt = parseInt;
var freeGlobal = typeof commonjsGlobal == "object" && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;
var freeSelf = typeof self == "object" && self && self.Object === Object && self;
var root = freeGlobal || freeSelf || Function("return this")();
var objectProto = Object.prototype;
var objectToString = objectProto.toString;
var nativeMax = Math.max, nativeMin = Math.min;
var now = function() {
  return root.Date.now();
};
function debounce(func, wait, options) {
  var lastArgs, lastThis, maxWait, result, timerId, lastCallTime, lastInvokeTime = 0, leading = false, maxing = false, trailing = true;
  if (typeof func != "function") {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  wait = toNumber(wait) || 0;
  if (isObject(options)) {
    leading = !!options.leading;
    maxing = "maxWait" in options;
    maxWait = maxing ? nativeMax(toNumber(options.maxWait) || 0, wait) : maxWait;
    trailing = "trailing" in options ? !!options.trailing : trailing;
  }
  function invokeFunc(time) {
    var args = lastArgs, thisArg = lastThis;
    lastArgs = lastThis = void 0;
    lastInvokeTime = time;
    result = func.apply(thisArg, args);
    return result;
  }
  function leadingEdge(time) {
    lastInvokeTime = time;
    timerId = setTimeout(timerExpired, wait);
    return leading ? invokeFunc(time) : result;
  }
  function remainingWait(time) {
    var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime, result2 = wait - timeSinceLastCall;
    return maxing ? nativeMin(result2, maxWait - timeSinceLastInvoke) : result2;
  }
  function shouldInvoke(time) {
    var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime;
    return lastCallTime === void 0 || timeSinceLastCall >= wait || timeSinceLastCall < 0 || maxing && timeSinceLastInvoke >= maxWait;
  }
  function timerExpired() {
    var time = now();
    if (shouldInvoke(time)) {
      return trailingEdge(time);
    }
    timerId = setTimeout(timerExpired, remainingWait(time));
  }
  function trailingEdge(time) {
    timerId = void 0;
    if (trailing && lastArgs) {
      return invokeFunc(time);
    }
    lastArgs = lastThis = void 0;
    return result;
  }
  function cancel() {
    if (timerId !== void 0) {
      clearTimeout(timerId);
    }
    lastInvokeTime = 0;
    lastArgs = lastCallTime = lastThis = timerId = void 0;
  }
  function flush() {
    return timerId === void 0 ? result : trailingEdge(now());
  }
  function debounced() {
    var time = now(), isInvoking = shouldInvoke(time);
    lastArgs = arguments;
    lastThis = this;
    lastCallTime = time;
    if (isInvoking) {
      if (timerId === void 0) {
        return leadingEdge(lastCallTime);
      }
      if (maxing) {
        timerId = setTimeout(timerExpired, wait);
        return invokeFunc(lastCallTime);
      }
    }
    if (timerId === void 0) {
      timerId = setTimeout(timerExpired, wait);
    }
    return result;
  }
  debounced.cancel = cancel;
  debounced.flush = flush;
  return debounced;
}
function throttle(func, wait, options) {
  var leading = true, trailing = true;
  if (typeof func != "function") {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  if (isObject(options)) {
    leading = "leading" in options ? !!options.leading : leading;
    trailing = "trailing" in options ? !!options.trailing : trailing;
  }
  return debounce(func, wait, {
    "leading": leading,
    "maxWait": wait,
    "trailing": trailing
  });
}
function isObject(value) {
  var type2 = typeof value;
  return !!value && (type2 == "object" || type2 == "function");
}
function isObjectLike(value) {
  return !!value && typeof value == "object";
}
function isSymbol(value) {
  return typeof value == "symbol" || isObjectLike(value) && objectToString.call(value) == symbolTag;
}
function toNumber(value) {
  if (typeof value == "number") {
    return value;
  }
  if (isSymbol(value)) {
    return NAN;
  }
  if (isObject(value)) {
    var other = typeof value.valueOf == "function" ? value.valueOf() : value;
    value = isObject(other) ? other + "" : other;
  }
  if (typeof value != "string") {
    return value === 0 ? value : +value;
  }
  value = value.replace(reTrim, "");
  var isBinary = reIsBinary.test(value);
  return isBinary || reIsOctal.test(value) ? freeParseInt(value.slice(2), isBinary ? 2 : 8) : reIsBadHex.test(value) ? NAN : +value;
}
var lodash_throttle = throttle;
const _sfc_main$1f = {
  name: "Grid",
  provide() {
    return {
      GridInstance: this
    };
  },
  props: {
    col: {
      type: Number,
      default: 3
    },
    square: {
      type: Boolean,
      default: false
    },
    padding: {
      type: String,
      default: "24px"
    },
    center: {
      type: Boolean,
      default: false
    },
    border: {
      type: Boolean,
      default: true
    },
    hover: {
      type: Boolean,
      default: false
    }
  },
  data() {
    return {
      resizeCount: 0,
      handleResize: () => {
      }
    };
  },
  computed: {
    classes() {
      return {
        "ivu-grid-center": this.center,
        "ivu-grid-border": this.border,
        "ivu-grid-hover": this.hover
      };
    }
  },
  methods: {
    onResize() {
      this.resizeCount++;
    }
  },
  mounted() {
    this.handleResize = lodash_throttle(this.onResize, 150, { leading: false });
    this.observer = elementResizeDetector();
    this.observer.listenTo(this.$refs.grid, this.handleResize);
  },
  beforeUnmount() {
    this.observer.removeListener(this.$refs.grid, this.handleResize);
  }
};
function _sfc_render$13(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(["ivu-grid", $options.classes]),
    ref: "grid"
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 2);
}
var Grid = /* @__PURE__ */ _export_sfc(_sfc_main$1f, [["render", _sfc_render$13]]);
const _sfc_main$1e = {
  name: "GridItem",
  inject: ["GridInstance"],
  data() {
    return {
      height: 0
    };
  },
  computed: {
    col() {
      return this.GridInstance.col;
    },
    square() {
      return this.GridInstance.square;
    },
    styles() {
      const style2 = {
        width: `${100 / this.col}%`
      };
      if (this.height && this.square) {
        style2.height = `${this.height}px`;
      }
      return style2;
    },
    mainStyles() {
      return {
        padding: this.GridInstance.padding
      };
    }
  },
  watch: {
    col() {
      nextTick(() => {
        this.handleChangeHeight();
      });
    },
    square() {
      this.handleChangeHeight();
    },
    "GridInstance.resizeCount"() {
      this.handleChangeHeight();
    }
  },
  methods: {
    handleChangeHeight() {
      if (this.square) {
        const $col = this.$refs.col;
        this.height = parseFloat(getStyle($col, "width"));
      }
    }
  },
  mounted() {
    this.handleChangeHeight();
  }
};
function _sfc_render$12(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: "ivu-grid-item",
    style: normalizeStyle($options.styles),
    ref: "col"
  }, [
    createElementVNode("div", {
      class: "ivu-grid-item-main",
      style: normalizeStyle($options.mainStyles)
    }, [
      renderSlot(_ctx.$slots, "default")
    ], 4)
  ], 4);
}
var GridItem = /* @__PURE__ */ _export_sfc(_sfc_main$1e, [["render", _sfc_render$12]]);
const prefixCls$D = "ivu-layout";
const _sfc_main$1d = {
  name: "Header",
  computed: {
    wrapClasses() {
      return `${prefixCls$D}-header`;
    }
  }
};
function _sfc_render$11(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.wrapClasses)
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 2);
}
var Header = /* @__PURE__ */ _export_sfc(_sfc_main$1d, [["render", _sfc_render$11]]);
const KeyCode = {
  MAC_ENTER: 3,
  BACKSPACE: 8,
  TAB: 9,
  NUM_CENTER: 12,
  ENTER: 13,
  SHIFT: 16,
  CTRL: 17,
  ALT: 18,
  PAUSE: 19,
  CAPS_LOCK: 20,
  ESC: 27,
  SPACE: 32,
  PAGE_UP: 33,
  PAGE_DOWN: 34,
  END: 35,
  HOME: 36,
  LEFT: 37,
  UP: 38,
  RIGHT: 39,
  DOWN: 40,
  PRINT_SCREEN: 44,
  INSERT: 45,
  DELETE: 46,
  ZERO: 48,
  ONE: 49,
  TWO: 50,
  THREE: 51,
  FOUR: 52,
  FIVE: 53,
  SIX: 54,
  SEVEN: 55,
  EIGHT: 56,
  NINE: 57,
  QUESTION_MARK: 63,
  A: 65,
  B: 66,
  C: 67,
  D: 68,
  E: 69,
  F: 70,
  G: 71,
  H: 72,
  I: 73,
  J: 74,
  K: 75,
  L: 76,
  M: 77,
  N: 78,
  O: 79,
  P: 80,
  Q: 81,
  R: 82,
  S: 83,
  T: 84,
  U: 85,
  V: 86,
  W: 87,
  X: 88,
  Y: 89,
  Z: 90,
  META: 91,
  WIN_KEY_RIGHT: 92,
  CONTEXT_MENU: 93,
  NUM_ZERO: 96,
  NUM_ONE: 97,
  NUM_TWO: 98,
  NUM_THREE: 99,
  NUM_FOUR: 100,
  NUM_FIVE: 101,
  NUM_SIX: 102,
  NUM_SEVEN: 103,
  NUM_EIGHT: 104,
  NUM_NINE: 105,
  NUM_MULTIPLY: 106,
  NUM_PLUS: 107,
  NUM_MINUS: 109,
  NUM_PERIOD: 110,
  NUM_DIVISION: 111,
  F1: 112,
  F2: 113,
  F3: 114,
  F4: 115,
  F5: 116,
  F6: 117,
  F7: 118,
  F8: 119,
  F9: 120,
  F10: 121,
  F11: 122,
  F12: 123,
  NUMLOCK: 144,
  SEMICOLON: 186,
  DASH: 189,
  EQUALS: 187,
  COMMA: 188,
  PERIOD: 190,
  SLASH: 191,
  APOSTROPHE: 192,
  SINGLE_QUOTE: 222,
  OPEN_SQUARE_BRACKET: 219,
  BACKSLASH: 220,
  CLOSE_SQUARE_BRACKET: 221,
  WIN_KEY: 224,
  MAC_FF_META: 224,
  WIN_IME: 229,
  isTextModifyingKeyEvent(e) {
    const { keyCode } = e;
    if (e.altKey && !e.ctrlKey || e.metaKey || keyCode >= KeyCode.F1 && keyCode <= KeyCode.F12) {
      return false;
    }
    switch (keyCode) {
      case KeyCode.ALT:
      case KeyCode.CAPS_LOCK:
      case KeyCode.CONTEXT_MENU:
      case KeyCode.CTRL:
      case KeyCode.DOWN:
      case KeyCode.END:
      case KeyCode.ESC:
      case KeyCode.HOME:
      case KeyCode.INSERT:
      case KeyCode.LEFT:
      case KeyCode.MAC_FF_META:
      case KeyCode.META:
      case KeyCode.NUMLOCK:
      case KeyCode.NUM_CENTER:
      case KeyCode.PAGE_DOWN:
      case KeyCode.PAGE_UP:
      case KeyCode.PAUSE:
      case KeyCode.PRINT_SCREEN:
      case KeyCode.RIGHT:
      case KeyCode.SHIFT:
      case KeyCode.UP:
      case KeyCode.WIN_KEY:
      case KeyCode.WIN_KEY_RIGHT:
        return false;
      default:
        return true;
    }
  },
  isCharacterKey(keyCode) {
    if (keyCode >= KeyCode.ZERO && keyCode <= KeyCode.NINE) {
      return true;
    }
    if (keyCode >= KeyCode.NUM_ZERO && keyCode <= KeyCode.NUM_MULTIPLY) {
      return true;
    }
    if (keyCode >= KeyCode.A && keyCode <= KeyCode.Z) {
      return true;
    }
    if (window.navigator.userAgent.indexOf("WebKit") !== -1 && keyCode === 0) {
      return true;
    }
    switch (keyCode) {
      case KeyCode.SPACE:
      case KeyCode.QUESTION_MARK:
      case KeyCode.NUM_PLUS:
      case KeyCode.NUM_MINUS:
      case KeyCode.NUM_PERIOD:
      case KeyCode.NUM_DIVISION:
      case KeyCode.SEMICOLON:
      case KeyCode.DASH:
      case KeyCode.EQUALS:
      case KeyCode.COMMA:
      case KeyCode.PERIOD:
      case KeyCode.SLASH:
      case KeyCode.APOSTROPHE:
      case KeyCode.SINGLE_QUOTE:
      case KeyCode.OPEN_SQUARE_BRACKET:
      case KeyCode.BACKSLASH:
      case KeyCode.CLOSE_SQUARE_BRACKET:
        return true;
      default:
        return false;
    }
  }
};
const prefixCls$C = "ivu-spin";
const _sfc_main$1c = {
  name: "Spin",
  mixins: [ScrollbarMixins],
  props: {
    size: {
      validator(value) {
        return oneOf(value, ["small", "large", "default"]);
      },
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.size === "" ? "default" : global2.$VIEWUI.size;
      }
    },
    fix: {
      type: Boolean,
      default: false
    },
    fullscreen: {
      type: Boolean,
      default: false
    },
    show: {
      type: Boolean,
      default: true
    }
  },
  data() {
    return {
      showText: false,
      visible: false
    };
  },
  computed: {
    classes() {
      return [
        `${prefixCls$C}`,
        {
          [`${prefixCls$C}-${this.size}`]: !!this.size,
          [`${prefixCls$C}-fix`]: this.fix,
          [`${prefixCls$C}-show-text`]: this.showText,
          [`${prefixCls$C}-fullscreen`]: this.fullscreen
        }
      ];
    },
    mainClasses() {
      return `${prefixCls$C}-main`;
    },
    dotClasses() {
      return `${prefixCls$C}-dot`;
    },
    textClasses() {
      return `${prefixCls$C}-text`;
    },
    fullscreenVisible() {
      if (this.fullscreen) {
        return this.visible;
      } else {
        return true;
      }
    }
  },
  watch: {
    visible(val) {
      if (val) {
        this.addScrollEffect();
      } else {
        this.removeScrollEffect();
      }
    }
  },
  mounted() {
    this.showText = !!this.$slots.default && this.$slots.default().some((item) => item.children && item.children.length);
  }
};
function _sfc_render$10(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createBlock(Transition, { name: "fade" }, {
    default: withCtx(() => [
      $options.fullscreenVisible && $props.show ? (openBlock(), createElementBlock("div", {
        key: 0,
        class: normalizeClass($options.classes)
      }, [
        createElementVNode("div", {
          class: normalizeClass($options.mainClasses)
        }, [
          createElementVNode("span", {
            class: normalizeClass($options.dotClasses)
          }, null, 2),
          createElementVNode("div", {
            class: normalizeClass($options.textClasses)
          }, [
            renderSlot(_ctx.$slots, "default")
          ], 2)
        ], 2)
      ], 2)) : createCommentVNode("", true)
    ]),
    _: 3
  });
}
var Spin = /* @__PURE__ */ _export_sfc(_sfc_main$1c, [["render", _sfc_render$10]]);
const _sfc_main$1b = {
  name: "ImagePreview",
  mixins: [Locale],
  components: { Icon, Spin, Row, Col },
  inheritAttrs: false,
  emits: ["update:modelValue", "on-close", "on-switch"],
  props: {
    modelValue: {
      type: Boolean,
      default: false
    },
    transfer: {
      type: Boolean,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.transfer === "" ? false : global2.$VIEWUI.transfer;
      }
    },
    maskClosable: {
      type: Boolean,
      default: true
    },
    previewList: {
      type: Array,
      default() {
        return [];
      }
    },
    initialIndex: {
      type: Number,
      default: 0
    },
    infinite: {
      type: Boolean,
      default: true
    },
    toolbar: {
      type: Array,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || !global2.$VIEWUI.image || global2.$VIEWUI.image.toolbar === "" ? ["zoomIn", "zoomOut", "original", "rotateLeft", "rotateRight", "download"] : global2.$VIEWUI.image.toolbar;
      }
    },
    renameImage: Function
  },
  data() {
    return {
      currentIndex: 0,
      scale: 1,
      degree: 0,
      translate: { x: 0, y: 0 },
      startX: 0,
      startY: 0,
      transition: true,
      original: false,
      prevOverflow: "",
      status: "loading",
      zIndex: 1e3,
      maskIndex: this.getMaskIndex(),
      downloading: false
    };
  },
  computed: {
    imgClasses() {
      return [
        "ivu-image-preview-image",
        {
          ["ivu-image-preview-grabbing"]: !this.transition,
          ["ivu-image-preview-hidden"]: this.status === "failed",
          ["ivu-image-preview-transition"]: this.transition,
          ["ivu-image-preview-limit"]: !this.original
        }
      ];
    },
    imageStyle() {
      let translateX = this.translate.x / this.scale;
      let translateY = this.translate.y / this.scale;
      const mod = this.degree % 360;
      if ([90, -270].includes(mod)) {
        [translateX, translateY] = [translateY, -translateX];
      }
      if ([180, -180].includes(mod)) {
        [translateX, translateY] = [-translateX, -translateY];
      }
      if ([270, -90].includes(mod)) {
        [translateX, translateY] = [-translateY, translateX];
      }
      return {
        transform: `
                        scale(${this.scale})
                        rotate(${this.degree}deg)
                        translate(${translateX}px, ${translateY}px)
                    `
      };
    },
    maskStyle() {
      return {
        zIndex: this.maskIndex + this.zIndex
      };
    },
    leftClasses() {
      return [
        "ivu-image-preview-arrow-left",
        {
          ["ivu-image-preview-arrow-disabled"]: this.hasLeftSwitchEnd
        }
      ];
    },
    rightClasses() {
      return [
        "ivu-image-preview-arrow-right",
        {
          ["ivu-image-preview-arrow-disabled"]: this.hasRightSwitchEnd
        }
      ];
    },
    hasRightSwitchEnd() {
      const { currentIndex, infinite, previewList } = this;
      const len = previewList.length;
      return infinite ? false : currentIndex >= len - 1;
    },
    hasLeftSwitchEnd() {
      const { currentIndex, infinite } = this;
      return infinite ? false : currentIndex === 0;
    },
    currentSrc() {
      return this.previewList[this.currentIndex];
    },
    failLang() {
      return this.t("i.image.fail");
    }
  },
  methods: {
    resetStyle() {
      this.scale = 1;
      this.degree = 0;
      this.translate.x = 0;
      this.translate.y = 0;
    },
    handleClose() {
      this.$emit("update:modelValue", false);
      this.$emit("on-close");
    },
    handleClickMask() {
      if (!this.maskClosable)
        return;
      this.handleClose();
    },
    handleSwitch(next) {
      if (next) {
        if (this.currentIndex + 1 === this.previewList.length) {
          if (this.infinite) {
            this.resetStyle();
            this.currentIndex = 0;
          }
        } else {
          this.resetStyle();
          this.currentIndex += 1;
        }
      } else {
        if (this.currentIndex === 0) {
          if (this.infinite) {
            this.resetStyle();
            this.currentIndex = this.previewList.length - 1;
          }
        } else {
          this.resetStyle();
          this.currentIndex -= 1;
        }
      }
      this.$emit("on-switch", { currentIndex: this.currentIndex });
    },
    getImageSuffixName() {
      const { previewList, currentIndex } = this;
      let imagePath = previewList[currentIndex];
      const regImageSuffix = /\.(jpg|jpeg|ico|webp|png|pjpeg)$/gi;
      imagePath = imagePath.replace(regImageSuffix, "");
      const splitImagePath = imagePath.split("/");
      return splitImagePath[splitImagePath.length - 1];
    },
    handleDownloadImage() {
      const { previewList, renameImage, currentIndex } = this;
      const imageName = typeOf(renameImage) === "function" ? this.renameImage(currentIndex) : this.getImageSuffixName();
      downloadFile(previewList[currentIndex], imageName).then(() => {
        this.downloading = false;
      }).catch(() => {
        this.downloading = false;
      });
    },
    handleOperation(val) {
      if (val === "zoomIn" && this.scale < 6)
        this.scale += 0.25;
      if (val === "zoomOut" && this.scale > 0.25)
        this.scale -= 0.25;
      if (val === "rotateLeft")
        this.degree -= 90;
      if (val === "rotateRight")
        this.degree += 90;
      if (val === "original") {
        this.original = !this.original;
        this.transition = false;
        this.resetStyle();
        setTimeout(() => {
          this.transition = true;
        }, 0);
      }
      if (val === "download") {
        this.downloading = true;
        this.handleDownloadImage();
      }
    },
    handleKeydown(event) {
      if (!this.modelValue)
        return;
      const { keyCode } = event;
      if (keyCode === KeyCode.LEFT)
        this.handleSwitch(false);
      if (keyCode === KeyCode.RIGHT)
        this.handleSwitch(true);
      if (keyCode === KeyCode.UP)
        this.handleOperation("zoomIn");
      if (keyCode === KeyCode.DOWN)
        this.handleOperation("zoomOut");
      if (keyCode === KeyCode.SPACE) {
        event.preventDefault();
        this.original = !this.original;
      }
    },
    handleKeyup(event) {
      if (!this.modelValue)
        return;
      const { keyCode } = event;
      if (keyCode === KeyCode.ESC)
        this.handleClose();
    },
    handleWheel(event) {
      if (!this.modelValue)
        return;
      const { deltaY } = event;
      this.handleOperation(deltaY < 0 ? "zoomIn" : "zoomOut");
    },
    handleMousedown(event) {
      const { pageX, pageY, which } = event;
      if (which !== 1)
        return;
      this.startX = pageX;
      this.startY = pageY;
      this.transition = false;
      on(document, "mousemove", this.handleMousemove);
      on(document, "mouseup", this.handleMouseup);
    },
    handleMousemove: lodash_throttle(function(event) {
      event.stopPropagation();
      const { pageX, pageY } = event;
      this.translate.x += pageX - this.startX;
      this.translate.y += pageY - this.startY;
      this.startX = pageX;
      this.startY = pageY;
    }),
    handleMouseup() {
      this.transition = true;
      off(document, "mousemove", this.handleMousemove);
      off(document, "mouseup", this.handleMouseup);
    },
    getBodyOverflow() {
      return isClient ? document.body.style.overflow : "";
    },
    setBodyOverflow(val) {
      if (!isClient)
        return;
      document.body.style.overflow = val;
    },
    handleImageLoad() {
      this.status = "loaded";
    },
    handleImageError() {
      this.status = "failed";
    },
    getMaskIndex() {
      transferIncrease();
      return transferIndex;
    }
  },
  watch: {
    modelValue(val) {
      if (val) {
        this.currentIndex = this.initialIndex;
        this.resetStyle();
        this.original = false;
        this.prevOverflow = this.getBodyOverflow();
        this.setBodyOverflow("hidden");
        this.maskIndex = this.getMaskIndex();
      } else {
        this.setBodyOverflow(this.prevOverflow);
      }
    },
    currentIndex() {
      this.status = "loading";
    }
  },
  mounted() {
    on(document, "keydown", this.handleKeydown);
    on(document, "keyup", this.handleKeyup);
    on(document, "wheel", this.handleWheel);
  },
  beforeUnmount() {
    off(document, "keydown", this.handleKeydown);
    off(document, "keyup", this.handleKeyup);
    off(document, "wheel", this.handleWheel);
  }
};
const _hoisted_1$C = {
  key: 1,
  class: "ivu-image-preview-fail"
};
const _hoisted_2$o = ["src"];
const _hoisted_3$k = {
  class: "ivu-image-preview-operations-item ivu-image-preview-operations-wait ivu-anim-loop",
  viewBox: "0 0 1024 1024",
  version: "1.1",
  xmlns: "http://www.w3.org/2000/svg",
  "p-id": "7816",
  width: "200",
  height: "200"
};
function _sfc_render$$(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Spin = resolveComponent("Spin");
  const _component_Col = resolveComponent("Col");
  const _component_Row = resolveComponent("Row");
  const _component_Icon = resolveComponent("Icon");
  return openBlock(), createBlock(Teleport, {
    to: "body",
    disabled: !$props.transfer
  }, [
    createVNode(Transition, { name: "fade" }, {
      default: withCtx(() => [
        $props.modelValue ? (openBlock(), createElementBlock("div", {
          key: 0,
          class: "ivu-image-preview-mask",
          style: normalizeStyle($options.maskStyle)
        }, null, 4)) : createCommentVNode("", true)
      ]),
      _: 1
    }),
    createVNode(Transition, { name: "fade" }, {
      default: withCtx(() => [
        $props.modelValue ? (openBlock(), createElementBlock("div", {
          key: 0,
          class: "ivu-image-preview-wrap",
          style: normalizeStyle($options.maskStyle)
        }, [
          createElementVNode("div", mergeProps({ class: "ivu-image-preview" }, _ctx.$attrs, {
            onClick: _cache[14] || (_cache[14] = withModifiers((...args) => $options.handleClickMask && $options.handleClickMask(...args), ["stop"]))
          }), [
            $data.status === "loading" ? (openBlock(), createBlock(_component_Spin, {
              key: 0,
              size: "large",
              class: "ivu-image-preview-loading"
            })) : $data.status === "failed" ? (openBlock(), createElementBlock("div", _hoisted_1$C, [
              createElementVNode("span", null, toDisplayString($options.failLang), 1)
            ])) : createCommentVNode("", true),
            (openBlock(), createElementBlock("img", {
              class: normalizeClass($options.imgClasses),
              style: normalizeStyle($options.imageStyle),
              src: $options.currentSrc,
              key: $data.currentIndex.toString(),
              onClick: _cache[0] || (_cache[0] = withModifiers(() => {
              }, ["stop"])),
              onMousedown: _cache[1] || (_cache[1] = withModifiers((...args) => $options.handleMousedown && $options.handleMousedown(...args), ["stop", "prevent"])),
              onLoad: _cache[2] || (_cache[2] = (...args) => $options.handleImageLoad && $options.handleImageLoad(...args)),
              onError: _cache[3] || (_cache[3] = (...args) => $options.handleImageError && $options.handleImageError(...args))
            }, null, 46, _hoisted_2$o)),
            $props.toolbar && $props.toolbar.length > 0 ? (openBlock(), createBlock(_component_Row, {
              key: 2,
              "class-name": "ivu-image-preview-operations",
              wrap: false,
              onClick: _cache[11] || (_cache[11] = withModifiers(() => {
              }, ["stop"]))
            }, {
              default: withCtx(() => [
                $props.toolbar.indexOf("zoomIn") > -1 ? (openBlock(), createBlock(_component_Col, {
                  key: 0,
                  flex: "1",
                  order: $props.toolbar.indexOf("zoomIn") + 1
                }, {
                  default: withCtx(() => [
                    (openBlock(), createElementBlock("svg", {
                      class: "ivu-image-preview-operations-item",
                      onClick: _cache[4] || (_cache[4] = withModifiers(($event) => $options.handleOperation("zoomIn"), ["stop"])),
                      viewBox: "0 0 1024 1024",
                      version: "1.1",
                      xmlns: "http://www.w3.org/2000/svg",
                      "p-id": "7197",
                      width: "200",
                      height: "200"
                    }, _cache[15] || (_cache[15] = [
                      createElementVNode("path", {
                        d: "M637 443H519V309c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8v134H325c-4.4 0-8 3.6-8 8v60c0 4.4 3.6 8 8 8h118v134c0 4.4 3.6 8 8 8h60c4.4 0 8-3.6 8-8V519h118c4.4 0 8-3.6 8-8v-60c0-4.4-3.6-8-8-8z",
                        "p-id": "7198",
                        fill: "#ffffff"
                      }, null, -1),
                      createElementVNode("path", {
                        d: "M921 867L775 721c122.1-148.9 113.6-369.5-26-509-148-148.1-388.4-148.1-537 0-148.1 148.6-148.1 389 0 537 139.5 139.6 360.1 148.1 509 26l146 146c3.2 2.8 8.3 2.8 11 0l43-43c2.8-2.7 2.8-7.8 0-11zM696 696c-118.8 118.7-311.2 118.7-430 0-118.7-118.8-118.7-311.2 0-430 118.8-118.7 311.2-118.7 430 0 118.7 118.8 118.7 311.2 0 430z",
                        "p-id": "7199",
                        fill: "#ffffff"
                      }, null, -1)
                    ])))
                  ]),
                  _: 1
                }, 8, ["order"])) : createCommentVNode("", true),
                $props.toolbar.indexOf("zoomOut") > -1 ? (openBlock(), createBlock(_component_Col, {
                  key: 1,
                  flex: "1",
                  order: $props.toolbar.indexOf("zoomOut") + 1
                }, {
                  default: withCtx(() => [
                    (openBlock(), createElementBlock("svg", {
                      class: "ivu-image-preview-operations-item",
                      onClick: _cache[5] || (_cache[5] = withModifiers(($event) => $options.handleOperation("zoomOut"), ["stop"])),
                      viewBox: "0 0 1024 1024",
                      version: "1.1",
                      xmlns: "http://www.w3.org/2000/svg",
                      "p-id": "7412",
                      width: "200",
                      height: "200"
                    }, _cache[16] || (_cache[16] = [
                      createElementVNode("path", {
                        d: "M637 443H325c-4.4 0-8 3.6-8 8v60c0 4.4 3.6 8 8 8h312c4.4 0 8-3.6 8-8v-60c0-4.4-3.6-8-8-8z",
                        "p-id": "7413",
                        fill: "#ffffff"
                      }, null, -1),
                      createElementVNode("path", {
                        d: "M921 867L775 721c122.1-148.9 113.6-369.5-26-509-148-148.1-388.4-148.1-537 0-148.1 148.6-148.1 389 0 537 139.5 139.6 360.1 148.1 509 26l146 146c3.2 2.8 8.3 2.8 11 0l43-43c2.8-2.7 2.8-7.8 0-11zM696 696c-118.8 118.7-311.2 118.7-430 0-118.7-118.8-118.7-311.2 0-430 118.8-118.7 311.2-118.7 430 0 118.7 118.8 118.7 311.2 0 430z",
                        "p-id": "7414",
                        fill: "#ffffff"
                      }, null, -1)
                    ])))
                  ]),
                  _: 1
                }, 8, ["order"])) : createCommentVNode("", true),
                $props.toolbar.indexOf("original") > -1 ? (openBlock(), createBlock(_component_Col, {
                  key: 2,
                  flex: "1",
                  order: $props.toolbar.indexOf("original") + 1
                }, {
                  default: withCtx(() => [
                    withDirectives((openBlock(), createElementBlock("svg", {
                      class: "ivu-image-preview-operations-item",
                      onClick: _cache[6] || (_cache[6] = withModifiers(($event) => $options.handleOperation("original"), ["stop"])),
                      viewBox: "0 0 1024 1024",
                      version: "1.1",
                      xmlns: "http://www.w3.org/2000/svg",
                      "p-id": "26672",
                      width: "200",
                      height: "200"
                    }, _cache[17] || (_cache[17] = [
                      createElementVNode("path", {
                        d: "M358.058667 128H156.970667A28.970667 28.970667 0 0 0 128 157.013333v202.837334c0 7.978667 6.528 14.506667 14.506667 14.506666h43.434666a14.506667 14.506667 0 0 0 14.506667-14.506666V200.448h157.610667a14.506667 14.506667 0 0 0 14.506666-14.506667V142.506667a14.506667 14.506667 0 0 0-14.506666-14.506667zM881.493333 649.642667h-43.434666a14.506667 14.506667 0 0 0-14.506667 14.506666v159.402667h-157.610667a14.506667 14.506667 0 0 0-14.506666 14.506667v43.434666c0 7.978667 6.570667 14.506667 14.506666 14.506667h201.088c16 0 28.970667-12.928 28.970667-29.013333v-202.837334a14.506667 14.506667 0 0 0-14.506667-14.506666zM358.058667 823.552H200.448v-159.402667a14.506667 14.506667 0 0 0-14.506667-14.506666H142.506667a14.506667 14.506667 0 0 0-14.506667 14.506666v202.88c0 16 12.970667 28.970667 29.013333 28.970667h201.045334a14.506667 14.506667 0 0 0 14.506666-14.506667v-43.434666a14.506667 14.506667 0 0 0-14.506666-14.506667zM866.986667 128h-201.088a14.506667 14.506667 0 0 0-14.506667 14.506667v43.434666c0 7.978667 6.570667 14.506667 14.506667 14.506667h157.610666v159.402667c0 7.978667 6.528 14.506667 14.506667 14.506666h43.434667a14.506667 14.506667 0 0 0 14.506666-14.506666V156.970667A28.928 28.928 0 0 0 866.986667 128z",
                        "p-id": "26673",
                        fill: "#ffffff"
                      }, null, -1)
                    ]), 512)), [
                      [vShow, !this.original]
                    ]),
                    withDirectives((openBlock(), createElementBlock("svg", {
                      class: "ivu-image-preview-operations-item",
                      onClick: _cache[7] || (_cache[7] = withModifiers(($event) => $options.handleOperation("original"), ["stop"])),
                      viewBox: "0 0 1024 1024",
                      version: "1.1",
                      xmlns: "http://www.w3.org/2000/svg",
                      "p-id": "1976",
                      width: "200",
                      height: "200"
                    }, _cache[18] || (_cache[18] = [
                      createElementVNode("path", {
                        d: "M864 128H160c-19.2 0-32 12.8-32 32v704c0 19.2 12.8 32 32 32h704c19.2 0 32-12.8 32-32V160c0-19.2-12.8-32-32-32z m-32 704H192V192h640v640z",
                        "p-id": "1977",
                        fill: "#ffffff"
                      }, null, -1),
                      createElementVNode("path", {
                        d: "M320 384v288c0 19.2 12.8 32 32 32s32-12.8 32-32V352c0-19.2-12.8-32-32-32h-32c-19.2 0-32 12.8-32 32s12.8 32 32 32zM640 384v288c0 19.2 12.8 32 32 32s32-12.8 32-32V352c0-19.2-12.8-32-32-32h-32c-19.2 0-32 12.8-32 32s12.8 32 32 32z",
                        "p-id": "1978",
                        fill: "#ffffff"
                      }, null, -1),
                      createElementVNode("path", {
                        d: "M512 384m-32 0a32 32 0 1 0 64 0 32 32 0 1 0-64 0Z",
                        "p-id": "1979",
                        fill: "#ffffff"
                      }, null, -1),
                      createElementVNode("path", {
                        d: "M512 640m-32 0a32 32 0 1 0 64 0 32 32 0 1 0-64 0Z",
                        "p-id": "1980",
                        fill: "#ffffff"
                      }, null, -1)
                    ]), 512)), [
                      [vShow, this.original]
                    ])
                  ]),
                  _: 1
                }, 8, ["order"])) : createCommentVNode("", true),
                $props.toolbar.indexOf("rotateLeft") > -1 ? (openBlock(), createBlock(_component_Col, {
                  key: 3,
                  flex: "1",
                  order: $props.toolbar.indexOf("rotateLeft") + 1
                }, {
                  default: withCtx(() => [
                    (openBlock(), createElementBlock("svg", {
                      class: "ivu-image-preview-operations-item",
                      onClick: _cache[8] || (_cache[8] = withModifiers(($event) => $options.handleOperation("rotateLeft"), ["stop"])),
                      viewBox: "0 0 1024 1024",
                      version: "1.1",
                      xmlns: "http://www.w3.org/2000/svg",
                      "p-id": "13308",
                      width: "200",
                      height: "200"
                    }, _cache[19] || (_cache[19] = [
                      createElementVNode("path", {
                        d: "M672 418H144c-17.7 0-32 14.3-32 32v414c0 17.7 14.3 32 32 32h528c17.7 0 32-14.3 32-32V450c0-17.7-14.3-32-32-32z m-44 402H188V494h440v326z m191.3-491.5c-78.8-100.7-196-153.6-314.6-154.2l-0.2-64c0-6.5-7.6-10.1-12.6-6.1l-128 101c-4 3.1-3.9 9.1 0 12.3L492 318.6c5.1 4 12.7 0.4 12.6-6.1v-63.9c12.9 0.1 25.9 0.9 38.8 2.5 42.1 5.2 82.1 18.2 119 38.7 38.1 21.2 71.2 49.7 98.4 84.3 27.1 34.7 46.7 73.7 58.1 115.8 11 40.7 14 82.7 8.9 124.8-0.7 5.4-1.4 10.8-2.4 16.1h74.9c14.8-103.6-11.3-213-81-302.3z",
                        "p-id": "13309",
                        fill: "#ffffff"
                      }, null, -1)
                    ])))
                  ]),
                  _: 1
                }, 8, ["order"])) : createCommentVNode("", true),
                $props.toolbar.indexOf("rotateRight") > -1 ? (openBlock(), createBlock(_component_Col, {
                  key: 4,
                  flex: "1",
                  order: $props.toolbar.indexOf("rotateRight") + 1
                }, {
                  default: withCtx(() => [
                    (openBlock(), createElementBlock("svg", {
                      class: "ivu-image-preview-operations-item",
                      onClick: _cache[9] || (_cache[9] = withModifiers(($event) => $options.handleOperation("rotateRight"), ["stop"])),
                      viewBox: "0 0 1024 1024",
                      version: "1.1",
                      xmlns: "http://www.w3.org/2000/svg",
                      "p-id": "13521",
                      width: "200",
                      height: "200"
                    }, _cache[20] || (_cache[20] = [
                      createElementVNode("path", {
                        d: "M480.5 251.2c13-1.6 25.9-2.4 38.8-2.5v63.9c0 6.5 7.5 10.1 12.6 6.1L660 217.6c4-3.2 4-9.2 0-12.3l-128-101c-5.1-4-12.6-0.4-12.6 6.1l-0.2 64c-118.6 0.5-235.8 53.4-314.6 154.2-69.6 89.2-95.7 198.6-81.1 302.4h74.9c-0.9-5.3-1.7-10.7-2.4-16.1-5.1-42.1-2.1-84.1 8.9-124.8 11.4-42.2 31-81.1 58.1-115.8 27.2-34.7 60.3-63.2 98.4-84.3 37-20.6 76.9-33.6 119.1-38.8zM880 418H352c-17.7 0-32 14.3-32 32v414c0 17.7 14.3 32 32 32h528c17.7 0 32-14.3 32-32V450c0-17.7-14.3-32-32-32z m-44 402H396V494h440v326z",
                        "p-id": "13522",
                        fill: "#ffffff"
                      }, null, -1)
                    ])))
                  ]),
                  _: 1
                }, 8, ["order"])) : createCommentVNode("", true),
                $props.toolbar.indexOf("download") > -1 ? (openBlock(), createBlock(_component_Col, {
                  key: 5,
                  flex: "1",
                  order: $props.toolbar.indexOf("download") + 1
                }, {
                  default: withCtx(() => [
                    withDirectives((openBlock(), createElementBlock("svg", {
                      class: "ivu-image-preview-operations-item",
                      onClick: _cache[10] || (_cache[10] = withModifiers(($event) => $options.handleOperation("download"), ["stop"])),
                      viewBox: "0 0 1024 1024",
                      version: "1.1",
                      xmlns: "http://www.w3.org/2000/svg",
                      "p-id": "8825",
                      width: "200",
                      height: "200"
                    }, _cache[21] || (_cache[21] = [
                      createElementVNode("path", {
                        d: "M505.7 621c3.2 4.1 9.4 4.1 12.6 0l112-141.7c4.1-5.2 0.4-12.9-6.3-12.9h-72.1V120c0-4.4-3.6-8-8-8h-64c-4.4 0-8 3.6-8 8v346.3H400c-6.7 0-10.4 7.7-6.3 12.9l112 141.8z",
                        "p-id": "8826",
                        fill: "#ffffff"
                      }, null, -1),
                      createElementVNode("path", {
                        d: "M903 516h-64c-4.4 0-8 3.6-8 8v300c0 4.4-3.6 8-8 8H199c-4.4 0-8-3.6-8-8V524c0-4.4-3.6-8-8-8h-64c-4.4 0-8 3.6-8 8v372c0 8.8 7.2 16 16 16h768c8.8 0 16-7.2 16-16V524c0-4.4-3.6-8-8-8z",
                        "p-id": "8827",
                        fill: "#ffffff"
                      }, null, -1)
                    ]), 512)), [
                      [vShow, !$data.downloading]
                    ]),
                    withDirectives((openBlock(), createElementBlock("svg", _hoisted_3$k, _cache[22] || (_cache[22] = [
                      createElementVNode("path", {
                        d: "M512 64c247.2 0 448 200.8 448 448h-64c0-212-172-384-384-384V64z m0 832c-212 0-384-172-384-384H64c0 247.2 200.8 448 448 448v-64z",
                        "p-id": "7817",
                        fill: "#ffffff"
                      }, null, -1)
                    ]), 512)), [
                      [vShow, $data.downloading]
                    ])
                  ]),
                  _: 1
                }, 8, ["order"])) : createCommentVNode("", true)
              ]),
              _: 1
            })) : createCommentVNode("", true),
            $props.previewList.length > 1 ? (openBlock(), createBlock(_component_Icon, {
              key: 3,
              class: normalizeClass($options.leftClasses),
              type: "ios-arrow-back",
              onClick: _cache[12] || (_cache[12] = withModifiers(($event) => $options.handleSwitch(false), ["stop"]))
            }, null, 8, ["class"])) : createCommentVNode("", true),
            $props.previewList.length > 1 ? (openBlock(), createBlock(_component_Icon, {
              key: 4,
              class: normalizeClass($options.rightClasses),
              type: "ios-arrow-forward",
              onClick: _cache[13] || (_cache[13] = withModifiers(($event) => $options.handleSwitch(true), ["stop"]))
            }, null, 8, ["class"])) : createCommentVNode("", true),
            createVNode(_component_Icon, {
              class: "ivu-image-preview-arrow-close",
              type: "md-close",
              onClick: withModifiers($options.handleClose, ["stop"])
            }, null, 8, ["onClick"])
          ], 16)
        ], 4)) : createCommentVNode("", true)
      ]),
      _: 1
    })
  ], 8, ["disabled"]);
}
var ImagePreview = /* @__PURE__ */ _export_sfc(_sfc_main$1b, [["render", _sfc_render$$]]);
const isElement = (el) => {
  return typeof HTMLElement === "object" && el instanceof HTMLElement;
};
const _sfc_main$1a = {
  name: "Image",
  mixins: [Locale],
  components: { ImagePreview },
  emits: ["on-load", "on-error", "on-switch", "on-close", "on-click"],
  props: {
    src: {
      type: String,
      default: ""
    },
    alt: {
      type: String,
      default: ""
    },
    preview: {
      type: Boolean,
      default: false
    },
    referrerPolicy: {
      type: String,
      default: ""
    },
    width: {
      type: [String, Number],
      default: ""
    },
    height: {
      type: [String, Number],
      default: ""
    },
    fit: {
      type: String,
      default: ""
    },
    lazy: {
      type: Boolean,
      default: false
    },
    scrollContainer: {
      type: [String],
      default: ""
    },
    transfer: {
      type: Boolean,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.transfer === "" ? false : global2.$VIEWUI.transfer;
      }
    },
    maskClosable: {
      type: Boolean,
      default: true
    },
    previewList: {
      type: Array
    },
    infinite: {
      type: Boolean,
      default: true
    },
    initialIndex: {
      type: Number,
      default: 0
    },
    previewTip: {
      type: Boolean,
      default: true
    },
    toolbar: {
      type: Array,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || !global2.$VIEWUI.image || global2.$VIEWUI.image.toolbar === "" ? ["zoomIn", "zoomOut", "original", "rotateLeft", "rotateRight", "download"] : global2.$VIEWUI.image.toolbar;
      }
    },
    renameImage: Function
  },
  data() {
    return {
      loadingImage: false,
      loading: false,
      imageError: false,
      scrollElement: null,
      observer: null,
      imagePreviewModal: false
    };
  },
  watch: {
    src() {
      this.loadImage();
    }
  },
  computed: {
    innerClasses() {
      return [
        "ivu-image-inner",
        {
          ["ivu-image-cursor"]: this.preview
        }
      ];
    },
    imgClasses() {
      return [
        "ivu-image-img",
        {
          ["ivu-image-img-hidden"]: this.loading || this.imageError
        }
      ];
    },
    fitStyle() {
      const fitContains = ["fill", "contain", "cover", "none", "scale-down"];
      const { fit } = this;
      return fitContains.includes(fit) ? `object-fit:${fit};` : "";
    },
    imageStyles() {
      return {
        width: typeof this.width === "number" ? `${this.width}px` : this.width,
        height: typeof this.height === "number" ? `${this.height}px` : this.height
      };
    },
    loadingLang() {
      return this.t("i.select.loading");
    },
    failLang() {
      return this.t("i.image.fail");
    },
    previewLang() {
      return this.t("i.image.preview");
    },
    loadingType() {
      return this.lazy ? "lazy" : "eager";
    }
  },
  mounted() {
    isClient && this.handleImageEvent();
  },
  methods: {
    handleLazy() {
      const $el = this.$refs.image;
      const observer = this.observer = new IntersectionObserver(this.handlerObserveImage, {
        root: this.scrollElement,
        rootMargin: "0px",
        threshold: 0
      });
      observer.observe($el);
    },
    handlerObserveImage(entries) {
      for (let entry of entries) {
        if (entry.isIntersecting) {
          this.offObserver();
          this.loadImage();
        }
      }
    },
    addLazyImageListener() {
      const { scrollContainer } = this;
      this.scrollElement = null;
      if (isElement(scrollContainer)) {
        this.scrollElement = scrollContainer;
      } else if (scrollContainer && typeof scrollContainer === "string") {
        this.scrollElement = document.querySelector(scrollContainer);
      }
      this.handleLazy();
    },
    handleImageLoad() {
      this.loading = false;
      this.imageError = false;
      this.$emit("on-load");
    },
    handleImageError() {
      this.loading = false;
      this.imageError = true;
      this.loadingImage = false;
      this.$emit("on-error");
    },
    loadImage() {
      this.loading = true;
      this.imageError = false;
      this.loadingImage = true;
    },
    handleImageEvent() {
      const { lazy } = this;
      lazy ? this.addLazyImageListener() : this.loadImage();
    },
    offObserver() {
      const { observer } = this;
      observer && observer.disconnect();
    },
    handlePreview() {
      const { preview, initialIndex } = this;
      if (preview) {
        this.imagePreviewModal = true;
        this.$emit("on-click", { initialIndex });
      }
    },
    handleClose() {
      this.$emit("on-close");
    },
    handleSwitch(params) {
      this.$emit("on-switch", params);
    }
  },
  beforeUnmount() {
    this.offObserver();
  }
};
const _hoisted_1$B = {
  key: 0,
  class: "ivu-image-placeholder"
};
const _hoisted_2$n = {
  key: 1,
  class: "ivu-image-error"
};
const _hoisted_3$j = ["alt", "src", "loading", "referrerPolicy"];
const _hoisted_4$f = { class: "ivu-image-mark" };
function _sfc_render$_(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_ImagePreview = resolveComponent("ImagePreview");
  return openBlock(), createElementBlock("div", {
    class: "ivu-image",
    ref: "image",
    style: normalizeStyle($options.imageStyles)
  }, [
    $data.loading ? (openBlock(), createElementBlock("div", _hoisted_1$B, [
      renderSlot(_ctx.$slots, "placeholder", {}, () => [
        createElementVNode("span", null, toDisplayString($options.loadingLang), 1)
      ])
    ])) : $data.imageError ? (openBlock(), createElementBlock("div", _hoisted_2$n, [
      renderSlot(_ctx.$slots, "error", {}, () => [
        createElementVNode("span", null, toDisplayString($options.failLang), 1)
      ])
    ])) : createCommentVNode("", true),
    $data.loadingImage ? (openBlock(), createElementBlock("div", {
      key: 2,
      class: normalizeClass($options.innerClasses),
      onClick: _cache[2] || (_cache[2] = (...args) => $options.handlePreview && $options.handlePreview(...args))
    }, [
      createElementVNode("img", {
        class: normalizeClass($options.imgClasses),
        style: normalizeStyle([$options.fitStyle]),
        alt: $props.alt,
        src: $props.src,
        loading: $options.loadingType,
        referrerPolicy: $props.referrerPolicy,
        onLoad: _cache[0] || (_cache[0] = (...args) => $options.handleImageLoad && $options.handleImageLoad(...args)),
        onError: _cache[1] || (_cache[1] = (...args) => $options.handleImageError && $options.handleImageError(...args))
      }, null, 46, _hoisted_3$j),
      $props.preview && $props.previewTip ? renderSlot(_ctx.$slots, "preview", { key: 0 }, () => [
        createElementVNode("div", _hoisted_4$f, [
          createElementVNode("span", null, toDisplayString($options.previewLang), 1)
        ])
      ]) : createCommentVNode("", true)
    ], 2)) : createCommentVNode("", true),
    $props.preview ? (openBlock(), createBlock(_component_ImagePreview, {
      key: 3,
      modelValue: $data.imagePreviewModal,
      "onUpdate:modelValue": _cache[3] || (_cache[3] = ($event) => $data.imagePreviewModal = $event),
      "preview-list": $props.previewList,
      "initial-index": $props.initialIndex,
      infinite: $props.infinite,
      "mask-closable": $props.maskClosable,
      transfer: $props.transfer,
      toolbar: $props.toolbar,
      renameImage: $props.renameImage,
      onOnClose: $options.handleClose,
      onOnSwitch: $options.handleSwitch
    }, null, 8, ["modelValue", "preview-list", "initial-index", "infinite", "mask-closable", "transfer", "toolbar", "renameImage", "onOnClose", "onOnSwitch"])) : createCommentVNode("", true)
  ], 4);
}
var Image = /* @__PURE__ */ _export_sfc(_sfc_main$1a, [["render", _sfc_render$_]]);
ImagePreview.newInstance = (properties) => {
  if (!isClient)
    return;
  const _props = properties || {};
  let _instance = null;
  const Instance = createApp({
    data() {
      return Object.assign({}, _props, {
        visible: false,
        previewList: [],
        initialIndex: 0,
        toolbar: ["zoomIn", "zoomOut", "original", "rotateLeft", "rotateRight", "download"],
        infinite: true,
        maskClosable: true,
        transfer: true
      });
    },
    render() {
      return h(ImagePreview, Object.assign({}, _props, {
        ref: "imagePreview",
        modelValue: this.visible,
        previewList: this.previewList,
        initialIndex: this.initialIndex,
        toolbar: this.toolbar,
        infinite: this.infinite,
        maskClosable: this.maskClosable,
        transfer: this.transfer,
        "onOn-close": this.close
      }));
    },
    methods: {
      close() {
        this.visible = false;
        setTimeout(() => {
          this.destroy();
          this.onRemove();
        }, 300);
      },
      destroy() {
        Instance.unmount();
        document.body.removeChild(container);
      },
      onRemove() {
      }
    },
    created() {
      _instance = getCurrentInstance();
    }
  });
  const container = document.createElement("div");
  document.body.appendChild(container);
  Instance.mount(container);
  const imagePreview = _instance.refs.imagePreview;
  return {
    show(options) {
      Object.keys(options).forEach((key2) => {
        imagePreview.$parent[key2] = options[key2];
      });
      imagePreview.$parent.visible = true;
    },
    component: imagePreview
  };
};
let imagePreviewInstance;
function getImagePreviewInstance() {
  imagePreviewInstance = imagePreviewInstance || ImagePreview.newInstance();
  return imagePreviewInstance;
}
ImagePreview.show = function(props = {}) {
  const instance = getImagePreviewInstance();
  props.onRemove = function() {
    imagePreviewInstance = null;
  };
  instance.show(props);
};
const prefixCls$B = "ivu-input-number";
const iconPrefixCls$2 = "ivu-icon";
function addNum(num1, num2) {
  let sq1, sq2, m;
  try {
    sq1 = num1.toString().split(".")[1].length;
  } catch (e) {
    sq1 = 0;
  }
  try {
    sq2 = num2.toString().split(".")[1].length;
  } catch (e) {
    sq2 = 0;
  }
  m = Math.pow(10, Math.max(sq1, sq2));
  return (Math.round(num1 * m) + Math.round(num2 * m)) / m;
}
const _sfc_main$19 = {
  name: "InputNumber",
  mixins: [mixinsForm],
  emits: ["on-change", "on-focus", "on-blur", "update:modelValue"],
  props: {
    max: {
      type: Number,
      default: Infinity
    },
    min: {
      type: Number,
      default: -Infinity
    },
    step: {
      type: Number,
      default: 1
    },
    activeChange: {
      type: Boolean,
      default: true
    },
    modelValue: {
      type: Number,
      default: 1
    },
    size: {
      validator(value) {
        return oneOf(value, ["small", "large", "default"]);
      },
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.size === "" ? "default" : global2.$VIEWUI.size;
      }
    },
    disabled: {
      type: Boolean,
      default: false
    },
    autofocus: {
      type: Boolean,
      default: false
    },
    readonly: {
      type: Boolean,
      default: false
    },
    editable: {
      type: Boolean,
      default: true
    },
    name: {
      type: String
    },
    precision: {
      type: Number
    },
    elementId: {
      type: String
    },
    formatter: {
      type: Function
    },
    parser: {
      type: Function
    },
    placeholder: {
      type: String,
      default: ""
    },
    controlsOutside: {
      type: Boolean,
      default: false
    }
  },
  data() {
    return {
      focused: false,
      upDisabled: false,
      downDisabled: false,
      currentValue: this.modelValue
    };
  },
  computed: {
    wrapClasses() {
      return [
        `${prefixCls$B}`,
        {
          [`${prefixCls$B}-${this.size}`]: !!this.size,
          [`${prefixCls$B}-disabled`]: this.itemDisabled,
          [`${prefixCls$B}-focused`]: this.focused,
          [`${prefixCls$B}-controls-outside`]: this.controlsOutside
        }
      ];
    },
    handlerClasses() {
      return `${prefixCls$B}-handler-wrap`;
    },
    upClasses() {
      return [
        `${prefixCls$B}-handler`,
        `${prefixCls$B}-handler-up`,
        {
          [`${prefixCls$B}-handler-up-disabled`]: this.upDisabled
        }
      ];
    },
    innerUpClasses() {
      return `${prefixCls$B}-handler-up-inner ${iconPrefixCls$2} ${iconPrefixCls$2}-ios-arrow-up`;
    },
    downClasses() {
      return [
        `${prefixCls$B}-handler`,
        `${prefixCls$B}-handler-down`,
        {
          [`${prefixCls$B}-handler-down-disabled`]: this.downDisabled
        }
      ];
    },
    innerDownClasses() {
      return `${prefixCls$B}-handler-down-inner ${iconPrefixCls$2} ${iconPrefixCls$2}-ios-arrow-down`;
    },
    inputWrapClasses() {
      return `${prefixCls$B}-input-wrap`;
    },
    inputClasses() {
      return `${prefixCls$B}-input`;
    },
    precisionValue() {
      if (!this.currentValue)
        return this.currentValue;
      return this.precision ? this.currentValue.toFixed(this.precision) : this.currentValue;
    },
    formatterValue() {
      if (this.formatter && this.precisionValue !== null) {
        return this.formatter(this.precisionValue);
      } else {
        return this.precisionValue;
      }
    }
  },
  methods: {
    preventDefault(e) {
      e.preventDefault();
    },
    up(e) {
      const targetVal = Number(e.target.value);
      if (this.upDisabled && isNaN(targetVal)) {
        return false;
      }
      this.changeStep("up", e);
    },
    down(e) {
      const targetVal = Number(e.target.value);
      if (this.downDisabled && isNaN(targetVal)) {
        return false;
      }
      this.changeStep("down", e);
    },
    changeStep(type2, e) {
      if (this.itemDisabled || this.readonly) {
        return false;
      }
      const targetVal = Number(e.target.value);
      let val = Number(this.currentValue);
      const step = Number(this.step);
      if (isNaN(val)) {
        return false;
      }
      if (!isNaN(targetVal)) {
        if (type2 === "up") {
          if (addNum(targetVal, step) <= this.max) {
            val = targetVal;
          } else {
            return false;
          }
        } else if (type2 === "down") {
          if (addNum(targetVal, -step) >= this.min) {
            val = targetVal;
          } else {
            return false;
          }
        }
      }
      if (type2 === "up") {
        val = addNum(val, step);
      } else if (type2 === "down") {
        val = addNum(val, -step);
      }
      this.setValue(val);
    },
    setValue(val) {
      if (val && !isNaN(this.precision))
        val = Number(Number(val).toFixed(this.precision));
      const { min, max } = this;
      if (val !== null) {
        if (val > max) {
          val = max;
        } else if (val < min) {
          val = min;
        }
      }
      nextTick(() => {
        this.currentValue = val;
        this.$emit("update:modelValue", val);
        this.$emit("on-change", val);
        this.handleFormItemChange("change", val);
      });
    },
    focus(event) {
      this.focused = true;
      this.$emit("on-focus", event);
    },
    blur() {
      this.focused = false;
      this.$emit("on-blur");
      if (!findComponentUpward(this, ["DatePicker", "TimePicker", "Cascader", "Search"])) {
        this.handleFormItemChange("blur", this.currentValue);
      }
    },
    keyDown(e) {
      if (e.keyCode === 38) {
        e.preventDefault();
        this.up(e);
      } else if (e.keyCode === 40) {
        e.preventDefault();
        this.down(e);
      }
    },
    change(event) {
      if (event.type === "change" && this.activeChange)
        return;
      if (event.type === "input" && !this.activeChange)
        return;
      let val = event.target.value.trim();
      if (this.parser) {
        val = this.parser(val);
      }
      const isEmptyString = val.length === 0;
      if (isEmptyString) {
        this.setValue(null);
        return;
      }
      if (event.type === "input" && val.match(/^\-?\.?$|\.$/))
        return;
      val = Number(val);
      if (!isNaN(val)) {
        this.currentValue = val;
        this.setValue(val);
      } else {
        event.target.value = this.currentValue;
      }
    },
    changeVal(val) {
      val = Number(val);
      if (!isNaN(val)) {
        const step = this.step;
        this.upDisabled = val + step > this.max;
        this.downDisabled = val - step < this.min;
      } else {
        this.upDisabled = true;
        this.downDisabled = true;
      }
    }
  },
  mounted() {
    this.changeVal(this.currentValue);
  },
  watch: {
    modelValue(val) {
      this.currentValue = val;
    },
    currentValue(val) {
      this.changeVal(val);
    },
    min() {
      this.changeVal(this.currentValue);
    },
    max() {
      this.changeVal(this.currentValue);
    }
  }
};
const _hoisted_1$A = ["id", "disabled", "autofocus", "readonly", "name", "value", "placeholder"];
function _sfc_render$Z(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.wrapClasses)
  }, [
    !$props.controlsOutside ? (openBlock(), createElementBlock("div", {
      key: 0,
      class: normalizeClass($options.handlerClasses)
    }, [
      createElementVNode("a", {
        onClick: _cache[1] || (_cache[1] = (...args) => $options.up && $options.up(...args)),
        class: normalizeClass($options.upClasses)
      }, [
        createElementVNode("span", {
          class: normalizeClass($options.innerUpClasses),
          onClick: _cache[0] || (_cache[0] = (...args) => $options.preventDefault && $options.preventDefault(...args))
        }, null, 2)
      ], 2),
      createElementVNode("a", {
        onClick: _cache[3] || (_cache[3] = (...args) => $options.down && $options.down(...args)),
        class: normalizeClass($options.downClasses)
      }, [
        createElementVNode("span", {
          class: normalizeClass($options.innerDownClasses),
          onClick: _cache[2] || (_cache[2] = (...args) => $options.preventDefault && $options.preventDefault(...args))
        }, null, 2)
      ], 2)
    ], 2)) : createCommentVNode("", true),
    $props.controlsOutside ? (openBlock(), createElementBlock("div", {
      key: 1,
      class: normalizeClass(["ivu-input-number-controls-outside-btn ivu-input-number-controls-outside-down", { "ivu-input-number-controls-outside-btn-disabled": $data.downDisabled }]),
      onClick: _cache[4] || (_cache[4] = (...args) => $options.down && $options.down(...args))
    }, _cache[12] || (_cache[12] = [
      createElementVNode("i", { class: "ivu-icon ivu-icon-ios-remove" }, null, -1)
    ]), 2)) : createCommentVNode("", true),
    $props.controlsOutside ? (openBlock(), createElementBlock("div", {
      key: 2,
      class: normalizeClass(["ivu-input-number-controls-outside-btn ivu-input-number-controls-outside-up", { "ivu-input-number-controls-outside-btn-disabled": $data.upDisabled }]),
      onClick: _cache[5] || (_cache[5] = (...args) => $options.up && $options.up(...args))
    }, _cache[13] || (_cache[13] = [
      createElementVNode("i", { class: "ivu-icon ivu-icon-ios-add" }, null, -1)
    ]), 2)) : createCommentVNode("", true),
    createElementVNode("div", {
      class: normalizeClass($options.inputWrapClasses)
    }, [
      createElementVNode("input", {
        id: $props.elementId,
        class: normalizeClass($options.inputClasses),
        disabled: _ctx.itemDisabled,
        autocomplete: "off",
        spellcheck: "false",
        autofocus: $props.autofocus,
        onFocus: _cache[6] || (_cache[6] = (...args) => $options.focus && $options.focus(...args)),
        onBlur: _cache[7] || (_cache[7] = (...args) => $options.blur && $options.blur(...args)),
        onKeydown: _cache[8] || (_cache[8] = withModifiers((...args) => $options.keyDown && $options.keyDown(...args), ["stop"])),
        onInput: _cache[9] || (_cache[9] = (...args) => $options.change && $options.change(...args)),
        onMouseup: _cache[10] || (_cache[10] = (...args) => $options.preventDefault && $options.preventDefault(...args)),
        onChange: _cache[11] || (_cache[11] = (...args) => $options.change && $options.change(...args)),
        readonly: $props.readonly || !$props.editable,
        name: $props.name,
        value: $options.formatterValue,
        placeholder: $props.placeholder
      }, null, 42, _hoisted_1$A)
    ], 2)
  ], 2);
}
var InputNumber = /* @__PURE__ */ _export_sfc(_sfc_main$19, [["render", _sfc_render$Z]]);
const prefixCls$A = "ivu-layout";
const _sfc_main$18 = {
  name: "Layout",
  data() {
    return {
      hasSider: false
    };
  },
  computed: {
    wrapClasses() {
      return [
        `${prefixCls$A}`,
        {
          [`${prefixCls$A}-has-sider`]: this.hasSider
        }
      ];
    }
  },
  methods: {
    findSider() {
      return this.$slots.default().some((child) => child.type.name === "Sider");
    }
  },
  mounted() {
    this.hasSider = this.findSider();
  }
};
function _sfc_render$Y(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.wrapClasses)
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 2);
}
var Layout = /* @__PURE__ */ _export_sfc(_sfc_main$18, [["render", _sfc_render$Y]]);
const defaultCopyConfig = {
  tooltips: ["\u590D\u5236", "\u590D\u5236\u6210\u529F"],
  showTip: false,
  successTip: "\u590D\u5236\u6210\u529F",
  errorTip: "\u590D\u5236\u5931\u8D25"
};
const defaultEditConfig = {
  tooltip: "\u7F16\u8F91",
  editing: false,
  maxlength: "",
  autosize: true,
  triggerType: "icon"
};
const defaultEllipsisConfig = {
  rows: 1,
  tooltip: false,
  suffix: false,
  expandable: false,
  symbol: "\u5C55\u5F00"
};
var baseProps = {
  emits: ["update:modelValue"],
  mixins: [mixinsLink],
  props: {
    type: {
      validator(value) {
        return oneOf(value, ["secondary", "success", "warning", "danger", ""]);
      },
      default: ""
    },
    copyable: {
      type: Boolean,
      default: false
    },
    copyText: {
      type: String,
      default: ""
    },
    copyConfig: {
      type: Object,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.typography.copyConfig === "" ? defaultCopyConfig : global2.$VIEWUI.typography.copyConfig;
      }
    },
    editable: {
      type: Boolean,
      default: false
    },
    editConfig: {
      type: Object,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.typography.editConfig === "" ? defaultEditConfig : global2.$VIEWUI.typography.editConfig;
      }
    },
    ellipsis: {
      type: Boolean,
      default: false
    },
    ellipsisConfig: {
      type: Object,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.typography.ellipsisConfig === "" ? defaultEllipsisConfig : global2.$VIEWUI.typography.ellipsisConfig;
      }
    },
    disabled: {
      type: Boolean,
      default: false
    },
    code: {
      type: Boolean,
      default: false
    },
    delete: {
      type: Boolean,
      default: false
    },
    keyboard: {
      type: Boolean,
      default: false
    },
    mark: {
      type: Boolean,
      default: false
    },
    strong: {
      type: Boolean,
      default: false
    },
    underline: {
      type: Boolean,
      default: false
    },
    italic: {
      type: Boolean,
      default: false
    },
    modelValue: {
      type: String,
      default: ""
    },
    transfer: {
      type: Boolean,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.transfer === "" ? false : global2.$VIEWUI.transfer;
      }
    },
    theme: {
      validator(value) {
        return oneOf(value, ["dark", "light"]);
      },
      default: "dark"
    },
    maxWidth: {
      type: [String, Number],
      default: 250
    },
    placement: {
      validator(value) {
        return oneOf(value, ["top", "top-start", "top-end", "bottom", "bottom-start", "bottom-end", "left", "left-start", "left-end", "right", "right-start", "right-end"]);
      },
      default: "top"
    }
  },
  computed: {
    isHrefPattern() {
      const { to } = this;
      return !!to;
    },
    linkProps() {
      if (this.isHrefPattern) {
        const { linkUrl, target } = this;
        return { href: linkUrl, target };
      } else {
        return {};
      }
    },
    mergedCopyConfig() {
      return Object.assign({}, defaultCopyConfig, this.copyConfig);
    },
    mergedEditConfig() {
      return Object.assign({}, defaultEditConfig, this.editConfig);
    },
    mergedEllipsisConfig() {
      return Object.assign({}, defaultEllipsisConfig, this.ellipsisConfig);
    }
  },
  methods: {
    commonSlots() {
      const slots = {};
      if (this.$slots.default)
        slots.default = () => this.$slots.default();
      if (this.$slots.copyIcon)
        slots.copyIcon = (props) => this.$slots.copyIcon(props);
      if (this.$slots.editIcon)
        slots.editIcon = (props) => this.$slots.editIcon(props);
      if (this.$slots.enterIcon)
        slots.enterIcon = (props) => this.$slots.enterIcon(props);
      return slots;
    },
    commonEvents() {
      return {
        "onUpdate:modelValue": this.handleOnUpdateModelValue
      };
    },
    handleOnUpdateModelValue(value) {
      this.$emit("update:modelValue", value);
    }
  }
};
const _sfc_main$17 = {
  name: "TypographyBase",
  mixins: [baseProps],
  emits: ["on-copy-success", "on-copy-error", "on-edit-start", "on-edit-end", "on-edit-change", "on-edit-cancel"],
  props: {
    component: {
      type: String,
      default: "div"
    },
    level: {
      type: Number,
      default: 0
    }
  },
  data() {
    return {
      currentContent: this.modelValue,
      copied: false,
      copyTimeout: null,
      editing: false,
      editContent: "",
      lastKeyCode: "",
      isEditESC: false,
      ellipsisText: "",
      ellipsisContent: "",
      isEllipsis: false,
      ellipsisExpanded: false,
      observer: null
    };
  },
  created() {
    this.editing = this.mergedEditConfig.editing || false;
    if (this.editing)
      this.editContent = this.currentContent ? this.currentContent : this.handleGetContent();
  },
  watch: {
    modelValue(val) {
      this.currentContent = val;
    },
    editing(val) {
      if (!val) {
        nextTick(() => {
          this.handleRemoveObserver();
          this.handleCreateObserver();
        });
      }
    },
    isEllipsis() {
      nextTick(() => {
        this.handleRemoveObserver();
        this.handleCreateObserver();
      });
    },
    ellipsis: {
      handler(val) {
        if (val) {
          nextTick(() => {
            this.handleUpdateEllipsisStatus();
            this.handleCreateObserver();
          });
        } else {
          this.handleRemoveObserver();
        }
      },
      immediate: true
    }
  },
  computed: {
    classes() {
      return [
        "ivu-typography",
        {
          [`ivu-typography-${this.type}`]: this.type,
          [`ivu-typography-disabled`]: this.disabled,
          ["ivu-typography-ellipsis-line-clamp"]: this.ellipsis && !this.ellipsisExpanded,
          ["ivu-typography-ellipsis-single-line"]: this.ellipsis && !this.ellipsisExpanded && this.mergedEllipsisConfig.rows === 1
        }
      ];
    }
  },
  methods: {
    wrapperDecorations() {
      let content = this.currentContent ? this.currentContent : this.$slots.default ? this.$slots.default() : "";
      function wrap(needed, tag) {
        if (!needed)
          return;
        content = h(tag, content);
      }
      wrap(this.strong, "strong");
      wrap(this.underline, "u");
      wrap(this.delete, "del");
      wrap(this.code, "code");
      wrap(this.mark, "mark");
      wrap(this.keyboard, "kbd");
      wrap(this.italic, "i");
      return content;
    },
    handleClickContent(event) {
      if (!this.isHrefPattern && this.component !== "a") {
        const triggerType = this.mergedEditConfig.triggerType;
        if (this.editable && (triggerType === "text" || triggerType === "both"))
          this.handleEdit();
      } else {
        const openInNewWindow = event.ctrlKey || event.metaKey;
        this.handleCheckClick(event, openInNewWindow);
      }
    },
    handleGetContent() {
      const container = document.createElement("div");
      document.body.appendChild(container);
      let Instance = null;
      let _instance = null;
      let content = "";
      const textNode = this.wrapperDecorations();
      Instance = createApp({
        render() {
          return h("div", {
            ref: "text",
            style: {
              display: "none"
            }
          }, textNode);
        },
        created() {
          _instance = getCurrentInstance();
        }
      });
      Instance.mount(container);
      content = _instance.refs.text.innerText;
      Instance.unmount();
      document.body.removeChild(container);
      return content;
    },
    handleCopy() {
      let content = "";
      if (this.copyText)
        content = this.copyText;
      else if (this.currentContent)
        content = this.currentContent;
      else if (this.$slots.default)
        content = this.handleGetContent();
      Copy({
        text: this.copyText ? this.copyText : content,
        showTip: this.mergedCopyConfig.showTip,
        successTip: this.mergedCopyConfig.successTip,
        errorTip: this.mergedCopyConfig.errorTip,
        success: () => {
          this.$emit("on-copy-success");
          this.copied = true;
          if (this.copyTimeout)
            clearTimeout(this.copyTimeout);
          this.copyTimeout = setTimeout(() => {
            this.copied = false;
          }, 3e3);
        },
        error: () => {
          this.$emit("on-copy-error");
        }
      });
    },
    handleEdit() {
      this.editContent = this.currentContent ? this.currentContent : this.handleGetContent();
      nextTick(() => {
        this.editing = true;
        this.$emit("on-edit-start");
        nextTick(() => {
          this.$refs.edit.focus({
            cursor: "end"
          });
        });
      });
    },
    handleEditBlur() {
      if (this.isEditESC) {
        this.isEditESC = false;
        return;
      }
      this.handleEditSave();
      this.$emit("on-edit-end", this.editContent);
    },
    handleEditChange(event) {
      const value = event.target.value;
      this.editContent = value;
      this.$emit("on-edit-change", value);
    },
    handleEditSave() {
      this.$emit("update:modelValue", this.editContent);
      this.editing = false;
    },
    handleEditKeydown(e) {
      const { keyCode } = e;
      if (keyCode === KeyCode.ENTER)
        e.preventDefault();
      this.lastKeyCode = keyCode;
    },
    handleEditKeyup(e) {
      const { keyCode, ctrlKey, altKey, metaKey, shiftKey } = e;
      if (this.lastKeyCode === keyCode && !ctrlKey && !altKey && !metaKey && !shiftKey) {
        if (keyCode === KeyCode.ENTER) {
          this.handleEditSave();
          this.$emit("on-edit-end", this.editContent);
        } else if (keyCode === KeyCode.ESC) {
          this.isEditESC = true;
          this.$emit("on-edit-cancel");
          this.editing = false;
        }
      }
    },
    handleUpdateEllipsisStatus() {
      if (this.ellipsis && !this.ellipsisExpanded) {
        const $el = this.$refs.typography;
        this.isEllipsis = $el.scrollHeight > $el.clientHeight;
      } else {
        this.isEllipsis = false;
      }
    },
    handleCreateObserver() {
      if (this.ellipsis && !this.ellipsisExpanded) {
        this.observer = elementResizeDetector();
        this.observer.listenTo(this.$refs.typography, this.handleUpdateEllipsisStatus);
      }
    },
    handleRemoveObserver() {
      if (this.observer) {
        this.observer.removeListener(this.$refs.typography, this.handleUpdateEllipsisStatus);
        this.observer = null;
      }
    }
  },
  render() {
    let contentNodes = [];
    const textNode = this.wrapperDecorations();
    contentNodes.push(textNode);
    if (this.editable) {
      const triggerType = this.mergedEditConfig.triggerType;
      if (triggerType === "icon" || triggerType === "both") {
        const editIconNode = this.$slots.editIcon ? this.$slots.editIcon() : h(Icon, { type: "md-create" });
        const editButtonNode = h("div", {
          class: "ivu-typography-edit",
          onClick: this.handleEdit
        }, editIconNode);
        if (this.mergedEditConfig.tooltip) {
          const editTooltipNode = h(Tooltip, {
            content: this.mergedEditConfig.tooltip,
            placement: "top"
          }, () => editButtonNode);
          contentNodes.push(editTooltipNode);
        } else {
          contentNodes.push(editButtonNode);
        }
      }
    }
    if (this.copyable) {
      const copyIconNode = this.$slots.copyIcon ? this.$slots.copyIcon({ copied: this.copied }) : h(Icon, { type: this.copied ? "md-checkmark" : "md-copy" });
      const copyButtonNode = h("div", {
        class: [
          "ivu-typography-copy",
          {
            "ivu-typography-copy-success": this.copied
          }
        ],
        onClick: this.handleCopy
      }, copyIconNode);
      if (this.mergedCopyConfig.tooltips instanceof Array && this.mergedCopyConfig.tooltips.length === 2) {
        const copyTooltipNode = h(Tooltip, {
          content: this.copied ? this.mergedCopyConfig.tooltips[1] : this.mergedCopyConfig.tooltips[0],
          placement: "top"
        }, () => copyButtonNode);
        contentNodes.push(copyTooltipNode);
      } else {
        contentNodes.push(copyButtonNode);
      }
    }
    if (this.editing) {
      const textareaNode = h(Input, {
        ref: "edit",
        modelValue: this.editContent,
        type: "textarea",
        autosize: this.mergedEditConfig.autosize,
        maxlength: this.mergedEditConfig.maxlength,
        "onOn-blur": this.handleEditBlur,
        "onOn-keydown": this.handleEditKeydown,
        "onOn-keyup": this.handleEditKeyup,
        "onOn-change": this.handleEditChange
      });
      const enterIconNode = this.$slots.enterIcon ? this.$slots.enterIcon() : h(Icon, { type: "md-return-left" });
      const confirmNode = h("span", {
        class: "ivu-typography-edit-content-confirm"
      }, enterIconNode);
      return h("div", {
        class: [
          "ivu-typography",
          "ivu-typography-edit-content",
          {
            [`ivu-typography-h${this.level}`]: this.level,
            ["ivu-typography-div"]: !this.level
          }
        ]
      }, [textareaNode, confirmNode]);
    } else {
      const style2 = {};
      if (this.ellipsis && !this.ellipsisExpanded) {
        style2["-webkit-line-clamp"] = this.mergedEllipsisConfig.rows;
      }
      let ellipsisExtraNode = null;
      const baseNode = h(this.component, {
        ref: "typography",
        class: this.classes,
        ...this.linkProps,
        style: style2,
        onClick: this.handleClickContent
      }, [contentNodes, ellipsisExtraNode]);
      if (this.ellipsis && !this.ellipsisExpanded && this.isEllipsis && this.mergedEllipsisConfig.tooltip) {
        return h(Tooltip, {
          content: this.mergedEllipsisConfig.tooltip === true ? this.handleGetContent() : this.mergedEllipsisConfig.tooltip,
          placement: this.placement,
          transfer: this.transfer,
          theme: this.theme,
          maxWidth: this.maxWidth
        }, () => baseNode);
      } else {
        return baseNode;
      }
    }
  },
  beforeUnmount() {
    this.handleRemoveObserver();
  }
};
const _sfc_main$16 = {
  name: "Link",
  mixins: [baseProps],
  render() {
    return h(_sfc_main$17, {
      ...this.$props,
      component: "a",
      ...this.commonEvents()
    }, this.commonSlots());
  }
};
function handleGetIndex() {
  transferIncrease();
  return transferIndex;
}
let tIndex = handleGetIndex();
Spin.newInstance = (properties) => {
  if (!isClient)
    return;
  const _props = properties || {};
  let _instance = null;
  const Instance = createApp({
    data() {
      return Object.assign({}, _props, {});
    },
    render() {
      let vnode = "";
      if (this.render) {
        vnode = h(Spin, {
          fix: true,
          fullscreen: true,
          ref: "spin"
        }, [this.render(h)]);
      } else {
        vnode = h(Spin, {
          size: "large",
          fix: true,
          fullscreen: true,
          ref: "spin"
        });
      }
      return h("div", {
        "class": "ivu-spin-fullscreen ivu-spin-fullscreen-wrapper",
        "style": {
          "z-index": 2010 + tIndex
        }
      }, [vnode]);
    },
    created() {
      _instance = getCurrentInstance();
    }
  });
  const container = document.createElement("div");
  document.body.appendChild(container);
  Instance.mount(container);
  const spin2 = _instance.refs.spin;
  return {
    show() {
      nextTick(() => {
        _instance.refs.spin.visible = true;
        tIndex = handleGetIndex();
      });
    },
    remove(cb) {
      _instance.refs.spin.visible = false;
      setTimeout(function() {
        Instance.unmount();
        document.body.removeChild(container);
        cb();
      }, 500);
    },
    component: spin2
  };
};
let spinInstance;
function getSpinInstance(render = void 0) {
  spinInstance = spinInstance || Spin.newInstance({
    render
  });
  return spinInstance;
}
function loading(options) {
  const render = "render" in options ? options.render : void 0;
  let instance = getSpinInstance(render);
  instance.show(options);
}
Spin.show = function(props = {}) {
  return loading(props);
};
Spin.hide = function() {
  if (!spinInstance)
    return false;
  const instance = getSpinInstance();
  instance.remove(() => {
    spinInstance = null;
  });
};
const prefixCls$z = "ivu-list";
const _sfc_main$15 = {
  name: "List",
  provide() {
    return {
      ListInstance: this
    };
  },
  components: { Spin },
  props: {
    border: {
      type: Boolean,
      default: false
    },
    itemLayout: {
      validator(value) {
        return oneOf(value, ["horizontal", "vertical"]);
      },
      default: "horizontal"
    },
    header: {
      type: String,
      default: ""
    },
    footer: {
      type: String,
      default: ""
    },
    loading: {
      type: Boolean,
      default: false
    },
    size: {
      validator(value) {
        return oneOf(value, ["small", "large", "default"]);
      },
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.size === "" ? "default" : global2.$VIEWUI.size;
      }
    },
    split: {
      type: Boolean,
      default: true
    }
  },
  data() {
    return {};
  },
  computed: {
    classes() {
      return [
        `${prefixCls$z}`,
        `${prefixCls$z}-${this.size}`,
        `${prefixCls$z}-${this.itemLayout}`,
        {
          [`${prefixCls$z}-bordered`]: this.border,
          [`${prefixCls$z}-split`]: this.split
        }
      ];
    }
  },
  methods: {}
};
const _hoisted_1$z = {
  key: 0,
  class: "ivu-list-header"
};
const _hoisted_2$m = { class: "ivu-list-container" };
const _hoisted_3$i = { class: "ivu-list-items" };
const _hoisted_4$e = {
  key: 2,
  class: "ivu-list-footer"
};
function _sfc_render$X(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Spin = resolveComponent("Spin");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes)
  }, [
    $props.header || _ctx.$slots.header ? (openBlock(), createElementBlock("div", _hoisted_1$z, [
      renderSlot(_ctx.$slots, "header", {}, () => [
        createTextVNode(toDisplayString($props.header), 1)
      ])
    ])) : createCommentVNode("", true),
    createElementVNode("div", _hoisted_2$m, [
      createElementVNode("ul", _hoisted_3$i, [
        renderSlot(_ctx.$slots, "default")
      ])
    ]),
    $props.loading ? (openBlock(), createBlock(_component_Spin, {
      key: 1,
      fix: "",
      size: "large"
    }, {
      default: withCtx(() => [
        renderSlot(_ctx.$slots, "spin")
      ]),
      _: 3
    })) : createCommentVNode("", true),
    $props.footer || _ctx.$slots.footer ? (openBlock(), createElementBlock("div", _hoisted_4$e, [
      renderSlot(_ctx.$slots, "footer", {}, () => [
        createTextVNode(toDisplayString($props.footer), 1)
      ])
    ])) : createCommentVNode("", true)
  ], 2);
}
var List$1 = /* @__PURE__ */ _export_sfc(_sfc_main$15, [["render", _sfc_render$X]]);
const _sfc_main$14 = {
  name: "ListItem",
  inject: ["ListInstance"],
  props: {},
  computed: {
    itemLayout() {
      return this.ListInstance.itemLayout;
    },
    isItemContainsTextNode() {
      let result;
      this.$slots.default().forEach((item) => {
        if (typeof item === "string") {
          result = true;
        }
      });
      return result;
    },
    isFlexMode() {
      const extra = this.$slots.extra;
      if (this.itemLayout === "vertical") {
        return !!extra;
      }
      return !this.isItemContainsTextNode;
    },
    classes() {
      return [
        {
          "ivu-list-item-no-flex": !this.isFlexMode
        }
      ];
    }
  }
};
const _hoisted_1$y = { class: "ivu-list-item-main" };
const _hoisted_2$l = {
  key: 0,
  class: "ivu-list-item-action"
};
const _hoisted_3$h = { class: "ivu-list-item-extra" };
const _hoisted_4$d = {
  key: 0,
  class: "ivu-list-item-action"
};
const _hoisted_5$9 = { class: "ivu-list-item-extra" };
function _sfc_render$W(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("li", {
    class: normalizeClass(["ivu-list-item", $options.classes])
  }, [
    $options.itemLayout === "vertical" && _ctx.$slots.extra ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
      createElementVNode("div", _hoisted_1$y, [
        renderSlot(_ctx.$slots, "default"),
        _ctx.$slots.action ? (openBlock(), createElementBlock("ul", _hoisted_2$l, [
          renderSlot(_ctx.$slots, "action")
        ])) : createCommentVNode("", true)
      ]),
      createElementVNode("div", _hoisted_3$h, [
        renderSlot(_ctx.$slots, "extra")
      ])
    ], 64)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
      renderSlot(_ctx.$slots, "default"),
      _ctx.$slots.action ? (openBlock(), createElementBlock("ul", _hoisted_4$d, [
        renderSlot(_ctx.$slots, "action")
      ])) : createCommentVNode("", true),
      createElementVNode("div", _hoisted_5$9, [
        renderSlot(_ctx.$slots, "extra")
      ])
    ], 64))
  ], 2);
}
var ListItem = /* @__PURE__ */ _export_sfc(_sfc_main$14, [["render", _sfc_render$W]]);
const _sfc_main$13 = {
  name: "ListItemMeta",
  components: { Avatar },
  props: {
    avatar: {
      type: String,
      default: ""
    },
    title: {
      type: String,
      default: ""
    },
    description: {
      type: String,
      default: ""
    }
  }
};
const _hoisted_1$x = { class: "ivu-list-item-meta" };
const _hoisted_2$k = {
  key: 0,
  class: "ivu-list-item-meta-avatar"
};
const _hoisted_3$g = { class: "ivu-list-item-meta-content" };
const _hoisted_4$c = {
  key: 0,
  class: "ivu-list-item-meta-title"
};
const _hoisted_5$8 = {
  key: 1,
  class: "ivu-list-item-meta-description"
};
function _sfc_render$V(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Avatar = resolveComponent("Avatar");
  return openBlock(), createElementBlock("div", _hoisted_1$x, [
    $props.avatar || _ctx.$slots.avatar ? (openBlock(), createElementBlock("div", _hoisted_2$k, [
      renderSlot(_ctx.$slots, "avatar", {}, () => [
        createVNode(_component_Avatar, { src: $props.avatar }, null, 8, ["src"])
      ])
    ])) : createCommentVNode("", true),
    createElementVNode("div", _hoisted_3$g, [
      $props.title || _ctx.$slots.title ? (openBlock(), createElementBlock("div", _hoisted_4$c, [
        renderSlot(_ctx.$slots, "title", {}, () => [
          createTextVNode(toDisplayString($props.title), 1)
        ])
      ])) : createCommentVNode("", true),
      $props.description || _ctx.$slots.description ? (openBlock(), createElementBlock("div", _hoisted_5$8, [
        renderSlot(_ctx.$slots, "description", {}, () => [
          createTextVNode(toDisplayString($props.description), 1)
        ])
      ])) : createCommentVNode("", true)
    ])
  ]);
}
var ListItemMeta = /* @__PURE__ */ _export_sfc(_sfc_main$13, [["render", _sfc_render$V]]);
const prefixCls$y = "ivu-loading-bar";
const _sfc_main$12 = {
  name: "LoadingBar",
  props: {
    color: {
      type: String,
      default: "primary"
    },
    failedColor: {
      type: String,
      default: "error"
    },
    height: {
      type: Number,
      default: 2
    }
  },
  data() {
    return {
      percent: 0,
      status: "success",
      show: false
    };
  },
  computed: {
    classes() {
      return `${prefixCls$y}`;
    },
    innerClasses() {
      return [
        `${prefixCls$y}-inner`,
        {
          [`${prefixCls$y}-inner-color-primary`]: this.color === "primary" && this.status === "success",
          [`${prefixCls$y}-inner-failed-color-error`]: this.failedColor === "error" && this.status === "error"
        }
      ];
    },
    outerStyles() {
      return {
        height: `${this.height}px`
      };
    },
    styles() {
      let style2 = {
        width: `${this.percent}%`,
        height: `${this.height}px`
      };
      if (this.color !== "primary" && this.status === "success") {
        style2.backgroundColor = this.color;
      }
      if (this.failedColor !== "error" && this.status === "error") {
        style2.backgroundColor = this.failedColor;
      }
      return style2;
    }
  }
};
function _sfc_render$U(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createBlock(Transition, { name: "fade" }, {
    default: withCtx(() => [
      withDirectives(createElementVNode("div", {
        class: normalizeClass($options.classes),
        style: normalizeStyle($options.outerStyles)
      }, [
        createElementVNode("div", {
          class: normalizeClass($options.innerClasses),
          style: normalizeStyle($options.styles)
        }, null, 6)
      ], 6), [
        [vShow, $data.show]
      ])
    ]),
    _: 1
  });
}
var LoadingBar = /* @__PURE__ */ _export_sfc(_sfc_main$12, [["render", _sfc_render$U]]);
LoadingBar.newInstance = (properties) => {
  if (!isClient)
    return;
  const _props = properties || {};
  let _instance = null;
  const Instance = createApp({
    data() {
      return _props;
    },
    render() {
      return h(LoadingBar, Object.assign({
        ref: "loadingBar"
      }, _props));
    },
    created() {
      _instance = getCurrentInstance();
    }
  });
  const container = document.createElement("div");
  document.body.appendChild(container);
  Instance.mount(container);
  const loading_bar = _instance.refs.loadingBar;
  return {
    update(options) {
      if ("percent" in options) {
        loading_bar.percent = options.percent;
      }
      if (options.status) {
        loading_bar.status = options.status;
      }
      if ("show" in options) {
        loading_bar.show = options.show;
      }
    },
    component: loading_bar,
    destroy() {
      Instance.unmount();
      document.body.removeChild(container);
    }
  };
};
let loadingBarInstance;
let color = "primary";
let duration = 800;
let failedColor = "error";
let height = 2;
let timer;
function getLoadingBarInstance() {
  loadingBarInstance = loadingBarInstance || LoadingBar.newInstance({
    color,
    failedColor,
    height
  });
  return loadingBarInstance;
}
function update(options) {
  let instance = getLoadingBarInstance();
  instance.update(options);
}
function hide() {
  setTimeout(() => {
    update({
      show: false
    });
    setTimeout(() => {
      update({
        percent: 0
      });
    }, 200);
  }, duration);
}
function clearTimer() {
  if (timer) {
    clearInterval(timer);
    timer = null;
  }
}
var index$3 = {
  start() {
    if (timer)
      return;
    let percent = 0;
    update({
      percent,
      status: "success",
      show: true
    });
    timer = setInterval(() => {
      percent += Math.floor(Math.random() * 3 + 1);
      if (percent > 95) {
        clearTimer();
      }
      update({
        percent,
        status: "success",
        show: true
      });
    }, 200);
  },
  update(percent) {
    clearTimer();
    update({
      percent,
      status: "success",
      show: true
    });
  },
  finish() {
    clearTimer();
    update({
      percent: 100,
      status: "success",
      show: true
    });
    hide();
  },
  error() {
    clearTimer();
    update({
      percent: 100,
      status: "error",
      show: true
    });
    hide();
  },
  config(options) {
    if (options.color) {
      color = options.color;
    }
    if (options.duration) {
      duration = options.duration;
    }
    if (options.failedColor) {
      failedColor = options.failedColor;
    }
    if (options.height) {
      height = options.height;
    }
  },
  destroy() {
    clearTimer();
    let instance = getLoadingBarInstance();
    loadingBarInstance = null;
    instance.destroy();
  }
};
const _sfc_main$11 = {
  name: "Login",
  components: { Form },
  emits: ["on-submit"],
  provide() {
    return {
      LoginInstance: this
    };
  },
  props: {},
  data() {
    return {
      formValidate: {}
    };
  },
  methods: {
    handleSubmit() {
      this.$refs.form.validate((valid) => {
        this.$emit("on-submit", valid, JSON.parse(JSON.stringify(this.formValidate)));
      });
    },
    handleValidate(fields, cb) {
      let status = true;
      fields.forEach((field) => {
        this.$refs.form.validateField(field, (valid) => {
          if (valid)
            status = false;
        });
      });
      cb(status);
    }
  }
};
const _hoisted_1$w = { class: "ivu-login" };
function _sfc_render$T(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Form = resolveComponent("Form");
  return openBlock(), createElementBlock("div", _hoisted_1$w, [
    createVNode(_component_Form, {
      ref: "form",
      model: $data.formValidate,
      onSubmit: _cache[0] || (_cache[0] = withModifiers(() => {
      }, ["prevent"]))
    }, {
      default: withCtx(() => [
        renderSlot(_ctx.$slots, "default")
      ]),
      _: 3
    }, 8, ["model"])
  ]);
}
var Login = /* @__PURE__ */ _export_sfc(_sfc_main$11, [["render", _sfc_render$T]]);
const prefixCls$x = "ivu-menu";
const _sfc_main$10 = {
  name: "Menu",
  emits: ["on-select", "on-open-change"],
  provide() {
    return {
      MenuInstance: this
    };
  },
  props: {
    mode: {
      validator(value) {
        return oneOf(value, ["horizontal", "vertical"]);
      },
      default: "vertical"
    },
    theme: {
      validator(value) {
        return oneOf(value, ["light", "dark", "primary"]);
      },
      default: "light"
    },
    activeName: {
      type: [String, Number]
    },
    openNames: {
      type: Array,
      default() {
        return [];
      }
    },
    accordion: {
      type: Boolean,
      default: false
    },
    width: {
      type: String,
      default: "240px"
    }
  },
  data() {
    return {
      currentActiveName: this.activeName,
      openedNames: [],
      submenuList: [],
      menuItemList: [],
      ready: false
    };
  },
  computed: {
    classes() {
      let theme = this.theme;
      if (this.mode === "vertical" && this.theme === "primary")
        theme = "light";
      return [
        `${prefixCls$x}`,
        `${prefixCls$x}-${theme}`,
        {
          [`${prefixCls$x}-${this.mode}`]: this.mode
        }
      ];
    },
    styles() {
      let style2 = {};
      if (this.mode === "vertical")
        style2.width = this.width;
      return style2;
    }
  },
  methods: {
    updateActiveName() {
      if (this.currentActiveName === void 0) {
        this.currentActiveName = -1;
      }
      this.submenuList.map((item) => item.submenu).forEach((item) => {
        item.handleUpdateActiveName(false);
      });
      this.menuItemList.map((item) => item.menuitem).forEach((item) => {
        item.handleUpdateActiveName(this.currentActiveName);
      });
    },
    updateOpenKeys(name2) {
      let names2 = [...this.openedNames];
      const index2 = names2.indexOf(name2);
      const submenuList = this.submenuList.map((item) => item.submenu);
      if (this.accordion)
        submenuList.forEach((item) => {
          item.opened = false;
        });
      if (index2 >= 0) {
        let currentSubmenu = null;
        submenuList.forEach((item) => {
          if (item.name === name2) {
            currentSubmenu = item;
            item.opened = false;
          }
        });
        findComponentsUpward(currentSubmenu, "Submenu").forEach((item) => {
          item.opened = true;
        });
        currentSubmenu.childSubmenuList.map((item) => item.submenu).forEach((item) => {
          item.opened = false;
        });
      } else {
        if (this.accordion) {
          let currentSubmenu = null;
          submenuList.forEach((item) => {
            if (item.name === name2) {
              currentSubmenu = item;
              item.opened = true;
            }
          });
          findComponentsUpward(currentSubmenu, "Submenu").forEach((item) => {
            item.opened = true;
          });
        } else {
          const submenuList2 = this.submenuList.map((item) => item.submenu);
          submenuList2.forEach((item) => {
            if (item.name === name2)
              item.opened = true;
          });
        }
      }
      let openedNames = submenuList.filter((item) => item.opened).map((item) => item.name);
      this.openedNames = [...openedNames];
      this.$emit("on-open-change", openedNames);
    },
    updateOpened() {
      const items = (this.submenuList || []).map((item) => item.submenu);
      if (items.length) {
        items.forEach((item) => {
          if (this.openedNames.indexOf(item.name) > -1)
            item.opened = true;
          else
            item.opened = false;
        });
      }
    },
    handleEmitSelectEvent(name2) {
      this.$emit("on-select", name2);
    },
    handleMenuItemSelect(name2) {
      this.currentActiveName = name2;
      this.$emit("on-select", name2);
    }
  },
  mounted() {
    this.openedNames = [...this.openNames];
    this.updateOpened();
    nextTick(() => {
      this.updateActiveName();
      this.ready = true;
    });
  },
  watch: {
    openNames(names2) {
      this.openedNames = names2;
    },
    activeName(val) {
      this.currentActiveName = val;
    },
    currentActiveName() {
      this.updateActiveName();
    }
  }
};
function _sfc_render$S(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("ul", {
    class: normalizeClass($options.classes),
    style: normalizeStyle($options.styles)
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 6);
}
var Menu = /* @__PURE__ */ _export_sfc(_sfc_main$10, [["render", _sfc_render$S]]);
var mixin = {
  inject: {
    MenuInstance: {
      default: null
    },
    SubmenuInstance: {
      default: null
    }
  },
  data() {
    return {
      menu: this.MenuInstance
    };
  },
  computed: {
    hasParentSubmenu() {
      return !!this.SubmenuInstance;
    },
    parentSubmenuNum() {
      return findComponentsUpward(this, "Submenu").length;
    },
    mode() {
      return this.MenuInstance.mode;
    }
  }
};
const prefixCls$w = "ivu-menu";
const _sfc_main$$ = {
  name: "MenuGroup",
  mixins: [mixin],
  props: {
    title: {
      type: String,
      default: ""
    }
  },
  data() {
    return {
      prefixCls: prefixCls$w
    };
  },
  computed: {
    groupStyle() {
      return this.hasParentSubmenu && this.mode !== "horizontal" ? {
        paddingLeft: 43 + (this.parentSubmenuNum - 1) * 28 + "px"
      } : {};
    }
  }
};
function _sfc_render$R(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("li", {
    class: normalizeClass([$data.prefixCls + "-item-group"])
  }, [
    createElementVNode("div", {
      class: normalizeClass([$data.prefixCls + "-item-group-title"]),
      style: normalizeStyle($options.groupStyle)
    }, toDisplayString($props.title), 7),
    createElementVNode("ul", null, [
      renderSlot(_ctx.$slots, "default")
    ])
  ], 2);
}
var MenuGroup = /* @__PURE__ */ _export_sfc(_sfc_main$$, [["render", _sfc_render$R]]);
const prefixCls$v = "ivu-menu";
const _sfc_main$_ = {
  name: "MenuItem",
  mixins: [mixin, mixinsLink],
  props: {
    name: {
      type: [String, Number],
      required: true
    },
    disabled: {
      type: Boolean,
      default: false
    }
  },
  data() {
    return {
      active: false,
      id: random(6)
    };
  },
  computed: {
    classes() {
      return [
        `${prefixCls$v}-item`,
        {
          [`${prefixCls$v}-item-active`]: this.active,
          [`${prefixCls$v}-item-selected`]: this.active,
          [`${prefixCls$v}-item-disabled`]: this.disabled
        }
      ];
    },
    itemStyle() {
      return this.hasParentSubmenu && this.mode !== "horizontal" ? {
        paddingLeft: 43 + (this.parentSubmenuNum - 1) * 24 + "px"
      } : {};
    }
  },
  methods: {
    handleClickItem(event, new_window = false) {
      if (this.disabled)
        return;
      if (new_window || this.target === "_blank") {
        this.handleCheckClick(event, new_window);
        let parentMenu = findComponentUpward(this, "Menu");
        if (parentMenu)
          parentMenu.handleEmitSelectEvent(this.name);
      } else {
        let parent = findComponentUpward(this, "Submenu");
        if (parent) {
          this.SubmenuInstance.handleMenuItemSelect(this.name);
        } else {
          this.MenuInstance.handleMenuItemSelect(this.name);
        }
        this.handleCheckClick(event, new_window);
      }
    },
    handleUpdateActiveName(name2) {
      if (this.name === name2) {
        this.active = true;
        if (this.SubmenuInstance)
          this.SubmenuInstance.handleUpdateActiveName(name2);
      } else {
        this.active = false;
      }
    },
    addMenuItem() {
      const root2 = this.MenuInstance;
      if (!root2.menuItemList)
        root2.menuItemList = [];
      root2.menuItemList.push({
        id: this.id,
        menuitem: this
      });
    },
    removeMenuItem() {
      const root2 = this.MenuInstance;
      if (root2.menuItemList && root2.menuItemList.length) {
        const index2 = root2.menuItemList.findIndex((item) => item.id === this.id);
        root2.menuItemList.splice(index2, 1);
      }
    }
  },
  mounted() {
    this.addMenuItem();
  },
  beforeUnmount() {
    this.removeMenuItem();
  }
};
const _hoisted_1$v = ["href", "target"];
function _sfc_render$Q(_ctx, _cache, $props, $setup, $data, $options) {
  return _ctx.to ? (openBlock(), createElementBlock("a", {
    key: 0,
    href: _ctx.linkUrl,
    target: _ctx.target,
    class: normalizeClass($options.classes),
    onClick: [
      _cache[0] || (_cache[0] = withModifiers(($event) => $options.handleClickItem($event, false), ["exact"])),
      _cache[1] || (_cache[1] = withModifiers(($event) => $options.handleClickItem($event, true), ["ctrl"])),
      _cache[2] || (_cache[2] = withModifiers(($event) => $options.handleClickItem($event, true), ["meta"]))
    ],
    style: normalizeStyle($options.itemStyle)
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 14, _hoisted_1$v)) : (openBlock(), createElementBlock("li", {
    key: 1,
    class: normalizeClass($options.classes),
    onClick: _cache[3] || (_cache[3] = withModifiers((...args) => $options.handleClickItem && $options.handleClickItem(...args), ["stop"])),
    style: normalizeStyle($options.itemStyle)
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 6));
}
var MenuItem = /* @__PURE__ */ _export_sfc(_sfc_main$_, [["render", _sfc_render$Q]]);
const _sfc_main$Z = {
  name: "Mobile",
  mixins: [LoginItem],
  data() {
    return {
      className: "ivu-login-mobile",
      prefix: "ios-phone-portrait",
      placeholder: "\u8BF7\u8F93\u5165\u624B\u673A\u53F7\u7801",
      type: "text"
    };
  },
  props: {
    rules: {
      type: [Object, Array],
      default() {
        return [
          {
            required: true,
            message: defaultValidateMessage["Mobile"],
            trigger: "change"
          },
          {
            pattern: /^1\d{10}$/,
            message: "\u8F93\u5165\u7684\u624B\u673A\u53F7\u7801\u683C\u5F0F\u4E0D\u6B63\u786E\uFF01",
            trigger: "change"
          }
        ];
      }
    }
  }
};
const prefixCls$u = "ivu-modal";
const dragData = {
  x: null,
  y: null,
  dragX: null,
  dragY: null,
  dragging: false,
  rect: null
};
const _sfc_main$Y = {
  inheritAttrs: false,
  name: "Modal",
  mixins: [Locale, ScrollbarMixins],
  components: { Icon, iButton: _sfc_main$2c },
  emits: ["on-cancel", "on-ok", "on-hidden", "on-visible-change", "update:modelValue"],
  provide() {
    return {
      ModalInstance: this
    };
  },
  props: {
    modelValue: {
      type: Boolean,
      default: false
    },
    closable: {
      type: Boolean,
      default: true
    },
    maskClosable: {
      type: Boolean,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.modal.maskClosable === "" ? true : global2.$VIEWUI.modal.maskClosable;
      }
    },
    title: {
      type: String
    },
    width: {
      type: [Number, String],
      default: 520
    },
    okText: {
      type: String
    },
    cancelText: {
      type: String
    },
    loading: {
      type: Boolean,
      default: false
    },
    styles: {
      type: Object,
      default() {
        return {};
      }
    },
    className: {
      type: String
    },
    footerHide: {
      type: Boolean,
      default: false
    },
    scrollable: {
      type: Boolean,
      default: false
    },
    transitionNames: {
      type: Array,
      default() {
        return ["ease", "fade"];
      }
    },
    transfer: {
      type: Boolean,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.transfer === "" ? true : global2.$VIEWUI.transfer;
      }
    },
    fullscreen: {
      type: Boolean,
      default: false
    },
    mask: {
      type: Boolean,
      default: true
    },
    draggable: {
      type: Boolean,
      default: false
    },
    sticky: {
      type: Boolean,
      default: false
    },
    stickyDistance: {
      type: Number,
      default: 10
    },
    resetDragPosition: {
      type: Boolean,
      default: false
    },
    zIndex: {
      type: Number,
      default: 1e3
    },
    beforeClose: Function,
    render: Function
  },
  data() {
    return {
      prefixCls: prefixCls$u,
      wrapShow: false,
      showHead: true,
      buttonLoading: false,
      visible: this.modelValue,
      dragData: deepCopy(dragData),
      modalIndex: this.handleGetModalIndex(),
      isMouseTriggerIn: false,
      id: random(6),
      tableList: [],
      sliderList: []
    };
  },
  computed: {
    wrapClasses() {
      return [
        `${prefixCls$u}-wrap`,
        {
          [`${prefixCls$u}-hidden`]: !this.wrapShow,
          [`${this.className}`]: !!this.className,
          [`${prefixCls$u}-no-mask`]: !this.showMask
        }
      ];
    },
    wrapStyles() {
      return {
        zIndex: this.modalIndex + this.zIndex
      };
    },
    maskClasses() {
      return `${prefixCls$u}-mask`;
    },
    classes() {
      return [
        `${prefixCls$u}`,
        {
          [`${prefixCls$u}-fullscreen`]: this.fullscreen,
          [`${prefixCls$u}-fullscreen-no-header`]: this.fullscreen && !this.showHead,
          [`${prefixCls$u}-fullscreen-no-footer`]: this.fullscreen && this.footerHide
        }
      ];
    },
    contentClasses() {
      return [
        `${prefixCls$u}-content`,
        {
          [`${prefixCls$u}-content-no-mask`]: !this.showMask,
          [`${prefixCls$u}-content-drag`]: this.draggable && !this.fullscreen,
          [`${prefixCls$u}-content-dragging`]: this.draggable && this.dragData.dragging
        }
      ];
    },
    mainStyles() {
      let style2 = {};
      const width = parseInt(this.width);
      const styleWidth = this.dragData.x !== null ? {
        top: 0
      } : {
        width: width <= 100 ? `${width}%` : `${width}px`
      };
      const customStyle = this.styles ? this.styles : {};
      Object.assign(style2, styleWidth, customStyle);
      return style2;
    },
    contentStyles() {
      let style2 = {};
      if (this.draggable && !this.fullscreen) {
        const customTop = this.styles.top ? parseFloat(this.styles.top) : 0;
        const customLeft = this.styles.left ? parseFloat(this.styles.left) : 0;
        if (this.dragData.x !== null)
          style2.left = `${this.dragData.x - customLeft}px`;
        if (this.dragData.y !== null)
          style2.top = `${this.dragData.y}px`;
        if (this.dragData.y !== null)
          style2.top = `${this.dragData.y - customTop}px`;
        const width = parseInt(this.width);
        const styleWidth = {
          width: width <= 100 ? `${width}%` : `${width}px`
        };
        Object.assign(style2, styleWidth);
      }
      return style2;
    },
    localeOkText() {
      if (this.okText === void 0) {
        return this.t("i.modal.okText");
      } else {
        return this.okText;
      }
    },
    localeCancelText() {
      if (this.cancelText === void 0) {
        return this.t("i.modal.cancelText");
      } else {
        return this.cancelText;
      }
    },
    showMask() {
      return this.mask;
    }
  },
  methods: {
    close() {
      if (!this.beforeClose) {
        return this.handleClose();
      }
      const before = this.beforeClose();
      if (before && before.then) {
        before.then(() => {
          this.handleClose();
        });
      } else {
        this.handleClose();
      }
    },
    handleClose() {
      this.visible = false;
      this.$emit("update:modelValue", false);
      this.$emit("on-cancel");
    },
    handleMask() {
      if (this.maskClosable && this.showMask) {
        this.close();
      }
    },
    handleWrapClick(event) {
      if (this.isMouseTriggerIn) {
        this.isMouseTriggerIn = false;
        return;
      }
      const className = event.target.getAttribute("class");
      if (className && className.indexOf(`${prefixCls$u}-wrap`) > -1)
        this.handleMask();
    },
    handleMousedown() {
      this.isMouseTriggerIn = true;
    },
    cancel() {
      this.close();
    },
    ok() {
      if (this.loading) {
        this.buttonLoading = true;
      } else {
        this.visible = false;
        this.$emit("update:modelValue", false);
      }
      this.$emit("on-ok");
    },
    EscClose(e) {
      if (this.visible && this.closable) {
        if (e.keyCode === 27) {
          const $Modals = this.$root.modalList.map((item) => item.modal).filter((item) => item.$data.visible && item.$props.closable);
          const $TopModal = $Modals.sort((a, b) => {
            return a.$data.modalIndex < b.$data.modalIndex ? 1 : -1;
          })[0];
          setTimeout(() => {
            $TopModal.close();
          }, 0);
        }
      }
    },
    animationFinish() {
      this.$emit("on-hidden");
    },
    handleMoveStart(event) {
      if (!this.draggable || this.fullscreen)
        return false;
      const $content = this.$refs.content;
      const rect = $content.getBoundingClientRect();
      this.dragData.rect = rect;
      this.dragData.x = rect.x || rect.left;
      this.dragData.y = rect.y || rect.top;
      const distance = {
        x: event.clientX,
        y: event.clientY
      };
      this.dragData.dragX = distance.x;
      this.dragData.dragY = distance.y;
      this.dragData.dragging = true;
      on(window, "mousemove", this.handleMoveMove);
      on(window, "mouseup", this.handleMoveEnd);
    },
    handleMoveMove(event) {
      if (!this.dragData.dragging || this.fullscreen)
        return false;
      const distance = {
        x: event.clientX,
        y: event.clientY
      };
      const diff_distance = {
        x: distance.x - this.dragData.dragX,
        y: distance.y - this.dragData.dragY
      };
      if (isClient && this.sticky) {
        const clientWidth = document.documentElement.clientWidth;
        const clientHeight = document.documentElement.clientHeight;
        if (this.dragData.x + diff_distance.x <= this.stickyDistance && diff_distance.x < 0) {
          this.dragData.x = 0;
        } else if (this.dragData.x + this.dragData.rect.width - clientWidth > -this.stickyDistance && diff_distance.x > 0) {
          this.dragData.x = clientWidth - this.dragData.rect.width;
        } else {
          this.dragData.x += diff_distance.x;
        }
        if (this.dragData.y + diff_distance.y <= this.stickyDistance && diff_distance.y < 0) {
          this.dragData.y = 0;
        } else if (this.dragData.y + this.dragData.rect.height - clientHeight > -this.stickyDistance && diff_distance.y > 0) {
          this.dragData.y = clientHeight - this.dragData.rect.height;
        } else {
          this.dragData.y += diff_distance.y;
        }
      } else {
        this.dragData.x += diff_distance.x;
        this.dragData.y += diff_distance.y;
      }
      this.dragData.dragX = distance.x;
      this.dragData.dragY = distance.y;
    },
    handleMoveEnd() {
      this.dragData.dragging = false;
      off(window, "mousemove", this.handleMoveMove);
      off(window, "mouseup", this.handleMoveEnd);
    },
    handleGetModalIndex() {
      transferIncrease();
      return transferIndex;
    },
    handleClickModal() {
      if (this.draggable) {
        if (lastVisibleIndex !== this.lastVisibleIndex) {
          this.lastVisibleIndex = lastVisibleIndex;
          return;
        }
        this.modalIndex = this.handleGetModalIndex();
      }
    },
    addModal() {
      const root2 = this.$root;
      if (!root2.modalList)
        root2.modalList = [];
      root2.modalList.push({
        id: this.id,
        modal: this
      });
    },
    removeModal() {
      const root2 = this.$root;
      if (!root2.modalList)
        return;
      const index2 = root2.modalList.findIndex((item) => item.id === this.id);
      root2.modalList.splice(index2, 1);
    }
  },
  watch: {
    modelValue(val) {
      this.visible = val;
    },
    visible(val) {
      if (val === false) {
        this.buttonLoading = false;
        this.timer = setTimeout(() => {
          this.wrapShow = false;
          this.removeScrollEffect();
        }, 300);
      } else {
        if (this.lastVisible !== val) {
          this.modalIndex = this.handleGetModalIndex();
          lastVisibleIncrease();
        }
        if (this.timer)
          clearTimeout(this.timer);
        this.wrapShow = true;
        if (!this.scrollable) {
          this.addScrollEffect();
        }
      }
      this.tableList.forEach((item) => {
        item.table.handleOnVisibleChange(val);
      });
      this.sliderList.forEach((item) => {
        item.slider.handleOnVisibleChange(val);
      });
      this.$emit("on-visible-change", val);
      this.lastVisible = val;
      this.lastVisibleIndex = lastVisibleIndex;
      if (val && this.resetDragPosition) {
        this.dragData = deepCopy(dragData);
      }
    },
    loading(val) {
      if (!val) {
        this.buttonLoading = false;
      }
    },
    scrollable(val) {
      if (!val) {
        this.addScrollEffect();
      } else {
        this.removeScrollEffect();
      }
    },
    title(val) {
      if (this.$slots.header === void 0) {
        this.showHead = !!val;
      }
    }
  },
  mounted() {
    if (this.visible) {
      this.wrapShow = true;
    }
    let showHead = true;
    if (this.$slots.header === void 0 && !this.title) {
      showHead = false;
    }
    this.showHead = showHead;
    this.addModal();
    isClient && document.addEventListener("keydown", this.EscClose);
  },
  beforeUnmount() {
    this.removeModal();
    isClient && document.removeEventListener("keydown", this.EscClose);
    this.removeScrollEffect();
  }
};
function _sfc_render$P(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = resolveComponent("Icon");
  const _component_i_button = resolveComponent("i-button");
  return openBlock(), createBlock(Teleport, {
    to: "body",
    disabled: !$props.transfer
  }, [
    createVNode(Transition, {
      name: $props.transitionNames[1]
    }, {
      default: withCtx(() => [
        $options.showMask ? withDirectives((openBlock(), createElementBlock("div", {
          key: 0,
          class: normalizeClass($options.maskClasses),
          style: normalizeStyle($options.wrapStyles),
          onClick: _cache[0] || (_cache[0] = (...args) => $options.handleMask && $options.handleMask(...args))
        }, null, 6)), [
          [vShow, $data.visible]
        ]) : createCommentVNode("", true)
      ]),
      _: 1
    }, 8, ["name"]),
    createElementVNode("div", {
      class: normalizeClass($options.wrapClasses),
      style: normalizeStyle($options.wrapStyles),
      onClick: _cache[5] || (_cache[5] = (...args) => $options.handleWrapClick && $options.handleWrapClick(...args))
    }, [
      createVNode(Transition, {
        name: $props.transitionNames[0],
        onAfterLeave: $options.animationFinish
      }, {
        default: withCtx(() => [
          withDirectives(createElementVNode("div", mergeProps(_ctx.$attrs, {
            class: $options.classes,
            style: $options.mainStyles,
            onMousedown: _cache[4] || (_cache[4] = (...args) => $options.handleMousedown && $options.handleMousedown(...args))
          }), [
            createElementVNode("div", {
              class: normalizeClass($options.contentClasses),
              ref: "content",
              style: normalizeStyle($options.contentStyles),
              onClick: _cache[3] || (_cache[3] = (...args) => $options.handleClickModal && $options.handleClickModal(...args))
            }, [
              $props.closable ? (openBlock(), createElementBlock("a", {
                key: 0,
                class: normalizeClass([$data.prefixCls + "-close"]),
                onClick: _cache[1] || (_cache[1] = (...args) => $options.close && $options.close(...args))
              }, [
                renderSlot(_ctx.$slots, "close", {}, () => [
                  createVNode(_component_Icon, { type: "ios-close" })
                ])
              ], 2)) : createCommentVNode("", true),
              $data.showHead ? (openBlock(), createElementBlock("div", {
                key: 1,
                class: normalizeClass([$data.prefixCls + "-header"]),
                onMousedown: _cache[2] || (_cache[2] = (...args) => $options.handleMoveStart && $options.handleMoveStart(...args))
              }, [
                renderSlot(_ctx.$slots, "header", {}, () => [
                  createElementVNode("div", {
                    class: normalizeClass([$data.prefixCls + "-header-inner"])
                  }, toDisplayString($props.title), 3)
                ])
              ], 34)) : createCommentVNode("", true),
              createElementVNode("div", {
                class: normalizeClass([$data.prefixCls + "-body"])
              }, [
                renderSlot(_ctx.$slots, "default")
              ], 2),
              !$props.footerHide ? (openBlock(), createElementBlock("div", {
                key: 2,
                class: normalizeClass([$data.prefixCls + "-footer"])
              }, [
                renderSlot(_ctx.$slots, "footer", {}, () => [
                  createVNode(_component_i_button, {
                    type: "text",
                    onClick: $options.cancel
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString($options.localeCancelText), 1)
                    ]),
                    _: 1
                  }, 8, ["onClick"]),
                  createVNode(_component_i_button, {
                    type: "primary",
                    loading: $data.buttonLoading,
                    onClick: $options.ok
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString($options.localeOkText), 1)
                    ]),
                    _: 1
                  }, 8, ["loading", "onClick"])
                ])
              ], 2)) : createCommentVNode("", true)
            ], 6)
          ], 16), [
            [vShow, $data.visible]
          ])
        ]),
        _: 3
      }, 8, ["name", "onAfterLeave"])
    ], 6)
  ], 8, ["disabled"]);
}
var Modal = /* @__PURE__ */ _export_sfc(_sfc_main$Y, [["render", _sfc_render$P]]);
const prefixCls$t = "ivu-modal-confirm";
Modal.newInstance = (properties) => {
  if (!isClient)
    return;
  const _props = properties || {};
  const container = document.createElement("div");
  document.body.appendChild(container);
  let _instance = null;
  const Instance = createApp({
    mixins: [Locale],
    data() {
      return Object.assign({}, _props, {
        visible: false,
        width: 416,
        title: "",
        body: "",
        iconType: "",
        iconName: "",
        okText: void 0,
        cancelText: void 0,
        showCancel: false,
        loading: false,
        buttonLoading: false,
        scrollable: false,
        closable: false,
        closing: false
      });
    },
    render() {
      let footerVNodes = [];
      if (this.showCancel) {
        footerVNodes.push(h(_sfc_main$2c, {
          type: "text",
          onClick: this.cancel
        }, () => this.localeCancelText));
      }
      footerVNodes.push(h(_sfc_main$2c, {
        type: "primary",
        loading: this.buttonLoading,
        onClick: this.ok
      }, () => this.localeOkText));
      let body_render;
      if (this.render) {
        body_render = h("div", {
          class: `${prefixCls$t}-body ${prefixCls$t}-body-render`
        }, [this.render(h)]);
      } else {
        body_render = h("div", {
          class: `${prefixCls$t}-body`
        }, [
          h("div", {
            innerHTML: this.body
          })
        ]);
      }
      let head_render;
      if (this.title) {
        head_render = h("div", {
          class: `${prefixCls$t}-head`
        }, [
          h("div", {
            class: this.iconTypeCls
          }, [
            h("i", {
              class: this.iconNameCls
            })
          ]),
          h("div", {
            class: `${prefixCls$t}-head-title`,
            innerHTML: this.title
          })
        ]);
      }
      return h(
        Modal,
        Object.assign({}, _props, {
          width: this.width,
          scrollable: this.scrollable,
          closable: this.closable,
          ref: "modal"
        }, {
          modelValue: this.visible,
          "onUpdate:modelValue": (status) => this.visible = status,
          "onOn-cancel": this.cancel
        }),
        () => h("div", {
          class: prefixCls$t
        }, [
          head_render,
          body_render,
          h("div", {
            class: `${prefixCls$t}-footer`
          }, footerVNodes)
        ])
      );
    },
    computed: {
      iconTypeCls() {
        return [
          `${prefixCls$t}-head-icon`,
          `${prefixCls$t}-head-icon-${this.iconType}`
        ];
      },
      iconNameCls() {
        return [
          "ivu-icon",
          `ivu-icon-${this.iconName}`
        ];
      },
      localeOkText() {
        if (this.okText) {
          return this.okText;
        } else {
          return this.t("i.modal.okText");
        }
      },
      localeCancelText() {
        if (this.cancelText) {
          return this.cancelText;
        } else {
          return this.t("i.modal.cancelText");
        }
      }
    },
    methods: {
      cancel() {
        if (this.closing)
          return;
        this.$refs.modal.visible = false;
        this.buttonLoading = false;
        this.onCancel();
        this.remove();
      },
      ok() {
        if (this.closing)
          return;
        if (this.loading) {
          this.buttonLoading = true;
        } else {
          this.$refs.modal.visible = false;
          this.remove();
        }
        this.onOk();
      },
      remove() {
        this.closing = true;
        setTimeout(() => {
          this.closing = false;
          this.destroy();
        }, 300);
      },
      destroy() {
        Instance.unmount();
        document.body.removeChild(container);
        this.onRemove();
      },
      onOk() {
      },
      onCancel() {
      },
      onRemove() {
      }
    },
    created() {
      _instance = getCurrentInstance();
    }
  });
  Instance.mount(container);
  const modal = _instance.refs.modal;
  return {
    show(props) {
      nextTick(() => {
        const modal2 = _instance.refs.modal;
        modal2.$parent.showCancel = props.showCancel;
        modal2.$parent.iconType = props.icon;
        switch (props.icon) {
          case "info":
            modal2.$parent.iconName = "ios-information-circle";
            break;
          case "success":
            modal2.$parent.iconName = "ios-checkmark-circle";
            break;
          case "warning":
            modal2.$parent.iconName = "ios-alert";
            break;
          case "error":
            modal2.$parent.iconName = "ios-close-circle";
            break;
          case "confirm":
            modal2.$parent.iconName = "ios-help-circle";
            break;
        }
        if ("width" in props) {
          modal2.$parent.width = props.width;
        }
        if ("closable" in props) {
          modal2.$parent.closable = props.closable;
        }
        if ("title" in props) {
          modal2.$parent.title = props.title;
        }
        if ("content" in props) {
          modal2.$parent.body = props.content;
        }
        if ("okText" in props) {
          modal2.$parent.okText = props.okText;
        }
        if ("cancelText" in props) {
          modal2.$parent.cancelText = props.cancelText;
        }
        if ("onCancel" in props) {
          modal2.$parent.onCancel = props.onCancel;
        }
        if ("onOk" in props) {
          modal2.$parent.onOk = props.onOk;
        }
        if ("loading" in props) {
          modal2.$parent.loading = props.loading;
        }
        if ("scrollable" in props) {
          modal2.$parent.scrollable = props.scrollable;
        }
        modal2.$parent.onRemove = props.onRemove;
        modal2.visible = true;
      });
    },
    remove() {
      modal.visible = false;
      modal.$parent.buttonLoading = false;
      modal.$parent.remove();
    },
    component: modal
  };
};
let modalInstance;
function getModalInstance(render = void 0, lockScroll = true) {
  modalInstance = modalInstance || Modal.newInstance({
    closable: false,
    maskClosable: false,
    footerHide: true,
    render,
    lockScroll
  });
  return modalInstance;
}
function confirm(options) {
  const render = "render" in options ? options.render : void 0;
  const lockScroll = "lockScroll" in options ? options.lockScroll : true;
  let instance = getModalInstance(render, lockScroll);
  options.onRemove = function() {
    modalInstance = null;
  };
  instance.show(options);
}
Modal.info = function(props = {}) {
  props.icon = "info";
  props.showCancel = false;
  return confirm(props);
};
Modal.success = function(props = {}) {
  props.icon = "success";
  props.showCancel = false;
  return confirm(props);
};
Modal.warning = function(props = {}) {
  props.icon = "warning";
  props.showCancel = false;
  return confirm(props);
};
Modal.error = function(props = {}) {
  props.icon = "error";
  props.showCancel = false;
  return confirm(props);
};
Modal.confirm = function(props = {}) {
  props.icon = "confirm";
  props.showCancel = true;
  return confirm(props);
};
Modal.remove = function() {
  if (!modalInstance) {
    return false;
  }
  const instance = getModalInstance();
  instance.remove();
};
const prefixCls$s = "ivu-notice";
const iconPrefixCls$1 = "ivu-icon";
const prefixKey = "ivu_notice_key_";
let top = 24;
let defaultDuration = 4.5;
let noticeInstance;
let name$1 = 1;
const iconTypes = {
  "info": "ios-information-circle",
  "success": "ios-checkmark-circle",
  "warning": "ios-alert",
  "error": "ios-close-circle"
};
const transitionName = "move-notice";
function getNoticeInstance() {
  noticeInstance = noticeInstance || Notification$1.newInstance({
    prefixCls: prefixCls$s,
    styles: {
      top: `${top}px`,
      right: 0
    },
    transitionName
  });
  return noticeInstance;
}
function notice(type2, options) {
  const title2 = options.title || "";
  const desc = options.desc || "";
  const noticeKey = options.name || `${prefixKey}${name$1}`;
  const onClose = options.onClose || function() {
  };
  const render = options.render;
  const duration2 = options.duration === 0 ? 0 : options.duration || defaultDuration;
  name$1++;
  let instance = getNoticeInstance();
  let content;
  let withIcon;
  const with_desc = options.render && !title2 ? "" : desc || options.render ? ` ${prefixCls$s}-with-desc` : "";
  if (type2 === "normal") {
    withIcon = false;
    content = `
            <div class="${prefixCls$s}-custom-content ${prefixCls$s}-with-normal ${with_desc}">
                <div class="${prefixCls$s}-title">${title2}</div>
                <div class="${prefixCls$s}-desc">${desc}</div>
            </div>
        `;
  } else {
    const iconType = iconTypes[type2];
    const outlineIcon = with_desc === "" ? "" : "-outline";
    withIcon = true;
    content = `
            <div class="${prefixCls$s}-custom-content ${prefixCls$s}-with-icon ${prefixCls$s}-with-${type2} ${with_desc}">
                <span class="${prefixCls$s}-icon ${prefixCls$s}-icon-${type2}">
                    <i class="${iconPrefixCls$1} ${iconPrefixCls$1}-${iconType}${outlineIcon}"></i>
                </span>
                <div class="${prefixCls$s}-title">${title2}</div>
                <div class="${prefixCls$s}-desc">${desc}</div>
            </div>
        `;
  }
  instance.notice({
    name: noticeKey.toString(),
    duration: duration2,
    styles: {},
    transitionName,
    content,
    withIcon,
    render,
    hasTitle: !!title2,
    onClose,
    closable: true,
    type: "notice"
  });
}
var index$2 = {
  open(options) {
    return notice("normal", options);
  },
  info(options) {
    return notice("info", options);
  },
  success(options) {
    return notice("success", options);
  },
  warning(options) {
    return notice("warning", options);
  },
  error(options) {
    return notice("error", options);
  },
  config(options) {
    if (options.top) {
      top = options.top;
    }
    if (options.duration || options.duration === 0) {
      defaultDuration = options.duration;
    }
  },
  close(name2) {
    if (name2) {
      name2 = name2.toString();
      if (noticeInstance) {
        noticeInstance.remove(name2);
      }
    } else {
      return false;
    }
  },
  destroy() {
    let instance = getNoticeInstance();
    noticeInstance = null;
    instance.destroy("ivu-notice");
  }
};
const prefixCls$r = "ivu-tabs";
const transitionTime = 300;
const getNextTab = (list, activeKey, direction, countDisabledAlso) => {
  const currentIndex = list.findIndex((tab) => tab.name === activeKey);
  const nextIndex = (currentIndex + direction + list.length) % list.length;
  const nextTab = list[nextIndex];
  if (nextTab.disabled)
    return getNextTab(list, nextTab.name, direction);
  else
    return nextTab;
};
const focusFirst = (element, root2) => {
  try {
    element.focus();
  } catch (err) {
  }
  if (isClient && document.activeElement == element && element !== root2)
    return true;
  const candidates = element.children;
  for (let candidate of candidates) {
    if (focusFirst(candidate, root2))
      return true;
  }
  return false;
};
const _sfc_main$X = {
  name: "Tabs",
  mixins: [globalConfig],
  emits: ["on-click", "on-dblclick", "on-contextmenu", "on-tab-remove", "on-drag-drop", "update:modelValue"],
  components: { Icon, Render: Render$1, Dropdown, DropdownMenu },
  provide() {
    return {
      TabsInstance: this
    };
  },
  props: {
    modelValue: {
      type: [String, Number]
    },
    type: {
      validator(value) {
        return oneOf(value, ["line", "card"]);
      },
      default: "line"
    },
    size: {
      validator(value) {
        return oneOf(value, ["small", "default"]);
      },
      default: "default"
    },
    animated: {
      type: Boolean,
      default: true
    },
    captureFocus: {
      type: Boolean,
      default: false
    },
    closable: {
      type: Boolean,
      default: false
    },
    beforeRemove: Function,
    name: {
      type: String
    },
    draggable: {
      type: Boolean,
      default: false
    },
    autoCloseContextmenu: {
      type: Boolean,
      default: true
    }
  },
  data() {
    return {
      prefixCls: prefixCls$r,
      navList: [],
      barWidth: 0,
      barOffset: 0,
      activeKey: this.modelValue,
      focusedKey: this.modelValue,
      showSlot: false,
      navStyle: {
        transform: ""
      },
      scrollable: false,
      transitioning: false,
      contextMenuVisible: false,
      contextMenuStyles: {
        top: 0,
        left: 0
      },
      paneList: [],
      tableList: []
    };
  },
  computed: {
    classes() {
      return [
        `${prefixCls$r}`,
        {
          [`${prefixCls$r}-card`]: this.type === "card",
          [`${prefixCls$r}-mini`]: this.size === "small" && this.type === "line",
          [`${prefixCls$r}-no-animation`]: !this.animated
        }
      ];
    },
    contentClasses() {
      return [
        `${prefixCls$r}-content`,
        {
          [`${prefixCls$r}-content-animated`]: this.animated
        }
      ];
    },
    barClasses() {
      return [
        `${prefixCls$r}-ink-bar`,
        {
          [`${prefixCls$r}-ink-bar-animated`]: this.animated
        }
      ];
    },
    contentStyle() {
      const x = this.getTabIndex(this.activeKey);
      const p = x === 0 ? "0%" : `-${x}00%`;
      let style2 = {};
      if (x > -1) {
        style2 = {
          transform: `translateX(${p}) translateZ(0px)`
        };
      }
      return style2;
    },
    barStyle() {
      let style2 = {
        visibility: "hidden",
        width: `${this.barWidth}px`
      };
      if (this.type === "line")
        style2.visibility = "visible";
      if (this.animated) {
        style2.transform = `translate3d(${this.barOffset}px, 0px, 0px)`;
      } else {
        style2.left = `${this.barOffset}px`;
      }
      return style2;
    },
    arrowType() {
      const config = this.globalConfig;
      let type2 = "ios-close";
      if (config) {
        if (config.tabs.customCloseIcon) {
          type2 = "";
        } else if (config.tabs.closeIcon) {
          type2 = config.tabs.closeIcon;
        }
      }
      return type2;
    },
    customArrowType() {
      const config = this.globalConfig;
      let type2 = "";
      if (config) {
        if (config.tabs.customCloseIcon) {
          type2 = config.tabs.customCloseIcon;
        }
      }
      return type2;
    },
    arrowSize() {
      const config = this.globalConfig;
      let size = "";
      if (config) {
        if (config.tabs.closeIconSize) {
          size = config.tabs.closeIconSize;
        }
      }
      return size;
    }
  },
  methods: {
    getTabs() {
      const AllTabPanes = this.paneList.map((item) => item.pane);
      const TabPanes = [];
      AllTabPanes.forEach((item) => {
        if (item.tab && this.name) {
          if (item.tab === this.name) {
            TabPanes.push(item);
          }
        } else {
          TabPanes.push(item);
        }
      });
      TabPanes.sort((a, b) => {
        if (a.index && b.index) {
          return a.index > b.index ? 1 : -1;
        }
      });
      return TabPanes;
    },
    updateNav() {
      this.navList = [];
      this.getTabs().forEach((pane, index2) => {
        this.navList.push({
          labelType: typeof pane.label,
          label: pane.label,
          icon: pane.icon || "",
          name: pane.currentName || index2,
          disabled: pane.disabled,
          closable: pane.closable,
          contextMenu: pane.contextMenu
        });
        if (!pane.currentName)
          pane.currentName = index2;
        if (index2 === 0) {
          if (!this.activeKey)
            this.activeKey = pane.currentName || index2;
        }
      });
      this.updateStatus();
      this.updateBar();
    },
    updateBar() {
      nextTick(() => {
        const index2 = this.getTabIndex(this.activeKey);
        if (!this.$refs.nav)
          return;
        const prevTabs = this.$refs.nav.querySelectorAll(`.${prefixCls$r}-tab`);
        const tab = prevTabs[index2];
        this.barWidth = tab ? parseFloat(tab.offsetWidth) : 0;
        if (index2 > 0) {
          let offset = 0;
          const gutter = this.size === "small" ? 0 : 16;
          for (let i = 0; i < index2; i++) {
            offset += parseFloat(prevTabs[i].offsetWidth) + gutter;
          }
          this.barOffset = offset;
        } else {
          this.barOffset = 0;
        }
        this.updateNavScroll();
      });
    },
    updateStatus() {
      const tabs = this.getTabs();
      tabs.forEach((tab) => tab.show = tab.currentName === this.activeKey || this.animated);
    },
    tabCls(item) {
      return [
        `${prefixCls$r}-tab`,
        {
          [`${prefixCls$r}-tab-disabled`]: item.disabled,
          [`${prefixCls$r}-tab-active`]: item.name === this.activeKey,
          [`${prefixCls$r}-tab-focused`]: item.name === this.focusedKey
        }
      ];
    },
    handleChange(index2) {
      if (this.transitioning)
        return;
      this.transitioning = true;
      setTimeout(() => this.transitioning = false, transitionTime);
      const nav = this.navList[index2];
      if (!nav || nav.disabled)
        return;
      this.activeKey = nav.name;
      this.$emit("update:modelValue", nav.name);
      this.$emit("on-click", nav.name);
    },
    handleDblclick(index2) {
      const nav = this.navList[index2];
      if (!nav || nav.disabled)
        return;
      this.$emit("on-dblclick", nav.name);
    },
    handleContextmenu(index2, event) {
      if (this.contextMenuVisible)
        this.handleClickContextMenuOutside();
      nextTick(() => {
        const nav = this.navList[index2];
        if (!nav || nav.disabled || !nav.contextMenu)
          return;
        event.preventDefault();
        const $TabsWrap = this.$refs.tabsWrap;
        const TabsBounding = $TabsWrap.getBoundingClientRect();
        const position = {
          left: `${event.clientX - TabsBounding.left}px`,
          top: `${event.clientY - TabsBounding.top}px`
        };
        this.contextMenuStyles = position;
        this.contextMenuVisible = true;
        this.$emit("on-contextmenu", nav, event, position);
      });
    },
    handleClickContextMenuOutside() {
      this.contextMenuVisible = false;
    },
    handlePreventSelect(index2, event) {
      const nav = this.navList[index2];
      if (!nav || nav.disabled || !nav.contextMenu)
        return;
      event.preventDefault();
    },
    handleTabKeyNavigation(e) {
      if (e.keyCode !== 37 && e.keyCode !== 39)
        return;
      const direction = e.keyCode === 39 ? 1 : -1;
      const nextTab = getNextTab(this.navList, this.focusedKey, direction);
      this.focusedKey = nextTab.name;
    },
    handleTabKeyboardSelect(init = false) {
      if (init)
        return;
      const focused = this.focusedKey || 0;
      const index2 = this.getTabIndex(focused);
      this.handleChange(index2);
    },
    handleRemove(index2) {
      if (!this.beforeRemove) {
        return this.handleRemoveTab(index2);
      }
      const before = this.beforeRemove(index2);
      if (before && before.then) {
        before.then(() => {
          this.handleRemoveTab(index2);
        });
      } else {
        this.handleRemoveTab(index2);
      }
    },
    handleRemoveTab(index2) {
      const tabs = this.getTabs();
      const tab = tabs[index2];
      if (tab.currentName === this.activeKey) {
        const newTabs = this.getTabs();
        let activeKey = -1;
        if (newTabs.length) {
          const leftNoDisabledTabs = tabs.filter((item, itemIndex) => !item.disabled && itemIndex < index2);
          const rightNoDisabledTabs = tabs.filter((item, itemIndex) => !item.disabled && itemIndex > index2);
          if (rightNoDisabledTabs.length) {
            activeKey = rightNoDisabledTabs[0].currentName;
          } else if (leftNoDisabledTabs.length) {
            activeKey = leftNoDisabledTabs[leftNoDisabledTabs.length - 1].currentName;
          } else {
            activeKey = newTabs[0].currentName;
          }
        }
        this.activeKey = activeKey;
        this.$emit("update:modelValue", activeKey);
      }
      this.$emit("on-tab-remove", tab.currentName);
      this.updateNav();
    },
    showClose(item) {
      if (this.type === "card") {
        if (item.closable !== null) {
          return item.closable;
        } else {
          return this.closable;
        }
      } else {
        return false;
      }
    },
    scrollPrev() {
      const containerWidth = this.$refs.navScroll.offsetWidth;
      const currentOffset = this.getCurrentScrollOffset();
      if (!currentOffset)
        return;
      let newOffset = currentOffset > containerWidth ? currentOffset - containerWidth : 0;
      this.setOffset(newOffset);
    },
    scrollNext() {
      const navWidth = this.$refs.nav.offsetWidth;
      const containerWidth = this.$refs.navScroll.offsetWidth;
      const currentOffset = this.getCurrentScrollOffset();
      if (navWidth - currentOffset <= containerWidth)
        return;
      let newOffset = navWidth - currentOffset > containerWidth * 2 ? currentOffset + containerWidth : navWidth - containerWidth;
      this.setOffset(newOffset);
    },
    getCurrentScrollOffset() {
      const { navStyle } = this;
      return navStyle.transform ? Number(navStyle.transform.match(/translateX\(-(\d+(\.\d+)*)px\)/)[1]) : 0;
    },
    getTabIndex(name2) {
      return this.navList.findIndex((nav) => nav.name === name2);
    },
    setOffset(value) {
      this.navStyle.transform = `translateX(-${value}px)`;
    },
    scrollToActiveTab() {
      if (!this.scrollable)
        return;
      const nav = this.$refs.nav;
      const activeTab = this.$el.querySelector(`.${prefixCls$r}-tab-active`);
      if (!activeTab)
        return;
      const navScroll = this.$refs.navScroll;
      const activeTabBounding = activeTab.getBoundingClientRect();
      const navScrollBounding = navScroll.getBoundingClientRect();
      const navBounding = nav.getBoundingClientRect();
      const currentOffset = this.getCurrentScrollOffset();
      let newOffset = currentOffset;
      if (navBounding.right < navScrollBounding.right) {
        newOffset = nav.offsetWidth - navScrollBounding.width;
      }
      if (activeTabBounding.left < navScrollBounding.left) {
        newOffset = currentOffset - (navScrollBounding.left - activeTabBounding.left);
      } else if (activeTabBounding.right > navScrollBounding.right) {
        newOffset = currentOffset + activeTabBounding.right - navScrollBounding.right;
      }
      if (currentOffset !== newOffset) {
        this.setOffset(Math.max(newOffset, 0));
      }
    },
    updateNavScroll() {
      const navWidth = this.$refs.nav.offsetWidth;
      const containerWidth = this.$refs.navScroll.offsetWidth;
      const currentOffset = this.getCurrentScrollOffset();
      if (containerWidth < navWidth) {
        this.scrollable = true;
        if (navWidth - currentOffset < containerWidth) {
          this.setOffset(navWidth - containerWidth);
        }
      } else {
        this.scrollable = false;
        if (currentOffset > 0) {
          this.setOffset(0);
        }
      }
    },
    handleScroll(e) {
      e.preventDefault();
      e.stopPropagation();
      const type2 = e.type;
      let delta = 0;
      if (type2 === "DOMMouseScroll" || type2 === "mousewheel") {
        delta = e.wheelDelta ? e.wheelDelta : -(e.detail || 0) * 40;
      }
      if (delta > 0) {
        this.scrollPrev();
      } else {
        this.scrollNext();
      }
    },
    handleResize() {
      this.updateNavScroll();
    },
    isInsideHiddenElement() {
      if (!isClient)
        return;
      let parentNode = this.$el.parentNode;
      while (parentNode && parentNode !== document.body) {
        if (parentNode.style && parentNode.style.display === "none") {
          return parentNode;
        }
        parentNode = parentNode.parentNode;
      }
      return false;
    },
    updateVisibility(index2) {
      [...this.$refs.panes.querySelectorAll(`.${prefixCls$r}-tabpane`)].forEach((el, i) => {
        if (index2 === i) {
          [...el.children].filter((child) => child.classList.contains(`${prefixCls$r}-tabpane`)).forEach((child) => child.style.visibility = "visible");
          if (this.captureFocus)
            setTimeout(() => focusFirst(el, el), transitionTime);
        } else {
          setTimeout(() => {
            [...el.children].filter((child) => child.classList.contains(`${prefixCls$r}-tabpane`)).forEach((child) => child.style.visibility = "hidden");
          }, transitionTime);
        }
      });
    },
    handleDrag(index2, event) {
      const nav = this.navList[index2];
      if (nav) {
        event.dataTransfer.setData("tab-name", nav.name);
      }
    },
    handleDrop(index2, event) {
      const nav = this.navList[index2];
      if (nav) {
        const dragName = event.dataTransfer.getData("tab-name");
        event.preventDefault();
        let navNames = this.navList.map((item) => item.name);
        const a = parseInt(navNames.findIndex((item) => item === dragName));
        const b = parseInt(navNames.findIndex((item) => item === nav.name));
        navNames.splice(b, 1, ...navNames.splice(a, 1, navNames[b]));
        this.$emit("on-drag-drop", dragName, nav.name, a, b, navNames);
      }
    },
    closeContextMenu() {
      this.handleClickContextMenuOutside();
    },
    handleClickDropdownItem() {
      if (this.autoCloseContextmenu)
        this.closeContextMenu();
    }
  },
  watch: {
    modelValue(val) {
      this.activeKey = val;
      this.focusedKey = val;
    },
    activeKey(val) {
      this.focusedKey = val;
      this.updateBar();
      this.updateStatus();
      this.tableList.forEach((item) => {
        item.table.handleOnVisibleChange(true);
      });
      nextTick(() => {
        this.scrollToActiveTab();
      });
      const nextIndex = Math.max(this.getTabIndex(this.focusedKey), 0);
      this.updateVisibility(nextIndex);
    }
  },
  mounted() {
    this.showSlot = this.$slots.extra !== void 0;
    this.observer = elementResizeDetector();
    this.observer.listenTo(this.$refs.navWrap, this.handleResize);
    const hiddenParentNode = this.isInsideHiddenElement();
    if (hiddenParentNode) {
      this.mutationObserver = new MutationObserver(() => {
        if (hiddenParentNode.style.display !== "none") {
          this.updateBar();
          this.mutationObserver.disconnect();
        }
      });
      this.mutationObserver.observe(hiddenParentNode, { attributes: true, childList: true, characterData: true, attributeFilter: ["style"] });
    }
    this.handleTabKeyboardSelect(true);
    this.updateVisibility(this.getTabIndex(this.activeKey));
  },
  beforeUnmount() {
    this.observer.removeListener(this.$refs.navWrap, this.handleResize);
    if (this.mutationObserver)
      this.mutationObserver.disconnect();
  }
};
const _hoisted_1$u = ["onClick", "onDblclick", "onContextmenu", "onSelectstart", "draggable", "onDragstart", "onDrop"];
function _sfc_render$O(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = resolveComponent("Icon");
  const _component_Render = resolveComponent("Render");
  const _component_DropdownMenu = resolveComponent("DropdownMenu");
  const _component_Dropdown = resolveComponent("Dropdown");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes),
    ref: "tabsWrap"
  }, [
    createElementVNode("div", {
      class: normalizeClass([$data.prefixCls + "-bar"])
    }, [
      $data.showSlot ? (openBlock(), createElementBlock("div", {
        key: 0,
        class: normalizeClass([$data.prefixCls + "-nav-right"])
      }, [
        renderSlot(_ctx.$slots, "extra")
      ], 2)) : createCommentVNode("", true),
      createElementVNode("div", {
        class: normalizeClass([$data.prefixCls + "-nav-container"]),
        tabindex: "0",
        ref: "navContainer",
        onKeydown: [
          _cache[5] || (_cache[5] = (...args) => $options.handleTabKeyNavigation && $options.handleTabKeyNavigation(...args)),
          _cache[6] || (_cache[6] = withKeys(withModifiers(($event) => $options.handleTabKeyboardSelect(false), ["prevent"]), ["space"]))
        ]
      }, [
        createElementVNode("div", {
          ref: "navWrap",
          class: normalizeClass([$data.prefixCls + "-nav-wrap", $data.scrollable ? $data.prefixCls + "-nav-scrollable" : ""])
        }, [
          createElementVNode("span", {
            class: normalizeClass([$data.prefixCls + "-nav-prev", $data.scrollable ? "" : $data.prefixCls + "-nav-scroll-disabled"]),
            onClick: _cache[0] || (_cache[0] = (...args) => $options.scrollPrev && $options.scrollPrev(...args))
          }, [
            createVNode(_component_Icon, { type: "ios-arrow-back" })
          ], 2),
          createElementVNode("span", {
            class: normalizeClass([$data.prefixCls + "-nav-next", $data.scrollable ? "" : $data.prefixCls + "-nav-scroll-disabled"]),
            onClick: _cache[1] || (_cache[1] = (...args) => $options.scrollNext && $options.scrollNext(...args))
          }, [
            createVNode(_component_Icon, { type: "ios-arrow-forward" })
          ], 2),
          createElementVNode("div", {
            ref: "navScroll",
            class: normalizeClass([$data.prefixCls + "-nav-scroll"]),
            "on:DOMMouseScroll": _cache[3] || (_cache[3] = (...args) => $options.handleScroll && $options.handleScroll(...args)),
            onMousewheel: _cache[4] || (_cache[4] = (...args) => $options.handleScroll && $options.handleScroll(...args))
          }, [
            createElementVNode("div", {
              ref: "nav",
              class: normalizeClass([$data.prefixCls + "-nav"]),
              style: normalizeStyle($data.navStyle)
            }, [
              createElementVNode("div", {
                class: normalizeClass($options.barClasses),
                style: normalizeStyle($options.barStyle)
              }, null, 6),
              (openBlock(true), createElementBlock(Fragment, null, renderList($data.navList, (item, index2) => {
                return openBlock(), createElementBlock("div", {
                  class: normalizeClass($options.tabCls(item)),
                  key: index2,
                  onClick: ($event) => $options.handleChange(index2),
                  onDblclick: ($event) => $options.handleDblclick(index2),
                  onContextmenu: withModifiers(($event) => $options.handleContextmenu(index2, $event), ["stop"]),
                  onSelectstart: withModifiers(($event) => $options.handlePreventSelect(index2, $event), ["stop"]),
                  draggable: $props.draggable,
                  onDragstart: ($event) => $options.handleDrag(index2, $event),
                  onDrop: ($event) => $options.handleDrop(index2, $event),
                  onDragover: _cache[2] || (_cache[2] = withModifiers(() => {
                  }, ["prevent"]))
                }, [
                  item.icon !== "" ? (openBlock(), createBlock(_component_Icon, {
                    key: 0,
                    type: item.icon
                  }, null, 8, ["type"])) : createCommentVNode("", true),
                  item.labelType === "function" ? (openBlock(), createBlock(_component_Render, {
                    key: 1,
                    render: item.label
                  }, null, 8, ["render"])) : (openBlock(), createElementBlock(Fragment, { key: 2 }, [
                    createTextVNode(toDisplayString(item.label), 1)
                  ], 64)),
                  $options.showClose(item) ? (openBlock(), createBlock(_component_Icon, {
                    key: 3,
                    class: normalizeClass([$data.prefixCls + "-close"]),
                    type: $options.arrowType,
                    custom: $options.customArrowType,
                    size: $options.arrowSize,
                    onClick: withModifiers(($event) => $options.handleRemove(index2), ["stop"])
                  }, null, 8, ["class", "type", "custom", "size", "onClick"])) : createCommentVNode("", true)
                ], 42, _hoisted_1$u);
              }), 128))
            ], 6)
          ], 34)
        ], 2)
      ], 34)
    ], 2),
    createElementVNode("div", {
      class: normalizeClass($options.contentClasses),
      style: normalizeStyle($options.contentStyle),
      ref: "panes"
    }, [
      renderSlot(_ctx.$slots, "default")
    ], 6),
    createElementVNode("div", {
      class: "ivu-tabs-context-menu",
      style: normalizeStyle($data.contextMenuStyles)
    }, [
      createVNode(_component_Dropdown, {
        trigger: "custom",
        visible: $data.contextMenuVisible,
        transfer: "",
        onOnClick: $options.handleClickDropdownItem,
        onOnClickoutside: $options.handleClickContextMenuOutside
      }, {
        list: withCtx(() => [
          createVNode(_component_DropdownMenu, null, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "contextMenu")
            ]),
            _: 3
          })
        ]),
        _: 3
      }, 8, ["visible", "onOnClick", "onOnClickoutside"])
    ], 4)
  ], 2);
}
var Tabs = /* @__PURE__ */ _export_sfc(_sfc_main$X, [["render", _sfc_render$O]]);
const _sfc_main$W = {
  name: "Notification",
  components: { Dropdown, DropdownMenu, Badge, Tabs },
  emits: ["on-visible-change", "on-item-click", "on-clear", "on-load-more", "on-tab-change"],
  provide() {
    return {
      NotificationInstance: this
    };
  },
  props: {
    count: {
      type: Number
    },
    autoCount: {
      type: Boolean,
      default: false
    },
    countType: {
      validator(value) {
        return oneOf(value, ["text", "badge"]);
      },
      default: "text"
    },
    icon: {
      type: String,
      default: "md-notifications-outline"
    },
    transfer: {
      type: Boolean,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.transfer === "" ? false : global2.$VIEWUI.transfer;
      }
    },
    placement: {
      validator(value) {
        return oneOf(value, ["top", "top-start", "top-end", "bottom", "bottom-start", "bottom-end", "left", "left-start", "left-end", "right", "right-start", "right-end"]);
      },
      default: "bottom"
    },
    badgeProps: {
      type: Object,
      default() {
        return {};
      }
    },
    clearClose: {
      type: Boolean,
      default: false
    },
    locale: {
      type: Object,
      default() {
        return {
          loadedAll: "\u52A0\u8F7D\u5B8C\u6BD5",
          loading: "\u52A0\u8F7D\u4E2D...",
          loadMore: "\u52A0\u8F7D\u66F4\u591A",
          clear: "\u6E05\u7A7A"
        };
      }
    },
    tab: {
      type: String
    },
    wide: {
      type: Boolean,
      default: false
    },
    transferClassName: {
      type: String
    }
  },
  data() {
    return {
      visible: false,
      countAll: 0,
      tabList: []
    };
  },
  computed: {
    finalCount() {
      return this.autoCount ? this.countAll : this.count;
    },
    transferClasses() {
      let classes = "ivu-notifications-transfer";
      if (this.transferClassName)
        classes += ` ${this.transferClassName}`;
      return classes;
    }
  },
  watch: {
    visible(val) {
      this.$emit("on-visible-change", val);
    }
  },
  methods: {
    handleVisibleChange(visible) {
      this.visible = visible;
    },
    handleClickOutside(e) {
      if (this.$refs.notice.contains(e.target))
        return;
      this.visible = false;
    },
    handleToggleOpen() {
      this.visible = !this.visible;
    },
    handleGetCountAll() {
      if (this.autoCount) {
        const $tabs = this.tabList.map((item) => item.tab);
        let countAll = 0;
        $tabs.forEach((item) => {
          if (item.count)
            countAll += item.count;
        });
        this.countAll = countAll;
      }
    },
    handleItemClick(tab, item) {
      this.$emit("on-item-click", tab, item);
    },
    handleClear(tab) {
      this.$emit("on-clear", tab);
      if (this.clearClose)
        this.handleClose();
    },
    handleLoadMore(tab) {
      this.$emit("on-load-more", tab);
    },
    handleClose() {
      this.visible = false;
    },
    handleTabChange(name2) {
      const $tabs = this.tabList.map((item) => item.tab);
      let tabInfo = {};
      $tabs.forEach((item) => {
        const tab = item.$refs.tab;
        if (tab.currentName === name2) {
          tabInfo = item.handleGetTabBaseInfo();
        }
      });
      this.$emit("on-tab-change", tabInfo);
    }
  }
};
const _hoisted_1$t = {
  class: "ivu-notifications",
  ref: "notice"
};
const _hoisted_2$j = { class: "ivu-notifications-tabs" };
const _hoisted_3$f = {
  key: 0,
  class: "ivu-notifications-extra"
};
function _sfc_render$N(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = resolveComponent("Icon");
  const _component_Badge = resolveComponent("Badge");
  const _component_Tabs = resolveComponent("Tabs");
  const _component_DropdownMenu = resolveComponent("DropdownMenu");
  const _component_Dropdown = resolveComponent("Dropdown");
  return openBlock(), createElementBlock("div", _hoisted_1$t, [
    createVNode(_component_Dropdown, {
      trigger: "custom",
      visible: $data.visible,
      transfer: $props.transfer,
      placement: $props.placement,
      "transfer-class-name": $options.transferClasses,
      onOnVisibleChange: $options.handleVisibleChange,
      onOnClickoutside: $options.handleClickOutside
    }, {
      list: withCtx(() => [
        _ctx.$slots.default ? (openBlock(), createBlock(_component_DropdownMenu, {
          key: 0,
          onClick: _cache[1] || (_cache[1] = withModifiers(() => {
          }, ["stop"]))
        }, {
          default: withCtx(() => [
            createElementVNode("div", {
              class: normalizeClass(["ivu-notifications-list", { "ivu-notifications-list-wide": $props.wide }])
            }, [
              createElementVNode("div", _hoisted_2$j, [
                createVNode(_component_Tabs, {
                  animated: false,
                  "model-value": $props.tab,
                  onOnClick: $options.handleTabChange
                }, {
                  default: withCtx(() => [
                    renderSlot(_ctx.$slots, "default")
                  ]),
                  _: 3
                }, 8, ["model-value", "onOnClick"])
              ])
            ], 2),
            _ctx.$slots.extra ? (openBlock(), createElementBlock("div", _hoisted_3$f, [
              renderSlot(_ctx.$slots, "extra")
            ])) : createCommentVNode("", true)
          ]),
          _: 3
        })) : createCommentVNode("", true)
      ]),
      default: withCtx(() => [
        createElementVNode("div", {
          class: "ivu-notifications-rel",
          onClick: _cache[0] || (_cache[0] = withModifiers((...args) => $options.handleToggleOpen && $options.handleToggleOpen(...args), ["prevent", "stop"]))
        }, [
          createVNode(_component_Badge, mergeProps({ count: $options.finalCount }, $props.badgeProps), {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "icon", {}, () => [
                createVNode(_component_Icon, {
                  type: $props.icon,
                  size: "24"
                }, null, 8, ["type"])
              ])
            ]),
            _: 3
          }, 16, ["count"])
        ])
      ]),
      _: 3
    }, 8, ["visible", "transfer", "placement", "transfer-class-name", "onOnVisibleChange", "onOnClickoutside"])
  ], 512);
}
var Notification = /* @__PURE__ */ _export_sfc(_sfc_main$W, [["render", _sfc_render$N]]);
const isEarly = (timeStamp, currentTime) => {
  return timeStamp <= currentTime;
};
const getHandledValue = (num) => {
  return num < 10 ? "0" + num : num;
};
const getDate = (timeStamp, startType) => {
  const d = new Date(timeStamp);
  const year = d.getFullYear();
  const month = getHandledValue(d.getMonth() + 1);
  const date3 = getHandledValue(d.getDate());
  const hours = getHandledValue(d.getHours());
  const minutes = getHandledValue(d.getMinutes());
  const second = getHandledValue(d.getSeconds());
  let resStr = "";
  if (startType === "year")
    resStr = year + "-" + month + "-" + date3 + " " + hours + ":" + minutes + ":" + second;
  else
    resStr = month + "-" + date3 + " " + hours + ":" + minutes;
  return resStr;
};
const getRelativeTime = (timeStamp, locale2) => {
  const currentTime = new Date().getTime();
  const IS_EARLY = isEarly(timeStamp, currentTime);
  let diff = currentTime - timeStamp;
  if (!IS_EARLY)
    diff = -diff;
  let resStr = "";
  let dirStr = IS_EARLY ? locale2("i.time.before") || "\u524D" : locale2("i.time.after") || "\u540E";
  if (diff < 1e3)
    resStr = locale2("i.time.just") || "\u521A\u521A";
  else if (diff < 6e4)
    resStr = parseInt(diff / 1e3) + (locale2("i.time.seconds") || "\u79D2") + dirStr;
  else if (diff >= 6e4 && diff < 36e5)
    resStr = Math.floor(diff / 6e4) + (locale2("i.time.minutes") || "\u5206\u949F") + dirStr;
  else if (diff >= 36e5 && diff < 864e5)
    resStr = Math.floor(diff / 36e5) + (locale2("i.time.hours") || "\u5C0F\u65F6") + dirStr;
  else if (diff >= 864e5 && diff < 262386e4)
    resStr = Math.floor(diff / 864e5) + (locale2("i.time.days") || "\u5929") + dirStr;
  else if (diff >= 262386e4 && diff <= 3156786e4 && IS_EARLY)
    resStr = getDate(timeStamp);
  else
    resStr = getDate(timeStamp, "year");
  return resStr;
};
function Time$1(timestamp, locale2) {
  return getRelativeTime(timestamp, locale2);
}
const prefixCls$q = "ivu-time";
const _sfc_main$V = {
  name: "Time",
  mixins: [Locale],
  props: {
    time: {
      type: [Number, Date, String],
      required: true
    },
    type: {
      type: String,
      validator(value) {
        return oneOf(value, ["relative", "date", "datetime"]);
      },
      default: "relative"
    },
    hash: {
      type: String,
      default: ""
    },
    interval: {
      type: Number,
      default: 60
    }
  },
  data() {
    return {
      date: ""
    };
  },
  computed: {
    classes() {
      return [
        `${prefixCls$q}`,
        {
          [`${prefixCls$q}-with-hash`]: this.hash
        }
      ];
    }
  },
  watch: {
    time() {
      this.setTime();
    }
  },
  methods: {
    handleClick() {
      if (isClient && this.hash !== "")
        window.location.hash = this.hash;
    },
    setTime() {
      const type2 = typeof this.time;
      let time;
      if (type2 === "number") {
        const timestamp = this.time.toString().length > 10 ? this.time : this.time * 1e3;
        time = new Date(timestamp).getTime();
      } else if (type2 === "object") {
        time = this.time.getTime();
      } else if (type2 === "string") {
        time = dayjs(this.time).valueOf();
      }
      if (this.type === "relative") {
        this.date = Time$1(time, this.t);
      } else {
        const date3 = new Date(this.time);
        const year = date3.getFullYear();
        const month = date3.getMonth() + 1 < 10 ? "0" + (date3.getMonth() + 1) : date3.getMonth() + 1;
        const day = date3.getDate() < 10 ? "0" + date3.getDate() : date3.getDate();
        const hour = date3.getHours() < 10 ? "0" + date3.getHours() : date3.getHours();
        const minute = date3.getMinutes() < 10 ? "0" + date3.getMinutes() : date3.getMinutes();
        const second = date3.getSeconds() < 10 ? "0" + date3.getSeconds() : date3.getSeconds();
        if (this.type === "datetime") {
          this.date = `${year}-${month}-${day} ${hour}:${minute}:${second}`;
        } else if (this.type === "date") {
          this.date = `${year}-${month}-${day}`;
        }
      }
    }
  },
  mounted() {
    this.setTime();
    if (this.interval !== 0) {
      this.timer = setInterval(() => {
        this.setTime();
      }, 1e3 * this.interval);
    }
  },
  beforeUnmount() {
    if (this.timer)
      clearInterval(this.timer);
  }
};
function _sfc_render$M(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("span", {
    class: normalizeClass($options.classes),
    onClick: _cache[0] || (_cache[0] = (...args) => $options.handleClick && $options.handleClick(...args))
  }, toDisplayString($data.date), 3);
}
var Time = /* @__PURE__ */ _export_sfc(_sfc_main$V, [["render", _sfc_render$M]]);
const _sfc_main$U = {
  name: "NotificationItem",
  inject: ["NotificationTabInstance", "NotificationInstance"],
  components: { Row, Col, Avatar, Tag, Time },
  emits: ["on-item-click"],
  props: {
    rowProps: {
      type: Object,
      default() {
        return {
          type: "flex",
          justify: "center",
          align: "middle"
        };
      }
    },
    read: {
      type: [Boolean, Number],
      default: false
    },
    icon: {
      type: String
    },
    customIcon: {
      type: String
    },
    iconColor: {
      type: String
    },
    iconSize: {
      validator(value) {
        return oneOf(value, ["small", "default", "large"]);
      },
      default: "default"
    },
    avatar: {
      type: String
    },
    avatarShape: {
      validator(value) {
        return oneOf(value, ["circle", "square"]);
      },
      default: "circle"
    },
    title: {
      type: String
    },
    content: {
      type: String
    },
    time: {
      type: [Number, Date, String]
    },
    timeProps: {
      type: Object,
      default() {
        return {};
      }
    },
    tag: {
      type: String
    },
    tagProps: {
      type: Object,
      default() {
        return {};
      }
    },
    clickClose: {
      type: Boolean,
      default: false
    }
  },
  data() {
    return {
      id: random(6)
    };
  },
  computed: {
    classes() {
      return {
        "ivu-notifications-item-unread": this.read === false || this.read === 0
      };
    },
    contentSpan() {
      return this.icon || this.customIcon || this.avatar || this.$slots.avatar ? 20 : 24;
    },
    iconStyle() {
      let style2 = {};
      if (this.iconColor) {
        style2 = {
          "background-color": this.iconColor
        };
      }
      return style2;
    }
  },
  methods: {
    handleClick() {
      this.$emit("on-item-click", this.$attrs);
      this.NotificationTabInstance.handleItemClick(this.$attrs);
      if (this.clickClose) {
        this.NotificationInstance.handleClose();
      }
    },
    addItem() {
      const target = this.NotificationTabInstance;
      target.itemList.push({
        id: this.id,
        item: this
      });
    },
    removeItem() {
      const target = this.NotificationTabInstance;
      const index2 = target.itemList.findIndex((item) => item.id === this.id);
      target.itemList.splice(index2, 1);
    }
  },
  mounted() {
    this.addItem();
    this.NotificationTabInstance.handleGetItems();
  },
  unmounted() {
    this.NotificationTabInstance.handleGetItems();
  },
  beforeUnmount() {
    this.removeItem();
  }
};
const _hoisted_1$s = { class: "ivu-notifications-item-title" };
const _hoisted_2$i = { key: 0 };
const _hoisted_3$e = {
  key: 0,
  class: "ivu-notifications-item-tag"
};
const _hoisted_4$b = {
  key: 0,
  class: "ivu-notifications-item-desc"
};
const _hoisted_5$7 = {
  key: 1,
  class: "ivu-notifications-item-time"
};
function _sfc_render$L(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Avatar = resolveComponent("Avatar");
  const _component_Col = resolveComponent("Col");
  const _component_Tag = resolveComponent("Tag");
  const _component_Time = resolveComponent("Time");
  const _component_Row = resolveComponent("Row");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(["ivu-notifications-item", $options.classes]),
    onClick: _cache[0] || (_cache[0] = (...args) => $options.handleClick && $options.handleClick(...args))
  }, [
    renderSlot(_ctx.$slots, "default", {}, () => [
      createVNode(_component_Row, normalizeProps(guardReactiveProps($props.rowProps)), {
        default: withCtx(() => [
          $props.icon || $props.customIcon || $props.avatar || _ctx.$slots.avatar ? (openBlock(), createBlock(_component_Col, {
            key: 0,
            span: "4",
            class: "ivu-notifications-item-icon"
          }, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "avatar", {}, () => [
                $props.icon ? (openBlock(), createBlock(_component_Avatar, {
                  key: 0,
                  icon: $props.icon,
                  shape: $props.avatarShape,
                  size: $props.iconSize,
                  style: normalizeStyle($options.iconStyle)
                }, null, 8, ["icon", "shape", "size", "style"])) : $props.customIcon ? (openBlock(), createBlock(_component_Avatar, {
                  key: 1,
                  "custom-icon": $props.customIcon,
                  shape: $props.avatarShape,
                  size: $props.iconSize,
                  style: normalizeStyle($options.iconStyle)
                }, null, 8, ["custom-icon", "shape", "size", "style"])) : $props.avatar ? (openBlock(), createBlock(_component_Avatar, {
                  key: 2,
                  src: $props.avatar,
                  shape: $props.avatarShape,
                  size: $props.iconSize,
                  style: normalizeStyle($options.iconStyle)
                }, null, 8, ["src", "shape", "size", "style"])) : createCommentVNode("", true)
              ])
            ]),
            _: 3
          })) : createCommentVNode("", true),
          createVNode(_component_Col, {
            span: $options.contentSpan,
            class: "ivu-notifications-item-content"
          }, {
            default: withCtx(() => [
              createElementVNode("div", _hoisted_1$s, [
                $props.title || _ctx.$slots.title ? (openBlock(), createElementBlock("h4", _hoisted_2$i, [
                  renderSlot(_ctx.$slots, "title", {}, () => [
                    createTextVNode(toDisplayString($props.title), 1)
                  ]),
                  $props.tag ? (openBlock(), createElementBlock("div", _hoisted_3$e, [
                    createVNode(_component_Tag, normalizeProps(guardReactiveProps($props.tagProps)), {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString($props.tag), 1)
                      ]),
                      _: 1
                    }, 16)
                  ])) : createCommentVNode("", true)
                ])) : createCommentVNode("", true)
              ]),
              $props.content || _ctx.$slots.content ? (openBlock(), createElementBlock("div", _hoisted_4$b, [
                renderSlot(_ctx.$slots, "content", {}, () => [
                  createTextVNode(toDisplayString($props.content), 1)
                ])
              ])) : createCommentVNode("", true),
              $props.time || _ctx.$slots.time ? (openBlock(), createElementBlock("div", _hoisted_5$7, [
                renderSlot(_ctx.$slots, "time", {}, () => [
                  createVNode(_component_Time, mergeProps({ time: $props.time }, $props.timeProps), null, 16, ["time"])
                ])
              ])) : createCommentVNode("", true)
            ]),
            _: 3
          }, 8, ["span"])
        ]),
        _: 3
      }, 16)
    ])
  ], 2);
}
var NotificationItem = /* @__PURE__ */ _export_sfc(_sfc_main$U, [["render", _sfc_render$L]]);
const prefixCls$p = "ivu-tabs-tabpane";
const _sfc_main$T = {
  name: "TabPane",
  inject: ["TabsInstance"],
  props: {
    name: {
      type: String
    },
    label: {
      type: [String, Function],
      default: ""
    },
    icon: {
      type: String
    },
    disabled: {
      type: Boolean,
      default: false
    },
    closable: {
      type: Boolean,
      default: null
    },
    tab: {
      type: String
    },
    index: {
      type: Number
    },
    contextMenu: {
      type: Boolean,
      default: false
    }
  },
  data() {
    return {
      prefixCls: prefixCls$p,
      show: true,
      currentName: this.name,
      id: random(6)
    };
  },
  computed: {
    contentStyle() {
      return {
        visibility: this.TabsInstance.activeKey !== this.currentName ? "hidden" : "visible"
      };
    }
  },
  methods: {
    updateNav() {
      this.TabsInstance.updateNav();
    },
    addPane() {
      const root2 = this.TabsInstance;
      if (!root2.paneList)
        root2.paneList = [];
      root2.paneList.push({
        id: this.id,
        pane: this
      });
    },
    removePane() {
      const root2 = this.TabsInstance;
      if (root2.paneList && root2.paneList.length) {
        const index2 = root2.paneList.findIndex((item) => item.id === this.id);
        root2.paneList.splice(index2, 1);
      }
    }
  },
  watch: {
    name(val) {
      this.currentName = val;
      this.updateNav();
    },
    label(val) {
      if (typeof val !== "function")
        this.updateNav();
    },
    icon() {
      this.updateNav();
    },
    disabled() {
      this.updateNav();
    }
  },
  mounted() {
    this.addPane();
    this.updateNav();
  },
  beforeUnmount() {
    this.removePane();
    this.updateNav();
  }
};
function _sfc_render$K(_ctx, _cache, $props, $setup, $data, $options) {
  return withDirectives((openBlock(), createElementBlock("div", {
    class: normalizeClass($data.prefixCls),
    style: normalizeStyle($options.contentStyle)
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 6)), [
    [vShow, $data.show]
  ]);
}
var TabPane = /* @__PURE__ */ _export_sfc(_sfc_main$T, [["render", _sfc_render$K]]);
const _sfc_main$S = {
  name: "NotificationTab",
  inject: ["NotificationInstance"],
  components: { TabPane, Icon },
  provide() {
    return {
      NotificationTabInstance: this
    };
  },
  props: {
    count: {
      type: Number
    },
    title: {
      type: String,
      required: true
    },
    name: {
      type: String
    },
    emptyText: {
      type: String,
      default: "\u76EE\u524D\u6CA1\u6709\u901A\u77E5"
    },
    emptyImage: {
      type: String,
      default: "https://file.iviewui.com/iview-pro/icon-no-message.svg"
    },
    loadedAll: {
      type: Boolean,
      default: true
    },
    showLoadedAll: {
      type: Boolean,
      default: true
    },
    loading: {
      type: Boolean,
      default: false
    },
    scrollToLoad: {
      type: Boolean,
      default: true
    },
    showClear: {
      type: Boolean,
      default: true
    },
    showClearIcon: {
      type: Boolean,
      default: true
    }
  },
  data() {
    return {
      customLabel: (h2) => {
        return h2("div", [
          h2("span", this.title),
          h2(Badge, {
            count: this.count
          })
        ]);
      },
      itemCount: 0,
      itemList: [],
      id: random(6)
    };
  },
  computed: {
    currentTitle() {
      const countType = this.NotificationInstance.countType;
      if (countType === "text") {
        const count = this.count ? `(${this.count})` : "";
        return `${this.title} ${count}`;
      } else if (countType === "badge") {
        return this.customLabel;
      }
    }
  },
  watch: {
    count: {
      handler() {
        this.NotificationInstance.handleGetCountAll();
      },
      immediate: true
    }
  },
  methods: {
    handleGetTabBaseInfo() {
      return {
        name: this.name,
        title: this.title
      };
    },
    handleGetItems() {
      const items = this.itemList.map((item) => item.item);
      this.itemCount = items.length;
    },
    handleItemClick(item) {
      this.NotificationInstance.handleItemClick(this.handleGetTabBaseInfo(), item);
    },
    handleClear() {
      this.NotificationInstance.handleClear(this.handleGetTabBaseInfo());
    },
    handleLoadMore() {
      this.NotificationInstance.handleLoadMore(this.handleGetTabBaseInfo());
    },
    handleScroll() {
      if (!this.scrollToLoad)
        return;
      const $scroll = this.$refs.scroll;
      const displacement = $scroll.scrollHeight - $scroll.clientHeight - $scroll.scrollTop;
      if (!this.loading && displacement === 0) {
        this.handleLoadMore();
      }
    },
    addTab() {
      const target = this.NotificationInstance;
      target.tabList.push({
        id: this.id,
        tab: this
      });
    },
    removeTab() {
      const target = this.NotificationInstance;
      const index2 = target.tabList.findIndex((item) => item.id === this.id);
      target.tabList.splice(index2, 1);
    }
  },
  mounted() {
    this.addTab();
  },
  beforeUnmount() {
    this.removeTab();
  }
};
const _hoisted_1$r = { class: "ivu-notifications-container-list" };
const _hoisted_2$h = {
  key: 0,
  class: "ivu-notifications-tab-empty"
};
const _hoisted_3$d = ["src"];
const _hoisted_4$a = { class: "ivu-notifications-tab-empty-text" };
const _hoisted_5$6 = { class: "ivu-notifications-tab-loading" };
const _hoisted_6$4 = {
  key: 0,
  class: "ivu-notifications-tab-loading-item ivu-notifications-tab-loading-show"
};
const _hoisted_7$3 = {
  key: 2,
  class: "ivu-notifications-tab-loading-item ivu-notifications-tab-loading-all"
};
function _sfc_render$J(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = resolveComponent("Icon");
  const _component_TabPane = resolveComponent("TabPane");
  return openBlock(), createBlock(_component_TabPane, {
    label: $options.currentTitle,
    name: $props.name,
    ref: "tab",
    class: "ivu-notifications-tab"
  }, {
    default: withCtx(() => [
      createElementVNode("div", {
        class: "ivu-notifications-container",
        onScroll: _cache[1] || (_cache[1] = (...args) => $options.handleScroll && $options.handleScroll(...args)),
        ref: "scroll"
      }, [
        renderSlot(_ctx.$slots, "top"),
        createElementVNode("div", _hoisted_1$r, [
          renderSlot(_ctx.$slots, "default")
        ]),
        !$props.loading && $data.itemCount === 0 ? (openBlock(), createElementBlock("div", _hoisted_2$h, [
          renderSlot(_ctx.$slots, "empty", {}, () => [
            $props.emptyImage ? (openBlock(), createElementBlock("img", {
              key: 0,
              class: "ivu-notifications-tab-empty-img",
              src: $props.emptyImage
            }, null, 8, _hoisted_3$d)) : createCommentVNode("", true),
            createElementVNode("div", _hoisted_4$a, toDisplayString($props.emptyText), 1)
          ])
        ])) : createCommentVNode("", true),
        createElementVNode("div", _hoisted_5$6, [
          $props.loading ? (openBlock(), createElementBlock("div", _hoisted_6$4, [
            renderSlot(_ctx.$slots, "loading", {}, () => [
              createVNode(_component_Icon, {
                type: "ios-loading",
                class: "ivu-load-loop"
              }),
              createTextVNode(" " + toDisplayString($options.NotificationInstance.locale.loading), 1)
            ])
          ])) : !$props.loadedAll ? (openBlock(), createElementBlock("div", {
            key: 1,
            class: "ivu-notifications-tab-loading-item ivu-notifications-tab-loading-more",
            onClick: _cache[0] || (_cache[0] = (...args) => $options.handleLoadMore && $options.handleLoadMore(...args))
          }, [
            renderSlot(_ctx.$slots, "load-more", {}, () => [
              createTextVNode(toDisplayString($options.NotificationInstance.locale.loadMore), 1)
            ])
          ])) : $props.showLoadedAll && $props.loadedAll ? (openBlock(), createElementBlock("div", _hoisted_7$3, [
            renderSlot(_ctx.$slots, "loaded-all", {}, () => [
              createTextVNode(toDisplayString($options.NotificationInstance.locale.loadedAll), 1)
            ])
          ])) : createCommentVNode("", true)
        ])
      ], 544),
      $props.showClear && $data.itemCount !== 0 ? (openBlock(), createElementBlock("div", {
        key: 0,
        class: "ivu-notifications-tab-clear",
        onClick: _cache[2] || (_cache[2] = (...args) => $options.handleClear && $options.handleClear(...args))
      }, [
        renderSlot(_ctx.$slots, "clear", {}, () => [
          $props.showClearIcon ? (openBlock(), createBlock(_component_Icon, {
            key: 0,
            type: "md-done-all"
          })) : createCommentVNode("", true),
          createElementVNode("span", null, toDisplayString($options.NotificationInstance.locale.clear) + toDisplayString($props.title), 1)
        ])
      ])) : createCommentVNode("", true)
    ]),
    _: 3
  }, 8, ["label", "name"]);
}
var NotificationTab = /* @__PURE__ */ _export_sfc(_sfc_main$S, [["render", _sfc_render$J]]);
const _sfc_main$R = {
  name: "Trend",
  components: { Icon },
  props: {
    flag: {
      validator(value) {
        return oneOf(value, ["up", "down"]);
      }
    },
    colorful: {
      type: Boolean,
      default: true
    },
    reverseColor: {
      type: Boolean,
      default: false
    },
    textColor: {
      type: Boolean,
      default: false
    },
    showTitle: {
      type: [Boolean, String],
      default: false
    }
  },
  computed: {
    classes() {
      return [
        {
          ["ivu-trend-up"]: this.flag === "up",
          ["ivu-trend-down"]: this.flag === "down",
          ["ivu-trend-reverse-color"]: this.reverseColor,
          ["ivu-trend-colorful"]: this.colorful,
          ["ivu-trend-text-color"]: this.textColor
        }
      ];
    },
    flagType() {
      return this.flag === "up" ? "md-arrow-dropup" : this.flag === "down" ? "md-arrow-dropdown" : "";
    }
  }
};
const _hoisted_1$q = { class: "ivu-trend-text" };
function _sfc_render$I(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = resolveComponent("Icon");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(["ivu-trend", $options.classes])
  }, [
    createElementVNode("span", _hoisted_1$q, [
      renderSlot(_ctx.$slots, "default")
    ]),
    createVNode(_component_Icon, {
      type: $options.flagType,
      class: "ivu-trend-flag"
    }, null, 8, ["type"])
  ], 2);
}
var Trend = /* @__PURE__ */ _export_sfc(_sfc_main$R, [["render", _sfc_render$I]]);
const _sfc_main$Q = {
  name: "NumberInfo",
  components: { Trend },
  props: {
    title: {
      type: String
    },
    subTitle: {
      type: String
    },
    total: {
      type: [String, Number]
    },
    subTotal: {
      type: [String, Number]
    },
    status: {
      validator(value) {
        return oneOf(value, ["up", "down"]);
      }
    },
    gap: {
      type: [String, Number],
      default: 8
    }
  },
  computed: {
    valueStyle() {
      return {
        "margin-top": this.gap + "px"
      };
    }
  }
};
const _hoisted_1$p = { class: "ivu-number-info" };
const _hoisted_2$g = {
  key: 0,
  class: "ivu-number-info-title"
};
const _hoisted_3$c = {
  key: 1,
  class: "ivu-number-info-subTitle"
};
const _hoisted_4$9 = { class: "ivu-number-info-total" };
const _hoisted_5$5 = {
  key: 0,
  class: "ivu-number-info-subTotal"
};
function _sfc_render$H(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Trend = resolveComponent("Trend");
  return openBlock(), createElementBlock("div", _hoisted_1$p, [
    $props.title || _ctx.$slots.title ? (openBlock(), createElementBlock("div", _hoisted_2$g, [
      renderSlot(_ctx.$slots, "title", {}, () => [
        createTextVNode(toDisplayString($props.title), 1)
      ])
    ])) : createCommentVNode("", true),
    $props.subTitle || _ctx.$slots.subTitle ? (openBlock(), createElementBlock("div", _hoisted_3$c, [
      renderSlot(_ctx.$slots, "subTitle", {}, () => [
        createTextVNode(toDisplayString($props.subTitle), 1)
      ])
    ])) : createCommentVNode("", true),
    createElementVNode("div", {
      class: "ivu-number-info-value",
      style: normalizeStyle($options.valueStyle)
    }, [
      createElementVNode("span", _hoisted_4$9, [
        renderSlot(_ctx.$slots, "total", {}, () => [
          createTextVNode(toDisplayString($props.total), 1)
        ])
      ]),
      $props.subTotal || _ctx.$slots.subTotal ? (openBlock(), createElementBlock("span", _hoisted_5$5, [
        renderSlot(_ctx.$slots, "subTotal", {}, () => [
          createVNode(_component_Trend, { flag: $props.status }, {
            default: withCtx(() => [
              createTextVNode(toDisplayString($props.subTotal), 1)
            ]),
            _: 1
          }, 8, ["flag"])
        ])
      ])) : createCommentVNode("", true)
    ], 4)
  ]);
}
var NumberInfo = /* @__PURE__ */ _export_sfc(_sfc_main$Q, [["render", _sfc_render$H]]);
var numeral = { exports: {} };
/*! @preserve
 * numeral.js
 * version : 2.0.6
 * author : Adam Draper
 * license : MIT
 * http://adamwdraper.github.com/Numeral-js/
 */
(function(module) {
  (function(global2, factory) {
    if (module.exports) {
      module.exports = factory();
    } else {
      global2.numeral = factory();
    }
  })(commonjsGlobal, function() {
    var numeral2, _, VERSION = "2.0.6", formats = {}, locales = {}, defaults2 = {
      currentLocale: "en",
      zeroFormat: null,
      nullFormat: null,
      defaultFormat: "0,0",
      scalePercentBy100: true
    }, options = {
      currentLocale: defaults2.currentLocale,
      zeroFormat: defaults2.zeroFormat,
      nullFormat: defaults2.nullFormat,
      defaultFormat: defaults2.defaultFormat,
      scalePercentBy100: defaults2.scalePercentBy100
    };
    function Numeral2(input, number3) {
      this._input = input;
      this._value = number3;
    }
    numeral2 = function(input) {
      var value, kind, unformatFunction, regexp3;
      if (numeral2.isNumeral(input)) {
        value = input.value();
      } else if (input === 0 || typeof input === "undefined") {
        value = 0;
      } else if (input === null || _.isNaN(input)) {
        value = null;
      } else if (typeof input === "string") {
        if (options.zeroFormat && input === options.zeroFormat) {
          value = 0;
        } else if (options.nullFormat && input === options.nullFormat || !input.replace(/[^0-9]+/g, "").length) {
          value = null;
        } else {
          for (kind in formats) {
            regexp3 = typeof formats[kind].regexps.unformat === "function" ? formats[kind].regexps.unformat() : formats[kind].regexps.unformat;
            if (regexp3 && input.match(regexp3)) {
              unformatFunction = formats[kind].unformat;
              break;
            }
          }
          unformatFunction = unformatFunction || numeral2._.stringToNumber;
          value = unformatFunction(input);
        }
      } else {
        value = Number(input) || null;
      }
      return new Numeral2(input, value);
    };
    numeral2.version = VERSION;
    numeral2.isNumeral = function(obj) {
      return obj instanceof Numeral2;
    };
    numeral2._ = _ = {
      numberToFormat: function(value, format2, roundingFunction) {
        var locale2 = locales[numeral2.options.currentLocale], negP = false, optDec = false, leadingCount = 0, abbr = "", trillion = 1e12, billion = 1e9, million = 1e6, thousand = 1e3, decimal = "", neg = false, abbrForce, abs, int, precision, signed, thousands, output;
        value = value || 0;
        abs = Math.abs(value);
        if (numeral2._.includes(format2, "(")) {
          negP = true;
          format2 = format2.replace(/[\(|\)]/g, "");
        } else if (numeral2._.includes(format2, "+") || numeral2._.includes(format2, "-")) {
          signed = numeral2._.includes(format2, "+") ? format2.indexOf("+") : value < 0 ? format2.indexOf("-") : -1;
          format2 = format2.replace(/[\+|\-]/g, "");
        }
        if (numeral2._.includes(format2, "a")) {
          abbrForce = format2.match(/a(k|m|b|t)?/);
          abbrForce = abbrForce ? abbrForce[1] : false;
          if (numeral2._.includes(format2, " a")) {
            abbr = " ";
          }
          format2 = format2.replace(new RegExp(abbr + "a[kmbt]?"), "");
          if (abs >= trillion && !abbrForce || abbrForce === "t") {
            abbr += locale2.abbreviations.trillion;
            value = value / trillion;
          } else if (abs < trillion && abs >= billion && !abbrForce || abbrForce === "b") {
            abbr += locale2.abbreviations.billion;
            value = value / billion;
          } else if (abs < billion && abs >= million && !abbrForce || abbrForce === "m") {
            abbr += locale2.abbreviations.million;
            value = value / million;
          } else if (abs < million && abs >= thousand && !abbrForce || abbrForce === "k") {
            abbr += locale2.abbreviations.thousand;
            value = value / thousand;
          }
        }
        if (numeral2._.includes(format2, "[.]")) {
          optDec = true;
          format2 = format2.replace("[.]", ".");
        }
        int = value.toString().split(".")[0];
        precision = format2.split(".")[1];
        thousands = format2.indexOf(",");
        leadingCount = (format2.split(".")[0].split(",")[0].match(/0/g) || []).length;
        if (precision) {
          if (numeral2._.includes(precision, "[")) {
            precision = precision.replace("]", "");
            precision = precision.split("[");
            decimal = numeral2._.toFixed(value, precision[0].length + precision[1].length, roundingFunction, precision[1].length);
          } else {
            decimal = numeral2._.toFixed(value, precision.length, roundingFunction);
          }
          int = decimal.split(".")[0];
          if (numeral2._.includes(decimal, ".")) {
            decimal = locale2.delimiters.decimal + decimal.split(".")[1];
          } else {
            decimal = "";
          }
          if (optDec && Number(decimal.slice(1)) === 0) {
            decimal = "";
          }
        } else {
          int = numeral2._.toFixed(value, 0, roundingFunction);
        }
        if (abbr && !abbrForce && Number(int) >= 1e3 && abbr !== locale2.abbreviations.trillion) {
          int = String(Number(int) / 1e3);
          switch (abbr) {
            case locale2.abbreviations.thousand:
              abbr = locale2.abbreviations.million;
              break;
            case locale2.abbreviations.million:
              abbr = locale2.abbreviations.billion;
              break;
            case locale2.abbreviations.billion:
              abbr = locale2.abbreviations.trillion;
              break;
          }
        }
        if (numeral2._.includes(int, "-")) {
          int = int.slice(1);
          neg = true;
        }
        if (int.length < leadingCount) {
          for (var i = leadingCount - int.length; i > 0; i--) {
            int = "0" + int;
          }
        }
        if (thousands > -1) {
          int = int.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g, "$1" + locale2.delimiters.thousands);
        }
        if (format2.indexOf(".") === 0) {
          int = "";
        }
        output = int + decimal + (abbr ? abbr : "");
        if (negP) {
          output = (negP && neg ? "(" : "") + output + (negP && neg ? ")" : "");
        } else {
          if (signed >= 0) {
            output = signed === 0 ? (neg ? "-" : "+") + output : output + (neg ? "-" : "+");
          } else if (neg) {
            output = "-" + output;
          }
        }
        return output;
      },
      stringToNumber: function(string2) {
        var locale2 = locales[options.currentLocale], stringOriginal = string2, abbreviations = {
          thousand: 3,
          million: 6,
          billion: 9,
          trillion: 12
        }, abbreviation, value, regexp3;
        if (options.zeroFormat && string2 === options.zeroFormat) {
          value = 0;
        } else if (options.nullFormat && string2 === options.nullFormat || !string2.replace(/[^0-9]+/g, "").length) {
          value = null;
        } else {
          value = 1;
          if (locale2.delimiters.decimal !== ".") {
            string2 = string2.replace(/\./g, "").replace(locale2.delimiters.decimal, ".");
          }
          for (abbreviation in abbreviations) {
            regexp3 = new RegExp("[^a-zA-Z]" + locale2.abbreviations[abbreviation] + "(?:\\)|(\\" + locale2.currency.symbol + ")?(?:\\))?)?$");
            if (stringOriginal.match(regexp3)) {
              value *= Math.pow(10, abbreviations[abbreviation]);
              break;
            }
          }
          value *= (string2.split("-").length + Math.min(string2.split("(").length - 1, string2.split(")").length - 1)) % 2 ? 1 : -1;
          string2 = string2.replace(/[^0-9\.]+/g, "");
          value *= Number(string2);
        }
        return value;
      },
      isNaN: function(value) {
        return typeof value === "number" && isNaN(value);
      },
      includes: function(string2, search) {
        return string2.indexOf(search) !== -1;
      },
      insert: function(string2, subString, start) {
        return string2.slice(0, start) + subString + string2.slice(start);
      },
      reduce: function(array3, callback) {
        if (this === null) {
          throw new TypeError("Array.prototype.reduce called on null or undefined");
        }
        if (typeof callback !== "function") {
          throw new TypeError(callback + " is not a function");
        }
        var t2 = Object(array3), len = t2.length >>> 0, k = 0, value;
        if (arguments.length === 3) {
          value = arguments[2];
        } else {
          while (k < len && !(k in t2)) {
            k++;
          }
          if (k >= len) {
            throw new TypeError("Reduce of empty array with no initial value");
          }
          value = t2[k++];
        }
        for (; k < len; k++) {
          if (k in t2) {
            value = callback(value, t2[k], k, t2);
          }
        }
        return value;
      },
      multiplier: function(x) {
        var parts = x.toString().split(".");
        return parts.length < 2 ? 1 : Math.pow(10, parts[1].length);
      },
      correctionFactor: function() {
        var args = Array.prototype.slice.call(arguments);
        return args.reduce(function(accum, next) {
          var mn = _.multiplier(next);
          return accum > mn ? accum : mn;
        }, 1);
      },
      toFixed: function(value, maxDecimals, roundingFunction, optionals) {
        var splitValue = value.toString().split("."), minDecimals = maxDecimals - (optionals || 0), boundedPrecision, optionalsRegExp, power, output;
        if (splitValue.length === 2) {
          boundedPrecision = Math.min(Math.max(splitValue[1].length, minDecimals), maxDecimals);
        } else {
          boundedPrecision = minDecimals;
        }
        power = Math.pow(10, boundedPrecision);
        output = (roundingFunction(value + "e+" + boundedPrecision) / power).toFixed(boundedPrecision);
        if (optionals > maxDecimals - boundedPrecision) {
          optionalsRegExp = new RegExp("\\.?0{1," + (optionals - (maxDecimals - boundedPrecision)) + "}$");
          output = output.replace(optionalsRegExp, "");
        }
        return output;
      }
    };
    numeral2.options = options;
    numeral2.formats = formats;
    numeral2.locales = locales;
    numeral2.locale = function(key2) {
      if (key2) {
        options.currentLocale = key2.toLowerCase();
      }
      return options.currentLocale;
    };
    numeral2.localeData = function(key2) {
      if (!key2) {
        return locales[options.currentLocale];
      }
      key2 = key2.toLowerCase();
      if (!locales[key2]) {
        throw new Error("Unknown locale : " + key2);
      }
      return locales[key2];
    };
    numeral2.reset = function() {
      for (var property in defaults2) {
        options[property] = defaults2[property];
      }
    };
    numeral2.zeroFormat = function(format2) {
      options.zeroFormat = typeof format2 === "string" ? format2 : null;
    };
    numeral2.nullFormat = function(format2) {
      options.nullFormat = typeof format2 === "string" ? format2 : null;
    };
    numeral2.defaultFormat = function(format2) {
      options.defaultFormat = typeof format2 === "string" ? format2 : "0.0";
    };
    numeral2.register = function(type2, name2, format2) {
      name2 = name2.toLowerCase();
      if (this[type2 + "s"][name2]) {
        throw new TypeError(name2 + " " + type2 + " already registered.");
      }
      this[type2 + "s"][name2] = format2;
      return format2;
    };
    numeral2.validate = function(val, culture) {
      var _decimalSep, _thousandSep, _currSymbol, _valArray, _abbrObj, _thousandRegEx, localeData, temp;
      if (typeof val !== "string") {
        val += "";
        if (console.warn) {
          console.warn("Numeral.js: Value is not string. It has been co-erced to: ", val);
        }
      }
      val = val.trim();
      if (!!val.match(/^\d+$/)) {
        return true;
      }
      if (val === "") {
        return false;
      }
      try {
        localeData = numeral2.localeData(culture);
      } catch (e) {
        localeData = numeral2.localeData(numeral2.locale());
      }
      _currSymbol = localeData.currency.symbol;
      _abbrObj = localeData.abbreviations;
      _decimalSep = localeData.delimiters.decimal;
      if (localeData.delimiters.thousands === ".") {
        _thousandSep = "\\.";
      } else {
        _thousandSep = localeData.delimiters.thousands;
      }
      temp = val.match(/^[^\d]+/);
      if (temp !== null) {
        val = val.substr(1);
        if (temp[0] !== _currSymbol) {
          return false;
        }
      }
      temp = val.match(/[^\d]+$/);
      if (temp !== null) {
        val = val.slice(0, -1);
        if (temp[0] !== _abbrObj.thousand && temp[0] !== _abbrObj.million && temp[0] !== _abbrObj.billion && temp[0] !== _abbrObj.trillion) {
          return false;
        }
      }
      _thousandRegEx = new RegExp(_thousandSep + "{2}");
      if (!val.match(/[^\d.,]/g)) {
        _valArray = val.split(_decimalSep);
        if (_valArray.length > 2) {
          return false;
        } else {
          if (_valArray.length < 2) {
            return !!_valArray[0].match(/^\d+.*\d$/) && !_valArray[0].match(_thousandRegEx);
          } else {
            if (_valArray[0].length === 1) {
              return !!_valArray[0].match(/^\d+$/) && !_valArray[0].match(_thousandRegEx) && !!_valArray[1].match(/^\d+$/);
            } else {
              return !!_valArray[0].match(/^\d+.*\d$/) && !_valArray[0].match(_thousandRegEx) && !!_valArray[1].match(/^\d+$/);
            }
          }
        }
      }
      return false;
    };
    numeral2.fn = Numeral2.prototype = {
      clone: function() {
        return numeral2(this);
      },
      format: function(inputString, roundingFunction) {
        var value = this._value, format2 = inputString || options.defaultFormat, kind, output, formatFunction;
        roundingFunction = roundingFunction || Math.round;
        if (value === 0 && options.zeroFormat !== null) {
          output = options.zeroFormat;
        } else if (value === null && options.nullFormat !== null) {
          output = options.nullFormat;
        } else {
          for (kind in formats) {
            if (format2.match(formats[kind].regexps.format)) {
              formatFunction = formats[kind].format;
              break;
            }
          }
          formatFunction = formatFunction || numeral2._.numberToFormat;
          output = formatFunction(value, format2, roundingFunction);
        }
        return output;
      },
      value: function() {
        return this._value;
      },
      input: function() {
        return this._input;
      },
      set: function(value) {
        this._value = Number(value);
        return this;
      },
      add: function(value) {
        var corrFactor = _.correctionFactor.call(null, this._value, value);
        function cback(accum, curr, currI, O) {
          return accum + Math.round(corrFactor * curr);
        }
        this._value = _.reduce([this._value, value], cback, 0) / corrFactor;
        return this;
      },
      subtract: function(value) {
        var corrFactor = _.correctionFactor.call(null, this._value, value);
        function cback(accum, curr, currI, O) {
          return accum - Math.round(corrFactor * curr);
        }
        this._value = _.reduce([value], cback, Math.round(this._value * corrFactor)) / corrFactor;
        return this;
      },
      multiply: function(value) {
        function cback(accum, curr, currI, O) {
          var corrFactor = _.correctionFactor(accum, curr);
          return Math.round(accum * corrFactor) * Math.round(curr * corrFactor) / Math.round(corrFactor * corrFactor);
        }
        this._value = _.reduce([this._value, value], cback, 1);
        return this;
      },
      divide: function(value) {
        function cback(accum, curr, currI, O) {
          var corrFactor = _.correctionFactor(accum, curr);
          return Math.round(accum * corrFactor) / Math.round(curr * corrFactor);
        }
        this._value = _.reduce([this._value, value], cback);
        return this;
      },
      difference: function(value) {
        return Math.abs(numeral2(this._value).subtract(value).value());
      }
    };
    numeral2.register("locale", "en", {
      delimiters: {
        thousands: ",",
        decimal: "."
      },
      abbreviations: {
        thousand: "k",
        million: "m",
        billion: "b",
        trillion: "t"
      },
      ordinal: function(number3) {
        var b = number3 % 10;
        return ~~(number3 % 100 / 10) === 1 ? "th" : b === 1 ? "st" : b === 2 ? "nd" : b === 3 ? "rd" : "th";
      },
      currency: {
        symbol: "$"
      }
    });
    (function() {
      numeral2.register("format", "bps", {
        regexps: {
          format: /(BPS)/,
          unformat: /(BPS)/
        },
        format: function(value, format2, roundingFunction) {
          var space = numeral2._.includes(format2, " BPS") ? " " : "", output;
          value = value * 1e4;
          format2 = format2.replace(/\s?BPS/, "");
          output = numeral2._.numberToFormat(value, format2, roundingFunction);
          if (numeral2._.includes(output, ")")) {
            output = output.split("");
            output.splice(-1, 0, space + "BPS");
            output = output.join("");
          } else {
            output = output + space + "BPS";
          }
          return output;
        },
        unformat: function(string2) {
          return +(numeral2._.stringToNumber(string2) * 1e-4).toFixed(15);
        }
      });
    })();
    (function() {
      var decimal = {
        base: 1e3,
        suffixes: ["B", "KB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"]
      }, binary = {
        base: 1024,
        suffixes: ["B", "KiB", "MiB", "GiB", "TiB", "PiB", "EiB", "ZiB", "YiB"]
      };
      var allSuffixes = decimal.suffixes.concat(binary.suffixes.filter(function(item) {
        return decimal.suffixes.indexOf(item) < 0;
      }));
      var unformatRegex = allSuffixes.join("|");
      unformatRegex = "(" + unformatRegex.replace("B", "B(?!PS)") + ")";
      numeral2.register("format", "bytes", {
        regexps: {
          format: /([0\s]i?b)/,
          unformat: new RegExp(unformatRegex)
        },
        format: function(value, format2, roundingFunction) {
          var output, bytes = numeral2._.includes(format2, "ib") ? binary : decimal, suffix = numeral2._.includes(format2, " b") || numeral2._.includes(format2, " ib") ? " " : "", power, min, max;
          format2 = format2.replace(/\s?i?b/, "");
          for (power = 0; power <= bytes.suffixes.length; power++) {
            min = Math.pow(bytes.base, power);
            max = Math.pow(bytes.base, power + 1);
            if (value === null || value === 0 || value >= min && value < max) {
              suffix += bytes.suffixes[power];
              if (min > 0) {
                value = value / min;
              }
              break;
            }
          }
          output = numeral2._.numberToFormat(value, format2, roundingFunction);
          return output + suffix;
        },
        unformat: function(string2) {
          var value = numeral2._.stringToNumber(string2), power, bytesMultiplier;
          if (value) {
            for (power = decimal.suffixes.length - 1; power >= 0; power--) {
              if (numeral2._.includes(string2, decimal.suffixes[power])) {
                bytesMultiplier = Math.pow(decimal.base, power);
                break;
              }
              if (numeral2._.includes(string2, binary.suffixes[power])) {
                bytesMultiplier = Math.pow(binary.base, power);
                break;
              }
            }
            value *= bytesMultiplier || 1;
          }
          return value;
        }
      });
    })();
    (function() {
      numeral2.register("format", "currency", {
        regexps: {
          format: /(\$)/
        },
        format: function(value, format2, roundingFunction) {
          var locale2 = numeral2.locales[numeral2.options.currentLocale], symbols = {
            before: format2.match(/^([\+|\-|\(|\s|\$]*)/)[0],
            after: format2.match(/([\+|\-|\)|\s|\$]*)$/)[0]
          }, output, symbol, i;
          format2 = format2.replace(/\s?\$\s?/, "");
          output = numeral2._.numberToFormat(value, format2, roundingFunction);
          if (value >= 0) {
            symbols.before = symbols.before.replace(/[\-\(]/, "");
            symbols.after = symbols.after.replace(/[\-\)]/, "");
          } else if (value < 0 && (!numeral2._.includes(symbols.before, "-") && !numeral2._.includes(symbols.before, "("))) {
            symbols.before = "-" + symbols.before;
          }
          for (i = 0; i < symbols.before.length; i++) {
            symbol = symbols.before[i];
            switch (symbol) {
              case "$":
                output = numeral2._.insert(output, locale2.currency.symbol, i);
                break;
              case " ":
                output = numeral2._.insert(output, " ", i + locale2.currency.symbol.length - 1);
                break;
            }
          }
          for (i = symbols.after.length - 1; i >= 0; i--) {
            symbol = symbols.after[i];
            switch (symbol) {
              case "$":
                output = i === symbols.after.length - 1 ? output + locale2.currency.symbol : numeral2._.insert(output, locale2.currency.symbol, -(symbols.after.length - (1 + i)));
                break;
              case " ":
                output = i === symbols.after.length - 1 ? output + " " : numeral2._.insert(output, " ", -(symbols.after.length - (1 + i) + locale2.currency.symbol.length - 1));
                break;
            }
          }
          return output;
        }
      });
    })();
    (function() {
      numeral2.register("format", "exponential", {
        regexps: {
          format: /(e\+|e-)/,
          unformat: /(e\+|e-)/
        },
        format: function(value, format2, roundingFunction) {
          var output, exponential = typeof value === "number" && !numeral2._.isNaN(value) ? value.toExponential() : "0e+0", parts = exponential.split("e");
          format2 = format2.replace(/e[\+|\-]{1}0/, "");
          output = numeral2._.numberToFormat(Number(parts[0]), format2, roundingFunction);
          return output + "e" + parts[1];
        },
        unformat: function(string2) {
          var parts = numeral2._.includes(string2, "e+") ? string2.split("e+") : string2.split("e-"), value = Number(parts[0]), power = Number(parts[1]);
          power = numeral2._.includes(string2, "e-") ? power *= -1 : power;
          function cback(accum, curr, currI, O) {
            var corrFactor = numeral2._.correctionFactor(accum, curr), num = accum * corrFactor * (curr * corrFactor) / (corrFactor * corrFactor);
            return num;
          }
          return numeral2._.reduce([value, Math.pow(10, power)], cback, 1);
        }
      });
    })();
    (function() {
      numeral2.register("format", "ordinal", {
        regexps: {
          format: /(o)/
        },
        format: function(value, format2, roundingFunction) {
          var locale2 = numeral2.locales[numeral2.options.currentLocale], output, ordinal = numeral2._.includes(format2, " o") ? " " : "";
          format2 = format2.replace(/\s?o/, "");
          ordinal += locale2.ordinal(value);
          output = numeral2._.numberToFormat(value, format2, roundingFunction);
          return output + ordinal;
        }
      });
    })();
    (function() {
      numeral2.register("format", "percentage", {
        regexps: {
          format: /(%)/,
          unformat: /(%)/
        },
        format: function(value, format2, roundingFunction) {
          var space = numeral2._.includes(format2, " %") ? " " : "", output;
          if (numeral2.options.scalePercentBy100) {
            value = value * 100;
          }
          format2 = format2.replace(/\s?\%/, "");
          output = numeral2._.numberToFormat(value, format2, roundingFunction);
          if (numeral2._.includes(output, ")")) {
            output = output.split("");
            output.splice(-1, 0, space + "%");
            output = output.join("");
          } else {
            output = output + space + "%";
          }
          return output;
        },
        unformat: function(string2) {
          var number3 = numeral2._.stringToNumber(string2);
          if (numeral2.options.scalePercentBy100) {
            return number3 * 0.01;
          }
          return number3;
        }
      });
    })();
    (function() {
      numeral2.register("format", "time", {
        regexps: {
          format: /(:)/,
          unformat: /(:)/
        },
        format: function(value, format2, roundingFunction) {
          var hours = Math.floor(value / 60 / 60), minutes = Math.floor((value - hours * 60 * 60) / 60), seconds = Math.round(value - hours * 60 * 60 - minutes * 60);
          return hours + ":" + (minutes < 10 ? "0" + minutes : minutes) + ":" + (seconds < 10 ? "0" + seconds : seconds);
        },
        unformat: function(string2) {
          var timeArray = string2.split(":"), seconds = 0;
          if (timeArray.length === 3) {
            seconds = seconds + Number(timeArray[0]) * 60 * 60;
            seconds = seconds + Number(timeArray[1]) * 60;
            seconds = seconds + Number(timeArray[2]);
          } else if (timeArray.length === 2) {
            seconds = seconds + Number(timeArray[0]) * 60;
            seconds = seconds + Number(timeArray[1]);
          }
          return Number(seconds);
        }
      });
    })();
    return numeral2;
  });
})(numeral);
var Numeral$1 = numeral.exports;
const _sfc_main$P = {
  name: "Numeral",
  emits: ["on-change"],
  props: {
    value: {
      type: [String, Number]
    },
    format: {
      type: String
    },
    prefix: {
      type: [String, Number]
    },
    suffix: {
      type: [String, Number]
    }
  },
  data() {
    return {
      currentValue: ""
    };
  },
  watch: {
    value() {
      this.init();
    },
    format() {
      this.init();
    }
  },
  methods: {
    init() {
      if (this.value !== void 0) {
        const num = Numeral$1(this.value);
        if (this.format) {
          this.currentValue = num.format(this.format);
        } else {
          this.currentValue = num.value();
        }
        this.$emit("on-change", this.currentValue);
      }
    },
    getValue() {
      return this.currentValue;
    }
  },
  mounted() {
    this.init();
  }
};
const _hoisted_1$o = { class: "ivu-numeral" };
function _sfc_render$G(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("span", _hoisted_1$o, [
    renderSlot(_ctx.$slots, "prefix", {}, () => [
      createTextVNode(toDisplayString($props.prefix), 1)
    ]),
    createTextVNode(toDisplayString($data.currentValue), 1),
    renderSlot(_ctx.$slots, "suffix", {}, () => [
      createTextVNode(toDisplayString($props.suffix), 1)
    ])
  ]);
}
var Numeral = /* @__PURE__ */ _export_sfc(_sfc_main$P, [["render", _sfc_render$G]]);
const prefixCls$o = "ivu-select-group";
const _sfc_main$O = {
  name: "OptionGroup",
  props: {
    label: {
      type: String,
      default: ""
    }
  },
  provide() {
    return {
      OptionGroupInstance: this
    };
  },
  inject: ["SelectInstance"],
  data() {
    return {
      prefixCls: prefixCls$o,
      hidden: false,
      id: random(6),
      optionList: []
    };
  },
  computed: {
    show() {
      return this.optionList.find((item) => item.proxy && item.proxy.isShow);
    }
  }
};
function _sfc_render$F(_ctx, _cache, $props, $setup, $data, $options) {
  return withDirectives((openBlock(), createElementBlock("li", {
    class: normalizeClass([$data.prefixCls + "-wrap"])
  }, [
    createElementVNode("div", {
      class: normalizeClass([$data.prefixCls + "-title"])
    }, toDisplayString($props.label), 3),
    createElementVNode("ul", null, [
      createElementVNode("li", {
        class: normalizeClass([$data.prefixCls]),
        ref: "options"
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 2)
    ])
  ], 2)), [
    [vShow, $options.show]
  ]);
}
var OptionGroup = /* @__PURE__ */ _export_sfc(_sfc_main$O, [["render", _sfc_render$F]]);
const prefixCls$n = "ivu-page";
function isValueNumber(value) {
  return /^[1-9][0-9]*$/.test(value + "");
}
const _sfc_main$N = {
  name: "PageOption",
  mixins: [Locale],
  components: { iSelect: Select, iOption },
  emits: ["on-size", "on-page"],
  props: {
    pageSizeOpts: Array,
    showSizer: Boolean,
    showElevator: Boolean,
    current: Number,
    _current: Number,
    pageSize: Number,
    allPages: Number,
    isSmall: Boolean,
    placement: String,
    transfer: Boolean,
    disabled: Boolean,
    eventsEnabled: Boolean
  },
  data() {
    return {
      currentPageSize: this.pageSize
    };
  },
  watch: {
    pageSize(val) {
      this.currentPageSize = val;
    }
  },
  computed: {
    size() {
      return this.isSmall ? "small" : "default";
    },
    optsClasses() {
      return [
        `${prefixCls$n}-options`
      ];
    },
    sizerClasses() {
      return [
        `${prefixCls$n}-options-sizer`
      ];
    },
    ElevatorClasses() {
      return [
        `${prefixCls$n}-options-elevator`
      ];
    }
  },
  methods: {
    changeSize() {
      this.$emit("on-size", this.currentPageSize);
    },
    changePage(event) {
      let val = event.target.value.trim();
      let page = 0;
      if (isValueNumber(val)) {
        val = Number(val);
        if (val != this.current) {
          const allPages = this.allPages;
          if (val > allPages) {
            page = allPages;
          } else {
            page = val;
          }
        }
      } else {
        page = 1;
      }
      if (page) {
        this.$emit("on-page", page);
        event.target.value = page;
      }
    }
  }
};
const _hoisted_1$n = ["value", "disabled"];
function _sfc_render$E(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_i_option = resolveComponent("i-option");
  const _component_i_select = resolveComponent("i-select");
  return $props.showSizer || $props.showElevator ? (openBlock(), createElementBlock("div", {
    key: 0,
    class: normalizeClass($options.optsClasses)
  }, [
    $props.showSizer ? (openBlock(), createElementBlock("div", {
      key: 0,
      class: normalizeClass($options.sizerClasses)
    }, [
      createVNode(_component_i_select, {
        modelValue: $data.currentPageSize,
        "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => $data.currentPageSize = $event),
        size: $options.size,
        placement: $props.placement,
        transfer: $props.transfer,
        disabled: $props.disabled,
        eventsEnabled: $props.eventsEnabled,
        onOnChange: $options.changeSize
      }, {
        default: withCtx(() => [
          (openBlock(true), createElementBlock(Fragment, null, renderList($props.pageSizeOpts, (item) => {
            return openBlock(), createBlock(_component_i_option, {
              key: item,
              value: item,
              style: { "text-align": "center" }
            }, {
              default: withCtx(() => [
                createTextVNode(toDisplayString(item) + " " + toDisplayString(_ctx.t("i.page.page")), 1)
              ]),
              _: 2
            }, 1032, ["value"]);
          }), 128))
        ]),
        _: 1
      }, 8, ["modelValue", "size", "placement", "transfer", "disabled", "eventsEnabled", "onOnChange"])
    ], 2)) : createCommentVNode("", true),
    $props.showElevator ? (openBlock(), createElementBlock("div", {
      key: 1,
      class: normalizeClass($options.ElevatorClasses)
    }, [
      createTextVNode(toDisplayString(_ctx.t("i.page.goto")) + " ", 1),
      createElementVNode("input", {
        type: "text",
        value: $props._current,
        autocomplete: "off",
        spellcheck: "false",
        disabled: $props.disabled,
        onKeyup: _cache[1] || (_cache[1] = withKeys((...args) => $options.changePage && $options.changePage(...args), ["enter"]))
      }, null, 40, _hoisted_1$n),
      createTextVNode(" " + toDisplayString(_ctx.t("i.page.p")), 1)
    ], 2)) : createCommentVNode("", true)
  ], 2)) : createCommentVNode("", true);
}
var Options = /* @__PURE__ */ _export_sfc(_sfc_main$N, [["render", _sfc_render$E]]);
const prefixCls$m = "ivu-page";
const _sfc_main$M = {
  name: "Page",
  mixins: [Locale],
  components: { Options },
  emits: ["update:modelValue", "on-change", "on-prev", "on-next", "on-page-size-change"],
  props: {
    modelValue: {
      type: Number,
      default: 1
    },
    total: {
      type: Number,
      default: 0
    },
    pageSize: {
      type: Number,
      default: 10
    },
    pageSizeOpts: {
      type: Array,
      default() {
        return [10, 20, 30, 40];
      }
    },
    placement: {
      validator(value) {
        return oneOf(value, ["top", "bottom"]);
      },
      default: "bottom"
    },
    transfer: {
      type: Boolean,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.transfer === "" ? false : global2.$VIEWUI.transfer;
      }
    },
    size: {
      validator(value) {
        return oneOf(value, ["small", "default"]);
      }
    },
    simple: {
      type: Boolean,
      default: false
    },
    showTotal: {
      type: Boolean,
      default: false
    },
    showElevator: {
      type: Boolean,
      default: false
    },
    showSizer: {
      type: Boolean,
      default: false
    },
    className: {
      type: String
    },
    styles: {
      type: Object
    },
    prevText: {
      type: String,
      default: ""
    },
    nextText: {
      type: String,
      default: ""
    },
    disabled: {
      type: Boolean,
      default: false
    },
    eventsEnabled: {
      type: Boolean,
      default: false
    }
  },
  data() {
    return {
      prefixCls: prefixCls$m,
      currentPage: this.modelValue,
      currentPageSize: this.pageSize
    };
  },
  watch: {
    total(val) {
      let maxPage = Math.ceil(val / this.currentPageSize);
      if (maxPage < this.currentPage) {
        this.currentPage = maxPage === 0 ? 1 : maxPage;
      }
    },
    modelValue(val) {
      this.currentPage = val;
    },
    pageSize(val) {
      this.currentPageSize = val;
    }
  },
  computed: {
    isSmall() {
      return this.size === "small";
    },
    allPages() {
      const allPage = Math.ceil(this.total / this.currentPageSize);
      return allPage === 0 ? 1 : allPage;
    },
    simpleWrapClasses() {
      return [
        `${prefixCls$m}`,
        `${prefixCls$m}-simple`,
        {
          [`${this.className}`]: !!this.className
        }
      ];
    },
    simplePagerClasses() {
      return `${prefixCls$m}-simple-pager`;
    },
    wrapClasses() {
      return [
        `${prefixCls$m}`,
        {
          [`${this.className}`]: !!this.className,
          [`${prefixCls$m}-with-disabled`]: this.disabled,
          "mini": this.size === "small"
        }
      ];
    },
    prevClasses() {
      return [
        `${prefixCls$m}-prev`,
        {
          [`${prefixCls$m}-disabled`]: this.currentPage === 1 || this.disabled,
          [`${prefixCls$m}-custom-text`]: this.prevText !== ""
        }
      ];
    },
    nextClasses() {
      return [
        `${prefixCls$m}-next`,
        {
          [`${prefixCls$m}-disabled`]: this.currentPage === this.allPages || this.disabled,
          [`${prefixCls$m}-custom-text`]: this.nextText !== ""
        }
      ];
    },
    firstPageClasses() {
      return [
        `${prefixCls$m}-item`,
        {
          [`${prefixCls$m}-item-active`]: this.currentPage === 1
        }
      ];
    },
    lastPageClasses() {
      return [
        `${prefixCls$m}-item`,
        {
          [`${prefixCls$m}-item-active`]: this.currentPage === this.allPages
        }
      ];
    }
  },
  methods: {
    changePage(page) {
      if (this.disabled)
        return;
      if (this.currentPage != page) {
        this.currentPage = page;
        this.$emit("update:modelValue", page);
        this.$emit("on-change", page);
      }
    },
    prev() {
      if (this.disabled)
        return;
      const current = this.currentPage;
      if (current <= 1) {
        return false;
      }
      this.changePage(current - 1);
      this.$emit("on-prev", current - 1);
    },
    next() {
      if (this.disabled)
        return;
      const current = this.currentPage;
      if (current >= this.allPages) {
        return false;
      }
      this.changePage(current + 1);
      this.$emit("on-next", current + 1);
    },
    fastPrev() {
      if (this.disabled)
        return;
      const page = this.currentPage - 5;
      if (page > 0) {
        this.changePage(page);
      } else {
        this.changePage(1);
      }
    },
    fastNext() {
      if (this.disabled)
        return;
      const page = this.currentPage + 5;
      if (page > this.allPages) {
        this.changePage(this.allPages);
      } else {
        this.changePage(page);
      }
    },
    onSize(pageSize) {
      if (this.disabled)
        return;
      this.currentPageSize = pageSize;
      this.$emit("on-page-size-change", pageSize);
      this.changePage(1);
    },
    onPage(page) {
      if (this.disabled)
        return;
      this.changePage(page);
    },
    keyDown(e) {
      const key2 = e.keyCode;
      const condition = key2 >= 48 && key2 <= 57 || key2 >= 96 && key2 <= 105 || key2 === 8 || key2 === 37 || key2 === 39;
      if (!condition) {
        e.preventDefault();
      }
    },
    keyUp(e) {
      const key2 = e.keyCode;
      const val = parseInt(e.target.value);
      if (key2 === 38) {
        this.prev();
      } else if (key2 === 40) {
        this.next();
      } else if (key2 === 13) {
        let page = 1;
        if (val > this.allPages) {
          page = this.allPages;
        } else if (val <= 0 || !val) {
          page = 1;
        } else {
          page = val;
        }
        e.target.value = page;
        this.changePage(page);
      }
    }
  }
};
const _hoisted_1$m = ["title"];
const _hoisted_2$f = ["title"];
const _hoisted_3$b = ["value", "disabled"];
const _hoisted_4$8 = ["title"];
const _hoisted_5$4 = ["title"];
const _hoisted_6$3 = {
  key: 1,
  class: "ivu-icon ivu-icon-ios-arrow-back"
};
const _hoisted_7$2 = ["title"];
const _hoisted_8$2 = ["title"];
const _hoisted_9$2 = ["title"];
const _hoisted_10$2 = ["title"];
const _hoisted_11$2 = ["title"];
const _hoisted_12$1 = ["title"];
const _hoisted_13 = ["title"];
const _hoisted_14 = ["title"];
const _hoisted_15 = ["title"];
const _hoisted_16 = ["title"];
const _hoisted_17 = ["title"];
const _hoisted_18 = {
  key: 1,
  class: "ivu-icon ivu-icon-ios-arrow-forward"
};
function _sfc_render$D(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Options = resolveComponent("Options");
  return $props.simple ? (openBlock(), createElementBlock("ul", {
    key: 0,
    class: normalizeClass($options.simpleWrapClasses),
    style: normalizeStyle($props.styles)
  }, [
    createElementVNode("li", {
      title: _ctx.t("i.page.prev"),
      class: normalizeClass($options.prevClasses),
      onClick: _cache[0] || (_cache[0] = (...args) => $options.prev && $options.prev(...args))
    }, _cache[17] || (_cache[17] = [
      createElementVNode("a", null, [
        createElementVNode("i", { class: "ivu-icon ivu-icon-ios-arrow-back" })
      ], -1)
    ]), 10, _hoisted_1$m),
    createElementVNode("div", {
      class: normalizeClass($options.simplePagerClasses),
      title: $data.currentPage + "/" + $options.allPages
    }, [
      createElementVNode("input", {
        type: "text",
        value: $data.currentPage,
        autocomplete: "off",
        spellcheck: "false",
        disabled: $props.disabled,
        onKeydown: _cache[1] || (_cache[1] = (...args) => $options.keyDown && $options.keyDown(...args)),
        onKeyup: _cache[2] || (_cache[2] = (...args) => $options.keyUp && $options.keyUp(...args)),
        onChange: _cache[3] || (_cache[3] = (...args) => $options.keyUp && $options.keyUp(...args))
      }, null, 40, _hoisted_3$b),
      _cache[18] || (_cache[18] = createElementVNode("span", null, "/", -1)),
      createTextVNode(" " + toDisplayString($options.allPages), 1)
    ], 10, _hoisted_2$f),
    createElementVNode("li", {
      title: _ctx.t("i.page.next"),
      class: normalizeClass($options.nextClasses),
      onClick: _cache[4] || (_cache[4] = (...args) => $options.next && $options.next(...args))
    }, _cache[19] || (_cache[19] = [
      createElementVNode("a", null, [
        createElementVNode("i", { class: "ivu-icon ivu-icon-ios-arrow-forward" })
      ], -1)
    ]), 10, _hoisted_4$8)
  ], 6)) : (openBlock(), createElementBlock("ul", {
    key: 1,
    class: normalizeClass($options.wrapClasses),
    style: normalizeStyle($props.styles)
  }, [
    $props.showTotal ? (openBlock(), createElementBlock("span", {
      key: 0,
      class: normalizeClass([$data.prefixCls + "-total"])
    }, [
      renderSlot(_ctx.$slots, "default", {}, () => [
        createTextVNode(toDisplayString(_ctx.t("i.page.total")) + " " + toDisplayString($props.total) + " ", 1),
        $props.total <= 1 ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
          createTextVNode(toDisplayString(_ctx.t("i.page.item")), 1)
        ], 64)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
          createTextVNode(toDisplayString(_ctx.t("i.page.items")), 1)
        ], 64))
      ])
    ], 2)) : createCommentVNode("", true),
    createElementVNode("li", {
      title: _ctx.t("i.page.prev"),
      class: normalizeClass($options.prevClasses),
      onClick: _cache[5] || (_cache[5] = (...args) => $options.prev && $options.prev(...args))
    }, [
      createElementVNode("a", null, [
        $props.prevText !== "" ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
          createTextVNode(toDisplayString($props.prevText), 1)
        ], 64)) : (openBlock(), createElementBlock("i", _hoisted_6$3))
      ])
    ], 10, _hoisted_5$4),
    createElementVNode("li", {
      title: "1",
      class: normalizeClass($options.firstPageClasses),
      onClick: _cache[6] || (_cache[6] = ($event) => $options.changePage(1))
    }, _cache[20] || (_cache[20] = [
      createElementVNode("a", null, "1", -1)
    ]), 2),
    $data.currentPage > 5 ? (openBlock(), createElementBlock("li", {
      key: 1,
      title: _ctx.t("i.page.prev5"),
      class: normalizeClass([$data.prefixCls + "-item-jump-prev"]),
      onClick: _cache[7] || (_cache[7] = (...args) => $options.fastPrev && $options.fastPrev(...args))
    }, _cache[21] || (_cache[21] = [
      createElementVNode("a", null, [
        createElementVNode("i", { class: "ivu-icon ivu-icon-ios-arrow-back" }),
        createElementVNode("i", { class: "ivu-icon ivu-icon-ios-more" })
      ], -1)
    ]), 10, _hoisted_7$2)) : createCommentVNode("", true),
    $data.currentPage === 5 ? (openBlock(), createElementBlock("li", {
      key: 2,
      title: $data.currentPage - 3,
      class: normalizeClass([$data.prefixCls + "-item"]),
      onClick: _cache[8] || (_cache[8] = ($event) => $options.changePage($data.currentPage - 3))
    }, [
      createElementVNode("a", null, toDisplayString($data.currentPage - 3), 1)
    ], 10, _hoisted_8$2)) : createCommentVNode("", true),
    $data.currentPage - 2 > 1 ? (openBlock(), createElementBlock("li", {
      key: 3,
      title: $data.currentPage - 2,
      class: normalizeClass([$data.prefixCls + "-item"]),
      onClick: _cache[9] || (_cache[9] = ($event) => $options.changePage($data.currentPage - 2))
    }, [
      createElementVNode("a", null, toDisplayString($data.currentPage - 2), 1)
    ], 10, _hoisted_9$2)) : createCommentVNode("", true),
    $data.currentPage - 1 > 1 ? (openBlock(), createElementBlock("li", {
      key: 4,
      title: $data.currentPage - 1,
      class: normalizeClass([$data.prefixCls + "-item"]),
      onClick: _cache[10] || (_cache[10] = ($event) => $options.changePage($data.currentPage - 1))
    }, [
      createElementVNode("a", null, toDisplayString($data.currentPage - 1), 1)
    ], 10, _hoisted_10$2)) : createCommentVNode("", true),
    $data.currentPage != 1 && $data.currentPage != $options.allPages ? (openBlock(), createElementBlock("li", {
      key: 5,
      title: $data.currentPage,
      class: normalizeClass([$data.prefixCls + "-item", $data.prefixCls + "-item-active"])
    }, [
      createElementVNode("a", null, toDisplayString($data.currentPage), 1)
    ], 10, _hoisted_11$2)) : createCommentVNode("", true),
    $data.currentPage + 1 < $options.allPages ? (openBlock(), createElementBlock("li", {
      key: 6,
      title: $data.currentPage + 1,
      class: normalizeClass([$data.prefixCls + "-item"]),
      onClick: _cache[11] || (_cache[11] = ($event) => $options.changePage($data.currentPage + 1))
    }, [
      createElementVNode("a", null, toDisplayString($data.currentPage + 1), 1)
    ], 10, _hoisted_12$1)) : createCommentVNode("", true),
    $data.currentPage + 2 < $options.allPages ? (openBlock(), createElementBlock("li", {
      key: 7,
      title: $data.currentPage + 2,
      class: normalizeClass([$data.prefixCls + "-item"]),
      onClick: _cache[12] || (_cache[12] = ($event) => $options.changePage($data.currentPage + 2))
    }, [
      createElementVNode("a", null, toDisplayString($data.currentPage + 2), 1)
    ], 10, _hoisted_13)) : createCommentVNode("", true),
    $options.allPages - $data.currentPage === 4 ? (openBlock(), createElementBlock("li", {
      key: 8,
      title: $data.currentPage + 3,
      class: normalizeClass([$data.prefixCls + "-item"]),
      onClick: _cache[13] || (_cache[13] = ($event) => $options.changePage($data.currentPage + 3))
    }, [
      createElementVNode("a", null, toDisplayString($data.currentPage + 3), 1)
    ], 10, _hoisted_14)) : createCommentVNode("", true),
    $options.allPages - $data.currentPage >= 5 ? (openBlock(), createElementBlock("li", {
      key: 9,
      title: _ctx.t("i.page.next5"),
      class: normalizeClass([$data.prefixCls + "-item-jump-next"]),
      onClick: _cache[14] || (_cache[14] = (...args) => $options.fastNext && $options.fastNext(...args))
    }, _cache[22] || (_cache[22] = [
      createElementVNode("a", null, [
        createElementVNode("i", { class: "ivu-icon ivu-icon-ios-arrow-forward" }),
        createElementVNode("i", { class: "ivu-icon ivu-icon-ios-more" })
      ], -1)
    ]), 10, _hoisted_15)) : createCommentVNode("", true),
    $options.allPages > 1 ? (openBlock(), createElementBlock("li", {
      key: 10,
      title: $options.allPages,
      class: normalizeClass($options.lastPageClasses),
      onClick: _cache[15] || (_cache[15] = ($event) => $options.changePage($options.allPages))
    }, [
      createElementVNode("a", null, toDisplayString($options.allPages), 1)
    ], 10, _hoisted_16)) : createCommentVNode("", true),
    createElementVNode("li", {
      title: _ctx.t("i.page.next"),
      class: normalizeClass($options.nextClasses),
      onClick: _cache[16] || (_cache[16] = (...args) => $options.next && $options.next(...args))
    }, [
      createElementVNode("a", null, [
        $props.nextText !== "" ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
          createTextVNode(toDisplayString($props.nextText), 1)
        ], 64)) : (openBlock(), createElementBlock("i", _hoisted_18))
      ])
    ], 10, _hoisted_17),
    createVNode(_component_Options, {
      "show-sizer": $props.showSizer,
      "page-size": $data.currentPageSize,
      "page-size-opts": $props.pageSizeOpts,
      placement: $props.placement,
      transfer: $props.transfer,
      "show-elevator": $props.showElevator,
      _current: $data.currentPage,
      current: $data.currentPage,
      disabled: $props.disabled,
      "all-pages": $options.allPages,
      "is-small": $options.isSmall,
      eventsEnabled: $props.eventsEnabled,
      onOnSize: $options.onSize,
      onOnPage: $options.onPage
    }, null, 8, ["show-sizer", "page-size", "page-size-opts", "placement", "transfer", "show-elevator", "_current", "current", "disabled", "all-pages", "is-small", "eventsEnabled", "onOnSize", "onOnPage"])
  ], 6));
}
var Page = /* @__PURE__ */ _export_sfc(_sfc_main$M, [["render", _sfc_render$D]]);
const _sfc_main$L = {
  name: "PageHeader",
  components: { Breadcrumb, BreadcrumbItem, Divider, Icon, Tabs, TabPane },
  emits: ["on-tab-change", "on-back"],
  props: {
    title: {
      type: String
    },
    back: {
      type: Boolean,
      default: false
    },
    logo: {
      type: String
    },
    action: {
      type: String
    },
    content: {
      type: String
    },
    extra: {
      type: String
    },
    breadcrumbList: {
      type: Array
    },
    hiddenBreadcrumb: {
      type: Boolean,
      default: false
    },
    tabList: {
      type: Array
    },
    tabActiveKey: {
      type: String
    },
    wide: {
      type: Boolean,
      default: false
    }
  },
  computed: {
    classes() {
      return {
        "ivu-page-header-wide": this.wide
      };
    }
  },
  methods: {
    handleTabChange(name2) {
      const tab = this.tabList.find((item) => item.name === name2);
      this.$emit("on-tab-change", JSON.parse(JSON.stringify(tab)));
    },
    handleBack() {
      this.$emit("on-back");
    }
  }
};
const _hoisted_1$l = {
  key: 0,
  class: "ivu-page-header-breadcrumb"
};
const _hoisted_2$e = { class: "ivu-page-header-detail" };
const _hoisted_3$a = {
  key: 1,
  class: "ivu-page-header-logo"
};
const _hoisted_4$7 = ["src"];
const _hoisted_5$3 = { class: "ivu-page-header-main" };
const _hoisted_6$2 = { class: "ivu-page-header-row" };
const _hoisted_7$1 = {
  key: 1,
  class: "ivu-page-header-title"
};
const _hoisted_8$1 = {
  key: 2,
  class: "ivu-page-header-action"
};
const _hoisted_9$1 = { class: "ivu-page-header-row" };
const _hoisted_10$1 = {
  key: 0,
  class: "ivu-page-header-content"
};
const _hoisted_11$1 = {
  key: 1,
  class: "ivu-page-header-extra"
};
const _hoisted_12 = {
  key: 1,
  class: "ivu-page-header-tabs"
};
function _sfc_render$C(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_BreadcrumbItem = resolveComponent("BreadcrumbItem");
  const _component_Breadcrumb = resolveComponent("Breadcrumb");
  const _component_Icon = resolveComponent("Icon");
  const _component_Divider = resolveComponent("Divider");
  const _component_TabPane = resolveComponent("TabPane");
  const _component_Tabs = resolveComponent("Tabs");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(["ivu-page-header", $options.classes])
  }, [
    _ctx.$slots.breadcrumb || !$props.hiddenBreadcrumb ? (openBlock(), createElementBlock("div", _hoisted_1$l, [
      renderSlot(_ctx.$slots, "breadcrumb", {}, () => [
        createVNode(_component_Breadcrumb, null, {
          default: withCtx(() => [
            (openBlock(true), createElementBlock(Fragment, null, renderList($props.breadcrumbList, (item, index2) => {
              return openBlock(), createBlock(_component_BreadcrumbItem, {
                key: index2,
                to: item.to,
                replace: item.replace,
                target: item.target
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(item.title), 1)
                ]),
                _: 2
              }, 1032, ["to", "replace", "target"]);
            }), 128))
          ]),
          _: 1
        })
      ])
    ])) : createCommentVNode("", true),
    createElementVNode("div", _hoisted_2$e, [
      $props.back || _ctx.$slots.back ? (openBlock(), createElementBlock("div", {
        key: 0,
        class: "ivu-page-header-back",
        onClick: _cache[0] || (_cache[0] = (...args) => $options.handleBack && $options.handleBack(...args))
      }, [
        renderSlot(_ctx.$slots, "back", {}, () => [
          createVNode(_component_Icon, { type: "md-arrow-back" })
        ]),
        createVNode(_component_Divider, { type: "vertical" })
      ])) : createCommentVNode("", true),
      $props.logo || _ctx.$slots.logo ? (openBlock(), createElementBlock("div", _hoisted_3$a, [
        renderSlot(_ctx.$slots, "logo", {}, () => [
          createElementVNode("img", { src: $props.logo }, null, 8, _hoisted_4$7)
        ])
      ])) : createCommentVNode("", true),
      createElementVNode("div", _hoisted_5$3, [
        createElementVNode("div", _hoisted_6$2, [
          $props.back || _ctx.$slots.back ? (openBlock(), createElementBlock("div", {
            key: 0,
            class: "ivu-page-header-back",
            onClick: _cache[1] || (_cache[1] = (...args) => $options.handleBack && $options.handleBack(...args))
          }, [
            renderSlot(_ctx.$slots, "back", {}, () => [
              createVNode(_component_Icon, { type: "md-arrow-back" })
            ]),
            createVNode(_component_Divider, { type: "vertical" })
          ])) : createCommentVNode("", true),
          $props.title || _ctx.$slots.title ? (openBlock(), createElementBlock("div", _hoisted_7$1, [
            renderSlot(_ctx.$slots, "title", {}, () => [
              createTextVNode(toDisplayString($props.title), 1)
            ])
          ])) : createCommentVNode("", true),
          $props.action || _ctx.$slots.action ? (openBlock(), createElementBlock("div", _hoisted_8$1, [
            renderSlot(_ctx.$slots, "action", {}, () => [
              createTextVNode(toDisplayString($props.action), 1)
            ])
          ])) : createCommentVNode("", true)
        ]),
        createElementVNode("div", _hoisted_9$1, [
          $props.content || _ctx.$slots.content ? (openBlock(), createElementBlock("div", _hoisted_10$1, [
            renderSlot(_ctx.$slots, "content", {}, () => [
              createTextVNode(toDisplayString($props.content), 1)
            ])
          ])) : createCommentVNode("", true),
          $props.extra || _ctx.$slots.extra ? (openBlock(), createElementBlock("div", _hoisted_11$1, [
            renderSlot(_ctx.$slots, "extra", {}, () => [
              createTextVNode(toDisplayString($props.extra), 1)
            ])
          ])) : createCommentVNode("", true)
        ])
      ])
    ]),
    $props.tabList && $props.tabList.length ? (openBlock(), createElementBlock("div", _hoisted_12, [
      createVNode(_component_Tabs, {
        animated: false,
        "model-value": $props.tabActiveKey,
        onOnClick: $options.handleTabChange
      }, {
        default: withCtx(() => [
          (openBlock(true), createElementBlock(Fragment, null, renderList($props.tabList, (item, index2) => {
            return openBlock(), createBlock(_component_TabPane, {
              key: index2,
              label: item.label,
              name: item.name
            }, null, 8, ["label", "name"]);
          }), 128))
        ]),
        _: 1
      }, 8, ["model-value", "onOnClick"])
    ])) : createCommentVNode("", true)
  ], 2);
}
var PageHeader = /* @__PURE__ */ _export_sfc(_sfc_main$L, [["render", _sfc_render$C]]);
const _sfc_main$K = defineComponent({
  name: "CollapseTransition",
  props: {
    ready: {
      type: Boolean,
      default: true
    }
  },
  setup(props) {
    return {
      on: {
        beforeEnter(el) {
          if (!props.ready)
            return;
          addClass(el, "collapse-transition");
          if (!el.dataset)
            el.dataset = {};
          el.dataset.oldPaddingTop = el.style.paddingTop;
          el.dataset.oldPaddingBottom = el.style.paddingBottom;
          el.style.height = "0";
          el.style.paddingTop = 0;
          el.style.paddingBottom = 0;
        },
        enter(el) {
          if (!props.ready)
            return;
          el.dataset.oldOverflow = el.style.overflow;
          if (el.scrollHeight !== 0) {
            el.style.height = el.scrollHeight + "px";
            el.style.paddingTop = el.dataset.oldPaddingTop;
            el.style.paddingBottom = el.dataset.oldPaddingBottom;
          } else {
            el.style.height = "";
            el.style.paddingTop = el.dataset.oldPaddingTop;
            el.style.paddingBottom = el.dataset.oldPaddingBottom;
          }
          el.style.overflow = "hidden";
        },
        afterEnter(el) {
          if (!props.ready)
            return;
          removeClass(el, "collapse-transition");
          el.style.height = "";
          el.style.overflow = el.dataset.oldOverflow;
        },
        beforeLeave(el) {
          if (!props.ready)
            return;
          if (!el.dataset)
            el.dataset = {};
          el.dataset.oldPaddingTop = el.style.paddingTop;
          el.dataset.oldPaddingBottom = el.style.paddingBottom;
          el.dataset.oldOverflow = el.style.overflow;
          el.style.height = el.scrollHeight + "px";
          el.style.overflow = "hidden";
        },
        leave(el) {
          if (!props.ready)
            return;
          if (el.scrollHeight !== 0) {
            addClass(el, "collapse-transition");
            el.style.height = 0;
            el.style.paddingTop = 0;
            el.style.paddingBottom = 0;
          }
        },
        afterLeave(el) {
          if (!props.ready)
            return;
          removeClass(el, "collapse-transition");
          el.style.height = "";
          el.style.overflow = el.dataset.oldOverflow;
          el.style.paddingTop = el.dataset.oldPaddingTop;
          el.style.paddingBottom = el.dataset.oldPaddingBottom;
        }
      }
    };
  }
});
function _sfc_render$B(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createBlock(Transition, toHandlers(_ctx.on), {
    default: withCtx(() => [
      renderSlot(_ctx.$slots, "default")
    ]),
    _: 3
  }, 16);
}
var CollapseTransition = /* @__PURE__ */ _export_sfc(_sfc_main$K, [["render", _sfc_render$B]]);
const prefixCls$l = "ivu-collapse";
const _sfc_main$J = {
  name: "Panel",
  components: { Icon, CollapseTransition },
  inject: ["CollapseInstance"],
  props: {
    name: {
      type: String
    },
    hideArrow: {
      type: Boolean,
      default: false
    }
  },
  data() {
    return {
      index: 0,
      mounted: false
    };
  },
  computed: {
    itemClasses() {
      return [
        `${prefixCls$l}-item`,
        {
          [`${prefixCls$l}-item-active`]: this.isActive
        }
      ];
    },
    headerClasses() {
      return `${prefixCls$l}-header`;
    },
    contentClasses() {
      return `${prefixCls$l}-content`;
    },
    boxClasses() {
      return `${prefixCls$l}-content-box`;
    },
    isActive() {
      const activeKey = this.CollapseInstance.getActiveKey();
      const name2 = this.name || this.index.toString();
      return activeKey.indexOf(name2) > -1;
    }
  },
  methods: {
    setIndex() {
      this.index = this.CollapseInstance.panelCount + 1;
      this.CollapseInstance.panelCount = this.index;
    },
    toggle() {
      this.CollapseInstance.toggle({
        name: this.name || this.index,
        isActive: this.isActive
      });
    }
  },
  mounted() {
    this.setIndex();
    this.mounted = true;
  }
};
function _sfc_render$A(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = resolveComponent("Icon");
  const _component_collapse_transition = resolveComponent("collapse-transition");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.itemClasses)
  }, [
    createElementVNode("div", {
      class: normalizeClass($options.headerClasses),
      onClick: _cache[0] || (_cache[0] = (...args) => $options.toggle && $options.toggle(...args))
    }, [
      !$props.hideArrow ? (openBlock(), createBlock(_component_Icon, {
        key: 0,
        type: "ios-arrow-forward"
      })) : createCommentVNode("", true),
      renderSlot(_ctx.$slots, "default")
    ], 2),
    $data.mounted ? (openBlock(), createBlock(_component_collapse_transition, { key: 0 }, {
      default: withCtx(() => [
        withDirectives(createElementVNode("div", {
          class: normalizeClass($options.contentClasses)
        }, [
          createElementVNode("div", {
            class: normalizeClass($options.boxClasses)
          }, [
            renderSlot(_ctx.$slots, "content")
          ], 2)
        ], 2), [
          [vShow, $options.isActive]
        ])
      ]),
      _: 3
    })) : createCommentVNode("", true)
  ], 2);
}
var Panel = /* @__PURE__ */ _export_sfc(_sfc_main$J, [["render", _sfc_render$A]]);
const _sfc_main$I = {
  name: "Paragraph",
  mixins: [baseProps],
  render() {
    return h(_sfc_main$17, {
      ...this.$props,
      component: "div",
      ...this.commonEvents()
    }, this.commonSlots());
  }
};
const _sfc_main$H = {
  name: "Password",
  mixins: [LoginItem],
  data() {
    return {
      className: "ivu-login-password",
      prefix: "ios-lock-outline",
      placeholder: "\u8BF7\u8F93\u5165\u5BC6\u7801",
      type: "password"
    };
  }
};
const prefixCls$k = "ivu-poptip";
const _sfc_main$G = {
  name: "Poptip",
  mixins: [Popper, Locale],
  emits: ["on-ok", "on-cancel"],
  directives: { clickOutside },
  components: { iButton: _sfc_main$2c },
  props: {
    trigger: {
      validator(value) {
        return oneOf(value, ["click", "focus", "hover"]);
      },
      default: "click"
    },
    placement: {
      validator(value) {
        return oneOf(value, ["top", "top-start", "top-end", "bottom", "bottom-start", "bottom-end", "left", "left-start", "left-end", "right", "right-start", "right-end"]);
      },
      default: "top"
    },
    title: {
      type: [String, Number]
    },
    content: {
      type: [String, Number],
      default: ""
    },
    width: {
      type: [String, Number]
    },
    confirm: {
      type: Boolean,
      default: false
    },
    okText: {
      type: String
    },
    cancelText: {
      type: String
    },
    transfer: {
      type: Boolean,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.transfer === "" ? false : global2.$VIEWUI.transfer;
      }
    },
    popperClass: {
      type: String
    },
    wordWrap: {
      type: Boolean,
      default: false
    },
    padding: {
      type: String
    },
    disabled: {
      type: Boolean,
      default: false
    },
    capture: {
      type: Boolean,
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI ? false : global2.$VIEWUI.capture;
      }
    },
    transferClassName: {
      type: String
    }
  },
  data() {
    return {
      prefixCls: prefixCls$k,
      showTitle: true,
      isInput: false,
      disableCloseUnderTransfer: false,
      tIndex: this.handleGetIndex()
    };
  },
  computed: {
    classes() {
      return [
        `${prefixCls$k}`,
        {
          [`${prefixCls$k}-confirm`]: this.confirm
        }
      ];
    },
    popperClasses() {
      return [
        `${prefixCls$k}-popper`,
        {
          [`${prefixCls$k}-confirm`]: this.transfer && this.confirm,
          [`${this.popperClass}`]: !!this.popperClass,
          [prefixCls$k + "-transfer"]: this.transfer,
          [this.transferClassName]: this.transferClassName
        }
      ];
    },
    styles() {
      let style2 = {};
      if (this.width) {
        style2.width = `${this.width}px`;
      }
      if (this.transfer)
        style2["z-index"] = 1060 + this.tIndex;
      return style2;
    },
    localeOkText() {
      if (this.okText === void 0) {
        return this.t("i.poptip.okText");
      } else {
        return this.okText;
      }
    },
    localeCancelText() {
      if (this.cancelText === void 0) {
        return this.t("i.poptip.cancelText");
      } else {
        return this.cancelText;
      }
    },
    contentClasses() {
      return [
        `${prefixCls$k}-body-content`,
        {
          [`${prefixCls$k}-body-content-word-wrap`]: this.wordWrap
        }
      ];
    },
    contentPaddingStyle() {
      const styles = {};
      if (this.padding !== "")
        styles["padding"] = this.padding;
      return styles;
    }
  },
  methods: {
    handleClick() {
      if (this.disabled)
        return;
      if (this.confirm) {
        this.visible = !this.visible;
        return true;
      }
      if (this.trigger !== "click") {
        return false;
      }
      this.visible = !this.visible;
    },
    handleTransferClick() {
      if (this.transfer)
        this.disableCloseUnderTransfer = true;
    },
    handleClose() {
      if (this.disableCloseUnderTransfer) {
        this.disableCloseUnderTransfer = false;
        return false;
      }
      if (this.confirm) {
        this.visible = false;
        return true;
      }
      if (this.trigger !== "click") {
        return false;
      }
      this.visible = false;
    },
    handleFocus(fromInput = true) {
      if (this.disabled)
        return;
      if (this.trigger !== "focus" || this.confirm || this.isInput && !fromInput) {
        return false;
      }
      this.visible = true;
    },
    handleBlur(fromInput = true) {
      if (this.trigger !== "focus" || this.confirm || this.isInput && !fromInput) {
        return false;
      }
      this.visible = false;
    },
    handleMouseenter() {
      if (this.disabled)
        return;
      if (this.trigger !== "hover" || this.confirm) {
        return false;
      }
      if (this.enterTimer)
        clearTimeout(this.enterTimer);
      this.enterTimer = setTimeout(() => {
        this.visible = true;
      }, 100);
    },
    handleMouseleave() {
      if (this.trigger !== "hover" || this.confirm) {
        return false;
      }
      if (this.enterTimer) {
        clearTimeout(this.enterTimer);
        this.enterTimer = setTimeout(() => {
          this.visible = false;
        }, 100);
      }
    },
    cancel() {
      this.visible = false;
      this.$emit("on-cancel");
    },
    ok() {
      this.visible = false;
      this.$emit("on-ok");
    },
    getInputChildren() {
      const $input = this.$refs.reference.querySelectorAll("input");
      const $textarea = this.$refs.reference.querySelectorAll("textarea");
      let $children = null;
      if ($input.length) {
        $children = $input[0];
      } else if ($textarea.length) {
        $children = $textarea[0];
      }
      return $children;
    },
    handleGetIndex() {
      transferIncrease();
      return transferIndex;
    },
    handleIndexIncrease() {
      this.tIndex = this.handleGetIndex();
    }
  },
  mounted() {
    if (!this.confirm) {
      this.showTitle = this.$slots.title !== void 0 || this.title;
    }
    if (this.trigger === "focus") {
      nextTick(() => {
        const $children = this.getInputChildren();
        if ($children) {
          this.isInput = true;
          $children.addEventListener("focus", this.handleFocus, false);
          $children.addEventListener("blur", this.handleBlur, false);
        }
      });
    }
  },
  beforeUnmount() {
    const $children = this.getInputChildren();
    if ($children) {
      $children.removeEventListener("focus", this.handleFocus, false);
      $children.removeEventListener("blur", this.handleBlur, false);
    }
  }
};
function _sfc_render$z(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_i_button = resolveComponent("i-button");
  const _directive_click_outside = resolveDirective("click-outside");
  return withDirectives((openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes),
    onMouseenter: _cache[6] || (_cache[6] = (...args) => $options.handleMouseenter && $options.handleMouseenter(...args)),
    onMouseleave: _cache[7] || (_cache[7] = (...args) => $options.handleMouseleave && $options.handleMouseleave(...args))
  }, [
    createElementVNode("div", {
      class: normalizeClass([$data.prefixCls + "-rel"]),
      ref: "reference",
      onClick: _cache[0] || (_cache[0] = (...args) => $options.handleClick && $options.handleClick(...args)),
      onMousedown: _cache[1] || (_cache[1] = ($event) => $options.handleFocus(false)),
      onMouseup: _cache[2] || (_cache[2] = ($event) => $options.handleBlur(false))
    }, [
      renderSlot(_ctx.$slots, "default")
    ], 34),
    (openBlock(), createBlock(Teleport, {
      to: "body",
      disabled: !$props.transfer
    }, [
      createVNode(Transition, { name: "fade" }, {
        default: withCtx(() => [
          withDirectives(createElementVNode("div", {
            class: normalizeClass($options.popperClasses),
            style: normalizeStyle($options.styles),
            ref: "popper",
            onClick: _cache[3] || (_cache[3] = (...args) => $options.handleTransferClick && $options.handleTransferClick(...args)),
            onMouseenter: _cache[4] || (_cache[4] = (...args) => $options.handleMouseenter && $options.handleMouseenter(...args)),
            onMouseleave: _cache[5] || (_cache[5] = (...args) => $options.handleMouseleave && $options.handleMouseleave(...args))
          }, [
            createElementVNode("div", {
              class: normalizeClass([$data.prefixCls + "-content"])
            }, [
              createElementVNode("div", {
                class: normalizeClass([$data.prefixCls + "-arrow"])
              }, null, 2),
              $props.confirm ? (openBlock(), createElementBlock("div", {
                key: 0,
                class: normalizeClass([$data.prefixCls + "-inner"])
              }, [
                createElementVNode("div", {
                  class: normalizeClass([$data.prefixCls + "-body"])
                }, [
                  _cache[8] || (_cache[8] = createElementVNode("i", { class: "ivu-icon ivu-icon-ios-help-circle" }, null, -1)),
                  createElementVNode("div", {
                    class: normalizeClass([$data.prefixCls + "-body-message"])
                  }, [
                    renderSlot(_ctx.$slots, "title", {}, () => [
                      createTextVNode(toDisplayString($props.title), 1)
                    ])
                  ], 2)
                ], 2),
                createElementVNode("div", {
                  class: normalizeClass([$data.prefixCls + "-footer"])
                }, [
                  createVNode(_component_i_button, {
                    type: "text",
                    size: "small",
                    onClick: $options.cancel
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString($options.localeCancelText), 1)
                    ]),
                    _: 1
                  }, 8, ["onClick"]),
                  createVNode(_component_i_button, {
                    type: "primary",
                    size: "small",
                    onClick: $options.ok
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString($options.localeOkText), 1)
                    ]),
                    _: 1
                  }, 8, ["onClick"])
                ], 2)
              ], 2)) : createCommentVNode("", true),
              !$props.confirm ? (openBlock(), createElementBlock("div", {
                key: 1,
                class: normalizeClass([$data.prefixCls + "-inner"])
              }, [
                $data.showTitle ? (openBlock(), createElementBlock("div", {
                  key: 0,
                  class: normalizeClass([$data.prefixCls + "-title"]),
                  style: normalizeStyle($options.contentPaddingStyle),
                  ref: "title"
                }, [
                  renderSlot(_ctx.$slots, "title", {}, () => [
                    createElementVNode("div", {
                      class: normalizeClass([$data.prefixCls + "-title-inner"])
                    }, toDisplayString($props.title), 3)
                  ])
                ], 6)) : createCommentVNode("", true),
                createElementVNode("div", {
                  class: normalizeClass([$data.prefixCls + "-body"]),
                  style: normalizeStyle($options.contentPaddingStyle)
                }, [
                  createElementVNode("div", {
                    class: normalizeClass($options.contentClasses)
                  }, [
                    renderSlot(_ctx.$slots, "content", {}, () => [
                      createElementVNode("div", {
                        class: normalizeClass([$data.prefixCls + "-body-content-inner"])
                      }, toDisplayString($props.content), 3)
                    ])
                  ], 2)
                ], 6)
              ], 2)) : createCommentVNode("", true)
            ], 2)
          ], 38), [
            [vShow, _ctx.visible]
          ])
        ]),
        _: 3
      })
    ], 8, ["disabled"]))
  ], 34)), [
    [_directive_click_outside, $options.handleClose]
  ]);
}
var Poptip = /* @__PURE__ */ _export_sfc(_sfc_main$G, [["render", _sfc_render$z]]);
const prefixCls$j = "ivu-progress";
const _sfc_main$F = {
  name: "Progress",
  components: { Icon },
  props: {
    percent: {
      type: Number,
      default: 0
    },
    successPercent: {
      type: Number,
      default: 0
    },
    status: {
      validator(value) {
        return oneOf(value, ["normal", "active", "wrong", "success"]);
      },
      default: "normal"
    },
    hideInfo: {
      type: Boolean,
      default: false
    },
    strokeWidth: {
      type: Number,
      default: 10
    },
    vertical: {
      type: Boolean,
      default: false
    },
    strokeColor: {
      type: [String, Array]
    },
    textInside: {
      type: Boolean,
      default: false
    }
  },
  data() {
    return {
      currentStatus: this.status
    };
  },
  computed: {
    isStatus() {
      return this.currentStatus === "wrong" || this.currentStatus === "success";
    },
    statusIcon() {
      let type2 = "";
      switch (this.currentStatus) {
        case "wrong":
          type2 = "ios-close-circle";
          break;
        case "success":
          type2 = "ios-checkmark-circle";
          break;
      }
      return type2;
    },
    bgStyle() {
      const style2 = this.vertical ? {
        height: `${this.percent}%`,
        width: `${this.strokeWidth}px`
      } : {
        width: `${this.percent}%`,
        height: `${this.strokeWidth}px`
      };
      if (this.strokeColor) {
        if (typeof this.strokeColor === "string") {
          style2["background-color"] = this.strokeColor;
        } else {
          style2["background-image"] = `linear-gradient(to right, ${this.strokeColor[0]} 0%, ${this.strokeColor[1]} 100%)`;
        }
      }
      return style2;
    },
    successBgStyle() {
      return this.vertical ? {
        height: `${this.successPercent}%`,
        width: `${this.strokeWidth}px`
      } : {
        width: `${this.successPercent}%`,
        height: `${this.strokeWidth}px`
      };
    },
    wrapClasses() {
      return [
        `${prefixCls$j}`,
        `${prefixCls$j}-${this.currentStatus}`,
        {
          [`${prefixCls$j}-show-info`]: !this.hideInfo && !this.textInside,
          [`${prefixCls$j}-vertical`]: this.vertical
        }
      ];
    },
    textClasses() {
      return `${prefixCls$j}-text`;
    },
    textInnerClasses() {
      return `${prefixCls$j}-text-inner`;
    },
    outerClasses() {
      return `${prefixCls$j}-outer`;
    },
    innerClasses() {
      return `${prefixCls$j}-inner`;
    },
    bgClasses() {
      return `${prefixCls$j}-bg`;
    },
    successBgClasses() {
      return `${prefixCls$j}-success-bg`;
    }
  },
  created() {
    this.handleStatus();
  },
  methods: {
    handleStatus(isDown) {
      if (isDown) {
        this.currentStatus = "normal";
        this.$emit("on-status-change", "normal");
      } else {
        if (parseInt(this.percent, 10) === 100) {
          this.currentStatus = "success";
          this.$emit("on-status-change", "success");
        }
      }
    }
  },
  watch: {
    percent(val, oldVal) {
      if (val < oldVal) {
        this.handleStatus(true);
      } else {
        this.handleStatus();
      }
    },
    status(val) {
      this.currentStatus = val;
    }
  }
};
const _hoisted_1$k = {
  key: 0,
  class: "ivu-progress-inner-text"
};
function _sfc_render$y(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = resolveComponent("Icon");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.wrapClasses)
  }, [
    createElementVNode("div", {
      class: normalizeClass($options.outerClasses)
    }, [
      createElementVNode("div", {
        class: normalizeClass($options.innerClasses)
      }, [
        createElementVNode("div", {
          class: normalizeClass($options.bgClasses),
          style: normalizeStyle($options.bgStyle)
        }, [
          $props.textInside ? (openBlock(), createElementBlock("div", _hoisted_1$k, toDisplayString($props.percent) + "%", 1)) : createCommentVNode("", true)
        ], 6),
        createElementVNode("div", {
          class: normalizeClass($options.successBgClasses),
          style: normalizeStyle($options.successBgStyle)
        }, null, 6)
      ], 2)
    ], 2),
    !$props.hideInfo && !$props.textInside ? (openBlock(), createElementBlock("span", {
      key: 0,
      class: normalizeClass($options.textClasses)
    }, [
      renderSlot(_ctx.$slots, "default", {}, () => [
        $options.isStatus ? (openBlock(), createElementBlock("span", {
          key: 0,
          class: normalizeClass($options.textInnerClasses)
        }, [
          createVNode(_component_Icon, { type: $options.statusIcon }, null, 8, ["type"])
        ], 2)) : (openBlock(), createElementBlock("span", {
          key: 1,
          class: normalizeClass($options.textInnerClasses)
        }, toDisplayString($props.percent) + "% ", 3))
      ])
    ], 2)) : createCommentVNode("", true)
  ], 2);
}
var iProgress = /* @__PURE__ */ _export_sfc(_sfc_main$F, [["render", _sfc_render$y]]);
const prefixCls$i = "ivu-rate";
const _sfc_main$E = {
  name: "Rate",
  mixins: [Locale, mixinsForm],
  emits: ["update:modelValue", "on-change"],
  props: {
    count: {
      type: Number,
      default: 5
    },
    modelValue: {
      type: Number,
      default: 0
    },
    allowHalf: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    },
    showText: {
      type: Boolean,
      default: false
    },
    name: {
      type: String
    },
    clearable: {
      type: Boolean,
      default: false
    },
    character: {
      type: String,
      default: ""
    },
    icon: {
      type: String,
      default: ""
    },
    customIcon: {
      type: String,
      default: ""
    }
  },
  data() {
    const value = this.modelValue || 0;
    return {
      prefixCls: prefixCls$i,
      hoverIndex: -1,
      isHover: false,
      isHalf: this.allowHalf && value.toString().indexOf(".") >= 0,
      currentValue: value
    };
  },
  computed: {
    classes() {
      return [
        `${prefixCls$i}`,
        {
          [`${prefixCls$i}-disabled`]: this.itemDisabled
        }
      ];
    },
    iconClasses() {
      return [
        "ivu-icon",
        {
          [`ivu-icon-${this.icon}`]: this.icon !== "",
          [`${this.customIcon}`]: this.customIcon !== ""
        }
      ];
    },
    showCharacter() {
      return this.character !== "" || this.icon !== "" || this.customIcon !== "";
    }
  },
  watch: {
    modelValue(val) {
      this.currentValue = val || 0;
    },
    currentValue(val) {
      this.setHalf(val);
    }
  },
  methods: {
    starCls(value) {
      const hoverIndex = this.hoverIndex;
      const currentIndex = this.isHover ? hoverIndex : this.currentValue;
      let full = false;
      let isLast = false;
      if (currentIndex >= value)
        full = true;
      if (this.isHover) {
        isLast = currentIndex === value;
      } else {
        isLast = Math.ceil(this.currentValue) === value;
      }
      return [
        {
          [`${prefixCls$i}-star`]: !this.showCharacter,
          [`${prefixCls$i}-star-chart`]: this.showCharacter,
          [`${prefixCls$i}-star-full`]: !isLast && full || isLast && !this.isHalf,
          [`${prefixCls$i}-star-half`]: isLast && this.isHalf,
          [`${prefixCls$i}-star-zero`]: !full
        }
      ];
    },
    handleMousemove(value, event) {
      if (this.itemDisabled)
        return;
      this.isHover = true;
      if (this.allowHalf) {
        const type2 = event.target.getAttribute("type") || false;
        this.isHalf = type2 === "half";
      } else {
        this.isHalf = false;
      }
      this.hoverIndex = value;
    },
    handleMouseleave() {
      if (this.itemDisabled)
        return;
      this.isHover = false;
      this.setHalf(this.currentValue);
      this.hoverIndex = -1;
    },
    setHalf(val) {
      this.isHalf = this.allowHalf && val.toString().indexOf(".") >= 0;
    },
    handleClick(value) {
      if (this.itemDisabled)
        return;
      if (this.isHalf)
        value -= 0.5;
      if (this.clearable && Math.abs(value - this.currentValue) < 0.01) {
        value = 0;
      }
      this.currentValue = value;
      this.$emit("update:modelValue", value);
      this.$emit("on-change", value);
      this.handleFormItemChange("change", value);
    }
  }
};
const _hoisted_1$j = ["name", "value"];
const _hoisted_2$d = ["onMousemove", "onClick"];
const _hoisted_3$9 = { key: 0 };
const _hoisted_4$6 = { key: 1 };
function _sfc_render$x(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes),
    onMouseleave: _cache[0] || (_cache[0] = (...args) => $options.handleMouseleave && $options.handleMouseleave(...args))
  }, [
    createElementVNode("input", {
      type: "hidden",
      name: $props.name,
      value: $data.currentValue
    }, null, 8, _hoisted_1$j),
    (openBlock(true), createElementBlock(Fragment, null, renderList($props.count, (item) => {
      return openBlock(), createElementBlock("div", {
        class: normalizeClass($options.starCls(item)),
        onMousemove: ($event) => $options.handleMousemove(item, $event),
        key: item,
        onClick: ($event) => $options.handleClick(item)
      }, [
        !$options.showCharacter ? (openBlock(), createElementBlock("span", {
          key: 0,
          class: normalizeClass([$data.prefixCls + "-star-content"]),
          type: "half"
        }, null, 2)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
          createElementVNode("span", {
            class: normalizeClass([$data.prefixCls + "-star-first"]),
            type: "half"
          }, [
            $props.character !== "" ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
              createTextVNode(toDisplayString($props.character), 1)
            ], 64)) : (openBlock(), createElementBlock("i", {
              key: 1,
              class: normalizeClass($options.iconClasses),
              type: "half"
            }, null, 2))
          ], 2),
          createElementVNode("span", {
            class: normalizeClass([$data.prefixCls + "-star-second"])
          }, [
            $props.character !== "" ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
              createTextVNode(toDisplayString($props.character), 1)
            ], 64)) : (openBlock(), createElementBlock("i", {
              key: 1,
              class: normalizeClass($options.iconClasses)
            }, null, 2))
          ], 2)
        ], 64))
      ], 42, _hoisted_2$d);
    }), 128)),
    $props.showText ? withDirectives((openBlock(), createElementBlock("div", {
      key: 0,
      class: normalizeClass([$data.prefixCls + "-text"])
    }, [
      renderSlot(_ctx.$slots, "default", {}, () => [
        createElementVNode("span", null, toDisplayString($data.currentValue), 1),
        _cache[1] || (_cache[1] = createTextVNode()),
        $data.currentValue <= 1 ? (openBlock(), createElementBlock("span", _hoisted_3$9, toDisplayString(_ctx.t("i.rate.star")), 1)) : (openBlock(), createElementBlock("span", _hoisted_4$6, toDisplayString(_ctx.t("i.rate.stars")), 1))
      ])
    ], 2)), [
      [vShow, $data.currentValue > 0]
    ]) : createCommentVNode("", true)
  ], 34);
}
var Rate = /* @__PURE__ */ _export_sfc(_sfc_main$E, [["render", _sfc_render$x]]);
const _sfc_main$D = {
  name: "Result",
  components: { Icon },
  props: {
    type: {
      validator(value) {
        return oneOf(value, ["success", "error", "warning"]);
      }
    },
    title: {
      type: String
    },
    desc: {
      type: String
    },
    extra: {
      type: String
    }
  },
  computed: {
    iconClasses() {
      return {
        "ivu-result-icon-success": this.type === "success",
        "ivu-result-icon-error": this.type === "error",
        "ivu-result-icon-warning": this.type === "warning"
      };
    }
  }
};
const _hoisted_1$i = { class: "ivu-result" };
const _hoisted_2$c = {
  key: 0,
  class: "ivu-result-title"
};
const _hoisted_3$8 = {
  key: 1,
  class: "ivu-result-desc"
};
const _hoisted_4$5 = {
  key: 2,
  class: "ivu-result-extra"
};
const _hoisted_5$2 = {
  key: 3,
  class: "ivu-result-actions"
};
function _sfc_render$w(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = resolveComponent("Icon");
  return openBlock(), createElementBlock("div", _hoisted_1$i, [
    createElementVNode("div", {
      class: normalizeClass(["ivu-result-icon", $options.iconClasses])
    }, [
      $props.type === "success" ? (openBlock(), createBlock(_component_Icon, {
        key: 0,
        type: "ios-checkmark"
      })) : createCommentVNode("", true),
      $props.type === "error" ? (openBlock(), createBlock(_component_Icon, {
        key: 1,
        type: "ios-close"
      })) : createCommentVNode("", true),
      $props.type === "warning" ? (openBlock(), createBlock(_component_Icon, {
        key: 2,
        type: "ios-information"
      })) : createCommentVNode("", true)
    ], 2),
    $props.title || _ctx.$slots.title ? (openBlock(), createElementBlock("div", _hoisted_2$c, [
      renderSlot(_ctx.$slots, "title", {}, () => [
        createTextVNode(toDisplayString($props.title), 1)
      ])
    ])) : createCommentVNode("", true),
    $props.desc || _ctx.$slots.desc ? (openBlock(), createElementBlock("div", _hoisted_3$8, [
      renderSlot(_ctx.$slots, "desc", {}, () => [
        createTextVNode(toDisplayString($props.desc), 1)
      ])
    ])) : createCommentVNode("", true),
    $props.extra || _ctx.$slots.extra ? (openBlock(), createElementBlock("div", _hoisted_4$5, [
      renderSlot(_ctx.$slots, "extra", {}, () => [
        createTextVNode(toDisplayString($props.extra), 1)
      ])
    ])) : createCommentVNode("", true),
    _ctx.$slots.actions ? (openBlock(), createElementBlock("div", _hoisted_5$2, [
      renderSlot(_ctx.$slots, "actions")
    ])) : createCommentVNode("", true)
  ]);
}
var Result = /* @__PURE__ */ _export_sfc(_sfc_main$D, [["render", _sfc_render$w]]);
const prefixCls$h = "ivu-scroll";
const _sfc_main$C = {
  props: ["text", "active", "spinnerHeight"],
  components: { Spin, Icon },
  computed: {
    wrapperClasses() {
      return [
        `${prefixCls$h}-loader-wrapper`,
        {
          [`${prefixCls$h}-loader-wrapper-active`]: this.active
        }
      ];
    },
    spinnerClasses() {
      return `${prefixCls$h}-spinner`;
    },
    iconClasses() {
      return `${prefixCls$h}-spinner-icon`;
    },
    textClasses() {
      return `${prefixCls$h}-loader-text`;
    }
  }
};
function _sfc_render$v(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = resolveComponent("Icon");
  const _component_Spin = resolveComponent("Spin");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.wrapperClasses)
  }, [
    createElementVNode("div", {
      class: normalizeClass($options.spinnerClasses)
    }, [
      createVNode(_component_Spin, { fix: "" }, {
        default: withCtx(() => [
          createVNode(_component_Icon, {
            type: "ios-loading",
            size: "18",
            class: normalizeClass($options.iconClasses)
          }, null, 8, ["class"]),
          $props.text ? (openBlock(), createElementBlock("div", {
            key: 0,
            class: normalizeClass($options.textClasses)
          }, toDisplayString($props.text), 3)) : createCommentVNode("", true)
        ]),
        _: 1
      })
    ], 2)
  ], 2);
}
var loader = /* @__PURE__ */ _export_sfc(_sfc_main$C, [["render", _sfc_render$v]]);
const prefixCls$g = "ivu-scroll";
const dragConfig = {
  sensitivity: 10,
  minimumStartDragOffset: 5
};
const noop = () => Promise.resolve();
const _sfc_main$B = {
  name: "Scroll",
  mixins: [Locale],
  components: { loader },
  props: {
    height: {
      type: [Number, String],
      default: 300
    },
    onReachTop: {
      type: Function
    },
    onReachBottom: {
      type: Function
    },
    onReachEdge: {
      type: Function
    },
    loadingText: {
      type: String
    },
    distanceToEdge: [Number, Array],
    stopSlide: {
      type: Boolean,
      default: false
    }
  },
  data() {
    const distanceToEdge = this.calculateProximityThreshold();
    return {
      showTopLoader: false,
      showBottomLoader: false,
      showBodyLoader: false,
      lastScroll: 0,
      reachedTopScrollLimit: true,
      reachedBottomScrollLimit: false,
      topRubberPadding: 0,
      bottomRubberPadding: 0,
      rubberRollBackTimeout: false,
      isLoading: false,
      pointerTouchDown: null,
      touchScroll: false,
      handleScroll: () => {
      },
      pointerUpHandler: () => {
      },
      pointerMoveHandler: () => {
      },
      topProximityThreshold: distanceToEdge[0],
      bottomProximityThreshold: distanceToEdge[1]
    };
  },
  computed: {
    wrapClasses() {
      return `${prefixCls$g}-wrapper`;
    },
    scrollContainerClasses() {
      return [
        `${prefixCls$g}-container`,
        {
          [`${prefixCls$g}-container-loading`]: this.showBodyLoader && this.stopSlide
        }
      ];
    },
    slotContainerClasses() {
      return [
        `${prefixCls$g}-content`,
        {
          [`${prefixCls$g}-content-loading`]: this.showBodyLoader
        }
      ];
    },
    loaderClasses() {
      return `${prefixCls$g}-loader`;
    },
    wrapperPadding() {
      return {
        paddingTop: this.topRubberPadding + "px",
        paddingBottom: this.bottomRubberPadding + "px"
      };
    },
    localeLoadingText() {
      if (this.loadingText === void 0) {
        return this.t("i.select.loading");
      } else {
        return this.loadingText;
      }
    }
  },
  methods: {
    waitOneSecond() {
      return new Promise((resolve) => {
        setTimeout(resolve, 1e3);
      });
    },
    calculateProximityThreshold() {
      const dte = this.distanceToEdge;
      if (typeof dte == "undefined")
        return [20, 20];
      return Array.isArray(dte) ? dte : [dte, dte];
    },
    onCallback(dir) {
      this.isLoading = true;
      this.showBodyLoader = true;
      if (dir > 0) {
        this.showTopLoader = true;
        this.topRubberPadding = 20;
      } else {
        this.showBottomLoader = true;
        this.bottomRubberPadding = 20;
        let bottomLoaderHeight = 0;
        const container = this.$refs.scrollContainer;
        const initialScrollTop = container.scrollTop;
        for (let i = 0; i < 20; i++) {
          setTimeout(() => {
            bottomLoaderHeight = Math.max(
              bottomLoaderHeight,
              this.$refs.bottomLoader.getBoundingClientRect().height
            );
            container.scrollTop = initialScrollTop + bottomLoaderHeight;
          }, i * 50);
        }
      }
      const callbacks = [this.waitOneSecond(), this.onReachEdge ? this.onReachEdge(dir) : noop()];
      callbacks.push(dir > 0 ? this.onReachTop ? this.onReachTop() : noop() : this.onReachBottom ? this.onReachBottom() : noop());
      let tooSlow = setTimeout(() => {
        this.reset();
      }, 5e3);
      Promise.all(callbacks).then(() => {
        clearTimeout(tooSlow);
        this.reset();
      });
    },
    reset() {
      [
        "showTopLoader",
        "showBottomLoader",
        "showBodyLoader",
        "isLoading",
        "reachedTopScrollLimit",
        "reachedBottomScrollLimit"
      ].forEach((prop2) => this[prop2] = false);
      this.lastScroll = 0;
      this.topRubberPadding = 0;
      this.bottomRubberPadding = 0;
      clearInterval(this.rubberRollBackTimeout);
      if (this.touchScroll) {
        setTimeout(() => {
          off(window, "touchend", this.pointerUpHandler);
          this.$refs.scrollContainer.removeEventListener("touchmove", this.pointerMoveHandler);
          this.touchScroll = false;
        }, 500);
      }
    },
    onWheel(event) {
      if (this.isLoading)
        return;
      const wheelDelta = event.wheelDelta ? event.wheelDelta : -(event.detail || event.deltaY);
      this.stretchEdge(wheelDelta);
    },
    stretchEdge(direction) {
      clearTimeout(this.rubberRollBackTimeout);
      if (!this.onReachEdge) {
        if (direction > 0) {
          if (!this.onReachTop)
            return;
        } else {
          if (!this.onReachBottom)
            return;
        }
      }
      this.rubberRollBackTimeout = setTimeout(() => {
        if (!this.isLoading)
          this.reset();
      }, 250);
      if (direction > 0 && this.reachedTopScrollLimit) {
        this.topRubberPadding += 5 - this.topRubberPadding / 5;
        if (this.topRubberPadding > this.topProximityThreshold)
          this.onCallback(1);
      } else if (direction < 0 && this.reachedBottomScrollLimit) {
        this.bottomRubberPadding += 6 - this.bottomRubberPadding / 4;
        if (this.bottomRubberPadding > this.bottomProximityThreshold)
          this.onCallback(-1);
      } else {
        this.onScroll();
      }
    },
    onScroll() {
      const el = this.$refs.scrollContainer;
      if (this.isLoading || !el)
        return;
      const scrollDirection = Math.sign(this.lastScroll - el.scrollTop);
      const displacement = el.scrollHeight - el.clientHeight - el.scrollTop;
      const topNegativeProximity = this.topProximityThreshold < 0 ? this.topProximityThreshold : 0;
      const bottomNegativeProximity = this.bottomProximityThreshold < 0 ? this.bottomProximityThreshold : 0;
      if (scrollDirection == -1 && displacement + bottomNegativeProximity <= dragConfig.sensitivity) {
        this.reachedBottomScrollLimit = true;
      } else if (scrollDirection >= 0 && el.scrollTop + topNegativeProximity <= 0) {
        this.reachedTopScrollLimit = true;
      } else {
        this.reachedTopScrollLimit = false;
        this.reachedBottomScrollLimit = false;
        this.lastScroll = el.scrollTop;
      }
    },
    getTouchCoordinates(e) {
      return {
        x: e.touches[0].pageX,
        y: e.touches[0].pageY
      };
    },
    onPointerDown(e) {
      if (this.isLoading)
        return;
      if (e.type == "touchstart") {
        const container = this.$refs.scrollContainer;
        if (this.reachedTopScrollLimit)
          container.scrollTop = 5;
        else if (this.reachedBottomScrollLimit)
          container.scrollTop -= 5;
      }
      if (e.type == "touchstart" && this.$refs.scrollContainer.scrollTop == 0)
        this.$refs.scrollContainer.scrollTop = 5;
      this.pointerTouchDown = this.getTouchCoordinates(e);
      on(window, "touchend", this.pointerUpHandler);
      this.$refs.scrollContainer.parentElement.addEventListener("touchmove", (e2) => {
        e2.stopPropagation();
        this.pointerMoveHandler(e2);
      }, { passive: false, useCapture: true });
    },
    onPointerMove(e) {
      if (!this.pointerTouchDown)
        return;
      if (this.isLoading)
        return;
      const pointerPosition = this.getTouchCoordinates(e);
      const yDiff = pointerPosition.y - this.pointerTouchDown.y;
      this.stretchEdge(yDiff);
      if (!this.touchScroll) {
        const wasDragged = Math.abs(yDiff) > dragConfig.minimumStartDragOffset;
        if (wasDragged)
          this.touchScroll = true;
      }
    },
    onPointerUp() {
      this.pointerTouchDown = null;
    }
  },
  created() {
    this.handleScroll = lodash_throttle(this.onScroll, 150, { leading: false });
    this.pointerUpHandler = this.onPointerUp.bind(this);
    this.pointerMoveHandler = lodash_throttle(this.onPointerMove, 50, { leading: false });
  }
};
function _sfc_render$u(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_loader = resolveComponent("loader");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.wrapClasses),
    style: { "touch-action": "none" }
  }, [
    createElementVNode("div", {
      class: normalizeClass($options.scrollContainerClasses),
      style: normalizeStyle({ height: $props.height + "px" }),
      onScroll: _cache[0] || (_cache[0] = (...args) => $data.handleScroll && $data.handleScroll(...args)),
      onWheel: _cache[1] || (_cache[1] = (...args) => $options.onWheel && $options.onWheel(...args)),
      onTouchstart: _cache[2] || (_cache[2] = (...args) => $options.onPointerDown && $options.onPointerDown(...args)),
      ref: "scrollContainer"
    }, [
      createElementVNode("div", {
        class: normalizeClass($options.loaderClasses),
        style: normalizeStyle({ paddingTop: $options.wrapperPadding.paddingTop }),
        ref: "toploader"
      }, [
        createVNode(_component_loader, {
          text: $options.localeLoadingText,
          active: $data.showTopLoader
        }, null, 8, ["text", "active"])
      ], 6),
      createElementVNode("div", {
        class: normalizeClass($options.slotContainerClasses),
        ref: "scrollContent"
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 2),
      createElementVNode("div", {
        class: normalizeClass($options.loaderClasses),
        style: normalizeStyle({ paddingBottom: $options.wrapperPadding.paddingBottom }),
        ref: "bottomLoader"
      }, [
        createVNode(_component_loader, {
          text: $options.localeLoadingText,
          active: $data.showBottomLoader
        }, null, 8, ["text", "active"])
      ], 6)
    ], 38)
  ], 2);
}
var Scroll = /* @__PURE__ */ _export_sfc(_sfc_main$B, [["render", _sfc_render$u]]);
const COMPLETE = "COMPLETE";
const CANCELED = "CANCELED";
function requestAnimation$1(task) {
  if (isClient && "requestAnimationFrame" in window) {
    return window.requestAnimationFrame(task);
  }
  setTimeout(task, 16);
}
function setElementScroll(element, x, y) {
  if (element === window) {
    element.scrollTo(x, y);
  } else {
    element.scrollLeft = x;
    element.scrollTop = y;
  }
}
function getTargetScrollLocation(target, parent, align) {
  if (!isClient)
    return;
  let targetPosition = target.getBoundingClientRect();
  let parentPosition = null;
  let x = null;
  let y = null;
  let differenceX = null;
  let differenceY = null;
  let targetWidth = null;
  let targetHeight = null;
  let leftAlign = align && align.left != null ? align.left : 0.5;
  let topAlign = align && align.top != null ? align.top : 0.5;
  let leftOffset = align && align.leftOffset != null ? align.leftOffset : 0;
  let topOffset = align && align.topOffset != null ? align.topOffset : 0;
  let leftScalar = leftAlign;
  let topScalar = topAlign;
  if (parent === window) {
    targetWidth = Math.min(targetPosition.width, window.innerWidth);
    targetHeight = Math.min(targetPosition.height, window.innerHeight);
    x = targetPosition.left + window.pageXOffset - window.innerWidth * leftScalar + targetWidth * leftScalar;
    y = targetPosition.top + window.pageYOffset - window.innerHeight * topScalar + targetHeight * topScalar;
    x -= leftOffset;
    y -= topOffset;
    differenceX = x - window.pageXOffset;
    differenceY = y - window.pageYOffset;
  } else {
    targetWidth = targetPosition.width;
    targetHeight = targetPosition.height;
    parentPosition = parent.getBoundingClientRect();
    let offsetLeft = targetPosition.left - (parentPosition.left - parent.scrollLeft);
    let offsetTop = targetPosition.top - (parentPosition.top - parent.scrollTop);
    x = offsetLeft + targetWidth * leftScalar - parent.clientWidth * leftScalar;
    y = offsetTop + targetHeight * topScalar - parent.clientHeight * topScalar;
    x = Math.max(Math.min(x, parent.scrollWidth - parent.clientWidth), 0);
    y = Math.max(Math.min(y, parent.scrollHeight - parent.clientHeight), 0);
    x -= leftOffset;
    y -= topOffset;
    differenceX = x - parent.scrollLeft;
    differenceY = y - parent.scrollTop;
  }
  return {
    x,
    y,
    differenceX,
    differenceY
  };
}
function animate(parent) {
  requestAnimation$1(function() {
    let scrollSettings = parent.scrollOption;
    if (!scrollSettings) {
      return;
    }
    let location = getTargetScrollLocation(scrollSettings.target, parent, scrollSettings.align);
    let time = Date.now() - scrollSettings.startTime;
    let timeValue = Math.min(1 / scrollSettings.time * time, 1);
    if (time > scrollSettings.time + 20) {
      setElementScroll(parent, location.x, location.y);
      parent.scrollOption = null;
      return scrollSettings.end(COMPLETE);
    }
    let easeValue = 1 - scrollSettings.ease(timeValue);
    setElementScroll(
      parent,
      location.x - location.differenceX * easeValue,
      location.y - location.differenceY * easeValue
    );
    animate(parent);
  });
}
function transitionScrollTo(target, parent, settings, callback) {
  let idle = !parent.scrollOption;
  let lastSettings = parent.scrollOption;
  let now2 = Date.now();
  let endHandler;
  if (lastSettings) {
    lastSettings.end(CANCELED);
  }
  function end(endType) {
    parent.scrollOption = null;
    if (parent.parentElement && parent.parentElement.scrollOption) {
      parent.parentElement.scrollOption.end(endType);
    }
    callback(endType);
    parent.removeEventListener("touchstart", endHandler);
  }
  parent.scrollOption = {
    startTime: lastSettings ? lastSettings.startTime : Date.now(),
    target,
    time: settings.time + (lastSettings ? now2 - lastSettings.startTime : 0),
    ease: settings.ease,
    align: settings.align,
    end
  };
  endHandler = end.bind(null, CANCELED);
  parent.addEventListener("touchstart", endHandler);
  if (idle) {
    animate(parent);
  }
}
function defaultIsScrollable(element) {
  if (!isClient)
    return;
  return element === window || (element.scrollHeight !== element.clientHeight || element.scrollWidth !== element.clientWidth) && getComputedStyle(element).overflow !== "hidden";
}
function defaultValidTarget() {
  return true;
}
function index$1(target, settings, callback) {
  if (!target) {
    return;
  }
  if (typeof settings === "function") {
    callback = settings;
    settings = null;
  }
  if (!settings) {
    settings = {};
  }
  settings.time = isNaN(settings.time) ? 1e3 : settings.time;
  settings.ease = settings.ease || function(v) {
    return 1 - Math.pow(1 - v, v / 2);
  };
  let parent = target.parentElement;
  let parents = 0;
  function done(endType) {
    parents -= 1;
    if (!parents && callback) {
      callback(endType);
    }
  }
  let validTarget = settings.validTarget || defaultValidTarget;
  let isScrollable = settings.isScrollable;
  while (parent) {
    if (validTarget(parent, parents) && (isScrollable ? isScrollable(parent, defaultIsScrollable) : defaultIsScrollable(parent))) {
      parents += 1;
      transitionScrollTo(target, parent, settings, done);
    }
    parent = parent.parentElement;
    if (!parent) {
      return;
    }
    if (parent.tagName === "BODY") {
      parent = window;
    }
  }
}
function requestAnimation(task) {
  if (isClient && "requestAnimationFrame" in window) {
    return window.requestAnimationFrame(task);
  }
  setTimeout(task, 16);
}
function index(el, settings, callback) {
  if (!el) {
    return;
  }
  if (typeof settings === "function") {
    callback = settings;
    settings = null;
  }
  if (!settings) {
    settings = {};
  }
  settings.time = isNaN(settings.time) ? 500 : settings.time;
  const from = el.scrollTop;
  const to = settings.to || 0;
  const difference = Math.abs(from - to);
  const step = Math.ceil(difference / settings.time * 50);
  function scroll2(start, end, step2) {
    if (start === end) {
      callback && callback();
      return;
    }
    let d = start + step2 > end ? end : start + step2;
    if (start > end) {
      d = start - step2 < end ? end : start - step2;
    }
    el.scrollTop = d;
    requestAnimation(() => scroll2(d, end, step2));
  }
  scroll2(from, to, step);
}
const prefixCls$f = "ivu-layout-sider";
setMatchMedia();
const _sfc_main$A = {
  name: "Sider",
  emits: ["on-collapse", "update:modelValue"],
  props: {
    modelValue: {
      type: Boolean,
      default: false
    },
    width: {
      type: [Number, String],
      default: 200
    },
    collapsedWidth: {
      type: [Number, String],
      default: 64
    },
    hideTrigger: {
      type: Boolean,
      default: false
    },
    breakpoint: {
      type: String,
      validator(val) {
        return oneOf(val, ["xs", "sm", "md", "lg", "xl", "xxl"]);
      }
    },
    collapsible: {
      type: Boolean,
      default: false
    },
    defaultCollapsed: {
      type: Boolean,
      default: false
    },
    reverseArrow: {
      type: Boolean,
      default: false
    }
  },
  data() {
    return {
      prefixCls: prefixCls$f,
      mediaMatched: false
    };
  },
  computed: {
    wrapClasses() {
      return [
        `${prefixCls$f}`,
        this.siderWidth ? "" : `${prefixCls$f}-zero-width`,
        this.modelValue ? `${prefixCls$f}-collapsed` : ""
      ];
    },
    wrapStyles() {
      return {
        width: `${this.siderWidth}px`,
        minWidth: `${this.siderWidth}px`,
        maxWidth: `${this.siderWidth}px`,
        flex: `0 0 ${this.siderWidth}px`
      };
    },
    triggerClasses() {
      return [
        `${prefixCls$f}-trigger`,
        this.modelValue ? `${prefixCls$f}-trigger-collapsed` : ""
      ];
    },
    childClasses() {
      return `${this.prefixCls}-children`;
    },
    zeroWidthTriggerClasses() {
      return [
        `${prefixCls$f}-zero-width-trigger`,
        this.reverseArrow ? `${prefixCls$f}-zero-width-trigger-left` : ""
      ];
    },
    triggerIconClasses() {
      return [
        "ivu-icon",
        `ivu-icon-ios-arrow-${this.reverseArrow ? "forward" : "back"}`,
        `${prefixCls$f}-trigger-icon`
      ];
    },
    siderWidth() {
      return this.collapsible ? this.modelValue ? this.mediaMatched ? 0 : parseInt(this.collapsedWidth) : parseInt(this.width) : this.width;
    },
    showZeroTrigger() {
      return this.collapsible ? this.mediaMatched && !this.hideTrigger || parseInt(this.collapsedWidth) === 0 && this.modelValue && !this.hideTrigger : false;
    },
    showBottomTrigger() {
      return this.collapsible ? !this.mediaMatched && !this.hideTrigger : false;
    }
  },
  methods: {
    toggleCollapse() {
      let modelValue = this.collapsible ? !this.modelValue : false;
      this.$emit("update:modelValue", modelValue);
    },
    matchMedia() {
      if (!isClient)
        return;
      let matchMedia;
      if (window.matchMedia) {
        matchMedia = window.matchMedia;
      }
      let mediaMatched = this.mediaMatched;
      this.mediaMatched = matchMedia(`(max-width: ${dimensionMap[this.breakpoint]})`).matches;
      if (this.mediaMatched !== mediaMatched) {
        this.$emit("update:modelValue", this.mediaMatched);
      }
    },
    onWindowResize() {
      this.matchMedia();
    }
  },
  watch: {
    modelValue(state) {
      this.$emit("on-collapse", state);
    }
  },
  mounted() {
    if (this.defaultCollapsed) {
      this.$emit("update:modelValue", this.defaultCollapsed);
    }
    if (this.breakpoint !== void 0) {
      on(window, "resize", this.onWindowResize);
      this.matchMedia();
    }
  },
  beforeUnmount() {
    if (this.breakpoint !== void 0) {
      off(window, "resize", this.onWindowResize);
    }
  }
};
function _sfc_render$t(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.wrapClasses),
    style: normalizeStyle($options.wrapStyles)
  }, [
    withDirectives(createElementVNode("span", {
      onClick: _cache[0] || (_cache[0] = (...args) => $options.toggleCollapse && $options.toggleCollapse(...args)),
      class: normalizeClass($options.zeroWidthTriggerClasses)
    }, _cache[2] || (_cache[2] = [
      createElementVNode("i", { class: "ivu-icon ivu-icon-ios-menu" }, null, -1)
    ]), 2), [
      [vShow, $options.showZeroTrigger]
    ]),
    createElementVNode("div", {
      class: normalizeClass($options.childClasses)
    }, [
      renderSlot(_ctx.$slots, "default")
    ], 2),
    renderSlot(_ctx.$slots, "trigger", {}, () => [
      withDirectives(createElementVNode("div", {
        class: normalizeClass($options.triggerClasses),
        onClick: _cache[1] || (_cache[1] = (...args) => $options.toggleCollapse && $options.toggleCollapse(...args)),
        style: normalizeStyle({ width: $options.siderWidth + "px" })
      }, [
        createElementVNode("i", {
          class: normalizeClass($options.triggerIconClasses)
        }, null, 2)
      ], 6), [
        [vShow, $options.showBottomTrigger]
      ])
    ])
  ], 6);
}
var Sider = /* @__PURE__ */ _export_sfc(_sfc_main$A, [["render", _sfc_render$t]]);
const prefixCls$e = "ivu-skeleton-item";
const _sfc_main$z = {
  name: "SkeletonItem",
  components: { Icon },
  inject: {
    SkeletonInstance: {
      default: null
    }
  },
  props: {
    animated: {
      type: Boolean,
      default: false
    },
    type: {
      validator(value) {
        return oneOf(value, ["circle", "square", "rect", "image"]);
      },
      default: "rect"
    },
    size: {
      validator(value) {
        return oneOf(value, ["small", "large", "default"]);
      },
      default() {
        const global2 = getCurrentInstance().appContext.config.globalProperties;
        return !global2.$VIEWUI || global2.$VIEWUI.size === "" ? "default" : global2.$VIEWUI.size;
      }
    },
    width: {
      type: [String, Number]
    },
    height: {
      type: [String, Number]
    },
    block: {
      type: Boolean,
      default: false
    },
    imgSrc: {
      type: String
    }
  },
  data() {
    return {
      prefixCls: prefixCls$e
    };
  },
  computed: {
    classes() {
      return [
        prefixCls$e,
        prefixCls$e + "-" + this.type,
        prefixCls$e + "-" + this.type + "-" + this.size,
        {
          [prefixCls$e + "-animated"]: this.animated || Boolean(this.SkeletonInstance) && this.SkeletonInstance.animated,
          [prefixCls$e + "-inline"]: !this.block,
          [prefixCls$e + "-with-image"]: this.showImage,
          [prefixCls$e + "-round"]: Boolean(this.SkeletonInstance) && this.SkeletonInstance.round
        }
      ];
    },
    styles() {
      const styleObj = {};
      if (["rect", "image"].includes(this.type)) {
        if (this.width) {
          styleObj.width = typeof this.width === "number" ? `${this.width}px` : this.width;
        }
        if (this.height) {
          styleObj.height = typeof this.height === "number" ? `${this.height}px` : this.height;
        }
        if (this.showImage) {
          styleObj.background = `no-repeat url(${this.imgSrc}) center center`;
          styleObj.backgroundSize = "contain";
        }
      }
      return styleObj;
    },
    showIcon() {
      return this.type === "image" && !this.imgSrc;
    },
    showImage() {
      return this.type === "image" && Boolean(this.imgSrc);
    },
    iconSize() {
      let iconSize = 16;
      if (this.size === "large")
        iconSize = 32;
      if (this.size === "small")
        iconSize = 10;
      return iconSize;
    }
  }
};
function _sfc_render$s(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = resolveComponent("Icon");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass($options.classes),
    style: normalizeStyle($options.styles)
  }, [
    $options.showIcon ? (openBlock(), createBlock(_component_Icon, {
      key: 0,
      class: normalizeClass($data.prefixCls + "-image-icon"),
      type: "ios-image",
      size: $options.iconSize
    }, null, 8, ["class", "size"])) : createCommentVNode("", true)
  ], 6);
}
var SkeletonItem = /* @__PURE__ */ _export_sfc(_sfc_main$z, [["render", _sfc_render$s]]);
const prefixCls$d = "ivu-skeleton";
const _sfc_main$y = {
  name: "Skeleton",
  components: { SkeletonItem, Row, Col },
  provide() {
    return {
      SkeletonInstance: this
    };
  },
  props: {
    animated: {
      type: Boolean,
      default: false
    },
    loading: {
      type: Boolean,
      default: false
    },
    round: {
      type: Boolean,
      default: false
    },
    paragraph: {
      validator(value) {
        if (typeof value === "number") {
          return value >= 1;
        }
        return typeof value.rows === "number" && value.rows >= 1;
      },
      type: [Number, Object],
      default: 3
    },
    title: {
      validator(value) {
        if (typeof value === "object") {
          if (value.width)
            return ["number", "string"].includes(typeof value.width);
        }
        return true;
      },
      type: [Boolean, Object],
      default: true
    },
    avatar: {
      validator(value) {
        if (typeof value === "object") {
          if (value.type)
            return oneOf(value.type, ["circle", "square"]);
          if (value.size)
            return oneOf(value.size, ["small", "large", "default"]);
        }
        return true;
      },
      type: [Boolean, Object],
      default: false
    }
  },
  data() {
    return {
      prefixCls: prefixCls$d
    };
  },
  computed: {
    classes() {
      return [
        prefixCls$d,
        {
          [prefixCls$d + "-with-title"]: this.showTitle,
          [prefixCls$d + "-with-avatar"]: this.showAvatar
        }
      ];
    },
    rows() {
      if (typeof this.paragraph === "number") {
        return this.paragraph;
      }
      return this.paragraph.rows;
    },
    rowsCount() {
      return this.rows + Number(this.showTitle);
    },
    showTitle() {
  