/// <reference types="react" />
import { TableComponents, VtOpts } from './vt';
/**
 * @example
 *
 * function MyTableComponent() {
 *
 * // ... your code
 *
 *
 * const y = 600;
 * const [ vt, setComponents, vtRef ] = useVT(() => ({
 *  scroll: {
 *    y
 *  }
 * }),
 * [y]);
 *
 * // useEffect(() => {
 * //  setComponents({
 * //    body: {
 * //      cell: MyCell,
 * //    }
 * //  })
 * // });
 *
 * // useEffect(() => vtRef.current.toScroll(100), []);
 *
 * return (
 *  <Table
 *   columns={columns}
 *   dataSource={dataSource}
 *   scroll={{ x: 1000, y }}
 *   components={vt}
 *  />
 * );
 * }
 */
declare function useVT(fnOpts: () => VtOpts, deps: React.DependencyList): [
    TableComponents,
    (components: TableComponents) => void,
    Required<VtOpts>['ref']
];
export { useVT };
