var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/vt.tsx
var vt_exports = {};
__export(vt_exports, {
  _set_components: () => _set_components,
  init: () => init
});
module.exports = __toCommonJS(vt_exports);
var import_react = require("react");
var React = __toESM(require("react"));
var SCROLLEVT_NULL = 0 << 0;
var SCROLLEVT_INIT = 1 << 0;
var SCROLLEVT_RECOMPUTE = 1 << 1;
var SCROLLEVT_NATIVE = 1 << 3;
var SCROLLEVT_BY_HOOK = 1 << 6;
var TOP_CONTINUE = 0;
var TOP_DONE = 1;
function default_context() {
  return {
    vt_state: 1 /* INIT */,
    possible_hight_per_tr: -1,
    computed_h: 0,
    re_computed: 0,
    row_height: [],
    row_count: 0,
    prev_row_count: 0,
    _offset_top: 0 | 0,
    _offset_head: 0 | 0,
    _offset_tail: 0 | 1,
    WH: 0,
    // the wrapper's height
    top: 0,
    left: 0,
    evt: SCROLLEVT_NULL,
    end: false,
    final_top: 0,
    f_final_top: TOP_DONE,
    update_count: 0,
    indexMap: /* @__PURE__ */ new WeakMap(),
    HND_PAINT: 0,
    retry_count: 5
  };
}
function helper_diagnosis(ctx) {
  if (Object.prototype.hasOwnProperty.call(ctx, "CLICK~__DIAGNOSIS__"))
    return;
  function diagnosis(flag) {
    let expect_height = 0;
    for (let i = 0; i < ctx.row_count; ++i) {
      expect_height += ctx.row_height[i];
    }
    let color, explain;
    if (expect_height > ctx.computed_h) {
      color = "color:rgb(15, 179, 9)";
      explain = "lower than expected";
    } else if (expect_height < ctx.computed_h) {
      color = "color:rgb(202, 61, 81)";
      explain = "higher than expected";
    } else {
      color = "color:rgba(0, 0, 0, 0.85)";
      explain = "normal";
    }
    const ret = ctx.computed_h - expect_height;
    if (flag) {
      console.debug("OoOoOoO DIAGNOSIS OoOoOoO");
      console.debug(`%c%d(%d)(${explain})`, color, expect_height, ctx.computed_h - expect_height);
      console.debug("OoOoOoOoOoOoOOoOoOoOoOoOo");
    }
    return ret;
  }
  Object.defineProperty(ctx, "CLICK~__DIAGNOSIS__", {
    get() {
      diagnosis(true);
    },
    configurable: false,
    enumerable: false
  });
  function cb() {
    if (diagnosis(false) !== 0) {
      window.alert("vt: an error occurred!");
      return;
    }
    window.requestIdleCallback ? window.requestIdleCallback(cb) : window.setTimeout(cb);
  }
  ctx.debug && cb();
}
function log_debug(ctx, msg) {
  if (ctx.debug) {
    if (msg[0] === "+") {
      return console.debug(msg.slice(1));
    }
    const d = new Date();
    const tid = `${d.toLocaleTimeString()}.${d.getMilliseconds()}`;
    console.debug(`%c[${ctx.id}][${tid}][${msg}]`, "color:#a00", ctx);
  }
}
var TableImpl = React.forwardRef(function TableImpl2(props, ref) {
  return /* @__PURE__ */ React.createElement("table", { ref, ...props });
});
function WrapperImpl(props) {
  return /* @__PURE__ */ React.createElement("tbody", { ...props });
}
var RowImpl = React.forwardRef(function RowImpl2(props, ref) {
  return /* @__PURE__ */ React.createElement("tr", { ref, ...props });
});
function scroll_with_offset(ctx, top) {
  const {
    row_height,
    row_count,
    overscanRowCount
  } = ctx;
  ctx._scroll_y = ctx.scroll.y;
  if (typeof ctx._scroll_y === "number") {
    ctx._y = ctx._scroll_y;
  } else if (typeof ctx._scroll_y === "string") {
    ctx._y = ctx.wrap_inst.current.parentElement.offsetHeight;
  } else {
    console.assert(false, "VT: did you forget to set `scroll.y`?");
    ctx._y = ctx.wrap_inst.current.parentElement.offsetHeight;
  }
  console.assert(ctx._y >= 0);
  let _top = 0, i = 0, j = 0;
  let torender_h = 0;
  if (top === -1 && row_count > 0) {
    i = row_count;
    while (i > 0 && torender_h < ctx._y) {
      torender_h += row_height[--i];
    }
    return [0 | i, 0 | row_count, 0 | ctx.computed_h - torender_h];
  }
  for (; i < row_count && _top < top; ++i) {
    _top += row_height[i];
  }
  j = i;
  for (; j < row_count && torender_h < ctx._y; ++j) {
    torender_h += row_height[j];
  }
  let overscan = overscanRowCount < 0 ? 0 : overscanRowCount;
  while (i > 0 && overscan--) {
    _top -= row_height[--i];
  }
  j += overscanRowCount;
  if (j > row_count)
    j = row_count;
  return [0 | i, 0 | j, 0 | _top];
}
function set_offset(ctx, top, head, tail) {
  ctx._offset_top = 0 | top;
  ctx._offset_head = 0 | head;
  ctx._offset_tail = 0 | tail;
}
function set_scroll(ctx, top, left, evt, end) {
  ctx.top = top;
  ctx.left = left;
  ctx.evt = evt;
  ctx.end = end;
}
function scroll_to(ctx, top, left) {
  if (!ctx.wrap_inst.current)
    return;
  const ele = ctx.wrap_inst.current.parentElement;
  ele.scrollTop = top;
  ele.scrollLeft = Math.max(left, ele.scrollLeft);
}
function repainting(ctx) {
  if (ctx.HND_PAINT)
    return;
  const { cq, wrap_inst } = ctx;
  const fn = () => {
    ctx.HND_PAINT = 0;
    for (let i = 0; i < cq.length; ++i) {
      if (cq[i].index >= ctx._offset_head && cq[i].index < ctx._offset_tail) {
        cq[i].func();
      }
    }
    if (ctx.vt_state !== 4 /* RUNNING */ || !wrap_inst.current)
      return;
    const h = ctx.computed_h;
    if (ctx.WH === h)
      return;
    ctx.WH = h;
    const s = wrap_inst.current.style;
    s.height = h ? (s.maxHeight = h + "px", s.maxHeight) : (s.maxHeight = "unset", s.maxHeight);
    ctx.on_update_wrap_style();
  };
  ctx.HND_PAINT = ctx.evt === SCROLLEVT_NATIVE ? window.requestAnimationFrame(fn) : window.setTimeout(fn);
}
function srs_expand(ctx, len, prev_len, fill_value) {
  const slen = len - prev_len;
  const shadow_rows = new Array(slen).fill(fill_value);
  ctx.row_height = ctx.row_height.concat(shadow_rows);
  ctx.computed_h += slen * fill_value;
}
function srs_shrink(ctx, len, prev_len) {
  if (len === 0) {
    ctx.computed_h = 0;
    ctx.row_height.length = 0;
    ctx.top = 0;
    return;
  }
  const rows = ctx.row_height;
  let h2shrink = 0;
  for (let i = len; i < prev_len; ++i) {
    h2shrink += rows[i];
  }
  ctx.computed_h -= h2shrink;
}
function set_tr_cnt(ctx, n) {
  ctx.re_computed = n - ctx.row_count;
  ctx.prev_row_count = ctx.row_count;
  ctx.row_count = n;
}
var VTable = (props, ref) => {
  const { style, context, ...rest } = props;
  const force = (0, import_react.useState)(0);
  const ref_func = (0, import_react.useRef)(() => {
  });
  let scroll_hook;
  const wrap_inst = (0, import_react.useMemo)(() => React.createRef(), []);
  const ctx = (0, import_react.useContext)(context);
  (0, import_react.useMemo)(() => {
    Object.assign(ctx, default_context());
    if (ctx.wrap_inst && ctx.wrap_inst.current) {
      ctx.wrap_inst.current.parentElement.removeEventListener("scroll", scroll_hook);
    }
    ctx.wrap_inst = wrap_inst;
    ctx.top = ctx.initTop;
    ctx.on_update_wrap_style = () => {
      if (ctx._y === 0 && `${ctx._scroll_y}`.length) {
        scroll_hook({
          flag: SCROLLEVT_BY_HOOK,
          target: {
            scrollTop: ctx.top,
            scrollLeft: ctx.left
          }
        });
      }
    };
    if (process.env.NODE_ENV !== "production")
      helper_diagnosis(ctx);
    ctx.cq = [];
    let pfirst = 0;
    let circleBufferSize = 0;
    ctx.cq.push = (item) => {
      if (ctx.vt_state !== 4 /* RUNNING */)
        return;
      const size = ctx._offset_tail - ctx._offset_head + ctx.overscanRowCount * 2 + 10;
      circleBufferSize = Math.max(circleBufferSize, size);
      if (pfirst > circleBufferSize) {
        pfirst = 0;
      }
      ctx.cq[pfirst++] = item;
      return 0;
    };
  }, []);
  const event_queue = (0, import_react.useRef)([]).current;
  let RAF_update_self;
  scroll_hook = (0, import_react.useCallback)((ev) => {
    if (ctx.vt_state !== 4 /* RUNNING */)
      return;
    const t0 = performance.now();
    if (ev) {
      if ("flag" in ev) {
        event_queue.push(ev);
      } else {
        const target = ev.target;
        const top = Math.max(target.scrollTop, 0);
        event_queue.push({
          target: {
            scrollTop: top,
            scrollLeft: target.scrollLeft
          },
          end: Math.abs(target.scrollHeight - target.clientHeight - Math.round(top)) <= (ctx.offset || 0),
          flag: SCROLLEVT_NATIVE
        });
      }
      if (ctx.f_final_top === TOP_CONTINUE) {
        return RAF_update_self(t0);
      }
    }
    if (ctx.HND_RAF)
      return;
    ctx.HND_RAF = window.setTimeout(() => Promise.resolve().then(() => RAF_update_self(t0)));
  }, []);
  RAF_update_self = (0, import_react.useCallback)((time) => {
    ctx.HND_RAF = 0;
    const t1 = performance.now();
    if (t1 - time > 10 && ctx.retry_count-- > 0) {
      scroll_hook();
      return;
    }
    ctx.retry_count = 5;
    if (ctx.vt_state !== 4 /* RUNNING */)
      return;
    const evq = event_queue;
    let e;
    if (!evq.length) {
      return;
    }
    e = evq.pop();
    evq.length = 0;
    let etop = e.target.scrollTop;
    let eleft = e.target.scrollLeft;
    const flag = e.flag;
    log_debug(ctx, `top: ${etop}, left: ${eleft}`);
    const offset = scroll_with_offset(
      ctx,
      ctx.f_final_top === TOP_CONTINUE ? ctx.final_top : etop
    );
    const head = offset[0];
    const tail = offset[1];
    const top = offset[2];
    const prev_head = ctx._offset_head;
    const prev_tail = ctx._offset_tail;
    const prev_top = ctx._offset_top;
    let end = false;
    switch (flag) {
      case SCROLLEVT_INIT:
        log_debug(ctx, "SCROLLEVT_INIT");
        break;
      case SCROLLEVT_BY_HOOK:
        log_debug(ctx, "SCROLLEVT_BY_HOOK");
        if (head === prev_head && tail === prev_tail && top === prev_top) {
          ctx.f_final_top = TOP_DONE;
          if (ctx.final_top === -1)
            etop = ctx.computed_h - ctx._y;
          end = true;
        } else {
          if (ctx.final_top === -1)
            etop = top;
        }
        break;
      case SCROLLEVT_RECOMPUTE:
        if (head === prev_head && tail === prev_tail && top === prev_top) {
          return;
        }
        log_debug(ctx, "SCROLLEVT_RECOMPUTE");
        break;
      case SCROLLEVT_NATIVE:
        if (head === prev_head && tail === prev_tail && top === prev_top) {
          return;
        }
        log_debug(ctx, "SCROLLEVT_NATIVE");
        if (ctx.onScroll) {
          ctx.onScroll({
            top: etop,
            left: eleft,
            isEnd: e.end
          });
        }
        end = e.end;
        break;
    }
    set_offset(ctx, top, head, tail);
    set_scroll(ctx, etop, eleft, flag, end);
    force[1](++ctx.update_count);
  }, []);
  (0, import_react.useImperativeHandle)(ref, () => {
    const scrollTo = (y) => {
      ctx.f_final_top = TOP_CONTINUE;
      ctx.final_top = y;
      scroll_hook({
        target: { scrollTop: y, scrollLeft: -1 },
        flag: SCROLLEVT_BY_HOOK
      });
    };
    return {
      scrollTo: (y) => {
        ref_func.current = () => scrollTo(y);
        ref_func.current();
      },
      scrollToIndex: (idx) => {
        ref_func.current = () => {
          if (idx > ctx.row_count - 1)
            idx = ctx.row_count - 1;
          if (idx < 0)
            idx = 0;
          let y = 0;
          for (let i = 0; i < idx; ++i) {
            y += ctx.row_height[i];
          }
          scrollTo(y);
        };
        ref_func.current();
      }
    };
  }, []);
  (0, import_react.useEffect)(() => {
    const el = wrap_inst.current.parentElement;
    try {
      el.addEventListener("scroll", scroll_hook, {
        passive: true
      });
    } catch {
      el.addEventListener("scroll", scroll_hook, false);
    }
  }, [wrap_inst.current]);
  (0, import_react.useEffect)(() => {
    scroll_hook({
      flag: SCROLLEVT_BY_HOOK,
      target: {
        scrollLeft: ctx.left,
        scrollTop: ctx.top
      }
    });
  }, [ctx.scroll.y]);
  (0, import_react.useEffect)(() => {
    switch (ctx.evt) {
      case SCROLLEVT_BY_HOOK:
        if (ctx.f_final_top === TOP_CONTINUE) {
          ref_func.current();
        } else {
          scroll_to(ctx, ctx.top, ctx.left);
        }
        break;
      case SCROLLEVT_INIT:
      case SCROLLEVT_RECOMPUTE:
        scroll_to(ctx, ctx.top, ctx.left);
        break;
    }
  }, [
    force[0]
    /* for performance. */
  ]);
  (0, import_react.useEffect)(() => {
    switch (ctx.vt_state) {
      case 2 /* LOADED */:
        ctx.vt_state = 4 /* RUNNING */;
        scroll_hook({
          target: { scrollTop: ctx.top, scrollLeft: 0 },
          flag: SCROLLEVT_BY_HOOK
        });
        break;
      case 4 /* RUNNING */:
        if (ctx.re_computed !== 0) {
          ctx.re_computed = 0;
          scroll_hook({
            target: { scrollTop: ctx.top, scrollLeft: ctx.left },
            flag: SCROLLEVT_RECOMPUTE
          });
        }
        break;
    }
  });
  const wrapStyle = (0, import_react.useMemo)(
    () => ({
      width: style.width,
      minWidth: "100%",
      position: "relative",
      transform: "translate(0)"
    }),
    [style.width]
  );
  const tableStyle = (0, import_react.useMemo)(
    () => ({
      ...style,
      width: void 0,
      position: "relative",
      top: ctx._offset_top,
      transform: "translate(0)"
    }),
    [ctx._offset_top]
  );
  const internalCtx = (0, import_react.useMemo)(() => ({ ...ctx }), [ctx.update_count]);
  const Table = ctx.components.table;
  return /* @__PURE__ */ React.createElement(
    "div",
    {
      ref: wrap_inst,
      style: wrapStyle
    },
    /* @__PURE__ */ React.createElement(context.Provider, { value: internalCtx }, /* @__PURE__ */ React.createElement(Table, { ...rest, style: tableStyle }))
  );
};
var VWrapper = (props) => {
  const { children, className, ctx } = props;
  const measureRow = children[0];
  const rows = children[1];
  let len = Array.isArray(rows) ? rows.length : 0;
  let { _offset_head: head, _offset_tail: tail } = ctx;
  let trs = [];
  switch (ctx.vt_state) {
    case 1 /* INIT */:
      if (len >= 0) {
        console.assert(head === 0);
        console.assert(tail === 1);
        if (Array.isArray(rows)) {
          trs = rows.slice(head, tail);
          ctx.indexMap.set(trs[0].props.record, 0);
        } else {
          trs = rows;
        }
        ctx.re_computed = len;
        ctx.prev_row_count = len;
        ctx.row_count = len;
      }
      break;
    case 4 /* RUNNING */:
      {
        if (tail > len) {
          const offset = tail - len;
          tail -= offset;
          head -= offset;
          if (head < 0)
            head = 0;
          if (tail < 0)
            tail = 0;
          set_offset(
            ctx,
            ctx._offset_top,
            head,
            tail
          );
        }
        if (ctx.row_count !== len) {
          set_tr_cnt(ctx, len);
        }
        len = ctx.row_count;
        const prev_len = ctx.prev_row_count;
        if (len < prev_len) {
          srs_shrink(ctx, len, prev_len);
        } else if (len > prev_len) {
          const row_h = ctx.row_height;
          if (len - row_h.length > 0) {
            srs_expand(ctx, len, prev_len, ctx.possible_hight_per_tr);
          } else {
            row_h.fill(ctx.possible_hight_per_tr, prev_len, len);
            ctx.computed_h += ctx.possible_hight_per_tr * (len - prev_len);
          }
        }
        if (len) {
          let idx = head;
          trs = rows.slice(idx, tail);
          trs.forEach((el) => ctx.indexMap.set(el.props.record, idx++));
        } else {
          trs = rows;
        }
        ctx.prev_row_count = ctx.row_count;
      }
      break;
    case 2 /* LOADED */:
      console.assert(false);
      break;
  }
  const Wrapper = ctx.components.body.wrapper;
  return /* @__PURE__ */ React.createElement(Wrapper, { className }, measureRow, trs);
};
var VTRow = (props) => {
  const ref = React.createRef();
  const { ctx, ...rest } = props;
  const children = props.children;
  const Row = ctx.components.body.row;
  if (!Array.isArray(children)) {
    return /* @__PURE__ */ React.createElement(Row, { ...rest }, children);
  }
  const row_props = children[0].props;
  const index = ctx.indexMap.get(row_props.record);
  const last_index = (0, import_react.useRef)(index);
  const expanded_cls = (0, import_react.useMemo)(() => `.${row_props.prefixCls}-expanded-row`, [row_props.prefixCls]);
  const t0 = performance.now();
  (0, import_react.useLayoutEffect)(() => {
    const t1 = performance.now();
    log_debug(ctx, `+idx ${index} tooks ${t1 - t0} ms`);
    if (ctx.vt_state === 4 /* RUNNING */) {
      repainting(ctx);
    } else {
      ctx.possible_hight_per_tr = ref.current.offsetHeight;
      srs_expand(ctx, ctx.row_count, 0, ctx.possible_hight_per_tr);
      repainting(ctx);
      ctx.vt_state = 2 /* LOADED */;
    }
    return () => {
      repainting(ctx);
    };
  }, []);
  (0, import_react.useEffect)(() => {
    ctx.cq.push({
      index,
      func: () => {
        const rowElm = ref.current;
        if (!rowElm)
          return;
        let h = rowElm.offsetHeight;
        let sibling = rowElm.nextSibling;
        while (sibling && sibling.matches(expanded_cls)) {
          h += sibling.offsetHeight;
          sibling = sibling.nextSibling;
        }
        const curr_h = ctx.row_height[index];
        const last_h = ctx.row_height[last_index.current];
        ctx.computed_h -= curr_h;
        ctx.computed_h += last_h;
        ctx.computed_h += h - last_h;
        ctx.row_height[index] = h;
      }
    });
    repainting(ctx);
  });
  return /* @__PURE__ */ React.createElement(Row, { ...rest, ref });
};
function _set_components(ctx, components) {
  const { table, body, header } = components;
  ctx.components.body = { ...ctx.components.body, ...body };
  if (body && body.cell) {
    ctx._vtcomponents.body.cell = body.cell;
  }
  if (header) {
    ctx.components.header = header;
    ctx._vtcomponents.header = header;
  }
  if (table) {
    ctx.components.table = table;
  }
}
function init(fnOpts, deps) {
  const ctx = (0, import_react.useRef)(React.createContext({})).current;
  const ctx_value = (0, import_react.useContext)(ctx);
  const default_ref = (0, import_react.useRef)({
    scrollTo: (y) => {
    },
    scrollToIndex: (idx) => {
    }
  });
  (0, import_react.useMemo)(() => {
    return Object.assign(
      ctx_value,
      {
        id: (+new Date()).toString(36).slice(4),
        initTop: 0,
        overscanRowCount: 5,
        debug: false,
        ref: default_ref
      },
      fnOpts()
    );
  }, deps);
  (0, import_react.useMemo)(() => {
    const VT = React.forwardRef(VTable);
    ctx_value._vtcomponents = {
      table: (props) => /* @__PURE__ */ React.createElement(VT, { ...props, context: ctx, ref: ctx_value.ref }),
      body: {
        // https://github.com/react-component/table/blob/master/src/Body/index.tsx#L114
        wrapper: (props) => {
          return /* @__PURE__ */ React.createElement(ctx.Consumer, null, () => {
            return /* @__PURE__ */ React.createElement(VWrapper, { ...props, ctx: ctx_value });
          });
        },
        row: (props) => /* @__PURE__ */ React.createElement(VTRow, { ...props, ctx: ctx_value })
      }
    };
    ctx_value.components = {};
    _set_components(ctx_value, {
      table: TableImpl,
      body: {
        wrapper: WrapperImpl,
        row: RowImpl
      }
    });
    ctx_value.vt_state = 1 /* INIT */;
  }, []);
  return ctx_value;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  _set_components,
  init
});
