import * as React from 'react';
declare type CustomizeComponent = React.FC<any>;
export interface TableComponents {
    table?: CustomizeComponent;
    header?: {
        wrapper?: CustomizeComponent;
        row?: CustomizeComponent;
        cell?: CustomizeComponent;
    };
    body?: {
        wrapper?: CustomizeComponent;
        row?: CustomizeComponent;
        cell?: CustomizeComponent;
    };
}
interface RefObject {
    scrollTo: (y: number) => void;
    scrollToIndex: (idx: number) => void;
}
export interface VtOpts {
    id?: number | string;
    /**
     * @default 5
     */
    overscanRowCount?: number;
    /**
     * this only needs the scroll.y
     */
    scroll: {
        y: number | string;
    };
    /**
     * wheel event(only works on native events).
     */
    onScroll?: ({ left, top, isEnd, }: {
        top: number;
        left: number;
        isEnd: boolean;
    }) => void;
    initTop?: number;
    /**
     * Offset of the table when isEnd becomes true.
     * @default 0
     */
    offset?: number;
    /**
     * @default false
     */
    debug?: boolean;
    ref?: React.MutableRefObject<RefObject>;
}
/**
 * `INIT` -> `LOADED` -> `RUNNING`
 */
declare enum e_VT_STATE {
    INIT = 1,
    LOADED = 2,
    RUNNING = 4
}
interface VT_CONTEXT extends VtOpts {
    _y: number;
    _scroll_y: number | string;
    _vtcomponents: TableComponents;
    components: TableComponents;
    vt_state: e_VT_STATE;
    possible_hight_per_tr: number;
    re_computed: number;
    row_height: number[];
    row_count: number;
    prev_row_count: number;
    wrap_inst: React.RefObject<HTMLDivElement>;
    VTScroll?: (param?: {
        top: number;
        left: number;
    }) => {
        top: number;
        left: number;
    };
    computed_h: number;
    WH: number;
    HND_PAINT: number;
    HND_RAF: number;
    _offset_top: number;
    _offset_head: number;
    _offset_tail: number;
    top: number;
    left: number;
    evt: number;
    end: boolean;
    final_top: number;
    f_final_top: number;
    update_count: number;
    on_update_wrap_style: () => void;
    indexMap: WeakMap<object, number>;
    cq: {
        index: number;
        func: () => void;
    }[];
    retry_count: number;
}
export declare function _set_components(ctx: VT_CONTEXT, components: TableComponents): void;
export declare function init(fnOpts: () => VtOpts, deps: React.DependencyList): VT_CONTEXT;
export {};
