function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
var _excluded = ["style", "context"],
  _excluded2 = ["ctx"];
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
/* eslint-disable no-console */

/*
The MIT License (MIT)

Copyright (c) 2019 https://github.com/wubostc/

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
*/

import { useRef, useState, useCallback, useContext, useEffect, useMemo, useImperativeHandle, useLayoutEffect } from 'react';
import * as React from 'react';
/**
 * THE EVENTS OF SCROLLING.
 */
var SCROLLEVT_NULL = 0 << 0;
var SCROLLEVT_INIT = 1 << 0;
var SCROLLEVT_RECOMPUTE = 1 << 1;
var SCROLLEVT_NATIVE = 1 << 3;
var SCROLLEVT_BY_HOOK = 1 << 6;

// any events will be `SCROLLEVT_BY_HOOK` if the `ctx.f_top ===  TOP_CONTINUE`.
var TOP_CONTINUE = 0;
var TOP_DONE = 1;
/**
 * `INIT` -> `LOADED` -> `RUNNING`
 */
var e_VT_STATE;
(function (e_VT_STATE) {
  e_VT_STATE[e_VT_STATE["INIT"] = 1] = "INIT";
  e_VT_STATE[e_VT_STATE["LOADED"] = 2] = "LOADED";
  e_VT_STATE[e_VT_STATE["RUNNING"] = 4] = "RUNNING";
})(e_VT_STATE || (e_VT_STATE = {}));
function default_context() {
  return {
    vt_state: e_VT_STATE.INIT,
    possible_hight_per_tr: -1,
    computed_h: 0,
    re_computed: 0,
    row_height: [],
    row_count: 0,
    prev_row_count: 0,
    _offset_top: 0 | 0,
    _offset_head: 0 | 0,
    _offset_tail: 0 | 1,
    WH: 0,
    // the wrapper's height
    top: 0,
    left: 0,
    evt: SCROLLEVT_NULL,
    end: false,
    final_top: 0,
    f_final_top: TOP_DONE,
    update_count: 0,
    indexMap: new WeakMap(),
    HND_PAINT: 0,
    retry_count: 5
  };
}

/* overload __DIAGNOSIS__. */
function helper_diagnosis(ctx) {
  if (Object.prototype.hasOwnProperty.call(ctx, 'CLICK~__DIAGNOSIS__')) return;
  function diagnosis(flag) {
    var expect_height = 0;
    for (var i = 0; i < ctx.row_count; ++i) {
      expect_height += ctx.row_height[i];
    }
    var color, explain;
    if (expect_height > ctx.computed_h) {
      color = 'color:rgb(15, 179, 9)'; // green
      explain = 'lower than expected';
    } else if (expect_height < ctx.computed_h) {
      color = 'color:rgb(202, 61, 81)'; // red
      explain = 'higher than expected';
    } else {
      color = 'color:rgba(0, 0, 0, 0.85)';
      explain = 'normal';
    }
    var ret = ctx.computed_h - expect_height;
    if (flag) {
      console.debug('OoOoOoO DIAGNOSIS OoOoOoO');
      console.debug("%c%d(%d)(".concat(explain, ")"), color, expect_height, ctx.computed_h - expect_height);
      console.debug('OoOoOoOoOoOoOOoOoOoOoOoOo');
    }
    return ret;
  }
  Object.defineProperty(ctx, 'CLICK~__DIAGNOSIS__', {
    get: function get() {
      diagnosis(true);
    },
    configurable: false,
    enumerable: false
  });
  function cb() {
    if (diagnosis(false) !== 0) {
      window.alert('vt: an error occurred!');
      return;
    }
    window.requestIdleCallback ? window.requestIdleCallback(cb) : window.setTimeout(cb);
  }
  ctx.debug && cb();
}
function log_debug(ctx, msg) {
  if (ctx.debug) {
    if (msg[0] === '+') {
      return console.debug(msg.slice(1));
    }
    var d = new Date();
    var tid = "".concat(d.toLocaleTimeString(), ".").concat(d.getMilliseconds());
    console.debug("%c[".concat(ctx.id, "][").concat(tid, "][").concat(msg, "]"), 'color:#a00', ctx);
  }
}

/**
 * Default Implementation Layer.
 */
/** AntD.TableComponent.table */
var TableImpl = /*#__PURE__*/React.forwardRef(function TableImpl(props, ref) {
  return /*#__PURE__*/React.createElement("table", _extends({
    ref: ref
  }, props));
});
/** AntD.TableComponent.body.wrapper */
function WrapperImpl(props) {
  return /*#__PURE__*/React.createElement("tbody", props);
}
/** AntD.TableComponent.body.row */
var RowImpl = /*#__PURE__*/React.forwardRef(function RowImpl(props, ref) {
  return /*#__PURE__*/React.createElement("tr", _extends({
    ref: ref
  }, props));
});

/**
 * O(n)
 * returns offset: [head, tail, top]
 */
function scroll_with_offset(ctx, top) {
  var row_height = ctx.row_height,
    row_count = ctx.row_count,
    overscanRowCount = ctx.overscanRowCount;
  ctx._scroll_y = ctx.scroll.y;
  if (typeof ctx._scroll_y === 'number') {
    ctx._y = ctx._scroll_y;
  } else if (typeof ctx._scroll_y === 'string') {
    /* a string, like "calc(100vh - 300px)" */
    // this offsetHeight may be 0!
    ctx._y = ctx.wrap_inst.current.parentElement.offsetHeight;
  } else {
    console.assert(false, 'VT: did you forget to set `scroll.y`?');
    ctx._y = ctx.wrap_inst.current.parentElement.offsetHeight;
  }
  console.assert(ctx._y >= 0);
  // to calc `_top` with `row_height` and `overscan`.
  var _top = 0,
    i = 0,
    j = 0;
  // the height to render.
  var torender_h = 0;

  // scroll to the bottom of the table.
  if (top === -1 && row_count > 0) {
    i = row_count;
    while (i > 0 && torender_h < ctx._y) {
      torender_h += row_height[--i];
    }
    return [0 | i, 0 | row_count, 0 | ctx.computed_h - torender_h];
  }
  for (; i < row_count && _top < top; ++i) {
    _top += row_height[i];
  }

  // start j from the visible area
  j = i;
  for (; j < row_count && torender_h < ctx._y; ++j) {
    torender_h += row_height[j];
  }

  // keep offset row on top and bottom
  var overscan = overscanRowCount < 0 ? 0 : overscanRowCount;
  while (i > 0 && overscan--) {
    _top -= row_height[--i];
  }
  j += overscanRowCount;
  if (j > row_count) j = row_count;
  // returns [head, tail, top].
  return [0 | i, 0 | j, 0 | _top];
}

// set the variables for offset top/head/tail.
function set_offset(ctx, top, head, tail) {
  ctx._offset_top = 0 | top;
  ctx._offset_head = 0 | head;
  ctx._offset_tail = 0 | tail;
}
function set_scroll(ctx, top, left, evt, end) {
  ctx.top = top;
  ctx.left = left;
  ctx.evt = evt;
  ctx.end = end;
}

// scrolls the parent element to specified location.
function scroll_to(ctx, top, left) {
  if (!ctx.wrap_inst.current) return;
  var ele = ctx.wrap_inst.current.parentElement;
  /** ie */
  ele.scrollTop = top;
  ele.scrollLeft = Math.max(left, ele.scrollLeft);
}
function repainting(ctx) {
  if (ctx.HND_PAINT) return;
  var cq = ctx.cq,
    wrap_inst = ctx.wrap_inst;
  var fn = function fn() {
    ctx.HND_PAINT = 0;

    // BATCH PROCESS in once time...
    for (var i = 0; i < cq.length; ++i) {
      if (cq[i].index >= ctx._offset_head && cq[i].index < ctx._offset_tail) {
        cq[i].func();
      }
    }
    if (ctx.vt_state !== e_VT_STATE.RUNNING || !wrap_inst.current) return;
    var h = ctx.computed_h;
    if (ctx.WH === h) return;
    ctx.WH = h;
    var s = wrap_inst.current.style;
    s.height = h ? (s.maxHeight = h + 'px', s.maxHeight) : (s.maxHeight = 'unset', s.maxHeight);
    ctx.on_update_wrap_style();
  };
  ctx.HND_PAINT = ctx.evt === SCROLLEVT_NATIVE ? window.requestAnimationFrame(fn) : window.setTimeout(fn);
}
function srs_expand(ctx, len, prev_len, fill_value) {
  var slen = len - prev_len;
  var shadow_rows = new Array(slen).fill(fill_value);
  ctx.row_height = ctx.row_height.concat(shadow_rows);
  ctx.computed_h += slen * fill_value;
}
function srs_shrink(ctx, len, prev_len) {
  if (len === 0) {
    ctx.computed_h = 0;
    ctx.row_height.length = 0;
    ctx.top = 0;
    return;
  }
  var rows = ctx.row_height;
  var h2shrink = 0;
  for (var i = len; i < prev_len; ++i) {
    h2shrink += rows[i];
  }
  ctx.computed_h -= h2shrink;
}
function set_tr_cnt(ctx, n) {
  ctx.re_computed = n - ctx.row_count;
  ctx.prev_row_count = ctx.row_count;
  ctx.row_count = n;
}
var VTable = function VTable(props, ref) {
  var style = props.style,
    context = props.context,
    rest = _objectWithoutProperties(props, _excluded);

  // force update this vt.
  var force = useState(0);
  var ref_func = useRef(function () {});

  // eslint-disable-next-line prefer-const
  var scroll_hook;

  /*********** DOM ************/
  var wrap_inst = useMemo(function () {
    return /*#__PURE__*/React.createRef();
  }, []);

  /*********** context ************/
  var ctx = useContext(context);
  useMemo(function () {
    Object.assign(ctx, default_context());
    if (ctx.wrap_inst && ctx.wrap_inst.current) {
      ctx.wrap_inst.current.parentElement.removeEventListener('scroll', scroll_hook);
    }
    ctx.wrap_inst = wrap_inst;
    ctx.top = ctx.initTop;
    ctx.on_update_wrap_style = function () {
      if (ctx._y === 0 && "".concat(ctx._scroll_y).length) {
        scroll_hook({
          flag: SCROLLEVT_BY_HOOK,
          target: {
            scrollTop: ctx.top,
            scrollLeft: ctx.left
          }
        });
      }
    };
    if (process.env.NODE_ENV !== 'production') helper_diagnosis(ctx);
    ctx.cq = [];
    var pfirst = 0;
    // let plast = 0
    var circleBufferSize = 0;
    ctx.cq.push = function (item) {
      if (ctx.vt_state !== e_VT_STATE.RUNNING) return;
      var size = ctx._offset_tail - ctx._offset_head + ctx.overscanRowCount * 2 + 10;
      circleBufferSize = Math.max(circleBufferSize, size);
      if (pfirst > circleBufferSize) {
        pfirst = 0;
      }
      ctx.cq[pfirst++] = item;
      return 0;
    };
  }, []);

  /*********** scroll event ************/
  var event_queue = useRef([]).current;

  /* eslint-disable prefer-const */
  var RAF_update_self;

  /*********** scroll hook ************/
  scroll_hook = useCallback(function (ev) {
    if (ctx.vt_state !== e_VT_STATE.RUNNING) return;
    var t0 = performance.now();
    if (ev) {
      if ('flag' in ev) {
        event_queue.push(ev);
      } else {
        var target = ev.target;
        var top = Math.max(target.scrollTop, 0);
        event_queue.push({
          target: {
            scrollTop: top,
            scrollLeft: target.scrollLeft
          },
          end: Math.abs(target.scrollHeight - target.clientHeight - Math.round(top)) <= (ctx.offset || 0),
          flag: SCROLLEVT_NATIVE
        });
      }
      if (ctx.f_final_top === TOP_CONTINUE) {
        return RAF_update_self(t0);
      }
    }
    if (ctx.HND_RAF) return;
    ctx.HND_RAF = window.setTimeout(function () {
      return Promise.resolve().then(function () {
        return RAF_update_self(t0);
      });
    });
  }, []);

  /* requestAnimationFrame callback */
  RAF_update_self = useCallback(function (time) {
    ctx.HND_RAF = 0;
    var t1 = performance.now();
    if (t1 - time > 10 && ctx.retry_count-- > 0) {
      scroll_hook();
      return;
    }
    ctx.retry_count = 5;
    if (ctx.vt_state !== e_VT_STATE.RUNNING) return;
    var evq = event_queue;
    var e;
    if (!evq.length) {
      return;
    }

    // this always consumes the last element of the event queue.
    e = evq.pop();
    evq.length = 0;
    var etop = e.target.scrollTop;
    var eleft = e.target.scrollLeft;
    var flag = e.flag;
    log_debug(ctx, "top: ".concat(etop, ", left: ").concat(eleft));

    // checks every tr's height, which will take some time...
    var offset = scroll_with_offset(ctx, ctx.f_final_top === TOP_CONTINUE ? ctx.final_top : etop);
    var head = offset[0];
    var tail = offset[1];
    var top = offset[2];
    var prev_head = ctx._offset_head;
    var prev_tail = ctx._offset_tail;
    var prev_top = ctx._offset_top;
    var end = false;
    switch (flag) {
      case SCROLLEVT_INIT:
        log_debug(ctx, 'SCROLLEVT_INIT');
        break;
      case SCROLLEVT_BY_HOOK:
        log_debug(ctx, 'SCROLLEVT_BY_HOOK');
        if (head === prev_head && tail === prev_tail && top === prev_top) {
          ctx.f_final_top = TOP_DONE;
          if (ctx.final_top === -1) etop = ctx.computed_h - ctx._y;
          end = true;
        } else {
          if (ctx.final_top === -1) etop = top;
        }
        break;
      case SCROLLEVT_RECOMPUTE:
        if (head === prev_head && tail === prev_tail && top === prev_top) {
          return;
        }
        log_debug(ctx, 'SCROLLEVT_RECOMPUTE');
        break;
      case SCROLLEVT_NATIVE:
        if (head === prev_head && tail === prev_tail && top === prev_top) {
          return;
        }
        log_debug(ctx, 'SCROLLEVT_NATIVE');
        if (ctx.onScroll) {
          ctx.onScroll({
            top: etop,
            left: eleft,
            isEnd: e.end
          });
        }
        end = e.end;
        break;
    }
    set_offset(ctx, top, head, tail);
    set_scroll(ctx, etop, eleft, flag, end);
    force[1](++ctx.update_count);
  }, []);

  // expose to the parent components you are using.
  useImperativeHandle(ref, function () {
    // `y === -1` indicates you need to scroll to the bottom of the table.
    var _scrollTo = function scrollTo(y) {
      ctx.f_final_top = TOP_CONTINUE;
      ctx.final_top = y;
      scroll_hook({
        target: {
          scrollTop: y,
          scrollLeft: -1
        },
        flag: SCROLLEVT_BY_HOOK
      });
    };
    return {
      scrollTo: function scrollTo(y) {
        ref_func.current = function () {
          return _scrollTo(y);
        };
        ref_func.current();
      },
      scrollToIndex: function scrollToIndex(idx) {
        ref_func.current = function () {
          if (idx > ctx.row_count - 1) idx = ctx.row_count - 1;
          if (idx < 0) idx = 0;
          var y = 0;
          for (var i = 0; i < idx; ++i) {
            y += ctx.row_height[i];
          }
          _scrollTo(y);
        };
        ref_func.current();
      }
    };
  }, []);
  useEffect(function () {
    var el = wrap_inst.current.parentElement;
    try {
      el.addEventListener('scroll', scroll_hook, {
        passive: true
      });
    } catch (_unused) {
      el.addEventListener('scroll', scroll_hook, false);
    }
  }, [wrap_inst.current]);
  useEffect(function () {
    scroll_hook({
      flag: SCROLLEVT_BY_HOOK,
      target: {
        scrollLeft: ctx.left,
        scrollTop: ctx.top
      }
    });
  }, [ctx.scroll.y]);

  // update DOM style.
  useEffect(function () {
    switch (ctx.evt) {
      case SCROLLEVT_BY_HOOK:
        if (ctx.f_final_top === TOP_CONTINUE) {
          ref_func.current();
        } else {
          scroll_to(ctx, ctx.top, ctx.left);
        }
        break;
      case SCROLLEVT_INIT:
      case SCROLLEVT_RECOMPUTE:
        scroll_to(ctx, ctx.top, ctx.left);
        break;
    }
  }, [force[0] /* for performance. */]);

  useEffect(function () {
    switch (ctx.vt_state) {
      case e_VT_STATE.LOADED:
        // changed by VTRow only.
        ctx.vt_state = e_VT_STATE.RUNNING;

        // force update.
        scroll_hook({
          target: {
            scrollTop: ctx.top,
            scrollLeft: 0
          },
          flag: SCROLLEVT_BY_HOOK
        });
        break;
      case e_VT_STATE.RUNNING:
        if (ctx.re_computed !== 0) {
          // rerender
          ctx.re_computed = 0;
          scroll_hook({
            target: {
              scrollTop: ctx.top,
              scrollLeft: ctx.left
            },
            flag: SCROLLEVT_RECOMPUTE
          });
        }
        break;
    }
  });
  var wrapStyle = useMemo(function () {
    return {
      width: style.width,
      minWidth: '100%',
      position: 'relative',
      transform: 'translate(0)'
    };
  }, [style.width]);
  var tableStyle = useMemo(function () {
    return _objectSpread(_objectSpread({}, style), {}, {
      width: void 0,
      position: 'relative',
      top: ctx._offset_top,
      transform: 'translate(0)'
    });
  }, [ctx._offset_top]);
  var internalCtx = useMemo(function () {
    return _objectSpread({}, ctx);
  }, [ctx.update_count]);
  var Table = ctx.components.table;
  return /*#__PURE__*/React.createElement("div", {
    ref: wrap_inst,
    style: wrapStyle
  }, /*#__PURE__*/React.createElement(context.Provider, {
    value: internalCtx
  }, /*#__PURE__*/React.createElement(Table, _extends({}, rest, {
    style: tableStyle
  }))));
};
var VWrapper = function VWrapper(props) {
  var children = props.children,
    className = props.className,
    ctx = props.ctx;
  var measureRow = children[0];
  var rows = children[1];

  // reference https://github.com/react-component/table/blob/master/src/Body/index.tsx#L6
  var len = Array.isArray(rows) ? rows.length : 0;
  var head = ctx._offset_head,
    tail = ctx._offset_tail;
  var trs = [];
  switch (ctx.vt_state) {
    case e_VT_STATE.INIT:
      if (len >= 0) {
        console.assert(head === 0);
        console.assert(tail === 1);
        if (Array.isArray(rows)) {
          trs = rows.slice(head, tail);
          ctx.indexMap.set(trs[0].props.record, 0);
        } else {
          trs = rows;
        }
        ctx.re_computed = len;
        ctx.prev_row_count = len;
        ctx.row_count = len;
      }
      break;
    case e_VT_STATE.RUNNING:
      {
        if (tail > len) {
          var offset = tail - len;
          tail -= offset;
          head -= offset;
          if (head < 0) head = 0;
          if (tail < 0) tail = 0;
          // update the `head` and `tail`.
          set_offset(ctx, ctx._offset_top /* NOTE: invalided param, just to fill for this param */, head, tail);
        }
        if (ctx.row_count !== len) {
          set_tr_cnt(ctx, len);
        }
        len = ctx.row_count;
        var prev_len = ctx.prev_row_count;

        /* shadow-rows rendering phase. */
        if (len < prev_len) {
          srs_shrink(ctx, len, prev_len);
        } else if (len > prev_len) {
          var row_h = ctx.row_height;
          if (len - row_h.length > 0) {
            srs_expand(ctx, len, prev_len, ctx.possible_hight_per_tr);
          } else {
            // using an existing array.
            row_h.fill(ctx.possible_hight_per_tr, prev_len, len);
            ctx.computed_h += ctx.possible_hight_per_tr * (len - prev_len);
          }
        }

        /**
         * tree-structure if indent is not 0
         *        |  idx
         *        |   0   || 0a                                 0  || 0a
         *        |   1   || 0b     --collapse occurred--       1  || 0b
         *        |   2   || - 1                             5->2  || 0c
         *  head  |   3   || - 1                             6->3  || 0d
         *        |   4   ||   - 2                           7->4  || 0e
         *        |   5   || 0c                              8->5  || - 1
         *        |   6   || 0d                              9->6  ||   - 2
         *        |   7   || 0e                             10->7  ||     - 3
         *  tail  |   8   || - 1                            11->8  || 0f
         *        |   9   ||  - 2
         *        |  10   ||    - 3
         *        |  11   || 0f
         *        |  12   ||
         */
        if (len) {
          var _idx = head;
          trs = rows.slice(_idx, tail);
          trs.forEach(function (el) {
            return ctx.indexMap.set(el.props.record, _idx++);
          });
        } else {
          trs = rows;
        }
        ctx.prev_row_count = ctx.row_count;
      }
      break;
    case e_VT_STATE.LOADED:
      console.assert(false);
      break;
  }
  var Wrapper = ctx.components.body.wrapper;
  return /*#__PURE__*/React.createElement(Wrapper, {
    className: className
  }, measureRow, trs);
};
var VTRow = function VTRow(props) {
  var ref = /*#__PURE__*/React.createRef();
  var ctx = props.ctx,
    rest = _objectWithoutProperties(props, _excluded2);
  var children = props.children;
  var Row = ctx.components.body.row;
  if (!Array.isArray(children)) {
    // https://github.com/react-component/table/blob/master/src/Body/BodyRow.tsx#L211
    // https://github.com/react-component/table/blob/master/src/Body/index.tsx#L105
    // only empty or expanded row...
    return /*#__PURE__*/React.createElement(Row, rest, children);
  }
  var row_props = children[0].props;
  var index = ctx.indexMap.get(row_props.record);
  var last_index = useRef(index);
  var expanded_cls = useMemo(function () {
    return ".".concat(row_props.prefixCls, "-expanded-row");
  }, [row_props.prefixCls]);
  var t0 = performance.now();
  useLayoutEffect(function () {
    var t1 = performance.now();
    log_debug(ctx, "+idx ".concat(index, " tooks ").concat(t1 - t0, " ms"));
    if (ctx.vt_state === e_VT_STATE.RUNNING) {
      repainting(ctx);
    } else {
      ctx.possible_hight_per_tr = ref.current.offsetHeight;
      srs_expand(ctx, ctx.row_count, 0, ctx.possible_hight_per_tr);
      repainting(ctx);
      ctx.vt_state = e_VT_STATE.LOADED;
    }
    return function () {
      repainting(ctx);
    };
  }, []);
  useEffect(function () {
    ctx.cq.push({
      index: index,
      func: function func() {
        var rowElm = ref.current;
        if (!rowElm) return;
        var h = rowElm.offsetHeight;
        var sibling = rowElm.nextSibling;
        // https://github.com/react-component/table/blob/master/src/Body/BodyRow.tsx#L212
        // include heights of all expanded rows, in parent rows
        while (sibling && sibling.matches(expanded_cls)) {
          h += sibling.offsetHeight;
          sibling = sibling.nextSibling;
        }
        var curr_h = ctx.row_height[index];
        var last_h = ctx.row_height[last_index.current];
        ctx.computed_h -= curr_h;
        ctx.computed_h += last_h;
        ctx.computed_h += h - last_h;
        ctx.row_height[index] = h;
      }
    });
    repainting(ctx);
  });
  return /*#__PURE__*/React.createElement(Row, _extends({}, rest, {
    ref: ref
  }));
};
export function _set_components(ctx, components) {
  var table = components.table,
    body = components.body,
    header = components.header;
  ctx.components.body = _objectSpread(_objectSpread({}, ctx.components.body), body);
  if (body && body.cell) {
    ctx._vtcomponents.body.cell = body.cell;
  }
  if (header) {
    ctx.components.header = header;
    ctx._vtcomponents.header = header;
  }
  if (table) {
    ctx.components.table = table;
  }
}
export function init(fnOpts, deps) {
  var ctx = useRef( /*#__PURE__*/React.createContext({})).current;
  var ctx_value = useContext(ctx);
  var default_ref = useRef({
    scrollTo: function scrollTo(y) {},
    scrollToIndex: function scrollToIndex(idx) {}
  });
  useMemo(function () {
    return Object.assign(ctx_value, {
      id: (+new Date()).toString(36).slice(4),
      initTop: 0,
      overscanRowCount: 5,
      debug: false,
      ref: default_ref
    }, fnOpts());
  }, deps);
  useMemo(function () {
    var VT = /*#__PURE__*/React.forwardRef(VTable);

    // set the virtual layer.
    ctx_value._vtcomponents = {
      table: function table(props) {
        return /*#__PURE__*/React.createElement(VT, _extends({}, props, {
          context: ctx,
          ref: ctx_value.ref
        }));
      },
      body: {
        // https://github.com/react-component/table/blob/master/src/Body/index.tsx#L114
        wrapper: function wrapper(props) {
          return /*#__PURE__*/React.createElement(ctx.Consumer, null, function /* value */
          () {
            return /*#__PURE__*/React.createElement(VWrapper, _extends({}, props, {
              ctx: ctx_value
            }));
          });
        },
        row: function row(props) {
          return /*#__PURE__*/React.createElement(VTRow, _extends({}, props, {
            ctx: ctx_value
          }));
        }
      }
    };
    // set the default implementation layer.
    ctx_value.components = {};
    _set_components(ctx_value, {
      table: TableImpl,
      body: {
        wrapper: WrapperImpl,
        row: RowImpl
      }
    });
    // start -> `INIT`
    ctx_value.vt_state = e_VT_STATE.INIT;
  }, []);
  return ctx_value;
}