import { isLike, ok } from "./is.js";
function isObjectLike(value) {
    return !!(typeof value === "object" && value) || typeof value === "function";
}
class DoubleMap {
    objects;
    values;
    get(parts, fn) {
        const found = this.pick(parts);
        if (isLike(found)) {
            return found;
        }
        return this.place(parts, fn(parts));
    }
    getStored(key) {
        if (isObjectLike(key)) {
            return this.objects?.get(key);
        }
        else {
            return this.values?.get(key);
        }
    }
    pick(parts) {
        const [key, ...rest] = parts;
        const value = this.getStored(key);
        if (value instanceof DoubleMap) {
            return value.pick(rest);
        }
        return value;
    }
    place(parts, value) {
        const target = parts.slice(0, -1).reduce((map, key) => {
            const existing = map.getStored(key);
            if (existing instanceof DoubleMap) {
                return existing;
            }
            const next = new DoubleMap();
            map.set(key, next);
            return next;
        }, this);
        ok(target instanceof DoubleMap);
        target.set(parts.at(-1), value);
        return value;
    }
    set(key, value) {
        if (isObjectLike(key)) {
            if (!this.objects) {
                this.objects = new WeakMap();
            }
            this.objects.set(key, value);
        }
        else {
            if (!this.values) {
                this.values = new Map();
            }
            this.values.set(key, value);
        }
    }
}
function createCompositeValue(fn) {
    const keys = new Map();
    return function compositeValue(...parts) {
        const { length } = parts;
        let map = keys.get(length);
        if (!map) {
            map = new DoubleMap();
            keys.set(length, map);
        }
        return map.get(parts, fn);
    };
}
export function createCompositeKey() {
    return createCompositeValue(() => Object.freeze({ __proto__: null }));
}
export function createCompositeSymbol() {
    return createCompositeValue((parts) => {
        if (parts.length === 1 && typeof parts[0] === "string") {
            return Symbol.for(parts[0]);
        }
        return Symbol();
    });
}
let internalCompositeKey = undefined;
let internalCompositeSymbol = undefined;
export function compositeKey(...parts) {
    if (!internalCompositeKey) {
        internalCompositeKey = createCompositeKey();
    }
    return internalCompositeKey(...parts);
}
export function compositeSymbol(...parts) {
    if (!internalCompositeSymbol) {
        internalCompositeSymbol = createCompositeSymbol();
    }
    return internalCompositeSymbol(...parts);
}
//# sourceMappingURL=composite.js.map