import { Navigation, NavigationEventMap } from "../spec/navigation";
export declare function createRepeatingPromise<T>(fn: () => Promise<T>): Promise<T>;
export declare function createNavigationEvent<T extends keyof NavigationEventMap, S, R = void | unknown>(type: T, navigation?: Navigation<S, R>): Promise<NavigationEventMap<S, R>[T]>;
export type NavigationEventsMap<S, R> = {
    [P in keyof NavigationEventMap]: Promise<NavigationEventMap<S, R>[P]>;
};
export declare function createNavigationEvents<S, R = void | unknown>(navigation?: Navigation<S, R>): NavigationEventsMap<S, R>;
export declare function createNavigationPromise<T extends keyof NavigationEventMap, S, R = void | unknown>(type: T, navigation?: Navigation<S, R>, onEventFn?: (event: NavigationEventMap<S, R>[T]) => void | unknown): Promise<NavigationEventMap<S, R>[T]>;
