export interface Event<Name extends string | symbol = string | symbol> {
    type: Name;
    parallel?: boolean;
    signal?: {
        aborted: boolean;
    };
    [key: string]: unknown;
    [key: number]: unknown;
    originalEvent?: Event;
}
export declare function isEvent(value: unknown): value is Event;
export declare function assertEvent<E extends Event>(value: unknown, type?: E["type"]): asserts value is E;
