import { Navigation, NavigationResult } from "./spec/navigation";
export interface NavigationLocationOptions {
    navigation: Navigation;
    baseURL?: URL | string;
}
export declare const AppLocationCheckChange: unique symbol;
export declare const AppLocationAwaitFinished: unique symbol;
export declare const AppLocationTransitionURL: unique symbol;
export declare const AppLocationUrl: unique symbol;
export interface LocationAncestorOriginsList {
    readonly length: number;
    contains(string: string): boolean;
    item(index: number): string | null;
    [index: number]: string;
}
export interface LocationPrototype {
    readonly ancestorOrigins: LocationAncestorOriginsList;
}
export interface Location extends LocationPrototype {
}
export interface NavigationLocation extends Location {
}
export declare const NAVIGATION_LOCATION_DEFAULT_URL = "https://html.spec.whatwg.org/";
/**
 * @experimental
 */
export declare class NavigationLocation implements Location {
    #private;
    constructor(options: NavigationLocationOptions);
    get [AppLocationUrl](): URL;
    get hash(): string;
    set hash(value: string);
    get host(): string;
    set host(value: string);
    get hostname(): string;
    set hostname(value: string);
    get href(): string;
    set href(value: string);
    get origin(): string;
    get pathname(): string;
    set pathname(value: string);
    get port(): string;
    set port(value: string);
    get protocol(): string;
    set protocol(value: string);
    get search(): string;
    set search(value: string);
    replace(url: string | URL): unknown;
    replace(url: string | URL): void;
    reload(): unknown;
    reload(): void;
    assign(url: string | URL): unknown;
    assign(url: string | URL): void;
    protected [AppLocationTransitionURL](url: URL | string, fn: (url: URL) => NavigationResult): Promise<void>;
    protected [AppLocationAwaitFinished](result: NavigationResult): Promise<void>;
    /**
     * This is needed if you have changed searchParams using its mutating methods
     *
     * TODO replace get searchParams with an observable change to auto trigger this function
     */
    [AppLocationCheckChange](): Promise<void>;
}
