import { NavigationHistoryEntry as NavigationHistoryEntryPrototype, NavigationHistoryEntryEventMap, NavigationHistoryEntryInit as NavigationHistoryEntryInitPrototype, NavigationNavigationType } from "./spec/navigation";
import { NavigationEventTarget } from "./navigation-event-target";
import { EventTargetListeners } from "./event-target";
declare const NavigationGetState: unique symbol;
export declare const NavigationHistoryEntryNavigationType: unique symbol;
export declare const NavigationHistoryEntryKnownAs: unique symbol;
export declare const NavigationHistoryEntrySetState: unique symbol;
export interface NavigationHistoryEntryGetStateFn<S> {
    (entry: NavigationHistoryEntry<S>): S | undefined;
}
export interface NavigationHistoryEntryFn<S> {
    (entry: NavigationHistoryEntry<S>): void;
}
export interface NavigationHistoryEntrySerialized<S = unknown> {
    key: string;
    navigationType?: string;
    url?: string;
    state?: S;
    sameDocument?: boolean;
}
export interface NavigationHistoryEntryInit<S> extends NavigationHistoryEntryInitPrototype<S> {
    navigationType: NavigationNavigationType;
    getState?: NavigationHistoryEntryGetStateFn<S>;
    [NavigationHistoryEntryKnownAs]?: Set<string>;
}
export declare class NavigationHistoryEntry<S> extends NavigationEventTarget<NavigationHistoryEntryEventMap> implements NavigationHistoryEntryPrototype<S> {
    #private;
    get index(): number;
    readonly key: string;
    readonly id: string;
    readonly url?: string;
    readonly sameDocument: boolean;
    get [NavigationHistoryEntryNavigationType](): NavigationNavigationType;
    get [NavigationHistoryEntryKnownAs](): Set<string>;
    get [EventTargetListeners](): import("./event-target").EventDescriptor[];
    constructor(init: NavigationHistoryEntryInit<S>);
    [NavigationGetState](): S;
    getState<ST extends S>(): ST;
    getState(): S;
    [NavigationHistoryEntrySetState](state: S): void;
}
export {};
