import { Navigation, NavigationHistoryEntry, NavigationEventMap, NavigationNavigationOptions, NavigationReloadOptions, NavigationResult, NavigationUpdateCurrentOptions } from "./spec/navigation";
import { EventCallback, EventTargetAddListenerOptions, SyncEventCallback, Event, EventTargetListeners as EventTargetListenersSymbol, EventDescriptor } from "./event-target";
import { NavigationNavigateOptions } from "./create-navigation-transition";
export interface NavigationNavigation {
    new (thisValue: Navigation): NavigationNavigation;
}
declare const Navigation: unique symbol;
export declare class NavigationNavigation<S = unknown> implements Navigation<S> {
    [key: string]: unknown;
    readonly [Navigation]: Navigation<S>;
    get [EventTargetListenersSymbol](): EventDescriptor[] | undefined;
    constructor(navigation: Navigation<S>);
    get canGoBack(): boolean;
    get canGoForward(): boolean;
    get currentEntry(): NavigationHistoryEntry<S>;
    set oncurrententrychange(value: Navigation["oncurrententrychange"]);
    set onnavigate(value: Navigation["onnavigate"]);
    set onnavigateerror(value: Navigation["onnavigateerror"]);
    set onnavigatesuccess(value: Navigation["onnavigatesuccess"]);
    get transition(): import("./spec/navigation").NavigationTransition<S>;
    addEventListener<K extends keyof NavigationEventMap<S>>(type: K, listener: (ev: NavigationEventMap<S>[K]) => unknown, options?: boolean | EventTargetAddListenerOptions): void;
    addEventListener(type: string, listener: EventCallback, options?: boolean | EventTargetAddListenerOptions): void;
    addEventListener(type: string | symbol, callback: EventCallback, options?: EventTargetAddListenerOptions): void;
    addEventListener(type: string, callback: EventCallback, options?: EventTargetAddListenerOptions): void;
    addEventListener(type: string | symbol, callback: Function, options?: EventTargetAddListenerOptions): void;
    back(options?: NavigationNavigationOptions): NavigationResult<S>;
    dispatchEvent(event: Event): Promise<void>;
    dispatchEvent(event: Event): void;
    entries(): NavigationHistoryEntry<S>[];
    forward(options?: NavigationNavigationOptions): NavigationResult<S>;
    traverseTo(key: string, options?: NavigationNavigationOptions): NavigationResult<S>;
    hasEventListener(type: string | symbol, callback?: Function): boolean;
    hasEventListener(type: string, callback?: Function): boolean;
    navigate<NS extends S = S>(url: string, options?: NavigationNavigateOptions<S>): NavigationResult<S>;
    reload<NS extends S = S>(options?: NavigationReloadOptions<S>): NavigationResult<S>;
    removeEventListener<K extends keyof NavigationEventMap<S>>(type: K, listener: (ev: NavigationEventMap<S>[K]) => unknown, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string, listener: EventCallback, options?: boolean | EventListenerOptions): void;
    removeEventListener(type: string | symbol, callback: Function, options?: unknown): void;
    removeEventListener(type: string, callback: SyncEventCallback<Event>, options?: unknown): void;
    updateCurrentEntry(options: NavigationUpdateCurrentOptions<S>): unknown;
    updateCurrentEntry(options: NavigationUpdateCurrentOptions<S>): void;
}
export {};
