import { NavigationTransition } from "./navigation-transition";
import { Navigation } from "./navigation";
import { NavigationHistoryEntry } from "./navigation-entry";
export interface NavigationTransitionPlannerOptions {
    transition: NavigationTransition;
    currentPlan?: NavigationTransitionPlan;
    finishedTransitions?: Set<NavigationTransition>;
    constructNavigation(): Navigation;
}
export declare const NavigationTransitionPlanNavigationSymbol: unique symbol;
export declare const NavigationTransitionPlanWhile: unique symbol;
export declare const NavigationTransitionPlanWait: unique symbol;
export interface NavigationTransitionPlan<S = unknown> {
    [NavigationTransitionPlanNavigationSymbol]: Navigation;
    [NavigationTransitionPlanWhile](promise: Promise<unknown>): void;
    [NavigationTransitionPlanWait](): Promise<NavigationHistoryEntry<S>>;
    transitions: NavigationTransition[];
    known: Set<NavigationHistoryEntry<S>>;
    knownTransitions: Set<NavigationTransition>;
    resolve(): Promise<void>;
}
export declare function plan(options: NavigationTransitionPlannerOptions): NavigationTransitionPlan<unknown>;
