import { NavigationHistoryEntry as NavigationHistoryEntryPrototype, NavigationIntercept as NavigationInterceptPrototype, NavigationInterceptOptions, NavigationNavigationOptions, NavigationNavigationType, NavigationResult, NavigationTransition as NavigationTransitionPrototype, NavigationTransitionInit as NavigationTransitionInitPrototype } from "./spec/navigation";
import { NavigationHistoryEntry } from "./navigation-entry";
import { Deferred } from "./util/deferred";
import { EventTarget } from "./event-target";
export declare const Rollback: unique symbol;
export declare const Unset: unique symbol;
export type InternalNavigationNavigationType = NavigationNavigationType | typeof Rollback | typeof Unset;
export declare const NavigationTransitionParentEventTarget: unique symbol;
export declare const NavigationTransitionFinishedDeferred: unique symbol;
export declare const NavigationTransitionCommittedDeferred: unique symbol;
export declare const NavigationTransitionNavigationType: unique symbol;
export declare const NavigationTransitionInitialEntries: unique symbol;
export declare const NavigationTransitionFinishedEntries: unique symbol;
export declare const NavigationTransitionInitialIndex: unique symbol;
export declare const NavigationTransitionFinishedIndex: unique symbol;
export declare const NavigationTransitionEntry: unique symbol;
export declare const NavigationTransitionIsCommitted: unique symbol;
export declare const NavigationTransitionIsFinished: unique symbol;
export declare const NavigationTransitionIsRejected: unique symbol;
export declare const NavigationTransitionKnown: unique symbol;
export declare const NavigationTransitionPromises: unique symbol;
export declare const NavigationIntercept: unique symbol;
export declare const NavigationTransitionIsOngoing: unique symbol;
export declare const NavigationTransitionIsPending: unique symbol;
export declare const NavigationTransitionIsAsync: unique symbol;
export declare const NavigationTransitionWait: unique symbol;
export declare const NavigationTransitionPromiseResolved: unique symbol;
export declare const NavigationTransitionRejected: unique symbol;
export declare const NavigationTransitionCommit: unique symbol;
export declare const NavigationTransitionFinish: unique symbol;
export declare const NavigationTransitionStart: unique symbol;
export declare const NavigationTransitionStartDeadline: unique symbol;
export declare const NavigationTransitionError: unique symbol;
export declare const NavigationTransitionFinally: unique symbol;
export declare const NavigationTransitionAbort: unique symbol;
export declare const NavigationTransitionInterceptOptionsCommit: unique symbol;
export declare const NavigationTransitionCommitIsManual: unique symbol;
export interface NavigationTransitionInit<S = unknown, R = unknown | void> extends Omit<NavigationTransitionInitPrototype, "finished"> {
    rollback(options?: NavigationNavigationOptions): NavigationResult<S>;
    [NavigationTransitionFinishedDeferred]?: Deferred<NavigationHistoryEntry<S>>;
    [NavigationTransitionCommittedDeferred]?: Deferred<NavigationHistoryEntry<S>>;
    [NavigationTransitionNavigationType]: InternalNavigationNavigationType;
    [NavigationTransitionInitialEntries]: NavigationHistoryEntry<S>[];
    [NavigationTransitionInitialIndex]: number;
    [NavigationTransitionFinishedEntries]?: NavigationHistoryEntry<S>[];
    [NavigationTransitionFinishedIndex]?: number;
    [NavigationTransitionKnown]?: Iterable<EventTarget>;
    [NavigationTransitionEntry]: NavigationHistoryEntry<S>;
    [NavigationTransitionParentEventTarget]: EventTarget;
}
export declare class NavigationTransition<S = unknown, R = unknown | void> extends EventTarget implements NavigationTransitionPrototype<S> {
    #private;
    readonly finished: Promise<NavigationHistoryEntryPrototype<S>>;
    /**
     * @experimental
     */
    readonly committed: Promise<NavigationHistoryEntryPrototype<S>>;
    readonly from: NavigationHistoryEntryPrototype<S>;
    readonly navigationType: NavigationNavigationType;
    /**
     * true if transition has an async intercept
     */
    [NavigationTransitionIsAsync]: boolean;
    /**
     * @experimental
     */
    readonly [NavigationTransitionInterceptOptionsCommit]: NavigationInterceptOptions<S>["commit"][];
    readonly [NavigationTransitionFinishedDeferred]: Deferred<NavigationHistoryEntry<S>>;
    readonly [NavigationTransitionCommittedDeferred]: Deferred<NavigationHistoryEntry<S>>;
    get [NavigationTransitionIsPending](): boolean;
    get [NavigationTransitionNavigationType](): InternalNavigationNavigationType;
    get [NavigationTransitionInitialEntries](): NavigationHistoryEntry<S>[];
    get [NavigationTransitionInitialIndex](): number;
    get [NavigationTransitionCommitIsManual](): boolean;
    [NavigationTransitionFinishedEntries]?: NavigationHistoryEntry<S>[];
    [NavigationTransitionFinishedIndex]?: number;
    [NavigationTransitionIsCommitted]: boolean;
    [NavigationTransitionIsFinished]: boolean;
    [NavigationTransitionIsRejected]: boolean;
    [NavigationTransitionIsOngoing]: boolean;
    readonly [NavigationTransitionKnown]: Set<EventTarget>;
    readonly [NavigationTransitionEntry]: NavigationHistoryEntry<S>;
    get signal(): AbortSignal;
    get [NavigationTransitionPromises](): Set<Promise<PromiseSettledResult<void>>>;
    constructor(init: NavigationTransitionInit<S, R>);
    rollback: (options?: NavigationNavigationOptions) => NavigationResult;
    [NavigationTransitionPromiseResolved]: (...promises: Promise<PromiseSettledResult<void>>[]) => void;
    [NavigationTransitionRejected]: (reason: unknown) => Promise<void>;
    [NavigationIntercept]: (options: NavigationInterceptPrototype<R>) => void;
    [NavigationTransitionWait]: () => Promise<NavigationHistoryEntry<S>>;
    [NavigationTransitionAbort](): void;
    [NavigationTransitionFinish]: () => Promise<void>;
}
