import { NavigationHistoryEntry, NavigationHistoryEntryFn, NavigationHistoryEntryGetStateFn, NavigationHistoryEntrySerialized } from "./navigation-entry";
import { Navigation as NavigationPrototype, NavigationEventMap, NavigationReloadOptions, NavigationResult, NavigationUpdateCurrentOptions, NavigationTransition as NavigationTransitionPrototype, NavigationNavigationOptions, NavigationNavigationType } from "./spec/navigation";
import { NavigationEventTarget } from "./navigation-event-target";
import { NavigationNavigateOptions } from "./create-navigation-transition";
export * from "./spec/navigation";
export interface NavigationOptions<S = unknown> {
    baseURL?: URL | string;
    getState?: NavigationHistoryEntryGetStateFn<S>;
    setState?: NavigationHistoryEntryFn<S>;
    disposeState?: NavigationHistoryEntryFn<S>;
    entries?: NavigationHistoryEntrySerialized<S>[];
    currentIndex?: number;
    currentKey?: string;
}
export declare const NavigationSetOptions: unique symbol;
export declare const NavigationSetEntries: unique symbol;
export declare const NavigationSetCurrentIndex: unique symbol;
export declare const NavigationSetCurrentKey: unique symbol;
export declare const NavigationGetState: unique symbol;
export declare const NavigationSetState: unique symbol;
export declare const NavigationDisposeState: unique symbol;
export declare function isNavigationNavigationType(value: unknown): value is NavigationNavigationType;
export declare class Navigation<S = unknown, R = unknown | void> extends NavigationEventTarget<NavigationEventMap<S, R>> implements NavigationPrototype<S, R> {
    #private;
    get canGoBack(): boolean;
    get canGoForward(): boolean;
    get currentEntry(): NavigationHistoryEntry<S>;
    get transition(): NavigationTransitionPrototype | undefined;
    constructor(options?: NavigationOptions<S>);
    [NavigationSetOptions](options: NavigationOptions<S>): void;
    /**
     * Set the current entry key without any lifecycle eventing
     *
     * This would be more exact than providing an index
     * @param key
     */
    [NavigationSetCurrentKey](key: string): void;
    /**
     * Set the current entry index without any lifecycle eventing
     * @param index
     */
    [NavigationSetCurrentIndex](index: number): void;
    /**
     * Set the entries available without any lifecycle eventing
     * @param entries
     */
    [NavigationSetEntries](entries: NavigationHistoryEntrySerialized<S>[]): void;
    [NavigationGetState]: (entry: NavigationHistoryEntry<S>) => S | undefined;
    [NavigationSetState]: (entry: NavigationHistoryEntry<S>) => void;
    [NavigationDisposeState]: (entry: NavigationHistoryEntry<S>) => void;
    back(options?: NavigationNavigationOptions): NavigationResult<S>;
    entries(): NavigationHistoryEntry<S>[];
    forward(options?: NavigationNavigationOptions): NavigationResult<S>;
    /**
    /**
     * @deprecated use traverseTo
     */
    goTo(key: string, options?: NavigationNavigateOptions): NavigationResult<R>;
    traverseTo(key: string, options?: NavigationNavigationOptions): NavigationResult<S>;
    navigate(url: string, options?: NavigationNavigateOptions<S>): NavigationResult;
    reload(options?: NavigationReloadOptions<S>): NavigationResult<S>;
    updateCurrentEntry(options: NavigationUpdateCurrentOptions<S>): unknown;
    updateCurrentEntry(options: NavigationUpdateCurrentOptions<S>): void;
}
