import { Navigation, NavigationEventMap, NavigationHistoryEntry, NavigationNavigateOptions, NavigationNavigationOptions, NavigationReloadOptions, NavigationResult, NavigationUpdateCurrentOptions } from "./spec/navigation";
import { NavigationEventTarget } from "./navigation-event-target";
export declare class NoOperationNavigation<S = unknown> extends NavigationEventTarget<NavigationEventMap> implements Navigation<S> {
    readonly canGoBack: boolean;
    readonly canGoForward: boolean;
    back(options?: NavigationNavigationOptions): NavigationResult;
    entries(): NavigationHistoryEntry[];
    forward(options?: NavigationNavigationOptions): NavigationResult;
    traverseTo(key: string, options?: NavigationNavigationOptions): NavigationResult;
    navigate(url: string, options?: NavigationNavigateOptions): NavigationResult;
    reload(options?: NavigationReloadOptions): NavigationResult;
    updateCurrentEntry(options: NavigationUpdateCurrentOptions): Promise<void>;
    updateCurrentEntry(options: NavigationUpdateCurrentOptions): void;
}
