import { Router } from "./router";
import { URLPattern } from "./url-pattern";
import { Event } from "../event-target";
import { NavigateEvent } from "../spec/navigation";
import { PatternRouteFn, RouteFn } from "./types";
export declare function getRouter<E extends Event = NavigateEvent, R = void | unknown>(): Router<E, R>;
export declare function route<E extends Event = NavigateEvent, R = void | unknown>(pattern: string | URLPattern, fn: PatternRouteFn<E, R>): Router<E, R>;
export declare function route<E extends Event = NavigateEvent, R = void | unknown>(fn: RouteFn<E, R>): Router<E, R>;
export declare function routes<E extends Event = NavigateEvent, R = void | unknown>(pattern: string | URLPattern, router: Router<E, R>): Router<E, R>;
export declare function routes<E extends Event = NavigateEvent, R = void | unknown>(pattern: string | URLPattern): Router<E, R>;
export declare function routes<E extends Event = NavigateEvent, R = void | unknown>(router: Router<E, R>): Router<E, R>;
export declare function routes<E extends Event = NavigateEvent, R = void | unknown>(): Router<E, R>;
