/**
 * vis-timeline and vis-graph2d
 * https://visjs.github.io/vis-timeline/
 *
 * Create a fully customizable, interactive timeline with items and ranges.
 *
 * @version 7.7.3
 * @date    2023-10-27T17:57:57.604Z
 *
 * @copyright (c) 2011-2017 Almende B.V, http://almende.com
 * @copyright (c) 2017-2019 visjs contributors, https://github.com/visjs
 *
 * @license
 * vis.js is dual licensed under both
 *
 *   1. The Apache 2.0 License
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *   and
 *
 *   2. The MIT License
 *      http://opensource.org/licenses/MIT
 *
 * vis.js may be distributed under either license.
 */
import t from"moment";import*as e from"vis-util/esnext/esm/vis-util.js";import{isNumber as s,isString as o,getType as n}from"vis-util/esnext/esm/vis-util.js";import{isDataViewLike as r,DataSet as a,createNewDataPipeFrom as h,DataView as l}from"vis-data/esnext/esm/vis-data.js";import d from"xss";import{v4 as p}from"uuid";import m from"component-emitter";import c from"propagating-hammerjs";import u from"@egjs/hammerjs";import g from"keycharm";function f(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}var b=f("undefined"!=typeof window&&window.moment||t);function y(t){if(!t)return!1;let e=t.idProp??t._idProp;return!!e&&r(e,t)}const v=/^\/?Date\((-?\d+)/i,w=/^\d+$/;function _(e,i){let r;if(void 0!==e){if(null===e)return null;if(!i)return e;if("string"!=typeof i&&!(i instanceof String))throw new Error("Type must be a string");switch(i){case"boolean":case"Boolean":return Boolean(e);case"number":case"Number":return o(e)&&!isNaN(Date.parse(e))?t(e).valueOf():Number(e.valueOf());case"string":case"String":return String(e);case"Date":try{return _(e,"Moment").toDate()}catch(t){throw t instanceof TypeError?new TypeError("Cannot convert object of type "+n(e)+" to type "+i):t}case"Moment":if(s(e))return t(e);if(e instanceof Date)return t(e.valueOf());if(t.isMoment(e))return t(e);if(o(e))return r=v.exec(e),r?t(Number(r[1])):(r=w.exec(e),t(r?Number(e):e));throw new TypeError("Cannot convert object of type "+n(e)+" to type "+i);case"ISODate":if(s(e))return new Date(e);if(e instanceof Date)return e.toISOString();if(t.isMoment(e))return e.toDate().toISOString();if(o(e))return r=v.exec(e),r?new Date(Number(r[1])).toISOString():t(e).format();throw new Error("Cannot convert object of type "+n(e)+" to type ISODate");case"ASPDate":if(s(e))return"/Date("+e+")/";if(e instanceof Date||t.isMoment(e))return"/Date("+e.valueOf()+")/";if(o(e)){let t;return r=v.exec(e),t=r?new Date(Number(r[1])).valueOf():new Date(e).valueOf(),"/Date("+t+")/"}throw new Error("Cannot convert object of type "+n(e)+" to type ASPDate");default:throw new Error(`Unknown type ${i}`)}}}function x(t,e={start:"Date",end:"Date"}){const i=t._idProp,s=new a({fieldId:i}),o=h(t).map((t=>Object.keys(t).reduce(((i,s)=>(i[s]=_(t[s],e[s]),i)),{}))).to(s);return o.all().start(),{add:(...e)=>t.getDataSet().add(...e),remove:(...e)=>t.getDataSet().remove(...e),update:(...e)=>t.getDataSet().update(...e),updateOnly:(...e)=>t.getDataSet().updateOnly(...e),clear:(...e)=>t.getDataSet().clear(...e),forEach:s.forEach.bind(s),get:s.get.bind(s),getIds:s.getIds.bind(s),off:s.off.bind(s),on:s.on.bind(s),get length(){return s.length},idProp:i,type:e,rawDS:t,coercedDS:s,dispose:()=>o.stop()}}const D=t=>{const e=new d.FilterXSS(t);return t=>e.process(t)},C=t=>t;let S=D();const k={...e,convert:_,setupXSSProtection:t=>{t&&(!0===t.disabled?(S=C,console.warn("You disabled XSS protection for vis-Timeline. I sure hope you know what you're doing!")):t.filterOptions&&(S=D(t.filterOptions)))}};Object.defineProperty(k,"xss",{get:function(){return S}});class T{constructor(t,e){this.options=null,this.props=null}setOptions(t){t&&k.extend(this.options,t)}redraw(){return!1}destroy(){}_isResized(){const t=this.props._previousWidth!==this.props.width||this.props._previousHeight!==this.props.height;return this.props._previousWidth=this.props.width,this.props._previousHeight=this.props.height,t}}function E(t,e,i){if(i&&!Array.isArray(i))return E(t,e,[i]);if(e.hiddenDates=[],i&&1==Array.isArray(i)){for(let s=0;s<i.length;s++)if(void 0===i[s].repeat){const o={};o.start=t(i[s].start).toDate().valueOf(),o.end=t(i[s].end).toDate().valueOf(),e.hiddenDates.push(o)}e.hiddenDates.sort(((t,e)=>t.start-e.start))}}function O(t,e,i){if(i&&!Array.isArray(i))return O(t,e,[i]);if(i&&void 0!==e.domProps.centerContainer.width){E(t,e,i);const s=t(e.range.start),o=t(e.range.end),n=(e.range.end-e.range.start)/e.domProps.centerContainer.width;for(let r=0;r<i.length;r++)if(void 0!==i[r].repeat){const a=t(i[r].start);let h=t(i[r].end);if("Invalid Date"==a._d)throw new Error(`Supplied start date is not valid: ${i[r].start}`);if("Invalid Date"==h._d)throw new Error(`Supplied end date is not valid: ${i[r].end}`);if(h-a>=4*n){let t=0;const n=o.clone();switch(i[r].repeat){case"daily":a.day()!=h.day()&&(t=1),a.dayOfYear(s.dayOfYear()),a.year(s.year()),a.subtract(7,"days"),h.dayOfYear(s.dayOfYear()),h.year(s.year()),h.subtract(7-t,"days"),n.add(1,"weeks");break;case"weekly":{const t=h.diff(a,"days"),e=a.day();a.date(s.date()),a.month(s.month()),a.year(s.year()),h=a.clone(),a.day(e),h.day(e),h.add(t,"days"),a.subtract(1,"weeks"),h.subtract(1,"weeks"),n.add(1,"weeks");break}case"monthly":a.month()!=h.month()&&(t=1),a.month(s.month()),a.year(s.year()),a.subtract(1,"months"),h.month(s.month()),h.year(s.year()),h.subtract(1,"months"),h.add(t,"months"),n.add(1,"months");break;case"yearly":a.year()!=h.year()&&(t=1),a.year(s.year()),a.subtract(1,"years"),h.year(s.year()),h.subtract(1,"years"),h.add(t,"years"),n.add(1,"years");break;default:return void console.log("Wrong repeat format, allowed are: daily, weekly, monthly, yearly. Given:",i[r].repeat)}for(;a<n;)switch(e.hiddenDates.push({start:a.valueOf(),end:h.valueOf()}),i[r].repeat){case"daily":a.add(1,"days"),h.add(1,"days");break;case"weekly":a.add(1,"weeks"),h.add(1,"weeks");break;case"monthly":a.add(1,"months"),h.add(1,"months");break;case"yearly":a.add(1,"y"),h.add(1,"y");break;default:return void console.log("Wrong repeat format, allowed are: daily, weekly, monthly, yearly. Given:",i[r].repeat)}e.hiddenDates.push({start:a.valueOf(),end:h.valueOf()})}}M(e);const r=z(e.range.start,e.hiddenDates),a=z(e.range.end,e.hiddenDates);let h=e.range.start,l=e.range.end;1==r.hidden&&(h=1==e.range.startToFront?r.startDate-1:r.endDate+1),1==a.hidden&&(l=1==e.range.endToFront?a.startDate-1:a.endDate+1),1!=r.hidden&&1!=a.hidden||e.range._applyRange(h,l)}}function M(t){const e=t.hiddenDates,i=[];for(var s=0;s<e.length;s++)for(let t=0;t<e.length;t++)s!=t&&1!=e[t].remove&&1!=e[s].remove&&(e[t].start>=e[s].start&&e[t].end<=e[s].end?e[t].remove=!0:e[t].start>=e[s].start&&e[t].start<=e[s].end?(e[s].end=e[t].end,e[t].remove=!0):e[t].end>=e[s].start&&e[t].end<=e[s].end&&(e[s].start=e[t].start,e[t].remove=!0));for(s=0;s<e.length;s++)!0!==e[s].remove&&i.push(e[s]);t.hiddenDates=i,t.hiddenDates.sort(((t,e)=>t.start-e.start))}function I(t,e,i){let s=!1;const o=e.current.valueOf();for(let t=0;t<e.hiddenDates.length;t++){const i=e.hiddenDates[t].start;var n=e.hiddenDates[t].end;if(o>=i&&o<n){s=!0;break}}if(1==s&&o<e._end.valueOf()&&o!=i){const s=t(i),o=t(n);s.year()!=o.year()?e.switchedYear=!0:s.month()!=o.month()?e.switchedMonth=!0:s.dayOfYear()!=o.dayOfYear()&&(e.switchedDay=!0),e.current=o}}function N(t,e,i){let s;if(0==t.body.hiddenDates.length)return s=t.range.conversion(i),(e.valueOf()-s.offset)*s.scale;{const o=z(e,t.body.hiddenDates);1==o.hidden&&(e=o.startDate);const n=A(t.body.hiddenDates,t.range.start,t.range.end);if(e<t.range.start){s=t.range.conversion(i,n);const o=L(t.body.hiddenDates,e,s.offset);return e=t.options.moment(e).toDate().valueOf(),e+=o,-(s.offset-e.valueOf())*s.scale}if(e>t.range.end){const o={start:t.range.start,end:e};return e=R(t.options.moment,t.body.hiddenDates,o,e),s=t.range.conversion(i,n),(e.valueOf()-s.offset)*s.scale}return e=R(t.options.moment,t.body.hiddenDates,t.range,e),s=t.range.conversion(i,n),(e.valueOf()-s.offset)*s.scale}}function P(t,e,i){if(0==t.body.hiddenDates.length){const s=t.range.conversion(i);return new Date(e/s.scale+s.offset)}{const s=A(t.body.hiddenDates,t.range.start,t.range.end),o=(t.range.end-t.range.start-s)*e/i,n=G(t.body.hiddenDates,t.range,o);return new Date(n+o+t.range.start)}}function A(t,e,i){let s=0;for(let o=0;o<t.length;o++){const n=t[o].start,r=t[o].end;n>=e&&r<i&&(s+=r-n)}return s}function L(t,e,i){let s=0;for(let o=0;o<t.length;o++){const n=t[o].start,r=t[o].end;n>=e&&r<=i&&(s+=r-n)}return s}function R(t,e,i,s){return s=t(s).toDate().valueOf(),s-=F(t,e,i,s)}function F(t,e,i,s){let o=0;s=t(s).toDate().valueOf();for(let t=0;t<e.length;t++){const n=e[t].start,r=e[t].end;n>=i.start&&r<i.end&&s>=r&&(o+=r-n)}return o}function G(t,e,i){let s=0,o=0,n=e.start;for(let r=0;r<t.length;r++){const a=t[r].start,h=t[r].end;if(a>=e.start&&h<e.end){if(o+=a-n,n=h,o>=i)break;s+=h-a}}return s}function H(t,e,i,s){const o=z(e,t);return 1==o.hidden?i<0?1==s?o.startDate-(o.endDate-e)-1:o.startDate-1:1==s?o.endDate+(e-o.startDate)+1:o.endDate+1:e}function z(t,e){for(let o=0;o<e.length;o++){var i=e[o].start,s=e[o].end;if(t>=i&&t<s)return{hidden:!0,startDate:i,endDate:s}}return{hidden:!1,startDate:i,endDate:s}}var j=Object.freeze({__proto__:null,convertHiddenOptions:E,correctTimeForHidden:R,getAccumulatedHiddenDuration:G,getHiddenDurationBefore:F,getHiddenDurationBeforeStart:L,getHiddenDurationBetween:A,getIsHidden:z,printDates:function(t){for(let e=0;e<t.length;e++)console.log(e,new Date(t[e].start),new Date(t[e].end),t[e].start,t[e].end,t[e].remove)},removeDuplicates:M,snapAwayFromHidden:H,stepOverHiddenDates:I,toScreen:N,toTime:P,updateHiddenDates:O});class B extends T{constructor(t,e){super();const i=b().hours(0).minutes(0).seconds(0).milliseconds(0),s=i.clone().add(-3,"days").valueOf(),o=i.clone().add(3,"days").valueOf();this.millisecondsPerPixelCache=void 0,void 0===e?(this.start=s,this.end=o):(this.start=e.start||s,this.end=e.end||o),this.rolling=!1,this.body=t,this.deltaDifference=0,this.scaleOffset=0,this.startToFront=!1,this.endToFront=!0,this.defaultOptions={rtl:!1,start:null,end:null,moment:b,direction:"horizontal",moveable:!0,zoomable:!0,min:null,max:null,zoomMin:10,zoomMax:31536e10,rollingMode:{follow:!1,offset:.5}},this.options=k.extend({},this.defaultOptions),this.props={touch:{}},this.animationTimer=null,this.body.emitter.on("panstart",this._onDragStart.bind(this)),this.body.emitter.on("panmove",this._onDrag.bind(this)),this.body.emitter.on("panend",this._onDragEnd.bind(this)),this.body.emitter.on("mousewheel",this._onMouseWheel.bind(this)),this.body.emitter.on("touch",this._onTouch.bind(this)),this.body.emitter.on("pinch",this._onPinch.bind(this)),this.body.dom.rollingModeBtn.addEventListener("click",this.startRolling.bind(this)),this.setOptions(e)}setOptions(t){if(t){const e=["animation","direction","min","max","zoomMin","zoomMax","moveable","zoomable","moment","activate","hiddenDates","zoomKey","zoomFriction","rtl","showCurrentTime","rollingMode","horizontalScroll"];k.selectiveExtend(e,this.options,t),t.rollingMode&&t.rollingMode.follow&&this.startRolling(),("start"in t||"end"in t)&&this.setRange(t.start,t.end)}}startRolling(){const t=this;!function e(){t.stopRolling(),t.rolling=!0;let i=t.end-t.start;const s=k.convert(new Date,"Date").valueOf(),o=t.options.rollingMode&&t.options.rollingMode.offset||.5,n=s-i*o,r=s+i*(1-o);t.setRange(n,r,{animation:!1}),i=1/t.conversion(t.body.domProps.center.width).scale/10,i<30&&(i=30),i>1e3&&(i=1e3),t.body.dom.rollingModeBtn.style.visibility="hidden",t.currentTimeTimer=setTimeout(e,i)}()}stopRolling(){void 0!==this.currentTimeTimer&&(clearTimeout(this.currentTimeTimer),this.rolling=!1,this.body.dom.rollingModeBtn.style.visibility="visible")}setRange(t,e,i,s,o){i||(i={}),!0!==i.byUser&&(i.byUser=!1);const n=this,r=null!=t?k.convert(t,"Date").valueOf():null,a=null!=e?k.convert(e,"Date").valueOf():null;if(this._cancelAnimation(),this.millisecondsPerPixelCache=void 0,i.animation){const t=this.start,e=this.end,l="object"==typeof i.animation&&"duration"in i.animation?i.animation.duration:500,d="object"==typeof i.animation&&"easingFunction"in i.animation?i.animation.easingFunction:"easeInOutQuad",p=k.easingFunctions[d];if(!p)throw new Error(`Unknown easing function ${JSON.stringify(d)}. Choose from: ${Object.keys(k.easingFunctions).join(", ")}`);const m=Date.now();let c=!1;const u=()=>{if(!n.props.touch.dragging){const d=Date.now()-m,g=p(d/l),f=d>l,b=f||null===r?r:t+(r-t)*g,y=f||null===a?a:e+(a-e)*g;h=n._applyRange(b,y),O(n.options.moment,n.body,n.options.hiddenDates),c=c||h;const v={start:new Date(n.start),end:new Date(n.end),byUser:i.byUser,event:i.event};if(o&&o(g,h,f),h&&n.body.emitter.emit("rangechange",v),f){if(c&&(n.body.emitter.emit("rangechanged",v),s))return s()}else n.animationTimer=setTimeout(u,20)}};return u()}var h=this._applyRange(r,a);if(O(this.options.moment,this.body,this.options.hiddenDates),h){const t={start:new Date(this.start),end:new Date(this.end),byUser:i.byUser,event:i.event};if(this.body.emitter.emit("rangechange",t),clearTimeout(n.timeoutID),n.timeoutID=setTimeout((()=>{n.body.emitter.emit("rangechanged",t)}),200),s)return s()}}getMillisecondsPerPixel(){return void 0===this.millisecondsPerPixelCache&&(this.millisecondsPerPixelCache=(this.end-this.start)/this.body.dom.center.clientWidth),this.millisecondsPerPixelCache}_cancelAnimation(){this.animationTimer&&(clearTimeout(this.animationTimer),this.animationTimer=null)}_applyRange(t,e){let i=null!=t?k.convert(t,"Date").valueOf():this.start,s=null!=e?k.convert(e,"Date").valueOf():this.end;const o=null!=this.options.max?k.convert(this.options.max,"Date").valueOf():null,n=null!=this.options.min?k.convert(this.options.min,"Date").valueOf():null;let r;if(isNaN(i)||null===i)throw new Error(`Invalid start "${t}"`);if(isNaN(s)||null===s)throw new Error(`Invalid end "${e}"`);if(s<i&&(s=i),null!==n&&i<n&&(r=n-i,i+=r,s+=r,null!=o&&s>o&&(s=o)),null!==o&&s>o&&(r=s-o,i-=r,s-=r,null!=n&&i<n&&(i=n)),null!==this.options.zoomMin){let t=parseFloat(this.options.zoomMin);if(t<0&&(t=0),s-i<t){const e=.5;this.end-this.start===t&&i>=this.start-e&&s<=this.end?(i=this.start,s=this.end):(r=t-(s-i),i-=r/2,s+=r/2)}}if(null!==this.options.zoomMax){let t=parseFloat(this.options.zoomMax);t<0&&(t=0),s-i>t&&(this.end-this.start===t&&i<this.start&&s>this.end?(i=this.start,s=this.end):(r=s-i-t,i+=r/2,s-=r/2))}const a=this.start!=i||this.end!=s;return i>=this.start&&i<=this.end||s>=this.start&&s<=this.end||this.start>=i&&this.start<=s||this.end>=i&&this.end<=s||this.body.emitter.emit("checkRangedItems"),this.start=i,this.end=s,a}getRange(){return{start:this.start,end:this.end}}conversion(t,e){return B.conversion(this.start,this.end,t,e)}static conversion(t,e,i,s){return void 0===s&&(s=0),0!=i&&e-t!=0?{offset:t,scale:i/(e-t-s)}:{offset:0,scale:1}}_onDragStart(t){this.deltaDifference=0,this.previousDelta=0,this.options.moveable&&this._isInsideRange(t)&&this.props.touch.allowDragging&&(this.stopRolling(),this.props.touch.start=this.start,this.props.touch.end=this.end,this.props.touch.dragging=!0,this.body.dom.root&&(this.body.dom.root.style.cursor="move"))}_onDrag(t){if(!t)return;if(!this.props.touch.dragging)return;if(!this.options.moveable)return;if(!this.props.touch.allowDragging)return;const e=this.options.direction;Y(e);let i="horizontal"==e?t.deltaX:t.deltaY;i-=this.deltaDifference;let s=this.props.touch.end-this.props.touch.start;s-=A(this.body.hiddenDates,this.start,this.end);const o="horizontal"==e?this.body.domProps.center.width:this.body.domProps.center.height;let n;n=this.options.rtl?i/o*s:-i/o*s;const r=this.props.touch.start+n,a=this.props.touch.end+n,h=H(this.body.hiddenDates,r,this.previousDelta-i,!0),l=H(this.body.hiddenDates,a,this.previousDelta-i,!0);if(h!=r||l!=a)return this.deltaDifference+=i,this.props.touch.start=h,this.props.touch.end=l,void this._onDrag(t);this.previousDelta=i,this._applyRange(r,a);const d=new Date(this.start),p=new Date(this.end);this.body.emitter.emit("rangechange",{start:d,end:p,byUser:!0,event:t}),this.body.emitter.emit("panmove")}_onDragEnd(t){this.props.touch.dragging&&this.options.moveable&&this.props.touch.allowDragging&&(this.props.touch.dragging=!1,this.body.dom.root&&(this.body.dom.root.style.cursor="auto"),this.body.emitter.emit("rangechanged",{start:new Date(this.start),end:new Date(this.end),byUser:!0,event:t}))}_onMouseWheel(t){let e=0;if(t.wheelDelta?e=t.wheelDelta/120:t.detail?e=-t.detail/3:t.deltaY&&(e=-t.deltaY/3),!(this.options.zoomKey&&!t[this.options.zoomKey]&&this.options.zoomable||!this.options.zoomable&&this.options.moveable)&&this.options.zoomable&&this.options.moveable&&this._isInsideRange(t)&&e){const i=this.options.zoomFriction||5;let s,o;if(s=e<0?1-e/i:1/(1+e/i),this.rolling){const t=this.options.rollingMode&&this.options.rollingMode.offset||.5;o=this.start+(this.end-this.start)*t}else{const e=this.getPointer({x:t.clientX,y:t.clientY},this.body.dom.center);o=this._pointerToDate(e)}this.zoom(s,o,e,t),t.preventDefault()}}_onTouch(t){this.props.touch.start=this.start,this.props.touch.end=this.end,this.props.touch.allowDragging=!0,this.props.touch.center=null,this.props.touch.centerDate=null,this.scaleOffset=0,this.deltaDifference=0,k.preventDefault(t)}_onPinch(t){if(!this.options.zoomable||!this.options.moveable)return;k.preventDefault(t),this.props.touch.allowDragging=!1,this.props.touch.center||(this.props.touch.center=this.getPointer(t.center,this.body.dom.center),this.props.touch.centerDate=this._pointerToDate(this.props.touch.center)),this.stopRolling();const e=1/(t.scale+this.scaleOffset),i=this.props.touch.centerDate,s=A(this.body.hiddenDates,this.start,this.end),o=F(this.options.moment,this.body.hiddenDates,this,i),n=s-o;let r=i-o+(this.props.touch.start-(i-o))*e,a=i+n+(this.props.touch.end-(i+n))*e;this.startToFront=1-e<=0,this.endToFront=e-1<=0;const h=H(this.body.hiddenDates,r,1-e,!0),l=H(this.body.hiddenDates,a,e-1,!0);h==r&&l==a||(this.props.touch.start=h,this.props.touch.end=l,this.scaleOffset=1-t.scale,r=h,a=l);const d={animation:!1,byUser:!0,event:t};this.setRange(r,a,d),this.startToFront=!1,this.endToFront=!0}_isInsideRange(t){const e=t.center?t.center.x:t.clientX,i=this.body.dom.centerContainer.getBoundingClientRect(),s=this.options.rtl?e-i.left:i.right-e,o=this.body.util.toTime(s);return o>=this.start&&o<=this.end}_pointerToDate(t){let e;const i=this.options.direction;if(Y(i),"horizontal"==i)return this.body.util.toTime(t.x).valueOf();{const i=this.body.domProps.center.height;return e=this.conversion(i),t.y/e.scale+e.offset}}getPointer(t,e){const i=e.getBoundingClientRect();return this.options.rtl?{x:i.right-t.x,y:t.y-i.top}:{x:t.x-i.left,y:t.y-i.top}}zoom(t,e,i,s){null==e&&(e=(this.start+this.end)/2);const o=A(this.body.hiddenDates,this.start,this.end),n=F(this.options.moment,this.body.hiddenDates,this,e),r=o-n;let a=e-n+(this.start-(e-n))*t,h=e+r+(this.end-(e+r))*t;this.startToFront=!(i>0),this.endToFront=!(-i>0);const l=H(this.body.hiddenDates,a,i,!0),d=H(this.body.hiddenDates,h,-i,!0);l==a&&d==h||(a=l,h=d);const p={animation:!1,byUser:!0,event:s};this.setRange(a,h,p),this.startToFront=!1,this.endToFront=!0}move(t){const e=this.end-this.start,i=this.start+e*t,s=this.end+e*t;this.start=i,this.end=s}moveTo(t){const e=(this.start+this.end)/2-t,i=this.start-e,s=this.end-e;this.setRange(i,s,{animation:!1,byUser:!0,event:null})}destroy(){this.stopRolling()}}function Y(t){if("horizontal"!=t&&"vertical"!=t)throw new TypeError(`Unknown direction "${t}". Choose "horizontal" or "vertical".`)}let $;if("undefined"!=typeof window){$=c(window.Hammer||u,{preventDefault:"mouse"})}else $=()=>function(){const t=()=>{};return{on:t,off:t,destroy:t,emit:t,get:e=>({set:t})}}();var W=$;function V(t,e){e.inputHandler=function(t){t.isFirst&&e(t)},t.on("hammer.input",e.inputHandler)}class U{constructor(t,e,i,s,o){this.moment=o&&o.moment||b,this.options=o||{},this.current=this.moment(),this._start=this.moment(),this._end=this.moment(),this.autoScale=!0,this.scale="day",this.step=1,this.setRange(t,e,i),this.switchedDay=!1,this.switchedMonth=!1,this.switchedYear=!1,Array.isArray(s)?this.hiddenDates=s:this.hiddenDates=null!=s?[s]:[],this.format=U.FORMAT}setMoment(t){this.moment=t,this.current=this.moment(this.current.valueOf()),this._start=this.moment(this._start.valueOf()),this._end=this.moment(this._end.valueOf())}setFormat(t){const e=k.deepExtend({},U.FORMAT);this.format=k.deepExtend(e,t)}setRange(t,e,i){if(!(t instanceof Date&&e instanceof Date))throw"No legal start or end date in method setRange";this._start=null!=t?this.moment(t.valueOf()):Date.now(),this._end=null!=e?this.moment(e.valueOf()):Date.now(),this.autoScale&&this.setMinimumStep(i)}start(){this.current=this._start.clone(),this.roundToMinor()}roundToMinor(){switch("week"==this.scale&&this.current.weekday(0),this.scale){case"year":this.current.year(this.step*Math.floor(this.current.year()/this.step)),this.current.month(0);case"month":this.current.date(1);case"week":case"day":case"weekday":this.current.hours(0);case"hour":this.current.minutes(0);case"minute":this.current.seconds(0);case"second":this.current.milliseconds(0)}if(1!=this.step){let t=this.current.clone();switch(this.scale){case"millisecond":this.current.subtract(this.current.milliseconds()%this.step,"milliseconds");break;case"second":this.current.subtract(this.current.seconds()%this.step,"seconds");break;case"minute":this.current.subtract(this.current.minutes()%this.step,"minutes");break;case"hour":this.current.subtract(this.current.hours()%this.step,"hours");break;case"weekday":case"day":this.current.subtract((this.current.date()-1)%this.step,"day");break;case"week":this.current.subtract(this.current.week()%this.step,"week");break;case"month":this.current.subtract(this.current.month()%this.step,"month");break;case"year":this.current.subtract(this.current.year()%this.step,"year")}t.isSame(this.current)||(this.current=this.moment(H(this.hiddenDates,this.current.valueOf(),-1,!0)))}}hasNext(){return this.current.valueOf()<=this._end.valueOf()}next(){const t=this.current.valueOf();switch(this.scale){case"millisecond":this.current.add(this.step,"millisecond");break;case"second":this.current.add(this.step,"second");break;case"minute":this.current.add(this.step,"minute");break;case"hour":this.current.add(this.step,"hour"),this.current.month()<6?this.current.subtract(this.current.hours()%this.step,"hour"):this.current.hours()%this.step!=0&&this.current.add(this.step-this.current.hours()%this.step,"hour");break;case"weekday":case"day":this.current.add(this.step,"day");break;case"week":if(0!==this.current.weekday())this.current.weekday(0),this.current.add(this.step,"week");else if(!1===this.options.showMajorLabels)this.current.add(this.step,"week");else{const t=this.current.clone();t.add(1,"week"),t.isSame(this.current,"month")?this.current.add(this.step,"week"):(this.current.add(this.step,"week"),this.current.date(1))}break;case"month":this.current.add(this.step,"month");break;case"year":this.current.add(this.step,"year")}if(1!=this.step)switch(this.scale){case"millisecond":this.current.milliseconds()>0&&this.current.milliseconds()<this.step&&this.current.milliseconds(0);break;case"second":this.current.seconds()>0&&this.current.seconds()<this.step&&this.current.seconds(0);break;case"minute":this.current.minutes()>0&&this.current.minutes()<this.step&&this.current.minutes(0);break;case"hour":this.current.hours()>0&&this.current.hours()<this.step&&this.current.hours(0);break;case"weekday":case"day":this.current.date()<this.step+1&&this.current.date(1);break;case"week":this.current.week()<this.step&&this.current.week(1);break;case"month":this.current.month()<this.step&&this.current.month(0)}this.current.valueOf()==t&&(this.current=this._end.clone()),this.switchedDay=!1,this.switchedMonth=!1,this.switchedYear=!1,I(this.moment,this,t)}getCurrent(){return this.current.clone()}setScale(t){t&&"string"==typeof t.scale&&(this.scale=t.scale,this.step=t.step>0?t.step:1,this.autoScale=!1)}setAutoScale(t){this.autoScale=t}setMinimumStep(t){if(null==t)return;const e=31104e6,i=2592e6,s=864e5,o=36e5,n=6e4,r=1e3;1e3*e>t&&(this.scale="year",this.step=1e3),500*e>t&&(this.scale="year",this.step=500),100*e>t&&(this.scale="year",this.step=100),50*e>t&&(this.scale="year",this.step=50),10*e>t&&(this.scale="year",this.step=10),5*e>t&&(this.scale="year",this.step=5),e>t&&(this.scale="year",this.step=1),7776e6>t&&(this.scale="month",this.step=3),i>t&&(this.scale="month",this.step=1),6048e5>t&&this.options.showWeekScale&&(this.scale="week",this.step=1),1728e5>t&&(this.scale="day",this.step=2),s>t&&(this.scale="day",this.step=1),432e5>t&&(this.scale="weekday",this.step=1),144e5>t&&(this.scale="hour",this.step=4),o>t&&(this.scale="hour",this.step=1),9e5>t&&(this.scale="minute",this.step=15),6e5>t&&(this.scale="minute",this.step=10),3e5>t&&(this.scale="minute",this.step=5),n>t&&(this.scale="minute",this.step=1),15e3>t&&(this.scale="second",this.step=15),1e4>t&&(this.scale="second",this.step=10),5e3>t&&(this.scale="second",this.step=5),r>t&&(this.scale="second",this.step=1),200>t&&(this.scale="millisecond",this.step=200),100>t&&(this.scale="millisecond",this.step=100),50>t&&(this.scale="millisecond",this.step=50),10>t&&(this.scale="millisecond",this.step=10),5>t&&(this.scale="millisecond",this.step=5),1>t&&(this.scale="millisecond",this.step=1)}static snap(t,e,i){const s=b(t);if("year"==e){const t=s.year()+Math.round(s.month()/12);s.year(Math.round(t/i)*i),s.month(0),s.date(0),s.hours(0),s.minutes(0),s.seconds(0),s.milliseconds(0)}else if("month"==e)s.date()>15?(s.date(1),s.add(1,"month")):s.date(1),s.hours(0),s.minutes(0),s.seconds(0),s.milliseconds(0);else if("week"==e)s.weekday()>2?(s.weekday(0),s.add(1,"week")):s.weekday(0),s.hours(0),s.minutes(0),s.seconds(0),s.milliseconds(0);else if("day"==e){switch(i){case 5:case 2:s.hours(24*Math.round(s.hours()/24));break;default:s.hours(12*Math.round(s.hours()/12))}s.minutes(0),s.seconds(0),s.milliseconds(0)}else if("weekday"==e){switch(i){case 5:case 2:s.hours(12*Math.round(s.hours()/12));break;default:s.hours(6*Math.round(s.hours()/6))}s.minutes(0),s.seconds(0),s.milliseconds(0)}else if("hour"==e){if(4===i)s.minutes(60*Math.round(s.minutes()/60));else s.minutes(30*Math.round(s.minutes()/30));s.seconds(0),s.milliseconds(0)}else if("minute"==e){switch(i){case 15:case 10:s.minutes(5*Math.round(s.minutes()/5)),s.seconds(0);break;case 5:s.seconds(60*Math.round(s.seconds()/60));break;default:s.seconds(30*Math.round(s.seconds()/30))}s.milliseconds(0)}else if("second"==e)switch(i){case 15:case 10:s.seconds(5*Math.round(s.seconds()/5)),s.milliseconds(0);break;case 5:s.milliseconds(1e3*Math.round(s.milliseconds()/1e3));break;default:s.milliseconds(500*Math.round(s.milliseconds()/500))}else if("millisecond"==e){const t=i>5?i/2:1;s.milliseconds(Math.round(s.milliseconds()/t)*t)}return s}isMajor(){if(1==this.switchedYear)switch(this.scale){case"year":case"month":case"week":case"weekday":case"day":case"hour":case"minute":case"second":case"millisecond":return!0;default:return!1}else if(1==this.switchedMonth)switch(this.scale){case"week":case"weekday":case"day":case"hour":case"minute":case"second":case"millisecond":return!0;default:return!1}else if(1==this.switchedDay)switch(this.scale){case"millisecond":case"second":case"minute":case"hour":return!0;default:return!1}const t=this.moment(this.current);switch(this.scale){case"millisecond":return 0==t.milliseconds();case"second":return 0==t.seconds();case"minute":return 0==t.hours()&&0==t.minutes();case"hour":return 0==t.hours();case"weekday":case"day":return this.options.showWeekScale?1==t.isoWeekday():1==t.date();case"week":return 1==t.date();case"month":return 0==t.month();default:return!1}}getLabelMinor(t){if(null==t&&(t=this.current),t instanceof Date&&(t=this.moment(t)),"function"==typeof this.format.minorLabels)return this.format.minorLabels(t,this.scale,this.step);const e=this.format.minorLabels[this.scale];return"week"===this.scale&&1===t.date()&&0!==t.weekday()?"":e&&e.length>0?this.moment(t).format(e):""}getLabelMajor(t){if(null==t&&(t=this.current),t instanceof Date&&(t=this.moment(t)),"function"==typeof this.format.majorLabels)return this.format.majorLabels(t,this.scale,this.step);const e=this.format.majorLabels[this.scale];return e&&e.length>0?this.moment(t).format(e):""}getClassName(){const t=this.moment,e=this.moment(this.current),i=e.locale?e.locale("en"):e.lang("en"),s=this.step,o=[];function n(t){return t/s%2==0?" vis-even":" vis-odd"}function r(e){return e.isSame(Date.now(),"day")?" vis-today":e.isSame(t().add(1,"day"),"day")?" vis-tomorrow":e.isSame(t().add(-1,"day"),"day")?" vis-yesterday":""}function a(t){return t.isSame(Date.now(),"week")?" vis-current-week":""}function h(t){return t.isSame(Date.now(),"month")?" vis-current-month":""}switch(this.scale){case"millisecond":o.push(r(i)),o.push(n(i.milliseconds()));break;case"second":o.push(r(i)),o.push(n(i.seconds()));break;case"minute":o.push(r(i)),o.push(n(i.minutes()));break;case"hour":o.push(`vis-h${i.hours()}${4==this.step?"-h"+(i.hours()+4):""}`),o.push(r(i)),o.push(n(i.hours()));break;case"weekday":o.push(`vis-${i.format("dddd").toLowerCase()}`),o.push(r(i)),o.push(a(i)),o.push(n(i.date()));break;case"day":o.push(`vis-day${i.date()}`),o.push(`vis-${i.format("MMMM").toLowerCase()}`),o.push(r(i)),o.push(h(i)),o.push(this.step<=2?r(i):""),o.push(this.step<=2?`vis-${i.format("dddd").toLowerCase()}`:""),o.push(n(i.date()-1));break;case"week":o.push(`vis-week${i.format("w")}`),o.push(a(i)),o.push(n(i.week()));break;case"month":o.push(`vis-${i.format("MMMM").toLowerCase()}`),o.push(h(i)),o.push(n(i.month()));break;case"year":o.push(`vis-year${i.year()}`),o.push(function(t){return t.isSame(Date.now(),"year")?" vis-current-year":""}(i)),o.push(n(i.year()))}return o.filter(String).join(" ")}}U.FORMAT={minorLabels:{millisecond:"SSS",second:"s",minute:"HH:mm",hour:"HH:mm",weekday:"ddd D",day:"D",week:"w",month:"MMM",year:"YYYY"},majorLabels:{millisecond:"HH:mm:ss",second:"D MMMM HH:mm",minute:"ddd D MMMM",hour:"ddd D MMMM",weekday:"MMMM YYYY",day:"MMMM YYYY",week:"MMMM YYYY",month:"YYYY",year:""}};class X extends T{constructor(t,e){super(),this.dom={foreground:null,lines:[],majorTexts:[],minorTexts:[],redundant:{lines:[],majorTexts:[],minorTexts:[]}},this.props={range:{start:0,end:0,minimumStep:0},lineTop:0},this.defaultOptions={orientation:{axis:"bottom"},showMinorLabels:!0,showMajorLabels:!0,showWeekScale:!1,maxMinorChars:7,format:k.extend({},U.FORMAT),moment:b,timeAxis:null},this.options=k.extend({},this.defaultOptions),this.body=t,this._create(),this.setOptions(e)}setOptions(t){t&&(k.selectiveExtend(["showMinorLabels","showMajorLabels","showWeekScale","maxMinorChars","hiddenDates","timeAxis","moment","rtl"],this.options,t),k.selectiveDeepExtend(["format"],this.options,t),"orientation"in t&&("string"==typeof t.orientation?this.options.orientation.axis=t.orientation:"object"==typeof t.orientation&&"axis"in t.orientation&&(this.options.orientation.axis=t.orientation.axis)),"locale"in t&&("function"==typeof b.locale?b.locale(t.locale):b.lang(t.locale)))}_create(){this.dom.foreground=document.createElement("div"),this.dom.background=document.createElement("div"),this.dom.foreground.className="vis-time-axis vis-foreground",this.dom.background.className="vis-time-axis vis-background"}destroy(){this.dom.foreground.parentNode&&this.dom.foreground.parentNode.removeChild(this.dom.foreground),this.dom.background.parentNode&&this.dom.background.parentNode.removeChild(this.dom.background),this.body=null}redraw(){const t=this.props,e=this.dom.foreground,i=this.dom.background,s="top"==this.options.orientation.axis?this.body.dom.top:this.body.dom.bottom,o=e.parentNode!==s;this._calculateCharSize();const n=this.options.showMinorLabels&&"none"!==this.options.orientation.axis,r=this.options.showMajorLabels&&"none"!==this.options.orientation.axis;t.minorLabelHeight=n?t.minorCharHeight:0,t.majorLabelHeight=r?t.majorCharHeight:0,t.height=t.minorLabelHeight+t.majorLabelHeight,t.width=e.offsetWidth,t.minorLineHeight=this.body.domProps.root.height-t.majorLabelHeight-("top"==this.options.orientation.axis?this.body.domProps.bottom.height:this.body.domProps.top.height),t.minorLineWidth=1,t.majorLineHeight=t.minorLineHeight+t.majorLabelHeight,t.majorLineWidth=1;const a=e.nextSibling,h=i.nextSibling;return e.parentNode&&e.parentNode.removeChild(e),i.parentNode&&i.parentNode.removeChild(i),e.style.height=`${this.props.height}px`,this._repaintLabels(),a?s.insertBefore(e,a):s.appendChild(e),h?this.body.dom.backgroundVertical.insertBefore(i,h):this.body.dom.backgroundVertical.appendChild(i),this._isResized()||o}_repaintLabels(){const t=this.options.orientation.axis,e=k.convert(this.body.range.start,"Number"),i=k.convert(this.body.range.end,"Number"),s=this.body.util.toTime((this.props.minorCharWidth||10)*this.options.maxMinorChars).valueOf();let o=s-F(this.options.moment,this.body.hiddenDates,this.body.range,s);o-=this.body.util.toTime(0).valueOf();const n=new U(new Date(e),new Date(i),o,this.body.hiddenDates,this.options);n.setMoment(this.options.moment),this.options.format&&n.setFormat(this.options.format),this.options.timeAxis&&n.setScale(this.options.timeAxis),this.step=n;const r=this.dom;let a,h,l,d,p,m;r.redundant.lines=r.lines,r.redundant.majorTexts=r.majorTexts,r.redundant.minorTexts=r.minorTexts,r.lines=[],r.majorTexts=[],r.minorTexts=[];let c,u,g,f=0,b=0;const y=1e3;let v;for(n.start(),h=n.getCurrent(),d=this.body.util.toScreen(h);n.hasNext()&&b<y;){if(b++,p=n.isMajor(),v=n.getClassName(),a=h,l=d,n.next(),h=n.getCurrent(),d=this.body.util.toScreen(h),c=f,f=d-l,"week"===n.scale)m=!0;else m=f>=.4*c;if(this.options.showMinorLabels&&m){var w=this._repaintMinorText(l,n.getLabelMinor(a),t,v);w.style.width=`${f}px`}p&&this.options.showMajorLabels?(l>0&&(null==g&&(g=l),w=this._repaintMajorText(l,n.getLabelMajor(a),t,v)),u=this._repaintMajorLine(l,f,t,v)):m?u=this._repaintMinorLine(l,f,t,v):u&&(u.style.width=`${parseInt(u.style.width)+f}px`)}if(b!==y||q||(console.warn("Something is wrong with the Timeline scale. Limited drawing of grid lines to 1000 lines."),q=!0),this.options.showMajorLabels){const e=this.body.util.toTime(0),i=n.getLabelMajor(e),s=i.length*(this.props.majorCharWidth||10)+10;(null==g||s<g)&&this._repaintMajorText(0,i,t,v)}k.forEach(this.dom.redundant,(t=>{for(;t.length;){const e=t.pop();e&&e.parentNode&&e.parentNode.removeChild(e)}}))}_repaintMinorText(t,e,i,s){let o=this.dom.redundant.minorTexts.shift();if(!o){const t=document.createTextNode("");o=document.createElement("div"),o.appendChild(t),this.dom.foreground.appendChild(o)}this.dom.minorTexts.push(o),o.innerHTML=k.xss(e);let n="top"==i?this.props.majorLabelHeight:0;return this._setXY(o,t,n),o.className=`vis-text vis-minor ${s}`,o}_repaintMajorText(t,e,i,s){let o=this.dom.redundant.majorTexts.shift();if(!o){const t=document.createElement("div");o=document.createElement("div"),o.appendChild(t),this.dom.foreground.appendChild(o)}o.childNodes[0].innerHTML=k.xss(e),o.className=`vis-text vis-major ${s}`;let n="top"==i?0:this.props.minorLabelHeight;return this._setXY(o,t,n),this.dom.majorTexts.push(o),o}_setXY(t,e,i){const s=this.options.rtl?-1*e:e;t.style.transform=`translate(${s}px, ${i}px)`}_repaintMinorLine(t,e,i,s){let o=this.dom.redundant.lines.shift();o||(o=document.createElement("div"),this.dom.background.appendChild(o)),this.dom.lines.push(o);const n=this.props;o.style.width=`${e}px`,o.style.height=`${n.minorLineHeight}px`;let r="top"==i?n.majorLabelHeight:this.body.domProps.top.height,a=t-n.minorLineWidth/2;return this._setXY(o,a,r),o.className=`vis-grid ${this.options.rtl?"vis-vertical-rtl":"vis-vertical"} vis-minor ${s}`,o}_repaintMajorLine(t,e,i,s){let o=this.dom.redundant.lines.shift();o||(o=document.createElement("div"),this.dom.background.appendChild(o)),this.dom.lines.push(o);const n=this.props;o.style.width=`${e}px`,o.style.height=`${n.majorLineHeight}px`;let r="top"==i?0:this.body.domProps.top.height,a=t-n.majorLineWidth/2;return this._setXY(o,a,r),o.className=`vis-grid ${this.options.rtl?"vis-vertical-rtl":"vis-vertical"} vis-major ${s}`,o}_calculateCharSize(){this.dom.measureCharMinor||(this.dom.measureCharMinor=document.createElement("DIV"),this.dom.measureCharMinor.className="vis-text vis-minor vis-measure",this.dom.measureCharMinor.style.position="absolute",this.dom.measureCharMinor.appendChild(document.createTextNode("0")),this.dom.foreground.appendChild(this.dom.measureCharMinor)),this.props.minorCharHeight=this.dom.measureCharMinor.clientHeight,this.props.minorCharWidth=this.dom.measureCharMinor.clientWidth,this.dom.measureCharMajor||(this.dom.measureCharMajor=document.createElement("DIV"),this.dom.measureCharMajor.className="vis-text vis-major vis-measure",this.dom.measureCharMajor.style.position="absolute",this.dom.measureCharMajor.appendChild(document.createTextNode("0")),this.dom.foreground.appendChild(this.dom.measureCharMajor)),this.props.majorCharHeight=this.dom.measureCharMajor.clientHeight,this.props.majorCharWidth=this.dom.measureCharMajor.clientWidth}}var q=!1;function K(t){this.active=!1,this.dom={container:t},this.dom.overlay=document.createElement("div"),this.dom.overlay.className="vis-overlay",this.dom.container.appendChild(this.dom.overlay),this.hammer=W(this.dom.overlay),this.hammer.on("tap",this._onTapOverlay.bind(this));var e=this;["tap","doubletap","press","pinch","pan","panstart","panmove","panend"].forEach((function(t){e.hammer.on(t,(function(t){t.stopPropagation()}))})),document&&document.body&&(this.onClick=function(i){(function(t,e){for(;t;){if(t===e)return!0;t=t.parentNode}return!1})(i.target,t)||e.deactivate()},document.body.addEventListener("click",this.onClick)),void 0!==this.keycharm&&this.keycharm.destroy(),this.keycharm=g(),this.escListener=this.deactivate.bind(this)}m(K.prototype),K.current=null,K.prototype.destroy=function(){this.deactivate(),this.dom.overlay.parentNode.removeChild(this.dom.overlay),this.onClick&&document.body.removeEventListener("click",this.onClick),void 0!==this.keycharm&&this.keycharm.destroy(),this.keycharm=null,this.hammer.destroy(),this.hammer=null},K.prototype.activate=function(){K.current&&K.current.deactivate(),K.current=this,this.active=!0,this.dom.overlay.style.display="none",k.addClassName(this.dom.container,"vis-active"),this.emit("change"),this.emit("activate"),this.keycharm.bind("esc",this.escListener)},K.prototype.deactivate=function(){K.current===this&&(K.current=null),this.active=!1,this.dom.overlay.style.display="",k.removeClassName(this.dom.container,"vis-active"),this.keycharm.unbind("esc",this.escListener),this.emit("change"),this.emit("deactivate")},K.prototype._onTapOverlay=function(t){this.activate(),t.stopPropagation()};const J={current:"current",time:"time",deleteSelected:"Delete selected"},Z={current:"attuale",time:"tempo",deleteSelected:"Cancella la selezione"},Q={current:"huidige",time:"tijd",deleteSelected:"Selectie verwijderen"},tt={current:"Aktuelle",time:"Zeit",deleteSelected:"Lösche Auswahl"},et={current:"actuel",time:"heure",deleteSelected:"Effacer la selection"},it={current:"corriente",time:"hora",deleteSelected:"Eliminar selección"},st={current:"поточний",time:"час",deleteSelected:"Видалити обране"},ot={current:"текущее",time:"время",deleteSelected:"Удалить выбранное"},nt={current:"aktualny",time:"czas",deleteSelected:"Usuń wybrane"},rt={current:"atual",time:"data",deleteSelected:"Apagar selecionado"},at={current:"現在",time:"時刻",deleteSelected:"選択されたものを削除"},ht={current:"nuvarande",time:"tid",deleteSelected:"Radera valda"},lt={current:"nåværende",time:"tid",deleteSelected:"Slett valgte"},dt={current:"einamas",time:"laikas",deleteSelected:"Pašalinti pasirinktą"},pt={en:J,en_EN:J,en_US:J,it:Z,it_IT:Z,it_CH:Z,nl:Q,nl_NL:Q,nl_BE:Q,de:tt,de_DE:tt,fr:et,fr_FR:et,fr_CA:et,fr_BE:et,es:it,es_ES:it,uk:st,uk_UA:st,ru:ot,ru_RU:ot,pl:nt,pl_PL:nt,pt:rt,pt_BR:rt,pt_PT:rt,ja:at,ja_JP:at,lt:dt,lt_LT:dt,sv:ht,sv_SE:ht,nb:lt,nn:lt,nb_NO:lt,nn_NO:lt};class mt extends T{constructor(t,e){super(),this.body=t,this.defaultOptions={moment:b,locales:pt,locale:"en",id:void 0,title:void 0},this.options=k.extend({},this.defaultOptions),this.setOptions(e),this.options.locales=k.extend({},pt,this.options.locales);const i=this.defaultOptions.locales[this.defaultOptions.locale];Object.keys(this.options.locales).forEach((t=>{this.options.locales[t]=k.extend({},i,this.options.locales[t])})),e&&null!=e.time?this.customTime=e.time:this.customTime=new Date,this.eventParams={},this._create()}setOptions(t){t&&k.selectiveExtend(["moment","locale","locales","id","title","rtl","snap"],this.options,t)}_create(){const t=document.createElement("div");t["custom-time"]=this,t.className=`vis-custom-time ${this.options.id||""}`,t.style.position="absolute",t.style.top="0px",t.style.height="100%",this.bar=t;const e=document.createElement("div");function i(t){this.body.range._onMouseWheel(t)}e.style.position="relative",e.style.top="0px",this.options.rtl?e.style.right="-10px":e.style.left="-10px",e.style.height="100%",e.style.width="20px",e.addEventListener?(e.addEventListener("mousewheel",i.bind(this),!1),e.addEventListener("DOMMouseScroll",i.bind(this),!1)):e.attachEvent("onmousewheel",i.bind(this)),t.appendChild(e),this.hammer=new W(e),this.hammer.on("panstart",this._onDragStart.bind(this)),this.hammer.on("panmove",this._onDrag.bind(this)),this.hammer.on("panend",this._onDragEnd.bind(this)),this.hammer.get("pan").set({threshold:5,direction:W.DIRECTION_ALL}),this.hammer.get("press").set({time:1e4})}destroy(){this.hide(),this.hammer.destroy(),this.hammer=null,this.body=null}redraw(){const t=this.body.dom.backgroundVertical;this.bar.parentNode!=t&&(this.bar.parentNode&&this.bar.parentNode.removeChild(this.bar),t.appendChild(this.bar));const e=this.body.util.toScreen(this.customTime);let i=this.options.locales[this.options.locale];i||(this.warned||(console.warn(`WARNING: options.locales['${this.options.locale}'] not found. See https://visjs.github.io/vis-timeline/docs/timeline/#Localization`),this.warned=!0),i=this.options.locales.en);let s=this.options.title;return void 0===s?(s=`${i.time}: ${this.options.moment(this.customTime).format("dddd, MMMM Do YYYY, H:mm:ss")}`,s=s.charAt(0).toUpperCase()+s.substring(1)):"function"==typeof s&&(s=s.call(this,this.customTime)),this.options.rtl?this.bar.style.right=`${e}px`:this.bar.style.left=`${e}px`,this.bar.title=s,!1}hide(){this.bar.parentNode&&this.bar.parentNode.removeChild(this.bar)}setCustomTime(t){this.customTime=k.convert(t,"Date"),this.redraw()}getCustomTime(){return new Date(this.customTime.valueOf())}setCustomMarker(t,e){this.marker&&this.bar.removeChild(this.marker),this.marker=document.createElement("div"),this.marker.className="vis-custom-time-marker",this.marker.innerHTML=k.xss(t),this.marker.style.position="absolute",e&&(this.marker.setAttribute("contenteditable","true"),this.marker.addEventListener("pointerdown",(function(){this.marker.focus()})),this.marker.addEventListener("input",this._onMarkerChange.bind(this)),this.marker.title=t,this.marker.addEventListener("blur",function(t){this.title!=t.target.innerHTML&&(this._onMarkerChanged(t),this.title=t.target.innerHTML)}.bind(this))),this.bar.appendChild(this.marker)}setCustomTitle(t){this.options.title=t}_onDragStart(t){this.eventParams.dragging=!0,this.eventParams.customTime=this.customTime,t.stopPropagation()}_onDrag(t){if(!this.eventParams.dragging)return;let e=this.options.rtl?-1*t.deltaX:t.deltaX;const i=this.body.util.toScreen(this.eventParams.customTime)+e,s=this.body.util.toTime(i),o=this.body.util.getScale(),n=this.body.util.getStep(),r=this.options.snap,a=r?r(s,o,n):s;this.setCustomTime(a),this.body.emitter.emit("timechange",{id:this.options.id,time:new Date(this.customTime.valueOf()),event:t}),t.stopPropagation()}_onDragEnd(t){this.eventParams.dragging&&(this.body.emitter.emit("timechanged",{id:this.options.id,time:new Date(this.customTime.valueOf()),event:t}),t.stopPropagation())}_onMarkerChange(t){this.body.emitter.emit("markerchange",{id:this.options.id,title:t.target.innerHTML,event:t}),t.stopPropagation()}_onMarkerChanged(t){this.body.emitter.emit("markerchanged",{id:this.options.id,title:t.target.innerHTML,event:t}),t.stopPropagation()}static customTimeFromTarget(t){let e=t.target;for(;e;){if(e.hasOwnProperty("custom-time"))return e["custom-time"];e=e.parentNode}return null}}class ct{_create(t){this.dom={},this.dom.container=t,this.dom.container.style.position="relative",this.dom.root=document.createElement("div"),this.dom.background=document.createElement("div"),this.dom.backgroundVertical=document.createElement("div"),this.dom.backgroundHorizontal=document.createElement("div"),this.dom.centerContainer=document.createElement("div"),this.dom.leftContainer=document.createElement("div"),this.dom.rightContainer=document.createElement("div"),this.dom.center=document.createElement("div"),this.dom.left=document.createElement("div"),this.dom.right=document.createElement("div"),this.dom.top=document.createElement("div"),this.dom.bottom=document.createElement("div"),this.dom.shadowTop=document.createElement("div"),this.dom.shadowBottom=document.createElement("div"),this.dom.shadowTopLeft=document.createElement("div"),this.dom.shadowBottomLeft=document.createElement("div"),this.dom.shadowTopRight=document.createElement("div"),this.dom.shadowBottomRight=document.createElement("div"),this.dom.rollingModeBtn=document.createElement("div"),this.dom.loadingScreen=document.createElement("div"),this.dom.root.className="vis-timeline",this.dom.background.className="vis-panel vis-background",this.dom.backgroundVertical.className="vis-panel vis-background vis-vertical",this.dom.backgroundHorizontal.className="vis-panel vis-background vis-horizontal",this.dom.centerContainer.className="vis-panel vis-center",this.dom.leftContainer.className="vis-panel vis-left",this.dom.rightContainer.className="vis-panel vis-right",this.dom.top.className="vis-panel vis-top",this.dom.bottom.className="vis-panel vis-bottom",this.dom.left.className="vis-content",this.dom.center.className="vis-content",this.dom.right.className="vis-content",this.dom.shadowTop.className="vis-shadow vis-top",this.dom.shadowBottom.className="vis-shadow vis-bottom",this.dom.shadowTopLeft.className="vis-shadow vis-top",this.dom.shadowBottomLeft.className="vis-shadow vis-bottom",this.dom.shadowTopRight.className="vis-shadow vis-top",this.dom.shadowBottomRight.className="vis-shadow vis-bottom",this.dom.rollingModeBtn.className="vis-rolling-mode-btn",this.dom.loadingScreen.className="vis-loading-screen",this.dom.root.appendChild(this.dom.background),this.dom.root.appendChild(this.dom.backgroundVertical),this.dom.root.appendChild(this.dom.backgroundHorizontal),this.dom.root.appendChild(this.dom.centerContainer),this.dom.root.appendChild(this.dom.leftContainer),this.dom.root.appendChild(this.dom.rightContainer),this.dom.root.appendChild(this.dom.top),this.dom.root.appendChild(this.dom.bottom),this.dom.root.appendChild(this.dom.rollingModeBtn),this.dom.centerContainer.appendChild(this.dom.center),this.dom.leftContainer.appendChild(this.dom.left),this.dom.rightContainer.appendChild(this.dom.right),this.dom.centerContainer.appendChild(this.dom.shadowTop),this.dom.centerContainer.appendChild(this.dom.shadowBottom),this.dom.leftContainer.appendChild(this.dom.shadowTopLeft),this.dom.leftContainer.appendChild(this.dom.shadowBottomLeft),this.dom.rightContainer.appendChild(this.dom.shadowTopRight),this.dom.rightContainer.appendChild(this.dom.shadowBottomRight),this.props={root:{},background:{},centerContainer:{},leftContainer:{},rightContainer:{},center:{},left:{},right:{},top:{},bottom:{},border:{},scrollTop:0,scrollTopMin:0},this.on("rangechange",(()=>{!0===this.initialDrawDone&&this._redraw()})),this.on("rangechanged",(()=>{this.initialRangeChangeDone||(this.initialRangeChangeDone=!0)})),this.on("touch",this._onTouch.bind(this)),this.on("panmove",this._onDrag.bind(this));const e=this;this._origRedraw=this._redraw.bind(this),this._redraw=k.throttle(this._origRedraw),this.on("_change",(t=>{e.itemSet&&e.itemSet.initialItemSetDrawn&&t&&1==t.queue?e._redraw():e._origRedraw()})),this.hammer=new W(this.dom.root);const i=this.hammer.get("pinch").set({enable:!0});i&&function(t){t.getTouchAction=function(){return["pan-y"]}}(i),this.hammer.get("pan").set({threshold:5,direction:W.DIRECTION_ALL}),this.timelineListeners={};var s,o;function n(t){this.isActive()&&this.emit("mousewheel",t);let e=0,i=0;if("detail"in t&&(i=-1*t.detail),"wheelDelta"in t&&(i=t.wheelDelta),"wheelDeltaY"in t&&(i=t.wheelDeltaY),"wheelDeltaX"in t&&(e=-1*t.wheelDeltaX),"axis"in t&&t.axis===t.HORIZONTAL_AXIS&&(e=-1*i,i=0),"deltaY"in t&&(i=-1*t.deltaY),"deltaX"in t&&(e=t.deltaX),t.deltaMode&&(1===t.deltaMode?(e*=40,i*=40):(e*=40,i*=800)),this.options.preferZoom){if(!this.options.zoomKey||t[this.options.zoomKey])return}else if(this.options.zoomKey&&t[this.options.zoomKey])return;if(this.options.verticalScroll||this.options.horizontalScroll)if(this.options.verticalScroll&&Math.abs(i)>=Math.abs(e)){const e=this.props.scrollTop,s=e+i;if(this.isActive()){this._setScrollTop(s)!==e&&(this._redraw(),this.emit("scroll",t),t.preventDefault())}}else if(this.options.horizontalScroll){const s=(Math.abs(e)>=Math.abs(i)?e:i)/120*(this.range.end-this.range.start)/20,o=this.range.start+s,n=this.range.end+s,r={animation:!1,byUser:!0,event:t};this.range.setRange(o,n,r),t.preventDefault()}}["tap","doubletap","press","pinch","pan","panstart","panmove","panend"].forEach((t=>{const i=i=>{e.isActive()&&e.emit(t,i)};e.hammer.on(t,i),e.timelineListeners[t]=i})),V(this.hammer,(t=>{e.emit("touch",t)})),s=this.hammer,(o=t=>{e.emit("release",t)}).inputHandler=function(t){t.isFinal&&o(t)},s.on("hammer.input",o.inputHandler);const r="onwheel"in document.createElement("div")?"wheel":void 0!==document.onmousewheel?"mousewheel":this.dom.centerContainer.addEventListener?"DOMMouseScroll":"onmousewheel";function a(t){if(e.options.verticalScroll&&(t.preventDefault(),e.isActive())){const i=-t.target.scrollTop;e._setScrollTop(i),e._redraw(),e.emit("scrollSide",t)}}this.dom.top.addEventListener,this.dom.bottom.addEventListener,this.dom.centerContainer.addEventListener(r,n.bind(this),!1),this.dom.top.addEventListener(r,n.bind(this),!1),this.dom.bottom.addEventListener(r,n.bind(this),!1),this.dom.left.parentNode.addEventListener("scroll",a.bind(this)),this.dom.right.parentNode.addEventListener("scroll",a.bind(this));let h=!1;if(this.dom.center.addEventListener("dragover",function(t){if(t.preventDefault&&(e.emit("dragover",e.getEventProperties(t)),t.preventDefault()),t.target.className.indexOf("timeline")>-1&&!h)return t.dataTransfer.dropEffect="move",h=!0,!1}.bind(this),!1),this.dom.center.addEventListener("drop",function(t){t.preventDefault&&t.preventDefault(),t.stopPropagation&&t.stopPropagation();try{var i=JSON.parse(t.dataTransfer.getData("text"));if(!i||!i.content)return}catch(t){return!1}return h=!1,t.center={x:t.clientX,y:t.clientY},"item"!==i.target?e.itemSet._onAddItem(t):e.itemSet._onDropObjectOnItem(t),e.emit("drop",e.getEventProperties(t)),!1}.bind(this),!1),this.customTimes=[],this.touch={},this.redrawCount=0,this.initialDrawDone=!1,this.initialRangeChangeDone=!1,!t)throw new Error("No container provided");t.appendChild(this.dom.root),t.appendChild(this.dom.loadingScreen)}setOptions(t){if(t){const e=["width","height","minHeight","maxHeight","autoResize","start","end","clickToUse","dataAttributes","hiddenDates","locale","locales","moment","preferZoom","rtl","zoomKey","horizontalScroll","verticalScroll","longSelectPressTime","snap"];if(k.selectiveExtend(e,this.options,t),this.dom.rollingModeBtn.style.visibility="hidden",this.options.rtl&&(this.dom.container.style.direction="rtl",this.dom.backgroundVertical.className="vis-panel vis-background vis-vertical-rtl"),this.options.verticalScroll&&(this.options.rtl?this.dom.rightContainer.className="vis-panel vis-right vis-vertical-scroll":this.dom.leftContainer.className="vis-panel vis-left vis-vertical-scroll"),"object"!=typeof this.options.orientation&&(this.options.orientation={item:void 0,axis:void 0}),"orientation"in t&&("string"==typeof t.orientation?this.options.orientation={item:t.orientation,axis:t.orientation}:"object"==typeof t.orientation&&("item"in t.orientation&&(this.options.orientation.item=t.orientation.item),"axis"in t.orientation&&(this.options.orientation.axis=t.orientation.axis))),"both"===this.options.orientation.axis){if(!this.timeAxis2){const t=this.timeAxis2=new X(this.body,this.options);t.setOptions=e=>{const i=e?k.extend({},e):{};i.orientation="top",X.prototype.setOptions.call(t,i)},this.components.push(t)}}else if(this.timeAxis2){const t=this.components.indexOf(this.timeAxis2);-1!==t&&this.components.splice(t,1),this.timeAxis2.destroy(),this.timeAxis2=null}"function"==typeof t.drawPoints&&(t.drawPoints={onRender:t.drawPoints}),"hiddenDates"in this.options&&E(this.options.moment,this.body,this.options.hiddenDates),"clickToUse"in t&&(t.clickToUse?this.activator||(this.activator=new K(this.dom.root)):this.activator&&(this.activator.destroy(),delete this.activator)),this._initAutoResize()}if(this.components.forEach((e=>e.setOptions(t))),"configure"in t){this.configurator||(this.configurator=this._createConfigurator()),this.configurator.setOptions(t.configure);const e=k.deepExtend({},this.options);this.components.forEach((t=>{k.deepExtend(e,t.options)})),this.configurator.setModuleOptions({global:e})}this._redraw()}isActive(){return!this.activator||this.activator.active}destroy(){this.setItems(null),this.setGroups(null),this.off(),this._stopAutoResize(),this.dom.root.parentNode&&this.dom.root.parentNode.removeChild(this.dom.root),this.dom=null,this.activator&&(this.activator.destroy(),delete this.activator);for(const t in this.timelineListeners)this.timelineListeners.hasOwnProperty(t)&&delete this.timelineListeners[t];this.timelineListeners=null,this.hammer&&this.hammer.destroy(),this.hammer=null,this.components.forEach((t=>t.destroy())),this.body=null}setCustomTime(t,e){const i=this.customTimes.filter((t=>e===t.options.id));if(0===i.length)throw new Error(`No custom time bar found with id ${JSON.stringify(e)}`);i.length>0&&i[0].setCustomTime(t)}getCustomTime(t){const e=this.customTimes.filter((e=>e.options.id===t));if(0===e.length)throw new Error(`No custom time bar found with id ${JSON.stringify(t)}`);return e[0].getCustomTime()}setCustomTimeMarker(t,e,i){const s=this.customTimes.filter((t=>t.options.id===e));if(0===s.length)throw new Error(`No custom time bar found with id ${JSON.stringify(e)}`);s.length>0&&s[0].setCustomMarker(t,i)}setCustomTimeTitle(t,e){const i=this.customTimes.filter((t=>t.options.id===e));if(0===i.length)throw new Error(`No custom time bar found with id ${JSON.stringify(e)}`);if(i.length>0)return i[0].setCustomTitle(t)}getEventProperties(t){return{event:t}}addCustomTime(t,e){const i=void 0!==t?k.convert(t,"Date"):new Date,s=this.customTimes.some((t=>t.options.id===e));if(s)throw new Error(`A custom time with id ${JSON.stringify(e)} already exists`);const o=new mt(this.body,k.extend({},this.options,{time:i,id:e,snap:this.itemSet?this.itemSet.options.snap:this.options.snap}));return this.customTimes.push(o),this.components.push(o),this._redraw(),e}removeCustomTime(t){const e=this.customTimes.filter((e=>e.options.id===t));if(0===e.length)throw new Error(`No custom time bar found with id ${JSON.stringify(t)}`);e.forEach((t=>{this.customTimes.splice(this.customTimes.indexOf(t),1),this.components.splice(this.components.indexOf(t),1),t.destroy()}))}getVisibleItems(){return this.itemSet&&this.itemSet.getVisibleItems()||[]}getItemsAtCurrentTime(t){return this.time=t,this.itemSet&&this.itemSet.getItemsAtCurrentTime(this.time)||[]}getVisibleGroups(){return this.itemSet&&this.itemSet.getVisibleGroups()||[]}fit(t,e){const i=this.getDataRange();if(null===i.min&&null===i.max)return;const s=i.max-i.min,o=new Date(i.min.valueOf()-.01*s),n=new Date(i.max.valueOf()+.01*s),r=!t||void 0===t.animation||t.animation;this.range.setRange(o,n,{animation:r},e)}getDataRange(){throw new Error("Cannot invoke abstract method getDataRange")}setWindow(t,e,i,s){let o,n;"function"==typeof arguments[2]&&(s=arguments[2],i={}),1==arguments.length?(n=arguments[0],o=void 0===n.animation||n.animation,this.range.setRange(n.start,n.end,{animation:o})):2==arguments.length&&"function"==typeof arguments[1]?(n=arguments[0],s=arguments[1],o=void 0===n.animation||n.animation,this.range.setRange(n.start,n.end,{animation:o},s)):(o=!i||void 0===i.animation||i.animation,this.range.setRange(t,e,{animation:o},s))}moveTo(t,e,i){"function"==typeof arguments[1]&&(i=arguments[1],e={});const s=this.range.end-this.range.start,o=k.convert(t,"Date").valueOf(),n=o-s/2,r=o+s/2,a=!e||void 0===e.animation||e.animation;this.range.setRange(n,r,{animation:a},i)}getWindow(){const t=this.range.getRange();return{start:new Date(t.start),end:new Date(t.end)}}zoomIn(t,e,i){if(!t||t<0||t>1)return;"function"==typeof arguments[1]&&(i=arguments[1],e={});const s=this.getWindow(),o=s.start.valueOf(),n=s.end.valueOf(),r=n-o,a=(r-r/(1+t))/2,h=o+a,l=n-a;this.setWindow(h,l,e,i)}zoomOut(t,e,i){if(!t||t<0||t>1)return;"function"==typeof arguments[1]&&(i=arguments[1],e={});const s=this.getWindow(),o=s.start.valueOf(),n=s.end.valueOf(),r=n-o,a=o-r*t/2,h=n+r*t/2;this.setWindow(a,h,e,i)}redraw(){this._redraw()}_redraw(){this.redrawCount++;const t=this.dom;if(!t||!t.container||0==t.root.offsetWidth)return;let e=!1;const i=this.options,s=this.props;O(this.options.moment,this.body,this.options.hiddenDates),"top"==i.orientation?(k.addClassName(t.root,"vis-top"),k.removeClassName(t.root,"vis-bottom")):(k.removeClassName(t.root,"vis-top"),k.addClassName(t.root,"vis-bottom")),i.rtl?(k.addClassName(t.root,"vis-rtl"),k.removeClassName(t.root,"vis-ltr")):(k.addClassName(t.root,"vis-ltr"),k.removeClassName(t.root,"vis-rtl")),t.root.style.maxHeight=k.option.asSize(i.maxHeight,""),t.root.style.minHeight=k.option.asSize(i.minHeight,""),t.root.style.width=k.option.asSize(i.width,"");const o=t.root.offsetWidth;s.border.left=1,s.border.right=1,s.border.top=1,s.border.bottom=1,s.center.height=t.center.offsetHeight,s.left.height=t.left.offsetHeight,s.right.height=t.right.offsetHeight,s.top.height=t.top.clientHeight||-s.border.top,s.bottom.height=Math.round(t.bottom.getBoundingClientRect().height)||t.bottom.clientHeight||-s.border.bottom;const n=Math.max(s.left.height,s.center.height,s.right.height),r=s.top.height+n+s.bottom.height+s.border.top+s.border.bottom;t.root.style.height=k.option.asSize(i.height,`${r}px`),s.root.height=t.root.offsetHeight,s.background.height=s.root.height;const a=s.root.height-s.top.height-s.bottom.height;s.centerContainer.height=a,s.leftContainer.height=a,s.rightContainer.height=s.leftContainer.height,s.root.width=o,s.background.width=s.root.width,this.initialDrawDone||(s.scrollbarWidth=k.getScrollBarWidth());const h=t.leftContainer.clientWidth,l=t.rightContainer.clientWidth;i.verticalScroll?i.rtl?(s.left.width=h||-s.border.left,s.right.width=l+s.scrollbarWidth||-s.border.right):(s.left.width=h+s.scrollbarWidth||-s.border.left,s.right.width=l||-s.border.right):(s.left.width=h||-s.border.left,s.right.width=l||-s.border.right),this._setDOM();let d=this._updateScrollTop();"top"!=i.orientation.item&&(d+=Math.max(s.centerContainer.height-s.center.height-s.border.top-s.border.bottom,0)),t.center.style.transform=`translateY(${d}px)`;const p=0==s.scrollTop?"hidden":"",m=s.scrollTop==s.scrollTopMin?"hidden":"";t.shadowTop.style.visibility=p,t.shadowBottom.style.visibility=m,t.shadowTopLeft.style.visibility=p,t.shadowBottomLeft.style.visibility=m,t.shadowTopRight.style.visibility=p,t.shadowBottomRight.style.visibility=m,i.verticalScroll&&(t.rightContainer.className="vis-panel vis-right vis-vertical-scroll",t.leftContainer.className="vis-panel vis-left vis-vertical-scroll",t.shadowTopRight.style.visibility="hidden",t.shadowBottomRight.style.visibility="hidden",t.shadowTopLeft.style.visibility="hidden",t.shadowBottomLeft.style.visibility="hidden",t.left.style.top="0px",t.right.style.top="0px"),(!i.verticalScroll||s.center.height<s.centerContainer.height)&&(t.left.style.top=`${d}px`,t.right.style.top=`${d}px`,t.rightContainer.className=t.rightContainer.className.replace(new RegExp("(?:^|\\s)vis-vertical-scroll(?:\\s|$)")," "),t.leftContainer.className=t.leftContainer.className.replace(new RegExp("(?:^|\\s)vis-vertical-scroll(?:\\s|$)")," "),s.left.width=h||-s.border.left,s.right.width=l||-s.border.right,this._setDOM());const c=s.center.height>s.centerContainer.height;this.hammer.get("pan").set({direction:c?W.DIRECTION_ALL:W.DIRECTION_HORIZONTAL}),this.hammer.get("press").set({time:this.options.longSelectPressTime}),this.components.forEach((t=>{e=t.redraw()||e}));if(e){if(this.redrawCount<5)return void this.body.emitter.emit("_change");console.log("WARNING: infinite loop in redraw?")}else this.redrawCount=0;this.body.emitter.emit("changed")}_setDOM(){const t=this.props,e=this.dom;t.leftContainer.width=t.left.width,t.rightContainer.width=t.right.width;const i=t.root.width-t.left.width-t.right.width;t.center.width=i,t.centerContainer.width=i,t.top.width=i,t.bottom.width=i,e.background.style.height=`${t.background.height}px`,e.backgroundVertical.style.height=`${t.background.height}px`,e.backgroundHorizontal.style.height=`${t.centerContainer.height}px`,e.centerContainer.style.height=`${t.centerContainer.height}px`,e.leftContainer.style.height=`${t.leftContainer.height}px`,e.rightContainer.style.height=`${t.rightContainer.height}px`,e.background.style.width=`${t.background.width}px`,e.backgroundVertical.style.width=`${t.centerContainer.width}px`,e.backgroundHorizontal.style.width=`${t.background.width}px`,e.centerContainer.style.width=`${t.center.width}px`,e.top.style.width=`${t.top.width}px`,e.bottom.style.width=`${t.bottom.width}px`,e.background.style.left="0",e.background.style.top="0",e.backgroundVertical.style.left=`${t.left.width+t.border.left}px`,e.backgroundVertical.style.top="0",e.backgroundHorizontal.style.left="0",e.backgroundHorizontal.style.top=`${t.top.height}px`,e.centerContainer.style.left=`${t.left.width}px`,e.centerContainer.style.top=`${t.top.height}px`,e.leftContainer.style.left="0",e.leftContainer.style.top=`${t.top.height}px`,e.rightContainer.style.left=`${t.left.width+t.center.width}px`,e.rightContainer.style.top=`${t.top.height}px`,e.top.style.left=`${t.left.width}px`,e.top.style.top="0",e.bottom.style.left=`${t.left.width}px`,e.bottom.style.top=`${t.top.height+t.centerContainer.height}px`,e.center.style.left="0",e.left.style.left="0",e.right.style.left="0"}setCurrentTime(t){if(!this.currentTime)throw new Error("Option showCurrentTime must be true");this.currentTime.setCurrentTime(t)}getCurrentTime(){if(!this.currentTime)throw new Error("Option showCurrentTime must be true");return this.currentTime.getCurrentTime()}_toTime(t){return P(this,t,this.props.center.width)}_toGlobalTime(t){return P(this,t,this.props.root.width)}_toScreen(t){return N(this,t,this.props.center.width)}_toGlobalScreen(t){return N(this,t,this.props.root.width)}_initAutoResize(){1==this.options.autoResize?this._startAutoResize():this._stopAutoResize()}_startAutoResize(){const t=this;this._stopAutoResize(),this._onResize=()=>{if(1==t.options.autoResize){if(t.dom.root){const e=t.dom.root.offsetHeight,i=t.dom.root.offsetWidth;i==t.props.lastWidth&&e==t.props.lastHeight||(t.props.lastWidth=i,t.props.lastHeight=e,t.props.scrollbarWidth=k.getScrollBarWidth(),t.body.emitter.emit("_change"))}}else t._stopAutoResize()},window.addEventListener("resize",this._onResize),t.dom.root&&(t.props.lastWidth=t.dom.root.offsetWidth,t.props.lastHeight=t.dom.root.offsetHeight),this.watchTimer=setInterval(this._onResize,1e3)}_stopAutoResize(){this.watchTimer&&(clearInterval(this.watchTimer),this.watchTimer=void 0),this._onResize&&(window.removeEventListener("resize",this._onResize),this._onResize=null)}_onTouch(t){this.touch.allowDragging=!0,this.touch.initialScrollTop=this.props.scrollTop}_onPinch(t){this.touch.allowDragging=!1}_onDrag(t){if(!t)return;if(!this.touch.allowDragging)return;const e=t.deltaY,i=this._getScrollTop(),s=this._setScrollTop(this.touch.initialScrollTop+e);this.options.verticalScroll&&(this.dom.left.parentNode.scrollTop=-this.props.scrollTop,this.dom.right.parentNode.scrollTop=-this.props.scrollTop),s!=i&&this.emit("verticalDrag")}_setScrollTop(t){return this.props.scrollTop=t,this._updateScrollTop(),this.props.scrollTop}_updateScrollTop(){const t=Math.min(this.props.centerContainer.height-this.props.border.top-this.props.border.bottom-this.props.center.height,0);return t!=this.props.scrollTopMin&&("top"!=this.options.orientation.item&&(this.props.scrollTop+=t-this.props.scrollTopMin),this.props.scrollTopMin=t),this.props.scrollTop>0&&(this.props.scrollTop=0),this.props.scrollTop<t&&(this.props.scrollTop=t),this.options.verticalScroll&&(this.dom.left.parentNode.scrollTop=-this.props.scrollTop,this.dom.right.parentNode.scrollTop=-this.props.scrollTop),this.props.scrollTop}_getScrollTop(){return this.props.scrollTop}_createConfigurator(){throw new Error("Cannot invoke abstract method _createConfigurator")}}m(ct.prototype);class ut extends T{constructor(t,e){super(),this.body=t,this.defaultOptions={rtl:!1,showCurrentTime:!0,alignCurrentTime:void 0,moment:b,locales:pt,locale:"en"},this.options=k.extend({},this.defaultOptions),this.setOptions(e),this.options.locales=k.extend({},pt,this.options.locales);const i=this.defaultOptions.locales[this.defaultOptions.locale];Object.keys(this.options.locales).forEach((t=>{this.options.locales[t]=k.extend({},i,this.options.locales[t])})),this.offset=0,this._create()}_create(){const t=document.createElement("div");t.className="vis-current-time",t.style.position="absolute",t.style.top="0px",t.style.height="100%",this.bar=t}destroy(){this.options.showCurrentTime=!1,this.redraw(),this.body=null}setOptions(t){t&&k.selectiveExtend(["rtl","showCurrentTime","alignCurrentTime","moment","locale","locales"],this.options,t)}redraw(){if(this.options.showCurrentTime){const t=this.body.dom.backgroundVertical;this.bar.parentNode!=t&&(this.bar.parentNode&&this.bar.parentNode.removeChild(this.bar),t.appendChild(this.bar),this.start());let e=this.options.moment(Date.now()+this.offset);this.options.alignCurrentTime&&(e=e.startOf(this.options.alignCurrentTime));const i=this.body.util.toScreen(e);let s=this.options.locales[this.options.locale];s||(this.warned||(console.warn(`WARNING: options.locales['${this.options.locale}'] not found. See https://visjs.github.io/vis-timeline/docs/timeline/#Localization`),this.warned=!0),s=this.options.locales.en);let o=`${s.current} ${s.time}: ${e.format("dddd, MMMM Do YYYY, H:mm:ss")}`;o=o.charAt(0).toUpperCase()+o.substring(1),this.options.rtl?this.bar.style.transform=`translateX(${-1*i}px)`:this.bar.style.transform=`translateX(${i}px)`,this.bar.title=o}else this.bar.parentNode&&this.bar.parentNode.removeChild(this.bar),this.stop();return!1}start(){const t=this;!function e(){t.stop();let i=1/t.body.range.conversion(t.body.domProps.center.width).scale/10;i<30&&(i=30),i>1e3&&(i=1e3),t.redraw(),t.body.emitter.emit("currentTimeTick"),t.currentTimeTimer=setTimeout(e,i)}()}stop(){void 0!==this.currentTimeTimer&&(clearTimeout(this.currentTimeTimer),delete this.currentTimeTimer)}setCurrentTime(t){const e=k.convert(t,"Date").valueOf(),i=Date.now();this.offset=e-i,this.redraw()}getCurrentTime(){return new Date(Date.now()+this.offset)}}const gt=.001;function ft(t){t.sort(((t,e)=>t.data.start-e.data.start))}function bt(t){t.sort(((t,e)=>("end"in t.data?t.data.end:t.data.start)-("end"in e.data?e.data.end:e.data.start)))}function yt(t,e,i,s){return null===Dt(t,e.item,!1,(t=>t.stack&&(i||null===t.top)),(t=>t.stack),(t=>e.axis),s)}function vt(t,e,i){const s=Dt(t,e.item,!1,(t=>t.stack),(t=>!0),(t=>t.baseTop));i.height=s-i.top+.5*e.item.vertical}function wt(t,e,i,s){for(let o=0;o<t.length;o++)if(null==t[o].data.subgroup)t[o].top=e.item.vertical;else if(void 0!==t[o].data.subgroup&&s){let s=0;for(const e in i)i.hasOwnProperty(e)&&1==i[e].visible&&i[e].index<i[t[o].data.subgroup].index&&(s+=i[e].height,i[t[o].data.subgroup].top=s);t[o].top=s+.5*e.item.vertical}s||_t(t,e,i)}function _t(t,e,i){Dt(Object.values(i).sort(((t,e)=>t.index>e.index?1:t.index<e.index?-1:0)),{vertical:0},!0,(t=>!0),(t=>!0),(t=>0));for(let s=0;s<t.length;s++)void 0!==t[s].data.subgroup&&(t[s].top=i[t[s].data.subgroup].top+.5*e.item.vertical)}function xt(t,e,i){let s=!1;const o=[];for(var n in i)i[n].hasOwnProperty("index")?o[i[n].index]=n:o.push(n);for(let r=0;r<o.length;r++)if(n=o[r],i.hasOwnProperty(n)){s=s||i[n].stack,i[n].top=0;for(const t in i)i[t].visible&&i[n].index>i[t].index&&(i[n].top+=i[t].height);const o=t[n];for(let t=0;t<o.length;t++)void 0!==o[t].data.subgroup&&(o[t].top=i[o[t].data.subgroup].top+.5*e.item.vertical,i[n].stack&&(o[t].baseTop=o[t].top));s&&i[n].stack&&vt(t[n],e,i[n])}}function Dt(t,e,i,s,o,n,r){let a=t=>t.start,h=t=>t.end;if(!i){const i=!(!t[0]||!t[0].options.rtl);a=i?t=>t.right:t=>t.left,h=t=>a(t)+t.width+e.horizontal}const l=[],d=[];let p=null,m=0;for(const e of t)if(s(e))l.push(e);else if(o(e)){const t=a(e);null!==p&&t<p-gt&&(m=0),p=t,m=Ct(d,(e=>a(e)-gt>t),m),d.splice(m,0,e),m++}p=null;let c=null;m=0;let u=0,g=0,f=0;for(;l.length>0;){const t=l.shift();t.top=n(t);const i=a(t),s=h(t);null!==p&&i<p-gt&&(u=0,g=0,m=0,c=null),p=i,u=Ct(d,(t=>i<h(t)-gt),u),(null===c||c<s-gt)&&(g=Ct(d,(t=>s<a(t)-gt),Math.max(u,g))),null!==c&&c-gt>s&&(g=St(d,(t=>s+gt>=a(t)),u,g)+1);const w=d.slice(u,g).filter((t=>i<h(t)-gt&&s-gt>a(t))).sort(((t,e)=>t.top-e.top));for(let i=0;i<w.length;i++){const s=w[i];y=s,v=e,(b=t).top-v.vertical+gt<y.top+y.height&&b.top+b.height+v.vertical-gt>y.top&&(t.top=s.top+s.height+e.vertical)}o(t)&&(m=Ct(d,(t=>a(t)-gt>i),m),d.splice(m,0,t),m++);const _=t.top+t.height;if(_>f&&(f=_),r&&r())return null}var b,y,v;return f}function Ct(t,e,i){i||(i=0);const s=t.slice(i).findIndex(e);return-1===s?t.length:s+i}function St(t,e,s,o){for(s||(s=0),o||(o=t.length),i=o-1;i>=s;i--)if(e(t[i]))return i;return s-1}var kt=Object.freeze({__proto__:null,nostack:wt,orderByEnd:bt,orderByStart:ft,stack:yt,stackSubgroups:_t,stackSubgroupsWithInnerStack:xt,substack:vt});const Tt="__background__";class Et{constructor(t,e,i){if(this.groupId=t,this.subgroups={},this.subgroupStack={},this.subgroupStackAll=!1,this.subgroupVisibility={},this.doInnerStack=!1,this.shouldBailStackItems=!1,this.subgroupIndex=0,this.subgroupOrderer=e&&e.subgroupOrder,this.itemSet=i,this.isVisible=null,this.stackDirty=!0,this._disposeCallbacks=[],e&&e.nestedGroups&&(this.nestedGroups=e.nestedGroups,0==e.showNested?this.showNested=!1:this.showNested=!0),e&&e.subgroupStack)if("boolean"==typeof e.subgroupStack)this.doInnerStack=e.subgroupStack,this.subgroupStackAll=e.subgroupStack;else for(const t in e.subgroupStack)this.subgroupStack[t]=e.subgroupStack[t],this.doInnerStack=this.doInnerStack||e.subgroupStack[t];e&&e.heightMode?this.heightMode=e.heightMode:this.heightMode=i.options.groupHeightMode,this.nestedInGroup=null,this.dom={},this.props={label:{width:0,height:0}},this.className=null,this.items={},this.visibleItems=[],this.itemsInRange=[],this.orderedItems={byStart:[],byEnd:[]},this.checkRangedItems=!1;const s=()=>{this.checkRangedItems=!0};this.itemSet.body.emitter.on("checkRangedItems",s),this._disposeCallbacks.push((()=>{this.itemSet.body.emitter.off("checkRangedItems",s)})),this._create(),this.setData(e)}_create(){const t=document.createElement("div");this.itemSet.options.groupEditable.order?t.className="vis-label draggable":t.className="vis-label",this.dom.label=t;const e=document.createElement("div");e.className="vis-inner",t.appendChild(e),this.dom.inner=e;const i=document.createElement("div");i.className="vis-group",i["vis-group"]=this,this.dom.foreground=i,this.dom.background=document.createElement("div"),this.dom.background.className="vis-group",this.dom.axis=document.createElement("div"),this.dom.axis.className="vis-group",this.dom.marker=document.createElement("div"),this.dom.marker.style.visibility="hidden",this.dom.marker.style.position="absolute",this.dom.marker.innerHTML="",this.dom.background.appendChild(this.dom.marker)}setData(t){if(this.itemSet.groupTouchParams.isDragging)return;let e,i;if(t&&t.subgroupVisibility)for(const e in t.subgroupVisibility)this.subgroupVisibility[e]=t.subgroupVisibility[e];if(this.itemSet.options&&this.itemSet.options.groupTemplate?(i=this.itemSet.options.groupTemplate.bind(this),e=i(t,this.dom.inner)):e=t&&t.content,e instanceof Element){for(;this.dom.inner.firstChild;)this.dom.inner.removeChild(this.dom.inner.firstChild);this.dom.inner.appendChild(e)}else e instanceof Object&&e.isReactComponent||(e instanceof Object?i(t,this.dom.inner):this.dom.inner.innerHTML=null!=e?k.xss(e):k.xss(this.groupId||""));this.dom.label.title=t&&t.title||"",this.dom.inner.firstChild?k.removeClassName(this.dom.inner,"vis-hidden"):k.addClassName(this.dom.inner,"vis-hidden"),t&&t.nestedGroups?(this.nestedGroups&&this.nestedGroups==t.nestedGroups||(this.nestedGroups=t.nestedGroups),void 0===t.showNested&&void 0!==this.showNested||(0==t.showNested?this.showNested=!1:this.showNested=!0),k.addClassName(this.dom.label,"vis-nesting-group"),this.showNested?(k.removeClassName(this.dom.label,"collapsed"),k.addClassName(this.dom.label,"expanded")):(k.removeClassName(this.dom.label,"expanded"),k.addClassName(this.dom.label,"collapsed"))):this.nestedGroups&&(this.nestedGroups=null,k.removeClassName(this.dom.label,"collapsed"),k.removeClassName(this.dom.label,"expanded"),k.removeClassName(this.dom.label,"vis-nesting-group")),t&&(t.treeLevel||t.nestedInGroup)?(k.addClassName(this.dom.label,"vis-nested-group"),t.treeLevel?k.addClassName(this.dom.label,"vis-group-level-"+t.treeLevel):k.addClassName(this.dom.label,"vis-group-level-unknown-but-gte1")):k.addClassName(this.dom.label,"vis-group-level-0");const s=t&&t.className||null;s!=this.className&&(this.className&&(k.removeClassName(this.dom.label,this.className),k.removeClassName(this.dom.foreground,this.className),k.removeClassName(this.dom.background,this.className),k.removeClassName(this.dom.axis,this.className)),k.addClassName(this.dom.label,s),k.addClassName(this.dom.foreground,s),k.addClassName(this.dom.background,s),k.addClassName(this.dom.axis,s),this.className=s),this.style&&(k.removeCssText(this.dom.label,this.style),this.style=null),t&&t.style&&(k.addCssText(this.dom.label,t.style),this.style=t.style)}getLabelWidth(){return this.props.label.width}_didMarkerHeightChange(){const t=this.dom.marker.clientHeight;if(t!=this.lastMarkerHeight){this.lastMarkerHeight=t;const e={};let i=0;k.forEach(this.items,((t,s)=>{if(t.dirty=!0,t.displayed){const o=!0;e[s]=t.redraw(o),i=e[s].length}}));if(i>0)for(let t=0;t<i;t++)k.forEach(e,(e=>{e[t]()}));return!0}return!1}_calculateGroupSizeAndPosition(){const{offsetTop:t,offsetLeft:e,offsetWidth:i}=this.dom.foreground;this.top=t,this.right=e,this.width=i}_shouldBailItemsRedraw(){const t=this,e=this.itemSet.options.onTimeout,i={relativeBailingTime:this.itemSet.itemsSettingTime,bailTimeMs:e&&e.timeoutMs,userBailFunction:e&&e.callback,shouldBailStackItems:this.shouldBailStackItems};let s=null;if(!this.itemSet.initialDrawDone){if(i.shouldBailStackItems)return!0;Math.abs(Date.now()-new Date(i.relativeBailingTime))>i.bailTimeMs&&(i.userBailFunction&&null==this.itemSet.userContinueNotBail?i.userBailFunction((e=>{t.itemSet.userContinueNotBail=e,s=!e})):s=0==t.itemSet.userContinueNotBail)}return s}_redrawItems(t,e,i,s){if(t||this.stackDirty||this.isVisible&&!e){const t={byEnd:this.orderedItems.byEnd.filter((t=>!t.isCluster)),byStart:this.orderedItems.byStart.filter((t=>!t.isCluster))},e={byEnd:[...new Set(this.orderedItems.byEnd.map((t=>t.cluster)).filter((t=>!!t)))],byStart:[...new Set(this.orderedItems.byStart.map((t=>t.cluster)).filter((t=>!!t)))]},o=()=>[...this._updateItemsInRange(t,this.visibleItems.filter((t=>!t.isCluster)),s),...this._updateClustersInRange(e,this.visibleItems.filter((t=>t.isCluster)),s)],n=t=>{let e={};for(const i in this.subgroups){const s=this.visibleItems.filter((t=>t.data.subgroup===i));e[i]=t?s.sort(((e,i)=>t(e.data,i.data))):s}return e};if("function"==typeof this.itemSet.options.order){const t=this;if(this.doInnerStack&&this.itemSet.options.stackSubgroups){xt(n(this.itemSet.options.order),i,this.subgroups),this.visibleItems=o(),this._updateSubGroupHeights(i)}else{this.visibleItems=o(),this._updateSubGroupHeights(i);const e=this.visibleItems.slice().filter((t=>t.isCluster||!t.isCluster&&!t.cluster)).sort(((e,i)=>t.itemSet.options.order(e.data,i.data)));this.shouldBailStackItems=yt(e,i,!0,this._shouldBailItemsRedraw.bind(this))}}else if(this.visibleItems=o(),this._updateSubGroupHeights(i),this.itemSet.options.stack)if(this.doInnerStack&&this.itemSet.options.stackSubgroups){xt(n(),i,this.subgroups)}else this.shouldBailStackItems=yt(this.visibleItems,i,!0,this._shouldBailItemsRedraw.bind(this));else wt(this.visibleItems,i,this.subgroups,this.itemSet.options.stackSubgroups);for(let t=0;t<this.visibleItems.length;t++)this.visibleItems[t].repositionX(),void 0!==this.subgroupVisibility[this.visibleItems[t].data.subgroup]&&(this.subgroupVisibility[this.visibleItems[t].data.subgroup]||this.visibleItems[t].hide());this.itemSet.options.cluster&&k.forEach(this.items,(t=>{t.cluster&&t.displayed&&t.hide()})),this.shouldBailStackItems&&this.itemSet.body.emitter.emit("destroyTimeline"),this.stackDirty=!1}}_didResize(t,e){t=k.updateProperty(this,"height",e)||t;const i=this.dom.inner.clientWidth,s=this.dom.inner.clientHeight;return t=k.updateProperty(this.props.label,"width",i)||t,t=k.updateProperty(this.props.label,"height",s)||t}_applyGroupHeight(t){this.dom.background.style.height=`${t}px`,this.dom.foreground.style.height=`${t}px`,this.dom.label.style.height=`${t}px`}_updateItemsVerticalPosition(t){for(let e=0,i=this.visibleItems.length;e<i;e++){const i=this.visibleItems[e];i.repositionY(t),this.isVisible||this.groupId==Tt||i.displayed&&i.hide()}}redraw(t,e,i,s){let o=!1;const n=this.isVisible;let r;const a=[()=>{i=this._didMarkerHeightChange.call(this)||i},this._updateSubGroupHeights.bind(this,e),this._calculateGroupSizeAndPosition.bind(this),()=>{this.isVisible=this._isGroupVisible.bind(this)(t,e)},()=>{this._redrawItems.bind(this)(i,n,e,t)},this._updateSubgroupsSizes.bind(this),()=>{r=this._calculateHeight.bind(this)(e)},this._calculateGroupSizeAndPosition.bind(this),()=>{o=this._didResize.bind(this)(o,r)},()=>{this._applyGroupHeight.bind(this)(r)},()=>{this._updateItemsVerticalPosition.bind(this)(e)},(()=>(!this.isVisible&&this.height&&(o=!1),o)).bind(this)];if(s)return a;{let t;return a.forEach((e=>{t=e()})),t}}_updateSubGroupHeights(t){if(Object.keys(this.subgroups).length>0){const e=this;this._resetSubgroups(),k.forEach(this.visibleItems,(i=>{void 0!==i.data.subgroup&&(e.subgroups[i.data.subgroup].height=Math.max(e.subgroups[i.data.subgroup].height,i.height+t.item.vertical),e.subgroups[i.data.subgroup].visible=void 0===this.subgroupVisibility[i.data.subgroup]||Boolean(this.subgroupVisibility[i.data.subgroup]))}))}}_isGroupVisible(t,e){return this.top<=t.body.domProps.centerContainer.height-t.body.domProps.scrollTop+e.axis&&this.top+this.height+e.axis>=-t.body.domProps.scrollTop}_calculateHeight(t){let e,i;if(i="fixed"===this.heightMode?k.toArray(this.items):this.visibleItems,i.length>0){let s=i[0].top,o=i[0].top+i[0].height;if(k.forEach(i,(t=>{s=Math.min(s,t.top),o=Math.max(o,t.top+t.height)})),s>t.axis){const e=s-t.axis;o-=e,k.forEach(i,(t=>{t.top-=e}))}e=Math.ceil(o+t.item.vertical/2),"fitItems"!==this.heightMode&&(e=Math.max(e,this.props.label.height))}else e=this.props.label.height;return e}show(){this.dom.label.parentNode||this.itemSet.dom.labelSet.appendChild(this.dom.label),this.dom.foreground.parentNode||this.itemSet.dom.foreground.appendChild(this.dom.foreground),this.dom.background.parentNode||this.itemSet.dom.background.appendChild(this.dom.background),this.dom.axis.parentNode||this.itemSet.dom.axis.appendChild(this.dom.axis)}hide(){const t=this.dom.label;t.parentNode&&t.parentNode.removeChild(t);const e=this.dom.foreground;e.parentNode&&e.parentNode.removeChild(e);const i=this.dom.background;i.parentNode&&i.parentNode.removeChild(i);const s=this.dom.axis;s.parentNode&&s.parentNode.removeChild(s)}add(t){if(this.items[t.id]=t,t.setParent(this),this.stackDirty=!0,void 0!==t.data.subgroup&&(this._addToSubgroup(t),this.orderSubgroups()),!this.visibleItems.includes(t)){const e=this.itemSet.body.range;this._checkIfVisible(t,this.visibleItems,e)}}_addToSubgroup(t,e=t.data.subgroup){null!=e&&void 0===this.subgroups[e]&&(this.subgroups[e]={height:0,top:0,start:t.data.start,end:t.data.end||t.data.start,visible:!1,index:this.subgroupIndex,items:[],stack:this.subgroupStackAll||this.subgroupStack[e]||!1},this.subgroupIndex++),new Date(t.data.start)<new Date(this.subgroups[e].start)&&(this.subgroups[e].start=t.data.start);const i=t.data.end||t.data.start;new Date(i)>new Date(this.subgroups[e].end)&&(this.subgroups[e].end=i),this.subgroups[e].items.push(t)}_updateSubgroupsSizes(){const t=this;if(t.subgroups)for(const e in t.subgroups){const i=t.subgroups[e].items[0].data.end||t.subgroups[e].items[0].data.start;let s=t.subgroups[e].items[0].data.start,o=i-1;t.subgroups[e].items.forEach((t=>{new Date(t.data.start)<new Date(s)&&(s=t.data.start);const e=t.data.end||t.data.start;new Date(e)>new Date(o)&&(o=e)})),t.subgroups[e].start=s,t.subgroups[e].end=new Date(o-1)}}orderSubgroups(){if(void 0!==this.subgroupOrderer){const t=[];if("string"==typeof this.subgroupOrderer){for(const e in this.subgroups)t.push({subgroup:e,sortField:this.subgroups[e].items[0].data[this.subgroupOrderer]});t.sort(((t,e)=>t.sortField-e.sortField))}else if("function"==typeof this.subgroupOrderer){for(const e in this.subgroups)t.push(this.subgroups[e].items[0].data);t.sort(this.subgroupOrderer)}if(t.length>0)for(let e=0;e<t.length;e++)this.subgroups[t[e].subgroup].index=e}}_resetSubgroups(){for(const t in this.subgroups)this.subgroups.hasOwnProperty(t)&&(this.subgroups[t].visible=!1,this.subgroups[t].height=0)}remove(t){delete this.items[t.id],t.setParent(null),this.stackDirty=!0;const e=this.visibleItems.indexOf(t);-1!=e&&this.visibleItems.splice(e,1),void 0!==t.data.subgroup&&(this._removeFromSubgroup(t),this.orderSubgroups())}_removeFromSubgroup(t,e=t.data.subgroup){if(null!=e){const i=this.subgroups[e];if(i){const s=i.items.indexOf(t);s>=0&&(i.items.splice(s,1),i.items.length?this._updateSubgroupsSizes():delete this.subgroups[e])}}}removeFromDataSet(t){this.itemSet.removeItem(t.id)}order(){const t=k.toArray(this.items),e=[],i=[];for(let s=0;s<t.length;s++)void 0!==t[s].data.end&&i.push(t[s]),e.push(t[s]);this.orderedItems={byStart:e,byEnd:i},ft(this.orderedItems.byStart),bt(this.orderedItems.byEnd)}_updateItemsInRange(t,e,i){const s=[],o={};if(!this.isVisible&&void 0!==this.height&&this.groupId!=Tt){for(let t=0;t<e.length;t++){var n=e[t];n.displayed&&n.hide()}return s}const r=(i.end-i.start)/4,a=i.start-r,h=i.end+r,l=t=>{const{start:e,end:i}=t;return i<a?-1:e<=h?0:1};if(e.length>0)for(let t=0;t<e.length;t++)this._checkIfVisibleWithReference(e[t],s,o,i);const d=k.binarySearchCustom(t.byStart,(t=>t<a?-1:t<=h?0:1),"data","start");if(this._traceVisible(d,t.byStart,s,o,(t=>t.data.start<a||t.data.start>h)),1==this.checkRangedItems){this.checkRangedItems=!1;for(let e=0;e<t.byEnd.length;e++)this._checkIfVisibleWithReference(t.byEnd[e],s,o,i)}else{const e=k.binarySearchCustom(t.byEnd,l,"data");this._traceVisible(e,t.byEnd,s,o,(t=>t.data.end<a||t.data.start>h))}const p={};let m=0;for(let t=0;t<s.length;t++){const e=s[t];if(!e.displayed){const i=!0;p[t]=e.redraw(i),m=p[t].length}}if(m>0)for(let t=0;t<m;t++)k.forEach(p,(e=>{e[t]()}));for(let t=0;t<s.length;t++)s[t].repositionX();return s}_traceVisible(t,e,i,s,o){if(-1!=t){for(let n=t;n>=0;n--){let t=e[n];if(o(t))break;t.isCluster&&!t.hasItems()||t.cluster||void 0===s[t.id]&&(s[t.id]=!0,i.push(t))}for(let n=t+1;n<e.length;n++){let t=e[n];if(o(t))break;t.isCluster&&!t.hasItems()||t.cluster||void 0===s[t.id]&&(s[t.id]=!0,i.push(t))}}}_checkIfVisible(t,e,i){t.isVisible(i)?(t.displayed||t.show(),t.repositionX(),e.push(t)):t.displayed&&t.hide()}_checkIfVisibleWithReference(t,e,i,s){t.isVisible(s)?void 0===i[t.id]&&(i[t.id]=!0,e.push(t)):t.displayed&&t.hide()}_updateClustersInRange(t,e,i){const s=[],o={};if(e.length>0)for(let t=0;t<e.length;t++)this._checkIfVisibleWithReference(e[t],s,o,i);for(let e=0;e<t.byStart.length;e++)this._checkIfVisibleWithReference(t.byStart[e],s,o,i);for(let e=0;e<t.byEnd.length;e++)this._checkIfVisibleWithReference(t.byEnd[e],s,o,i);const n={};let r=0;for(let t=0;t<s.length;t++){const e=s[t];if(!e.displayed){const i=!0;n[t]=e.redraw(i),r=n[t].length}}if(r>0)for(var a=0;a<r;a++)k.forEach(n,(function(t){t[a]()}));for(let t=0;t<s.length;t++)s[t].repositionX();return s}changeSubgroup(t,e,i){this._removeFromSubgroup(t,e),this._addToSubgroup(t,i),this.orderSubgroups()}dispose(){let t;for(this.hide();t=this._disposeCallbacks.pop();)t()}}class Ot extends Et{constructor(t,e,i){super(t,e,i),this.width=0,this.height=0,this.top=0,this.left=0}redraw(t,e,i){this.visibleItems=this._updateItemsInRange(this.orderedItems,this.visibleItems,t),this.width=this.dom.background.offsetWidth,this.dom.background.style.height="0";for(let t=0,i=this.visibleItems.length;t<i;t++){this.visibleItems[t].repositionY(e)}return!1}show(){this.dom.background.parentNode||this.itemSet.dom.background.appendChild(this.dom.background)}}class Mt{constructor(t,e,i){this.id=null,this.parent=null,this.data=t,this.dom=null,this.conversion=e||{},this.defaultOptions={locales:pt,locale:"en"},this.options=k.extend({},this.defaultOptions,i),this.options.locales=k.extend({},pt,this.options.locales);const s=this.defaultOptions.locales[this.defaultOptions.locale];Object.keys(this.options.locales).forEach((t=>{this.options.locales[t]=k.extend({},s,this.options.locales[t])})),this.selected=!1,this.displayed=!1,this.groupShowing=!0,this.selectable=i&&i.selectable||!1,this.dirty=!0,this.top=null,this.right=null,this.left=null,this.width=null,this.height=null,this.setSelectability(t),this.editable=null,this._updateEditStatus()}select(){this.selectable&&(this.selected=!0,this.dirty=!0,this.displayed&&this.redraw())}unselect(){this.selected=!1,this.dirty=!0,this.displayed&&this.redraw()}setData(t){null!=t.group&&this.data.group!=t.group&&null!=this.parent&&this.parent.itemSet._moveToGroup(this,t.group),this.setSelectability(t),this.parent&&(this.parent.stackDirty=!0);null!=t.subgroup&&this.data.subgroup!=t.subgroup&&null!=this.parent&&this.parent.changeSubgroup(this,this.data.subgroup,t.subgroup),this.data=t,this._updateEditStatus(),this.dirty=!0,this.displayed&&this.redraw()}setSelectability(t){t&&(this.selectable=void 0===t.selectable||Boolean(t.selectable))}setParent(t){this.displayed?(this.hide(),this.parent=t,this.parent&&this.show()):this.parent=t}isVisible(t){return!1}show(){return!1}hide(){return!1}redraw(){}repositionX(){}repositionY(){}_repaintDragCenter(){if(this.selected&&this.editable.updateTime&&!this.dom.dragCenter){const t=this,e=document.createElement("div");e.className="vis-drag-center",e.dragCenterItem=this,this.hammerDragCenter=new W(e),this.hammerDragCenter.on("tap",(e=>{t.parent.itemSet.body.emitter.emit("click",{event:e,item:t.id})})),this.hammerDragCenter.on("doubletap",(e=>{e.stopPropagation(),t.parent.itemSet._onUpdateItem(t),t.parent.itemSet.body.emitter.emit("doubleClick",{event:e,item:t.id})})),this.hammerDragCenter.on("panstart",(e=>{e.stopPropagation(),t.parent.itemSet._onDragStart(e)})),this.hammerDragCenter.on("panmove",t.parent.itemSet._onDrag.bind(t.parent.itemSet)),this.hammerDragCenter.on("panend",t.parent.itemSet._onDragEnd.bind(t.parent.itemSet)),this.hammerDragCenter.get("press").set({time:1e4}),this.dom.box?this.dom.dragLeft?this.dom.box.insertBefore(e,this.dom.dragLeft):this.dom.box.appendChild(e):this.dom.point&&this.dom.point.appendChild(e),this.dom.dragCenter=e}else!this.selected&&this.dom.dragCenter&&(this.dom.dragCenter.parentNode&&this.dom.dragCenter.parentNode.removeChild(this.dom.dragCenter),this.dom.dragCenter=null,this.hammerDragCenter&&(this.hammerDragCenter.destroy(),this.hammerDragCenter=null))}_repaintDeleteButton(t){const e=(this.options.editable.overrideItems||null==this.editable)&&this.options.editable.remove||!this.options.editable.overrideItems&&null!=this.editable&&this.editable.remove;if(this.selected&&e&&!this.dom.deleteButton){const e=this,i=document.createElement("div");this.options.rtl?i.className="vis-delete-rtl":i.className="vis-delete";let s=this.options.locales[this.options.locale];s||(this.warned||(console.warn(`WARNING: options.locales['${this.options.locale}'] not found. See https://visjs.github.io/vis-timeline/docs/timeline/#Localization`),this.warned=!0),s=this.options.locales.en),i.title=s.deleteSelected,this.hammerDeleteButton=new W(i).on("tap",(t=>{t.stopPropagation(),e.parent.removeFromDataSet(e)})),t.appendChild(i),this.dom.deleteButton=i}else this.selected&&e||!this.dom.deleteButton||(this.dom.deleteButton.parentNode&&this.dom.deleteButton.parentNode.removeChild(this.dom.deleteButton),this.dom.deleteButton=null,this.hammerDeleteButton&&(this.hammerDeleteButton.destroy(),this.hammerDeleteButton=null))}_repaintOnItemUpdateTimeTooltip(t){if(!this.options.tooltipOnItemUpdateTime)return;const e=(this.options.editable.updateTime||!0===this.data.editable)&&!1!==this.data.editable;if(this.selected&&e&&!this.dom.onItemUpdateTimeTooltip){const e=document.createElement("div");e.className="vis-onUpdateTime-tooltip",t.appendChild(e),this.dom.onItemUpdateTimeTooltip=e}else!this.selected&&this.dom.onItemUpdateTimeTooltip&&(this.dom.onItemUpdateTimeTooltip.parentNode&&this.dom.onItemUpdateTimeTooltip.parentNode.removeChild(this.dom.onItemUpdateTimeTooltip),this.dom.onItemUpdateTimeTooltip=null);if(this.dom.onItemUpdateTimeTooltip){this.dom.onItemUpdateTimeTooltip.style.visibility=this.parent.itemSet.touchParams.itemIsDragging?"visible":"hidden",this.dom.onItemUpdateTimeTooltip.style.transform="translateX(-50%)",this.dom.onItemUpdateTimeTooltip.style.left="50%";const t=50,e=this.parent.itemSet.body.domProps.scrollTop;let i;i="top"==this.options.orientation.item?this.top:this.parent.height-this.top-this.height;let s,o;i+this.parent.top-t<-e?(this.dom.onItemUpdateTimeTooltip.style.bottom="",this.dom.onItemUpdateTimeTooltip.style.top=`${this.height+2}px`):(this.dom.onItemUpdateTimeTooltip.style.top="",this.dom.onItemUpdateTimeTooltip.style.bottom=`${this.height+2}px`),this.options.tooltipOnItemUpdateTime&&this.options.tooltipOnItemUpdateTime.template?(o=this.options.tooltipOnItemUpdateTime.template.bind(this),s=o(this.data)):(s=`start: ${b(this.data.start).format("MM/DD/YYYY hh:mm")}`,this.data.end&&(s+=`<br> end: ${b(this.data.end).format("MM/DD/YYYY hh:mm")}`)),this.dom.onItemUpdateTimeTooltip.innerHTML=k.xss(s)}}_getItemData(){return this.parent.itemSet.itemsData.get(this.id)}_updateContents(t){let e,i,s,o,n;const r=this._getItemData(),a=(this.dom.box||this.dom.point).getElementsByClassName("vis-item-visible-frame")[0];if(this.options.visibleFrameTemplate?(n=this.options.visibleFrameTemplate.bind(this),o=k.xss(n(r,a))):o="",a)if(o instanceof Object&&!(o instanceof Element))n(r,a);else if(i=this._contentToString(this.itemVisibleFrameContent)!==this._contentToString(o),i){if(o instanceof Element)a.innerHTML="",a.appendChild(o);else if(null!=o)a.innerHTML=k.xss(o);else if("background"!=this.data.type||void 0!==this.data.content)throw new Error(`Property "content" missing in item ${this.id}`);this.itemVisibleFrameContent=o}if(this.options.template?(s=this.options.template.bind(this),e=s(r,t,this.data)):e=this.data.content,e instanceof Object&&!(e instanceof Element))s(r,t);else if(i=this._contentToString(this.content)!==this._contentToString(e),i){if(e instanceof Element)t.innerHTML="",t.appendChild(e);else if(null!=e)t.innerHTML=k.xss(e);else if("background"!=this.data.type||void 0!==this.data.content)throw new Error(`Property "content" missing in item ${this.id}`);this.content=e}}_updateDataAttributes(t){if(this.options.dataAttributes&&this.options.dataAttributes.length>0){let e=[];if(Array.isArray(this.options.dataAttributes))e=this.options.dataAttributes;else{if("all"!=this.options.dataAttributes)return;e=Object.keys(this.data)}for(const i of e){const e=this.data[i];null!=e?t.setAttribute(`data-${i}`,e):t.removeAttribute(`data-${i}`)}}}_updateStyle(t){this.style&&(k.removeCssText(t,this.style),this.style=null),this.data.style&&(k.addCssText(t,this.data.style),this.style=this.data.style)}_contentToString(t){return"string"==typeof t?t:t&&"outerHTML"in t?t.outerHTML:t}_updateEditStatus(){this.options&&("boolean"==typeof this.options.editable?this.editable={updateTime:this.options.editable,updateGroup:this.options.editable,remove:this.options.editable}:"object"==typeof this.options.editable&&(this.editable={},k.selectiveExtend(["updateTime","updateGroup","remove"],this.editable,this.options.editable))),this.options&&this.options.editable&&!0===this.options.editable.overrideItems||this.data&&("boolean"==typeof this.data.editable?this.editable={updateTime:this.data.editable,updateGroup:this.data.editable,remove:this.data.editable}:"object"==typeof this.data.editable&&(this.editable={},k.selectiveExtend(["updateTime","updateGroup","remove"],this.editable,this.data.editable)))}getWidthLeft(){return 0}getWidthRight(){return 0}getTitle(){if(this.options.tooltip&&this.options.tooltip.template){return this.options.tooltip.template.bind(this)(this._getItemData(),this.data)}return this.data.title}}Mt.prototype.stack=!0;class It extends Mt{constructor(t,e,i){if(super(t,e,i),this.props={dot:{width:0,height:0},line:{width:0,height:0}},t&&null==t.start)throw new Error(`Property "start" missing in item ${t}`)}isVisible(t){if(this.cluster)return!1;let e;const i=this.data.align||this.options.align,s=this.width*t.getMillisecondsPerPixel();return e="right"==i?this.data.start.getTime()>t.start&&this.data.start.getTime()-s<t.end:"left"==i?this.data.start.getTime()+s>t.start&&this.data.start.getTime()<t.end:this.data.start.getTime()+s/2>t.start&&this.data.start.getTime()-s/2<t.end,e}_createDomElement(){this.dom||(this.dom={},this.dom.box=document.createElement("DIV"),this.dom.content=document.createElement("DIV"),this.dom.content.className="vis-item-content",this.dom.box.appendChild(this.dom.content),this.dom.line=document.createElement("DIV"),this.dom.line.className="vis-line",this.dom.dot=document.createElement("DIV"),this.dom.dot.className="vis-dot",this.dom.box["vis-item"]=this,this.dirty=!0)}_appendDomElement(){if(!this.parent)throw new Error("Cannot redraw item: no parent attached");if(!this.dom.box.parentNode){const t=this.parent.dom.foreground;if(!t)throw new Error("Cannot redraw item: parent has no foreground container element");t.appendChild(this.dom.box)}if(!this.dom.line.parentNode){var t=this.parent.dom.background;if(!t)throw new Error("Cannot redraw item: parent has no background container element");t.appendChild(this.dom.line)}if(!this.dom.dot.parentNode){const e=this.parent.dom.axis;if(!t)throw new Error("Cannot redraw item: parent has no axis container element");e.appendChild(this.dom.dot)}this.displayed=!0}_updateDirtyDomComponents(){if(this.dirty){this._updateContents(this.dom.content),this._updateDataAttributes(this.dom.box),this._updateStyle(this.dom.box);const t=this.editable.updateTime||this.editable.updateGroup,e=(this.data.className?" "+this.data.className:"")+(this.selected?" vis-selected":"")+(t?" vis-editable":" vis-readonly");this.dom.box.className=`vis-item vis-box${e}`,this.dom.line.className=`vis-item vis-line${e}`,this.dom.dot.className=`vis-item vis-dot${e}`}}_getDomComponentsSizes(){return{previous:{right:this.dom.box.style.right,left:this.dom.box.style.left},dot:{height:this.dom.dot.offsetHeight,width:this.dom.dot.offsetWidth},line:{width:this.dom.line.offsetWidth},box:{width:this.dom.box.offsetWidth,height:this.dom.box.offsetHeight}}}_updateDomComponentsSizes(t){this.options.rtl?this.dom.box.style.right="0px":this.dom.box.style.left="0px",this.props.dot.height=t.dot.height,this.props.dot.width=t.dot.width,this.props.line.width=t.line.width,this.width=t.box.width,this.height=t.box.height,this.options.rtl?this.dom.box.style.right=t.previous.right:this.dom.box.style.left=t.previous.left,this.dirty=!1}_repaintDomAdditionals(){this._repaintOnItemUpdateTimeTooltip(this.dom.box),this._repaintDragCenter(),this._repaintDeleteButton(this.dom.box)}redraw(t){let e;const i=[this._createDomElement.bind(this),this._appendDomElement.bind(this),this._updateDirtyDomComponents.bind(this),()=>{this.dirty&&(e=this._getDomComponentsSizes())},()=>{this.dirty&&this._updateDomComponentsSizes.bind(this)(e)},this._repaintDomAdditionals.bind(this)];if(t)return i;{let t;return i.forEach((e=>{t=e()})),t}}show(t){if(!this.displayed)return this.redraw(t)}hide(){if(this.displayed){const t=this.dom;t.box.remove?t.box.remove():t.box.parentNode&&t.box.parentNode.removeChild(t.box),t.line.remove?t.line.remove():t.line.parentNode&&t.line.parentNode.removeChild(t.line),t.dot.remove?t.dot.remove():t.dot.parentNode&&t.dot.parentNode.removeChild(t.dot),this.displayed=!1}}repositionXY(){const t=this.options.rtl,e=(t,e,i,s=!1)=>{if(void 0===e&&void 0===i)return;const o=s?-1*e:e;t.style.transform=void 0!==i?void 0!==e?`translate(${o}px, ${i}px)`:`translateY(${i}px)`:`translateX(${o}px)`};e(this.dom.box,this.boxX,this.boxY,t),e(this.dom.dot,this.dotX,this.dotY,t),e(this.dom.line,this.lineX,this.lineY,t)}repositionX(){const t=this.conversion.toScreen(this.data.start),e=void 0===this.data.align?this.options.align:this.data.align,i=this.props.line.width,s=this.props.dot.width;"right"==e?(this.boxX=t-this.width,this.lineX=t-i,this.dotX=t-i/2-s/2):"left"==e?(this.boxX=t,this.lineX=t,this.dotX=t+i/2-s/2):(this.boxX=t-this.width/2,this.lineX=this.options.rtl?t-i:t-i/2,this.dotX=t-s/2),this.options.rtl?this.right=this.boxX:this.left=this.boxX,this.repositionXY()}repositionY(){const t=this.options.orientation.item,e=this.dom.line.style;if("top"==t){const t=this.parent.top+this.top+1;this.boxY=this.top||0,e.height=`${t}px`,e.bottom="",e.top="0"}else{const t=this.parent.itemSet.props.height-this.parent.top-this.parent.height+this.top;this.boxY=this.parent.height-this.top-(this.height||0),e.height=`${t}px`,e.top="",e.bottom="0"}this.dotY=-this.props.dot.height/2,this.repositionXY()}getWidthLeft(){return this.width/2}getWidthRight(){return this.width/2}}class Nt extends Mt{constructor(t,e,i){if(super(t,e,i),this.props={dot:{top:0,width:0,height:0},content:{height:0,marginLeft:0,marginRight:0}},t&&null==t.start)throw new Error(`Property "start" missing in item ${t}`)}isVisible(t){if(this.cluster)return!1;const e=this.width*t.getMillisecondsPerPixel();return this.data.start.getTime()+e>t.start&&this.data.start<t.end}_createDomElement(){this.dom||(this.dom={},this.dom.point=document.createElement("div"),this.dom.content=document.createElement("div"),this.dom.content.className="vis-item-content",this.dom.point.appendChild(this.dom.content),this.dom.dot=document.createElement("div"),this.dom.point.appendChild(this.dom.dot),this.dom.point["vis-item"]=this,this.dirty=!0)}_appendDomElement(){if(!this.parent)throw new Error("Cannot redraw item: no parent attached");if(!this.dom.point.parentNode){const t=this.parent.dom.foreground;if(!t)throw new Error("Cannot redraw item: parent has no foreground container element");t.appendChild(this.dom.point)}this.displayed=!0}_updateDirtyDomComponents(){if(this.dirty){this._updateContents(this.dom.content),this._updateDataAttributes(this.dom.point),this._updateStyle(this.dom.point);const t=this.editable.updateTime||this.editable.updateGroup,e=(this.data.className?" "+this.data.className:"")+(this.selected?" vis-selected":"")+(t?" vis-editable":" vis-readonly");this.dom.point.className=`vis-item vis-point${e}`,this.dom.dot.className=`vis-item vis-dot${e}`}}_getDomComponentsSizes(){return{dot:{width:this.dom.dot.offsetWidth,height:this.dom.dot.offsetHeight},content:{width:this.dom.content.offsetWidth,height:this.dom.content.offsetHeight},point:{width:this.dom.point.offsetWidth,height:this.dom.point.offsetHeight}}}_updateDomComponentsSizes(t){this.props.dot.width=t.dot.width,this.props.dot.height=t.dot.height,this.props.content.height=t.content.height,this.options.rtl?this.dom.content.style.marginRight=this.props.dot.width/2+"px":this.dom.content.style.marginLeft=this.props.dot.width/2+"px",this.width=t.point.width,this.height=t.point.height,this.dom.dot.style.top=(this.height-this.props.dot.height)/2+"px";const e=this.props.dot.width,i=this.options.rtl?e/2:e/2*-1;this.dom.dot.style.transform=`translateX(${i}px`,this.dirty=!1}_repaintDomAdditionals(){this._repaintOnItemUpdateTimeTooltip(this.dom.point),this._repaintDragCenter(),this._repaintDeleteButton(this.dom.point)}redraw(t){let e;const i=[this._createDomElement.bind(this),this._appendDomElement.bind(this),this._updateDirtyDomComponents.bind(this),()=>{this.dirty&&(e=this._getDomComponentsSizes())},()=>{this.dirty&&this._updateDomComponentsSizes.bind(this)(e)},this._repaintDomAdditionals.bind(this)];if(t)return i;{let t;return i.forEach((e=>{t=e()})),t}}repositionXY(){const t=this.options.rtl;((t,e,i,s=!1)=>{if(void 0===e&&void 0===i)return;const o=s?-1*e:e;t.style.transform=void 0!==i?void 0!==e?`translate(${o}px, ${i}px)`:`translateY(${i}px)`:`translateX(${o}px)`})(this.dom.point,this.pointX,this.pointY,t)}show(t){if(!this.displayed)return this.redraw(t)}hide(){this.displayed&&(this.dom.point.parentNode&&this.dom.point.parentNode.removeChild(this.dom.point),this.displayed=!1)}repositionX(){const t=this.conversion.toScreen(this.data.start);this.pointX=t,this.options.rtl?this.right=t-this.props.dot.width:this.left=t-this.props.dot.width,this.repositionXY()}repositionY(){const t=this.options.orientation.item;this.pointY="top"==t?this.top:this.parent.height-this.top-this.height,this.repositionXY()}getWidthLeft(){return this.props.dot.width}getWidthRight(){return this.props.dot.width}}class Pt extends Mt{constructor(t,e,i){if(super(t,e,i),this.props={content:{width:0}},this.overflow=!1,t){if(null==t.start)throw new Error(`Property "start" missing in item ${t.id}`);if(null==t.end)throw new Error(`Property "end" missing in item ${t.id}`)}}isVisible(t){return!this.cluster&&(this.data.start<t.end&&this.data.end>t.start)}_createDomElement(){this.dom||(this.dom={},this.dom.box=document.createElement("div"),this.dom.frame=document.createElement("div"),this.dom.frame.className="vis-item-overflow",this.dom.box.appendChild(this.dom.frame),this.dom.visibleFrame=document.createElement("div"),this.dom.visibleFrame.className="vis-item-visible-frame",this.dom.box.appendChild(this.dom.visibleFrame),this.dom.content=document.createElement("div"),this.dom.content.className="vis-item-content",this.dom.frame.appendChild(this.dom.content),this.dom.box["vis-item"]=this,this.dirty=!0)}_appendDomElement(){if(!this.parent)throw new Error("Cannot redraw item: no parent attached");if(!this.dom.box.parentNode){const t=this.parent.dom.foreground;if(!t)throw new Error("Cannot redraw item: parent has no foreground container element");t.appendChild(this.dom.box)}this.displayed=!0}_updateDirtyDomComponents(){if(this.dirty){this._updateContents(this.dom.content),this._updateDataAttributes(this.dom.box),this._updateStyle(this.dom.box);const t=this.editable.updateTime||this.editable.updateGroup,e=(this.data.className?" "+this.data.className:"")+(this.selected?" vis-selected":"")+(t?" vis-editable":" vis-readonly");this.dom.box.className=this.baseClassName+e,this.dom.content.style.maxWidth="none"}}_getDomComponentsSizes(){return this.overflow="hidden"!==window.getComputedStyle(this.dom.frame).overflow,this.whiteSpace="nowrap"!==window.getComputedStyle(this.dom.content).whiteSpace,{content:{width:this.dom.content.offsetWidth},box:{height:this.dom.box.offsetHeight}}}_updateDomComponentsSizes(t){this.props.content.width=t.content.width,this.height=t.box.height,this.dom.content.style.maxWidth="",this.dirty=!1}_repaintDomAdditionals(){this._repaintOnItemUpdateTimeTooltip(this.dom.box),this._repaintDeleteButton(this.dom.box),this._repaintDragCenter(),this._repaintDragLeft(),this._repaintDragRight()}redraw(t){let e;const i=[this._createDomElement.bind(this),this._appendDomElement.bind(this),this._updateDirtyDomComponents.bind(this),()=>{this.dirty&&(e=this._getDomComponentsSizes.bind(this)())},()=>{this.dirty&&this._updateDomComponentsSizes.bind(this)(e)},this._repaintDomAdditionals.bind(this)];if(t)return i;{let t;return i.forEach((e=>{t=e()})),t}}show(t){if(!this.displayed)return this.redraw(t)}hide(){if(this.displayed){const t=this.dom.box;t.parentNode&&t.parentNode.removeChild(t),this.displayed=!1}}repositionX(t){const e=this.parent.width;let i=this.conversion.toScreen(this.data.start),s=this.conversion.toScreen(this.data.end);const o=void 0===this.data.align?this.options.align:this.data.align;let n,r;!1===this.data.limitSize||void 0!==t&&!0!==t||(i<-e&&(i=-e),s>2*e&&(s=2*e));const a=Math.max(Math.round(1e3*(s-i))/1e3,1);switch(this.overflow?(this.options.rtl?this.right=i:this.left=i,this.width=a+this.props.content.width,r=this.props.content.width):(this.options.rtl?this.right=i:this.left=i,this.width=a,r=Math.min(s-i,this.props.content.width)),this.options.rtl?this.dom.box.style.transform=`translateX(${-1*this.right}px)`:this.dom.box.style.transform=`translateX(${this.left}px)`,this.dom.box.style.width=`${a}px`,this.whiteSpace&&(this.height=this.dom.box.offsetHeight),o){case"left":this.dom.content.style.transform="translateX(0)";break;case"right":if(this.options.rtl){const t=-1*Math.max(a-r,0);this.dom.content.style.transform=`translateX(${t}px)`}else this.dom.content.style.transform=`translateX(${Math.max(a-r,0)}px)`;break;case"center":if(this.options.rtl){const t=-1*Math.max((a-r)/2,0);this.dom.content.style.transform=`translateX(${t}px)`}else this.dom.content.style.transform=`translateX(${Math.max((a-r)/2,0)}px)`;break;default:if(n=this.overflow?s>0?Math.max(-i,0):-r:i<0?-i:0,this.options.rtl){const t=-1*n;this.dom.content.style.transform=`translateX(${t}px)`}else this.dom.content.style.transform=`translateX(${n}px)`}}repositionY(){const t=this.options.orientation.item,e=this.dom.box;e.style.top="top"==t?`${this.top}px`:this.parent.height-this.top-this.height+"px"}_repaintDragLeft(){if((this.selected||this.options.itemsAlwaysDraggable.range)&&this.editable.updateTime&&!this.dom.dragLeft){const t=document.createElement("div");t.className="vis-drag-left",t.dragLeftItem=this,this.dom.box.appendChild(t),this.dom.dragLeft=t}else this.selected||this.options.itemsAlwaysDraggable.range||!this.dom.dragLeft||(this.dom.dragLeft.parentNode&&this.dom.dragLeft.parentNode.removeChild(this.dom.dragLeft),this.dom.dragLeft=null)}_repaintDragRight(){if((this.selected||this.options.itemsAlwaysDraggable.range)&&this.editable.updateTime&&!this.dom.dragRight){const t=document.createElement("div");t.className="vis-drag-right",t.dragRightItem=this,this.dom.box.appendChild(t),this.dom.dragRight=t}else this.selected||this.options.itemsAlwaysDraggable.range||!this.dom.dragRight||(this.dom.dragRight.parentNode&&this.dom.dragRight.parentNode.removeChild(this.dom.dragRight),this.dom.dragRight=null)}}Pt.prototype.baseClassName="vis-item vis-range";class At extends Mt{constructor(t,e,i){if(super(t,e,i),this.props={content:{width:0}},this.overflow=!1,t){if(null==t.start)throw new Error(`Property "start" missing in item ${t.id}`);if(null==t.end)throw new Error(`Property "end" missing in item ${t.id}`)}}isVisible(t){return this.data.start<t.end&&this.data.end>t.start}_createDomElement(){this.dom||(this.dom={},this.dom.box=document.createElement("div"),this.dom.frame=document.createElement("div"),this.dom.frame.className="vis-item-overflow",this.dom.box.appendChild(this.dom.frame),this.dom.content=document.createElement("div"),this.dom.content.className="vis-item-content",this.dom.frame.appendChild(this.dom.content),this.dirty=!0)}_appendDomElement(){if(!this.parent)throw new Error("Cannot redraw item: no parent attached");if(!this.dom.box.parentNode){const t=this.parent.dom.background;if(!t)throw new Error("Cannot redraw item: parent has no background container element");t.appendChild(this.dom.box)}this.displayed=!0}_updateDirtyDomComponents(){if(this.dirty){this._updateContents(this.dom.content),this._updateDataAttributes(this.dom.content),this._updateStyle(this.dom.box);const t=(this.data.className?" "+this.data.className:"")+(this.selected?" vis-selected":"");this.dom.box.className=this.baseClassName+t}}_getDomComponentsSizes(){return this.overflow="hidden"!==window.getComputedStyle(this.dom.content).overflow,{content:{width:this.dom.content.offsetWidth}}}_updateDomComponentsSizes(t){this.props.content.width=t.content.width,this.height=0,this.dirty=!1}_repaintDomAdditionals(){}redraw(t){let e;const i=[this._createDomElement.bind(this),this._appendDomElement.bind(this),this._updateDirtyDomComponents.bind(this),()=>{this.dirty&&(e=this._getDomComponentsSizes.bind(this)())},()=>{this.dirty&&this._updateDomComponentsSizes.bind(this)(e)},this._repaintDomAdditionals.bind(this)];if(t)return i;{let t;return i.forEach((e=>{t=e()})),t}}repositionY(t){let e;const i=this.options.orientation.item;if(void 0!==this.data.subgroup){const t=this.data.subgroup;this.dom.box.style.height=`${this.parent.subgroups[t].height}px`,this.dom.box.style.top="top"==i?`${this.parent.top+this.parent.subgroups[t].top}px`:this.parent.top+this.parent.height-this.parent.subgroups[t].top-this.parent.subgroups[t].height+"px",this.dom.box.style.bottom=""}else this.parent instanceof Ot?(e=Math.max(this.parent.height,this.parent.itemSet.body.domProps.center.height,this.parent.itemSet.body.domProps.centerContainer.height),this.dom.box.style.bottom="bottom"==i?"0":"",this.dom.box.style.top="top"==i?"0":""):(e=this.parent.height,this.dom.box.style.top=`${this.parent.top}px`,this.dom.box.style.bottom="");this.dom.box.style.height=`${e}px`}}At.prototype.baseClassName="vis-item vis-background",At.prototype.stack=!1,At.prototype.show=Pt.prototype.show,At.prototype.hide=Pt.prototype.hide,At.prototype.repositionX=Pt.prototype.repositionX;class Lt{constructor(t,e){this.container=t,this.overflowMethod=e||"cap",this.x=0,this.y=0,this.padding=5,this.hidden=!1,this.frame=document.createElement("div"),this.frame.className="vis-tooltip",this.container.appendChild(this.frame)}setPosition(t,e){this.x=parseInt(t),this.y=parseInt(e)}setText(t){t instanceof Element?(this.frame.innerHTML="",this.frame.appendChild(t)):this.frame.innerHTML=k.xss(t)}show(t){if(void 0===t&&(t=!0),!0===t){var e=this.frame.clientHeight,i=this.frame.clientWidth,s=this.frame.parentNode.clientHeight,o=this.frame.parentNode.clientWidth,n=0,r=0;if("flip"==this.overflowMethod||"none"==this.overflowMethod){let t=!1,s=!0;"flip"==this.overflowMethod&&(this.y-e<this.padding&&(s=!1),this.x+i>o-this.padding&&(t=!0)),n=t?this.x-i:this.x,r=s?this.y-e:this.y}else(r=this.y-e)+e+this.padding>s&&(r=s-e-this.padding),r<this.padding&&(r=this.padding),(n=this.x)+i+this.padding>o&&(n=o-i-this.padding),n<this.padding&&(n=this.padding);this.frame.style.left=n+"px",this.frame.style.top=r+"px",this.frame.style.visibility="visible",this.hidden=!1}else this.hide()}hide(){this.hidden=!0,this.frame.style.left="0",this.frame.style.top="0",this.frame.style.visibility="hidden"}destroy(){this.frame.parentNode.removeChild(this.frame)}}class Rt extends Mt{constructor(t,e,i){if(super(t,e,Object.assign({},{fitOnDoubleClick:!0},i,{editable:!1})),this.props={content:{width:0,height:0}},!t||null==t.uiItems)throw new Error('Property "uiItems" missing in item '+t.id);this.id=p(),this.group=t.group,this._setupRange(),this.emitter=this.data.eventEmitter,this.range=this.data.range,this.attached=!1,this.isCluster=!0,this.data.isCluster=!0}hasItems(){return this.data.uiItems&&this.data.uiItems.length&&this.attached}setUiItems(t){this.detach(),this.data.uiItems=t,this._setupRange(),this.attach()}isVisible(t){const e=this.data.end?this.data.end-this.data.start:0,i=this.width*t.getMillisecondsPerPixel(),s=Math.max(this.data.start.getTime()+e,this.data.start.getTime()+i);return this.data.start<t.end&&s>t.start&&this.hasItems()}getData(){return{isCluster:!0,id:this.id,items:this.data.items||[],data:this.data}}redraw(t){var e,i,s=[this._createDomElement.bind(this),this._appendDomElement.bind(this),this._updateDirtyDomComponents.bind(this),function(){this.dirty&&(e=this._getDomComponentsSizes())}.bind(this),function(){this.dirty&&this._updateDomComponentsSizes.bind(this)(e)}.bind(this),this._repaintDomAdditionals.bind(this)];return t?s:(s.forEach((function(t){i=t()})),i)}show(){this.displayed||this.redraw()}hide(){if(this.displayed){var t=this.dom;t.box.parentNode&&t.box.parentNode.removeChild(t.box),this.options.showStipes&&(t.line.parentNode&&t.line.parentNode.removeChild(t.line),t.dot.parentNode&&t.dot.parentNode.removeChild(t.dot)),this.displayed=!1}}repositionX(){let t=this.conversion.toScreen(this.data.start),e=this.data.end?this.conversion.toScreen(this.data.end):0;if(e)this.repositionXWithRanges(t,e);else{let e=void 0===this.data.align?this.options.align:this.data.align;this.repositionXWithoutRanges(t,e)}this.options.showStipes&&(this.dom.line.style.display=this._isStipeVisible()?"block":"none",this.dom.dot.style.display=this._isStipeVisible()?"block":"none",this._isStipeVisible()&&this.repositionStype(t,e))}repositionStype(t,e){this.dom.line.style.display="block",this.dom.dot.style.display="block";const i=this.dom.line.offsetWidth,s=this.dom.dot.offsetWidth;if(e){const o=i+t+(e-t)/2,n=o-s/2,r=this.options.rtl?-1*o:o,a=this.options.rtl?-1*n:n;this.dom.line.style.transform=`translateX(${r}px)`,this.dom.dot.style.transform=`translateX(${a}px)`}else{const e=this.options.rtl?-1*t:t,i=this.options.rtl?-1*(t-s/2):t-s/2;this.dom.line.style.transform=`translateX(${e}px)`,this.dom.dot.style.transform=`translateX(${i}px)`}}repositionXWithoutRanges(t,e){"right"==e?this.options.rtl?(this.right=t-this.width,this.dom.box.style.right=this.right+"px"):(this.left=t-this.width,this.dom.box.style.left=this.left+"px"):"left"==e?this.options.rtl?(this.right=t,this.dom.box.style.right=this.right+"px"):(this.left=t,this.dom.box.style.left=this.left+"px"):this.options.rtl?(this.right=t-this.width/2,this.dom.box.style.right=this.right+"px"):(this.left=t-this.width/2,this.dom.box.style.left=this.left+"px")}repositionXWithRanges(t,e){let i=Math.round(Math.max(e-t+.5,1));this.options.rtl?this.right=t:this.left=t,this.width=Math.max(i,this.minWidth||0),this.options.rtl?this.dom.box.style.right=this.right+"px":this.dom.box.style.left=this.left+"px",this.dom.box.style.width=i+"px"}repositionY(){var t=this.options.orientation.item,e=this.dom.box;if(e.style.top="top"==t?(this.top||0)+"px":(this.parent.height-this.top-this.height||0)+"px",this.options.showStipes){if("top"==t)this.dom.line.style.top="0",this.dom.line.style.height=this.parent.top+this.top+1+"px",this.dom.line.style.bottom="";else{var i=this.parent.itemSet.props.height,s=i-this.parent.top-this.parent.height+this.top;this.dom.line.style.top=i-s+"px",this.dom.line.style.bottom="0"}this.dom.dot.style.top=-this.dom.dot.offsetHeight/2+"px"}}getWidthLeft(){return this.width/2}getWidthRight(){return this.width/2}move(){this.repositionX(),this.repositionY()}attach(){for(let t of this.data.uiItems)t.cluster=this;this.data.items=this.data.uiItems.map((t=>t.data)),this.attached=!0,this.dirty=!0}detach(t=!1){if(this.hasItems()){for(let t of this.data.uiItems)delete t.cluster;this.attached=!1,t&&this.group&&(this.group.remove(this),this.group=null),this.data.items=[],this.dirty=!0}}_onDoubleClick(){this._fit()}_setupRange(){const t=this.data.uiItems.map((t=>({start:t.data.start.valueOf(),end:t.data.end?t.data.end.valueOf():t.data.start.valueOf()})));this.data.min=Math.min(...t.map((t=>Math.min(t.start,t.end||t.start)))),this.data.max=Math.max(...t.map((t=>Math.max(t.start,t.end||t.start))));const e=this.data.uiItems.map((t=>t.center)).reduce(((t,e)=>t+e),0)/this.data.uiItems.length;this.data.uiItems.some((t=>t.data.end))?(this.data.start=new Date(this.data.min),this.data.end=new Date(this.data.max)):(this.data.start=new Date(e),this.data.end=null)}_getUiItems(){return this.data.uiItems&&this.data.uiItems.length?this.data.uiItems.filter((t=>t.cluster===this)):[]}_createDomElement(){this.dom||(this.dom={},this.dom.box=document.createElement("DIV"),this.dom.content=document.createElement("DIV"),this.dom.content.className="vis-item-content",this.dom.box.appendChild(this.dom.content),this.options.showStipes&&(this.dom.line=document.createElement("DIV"),this.dom.line.className="vis-cluster-line",this.dom.line.style.display="none",this.dom.dot=document.createElement("DIV"),this.dom.dot.className="vis-cluster-dot",this.dom.dot.style.display="none"),this.options.fitOnDoubleClick&&(this.dom.box.ondblclick=Rt.prototype._onDoubleClick.bind(this)),this.dom.box["vis-item"]=this,this.dirty=!0)}_appendDomElement(){if(!this.parent)throw new Error("Cannot redraw item: no parent attached");if(!this.dom.box.parentNode){const t=this.parent.dom.foreground;if(!t)throw new Error("Cannot redraw item: parent has no foreground container element");t.appendChild(this.dom.box)}const t=this.parent.dom.background;if(this.options.showStipes){if(!this.dom.line.parentNode){if(!t)throw new Error("Cannot redraw item: parent has no background container element");t.appendChild(this.dom.line)}if(!this.dom.dot.parentNode){var e=this.parent.dom.axis;if(!t)throw new Error("Cannot redraw item: parent has no axis container element");e.appendChild(this.dom.dot)}}this.displayed=!0}_updateDirtyDomComponents(){if(this.dirty){this._updateContents(this.dom.content),this._updateDataAttributes(this.dom.box),this._updateStyle(this.dom.box);const t=this.baseClassName+" "+(this.data.className?" "+this.data.className:"")+(this.selected?" vis-selected":"")+" vis-readonly";this.dom.box.className="vis-item "+t,this.options.showStipes&&(this.dom.line.className="vis-item vis-cluster-line "+(this.selected?" vis-selected":""),this.dom.dot.className="vis-item vis-cluster-dot "+(this.selected?" vis-selected":"")),this.data.end&&(this.dom.content.style.maxWidth="none")}}_getDomComponentsSizes(){const t={previous:{right:this.dom.box.style.right,left:this.dom.box.style.left},box:{width:this.dom.box.offsetWidth,height:this.dom.box.offsetHeight}};return this.options.showStipes&&(t.dot={height:this.dom.dot.offsetHeight,width:this.dom.dot.offsetWidth},t.line={width:this.dom.line.offsetWidth}),t}_updateDomComponentsSizes(t){this.options.rtl?this.dom.box.style.right="0px":this.dom.box.style.left="0px",this.data.end?this.minWidth=t.box.width:this.width=t.box.width,this.height=t.box.height,this.options.rtl?this.dom.box.style.right=t.previous.right:this.dom.box.style.left=t.previous.left,this.dirty=!1}_repaintDomAdditionals(){this._repaintOnItemUpdateTimeTooltip(this.dom.box)}_isStipeVisible(){return this.minWidth>=this.width||!this.data.end}_getFitRange(){const t=.05*(this.data.max-this.data.min)/2;return{fitStart:this.data.min-t,fitEnd:this.data.max+t}}_fit(){if(this.emitter){const{fitStart:t,fitEnd:e}=this._getFitRange(),i={start:new Date(t),end:new Date(e),animation:!0};this.emitter.emit("fit",i)}}_getItemData(){return this.data}}Rt.prototype.baseClassName="vis-item vis-range vis-cluster";const Ft="__ungrouped__";class Gt{constructor(t){this.itemSet=t,this.groups={},this.cache={},this.cache[-1]=[]}createClusterItem(t,e,i){return new Rt(t,e,i)}setItems(t,e){this.items=t||[],this.dataChanged=!0,this.applyOnChangedLevel=!1,e&&e.applyOnChangedLevel&&(this.applyOnChangedLevel=e.applyOnChangedLevel)}updateData(){this.dataChanged=!0,this.applyOnChangedLevel=!1}getClusters(t,e,i){let{maxItems:s,clusterCriteria:o}="boolean"==typeof i?{}:i;o||(o=()=>!0),s=s||1;let n=-1,r=0;if(e>0){if(e>=1)return[];n=Math.abs(Math.round(Math.log(100/e)/Math.log(2))),r=Math.abs(Math.pow(2,n))}if(this.dataChanged){const t=n!=this.cacheLevel;(!this.applyOnChangedLevel||t)&&(this._dropLevelsCache(),this._filterData())}this.cacheLevel=n;let a=this.cache[n];if(!a){a=[];for(let e in this.groups)if(this.groups.hasOwnProperty(e)){const n=this.groups[e],h=n.length;let l=0;for(;l<h;){let e=n[l],h=1,d=l-1;for(;d>=0&&e.center-n[d].center<r/2;)!n[d].cluster&&o(e.data,n[d].data)&&h++,d--;let p=l+1;for(;p<n.length&&n[p].center-e.center<r/2;)o(e.data,n[p].data)&&h++,p++;let m=a.length-1;for(;m>=0&&e.center-a[m].center<r;)e.group==a[m].group&&o(e.data,a[m].data)&&h++,m--;if(h>s){const r=h-s+1,d=[];let p=l;for(;d.length<r&&p<n.length;)o(n[l].data,n[p].data)&&d.push(n[p]),p++;const m=this.itemSet.getGroupId(e.data),c=this.itemSet.groups[m]||this.itemSet.groups[Ft];let u=this._getClusterForItems(d,c,t,i);a.push(u),l+=r}else delete e.cluster,l+=1}}this.cache[n]=a}return a}_filterData(){const t={};this.groups=t;for(const e of Object.values(this.items)){const i=e.parent?e.parent.groupId:"";let s=t[i];s||(s=[],t[i]=s),s.push(e),e.data.start&&(e.data.end?e.center=(e.data.start.valueOf()+e.data.end.valueOf())/2:e.center=e.data.start.valueOf())}for(let e in t)t.hasOwnProperty(e)&&t[e].sort(((t,e)=>t.center-e.center));this.dataChanged=!1}_getClusterForItems(t,e,i,s){const o=(i||[]).map((t=>({cluster:t,itemsIds:new Set(t.data.uiItems.map((t=>t.id)))})));let n;if(o.length)for(let e of o)if(e.itemsIds.size===t.length&&t.every((t=>e.itemsIds.has(t.id)))){n=e.cluster;break}if(n)return n.setUiItems(t),n.group!==e&&(n.group&&n.group.remove(n),e&&(e.add(n),n.group=e)),n;let r=s.titleTemplate||"";const a={toScreen:this.itemSet.body.util.toScreen,toTime:this.itemSet.body.util.toTime},h=r.replace(/{count}/,t.length),l='<div title="'+h+'">'+t.length+"</div>",d=Object.assign({},s,this.itemSet.options),p={content:l,title:h,group:e,uiItems:t,eventEmitter:this.itemSet.body.emitter,range:this.itemSet.body.range};return n=this.createClusterItem(p,a,d),e&&(e.add(n),n.group=e),n.attach(),n}_dropLevelsCache(){this.cache={},this.cacheLevel=-1,this.cache[this.cacheLevel]=[]}}const Ht="__ungrouped__",zt="__background__";class jt extends T{constructor(t,e){super(),this.body=t,this.defaultOptions={type:null,orientation:{item:"bottom"},align:"auto",stack:!0,stackSubgroups:!0,groupOrderSwap(t,e,i){const s=e.order;e.order=t.order,t.order=s},groupOrder:"order",selectable:!0,multiselect:!1,longSelectPressTime:251,itemsAlwaysDraggable:{item:!1,range:!1},editable:{updateTime:!1,updateGroup:!1,add:!1,remove:!1,overrideItems:!1},groupEditable:{order:!1,add:!1,remove:!1},snap:U.snap,onDropObjectOnItem(t,e,i){i(e)},onAdd(t,e){e(t)},onUpdate(t,e){e(t)},onMove(t,e){e(t)},onRemove(t,e){e(t)},onMoving(t,e){e(t)},onAddGroup(t,e){e(t)},onMoveGroup(t,e){e(t)},onRemoveGroup(t,e){e(t)},margin:{item:{horizontal:10,vertical:10},axis:20},showTooltips:!0,tooltip:{followMouse:!1,overflowMethod:"flip",delay:500},tooltipOnItemUpdateTime:!1},this.options=k.extend({},this.defaultOptions),this.options.rtl=e.rtl,this.options.onTimeout=e.onTimeout,this.conversion={toScreen:t.util.toScreen,toTime:t.util.toTime},this.dom={},this.props={},this.hammer=null;const i=this;this.itemsData=null,this.groupsData=null,this.itemsSettingTime=null,this.initialItemSetDrawn=!1,this.userContinueNotBail=null,this.sequentialSelection=!1,this.itemListeners={add(t,e,s){i._onAdd(e.items),i.options.cluster&&i.clusterGenerator.setItems(i.items,{applyOnChangedLevel:!1}),i.redraw()},update(t,e,s){i._onUpdate(e.items),i.options.cluster&&i.clusterGenerator.setItems(i.items,{applyOnChangedLevel:!1}),i.redraw()},remove(t,e,s){i._onRemove(e.items),i.options.cluster&&i.clusterGenerator.setItems(i.items,{applyOnChangedLevel:!1}),i.redraw()}},this.groupListeners={add(t,e,s){if(i._onAddGroups(e.items),i.groupsData&&i.groupsData.length>0){const t=i.groupsData.getDataSet();t.get().forEach((e=>{if(e.nestedGroups){0!=e.showNested&&(e.showNested=!0);let i=[];e.nestedGroups.forEach((s=>{const o=t.get(s);o&&(o.nestedInGroup=e.id,0==e.showNested&&(o.visible=!1),i=i.concat(o))})),t.update(i,s)}}))}},update(t,e,s){i._onUpdateGroups(e.items)},remove(t,e,s){i._onRemoveGroups(e.items)}},this.items={},this.groups={},this.groupIds=[],this.selection=[],this.popup=null,this.popupTimer=null,this.touchParams={},this.groupTouchParams={group:null,isDragging:!1},this._create(),this.setOptions(e),this.clusters=[]}_create(){const t=document.createElement("div");t.className="vis-itemset",t["vis-itemset"]=this,this.dom.frame=t;const e=document.createElement("div");e.className="vis-background",t.appendChild(e),this.dom.background=e;const i=document.createElement("div");i.className="vis-foreground",t.appendChild(i),this.dom.foreground=i;const s=document.createElement("div");s.className="vis-axis",this.dom.axis=s;const o=document.createElement("div");o.className="vis-labelset",this.dom.labelSet=o,this._updateUngrouped();const n=new Ot(zt,null,this);n.show(),this.groups[zt]=n,this.hammer=new W(this.body.dom.centerContainer),this.hammer.on("hammer.input",(t=>{t.isFirst&&this._onTouch(t)})),this.hammer.on("panstart",this._onDragStart.bind(this)),this.hammer.on("panmove",this._onDrag.bind(this)),this.hammer.on("panend",this._onDragEnd.bind(this)),this.hammer.get("pan").set({threshold:5,direction:W.ALL}),this.hammer.get("press").set({time:1e4}),this.hammer.on("tap",this._onSelectItem.bind(this)),this.hammer.on("press",this._onMultiSelectItem.bind(this)),this.hammer.get("press").set({time:1e4}),this.hammer.on("doubletap",this._onAddItem.bind(this)),this.options.rtl?this.groupHammer=new W(this.body.dom.rightContainer):this.groupHammer=new W(this.body.dom.leftContainer),this.groupHammer.on("tap",this._onGroupClick.bind(this)),this.groupHammer.on("panstart",this._onGroupDragStart.bind(this)),this.groupHammer.on("panmove",this._onGroupDrag.bind(this)),this.groupHammer.on("panend",this._onGroupDragEnd.bind(this)),this.groupHammer.get("pan").set({threshold:5,direction:W.DIRECTION_VERTICAL}),this.body.dom.centerContainer.addEventListener("mouseover",this._onMouseOver.bind(this)),this.body.dom.centerContainer.addEventListener("mouseout",this._onMouseOut.bind(this)),this.body.dom.centerContainer.addEventListener("mousemove",this._onMouseMove.bind(this)),this.body.dom.centerContainer.addEventListener("contextmenu",this._onDragEnd.bind(this)),this.body.dom.centerContainer.addEventListener("mousewheel",this._onMouseWheel.bind(this)),this.show()}setOptions(t){if(t){const e=["type","rtl","align","order","stack","stackSubgroups","selectable","multiselect","sequentialSelection","multiselectPerGroup","longSelectPressTime","groupOrder","dataAttributes","template","groupTemplate","visibleFrameTemplate","hide","snap","groupOrderSwap","showTooltips","tooltip","tooltipOnItemUpdateTime","groupHeightMode","onTimeout"];k.selectiveExtend(e,this.options,t),"itemsAlwaysDraggable"in t&&("boolean"==typeof t.itemsAlwaysDraggable?(this.options.itemsAlwaysDraggable.item=t.itemsAlwaysDraggable,this.options.itemsAlwaysDraggable.range=!1):"object"==typeof t.itemsAlwaysDraggable&&(k.selectiveExtend(["item","range"],this.options.itemsAlwaysDraggable,t.itemsAlwaysDraggable),this.options.itemsAlwaysDraggable.item||(this.options.itemsAlwaysDraggable.range=!1))),"sequentialSelection"in t&&"boolean"==typeof t.sequentialSelection&&(this.options.sequentialSelection=t.sequentialSelection),"orientation"in t&&("string"==typeof t.orientation?this.options.orientation.item="top"===t.orientation?"top":"bottom":"object"==typeof t.orientation&&"item"in t.orientation&&(this.options.orientation.item=t.orientation.item)),"margin"in t&&("number"==typeof t.margin?(this.options.margin.axis=t.margin,this.options.margin.item.horizontal=t.margin,this.options.margin.item.vertical=t.margin):"object"==typeof t.margin&&(k.selectiveExtend(["axis"],this.options.margin,t.margin),"item"in t.margin&&("number"==typeof t.margin.item?(this.options.margin.item.horizontal=t.margin.item,this.options.margin.item.vertical=t.margin.item):"object"==typeof t.margin.item&&k.selectiveExtend(["horizontal","vertical"],this.options.margin.item,t.margin.item)))),["locale","locales"].forEach((e=>{e in t&&(this.options[e]=t[e])})),"editable"in t&&("boolean"==typeof t.editable?(this.options.editable.updateTime=t.editable,this.options.editable.updateGroup=t.editable,this.options.editable.add=t.editable,this.options.editable.remove=t.editable,this.options.editable.overrideItems=!1):"object"==typeof t.editable&&k.selectiveExtend(["updateTime","updateGroup","add","remove","overrideItems"],this.options.editable,t.editable)),"groupEditable"in t&&("boolean"==typeof t.groupEditable?(this.options.groupEditable.order=t.groupEditable,this.options.groupEditable.add=t.groupEditable,this.options.groupEditable.remove=t.groupEditable):"object"==typeof t.groupEditable&&k.selectiveExtend(["order","add","remove"],this.options.groupEditable,t.groupEditable));["onDropObjectOnItem","onAdd","onUpdate","onRemove","onMove","onMoving","onAddGroup","onMoveGroup","onRemoveGroup"].forEach((e=>{const i=t[e];if(i){if("function"!=typeof i)throw new Error(`option ${e} must be a function ${e}(item, callback)`);this.options[e]=i}})),t.cluster?(Object.assign(this.options,{cluster:t.cluster}),this.clusterGenerator||(this.clusterGenerator=new Gt(this)),this.clusterGenerator.setItems(this.items,{applyOnChangedLevel:!1}),this.markDirty({refreshItems:!0,restackGroups:!0}),this.redraw()):this.clusterGenerator?(this._detachAllClusters(),this.clusters=[],this.clusterGenerator=null,this.options.cluster=void 0,this.markDirty({refreshItems:!0,restackGroups:!0}),this.redraw()):this.markDirty()}}markDirty(t){this.groupIds=[],t&&(t.refreshItems&&k.forEach(this.items,(t=>{t.dirty=!0,t.displayed&&t.redraw()})),t.restackGroups&&k.forEach(this.groups,((t,e)=>{e!==zt&&(t.stackDirty=!0)})))}destroy(){this.clearPopupTimer(),this.hide(),this.setItems(null),this.setGroups(null),this.hammer&&this.hammer.destroy(),this.groupHammer&&this.groupHammer.destroy(),this.hammer=null,this.body=null,this.conversion=null}hide(){this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame),this.dom.axis.parentNode&&this.dom.axis.parentNode.removeChild(this.dom.axis),this.dom.labelSet.parentNode&&this.dom.labelSet.parentNode.removeChild(this.dom.labelSet)}show(){this.dom.frame.parentNode||this.body.dom.center.appendChild(this.dom.frame),this.dom.axis.parentNode||this.body.dom.backgroundVertical.appendChild(this.dom.axis),this.dom.labelSet.parentNode||(this.options.rtl?this.body.dom.right.appendChild(this.dom.labelSet):this.body.dom.left.appendChild(this.dom.labelSet))}setPopupTimer(t){if(this.clearPopupTimer(),t){const e=this.options.tooltip.delay||"number"==typeof this.options.tooltip.delay?this.options.tooltip.delay:500;this.popupTimer=setTimeout((function(){t.show()}),e)}}clearPopupTimer(){null!=this.popupTimer&&(clearTimeout(this.popupTimer),this.popupTimer=null)}setSelection(t){null==t&&(t=[]),Array.isArray(t)||(t=[t]);const e=this.selection.filter((e=>-1===t.indexOf(e)));for(let t of e){const e=this.getItemById(t);e&&e.unselect()}this.selection=[...t];for(let e of t){const t=this.getItemById(e);t&&t.select()}}getSelection(){return this.selection.concat([])}getVisibleItems(){const t=this.body.range.getRange();let e,i;this.options.rtl?(e=this.body.util.toScreen(t.start),i=this.body.util.toScreen(t.end)):(i=this.body.util.toScreen(t.start),e=this.body.util.toScreen(t.end));const s=[];for(const t in this.groups)if(this.groups.hasOwnProperty(t)){const o=this.groups[t],n=o.isVisible?o.visibleItems:[];for(const t of n)this.options.rtl?t.right<i&&t.right+t.width>e&&s.push(t.id):t.left<e&&t.left+t.width>i&&s.push(t.id)}return s}getItemsAtCurrentTime(t){let e,i;this.options.rtl?(e=this.body.util.toScreen(t),i=this.body.util.toScreen(t)):(i=this.body.util.toScreen(t),e=this.body.util.toScreen(t));const s=[];for(const t in this.groups)if(this.groups.hasOwnProperty(t)){const o=this.groups[t],n=o.isVisible?o.visibleItems:[];for(const t of n)this.options.rtl?t.right<i&&t.right+t.width>e&&s.push(t.id):t.left<e&&t.left+t.width>i&&s.push(t.id)}return s}getVisibleGroups(){const t=[];for(const e in this.groups)if(this.groups.hasOwnProperty(e)){this.groups[e].isVisible&&t.push(e)}return t}getItemById(t){return this.items[t]||this.clusters.find((e=>e.id===t))}_deselect(t){const e=this.selection;for(let i=0,s=e.length;i<s;i++)if(e[i]==t){e.splice(i,1);break}}redraw(){const t=this.options.margin,e=this.body.range,i=k.option.asSize,s=this.options,o=s.orientation.item;let n=!1;const r=this.dom.frame;this.props.top=this.body.domProps.top.height+this.body.domProps.border.top,this.options.rtl?this.props.right=this.body.domProps.right.width+this.body.domProps.border.right:this.props.left=this.body.domProps.left.width+this.body.domProps.border.left,r.className="vis-itemset",this.options.cluster&&this._clusterItems(),n=this._orderGroups()||n;const a=e.end-e.start,h=a!=this.lastVisibleInterval||this.props.width!=this.props.lastWidth,l=e.start!=this.lastRangeStart,d=s.stack!=this.lastStack,p=s.stackSubgroups!=this.lastStackSubgroups,m=h||l||d||p;this.lastVisibleInterval=a,this.lastRangeStart=e.start,this.lastStack=s.stack,this.lastStackSubgroups=s.stackSubgroups,this.props.lastWidth=this.props.width;const c=this._firstGroup(),u={item:t.item,axis:t.axis},g={item:t.item,axis:t.item.vertical/2};let f=0;const b=t.axis+t.item.vertical;this.groups[zt].redraw(e,g,m);const y={};let v=0;k.forEach(this.groups,((t,i)=>{if(i===zt)return;const s=t==c?u:g;y[i]=t.redraw(e,s,m,!0),v=y[i].length}));if(v>0){const t={};for(let e=0;e<v;e++)k.forEach(y,((i,s)=>{t[s]=i[e]()}));k.forEach(this.groups,((e,i)=>{if(i===zt)return;const s=t[i];n=s||n,f+=e.height})),f=Math.max(f,b)}return f=Math.max(f,b),r.style.height=i(f),this.props.width=r.offsetWidth,this.props.height=f,this.dom.axis.style.top=i("top"==o?this.body.domProps.top.height+this.body.domProps.border.top:this.body.domProps.top.height+this.body.domProps.centerContainer.height),this.options.rtl?this.dom.axis.style.right="0":this.dom.axis.style.left="0",this.hammer.get("press").set({time:this.options.longSelectPressTime}),this.initialItemSetDrawn=!0,n=this._isResized()||n,n}_firstGroup(){const t="top"==this.options.orientation.item?0:this.groupIds.length-1,e=this.groupIds[t];return this.groups[e]||this.groups[Ht]||null}_updateUngrouped(){let t,e,i=this.groups[Ht];if(this.groupsData){if(i)for(e in i.dispose(),delete this.groups[Ht],this.items)if(this.items.hasOwnProperty(e)){t=this.items[e],t.parent&&t.parent.remove(t);const i=this.getGroupId(t.data),s=this.groups[i];s&&s.add(t)||t.hide()}}else if(!i){const s=null,o=null;for(e in i=new Et(s,o,this),this.groups[Ht]=i,this.items)this.items.hasOwnProperty(e)&&(t=this.items[e],i.add(t));i.show()}}getLabelSet(){return this.dom.labelSet}setItems(t){this.itemsSettingTime=new Date;const e=this;let i;const s=this.itemsData;if(t){if(!y(t))throw new TypeError("Data must implement the interface of DataSet or DataView");this.itemsData=x(t)}else this.itemsData=null;if(s&&(k.forEach(this.itemListeners,((t,e)=>{s.off(e,t)})),s.dispose(),i=s.getIds(),this._onRemove(i)),this.itemsData){const t=this.id;k.forEach(this.itemListeners,((i,s)=>{e.itemsData.on(s,i,t)})),i=this.itemsData.getIds(),this._onAdd(i),this._updateUngrouped()}this.body.emitter.emit("_change",{queue:!0})}getItems(){return null!=this.itemsData?this.itemsData.rawDS:null}setGroups(t){const e=this;let i;if(this.groupsData&&(k.forEach(this.groupListeners,((t,i)=>{e.groupsData.off(i,t)})),i=this.groupsData.getIds(),this.groupsData=null,this._onRemoveGroups(i)),t){if(!y(t))throw new TypeError("Data must implement the interface of DataSet or DataView");this.groupsData=t}else this.groupsData=null;if(this.groupsData){const t=this.groupsData.getDataSet();t.get().forEach((e=>{e.nestedGroups&&e.nestedGroups.forEach((i=>{const s=t.get(i);s.nestedInGroup=e.id,0==e.showNested&&(s.visible=!1),t.update(s)}))}));const s=this.id;k.forEach(this.groupListeners,((t,i)=>{e.groupsData.on(i,t,s)})),i=this.groupsData.getIds(),this._onAddGroups(i)}this._updateUngrouped(),this._order(),this.options.cluster&&(this.clusterGenerator.updateData(),this._clusterItems(),this.markDirty({refreshItems:!0,restackGroups:!0})),this.body.emitter.emit("_change",{queue:!0})}getGroups(){return this.groupsData}removeItem(t){const e=this.itemsData.get(t);e&&this.options.onRemove(e,(e=>{e&&this.itemsData.remove(t)}))}_getType(t){return t.type||this.options.type||(t.end?"range":"box")}getGroupId(t){return"background"==this._getType(t)&&null==t.group?zt:this.groupsData?t.group:Ht}_onUpdate(t){const e=this;t.forEach((t=>{const i=e.itemsData.get(t);let s=e.items[t];const o=i?e._getType(i):null,n=jt.types[o];let r;if(s&&(n&&s instanceof n?e._updateItem(s,i):(r=s.selected,e._removeItem(s),s=null)),!s&&i){if(!n)throw new TypeError(`Unknown item type "${o}"`);s=new n(i,e.conversion,e.options),s.id=t,e._addItem(s),r&&(this.selection.push(t),s.select())}})),this._order(),this.options.cluster&&(this.clusterGenerator.setItems(this.items,{applyOnChangedLevel:!1}),this._clusterItems()),this.body.emitter.emit("_change",{queue:!0})}_onRemove(t){let e=0;const i=this;t.forEach((t=>{const s=i.items[t];s&&(e++,i._removeItem(s))})),e&&(this._order(),this.body.emitter.emit("_change",{queue:!0}))}_order(){k.forEach(this.groups,(t=>{t.order()}))}_onUpdateGroups(t){this._onAddGroups(t)}_onAddGroups(t){const e=this;t.forEach((t=>{const i=e.groupsData.get(t);let s=e.groups[t];if(s)s.setData(i);else{if(t==Ht||t==zt)throw new Error(`Illegal group id. ${t} is a reserved id.`);const o=Object.create(e.options);k.extend(o,{height:null}),s=new Et(t,i,e),e.groups[t]=s;for(const i in e.items)if(e.items.hasOwnProperty(i)){const o=e.items[i];o.data.group==t&&s.add(o)}s.order(),s.show()}})),this.body.emitter.emit("_change",{queue:!0})}_onRemoveGroups(t){t.forEach((t=>{const e=this.groups[t];e&&(e.dispose(),delete this.groups[t])})),this.options.cluster&&(this.clusterGenerator.updateData(),this._clusterItems()),this.markDirty({restackGroups:!!this.options.cluster}),this.body.emitter.emit("_change",{queue:!0})}_orderGroups(){if(this.groupsData){let t=this.groupsData.getIds({order:this.options.groupOrder});t=this._orderNestedGroups(t);const e=!k.equalArray(t,this.groupIds);if(e){const e=this.groups;t.forEach((t=>{e[t].hide()})),t.forEach((t=>{e[t].show()})),this.groupIds=t}return e}return!1}_orderNestedGroups(t){return function t(e,i){let s=[];return i.forEach((i=>{s.push(i);if(e.groupsData.get(i).nestedGroups){const o=e.groupsData.get({filter:t=>t.nestedInGroup==i,order:e.options.groupOrder}).map((t=>t.id));s=s.concat(t(e,o))}})),s}(this,t.filter((t=>!this.groupsData.get(t).nestedInGroup)))}_addItem(t){this.items[t.id]=t;const e=this.getGroupId(t.data),i=this.groups[e];i?i&&i.data&&i.data.showNested&&(t.groupShowing=!0):t.groupShowing=!1,i&&i.add(t)}_updateItem(t,e){t.setData(e);const i=this.getGroupId(t.data),s=this.groups[i];s?s&&s.data&&s.data.showNested&&(t.groupShowing=!0):t.groupShowing=!1}_removeItem(t){t.hide(),delete this.items[t.id];const e=this.selection.indexOf(t.id);-1!=e&&this.selection.splice(e,1),t.parent&&t.parent.remove(t),null!=this.popup&&this.popup.hide()}_constructByEndArray(t){const e=[];for(let i=0;i<t.length;i++)t[i]instanceof Pt&&e.push(t[i]);return e}_onTouch(t){this.touchParams.item=this.itemFromTarget(t),this.touchParams.dragLeftItem=t.target.dragLeftItem||!1,this.touchParams.dragRightItem=t.target.dragRightItem||!1,this.touchParams.itemProps=null}_getGroupIndex(t){for(let e=0;e<this.groupIds.length;e++)if(t==this.groupIds[e])return e}_onDragStart(t){if(this.touchParams.itemIsDragging)return;const e=this.touchParams.item||null,i=this;let s;if(e&&(e.selected||this.options.itemsAlwaysDraggable.item)){if(this.options.editable.overrideItems&&!this.options.editable.updateTime&&!this.options.editable.updateGroup)return;if(null!=e.editable&&!e.editable.updateTime&&!e.editable.updateGroup&&!this.options.editable.overrideItems)return;const o=this.touchParams.dragLeftItem,n=this.touchParams.dragRightItem;if(this.touchParams.itemIsDragging=!0,this.touchParams.selectedItem=e,o)s={item:o,initialX:t.center.x,dragLeft:!0,data:this._cloneItemData(e.data)},this.touchParams.itemProps=[s];else if(n)s={item:n,initialX:t.center.x,dragRight:!0,data:this._cloneItemData(e.data)},this.touchParams.itemProps=[s];else if(this.options.editable.add&&(t.srcEvent.ctrlKey||t.srcEvent.metaKey))this._onDragStartAddItem(t);else{this.groupIds.length<1&&this.redraw();const s=this._getGroupIndex(e.data.group),o=this.options.itemsAlwaysDraggable.item&&!e.selected?[e.id]:this.getSelection();this.touchParams.itemProps=o.map((e=>{const o=i.items[e],n=i._getGroupIndex(o.data.group);return{item:o,initialX:t.center.x,groupOffset:s-n,data:this._cloneItemData(o.data)}}))}t.stopPropagation()}else this.options.editable.add&&(t.srcEvent.ctrlKey||t.srcEvent.metaKey)&&this._onDragStartAddItem(t)}_onDragStartAddItem(t){const e=this.options.snap||null,i=this.dom.frame.getBoundingClientRect(),s=this.options.rtl?i.right-t.center.x+10:t.center.x-i.left-10,o=this.body.util.toTime(s),n=this.body.util.getScale(),r=this.body.util.getStep(),a=e?e(o,n,r):o,h={type:"range",start:a,end:a,content:"new item"},l=p();h[this.itemsData.idProp]=l;const d=this.groupFromTarget(t);d&&(h.group=d.groupId);const m=new Pt(h,this.conversion,this.options);m.id=l,m.data=this._cloneItemData(h),this._addItem(m),this.touchParams.selectedItem=m;const c={item:m,initialX:t.center.x,data:m.data};this.options.rtl?c.dragLeft=!0:c.dragRight=!0,this.touchParams.itemProps=[c],t.stopPropagation()}_onDrag(t){if(null!=this.popup&&this.options.showTooltips&&!this.popup.hidden){const e=this.body.dom.centerContainer,i=e.getBoundingClientRect();this.popup.setPosition(t.center.x-i.left+e.offsetLeft,t.center.y-i.top+e.offsetTop),this.popup.show()}if(this.touchParams.itemProps){t.stopPropagation();const e=this,i=this.options.snap||null,s=this.body.dom.root.offsetLeft,o=this.options.rtl?s+this.body.domProps.right.width:s+this.body.domProps.left.width,n=this.body.util.getScale(),r=this.body.util.getStep(),a=this.touchParams.selectedItem,h=(this.options.editable.overrideItems||null==a.editable)&&this.options.editable.updateGroup||!this.options.editable.overrideItems&&null!=a.editable&&a.editable.updateGroup;let l=null;if(h&&a&&null!=a.data.group){const i=e.groupFromTarget(t);i&&(l=this._getGroupIndex(i.groupId))}this.touchParams.itemProps.forEach((s=>{const d=e.body.util.toTime(t.center.x-o),p=e.body.util.toTime(s.initialX-o);let m,c,u,g,f;m=this.options.rtl?-(d-p):d-p;let b=this._cloneItemData(s.item.data);if(null!=s.item.editable&&!s.item.editable.updateTime&&!s.item.editable.updateGroup&&!e.options.editable.overrideItems)return;if((this.options.editable.overrideItems||null==a.editable)&&this.options.editable.updateTime||!this.options.editable.overrideItems&&null!=a.editable&&a.editable.updateTime)if(s.dragLeft)this.options.rtl?null!=b.end&&(u=k.convert(s.data.end,"Date"),f=new Date(u.valueOf()+m),b.end=i?i(f,n,r):f):null!=b.start&&(c=k.convert(s.data.start,"Date"),g=new Date(c.valueOf()+m),b.start=i?i(g,n,r):g);else if(s.dragRight)this.options.rtl?null!=b.start&&(c=k.convert(s.data.start,"Date"),g=new Date(c.valueOf()+m),b.start=i?i(g,n,r):g):null!=b.end&&(u=k.convert(s.data.end,"Date"),f=new Date(u.valueOf()+m),b.end=i?i(f,n,r):f);else if(null!=b.start)if(c=k.convert(s.data.start,"Date").valueOf(),g=new Date(c+m),null!=b.end){u=k.convert(s.data.end,"Date");const t=u.valueOf()-c.valueOf();b.start=i?i(g,n,r):g,b.end=new Date(b.start.valueOf()+t)}else b.start=i?i(g,n,r):g;if(h&&!s.dragLeft&&!s.dragRight&&null!=l&&null!=b.group){let t=l-s.groupOffset;t=Math.max(0,t),t=Math.min(e.groupIds.length-1,t),b.group=e.groupIds[t]}b=this._cloneItemData(b),e.options.onMoving(b,(t=>{t&&s.item.setData(this._cloneItemData(t,"Date"))}))})),this.body.emitter.emit("_change")}}_moveToGroup(t,e){const i=this.groups[e];if(i&&i.groupId!=t.data.group){const e=t.parent;e.remove(t),e.order(),t.data.group=i.groupId,i.add(t),i.order()}}_onDragEnd(t){if(this.touchParams.itemIsDragging=!1,this.touchParams.itemProps){t.stopPropagation();const e=this,i=this.touchParams.itemProps;this.touchParams.itemProps=null,i.forEach((t=>{const i=t.item.id;if(null!=e.itemsData.get(i)){const s=this._cloneItemData(t.item.data);e.options.onMove(s,(s=>{s?(s[this.itemsData.idProp]=i,this.itemsData.update(s)):(t.item.setData(t.data),e.body.emitter.emit("_change"))}))}else e.options.onAdd(t.item.data,(i=>{e._removeItem(t.item),i&&e.itemsData.add(i),e.body.emitter.emit("_change")}))}))}}_onGroupClick(t){const e=this.groupFromTarget(t);setTimeout((()=>{this.toggleGroupShowNested(e)}),1)}toggleGroupShowNested(t,e=void 0){if(!t||!t.nestedGroups)return;const i=this.groupsData.getDataSet();t.showNested=null!=e?!!e:!t.showNested;let s=i.get(t.groupId);s.showNested=t.showNested;let o=t.nestedGroups,n=o;for(;n.length>0;){let t=n;n=[];for(let e=0;e<t.length;e++){let s=i.get(t[e]);s.nestedGroups&&(n=n.concat(s.nestedGroups))}n.length>0&&(o=o.concat(n))}var r;if(s.showNested){var a=i.get(s.nestedGroups);for(let t=0;t<a.length;t++){let e=a[t];e.nestedGroups&&e.nestedGroups.length>0&&(null==e.showNested||1==e.showNested)&&a.push(...i.get(e.nestedGroups))}r=a.map((function(t){return null==t.visible&&(t.visible=!0),t.visible=!!s.showNested,t}))}else r=i.get(o).map((function(t){return null==t.visible&&(t.visible=!0),t.visible=!!s.showNested,t}));i.update(r.concat(s)),s.showNested?(k.removeClassName(t.dom.label,"collapsed"),k.addClassName(t.dom.label,"expanded")):(k.removeClassName(t.dom.label,"expanded"),k.addClassName(t.dom.label,"collapsed"))}toggleGroupDragClassName(t){t.dom.label.classList.toggle("vis-group-is-dragging"),t.dom.foreground.classList.toggle("vis-group-is-dragging")}_onGroupDragStart(t){this.groupTouchParams.isDragging||this.options.groupEditable.order&&(this.groupTouchParams.group=this.groupFromTarget(t),this.groupTouchParams.group&&(t.stopPropagation(),this.groupTouchParams.isDragging=!0,this.toggleGroupDragClassName(this.groupTouchParams.group),this.groupTouchParams.originalOrder=this.groupsData.getIds({order:this.options.groupOrder})))}_onGroupDrag(t){if(this.options.groupEditable.order&&this.groupTouchParams.group){t.stopPropagation();const e=this.groupsData.getDataSet(),i=this.groupFromTarget(t);if(i&&i.height!=this.groupTouchParams.group.height){const e=i.top<this.groupTouchParams.group.top,s=t.center?t.center.y:t.clientY,o=i.dom.foreground.getBoundingClientRect(),n=this.groupTouchParams.group.height;if(e){if(o.top+n<s)return}else{const t=i.height;if(o.top+t-n>s)return}}if(i&&i!=this.groupTouchParams.group){const t=e.get(i.groupId),s=e.get(this.groupTouchParams.group.groupId);s&&t&&(this.options.groupOrderSwap(s,t,e),e.update(s),e.update(t));const o=e.getIds({order:this.options.groupOrder});if(!k.equalArray(o,this.groupTouchParams.originalOrder)){const t=this.groupTouchParams.originalOrder,i=this.groupTouchParams.group.groupId,s=Math.min(t.length,o.length);let n=0,r=0,a=0;for(;n<s;){for(;n+r<s&&n+a<s&&o[n+r]==t[n+a];)n++;if(n+r>=s)break;if(o[n+r]==i)r=1;else if(t[n+a]==i)a=1;else{const i=o.indexOf(t[n+a]),s=e.get(o[n+r]),h=e.get(t[n+a]);this.options.groupOrderSwap(s,h,e),e.update(s),e.update(h);const l=o[n+r];o[n+r]=t[n+a],o[i]=l,n++}}}}}}_onGroupDragEnd(t){if(this.groupTouchParams.isDragging=!1,this.options.groupEditable.order&&this.groupTouchParams.group){t.stopPropagation();const e=this,i=e.groupTouchParams.group.groupId,s=e.groupsData.getDataSet(),o=k.extend({},s.get(i));e.options.onMoveGroup(o,(t=>{if(t)t[s._idProp]=i,s.update(t);else{const t=s.getIds({order:e.options.groupOrder});if(!k.equalArray(t,e.groupTouchParams.originalOrder)){const i=e.groupTouchParams.originalOrder,o=Math.min(i.length,t.length);let n=0;for(;n<o;){for(;n<o&&t[n]==i[n];)n++;if(n>=o)break;const r=t.indexOf(i[n]),a=s.get(t[n]),h=s.get(i[n]);e.options.groupOrderSwap(a,h,s),s.update(a),s.update(h);const l=t[n];t[n]=i[n],t[r]=l,n++}}}})),e.body.emitter.emit("groupDragged",{groupId:i}),this.toggleGroupDragClassName(this.groupTouchParams.group),this.groupTouchParams.group=null}}_onSelectItem(t){if(!this.options.selectable)return;const e=t.srcEvent&&(t.srcEvent.ctrlKey||t.srcEvent.metaKey),i=t.srcEvent&&t.srcEvent.shiftKey;if(e||i)return void this._onMultiSelectItem(t);const s=this.getSelection(),o=this.itemFromTarget(t),n=o&&o.selectable?[o.id]:[];this.setSelection(n);const r=this.getSelection();(r.length>0||s.length>0)&&this.body.emitter.emit("select",{items:r,event:t})}_onMouseOver(t){const e=this.itemFromTarget(t);if(!e)return;if(e===this.itemFromRelatedTarget(t))return;const i=e.getTitle();if(this.options.showTooltips&&i){null==this.popup&&(this.popup=new Lt(this.body.dom.root,this.options.tooltip.overflowMethod||"flip")),this.popup.setText(i);const e=this.body.dom.centerContainer,s=e.getBoundingClientRect();this.popup.setPosition(t.clientX-s.left+e.offsetLeft,t.clientY-s.top+e.offsetTop),this.setPopupTimer(this.popup)}else this.clearPopupTimer(),null!=this.popup&&this.popup.hide();this.body.emitter.emit("itemover",{item:e.id,event:t})}_onMouseOut(t){const e=this.itemFromTarget(t);if(!e)return;e!==this.itemFromRelatedTarget(t)&&(this.clearPopupTimer(),null!=this.popup&&this.popup.hide(),this.body.emitter.emit("itemout",{item:e.id,event:t}))}_onMouseMove(t){if(this.itemFromTarget(t)&&(null!=this.popupTimer&&this.setPopupTimer(this.popup),this.options.showTooltips&&this.options.tooltip.followMouse&&this.popup&&!this.popup.hidden)){const e=this.body.dom.centerContainer,i=e.getBoundingClientRect();this.popup.setPosition(t.clientX-i.left+e.offsetLeft,t.clientY-i.top+e.offsetTop),this.popup.show()}}_onMouseWheel(t){this.touchParams.itemIsDragging&&this._onDragEnd(t)}_onUpdateItem(t){if(!this.options.selectable)return;if(!this.options.editable.updateTime&&!this.options.editable.updateGroup)return;const e=this;if(t){const i=e.itemsData.get(t.id);this.options.onUpdate(i,(t=>{t&&e.itemsData.update(t)}))}}_onDropObjectOnItem(t){const e=this.itemFromTarget(t),i=JSON.parse(t.dataTransfer.getData("text"));this.options.onDropObjectOnItem(i,e)}_onAddItem(t){if(!this.options.selectable)return;if(!this.options.editable.add)return;const e=this,i=this.options.snap||null,s=this.dom.frame.getBoundingClientRect(),o=this.options.rtl?s.right-t.center.x:t.center.x-s.left,n=this.body.util.toTime(o),r=this.body.util.getScale(),a=this.body.util.getStep();let h,l;"drop"==t.type?(l=JSON.parse(t.dataTransfer.getData("text")),l.content=l.content?l.content:"new item",l.start=l.start?l.start:i?i(n,r,a):n,l.type=l.type||"box",l[this.itemsData.idProp]=l.id||p(),"range"!=l.type||l.end||(h=this.body.util.toTime(o+this.props.width/5),l.end=i?i(h,r,a):h)):(l={start:i?i(n,r,a):n,content:"new item"},l[this.itemsData.idProp]=p(),"range"===this.options.type&&(h=this.body.util.toTime(o+this.props.width/5),l.end=i?i(h,r,a):h));const d=this.groupFromTarget(t);d&&(l.group=d.groupId),l=this._cloneItemData(l),this.options.onAdd(l,(i=>{i&&(e.itemsData.add(i),"drop"==t.type&&e.setSelection([i.id]))}))}_onMultiSelectItem(t){if(!this.options.selectable)return;const e=this.itemFromTarget(t);if(e){let i=this.options.multiselect?this.getSelection():[];if((t.srcEvent&&t.srcEvent.shiftKey||!1||this.options.sequentialSelection)&&this.options.multiselect){const t=this.itemsData.get(e.id).group;let s;this.options.multiselectPerGroup&&i.length>0&&(s=this.itemsData.get(i[0]).group),this.options.multiselectPerGroup&&null!=s&&s!=t||i.push(e.id);const o=jt._getItemRange(this.itemsData.get(i));if(!this.options.multiselectPerGroup||s==t){i=[];for(const t in this.items)if(this.items.hasOwnProperty(t)){const e=this.items[t],n=e.data.start,r=void 0!==e.data.end?e.data.end:n;!(n>=o.min&&r<=o.max)||this.options.multiselectPerGroup&&s!=this.itemsData.get(e.id).group||e instanceof At||i.push(e.id)}}}else{const t=i.indexOf(e.id);-1==t?i.push(e.id):i.splice(t,1)}const s=i.filter((t=>this.getItemById(t).selectable));this.setSelection(s),this.body.emitter.emit("select",{items:this.getSelection(),event:t})}}static _getItemRange(t){let e=null,i=null;return t.forEach((t=>{(null==i||t.start<i)&&(i=t.start),null!=t.end?(null==e||t.end>e)&&(e=t.end):(null==e||t.start>e)&&(e=t.start)})),{min:i,max:e}}itemFromElement(t){let e=t;for(;e;){if(e.hasOwnProperty("vis-item"))return e["vis-item"];e=e.parentNode}return null}itemFromTarget(t){return this.itemFromElement(t.target)}itemFromRelatedTarget(t){return this.itemFromElement(t.relatedTarget)}groupFromTarget(t){const e=t.center?t.center.y:t.clientY;let i=this.groupIds;i.length<=0&&this.groupsData&&(i=this.groupsData.getIds({order:this.options.groupOrder}));for(let t=0;t<i.length;t++){const s=i[t],o=this.groups[s],n=o.dom.foreground,r=n.getBoundingClientRect();if(e>=r.top&&e<r.top+n.offsetHeight)return o;if("top"===this.options.orientation.item){if(t===this.groupIds.length-1&&e>r.top)return o}else if(0===t&&e<r.top+n.offset)return o}return null}static itemSetFromTarget(t){let e=t.target;for(;e;){if(e.hasOwnProperty("vis-itemset"))return e["vis-itemset"];e=e.parentNode}return null}_cloneItemData(t,e){const i=k.extend({},t);return e||(e=this.itemsData.type),null!=i.start&&(i.start=k.convert(i.start,e&&e.start||"Date")),null!=i.end&&(i.end=k.convert(i.end,e&&e.end||"Date")),i}_clusterItems(){if(!this.options.cluster)return;const{scale:t}=this.body.range.conversion(this.body.domProps.center.width),e=this.clusterGenerator.getClusters(this.clusters,t,this.options.cluster);if(this.clusters!=e){if(this._detachAllClusters(),e){for(let t of e)t.attach();this.clusters=e}this._updateClusters(e)}}_detachAllClusters(){if(this.options.cluster&&this.clusters&&this.clusters.length)for(let t of this.clusters)t.detach()}_updateClusters(t){if(this.clusters&&this.clusters.length){const e=new Set(t.map((t=>t.id))),i=this.clusters.filter((t=>!e.has(t.id)));let s=!1;for(let t of i){const e=this.selection.indexOf(t.id);-1!==e&&(t.unselect(),this.selection.splice(e,1),s=!0)}if(s){const t=this.getSelection();this.body.emitter.emit("select",{items:t,event:event})}}this.clusters=t||[]}}jt.types={background:At,box:It,range:Pt,point:Nt},jt.prototype._onAdd=jt.prototype._onUpdate;let Bt,Yt=!1,$t="background: #FFeeee; color: #dd0000";class Wt{constructor(){}static validate(t,e,i){Yt=!1,Bt=e;let s=e;return void 0!==i&&(s=e[i]),Wt.parse(t,s,[]),Yt}static parse(t,e,i){for(let s in t)t.hasOwnProperty(s)&&Wt.check(s,t,e,i)}static check(t,e,i,s){if(void 0===i[t]&&void 0===i.__any__)return void Wt.getSuggestion(t,i,s);let o=t,n=!0;void 0===i[t]&&void 0!==i.__any__&&(o="__any__",n="object"===Wt.getType(e[t]));let r=i[o];n&&void 0!==r.__type__&&(r=r.__type__),Wt.checkFields(t,e,i,o,r,s)}static checkFields(t,e,i,s,o,n){let r=function(e){console.log("%c"+e+Wt.printLocation(n,t),$t)},a=Wt.getType(e[t]),h=o[a];void 0!==h?"array"===Wt.getType(h)&&-1===h.indexOf(e[t])?(r('Invalid option detected in "'+t+'". Allowed values are:'+Wt.print(h)+' not "'+e[t]+'". '),Yt=!0):"object"===a&&"__any__"!==s&&(n=k.copyAndExtendArray(n,t),Wt.parse(e[t],i[s],n)):void 0===o.any&&(r('Invalid type received for "'+t+'". Expected: '+Wt.print(Object.keys(o))+". Received ["+a+'] "'+e[t]+'"'),Yt=!0)}static getType(t){var e=typeof t;return"object"===e?null===t?"null":t instanceof Boolean?"boolean":t instanceof Number?"number":t instanceof String?"string":Array.isArray(t)?"array":t instanceof Date?"date":void 0!==t.nodeType?"dom":!0===t._isAMomentObject?"moment":"object":"number"===e?"number":"boolean"===e?"boolean":"string"===e?"string":void 0===e?"undefined":e}static getSuggestion(t,e,i){let s,o=Wt.findInOptions(t,e,i,!1),n=Wt.findInOptions(t,Bt,[],!0);s=void 0!==o.indexMatch?" in "+Wt.printLocation(o.path,t,"")+'Perhaps it was incomplete? Did you mean: "'+o.indexMatch+'"?\n\n':n.distance<=4&&o.distance>n.distance?" in "+Wt.printLocation(o.path,t,"")+"Perhaps it was misplaced? Matching option found at: "+Wt.printLocation(n.path,n.closestMatch,""):o.distance<=8?'. Did you mean "'+o.closestMatch+'"?'+Wt.printLocation(o.path,t):". Did you mean one of these: "+Wt.print(Object.keys(e))+Wt.printLocation(i,t),console.log('%cUnknown option detected: "'+t+'"'+s,$t),Yt=!0}static findInOptions(t,e,i,s=!1){let o,n=1e9,r="",a=[],h=t.toLowerCase();for(let l in e){let d;if(void 0!==e[l].__type__&&!0===s){let s=Wt.findInOptions(t,e[l],k.copyAndExtendArray(i,l));n>s.distance&&(r=s.closestMatch,a=s.path,n=s.distance,o=s.indexMatch)}else-1!==l.toLowerCase().indexOf(h)&&(o=l),d=Wt.levenshteinDistance(t,l),n>d&&(r=l,a=k.copyArray(i),n=d)}return{closestMatch:r,path:a,distance:n,indexMatch:o}}static printLocation(t,e,i="Problem value found at: \n"){let s="\n\n"+i+"options = {\n";for(let e=0;e<t.length;e++){for(let t=0;t<e+1;t++)s+="  ";s+=t[e]+": {\n"}for(let e=0;e<t.length+1;e++)s+="  ";s+=e+"\n";for(let e=0;e<t.length+1;e++){for(let i=0;i<t.length-e;i++)s+="  ";s+="}\n"}return s+"\n\n"}static print(t){return JSON.stringify(t).replace(/(\")|(\[)|(\])|(,"__type__")/g,"").replace(/(\,)/g,", ")}static levenshteinDistance(t,e){if(0===t.length)return e.length;if(0===e.length)return t.length;var i,s,o=[];for(i=0;i<=e.length;i++)o[i]=[i];for(s=0;s<=t.length;s++)o[0][s]=s;for(i=1;i<=e.length;i++)for(s=1;s<=t.length;s++)e.charAt(i-1)==t.charAt(s-1)?o[i][s]=o[i-1][s-1]:o[i][s]=Math.min(o[i-1][s-1]+1,Math.min(o[i][s-1]+1,o[i-1][s]+1));return o[e.length][t.length]}}let Vt="string",Ut="boolean",Xt="number",qt="array",Kt="date",Jt="object",Zt="moment",Qt={configure:{enabled:{boolean:Ut},filter:{boolean:Ut,function:"function"},container:{dom:"dom"},__type__:{object:Jt,boolean:Ut,function:"function"}},align:{string:Vt},alignCurrentTime:{string:Vt,undefined:"undefined"},rtl:{boolean:Ut,undefined:"undefined"},rollingMode:{follow:{boolean:Ut},offset:{number:Xt,undefined:"undefined"},__type__:{object:Jt}},onTimeout:{timeoutMs:{number:Xt},callback:{function:"function"},__type__:{object:Jt}},verticalScroll:{boolean:Ut,undefined:"undefined"},horizontalScroll:{boolean:Ut,undefined:"undefined"},autoResize:{boolean:Ut},throttleRedraw:{number:Xt},clickToUse:{boolean:Ut},dataAttributes:{string:Vt,array:qt},editable:{add:{boolean:Ut,undefined:"undefined"},remove:{boolean:Ut,undefined:"undefined"},updateGroup:{boolean:Ut,undefined:"undefined"},updateTime:{boolean:Ut,undefined:"undefined"},overrideItems:{boolean:Ut,undefined:"undefined"},__type__:{boolean:Ut,object:Jt}},end:{number:Xt,date:Kt,string:Vt,moment:Zt},format:{minorLabels:{millisecond:{string:Vt,undefined:"undefined"},second:{string:Vt,undefined:"undefined"},minute:{string:Vt,undefined:"undefined"},hour:{string:Vt,undefined:"undefined"},weekday:{string:Vt,undefined:"undefined"},day:{string:Vt,undefined:"undefined"},week:{string:Vt,undefined:"undefined"},month:{string:Vt,undefined:"undefined"},year:{string:Vt,undefined:"undefined"},__type__:{object:Jt,function:"function"}},majorLabels:{millisecond:{string:Vt,undefined:"undefined"},second:{string:Vt,undefined:"undefined"},minute:{string:Vt,undefined:"undefined"},hour:{string:Vt,undefined:"undefined"},weekday:{string:Vt,undefined:"undefined"},day:{string:Vt,undefined:"undefined"},week:{string:Vt,undefined:"undefined"},month:{string:Vt,undefined:"undefined"},year:{string:Vt,undefined:"undefined"},__type__:{object:Jt,function:"function"}},__type__:{object:Jt}},moment:{function:"function"},groupHeightMode:{string:Vt},groupOrder:{string:Vt,function:"function"},groupEditable:{add:{boolean:Ut,undefined:"undefined"},remove:{boolean:Ut,undefined:"undefined"},order:{boolean:Ut,undefined:"undefined"},__type__:{boolean:Ut,object:Jt}},groupOrderSwap:{function:"function"},height:{string:Vt,number:Xt},hiddenDates:{start:{date:Kt,number:Xt,string:Vt,moment:Zt},end:{date:Kt,number:Xt,string:Vt,moment:Zt},repeat:{string:Vt},__type__:{object:Jt,array:qt}},itemsAlwaysDraggable:{item:{boolean:Ut,undefined:"undefined"},range:{boolean:Ut,undefined:"undefined"},__type__:{boolean:Ut,object:Jt}},limitSize:{boolean:Ut},locale:{string:Vt},locales:{__any__:{any:"any"},__type__:{object:Jt}},longSelectPressTime:{number:Xt},margin:{axis:{number:Xt},item:{horizontal:{number:Xt,undefined:"undefined"},vertical:{number:Xt,undefined:"undefined"},__type__:{object:Jt,number:Xt}},__type__:{object:Jt,number:Xt}},max:{date:Kt,number:Xt,string:Vt,moment:Zt},maxHeight:{number:Xt,string:Vt},maxMinorChars:{number:Xt},min:{date:Kt,number:Xt,string:Vt,moment:Zt},minHeight:{number:Xt,string:Vt},moveable:{boolean:Ut},multiselect:{boolean:Ut},multiselectPerGroup:{boolean:Ut},onAdd:{function:"function"},onDropObjectOnItem:{function:"function"},onUpdate:{function:"function"},onMove:{function:"function"},onMoving:{function:"function"},onRemove:{function:"function"},onAddGroup:{function:"function"},onMoveGroup:{function:"function"},onRemoveGroup:{function:"function"},onInitialDrawComplete:{function:"function"},order:{function:"function"},orientation:{axis:{string:Vt,undefined:"undefined"},item:{string:Vt,undefined:"undefined"},__type__:{string:Vt,object:Jt}},selectable:{boolean:Ut},sequentialSelection:{boolean:Ut},showCurrentTime:{boolean:Ut},showMajorLabels:{boolean:Ut},showMinorLabels:{boolean:Ut},showWeekScale:{boolean:Ut},stack:{boolean:Ut},stackSubgroups:{boolean:Ut},cluster:{maxItems:{number:Xt,undefined:"undefined"},titleTemplate:{string:Vt,undefined:"undefined"},clusterCriteria:{function:"function",undefined:"undefined"},showStipes:{boolean:Ut,undefined:"undefined"},fitOnDoubleClick:{boolean:Ut,undefined:"undefined"},__type__:{boolean:Ut,object:Jt}},snap:{function:"function",null:"null"},start:{date:Kt,number:Xt,string:Vt,moment:Zt},template:{function:"function"},loadingScreenTemplate:{function:"function"},groupTemplate:{function:"function"},visibleFrameTemplate:{string:Vt,function:"function"},showTooltips:{boolean:Ut},tooltip:{followMouse:{boolean:Ut},overflowMethod:{string:["cap","flip","none"]},delay:{number:Xt},template:{function:"function"},__type__:{object:Jt}},tooltipOnItemUpdateTime:{template:{function:"function"},__type__:{boolean:Ut,object:Jt}},timeAxis:{scale:{string:Vt,undefined:"undefined"},step:{number:Xt,undefined:"undefined"},__type__:{object:Jt}},type:{string:Vt},width:{string:Vt,number:Xt},preferZoom:{boolean:Ut},zoomable:{boolean:Ut},zoomKey:{string:["ctrlKey","altKey","shiftKey","metaKey",""]},zoomFriction:{number:Xt},zoomMax:{number:Xt},zoomMin:{number:Xt},xss:{disabled:{boolean:Ut},filterOptions:{__any__:{any:"any"},__type__:{object:Jt}},__type__:{object:Jt}},__type__:{object:Jt}},te={global:{align:["center","left","right"],alignCurrentTime:["none","year","month","quarter","week","isoWeek","day","date","hour","minute","second"],direction:!1,autoResize:!0,clickToUse:!1,editable:{add:!1,remove:!1,updateGroup:!1,updateTime:!1},end:"",format:{minorLabels:{millisecond:"SSS",second:"s",minute:"HH:mm",hour:"HH:mm",weekday:"ddd D",day:"D",week:"w",month:"MMM",year:"YYYY"},majorLabels:{millisecond:"HH:mm:ss",second:"D MMMM HH:mm",minute:"ddd D MMMM",hour:"ddd D MMMM",weekday:"MMMM YYYY",day:"MMMM YYYY",week:"MMMM YYYY",month:"YYYY",year:""}},groupHeightMode:["auto","fixed","fitItems"],groupsDraggable:!1,height:"",locale:"",longSelectPressTime:251,margin:{axis:[20,0,100,1],item:{horizontal:[10,0,100,1],vertical:[10,0,100,1]}},max:"",maxHeight:"",maxMinorChars:[7,0,20,1],min:"",minHeight:"",moveable:!1,multiselect:!1,multiselectPerGroup:!1,orientation:{axis:["both","bottom","top"],item:["bottom","top"]},preferZoom:!1,selectable:!0,showCurrentTime:!1,showMajorLabels:!0,showMinorLabels:!0,stack:!0,stackSubgroups:!0,cluster:!1,start:"",showTooltips:!0,tooltip:{followMouse:!1,overflowMethod:"flip",delay:[500,0,99999,100]},tooltipOnItemUpdateTime:!1,type:["box","point","range","background"],width:"100%",zoomable:!0,zoomKey:["ctrlKey","altKey","shiftKey","metaKey",""],zoomMax:[31536e10,10,31536e10,1],zoomMin:[10,10,31536e10,1],xss:{disabled:!1}}};var ee={black:"#000000",navy:"#000080",darkblue:"#00008B",mediumblue:"#0000CD",blue:"#0000FF",darkgreen:"#006400",green:"#008000",teal:"#008080",darkcyan:"#008B8B",deepskyblue:"#00BFFF",darkturquoise:"#00CED1",mediumspringgreen:"#00FA9A",lime:"#00FF00",springgreen:"#00FF7F",aqua:"#00FFFF",cyan:"#00FFFF",midnightblue:"#191970",dodgerblue:"#1E90FF",lightseagreen:"#20B2AA",forestgreen:"#228B22",seagreen:"#2E8B57",darkslategray:"#2F4F4F",limegreen:"#32CD32",mediumseagreen:"#3CB371",turquoise:"#40E0D0",royalblue:"#4169E1",steelblue:"#4682B4",darkslateblue:"#483D8B",mediumturquoise:"#48D1CC",indigo:"#4B0082",darkolivegreen:"#556B2F",cadetblue:"#5F9EA0",cornflowerblue:"#6495ED",mediumaquamarine:"#66CDAA",dimgray:"#696969",slateblue:"#6A5ACD",olivedrab:"#6B8E23",slategray:"#708090",lightslategray:"#778899",mediumslateblue:"#7B68EE",lawngreen:"#7CFC00",chartreuse:"#7FFF00",aquamarine:"#7FFFD4",maroon:"#800000",purple:"#800080",olive:"#808000",gray:"#808080",skyblue:"#87CEEB",lightskyblue:"#87CEFA",blueviolet:"#8A2BE2",darkred:"#8B0000",darkmagenta:"#8B008B",saddlebrown:"#8B4513",darkseagreen:"#8FBC8F",lightgreen:"#90EE90",mediumpurple:"#9370D8",darkviolet:"#9400D3",palegreen:"#98FB98",darkorchid:"#9932CC",yellowgreen:"#9ACD32",sienna:"#A0522D",brown:"#A52A2A",darkgray:"#A9A9A9",lightblue:"#ADD8E6",greenyellow:"#ADFF2F",paleturquoise:"#AFEEEE",lightsteelblue:"#B0C4DE",powderblue:"#B0E0E6",firebrick:"#B22222",darkgoldenrod:"#B8860B",mediumorchid:"#BA55D3",rosybrown:"#BC8F8F",darkkhaki:"#BDB76B",silver:"#C0C0C0",mediumvioletred:"#C71585",indianred:"#CD5C5C",peru:"#CD853F",chocolate:"#D2691E",tan:"#D2B48C",lightgrey:"#D3D3D3",palevioletred:"#D87093",thistle:"#D8BFD8",orchid:"#DA70D6",goldenrod:"#DAA520",crimson:"#DC143C",gainsboro:"#DCDCDC",plum:"#DDA0DD",burlywood:"#DEB887",lightcyan:"#E0FFFF",lavender:"#E6E6FA",darksalmon:"#E9967A",violet:"#EE82EE",palegoldenrod:"#EEE8AA",lightcoral:"#F08080",khaki:"#F0E68C",aliceblue:"#F0F8FF",honeydew:"#F0FFF0",azure:"#F0FFFF",sandybrown:"#F4A460",wheat:"#F5DEB3",beige:"#F5F5DC",whitesmoke:"#F5F5F5",mintcream:"#F5FFFA",ghostwhite:"#F8F8FF",salmon:"#FA8072",antiquewhite:"#FAEBD7",linen:"#FAF0E6",lightgoldenrodyellow:"#FAFAD2",oldlace:"#FDF5E6",red:"#FF0000",fuchsia:"#FF00FF",magenta:"#FF00FF",deeppink:"#FF1493",orangered:"#FF4500",tomato:"#FF6347",hotpink:"#FF69B4",coral:"#FF7F50",darkorange:"#FF8C00",lightsalmon:"#FFA07A",orange:"#FFA500",lightpink:"#FFB6C1",pink:"#FFC0CB",gold:"#FFD700",peachpuff:"#FFDAB9",navajowhite:"#FFDEAD",moccasin:"#FFE4B5",bisque:"#FFE4C4",mistyrose:"#FFE4E1",blanchedalmond:"#FFEBCD",papayawhip:"#FFEFD5",lavenderblush:"#FFF0F5",seashell:"#FFF5EE",cornsilk:"#FFF8DC",lemonchiffon:"#FFFACD",floralwhite:"#FFFAF0",snow:"#FFFAFA",yellow:"#FFFF00",lightyellow:"#FFFFE0",ivory:"#FFFFF0",white:"#FFFFFF"};class ie{constructor(t=1){this.pixelRatio=t,this.generated=!1,this.centerCoordinates={x:144.5,y:144.5},this.r=289*.49,this.color={r:255,g:255,b:255,a:1},this.hueCircle=void 0,this.initialColor={r:255,g:255,b:255,a:1},this.previousColor=void 0,this.applied=!1,this.updateCallback=()=>{},this.closeCallback=()=>{},this._create()}insertTo(t){void 0!==this.hammer&&(this.hammer.destroy(),this.hammer=void 0),this.container=t,this.container.appendChild(this.frame),this._bindHammer(),this._setSize()}setUpdateCallback(t){if("function"!=typeof t)throw new Error("Function attempted to set as colorPicker update callback is not a function.");this.updateCallback=t}setCloseCallback(t){if("function"!=typeof t)throw new Error("Function attempted to set as colorPicker closing callback is not a function.");this.closeCallback=t}_isColorString(t){if("string"==typeof t)return ee[t]}setColor(t,e=!0){if("none"===t)return;let i;var s=this._isColorString(t);if(void 0!==s&&(t=s),!0===k.isString(t)){if(!0===k.isValidRGB(t)){let e=t.substr(4).substr(0,t.length-5).split(",");i={r:e[0],g:e[1],b:e[2],a:1}}else if(!0===k.isValidRGBA(t)){let e=t.substr(5).substr(0,t.length-6).split(",");i={r:e[0],g:e[1],b:e[2],a:e[3]}}else if(!0===k.isValidHex(t)){let e=k.hexToRGB(t);i={r:e.r,g:e.g,b:e.b,a:1}}}else if(t instanceof Object&&void 0!==t.r&&void 0!==t.g&&void 0!==t.b){let e=void 0!==t.a?t.a:"1.0";i={r:t.r,g:t.g,b:t.b,a:e}}if(void 0===i)throw new Error("Unknown color passed to the colorPicker. Supported are strings: rgb, hex, rgba. Object: rgb ({r:r,g:g,b:b,[a:a]}). Supplied: "+JSON.stringify(t));this._setColor(i,e)}show(){void 0!==this.closeCallback&&(this.closeCallback(),this.closeCallback=void 0),this.applied=!1,this.frame.style.display="block",this._generateHueCircle()}_hide(t=!0){!0===t&&(this.previousColor=k.extend({},this.color)),!0===this.applied&&this.updateCallback(this.initialColor),this.frame.style.display="none",setTimeout((()=>{void 0!==this.closeCallback&&(this.closeCallback(),this.closeCallback=void 0)}),0)}_save(){this.updateCallback(this.color),this.applied=!1,this._hide()}_apply(){this.applied=!0,this.updateCallback(this.color),this._updatePicker(this.color)}_loadLast(){void 0!==this.previousColor?this.setColor(this.previousColor,!1):alert("There is no last color to load...")}_setColor(t,e=!0){!0===e&&(this.initialColor=k.extend({},t)),this.color=t;let i=k.RGBToHSV(t.r,t.g,t.b),s=2*Math.PI,o=this.r*i.s,n=this.centerCoordinates.x+o*Math.sin(s*i.h),r=this.centerCoordinates.y+o*Math.cos(s*i.h);this.colorPickerSelector.style.left=n-.5*this.colorPickerSelector.clientWidth+"px",this.colorPickerSelector.style.top=r-.5*this.colorPickerSelector.clientHeight+"px",this._updatePicker(t)}_setOpacity(t){this.color.a=t/100,this._updatePicker(this.color)}_setBrightness(t){let e=k.RGBToHSV(this.color.r,this.color.g,this.color.b);e.v=t/100;let i=k.HSVToRGB(e.h,e.s,e.v);i.a=this.color.a,this.color=i,this._updatePicker()}_updatePicker(t=this.color){let e=k.RGBToHSV(t.r,t.g,t.b),i=this.colorPickerCanvas.getContext("2d");void 0===this.pixelRation&&(this.pixelRatio=(window.devicePixelRatio||1)/(i.webkitBackingStorePixelRatio||i.mozBackingStorePixelRatio||i.msBackingStorePixelRatio||i.oBackingStorePixelRatio||i.backingStorePixelRatio||1)),i.setTransform(this.pixelRatio,0,0,this.pixelRatio,0,0);let s=this.colorPickerCanvas.clientWidth,o=this.colorPickerCanvas.clientHeight;i.clearRect(0,0,s,o),i.putImageData(this.hueCircle,0,0),i.fillStyle="rgba(0,0,0,"+(1-e.v)+")",i.circle(this.centerCoordinates.x,this.centerCoordinates.y,this.r),i.fill(),this.brightnessRange.value=100*e.v,this.opacityRange.value=100*t.a,this.initialColorDiv.style.backgroundColor="rgba("+this.initialColor.r+","+this.initialColor.g+","+this.initialColor.b+","+this.initialColor.a+")",this.newColorDiv.style.backgroundColor="rgba("+this.color.r+","+this.color.g+","+this.color.b+","+this.color.a+")"}_setSize(){this.colorPickerCanvas.style.width="100%",this.colorPickerCanvas.style.height="100%",this.colorPickerCanvas.width=289*this.pixelRatio,this.colorPickerCanvas.height=289*this.pixelRatio}_create(){if(this.frame=document.createElement("div"),this.frame.className="vis-color-picker",this.colorPickerDiv=document.createElement("div"),this.colorPickerSelector=document.createElement("div"),this.colorPickerSelector.className="vis-selector",this.colorPickerDiv.appendChild(this.colorPickerSelector),this.colorPickerCanvas=document.createElement("canvas"),this.colorPickerDiv.appendChild(this.colorPickerCanvas),this.colorPickerCanvas.getContext){let t=this.colorPickerCanvas.getContext("2d");this.pixelRatio=(window.devicePixelRatio||1)/(t.webkitBackingStorePixelRatio||t.mozBackingStorePixelRatio||t.msBackingStorePixelRatio||t.oBackingStorePixelRatio||t.backingStorePixelRatio||1),this.colorPickerCanvas.getContext("2d").setTransform(this.pixelRatio,0,0,this.pixelRatio,0,0)}else{let t=document.createElement("DIV");t.style.color="red",t.style.fontWeight="bold",t.style.padding="10px",t.innerHTML="Error: your browser does not support HTML canvas",this.colorPickerCanvas.appendChild(t)}this.colorPickerDiv.className="vis-color",this.opacityDiv=document.createElement("div"),this.opacityDiv.className="vis-opacity",this.brightnessDiv=document.createElement("div"),this.brightnessDiv.className="vis-brightness",this.arrowDiv=document.createElement("div"),this.arrowDiv.className="vis-arrow",this.opacityRange=document.createElement("input");try{this.opacityRange.type="range",this.opacityRange.min="0",this.opacityRange.max="100"}catch(t){}this.opacityRange.value="100",this.opacityRange.className="vis-range",this.brightnessRange=document.createElement("input");try{this.brightnessRange.type="range",this.brightnessRange.min="0",this.brightnessRange.max="100"}catch(t){}this.brightnessRange.value="100",this.brightnessRange.className="vis-range",this.opacityDiv.appendChild(this.opacityRange),this.brightnessDiv.appendChild(this.brightnessRange);var t=this;this.opacityRange.onchange=function(){t._setOpacity(this.value)},this.opacityRange.oninput=function(){t._setOpacity(this.value)},this.brightnessRange.onchange=function(){t._setBrightness(this.value)},this.brightnessRange.oninput=function(){t._setBrightness(this.value)},this.brightnessLabel=document.createElement("div"),this.brightnessLabel.className="vis-label vis-brightness",this.brightnessLabel.innerHTML="brightness:",this.opacityLabel=document.createElement("div"),this.opacityLabel.className="vis-label vis-opacity",this.opacityLabel.innerHTML="opacity:",this.newColorDiv=document.createElement("div"),this.newColorDiv.className="vis-new-color",this.newColorDiv.innerHTML="new",this.initialColorDiv=document.createElement("div"),this.initialColorDiv.className="vis-initial-color",this.initialColorDiv.innerHTML="initial",this.cancelButton=document.createElement("div"),this.cancelButton.className="vis-button vis-cancel",this.cancelButton.innerHTML="cancel",this.cancelButton.onclick=this._hide.bind(this,!1),this.applyButton=document.createElement("div"),this.applyButton.className="vis-button vis-apply",this.applyButton.innerHTML="apply",this.applyButton.onclick=this._apply.bind(this),this.saveButton=document.createElement("div"),this.saveButton.className="vis-button vis-save",this.saveButton.innerHTML="save",this.saveButton.onclick=this._save.bind(this),this.loadButton=document.createElement("div"),this.loadButton.className="vis-button vis-load",this.loadButton.innerHTML="load last",this.loadButton.onclick=this._loadLast.bind(this),this.frame.appendChild(this.colorPickerDiv),this.frame.appendChild(this.arrowDiv),this.frame.appendChild(this.brightnessLabel),this.frame.appendChild(this.brightnessDiv),this.frame.appendChild(this.opacityLabel),this.frame.appendChild(this.opacityDiv),this.frame.appendChild(this.newColorDiv),this.frame.appendChild(this.initialColorDiv),this.frame.appendChild(this.cancelButton),this.frame.appendChild(this.applyButton),this.frame.appendChild(this.saveButton),this.frame.appendChild(this.loadButton)}_bindHammer(){this.drag={},this.pinch={},this.hammer=new W(this.colorPickerCanvas),this.hammer.get("pinch").set({enable:!0}),V(this.hammer,(t=>{this._moveSelector(t)})),this.hammer.on("tap",(t=>{this._moveSelector(t)})),this.hammer.on("panstart",(t=>{this._moveSelector(t)})),this.hammer.on("panmove",(t=>{this._moveSelector(t)})),this.hammer.on("panend",(t=>{this._moveSelector(t)}))}_generateHueCircle(){if(!1===this.generated){let t=this.colorPickerCanvas.getContext("2d");void 0===this.pixelRation&&(this.pixelRatio=(window.devicePixelRatio||1)/(t.webkitBackingStorePixelRatio||t.mozBackingStorePixelRatio||t.msBackingStorePixelRatio||t.oBackingStorePixelRatio||t.backingStorePixelRatio||1)),t.setTransform(this.pixelRatio,0,0,this.pixelRatio,0,0);let e,i,s,o,n=this.colorPickerCanvas.clientWidth,r=this.colorPickerCanvas.clientHeight;t.clearRect(0,0,n,r),this.centerCoordinates={x:.5*n,y:.5*r},this.r=.49*n;let a,h=2*Math.PI/360,l=1/360,d=1/this.r;for(s=0;s<360;s++)for(o=0;o<this.r;o++)e=this.centerCoordinates.x+o*Math.sin(h*s),i=this.centerCoordinates.y+o*Math.cos(h*s),a=k.HSVToRGB(s*l,o*d,1),t.fillStyle="rgb("+a.r+","+a.g+","+a.b+")",t.fillRect(e-.5,i-.5,2,2);t.strokeStyle="rgba(0,0,0,1)",t.circle(this.centerCoordinates.x,this.centerCoordinates.y,this.r),t.stroke(),this.hueCircle=t.getImageData(0,0,n,r)}this.generated=!0}_moveSelector(t){let e=this.colorPickerDiv.getBoundingClientRect(),i=t.center.x-e.left,s=t.center.y-e.top,o=.5*this.colorPickerDiv.clientHeight,n=.5*this.colorPickerDiv.clientWidth,r=i-n,a=s-o,h=Math.atan2(r,a),l=.98*Math.min(Math.sqrt(r*r+a*a),n),d=Math.cos(h)*l+o,p=Math.sin(h)*l+n;this.colorPickerSelector.style.top=d-.5*this.colorPickerSelector.clientHeight+"px",this.colorPickerSelector.style.left=p-.5*this.colorPickerSelector.clientWidth+"px";let m=h/(2*Math.PI);m=m<0?m+1:m;let c=l/this.r,u=k.RGBToHSV(this.color.r,this.color.g,this.color.b);u.h=m,u.s=c;let g=k.HSVToRGB(u.h,u.s,u.v);g.a=this.color.a,this.color=g,this.initialColorDiv.style.backgroundColor="rgba("+this.initialColor.r+","+this.initialColor.g+","+this.initialColor.b+","+this.initialColor.a+")",this.newColorDiv.style.backgroundColor="rgba("+this.color.r+","+this.color.g+","+this.color.b+","+this.color.a+")"}}class se{constructor(t,e,i,s=1){this.parent=t,this.changedOptions=[],this.container=e,this.allowCreation=!1,this.options={},this.initialized=!1,this.popupCounter=0,this.defaultOptions={enabled:!1,filter:!0,container:void 0,showButton:!0},k.extend(this.options,this.defaultOptions),this.configureOptions=i,this.moduleOptions={},this.domElements=[],this.popupDiv={},this.popupLimit=5,this.popupHistory={},this.colorPicker=new ie(s),this.wrapper=void 0}setOptions(t){if(void 0!==t){this.popupHistory={},this._removePopup();let e=!0;if("string"==typeof t)this.options.filter=t;else if(Array.isArray(t))this.options.filter=t.join();else if("object"==typeof t){if(null==t)throw new TypeError("options cannot be null");void 0!==t.container&&(this.options.container=t.container),void 0!==t.filter&&(this.options.filter=t.filter),void 0!==t.showButton&&(this.options.showButton=t.showButton),void 0!==t.enabled&&(e=t.enabled)}else"boolean"==typeof t?(this.options.filter=!0,e=t):"function"==typeof t&&(this.options.filter=t,e=!0);!1===this.options.filter&&(e=!1),this.options.enabled=e}this._clean()}setModuleOptions(t){this.moduleOptions=t,!0===this.options.enabled&&(this._clean(),void 0!==this.options.container&&(this.container=this.options.container),this._create())}_create(){this._clean(),this.changedOptions=[];let t=this.options.filter,e=0,i=!1;for(let s in this.configureOptions)this.configureOptions.hasOwnProperty(s)&&(this.allowCreation=!1,i=!1,"function"==typeof t?(i=t(s,[]),i=i||this._handleObject(this.configureOptions[s],[s],!0)):!0!==t&&-1===t.indexOf(s)||(i=!0),!1!==i&&(this.allowCreation=!0,e>0&&this._makeItem([]),this._makeHeader(s),this._handleObject(this.configureOptions[s],[s])),e++);this._makeButton(),this._push()}_push(){this.wrapper=document.createElement("div"),this.wrapper.className="vis-configuration-wrapper",this.container.appendChild(this.wrapper);for(var t=0;t<this.domElements.length;t++)this.wrapper.appendChild(this.domElements[t]);this._showPopupIfNeeded()}_clean(){for(var t=0;t<this.domElements.length;t++)this.wrapper.removeChild(this.domElements[t]);void 0!==this.wrapper&&(this.container.removeChild(this.wrapper),this.wrapper=void 0),this.domElements=[],this._removePopup()}_getValue(t){let e=this.moduleOptions;for(let i=0;i<t.length;i++){if(void 0===e[t[i]]){e=void 0;break}e=e[t[i]]}return e}_makeItem(t,...e){if(!0===this.allowCreation){let i=document.createElement("div");return i.className="vis-configuration vis-config-item vis-config-s"+t.length,e.forEach((t=>{i.appendChild(t)})),this.domElements.push(i),this.domElements.length}return 0}_makeHeader(t){let e=document.createElement("div");e.className="vis-configuration vis-config-header",e.innerHTML=k.xss(t),this._makeItem([],e)}_makeLabel(t,e,i=!1){let s=document.createElement("div");return s.className="vis-configuration vis-config-label vis-config-s"+e.length,s.innerHTML=!0===i?k.xss("<i><b>"+t+":</b></i>"):k.xss(t+":"),s}_makeDropdown(t,e,i){let s=document.createElement("select");s.className="vis-configuration vis-config-select";let o=0;void 0!==e&&-1!==t.indexOf(e)&&(o=t.indexOf(e));for(let e=0;e<t.length;e++){let i=document.createElement("option");i.value=t[e],e===o&&(i.selected="selected"),i.innerHTML=t[e],s.appendChild(i)}let n=this;s.onchange=function(){n._update(this.value,i)};let r=this._makeLabel(i[i.length-1],i);this._makeItem(i,r,s)}_makeRange(t,e,i){let s=t[0],o=t[1],n=t[2],r=t[3],a=document.createElement("input");a.className="vis-configuration vis-config-range";try{a.type="range",a.min=o,a.max=n}catch(t){}a.step=r;let h="",l=0;if(void 0!==e){let t=1.2;e<0&&e*t<o?(a.min=Math.ceil(e*t),l=a.min,h="range increased"):e/t<o&&(a.min=Math.ceil(e/t),l=a.min,h="range increased"),e*t>n&&1!==n&&(a.max=Math.ceil(e*t),l=a.max,h="range increased"),a.value=e}else a.value=s;let d=document.createElement("input");d.className="vis-configuration vis-config-rangeinput",d.value=Number(a.value);var p=this;a.onchange=function(){d.value=this.value,p._update(Number(this.value),i)},a.oninput=function(){d.value=this.value};let m=this._makeLabel(i[i.length-1],i),c=this._makeItem(i,m,a,d);""!==h&&this.popupHistory[c]!==l&&(this.popupHistory[c]=l,this._setupPopup(h,c))}_makeButton(){if(!0===this.options.showButton){let t=document.createElement("div");t.className="vis-configuration vis-config-button",t.innerHTML="generate options",t.onclick=()=>{this._printOptions()},t.onmouseover=()=>{t.className="vis-configuration vis-config-button hover"},t.onmouseout=()=>{t.className="vis-configuration vis-config-button"},this.optionsContainer=document.createElement("div"),this.optionsContainer.className="vis-configuration vis-config-option-container",this.domElements.push(this.optionsContainer),this.domElements.push(t)}}_setupPopup(t,e){if(!0===this.initialized&&!0===this.allowCreation&&this.popupCounter<this.popupLimit){let i=document.createElement("div");i.id="vis-configuration-popup",i.className="vis-configuration-popup",i.innerHTML=k.xss(t),i.onclick=()=>{this._removePopup()},this.popupCounter+=1,this.popupDiv={html:i,index:e}}}_removePopup(){void 0!==this.popupDiv.html&&(this.popupDiv.html.parentNode.removeChild(this.popupDiv.html),clearTimeout(this.popupDiv.hideTimeout),clearTimeout(this.popupDiv.deleteTimeout),this.popupDiv={})}_showPopupIfNeeded(){if(void 0!==this.popupDiv.html){let t=this.domElements[this.popupDiv.index].getBoundingClientRect();this.popupDiv.html.style.left=t.left+"px",this.popupDiv.html.style.top=t.top-30+"px",document.body.appendChild(this.popupDiv.html),this.popupDiv.hideTimeout=setTimeout((()=>{this.popupDiv.html.style.opacity=0}),1500),this.popupDiv.deleteTimeout=setTimeout((()=>{this._removePopup()}),1800)}}_makeCheckbox(t,e,i){var s=document.createElement("input");s.type="checkbox",s.className="vis-configuration vis-config-checkbox",s.checked=t,void 0!==e&&(s.checked=e,e!==t&&("object"==typeof t?e!==t.enabled&&this.changedOptions.push({path:i,value:e}):this.changedOptions.push({path:i,value:e})));let o=this;s.onchange=function(){o._update(this.checked,i)};let n=this._makeLabel(i[i.length-1],i);this._makeItem(i,n,s)}_makeTextInput(t,e,i){var s=document.createElement("input");s.type="text",s.className="vis-configuration vis-config-text",s.value=e,e!==t&&this.changedOptions.push({path:i,value:e});let o=this;s.onchange=function(){o._update(this.value,i)};let n=this._makeLabel(i[i.length-1],i);this._makeItem(i,n,s)}_makeColorField(t,e,i){let s=t[1],o=document.createElement("div");"none"!==(e=void 0===e?s:e)?(o.className="vis-configuration vis-config-colorBlock",o.style.backgroundColor=e):o.className="vis-configuration vis-config-colorBlock none",e=void 0===e?s:e,o.onclick=()=>{this._showColorPicker(e,o,i)};let n=this._makeLabel(i[i.length-1],i);this._makeItem(i,n,o)}_showColorPicker(t,e,i){e.onclick=function(){},this.colorPicker.insertTo(e),this.colorPicker.show(),this.colorPicker.setColor(t),this.colorPicker.setUpdateCallback((t=>{let s="rgba("+t.r+","+t.g+","+t.b+","+t.a+")";e.style.backgroundColor=s,this._update(s,i)})),this.colorPicker.setCloseCallback((()=>{e.onclick=()=>{this._showColorPicker(t,e,i)}}))}_handleObject(t,e=[],i=!1){let s=!1,o=this.options.filter,n=!1;for(let r in t)if(t.hasOwnProperty(r)){s=!0;let a=t[r],h=k.copyAndExtendArray(e,r);if("function"==typeof o&&(s=o(r,e),!1===s&&!Array.isArray(a)&&"string"!=typeof a&&"boolean"!=typeof a&&a instanceof Object&&(this.allowCreation=!1,s=this._handleObject(a,h,!0),this.allowCreation=!1===i)),!1!==s){n=!0;let t=this._getValue(h);if(Array.isArray(a))this._handleArray(a,t,h);else if("string"==typeof a)this._makeTextInput(a,t,h);else if("boolean"==typeof a)this._makeCheckbox(a,t,h);else if(a instanceof Object){let t=!0;if(-1!==e.indexOf("physics")&&this.moduleOptions.physics.solver!==r&&(t=!1),!0===t)if(void 0!==a.enabled){let t=k.copyAndExtendArray(h,"enabled"),e=this._getValue(t);if(!0===e){let t=this._makeLabel(r,h,!0);this._makeItem(h,t),n=this._handleObject(a,h)||n}else this._makeCheckbox(a,e,h)}else{let t=this._makeLabel(r,h,!0);this._makeItem(h,t),n=this._handleObject(a,h)||n}}else console.error("dont know how to handle",a,r,h)}}return n}_handleArray(t,e,i){"string"==typeof t[0]&&"color"===t[0]?(this._makeColorField(t,e,i),t[1]!==e&&this.changedOptions.push({path:i,value:e})):"string"==typeof t[0]?(this._makeDropdown(t,e,i),t[0]!==e&&this.changedOptions.push({path:i,value:e})):"number"==typeof t[0]&&(this._makeRange(t,e,i),t[0]!==e&&this.changedOptions.push({path:i,value:Number(e)}))}_update(t,e){let i=this._constructOptions(t,e);this.parent.body&&this.parent.body.emitter&&this.parent.body.emitter.emit&&this.parent.body.emitter.emit("configChange",i),this.initialized=!0,this.parent.setOptions(i)}_constructOptions(t,e,i={}){let s=i;t="false"!==(t="true"===t||t)&&t;for(let i=0;i<e.length;i++)"global"!==e[i]&&(void 0===s[e[i]]&&(s[e[i]]={}),i!==e.length-1?s=s[e[i]]:s[e[i]]=t);return i}_printOptions(){let t=this.getOptions();this.optionsContainer.innerHTML="<pre>var options = "+JSON.stringify(t,null,2)+"</pre>"}getOptions(){let t={};for(var e=0;e<this.changedOptions.length;e++)this._constructOptions(this.changedOptions[e].value,this.changedOptions[e].path,t);return t}}class oe extends ct{constructor(t,e,i,s){if(super(),this.initTime=new Date,this.itemsDone=!1,!(this instanceof oe))throw new SyntaxError("Constructor must be called with the new operator");if(!Array.isArray(i)&&!y(i)&&i instanceof Object){const t=s;s=i,i=t}s&&s.throttleRedraw&&console.warn('Timeline option "throttleRedraw" is DEPRICATED and no longer supported. It will be removed in the next MAJOR release.');const o=this;if(this.defaultOptions={autoResize:!0,longSelectPressTime:251,orientation:{axis:"bottom",item:"bottom"},moment:b},this.options=k.deepExtend({},this.defaultOptions),s&&k.setupXSSProtection(s.xss),this._create(t),!s||s&&void 0===s.rtl){let t;this.dom.root.style.visibility="hidden";let e=this.dom.root;for(;!t&&e;)t=window.getComputedStyle(e,null).direction,e=e.parentElement;this.options.rtl=t&&"rtl"==t.toLowerCase()}else this.options.rtl=s.rtl;s&&(s.rollingMode&&(this.options.rollingMode=s.rollingMode),s.onInitialDrawComplete&&(this.options.onInitialDrawComplete=s.onInitialDrawComplete),s.onTimeout&&(this.options.onTimeout=s.onTimeout),s.loadingScreenTemplate&&(this.options.loadingScreenTemplate=s.loadingScreenTemplate));const n=document.createElement("div");if(this.options.loadingScreenTemplate){const t=this.options.loadingScreenTemplate.bind(this),e=t(this.dom.loadingScreen);e instanceof Object&&!(e instanceof Element)?t(n):e instanceof Element?(n.innerHTML="",n.appendChild(e)):null!=e&&(n.innerHTML=k.xss(e))}function r(t,e){o.hasListeners(t)&&o.emit(t,o.getEventProperties(e))}this.dom.loadingScreen.appendChild(n),this.components=[],this.body={dom:this.dom,domProps:this.props,emitter:{on:this.on.bind(this),off:this.off.bind(this),emit:this.emit.bind(this)},hiddenDates:[],util:{getScale:()=>o.timeAxis.step.scale,getStep:()=>o.timeAxis.step.step,toScreen:o._toScreen.bind(o),toGlobalScreen:o._toGlobalScreen.bind(o),toTime:o._toTime.bind(o),toGlobalTime:o._toGlobalTime.bind(o)}},this.range=new B(this.body,this.options),this.components.push(this.range),this.body.range=this.range,this.timeAxis=new X(this.body,this.options),this.timeAxis2=null,this.components.push(this.timeAxis),this.currentTime=new ut(this.body,this.options),this.components.push(this.currentTime),this.itemSet=new jt(this.body,this.options),this.components.push(this.itemSet),this.itemsData=null,this.groupsData=null,this.dom.root.onclick=t=>{r("click",t)},this.dom.root.ondblclick=t=>{r("doubleClick",t)},this.dom.root.oncontextmenu=t=>{r("contextmenu",t)},this.dom.root.onmouseover=t=>{r("mouseOver",t)},window.PointerEvent?(this.dom.root.onpointerdown=t=>{r("mouseDown",t)},this.dom.root.onpointermove=t=>{r("mouseMove",t)},this.dom.root.onpointerup=t=>{r("mouseUp",t)}):(this.dom.root.onmousemove=t=>{r("mouseMove",t)},this.dom.root.onmousedown=t=>{r("mouseDown",t)},this.dom.root.onmouseup=t=>{r("mouseUp",t)}),this.initialFitDone=!1,this.on("changed",(()=>{if(null!=o.itemsData){if(!o.initialFitDone&&!o.options.rollingMode)if(o.initialFitDone=!0,null!=o.options.start||null!=o.options.end){if(null==o.options.start||null==o.options.end)var t=o.getItemRange();const e=null!=o.options.start?o.options.start:t.min,i=null!=o.options.end?o.options.end:t.max;o.setWindow(e,i,{animation:!1})}else o.fit({animation:!1});o.initialDrawDone||!o.initialRangeChangeDone&&(o.options.start||o.options.end)&&!o.options.rollingMode||(o.initialDrawDone=!0,o.itemSet.initialDrawDone=!0,o.dom.root.style.visibility="visible",o.dom.loadingScreen.parentNode.removeChild(o.dom.loadingScreen),o.options.onInitialDrawComplete&&setTimeout((()=>o.options.onInitialDrawComplete()),0))}})),this.on("destroyTimeline",(()=>{o.destroy()})),s&&this.setOptions(s),this.body.emitter.on("fit",(t=>{this._onFit(t),this.redraw()})),i&&this.setGroups(i),e&&this.setItems(e),this._redraw()}_createConfigurator(){return new se(this,this.dom.container,te)}redraw(){this.itemSet&&this.itemSet.markDirty({refreshItems:!0}),this._redraw()}setOptions(t){if(!0===Wt.validate(t,Qt)&&console.log("%cErrors have been found in the supplied options object.",$t),ct.prototype.setOptions.call(this,t),"type"in t&&t.type!==this.options.type){this.options.type=t.type;const e=this.itemsData;if(e){const t=this.getSelection();this.setItems(null),this.setItems(e.rawDS),this.setSelection(t)}}}setItems(t){let e;this.itemsDone=!1,e=t?y(t)?x(t):x(new a(t)):null,this.itemsData&&this.itemsData.dispose(),this.itemsData=e,this.itemSet&&this.itemSet.setItems(null!=e?e.rawDS:null)}setGroups(t){let e;const i=t=>!1!==t.visible;t?(Array.isArray(t)&&(t=new a(t)),e=new l(t,{filter:i})):e=null,null!=this.groupsData&&"function"==typeof this.groupsData.setData&&this.groupsData.setData(null),this.groupsData=e,this.itemSet.setGroups(e)}setData(t){t&&t.groups&&this.setGroups(t.groups),t&&t.items&&this.setItems(t.items)}setSelection(t,e){this.itemSet&&this.itemSet.setSelection(t),e&&e.focus&&this.focus(t,e)}getSelection(){return this.itemSet&&this.itemSet.getSelection()||[]}focus(t,e){if(!this.itemsData||null==t)return;const i=Array.isArray(t)?t:[t],s=this.itemsData.get(i);let o=null,n=null;if(s.forEach((t=>{const e=t.start.valueOf(),i="end"in t?t.end.valueOf():t.start.valueOf();(null===o||e<o)&&(o=e),(null===n||i>n)&&(n=i)})),null!==o&&null!==n){const t=this,s=this.itemSet.items[i[0]];let r=-1*this._getScrollTop(),a=null;const h=(e,i,o)=>{const n=ae(t,s);if(!1===n)return;if(a||(a=n),a.itemTop==n.itemTop&&!a.shouldScroll)return;a.itemTop!=n.itemTop&&n.shouldScroll&&(a=n,r=-1*t._getScrollTop());const h=r,l=a.scrollOffset,d=o?l:h+(l-h)*e;t._setScrollTop(-d),i||t._redraw()},l=()=>{const e=ae(t,s);e.shouldScroll&&e.itemTop!=a.itemTop&&(t._setScrollTop(-e.scrollOffset),t._redraw())},d=()=>{l(),setTimeout(l,100)},p=!e||void 0===e.zoom||e.zoom,m=(o+n)/2,c=p?1.1*(n-o):Math.max(this.range.end-this.range.start,1.1*(n-o)),u=!e||void 0===e.animation||e.animation;u||(a={shouldScroll:!1,scrollOffset:-1,itemTop:-1}),this.range.setRange(m-c/2,m+c/2,{animation:u},d,h)}}fit(t,e){const i=!t||void 0===t.animation||t.animation;let s;1===this.itemsData.length&&void 0===this.itemsData.get()[0].end?(s=this.getDataRange(),this.moveTo(s.min.valueOf(),{animation:i},e)):(s=this.getItemRange(),this.range.setRange(s.min,s.max,{animation:i},e))}getItemRange(){const t=this.getDataRange();let e=null!==t.min?t.min.valueOf():null,i=null!==t.max?t.max.valueOf():null,s=null,o=null;if(null!=e&&null!=i){let t=i-e;t<=0&&(t=10);const n=t/this.props.center.width,r={};let a=0;k.forEach(this.itemSet.items,((t,e)=>{if(t.groupShowing){const i=!0;r[e]=t.redraw(i),a=r[e].length}}));if(a>0)for(let t=0;t<a;t++)k.forEach(r,(e=>{e[t]()}));if(k.forEach(this.itemSet.items,(t=>{const r=ne(t),a=re(t);let h,l;this.options.rtl?(h=r-(t.getWidthRight()+10)*n,l=a+(t.getWidthLeft()+10)*n):(h=r-(t.getWidthLeft()+10)*n,l=a+(t.getWidthRight()+10)*n),h<e&&(e=h,s=t),l>i&&(i=l,o=t)})),s&&o){const n=s.getWidthLeft()+10,r=o.getWidthRight()+10,a=this.props.center.width-n-r;a>0&&(this.options.rtl?(e=ne(s)-r*t/a,i=re(o)+n*t/a):(e=ne(s)-n*t/a,i=re(o)+r*t/a))}}return{min:null!=e?new Date(e):null,max:null!=i?new Date(i):null}}getDataRange(){let t=null,e=null;return this.itemsData&&this.itemsData.forEach((i=>{const s=k.convert(i.start,"Date").valueOf(),o=k.convert(null!=i.end?i.end:i.start,"Date").valueOf();(null===t||s<t)&&(t=s),(null===e||o>e)&&(e=o)})),{min:null!=t?new Date(t):null,max:null!=e?new Date(e):null}}getEventProperties(t){const e=t.center?t.center.x:t.clientX,i=t.center?t.center.y:t.clientY,s=this.dom.centerContainer.getBoundingClientRect(),o=this.options.rtl?s.right-e:e-s.left,n=i-s.top,r=this.itemSet.itemFromTarget(t),a=this.itemSet.groupFromTarget(t),h=mt.customTimeFromTarget(t),l=this.itemSet.options.snap||null,d=this.body.util.getScale(),p=this.body.util.getStep(),m=this._toTime(o),c=l?l(m,d,p):m,u=k.getTarget(t);let g=null;return null!=r?g="item":null!=h?g="custom-time":k.hasParent(u,this.timeAxis.dom.foreground)||this.timeAxis2&&k.hasParent(u,this.timeAxis2.dom.foreground)?g="axis":k.hasParent(u,this.itemSet.dom.labelSet)?g="group-label":k.hasParent(u,this.currentTime.bar)?g="current-time":k.hasParent(u,this.dom.center)&&(g="background"),{event:t,item:r?r.id:null,isCluster:!!r&&!!r.isCluster,items:r?r.items||[]:null,group:a?a.groupId:null,customTime:h?h.options.id:null,what:g,pageX:t.srcEvent?t.srcEvent.pageX:t.pageX,pageY:t.srcEvent?t.srcEvent.pageY:t.pageY,x:o,y:n,time:m,snappedTime:c}}toggleRollingMode(){this.range.rolling?this.range.stopRolling():(null==this.options.rollingMode&&this.setOptions(this.options),this.range.startRolling())}_redraw(){ct.prototype._redraw.call(this)}_onFit(t){const{start:e,end:i,animation:s}=t;i?this.range.setRange(e,i,{animation:s}):this.moveTo(e.valueOf(),{animation:s})}}function ne(t){return k.convert(t.data.start,"Date").valueOf()}function re(t){const e=null!=t.data.end?t.data.end:t.data.start;return k.convert(e,"Date").valueOf()}function ae(t,e){if(!e.parent)return!1;const i=t.options.rtl?t.props.rightContainer.height:t.props.leftContainer.height,s=t.props.center.height,o=e.parent;let n=o.top,r=!0;const a=t.timeAxis.options.orientation.axis,h=()=>"bottom"==a?o.height-e.top-e.height:e.top,l=-1*t._getScrollTop(),d=n+h(),p=e.height;return d<l?n+i<=n+h()+p&&(n+=h()-t.itemSet.options.margin.item.vertical):d+p>l+i?n+=h()+p-i+t.itemSet.options.margin.item.vertical:r=!1,n=Math.min(n,s-i),{shouldScroll:r,scrollOffset:n,itemTop:d}}function he(t){for(var e in t)t.hasOwnProperty(e)&&(t[e].redundant=t[e].used,t[e].used=[])}function le(t){for(var e in t)if(t.hasOwnProperty(e)&&t[e].redundant){for(var i=0;i<t[e].redundant.length;i++)t[e].redundant[i].parentNode.removeChild(t[e].redundant[i]);t[e].redundant=[]}}function de(t,e,i){var s;return e.hasOwnProperty(t)?e[t].redundant.length>0?(s=e[t].redundant[0],e[t].redundant.shift()):(s=document.createElementNS("http://www.w3.org/2000/svg",t),i.appendChild(s)):(s=document.createElementNS("http://www.w3.org/2000/svg",t),e[t]={used:[],redundant:[]},i.appendChild(s)),e[t].used.push(s),s}function pe(t,e,i,s){var o;return e.hasOwnProperty(t)?e[t].redundant.length>0?(o=e[t].redundant[0],e[t].redundant.shift()):(o=document.createElement(t),void 0!==s?i.insertBefore(o,s):i.appendChild(o)):(o=document.createElement(t),e[t]={used:[],redundant:[]},void 0!==s?i.insertBefore(o,s):i.appendChild(o)),e[t].used.push(o),o}function me(t,e,i,s,o,n){var r;if("circle"==i.style?((r=de("circle",s,o)).setAttributeNS(null,"cx",t),r.setAttributeNS(null,"cy",e),r.setAttributeNS(null,"r",.5*i.size)):((r=de("rect",s,o)).setAttributeNS(null,"x",t-.5*i.size),r.setAttributeNS(null,"y",e-.5*i.size),r.setAttributeNS(null,"width",i.size),r.setAttributeNS(null,"height",i.size)),void 0!==i.styles&&r.setAttributeNS(null,"style",i.styles),r.setAttributeNS(null,"class",i.className+" vis-point"),n){var a=de("text",s,o);n.xOffset&&(t+=n.xOffset),n.yOffset&&(e+=n.yOffset),n.content&&(a.textContent=n.content),n.className&&a.setAttributeNS(null,"class",n.className+" vis-label"),a.setAttributeNS(null,"x",t),a.setAttributeNS(null,"y",e)}return r}function ce(t,e,i,s,o,n,r,a){if(0!=s){s<0&&(e-=s*=-1);var h=de("rect",n,r);h.setAttributeNS(null,"x",t-.5*i),h.setAttributeNS(null,"y",e),h.setAttributeNS(null,"width",i),h.setAttributeNS(null,"height",s),h.setAttributeNS(null,"class",o),a&&h.setAttributeNS(null,"style",a)}}class ue{constructor(t,e,i,s,o,n,r=!1,a=!1){if(this.majorSteps=[1,2,5,10],this.minorSteps=[.25,.5,1,2],this.customLines=null,this.containerHeight=o,this.majorCharHeight=n,this._start=t,this._end=e,this.scale=1,this.minorStepIdx=-1,this.magnitudefactor=1,this.determineScale(),this.zeroAlign=r,this.autoScaleStart=i,this.autoScaleEnd=s,this.formattingFunction=a,i||s){const t=this,e=e=>{const i=e-e%(t.magnitudefactor*t.minorSteps[t.minorStepIdx]);return e%(t.magnitudefactor*t.minorSteps[t.minorStepIdx])>t.magnitudefactor*t.minorSteps[t.minorStepIdx]*.5?i+t.magnitudefactor*t.minorSteps[t.minorStepIdx]:i};i&&(this._start-=2*this.magnitudefactor*this.minorSteps[this.minorStepIdx],this._start=e(this._start)),s&&(this._end+=this.magnitudefactor*this.minorSteps[this.minorStepIdx],this._end=e(this._end)),this.determineScale()}}setCharHeight(t){this.majorCharHeight=t}setHeight(t){this.containerHeight=t}determineScale(){const t=this._end-this._start;this.scale=this.containerHeight/t;const e=this.majorCharHeight/this.scale,i=t>0?Math.round(Math.log(t)/Math.LN10):0;this.minorStepIdx=-1,this.magnitudefactor=Math.pow(10,i);let s=0;i<0&&(s=i);let o=!1;for(let t=s;Math.abs(t)<=Math.abs(i);t++){this.magnitudefactor=Math.pow(10,t);for(let t=0;t<this.minorSteps.length;t++){if(this.magnitudefactor*this.minorSteps[t]>=e){o=!0,this.minorStepIdx=t;break}}if(!0===o)break}}is_major(t){return t%(this.magnitudefactor*this.majorSteps[this.minorStepIdx])==0}getStep(){return this.magnitudefactor*this.minorSteps[this.minorStepIdx]}getFirstMajor(){const t=this.magnitudefactor*this.majorSteps[this.minorStepIdx];return this.convertValue(this._start+(t-this._start%t)%t)}formatValue(t){let e=t.toPrecision(5);return"function"==typeof this.formattingFunction&&(e=this.formattingFunction(t)),"number"==typeof e?`${e}`:"string"==typeof e?e:t.toPrecision(5)}getLines(){const t=[],e=this.getStep(),i=(e-this._start%e)%e;for(let s=this._start+i;this._end-s>1e-5;s+=e)s!=this._start&&t.push({major:this.is_major(s),y:this.convertValue(s),val:this.formatValue(s)});return t}followScale(t){const e=this.minorStepIdx,i=this._start,s=this._end,o=this,n=()=>{o.magnitudefactor*=2},r=()=>{o.magnitudefactor/=2};t.minorStepIdx<=1&&this.minorStepIdx<=1||t.minorStepIdx>1&&this.minorStepIdx>1||(t.minorStepIdx<this.minorStepIdx?(this.minorStepIdx=1,2==e||n(),n()):(this.minorStepIdx=2,1==e||r(),r()));const a=t.convertValue(0),h=t.getStep()*t.scale;let l=!1,d=0;for(;!l&&d++<5;){this.scale=h/(this.minorSteps[this.minorStepIdx]*this.magnitudefactor);const e=this.containerHeight/this.scale;this._start=i,this._end=this._start+e;const o=this._end*this.scale,d=this.magnitudefactor*this.majorSteps[this.minorStepIdx],p=this.getFirstMajor()-t.getFirstMajor();if(this.zeroAlign){const t=a-o;this._end+=t/this.scale,this._start=this._end-e}else this.autoScaleStart?(this._start-=p/this.scale,this._end=this._start+e):(this._start+=d-p/this.scale,this._end=this._start+e);if(!this.autoScaleEnd&&this._end>s+1e-5)r(),l=!1;else{if(!this.autoScaleStart&&this._start<i-1e-5){if(!(this.zeroAlign&&i>=0)){r(),l=!1;continue}console.warn("Can't adhere to given 'min' range, due to zeroalign")}this.autoScaleStart&&this.autoScaleEnd&&e<s-i?(n(),l=!1):l=!0}}}convertValue(t){return this.containerHeight-(t-this._start)*this.scale}screenToValue(t){return(this.containerHeight-t)/this.scale+this._start}}class ge extends T{constructor(t,e,i,s){super(),this.id=p(),this.body=t,this.defaultOptions={orientation:"left",showMinorLabels:!0,showMajorLabels:!0,showWeekScale:!1,icons:!1,majorLinesOffset:7,minorLinesOffset:4,labelOffsetX:10,labelOffsetY:2,iconWidth:20,width:"40px",visible:!0,alignZeros:!0,left:{range:{min:void 0,max:void 0},format:t=>`${parseFloat(t.toPrecision(3))}`,title:{text:void 0,style:void 0}},right:{range:{min:void 0,max:void 0},format:t=>`${parseFloat(t.toPrecision(3))}`,title:{text:void 0,style:void 0}}},this.linegraphOptions=s,this.linegraphSVG=i,this.props={},this.DOMelements={lines:{},labels:{},title:{}},this.dom={},this.scale=void 0,this.range={start:0,end:0},this.options=k.extend({},this.defaultOptions),this.conversionFactor=1,this.setOptions(e),this.width=Number(`${this.options.width}`.replace("px","")),this.minWidth=this.width,this.height=this.linegraphSVG.getBoundingClientRect().height,this.hidden=!1,this.stepPixels=25,this.zeroCrossing=-1,this.amountOfSteps=-1,this.lineOffset=0,this.master=!0,this.masterAxis=null,this.svgElements={},this.iconsRemoved=!1,this.groups={},this.amountOfGroups=0,this._create(),null==this.scale&&this._redrawLabels(),this.framework={svg:this.svg,svgElements:this.svgElements,options:this.options,groups:this.groups};const o=this;this.body.emitter.on("verticalDrag",(()=>{o.dom.lineContainer.style.top=`${o.body.domProps.scrollTop}px`}))}addGroup(t,e){this.groups.hasOwnProperty(t)||(this.groups[t]=e),this.amountOfGroups+=1}updateGroup(t,e){this.groups.hasOwnProperty(t)||(this.amountOfGroups+=1),this.groups[t]=e}removeGroup(t){this.groups.hasOwnProperty(t)&&(delete this.groups[t],this.amountOfGroups-=1)}setOptions(t){if(t){let e=!1;this.options.orientation!=t.orientation&&void 0!==t.orientation&&(e=!0);const i=["orientation","showMinorLabels","showMajorLabels","icons","majorLinesOffset","minorLinesOffset","labelOffsetX","labelOffsetY","iconWidth","width","visible","left","right","alignZeros"];k.selectiveDeepExtend(i,this.options,t),this.minWidth=Number(`${this.options.width}`.replace("px","")),!0===e&&this.dom.frame&&(this.hide(),this.show())}}_create(){this.dom.frame=document.createElement("div"),this.dom.frame.style.width=this.options.width,this.dom.frame.style.height=this.height,this.dom.lineContainer=document.createElement("div"),this.dom.lineContainer.style.width="100%",this.dom.lineContainer.style.height=this.height,this.dom.lineContainer.style.position="relative",this.dom.lineContainer.style.visibility="visible",this.dom.lineContainer.style.display="block",this.svg=document.createElementNS("http://www.w3.org/2000/svg","svg"),this.svg.style.position="absolute",this.svg.style.top="0px",this.svg.style.height="100%",this.svg.style.width="100%",this.svg.style.display="block",this.dom.frame.appendChild(this.svg)}_redrawGroupIcons(){let t;he(this.svgElements);const e=this.options.iconWidth;let i=11.5;t="left"===this.options.orientation?4:this.width-e-4;const s=Object.keys(this.groups);s.sort(((t,e)=>t<e?-1:1));for(const o of s)!0!==this.groups[o].visible||void 0!==this.linegraphOptions.visibility[o]&&!0!==this.linegraphOptions.visibility[o]||(this.groups[o].getLegend(e,15,this.framework,t,i),i+=19);le(this.svgElements),this.iconsRemoved=!1}_cleanupIcons(){!1===this.iconsRemoved&&(he(this.svgElements),le(this.svgElements),this.iconsRemoved=!0)}show(){this.hidden=!1,this.dom.frame.parentNode||("left"===this.options.orientation?this.body.dom.left.appendChild(this.dom.frame):this.body.dom.right.appendChild(this.dom.frame)),this.dom.lineContainer.parentNode||this.body.dom.backgroundHorizontal.appendChild(this.dom.lineContainer),this.dom.lineContainer.style.display="block"}hide(){this.hidden=!0,this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame),this.dom.lineContainer.style.display="none"}setRange(t,e){this.range.start=t,this.range.end=e}redraw(){let t=!1,e=0;this.dom.lineContainer.style.top=`${this.body.domProps.scrollTop}px`;for(const t in this.groups)this.groups.hasOwnProperty(t)&&(!0!==this.groups[t].visible||void 0!==this.linegraphOptions.visibility[t]&&!0!==this.linegraphOptions.visibility[t]||e++);if(0===this.amountOfGroups||0===e)this.hide();else{this.show(),this.height=Number(this.linegraphSVG.style.height.replace("px","")),this.dom.lineContainer.style.height=`${this.height}px`,this.width=!0===this.options.visible?Number(`${this.options.width}`.replace("px","")):0;const e=this.props,i=this.dom.frame;i.className="vis-data-axis",this._calculateCharSize();const s=this.options.orientation,o=this.options.showMinorLabels,n=this.options.showMajorLabels,r=this.body.dom.backgroundHorizontal.offsetWidth;e.minorLabelHeight=o?e.minorCharHeight:0,e.majorLabelHeight=n?e.majorCharHeight:0,e.minorLineWidth=r-this.lineOffset-this.width+2*this.options.minorLinesOffset,e.minorLineHeight=1,e.majorLineWidth=r-this.lineOffset-this.width+2*this.options.majorLinesOffset,e.majorLineHeight=1,"left"===s?(i.style.top="0",i.style.left="0",i.style.bottom="",i.style.width=`${this.width}px`,i.style.height=`${this.height}px`,this.props.width=this.body.domProps.left.width,this.props.height=this.body.domProps.left.height):(i.style.top="",i.style.bottom="0",i.style.left="0",i.style.width=`${this.width}px`,i.style.height=`${this.height}px`,this.props.width=this.body.domProps.right.width,this.props.height=this.body.domProps.right.height),t=this._redrawLabels(),t=this._isResized()||t,!0===this.options.icons?this._redrawGroupIcons():this._cleanupIcons(),this._redrawTitle(s)}return t}_redrawLabels(){let t=!1;he(this.DOMelements.lines),he(this.DOMelements.labels);const e=this.options.orientation,i=null!=this.options[e].range?this.options[e].range:{};let s=!0;null!=i.max&&(this.range.end=i.max,s=!1);let o=!0;null!=i.min&&(this.range.start=i.min,o=!1),this.scale=new ue(this.range.start,this.range.end,o,s,this.dom.frame.offsetHeight,this.props.majorCharHeight,this.options.alignZeros,this.options[e].format),!1===this.master&&null!=this.masterAxis?(this.scale.followScale(this.masterAxis.scale),this.dom.lineContainer.style.display="none"):this.dom.lineContainer.style.display="block",this.maxLabelSize=0;this.scale.getLines().forEach((t=>{const i=t.y,s=t.major;this.options.showMinorLabels&&!1===s&&this._redrawLabel(i-2,t.val,e,"vis-y-axis vis-minor",this.props.minorCharHeight),s&&i>=0&&this._redrawLabel(i-2,t.val,e,"vis-y-axis vis-major",this.props.majorCharHeight),!0===this.master&&(s?this._redrawLine(i,e,"vis-grid vis-horizontal vis-major",this.options.majorLinesOffset,this.props.majorLineWidth):this._redrawLine(i,e,"vis-grid vis-horizontal vis-minor",this.options.minorLinesOffset,this.props.minorLineWidth))}));let n=0;void 0!==this.options[e].title&&void 0!==this.options[e].title.text&&(n=this.props.titleCharHeight);const r=!0===this.options.icons?Math.max(this.options.iconWidth,n)+this.options.labelOffsetX+15:n+this.options.labelOffsetX+15;return this.maxLabelSize>this.width-r&&!0===this.options.visible?(this.width=this.maxLabelSize+r,this.options.width=`${this.width}px`,le(this.DOMelements.lines),le(this.DOMelements.labels),this.redraw(),t=!0):this.maxLabelSize<this.width-r&&!0===this.options.visible&&this.width>this.minWidth?(this.width=Math.max(this.minWidth,this.maxLabelSize+r),this.options.width=`${this.width}px`,le(this.DOMelements.lines),le(this.DOMelements.labels),this.redraw(),t=!0):(le(this.DOMelements.lines),le(this.DOMelements.labels),t=!1),t}convertValue(t){return this.scale.convertValue(t)}screenToValue(t){return this.scale.screenToValue(t)}_redrawLabel(t,e,i,s,o){const n=pe("div",this.DOMelements.labels,this.dom.frame);n.className=s,n.innerHTML=k.xss(e),"left"===i?(n.style.left=`-${this.options.labelOffsetX}px`,n.style.textAlign="right"):(n.style.right=`-${this.options.labelOffsetX}px`,n.style.textAlign="left"),n.style.top=`${t-.5*o+this.options.labelOffsetY}px`,e+="";const r=Math.max(this.props.majorCharWidth,this.props.minorCharWidth);this.maxLabelSize<e.length*r&&(this.maxLabelSize=e.length*r)}_redrawLine(t,e,i,s,o){if(!0===this.master){const n=pe("div",this.DOMelements.lines,this.dom.lineContainer);n.className=i,n.innerHTML="","left"===e?n.style.left=this.width-s+"px":n.style.right=this.width-s+"px",n.style.width=`${o}px`,n.style.top=`${t}px`}}_redrawTitle(t){if(he(this.DOMelements.title),void 0!==this.options[t].title&&void 0!==this.options[t].title.text){const e=pe("div",this.DOMelements.title,this.dom.frame);e.className=`vis-y-axis vis-title vis-${t}`,e.innerHTML=k.xss(this.options[t].title.text),void 0!==this.options[t].title.style&&k.addCssText(e,this.options[t].title.style),"left"===t?e.style.left=`${this.props.titleCharHeight}px`:e.style.right=`${this.props.titleCharHeight}px`,e.style.width=`${this.height}px`}le(this.DOMelements.title)}_calculateCharSize(){if(!("minorCharHeight"in this.props)){const t=document.createTextNode("0"),e=document.createElement("div");e.className="vis-y-axis vis-minor vis-measure",e.appendChild(t),this.dom.frame.appendChild(e),this.props.minorCharHeight=e.clientHeight,this.props.minorCharWidth=e.clientWidth,this.dom.frame.removeChild(e)}if(!("majorCharHeight"in this.props)){const t=document.createTextNode("0"),e=document.createElement("div");e.className="vis-y-axis vis-major vis-measure",e.appendChild(t),this.dom.frame.appendChild(e),this.props.majorCharHeight=e.clientHeight,this.props.majorCharWidth=e.clientWidth,this.dom.frame.removeChild(e)}if(!("titleCharHeight"in this.props)){const t=document.createTextNode("0"),e=document.createElement("div");e.className="vis-y-axis vis-title vis-measure",e.appendChild(t),this.dom.frame.appendChild(e),this.props.titleCharHeight=e.clientHeight,this.props.titleCharWidth=e.clientWidth,this.dom.frame.removeChild(e)}}}function fe(t,e){}function be(t,e){return{style:(e=void 0===e?{}:e).style||t.options.drawPoints.style,styles:e.styles||t.options.drawPoints.styles,size:e.size||t.options.drawPoints.size,className:e.className||t.className}}function ye(t,e){}function ve(t,e){}function we(t,e,i,s){this.id=e;this.options=k.selectiveBridgeObject(["sampling","style","sort","yAxisOrientation","barChart","drawPoints","shaded","interpolation","zIndex","excludeFromStacking","excludeFromLegend"],i),this.usingDefaultStyle=void 0===t.className,this.groupsUsingDefaultStyles=s,this.zeroPosition=0,this.update(t),1==this.usingDefaultStyle&&(this.groupsUsingDefaultStyles[0]+=1),this.itemsData=[],this.visible=void 0===t.visible||t.visible}function _e(t,e,i,s){this.body=t,this.defaultOptions={enabled:!1,icons:!0,iconSize:20,iconSpacing:6,left:{visible:!0,position:"top-left"},right:{visible:!0,position:"top-right"}},this.side=i,this.options=k.extend({},this.defaultOptions),this.linegraphOptions=s,this.svgElements={},this.dom={},this.groups={},this.amountOfGroups=0,this._create(),this.framework={svg:this.svg,svgElements:this.svgElements,options:this.options,groups:this.groups},this.setOptions(e)}fe.draw=function(t,e,i,s){s=s||0;for(var o=function(t,e){var i=void 0;t.options&&t.options.drawPoints&&t.options.drawPoints.onRender&&"function"==typeof t.options.drawPoints.onRender&&(i=t.options.drawPoints.onRender);e.group.options&&e.group.options.drawPoints&&e.group.options.drawPoints.onRender&&"function"==typeof e.group.options.drawPoints.onRender&&(i=e.group.options.drawPoints.onRender);return i}(i,e),n=0;n<t.length;n++)if(o){var r=o(t[n],e);!0!==r&&"object"!=typeof r||me(t[n].screen_x+s,t[n].screen_y,be(e,r),i.svgElements,i.svg,t[n].label)}else me(t[n].screen_x+s,t[n].screen_y,be(e),i.svgElements,i.svg,t[n].label)},fe.drawIcon=function(t,e,i,s,o,n){var r=.5*o,a=de("rect",n.svgElements,n.svg);a.setAttributeNS(null,"x",e),a.setAttributeNS(null,"y",i-r),a.setAttributeNS(null,"width",s),a.setAttributeNS(null,"height",2*r),a.setAttributeNS(null,"class","vis-outline"),me(e+.5*s,i,be(t),n.svgElements,n.svg)},ye.drawIcon=function(t,e,i,s,o,n){var r=.5*o,a=de("rect",n.svgElements,n.svg);a.setAttributeNS(null,"x",e),a.setAttributeNS(null,"y",i-r),a.setAttributeNS(null,"width",s),a.setAttributeNS(null,"height",2*r),a.setAttributeNS(null,"class","vis-outline");var h=Math.round(.3*s),l=t.options.barChart.width/h,d=Math.round(.4*o),p=Math.round(.75*o),m=Math.round((s-2*h)/3);if(ce(e+.5*h+m,i+r-d-1,h,d,t.className+" vis-bar",n.svgElements,n.svg,t.style),ce(e+1.5*h+m+2,i+r-p-1,h,p,t.className+" vis-bar",n.svgElements,n.svg,t.style),1==t.options.drawPoints.enabled){var c={style:t.options.drawPoints.style,styles:t.options.drawPoints.styles,size:t.options.drawPoints.size/l,className:t.className};me(e+.5*h+m,i+r-d-1,c,n.svgElements,n.svg),me(e+1.5*h+m+2,i+r-p-1,c,n.svgElements,n.svg)}},ye.draw=function(t,e,i){var s,o,n,r,a,h,l=[],d={},p=0;for(a=0;a<t.length;a++)if("bar"===(r=i.groups[t[a]]).options.style&&!0===r.visible&&(void 0===i.options.groups.visibility[t[a]]||!0===i.options.groups.visibility[t[a]]))for(h=0;h<e[t[a]].length;h++)l.push({screen_x:e[t[a]][h].screen_x,screen_end:e[t[a]][h].screen_end,screen_y:e[t[a]][h].screen_y,x:e[t[a]][h].x,end:e[t[a]][h].end,y:e[t[a]][h].y,groupId:t[a],label:e[t[a]][h].label}),p+=1;if(0!==p)for(l.sort((function(t,e){return t.screen_x===e.screen_x?t.groupId<e.groupId?-1:1:t.screen_x-e.screen_x})),ye._getDataIntersections(d,l),a=0;a<l.length;a++){var m=null!=(r=i.groups[l[a].groupId]).options.barChart.minWidth?r.options.barChart.minWidth:.1*r.options.barChart.width,c=0;if(void 0===d[o=l[a].screen_x])a+1<l.length&&(s=Math.abs(l[a+1].screen_x-o)),n=ye._getSafeDrawData(s,r,m);else{var u=a+(d[o].amount-d[o].resolved);u<l.length&&(s=Math.abs(l[u].screen_x-o)),n=ye._getSafeDrawData(s,r,m),d[o].resolved+=1,!0===r.options.stack&&!0!==r.options.excludeFromStacking?l[a].screen_y<r.zeroPosition?(c=d[o].accumulatedNegative,d[o].accumulatedNegative+=r.zeroPosition-l[a].screen_y):(c=d[o].accumulatedPositive,d[o].accumulatedPositive+=r.zeroPosition-l[a].screen_y):!0===r.options.barChart.sideBySide&&(n.width=n.width/d[o].amount,n.offset+=d[o].resolved*n.width-.5*n.width*(d[o].amount+1))}let t=n.width,e=l[a].screen_x;if(null!=l[a].screen_end?(t=l[a].screen_end-l[a].screen_x,e+=.5*t):e+=n.offset,ce(e,l[a].screen_y-c,t,r.zeroPosition-l[a].screen_y,r.className+" vis-bar",i.svgElements,i.svg,r.style),!0===r.options.drawPoints.enabled){let t={screen_x:l[a].screen_x,screen_y:l[a].screen_y-c,x:l[a].x,y:l[a].y,groupId:l[a].groupId,label:l[a].label};fe.draw([t],r,i,n.offset)}}},ye._getDataIntersections=function(t,e){for(var i,s=0;s<e.length;s++)s+1<e.length&&(i=Math.abs(e[s+1].screen_x-e[s].screen_x)),s>0&&(i=Math.min(i,Math.abs(e[s-1].screen_x-e[s].screen_x))),0===i&&(void 0===t[e[s].screen_x]&&(t[e[s].screen_x]={amount:0,resolved:0,accumulatedPositive:0,accumulatedNegative:0}),t[e[s].screen_x].amount+=1)},ye._getSafeDrawData=function(t,e,i){var s,o;return t<e.options.barChart.width&&t>0?(s=t<i?i:t,o=0,"left"===e.options.barChart.align?o-=.5*t:"right"===e.options.barChart.align&&(o+=.5*t)):(s=e.options.barChart.width,o=0,"left"===e.options.barChart.align?o-=.5*e.options.barChart.width:"right"===e.options.barChart.align&&(o+=.5*e.options.barChart.width)),{width:s,offset:o}},ye.getStackedYRange=function(t,e,i,s,o){if(t.length>0){t.sort((function(t,e){return t.screen_x===e.screen_x?t.groupId<e.groupId?-1:1:t.screen_x-e.screen_x}));var n={};ye._getDataIntersections(n,t),e[s]=ye._getStackedYRange(n,t),e[s].yAxisOrientation=o,i.push(s)}},ye._getStackedYRange=function(t,e){for(var i,s=e[0].screen_y,o=e[0].screen_y,n=0;n<e.length;n++)void 0===t[i=e[n].screen_x]?(s=s>e[n].screen_y?e[n].screen_y:s,o=o<e[n].screen_y?e[n].screen_y:o):e[n].screen_y<0?t[i].accumulatedNegative+=e[n].screen_y:t[i].accumulatedPositive+=e[n].screen_y;for(var r in t)t.hasOwnProperty(r)&&(s=(s=s>t[r].accumulatedNegative?t[r].accumulatedNegative:s)>t[r].accumulatedPositive?t[r].accumulatedPositive:s,o=(o=o<t[r].accumulatedNegative?t[r].accumulatedNegative:o)<t[r].accumulatedPositive?t[r].accumulatedPositive:o);return{min:s,max:o}},ve.calcPath=function(t,e){if(null!=t&&t.length>0){return 1==e.options.interpolation.enabled?ve._catmullRom(t,e):ve._linear(t)}},ve.drawIcon=function(t,e,i,s,o,n){var r,a,h=.5*o,l=de("rect",n.svgElements,n.svg);(l.setAttributeNS(null,"x",e),l.setAttributeNS(null,"y",i-h),l.setAttributeNS(null,"width",s),l.setAttributeNS(null,"height",2*h),l.setAttributeNS(null,"class","vis-outline"),(r=de("path",n.svgElements,n.svg)).setAttributeNS(null,"class",t.className),void 0!==t.style&&r.setAttributeNS(null,"style",t.style),r.setAttributeNS(null,"d","M"+e+","+i+" L"+(e+s)+","+i),1==t.options.shaded.enabled&&(a=de("path",n.svgElements,n.svg),"top"==t.options.shaded.orientation?a.setAttributeNS(null,"d","M"+e+", "+(i-h)+"L"+e+","+i+" L"+(e+s)+","+i+" L"+(e+s)+","+(i-h)):a.setAttributeNS(null,"d","M"+e+","+i+" L"+e+","+(i+h)+" L"+(e+s)+","+(i+h)+"L"+(e+s)+","+i),a.setAttributeNS(null,"class",t.className+" vis-icon-fill"),void 0!==t.options.shaded.style&&""!==t.options.shaded.style&&a.setAttributeNS(null,"style",t.options.shaded.style)),1==t.options.drawPoints.enabled)&&me(e+.5*s,i,{style:t.options.drawPoints.style,styles:t.options.drawPoints.styles,size:t.options.drawPoints.size,className:t.className},n.svgElements,n.svg)},ve.drawShading=function(t,e,i,s){if(1==e.options.shaded.enabled){var o,n=Number(s.svg.style.height.replace("px","")),r=de("path",s.svgElements,s.svg),a="L";1==e.options.interpolation.enabled&&(a="C");var h=0;h="top"==e.options.shaded.orientation?0:"bottom"==e.options.shaded.orientation?n:Math.min(Math.max(0,e.zeroPosition),n),o="group"==e.options.shaded.orientation&&null!=i&&null!=i?"M"+t[0][0]+","+t[0][1]+" "+this.serializePath(t,a,!1)+" L"+i[i.length-1][0]+","+i[i.length-1][1]+" "+this.serializePath(i,a,!0)+i[0][0]+","+i[0][1]+" Z":"M"+t[0][0]+","+t[0][1]+" "+this.serializePath(t,a,!1)+" V"+h+" H"+t[0][0]+" Z",r.setAttributeNS(null,"class",e.className+" vis-fill"),void 0!==e.options.shaded.style&&r.setAttributeNS(null,"style",e.options.shaded.style),r.setAttributeNS(null,"d",o)}},ve.draw=function(t,e,i){if(null!=t&&null!=t){var s=de("path",i.svgElements,i.svg);s.setAttributeNS(null,"class",e.className),void 0!==e.style&&s.setAttributeNS(null,"style",e.style);var o="L";1==e.options.interpolation.enabled&&(o="C"),s.setAttributeNS(null,"d","M"+t[0][0]+","+t[0][1]+" "+this.serializePath(t,o,!1))}},ve.serializePath=function(t,e,i){if(t.length<2)return"";var s,o=e;if(i)for(s=t.length-2;s>0;s--)o+=t[s][0]+","+t[s][1]+" ";else for(s=1;s<t.length;s++)o+=t[s][0]+","+t[s][1]+" ";return o},ve._catmullRomUniform=function(t){var e,i,s,o,n,r,a=[];a.push([Math.round(t[0].screen_x),Math.round(t[0].screen_y)]);for(var h=1/6,l=t.length,d=0;d<l-1;d++)e=0==d?t[0]:t[d-1],i=t[d],s=t[d+1],o=d+2<l?t[d+2]:s,n={screen_x:(-e.screen_x+6*i.screen_x+s.screen_x)*h,screen_y:(-e.screen_y+6*i.screen_y+s.screen_y)*h},r={screen_x:(i.screen_x+6*s.screen_x-o.screen_x)*h,screen_y:(i.screen_y+6*s.screen_y-o.screen_y)*h},a.push([n.screen_x,n.screen_y]),a.push([r.screen_x,r.screen_y]),a.push([s.screen_x,s.screen_y]);return a},ve._catmullRom=function(t,e){var i=e.options.interpolation.alpha;if(0==i||void 0===i)return this._catmullRomUniform(t);var s,o,n,r,a,h,l,d,p,m,c,u,g,f,b,y,v,w,_,x=[];x.push([Math.round(t[0].screen_x),Math.round(t[0].screen_y)]);for(var D=t.length,C=0;C<D-1;C++)s=0==C?t[0]:t[C-1],o=t[C],n=t[C+1],r=C+2<D?t[C+2]:n,l=Math.sqrt(Math.pow(s.screen_x-o.screen_x,2)+Math.pow(s.screen_y-o.screen_y,2)),d=Math.sqrt(Math.pow(o.screen_x-n.screen_x,2)+Math.pow(o.screen_y-n.screen_y,2)),p=Math.sqrt(Math.pow(n.screen_x-r.screen_x,2)+Math.pow(n.screen_y-r.screen_y,2)),f=Math.pow(p,i),y=Math.pow(p,2*i),b=Math.pow(d,i),v=Math.pow(d,2*i),_=Math.pow(l,i),m=2*(w=Math.pow(l,2*i))+3*_*b+v,c=2*y+3*f*b+v,(u=3*_*(_+b))>0&&(u=1/u),(g=3*f*(f+b))>0&&(g=1/g),a={screen_x:(-v*s.screen_x+m*o.screen_x+w*n.screen_x)*u,screen_y:(-v*s.screen_y+m*o.screen_y+w*n.screen_y)*u},h={screen_x:(y*o.screen_x+c*n.screen_x-v*r.screen_x)*g,screen_y:(y*o.screen_y+c*n.screen_y-v*r.screen_y)*g},0==a.screen_x&&0==a.screen_y&&(a=o),0==h.screen_x&&0==h.screen_y&&(h=n),x.push([a.screen_x,a.screen_y]),x.push([h.screen_x,h.screen_y]),x.push([n.screen_x,n.screen_y]);return x},ve._linear=function(t){for(var e=[],i=0;i<t.length;i++)e.push([t[i].screen_x,t[i].screen_y]);return e},we.prototype.setItems=function(t){null!=t?(this.itemsData=t,1==this.options.sort&&k.insertSort(this.itemsData,(function(t,e){return t.x>e.x?1:-1}))):this.itemsData=[]},we.prototype.getItems=function(){return this.itemsData},we.prototype.setZeroPosition=function(t){this.zeroPosition=t},we.prototype.setOptions=function(t){if(void 0!==t){k.selectiveDeepExtend(["sampling","style","sort","yAxisOrientation","barChart","zIndex","excludeFromStacking","excludeFromLegend"],this.options,t),"function"==typeof t.drawPoints&&(t.drawPoints={onRender:t.drawPoints}),k.mergeOptions(this.options,t,"interpolation"),k.mergeOptions(this.options,t,"drawPoints"),k.mergeOptions(this.options,t,"shaded"),t.interpolation&&"object"==typeof t.interpolation&&t.interpolation.parametrization&&("uniform"==t.interpolation.parametrization?this.options.interpolation.alpha=0:"chordal"==t.interpolation.parametrization?this.options.interpolation.alpha=1:(this.options.interpolation.parametrization="centripetal",this.options.interpolation.alpha=.5))}},we.prototype.update=function(t){this.group=t,this.content=t.content||"graph",this.className=t.className||this.className||"vis-graph-group"+this.groupsUsingDefaultStyles[0]%10,this.visible=void 0===t.visible||t.visible,this.style=t.style,this.setOptions(t.options)},we.prototype.getLegend=function(t,e,i,s,o){null!=i&&null!=i||(i={svg:document.createElementNS("http://www.w3.org/2000/svg","svg"),svgElements:{},options:this.options,groups:[this]});switch(null!=s&&null!=s||(s=0),null!=o&&null!=o||(o=.5*e),this.options.style){case"line":ve.drawIcon(this,s,o,t,e,i);break;case"points":case"point":fe.drawIcon(this,s,o,t,e,i);break;case"bar":ye.drawIcon(this,s,o,t,e,i)}return{icon:i.svg,label:this.content,orientation:this.options.yAxisOrientation}},we.prototype.getYRange=function(t){for(var e=t[0].y,i=t[0].y,s=0;s<t.length;s++)e=e>t[s].y?t[s].y:e,i=i<t[s].y?t[s].y:i;return{min:e,max:i,yAxisOrientation:this.options.yAxisOrientation}},_e.prototype=new T,_e.prototype.clear=function(){this.groups={},this.amountOfGroups=0},_e.prototype.addGroup=function(t,e){1!=e.options.excludeFromLegend&&(this.groups.hasOwnProperty(t)||(this.groups[t]=e),this.amountOfGroups+=1)},_e.prototype.updateGroup=function(t,e){this.groups[t]=e},_e.prototype.removeGroup=function(t){this.groups.hasOwnProperty(t)&&(delete this.groups[t],this.amountOfGroups-=1)},_e.prototype._create=function(){this.dom.frame=document.createElement("div"),this.dom.frame.className="vis-legend",this.dom.frame.style.position="absolute",this.dom.frame.style.top="10px",this.dom.frame.style.display="block",this.dom.textArea=document.createElement("div"),this.dom.textArea.className="vis-legend-text",this.dom.textArea.style.position="relative",this.dom.textArea.style.top="0px",this.svg=document.createElementNS("http://www.w3.org/2000/svg","svg"),this.svg.style.position="absolute",this.svg.style.top="0px",this.svg.style.width=this.options.iconSize+5+"px",this.svg.style.height="100%",this.dom.frame.appendChild(this.svg),this.dom.frame.appendChild(this.dom.textArea)},_e.prototype.hide=function(){this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame)},_e.prototype.show=function(){this.dom.frame.parentNode||this.body.dom.center.appendChild(this.dom.frame)},_e.prototype.setOptions=function(t){k.selectiveDeepExtend(["enabled","orientation","icons","left","right"],this.options,t)},_e.prototype.redraw=function(){var t=0,e=Object.keys(this.groups);e.sort((function(t,e){return t<e?-1:1}));for(var i=0;i<e.length;i++){var s=e[i];1!=this.groups[s].visible||void 0!==this.linegraphOptions.visibility[s]&&1!=this.linegraphOptions.visibility[s]||t++}if(0==this.options[this.side].visible||0==this.amountOfGroups||0==this.options.enabled||0==t)this.hide();else{if(this.show(),"top-left"==this.options[this.side].position||"bottom-left"==this.options[this.side].position?(this.dom.frame.style.left="4px",this.dom.frame.style.textAlign="left",this.dom.textArea.style.textAlign="left",this.dom.textArea.style.left=this.options.iconSize+15+"px",this.dom.textArea.style.right="",this.svg.style.left="0px",this.svg.style.right=""):(this.dom.frame.style.right="4px",this.dom.frame.style.textAlign="right",this.dom.textArea.style.textAlign="right",this.dom.textArea.style.right=this.options.iconSize+15+"px",this.dom.textArea.style.left="",this.svg.style.right="0px",this.svg.style.left=""),"top-left"==this.options[this.side].position||"top-right"==this.options[this.side].position)this.dom.frame.style.top=4-Number(this.body.dom.center.style.top.replace("px",""))+"px",this.dom.frame.style.bottom="";else{var o=this.body.domProps.center.height-this.body.domProps.centerContainer.height;this.dom.frame.style.bottom=4+o+Number(this.body.dom.center.style.top.replace("px",""))+"px",this.dom.frame.style.top=""}0==this.options.icons?(this.dom.frame.style.width=this.dom.textArea.offsetWidth+10+"px",this.dom.textArea.style.right="",this.dom.textArea.style.left="",this.svg.style.width="0px"):(this.dom.frame.style.width=this.options.iconSize+15+this.dom.textArea.offsetWidth+10+"px",this.drawLegendIcons());var n="";for(i=0;i<e.length;i++)s=e[i],1!=this.groups[s].visible||void 0!==this.linegraphOptions.visibility[s]&&1!=this.linegraphOptions.visibility[s]||(n+=this.groups[s].content+"<br />");this.dom.textArea.innerHTML=k.xss(n),this.dom.textArea.style.lineHeight=.75*this.options.iconSize+this.options.iconSpacing+"px"}},_e.prototype.drawLegendIcons=function(){if(this.dom.frame.parentNode){var t=Object.keys(this.groups);t.sort((function(t,e){return t<e?-1:1})),he(l=this.svgElements),le(l),he(l);var e=window.getComputedStyle(this.dom.frame).paddingTop,i=Number(e.replace("px","")),s=i,o=this.options.iconSize,n=.75*this.options.iconSize,r=i+.5*n+3;this.svg.style.width=o+5+i+"px";for(var a=0;a<t.length;a++){var h=t[a];1!=this.groups[h].visible||void 0!==this.linegraphOptions.visibility[h]&&1!=this.linegraphOptions.visibility[h]||(this.groups[h].getLegend(o,n,this.framework,s,r),r+=n+this.options.iconSpacing)}}var l};var xe="__ungrouped__";function De(t,e){this.id=p(),this.body=t,this.defaultOptions={yAxisOrientation:"left",defaultGroup:"default",sort:!0,sampling:!0,stack:!1,graphHeight:"400px",shaded:{enabled:!1,orientation:"bottom"},style:"line",barChart:{width:50,sideBySide:!1,align:"center"},interpolation:{enabled:!0,parametrization:"centripetal",alpha:.5},drawPoints:{enabled:!0,size:6,style:"square"},dataAxis:{},legend:{},groups:{visibility:{}}},this.options=k.extend({},this.defaultOptions),this.dom={},this.props={},this.hammer=null,this.groups={},this.abortedGraphUpdate=!1,this.updateSVGheight=!1,this.updateSVGheightOnResize=!1,this.forceGraphUpdate=!0;var i=this;this.itemsData=null,this.groupsData=null,this.itemListeners={add:function(t,e,s){i._onAdd(e.items)},update:function(t,e,s){i._onUpdate(e.items)},remove:function(t,e,s){i._onRemove(e.items)}},this.groupListeners={add:function(t,e,s){i._onAddGroups(e.items)},update:function(t,e,s){i._onUpdateGroups(e.items)},remove:function(t,e,s){i._onRemoveGroups(e.items)}},this.items={},this.selection=[],this.lastStart=this.body.range.start,this.touchParams={},this.svgElements={},this.setOptions(e),this.groupsUsingDefaultStyles=[0],this.body.emitter.on("rangechanged",(function(){i.svg.style.left=k.option.asSize(-i.props.width),i.forceGraphUpdate=!0,i.redraw.call(i)})),this._create(),this.framework={svg:this.svg,svgElements:this.svgElements,options:this.options,groups:this.groups}}De.prototype=new T,De.prototype._create=function(){var t=document.createElement("div");t.className="vis-line-graph",this.dom.frame=t,this.svg=document.createElementNS("http://www.w3.org/2000/svg","svg"),this.svg.style.position="relative",this.svg.style.height=(""+this.options.graphHeight).replace("px","")+"px",this.svg.style.display="block",t.appendChild(this.svg),this.options.dataAxis.orientation="left",this.yAxisLeft=new ge(this.body,this.options.dataAxis,this.svg,this.options.groups),this.options.dataAxis.orientation="right",this.yAxisRight=new ge(this.body,this.options.dataAxis,this.svg,this.options.groups),delete this.options.dataAxis.orientation,this.legendLeft=new _e(this.body,this.options.legend,"left",this.options.groups),this.legendRight=new _e(this.body,this.options.legend,"right",this.options.groups),this.show()},De.prototype.setOptions=function(t){if(t){void 0===t.graphHeight&&void 0!==t.height?(this.updateSVGheight=!0,this.updateSVGheightOnResize=!0):void 0!==this.body.domProps.centerContainer.height&&void 0!==t.graphHeight&&parseInt((t.graphHeight+"").replace("px",""))<this.body.domProps.centerContainer.height&&(this.updateSVGheight=!0),k.selectiveDeepExtend(["sampling","defaultGroup","stack","height","graphHeight","yAxisOrientation","style","barChart","dataAxis","sort","groups"],this.options,t),k.mergeOptions(this.options,t,"interpolation"),k.mergeOptions(this.options,t,"drawPoints"),k.mergeOptions(this.options,t,"shaded"),k.mergeOptions(this.options,t,"legend"),t.interpolation&&"object"==typeof t.interpolation&&t.interpolation.parametrization&&("uniform"==t.interpolation.parametrization?this.options.interpolation.alpha=0:"chordal"==t.interpolation.parametrization?this.options.interpolation.alpha=1:(this.options.interpolation.parametrization="centripetal",this.options.interpolation.alpha=.5)),this.yAxisLeft&&void 0!==t.dataAxis&&(this.yAxisLeft.setOptions(this.options.dataAxis),this.yAxisRight.setOptions(this.options.dataAxis)),this.legendLeft&&void 0!==t.legend&&(this.legendLeft.setOptions(this.options.legend),this.legendRight.setOptions(this.options.legend)),this.groups.hasOwnProperty(xe)&&this.groups[xe].setOptions(t)}this.dom.frame&&(this.forceGraphUpdate=!0,this.body.emitter.emit("_change",{queue:!0}))},De.prototype.hide=function(){this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame)},De.prototype.show=function(){this.dom.frame.parentNode||this.body.dom.center.appendChild(this.dom.frame)},De.prototype.setItems=function(t){var e,i=this,s=this.itemsData;if(t){if(!y(t))throw new TypeError("Data must implement the interface of DataSet or DataView");this.itemsData=x(t)}else this.itemsData=null;if(s&&(k.forEach(this.itemListeners,(function(t,e){s.off(e,t)})),s.dispose(),e=s.getIds(),this._onRemove(e)),this.itemsData){var o=this.id;k.forEach(this.itemListeners,(function(t,e){i.itemsData.on(e,t,o)})),e=this.itemsData.getIds(),this._onAdd(e)}},De.prototype.setGroups=function(t){var e,i=this;if(this.groupsData){k.forEach(this.groupListeners,(function(t,e){i.groupsData.off(e,t)})),e=this.groupsData.getIds(),this.groupsData=null;for(var s=0;s<e.length;s++)this._removeGroup(e[s])}if(t){if(!y(t))throw new TypeError("Data must implement the interface of DataSet or DataView");this.groupsData=t}else this.groupsData=null;if(this.groupsData){var o=this.id;k.forEach(this.groupListeners,(function(t,e){i.groupsData.on(e,t,o)})),e=this.groupsData.getIds(),this._onAddGroups(e)}},De.prototype._onUpdate=function(t){this._updateAllGroupData(t)},De.prototype._onAdd=function(t){this._onUpdate(t)},De.prototype._onRemove=function(t){this._onUpdate(t)},De.prototype._onUpdateGroups=function(t){this._updateAllGroupData(null,t)},De.prototype._onAddGroups=function(t){this._onUpdateGroups(t)},De.prototype._onRemoveGroups=function(t){for(var e=0;e<t.length;e++)this._removeGroup(t[e]);this.forceGraphUpdate=!0,this.body.emitter.emit("_change",{queue:!0})},De.prototype._removeGroup=function(t){this.groups.hasOwnProperty(t)&&("right"==this.groups[t].options.yAxisOrientation?(this.yAxisRight.removeGroup(t),this.legendRight.removeGroup(t),this.legendRight.redraw()):(this.yAxisLeft.removeGroup(t),this.legendLeft.removeGroup(t),this.legendLeft.redraw()),delete this.groups[t])},De.prototype._updateGroup=function(t,e){this.groups.hasOwnProperty(e)?(this.groups[e].update(t),"right"==this.groups[e].options.yAxisOrientation?(this.yAxisRight.updateGroup(e,this.groups[e]),this.legendRight.updateGroup(e,this.groups[e]),this.yAxisLeft.removeGroup(e),this.legendLeft.removeGroup(e)):(this.yAxisLeft.updateGroup(e,this.groups[e]),this.legendLeft.updateGroup(e,this.groups[e]),this.yAxisRight.removeGroup(e),this.legendRight.removeGroup(e))):(this.groups[e]=new we(t,e,this.options,this.groupsUsingDefaultStyles),"right"==this.groups[e].options.yAxisOrientation?(this.yAxisRight.addGroup(e,this.groups[e]),this.legendRight.addGroup(e,this.groups[e])):(this.yAxisLeft.addGroup(e,this.groups[e]),this.legendLeft.addGroup(e,this.groups[e]))),this.legendLeft.redraw(),this.legendRight.redraw()},De.prototype._updateAllGroupData=function(t,e){if(null!=this.itemsData){var i={},s=this.itemsData.get(),o=this.itemsData.idProp,n={};t&&t.map((function(t){n[t]=t}));for(var r={},a=0;a<s.length;a++){var h=s[a],l=h.group;null==l&&(l=xe),r.hasOwnProperty(l)?r[l]++:r[l]=1}var d={};if(!e&&t)for(l in this.groups)if(this.groups.hasOwnProperty(l)){var p=(g=this.groups[l]).getItems();i[l]=p.filter((function(t){return d[t[o]]=t[o],t[o]!==n[t[o]]}));var m=r[l];r[l]-=i[l].length,i[l].length<m&&(i[l][m-1]={})}for(a=0;a<s.length;a++)if(null==(l=(h=s[a]).group)&&(l=xe),e||!t||h[o]===n[h[o]]||!d.hasOwnProperty(h[o])){i.hasOwnProperty(l)||(i[l]=new Array(r[l]));var c=k.bridgeObject(h);c.x=k.convert(h.x,"Date"),c.end=k.convert(h.end,"Date"),c.orginalY=h.y,c.y=Number(h.y),c[o]=h[o];var u=i[l].length-r[l]--;i[l][u]=c}for(l in this.groups)this.groups.hasOwnProperty(l)&&(i.hasOwnProperty(l)||(i[l]=new Array(0)));for(l in i)if(i.hasOwnProperty(l))if(0==i[l].length)this.groups.hasOwnProperty(l)&&this._removeGroup(l);else{var g=void 0;null!=this.groupsData&&(g=this.groupsData.get(l)),null==g&&(g={id:l,content:this.options.defaultGroup+l}),this._updateGroup(g,l),this.groups[l].setItems(i[l])}this.forceGraphUpdate=!0,this.body.emitter.emit("_change",{queue:!0})}},De.prototype.redraw=function(){var t=!1;this.props.width=this.dom.frame.offsetWidth,this.props.height=this.body.domProps.centerContainer.height-this.body.domProps.border.top-this.body.domProps.border.bottom,t=this._isResized()||t;var e=this.body.range.end-this.body.range.start,i=e!=this.lastVisibleInterval;if(this.lastVisibleInterval=e,1==t&&(this.svg.style.width=k.option.asSize(3*this.props.width),this.svg.style.left=k.option.asSize(-this.props.width),-1==(this.options.height+"").indexOf("%")&&1!=this.updateSVGheightOnResize||(this.updateSVGheight=!0)),1==this.updateSVGheight?(this.options.graphHeight!=this.props.height+"px"&&(this.options.graphHeight=this.props.height+"px",this.svg.style.height=this.props.height+"px"),this.updateSVGheight=!1):this.svg.style.height=(""+this.options.graphHeight).replace("px","")+"px",1==t||1==i||1==this.abortedGraphUpdate||1==this.forceGraphUpdate)t=this._updateGraph()||t,this.forceGraphUpdate=!1,this.lastStart=this.body.range.start,this.svg.style.left=-this.props.width+"px";else if(0!=this.lastStart){var s=this.body.range.start-this.lastStart,o=this.body.range.end-this.body.range.start;if(0!=this.props.width){var n=s*(this.props.width/o);this.svg.style.left=-this.props.width-n+"px"}}return this.legendLeft.redraw(),this.legendRight.redraw(),t},De.prototype._getSortedGroupIds=function(){var t=[];for(var e in this.groups)if(this.groups.hasOwnProperty(e)){var i=this.groups[e];1!=i.visible||void 0!==this.options.groups.visibility[e]&&1!=this.options.groups.visibility[e]||t.push({id:e,zIndex:i.options.zIndex})}k.insertSort(t,(function(t,e){var i=t.zIndex,s=e.zIndex;return void 0===i&&(i=0),void 0===s&&(s=0),i==s?0:i<s?-1:1}));for(var s=new Array(t.length),o=0;o<t.length;o++)s[o]=t[o].id;return s},De.prototype._updateGraph=function(){if(he(this.svgElements),0!=this.props.width&&null!=this.itemsData){var t,e,i={},s=this.body.util.toGlobalTime(-this.body.domProps.root.width),o=this.body.util.toGlobalTime(2*this.body.domProps.root.width),n=this._getSortedGroupIds();if(n.length>0){var r={};for(this._getRelevantData(n,r,s,o),this._applySampling(n,r),e=0;e<n.length;e++)this._convertXcoordinates(r[n[e]]);if(this._getYRanges(n,r,i),1==this._updateYAxis(n,i))return le(this.svgElements),this.abortedGraphUpdate=!0,!0;this.abortedGraphUpdate=!1;var a=void 0;for(e=0;e<n.length;e++)t=this.groups[n[e]],!0===this.options.stack&&"line"===this.options.style&&(null!=t.options.excludeFromStacking&&t.options.excludeFromStacking||(null!=a&&(this._stack(r[t.id],r[a.id]),1==t.options.shaded.enabled&&"group"!==t.options.shaded.orientation&&("top"==t.options.shaded.orientation&&"group"!==a.options.shaded.orientation?(a.options.shaded.orientation="group",a.options.shaded.groupId=t.id):(t.options.shaded.orientation="group",t.options.shaded.groupId=a.id))),a=t)),this._convertYcoordinates(r[n[e]],t);var h={};for(e=0;e<n.length;e++)if("line"===(t=this.groups[n[e]]).options.style&&1==t.options.shaded.enabled){var l=r[n[e]];if(null==l||0==l.length)continue;if(h.hasOwnProperty(n[e])||(h[n[e]]=ve.calcPath(l,t)),"group"===t.options.shaded.orientation){var d=t.options.shaded.groupId;if(-1===n.indexOf(d)){console.log(t.id+": Unknown shading group target given:"+d);continue}h.hasOwnProperty(d)||(h[d]=ve.calcPath(r[d],this.groups[d])),ve.drawShading(h[n[e]],t,h[d],this.framework)}else ve.drawShading(h[n[e]],t,void 0,this.framework)}for(ye.draw(n,r,this.framework),e=0;e<n.length;e++)if(t=this.groups[n[e]],r[n[e]].length>0)switch(t.options.style){case"line":h.hasOwnProperty(n[e])||(h[n[e]]=ve.calcPath(r[n[e]],t)),ve.draw(h[n[e]],t,this.framework);case"point":case"points":"point"!=t.options.style&&"points"!=t.options.style&&1!=t.options.drawPoints.enabled||fe.draw(r[n[e]],t,this.framework)}}}return le(this.svgElements),!1},De.prototype._stack=function(t,e){var i,s,o,n,r;i=0;for(var a=0;a<t.length;a++){n=void 0,r=void 0;for(var h=i;h<e.length;h++){if(e[h].x===t[a].x){n=e[h],r=e[h],i=h;break}if(e[h].x>t[a].x){r=e[h],n=0==h?r:e[h-1],i=h;break}}void 0===r&&(n=e[e.length-1],r=e[e.length-1]),s=r.x-n.x,o=r.y-n.y,t[a].y=0==s?t[a].orginalY+r.y:t[a].orginalY+o/s*(t[a].x-n.x)+n.y}},De.prototype._getRelevantData=function(t,e,i,s){var o,n,r,a;if(t.length>0)for(n=0;n<t.length;n++){var h=(o=this.groups[t[n]]).getItems();if(1==o.options.sort){var l=function(t,e){return t.getTime()==e.getTime()?0:t<e?-1:1},d=Math.max(0,k.binarySearchValue(h,i,"x","before",l)),p=Math.min(h.length,k.binarySearchValue(h,s,"x","after",l)+1);p<=0&&(p=h.length);var m=new Array(p-d);for(r=d;r<p;r++)a=o.itemsData[r],m[r-d]=a;e[t[n]]=m}else e[t[n]]=o.itemsData}},De.prototype._applySampling=function(t,e){if(t.length>0)for(var i=0;i<t.length;i++)if(1==this.groups[t[i]].options.sampling){var s=e[t[i]];if(s.length>0){var o,n=s.length,r=n/(this.body.util.toGlobalScreen(s[s.length-1].x)-this.body.util.toGlobalScreen(s[0].x));o=Math.min(Math.ceil(.2*n),Math.max(1,Math.round(r)));for(var a=new Array(n),h=0;h<n;h+=o){a[Math.round(h/o)]=s[h]}e[t[i]]=a.splice(0,Math.round(n/o))}}},De.prototype._getYRanges=function(t,e,i){var s,o,n,r,a=[],h=[];if(t.length>0){for(n=0;n<t.length;n++)s=e[t[n]],r=this.groups[t[n]].options,s.length>0&&(o=this.groups[t[n]],!0===r.stack&&"bar"===r.style?"left"===r.yAxisOrientation?a=a.concat(s):h=h.concat(s):i[t[n]]=o.getYRange(s,t[n]));ye.getStackedYRange(a,i,t,"__barStackLeft","left"),ye.getStackedYRange(h,i,t,"__barStackRight","right")}},De.prototype._updateYAxis=function(t,e){var i,s,o=!1,n=!1,r=!1,a=1e9,h=1e9,l=-1e9,d=-1e9;if(t.length>0){for(var p=0;p<t.length;p++){var m=this.groups[t[p]];m&&"right"!=m.options.yAxisOrientation?(n=!0,a=1e9,l=-1e9):m&&m.options.yAxisOrientation&&(r=!0,h=1e9,d=-1e9)}for(p=0;p<t.length;p++)e.hasOwnProperty(t[p])&&!0!==e[t[p]].ignore&&(i=e[t[p]].min,s=e[t[p]].max,"right"!=e[t[p]].yAxisOrientation?(n=!0,a=a>i?i:a,l=l<s?s:l):(r=!0,h=h>i?i:h,d=d<s?s:d));1==n&&this.yAxisLeft.setRange(a,l),1==r&&this.yAxisRight.setRange(h,d)}o=this._toggleAxisVisiblity(n,this.yAxisLeft)||o,o=this._toggleAxisVisiblity(r,this.yAxisRight)||o,1==r&&1==n?(this.yAxisLeft.drawIcons=!0,this.yAxisRight.drawIcons=!0):(this.yAxisLeft.drawIcons=!1,this.yAxisRight.drawIcons=!1),this.yAxisRight.master=!n,this.yAxisRight.masterAxis=this.yAxisLeft,0==this.yAxisRight.master?(this.yAxisLeft.lineOffset=1==r?this.yAxisRight.width:0,o=this.yAxisLeft.redraw()||o,o=this.yAxisRight.redraw()||o):o=this.yAxisRight.redraw()||o;var c=["__barStackLeft","__barStackRight","__lineStackLeft","__lineStackRight"];for(p=0;p<c.length;p++)-1!=t.indexOf(c[p])&&t.splice(t.indexOf(c[p]),1);return o},De.prototype._toggleAxisVisiblity=function(t,e){var i=!1;return 0==t?e.dom.frame.parentNode&&0==e.hidden&&(e.hide(),i=!0):e.dom.frame.parentNode||1!=e.hidden||(e.show(),i=!0),i},De.prototype._convertXcoordinates=function(t){for(var e=this.body.util.toScreen,i=0;i<t.length;i++)t[i].screen_x=e(t[i].x)+this.props.width,t[i].screen_y=t[i].y,null!=t[i].end?t[i].screen_end=e(t[i].end)+this.props.width:t[i].screen_end=void 0},De.prototype._convertYcoordinates=function(t,e){var i=this.yAxisLeft,s=Number(this.svg.style.height.replace("px",""));"right"==e.options.yAxisOrientation&&(i=this.yAxisRight);for(var o=0;o<t.length;o++)t[o].screen_y=Math.round(i.convertValue(t[o].y));e.setZeroPosition(Math.min(s,i.convertValue(0)))};let Ce="string",Se="boolean",ke="number",Te="date",Ee="object",Oe="moment",Me={configure:{enabled:{boolean:Se},filter:{boolean:Se,function:"function"},container:{dom:"dom"},__type__:{object:Ee,boolean:Se,function:"function"}},alignCurrentTime:{string:Ce,undefined:"undefined"},yAxisOrientation:{string:["left","right"]},defaultGroup:{string:Ce},sort:{boolean:Se},sampling:{boolean:Se},stack:{boolean:Se},graphHeight:{string:Ce,number:ke},shaded:{enabled:{boolean:Se},orientation:{string:["bottom","top","zero","group"]},groupId:{object:Ee},__type__:{boolean:Se,object:Ee}},style:{string:["line","bar","points"]},barChart:{width:{number:ke},minWidth:{number:ke},sideBySide:{boolean:Se},align:{string:["left","center","right"]},__type__:{object:Ee}},interpolation:{enabled:{boolean:Se},parametrization:{string:["centripetal","chordal","uniform"]},alpha:{number:ke},__type__:{object:Ee,boolean:Se}},drawPoints:{enabled:{boolean:Se},onRender:{function:"function"},size:{number:ke},style:{string:["square","circle"]},__type__:{object:Ee,boolean:Se,function:"function"}},dataAxis:{showMinorLabels:{boolean:Se},showMajorLabels:{boolean:Se},showWeekScale:{boolean:Se},icons:{boolean:Se},width:{string:Ce,number:ke},visible:{boolean:Se},alignZeros:{boolean:Se},left:{range:{min:{number:ke,undefined:"undefined"},max:{number:ke,undefined:"undefined"},__type__:{object:Ee}},format:{function:"function"},title:{text:{string:Ce,number:ke,undefined:"undefined"},style:{string:Ce,undefined:"undefined"},__type__:{object:Ee}},__type__:{object:Ee}},right:{range:{min:{number:ke,undefined:"undefined"},max:{number:ke,undefined:"undefined"},__type__:{object:Ee}},format:{function:"function"},title:{text:{string:Ce,number:ke,undefined:"undefined"},style:{string:Ce,undefined:"undefined"},__type__:{object:Ee}},__type__:{object:Ee}},__type__:{object:Ee}},legend:{enabled:{boolean:Se},icons:{boolean:Se},left:{visible:{boolean:Se},position:{string:["top-right","bottom-right","top-left","bottom-left"]},__type__:{object:Ee}},right:{visible:{boolean:Se},position:{string:["top-right","bottom-right","top-left","bottom-left"]},__type__:{object:Ee}},__type__:{object:Ee,boolean:Se}},groups:{visibility:{any:"any"},__type__:{object:Ee}},autoResize:{boolean:Se},throttleRedraw:{number:ke},clickToUse:{boolean:Se},end:{number:ke,date:Te,string:Ce,moment:Oe},format:{minorLabels:{millisecond:{string:Ce,undefined:"undefined"},second:{string:Ce,undefined:"undefined"},minute:{string:Ce,undefined:"undefined"},hour:{string:Ce,undefined:"undefined"},weekday:{string:Ce,undefined:"undefined"},day:{string:Ce,undefined:"undefined"},week:{string:Ce,undefined:"undefined"},month:{string:Ce,undefined:"undefined"},quarter:{string:Ce,undefined:"undefined"},year:{string:Ce,undefined:"undefined"},__type__:{object:Ee}},majorLabels:{millisecond:{string:Ce,undefined:"undefined"},second:{string:Ce,undefined:"undefined"},minute:{string:Ce,undefined:"undefined"},hour:{string:Ce,undefined:"undefined"},weekday:{string:Ce,undefined:"undefined"},day:{string:Ce,undefined:"undefined"},week:{string:Ce,undefined:"undefined"},month:{string:Ce,undefined:"undefined"},quarter:{string:Ce,undefined:"undefined"},year:{string:Ce,undefined:"undefined"},__type__:{object:Ee}},__type__:{object:Ee}},moment:{function:"function"},height:{string:Ce,number:ke},hiddenDates:{start:{date:Te,number:ke,string:Ce,moment:Oe},end:{date:Te,number:ke,string:Ce,moment:Oe},repeat:{string:Ce},__type__:{object:Ee,array:"array"}},locale:{string:Ce},locales:{__any__:{any:"any"},__type__:{object:Ee}},max:{date:Te,number:ke,string:Ce,moment:Oe},maxHeight:{number:ke,string:Ce},maxMinorChars:{number:ke},min:{date:Te,number:ke,string:Ce,moment:Oe},minHeight:{number:ke,string:Ce},moveable:{boolean:Se},multiselect:{boolean:Se},orientation:{string:Ce},showCurrentTime:{boolean:Se},showMajorLabels:{boolean:Se},showMinorLabels:{boolean:Se},showWeekScale:{boolean:Se},snap:{function:"function",null:"null"},start:{date:Te,number:ke,string:Ce,moment:Oe},timeAxis:{scale:{string:Ce,undefined:"undefined"},step:{number:ke,undefined:"undefined"},__type__:{object:Ee}},width:{string:Ce,number:ke},zoomable:{boolean:Se},zoomKey:{string:["ctrlKey","altKey","metaKey",""]},zoomMax:{number:ke},zoomMin:{number:ke},zIndex:{number:ke},__type__:{object:Ee}},Ie={global:{alignCurrentTime:["none","year","month","quarter","week","isoWeek","day","date","hour","minute","second"],sort:!0,sampling:!0,stack:!1,shaded:{enabled:!1,orientation:["zero","top","bottom","group"]},style:["line","bar","points"],barChart:{width:[50,5,100,5],minWidth:[50,5,100,5],sideBySide:!1,align:["left","center","right"]},interpolation:{enabled:!0,parametrization:["centripetal","chordal","uniform"]},drawPoints:{enabled:!0,size:[6,2,30,1],style:["square","circle"]},dataAxis:{showMinorLabels:!0,showMajorLabels:!0,showWeekScale:!1,icons:!1,width:[40,0,200,1],visible:!0,alignZeros:!0,left:{title:{text:"",style:""}},right:{title:{text:"",style:""}}},legend:{enabled:!1,icons:!0,left:{visible:!0,position:["top-right","bottom-right","top-left","bottom-left"]},right:{visible:!0,position:["top-right","bottom-right","top-left","bottom-left"]}},autoResize:!0,clickToUse:!1,end:"",format:{minorLabels:{millisecond:"SSS",second:"s",minute:"HH:mm",hour:"HH:mm",weekday:"ddd D",day:"D",week:"w",month:"MMM",quarter:"[Q]Q",year:"YYYY"},majorLabels:{millisecond:"HH:mm:ss",second:"D MMMM HH:mm",minute:"ddd D MMMM",hour:"ddd D MMMM",weekday:"MMMM YYYY",day:"MMMM YYYY",week:"MMMM YYYY",month:"YYYY",quarter:"YYYY",year:""}},height:"",locale:"",max:"",maxHeight:"",maxMinorChars:[7,0,20,1],min:"",minHeight:"",moveable:!0,orientation:["both","bottom","top"],showCurrentTime:!1,showMajorLabels:!0,showMinorLabels:!0,showWeekScale:!1,start:"",width:"100%",zoomable:!0,zoomKey:["ctrlKey","altKey","metaKey",""],zoomMax:[31536e10,10,31536e10,1],zoomMin:[10,10,31536e10,1],zIndex:0}};function Ne(t,e,i,s){if(!Array.isArray(i)&&!y(i)&&i instanceof Object){var o=s;s=i,i=o}s&&s.throttleRedraw&&console.warn('Graph2d option "throttleRedraw" is DEPRICATED and no longer supported. It will be removed in the next MAJOR release.');var n=this;this.defaultOptions={start:null,end:null,autoResize:!0,orientation:{axis:"bottom",item:"bottom"},moment:b,width:null,height:null,maxHeight:null,minHeight:null},this.options=k.deepExtend({},this.defaultOptions),this._create(t),this.components=[],this.body={dom:this.dom,domProps:this.props,emitter:{on:this.on.bind(this),off:this.off.bind(this),emit:this.emit.bind(this)},hiddenDates:[],util:{getScale:()=>n.timeAxis.step.scale,getStep:()=>n.timeAxis.step.step,toScreen:n._toScreen.bind(n),toGlobalScreen:n._toGlobalScreen.bind(n),toTime:n._toTime.bind(n),toGlobalTime:n._toGlobalTime.bind(n)}},this.range=new B(this.body),this.components.push(this.range),this.body.range=this.range,this.timeAxis=new X(this.body),this.components.push(this.timeAxis),this.currentTime=new ut(this.body),this.components.push(this.currentTime),this.linegraph=new De(this.body),this.components.push(this.linegraph),this.itemsData=null,this.groupsData=null,this.on("tap",(function(t){n.emit("click",n.getEventProperties(t))})),this.on("doubletap",(function(t){n.emit("doubleClick",n.getEventProperties(t))})),this.dom.root.oncontextmenu=function(t){n.emit("contextmenu",n.getEventProperties(t))},this.initialFitDone=!1,this.on("changed",(function(){if(null!=n.itemsData){if(!n.initialFitDone&&!n.options.rollingMode)if(n.initialFitDone=!0,null!=n.options.start||null!=n.options.end){if(null==n.options.start||null==n.options.end)var t=n.getItemRange();var e=null!=n.options.start?n.options.start:t.min,i=null!=n.options.end?n.options.end:t.max;n.setWindow(e,i,{animation:!1})}else n.fit({animation:!1});n.initialDrawDone||!n.initialRangeChangeDone&&(n.options.start||n.options.end)&&!n.options.rollingMode||(n.initialDrawDone=!0,n.dom.root.style.visibility="visible",n.dom.loadingScreen.parentNode.removeChild(n.dom.loadingScreen),n.options.onInitialDrawComplete&&setTimeout((()=>n.options.onInitialDrawComplete()),0))}})),s&&this.setOptions(s),i&&this.setGroups(i),e&&this.setItems(e),this._redraw()}Ne.prototype=new ct,Ne.prototype.setOptions=function(t){!0===Wt.validate(t,Me)&&console.log("%cErrors have been found in the supplied options object.",$t),ct.prototype.setOptions.call(this,t)},Ne.prototype.setItems=function(t){var e,i=null==this.itemsData;if(e=t?y(t)?x(t):x(new a(t)):null,this.itemsData&&this.itemsData.dispose(),this.itemsData=e,this.linegraph&&this.linegraph.setItems(null!=e?e.rawDS:null),i)if(null!=this.options.start||null!=this.options.end){var s=null!=this.options.start?this.options.start:null,o=null!=this.options.end?this.options.end:null;this.setWindow(s,o,{animation:!1})}else this.fit({animation:!1})},Ne.prototype.setGroups=function(t){var e;e=t?y(t)?t:new a(t):null,this.groupsData=e,this.linegraph.setGroups(e)},Ne.prototype.getLegend=function(t,e,i){return void 0===e&&(e=15),void 0===i&&(i=15),void 0!==this.linegraph.groups[t]?this.linegraph.groups[t].getLegend(e,i):"cannot find group:'"+t+"'"},Ne.prototype.isGroupVisible=function(t){return void 0!==this.linegraph.groups[t]&&(this.linegraph.groups[t].visible&&(void 0===this.linegraph.options.groups.visibility[t]||1==this.linegraph.options.groups.visibility[t]))},Ne.prototype.getDataRange=function(){var t=null,e=null;for(var i in this.linegraph.groups)if(this.linegraph.groups.hasOwnProperty(i)&&1==this.linegraph.groups[i].visible)for(var s=0;s<this.linegraph.groups[i].itemsData.length;s++){var o=this.linegraph.groups[i].itemsData[s],n=k.convert(o.x,"Date").valueOf();t=null==t||t>n?n:t,e=null==e||e<n?n:e}return{min:null!=t?new Date(t):null,max:null!=e?new Date(e):null}},Ne.prototype.getEventProperties=function(t){var e=t.center?t.center.x:t.clientX,i=t.center?t.center.y:t.clientY,s=e-k.getAbsoluteLeft(this.dom.centerContainer),o=i-k.getAbsoluteTop(this.dom.centerContainer),n=this._toTime(s),r=mt.customTimeFromTarget(t),a=k.getTarget(t),h=null;k.hasParent(a,this.timeAxis.dom.foreground)||this.timeAxis2&&k.hasParent(a,this.timeAxis2.dom.foreground)?h="axis":k.hasParent(a,this.linegraph.yAxisLeft.dom.frame)||k.hasParent(a,this.linegraph.yAxisRight.dom.frame)?h="data-axis":k.hasParent(a,this.linegraph.legendLeft.dom.frame)||k.hasParent(a,this.linegraph.legendRight.dom.frame)?h="legend":null!=r?h="custom-time":k.hasParent(a,this.currentTime.bar)?h="current-time":k.hasParent(a,this.dom.center)&&(h="background");var l=[],d=this.linegraph.yAxisLeft,p=this.linegraph.yAxisRight;return!d.hidden&&this.itemsData.length>0&&l.push(d.screenToValue(o)),!p.hidden&&this.itemsData.length>0&&l.push(p.screenToValue(o)),{event:t,customTime:r?r.options.id:null,what:h,pageX:t.srcEvent?t.srcEvent.pageX:t.pageX,pageY:t.srcEvent?t.srcEvent.pageY:t.pageY,x:s,y:o,time:n,value:l}},Ne.prototype._createConfigurator=function(){return new se(this,this.dom.container,Ie)};const Pe=function(){try{return navigator?navigator.languages&&navigator.languages.length?navigator.languages:navigator.userLanguage||navigator.language||navigator.browserLanguage||"en":"en"}catch(t){return"en"}}();t.locale(Pe);const Ae={Core:ct,DateUtil:j,Range:B,stack:kt,TimeStep:U,components:{items:{Item:Mt,BackgroundItem:At,BoxItem:It,ClusterItem:Rt,PointItem:Nt,RangeItem:Pt},BackgroundGroup:Ot,Component:T,CurrentTime:ut,CustomTime:mt,DataAxis:ge,DataScale:ue,GraphGroup:we,Group:Et,ItemSet:jt,Legend:_e,LineGraph:De,TimeAxis:X}};export{Ne as Graph2d,oe as Timeline,Ae as timeline};
//# sourceMappingURL=vis-timeline-graph2d.min.js.map
