/**
 * vis-timeline and vis-graph2d
 * https://visjs.github.io/vis-timeline/
 *
 * Create a fully customizable, interactive timeline with items and ranges.
 *
 * @version 8.1.1
 * @date    2025-07-19T11:43:14.304Z
 *
 * @copyright (c) 2011-2017 Almende B.V, http://almende.com
 * @copyright (c) 2017-2019 visjs contributors, https://github.com/visjs
 *
 * @license
 * vis.js is dual licensed under both
 *
 *   1. The Apache 2.0 License
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *   and
 *
 *   2. The MIT License
 *      http://opensource.org/licenses/MIT
 *
 * vis.js may be distributed under either license.
 */
function t(t,e){void 0===e&&(e={});var i=e.insertAt;if(t&&"undefined"!=typeof document){var n=document.head||document.getElementsByTagName("head")[0],o=document.createElement("style");o.type="text/css","top"===i&&n.firstChild?n.insertBefore(o,n.firstChild):n.appendChild(o),o.styleSheet?o.styleSheet.cssText=t:o.appendChild(document.createTextNode(t))}}t(".vis .overlay{height:100%;left:0;position:absolute;top:0;width:100%;z-index:10}.vis-active{box-shadow:0 0 10px #86d5f8}");t(".vis [class*=span]{min-height:0;width:auto}");t('div.vis-configuration{display:block;float:left;font-size:12px;position:relative}div.vis-configuration-wrapper{display:block;width:700px}div.vis-configuration-wrapper:after{clear:both;content:"";display:block}div.vis-configuration.vis-config-option-container{background-color:#fff;border:2px solid #f7f8fa;border-radius:4px;display:block;left:10px;margin-top:20px;padding-left:5px;width:495px}div.vis-configuration.vis-config-button{background-color:#f7f8fa;border:2px solid #ceced0;border-radius:4px;cursor:pointer;display:block;height:25px;left:10px;line-height:25px;margin-bottom:30px;margin-top:20px;padding-left:5px;vertical-align:middle;width:495px}div.vis-configuration.vis-config-button.hover{background-color:#4588e6;border:2px solid #214373;color:#fff}div.vis-configuration.vis-config-item{display:block;float:left;height:25px;line-height:25px;vertical-align:middle;width:495px}div.vis-configuration.vis-config-item.vis-config-s2{background-color:#f7f8fa;border-radius:3px;left:10px;padding-left:5px}div.vis-configuration.vis-config-item.vis-config-s3{background-color:#e4e9f0;border-radius:3px;left:20px;padding-left:5px}div.vis-configuration.vis-config-item.vis-config-s4{background-color:#cfd8e6;border-radius:3px;left:30px;padding-left:5px}div.vis-configuration.vis-config-header{font-size:18px;font-weight:700}div.vis-configuration.vis-config-label{height:25px;line-height:25px;width:120px}div.vis-configuration.vis-config-label.vis-config-s3{width:110px}div.vis-configuration.vis-config-label.vis-config-s4{width:100px}div.vis-configuration.vis-config-colorBlock{border:1px solid #444;border-radius:2px;cursor:pointer;height:19px;margin:0;padding:0;top:1px;width:30px}input.vis-configuration.vis-config-checkbox{left:-5px}input.vis-configuration.vis-config-rangeinput{margin:0;padding:1px;pointer-events:none;position:relative;top:-5px;width:60px}input.vis-configuration.vis-config-range{-webkit-appearance:none;background-color:transparent;border:0 solid #fff;height:20px;width:300px}input.vis-configuration.vis-config-range::-webkit-slider-runnable-track{background:#dedede;background:-moz-linear-gradient(top,#dedede 0,#c8c8c8 99%);background:-webkit-gradient(linear,left top,left bottom,color-stop(0,#dedede),color-stop(99%,#c8c8c8));background:-webkit-linear-gradient(top,#dedede,#c8c8c8 99%);background:-o-linear-gradient(top,#dedede 0,#c8c8c8 99%);background:-ms-linear-gradient(top,#dedede 0,#c8c8c8 99%);background:linear-gradient(180deg,#dedede 0,#c8c8c8 99%);border:1px solid #999;border-radius:3px;box-shadow:0 0 3px 0 #aaa;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr="#dedede",endColorstr="#c8c8c8",GradientType=0);height:5px;width:300px}input.vis-configuration.vis-config-range::-webkit-slider-thumb{-webkit-appearance:none;background:#3876c2;background:-moz-linear-gradient(top,#3876c2 0,#385380 100%);background:-webkit-gradient(linear,left top,left bottom,color-stop(0,#3876c2),color-stop(100%,#385380));background:-webkit-linear-gradient(top,#3876c2,#385380);background:-o-linear-gradient(top,#3876c2 0,#385380 100%);background:-ms-linear-gradient(top,#3876c2 0,#385380 100%);background:linear-gradient(180deg,#3876c2 0,#385380);border:1px solid #14334b;border-radius:50%;box-shadow:0 0 1px 0 #111927;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr="#3876c2",endColorstr="#385380",GradientType=0);height:17px;margin-top:-7px;width:17px}input.vis-configuration.vis-config-range:focus{outline:none}input.vis-configuration.vis-config-range:focus::-webkit-slider-runnable-track{background:#9d9d9d;background:-moz-linear-gradient(top,#9d9d9d 0,#c8c8c8 99%);background:-webkit-gradient(linear,left top,left bottom,color-stop(0,#9d9d9d),color-stop(99%,#c8c8c8));background:-webkit-linear-gradient(top,#9d9d9d,#c8c8c8 99%);background:-o-linear-gradient(top,#9d9d9d 0,#c8c8c8 99%);background:-ms-linear-gradient(top,#9d9d9d 0,#c8c8c8 99%);background:linear-gradient(180deg,#9d9d9d 0,#c8c8c8 99%);filter:progid:DXImageTransform.Microsoft.gradient(startColorstr="#9d9d9d",endColorstr="#c8c8c8",GradientType=0)}input.vis-configuration.vis-config-range::-moz-range-track{background:#dedede;background:-moz-linear-gradient(top,#dedede 0,#c8c8c8 99%);background:-webkit-gradient(linear,left top,left bottom,color-stop(0,#dedede),color-stop(99%,#c8c8c8));background:-webkit-linear-gradient(top,#dedede,#c8c8c8 99%);background:-o-linear-gradient(top,#dedede 0,#c8c8c8 99%);background:-ms-linear-gradient(top,#dedede 0,#c8c8c8 99%);background:linear-gradient(180deg,#dedede 0,#c8c8c8 99%);border:1px solid #999;border-radius:3px;box-shadow:0 0 3px 0 #aaa;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr="#dedede",endColorstr="#c8c8c8",GradientType=0);height:10px;width:300px}input.vis-configuration.vis-config-range::-moz-range-thumb{background:#385380;border:none;border-radius:50%;height:16px;width:16px}input.vis-configuration.vis-config-range:-moz-focusring{outline:1px solid #fff;outline-offset:-1px}input.vis-configuration.vis-config-range::-ms-track{background:transparent;border-color:transparent;border-width:6px 0;color:transparent;height:5px;width:300px}input.vis-configuration.vis-config-range::-ms-fill-lower{background:#777;border-radius:10px}input.vis-configuration.vis-config-range::-ms-fill-upper{background:#ddd;border-radius:10px}input.vis-configuration.vis-config-range::-ms-thumb{background:#385380;border:none;border-radius:50%;height:16px;width:16px}input.vis-configuration.vis-config-range:focus::-ms-fill-lower{background:#888}input.vis-configuration.vis-config-range:focus::-ms-fill-upper{background:#ccc}.vis-configuration-popup{background:rgba(57,76,89,.85);border:2px solid #f2faff;border-radius:4px;color:#fff;font-size:14px;height:30px;line-height:30px;position:absolute;text-align:center;-webkit-transition:opacity .3s ease-in-out;-moz-transition:opacity .3s ease-in-out;transition:opacity .3s ease-in-out;width:150px}.vis-configuration-popup:after,.vis-configuration-popup:before{border:solid transparent;content:" ";height:0;left:100%;pointer-events:none;position:absolute;top:50%;width:0}.vis-configuration-popup:after{border-color:rgba(136,183,213,0) rgba(136,183,213,0) rgba(136,183,213,0) rgba(57,76,89,.85);border-width:8px;margin-top:-8px}.vis-configuration-popup:before{border-color:rgba(194,225,245,0) rgba(194,225,245,0) rgba(194,225,245,0) #f2faff;border-width:12px;margin-top:-12px}');t("div.vis-tooltip{background-color:#f5f4ed;border:1px solid #808074;-moz-border-radius:3px;-webkit-border-radius:3px;border-radius:3px;box-shadow:3px 3px 10px rgba(0,0,0,.2);color:#000;font-family:verdana;font-size:14px;padding:5px;pointer-events:none;position:absolute;visibility:hidden;white-space:nowrap;z-index:5}");t("");t('.vis-current-time{background-color:#ff7f6e;pointer-events:none;width:2px;z-index:1}.vis-rolling-mode-btn{background:#3876c2;border-radius:50%;color:#fff;cursor:pointer;font-size:28px;font-weight:700;height:40px;opacity:.8;position:absolute;right:20px;text-align:center;top:7px;width:40px}.vis-rolling-mode-btn:before{content:"\\26F6"}.vis-rolling-mode-btn:hover{opacity:1}');t(".vis-custom-time{background-color:#6e94ff;cursor:move;width:2px;z-index:1}.vis-custom-time>.vis-custom-time-marker{background-color:inherit;color:#fff;cursor:auto;font-size:12px;padding:3px 5px;top:0;white-space:nowrap;z-index:inherit}");t(".vis-panel.vis-background.vis-horizontal .vis-grid.vis-horizontal{border-bottom:1px solid;height:0;position:absolute;width:100%}.vis-panel.vis-background.vis-horizontal .vis-grid.vis-minor{border-color:#e5e5e5}.vis-panel.vis-background.vis-horizontal .vis-grid.vis-major{border-color:#bfbfbf}.vis-data-axis .vis-y-axis.vis-major{color:#4d4d4d;position:absolute;white-space:nowrap;width:100%}.vis-data-axis .vis-y-axis.vis-major.vis-measure{border:0;margin:0;padding:0;visibility:hidden;width:auto}.vis-data-axis .vis-y-axis.vis-minor{color:#bebebe;position:absolute;white-space:nowrap;width:100%}.vis-data-axis .vis-y-axis.vis-minor.vis-measure{border:0;margin:0;padding:0;visibility:hidden;width:auto}.vis-data-axis .vis-y-axis.vis-title{bottom:20px;color:#4d4d4d;position:absolute;text-align:center;white-space:nowrap}.vis-data-axis .vis-y-axis.vis-title.vis-measure{margin:0;padding:0;visibility:hidden;width:auto}.vis-data-axis .vis-y-axis.vis-title.vis-left{bottom:0;-webkit-transform:rotate(-90deg);-moz-transform:rotate(-90deg);-ms-transform:rotate(-90deg);-o-transform:rotate(-90deg);transform:rotate(-90deg);-webkit-transform-origin:left top;-moz-transform-origin:left top;-ms-transform-origin:left top;-o-transform-origin:left top;transform-origin:left bottom}.vis-data-axis .vis-y-axis.vis-title.vis-right{bottom:0;-webkit-transform:rotate(90deg);-moz-transform:rotate(90deg);-ms-transform:rotate(90deg);-o-transform:rotate(90deg);transform:rotate(90deg);-webkit-transform-origin:right bottom;-moz-transform-origin:right bottom;-ms-transform-origin:right bottom;-o-transform-origin:right bottom;transform-origin:right bottom}.vis-legend{background-color:rgba(247,252,255,.65);border:1px solid #b3b3b3;box-shadow:2px 2px 10px hsla(0,0%,60%,.55);padding:5px}.vis-legend-text{display:inline-block;white-space:nowrap}");t('.vis-item{background-color:#d5ddf6;border-color:#97b0f8;border-width:1px;color:#1a1a1a;display:inline-block;position:absolute;z-index:1}.vis-item.vis-selected{background-color:#fff785;border-color:#ffc200;z-index:2}.vis-editable.vis-selected{cursor:move}.vis-item.vis-point.vis-selected{background-color:#fff785}.vis-item.vis-box{border-radius:2px;border-style:solid;text-align:center}.vis-item.vis-point{background:none}.vis-item.vis-dot{border-radius:4px;border-style:solid;border-width:4px;padding:0;position:absolute}.vis-item.vis-range{border-radius:2px;border-style:solid;box-sizing:border-box}.vis-item.vis-background{background-color:rgba(213,221,246,.4);border:none;box-sizing:border-box;margin:0;padding:0}.vis-item .vis-item-overflow{height:100%;margin:0;overflow:hidden;padding:0;position:relative;width:100%}.vis-item-visible-frame{white-space:nowrap}.vis-item.vis-range .vis-item-content{display:inline-block;position:relative}.vis-item.vis-background .vis-item-content{display:inline-block;position:absolute}.vis-item.vis-line{border-left-style:solid;border-left-width:1px;padding:0;position:absolute;width:0}.vis-item .vis-item-content{box-sizing:border-box;padding:5px;white-space:nowrap}.vis-item .vis-onUpdateTime-tooltip{background:#4f81bd;border-radius:1px;color:#fff;padding:5px;position:absolute;text-align:center;transition:.4s;-o-transition:.4s;-moz-transition:.4s;-webkit-transition:.4s;white-space:nowrap;width:200px}.vis-item .vis-delete,.vis-item .vis-delete-rtl{box-sizing:border-box;cursor:pointer;height:24px;padding:0 5px;position:absolute;top:0;-webkit-transition:background .2s linear;-moz-transition:background .2s linear;-ms-transition:background .2s linear;-o-transition:background .2s linear;transition:background .2s linear;width:24px}.vis-item .vis-delete{right:-24px}.vis-item .vis-delete-rtl{left:-24px}.vis-item .vis-delete-rtl:after,.vis-item .vis-delete:after{color:red;content:"\\00D7";font-family:arial,sans-serif;font-size:22px;font-weight:700;-webkit-transition:color .2s linear;-moz-transition:color .2s linear;-ms-transition:color .2s linear;-o-transition:color .2s linear;transition:color .2s linear}.vis-item .vis-delete-rtl:hover,.vis-item .vis-delete:hover{background:red}.vis-item .vis-delete-rtl:hover:after,.vis-item .vis-delete:hover:after{color:#fff}.vis-item .vis-drag-center{cursor:move;height:100%;left:0;position:absolute;top:0;width:100%}.vis-item.vis-range .vis-drag-left{cursor:w-resize;left:-4px}.vis-item.vis-range .vis-drag-left,.vis-item.vis-range .vis-drag-right{height:100%;max-width:20%;min-width:2px;position:absolute;top:0;width:24px}.vis-item.vis-range .vis-drag-right{cursor:e-resize;right:-4px}.vis-range.vis-item.vis-readonly .vis-drag-left,.vis-range.vis-item.vis-readonly .vis-drag-right{cursor:auto}.vis-item.vis-cluster{border-radius:2px;border-style:solid;text-align:center;vertical-align:center}.vis-item.vis-cluster-line{border-left-style:solid;border-left-width:1px;padding:0;position:absolute;width:0}.vis-item.vis-cluster-dot{border-radius:4px;border-style:solid;border-width:4px;padding:0;position:absolute}');t('.vis-itemset{box-sizing:border-box;margin:0;padding:0;position:relative}.vis-itemset .vis-background,.vis-itemset .vis-foreground{height:100%;overflow:visible;position:absolute;width:100%}.vis-axis{height:0;left:0;position:absolute;width:100%;z-index:1}.vis-foreground .vis-group{border-bottom:1px solid #bfbfbf;box-sizing:border-box;position:relative}.vis-foreground .vis-group:last-child{border-bottom:none}.vis-nesting-group{cursor:pointer}.vis-label.vis-nested-group.vis-group-level-unknown-but-gte1{background:#f5f5f5}.vis-label.vis-nested-group.vis-group-level-0{background-color:#fff}.vis-ltr .vis-label.vis-nested-group.vis-group-level-0 .vis-inner{padding-left:0}.vis-rtl .vis-label.vis-nested-group.vis-group-level-0 .vis-inner{padding-right:0}.vis-label.vis-nested-group.vis-group-level-1{background-color:rgba(0,0,0,.05)}.vis-ltr .vis-label.vis-nested-group.vis-group-level-1 .vis-inner{padding-left:15px}.vis-rtl .vis-label.vis-nested-group.vis-group-level-1 .vis-inner{padding-right:15px}.vis-label.vis-nested-group.vis-group-level-2{background-color:rgba(0,0,0,.1)}.vis-ltr .vis-label.vis-nested-group.vis-group-level-2 .vis-inner{padding-left:30px}.vis-rtl .vis-label.vis-nested-group.vis-group-level-2 .vis-inner{padding-right:30px}.vis-label.vis-nested-group.vis-group-level-3{background-color:rgba(0,0,0,.15)}.vis-ltr .vis-label.vis-nested-group.vis-group-level-3 .vis-inner{padding-left:45px}.vis-rtl .vis-label.vis-nested-group.vis-group-level-3 .vis-inner{padding-right:45px}.vis-label.vis-nested-group.vis-group-level-4{background-color:rgba(0,0,0,.2)}.vis-ltr .vis-label.vis-nested-group.vis-group-level-4 .vis-inner{padding-left:60px}.vis-rtl .vis-label.vis-nested-group.vis-group-level-4 .vis-inner{padding-right:60px}.vis-label.vis-nested-group.vis-group-level-5{background-color:rgba(0,0,0,.25)}.vis-ltr .vis-label.vis-nested-group.vis-group-level-5 .vis-inner{padding-left:75px}.vis-rtl .vis-label.vis-nested-group.vis-group-level-5 .vis-inner{padding-right:75px}.vis-label.vis-nested-group.vis-group-level-6{background-color:rgba(0,0,0,.3)}.vis-ltr .vis-label.vis-nested-group.vis-group-level-6 .vis-inner{padding-left:90px}.vis-rtl .vis-label.vis-nested-group.vis-group-level-6 .vis-inner{padding-right:90px}.vis-label.vis-nested-group.vis-group-level-7{background-color:rgba(0,0,0,.35)}.vis-ltr .vis-label.vis-nested-group.vis-group-level-7 .vis-inner{padding-left:105px}.vis-rtl .vis-label.vis-nested-group.vis-group-level-7 .vis-inner{padding-right:105px}.vis-label.vis-nested-group.vis-group-level-8{background-color:rgba(0,0,0,.4)}.vis-ltr .vis-label.vis-nested-group.vis-group-level-8 .vis-inner{padding-left:120px}.vis-rtl .vis-label.vis-nested-group.vis-group-level-8 .vis-inner{padding-right:120px}.vis-label.vis-nested-group.vis-group-level-9{background-color:rgba(0,0,0,.45)}.vis-ltr .vis-label.vis-nested-group.vis-group-level-9 .vis-inner{padding-left:135px}.vis-rtl .vis-label.vis-nested-group.vis-group-level-9 .vis-inner{padding-right:135px}.vis-label.vis-nested-group{background-color:rgba(0,0,0,.5)}.vis-ltr .vis-label.vis-nested-group .vis-inner{padding-left:150px}.vis-rtl .vis-label.vis-nested-group .vis-inner{padding-right:150px}.vis-group-level-unknown-but-gte1{border:1px solid red}.vis-label.vis-nesting-group:before{display:inline-block;width:15px}.vis-label.vis-nesting-group.expanded:before{content:"\\25BC"}.vis-label.vis-nesting-group.collapsed:before{content:"\\25B6"}.vis-rtl .vis-label.vis-nesting-group.collapsed:before{content:"\\25C0"}.vis-ltr .vis-label:not(.vis-nesting-group):not(.vis-group-level-0){padding-left:15px}.vis-rtl .vis-label:not(.vis-nesting-group):not(.vis-group-level-0){padding-right:15px}.vis-overlay{height:100%;left:0;position:absolute;top:0;width:100%;z-index:10}');t(".vis-labelset{overflow:hidden}.vis-labelset,.vis-labelset .vis-label{box-sizing:border-box;position:relative}.vis-labelset .vis-label{border-bottom:1px solid #bfbfbf;color:#4d4d4d;left:0;top:0;width:100%}.vis-labelset .vis-label.draggable{cursor:pointer}.vis-group-is-dragging{background:rgba(0,0,0,.1)}.vis-labelset .vis-label:last-child{border-bottom:none}.vis-labelset .vis-label .vis-inner{display:inline-block;padding:5px}.vis-labelset .vis-label .vis-inner.vis-hidden{padding:0}");t(".vis-panel{box-sizing:border-box;margin:0;padding:0;position:absolute}.vis-panel.vis-bottom,.vis-panel.vis-center,.vis-panel.vis-left,.vis-panel.vis-right,.vis-panel.vis-top{border:1px #bfbfbf}.vis-panel.vis-center,.vis-panel.vis-left,.vis-panel.vis-right{border-bottom-style:solid;border-top-style:solid;overflow:hidden}.vis-left.vis-panel.vis-vertical-scroll,.vis-right.vis-panel.vis-vertical-scroll{height:100%;overflow-x:hidden;overflow-y:scroll}.vis-left.vis-panel.vis-vertical-scroll{direction:rtl}.vis-left.vis-panel.vis-vertical-scroll .vis-content,.vis-right.vis-panel.vis-vertical-scroll{direction:ltr}.vis-right.vis-panel.vis-vertical-scroll .vis-content{direction:rtl}.vis-panel.vis-bottom,.vis-panel.vis-center,.vis-panel.vis-top{border-left-style:solid;border-right-style:solid}.vis-background{overflow:hidden}.vis-panel>.vis-content{position:relative}.vis-panel .vis-shadow{box-shadow:0 0 10px rgba(0,0,0,.8);height:1px;position:absolute;width:100%}.vis-panel .vis-shadow.vis-top{left:0;top:-1px}.vis-panel .vis-shadow.vis-bottom{bottom:-1px;left:0}");t(".vis-graph-group0{fill:#4f81bd;fill-opacity:0;stroke-width:2px;stroke:#4f81bd}.vis-graph-group1{fill:#f79646;fill-opacity:0;stroke-width:2px;stroke:#f79646}.vis-graph-group2{fill:#8c51cf;fill-opacity:0;stroke-width:2px;stroke:#8c51cf}.vis-graph-group3{fill:#75c841;fill-opacity:0;stroke-width:2px;stroke:#75c841}.vis-graph-group4{fill:#ff0100;fill-opacity:0;stroke-width:2px;stroke:#ff0100}.vis-graph-group5{fill:#37d8e6;fill-opacity:0;stroke-width:2px;stroke:#37d8e6}.vis-graph-group6{fill:#042662;fill-opacity:0;stroke-width:2px;stroke:#042662}.vis-graph-group7{fill:#00ff26;fill-opacity:0;stroke-width:2px;stroke:#00ff26}.vis-graph-group8{fill:#f0f;fill-opacity:0;stroke-width:2px;stroke:#f0f}.vis-graph-group9{fill:#8f3938;fill-opacity:0;stroke-width:2px;stroke:#8f3938}.vis-timeline .vis-fill{fill-opacity:.1;stroke:none}.vis-timeline .vis-bar{fill-opacity:.5;stroke-width:1px}.vis-timeline .vis-point{stroke-width:2px;fill-opacity:1}.vis-timeline .vis-legend-background{stroke-width:1px;fill-opacity:.9;fill:#fff;stroke:#c2c2c2}.vis-timeline .vis-outline{stroke-width:1px;fill-opacity:1;fill:#fff;stroke:#e5e5e5}.vis-timeline .vis-icon-fill{fill-opacity:.3;stroke:none}");t(".vis-time-axis{overflow:hidden;position:relative}.vis-time-axis.vis-foreground{left:0;top:0;width:100%}.vis-time-axis.vis-background{height:100%;left:0;position:absolute;top:0;width:100%}.vis-time-axis .vis-text{box-sizing:border-box;color:#4d4d4d;overflow:hidden;padding:3px;position:absolute;white-space:nowrap}.vis-time-axis .vis-text.vis-measure{margin-left:0;margin-right:0;padding-left:0;padding-right:0;position:absolute;visibility:hidden}.vis-time-axis .vis-grid.vis-vertical{border-left:1px solid;position:absolute}.vis-time-axis .vis-grid.vis-vertical-rtl{border-right:1px solid;position:absolute}.vis-time-axis .vis-grid.vis-minor{border-color:#e5e5e5}.vis-time-axis .vis-grid.vis-major{border-color:#bfbfbf}");t(".vis-timeline{border:1px solid #bfbfbf;box-sizing:border-box;margin:0;overflow:hidden;padding:0;position:relative}.vis-loading-screen{height:100%;left:0;position:absolute;top:0;width:100%}");var e="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function n(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}function o(t){throw new Error('Could not dynamically require "'+t+'". Please configure the dynamicRequireTargets or/and ignoreDynamicRequires option of @rollup/plugin-commonjs appropriately for this require call to work.')}var s,r={exports:{}};function a(){return s||(s=1,(t=r).exports=function(){var e,i;function n(){return e.apply(null,arguments)}function s(t){e=t}function r(t){return t instanceof Array||"[object Array]"===Object.prototype.toString.call(t)}function a(t){return null!=t&&"[object Object]"===Object.prototype.toString.call(t)}function l(t,e){return Object.prototype.hasOwnProperty.call(t,e)}function h(t){if(Object.getOwnPropertyNames)return 0===Object.getOwnPropertyNames(t).length;var e;for(e in t)if(l(t,e))return!1;return!0}function d(t){return void 0===t}function c(t){return"number"==typeof t||"[object Number]"===Object.prototype.toString.call(t)}function u(t){return t instanceof Date||"[object Date]"===Object.prototype.toString.call(t)}function p(t,e){var i,n=[],o=t.length;for(i=0;i<o;++i)n.push(e(t[i],i));return n}function m(t,e){for(var i in e)l(e,i)&&(t[i]=e[i]);return l(e,"toString")&&(t.toString=e.toString),l(e,"valueOf")&&(t.valueOf=e.valueOf),t}function f(t,e,i,n){return qi(t,e,i,n,!0).utc()}function g(){return{empty:!1,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:!1,invalidEra:null,invalidMonth:null,invalidFormat:!1,userInvalidated:!1,iso:!1,parsedDateParts:[],era:null,meridiem:null,rfc2822:!1,weekdayMismatch:!1}}function v(t){return null==t._pf&&(t._pf=g()),t._pf}function b(t){var e=null,n=!1,o=t._d&&!isNaN(t._d.getTime());return o&&(e=v(t),n=i.call(e.parsedDateParts,function(t){return null!=t}),o=e.overflow<0&&!e.empty&&!e.invalidEra&&!e.invalidMonth&&!e.invalidWeekday&&!e.weekdayMismatch&&!e.nullInput&&!e.invalidFormat&&!e.userInvalidated&&(!e.meridiem||e.meridiem&&n),t._strict&&(o=o&&0===e.charsLeftOver&&0===e.unusedTokens.length&&void 0===e.bigHour)),null!=Object.isFrozen&&Object.isFrozen(t)?o:(t._isValid=o,t._isValid)}function y(t){var e=f(NaN);return null!=t?m(v(e),t):v(e).userInvalidated=!0,e}i=Array.prototype.some?Array.prototype.some:function(t){var e,i=Object(this),n=i.length>>>0;for(e=0;e<n;e++)if(e in i&&t.call(this,i[e],e,i))return!0;return!1};var _=n.momentProperties=[],w=!1;function x(t,e){var i,n,o,s=_.length;if(d(e._isAMomentObject)||(t._isAMomentObject=e._isAMomentObject),d(e._i)||(t._i=e._i),d(e._f)||(t._f=e._f),d(e._l)||(t._l=e._l),d(e._strict)||(t._strict=e._strict),d(e._tzm)||(t._tzm=e._tzm),d(e._isUTC)||(t._isUTC=e._isUTC),d(e._offset)||(t._offset=e._offset),d(e._pf)||(t._pf=v(e)),d(e._locale)||(t._locale=e._locale),s>0)for(i=0;i<s;i++)d(o=e[n=_[i]])||(t[n]=o);return t}function k(t){x(this,t),this._d=new Date(null!=t._d?t._d.getTime():NaN),this.isValid()||(this._d=new Date(NaN)),!1===w&&(w=!0,n.updateOffset(this),w=!1)}function D(t){return t instanceof k||null!=t&&null!=t._isAMomentObject}function S(t){!1===n.suppressDeprecationWarnings&&"undefined"!=typeof console&&console.warn&&console.warn("Deprecation warning: "+t)}function C(t,e){var i=!0;return m(function(){if(null!=n.deprecationHandler&&n.deprecationHandler(null,t),i){var o,s,r,a=[],h=arguments.length;for(s=0;s<h;s++){if(o="","object"==typeof arguments[s]){for(r in o+="\n["+s+"] ",arguments[0])l(arguments[0],r)&&(o+=r+": "+arguments[0][r]+", ");o=o.slice(0,-2)}else o=arguments[s];a.push(o)}S(t+"\nArguments: "+Array.prototype.slice.call(a).join("")+"\n"+(new Error).stack),i=!1}return e.apply(this,arguments)},e)}var T,M={};function O(t,e){null!=n.deprecationHandler&&n.deprecationHandler(t,e),M[t]||(S(e),M[t]=!0)}function E(t){return"undefined"!=typeof Function&&t instanceof Function||"[object Function]"===Object.prototype.toString.call(t)}function P(t){var e,i;for(i in t)l(t,i)&&(E(e=t[i])?this[i]=e:this["_"+i]=e);this._config=t,this._dayOfMonthOrdinalParseLenient=new RegExp((this._dayOfMonthOrdinalParse.source||this._ordinalParse.source)+"|"+/\d{1,2}/.source)}function A(t,e){var i,n=m({},t);for(i in e)l(e,i)&&(a(t[i])&&a(e[i])?(n[i]={},m(n[i],t[i]),m(n[i],e[i])):null!=e[i]?n[i]=e[i]:delete n[i]);for(i in t)l(t,i)&&!l(e,i)&&a(t[i])&&(n[i]=m({},n[i]));return n}function I(t){null!=t&&this.set(t)}n.suppressDeprecationWarnings=!1,n.deprecationHandler=null,T=Object.keys?Object.keys:function(t){var e,i=[];for(e in t)l(t,e)&&i.push(e);return i};var N={sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"};function L(t,e,i){var n=this._calendar[t]||this._calendar.sameElse;return E(n)?n.call(e,i):n}function F(t,e,i){var n=""+Math.abs(t),o=e-n.length;return(t>=0?i?"+":"":"-")+Math.pow(10,Math.max(0,o)).toString().substr(1)+n}var R=/(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|N{1,5}|YYYYYY|YYYYY|YYYY|YY|y{2,4}|yo?|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g,Y=/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g,j={},H={};function z(t,e,i,n){var o=n;"string"==typeof n&&(o=function(){return this[n]()}),t&&(H[t]=o),e&&(H[e[0]]=function(){return F(o.apply(this,arguments),e[1],e[2])}),i&&(H[i]=function(){return this.localeData().ordinal(o.apply(this,arguments),t)})}function G(t){return t.match(/\[[\s\S]/)?t.replace(/^\[|\]$/g,""):t.replace(/\\/g,"")}function W(t){var e,i,n=t.match(R);for(e=0,i=n.length;e<i;e++)H[n[e]]?n[e]=H[n[e]]:n[e]=G(n[e]);return function(e){var o,s="";for(o=0;o<i;o++)s+=E(n[o])?n[o].call(e,t):n[o];return s}}function B(t,e){return t.isValid()?(e=V(e,t.localeData()),j[e]=j[e]||W(e),j[e](t)):t.localeData().invalidDate()}function V(t,e){var i=5;function n(t){return e.longDateFormat(t)||t}for(Y.lastIndex=0;i>=0&&Y.test(t);)t=t.replace(Y,n),Y.lastIndex=0,i-=1;return t}var U={LTS:"h:mm:ss A",LT:"h:mm A",L:"MM/DD/YYYY",LL:"MMMM D, YYYY",LLL:"MMMM D, YYYY h:mm A",LLLL:"dddd, MMMM D, YYYY h:mm A"};function X(t){var e=this._longDateFormat[t],i=this._longDateFormat[t.toUpperCase()];return e||!i?e:(this._longDateFormat[t]=i.match(R).map(function(t){return"MMMM"===t||"MM"===t||"DD"===t||"dddd"===t?t.slice(1):t}).join(""),this._longDateFormat[t])}var q="Invalid date";function Z(){return this._invalidDate}var K="%d",$=/\d{1,2}/;function J(t){return this._ordinal.replace("%d",t)}var Q={future:"in %s",past:"%s ago",s:"a few seconds",ss:"%d seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",w:"a week",ww:"%d weeks",M:"a month",MM:"%d months",y:"a year",yy:"%d years"};function tt(t,e,i,n){var o=this._relativeTime[i];return E(o)?o(t,e,i,n):o.replace(/%d/i,t)}function et(t,e){var i=this._relativeTime[t>0?"future":"past"];return E(i)?i(e):i.replace(/%s/i,e)}var it={D:"date",dates:"date",date:"date",d:"day",days:"day",day:"day",e:"weekday",weekdays:"weekday",weekday:"weekday",E:"isoWeekday",isoweekdays:"isoWeekday",isoweekday:"isoWeekday",DDD:"dayOfYear",dayofyears:"dayOfYear",dayofyear:"dayOfYear",h:"hour",hours:"hour",hour:"hour",ms:"millisecond",milliseconds:"millisecond",millisecond:"millisecond",m:"minute",minutes:"minute",minute:"minute",M:"month",months:"month",month:"month",Q:"quarter",quarters:"quarter",quarter:"quarter",s:"second",seconds:"second",second:"second",gg:"weekYear",weekyears:"weekYear",weekyear:"weekYear",GG:"isoWeekYear",isoweekyears:"isoWeekYear",isoweekyear:"isoWeekYear",w:"week",weeks:"week",week:"week",W:"isoWeek",isoweeks:"isoWeek",isoweek:"isoWeek",y:"year",years:"year",year:"year"};function nt(t){return"string"==typeof t?it[t]||it[t.toLowerCase()]:void 0}function ot(t){var e,i,n={};for(i in t)l(t,i)&&(e=nt(i))&&(n[e]=t[i]);return n}var st={date:9,day:11,weekday:11,isoWeekday:11,dayOfYear:4,hour:13,millisecond:16,minute:14,month:8,quarter:7,second:15,weekYear:1,isoWeekYear:1,week:5,isoWeek:5,year:1};function rt(t){var e,i=[];for(e in t)l(t,e)&&i.push({unit:e,priority:st[e]});return i.sort(function(t,e){return t.priority-e.priority}),i}var at,lt=/\d/,ht=/\d\d/,dt=/\d{3}/,ct=/\d{4}/,ut=/[+-]?\d{6}/,pt=/\d\d?/,mt=/\d\d\d\d?/,ft=/\d\d\d\d\d\d?/,gt=/\d{1,3}/,vt=/\d{1,4}/,bt=/[+-]?\d{1,6}/,yt=/\d+/,_t=/[+-]?\d+/,wt=/Z|[+-]\d\d:?\d\d/gi,xt=/Z|[+-]\d\d(?::?\d\d)?/gi,kt=/[+-]?\d+(\.\d{1,3})?/,Dt=/[0-9]{0,256}['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFF07\uFF10-\uFFEF]{1,256}|[\u0600-\u06FF\/]{1,256}(\s*?[\u0600-\u06FF]{1,256}){1,2}/i,St=/^[1-9]\d?/,Ct=/^([1-9]\d|\d)/;function Tt(t,e,i){at[t]=E(e)?e:function(t,n){return t&&i?i:e}}function Mt(t,e){return l(at,t)?at[t](e._strict,e._locale):new RegExp(Ot(t))}function Ot(t){return Et(t.replace("\\","").replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g,function(t,e,i,n,o){return e||i||n||o}))}function Et(t){return t.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")}function Pt(t){return t<0?Math.ceil(t)||0:Math.floor(t)}function At(t){var e=+t,i=0;return 0!==e&&isFinite(e)&&(i=Pt(e)),i}at={};var It={};function Nt(t,e){var i,n,o=e;for("string"==typeof t&&(t=[t]),c(e)&&(o=function(t,i){i[e]=At(t)}),n=t.length,i=0;i<n;i++)It[t[i]]=o}function Lt(t,e){Nt(t,function(t,i,n,o){n._w=n._w||{},e(t,n._w,n,o)})}function Ft(t,e,i){null!=e&&l(It,t)&&It[t](e,i._a,i,t)}function Rt(t){return t%4==0&&t%100!=0||t%400==0}var Yt=0,jt=1,Ht=2,zt=3,Gt=4,Wt=5,Bt=6,Vt=7,Ut=8;function Xt(t){return Rt(t)?366:365}z("Y",0,0,function(){var t=this.year();return t<=9999?F(t,4):"+"+t}),z(0,["YY",2],0,function(){return this.year()%100}),z(0,["YYYY",4],0,"year"),z(0,["YYYYY",5],0,"year"),z(0,["YYYYYY",6,!0],0,"year"),Tt("Y",_t),Tt("YY",pt,ht),Tt("YYYY",vt,ct),Tt("YYYYY",bt,ut),Tt("YYYYYY",bt,ut),Nt(["YYYYY","YYYYYY"],Yt),Nt("YYYY",function(t,e){e[Yt]=2===t.length?n.parseTwoDigitYear(t):At(t)}),Nt("YY",function(t,e){e[Yt]=n.parseTwoDigitYear(t)}),Nt("Y",function(t,e){e[Yt]=parseInt(t,10)}),n.parseTwoDigitYear=function(t){return At(t)+(At(t)>68?1900:2e3)};var qt,Zt=$t("FullYear",!0);function Kt(){return Rt(this.year())}function $t(t,e){return function(i){return null!=i?(Qt(this,t,i),n.updateOffset(this,e),this):Jt(this,t)}}function Jt(t,e){if(!t.isValid())return NaN;var i=t._d,n=t._isUTC;switch(e){case"Milliseconds":return n?i.getUTCMilliseconds():i.getMilliseconds();case"Seconds":return n?i.getUTCSeconds():i.getSeconds();case"Minutes":return n?i.getUTCMinutes():i.getMinutes();case"Hours":return n?i.getUTCHours():i.getHours();case"Date":return n?i.getUTCDate():i.getDate();case"Day":return n?i.getUTCDay():i.getDay();case"Month":return n?i.getUTCMonth():i.getMonth();case"FullYear":return n?i.getUTCFullYear():i.getFullYear();default:return NaN}}function Qt(t,e,i){var n,o,s,r,a;if(t.isValid()&&!isNaN(i)){switch(n=t._d,o=t._isUTC,e){case"Milliseconds":return void(o?n.setUTCMilliseconds(i):n.setMilliseconds(i));case"Seconds":return void(o?n.setUTCSeconds(i):n.setSeconds(i));case"Minutes":return void(o?n.setUTCMinutes(i):n.setMinutes(i));case"Hours":return void(o?n.setUTCHours(i):n.setHours(i));case"Date":return void(o?n.setUTCDate(i):n.setDate(i));case"FullYear":break;default:return}s=i,r=t.month(),a=29!==(a=t.date())||1!==r||Rt(s)?a:28,o?n.setUTCFullYear(s,r,a):n.setFullYear(s,r,a)}}function te(t){return E(this[t=nt(t)])?this[t]():this}function ee(t,e){if("object"==typeof t){var i,n=rt(t=ot(t)),o=n.length;for(i=0;i<o;i++)this[n[i].unit](t[n[i].unit])}else if(E(this[t=nt(t)]))return this[t](e);return this}function ie(t,e){return(t%e+e)%e}function ne(t,e){if(isNaN(t)||isNaN(e))return NaN;var i=ie(e,12);return t+=(e-i)/12,1===i?Rt(t)?29:28:31-i%7%2}qt=Array.prototype.indexOf?Array.prototype.indexOf:function(t){var e;for(e=0;e<this.length;++e)if(this[e]===t)return e;return-1},z("M",["MM",2],"Mo",function(){return this.month()+1}),z("MMM",0,0,function(t){return this.localeData().monthsShort(this,t)}),z("MMMM",0,0,function(t){return this.localeData().months(this,t)}),Tt("M",pt,St),Tt("MM",pt,ht),Tt("MMM",function(t,e){return e.monthsShortRegex(t)}),Tt("MMMM",function(t,e){return e.monthsRegex(t)}),Nt(["M","MM"],function(t,e){e[jt]=At(t)-1}),Nt(["MMM","MMMM"],function(t,e,i,n){var o=i._locale.monthsParse(t,n,i._strict);null!=o?e[jt]=o:v(i).invalidMonth=t});var oe="January_February_March_April_May_June_July_August_September_October_November_December".split("_"),se="Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),re=/D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/,ae=Dt,le=Dt;function he(t,e){return t?r(this._months)?this._months[t.month()]:this._months[(this._months.isFormat||re).test(e)?"format":"standalone"][t.month()]:r(this._months)?this._months:this._months.standalone}function de(t,e){return t?r(this._monthsShort)?this._monthsShort[t.month()]:this._monthsShort[re.test(e)?"format":"standalone"][t.month()]:r(this._monthsShort)?this._monthsShort:this._monthsShort.standalone}function ce(t,e,i){var n,o,s,r=t.toLocaleLowerCase();if(!this._monthsParse)for(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[],n=0;n<12;++n)s=f([2e3,n]),this._shortMonthsParse[n]=this.monthsShort(s,"").toLocaleLowerCase(),this._longMonthsParse[n]=this.months(s,"").toLocaleLowerCase();return i?"MMM"===e?-1!==(o=qt.call(this._shortMonthsParse,r))?o:null:-1!==(o=qt.call(this._longMonthsParse,r))?o:null:"MMM"===e?-1!==(o=qt.call(this._shortMonthsParse,r))||-1!==(o=qt.call(this._longMonthsParse,r))?o:null:-1!==(o=qt.call(this._longMonthsParse,r))||-1!==(o=qt.call(this._shortMonthsParse,r))?o:null}function ue(t,e,i){var n,o,s;if(this._monthsParseExact)return ce.call(this,t,e,i);for(this._monthsParse||(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[]),n=0;n<12;n++){if(o=f([2e3,n]),i&&!this._longMonthsParse[n]&&(this._longMonthsParse[n]=new RegExp("^"+this.months(o,"").replace(".","")+"$","i"),this._shortMonthsParse[n]=new RegExp("^"+this.monthsShort(o,"").replace(".","")+"$","i")),i||this._monthsParse[n]||(s="^"+this.months(o,"")+"|^"+this.monthsShort(o,""),this._monthsParse[n]=new RegExp(s.replace(".",""),"i")),i&&"MMMM"===e&&this._longMonthsParse[n].test(t))return n;if(i&&"MMM"===e&&this._shortMonthsParse[n].test(t))return n;if(!i&&this._monthsParse[n].test(t))return n}}function pe(t,e){if(!t.isValid())return t;if("string"==typeof e)if(/^\d+$/.test(e))e=At(e);else if(!c(e=t.localeData().monthsParse(e)))return t;var i=e,n=t.date();return n=n<29?n:Math.min(n,ne(t.year(),i)),t._isUTC?t._d.setUTCMonth(i,n):t._d.setMonth(i,n),t}function me(t){return null!=t?(pe(this,t),n.updateOffset(this,!0),this):Jt(this,"Month")}function fe(){return ne(this.year(),this.month())}function ge(t){return this._monthsParseExact?(l(this,"_monthsRegex")||be.call(this),t?this._monthsShortStrictRegex:this._monthsShortRegex):(l(this,"_monthsShortRegex")||(this._monthsShortRegex=ae),this._monthsShortStrictRegex&&t?this._monthsShortStrictRegex:this._monthsShortRegex)}function ve(t){return this._monthsParseExact?(l(this,"_monthsRegex")||be.call(this),t?this._monthsStrictRegex:this._monthsRegex):(l(this,"_monthsRegex")||(this._monthsRegex=le),this._monthsStrictRegex&&t?this._monthsStrictRegex:this._monthsRegex)}function be(){function t(t,e){return e.length-t.length}var e,i,n,o,s=[],r=[],a=[];for(e=0;e<12;e++)i=f([2e3,e]),n=Et(this.monthsShort(i,"")),o=Et(this.months(i,"")),s.push(n),r.push(o),a.push(o),a.push(n);s.sort(t),r.sort(t),a.sort(t),this._monthsRegex=new RegExp("^("+a.join("|")+")","i"),this._monthsShortRegex=this._monthsRegex,this._monthsStrictRegex=new RegExp("^("+r.join("|")+")","i"),this._monthsShortStrictRegex=new RegExp("^("+s.join("|")+")","i")}function ye(t,e,i,n,o,s,r){var a;return t<100&&t>=0?(a=new Date(t+400,e,i,n,o,s,r),isFinite(a.getFullYear())&&a.setFullYear(t)):a=new Date(t,e,i,n,o,s,r),a}function _e(t){var e,i;return t<100&&t>=0?((i=Array.prototype.slice.call(arguments))[0]=t+400,e=new Date(Date.UTC.apply(null,i)),isFinite(e.getUTCFullYear())&&e.setUTCFullYear(t)):e=new Date(Date.UTC.apply(null,arguments)),e}function we(t,e,i){var n=7+e-i;return-(7+_e(t,0,n).getUTCDay()-e)%7+n-1}function xe(t,e,i,n,o){var s,r,a=1+7*(e-1)+(7+i-n)%7+we(t,n,o);return a<=0?r=Xt(s=t-1)+a:a>Xt(t)?(s=t+1,r=a-Xt(t)):(s=t,r=a),{year:s,dayOfYear:r}}function ke(t,e,i){var n,o,s=we(t.year(),e,i),r=Math.floor((t.dayOfYear()-s-1)/7)+1;return r<1?n=r+De(o=t.year()-1,e,i):r>De(t.year(),e,i)?(n=r-De(t.year(),e,i),o=t.year()+1):(o=t.year(),n=r),{week:n,year:o}}function De(t,e,i){var n=we(t,e,i),o=we(t+1,e,i);return(Xt(t)-n+o)/7}function Se(t){return ke(t,this._week.dow,this._week.doy).week}z("w",["ww",2],"wo","week"),z("W",["WW",2],"Wo","isoWeek"),Tt("w",pt,St),Tt("ww",pt,ht),Tt("W",pt,St),Tt("WW",pt,ht),Lt(["w","ww","W","WW"],function(t,e,i,n){e[n.substr(0,1)]=At(t)});var Ce={dow:0,doy:6};function Te(){return this._week.dow}function Me(){return this._week.doy}function Oe(t){var e=this.localeData().week(this);return null==t?e:this.add(7*(t-e),"d")}function Ee(t){var e=ke(this,1,4).week;return null==t?e:this.add(7*(t-e),"d")}function Pe(t,e){return"string"!=typeof t?t:isNaN(t)?"number"==typeof(t=e.weekdaysParse(t))?t:null:parseInt(t,10)}function Ae(t,e){return"string"==typeof t?e.weekdaysParse(t)%7||7:isNaN(t)?null:t}function Ie(t,e){return t.slice(e,7).concat(t.slice(0,e))}z("d",0,"do","day"),z("dd",0,0,function(t){return this.localeData().weekdaysMin(this,t)}),z("ddd",0,0,function(t){return this.localeData().weekdaysShort(this,t)}),z("dddd",0,0,function(t){return this.localeData().weekdays(this,t)}),z("e",0,0,"weekday"),z("E",0,0,"isoWeekday"),Tt("d",pt),Tt("e",pt),Tt("E",pt),Tt("dd",function(t,e){return e.weekdaysMinRegex(t)}),Tt("ddd",function(t,e){return e.weekdaysShortRegex(t)}),Tt("dddd",function(t,e){return e.weekdaysRegex(t)}),Lt(["dd","ddd","dddd"],function(t,e,i,n){var o=i._locale.weekdaysParse(t,n,i._strict);null!=o?e.d=o:v(i).invalidWeekday=t}),Lt(["d","e","E"],function(t,e,i,n){e[n]=At(t)});var Ne="Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),Le="Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),Fe="Su_Mo_Tu_We_Th_Fr_Sa".split("_"),Re=Dt,Ye=Dt,je=Dt;function He(t,e){var i=r(this._weekdays)?this._weekdays:this._weekdays[t&&!0!==t&&this._weekdays.isFormat.test(e)?"format":"standalone"];return!0===t?Ie(i,this._week.dow):t?i[t.day()]:i}function ze(t){return!0===t?Ie(this._weekdaysShort,this._week.dow):t?this._weekdaysShort[t.day()]:this._weekdaysShort}function Ge(t){return!0===t?Ie(this._weekdaysMin,this._week.dow):t?this._weekdaysMin[t.day()]:this._weekdaysMin}function We(t,e,i){var n,o,s,r=t.toLocaleLowerCase();if(!this._weekdaysParse)for(this._weekdaysParse=[],this._shortWeekdaysParse=[],this._minWeekdaysParse=[],n=0;n<7;++n)s=f([2e3,1]).day(n),this._minWeekdaysParse[n]=this.weekdaysMin(s,"").toLocaleLowerCase(),this._shortWeekdaysParse[n]=this.weekdaysShort(s,"").toLocaleLowerCase(),this._weekdaysParse[n]=this.weekdays(s,"").toLocaleLowerCase();return i?"dddd"===e?-1!==(o=qt.call(this._weekdaysParse,r))?o:null:"ddd"===e?-1!==(o=qt.call(this._shortWeekdaysParse,r))?o:null:-1!==(o=qt.call(this._minWeekdaysParse,r))?o:null:"dddd"===e?-1!==(o=qt.call(this._weekdaysParse,r))||-1!==(o=qt.call(this._shortWeekdaysParse,r))||-1!==(o=qt.call(this._minWeekdaysParse,r))?o:null:"ddd"===e?-1!==(o=qt.call(this._shortWeekdaysParse,r))||-1!==(o=qt.call(this._weekdaysParse,r))||-1!==(o=qt.call(this._minWeekdaysParse,r))?o:null:-1!==(o=qt.call(this._minWeekdaysParse,r))||-1!==(o=qt.call(this._weekdaysParse,r))||-1!==(o=qt.call(this._shortWeekdaysParse,r))?o:null}function Be(t,e,i){var n,o,s;if(this._weekdaysParseExact)return We.call(this,t,e,i);for(this._weekdaysParse||(this._weekdaysParse=[],this._minWeekdaysParse=[],this._shortWeekdaysParse=[],this._fullWeekdaysParse=[]),n=0;n<7;n++){if(o=f([2e3,1]).day(n),i&&!this._fullWeekdaysParse[n]&&(this._fullWeekdaysParse[n]=new RegExp("^"+this.weekdays(o,"").replace(".","\\.?")+"$","i"),this._shortWeekdaysParse[n]=new RegExp("^"+this.weekdaysShort(o,"").replace(".","\\.?")+"$","i"),this._minWeekdaysParse[n]=new RegExp("^"+this.weekdaysMin(o,"").replace(".","\\.?")+"$","i")),this._weekdaysParse[n]||(s="^"+this.weekdays(o,"")+"|^"+this.weekdaysShort(o,"")+"|^"+this.weekdaysMin(o,""),this._weekdaysParse[n]=new RegExp(s.replace(".",""),"i")),i&&"dddd"===e&&this._fullWeekdaysParse[n].test(t))return n;if(i&&"ddd"===e&&this._shortWeekdaysParse[n].test(t))return n;if(i&&"dd"===e&&this._minWeekdaysParse[n].test(t))return n;if(!i&&this._weekdaysParse[n].test(t))return n}}function Ve(t){if(!this.isValid())return null!=t?this:NaN;var e=Jt(this,"Day");return null!=t?(t=Pe(t,this.localeData()),this.add(t-e,"d")):e}function Ue(t){if(!this.isValid())return null!=t?this:NaN;var e=(this.day()+7-this.localeData()._week.dow)%7;return null==t?e:this.add(t-e,"d")}function Xe(t){if(!this.isValid())return null!=t?this:NaN;if(null!=t){var e=Ae(t,this.localeData());return this.day(this.day()%7?e:e-7)}return this.day()||7}function qe(t){return this._weekdaysParseExact?(l(this,"_weekdaysRegex")||$e.call(this),t?this._weekdaysStrictRegex:this._weekdaysRegex):(l(this,"_weekdaysRegex")||(this._weekdaysRegex=Re),this._weekdaysStrictRegex&&t?this._weekdaysStrictRegex:this._weekdaysRegex)}function Ze(t){return this._weekdaysParseExact?(l(this,"_weekdaysRegex")||$e.call(this),t?this._weekdaysShortStrictRegex:this._weekdaysShortRegex):(l(this,"_weekdaysShortRegex")||(this._weekdaysShortRegex=Ye),this._weekdaysShortStrictRegex&&t?this._weekdaysShortStrictRegex:this._weekdaysShortRegex)}function Ke(t){return this._weekdaysParseExact?(l(this,"_weekdaysRegex")||$e.call(this),t?this._weekdaysMinStrictRegex:this._weekdaysMinRegex):(l(this,"_weekdaysMinRegex")||(this._weekdaysMinRegex=je),this._weekdaysMinStrictRegex&&t?this._weekdaysMinStrictRegex:this._weekdaysMinRegex)}function $e(){function t(t,e){return e.length-t.length}var e,i,n,o,s,r=[],a=[],l=[],h=[];for(e=0;e<7;e++)i=f([2e3,1]).day(e),n=Et(this.weekdaysMin(i,"")),o=Et(this.weekdaysShort(i,"")),s=Et(this.weekdays(i,"")),r.push(n),a.push(o),l.push(s),h.push(n),h.push(o),h.push(s);r.sort(t),a.sort(t),l.sort(t),h.sort(t),this._weekdaysRegex=new RegExp("^("+h.join("|")+")","i"),this._weekdaysShortRegex=this._weekdaysRegex,this._weekdaysMinRegex=this._weekdaysRegex,this._weekdaysStrictRegex=new RegExp("^("+l.join("|")+")","i"),this._weekdaysShortStrictRegex=new RegExp("^("+a.join("|")+")","i"),this._weekdaysMinStrictRegex=new RegExp("^("+r.join("|")+")","i")}function Je(){return this.hours()%12||12}function Qe(){return this.hours()||24}function ti(t,e){z(t,0,0,function(){return this.localeData().meridiem(this.hours(),this.minutes(),e)})}function ei(t,e){return e._meridiemParse}function ii(t){return"p"===(t+"").toLowerCase().charAt(0)}z("H",["HH",2],0,"hour"),z("h",["hh",2],0,Je),z("k",["kk",2],0,Qe),z("hmm",0,0,function(){return""+Je.apply(this)+F(this.minutes(),2)}),z("hmmss",0,0,function(){return""+Je.apply(this)+F(this.minutes(),2)+F(this.seconds(),2)}),z("Hmm",0,0,function(){return""+this.hours()+F(this.minutes(),2)}),z("Hmmss",0,0,function(){return""+this.hours()+F(this.minutes(),2)+F(this.seconds(),2)}),ti("a",!0),ti("A",!1),Tt("a",ei),Tt("A",ei),Tt("H",pt,Ct),Tt("h",pt,St),Tt("k",pt,St),Tt("HH",pt,ht),Tt("hh",pt,ht),Tt("kk",pt,ht),Tt("hmm",mt),Tt("hmmss",ft),Tt("Hmm",mt),Tt("Hmmss",ft),Nt(["H","HH"],zt),Nt(["k","kk"],function(t,e,i){var n=At(t);e[zt]=24===n?0:n}),Nt(["a","A"],function(t,e,i){i._isPm=i._locale.isPM(t),i._meridiem=t}),Nt(["h","hh"],function(t,e,i){e[zt]=At(t),v(i).bigHour=!0}),Nt("hmm",function(t,e,i){var n=t.length-2;e[zt]=At(t.substr(0,n)),e[Gt]=At(t.substr(n)),v(i).bigHour=!0}),Nt("hmmss",function(t,e,i){var n=t.length-4,o=t.length-2;e[zt]=At(t.substr(0,n)),e[Gt]=At(t.substr(n,2)),e[Wt]=At(t.substr(o)),v(i).bigHour=!0}),Nt("Hmm",function(t,e,i){var n=t.length-2;e[zt]=At(t.substr(0,n)),e[Gt]=At(t.substr(n))}),Nt("Hmmss",function(t,e,i){var n=t.length-4,o=t.length-2;e[zt]=At(t.substr(0,n)),e[Gt]=At(t.substr(n,2)),e[Wt]=At(t.substr(o))});var ni=/[ap]\.?m?\.?/i,oi=$t("Hours",!0);function si(t,e,i){return t>11?i?"pm":"PM":i?"am":"AM"}var ri,ai={calendar:N,longDateFormat:U,invalidDate:q,ordinal:K,dayOfMonthOrdinalParse:$,relativeTime:Q,months:oe,monthsShort:se,week:Ce,weekdays:Ne,weekdaysMin:Fe,weekdaysShort:Le,meridiemParse:ni},li={},hi={};function di(t,e){var i,n=Math.min(t.length,e.length);for(i=0;i<n;i+=1)if(t[i]!==e[i])return i;return n}function ci(t){return t?t.toLowerCase().replace("_","-"):t}function ui(t){for(var e,i,n,o,s=0;s<t.length;){for(e=(o=ci(t[s]).split("-")).length,i=(i=ci(t[s+1]))?i.split("-"):null;e>0;){if(n=mi(o.slice(0,e).join("-")))return n;if(i&&i.length>=e&&di(o,i)>=e-1)break;e--}s++}return ri}function pi(t){return!(!t||!t.match("^[^/\\\\]*$"))}function mi(e){var i=null;if(void 0===li[e]&&t&&t.exports&&pi(e))try{i=ri._abbr,o("./locale/"+e),fi(i)}catch(t){li[e]=null}return li[e]}function fi(t,e){var i;return t&&((i=d(e)?bi(t):gi(t,e))?ri=i:"undefined"!=typeof console&&console.warn&&console.warn("Locale "+t+" not found. Did you forget to load it?")),ri._abbr}function gi(t,e){if(null!==e){var i,n=ai;if(e.abbr=t,null!=li[t])O("defineLocaleOverride","use moment.updateLocale(localeName, config) to change an existing locale. moment.defineLocale(localeName, config) should only be used for creating a new locale See http://momentjs.com/guides/#/warnings/define-locale/ for more info."),n=li[t]._config;else if(null!=e.parentLocale)if(null!=li[e.parentLocale])n=li[e.parentLocale]._config;else{if(null==(i=mi(e.parentLocale)))return hi[e.parentLocale]||(hi[e.parentLocale]=[]),hi[e.parentLocale].push({name:t,config:e}),null;n=i._config}return li[t]=new I(A(n,e)),hi[t]&&hi[t].forEach(function(t){gi(t.name,t.config)}),fi(t),li[t]}return delete li[t],null}function vi(t,e){if(null!=e){var i,n,o=ai;null!=li[t]&&null!=li[t].parentLocale?li[t].set(A(li[t]._config,e)):(null!=(n=mi(t))&&(o=n._config),e=A(o,e),null==n&&(e.abbr=t),(i=new I(e)).parentLocale=li[t],li[t]=i),fi(t)}else null!=li[t]&&(null!=li[t].parentLocale?(li[t]=li[t].parentLocale,t===fi()&&fi(t)):null!=li[t]&&delete li[t]);return li[t]}function bi(t){var e;if(t&&t._locale&&t._locale._abbr&&(t=t._locale._abbr),!t)return ri;if(!r(t)){if(e=mi(t))return e;t=[t]}return ui(t)}function yi(){return T(li)}function _i(t){var e,i=t._a;return i&&-2===v(t).overflow&&(e=i[jt]<0||i[jt]>11?jt:i[Ht]<1||i[Ht]>ne(i[Yt],i[jt])?Ht:i[zt]<0||i[zt]>24||24===i[zt]&&(0!==i[Gt]||0!==i[Wt]||0!==i[Bt])?zt:i[Gt]<0||i[Gt]>59?Gt:i[Wt]<0||i[Wt]>59?Wt:i[Bt]<0||i[Bt]>999?Bt:-1,v(t)._overflowDayOfYear&&(e<Yt||e>Ht)&&(e=Ht),v(t)._overflowWeeks&&-1===e&&(e=Vt),v(t)._overflowWeekday&&-1===e&&(e=Ut),v(t).overflow=e),t}var wi=/^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([+-]\d\d(?::?\d\d)?|\s*Z)?)?$/,xi=/^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d|))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([+-]\d\d(?::?\d\d)?|\s*Z)?)?$/,ki=/Z|[+-]\d\d(?::?\d\d)?/,Di=[["YYYYYY-MM-DD",/[+-]\d{6}-\d\d-\d\d/],["YYYY-MM-DD",/\d{4}-\d\d-\d\d/],["GGGG-[W]WW-E",/\d{4}-W\d\d-\d/],["GGGG-[W]WW",/\d{4}-W\d\d/,!1],["YYYY-DDD",/\d{4}-\d{3}/],["YYYY-MM",/\d{4}-\d\d/,!1],["YYYYYYMMDD",/[+-]\d{10}/],["YYYYMMDD",/\d{8}/],["GGGG[W]WWE",/\d{4}W\d{3}/],["GGGG[W]WW",/\d{4}W\d{2}/,!1],["YYYYDDD",/\d{7}/],["YYYYMM",/\d{6}/,!1],["YYYY",/\d{4}/,!1]],Si=[["HH:mm:ss.SSSS",/\d\d:\d\d:\d\d\.\d+/],["HH:mm:ss,SSSS",/\d\d:\d\d:\d\d,\d+/],["HH:mm:ss",/\d\d:\d\d:\d\d/],["HH:mm",/\d\d:\d\d/],["HHmmss.SSSS",/\d\d\d\d\d\d\.\d+/],["HHmmss,SSSS",/\d\d\d\d\d\d,\d+/],["HHmmss",/\d\d\d\d\d\d/],["HHmm",/\d\d\d\d/],["HH",/\d\d/]],Ci=/^\/?Date\((-?\d+)/i,Ti=/^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\d{4}))$/,Mi={UT:0,GMT:0,EDT:-240,EST:-300,CDT:-300,CST:-360,MDT:-360,MST:-420,PDT:-420,PST:-480};function Oi(t){var e,i,n,o,s,r,a=t._i,l=wi.exec(a)||xi.exec(a),h=Di.length,d=Si.length;if(l){for(v(t).iso=!0,e=0,i=h;e<i;e++)if(Di[e][1].exec(l[1])){o=Di[e][0],n=!1!==Di[e][2];break}if(null==o)return void(t._isValid=!1);if(l[3]){for(e=0,i=d;e<i;e++)if(Si[e][1].exec(l[3])){s=(l[2]||" ")+Si[e][0];break}if(null==s)return void(t._isValid=!1)}if(!n&&null!=s)return void(t._isValid=!1);if(l[4]){if(!ki.exec(l[4]))return void(t._isValid=!1);r="Z"}t._f=o+(s||"")+(r||""),zi(t)}else t._isValid=!1}function Ei(t,e,i,n,o,s){var r=[Pi(t),se.indexOf(e),parseInt(i,10),parseInt(n,10),parseInt(o,10)];return s&&r.push(parseInt(s,10)),r}function Pi(t){var e=parseInt(t,10);return e<=49?2e3+e:e<=999?1900+e:e}function Ai(t){return t.replace(/\([^()]*\)|[\n\t]/g," ").replace(/(\s\s+)/g," ").replace(/^\s\s*/,"").replace(/\s\s*$/,"")}function Ii(t,e,i){return!t||Le.indexOf(t)===new Date(e[0],e[1],e[2]).getDay()||(v(i).weekdayMismatch=!0,i._isValid=!1,!1)}function Ni(t,e,i){if(t)return Mi[t];if(e)return 0;var n=parseInt(i,10),o=n%100;return(n-o)/100*60+o}function Li(t){var e,i=Ti.exec(Ai(t._i));if(i){if(e=Ei(i[4],i[3],i[2],i[5],i[6],i[7]),!Ii(i[1],e,t))return;t._a=e,t._tzm=Ni(i[8],i[9],i[10]),t._d=_e.apply(null,t._a),t._d.setUTCMinutes(t._d.getUTCMinutes()-t._tzm),v(t).rfc2822=!0}else t._isValid=!1}function Fi(t){var e=Ci.exec(t._i);null===e?(Oi(t),!1===t._isValid&&(delete t._isValid,Li(t),!1===t._isValid&&(delete t._isValid,t._strict?t._isValid=!1:n.createFromInputFallback(t)))):t._d=new Date(+e[1])}function Ri(t,e,i){return null!=t?t:null!=e?e:i}function Yi(t){var e=new Date(n.now());return t._useUTC?[e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate()]:[e.getFullYear(),e.getMonth(),e.getDate()]}function ji(t){var e,i,n,o,s,r=[];if(!t._d){for(n=Yi(t),t._w&&null==t._a[Ht]&&null==t._a[jt]&&Hi(t),null!=t._dayOfYear&&(s=Ri(t._a[Yt],n[Yt]),(t._dayOfYear>Xt(s)||0===t._dayOfYear)&&(v(t)._overflowDayOfYear=!0),i=_e(s,0,t._dayOfYear),t._a[jt]=i.getUTCMonth(),t._a[Ht]=i.getUTCDate()),e=0;e<3&&null==t._a[e];++e)t._a[e]=r[e]=n[e];for(;e<7;e++)t._a[e]=r[e]=null==t._a[e]?2===e?1:0:t._a[e];24===t._a[zt]&&0===t._a[Gt]&&0===t._a[Wt]&&0===t._a[Bt]&&(t._nextDay=!0,t._a[zt]=0),t._d=(t._useUTC?_e:ye).apply(null,r),o=t._useUTC?t._d.getUTCDay():t._d.getDay(),null!=t._tzm&&t._d.setUTCMinutes(t._d.getUTCMinutes()-t._tzm),t._nextDay&&(t._a[zt]=24),t._w&&void 0!==t._w.d&&t._w.d!==o&&(v(t).weekdayMismatch=!0)}}function Hi(t){var e,i,n,o,s,r,a,l,h;null!=(e=t._w).GG||null!=e.W||null!=e.E?(s=1,r=4,i=Ri(e.GG,t._a[Yt],ke(Zi(),1,4).year),n=Ri(e.W,1),((o=Ri(e.E,1))<1||o>7)&&(l=!0)):(s=t._locale._week.dow,r=t._locale._week.doy,h=ke(Zi(),s,r),i=Ri(e.gg,t._a[Yt],h.year),n=Ri(e.w,h.week),null!=e.d?((o=e.d)<0||o>6)&&(l=!0):null!=e.e?(o=e.e+s,(e.e<0||e.e>6)&&(l=!0)):o=s),n<1||n>De(i,s,r)?v(t)._overflowWeeks=!0:null!=l?v(t)._overflowWeekday=!0:(a=xe(i,n,o,s,r),t._a[Yt]=a.year,t._dayOfYear=a.dayOfYear)}function zi(t){if(t._f!==n.ISO_8601)if(t._f!==n.RFC_2822){t._a=[],v(t).empty=!0;var e,i,o,s,r,a,l,h=""+t._i,d=h.length,c=0;for(l=(o=V(t._f,t._locale).match(R)||[]).length,e=0;e<l;e++)s=o[e],(i=(h.match(Mt(s,t))||[])[0])&&((r=h.substr(0,h.indexOf(i))).length>0&&v(t).unusedInput.push(r),h=h.slice(h.indexOf(i)+i.length),c+=i.length),H[s]?(i?v(t).empty=!1:v(t).unusedTokens.push(s),Ft(s,i,t)):t._strict&&!i&&v(t).unusedTokens.push(s);v(t).charsLeftOver=d-c,h.length>0&&v(t).unusedInput.push(h),t._a[zt]<=12&&!0===v(t).bigHour&&t._a[zt]>0&&(v(t).bigHour=void 0),v(t).parsedDateParts=t._a.slice(0),v(t).meridiem=t._meridiem,t._a[zt]=Gi(t._locale,t._a[zt],t._meridiem),null!==(a=v(t).era)&&(t._a[Yt]=t._locale.erasConvertYear(a,t._a[Yt])),ji(t),_i(t)}else Li(t);else Oi(t)}function Gi(t,e,i){var n;return null==i?e:null!=t.meridiemHour?t.meridiemHour(e,i):null!=t.isPM?((n=t.isPM(i))&&e<12&&(e+=12),n||12!==e||(e=0),e):e}function Wi(t){var e,i,n,o,s,r,a=!1,l=t._f.length;if(0===l)return v(t).invalidFormat=!0,void(t._d=new Date(NaN));for(o=0;o<l;o++)s=0,r=!1,e=x({},t),null!=t._useUTC&&(e._useUTC=t._useUTC),e._f=t._f[o],zi(e),b(e)&&(r=!0),s+=v(e).charsLeftOver,s+=10*v(e).unusedTokens.length,v(e).score=s,a?s<n&&(n=s,i=e):(null==n||s<n||r)&&(n=s,i=e,r&&(a=!0));m(t,i||e)}function Bi(t){if(!t._d){var e=ot(t._i),i=void 0===e.day?e.date:e.day;t._a=p([e.year,e.month,i,e.hour,e.minute,e.second,e.millisecond],function(t){return t&&parseInt(t,10)}),ji(t)}}function Vi(t){var e=new k(_i(Ui(t)));return e._nextDay&&(e.add(1,"d"),e._nextDay=void 0),e}function Ui(t){var e=t._i,i=t._f;return t._locale=t._locale||bi(t._l),null===e||void 0===i&&""===e?y({nullInput:!0}):("string"==typeof e&&(t._i=e=t._locale.preparse(e)),D(e)?new k(_i(e)):(u(e)?t._d=e:r(i)?Wi(t):i?zi(t):Xi(t),b(t)||(t._d=null),t))}function Xi(t){var e=t._i;d(e)?t._d=new Date(n.now()):u(e)?t._d=new Date(e.valueOf()):"string"==typeof e?Fi(t):r(e)?(t._a=p(e.slice(0),function(t){return parseInt(t,10)}),ji(t)):a(e)?Bi(t):c(e)?t._d=new Date(e):n.createFromInputFallback(t)}function qi(t,e,i,n,o){var s={};return!0!==e&&!1!==e||(n=e,e=void 0),!0!==i&&!1!==i||(n=i,i=void 0),(a(t)&&h(t)||r(t)&&0===t.length)&&(t=void 0),s._isAMomentObject=!0,s._useUTC=s._isUTC=o,s._l=i,s._i=t,s._f=e,s._strict=n,Vi(s)}function Zi(t,e,i,n){return qi(t,e,i,n,!1)}n.createFromInputFallback=C("value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are discouraged. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.",function(t){t._d=new Date(t._i+(t._useUTC?" UTC":""))}),n.ISO_8601=function(){},n.RFC_2822=function(){};var Ki=C("moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/",function(){var t=Zi.apply(null,arguments);return this.isValid()&&t.isValid()?t<this?this:t:y()}),$i=C("moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/",function(){var t=Zi.apply(null,arguments);return this.isValid()&&t.isValid()?t>this?this:t:y()});function Ji(t,e){var i,n;if(1===e.length&&r(e[0])&&(e=e[0]),!e.length)return Zi();for(i=e[0],n=1;n<e.length;++n)e[n].isValid()&&!e[n][t](i)||(i=e[n]);return i}function Qi(){return Ji("isBefore",[].slice.call(arguments,0))}function tn(){return Ji("isAfter",[].slice.call(arguments,0))}var en=function(){return Date.now?Date.now():+new Date},nn=["year","quarter","month","week","day","hour","minute","second","millisecond"];function on(t){var e,i,n=!1,o=nn.length;for(e in t)if(l(t,e)&&(-1===qt.call(nn,e)||null!=t[e]&&isNaN(t[e])))return!1;for(i=0;i<o;++i)if(t[nn[i]]){if(n)return!1;parseFloat(t[nn[i]])!==At(t[nn[i]])&&(n=!0)}return!0}function sn(){return this._isValid}function rn(){return On(NaN)}function an(t){var e=ot(t),i=e.year||0,n=e.quarter||0,o=e.month||0,s=e.week||e.isoWeek||0,r=e.day||0,a=e.hour||0,l=e.minute||0,h=e.second||0,d=e.millisecond||0;this._isValid=on(e),this._milliseconds=+d+1e3*h+6e4*l+1e3*a*60*60,this._days=+r+7*s,this._months=+o+3*n+12*i,this._data={},this._locale=bi(),this._bubble()}function ln(t){return t instanceof an}function hn(t){return t<0?-1*Math.round(-1*t):Math.round(t)}function dn(t,e,i){var n,o=Math.min(t.length,e.length),s=Math.abs(t.length-e.length),r=0;for(n=0;n<o;n++)At(t[n])!==At(e[n])&&r++;return r+s}function cn(t,e){z(t,0,0,function(){var t=this.utcOffset(),i="+";return t<0&&(t=-t,i="-"),i+F(~~(t/60),2)+e+F(~~t%60,2)})}cn("Z",":"),cn("ZZ",""),Tt("Z",xt),Tt("ZZ",xt),Nt(["Z","ZZ"],function(t,e,i){i._useUTC=!0,i._tzm=pn(xt,t)});var un=/([\+\-]|\d\d)/gi;function pn(t,e){var i,n,o=(e||"").match(t);return null===o?null:0===(n=60*(i=((o[o.length-1]||[])+"").match(un)||["-",0,0])[1]+At(i[2]))?0:"+"===i[0]?n:-n}function mn(t,e){var i,o;return e._isUTC?(i=e.clone(),o=(D(t)||u(t)?t.valueOf():Zi(t).valueOf())-i.valueOf(),i._d.setTime(i._d.valueOf()+o),n.updateOffset(i,!1),i):Zi(t).local()}function fn(t){return-Math.round(t._d.getTimezoneOffset())}function gn(t,e,i){var o,s=this._offset||0;if(!this.isValid())return null!=t?this:NaN;if(null!=t){if("string"==typeof t){if(null===(t=pn(xt,t)))return this}else Math.abs(t)<16&&!i&&(t*=60);return!this._isUTC&&e&&(o=fn(this)),this._offset=t,this._isUTC=!0,null!=o&&this.add(o,"m"),s!==t&&(!e||this._changeInProgress?Nn(this,On(t-s,"m"),1,!1):this._changeInProgress||(this._changeInProgress=!0,n.updateOffset(this,!0),this._changeInProgress=null)),this}return this._isUTC?s:fn(this)}function vn(t,e){return null!=t?("string"!=typeof t&&(t=-t),this.utcOffset(t,e),this):-this.utcOffset()}function bn(t){return this.utcOffset(0,t)}function yn(t){return this._isUTC&&(this.utcOffset(0,t),this._isUTC=!1,t&&this.subtract(fn(this),"m")),this}function _n(){if(null!=this._tzm)this.utcOffset(this._tzm,!1,!0);else if("string"==typeof this._i){var t=pn(wt,this._i);null!=t?this.utcOffset(t):this.utcOffset(0,!0)}return this}function wn(t){return!!this.isValid()&&(t=t?Zi(t).utcOffset():0,(this.utcOffset()-t)%60==0)}function xn(){return this.utcOffset()>this.clone().month(0).utcOffset()||this.utcOffset()>this.clone().month(5).utcOffset()}function kn(){if(!d(this._isDSTShifted))return this._isDSTShifted;var t,e={};return x(e,this),(e=Ui(e))._a?(t=e._isUTC?f(e._a):Zi(e._a),this._isDSTShifted=this.isValid()&&dn(e._a,t.toArray())>0):this._isDSTShifted=!1,this._isDSTShifted}function Dn(){return!!this.isValid()&&!this._isUTC}function Sn(){return!!this.isValid()&&this._isUTC}function Cn(){return!!this.isValid()&&this._isUTC&&0===this._offset}n.updateOffset=function(){};var Tn=/^(-|\+)?(?:(\d*)[. ])?(\d+):(\d+)(?::(\d+)(\.\d*)?)?$/,Mn=/^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;function On(t,e){var i,n,o,s=t,r=null;return ln(t)?s={ms:t._milliseconds,d:t._days,M:t._months}:c(t)||!isNaN(+t)?(s={},e?s[e]=+t:s.milliseconds=+t):(r=Tn.exec(t))?(i="-"===r[1]?-1:1,s={y:0,d:At(r[Ht])*i,h:At(r[zt])*i,m:At(r[Gt])*i,s:At(r[Wt])*i,ms:At(hn(1e3*r[Bt]))*i}):(r=Mn.exec(t))?(i="-"===r[1]?-1:1,s={y:En(r[2],i),M:En(r[3],i),w:En(r[4],i),d:En(r[5],i),h:En(r[6],i),m:En(r[7],i),s:En(r[8],i)}):null==s?s={}:"object"==typeof s&&("from"in s||"to"in s)&&(o=An(Zi(s.from),Zi(s.to)),(s={}).ms=o.milliseconds,s.M=o.months),n=new an(s),ln(t)&&l(t,"_locale")&&(n._locale=t._locale),ln(t)&&l(t,"_isValid")&&(n._isValid=t._isValid),n}function En(t,e){var i=t&&parseFloat(t.replace(",","."));return(isNaN(i)?0:i)*e}function Pn(t,e){var i={};return i.months=e.month()-t.month()+12*(e.year()-t.year()),t.clone().add(i.months,"M").isAfter(e)&&--i.months,i.milliseconds=+e-+t.clone().add(i.months,"M"),i}function An(t,e){var i;return t.isValid()&&e.isValid()?(e=mn(e,t),t.isBefore(e)?i=Pn(t,e):((i=Pn(e,t)).milliseconds=-i.milliseconds,i.months=-i.months),i):{milliseconds:0,months:0}}function In(t,e){return function(i,n){var o;return null===n||isNaN(+n)||(O(e,"moment()."+e+"(period, number) is deprecated. Please use moment()."+e+"(number, period). See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info."),o=i,i=n,n=o),Nn(this,On(i,n),t),this}}function Nn(t,e,i,o){var s=e._milliseconds,r=hn(e._days),a=hn(e._months);t.isValid()&&(o=null==o||o,a&&pe(t,Jt(t,"Month")+a*i),r&&Qt(t,"Date",Jt(t,"Date")+r*i),s&&t._d.setTime(t._d.valueOf()+s*i),o&&n.updateOffset(t,r||a))}On.fn=an.prototype,On.invalid=rn;var Ln=In(1,"add"),Fn=In(-1,"subtract");function Rn(t){return"string"==typeof t||t instanceof String}function Yn(t){return D(t)||u(t)||Rn(t)||c(t)||Hn(t)||jn(t)||null==t}function jn(t){var e,i,n=a(t)&&!h(t),o=!1,s=["years","year","y","months","month","M","days","day","d","dates","date","D","hours","hour","h","minutes","minute","m","seconds","second","s","milliseconds","millisecond","ms"],r=s.length;for(e=0;e<r;e+=1)i=s[e],o=o||l(t,i);return n&&o}function Hn(t){var e=r(t),i=!1;return e&&(i=0===t.filter(function(e){return!c(e)&&Rn(t)}).length),e&&i}function zn(t){var e,i,n=a(t)&&!h(t),o=!1,s=["sameDay","nextDay","lastDay","nextWeek","lastWeek","sameElse"];for(e=0;e<s.length;e+=1)i=s[e],o=o||l(t,i);return n&&o}function Gn(t,e){var i=t.diff(e,"days",!0);return i<-6?"sameElse":i<-1?"lastWeek":i<0?"lastDay":i<1?"sameDay":i<2?"nextDay":i<7?"nextWeek":"sameElse"}function Wn(t,e){1===arguments.length&&(arguments[0]?Yn(arguments[0])?(t=arguments[0],e=void 0):zn(arguments[0])&&(e=arguments[0],t=void 0):(t=void 0,e=void 0));var i=t||Zi(),o=mn(i,this).startOf("day"),s=n.calendarFormat(this,o)||"sameElse",r=e&&(E(e[s])?e[s].call(this,i):e[s]);return this.format(r||this.localeData().calendar(s,this,Zi(i)))}function Bn(){return new k(this)}function Vn(t,e){var i=D(t)?t:Zi(t);return!(!this.isValid()||!i.isValid())&&("millisecond"===(e=nt(e)||"millisecond")?this.valueOf()>i.valueOf():i.valueOf()<this.clone().startOf(e).valueOf())}function Un(t,e){var i=D(t)?t:Zi(t);return!(!this.isValid()||!i.isValid())&&("millisecond"===(e=nt(e)||"millisecond")?this.valueOf()<i.valueOf():this.clone().endOf(e).valueOf()<i.valueOf())}function Xn(t,e,i,n){var o=D(t)?t:Zi(t),s=D(e)?e:Zi(e);return!!(this.isValid()&&o.isValid()&&s.isValid())&&("("===(n=n||"()")[0]?this.isAfter(o,i):!this.isBefore(o,i))&&(")"===n[1]?this.isBefore(s,i):!this.isAfter(s,i))}function qn(t,e){var i,n=D(t)?t:Zi(t);return!(!this.isValid()||!n.isValid())&&("millisecond"===(e=nt(e)||"millisecond")?this.valueOf()===n.valueOf():(i=n.valueOf(),this.clone().startOf(e).valueOf()<=i&&i<=this.clone().endOf(e).valueOf()))}function Zn(t,e){return this.isSame(t,e)||this.isAfter(t,e)}function Kn(t,e){return this.isSame(t,e)||this.isBefore(t,e)}function $n(t,e,i){var n,o,s;if(!this.isValid())return NaN;if(!(n=mn(t,this)).isValid())return NaN;switch(o=6e4*(n.utcOffset()-this.utcOffset()),e=nt(e)){case"year":s=Jn(this,n)/12;break;case"month":s=Jn(this,n);break;case"quarter":s=Jn(this,n)/3;break;case"second":s=(this-n)/1e3;break;case"minute":s=(this-n)/6e4;break;case"hour":s=(this-n)/36e5;break;case"day":s=(this-n-o)/864e5;break;case"week":s=(this-n-o)/6048e5;break;default:s=this-n}return i?s:Pt(s)}function Jn(t,e){if(t.date()<e.date())return-Jn(e,t);var i=12*(e.year()-t.year())+(e.month()-t.month()),n=t.clone().add(i,"months");return-(i+(e-n<0?(e-n)/(n-t.clone().add(i-1,"months")):(e-n)/(t.clone().add(i+1,"months")-n)))||0}function Qn(){return this.clone().locale("en").format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ")}function to(t){if(!this.isValid())return null;var e=!0!==t,i=e?this.clone().utc():this;return i.year()<0||i.year()>9999?B(i,e?"YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]":"YYYYYY-MM-DD[T]HH:mm:ss.SSSZ"):E(Date.prototype.toISOString)?e?this.toDate().toISOString():new Date(this.valueOf()+60*this.utcOffset()*1e3).toISOString().replace("Z",B(i,"Z")):B(i,e?"YYYY-MM-DD[T]HH:mm:ss.SSS[Z]":"YYYY-MM-DD[T]HH:mm:ss.SSSZ")}function eo(){if(!this.isValid())return"moment.invalid(/* "+this._i+" */)";var t,e,i,n,o="moment",s="";return this.isLocal()||(o=0===this.utcOffset()?"moment.utc":"moment.parseZone",s="Z"),t="["+o+'("]',e=0<=this.year()&&this.year()<=9999?"YYYY":"YYYYYY",i="-MM-DD[T]HH:mm:ss.SSS",n=s+'[")]',this.format(t+e+i+n)}function io(t){t||(t=this.isUtc()?n.defaultFormatUtc:n.defaultFormat);var e=B(this,t);return this.localeData().postformat(e)}function no(t,e){return this.isValid()&&(D(t)&&t.isValid()||Zi(t).isValid())?On({to:this,from:t}).locale(this.locale()).humanize(!e):this.localeData().invalidDate()}function oo(t){return this.from(Zi(),t)}function so(t,e){return this.isValid()&&(D(t)&&t.isValid()||Zi(t).isValid())?On({from:this,to:t}).locale(this.locale()).humanize(!e):this.localeData().invalidDate()}function ro(t){return this.to(Zi(),t)}function ao(t){var e;return void 0===t?this._locale._abbr:(null!=(e=bi(t))&&(this._locale=e),this)}n.defaultFormat="YYYY-MM-DDTHH:mm:ssZ",n.defaultFormatUtc="YYYY-MM-DDTHH:mm:ss[Z]";var lo=C("moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.",function(t){return void 0===t?this.localeData():this.locale(t)});function ho(){return this._locale}var co=1e3,uo=60*co,po=60*uo,mo=3506328*po;function fo(t,e){return(t%e+e)%e}function go(t,e,i){return t<100&&t>=0?new Date(t+400,e,i)-mo:new Date(t,e,i).valueOf()}function vo(t,e,i){return t<100&&t>=0?Date.UTC(t+400,e,i)-mo:Date.UTC(t,e,i)}function bo(t){var e,i;if(void 0===(t=nt(t))||"millisecond"===t||!this.isValid())return this;switch(i=this._isUTC?vo:go,t){case"year":e=i(this.year(),0,1);break;case"quarter":e=i(this.year(),this.month()-this.month()%3,1);break;case"month":e=i(this.year(),this.month(),1);break;case"week":e=i(this.year(),this.month(),this.date()-this.weekday());break;case"isoWeek":e=i(this.year(),this.month(),this.date()-(this.isoWeekday()-1));break;case"day":case"date":e=i(this.year(),this.month(),this.date());break;case"hour":e=this._d.valueOf(),e-=fo(e+(this._isUTC?0:this.utcOffset()*uo),po);break;case"minute":e=this._d.valueOf(),e-=fo(e,uo);break;case"second":e=this._d.valueOf(),e-=fo(e,co)}return this._d.setTime(e),n.updateOffset(this,!0),this}function yo(t){var e,i;if(void 0===(t=nt(t))||"millisecond"===t||!this.isValid())return this;switch(i=this._isUTC?vo:go,t){case"year":e=i(this.year()+1,0,1)-1;break;case"quarter":e=i(this.year(),this.month()-this.month()%3+3,1)-1;break;case"month":e=i(this.year(),this.month()+1,1)-1;break;case"week":e=i(this.year(),this.month(),this.date()-this.weekday()+7)-1;break;case"isoWeek":e=i(this.year(),this.month(),this.date()-(this.isoWeekday()-1)+7)-1;break;case"day":case"date":e=i(this.year(),this.month(),this.date()+1)-1;break;case"hour":e=this._d.valueOf(),e+=po-fo(e+(this._isUTC?0:this.utcOffset()*uo),po)-1;break;case"minute":e=this._d.valueOf(),e+=uo-fo(e,uo)-1;break;case"second":e=this._d.valueOf(),e+=co-fo(e,co)-1}return this._d.setTime(e),n.updateOffset(this,!0),this}function _o(){return this._d.valueOf()-6e4*(this._offset||0)}function wo(){return Math.floor(this.valueOf()/1e3)}function xo(){return new Date(this.valueOf())}function ko(){var t=this;return[t.year(),t.month(),t.date(),t.hour(),t.minute(),t.second(),t.millisecond()]}function Do(){var t=this;return{years:t.year(),months:t.month(),date:t.date(),hours:t.hours(),minutes:t.minutes(),seconds:t.seconds(),milliseconds:t.milliseconds()}}function So(){return this.isValid()?this.toISOString():null}function Co(){return b(this)}function To(){return m({},v(this))}function Mo(){return v(this).overflow}function Oo(){return{input:this._i,format:this._f,locale:this._locale,isUTC:this._isUTC,strict:this._strict}}function Eo(t,e){var i,o,s,r=this._eras||bi("en")._eras;for(i=0,o=r.length;i<o;++i)switch("string"==typeof r[i].since&&(s=n(r[i].since).startOf("day"),r[i].since=s.valueOf()),typeof r[i].until){case"undefined":r[i].until=1/0;break;case"string":s=n(r[i].until).startOf("day").valueOf(),r[i].until=s.valueOf()}return r}function Po(t,e,i){var n,o,s,r,a,l=this.eras();for(t=t.toUpperCase(),n=0,o=l.length;n<o;++n)if(s=l[n].name.toUpperCase(),r=l[n].abbr.toUpperCase(),a=l[n].narrow.toUpperCase(),i)switch(e){case"N":case"NN":case"NNN":if(r===t)return l[n];break;case"NNNN":if(s===t)return l[n];break;case"NNNNN":if(a===t)return l[n]}else if([s,r,a].indexOf(t)>=0)return l[n]}function Ao(t,e){var i=t.since<=t.until?1:-1;return void 0===e?n(t.since).year():n(t.since).year()+(e-t.offset)*i}function Io(){var t,e,i,n=this.localeData().eras();for(t=0,e=n.length;t<e;++t){if(i=this.clone().startOf("day").valueOf(),n[t].since<=i&&i<=n[t].until)return n[t].name;if(n[t].until<=i&&i<=n[t].since)return n[t].name}return""}function No(){var t,e,i,n=this.localeData().eras();for(t=0,e=n.length;t<e;++t){if(i=this.clone().startOf("day").valueOf(),n[t].since<=i&&i<=n[t].until)return n[t].narrow;if(n[t].until<=i&&i<=n[t].since)return n[t].narrow}return""}function Lo(){var t,e,i,n=this.localeData().eras();for(t=0,e=n.length;t<e;++t){if(i=this.clone().startOf("day").valueOf(),n[t].since<=i&&i<=n[t].until)return n[t].abbr;if(n[t].until<=i&&i<=n[t].since)return n[t].abbr}return""}function Fo(){var t,e,i,o,s=this.localeData().eras();for(t=0,e=s.length;t<e;++t)if(i=s[t].since<=s[t].until?1:-1,o=this.clone().startOf("day").valueOf(),s[t].since<=o&&o<=s[t].until||s[t].until<=o&&o<=s[t].since)return(this.year()-n(s[t].since).year())*i+s[t].offset;return this.year()}function Ro(t){return l(this,"_erasNameRegex")||Bo.call(this),t?this._erasNameRegex:this._erasRegex}function Yo(t){return l(this,"_erasAbbrRegex")||Bo.call(this),t?this._erasAbbrRegex:this._erasRegex}function jo(t){return l(this,"_erasNarrowRegex")||Bo.call(this),t?this._erasNarrowRegex:this._erasRegex}function Ho(t,e){return e.erasAbbrRegex(t)}function zo(t,e){return e.erasNameRegex(t)}function Go(t,e){return e.erasNarrowRegex(t)}function Wo(t,e){return e._eraYearOrdinalRegex||yt}function Bo(){var t,e,i,n,o,s=[],r=[],a=[],l=[],h=this.eras();for(t=0,e=h.length;t<e;++t)i=Et(h[t].name),n=Et(h[t].abbr),o=Et(h[t].narrow),r.push(i),s.push(n),a.push(o),l.push(i),l.push(n),l.push(o);this._erasRegex=new RegExp("^("+l.join("|")+")","i"),this._erasNameRegex=new RegExp("^("+r.join("|")+")","i"),this._erasAbbrRegex=new RegExp("^("+s.join("|")+")","i"),this._erasNarrowRegex=new RegExp("^("+a.join("|")+")","i")}function Vo(t,e){z(0,[t,t.length],0,e)}function Uo(t){return Jo.call(this,t,this.week(),this.weekday()+this.localeData()._week.dow,this.localeData()._week.dow,this.localeData()._week.doy)}function Xo(t){return Jo.call(this,t,this.isoWeek(),this.isoWeekday(),1,4)}function qo(){return De(this.year(),1,4)}function Zo(){return De(this.isoWeekYear(),1,4)}function Ko(){var t=this.localeData()._week;return De(this.year(),t.dow,t.doy)}function $o(){var t=this.localeData()._week;return De(this.weekYear(),t.dow,t.doy)}function Jo(t,e,i,n,o){var s;return null==t?ke(this,n,o).year:(e>(s=De(t,n,o))&&(e=s),Qo.call(this,t,e,i,n,o))}function Qo(t,e,i,n,o){var s=xe(t,e,i,n,o),r=_e(s.year,0,s.dayOfYear);return this.year(r.getUTCFullYear()),this.month(r.getUTCMonth()),this.date(r.getUTCDate()),this}function ts(t){return null==t?Math.ceil((this.month()+1)/3):this.month(3*(t-1)+this.month()%3)}z("N",0,0,"eraAbbr"),z("NN",0,0,"eraAbbr"),z("NNN",0,0,"eraAbbr"),z("NNNN",0,0,"eraName"),z("NNNNN",0,0,"eraNarrow"),z("y",["y",1],"yo","eraYear"),z("y",["yy",2],0,"eraYear"),z("y",["yyy",3],0,"eraYear"),z("y",["yyyy",4],0,"eraYear"),Tt("N",Ho),Tt("NN",Ho),Tt("NNN",Ho),Tt("NNNN",zo),Tt("NNNNN",Go),Nt(["N","NN","NNN","NNNN","NNNNN"],function(t,e,i,n){var o=i._locale.erasParse(t,n,i._strict);o?v(i).era=o:v(i).invalidEra=t}),Tt("y",yt),Tt("yy",yt),Tt("yyy",yt),Tt("yyyy",yt),Tt("yo",Wo),Nt(["y","yy","yyy","yyyy"],Yt),Nt(["yo"],function(t,e,i,n){var o;i._locale._eraYearOrdinalRegex&&(o=t.match(i._locale._eraYearOrdinalRegex)),i._locale.eraYearOrdinalParse?e[Yt]=i._locale.eraYearOrdinalParse(t,o):e[Yt]=parseInt(t,10)}),z(0,["gg",2],0,function(){return this.weekYear()%100}),z(0,["GG",2],0,function(){return this.isoWeekYear()%100}),Vo("gggg","weekYear"),Vo("ggggg","weekYear"),Vo("GGGG","isoWeekYear"),Vo("GGGGG","isoWeekYear"),Tt("G",_t),Tt("g",_t),Tt("GG",pt,ht),Tt("gg",pt,ht),Tt("GGGG",vt,ct),Tt("gggg",vt,ct),Tt("GGGGG",bt,ut),Tt("ggggg",bt,ut),Lt(["gggg","ggggg","GGGG","GGGGG"],function(t,e,i,n){e[n.substr(0,2)]=At(t)}),Lt(["gg","GG"],function(t,e,i,o){e[o]=n.parseTwoDigitYear(t)}),z("Q",0,"Qo","quarter"),Tt("Q",lt),Nt("Q",function(t,e){e[jt]=3*(At(t)-1)}),z("D",["DD",2],"Do","date"),Tt("D",pt,St),Tt("DD",pt,ht),Tt("Do",function(t,e){return t?e._dayOfMonthOrdinalParse||e._ordinalParse:e._dayOfMonthOrdinalParseLenient}),Nt(["D","DD"],Ht),Nt("Do",function(t,e){e[Ht]=At(t.match(pt)[0])});var es=$t("Date",!0);function is(t){var e=Math.round((this.clone().startOf("day")-this.clone().startOf("year"))/864e5)+1;return null==t?e:this.add(t-e,"d")}z("DDD",["DDDD",3],"DDDo","dayOfYear"),Tt("DDD",gt),Tt("DDDD",dt),Nt(["DDD","DDDD"],function(t,e,i){i._dayOfYear=At(t)}),z("m",["mm",2],0,"minute"),Tt("m",pt,Ct),Tt("mm",pt,ht),Nt(["m","mm"],Gt);var ns=$t("Minutes",!1);z("s",["ss",2],0,"second"),Tt("s",pt,Ct),Tt("ss",pt,ht),Nt(["s","ss"],Wt);var os,ss,rs=$t("Seconds",!1);for(z("S",0,0,function(){return~~(this.millisecond()/100)}),z(0,["SS",2],0,function(){return~~(this.millisecond()/10)}),z(0,["SSS",3],0,"millisecond"),z(0,["SSSS",4],0,function(){return 10*this.millisecond()}),z(0,["SSSSS",5],0,function(){return 100*this.millisecond()}),z(0,["SSSSSS",6],0,function(){return 1e3*this.millisecond()}),z(0,["SSSSSSS",7],0,function(){return 1e4*this.millisecond()}),z(0,["SSSSSSSS",8],0,function(){return 1e5*this.millisecond()}),z(0,["SSSSSSSSS",9],0,function(){return 1e6*this.millisecond()}),Tt("S",gt,lt),Tt("SS",gt,ht),Tt("SSS",gt,dt),os="SSSS";os.length<=9;os+="S")Tt(os,yt);function as(t,e){e[Bt]=At(1e3*("0."+t))}for(os="S";os.length<=9;os+="S")Nt(os,as);function ls(){return this._isUTC?"UTC":""}function hs(){return this._isUTC?"Coordinated Universal Time":""}ss=$t("Milliseconds",!1),z("z",0,0,"zoneAbbr"),z("zz",0,0,"zoneName");var ds=k.prototype;function cs(t){return Zi(1e3*t)}function us(){return Zi.apply(null,arguments).parseZone()}function ps(t){return t}ds.add=Ln,ds.calendar=Wn,ds.clone=Bn,ds.diff=$n,ds.endOf=yo,ds.format=io,ds.from=no,ds.fromNow=oo,ds.to=so,ds.toNow=ro,ds.get=te,ds.invalidAt=Mo,ds.isAfter=Vn,ds.isBefore=Un,ds.isBetween=Xn,ds.isSame=qn,ds.isSameOrAfter=Zn,ds.isSameOrBefore=Kn,ds.isValid=Co,ds.lang=lo,ds.locale=ao,ds.localeData=ho,ds.max=$i,ds.min=Ki,ds.parsingFlags=To,ds.set=ee,ds.startOf=bo,ds.subtract=Fn,ds.toArray=ko,ds.toObject=Do,ds.toDate=xo,ds.toISOString=to,ds.inspect=eo,"undefined"!=typeof Symbol&&null!=Symbol.for&&(ds[Symbol.for("nodejs.util.inspect.custom")]=function(){return"Moment<"+this.format()+">"}),ds.toJSON=So,ds.toString=Qn,ds.unix=wo,ds.valueOf=_o,ds.creationData=Oo,ds.eraName=Io,ds.eraNarrow=No,ds.eraAbbr=Lo,ds.eraYear=Fo,ds.year=Zt,ds.isLeapYear=Kt,ds.weekYear=Uo,ds.isoWeekYear=Xo,ds.quarter=ds.quarters=ts,ds.month=me,ds.daysInMonth=fe,ds.week=ds.weeks=Oe,ds.isoWeek=ds.isoWeeks=Ee,ds.weeksInYear=Ko,ds.weeksInWeekYear=$o,ds.isoWeeksInYear=qo,ds.isoWeeksInISOWeekYear=Zo,ds.date=es,ds.day=ds.days=Ve,ds.weekday=Ue,ds.isoWeekday=Xe,ds.dayOfYear=is,ds.hour=ds.hours=oi,ds.minute=ds.minutes=ns,ds.second=ds.seconds=rs,ds.millisecond=ds.milliseconds=ss,ds.utcOffset=gn,ds.utc=bn,ds.local=yn,ds.parseZone=_n,ds.hasAlignedHourOffset=wn,ds.isDST=xn,ds.isLocal=Dn,ds.isUtcOffset=Sn,ds.isUtc=Cn,ds.isUTC=Cn,ds.zoneAbbr=ls,ds.zoneName=hs,ds.dates=C("dates accessor is deprecated. Use date instead.",es),ds.months=C("months accessor is deprecated. Use month instead",me),ds.years=C("years accessor is deprecated. Use year instead",Zt),ds.zone=C("moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/",vn),ds.isDSTShifted=C("isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information",kn);var ms=I.prototype;function fs(t,e,i,n){var o=bi(),s=f().set(n,e);return o[i](s,t)}function gs(t,e,i){if(c(t)&&(e=t,t=void 0),t=t||"",null!=e)return fs(t,e,i,"month");var n,o=[];for(n=0;n<12;n++)o[n]=fs(t,n,i,"month");return o}function vs(t,e,i,n){"boolean"==typeof t?(c(e)&&(i=e,e=void 0),e=e||""):(i=e=t,t=!1,c(e)&&(i=e,e=void 0),e=e||"");var o,s=bi(),r=t?s._week.dow:0,a=[];if(null!=i)return fs(e,(i+r)%7,n,"day");for(o=0;o<7;o++)a[o]=fs(e,(o+r)%7,n,"day");return a}function bs(t,e){return gs(t,e,"months")}function ys(t,e){return gs(t,e,"monthsShort")}function _s(t,e,i){return vs(t,e,i,"weekdays")}function ws(t,e,i){return vs(t,e,i,"weekdaysShort")}function xs(t,e,i){return vs(t,e,i,"weekdaysMin")}ms.calendar=L,ms.longDateFormat=X,ms.invalidDate=Z,ms.ordinal=J,ms.preparse=ps,ms.postformat=ps,ms.relativeTime=tt,ms.pastFuture=et,ms.set=P,ms.eras=Eo,ms.erasParse=Po,ms.erasConvertYear=Ao,ms.erasAbbrRegex=Yo,ms.erasNameRegex=Ro,ms.erasNarrowRegex=jo,ms.months=he,ms.monthsShort=de,ms.monthsParse=ue,ms.monthsRegex=ve,ms.monthsShortRegex=ge,ms.week=Se,ms.firstDayOfYear=Me,ms.firstDayOfWeek=Te,ms.weekdays=He,ms.weekdaysMin=Ge,ms.weekdaysShort=ze,ms.weekdaysParse=Be,ms.weekdaysRegex=qe,ms.weekdaysShortRegex=Ze,ms.weekdaysMinRegex=Ke,ms.isPM=ii,ms.meridiem=si,fi("en",{eras:[{since:"0001-01-01",until:1/0,offset:1,name:"Anno Domini",narrow:"AD",abbr:"AD"},{since:"0000-12-31",until:-1/0,offset:1,name:"Before Christ",narrow:"BC",abbr:"BC"}],dayOfMonthOrdinalParse:/\d{1,2}(th|st|nd|rd)/,ordinal:function(t){var e=t%10;return t+(1===At(t%100/10)?"th":1===e?"st":2===e?"nd":3===e?"rd":"th")}}),n.lang=C("moment.lang is deprecated. Use moment.locale instead.",fi),n.langData=C("moment.langData is deprecated. Use moment.localeData instead.",bi);var ks=Math.abs;function Ds(){var t=this._data;return this._milliseconds=ks(this._milliseconds),this._days=ks(this._days),this._months=ks(this._months),t.milliseconds=ks(t.milliseconds),t.seconds=ks(t.seconds),t.minutes=ks(t.minutes),t.hours=ks(t.hours),t.months=ks(t.months),t.years=ks(t.years),this}function Ss(t,e,i,n){var o=On(e,i);return t._milliseconds+=n*o._milliseconds,t._days+=n*o._days,t._months+=n*o._months,t._bubble()}function Cs(t,e){return Ss(this,t,e,1)}function Ts(t,e){return Ss(this,t,e,-1)}function Ms(t){return t<0?Math.floor(t):Math.ceil(t)}function Os(){var t,e,i,n,o,s=this._milliseconds,r=this._days,a=this._months,l=this._data;return s>=0&&r>=0&&a>=0||s<=0&&r<=0&&a<=0||(s+=864e5*Ms(Ps(a)+r),r=0,a=0),l.milliseconds=s%1e3,t=Pt(s/1e3),l.seconds=t%60,e=Pt(t/60),l.minutes=e%60,i=Pt(e/60),l.hours=i%24,r+=Pt(i/24),a+=o=Pt(Es(r)),r-=Ms(Ps(o)),n=Pt(a/12),a%=12,l.days=r,l.months=a,l.years=n,this}function Es(t){return 4800*t/146097}function Ps(t){return 146097*t/4800}function As(t){if(!this.isValid())return NaN;var e,i,n=this._milliseconds;if("month"===(t=nt(t))||"quarter"===t||"year"===t)switch(e=this._days+n/864e5,i=this._months+Es(e),t){case"month":return i;case"quarter":return i/3;case"year":return i/12}else switch(e=this._days+Math.round(Ps(this._months)),t){case"week":return e/7+n/6048e5;case"day":return e+n/864e5;case"hour":return 24*e+n/36e5;case"minute":return 1440*e+n/6e4;case"second":return 86400*e+n/1e3;case"millisecond":return Math.floor(864e5*e)+n;default:throw new Error("Unknown unit "+t)}}function Is(t){return function(){return this.as(t)}}var Ns=Is("ms"),Ls=Is("s"),Fs=Is("m"),Rs=Is("h"),Ys=Is("d"),js=Is("w"),Hs=Is("M"),zs=Is("Q"),Gs=Is("y"),Ws=Ns;function Bs(){return On(this)}function Vs(t){return t=nt(t),this.isValid()?this[t+"s"]():NaN}function Us(t){return function(){return this.isValid()?this._data[t]:NaN}}var Xs=Us("milliseconds"),qs=Us("seconds"),Zs=Us("minutes"),Ks=Us("hours"),$s=Us("days"),Js=Us("months"),Qs=Us("years");function tr(){return Pt(this.days()/7)}var er=Math.round,ir={ss:44,s:45,m:45,h:22,d:26,w:null,M:11};function nr(t,e,i,n,o){return o.relativeTime(e||1,!!i,t,n)}function or(t,e,i,n){var o=On(t).abs(),s=er(o.as("s")),r=er(o.as("m")),a=er(o.as("h")),l=er(o.as("d")),h=er(o.as("M")),d=er(o.as("w")),c=er(o.as("y")),u=s<=i.ss&&["s",s]||s<i.s&&["ss",s]||r<=1&&["m"]||r<i.m&&["mm",r]||a<=1&&["h"]||a<i.h&&["hh",a]||l<=1&&["d"]||l<i.d&&["dd",l];return null!=i.w&&(u=u||d<=1&&["w"]||d<i.w&&["ww",d]),(u=u||h<=1&&["M"]||h<i.M&&["MM",h]||c<=1&&["y"]||["yy",c])[2]=e,u[3]=+t>0,u[4]=n,nr.apply(null,u)}function sr(t){return void 0===t?er:"function"==typeof t&&(er=t,!0)}function rr(t,e){return void 0!==ir[t]&&(void 0===e?ir[t]:(ir[t]=e,"s"===t&&(ir.ss=e-1),!0))}function ar(t,e){if(!this.isValid())return this.localeData().invalidDate();var i,n,o=!1,s=ir;return"object"==typeof t&&(e=t,t=!1),"boolean"==typeof t&&(o=t),"object"==typeof e&&(s=Object.assign({},ir,e),null!=e.s&&null==e.ss&&(s.ss=e.s-1)),n=or(this,!o,s,i=this.localeData()),o&&(n=i.pastFuture(+this,n)),i.postformat(n)}var lr=Math.abs;function hr(t){return(t>0)-(t<0)||+t}function dr(){if(!this.isValid())return this.localeData().invalidDate();var t,e,i,n,o,s,r,a,l=lr(this._milliseconds)/1e3,h=lr(this._days),d=lr(this._months),c=this.asSeconds();return c?(t=Pt(l/60),e=Pt(t/60),l%=60,t%=60,i=Pt(d/12),d%=12,n=l?l.toFixed(3).replace(/\.?0+$/,""):"",o=c<0?"-":"",s=hr(this._months)!==hr(c)?"-":"",r=hr(this._days)!==hr(c)?"-":"",a=hr(this._milliseconds)!==hr(c)?"-":"",o+"P"+(i?s+i+"Y":"")+(d?s+d+"M":"")+(h?r+h+"D":"")+(e||t||l?"T":"")+(e?a+e+"H":"")+(t?a+t+"M":"")+(l?a+n+"S":"")):"P0D"}var cr=an.prototype;return cr.isValid=sn,cr.abs=Ds,cr.add=Cs,cr.subtract=Ts,cr.as=As,cr.asMilliseconds=Ns,cr.asSeconds=Ls,cr.asMinutes=Fs,cr.asHours=Rs,cr.asDays=Ys,cr.asWeeks=js,cr.asMonths=Hs,cr.asQuarters=zs,cr.asYears=Gs,cr.valueOf=Ws,cr._bubble=Os,cr.clone=Bs,cr.get=Vs,cr.milliseconds=Xs,cr.seconds=qs,cr.minutes=Zs,cr.hours=Ks,cr.days=$s,cr.weeks=tr,cr.months=Js,cr.years=Qs,cr.humanize=ar,cr.toISOString=dr,cr.toString=dr,cr.toJSON=dr,cr.locale=ao,cr.localeData=ho,cr.toIsoString=C("toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)",dr),cr.lang=lo,z("X",0,0,"unix"),z("x",0,0,"valueOf"),Tt("x",_t),Tt("X",kt),Nt("X",function(t,e,i){i._d=new Date(1e3*parseFloat(t))}),Nt("x",function(t,e,i){i._d=new Date(At(t))}),
//! moment.js
n.version="2.30.1",s(Zi),n.fn=ds,n.min=Qi,n.max=tn,n.now=en,n.utc=f,n.unix=cs,n.months=bs,n.isDate=u,n.locale=fi,n.invalid=y,n.duration=On,n.isMoment=D,n.weekdays=_s,n.parseZone=us,n.localeData=bi,n.isDuration=ln,n.monthsShort=ys,n.weekdaysMin=xs,n.defineLocale=gi,n.updateLocale=vi,n.locales=yi,n.weekdaysShort=ws,n.normalizeUnits=nt,n.relativeTimeRounding=sr,n.relativeTimeThreshold=rr,n.calendarFormat=Gn,n.prototype=ds,n.HTML5_FMT={DATETIME_LOCAL:"YYYY-MM-DDTHH:mm",DATETIME_LOCAL_SECONDS:"YYYY-MM-DDTHH:mm:ss",DATETIME_LOCAL_MS:"YYYY-MM-DDTHH:mm:ss.SSS",DATE:"YYYY-MM-DD",TIME:"HH:mm",TIME_SECONDS:"HH:mm:ss",TIME_MS:"HH:mm:ss.SSS",WEEK:"GGGG-[W]WW",MONTH:"YYYY-MM"},n}()),r.exports;var t}var l,h;l||(l=1,h=function(t){
//! moment.js locale configuration
function e(t,e,i,n){var o={m:["eine Minute","einer Minute"],h:["eine Stunde","einer Stunde"],d:["ein Tag","einem Tag"],dd:[t+" Tage",t+" Tagen"],w:["eine Woche","einer Woche"],M:["ein Monat","einem Monat"],MM:[t+" Monate",t+" Monaten"],y:["ein Jahr","einem Jahr"],yy:[t+" Jahre",t+" Jahren"]};return e?o[i][0]:o[i][1]}return t.defineLocale("de",{months:"Januar_Februar_März_April_Mai_Juni_Juli_August_September_Oktober_November_Dezember".split("_"),monthsShort:"Jan._Feb._März_Apr._Mai_Juni_Juli_Aug._Sep._Okt._Nov._Dez.".split("_"),monthsParseExact:!0,weekdays:"Sonntag_Montag_Dienstag_Mittwoch_Donnerstag_Freitag_Samstag".split("_"),weekdaysShort:"So._Mo._Di._Mi._Do._Fr._Sa.".split("_"),weekdaysMin:"So_Mo_Di_Mi_Do_Fr_Sa".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY HH:mm",LLLL:"dddd, D. MMMM YYYY HH:mm"},calendar:{sameDay:"[heute um] LT [Uhr]",sameElse:"L",nextDay:"[morgen um] LT [Uhr]",nextWeek:"dddd [um] LT [Uhr]",lastDay:"[gestern um] LT [Uhr]",lastWeek:"[letzten] dddd [um] LT [Uhr]"},relativeTime:{future:"in %s",past:"vor %s",s:"ein paar Sekunden",ss:"%d Sekunden",m:e,mm:"%d Minuten",h:e,hh:"%d Stunden",d:e,dd:e,w:e,ww:"%d Wochen",M:e,MM:e,y:e,yy:e},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}})},h(a()));var d;d||(d=1,function(t,e){e(a())}(0,function(t){
//! moment.js locale configuration
var e="ene._feb._mar._abr._may._jun._jul._ago._sep._oct._nov._dic.".split("_"),i="ene_feb_mar_abr_may_jun_jul_ago_sep_oct_nov_dic".split("_"),n=[/^ene/i,/^feb/i,/^mar/i,/^abr/i,/^may/i,/^jun/i,/^jul/i,/^ago/i,/^sep/i,/^oct/i,/^nov/i,/^dic/i],o=/^(enero|febrero|marzo|abril|mayo|junio|julio|agosto|septiembre|octubre|noviembre|diciembre|ene\.?|feb\.?|mar\.?|abr\.?|may\.?|jun\.?|jul\.?|ago\.?|sep\.?|oct\.?|nov\.?|dic\.?)/i;return t.defineLocale("es",{months:"enero_febrero_marzo_abril_mayo_junio_julio_agosto_septiembre_octubre_noviembre_diciembre".split("_"),monthsShort:function(t,n){return t?/-MMM-/.test(n)?i[t.month()]:e[t.month()]:e},monthsRegex:o,monthsShortRegex:o,monthsStrictRegex:/^(enero|febrero|marzo|abril|mayo|junio|julio|agosto|septiembre|octubre|noviembre|diciembre)/i,monthsShortStrictRegex:/^(ene\.?|feb\.?|mar\.?|abr\.?|may\.?|jun\.?|jul\.?|ago\.?|sep\.?|oct\.?|nov\.?|dic\.?)/i,monthsParse:n,longMonthsParse:n,shortMonthsParse:n,weekdays:"domingo_lunes_martes_miércoles_jueves_viernes_sábado".split("_"),weekdaysShort:"dom._lun._mar._mié._jue._vie._sáb.".split("_"),weekdaysMin:"do_lu_ma_mi_ju_vi_sá".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD/MM/YYYY",LL:"D [de] MMMM [de] YYYY",LLL:"D [de] MMMM [de] YYYY H:mm",LLLL:"dddd, D [de] MMMM [de] YYYY H:mm"},calendar:{sameDay:function(){return"[hoy a la"+(1!==this.hours()?"s":"")+"] LT"},nextDay:function(){return"[mañana a la"+(1!==this.hours()?"s":"")+"] LT"},nextWeek:function(){return"dddd [a la"+(1!==this.hours()?"s":"")+"] LT"},lastDay:function(){return"[ayer a la"+(1!==this.hours()?"s":"")+"] LT"},lastWeek:function(){return"[el] dddd [pasado a la"+(1!==this.hours()?"s":"")+"] LT"},sameElse:"L"},relativeTime:{future:"en %s",past:"hace %s",s:"unos segundos",ss:"%d segundos",m:"un minuto",mm:"%d minutos",h:"una hora",hh:"%d horas",d:"un día",dd:"%d días",w:"una semana",ww:"%d semanas",M:"un mes",MM:"%d meses",y:"un año",yy:"%d años"},dayOfMonthOrdinalParse:/\d{1,2}º/,ordinal:"%dº",week:{dow:1,doy:4},invalidDate:"Fecha inválida"})}));var c;c||(c=1,function(t,e){e(a())}(0,function(t){
//! moment.js locale configuration
var e=/(janv\.?|févr\.?|mars|avr\.?|mai|juin|juil\.?|août|sept\.?|oct\.?|nov\.?|déc\.?|janvier|février|mars|avril|mai|juin|juillet|août|septembre|octobre|novembre|décembre)/i,i=[/^janv/i,/^févr/i,/^mars/i,/^avr/i,/^mai/i,/^juin/i,/^juil/i,/^août/i,/^sept/i,/^oct/i,/^nov/i,/^déc/i],n=t.defineLocale("fr",{months:"janvier_février_mars_avril_mai_juin_juillet_août_septembre_octobre_novembre_décembre".split("_"),monthsShort:"janv._févr._mars_avr._mai_juin_juil._août_sept._oct._nov._déc.".split("_"),monthsRegex:e,monthsShortRegex:e,monthsStrictRegex:/^(janvier|février|mars|avril|mai|juin|juillet|août|septembre|octobre|novembre|décembre)/i,monthsShortStrictRegex:/(janv\.?|févr\.?|mars|avr\.?|mai|juin|juil\.?|août|sept\.?|oct\.?|nov\.?|déc\.?)/i,monthsParse:i,longMonthsParse:i,shortMonthsParse:i,weekdays:"dimanche_lundi_mardi_mercredi_jeudi_vendredi_samedi".split("_"),weekdaysShort:"dim._lun._mar._mer._jeu._ven._sam.".split("_"),weekdaysMin:"di_lu_ma_me_je_ve_sa".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[Aujourd’hui à] LT",nextDay:"[Demain à] LT",nextWeek:"dddd [à] LT",lastDay:"[Hier à] LT",lastWeek:"dddd [dernier à] LT",sameElse:"L"},relativeTime:{future:"dans %s",past:"il y a %s",s:"quelques secondes",ss:"%d secondes",m:"une minute",mm:"%d minutes",h:"une heure",hh:"%d heures",d:"un jour",dd:"%d jours",w:"une semaine",ww:"%d semaines",M:"un mois",MM:"%d mois",y:"un an",yy:"%d ans"},dayOfMonthOrdinalParse:/\d{1,2}(er|)/,ordinal:function(t,e){switch(e){case"D":return t+(1===t?"er":"");default:case"M":case"Q":case"DDD":case"d":return t+(1===t?"er":"e");case"w":case"W":return t+(1===t?"re":"e")}},week:{dow:1,doy:4}});return n}));var u;u||(u=1,function(t,e){e(a())}(0,function(t){return t.defineLocale("it",{months:"gennaio_febbraio_marzo_aprile_maggio_giugno_luglio_agosto_settembre_ottobre_novembre_dicembre".split("_"),monthsShort:"gen_feb_mar_apr_mag_giu_lug_ago_set_ott_nov_dic".split("_"),weekdays:"domenica_lunedì_martedì_mercoledì_giovedì_venerdì_sabato".split("_"),weekdaysShort:"dom_lun_mar_mer_gio_ven_sab".split("_"),weekdaysMin:"do_lu_ma_me_gi_ve_sa".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:function(){return"[Oggi a"+(this.hours()>1?"lle ":0===this.hours()?" ":"ll'")+"]LT"},nextDay:function(){return"[Domani a"+(this.hours()>1?"lle ":0===this.hours()?" ":"ll'")+"]LT"},nextWeek:function(){return"dddd [a"+(this.hours()>1?"lle ":0===this.hours()?" ":"ll'")+"]LT"},lastDay:function(){return"[Ieri a"+(this.hours()>1?"lle ":0===this.hours()?" ":"ll'")+"]LT"},lastWeek:function(){return 0===this.day()?"[La scorsa] dddd [a"+(this.hours()>1?"lle ":0===this.hours()?" ":"ll'")+"]LT":"[Lo scorso] dddd [a"+(this.hours()>1?"lle ":0===this.hours()?" ":"ll'")+"]LT"},sameElse:"L"},relativeTime:{future:"tra %s",past:"%s fa",s:"alcuni secondi",ss:"%d secondi",m:"un minuto",mm:"%d minuti",h:"un'ora",hh:"%d ore",d:"un giorno",dd:"%d giorni",w:"una settimana",ww:"%d settimane",M:"un mese",MM:"%d mesi",y:"un anno",yy:"%d anni"},dayOfMonthOrdinalParse:/\d{1,2}º/,ordinal:"%dº",week:{dow:1,doy:4}})}));var p;p||(p=1,function(t,e){e(a())}(0,function(t){
//! moment.js locale configuration
var e=t.defineLocale("ja",{eras:[{since:"2019-05-01",offset:1,name:"令和",narrow:"㋿",abbr:"R"},{since:"1989-01-08",until:"2019-04-30",offset:1,name:"平成",narrow:"㍻",abbr:"H"},{since:"1926-12-25",until:"1989-01-07",offset:1,name:"昭和",narrow:"㍼",abbr:"S"},{since:"1912-07-30",until:"1926-12-24",offset:1,name:"大正",narrow:"㍽",abbr:"T"},{since:"1873-01-01",until:"1912-07-29",offset:6,name:"明治",narrow:"㍾",abbr:"M"},{since:"0001-01-01",until:"1873-12-31",offset:1,name:"西暦",narrow:"AD",abbr:"AD"},{since:"0000-12-31",until:-1/0,offset:1,name:"紀元前",narrow:"BC",abbr:"BC"}],eraYearOrdinalRegex:/(元|\d+)年/,eraYearOrdinalParse:function(t,e){return"元"===e[1]?1:parseInt(e[1]||t,10)},months:"1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月".split("_"),monthsShort:"1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月".split("_"),weekdays:"日曜日_月曜日_火曜日_水曜日_木曜日_金曜日_土曜日".split("_"),weekdaysShort:"日_月_火_水_木_金_土".split("_"),weekdaysMin:"日_月_火_水_木_金_土".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"YYYY/MM/DD",LL:"YYYY年M月D日",LLL:"YYYY年M月D日 HH:mm",LLLL:"YYYY年M月D日 dddd HH:mm",l:"YYYY/MM/DD",ll:"YYYY年M月D日",lll:"YYYY年M月D日 HH:mm",llll:"YYYY年M月D日(ddd) HH:mm"},meridiemParse:/午前|午後/i,isPM:function(t){return"午後"===t},meridiem:function(t,e,i){return t<12?"午前":"午後"},calendar:{sameDay:"[今日] LT",nextDay:"[明日] LT",nextWeek:function(t){return t.week()!==this.week()?"[来週]dddd LT":"dddd LT"},lastDay:"[昨日] LT",lastWeek:function(t){return this.week()!==t.week()?"[先週]dddd LT":"dddd LT"},sameElse:"L"},dayOfMonthOrdinalParse:/\d{1,2}日/,ordinal:function(t,e){switch(e){case"y":return 1===t?"元年":t+"年";case"d":case"D":case"DDD":return t+"日";default:return t}},relativeTime:{future:"%s後",past:"%s前",s:"数秒",ss:"%d秒",m:"1分",mm:"%d分",h:"1時間",hh:"%d時間",d:"1日",dd:"%d日",M:"1ヶ月",MM:"%dヶ月",y:"1年",yy:"%d年"}});return e}));var m;m||(m=1,function(t,e){e(a())}(0,function(t){
//! moment.js locale configuration
var e="jan._feb._mrt._apr._mei_jun._jul._aug._sep._okt._nov._dec.".split("_"),i="jan_feb_mrt_apr_mei_jun_jul_aug_sep_okt_nov_dec".split("_"),n=[/^jan/i,/^feb/i,/^(maart|mrt\.?)$/i,/^apr/i,/^mei$/i,/^jun[i.]?$/i,/^jul[i.]?$/i,/^aug/i,/^sep/i,/^okt/i,/^nov/i,/^dec/i],o=/^(januari|februari|maart|april|mei|ju[nl]i|augustus|september|oktober|november|december|jan\.?|feb\.?|mrt\.?|apr\.?|ju[nl]\.?|aug\.?|sep\.?|okt\.?|nov\.?|dec\.?)/i,s=t.defineLocale("nl",{months:"januari_februari_maart_april_mei_juni_juli_augustus_september_oktober_november_december".split("_"),monthsShort:function(t,n){return t?/-MMM-/.test(n)?i[t.month()]:e[t.month()]:e},monthsRegex:o,monthsShortRegex:o,monthsStrictRegex:/^(januari|februari|maart|april|mei|ju[nl]i|augustus|september|oktober|november|december)/i,monthsShortStrictRegex:/^(jan\.?|feb\.?|mrt\.?|apr\.?|mei|ju[nl]\.?|aug\.?|sep\.?|okt\.?|nov\.?|dec\.?)/i,monthsParse:n,longMonthsParse:n,shortMonthsParse:n,weekdays:"zondag_maandag_dinsdag_woensdag_donderdag_vrijdag_zaterdag".split("_"),weekdaysShort:"zo._ma._di._wo._do._vr._za.".split("_"),weekdaysMin:"zo_ma_di_wo_do_vr_za".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD-MM-YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[vandaag om] LT",nextDay:"[morgen om] LT",nextWeek:"dddd [om] LT",lastDay:"[gisteren om] LT",lastWeek:"[afgelopen] dddd [om] LT",sameElse:"L"},relativeTime:{future:"over %s",past:"%s geleden",s:"een paar seconden",ss:"%d seconden",m:"één minuut",mm:"%d minuten",h:"één uur",hh:"%d uur",d:"één dag",dd:"%d dagen",w:"één week",ww:"%d weken",M:"één maand",MM:"%d maanden",y:"één jaar",yy:"%d jaar"},dayOfMonthOrdinalParse:/\d{1,2}(ste|de)/,ordinal:function(t){return t+(1===t||8===t||t>=20?"ste":"de")},week:{dow:1,doy:4}});return s}));var f;f||(f=1,function(t,e){e(a())}(0,function(t){
//! moment.js locale configuration
var e="styczeń_luty_marzec_kwiecień_maj_czerwiec_lipiec_sierpień_wrzesień_październik_listopad_grudzień".split("_"),i="stycznia_lutego_marca_kwietnia_maja_czerwca_lipca_sierpnia_września_października_listopada_grudnia".split("_"),n=[/^sty/i,/^lut/i,/^mar/i,/^kwi/i,/^maj/i,/^cze/i,/^lip/i,/^sie/i,/^wrz/i,/^paź/i,/^lis/i,/^gru/i];function o(t){return t%10<5&&t%10>1&&~~(t/10)%10!=1}function s(t,e,i){var n=t+" ";switch(i){case"ss":return n+(o(t)?"sekundy":"sekund");case"m":return e?"minuta":"minutę";case"mm":return n+(o(t)?"minuty":"minut");case"h":return e?"godzina":"godzinę";case"hh":return n+(o(t)?"godziny":"godzin");case"ww":return n+(o(t)?"tygodnie":"tygodni");case"MM":return n+(o(t)?"miesiące":"miesięcy");case"yy":return n+(o(t)?"lata":"lat")}}return t.defineLocale("pl",{months:function(t,n){return t?/D MMMM/.test(n)?i[t.month()]:e[t.month()]:e},monthsShort:"sty_lut_mar_kwi_maj_cze_lip_sie_wrz_paź_lis_gru".split("_"),monthsParse:n,longMonthsParse:n,shortMonthsParse:n,weekdays:"niedziela_poniedziałek_wtorek_środa_czwartek_piątek_sobota".split("_"),weekdaysShort:"ndz_pon_wt_śr_czw_pt_sob".split("_"),weekdaysMin:"Nd_Pn_Wt_Śr_Cz_Pt_So".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Dziś o] LT",nextDay:"[Jutro o] LT",nextWeek:function(){switch(this.day()){case 0:return"[W niedzielę o] LT";case 2:return"[We wtorek o] LT";case 3:return"[W środę o] LT";case 6:return"[W sobotę o] LT";default:return"[W] dddd [o] LT"}},lastDay:"[Wczoraj o] LT",lastWeek:function(){switch(this.day()){case 0:return"[W zeszłą niedzielę o] LT";case 3:return"[W zeszłą środę o] LT";case 6:return"[W zeszłą sobotę o] LT";default:return"[W zeszły] dddd [o] LT"}},sameElse:"L"},relativeTime:{future:"za %s",past:"%s temu",s:"kilka sekund",ss:s,m:s,mm:s,h:s,hh:s,d:"1 dzień",dd:"%d dni",w:"tydzień",ww:s,M:"miesiąc",MM:s,y:"rok",yy:s},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}})}));var g;g||(g=1,function(t,e){e(a())}(0,function(t){function e(t,e,i){var n,o;return"m"===i?e?"минута":"минуту":t+" "+(n=+t,o={ss:e?"секунда_секунды_секунд":"секунду_секунды_секунд",mm:e?"минута_минуты_минут":"минуту_минуты_минут",hh:"час_часа_часов",dd:"день_дня_дней",ww:"неделя_недели_недель",MM:"месяц_месяца_месяцев",yy:"год_года_лет"}[i].split("_"),n%10==1&&n%100!=11?o[0]:n%10>=2&&n%10<=4&&(n%100<10||n%100>=20)?o[1]:o[2])}var i=[/^янв/i,/^фев/i,/^мар/i,/^апр/i,/^ма[йя]/i,/^июн/i,/^июл/i,/^авг/i,/^сен/i,/^окт/i,/^ноя/i,/^дек/i],n=t.defineLocale("ru",{months:{format:"января_февраля_марта_апреля_мая_июня_июля_августа_сентября_октября_ноября_декабря".split("_"),standalone:"январь_февраль_март_апрель_май_июнь_июль_август_сентябрь_октябрь_ноябрь_декабрь".split("_")},monthsShort:{format:"янв._февр._мар._апр._мая_июня_июля_авг._сент._окт._нояб._дек.".split("_"),standalone:"янв._февр._март_апр._май_июнь_июль_авг._сент._окт._нояб._дек.".split("_")},weekdays:{standalone:"воскресенье_понедельник_вторник_среда_четверг_пятница_суббота".split("_"),format:"воскресенье_понедельник_вторник_среду_четверг_пятницу_субботу".split("_"),isFormat:/\[ ?[Вв] ?(?:прошлую|следующую|эту)? ?] ?dddd/},weekdaysShort:"вс_пн_вт_ср_чт_пт_сб".split("_"),weekdaysMin:"вс_пн_вт_ср_чт_пт_сб".split("_"),monthsParse:i,longMonthsParse:i,shortMonthsParse:i,monthsRegex:/^(январ[ья]|янв\.?|феврал[ья]|февр?\.?|марта?|мар\.?|апрел[ья]|апр\.?|ма[йя]|июн[ья]|июн\.?|июл[ья]|июл\.?|августа?|авг\.?|сентябр[ья]|сент?\.?|октябр[ья]|окт\.?|ноябр[ья]|нояб?\.?|декабр[ья]|дек\.?)/i,monthsShortRegex:/^(январ[ья]|янв\.?|феврал[ья]|февр?\.?|марта?|мар\.?|апрел[ья]|апр\.?|ма[йя]|июн[ья]|июн\.?|июл[ья]|июл\.?|августа?|авг\.?|сентябр[ья]|сент?\.?|октябр[ья]|окт\.?|ноябр[ья]|нояб?\.?|декабр[ья]|дек\.?)/i,monthsStrictRegex:/^(январ[яь]|феврал[яь]|марта?|апрел[яь]|ма[яй]|июн[яь]|июл[яь]|августа?|сентябр[яь]|октябр[яь]|ноябр[яь]|декабр[яь])/i,monthsShortStrictRegex:/^(янв\.|февр?\.|мар[т.]|апр\.|ма[яй]|июн[ья.]|июл[ья.]|авг\.|сент?\.|окт\.|нояб?\.|дек\.)/i,longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY г.",LLL:"D MMMM YYYY г., H:mm",LLLL:"dddd, D MMMM YYYY г., H:mm"},calendar:{sameDay:"[Сегодня, в] LT",nextDay:"[Завтра, в] LT",lastDay:"[Вчера, в] LT",nextWeek:function(t){if(t.week()===this.week())return 2===this.day()?"[Во] dddd, [в] LT":"[В] dddd, [в] LT";switch(this.day()){case 0:return"[В следующее] dddd, [в] LT";case 1:case 2:case 4:return"[В следующий] dddd, [в] LT";case 3:case 5:case 6:return"[В следующую] dddd, [в] LT"}},lastWeek:function(t){if(t.week()===this.week())return 2===this.day()?"[Во] dddd, [в] LT":"[В] dddd, [в] LT";switch(this.day()){case 0:return"[В прошлое] dddd, [в] LT";case 1:case 2:case 4:return"[В прошлый] dddd, [в] LT";case 3:case 5:case 6:return"[В прошлую] dddd, [в] LT"}},sameElse:"L"},relativeTime:{future:"через %s",past:"%s назад",s:"несколько секунд",ss:e,m:e,mm:e,h:"час",hh:e,d:"день",dd:e,w:"неделя",ww:e,M:"месяц",MM:e,y:"год",yy:e},meridiemParse:/ночи|утра|дня|вечера/i,isPM:function(t){return/^(дня|вечера)$/.test(t)},meridiem:function(t,e,i){return t<4?"ночи":t<12?"утра":t<17?"дня":"вечера"},dayOfMonthOrdinalParse:/\d{1,2}-(й|го|я)/,ordinal:function(t,e){switch(e){case"M":case"d":case"DDD":return t+"-й";case"D":return t+"-го";case"w":case"W":return t+"-я";default:return t}},week:{dow:1,doy:4}});return n}));var v;v||(v=1,function(t,e){e(a())}(0,function(t){function e(t,e,i){var n,o;return"m"===i?e?"хвилина":"хвилину":"h"===i?e?"година":"годину":t+" "+(n=+t,o={ss:e?"секунда_секунди_секунд":"секунду_секунди_секунд",mm:e?"хвилина_хвилини_хвилин":"хвилину_хвилини_хвилин",hh:e?"година_години_годин":"годину_години_годин",dd:"день_дні_днів",MM:"місяць_місяці_місяців",yy:"рік_роки_років"}[i].split("_"),n%10==1&&n%100!=11?o[0]:n%10>=2&&n%10<=4&&(n%100<10||n%100>=20)?o[1]:o[2])}function i(t){return function(){return t+"о"+(11===this.hours()?"б":"")+"] LT"}}var n=t.defineLocale("uk",{months:{format:"січня_лютого_березня_квітня_травня_червня_липня_серпня_вересня_жовтня_листопада_грудня".split("_"),standalone:"січень_лютий_березень_квітень_травень_червень_липень_серпень_вересень_жовтень_листопад_грудень".split("_")},monthsShort:"січ_лют_бер_квіт_трав_черв_лип_серп_вер_жовт_лист_груд".split("_"),weekdays:function(t,e){var i={nominative:"неділя_понеділок_вівторок_середа_четвер_п’ятниця_субота".split("_"),accusative:"неділю_понеділок_вівторок_середу_четвер_п’ятницю_суботу".split("_"),genitive:"неділі_понеділка_вівторка_середи_четверга_п’ятниці_суботи".split("_")};return!0===t?i.nominative.slice(1,7).concat(i.nominative.slice(0,1)):t?i[/(\[[ВвУу]\]) ?dddd/.test(e)?"accusative":/\[?(?:минулої|наступної)? ?\] ?dddd/.test(e)?"genitive":"nominative"][t.day()]:i.nominative},weekdaysShort:"нд_пн_вт_ср_чт_пт_сб".split("_"),weekdaysMin:"нд_пн_вт_ср_чт_пт_сб".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY р.",LLL:"D MMMM YYYY р., HH:mm",LLLL:"dddd, D MMMM YYYY р., HH:mm"},calendar:{sameDay:i("[Сьогодні "),nextDay:i("[Завтра "),lastDay:i("[Вчора "),nextWeek:i("[У] dddd ["),lastWeek:function(){switch(this.day()){case 0:case 3:case 5:case 6:return i("[Минулої] dddd [").call(this);case 1:case 2:case 4:return i("[Минулого] dddd [").call(this)}},sameElse:"L"},relativeTime:{future:"за %s",past:"%s тому",s:"декілька секунд",ss:e,m:e,mm:e,h:"годину",hh:e,d:"день",dd:e,M:"місяць",MM:e,y:"рік",yy:e},meridiemParse:/ночі|ранку|дня|вечора/,isPM:function(t){return/^(дня|вечора)$/.test(t)},meridiem:function(t,e,i){return t<4?"ночі":t<12?"ранку":t<17?"дня":"вечора"},dayOfMonthOrdinalParse:/\d{1,2}-(й|го)/,ordinal:function(t,e){switch(e){case"M":case"d":case"DDD":case"w":case"W":return t+"-й";case"D":return t+"-го";default:return t}},week:{dow:1,doy:7}});return n}));var b,y={exports:{}};var _=(b||(b=1,function(){function t(e){if(e)return function(e){for(var i in t.prototype)e[i]=t.prototype[i];return e}(e)}y.exports=t,t.prototype.on=t.prototype.addEventListener=function(t,e){return this._callbacks=this._callbacks||{},(this._callbacks["$"+t]=this._callbacks["$"+t]||[]).push(e),this},t.prototype.once=function(t,e){function i(){this.off(t,i),e.apply(this,arguments)}return i.fn=e,this.on(t,i),this},t.prototype.off=t.prototype.removeListener=t.prototype.removeAllListeners=t.prototype.removeEventListener=function(t,e){if(this._callbacks=this._callbacks||{},0==arguments.length)return this._callbacks={},this;var i,n=this._callbacks["$"+t];if(!n)return this;if(1==arguments.length)return delete this._callbacks["$"+t],this;for(var o=0;o<n.length;o++)if((i=n[o])===e||i.fn===e){n.splice(o,1);break}return 0===n.length&&delete this._callbacks["$"+t],this},t.prototype.emit=function(t){this._callbacks=this._callbacks||{};for(var e=new Array(arguments.length-1),i=this._callbacks["$"+t],n=1;n<arguments.length;n++)e[n-1]=arguments[n];if(i){n=0;for(var o=(i=i.slice(0)).length;n<o;++n)i[n].apply(this,e)}return this},t.prototype.listeners=function(t){return this._callbacks=this._callbacks||{},this._callbacks["$"+t]||[]},t.prototype.hasListeners=function(t){return!!this.listeners(t).length}}()),y.exports),w=n(_);
/*! Hammer.JS - v2.0.17-rc - 2019-12-16
 * http://naver.github.io/egjs
 *
 * Forked By Naver egjs
 * Copyright (c) hammerjs
 * Licensed under the MIT license */
function x(){return x=Object.assign||function(t){for(var e=1;e<arguments.length;e++){var i=arguments[e];for(var n in i)Object.prototype.hasOwnProperty.call(i,n)&&(t[n]=i[n])}return t},x.apply(this,arguments)}function k(t,e){t.prototype=Object.create(e.prototype),t.prototype.constructor=t,t.__proto__=e}function D(t){if(void 0===t)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return t}var S,C="function"!=typeof Object.assign?function(t){if(null==t)throw new TypeError("Cannot convert undefined or null to object");for(var e=Object(t),i=1;i<arguments.length;i++){var n=arguments[i];if(null!=n)for(var o in n)n.hasOwnProperty(o)&&(e[o]=n[o])}return e}:Object.assign,T=["","webkit","Moz","MS","ms","o"],M="undefined"==typeof document?{style:{}}:document.createElement("div"),O=Math.round,E=Math.abs,P=Date.now;function A(t,e){for(var i,n,o=e[0].toUpperCase()+e.slice(1),s=0;s<T.length;){if((n=(i=T[s])?i+o:e)in t)return n;s++}}S="undefined"==typeof window?{}:window;var I=A(M.style,"touchAction"),N=void 0!==I;var L="compute",F="auto",R="manipulation",Y="none",j="pan-x",H="pan-y",z=function(){if(!N)return!1;var t={},e=S.CSS&&S.CSS.supports;return["auto","manipulation","pan-y","pan-x","pan-x pan-y","none"].forEach(function(i){return t[i]=!e||S.CSS.supports("touch-action",i)}),t}(),G="ontouchstart"in S,W=void 0!==A(S,"PointerEvent"),B=G&&/mobile|tablet|ip(ad|hone|od)|android/i.test(navigator.userAgent),V="touch",U="mouse",X=16,q=24,Z=["x","y"],K=["clientX","clientY"];function $(t,e,i){var n;if(t)if(t.forEach)t.forEach(e,i);else if(void 0!==t.length)for(n=0;n<t.length;)e.call(i,t[n],n,t),n++;else for(n in t)t.hasOwnProperty(n)&&e.call(i,t[n],n,t)}function J(t,e){return"function"==typeof t?t.apply(e&&e[0]||void 0,e):t}function Q(t,e){return t.indexOf(e)>-1}var tt=function(){function t(t,e){this.manager=t,this.set(e)}var e=t.prototype;return e.set=function(t){t===L&&(t=this.compute()),N&&this.manager.element.style&&z[t]&&(this.manager.element.style[I]=t),this.actions=t.toLowerCase().trim()},e.update=function(){this.set(this.manager.options.touchAction)},e.compute=function(){var t=[];return $(this.manager.recognizers,function(e){J(e.options.enable,[e])&&(t=t.concat(e.getTouchAction()))}),function(t){if(Q(t,Y))return Y;var e=Q(t,j),i=Q(t,H);return e&&i?Y:e||i?e?j:H:Q(t,R)?R:F}(t.join(" "))},e.preventDefaults=function(t){var e=t.srcEvent,i=t.offsetDirection;if(this.manager.session.prevented)e.preventDefault();else{var n=this.actions,o=Q(n,Y)&&!z[Y],s=Q(n,H)&&!z[H],r=Q(n,j)&&!z[j];if(o){var a=1===t.pointers.length,l=t.distance<2,h=t.deltaTime<250;if(a&&l&&h)return}if(!r||!s)return o||s&&6&i||r&&i&q?this.preventSrc(e):void 0}},e.preventSrc=function(t){this.manager.session.prevented=!0,t.preventDefault()},t}();function et(t,e){for(;t;){if(t===e)return!0;t=t.parentNode}return!1}function it(t){var e=t.length;if(1===e)return{x:O(t[0].clientX),y:O(t[0].clientY)};for(var i=0,n=0,o=0;o<e;)i+=t[o].clientX,n+=t[o].clientY,o++;return{x:O(i/e),y:O(n/e)}}function nt(t){for(var e=[],i=0;i<t.pointers.length;)e[i]={clientX:O(t.pointers[i].clientX),clientY:O(t.pointers[i].clientY)},i++;return{timeStamp:P(),pointers:e,center:it(e),deltaX:t.deltaX,deltaY:t.deltaY}}function ot(t,e,i){i||(i=Z);var n=e[i[0]]-t[i[0]],o=e[i[1]]-t[i[1]];return Math.sqrt(n*n+o*o)}function st(t,e,i){i||(i=Z);var n=e[i[0]]-t[i[0]],o=e[i[1]]-t[i[1]];return 180*Math.atan2(o,n)/Math.PI}function rt(t,e){return t===e?1:E(t)>=E(e)?t<0?2:4:e<0?8:X}function at(t,e,i){return{x:e/t||0,y:i/t||0}}function lt(t,e){var i=t.session,n=e.pointers,o=n.length;i.firstInput||(i.firstInput=nt(e)),o>1&&!i.firstMultiple?i.firstMultiple=nt(e):1===o&&(i.firstMultiple=!1);var s=i.firstInput,r=i.firstMultiple,a=r?r.center:s.center,l=e.center=it(n);e.timeStamp=P(),e.deltaTime=e.timeStamp-s.timeStamp,e.angle=st(a,l),e.distance=ot(a,l),function(t,e){var i=e.center,n=t.offsetDelta||{},o=t.prevDelta||{},s=t.prevInput||{};1!==e.eventType&&4!==s.eventType||(o=t.prevDelta={x:s.deltaX||0,y:s.deltaY||0},n=t.offsetDelta={x:i.x,y:i.y}),e.deltaX=o.x+(i.x-n.x),e.deltaY=o.y+(i.y-n.y)}(i,e),e.offsetDirection=rt(e.deltaX,e.deltaY);var h,d,c=at(e.deltaTime,e.deltaX,e.deltaY);e.overallVelocityX=c.x,e.overallVelocityY=c.y,e.overallVelocity=E(c.x)>E(c.y)?c.x:c.y,e.scale=r?(h=r.pointers,ot((d=n)[0],d[1],K)/ot(h[0],h[1],K)):1,e.rotation=r?function(t,e){return st(e[1],e[0],K)+st(t[1],t[0],K)}(r.pointers,n):0,e.maxPointers=i.prevInput?e.pointers.length>i.prevInput.maxPointers?e.pointers.length:i.prevInput.maxPointers:e.pointers.length,function(t,e){var i,n,o,s,r=t.lastInterval||e,a=e.timeStamp-r.timeStamp;if(8!==e.eventType&&(a>25||void 0===r.velocity)){var l=e.deltaX-r.deltaX,h=e.deltaY-r.deltaY,d=at(a,l,h);n=d.x,o=d.y,i=E(d.x)>E(d.y)?d.x:d.y,s=rt(l,h),t.lastInterval=e}else i=r.velocity,n=r.velocityX,o=r.velocityY,s=r.direction;e.velocity=i,e.velocityX=n,e.velocityY=o,e.direction=s}(i,e);var u,p=t.element,m=e.srcEvent;et(u=m.composedPath?m.composedPath()[0]:m.path?m.path[0]:m.target,p)&&(p=u),e.target=p}function ht(t,e,i){var n=i.pointers.length,o=i.changedPointers.length,s=1&e&&n-o===0,r=12&e&&n-o===0;i.isFirst=!!s,i.isFinal=!!r,s&&(t.session={}),i.eventType=e,lt(t,i),t.emit("hammer.input",i),t.recognize(i),t.session.prevInput=i}function dt(t){return t.trim().split(/\s+/g)}function ct(t,e,i){$(dt(e),function(e){t.addEventListener(e,i,!1)})}function ut(t,e,i){$(dt(e),function(e){t.removeEventListener(e,i,!1)})}function pt(t){var e=t.ownerDocument||t;return e.defaultView||e.parentWindow||window}var mt=function(){function t(t,e){var i=this;this.manager=t,this.callback=e,this.element=t.element,this.target=t.options.inputTarget,this.domHandler=function(e){J(t.options.enable,[t])&&i.handler(e)},this.init()}var e=t.prototype;return e.handler=function(){},e.init=function(){this.evEl&&ct(this.element,this.evEl,this.domHandler),this.evTarget&&ct(this.target,this.evTarget,this.domHandler),this.evWin&&ct(pt(this.element),this.evWin,this.domHandler)},e.destroy=function(){this.evEl&&ut(this.element,this.evEl,this.domHandler),this.evTarget&&ut(this.target,this.evTarget,this.domHandler),this.evWin&&ut(pt(this.element),this.evWin,this.domHandler)},t}();function ft(t,e,i){if(t.indexOf&&!i)return t.indexOf(e);for(var n=0;n<t.length;){if(i&&t[n][i]==e||!i&&t[n]===e)return n;n++}return-1}var gt={pointerdown:1,pointermove:2,pointerup:4,pointercancel:8,pointerout:8},vt={2:V,3:"pen",4:U,5:"kinect"},bt="pointerdown",yt="pointermove pointerup pointercancel";S.MSPointerEvent&&!S.PointerEvent&&(bt="MSPointerDown",yt="MSPointerMove MSPointerUp MSPointerCancel");var _t=function(t){function e(){var i,n=e.prototype;return n.evEl=bt,n.evWin=yt,(i=t.apply(this,arguments)||this).store=i.manager.session.pointerEvents=[],i}return k(e,t),e.prototype.handler=function(t){var e=this.store,i=!1,n=t.type.toLowerCase().replace("ms",""),o=gt[n],s=vt[t.pointerType]||t.pointerType,r=s===V,a=ft(e,t.pointerId,"pointerId");1&o&&(0===t.button||r)?a<0&&(e.push(t),a=e.length-1):12&o&&(i=!0),a<0||(e[a]=t,this.callback(this.manager,o,{pointers:e,changedPointers:[t],pointerType:s,srcEvent:t}),i&&e.splice(a,1))},e}(mt);function wt(t){return Array.prototype.slice.call(t,0)}function xt(t,e,i){for(var n=[],o=[],s=0;s<t.length;){var r=e?t[s][e]:t[s];ft(o,r)<0&&n.push(t[s]),o[s]=r,s++}return i&&(n=e?n.sort(function(t,i){return t[e]>i[e]}):n.sort()),n}var kt={touchstart:1,touchmove:2,touchend:4,touchcancel:8},Dt=function(t){function e(){var i;return e.prototype.evTarget="touchstart touchmove touchend touchcancel",(i=t.apply(this,arguments)||this).targetIds={},i}return k(e,t),e.prototype.handler=function(t){var e=kt[t.type],i=St.call(this,t,e);i&&this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:V,srcEvent:t})},e}(mt);function St(t,e){var i,n,o=wt(t.touches),s=this.targetIds;if(3&e&&1===o.length)return s[o[0].identifier]=!0,[o,o];var r=wt(t.changedTouches),a=[],l=this.target;if(n=o.filter(function(t){return et(t.target,l)}),1===e)for(i=0;i<n.length;)s[n[i].identifier]=!0,i++;for(i=0;i<r.length;)s[r[i].identifier]&&a.push(r[i]),12&e&&delete s[r[i].identifier],i++;return a.length?[xt(n.concat(a),"identifier",!0),a]:void 0}var Ct={mousedown:1,mousemove:2,mouseup:4},Tt=function(t){function e(){var i,n=e.prototype;return n.evEl="mousedown",n.evWin="mousemove mouseup",(i=t.apply(this,arguments)||this).pressed=!1,i}return k(e,t),e.prototype.handler=function(t){var e=Ct[t.type];1&e&&0===t.button&&(this.pressed=!0),2&e&&1!==t.which&&(e=4),this.pressed&&(4&e&&(this.pressed=!1),this.callback(this.manager,e,{pointers:[t],changedPointers:[t],pointerType:U,srcEvent:t}))},e}(mt);function Mt(t){var e=t.changedPointers[0];if(e.identifier===this.primaryTouch){var i={x:e.clientX,y:e.clientY},n=this.lastTouches;this.lastTouches.push(i);setTimeout(function(){var t=n.indexOf(i);t>-1&&n.splice(t,1)},2500)}}function Ot(t,e){1&t?(this.primaryTouch=e.changedPointers[0].identifier,Mt.call(this,e)):12&t&&Mt.call(this,e)}function Et(t){for(var e=t.srcEvent.clientX,i=t.srcEvent.clientY,n=0;n<this.lastTouches.length;n++){var o=this.lastTouches[n],s=Math.abs(e-o.x),r=Math.abs(i-o.y);if(s<=25&&r<=25)return!0}return!1}var Pt=function(){return function(t){function e(e,i){var n;return(n=t.call(this,e,i)||this).handler=function(t,e,i){var o=i.pointerType===V,s=i.pointerType===U;if(!(s&&i.sourceCapabilities&&i.sourceCapabilities.firesTouchEvents)){if(o)Ot.call(D(D(n)),e,i);else if(s&&Et.call(D(D(n)),i))return;n.callback(t,e,i)}},n.touch=new Dt(n.manager,n.handler),n.mouse=new Tt(n.manager,n.handler),n.primaryTouch=null,n.lastTouches=[],n}return k(e,t),e.prototype.destroy=function(){this.touch.destroy(),this.mouse.destroy()},e}(mt)}();function At(t,e,i){return!!Array.isArray(t)&&($(t,i[e],i),!0)}var It=32,Nt=1;function Lt(t,e){var i=e.manager;return i?i.get(t):t}function Ft(t){return 16&t?"cancel":8&t?"end":4&t?"move":2&t?"start":""}var Rt=function(){function t(t){void 0===t&&(t={}),this.options=x({enable:!0},t),this.id=Nt++,this.manager=null,this.state=1,this.simultaneous={},this.requireFail=[]}var e=t.prototype;return e.set=function(t){return C(this.options,t),this.manager&&this.manager.touchAction.update(),this},e.recognizeWith=function(t){if(At(t,"recognizeWith",this))return this;var e=this.simultaneous;return e[(t=Lt(t,this)).id]||(e[t.id]=t,t.recognizeWith(this)),this},e.dropRecognizeWith=function(t){return At(t,"dropRecognizeWith",this)||(t=Lt(t,this),delete this.simultaneous[t.id]),this},e.requireFailure=function(t){if(At(t,"requireFailure",this))return this;var e=this.requireFail;return-1===ft(e,t=Lt(t,this))&&(e.push(t),t.requireFailure(this)),this},e.dropRequireFailure=function(t){if(At(t,"dropRequireFailure",this))return this;t=Lt(t,this);var e=ft(this.requireFail,t);return e>-1&&this.requireFail.splice(e,1),this},e.hasRequireFailures=function(){return this.requireFail.length>0},e.canRecognizeWith=function(t){return!!this.simultaneous[t.id]},e.emit=function(t){var e=this,i=this.state;function n(i){e.manager.emit(i,t)}i<8&&n(e.options.event+Ft(i)),n(e.options.event),t.additionalEvent&&n(t.additionalEvent),i>=8&&n(e.options.event+Ft(i))},e.tryEmit=function(t){if(this.canEmit())return this.emit(t);this.state=It},e.canEmit=function(){for(var t=0;t<this.requireFail.length;){if(!(33&this.requireFail[t].state))return!1;t++}return!0},e.recognize=function(t){var e=C({},t);if(!J(this.options.enable,[this,e]))return this.reset(),void(this.state=It);56&this.state&&(this.state=1),this.state=this.process(e),30&this.state&&this.tryEmit(e)},e.process=function(t){},e.getTouchAction=function(){},e.reset=function(){},t}(),Yt=function(t){function e(e){var i;return void 0===e&&(e={}),(i=t.call(this,x({event:"tap",pointers:1,taps:1,interval:300,time:250,threshold:9,posThreshold:10},e))||this).pTime=!1,i.pCenter=!1,i._timer=null,i._input=null,i.count=0,i}k(e,t);var i=e.prototype;return i.getTouchAction=function(){return[R]},i.process=function(t){var e=this,i=this.options,n=t.pointers.length===i.pointers,o=t.distance<i.threshold,s=t.deltaTime<i.time;if(this.reset(),1&t.eventType&&0===this.count)return this.failTimeout();if(o&&s&&n){if(4!==t.eventType)return this.failTimeout();var r=!this.pTime||t.timeStamp-this.pTime<i.interval,a=!this.pCenter||ot(this.pCenter,t.center)<i.posThreshold;if(this.pTime=t.timeStamp,this.pCenter=t.center,a&&r?this.count+=1:this.count=1,this._input=t,0===this.count%i.taps)return this.hasRequireFailures()?(this._timer=setTimeout(function(){e.state=8,e.tryEmit()},i.interval),2):8}return It},i.failTimeout=function(){var t=this;return this._timer=setTimeout(function(){t.state=It},this.options.interval),It},i.reset=function(){clearTimeout(this._timer)},i.emit=function(){8===this.state&&(this._input.tapCount=this.count,this.manager.emit(this.options.event,this._input))},e}(Rt),jt=function(t){function e(e){return void 0===e&&(e={}),t.call(this,x({pointers:1},e))||this}k(e,t);var i=e.prototype;return i.attrTest=function(t){var e=this.options.pointers;return 0===e||t.pointers.length===e},i.process=function(t){var e=this.state,i=t.eventType,n=6&e,o=this.attrTest(t);return n&&(8&i||!o)?16|e:n||o?4&i?8|e:2&e?4|e:2:It},e}(Rt);function Ht(t){return t===X?"down":8===t?"up":2===t?"left":4===t?"right":""}var zt=function(t){function e(e){var i;return void 0===e&&(e={}),(i=t.call(this,x({event:"pan",threshold:10,pointers:1,direction:30},e))||this).pX=null,i.pY=null,i}k(e,t);var i=e.prototype;return i.getTouchAction=function(){var t=this.options.direction,e=[];return 6&t&&e.push(H),t&q&&e.push(j),e},i.directionTest=function(t){var e=this.options,i=!0,n=t.distance,o=t.direction,s=t.deltaX,r=t.deltaY;return o&e.direction||(6&e.direction?(o=0===s?1:s<0?2:4,i=s!==this.pX,n=Math.abs(t.deltaX)):(o=0===r?1:r<0?8:X,i=r!==this.pY,n=Math.abs(t.deltaY))),t.direction=o,i&&n>e.threshold&&o&e.direction},i.attrTest=function(t){return jt.prototype.attrTest.call(this,t)&&(2&this.state||!(2&this.state)&&this.directionTest(t))},i.emit=function(e){this.pX=e.deltaX,this.pY=e.deltaY;var i=Ht(e.direction);i&&(e.additionalEvent=this.options.event+i),t.prototype.emit.call(this,e)},e}(jt),Gt=function(t){function e(e){return void 0===e&&(e={}),t.call(this,x({event:"swipe",threshold:10,velocity:.3,direction:30,pointers:1},e))||this}k(e,t);var i=e.prototype;return i.getTouchAction=function(){return zt.prototype.getTouchAction.call(this)},i.attrTest=function(e){var i,n=this.options.direction;return 30&n?i=e.overallVelocity:6&n?i=e.overallVelocityX:n&q&&(i=e.overallVelocityY),t.prototype.attrTest.call(this,e)&&n&e.offsetDirection&&e.distance>this.options.threshold&&e.maxPointers===this.options.pointers&&E(i)>this.options.velocity&&4&e.eventType},i.emit=function(t){var e=Ht(t.offsetDirection);e&&this.manager.emit(this.options.event+e,t),this.manager.emit(this.options.event,t)},e}(jt),Wt=function(t){function e(e){return void 0===e&&(e={}),t.call(this,x({event:"pinch",threshold:0,pointers:2},e))||this}k(e,t);var i=e.prototype;return i.getTouchAction=function(){return[Y]},i.attrTest=function(e){return t.prototype.attrTest.call(this,e)&&(Math.abs(e.scale-1)>this.options.threshold||2&this.state)},i.emit=function(e){if(1!==e.scale){var i=e.scale<1?"in":"out";e.additionalEvent=this.options.event+i}t.prototype.emit.call(this,e)},e}(jt),Bt=function(t){function e(e){return void 0===e&&(e={}),t.call(this,x({event:"rotate",threshold:0,pointers:2},e))||this}k(e,t);var i=e.prototype;return i.getTouchAction=function(){return[Y]},i.attrTest=function(e){return t.prototype.attrTest.call(this,e)&&(Math.abs(e.rotation)>this.options.threshold||2&this.state)},e}(jt),Vt=function(t){function e(e){var i;return void 0===e&&(e={}),(i=t.call(this,x({event:"press",pointers:1,time:251,threshold:9},e))||this)._timer=null,i._input=null,i}k(e,t);var i=e.prototype;return i.getTouchAction=function(){return[F]},i.process=function(t){var e=this,i=this.options,n=t.pointers.length===i.pointers,o=t.distance<i.threshold,s=t.deltaTime>i.time;if(this._input=t,!o||!n||12&t.eventType&&!s)this.reset();else if(1&t.eventType)this.reset(),this._timer=setTimeout(function(){e.state=8,e.tryEmit()},i.time);else if(4&t.eventType)return 8;return It},i.reset=function(){clearTimeout(this._timer)},i.emit=function(t){8===this.state&&(t&&4&t.eventType?this.manager.emit(this.options.event+"up",t):(this._input.timeStamp=P(),this.manager.emit(this.options.event,this._input)))},e}(Rt),Ut={domEvents:!1,touchAction:L,enable:!0,inputTarget:null,inputClass:null,cssProps:{userSelect:"none",touchSelect:"none",touchCallout:"none",contentZooming:"none",userDrag:"none",tapHighlightColor:"rgba(0,0,0,0)"}},Xt=[[Bt,{enable:!1}],[Wt,{enable:!1},["rotate"]],[Gt,{direction:6}],[zt,{direction:6},["swipe"]],[Yt],[Yt,{event:"doubletap",taps:2},["tap"]],[Vt]];function qt(t,e){var i,n=t.element;n.style&&($(t.options.cssProps,function(o,s){i=A(n.style,s),e?(t.oldCssProps[i]=n.style[i],n.style[i]=o):n.style[i]=t.oldCssProps[i]||""}),e||(t.oldCssProps={}))}var Zt=function(){function t(t,e){var i,n=this;this.options=C({},Ut,e||{}),this.options.inputTarget=this.options.inputTarget||t,this.handlers={},this.session={},this.recognizers=[],this.oldCssProps={},this.element=t,this.input=new((i=this).options.inputClass||(W?_t:B?Dt:G?Pt:Tt))(i,ht),this.touchAction=new tt(this,this.options.touchAction),qt(this,!0),$(this.options.recognizers,function(t){var e=n.add(new t[0](t[1]));t[2]&&e.recognizeWith(t[2]),t[3]&&e.requireFailure(t[3])},this)}var e=t.prototype;return e.set=function(t){return C(this.options,t),t.touchAction&&this.touchAction.update(),t.inputTarget&&(this.input.destroy(),this.input.target=t.inputTarget,this.input.init()),this},e.stop=function(t){this.session.stopped=t?2:1},e.recognize=function(t){var e=this.session;if(!e.stopped){var i;this.touchAction.preventDefaults(t);var n=this.recognizers,o=e.curRecognizer;(!o||o&&8&o.state)&&(e.curRecognizer=null,o=null);for(var s=0;s<n.length;)i=n[s],2===e.stopped||o&&i!==o&&!i.canRecognizeWith(o)?i.reset():i.recognize(t),!o&&14&i.state&&(e.curRecognizer=i,o=i),s++}},e.get=function(t){if(t instanceof Rt)return t;for(var e=this.recognizers,i=0;i<e.length;i++)if(e[i].options.event===t)return e[i];return null},e.add=function(t){if(At(t,"add",this))return this;var e=this.get(t.options.event);return e&&this.remove(e),this.recognizers.push(t),t.manager=this,this.touchAction.update(),t},e.remove=function(t){if(At(t,"remove",this))return this;var e=this.get(t);if(t){var i=this.recognizers,n=ft(i,e);-1!==n&&(i.splice(n,1),this.touchAction.update())}return this},e.on=function(t,e){if(void 0===t||void 0===e)return this;var i=this.handlers;return $(dt(t),function(t){i[t]=i[t]||[],i[t].push(e)}),this},e.off=function(t,e){if(void 0===t)return this;var i=this.handlers;return $(dt(t),function(t){e?i[t]&&i[t].splice(ft(i[t],e),1):delete i[t]}),this},e.emit=function(t,e){this.options.domEvents&&function(t,e){var i=document.createEvent("Event");i.initEvent(t,!0,!0),i.gesture=e,e.target.dispatchEvent(i)}(t,e);var i=this.handlers[t]&&this.handlers[t].slice();if(i&&i.length){e.type=t,e.preventDefault=function(){e.srcEvent.preventDefault()};for(var n=0;n<i.length;)i[n](e),n++}},e.destroy=function(){this.element&&qt(this,!1),this.handlers={},this.session={},this.input.destroy(),this.element=null},t}(),Kt={touchstart:1,touchmove:2,touchend:4,touchcancel:8},$t=function(t){function e(){var i,n=e.prototype;return n.evTarget="touchstart",n.evWin="touchstart touchmove touchend touchcancel",(i=t.apply(this,arguments)||this).started=!1,i}return k(e,t),e.prototype.handler=function(t){var e=Kt[t.type];if(1===e&&(this.started=!0),this.started){var i=Jt.call(this,t,e);12&e&&i[0].length-i[1].length===0&&(this.started=!1),this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:V,srcEvent:t})}},e}(mt);function Jt(t,e){var i=wt(t.touches),n=wt(t.changedTouches);return 12&e&&(i=xt(i.concat(n),"identifier",!0)),[i,n]}function Qt(t,e,i){var n="DEPRECATED METHOD: "+e+"\n"+i+" AT \n";return function(){var e=new Error("get-stack-trace"),i=e&&e.stack?e.stack.replace(/^[^\(]+?[\n$]/gm,"").replace(/^\s+at\s+/gm,"").replace(/^Object.<anonymous>\s*\(/gm,"{anonymous}()@"):"Unknown Stack Trace",o=window.console&&(window.console.warn||window.console.log);return o&&o.call(window.console,n,i),t.apply(this,arguments)}}var te=Qt(function(t,e,i){for(var n=Object.keys(e),o=0;o<n.length;)(!i||i&&void 0===t[n[o]])&&(t[n[o]]=e[n[o]]),o++;return t},"extend","Use `assign`."),ee=Qt(function(t,e){return te(t,e,!0)},"merge","Use `assign`.");function ie(t,e,i){var n,o=e.prototype;(n=t.prototype=Object.create(o)).constructor=t,n._super=o,i&&C(n,i)}function ne(t,e){return function(){return t.apply(e,arguments)}}var oe=function(){var t=function(t,e){return void 0===e&&(e={}),new Zt(t,x({recognizers:Xt.concat()},e))};return t.VERSION="2.0.17-rc",t.DIRECTION_ALL=30,t.DIRECTION_DOWN=X,t.DIRECTION_LEFT=2,t.DIRECTION_RIGHT=4,t.DIRECTION_UP=8,t.DIRECTION_HORIZONTAL=6,t.DIRECTION_VERTICAL=q,t.DIRECTION_NONE=1,t.DIRECTION_DOWN=X,t.INPUT_START=1,t.INPUT_MOVE=2,t.INPUT_END=4,t.INPUT_CANCEL=8,t.STATE_POSSIBLE=1,t.STATE_BEGAN=2,t.STATE_CHANGED=4,t.STATE_ENDED=8,t.STATE_RECOGNIZED=8,t.STATE_CANCELLED=16,t.STATE_FAILED=It,t.Manager=Zt,t.Input=mt,t.TouchAction=tt,t.TouchInput=Dt,t.MouseInput=Tt,t.PointerEventInput=_t,t.TouchMouseInput=Pt,t.SingleTouchInput=$t,t.Recognizer=Rt,t.AttrRecognizer=jt,t.Tap=Yt,t.Pan=zt,t.Swipe=Gt,t.Pinch=Wt,t.Rotate=Bt,t.Press=Vt,t.on=ct,t.off=ut,t.each=$,t.merge=ee,t.extend=te,t.bindFn=ne,t.assign=C,t.inherit=ie,t.bindFn=ne,t.prefixed=A,t.toArray=wt,t.inArray=ft,t.uniqueArray=xt,t.splitStr=dt,t.boolOrFn=J,t.hasParent=et,t.addEventListeners=ct,t.removeEventListeners=ut,t.defaults=C({},Ut,{preset:Xt}),t}();oe.defaults;
/**
 * vis-util
 * https://github.com/visjs/vis-util
 *
 * utilitie collection for visjs
 *
 * @version 6.0.0
 * @date    2025-07-12T18:02:43.836Z
 *
 * @copyright (c) 2011-2017 Almende B.V, http://almende.com
 * @copyright (c) 2017-2019 visjs contributors, https://github.com/visjs
 *
 * @license
 * vis.js is dual licensed under both
 *
 *   1. The Apache 2.0 License
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *   and
 *
 *   2. The MIT License
 *      http://opensource.org/licenses/MIT
 *
 * vis.js may be distributed under either license.
 */
const se=Symbol("DELETE");function re(t,...e){return ae({},t,...e)}function ae(...t){const e=le(...t);return de(e),e}function le(...t){if(t.length<2)return t[0];if(t.length>2)return le(ae(t[0],t[1]),...t.slice(2));const e=t[0],i=t[1];if(e instanceof Date&&i instanceof Date)return e.setTime(i.getTime()),e;for(const t of Reflect.ownKeys(i))Object.prototype.propertyIsEnumerable.call(i,t)&&(i[t]===se?delete e[t]:null===e[t]||null===i[t]||"object"!=typeof e[t]||"object"!=typeof i[t]||Array.isArray(e[t])||Array.isArray(i[t])?e[t]=he(i[t]):e[t]=le(e[t],i[t]));return e}function he(t){return Array.isArray(t)?t.map(t=>he(t)):"object"==typeof t&&null!==t?t instanceof Date?new Date(t.getTime()):le({},t):t}function de(t){for(const e of Object.keys(t))t[e]===se?delete t[e]:"object"==typeof t[e]&&null!==t[e]&&de(t[e])}const ce="undefined"!=typeof window?window.Hammer||oe:function(){return function(){const t=()=>{};return{on:t,off:t,destroy:t,emit:t,get:()=>({set:t})}}()};function ue(t){this._cleanupQueue=[],this.active=!1,this._dom={container:t,overlay:document.createElement("div")},this._dom.overlay.classList.add("vis-overlay"),this._dom.container.appendChild(this._dom.overlay),this._cleanupQueue.push(()=>{this._dom.overlay.parentNode.removeChild(this._dom.overlay)});const e=ce(this._dom.overlay);e.on("tap",this._onTapOverlay.bind(this)),this._cleanupQueue.push(()=>{e.destroy()});["tap","doubletap","press","pinch","pan","panstart","panmove","panend"].forEach(t=>{e.on(t,t=>{t.srcEvent.stopPropagation()})}),document&&document.body&&(this._onClick=e=>{(function(t,e){for(;t;){if(t===e)return!0;t=t.parentNode}return!1})(e.target,t)||this.deactivate()},document.body.addEventListener("click",this._onClick),this._cleanupQueue.push(()=>{document.body.removeEventListener("click",this._onClick)})),this._escListener=t=>{("key"in t?"Escape"===t.key:27===t.keyCode)&&this.deactivate()}}w(ue.prototype),ue.current=null,ue.prototype.destroy=function(){this.deactivate();for(const t of this._cleanupQueue.splice(0).reverse())t()},ue.prototype.activate=function(){ue.current&&ue.current.deactivate(),ue.current=this,this.active=!0,this._dom.overlay.style.display="none",this._dom.container.classList.add("vis-active"),this.emit("change"),this.emit("activate"),document.body.addEventListener("keydown",this._escListener)},ue.prototype.deactivate=function(){this.active=!1,this._dom.overlay.style.display="block",this._dom.container.classList.remove("vis-active"),document.body.removeEventListener("keydown",this._escListener),this.emit("change"),this.emit("deactivate")},ue.prototype._onTapOverlay=function(t){this.activate(),t.srcEvent.stopPropagation()};const pe=/^\/?Date\((-?\d+)/i,me=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i,fe=/^#?([a-f\d])([a-f\d])([a-f\d])$/i,ge=/^rgb\( *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *\)$/i,ve=/^rgba\( *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *([01]|0?\.\d+) *\)$/i;function be(t){return t instanceof Number||"number"==typeof t}function ye(t){return t instanceof String||"string"==typeof t}function _e(t){return"object"==typeof t&&null!==t}function we(t,e,i,n){let o=!1;!0===n&&(o=null===e[i]&&void 0!==t[i]),o?delete t[i]:t[i]=e[i]}const xe=Object.assign;function ke(t,e,i=!1,n=!1){for(const o in e)(Object.prototype.hasOwnProperty.call(e,o)||!0===i)&&("object"==typeof e[o]&&null!==e[o]&&Object.getPrototypeOf(e[o])===Object.prototype?void 0===t[o]?t[o]=ke({},e[o],i):"object"==typeof t[o]&&null!==t[o]&&Object.getPrototypeOf(t[o])===Object.prototype?ke(t[o],e[o],i):we(t,e,o,n):Array.isArray(e[o])?t[o]=e[o].slice():we(t,e,o,n));return t}function De(t){const e=typeof t;return"object"===e?null===t?"null":t instanceof Boolean?"Boolean":t instanceof Number?"Number":t instanceof String?"String":Array.isArray(t)?"Array":t instanceof Date?"Date":"Object":"number"===e?"Number":"boolean"===e?"Boolean":"string"===e?"String":void 0===e?"undefined":e}function Se(t,e){return[...t,e]}function Ce(t){return t.slice()}const Te=Object.values;const Me={asBoolean:(t,e)=>("function"==typeof t&&(t=t()),null!=t?0!=t:e||null),asNumber:(t,e)=>("function"==typeof t&&(t=t()),null!=t?Number(t)||e||null:e||null),asString:(t,e)=>("function"==typeof t&&(t=t()),null!=t?String(t):e||null),asSize:(t,e)=>("function"==typeof t&&(t=t()),ye(t)?t:be(t)?t+"px":e||null),asElement:(t,e)=>("function"==typeof t&&(t=t()),t||e||null)};function Oe(t){let e;switch(t.length){case 3:case 4:return e=fe.exec(t),e?{r:parseInt(e[1]+e[1],16),g:parseInt(e[2]+e[2],16),b:parseInt(e[3]+e[3],16)}:null;case 6:case 7:return e=me.exec(t),e?{r:parseInt(e[1],16),g:parseInt(e[2],16),b:parseInt(e[3],16)}:null;default:return null}}function Ee(t,e,i){return"#"+((1<<24)+(t<<16)+(e<<8)+i).toString(16).slice(1)}function Pe(t,e,i){t/=255,e/=255,i/=255;const n=Math.min(t,Math.min(e,i)),o=Math.max(t,Math.max(e,i));if(n===o)return{h:0,s:0,v:n};return{h:60*((t===n?3:i===n?1:5)-(t===n?e-i:i===n?t-e:i-t)/(o-n))/360,s:(o-n)/o,v:o}}function Ae(t){const e=document.createElement("div"),i={};e.style.cssText=t;for(let t=0;t<e.style.length;++t)i[e.style[t]]=e.style.getPropertyValue(e.style[t]);return i}function Ie(t,e,i){let n,o,s;const r=Math.floor(6*t),a=6*t-r,l=i*(1-e),h=i*(1-a*e),d=i*(1-(1-a)*e);switch(r%6){case 0:n=i,o=d,s=l;break;case 1:n=h,o=i,s=l;break;case 2:n=l,o=i,s=d;break;case 3:n=l,o=h,s=i;break;case 4:n=d,o=l,s=i;break;case 5:n=i,o=l,s=h}return{r:Math.floor(255*n),g:Math.floor(255*o),b:Math.floor(255*s)}}function Ne(t,e,i){const n=Ie(t,e,i);return Ee(n.r,n.g,n.b)}function Le(t){const e=Oe(t);if(!e)throw new TypeError(`'${t}' is not a valid color.`);return Pe(e.r,e.g,e.b)}function Fe(t){return/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(t)}function Re(t){return ge.test(t)}function Ye(t){return ve.test(t)}function je(t){if(null===t||"object"!=typeof t)return null;if(t instanceof Element)return t;const e=Object.create(t);for(const i in t)Object.prototype.hasOwnProperty.call(t,i)&&"object"==typeof t[i]&&(e[i]=je(t[i]));return e}const He={linear:t=>t,easeInQuad:t=>t*t,easeOutQuad:t=>t*(2-t),easeInOutQuad:t=>t<.5?2*t*t:(4-2*t)*t-1,easeInCubic:t=>t*t*t,easeOutCubic:t=>--t*t*t+1,easeInOutCubic:t=>t<.5?4*t*t*t:(t-1)*(2*t-2)*(2*t-2)+1,easeInQuart:t=>t*t*t*t,easeOutQuart:t=>1- --t*t*t*t,easeInOutQuart:t=>t<.5?8*t*t*t*t:1-8*--t*t*t*t,easeInQuint:t=>t*t*t*t*t,easeOutQuint:t=>1+--t*t*t*t*t,easeInOutQuint:t=>t<.5?16*t*t*t*t*t:1+16*--t*t*t*t*t};const ze={black:"#000000",navy:"#000080",darkblue:"#00008B",mediumblue:"#0000CD",blue:"#0000FF",darkgreen:"#006400",green:"#008000",teal:"#008080",darkcyan:"#008B8B",deepskyblue:"#00BFFF",darkturquoise:"#00CED1",mediumspringgreen:"#00FA9A",lime:"#00FF00",springgreen:"#00FF7F",aqua:"#00FFFF",cyan:"#00FFFF",midnightblue:"#191970",dodgerblue:"#1E90FF",lightseagreen:"#20B2AA",forestgreen:"#228B22",seagreen:"#2E8B57",darkslategray:"#2F4F4F",limegreen:"#32CD32",mediumseagreen:"#3CB371",turquoise:"#40E0D0",royalblue:"#4169E1",steelblue:"#4682B4",darkslateblue:"#483D8B",mediumturquoise:"#48D1CC",indigo:"#4B0082",darkolivegreen:"#556B2F",cadetblue:"#5F9EA0",cornflowerblue:"#6495ED",mediumaquamarine:"#66CDAA",dimgray:"#696969",slateblue:"#6A5ACD",olivedrab:"#6B8E23",slategray:"#708090",lightslategray:"#778899",mediumslateblue:"#7B68EE",lawngreen:"#7CFC00",chartreuse:"#7FFF00",aquamarine:"#7FFFD4",maroon:"#800000",purple:"#800080",olive:"#808000",gray:"#808080",skyblue:"#87CEEB",lightskyblue:"#87CEFA",blueviolet:"#8A2BE2",darkred:"#8B0000",darkmagenta:"#8B008B",saddlebrown:"#8B4513",darkseagreen:"#8FBC8F",lightgreen:"#90EE90",mediumpurple:"#9370D8",darkviolet:"#9400D3",palegreen:"#98FB98",darkorchid:"#9932CC",yellowgreen:"#9ACD32",sienna:"#A0522D",brown:"#A52A2A",darkgray:"#A9A9A9",lightblue:"#ADD8E6",greenyellow:"#ADFF2F",paleturquoise:"#AFEEEE",lightsteelblue:"#B0C4DE",powderblue:"#B0E0E6",firebrick:"#B22222",darkgoldenrod:"#B8860B",mediumorchid:"#BA55D3",rosybrown:"#BC8F8F",darkkhaki:"#BDB76B",silver:"#C0C0C0",mediumvioletred:"#C71585",indianred:"#CD5C5C",peru:"#CD853F",chocolate:"#D2691E",tan:"#D2B48C",lightgrey:"#D3D3D3",palevioletred:"#D87093",thistle:"#D8BFD8",orchid:"#DA70D6",goldenrod:"#DAA520",crimson:"#DC143C",gainsboro:"#DCDCDC",plum:"#DDA0DD",burlywood:"#DEB887",lightcyan:"#E0FFFF",lavender:"#E6E6FA",darksalmon:"#E9967A",violet:"#EE82EE",palegoldenrod:"#EEE8AA",lightcoral:"#F08080",khaki:"#F0E68C",aliceblue:"#F0F8FF",honeydew:"#F0FFF0",azure:"#F0FFFF",sandybrown:"#F4A460",wheat:"#F5DEB3",beige:"#F5F5DC",whitesmoke:"#F5F5F5",mintcream:"#F5FFFA",ghostwhite:"#F8F8FF",salmon:"#FA8072",antiquewhite:"#FAEBD7",linen:"#FAF0E6",lightgoldenrodyellow:"#FAFAD2",oldlace:"#FDF5E6",red:"#FF0000",fuchsia:"#FF00FF",magenta:"#FF00FF",deeppink:"#FF1493",orangered:"#FF4500",tomato:"#FF6347",hotpink:"#FF69B4",coral:"#FF7F50",darkorange:"#FF8C00",lightsalmon:"#FFA07A",orange:"#FFA500",lightpink:"#FFB6C1",pink:"#FFC0CB",gold:"#FFD700",peachpuff:"#FFDAB9",navajowhite:"#FFDEAD",moccasin:"#FFE4B5",bisque:"#FFE4C4",mistyrose:"#FFE4E1",blanchedalmond:"#FFEBCD",papayawhip:"#FFEFD5",lavenderblush:"#FFF0F5",seashell:"#FFF5EE",cornsilk:"#FFF8DC",lemonchiffon:"#FFFACD",floralwhite:"#FFFAF0",snow:"#FFFAFA",yellow:"#FFFF00",lightyellow:"#FFFFE0",ivory:"#FFFFF0",white:"#FFFFFF"};let Ge=class{constructor(t=1){this.pixelRatio=t,this.generated=!1,this.centerCoordinates={x:144.5,y:144.5},this.r=289*.49,this.color={r:255,g:255,b:255,a:1},this.hueCircle=void 0,this.initialColor={r:255,g:255,b:255,a:1},this.previousColor=void 0,this.applied=!1,this.updateCallback=()=>{},this.closeCallback=()=>{},this._create()}insertTo(t){void 0!==this.hammer&&(this.hammer.destroy(),this.hammer=void 0),this.container=t,this.container.appendChild(this.frame),this._bindHammer(),this._setSize()}setUpdateCallback(t){if("function"!=typeof t)throw new Error("Function attempted to set as colorPicker update callback is not a function.");this.updateCallback=t}setCloseCallback(t){if("function"!=typeof t)throw new Error("Function attempted to set as colorPicker closing callback is not a function.");this.closeCallback=t}_isColorString(t){if("string"==typeof t)return ze[t]}setColor(t,e=!0){if("none"===t)return;let i;const n=this._isColorString(t);if(void 0!==n&&(t=n),!0===ye(t)){if(!0===Re(t)){const e=t.substr(4).substr(0,t.length-5).split(",");i={r:e[0],g:e[1],b:e[2],a:1}}else if(!0===Ye(t)){const e=t.substr(5).substr(0,t.length-6).split(",");i={r:e[0],g:e[1],b:e[2],a:e[3]}}else if(!0===Fe(t)){const e=Oe(t);i={r:e.r,g:e.g,b:e.b,a:1}}}else if(t instanceof Object&&void 0!==t.r&&void 0!==t.g&&void 0!==t.b){const e=void 0!==t.a?t.a:"1.0";i={r:t.r,g:t.g,b:t.b,a:e}}if(void 0===i)throw new Error("Unknown color passed to the colorPicker. Supported are strings: rgb, hex, rgba. Object: rgb ({r:r,g:g,b:b,[a:a]}). Supplied: "+JSON.stringify(t));this._setColor(i,e)}show(){void 0!==this.closeCallback&&(this.closeCallback(),this.closeCallback=void 0),this.applied=!1,this.frame.style.display="block",this._generateHueCircle()}_hide(t=!0){!0===t&&(this.previousColor=Object.assign({},this.color)),!0===this.applied&&this.updateCallback(this.initialColor),this.frame.style.display="none",setTimeout(()=>{void 0!==this.closeCallback&&(this.closeCallback(),this.closeCallback=void 0)},0)}_save(){this.updateCallback(this.color),this.applied=!1,this._hide()}_apply(){this.applied=!0,this.updateCallback(this.color),this._updatePicker(this.color)}_loadLast(){void 0!==this.previousColor?this.setColor(this.previousColor,!1):alert("There is no last color to load...")}_setColor(t,e=!0){!0===e&&(this.initialColor=Object.assign({},t)),this.color=t;const i=Pe(t.r,t.g,t.b),n=2*Math.PI,o=this.r*i.s,s=this.centerCoordinates.x+o*Math.sin(n*i.h),r=this.centerCoordinates.y+o*Math.cos(n*i.h);this.colorPickerSelector.style.left=s-.5*this.colorPickerSelector.clientWidth+"px",this.colorPickerSelector.style.top=r-.5*this.colorPickerSelector.clientHeight+"px",this._updatePicker(t)}_setOpacity(t){this.color.a=t/100,this._updatePicker(this.color)}_setBrightness(t){const e=Pe(this.color.r,this.color.g,this.color.b);e.v=t/100;const i=Ie(e.h,e.s,e.v);i.a=this.color.a,this.color=i,this._updatePicker()}_updatePicker(t=this.color){const e=Pe(t.r,t.g,t.b),i=this.colorPickerCanvas.getContext("2d");void 0===this.pixelRation&&(this.pixelRatio=(window.devicePixelRatio||1)/(i.webkitBackingStorePixelRatio||i.mozBackingStorePixelRatio||i.msBackingStorePixelRatio||i.oBackingStorePixelRatio||i.backingStorePixelRatio||1)),i.setTransform(this.pixelRatio,0,0,this.pixelRatio,0,0);const n=this.colorPickerCanvas.clientWidth,o=this.colorPickerCanvas.clientHeight;i.clearRect(0,0,n,o),i.putImageData(this.hueCircle,0,0),i.fillStyle="rgba(0,0,0,"+(1-e.v)+")",i.circle(this.centerCoordinates.x,this.centerCoordinates.y,this.r),i.fill(),this.brightnessRange.value=100*e.v,this.opacityRange.value=100*t.a,this.initialColorDiv.style.backgroundColor="rgba("+this.initialColor.r+","+this.initialColor.g+","+this.initialColor.b+","+this.initialColor.a+")",this.newColorDiv.style.backgroundColor="rgba("+this.color.r+","+this.color.g+","+this.color.b+","+this.color.a+")"}_setSize(){this.colorPickerCanvas.style.width="100%",this.colorPickerCanvas.style.height="100%",this.colorPickerCanvas.width=289*this.pixelRatio,this.colorPickerCanvas.height=289*this.pixelRatio}_create(){if(this.frame=document.createElement("div"),this.frame.className="vis-color-picker",this.colorPickerDiv=document.createElement("div"),this.colorPickerSelector=document.createElement("div"),this.colorPickerSelector.className="vis-selector",this.colorPickerDiv.appendChild(this.colorPickerSelector),this.colorPickerCanvas=document.createElement("canvas"),this.colorPickerDiv.appendChild(this.colorPickerCanvas),this.colorPickerCanvas.getContext){const t=this.colorPickerCanvas.getContext("2d");this.pixelRatio=(window.devicePixelRatio||1)/(t.webkitBackingStorePixelRatio||t.mozBackingStorePixelRatio||t.msBackingStorePixelRatio||t.oBackingStorePixelRatio||t.backingStorePixelRatio||1),this.colorPickerCanvas.getContext("2d").setTransform(this.pixelRatio,0,0,this.pixelRatio,0,0)}else{const t=document.createElement("DIV");t.style.color="red",t.style.fontWeight="bold",t.style.padding="10px",t.innerText="Error: your browser does not support HTML canvas",this.colorPickerCanvas.appendChild(t)}this.colorPickerDiv.className="vis-color",this.opacityDiv=document.createElement("div"),this.opacityDiv.className="vis-opacity",this.brightnessDiv=document.createElement("div"),this.brightnessDiv.className="vis-brightness",this.arrowDiv=document.createElement("div"),this.arrowDiv.className="vis-arrow",this.opacityRange=document.createElement("input");try{this.opacityRange.type="range",this.opacityRange.min="0",this.opacityRange.max="100"}catch(t){}this.opacityRange.value="100",this.opacityRange.className="vis-range",this.brightnessRange=document.createElement("input");try{this.brightnessRange.type="range",this.brightnessRange.min="0",this.brightnessRange.max="100"}catch(t){}this.brightnessRange.value="100",this.brightnessRange.className="vis-range",this.opacityDiv.appendChild(this.opacityRange),this.brightnessDiv.appendChild(this.brightnessRange);const t=this;this.opacityRange.onchange=function(){t._setOpacity(this.value)},this.opacityRange.oninput=function(){t._setOpacity(this.value)},this.brightnessRange.onchange=function(){t._setBrightness(this.value)},this.brightnessRange.oninput=function(){t._setBrightness(this.value)},this.brightnessLabel=document.createElement("div"),this.brightnessLabel.className="vis-label vis-brightness",this.brightnessLabel.innerText="brightness:",this.opacityLabel=document.createElement("div"),this.opacityLabel.className="vis-label vis-opacity",this.opacityLabel.innerText="opacity:",this.newColorDiv=document.createElement("div"),this.newColorDiv.className="vis-new-color",this.newColorDiv.innerText="new",this.initialColorDiv=document.createElement("div"),this.initialColorDiv.className="vis-initial-color",this.initialColorDiv.innerText="initial",this.cancelButton=document.createElement("div"),this.cancelButton.className="vis-button vis-cancel",this.cancelButton.innerText="cancel",this.cancelButton.onclick=this._hide.bind(this,!1),this.applyButton=document.createElement("div"),this.applyButton.className="vis-button vis-apply",this.applyButton.innerText="apply",this.applyButton.onclick=this._apply.bind(this),this.saveButton=document.createElement("div"),this.saveButton.className="vis-button vis-save",this.saveButton.innerText="save",this.saveButton.onclick=this._save.bind(this),this.loadButton=document.createElement("div"),this.loadButton.className="vis-button vis-load",this.loadButton.innerText="load last",this.loadButton.onclick=this._loadLast.bind(this),this.frame.appendChild(this.colorPickerDiv),this.frame.appendChild(this.arrowDiv),this.frame.appendChild(this.brightnessLabel),this.frame.appendChild(this.brightnessDiv),this.frame.appendChild(this.opacityLabel),this.frame.appendChild(this.opacityDiv),this.frame.appendChild(this.newColorDiv),this.frame.appendChild(this.initialColorDiv),this.frame.appendChild(this.cancelButton),this.frame.appendChild(this.applyButton),this.frame.appendChild(this.saveButton),this.frame.appendChild(this.loadButton)}_bindHammer(){this.drag={},this.pinch={},this.hammer=new ce(this.colorPickerCanvas),this.hammer.get("pinch").set({enable:!0}),this.hammer.on("hammer.input",t=>{t.isFirst&&this._moveSelector(t)}),this.hammer.on("tap",t=>{this._moveSelector(t)}),this.hammer.on("panstart",t=>{this._moveSelector(t)}),this.hammer.on("panmove",t=>{this._moveSelector(t)}),this.hammer.on("panend",t=>{this._moveSelector(t)})}_generateHueCircle(){if(!1===this.generated){const t=this.colorPickerCanvas.getContext("2d");void 0===this.pixelRation&&(this.pixelRatio=(window.devicePixelRatio||1)/(t.webkitBackingStorePixelRatio||t.mozBackingStorePixelRatio||t.msBackingStorePixelRatio||t.oBackingStorePixelRatio||t.backingStorePixelRatio||1)),t.setTransform(this.pixelRatio,0,0,this.pixelRatio,0,0);const e=this.colorPickerCanvas.clientWidth,i=this.colorPickerCanvas.clientHeight;let n,o,s,r;t.clearRect(0,0,e,i),this.centerCoordinates={x:.5*e,y:.5*i},this.r=.49*e;const a=2*Math.PI/360,l=1/360,h=1/this.r;let d;for(s=0;s<360;s++)for(r=0;r<this.r;r++)n=this.centerCoordinates.x+r*Math.sin(a*s),o=this.centerCoordinates.y+r*Math.cos(a*s),d=Ie(s*l,r*h,1),t.fillStyle="rgb("+d.r+","+d.g+","+d.b+")",t.fillRect(n-.5,o-.5,2,2);t.strokeStyle="rgba(0,0,0,1)",t.circle(this.centerCoordinates.x,this.centerCoordinates.y,this.r),t.stroke(),this.hueCircle=t.getImageData(0,0,e,i)}this.generated=!0}_moveSelector(t){const e=this.colorPickerDiv.getBoundingClientRect(),i=t.center.x-e.left,n=t.center.y-e.top,o=.5*this.colorPickerDiv.clientHeight,s=.5*this.colorPickerDiv.clientWidth,r=i-s,a=n-o,l=Math.atan2(r,a),h=.98*Math.min(Math.sqrt(r*r+a*a),s),d=Math.cos(l)*h+o,c=Math.sin(l)*h+s;this.colorPickerSelector.style.top=d-.5*this.colorPickerSelector.clientHeight+"px",this.colorPickerSelector.style.left=c-.5*this.colorPickerSelector.clientWidth+"px";let u=l/(2*Math.PI);u=u<0?u+1:u;const p=h/this.r,m=Pe(this.color.r,this.color.g,this.color.b);m.h=u,m.s=p;const f=Ie(m.h,m.s,m.v);f.a=this.color.a,this.color=f,this.initialColorDiv.style.backgroundColor="rgba("+this.initialColor.r+","+this.initialColor.g+","+this.initialColor.b+","+this.initialColor.a+")",this.newColorDiv.style.backgroundColor="rgba("+this.color.r+","+this.color.g+","+this.color.b+","+this.color.a+")"}};function We(...t){if(t.length<1)throw new TypeError("Invalid arguments.");if(1===t.length)return document.createTextNode(t[0]);{const e=document.createElement(t[0]);return e.appendChild(We(...t.slice(1))),e}}let Be,Ve=!1;const Ue="background: #FFeeee; color: #dd0000";const Xe=ue,qe=Ge,Ze=class{constructor(t,e,i,n=1,o=()=>!1){this.parent=t,this.changedOptions=[],this.container=e,this.allowCreation=!1,this.hideOption=o,this.options={},this.initialized=!1,this.popupCounter=0,this.defaultOptions={enabled:!1,filter:!0,container:void 0,showButton:!0},Object.assign(this.options,this.defaultOptions),this.configureOptions=i,this.moduleOptions={},this.domElements=[],this.popupDiv={},this.popupLimit=5,this.popupHistory={},this.colorPicker=new Ge(n),this.wrapper=void 0}setOptions(t){if(void 0!==t){this.popupHistory={},this._removePopup();let e=!0;if("string"==typeof t)this.options.filter=t;else if(Array.isArray(t))this.options.filter=t.join();else if("object"==typeof t){if(null==t)throw new TypeError("options cannot be null");void 0!==t.container&&(this.options.container=t.container),void 0!==t.filter&&(this.options.filter=t.filter),void 0!==t.showButton&&(this.options.showButton=t.showButton),void 0!==t.enabled&&(e=t.enabled)}else"boolean"==typeof t?(this.options.filter=!0,e=t):"function"==typeof t&&(this.options.filter=t,e=!0);!1===this.options.filter&&(e=!1),this.options.enabled=e}this._clean()}setModuleOptions(t){this.moduleOptions=t,!0===this.options.enabled&&(this._clean(),void 0!==this.options.container&&(this.container=this.options.container),this._create())}_create(){this._clean(),this.changedOptions=[];const t=this.options.filter;let e=0,i=!1;for(const n in this.configureOptions)Object.prototype.hasOwnProperty.call(this.configureOptions,n)&&(this.allowCreation=!1,i=!1,"function"==typeof t?(i=t(n,[]),i=i||this._handleObject(this.configureOptions[n],[n],!0)):!0!==t&&-1===t.indexOf(n)||(i=!0),!1!==i&&(this.allowCreation=!0,e>0&&this._makeItem([]),this._makeHeader(n),this._handleObject(this.configureOptions[n],[n])),e++);this._makeButton(),this._push()}_push(){this.wrapper=document.createElement("div"),this.wrapper.className="vis-configuration-wrapper",this.container.appendChild(this.wrapper);for(let t=0;t<this.domElements.length;t++)this.wrapper.appendChild(this.domElements[t]);this._showPopupIfNeeded()}_clean(){for(let t=0;t<this.domElements.length;t++)this.wrapper.removeChild(this.domElements[t]);void 0!==this.wrapper&&(this.container.removeChild(this.wrapper),this.wrapper=void 0),this.domElements=[],this._removePopup()}_getValue(t){let e=this.moduleOptions;for(let i=0;i<t.length;i++){if(void 0===e[t[i]]){e=void 0;break}e=e[t[i]]}return e}_makeItem(t,...e){if(!0===this.allowCreation){const i=document.createElement("div");return i.className="vis-configuration vis-config-item vis-config-s"+t.length,e.forEach(t=>{i.appendChild(t)}),this.domElements.push(i),this.domElements.length}return 0}_makeHeader(t){const e=document.createElement("div");e.className="vis-configuration vis-config-header",e.innerText=t,this._makeItem([],e)}_makeLabel(t,e,i=!1){const n=document.createElement("div");if(n.className="vis-configuration vis-config-label vis-config-s"+e.length,!0===i){for(;n.firstChild;)n.removeChild(n.firstChild);n.appendChild(We("i","b",t))}else n.innerText=t+":";return n}_makeDropdown(t,e,i){const n=document.createElement("select");n.className="vis-configuration vis-config-select";let o=0;void 0!==e&&-1!==t.indexOf(e)&&(o=t.indexOf(e));for(let e=0;e<t.length;e++){const i=document.createElement("option");i.value=t[e],e===o&&(i.selected="selected"),i.innerText=t[e],n.appendChild(i)}const s=this;n.onchange=function(){s._update(this.value,i)};const r=this._makeLabel(i[i.length-1],i);this._makeItem(i,r,n)}_makeRange(t,e,i){const n=t[0],o=t[1],s=t[2],r=t[3],a=document.createElement("input");a.className="vis-configuration vis-config-range";try{a.type="range",a.min=o,a.max=s}catch(t){}a.step=r;let l="",h=0;if(void 0!==e){const t=1.2;e<0&&e*t<o?(a.min=Math.ceil(e*t),h=a.min,l="range increased"):e/t<o&&(a.min=Math.ceil(e/t),h=a.min,l="range increased"),e*t>s&&1!==s&&(a.max=Math.ceil(e*t),h=a.max,l="range increased"),a.value=e}else a.value=n;const d=document.createElement("input");d.className="vis-configuration vis-config-rangeinput",d.value=a.value;const c=this;a.onchange=function(){d.value=this.value,c._update(Number(this.value),i)},a.oninput=function(){d.value=this.value};const u=this._makeLabel(i[i.length-1],i),p=this._makeItem(i,u,a,d);""!==l&&this.popupHistory[p]!==h&&(this.popupHistory[p]=h,this._setupPopup(l,p))}_makeButton(){if(!0===this.options.showButton){const t=document.createElement("div");t.className="vis-configuration vis-config-button",t.innerText="generate options",t.onclick=()=>{this._printOptions()},t.onmouseover=()=>{t.className="vis-configuration vis-config-button hover"},t.onmouseout=()=>{t.className="vis-configuration vis-config-button"},this.optionsContainer=document.createElement("div"),this.optionsContainer.className="vis-configuration vis-config-option-container",this.domElements.push(this.optionsContainer),this.domElements.push(t)}}_setupPopup(t,e){if(!0===this.initialized&&!0===this.allowCreation&&this.popupCounter<this.popupLimit){const i=document.createElement("div");i.id="vis-configuration-popup",i.className="vis-configuration-popup",i.innerText=t,i.onclick=()=>{this._removePopup()},this.popupCounter+=1,this.popupDiv={html:i,index:e}}}_removePopup(){void 0!==this.popupDiv.html&&(this.popupDiv.html.parentNode.removeChild(this.popupDiv.html),clearTimeout(this.popupDiv.hideTimeout),clearTimeout(this.popupDiv.deleteTimeout),this.popupDiv={})}_showPopupIfNeeded(){if(void 0!==this.popupDiv.html){const t=this.domElements[this.popupDiv.index].getBoundingClientRect();this.popupDiv.html.style.left=t.left+"px",this.popupDiv.html.style.top=t.top-30+"px",document.body.appendChild(this.popupDiv.html),this.popupDiv.hideTimeout=setTimeout(()=>{this.popupDiv.html.style.opacity=0},1500),this.popupDiv.deleteTimeout=setTimeout(()=>{this._removePopup()},1800)}}_makeCheckbox(t,e,i){const n=document.createElement("input");n.type="checkbox",n.className="vis-configuration vis-config-checkbox",n.checked=t,void 0!==e&&(n.checked=e,e!==t&&("object"==typeof t?e!==t.enabled&&this.changedOptions.push({path:i,value:e}):this.changedOptions.push({path:i,value:e})));const o=this;n.onchange=function(){o._update(this.checked,i)};const s=this._makeLabel(i[i.length-1],i);this._makeItem(i,s,n)}_makeTextInput(t,e,i){const n=document.createElement("input");n.type="text",n.className="vis-configuration vis-config-text",n.value=e,e!==t&&this.changedOptions.push({path:i,value:e});const o=this;n.onchange=function(){o._update(this.value,i)};const s=this._makeLabel(i[i.length-1],i);this._makeItem(i,s,n)}_makeColorField(t,e,i){const n=t[1],o=document.createElement("div");"none"!==(e=void 0===e?n:e)?(o.className="vis-configuration vis-config-colorBlock",o.style.backgroundColor=e):o.className="vis-configuration vis-config-colorBlock none",e=void 0===e?n:e,o.onclick=()=>{this._showColorPicker(e,o,i)};const s=this._makeLabel(i[i.length-1],i);this._makeItem(i,s,o)}_showColorPicker(t,e,i){e.onclick=function(){},this.colorPicker.insertTo(e),this.colorPicker.show(),this.colorPicker.setColor(t),this.colorPicker.setUpdateCallback(t=>{const n="rgba("+t.r+","+t.g+","+t.b+","+t.a+")";e.style.backgroundColor=n,this._update(n,i)}),this.colorPicker.setCloseCallback(()=>{e.onclick=()=>{this._showColorPicker(t,e,i)}})}_handleObject(t,e=[],i=!1){let n=!1;const o=this.options.filter;let s=!1;for(const r in t)if(Object.prototype.hasOwnProperty.call(t,r)){n=!0;const a=t[r],l=Se(e,r);if("function"==typeof o&&(n=o(r,e),!1===n&&!Array.isArray(a)&&"string"!=typeof a&&"boolean"!=typeof a&&a instanceof Object&&(this.allowCreation=!1,n=this._handleObject(a,l,!0),this.allowCreation=!1===i)),!1!==n){s=!0;const t=this._getValue(l);if(Array.isArray(a))this._handleArray(a,t,l);else if("string"==typeof a)this._makeTextInput(a,t,l);else if("boolean"==typeof a)this._makeCheckbox(a,t,l);else if(a instanceof Object){if(!this.hideOption(e,r,this.moduleOptions))if(void 0!==a.enabled){const t=Se(l,"enabled"),e=this._getValue(t);if(!0===e){const t=this._makeLabel(r,l,!0);this._makeItem(l,t),s=this._handleObject(a,l)||s}else this._makeCheckbox(a,e,l)}else{const t=this._makeLabel(r,l,!0);this._makeItem(l,t),s=this._handleObject(a,l)||s}}else console.error("dont know how to handle",a,r,l)}}return s}_handleArray(t,e,i){"string"==typeof t[0]&&"color"===t[0]?(this._makeColorField(t,e,i),t[1]!==e&&this.changedOptions.push({path:i,value:e})):"string"==typeof t[0]?(this._makeDropdown(t,e,i),t[0]!==e&&this.changedOptions.push({path:i,value:e})):"number"==typeof t[0]&&(this._makeRange(t,e,i),t[0]!==e&&this.changedOptions.push({path:i,value:Number(e)}))}_update(t,e){const i=this._constructOptions(t,e);this.parent.body&&this.parent.body.emitter&&this.parent.body.emitter.emit&&this.parent.body.emitter.emit("configChange",i),this.initialized=!0,this.parent.setOptions(i)}_constructOptions(t,e,i={}){let n=i;t="false"!==(t="true"===t||t)&&t;for(let i=0;i<e.length;i++)"global"!==e[i]&&(void 0===n[e[i]]&&(n[e[i]]={}),i!==e.length-1?n=n[e[i]]:n[e[i]]=t);return i}_printOptions(){const t=this.getOptions();for(;this.optionsContainer.firstChild;)this.optionsContainer.removeChild(this.optionsContainer.firstChild);this.optionsContainer.appendChild(We("pre","const options = "+JSON.stringify(t,null,2)))}getOptions(){const t={};for(let e=0;e<this.changedOptions.length;e++)this._constructOptions(this.changedOptions[e].value,this.changedOptions[e].path,t);return t}},Ke=ce,$e=class{constructor(t,e){this.container=t,this.overflowMethod=e||"cap",this.x=0,this.y=0,this.padding=5,this.hidden=!1,this.frame=document.createElement("div"),this.frame.className="vis-tooltip",this.container.appendChild(this.frame)}setPosition(t,e){this.x=parseInt(t),this.y=parseInt(e)}setText(t){if(t instanceof Element){for(;this.frame.firstChild;)this.frame.removeChild(this.frame.firstChild);this.frame.appendChild(t)}else this.frame.innerText=t}show(t){if(void 0===t&&(t=!0),!0===t){const t=this.frame.clientHeight,e=this.frame.clientWidth,i=this.frame.parentNode.clientHeight,n=this.frame.parentNode.clientWidth;let o=0,s=0;if("flip"==this.overflowMethod){let i=!1,r=!0;this.y-t<this.padding&&(r=!1),this.x+e>n-this.padding&&(i=!0),o=i?this.x-e:this.x,s=r?this.y-t:this.y}else s=this.y-t,s+t+this.padding>i&&(s=i-t-this.padding),s<this.padding&&(s=this.padding),o=this.x,o+e+this.padding>n&&(o=n-e-this.padding),o<this.padding&&(o=this.padding);this.frame.style.left=o+"px",this.frame.style.top=s+"px",this.frame.style.visibility="visible",this.hidden=!1}else this.hide()}hide(){this.hidden=!0,this.frame.style.left="0",this.frame.style.top="0",this.frame.style.visibility="hidden"}destroy(){this.frame.parentNode.removeChild(this.frame)}},Je=Ue,Qe=class t{static validate(e,i,n){Ve=!1,Be=i;let o=i;return void 0!==n&&(o=i[n]),t.parse(e,o,[]),Ve}static parse(e,i,n){for(const o in e)Object.prototype.hasOwnProperty.call(e,o)&&t.check(o,e,i,n)}static check(e,i,n,o){if(void 0===n[e]&&void 0===n.__any__)return void t.getSuggestion(e,n,o);let s=e,r=!0;void 0===n[e]&&void 0!==n.__any__&&(s="__any__",r="object"===t.getType(i[e]));let a=n[s];r&&void 0!==a.__type__&&(a=a.__type__),t.checkFields(e,i,n,s,a,o)}static checkFields(e,i,n,o,s,r){const a=function(i){console.error("%c"+i+t.printLocation(r,e),Ue)},l=t.getType(i[e]),h=s[l];void 0!==h?"array"===t.getType(h)&&-1===h.indexOf(i[e])?(a('Invalid option detected in "'+e+'". Allowed values are:'+t.print(h)+' not "'+i[e]+'". '),Ve=!0):"object"===l&&"__any__"!==o&&(r=Se(r,e),t.parse(i[e],n[o],r)):void 0===s.any&&(a('Invalid type received for "'+e+'". Expected: '+t.print(Object.keys(s))+". Received ["+l+'] "'+i[e]+'"'),Ve=!0)}static getType(t){const e=typeof t;return"object"===e?null===t?"null":t instanceof Boolean?"boolean":t instanceof Number?"number":t instanceof String?"string":Array.isArray(t)?"array":t instanceof Date?"date":void 0!==t.nodeType?"dom":!0===t._isAMomentObject?"moment":"object":"number"===e?"number":"boolean"===e?"boolean":"string"===e?"string":void 0===e?"undefined":e}static getSuggestion(e,i,n){const o=t.findInOptions(e,i,n,!1),s=t.findInOptions(e,Be,[],!0);let r;r=void 0!==o.indexMatch?" in "+t.printLocation(o.path,e,"")+'Perhaps it was incomplete? Did you mean: "'+o.indexMatch+'"?\n\n':s.distance<=4&&o.distance>s.distance?" in "+t.printLocation(o.path,e,"")+"Perhaps it was misplaced? Matching option found at: "+t.printLocation(s.path,s.closestMatch,""):o.distance<=8?'. Did you mean "'+o.closestMatch+'"?'+t.printLocation(o.path,e):". Did you mean one of these: "+t.print(Object.keys(i))+t.printLocation(n,e),console.error('%cUnknown option detected: "'+e+'"'+r,Ue),Ve=!0}static findInOptions(e,i,n,o=!1){let s=1e9,r="",a=[];const l=e.toLowerCase();let h;for(const d in i){let c;if(void 0!==i[d].__type__&&!0===o){const o=t.findInOptions(e,i[d],Se(n,d));s>o.distance&&(r=o.closestMatch,a=o.path,s=o.distance,h=o.indexMatch)}else-1!==d.toLowerCase().indexOf(l)&&(h=d),c=t.levenshteinDistance(e,d),s>c&&(r=d,a=Ce(n),s=c)}return{closestMatch:r,path:a,distance:s,indexMatch:h}}static printLocation(t,e,i="Problem value found at: \n"){let n="\n\n"+i+"options = {\n";for(let e=0;e<t.length;e++){for(let t=0;t<e+1;t++)n+="  ";n+=t[e]+": {\n"}for(let e=0;e<t.length+1;e++)n+="  ";n+=e+"\n";for(let e=0;e<t.length+1;e++){for(let i=0;i<t.length-e;i++)n+="  ";n+="}\n"}return n+"\n\n"}static print(t){return JSON.stringify(t).replace(/(")|(\[)|(\])|(,"__type__")/g,"").replace(/(,)/g,", ")}static levenshteinDistance(t,e){if(0===t.length)return e.length;if(0===e.length)return t.length;const i=[];let n,o;for(n=0;n<=e.length;n++)i[n]=[n];for(o=0;o<=t.length;o++)i[0][o]=o;for(n=1;n<=e.length;n++)for(o=1;o<=t.length;o++)e.charAt(n-1)==t.charAt(o-1)?i[n][o]=i[n-1][o-1]:i[n][o]=Math.min(i[n-1][o-1]+1,Math.min(i[n][o-1]+1,i[n-1][o]+1));return i[e.length][t.length]}};var ti=Object.freeze({__proto__:null,Activator:Xe,Alea:function(...t){return function(t){let[e,i,n]=function(...t){const e=function(){let t=4022871197;return function(e){const i=e.toString();for(let e=0;e<i.length;e++){t+=i.charCodeAt(e);let n=.02519603282416938*t;t=n>>>0,n-=t,n*=t,t=n>>>0,n-=t,t+=4294967296*n}return 2.3283064365386963e-10*(t>>>0)}}();let i=e(" "),n=e(" "),o=e(" ");for(let s=0;s<t.length;s++)i-=e(t[s]),i<0&&(i+=1),n-=e(t[s]),n<0&&(n+=1),o-=e(t[s]),o<0&&(o+=1);return[i,n,o]}(t),o=1;const s=()=>{const t=2091639*e+2.3283064365386963e-10*o;return e=i,i=n,n=t-(o=0|t)};return s.uint32=()=>4294967296*s(),s.fract53=()=>s()+11102230246251565e-32*(2097152*s()|0),s.algorithm="Alea",s.seed=t,s.version="0.9",s}(t.length?t:[Date.now()])},ColorPicker:qe,Configurator:Ze,DELETE:se,HSVToHex:Ne,HSVToRGB:Ie,Hammer:Ke,Popup:$e,RGBToHSV:Pe,RGBToHex:Ee,VALIDATOR_PRINT_STYLE:Je,Validator:Qe,addClassName:function(t,e){let i=t.className.split(" ");const n=e.split(" ");i=i.concat(n.filter(function(t){return!i.includes(t)})),t.className=i.join(" ")},addCssText:function(t,e){const i=Ae(e);for(const[e,n]of Object.entries(i))t.style.setProperty(e,n)},binarySearchCustom:function(t,e,i,n){let o=0,s=0,r=t.length-1;for(;s<=r&&o<1e4;){const a=Math.floor((s+r)/2),l=t[a],h=e(void 0===n?l[i]:l[i][n]);if(0==h)return a;-1==h?s=a+1:r=a-1,o++}return-1},binarySearchValue:function(t,e,i,n,o){let s,r,a,l,h=0,d=0,c=t.length-1;for(o=null!=o?o:function(t,e){return t==e?0:t<e?-1:1};d<=c&&h<1e4;){if(l=Math.floor(.5*(c+d)),s=t[Math.max(0,l-1)][i],r=t[l][i],a=t[Math.min(t.length-1,l+1)][i],0==o(r,e))return l;if(o(s,e)<0&&o(r,e)>0)return"before"==n?Math.max(0,l-1):l;if(o(r,e)<0&&o(a,e)>0)return"before"==n?l:Math.min(t.length-1,l+1);o(r,e)<0?d=l+1:c=l-1,h++}return-1},bridgeObject:je,copyAndExtendArray:Se,copyArray:Ce,deepExtend:ke,deepObjectAssign:ae,easingFunctions:He,equalArray:function(t,e){if(t.length!==e.length)return!1;for(let i=0,n=t.length;i<n;i++)if(t[i]!=e[i])return!1;return!0},extend:xe,fillIfDefined:function t(e,i,n=!1){for(const o in e)if(void 0!==i[o])if(null===i[o]||"object"!=typeof i[o])we(e,i,o,n);else{const s=e[o],r=i[o];_e(s)&&_e(r)&&t(s,r,n)}},forEach:function(t,e){if(Array.isArray(t)){const i=t.length;for(let n=0;n<i;n++)e(t[n],n,t)}else for(const i in t)Object.prototype.hasOwnProperty.call(t,i)&&e(t[i],i,t)},getAbsoluteLeft:function(t){return t.getBoundingClientRect().left},getAbsoluteRight:function(t){return t.getBoundingClientRect().right},getAbsoluteTop:function(t){return t.getBoundingClientRect().top},getScrollBarWidth:function(){const t=document.createElement("p");t.style.width="100%",t.style.height="200px";const e=document.createElement("div");e.style.position="absolute",e.style.top="0px",e.style.left="0px",e.style.visibility="hidden",e.style.width="200px",e.style.height="150px",e.style.overflow="hidden",e.appendChild(t),document.body.appendChild(e);const i=t.offsetWidth;e.style.overflow="scroll";let n=t.offsetWidth;return i==n&&(n=e.clientWidth),document.body.removeChild(e),i-n},getTarget:function(t=window.event){let e=null;return t&&(t.target?e=t.target:t.srcElement&&(e=t.srcElement)),e instanceof Element&&(null==e.nodeType||3!=e.nodeType||(e=e.parentNode,e instanceof Element))?e:null},getType:De,hasParent:function(t,e){let i=t;for(;i;){if(i===e)return!0;if(!i.parentNode)return!1;i=i.parentNode}return!1},hexToHSV:Le,hexToRGB:Oe,insertSort:function(t,e){for(let i=0;i<t.length;i++){const n=t[i];let o;for(o=i;o>0&&e(n,t[o-1])<0;o--)t[o]=t[o-1];t[o]=n}return t},isDate:function(t){if(t instanceof Date)return!0;if(ye(t)){if(pe.exec(t))return!0;if(!isNaN(Date.parse(t)))return!0}return!1},isNumber:be,isObject:_e,isString:ye,isValidHex:Fe,isValidRGB:Re,isValidRGBA:Ye,mergeOptions:function(t,e,i,n={}){const o=function(t){return null!=t},s=function(t){return null!==t&&"object"==typeof t};if(!s(t))throw new Error("Parameter mergeTarget must be an object");if(!s(e))throw new Error("Parameter options must be an object");if(!o(i))throw new Error("Parameter option must have a value");if(!s(n))throw new Error("Parameter globalOptions must be an object");const r=e[i],a=s(n)&&!function(t){for(const e in t)if(Object.prototype.hasOwnProperty.call(t,e))return!1;return!0}(n)?n[i]:void 0,l=a?a.enabled:void 0;if(void 0===r)return;if("boolean"==typeof r)return s(t[i])||(t[i]={}),void(t[i].enabled=r);if(null===r&&!s(t[i])){if(!o(a))return;t[i]=Object.create(a)}if(!s(r))return;let h=!0;void 0!==r.enabled?h=r.enabled:void 0!==l&&(h=a.enabled),function(t,e,i){s(t[i])||(t[i]={});const n=e[i],o=t[i];for(const t in n)Object.prototype.hasOwnProperty.call(n,t)&&(o[t]=n[t])}(t,e,i),t[i].enabled=h},option:Me,overrideOpacity:function(t,e){if(t.includes("rgba"))return t;if(t.includes("rgb")){const i=t.substr(t.indexOf("(")+1).replace(")","").split(",");return"rgba("+i[0]+","+i[1]+","+i[2]+","+e+")"}{const i=Oe(t);return null==i?t:"rgba("+i.r+","+i.g+","+i.b+","+e+")"}},parseColor:function(t,e){if(ye(t)){let e=t;if(Re(e)){const t=e.substr(4).substr(0,e.length-5).split(",").map(function(t){return parseInt(t)});e=Ee(t[0],t[1],t[2])}if(!0===Fe(e)){const t=Le(e),i={h:t.h,s:.8*t.s,v:Math.min(1,1.02*t.v)},n={h:t.h,s:Math.min(1,1.25*t.s),v:.8*t.v},o=Ne(n.h,n.s,n.v),s=Ne(i.h,i.s,i.v);return{background:e,border:o,highlight:{background:s,border:o},hover:{background:s,border:o}}}return{background:e,border:e,highlight:{background:e,border:e},hover:{background:e,border:e}}}if(e){return{background:t.background||e.background,border:t.border||e.border,highlight:ye(t.highlight)?{border:t.highlight,background:t.highlight}:{background:t.highlight&&t.highlight.background||e.highlight.background,border:t.highlight&&t.highlight.border||e.highlight.border},hover:ye(t.hover)?{border:t.hover,background:t.hover}:{border:t.hover&&t.hover.border||e.hover.border,background:t.hover&&t.hover.background||e.hover.background}}}return{background:t.background||void 0,border:t.border||void 0,highlight:ye(t.highlight)?{border:t.highlight,background:t.highlight}:{background:t.highlight&&t.highlight.background||void 0,border:t.highlight&&t.highlight.border||void 0},hover:ye(t.hover)?{border:t.hover,background:t.hover}:{border:t.hover&&t.hover.border||void 0,background:t.hover&&t.hover.background||void 0}}},preventDefault:function(t){t||(t=window.event),t&&(t.preventDefault?t.preventDefault():t.returnValue=!1)},pureDeepObjectAssign:re,recursiveDOMDelete:function t(e){if(e)for(;!0===e.hasChildNodes();){const i=e.firstChild;i&&(t(i),e.removeChild(i))}},removeClassName:function(t,e){let i=t.className.split(" ");const n=e.split(" ");i=i.filter(function(t){return!n.includes(t)}),t.className=i.join(" ")},removeCssText:function(t,e){const i=Ae(e);for(const e of Object.keys(i))t.style.removeProperty(e)},selectiveBridgeObject:function(t,e){if(null!==e&&"object"==typeof e){const i=Object.create(e);for(let n=0;n<t.length;n++)Object.prototype.hasOwnProperty.call(e,t[n])&&"object"==typeof e[t[n]]&&(i[t[n]]=je(e[t[n]]));return i}return null},selectiveDeepExtend:function(t,e,i,n=!1){if(Array.isArray(i))throw new TypeError("Arrays are not supported by deepExtend");for(let o=0;o<t.length;o++){const s=t[o];if(Object.prototype.hasOwnProperty.call(i,s))if(i[s]&&i[s].constructor===Object)void 0===e[s]&&(e[s]={}),e[s].constructor===Object?ke(e[s],i[s],!1,n):we(e,i,s,n);else{if(Array.isArray(i[s]))throw new TypeError("Arrays are not supported by deepExtend");we(e,i,s,n)}}return e},selectiveExtend:function(t,e,...i){if(!Array.isArray(t))throw new Error("Array with property names expected as first argument");for(const n of i)for(let i=0;i<t.length;i++){const o=t[i];n&&Object.prototype.hasOwnProperty.call(n,o)&&(e[o]=n[o])}return e},selectiveNotDeepExtend:function(t,e,i,n=!1){if(Array.isArray(i))throw new TypeError("Arrays are not supported by deepExtend");for(const o in i)if(Object.prototype.hasOwnProperty.call(i,o)&&!t.includes(o))if(i[o]&&i[o].constructor===Object)void 0===e[o]&&(e[o]={}),e[o].constructor===Object?ke(e[o],i[o]):we(e,i,o,n);else if(Array.isArray(i[o])){e[o]=[];for(let t=0;t<i[o].length;t++)e[o].push(i[o][t])}else we(e,i,o,n);return e},throttle:function(t){let e=!1;return()=>{e||(e=!0,requestAnimationFrame(()=>{e=!1,t()}))}},toArray:Te,topMost:function(t,e){let i;Array.isArray(e)||(e=[e]);for(const n of t)if(n){i=n[e[0]];for(let t=1;t<e.length;t++)i&&(i=i[e[t]]);if(void 0!==i)break}return i},updateProperty:function(t,e,i){return t[e]!==i&&(t[e]=i,!0)}});function ei(t){for(var e in t)t.hasOwnProperty(e)&&(t[e].redundant=t[e].used,t[e].used=[])}function ii(t){for(var e in t)if(t.hasOwnProperty(e)&&t[e].redundant){for(var i=0;i<t[e].redundant.length;i++)t[e].redundant[i].parentNode.removeChild(t[e].redundant[i]);t[e].redundant=[]}}function ni(t){ei(t),ii(t),ei(t)}function oi(t,e,i){var n;return e.hasOwnProperty(t)?e[t].redundant.length>0?(n=e[t].redundant[0],e[t].redundant.shift()):(n=document.createElementNS("http://www.w3.org/2000/svg",t),i.appendChild(n)):(n=document.createElementNS("http://www.w3.org/2000/svg",t),e[t]={used:[],redundant:[]},i.appendChild(n)),e[t].used.push(n),n}function si(t,e,i,n){var o;return e.hasOwnProperty(t)?e[t].redundant.length>0?(o=e[t].redundant[0],e[t].redundant.shift()):(o=document.createElement(t),void 0!==n?i.insertBefore(o,n):i.appendChild(o)):(o=document.createElement(t),e[t]={used:[],redundant:[]},void 0!==n?i.insertBefore(o,n):i.appendChild(o)),e[t].used.push(o),o}function ri(t,e,i,n,o,s){var r;if("circle"==i.style?((r=oi("circle",n,o)).setAttributeNS(null,"cx",t),r.setAttributeNS(null,"cy",e),r.setAttributeNS(null,"r",.5*i.size)):((r=oi("rect",n,o)).setAttributeNS(null,"x",t-.5*i.size),r.setAttributeNS(null,"y",e-.5*i.size),r.setAttributeNS(null,"width",i.size),r.setAttributeNS(null,"height",i.size)),void 0!==i.styles&&r.setAttributeNS(null,"style",i.styles),r.setAttributeNS(null,"class",i.className+" vis-point"),s){var a=oi("text",n,o);s.xOffset&&(t+=s.xOffset),s.yOffset&&(e+=s.yOffset),s.content&&(a.textContent=s.content),s.className&&a.setAttributeNS(null,"class",s.className+" vis-label"),a.setAttributeNS(null,"x",t),a.setAttributeNS(null,"y",e)}return r}function ai(t,e,i,n,o,s,r,a){if(0!=n){n<0&&(e-=n*=-1);var l=oi("rect",s,r);l.setAttributeNS(null,"x",t-.5*i),l.setAttributeNS(null,"y",e),l.setAttributeNS(null,"width",i),l.setAttributeNS(null,"height",n),l.setAttributeNS(null,"class",o),a&&l.setAttributeNS(null,"style",a)}}function li(){try{return navigator?navigator.languages&&navigator.languages.length?navigator.languages:navigator.userLanguage||navigator.language||navigator.browserLanguage||"en":"en"}catch(t){return"en"}}var hi=Object.freeze({__proto__:null,cleanupElements:ii,drawBar:ai,drawPoint:ri,getDOMElement:si,getNavigatorLanguage:li,getSVGElement:oi,prepareElements:ei,resetElements:ni});const di=[];for(let t=0;t<256;++t)di.push((t+256).toString(16).slice(1));let ci;const ui=new Uint8Array(16);var pi={randomUUID:"undefined"!=typeof crypto&&crypto.randomUUID&&crypto.randomUUID.bind(crypto)};function mi(t,e,i){if(pi.randomUUID&&!t)return pi.randomUUID();const n=(t=t||{}).random??t.rng?.()??function(){if(!ci){if("undefined"==typeof crypto||!crypto.getRandomValues)throw new Error("crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported");ci=crypto.getRandomValues.bind(crypto)}return ci(ui)}();if(n.length<16)throw new Error("Random bytes length must be >= 16");return n[6]=15&n[6]|64,n[8]=63&n[8]|128,function(t,e=0){return(di[t[e+0]]+di[t[e+1]]+di[t[e+2]]+di[t[e+3]]+"-"+di[t[e+4]]+di[t[e+5]]+"-"+di[t[e+6]]+di[t[e+7]]+"-"+di[t[e+8]]+di[t[e+9]]+"-"+di[t[e+10]]+di[t[e+11]]+di[t[e+12]]+di[t[e+13]]+di[t[e+14]]+di[t[e+15]]).toLowerCase()}(n)}
/**
 * vis-data
 * http://visjs.org/
 *
 * Manage unstructured data using DataSet. Add, update, and remove data, and listen for changes in the data.
 *
 * @version 8.0.1
 * @date    2025-07-13T02:52:37.151Z
 *
 * @copyright (c) 2011-2017 Almende B.V, http://almende.com
 * @copyright (c) 2017-2019 visjs contributors, https://github.com/visjs
 *
 * @license
 * vis.js is dual licensed under both
 *
 *   1. The Apache 2.0 License
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *   and
 *
 *   2. The MIT License
 *      http://opensource.org/licenses/MIT
 *
 * vis.js may be distributed under either license.
 */class fi{_source;_transformers;_target;_listeners={add:this._add.bind(this),remove:this._remove.bind(this),update:this._update.bind(this)};constructor(t,e,i){this._source=t,this._transformers=e,this._target=i}all(){return this._target.update(this._transformItems(this._source.get())),this}start(){return this._source.on("add",this._listeners.add),this._source.on("remove",this._listeners.remove),this._source.on("update",this._listeners.update),this}stop(){return this._source.off("add",this._listeners.add),this._source.off("remove",this._listeners.remove),this._source.off("update",this._listeners.update),this}_transformItems(t){return this._transformers.reduce((t,e)=>e(t),t)}_add(t,e){null!=e&&this._target.add(this._transformItems(this._source.get(e.items)))}_update(t,e){null!=e&&this._target.update(this._transformItems(this._source.get(e.items)))}_remove(t,e){null!=e&&this._target.remove(this._transformItems(e.oldData))}}class gi{_source;_transformers=[];constructor(t){this._source=t}filter(t){return this._transformers.push(e=>e.filter(t)),this}map(t){return this._transformers.push(e=>e.map(t)),this}flatMap(t){return this._transformers.push(e=>e.flatMap(t)),this}to(t){return new fi(this._source,this._transformers,t)}}function vi(t){return"string"==typeof t||"number"==typeof t}class bi{delay;max;_queue=[];_timeout=null;_extended=null;constructor(t){this.delay=null,this.max=1/0,this.setOptions(t)}setOptions(t){t&&void 0!==t.delay&&(this.delay=t.delay),t&&void 0!==t.max&&(this.max=t.max),this._flushIfNeeded()}static extend(t,e){const i=new bi(e);if(void 0!==t.flush)throw new Error("Target object already has a property flush");t.flush=()=>{i.flush()};const n=[{name:"flush",original:void 0}];if(e&&e.replace)for(let o=0;o<e.replace.length;o++){const s=e.replace[o];n.push({name:s,original:t[s]}),i.replace(t,s)}return i._extended={object:t,methods:n},i}destroy(){if(this.flush(),this._extended){const t=this._extended.object,e=this._extended.methods;for(let i=0;i<e.length;i++){const n=e[i];n.original?t[n.name]=n.original:delete t[n.name]}this._extended=null}}replace(t,e){const i=this,n=t[e];if(!n)throw new Error("Method "+e+" undefined");t[e]=function(...t){i.queue({args:t,fn:n,context:this})}}queue(t){"function"==typeof t?this._queue.push({fn:t}):this._queue.push(t),this._flushIfNeeded()}_flushIfNeeded(){this._queue.length>this.max&&this.flush(),null!=this._timeout&&(clearTimeout(this._timeout),this._timeout=null),this.queue.length>0&&"number"==typeof this.delay&&(this._timeout=setTimeout(()=>{this.flush()},this.delay))}flush(){this._queue.splice(0).forEach(t=>{t.fn.apply(t.context||t.fn,t.args||[])})}}class yi{_subscribers={"*":[],add:[],remove:[],update:[]};_trigger(t,e,i){if("*"===t)throw new Error("Cannot trigger event *");[...this._subscribers[t],...this._subscribers["*"]].forEach(n=>{n(t,e,null!=i?i:null)})}on(t,e){"function"==typeof e&&this._subscribers[t].push(e)}off(t,e){this._subscribers[t]=this._subscribers[t].filter(t=>t!==e)}subscribe=yi.prototype.on;unsubscribe=yi.prototype.off;get testLeakSubscribers(){return this._subscribers}}class _i{_pairs;constructor(t){this._pairs=t}*[Symbol.iterator](){for(const[t,e]of this._pairs)yield[t,e]}*entries(){for(const[t,e]of this._pairs)yield[t,e]}*keys(){for(const[t]of this._pairs)yield t}*values(){for(const[,t]of this._pairs)yield t}toIdArray(){return[...this._pairs].map(t=>t[0])}toItemArray(){return[...this._pairs].map(t=>t[1])}toEntryArray(){return[...this._pairs]}toObjectMap(){const t=Object.create(null);for(const[e,i]of this._pairs)t[e]=i;return t}toMap(){return new Map(this._pairs)}toIdSet(){return new Set(this.toIdArray())}toItemSet(){return new Set(this.toItemArray())}cache(){return new _i([...this._pairs])}distinct(t){const e=new Set;for(const[i,n]of this._pairs)e.add(t(n,i));return e}filter(t){const e=this._pairs;return new _i({*[Symbol.iterator](){for(const[i,n]of e)t(n,i)&&(yield[i,n])}})}forEach(t){for(const[e,i]of this._pairs)t(i,e)}map(t){const e=this._pairs;return new _i({*[Symbol.iterator](){for(const[i,n]of e)yield[i,t(n,i)]}})}max(t){const e=this._pairs[Symbol.iterator]();let i=e.next();if(i.done)return null;let n=i.value[1],o=t(i.value[1],i.value[0]);for(;!(i=e.next()).done;){const[e,s]=i.value,r=t(s,e);r>o&&(o=r,n=s)}return n}min(t){const e=this._pairs[Symbol.iterator]();let i=e.next();if(i.done)return null;let n=i.value[1],o=t(i.value[1],i.value[0]);for(;!(i=e.next()).done;){const[e,s]=i.value,r=t(s,e);r<o&&(o=r,n=s)}return n}reduce(t,e){for(const[i,n]of this._pairs)e=t(e,n,i);return e}sort(t){return new _i({[Symbol.iterator]:()=>[...this._pairs].sort(([e,i],[n,o])=>t(i,o,e,n))[Symbol.iterator]()})}}class wi extends yi{flush;length;get idProp(){return this._idProp}_options;_data;_idProp;_queue=null;constructor(t,e){super(),t&&!Array.isArray(t)&&(e=t,t=[]),this._options=e||{},this._data=new Map,this.length=0,this._idProp=this._options.fieldId||"id",t&&t.length&&this.add(t),this.setOptions(e)}setOptions(t){t&&void 0!==t.queue&&(!1===t.queue?this._queue&&(this._queue.destroy(),this._queue=null):(this._queue||(this._queue=bi.extend(this,{replace:["add","update","remove"]})),t.queue&&"object"==typeof t.queue&&this._queue.setOptions(t.queue)))}add(t,e){const i=[];let n;if(Array.isArray(t)){if(t.map(t=>t[this._idProp]).some(t=>this._data.has(t)))throw new Error("A duplicate id was found in the parameter array.");for(let e=0,o=t.length;e<o;e++)n=this._addItem(t[e]),i.push(n)}else{if(!t||"object"!=typeof t)throw new Error("Unknown dataType");n=this._addItem(t),i.push(n)}return i.length&&this._trigger("add",{items:i},e),i}update(t,e){const i=[],n=[],o=[],s=[],r=this._idProp,a=t=>{const e=t[r];if(null!=e&&this._data.has(e)){const i=t,r=Object.assign({},this._data.get(e)),a=this._updateItem(i);n.push(a),s.push(i),o.push(r)}else{const e=this._addItem(t);i.push(e)}};if(Array.isArray(t))for(let e=0,i=t.length;e<i;e++)t[e]&&"object"==typeof t[e]?a(t[e]):console.warn("Ignoring input item, which is not an object at index "+e);else{if(!t||"object"!=typeof t)throw new Error("Unknown dataType");a(t)}if(i.length&&this._trigger("add",{items:i},e),n.length){const t={items:n,oldData:o,data:s};this._trigger("update",t,e)}return i.concat(n)}updateOnly(t,e){Array.isArray(t)||(t=[t]);const i=t.map(t=>{const e=this._data.get(t[this._idProp]);if(null==e)throw new Error("Updating non-existent items is not allowed.");return{oldData:e,update:t}}).map(({oldData:t,update:e})=>{const i=t[this._idProp],n=re(t,e);return this._data.set(i,n),{id:i,oldData:t,updatedData:n}});if(i.length){const t={items:i.map(t=>t.id),oldData:i.map(t=>t.oldData),data:i.map(t=>t.updatedData)};return this._trigger("update",t,e),t.items}return[]}get(t,e){let i,n,o;vi(t)?(i=t,o=e):Array.isArray(t)?(n=t,o=e):o=t;const s=o&&"Object"===o.returnType?"Object":"Array",r=o&&o.filter,a=[];let l,h,d;if(null!=i)l=this._data.get(i),l&&r&&!r(l)&&(l=void 0);else if(null!=n)for(let t=0,e=n.length;t<e;t++)l=this._data.get(n[t]),null==l||r&&!r(l)||a.push(l);else{h=[...this._data.keys()];for(let t=0,e=h.length;t<e;t++)d=h[t],l=this._data.get(d),null==l||r&&!r(l)||a.push(l)}if(o&&o.order&&null==i&&this._sort(a,o.order),o&&o.fields){const t=o.fields;if(null!=i&&null!=l)l=this._filterFields(l,t);else for(let e=0,i=a.length;e<i;e++)a[e]=this._filterFields(a[e],t)}if("Object"==s){const t={};for(let e=0,i=a.length;e<i;e++){const i=a[e];t[i[this._idProp]]=i}return t}return null!=i?l??null:a}getIds(t){const e=this._data,i=t&&t.filter,n=t&&t.order,o=[...e.keys()],s=[];if(i)if(n){const t=[];for(let e=0,n=o.length;e<n;e++){const n=o[e],s=this._data.get(n);null!=s&&i(s)&&t.push(s)}this._sort(t,n);for(let e=0,i=t.length;e<i;e++)s.push(t[e][this._idProp])}else for(let t=0,e=o.length;t<e;t++){const e=o[t],n=this._data.get(e);null!=n&&i(n)&&s.push(n[this._idProp])}else if(n){const t=[];for(let i=0,n=o.length;i<n;i++){const n=o[i];t.push(e.get(n))}this._sort(t,n);for(let e=0,i=t.length;e<i;e++)s.push(t[e][this._idProp])}else for(let t=0,i=o.length;t<i;t++){const i=o[t],n=e.get(i);null!=n&&s.push(n[this._idProp])}return s}getDataSet(){return this}forEach(t,e){const i=e&&e.filter,n=[...this._data.keys()];if(e&&e.order){const i=this.get(e);for(let e=0,n=i.length;e<n;e++){const n=i[e];t(n,n[this._idProp])}}else for(let e=0,o=n.length;e<o;e++){const o=n[e],s=this._data.get(o);null==s||i&&!i(s)||t(s,o)}}map(t,e){const i=e&&e.filter,n=[],o=[...this._data.keys()];for(let e=0,s=o.length;e<s;e++){const s=o[e],r=this._data.get(s);null==r||i&&!i(r)||n.push(t(r,s))}return e&&e.order&&this._sort(n,e.order),n}_filterFields(t,e){return t?(Array.isArray(e)?e:Object.keys(e)).reduce((e,i)=>(e[i]=t[i],e),{}):t}_sort(t,e){if("string"==typeof e){const i=e;t.sort((t,e)=>{const n=t[i],o=e[i];return n>o?1:n<o?-1:0})}else{if("function"!=typeof e)throw new TypeError("Order must be a function or a string");t.sort(e)}}remove(t,e){const i=[],n=[],o=Array.isArray(t)?t:[t];for(let t=0,e=o.length;t<e;t++){const e=this._remove(o[t]);if(e){const t=e[this._idProp];null!=t&&(i.push(t),n.push(e))}}return i.length&&this._trigger("remove",{items:i,oldData:n},e),i}_remove(t){let e;if(vi(t)?e=t:t&&"object"==typeof t&&(e=t[this._idProp]),null!=e&&this._data.has(e)){const t=this._data.get(e)||null;return this._data.delete(e),--this.length,t}return null}clear(t){const e=[...this._data.keys()],i=[];for(let t=0,n=e.length;t<n;t++)i.push(this._data.get(e[t]));return this._data.clear(),this.length=0,this._trigger("remove",{items:e,oldData:i},t),e}max(t){let e=null,i=null;for(const n of this._data.values()){const o=n[t];"number"==typeof o&&(null==i||o>i)&&(e=n,i=o)}return e||null}min(t){let e=null,i=null;for(const n of this._data.values()){const o=n[t];"number"==typeof o&&(null==i||o<i)&&(e=n,i=o)}return e||null}distinct(t){const e=this._data,i=[...e.keys()],n=[];let o=0;for(let s=0,r=i.length;s<r;s++){const r=i[s],a=e.get(r)[t];let l=!1;for(let t=0;t<o;t++)if(n[t]==a){l=!0;break}l||void 0===a||(n[o]=a,o++)}return n}_addItem(t){const e=function(t,e){return null==t[e]&&(t[e]=mi()),t}(t,this._idProp),i=e[this._idProp];if(this._data.has(i))throw new Error("Cannot add item: item with id "+i+" already exists");return this._data.set(i,e),++this.length,i}_updateItem(t){const e=t[this._idProp];if(null==e)throw new Error("Cannot update item: item has no id (item: "+JSON.stringify(t)+")");const i=this._data.get(e);if(!i)throw new Error("Cannot update item: no item with id "+e+" found");return this._data.set(e,{...i,...t}),e}stream(t){if(t){const e=this._data;return new _i({*[Symbol.iterator](){for(const i of t){const t=e.get(i);null!=t&&(yield[i,t])}}})}return new _i({[Symbol.iterator]:this._data.entries.bind(this._data)})}get testLeakData(){return this._data}get testLeakIdProp(){return this._idProp}get testLeakOptions(){return this._options}get testLeakQueue(){return this._queue}set testLeakQueue(t){this._queue=t}}class xi extends yi{length=0;get idProp(){return this.getDataSet().idProp}_listener;_data;_ids=new Set;_options;constructor(t,e){super(),this._options=e||{},this._listener=this._onEvent.bind(this),this.setData(t)}setData(t){if(this._data){this._data.off&&this._data.off("*",this._listener);const t=this._data.getIds({filter:this._options.filter}),e=this._data.get(t);this._ids.clear(),this.length=0,this._trigger("remove",{items:t,oldData:e})}if(null!=t){this._data=t;const e=this._data.getIds({filter:this._options.filter});for(let t=0,i=e.length;t<i;t++){const i=e[t];this._ids.add(i)}this.length=e.length,this._trigger("add",{items:e})}else this._data=new wi;this._data.on&&this._data.on("*",this._listener)}refresh(){const t=this._data.getIds({filter:this._options.filter}),e=[...this._ids],i={},n=[],o=[],s=[];for(let e=0,o=t.length;e<o;e++){const o=t[e];i[o]=!0,this._ids.has(o)||(n.push(o),this._ids.add(o))}for(let t=0,n=e.length;t<n;t++){const n=e[t],r=this._data.get(n);null==r?console.error("If you see this, report it please."):i[n]||(o.push(n),s.push(r),this._ids.delete(n))}this.length+=n.length-o.length,n.length&&this._trigger("add",{items:n}),o.length&&this._trigger("remove",{items:o,oldData:s})}get(t,e){if(null==this._data)return null;let i,n=null;vi(t)||Array.isArray(t)?(n=t,i=e):i=t;const o=Object.assign({},this._options,i),s=this._options.filter,r=i&&i.filter;return s&&r&&(o.filter=t=>s(t)&&r(t)),null==n?this._data.get(o):this._data.get(n,o)}getIds(t){if(this._data.length){const e=this._options.filter,i=null!=t?t.filter:null;let n;return n=i?e?t=>e(t)&&i(t):i:e,this._data.getIds({filter:n,order:t&&t.order})}return[]}forEach(t,e){if(this._data){const i=this._options.filter,n=e&&e.filter;let o;o=n?i?function(t){return i(t)&&n(t)}:n:i,this._data.forEach(t,{filter:o,order:e&&e.order})}}map(t,e){if(this._data){const i=this._options.filter,n=e&&e.filter;let o;return o=n?i?t=>i(t)&&n(t):n:i,this._data.map(t,{filter:o,order:e&&e.order})}return[]}getDataSet(){return this._data.getDataSet()}stream(t){return this._data.stream(t||{[Symbol.iterator]:this._ids.keys.bind(this._ids)})}dispose(){this._data?.off&&this._data.off("*",this._listener);const t="This data view has already been disposed of.",e={get:()=>{throw new Error(t)},set:()=>{throw new Error(t)},configurable:!1};for(const t of Reflect.ownKeys(xi.prototype))Object.defineProperty(this,t,e)}_onEvent(t,e,i){if(!e||!e.items||!this._data)return;const n=e.items,o=[],s=[],r=[],a=[],l=[],h=[];switch(t){case"add":for(let t=0,e=n.length;t<e;t++){const e=n[t];this.get(e)&&(this._ids.add(e),o.push(e))}break;case"update":for(let t=0,i=n.length;t<i;t++){const i=n[t];this.get(i)?this._ids.has(i)?(s.push(i),l.push(e.data[t]),a.push(e.oldData[t])):(this._ids.add(i),o.push(i)):this._ids.has(i)&&(this._ids.delete(i),r.push(i),h.push(e.oldData[t]))}break;case"remove":for(let t=0,i=n.length;t<i;t++){const i=n[t];this._ids.has(i)&&(this._ids.delete(i),r.push(i),h.push(e.oldData[t]))}}this.length+=o.length-r.length,o.length&&this._trigger("add",{items:o},i),s.length&&this._trigger("update",{items:s,oldData:a,data:l},i),r.length&&this._trigger("remove",{items:r,oldData:h},i)}}console.warn("You're running a development build.");var ki,Di,Si,Ci,Ti,Mi,Oi,Ei,Pi,Ai,Ii,Ni,Li,Fi,Ri,Yi;function ji(){if(Di)return ki;Di=1;var t=function(t){return t&&t.Math===Math&&t};return ki=t("object"==typeof globalThis&&globalThis)||t("object"==typeof window&&window)||t("object"==typeof self&&self)||t("object"==typeof e&&e)||t("object"==typeof ki&&ki)||function(){return this}()||Function("return this")()}function Hi(){return Ci?Si:(Ci=1,Si=function(t){try{return!!t()}catch(t){return!0}})}function zi(){return Mi?Ti:(Mi=1,Ti=!Hi()(function(){var t=function(){}.bind();return"function"!=typeof t||t.hasOwnProperty("prototype")}))}function Gi(){if(Ei)return Oi;Ei=1;var t=zi(),e=Function.prototype,i=e.apply,n=e.call;return Oi="object"==typeof Reflect&&Reflect.apply||(t?n.bind(i):function(){return n.apply(i,arguments)}),Oi}function Wi(){if(Ai)return Pi;Ai=1;var t=zi(),e=Function.prototype,i=e.call,n=t&&e.bind.bind(i,i);return Pi=t?n:function(t){return function(){return i.apply(t,arguments)}},Pi}function Bi(){if(Ni)return Ii;Ni=1;var t=Wi(),e=t({}.toString),i=t("".slice);return Ii=function(t){return i(e(t),8,-1)},Ii}function Vi(){if(Fi)return Li;Fi=1;var t=Bi(),e=Wi();return Li=function(i){if("Function"===t(i))return e(i)}}function Ui(){if(Yi)return Ri;Yi=1;var t="object"==typeof document&&document.all;return Ri=void 0===t&&void 0!==t?function(e){return"function"==typeof e||e===t}:function(t){return"function"==typeof t}}var Xi,qi,Zi,Ki,$i={};function Ji(){return qi?Xi:(qi=1,Xi=!Hi()(function(){return 7!==Object.defineProperty({},1,{get:function(){return 7}})[1]}))}function Qi(){if(Ki)return Zi;Ki=1;var t=zi(),e=Function.prototype.call;return Zi=t?e.bind(e):function(){return e.apply(e,arguments)},Zi}var tn,en,nn,on,sn,rn,an,ln,hn,dn,cn,un,pn,mn,fn,gn,vn,bn,yn,_n,wn,xn,kn,Dn,Sn,Cn,Tn,Mn,On,En,Pn,An,In,Nn,Ln,Fn,Rn,Yn={};function jn(){if(tn)return Yn;tn=1;var t={}.propertyIsEnumerable,e=Object.getOwnPropertyDescriptor,i=e&&!t.call({1:2},1);return Yn.f=i?function(t){var i=e(this,t);return!!i&&i.enumerable}:t,Yn}function Hn(){return nn?en:(nn=1,en=function(t,e){return{enumerable:!(1&t),configurable:!(2&t),writable:!(4&t),value:e}})}function zn(){if(sn)return on;sn=1;var t=Wi(),e=Hi(),i=Bi(),n=Object,o=t("".split);return on=e(function(){return!n("z").propertyIsEnumerable(0)})?function(t){return"String"===i(t)?o(t,""):n(t)}:n,on}function Gn(){return an||(an=1,rn=function(t){return null==t}),rn}function Wn(){if(hn)return ln;hn=1;var t=Gn(),e=TypeError;return ln=function(i){if(t(i))throw new e("Can't call method on "+i);return i},ln}function Bn(){if(cn)return dn;cn=1;var t=zn(),e=Wn();return dn=function(i){return t(e(i))},dn}function Vn(){if(pn)return un;pn=1;var t=Ui();return un=function(e){return"object"==typeof e?null!==e:t(e)},un}function Un(){return fn?mn:(fn=1,mn={})}function Xn(){if(vn)return gn;vn=1;var t=Un(),e=ji(),i=Ui(),n=function(t){return i(t)?t:void 0};return gn=function(i,o){return arguments.length<2?n(t[i])||n(e[i]):t[i]&&t[i][o]||e[i]&&e[i][o]},gn}function qn(){return yn?bn:(yn=1,bn=Wi()({}.isPrototypeOf))}function Zn(){if(wn)return _n;wn=1;var t=ji().navigator,e=t&&t.userAgent;return _n=e?String(e):""}function Kn(){if(kn)return xn;kn=1;var t,e,i=ji(),n=Zn(),o=i.process,s=i.Deno,r=o&&o.versions||s&&s.version,a=r&&r.v8;return a&&(e=(t=a.split("."))[0]>0&&t[0]<4?1:+(t[0]+t[1])),!e&&n&&(!(t=n.match(/Edge\/(\d+)/))||t[1]>=74)&&(t=n.match(/Chrome\/(\d+)/))&&(e=+t[1]),xn=e}function $n(){if(Sn)return Dn;Sn=1;var t=Kn(),e=Hi(),i=ji().String;return Dn=!!Object.getOwnPropertySymbols&&!e(function(){var e=Symbol("symbol detection");return!i(e)||!(Object(e)instanceof Symbol)||!Symbol.sham&&t&&t<41}),Dn}function Jn(){return Tn?Cn:(Tn=1,Cn=$n()&&!Symbol.sham&&"symbol"==typeof Symbol.iterator)}function Qn(){if(On)return Mn;On=1;var t=Xn(),e=Ui(),i=qn(),n=Object;return Mn=Jn()?function(t){return"symbol"==typeof t}:function(o){var s=t("Symbol");return e(s)&&i(s.prototype,n(o))},Mn}function to(){if(Pn)return En;Pn=1;var t=String;return En=function(e){try{return t(e)}catch(t){return"Object"}}}function eo(){if(In)return An;In=1;var t=Ui(),e=to(),i=TypeError;return An=function(n){if(t(n))return n;throw new i(e(n)+" is not a function")}}function io(){if(Ln)return Nn;Ln=1;var t=eo(),e=Gn();return Nn=function(i,n){var o=i[n];return e(o)?void 0:t(o)}}function no(){if(Rn)return Fn;Rn=1;var t=Qi(),e=Ui(),i=Vn(),n=TypeError;return Fn=function(o,s){var r,a;if("string"===s&&e(r=o.toString)&&!i(a=t(r,o)))return a;if(e(r=o.valueOf)&&!i(a=t(r,o)))return a;if("string"!==s&&e(r=o.toString)&&!i(a=t(r,o)))return a;throw new n("Can't convert object to primitive value")}}var oo,so,ro,ao,lo,ho,co,uo,po,mo,fo,go,vo,bo,yo,_o,wo,xo,ko,Do,So,Co,To,Mo,Oo,Eo,Po,Ao,Io={exports:{}};function No(){return so?oo:(so=1,oo=!0)}function Lo(){if(ao)return ro;ao=1;var t=ji(),e=Object.defineProperty;return ro=function(i,n){try{e(t,i,{value:n,configurable:!0,writable:!0})}catch(e){t[i]=n}return n}}function Fo(){if(lo)return Io.exports;lo=1;var t=No(),e=ji(),i=Lo(),n="__core-js_shared__",o=Io.exports=e[n]||i(n,{});return(o.versions||(o.versions=[])).push({version:"3.44.0",mode:t?"pure":"global",copyright:"© 2014-2025 Denis Pushkarev (zloirock.ru)",license:"https://github.com/zloirock/core-js/blob/v3.44.0/LICENSE",source:"https://github.com/zloirock/core-js"}),Io.exports}function Ro(){if(co)return ho;co=1;var t=Fo();return ho=function(e,i){return t[e]||(t[e]=i||{})}}function Yo(){if(po)return uo;po=1;var t=Wn(),e=Object;return uo=function(i){return e(t(i))}}function jo(){if(fo)return mo;fo=1;var t=Wi(),e=Yo(),i=t({}.hasOwnProperty);return mo=Object.hasOwn||function(t,n){return i(e(t),n)},mo}function Ho(){if(vo)return go;vo=1;var t=Wi(),e=0,i=Math.random(),n=t(1.1.toString);return go=function(t){return"Symbol("+(void 0===t?"":t)+")_"+n(++e+i,36)}}function zo(){if(yo)return bo;yo=1;var t=ji(),e=Ro(),i=jo(),n=Ho(),o=$n(),s=Jn(),r=t.Symbol,a=e("wks"),l=s?r.for||r:r&&r.withoutSetter||n;return bo=function(t){return i(a,t)||(a[t]=o&&i(r,t)?r[t]:l("Symbol."+t)),a[t]}}function Go(){if(wo)return _o;wo=1;var t=Qi(),e=Vn(),i=Qn(),n=io(),o=no(),s=TypeError,r=zo()("toPrimitive");return _o=function(a,l){if(!e(a)||i(a))return a;var h,d=n(a,r);if(d){if(void 0===l&&(l="default"),h=t(d,a,l),!e(h)||i(h))return h;throw new s("Can't convert object to primitive value")}return void 0===l&&(l="number"),o(a,l)}}function Wo(){if(ko)return xo;ko=1;var t=Go(),e=Qn();return xo=function(i){var n=t(i,"string");return e(n)?n:n+""}}function Bo(){if(So)return Do;So=1;var t=ji(),e=Vn(),i=t.document,n=e(i)&&e(i.createElement);return Do=function(t){return n?i.createElement(t):{}},Do}function Vo(){if(To)return Co;To=1;var t=Ji(),e=Hi(),i=Bo();return Co=!t&&!e(function(){return 7!==Object.defineProperty(i("div"),"a",{get:function(){return 7}}).a})}function Uo(){if(Mo)return $i;Mo=1;var t=Ji(),e=Qi(),i=jn(),n=Hn(),o=Bn(),s=Wo(),r=jo(),a=Vo(),l=Object.getOwnPropertyDescriptor;return $i.f=t?l:function(t,h){if(t=o(t),h=s(h),a)try{return l(t,h)}catch(t){}if(r(t,h))return n(!e(i.f,t,h),t[h])},$i}function Xo(){if(Eo)return Oo;Eo=1;var t=Hi(),e=Ui(),i=/#|\.prototype\./,n=function(i,n){var l=s[o(i)];return l===a||l!==r&&(e(n)?t(n):!!n)},o=n.normalize=function(t){return String(t).replace(i,".").toLowerCase()},s=n.data={},r=n.NATIVE="N",a=n.POLYFILL="P";return Oo=n}function qo(){if(Ao)return Po;Ao=1;var t=Vi(),e=eo(),i=zi(),n=t(t.bind);return Po=function(t,o){return e(t),void 0===o?t:i?n(t,o):function(){return t.apply(o,arguments)}},Po}var Zo,Ko,$o,Jo,Qo,ts,es,is,ns,os,ss,rs,as,ls,hs,ds,cs,us,ps={};function ms(){return Ko?Zo:(Ko=1,Zo=Ji()&&Hi()(function(){return 42!==Object.defineProperty(function(){},"prototype",{value:42,writable:!1}).prototype}))}function fs(){if(Jo)return $o;Jo=1;var t=Vn(),e=String,i=TypeError;return $o=function(n){if(t(n))return n;throw new i(e(n)+" is not an object")}}function gs(){if(Qo)return ps;Qo=1;var t=Ji(),e=Vo(),i=ms(),n=fs(),o=Wo(),s=TypeError,r=Object.defineProperty,a=Object.getOwnPropertyDescriptor,l="enumerable",h="configurable",d="writable";return ps.f=t?i?function(t,e,i){if(n(t),e=o(e),n(i),"function"==typeof t&&"prototype"===e&&"value"in i&&d in i&&!i[d]){var s=a(t,e);s&&s[d]&&(t[e]=i.value,i={configurable:h in i?i[h]:s[h],enumerable:l in i?i[l]:s[l],writable:!1})}return r(t,e,i)}:r:function(t,i,a){if(n(t),i=o(i),n(a),e)try{return r(t,i,a)}catch(t){}if("get"in a||"set"in a)throw new s("Accessors not supported");return"value"in a&&(t[i]=a.value),t},ps}function vs(){if(es)return ts;es=1;var t=Ji(),e=gs(),i=Hn();return ts=t?function(t,n,o){return e.f(t,n,i(1,o))}:function(t,e,i){return t[e]=i,t},ts}function bs(){if(ns)return is;ns=1;var t=ji(),e=Gi(),i=Vi(),n=Ui(),o=Uo().f,s=Xo(),r=Un(),a=qo(),l=vs(),h=jo(),d=function(t){var i=function(n,o,s){if(this instanceof i){switch(arguments.length){case 0:return new t;case 1:return new t(n);case 2:return new t(n,o)}return new t(n,o,s)}return e(t,this,arguments)};return i.prototype=t.prototype,i};return is=function(e,c){var u,p,m,f,g,v,b,y,_,w=e.target,x=e.global,k=e.stat,D=e.proto,S=x?t:k?t[w]:t[w]&&t[w].prototype,C=x?r:r[w]||l(r,w,{})[w],T=C.prototype;for(f in c)p=!(u=s(x?f:w+(k?".":"#")+f,e.forced))&&S&&h(S,f),v=C[f],p&&(b=e.dontCallGetSet?(_=o(S,f))&&_.value:S[f]),g=p&&b?b:c[f],(u||D||typeof v!=typeof g)&&(y=e.bind&&p?a(g,t):e.wrap&&p?d(g):D&&n(g)?i(g):g,(e.sham||g&&g.sham||v&&v.sham)&&l(y,"sham",!0),l(C,f,y),D&&(h(r,m=w+"Prototype")||l(r,m,{}),l(r[m],f,g),e.real&&T&&(u||!T[f])&&l(T,f,g)))}}function ys(){if(ss)return os;ss=1;var t=Bi();return os=Array.isArray||function(e){return"Array"===t(e)}}function _s(){return ls?as:(ls=1,rs||(rs=1,bs()({target:"Array",stat:!0},{isArray:ys()})),as=Un().Array.isArray)}function ws(){return ds?hs:(ds=1,hs=_s())}var xs,ks,Ds,Ss,Cs,Ts,Ms,Os,Es,Ps,As,Is,Ns,Ls,Fs,Rs=n(us?cs:(us=1,cs=ws())),Ys={};function js(){return ks?xs:(ks=1,xs=Wi()([].slice))}function Hs(){if(Ss)return Ds;Ss=1;var t=Wi(),e=eo(),i=Vn(),n=jo(),o=js(),s=zi(),r=Function,a=t([].concat),l=t([].join),h={};return Ds=s?r.bind:function(t){var s=e(this),d=s.prototype,c=o(arguments,1),u=function(){var e=a(c,o(arguments));return this instanceof u?function(t,e,i){if(!n(h,e)){for(var o=[],s=0;s<e;s++)o[s]="a["+s+"]";h[e]=r("C,a","return new C("+l(o,",")+")")}return h[e](t,i)}(s,e.length,e):s.apply(t,e)};return i(d)&&(u.prototype=d),u},Ds}function zs(){if(Ms)return Ts;Ms=1;var t=ji(),e=Un();return Ts=function(i,n){var o=e[i+"Prototype"],s=o&&o[n];if(s)return s;var r=t[i],a=r&&r.prototype;return a&&a[n]}}function Gs(){return Es?Os:(Es=1,function(){if(Cs)return Ys;Cs=1;var t=bs(),e=Hs();t({target:"Function",proto:!0,forced:Function.bind!==e},{bind:e})}(),Os=zs()("Function","bind"))}function Ws(){if(As)return Ps;As=1;var t=qn(),e=Gs(),i=Function.prototype;return Ps=function(n){var o=n.bind;return n===i||t(i,n)&&o===i.bind?e:o},Ps}function Bs(){return Ns?Is:(Ns=1,Is=Ws())}var Vs,Us,Xs,qs,Zs,Ks,$s,Js=n(Fs?Ls:(Fs=1,Ls=Bs())),Qs={},tr={};function er(){if(Us)return Vs;Us=1;var t=ji(),e=Zn(),i=Bi(),n=function(t){return e.slice(0,t.length)===t};return Vs=n("Bun/")?"BUN":n("Cloudflare-Workers")?"CLOUDFLARE":n("Deno/")?"DENO":n("Node.js/")?"NODE":t.Bun&&"string"==typeof Bun.version?"BUN":t.Deno&&"object"==typeof Deno.version?"DENO":"process"===i(t.process)?"NODE":t.window&&t.document?"BROWSER":"REST"}function ir(){if(qs)return Xs;qs=1;var t=TypeError;return Xs=function(e,i){if(e<i)throw new t("Not enough arguments");return e}}function nr(){if(Ks)return Zs;Ks=1;var t,e=ji(),i=Gi(),n=Ui(),o=er(),s=Zn(),r=js(),a=ir(),l=e.Function,h=/MSIE .\./.test(s)||"BUN"===o&&((t=e.Bun.version.split(".")).length<3||"0"===t[0]&&(t[1]<3||"3"===t[1]&&"0"===t[2]));return Zs=function(t,e){var o=e?2:1;return h?function(s,h){var d=a(arguments.length,1)>o,c=n(s)?s:l(s),u=d?r(arguments,o):[],p=d?function(){i(c,this,u)}:c;return e?t(p,h):t(p)}:t},Zs}var or,sr,rr,ar,lr,hr,dr={};function cr(){return sr||(sr=1,function(){if($s)return tr;$s=1;var t=bs(),e=ji(),i=nr()(e.setInterval,!0);t({global:!0,bind:!0,forced:e.setInterval!==i},{setInterval:i})}(),function(){if(or)return dr;or=1;var t=bs(),e=ji(),i=nr()(e.setTimeout,!0);t({global:!0,bind:!0,forced:e.setTimeout!==i},{setTimeout:i})}()),Qs}function ur(){return ar?rr:(ar=1,cr(),rr=Un().setTimeout)}var pr,mr,fr,gr,vr=n(hr?lr:(hr=1,lr=ur()));function br(){if(mr)return pr;mr=1;var t={};return t[zo()("toStringTag")]="z",pr="[object z]"===String(t)}function yr(){if(gr)return fr;gr=1;var t=br(),e=Ui(),i=Bi(),n=zo()("toStringTag"),o=Object,s="Arguments"===i(function(){return arguments}());return fr=t?i:function(t){var r,a,l;return void 0===t?"Undefined":null===t?"Null":"string"==typeof(a=function(t,e){try{return t[e]}catch(t){}}(r=o(t),n))?a:s?i(r):"Object"===(l=i(r))&&e(r.callee)?"Arguments":l},fr}var _r,wr,xr,kr,Dr,Sr,Cr,Tr,Mr,Or,Er,Pr,Ar,Ir,Nr,Lr,Fr,Rr,Yr,jr,Hr,zr,Gr,Wr,Br,Vr,Ur,Xr,qr,Zr,Kr,$r={};function Jr(){if(wr)return _r;wr=1;var t=Math.ceil,e=Math.floor;return _r=Math.trunc||function(i){var n=+i;return(n>0?e:t)(n)}}function Qr(){if(kr)return xr;kr=1;var t=Jr();return xr=function(e){var i=+e;return i!=i||0===i?0:t(i)},xr}function ta(){if(Sr)return Dr;Sr=1;var t=Qr(),e=Math.min;return Dr=function(i){var n=t(i);return n>0?e(n,9007199254740991):0}}function ea(){if(Tr)return Cr;Tr=1;var t=ta();return Cr=function(e){return t(e.length)}}function ia(){if(Or)return Mr;Or=1;var t=Wi(),e=Ui(),i=Fo(),n=t(Function.toString);return e(i.inspectSource)||(i.inspectSource=function(t){return n(t)}),Mr=i.inspectSource}function na(){if(Pr)return Er;Pr=1;var t=Wi(),e=Hi(),i=Ui(),n=yr(),o=Xn(),s=ia(),r=function(){},a=o("Reflect","construct"),l=/^\s*(?:class|function)\b/,h=t(l.exec),d=!l.test(r),c=function(t){if(!i(t))return!1;try{return a(r,[],t),!0}catch(t){return!1}},u=function(t){if(!i(t))return!1;switch(n(t)){case"AsyncFunction":case"GeneratorFunction":case"AsyncGeneratorFunction":return!1}try{return d||!!h(l,s(t))}catch(t){return!0}};return u.sham=!0,Er=!a||e(function(){var t;return c(c.call)||!c(Object)||!c(function(){t=!0})||t})?u:c}function oa(){if(Ir)return Ar;Ir=1;var t=ys(),e=na(),i=Vn(),n=zo()("species"),o=Array;return Ar=function(s){var r;return t(s)&&(r=s.constructor,(e(r)&&(r===o||t(r.prototype))||i(r)&&null===(r=r[n]))&&(r=void 0)),void 0===r?o:r}}function sa(){if(Lr)return Nr;Lr=1;var t=oa();return Nr=function(e,i){return new(t(e))(0===i?0:i)}}function ra(){if(Rr)return Fr;Rr=1;var t=qo(),e=Wi(),i=zn(),n=Yo(),o=ea(),s=sa(),r=e([].push),a=function(e){var a=1===e,l=2===e,h=3===e,d=4===e,c=6===e,u=7===e,p=5===e||c;return function(m,f,g,v){for(var b,y,_=n(m),w=i(_),x=o(w),k=t(f,g),D=0,S=v||s,C=a?S(m,x):l||u?S(m,0):void 0;x>D;D++)if((p||D in w)&&(y=k(b=w[D],D,_),e))if(a)C[D]=y;else if(y)switch(e){case 3:return!0;case 5:return b;case 6:return D;case 2:r(C,b)}else switch(e){case 4:return!1;case 7:r(C,b)}return c?-1:h||d?d:C}};return Fr={forEach:a(0),map:a(1),filter:a(2),some:a(3),every:a(4),find:a(5),findIndex:a(6),filterReject:a(7)}}function aa(){if(jr)return Yr;jr=1;var t=Hi();return Yr=function(e,i){var n=[][e];return!!n&&t(function(){n.call(null,i||function(){return 1},1)})}}function la(){if(zr)return Hr;zr=1;var t=ra().forEach,e=aa()("forEach");return Hr=e?[].forEach:function(e){return t(this,e,arguments.length>1?arguments[1]:void 0)},Hr}function ha(){return Br?Wr:(Br=1,function(){if(Gr)return $r;Gr=1;var t=bs(),e=la();t({target:"Array",proto:!0,forced:[].forEach!==e},{forEach:e})}(),Wr=zs()("Array","forEach"))}function da(){return Ur?Vr:(Ur=1,Vr=ha())}function ca(){if(qr)return Xr;qr=1;var t=yr(),e=jo(),i=qn(),n=da(),o=Array.prototype,s={DOMTokenList:!0,NodeList:!0};return Xr=function(r){var a=r.forEach;return r===o||i(o,r)&&a===o.forEach||e(s,t(r))?n:a},Xr}var ua=n(Kr?Zr:(Kr=1,Zr=ca())),pa=n(a());const ma="undefined"!=typeof window&&window.moment||pa;var fa,ga,va={},ba={};function ya(){if(ga)return fa;ga=1;var t=yr(),e=String;return fa=function(i){if("Symbol"===t(i))throw new TypeError("Cannot convert a Symbol value to a string");return e(i)}}var _a,wa,xa,ka,Da,Sa,Ca,Ta,Ma,Oa,Ea,Pa,Aa,Ia,Na,La,Fa,Ra,Ya,ja={};function Ha(){if(wa)return _a;wa=1;var t=Qr(),e=Math.max,i=Math.min;return _a=function(n,o){var s=t(n);return s<0?e(s+o,0):i(s,o)}}function za(){if(ka)return xa;ka=1;var t=Bn(),e=Ha(),i=ea(),n=function(n){return function(o,s,r){var a=t(o),l=i(a);if(0===l)return!n&&-1;var h,d=e(r,l);if(n&&s!=s){for(;l>d;)if((h=a[d++])!=h)return!0}else for(;l>d;d++)if((n||d in a)&&a[d]===s)return n||d||0;return!n&&-1}};return xa={includes:n(!0),indexOf:n(!1)}}function Ga(){return Sa?Da:(Sa=1,Da={})}function Wa(){if(Ta)return Ca;Ta=1;var t=Wi(),e=jo(),i=Bn(),n=za().indexOf,o=Ga(),s=t([].push);return Ca=function(t,r){var a,l=i(t),h=0,d=[];for(a in l)!e(o,a)&&e(l,a)&&s(d,a);for(;r.length>h;)e(l,a=r[h++])&&(~n(d,a)||s(d,a));return d},Ca}function Ba(){return Oa?Ma:(Oa=1,Ma=["constructor","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","toLocaleString","toString","valueOf"])}function Va(){if(Pa)return Ea;Pa=1;var t=Wa(),e=Ba();return Ea=Object.keys||function(i){return t(i,e)}}function Ua(){if(Aa)return ja;Aa=1;var t=Ji(),e=ms(),i=gs(),n=fs(),o=Bn(),s=Va();return ja.f=t&&!e?Object.defineProperties:function(t,e){n(t);for(var r,a=o(e),l=s(e),h=l.length,d=0;h>d;)i.f(t,r=l[d++],a[r]);return t},ja}function Xa(){return Na?Ia:(Na=1,Ia=Xn()("document","documentElement"))}function qa(){if(Fa)return La;Fa=1;var t=Ro(),e=Ho(),i=t("keys");return La=function(t){return i[t]||(i[t]=e(t))}}function Za(){if(Ya)return Ra;Ya=1;var t,e=fs(),i=Ua(),n=Ba(),o=Ga(),s=Xa(),r=Bo(),a="prototype",l="script",h=qa()("IE_PROTO"),d=function(){},c=function(t){return"<"+l+">"+t+"</"+l+">"},u=function(t){t.write(c("")),t.close();var e=t.parentWindow.Object;return t=null,e},p=function(){try{t=new ActiveXObject("htmlfile")}catch(t){}var e,i,o;p="undefined"!=typeof document?document.domain&&t?u(t):(i=r("iframe"),o="java"+l+":",i.style.display="none",s.appendChild(i),i.src=String(o),(e=i.contentWindow.document).open(),e.write(c("document.F=Object")),e.close(),e.F):u(t);for(var h=n.length;h--;)delete p[a][n[h]];return p()};return o[h]=!0,Ra=Object.create||function(t,n){var o;return null!==t?(d[a]=e(t),o=new d,d[a]=null,o[h]=t):o=p(),void 0===n?o:i.f(o,n)}}var Ka,$a={};function Ja(){if(Ka)return $a;Ka=1;var t=Wa(),e=Ba().concat("length","prototype");return $a.f=Object.getOwnPropertyNames||function(i){return t(i,e)},$a}var Qa,tl={};function el(){if(Qa)return tl;Qa=1;var t=Bi(),e=Bn(),i=Ja().f,n=js(),o="object"==typeof window&&window&&Object.getOwnPropertyNames?Object.getOwnPropertyNames(window):[];return tl.f=function(s){return o&&"Window"===t(s)?function(t){try{return i(t)}catch(t){return n(o)}}(s):i(e(s))},tl}var il,nl,ol,sl,rl,al={};function ll(){return il||(il=1,al.f=Object.getOwnPropertySymbols),al}function hl(){if(ol)return nl;ol=1;var t=vs();return nl=function(e,i,n,o){return o&&o.enumerable?e[i]=n:t(e,i,n),e}}function dl(){if(rl)return sl;rl=1;var t=gs();return sl=function(e,i,n){return t.f(e,i,n)}}var cl,ul,pl,ml,fl,gl,vl,bl,yl,_l,wl,xl,kl,Dl,Sl={};function Cl(){if(cl)return Sl;cl=1;var t=zo();return Sl.f=t,Sl}function Tl(){if(pl)return ul;pl=1;var t=Un(),e=jo(),i=Cl(),n=gs().f;return ul=function(o){var s=t.Symbol||(t.Symbol={});e(s,o)||n(s,o,{value:i.f(o)})}}function Ml(){if(fl)return ml;fl=1;var t=Qi(),e=Xn(),i=zo(),n=hl();return ml=function(){var o=e("Symbol"),s=o&&o.prototype,r=s&&s.valueOf,a=i("toPrimitive");s&&!s[a]&&n(s,a,function(e){return t(r,this)},{arity:1})}}function Ol(){if(vl)return gl;vl=1;var t=br(),e=yr();return gl=t?{}.toString:function(){return"[object "+e(this)+"]"}}function El(){if(yl)return bl;yl=1;var t=br(),e=gs().f,i=vs(),n=jo(),o=Ol(),s=zo()("toStringTag");return bl=function(r,a,l,h){var d=l?r:r&&r.prototype;d&&(n(d,s)||e(d,s,{configurable:!0,value:a}),h&&!t&&i(d,"toString",o))},bl}function Pl(){if(wl)return _l;wl=1;var t=ji(),e=Ui(),i=t.WeakMap;return _l=e(i)&&/native code/.test(String(i))}function Al(){if(kl)return xl;kl=1;var t,e,i,n=Pl(),o=ji(),s=Vn(),r=vs(),a=jo(),l=Fo(),h=qa(),d=Ga(),c="Object already initialized",u=o.TypeError,p=o.WeakMap;if(n||l.state){var m=l.state||(l.state=new p);m.get=m.get,m.has=m.has,m.set=m.set,t=function(t,e){if(m.has(t))throw new u(c);return e.facade=t,m.set(t,e),e},e=function(t){return m.get(t)||{}},i=function(t){return m.has(t)}}else{var f=h("state");d[f]=!0,t=function(t,e){if(a(t,f))throw new u(c);return e.facade=t,r(t,f,e),e},e=function(t){return a(t,f)?t[f]:{}},i=function(t){return a(t,f)}}return xl={set:t,get:e,has:i,enforce:function(n){return i(n)?e(n):t(n,{})},getterFor:function(t){return function(i){var n;if(!s(i)||(n=e(i)).type!==t)throw new u("Incompatible receiver, "+t+" required");return n}}},xl}var Il,Nl,Ll,Fl={};function Rl(){return Nl?Il:(Nl=1,Il=$n()&&!!Symbol.for&&!!Symbol.keyFor)}var Yl,jl={};var Hl,zl,Gl,Wl={};function Bl(){if(zl)return Hl;zl=1;var t=Wi(),e=ys(),i=Ui(),n=Bi(),o=ya(),s=t([].push);return Hl=function(t){if(i(t))return t;if(e(t)){for(var r=t.length,a=[],l=0;l<r;l++){var h=t[l];"string"==typeof h?s(a,h):"number"!=typeof h&&"Number"!==n(h)&&"String"!==n(h)||s(a,o(h))}var d=a.length,c=!0;return function(t,i){if(c)return c=!1,i;if(e(this))return i;for(var n=0;n<d;n++)if(a[n]===t)return i}}},Hl}function Vl(){if(Gl)return Wl;Gl=1;var t=bs(),e=Xn(),i=Gi(),n=Qi(),o=Wi(),s=Hi(),r=Ui(),a=Qn(),l=js(),h=Bl(),d=$n(),c=String,u=e("JSON","stringify"),p=o(/./.exec),m=o("".charAt),f=o("".charCodeAt),g=o("".replace),v=o(1.1.toString),b=/[\uD800-\uDFFF]/g,y=/^[\uD800-\uDBFF]$/,_=/^[\uDC00-\uDFFF]$/,w=!d||s(function(){var t=e("Symbol")("stringify detection");return"[null]"!==u([t])||"{}"!==u({a:t})||"{}"!==u(Object(t))}),x=s(function(){return'"\\udf06\\ud834"'!==u("\udf06\ud834")||'"\\udead"'!==u("\udead")}),k=function(t,e){var o=l(arguments),s=h(e);if(r(s)||void 0!==t&&!a(t))return o[1]=function(t,e){if(r(s)&&(e=n(s,this,c(t),e)),!a(e))return e},i(u,null,o)},D=function(t,e,i){var n=m(i,e-1),o=m(i,e+1);return p(y,t)&&!p(_,o)||p(_,t)&&!p(y,n)?"\\u"+v(f(t,0),16):t};return u&&t({target:"JSON",stat:!0,arity:3,forced:w||x},{stringify:function(t,e,n){var o=l(arguments),s=i(w?k:u,null,o);return x&&"string"==typeof s?g(s,b,D):s}}),Wl}var Ul,Xl,ql,Zl,Kl,$l,Jl,Ql,th={};function eh(){return Xl||(Xl=1,function(){if(Dl)return ba;Dl=1;var t=bs(),e=ji(),i=Qi(),n=Wi(),o=No(),s=Ji(),r=$n(),a=Hi(),l=jo(),h=qn(),d=fs(),c=Bn(),u=Wo(),p=ya(),m=Hn(),f=Za(),g=Va(),v=Ja(),b=el(),y=ll(),_=Uo(),w=gs(),x=Ua(),k=jn(),D=hl(),S=dl(),C=Ro(),T=qa(),M=Ga(),O=Ho(),E=zo(),P=Cl(),A=Tl(),I=Ml(),N=El(),L=Al(),F=ra().forEach,R=T("hidden"),Y="Symbol",j="prototype",H=L.set,z=L.getterFor(Y),G=Object[j],W=e.Symbol,B=W&&W[j],V=e.RangeError,U=e.TypeError,X=e.QObject,q=_.f,Z=w.f,K=b.f,$=k.f,J=n([].push),Q=C("symbols"),tt=C("op-symbols"),et=C("wks"),it=!X||!X[j]||!X[j].findChild,nt=function(t,e,i){var n=q(G,e);n&&delete G[e],Z(t,e,i),n&&t!==G&&Z(G,e,n)},ot=s&&a(function(){return 7!==f(Z({},"a",{get:function(){return Z(this,"a",{value:7}).a}})).a})?nt:Z,st=function(t,e){var i=Q[t]=f(B);return H(i,{type:Y,tag:t,description:e}),s||(i.description=e),i},rt=function(t,e,i){t===G&&rt(tt,e,i),d(t);var n=u(e);return d(i),l(Q,n)?(i.enumerable?(l(t,R)&&t[R][n]&&(t[R][n]=!1),i=f(i,{enumerable:m(0,!1)})):(l(t,R)||Z(t,R,m(1,f(null))),t[R][n]=!0),ot(t,n,i)):Z(t,n,i)},at=function(t,e){d(t);var n=c(e),o=g(n).concat(ct(n));return F(o,function(e){s&&!i(lt,n,e)||rt(t,e,n[e])}),t},lt=function(t){var e=u(t),n=i($,this,e);return!(this===G&&l(Q,e)&&!l(tt,e))&&(!(n||!l(this,e)||!l(Q,e)||l(this,R)&&this[R][e])||n)},ht=function(t,e){var i=c(t),n=u(e);if(i!==G||!l(Q,n)||l(tt,n)){var o=q(i,n);return!o||!l(Q,n)||l(i,R)&&i[R][n]||(o.enumerable=!0),o}},dt=function(t){var e=K(c(t)),i=[];return F(e,function(t){l(Q,t)||l(M,t)||J(i,t)}),i},ct=function(t){var e=t===G,i=K(e?tt:c(t)),n=[];return F(i,function(t){!l(Q,t)||e&&!l(G,t)||J(n,Q[t])}),n};r||(W=function(){if(h(B,this))throw new U("Symbol is not a constructor");var t=arguments.length&&void 0!==arguments[0]?p(arguments[0]):void 0,n=O(t),o=function(t){var s=void 0===this?e:this;s===G&&i(o,tt,t),l(s,R)&&l(s[R],n)&&(s[R][n]=!1);var r=m(1,t);try{ot(s,n,r)}catch(t){if(!(t instanceof V))throw t;nt(s,n,r)}};return s&&it&&ot(G,n,{configurable:!0,set:o}),st(n,t)},D(B=W[j],"toString",function(){return z(this).tag}),D(W,"withoutSetter",function(t){return st(O(t),t)}),k.f=lt,w.f=rt,x.f=at,_.f=ht,v.f=b.f=dt,y.f=ct,P.f=function(t){return st(E(t),t)},s&&(S(B,"description",{configurable:!0,get:function(){return z(this).description}}),o||D(G,"propertyIsEnumerable",lt,{unsafe:!0}))),t({global:!0,constructor:!0,wrap:!0,forced:!r,sham:!r},{Symbol:W}),F(g(et),function(t){A(t)}),t({target:Y,stat:!0,forced:!r},{useSetter:function(){it=!0},useSimple:function(){it=!1}}),t({target:"Object",stat:!0,forced:!r,sham:!s},{create:function(t,e){return void 0===e?f(t):at(f(t),e)},defineProperty:rt,defineProperties:at,getOwnPropertyDescriptor:ht}),t({target:"Object",stat:!0,forced:!r},{getOwnPropertyNames:dt}),I(),N(W,Y),M[R]=!0}(),function(){if(Ll)return Fl;Ll=1;var t=bs(),e=Xn(),i=jo(),n=ya(),o=Ro(),s=Rl(),r=o("string-to-symbol-registry"),a=o("symbol-to-string-registry");t({target:"Symbol",stat:!0,forced:!s},{for:function(t){var o=n(t);if(i(r,o))return r[o];var s=e("Symbol")(o);return r[o]=s,a[s]=o,s}})}(),function(){if(Yl)return jl;Yl=1;var t=bs(),e=jo(),i=Qn(),n=to(),o=Ro(),s=Rl(),r=o("symbol-to-string-registry");t({target:"Symbol",stat:!0,forced:!s},{keyFor:function(t){if(!i(t))throw new TypeError(n(t)+" is not a symbol");if(e(r,t))return r[t]}})}(),Vl(),function(){if(Ul)return th;Ul=1;var t=bs(),e=$n(),i=Hi(),n=ll(),o=Yo();t({target:"Object",stat:!0,forced:!e||i(function(){n.f(1)})},{getOwnPropertySymbols:function(t){var e=n.f;return e?e(o(t)):[]}})}()),va}function ih(){return Zl?ql:(Zl=1,eh(),ql=Un().Object.getOwnPropertySymbols)}function nh(){return $l?Kl:($l=1,Kl=ih())}var oh,sh,rh,ah,lh,hh,dh,ch,uh,ph,mh,fh=n(Ql?Jl:(Ql=1,Jl=nh())),gh={};function vh(){if(sh)return oh;sh=1;var t=Hi(),e=zo(),i=Kn(),n=e("species");return oh=function(e){return i>=51||!t(function(){var t=[];return(t.constructor={})[n]=function(){return{foo:1}},1!==t[e](Boolean).foo})},oh}function bh(){return lh?ah:(lh=1,function(){if(rh)return gh;rh=1;var t=bs(),e=ra().filter;t({target:"Array",proto:!0,forced:!vh()("filter")},{filter:function(t){return e(this,t,arguments.length>1?arguments[1]:void 0)}})}(),ah=zs()("Array","filter"))}function yh(){if(dh)return hh;dh=1;var t=qn(),e=bh(),i=Array.prototype;return hh=function(n){var o=n.filter;return n===i||t(i,n)&&o===i.filter?e:o},hh}function _h(){return uh?ch:(uh=1,ch=yh())}var wh,xh,kh,Dh,Sh,Ch,Th=n(mh?ph:(mh=1,ph=_h())),Mh={exports:{}},Oh={};function Eh(){if(xh)return Mh.exports;xh=1,function(){if(wh)return Oh;wh=1;var t=bs(),e=Hi(),i=Bn(),n=Uo().f,o=Ji();t({target:"Object",stat:!0,forced:!o||e(function(){n(1)}),sham:!o},{getOwnPropertyDescriptor:function(t,e){return n(i(t),e)}})}();var t=Un().Object,e=Mh.exports=function(e,i){return t.getOwnPropertyDescriptor(e,i)};return t.getOwnPropertyDescriptor.sham&&(e.sham=!0),Mh.exports}function Ph(){return Dh?kh:(Dh=1,kh=Eh())}var Ah,Ih,Nh,Lh,Fh,Rh,Yh,jh,Hh,zh,Gh,Wh=n(Ch?Sh:(Ch=1,Sh=Ph())),Bh={};function Vh(){if(Ih)return Ah;Ih=1;var t=Xn(),e=Wi(),i=Ja(),n=ll(),o=fs(),s=e([].concat);return Ah=t("Reflect","ownKeys")||function(t){var e=i.f(o(t)),r=n.f;return r?s(e,r(t)):e},Ah}function Uh(){if(Lh)return Nh;Lh=1;var t=Ji(),e=gs(),i=Hn();return Nh=function(n,o,s){t?e.f(n,o,i(0,s)):n[o]=s},Nh}function Xh(){return Yh?Rh:(Yh=1,function(){if(Fh)return Bh;Fh=1;var t=bs(),e=Ji(),i=Vh(),n=Bn(),o=Uo(),s=Uh();t({target:"Object",stat:!0,sham:!e},{getOwnPropertyDescriptors:function(t){for(var e,r,a=n(t),l=o.f,h=i(a),d={},c=0;h.length>c;)void 0!==(r=l(a,e=h[c++]))&&s(d,e,r);return d}})}(),Rh=Un().Object.getOwnPropertyDescriptors)}function qh(){return Hh?jh:(Hh=1,jh=Xh())}var Zh,Kh,$h,Jh,Qh,td,ed=n(Gh?zh:(Gh=1,zh=qh())),id={exports:{}},nd={};function od(){if(Zh)return nd;Zh=1;var t=bs(),e=Ji(),i=Ua().f;return t({target:"Object",stat:!0,forced:Object.defineProperties!==i,sham:!e},{defineProperties:i}),nd}function sd(){if(Kh)return id.exports;Kh=1,od();var t=Un().Object,e=id.exports=function(e,i){return t.defineProperties(e,i)};return t.defineProperties.sham&&(e.sham=!0),id.exports}function rd(){return Jh?$h:(Jh=1,$h=sd())}var ad,ld,hd,dd,cd,ud,pd,md,fd,gd,vd=n(td?Qh:(td=1,Qh=rd())),bd={exports:{}},yd={};function _d(){if(ad)return yd;ad=1;var t=bs(),e=Ji(),i=gs().f;return t({target:"Object",stat:!0,forced:Object.defineProperty!==i,sham:!e},{defineProperty:i}),yd}function wd(){if(ld)return bd.exports;ld=1,_d();var t=Un().Object,e=bd.exports=function(e,i,n){return t.defineProperty(e,i,n)};return t.defineProperty.sham&&(e.sham=!0),bd.exports}function xd(){return dd?hd:(dd=1,hd=wd())}function kd(){return ud?cd:(ud=1,cd=xd())}function Dd(){return md?pd:(md=1,pd=kd())}function Sd(){return gd?fd:(gd=1,fd=Dd())}var Cd,Td,Md,Od=n(Sd()),Ed={};function Pd(){if(Td)return Cd;Td=1;var t=TypeError;return Cd=function(e){if(e>9007199254740991)throw t("Maximum allowed index exceeded");return e},Cd}function Ad(){if(Md)return Ed;Md=1;var t=bs(),e=Hi(),i=ys(),n=Vn(),o=Yo(),s=ea(),r=Pd(),a=Uh(),l=sa(),h=vh(),d=zo(),c=Kn(),u=d("isConcatSpreadable"),p=c>=51||!e(function(){var t=[];return t[u]=!1,t.concat()[0]!==t}),m=function(t){if(!n(t))return!1;var e=t[u];return void 0!==e?!!e:i(t)};return t({target:"Array",proto:!0,arity:1,forced:!p||!h("concat")},{concat:function(t){var e,i,n,h,d,c=o(this),u=l(c,0),p=0;for(e=-1,n=arguments.length;e<n;e++)if(m(d=-1===e?c:arguments[e]))for(h=s(d),r(p+h),i=0;i<h;i++,p++)i in d&&a(u,p,d[i]);else r(p+1),a(u,p++,d);return u.length=p,u}}),Ed}var Id,Nd={};function Ld(){return Id||(Id=1,Tl()("asyncDispose")),Nd}var Fd;var Rd,Yd={};function jd(){return Rd||(Rd=1,Tl()("dispose")),Yd}var Hd;var zd;var Gd,Wd={};function Bd(){return Gd||(Gd=1,Tl()("iterator")),Wd}var Vd;var Ud;var Xd;var qd;var Zd;var Kd;var $d,Jd={};function Qd(){if($d)return Jd;$d=1;var t=Tl(),e=Ml();return t("toPrimitive"),e(),Jd}var tc,ec={};var ic;var nc,oc,sc,rc={};function ac(){return sc?oc:(sc=1,Ad(),eh(),Ld(),Fd||(Fd=1,Tl()("asyncIterator")),jd(),Hd||(Hd=1,Tl()("hasInstance")),zd||(zd=1,Tl()("isConcatSpreadable")),Bd(),Vd||(Vd=1,Tl()("match")),Ud||(Ud=1,Tl()("matchAll")),Xd||(Xd=1,Tl()("replace")),qd||(qd=1,Tl()("search")),Zd||(Zd=1,Tl()("species")),Kd||(Kd=1,Tl()("split")),Qd(),function(){if(tc)return ec;tc=1;var t=Xn(),e=Tl(),i=El();e("toStringTag"),i(t("Symbol"),"Symbol")}(),ic||(ic=1,Tl()("unscopables")),function(){if(nc)return rc;nc=1;var t=ji();El()(t.JSON,"JSON",!0)}(),oc=Un().Symbol)}var lc,hc,dc,cc,uc,pc,mc,fc,gc,vc,bc,yc,_c,wc,xc,kc,Dc,Sc,Cc,Tc,Mc,Oc,Ec,Pc,Ac,Ic,Nc,Lc,Fc,Rc,Yc,jc,Hc,zc={};function Gc(){return hc?lc:(hc=1,lc=function(){})}function Wc(){return cc?dc:(cc=1,dc={})}function Bc(){if(pc)return uc;pc=1;var t=Ji(),e=jo(),i=Function.prototype,n=t&&Object.getOwnPropertyDescriptor,o=e(i,"name"),s=o&&"something"===function(){}.name,r=o&&(!t||t&&n(i,"name").configurable);return uc={EXISTS:o,PROPER:s,CONFIGURABLE:r}}function Vc(){return fc?mc:(fc=1,mc=!Hi()(function(){function t(){}return t.prototype.constructor=null,Object.getPrototypeOf(new t)!==t.prototype}))}function Uc(){if(vc)return gc;vc=1;var t=jo(),e=Ui(),i=Yo(),n=qa(),o=Vc(),s=n("IE_PROTO"),r=Object,a=r.prototype;return gc=o?r.getPrototypeOf:function(n){var o=i(n);if(t(o,s))return o[s];var l=o.constructor;return e(l)&&o instanceof l?l.prototype:o instanceof r?a:null},gc}function Xc(){if(yc)return bc;yc=1;var t,e,i,n=Hi(),o=Ui(),s=Vn(),r=Za(),a=Uc(),l=hl(),h=zo(),d=No(),c=h("iterator"),u=!1;return[].keys&&("next"in(i=[].keys())?(e=a(a(i)))!==Object.prototype&&(t=e):u=!0),!s(t)||n(function(){var e={};return t[c].call(e)!==e})?t={}:d&&(t=r(t)),o(t[c])||l(t,c,function(){return this}),bc={IteratorPrototype:t,BUGGY_SAFARI_ITERATORS:u}}function qc(){if(wc)return _c;wc=1;var t=Xc().IteratorPrototype,e=Za(),i=Hn(),n=El(),o=Wc(),s=function(){return this};return _c=function(r,a,l,h){var d=a+" Iterator";return r.prototype=e(t,{next:i(+!h,l)}),n(r,d,!1,!0),o[d]=s,r}}function Zc(){if(kc)return xc;kc=1;var t=Wi(),e=eo();return xc=function(i,n,o){try{return t(e(Object.getOwnPropertyDescriptor(i,n)[o]))}catch(t){}},xc}function Kc(){if(Sc)return Dc;Sc=1;var t=Vn();return Dc=function(e){return t(e)||null===e}}function $c(){if(Tc)return Cc;Tc=1;var t=Kc(),e=String,i=TypeError;return Cc=function(n){if(t(n))return n;throw new i("Can't set "+e(n)+" as a prototype")}}function Jc(){if(Oc)return Mc;Oc=1;var t=Zc(),e=Vn(),i=Wn(),n=$c();return Mc=Object.setPrototypeOf||("__proto__"in{}?function(){var o,s=!1,r={};try{(o=t(Object.prototype,"__proto__","set"))(r,[]),s=r instanceof Array}catch(t){}return function(t,r){return i(t),n(r),e(t)?(s?o(t,r):t.__proto__=r,t):t}}():void 0)}function Qc(){if(Pc)return Ec;Pc=1;var t=bs(),e=Qi(),i=No(),n=Bc(),o=Ui(),s=qc(),r=Uc(),a=Jc(),l=El(),h=vs(),d=hl(),c=zo(),u=Wc(),p=Xc(),m=n.PROPER,f=n.CONFIGURABLE,g=p.IteratorPrototype,v=p.BUGGY_SAFARI_ITERATORS,b=c("iterator"),y="keys",_="values",w="entries",x=function(){return this};return Ec=function(n,c,p,k,D,S,C){s(p,c,k);var T,M,O,E=function(t){if(t===D&&L)return L;if(!v&&t&&t in I)return I[t];switch(t){case y:case _:case w:return function(){return new p(this,t)}}return function(){return new p(this)}},P=c+" Iterator",A=!1,I=n.prototype,N=I[b]||I["@@iterator"]||D&&I[D],L=!v&&N||E(D),F="Array"===c&&I.entries||N;if(F&&(T=r(F.call(new n)))!==Object.prototype&&T.next&&(i||r(T)===g||(a?a(T,g):o(T[b])||d(T,b,x)),l(T,P,!0,!0),i&&(u[P]=x)),m&&D===_&&N&&N.name!==_&&(!i&&f?h(I,"name",_):(A=!0,L=function(){return e(N,this)})),D)if(M={values:E(_),keys:S?L:E(y),entries:E(w)},C)for(O in M)(v||A||!(O in I))&&d(I,O,M[O]);else t({target:c,proto:!0,forced:v||A},M);return i&&!C||I[b]===L||d(I,b,L,{name:D}),u[c]=L,M}}function tu(){return Ic?Ac:(Ic=1,Ac=function(t,e){return{value:t,done:e}})}function eu(){if(Lc)return Nc;Lc=1;var t=Bn(),e=Gc(),i=Wc(),n=Al(),o=gs().f,s=Qc(),r=tu(),a=No(),l=Ji(),h="Array Iterator",d=n.set,c=n.getterFor(h);Nc=s(Array,"Array",function(e,i){d(this,{type:h,target:t(e),index:0,kind:i})},function(){var t=c(this),e=t.target,i=t.index++;if(!e||i>=e.length)return t.target=null,r(void 0,!0);switch(t.kind){case"keys":return r(i,!1);case"values":return r(e[i],!1)}return r([i,e[i]],!1)},"values");var u=i.Arguments=i.Array;if(e("keys"),e("values"),e("entries"),!a&&l&&"values"!==u.name)try{o(u,"name",{value:"values"})}catch(t){}return Nc}function iu(){return Rc?Fc:(Rc=1,Fc={CSSRuleList:0,CSSStyleDeclaration:0,CSSValueList:0,ClientRectList:0,DOMRectList:0,DOMStringList:0,DOMTokenList:1,DataTransferItemList:0,FileList:0,HTMLAllCollection:0,HTMLCollection:0,HTMLFormElement:0,HTMLSelectElement:0,MediaList:0,MimeTypeArray:0,NamedNodeMap:0,NodeList:1,PaintRequestList:0,Plugin:0,PluginArray:0,SVGLengthList:0,SVGNumberList:0,SVGPathSegList:0,SVGPointList:0,SVGStringList:0,SVGTransformList:0,SourceBufferList:0,StyleSheetList:0,TextTrackCueList:0,TextTrackList:0,TouchList:0})}function nu(){if(Yc)return zc;Yc=1,eu();var t=iu(),e=ji(),i=El(),n=Wc();for(var o in t)i(e[o],o),n[o]=n.Array;return zc}function ou(){if(Hc)return jc;Hc=1;var t=ac();return nu(),jc=t}var su,ru={};var au;var lu;var hu,du,cu;function uu(){if(cu)return du;cu=1;var t=ou();return function(){if(su)return ru;su=1;var t=zo(),e=gs().f,i=t("metadata"),n=Function.prototype;void 0===n[i]&&e(n,i,{value:null})}(),au||(au=1,Ld()),lu||(lu=1,jd()),hu||(hu=1,Tl()("metadata")),du=t}var pu,mu,fu;function gu(){if(mu)return pu;mu=1;var t=Xn(),e=Wi(),i=t("Symbol"),n=i.keyFor,o=e(i.prototype.valueOf);return pu=i.isRegisteredSymbol||function(t){try{return void 0!==n(o(t))}catch(t){return!1}}}var vu,bu,yu;function _u(){if(bu)return vu;bu=1;for(var t=Ro(),e=Xn(),i=Wi(),n=Qn(),o=zo(),s=e("Symbol"),r=s.isWellKnownSymbol,a=e("Object","getOwnPropertyNames"),l=i(s.prototype.valueOf),h=t("wks"),d=0,c=a(s),u=c.length;d<u;d++)try{var p=c[d];n(s[p])&&o(p)}catch(t){}return vu=function(t){if(r&&r(t))return!0;try{for(var e=l(t),i=0,n=a(h),o=n.length;i<o;i++)if(h[n[i]]==e)return!0}catch(t){}return!1},vu}var wu;var xu;var ku;var Du;var Su;var Cu;var Tu;var Mu,Ou,Eu,Pu,Au;function Iu(){if(Eu)return Ou;Eu=1;var t=uu();return fu||(fu=1,bs()({target:"Symbol",stat:!0},{isRegisteredSymbol:gu()})),yu||(yu=1,bs()({target:"Symbol",stat:!0,forced:!0},{isWellKnownSymbol:_u()})),wu||(wu=1,Tl()("customMatcher")),xu||(xu=1,Tl()("observable")),ku||(ku=1,bs()({target:"Symbol",stat:!0,name:"isRegisteredSymbol"},{isRegistered:gu()})),Du||(Du=1,bs()({target:"Symbol",stat:!0,name:"isWellKnownSymbol",forced:!0},{isWellKnown:_u()})),Su||(Su=1,Tl()("matcher")),Cu||(Cu=1,Tl()("metadataKey")),Tu||(Tu=1,Tl()("patternMatch")),Mu||(Mu=1,Tl()("replaceAll")),Ou=t}function Nu(){return Au?Pu:(Au=1,Pu=Iu())}var Lu,Fu,Ru,Yu,ju,Hu,zu,Gu,Wu,Bu,Vu,Uu,Xu,qu=n(Nu()),Zu={};function Ku(){if(Fu)return Lu;Fu=1;var t=Wi(),e=Qr(),i=ya(),n=Wn(),o=t("".charAt),s=t("".charCodeAt),r=t("".slice),a=function(t){return function(a,l){var h,d,c=i(n(a)),u=e(l),p=c.length;return u<0||u>=p?t?"":void 0:(h=s(c,u))<55296||h>56319||u+1===p||(d=s(c,u+1))<56320||d>57343?t?o(c,u):h:t?r(c,u,u+2):d-56320+(h-55296<<10)+65536}};return Lu={codeAt:a(!1),charAt:a(!0)}}function $u(){if(Ru)return Zu;Ru=1;var t=Ku().charAt,e=ya(),i=Al(),n=Qc(),o=tu(),s="String Iterator",r=i.set,a=i.getterFor(s);return n(String,"String",function(t){r(this,{type:s,string:e(t),index:0})},function(){var e,i=a(this),n=i.string,s=i.index;return s>=n.length?o(void 0,!0):(e=t(n,s),i.index+=e.length,o(e,!1))}),Zu}function Ju(){return ju?Yu:(ju=1,eu(),$u(),Bd(),Yu=Cl().f("iterator"))}function Qu(){if(zu)return Hu;zu=1;var t=Ju();return nu(),Hu=t}function tp(){return Wu?Gu:(Wu=1,Gu=Qu())}function ep(){return Vu?Bu:(Vu=1,Bu=tp())}function ip(){return Xu?Uu:(Xu=1,Uu=ep())}var np,op,sp,rp,ap,lp,hp,dp,cp,up,pp=n(ip());function mp(t){return mp="function"==typeof qu&&"symbol"==typeof pp?function(t){return typeof t}:function(t){return t&&"function"==typeof qu&&t.constructor===qu&&t!==qu.prototype?"symbol":typeof t},mp(t)}function fp(){return op?np:(op=1,Qd(),np=Cl().f("toPrimitive"))}function gp(){return rp?sp:(rp=1,sp=fp())}function vp(){return lp?ap:(lp=1,ap=gp())}function bp(){return dp?hp:(dp=1,hp=vp())}function yp(){return up?cp:(up=1,cp=bp())}var _p=n(yp());function wp(t){var e=function(t,e){if("object"!=mp(t)||!t)return t;var i=t[_p];if(void 0!==i){var n=i.call(t,e);if("object"!=mp(n))return n;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===e?String:Number)(t)}(t,"string");return"symbol"==mp(e)?e:e+""}function xp(t,e,i){return(e=wp(e))in t?Od(t,e,{value:i,enumerable:!0,configurable:!0,writable:!0}):t[e]=i,t}var kp,Dp,Sp,Cp,Tp,Mp,Op,Ep,Pp,Ap={};function Ip(){return Sp?Dp:(Sp=1,function(){if(kp)return Ap;kp=1;var t=bs(),e=ra().map;t({target:"Array",proto:!0,forced:!vh()("map")},{map:function(t){return e(this,t,arguments.length>1?arguments[1]:void 0)}})}(),Dp=zs()("Array","map"))}function Np(){if(Tp)return Cp;Tp=1;var t=qn(),e=Ip(),i=Array.prototype;return Cp=function(n){var o=n.map;return n===i||t(i,n)&&o===i.map?e:o},Cp}function Lp(){return Op?Mp:(Op=1,Mp=Np())}var Fp,Rp,Yp,jp,Hp,zp,Gp,Wp,Bp,Vp,Up,Xp,qp,Zp=n(Pp?Ep:(Pp=1,Ep=Lp())),Kp={};function $p(){if(Rp)return Fp;Rp=1;var t=eo(),e=Yo(),i=zn(),n=ea(),o=TypeError,s="Reduce of empty array with no initial value",r=function(r){return function(a,l,h,d){var c=e(a),u=i(c),p=n(c);if(t(l),0===p&&h<2)throw new o(s);var m=r?p-1:0,f=r?-1:1;if(h<2)for(;;){if(m in u){d=u[m],m+=f;break}if(m+=f,r?m<0:p<=m)throw new o(s)}for(;r?m>=0:p>m;m+=f)m in u&&(d=l(d,u[m],m,c));return d}};return Fp={left:r(!1),right:r(!0)}}function Jp(){return jp?Yp:(jp=1,Yp="NODE"===er())}function Qp(){return Gp?zp:(Gp=1,function(){if(Hp)return Kp;Hp=1;var t=bs(),e=$p().left,i=aa(),n=Kn();t({target:"Array",proto:!0,forced:!Jp()&&n>79&&n<83||!i("reduce")},{reduce:function(t){var i=arguments.length;return e(this,t,i,i>1?arguments[1]:void 0)}})}(),zp=zs()("Array","reduce"))}function tm(){if(Bp)return Wp;Bp=1;var t=qn(),e=Qp(),i=Array.prototype;return Wp=function(n){var o=n.reduce;return n===i||t(i,n)&&o===i.reduce?e:o},Wp}function em(){return Up?Vp:(Up=1,Vp=tm())}var im,nm,om,sm,rm,am,lm,hm=n(qp?Xp:(qp=1,Xp=em())),dm={};function cm(){return om?nm:(om=1,function(){if(im)return dm;im=1;var t=bs(),e=Yo(),i=Va();t({target:"Object",stat:!0,forced:Hi()(function(){i(1)})},{keys:function(t){return i(e(t))}})}(),nm=Un().Object.keys)}function um(){return rm?sm:(rm=1,sm=cm())}var pm,mm,fm=n(lm?am:(lm=1,am=um()));var gm,vm,bm,ym,_m,wm,xm,km,Dm,Sm,Cm,Tm=n(mm?pm:(mm=1,pm=xd())),Mm={exports:{}},Om={},Em={exports:{}},Pm={};function Am(){if(gm)return Pm;function t(){var t={"align-content":!1,"align-items":!1,"align-self":!1,"alignment-adjust":!1,"alignment-baseline":!1,all:!1,"anchor-point":!1,animation:!1,"animation-delay":!1,"animation-direction":!1,"animation-duration":!1,"animation-fill-mode":!1,"animation-iteration-count":!1,"animation-name":!1,"animation-play-state":!1,"animation-timing-function":!1,azimuth:!1,"backface-visibility":!1,background:!0,"background-attachment":!0,"background-clip":!0,"background-color":!0,"background-image":!0,"background-origin":!0,"background-position":!0,"background-repeat":!0,"background-size":!0,"baseline-shift":!1,binding:!1,bleed:!1,"bookmark-label":!1,"bookmark-level":!1,"bookmark-state":!1,border:!0,"border-bottom":!0,"border-bottom-color":!0,"border-bottom-left-radius":!0,"border-bottom-right-radius":!0,"border-bottom-style":!0,"border-bottom-width":!0,"border-collapse":!0,"border-color":!0,"border-image":!0,"border-image-outset":!0,"border-image-repeat":!0,"border-image-slice":!0,"border-image-source":!0,"border-image-width":!0,"border-left":!0,"border-left-color":!0,"border-left-style":!0,"border-left-width":!0,"border-radius":!0,"border-right":!0,"border-right-color":!0,"border-right-style":!0,"border-right-width":!0,"border-spacing":!0,"border-style":!0,"border-top":!0,"border-top-color":!0,"border-top-left-radius":!0,"border-top-right-radius":!0,"border-top-style":!0,"border-top-width":!0,"border-width":!0,bottom:!1,"box-decoration-break":!0,"box-shadow":!0,"box-sizing":!0,"box-snap":!0,"box-suppress":!0,"break-after":!0,"break-before":!0,"break-inside":!0,"caption-side":!1,chains:!1,clear:!0,clip:!1,"clip-path":!1,"clip-rule":!1,color:!0,"color-interpolation-filters":!0,"column-count":!1,"column-fill":!1,"column-gap":!1,"column-rule":!1,"column-rule-color":!1,"column-rule-style":!1,"column-rule-width":!1,"column-span":!1,"column-width":!1,columns:!1,contain:!1,content:!1,"counter-increment":!1,"counter-reset":!1,"counter-set":!1,crop:!1,cue:!1,"cue-after":!1,"cue-before":!1,cursor:!1,direction:!1,display:!0,"display-inside":!0,"display-list":!0,"display-outside":!0,"dominant-baseline":!1,elevation:!1,"empty-cells":!1,filter:!1,flex:!1,"flex-basis":!1,"flex-direction":!1,"flex-flow":!1,"flex-grow":!1,"flex-shrink":!1,"flex-wrap":!1,float:!1,"float-offset":!1,"flood-color":!1,"flood-opacity":!1,"flow-from":!1,"flow-into":!1,font:!0,"font-family":!0,"font-feature-settings":!0,"font-kerning":!0,"font-language-override":!0,"font-size":!0,"font-size-adjust":!0,"font-stretch":!0,"font-style":!0,"font-synthesis":!0,"font-variant":!0,"font-variant-alternates":!0,"font-variant-caps":!0,"font-variant-east-asian":!0,"font-variant-ligatures":!0,"font-variant-numeric":!0,"font-variant-position":!0,"font-weight":!0,grid:!1,"grid-area":!1,"grid-auto-columns":!1,"grid-auto-flow":!1,"grid-auto-rows":!1,"grid-column":!1,"grid-column-end":!1,"grid-column-start":!1,"grid-row":!1,"grid-row-end":!1,"grid-row-start":!1,"grid-template":!1,"grid-template-areas":!1,"grid-template-columns":!1,"grid-template-rows":!1,"hanging-punctuation":!1,height:!0,hyphens:!1,icon:!1,"image-orientation":!1,"image-resolution":!1,"ime-mode":!1,"initial-letters":!1,"inline-box-align":!1,"justify-content":!1,"justify-items":!1,"justify-self":!1,left:!1,"letter-spacing":!0,"lighting-color":!0,"line-box-contain":!1,"line-break":!1,"line-grid":!1,"line-height":!1,"line-snap":!1,"line-stacking":!1,"line-stacking-ruby":!1,"line-stacking-shift":!1,"line-stacking-strategy":!1,"list-style":!0,"list-style-image":!0,"list-style-position":!0,"list-style-type":!0,margin:!0,"margin-bottom":!0,"margin-left":!0,"margin-right":!0,"margin-top":!0,"marker-offset":!1,"marker-side":!1,marks:!1,mask:!1,"mask-box":!1,"mask-box-outset":!1,"mask-box-repeat":!1,"mask-box-slice":!1,"mask-box-source":!1,"mask-box-width":!1,"mask-clip":!1,"mask-image":!1,"mask-origin":!1,"mask-position":!1,"mask-repeat":!1,"mask-size":!1,"mask-source-type":!1,"mask-type":!1,"max-height":!0,"max-lines":!1,"max-width":!0,"min-height":!0,"min-width":!0,"move-to":!1,"nav-down":!1,"nav-index":!1,"nav-left":!1,"nav-right":!1,"nav-up":!1,"object-fit":!1,"object-position":!1,opacity:!1,order:!1,orphans:!1,outline:!1,"outline-color":!1,"outline-offset":!1,"outline-style":!1,"outline-width":!1,overflow:!1,"overflow-wrap":!1,"overflow-x":!1,"overflow-y":!1,padding:!0,"padding-bottom":!0,"padding-left":!0,"padding-right":!0,"padding-top":!0,page:!1,"page-break-after":!1,"page-break-before":!1,"page-break-inside":!1,"page-policy":!1,pause:!1,"pause-after":!1,"pause-before":!1,perspective:!1,"perspective-origin":!1,pitch:!1,"pitch-range":!1,"play-during":!1,position:!1,"presentation-level":!1,quotes:!1,"region-fragment":!1,resize:!1,rest:!1,"rest-after":!1,"rest-before":!1,richness:!1,right:!1,rotation:!1,"rotation-point":!1,"ruby-align":!1,"ruby-merge":!1,"ruby-position":!1,"shape-image-threshold":!1,"shape-outside":!1,"shape-margin":!1,size:!1,speak:!1,"speak-as":!1,"speak-header":!1,"speak-numeral":!1,"speak-punctuation":!1,"speech-rate":!1,stress:!1,"string-set":!1,"tab-size":!1,"table-layout":!1,"text-align":!0,"text-align-last":!0,"text-combine-upright":!0,"text-decoration":!0,"text-decoration-color":!0,"text-decoration-line":!0,"text-decoration-skip":!0,"text-decoration-style":!0,"text-emphasis":!0,"text-emphasis-color":!0,"text-emphasis-position":!0,"text-emphasis-style":!0,"text-height":!0,"text-indent":!0,"text-justify":!0,"text-orientation":!0,"text-overflow":!0,"text-shadow":!0,"text-space-collapse":!0,"text-transform":!0,"text-underline-position":!0,"text-wrap":!0,top:!1,transform:!1,"transform-origin":!1,"transform-style":!1,transition:!1,"transition-delay":!1,"transition-duration":!1,"transition-property":!1,"transition-timing-function":!1,"unicode-bidi":!1,"vertical-align":!1,visibility:!1,"voice-balance":!1,"voice-duration":!1,"voice-family":!1,"voice-pitch":!1,"voice-range":!1,"voice-rate":!1,"voice-stress":!1,"voice-volume":!1,volume:!1,"white-space":!1,widows:!1,width:!0,"will-change":!1,"word-break":!0,"word-spacing":!0,"word-wrap":!0,"wrap-flow":!1,"wrap-through":!1,"writing-mode":!1,"z-index":!1};return t}gm=1;var e=/javascript\s*\:/gim;return Pm.whiteList=t(),Pm.getDefaultWhiteList=t,Pm.onAttr=function(t,e,i){},Pm.onIgnoreAttr=function(t,e,i){},Pm.safeAttrValue=function(t,i){return e.test(i)?"":i},Pm}function Im(){return bm?vm:(bm=1,vm={indexOf:function(t,e){var i,n;if(Array.prototype.indexOf)return t.indexOf(e);for(i=0,n=t.length;i<n;i++)if(t[i]===e)return i;return-1},forEach:function(t,e,i){var n,o;if(Array.prototype.forEach)return t.forEach(e,i);for(n=0,o=t.length;n<o;n++)e.call(i,t[n],n,t)},trim:function(t){return String.prototype.trim?t.trim():t.replace(/(^\s*)|(\s*$)/g,"")},trimRight:function(t){return String.prototype.trimRight?t.trimRight():t.replace(/(\s*$)/g,"")}})}function Nm(){if(xm)return wm;xm=1;var t=Am(),e=function(){if(_m)return ym;_m=1;var t=Im();return ym=function(e,i){";"!==(e=t.trimRight(e))[e.length-1]&&(e+=";");var n=e.length,o=!1,s=0,r=0,a="";function l(){if(!o){var n=t.trim(e.slice(s,r)),l=n.indexOf(":");if(-1!==l){var h=t.trim(n.slice(0,l)),d=t.trim(n.slice(l+1));if(h){var c=i(s,a.length,h,d,n);c&&(a+=c+"; ")}}}s=r+1}for(;r<n;r++){var h=e[r];if("/"===h&&"*"===e[r+1]){var d=e.indexOf("*/",r+2);if(-1===d)break;s=(r=d+1)+1,o=!1}else"("===h?o=!0:")"===h?o=!1:";"===h?o||l():"\n"===h&&l()}return t.trim(a)},ym}();function i(t){return null==t}function n(e){(e=function(t){var e={};for(var i in t)e[i]=t[i];return e}(e||{})).whiteList=e.whiteList||t.whiteList,e.onAttr=e.onAttr||t.onAttr,e.onIgnoreAttr=e.onIgnoreAttr||t.onIgnoreAttr,e.safeAttrValue=e.safeAttrValue||t.safeAttrValue,this.options=e}return Im(),n.prototype.process=function(t){if(!(t=(t=t||"").toString()))return"";var n=this.options,o=n.whiteList,s=n.onAttr,r=n.onIgnoreAttr,a=n.safeAttrValue;return e(t,function(t,e,n,l,h){var d=o[n],c=!1;if(!0===d?c=d:"function"==typeof d?c=d(l):d instanceof RegExp&&(c=d.test(l)),!0!==c&&(c=!1),l=a(n,l)){var u,p={position:e,sourcePosition:t,source:h,isWhite:c};return c?i(u=s(n,l,p))?n+":"+l:u:i(u=r(n,l,p))?void 0:u}})},wm=n}function Lm(){return km||(km=1,function(t,e){var i=Am(),n=Nm();for(var o in e=t.exports=function(t,e){return new n(e).process(t)},e.FilterCSS=n,i)e[o]=i[o];"undefined"!=typeof window&&(window.filterCSS=t.exports)}(Em,Em.exports)),Em.exports}function Fm(){return Sm?Dm:(Sm=1,Dm={indexOf:function(t,e){var i,n;if(Array.prototype.indexOf)return t.indexOf(e);for(i=0,n=t.length;i<n;i++)if(t[i]===e)return i;return-1},forEach:function(t,e,i){var n,o;if(Array.prototype.forEach)return t.forEach(e,i);for(n=0,o=t.length;n<o;n++)e.call(i,t[n],n,t)},trim:function(t){return String.prototype.trim?t.trim():t.replace(/(^\s*)|(\s*$)/g,"")},spaceIndex:function(t){var e=/\s|\n|\t/.exec(t);return e?e.index:-1}})}function Rm(){if(Cm)return Om;Cm=1;var t=Lm().FilterCSS,e=Lm().getDefaultWhiteList,i=Fm();function n(){return{a:["target","href","title"],abbr:["title"],address:[],area:["shape","coords","href","alt"],article:[],aside:[],audio:["autoplay","controls","crossorigin","loop","muted","preload","src"],b:[],bdi:["dir"],bdo:["dir"],big:[],blockquote:["cite"],br:[],caption:[],center:[],cite:[],code:[],col:["align","valign","span","width"],colgroup:["align","valign","span","width"],dd:[],del:["datetime"],details:["open"],div:[],dl:[],dt:[],em:[],figcaption:[],figure:[],font:["color","size","face"],footer:[],h1:[],h2:[],h3:[],h4:[],h5:[],h6:[],header:[],hr:[],i:[],img:["src","alt","title","width","height","loading"],ins:["datetime"],kbd:[],li:[],mark:[],nav:[],ol:[],p:[],pre:[],s:[],section:[],small:[],span:[],sub:[],summary:[],sup:[],strong:[],strike:[],table:["width","border","align","valign"],tbody:["align","valign"],td:["width","rowspan","colspan","align","valign"],tfoot:["align","valign"],th:["width","rowspan","colspan","align","valign"],thead:["align","valign"],tr:["rowspan","align","valign"],tt:[],u:[],ul:[],video:["autoplay","controls","crossorigin","loop","muted","playsinline","poster","preload","src","height","width"]}}var o=new t;function s(t){return t.replace(r,"&lt;").replace(a,"&gt;")}var r=/</g,a=/>/g,l=/"/g,h=/&quot;/g,d=/&#([a-zA-Z0-9]*);?/gim,c=/&colon;?/gim,u=/&newline;?/gim,p=/((j\s*a\s*v\s*a|v\s*b|l\s*i\s*v\s*e)\s*s\s*c\s*r\s*i\s*p\s*t\s*|m\s*o\s*c\s*h\s*a):/gi,m=/e\s*x\s*p\s*r\s*e\s*s\s*s\s*i\s*o\s*n\s*\(.*/gi,f=/u\s*r\s*l\s*\(.*/gi;function g(t){return t.replace(l,"&quot;")}function v(t){return t.replace(h,'"')}function b(t){return t.replace(d,function(t,e){return"x"===e[0]||"X"===e[0]?String.fromCharCode(parseInt(e.substr(1),16)):String.fromCharCode(parseInt(e,10))})}function y(t){return t.replace(c,":").replace(u," ")}function _(t){for(var e="",n=0,o=t.length;n<o;n++)e+=t.charCodeAt(n)<32?" ":t.charAt(n);return i.trim(e)}function w(t){return t=_(t=y(t=b(t=v(t))))}function x(t){return t=s(t=g(t))}return Om.whiteList={a:["target","href","title"],abbr:["title"],address:[],area:["shape","coords","href","alt"],article:[],aside:[],audio:["autoplay","controls","crossorigin","loop","muted","preload","src"],b:[],bdi:["dir"],bdo:["dir"],big:[],blockquote:["cite"],br:[],caption:[],center:[],cite:[],code:[],col:["align","valign","span","width"],colgroup:["align","valign","span","width"],dd:[],del:["datetime"],details:["open"],div:[],dl:[],dt:[],em:[],figcaption:[],figure:[],font:["color","size","face"],footer:[],h1:[],h2:[],h3:[],h4:[],h5:[],h6:[],header:[],hr:[],i:[],img:["src","alt","title","width","height","loading"],ins:["datetime"],kbd:[],li:[],mark:[],nav:[],ol:[],p:[],pre:[],s:[],section:[],small:[],span:[],sub:[],summary:[],sup:[],strong:[],strike:[],table:["width","border","align","valign"],tbody:["align","valign"],td:["width","rowspan","colspan","align","valign"],tfoot:["align","valign"],th:["width","rowspan","colspan","align","valign"],thead:["align","valign"],tr:["rowspan","align","valign"],tt:[],u:[],ul:[],video:["autoplay","controls","crossorigin","loop","muted","playsinline","poster","preload","src","height","width"]},Om.getDefaultWhiteList=n,Om.onTag=function(t,e,i){},Om.onIgnoreTag=function(t,e,i){},Om.onTagAttr=function(t,e,i){},Om.onIgnoreTagAttr=function(t,e,i){},Om.safeAttrValue=function(t,e,n,s){if(n=w(n),"href"===e||"src"===e){if("#"===(n=i.trim(n)))return"#";if("http://"!==n.substr(0,7)&&"https://"!==n.substr(0,8)&&"mailto:"!==n.substr(0,7)&&"tel:"!==n.substr(0,4)&&"data:image/"!==n.substr(0,11)&&"ftp://"!==n.substr(0,6)&&"./"!==n.substr(0,2)&&"../"!==n.substr(0,3)&&"#"!==n[0]&&"/"!==n[0])return""}else if("background"===e){if(p.lastIndex=0,p.test(n))return""}else if("style"===e){if(m.lastIndex=0,m.test(n))return"";if(f.lastIndex=0,f.test(n)&&(p.lastIndex=0,p.test(n)))return"";!1!==s&&(n=(s=s||o).process(n))}return n=x(n)},Om.escapeHtml=s,Om.escapeQuote=g,Om.unescapeQuote=v,Om.escapeHtmlEntities=b,Om.escapeDangerHtml5Entities=y,Om.clearNonPrintableCharacter=_,Om.friendlyAttrValue=w,Om.escapeAttrValue=x,Om.onIgnoreTagStripAll=function(){return""},Om.StripTagBody=function(t,e){"function"!=typeof e&&(e=function(){});var n=!Array.isArray(t),o=[],s=!1;return{onIgnoreTag:function(r,a,l){if(function(e){return!!n||-1!==i.indexOf(t,e)}(r)){if(l.isClosing){var h="[/removed]",d=l.position+10;return o.push([!1!==s?s:l.position,d]),s=!1,h}return s||(s=l.position),"[removed]"}return e(r,a,l)},remove:function(t){var e="",n=0;return i.forEach(o,function(i){e+=t.slice(n,i[0]),n=i[1]}),e+=t.slice(n)}}},Om.stripCommentTag=function(t){for(var e="",i=0;i<t.length;){var n=t.indexOf("\x3c!--",i);if(-1===n){e+=t.slice(i);break}e+=t.slice(i,n);var o=t.indexOf("--\x3e",n);if(-1===o)break;i=o+3}return e},Om.stripBlankChar=function(t){var e=t.split("");return(e=e.filter(function(t){var e=t.charCodeAt(0);return 127!==e&&(!(e<=31)||(10===e||13===e))})).join("")},Om.attributeWrapSign='"',Om.cssFilter=o,Om.getDefaultCSSWhiteList=e,Om}var Ym,jm,Hm,zm,Gm={};function Wm(){if(Ym)return Gm;Ym=1;var t=Fm();function e(e){var i,n=t.spaceIndex(e);return i=-1===n?e.slice(1,-1):e.slice(1,n+1),"/"===(i=t.trim(i).toLowerCase()).slice(0,1)&&(i=i.slice(1)),"/"===i.slice(-1)&&(i=i.slice(0,-1)),i}function i(t){return"</"===t.slice(0,2)}var n=/[^a-zA-Z0-9\\_:.-]/gim;function o(t,e){for(;e<t.length;e++){var i=t[e];if(" "!==i)return"="===i?e:-1}}function s(t,e){for(;e<t.length;e++){var i=t[e];if(" "!==i)return"'"===i||'"'===i?e:-1}}function r(t,e){for(;e>0;e--){var i=t[e];if(" "!==i)return"="===i?e:-1}}function a(t){return function(t){return'"'===t[0]&&'"'===t[t.length-1]||"'"===t[0]&&"'"===t[t.length-1]}(t)?t.substr(1,t.length-2):t}return Gm.parseTag=function(t,n,o){var s="",r=0,a=!1,l=!1,h=0,d=t.length,c="",u="";t:for(h=0;h<d;h++){var p=t.charAt(h);if(!1===a){if("<"===p){a=h;continue}}else if(!1===l){if("<"===p){s+=o(t.slice(r,h)),a=h,r=h;continue}if(">"===p||h===d-1){s+=o(t.slice(r,a)),c=e(u=t.slice(a,h+1)),s+=n(a,s.length,c,u,i(u)),r=h+1,a=!1;continue}if('"'===p||"'"===p)for(var m=1,f=t.charAt(h-m);""===f.trim()||"="===f;){if("="===f){l=p;continue t}f=t.charAt(h-++m)}}else if(p===l){l=!1;continue}}return r<d&&(s+=o(t.substr(r))),s},Gm.parseAttr=function(e,i){var l=0,h=0,d=[],c=!1,u=e.length;function p(e,o){if(!((e=(e=t.trim(e)).replace(n,"").toLowerCase()).length<1)){var s=i(e,o||"");s&&d.push(s)}}for(var m=0;m<u;m++){var f,g=e.charAt(m);if(!1!==c||"="!==g)if(!1===c||m!==h)if(/\s|\n|\t/.test(g)){if(e=e.replace(/\s|\n|\t/g," "),!1===c){if(-1===(f=o(e,m))){p(t.trim(e.slice(l,m))),c=!1,l=m+1;continue}m=f-1;continue}if(-1===(f=r(e,m-1))){p(c,a(t.trim(e.slice(l,m)))),c=!1,l=m+1;continue}}else;else{if(-1===(f=e.indexOf(g,m+1)))break;p(c,t.trim(e.slice(h+1,f))),c=!1,l=(m=f)+1}else c=e.slice(l,m),l=m+1,h='"'===e.charAt(l)||"'"===e.charAt(l)?l:s(e,m+1)}return l<e.length&&(!1===c?p(e.slice(l)):p(c,a(t.trim(e.slice(l))))),t.trim(d.join(" "))},Gm}function Bm(){if(Hm)return jm;Hm=1;var t=Lm().FilterCSS,e=Rm(),i=Wm(),n=i.parseTag,o=i.parseAttr,s=Fm();function r(t){return null==t}function a(i){(i=function(t){var e={};for(var i in t)e[i]=t[i];return e}(i||{})).stripIgnoreTag&&(i.onIgnoreTag&&console.error('Notes: cannot use these two options "stripIgnoreTag" and "onIgnoreTag" at the same time'),i.onIgnoreTag=e.onIgnoreTagStripAll),i.whiteList||i.allowList?i.whiteList=function(t){var e={};for(var i in t)Array.isArray(t[i])?e[i.toLowerCase()]=t[i].map(function(t){return t.toLowerCase()}):e[i.toLowerCase()]=t[i];return e}(i.whiteList||i.allowList):i.whiteList=e.whiteList,this.attributeWrapSign=!0===i.singleQuotedAttributeValue?"'":e.attributeWrapSign,i.onTag=i.onTag||e.onTag,i.onTagAttr=i.onTagAttr||e.onTagAttr,i.onIgnoreTag=i.onIgnoreTag||e.onIgnoreTag,i.onIgnoreTagAttr=i.onIgnoreTagAttr||e.onIgnoreTagAttr,i.safeAttrValue=i.safeAttrValue||e.safeAttrValue,i.escapeHtml=i.escapeHtml||e.escapeHtml,this.options=i,!1===i.css?this.cssFilter=!1:(i.css=i.css||{},this.cssFilter=new t(i.css))}return a.prototype.process=function(t){if(!(t=(t=t||"").toString()))return"";var i=this,a=i.options,l=a.whiteList,h=a.onTag,d=a.onIgnoreTag,c=a.onTagAttr,u=a.onIgnoreTagAttr,p=a.safeAttrValue,m=a.escapeHtml,f=i.attributeWrapSign,g=i.cssFilter;a.stripBlankChar&&(t=e.stripBlankChar(t)),a.allowCommentTag||(t=e.stripCommentTag(t));var v=!1;a.stripIgnoreTagBody&&(v=e.StripTagBody(a.stripIgnoreTagBody,d),d=v.onIgnoreTag);var b=n(t,function(t,e,i,n,a){var v={sourcePosition:t,position:e,isClosing:a,isWhite:Object.prototype.hasOwnProperty.call(l,i)},b=h(i,n,v);if(!r(b))return b;if(v.isWhite){if(v.isClosing)return"</"+i+">";var y=function(t){var e=s.spaceIndex(t);if(-1===e)return{html:"",closing:"/"===t[t.length-2]};var i="/"===(t=s.trim(t.slice(e+1,-1)))[t.length-1];return i&&(t=s.trim(t.slice(0,-1))),{html:t,closing:i}}(n),_=l[i],w=o(y.html,function(t,e){var n=-1!==s.indexOf(_,t),o=c(i,t,e,n);return r(o)?n?(e=p(i,t,e,g))?t+"="+f+e+f:t:r(o=u(i,t,e,n))?void 0:o:o});return n="<"+i,w&&(n+=" "+w),y.closing&&(n+=" /"),n+=">"}return r(b=d(i,n,v))?m(n):b},m);return v&&(b=v.remove(b)),b},jm=a}var Vm=(zm||(zm=1,function(t,e){var i=Rm(),n=Wm(),o=Bm();function s(t,e){return new o(e).process(t)}(e=t.exports=s).filterXSS=s,e.FilterXSS=o,function(){for(var t in i)e[t]=i[t];for(var o in n)e[o]=n[o]}(),"undefined"!=typeof window&&(window.filterXSS=t.exports),"undefined"!=typeof self&&"undefined"!=typeof DedicatedWorkerGlobalScope&&self instanceof DedicatedWorkerGlobalScope&&(self.filterXSS=t.exports)}(Mm,Mm.exports)),Mm.exports),Um=n(Vm);function Xm(t,e){var i=fm(t);if(fh){var n=fh(t);e&&(n=Th(n).call(n,function(e){return Wh(t,e).enumerable})),i.push.apply(i,n)}return i}function qm(t){for(var e=1;e<arguments.length;e++){var i,n,o=null!=arguments[e]?arguments[e]:{};e%2?ua(i=Xm(Object(o),!0)).call(i,function(e){xp(t,e,o[e])}):ed?vd(t,ed(o)):ua(n=Xm(Object(o))).call(n,function(e){Tm(t,e,Wh(o,e))})}return t}function Zm(t){var e;if(!t)return!1;let i=null!==(e=t.idProp)&&void 0!==e?e:t._idProp;return!!i&&function(t,e){return"object"==typeof e&&null!==e&&t===e.idProp&&"function"==typeof e.forEach&&"function"==typeof e.get&&"function"==typeof e.getDataSet&&"function"==typeof e.getIds&&"number"==typeof e.length&&"function"==typeof e.map&&"function"==typeof e.off&&"function"==typeof e.on&&"function"==typeof e.stream&&function(t,e){return"object"==typeof e&&null!==e&&t===e.idProp&&"function"==typeof e.add&&"function"==typeof e.clear&&"function"==typeof e.distinct&&"function"==typeof e.forEach&&"function"==typeof e.get&&"function"==typeof e.getDataSet&&"function"==typeof e.getIds&&"number"==typeof e.length&&"function"==typeof e.map&&"function"==typeof e.max&&"function"==typeof e.min&&"function"==typeof e.off&&"function"==typeof e.on&&"function"==typeof e.remove&&"function"==typeof e.setOptions&&"function"==typeof e.stream&&"function"==typeof e.update&&"function"==typeof e.updateOnly}(t,e.getDataSet())}(i,t)}const Km=/^\/?Date\((-?\d+)/i,$m=/^\d+$/;function Jm(t,e){let i;if(void 0!==t){if(null===t)return null;if(!e)return t;if("string"!=typeof e&&!(e instanceof String))throw new Error("Type must be a string");switch(e){case"boolean":case"Boolean":return Boolean(t);case"number":case"Number":return ye(t)&&!isNaN(Date.parse(t))?pa(t).valueOf():Number(t.valueOf());case"string":case"String":return String(t);case"Date":try{return Jm(t,"Moment").toDate()}catch(i){throw i instanceof TypeError?new TypeError("Cannot convert object of type "+De(t)+" to type "+e):i}case"Moment":if(be(t))return pa(t);if(t instanceof Date)return pa(t.valueOf());if(pa.isMoment(t))return pa(t);if(ye(t))return i=Km.exec(t),i?pa(Number(i[1])):(i=$m.exec(t),pa(i?Number(t):t));throw new TypeError("Cannot convert object of type "+De(t)+" to type "+e);case"ISODate":if(be(t))return new Date(t);if(t instanceof Date)return t.toISOString();if(pa.isMoment(t))return t.toDate().toISOString();if(ye(t))return i=Km.exec(t),i?new Date(Number(i[1])).toISOString():pa(t).format();throw new Error("Cannot convert object of type "+De(t)+" to type ISODate");case"ASPDate":if(be(t))return"/Date("+t+")/";if(t instanceof Date||pa.isMoment(t))return"/Date("+t.valueOf()+")/";if(ye(t)){let e;return i=Km.exec(t),e=i?new Date(Number(i[1])).valueOf():new Date(t).valueOf(),"/Date("+e+")/"}throw new Error("Cannot convert object of type "+De(t)+" to type ASPDate");default:throw new Error("Unknown type ".concat(e))}}}function Qm(t){var e,i,n,o,s,r;let a=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{start:"Date",end:"Date"};const l=t._idProp,h=new wi({fieldId:l}),d=Zp((c=t,e=new gi(c))).call(e,t=>{var e;return hm(e=fm(t)).call(e,(e,i)=>(e[i]=Jm(t[i],a[i]),e),{})}).to(h);var c;return d.all().start(),{add:function(){return t.getDataSet().add(...arguments)},remove:function(){return t.getDataSet().remove(...arguments)},update:function(){return t.getDataSet().update(...arguments)},updateOnly:function(){return t.getDataSet().updateOnly(...arguments)},clear:function(){return t.getDataSet().clear(...arguments)},forEach:Js(i=ua(h)).call(i,h),get:Js(n=h.get).call(n,h),getIds:Js(o=h.getIds).call(o,h),off:Js(s=h.off).call(s,h),on:Js(r=h.on).call(r,h),get length(){return h.length},idProp:l,type:a,rawDS:t,coercedDS:h,dispose:()=>d.stop()}}const tf=t=>{const e=new Um.FilterXSS(t);return t=>"string"==typeof t?e.process(t):t},ef=t=>t;let nf=tf();const of=qm(qm({},ti),{},{convert:Jm,setupXSSProtection:t=>{t&&(!0===t.disabled?(nf=ef,console.warn("You disabled XSS protection for vis-Timeline. I sure hope you know what you're doing!")):t.filterOptions&&(nf=tf(t.filterOptions)))}});var sf,rf,af,lf,hf,df,cf,uf;function pf(){return rf?sf:(rf=1,Ad(),sf=zs()("Array","concat"))}function mf(){if(lf)return af;lf=1;var t=qn(),e=pf(),i=Array.prototype;return af=function(n){var o=n.concat;return n===i||t(i,n)&&o===i.concat?e:o},af}function ff(){return df?hf:(df=1,hf=mf())}Tm(of,"xss",{get:function(){return nf}});var gf,vf,bf,yf,_f,wf,xf,kf,Df,Sf,Cf,Tf,Mf,Of=n(uf?cf:(uf=1,cf=ff())),Ef={};function Pf(){if(vf)return gf;vf=1;var t=Qr(),e=ya(),i=Wn(),n=RangeError;return gf=function(o){var s=e(i(this)),r="",a=t(o);if(a<0||a===1/0)throw new n("Wrong number of repetitions");for(;a>0;(a>>>=1)&&(s+=s))1&a&&(r+=s);return r}}function Af(){if(yf)return bf;yf=1;var t=Wi(),e=ta(),i=ya(),n=Pf(),o=Wn(),s=t(n),r=t("".slice),a=Math.ceil,l=function(t){return function(n,l,h){var d,c,u=i(o(n)),p=e(l),m=u.length,f=void 0===h?" ":i(h);return p<=m||""===f?u:((c=s(f,a((d=p-m)/f.length))).length>d&&(c=r(c,0,d)),t?u+c:c+u)}};return bf={start:l(!1),end:l(!0)}}function If(){if(wf)return _f;wf=1;var t=Wi(),e=Hi(),i=Af().start,n=RangeError,o=isFinite,s=Math.abs,r=Date.prototype,a=r.toISOString,l=t(r.getTime),h=t(r.getUTCDate),d=t(r.getUTCFullYear),c=t(r.getUTCHours),u=t(r.getUTCMilliseconds),p=t(r.getUTCMinutes),m=t(r.getUTCMonth),f=t(r.getUTCSeconds);return _f=e(function(){return"0385-07-25T07:06:39.999Z"!==a.call(new Date(-50000000000001))})||!e(function(){a.call(new Date(NaN))})?function(){if(!o(l(this)))throw new n("Invalid time value");var t=this,e=d(t),r=u(t),a=e<0?"-":e>9999?"+":"";return a+i(s(e),a?6:4,0)+"-"+i(m(t)+1,2,0)+"-"+i(h(t),2,0)+"T"+i(c(t),2,0)+":"+i(p(t),2,0)+":"+i(f(t),2,0)+"."+i(r,3,0)+"Z"}:a,_f}function Nf(){if(Df)return kf;Df=1,function(){if(xf)return Ef;xf=1;var t=bs(),e=Qi(),i=Yo(),n=Go(),o=If(),s=Bi();t({target:"Date",proto:!0,forced:Hi()(function(){return null!==new Date(NaN).toJSON()||1!==e(Date.prototype.toJSON,{toISOString:function(){return 1}})})},{toJSON:function(t){var r=i(this),a=n(r,"number");return"number"!=typeof a||isFinite(a)?"toISOString"in r||"Date"!==s(r)?r.toISOString():e(o,r):null}})}(),Vl();var t=Un(),e=Gi();return t.JSON||(t.JSON={stringify:JSON.stringify}),kf=function(i,n,o){return e(t.JSON.stringify,null,arguments)},kf}function Lf(){return Cf?Sf:(Cf=1,Sf=Nf())}var Ff,Rf,Yf,jf,Hf,zf,Gf,Wf=n(Mf?Tf:(Mf=1,Tf=Lf())),Bf={};function Vf(){return Yf?Rf:(Yf=1,function(){if(Ff)return Bf;Ff=1;var t=bs(),e=Date,i=Wi()(e.prototype.getTime);t({target:"Date",stat:!0},{now:function(){return i(new e)}})}(),Rf=Un().Date.now)}function Uf(){return Hf?jf:(Hf=1,jf=Vf())}var Xf,qf,Zf,Kf,$f,Jf,Qf,tg,eg,ig,ng,og,sg,rg=n(Gf?zf:(Gf=1,zf=Uf())),ag={};function lg(){return qf?Xf:(qf=1,Xf="\t\n\v\f\r                　\u2028\u2029\ufeff")}function hg(){if(Kf)return Zf;Kf=1;var t=Wi(),e=Wn(),i=ya(),n=lg(),o=t("".replace),s=RegExp("^["+n+"]+"),r=RegExp("(^|[^"+n+"])["+n+"]+$"),a=function(t){return function(n){var a=i(e(n));return 1&t&&(a=o(a,s,"")),2&t&&(a=o(a,r,"$1")),a}};return Zf={start:a(1),end:a(2),trim:a(3)}}function dg(){if(Jf)return $f;Jf=1;var t=ji(),e=Hi(),i=Wi(),n=ya(),o=hg().trim,s=lg(),r=i("".charAt),a=t.parseFloat,l=t.Symbol,h=l&&l.iterator,d=1/a(s+"-0")!=-1/0||h&&!e(function(){a(Object(h))});return $f=d?function(t){var e=o(n(t)),i=a(e);return 0===i&&"-"===r(e,0)?-0:i}:a,$f}function cg(){return eg?tg:(eg=1,function(){if(Qf)return ag;Qf=1;var t=bs(),e=dg();t({global:!0,forced:parseFloat!==e},{parseFloat:e})}(),tg=Un().parseFloat)}function ug(){return ng?ig:(ng=1,ig=cg())}var pg=n(sg?og:(sg=1,og=ug()));class mg{constructor(t,e){this.options=null,this.props=null}setOptions(t){t&&of.extend(this.options,t)}redraw(){return!1}destroy(){}_isResized(){const t=this.props._previousWidth!==this.props.width||this.props._previousHeight!==this.props.height;return this.props._previousWidth=this.props.width,this.props._previousHeight=this.props.height,t}}var fg,gg,vg,bg,yg,_g,wg,xg,kg;function Dg(){return vg?gg:(vg=1,fg||(fg=1,bs()({target:"String",proto:!0},{repeat:Pf()})),gg=zs()("String","repeat"))}function Sg(){if(yg)return bg;yg=1;var t=qn(),e=Dg(),i=String.prototype;return bg=function(n){var o=n.repeat;return"string"==typeof n||n===i||t(i,n)&&o===i.repeat?e:o},bg}function Cg(){return wg?_g:(wg=1,_g=Sg())}var Tg,Mg,Og,Eg,Pg,Ag,Ig,Ng,Lg,Fg,Rg,Yg,jg,Hg,zg,Gg,Wg,Bg,Vg,Ug=n(kg?xg:(kg=1,xg=Cg())),Xg={};function qg(){if(Mg)return Tg;Mg=1;var t=to(),e=TypeError;return Tg=function(i,n){if(!delete i[n])throw new e("Cannot delete property "+t(n)+" of "+t(i))}}function Zg(){if(Eg)return Og;Eg=1;var t=js(),e=Math.floor,i=function(n,o){var s=n.length;if(s<8)for(var r,a,l=1;l<s;){for(a=l,r=n[l];a&&o(n[a-1],r)>0;)n[a]=n[--a];a!==l++&&(n[a]=r)}else for(var h=e(s/2),d=i(t(n,0,h),o),c=i(t(n,h),o),u=d.length,p=c.length,m=0,f=0;m<u||f<p;)n[m+f]=m<u&&f<p?o(d[m],c[f])<=0?d[m++]:c[f++]:m<u?d[m++]:c[f++];return n};return Og=i}function Kg(){if(Ag)return Pg;Ag=1;var t=Zn().match(/firefox\/(\d+)/i);return Pg=!!t&&+t[1]}function $g(){return Ng?Ig:(Ng=1,Ig=/MSIE|Trident/.test(Zn()))}function Jg(){if(Fg)return Lg;Fg=1;var t=Zn().match(/AppleWebKit\/(\d+)\./);return Lg=!!t&&+t[1]}function Qg(){if(Rg)return Xg;Rg=1;var t=bs(),e=Wi(),i=eo(),n=Yo(),o=ea(),s=qg(),r=ya(),a=Hi(),l=Zg(),h=aa(),d=Kg(),c=$g(),u=Kn(),p=Jg(),m=[],f=e(m.sort),g=e(m.push),v=a(function(){m.sort(void 0)}),b=a(function(){m.sort(null)}),y=h("sort"),_=!a(function(){if(u)return u<70;if(!(d&&d>3)){if(c)return!0;if(p)return p<603;var t,e,i,n,o="";for(t=65;t<76;t++){switch(e=String.fromCharCode(t),t){case 66:case 69:case 70:case 72:i=3;break;case 68:case 71:i=4;break;default:i=2}for(n=0;n<47;n++)m.push({k:e+n,v:i})}for(m.sort(function(t,e){return e.v-t.v}),n=0;n<m.length;n++)e=m[n].k.charAt(0),o.charAt(o.length-1)!==e&&(o+=e);return"DGBEFHACIJK"!==o}});return t({target:"Array",proto:!0,forced:v||!b||!y||!_},{sort:function(t){void 0!==t&&i(t);var e=n(this);if(_)return void 0===t?f(e):f(e,t);var a,h,d=[],c=o(e);for(h=0;h<c;h++)h in e&&g(d,e[h]);for(l(d,function(t){return function(e,i){return void 0===i?-1:void 0===e?1:void 0!==t?+t(e,i)||0:r(e)>r(i)?1:-1}}(t)),a=o(d),h=0;h<a;)e[h]=d[h++];for(;h<c;)s(e,h++);return e}}),Xg}function tv(){return jg?Yg:(jg=1,Qg(),Yg=zs()("Array","sort"))}function ev(){if(zg)return Hg;zg=1;var t=qn(),e=tv(),i=Array.prototype;return Hg=function(n){var o=n.sort;return n===i||t(i,n)&&o===i.sort?e:o},Hg}function iv(){return Wg?Gg:(Wg=1,Gg=ev())}var nv=n(Vg?Bg:(Vg=1,Bg=iv()));function ov(t,e,i){if(i&&!Rs(i))return ov(t,e,[i]);if(e.hiddenDates=[],i&&1==Rs(i)){var n;for(let n=0;n<i.length;n++)if(void 0===Ug(i[n])){const o={};o.start=t(i[n].start).toDate().valueOf(),o.end=t(i[n].end).toDate().valueOf(),e.hiddenDates.push(o)}nv(n=e.hiddenDates).call(n,(t,e)=>t.start-e.start)}}function sv(t,e,i){if(i&&!Rs(i))return sv(t,e,[i]);if(i&&void 0!==e.domProps.centerContainer.width){ov(t,e,i);const n=t(e.range.start),o=t(e.range.end),s=(e.range.end-e.range.start)/e.domProps.centerContainer.width;for(let r=0;r<i.length;r++)if(void 0!==Ug(i[r])){let a=t(i[r].start),l=t(i[r].end);if("Invalid Date"==a._d)throw new Error("Supplied start date is not valid: ".concat(i[r].start));if("Invalid Date"==l._d)throw new Error("Supplied end date is not valid: ".concat(i[r].end));if(l-a>=4*s){let t=0,s=o.clone();switch(Ug(i[r])){case"daily":a.day()!=l.day()&&(t=1),a=a.dayOfYear(n.dayOfYear()).year(n.year()).subtract(7,"days"),l=l.dayOfYear(n.dayOfYear()).year(n.year()).subtract(7-t,"days"),s.add(1,"weeks");break;case"weekly":{const t=l.diff(a,"days"),e=a.day();a=a.date(n.date()).month(n.month()).year(n.year()),l=a.clone(),a=a.day(e).subtract(1,"weeks"),l=l.day(e).add(t,"days").subtract(1,"weeks"),s.add(1,"weeks");break}case"monthly":a.month()!=l.month()&&(t=1),a=a.month(n.month()).year(n.year()).subtract(1,"months"),l=l.month(n.month()).year(n.year()).subtract(1,"months").add(t,"months"),s.add(1,"months");break;case"yearly":a.year()!=l.year()&&(t=1),a=a.year(n.year()).subtract(1,"years"),l=l.year(n.year()).subtract(1,"years").add(t,"years"),s.add(1,"years");break;default:return void console.log("Wrong repeat format, allowed are: daily, weekly, monthly, yearly. Given:",Ug(i[r]))}for(;a<s;)switch(e.hiddenDates.push({start:a.valueOf(),end:l.valueOf()}),Ug(i[r])){case"daily":a=a.add(1,"days"),l=l.add(1,"days");break;case"weekly":a=a.add(1,"weeks"),l=l.add(1,"weeks");break;case"monthly":a=a.add(1,"months"),l=l.add(1,"months");break;case"yearly":a=a.add(1,"y"),l=l.add(1,"y");break;default:return void console.log("Wrong repeat format, allowed are: daily, weekly, monthly, yearly. Given:",Ug(i[r]))}e.hiddenDates.push({start:a.valueOf(),end:l.valueOf()})}}rv(e);const r=gv(e.range.start,e.hiddenDates),a=gv(e.range.end,e.hiddenDates);let l=e.range.start,h=e.range.end;1==r.hidden&&(l=1==e.range.startToFront?r.startDate-1:r.endDate+1),1==a.hidden&&(h=1==e.range.endToFront?a.startDate-1:a.endDate+1),1!=r.hidden&&1!=a.hidden||e.range._applyRange(l,h)}}function rv(t){var e;const i=t.hiddenDates,n=[];for(var o=0;o<i.length;o++)for(let t=0;t<i.length;t++)o!=t&&1!=i[t].remove&&1!=i[o].remove&&(i[t].start>=i[o].start&&i[t].end<=i[o].end?i[t].remove=!0:i[t].start>=i[o].start&&i[t].start<=i[o].end?(i[o].end=i[t].end,i[t].remove=!0):i[t].end>=i[o].start&&i[t].end<=i[o].end&&(i[o].start=i[t].start,i[t].remove=!0));for(o=0;o<i.length;o++)!0!==i[o].remove&&n.push(i[o]);t.hiddenDates=n,nv(e=t.hiddenDates).call(e,(t,e)=>t.start-e.start)}function av(t,e,i){let n=!1;const o=e.current.valueOf();for(let t=0;t<e.hiddenDates.length;t++){const i=e.hiddenDates[t].start;var s=e.hiddenDates[t].end;if(o>=i&&o<s){n=!0;break}}if(1==n&&o<e._end.valueOf()&&o!=i){const n=t(i),o=t(s);n.year()!=o.year()?e.switchedYear=!0:n.month()!=o.month()?e.switchedMonth=!0:n.dayOfYear()!=o.dayOfYear()&&(e.switchedDay=!0),e.current=o}}function lv(t,e,i){let n;if(0==t.body.hiddenDates.length)return n=t.range.conversion(i),(e.valueOf()-n.offset)*n.scale;{const o=gv(e,t.body.hiddenDates);1==o.hidden&&(e=o.startDate);const s=dv(t.body.hiddenDates,t.range.start,t.range.end);if(e<t.range.start){n=t.range.conversion(i,s);const o=cv(t.body.hiddenDates,e,n.offset);return e=t.options.moment(e).toDate().valueOf(),e+=o,-(n.offset-e.valueOf())*n.scale}if(e>t.range.end){const o={start:t.range.start,end:e};return e=uv(t.options.moment,t.body.hiddenDates,o,e),n=t.range.conversion(i,s),(e.valueOf()-n.offset)*n.scale}return e=uv(t.options.moment,t.body.hiddenDates,t.range,e),n=t.range.conversion(i,s),(e.valueOf()-n.offset)*n.scale}}function hv(t,e,i){if(0==t.body.hiddenDates.length){const n=t.range.conversion(i);return new Date(e/n.scale+n.offset)}{const n=dv(t.body.hiddenDates,t.range.start,t.range.end),o=(t.range.end-t.range.start-n)*e/i,s=mv(t.body.hiddenDates,t.range,o);return new Date(s+o+t.range.start)}}function dv(t,e,i){let n=0;for(let o=0;o<t.length;o++){const s=t[o].start,r=t[o].end;s>=e&&r<i&&(n+=r-s)}return n}function cv(t,e,i){let n=0;for(let o=0;o<t.length;o++){const s=t[o].start,r=t[o].end;s>=e&&r<=i&&(n+=r-s)}return n}function uv(t,e,i,n){return n=t(n).toDate().valueOf(),n-=pv(t,e,i,n)}function pv(t,e,i,n){let o=0;n=t(n).toDate().valueOf();for(let t=0;t<e.length;t++){const s=e[t].start,r=e[t].end;s>=i.start&&r<i.end&&n>=r&&(o+=r-s)}return o}function mv(t,e,i){let n=0,o=0,s=e.start;for(let r=0;r<t.length;r++){const a=t[r].start,l=t[r].end;if(a>=e.start&&l<e.end){if(o+=a-s,s=l,o>=i)break;n+=l-a}}return n}function fv(t,e,i,n){const o=gv(e,t);return 1==o.hidden?i<0?1==n?o.startDate-(o.endDate-e)-1:o.startDate-1:1==n?o.endDate+(e-o.startDate)+1:o.endDate+1:e}function gv(t,e){for(let o=0;o<e.length;o++){var i=e[o].start,n=e[o].end;if(t>=i&&t<n)return{hidden:!0,startDate:i,endDate:n}}return{hidden:!1,startDate:i,endDate:n}}var vv=Object.freeze({__proto__:null,convertHiddenOptions:ov,correctTimeForHidden:uv,getAccumulatedHiddenDuration:mv,getHiddenDurationBefore:pv,getHiddenDurationBeforeStart:cv,getHiddenDurationBetween:dv,getIsHidden:gv,printDates:function(t){for(let e=0;e<t.length;e++)console.log(e,new Date(t[e].start),new Date(t[e].end),t[e].start,t[e].end,t[e].remove)},removeDuplicates:rv,snapAwayFromHidden:fv,stepOverHiddenDates:av,toScreen:lv,toTime:hv,updateHiddenDates:sv});class bv extends mg{constructor(t,e){var i,n,o,s,r,a,l;super();const h=ma().hours(0).minutes(0).seconds(0).milliseconds(0),d=h.clone().add(-3,"days").valueOf(),c=h.clone().add(3,"days").valueOf();this.millisecondsPerPixelCache=void 0,void 0===e?(this.start=d,this.end=c):(this.start=e.start||d,this.end=e.end||c),this.rolling=!1,this.body=t,this.deltaDifference=0,this.scaleOffset=0,this.startToFront=!1,this.endToFront=!0,this.defaultOptions={rtl:!1,start:null,end:null,moment:ma,direction:"horizontal",moveable:!0,zoomable:!0,min:null,max:null,zoomMin:10,zoomMax:31536e10,rollingMode:{follow:!1,offset:.5}},this.options=of.extend({},this.defaultOptions),this.props={touch:{}},this.animationTimer=null,this.body.emitter.on("panstart",Js(i=this._onDragStart).call(i,this)),this.body.emitter.on("panmove",Js(n=this._onDrag).call(n,this)),this.body.emitter.on("panend",Js(o=this._onDragEnd).call(o,this)),this.body.emitter.on("mousewheel",Js(s=this._onMouseWheel).call(s,this)),this.body.emitter.on("touch",Js(r=this._onTouch).call(r,this)),this.body.emitter.on("pinch",Js(a=this._onPinch).call(a,this)),this.body.dom.rollingModeBtn.addEventListener("click",Js(l=this.startRolling).call(l,this)),this.setOptions(e)}setOptions(t){if(t){const e=["animation","direction","min","max","zoomMin","zoomMax","moveable","zoomable","moment","activate","hiddenDates","zoomKey","zoomFriction","rtl","showCurrentTime","rollingMode","horizontalScroll"];of.selectiveExtend(e,this.options,t),t.rollingMode&&t.rollingMode.follow&&this.startRolling(),("start"in t||"end"in t)&&this.setRange(t.start,t.end)}}startRolling(){const t=this;!function e(){t.stopRolling(),t.rolling=!0;let i=t.end-t.start;const n=of.convert(new Date,"Date").valueOf(),o=t.options.rollingMode&&t.options.rollingMode.offset||.5,s=n-i*o,r=n+i*(1-o);t.setRange(s,r,{animation:!1}),i=1/t.conversion(t.body.domProps.center.width).scale/10,i<30&&(i=30),i>1e3&&(i=1e3),t.body.dom.rollingModeBtn.style.visibility="hidden",t.currentTimeTimer=vr(e,i)}()}stopRolling(){void 0!==this.currentTimeTimer&&(clearTimeout(this.currentTimeTimer),this.rolling=!1,this.body.dom.rollingModeBtn.style.visibility="visible")}setRange(t,e,i,n,o){i||(i={}),!0!==i.byUser&&(i.byUser=!1);const s=this,r=null!=t?of.convert(t,"Date").valueOf():null,a=null!=e?of.convert(e,"Date").valueOf():null;if(this._cancelAnimation(),this.millisecondsPerPixelCache=void 0,i.animation){const t=this.start,e=this.end,d="object"==typeof i.animation&&"duration"in i.animation?i.animation.duration:500,c="object"==typeof i.animation&&"easingFunction"in i.animation?i.animation.easingFunction:"easeInOutQuad",u=of.easingFunctions[c];var l;if(!u)throw new Error(Of(l="Unknown easing function ".concat(Wf(c),". Choose from: ")).call(l,fm(of.easingFunctions).join(", ")));const p=rg();let m=!1;const f=()=>{if(!s.props.touch.dragging){const l=rg()-p,c=u(l/d),g=l>d,v=g||null===r?r:t+(r-t)*c,b=g||null===a?a:e+(a-e)*c;h=s._applyRange(v,b),sv(s.options.moment,s.body,s.options.hiddenDates),m=m||h;const y={start:new Date(s.start),end:new Date(s.end),byUser:i.byUser,event:i.event};if(o&&o(c,h,g),h&&s.body.emitter.emit("rangechange",y),g){if(m&&(s.body.emitter.emit("rangechanged",y),n))return n()}else s.animationTimer=vr(f,20)}};return f()}var h=this._applyRange(r,a);if(sv(this.options.moment,this.body,this.options.hiddenDates),h){const t={start:new Date(this.start),end:new Date(this.end),byUser:i.byUser,event:i.event};if(this.body.emitter.emit("rangechange",t),clearTimeout(s.timeoutID),s.timeoutID=vr(()=>{s.body.emitter.emit("rangechanged",t)},200),n)return n()}}getMillisecondsPerPixel(){return void 0===this.millisecondsPerPixelCache&&(this.millisecondsPerPixelCache=(this.end-this.start)/this.body.dom.center.clientWidth),this.millisecondsPerPixelCache}_cancelAnimation(){this.animationTimer&&(clearTimeout(this.animationTimer),this.animationTimer=null)}_applyRange(t,e){let i=null!=t?of.convert(t,"Date").valueOf():this.start,n=null!=e?of.convert(e,"Date").valueOf():this.end;const o=null!=this.options.max?of.convert(this.options.max,"Date").valueOf():null,s=null!=this.options.min?of.convert(this.options.min,"Date").valueOf():null;let r;if(isNaN(i)||null===i)throw new Error('Invalid start "'.concat(t,'"'));if(isNaN(n)||null===n)throw new Error('Invalid end "'.concat(e,'"'));if(n<i&&(n=i),null!==s&&i<s&&(r=s-i,i+=r,n+=r,null!=o&&n>o&&(n=o)),null!==o&&n>o&&(r=n-o,i-=r,n-=r,null!=s&&i<s&&(i=s)),null!==this.options.zoomMin){let t=pg(this.options.zoomMin);if(t<0&&(t=0),n-i<t){const e=.5;this.end-this.start===t&&i>=this.start-e&&n<=this.end?(i=this.start,n=this.end):(r=t-(n-i),i-=r/2,n+=r/2)}}if(null!==this.options.zoomMax){let t=pg(this.options.zoomMax);t<0&&(t=0),n-i>t&&(this.end-this.start===t&&i<this.start&&n>this.end?(i=this.start,n=this.end):(r=n-i-t,i+=r/2,n-=r/2))}const a=this.start!=i||this.end!=n;return i>=this.start&&i<=this.end||n>=this.start&&n<=this.end||this.start>=i&&this.start<=n||this.end>=i&&this.end<=n||this.body.emitter.emit("checkRangedItems"),this.start=i,this.end=n,a}getRange(){return{start:this.start,end:this.end}}conversion(t,e){return bv.conversion(this.start,this.end,t,e)}static conversion(t,e,i,n){return void 0===n&&(n=0),0!=i&&e-t!=0?{offset:t,scale:i/(e-t-n)}:{offset:0,scale:1}}_onDragStart(t){this.deltaDifference=0,this.previousDelta=0,this.options.moveable&&this._isInsideRange(t)&&this.props.touch.allowDragging&&(this.stopRolling(),this.props.touch.start=this.start,this.props.touch.end=this.end,this.props.touch.dragging=!0,this.body.dom.root&&(this.body.dom.root.style.cursor="move"))}_onDrag(t){if(!t)return;if(!this.props.touch.dragging)return;if(!this.options.moveable)return;if(!this.props.touch.allowDragging)return;const e=this.options.direction;yv(e);let i="horizontal"==e?t.deltaX:t.deltaY;i-=this.deltaDifference;let n=this.props.touch.end-this.props.touch.start;n-=dv(this.body.hiddenDates,this.start,this.end);const o="horizontal"==e?this.body.domProps.center.width:this.body.domProps.center.height;let s;s=this.options.rtl?i/o*n:-i/o*n;const r=this.props.touch.start+s,a=this.props.touch.end+s,l=fv(this.body.hiddenDates,r,this.previousDelta-i,!0),h=fv(this.body.hiddenDates,a,this.previousDelta-i,!0);if(l!=r||h!=a)return this.deltaDifference+=i,this.props.touch.start=l,this.props.touch.end=h,void this._onDrag(t);this.previousDelta=i,this._applyRange(r,a);const d=new Date(this.start),c=new Date(this.end);this.body.emitter.emit("rangechange",{start:d,end:c,byUser:!0,event:t}),this.body.emitter.emit("panmove")}_onDragEnd(t){this.props.touch.dragging&&this.options.moveable&&this.props.touch.allowDragging&&(this.props.touch.dragging=!1,this.body.dom.root&&(this.body.dom.root.style.cursor="auto"),this.body.emitter.emit("rangechanged",{start:new Date(this.start),end:new Date(this.end),byUser:!0,event:t}))}_onMouseWheel(t){let e=0;if(t.wheelDelta?e=t.wheelDelta/120:t.detail?e=-t.detail/3:t.deltaY&&(e=-t.deltaY/3),!(this.options.zoomKey&&!t[this.options.zoomKey]&&this.options.zoomable||!this.options.zoomable&&this.options.moveable)&&this.options.zoomable&&this.options.moveable&&this._isInsideRange(t)&&e){const i=this.options.zoomFriction||5;let n,o;if(n=e<0?1-e/i:1/(1+e/i),this.rolling){const t=this.options.rollingMode&&this.options.rollingMode.offset||.5;o=this.start+(this.end-this.start)*t}else{const e=this.getPointer({x:t.clientX,y:t.clientY},this.body.dom.center);o=this._pointerToDate(e)}this.zoom(n,o,e,t),t.preventDefault()}}_onTouch(t){this.props.touch.start=this.start,this.props.touch.end=this.end,this.props.touch.allowDragging=!0,this.props.touch.center=null,this.props.touch.centerDate=null,this.scaleOffset=0,this.deltaDifference=0,of.preventDefault(t)}_onPinch(t){if(!this.options.zoomable||!this.options.moveable)return;of.preventDefault(t),this.props.touch.allowDragging=!1,this.props.touch.center||(this.props.touch.center=this.getPointer(t.center,this.body.dom.center),this.props.touch.centerDate=this._pointerToDate(this.props.touch.center)),this.stopRolling();const e=1/(t.scale+this.scaleOffset),i=this.props.touch.centerDate,n=dv(this.body.hiddenDates,this.start,this.end),o=pv(this.options.moment,this.body.hiddenDates,this,i),s=n-o;let r=i-o+(this.props.touch.start-(i-o))*e,a=i+s+(this.props.touch.end-(i+s))*e;this.startToFront=1-e<=0,this.endToFront=e-1<=0;const l=fv(this.body.hiddenDates,r,1-e,!0),h=fv(this.body.hiddenDates,a,e-1,!0);l==r&&h==a||(this.props.touch.start=l,this.props.touch.end=h,this.scaleOffset=1-t.scale,r=l,a=h);const d={animation:!1,byUser:!0,event:t};this.setRange(r,a,d),this.startToFront=!1,this.endToFront=!0}_isInsideRange(t){const e=t.center?t.center.x:t.clientX,i=this.body.dom.centerContainer.getBoundingClientRect(),n=this.options.rtl?e-i.left:i.right-e,o=this.body.util.toTime(n);return o>=this.start&&o<=this.end}_pointerToDate(t){let e;const i=this.options.direction;if(yv(i),"horizontal"==i)return this.body.util.toTime(t.x).valueOf();{const i=this.body.domProps.center.height;return e=this.conversion(i),t.y/e.scale+e.offset}}getPointer(t,e){const i=e.getBoundingClientRect();return this.options.rtl?{x:i.right-t.x,y:t.y-i.top}:{x:t.x-i.left,y:t.y-i.top}}zoom(t,e,i,n){null==e&&(e=(this.start+this.end)/2);const o=dv(this.body.hiddenDates,this.start,this.end),s=pv(this.options.moment,this.body.hiddenDates,this,e),r=o-s;let a=e-s+(this.start-(e-s))*t,l=e+r+(this.end-(e+r))*t;this.startToFront=!(i>0),this.endToFront=!(-i>0);const h=fv(this.body.hiddenDates,a,i,!0),d=fv(this.body.hiddenDates,l,-i,!0);h==a&&d==l||(a=h,l=d);const c={animation:!1,byUser:!0,event:n};this.setRange(a,l,c),this.startToFront=!1,this.endToFront=!0}move(t){const e=this.end-this.start,i=this.start+e*t,n=this.end+e*t;this.start=i,this.end=n}moveTo(t){const e=(this.start+this.end)/2-t,i=this.start-e,n=this.end-e;this.setRange(i,n,{animation:!1,byUser:!0,event:null})}destroy(){this.stopRolling()}}function yv(t){if("horizontal"!=t&&"vertical"!=t)throw new TypeError('Unknown direction "'.concat(t,'". Choose "horizontal" or "vertical".'))}var _v,wv,xv,kv,Dv,Sv,Cv,Tv,Mv,Ov={};function Ev(){return xv?wv:(xv=1,function(){if(_v)return Ov;_v=1;var t=bs(),e=Vi(),i=za().indexOf,n=aa(),o=e([].indexOf),s=!!o&&1/o([1],1,-0)<0;t({target:"Array",proto:!0,forced:s||!n("indexOf")},{indexOf:function(t){var e=arguments.length>1?arguments[1]:void 0;return s?o(this,t,e)||0:i(this,t,e)}})}(),wv=zs()("Array","indexOf"))}function Pv(){if(Dv)return kv;Dv=1;var t=qn(),e=Ev(),i=Array.prototype;return kv=function(n){var o=n.indexOf;return n===i||t(i,n)&&o===i.indexOf?e:o},kv}function Av(){return Cv?Sv:(Cv=1,Sv=Pv())}var Iv,Nv,Lv,Fv,Rv,Yv,jv,Hv,zv,Gv,Wv,Bv=n(Mv?Tv:(Mv=1,Tv=Av())),Vv={};function Uv(){if(Nv)return Iv;Nv=1;var t=Ji(),e=ys(),i=TypeError,n=Object.getOwnPropertyDescriptor,o=t&&!function(){if(void 0!==this)return!0;try{Object.defineProperty([],"length",{writable:!1}).length=1}catch(t){return t instanceof TypeError}}();return Iv=o?function(t,o){if(e(t)&&!n(t,"length").writable)throw new i("Cannot set read only .length");return t.length=o}:function(t,e){return t.length=e}}function Xv(){return Rv?Fv:(Rv=1,function(){if(Lv)return Vv;Lv=1;var t=bs(),e=Yo(),i=Ha(),n=Qr(),o=ea(),s=Uv(),r=Pd(),a=sa(),l=Uh(),h=qg(),d=vh()("splice"),c=Math.max,u=Math.min;t({target:"Array",proto:!0,forced:!d},{splice:function(t,d){var p,m,f,g,v,b,y=e(this),_=o(y),w=i(t,_),x=arguments.length;for(0===x?p=m=0:1===x?(p=0,m=_-w):(p=x-2,m=u(c(n(d),0),_-w)),r(_+p-m),f=a(y,m),g=0;g<m;g++)(v=w+g)in y&&l(f,g,y[v]);if(f.length=m,p<m){for(g=w;g<_-m;g++)b=g+p,(v=g+m)in y?y[b]=y[v]:h(y,b);for(g=_;g>_-m+p;g--)h(y,g-1)}else if(p>m)for(g=_-m;g>w;g--)b=g+p-1,(v=g+m-1)in y?y[b]=y[v]:h(y,b);for(g=0;g<p;g++)y[g+w]=arguments[g+2];return s(y,_-m+p),f}})}(),Fv=zs()("Array","splice"))}function qv(){if(jv)return Yv;jv=1;var t=qn(),e=Xv(),i=Array.prototype;return Yv=function(n){var o=n.splice;return n===i||t(i,n)&&o===i.splice?e:o},Yv}function Zv(){return zv?Hv:(zv=1,Hv=qv())}var Kv,$v,Jv,Qv,tb,eb,ib,nb,ob,sb=n(Wv?Gv:(Wv=1,Gv=Zv())),rb={};function ab(){return Jv?$v:(Jv=1,function(){if(Kv)return rb;Kv=1;var t=bs(),e=ra().some;t({target:"Array",proto:!0,forced:!aa()("some")},{some:function(t){return e(this,t,arguments.length>1?arguments[1]:void 0)}})}(),$v=zs()("Array","some"))}function lb(){if(tb)return Qv;tb=1;var t=qn(),e=ab(),i=Array.prototype;return Qv=function(n){var o=n.some;return n===i||t(i,n)&&o===i.some?e:o},Qv}function hb(){return ib?eb:(ib=1,eb=lb())}var db,cb,ub,pb,mb=n(ob?nb:(ob=1,nb=hb()));function fb(){return cb?db:(cb=1,cr(),db=Un().setInterval)}var gb=n(pb?ub:(pb=1,ub=fb())),vb=null;let bb;if("undefined"!=typeof window){bb=function t(e,i){var n=i||{preventDefault:!1};if(e.Manager){var o=e,s=function(e,i){var s=Object.create(n);return i&&o.assign(s,i),t(new o(e,s),s)};return o.assign(s,o),s.Manager=function(e,i){var s=Object.create(n);return i&&o.assign(s,i),t(new o.Manager(e,s),s)},s}var r=Object.create(e),a=e.element;function l(t){return t.match(/[^ ]+/g)}function h(t){if("hammer.input"!==t.type){if(t.srcEvent._handled||(t.srcEvent._handled={}),t.srcEvent._handled[t.type])return;t.srcEvent._handled[t.type]=!0}var e=!1;t.stopPropagation=function(){e=!0};var i=t.srcEvent.stopPropagation.bind(t.srcEvent);"function"==typeof i&&(t.srcEvent.stopPropagation=function(){i(),t.stopPropagation()}),t.firstTarget=vb;for(var n=vb.isConnected?vb:t.target;n&&!e;){var o=n.hammer;if(o)for(var s,r=0;r<o.length;r++)if(s=o[r]._handlers[t.type])for(var a=0;a<s.length&&!e;a++)s[a](t);n=n.parentNode}}return a.hammer||(a.hammer=[]),a.hammer.push(r),e.on("hammer.input",function(t){!0!==n.preventDefault&&n.preventDefault!==t.pointerType||t.preventDefault(),t.isFirst&&(vb=t.target)}),r._handlers={},r.on=function(t,i){return l(t).forEach(function(t){var n=r._handlers[t];n||(r._handlers[t]=n=[],e.on(t,h)),n.push(i)}),r},r.off=function(t,i){return l(t).forEach(function(t){var n=r._handlers[t];n&&((n=i?n.filter(function(t){return t!==i}):[]).length>0?r._handlers[t]=n:(e.off(t,h),delete r._handlers[t]))}),r},r.emit=function(t,i){vb=i.target,e.emit(t,i)},r.destroy=function(){var t=e.element.hammer,i=t.indexOf(r);-1!==i&&t.splice(i,1),t.length||delete e.element.hammer,r._handlers={},e.destroy()},r}(window.Hammer||oe,{preventDefault:"mouse"})}else bb=function(){return function(){const t=()=>{};return{on:t,off:t,destroy:t,emit:t,get:e=>({set:t})}}()};var yb=bb;function _b(t,e){e.inputHandler=function(t){t.isFirst&&e(t)},t.on("hammer.input",e.inputHandler)}var wb,xb,kb,Db,Sb,Cb,Tb,Mb,Ob,Eb={};function Pb(){if(xb)return wb;xb=1;var t=ji(),e=Hi(),i=Wi(),n=ya(),o=hg().trim,s=lg(),r=t.parseInt,a=t.Symbol,l=a&&a.iterator,h=/^[+-]?0x/i,d=i(h.exec),c=8!==r(s+"08")||22!==r(s+"0x16")||l&&!e(function(){r(Object(l))});return wb=c?function(t,e){var i=o(n(t));return r(i,e>>>0||(d(h,i)?16:10))}:r,wb}function Ab(){return Sb?Db:(Sb=1,function(){if(kb)return Eb;kb=1;var t=bs(),e=Pb();t({global:!0,forced:parseInt!==e},{parseInt:e})}(),Db=Un().parseInt)}function Ib(){return Tb?Cb:(Tb=1,Cb=Ab())}var Nb=n(Ob?Mb:(Ob=1,Mb=Ib()));class Lb{constructor(t,e,i,n,o){this.moment=o&&o.moment||ma,this.options=o||{},this.current=this.moment(),this._start=this.moment(),this._end=this.moment(),this.autoScale=!0,this.scale="day",this.step=1,this.setRange(t,e,i),this.switchedDay=!1,this.switchedMonth=!1,this.switchedYear=!1,Rs(n)?this.hiddenDates=n:this.hiddenDates=null!=n?[n]:[],this.format=Lb.FORMAT}setMoment(t){this.moment=t,this.current=this.moment(this.current.valueOf()),this._start=this.moment(this._start.valueOf()),this._end=this.moment(this._end.valueOf())}setFormat(t){const e=of.deepExtend({},Lb.FORMAT);this.format=of.deepExtend(e,t)}setRange(t,e,i){if(!(t instanceof Date&&e instanceof Date))throw"No legal start or end date in method setRange";this._start=null!=t?this.moment(t.valueOf()):rg(),this._end=null!=e?this.moment(e.valueOf()):rg(),this.autoScale&&this.setMinimumStep(i)}start(){this.current=this._start.clone(),this.roundToMinor()}roundToMinor(){switch("week"==this.scale&&this.current.weekday(0),this.scale){case"year":this.current=this.current.year(this.step*Math.floor(this.current.year()/this.step)).month(0);case"month":this.current=this.current.date(1);case"week":case"day":case"weekday":this.current=this.current.hours(0);case"hour":this.current=this.current.minutes(0);case"minute":this.current=this.current.seconds(0);case"second":this.current=this.current.milliseconds(0)}if(1!=this.step){let t=this.current.clone();switch(this.scale){case"millisecond":this.current=this.current.subtract(this.current.milliseconds()%this.step,"milliseconds");break;case"second":this.current=this.current.subtract(this.current.seconds()%this.step,"seconds");break;case"minute":this.current=this.current.subtract(this.current.minutes()%this.step,"minutes");break;case"hour":this.current=this.current.subtract(this.current.hours()%this.step,"hours");break;case"weekday":case"day":this.current=this.current.subtract((this.current.date()-1)%this.step,"day");break;case"week":this.current=this.current.subtract(this.current.week()%this.step,"week");break;case"month":this.current=this.current.subtract(this.current.month()%this.step,"month");break;case"year":this.current=this.current.subtract(this.current.year()%this.step,"year")}t.isSame(this.current)||(this.current=this.moment(fv(this.hiddenDates,this.current.valueOf(),-1,!0)))}}hasNext(){return this.current.valueOf()<=this._end.valueOf()}next(){const t=this.current.valueOf();switch(this.scale){case"millisecond":this.current=this.current.add(this.step,"millisecond");break;case"second":this.current=this.current.add(this.step,"second");break;case"minute":this.current=this.current.add(this.step,"minute");break;case"hour":this.current=this.current.add(this.step,"hour"),this.current.month()<6?this.current=this.current.subtract(this.current.hours()%this.step,"hour"):this.current.hours()%this.step!==0&&(this.current=this.current.add(this.step-this.current.hours()%this.step,"hour"));break;case"weekday":case"day":this.current=this.current.add(this.step,"day");break;case"week":if(0!==this.current.weekday())this.current=this.current.weekday(0).add(this.step,"week");else if(!1===this.options.showMajorLabels)this.current=this.current.add(this.step,"week");else{const t=this.current.clone();t.add(1,"week"),t.isSame(this.current,"month")?this.current=this.current.add(this.step,"week"):this.current=this.current.add(this.step,"week").date(1)}break;case"month":this.current=this.current.add(this.step,"month");break;case"year":this.current=this.current.add(this.step,"year")}if(1!=this.step)switch(this.scale){case"millisecond":this.current.milliseconds()>0&&this.current.milliseconds()<this.step&&(this.current=this.current.milliseconds(0));break;case"second":this.current.seconds()>0&&this.current.seconds()<this.step&&(this.current=this.current.seconds(0));break;case"minute":this.current.minutes()>0&&this.current.minutes()<this.step&&(this.current=this.current.minutes(0));break;case"hour":this.current.hours()>0&&this.current.hours()<this.step&&(this.current=this.current.hours(0));break;case"weekday":case"day":this.current.date()<this.step+1&&(this.current=this.current.date(1));break;case"week":this.current.week()<this.step&&(this.current=this.current.week(1));break;case"month":this.current.month()<this.step&&(this.current=this.current.month(0))}this.current.valueOf()==t&&(this.current=this._end.clone()),this.switchedDay=!1,this.switchedMonth=!1,this.switchedYear=!1,av(this.moment,this,t)}getCurrent(){return this.current.clone()}setScale(t){t&&"string"==typeof t.scale&&(this.scale=t.scale,this.step=t.step>0?t.step:1,this.autoScale=!1)}setAutoScale(t){this.autoScale=t}setMinimumStep(t){if(null==t)return;const e=31104e6,i=2592e6,n=864e5,o=36e5,s=6e4,r=1e3;1e3*e>t&&(this.scale="year",this.step=1e3),500*e>t&&(this.scale="year",this.step=500),100*e>t&&(this.scale="year",this.step=100),50*e>t&&(this.scale="year",this.step=50),10*e>t&&(this.scale="year",this.step=10),5*e>t&&(this.scale="year",this.step=5),e>t&&(this.scale="year",this.step=1),7776e6>t&&(this.scale="month",this.step=3),i>t&&(this.scale="month",this.step=1),6048e5>t&&this.options.showWeekScale&&(this.scale="week",this.step=1),1728e5>t&&(this.scale="day",this.step=2),n>t&&(this.scale="day",this.step=1),432e5>t&&(this.scale="weekday",this.step=1),144e5>t&&(this.scale="hour",this.step=4),o>t&&(this.scale="hour",this.step=1),9e5>t&&(this.scale="minute",this.step=15),6e5>t&&(this.scale="minute",this.step=10),3e5>t&&(this.scale="minute",this.step=5),s>t&&(this.scale="minute",this.step=1),15e3>t&&(this.scale="second",this.step=15),1e4>t&&(this.scale="second",this.step=10),5e3>t&&(this.scale="second",this.step=5),r>t&&(this.scale="second",this.step=1),200>t&&(this.scale="millisecond",this.step=200),100>t&&(this.scale="millisecond",this.step=100),50>t&&(this.scale="millisecond",this.step=50),10>t&&(this.scale="millisecond",this.step=10),5>t&&(this.scale="millisecond",this.step=5),1>t&&(this.scale="millisecond",this.step=1)}static snap(t,e,i){let n=ma(t);if("year"==e){const t=n.year()+Math.round(n.month()/12);n=n.year(Math.round(t/i)*i).month(0).date(0).hours(0).minutes(0).seconds(0).milliseconds(0)}else if("month"==e)n=n.date()>15?n.date(1).add(1,"month"):n.date(1),n=n.hours(0).minutes(0).seconds(0).milliseconds(0);else if("week"==e)n=n.weekday()>2?n.weekday(0).add(1,"week"):n.weekday(0),n=n.hours(0).minutes(0).seconds(0).milliseconds(0);else if("day"==e){switch(i){case 5:case 2:n=n.hours(24*Math.round(n.hours()/24));break;default:n=n.hours(12*Math.round(n.hours()/12))}n=n.minutes(0).seconds(0).milliseconds(0)}else if("weekday"==e){switch(i){case 5:case 2:n=n.hours(12*Math.round(n.hours()/12));break;default:n=n.hours(6*Math.round(n.hours()/6))}n=n.minutes(0).seconds(0).milliseconds(0)}else if("hour"==e){if(4===i)n=n.minutes(60*Math.round(n.minutes()/60));else n=n.minutes(30*Math.round(n.minutes()/30));n=n.seconds(0).milliseconds(0)}else if("minute"==e){switch(i){case 15:case 10:n=n.minutes(5*Math.round(n.minutes()/5)).seconds(0);break;case 5:n=n.seconds(60*Math.round(n.seconds()/60));break;default:n=n.seconds(30*Math.round(n.seconds()/30))}n=n.milliseconds(0)}else if("second"==e)switch(i){case 15:case 10:n=n.seconds(5*Math.round(n.seconds()/5)).milliseconds(0);break;case 5:n=n.milliseconds(1e3*Math.round(n.milliseconds()/1e3));break;default:n=n.milliseconds(500*Math.round(n.milliseconds()/500))}else if("millisecond"==e){const t=i>5?i/2:1;n=n.milliseconds(Math.round(n.milliseconds()/t)*t)}return n}isMajor(){if(1==this.switchedYear)switch(this.scale){case"year":case"month":case"week":case"weekday":case"day":case"hour":case"minute":case"second":case"millisecond":return!0;default:return!1}else if(1==this.switchedMonth)switch(this.scale){case"week":case"weekday":case"day":case"hour":case"minute":case"second":case"millisecond":return!0;default:return!1}else if(1==this.switchedDay)switch(this.scale){case"millisecond":case"second":case"minute":case"hour":return!0;default:return!1}const t=this.moment(this.current);switch(this.scale){case"millisecond":return 0==t.milliseconds();case"second":return 0==t.seconds();case"minute":return 0==t.hours()&&0==t.minutes();case"hour":return 0==t.hours();case"weekday":case"day":return this.options.showWeekScale?1==t.isoWeekday():1==t.date();case"week":return 1==t.date();case"month":return 0==t.month();default:return!1}}getLabelMinor(t){if(null==t&&(t=this.current),t instanceof Date&&(t=this.moment(t)),"function"==typeof this.format.minorLabels)return this.format.minorLabels(t,this.scale,this.step);const e=this.format.minorLabels[this.scale];return"week"===this.scale&&1===t.date()&&0!==t.weekday()?"":e&&e.length>0?this.moment(t).format(e):""}getLabelMajor(t){if(null==t&&(t=this.current),t instanceof Date&&(t=this.moment(t)),"function"==typeof this.format.majorLabels)return this.format.majorLabels(t,this.scale,this.step);const e=this.format.majorLabels[this.scale];return e&&e.length>0?this.moment(t).format(e):""}getClassName(){var t;const e=this.moment,i=this.moment(this.current),n=i.locale?i.locale("en"):i.lang("en"),o=this.step,s=[];function r(t){return t/o%2==0?" vis-even":" vis-odd"}function a(t){return t.isSame(rg(),"day")?" vis-today":t.isSame(e().add(1,"day"),"day")?" vis-tomorrow":t.isSame(e().add(-1,"day"),"day")?" vis-yesterday":""}function l(t){return t.isSame(rg(),"week")?" vis-current-week":""}function h(t){return t.isSame(rg(),"month")?" vis-current-month":""}switch(this.scale){case"millisecond":s.push(a(n)),s.push(r(n.milliseconds()));break;case"second":s.push(a(n)),s.push(r(n.seconds()));break;case"minute":s.push(a(n)),s.push(r(n.minutes()));break;case"hour":s.push(Of(t="vis-h".concat(n.hours())).call(t,4==this.step?"-h"+(n.hours()+4):"")),s.push(a(n)),s.push(r(n.hours()));break;case"weekday":s.push("vis-".concat(n.format("dddd").toLowerCase())),s.push(a(n)),s.push(l(n)),s.push(r(n.date()));break;case"day":s.push("vis-day".concat(n.date())),s.push("vis-".concat(n.format("MMMM").toLowerCase())),s.push(a(n)),s.push(h(n)),s.push(this.step<=2?a(n):""),s.push(this.step<=2?"vis-".concat(n.format("dddd").toLowerCase()):""),s.push(r(n.date()-1));break;case"week":s.push("vis-week".concat(n.format("w"))),s.push(l(n)),s.push(r(n.week()));break;case"month":s.push("vis-".concat(n.format("MMMM").toLowerCase())),s.push(h(n)),s.push(r(n.month()));break;case"year":s.push("vis-year".concat(n.year())),s.push(function(t){return t.isSame(rg(),"year")?" vis-current-year":""}(n)),s.push(r(n.year()))}return Th(s).call(s,String).join(" ")}}Lb.FORMAT={minorLabels:{millisecond:"SSS",second:"s",minute:"HH:mm",hour:"HH:mm",weekday:"ddd D",day:"D",week:"w",month:"MMM",year:"YYYY"},majorLabels:{millisecond:"HH:mm:ss",second:"D MMMM HH:mm",minute:"ddd D MMMM",hour:"ddd D MMMM",weekday:"MMMM YYYY",day:"MMMM YYYY",week:"MMMM YYYY",month:"YYYY",year:""}};class Fb extends mg{constructor(t,e){super(),this.dom={foreground:null,lines:[],majorTexts:[],minorTexts:[],redundant:{lines:[],majorTexts:[],minorTexts:[]}},this.props={range:{start:0,end:0,minimumStep:0},lineTop:0},this.defaultOptions={orientation:{axis:"bottom"},showMinorLabels:!0,showMajorLabels:!0,showWeekScale:!1,maxMinorChars:7,format:of.extend({},Lb.FORMAT),moment:ma,timeAxis:null},this.options=of.extend({},this.defaultOptions),this.body=t,this._create(),this.setOptions(e)}setOptions(t){t&&(of.selectiveExtend(["showMinorLabels","showMajorLabels","showWeekScale","maxMinorChars","hiddenDates","timeAxis","moment","rtl"],this.options,t),of.selectiveDeepExtend(["format"],this.options,t),"orientation"in t&&("string"==typeof t.orientation?this.options.orientation.axis=t.orientation:"object"==typeof t.orientation&&"axis"in t.orientation&&(this.options.orientation.axis=t.orientation.axis)),"locale"in t&&("function"==typeof ma.locale?ma.locale(t.locale):ma.lang(t.locale)))}_create(){this.dom.foreground=document.createElement("div"),this.dom.background=document.createElement("div"),this.dom.foreground.className="vis-time-axis vis-foreground",this.dom.background.className="vis-time-axis vis-background"}destroy(){this.dom.foreground.parentNode&&this.dom.foreground.parentNode.removeChild(this.dom.foreground),this.dom.background.parentNode&&this.dom.background.parentNode.removeChild(this.dom.background),this.body=null}redraw(){const t=this.props,e=this.dom.foreground,i=this.dom.background,n="top"==this.options.orientation.axis?this.body.dom.top:this.body.dom.bottom,o=e.parentNode!==n;this._calculateCharSize();const s=this.options.showMinorLabels&&"none"!==this.options.orientation.axis,r=this.options.showMajorLabels&&"none"!==this.options.orientation.axis;t.minorLabelHeight=s?t.minorCharHeight:0,t.majorLabelHeight=r?t.majorCharHeight:0,t.height=t.minorLabelHeight+t.majorLabelHeight,t.width=e.offsetWidth,t.minorLineHeight=this.body.domProps.root.height-t.majorLabelHeight-("top"==this.options.orientation.axis?this.body.domProps.bottom.height:this.body.domProps.top.height),t.minorLineWidth=1,t.majorLineHeight=t.minorLineHeight+t.majorLabelHeight,t.majorLineWidth=1;const a=e.nextSibling,l=i.nextSibling;return e.parentNode&&e.parentNode.removeChild(e),i.parentNode&&i.parentNode.removeChild(i),e.style.height="".concat(this.props.height,"px"),this._repaintLabels(),a?n.insertBefore(e,a):n.appendChild(e),l?this.body.dom.backgroundVertical.insertBefore(i,l):this.body.dom.backgroundVertical.appendChild(i),this._isResized()||o}_repaintLabels(){const t=this.options.orientation.axis,e=of.convert(this.body.range.start,"Number"),i=of.convert(this.body.range.end,"Number"),n=this.body.util.toTime((this.props.minorCharWidth||10)*this.options.maxMinorChars).valueOf();let o=n-pv(this.options.moment,this.body.hiddenDates,this.body.range,n);o-=this.body.util.toTime(0).valueOf();const s=new Lb(new Date(e),new Date(i),o,this.body.hiddenDates,this.options);s.setMoment(this.options.moment),this.options.format&&s.setFormat(this.options.format),this.options.timeAxis&&s.setScale(this.options.timeAxis),this.step=s;const r=this.dom;let a,l,h,d,c,u;r.redundant.lines=r.lines,r.redundant.majorTexts=r.majorTexts,r.redundant.minorTexts=r.minorTexts,r.lines=[],r.majorTexts=[],r.minorTexts=[];let p,m,f,g=0,v=0;const b=1e3;let y;for(s.start(),l=s.getCurrent(),d=this.body.util.toScreen(l);s.hasNext()&&v<b;){if(v++,c=s.isMajor(),y=s.getClassName(),a=l,h=d,s.next(),l=s.getCurrent(),d=this.body.util.toScreen(l),p=g,g=d-h,"week"===s.scale)u=!0;else u=g>=.4*p;if(this.options.showMinorLabels&&u){var _=this._repaintMinorText(h,s.getLabelMinor(a),t,y);_.style.width="".concat(g,"px")}c&&this.options.showMajorLabels?(h>0&&(null==f&&(f=h),_=this._repaintMajorText(h,s.getLabelMajor(a),t,y)),m=this._repaintMajorLine(h,g,t,y)):u?m=this._repaintMinorLine(h,g,t,y):m&&(m.style.width="".concat(Nb(m.style.width)+g,"px"))}if(v!==b||Rb||(console.warn("Something is wrong with the Timeline scale. Limited drawing of grid lines to ".concat(b," lines.")),Rb=!0),this.options.showMajorLabels){const e=this.body.util.toTime(0),i=s.getLabelMajor(e),n=i.length*(this.props.majorCharWidth||10)+10;(null==f||n<f)&&this._repaintMajorText(0,i,t,y)}ua(of).call(of,this.dom.redundant,t=>{for(;t.length;){const e=t.pop();e&&e.parentNode&&e.parentNode.removeChild(e)}})}_repaintMinorText(t,e,i,n){let o=this.dom.redundant.minorTexts.shift();if(!o){const t=document.createTextNode("");o=document.createElement("div"),o.appendChild(t),this.dom.foreground.appendChild(o)}this.dom.minorTexts.push(o),o.innerHTML=of.xss(e);let s="top"==i?this.props.majorLabelHeight:0;return this._setXY(o,t,s),o.className="vis-text vis-minor ".concat(n),o}_repaintMajorText(t,e,i,n){let o=this.dom.redundant.majorTexts.shift();if(!o){const t=document.createElement("div");o=document.createElement("div"),o.appendChild(t),this.dom.foreground.appendChild(o)}o.childNodes[0].innerHTML=of.xss(e),o.className="vis-text vis-major ".concat(n);let s="top"==i?0:this.props.minorLabelHeight;return this._setXY(o,t,s),this.dom.majorTexts.push(o),o}_setXY(t,e,i){var n;const o=this.options.rtl?-1*e:e;t.style.transform=Of(n="translate(".concat(o,"px, ")).call(n,i,"px)")}_repaintMinorLine(t,e,i,n){var o;let s=this.dom.redundant.lines.shift();s||(s=document.createElement("div"),this.dom.background.appendChild(s)),this.dom.lines.push(s);const r=this.props;s.style.width="".concat(e,"px"),s.style.height="".concat(r.minorLineHeight,"px");let a="top"==i?r.majorLabelHeight:this.body.domProps.top.height,l=t-r.minorLineWidth/2;return this._setXY(s,l,a),s.className=Of(o="vis-grid ".concat(this.options.rtl?"vis-vertical-rtl":"vis-vertical"," vis-minor ")).call(o,n),s}_repaintMajorLine(t,e,i,n){var o;let s=this.dom.redundant.lines.shift();s||(s=document.createElement("div"),this.dom.background.appendChild(s)),this.dom.lines.push(s);const r=this.props;s.style.width="".concat(e,"px"),s.style.height="".concat(r.majorLineHeight,"px");let a="top"==i?0:this.body.domProps.top.height,l=t-r.majorLineWidth/2;return this._setXY(s,l,a),s.className=Of(o="vis-grid ".concat(this.options.rtl?"vis-vertical-rtl":"vis-vertical"," vis-major ")).call(o,n),s}_calculateCharSize(){this.dom.measureCharMinor||(this.dom.measureCharMinor=document.createElement("DIV"),this.dom.measureCharMinor.className="vis-text vis-minor vis-measure",this.dom.measureCharMinor.style.position="absolute",this.dom.measureCharMinor.appendChild(document.createTextNode("0")),this.dom.foreground.appendChild(this.dom.measureCharMinor)),this.props.minorCharHeight=this.dom.measureCharMinor.clientHeight,this.props.minorCharWidth=this.dom.measureCharMinor.clientWidth,this.dom.measureCharMajor||(this.dom.measureCharMajor=document.createElement("DIV"),this.dom.measureCharMajor.className="vis-text vis-major vis-measure",this.dom.measureCharMajor.style.position="absolute",this.dom.measureCharMajor.appendChild(document.createTextNode("0")),this.dom.foreground.appendChild(this.dom.measureCharMajor)),this.props.majorCharHeight=this.dom.measureCharMajor.clientHeight,this.props.majorCharWidth=this.dom.measureCharMajor.clientWidth}}var Rb=!1;function Yb(t){var e,i=t&&t.preventDefault||!1,n=t&&t.container||window,o={},s={keydown:{},keyup:{}},r={};for(e=97;e<=122;e++)r[String.fromCharCode(e)]={code:e-97+65,shift:!1};for(e=65;e<=90;e++)r[String.fromCharCode(e)]={code:e,shift:!0};for(e=0;e<=9;e++)r[""+e]={code:48+e,shift:!1};for(e=1;e<=12;e++)r["F"+e]={code:111+e,shift:!1};for(e=0;e<=9;e++)r["num"+e]={code:96+e,shift:!1};r["num*"]={code:106,shift:!1},r["num+"]={code:107,shift:!1},r["num-"]={code:109,shift:!1},r["num/"]={code:111,shift:!1},r["num."]={code:110,shift:!1},r.left={code:37,shift:!1},r.up={code:38,shift:!1},r.right={code:39,shift:!1},r.down={code:40,shift:!1},r.space={code:32,shift:!1},r.enter={code:13,shift:!1},r.shift={code:16,shift:void 0},r.esc={code:27,shift:!1},r.backspace={code:8,shift:!1},r.tab={code:9,shift:!1},r.ctrl={code:17,shift:!1},r.alt={code:18,shift:!1},r.delete={code:46,shift:!1},r.pageup={code:33,shift:!1},r.pagedown={code:34,shift:!1},r["="]={code:187,shift:!1},r["-"]={code:189,shift:!1},r["]"]={code:221,shift:!1},r["["]={code:219,shift:!1};var a=function(t){h(t,"keydown")},l=function(t){h(t,"keyup")},h=function(t,e){if(void 0!==s[e][t.keyCode]){for(var n=s[e][t.keyCode],o=0;o<n.length;o++)(void 0===n[o].shift||1==n[o].shift&&1==t.shiftKey||0==n[o].shift&&0==t.shiftKey)&&n[o].fn(t);1==i&&t.preventDefault()}};return o.bind=function(t,e,i){if(void 0===i&&(i="keydown"),void 0===r[t])throw new Error("unsupported key: "+t);void 0===s[i][r[t].code]&&(s[i][r[t].code]=[]),s[i][r[t].code].push({fn:e,shift:r[t].shift})},o.bindAll=function(t,e){for(var i in void 0===e&&(e="keydown"),r)r.hasOwnProperty(i)&&o.bind(i,t,e)},o.getKey=function(t){for(var e in r)if(r.hasOwnProperty(e)){if(1==t.shiftKey&&1==r[e].shift&&t.keyCode==r[e].code)return e;if(0==t.shiftKey&&0==r[e].shift&&t.keyCode==r[e].code)return e;if(t.keyCode==r[e].code&&"shift"==e)return e}return"unknown key, currently not supported"},o.unbind=function(t,e,i){if(void 0===i&&(i="keydown"),void 0===r[t])throw new Error("unsupported key: "+t);if(void 0!==e){var n=[],o=s[i][r[t].code];if(void 0!==o)for(var a=0;a<o.length;a++)o[a].fn==e&&o[a].shift==r[t].shift||n.push(s[i][r[t].code][a]);s[i][r[t].code]=n}else s[i][r[t].code]=[]},o.reset=function(){s={keydown:{},keyup:{}}},o.destroy=function(){s={keydown:{},keyup:{}},n.removeEventListener("keydown",a,!0),n.removeEventListener("keyup",l,!0)},n.addEventListener("keydown",a,!0),n.addEventListener("keyup",l,!0),o}function jb(t){var e,i;this.active=!1,this.dom={container:t},this.dom.overlay=document.createElement("div"),this.dom.overlay.className="vis-overlay",this.dom.container.appendChild(this.dom.overlay),this.hammer=yb(this.dom.overlay),this.hammer.on("tap",Js(e=this._onTapOverlay).call(e,this));var n=this,o=["tap","doubletap","press","pinch","pan","panstart","panmove","panend"];ua(o).call(o,function(t){n.hammer.on(t,function(t){t.stopPropagation()})}),document&&document.body&&(this.onClick=function(e){(function(t,e){for(;t;){if(t===e)return!0;t=t.parentNode}return!1})(e.target,t)||n.deactivate()},document.body.addEventListener("click",this.onClick)),void 0!==this.keycharm&&this.keycharm.destroy(),this.keycharm=Yb(),this.escListener=Js(i=this.deactivate).call(i,this)}w(jb.prototype),jb.current=null,jb.prototype.destroy=function(){this.deactivate(),this.dom.overlay.parentNode.removeChild(this.dom.overlay),this.onClick&&document.body.removeEventListener("click",this.onClick),void 0!==this.keycharm&&this.keycharm.destroy(),this.keycharm=null,this.hammer.destroy(),this.hammer=null},jb.prototype.activate=function(){var t;jb.current&&jb.current.deactivate(),jb.current=this,this.active=!0,this.dom.overlay.style.display="none",of.addClassName(this.dom.container,"vis-active"),this.emit("change"),this.emit("activate"),Js(t=this.keycharm).call(t,"esc",this.escListener)},jb.prototype.deactivate=function(){jb.current===this&&(jb.current=null),this.active=!1,this.dom.overlay.style.display="",of.removeClassName(this.dom.container,"vis-active"),this.keycharm.unbind("esc",this.escListener),this.emit("change"),this.emit("deactivate")},jb.prototype._onTapOverlay=function(t){this.activate(),t.stopPropagation()};const Hb={current:"current",time:"time",deleteSelected:"Delete selected"},zb={current:"attuale",time:"tempo",deleteSelected:"Cancella la selezione"},Gb={current:"huidige",time:"tijd",deleteSelected:"Selectie verwijderen"},Wb={current:"Aktuelle",time:"Zeit",deleteSelected:"Lösche Auswahl"},Bb={current:"actuel",time:"heure",deleteSelected:"Effacer la selection"},Vb={current:"corriente",time:"hora",deleteSelected:"Eliminar selección"},Ub={current:"поточний",time:"час",deleteSelected:"Видалити обране"},Xb={current:"текущее",time:"время",deleteSelected:"Удалить выбранное"},qb={current:"aktualny",time:"czas",deleteSelected:"Usuń wybrane"},Zb={current:"atual",time:"data",deleteSelected:"Apagar selecionado"},Kb={current:"現在",time:"時刻",deleteSelected:"選択されたものを削除"},$b={current:"nuvarande",time:"tid",deleteSelected:"Radera valda"},Jb={current:"nåværende",time:"tid",deleteSelected:"Slett valgte"},Qb={current:"einamas",time:"laikas",deleteSelected:"Pašalinti pasirinktą"},ty={en:Hb,en_EN:Hb,en_US:Hb,it:zb,it_IT:zb,it_CH:zb,nl:Gb,nl_NL:Gb,nl_BE:Gb,de:Wb,de_DE:Wb,fr:Bb,fr_FR:Bb,fr_CA:Bb,fr_BE:Bb,es:Vb,es_ES:Vb,uk:Ub,uk_UA:Ub,ru:Xb,ru_RU:Xb,pl:qb,pl_PL:qb,pt:Zb,pt_BR:Zb,pt_PT:Zb,ja:Kb,ja_JP:Kb,lt:Qb,lt_LT:Qb,sv:$b,sv_SE:$b,nb:Jb,nn:Jb,nb_NO:Jb,nn_NO:Jb};class ey extends mg{constructor(t,e){var i;super(),this.body=t,this.defaultOptions={moment:ma,locales:ty,locale:"en",id:void 0,title:void 0},this.options=of.extend({},this.defaultOptions),this.setOptions(e),this.options.locales=of.extend({},ty,this.options.locales);const n=this.defaultOptions.locales[this.defaultOptions.locale];ua(i=fm(this.options.locales)).call(i,t=>{this.options.locales[t]=of.extend({},n,this.options.locales[t])}),e&&null!=e.time?this.customTime=e.time:this.customTime=new Date,this.eventParams={},this._create()}setOptions(t){t&&of.selectiveExtend(["moment","locale","locales","id","title","rtl","snap"],this.options,t)}_create(){var t,e,i;const n=document.createElement("div");n["custom-time"]=this,n.className="vis-custom-time ".concat(this.options.id||""),n.style.position="absolute",n.style.top="0px",n.style.height="100%",this.bar=n;const o=document.createElement("div");function s(t){this.body.range._onMouseWheel(t)}o.style.position="relative",o.style.top="0px",this.options.rtl?o.style.right="-10px":o.style.left="-10px",o.style.height="100%",o.style.width="20px",o.addEventListener?(o.addEventListener("mousewheel",Js(s).call(s,this),!1),o.addEventListener("DOMMouseScroll",Js(s).call(s,this),!1)):o.attachEvent("onmousewheel",Js(s).call(s,this)),n.appendChild(o),this.hammer=new yb(o),this.hammer.on("panstart",Js(t=this._onDragStart).call(t,this)),this.hammer.on("panmove",Js(e=this._onDrag).call(e,this)),this.hammer.on("panend",Js(i=this._onDragEnd).call(i,this)),this.hammer.get("pan").set({threshold:5,direction:yb.DIRECTION_ALL}),this.hammer.get("press").set({time:1e4})}destroy(){this.hide(),this.hammer.destroy(),this.hammer=null,this.body=null}redraw(){const t=this.body.dom.backgroundVertical;this.bar.parentNode!=t&&(this.bar.parentNode&&this.bar.parentNode.removeChild(this.bar),t.appendChild(this.bar));const e=this.body.util.toScreen(this.customTime);let i=this.options.locales[this.options.locale];i||(this.warned||(console.warn("WARNING: options.locales['".concat(this.options.locale,"'] not found. See https://visjs.github.io/vis-timeline/docs/timeline/#Localization")),this.warned=!0),i=this.options.locales.en);let n=this.options.title;var o;void 0===n?(n=Of(o="".concat(i.time,": ")).call(o,this.options.moment(this.customTime).format("dddd, MMMM Do YYYY, H:mm:ss")),n=n.charAt(0).toUpperCase()+n.substring(1)):"function"==typeof n&&(n=n.call(this,this.customTime));return this.options.rtl?this.bar.style.right="".concat(e,"px"):this.bar.style.left="".concat(e,"px"),this.bar.title=n,!1}hide(){this.bar.parentNode&&this.bar.parentNode.removeChild(this.bar)}setCustomTime(t){this.customTime=of.convert(t,"Date"),this.redraw()}getCustomTime(){return new Date(this.customTime.valueOf())}setCustomMarker(t,e){var i,n;(this.marker&&this.bar.removeChild(this.marker),this.marker=document.createElement("div"),this.marker.className="vis-custom-time-marker",this.marker.innerHTML=of.xss(t),this.marker.style.position="absolute",e)&&(this.marker.setAttribute("contenteditable","true"),this.marker.addEventListener("pointerdown",function(){this.marker.focus()}),this.marker.addEventListener("input",Js(i=this._onMarkerChange).call(i,this)),this.marker.title=t,this.marker.addEventListener("blur",Js(n=function(t){this.title!=t.target.innerHTML&&(this._onMarkerChanged(t),this.title=t.target.innerHTML)}).call(n,this)));this.bar.appendChild(this.marker)}setCustomTitle(t){this.options.title=t}_onDragStart(t){this.eventParams.dragging=!0,this.eventParams.customTime=this.customTime,t.stopPropagation()}_onDrag(t){if(!this.eventParams.dragging)return;let e=this.options.rtl?-1*t.deltaX:t.deltaX;const i=this.body.util.toScreen(this.eventParams.customTime)+e,n=this.body.util.toTime(i),o=this.body.util.getScale(),s=this.body.util.getStep(),r=this.options.snap,a=r?r(n,o,s):n;this.setCustomTime(a),this.body.emitter.emit("timechange",{id:this.options.id,time:new Date(this.customTime.valueOf()),event:t}),t.stopPropagation()}_onDragEnd(t){this.eventParams.dragging&&(this.body.emitter.emit("timechanged",{id:this.options.id,time:new Date(this.customTime.valueOf()),event:t}),t.stopPropagation())}_onMarkerChange(t){this.body.emitter.emit("markerchange",{id:this.options.id,title:t.target.innerHTML,event:t}),t.stopPropagation()}_onMarkerChanged(t){this.body.emitter.emit("markerchanged",{id:this.options.id,title:t.target.innerHTML,event:t}),t.stopPropagation()}static customTimeFromTarget(t){let e=t.target;for(;e;){if(e.hasOwnProperty("custom-time"))return e["custom-time"];e=e.parentNode}return null}}class iy{_create(t){var e,i,n;this.dom={},this.dom.container=t,this.dom.container.style.position="relative",this.dom.root=document.createElement("div"),this.dom.background=document.createElement("div"),this.dom.backgroundVertical=document.createElement("div"),this.dom.backgroundHorizontal=document.createElement("div"),this.dom.centerContainer=document.createElement("div"),this.dom.leftContainer=document.createElement("div"),this.dom.rightContainer=document.createElement("div"),this.dom.center=document.createElement("div"),this.dom.left=document.createElement("div"),this.dom.right=document.createElement("div"),this.dom.top=document.createElement("div"),this.dom.bottom=document.createElement("div"),this.dom.shadowTop=document.createElement("div"),this.dom.shadowBottom=document.createElement("div"),this.dom.shadowTopLeft=document.createElement("div"),this.dom.shadowBottomLeft=document.createElement("div"),this.dom.shadowTopRight=document.createElement("div"),this.dom.shadowBottomRight=document.createElement("div"),this.dom.rollingModeBtn=document.createElement("div"),this.dom.loadingScreen=document.createElement("div"),this.dom.root.className="vis-timeline",this.dom.background.className="vis-panel vis-background",this.dom.backgroundVertical.className="vis-panel vis-background vis-vertical",this.dom.backgroundHorizontal.className="vis-panel vis-background vis-horizontal",this.dom.centerContainer.className="vis-panel vis-center",this.dom.leftContainer.className="vis-panel vis-left",this.dom.rightContainer.className="vis-panel vis-right",this.dom.top.className="vis-panel vis-top",this.dom.bottom.className="vis-panel vis-bottom",this.dom.left.className="vis-content",this.dom.center.className="vis-content",this.dom.right.className="vis-content",this.dom.shadowTop.className="vis-shadow vis-top",this.dom.shadowBottom.className="vis-shadow vis-bottom",this.dom.shadowTopLeft.className="vis-shadow vis-top",this.dom.shadowBottomLeft.className="vis-shadow vis-bottom",this.dom.shadowTopRight.className="vis-shadow vis-top",this.dom.shadowBottomRight.className="vis-shadow vis-bottom",this.dom.rollingModeBtn.className="vis-rolling-mode-btn",this.dom.loadingScreen.className="vis-loading-screen",this.dom.root.appendChild(this.dom.background),this.dom.root.appendChild(this.dom.backgroundVertical),this.dom.root.appendChild(this.dom.backgroundHorizontal),this.dom.root.appendChild(this.dom.centerContainer),this.dom.root.appendChild(this.dom.leftContainer),this.dom.root.appendChild(this.dom.rightContainer),this.dom.root.appendChild(this.dom.top),this.dom.root.appendChild(this.dom.bottom),this.dom.root.appendChild(this.dom.rollingModeBtn),this.dom.centerContainer.appendChild(this.dom.center),this.dom.leftContainer.appendChild(this.dom.left),this.dom.rightContainer.appendChild(this.dom.right),this.dom.centerContainer.appendChild(this.dom.shadowTop),this.dom.centerContainer.appendChild(this.dom.shadowBottom),this.dom.leftContainer.appendChild(this.dom.shadowTopLeft),this.dom.leftContainer.appendChild(this.dom.shadowBottomLeft),this.dom.rightContainer.appendChild(this.dom.shadowTopRight),this.dom.rightContainer.appendChild(this.dom.shadowBottomRight),this.props={root:{},background:{},centerContainer:{},leftContainer:{},rightContainer:{},center:{},left:{},right:{},top:{},bottom:{},border:{},scrollTop:0,scrollTopMin:0},this.on("rangechange",()=>{!0===this.initialDrawDone&&this._redraw()}),this.on("rangechanged",()=>{this.initialRangeChangeDone||(this.initialRangeChangeDone=!0)}),this.on("touch",Js(e=this._onTouch).call(e,this)),this.on("panmove",Js(i=this._onDrag).call(i,this));const o=this;this._origRedraw=Js(n=this._redraw).call(n,this),this._redraw=of.throttle(this._origRedraw),this.on("_change",t=>{o.itemSet&&o.itemSet.initialItemSetDrawn&&t&&1==t.queue?o._redraw():o._origRedraw()}),this.hammer=new yb(this.dom.root);const s=this.hammer.get("pinch").set({enable:!0});s&&function(t){t.getTouchAction=function(){return["pan-y"]}}(s),this.hammer.get("pan").set({threshold:5,direction:yb.DIRECTION_ALL}),this.timelineListeners={};const r=["tap","doubletap","press","pinch","pan","panstart","panmove","panend"];var a,l;function h(t){this.isActive()&&this.emit("mousewheel",t);let e=0,i=0;if("detail"in t&&(i=-1*t.detail),"wheelDelta"in t&&(i=t.wheelDelta),"wheelDeltaY"in t&&(i=t.wheelDeltaY),"wheelDeltaX"in t&&(e=-1*t.wheelDeltaX),"axis"in t&&t.axis===t.HORIZONTAL_AXIS&&(e=-1*i,i=0),"deltaY"in t&&(i=-1*t.deltaY),"deltaX"in t&&(e=t.deltaX),t.deltaMode&&(1===t.deltaMode?(e*=40,i*=40):(e*=40,i*=800)),this.options.preferZoom){if(!this.options.zoomKey||t[this.options.zoomKey])return}else if(this.options.zoomKey&&t[this.options.zoomKey])return;if(this.options.verticalScroll||this.options.horizontalScroll)if(this.options.verticalScroll&&Math.abs(i)>=Math.abs(e)){const e=this.props.scrollTop,n=e+i;if(this.isActive()){this._setScrollTop(n)!==e&&(this._redraw(),this.emit("scroll",t),t.preventDefault())}}else if(this.options.horizontalScroll){const n=(Math.abs(e)>=Math.abs(i)?e:i)/120*(this.range.end-this.range.start)/20,o=this.range.start+n,s=this.range.end+n,r={animation:!1,byUser:!0,event:t};this.range.setRange(o,s,r),t.preventDefault()}}ua(r).call(r,t=>{const e=e=>{o.isActive()&&o.emit(t,e)};o.hammer.on(t,e),o.timelineListeners[t]=e}),_b(this.hammer,t=>{o.emit("touch",t)}),a=this.hammer,(l=t=>{o.emit("release",t)}).inputHandler=function(t){t.isFinal&&l(t)},a.on("hammer.input",l.inputHandler);const d="onwheel"in document.createElement("div")?"wheel":void 0!==document.onmousewheel?"mousewheel":this.dom.centerContainer.addEventListener?"DOMMouseScroll":"onmousewheel";function c(t){if(o.options.verticalScroll&&(t.preventDefault(),o.isActive())){const e=-t.target.scrollTop;o._setScrollTop(e),o._redraw(),o.emit("scrollSide",t)}}this.dom.top.addEventListener,this.dom.bottom.addEventListener,this.dom.centerContainer.addEventListener(d,Js(h).call(h,this),!1),this.dom.top.addEventListener(d,Js(h).call(h,this),!1),this.dom.bottom.addEventListener(d,Js(h).call(h,this),!1),this.dom.left.parentNode.addEventListener("scroll",Js(c).call(c,this)),this.dom.right.parentNode.addEventListener("scroll",Js(c).call(c,this));let u=!1;function p(t){var e;if(t.preventDefault&&(o.emit("dragover",o.getEventProperties(t)),t.preventDefault()),Bv(e=t.target.className).call(e,"timeline")>-1&&!u)return t.dataTransfer.dropEffect="move",u=!0,!1}function m(t){t.preventDefault&&t.preventDefault(),t.stopPropagation&&t.stopPropagation();try{var e=JSON.parse(t.dataTransfer.getData("text"));if(!e||!e.content)return}catch(t){return!1}return u=!1,t.center={x:t.clientX,y:t.clientY},"item"!==e.target?o.itemSet._onAddItem(t):o.itemSet._onDropObjectOnItem(t),o.emit("drop",o.getEventProperties(t)),!1}if(this.dom.center.addEventListener("dragover",Js(p).call(p,this),!1),this.dom.center.addEventListener("drop",Js(m).call(m,this),!1),this.customTimes=[],this.touch={},this.redrawCount=0,this.initialDrawDone=!1,this.initialRangeChangeDone=!1,!t)throw new Error("No container provided");t.appendChild(this.dom.root),t.appendChild(this.dom.loadingScreen)}setOptions(t){var e;if(t){const e=["width","height","minHeight","maxHeight","autoResize","start","end","clickToUse","dataAttributes","hiddenDates","locale","locales","moment","preferZoom","rtl","zoomKey","horizontalScroll","verticalScroll","longSelectPressTime","snap"];if(of.selectiveExtend(e,this.options,t),this.dom.rollingModeBtn.style.visibility="hidden",this.options.rtl&&(this.dom.container.style.direction="rtl",this.dom.backgroundVertical.className="vis-panel vis-background vis-vertical-rtl"),this.options.verticalScroll&&(this.options.rtl?this.dom.rightContainer.className="vis-panel vis-right vis-vertical-scroll":this.dom.leftContainer.className="vis-panel vis-left vis-vertical-scroll"),"object"!=typeof this.options.orientation&&(this.options.orientation={item:void 0,axis:void 0}),"orientation"in t&&("string"==typeof t.orientation?this.options.orientation={item:t.orientation,axis:t.orientation}:"object"==typeof t.orientation&&("item"in t.orientation&&(this.options.orientation.item=t.orientation.item),"axis"in t.orientation&&(this.options.orientation.axis=t.orientation.axis))),"both"===this.options.orientation.axis){if(!this.timeAxis2){const t=this.timeAxis2=new Fb(this.body,this.options);t.setOptions=e=>{const i=e?of.extend({},e):{};i.orientation="top",Fb.prototype.setOptions.call(t,i)},this.components.push(t)}}else if(this.timeAxis2){var i;const t=Bv(i=this.components).call(i,this.timeAxis2);var n;if(-1!==t)sb(n=this.components).call(n,t,1);this.timeAxis2.destroy(),this.timeAxis2=null}"function"==typeof t.drawPoints&&(t.drawPoints={onRender:t.drawPoints}),"hiddenDates"in this.options&&ov(this.options.moment,this.body,this.options.hiddenDates),"clickToUse"in t&&(t.clickToUse?this.activator||(this.activator=new jb(this.dom.root)):this.activator&&(this.activator.destroy(),delete this.activator)),this._initAutoResize()}if(ua(e=this.components).call(e,e=>e.setOptions(t)),"configure"in t){var o;this.configurator||(this.configurator=this._createConfigurator()),this.configurator.setOptions(t.configure);const e=of.deepExtend({},this.options);ua(o=this.components).call(o,t=>{of.deepExtend(e,t.options)}),this.configurator.setModuleOptions({global:e})}this._redraw()}isActive(){return!this.activator||this.activator.active}destroy(){var t;this.setItems(null),this.setGroups(null),this.off(),this._stopAutoResize(),this.dom.root.parentNode&&this.dom.root.parentNode.removeChild(this.dom.root),this.dom=null,this.activator&&(this.activator.destroy(),delete this.activator);for(const t in this.timelineListeners)this.timelineListeners.hasOwnProperty(t)&&delete this.timelineListeners[t];this.timelineListeners=null,this.hammer&&this.hammer.destroy(),this.hammer=null,ua(t=this.components).call(t,t=>t.destroy()),this.body=null}setCustomTime(t,e){var i;const n=Th(i=this.customTimes).call(i,t=>e===t.options.id);if(0===n.length)throw new Error("No custom time bar found with id ".concat(Wf(e)));n.length>0&&n[0].setCustomTime(t)}getCustomTime(t){var e;const i=Th(e=this.customTimes).call(e,e=>e.options.id===t);if(0===i.length)throw new Error("No custom time bar found with id ".concat(Wf(t)));return i[0].getCustomTime()}setCustomTimeMarker(t,e,i){var n;const o=Th(n=this.customTimes).call(n,t=>t.options.id===e);if(0===o.length)throw new Error("No custom time bar found with id ".concat(Wf(e)));o.length>0&&o[0].setCustomMarker(t,i)}setCustomTimeTitle(t,e){var i;const n=Th(i=this.customTimes).call(i,t=>t.options.id===e);if(0===n.length)throw new Error("No custom time bar found with id ".concat(Wf(e)));if(n.length>0)return n[0].setCustomTitle(t)}getEventProperties(t){return{event:t}}addCustomTime(t,e){var i;const n=void 0!==t?of.convert(t,"Date"):new Date,o=mb(i=this.customTimes).call(i,t=>t.options.id===e);if(o)throw new Error("A custom time with id ".concat(Wf(e)," already exists"));const s=new ey(this.body,of.extend({},this.options,{time:n,id:e,snap:this.itemSet?this.itemSet.options.snap:this.options.snap}));return this.customTimes.push(s),this.components.push(s),this._redraw(),e}removeCustomTime(t){var e;const i=Th(e=this.customTimes).call(e,e=>e.options.id===t);if(0===i.length)throw new Error("No custom time bar found with id ".concat(Wf(t)));ua(i).call(i,t=>{var e,i,n,o;sb(e=this.customTimes).call(e,Bv(i=this.customTimes).call(i,t),1),sb(n=this.components).call(n,Bv(o=this.components).call(o,t),1),t.destroy()})}getVisibleItems(){return this.itemSet&&this.itemSet.getVisibleItems()||[]}getItemsAtCurrentTime(t){return this.time=t,this.itemSet&&this.itemSet.getItemsAtCurrentTime(this.time)||[]}getVisibleGroups(){return this.itemSet&&this.itemSet.getVisibleGroups()||[]}fit(t,e){const i=this.getDataRange();if(null===i.min&&null===i.max)return;const n=i.max-i.min,o=new Date(i.min.valueOf()-.01*n),s=new Date(i.max.valueOf()+.01*n),r=!t||void 0===t.animation||t.animation;this.range.setRange(o,s,{animation:r},e)}getDataRange(){throw new Error("Cannot invoke abstract method getDataRange")}setWindow(t,e,i,n){let o,s;"function"==typeof arguments[2]&&(n=arguments[2],i={}),1==arguments.length?(s=arguments[0],o=void 0===s.animation||s.animation,this.range.setRange(s.start,s.end,{animation:o})):2==arguments.length&&"function"==typeof arguments[1]?(s=arguments[0],n=arguments[1],o=void 0===s.animation||s.animation,this.range.setRange(s.start,s.end,{animation:o},n)):(o=!i||void 0===i.animation||i.animation,this.range.setRange(t,e,{animation:o},n))}moveTo(t,e,i){"function"==typeof arguments[1]&&(i=arguments[1],e={});const n=this.range.end-this.range.start,o=of.convert(t,"Date").valueOf(),s=o-n/2,r=o+n/2,a=!e||void 0===e.animation||e.animation;this.range.setRange(s,r,{animation:a},i)}getWindow(){const t=this.range.getRange();return{start:new Date(t.start),end:new Date(t.end)}}zoomIn(t,e,i){if(!t||t<0||t>1)return;"function"==typeof arguments[1]&&(i=arguments[1],e={});const n=this.getWindow(),o=n.start.valueOf(),s=n.end.valueOf(),r=s-o,a=(r-r/(1+t))/2,l=o+a,h=s-a;this.setWindow(l,h,e,i)}zoomOut(t,e,i){if(!t||t<0||t>1)return;"function"==typeof arguments[1]&&(i=arguments[1],e={});const n=this.getWindow(),o=n.start.valueOf(),s=n.end.valueOf(),r=s-o,a=o-r*t/2,l=s+r*t/2;this.setWindow(a,l,e,i)}redraw(){this._redraw()}_redraw(){var t;this.redrawCount++;const e=this.dom;if(!e||!e.container||0==e.root.offsetWidth)return;let i=!1;const n=this.options,o=this.props;sv(this.options.moment,this.body,this.options.hiddenDates),"top"==n.orientation?(of.addClassName(e.root,"vis-top"),of.removeClassName(e.root,"vis-bottom")):(of.removeClassName(e.root,"vis-top"),of.addClassName(e.root,"vis-bottom")),n.rtl?(of.addClassName(e.root,"vis-rtl"),of.removeClassName(e.root,"vis-ltr")):(of.addClassName(e.root,"vis-ltr"),of.removeClassName(e.root,"vis-rtl")),e.root.style.maxHeight=of.option.asSize(n.maxHeight,""),e.root.style.minHeight=of.option.asSize(n.minHeight,""),e.root.style.width=of.option.asSize(n.width,"");const s=e.root.offsetWidth;o.border.left=1,o.border.right=1,o.border.top=1,o.border.bottom=1,o.center.height=e.center.offsetHeight,o.left.height=e.left.offsetHeight,o.right.height=e.right.offsetHeight,o.top.height=e.top.clientHeight||-o.border.top,o.bottom.height=Math.round(e.bottom.getBoundingClientRect().height)||e.bottom.clientHeight||-o.border.bottom;const r=Math.max(o.left.height,o.center.height,o.right.height),a=o.top.height+r+o.bottom.height+o.border.top+o.border.bottom;e.root.style.height=of.option.asSize(n.height,"".concat(a,"px")),o.root.height=e.root.offsetHeight,o.background.height=o.root.height;const l=o.root.height-o.top.height-o.bottom.height;o.centerContainer.height=l,o.leftContainer.height=l,o.rightContainer.height=o.leftContainer.height,o.root.width=s,o.background.width=o.root.width,this.initialDrawDone||(o.scrollbarWidth=of.getScrollBarWidth());const h=e.leftContainer.clientWidth,d=e.rightContainer.clientWidth;n.verticalScroll?n.rtl?(o.left.width=h||-o.border.left,o.right.width=d+o.scrollbarWidth||-o.border.right):(o.left.width=h+o.scrollbarWidth||-o.border.left,o.right.width=d||-o.border.right):(o.left.width=h||-o.border.left,o.right.width=d||-o.border.right),this._setDOM();let c=this._updateScrollTop();"top"!=n.orientation.item&&(c+=Math.max(o.centerContainer.height-o.center.height-o.border.top-o.border.bottom,0)),e.center.style.transform="translateY(".concat(c,"px)");const u=0==o.scrollTop?"hidden":"",p=o.scrollTop==o.scrollTopMin?"hidden":"";e.shadowTop.style.visibility=u,e.shadowBottom.style.visibility=p,e.shadowTopLeft.style.visibility=u,e.shadowBottomLeft.style.visibility=p,e.shadowTopRight.style.visibility=u,e.shadowBottomRight.style.visibility=p,n.verticalScroll&&(e.rightContainer.className="vis-panel vis-right vis-vertical-scroll",e.leftContainer.className="vis-panel vis-left vis-vertical-scroll",e.shadowTopRight.style.visibility="hidden",e.shadowBottomRight.style.visibility="hidden",e.shadowTopLeft.style.visibility="hidden",e.shadowBottomLeft.style.visibility="hidden",e.left.style.top="0px",e.right.style.top="0px"),(!n.verticalScroll||o.center.height<o.centerContainer.height)&&(e.left.style.top="".concat(c,"px"),e.right.style.top="".concat(c,"px"),e.rightContainer.className=e.rightContainer.className.replace(new RegExp("(?:^|\\s)vis-vertical-scroll(?:\\s|$)")," "),e.leftContainer.className=e.leftContainer.className.replace(new RegExp("(?:^|\\s)vis-vertical-scroll(?:\\s|$)")," "),o.left.width=h||-o.border.left,o.right.width=d||-o.border.right,this._setDOM());const m=o.center.height>o.centerContainer.height;this.hammer.get("pan").set({direction:m?yb.DIRECTION_ALL:yb.DIRECTION_HORIZONTAL}),this.hammer.get("press").set({time:this.options.longSelectPressTime}),ua(t=this.components).call(t,t=>{i=t.redraw()||i});if(i){if(this.redrawCount<5)return void this.body.emitter.emit("_change");console.log("WARNING: infinite loop in redraw?")}else this.redrawCount=0;this.body.emitter.emit("changed")}_setDOM(){const t=this.props,e=this.dom;t.leftContainer.width=t.left.width,t.rightContainer.width=t.right.width;const i=t.root.width-t.left.width-t.right.width;t.center.width=i,t.centerContainer.width=i,t.top.width=i,t.bottom.width=i,e.background.style.height="".concat(t.background.height,"px"),e.backgroundVertical.style.height="".concat(t.background.height,"px"),e.backgroundHorizontal.style.height="".concat(t.centerContainer.height,"px"),e.centerContainer.style.height="".concat(t.centerContainer.height,"px"),e.leftContainer.style.height="".concat(t.leftContainer.height,"px"),e.rightContainer.style.height="".concat(t.rightContainer.height,"px"),e.background.style.width="".concat(t.background.width,"px"),e.backgroundVertical.style.width="".concat(t.centerContainer.width,"px"),e.backgroundHorizontal.style.width="".concat(t.background.width,"px"),e.centerContainer.style.width="".concat(t.center.width,"px"),e.top.style.width="".concat(t.top.width,"px"),e.bottom.style.width="".concat(t.bottom.width,"px"),e.background.style.left="0",e.background.style.top="0",e.backgroundVertical.style.left="".concat(t.left.width+t.border.left,"px"),e.backgroundVertical.style.top="0",e.backgroundHorizontal.style.left="0",e.backgroundHorizontal.style.top="".concat(t.top.height,"px"),e.centerContainer.style.left="".concat(t.left.width,"px"),e.centerContainer.style.top="".concat(t.top.height,"px"),e.leftContainer.style.left="0",e.leftContainer.style.top="".concat(t.top.height,"px"),e.rightContainer.style.left="".concat(t.left.width+t.center.width,"px"),e.rightContainer.style.top="".concat(t.top.height,"px"),e.top.style.left="".concat(t.left.width,"px"),e.top.style.top="0",e.bottom.style.left="".concat(t.left.width,"px"),e.bottom.style.top="".concat(t.top.height+t.centerContainer.height,"px"),e.center.style.left="0",e.left.style.left="0",e.right.style.left="0"}setCurrentTime(t){if(!this.currentTime)throw new Error("Option showCurrentTime must be true");this.currentTime.setCurrentTime(t)}getCurrentTime(){if(!this.currentTime)throw new Error("Option showCurrentTime must be true");return this.currentTime.getCurrentTime()}_toTime(t){return hv(this,t,this.props.center.width)}_toGlobalTime(t){return hv(this,t,this.props.root.width)}_toScreen(t){return lv(this,t,this.props.center.width)}_toGlobalScreen(t){return lv(this,t,this.props.root.width)}_initAutoResize(){1==this.options.autoResize?this._startAutoResize():this._stopAutoResize()}_startAutoResize(){const t=this;this._stopAutoResize(),this._onResize=()=>{if(1==t.options.autoResize){if(t.dom.root){const e=t.dom.root.offsetHeight,i=t.dom.root.offsetWidth;i==t.props.lastWidth&&e==t.props.lastHeight||(t.props.lastWidth=i,t.props.lastHeight=e,t.props.scrollbarWidth=of.getScrollBarWidth(),t.body.emitter.emit("_change"))}}else t._stopAutoResize()},window.addEventListener("resize",this._onResize),t.dom.root&&(t.props.lastWidth=t.dom.root.offsetWidth,t.props.lastHeight=t.dom.root.offsetHeight),this.watchTimer=gb(this._onResize,1e3)}_stopAutoResize(){this.watchTimer&&(clearInterval(this.watchTimer),this.watchTimer=void 0),this._onResize&&(window.removeEventListener("resize",this._onResize),this._onResize=null)}_onTouch(t){this.touch.allowDragging=!0,this.touch.initialScrollTop=this.props.scrollTop}_onPinch(t){this.touch.allowDragging=!1}_onDrag(t){if(!t)return;if(!this.touch.allowDragging)return;const e=t.deltaY,i=this._getScrollTop(),n=this._setScrollTop(this.touch.initialScrollTop+e);this.options.verticalScroll&&(this.dom.left.parentNode.scrollTop=-this.props.scrollTop,this.dom.right.parentNode.scrollTop=-this.props.scrollTop),n!=i&&this.emit("verticalDrag")}_setScrollTop(t){return this.props.scrollTop=t,this._updateScrollTop(),this.props.scrollTop}_updateScrollTop(){const t=Math.min(this.props.centerContainer.height-this.props.border.top-this.props.border.bottom-this.props.center.height,0);return t!=this.props.scrollTopMin&&("top"!=this.options.orientation.item&&(this.props.scrollTop+=t-this.props.scrollTopMin),this.props.scrollTopMin=t),this.props.scrollTop>0&&(this.props.scrollTop=0),this.props.scrollTop<t&&(this.props.scrollTop=t),this.options.verticalScroll&&(this.dom.left.parentNode.scrollTop=-this.props.scrollTop,this.dom.right.parentNode.scrollTop=-this.props.scrollTop),this.props.scrollTop}_getScrollTop(){return this.props.scrollTop}_createConfigurator(){throw new Error("Cannot invoke abstract method _createConfigurator")}}w(iy.prototype);class ny extends mg{constructor(t,e){var i;super(),this.body=t,this.defaultOptions={rtl:!1,showCurrentTime:!0,alignCurrentTime:void 0,moment:ma,locales:ty,locale:"en"},this.options=of.extend({},this.defaultOptions),this.setOptions(e),this.options.locales=of.extend({},ty,this.options.locales);const n=this.defaultOptions.locales[this.defaultOptions.locale];ua(i=fm(this.options.locales)).call(i,t=>{this.options.locales[t]=of.extend({},n,this.options.locales[t])}),this.offset=0,this._create()}_create(){const t=document.createElement("div");t.className="vis-current-time",t.style.position="absolute",t.style.top="0px",t.style.height="100%",this.bar=t}destroy(){this.options.showCurrentTime=!1,this.redraw(),this.body=null}setOptions(t){t&&of.selectiveExtend(["rtl","showCurrentTime","alignCurrentTime","moment","locale","locales"],this.options,t)}redraw(){if(this.options.showCurrentTime){var t,e;const i=this.body.dom.backgroundVertical;this.bar.parentNode!=i&&(this.bar.parentNode&&this.bar.parentNode.removeChild(this.bar),i.appendChild(this.bar),this.start());let n=this.options.moment(rg()+this.offset);this.options.alignCurrentTime&&(n=n.startOf(this.options.alignCurrentTime));const o=this.body.util.toScreen(n);let s=this.options.locales[this.options.locale];s||(this.warned||(console.warn("WARNING: options.locales['".concat(this.options.locale,"'] not found. See https://visjs.github.io/vis-timeline/docs/timeline/#Localization")),this.warned=!0),s=this.options.locales.en);let r=Of(t=Of(e="".concat(s.current," ")).call(e,s.time,": ")).call(t,n.format("dddd, MMMM Do YYYY, H:mm:ss"));r=r.charAt(0).toUpperCase()+r.substring(1),this.options.rtl?this.bar.style.transform="translateX(".concat(-1*o,"px)"):this.bar.style.transform="translateX(".concat(o,"px)"),this.bar.title=r}else this.bar.parentNode&&this.bar.parentNode.removeChild(this.bar),this.stop();return!1}start(){const t=this;!function e(){t.stop();let i=1/t.body.range.conversion(t.body.domProps.center.width).scale/10;i<30&&(i=30),i>1e3&&(i=1e3),t.redraw(),t.body.emitter.emit("currentTimeTick"),t.currentTimeTimer=vr(e,i)}()}stop(){void 0!==this.currentTimeTimer&&(clearTimeout(this.currentTimeTimer),delete this.currentTimeTimer)}setCurrentTime(t){const e=of.convert(t,"Date").valueOf(),i=rg();this.offset=e-i,this.redraw()}getCurrentTime(){return new Date(rg()+this.offset)}}var oy,sy,ry,ay,ly,hy,dy,cy,uy,py={};function my(){if(sy)return oy;sy=1;var t=Ji(),e=Wi(),i=Qi(),n=Hi(),o=Va(),s=ll(),r=jn(),a=Yo(),l=zn(),h=Object.assign,d=Object.defineProperty,c=e([].concat);return oy=!h||n(function(){if(t&&1!==h({b:1},h(d({},"a",{enumerable:!0,get:function(){d(this,"b",{value:3,enumerable:!1})}}),{b:2})).b)return!0;var e={},i={},n=Symbol("assign detection"),s="abcdefghijklmnopqrst";return e[n]=7,s.split("").forEach(function(t){i[t]=t}),7!==h({},e)[n]||o(h({},i)).join("")!==s})?function(e,n){for(var h=a(e),d=arguments.length,u=1,p=s.f,m=r.f;d>u;)for(var f,g=l(arguments[u++]),v=p?c(o(g),p(g)):o(g),b=v.length,y=0;b>y;)f=v[y++],t&&!i(m,g,f)||(h[f]=g[f]);return h}:h,oy}function fy(){return ly?ay:(ly=1,function(){if(ry)return py;ry=1;var t=bs(),e=my();t({target:"Object",stat:!0,arity:2,forced:Object.assign!==e},{assign:e})}(),ay=Un().Object.assign)}function gy(){return dy?hy:(dy=1,hy=fy())}var vy,by,yy,_y,wy,xy,ky,Dy,Sy,Cy=n(uy?cy:(uy=1,cy=gy())),Ty={};function My(){return yy?by:(yy=1,function(){if(vy)return Ty;vy=1;var t=bs(),e=ra().find,i=Gc(),n="find",o=!0;n in[]&&Array(1)[n](function(){o=!1}),t({target:"Array",proto:!0,forced:o},{find:function(t){return e(this,t,arguments.length>1?arguments[1]:void 0)}}),i(n)}(),by=zs()("Array","find"))}function Oy(){if(wy)return _y;wy=1;var t=qn(),e=My(),i=Array.prototype;return _y=function(n){var o=n.find;return n===i||t(i,n)&&o===i.find?e:o},_y}function Ey(){return ky?xy:(ky=1,xy=Oy())}var Py,Ay,Iy,Ny,Ly,Fy,Ry,Yy=n(Sy?Dy:(Sy=1,Dy=Ey()));function jy(){if(Iy)return Ay;Iy=1,Py||(Py=1,bs()({target:"Object",stat:!0,sham:!Ji()},{create:Za()}));var t=Un().Object;return Ay=function(e,i){return t.create(e,i)}}function Hy(){return Ly?Ny:(Ly=1,Ny=jy())}var zy,Gy,Wy,By,Vy,Uy,Xy,qy,Zy,Ky,$y,Jy,Qy,t_,e_,i_,n_,o_,s_,r_,a_,l_,h_,d_,c_,u_,p_,m_,f_,g_=n(Ry?Fy:(Ry=1,Fy=Hy())),v_={},b_={exports:{}};function y_(){return Gy?zy:(Gy=1,zy=Hi()(function(){if("function"==typeof ArrayBuffer){var t=new ArrayBuffer(8);Object.isExtensible(t)&&Object.defineProperty(t,"a",{value:8})}}))}function __(){if(By)return Wy;By=1;var t=Hi(),e=Vn(),i=Bi(),n=y_(),o=Object.isExtensible,s=t(function(){});return Wy=s||n?function(t){return!!e(t)&&((!n||"ArrayBuffer"!==i(t))&&(!o||o(t)))}:o,Wy}function w_(){return Uy?Vy:(Uy=1,Vy=!Hi()(function(){return Object.isExtensible(Object.preventExtensions({}))}))}function x_(){if(Xy)return b_.exports;Xy=1;var t=bs(),e=Wi(),i=Ga(),n=Vn(),o=jo(),s=gs().f,r=Ja(),a=el(),l=__(),h=Ho(),d=w_(),c=!1,u=h("meta"),p=0,m=function(t){s(t,u,{value:{objectID:"O"+p++,weakData:{}}})},f=b_.exports={enable:function(){f.enable=function(){},c=!0;var i=r.f,n=e([].splice),o={};o[u]=1,i(o).length&&(r.f=function(t){for(var e=i(t),o=0,s=e.length;o<s;o++)if(e[o]===u){n(e,o,1);break}return e},t({target:"Object",stat:!0,forced:!0},{getOwnPropertyNames:a.f}))},fastKey:function(t,e){if(!n(t))return"symbol"==typeof t?t:("string"==typeof t?"S":"P")+t;if(!o(t,u)){if(!l(t))return"F";if(!e)return"E";m(t)}return t[u].objectID},getWeakData:function(t,e){if(!o(t,u)){if(!l(t))return!0;if(!e)return!1;m(t)}return t[u].weakData},onFreeze:function(t){return d&&c&&l(t)&&!o(t,u)&&m(t),t}};return i[u]=!0,b_.exports}function k_(){if(Zy)return qy;Zy=1;var t=zo(),e=Wc(),i=t("iterator"),n=Array.prototype;return qy=function(t){return void 0!==t&&(e.Array===t||n[i]===t)},qy}function D_(){if($y)return Ky;$y=1;var t=yr(),e=io(),i=Gn(),n=Wc(),o=zo()("iterator");return Ky=function(s){if(!i(s))return e(s,o)||e(s,"@@iterator")||n[t(s)]},Ky}function S_(){if(Qy)return Jy;Qy=1;var t=Qi(),e=eo(),i=fs(),n=to(),o=D_(),s=TypeError;return Jy=function(r,a){var l=arguments.length<2?o(r):a;if(e(l))return i(t(l,r));throw new s(n(r)+" is not iterable")},Jy}function C_(){if(e_)return t_;e_=1;var t=Qi(),e=fs(),i=io();return t_=function(n,o,s){var r,a;e(n);try{if(!(r=i(n,"return"))){if("throw"===o)throw s;return s}r=t(r,n)}catch(t){a=!0,r=t}if("throw"===o)throw s;if(a)throw r;return e(r),s},t_}function T_(){if(n_)return i_;n_=1;var t=qo(),e=Qi(),i=fs(),n=to(),o=k_(),s=ea(),r=qn(),a=S_(),l=D_(),h=C_(),d=TypeError,c=function(t,e){this.stopped=t,this.result=e},u=c.prototype;return i_=function(p,m,f){var g,v,b,y,_,w,x,k=f&&f.that,D=!(!f||!f.AS_ENTRIES),S=!(!f||!f.IS_RECORD),C=!(!f||!f.IS_ITERATOR),T=!(!f||!f.INTERRUPTED),M=t(m,k),O=function(t){return g&&h(g,"normal"),new c(!0,t)},E=function(t){return D?(i(t),T?M(t[0],t[1],O):M(t[0],t[1])):T?M(t,O):M(t)};if(S)g=p.iterator;else if(C)g=p;else{if(!(v=l(p)))throw new d(n(p)+" is not iterable");if(o(v)){for(b=0,y=s(p);y>b;b++)if((_=E(p[b]))&&r(u,_))return _;return new c(!1)}g=a(p,v)}for(w=S?p.next:g.next;!(x=e(w,g)).done;){try{_=E(x.value)}catch(t){h(g,"throw",t)}if("object"==typeof _&&_&&r(u,_))return _}return new c(!1)},i_}function M_(){if(s_)return o_;s_=1;var t=qn(),e=TypeError;return o_=function(i,n){if(t(n,i))return i;throw new e("Incorrect invocation")},o_}function O_(){if(a_)return r_;a_=1;var t=bs(),e=ji(),i=x_(),n=Hi(),o=vs(),s=T_(),r=M_(),a=Ui(),l=Vn(),h=Gn(),d=El(),c=gs().f,u=ra().forEach,p=Ji(),m=Al(),f=m.set,g=m.getterFor;return r_=function(m,v,b){var y,_=-1!==m.indexOf("Map"),w=-1!==m.indexOf("Weak"),x=_?"set":"add",k=e[m],D=k&&k.prototype,S={};if(p&&a(k)&&(w||D.forEach&&!n(function(){(new k).entries().next()}))){var C=(y=v(function(t,e){f(r(t,C),{type:m,collection:new k}),h(e)||s(e,t[x],{that:t,AS_ENTRIES:_})})).prototype,T=g(m);u(["add","clear","delete","forEach","get","has","set","keys","values","entries"],function(t){var e="add"===t||"set"===t;!(t in D)||w&&"clear"===t||o(C,t,function(i,n){var o=T(this).collection;if(!e&&w&&!l(i))return"get"===t&&void 0;var s=o[t](0===i?0:i,n);return e?this:s})}),w||c(C,"size",{configurable:!0,get:function(){return T(this).collection.size}})}else y=b.getConstructor(v,m,_,x),i.enable();return d(y,m,!1,!0),S[m]=y,t({global:!0,forced:!0},S),w||b.setStrong(y,m,_),y}}function E_(){if(h_)return l_;h_=1;var t=hl();return l_=function(e,i,n){for(var o in i)n&&n.unsafe&&e[o]?e[o]=i[o]:t(e,o,i[o],n);return e}}function P_(){if(c_)return d_;c_=1;var t=Xn(),e=dl(),i=zo(),n=Ji(),o=i("species");return d_=function(i){var s=t(i);n&&s&&!s[o]&&e(s,o,{configurable:!0,get:function(){return this}})}}function A_(){if(p_)return u_;p_=1;var t=Za(),e=dl(),i=E_(),n=qo(),o=M_(),s=Gn(),r=T_(),a=Qc(),l=tu(),h=P_(),d=Ji(),c=x_().fastKey,u=Al(),p=u.set,m=u.getterFor;return u_={getConstructor:function(a,l,h,u){var f=a(function(e,i){o(e,g),p(e,{type:l,index:t(null),first:null,last:null,size:0}),d||(e.size=0),s(i)||r(i,e[u],{that:e,AS_ENTRIES:h})}),g=f.prototype,v=m(l),b=function(t,e,i){var n,o,s=v(t),r=y(t,e);return r?r.value=i:(s.last=r={index:o=c(e,!0),key:e,value:i,previous:n=s.last,next:null,removed:!1},s.first||(s.first=r),n&&(n.next=r),d?s.size++:t.size++,"F"!==o&&(s.index[o]=r)),t},y=function(t,e){var i,n=v(t),o=c(e);if("F"!==o)return n.index[o];for(i=n.first;i;i=i.next)if(i.key===e)return i};return i(g,{clear:function(){for(var e=v(this),i=e.first;i;)i.removed=!0,i.previous&&(i.previous=i.previous.next=null),i=i.next;e.first=e.last=null,e.index=t(null),d?e.size=0:this.size=0},delete:function(t){var e=this,i=v(e),n=y(e,t);if(n){var o=n.next,s=n.previous;delete i.index[n.index],n.removed=!0,s&&(s.next=o),o&&(o.previous=s),i.first===n&&(i.first=o),i.last===n&&(i.last=s),d?i.size--:e.size--}return!!n},forEach:function(t){for(var e,i=v(this),o=n(t,arguments.length>1?arguments[1]:void 0);e=e?e.next:i.first;)for(o(e.value,e.key,this);e&&e.removed;)e=e.previous},has:function(t){return!!y(this,t)}}),i(g,h?{get:function(t){var e=y(this,t);return e&&e.value},set:function(t,e){return b(this,0===t?0:t,e)}}:{add:function(t){return b(this,t=0===t?0:t,t)}}),d&&e(g,"size",{configurable:!0,get:function(){return v(this).size}}),f},setStrong:function(t,e,i){var n=e+" Iterator",o=m(e),s=m(n);a(t,e,function(t,e){p(this,{type:n,target:t,state:o(t),kind:e,last:null})},function(){for(var t=s(this),e=t.kind,i=t.last;i&&i.removed;)i=i.previous;return t.target&&(t.last=i=i?i.next:t.state.first)?l("keys"===e?i.key:"values"===e?i.value:[i.key,i.value],!1):(t.target=null,l(void 0,!0))},i?"entries":"values",!i,!0),h(e)}},u_}function I_(){return f_||(f_=1,m_||(m_=1,O_()("Set",function(t){return function(){return t(this,arguments.length?arguments[0]:void 0)}},A_()))),v_}var N_,L_,F_,R_,Y_,j_,H_,z_,G_,W_,B_,V_,U_,X_,q_,Z_,K_,$_,J_,Q_,tw,ew,iw,nw={};function ow(){if(L_)return N_;L_=1;var t=to(),e=TypeError;return N_=function(i){if("object"==typeof i&&"size"in i&&"has"in i&&"add"in i&&"delete"in i&&"keys"in i)return i;throw new e(t(i)+" is not a set")},N_}function sw(){return R_||(R_=1,F_=function(t,e){return 1===e?function(e,i){return e[t](i)}:function(e,i,n){return e[t](i,n)}}),F_}function rw(){if(j_)return Y_;j_=1;var t=Xn(),e=sw(),i=t("Set"),n=i.prototype;return Y_={Set:i,add:e("add",1),has:e("has",1),remove:e("delete",1),proto:n}}function aw(){if(z_)return H_;z_=1;var t=Qi();return H_=function(e,i,n){for(var o,s,r=n?e:e.iterator,a=e.next;!(o=t(a,r)).done;)if(void 0!==(s=i(o.value)))return s},H_}function lw(){if(W_)return G_;W_=1;var t=aw();return G_=function(e,i,n){return n?t(e.keys(),i,!0):e.forEach(i)},G_}function hw(){if(V_)return B_;V_=1;var t=rw(),e=lw(),i=t.Set,n=t.add;return B_=function(t){var o=new i;return e(t,function(t){n(o,t)}),o},B_}function dw(){return X_||(X_=1,U_=function(t){return t.size}),U_}function cw(){return Z_?q_:(Z_=1,q_=function(t){return{iterator:t,next:t.next,done:!1}})}function uw(){if($_)return K_;$_=1;var t=eo(),e=fs(),i=Qi(),n=Qr(),o=cw(),s="Invalid size",r=RangeError,a=TypeError,l=Math.max,h=function(e,i){this.set=e,this.size=l(i,0),this.has=t(e.has),this.keys=t(e.keys)};return h.prototype={getIterator:function(){return o(e(i(this.keys,this.set)))},includes:function(t){return i(this.has,this.set,t)}},K_=function(t){e(t);var i=+t.size;if(i!=i)throw new a(s);var o=n(i);if(o<0)throw new r(s);return new h(t,o)}}function pw(){if(Q_)return J_;Q_=1;var t=ow(),e=rw(),i=hw(),n=dw(),o=uw(),s=lw(),r=aw(),a=e.has,l=e.remove;return J_=function(e){var h=t(this),d=o(e),c=i(h);return n(h)<=d.size?s(h,function(t){d.includes(t)&&l(c,t)}):r(d.getIterator(),function(t){a(c,t)&&l(c,t)}),c}}function mw(){return ew?tw:(ew=1,tw=function(){return!1})}var fw,gw,vw,bw={};function yw(){if(gw)return fw;gw=1;var t=ow(),e=rw(),i=dw(),n=uw(),o=lw(),s=aw(),r=e.Set,a=e.add,l=e.has;return fw=function(e){var h=t(this),d=n(e),c=new r;return i(h)>d.size?s(d.getIterator(),function(t){l(h,t)&&a(c,t)}):o(h,function(t){d.includes(t)&&a(c,t)}),c}}var _w,ww,xw,kw={};function Dw(){if(ww)return _w;ww=1;var t=ow(),e=rw().has,i=dw(),n=uw(),o=lw(),s=aw(),r=C_();return _w=function(a){var l=t(this),h=n(a);if(i(l)<=h.size)return!1!==o(l,function(t){if(h.includes(t))return!1},!0);var d=h.getIterator();return!1!==s(d,function(t){if(e(l,t))return r(d,"normal",!1)})},_w}var Sw,Cw,Tw,Mw={};function Ow(){if(Cw)return Sw;Cw=1;var t=ow(),e=dw(),i=lw(),n=uw();return Sw=function(o){var s=t(this),r=n(o);return!(e(s)>r.size)&&!1!==i(s,function(t){if(!r.includes(t))return!1},!0)}}var Ew,Pw,Aw,Iw={};function Nw(){if(Pw)return Ew;Pw=1;var t=ow(),e=rw().has,i=dw(),n=uw(),o=aw(),s=C_();return Ew=function(r){var a=t(this),l=n(r);if(i(a)<l.size)return!1;var h=l.getIterator();return!1!==o(h,function(t){if(!e(a,t))return s(h,"normal",!1)})},Ew}var Lw,Fw,Rw,Yw,jw,Hw={};function zw(){if(Fw)return Lw;Fw=1;var t=ow(),e=rw(),i=hw(),n=uw(),o=aw(),s=e.add,r=e.has,a=e.remove;return Lw=function(e){var l=t(this),h=n(e).getIterator(),d=i(l);return o(h,function(t){r(l,t)?a(d,t):s(d,t)}),d}}function Gw(){return Yw?Rw:(Yw=1,Rw=function(t){try{var e=new Set,i={size:0,has:function(){return!0},keys:function(){return Object.defineProperty({},"next",{get:function(){return e.clear(),e.add(4),function(){return{done:!0}}}})}},n=e[t](i);return 1===n.size&&4===n.values().next().value}catch(t){return!1}})}var Ww,Bw,Vw,Uw,Xw,qw,Zw,Kw,$w,Jw={};function Qw(){if(Bw)return Ww;Bw=1;var t=ow(),e=rw().add,i=hw(),n=uw(),o=aw();return Ww=function(s){var r=t(this),a=n(s).getIterator(),l=i(r);return o(a,function(t){e(l,t)}),l},Ww}function tx(){return Xw?Uw:(Xw=1,eu(),I_(),function(){if(iw)return nw;iw=1;var t=bs(),e=pw(),i=Hi();t({target:"Set",proto:!0,real:!0,forced:!mw()("difference",function(t){return 0===t.size})||i(function(){var t={size:1,has:function(){return!0},keys:function(){var t=0;return{next:function(){var i=t++>1;return e.has(1)&&e.clear(),{done:i,value:2}}}}},e=new Set([1,2,3,4]);return 3!==e.difference(t).size})},{difference:e})}(),function(){if(vw)return bw;vw=1;var t=bs(),e=Hi(),i=yw();t({target:"Set",proto:!0,real:!0,forced:!mw()("intersection",function(t){return 2===t.size&&t.has(1)&&t.has(2)})||e(function(){return"3,2"!==String(Array.from(new Set([1,2,3]).intersection(new Set([3,2]))))})},{intersection:i})}(),function(){if(xw)return kw;xw=1;var t=bs(),e=Dw();t({target:"Set",proto:!0,real:!0,forced:!mw()("isDisjointFrom",function(t){return!t})},{isDisjointFrom:e})}(),function(){if(Tw)return Mw;Tw=1;var t=bs(),e=Ow();t({target:"Set",proto:!0,real:!0,forced:!mw()("isSubsetOf",function(t){return t})},{isSubsetOf:e})}(),function(){if(Aw)return Iw;Aw=1;var t=bs(),e=Nw();t({target:"Set",proto:!0,real:!0,forced:!mw()("isSupersetOf",function(t){return!t})},{isSupersetOf:e})}(),function(){if(jw)return Hw;jw=1;var t=bs(),e=zw(),i=Gw();t({target:"Set",proto:!0,real:!0,forced:!mw()("symmetricDifference")||!i("symmetricDifference")},{symmetricDifference:e})}(),function(){if(Vw)return Jw;Vw=1;var t=bs(),e=Qw(),i=Gw();t({target:"Set",proto:!0,real:!0,forced:!mw()("union")||!i("union")},{union:e})}(),$u(),Uw=Un().Set)}function ex(){if(Zw)return qw;Zw=1;var t=tx();return nu(),qw=t}var ix,nx,ox,sx,rx,ax,lx,hx,dx,cx=n($w?Kw:($w=1,Kw=ex())),ux={};function px(){return ox?nx:(ox=1,function(){if(ix)return ux;ix=1;var t=bs(),e=ys(),i=na(),n=Vn(),o=Ha(),s=ea(),r=Bn(),a=Uh(),l=zo(),h=vh(),d=js(),c=h("slice"),u=l("species"),p=Array,m=Math.max;t({target:"Array",proto:!0,forced:!c},{slice:function(t,l){var h,c,f,g=r(this),v=s(g),b=o(t,v),y=o(void 0===l?v:l,v);if(e(g)&&(h=g.constructor,(i(h)&&(h===p||e(h.prototype))||n(h)&&null===(h=h[u]))&&(h=void 0),h===p||void 0===h))return d(g,b,y);for(c=new(void 0===h?p:h)(m(y-b,0)),f=0;b<y;b++,f++)b in g&&a(c,f,g[b]);return c.length=f,c}})}(),nx=zs()("Array","slice"))}function mx(){if(rx)return sx;rx=1;var t=qn(),e=px(),i=Array.prototype;return sx=function(n){var o=n.slice;return n===i||t(i,n)&&o===i.slice?e:o},sx}function fx(){return lx?ax:(lx=1,ax=mx())}var gx,vx,bx,yx=n(dx?hx:(dx=1,hx=fx())),_x={};function wx(){return bx?vx:(bx=1,function(){if(gx)return _x;gx=1;var t=bs(),e=za().includes,i=Hi(),n=Gc();t({target:"Array",proto:!0,forced:i(function(){return!Array(1).includes()})},{includes:function(t){return e(this,t,arguments.length>1?arguments[1]:void 0)}}),n("includes")}(),vx=zs()("Array","includes"))}var xx,kx,Dx,Sx,Cx,Tx,Mx,Ox,Ex,Px,Ax,Ix,Nx,Lx,Fx,Rx={};function Yx(){if(kx)return xx;kx=1;var t=Vn(),e=Bi(),i=zo()("match");return xx=function(n){var o;return t(n)&&(void 0!==(o=n[i])?!!o:"RegExp"===e(n))},xx}function jx(){if(Sx)return Dx;Sx=1;var t=Yx(),e=TypeError;return Dx=function(i){if(t(i))throw new e("The method doesn't accept regular expressions");return i},Dx}function Hx(){if(Tx)return Cx;Tx=1;var t=zo()("match");return Cx=function(e){var i=/./;try{"/./"[e](i)}catch(n){try{return i[t]=!1,"/./"[e](i)}catch(t){}}return!1}}function zx(){return Ex?Ox:(Ex=1,function(){if(Mx)return Rx;Mx=1;var t=bs(),e=Wi(),i=jx(),n=Wn(),o=ya(),s=Hx(),r=e("".indexOf);t({target:"String",proto:!0,forced:!s("includes")},{includes:function(t){return!!~r(o(n(this)),o(i(t)),arguments.length>1?arguments[1]:void 0)}})}(),Ox=zs()("String","includes"))}function Gx(){if(Ax)return Px;Ax=1;var t=qn(),e=wx(),i=zx(),n=Array.prototype,o=String.prototype;return Px=function(s){var r=s.includes;return s===n||t(n,s)&&r===n.includes?e:"string"==typeof s||s===o||t(o,s)&&r===o.includes?i:r},Px}function Wx(){return Nx?Ix:(Nx=1,Ix=Gx())}var Bx,Vx,Ux,Xx,qx,Zx,Kx,$x,Jx,Qx=n(Fx?Lx:(Fx=1,Lx=Wx())),tk={};function ek(){if(Vx)return Bx;Vx=1;var t=Ji(),e=Hi(),i=Wi(),n=Uc(),o=Va(),s=Bn(),r=i(jn().f),a=i([].push),l=t&&e(function(){var t=Object.create(null);return t[2]=2,!r(t,2)}),h=function(e){return function(i){for(var h,d=s(i),c=o(d),u=l&&null===n(d),p=c.length,m=0,f=[];p>m;)h=c[m++],t&&!(u?h in d:r(d,h))||a(f,e?[h,d[h]]:d[h]);return f}};return Bx={entries:h(!0),values:h(!1)}}function ik(){return qx?Xx:(qx=1,function(){if(Ux)return tk;Ux=1;var t=bs(),e=ek().values;t({target:"Object",stat:!0},{values:function(t){return e(t)}})}(),Xx=Un().Object.values)}function nk(){return Kx?Zx:(Kx=1,Zx=ik())}var ok,sk,rk,ak,lk,hk,dk,ck,uk,pk=n(Jx?$x:(Jx=1,$x=nk())),mk={};function fk(){return rk?sk:(rk=1,function(){if(ok)return mk;ok=1;var t=bs(),e=ra().findIndex,i=Gc(),n="findIndex",o=!0;n in[]&&Array(1)[n](function(){o=!1}),t({target:"Array",proto:!0,forced:o},{findIndex:function(t){return e(this,t,arguments.length>1?arguments[1]:void 0)}}),i(n)}(),sk=zs()("Array","findIndex"))}function gk(){if(lk)return ak;lk=1;var t=qn(),e=fk(),i=Array.prototype;return ak=function(n){var o=n.findIndex;return n===i||t(i,n)&&o===i.findIndex?e:o},ak}function vk(){return dk?hk:(dk=1,hk=gk())}var bk=n(uk?ck:(uk=1,ck=vk()));const yk=.001;function _k(t){nv(t).call(t,(t,e)=>t.data.start-e.data.start)}function wk(t){nv(t).call(t,(t,e)=>("end"in t.data?t.data.end:t.data.start)-("end"in e.data?e.data.end:e.data.start))}function xk(t,e,i,n){return null===Tk(t,e.item,!1,t=>t.stack&&(i||null===t.top),t=>t.stack,t=>e.axis,n)}function kk(t,e,i){const n=Tk(t,e.item,!1,t=>t.stack,t=>!0,t=>t.baseTop);i.height=n-i.top+.5*e.item.vertical}function Dk(t,e,i,n){for(let o=0;o<t.length;o++)if(null==t[o].data.subgroup)t[o].top=e.item.vertical;else if(void 0!==t[o].data.subgroup&&n){let n=0;for(const e in i)i.hasOwnProperty(e)&&1==i[e].visible&&i[e].index<i[t[o].data.subgroup].index&&(n+=i[e].height,i[t[o].data.subgroup].top=n);t[o].top=n+.5*e.item.vertical}n||Sk(t,e,i)}function Sk(t,e,i){var n;Tk(nv(n=pk(i)).call(n,(t,e)=>t.index>e.index?1:t.index<e.index?-1:0),{vertical:0},!0,t=>!0,t=>!0,t=>0);for(let n=0;n<t.length;n++)void 0!==t[n].data.subgroup&&(t[n].top=i[t[n].data.subgroup].top+.5*e.item.vertical)}function Ck(t,e,i){let n=!1;const o=[];for(var s in i)i[s].hasOwnProperty("index")?o[i[s].index]=s:o.push(s);for(let r=0;r<o.length;r++)if(s=o[r],i.hasOwnProperty(s)){n=n||i[s].stack,i[s].top=0;for(const t in i)i[t].visible&&i[s].index>i[t].index&&(i[s].top+=i[t].height);const o=t[s];for(let t=0;t<o.length;t++)void 0!==o[t].data.subgroup&&(o[t].top=i[o[t].data.subgroup].top+.5*e.item.vertical,i[s].stack&&(o[t].baseTop=o[t].top));n&&i[s].stack&&kk(t[s],e,i[s])}}function Tk(t,e,i,n,o,s,r){let a=t=>t.start,l=t=>t.end;if(!i){const i=!(!t[0]||!t[0].options.rtl);a=i?t=>t.right:t=>t.left,l=t=>a(t)+t.width+e.horizontal}const h=[],d=[];let c=null,u=0;for(const e of t)if(n(e))h.push(e);else if(o(e)){const t=a(e);null!==c&&t<c-yk&&(u=0),c=t,u=Ok(d,e=>a(e)-yk>t,u),sb(d).call(d,u,0,e),u++}c=null;let p=null;u=0;let m=0,f=0,g=0;for(;h.length>0;){var v,b;const t=h.shift();t.top=s(t);const i=a(t),n=l(t);null!==c&&i<c-yk&&(m=0,f=0,u=0,p=null),c=i,m=Ok(d,t=>i<l(t)-yk,m),(null===p||p<n-yk)&&(f=Ok(d,t=>n<a(t)-yk,Math.max(m,f))),null!==p&&p-yk>n&&(f=Ek(d,t=>n+yk>=a(t),m,f)+1);const y=nv(v=Th(b=yx(d).call(d,m,f)).call(b,t=>i<l(t)-yk&&n-yk>a(t))).call(v,(t,e)=>t.top-e.top);for(let i=0;i<y.length;i++){const n=y[i];Mk(t,n,e)&&(t.top=n.top+n.height+e.vertical)}o(t)&&(u=Ok(d,t=>a(t)-yk>i,u),sb(d).call(d,u,0,t),u++);const _=t.top+t.height;if(_>g&&(g=_),r&&r())return null}return g}function Mk(t,e,i){return t.top-i.vertical+yk<e.top+e.height&&t.top+t.height+i.vertical-yk>e.top}function Ok(t,e,i){var n;i||(i=0);const o=bk(n=yx(t).call(t,i)).call(n,e);return-1===o?t.length:o+i}function Ek(t,e,n,o){for(n||(n=0),o||(o=t.length),i=o-1;i>=n;i--)if(e(t[i]))return i;return n-1}var Pk=Object.freeze({__proto__:null,nostack:Dk,orderByEnd:wk,orderByStart:_k,stack:xk,stackSubgroups:Sk,stackSubgroupsWithInnerStack:Ck,substack:kk});const Ak="__background__";class Ik{constructor(t,e,i){if(this.groupId=t,this.subgroups={},this.subgroupStack={},this.subgroupStackAll=!1,this.subgroupVisibility={},this.doInnerStack=!1,this.shouldBailStackItems=!1,this.subgroupIndex=0,this.subgroupOrderer=e&&e.subgroupOrder,this.itemSet=i,this.isVisible=null,this.stackDirty=!0,this._disposeCallbacks=[],e&&e.nestedGroups&&(this.nestedGroups=e.nestedGroups,0==e.showNested?this.showNested=!1:this.showNested=!0),e&&e.subgroupStack)if("boolean"==typeof e.subgroupStack)this.doInnerStack=e.subgroupStack,this.subgroupStackAll=e.subgroupStack;else for(const t in e.subgroupStack)this.subgroupStack[t]=e.subgroupStack[t],this.doInnerStack=this.doInnerStack||e.subgroupStack[t];e&&e.heightMode?this.heightMode=e.heightMode:this.heightMode=i.options.groupHeightMode,this.nestedInGroup=null,this.dom={},this.props={label:{width:0,height:0}},this.className=null,this.items={},this.visibleItems=[],this.itemsInRange=[],this.orderedItems={byStart:[],byEnd:[]},this.checkRangedItems=!1;const n=()=>{this.checkRangedItems=!0};this.itemSet.body.emitter.on("checkRangedItems",n),this._disposeCallbacks.push(()=>{this.itemSet.body.emitter.off("checkRangedItems",n)}),this._create(),this.setData(e)}_create(){const t=document.createElement("div");this.itemSet.options.groupEditable.order?t.className="vis-label draggable":t.className="vis-label",this.dom.label=t;const e=document.createElement("div");e.className="vis-inner",t.appendChild(e),this.dom.inner=e;const i=document.createElement("div");i.className="vis-group",i["vis-group"]=this,this.dom.foreground=i,this.dom.background=document.createElement("div"),this.dom.background.className="vis-group",this.dom.axis=document.createElement("div"),this.dom.axis.className="vis-group",this.dom.marker=document.createElement("div"),this.dom.marker.style.visibility="hidden",this.dom.marker.style.position="absolute",this.dom.marker.innerHTML="",this.dom.background.appendChild(this.dom.marker)}setData(t){if(this.itemSet.groupTouchParams.isDragging)return;let e,i;if(t&&t.subgroupVisibility)for(const e in t.subgroupVisibility)this.subgroupVisibility[e]=t.subgroupVisibility[e];var n;this.itemSet.options&&this.itemSet.options.groupTemplate?(i=Js(n=this.itemSet.options.groupTemplate).call(n,this),e=i(t,this.dom.inner)):e=t&&t.content;if(e instanceof Element){for(;this.dom.inner.firstChild;)this.dom.inner.removeChild(this.dom.inner.firstChild);this.dom.inner.appendChild(e)}else e instanceof Object&&e.isReactComponent||(e instanceof Object?i(t,this.dom.inner):this.dom.inner.innerHTML=null!=e?of.xss(e):of.xss(this.groupId||""));this.dom.label.title=t&&t.title||"",this.dom.inner.firstChild?of.removeClassName(this.dom.inner,"vis-hidden"):of.addClassName(this.dom.inner,"vis-hidden"),t&&t.nestedGroups?(this.nestedGroups&&this.nestedGroups==t.nestedGroups||(this.nestedGroups=t.nestedGroups),void 0===t.showNested&&void 0!==this.showNested||(0==t.showNested?this.showNested=!1:this.showNested=!0),of.addClassName(this.dom.label,"vis-nesting-group"),this.showNested?(of.removeClassName(this.dom.label,"collapsed"),of.addClassName(this.dom.label,"expanded")):(of.removeClassName(this.dom.label,"expanded"),of.addClassName(this.dom.label,"collapsed"))):this.nestedGroups&&(this.nestedGroups=null,of.removeClassName(this.dom.label,"collapsed"),of.removeClassName(this.dom.label,"expanded"),of.removeClassName(this.dom.label,"vis-nesting-group")),t&&(t.treeLevel||t.nestedInGroup)?(of.addClassName(this.dom.label,"vis-nested-group"),t.treeLevel?of.addClassName(this.dom.label,"vis-group-level-"+t.treeLevel):of.addClassName(this.dom.label,"vis-group-level-unknown-but-gte1")):of.addClassName(this.dom.label,"vis-group-level-0");const o=t&&t.className||null;o!=this.className&&(this.className&&(of.removeClassName(this.dom.label,this.className),of.removeClassName(this.dom.foreground,this.className),of.removeClassName(this.dom.background,this.className),of.removeClassName(this.dom.axis,this.className)),of.addClassName(this.dom.label,o),of.addClassName(this.dom.foreground,o),of.addClassName(this.dom.background,o),of.addClassName(this.dom.axis,o),this.className=o),this.style&&(of.removeCssText(this.dom.label,this.style),this.style=null),t&&t.style&&(of.addCssText(this.dom.label,t.style),this.style=t.style)}getLabelWidth(){return this.props.label.width}_didMarkerHeightChange(){const t=this.dom.marker.clientHeight;if(t!=this.lastMarkerHeight){this.lastMarkerHeight=t;const e={};let i=0;ua(of).call(of,this.items,(t,n)=>{if(t.dirty=!0,t.displayed){const o=!0;e[n]=t.redraw(o),i=e[n].length}});if(i>0)for(let t=0;t<i;t++)ua(of).call(of,e,e=>{e[t]()});return!0}return!1}_calculateGroupSizeAndPosition(){const{offsetTop:t,offsetLeft:e,offsetWidth:i}=this.dom.foreground;this.top=t,this.right=e,this.width=i}_shouldBailItemsRedraw(){const t=this,e=this.itemSet.options.onTimeout,i={relativeBailingTime:this.itemSet.itemsSettingTime,bailTimeMs:e&&e.timeoutMs,userBailFunction:e&&e.callback,shouldBailStackItems:this.shouldBailStackItems};let n=null;if(!this.itemSet.initialDrawDone){if(i.shouldBailStackItems)return!0;Math.abs(rg()-new Date(i.relativeBailingTime))>i.bailTimeMs&&(i.userBailFunction&&null==this.itemSet.userContinueNotBail?i.userBailFunction(e=>{t.itemSet.userContinueNotBail=e,n=!e}):n=0==t.itemSet.userContinueNotBail)}return n}_redrawItems(t,e,i,n){if(t||this.stackDirty||this.isVisible&&!e){var o,s,r,a,l,h;const t={byEnd:Th(o=this.orderedItems.byEnd).call(o,t=>!t.isCluster),byStart:Th(s=this.orderedItems.byStart).call(s,t=>!t.isCluster)},e={byEnd:[...new cx(Th(r=Zp(a=this.orderedItems.byEnd).call(a,t=>t.cluster)).call(r,t=>!!t))],byStart:[...new cx(Th(l=Zp(h=this.orderedItems.byStart).call(h,t=>t.cluster)).call(l,t=>!!t))]},f=()=>{var i,o;return[...this._updateItemsInRange(t,Th(i=this.visibleItems).call(i,t=>!t.isCluster),n),...this._updateClustersInRange(e,Th(o=this.visibleItems).call(o,t=>t.isCluster),n)]},g=t=>{let e={};for(const n in this.subgroups){var i;const o=Th(i=this.visibleItems).call(i,t=>t.data.subgroup===n);e[n]=t?nv(o).call(o,(e,i)=>t(e.data,i.data)):o}return e};if("function"==typeof this.itemSet.options.order){const t=this;if(this.doInnerStack&&this.itemSet.options.stackSubgroups){Ck(g(this.itemSet.options.order),i,this.subgroups),this.visibleItems=f(),this._updateSubGroupHeights(i)}else{var d,c,u,p;this.visibleItems=f(),this._updateSubGroupHeights(i);const e=nv(d=Th(c=yx(u=this.visibleItems).call(u)).call(c,t=>t.isCluster||!t.isCluster&&!t.cluster)).call(d,(e,i)=>t.itemSet.options.order(e.data,i.data));this.shouldBailStackItems=xk(e,i,!0,Js(p=this._shouldBailItemsRedraw).call(p,this))}}else if(this.visibleItems=f(),this._updateSubGroupHeights(i),this.itemSet.options.stack)if(this.doInnerStack&&this.itemSet.options.stackSubgroups){Ck(g(),i,this.subgroups)}else{var m;this.shouldBailStackItems=xk(this.visibleItems,i,!0,Js(m=this._shouldBailItemsRedraw).call(m,this))}else Dk(this.visibleItems,i,this.subgroups,this.itemSet.options.stackSubgroups);for(let t=0;t<this.visibleItems.length;t++)this.visibleItems[t].repositionX(),void 0!==this.subgroupVisibility[this.visibleItems[t].data.subgroup]&&(this.subgroupVisibility[this.visibleItems[t].data.subgroup]||this.visibleItems[t].hide());this.itemSet.options.cluster&&ua(of).call(of,this.items,t=>{t.cluster&&t.displayed&&t.hide()}),this.shouldBailStackItems&&this.itemSet.body.emitter.emit("destroyTimeline"),this.stackDirty=!1}}_didResize(t,e){t=of.updateProperty(this,"height",e)||t;const i=this.dom.inner.clientWidth,n=this.dom.inner.clientHeight;return t=of.updateProperty(this.props.label,"width",i)||t,t=of.updateProperty(this.props.label,"height",n)||t}_applyGroupHeight(t){this.dom.background.style.height="".concat(t,"px"),this.dom.foreground.style.height="".concat(t,"px"),this.dom.label.style.height="".concat(t,"px")}_updateItemsVerticalPosition(t){for(let e=0,i=this.visibleItems.length;e<i;e++){const i=this.visibleItems[e];i.repositionY(t),this.isVisible||this.groupId==Ak||i.displayed&&i.hide()}}redraw(t,e,i,n){var o,s,r,a,l;let h=!1;const d=this.isVisible;let c;const u=[()=>{i=this._didMarkerHeightChange.call(this)||i},Js(o=this._updateSubGroupHeights).call(o,this,e),Js(s=this._calculateGroupSizeAndPosition).call(s,this),()=>{var i;this.isVisible=Js(i=this._isGroupVisible).call(i,this)(t,e)},()=>{var n;Js(n=this._redrawItems).call(n,this)(i,d,e,t)},Js(r=this._updateSubgroupsSizes).call(r,this),()=>{var t;c=Js(t=this._calculateHeight).call(t,this)(e)},Js(a=this._calculateGroupSizeAndPosition).call(a,this),()=>{var t;h=Js(t=this._didResize).call(t,this)(h,c)},()=>{var t;Js(t=this._applyGroupHeight).call(t,this)(c)},()=>{var t;Js(t=this._updateItemsVerticalPosition).call(t,this)(e)},Js(l=()=>(!this.isVisible&&this.height&&(h=!1),h)).call(l,this)];if(n)return u;{let t;return ua(u).call(u,e=>{t=e()}),t}}_updateSubGroupHeights(t){if(fm(this.subgroups).length>0){const e=this;this._resetSubgroups(),ua(of).call(of,this.visibleItems,i=>{void 0!==i.data.subgroup&&(e.subgroups[i.data.subgroup].height=Math.max(e.subgroups[i.data.subgroup].height,i.height+t.item.vertical),e.subgroups[i.data.subgroup].visible=void 0===this.subgroupVisibility[i.data.subgroup]||Boolean(this.subgroupVisibility[i.data.subgroup]))})}}_isGroupVisible(t,e){return this.top<=t.body.domProps.centerContainer.height-t.body.domProps.scrollTop+e.axis&&this.top+this.height+e.axis>=-t.body.domProps.scrollTop}_calculateHeight(t){let e,i;if(i="fixed"===this.heightMode?of.toArray(this.items):this.visibleItems,i.length>0){let n=i[0].top,o=i[0].top+i[0].height;if(ua(of).call(of,i,t=>{n=Math.min(n,t.top),o=Math.max(o,t.top+t.height)}),n>t.axis){const e=n-t.axis;o-=e,ua(of).call(of,i,t=>{t.top-=e})}e=Math.ceil(o+t.item.vertical/2),"fitItems"!==this.heightMode&&(e=Math.max(e,this.props.label.height))}else e=this.props.label.height;return e}show(){this.dom.label.parentNode||this.itemSet.dom.labelSet.appendChild(this.dom.label),this.dom.foreground.parentNode||this.itemSet.dom.foreground.appendChild(this.dom.foreground),this.dom.background.parentNode||this.itemSet.dom.background.appendChild(this.dom.background),this.dom.axis.parentNode||this.itemSet.dom.axis.appendChild(this.dom.axis)}hide(){const t=this.dom.label;t.parentNode&&t.parentNode.removeChild(t);const e=this.dom.foreground;e.parentNode&&e.parentNode.removeChild(e);const i=this.dom.background;i.parentNode&&i.parentNode.removeChild(i);const n=this.dom.axis;n.parentNode&&n.parentNode.removeChild(n)}add(t){var e;if(this.items[t.id]=t,t.setParent(this),this.stackDirty=!0,void 0!==t.data.subgroup&&(this._addToSubgroup(t),this.orderSubgroups()),!Qx(e=this.visibleItems).call(e,t)){const e=this.itemSet.body.range;this._checkIfVisible(t,this.visibleItems,e)}}_addToSubgroup(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:t.data.subgroup;null!=e&&void 0===this.subgroups[e]&&(this.subgroups[e]={height:0,top:0,start:t.data.start,end:t.data.end||t.data.start,visible:!1,index:this.subgroupIndex,items:[],stack:this.subgroupStackAll||this.subgroupStack[e]||!1},this.subgroupIndex++),new Date(t.data.start)<new Date(this.subgroups[e].start)&&(this.subgroups[e].start=t.data.start);const i=t.data.end||t.data.start;new Date(i)>new Date(this.subgroups[e].end)&&(this.subgroups[e].end=i),this.subgroups[e].items.push(t)}_updateSubgroupsSizes(){const t=this;if(t.subgroups)for(const i in t.subgroups){var e;const n=t.subgroups[i].items[0].data.end||t.subgroups[i].items[0].data.start;let o=t.subgroups[i].items[0].data.start,s=n-1;ua(e=t.subgroups[i].items).call(e,t=>{new Date(t.data.start)<new Date(o)&&(o=t.data.start);const e=t.data.end||t.data.start;new Date(e)>new Date(s)&&(s=e)}),t.subgroups[i].start=o,t.subgroups[i].end=new Date(s-1)}}orderSubgroups(){if(void 0!==this.subgroupOrderer){const t=[];if("string"==typeof this.subgroupOrderer){for(const e in this.subgroups)t.push({subgroup:e,sortField:this.subgroups[e].items[0].data[this.subgroupOrderer]});nv(t).call(t,(t,e)=>t.sortField-e.sortField)}else if("function"==typeof this.subgroupOrderer){for(const e in this.subgroups)t.push(this.subgroups[e].items[0].data);nv(t).call(t,this.subgroupOrderer)}if(t.length>0)for(let e=0;e<t.length;e++)this.subgroups[t[e].subgroup].index=e}}_resetSubgroups(){for(const t in this.subgroups)this.subgroups.hasOwnProperty(t)&&(this.subgroups[t].visible=!1,this.subgroups[t].height=0)}remove(t){var e,i;delete this.items[t.id],t.setParent(null),this.stackDirty=!0;const n=Bv(e=this.visibleItems).call(e,t);-1!=n&&sb(i=this.visibleItems).call(i,n,1),void 0!==t.data.subgroup&&(this._removeFromSubgroup(t),this.orderSubgroups())}_removeFromSubgroup(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:t.data.subgroup;if(null!=e){const o=this.subgroups[e];if(o){var i;const s=Bv(i=o.items).call(i,t);var n;if(s>=0)sb(n=o.items).call(n,s,1),o.items.length?this._updateSubgroupsSizes():delete this.subgroups[e]}}}removeFromDataSet(t){this.itemSet.removeItem(t.id)}order(){const t=of.toArray(this.items),e=[],i=[];for(let n=0;n<t.length;n++)void 0!==t[n].data.end&&i.push(t[n]),e.push(t[n]);this.orderedItems={byStart:e,byEnd:i},_k(this.orderedItems.byStart),wk(this.orderedItems.byEnd)}_updateItemsInRange(t,e,i){const n=[],o={};if(!this.isVisible&&void 0!==this.height&&this.groupId!=Ak){for(let t=0;t<e.length;t++){var s=e[t];s.displayed&&s.hide()}return n}const r=(i.end-i.start)/4,a=i.start-r,l=i.end+r,h=t=>{const{start:e,end:i}=t;return i<a?-1:e<=l?0:1};if(e.length>0)for(let t=0;t<e.length;t++)this._checkIfVisibleWithReference(e[t],n,o,i);const d=of.binarySearchCustom(t.byStart,t=>t<a?-1:t<=l?0:1,"data","start");if(this._traceVisible(d,t.byStart,n,o,t=>t.data.start<a||t.data.start>l),1==this.checkRangedItems){this.checkRangedItems=!1;for(let e=0;e<t.byEnd.length;e++)this._checkIfVisibleWithReference(t.byEnd[e],n,o,i)}else{const e=of.binarySearchCustom(t.byEnd,h,"data");this._traceVisible(e,t.byEnd,n,o,t=>t.data.end<a||t.data.start>l)}const c={};let u=0;for(let t=0;t<n.length;t++){const e=n[t];if(!e.displayed){const i=!0;c[t]=e.redraw(i),u=c[t].length}}if(u>0)for(let t=0;t<u;t++)ua(of).call(of,c,e=>{e[t]()});for(let t=0;t<n.length;t++)n[t].repositionX();return n}_traceVisible(t,e,i,n,o){if(-1!=t){for(let s=t;s>=0;s--){let t=e[s];if(o(t))break;t.isCluster&&!t.hasItems()||t.cluster||void 0===n[t.id]&&(n[t.id]=!0,i.push(t))}for(let s=t+1;s<e.length;s++){let t=e[s];if(o(t))break;t.isCluster&&!t.hasItems()||t.cluster||void 0===n[t.id]&&(n[t.id]=!0,i.push(t))}}}_checkIfVisible(t,e,i){t.isVisible(i)?(t.displayed||t.show(),t.repositionX(),e.push(t)):t.displayed&&t.hide()}_checkIfVisibleWithReference(t,e,i,n){t.isVisible(n)?void 0===i[t.id]&&(i[t.id]=!0,e.push(t)):t.displayed&&t.hide()}_updateClustersInRange(t,e,i){const n=[],o={};if(e.length>0)for(let t=0;t<e.length;t++)this._checkIfVisibleWithReference(e[t],n,o,i);for(let e=0;e<t.byStart.length;e++)this._checkIfVisibleWithReference(t.byStart[e],n,o,i);for(let e=0;e<t.byEnd.length;e++)this._checkIfVisibleWithReference(t.byEnd[e],n,o,i);const s={};let r=0;for(let t=0;t<n.length;t++){const e=n[t];if(!e.displayed){const i=!0;s[t]=e.redraw(i),r=s[t].length}}if(r>0)for(var a=0;a<r;a++)ua(of).call(of,s,function(t){t[a]()});for(let t=0;t<n.length;t++)n[t].repositionX();return n}changeSubgroup(t,e,i){this._removeFromSubgroup(t,e),this._addToSubgroup(t,i),this.orderSubgroups()}dispose(){let t;for(this.hide();t=this._disposeCallbacks.pop();)t()}}class Nk extends Ik{constructor(t,e,i){super(t,e,i),this.width=0,this.height=0,this.top=0,this.left=0}redraw(t,e,i){this.visibleItems=this._updateItemsInRange(this.orderedItems,this.visibleItems,t),this.width=this.dom.background.offsetWidth,this.dom.background.style.height="0";for(let t=0,i=this.visibleItems.length;t<i;t++){this.visibleItems[t].repositionY(e)}return!1}show(){this.dom.background.parentNode||this.itemSet.dom.background.appendChild(this.dom.background)}}class Lk{constructor(t,e,i){var n;this.id=null,this.parent=null,this.data=t,this.dom=null,this.conversion=e||{},this.defaultOptions={locales:ty,locale:"en"},this.options=of.extend({},this.defaultOptions,i),this.options.locales=of.extend({},ty,this.options.locales);const o=this.defaultOptions.locales[this.defaultOptions.locale];ua(n=fm(this.options.locales)).call(n,t=>{this.options.locales[t]=of.extend({},o,this.options.locales[t])}),this.selected=!1,this.displayed=!1,this.groupShowing=!0,this.selectable=i&&i.selectable||!1,this.dirty=!0,this.top=null,this.right=null,this.left=null,this.width=null,this.height=null,this.setSelectability(t),this.editable=null,this._updateEditStatus()}select(){this.selectable&&(this.selected=!0,this.dirty=!0,this.displayed&&this.redraw())}unselect(){this.selected=!1,this.dirty=!0,this.displayed&&this.redraw()}setData(t){null!=t.group&&this.data.group!=t.group&&null!=this.parent&&this.parent.itemSet._moveToGroup(this,t.group),this.setSelectability(t),this.parent&&(this.parent.stackDirty=!0);null!=t.subgroup&&this.data.subgroup!=t.subgroup&&null!=this.parent&&this.parent.changeSubgroup(this,this.data.subgroup,t.subgroup),this.data=t,this._updateEditStatus(),this.dirty=!0,this.displayed&&this.redraw()}setSelectability(t){t&&(this.selectable=void 0===t.selectable||Boolean(t.selectable))}setParent(t){this.displayed?(this.hide(),this.parent=t,this.parent&&this.show()):this.parent=t}isVisible(t){return!1}show(){return!1}hide(){return!1}redraw(){}repositionX(){}repositionY(){}_repaintDragCenter(){if(this.selected&&this.editable.updateTime&&!this.dom.dragCenter){var t,e;const i=this,n=document.createElement("div");n.className="vis-drag-center",n.dragCenterItem=this,this.hammerDragCenter=new yb(n),this.hammerDragCenter.on("tap",t=>{i.parent.itemSet.body.emitter.emit("click",{event:t,item:i.id})}),this.hammerDragCenter.on("doubletap",t=>{t.stopPropagation(),i.parent.itemSet._onUpdateItem(i),i.parent.itemSet.body.emitter.emit("doubleClick",{event:t,item:i.id})}),this.hammerDragCenter.on("panstart",t=>{t.stopPropagation(),i.parent.itemSet._onDragStart(t)}),this.hammerDragCenter.on("panmove",Js(t=i.parent.itemSet._onDrag).call(t,i.parent.itemSet)),this.hammerDragCenter.on("panend",Js(e=i.parent.itemSet._onDragEnd).call(e,i.parent.itemSet)),this.hammerDragCenter.get("press").set({time:1e4}),this.dom.box?this.dom.dragLeft?this.dom.box.insertBefore(n,this.dom.dragLeft):this.dom.box.appendChild(n):this.dom.point&&this.dom.point.appendChild(n),this.dom.dragCenter=n}else!this.selected&&this.dom.dragCenter&&(this.dom.dragCenter.parentNode&&this.dom.dragCenter.parentNode.removeChild(this.dom.dragCenter),this.dom.dragCenter=null,this.hammerDragCenter&&(this.hammerDragCenter.destroy(),this.hammerDragCenter=null))}_repaintDeleteButton(t){const e=(this.options.editable.overrideItems||null==this.editable)&&this.options.editable.remove||!this.options.editable.overrideItems&&null!=this.editable&&this.editable.remove;if(this.selected&&e&&!this.dom.deleteButton){const e=this,i=document.createElement("div");this.options.rtl?i.className="vis-delete-rtl":i.className="vis-delete";let n=this.options.locales[this.options.locale];n||(this.warned||(console.warn("WARNING: options.locales['".concat(this.options.locale,"'] not found. See https://visjs.github.io/vis-timeline/docs/timeline/#Localization")),this.warned=!0),n=this.options.locales.en),i.title=n.deleteSelected,this.hammerDeleteButton=new yb(i).on("tap",t=>{t.stopPropagation(),e.parent.removeFromDataSet(e)}),t.appendChild(i),this.dom.deleteButton=i}else this.selected&&e||!this.dom.deleteButton||(this.dom.deleteButton.parentNode&&this.dom.deleteButton.parentNode.removeChild(this.dom.deleteButton),this.dom.deleteButton=null,this.hammerDeleteButton&&(this.hammerDeleteButton.destroy(),this.hammerDeleteButton=null))}_repaintOnItemUpdateTimeTooltip(t){if(!this.options.tooltipOnItemUpdateTime)return;const e=(this.options.editable.updateTime||!0===this.data.editable)&&!1!==this.data.editable;if(this.selected&&e&&!this.dom.onItemUpdateTimeTooltip){const e=document.createElement("div");e.className="vis-onUpdateTime-tooltip",t.appendChild(e),this.dom.onItemUpdateTimeTooltip=e}else!this.selected&&this.dom.onItemUpdateTimeTooltip&&(this.dom.onItemUpdateTimeTooltip.parentNode&&this.dom.onItemUpdateTimeTooltip.parentNode.removeChild(this.dom.onItemUpdateTimeTooltip),this.dom.onItemUpdateTimeTooltip=null);if(this.dom.onItemUpdateTimeTooltip){this.dom.onItemUpdateTimeTooltip.style.visibility=this.parent.itemSet.touchParams.itemIsDragging?"visible":"hidden",this.dom.onItemUpdateTimeTooltip.style.transform="translateX(-50%)",this.dom.onItemUpdateTimeTooltip.style.left="50%";const t=50,e=this.parent.itemSet.body.domProps.scrollTop;let n;n="top"==this.options.orientation.item?this.top:this.parent.height-this.top-this.height;let o,s;var i;if(n+this.parent.top-t<-e?(this.dom.onItemUpdateTimeTooltip.style.bottom="",this.dom.onItemUpdateTimeTooltip.style.top="".concat(this.height+2,"px")):(this.dom.onItemUpdateTimeTooltip.style.top="",this.dom.onItemUpdateTimeTooltip.style.bottom="".concat(this.height+2,"px")),this.options.tooltipOnItemUpdateTime&&this.options.tooltipOnItemUpdateTime.template)s=Js(i=this.options.tooltipOnItemUpdateTime.template).call(i,this),o=s(this.data);else o="start: ".concat(ma(this.data.start).format("MM/DD/YYYY hh:mm")),this.data.end&&(o+="<br> end: ".concat(ma(this.data.end).format("MM/DD/YYYY hh:mm")));this.dom.onItemUpdateTimeTooltip.innerHTML=of.xss(o)}}_getItemData(){return this.parent.itemSet.itemsData.get(this.id)}_updateContents(t){let e,i,n,o,s;const r=this._getItemData(),a=(this.dom.box||this.dom.point).getElementsByClassName("vis-item-visible-frame")[0];var l,h;this.options.visibleFrameTemplate?(s=Js(l=this.options.visibleFrameTemplate).call(l,this),o=of.xss(s(r,a))):o="";if(a)if(o instanceof Object&&!(o instanceof Element))s(r,a);else if(i=this._contentToString(this.itemVisibleFrameContent)!==this._contentToString(o),i){if(o instanceof Element)a.innerHTML="",a.appendChild(o);else if(null!=o)a.innerHTML=of.xss(o);else if("background"!=this.data.type||void 0!==this.data.content)throw new Error('Property "content" missing in item '.concat(this.id));this.itemVisibleFrameContent=o}this.options.template?(n=Js(h=this.options.template).call(h,this),e=n(r,t,this.data)):e=this.data.content;if(e instanceof Object&&!(e instanceof Element))n(r,t);else if(i=this._contentToString(this.content)!==this._contentToString(e),i){if(e instanceof Element)t.innerHTML="",t.appendChild(e);else if(null!=e)t.innerHTML=of.xss(e);else if("background"!=this.data.type||void 0!==this.data.content)throw new Error('Property "content" missing in item '.concat(this.id));this.content=e}}_updateDataAttributes(t){if(this.options.dataAttributes&&this.options.dataAttributes.length>0){let e=[];if(Rs(this.options.dataAttributes))e=this.options.dataAttributes;else{if("all"!=this.options.dataAttributes)return;e=fm(this.data)}for(const i of e){const e=this.data[i];null!=e?t.setAttribute("data-".concat(i),e):t.removeAttribute("data-".concat(i))}}}_updateStyle(t){this.style&&(of.removeCssText(t,this.style),this.style=null),this.data.style&&(of.addCssText(t,this.data.style),this.style=this.data.style)}_contentToString(t){return"string"==typeof t?t:t&&"outerHTML"in t?t.outerHTML:t}_updateEditStatus(){this.options&&("boolean"==typeof this.options.editable?this.editable={updateTime:this.options.editable,updateGroup:this.options.editable,remove:this.options.editable}:"object"==typeof this.options.editable&&(this.editable={},of.selectiveExtend(["updateTime","updateGroup","remove"],this.editable,this.options.editable))),this.options&&this.options.editable&&!0===this.options.editable.overrideItems||this.data&&("boolean"==typeof this.data.editable?this.editable={updateTime:this.data.editable,updateGroup:this.data.editable,remove:this.data.editable}:"object"==typeof this.data.editable&&(this.editable={},of.selectiveExtend(["updateTime","updateGroup","remove"],this.editable,this.data.editable)))}getWidthLeft(){return 0}getWidthRight(){return 0}getTitle(){if(this.options.tooltip&&this.options.tooltip.template){var t;return Js(t=this.options.tooltip.template).call(t,this)(this._getItemData(),this.data)}return this.data.title}}Lk.prototype.stack=!0;class Fk extends Lk{constructor(t,e,i){if(super(t,e,i),this.props={dot:{width:0,height:0},line:{width:0,height:0}},t&&null==t.start)throw new Error('Property "start" missing in item '.concat(t))}isVisible(t){if(this.cluster)return!1;let e;const i=this.data.align||this.options.align,n=this.width*t.getMillisecondsPerPixel();return e="right"==i?this.data.start.getTime()>t.start&&this.data.start.getTime()-n<t.end:"left"==i?this.data.start.getTime()+n>t.start&&this.data.start.getTime()<t.end:this.data.start.getTime()+n/2>t.start&&this.data.start.getTime()-n/2<t.end,e}_createDomElement(){this.dom||(this.dom={},this.dom.box=document.createElement("DIV"),this.dom.content=document.createElement("DIV"),this.dom.content.className="vis-item-content",this.dom.box.appendChild(this.dom.content),this.dom.line=document.createElement("DIV"),this.dom.line.className="vis-line",this.dom.dot=document.createElement("DIV"),this.dom.dot.className="vis-dot",this.dom.box["vis-item"]=this,this.dirty=!0)}_appendDomElement(){if(!this.parent)throw new Error("Cannot redraw item: no parent attached");if(!this.dom.box.parentNode){const t=this.parent.dom.foreground;if(!t)throw new Error("Cannot redraw item: parent has no foreground container element");t.appendChild(this.dom.box)}if(!this.dom.line.parentNode){var t=this.parent.dom.background;if(!t)throw new Error("Cannot redraw item: parent has no background container element");t.appendChild(this.dom.line)}if(!this.dom.dot.parentNode){const e=this.parent.dom.axis;if(!t)throw new Error("Cannot redraw item: parent has no axis container element");e.appendChild(this.dom.dot)}this.displayed=!0}_updateDirtyDomComponents(){if(this.dirty){this._updateContents(this.dom.content),this._updateDataAttributes(this.dom.box),this._updateStyle(this.dom.box);const t=this.editable.updateTime||this.editable.updateGroup,e=(this.data.className?" "+this.data.className:"")+(this.selected?" vis-selected":"")+(t?" vis-editable":" vis-readonly");this.dom.box.className="vis-item vis-box".concat(e),this.dom.line.className="vis-item vis-line".concat(e),this.dom.dot.className="vis-item vis-dot".concat(e)}}_getDomComponentsSizes(){return{previous:{right:this.dom.box.style.right,left:this.dom.box.style.left},dot:{height:this.dom.dot.offsetHeight,width:this.dom.dot.offsetWidth},line:{width:this.dom.line.offsetWidth},box:{width:this.dom.box.offsetWidth,height:this.dom.box.offsetHeight}}}_updateDomComponentsSizes(t){this.options.rtl?this.dom.box.style.right="0px":this.dom.box.style.left="0px",this.props.dot.height=t.dot.height,this.props.dot.width=t.dot.width,this.props.line.width=t.line.width,this.width=t.box.width,this.height=t.box.height,this.options.rtl?this.dom.box.style.right=t.previous.right:this.dom.box.style.left=t.previous.left,this.dirty=!1}_repaintDomAdditionals(){this._repaintOnItemUpdateTimeTooltip(this.dom.box),this._repaintDragCenter(),this._repaintDeleteButton(this.dom.box)}redraw(t){var e,i,n,o;let s;const r=[Js(e=this._createDomElement).call(e,this),Js(i=this._appendDomElement).call(i,this),Js(n=this._updateDirtyDomComponents).call(n,this),()=>{this.dirty&&(s=this._getDomComponentsSizes())},()=>{var t;this.dirty&&Js(t=this._updateDomComponentsSizes).call(t,this)(s)},Js(o=this._repaintDomAdditionals).call(o,this)];if(t)return r;{let t;return ua(r).call(r,e=>{t=e()}),t}}show(t){if(!this.displayed)return this.redraw(t)}hide(){if(this.displayed){const t=this.dom;t.box.remove?t.box.remove():t.box.parentNode&&t.box.parentNode.removeChild(t.box),t.line.remove?t.line.remove():t.line.parentNode&&t.line.parentNode.removeChild(t.line),t.dot.remove?t.dot.remove():t.dot.parentNode&&t.dot.parentNode.removeChild(t.dot),this.displayed=!1}}repositionXY(){const t=this.options.rtl,e=function(t,e,i){var n;if(void 0===e&&void 0===i)return;const o=arguments.length>3&&void 0!==arguments[3]&&arguments[3]?-1*e:e;t.style.transform=void 0!==i?void 0!==e?Of(n="translate(".concat(o,"px, ")).call(n,i,"px)"):"translateY(".concat(i,"px)"):"translateX(".concat(o,"px)")};e(this.dom.box,this.boxX,this.boxY,t),e(this.dom.dot,this.dotX,this.dotY,t),e(this.dom.line,this.lineX,this.lineY,t)}repositionX(){const t=this.conversion.toScreen(this.data.start),e=void 0===this.data.align?this.options.align:this.data.align,i=this.props.line.width,n=this.props.dot.width;"right"==e?(this.boxX=t-this.width,this.lineX=t-i,this.dotX=t-i/2-n/2):"left"==e?(this.boxX=t,this.lineX=t,this.dotX=t+i/2-n/2):(this.boxX=t-this.width/2,this.lineX=this.options.rtl?t-i:t-i/2,this.dotX=t-n/2),this.options.rtl?this.right=this.boxX:this.left=this.boxX,this.repositionXY()}repositionY(){const t=this.options.orientation.item,e=this.dom.line.style;if("top"==t){const t=this.parent.top+this.top+1;this.boxY=this.top||0,e.height="".concat(t,"px"),e.bottom="",e.top="0"}else{const t=this.parent.itemSet.props.height-this.parent.top-this.parent.height+this.top;this.boxY=this.parent.height-this.top-(this.height||0),e.height="".concat(t,"px"),e.top="",e.bottom="0"}this.dotY=-this.props.dot.height/2,this.repositionXY()}getWidthLeft(){return this.width/2}getWidthRight(){return this.width/2}}class Rk extends Lk{constructor(t,e,i){if(super(t,e,i),this.props={dot:{top:0,width:0,height:0},content:{height:0,marginLeft:0,marginRight:0}},t&&null==t.start)throw new Error('Property "start" missing in item '.concat(t))}isVisible(t){if(this.cluster)return!1;const e=this.width*t.getMillisecondsPerPixel();return this.data.start.getTime()+e>t.start&&this.data.start<t.end}_createDomElement(){this.dom||(this.dom={},this.dom.point=document.createElement("div"),this.dom.content=document.createElement("div"),this.dom.content.className="vis-item-content",this.dom.point.appendChild(this.dom.content),this.dom.dot=document.createElement("div"),this.dom.point.appendChild(this.dom.dot),this.dom.point["vis-item"]=this,this.dirty=!0)}_appendDomElement(){if(!this.parent)throw new Error("Cannot redraw item: no parent attached");if(!this.dom.point.parentNode){const t=this.parent.dom.foreground;if(!t)throw new Error("Cannot redraw item: parent has no foreground container element");t.appendChild(this.dom.point)}this.displayed=!0}_updateDirtyDomComponents(){if(this.dirty){this._updateContents(this.dom.content),this._updateDataAttributes(this.dom.point),this._updateStyle(this.dom.point);const t=this.editable.updateTime||this.editable.updateGroup,e=(this.data.className?" "+this.data.className:"")+(this.selected?" vis-selected":"")+(t?" vis-editable":" vis-readonly");this.dom.point.className="vis-item vis-point".concat(e),this.dom.dot.className="vis-item vis-dot".concat(e)}}_getDomComponentsSizes(){return{dot:{width:this.dom.dot.offsetWidth,height:this.dom.dot.offsetHeight},content:{width:this.dom.content.offsetWidth,height:this.dom.content.offsetHeight},point:{width:this.dom.point.offsetWidth,height:this.dom.point.offsetHeight}}}_updateDomComponentsSizes(t){this.props.dot.width=t.dot.width,this.props.dot.height=t.dot.height,this.props.content.height=t.content.height,this.options.rtl?this.dom.content.style.marginRight="".concat(this.props.dot.width/2,"px"):this.dom.content.style.marginLeft="".concat(this.props.dot.width/2,"px"),this.width=t.point.width,this.height=t.point.height,this.dom.dot.style.top="".concat((this.height-this.props.dot.height)/2,"px");const e=this.props.dot.width,i=this.options.rtl?e/2:e/2*-1;this.dom.dot.style.transform="translateX(".concat(i,"px"),this.dirty=!1}_repaintDomAdditionals(){this._repaintOnItemUpdateTimeTooltip(this.dom.point),this._repaintDragCenter(),this._repaintDeleteButton(this.dom.point)}redraw(t){var e,i,n,o;let s;const r=[Js(e=this._createDomElement).call(e,this),Js(i=this._appendDomElement).call(i,this),Js(n=this._updateDirtyDomComponents).call(n,this),()=>{this.dirty&&(s=this._getDomComponentsSizes())},()=>{var t;this.dirty&&Js(t=this._updateDomComponentsSizes).call(t,this)(s)},Js(o=this._repaintDomAdditionals).call(o,this)];if(t)return r;{let t;return ua(r).call(r,e=>{t=e()}),t}}repositionXY(){const t=this.options.rtl;!function(t,e,i){var n;if(void 0===e&&void 0===i)return;const o=arguments.length>3&&void 0!==arguments[3]&&arguments[3]?-1*e:e;t.style.transform=void 0!==i?void 0!==e?Of(n="translate(".concat(o,"px, ")).call(n,i,"px)"):"translateY(".concat(i,"px)"):"translateX(".concat(o,"px)")}(this.dom.point,this.pointX,this.pointY,t)}show(t){if(!this.displayed)return this.redraw(t)}hide(){this.displayed&&(this.dom.point.parentNode&&this.dom.point.parentNode.removeChild(this.dom.point),this.displayed=!1)}repositionX(){const t=this.conversion.toScreen(this.data.start);this.pointX=t,this.options.rtl?this.right=t-this.props.dot.width:this.left=t-this.props.dot.width,this.repositionXY()}repositionY(){const t=this.options.orientation.item;this.pointY="top"==t?this.top:this.parent.height-this.top-this.height,this.repositionXY()}getWidthLeft(){return this.props.dot.width}getWidthRight(){return this.props.dot.width}}class Yk extends Lk{constructor(t,e,i){if(super(t,e,i),this.props={content:{width:0}},this.overflow=!1,t){if(null==t.start)throw new Error('Property "start" missing in item '.concat(t.id));if(null==t.end)throw new Error('Property "end" missing in item '.concat(t.id))}}isVisible(t){return!this.cluster&&(this.data.start<t.end&&this.data.end>t.start)}_createDomElement(){this.dom||(this.dom={},this.dom.box=document.createElement("div"),this.dom.frame=document.createElement("div"),this.dom.frame.className="vis-item-overflow",this.dom.box.appendChild(this.dom.frame),this.dom.visibleFrame=document.createElement("div"),this.dom.visibleFrame.className="vis-item-visible-frame",this.dom.box.appendChild(this.dom.visibleFrame),this.dom.content=document.createElement("div"),this.dom.content.className="vis-item-content",this.dom.frame.appendChild(this.dom.content),this.dom.box["vis-item"]=this,this.dirty=!0)}_appendDomElement(){if(!this.parent)throw new Error("Cannot redraw item: no parent attached");if(!this.dom.box.parentNode){const t=this.parent.dom.foreground;if(!t)throw new Error("Cannot redraw item: parent has no foreground container element");t.appendChild(this.dom.box)}this.displayed=!0}_updateDirtyDomComponents(){if(this.dirty){this._updateContents(this.dom.content),this._updateDataAttributes(this.dom.box),this._updateStyle(this.dom.box);const t=this.editable.updateTime||this.editable.updateGroup,e=(this.data.className?" "+this.data.className:"")+(this.selected?" vis-selected":"")+(t?" vis-editable":" vis-readonly");this.dom.box.className=this.baseClassName+e,this.dom.content.style.maxWidth="none"}}_getDomComponentsSizes(){return this.overflow="hidden"!==window.getComputedStyle(this.dom.frame).overflow,this.whiteSpace="nowrap"!==window.getComputedStyle(this.dom.content).whiteSpace,{content:{width:this.dom.content.offsetWidth},box:{height:this.dom.box.offsetHeight}}}_updateDomComponentsSizes(t){this.props.content.width=t.content.width,this.height=t.box.height,this.dom.content.style.maxWidth="",this.dirty=!1}_repaintDomAdditionals(){this._repaintOnItemUpdateTimeTooltip(this.dom.box),this._repaintDeleteButton(this.dom.box),this._repaintDragCenter(),this._repaintDragLeft(),this._repaintDragRight()}redraw(t){var e,i,n,o;let s;const r=[Js(e=this._createDomElement).call(e,this),Js(i=this._appendDomElement).call(i,this),Js(n=this._updateDirtyDomComponents).call(n,this),()=>{var t;this.dirty&&(s=Js(t=this._getDomComponentsSizes).call(t,this)())},()=>{var t;this.dirty&&Js(t=this._updateDomComponentsSizes).call(t,this)(s)},Js(o=this._repaintDomAdditionals).call(o,this)];if(t)return r;{let t;return ua(r).call(r,e=>{t=e()}),t}}show(t){if(!this.displayed)return this.redraw(t)}hide(){if(this.displayed){const t=this.dom.box;t.parentNode&&t.parentNode.removeChild(t),this.displayed=!1}}repositionX(t){const e=this.parent.width;let i=this.conversion.toScreen(this.data.start),n=this.conversion.toScreen(this.data.end);const o=void 0===this.data.align?this.options.align:this.data.align;let s,r;!1===this.data.limitSize||void 0!==t&&!0!==t||(i<-e&&(i=-e),n>2*e&&(n=2*e));const a=Math.max(Math.round(1e3*(n-i))/1e3,1);switch(this.overflow?(this.options.rtl?this.right=i:this.left=i,this.width=a+this.props.content.width,r=this.props.content.width):(this.options.rtl?this.right=i:this.left=i,this.width=a,r=Math.min(n-i,this.props.content.width)),this.options.rtl?this.dom.box.style.transform="translateX(".concat(-1*this.right,"px)"):this.dom.box.style.transform="translateX(".concat(this.left,"px)"),this.dom.box.style.width="".concat(a,"px"),this.whiteSpace&&(this.height=this.dom.box.offsetHeight),o){case"left":this.dom.content.style.transform="translateX(0)";break;case"right":if(this.options.rtl){const t=-1*Math.max(a-r,0);this.dom.content.style.transform="translateX(".concat(t,"px)")}else this.dom.content.style.transform="translateX(".concat(Math.max(a-r,0),"px)");break;case"center":if(this.options.rtl){const t=-1*Math.max((a-r)/2,0);this.dom.content.style.transform="translateX(".concat(t,"px)")}else this.dom.content.style.transform="translateX(".concat(Math.max((a-r)/2,0),"px)");break;default:if(s=this.overflow?n>0?Math.max(-i,0):-r:i<0?-i:0,this.options.rtl){const t=-1*s;this.dom.content.style.transform="translateX(".concat(t,"px)")}else this.dom.content.style.transform="translateX(".concat(s,"px)")}}repositionY(){const t=this.options.orientation.item,e=this.dom.box;e.style.top="".concat("top"==t?this.top:this.parent.height-this.top-this.height,"px")}_repaintDragLeft(){if((this.selected||this.options.itemsAlwaysDraggable.range)&&this.editable.updateTime&&!this.dom.dragLeft){const t=document.createElement("div");t.className="vis-drag-left",t.dragLeftItem=this,this.dom.box.appendChild(t),this.dom.dragLeft=t}else this.selected||this.options.itemsAlwaysDraggable.range||!this.dom.dragLeft||(this.dom.dragLeft.parentNode&&this.dom.dragLeft.parentNode.removeChild(this.dom.dragLeft),this.dom.dragLeft=null)}_repaintDragRight(){if((this.selected||this.options.itemsAlwaysDraggable.range)&&this.editable.updateTime&&!this.dom.dragRight){const t=document.createElement("div");t.className="vis-drag-right",t.dragRightItem=this,this.dom.box.appendChild(t),this.dom.dragRight=t}else this.selected||this.options.itemsAlwaysDraggable.range||!this.dom.dragRight||(this.dom.dragRight.parentNode&&this.dom.dragRight.parentNode.removeChild(this.dom.dragRight),this.dom.dragRight=null)}}Yk.prototype.baseClassName="vis-item vis-range";class jk extends Lk{constructor(t,e,i){if(super(t,e,i),this.props={content:{width:0}},this.overflow=!1,t){if(null==t.start)throw new Error('Property "start" missing in item '.concat(t.id));if(null==t.end)throw new Error('Property "end" missing in item '.concat(t.id))}}isVisible(t){return this.data.start<t.end&&this.data.end>t.start}_createDomElement(){this.dom||(this.dom={},this.dom.box=document.createElement("div"),this.dom.frame=document.createElement("div"),this.dom.frame.className="vis-item-overflow",this.dom.box.appendChild(this.dom.frame),this.dom.content=document.createElement("div"),this.dom.content.className="vis-item-content",this.dom.frame.appendChild(this.dom.content),this.dirty=!0)}_appendDomElement(){if(!this.parent)throw new Error("Cannot redraw item: no parent attached");if(!this.dom.box.parentNode){const t=this.parent.dom.background;if(!t)throw new Error("Cannot redraw item: parent has no background container element");t.appendChild(this.dom.box)}this.displayed=!0}_updateDirtyDomComponents(){if(this.dirty){this._updateContents(this.dom.content),this._updateDataAttributes(this.dom.content),this._updateStyle(this.dom.box);const t=(this.data.className?" "+this.data.className:"")+(this.selected?" vis-selected":"");this.dom.box.className=this.baseClassName+t}}_getDomComponentsSizes(){return this.overflow="hidden"!==window.getComputedStyle(this.dom.content).overflow,{content:{width:this.dom.content.offsetWidth}}}_updateDomComponentsSizes(t){this.props.content.width=t.content.width,this.height=0,this.dirty=!1}_repaintDomAdditionals(){}redraw(t){var e,i,n,o;let s;const r=[Js(e=this._createDomElement).call(e,this),Js(i=this._appendDomElement).call(i,this),Js(n=this._updateDirtyDomComponents).call(n,this),()=>{var t;this.dirty&&(s=Js(t=this._getDomComponentsSizes).call(t,this)())},()=>{var t;this.dirty&&Js(t=this._updateDomComponentsSizes).call(t,this)(s)},Js(o=this._repaintDomAdditionals).call(o,this)];if(t)return r;{let t;return ua(r).call(r,e=>{t=e()}),t}}repositionY(t){let e;const i=this.options.orientation.item;if(void 0!==this.data.subgroup){const t=this.data.subgroup;this.dom.box.style.height="".concat(this.parent.subgroups[t].height,"px"),this.dom.box.style.top="".concat("top"==i?this.parent.top+this.parent.subgroups[t].top:this.parent.top+this.parent.height-this.parent.subgroups[t].top-this.parent.subgroups[t].height,"px"),this.dom.box.style.bottom=""}else this.parent instanceof Nk?(e=Math.max(this.parent.height,this.parent.itemSet.body.domProps.center.height,this.parent.itemSet.body.domProps.centerContainer.height),this.dom.box.style.bottom="bottom"==i?"0":"",this.dom.box.style.top="top"==i?"0":""):(e=this.parent.height,this.dom.box.style.top="".concat(this.parent.top,"px"),this.dom.box.style.bottom="");this.dom.box.style.height="".concat(e,"px")}}jk.prototype.baseClassName="vis-item vis-background",jk.prototype.stack=!1,jk.prototype.show=Yk.prototype.show,jk.prototype.hide=Yk.prototype.hide,jk.prototype.repositionX=Yk.prototype.repositionX;class Hk{constructor(t,e){this.container=t,this.overflowMethod=e||"cap",this.x=0,this.y=0,this.padding=5,this.hidden=!1,this.frame=document.createElement("div"),this.frame.className="vis-tooltip",this.container.appendChild(this.frame)}setPosition(t,e){this.x=Nb(t),this.y=Nb(e)}setText(t){t instanceof Element?(this.frame.innerHTML="",this.frame.appendChild(t)):this.frame.innerHTML=of.xss(t)}show(t){if(void 0===t&&(t=!0),!0===t){var e=this.frame.clientHeight,i=this.frame.clientWidth,n=this.frame.parentNode.clientHeight,o=this.frame.parentNode.clientWidth,s=0,r=0;if("flip"==this.overflowMethod||"none"==this.overflowMethod){let t=!1,n=!0;"flip"==this.overflowMethod&&(this.y-e<this.padding&&(n=!1),this.x+i>o-this.padding&&(t=!0)),s=t?this.x-i:this.x,r=n?this.y-e:this.y}else(r=this.y-e)+e+this.padding>n&&(r=n-e-this.padding),r<this.padding&&(r=this.padding),(s=this.x)+i+this.padding>o&&(s=o-i-this.padding),s<this.padding&&(s=this.padding);this.frame.style.left=s+"px",this.frame.style.top=r+"px",this.frame.style.visibility="visible",this.hidden=!1}else this.hide()}hide(){this.hidden=!0,this.frame.style.left="0",this.frame.style.top="0",this.frame.style.visibility="hidden"}destroy(){this.frame.parentNode.removeChild(this.frame)}}var zk,Gk,Wk,Bk,Vk,Uk,Xk,qk,Zk,Kk={};function $k(){return Wk?Gk:(Wk=1,function(){if(zk)return Kk;zk=1;var t=bs(),e=ra().every;t({target:"Array",proto:!0,forced:!aa()("every")},{every:function(t){return e(this,t,arguments.length>1?arguments[1]:void 0)}})}(),Gk=zs()("Array","every"))}function Jk(){if(Vk)return Bk;Vk=1;var t=qn(),e=$k(),i=Array.prototype;return Bk=function(n){var o=n.every;return n===i||t(i,n)&&o===i.every?e:o},Bk}function Qk(){return Xk?Uk:(Xk=1,Uk=Jk())}var tD=n(Zk?qk:(Zk=1,qk=Qk()));class eD extends Lk{constructor(t,e,i){if(super(t,e,Cy({},{fitOnDoubleClick:!0},i,{editable:!1})),this.props={content:{width:0,height:0}},!t||null==t.uiItems)throw new Error('Property "uiItems" missing in item '+t.id);this.id=mi(),this.group=t.group,this._setupRange(),this.emitter=this.data.eventEmitter,this.range=this.data.range,this.attached=!1,this.isCluster=!0,this.data.isCluster=!0}hasItems(){return this.data.uiItems&&this.data.uiItems.length&&this.attached}setUiItems(t){this.detach(),this.data.uiItems=t,this._setupRange(),this.attach()}isVisible(t){const e=this.data.end?this.data.end-this.data.start:0,i=this.width*t.getMillisecondsPerPixel(),n=Math.max(this.data.start.getTime()+e,this.data.start.getTime()+i);return this.data.start<t.end&&n>t.start&&this.hasItems()}getData(){return{isCluster:!0,id:this.id,items:this.data.items||[],data:this.data}}redraw(t){var e,i,n,o,s,r,a,l,h=[Js(e=this._createDomElement).call(e,this),Js(i=this._appendDomElement).call(i,this),Js(n=this._updateDirtyDomComponents).call(n,this),Js(o=function(){this.dirty&&(a=this._getDomComponentsSizes())}).call(o,this),Js(s=function(){var t;this.dirty&&Js(t=this._updateDomComponentsSizes).call(t,this)(a)}).call(s,this),Js(r=this._repaintDomAdditionals).call(r,this)];return t?h:(ua(h).call(h,function(t){l=t()}),l)}show(){this.displayed||this.redraw()}hide(){if(this.displayed){var t=this.dom;t.box.parentNode&&t.box.parentNode.removeChild(t.box),this.options.showStipes&&(t.line.parentNode&&t.line.parentNode.removeChild(t.line),t.dot.parentNode&&t.dot.parentNode.removeChild(t.dot)),this.displayed=!1}}repositionX(){let t=this.conversion.toScreen(this.data.start),e=this.data.end?this.conversion.toScreen(this.data.end):0;if(e)this.repositionXWithRanges(t,e);else{let e=void 0===this.data.align?this.options.align:this.data.align;this.repositionXWithoutRanges(t,e)}this.options.showStipes&&(this.dom.line.style.display=this._isStipeVisible()?"block":"none",this.dom.dot.style.display=this._isStipeVisible()?"block":"none",this._isStipeVisible()&&this.repositionStype(t,e))}repositionStype(t,e){this.dom.line.style.display="block",this.dom.dot.style.display="block";const i=this.dom.line.offsetWidth,n=this.dom.dot.offsetWidth;if(e){const o=i+t+(e-t)/2,s=o-n/2,r=this.options.rtl?-1*o:o,a=this.options.rtl?-1*s:s;this.dom.line.style.transform="translateX(".concat(r,"px)"),this.dom.dot.style.transform="translateX(".concat(a,"px)")}else{const e=this.options.rtl?-1*t:t,i=this.options.rtl?-1*(t-n/2):t-n/2;this.dom.line.style.transform="translateX(".concat(e,"px)"),this.dom.dot.style.transform="translateX(".concat(i,"px)")}}repositionXWithoutRanges(t,e){"right"==e?this.options.rtl?(this.right=t-this.width,this.dom.box.style.right=this.right+"px"):(this.left=t-this.width,this.dom.box.style.left=this.left+"px"):"left"==e?this.options.rtl?(this.right=t,this.dom.box.style.right=this.right+"px"):(this.left=t,this.dom.box.style.left=this.left+"px"):this.options.rtl?(this.right=t-this.width/2,this.dom.box.style.right=this.right+"px"):(this.left=t-this.width/2,this.dom.box.style.left=this.left+"px")}repositionXWithRanges(t,e){let i=Math.round(Math.max(e-t+.5,1));this.options.rtl?this.right=t:this.left=t,this.width=Math.max(i,this.minWidth||0),this.options.rtl?this.dom.box.style.right=this.right+"px":this.dom.box.style.left=this.left+"px",this.dom.box.style.width=i+"px"}repositionY(){var t=this.options.orientation.item,e=this.dom.box;if(e.style.top="top"==t?(this.top||0)+"px":(this.parent.height-this.top-this.height||0)+"px",this.options.showStipes){if("top"==t)this.dom.line.style.top="0",this.dom.line.style.height=this.parent.top+this.top+1+"px",this.dom.line.style.bottom="";else{var i=this.parent.itemSet.props.height,n=i-this.parent.top-this.parent.height+this.top;this.dom.line.style.top=i-n+"px",this.dom.line.style.bottom="0"}this.dom.dot.style.top=-this.dom.dot.offsetHeight/2+"px"}}getWidthLeft(){return this.width/2}getWidthRight(){return this.width/2}move(){this.repositionX(),this.repositionY()}attach(){var t;for(let t of this.data.uiItems)t.cluster=this;this.data.items=Zp(t=this.data.uiItems).call(t,t=>t.data),this.attached=!0,this.dirty=!0}detach(){let t=arguments.length>0&&void 0!==arguments[0]&&arguments[0];if(this.hasItems()){for(let t of this.data.uiItems)delete t.cluster;this.attached=!1,t&&this.group&&(this.group.remove(this),this.group=null),this.data.items=[],this.dirty=!0}}_onDoubleClick(){this._fit()}_setupRange(){var t,e,i;const n=Zp(t=this.data.uiItems).call(t,t=>({start:t.data.start.valueOf(),end:t.data.end?t.data.end.valueOf():t.data.start.valueOf()}));this.data.min=Math.min(...Zp(n).call(n,t=>Math.min(t.start,t.end||t.start))),this.data.max=Math.max(...Zp(n).call(n,t=>Math.max(t.start,t.end||t.start)));const o=Zp(e=this.data.uiItems).call(e,t=>t.center),s=hm(o).call(o,(t,e)=>t+e,0)/this.data.uiItems.length;mb(i=this.data.uiItems).call(i,t=>t.data.end)?(this.data.start=new Date(this.data.min),this.data.end=new Date(this.data.max)):(this.data.start=new Date(s),this.data.end=null)}_getUiItems(){var t;return this.data.uiItems&&this.data.uiItems.length?Th(t=this.data.uiItems).call(t,t=>t.cluster===this):[]}_createDomElement(){if(!this.dom){var t;if(this.dom={},this.dom.box=document.createElement("DIV"),this.dom.content=document.createElement("DIV"),this.dom.content.className="vis-item-content",this.dom.box.appendChild(this.dom.content),this.options.showStipes&&(this.dom.line=document.createElement("DIV"),this.dom.line.className="vis-cluster-line",this.dom.line.style.display="none",this.dom.dot=document.createElement("DIV"),this.dom.dot.className="vis-cluster-dot",this.dom.dot.style.display="none"),this.options.fitOnDoubleClick)this.dom.box.ondblclick=Js(t=eD.prototype._onDoubleClick).call(t,this);this.dom.box["vis-item"]=this,this.dirty=!0}}_appendDomElement(){if(!this.parent)throw new Error("Cannot redraw item: no parent attached");if(!this.dom.box.parentNode){const t=this.parent.dom.foreground;if(!t)throw new Error("Cannot redraw item: parent has no foreground container element");t.appendChild(this.dom.box)}const t=this.parent.dom.background;if(this.options.showStipes){if(!this.dom.line.parentNode){if(!t)throw new Error("Cannot redraw item: parent has no background container element");t.appendChild(this.dom.line)}if(!this.dom.dot.parentNode){var e=this.parent.dom.axis;if(!t)throw new Error("Cannot redraw item: parent has no axis container element");e.appendChild(this.dom.dot)}}this.displayed=!0}_updateDirtyDomComponents(){if(this.dirty){this._updateContents(this.dom.content),this._updateDataAttributes(this.dom.box),this._updateStyle(this.dom.box);const t=this.baseClassName+" "+(this.data.className?" "+this.data.className:"")+(this.selected?" vis-selected":"")+" vis-readonly";this.dom.box.className="vis-item "+t,this.options.showStipes&&(this.dom.line.className="vis-item vis-cluster-line "+(this.selected?" vis-selected":""),this.dom.dot.className="vis-item vis-cluster-dot "+(this.selected?" vis-selected":"")),this.data.end&&(this.dom.content.style.maxWidth="none")}}_getDomComponentsSizes(){const t={previous:{right:this.dom.box.style.right,left:this.dom.box.style.left},box:{width:this.dom.box.offsetWidth,height:this.dom.box.offsetHeight}};return this.options.showStipes&&(t.dot={height:this.dom.dot.offsetHeight,width:this.dom.dot.offsetWidth},t.line={width:this.dom.line.offsetWidth}),t}_updateDomComponentsSizes(t){this.options.rtl?this.dom.box.style.right="0px":this.dom.box.style.left="0px",this.data.end?this.minWidth=t.box.width:this.width=t.box.width,this.height=t.box.height,this.options.rtl?this.dom.box.style.right=t.previous.right:this.dom.box.style.left=t.previous.left,this.dirty=!1}_repaintDomAdditionals(){this._repaintOnItemUpdateTimeTooltip(this.dom.box)}_isStipeVisible(){return this.minWidth>=this.width||!this.data.end}_getFitRange(){const t=.05*(this.data.max-this.data.min)/2;return{fitStart:this.data.min-t,fitEnd:this.data.max+t}}_fit(){if(this.emitter){const{fitStart:t,fitEnd:e}=this._getFitRange(),i={start:new Date(t),end:new Date(e),animation:!0};this.emitter.emit("fit",i)}}_getItemData(){return this.data}}eD.prototype.baseClassName="vis-item vis-range vis-cluster";const iD="__ungrouped__";class nD{constructor(t){this.itemSet=t,this.groups={},this.cache={},this.cache[-1]=[]}createClusterItem(t,e,i){return new eD(t,e,i)}setItems(t,e){this.items=t||[],this.dataChanged=!0,this.applyOnChangedLevel=!1,e&&e.applyOnChangedLevel&&(this.applyOnChangedLevel=e.applyOnChangedLevel)}updateData(){this.dataChanged=!0,this.applyOnChangedLevel=!1}getClusters(t,e,i){let{maxItems:n,clusterCriteria:o}="boolean"==typeof i?{}:i;o||(o=()=>!0),n=n||1;let s=-1,r=0;if(e>0){if(e>=1)return[];s=Math.abs(Math.round(Math.log(100/e)/Math.log(2))),r=Math.abs(Math.pow(2,s))}if(this.dataChanged){const t=s!=this.cacheLevel;(!this.applyOnChangedLevel||t)&&(this._dropLevelsCache(),this._filterData())}this.cacheLevel=s;let a=this.cache[s];if(!a){a=[];for(let e in this.groups)if(this.groups.hasOwnProperty(e)){const s=this.groups[e],l=s.length;let h=0;for(;h<l;){let e=s[h],l=1,d=h-1;for(;d>=0&&e.center-s[d].center<r/2;)!s[d].cluster&&o(e.data,s[d].data)&&l++,d--;let c=h+1;for(;c<s.length&&s[c].center-e.center<r/2;)o(e.data,s[c].data)&&l++,c++;let u=a.length-1;for(;u>=0&&e.center-a[u].center<r;)e.group==a[u].group&&o(e.data,a[u].data)&&l++,u--;if(l>n){const r=l-n+1,d=[];let c=h;for(;d.length<r&&c<s.length;)o(s[h].data,s[c].data)&&d.push(s[c]),c++;const u=this.itemSet.getGroupId(e.data),p=this.itemSet.groups[u]||this.itemSet.groups[iD];let m=this._getClusterForItems(d,p,t,i);a.push(m),h+=r}else delete e.cluster,h+=1}}this.cache[s]=a}return a}_filterData(){const t={};this.groups=t;for(const e of pk(this.items)){const i=e.parent?e.parent.groupId:"";let n=t[i];n||(n=[],t[i]=n),n.push(e),e.data.start&&(e.data.end?e.center=(e.data.start.valueOf()+e.data.end.valueOf())/2:e.center=e.data.start.valueOf())}for(let i in t){var e;if(t.hasOwnProperty(i))nv(e=t[i]).call(e,(t,e)=>t.center-e.center)}this.dataChanged=!1}_getClusterForItems(t,e,i,n){var o;const s=Zp(o=i||[]).call(o,t=>{var e;return{cluster:t,itemsIds:new cx(Zp(e=t.data.uiItems).call(e,t=>t.id))}});let r;if(s.length)for(let e of s)if(e.itemsIds.size===t.length&&tD(t).call(t,t=>e.itemsIds.has(t.id))){r=e.cluster;break}if(r)return r.setUiItems(t),r.group!==e&&(r.group&&r.group.remove(r),e&&(e.add(r),r.group=e)),r;let a=n.titleTemplate||"";const l={toScreen:this.itemSet.body.util.toScreen,toTime:this.itemSet.body.util.toTime},h=a.replace(/{count}/,t.length),d='<div title="'+h+'">'+t.length+"</div>",c=Cy({},n,this.itemSet.options),u={content:d,title:h,group:e,uiItems:t,eventEmitter:this.itemSet.body.emitter,range:this.itemSet.body.range};return r=this.createClusterItem(u,l,c),e&&(e.add(r),r.group=e),r.attach(),r}_dropLevelsCache(){this.cache={},this.cacheLevel=-1,this.cache[this.cacheLevel]=[]}}const oD="__ungrouped__",sD="__background__";class rD extends mg{constructor(t,e){super(),this.body=t,this.defaultOptions={type:null,orientation:{item:"bottom"},align:"auto",stack:!0,stackSubgroups:!0,groupOrderSwap(t,e,i){const n=e.order;e.order=t.order,t.order=n},groupOrder:"order",selectable:!0,multiselect:!1,longSelectPressTime:251,itemsAlwaysDraggable:{item:!1,range:!1},editable:{updateTime:!1,updateGroup:!1,add:!1,remove:!1,overrideItems:!1},groupEditable:{order:!1,add:!1,remove:!1},snap:Lb.snap,onDropObjectOnItem(t,e,i){i(e)},onAdd(t,e){e(t)},onUpdate(t,e){e(t)},onMove(t,e){e(t)},onRemove(t,e){e(t)},onMoving(t,e){e(t)},onAddGroup(t,e){e(t)},onMoveGroup(t,e){e(t)},onRemoveGroup(t,e){e(t)},margin:{item:{horizontal:10,vertical:10},axis:20},showTooltips:!0,tooltip:{followMouse:!1,overflowMethod:"flip",delay:500},tooltipOnItemUpdateTime:!1},this.options=of.extend({},this.defaultOptions),this.options.rtl=e.rtl,this.options.onTimeout=e.onTimeout,this.conversion={toScreen:t.util.toScreen,toTime:t.util.toTime},this.dom={},this.props={},this.hammer=null;const i=this;this.itemsData=null,this.groupsData=null,this.itemsSettingTime=null,this.initialItemSetDrawn=!1,this.userContinueNotBail=null,this.sequentialSelection=!1,this.itemListeners={add(t,e,n){i._onAdd(e.items),i.options.cluster&&i.clusterGenerator.setItems(i.items,{applyOnChangedLevel:!1}),i.redraw()},update(t,e,n){i._onUpdate(e.items),i.options.cluster&&i.clusterGenerator.setItems(i.items,{applyOnChangedLevel:!1}),i.redraw()},remove(t,e,n){i._onRemove(e.items),i.options.cluster&&i.clusterGenerator.setItems(i.items,{applyOnChangedLevel:!1}),i.redraw()}},this.groupListeners={add(t,e,n){if(i._onAddGroups(e.items),i.groupsData&&i.groupsData.length>0){var o;const t=i.groupsData.getDataSet();ua(o=t.get()).call(o,e=>{if(e.nestedGroups){var i;0!=e.showNested&&(e.showNested=!0);let o=[];ua(i=e.nestedGroups).call(i,i=>{const n=t.get(i);n&&(n.nestedInGroup=e.id,0==e.showNested&&(n.visible=!1),o=Of(o).call(o,n))}),t.update(o,n)}})}},update(t,e,n){i._onUpdateGroups(e.items)},remove(t,e,n){i._onRemoveGroups(e.items)}},this.items={},this.groups={},this.groupIds=[],this.selection=[],this.popup=null,this.popupTimer=null,this.touchParams={},this.groupTouchParams={group:null,isDragging:!1},this._create(),this.setOptions(e),this.clusters=[]}_create(){var t,e,i,n,o,s,r,a,l,h,d,c,u,p,m;const f=document.createElement("div");f.className="vis-itemset",f["vis-itemset"]=this,this.dom.frame=f;const g=document.createElement("div");g.className="vis-background",f.appendChild(g),this.dom.background=g;const v=document.createElement("div");v.className="vis-foreground",f.appendChild(v),this.dom.foreground=v;const b=document.createElement("div");b.className="vis-axis",this.dom.axis=b;const y=document.createElement("div");y.className="vis-labelset",this.dom.labelSet=y,this._updateUngrouped();const _=new Nk(sD,null,this);_.show(),this.groups[sD]=_,this.hammer=new yb(this.body.dom.centerContainer),this.hammer.on("hammer.input",t=>{t.isFirst&&this._onTouch(t)}),this.hammer.on("panstart",Js(t=this._onDragStart).call(t,this)),this.hammer.on("panmove",Js(e=this._onDrag).call(e,this)),this.hammer.on("panend",Js(i=this._onDragEnd).call(i,this)),this.hammer.get("pan").set({threshold:5,direction:yb.ALL}),this.hammer.get("press").set({time:1e4}),this.hammer.on("tap",Js(n=this._onSelectItem).call(n,this)),this.hammer.on("press",Js(o=this._onMultiSelectItem).call(o,this)),this.hammer.get("press").set({time:1e4}),this.hammer.on("doubletap",Js(s=this._onAddItem).call(s,this)),this.options.rtl?this.groupHammer=new yb(this.body.dom.rightContainer):this.groupHammer=new yb(this.body.dom.leftContainer),this.groupHammer.on("tap",Js(r=this._onGroupClick).call(r,this)),this.groupHammer.on("panstart",Js(a=this._onGroupDragStart).call(a,this)),this.groupHammer.on("panmove",Js(l=this._onGroupDrag).call(l,this)),this.groupHammer.on("panend",Js(h=this._onGroupDragEnd).call(h,this)),this.groupHammer.get("pan").set({threshold:5,direction:yb.DIRECTION_VERTICAL}),this.body.dom.centerContainer.addEventListener("mouseover",Js(d=this._onMouseOver).call(d,this)),this.body.dom.centerContainer.addEventListener("mouseout",Js(c=this._onMouseOut).call(c,this)),this.body.dom.centerContainer.addEventListener("mousemove",Js(u=this._onMouseMove).call(u,this)),this.body.dom.centerContainer.addEventListener("contextmenu",Js(p=this._onDragEnd).call(p,this)),this.body.dom.centerContainer.addEventListener("mousewheel",Js(m=this._onMouseWheel).call(m,this)),this.show()}setOptions(t){if(t){var e,i;const n=["type","rtl","align","order","stack","stackSubgroups","selectable","multiselect","sequentialSelection","multiselectPerGroup","longSelectPressTime","groupOrder","dataAttributes","template","groupTemplate","visibleFrameTemplate","hide","snap","groupOrderSwap","showTooltips","tooltip","tooltipOnItemUpdateTime","groupHeightMode","onTimeout"];of.selectiveExtend(n,this.options,t),"itemsAlwaysDraggable"in t&&("boolean"==typeof t.itemsAlwaysDraggable?(this.options.itemsAlwaysDraggable.item=t.itemsAlwaysDraggable,this.options.itemsAlwaysDraggable.range=!1):"object"==typeof t.itemsAlwaysDraggable&&(of.selectiveExtend(["item","range"],this.options.itemsAlwaysDraggable,t.itemsAlwaysDraggable),this.options.itemsAlwaysDraggable.item||(this.options.itemsAlwaysDraggable.range=!1))),"sequentialSelection"in t&&"boolean"==typeof t.sequentialSelection&&(this.options.sequentialSelection=t.sequentialSelection),"orientation"in t&&("string"==typeof t.orientation?this.options.orientation.item="top"===t.orientation?"top":"bottom":"object"==typeof t.orientation&&"item"in t.orientation&&(this.options.orientation.item=t.orientation.item)),"margin"in t&&("number"==typeof t.margin?(this.options.margin.axis=t.margin,this.options.margin.item.horizontal=t.margin,this.options.margin.item.vertical=t.margin):"object"==typeof t.margin&&(of.selectiveExtend(["axis"],this.options.margin,t.margin),"item"in t.margin&&("number"==typeof t.margin.item?(this.options.margin.item.horizontal=t.margin.item,this.options.margin.item.vertical=t.margin.item):"object"==typeof t.margin.item&&of.selectiveExtend(["horizontal","vertical"],this.options.margin.item,t.margin.item)))),ua(e=["locale","locales"]).call(e,e=>{e in t&&(this.options[e]=t[e])}),"editable"in t&&("boolean"==typeof t.editable?(this.options.editable.updateTime=t.editable,this.options.editable.updateGroup=t.editable,this.options.editable.add=t.editable,this.options.editable.remove=t.editable,this.options.editable.overrideItems=!1):"object"==typeof t.editable&&of.selectiveExtend(["updateTime","updateGroup","add","remove","overrideItems"],this.options.editable,t.editable)),"groupEditable"in t&&("boolean"==typeof t.groupEditable?(this.options.groupEditable.order=t.groupEditable,this.options.groupEditable.add=t.groupEditable,this.options.groupEditable.remove=t.groupEditable):"object"==typeof t.groupEditable&&of.selectiveExtend(["order","add","remove"],this.options.groupEditable,t.groupEditable));const o=e=>{const i=t[e];if(i){var n;if("function"!=typeof i)throw new Error(Of(n="option ".concat(e," must be a function ")).call(n,e,"(item, callback)"));this.options[e]=i}};ua(i=["onDropObjectOnItem","onAdd","onUpdate","onRemove","onMove","onMoving","onAddGroup","onMoveGroup","onRemoveGroup"]).call(i,o),t.cluster?(Cy(this.options,{cluster:t.cluster}),this.clusterGenerator||(this.clusterGenerator=new nD(this)),this.clusterGenerator.setItems(this.items,{applyOnChangedLevel:!1}),this.markDirty({refreshItems:!0,restackGroups:!0}),this.redraw()):this.clusterGenerator?(this._detachAllClusters(),this.clusters=[],this.clusterGenerator=null,this.options.cluster=void 0,this.markDirty({refreshItems:!0,restackGroups:!0}),this.redraw()):this.markDirty()}}markDirty(t){this.groupIds=[],t&&(t.refreshItems&&ua(of).call(of,this.items,t=>{t.dirty=!0,t.displayed&&t.redraw()}),t.restackGroups&&ua(of).call(of,this.groups,(t,e)=>{e!==sD&&(t.stackDirty=!0)}))}destroy(){this.clearPopupTimer(),this.hide(),this.setItems(null),this.setGroups(null),this.hammer&&this.hammer.destroy(),this.groupHammer&&this.groupHammer.destroy(),this.hammer=null,this.body=null,this.conversion=null}hide(){this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame),this.dom.axis.parentNode&&this.dom.axis.parentNode.removeChild(this.dom.axis),this.dom.labelSet.parentNode&&this.dom.labelSet.parentNode.removeChild(this.dom.labelSet)}show(){this.dom.frame.parentNode||this.body.dom.center.appendChild(this.dom.frame),this.dom.axis.parentNode||this.body.dom.backgroundVertical.appendChild(this.dom.axis),this.dom.labelSet.parentNode||(this.options.rtl?this.body.dom.right.appendChild(this.dom.labelSet):this.body.dom.left.appendChild(this.dom.labelSet))}setPopupTimer(t){if(this.clearPopupTimer(),t){const e=this.options.tooltip.delay||"number"==typeof this.options.tooltip.delay?this.options.tooltip.delay:500;this.popupTimer=vr(function(){t.show()},e)}}clearPopupTimer(){null!=this.popupTimer&&(clearTimeout(this.popupTimer),this.popupTimer=null)}setSelection(t){var e;null==t&&(t=[]),Rs(t)||(t=[t]);const i=Th(e=this.selection).call(e,e=>-1===Bv(t).call(t,e));for(let t of i){const e=this.getItemById(t);e&&e.unselect()}this.selection=[...t];for(let e of t){const t=this.getItemById(e);t&&t.select()}}getSelection(){var t;return Of(t=this.selection).call(t,[])}getVisibleItems(){const t=this.body.range.getRange();let e,i;this.options.rtl?(e=this.body.util.toScreen(t.start),i=this.body.util.toScreen(t.end)):(i=this.body.util.toScreen(t.start),e=this.body.util.toScreen(t.end));const n=[];for(const t in this.groups)if(this.groups.hasOwnProperty(t)){const o=this.groups[t],s=o.isVisible?o.visibleItems:[];for(const t of s)this.options.rtl?t.right<i&&t.right+t.width>e&&n.push(t.id):t.left<e&&t.left+t.width>i&&n.push(t.id)}return n}getItemsAtCurrentTime(t){let e,i;this.options.rtl?(e=this.body.util.toScreen(t),i=this.body.util.toScreen(t)):(i=this.body.util.toScreen(t),e=this.body.util.toScreen(t));const n=[];for(const t in this.groups)if(this.groups.hasOwnProperty(t)){const o=this.groups[t],s=o.isVisible?o.visibleItems:[];for(const t of s)this.options.rtl?t.right<i&&t.right+t.width>e&&n.push(t.id):t.left<e&&t.left+t.width>i&&n.push(t.id)}return n}getVisibleGroups(){const t=[];for(const e in this.groups)if(this.groups.hasOwnProperty(e)){this.groups[e].isVisible&&t.push(e)}return t}getItemById(t){var e;return this.items[t]||Yy(e=this.clusters).call(e,e=>e.id===t)}_deselect(t){const e=this.selection;for(let i=0,n=e.length;i<n;i++)if(e[i]==t){sb(e).call(e,i,1);break}}redraw(){const t=this.options.margin,e=this.body.range,i=of.option.asSize,n=this.options,o=n.orientation.item;let s=!1;const r=this.dom.frame;this.props.top=this.body.domProps.top.height+this.body.domProps.border.top,this.options.rtl?this.props.right=this.body.domProps.right.width+this.body.domProps.border.right:this.props.left=this.body.domProps.left.width+this.body.domProps.border.left,r.className="vis-itemset",this.options.cluster&&this._clusterItems(),s=this._orderGroups()||s;const a=e.end-e.start,l=a!=this.lastVisibleInterval||this.props.width!=this.props.lastWidth,h=e.start!=this.lastRangeStart,d=n.stack!=this.lastStack,c=n.stackSubgroups!=this.lastStackSubgroups,u=l||h||d||c;this.lastVisibleInterval=a,this.lastRangeStart=e.start,this.lastStack=n.stack,this.lastStackSubgroups=n.stackSubgroups,this.props.lastWidth=this.props.width;const p=this._firstGroup(),m={item:t.item,axis:t.axis},f={item:t.item,axis:t.item.vertical/2};let g=0;const v=t.axis+t.item.vertical;this.groups[sD].redraw(e,f,u);const b={};let y=0;ua(of).call(of,this.groups,(t,i)=>{if(i===sD)return;const n=t==p?m:f;b[i]=t.redraw(e,n,u,!0),y=b[i].length});if(y>0){const t={};for(let e=0;e<y;e++)ua(of).call(of,b,(i,n)=>{t[n]=i[e]()});ua(of).call(of,this.groups,(e,i)=>{if(i===sD)return;const n=t[i];s=n||s,g+=e.height}),g=Math.max(g,v)}return g=Math.max(g,v),r.style.height=i(g),this.props.width=r.offsetWidth,this.props.height=g,this.dom.axis.style.top=i("top"==o?this.body.domProps.top.height+this.body.domProps.border.top:this.body.domProps.top.height+this.body.domProps.centerContainer.height),this.options.rtl?this.dom.axis.style.right="0":this.dom.axis.style.left="0",this.hammer.get("press").set({time:this.options.longSelectPressTime}),this.initialItemSetDrawn=!0,s=this._isResized()||s,s}_firstGroup(){const t="top"==this.options.orientation.item?0:this.groupIds.length-1,e=this.groupIds[t];return this.groups[e]||this.groups[oD]||null}_updateUngrouped(){let t,e,i=this.groups[oD];if(this.groupsData){if(i)for(e in i.dispose(),delete this.groups[oD],this.items)if(this.items.hasOwnProperty(e)){t=this.items[e],t.parent&&t.parent.remove(t);const i=this.getGroupId(t.data),n=this.groups[i];n&&n.add(t)||t.hide()}}else if(!i){const n=null,o=null;for(e in i=new Ik(n,o,this),this.groups[oD]=i,this.items)this.items.hasOwnProperty(e)&&(t=this.items[e],i.add(t));i.show()}}getLabelSet(){return this.dom.labelSet}setItems(t){this.itemsSettingTime=new Date;const e=this;let i;const n=this.itemsData;if(t){if(!Zm(t))throw new TypeError("Data must implement the interface of DataSet or DataView");this.itemsData=Qm(t)}else this.itemsData=null;if(n&&(ua(of).call(of,this.itemListeners,(t,e)=>{n.off(e,t)}),n.dispose(),i=n.getIds(),this._onRemove(i)),this.itemsData){const t=this.id;ua(of).call(of,this.itemListeners,(i,n)=>{e.itemsData.on(n,i,t)}),i=this.itemsData.getIds(),this._onAdd(i),this._updateUngrouped()}this.body.emitter.emit("_change",{queue:!0})}getItems(){return null!=this.itemsData?this.itemsData.rawDS:null}setGroups(t){const e=this;let i;if(this.groupsData&&(ua(of).call(of,this.groupListeners,(t,i)=>{e.groupsData.off(i,t)}),i=this.groupsData.getIds(),this.groupsData=null,this._onRemoveGroups(i)),t){if(!Zm(t))throw new TypeError("Data must implement the interface of DataSet or DataView");this.groupsData=t}else this.groupsData=null;if(this.groupsData){var n;const t=this.groupsData.getDataSet();ua(n=t.get()).call(n,e=>{var i;e.nestedGroups&&ua(i=e.nestedGroups).call(i,i=>{const n=t.get(i);n.nestedInGroup=e.id,0==e.showNested&&(n.visible=!1),t.update(n)})});const o=this.id;ua(of).call(of,this.groupListeners,(t,i)=>{e.groupsData.on(i,t,o)}),i=this.groupsData.getIds(),this._onAddGroups(i)}this._updateUngrouped(),this._order(),this.options.cluster&&(this.clusterGenerator.updateData(),this._clusterItems(),this.markDirty({refreshItems:!0,restackGroups:!0})),this.body.emitter.emit("_change",{queue:!0})}getGroups(){return this.groupsData}removeItem(t){const e=this.itemsData.get(t);e&&this.options.onRemove(e,e=>{e&&this.itemsData.remove(t)})}_getType(t){return t.type||this.options.type||(t.end?"range":"box")}getGroupId(t){return"background"==this._getType(t)&&null==t.group?sD:this.groupsData?t.group:oD}_onUpdate(t){const e=this;ua(t).call(t,t=>{const i=e.itemsData.get(t);let n=e.items[t];const o=i?e._getType(i):null,s=rD.types[o];let r;if(n&&(s&&n instanceof s?e._updateItem(n,i):(r=n.selected,e._removeItem(n),n=null)),!n&&i){if(!s)throw new TypeError('Unknown item type "'.concat(o,'"'));n=new s(i,e.conversion,e.options),n.id=t,e._addItem(n),r&&(this.selection.push(t),n.select())}}),this._order(),this.options.cluster&&(this.clusterGenerator.setItems(this.items,{applyOnChangedLevel:!1}),this._clusterItems()),this.body.emitter.emit("_change",{queue:!0})}_onRemove(t){let e=0;const i=this;ua(t).call(t,t=>{const n=i.items[t];n&&(e++,i._removeItem(n))}),e&&(this._order(),this.body.emitter.emit("_change",{queue:!0}))}_order(){ua(of).call(of,this.groups,t=>{t.order()})}_onUpdateGroups(t){this._onAddGroups(t)}_onAddGroups(t){const e=this;ua(t).call(t,t=>{const i=e.groupsData.get(t);let n=e.groups[t];if(n)n.setData(i);else{if(t==oD||t==sD)throw new Error("Illegal group id. ".concat(t," is a reserved id."));const o=g_(e.options);of.extend(o,{height:null}),n=new Ik(t,i,e),e.groups[t]=n;for(const i in e.items)if(e.items.hasOwnProperty(i)){const o=e.items[i];o.data.group==t&&n.add(o)}n.order(),n.show()}}),this.body.emitter.emit("_change",{queue:!0})}_onRemoveGroups(t){ua(t).call(t,t=>{const e=this.groups[t];e&&(e.dispose(),delete this.groups[t])}),this.options.cluster&&(this.clusterGenerator.updateData(),this._clusterItems()),this.markDirty({restackGroups:!!this.options.cluster}),this.body.emitter.emit("_change",{queue:!0})}_orderGroups(){if(this.groupsData){let t=this.groupsData.getIds({order:this.options.groupOrder});t=this._orderNestedGroups(t);const e=!of.equalArray(t,this.groupIds);if(e){const e=this.groups;ua(t).call(t,t=>{e[t].hide()}),ua(t).call(t,t=>{e[t].show()}),this.groupIds=t}return e}return!1}_orderNestedGroups(t){return function t(e,i){let n=[];return ua(i).call(i,i=>{n.push(i);if(e.groupsData.get(i).nestedGroups){var o;const s=Zp(o=e.groupsData.get({filter:t=>t.nestedInGroup==i,order:e.options.groupOrder})).call(o,t=>t.id);n=Of(n).call(n,t(e,s))}}),n}(this,Th(t).call(t,t=>!this.groupsData.get(t).nestedInGroup))}_addItem(t){this.items[t.id]=t;const e=this.getGroupId(t.data),i=this.groups[e];i?i&&i.data&&i.data.showNested&&(t.groupShowing=!0):t.groupShowing=!1,i&&i.add(t)}_updateItem(t,e){t.setData(e);const i=this.getGroupId(t.data),n=this.groups[i];n?n&&n.data&&n.data.showNested&&(t.groupShowing=!0):t.groupShowing=!1}_removeItem(t){var e,i;t.hide(),delete this.items[t.id];const n=Bv(e=this.selection).call(e,t.id);-1!=n&&sb(i=this.selection).call(i,n,1),t.parent&&t.parent.remove(t),null!=this.popup&&this.popup.hide()}_constructByEndArray(t){const e=[];for(let i=0;i<t.length;i++)t[i]instanceof Yk&&e.push(t[i]);return e}_onTouch(t){this.touchParams.item=this.itemFromTarget(t),this.touchParams.dragLeftItem=t.target.dragLeftItem||!1,this.touchParams.dragRightItem=t.target.dragRightItem||!1,this.touchParams.itemProps=null}_getGroupIndex(t){for(let e=0;e<this.groupIds.length;e++)if(t==this.groupIds[e])return e}_onDragStart(t){if(this.touchParams.itemIsDragging)return;const e=this.touchParams.item||null,i=this;let n;if(e&&(e.selected||this.options.itemsAlwaysDraggable.item)){if(this.options.editable.overrideItems&&!this.options.editable.updateTime&&!this.options.editable.updateGroup)return;if(null!=e.editable&&!e.editable.updateTime&&!e.editable.updateGroup&&!this.options.editable.overrideItems)return;const o=this.touchParams.dragLeftItem,s=this.touchParams.dragRightItem;if(this.touchParams.itemIsDragging=!0,this.touchParams.selectedItem=e,o)n={item:o,initialX:t.center.x,dragLeft:!0,data:this._cloneItemData(e.data)},this.touchParams.itemProps=[n];else if(s)n={item:s,initialX:t.center.x,dragRight:!0,data:this._cloneItemData(e.data)},this.touchParams.itemProps=[n];else if(this.options.editable.add&&(t.srcEvent.ctrlKey||t.srcEvent.metaKey))this._onDragStartAddItem(t);else{this.groupIds.length<1&&this.redraw();const n=this._getGroupIndex(e.data.group),o=this.options.itemsAlwaysDraggable.item&&!e.selected?[e.id]:this.getSelection();this.touchParams.itemProps=Zp(o).call(o,e=>{const o=i.items[e],s=i._getGroupIndex(o.data.group);return{item:o,initialX:t.center.x,groupOffset:n-s,data:this._cloneItemData(o.data)}})}t.stopPropagation()}else this.options.editable.add&&(t.srcEvent.ctrlKey||t.srcEvent.metaKey)&&this._onDragStartAddItem(t)}_onDragStartAddItem(t){const e=this.options.snap||null,i=this.dom.frame.getBoundingClientRect(),n=this.options.rtl?i.right-t.center.x+10:t.center.x-i.left-10,o=this.body.util.toTime(n),s=this.body.util.getScale(),r=this.body.util.getStep(),a=e?e(o,s,r):o,l={type:"range",start:a,end:a,content:"new item"},h=mi();l[this.itemsData.idProp]=h;const d=this.groupFromTarget(t);d&&(l.group=d.groupId);const c=new Yk(l,this.conversion,this.options);c.id=h,c.data=this._cloneItemData(l),this._addItem(c),this.touchParams.selectedItem=c;const u={item:c,initialX:t.center.x,data:c.data};this.options.rtl?u.dragLeft=!0:u.dragRight=!0,this.touchParams.itemProps=[u],t.stopPropagation()}_onDrag(t){if(null!=this.popup&&this.options.showTooltips&&!this.popup.hidden){const e=this.body.dom.centerContainer,i=e.getBoundingClientRect();this.popup.setPosition(t.center.x-i.left+e.offsetLeft,t.center.y-i.top+e.offsetTop),this.popup.show()}if(this.touchParams.itemProps){var e;t.stopPropagation();const i=this,n=this.options.snap||null,o=this.body.dom.root.offsetLeft,s=this.options.rtl?o+this.body.domProps.right.width:o+this.body.domProps.left.width,r=this.body.util.getScale(),a=this.body.util.getStep(),l=this.touchParams.selectedItem,h=(this.options.editable.overrideItems||null==l.editable)&&this.options.editable.updateGroup||!this.options.editable.overrideItems&&null!=l.editable&&l.editable.updateGroup;let d=null;if(h&&l&&null!=l.data.group){const e=i.groupFromTarget(t);e&&(d=this._getGroupIndex(e.groupId))}ua(e=this.touchParams.itemProps).call(e,e=>{const o=i.body.util.toTime(t.center.x-s),c=i.body.util.toTime(e.initialX-s);let u,p,m,f,g;u=this.options.rtl?-(o-c):o-c;let v=this._cloneItemData(e.item.data);if(null!=e.item.editable&&!e.item.editable.updateTime&&!e.item.editable.updateGroup&&!i.options.editable.overrideItems)return;if((this.options.editable.overrideItems||null==l.editable)&&this.options.editable.updateTime||!this.options.editable.overrideItems&&null!=l.editable&&l.editable.updateTime)if(e.dragLeft)this.options.rtl?null!=v.end&&(m=of.convert(e.data.end,"Date"),g=new Date(m.valueOf()+u),v.end=n?n(g,r,a):g):null!=v.start&&(p=of.convert(e.data.start,"Date"),f=new Date(p.valueOf()+u),v.start=n?n(f,r,a):f);else if(e.dragRight)this.options.rtl?null!=v.start&&(p=of.convert(e.data.start,"Date"),f=new Date(p.valueOf()+u),v.start=n?n(f,r,a):f):null!=v.end&&(m=of.convert(e.data.end,"Date"),g=new Date(m.valueOf()+u),v.end=n?n(g,r,a):g);else if(null!=v.start)if(p=of.convert(e.data.start,"Date").valueOf(),f=new Date(p+u),null!=v.end){m=of.convert(e.data.end,"Date");const t=m.valueOf()-p.valueOf();v.start=n?n(f,r,a):f,v.end=new Date(v.start.valueOf()+t)}else v.start=n?n(f,r,a):f;if(h&&!e.dragLeft&&!e.dragRight&&null!=d&&null!=v.group){let t=d-e.groupOffset;t=Math.max(0,t),t=Math.min(i.groupIds.length-1,t),v.group=i.groupIds[t]}v=this._cloneItemData(v),i.options.onMoving(v,t=>{t&&e.item.setData(this._cloneItemData(t,"Date"))})}),this.body.emitter.emit("_change")}}_moveToGroup(t,e){const i=this.groups[e];if(i&&i.groupId!=t.data.group){const e=t.parent;e.remove(t),e.order(),t.data.group=i.groupId,i.add(t),i.order()}}_onDragEnd(t){if(this.touchParams.itemIsDragging=!1,this.touchParams.itemProps){t.stopPropagation();const e=this,i=this.touchParams.itemProps;this.touchParams.itemProps=null,ua(i).call(i,t=>{const i=t.item.id;if(null!=e.itemsData.get(i)){const n=this._cloneItemData(t.item.data);e.options.onMove(n,n=>{n?(n[this.itemsData.idProp]=i,this.itemsData.update(n)):(t.item.setData(t.data),e.body.emitter.emit("_change"))})}else e.options.onAdd(t.item.data,i=>{e._removeItem(t.item),i&&e.itemsData.add(i),e.body.emitter.emit("_change")})})}}_onGroupClick(t){const e=this.groupFromTarget(t);vr(()=>{this.toggleGroupShowNested(e)},1)}toggleGroupShowNested(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:void 0;if(!t||!t.nestedGroups)return;const i=this.groupsData.getDataSet();t.showNested=null!=e?!!e:!t.showNested;let n=i.get(t.groupId);n.showNested=t.showNested;let o=t.nestedGroups,s=o;for(;s.length>0;){let t=s;s=[];for(let e=0;e<t.length;e++){let n=i.get(t[e]);n.nestedGroups&&(s=Of(s).call(s,n.nestedGroups))}s.length>0&&(o=Of(o).call(o,s))}var r;if(n.showNested){var a=i.get(n.nestedGroups);for(let t=0;t<a.length;t++){let e=a[t];e.nestedGroups&&e.nestedGroups.length>0&&(null==e.showNested||1==e.showNested)&&a.push(...i.get(e.nestedGroups))}r=Zp(a).call(a,function(t){return null==t.visible&&(t.visible=!0),t.visible=!!n.showNested,t})}else{var l;r=Zp(l=i.get(o)).call(l,function(t){return null==t.visible&&(t.visible=!0),t.visible=!!n.showNested,t})}i.update(Of(r).call(r,n)),n.showNested?(of.removeClassName(t.dom.label,"collapsed"),of.addClassName(t.dom.label,"expanded")):(of.removeClassName(t.dom.label,"expanded"),of.addClassName(t.dom.label,"collapsed"))}toggleGroupDragClassName(t){t.dom.label.classList.toggle("vis-group-is-dragging"),t.dom.foreground.classList.toggle("vis-group-is-dragging")}_onGroupDragStart(t){this.groupTouchParams.isDragging||this.options.groupEditable.order&&(this.groupTouchParams.group=this.groupFromTarget(t),this.groupTouchParams.group&&(t.stopPropagation(),this.groupTouchParams.isDragging=!0,this.toggleGroupDragClassName(this.groupTouchParams.group),this.groupTouchParams.originalOrder=this.groupsData.getIds({order:this.options.groupOrder})))}_onGroupDrag(t){if(this.options.groupEditable.order&&this.groupTouchParams.group){t.stopPropagation();const e=this.groupsData.getDataSet(),i=this.groupFromTarget(t);if(i&&i.height!=this.groupTouchParams.group.height){const e=i.top<this.groupTouchParams.group.top,n=t.center?t.center.y:t.clientY,o=i.dom.foreground.getBoundingClientRect(),s=this.groupTouchParams.group.height;if(e){if(o.top+s<n)return}else{const t=i.height;if(o.top+t-s>n)return}}if(i&&i!=this.groupTouchParams.group){const t=e.get(i.groupId),n=e.get(this.groupTouchParams.group.groupId);n&&t&&(this.options.groupOrderSwap(n,t,e),e.update(n),e.update(t));const o=e.getIds({order:this.options.groupOrder});if(!of.equalArray(o,this.groupTouchParams.originalOrder)){const t=this.groupTouchParams.originalOrder,i=this.groupTouchParams.group.groupId,n=Math.min(t.length,o.length);let s=0,r=0,a=0;for(;s<n;){for(;s+r<n&&s+a<n&&o[s+r]==t[s+a];)s++;if(s+r>=n)break;if(o[s+r]==i)r=1;else if(t[s+a]==i)a=1;else{const i=Bv(o).call(o,t[s+a]),n=e.get(o[s+r]),l=e.get(t[s+a]);this.options.groupOrderSwap(n,l,e),e.update(n),e.update(l);const h=o[s+r];o[s+r]=t[s+a],o[i]=h,s++}}}}}}_onGroupDragEnd(t){if(this.groupTouchParams.isDragging=!1,this.options.groupEditable.order&&this.groupTouchParams.group){t.stopPropagation();const e=this,i=e.groupTouchParams.group.groupId,n=e.groupsData.getDataSet(),o=of.extend({},n.get(i));e.options.onMoveGroup(o,t=>{if(t)t[n._idProp]=i,n.update(t);else{const t=n.getIds({order:e.options.groupOrder});if(!of.equalArray(t,e.groupTouchParams.originalOrder)){const i=e.groupTouchParams.originalOrder,o=Math.min(i.length,t.length);let s=0;for(;s<o;){for(;s<o&&t[s]==i[s];)s++;if(s>=o)break;const r=Bv(t).call(t,i[s]),a=n.get(t[s]),l=n.get(i[s]);e.options.groupOrderSwap(a,l,n),n.update(a),n.update(l);const h=t[s];t[s]=i[s],t[r]=h,s++}}}}),e.body.emitter.emit("groupDragged",{groupId:i}),this.toggleGroupDragClassName(this.groupTouchParams.group),this.groupTouchParams.group=null}}_onSelectItem(t){if(!this.options.selectable)return;const e=t.srcEvent&&(t.srcEvent.ctrlKey||t.srcEvent.metaKey),i=t.srcEvent&&t.srcEvent.shiftKey;if(e||i)return void this._onMultiSelectItem(t);const n=this.getSelection(),o=this.itemFromTarget(t),s=o&&o.selectable?[o.id]:[];this.setSelection(s);const r=this.getSelection();(r.length>0||n.length>0)&&this.body.emitter.emit("select",{items:r,event:t})}_onMouseOver(t){const e=this.itemFromTarget(t);if(!e)return;if(e===this.itemFromRelatedTarget(t))return;const i=e.getTitle();if(this.options.showTooltips&&i){null==this.popup&&(this.popup=new Hk(this.body.dom.root,this.options.tooltip.overflowMethod||"flip")),this.popup.setText(i);const e=this.body.dom.centerContainer,n=e.getBoundingClientRect();this.popup.setPosition(t.clientX-n.left+e.offsetLeft,t.clientY-n.top+e.offsetTop),this.setPopupTimer(this.popup)}else this.clearPopupTimer(),null!=this.popup&&this.popup.hide();this.body.emitter.emit("itemover",{item:e.id,event:t})}_onMouseOut(t){const e=this.itemFromTarget(t);if(!e)return;e!==this.itemFromRelatedTarget(t)&&(this.clearPopupTimer(),null!=this.popup&&this.popup.hide(),this.body.emitter.emit("itemout",{item:e.id,event:t}))}_onMouseMove(t){if(this.itemFromTarget(t)&&(null!=this.popupTimer&&this.setPopupTimer(this.popup),this.options.showTooltips&&this.options.tooltip.followMouse&&this.popup&&!this.popup.hidden)){const e=this.body.dom.centerContainer,i=e.getBoundingClientRect();this.popup.setPosition(t.clientX-i.left+e.offsetLeft,t.clientY-i.top+e.offsetTop),this.popup.show()}}_onMouseWheel(t){this.touchParams.itemIsDragging&&this._onDragEnd(t)}_onUpdateItem(t){if(!this.options.selectable)return;if(!this.options.editable.updateTime&&!this.options.editable.updateGroup)return;const e=this;if(t){const i=e.itemsData.get(t.id);this.options.onUpdate(i,t=>{t&&e.itemsData.update(t)})}}_onDropObjectOnItem(t){const e=this.itemFromTarget(t),i=JSON.parse(t.dataTransfer.getData("text"));this.options.onDropObjectOnItem(i,e)}_onAddItem(t){if(!this.options.selectable)return;if(!this.options.editable.add)return;const e=this,i=this.options.snap||null,n=this.dom.frame.getBoundingClientRect(),o=this.options.rtl?n.right-t.center.x:t.center.x-n.left,s=this.body.util.toTime(o),r=this.body.util.getScale(),a=this.body.util.getStep();let l,h;"drop"==t.type?(h=JSON.parse(t.dataTransfer.getData("text")),h.content=h.content?h.content:"new item",h.start=h.start?h.start:i?i(s,r,a):s,h.type=h.type||"box",h[this.itemsData.idProp]=h.id||mi(),"range"!=h.type||h.end||(l=this.body.util.toTime(o+this.props.width/5),h.end=i?i(l,r,a):l)):(h={start:i?i(s,r,a):s,content:"new item"},h[this.itemsData.idProp]=mi(),"range"===this.options.type&&(l=this.body.util.toTime(o+this.props.width/5),h.end=i?i(l,r,a):l));const d=this.groupFromTarget(t);d&&(h.group=d.groupId),h=this._cloneItemData(h),this.options.onAdd(h,i=>{i&&(e.itemsData.add(i),"drop"==t.type&&e.setSelection([i.id]))})}_onMultiSelectItem(t){if(!this.options.selectable)return;const e=this.itemFromTarget(t);if(e){let i=this.options.multiselect?this.getSelection():[];if((t.srcEvent&&t.srcEvent.shiftKey||!1||this.options.sequentialSelection)&&this.options.multiselect){const t=this.itemsData.get(e.id).group;let n;this.options.multiselectPerGroup&&i.length>0&&(n=this.itemsData.get(i[0]).group),this.options.multiselectPerGroup&&null!=n&&n!=t||i.push(e.id);const o=rD._getItemRange(this.itemsData.get(i));if(!this.options.multiselectPerGroup||n==t){i=[];for(const t in this.items)if(this.items.hasOwnProperty(t)){const e=this.items[t],s=e.data.start,r=void 0!==e.data.end?e.data.end:s;!(s>=o.min&&r<=o.max)||this.options.multiselectPerGroup&&n!=this.itemsData.get(e.id).group||e instanceof jk||i.push(e.id)}}}else{const t=Bv(i).call(i,e.id);-1==t?i.push(e.id):sb(i).call(i,t,1)}const n=Th(i).call(i,t=>this.getItemById(t).selectable);this.setSelection(n),this.body.emitter.emit("select",{items:this.getSelection(),event:t})}}static _getItemRange(t){let e=null,i=null;return ua(t).call(t,t=>{(null==i||t.start<i)&&(i=t.start),null!=t.end?(null==e||t.end>e)&&(e=t.end):(null==e||t.start>e)&&(e=t.start)}),{min:i,max:e}}itemFromElement(t){let e=t;for(;e;){if(e.hasOwnProperty("vis-item"))return e["vis-item"];e=e.parentNode}return null}itemFromTarget(t){return this.itemFromElement(t.target)}itemFromRelatedTarget(t){return this.itemFromElement(t.relatedTarget)}groupFromTarget(t){const e=t.center?t.center.y:t.clientY;let i=this.groupIds;i.length<=0&&this.groupsData&&(i=this.groupsData.getIds({order:this.options.groupOrder}));for(let t=0;t<i.length;t++){const n=i[t],o=this.groups[n],s=o.dom.foreground,r=s.getBoundingClientRect();if(e>=r.top&&e<r.top+s.offsetHeight)return o;if("top"===this.options.orientation.item){if(t===this.groupIds.length-1&&e>r.top)return o}else if(0===t&&e<r.top+s.offset)return o}return null}static itemSetFromTarget(t){let e=t.target;for(;e;){if(e.hasOwnProperty("vis-itemset"))return e["vis-itemset"];e=e.parentNode}return null}_cloneItemData(t,e){const i=of.extend({},t);return e||(e=this.itemsData.type),null!=i.start&&(i.start=of.convert(i.start,e&&e.start||"Date")),null!=i.end&&(i.end=of.convert(i.end,e&&e.end||"Date")),i}_clusterItems(){if(!this.options.cluster)return;const{scale:t}=this.body.range.conversion(this.body.domProps.center.width),e=this.clusterGenerator.getClusters(this.clusters,t,this.options.cluster);if(this.clusters!=e){if(this._detachAllClusters(),e){for(let t of e)t.attach();this.clusters=e}this._updateClusters(e)}}_detachAllClusters(){if(this.options.cluster&&this.clusters&&this.clusters.length)for(let t of this.clusters)t.detach()}_updateClusters(t){if(this.clusters&&this.clusters.length){var e;const o=new cx(Zp(t).call(t,t=>t.id)),s=Th(e=this.clusters).call(e,t=>!o.has(t.id));let r=!1;for(let t of s){var i;const e=Bv(i=this.selection).call(i,t.id);var n;if(-1!==e)t.unselect(),sb(n=this.selection).call(n,e,1),r=!0}if(r){const t=this.getSelection();this.body.emitter.emit("select",{items:t,event:event})}}this.clusters=t||[]}}rD.types={background:jk,box:Fk,range:Yk,point:Rk},rD.prototype._onAdd=rD.prototype._onUpdate;let aD,lD=!1,hD="background: #FFeeee; color: #dd0000";class dD{constructor(){}static validate(t,e,i){lD=!1,aD=e;let n=e;return void 0!==i&&(n=e[i]),dD.parse(t,n,[]),lD}static parse(t,e,i){for(let n in t)t.hasOwnProperty(n)&&dD.check(n,t,e,i)}static check(t,e,i,n){if(void 0===i[t]&&void 0===i.__any__)return void dD.getSuggestion(t,i,n);let o=t,s=!0;void 0===i[t]&&void 0!==i.__any__&&(o="__any__",s="object"===dD.getType(e[t]));let r=i[o];s&&void 0!==r.__type__&&(r=r.__type__),dD.checkFields(t,e,i,o,r,n)}static checkFields(t,e,i,n,o,s){let r=function(e){console.log("%c"+e+dD.printLocation(s,t),hD)},a=dD.getType(e[t]),l=o[a];void 0!==l?"array"===dD.getType(l)&&-1===Bv(l).call(l,e[t])?(r('Invalid option detected in "'+t+'". Allowed values are:'+dD.print(l)+' not "'+e[t]+'". '),lD=!0):"object"===a&&"__any__"!==n&&(s=of.copyAndExtendArray(s,t),dD.parse(e[t],i[n],s)):void 0===o.any&&(r('Invalid type received for "'+t+'". Expected: '+dD.print(fm(o))+". Received ["+a+'] "'+e[t]+'"'),lD=!0)}static getType(t){var e=typeof t;return"object"===e?null===t?"null":t instanceof Boolean?"boolean":t instanceof Number?"number":t instanceof String?"string":Rs(t)?"array":t instanceof Date?"date":void 0!==t.nodeType?"dom":!0===t._isAMomentObject?"moment":"object":"number"===e?"number":"boolean"===e?"boolean":"string"===e?"string":void 0===e?"undefined":e}static getSuggestion(t,e,i){let n,o=dD.findInOptions(t,e,i,!1),s=dD.findInOptions(t,aD,[],!0);n=void 0!==o.indexMatch?" in "+dD.printLocation(o.path,t,"")+'Perhaps it was incomplete? Did you mean: "'+o.indexMatch+'"?\n\n':s.distance<=4&&o.distance>s.distance?" in "+dD.printLocation(o.path,t,"")+"Perhaps it was misplaced? Matching option found at: "+dD.printLocation(s.path,s.closestMatch,""):o.distance<=8?'. Did you mean "'+o.closestMatch+'"?'+dD.printLocation(o.path,t):". Did you mean one of these: "+dD.print(fm(e))+dD.printLocation(i,t),console.log('%cUnknown option detected: "'+t+'"'+n,hD),lD=!0}static findInOptions(t,e,i){let n,o=arguments.length>3&&void 0!==arguments[3]&&arguments[3],s=1e9,r="",a=[],l=t.toLowerCase();for(let d in e){let c;if(void 0!==e[d].__type__&&!0===o){let o=dD.findInOptions(t,e[d],of.copyAndExtendArray(i,d));s>o.distance&&(r=o.closestMatch,a=o.path,s=o.distance,n=o.indexMatch)}else{var h;-1!==Bv(h=d.toLowerCase()).call(h,l)&&(n=d),c=dD.levenshteinDistance(t,d),s>c&&(r=d,a=of.copyArray(i),s=c)}}return{closestMatch:r,path:a,distance:s,indexMatch:n}}static printLocation(t,e){let i="\n\n"+(arguments.length>2&&void 0!==arguments[2]?arguments[2]:"Problem value found at: \n")+"options = {\n";for(let e=0;e<t.length;e++){for(let t=0;t<e+1;t++)i+="  ";i+=t[e]+": {\n"}for(let e=0;e<t.length+1;e++)i+="  ";i+=e+"\n";for(let e=0;e<t.length+1;e++){for(let n=0;n<t.length-e;n++)i+="  ";i+="}\n"}return i+"\n\n"}static print(t){return Wf(t).replace(/(\")|(\[)|(\])|(,"__type__")/g,"").replace(/(\,)/g,", ")}static levenshteinDistance(t,e){if(0===t.length)return e.length;if(0===e.length)return t.length;var i,n,o=[];for(i=0;i<=e.length;i++)o[i]=[i];for(n=0;n<=t.length;n++)o[0][n]=n;for(i=1;i<=e.length;i++)for(n=1;n<=t.length;n++)e.charAt(i-1)==t.charAt(n-1)?o[i][n]=o[i-1][n-1]:o[i][n]=Math.min(o[i-1][n-1]+1,Math.min(o[i][n-1]+1,o[i-1][n]+1));return o[e.length][t.length]}}let cD="string",uD="boolean",pD="number",mD="array",fD="date",gD="object",vD="moment",bD={configure:{enabled:{boolean:uD},filter:{boolean:uD,function:"function"},container:{dom:"dom"},__type__:{object:gD,boolean:uD,function:"function"}},align:{string:cD},alignCurrentTime:{string:cD,undefined:"undefined"},rtl:{boolean:uD,undefined:"undefined"},rollingMode:{follow:{boolean:uD},offset:{number:pD,undefined:"undefined"},__type__:{object:gD}},onTimeout:{timeoutMs:{number:pD},callback:{function:"function"},__type__:{object:gD}},verticalScroll:{boolean:uD,undefined:"undefined"},horizontalScroll:{boolean:uD,undefined:"undefined"},autoResize:{boolean:uD},throttleRedraw:{number:pD},clickToUse:{boolean:uD},dataAttributes:{string:cD,array:mD},editable:{add:{boolean:uD,undefined:"undefined"},remove:{boolean:uD,undefined:"undefined"},updateGroup:{boolean:uD,undefined:"undefined"},updateTime:{boolean:uD,undefined:"undefined"},overrideItems:{boolean:uD,undefined:"undefined"},__type__:{boolean:uD,object:gD}},end:{number:pD,date:fD,string:cD,moment:vD},format:{minorLabels:{millisecond:{string:cD,undefined:"undefined"},second:{string:cD,undefined:"undefined"},minute:{string:cD,undefined:"undefined"},hour:{string:cD,undefined:"undefined"},weekday:{string:cD,undefined:"undefined"},day:{string:cD,undefined:"undefined"},week:{string:cD,undefined:"undefined"},month:{string:cD,undefined:"undefined"},year:{string:cD,undefined:"undefined"},__type__:{object:gD,function:"function"}},majorLabels:{millisecond:{string:cD,undefined:"undefined"},second:{string:cD,undefined:"undefined"},minute:{string:cD,undefined:"undefined"},hour:{string:cD,undefined:"undefined"},weekday:{string:cD,undefined:"undefined"},day:{string:cD,undefined:"undefined"},week:{string:cD,undefined:"undefined"},month:{string:cD,undefined:"undefined"},year:{string:cD,undefined:"undefined"},__type__:{object:gD,function:"function"}},__type__:{object:gD}},moment:{function:"function"},groupHeightMode:{string:cD},groupOrder:{string:cD,function:"function"},groupEditable:{add:{boolean:uD,undefined:"undefined"},remove:{boolean:uD,undefined:"undefined"},order:{boolean:uD,undefined:"undefined"},__type__:{boolean:uD,object:gD}},groupOrderSwap:{function:"function"},height:{string:cD,number:pD},hiddenDates:{start:{date:fD,number:pD,string:cD,moment:vD},end:{date:fD,number:pD,string:cD,moment:vD},repeat:{string:cD},__type__:{object:gD,array:mD}},itemsAlwaysDraggable:{item:{boolean:uD,undefined:"undefined"},range:{boolean:uD,undefined:"undefined"},__type__:{boolean:uD,object:gD}},limitSize:{boolean:uD},locale:{string:cD},locales:{__any__:{any:"any"},__type__:{object:gD}},longSelectPressTime:{number:pD},margin:{axis:{number:pD},item:{horizontal:{number:pD,undefined:"undefined"},vertical:{number:pD,undefined:"undefined"},__type__:{object:gD,number:pD}},__type__:{object:gD,number:pD}},max:{date:fD,number:pD,string:cD,moment:vD},maxHeight:{number:pD,string:cD},maxMinorChars:{number:pD},min:{date:fD,number:pD,string:cD,moment:vD},minHeight:{number:pD,string:cD},moveable:{boolean:uD},multiselect:{boolean:uD},multiselectPerGroup:{boolean:uD},onAdd:{function:"function"},onDropObjectOnItem:{function:"function"},onUpdate:{function:"function"},onMove:{function:"function"},onMoving:{function:"function"},onRemove:{function:"function"},onAddGroup:{function:"function"},onMoveGroup:{function:"function"},onRemoveGroup:{function:"function"},onInitialDrawComplete:{function:"function"},order:{function:"function"},orientation:{axis:{string:cD,undefined:"undefined"},item:{string:cD,undefined:"undefined"},__type__:{string:cD,object:gD}},selectable:{boolean:uD},sequentialSelection:{boolean:uD},showCurrentTime:{boolean:uD},showMajorLabels:{boolean:uD},showMinorLabels:{boolean:uD},showWeekScale:{boolean:uD},stack:{boolean:uD},stackSubgroups:{boolean:uD},cluster:{maxItems:{number:pD,undefined:"undefined"},titleTemplate:{string:cD,undefined:"undefined"},clusterCriteria:{function:"function",undefined:"undefined"},showStipes:{boolean:uD,undefined:"undefined"},fitOnDoubleClick:{boolean:uD,undefined:"undefined"},__type__:{boolean:uD,object:gD}},snap:{function:"function",null:"null"},start:{date:fD,number:pD,string:cD,moment:vD},template:{function:"function"},loadingScreenTemplate:{function:"function"},groupTemplate:{function:"function"},visibleFrameTemplate:{string:cD,function:"function"},showTooltips:{boolean:uD},tooltip:{followMouse:{boolean:uD},overflowMethod:{string:["cap","flip","none"]},delay:{number:pD},template:{function:"function"},__type__:{object:gD}},tooltipOnItemUpdateTime:{template:{function:"function"},__type__:{boolean:uD,object:gD}},timeAxis:{scale:{string:cD,undefined:"undefined"},step:{number:pD,undefined:"undefined"},__type__:{object:gD}},type:{string:cD},width:{string:cD,number:pD},preferZoom:{boolean:uD},zoomable:{boolean:uD},zoomKey:{string:["ctrlKey","altKey","shiftKey","metaKey",""]},zoomFriction:{number:pD},zoomMax:{number:pD},zoomMin:{number:pD},xss:{disabled:{boolean:uD},filterOptions:{__any__:{any:"any"},__type__:{object:gD}},__type__:{object:gD}},__type__:{object:gD}},yD={global:{align:["center","left","right"],alignCurrentTime:["none","year","month","quarter","week","isoWeek","day","date","hour","minute","second"],direction:!1,autoResize:!0,clickToUse:!1,editable:{add:!1,remove:!1,updateGroup:!1,updateTime:!1},end:"",format:{minorLabels:{millisecond:"SSS",second:"s",minute:"HH:mm",hour:"HH:mm",weekday:"ddd D",day:"D",week:"w",month:"MMM",year:"YYYY"},majorLabels:{millisecond:"HH:mm:ss",second:"D MMMM HH:mm",minute:"ddd D MMMM",hour:"ddd D MMMM",weekday:"MMMM YYYY",day:"MMMM YYYY",week:"MMMM YYYY",month:"YYYY",year:""}},groupHeightMode:["auto","fixed","fitItems"],groupsDraggable:!1,height:"",locale:"",longSelectPressTime:251,margin:{axis:[20,0,100,1],item:{horizontal:[10,0,100,1],vertical:[10,0,100,1]}},max:"",maxHeight:"",maxMinorChars:[7,0,20,1],min:"",minHeight:"",moveable:!1,multiselect:!1,multiselectPerGroup:!1,orientation:{axis:["both","bottom","top"],item:["bottom","top"]},preferZoom:!1,selectable:!0,showCurrentTime:!1,showMajorLabels:!0,showMinorLabels:!0,stack:!0,stackSubgroups:!0,cluster:!1,start:"",showTooltips:!0,tooltip:{followMouse:!1,overflowMethod:"flip",delay:[500,0,99999,100]},tooltipOnItemUpdateTime:!1,type:["box","point","range","background"],width:"100%",zoomable:!0,zoomKey:["ctrlKey","altKey","shiftKey","metaKey",""],zoomMax:[31536e10,10,31536e10,1],zoomMin:[10,10,31536e10,1],xss:{disabled:!1}}};var _D,wD,xD,kD,DD,SD,CD,TD,MD,OD,ED,PD={};function AD(){if(wD)return _D;wD=1;var t=Yo(),e=Ha(),i=ea();return _D=function(n){for(var o=t(this),s=i(o),r=arguments.length,a=e(r>1?arguments[1]:void 0,s),l=r>2?arguments[2]:void 0,h=void 0===l?s:e(l,s);h>a;)o[a++]=n;return o},_D}function ID(){return DD?kD:(DD=1,function(){if(xD)return PD;xD=1;var t=bs(),e=AD(),i=Gc();t({target:"Array",proto:!0},{fill:e}),i("fill")}(),kD=zs()("Array","fill"))}function ND(){if(CD)return SD;CD=1;var t=qn(),e=ID(),i=Array.prototype;return SD=function(n){var o=n.fill;return n===i||t(i,n)&&o===i.fill?e:o},SD}function LD(){return MD?TD:(MD=1,TD=ND())}var FD=n(ED?OD:(ED=1,OD=LD())),RD={black:"#000000",navy:"#000080",darkblue:"#00008B",mediumblue:"#0000CD",blue:"#0000FF",darkgreen:"#006400",green:"#008000",teal:"#008080",darkcyan:"#008B8B",deepskyblue:"#00BFFF",darkturquoise:"#00CED1",mediumspringgreen:"#00FA9A",lime:"#00FF00",springgreen:"#00FF7F",aqua:"#00FFFF",cyan:"#00FFFF",midnightblue:"#191970",dodgerblue:"#1E90FF",lightseagreen:"#20B2AA",forestgreen:"#228B22",seagreen:"#2E8B57",darkslategray:"#2F4F4F",limegreen:"#32CD32",mediumseagreen:"#3CB371",turquoise:"#40E0D0",royalblue:"#4169E1",steelblue:"#4682B4",darkslateblue:"#483D8B",mediumturquoise:"#48D1CC",indigo:"#4B0082",darkolivegreen:"#556B2F",cadetblue:"#5F9EA0",cornflowerblue:"#6495ED",mediumaquamarine:"#66CDAA",dimgray:"#696969",slateblue:"#6A5ACD",olivedrab:"#6B8E23",slategray:"#708090",lightslategray:"#778899",mediumslateblue:"#7B68EE",lawngreen:"#7CFC00",chartreuse:"#7FFF00",aquamarine:"#7FFFD4",maroon:"#800000",purple:"#800080",olive:"#808000",gray:"#808080",skyblue:"#87CEEB",lightskyblue:"#87CEFA",blueviolet:"#8A2BE2",darkred:"#8B0000",darkmagenta:"#8B008B",saddlebrown:"#8B4513",darkseagreen:"#8FBC8F",lightgreen:"#90EE90",mediumpurple:"#9370D8",darkviolet:"#9400D3",palegreen:"#98FB98",darkorchid:"#9932CC",yellowgreen:"#9ACD32",sienna:"#A0522D",brown:"#A52A2A",darkgray:"#A9A9A9",lightblue:"#ADD8E6",greenyellow:"#ADFF2F",paleturquoise:"#AFEEEE",lightsteelblue:"#B0C4DE",powderblue:"#B0E0E6",firebrick:"#B22222",darkgoldenrod:"#B8860B",mediumorchid:"#BA55D3",rosybrown:"#BC8F8F",darkkhaki:"#BDB76B",silver:"#C0C0C0",mediumvioletred:"#C71585",indianred:"#CD5C5C",peru:"#CD853F",chocolate:"#D2691E",tan:"#D2B48C",lightgrey:"#D3D3D3",palevioletred:"#D87093",thistle:"#D8BFD8",orchid:"#DA70D6",goldenrod:"#DAA520",crimson:"#DC143C",gainsboro:"#DCDCDC",plum:"#DDA0DD",burlywood:"#DEB887",lightcyan:"#E0FFFF",lavender:"#E6E6FA",darksalmon:"#E9967A",violet:"#EE82EE",palegoldenrod:"#EEE8AA",lightcoral:"#F08080",khaki:"#F0E68C",aliceblue:"#F0F8FF",honeydew:"#F0FFF0",azure:"#F0FFFF",sandybrown:"#F4A460",wheat:"#F5DEB3",beige:"#F5F5DC",whitesmoke:"#F5F5F5",mintcream:"#F5FFFA",ghostwhite:"#F8F8FF",salmon:"#FA8072",antiquewhite:"#FAEBD7",linen:"#FAF0E6",lightgoldenrodyellow:"#FAFAD2",oldlace:"#FDF5E6",red:"#FF0000",fuchsia:"#FF00FF",magenta:"#FF00FF",deeppink:"#FF1493",orangered:"#FF4500",tomato:"#FF6347",hotpink:"#FF69B4",coral:"#FF7F50",darkorange:"#FF8C00",lightsalmon:"#FFA07A",orange:"#FFA500",lightpink:"#FFB6C1",pink:"#FFC0CB",gold:"#FFD700",peachpuff:"#FFDAB9",navajowhite:"#FFDEAD",moccasin:"#FFE4B5",bisque:"#FFE4C4",mistyrose:"#FFE4E1",blanchedalmond:"#FFEBCD",papayawhip:"#FFEFD5",lavenderblush:"#FFF0F5",seashell:"#FFF5EE",cornsilk:"#FFF8DC",lemonchiffon:"#FFFACD",floralwhite:"#FFFAF0",snow:"#FFFAFA",yellow:"#FFFF00",lightyellow:"#FFFFE0",ivory:"#FFFFF0",white:"#FFFFFF"};class YD{constructor(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:1;this.pixelRatio=t,this.generated=!1,this.centerCoordinates={x:144.5,y:144.5},this.r=289*.49,this.color={r:255,g:255,b:255,a:1},this.hueCircle=void 0,this.initialColor={r:255,g:255,b:255,a:1},this.previousColor=void 0,this.applied=!1,this.updateCallback=()=>{},this.closeCallback=()=>{},this._create()}insertTo(t){void 0!==this.hammer&&(this.hammer.destroy(),this.hammer=void 0),this.container=t,this.container.appendChild(this.frame),this._bindHammer(),this._setSize()}setUpdateCallback(t){if("function"!=typeof t)throw new Error("Function attempted to set as colorPicker update callback is not a function.");this.updateCallback=t}setCloseCallback(t){if("function"!=typeof t)throw new Error("Function attempted to set as colorPicker closing callback is not a function.");this.closeCallback=t}_isColorString(t){if("string"==typeof t)return RD[t]}setColor(t){let e,i=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];if("none"!==t){var n=this._isColorString(t);if(void 0!==n&&(t=n),!0===of.isString(t)){if(!0===of.isValidRGB(t)){let i=t.substr(4).substr(0,t.length-5).split(",");e={r:i[0],g:i[1],b:i[2],a:1}}else if(!0===of.isValidRGBA(t)){let i=t.substr(5).substr(0,t.length-6).split(",");e={r:i[0],g:i[1],b:i[2],a:i[3]}}else if(!0===of.isValidHex(t)){let i=of.hexToRGB(t);e={r:i.r,g:i.g,b:i.b,a:1}}}else if(t instanceof Object&&void 0!==t.r&&void 0!==t.g&&void 0!==t.b){let i=void 0!==t.a?t.a:"1.0";e={r:t.r,g:t.g,b:t.b,a:i}}if(void 0===e)throw new Error("Unknown color passed to the colorPicker. Supported are strings: rgb, hex, rgba. Object: rgb ({r:r,g:g,b:b,[a:a]}). Supplied: "+Wf(t));this._setColor(e,i)}}show(){void 0!==this.closeCallback&&(this.closeCallback(),this.closeCallback=void 0),this.applied=!1,this.frame.style.display="block",this._generateHueCircle()}_hide(){!0===(!(arguments.length>0&&void 0!==arguments[0])||arguments[0])&&(this.previousColor=of.extend({},this.color)),!0===this.applied&&this.updateCallback(this.initialColor),this.frame.style.display="none",vr(()=>{void 0!==this.closeCallback&&(this.closeCallback(),this.closeCallback=void 0)},0)}_save(){this.updateCallback(this.color),this.applied=!1,this._hide()}_apply(){this.applied=!0,this.updateCallback(this.color),this._updatePicker(this.color)}_loadLast(){void 0!==this.previousColor?this.setColor(this.previousColor,!1):alert("There is no last color to load...")}_setColor(t){!0===(!(arguments.length>1&&void 0!==arguments[1])||arguments[1])&&(this.initialColor=of.extend({},t)),this.color=t;let e=of.RGBToHSV(t.r,t.g,t.b),i=2*Math.PI,n=this.r*e.s,o=this.centerCoordinates.x+n*Math.sin(i*e.h),s=this.centerCoordinates.y+n*Math.cos(i*e.h);this.colorPickerSelector.style.left=o-.5*this.colorPickerSelector.clientWidth+"px",this.colorPickerSelector.style.top=s-.5*this.colorPickerSelector.clientHeight+"px",this._updatePicker(t)}_setOpacity(t){this.color.a=t/100,this._updatePicker(this.color)}_setBrightness(t){let e=of.RGBToHSV(this.color.r,this.color.g,this.color.b);e.v=t/100;let i=of.HSVToRGB(e.h,e.s,e.v);i.a=this.color.a,this.color=i,this._updatePicker()}_updatePicker(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.color,e=of.RGBToHSV(t.r,t.g,t.b),i=this.colorPickerCanvas.getContext("2d");void 0===this.pixelRation&&(this.pixelRatio=(window.devicePixelRatio||1)/(i.webkitBackingStorePixelRatio||i.mozBackingStorePixelRatio||i.msBackingStorePixelRatio||i.oBackingStorePixelRatio||i.backingStorePixelRatio||1)),i.setTransform(this.pixelRatio,0,0,this.pixelRatio,0,0);let n=this.colorPickerCanvas.clientWidth,o=this.colorPickerCanvas.clientHeight;i.clearRect(0,0,n,o),i.putImageData(this.hueCircle,0,0),i.fillStyle="rgba(0,0,0,"+(1-e.v)+")",i.circle(this.centerCoordinates.x,this.centerCoordinates.y,this.r),FD(i).call(i),this.brightnessRange.value=100*e.v,this.opacityRange.value=100*t.a,this.initialColorDiv.style.backgroundColor="rgba("+this.initialColor.r+","+this.initialColor.g+","+this.initialColor.b+","+this.initialColor.a+")",this.newColorDiv.style.backgroundColor="rgba("+this.color.r+","+this.color.g+","+this.color.b+","+this.color.a+")"}_setSize(){this.colorPickerCanvas.style.width="100%",this.colorPickerCanvas.style.height="100%",this.colorPickerCanvas.width=289*this.pixelRatio,this.colorPickerCanvas.height=289*this.pixelRatio}_create(){var t,e,i,n;if(this.frame=document.createElement("div"),this.frame.className="vis-color-picker",this.colorPickerDiv=document.createElement("div"),this.colorPickerSelector=document.createElement("div"),this.colorPickerSelector.className="vis-selector",this.colorPickerDiv.appendChild(this.colorPickerSelector),this.colorPickerCanvas=document.createElement("canvas"),this.colorPickerDiv.appendChild(this.colorPickerCanvas),this.colorPickerCanvas.getContext){let t=this.colorPickerCanvas.getContext("2d");this.pixelRatio=(window.devicePixelRatio||1)/(t.webkitBackingStorePixelRatio||t.mozBackingStorePixelRatio||t.msBackingStorePixelRatio||t.oBackingStorePixelRatio||t.backingStorePixelRatio||1),this.colorPickerCanvas.getContext("2d").setTransform(this.pixelRatio,0,0,this.pixelRatio,0,0)}else{let t=document.createElement("DIV");t.style.color="red",t.style.fontWeight="bold",t.style.padding="10px",t.innerHTML="Error: your browser does not support HTML canvas",this.colorPickerCanvas.appendChild(t)}this.colorPickerDiv.className="vis-color",this.opacityDiv=document.createElement("div"),this.opacityDiv.className="vis-opacity",this.brightnessDiv=document.createElement("div"),this.brightnessDiv.className="vis-brightness",this.arrowDiv=document.createElement("div"),this.arrowDiv.className="vis-arrow",this.opacityRange=document.createElement("input");try{this.opacityRange.type="range",this.opacityRange.min="0",this.opacityRange.max="100"}catch(t){}this.opacityRange.value="100",this.opacityRange.className="vis-range",this.brightnessRange=document.createElement("input");try{this.brightnessRange.type="range",this.brightnessRange.min="0",this.brightnessRange.max="100"}catch(t){}this.brightnessRange.value="100",this.brightnessRange.className="vis-range",this.opacityDiv.appendChild(this.opacityRange),this.brightnessDiv.appendChild(this.brightnessRange);var o=this;this.opacityRange.onchange=function(){o._setOpacity(this.value)},this.opacityRange.oninput=function(){o._setOpacity(this.value)},this.brightnessRange.onchange=function(){o._setBrightness(this.value)},this.brightnessRange.oninput=function(){o._setBrightness(this.value)},this.brightnessLabel=document.createElement("div"),this.brightnessLabel.className="vis-label vis-brightness",this.brightnessLabel.innerHTML="brightness:",this.opacityLabel=document.createElement("div"),this.opacityLabel.className="vis-label vis-opacity",this.opacityLabel.innerHTML="opacity:",this.newColorDiv=document.createElement("div"),this.newColorDiv.className="vis-new-color",this.newColorDiv.innerHTML="new",this.initialColorDiv=document.createElement("div"),this.initialColorDiv.className="vis-initial-color",this.initialColorDiv.innerHTML="initial",this.cancelButton=document.createElement("div"),this.cancelButton.className="vis-button vis-cancel",this.cancelButton.innerHTML="cancel",this.cancelButton.onclick=Js(t=this._hide).call(t,this,!1),this.applyButton=document.createElement("div"),this.applyButton.className="vis-button vis-apply",this.applyButton.innerHTML="apply",this.applyButton.onclick=Js(e=this._apply).call(e,this),this.saveButton=document.createElement("div"),this.saveButton.className="vis-button vis-save",this.saveButton.innerHTML="save",this.saveButton.onclick=Js(i=this._save).call(i,this),this.loadButton=document.createElement("div"),this.loadButton.className="vis-button vis-load",this.loadButton.innerHTML="load last",this.loadButton.onclick=Js(n=this._loadLast).call(n,this),this.frame.appendChild(this.colorPickerDiv),this.frame.appendChild(this.arrowDiv),this.frame.appendChild(this.brightnessLabel),this.frame.appendChild(this.brightnessDiv),this.frame.appendChild(this.opacityLabel),this.frame.appendChild(this.opacityDiv),this.frame.appendChild(this.newColorDiv),this.frame.appendChild(this.initialColorDiv),this.frame.appendChild(this.cancelButton),this.frame.appendChild(this.applyButton),this.frame.appendChild(this.saveButton),this.frame.appendChild(this.loadButton)}_bindHammer(){this.drag={},this.pinch={},this.hammer=new yb(this.colorPickerCanvas),this.hammer.get("pinch").set({enable:!0}),_b(this.hammer,t=>{this._moveSelector(t)}),this.hammer.on("tap",t=>{this._moveSelector(t)}),this.hammer.on("panstart",t=>{this._moveSelector(t)}),this.hammer.on("panmove",t=>{this._moveSelector(t)}),this.hammer.on("panend",t=>{this._moveSelector(t)})}_generateHueCircle(){if(!1===this.generated){let t=this.colorPickerCanvas.getContext("2d");void 0===this.pixelRation&&(this.pixelRatio=(window.devicePixelRatio||1)/(t.webkitBackingStorePixelRatio||t.mozBackingStorePixelRatio||t.msBackingStorePixelRatio||t.oBackingStorePixelRatio||t.backingStorePixelRatio||1)),t.setTransform(this.pixelRatio,0,0,this.pixelRatio,0,0);let e,i,n,o,s=this.colorPickerCanvas.clientWidth,r=this.colorPickerCanvas.clientHeight;t.clearRect(0,0,s,r),this.centerCoordinates={x:.5*s,y:.5*r},this.r=.49*s;let a,l=2*Math.PI/360,h=1/360,d=1/this.r;for(n=0;n<360;n++)for(o=0;o<this.r;o++)e=this.centerCoordinates.x+o*Math.sin(l*n),i=this.centerCoordinates.y+o*Math.cos(l*n),a=of.HSVToRGB(n*h,o*d,1),t.fillStyle="rgb("+a.r+","+a.g+","+a.b+")",t.fillRect(e-.5,i-.5,2,2);t.strokeStyle="rgba(0,0,0,1)",t.circle(this.centerCoordinates.x,this.centerCoordinates.y,this.r),t.stroke(),this.hueCircle=t.getImageData(0,0,s,r)}this.generated=!0}_moveSelector(t){let e=this.colorPickerDiv.getBoundingClientRect(),i=t.center.x-e.left,n=t.center.y-e.top,o=.5*this.colorPickerDiv.clientHeight,s=.5*this.colorPickerDiv.clientWidth,r=i-s,a=n-o,l=Math.atan2(r,a),h=.98*Math.min(Math.sqrt(r*r+a*a),s),d=Math.cos(l)*h+o,c=Math.sin(l)*h+s;this.colorPickerSelector.style.top=d-.5*this.colorPickerSelector.clientHeight+"px",this.colorPickerSelector.style.left=c-.5*this.colorPickerSelector.clientWidth+"px";let u=l/(2*Math.PI);u=u<0?u+1:u;let p=h/this.r,m=of.RGBToHSV(this.color.r,this.color.g,this.color.b);m.h=u,m.s=p;let f=of.HSVToRGB(m.h,m.s,m.v);f.a=this.color.a,this.color=f,this.initialColorDiv.style.backgroundColor="rgba("+this.initialColor.r+","+this.initialColor.g+","+this.initialColor.b+","+this.initialColor.a+")",this.newColorDiv.style.backgroundColor="rgba("+this.color.r+","+this.color.g+","+this.color.b+","+this.color.a+")"}}class jD{constructor(t,e,i){let n=arguments.length>3&&void 0!==arguments[3]?arguments[3]:1;this.parent=t,this.changedOptions=[],this.container=e,this.allowCreation=!1,this.options={},this.initialized=!1,this.popupCounter=0,this.defaultOptions={enabled:!1,filter:!0,container:void 0,showButton:!0},of.extend(this.options,this.defaultOptions),this.configureOptions=i,this.moduleOptions={},this.domElements=[],this.popupDiv={},this.popupLimit=5,this.popupHistory={},this.colorPicker=new YD(n),this.wrapper=void 0}setOptions(t){if(void 0!==t){this.popupHistory={},this._removePopup();let e=!0;if("string"==typeof t)this.options.filter=t;else if(Rs(t))this.options.filter=t.join();else if("object"==typeof t){if(null==t)throw new TypeError("options cannot be null");void 0!==t.container&&(this.options.container=t.container),void 0!==Th(t)&&(this.options.filter=Th(t)),void 0!==t.showButton&&(this.options.showButton=t.showButton),void 0!==t.enabled&&(e=t.enabled)}else"boolean"==typeof t?(this.options.filter=!0,e=t):"function"==typeof t&&(this.options.filter=t,e=!0);!1===Th(this.options)&&(e=!1),this.options.enabled=e}this._clean()}setModuleOptions(t){this.moduleOptions=t,!0===this.options.enabled&&(this._clean(),void 0!==this.options.container&&(this.container=this.options.container),this._create())}_create(){this._clean(),this.changedOptions=[];let t=Th(this.options),e=0,i=!1;for(let n in this.configureOptions)this.configureOptions.hasOwnProperty(n)&&(this.allowCreation=!1,i=!1,"function"==typeof t?(i=t(n,[]),i=i||this._handleObject(this.configureOptions[n],[n],!0)):!0!==t&&-1===Bv(t).call(t,n)||(i=!0),!1!==i&&(this.allowCreation=!0,e>0&&this._makeItem([]),this._makeHeader(n),this._handleObject(this.configureOptions[n],[n])),e++);this._makeButton(),this._push()}_push(){this.wrapper=document.createElement("div"),this.wrapper.className="vis-configuration-wrapper",this.container.appendChild(this.wrapper);for(var t=0;t<this.domElements.length;t++)this.wrapper.appendChild(this.domElements[t]);this._showPopupIfNeeded()}_clean(){for(var t=0;t<this.domElements.length;t++)this.wrapper.removeChild(this.domElements[t]);void 0!==this.wrapper&&(this.container.removeChild(this.wrapper),this.wrapper=void 0),this.domElements=[],this._removePopup()}_getValue(t){let e=this.moduleOptions;for(let i=0;i<t.length;i++){if(void 0===e[t[i]]){e=void 0;break}e=e[t[i]]}return e}_makeItem(t){if(!0===this.allowCreation){let o=document.createElement("div");o.className="vis-configuration vis-config-item vis-config-s"+t.length;for(var e=arguments.length,i=new Array(e>1?e-1:0),n=1;n<e;n++)i[n-1]=arguments[n];return ua(i).call(i,t=>{o.appendChild(t)}),this.domElements.push(o),this.domElements.length}return 0}_makeHeader(t){let e=document.createElement("div");e.className="vis-configuration vis-config-header",e.innerHTML=of.xss(t),this._makeItem([],e)}_makeLabel(t,e){let i=arguments.length>2&&void 0!==arguments[2]&&arguments[2],n=document.createElement("div");return n.className="vis-configuration vis-config-label vis-config-s"+e.length,n.innerHTML=!0===i?of.xss("<i><b>"+t+":</b></i>"):of.xss(t+":"),n}_makeDropdown(t,e,i){let n=document.createElement("select");n.className="vis-configuration vis-config-select";let o=0;void 0!==e&&-1!==Bv(t).call(t,e)&&(o=Bv(t).call(t,e));for(let e=0;e<t.length;e++){let i=document.createElement("option");i.value=t[e],e===o&&(i.selected="selected"),i.innerHTML=t[e],n.appendChild(i)}let s=this;n.onchange=function(){s._update(this.value,i)};let r=this._makeLabel(i[i.length-1],i);this._makeItem(i,r,n)}_makeRange(t,e,i){let n=t[0],o=t[1],s=t[2],r=t[3],a=document.createElement("input");a.className="vis-configuration vis-config-range";try{a.type="range",a.min=o,a.max=s}catch(t){}a.step=r;let l="",h=0;if(void 0!==e){let t=1.2;e<0&&e*t<o?(a.min=Math.ceil(e*t),h=a.min,l="range increased"):e/t<o&&(a.min=Math.ceil(e/t),h=a.min,l="range increased"),e*t>s&&1!==s&&(a.max=Math.ceil(e*t),h=a.max,l="range increased"),a.value=e}else a.value=n;let d=document.createElement("input");d.className="vis-configuration vis-config-rangeinput",d.value=Number(a.value);var c=this;a.onchange=function(){d.value=this.value,c._update(Number(this.value),i)},a.oninput=function(){d.value=this.value};let u=this._makeLabel(i[i.length-1],i),p=this._makeItem(i,u,a,d);""!==l&&this.popupHistory[p]!==h&&(this.popupHistory[p]=h,this._setupPopup(l,p))}_makeButton(){if(!0===this.options.showButton){let t=document.createElement("div");t.className="vis-configuration vis-config-button",t.innerHTML="generate options",t.onclick=()=>{this._printOptions()},t.onmouseover=()=>{t.className="vis-configuration vis-config-button hover"},t.onmouseout=()=>{t.className="vis-configuration vis-config-button"},this.optionsContainer=document.createElement("div"),this.optionsContainer.className="vis-configuration vis-config-option-container",this.domElements.push(this.optionsContainer),this.domElements.push(t)}}_setupPopup(t,e){if(!0===this.initialized&&!0===this.allowCreation&&this.popupCounter<this.popupLimit){let i=document.createElement("div");i.id="vis-configuration-popup",i.className="vis-configuration-popup",i.innerHTML=of.xss(t),i.onclick=()=>{this._removePopup()},this.popupCounter+=1,this.popupDiv={html:i,index:e}}}_removePopup(){void 0!==this.popupDiv.html&&(this.popupDiv.html.parentNode.removeChild(this.popupDiv.html),clearTimeout(this.popupDiv.hideTimeout),clearTimeout(this.popupDiv.deleteTimeout),this.popupDiv={})}_showPopupIfNeeded(){if(void 0!==this.popupDiv.html){let t=this.domElements[this.popupDiv.index].getBoundingClientRect();this.popupDiv.html.style.left=t.left+"px",this.popupDiv.html.style.top=t.top-30+"px",document.body.appendChild(this.popupDiv.html),this.popupDiv.hideTimeout=vr(()=>{this.popupDiv.html.style.opacity=0},1500),this.popupDiv.deleteTimeout=vr(()=>{this._removePopup()},1800)}}_makeCheckbox(t,e,i){var n=document.createElement("input");n.type="checkbox",n.className="vis-configuration vis-config-checkbox",n.checked=t,void 0!==e&&(n.checked=e,e!==t&&("object"==typeof t?e!==t.enabled&&this.changedOptions.push({path:i,value:e}):this.changedOptions.push({path:i,value:e})));let o=this;n.onchange=function(){o._update(this.checked,i)};let s=this._makeLabel(i[i.length-1],i);this._makeItem(i,s,n)}_makeTextInput(t,e,i){var n=document.createElement("input");n.type="text",n.className="vis-configuration vis-config-text",n.value=e,e!==t&&this.changedOptions.push({path:i,value:e});let o=this;n.onchange=function(){o._update(this.value,i)};let s=this._makeLabel(i[i.length-1],i);this._makeItem(i,s,n)}_makeColorField(t,e,i){let n=t[1],o=document.createElement("div");"none"!==(e=void 0===e?n:e)?(o.className="vis-configuration vis-config-colorBlock",o.style.backgroundColor=e):o.className="vis-configuration vis-config-colorBlock none",e=void 0===e?n:e,o.onclick=()=>{this._showColorPicker(e,o,i)};let s=this._makeLabel(i[i.length-1],i);this._makeItem(i,s,o)}_showColorPicker(t,e,i){e.onclick=function(){},this.colorPicker.insertTo(e),this.colorPicker.show(),this.colorPicker.setColor(t),this.colorPicker.setUpdateCallback(t=>{let n="rgba("+t.r+","+t.g+","+t.b+","+t.a+")";e.style.backgroundColor=n,this._update(n,i)}),this.colorPicker.setCloseCallback(()=>{e.onclick=()=>{this._showColorPicker(t,e,i)}})}_handleObject(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],i=arguments.length>2&&void 0!==arguments[2]&&arguments[2],n=!1,o=Th(this.options),s=!1;for(let r in t)if(t.hasOwnProperty(r)){n=!0;let a=t[r],l=of.copyAndExtendArray(e,r);if("function"==typeof o&&(n=o(r,e),!1===n&&!Rs(a)&&"string"!=typeof a&&"boolean"!=typeof a&&a instanceof Object&&(this.allowCreation=!1,n=this._handleObject(a,l,!0),this.allowCreation=!1===i)),!1!==n){s=!0;let t=this._getValue(l);if(Rs(a))this._handleArray(a,t,l);else if("string"==typeof a)this._makeTextInput(a,t,l);else if("boolean"==typeof a)this._makeCheckbox(a,t,l);else if(a instanceof Object){let t=!0;if(-1!==Bv(e).call(e,"physics")&&this.moduleOptions.physics.solver!==r&&(t=!1),!0===t)if(void 0!==a.enabled){let t=of.copyAndExtendArray(l,"enabled"),e=this._getValue(t);if(!0===e){let t=this._makeLabel(r,l,!0);this._makeItem(l,t),s=this._handleObject(a,l)||s}else this._makeCheckbox(a,e,l)}else{let t=this._makeLabel(r,l,!0);this._makeItem(l,t),s=this._handleObject(a,l)||s}}else console.error("dont know how to handle",a,r,l)}}return s}_handleArray(t,e,i){"string"==typeof t[0]&&"color"===t[0]?(this._makeColorField(t,e,i),t[1]!==e&&this.changedOptions.push({path:i,value:e})):"string"==typeof t[0]?(this._makeDropdown(t,e,i),t[0]!==e&&this.changedOptions.push({path:i,value:e})):"number"==typeof t[0]&&(this._makeRange(t,e,i),t[0]!==e&&this.changedOptions.push({path:i,value:Number(e)}))}_update(t,e){let i=this._constructOptions(t,e);this.parent.body&&this.parent.body.emitter&&this.parent.body.emitter.emit&&this.parent.body.emitter.emit("configChange",i),this.initialized=!0,this.parent.setOptions(i)}_constructOptions(t,e){let i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},n=i;t="false"!==(t="true"===t||t)&&t;for(let i=0;i<e.length;i++)"global"!==e[i]&&(void 0===n[e[i]]&&(n[e[i]]={}),i!==e.length-1?n=n[e[i]]:n[e[i]]=t);return i}_printOptions(){let t=this.getOptions();this.optionsContainer.innerHTML="<pre>var options = "+Wf(t,null,2)+"</pre>"}getOptions(){let t={};for(var e=0;e<this.changedOptions.length;e++)this._constructOptions(this.changedOptions[e].value,this.changedOptions[e].path,t);return t}}class HD extends iy{constructor(t,e,i,n){var o,s,r,a,l,h,d;if(super(),this.initTime=new Date,this.itemsDone=!1,!(this instanceof HD))throw new SyntaxError("Constructor must be called with the new operator");if(!Rs(i)&&!Zm(i)&&i instanceof Object){const t=n;n=i,i=t}n&&n.throttleRedraw&&console.warn('Timeline option "throttleRedraw" is DEPRICATED and no longer supported. It will be removed in the next MAJOR release.');const c=this;if(this.defaultOptions={autoResize:!0,longSelectPressTime:251,orientation:{axis:"bottom",item:"bottom"},moment:ma},this.options=of.deepExtend({},this.defaultOptions),n&&of.setupXSSProtection(n.xss),this._create(t),!n||n&&void 0===n.rtl){let t;this.dom.root.style.visibility="hidden";let e=this.dom.root;for(;!t&&e;)t=window.getComputedStyle(e,null).direction,e=e.parentElement;this.options.rtl=t&&"rtl"==t.toLowerCase()}else this.options.rtl=n.rtl;n&&(n.rollingMode&&(this.options.rollingMode=n.rollingMode),n.onInitialDrawComplete&&(this.options.onInitialDrawComplete=n.onInitialDrawComplete),n.onTimeout&&(this.options.onTimeout=n.onTimeout),n.loadingScreenTemplate&&(this.options.loadingScreenTemplate=n.loadingScreenTemplate));const u=document.createElement("div");if(this.options.loadingScreenTemplate){var p;const t=Js(p=this.options.loadingScreenTemplate).call(p,this),e=t(this.dom.loadingScreen);e instanceof Object&&!(e instanceof Element)?t(u):e instanceof Element?(u.innerHTML="",u.appendChild(e)):null!=e&&(u.innerHTML=of.xss(e))}function m(t,e){c.hasListeners(t)&&c.emit(t,c.getEventProperties(e))}this.dom.loadingScreen.appendChild(u),this.components=[],this.body={dom:this.dom,domProps:this.props,emitter:{on:Js(o=this.on).call(o,this),off:Js(s=this.off).call(s,this),emit:Js(r=this.emit).call(r,this)},hiddenDates:[],util:{getScale:()=>c.timeAxis.step.scale,getStep:()=>c.timeAxis.step.step,toScreen:Js(a=c._toScreen).call(a,c),toGlobalScreen:Js(l=c._toGlobalScreen).call(l,c),toTime:Js(h=c._toTime).call(h,c),toGlobalTime:Js(d=c._toGlobalTime).call(d,c)}},this.range=new bv(this.body,this.options),this.components.push(this.range),this.body.range=this.range,this.timeAxis=new Fb(this.body,this.options),this.timeAxis2=null,this.components.push(this.timeAxis),this.currentTime=new ny(this.body,this.options),this.components.push(this.currentTime),this.itemSet=new rD(this.body,this.options),this.components.push(this.itemSet),this.itemsData=null,this.groupsData=null,this.dom.root.onclick=t=>{m("click",t)},this.dom.root.ondblclick=t=>{m("doubleClick",t)},this.dom.root.oncontextmenu=t=>{m("contextmenu",t)},this.dom.root.onmouseover=t=>{m("mouseOver",t)},window.PointerEvent?(this.dom.root.onpointerdown=t=>{m("mouseDown",t)},this.dom.root.onpointermove=t=>{m("mouseMove",t)},this.dom.root.onpointerup=t=>{m("mouseUp",t)}):(this.dom.root.onmousemove=t=>{m("mouseMove",t)},this.dom.root.onmousedown=t=>{m("mouseDown",t)},this.dom.root.onmouseup=t=>{m("mouseUp",t)}),this.initialFitDone=!1,this.on("changed",()=>{if(null!=c.itemsData){if(!c.initialFitDone&&!c.options.rollingMode)if(c.initialFitDone=!0,null!=c.options.start||null!=c.options.end){if(null==c.options.start||null==c.options.end)var t=c.getItemRange();const e=null!=c.options.start?c.options.start:t.min,i=null!=c.options.end?c.options.end:t.max;c.setWindow(e,i,{animation:!1})}else c.fit({animation:!1});c.initialDrawDone||!c.initialRangeChangeDone&&(c.options.start||c.options.end)&&!c.options.rollingMode||(c.initialDrawDone=!0,c.itemSet.initialDrawDone=!0,c.dom.root.style.visibility="visible",c.dom.loadingScreen.parentNode.removeChild(c.dom.loadingScreen),c.options.onInitialDrawComplete&&vr(()=>c.options.onInitialDrawComplete(),0))}}),this.on("destroyTimeline",()=>{c.destroy()}),n&&this.setOptions(n),this.body.emitter.on("fit",t=>{this._onFit(t),this.redraw()}),i&&this.setGroups(i),e&&this.setItems(e),this._redraw()}_createConfigurator(){return new jD(this,this.dom.container,yD)}redraw(){this.itemSet&&this.itemSet.markDirty({refreshItems:!0}),this._redraw()}setOptions(t){if(!0===dD.validate(t,bD)&&console.log("%cErrors have been found in the supplied options object.",hD),iy.prototype.setOptions.call(this,t),"type"in t&&t.type!==this.options.type){this.options.type=t.type;const e=this.itemsData;if(e){const t=this.getSelection();this.setItems(null),this.setItems(e.rawDS),this.setSelection(t)}}}setItems(t){let e;this.itemsDone=!1,e=t?Zm(t)?Qm(t):Qm(new wi(t)):null,this.itemsData&&this.itemsData.dispose(),this.itemsData=e,this.itemSet&&this.itemSet.setItems(null!=e?e.rawDS:null)}setGroups(t){let e;const i=t=>!1!==t.visible;t?(Rs(t)&&(t=new wi(t)),e=new xi(t,{filter:i})):e=null,null!=this.groupsData&&"function"==typeof this.groupsData.setData&&this.groupsData.setData(null),this.groupsData=e,this.itemSet.setGroups(e)}setData(t){t&&t.groups&&this.setGroups(t.groups),t&&t.items&&this.setItems(t.items)}setSelection(t,e){this.itemSet&&this.itemSet.setSelection(t),e&&e.focus&&this.focus(t,e)}getSelection(){return this.itemSet&&this.itemSet.getSelection()||[]}focus(t,e){if(!this.itemsData||null==t)return;const i=Rs(t)?t:[t],n=this.itemsData.get(i);let o=null,s=null;if(ua(n).call(n,t=>{const e=t.start.valueOf(),i="end"in t?t.end.valueOf():t.start.valueOf();(null===o||e<o)&&(o=e),(null===s||i>s)&&(s=i)}),null!==o&&null!==s){const t=this,n=this.itemSet.items[i[0]];let r=-1*this._getScrollTop(),a=null;const l=(e,i,o)=>{const s=WD(t,n);if(!1===s)return;if(a||(a=s),a.itemTop==s.itemTop&&!a.shouldScroll)return;a.itemTop!=s.itemTop&&s.shouldScroll&&(a=s,r=-1*t._getScrollTop());const l=r,h=a.scrollOffset,d=o?h:l+(h-l)*e;t._setScrollTop(-d),i||t._redraw()},h=()=>{const e=WD(t,n);e.shouldScroll&&e.itemTop!=a.itemTop&&(t._setScrollTop(-e.scrollOffset),t._redraw())},d=()=>{h(),vr(h,100)},c=!e||void 0===e.zoom||e.zoom,u=(o+s)/2,p=c?1.1*(s-o):Math.max(this.range.end-this.range.start,1.1*(s-o)),m=!e||void 0===e.animation||e.animation;m||(a={shouldScroll:!1,scrollOffset:-1,itemTop:-1}),this.range.stopRolling(),this.range.setRange(u-p/2,u+p/2,{animation:m},d,l)}}fit(t,e){const i=!t||void 0===t.animation||t.animation;let n;1===this.itemsData.length&&void 0===this.itemsData.get()[0].end?(n=this.getDataRange(),this.moveTo(n.min.valueOf(),{animation:i},e)):(n=this.getItemRange(),this.range.setRange(n.min,n.max,{animation:i},e))}getItemRange(){const t=this.getDataRange();let e=null!==t.min?t.min.valueOf():null,i=null!==t.max?t.max.valueOf():null,n=null,o=null;if(null!=e&&null!=i){let t=i-e;t<=0&&(t=10);const s=t/this.props.center.width,r={};let a=0;ua(of).call(of,this.itemSet.items,(t,e)=>{if(t.groupShowing){const i=!0;r[e]=t.redraw(i),a=r[e].length}});if(a>0)for(let t=0;t<a;t++)ua(of).call(of,r,e=>{e[t]()});if(ua(of).call(of,this.itemSet.items,t=>{const r=zD(t),a=GD(t);let l,h;this.options.rtl?(l=r-(t.getWidthRight()+10)*s,h=a+(t.getWidthLeft()+10)*s):(l=r-(t.getWidthLeft()+10)*s,h=a+(t.getWidthRight()+10)*s),l<e&&(e=l,n=t),h>i&&(i=h,o=t)}),n&&o){const s=n.getWidthLeft()+10,r=o.getWidthRight()+10,a=this.props.center.width-s-r;a>0&&(this.options.rtl?(e=zD(n)-r*t/a,i=GD(o)+s*t/a):(e=zD(n)-s*t/a,i=GD(o)+r*t/a))}}return{min:null!=e?new Date(e):null,max:null!=i?new Date(i):null}}getDataRange(){let t=null,e=null;var i;this.itemsData&&ua(i=this.itemsData).call(i,i=>{const n=of.convert(i.start,"Date").valueOf(),o=of.convert(null!=i.end?i.end:i.start,"Date").valueOf();(null===t||n<t)&&(t=n),(null===e||o>e)&&(e=o)});return{min:null!=t?new Date(t):null,max:null!=e?new Date(e):null}}getEventProperties(t){const e=t.center?t.center.x:t.clientX,i=t.center?t.center.y:t.clientY,n=this.dom.centerContainer.getBoundingClientRect(),o=this.options.rtl?n.right-e:e-n.left,s=i-n.top,r=this.itemSet.itemFromTarget(t),a=this.itemSet.groupFromTarget(t),l=ey.customTimeFromTarget(t),h=this.itemSet.options.snap||null,d=this.body.util.getScale(),c=this.body.util.getStep(),u=this._toTime(o),p=h?h(u,d,c):u,m=of.getTarget(t);let f=null;return null!=r?f="item":null!=l?f="custom-time":of.hasParent(m,this.timeAxis.dom.foreground)||this.timeAxis2&&of.hasParent(m,this.timeAxis2.dom.foreground)?f="axis":of.hasParent(m,this.itemSet.dom.labelSet)?f="group-label":of.hasParent(m,this.currentTime.bar)?f="current-time":of.hasParent(m,this.dom.center)&&(f="background"),{event:t,item:r?r.id:null,isCluster:!!r&&!!r.isCluster,items:r?r.items||[]:null,group:a?a.groupId:null,customTime:l?l.options.id:null,what:f,pageX:t.srcEvent?t.srcEvent.pageX:t.pageX,pageY:t.srcEvent?t.srcEvent.pageY:t.pageY,x:o,y:s,time:u,snappedTime:p}}toggleRollingMode(){this.range.rolling?this.range.stopRolling():(null==this.options.rollingMode&&this.setOptions(this.options),this.range.startRolling())}_redraw(){iy.prototype._redraw.call(this)}_onFit(t){const{start:e,end:i,animation:n}=t;i?this.range.setRange(e,i,{animation:n}):this.moveTo(e.valueOf(),{animation:n})}}function zD(t){return of.convert(t.data.start,"Date").valueOf()}function GD(t){const e=null!=t.data.end?t.data.end:t.data.start;return of.convert(e,"Date").valueOf()}function WD(t,e){if(!e.parent)return!1;const i=t.options.rtl?t.props.rightContainer.height:t.props.leftContainer.height,n=t.props.center.height,o=e.parent;let s=o.top,r=!0;const a=t.timeAxis.options.orientation.axis,l=()=>"bottom"==a?o.height-e.top-e.height:e.top,h=-1*t._getScrollTop(),d=s+l(),c=e.height;return d<h?s+i<=s+l()+c&&(s+=l()-t.itemSet.options.margin.item.vertical):d+c>h+i?s+=l()+c-i+t.itemSet.options.margin.item.vertical:r=!1,s=Math.min(s,n-i),{shouldScroll:r,scrollOffset:s,itemTop:d}}class BD{constructor(t,e,i,n,o,s){let r=arguments.length>6&&void 0!==arguments[6]&&arguments[6],a=arguments.length>7&&void 0!==arguments[7]&&arguments[7];if(this.majorSteps=[1,2,5,10],this.minorSteps=[.25,.5,1,2],this.customLines=null,this.containerHeight=o,this.majorCharHeight=s,this._start=t,this._end=e,this.scale=1,this.minorStepIdx=-1,this.magnitudefactor=1,this.determineScale(),this.zeroAlign=r,this.autoScaleStart=i,this.autoScaleEnd=n,this.formattingFunction=a,i||n){const t=this,e=e=>{const i=e-e%(t.magnitudefactor*t.minorSteps[t.minorStepIdx]);return e%(t.magnitudefactor*t.minorSteps[t.minorStepIdx])>t.magnitudefactor*t.minorSteps[t.minorStepIdx]*.5?i+t.magnitudefactor*t.minorSteps[t.minorStepIdx]:i};i&&(this._start-=2*this.magnitudefactor*this.minorSteps[this.minorStepIdx],this._start=e(this._start)),n&&(this._end+=this.magnitudefactor*this.minorSteps[this.minorStepIdx],this._end=e(this._end)),this.determineScale()}}setCharHeight(t){this.majorCharHeight=t}setHeight(t){this.containerHeight=t}determineScale(){const t=this._end-this._start;this.scale=this.containerHeight/t;const e=this.majorCharHeight/this.scale,i=t>0?Math.round(Math.log(t)/Math.LN10):0;this.minorStepIdx=-1,this.magnitudefactor=Math.pow(10,i);let n=0;i<0&&(n=i);let o=!1;for(let t=n;Math.abs(t)<=Math.abs(i);t++){this.magnitudefactor=Math.pow(10,t);for(let t=0;t<this.minorSteps.length;t++){if(this.magnitudefactor*this.minorSteps[t]>=e){o=!0,this.minorStepIdx=t;break}}if(!0===o)break}}is_major(t){return t%(this.magnitudefactor*this.majorSteps[this.minorStepIdx])===0}getStep(){return this.magnitudefactor*this.minorSteps[this.minorStepIdx]}getFirstMajor(){const t=this.magnitudefactor*this.majorSteps[this.minorStepIdx];return this.convertValue(this._start+(t-this._start%t)%t)}formatValue(t){let e=t.toPrecision(5);return"function"==typeof this.formattingFunction&&(e=this.formattingFunction(t)),"number"==typeof e?"".concat(e):"string"==typeof e?e:t.toPrecision(5)}getLines(){const t=[],e=this.getStep(),i=(e-this._start%e)%e;for(let n=this._start+i;this._end-n>1e-5;n+=e)n!=this._start&&t.push({major:this.is_major(n),y:this.convertValue(n),val:this.formatValue(n)});return t}followScale(t){const e=this.minorStepIdx,i=this._start,n=this._end,o=this,s=()=>{o.magnitudefactor*=2},r=()=>{o.magnitudefactor/=2};t.minorStepIdx<=1&&this.minorStepIdx<=1||t.minorStepIdx>1&&this.minorStepIdx>1||(t.minorStepIdx<this.minorStepIdx?(this.minorStepIdx=1,2==e||s(),s()):(this.minorStepIdx=2,1==e||r(),r()));const a=t.convertValue(0),l=t.getStep()*t.scale;let h=!1,d=0;for(;!h&&d++<5;){this.scale=l/(this.minorSteps[this.minorStepIdx]*this.magnitudefactor);const e=this.containerHeight/this.scale;this._start=i,this._end=this._start+e;const o=this._end*this.scale,d=this.magnitudefactor*this.majorSteps[this.minorStepIdx],c=this.getFirstMajor()-t.getFirstMajor();if(this.zeroAlign){const t=a-o;this._end+=t/this.scale,this._start=this._end-e}else this.autoScaleStart?(this._start-=c/this.scale,this._end=this._start+e):(this._start+=d-c/this.scale,this._end=this._start+e);if(!this.autoScaleEnd&&this._end>n+1e-5)r(),h=!1;else{if(!this.autoScaleStart&&this._start<i-1e-5){if(!(this.zeroAlign&&i>=0)){r(),h=!1;continue}console.warn("Can't adhere to given 'min' range, due to zeroalign")}this.autoScaleStart&&this.autoScaleEnd&&e<n-i?(s(),h=!1):h=!0}}}convertValue(t){return this.containerHeight-(t-this._start)*this.scale}screenToValue(t){return(this.containerHeight-t)/this.scale+this._start}}class VD extends mg{constructor(t,e,i,n){super(),this.id=mi(),this.body=t,this.defaultOptions={orientation:"left",showMinorLabels:!0,showMajorLabels:!0,showWeekScale:!1,icons:!1,majorLinesOffset:7,minorLinesOffset:4,labelOffsetX:10,labelOffsetY:2,iconWidth:20,width:"40px",visible:!0,alignZeros:!0,left:{range:{min:void 0,max:void 0},format:t=>"".concat(pg(t.toPrecision(3))),title:{text:void 0,style:void 0}},right:{range:{min:void 0,max:void 0},format:t=>"".concat(pg(t.toPrecision(3))),title:{text:void 0,style:void 0}}},this.linegraphOptions=n,this.linegraphSVG=i,this.props={},this.DOMelements={lines:{},labels:{},title:{}},this.dom={},this.scale=void 0,this.range={start:0,end:0},this.options=of.extend({},this.defaultOptions),this.conversionFactor=1,this.setOptions(e),this.width=Number("".concat(this.options.width).replace("px","")),this.minWidth=this.width,this.height=this.linegraphSVG.getBoundingClientRect().height,this.hidden=!1,this.stepPixels=25,this.zeroCrossing=-1,this.amountOfSteps=-1,this.lineOffset=0,this.master=!0,this.masterAxis=null,this.svgElements={},this.iconsRemoved=!1,this.groups={},this.amountOfGroups=0,this._create(),null==this.scale&&this._redrawLabels(),this.framework={svg:this.svg,svgElements:this.svgElements,options:this.options,groups:this.groups};const o=this;this.body.emitter.on("verticalDrag",()=>{o.dom.lineContainer.style.top="".concat(o.body.domProps.scrollTop,"px")})}addGroup(t,e){this.groups.hasOwnProperty(t)||(this.groups[t]=e),this.amountOfGroups+=1}updateGroup(t,e){this.groups.hasOwnProperty(t)||(this.amountOfGroups+=1),this.groups[t]=e}removeGroup(t){this.groups.hasOwnProperty(t)&&(delete this.groups[t],this.amountOfGroups-=1)}setOptions(t){if(t){let e=!1;this.options.orientation!=t.orientation&&void 0!==t.orientation&&(e=!0);const i=["orientation","showMinorLabels","showMajorLabels","icons","majorLinesOffset","minorLinesOffset","labelOffsetX","labelOffsetY","iconWidth","width","visible","left","right","alignZeros"];of.selectiveDeepExtend(i,this.options,t),this.minWidth=Number("".concat(this.options.width).replace("px","")),!0===e&&this.dom.frame&&(this.hide(),this.show())}}_create(){this.dom.frame=document.createElement("div"),this.dom.frame.style.width=this.options.width,this.dom.frame.style.height=this.height,this.dom.lineContainer=document.createElement("div"),this.dom.lineContainer.style.width="100%",this.dom.lineContainer.style.height=this.height,this.dom.lineContainer.style.position="relative",this.dom.lineContainer.style.visibility="visible",this.dom.lineContainer.style.display="block",this.svg=document.createElementNS("http://www.w3.org/2000/svg","svg"),this.svg.style.position="absolute",this.svg.style.top="0px",this.svg.style.height="100%",this.svg.style.width="100%",this.svg.style.display="block",this.dom.frame.appendChild(this.svg)}_redrawGroupIcons(){let t;ei(this.svgElements);const e=this.options.iconWidth;let i=11.5;t="left"===this.options.orientation?4:this.width-e-4;const n=fm(this.groups);nv(n).call(n,(t,e)=>t<e?-1:1);for(const o of n)!0!==this.groups[o].visible||void 0!==this.linegraphOptions.visibility[o]&&!0!==this.linegraphOptions.visibility[o]||(this.groups[o].getLegend(e,15,this.framework,t,i),i+=19);ii(this.svgElements),this.iconsRemoved=!1}_cleanupIcons(){!1===this.iconsRemoved&&(ei(this.svgElements),ii(this.svgElements),this.iconsRemoved=!0)}show(){this.hidden=!1,this.dom.frame.parentNode||("left"===this.options.orientation?this.body.dom.left.appendChild(this.dom.frame):this.body.dom.right.appendChild(this.dom.frame)),this.dom.lineContainer.parentNode||this.body.dom.backgroundHorizontal.appendChild(this.dom.lineContainer),this.dom.lineContainer.style.display="block"}hide(){this.hidden=!0,this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame),this.dom.lineContainer.style.display="none"}setRange(t,e){this.range.start=t,this.range.end=e}redraw(){let t=!1,e=0;this.dom.lineContainer.style.top="".concat(this.body.domProps.scrollTop,"px");for(const t in this.groups)this.groups.hasOwnProperty(t)&&(!0!==this.groups[t].visible||void 0!==this.linegraphOptions.visibility[t]&&!0!==this.linegraphOptions.visibility[t]||e++);if(0===this.amountOfGroups||0===e)this.hide();else{this.show(),this.height=Number(this.linegraphSVG.style.height.replace("px","")),this.dom.lineContainer.style.height="".concat(this.height,"px"),this.width=!0===this.options.visible?Number("".concat(this.options.width).replace("px","")):0;const e=this.props,i=this.dom.frame;i.className="vis-data-axis",this._calculateCharSize();const n=this.options.orientation,o=this.options.showMinorLabels,s=this.options.showMajorLabels,r=this.body.dom.backgroundHorizontal.offsetWidth;e.minorLabelHeight=o?e.minorCharHeight:0,e.majorLabelHeight=s?e.majorCharHeight:0,e.minorLineWidth=r-this.lineOffset-this.width+2*this.options.minorLinesOffset,e.minorLineHeight=1,e.majorLineWidth=r-this.lineOffset-this.width+2*this.options.majorLinesOffset,e.majorLineHeight=1,"left"===n?(i.style.top="0",i.style.left="0",i.style.bottom="",i.style.width="".concat(this.width,"px"),i.style.height="".concat(this.height,"px"),this.props.width=this.body.domProps.left.width,this.props.height=this.body.domProps.left.height):(i.style.top="",i.style.bottom="0",i.style.left="0",i.style.width="".concat(this.width,"px"),i.style.height="".concat(this.height,"px"),this.props.width=this.body.domProps.right.width,this.props.height=this.body.domProps.right.height),t=this._redrawLabels(),t=this._isResized()||t,!0===this.options.icons?this._redrawGroupIcons():this._cleanupIcons(),this._redrawTitle(n)}return t}_redrawLabels(){let t=!1;ei(this.DOMelements.lines),ei(this.DOMelements.labels);const e=this.options.orientation,i=null!=this.options[e].range?this.options[e].range:{};let n=!0;null!=i.max&&(this.range.end=i.max,n=!1);let o=!0;null!=i.min&&(this.range.start=i.min,o=!1),this.scale=new BD(this.range.start,this.range.end,o,n,this.dom.frame.offsetHeight,this.props.majorCharHeight,this.options.alignZeros,this.options[e].format),!1===this.master&&null!=this.masterAxis?(this.scale.followScale(this.masterAxis.scale),this.dom.lineContainer.style.display="none"):this.dom.lineContainer.style.display="block",this.maxLabelSize=0;const s=this.scale.getLines();ua(s).call(s,t=>{const i=t.y,n=t.major;this.options.showMinorLabels&&!1===n&&this._redrawLabel(i-2,t.val,e,"vis-y-axis vis-minor",this.props.minorCharHeight),n&&i>=0&&this._redrawLabel(i-2,t.val,e,"vis-y-axis vis-major",this.props.majorCharHeight),!0===this.master&&(n?this._redrawLine(i,e,"vis-grid vis-horizontal vis-major",this.options.majorLinesOffset,this.props.majorLineWidth):this._redrawLine(i,e,"vis-grid vis-horizontal vis-minor",this.options.minorLinesOffset,this.props.minorLineWidth))});let r=0;void 0!==this.options[e].title&&void 0!==this.options[e].title.text&&(r=this.props.titleCharHeight);const a=!0===this.options.icons?Math.max(this.options.iconWidth,r)+this.options.labelOffsetX+15:r+this.options.labelOffsetX+15;return this.maxLabelSize>this.width-a&&!0===this.options.visible?(this.width=this.maxLabelSize+a,this.options.width="".concat(this.width,"px"),ii(this.DOMelements.lines),ii(this.DOMelements.labels),this.redraw(),t=!0):this.maxLabelSize<this.width-a&&!0===this.options.visible&&this.width>this.minWidth?(this.width=Math.max(this.minWidth,this.maxLabelSize+a),this.options.width="".concat(this.width,"px"),ii(this.DOMelements.lines),ii(this.DOMelements.labels),this.redraw(),t=!0):(ii(this.DOMelements.lines),ii(this.DOMelements.labels),t=!1),t}convertValue(t){return this.scale.convertValue(t)}screenToValue(t){return this.scale.screenToValue(t)}_redrawLabel(t,e,i,n,o){const s=si("div",this.DOMelements.labels,this.dom.frame);s.className=n,s.innerHTML=of.xss(e),"left"===i?(s.style.left="-".concat(this.options.labelOffsetX,"px"),s.style.textAlign="right"):(s.style.right="-".concat(this.options.labelOffsetX,"px"),s.style.textAlign="left"),s.style.top="".concat(t-.5*o+this.options.labelOffsetY,"px"),e+="";const r=Math.max(this.props.majorCharWidth,this.props.minorCharWidth);this.maxLabelSize<e.length*r&&(this.maxLabelSize=e.length*r)}_redrawLine(t,e,i,n,o){if(!0===this.master){const s=si("div",this.DOMelements.lines,this.dom.lineContainer);s.className=i,s.innerHTML="","left"===e?s.style.left="".concat(this.width-n,"px"):s.style.right="".concat(this.width-n,"px"),s.style.width="".concat(o,"px"),s.style.top="".concat(t,"px")}}_redrawTitle(t){if(ei(this.DOMelements.title),void 0!==this.options[t].title&&void 0!==this.options[t].title.text){const e=si("div",this.DOMelements.title,this.dom.frame);e.className="vis-y-axis vis-title vis-".concat(t),e.innerHTML=of.xss(this.options[t].title.text),void 0!==this.options[t].title.style&&of.addCssText(e,this.options[t].title.style),"left"===t?e.style.left="".concat(this.props.titleCharHeight,"px"):e.style.right="".concat(this.props.titleCharHeight,"px"),e.style.width="".concat(this.height,"px")}ii(this.DOMelements.title)}_calculateCharSize(){if(!("minorCharHeight"in this.props)){const t=document.createTextNode("0"),e=document.createElement("div");e.className="vis-y-axis vis-minor vis-measure",e.appendChild(t),this.dom.frame.appendChild(e),this.props.minorCharHeight=e.clientHeight,this.props.minorCharWidth=e.clientWidth,this.dom.frame.removeChild(e)}if(!("majorCharHeight"in this.props)){const t=document.createTextNode("0"),e=document.createElement("div");e.className="vis-y-axis vis-major vis-measure",e.appendChild(t),this.dom.frame.appendChild(e),this.props.majorCharHeight=e.clientHeight,this.props.majorCharWidth=e.clientWidth,this.dom.frame.removeChild(e)}if(!("titleCharHeight"in this.props)){const t=document.createTextNode("0"),e=document.createElement("div");e.className="vis-y-axis vis-title vis-measure",e.appendChild(t),this.dom.frame.appendChild(e),this.props.titleCharHeight=e.clientHeight,this.props.titleCharWidth=e.clientWidth,this.dom.frame.removeChild(e)}}}function UD(t,e){}function XD(t,e){return{style:(e=void 0===e?{}:e).style||t.options.drawPoints.style,styles:e.styles||t.options.drawPoints.styles,size:e.size||t.options.drawPoints.size,className:e.className||t.className}}function qD(t,e){}function ZD(t,e){}function KD(t,e,i,n){this.id=e;this.options=of.selectiveBridgeObject(["sampling","style","sort","yAxisOrientation","barChart","drawPoints","shaded","interpolation","zIndex","excludeFromStacking","excludeFromLegend"],i),this.usingDefaultStyle=void 0===t.className,this.groupsUsingDefaultStyles=n,this.zeroPosition=0,this.update(t),1==this.usingDefaultStyle&&(this.groupsUsingDefaultStyles[0]+=1),this.itemsData=[],this.visible=void 0===t.visible||t.visible}function $D(t,e,i,n){this.body=t,this.defaultOptions={enabled:!1,icons:!0,iconSize:20,iconSpacing:6,left:{visible:!0,position:"top-left"},right:{visible:!0,position:"top-right"}},this.side=i,this.options=of.extend({},this.defaultOptions),this.linegraphOptions=n,this.svgElements={},this.dom={},this.groups={},this.amountOfGroups=0,this._create(),this.framework={svg:this.svg,svgElements:this.svgElements,options:this.options,groups:this.groups},this.setOptions(e)}UD.draw=function(t,e,i,n){n=n||0;for(var o=function(t,e){var i=void 0;t.options&&t.options.drawPoints&&t.options.drawPoints.onRender&&"function"==typeof t.options.drawPoints.onRender&&(i=t.options.drawPoints.onRender);e.group.options&&e.group.options.drawPoints&&e.group.options.drawPoints.onRender&&"function"==typeof e.group.options.drawPoints.onRender&&(i=e.group.options.drawPoints.onRender);return i}(i,e),s=0;s<t.length;s++)if(o){var r=o(t[s],e);!0!==r&&"object"!=typeof r||ri(t[s].screen_x+n,t[s].screen_y,XD(e,r),i.svgElements,i.svg,t[s].label)}else ri(t[s].screen_x+n,t[s].screen_y,XD(e),i.svgElements,i.svg,t[s].label)},UD.drawIcon=function(t,e,i,n,o,s){var r=.5*o,a=oi("rect",s.svgElements,s.svg);a.setAttributeNS(null,"x",e),a.setAttributeNS(null,"y",i-r),a.setAttributeNS(null,"width",n),a.setAttributeNS(null,"height",2*r),a.setAttributeNS(null,"class","vis-outline"),ri(e+.5*n,i,XD(t),s.svgElements,s.svg)},qD.drawIcon=function(t,e,i,n,o,s){var r=.5*o,a=oi("rect",s.svgElements,s.svg);a.setAttributeNS(null,"x",e),a.setAttributeNS(null,"y",i-r),a.setAttributeNS(null,"width",n),a.setAttributeNS(null,"height",2*r),a.setAttributeNS(null,"class","vis-outline");var l=Math.round(.3*n),h=t.options.barChart.width/l,d=Math.round(.4*o),c=Math.round(.75*o),u=Math.round((n-2*l)/3);if(ai(e+.5*l+u,i+r-d-1,l,d,t.className+" vis-bar",s.svgElements,s.svg,t.style),ai(e+1.5*l+u+2,i+r-c-1,l,c,t.className+" vis-bar",s.svgElements,s.svg,t.style),1==t.options.drawPoints.enabled){var p={style:t.options.drawPoints.style,styles:t.options.drawPoints.styles,size:t.options.drawPoints.size/h,className:t.className};ri(e+.5*l+u,i+r-d-1,p,s.svgElements,s.svg),ri(e+1.5*l+u+2,i+r-c-1,p,s.svgElements,s.svg)}},qD.draw=function(t,e,i){var n,o,s,r,a,l,h=[],d={},c=0;for(a=0;a<t.length;a++)if("bar"===(r=i.groups[t[a]]).options.style&&!0===r.visible&&(void 0===i.options.groups.visibility[t[a]]||!0===i.options.groups.visibility[t[a]]))for(l=0;l<e[t[a]].length;l++)h.push({screen_x:e[t[a]][l].screen_x,screen_end:e[t[a]][l].screen_end,screen_y:e[t[a]][l].screen_y,x:e[t[a]][l].x,end:e[t[a]][l].end,y:e[t[a]][l].y,groupId:t[a],label:e[t[a]][l].label}),c+=1;if(0!==c)for(nv(h).call(h,function(t,e){return t.screen_x===e.screen_x?t.groupId<e.groupId?-1:1:t.screen_x-e.screen_x}),qD._getDataIntersections(d,h),a=0;a<h.length;a++){var u=null!=(r=i.groups[h[a].groupId]).options.barChart.minWidth?r.options.barChart.minWidth:.1*r.options.barChart.width,p=0;if(void 0===d[o=h[a].screen_x])a+1<h.length&&(n=Math.abs(h[a+1].screen_x-o)),s=qD._getSafeDrawData(n,r,u);else{var m=a+(d[o].amount-d[o].resolved);m<h.length&&(n=Math.abs(h[m].screen_x-o)),s=qD._getSafeDrawData(n,r,u),d[o].resolved+=1,!0===r.options.stack&&!0!==r.options.excludeFromStacking?h[a].screen_y<r.zeroPosition?(p=d[o].accumulatedNegative,d[o].accumulatedNegative+=r.zeroPosition-h[a].screen_y):(p=d[o].accumulatedPositive,d[o].accumulatedPositive+=r.zeroPosition-h[a].screen_y):!0===r.options.barChart.sideBySide&&(s.width=s.width/d[o].amount,s.offset+=d[o].resolved*s.width-.5*s.width*(d[o].amount+1))}let t=s.width,e=h[a].screen_x;if(null!=h[a].screen_end?(t=h[a].screen_end-h[a].screen_x,e+=.5*t):e+=s.offset,ai(e,h[a].screen_y-p,t,r.zeroPosition-h[a].screen_y,r.className+" vis-bar",i.svgElements,i.svg,r.style),!0===r.options.drawPoints.enabled){let t={screen_x:h[a].screen_x,screen_y:h[a].screen_y-p,x:h[a].x,y:h[a].y,groupId:h[a].groupId,label:h[a].label};UD.draw([t],r,i,s.offset)}}},qD._getDataIntersections=function(t,e){for(var i,n=0;n<e.length;n++)n+1<e.length&&(i=Math.abs(e[n+1].screen_x-e[n].screen_x)),n>0&&(i=Math.min(i,Math.abs(e[n-1].screen_x-e[n].screen_x))),0===i&&(void 0===t[e[n].screen_x]&&(t[e[n].screen_x]={amount:0,resolved:0,accumulatedPositive:0,accumulatedNegative:0}),t[e[n].screen_x].amount+=1)},qD._getSafeDrawData=function(t,e,i){var n,o;return t<e.options.barChart.width&&t>0?(n=t<i?i:t,o=0,"left"===e.options.barChart.align?o-=.5*t:"right"===e.options.barChart.align&&(o+=.5*t)):(n=e.options.barChart.width,o=0,"left"===e.options.barChart.align?o-=.5*e.options.barChart.width:"right"===e.options.barChart.align&&(o+=.5*e.options.barChart.width)),{width:n,offset:o}},qD.getStackedYRange=function(t,e,i,n,o){if(t.length>0){nv(t).call(t,function(t,e){return t.screen_x===e.screen_x?t.groupId<e.groupId?-1:1:t.screen_x-e.screen_x});var s={};qD._getDataIntersections(s,t),e[n]=qD._getStackedYRange(s,t),e[n].yAxisOrientation=o,i.push(n)}},qD._getStackedYRange=function(t,e){for(var i,n=e[0].screen_y,o=e[0].screen_y,s=0;s<e.length;s++)void 0===t[i=e[s].screen_x]?(n=n>e[s].screen_y?e[s].screen_y:n,o=o<e[s].screen_y?e[s].screen_y:o):e[s].screen_y<0?t[i].accumulatedNegative+=e[s].screen_y:t[i].accumulatedPositive+=e[s].screen_y;for(var r in t)t.hasOwnProperty(r)&&(n=(n=n>t[r].accumulatedNegative?t[r].accumulatedNegative:n)>t[r].accumulatedPositive?t[r].accumulatedPositive:n,o=(o=o<t[r].accumulatedNegative?t[r].accumulatedNegative:o)<t[r].accumulatedPositive?t[r].accumulatedPositive:o);return{min:n,max:o}},ZD.calcPath=function(t,e){if(null!=t&&t.length>0){return 1==e.options.interpolation.enabled?ZD._catmullRom(t,e):ZD._linear(t)}},ZD.drawIcon=function(t,e,i,n,o,s){var r,a,l=.5*o,h=oi("rect",s.svgElements,s.svg);(h.setAttributeNS(null,"x",e),h.setAttributeNS(null,"y",i-l),h.setAttributeNS(null,"width",n),h.setAttributeNS(null,"height",2*l),h.setAttributeNS(null,"class","vis-outline"),(r=oi("path",s.svgElements,s.svg)).setAttributeNS(null,"class",t.className),void 0!==t.style&&r.setAttributeNS(null,"style",t.style),r.setAttributeNS(null,"d","M"+e+","+i+" L"+(e+n)+","+i),1==t.options.shaded.enabled&&(a=oi("path",s.svgElements,s.svg),"top"==t.options.shaded.orientation?a.setAttributeNS(null,"d","M"+e+", "+(i-l)+"L"+e+","+i+" L"+(e+n)+","+i+" L"+(e+n)+","+(i-l)):a.setAttributeNS(null,"d","M"+e+","+i+" L"+e+","+(i+l)+" L"+(e+n)+","+(i+l)+"L"+(e+n)+","+i),a.setAttributeNS(null,"class",t.className+" vis-icon-fill"),void 0!==t.options.shaded.style&&""!==t.options.shaded.style&&a.setAttributeNS(null,"style",t.options.shaded.style)),1==t.options.drawPoints.enabled)&&ri(e+.5*n,i,{style:t.options.drawPoints.style,styles:t.options.drawPoints.styles,size:t.options.drawPoints.size,className:t.className},s.svgElements,s.svg)},ZD.drawShading=function(t,e,i,n){if(1==e.options.shaded.enabled){var o,s=Number(n.svg.style.height.replace("px","")),r=oi("path",n.svgElements,n.svg),a="L";1==e.options.interpolation.enabled&&(a="C");var l=0;l="top"==e.options.shaded.orientation?0:"bottom"==e.options.shaded.orientation?s:Math.min(Math.max(0,e.zeroPosition),s),o="group"==e.options.shaded.orientation&&null!=i&&null!=i?"M"+t[0][0]+","+t[0][1]+" "+this.serializePath(t,a,!1)+" L"+i[i.length-1][0]+","+i[i.length-1][1]+" "+this.serializePath(i,a,!0)+i[0][0]+","+i[0][1]+" Z":"M"+t[0][0]+","+t[0][1]+" "+this.serializePath(t,a,!1)+" V"+l+" H"+t[0][0]+" Z",r.setAttributeNS(null,"class",e.className+" vis-fill"),void 0!==e.options.shaded.style&&r.setAttributeNS(null,"style",e.options.shaded.style),r.setAttributeNS(null,"d",o)}},ZD.draw=function(t,e,i){if(null!=t&&null!=t){var n=oi("path",i.svgElements,i.svg);n.setAttributeNS(null,"class",e.className),void 0!==e.style&&n.setAttributeNS(null,"style",e.style);var o="L";1==e.options.interpolation.enabled&&(o="C"),n.setAttributeNS(null,"d","M"+t[0][0]+","+t[0][1]+" "+this.serializePath(t,o,!1))}},ZD.serializePath=function(t,e,i){if(t.length<2)return"";var n,o=e;if(i)for(n=t.length-2;n>0;n--)o+=t[n][0]+","+t[n][1]+" ";else for(n=1;n<t.length;n++)o+=t[n][0]+","+t[n][1]+" ";return o},ZD._catmullRomUniform=function(t){var e,i,n,o,s,r,a=[];a.push([Math.round(t[0].screen_x),Math.round(t[0].screen_y)]);for(var l=1/6,h=t.length,d=0;d<h-1;d++)e=0==d?t[0]:t[d-1],i=t[d],n=t[d+1],o=d+2<h?t[d+2]:n,s={screen_x:(-e.screen_x+6*i.screen_x+n.screen_x)*l,screen_y:(-e.screen_y+6*i.screen_y+n.screen_y)*l},r={screen_x:(i.screen_x+6*n.screen_x-o.screen_x)*l,screen_y:(i.screen_y+6*n.screen_y-o.screen_y)*l},a.push([s.screen_x,s.screen_y]),a.push([r.screen_x,r.screen_y]),a.push([n.screen_x,n.screen_y]);return a},ZD._catmullRom=function(t,e){var i=e.options.interpolation.alpha;if(0==i||void 0===i)return this._catmullRomUniform(t);var n,o,s,r,a,l,h,d,c,u,p,m,f,g,v,b,y,_,w,x=[];x.push([Math.round(t[0].screen_x),Math.round(t[0].screen_y)]);for(var k=t.length,D=0;D<k-1;D++)n=0==D?t[0]:t[D-1],o=t[D],s=t[D+1],r=D+2<k?t[D+2]:s,h=Math.sqrt(Math.pow(n.screen_x-o.screen_x,2)+Math.pow(n.screen_y-o.screen_y,2)),d=Math.sqrt(Math.pow(o.screen_x-s.screen_x,2)+Math.pow(o.screen_y-s.screen_y,2)),c=Math.sqrt(Math.pow(s.screen_x-r.screen_x,2)+Math.pow(s.screen_y-r.screen_y,2)),g=Math.pow(c,i),b=Math.pow(c,2*i),v=Math.pow(d,i),y=Math.pow(d,2*i),w=Math.pow(h,i),u=2*(_=Math.pow(h,2*i))+3*w*v+y,p=2*b+3*g*v+y,(m=3*w*(w+v))>0&&(m=1/m),(f=3*g*(g+v))>0&&(f=1/f),a={screen_x:(-y*n.screen_x+u*o.screen_x+_*s.screen_x)*m,screen_y:(-y*n.screen_y+u*o.screen_y+_*s.screen_y)*m},l={screen_x:(b*o.screen_x+p*s.screen_x-y*r.screen_x)*f,screen_y:(b*o.screen_y+p*s.screen_y-y*r.screen_y)*f},0==a.screen_x&&0==a.screen_y&&(a=o),0==l.screen_x&&0==l.screen_y&&(l=s),x.push([a.screen_x,a.screen_y]),x.push([l.screen_x,l.screen_y]),x.push([s.screen_x,s.screen_y]);return x},ZD._linear=function(t){for(var e=[],i=0;i<t.length;i++)e.push([t[i].screen_x,t[i].screen_y]);return e},KD.prototype.setItems=function(t){null!=t?(this.itemsData=t,1==nv(this.options)&&of.insertSort(this.itemsData,function(t,e){return t.x>e.x?1:-1})):this.itemsData=[]},KD.prototype.getItems=function(){return this.itemsData},KD.prototype.setZeroPosition=function(t){this.zeroPosition=t},KD.prototype.setOptions=function(t){if(void 0!==t){of.selectiveDeepExtend(["sampling","style","sort","yAxisOrientation","barChart","zIndex","excludeFromStacking","excludeFromLegend"],this.options,t),"function"==typeof t.drawPoints&&(t.drawPoints={onRender:t.drawPoints}),of.mergeOptions(this.options,t,"interpolation"),of.mergeOptions(this.options,t,"drawPoints"),of.mergeOptions(this.options,t,"shaded"),t.interpolation&&"object"==typeof t.interpolation&&t.interpolation.parametrization&&("uniform"==t.interpolation.parametrization?this.options.interpolation.alpha=0:"chordal"==t.interpolation.parametrization?this.options.interpolation.alpha=1:(this.options.interpolation.parametrization="centripetal",this.options.interpolation.alpha=.5))}},KD.prototype.update=function(t){this.group=t,this.content=t.content||"graph",this.className=t.className||this.className||"vis-graph-group"+this.groupsUsingDefaultStyles[0]%10,this.visible=void 0===t.visible||t.visible,this.style=t.style,this.setOptions(t.options)},KD.prototype.getLegend=function(t,e,i,n,o){null!=i&&null!=i||(i={svg:document.createElementNS("http://www.w3.org/2000/svg","svg"),svgElements:{},options:this.options,groups:[this]});switch(null!=n&&null!=n||(n=0),null!=o&&null!=o||(o=.5*e),this.options.style){case"line":ZD.drawIcon(this,n,o,t,e,i);break;case"points":case"point":UD.drawIcon(this,n,o,t,e,i);break;case"bar":qD.drawIcon(this,n,o,t,e,i)}return{icon:i.svg,label:this.content,orientation:this.options.yAxisOrientation}},KD.prototype.getYRange=function(t){for(var e=t[0].y,i=t[0].y,n=0;n<t.length;n++)e=e>t[n].y?t[n].y:e,i=i<t[n].y?t[n].y:i;return{min:e,max:i,yAxisOrientation:this.options.yAxisOrientation}},$D.prototype=new mg,$D.prototype.clear=function(){this.groups={},this.amountOfGroups=0},$D.prototype.addGroup=function(t,e){1!=e.options.excludeFromLegend&&(this.groups.hasOwnProperty(t)||(this.groups[t]=e),this.amountOfGroups+=1)},$D.prototype.updateGroup=function(t,e){this.groups[t]=e},$D.prototype.removeGroup=function(t){this.groups.hasOwnProperty(t)&&(delete this.groups[t],this.amountOfGroups-=1)},$D.prototype._create=function(){this.dom.frame=document.createElement("div"),this.dom.frame.className="vis-legend",this.dom.frame.style.position="absolute",this.dom.frame.style.top="10px",this.dom.frame.style.display="block",this.dom.textArea=document.createElement("div"),this.dom.textArea.className="vis-legend-text",this.dom.textArea.style.position="relative",this.dom.textArea.style.top="0px",this.svg=document.createElementNS("http://www.w3.org/2000/svg","svg"),this.svg.style.position="absolute",this.svg.style.top="0px",this.svg.style.width=this.options.iconSize+5+"px",this.svg.style.height="100%",this.dom.frame.appendChild(this.svg),this.dom.frame.appendChild(this.dom.textArea)},$D.prototype.hide=function(){this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame)},$D.prototype.show=function(){this.dom.frame.parentNode||this.body.dom.center.appendChild(this.dom.frame)},$D.prototype.setOptions=function(t){of.selectiveDeepExtend(["enabled","orientation","icons","left","right"],this.options,t)},$D.prototype.redraw=function(){var t=0,e=fm(this.groups);nv(e).call(e,function(t,e){return t<e?-1:1});for(var i=0;i<e.length;i++){var n=e[i];1!=this.groups[n].visible||void 0!==this.linegraphOptions.visibility[n]&&1!=this.linegraphOptions.visibility[n]||t++}if(0==this.options[this.side].visible||0==this.amountOfGroups||0==this.options.enabled||0==t)this.hide();else{if(this.show(),"top-left"==this.options[this.side].position||"bottom-left"==this.options[this.side].position?(this.dom.frame.style.left="4px",this.dom.frame.style.textAlign="left",this.dom.textArea.style.textAlign="left",this.dom.textArea.style.left=this.options.iconSize+15+"px",this.dom.textArea.style.right="",this.svg.style.left="0px",this.svg.style.right=""):(this.dom.frame.style.right="4px",this.dom.frame.style.textAlign="right",this.dom.textArea.style.textAlign="right",this.dom.textArea.style.right=this.options.iconSize+15+"px",this.dom.textArea.style.left="",this.svg.style.right="0px",this.svg.style.left=""),"top-left"==this.options[this.side].position||"top-right"==this.options[this.side].position)this.dom.frame.style.top=4-Number(this.body.dom.center.style.top.replace("px",""))+"px",this.dom.frame.style.bottom="";else{var o=this.body.domProps.center.height-this.body.domProps.centerContainer.height;this.dom.frame.style.bottom=4+o+Number(this.body.dom.center.style.top.replace("px",""))+"px",this.dom.frame.style.top=""}0==this.options.icons?(this.dom.frame.style.width=this.dom.textArea.offsetWidth+10+"px",this.dom.textArea.style.right="",this.dom.textArea.style.left="",this.svg.style.width="0px"):(this.dom.frame.style.width=this.options.iconSize+15+this.dom.textArea.offsetWidth+10+"px",this.drawLegendIcons());var s="";for(i=0;i<e.length;i++)n=e[i],1!=this.groups[n].visible||void 0!==this.linegraphOptions.visibility[n]&&1!=this.linegraphOptions.visibility[n]||(s+=this.groups[n].content+"<br />");this.dom.textArea.innerHTML=of.xss(s),this.dom.textArea.style.lineHeight=.75*this.options.iconSize+this.options.iconSpacing+"px"}},$D.prototype.drawLegendIcons=function(){if(this.dom.frame.parentNode){var t=fm(this.groups);nv(t).call(t,function(t,e){return t<e?-1:1}),ni(this.svgElements);var e=window.getComputedStyle(this.dom.frame).paddingTop,i=Number(e.replace("px","")),n=i,o=this.options.iconSize,s=.75*this.options.iconSize,r=i+.5*s+3;this.svg.style.width=o+5+i+"px";for(var a=0;a<t.length;a++){var l=t[a];1!=this.groups[l].visible||void 0!==this.linegraphOptions.visibility[l]&&1!=this.linegraphOptions.visibility[l]||(this.groups[l].getLegend(o,s,this.framework,n,r),r+=s+this.options.iconSpacing)}}};var JD="__ungrouped__";function QD(t,e){this.id=mi(),this.body=t,this.defaultOptions={yAxisOrientation:"left",defaultGroup:"default",sort:!0,sampling:!0,stack:!1,graphHeight:"400px",shaded:{enabled:!1,orientation:"bottom"},style:"line",barChart:{width:50,sideBySide:!1,align:"center"},interpolation:{enabled:!0,parametrization:"centripetal",alpha:.5},drawPoints:{enabled:!0,size:6,style:"square"},dataAxis:{},legend:{},groups:{visibility:{}}},this.options=of.extend({},this.defaultOptions),this.dom={},this.props={},this.hammer=null,this.groups={},this.abortedGraphUpdate=!1,this.updateSVGheight=!1,this.updateSVGheightOnResize=!1,this.forceGraphUpdate=!0;var i=this;this.itemsData=null,this.groupsData=null,this.itemListeners={add:function(t,e,n){i._onAdd(e.items)},update:function(t,e,n){i._onUpdate(e.items)},remove:function(t,e,n){i._onRemove(e.items)}},this.groupListeners={add:function(t,e,n){i._onAddGroups(e.items)},update:function(t,e,n){i._onUpdateGroups(e.items)},remove:function(t,e,n){i._onRemoveGroups(e.items)}},this.items={},this.selection=[],this.lastStart=this.body.range.start,this.touchParams={},this.svgElements={},this.setOptions(e),this.groupsUsingDefaultStyles=[0],this.body.emitter.on("rangechanged",function(){i.svg.style.left=of.option.asSize(-i.props.width),i.forceGraphUpdate=!0,i.redraw.call(i)}),this._create(),this.framework={svg:this.svg,svgElements:this.svgElements,options:this.options,groups:this.groups}}QD.prototype=new mg,QD.prototype._create=function(){var t=document.createElement("div");t.className="vis-line-graph",this.dom.frame=t,this.svg=document.createElementNS("http://www.w3.org/2000/svg","svg"),this.svg.style.position="relative",this.svg.style.height=(""+this.options.graphHeight).replace("px","")+"px",this.svg.style.display="block",t.appendChild(this.svg),this.options.dataAxis.orientation="left",this.yAxisLeft=new VD(this.body,this.options.dataAxis,this.svg,this.options.groups),this.options.dataAxis.orientation="right",this.yAxisRight=new VD(this.body,this.options.dataAxis,this.svg,this.options.groups),delete this.options.dataAxis.orientation,this.legendLeft=new $D(this.body,this.options.legend,"left",this.options.groups),this.legendRight=new $D(this.body,this.options.legend,"right",this.options.groups),this.show()},QD.prototype.setOptions=function(t){if(t){void 0===t.graphHeight&&void 0!==t.height?(this.updateSVGheight=!0,this.updateSVGheightOnResize=!0):void 0!==this.body.domProps.centerContainer.height&&void 0!==t.graphHeight&&Nb((t.graphHeight+"").replace("px",""))<this.body.domProps.centerContainer.height&&(this.updateSVGheight=!0),of.selectiveDeepExtend(["sampling","defaultGroup","stack","height","graphHeight","yAxisOrientation","style","barChart","dataAxis","sort","groups"],this.options,t),of.mergeOptions(this.options,t,"interpolation"),of.mergeOptions(this.options,t,"drawPoints"),of.mergeOptions(this.options,t,"shaded"),of.mergeOptions(this.options,t,"legend"),t.interpolation&&"object"==typeof t.interpolation&&t.interpolation.parametrization&&("uniform"==t.interpolation.parametrization?this.options.interpolation.alpha=0:"chordal"==t.interpolation.parametrization?this.options.interpolation.alpha=1:(this.options.interpolation.parametrization="centripetal",this.options.interpolation.alpha=.5)),this.yAxisLeft&&void 0!==t.dataAxis&&(this.yAxisLeft.setOptions(this.options.dataAxis),this.yAxisRight.setOptions(this.options.dataAxis)),this.legendLeft&&void 0!==t.legend&&(this.legendLeft.setOptions(this.options.legend),this.legendRight.setOptions(this.options.legend)),this.groups.hasOwnProperty(JD)&&this.groups[JD].setOptions(t)}this.dom.frame&&(this.forceGraphUpdate=!0,this.body.emitter.emit("_change",{queue:!0}))},QD.prototype.hide=function(){this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame)},QD.prototype.show=function(){this.dom.frame.parentNode||this.body.dom.center.appendChild(this.dom.frame)},QD.prototype.setItems=function(t){var e,i=this,n=this.itemsData;if(t){if(!Zm(t))throw new TypeError("Data must implement the interface of DataSet or DataView");this.itemsData=Qm(t)}else this.itemsData=null;if(n&&(ua(of).call(of,this.itemListeners,function(t,e){n.off(e,t)}),n.dispose(),e=n.getIds(),this._onRemove(e)),this.itemsData){var o=this.id;ua(of).call(of,this.itemListeners,function(t,e){i.itemsData.on(e,t,o)}),e=this.itemsData.getIds(),this._onAdd(e)}},QD.prototype.setGroups=function(t){var e,i=this;if(this.groupsData){ua(of).call(of,this.groupListeners,function(t,e){i.groupsData.off(e,t)}),e=this.groupsData.getIds(),this.groupsData=null;for(var n=0;n<e.length;n++)this._removeGroup(e[n])}if(t){if(!Zm(t))throw new TypeError("Data must implement the interface of DataSet or DataView");this.groupsData=t}else this.groupsData=null;if(this.groupsData){var o=this.id;ua(of).call(of,this.groupListeners,function(t,e){i.groupsData.on(e,t,o)}),e=this.groupsData.getIds(),this._onAddGroups(e)}},QD.prototype._onUpdate=function(t){this._updateAllGroupData(t)},QD.prototype._onAdd=function(t){this._onUpdate(t)},QD.prototype._onRemove=function(t){this._onUpdate(t)},QD.prototype._onUpdateGroups=function(t){this._updateAllGroupData(null,t)},QD.prototype._onAddGroups=function(t){this._onUpdateGroups(t)},QD.prototype._onRemoveGroups=function(t){for(var e=0;e<t.length;e++)this._removeGroup(t[e]);this.forceGraphUpdate=!0,this.body.emitter.emit("_change",{queue:!0})},QD.prototype._removeGroup=function(t){this.groups.hasOwnProperty(t)&&("right"==this.groups[t].options.yAxisOrientation?(this.yAxisRight.removeGroup(t),this.legendRight.removeGroup(t),this.legendRight.redraw()):(this.yAxisLeft.removeGroup(t),this.legendLeft.removeGroup(t),this.legendLeft.redraw()),delete this.groups[t])},QD.prototype._updateGroup=function(t,e){this.groups.hasOwnProperty(e)?(this.groups[e].update(t),"right"==this.groups[e].options.yAxisOrientation?(this.yAxisRight.updateGroup(e,this.groups[e]),this.legendRight.updateGroup(e,this.groups[e]),this.yAxisLeft.removeGroup(e),this.legendLeft.removeGroup(e)):(this.yAxisLeft.updateGroup(e,this.groups[e]),this.legendLeft.updateGroup(e,this.groups[e]),this.yAxisRight.removeGroup(e),this.legendRight.removeGroup(e))):(this.groups[e]=new KD(t,e,this.options,this.groupsUsingDefaultStyles),"right"==this.groups[e].options.yAxisOrientation?(this.yAxisRight.addGroup(e,this.groups[e]),this.legendRight.addGroup(e,this.groups[e])):(this.yAxisLeft.addGroup(e,this.groups[e]),this.legendLeft.addGroup(e,this.groups[e]))),this.legendLeft.redraw(),this.legendRight.redraw()},QD.prototype._updateAllGroupData=function(t,e){if(null!=this.itemsData){var i={},n=this.itemsData.get(),o=this.itemsData.idProp,s={};t&&Zp(t).call(t,function(t){s[t]=t});for(var r={},a=0;a<n.length;a++){var l=n[a],h=l.group;null==h&&(h=JD),r.hasOwnProperty(h)?r[h]++:r[h]=1}var d={};if(!e&&t)for(h in this.groups)if(this.groups.hasOwnProperty(h)){var c=(f=this.groups[h]).getItems();i[h]=Th(c).call(c,function(t){return d[t[o]]=t[o],t[o]!==s[t[o]]});var u=r[h];r[h]-=i[h].length,i[h].length<u&&(i[h][u-1]={})}for(a=0;a<n.length;a++)if(null==(h=(l=n[a]).group)&&(h=JD),e||!t||l[o]===s[l[o]]||!d.hasOwnProperty(l[o])){i.hasOwnProperty(h)||(i[h]=new Array(r[h]));var p=of.bridgeObject(l);p.x=of.convert(l.x,"Date"),p.end=of.convert(l.end,"Date"),p.orginalY=l.y,p.y=Number(l.y),p[o]=l[o];var m=i[h].length-r[h]--;i[h][m]=p}for(h in this.groups)this.groups.hasOwnProperty(h)&&(i.hasOwnProperty(h)||(i[h]=new Array(0)));for(h in i)if(i.hasOwnProperty(h))if(0==i[h].length)this.groups.hasOwnProperty(h)&&this._removeGroup(h);else{var f=void 0;null!=this.groupsData&&(f=this.groupsData.get(h)),null==f&&(f={id:h,content:this.options.defaultGroup+h}),this._updateGroup(f,h),this.groups[h].setItems(i[h])}this.forceGraphUpdate=!0,this.body.emitter.emit("_change",{queue:!0})}},QD.prototype.redraw=function(){var t=!1;this.props.width=this.dom.frame.offsetWidth,this.props.height=this.body.domProps.centerContainer.height-this.body.domProps.border.top-this.body.domProps.border.bottom,t=this._isResized()||t;var e,i=this.body.range.end-this.body.range.start,n=i!=this.lastVisibleInterval;(this.lastVisibleInterval=i,1==t)&&(this.svg.style.width=of.option.asSize(3*this.props.width),this.svg.style.left=of.option.asSize(-this.props.width),-1==Bv(e=this.options.height+"").call(e,"%")&&1!=this.updateSVGheightOnResize||(this.updateSVGheight=!0));if(1==this.updateSVGheight?(this.options.graphHeight!=this.props.height+"px"&&(this.options.graphHeight=this.props.height+"px",this.svg.style.height=this.props.height+"px"),this.updateSVGheight=!1):this.svg.style.height=(""+this.options.graphHeight).replace("px","")+"px",1==t||1==n||1==this.abortedGraphUpdate||1==this.forceGraphUpdate)t=this._updateGraph()||t,this.forceGraphUpdate=!1,this.lastStart=this.body.range.start,this.svg.style.left=-this.props.width+"px";else if(0!=this.lastStart){var o=this.body.range.start-this.lastStart,s=this.body.range.end-this.body.range.start;if(0!=this.props.width){var r=o*(this.props.width/s);this.svg.style.left=-this.props.width-r+"px"}}return this.legendLeft.redraw(),this.legendRight.redraw(),t},QD.prototype._getSortedGroupIds=function(){var t=[];for(var e in this.groups)if(this.groups.hasOwnProperty(e)){var i=this.groups[e];1!=i.visible||void 0!==this.options.groups.visibility[e]&&1!=this.options.groups.visibility[e]||t.push({id:e,zIndex:i.options.zIndex})}of.insertSort(t,function(t,e){var i=t.zIndex,n=e.zIndex;return void 0===i&&(i=0),void 0===n&&(n=0),i==n?0:i<n?-1:1});for(var n=new Array(t.length),o=0;o<t.length;o++)n[o]=t[o].id;return n},QD.prototype._updateGraph=function(){if(ei(this.svgElements),0!=this.props.width&&null!=this.itemsData){var t,e,i={},n=this.body.util.toGlobalTime(-this.body.domProps.root.width),o=this.body.util.toGlobalTime(2*this.body.domProps.root.width),s=this._getSortedGroupIds();if(s.length>0){var r={};for(this._getRelevantData(s,r,n,o),this._applySampling(s,r),e=0;e<s.length;e++)this._convertXcoordinates(r[s[e]]);if(this._getYRanges(s,r,i),1==this._updateYAxis(s,i))return ii(this.svgElements),this.abortedGraphUpdate=!0,!0;this.abortedGraphUpdate=!1;var a=void 0;for(e=0;e<s.length;e++)t=this.groups[s[e]],!0===this.options.stack&&"line"===this.options.style&&(null!=t.options.excludeFromStacking&&t.options.excludeFromStacking||(null!=a&&(this._stack(r[t.id],r[a.id]),1==t.options.shaded.enabled&&"group"!==t.options.shaded.orientation&&("top"==t.options.shaded.orientation&&"group"!==a.options.shaded.orientation?(a.options.shaded.orientation="group",a.options.shaded.groupId=t.id):(t.options.shaded.orientation="group",t.options.shaded.groupId=a.id))),a=t)),this._convertYcoordinates(r[s[e]],t);var l={};for(e=0;e<s.length;e++)if("line"===(t=this.groups[s[e]]).options.style&&1==t.options.shaded.enabled){var h=r[s[e]];if(null==h||0==h.length)continue;if(l.hasOwnProperty(s[e])||(l[s[e]]=ZD.calcPath(h,t)),"group"===t.options.shaded.orientation){var d=t.options.shaded.groupId;if(-1===Bv(s).call(s,d)){console.log(t.id+": Unknown shading group target given:"+d);continue}l.hasOwnProperty(d)||(l[d]=ZD.calcPath(r[d],this.groups[d])),ZD.drawShading(l[s[e]],t,l[d],this.framework)}else ZD.drawShading(l[s[e]],t,void 0,this.framework)}for(qD.draw(s,r,this.framework),e=0;e<s.length;e++)if(t=this.groups[s[e]],r[s[e]].length>0)switch(t.options.style){case"line":l.hasOwnProperty(s[e])||(l[s[e]]=ZD.calcPath(r[s[e]],t)),ZD.draw(l[s[e]],t,this.framework);case"point":case"points":"point"!=t.options.style&&"points"!=t.options.style&&1!=t.options.drawPoints.enabled||UD.draw(r[s[e]],t,this.framework)}}}return ii(this.svgElements),!1},QD.prototype._stack=function(t,e){var i,n,o,s,r;i=0;for(var a=0;a<t.length;a++){s=void 0,r=void 0;for(var l=i;l<e.length;l++){if(e[l].x===t[a].x){s=e[l],r=e[l],i=l;break}if(e[l].x>t[a].x){r=e[l],s=0==l?r:e[l-1],i=l;break}}void 0===r&&(s=e[e.length-1],r=e[e.length-1]),n=r.x-s.x,o=r.y-s.y,t[a].y=0==n?t[a].orginalY+r.y:t[a].orginalY+o/n*(t[a].x-s.x)+s.y}},QD.prototype._getRelevantData=function(t,e,i,n){var o,s,r,a;if(t.length>0)for(s=0;s<t.length;s++){var l=(o=this.groups[t[s]]).getItems();if(1==nv(o.options)){var h=function(t,e){return t.getTime()==e.getTime()?0:t<e?-1:1},d=Math.max(0,of.binarySearchValue(l,i,"x","before",h)),c=Math.min(l.length,of.binarySearchValue(l,n,"x","after",h)+1);c<=0&&(c=l.length);var u=new Array(c-d);for(r=d;r<c;r++)a=o.itemsData[r],u[r-d]=a;e[t[s]]=u}else e[t[s]]=o.itemsData}},QD.prototype._applySampling=function(t,e){if(t.length>0)for(var i=0;i<t.length;i++)if(1==this.groups[t[i]].options.sampling){var n=e[t[i]];if(n.length>0){var o,s=n.length,r=s/(this.body.util.toGlobalScreen(n[n.length-1].x)-this.body.util.toGlobalScreen(n[0].x));o=Math.min(Math.ceil(.2*s),Math.max(1,Math.round(r)));for(var a=new Array(s),l=0;l<s;l+=o){a[Math.round(l/o)]=n[l]}e[t[i]]=sb(a).call(a,0,Math.round(s/o))}}},QD.prototype._getYRanges=function(t,e,i){var n,o,s,r,a=[],l=[];if(t.length>0){for(s=0;s<t.length;s++)n=e[t[s]],r=this.groups[t[s]].options,n.length>0&&(o=this.groups[t[s]],!0===r.stack&&"bar"===r.style?"left"===r.yAxisOrientation?a=Of(a).call(a,n):l=Of(l).call(l,n):i[t[s]]=o.getYRange(n,t[s]));qD.getStackedYRange(a,i,t,"__barStackLeft","left"),qD.getStackedYRange(l,i,t,"__barStackRight","right")}},QD.prototype._updateYAxis=function(t,e){var i,n,o=!1,s=!1,r=!1,a=1e9,l=1e9,h=-1e9,d=-1e9;if(t.length>0){for(var c=0;c<t.length;c++){var u=this.groups[t[c]];u&&"right"!=u.options.yAxisOrientation?(s=!0,a=1e9,h=-1e9):u&&u.options.yAxisOrientation&&(r=!0,l=1e9,d=-1e9)}for(c=0;c<t.length;c++)e.hasOwnProperty(t[c])&&!0!==e[t[c]].ignore&&(i=e[t[c]].min,n=e[t[c]].max,"right"!=e[t[c]].yAxisOrientation?(s=!0,a=a>i?i:a,h=h<n?n:h):(r=!0,l=l>i?i:l,d=d<n?n:d));1==s&&this.yAxisLeft.setRange(a,h),1==r&&this.yAxisRight.setRange(l,d)}o=this._toggleAxisVisiblity(s,this.yAxisLeft)||o,o=this._toggleAxisVisiblity(r,this.yAxisRight)||o,1==r&&1==s?(this.yAxisLeft.drawIcons=!0,this.yAxisRight.drawIcons=!0):(this.yAxisLeft.drawIcons=!1,this.yAxisRight.drawIcons=!1),this.yAxisRight.master=!s,this.yAxisRight.masterAxis=this.yAxisLeft,0==this.yAxisRight.master?(this.yAxisLeft.lineOffset=1==r?this.yAxisRight.width:0,o=this.yAxisLeft.redraw()||o,o=this.yAxisRight.redraw()||o):o=this.yAxisRight.redraw()||o;var p=["__barStackLeft","__barStackRight","__lineStackLeft","__lineStackRight"];for(c=0;c<p.length;c++)-1!=Bv(t).call(t,p[c])&&sb(t).call(t,Bv(t).call(t,p[c]),1);return o},QD.prototype._toggleAxisVisiblity=function(t,e){var i=!1;return 0==t?e.dom.frame.parentNode&&0==e.hidden&&(e.hide(),i=!0):e.dom.frame.parentNode||1!=e.hidden||(e.show(),i=!0),i},QD.prototype._convertXcoordinates=function(t){for(var e=this.body.util.toScreen,i=0;i<t.length;i++)t[i].screen_x=e(t[i].x)+this.props.width,t[i].screen_y=t[i].y,null!=t[i].end?t[i].screen_end=e(t[i].end)+this.props.width:t[i].screen_end=void 0},QD.prototype._convertYcoordinates=function(t,e){var i=this.yAxisLeft,n=Number(this.svg.style.height.replace("px",""));"right"==e.options.yAxisOrientation&&(i=this.yAxisRight);for(var o=0;o<t.length;o++)t[o].screen_y=Math.round(i.convertValue(t[o].y));e.setZeroPosition(Math.min(n,i.convertValue(0)))};let tS="string",eS="boolean",iS="number",nS="date",oS="object",sS="moment",rS={configure:{enabled:{boolean:eS},filter:{boolean:eS,function:"function"},container:{dom:"dom"},__type__:{object:oS,boolean:eS,function:"function"}},alignCurrentTime:{string:tS,undefined:"undefined"},yAxisOrientation:{string:["left","right"]},defaultGroup:{string:tS},sort:{boolean:eS},sampling:{boolean:eS},stack:{boolean:eS},graphHeight:{string:tS,number:iS},shaded:{enabled:{boolean:eS},orientation:{string:["bottom","top","zero","group"]},groupId:{object:oS},__type__:{boolean:eS,object:oS}},style:{string:["line","bar","points"]},barChart:{width:{number:iS},minWidth:{number:iS},sideBySide:{boolean:eS},align:{string:["left","center","right"]},__type__:{object:oS}},interpolation:{enabled:{boolean:eS},parametrization:{string:["centripetal","chordal","uniform"]},alpha:{number:iS},__type__:{object:oS,boolean:eS}},drawPoints:{enabled:{boolean:eS},onRender:{function:"function"},size:{number:iS},style:{string:["square","circle"]},__type__:{object:oS,boolean:eS,function:"function"}},dataAxis:{showMinorLabels:{boolean:eS},showMajorLabels:{boolean:eS},showWeekScale:{boolean:eS},icons:{boolean:eS},width:{string:tS,number:iS},visible:{boolean:eS},alignZeros:{boolean:eS},left:{range:{min:{number:iS,undefined:"undefined"},max:{number:iS,undefined:"undefined"},__type__:{object:oS}},format:{function:"function"},title:{text:{string:tS,number:iS,undefined:"undefined"},style:{string:tS,undefined:"undefined"},__type__:{object:oS}},__type__:{object:oS}},right:{range:{min:{number:iS,undefined:"undefined"},max:{number:iS,undefined:"undefined"},__type__:{object:oS}},format:{function:"function"},title:{text:{string:tS,number:iS,undefined:"undefined"},style:{string:tS,undefined:"undefined"},__type__:{object:oS}},__type__:{object:oS}},__type__:{object:oS}},legend:{enabled:{boolean:eS},icons:{boolean:eS},left:{visible:{boolean:eS},position:{string:["top-right","bottom-right","top-left","bottom-left"]},__type__:{object:oS}},right:{visible:{boolean:eS},position:{string:["top-right","bottom-right","top-left","bottom-left"]},__type__:{object:oS}},__type__:{object:oS,boolean:eS}},groups:{visibility:{any:"any"},__type__:{object:oS}},autoResize:{boolean:eS},throttleRedraw:{number:iS},clickToUse:{boolean:eS},end:{number:iS,date:nS,string:tS,moment:sS},format:{minorLabels:{millisecond:{string:tS,undefined:"undefined"},second:{string:tS,undefined:"undefined"},minute:{string:tS,undefined:"undefined"},hour:{string:tS,undefined:"undefined"},weekday:{string:tS,undefined:"undefined"},day:{string:tS,undefined:"undefined"},week:{string:tS,undefined:"undefined"},month:{string:tS,undefined:"undefined"},quarter:{string:tS,undefined:"undefined"},year:{string:tS,undefined:"undefined"},__type__:{object:oS}},majorLabels:{millisecond:{string:tS,undefined:"undefined"},second:{string:tS,undefined:"undefined"},minute:{string:tS,undefined:"undefined"},hour:{string:tS,undefined:"undefined"},weekday:{string:tS,undefined:"undefined"},day:{string:tS,undefined:"undefined"},week:{string:tS,undefined:"undefined"},month:{string:tS,undefined:"undefined"},quarter:{string:tS,undefined:"undefined"},year:{string:tS,undefined:"undefined"},__type__:{object:oS}},__type__:{object:oS}},moment:{function:"function"},height:{string:tS,number:iS},hiddenDates:{start:{date:nS,number:iS,string:tS,moment:sS},end:{date:nS,number:iS,string:tS,moment:sS},repeat:{string:tS},__type__:{object:oS,array:"array"}},locale:{string:tS},locales:{__any__:{any:"any"},__type__:{object:oS}},max:{date:nS,number:iS,string:tS,moment:sS},maxHeight:{number:iS,string:tS},maxMinorChars:{number:iS},min:{date:nS,number:iS,string:tS,moment:sS},minHeight:{number:iS,string:tS},moveable:{boolean:eS},multiselect:{boolean:eS},orientation:{string:tS},showCurrentTime:{boolean:eS},showMajorLabels:{boolean:eS},showMinorLabels:{boolean:eS},showWeekScale:{boolean:eS},snap:{function:"function",null:"null"},start:{date:nS,number:iS,string:tS,moment:sS},timeAxis:{scale:{string:tS,undefined:"undefined"},step:{number:iS,undefined:"undefined"},__type__:{object:oS}},width:{string:tS,number:iS},zoomable:{boolean:eS},zoomKey:{string:["ctrlKey","altKey","metaKey",""]},zoomMax:{number:iS},zoomMin:{number:iS},zIndex:{number:iS},__type__:{object:oS}},aS={global:{alignCurrentTime:["none","year","month","quarter","week","isoWeek","day","date","hour","minute","second"],sort:!0,sampling:!0,stack:!1,shaded:{enabled:!1,orientation:["zero","top","bottom","group"]},style:["line","bar","points"],barChart:{width:[50,5,100,5],minWidth:[50,5,100,5],sideBySide:!1,align:["left","center","right"]},interpolation:{enabled:!0,parametrization:["centripetal","chordal","uniform"]},drawPoints:{enabled:!0,size:[6,2,30,1],style:["square","circle"]},dataAxis:{showMinorLabels:!0,showMajorLabels:!0,showWeekScale:!1,icons:!1,width:[40,0,200,1],visible:!0,alignZeros:!0,left:{title:{text:"",style:""}},right:{title:{text:"",style:""}}},legend:{enabled:!1,icons:!0,left:{visible:!0,position:["top-right","bottom-right","top-left","bottom-left"]},right:{visible:!0,position:["top-right","bottom-right","top-left","bottom-left"]}},autoResize:!0,clickToUse:!1,end:"",format:{minorLabels:{millisecond:"SSS",second:"s",minute:"HH:mm",hour:"HH:mm",weekday:"ddd D",day:"D",week:"w",month:"MMM",quarter:"[Q]Q",year:"YYYY"},majorLabels:{millisecond:"HH:mm:ss",second:"D MMMM HH:mm",minute:"ddd D MMMM",hour:"ddd D MMMM",weekday:"MMMM YYYY",day:"MMMM YYYY",week:"MMMM YYYY",month:"YYYY",quarter:"YYYY",year:""}},height:"",locale:"",max:"",maxHeight:"",maxMinorChars:[7,0,20,1],min:"",minHeight:"",moveable:!0,orientation:["both","bottom","top"],showCurrentTime:!1,showMajorLabels:!0,showMinorLabels:!0,showWeekScale:!1,start:"",width:"100%",zoomable:!0,zoomKey:["ctrlKey","altKey","metaKey",""],zoomMax:[31536e10,10,31536e10,1],zoomMin:[10,10,31536e10,1],zIndex:0}};function lS(t,e,i,n){var o,s,r,a,l,h,d;if(!Rs(i)&&!Zm(i)&&i instanceof Object){var c=n;n=i,i=c}n&&n.throttleRedraw&&console.warn('Graph2d option "throttleRedraw" is DEPRICATED and no longer supported. It will be removed in the next MAJOR release.');var u=this;this.defaultOptions={start:null,end:null,autoResize:!0,orientation:{axis:"bottom",item:"bottom"},moment:ma,width:null,height:null,maxHeight:null,minHeight:null},this.options=of.deepExtend({},this.defaultOptions),this._create(t),this.components=[],this.body={dom:this.dom,domProps:this.props,emitter:{on:Js(o=this.on).call(o,this),off:Js(s=this.off).call(s,this),emit:Js(r=this.emit).call(r,this)},hiddenDates:[],util:{getScale:()=>u.timeAxis.step.scale,getStep:()=>u.timeAxis.step.step,toScreen:Js(a=u._toScreen).call(a,u),toGlobalScreen:Js(l=u._toGlobalScreen).call(l,u),toTime:Js(h=u._toTime).call(h,u),toGlobalTime:Js(d=u._toGlobalTime).call(d,u)}},this.range=new bv(this.body),this.components.push(this.range),this.body.range=this.range,this.timeAxis=new Fb(this.body),this.components.push(this.timeAxis),this.currentTime=new ny(this.body),this.components.push(this.currentTime),this.linegraph=new QD(this.body),this.components.push(this.linegraph),this.itemsData=null,this.groupsData=null,this.on("tap",function(t){u.emit("click",u.getEventProperties(t))}),this.on("doubletap",function(t){u.emit("doubleClick",u.getEventProperties(t))}),this.dom.root.oncontextmenu=function(t){u.emit("contextmenu",u.getEventProperties(t))},this.initialFitDone=!1,this.on("changed",function(){if(null!=u.itemsData){if(!u.initialFitDone&&!u.options.rollingMode)if(u.initialFitDone=!0,null!=u.options.start||null!=u.options.end){if(null==u.options.start||null==u.options.end)var t=u.getItemRange();var e=null!=u.options.start?u.options.start:t.min,i=null!=u.options.end?u.options.end:t.max;u.setWindow(e,i,{animation:!1})}else u.fit({animation:!1});u.initialDrawDone||!u.initialRangeChangeDone&&(u.options.start||u.options.end)&&!u.options.rollingMode||(u.initialDrawDone=!0,u.dom.root.style.visibility="visible",u.dom.loadingScreen.parentNode.removeChild(u.dom.loadingScreen),u.options.onInitialDrawComplete&&vr(()=>u.options.onInitialDrawComplete(),0))}}),n&&this.setOptions(n),i&&this.setGroups(i),e&&this.setItems(e),this._redraw()}lS.prototype=new iy,lS.prototype.setOptions=function(t){!0===dD.validate(t,rS)&&console.log("%cErrors have been found in the supplied options object.",hD),iy.prototype.setOptions.call(this,t)},lS.prototype.setItems=function(t){var e,i=null==this.itemsData;if(e=t?Zm(t)?Qm(t):Qm(new wi(t)):null,this.itemsData&&this.itemsData.dispose(),this.itemsData=e,this.linegraph&&this.linegraph.setItems(null!=e?e.rawDS:null),i)if(null!=this.options.start||null!=this.options.end){var n=null!=this.options.start?this.options.start:null,o=null!=this.options.end?this.options.end:null;this.setWindow(n,o,{animation:!1})}else this.fit({animation:!1})},lS.prototype.setGroups=function(t){var e;e=t?Zm(t)?t:new wi(t):null,this.groupsData=e,this.linegraph.setGroups(e)},lS.prototype.getLegend=function(t,e,i){return void 0===e&&(e=15),void 0===i&&(i=15),void 0!==this.linegraph.groups[t]?this.linegraph.groups[t].getLegend(e,i):"cannot find group:'"+t+"'"},lS.prototype.isGroupVisible=function(t){return void 0!==this.linegraph.groups[t]&&(this.linegraph.groups[t].visible&&(void 0===this.linegraph.options.groups.visibility[t]||1==this.linegraph.options.groups.visibility[t]))},lS.prototype.getDataRange=function(){var t=null,e=null;for(var i in this.linegraph.groups)if(this.linegraph.groups.hasOwnProperty(i)&&1==this.linegraph.groups[i].visible)for(var n=0;n<this.linegraph.groups[i].itemsData.length;n++){var o=this.linegraph.groups[i].itemsData[n],s=of.convert(o.x,"Date").valueOf();t=null==t||t>s?s:t,e=null==e||e<s?s:e}return{min:null!=t?new Date(t):null,max:null!=e?new Date(e):null}},lS.prototype.getEventProperties=function(t){var e=t.center?t.center.x:t.clientX,i=t.center?t.center.y:t.clientY,n=e-of.getAbsoluteLeft(this.dom.centerContainer),o=i-of.getAbsoluteTop(this.dom.centerContainer),s=this._toTime(n),r=ey.customTimeFromTarget(t),a=of.getTarget(t),l=null;of.hasParent(a,this.timeAxis.dom.foreground)||this.timeAxis2&&of.hasParent(a,this.timeAxis2.dom.foreground)?l="axis":of.hasParent(a,this.linegraph.yAxisLeft.dom.frame)||of.hasParent(a,this.linegraph.yAxisRight.dom.frame)?l="data-axis":of.hasParent(a,this.linegraph.legendLeft.dom.frame)||of.hasParent(a,this.linegraph.legendRight.dom.frame)?l="legend":null!=r?l="custom-time":of.hasParent(a,this.currentTime.bar)?l="current-time":of.hasParent(a,this.dom.center)&&(l="background");var h=[],d=this.linegraph.yAxisLeft,c=this.linegraph.yAxisRight;return!d.hidden&&this.itemsData.length>0&&h.push(d.screenToValue(o)),!c.hidden&&this.itemsData.length>0&&h.push(c.screenToValue(o)),{event:t,customTime:r?r.options.id:null,what:l,pageX:t.srcEvent?t.srcEvent.pageX:t.pageX,pageY:t.srcEvent?t.srcEvent.pageY:t.pageY,x:n,y:o,time:s,value:h}},lS.prototype._createConfigurator=function(){return new jD(this,this.dom.container,aS)};const hS=li();ma.locale(hS);const dS={Core:iy,DateUtil:vv,Range:bv,stack:Pk,TimeStep:Lb,components:{items:{Item:Lk,BackgroundItem:jk,BoxItem:Fk,ClusterItem:eD,PointItem:Rk,RangeItem:Yk},BackgroundGroup:Nk,Component:mg,CurrentTime:ny,CustomTime:ey,DataAxis:VD,DataScale:BD,GraphGroup:KD,Group:Ik,ItemSet:rD,Legend:$D,LineGraph:QD,TimeAxis:Fb}};export{hi as DOMutil,wi as DataSet,xi as DataView,lS as Graph2d,yb as Hammer,bi as Queue,HD as Timeline,Yb as keycharm,ma as moment,dS as timeline,ti as util};
//# sourceMappingURL=vis-timeline-graph2d.min.mjs.map
