import { parseUUID, stringifyUUID } from './parsing';
import { uuid1 } from './uuid1';
import { uuid4 } from './uuid4';
export * from './parsing';
export * from './uuid1';
export * from './uuid4';
/**
 * API properties as used before ES2015 modules and TypeScript.
 */
export interface OldAPIProps {
    /** Generate UUIDv1. */
    v1: typeof uuid1;
    /** Generate UUIDv4. */
    v4: typeof uuid4;
    /** Parse string UUID representation into bytes. */
    parse: typeof parseUUID;
    /** Parse bytes into string UUID representation. */
    unparse: typeof stringifyUUID;
}
/**
 * API as used before ES2015 modules and TypeScript.
 */
export declare type OldAPI = typeof uuid4 & OldAPIProps;
declare const oldAPI: OldAPI;
export default oldAPI;
export { uuid1 as v1, uuid4 as v4, parseUUID as parse, stringifyUUID as unparse };
//# sourceMappingURL=index.d.ts.map