import { Bytes } from './types';
/**
 * Parse a string UUID representation into it's component bytes.
 *
 * @param str - String UUID.
 * @param buf - Buffer to be filled with the bytes.
 * @param offset - Offset from the start of the buffer where the UUID bytes will be saved.
 *
 * @returns An array (or Uint8Array if supplied) of bytes.
 */
export declare function parseUUID(str: string, buf?: Bytes, offset?: number): Bytes;
/**
 * Represent binary UUID into it's string representation.
 *
 * @param buf - Buffer containing UUID bytes.
 * @param offset - Offset from the start of the buffer where the UUID is saved (not needed if the buffer starts with the UUID).
 *
 * @returns String representation of the UUID.
 */
export declare function stringifyUUID(buf: Bytes, offset?: number): string;
//# sourceMappingURL=parsing.d.ts.map