import { Bytes } from './types';
/**
 * UUIDv1 options.
 */
export interface UUID1Options {
    /**
     * Sequence number.
     */
    clockseq?: number;
    /**
     * Time in milliseconds since the Gregorian epoch.
     */
    msecs?: number;
    /**
     * 100-nanoseconds since msecs (if missing it will be simulated using a counter).
     */
    nsecs?: number;
    /**
     * 6 bytes long node id, for example MAC address.
     */
    node?: Bytes;
}
export declare function uuid1(options?: UUID1Options): string;
export declare function uuid1(options: UUID1Options, buf: Bytes, offset?: number): Bytes;
//# sourceMappingURL=uuid1.d.ts.map