import { Bytes } from './types';
/**
 * UUIDv4 options.
 */
export interface UUID4Options {
    /**
     * Random data (16 bytes) to be used instead of generated.
     *
     * **Warning**: the data will be modified and returned.
     */
    random?: Bytes;
    /**
     * Random data (16 bytes) generator to be used instead of default generator.
     *
     * **Warning**: the returned data will be modified and returned.
     */
    rng?: () => Bytes;
}
export declare function uuid4(options: 'binary'): number[];
export declare function uuid4(options?: UUID4Options): string;
export declare function uuid4(options: 'binary' | UUID4Options, buf: Bytes, offset?: number): Bytes;
//# sourceMappingURL=uuid4.d.ts.map