'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var url = require('url');
var fs = require('fs');
var pathe = require('pathe');
var mlly = require('mlly');

const isWindows = process.platform === "win32";
function slash(str) {
  return str.replace(/\\/g, "/");
}
function mergeSlashes(str) {
  return str.replace(/\/\//g, "/");
}
function normalizeRequestId(id, base) {
  if (base && id.startsWith(base))
    id = `/${id.slice(base.length)}`;
  return id.replace(/^\/@id\/__x00__/, "\0").replace(/^\/@id\//, "").replace(/^__vite-browser-external:/, "").replace(/^(node|file):/, "").replace(/^\/+/, "/").replace(/\?v=\w+/, "?").replace(/&v=\w+/, "").replace(/\?t=\w+/, "?").replace(/&t=\w+/, "").replace(/\?import/, "?").replace(/&import/, "").replace(/\?&/, "?").replace(/\?+$/, "");
}
const queryRE = /\?.*$/s;
const hashRE = /#.*$/s;
const cleanUrl = (url) => url.replace(hashRE, "").replace(queryRE, "");
function normalizeModuleId(id) {
  return id.replace(/\\/g, "/").replace(/^\/@fs\//, "/").replace(/^file:\//, "/").replace(/^\/+/, "/");
}
function isPrimitive(v) {
  return v !== Object(v);
}
function pathFromRoot(root, filename) {
  if (mlly.isNodeBuiltin(filename))
    return filename;
  filename = filename.replace(/^\/@fs\//, isWindows ? "" : "/");
  if (!filename.startsWith(root))
    return filename;
  const relativePath = pathe.relative(root, filename);
  const segments = relativePath.split("/");
  const startIndex = segments.findIndex((segment) => segment !== ".." && segment !== ".");
  return `/${segments.slice(startIndex).join("/")}`;
}
function toFilePath(id, root) {
  let absolute = (() => {
    if (id.startsWith("/@fs/"))
      return id.slice(4);
    if (!id.startsWith(root) && id.startsWith("/")) {
      const resolved = pathe.resolve(root, id.slice(1));
      if (fs.existsSync(resolved.replace(/\?.*$/, "")))
        return resolved;
    }
    return id;
  })();
  if (absolute.startsWith("//"))
    absolute = absolute.slice(1);
  return isWindows && absolute.startsWith("/") ? slash(url.fileURLToPath(url.pathToFileURL(absolute.slice(1)).href)) : absolute;
}
function toArray(array) {
  if (array === null || array === void 0)
    array = [];
  if (Array.isArray(array))
    return array;
  return [array];
}

exports.cleanUrl = cleanUrl;
exports.hashRE = hashRE;
exports.isPrimitive = isPrimitive;
exports.isWindows = isWindows;
exports.mergeSlashes = mergeSlashes;
exports.normalizeModuleId = normalizeModuleId;
exports.normalizeRequestId = normalizeRequestId;
exports.pathFromRoot = pathFromRoot;
exports.queryRE = queryRE;
exports.slash = slash;
exports.toArray = toArray;
exports.toFilePath = toFilePath;
