"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var options_exports = {};
__export(options_exports, {
  translateOptions: () => translateOptions
});
module.exports = __toCommonJS(options_exports);
var import_meow = __toESM(require("meow"), 1);
const EXIT_CODE_ERROR = 2;
const translateOptions = (command) => {
  const result = (0, import_meow.default)({
    autoHelp: false,
    autoVersion: false,
    help: `
    Usage: stylelint [input] [options]
    Input: Files(s), glob(s), or nothing to use stdin.
      If an input argument is wrapped in quotation marks, it will be passed to
      globby for cross-platform glob support. node_modules are always ignored.
      You can also pass no input and use stdin, instead.
    Options:
      --config
        Path to a specific configuration file (JSON, YAML, or CommonJS), or the
        name of a module in node_modules that points to one. If no --config
        argument is provided, stylelint will search for configuration files in
        the following places, in this order:
          - a stylelint property in package.json
          - a .stylelintrc file (with or without filename extension:
            .json, .yaml, .yml, and .js are available)
          - a stylelint.config.js file exporting a JS object
        The search will begin in the working directory and move up the directory
        tree until a configuration file is found.
      --config-basedir
        An absolute path to the directory that relative paths defining "extends"
        and "plugins" are *relative to*. Only necessary if these values are
        relative paths.
      --print-config
        Print the configuration for the given path.
      --ignore-path, -i
        Path to a file containing patterns that describe files to ignore. The
        path can be absolute or relative to process.cwd(). By default, stylelint
        looks for .stylelintignore in process.cwd().
      --ignore-pattern, --ip
        Pattern of files to ignore (in addition to those in .stylelintignore)
      --fix
        Automatically fix problems of certain rules.
      --custom-syntax
        Module name or path to a JS file exporting a PostCSS-compatible syntax.
      --stdin
        Accept stdin input even if it is empty.
      --stdin-filename
        A filename to assign stdin input.
      --ignore-disables, --id
        Ignore stylelint-disable comments.
      --disable-default-ignores, --di
        Allow linting of node_modules.
      --cache                       [default: false]
        Store the info about processed files in order to only operate on the
        changed ones the next time you run stylelint. By default, the cache
        is stored in "./.stylelintcache". To adjust this, use --cache-location.
      --cache-location              [default: '.stylelintcache']
        Path to a file or directory to be used for the cache location.
        Default is "./.stylelintcache". If a directory is specified, a cache
        file will be created inside the specified folder, with a name derived
        from a hash of the current working directory.
        If the directory for the cache does not exist, make sure you add a trailing "/"
        on *nix systems or "\\" on Windows. Otherwise the path will be assumed to be a file.
      --formatter, -f               [default: "string"]
        The output formatter: "compact", "json", "tap", "unix" or "verbose"
      --custom-formatter
        Path to a JS file exporting a custom formatting function.
      --quiet, -q
        Only register problems for rules with an "error"-level severity (ignore
        "warning"-level).
      --color
      --no-color
        Force enabling/disabling of color.
      --report-needless-disables, --rd
        Also report errors for stylelint-disable comments that are not blocking a lint warning.
        The process will exit with code ${EXIT_CODE_ERROR} if needless disables are found.
      --report-invalid-scope-disables, --risd
        Report stylelint-disable comments that used for rules that don't exist within the configuration object.
        The process will exit with code ${EXIT_CODE_ERROR} if invalid scope disables are found.
      --report-descriptionless-disables, --rdd
        Report stylelint-disable comments without a description.
        The process will exit with code ${EXIT_CODE_ERROR} if descriptionless disables are found.
      --max-warnings, --mw
        Number of warnings above which the process will exit with code ${EXIT_CODE_ERROR}.
        Useful when setting "defaultSeverity" to "warning" and expecting the
        process to fail on warnings (e.g. CI build).
      --output-file, -o
        Path of file to write report.
      --version, -v
        Show the currently installed version of stylelint.
      --allow-empty-input, --aei
        When glob pattern matches no files, the process will exit without throwing an error.
	`,
    flags: {
      allowEmptyInput: {
        alias: "aei",
        type: "boolean"
      },
      cache: {
        type: "boolean"
      },
      cacheLocation: {
        type: "string"
      },
      color: {
        type: "boolean"
      },
      config: {
        type: "string"
      },
      configBasedir: {
        type: "string"
      },
      customFormatter: {
        type: "string"
      },
      customSyntax: {
        type: "string"
      },
      disableDefaultIgnores: {
        alias: "di",
        type: "boolean"
      },
      fix: {
        type: "boolean"
      },
      formatter: {
        alias: "f",
        default: "json",
        type: "string"
      },
      help: {
        alias: "h",
        type: "boolean"
      },
      ignoreDisables: {
        alias: "id",
        type: "boolean"
      },
      ignorePath: {
        alias: "i",
        type: "string"
      },
      ignorePattern: {
        alias: "ip",
        type: "string",
        isMultiple: true
      },
      maxWarnings: {
        alias: "mw",
        type: "number"
      },
      outputFile: {
        alias: "o",
        type: "string"
      },
      printConfig: {
        type: "boolean"
      },
      quiet: {
        alias: "q",
        type: "boolean"
      },
      reportDescriptionlessDisables: {
        alias: "rdd",
        type: "boolean"
      },
      reportInvalidScopeDisables: {
        alias: "risd",
        type: "boolean"
      },
      reportNeedlessDisables: {
        alias: "rd",
        type: "boolean"
      },
      stdin: {
        type: "boolean"
      },
      stdinFilename: {
        type: "string"
      },
      syntax: {
        alias: "s",
        type: "string"
      },
      version: {
        alias: "v",
        type: "boolean"
      }
    },
    argv: command.split(" ").filter((item) => !!item)
  });
  return {
    ...Object.fromEntries(
      Object.entries(result.flags).filter(
        ([key]) => [
          "files",
          "globbyOptions",
          "cache",
          "cacheLocation",
          "code",
          "codeFilename",
          "config",
          "configFile",
          "configBasedir",
          "cwd",
          "ignoreDisables",
          "ignorePath",
          "ignorePattern",
          "reportDescriptionlessDisables",
          "reportNeedlessDisables",
          "reportInvalidScopeDisables",
          "maxWarnings",
          "customSyntax",
          "formatter",
          "disableDefaultIgnores",
          "fix",
          "allowEmptyInput",
          "quiet"
        ].includes(key)
      )
    ),
    formatter: result.flags.formatter === "string" ? "json" : result.flags.formatter,
    files: result.input[1]
  };
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  translateOptions
});
//# sourceMappingURL=options.js.map